
-- OnShow
function MerchConfigFrame_OnShow(self)
	-- make sure our profile has been loaded
	if ( not MerchConfig_VariablesLoaded ) then -- config not loaded
		MerchConfigFrame:Hide(); -- hide our config pane
		return;
	end
	-- read settings from profile, and change checkbuttons and slider to represent them

	getglobal(self:GetName().."CheckButtonAutoRepair"):SetChecked( MerchConfig[RealmPlayer].MHAutoRepair );		
	getglobal(self:GetName().."CheckButtonAutoVendor"):SetChecked( MerchConfig[RealmPlayer].MHAutoVendor );
	getglobal(self:GetName().."CheckButtonAnnounceRepair"):SetChecked( MerchConfig[RealmPlayer].MHAnnounceRepair );
	getglobal(self:GetName().."CheckButtonVendorList"):SetChecked( MerchConfig[RealmPlayer].MHVendorList );
	getglobal(self:GetName().."CheckButtonVendorTotal"):SetChecked( MerchConfig[RealmPlayer].MHVendorTotal );
	getglobal(self:GetName().."CheckButtonMerchantBags"):SetChecked( MerchConfig[RealmPlayer].MHMerchantBags );
	getglobal(self:GetName().."CheckButtonMailBags"):SetChecked( MerchConfig[RealmPlayer].MHMailBags );
	getglobal(self:GetName().."CheckButtonAuctionBags"):SetChecked( MerchConfig[RealmPlayer].MHAuctionBags );
	getglobal(self:GetName().."CheckButtonBankBags"):SetChecked( MerchConfig[RealmPlayer].MHBankBags );
	getglobal(self:GetName().."CheckButtonGuildBankBags"):SetChecked( MerchConfig[RealmPlayer].MHGuildBankBags );
	getglobal(self:GetName().."CheckButtonGuildBankRepair"):SetChecked( MerchConfig[RealmPlayer].MHGuildBankRepair );
	getglobal(self:GetName().."CheckButtonTradeBags"):SetChecked( MerchConfig[RealmPlayer].MHTradeBags );
	getglobal(self:GetName().."CheckButtonVendorLimit"):SetChecked( MerchConfig[RealmPlayer].MHVendorLimit );
	getglobal(self:GetName().."SliderDestroyJunk"):SetValue( MerchConfig[RealmPlayer].MHDestroyJunkValue );

	-- Tooltip settings
	MerchConfigFrameCheckButtonAutoRepair.tooltip = format("%s", "|cFFFFFFFFIf checked, this will automatically\nrepair all items when interacting\nwith a repair merchant.");
	MerchConfigFrameCheckButtonAutoVendor.tooltip = format("%s", "|cFFFFFFFFIf checked, this will automatically\nsell all of your junk (grey) items\nand Vendor List items to the vendor.");
	MerchConfigFrameCheckButtonAnnounceRepair.tooltip = format("%s", "|cFFFFFFFFIf checked, this will print the total\ncost of repairs to the chat frame.");
	MerchConfigFrameCheckButtonVendorList.tooltip = format("%s", "|cFFFFFFFFIf checked, this will print a list of\nall items sold and their sale price.");
	MerchConfigFrameCheckButtonVendorTotal.tooltip = format("%s", "|cFFFFFFFFIf checked, this will print a total of the\nnumber of items sold and the overall\nprofit they were sold for.");
	MerchConfigFrameCheckButtonMerchantBags.tooltip = format("%s", "|cFFFFFFFFIf checked, this will open all of your\nbags when you speak to a vendor, and\nclose them when you leave.");
	MerchConfigFrameCheckButtonMailBags.tooltip = format("%s", "|cFFFFFFFFIf checked, this will open all of your\nbags when you use the mailbox, and\nclose them when you leave.");
	MerchConfigFrameCheckButtonAuctionBags.tooltip = format("%s", "|cFFFFFFFFIf checked, this will open all of your\nbags when you speak to an auctioneer,\nand close them when you leave.");
	MerchConfigFrameCheckButtonBankBags.tooltip = format("%s", "|cFFFFFFFFIf checked, this will open all of your\nbags when you access the bank, and\nclose them when you leave.");
	MerchConfigFrameCheckButtonGuildBankBags.tooltip = format("%s", "|cFFFFFFFFIf checked, this will open all of your\nbags when you access the guild bank,\nand close them when you leave.");
	MerchConfigFrameCheckButtonGuildBankRepair.tooltip = format("%s", "|cFFFFFFFFIf checked, this will automatically repair all your\nitems using guild bank funds when you interact with\na repair merchant (if Auto Repair is enabled).");
	MerchConfigFrameCheckButtonTradeBags.tooltip = format("%s", "|cFFFFFFFFIf checked, this will open all of your\nbags when you open trade with another\nplayer, and close them when you finish.");
	MerchConfigFrameCheckButtonVendorLimit.tooltip = format("%s", "|cFFFFFFFFIf checked, this will set the maximum\nnumber of items sold in one transaction\nto 12 (the buyback limit).\n\n|CFF00FF00If this is enabled, you will need to reopen\nthe vendor window to sell the rest\nof your items if you have more than 12.");
	MerchConfigFrameSliderDestroyJunk.tooltip = format("%s", "|cFFFFFFFFSelect the max value of items to be destroyed, anywhere\nbetween 5 Silver and 5 Gold.");
	MerchConfigFrameButtonDestroyJunk.tooltip = format("%s", "|cFFFFFFFFClicking this button will destroy all the junk\nand Vendor List items in your bags up to\nthe value you have selected.\n\n|CFF00FF00NOTE: Items with no sell value will not be destroyed\nunless they are on the Vendor List.");
end


-- OnClick
function MerchConfigOptions_OnClick(self) 
	-- make sure our profile has been loaded
	if ( not MerchConfig_VariablesLoaded ) then -- config not loaded
		MerchConfigOptions:GetParent():Hide(); -- hide our config pane
		return;
	end
	-- read setting out of checkbox and put into profile
	if ( self:GetName() == (self:GetParent():GetName().."CheckButtonAutoRepair" ) ) then
		MerchConfig[RealmPlayer].MHAutoRepair = self:GetChecked(); -- set profile
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonAutoVendor" ) ) then
		MerchConfig[RealmPlayer].MHAutoVendor = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonAnnounceRepair" ) ) then
		MerchConfig[RealmPlayer].MHAnnounceRepair = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonVendorList" ) ) then
		MerchConfig[RealmPlayer].MHVendorList = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonVendorTotal" ) ) then
		MerchConfig[RealmPlayer].MHVendorTotal = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonMerchantBags" ) ) then
		MerchConfig[RealmPlayer].MHMerchantBags = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonMailBags" ) ) then
		MerchConfig[RealmPlayer].MHMailBags = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonAuctionBags" ) ) then
		MerchConfig[RealmPlayer].MHAuctionBags = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonBankBags" ) ) then
		MerchConfig[RealmPlayer].MHBankBags = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonGuildBankBags" ) ) then
		MerchConfig[RealmPlayer].MHGuildBankBags = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonGuildBankRepair" ) ) then
		MerchConfig[RealmPlayer].MHGuildBankRepair = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonTradeBags" ) ) then
		MerchConfig[RealmPlayer].MHTradeBags = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."CheckButtonVendorLimit" ) ) then
		MerchConfig[RealmPlayer].MHVendorLimit = self:GetChecked();
	elseif ( self:GetName() == (self:GetParent():GetName().."SliderDestroyJunk" ) ) then
		MerchConfig[RealmPlayer].MHDestroyJunkValue = self:GetValue();
	end
end

