function MapLevelInfo_locale()

    -------------------------------
    -- Translations

    local L = {
	 ["enUS"] = {
		 ["unknown zone"] = "unknown zone"
		,["Capital City"] = "Capital City"
		,["Sanctuary"]    = "Sanctuary"
		,["Horde"]        = "Horde"
		,["Alliance"]     = "Alliance"
		,["PvP Combat Zone"] = "PvP Combat Zone"
		,["Contested Zone"] = "Contested"
		,["Staging Area"] = "Staging Area"
		,["Worgen only"] = "Worgen only"
		,["Goblin only"] = "Goblin only"
		,["Garrison"] = "Garrison"
		,["MISSING ZONES ERROR"] = "ERROR - one or more missing zones! Please report any missing zones you are given on CURSE.COM MapLevelInfo. Thanks! :)"
	}

	,["deDE"] = {
		 ["unknown zone"] = "unbekannte Zone"
		,["Capital City"] = "Hauptstadt"
		,["Sanctuary"]    = "Sicheres Gebiet"
		,["Horde"]        = "Horde"
		,["Alliance"]     = "Allianz"
		,["PvP Combat Zone"] = "PvP Kampfzone"
		,["Contested Zone"] = "Umkämpft"
		,["Staging Area"] = "Staging Area"
		,["Worgen only"] = "Nur Worgen"
		,["Goblin only"] = "Nur Goblin"
		,["Garrison"] = "Garnison"
		,["MISSING ZONES ERROR"] = "FEHLER - eine oder mehrere fehlende Zonen. Rund um den Zeitpunkt der Veröffentlichung von 'Mists of Pandaria' benötige ich wirklich Hilfe mit den Übersetzungen. Bitte melden Sie fehlende Zonen auf CURSE.COM MapLevelInfo. Danke! :)"
	}

	,["esES"] = {
		 ["unknown zone"] = "desconocidos zona"
		,["Capital City"] = "Ciudad Capital"
		,["Sanctuary"]    = "Santuario"
		,["Horde"]        = "Horda"
		,["Alliance"]     = "Alianza"
		,["PvP Combat Zone"] = "PvP zona de combate"
		,["Contested Zone"] = "En disputa"
		,["Staging Area"] = "Área de ensayo"
		,["Worgen only"] = "Sólo Worgen"
		,["Goblin only"] = "Sólo Goblin"
		,["Garrison"] = "Cuarteles"
		,["MISSING ZONES ERROR"] = "ERROR - una o más zonas que faltan. En la época de la liberación de 'Mists of Pandaria' Estoy realmente necesitan ayuda con las traducciones. Por favor, informe a cualquier zona de falta que le den CURSE.COM MapLevelInfo. Si no, no conseguirá nunca fija, ya que no lo conocen! :)"
	}

	,["frFR"] = {
		 ["unknown zone"] = "zone inconnue"
		,["Capital City"] = "Capitale"
		,["Sanctuary"]    = "Sanctuaire"
		,["Horde"]        = "Horde"
		,["Alliance"]     = "Alliance"
		,["PvP Combat Zone"] = "Zone de combat PvP"
		,["Contested Zone"] = "Contesté"
		,["Staging Area"] = "Zone de transit"
		,["Worgen only"] = "Worgen seulement"
		,["Goblin only"] = "Goblin seulement"
		,["Garrison"] = "Fief"
		,["MISSING ZONES ERROR"] = "ERREUR - une ou plusieurs zones manquantes. Autour du moment de la libération 'Mists of Pandaria' Je suis vraiment dans le besoin de l'aide à la traduction. S'il vous plaît signaler tout zones manquantes vous sont donnés sur CURSE.COM MapLevelInfo. Si vous n'avez pas il ne pourra jamais se fixe comme je ne sais pas à ce sujet! :)"
	}

	,["ruRU"] = {

		--ruRU translation courtesy of 'yujitfd' !

		 ["unknown zone"] = "неизвестная зона"
		,["Capital City"] = "Столица"
		,["Sanctuary"] = "Святилище"
		,["Horde"] = "Орда"
		,["Alliance"] = "Альянс"
		,["PvP Combat Zone"] = "Зона PvP"
		,["Contested Zone"] = "Спорная территория"
		,["Staging Area"] = "Зона конфликта"
		,["Worgen only"] = "Территория Воргенов"
		,["Goblin only"] = "Территория Гоблинов"
		,["Garrison"] = "Гарнизонов"
		,["MISSING ZONES ERROR"] = "ОШИБКА - отсутствует одна или несколько зон. Пожалуйста, сообщайте об отсутствующих зонах на странице MapLevelInfo на сайте CURSE.COM MapLevelInfo. Без вашей помощи описания новых зон вряд ли появятся :)"

	}

	,["ptBR"] = {

		--ptBR translation courtesy of 'BarbarianFighter'!

		 ["unknown zone"] = "Zona Desconhecida"
		,["Capital City"] = "Capital"
		,["Sanctuary"]    = "Santuário"
		,["Horde"]        = "Horda"
		,["Alliance"]     = "Aliança"
		,["PvP Combat Zone"] = "Zona de Combate JxJ"
		,["Contested Zone"] = "Território Neutro"
		,["Staging Area"] = "Área Inicial"
		,["Worgen only"] = "Apenas Worgens"
		,["Goblin only"] = "Apenas Goblins"
		,["Garrison"] = "Guarnição"
		,["MISSING ZONES ERROR"] = "ERRO - uma ou mais zonas estão faltando! Por favor reporte quaisquer zonas que faltem em CURSE.COM MapLevelInfo. Obrigado! :)"
	}

	,["zhTW"] = {

		--zhTW translation courtesy of 'fanthos'!

		 ["unknown zone"] = "未知區域"
		,["Capital City"] = "城市"
		,["Sanctuary"]    = "聖域"
		,["Horde"]        = "部落領地"
		,["Alliance"]     = "聯盟領地"
		,["PvP Combat Zone"] = "PvP戰鬥區域"
		,["Contested Area"] = "競技區域"
		,["Staging Area"] = "Staging Area"
		,["Worgen only"] = "僅狼人"
		,["Goblin only"] = "僅哥布林"
		,["Garrison"] = "Garrison"  --please message me on curse if you have a translation.
		,["MISSING ZONES ERROR"] = "錯誤 - 一個或多個丟失的地區！ 請報告到Curse.com MapLevelInfo。 謝謝！"
	}

    };



    -------------------------------
    -- Locale Setup

    local currentLocale = GetLocale();
    local currentLocaleSupported = false;

    if (L[currentLocale]) then
    	currentLocaleSupported = true;
    elseif (currentLocale == "esMX") then
    	currentLocale = "esES";
    	currentLocaleSupported = true;
    elseif (currentLocale == "ptPT") then
    	currentLocale = "ptBR";
    	currentLocaleSupported = true;
    else
    	currentLocale = "enUS";
    end

    L = L[currentLocale];

    return currentLocale,currentLocaleSupported,L;
end
