function MapLevelInfo_init()

	--MapLevelInfoFrame:SetFrameLevel(MapLevelInfoFrame:GetFrameLevel()-1);
	--DEFAULT_CHAT_FRAME:AddMessage(WorldMapDetailFrame:GetFrameLevel()..":"..MapLevelInfoFrame:GetFrameLevel());

	local function trim(s)
		return (s:gsub("^%s*(.-)%s*$", "%1"))
	end

	-------------------------------
	-- Database Load

	local currentLocale,currentLocaleSupported,L = MapLevelInfo_locale();

	local continentNumberTable = {-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};

	local zones = MapLevelInfo_DB();

	local _;	-- throw-away variables
	local mapID, zoneDetail, zoneName, ckey, continentID;

	local zonesByName = {};

	for ckey,continentID in next, continentNumberTable do
		--SELECTED_CHAT_FRAME:AddMessage(continentID);
		zonesByName[continentID] = {};
	end

	for mapID, zoneDetail in next, zones do
		zoneName = trim(GetMapNameByID(mapID));
		for ckey, continentID in next, zoneDetail.Cont do
			--SELECTED_CHAT_FRAME:AddMessage(continentID.." : "..mapID.." : "..zoneName);
			if (zonesByName[continentID][zoneName]) then
				zonesByName[continentID][zoneName] = 1/0;  --issue here, abend in a heap.
			else
				zonesByName[continentID][zoneName] = mapID;
			end
		end
	end


	return currentLocale,currentLocaleSupported,L,zones,zonesByName,mapID;

end	
