-------------------------------
-- Database
-- ========
--
-- zoneDetail array -
--                 1,2: low level, high level
--					0,0 will not show any level range
--					<0,<0 denotes a capital city
--					x,y (anything else) will show as level range
--
--                 3: zone type
--					N - contested zone or neutral (sanctuary) capital city
--					A - Alliance controlled/favored
--					H - Horde controlled/favored
--					C - Continent (loaded automatically during init)
--					X - PvP combat zone (Wintergrasp, etc)
--
-------------------------------

function MapLevelInfo_DB()

		local zoneDetail = {

			 [13] = {1,90,"C",["Cont"]={0}}	--Kalimdor;
			,[772] = {0,0,"N",["Cont"]={1},["Pet"]={16,17}}	--Ahn'Qiraj: The Fallen Kingdom;
			,[894] = {1,20,"A",["Cont"]={1}}	--Ammen Vale;
			,[43] = {15,60,"N",["Cont"]={1},["Pet"]={4,6}}	--Ashenvale;
			,[181] = {10,60,"H",["Cont"]={1},["Pet"]={3,6}}	--Azshara;
			,[464] = {1,20,"A",["Cont"]={1},["Pet"]={1,2}}	--Azuremyst Isle;
			,[476] = {10,60,"A",["Cont"]={1},["Pet"]={3,6}}	--Bloodmyst Isle;
			,[890] = {1,20,"H",["Cont"]={1}}	--Camp Narache;
			,[42] = {10,60,"A",["Cont"]={1},["Pet"]={3,6}}	--Darkshore;
			,[381] = {-1,-1,"A",["Cont"]={0,1},["Pet"]={1,3}}	--Darnassus;
			,[101] = {30,60,"N",["Cont"]={1},["Pet"]={7,9}}	--Desolace;
			,[4] = {1,20,"H",["Cont"]={1},["Pet"]={1,2}}	--Durotar;
			,[141] = {35,60,"N",["Cont"]={1},["Pet"]={12,13}}	--Dustwallow Marsh;
			,[891] = {1,20,"H",["Cont"]={1}}	--Echo Isles;
			,[182] = {40,60,"N",["Cont"]={1},["Pet"]={14,15}}	--Felwood;
			,[121] = {35,60,"N",["Cont"]={1},["Pet"]={11,12}}	--Feralas;
			,[241] = {0,0,"N",["Cont"]={1},["Pet"]={15,16}}	--Moonglade;
			,[606] = {80,90,"N",["Cont"]={1},["Pet"]={22,24}}	--Mount Hyjal;
			,[9] = {1,20,"H",["Cont"]={1},["Pet"]={1,2}}	--Mulgore;
			,[11] = {10,60,"H",["Cont"]={1},["Pet"]={3,4}}	--Northern Barrens;
			,[321] = {-1,-1,"H",["Cont"]={0,1},["Pet"]={1,1}}	--Orgrimmar;
			,[888] = {1,20,"A",["Cont"]={1}}	--Shadowglen;
			,[261] = {40,60,"N",["Cont"]={1},["Pet"]={16,17}}	--Silithus;
			,[607] = {25,60,"N",["Cont"]={1},["Pet"]={9,10}}	--Southern Barrens;
			,[81] = {20,60,"N",["Cont"]={1},["Pet"]={5,7}}	--Stonetalon Mountains;
			,[161] = {40,60,"N",["Cont"]={1},["Pet"]={13,14}}	--Tanaris;
			,[41] = {1,20,"A",["Cont"]={1},["Pet"]={1,2}}	--Teldrassil;
			,[471] = {-1,-1,"A",["Cont"]={0,1},["Pet"]={1,3}}	--The Exodar;
			,[61] = {40,60,"N",["Cont"]={1},["Pet"]={13,14}}	--Thousand Needles;
			,[362] = {-1,-1,"H",["Cont"]={0,1},["Pet"]={1,3}}	--Thunder Bluff;
			,[720] = {83,90,"N",["Cont"]={1},["Pet"]={23,24}}	--Uldum;
			,[201] = {40,60,"N",["Cont"]={1},["Pet"]={15,16}}	--Un'Goro Crater;
			,[889] = {1,20,"H",["Cont"]={1}}	--Valley of Trials;
			,[281] = {40,60,"N",["Cont"]={1},["Pet"]={17,18}}	--Winterspring;
	
	
			,[14] = {1,90,"C",["Cont"]={0}}	--Eastern Kingdoms;
			,[614] = {80,90,"N",["Cont"]={2}}	--Abyssal Depths;
			,[16] = {25,60,"N",["Cont"]={2},["Pet"]={7,8}}	--Arathi Highlands;
			,[17] = {40,60,"N",["Cont"]={2},["Pet"]={13,14}}	--Badlands;
			,[19] = {40,60,"N",["Cont"]={2},["Pet"]={16,17}}	--Blasted Lands;
			,[29] = {40,60,"N",["Cont"]={2},["Pet"]={15,16}}	--Burning Steppes;
			,[866] = {1,20,"A",["Cont"]={2}}	--Coldridge Valley;
			,[32] = {50,60,"N",["Cont"]={2},["Pet"]={17,18}}	--Deadwind Pass;
			,[892] = {1,20,"H",["Cont"]={2}}	--Deathknell;
			,[27] = {1,20,"A",["Cont"]={2},["Pet"]={1,2}}	--Dun Morogh;
			,[34] = {20,60,"A",["Cont"]={2},["Pet"]={5,7}}	--Duskwood;
			,[23] = {40,60,"N",["Cont"]={2},["Pet"]={12,13}}	--Eastern Plaguelands;
			,[30] = {1,20,"A",["Cont"]={2},["Pet"]={1,2}}	--Elwynn Forest;
			,[462] = {1,20,"H",["Cont"]={2},["Pet"]={1,2}}	--Eversong Woods;
			,[463] = {10,60,"H",["Cont"]={2},["Pet"]={3,6}}	--Ghostlands;
			,[545] = {1,12,"A",["Note"]="Worgen only",["Cont"]={2}}	--Ruins of Gilneas;
			,[611] = {1,5,"A",["Note"]="Worgen only",["Cont"]={2}}	--Ruins of Gilneas City;
			,[24] = {15,60,"H",["Cont"]={2},["Pet"]={6,7}}	--Hillsbrad Foothills;
			,[341] = {-1,-1,"A",["Cont"]={0,2},["Pet"]={1,3}}	--Ironforge;
			,[499] = {67,80,"N",["Cont"]={2}}	--Isle of Quel'Danas;
			,[610] = {80,90,"N",["Cont"]={2}}	--Kelp'thar Forest;
			,[35] = {10,60,"A",["Cont"]={2},["Pet"]={3,6}}	--Loch Modan;
			,[895] = {1,20,"A",["Cont"]={2}}	--New Tinkertown;
			,[37] = {25,60,"N",["Cont"]={2},["Pet"]={7,9}}	--Northern Stranglethorn;
			,[864] = {1,20,"A",["Cont"]={2}}	--Northshire;
			,[36] = {15,60,"A",["Cont"]={2},["Pet"]={4,6}}	--Redridge Mountains;
			,[684] = {1,12,"A",["Note"]="Worgen only",["Cont"]={2}}	--Ruins of Gilneas;
			,[685] = {1,5,"A",["Note"]="Worgen only",["Cont"]={2}}	--Ruins of Gilneas City;
			,[28] = {40,60,"N",["Cont"]={2},["Pet"]={13,14}}	--Searing Gorge;
			,[615] = {80,90,"N",["Cont"]={2}}	--Shimmering Expanse;
			,[480] = {-1,-1,"H",["Cont"]={0,2},["Pet"]={1,3}}	--Silvermoon City;
			,[21] = {10,60,"H",["Cont"]={2},["Pet"]={3,6}}	--Silverpine Forest;
			,[301] = {-1,-1,"A",["Cont"]={0,2},["Pet"]={1,1}}	--Stormwind City;
			,[689] = {25,60,"N",["Cont"]={2},["Pet"]={7,10}}	--Stranglethorn Vale;
			,[893] = {1,20,"H",["Cont"]={2}}	--Sunstrider Isle;
			,[38] = {40,60,"N",["Cont"]={2},["Pet"]={14,15}}	--Swamp of Sorrows;
			,[673] = {30,60,"N",["Cont"]={2},["Pet"]={9,10}}	--The Cape of Stranglethorn;
			,[26] = {30,60,"N",["Cont"]={2},["Pet"]={11,12}}	--The Hinterlands;
			,[502] = {55,58,"N",["Cont"]={2}}	--Plaguelands: The Scarlet Enclave;
			,[20] = {1,20,"H",["Cont"]={2},["Pet"]={1,2}}	--Tirisfal Glades;
			,[708] = {85,85,"X",["Cont"]={2},["Pet"]={23,24}}	--Tol Barad;
			,[709] = {85,85,"N",["Cont"]={2},["Pet"]={23,24}}	--Tol Barad Peninsula;
			,[700] = {84,90,"N",["Cont"]={2},["Pet"]={23,24}}	--Twilight Highlands;
			,[382] = {-1,-1,"H",["Cont"]={0,2},["Pet"]={1,3}}	--Undercity;
			,[613] = {80,90,"N",["Cont"]={2}}	--Vashj'ir;
			,[22] = {35,60,"N",["Cont"]={2},["Pet"]={10,11}}	--Western Plaguelands;
			,[39] = {10,60,"A",["Cont"]={2},["Pet"]={3,4}}	--Westfall;
			,[40] = {20,60,"A",["Cont"]={2},["Pet"]={6,7}}	--Wetlands;
	
	
			,[466] = {58,80,"C",["Cont"]={-1}}	--Outland;
			,[475] = {65,80,"N",["Cont"]={3},["Pet"]={18,20}}	--Blade's Edge Mountains;
			,[465] = {58,80,"N",["Cont"]={3},["Pet"]={17,18}}	--Hellfire Peninsula;
			,[477] = {64,80,"N",["Cont"]={3},["Pet"]={18,19}}	--Nagrand;
			,[479] = {67,80,"N",["Cont"]={3},["Pet"]={20,21}}	--Netherstorm;
			,[473] = {67,80,"N",["Cont"]={3},["Pet"]={20,21}}	--Shadowmoon Valley;
			,[481] = {-1,-1,"S",["Cont"]={3}}	--Shattrath City;
			,[478] = {62,80,"N",["Cont"]={3},["Pet"]={18,19}}	--Terokkar Forest;
			,[467] = {60,80,"N",["Cont"]={3},["Pet"]={18,19}}	--Zangarmarsh;
	
	
			,[485] = {58,80,"C",["Cont"]={0}}	--Northrend;
			,[486] = {58,80,"N",["Cont"]={4},["Pet"]={20,22}}	--Borean Tundra;
			,[510] = {67,80,"N",["Cont"]={4},["Pet"]={22,23}}	--Crystalsong Forest;
			,[504] = {-1,-1,"S",["Cont"]={0,4}}	--Dalaran;
			,[488] = {61,80,"N",["Cont"]={4},["Pet"]={22,23}}	--Dragonblight;
			,[490] = {63,80,"N",["Cont"]={4},["Pet"]={21,22}}	--Grizzly Hills;
			,[491] = {58,80,"N",["Cont"]={4},["Pet"]={20,22}}	--Howling Fjord;
			,[541] = {67,80,"N",["Cont"]={4}}	--Hrothgar's Landing;
			,[492] = {67,80,"N",["Cont"]={4},["Pet"]={22,23}}	--Icecrown;
			,[493] = {66,80,"N",["Cont"]={4},["Pet"]={21,22}}	--Sholazar Basin;
			,[495] = {67,80,"N",["Cont"]={4},["Pet"]={22,23}}	--The Storm Peaks;
			,[501] = {67,80,"X",["Cont"]={4}}	--Wintergrasp;
			,[496] = {64,80,"N",["Cont"]={4},["Pet"]={22,23}}	--Zul'Drak;
	
	
			,[751] = {1,90,"C",["Cont"]={0}}	--The Maelstrom;
			,[640] = {82,90,"N",["Cont"]={5},["Pet"]={22,23}}	--Deepholm;
			,[605] = {1,5,"H",["Note"]="Goblin only",["Cont"]={5}}	--Kezan;
			,[544] = {5,10,"H",["Note"]="Goblin only",["Cont"]={5}}	--The Lost Isles;
			,[737] = {0,0,"S",["Cont"]={5}}	--The Maelstrom;
	
	
			,[862] = {80,90,"C",["Cont"]={0}}	--Pandaria;
			,[858] = {84,90,"N",["Cont"]={6},["Pet"]={24,25}}	--Dread Wastes;
			,[929] = {85,90,"N",["Cont"]={6}}	--Isle of Giants;
			,[928] = {85,90,"N",["Cont"]={6},["Pet"]={25,25}}	--Isle of Thunder;
			,[857] = {81,90,"N",["Cont"]={6},["Pet"]={23,25}}	--Krasarang Wilds;
			,[809] = {82,90,"N",["Cont"]={6},["Pet"]={23,25}}	--Kun-Lai Summit;
			,[905] = {-1,-1,"A",["Cont"]={6}}	--Shrine of Seven Stars;
			,[903] = {-1,-1,"H",["Cont"]={6}}	--Shrine of Two Moons;
			,[806] = {80,90,"N",["Cont"]={6},["Pet"]={23,25}}	--The Jade Forest;
			,[873] = {87,87,"N",["Cont"]={6}}	--The Veiled Stair;
			,[808] = {1,10,"N",["Cont"]={6}}	--The Wandering Isle;
			,[951] = {85,90,"N",["Cont"]={6},["Pet"]={25,25}}	--Timeless Isle;
			,[810] = {83,90,"N",["Cont"]={6},["Pet"]={24,25}}	--Townlong Steppes;
			,[811] = {85,90,"N",["Cont"]={6},["Pet"]={24,25}}	--Vale of Eternal Blossoms;
			,[807] = {81,90,"N",["Cont"]={6},["Pet"]={23,25}}	--Valley of the Four Winds;
	
	
			,[962] = {90,100,"C",["Cont"]={-1}}	--Draenor;
			,[978] = {100,100,"X",["Cont"]={7},["Pet"]={25,25}}	--Ashran;
			,[941] = {90,100,"H",["Cont"]={7},["Pet"]={23,25}}	--Frostfire Ridge;
			,[949] = {92,100,"N",["Cont"]={7},["Pet"]={25,25}}	--Gorgrond;
			,[950] = {98,100,"N",["Cont"]={7},["Pet"]={25,25}}	--Nagrand;
			,[947] = {90,100,"A",["Cont"]={7},["Pet"]={23,25}}	--Shadowmoon Valley;
			,[948] = {96,100,"N",["Cont"]={7},["Pet"]={25,25}}	--Spires of Arak;
			,[946] = {94,100,"N",["Cont"]={7},["Pet"]={25,25}}	--Talador;
			,[945] = {100,100,"N",["Cont"]={7},["Pet"]={25,25}}	--Tanaan Jungle;
			,[971] = {-1,-1,"A",["Cont"]={7},["Special"]="G"}	--Alliance Garrison;
			,[976] = {-1,-1,"H",["Cont"]={7},["Special"]="G"}	--Horde Garrison;


			,[1007] = {100,110,"C",["Cont"]={0}}	--The Broken Isles;
			,[1014] = {-1,-1,"S",["Cont"]={8},["Pet"]={25,25}} 	--Dalaran
			,[1015] = {100,109,"N",["Cont"]={8},["Pet"]={25,25}}	--Azsuna;
			,[1018] = {100,109,"N",["Cont"]={8},["Pet"]={25,25}}	--Val'sharah;
			,[1024] = {100,109,"N",["Cont"]={8},["Pet"]={25,25}}	--Highmountain;
			,[1017] = {100,109,"N",["Cont"]={8},["Pet"]={25,25}}	--Stormheim;
			,[1033] = {110,110,"N",["Cont"]={8},["Pet"]={25,25}}	--Suramar;
			,[1021] = {110,110,"N",["Cont"]={8},["Pet"]={25,25}}	--The Broken Shore;
			,[1096] = {98,110,"N",["Cont"]={8},["Pet"]={25,25}}	--Eye of Azshara;
		  
		  
		  
		  ,[1184] = {110,110,"C",["Cont"]={0}}	--Argus;
		  ,[1135] = {110,110,"N",["Cont"]={9},["Pet"]={25,25}}	--Krokuun;
		  ,[1171] = {110,110,"N",["Cont"]={9},["Pet"]={25,25}}	--Antoran Wastes;
		  ,[1170] = {110,110,"N",["Cont"]={9},["Pet"]={25,25}}	--Mac'Aree;
		  

	-- END OF LEVEL DATA
		};

	-- zone ID output for console: /run DEFAULT_CHAT_FRAME:AddMessage(GetCurrentMapAreaID());


	return zoneDetail;
end;

