-- Initialise

local MLI_VERSION = "2.1.6";

local L,zones,zonesByName;		--arrays
local currentLocale;			--strings
local currentLocaleSupported;		--booleans

local zoneDefault=" ";

local notActive = true;
local MLI_DEV = false;

local MLI_HIDE = false;

local lastX,lastY = 100;
local lastTime = 0;

local savedZone = "";
local savedMapText = "";
local savedPetLevels = "";
local savedCurrentMapAreaID = -1;

local savedScale = 0;
--local indentX = 75;   --was 60
--local indentY = 50;  --was -40, now negative at use

MapLevelInfoSettings = {};
local MapLevelInfoDefaultsVersion = 3;
local MapLevelInfoDefaults = {
		 ["fontLarge"]		= 22
		,["fontOutline"]	= true
		,["showAtZoneZoom"]	= true
		,["scale"]		= 100
		,["indentX"]		= 75
		,["indentY"]		= 50
		,["showPetLevels"]	= true
	};

local MapLevelInfo_Frame = CreateFrame("frame");
MapLevelInfo_Frame:RegisterEvent("ADDON_LOADED");

local _;	-- throw-away variables

---------
--REFERENCE:
--
--WorldMapDetailFrame (MAIN FRAME)
--WorldMapFrameAreaFrame (DETAIL CONTAINER)
--WorldMapFrameAreaLabel (ZONE NAMES)
--WorldMapFrameAreaDescription (ADDITIONAL TEXT, PVP)
--WorldMapFrameAreaPetLevels (PET LEVELS)
--WorldMapZoneInfo (BOTTOM)
--
--

	-------------------------------
	-- Trim
	local function trim(s)
		return (s:gsub("^%s*(.-)%s*$", "%1"))
	end

	-------------------------------
	-- OnUpdate functions
	-- moved out of OnUpdate as *Phanx* pointed out it was creating this function every time it ran.

	local function MapLevelInfo_LevelColour(maxLevelZone, minLevelZone) 

		local playerLevel = UnitLevel("player");
		local levelNull = maxLevelZone + ceil(GetQuestGreenRange()/2) + 1;
		local levelVeryHard = minLevelZone - 3;
		local levelHard = minLevelZone;
		local levelLow = maxLevelZone;
		local colour = {["R"]=1, ["G"]=1, ["B"]=1};

		if ( minLevelZone <= 0 ) then	-- capital city / unknown area
			colour = {["R"]=0.5, ["G"]=0.5, ["B"]=0.5};
		elseif ( playerLevel >= levelNull ) then	-- grey, little/no xp
			colour = {["R"]=0.5, ["G"]=0.5, ["B"]=0.5};
		elseif ( playerLevel <= levelVeryHard ) then	-- solid red, hard & probably no quests.
			--colour = {["R"]=1, ["G"]=0.2, ["B"]=0}; not blizz colours
			colour = {["R"]=1, ["G"]=0.1, ["B"]=0.1};
		elseif (  ( playerLevel > levelHard and playerLevel < levelLow )
		        or( (levelLow-levelHard)<2 and (playerLevel==levelLow or playerLevel==levelHard) ) ) then -- yellow, the 'sweetspot'
			--colour = {["R"]=1, ["G"]=1, ["B"]=0.2}; not blizz colours
			colour = {["R"]=1, ["G"]=1, ["B"]=0};
		elseif ( playerLevel >= levelLow and playerLevel < levelNull ) then -- green, on the easy side
			--colour = {["R"]=0, ["G"]=1, ["B"]=0.2}; not blizz colours
			colour = {["R"]=0.25, ["G"]=0.75, ["B"]=0.25};
		elseif ( playerLevel > levelVeryHard and playerLevel <= levelHard ) then -- orange, tough going
			--colour = {["R"]=1, ["G"]=0.6, ["B"]=0.2}; not blizz colours
			colour = {["R"]=1, ["G"]=0.5, ["B"]=0.25};
		end

		return colour;
	end

-------------------------------
-- OnUpdate
function MapLevelInfo_OnUpdate(self, elapsed)


	-------------------------------
	-- OnUpdate main procedure

	if (notActive) then return; end

	local currentMapAreaID = GetCurrentMapAreaID();
	local curX, curY = GetCursorPosition();
	local theTime = GetTime();
	local mapText = WorldMapFrameAreaLabel:GetText();
	local petLevels = WorldMapFrameAreaPetLevels:GetText();
	local mapDescription = WorldMapFrameAreaDescription:GetText();
	if (mapText) then mapText = trim(mapText:gsub("|.+$","")); end    -- get rid of 
	local scale = WorldMapDetailFrame:GetEffectiveScale();
	--DEFAULT_CHAT_FRAME:AddMessage(scale);

	--test to break out
	if (lastX==curX and lastY==curY and currentMapAreaID==savedCurrentMapAreaID and mapText==savedMapText and petLevels==savedPetLevels and scale==savedScale and (lastTime+0.5)>theTime) then return; else lastX = curX; lastY = curY; lastTime=theTime; end

	local currentContinentIndex = GetCurrentMapContinent();
	local isSpecial = false; if (zones[currentMapAreaID]) then if (zones[currentMapAreaID].Special) then isSpecial = zones[currentMapAreaID].Special; end end
	local zoneName;
	local zone = nil;

	--convert x,y
	local width = WorldMapDetailFrame:GetWidth();
	local height = WorldMapDetailFrame:GetHeight();
	local centerX, centerY = WorldMapDetailFrame:GetCenter();
	local topleftX = centerX - (width/2);
	local topleftY = centerY + (height/2);
	local x = ((curX/scale) - topleftX) / width;
	local y = (topleftY - (curY/scale)) / height;

	--DEFAULT_CHAT_FRAME:AddMessage(WORLDMAP_QUESTLIST_SIZE);
	--DEFAULT_CHAT_FRAME:AddMessage(scale..":"..width..":"..height);
	--DEFAULT_CHAT_FRAME:AddMessage(WorldMapDetailFrame:GetFrameLevel()..":"..MapLevelInfoFrame:GetFrameLevel());

	local cursorOnMap = false; 
	if (x>=0 and x<=0.065 and y>=0 and y<=0.097) then
		if (not MLI_HIDE) then
			MLI_HIDE = true;
			MapLevelInfoFrame:SetAlpha(0.15);
		end
	else
		if (x>=0 and x<=1 and y>=0 and y<=1) then
			cursorOnMap = true;
		end
		if (MLI_HIDE) then
			MLI_HIDE = false;
			MapLevelInfoFrame:SetAlpha(1.00);
		end
	end

	if (mapText and cursorOnMap and not isSpecial) then
		if (zonesByName[currentContinentIndex][mapText]) then
			zone = zonesByName[currentContinentIndex][mapText];
			if (not zones[zone]) then zone = nil; end
		end
	end

	if (not zone and cursorOnMap and not isSpecial) then
		zoneName, _, _, _, _, _, _, _ = UpdateMapHighlight(x, y);
		if (zonesByName[currentContinentIndex][zoneName]) then
			zone = zonesByName[currentContinentIndex][zoneName];
			if (not zones[zone]) then zone = nil; end
		end
	end

	--if (zone) then
	--	DEFAULT_CHAT_FRAME:AddMessage(currentContinentIndex..":"..mapText..":"..zone..":"..zones[zone][1]..","..zones[zone][2]..","..zones[zone][3]);
	--end

	if (not zone and MapLevelInfoSettings.showAtZoneZoom) then
		zone = currentMapAreaID;
		--DEFAULT_CHAT_FRAME:AddMessage(currentContinentIndex..":"..mapText..":"..zone);
		if (not zones[zone]) then zone = nil; end
	end

	if (scale ~= savedScale) then
		savedScale = scale;
		MapLevelInfoFrame_MainText:SetPoint("TOPLEFT","WorldMapDetailFrame","TOPLEFT",floor(MapLevelInfoSettings.indentX*(savedScale+0.3)), floor(-MapLevelInfoSettings.indentY*(savedScale+0.3)));
	end

	if (zone == savedZone and mapText == savedMapText and petLevels == savedPetLevels) then
		return
	else
		savedZone      = zone;
		savedCurrentMapAreaID = currentMapAreaID;
		savedMapText   = mapText;
		savedPetLevels = petLevels;

		if (zone == nil) then
			MapLevelInfoFrame_MainText:SetTextColor(0.5, 0.5, 0.5);
			MapLevelInfoFrame_MainText:SetText(savedMapText);
			MapLevelInfoFrame_Key:SetText("");
			MapLevelInfoFrame_LevelRange:SetText("");
			MapLevelInfoFrame_ExtraText:SetText("");
			MapLevelInfoFrame_ExtraText2:SetText("");
		else
			local zoneInfo = zones[zone];
			local zoneName = GetMapNameByID(zone);
			local controlInfo = "";
			local levelRange = "";
			local extraText = "";
			local extraText2 = "";
			local setControlColour, setLevelColour, setExtraColour;
			if (zoneInfo[3] == "N") then
				controlInfo = L["Contested Zone"];
				setControlColour = {["R"]=1, ["G"]=1, ["B"]=0};

			elseif (zoneInfo[3] == "H") then
				controlInfo = L["Horde"];
				setControlColour = {["R"]=1, ["G"]=0.1, ["B"]=0.1};

			elseif (zoneInfo[3] == "A") then
				controlInfo = L["Alliance"];
				setControlColour = {["R"]=0, ["G"]=0.5, ["B"]=1};

			elseif (zoneInfo[3] == "X") then
				controlInfo = L["PvP Combat Zone"];
				setControlColour = {["R"]=1, ["G"]=0.5, ["B"]=0.25};

			elseif (zoneInfo[3] == "S") then
				controlInfo = L["Sanctuary"];
				setControlColour = {["R"]=0.25, ["G"]=0.75, ["B"]=0.25};

			elseif (zoneInfo[3] == "C") then
				setControlColour = {["R"]=1, ["G"]=0.75, ["B"]=0.15};

			else -- should not be any 'else'
				setControlColour = {["R"]=1, ["G"]=1, ["B"]=1};
			end
			setExtraColour = setControlColour;
			if (mapDescription and zoneInfo[3] ~= "X") then
				setExtraColour = {["R"]=0.25, ["G"]=0.75, ["B"]=0.25};
			end;


			local setLevelColour = MapLevelInfo_LevelColour(0,0);
			if (zoneInfo == zoneDefault) then
				levelRange = "["..L["unknown zone"].."]";

			elseif (zoneInfo[1] < 0 and zoneInfo[2] < 0) then
				if (isSpecial) then
					if (isSpecial == "G") then
						levelRange = L["Garrison"];
					else
						levelRange = " ";
					end
				else
					levelRange = L["Capital City"];
				end

			elseif (zoneInfo[1] == 0 and zoneInfo[2] == 0 and zoneInfo[3] ~= "C" and (not MapLevelInfoSettings.showPetLevels or not zoneInfo.Pet)) then
				--levelRange = L["Staging Area"];
				levelRange = MapLevelInfoFrame_ExtraText:GetText();
				MapLevelInfoFrame_ExtraText:SetText("");
				setLevelColour = {["R"]=1, ["G"]=1, ["B"]=0.2};

			elseif (zoneInfo[1] > 0 and zoneInfo[2] > 0) then
				if (zoneInfo[1] < zoneInfo[2]) then
					levelRange = "["..zoneInfo[1].."-"..zoneInfo[2].."]";
					setLevelColour = MapLevelInfo_LevelColour(zoneInfo[2], zoneInfo[1]);
				else
					levelRange = "["..zoneInfo[1].."]";
					setLevelColour = MapLevelInfo_LevelColour(zoneInfo[1], zoneInfo[1]);
				end
			end
			if (zoneInfo["Note"]) then
				if (levelRange ~= "") then
					levelRange = levelRange.." ";
				end;
				levelRange = levelRange.."|cFF808080"..L[zoneInfo["Note"]];
			end


			extraText = "";
			if (savedMapText ~= nil and savedMapText ~= "BLAH!" and not zonesByName[currentContinentIndex][savedMapText]) then
				local tempMapText = savedMapText;
				local testLength = zoneName:len()+2;
				if (tempMapText:len() > testLength and MapLevelInfoSettings.showAtZoneZoom) then
					if (tempMapText:sub(0-testLength) == ", "..zoneName) then
						tempMapText = tempMapText:sub(1,tempMapText:len()-testLength);
					end
				end
				if (zoneInfo[3]=="C") then
					controlInfo = tempMapText;
				else
					extraText = tempMapText;
				end
			--elseif (zoneInfo[3]~="C" and not zonesByName[currentContinentIndex][savedMapText]) then
			--	extraText = zoneName;
			end

	-------------------------
	-- Pet Levels Managemnent
	-------------------------
			--if you want to check if people have pet battles unlocked. At the moment we always show if on.
			--local _, _, _, _, locked = C_PetJournal.GetPetLoadOutInfo(1);
			
			local petText,petColour = nil;

			if (zoneInfo.Pet and MapLevelInfoSettings.showPetLevels and currentContinentIndex>0) then
				local petMinLevel = zoneInfo.Pet[1];
				local petMaxLevel = zoneInfo.Pet[2];
				-- *** START SECTION WorldMapFrame.lua (5.2.0.16650) lines 1337 (ya, rly.) to 1359 ***
				-- *** wow.go-hero.net/framexml/16650/WorldMapFrame.lua#1337 ***
				local teamLevel = C_PetJournal.GetPetTeamAverageLevel();
				local color
				if (teamLevel) then
					if (teamLevel < petMinLevel) then
						--add 2 to the min level because it's really hard to fight higher level pets
						color = GetRelativeDifficultyColor(teamLevel, petMinLevel + 2);
					elseif (teamLevel > petMaxLevel) then
						color = GetRelativeDifficultyColor(teamLevel, petMaxLevel);
					else
						--if your team is in the level range, no need to call the function, just make it yellow
						color = QuestDifficultyColors["difficult"];
					end
				else
					--If you unlocked pet battles but have no team, level ranges are meaningless so make them grey
					color = QuestDifficultyColors["header"];
				end
				color = ConvertRGBtoColorString(color);
				-- *** END SECTION WorldMapFrame.lua (5.2.0.16650) lines 1337 to 1359 ***
				-- *** wow.go-hero.net/framexml/16650/WorldMapFrame.lua#1337 ***
				petColour = color;
				if (petMinLevel ~= petMaxLevel) then
					petText = "(" .. petMinLevel .. "-" .. petMaxLevel .. ")";
				else
					petText = "(" .. petMinLevel .. ")";
				end
			end
			if (petText) then
				if (levelRange == nil) then
					levelRange = "";
				elseif (levelRange:len() > 0) then
					if (string.sub(levelRange, -1) ~= "]") then
						levelRange = levelRange .. ",";
					end
					levelRange = levelRange .. "  ";
				end
				levelRange = levelRange .. "|cff7f7f7fPet: " .. petColour .. petText .. "|cff7f7f7f";
			end
				

			--FOR DEBUGGING (and take with pinch of salt as mine can update at very slightly different times to blizz hence false hits)
			if (MLI_DEV) then
				if (savedPetLevels and MapLevelInfoSettings.showPetLevels) then
					local s,e = savedPetLevels:find("|c");
					if (s) then
						local petTextBlizzard = savedPetLevels:sub(s+10);
						s,e = petTextBlizzard:find(")");
						petTextBlizzard = petTextBlizzard:sub(1,s);
						if (petText) then
							if (petText ~= petTextBlizzard) then
								DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00MapLevelInfo PET MISMATCH ERROR: " .. zone .. ":" .. zoneName .. ">" .. petTextBlizzard .. "<Blz U>"..petText.."<");
							end
						end
					end
				end
			end



	-------------------------
	-- Output Level Detail
	-------------------------

			MapLevelInfoFrame_MainText:SetTextColor(setControlColour["R"], setControlColour["G"], setControlColour["B"]);
			MapLevelInfoFrame_Key:SetTextColor(setControlColour["R"], setControlColour["G"], setControlColour["B"]);
			MapLevelInfoFrame_LevelRange:SetTextColor(setLevelColour["R"], setLevelColour["G"], setLevelColour["B"]);
			MapLevelInfoFrame_ExtraText:SetTextColor(setExtraColour["R"], setExtraColour["G"], setExtraColour["B"]);
			MapLevelInfoFrame_ExtraText2:SetTextColor(setExtraColour["R"], setExtraColour["G"], setExtraColour["B"]);

			MapLevelInfoFrame_MainText:SetText(zoneName);
			MapLevelInfoFrame_Key:SetText(controlInfo);
			MapLevelInfoFrame_LevelRange:SetText(levelRange);
			MapLevelInfoFrame_ExtraText:SetText(extraText);
			MapLevelInfoFrame_ExtraText2:SetText(mapDescription);

		end
	end
end





local function MapLevelInfo_SetFonts(fontLarge,fontOutlineBool)

		local minSize = ceil((6+1)/0.75);
		local maxSize = 24;

		if (fontLarge>maxSize) then fontLarge=maxSize elseif (fontLarge<minSize) then fontLarge=minSize end;
		local fontSmall = floor(fontLarge*0.75)-1;
		local fontSpacing = fontLarge;
		if (fontLarge > 18) then
			fontSpacing = fontSpacing + fontLarge - 18;
		elseif (fontLarge < 14) then
			fontSpacing = 14;
		end

		local theFont,_ = GameFontHighlight:GetFont();
		local fontOutline = "";
		if (fontOutlineBool) then fontOutline = "OUTLINE"; end
		
		MapLevelInfoFrame_MainText:SetFont(theFont,fontLarge,fontOutline);
		MapLevelInfoFrame_Key:SetFont(theFont,fontSmall,fontOutline);
		MapLevelInfoFrame_LevelRange:SetFont(theFont,fontSmall,fontOutline);
		MapLevelInfoFrame_ExtraText:SetFont(theFont,fontSmall,fontOutline);
		MapLevelInfoFrame_ExtraText2:SetFont(theFont,fontSmall,fontOutline);
		MapLevelInfoFrame_Key:SetPoint("BOTTOMLEFT", "MapLevelInfoFrame_MainText", "BOTTOMLEFT", 0, -fontSpacing);
		MapLevelInfoFrame_LevelRange:SetPoint("BOTTOMLEFT", "MapLevelInfoFrame_Key", "BOTTOMLEFT", 0, -fontSpacing);
		MapLevelInfoFrame_ExtraText:SetPoint("BOTTOMLEFT", "MapLevelInfoFrame_LevelRange", "BOTTOMLEFT", 0, -fontSpacing);
		MapLevelInfoFrame_ExtraText2:SetPoint("BOTTOMLEFT", "MapLevelInfoFrame_ExtraText", "BOTTOMLEFT", 0, -fontSpacing);

end


--============================
--= Register the Slash Command
--============================
SlashCmdList["MLI"] = function(_msg)
	if (_msg) then
		local _, _, cmd, arg1 = string.find(string.upper(_msg), "([%w]+)%s*(.*)$");
		if ("DEFAULT" == cmd or "RESET" == cmd) then		-- reset the list
			for MLI_default_key,MLI_default_value in next,MapLevelInfoDefaults do
				MapLevelInfoSettings[MLI_default_key] = MLI_default_value;
			end
			MapLevelInfo_SetFonts(MapLevelInfoSettings.fontLarge,MapLevelInfoSettings.fontOutline);
			MapLevelInfoFrame:SetScale(MapLevelInfoSettings.scale/100);
			MapLevelInfoFrame_MainText:SetPoint("TOPLEFT","WorldMapDetailFrame","TOPLEFT",floor(MapLevelInfoSettings.indentX*(savedScale+0.3)), floor(-MapLevelInfoSettings.indentY*(savedScale+0.3)));
			WorldMapFrameAreaLabel:Hide();
			MapLevelInfoFrame:Show();
			notActive=false;
			local confirmMsg = "MapLevelInfo: defaults reset";
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00".. confirmMsg);

		elseif ("SIZE" == cmd) then		-- set the text size
			local confirmMsg = "MapLevelInfo size ";
			local setSize = arg1:match("^%s*(%d+)%s*$");
			if (setSize ~= nil and tonumber(setSize)>=10 and tonumber(setSize)<=24) then
				MapLevelInfoSettings.fontLarge = floor(tonumber(setSize));
				MapLevelInfo_SetFonts(MapLevelInfoSettings.fontLarge,MapLevelInfoSettings.fontOutline);
				confirmMsg = confirmMsg .. "set to " ..MapLevelInfoSettings.fontLarge;
			else
				confirmMsg = confirmMsg .. "currently " ..MapLevelInfoSettings.fontLarge..". Settable range: 10-24.";
				if (arg1 ~= "") then
					confirmMsg = confirmMsg .. " (Option unknown: '"..arg1.."')";
				end
			end
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		elseif ("OUTLINE" == cmd) then
			local confirmMsg = "MapLevelInfo map text outline switched ";
			if (MapLevelInfoSettings.fontOutline) then
				MapLevelInfoSettings.fontOutline = false;
				confirmMsg = confirmMsg .. "off.";
			else
				MapLevelInfoSettings.fontOutline = true;
				confirmMsg = confirmMsg .. "on.";
			end
			MapLevelInfo_SetFonts(MapLevelInfoSettings.fontLarge,MapLevelInfoSettings.fontOutline);
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		elseif ("ZONE" == cmd) then
			local confirmMsg = "MapLevelInfo details at zone zoom-level switched ";
			if (MapLevelInfoSettings.showAtZoneZoom) then
				MapLevelInfoSettings.showAtZoneZoom = false;
				confirmMsg = confirmMsg .. "off.";
			else
				MapLevelInfoSettings.showAtZoneZoom = true;
				confirmMsg = confirmMsg .. "on.";
			end
			MapLevelInfo_SetFonts(MapLevelInfoSettings.fontLarge,MapLevelInfoSettings.fontOutline);
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		elseif ("PET" == cmd) then
			local confirmMsg = "MapLevelInfo pet level details shown switched ";
			if (MapLevelInfoSettings.showPetLevels) then
				MapLevelInfoSettings.showPetLevels = false;
				confirmMsg = confirmMsg .. "off.";
			else
				MapLevelInfoSettings.showPetLevels = true;
				confirmMsg = confirmMsg .. "on.";
			end
			MapLevelInfo_SetFonts(MapLevelInfoSettings.fontLarge,MapLevelInfoSettings.fontOutline);
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		elseif ("TOGGLE" == cmd) then
			local confirmMsg = "MapLevelInfo switched ";
			if (notActive) then
				WorldMapFrameAreaLabel:Hide();
				WorldMapFrameAreaPetLevels:Hide();
				WorldMapFrameAreaDescription:Hide();
				MapLevelInfoFrame:Show();
				notActive=false;
				confirmMsg = confirmMsg .. "ON";
			else
				WorldMapFrameAreaLabel:Show();
				WorldMapFrameAreaPetLevels:Show();
				WorldMapFrameAreaDescription:Show();
				MapLevelInfoFrame:Hide();
				notActive=true;
				confirmMsg = confirmMsg .. "OFF";
			end
			confirmMsg = confirmMsg .. ". This setting is not saved between sessions.";
			MapLevelInfo_SetFonts(MapLevelInfoSettings.fontLarge,MapLevelInfoSettings.fontOutline);
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		elseif ("SCALE" == cmd) then		-- set the frame scale (relative to world map frame)
			local confirmMsg = "MapLevelInfo scale ";
			local setScale = arg1:match("^%s*(%d+)%s*$");
			if (setScale ~= nil and tonumber(setScale)>=20 and tonumber(setScale)<=500) then
				MapLevelInfoSettings.scale = floor(tonumber(setScale));
				MapLevelInfoFrame:SetScale(MapLevelInfoSettings.scale/100);
				confirmMsg = confirmMsg .. "set to " ..MapLevelInfoSettings.scale.."%.";
			else
				confirmMsg = confirmMsg .. "currently " ..MapLevelInfoSettings.scale.."%. Settable range: 20-500.";
				if (arg1 ~= "") then
					confirmMsg = confirmMsg .. " (Option unknown: '"..arg1.."')";
				end
			end
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		elseif ("INDENTX" == cmd) then		-- set the X indent
			local confirmMsg = "MapLevelInfo indentX ";
			local setIndent = arg1:match("^%s*(%d+)%s*$");
			if (setIndent ~= nil and tonumber(setIndent)>=0 and tonumber(setIndent)<=10000) then
				MapLevelInfoSettings.indentX = floor(tonumber(setIndent));
				MapLevelInfoFrame_MainText:SetPoint("TOPLEFT","WorldMapDetailFrame","TOPLEFT",floor(MapLevelInfoSettings.indentX*(savedScale+0.3)), floor(-MapLevelInfoSettings.indentY*(savedScale+0.3)));
				confirmMsg = confirmMsg .. "set to " ..MapLevelInfoSettings.indentX..".";
			else
				confirmMsg = confirmMsg .. "currently " ..MapLevelInfoSettings.indentX..". Settable range: 0-10000.";
				if (arg1 ~= "") then
					confirmMsg = confirmMsg .. " (Option unknown: '"..arg1.."')";
				end
			end
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		elseif ("INDENTY" == cmd) then		-- set the Y indent
			local confirmMsg = "MapLevelInfo indentY ";
			local setIndent = arg1:match("^%s*(%d+)%s*$");
			if (setIndent ~= nil and tonumber(setIndent)>=0 and tonumber(setIndent)<=10000) then
				MapLevelInfoSettings.indentY = floor(tonumber(setIndent));
				MapLevelInfoFrame_MainText:SetPoint("TOPLEFT","WorldMapDetailFrame","TOPLEFT",floor(MapLevelInfoSettings.indentX*(savedScale+0.3)), floor(-MapLevelInfoSettings.indentY*(savedScale+0.3)));
				confirmMsg = confirmMsg .. "set to " ..MapLevelInfoSettings.indentY..".";
			else
				confirmMsg = confirmMsg .. "currently " ..MapLevelInfoSettings.indentY..". Settable range: 0-10000.";
				if (arg1 ~= "") then
					confirmMsg = confirmMsg .. " (Option unknown: '"..arg1.."')";
				end
			end
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		elseif ("DEV" == cmd) then		-- enable dev mode
			MLI_DEV = true;
			WorldMapFrameAreaLabel:Show();
			WorldMapFrameAreaPetLevels:Show();
			WorldMapFrameAreaDescription:Show();
			local confirmMsg = "MapLevelInfo Developer mode enabled. Reload UI or relog to disable.";
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. confirmMsg);

		else -- either a gap command or an incorrect option
			local badCmd = "";
			if (_msg ~= "" and _msg ~= "?" and _msg ~= "HELP") then badCmd = " Unknown command: '" .. _msg .. "'"; end;

			local outlineSetting="OFF";
			if (MapLevelInfoSettings.fontOutline) then outlineSetting="ON"; end
			local showAtZoneZoom="OFF";
			if (MapLevelInfoSettings.showAtZoneZoom) then showAtZoneZoom="ON"; end
			local showPetLevels="OFF";
			if (MapLevelInfoSettings.showPetLevels) then showPetLevels="ON"; end
			local mliShow="ON";
			if (notActive) then mliShow="OFF"; end

			local helpMsg = "/maplevelinfo or /mli " .. badCmd .. "\n" ..
				"/mli default: resets options (size:22; outline:ON; zone:ON; toggle:ON).\n" ..
				"/mli size n: sets zone text size to 'n', where 'n' is 10-24. ["..MapLevelInfoSettings.fontLarge.."]\n" ..
				"/mli outline: toggles text outline on/off. ["..outlineSetting.."]\n" ..
				"/mli zone: toggles MapLevelInfo details on zone zoom-level. ["..showAtZoneZoom.."]\n" ..
				"/mli pet: toggles MapLevelInfo pet levels on/off. ["..showPetLevels.."]\n" ..
				"/mli toggle: toggles MapLevelInfo on/off for the current session ["..mliShow.."]";
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. helpMsg);
		end
	end
end

SLASH_MLI1 = "/maplevelinfo";
SLASH_MLI2 = "/mli";	



--============================
--= Loaded
--============================

local function MapLevelInfo_OnEvent(self, event, arg1, ...)
	if ( event == "ADDON_LOADED" and arg1:lower() == "maplevelinfo" ) then

		currentLocale,currentLocaleSupported,L,zones,zonesByName = MapLevelInfo_init();

		local defaultReset = false;
		if (MapLevelInfoDefaultsVersion ~= MapLevelInfoSettings["defaultVersion"]) then
			defaultReset = true;
			MapLevelInfoSettings = {};
			MapLevelInfoSettings["defaultVersion"] = MapLevelInfoDefaultsVersion;
			DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00MapLevelInfo defaults are being reset (new version).");
		end
		for MLI_default_key,MLI_default_value in next,MapLevelInfoDefaults do
			if (MapLevelInfoSettings[MLI_default_key] == nil or defaultReset) then
				MapLevelInfoSettings[MLI_default_key] = MLI_default_value;
			end
		end

		MapLevelInfo_SetFonts(MapLevelInfoSettings.fontLarge,MapLevelInfoSettings.fontOutline);
		MapLevelInfoFrame:SetScale(MapLevelInfoSettings.scale/100);

		local okMessage = "OK";
		if (currentLocaleSupported == FALSE) then
			okMessage = "current locale not supported fully";
		end

		DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00MapLevelInfo "..MLI_VERSION.." loaded for ["..currentLocale.."] "..okMessage..". For options use /mli");

		WorldMapFrameAreaLabel:Hide();
		WorldMapFrameAreaPetLevels:Hide();
		WorldMapFrameAreaDescription:Hide();
		--WorldMapZoneInfo:Hide();
		notActive=false;

		--FOR FINDING THE TEXT FIELDS!!
		--local k,v;
		--for k,v in pairs(_G) do
		--	if (k:find("WorldMapFrameArea") ~= nil) then
		--		DEFAULT_CHAT_FRAME:AddMessage("|cFFFFCC00" .. k);
		--	end
		--end

	end
end
MapLevelInfo_Frame:SetScript("OnEvent", MapLevelInfo_OnEvent);
