--[[
LibObjectiveProgress: Weight Data
Last Updated: Patch 7.3.0 Live; 2018-06-26T0:22:11Z

If you would like a copy of this data in a different format for your own purposes or to be informed of future updates:
Contact MMOSimca / Simca@Malfurion - either through MMO-Champion, through Curse, or in-game

You may use this data in any form for any purpose without my permission (though it'd be cool if you gave a shoutout somewhere).
]]--

local LOP = LibStub("LibObjectiveProgress-1.0")
if not LOP then return end


-- Data obtained from Criteria.db2 / CriteriaTree.db2 / Scenario.db2 / ScenarioStep.db2 / Map.db2
function LOP:LoadWeightDataByMap()
    LOP.MapBasedWeights = {
        -- Hall of Valor
        [1477] = {
            {
                [97087] = 1.5873,
                [96611] = 1.5873,
                [96608] = 1.5873,
                [96677] = 1.5873,
                [96640] = 1.5873,
                [95834] = 1.5873,
                [96664] = 1.5873,
                [95832] = 1.5873,
                [95842] = 1.5873,
                [97068] = 3.96825,
                [96574] = 3.96825,
                [99891] = 3.96825,
                [97197] = 1.5873,
                [99804] = 1.5873,
                [96934] = 1.5873,
                [97083] = 3.96825,
                [95843] = 3.96825,
                [97081] = 3.96825,
                [97084] = 3.96825,
            },
            {
                [97087] = 1.3245,
                [96611] = 1.3245,
                [96608] = 1.3245,
                [96677] = 1.3245,
                [96640] = 1.3245,
                [95834] = 1.3245,
                [96664] = 1.3245,
                [95832] = 1.3245,
                [95842] = 1.3245,
                [97068] = 3.31126,
                [96574] = 3.31126,
                [99891] = 3.31126,
                [96934] = 1.3245,
                [99804] = 1.3245,
                [97197] = 1.3245,
                [97084] = 3.31126,
                [97081] = 3.31126,
                [97083] = 3.31126,
                [95843] = 3.31126,
            },
        },
        -- Black Rook Hold
        [1501] = {
            {
                [98370] = 1.33333,
                [98368] = 1.33333,
                [98366] = 1.33333,
                [98521] = 3.33333,
                [98538] = 3.33333,
                [98677] = 0.33333,
                [98681] = 2,
                [98706] = 2,
                [98280] = 1.33333,
                [101549] = 0.33333,
                [98275] = 1.33333,
                [98243] = 1.33333,
                [98691] = 1.33333,
                [101839] = 1.33333,
                [102138] = 3.33333,
                [98813] = 1.33333,
                [102788] = 1.33333,
                [98810] = 2,
                [98792] = 1.33333,
                [101923] = 1.33333,
                [98900] = 1.33333,
                [102095] = 1.33333,
                [102094] = 1.33333,
            },
            {
                [98370] = 1.11111,
                [98368] = 1.11111,
                [98366] = 1.11111,
                [98521] = 2.77778,
                [98538] = 2.77778,
                [98677] = 0.27778,
                [98681] = 1.66667,
                [98706] = 1.66667,
                [98280] = 1.11111,
                [101549] = 0.27778,
                [98275] = 1.11111,
                [98243] = 1.11111,
                [98691] = 1.11111,
                [101839] = 1.11111,
                [102138] = 2.77778,
                [98813] = 1.11111,
                [102788] = 1.11111,
                [98810] = 1.66667,
                [98792] = 1.11111,
                [101923] = 1.11111,
                [98900] = 1.11111,
                [102095] = 1.11111,
                [102094] = 1.11111,
            },
        },
        -- Eye of Azshara
        [1456] = {
            {
                [91783] = 1.94175,
                [95861] = 1.94175,
                [100216] = 1.94175,
                [91782] = 4.85437,
                [91785] = 0.97087,
                [91781] = 1.94175,
                [95920] = 0.97087,
                [97171] = 4.85437,
                [97170] = 1.94175,
                [97173] = 1.94175,
                [97172] = 0.48544,
                [91796] = 4.85437,
                [95939] = 4.85437,
                [99629] = 0.48544,
                [106785] = 0.48544,
                [99630] = 0.48544,
                [106786] = 0.48544,
                [95940] = 0.48544,
                [106787] = 0.48544,
                [91794] = 0.48544,
                [101414] = 0.97087,
                [91793] = 0.48544,
                [91792] = 4.85437,
                [95947] = 1.94175,
                [91790] = 1.94175,
                [91786] = 1.94175,
                [91787] = 0.48544,
                [100248] = 1.94175,
                [100249] = 1.94175,
                [100250] = 1.94175,
                [98173] = 1.94175,
            },
            {
                [91783] = 1.65289,
                [95861] = 1.65289,
                [100216] = 1.65289,
                [91782] = 4.13223,
                [91785] = 0.82645,
                [91781] = 1.65289,
                [95920] = 0.82645,
                [97171] = 4.13223,
                [97170] = 1.65289,
                [97173] = 1.65289,
                [97172] = 0.41322,
                [91796] = 4.13223,
                [95939] = 4.13223,
                [99629] = 0.41322,
                [106785] = 0.41322,
                [99630] = 0.41322,
                [106786] = 0.41322,
                [95940] = 0.41322,
                [106787] = 0.41322,
                [91794] = 0.41322,
                [101414] = 0.82645,
                [91793] = 0.41322,
                [91792] = 4.13223,
                [95947] = 1.65289,
                [91790] = 1.65289,
                [91786] = 1.65289,
                [91787] = 0.41322,
                [100248] = 1.65289,
                [100249] = 1.65289,
                [100250] = 1.65289,
                [98173] = 1.65289,
            },
        },
        -- Darkheart Thicket
        [1466] = {
            {
                [95771] = 1.42857,
                [95779] = 3.57143,
                [99358] = 1.42857,
                [101679] = 1.42857,
                [95766] = 1.42857,
                [99359] = 1.07143,
                [99360] = 3.21429,
                [95769] = 1.42857,
                [95772] = 1.42857,
                [100531] = 2.85714,
                [101991] = 1.42857,
                [100526] = 1.42857,
                [100527] = 1.07143,
                [100539] = 1.42857,
                [99365] = 1.42857,
                [99366] = 1.42857,
                [100529] = 0.35714,
            },
            {
                [95771] = 1.19048,
                [95779] = 2.97619,
                [99358] = 1.19048,
                [101679] = 1.19048,
                [95766] = 1.19048,
                [99359] = 0.89286,
                [99360] = 2.67857,
                [95769] = 1.19048,
                [95772] = 1.19048,
                [100531] = 2.38095,
                [101991] = 1.19048,
                [100526] = 1.19048,
                [100527] = 0.89286,
                [100539] = 1.19048,
                [99365] = 1.19048,
                [99366] = 1.19048,
                [100529] = 0.29762,
            },
        },
        -- Vault of the Wardens
        [1493] = {
            {
                [95771] = 1.90476,
                [96657] = 5.71429,
                [97674] = 1.90476,
                [102583] = 1.90476,
                [99956] = 1.90476,
                [96587] = 1.90476,
                [99649] = 5.71429,
                [98177] = 5.71429,
                [96584] = 1.90476,
                [98963] = 0.47619,
                [98533] = 4.7619,
                [102584] = 1.90476,
                [98926] = 1.90476,
                [97678] = 3.80952,
                [97677] = 0.47619,
                [96480] = 0.47619,
                [100364] = 1.90476,
                [98954] = 1.90476,
                [102566] = 5.71429,
            },
            {
                [95771] = 1.5873,
                [96657] = 4.7619,
                [97674] = 1.5873,
                [102583] = 1.5873,
                [99956] = 1.5873,
                [96587] = 1.5873,
                [99649] = 4.7619,
                [98177] = 4.7619,
                [96584] = 1.5873,
                [98963] = 0.39683,
                [98533] = 3.96825,
                [102584] = 1.5873,
                [98926] = 1.5873,
                [97678] = 3.1746,
                [97677] = 0.39683,
                [96480] = 0.39683,
                [100364] = 1.5873,
                [98954] = 1.5873,
                [102566] = 4.7619,
            },
        },
        -- Neltharion's Lair
        [1458] = {
            {
                [102404] = 1.81818,
                [91332] = 1.81818,
                [92610] = 1.81818,
                [92351] = 1.81818,
                [91008] = 1.81818,
                [90998] = 1.81818,
                [102253] = 1.81818,
                [102232] = 1.81818,
                [90997] = 1.81818,
                [92350] = 1.81818,
                [91000] = 3.63636,
                [101438] = 1.81818,
                [91006] = 1.81818,
                [105636] = 1.81818,
                [105720] = 1.81818,
                [98406] = 1.81818,
                [102287] = 4.54545,
                [96247] = 0.45455,
                [91001] = 1.81818,
                [102430] = 0.45455,
                [113998] = 1.81818,
                [113537] = 4.54545,
            },
            {
                [102404] = 1.51515,
                [91332] = 1.51515,
                [92610] = 1.51515,
                [92351] = 1.51515,
                [91008] = 1.51515,
                [90998] = 1.51515,
                [102253] = 1.51515,
                [102232] = 1.51515,
                [90997] = 1.51515,
                [92350] = 1.51515,
                [91000] = 3.0303,
                [101438] = 1.51515,
                [91006] = 1.51515,
                [105636] = 1.51515,
                [105720] = 1.51515,
                [98406] = 1.51515,
                [102287] = 3.78788,
                [96247] = 0.37879,
                [91001] = 1.51515,
                [102430] = 0.37879,
                [113998] = 1.51515,
                [113537] = 3.78788,
            },
        },
        -- Maw of Souls
        [1492] = {
            {
                [97097] = 2.66667,
                [97043] = 2.66667,
                [99188] = 2.66667,
                [102375] = 2,
                [98919] = 2.66667,
                [97182] = 4,
                [99033] = 2.66667,
                [97185] = 6.66667,
                [97119] = 0.66667,
                [97200] = 2.66667,
                [102104] = 2.66667,
                [97365] = 2.66667,
                [99307] = 8,
                [98973] = 0.66667,
            },
            {
                [97097] = 2.22222,
                [97043] = 2.22222,
                [99188] = 2.22222,
                [102375] = 1.66667,
                [98919] = 2.22222,
                [97182] = 3.33333,
                [99033] = 2.22222,
                [97185] = 5.55556,
                [97119] = 0.55556,
                [97200] = 2.22222,
                [102104] = 2.22222,
                [97365] = 2.22222,
                [99307] = 6.66667,
                [98973] = 0.55556,
            },
        },
        -- Arcway
        [1516] = {
            {
                [98728] = 1.78571,
                [98756] = 1.02041,
                [105617] = 1.02041,
                [105682] = 2.04082,
                [98732] = 0.2551,
                [105651] = 2.55102,
                [98759] = 1.02041,
                [105876] = 0.2551,
                [102351] = 0.2551,
                [105915] = 1.02041,
                [105921] = 1.02041,
                [105706] = 2.55102,
                [98425] = 1.02041,
                [106059] = 1.02041,
                [98733] = 1.02041,
                [105952] = 1.53061,
                [98770] = 1.02041,
                [105629] = 0.2551,
                [113699] = 2.04082,
            },
            {
                [98728] = 1.50215,
                [98756] = 0.85837,
                [105617] = 0.85837,
                [105682] = 1.71674,
                [98732] = 0.21459,
                [105651] = 2.14592,
                [98759] = 0.85837,
                [105876] = 0.21459,
                [102351] = 0.21459,
                [105915] = 0.85837,
                [105921] = 0.85837,
                [105706] = 2.14592,
                [98425] = 0.85837,
                [106059] = 0.85837,
                [98733] = 0.85837,
                [105952] = 1.28755,
                [98770] = 0.85837,
                [105629] = 0.21459,
                [113699] = 1.71674,
            },
        },
        -- Court of Stars
        [1571] = {
            {
                [105704] = 2.5,
                [104251] = 2.5,
                [104270] = 5,
                [104277] = 2.5,
                [104278] = 6.25,
                [104246] = 2.5,
                [104247] = 2.5,
                [105703] = 0.625,
                [105705] = 2.5,
                [105715] = 2.5,
                [105699] = 1.875,
                [111563] = 2.5,
                [104300] = 2.5,
                [104295] = 0.625,
            },
            {
                [105703] = 0.52083,
                [105715] = 2.08333,
                [104295] = 0.52083,
                [104300] = 2.08333,
                [104247] = 2.08333,
                [111563] = 2.08333,
                [105704] = 2.08333,
                [104277] = 2.08333,
                [105699] = 1.5625,
                [104246] = 2.08333,
                [104270] = 4.16667,
                [105705] = 2.08333,
                [104278] = 5.20833,
                [104251] = 2.08333,
            },
        },
        -- Return to Karazhan
        [1651] = {
            -- Lower
            {
                [114627] = 0.95238,
                [114626] = 0.95238,
                [114541] = 0.2381,
                [114542] = 0.95238,
                [114584] = 0.2381,
                [114526] = 0.2381,
                [116549] = 0.95238,
                [114544] = 0.95238,
                [114625] = 0.2381,
                [114629] = 0.95238,
                [114634] = 0.95238,
                [114636] = 0.95238,
                [114637] = 0.95238,
                [114783] = 0.95238,
                [114796] = 0.95238,
                [114792] = 0.95238,
                [115020] = 0.95238,
                [115019] = 0.95238,
                [115115] = 0.95238,
                [114624] = 1.90476,
                [114628] = 0.95238,
                [114794] = 0.95238,
                [114716] = 0.2381,
                [114715] = 0.95238,
                [114802] = 0.95238,
                [114801] = 0.95238,
                [114804] = 0.95238,
                [114803] = 0.95238,
                [114633] = 0.95238,
                [116550] = 0.95238,
                [114632] = 0.95238,
                [114714] = 0.95238,
            },
            {
                [114627] = 0.79365,
                [114626] = 0.79365,
                [114541] = 0.19841,
                [114542] = 0.79365,
                [114584] = 0.19841,
                [114526] = 0.19841,
                [116549] = 0.79365,
                [114544] = 0.79365,
                [114625] = 0.19841,
                [114629] = 0.79365,
                [114634] = 0.79365,
                [114636] = 0.79365,
                [114637] = 0.79365,
                [114783] = 0.79365,
                [114796] = 0.79365,
                [114792] = 0.79365,
                [115020] = 0.79365,
                [115019] = 0.79365,
                [115115] = 0.79365,
                [114624] = 1.5873,
                [114628] = 0.79365,
                [114794] = 0.79365,
                [114716] = 0.19841,
                [114715] = 0.79365,
                [114802] = 0.79365,
                [114801] = 0.79365,
                [114804] = 0.79365,
                [114803] = 0.79365,
                [114633] = 0.79365,
                [116550] = 0.79365,
                [114632] = 0.79365,
                [114714] = 0.79365,
                [114714] = 0.79365,
            },
            -- Upper
            {
                [114626] = 2.36686,
                [114627] = 2.36686,
                [114334] = 2.36686,
                [115765] = 7.10059,
                [114338] = 5.91716,
                [114364] = 0.59172,
                [115484] = 2.36686,
                [115488] = 2.36686,
                [115757] = 4.73373,
                [115419] = 4.73373,
                [115417] = 4.73373,
                [115418] = 4.73373,
                [115831] = 2.36686,
                [115486] = 4.73373,
                [115388] = 7.10059,
            },
            {
                [114626] = 1.9802,
                [114627] = 1.9802,
                [114334] = 1.9802,
                [115765] = 5.94059,
                [114338] = 4.9505,
                [114364] = 0.49505,
                [115484] = 1.9802,
                [115488] = 1.9802,
                [115757] = 3.9604,
                [115419] = 3.9604,
                [115417] = 3.9604,
                [115418] = 3.9604,
                [115831] = 1.9802,
                [115486] = 3.9604,
                [115388] = 5.94059,
            },
        },
        -- Cathedral of Eternal Night
        [1677] = {
            {
                [119952] = 1.31148,
                [120550] = 1.31148,
                [118704] = 3.27869,
                [119923] = 1.31148,
                [118700] = 0.65574,
                [119930] = 1.31148,
                [120366] = 1.31148,
                [119978] = 0.32787,
                [118703] = 1.31148,
                [118716] = 1.31148,
                [119977] = 1.31148,
                [118717] = 1.31148,
                [118719] = 1.31148,
                [118723] = 3.27869,
                [120274] = 2.62295,
                [118706] = 0.65574,
                [118712] = 1.31148,
                [118705] = 3.27869,
                [120374] = 1.31148,
                [118690] = 1.31148,
                [118724] = 1.31148,
                [120556] = 1.31148,
                [120405] = 1.31148,
                [118714] = 1.31148,
                [121318] = 0.32787,
                [121569] = 1.31148,
                [121711] = 1.31148,
                [120371] = 1.31148,
                [118713] = 1.31148,
                [121553] = 1.31148,
            },
            {
                [119952] = 1.19403,
                [120550] = 1.19403,
                [118704] = 2.98507,
                [119923] = 1.19403,
                [118700] = 0.59701,
                [119930] = 1.19403,
                [120366] = 1.19403,
                [119978] = 0.29851,
                [118703] = 1.19403,
                [118716] = 1.19403,
                [119977] = 1.19403,
                [118717] = 1.19403,
                [118719] = 1.19403,
                [118723] = 2.98507,
                [120274] = 2.38806,
                [118706] = 0.59701,
                [118712] = 1.19403,
                [118705] = 2.98507,
                [120374] = 1.19403,
                [118690] = 1.19403,
                [118724] = 1.19403,
                [120556] = 1.19403,
                [120405] = 1.19403,
                [118714] = 1.19403,
                [121318] = 0.29851,
                [121569] = 1.19403,
                [121711] = 1.19403,
                [120371] = 1.19403,
                [118713] = 1.19403,
                [121553] = 1.19403,
            },
        },
        -- Seat of the Triumvirate
        [1753] = {
            {
                [124171] = 1.45455,
                [122322] = 1.45455,
                [122478] = 0.72727,
                [122398] = 1.45455,
                [122408] = 1.45455,
                [122413] = 1.45455,
                [122421] = 2.90909,
                [122410] = 0.36364,
                [122403] = 1.45455,
                [122571] = 2.90909,
                [122407] = 1.45455,
                [122412] = 1.45455,
                [122405] = 1.45455,
                [122404] = 1.45455,
                [124947] = 0.36364,
                [122423] = 2.90909,
                [125860] = 2.90909,
            },
            {
                [124171] = 1.21581,
                [122322] = 1.21581,
                [122478] = 0.6079,
                [122398] = 1.21581,
                [122408] = 1.21581,
                [122413] = 1.21581,
                [122421] = 2.43161,
                [122410] = 0.30395,
                [122403] = 1.21581,
                [122571] = 2.43161,
                [122407] = 1.21581,
                [122412] = 1.21581,
                [122405] = 1.21581,
                [122404] = 1.21581,
                [124947] = 0.30395,
                [122423] = 2.43161,
                [125860] = 2.43161,
            },
        },
        -- Atal'Dazar (CityofGoldExterior)
        [1763] = {
            {
                [127879] = 2.0202,
                [122971] = 2.0202,
                [127799] = 2.0202,
                [122972] = 2.0202,
                [122973] = 2.0202,
                [122984] = 3.0303,
                [132126] = 2.0202,
                [127757] = 2.0202,
                [122970] = 2.0202,
                [122969] = 2.0202,
                [128435] = 0.50505,
                [128434] = 2.0202,
                [129553] = 5.05051,
                [129552] = 3.0303,
                [128455] = 3.0303,
            },
            {
                [127879] = 1.68776,
                [122971] = 1.68776,
                [127799] = 1.68776,
                [122972] = 1.68776,
                [122973] = 1.68776,
                [122984] = 2.53165,
                [132126] = 1.68776,
                [127757] = 1.68776,
                [122970] = 1.68776,
                [122969] = 1.68776,
                [128435] = 0.42194,
                [128434] = 1.68776,
                [129553] = 4.21941,
                [129552] = 2.53165,
                [128455] = 2.53165,
            },
        },
        -- Tol Dagor (KulTirasPrison)
        [1771] = {
            {
                [127480] = 0.28736,
                [127482] = 1.72414,
                [127381] = 1.72414,
                [130025] = 2.01149,
                [131112] = 1.72414,
                [127485] = 0.86207,
                [130582] = 0.28736,
                [130026] = 1.72414,
                [130207] = 0.86207,
                [131445] = 2.58621,
                [130027] = 2.01149,
                [127486] = 2.01149,
                [130353] = 1.72414,
                [127488] = 2.01149,
                [127497] = 2.58621,
                [127477] = 1.72414,
            },
            {
                [127480] = 0.23981,
                [127482] = 1.43885,
                [127381] = 1.43885,
                [130025] = 1.67866,
                [131112] = 1.43885,
                [127485] = 0.71942,
                [130582] = 0.23981,
                [130026] = 1.43885,
                [130207] = 0.71942,
                [131445] = 2.15827,
                [130027] = 1.67866,
                [127486] = 1.67866,
                [130353] = 1.43885,
                [127488] = 1.67866,
                [127497] = 2.15827,
                [127477] = 1.43885,
            },
        },
        -- Freehold (PirateTownDungeon)
        [1754] = {
            {
                [126928] = 1.53257,
                [126918] = 1.53257,
                [129788] = 1.53257,
                [128551] = 1.53257,
                [129602] = 2.29885,
                [129598] = 0.76628,
                [127111] = 2.29885,
                [130011] = 1.53257,
                [129526] = 1.53257,
                [130522] = 0.76628,
                [130024] = 0.38314,
                [130404] = 2.29885,
                [127124] = 0.38314,
                [127119] = 0.38314,
                [129548] = 1.53257,
                [129529] = 1.53257,
                [129547] = 1.53257,
                [129550] = 1.53257,
                [129551] = 0.38314,
                [129527] = 1.53257,
                [129599] = 1.53257,
                [129600] = 1.53257,
                [130400] = 2.29885,
                [126919] = 1.53257,
                [130012] = 1.53257,
                [127106] = 2.29885,
                [130521] = 0.38314,
                [129601] = 1.53257,
                [129559] = 1.53257,
            },
            {
                [126928] = 1.27796,
                [126918] = 1.27796,
                [129788] = 1.27796,
                [128551] = 1.27796,
                [129602] = 1.91693,
                [129598] = 0.63898,
                [127111] = 1.91693,
                [130011] = 1.27796,
                [129526] = 1.27796,
                [130522] = 0.63898,
                [130024] = 0.31949,
                [130404] = 1.91693,
                [127124] = 0.31949,
                [127119] = 0.31949,
                [129548] = 1.27796,
                [129529] = 0,
                [129547] = 1.27796,
                [129550] = 1.27796,
                [129551] = 0.31949,
                [129527] = 1.27796,
                [129599] = 1.27796,
                [129600] = 1.27796,
                [130400] = 1.91693,
                [126919] = 1.27796,
                [130012] = 1.27796,
                [127106] = 1.91693,
                [129559] = 1.27796,
                [129601] = 1.27796,
                [130521] = 0.31949,
            },
        },
        -- Kezan (DevMapG)
        [1594] = {
            {
                [130436] = 0.25641,
                [136006] = 0.25641,
                [130488] = 1.02564,
                [130485] = 1.53846,
                [136470] = 1.02564,
                [130435] = 1.28205,
                [134232] = 1.02564,
                [136139] = 1.53846,
                [130437] = 0.51282,
                [130653] = 1.02564,
                [130661] = 1.02564,
                [130661] = 1.02564,
                [136643] = 1.53846,
                [130635] = 1.02564,
                [134005] = 0.25641,
                [134012] = 1.53846,
                [137713] = 0.25641,
                [137940] = 1.02564,
                [133430] = 1.53846,
                [133345] = 1.02564,
                [133432] = 1.02564,
                [136934] = 1.02564,
                [133963] = 0.25641,
                [133593] = 1.02564,
                [133463] = 1.53846,
                [137029] = 1.02564,
                [133436] = 1.02564,
                [133482] = 0.25641,
            },
            {
                [130436] = 0.21368,
                [136006] = 0.21368,
                [130488] = 0.8547,
                [130485] = 1.28205,
                [136470] = 0.8547,
                [130435] = 1.06838,
                [134232] = 0.8547,
                [136139] = 1.28205,
                [130437] = 0.42735,
                [130653] = 0.8547,
                [130661] = 0.8547,
                [130661] = 0.8547,
                [136643] = 1.28205,
                [130635] = 0.8547,
                [134005] = 0.21368,
                [134012] = 1.28205,
                [137713] = 0.21368,
                [137940] = 0.8547,
                [133430] = 1.28205,
                [133345] = 0.8547,
                [133432] = 0.8547,
                [136934] = 0.8547,
                [133963] = 0.21368,
                [133593] = 0.8547,
                [133463] = 1.28205,
                [137029] = 0.8547,
                [133436] = 0.8547,
                [133482] = 0.21368,
                [136005] = 0.21368,
            },
        },
        -- Waycrest Manor (DrustvarDungeon)
        [1862] = {
            {
                [135240] = 0.69204,
                [137048] = 0.34602,
                [131850] = 1.38408,
                [131849] = 1.38408,
                [135234] = 0.69204,
                [134024] = 0.34602,
                [135048] = 1.38408,
                [134041] = 1.38408,
                [131847] = 1.38408,
                [131586] = 1.38408,
                [137830] = 1.38408,
                [131601] = 1.38408,
                [131611] = 1.38408,
                [131607] = 1.38408,
                [131677] = 1.38408,
                [131669] = 0.34602,
                [131858] = 1.38408,
                [131666] = 1.38408,
                [135329] = 2.07612,
                [131685] = 1.38408,
                [131585] = 1.38408,
                [131587] = 1.7301,
                [131812] = 1.38408,
                [135052] = 0.34602,
                [135474] = 1.38408,
                [131818] = 1.38408,
                [135049] = 0.69204,
                [135365] = 2.07612,
                [131819] = 1.38408,
                [139269] = 1.38408,
            },
            {
                [135240] = 0.57803,
                [137048] = 0.28902,
                [131850] = 1.15607,
                [131849] = 1.15607,
                [135234] = 0.57803,
                [134024] = 0.28902,
                [135048] = 1.15607,
                [134041] = 1.15607,
                [131847] = 1.15607,
                [131586] = 1.15607,
                [137830] = 1.15607,
                [131601] = 1.15607,
                [131611] = 1.15607,
                [131607] = 1.15607,
                [131677] = 1.15607,
                [131669] = 0.28902,
                [131858] = 1.15607,
                [131666] = 1.15607,
                [135329] = 1.7341,
                [131685] = 1.15607,
                [131585] = 1.15607,
                [131587] = 1.44509,
                [131812] = 1.15607,
                [135052] = 0.28902,
                [135474] = 1.15607,
                [131818] = 1.15607,
                [135049] = 0.57803,
                [135365] = 1.7341,
                [131819] = 1.15607,
                [139269] = 1.15607,
            },
        },
        -- Kings' Rest (CityofGoldInteriorDungeon)
        [1762] = {
            {
                [133935] = 1.89394,
                [133943] = 0.37879,
                [134158] = 2.27273,
                [134174] = 1.89394,
                [134157] = 1.51515,
                [137485] = 1.51515,
                [137484] = 2.27273,
                [137473] = 1.51515,
                [134331] = 2.27273,
                [134251] = 1.51515,
                [137486] = 1.51515,
                [137487] = 1.51515,
                [137474] = 2.27273,
                [137478] = 2.27273,
                [134739] = 3.0303,
                [137989] = 0.75758,
                [137969] = 3.0303,
                [135167] = 1.51515,
                [135204] = 1.51515,
                [135239] = 1.51515,
                [135231] = 3.0303,
                [135192] = 1.51515,
                [135235] = 1.51515,
                [134994] = 0.37879,
                [64192] = 3.0303,
            },
            {
                [133935] = 1.58228,
                [133943] = 0.31646,
                [134158] = 1.89873,
                [134174] = 1.58228,
                [134157] = 1.26582,
                [137485] = 1.26582,
                [137484] = 1.89873,
                [137473] = 1.26582,
                [134331] = 1.89873,
                [134251] = 1.26582,
                [137486] = 1.26582,
                [137487] = 1.26582,
                [137474] = 1.89873,
                [137478] = 1.89873,
                [134739] = 2.53165,
                [137989] = 0.63291,
                [137969] = 2.53165,
                [135167] = 1.26582,
                [135204] = 1.26582,
                [135239] = 1.26582,
                [135231] = 2.53165,
                [135192] = 1.26582,
                [135235] = 1.26582,
                [134994] = 0.31646,
                [64192] = 2.53165,
            },
        },
        -- Temple of Sethraliss (SnakeDungeon)
        [1877] = {
            {
                [134616] = 0.90909,
                [134600] = 1.81818,
                [134602] = 1.81818,
                [134617] = 0.45455,
                [134991] = 2.72727,
                [134990] = 1.81818,
                [134629] = 2.72727,
                [134364] = 1.81818,
                [136076] = 2.72727,
                [134599] = 1.81818,
                [134691] = 1.81818,
                [63453] = 5.45455,
                [134686] = 1.81818,
                [139422] = 2.72727,
                [135562] = 0.90909,
                [135846] = 0.90909,
                [139425] = 1.81818,
                [139110] = 2.27273,
                [139946] = 2.72727,
                [139949] = 1.81818,
                [136250] = 1.81818,
                [63063] = 1.81818,
                [139110] = 2.72727,
            },
            {
                [134616] = 0.75758,
                [134600] = 1.51515,
                [134602] = 1.51515,
                [134617] = 0.37879,
                [134991] = 2.27273,
                [134990] = 1.51515,
                [134629] = 2.27273,
                [134364] = 1.51515,
                [136076] = 2.27273,
                [134599] = 1.51515,
                [134691] = 1.51515,
                [63453] = 4.54545,
            },
        },
        -- The Underrot (UnderrotDungeon)
        [1841] = {
            {
                [131402] = 0.39683,
                [131436] = 2.38095,
                [130909] = 1.5873,
                [133663] = 1.5873,
                [131492] = 1.5873,
                [133685] = 1.5873,
                [133835] = 1.5873,
                [133852] = 1.5873,
                [133870] = 1.5873,
                [133836] = 1.5873,
                [134284] = 1.5873,
                [133912] = 2.38095,
                [138187] = 1.5873,
                [138281] = 2.38095,
            },
            {
                [131402] = 0.33223,
                [131436] = 1.99336,
                [130909] = 1.3289,
                [133663] = 1.3289,
                [131492] = 1.3289,
                [133685] = 1.3289,
                [133835] = 1.3289,
                [133852] = 1.3289,
                [133870] = 1.3289,
                [133836] = 1.3289,
                [134284] = 1.3289,
                [133912] = 1.99336,
                [138187] = 1.3289,
                [138281] = 1.99336,
            },
        },
        -- Shrine of the Storm (SeaPriestDungeon)
        [1864] = {
            {
                [134139] = 1.42566,
                [134173] = 0.20367,
                [134137] = 1.222,
                [134144] = 1.222,
                [136186] = 1.222,
                [136214] = 1.83299,
                [134150] = 1.83299,
                [136249] = 1.83299,
                [136347] = 0.20367,
                [134417] = 1.42566,
                [134338] = 1.222,
                [134418] = 1.222,
                [134423] = 0.20367,
                [136353] = 1.42566,
                [134514] = 1.222,
                [136295] = 1.83299,
                [136297] = 1.222,
                [139800] = 1.222,
                [139799] = 1.222,
                [140038] = 0.40733,
                [139626] = 0.20367,
            },
            {
                [134139] = 1.18846,
                [134173] = 0.16978,
                [134137] = 1.01868,
                [134144] = 1.01868,
                [136186] = 1.01868,
                [136214] = 1.52801,
                [134150] = 1.52801,
                [136249] = 1.52801,
                [136347] = 0.16978,
                [134417] = 1.18846,
                [134338] = 1.01868,
                [134418] = 1.01868,
                [134423] = 0.16978,
                [136353] = 1.18846,
                [134514] = 1.01868,
                [136295] = 1.52801,
                [136297] = 1.01868,
                [139626] = 0.16978,
                [140038] = 0.33956,
                [139799] = 1.01868,
                [139800] = 1.01868,
            },
        },
        -- Siege of Boralus (BoralusDungeon)
        [1822] = {
            -- Alliance
            {
                [133990] = 0.37594,
                [129372] = 1.50376,
                [129374] = 1.50376,
                [129370] = 1.50376,
                [129369] = 3.00752,
                [129371] = 1.50376,
                [129373] = 1.50376,
                [129640] = 1.50376,
                [135258] = 0.37594,
                [137521] = 1.50376,
                [128969] = 3.00752,
                [138255] = 1.50376,
                [135263] = 1.50376,
                [138464] = 1.50376,
                [138465] = 1.50376,
                [135241] = 1.50376,
                [129366] = 1.50376,
                [135245] = 3.00752,
                [129367] = 1.50376,
                [137511] = 1.50376,
                [137516] = 1.50376,
                [137517] = 1.50376,
            },
            {
                [133990] = 0.31348,
                [129372] = 1.25392,
                [129374] = 1.25392,
                [129370] = 1.25392,
                [129369] = 2.50784,
                [129371] = 1.25392,
                [129373] = 1.25392,
                [129640] = 1.25392,
                [135258] = 0.31348,
                [137521] = 1.25392,
                [128969] = 2.50784,
                [138255] = 1.25392,
                [135263] = 1.25392,
                [138464] = 1.25392,
                [138465] = 1.25392,
                [135241] = 1.25392,
                [129366] = 1.25392,
                [135245] = 2.50784,
                [129367] = 1.25392,
                [137511] = 1.25392,
                [137516] = 1.25392,
                [137517] = 1.25392,
            },
            -- Horde
            {
                [133990] = 0.3937,
                [129372] = 1.5748,
                [129374] = 1.5748,
                [129370] = 1.5748,
                [129369] = 3.14961,
                [129371] = 1.5748,
                [129373] = 1.5748,
                [129640] = 1.5748,
                [135258] = 0.3937,
                [137521] = 1.5748,
                [128969] = 3.14961,
                [138255] = 1.5748,
                [135263] = 1.5748,
                [138464] = 1.5748,
                [138465] = 1.5748,
                [135241] = 1.5748,
                [129366] = 1.5748,
                [135245] = 3.14961,
                [129367] = 1.5748,
                [137511] = 1.5748,
                [137516] = 1.5748,
                [137517] = 1.5748,
                [141495] = 0.3937,
                [141283] = 1.5748,
                [141285] = 1.5748,
            },
            {
                [133990] = 0.32895,
                [129372] = 1.31579,
                [129374] = 1.31579,
                [129370] = 1.31579,
                [129369] = 2.63158,
                [129371] = 1.31579,
                [129373] = 1.31579,
                [129640] = 1.31579,
                [135258] = 0.32895,
                [137521] = 1.31579,
                [128969] = 2.63158,
                [138255] = 1.31579,
                [135263] = 1.31579,
                [138464] = 1.31579,
                [138465] = 1.31579,
                [135241] = 1.31579,
                [129366] = 1.31579,
                [135245] = 2.63158,
                [129367] = 1.31579,
                [137511] = 1.31579,
                [137516] = 1.31579,
                [137517] = 1.31579,
                [141285] = 1.31579,
                [141283] = 1.31579,
                [141495] = 0.32895,
            },
        },
    }
end


-- Data obtained from QuestCache.wdb; filtered on (Type==0 || Type==3) && Flags&0x64!=0 && PercentAmount!=0 in order to eliminate unneeded entries
function LOP:LoadWeightDataByQuest()
    LOP.QuestBasedWeights = {
        [35637] = {
            [85260] = 0.2,
            [82675] = 0.2,
            [88445] = 0.2,
            [85261] = 1,
            [77988] = 1,
            [77991] = 1,
            [77994] = 1,
            [77997] = 1,
            [78003] = 1,
            [78778] = 1,
            [78782] = 1,
            [82711] = 1,
            [88425] = 1,
            [88430] = 1,
            [89164] = 1,
            [85265] = 2,
            [82531] = 3,
            [77992] = 3,
            [77993] = 3,
            [77995] = 3,
            [78578] = 3,
            [88437] = 3,
            [88459] = 3,
            [85262] = 8,
            [85263] = 20,
            [82614] = 20,
            [82616] = 20,
            [82617] = 20,
            [82618] = 20,
            [82620] = 20,
        },
        [35641] = {
            [85260] = 0.2,
            [82675] = 0.2,
            [88445] = 0.2,
            [85261] = 1,
            [77988] = 1,
            [77991] = 1,
            [77994] = 1,
            [77997] = 1,
            [78003] = 1,
            [78778] = 1,
            [78782] = 1,
            [82711] = 1,
            [88425] = 1,
            [88430] = 1,
            [89164] = 1,
            [85265] = 2,
            [82531] = 3,
            [77992] = 3,
            [77993] = 3,
            [77995] = 3,
            [78578] = 3,
            [88437] = 3,
            [88459] = 3,
            [85262] = 8,
            [85263] = 20,
            [82614] = 20,
            [82616] = 20,
            [82617] = 20,
            [82618] = 20,
            [82620] = 20,
        },
        [35974] = {
            [85726] = 10,
            [85555] = 10,
            [85568] = 10,
            [85726] = 10,
            [85837] = 10,
            [85728] = 3,
            [85727] = 2,
            [78409] = 2,
            [78410] = 2,
            [78973] = 2,
            [83800] = 1,
            [75280] = 1,
            [78148] = 1,
            [78168] = 1,
            [78475] = 1,
            [78550] = 1,
            [84002] = 1,
            [85098] = 1,
            [85150] = 1,
            [85357] = 1,
            [87487] = 1,
            [78190] = 1,
            [78328] = 1,
            [78339] = 1,
            [78999] = 1,
            [87486] = 1,
            [87489] = 1,
            [85729] = 0.3,
            [78324] = 0.3,
            [84927] = 0.3,
            [78183] = 1,
        },
        [35977] = {
            [85726] = 10,
            [85555] = 10,
            [85568] = 10,
            [85726] = 10,
            [85837] = 10,
            [85728] = 3,
            [85727] = 2,
            [78409] = 2,
            [78410] = 2,
            [78973] = 2,
            [83800] = 1,
            [75280] = 1,
            [78148] = 1,
            [78168] = 1,
            [78475] = 1,
            [78550] = 1,
            [84002] = 1,
            [85098] = 1,
            [85150] = 1,
            [85357] = 1,
            [87487] = 1,
            [78190] = 1,
            [78328] = 1,
            [78339] = 1,
            [78999] = 1,
            [87486] = 1,
            [87489] = 1,
            [85729] = 0.3,
            [78324] = 0.3,
            [84927] = 0.3,
            [78183] = 1,
        },
        [36069] = {
            [84010] = 1,
            [88960] = 0.1,
            [83973] = 0.1,
            [83974] = 0.1,
            [83975] = 0.1,
            [83976] = 0.1,
            [83977] = 0.1,
            [83978] = 0.1,
            [83979] = 0.1,
            [83980] = 0.1,
            [83981] = 0.1,
            [83982] = 0.1,
            [83983] = 0.1,
            [83984] = 0.1,
            [83987] = 0.1,
            [83988] = 0.1,
            [83989] = 0.1,
            [83990] = 0.1,
            [83991] = 0.1,
            [83992] = 0.1,
            [83993] = 0.1,
            [83994] = 0.1,
            [84013] = 0.1,
            [84016] = 0.1,
            [84039] = 0.1,
            [84082] = 0.1,
            [84083] = 0.1,
            [84156] = 0.1,
            [84172] = 0.1,
            [84231] = 0.1,
            [84298] = 0.1,
            [84303] = 0.1,
            [84467] = 0.1,
            [85542] = 0.1,
            [87656] = 0.1,
            [88078] = 0.1,
            [88079] = 0.1,
            [89083] = 0.1,
            [89084] = 0.1,
            [89085] = 0.1,
            [91933] = 0.1,
            [91934] = 0.1,
            [94495] = 0.1,
            [83990] = 30,
            [83975] = 4,
            [83980] = 4,
            [83983] = 4,
            [83976] = 3,
            [83982] = 3,
            [83984] = 3,
        },
        [36070] = {
            [84010] = 1,
            [88960] = 0.1,
            [83973] = 0.1,
            [83974] = 0.1,
            [83975] = 0.1,
            [83976] = 0.1,
            [83977] = 0.1,
            [83978] = 0.1,
            [83979] = 0.1,
            [83980] = 0.1,
            [83981] = 0.1,
            [83982] = 0.1,
            [83983] = 0.1,
            [83984] = 0.1,
            [83987] = 0.1,
            [83988] = 0.1,
            [83989] = 0.1,
            [83990] = 0.1,
            [83991] = 0.1,
            [83992] = 0.1,
            [83993] = 0.1,
            [83994] = 0.1,
            [84013] = 0.1,
            [84016] = 0.1,
            [84039] = 0.1,
            [84082] = 0.1,
            [84083] = 0.1,
            [84156] = 0.1,
            [84172] = 0.1,
            [84231] = 0.1,
            [84298] = 0.1,
            [84303] = 0.1,
            [84467] = 0.1,
            [85542] = 0.1,
            [87656] = 0.1,
            [88078] = 0.1,
            [88079] = 0.1,
            [89083] = 0.1,
            [89084] = 0.1,
            [89085] = 0.1,
            [91933] = 0.1,
            [91934] = 0.1,
            [94495] = 0.1,
            [83990] = 30,
            [83975] = 4,
            [83980] = 4,
            [83983] = 4,
            [83976] = 3,
            [83982] = 3,
            [83984] = 12,
        },
        [36338] = {
            [85197] = 0.2,
            [84027] = 0.2,
            [84283] = 0.2,
            [84442] = 0.2,
            [84445] = 0.2,
            [84446] = 0.2,
            [85191] = 0.2,
            [85490] = 0.2,
            [85498] = 0.2,
            [85966] = 0.2,
            [85000] = 1,
            [82922] = 1,
            [82934] = 1,
            [82960] = 1,
            [83004] = 1,
            [83017] = 1,
            [83023] = 1,
            [84026] = 1,
            [84055] = 1,
            [84094] = 1,
            [84095] = 1,
            [84096] = 1,
            [84099] = 1,
            [84112] = 1,
            [84180] = 1,
            [84266] = 1,
            [84334] = 1,
            [84447] = 1,
            [84448] = 1,
            [84449] = 1,
            [84870] = 1,
            [84871] = 1,
            [84873] = 1,
            [87337] = 1,
            [87340] = 1,
            [87576] = 1,
            [88043] = 1,
            [88071] = 1,
            [88494] = 1,
            [85195] = 3,
            [82928] = 3,
            [82964] = 3,
            [82990] = 3,
            [83018] = 3,
            [84105] = 3,
            [84142] = 3,
            [84181] = 3,
            [84278] = 3,
            [84337] = 3,
            [84367] = 3,
            [84880] = 3,
            [85200] = 25,
            [82992] = 25,
            [83008] = 25,
            [83019] = 25,
            [87597] = 25,
            [84754] = 2.25,
            [83856] = 2,
            [84279] = 2,
            [84992] = 2,
            [85370] = 10,
            [84997] = 3,
            [85393] = 1,
            [88875] = 1,
            [88876] = 1,
            [88877] = 1,
            [88878] = 1,
            [88879] = 1,
            [85103] = 3,
            [86448] = 3,
        },
        [36347] = {
            [85079] = 0.2,
            [84999] = 0.2,
            [85478] = 0.2,
            [86269] = 0.2,
            [88264] = 0.2,
            [88486] = 0.2,
            [85319] = 1,
            [81541] = 1,
            [81605] = 1,
            [84888] = 1,
            [85168] = 1,
            [81542] = 1.3,
            [86024] = 1.3,
            [84945] = 3,
            [84908] = 5,
            [81543] = 6.5,
            [85321] = 25,
            [84911] = 25,
            [84925] = 25,
            [85001] = 25,
            [85029] = 25,
            [85035] = 25,
            [85121] = 25,
            [86212] = 25,
            [86213] = 25,
        },
        [36348] = {
            [85079] = 0.2,
            [84999] = 0.2,
            [85478] = 0.2,
            [86269] = 0.2,
            [88264] = 0.2,
            [88486] = 0.2,
            [85319] = 1,
            [81541] = 1,
            [81605] = 1,
            [84888] = 1,
            [85168] = 1,
            [81542] = 1.3,
            [86024] = 1.3,
            [84945] = 3,
            [84908] = 5,
            [81543] = 6.5,
            [85321] = 25,
            [84911] = 25,
            [84925] = 25,
            [85001] = 25,
            [85029] = 25,
            [85035] = 25,
            [85121] = 25,
            [86212] = 25,
            [86213] = 25,
        },
        [36383] = {
            [85228] = 1,
            [85124] = 1,
            [85126] = 1,
            [85127] = 1,
            [85128] = 1,
            [85177] = 1,
            [85180] = 1,
            [85184] = 1,
            [86405] = 1,
            [86500] = 1,
            [86528] = 1,
            [86536] = 1,
            [87439] = 1,
            [85229] = 5,
            [85123] = 5,
            [85136] = 5,
            [86499] = 5,
            [87440] = 5,
            [85230] = 20,
            [86562] = 20,
            [86566] = 20,
            [86571] = 20,
            [86574] = 20,
            [86577] = 20,
            [86579] = 20,
            [86582] = 20,
            [86298] = 0.5,
            [85277] = 0.5,
            [86297] = 0.5,
            [86332] = 0.5,
            [87438] = 0.5,
        },
        [36489] = {
            [85228] = 1,
            [85124] = 1,
            [85126] = 1,
            [85127] = 1,
            [85128] = 1,
            [85177] = 1,
            [85180] = 1,
            [85184] = 1,
            [86405] = 1,
            [86500] = 1,
            [86528] = 1,
            [86536] = 1,
            [87439] = 1,
            [85229] = 5,
            [85123] = 5,
            [85136] = 5,
            [86499] = 5,
            [87440] = 5,
            [85230] = 20,
            [86562] = 20,
            [86566] = 20,
            [86571] = 20,
            [86574] = 20,
            [86577] = 20,
            [86579] = 20,
            [86582] = 20,
            [86298] = 0.5,
            [85277] = 0.5,
            [86297] = 0.5,
            [86332] = 0.5,
            [87438] = 0.5,
        },
        [36490] = {
            [86556] = 0.5,
            [86550] = 0.5,
            [85609] = 1,
            [85043] = 1,
            [85066] = 1,
            [85068] = 1,
            [85073] = 1,
            [85075] = 1,
            [85082] = 1,
            [85204] = 1,
            [85515] = 1,
            [85697] = 1,
            [86059] = 1,
            [86128] = 1,
            [86198] = 1,
            [86323] = 1,
            [85607] = 2.5,
            [85034] = 2.5,
            [85299] = 2.5,
            [86099] = 2.5,
            [86179] = 2.5,
            [86324] = 2.5,
            [87639] = 2.5,
            [85608] = 5,
            [85303] = 5,
            [85304] = 5,
            [85392] = 5,
            [86271] = 5,
            [85610] = 8,
            [85026] = 8,
            [85078] = 8,
            [85451] = 8,
            [85611] = 12,
            [85036] = 12,
            [85037] = 20,
        },
        [36491] = {
            [86556] = 0.5,
            [86550] = 0.5,
            [85609] = 1,
            [85043] = 1,
            [85066] = 1,
            [85068] = 1,
            [85073] = 1,
            [85075] = 1,
            [85082] = 1,
            [85204] = 1,
            [85515] = 1,
            [85697] = 1,
            [86059] = 1,
            [86128] = 1,
            [86198] = 1,
            [86323] = 1,
            [85607] = 2.5,
            [85034] = 2.5,
            [85299] = 2.5,
            [86099] = 2.5,
            [86179] = 2.5,
            [86324] = 2.5,
            [87639] = 2.5,
            [85608] = 5,
            [85303] = 5,
            [85304] = 5,
            [85392] = 5,
            [86271] = 5,
            [85610] = 8,
            [85026] = 8,
            [85078] = 8,
            [85451] = 8,
            [85611] = 12,
            [85036] = 12,
            [85037] = 20,
        },
        [36807] = {
            [87378] = 0.3,
            [86139] = 0.3,
            [86192] = 0.3,
            [86529] = 0.3,
            [86530] = 0.3,
            [86531] = 0.3,
            [87370] = 1,
            [82940] = 1,
            [82981] = 1,
            [82983] = 1,
            [83011] = 1,
            [83013] = 1,
            [83020] = 1,
            [83021] = 1,
            [86190] = 1,
            [86191] = 1,
            [86515] = 1,
            [86553] = 1,
            [86591] = 1,
            [86600] = 1,
            [86838] = 1,
            [87341] = 1,
            [87498] = 1,
            [87875] = 1,
            [87876] = 1,
            [87371] = 3,
            [82921] = 3,
            [82996] = 3,
            [82997] = 3,
            [86140] = 3,
            [86745] = 3,
            [86807] = 3,
            [88941] = 3,
            [87377] = 20,
            [82920] = 20,
            [82930] = 20,
            [82942] = 20,
            [82988] = 20,
            [82998] = 20,
            [87668] = 20,
            [88436] = 20,
            [88728] = 20,
            [87373] = 3,
            [87364] = 1.5,
            [86869] = 0.75,
            [86599] = 4,
            [88407] = 3,
            [88405] = 2,
        },
        [36808] = {
            [85197] = 0.2,
            [84027] = 0.2,
            [84283] = 0.2,
            [84442] = 0.2,
            [84445] = 0.2,
            [84446] = 0.2,
            [85191] = 0.2,
            [85490] = 0.2,
            [85498] = 0.2,
            [85966] = 0.2,
            [85000] = 1,
            [82922] = 1,
            [82934] = 1,
            [82960] = 1,
            [83004] = 1,
            [83017] = 1,
            [83023] = 1,
            [84026] = 1,
            [84055] = 1,
            [84094] = 1,
            [84095] = 1,
            [84096] = 1,
            [84099] = 1,
            [84112] = 1,
            [84180] = 1,
            [84266] = 1,
            [84334] = 1,
            [84447] = 1,
            [84448] = 1,
            [84449] = 1,
            [84870] = 1,
            [84871] = 1,
            [84873] = 1,
            [87337] = 1,
            [87340] = 1,
            [87576] = 1,
            [88043] = 1,
            [88071] = 1,
            [88494] = 1,
            [85195] = 3,
            [82928] = 3,
            [82964] = 3,
            [82990] = 3,
            [83018] = 3,
            [84105] = 3,
            [84142] = 3,
            [84181] = 3,
            [84278] = 3,
            [84337] = 3,
            [84367] = 3,
            [84880] = 3,
            [85200] = 25,
            [82992] = 25,
            [83008] = 25,
            [83019] = 25,
            [87597] = 25,
            [84754] = 2.25,
            [83856] = 2,
            [84279] = 2,
            [84992] = 2,
            [85370] = 10,
            [84997] = 3,
            [85393] = 1,
            [88875] = 1,
            [88876] = 1,
            [88877] = 1,
            [88878] = 1,
            [88879] = 1,
            [85103] = 3,
            [86448] = 3,
        },
        [36809] = {
            [87378] = 0.3,
            [86139] = 0.3,
            [86192] = 0.3,
            [86529] = 0.3,
            [86530] = 0.3,
            [86531] = 0.3,
            [87370] = 1,
            [82940] = 1,
            [82981] = 1,
            [82983] = 1,
            [83011] = 1,
            [83013] = 1,
            [83020] = 1,
            [83021] = 1,
            [86190] = 1,
            [86191] = 1,
            [86515] = 1,
            [86553] = 1,
            [86591] = 1,
            [86600] = 1,
            [86838] = 1,
            [87341] = 1,
            [87498] = 1,
            [87875] = 1,
            [87876] = 1,
            [87372] = 3,
            [87377] = 20,
            [82920] = 20,
            [82930] = 20,
            [82942] = 20,
            [82988] = 20,
            [82998] = 20,
            [87668] = 20,
            [88436] = 20,
            [88728] = 20,
            [87373] = 3,
            [87364] = 1.5,
            [86869] = 3,
            [86599] = 4,
            [88407] = 3,
            [88405] = 2,
        },
        [36811] = {
            [90660] = 0.5,
            [90659] = 1.5,
            [89731] = 1.5,
            [90661] = 1.5,
            [103162] = 1.5,
            [103180] = 1.5,
            [103231] = 1.5,
            [119515] = 1.5,
            [119516] = 1.5,
            [119517] = 1.5,
            [103176] = 2.5,
            [103363] = 2.5,
            [119466] = 2.5,
            [90662] = 25,
            [90663] = 25,
            [106629] = 25,
        },
        [36814] = {
            [88278] = 0.25,
            [88729] = 0.25,
            [89049] = 0.25,
            [88174] = 1,
            [86261] = 1,
            [86263] = 1,
            [86264] = 1,
            [86267] = 1,
            [88261] = 1,
            [88279] = 1,
            [88394] = 1,
            [88828] = 1,
            [89019] = 1,
            [88175] = 5,
            [86258] = 5,
            [86259] = 5,
            [86260] = 5,
            [86262] = 5,
            [86265] = 5,
            [88176] = 20,
            [82058] = 20,
            [86257] = 20,
            [86266] = 20,
            [86268] = 20,
            [87626] = 20,
            [88580] = 20,
            [88582] = 20,
            [88583] = 20,
            [88586] = 20,
            [88672] = 20,
        },
        [36815] = {
            [88278] = 0.25,
            [88729] = 0.25,
            [89049] = 0.25,
            [88174] = 1,
            [86261] = 1,
            [86263] = 1,
            [86264] = 1,
            [86267] = 1,
            [88261] = 1,
            [88279] = 1,
            [88394] = 1,
            [88828] = 1,
            [89019] = 1,
            [88175] = 5,
            [86258] = 5,
            [86259] = 5,
            [86260] = 5,
            [86262] = 5,
            [86265] = 5,
            [88176] = 20,
            [82058] = 20,
            [86257] = 20,
            [86266] = 20,
            [86268] = 20,
            [87626] = 20,
            [88580] = 20,
            [88582] = 20,
            [88583] = 20,
            [88586] = 20,
            [88672] = 20,
        },
        [36816] = {
            [87640] = 1,
            [83645] = 1,
            [88116] = 1,
            [83575] = 1,
            [83577] = 1,
            [83641] = 1,
            [87642] = 4,
            [83570] = 4,
            [83655] = 4,
            [83831] = 4,
            [87538] = 4,
            [87638] = 4,
            [83640] = 4,
            [87644] = 8,
            [83848] = 8,
            [87654] = 8,
            [88187] = 8,
            [87645] = 15,
            [87788] = 15,
            [87837] = 15,
            [87646] = 18,
            [87846] = 18,
            [88116] = 4,
        },
        [36817] = {
            [87640] = 1,
            [83645] = 1,
            [88116] = 1,
            [83575] = 1,
            [83577] = 1,
            [83641] = 1,
            [87642] = 4,
            [83570] = 4,
            [83655] = 4,
            [83831] = 4,
            [87538] = 4,
            [87638] = 4,
            [83640] = 4,
            [87644] = 8,
            [83848] = 8,
            [87654] = 8,
            [88187] = 8,
            [87645] = 15,
            [87788] = 15,
            [87837] = 15,
            [87646] = 18,
            [87846] = 18,
            [88116] = 4,
        },
        [36818] = {
            [86955] = 1,
            [72571] = 1,
            [86656] = 1,
            [86657] = 1,
            [86660] = 1,
            [87264] = 1,
            [86957] = 3,
            [83049] = 3,
            [86659] = 3,
            [87385] = 3,
            [86958] = 8,
            [86658] = 8,
            [86960] = 8,
            [87239] = 8,
            [87344] = 8,
            [87584] = 8,
            [87574] = 15,
            [86959] = 15,
            [87234] = 15,
            [86960] = 20,
            [86992] = 6,
            [87017] = 6,
            [87024] = 6,
            [86947] = 2,
            [87389] = 2,
            [87264] = 2,
        },
        [36819] = {
            [86955] = 1,
            [72571] = 1,
            [86656] = 1,
            [86657] = 1,
            [86660] = 1,
            [87264] = 1,
            [86957] = 3,
            [83049] = 3,
            [86659] = 3,
            [87385] = 3,
            [86958] = 8,
            [86658] = 8,
            [86960] = 8,
            [87239] = 8,
            [87344] = 8,
            [87584] = 8,
            [87574] = 15,
            [86959] = 15,
            [87234] = 15,
            [86960] = 20,
            [86992] = 6,
            [87017] = 6,
            [87024] = 6,
            [86947] = 2,
            [87389] = 2,
            [87264] = 2,
        },
        [36820] = {
            [88200] = 4,
            [84760] = 4,
            [87310] = 4,
            [88199] = 4,
            [88478] = 4,
            [88496] = 4,
            [88497] = 4,
            [88498] = 4,
            [88523] = 4,
            [88524] = 4,
            [88525] = 4,
            [88906] = 4,
            [88930] = 4,
            [88946] = 4,
            [88201] = 8,
            [84764] = 8,
            [84765] = 8,
            [88202] = 12,
            [88207] = 12,
            [88208] = 12,
            [88203] = 30,
            [88209] = 30,
            [88204] = 60,
            [88210] = 60,
            [88931] = 4,
        },
        [36821] = {
            [88200] = 4,
            [84760] = 4,
            [87310] = 4,
            [88199] = 4,
            [88478] = 4,
            [88496] = 4,
            [88497] = 4,
            [88498] = 4,
            [88523] = 4,
            [88524] = 4,
            [88525] = 4,
            [88906] = 4,
            [88930] = 4,
            [88946] = 4,
            [88201] = 8,
            [84764] = 8,
            [84765] = 8,
            [88202] = 12,
            [88207] = 12,
            [88208] = 12,
            [88203] = 30,
            [88209] = 30,
            [88204] = 60,
            [88210] = 60,
            [88931] = 4,
        },
        [36822] = {
            [87624] = 0.75,
            [87610] = 1.5,
            [77175] = 1.5,
            [77940] = 1.5,
            [77944] = 1.5,
            [77945] = 1.5,
            [78223] = 1.5,
            [85973] = 1.5,
            [85997] = 1.5,
            [87618] = 5,
            [78210] = 5,
            [78231] = 5,
            [84378] = 5,
            [84379] = 5,
            [84384] = 5,
            [86373] = 5,
            [87600] = 5,
            [87621] = 15,
            [84374] = 15,
            [84376] = 15,
            [84392] = 15,
            [87622] = 15,
            [84384] = 20,
            [88860] = 2,
        },
        [36823] = {
            [87624] = 0.75,
            [87610] = 1.5,
            [77175] = 1.5,
            [77940] = 1.5,
            [77944] = 1.5,
            [77945] = 1.5,
            [78223] = 1.5,
            [85973] = 1.5,
            [85997] = 1.5,
            [87618] = 5,
            [78210] = 5,
            [78231] = 5,
            [84378] = 5,
            [84379] = 5,
            [84384] = 5,
            [86373] = 5,
            [87600] = 5,
            [87621] = 15,
            [84374] = 15,
            [84376] = 15,
            [84392] = 15,
            [87622] = 15,
            [84384] = 20,
            [88860] = 2,
        },
        [36826] = {
            [87507] = 0.2,
            [87330] = 0.2,
            [87360] = 0.2,
            [87588] = 0.2,
            [87838] = 0.2,
            [87513] = 1,
            [72297] = 1,
            [72348] = 1,
            [87332] = 1,
            [87345] = 1,
            [87974] = 1,
            [87986] = 1,
            [87514] = 2,
            [76905] = 2,
            [87383] = 0.1,
            [87512] = 4,
            [87346] = 4,
            [87511] = 15,
            [78265] = 15,
            [87348] = 15,
            [72364] = 15,
            [87351] = 15,
            [87352] = 15,
            [87742] = 20,
            [87356] = 20,
            [87357] = 20,
            [87510] = 2,
            [87333] = 3,
            [76905] = 3,
        },
        [36827] = {
            [87507] = 0.2,
            [87330] = 0.2,
            [87360] = 0.2,
            [87588] = 0.2,
            [87838] = 0.2,
            [87513] = 1,
            [72297] = 1,
            [72348] = 1,
            [87332] = 1,
            [87345] = 1,
            [87974] = 1,
            [87986] = 1,
            [87513] = 2,
            [72297] = 2,
            [72348] = 2,
            [87332] = 2,
            [87345] = 2,
            [87974] = 2,
            [87986] = 2,
            [87383] = 0.1,
            [87512] = 4,
            [87346] = 4,
            [87511] = 15,
            [78265] = 15,
            [87348] = 15,
            [72364] = 15,
            [87351] = 15,
            [87352] = 15,
            [87742] = 20,
            [87356] = 20,
            [87357] = 20,
            [87510] = 2,
            [87333] = 3,
            [76905] = 3,
        },
        [36860] = {
            [87030] = 0.5,
            [87031] = 0.5,
            [87032] = 0.5,
            [87033] = 0.5,
            [87034] = 1,
            [87036] = 2,
            [86558] = 4,
            [86559] = 3,
            [87037] = 0.5,
            [87038] = 0.5,
            [86560] = 2,
            [88260] = 5,
            [89095] = 0.5,
            [86144] = 0.5,
            [86155] = 0.5,
            [86163] = 0.5,
            [86168] = 0.5,
            [86204] = 0.5,
            [86205] = 0.5,
            [86206] = 0.5,
            [86207] = 0.5,
            [86211] = 0.5,
            [86215] = 0.5,
            [86216] = 0.5,
            [86617] = 0.5,
            [86620] = 0.5,
            [86621] = 0.5,
            [87019] = 0.5,
            [87026] = 0.5,
            [87027] = 0.5,
            [87029] = 0.5,
            [87220] = 0.5,
            [89125] = 0.5,
            [89126] = 0.5,
            [89127] = 0.5,
            [89128] = 0.5,
            [89144] = 0.5,
            [87029] = 30,
            [87026] = 30,
            [87019] = 30,
            [86621] = 30,
            [87027] = 30,
        },
        [37466] = {
            [91287] = 1,
            [91284] = 3,
            [88086] = 3,
            [88087] = 3,
            [91285] = 7,
            [91459] = 7,
            [107447] = 7,
            [117483] = 7,
            [91286] = 10,
            [89846] = 10,
            [107127] = 10,
            [91449] = 4,
        },
        [37495] = {
            [90109] = 2.5,
            [89097] = 20,
            [112018] = 4,
        },
        [37585] = {
            [87624] = 0.75,
            [87610] = 1.5,
            [77175] = 1.5,
            [77940] = 1.5,
            [77944] = 1.5,
            [77945] = 1.5,
            [78223] = 1.5,
            [85973] = 1.5,
            [85997] = 1.5,
            [87618] = 5,
            [78210] = 5,
            [78231] = 5,
            [84378] = 5,
            [84379] = 5,
            [84384] = 5,
            [86373] = 5,
            [87600] = 5,
            [87621] = 15,
            [84374] = 15,
            [84376] = 15,
            [84392] = 15,
            [87622] = 15,
            [84384] = 20,
            [88860] = 2,
        },
        [37622] = {
            [87624] = 0.75,
            [87610] = 1.5,
            [77175] = 1.5,
            [77940] = 1.5,
            [77944] = 1.5,
            [77945] = 1.5,
            [78223] = 1.5,
            [85973] = 1.5,
            [85997] = 1.5,
            [87618] = 5,
            [78210] = 5,
            [78231] = 5,
            [84378] = 5,
            [84379] = 5,
            [84384] = 5,
            [86373] = 5,
            [87600] = 5,
            [87621] = 15,
            [84374] = 15,
            [84376] = 15,
            [84392] = 15,
            [87622] = 15,
            [84384] = 20,
            [88860] = 2,
        },
        [37623] = {
            [85260] = 0.4,
            [82675] = 0.4,
            [88445] = 0.4,
            [85261] = 2,
            [77988] = 2,
            [77991] = 2,
            [77994] = 2,
            [77997] = 2,
            [78003] = 2,
            [78778] = 2,
            [78782] = 2,
            [82711] = 2,
            [88425] = 2,
            [88430] = 2,
            [89164] = 2,
            [85265] = 4,
            [82531] = 6,
            [77992] = 6,
            [77993] = 6,
            [77995] = 6,
            [78578] = 6,
            [88437] = 6,
            [88459] = 6,
            [85262] = 12,
            [85263] = 25,
            [82614] = 25,
            [82616] = 25,
            [82617] = 25,
            [82618] = 25,
            [82620] = 25,
        },
        [37624] = {
            [85260] = 0.4,
            [82675] = 0.4,
            [88445] = 0.4,
            [85261] = 2,
            [77988] = 2,
            [77991] = 2,
            [77994] = 2,
            [77997] = 2,
            [78003] = 2,
            [78778] = 2,
            [78782] = 2,
            [82711] = 2,
            [88425] = 2,
            [88430] = 2,
            [89164] = 2,
            [85265] = 4,
            [82531] = 6,
            [77992] = 6,
            [77993] = 6,
            [77995] = 6,
            [78578] = 6,
            [88437] = 6,
            [88459] = 6,
            [85262] = 12,
            [85263] = 25,
            [82614] = 25,
            [82616] = 25,
            [82617] = 25,
            [82618] = 25,
            [82620] = 25,
        },
        [37626] = {
            [87507] = 0.2,
            [87330] = 0.2,
            [87360] = 0.2,
            [87588] = 0.2,
            [87838] = 0.2,
            [87513] = 1,
            [72297] = 1,
            [72348] = 1,
            [87332] = 1,
            [87345] = 1,
            [87974] = 1,
            [87986] = 1,
            [87513] = 2,
            [72297] = 2,
            [72348] = 2,
            [87332] = 2,
            [87345] = 2,
            [87974] = 2,
            [87986] = 2,
            [87383] = 0.1,
            [87512] = 4,
            [87346] = 4,
            [87511] = 15,
            [78265] = 15,
            [87348] = 15,
            [72364] = 15,
            [87351] = 15,
            [87352] = 15,
            [87742] = 20,
            [87356] = 20,
            [87357] = 20,
            [87510] = 3,
            [87333] = 3,
            [76905] = 3,
        },
        [37627] = {
            [87640] = 1,
            [83645] = 1,
            [88116] = 1,
            [83575] = 1,
            [83577] = 1,
            [83641] = 1,
            [87642] = 4,
            [83570] = 4,
            [83655] = 4,
            [83831] = 4,
            [87538] = 4,
            [87638] = 4,
            [83640] = 4,
            [87644] = 8,
            [83848] = 8,
            [87654] = 8,
            [88187] = 8,
            [87645] = 15,
            [87788] = 15,
            [87837] = 15,
            [87646] = 18,
            [87846] = 18,
            [88116] = 4,
        },
        [37628] = {
            [87640] = 1,
            [83645] = 1,
            [88116] = 1,
            [83575] = 1,
            [83577] = 1,
            [83641] = 1,
            [87642] = 4,
            [83570] = 4,
            [83655] = 4,
            [83831] = 4,
            [87538] = 4,
            [87638] = 4,
            [83640] = 4,
            [87644] = 8,
            [83848] = 8,
            [87654] = 8,
            [88187] = 8,
            [87645] = 15,
            [87788] = 15,
            [87837] = 15,
            [87646] = 18,
            [87846] = 18,
            [88116] = 4,
        },
        [37629] = {
            [86955] = 1,
            [72571] = 1,
            [86656] = 1,
            [86657] = 1,
            [86660] = 1,
            [87264] = 1,
            [86957] = 3,
            [83049] = 3,
            [86659] = 3,
            [87385] = 3,
            [86958] = 8,
            [86658] = 8,
            [86960] = 8,
            [87239] = 8,
            [87344] = 8,
            [87584] = 8,
            [87574] = 15,
            [86959] = 15,
            [87234] = 15,
            [86960] = 20,
            [86992] = 6,
            [87017] = 6,
            [87024] = 6,
            [86947] = 2,
            [87389] = 2,
            [87264] = 2,
        },
        [37630] = {
            [86955] = 1,
            [72571] = 1,
            [86656] = 1,
            [86657] = 1,
            [86660] = 1,
            [87264] = 1,
            [86957] = 3,
            [83049] = 3,
            [86659] = 3,
            [87385] = 3,
            [86958] = 8,
            [86658] = 8,
            [86960] = 8,
            [87239] = 8,
            [87344] = 8,
            [87584] = 8,
            [87574] = 15,
            [86959] = 15,
            [87234] = 15,
            [86960] = 20,
            [86992] = 6,
            [87017] = 6,
            [87024] = 6,
            [86947] = 2,
            [87389] = 2,
            [87264] = 2,
        },
        [37631] = {
            [85079] = 0.2,
            [84999] = 0.2,
            [85478] = 0.2,
            [86269] = 0.2,
            [88264] = 0.2,
            [88486] = 0.2,
            [85319] = 1,
            [81541] = 1,
            [81605] = 1,
            [84888] = 1,
            [85168] = 1,
            [81542] = 1.3,
            [86024] = 1.3,
            [84945] = 3,
            [84908] = 5,
            [81543] = 6.5,
            [85321] = 25,
            [84911] = 25,
            [84925] = 25,
            [85001] = 25,
            [85029] = 25,
            [85035] = 25,
            [85121] = 25,
            [86212] = 25,
            [86213] = 25,
        },
        [37632] = {
            [85079] = 0.2,
            [84999] = 0.2,
            [85478] = 0.2,
            [86269] = 0.2,
            [88264] = 0.2,
            [88486] = 0.2,
            [85319] = 1,
            [81541] = 1,
            [81605] = 1,
            [84888] = 1,
            [85168] = 1,
            [81542] = 1.3,
            [86024] = 1.3,
            [84945] = 3,
            [84908] = 5,
            [81543] = 6.5,
            [85321] = 25,
            [84911] = 25,
            [84925] = 25,
            [85001] = 25,
            [85029] = 25,
            [85035] = 25,
            [85121] = 25,
            [86212] = 25,
            [86213] = 25,
        },
        [37633] = {
            [85726] = 15,
            [85555] = 15,
            [85568] = 15,
            [85726] = 15,
            [85837] = 15,
            [85728] = 4.5,
            [85727] = 3,
            [78409] = 3,
            [78410] = 3,
            [78973] = 3,
            [83800] = 1.5,
            [75280] = 1.5,
            [78148] = 1.5,
            [78168] = 1.5,
            [78475] = 1.5,
            [78550] = 1.5,
            [84002] = 1.5,
            [85098] = 1.5,
            [85150] = 1.5,
            [85357] = 1.5,
            [87487] = 1.5,
            [78190] = 1.5,
            [78328] = 1.5,
            [78339] = 1.5,
            [78999] = 1.5,
            [87486] = 1.5,
            [87489] = 1.5,
            [85729] = 0.45,
            [78324] = 0.45,
            [84927] = 0.45,
            [78183] = 1.5,
        },
        [37634] = {
            [85726] = 15,
            [85555] = 15,
            [85568] = 15,
            [85726] = 15,
            [85837] = 15,
            [85728] = 4.5,
            [85727] = 3,
            [78409] = 3,
            [78410] = 3,
            [78973] = 3,
            [83800] = 1.5,
            [75280] = 1.5,
            [78148] = 1.5,
            [78168] = 1.5,
            [78475] = 1.5,
            [78550] = 1.5,
            [84002] = 1.5,
            [85098] = 1.5,
            [85150] = 1.5,
            [85357] = 1.5,
            [87487] = 1.5,
            [78190] = 1.5,
            [78328] = 1.5,
            [78339] = 1.5,
            [78999] = 1.5,
            [87486] = 1.5,
            [87489] = 1.5,
            [85729] = 0.45,
            [78324] = 0.45,
            [84927] = 0.45,
            [78183] = 1.5,
        },
        [37635] = {
            [85197] = 0.2,
            [84027] = 0.2,
            [84283] = 0.2,
            [84442] = 0.2,
            [84445] = 0.2,
            [84446] = 0.2,
            [85191] = 0.2,
            [85490] = 0.2,
            [85498] = 0.2,
            [85966] = 0.2,
            [85000] = 1,
            [82922] = 1,
            [82934] = 1,
            [82960] = 1,
            [83004] = 1,
            [83017] = 1,
            [83023] = 1,
            [84026] = 1,
            [84055] = 1,
            [84094] = 1,
            [84095] = 1,
            [84096] = 1,
            [84099] = 1,
            [84112] = 1,
            [84180] = 1,
            [84266] = 1,
            [84334] = 1,
            [84447] = 1,
            [84448] = 1,
            [84449] = 1,
            [84870] = 1,
            [84871] = 1,
            [84873] = 1,
            [87337] = 1,
            [87340] = 1,
            [87576] = 1,
            [88043] = 1,
            [88071] = 1,
            [88494] = 1,
            [85195] = 3,
            [82928] = 3,
            [82964] = 3,
            [82990] = 3,
            [83018] = 3,
            [84105] = 3,
            [84142] = 3,
            [84181] = 3,
            [84278] = 3,
            [84337] = 3,
            [84367] = 3,
            [84880] = 3,
            [85200] = 25,
            [82992] = 25,
            [83008] = 25,
            [83019] = 25,
            [87597] = 25,
            [84754] = 2.25,
            [83856] = 2,
            [84279] = 2,
            [84992] = 2,
            [85370] = 10,
            [84997] = 3,
            [85393] = 1,
            [88875] = 1,
            [88876] = 1,
            [88877] = 1,
            [88878] = 1,
            [88879] = 1,
            [85103] = 3,
            [86448] = 3,
        },
        [37636] = {
            [85197] = 0.2,
            [84027] = 0.2,
            [84283] = 0.2,
            [84442] = 0.2,
            [84445] = 0.2,
            [84446] = 0.2,
            [85191] = 0.2,
            [85490] = 0.2,
            [85498] = 0.2,
            [85966] = 0.2,
            [85000] = 1,
            [82922] = 1,
            [82934] = 1,
            [82960] = 1,
            [83004] = 1,
            [83017] = 1,
            [83023] = 1,
            [84026] = 1,
            [84055] = 1,
            [84094] = 1,
            [84095] = 1,
            [84096] = 1,
            [84099] = 1,
            [84112] = 1,
            [84180] = 1,
            [84266] = 1,
            [84334] = 1,
            [84447] = 1,
            [84448] = 1,
            [84449] = 1,
            [84870] = 1,
            [84871] = 1,
            [84873] = 1,
            [87337] = 1,
            [87340] = 1,
            [87576] = 1,
            [88043] = 1,
            [88071] = 1,
            [88494] = 1,
            [85195] = 3,
            [82928] = 3,
            [82964] = 3,
            [82990] = 3,
            [83018] = 3,
            [84105] = 3,
            [84142] = 3,
            [84181] = 3,
            [84278] = 3,
            [84337] = 3,
            [84367] = 3,
            [84880] = 3,
            [85200] = 25,
            [82992] = 25,
            [83008] = 25,
            [83019] = 25,
            [87597] = 25,
            [84754] = 2.25,
            [83856] = 2,
            [84279] = 2,
            [84992] = 2,
            [85370] = 10,
            [84997] = 3,
            [85393] = 1,
            [88875] = 1,
            [88876] = 1,
            [88877] = 1,
            [88878] = 1,
            [88879] = 1,
            [85103] = 3,
            [86448] = 3,
        },
        [37779] = {
            [89025] = 4,
            [89024] = 4,
            [89803] = 5,
            [89891] = 5,
            [93714] = 5,
            [104878] = 5,
            [89802] = 10,
            [89816] = 10,
            [89808] = 5,
            [89811] = 2,
        },
        [37865] = {
            [90048] = 3,
            [90433] = 3,
            [91705] = 3,
            [90047] = 1,
            [89777] = 1,
            [89810] = 1,
            [89857] = 1,
            [89935] = 1,
            [89936] = 1,
            [89972] = 1,
            [89973] = 1,
            [90024] = 1,
            [90069] = 1,
            [90136] = 1,
            [90165] = 1,
            [90494] = 1,
            [90495] = 1,
            [89972] = 2,
            [90124] = 2,
            [89973] = 1,
            [89857] = 1,
            [90074] = 5,
            [90094] = 15,
            [90122] = 15,
            [90087] = 30,
            [90024] = 10,
            [90069] = 1,
            [90126] = 1,
            [89935] = 1,
            [90136] = 1,
            [89936] = 1,
            [89810] = 1,
            [89777] = 1,
            [90519] = 10,
            [90522] = 1,
            [90163] = 4,
        },
        [37866] = {
            [90048] = 3,
            [90433] = 3,
            [91705] = 3,
            [90047] = 1,
            [89777] = 1,
            [89810] = 1,
            [89857] = 1,
            [89935] = 1,
            [89936] = 1,
            [89972] = 1,
            [89973] = 1,
            [90024] = 1,
            [90069] = 1,
            [90136] = 1,
            [90165] = 1,
            [90494] = 1,
            [90495] = 1,
            [89972] = 2,
            [90124] = 2,
            [89973] = 1,
            [89857] = 1,
            [90074] = 5,
            [90094] = 15,
            [90122] = 15,
            [90087] = 30,
            [90024] = 10,
            [90069] = 1,
            [90126] = 1,
            [89935] = 1,
            [90136] = 1,
            [89936] = 1,
            [89810] = 1,
            [89777] = 1,
            [90519] = 10,
            [90522] = 1,
            [90163] = 4,
        },
        [37921] = {
            [90025] = 2,
            [89952] = 2,
            [89985] = 2,
            [90030] = 2,
            [90189] = 2,
            [91593] = 2,
            [91595] = 2,
            [91597] = 2,
            [91599] = 2,
            [91601] = 2,
            [92191] = 2,
            [95615] = 2,
            [95618] = 2,
            [89951] = 6,
            [93147] = 6,
            [93174] = 6,
            [91596] = 10,
        },
        [37938] = {
            [90303] = 0.1,
            [90706] = 0.1,
            [90706] = 3,
            [90789] = 3,
            [90300] = 3,
            [90620] = 1,
            [89748] = 1,
            [90312] = 1,
            [90607] = 1,
            [90649] = 1,
            [90654] = 1,
            [94467] = 1,
            [94468] = 1,
            [94469] = 1,
            [90782] = 10,
            [89686] = 5,
            [89683] = 5,
            [90950] = 10,
            [91052] = 10,
            [92451] = 25,
            [90265] = 7,
            [91068] = 9,
            [93334] = 8,
            [93335] = 8,
            [90777] = 10,
            [91262] = 1,
            [90655] = 1,
            [95236] = 1,
        },
        [37963] = {
            [91094] = 0.75,
            [89393] = 0.75,
            [90242] = 0.75,
            [90468] = 8,
            [90389] = 8,
            [90390] = 8,
            [90467] = 3,
            [89801] = 3,
            [90005] = 3,
            [90243] = 3,
            [90318] = 3,
            [90616] = 3,
            [93164] = 3,
            [100345] = 3,
            [109826] = 3,
            [119483] = 3,
            [90469] = 10,
            [90244] = 10,
            [90267] = 10,
        },
        [37965] = {
            [90480] = 3,
            [90526] = 3,
            [90985] = 3,
            [91048] = 3,
            [104812] = 3,
            [90537] = 10,
            [90648] = 1,
            [91371] = 1,
            [90547] = 20,
            [90542] = 20,
            [90541] = 10,
        },
        [37966] = {
            [90478] = 1,
            [90286] = 1,
            [90295] = 1,
            [90421] = 1,
            [90517] = 1,
            [90684] = 1,
            [92575] = 1,
            [93349] = 1,
            [95248] = 1,
            [90302] = 3,
            [90425] = 2,
            [90501] = 3,
            [91817] = 10,
            [90429] = 10,
            [90434] = 10,
            [90437] = 10,
            [90438] = 10,
            [90442] = 10,
            [92544] = 6,
            [92546] = 6,
            [92625] = 6,
            [92597] = 5,
        },
        [37970] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [89675] = 10,
            [91727] = 10,
            [91695] = 15,
            [93034] = 3,
            [92647] = 10,
        },
        [38009] = {
            [90303] = 0.1,
            [90706] = 0.1,
            [90706] = 3,
            [90789] = 3,
            [90300] = 3,
            [90620] = 1,
            [89748] = 1,
            [90312] = 1,
            [90607] = 1,
            [90649] = 1,
            [90654] = 1,
            [94467] = 1,
            [94468] = 1,
            [94469] = 1,
            [90782] = 10,
            [89686] = 5,
            [89683] = 5,
            [90950] = 10,
            [91052] = 10,
            [92451] = 25,
            [90265] = 7,
            [91068] = 9,
            [93334] = 8,
            [93335] = 8,
            [90777] = 10,
            [91262] = 1,
            [90655] = 1,
            [95236] = 1,
        },
        [38020] = {
            [90478] = 1,
            [90286] = 1,
            [90295] = 1,
            [90421] = 1,
            [90517] = 1,
            [90684] = 1,
            [92575] = 1,
            [93349] = 1,
            [95248] = 1,
            [90302] = 3,
            [90425] = 2,
            [90501] = 3,
            [91817] = 10,
            [90429] = 10,
            [90434] = 10,
            [90437] = 10,
            [90438] = 10,
            [90442] = 10,
            [92544] = 6,
            [92546] = 6,
            [92625] = 6,
            [92597] = 5,
        },
        [38040] = {
            [90855] = 1,
            [89699] = 1,
            [89703] = 1,
            [89705] = 1,
            [89706] = 1,
            [90851] = 1,
            [90884] = 1,
            [90885] = 1,
            [90887] = 1,
            [90888] = 1,
            [90936] = 1,
            [91301] = 1,
            [92197] = 1,
            [93028] = 1,
            [93076] = 1,
            [95235] = 1,
            [89857] = 1,
            [92706] = 1,
            [90781] = 2,
            [90704] = 3,
            [89706] = 3,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 12,
            [93028] = 4,
        },
        [38043] = {
            [90855] = 1,
            [89699] = 1,
            [89703] = 1,
            [89705] = 1,
            [89706] = 1,
            [90851] = 1,
            [90884] = 1,
            [90885] = 1,
            [90887] = 1,
            [90888] = 1,
            [90936] = 1,
            [91301] = 1,
            [92197] = 1,
            [93028] = 1,
            [93076] = 1,
            [95235] = 1,
            [89857] = 1,
            [92706] = 1,
            [90781] = 2,
            [90704] = 3,
            [89706] = 3,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 12,
            [93028] = 4,
        },
        [38051] = {
            [90867] = 1,
            [90482] = 1,
            [90483] = 1,
            [90497] = 1,
            [90510] = 1,
            [90742] = 1,
            [90743] = 1,
            [91250] = 1,
            [91252] = 1,
            [91253] = 1,
            [92873] = 1,
            [93035] = 2,
            [91251] = 2,
            [90371] = 3,
            [90337] = 4,
            [93014] = 4,
            [90868] = 8,
            [90585] = 8,
            [91232] = 8,
            [91243] = 8,
            [92977] = 8,
            [93001] = 8,
            [93057] = 8,
            [93036] = 10,
        },
        [38054] = {
            [90867] = 1,
            [90482] = 1,
            [90483] = 1,
            [90497] = 1,
            [90510] = 1,
            [90742] = 1,
            [90743] = 1,
            [91250] = 1,
            [91252] = 1,
            [91253] = 1,
            [92873] = 1,
            [93035] = 2,
            [91251] = 2,
            [90371] = 3,
            [90337] = 4,
            [93014] = 4,
            [93036] = 8,
            [90868] = 10,
            [90585] = 10,
            [91232] = 10,
            [91243] = 10,
            [92977] = 10,
            [93001] = 10,
            [93057] = 10,
        },
        [38343] = {
            [89759] = 2,
            [91384] = 1,
            [91575] = 2,
            [91424] = 2,
            [91926] = 2,
            [92040] = 10,
            [97445] = 2,
            [97443] = 2,
            [97433] = 2,
            [93377] = 2,
            [93005] = 3,
            [115753] = 3,
            [118177] = 3,
        },
        [38372] = {
            [91121] = 3,
            [91122] = 3,
            [91598] = 3,
            [91182] = 4,
            [91149] = 4,
            [91150] = 4,
            [91151] = 4,
            [91153] = 4,
            [92874] = 4,
            [93604] = 4,
            [93641] = 4,
            [93645] = 4,
            [96932] = 2,
            [94207] = 3,
            [94208] = 3,
            [92180] = 4,
            [91130] = 4,
        },
        [38374] = {
            [92238] = 1,
            [91239] = 1,
            [91245] = 1,
            [91429] = 1,
            [91565] = 1,
            [91799] = 1,
            [91800] = 1,
            [92128] = 1,
            [94624] = 1,
            [95031] = 1,
            [99450] = 1,
            [92239] = 2,
            [91204] = 2,
            [91205] = 2,
            [91417] = 2,
            [91486] = 2,
            [91487] = 2,
            [91488] = 2,
            [91517] = 2,
            [91741] = 2,
            [91893] = 2,
            [91894] = 2,
            [91895] = 2,
            [91920] = 2,
            [105216] = 2,
            [108526] = 2,
            [108530] = 2,
            [92240] = 3,
            [91202] = 3,
            [91217] = 3,
            [100446] = 3,
            [92241] = 5,
            [91795] = 5,
            [91803] = 5,
            [91874] = 5,
            [96992] = 10,
            [91892] = 10,
            [100474] = 15,
            [91529] = 15,
        },
        [38439] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91727] = 10,
            [91695] = 15,
            [93034] = 3,
            [92647] = 10,
            [89675] = 10,
        },
        [38442] = {
            [96248] = 1,
            [96249] = 2,
            [96129] = 2,
            [96229] = 2,
            [96236] = 2,
            [100433] = 2,
            [100435] = 2,
            [108283] = 2,
            [108289] = 2,
            [108306] = 2,
            [108309] = 2,
            [96250] = 3,
            [96135] = 3,
            [96215] = 3,
            [105077] = 3,
            [96251] = 5,
        },
        [38569] = {
            [90025] = 2,
            [89952] = 2,
            [89985] = 2,
            [90030] = 2,
            [90189] = 2,
            [91593] = 2,
            [91595] = 2,
            [91597] = 2,
            [91599] = 2,
            [91601] = 2,
            [92191] = 2,
            [95615] = 2,
            [95618] = 2,
            [89951] = 6,
            [93147] = 6,
            [93174] = 6,
            [91596] = 10,
        },
        [38587] = {
            [91939] = 4,
            [92227] = 5,
            [92395] = 1,
            [92453] = 3,
            [92411] = 8,
            [92408] = 8,
            [91009] = 8,
            [92274] = 15,
            [92396] = 2,
            [92398] = 1,
            [92262] = 1,
            [92397] = 1,
            [92026] = 2,
            [92031] = 5,
            [92083] = 1,
            [92082] = 1,
            [92028] = 2,
            [92051] = 2,
            [92402] = 2,
            [95157] = 2,
            [95159] = 2,
            [95162] = 2,
            [95164] = 2,
            [95165] = 2,
            [95170] = 2,
            [95172] = 2,
            [95173] = 2,
            [95176] = 2,
            [95177] = 2,
            [95178] = 2,
            [95179] = 2,
            [95180] = 2,
            [95181] = 2,
            [95182] = 2,
            [95183] = 2,
            [95184] = 2,
            [95185] = 2,
            [95187] = 2,
            [95188] = 2,
            [95189] = 2,
            [95190] = 2,
            [95677] = 2,
            [95756] = 2,
            [95758] = 2,
            [95759] = 2,
            [92002] = 1,
            [91098] = 8,
        },
        [38588] = {
            [91939] = 4,
            [92227] = 5,
            [92395] = 1,
            [92453] = 3,
            [92411] = 8,
            [92408] = 8,
            [91009] = 8,
            [92274] = 10,
            [92396] = 2,
            [92398] = 1,
            [92262] = 1,
            [92397] = 1,
            [92026] = 2,
            [92031] = 5,
            [92083] = 1,
            [92082] = 1,
            [92028] = 2,
            [92051] = 2,
            [92402] = 2,
            [95157] = 2,
            [95159] = 2,
            [95162] = 2,
            [95164] = 2,
            [95165] = 2,
            [95170] = 2,
            [95172] = 2,
            [95173] = 2,
            [95176] = 2,
            [95177] = 2,
            [95178] = 2,
            [95179] = 2,
            [95180] = 2,
            [95181] = 2,
            [95182] = 2,
            [95183] = 2,
            [95184] = 2,
            [95185] = 2,
            [95187] = 2,
            [95188] = 2,
            [95189] = 2,
            [95190] = 2,
            [95677] = 2,
            [95756] = 2,
            [95758] = 2,
            [95759] = 2,
            [92002] = 1,
            [91098] = 8,
        },
        [38716] = {
            [93067] = 3,
            [92954] = 3,
            [93061] = 3,
            [92963] = 8,
            [92965] = 8,
            [92966] = 8,
            [91839] = 5,
            [95247] = 5,
            [93031] = 15,
            [94974] = 8,
            [92971] = 8,
            [95430] = 3,
            [91860] = 3,
        },
        [38748] = {
            [93074] = 5,
            [93114] = 5,
            [94849] = 5,
            [95454] = 5,
            [95457] = 5,
            [98242] = 5,
            [111981] = 5,
            [112021] = 5,
            [93157] = 5,
            [104924] = 5,
            [106842] = 5,
            [113646] = 5,
            [93169] = 6,
            [95988] = 6,
            [93159] = 10,
            [93111] = 5,
            [112052] = 5,
        },
        [38819] = {
            [97382] = 5,
            [97059] = 20,
            [97057] = 20,
            [97058] = 20,
            [97370] = 20,
            [97395] = 5,
            [101947] = 2.5,
            [93716] = 2.5,
            [96277] = 2.5,
            [96278] = 2.5,
            [96279] = 2.5,
            [97014] = 2.5,
            [97034] = 2.5,
            [97057] = 2.5,
            [97058] = 2.5,
            [97059] = 2.5,
            [97370] = 2.5,
            [97706] = 2.5,
            [98986] = 2.5,
            [99759] = 2.5,
            [102724] = 2.5,
            [103432] = 2.5,
            [96280] = 1,
            [96402] = 5,
            [101319] = 2.5,
        },
        [38842] = {
            [93389] = 3,
            [91354] = 3,
            [91472] = 3,
            [91474] = 3,
            [99008] = 4,
            [93444] = 5,
            [94572] = 1,
        },
        [38865] = {
            [90867] = 1,
            [90482] = 1,
            [90483] = 1,
            [90497] = 1,
            [90510] = 1,
            [90742] = 1,
            [90743] = 1,
            [91250] = 1,
            [91252] = 1,
            [91253] = 1,
            [92873] = 1,
            [93035] = 2,
            [91251] = 2,
            [90371] = 3,
            [90337] = 4,
            [93014] = 4,
            [93036] = 8,
            [90868] = 10,
            [90585] = 10,
            [91232] = 10,
            [91243] = 10,
            [92977] = 10,
            [93001] = 10,
            [93057] = 10,
        },
        [38866] = {
            [90867] = 1,
            [90482] = 1,
            [90483] = 1,
            [90497] = 1,
            [90510] = 1,
            [90742] = 1,
            [90743] = 1,
            [91250] = 1,
            [91252] = 1,
            [91253] = 1,
            [92873] = 1,
            [93035] = 2,
            [91251] = 2,
            [90371] = 3,
            [90337] = 4,
            [93014] = 4,
            [93036] = 8,
            [90868] = 10,
            [90585] = 10,
            [91232] = 10,
            [91243] = 10,
            [92977] = 10,
            [93001] = 10,
            [93057] = 10,
        },
        [38868] = {
            [90303] = 0.1,
            [90706] = 0.1,
            [90706] = 3,
            [90789] = 3,
            [90300] = 3,
            [90620] = 1,
            [89748] = 1,
            [90312] = 1,
            [90607] = 1,
            [90649] = 1,
            [90654] = 1,
            [94467] = 1,
            [94468] = 1,
            [94469] = 1,
            [90782] = 10,
            [89686] = 5,
            [89683] = 5,
            [90950] = 10,
            [91052] = 10,
            [92451] = 25,
            [90265] = 7,
            [91068] = 9,
            [93334] = 8,
            [93335] = 8,
            [91262] = 1,
            [90655] = 1,
            [95236] = 1,
        },
        [38869] = {
            [90303] = 0.1,
            [90706] = 0.1,
            [90706] = 3,
            [90789] = 3,
            [90300] = 3,
            [90620] = 1,
            [89748] = 1,
            [90312] = 1,
            [90607] = 1,
            [90649] = 1,
            [90654] = 1,
            [94467] = 1,
            [94468] = 1,
            [94469] = 1,
            [90782] = 10,
            [89686] = 5,
            [89683] = 5,
            [90950] = 10,
            [91052] = 10,
            [92451] = 25,
            [90265] = 7,
            [91068] = 9,
            [93334] = 8,
            [93335] = 8,
            [91262] = 1,
            [90655] = 1,
            [95236] = 1,
        },
        [38870] = {
            [90855] = 1,
            [89699] = 1,
            [89703] = 1,
            [89705] = 1,
            [89706] = 1,
            [90851] = 1,
            [90884] = 1,
            [90885] = 1,
            [90887] = 1,
            [90888] = 1,
            [90936] = 1,
            [91301] = 1,
            [92197] = 1,
            [93028] = 1,
            [93076] = 1,
            [95235] = 1,
            [89857] = 1,
            [92706] = 1,
            [90781] = 2,
            [90704] = 3,
            [89706] = 3,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 12,
            [93028] = 4,
        },
        [38871] = {
            [90855] = 1,
            [89699] = 1,
            [89703] = 1,
            [89705] = 1,
            [89706] = 1,
            [90851] = 1,
            [90884] = 1,
            [90885] = 1,
            [90887] = 1,
            [90888] = 1,
            [90936] = 1,
            [91301] = 1,
            [92197] = 1,
            [93028] = 1,
            [93076] = 1,
            [95235] = 1,
            [89857] = 1,
            [92706] = 1,
            [90781] = 2,
            [90704] = 3,
            [89706] = 3,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 12,
            [93028] = 4,
        },
        [38876] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91908] = 1,
            [91727] = 10,
            [91695] = 15,
            [93034] = 3,
        },
        [38877] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91908] = 1,
            [91727] = 10,
            [91695] = 15,
            [93034] = 3,
        },
        [38939] = {
            [93941] = 1,
            [94959] = 1,
            [93942] = 2,
            [92764] = 2,
            [93584] = 2,
            [93866] = 2,
            [94752] = 2,
            [94823] = 2,
            [94856] = 2,
            [98953] = 2,
            [98955] = 2,
            [100540] = 2,
            [93943] = 3,
            [93944] = 5,
            [94413] = 5,
            [94211] = 10,
            [92751] = 10,
        },
        [39029] = {
            [94205] = 6,
            [92794] = 6,
            [104923] = 6,
            [94204] = 6,
            [92788] = 6,
            [92789] = 6,
            [92792] = 6,
            [93157] = 6,
            [94007] = 6,
            [94201] = 6,
            [94620] = 6,
            [104920] = 6,
            [104922] = 6,
            [104924] = 6,
            [106842] = 6,
            [110896] = 12,
        },
        [39119] = {
            [94401] = 1,
            [94943] = 1,
            [94402] = 2,
            [93875] = 2,
            [94824] = 2,
            [98955] = 2,
            [100540] = 2,
            [92764] = 2,
            [93584] = 2,
            [94752] = 2,
            [94823] = 2,
            [94856] = 2,
            [98953] = 2,
            [94403] = 3,
            [94404] = 5,
            [94413] = 5,
            [94405] = 10,
            [92751] = 10,
        },
        [39274] = {
            [95013] = 4,
            [94687] = 3,
            [96124] = 4,
            [99406] = 8,
        },
        [39279] = {
            [94651] = 1,
            [95226] = 2.5,
            [93105] = 2.5,
            [93112] = 2.5,
            [93115] = 2.5,
            [93221] = 2.5,
            [94654] = 2.5,
            [95046] = 2.5,
            [97026] = 2.5,
            [102714] = 2.5,
            [96400] = 4,
            [97142] = 5,
        },
        [39317] = {
            [94983] = 5,
            [94984] = 5,
            [94986] = 10,
            [95174] = 5,
            [95204] = 10,
        },
        [39371] = {
            [95270] = 5,
            [95310] = 5,
        },
        [39393] = {
            [95747] = 5,
            [97799] = 5,
            [98089] = 1,
            [95599] = 1,
            [104969] = 1,
            [98087] = 3,
            [95726] = 3,
            [95727] = 3,
            [98088] = 5,
            [95318] = 5,
            [98141] = 5,
            [95319] = 5,
            [95320] = 5,
        },
        [39424] = {
            [95290] = 8,
            [95707] = 8,
            [96423] = 8,
            [96615] = 8,
            [100055] = 8,
            [104323] = 8,
            [104328] = 8,
            [105065] = 8,
            [105066] = 8,
            [96361] = 8,
        },
        [39441] = {
            [90855] = 1,
            [89699] = 1,
            [89703] = 1,
            [89705] = 1,
            [89706] = 1,
            [90851] = 1,
            [90884] = 1,
            [90885] = 1,
            [90887] = 1,
            [90888] = 1,
            [90936] = 1,
            [91301] = 1,
            [92197] = 1,
            [93028] = 1,
            [93076] = 1,
            [95235] = 1,
            [89857] = 1,
            [92706] = 1,
            [90781] = 2,
            [90704] = 3,
            [89706] = 3,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 12,
            [93028] = 4,
        },
        [39442] = {
            [90855] = 1,
            [89699] = 1,
            [89703] = 1,
            [89705] = 1,
            [89706] = 1,
            [90851] = 1,
            [90884] = 1,
            [90885] = 1,
            [90887] = 1,
            [90888] = 1,
            [90936] = 1,
            [91301] = 1,
            [92197] = 1,
            [93028] = 1,
            [93076] = 1,
            [95235] = 1,
            [89857] = 1,
            [92706] = 1,
            [90781] = 2,
            [90704] = 3,
            [89706] = 3,
            [90884] = 4,
            [90885] = 4,
            [90887] = 5,
            [90888] = 4,
            [91227] = 12,
            [93028] = 4,
        },
        [39443] = {
            [90867] = 1,
            [90482] = 1,
            [90483] = 1,
            [90497] = 1,
            [90510] = 1,
            [90742] = 1,
            [90743] = 1,
            [91250] = 1,
            [91252] = 1,
            [91253] = 1,
            [92873] = 1,
            [93035] = 2,
            [91251] = 2,
            [90371] = 3,
            [90337] = 4,
            [93014] = 4,
            [93036] = 8,
            [90868] = 10,
            [90585] = 10,
            [91232] = 10,
            [91243] = 10,
            [92977] = 10,
            [93001] = 10,
            [93057] = 10,
        },
        [39444] = {
            [90867] = 1,
            [90482] = 1,
            [90483] = 1,
            [90497] = 1,
            [90510] = 1,
            [90742] = 1,
            [90743] = 1,
            [91250] = 1,
            [91252] = 1,
            [91253] = 1,
            [92873] = 1,
            [93035] = 2,
            [91251] = 2,
            [90371] = 3,
            [90337] = 4,
            [93014] = 4,
            [93036] = 8,
            [90868] = 10,
            [90585] = 10,
            [91232] = 10,
            [91243] = 10,
            [92977] = 10,
            [93001] = 10,
            [93057] = 10,
        },
        [39445] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91908] = 1,
            [91727] = 10,
            [91695] = 15,
            [93034] = 3,
        },
        [39446] = {
            [92616] = 5,
            [91901] = 2,
            [91760] = 4,
            [91721] = 1,
            [91764] = 1,
            [90066] = 1,
            [89754] = 1,
            [91908] = 1,
            [91727] = 10,
            [91695] = 15,
            [93034] = 3,
        },
        [39447] = {
            [90303] = 0.1,
            [90706] = 0.1,
            [90706] = 3,
            [90789] = 3,
            [90300] = 3,
            [90620] = 1,
            [89748] = 1,
            [90312] = 1,
            [90607] = 1,
            [90649] = 1,
            [90654] = 1,
            [94467] = 1,
            [94468] = 1,
            [94469] = 1,
            [90782] = 10,
            [89686] = 5,
            [89683] = 5,
            [90950] = 10,
            [91052] = 10,
            [92451] = 25,
            [90265] = 7,
            [91068] = 9,
            [93334] = 8,
            [93335] = 8,
            [91262] = 1,
            [90655] = 1,
            [95236] = 1,
        },
        [39448] = {
            [90303] = 0.1,
            [90706] = 0.1,
            [90706] = 3,
            [90789] = 3,
            [90300] = 3,
            [90620] = 1,
            [89748] = 1,
            [90312] = 1,
            [90607] = 1,
            [90649] = 1,
            [90654] = 1,
            [94467] = 1,
            [94468] = 1,
            [94469] = 1,
            [90782] = 10,
            [89686] = 5,
            [89683] = 5,
            [90950] = 10,
            [91052] = 10,
            [92451] = 25,
            [90265] = 7,
            [91068] = 9,
            [93334] = 8,
            [93335] = 8,
            [91262] = 1,
            [90655] = 1,
            [95236] = 1,
        },
        [39449] = {
            [90478] = 1,
            [90286] = 1,
            [90295] = 1,
            [90421] = 1,
            [90517] = 1,
            [90684] = 1,
            [92575] = 1,
            [93349] = 1,
            [95248] = 1,
            [90302] = 3,
            [90425] = 2,
            [90501] = 3,
            [91817] = 10,
            [90429] = 10,
            [90434] = 10,
            [90437] = 10,
            [90438] = 10,
            [90442] = 10,
            [92544] = 6,
            [92546] = 6,
            [92625] = 6,
            [92597] = 5,
        },
        [39450] = {
            [90478] = 1,
            [90286] = 1,
            [90295] = 1,
            [90421] = 1,
            [90517] = 1,
            [90684] = 1,
            [92575] = 1,
            [93349] = 1,
            [95248] = 1,
            [90302] = 3,
            [90425] = 2,
            [90501] = 3,
            [91817] = 10,
            [90429] = 10,
            [90434] = 10,
            [90437] = 10,
            [90438] = 10,
            [90442] = 10,
            [92544] = 6,
            [92546] = 6,
            [92625] = 6,
            [92597] = 5,
        },
        [39451] = {
            [90048] = 3,
            [90433] = 3,
            [91705] = 3,
            [90047] = 1,
            [89777] = 1,
            [89810] = 1,
            [89857] = 1,
            [89935] = 1,
            [89936] = 1,
            [89972] = 1,
            [89973] = 1,
            [90024] = 1,
            [90069] = 1,
            [90136] = 1,
            [90165] = 1,
            [90494] = 1,
            [90495] = 1,
            [89972] = 2,
            [90124] = 2,
            [89973] = 1,
            [89857] = 1,
            [90074] = 5,
            [90094] = 15,
            [90122] = 15,
            [90087] = 30,
            [90024] = 10,
            [90069] = 1,
            [90126] = 1,
            [89935] = 1,
            [90136] = 1,
            [89936] = 1,
            [89810] = 1,
            [89777] = 1,
            [90519] = 10,
            [90522] = 1,
            [90163] = 4,
        },
        [39452] = {
            [90048] = 3,
            [90433] = 3,
            [91705] = 3,
            [90047] = 1,
            [89777] = 1,
            [89810] = 1,
            [89857] = 1,
            [89935] = 1,
            [89936] = 1,
            [89972] = 1,
            [89973] = 1,
            [90024] = 1,
            [90069] = 1,
            [90136] = 1,
            [90165] = 1,
            [90494] = 1,
            [90495] = 1,
            [89972] = 2,
            [90124] = 2,
            [89973] = 1,
            [89857] = 1,
            [90074] = 5,
            [90094] = 15,
            [90122] = 15,
            [90087] = 30,
            [90024] = 10,
            [90069] = 1,
            [90126] = 1,
            [89935] = 1,
            [90136] = 1,
            [89936] = 1,
            [89810] = 1,
            [89777] = 1,
            [90519] = 10,
            [90522] = 1,
            [90163] = 4,
        },
        [39453] = {
            [91939] = 4,
            [92227] = 5,
            [92395] = 1,
            [92453] = 3,
            [92411] = 8,
            [92408] = 8,
            [91009] = 8,
            [92274] = 15,
            [92396] = 2,
            [92398] = 1,
            [92262] = 1,
            [92397] = 1,
            [92026] = 2,
            [92031] = 5,
            [92083] = 1,
            [92082] = 1,
            [92028] = 2,
            [92051] = 2,
            [92402] = 2,
            [95157] = 2,
            [95159] = 2,
            [95162] = 2,
            [95164] = 2,
            [95165] = 2,
            [95170] = 2,
            [95172] = 2,
            [95173] = 2,
            [95176] = 2,
            [95177] = 2,
            [95178] = 2,
            [95179] = 2,
            [95180] = 2,
            [95181] = 2,
            [95182] = 2,
            [95183] = 2,
            [95184] = 2,
            [95185] = 2,
            [95187] = 2,
            [95188] = 2,
            [95189] = 2,
            [95190] = 2,
            [95677] = 2,
            [95756] = 2,
            [95758] = 2,
            [95759] = 2,
            [92002] = 1,
            [91098] = 8,
        },
        [39454] = {
            [91939] = 4,
            [92227] = 5,
            [92395] = 1,
            [92453] = 3,
            [92411] = 8,
            [92408] = 8,
            [91009] = 8,
            [92274] = 10,
            [92396] = 2,
            [92398] = 1,
            [92262] = 1,
            [92397] = 1,
            [92026] = 2,
            [92031] = 5,
            [92083] = 1,
            [92082] = 1,
            [92028] = 2,
            [92051] = 2,
            [92402] = 2,
            [95157] = 2,
            [95159] = 2,
            [95162] = 2,
            [95164] = 2,
            [95165] = 2,
            [95170] = 2,
            [95172] = 2,
            [95173] = 2,
            [95176] = 2,
            [95177] = 2,
            [95178] = 2,
            [95179] = 2,
            [95180] = 2,
            [95181] = 2,
            [95182] = 2,
            [95183] = 2,
            [95184] = 2,
            [95185] = 2,
            [95187] = 2,
            [95188] = 2,
            [95189] = 2,
            [95190] = 2,
            [95677] = 2,
            [95756] = 2,
            [95758] = 2,
            [95759] = 2,
            [92002] = 1,
            [91098] = 8,
        },
        [39576] = {
            [108014] = 10,
            [96287] = 5,
            [108009] = 2.5,
            [96588] = 15,
            [98957] = 10,
            [104733] = 10,
            [96021] = 15,
        },
        [39742] = {
            [97969] = 3,
            [92776] = 3,
            [92782] = 3,
            [96997] = 3,
            [97044] = 3,
            [97225] = 3,
            [101505] = 3,
            [101506] = 3,
            [101507] = 3,
            [101508] = 3,
            [97069] = 3,
            [97970] = 5,
            [92990] = 5,
            [96682] = 5,
            [97228] = 5,
            [100326] = 10,
            [97632] = 10,
            [96783] = 20,
        },
        [39990] = {
            [97940] = 4,
        },
        [39998] = {
            [97945] = 0.5,
            [95620] = 0.5,
            [97906] = 0.5,
            [105084] = 0.5,
            [112480] = 0.5,
            [97946] = 1,
            [97816] = 1,
            [97821] = 1,
            [97851] = 1,
            [112479] = 1,
            [112481] = 1,
            [97947] = 2,
            [97825] = 2,
            [105083] = 2,
            [105127] = 2,
            [105129] = 2,
            [113171] = 2,
            [97948] = 3,
            [97822] = 3,
            [97859] = 3,
            [97942] = 3,
            [97944] = 3,
            [97949] = 5,
        },
        [40050] = {
            [97919] = 5,
            [97920] = 5,
            [105062] = 5,
            [97933] = 10,
            [98311] = 10,
        },
        [40111] = {
            [98492] = 2,
            [98498] = 2,
            [98501] = 2,
            [98502] = 2,
            [109171] = 2,
            [110110] = 2,
            [112090] = 2,
            [114255] = 2,
            [98493] = 3,
            [98500] = 3,
            [110258] = 3,
            [98494] = 5,
            [98495] = 10,
            [98503] = 10,
        },
        [40121] = {
            [98585] = 1,
            [98599] = 1,
            [98600] = 1,
            [98601] = 1,
            [98603] = 1,
            [98703] = 1,
            [98909] = 1,
            [98749] = 2,
        },
        [40316] = {
            [94386] = 5,
            [97318] = 5,
            [94196] = 5,
            [94152] = 5,
            [95693] = 10,
            [94153] = 5,
            [104531] = 6,
        },
        [40594] = {
            [97217] = 5,
            [97241] = 1,
            [97235] = 1,
            [97498] = 5,
            [97316] = 5,
        },
        [40896] = {
            [102251] = 8,
            [101700] = 8,
            [101793] = 8,
            [101794] = 8,
            [101795] = 8,
            [101803] = 8,
            [101804] = 8,
            [101805] = 8,
            [101806] = 8,
            [101807] = 8,
            [101808] = 8,
            [101815] = 8,
            [101826] = 8,
            [101827] = 8,
            [101828] = 8,
            [101829] = 8,
            [101832] = 8,
            [101833] = 8,
            [101834] = 8,
            [101835] = 8,
            [101836] = 8,
            [101837] = 8,
            [102727] = 8,
            [102728] = 8,
            [102729] = 8,
            [102736] = 8,
            [106074] = 8,
            [117353] = 8,
        },
        [40951] = {
            [98653] = 7,
            [102827] = 7,
        },
        [40925] = {
            [102406] = 2,
            [102407] = 15,
        },
        [40978] = {
            [96146] = 10,
            [97449] = 10,
        },
        [41013] = {
            [102623] = 10,
        },
        [41024] = {
            [102251] = 8,
            [101700] = 8,
            [101793] = 8,
            [101794] = 8,
            [101795] = 8,
            [101803] = 8,
            [101804] = 8,
            [101805] = 8,
            [101806] = 8,
            [101807] = 8,
            [101808] = 8,
            [101815] = 8,
            [101826] = 8,
            [101827] = 8,
            [101828] = 8,
            [101829] = 8,
            [101832] = 8,
            [101833] = 8,
            [101834] = 8,
            [101835] = 8,
            [101836] = 8,
            [101837] = 8,
            [102727] = 8,
            [102728] = 8,
            [102729] = 8,
            [102736] = 8,
            [106074] = 8,
            [117353] = 8,
            [102736] = 3,
            [101806] = 3,
            [101807] = 3,
            [101808] = 3,
        },
        [41025] = {
            [102251] = 8,
            [101700] = 8,
            [101793] = 8,
            [101794] = 8,
            [101795] = 8,
            [101803] = 8,
            [101804] = 8,
            [101805] = 8,
            [101806] = 8,
            [101807] = 8,
            [101808] = 8,
            [101815] = 8,
            [101826] = 8,
            [101827] = 8,
            [101828] = 8,
            [101829] = 8,
            [101832] = 8,
            [101833] = 8,
            [101834] = 8,
            [101835] = 8,
            [101836] = 8,
            [101837] = 8,
            [102727] = 8,
            [102728] = 8,
            [102729] = 8,
            [102736] = 8,
            [106074] = 8,
            [117353] = 8,
        },
        [41026] = {
            [102251] = 8,
            [101700] = 8,
            [101793] = 8,
            [101794] = 8,
            [101795] = 8,
            [101803] = 8,
            [101804] = 8,
            [101805] = 8,
            [101806] = 8,
            [101807] = 8,
            [101808] = 8,
            [101815] = 8,
            [101826] = 8,
            [101827] = 8,
            [101828] = 8,
            [101829] = 8,
            [101832] = 8,
            [101833] = 8,
            [101834] = 8,
            [101835] = 8,
            [101836] = 8,
            [101837] = 8,
            [102727] = 8,
            [102728] = 8,
            [102729] = 8,
            [102736] = 8,
            [106074] = 8,
            [117353] = 8,
        },
        [41122] = {
            [103150] = 15,
            [103173] = 8,
            [103174] = 4,
        },
        [41127] = {
            [103177] = 2,
            [103196] = 2,
            [103234] = 10,
            [103235] = 10,
            [103227] = 5,
            [103178] = 6,
            [103179] = 6,
            [104690] = 15,
            [102633] = 5,
            [102634] = 8,
            [104691] = 15,
        },
        [41144] = {
            [95148] = 8,
            [95013] = 8,
            [96124] = 8,
            [94687] = 4,
        },
        [41227] = {
            [103650] = 8,
            [102864] = 8,
            [102865] = 8,
            [102866] = 8,
            [102867] = 8,
            [102868] = 8,
            [102869] = 8,
            [102871] = 8,
            [102872] = 8,
            [102873] = 8,
            [102874] = 8,
            [102875] = 8,
            [102876] = 8,
            [102877] = 8,
            [102878] = 8,
            [117935] = 8,
            [117936] = 8,
            [117937] = 8,
            [117939] = 8,
            [117940] = 8,
        },
        [41257] = {
            [103651] = 8,
            [103210] = 8,
            [103215] = 8,
            [103218] = 8,
            [103222] = 8,
            [103245] = 8,
            [103307] = 8,
            [103430] = 8,
            [103431] = 8,
            [103446] = 8,
            [103449] = 8,
            [103453] = 8,
            [103457] = 8,
            [103729] = 8,
            [103745] = 8,
            [117941] = 8,
            [117942] = 8,
            [117943] = 8,
            [117944] = 8,
        },
        [41308] = {
            [103837] = 15,
            [103850] = 15,
            [103851] = 40,
            [110839] = 40,
        },
        [41420] = {
            [103650] = 8,
            [102864] = 8,
            [102865] = 8,
            [102866] = 8,
            [102867] = 8,
            [102868] = 8,
            [102869] = 8,
            [102871] = 8,
            [102872] = 8,
            [102873] = 8,
            [102874] = 8,
            [102875] = 8,
            [102876] = 8,
            [102877] = 8,
            [102878] = 8,
            [117935] = 8,
            [117936] = 8,
            [117937] = 8,
            [117939] = 8,
            [117940] = 8,
        },
        [41421] = {
            [103651] = 8,
            [103210] = 8,
            [103215] = 8,
            [103218] = 8,
            [103222] = 8,
            [103245] = 8,
            [103307] = 8,
            [103430] = 8,
            [103431] = 8,
            [103446] = 8,
            [103449] = 8,
            [103453] = 8,
            [103457] = 8,
            [103729] = 8,
            [103745] = 8,
            [117941] = 8,
            [117942] = 8,
            [117943] = 8,
            [117944] = 8,
        },
        [41705] = {
            [104614] = 15,
            [104615] = 8,
            [104692] = 8,
            [111184] = 8,
            [104624] = 13,
            [104660] = 25,
        },
        [41706] = {
            [104590] = 8,
            [104582] = 6,
            [104589] = 4,
        },
        [41896] = {
            [105365] = 2,
            [105780] = 2,
            [110347] = 2,
            [110435] = 2,
            [110436] = 2,
            [110448] = 2,
            [105366] = 5,
            [105360] = 5,
            [105361] = 5,
            [105362] = 5,
            [105781] = 25,
            [105363] = 25,
            [106178] = 25,
            [110073] = 25,
            [110468] = 25,
        },
        [41925] = {
            [89759] = 8,
            [91384] = 4,
            [91575] = 8,
            [91424] = 8,
            [91926] = 10,
            [92040] = 15,
            [97445] = 8,
            [97443] = 8,
            [97433] = 8,
            [91948] = 30,
            [93005] = 20,
            [91657] = 15,
        },
        [41927] = {
            [98429] = 4,
            [98412] = 4,
            [98432] = 8,
            [93066] = 8,
            [93344] = 8,
            [98411] = 8,
            [108856] = 8,
            [93070] = 8,
            [98433] = 15,
            [98434] = 20,
            [98421] = 20,
            [107403] = 20,
        },
        [41930] = {
            [97945] = 3,
            [95620] = 3,
            [97906] = 3,
            [105084] = 3,
            [112480] = 3,
            [97946] = 8,
            [97816] = 8,
            [97821] = 8,
            [97851] = 8,
            [112479] = 8,
            [112481] = 8,
            [97947] = 15,
            [97825] = 15,
            [105083] = 15,
            [105127] = 15,
            [105129] = 15,
            [113171] = 15,
            [97948] = 20,
            [97822] = 20,
            [97859] = 20,
            [97942] = 20,
            [97944] = 20,
            [97949] = 25,
        },
        [41961] = {
            [93067] = 8,
            [92954] = 8,
            [93061] = 8,
            [92963] = 16,
            [92965] = 16,
            [92966] = 16,
            [91839] = 12,
            [95247] = 8,
            [93031] = 16,
            [94974] = 8,
            [92971] = 16,
            [95430] = 6,
            [91860] = 6,
            [108941] = 18,
        },
        [41992] = {
            [93155] = 6,
            [97337] = 8,
            [97338] = 3,
            [92989] = 16,
        },
        [42004] = {
            [105718] = 5,
        },
        [42013] = {
            [105746] = 8,
            [105748] = 6,
            [105750] = 6,
            [105532] = 4,
            [105751] = 20,
            [105749] = 8,
        },
        [42018] = {
            [91094] = 3,
            [89393] = 3,
            [90242] = 3,
            [90468] = 8,
            [90389] = 8,
            [90390] = 8,
            [90467] = 6,
            [89801] = 6,
            [90005] = 6,
            [90243] = 6,
            [90318] = 6,
            [90616] = 6,
            [93164] = 6,
            [100345] = 6,
            [109826] = 6,
            [119483] = 6,
            [90469] = 15,
            [90244] = 15,
            [90267] = 15,
            [105947] = 4,
            [105950] = 6,
            [105961] = 8,
        },
        [42019] = {
            [89025] = 6,
            [89024] = 6,
            [89803] = 8,
            [89891] = 8,
            [93714] = 8,
            [104878] = 8,
            [89802] = 25,
            [89816] = 25,
            [89808] = 10,
            [89811] = 4,
        },
        [42022] = {
            [91287] = 3,
            [91284] = 6,
            [88086] = 6,
            [88087] = 6,
            [91285] = 8,
            [91459] = 8,
            [107447] = 8,
            [117483] = 8,
            [91286] = 25,
            [89846] = 25,
            [107127] = 25,
            [106105] = 6,
        },
        [42023] = {
            [106650] = 2,
        },
        [42025] = {
            [110585] = 5,
            [107020] = 5,
            [107463] = 5,
            [109942] = 5,
            [109967] = 5,
            [109994] = 5,
        },
        [42027] = {
            [90660] = 4,
            [90659] = 6,
            [89731] = 6,
            [90661] = 6,
            [103162] = 6,
            [103180] = 6,
            [103231] = 6,
            [119515] = 6,
            [119516] = 6,
            [119517] = 6,
            [103176] = 8,
            [103363] = 8,
            [119466] = 8,
            [90662] = 25,
        },
        [42028] = {
            [105793] = 24,
            [105902] = 8,
            [105826] = 8,
            [105823] = 6,
            [105807] = 4,
        },
        [42053] = {
            [107219] = 3,
            [107140] = 3,
            [107160] = 3,
            [107161] = 3,
            [107220] = 5,
            [107142] = 5,
            [107144] = 5,
            [107221] = 10,
            [107143] = 10,
            [107147] = 10,
            [106906] = 20,
        },
        [42070] = {
            [103650] = 8,
            [102864] = 8,
            [102865] = 8,
            [102866] = 8,
            [102867] = 8,
            [102868] = 8,
            [102869] = 8,
            [102871] = 8,
            [102872] = 8,
            [102873] = 8,
            [102874] = 8,
            [102875] = 8,
            [102876] = 8,
            [102877] = 8,
            [102878] = 8,
            [117935] = 8,
            [117936] = 8,
            [117937] = 8,
            [117939] = 8,
            [117940] = 8,
        },
        [42082] = {
            [105554] = 8,
            [105585] = 4,
            [105613] = 7,
        },
        [42087] = {
            [105823] = 6,
            [105826] = 8,
            [106067] = 0.5,
        },
        [42111] = {
            [100271] = 8,
            [99581] = 8,
            [99584] = 8,
            [99762] = 8,
            [99765] = 8,
            [99767] = 8,
            [100047] = 8,
            [100895] = 8,
            [100993] = 8,
            [101291] = 8,
            [101868] = 8,
            [101900] = 8,
            [102837] = 8,
            [105269] = 8,
            [105270] = 8,
            [105271] = 8,
            [106339] = 8,
            [106348] = 8,
            [107722] = 8,
            [108314] = 8,
            [110805] = 8,
            [113675] = 8,
            [113679] = 8,
            [113850] = 8,
            [100273] = 12,
            [99485] = 12,
            [99764] = 12,
            [100595] = 12,
            [101878] = 12,
            [102898] = 12,
            [103671] = 12,
            [106526] = 12,
            [106532] = 12,
            [100274] = 16,
            [99795] = 16,
            [100019] = 16,
            [106374] = 3,
            [106375] = 3,
        },
        [42277] = {
            [107384] = 3,
            [107102] = 3,
            [107748] = 3,
            [107323] = 3,
            [107545] = 3,
            [107550] = 3,
            [107383] = 8,
            [107103] = 8,
            [107116] = 8,
            [107119] = 8,
            [107133] = 8,
            [107135] = 8,
            [107136] = 8,
            [107172] = 8,
            [107193] = 8,
            [107201] = 8,
            [107327] = 8,
            [107440] = 8,
            [110619] = 8,
            [107267] = 8,
            [107335] = 8,
            [107362] = 8,
            [107363] = 8,
            [107366] = 8,
            [107368] = 8,
            [107485] = 8,
            [107546] = 8,
            [107547] = 8,
            [107990] = 8,
            [107381] = 12,
            [107105] = 12,
            [107331] = 12,
            [113987] = 12,
            [107216] = 12,
            [107328] = 12,
            [107382] = 16,
        },
        [42373] = {
            [95290] = 6,
            [95707] = 6,
            [96423] = 6,
            [96615] = 6,
            [100055] = 6,
            [104323] = 6,
            [104328] = 6,
            [105065] = 6,
            [105066] = 6,
            [96361] = 6,
        },
        [42431] = {
            [99223] = 4,
            [107258] = 2,
            [107455] = 1,
            [107454] = 8,
        },
        [43183] = {
            [103651] = 8,
            [103210] = 8,
            [103215] = 8,
            [103218] = 8,
            [103222] = 8,
            [103245] = 8,
            [103307] = 8,
            [103430] = 8,
            [103431] = 8,
            [103446] = 8,
            [103449] = 8,
            [103453] = 8,
            [103457] = 8,
            [103729] = 8,
            [103745] = 8,
            [117941] = 8,
            [117942] = 8,
            [117943] = 8,
            [117944] = 8,
        },
        [43241] = {
            [92383] = 4,
            [95951] = 4,
            [106842] = 1,
            [107666] = 1,
            [109796] = 6,
            [110032] = 5,
            [110423] = 20,
        },
        [43247] = {
            [103650] = 8,
            [102864] = 8,
            [102865] = 8,
            [102866] = 8,
            [102867] = 8,
            [102868] = 8,
            [102869] = 8,
            [102871] = 8,
            [102872] = 8,
            [102873] = 8,
            [102874] = 8,
            [102875] = 8,
            [102876] = 8,
            [102877] = 8,
            [102878] = 8,
            [117935] = 8,
            [117936] = 8,
            [117937] = 8,
            [117939] = 8,
            [117940] = 8,
        },
        [43248] = {
            [103651] = 8,
            [103210] = 8,
            [103215] = 8,
            [103218] = 8,
            [103222] = 8,
            [103245] = 8,
            [103307] = 8,
            [103430] = 8,
            [103431] = 8,
            [103446] = 8,
            [103449] = 8,
            [103453] = 8,
            [103457] = 8,
            [103729] = 8,
            [103745] = 8,
            [117941] = 8,
            [117942] = 8,
            [117943] = 8,
            [117944] = 8,
        },
        [43324] = {
            [108600] = 10,
            [108259] = 6,
            [108675] = 6,
            [108327] = 3,
        },
        [43336] = {
            [92383] = 6,
            [95951] = 6,
            [106842] = 1.5,
            [107666] = 1.5,
            [110423] = 24,
        },
        [43483] = {
            [110671] = 2,
            [108806] = 2,
            [109099] = 2,
            [109112] = 2,
            [109336] = 2,
            [109354] = 2,
            [109725] = 2,
            [110384] = 2,
            [110474] = 2,
            [110484] = 2,
            [110699] = 2,
            [110700] = 2,
            [110742] = 2,
            [110776] = 2,
            [110777] = 2,
            [110778] = 2,
            [110779] = 2,
            [110994] = 2,
            [111086] = 2,
            [111593] = 2,
            [111652] = 2,
            [110486] = 25,
        },
        [43583] = {
            [110933] = 3,
            [111006] = 3,
            [111013] = 3,
            [111016] = 3,
            [113702] = 3,
            [113703] = 3,
            [110955] = 3,
            [110956] = 3,
            [110999] = 3,
            [111020] = 6,
            [110957] = 6,
            [110997] = 6,
            [110998] = 6,
            [111012] = 6,
            [111002] = 6,
            [111003] = 6,
            [113704] = 2,
            [113705] = 2,
        },
        [43598] = {
            [103650] = 8,
            [102864] = 8,
            [102865] = 8,
            [102866] = 8,
            [102867] = 8,
            [102868] = 8,
            [102869] = 8,
            [102871] = 8,
            [102872] = 8,
            [102873] = 8,
            [102874] = 8,
            [102875] = 8,
            [102876] = 8,
            [102877] = 8,
            [102878] = 8,
            [117935] = 8,
            [117936] = 8,
            [117937] = 8,
            [117939] = 8,
            [117940] = 8,
        },
        [43599] = {
            [103651] = 8,
            [103210] = 8,
            [103215] = 8,
            [103218] = 8,
            [103222] = 8,
            [103245] = 8,
            [103307] = 8,
            [103430] = 8,
            [103431] = 8,
            [103446] = 8,
            [103449] = 8,
            [103453] = 8,
            [103457] = 8,
            [103729] = 8,
            [103745] = 8,
            [117941] = 8,
            [117942] = 8,
            [117943] = 8,
            [117944] = 8,
        },
        [43600] = {
            [103650] = 8,
            [102864] = 8,
            [102865] = 8,
            [102866] = 8,
            [102867] = 8,
            [102868] = 8,
            [102869] = 8,
            [102871] = 8,
            [102872] = 8,
            [102873] = 8,
            [102874] = 8,
            [102875] = 8,
            [102876] = 8,
            [102877] = 8,
            [102878] = 8,
            [117935] = 8,
            [117936] = 8,
            [117937] = 8,
            [117939] = 8,
            [117940] = 8,
        },
        [43601] = {
            [103651] = 8,
            [103210] = 8,
            [103215] = 8,
            [103218] = 8,
            [103222] = 8,
            [103245] = 8,
            [103307] = 8,
            [103430] = 8,
            [103431] = 8,
            [103446] = 8,
            [103449] = 8,
            [103453] = 8,
            [103457] = 8,
            [103729] = 8,
            [103745] = 8,
            [117941] = 8,
            [117942] = 8,
            [117943] = 8,
            [117944] = 8,
        },
        [43932] = {
            [111910] = 6,
            [99755] = 6,
            [106032] = 6,
            [106654] = 6,
            [107449] = 6,
            [107450] = 6,
            [108930] = 6,
            [109048] = 6,
            [109199] = 6,
            [109473] = 6,
            [111446] = 6,
            [111612] = 6,
            [111619] = 6,
            [112821] = 6,
            [112822] = 6,
            [113451] = 6,
            [113452] = 6,
            [113462] = 6,
            [113463] = 6,
            [113464] = 6,
            [113465] = 6,
            [114468] = 6,
            [114470] = 6,
            [114472] = 6,
            [114474] = 6,
            [114480] = 6,
            [114868] = 6,
            [115216] = 6,
            [115241] = 6,
            [115249] = 6,
            [116013] = 6,
            [113679] = 6,
            [111911] = 10,
            [107521] = 10,
            [107717] = 10,
            [107721] = 10,
            [107727] = 10,
            [112788] = 10,
            [113633] = 10,
        },
        [43964] = {
            [112134] = 1,
            [112135] = 5,
            [112136] = 10,
            [112127] = 10,
            [112133] = 10,
            [112196] = 10,
            [112197] = 10,
            [112200] = 10,
            [112202] = 10,
            [112203] = 10,
            [112205] = 10,
            [112207] = 10,
            [112211] = 10,
            [112215] = 10,
            [112217] = 10,
            [112219] = 10,
            [112556] = 10,
            [112559] = 10,
            [112560] = 10,
            [112619] = 10,
            [112620] = 10,
            [112621] = 10,
            [112622] = 10,
            [112624] = 10,
            [112137] = 20,
        },
        [44049] = {
            [111479] = 15,
            [111456] = 4,
            [111469] = 2,
        },
        [44054] = {
            [112446] = 1,
            [111469] = 1,
            [112447] = 3,
            [111456] = 3,
            [111756] = 3,
            [111766] = 3,
            [111767] = 3,
            [111768] = 3,
            [111929] = 3,
            [112448] = 5,
            [102059] = 5,
            [111479] = 5,
            [111751] = 5,
            [111763] = 5,
            [111889] = 5,
            [112449] = 1,
            [111752] = 1,
            [112450] = 10,
            [111508] = 10,
            [111823] = 10,
            [103972] = 10,
        },
        [44730] = {
            [114994] = 20,
            [115008] = 5,
            [115010] = 5,
            [115021] = 5,
            [115379] = 5,
            [115443] = 5,
            [116425] = 5,
            [116429] = 5,
            [115119] = 10,
            [115015] = 5,
        },
        [44737] = {
            [115025] = 6,
            [115031] = 5,
            [115026] = 2,
            [115739] = 5,
            [115751] = 25,
        },
        [44744] = {
            [115089] = 8,
            [115090] = 5,
            [115216] = 5,
            [115249] = 5,
        },
        [44759] = {
            [115333] = 10,
            [115008] = 5,
            [115010] = 5,
            [115021] = 5,
            [115379] = 5,
            [115443] = 5,
            [116425] = 5,
            [116429] = 5,
        },
        [44780] = {
            [115383] = 3,
            [115384] = 8,
            [114874] = 8,
            [114876] = 8,
            [114868] = 8,
            [114873] = 8,
            [114904] = 8,
            [115806] = 8,
            [116013] = 8,
            [115385] = 12,
            [114869] = 12,
            [114875] = 12,
        },
        [44789] = {
            [115657] = 4,
            [115656] = 4,
            [115658] = 4,
            [117345] = 15,
            [90679] = 15,
            [117346] = 15,
        },
        [44823] = {
            [116315] = 16,
        },
        [44857] = {
            [106765] = 15,
            [106764] = 10,
        },
        [44867] = {
            [115961] = 8,
            [115690] = 8,
            [115691] = 8,
            [115692] = 8,
            [115724] = 8,
            [115755] = 8,
            [115962] = 12,
            [115738] = 12,
            [115954] = 12,
        },
        [44884] = {
            [115790] = 8,
            [115854] = 5,
            [115008] = 5,
            [115010] = 5,
            [115021] = 5,
            [115379] = 5,
            [115443] = 5,
            [116425] = 5,
            [116429] = 5,
            [115891] = 5,
            [117486] = 5,
            [115841] = 10,
        },
        [44892] = {
            [115679] = 4,
            [115677] = 2,
            [115665] = 4,
            [115669] = 10,
            [115673] = 15,
            [115927] = 8,
        },
        [44893] = {
            [115680] = 4,
            [115678] = 2,
            [115663] = 4,
            [115667] = 10,
            [115671] = 15,
            [115925] = 8,
        },
        [44894] = {
            [115681] = 4,
            [115675] = 2,
            [115666] = 4,
            [115670] = 10,
            [115674] = 15,
            [115922] = 8,
        },
        [44895] = {
            [115682] = 4,
            [115676] = 2,
            [115664] = 4,
            [115668] = 10,
            [115672] = 15,
            [115917] = 8,
        },
        [44938] = {
            [117240] = 3,
        },
        [45058] = {
            [115969] = 10,
            [116025] = 3,
            [116026] = 3,
            [116027] = 3,
            [115558] = 4,
            [117792] = 20,
        },
        [45118] = {
            [115753] = 10,
            [91948] = 20,
            [91527] = 3,
            [93377] = 10,
            [89759] = 10,
            [97445] = 8,
            [97443] = 8,
            [97433] = 8,
            [93005] = 10,
            [91537] = 6,
            [97630] = 20,
            [91657] = 20,
            [118177] = 10,
            [91384] = 3,
            [91575] = 10,
            [115732] = 20,
        },
        [45134] = {
            [116205] = 5,
            [116219] = 6,
            [116204] = 4,
            [116282] = 5,
            [116281] = 5,
            [116217] = 3,
            [116277] = 8,
            [116290] = 8,
        },
        [45203] = {
            [116425] = 2,
            [116324] = 6,
            [116167] = 10,
            [116429] = 4,
            [116424] = 7,
            [116428] = 5,
            [116433] = 5,
        },
        [45307] = {
            [100998] = 5,
            [102913] = 10,
            [100999] = 5,
        },
        [45390] = {
            [116825] = 5,
            [117080] = 8,
            [116823] = 5,
            [116813] = 8,
            [116812] = 8,
            [116811] = 8,
            [116810] = 8,
            [116809] = 8,
            [116842] = 15,
            [116848] = 15,
            [115379] = 2,
        },
        [45406] = {
            [116882] = 1,
            [116850] = 3,
            [116883] = 1,
            [116884] = 2,
            [116899] = 4,
            [116901] = 4,
            [116898] = 4,
            [116909] = 1,
            [116917] = 1,
            [116892] = 2,
            [116885] = 3,
            [116897] = 1,
            [116920] = 5,
        },
        [45439] = {
            [117018] = 6,
            [116980] = 5,
            [116981] = 4,
            [117019] = 2,
            [116972] = 8,
            [117003] = 8,
        },
        [45586] = {
            [117324] = 5,
            [117328] = 10,
        },
        [45626] = {
            [117354] = 2,
            [117425] = 10,
            [117446] = 10,
        },
        [45653] = {
            [117354] = 2,
            [117425] = 10,
            [117446] = 10,
            [119721] = 1,
        },
        [45746] = {
            [117551] = 4,
            [117554] = 4,
            [117557] = 6,
            [117560] = 2,
            [117561] = 4,
            [117612] = 4,
            [117613] = 4,
            [117614] = 4,
            [117623] = 4,
            [117629] = 6,
        },
        [45786] = {
            [118305] = 8,
            [118280] = 5,
            [118415] = 5,
            [117850] = 15,
            [117837] = 15,
            [117883] = 1,
            [118410] = 3,
        },
        [45795] = {
            [117655] = 5,
            [117735] = 5,
            [117736] = 5,
            [117737] = 5,
            [117743] = 5,
            [119902] = 5,
            [117649] = 10,
            [117636] = 5,
        },
        [45804] = {
            [118077] = 4,
            [118078] = 5,
        },
        [45970] = {
            [119635] = 8,
            [119634] = 5,
            [119694] = 5,
        },
        [46032] = {
            [118454] = 8,
            [118455] = 8,
            [118459] = 20,
            [118472] = 10,
            [118502] = 5,
        },
        [46073] = {
            [117559] = 2.5,
            [117552] = 2.5,
            [117567] = 2.5,
            [117546] = 5,
            [117555] = 1,
            [118720] = 25,
        },
        [46116] = {
            [116566] = 5,
            [118782] = 7,
            [118783] = 5,
            [116521] = 5,
            [116664] = 10,
        },
        [46160] = {
            [118841] = 10,
            [118845] = 16,
            [118846] = 5,
            [118857] = 60,
        },
        [46201] = {
            [120087] = 1,
            [120103] = 5,
            [120112] = 20,
            [120113] = 2,
        },
        [46347] = {
            [120761] = 2,
            [120768] = 10,
        },
        [46725] = {
            [117952] = 5,
        },
        [46750] = {
            [117952] = 10,
        },
        [46752] = {
            [117952] = 10,
        },
        [46756] = {
            [115624] = 1,
            [117403] = 10,
            [117404] = 10,
            [120143] = 10,
            [117413] = 3,
            [117492] = 3,
            [119203] = 3,
            [119270] = 3,
            [120481] = 5,
        },
        [46833] = {
            [120709] = 5,
            [120710] = 5,
            [120711] = 5,
            [120734] = 5,
            [117091] = 20,
            [120735] = 8,
            [120739] = 2,
        },
        [47132] = {
            [120932] = 5,
            [120933] = 3,
            [120934] = 2,
            [120943] = 10,
            [121344] = 6,
        },
        [47707] = {
            [123509] = 3,
            [123513] = 6,
            [123514] = 30,
            [125251] = 10,
            [124959] = 6,
        },
        [48777] = {
            [126073] = 2,
            [126072] = 5,
            [126071] = 15,
            [126082] = 10,
            [126040] = 15,
        },
        [48983] = {
            [126457] = 7.5,
            [126458] = 5,
            [126456] = 5,
            [127914] = 20,
        },
    }
end
