-- $Id: Lib-ScenariosStepsDescriptionsDB.lua 17 2018-04-24 09:17:50Z arith $
local FOLDER_NAME, private = ...

local Descriptions = {}
if not private.Scenarios then private.Scenarios = {} end
private.Scenarios.Descriptions = Descriptions

--[[
LibScenariosDescriptionsTempDB = { --{ "Scenario ID", "Step ID", "Steps", "enUS", "deDE", "esES", "esMX", "frFR", "itIT", "koKR", "ptBR", "ruRU", "zhCN", "zhTW" };
{ "15", "24", "0", "Bring Brewmaster Bo to the Unga Ingoo Brewing Cauldron.", "Bringt Braumeister Bo zum Braukessel von Unga Ingu.", "Lleva al maestro cervecero Bo hasta el caldero de fermentación de Unga Ingoo.", "Lleva al maestro cervecero Bo hasta el caldero de fermentación de Unga Ingoo.", "Amenez le maître brasseur Bo au chaudron de brassage d’Unga Ingou.", "Scorta il Mastro Birraio Bo al Tino di Fermentazione a Unga Ingu.", "양조사 보를 웅가 잉구 양조 가마솥에 데려가야 합니다.", "Escolte o Mestre Cervejeiro Bô até o Caldeirão de Brassagem de Ungá Ingô.", "Проведите хмелевара Бо к кипящему котлу Унга-Ингу.", "护送珀酒仙去盎迦猴岛的酿酒大锅。", "帶釀酒大師阿波到仰加印古的釀酒鍋。" };
{ "15", "25", "1", "Bring 200 Unga Jungle Brew to the Brewing Cauldron.", "Bringt 200 Becher Ungadschungelbräu zum Braukessel.", "Lleva 200 brebajes de jungla de Unga al caldero de fermentación.", "Lleva 200 brebajes de jungla de Unga al caldero de fermentación.", "Apportez 200 brassejungles d’Unga au chaudron de brassage.", "Porta 200 Birre della Giungla di Unga al Tino di Fermentazione.", "양조 가마솥에 웅가 밀림 맥주 200개를 가져가야 합니다.", "Leve 200 Cervejas Selvagens de Ungá para o Caldeirão de Brassagem.", "Вылейте в хмелеваренный котел 200 порций тропического отвара Унга.", "带上200桶盎迦丛林酒去酿酒大锅。", "帶200個仰加叢林酒到釀酒鍋。" };
{ "15", "26", "2", "Defeat Captain Ook.", "Bezwingt Kapitän Uuk.", "Derrota al capitán Ook.", "Derrota al capitán Ook.", "Terrassez le capitaine Ouk.", "Sconfiggi Capitan Gancino.", "선장 우끼를 처치해야 합니다.", "Derrote o Capitão Fedô.", "Одолейте капитана Ука.", "击败乌克头领。", "殺死烏克船長。" };
{ "39", "114", "0", "Defeat the corrupted Shado-Pan Leader.", "Bezwingt den verderbten Anführer der Shado-Pan.", "Derrota al líder del Shadopan corrupto.", "Derrota al líder del Shadopan corrupto.", "Terrassez le chef pandashan.", "Sconfiggi il capo corrotto degli Shandaren.", "타락한 음영파 대장을 처치해야 합니다.", "Derrote o líder Shado-pan corrompido.", "Одолейте поддавшегося скверне лидера Шадо-Пан.", "击败被腐蚀的影踪派高手。", "殺死腐化的影潘首領。" };
{ "39", "115", "2", "Delve deeper into the crypt and search the bottom level.", "Geht tiefer in die Krypta hinein und durchsucht die untere Ebene.", "Investiga más a fondo la cripta y rastrea el nivel inferior.", "Investiga más a fondo la cripta y rastrea el nivel inferior.", "Enfoncez-vous dans les profondeurs de la crypte et fouillez le niveau inférieur.", "Addentrati nella cripta e raggiungi il livello inferiore.", "납골당 내부로 더욱 깊이 들어가 최하층을 수색해야 합니다.", "Adentre-se ainda mais na cripta e vasculhe o nível mais baixo.", "Спуститесь еще глубже и обыщите нижний уровень гробниц.", "深度挖掘地穴并搜索地穴的底层。", "深入墓穴，到底層進行搜索。" };
};
]]

Descriptions.DB = { 
["53"] = {
{ "Defeat the forces of the Scarlet Crusade inside their monastery.", "Bezwingt die Streitkräfte des Scharlachroten Kreuzzugs in ihrem Kloster.", "Derrota a las fuerzas de la Cruzada Escarlata que están en el Monasterio Escarlata.", "Derrota a las fuerzas de la Cruzada Escarlata que están en el Monasterio Escarlata.", "Terrassez les troupes de la Croisade écarlate dans leur monastère.", "Sconfiggi le forze della Crociata Scarlatta nel monastero.", "붉은십자군 수도원에 있는 붉은십자군을 처치해야 합니다.", "Derrote as forças da Cruzada Escarlate dentro do monastério.", "Победите силы Алого ордена в их собственном монастыре.", "击败修道院里的血色十字军。", "消滅修道院裡的血色十字軍。", }, 
},
["63"] = {
{ "Help Brewmaster Boof's assistants gather the ingredients for the Kun-Lai Kicker.", "Helft den Gehilfen von Braumeister Boof dabei, die Zutaten für den Kun-Lai-Hammer zu sammeln.", "Ayuda a los asistentes del maestro cervecero Boof a reunir los ingredientes para la pateadora de Kun-Lai.", "Ayuda a los asistentes del maestro cervecero Boof a reunir los ingredientes para la pateadora de Kun-Lai.", "Aidez les assistants du maître brasseur Giclette à rassembler les ingrédients de la Ravigote de Kun-Lai.", "Aiuta gli assistenti del Mastro Birraio Bof a raccogliere gli ingredienti per la Spezzagambe del Kun-Lai.", "양조사 부프의 조수가 쿤라이 뻥뻥주 양조에 필요한 재료를 모으는 것을 도와야 합니다.", "Ajude os assistentes do Mestre Cervejeiro Buf a coletar os ingredientes para a Touro Vermelho de Kun-Lai.", "Помогите помощникам хмелевара Буфа собрать ингредиенты для куньлайского сногсшибателя.", "帮酒仙布夫的助手收集昆莱劲酒的酿造材料。", "幫助釀酒大師布夫的助手收集崑萊好勁道所需的原料。", }, 
{ "Investigate the Yaungol sightings.", "Untersucht die Sichtungen der Yaungol.", "Investiga los avistamientos yaungol.", "Investiga los avistamientos yaungol.", "Enquêtez sur les apparitions de yaungols.", "Investiga sugli avvistamenti di Yaungol.", "야운골 목격에 관한 내용을 조사해야 합니다.", "Investigue as aparições de yaungóis.", "Осмотрите места, где были замечены яунголы.", "调查野牛人的眼线。", "調查揚古出沒的狀況。", }, 
{ "Stop the Bataari invasion on Binan Village.", "Halte die Invasion der Bataari auf Binan auf.", "Detén la invasión Bataari en la Aldea Binan.", "Detén la invasión Bataari en la Aldea Binan.", "Arrêtez l’invasion bataari sur Binan.", "Ferma gli invasori di Bataar a Binan.", "빈안 마을을 공격하는 바타리 병력을 저지해야 합니다.", "Impeça a invasão Bataari na Vila Binan.", "Остановите атаку батааров на деревню Бинан.", "阻止巴塔里野牛人对滨岸村的入侵。", "阻止巴塔利入侵濱南村。", }, 
{ "Defeat Warbringer Qobi.", "Bezwingt Kriegshetzer Qobi.", "Derrota al belisario Qobi.", "Derrota al belisario Qobi.", "Terrassez le porteguerre Qobi.", "Sconfiggi l'Araldo della Guerra Qobi.", "전쟁인도자 코비를 처치해야 합니다.", "Derrote o Armipotente Qobi.", "Победите Воителя Коби.", "击败战争使者虬碧。", "殺死戰爭使者闊畢。", }, 
},
["537"] = {
{ "Defeat the bosses of Stormstout Brewery.", "Besiegt die Bosse in der Brauerei Sturmbräu.", "Derrota a los jefes de la Cervecería del Trueno.", "Derrota a los jefes de la Cervecería del Trueno.", "Terrassez les boss de la brasserie Brune d’Orage.", "Sconfiggi i boss del Birrificio Triplo Malto.", "스톰스타우트 양조장 우두머리들을 처치해야 합니다.", "Derrote os chefes da Cervejaria Malte do Trovão.", "Победите боссов в хмелеварне Буйных Портеров.", "击败风暴烈酒酿造厂的首领。", "擊敗風暴烈酒酒坊的首領。", }, 
},
["637"] = {
{ "Destroy the Ash'ari Crystals to disable the ziggurats and gain access to the Slaughterhouse.", "Zerstört die Kristalle von Ash'ari, um die Ziggurats zu zerstören und Zugang zum Schlachthaus zu erhalten.", "Destruye los cristales Ash'ari para desactivar los zigurats y poder entrar en El Degolladero.", "Destruye los cristales Ash'ari para desactivar los zigurats y tener acceso al Matadero.", "Détruisez les cristaux d’Ash’ari pour désactiver les ziggourats et pouvoir accéder à l’abattoir.", "Distruggi i Cristalli Ash'ari per disattivare le Ziggurat e ottenere l'accesso al Mattatoio.", "애쉬아리 수정을 파괴해 지구라트를 정지시켜, 도살장으로 가는 길을 열어야 합니다.", "Destrua os Cristal Ash'ari para desativar os zigurates e ganhar acesso ao Abatedouro.", "Уничтожьте кристаллы Аш'ари, чтобы отключить зиккураты и проникнуть на бойню.", "摧毁阿莎利水晶以关闭通灵塔，并进入屠宰房。", "摧毀阿莎利水晶並關閉通靈塔，然後進入屠宰房。", }, 
{ "Defeat the abominations guarding the Slaughterhouse.", "Besiegt die Monstrositäten, die das Schlachthaus bewachen.", "Derrota a las abominaciones que vigilan El Degolladero.", "Derrota a las abominaciones que protegen el matadero", "Triomphez des abominations qui gardent l’abattoir.", "Sconfiggi gli abomini a guardia del Mattatoio.", "도살장을 지키는 누더기골렘들을 처치해야 합니다.", "Derrote as abominações que protegem o Abatedouro.", "Победите поганищ, охраняющих бойню.", "击败守卫屠宰房的憎恶。", "擊敗守衛屠宰房的憎惡體。", }, 
{ "Defeat Ramstein the Gorger.", "Bezwingt Ramstein den Verschlinger.", "Derrota a Ramstein el Empachador.", "Derrota a Ramstein el Empachador.", "Terrassez Ramstein Grandgosier.", "Sconfiggi Ramstein il Bramacarne.", "먹보 람스타인을 처치해야 합니다.", "Derrote Ramstein, o Devorador.", "Победите Рамштайна Ненасытного.", "击败吞咽者拉姆斯登。", "擊敗『暴食者』拉姆斯登", }, 
{ "Defeat the Black Guard Sentries and proceed into Lord Aurius Rivendare's domain.", "Besiegt die Wachposten der schwarzen Wache und dringt in Aurius Totenschwurs Reich vor.", "Derrota a los avizores Guardia Negra y entra en los dominios de lord Aurius Osahendido.", "Derrota a los centinelas de la guardia negra y avanza al dominio de Lord Aurius Osahendido.", "Terrassez les factionnaires de la Garde noire et progressez jusqu’au domaine du seigneur Aurius Vaillefendre.", "Sconfiggi gli Avvistatori della Guardia Nera e penetra nel dominio di Ser Aurius Fieramorte.", "검은호위대 보초병들을 처치하고 군주 아우리우스 리븐데어의 거처로 들어가야 합니다.", "Derrote as Sentinelas da Guarda Negra e prossiga para os domínios de Lorde Aurius Rivendare.", "Победите караульных Черной Стражи и проникните в покои лорда Аурия Ривендера.", "击败黑衣守卫斥候并进入奥里克斯·瑞文戴尔领主的领域。", "擊敗黑衣衛哨衛並繼續前往奧里爾斯‧瑞文戴爾的領域。", }, 
{ "Defeat Magistrate Barthilas.", "Bezwingt Magistrat Barthilas.", "Derrota al magistrado Barthilas.", "Derrota al Magistrado Barthilas.", "Terrassez le magistrat Barthilas.", "Sconfiggi il Magistrato Barthilas.", "집정관 발실라스를 처치해야 합니다.", "Derrote o Magistrado Barthilas.", "Победите мирового судью Бартиласа.", "击败巴瑟拉斯镇长。", "擊敗巴瑟拉斯鎮長", }, 
},
["940"] = {
{ "Baron Sliver should have already arrived. Search for him.", "Baron Splitter sollte bereits eingetroffen sein. Sucht nach ihm.", "El barón Tajada debería haber llegado ya. Búscalo.", "El Barón Tajada ya debe haber llegado. Búscalo.", "Le baron Lesquille devrait déjà être là. Partez à sa recherche.", "Il Barone Sliver dovrebbe essere già arrivato. Trovalo.", "남작 슬리버가 이미 도착해 있을 것입니다. 그를 찾아야 합니다.", "Barão Laska já deve ter chegado. Procure por ele.", "Барон Раздор должен быть где-то здесь. Найдите его.", "斯利文男爵应该已经到了。去找他。", "史力弗男爵應該已經抵達了。找到他。", }, 
{ "Follow Baron Sliver up the rise ahead.", "Folgt Baron Splitter auf die Anhöhe.", "Sigue al barón Tajada por la elevación.", "Sigue al Barón Tajada por la subida que hay más adelante.", "Suivez le baron Lesquille au sommet du talus.", "Segui il Barone Sliver sopra l'altura.", "남작 슬리버를 따라 전방의 봉우리로 가야 합니다.", "Siga o Barão Laska colina acima.", "Подниметесь на лежащую впереди возвышенность вслед за бароном Раздором.", "跟上前方的斯利文男爵。", "跟隨史力弗男爵登上前方的高地。", }, 
{ "A wall of flames blocks the path. Protect Baron Sliver while he disables the barrier.", "Eine Flammenwand blockiert den Weg. Beschützt Baron Splitter, während er die Barriere deaktiviert.", "Un muro de llamas bloquea el paso. Protege al barón Tajada mientras desactiva la barrera.", "Un muro de llamas te bloquea el paso. Protege al Barón Tajada mientras desactiva la barrera.", "Un mur de flammes vous barre la route. Protégez le baron Lesquille pendant qu’il neutralise la barrière.", "Un muro di fiamme blocca il passaggio. Proteggi il Barone Sliver mentre disattiva la barriera.", "불길이 치솟아 길이 막혀있습니다. 남작 슬리버가 방벽을 비활성화하는 동안 그를 보호해야 합니다.", "Uma muralha de chamas bloqueia o caminho. Proteja o Barão Laska enquanto ele desativa a barreira.", "Стена пламени преграждает вам путь. Защищайте барона Раздора, пока он рассеивает ее.", "一堵火墙拦住了去路。在斯利文男爵解除它的期间保护他。", "有道烈焰之牆擋住了道路。在史力弗男爵解除這道屏障的時候保護他。", }, 
{ "Follow Baron Sliver into Legion territory and search the camp.", "Folgt Baron Splitter ins Territorium der Legion und durchsucht das Lager.", "Sigue al barón Tajada hasta el territorio de la Legión e inspecciona el campamento.", "Sigue al Barón Tajada hasta el territorio de la Legión y busca el campamento.", "Suivez le baron Lesquille dans le territoire de la Légion et fouillez le camp.", "Segui il Barone Sliver nel territorio della Legione e ispeziona l'accampamento.", "남작 슬리버를 따라 군단의 영토로 들어간 다음 야영지를 조사해야 합니다.", "Siga o Barão Laska pelo território da Legião e reviste o acampamento.", "Следуйте за бароном Раздором вглубь территории Легиона и обыщите лагерь.", "跟随斯利文男爵深入军团领土并搜索营地。", "跟隨史力弗男爵進入燃燒軍團的領域然後搜索營地。", }, 
{ "Hunt down Inquisitor Zalinor and obtain his keystone.", "Jagt Inquisitor Zalinor und nehmt seinen Schlüsselstein an Euch.", "Persigue al inquisidor Zalinor y consigue su piedra angular.", "Persigue al Inquisidor Zalinor y consigue su piedra angular.", "Traquez l’inquisiteur Zalinor et récupérez sa clé.", "Insegui l'Inquisitore Zalinor e ottieni la sua Chiave di Pietra.", "심문관 잘리노르를 처치하고 쐐기돌을 획득해야 합니다.", "Cace o Inquisidor Zalinor e obtenha a pedra-chave dele.", "Найдите инквизитора Залинора и заберите его ключ.", "追踪审判官扎里诺，并获取他的钥石。", "獵殺審判官薩林諾，取得他的鑰石。", }, 
{ "With the keystone in hand release your ally.", "Befreit Euren Verbündeten mit dem Schlüsselstein in Eurer Hand.", "Con la piedra angular en tu poder, libera a tu aliado.", "Libera a tu aliado usando la piedra angular.", "Libérez votre acolyte à l’aide de la clé.", "Con l'aiuto della Chiave di Pietra, libera il tuo alleato.", "쐐기돌을 가지고 아군을 풀어줘야 합니다.", "Liberte o aliado com a pedra-chave.", "Воспользовавшись ключом инквизитора, освободите вашего союзника.", "钥石在手，你可以解放你的盟友了。", "用鑰石釋放你的夥伴。", }, 
{ "Travel to the citadel and assist Baron Sliver as he disables its barrier.", "Reist zur Zitadelle und unterstützt Baron Splitter, während er die Barriere deaktiviert.", "Viaja a la ciudadela y ayuda al barón Tajada mientras desactiva su barrera.", "Viaja a la ciudadela y ayuda al Barón Tajada mientras desactiva la barrera.", "Allez à la citadelle et aidez le baron Lesquille pendant qu’il en neutralise la barrière.", "Raggiungi la cittadella e aiuta il Barone Sliver mentre disattiva la barriera.", "성채로 간 다음 남작 슬리버가 방벽을 비활성화하는 것을 도와야 합니다.", "Vá à cidadela e ajude o Barão Laska a desativar a barreira.", "Отправляйтесь в цитадель и помогите барону Раздору развеять барьер.", "前往城堡，在斯利文男爵解除屏障期间保护他。", "前往堡壘，在史力弗男爵解除屏障的時候保護他。", }, 
{ "The way is open into the complex. Continue down into the structure and locate Margrave.", "Der Weg in den Komplex ist frei. Begebt Euch tiefer in das Bauwerk und sucht nach dem Markgrafen.", "El camino hacia el complejo está despejado. Penetra en la estructura y busca a Margrave.", "La entrada hacia el complejo está abierta. Baja por la estructura y localiza a Margrave.", "La voie est libre. Continuez à vous enfoncer dans le complexe et trouvez Margrave.", "La strada per il complesso è libera. Esplora la struttura e trova Margrave.", "성채 내부로 가는 길이 열렸습니다. 아래로 계속 내려가 마르그레이브를 찾아야 합니다.", "O caminho para o complexo está aberto. Adentre a estrutura para procurar Margrave.", "Путь в цитадель открыт. Проникните внутрь и отыщите маркграфа.", "通往设施的路已经敞开了。继续进入建筑的下方，找到玛格拉弗。", "可以進入堡壘了。繼續往下進入建築，找到瑪葛瑞弗。", }, 
{ "Gorelix has slain Margrave! Destroy the demon!", "Gorelix hat den Markgrafen getötet! Vernichtet den Dämon!", "¡Sangrelix ha matado a Margrave! ¡Acaba con ese demonio!", "¡Gorelix mató a Margrave! ¡Destruye al demonio!", "Tripelix a tué Margrave ! Terrassez ce démon !", "Gorelix ha ucciso Margrave! Elimina il demone!", "고어릭스가 마르그레이브를 죽였습니다! 악마가 대가를 치르게 하십시오!", "Sangrelix assassinou Margrave! Destrua o demônio!", "Гореликс убил маркграфа! Уничтожьте демона!", "高瑞里克斯处决了玛格拉弗！消灭那个恶魔！", "葛里克斯殺死了瑪葛瑞弗！消滅這個惡魔！", }, 
{ "With Gorelix dead his axe is now yours. Take it.", "Mit Gorelix' Tod ist seine Axt Euer. Nehmt sie.", "Tras la muerte de Sangrelix, su hacha es tuya. Cógela.", "Ahora que Gorelix está muerto, su hacha es tuya. Tómala.", "Maintenant que Tripelix est mort, sa hache est à vous. Prenez-la.", "Con la morte di Gorelix, l'ascia è finalmente tua. Prendila.", "고어릭스가 죽었으니 이제 그의 도끼는 당신의 것입니다. 도끼를 획득하십시오.", "Com Sangrelix morto, o machado dele é seu. Pegue-o.", "Теперь, когда Гореликс мертв, его топор ваш. Заберите его.", "高瑞里克斯已死，他的斧头是你的了。拿走它。", "葛里克斯已死，這把斧頭是你的了。拿起它。", }, 
{ "The Lich King await's news of your success. Use Baron Sliver's Death Gate to travel to Icecrown.", "Der Lichkönig erwartet Neuigkeiten über Euren Erfolg. Nutzt Baron Splitters schwarzes Tor, um nach Eiskrone zu reisen.", "El Rey Exánime espera noticias de tu triunfo. Usa el portón de la muerte del barón Tajada para viajar hasta Corona de Hielo.", "El Rey Exánime espera noticias de su éxito. Usa el Portón de la muerte del Barón Tajada para viajar a Corona de Hielo.", "Le roi-liche attend de vos nouvelles. Utilisez la porte de la mort créée par le baron Lesquille pour vous rendre à la Couronne de glace.", "Il Re dei Lich attende novità sul tuo successo. Usa il Portale della Morte del Barone Sliver per raggiungere la Corona di Ghiaccio.", "리치 왕이 당신의 승전보를 기다리고 있습니다. 남작 슬리버의 죽음의 관문을 통해 얼음왕관으로 이동해야 합니다.", "O Lich Rei aguarda notícias do seu sucesso. Use o Portão da Morte do Barão Laska para ir à Coroa de Gelo.", "Король-лич ждет вестей о вашем успехе. Отправьтесь в Ледяную Корону через Врата смерти барона Раздора.", "巫妖王等待着你胜利的消息，使用斯利文男爵的黑锋之门回到冰冠堡垒。", "巫妖王正在等候你的好消息。使用史力弗男爵的死亡之門以前往寒冰皇冠。", }, 
},
["237"] = {
{ "Speak to Rotun to begin a trial.", "Sprecht mit Rotun, um eine Prüfung zu beginnen.", "Habla con Rotun para comenzar una prueba.", "Habla con Rotun para comenzar una prueba.", "Parlez à Rotun pour lancer l’épreuve.", "Parla con Rotun per iniziare la prova.", "로툰과 대화해서 시험을 시작해야 합니다.", "Fale com Rotun para começar um teste.", "Поговорите с Ротуном, чтобы начать испытание.", "与罗敦交谈以开启试炼。", "和羅通交談以開始試煉。", }, 
},
["640"] = {
{ "Defeat the bosses of the Temple of Atal'hakkar", "Bezwingt die Bosse des Tempels von Atal'Hakkar.", "Derrota a los jefes del Templo de Atal'hakkar.", "Derrota a los jefes del templo de Atal'hakkar", "Triomphez des boss du temple d’Atal’hakkar.", "Sconfiggi i boss del Tempio di Atal'Hakkar.", "아탈학카르 신전 우두머리들을 처치해야 합니다.", "Derrote os chefes do Templo de Atal'Hakkar", "Победите боссов в храме Атал'Хаккара", "击败阿塔哈卡神庙的首领", "擊敗阿塔哈卡神廟的首領", }, 
},
["1253"] = {
{ "Defeat the forces of Xavius at the base of Shaladrassil.", "Bezwingt die Streitmacht von Xavius an den Wurzeln von Shaladrassil.", "Derrota a los ejércitos de Xavius en la base de Shaladrassil.", "Derrota a las fuerzas de Xavius en la base de Shaladrassil.", "Terrassez les forces de Xavius au pied de Shaladrassil.", "Sconfiggi le forze di Xavius alla base di Shaladrassil.", "샬라드라실 아래에 있는 자비우스의 군대를 물리쳐야 합니다.", "Derrote as forças de Xavius na base de Shaladrassil.", "Разгромите силы Ксавия у корней Шаладрассила.", "在莎拉达希尔的根部击败萨维斯的部队。", "在夏達希爾的根部擊敗薩維斯的部隊。", }, 
},
["1214"] = {
{ "Learn about being a Hunter.", "Erfahrt etwas über das Leben als Jäger.", "Infórmate sobre ser un cazador.", "Averigua más sobre ser un cazador.", "Apprenez-en davantage sur les chasseurs.", "Impara il significato di essere un Cacciatore.", "사냥꾼에 대해 배워야 합니다.", "Aprenda sobre os Caçadores.", "Узнайте, что значит быть охотником.", "学习如何成为一名猎人。", "學習如何當一名獵人。", }, 
{ "Learn about Call Pet.", "Erfahrt mehr über 'Begleiter rufen'.", "Infórmate sobre Llamar a mascota.", "Averigua más sobre Llamar a mascota.", "Apprenez-en davantage sur Appel du familier.", "Impara come usare Richiamo: Famiglio.", "야수 부르기에 대해 배워야 합니다.", "Aprenda sobre Chamar Ajudante.", "Научитесь применять \"Призыв питомца\".", "学习召唤宠物。", "學習如何召喚寵物。", }, 
{ "Learn about Harpoon.", "Erfahrt mehr über 'Harpune'.", "Infórmate sobre Arpón.", "Averigua más sobre Arpón.", "Apprenez-en davantage sur Harpon.", "Impara come usare Arpione.", "작살에 대해 배워야 합니다.", "Aprenda sobre Arpão.", "Научитесь применять \"Гарпун\".", "学习鱼叉猛刺。", "學習如何使用魚叉。", }, 
{ "Learn about Lacerate.", "Erfahrt mehr über 'Aufschlitzen'.", "Infórmate sobre Lacerar.", "Averigua más sobre Lacerar.", "Apprenez-en davantage sur Lacérer.", "Impara come usare Lacerazione.", "가르기에 대해 배워야 합니다.", "Aprenda sobre Lacerar.", "Научитесь применять \"Режущий удар\".", "学习裂痕。", "學習如何使用割裂。", }, 
{ "Learn about Flanking Strike.", "Erfahrt mehr über 'Flankenangriff'.", "Infórmate sobre Golpe de flanco.", "Averigua más sobre Golpe lateral.", "Apprenez-en davantage sur Frappe latérale.", "Impara come usare Assalto Fiancheggiato.", "측방 강타에 대해 배워야 합니다.", "Aprenda sobre Ataque Flanqueante.", "Научитесь применять \"Обходной удар\".", "学习侧翼打击", "學習如何使用側翼攻擊。", }, 
{ "Learn about Raptor Strike", "Erfahrt mehr über 'Raptorstoß'.", "Infórmate sobre Golpe de raptor.", "Averigua más sobre Golpe de raptor", "Apprenez-en davantage sur Attaque du raptor.", "Impara come usare Assalto del Raptor.", "랩터의 일격에 대해 배워야 합니다.", "Aprenda sobre Golpe do Raptor.", "Научитесь применять \"Удар ящера\".", "学习猛禽一击", "學會如何使用猛禽一擊。", }, 
{ "Learn about Mongoose Bite.", "Erfahrt mehr über 'Mungobiss'.", "Infórmate sobre Mordisco de mangosta.", "Averigua más sobre Mordedura de mangosta.", "Apprenez-en davantage sur Morsure de mangouste.", "Impara come usare Morso della Mangusta.", "살쾡이의 이빨에 대해 배워야 합니다.", "Aprenda sobre Mordida de Mangusto.", "Научитесь применять \"Укус мангуста\".", "学习猫鼬撕咬", "學習如何使用貓鼬撕咬。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Carve.", "Erfahrt mehr über 'Schlitzen'.", "Infórmate sobre Trinchar.", "Averigua más sobre Corte.", "Apprenez-en davantage sur Écharper.", "Impara come usare Scorticatura.", "저미기에 대해 배워야 합니다.", "Aprenda sobre Trinchar.", "Научитесь применять \"Разделку туши\".", "学习削凿。", "學習如何使用橫劈。", }, 
{ "Learn about Feign Death.", "Erfahrt mehr über 'Totstellen'.", "Infórmate sobre Fingir muerte.", "Averigua más sobre Fingir muerte.", "Apprenez-en davantage sur Feindre la mort.", "Impara come usare Morte Apparente.", "죽은 척하기에 대해 배워야 합니다.", "Aprenda sobre Fingir de Morto.", "Научитесь применять способность \"Притвориться мертвым\".", "学习假死。", "學習如何使用假死。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你学到的本领，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你学到的本领，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["651"] = {
{ "Defeat the bosses of the Scarlet Halls.", "Bezwingt die Bosse der Scharlachroten Hallen.", "Derrota a los jefes de las Cámaras Escarlata.", "Derrota a los jefes de las Cámaras Escarlata.", "Triomphez des boss des salles Écarlates.", "Sconfiggi i boss delle Sale Scarlatte.", "붉은십자군 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões Escarlates.", "Победите боссов в Залах Алого ордена.", "击败血色大厅的首领。", "擊敗血色大廳的首領。", }, 
{ "Defeat Armsmaster Harlan.", "Bezwingt Waffenmeister Harlan.", "Derrota al maestro de armas Harlan.", "Derrota al maestro de armas Harlan.", "Triomphez du maître d’armes Harlan.", "Sconfiggi il Maestro d'Armi Harlan.", "무기전문가 할란을 처치해야 합니다.", "Derrote o Mestre Armeiro Harlan.", "Победите воителя Гарлана.", "击败武器大师哈兰。", "擊敗武器大師哈倫。", }, 
},
["1328"] = {
{ "Find the Frozen Span before feral undead overwhelm you.", "Findet den Frostübergang, bevor die wilden Untoten Euch überwältigen.", "Encuentra el Tramo Congelado antes de que los no-muertos ferales te superen.", "Encuentra el Puente gélido antes de que los no-muertos ferales arrasen contigo.", "Trouvez le viaduc Gelé avant que les morts-vivants sauvages ne vous submergent.", "Trova il Baratro Congelato prima che i Non Morti Ferini abbiano la meglio su di te.", "야생 언데드를 물리치며 얼어붙은 교각을 찾으십시오.", "Encontre o Vão Glacial antes que os mortos-vivos ferais sobrepujem você.", "Отыщите Ледяные просторы, пока дикая нежить не одолела вас.", "在被狂野的亡灵淹没之前找到冰封之桥。", "在你被不死生物擊敗之前找到冰封大橋。", }, 
{ "Cross the span to Kyranastrasz' Rest.", "Überquert den Übergang zu Kyranastrasz' Ruhestätte.", "Cruza el tramo hacia el Reposo de Kyranastrasz.", "Cruza el puente hasta el Descanso de Kyranastrasz.", "Traversez le viaduc Gelé pour gagner le Repos de Kyranastrasz.", "Attraversa il baratro e raggiungi Requie di Kyranastrasz.", "교각을 건너 키라나스트라즈의 안식처로 가십시오.", "Cruze o vão até o Retiro de Kyranastrasz.", "Преодолейте пропасть, за которой лежит Последнее пристанище Киранастраза", "通过冰桥，前往吉拉纳斯塔兹之墓。", "橫越大橋前往凱拉納史卓茲之眠。", }, 
{ "Slay undead to collect the red dragon's essence.", "Tötet Untote, um die Essenz des roten Drachen zu sammeln.", "Mata no-muertos para reunir la esencia del dragón Rojo.", "Mata a los no-muertos para recolectar la esencia del dragón rojo.", "Tuez des morts-vivants pour récupérer l’essence du dragon rouge.", "Uccidi i non morti per raccogliere l'essenza del Drago Rosso.", "언데드를 처치해 붉은용의 정수를 모으십시오.", "Mate os mortos-vivos para coletar a essência do dragão vermelho.", "Убивайте нежить, чтобы собрать сущность красного дракона.", "击杀亡灵，收集红龙的精华。", "殺死不死生物取得紅龍精華。", }, 
{ "Convert the life essence to unholy essence.", "Wandelt die Lebensessenz in unheilige Essenz um.", "Convierte la esencia vital en esencia profana.", "Convierte la esencia de vida en esencia profana.", "Transformez l’essence vitale en essence impie.", "Converti l'essenza di vita in essenza empia.", "생명의 정수를 부정의 정수로 전환하십시오.", "Converta a essência da vida em essência profana.", "Преобразуйте сущность жизни сущность нечестивости.", "将生命精华转化为邪恶精华。", "把生命精華轉化成穢邪精華。", }, 
{ "Use the unholy essence to raise your dragon.", "Verwendet die unheilige Essenz, um Euren Drachen zu erwecken.", "Utiliza la esencia profana para alzar a tu dragón.", "Usa la esencia profana para despertar a tu dragón.", "Utilisez l’essence impie pour ressusciter votre dragon.", "Usa l'essenza empia per far risorgere il tuo drago.", "부정의 정수를 이용해 당신의 용을 일으키십시오.", "Use a essência profana para reanimar seu dragão.", "Воскресите дракона в облике нежити с помощью нечестивой сущности.", "使用邪恶精华复活你的巨龙。", "用穢邪精華來復活你的龍。", }, 
},
["959"] = {
{ "Defend against the Legion threat at Kharanos.", "Schlagt die Legionsbedrohung bei Kharanos zurück.", "Defiende Kharanos de la amenaza de la Legión.", "Lucha contra la amenaza de la Legión en Kharanos.", "Repoussez l’assaut de la Légion à Kharanos.", "Neutralizza la minaccia della Legione a Kharanos.", "군단의 위협에 맞서 카라노스를 방어해야 합니다.", "Defenda Kharanos contra a Legião.", "Ликвидируйте угрозу Легиона в Караносе.", "在卡拉诺斯抵抗燃烧军团的威胁。", "在卡拉諾斯對抗燃燒軍團的威脅。", }, 
{ "Defeat the Legion Commander threatening Kharanos.", "Bezwingt den Legionskommandanten, der Kharanos bedroht.", "Derrota al comandante de la Legión que amenaza Kharanos.", "Derrota al comandante de la Legión que amenaza Kharanos.", "Terrassez le commandant de la Légion qui menace Kharanos.", "Sconfiggi il Comandante della Legione che minaccia Kharanos.", "카라노스를 위협하는 군단 사령관을 처치해야 합니다.", "Derrote o Comandante de Legião que ameaça Kharanos.", "Победите командира Легиона, угрожающего Караносу.", "击败威胁卡拉诺斯的军团指挥官。", "擊敗威脅卡拉諾斯的燃燒軍團指揮官。", }, 
{ "Repel the Legion's forces throughout Dun Morogh.", "Schlagt die Streitkräfte der Legion in ganz Dun Morogh zurück.", "Rechaza a los ejércitos de la Legión de Dun Morogh.", "Repele a las fuerzas de la Legión en Dun Morogh.", "Repoussez les troupes de la Légion aux quatre coins de Dun Morogh.", "Respingi le forze della Legione sparse per Dun Morogh.", "던 모로 전역의 군단 세력을 격퇴해야 합니다.", "Rechace as forças da Legião em Dun Morogh.", "Отразите вторжение сил Легиона в Дун Мороге.", "击退丹莫罗各地的燃烧军团部队。", "在丹莫洛各地擊退燃燒軍團。", }, 
{ "Defeat the demon lord commanding the invasion at Kharanos.", "Bezwingt den Dämonenfürsten, der die Invasion von Kharanos befehligt.", "Derrota al señor demoníaco que lidera la invasión en Kharanos.", "Derrota al señor de los demonios que comanda la invasión en Kharanos.", "Terrassez le seigneur démon à la tête de l’armée d’invasion à Kharanos.", "Sconfiggi il Signore dei Demoni al comando dell'invasione a Kharanos.", "카라노스 침공을 지휘하는 악마 군주를 처치해야 합니다.", "Derrote o lorde-demônio que comanda a invasão à Kharanos.", "Победите повелителя демонов, командующего вторжением в Каранос.", "击败指挥入侵卡拉诺斯的恶魔领主。", "在卡拉諾斯擊敗指揮入侵行動的惡魔領主。", }, 
},
["636"] = {
{ "Balnazzar has risen an army of vile undead slaves, we cannot let him grow this army. Kill him while we still have a chance!", "Balnazzar hat ein Heer untoter Sklaven zum Leben erweckt, wir dürfen nicht zulassen, dass er sein Heer vergrößert. Ihr müsst ihn töten, solange wir noch die Gelegenheit dazu haben!", "Balnazzar ha levantado un ejército de viles esclavos no-muertos, no podemos permitir que engrose sus filas. ¡Mátalo mientras aún tengamos una oportunidad!", "Balnazzar reunió un ejército de esclavos no-muertos viles, no podemos dejar que lo fortalezca. ¡Matémoslo mientras podamos!", "Balnazzar a levé une ignoble armée d’esclaves morts-vivants. Nous ne pouvons pas lui permettre de la renforcer. Tuez-le tant que c’est encore possible !", "Balnazzar ha fatto risorgere un esercito di schiavi non morti: non possiamo permettere che la sua armata cresca ancora. Uccidilo prima che sia troppo tardi!", "발나자르가 끔찍한 언데드 노예로 이루어진 군대를 일으켰습니다. 그의 군대가 커지게 둘 수는 없습니다. 아직 기회가 있을 때 그를 처치해야 합니다!", "Balnazzar ergueu um exército de escravos mortos-vivos sinistros. Não podemos deixar esse exército crescer. Mate-o enquanto ainda é possível!", "Бальназар призвал армию нежити из числа мертвых рабов. Нельзя допустить, чтобы эта армия разрослась. Убей его, пока не поздно!", "巴纳扎尔唤起了一支邪恶的亡灵奴隶大军，我们不能让他的军力继续增长。快去杀了他，否则一切就太迟了！", "巴納札爾用邪惡的不死奴隸組成了一支軍隊，我們不能讓他繼續擴張軍隊規模。趁還來得及之前把巴納札爾幹掉！", }, 
{ "Defeat The Unforgiven.", "Bezwingt den Unverziehenen.", "Derrota a La Imperdonable.", "Derrota a La Imperdonable.", "Terrassez le Condamné.", "Sconfiggi L'Implacabile.", "용서받지 못한 자를 처치해야 합니다.", "Derrote o Imperdoável.", "Победите Непрощенного.", "击败不可宽恕者", "擊敗不可寬恕者。", }, 
{ "Defeated Hearthsinger Forresten", "Herdsinger Forresten bezwungen", "Derrota al Cantachimeneas Forresten.", "Cantachimeneas Forresten derrotado.", "Terrassez le chanteloge Forrestin.", "Sconfiggi Forresten il Cantastorie.", "하스싱어 포레스턴을 처치해야 합니다.", "Derrotou Cantalar Forresten", "Победите певчего Форрестена", "击败弗雷斯特恩", "擊敗爐邊歌手弗瑞斯坦", }, 
{ "Defeat Timmy the Cruel.", "Bezwingt Timmy den Grausamen.", "Derrota a Timmy el Cruel.", "Derrota Timmy el Cruel.", "Terrassez Timmy le Cruel.", "Sconfiggi Timmy il Crudele.", "잔혹한 티미를 처치해야 합니다.", "Derrote Tico, o Cruel.", "Победите Тимми Беспощадного.", "击败悲惨的提米。", "擊敗殘忍的提米。", }, 
{ "Defeat Postmaster Malown.", "Bezwingt Postmeister Malown.", "Derrota al jefe de correos Gassol.", "Derrota al Jefe de correos Gassol.", "Terrassez le postier Malown.", "Sconfiggi il Postino Malown.", "우체국장 말로운을 처치해야 합니다.", "Derrote o Chefe do Correio Malown.", "Победите почтальона Мэлоуна.", "击败邮差马龙。", "擊敗郵政局長瑪羅恩。", }, 
{ "Defeat Commander Malor.", "Bezwingt Kommandant Malor.", "Derrota al comandante Malor.", "Derrota al Comandante Malor.", "Terrassez le commandant Malor.", "Sconfiggi il Comandante Malor.", "사령관 말로를 처치해야 합니다.", "Derrote o Comandante Malor.", "Победите командира Малора", "击败指挥官玛洛尔。", "擊敗指揮官瑪洛爾。", }, 
{ "Defeat Willey Hopebreaker.", "Bezwingt Willey Hoffnungsbrecher.", "Derrota a Willey Rompeesperanzas.", "Derrota a Willey Rompeesperanzas.", "Terrassez Wiley Mutilespoir.", "Sconfiggi Willey Frangifede.", "윌리 호프브레이커를 처치해야 합니다.", "Derrote Gualter Quebrafé.", "Победите Вилли Разбивающего Надежды.", "击败希望破坏者威利。", "擊敗威利‧希望破除者。", }, 
{ "Defeat Instructor Galford.", "Bezwingt Instrukteur Galford.", "Derrota al instructor Galford.", "Derrota al Instructor Galford.", "Terrassez l’instructeur Galford.", "Sconfiggi l'Istruttore Galford.", "교관 갈포드를 처치해야 합니다.", "Derrote o Instrutor Galford.", "Победите инструктора Галфорда", "击败档案管理员加尔福特。", "擊敗古卷管理者加爾福特。", }, 
},
["536"] = {
{ "Defeat the bosses of Mogu'shan Palace.", "Besiegt die Bosse im Mogu'shanpalast.", "Derrota a los jefes del Palacio Mogu'shan.", "Derrota a los jefes del Palacio Mogu'shan.", "Terrassez les boss du palais Mogu’shan.", "Sconfiggi i boss del Palazzo Mogu'shan.", "모구샨 궁전 우두머리들을 처치해야 합니다.", "Derrote os chefes do Palácio Mogu'shan.", "Победите боссов во дворце Могу'шан.", "击败魔古山宫殿的首领。", "擊敗魔古山宮的首領。", }, 
},
["736"] = {
{ "Take the elevator to the arena", "Nehmt den Aufzug zur Arena.", "Toma el ascensor hasta la arena.", "Toma el ascensor a la arena", "Prenez le monte-charge pour l’Arène.", "Prendi l'ascensore per l'arena.", "승강기를 타고 투기장에 가야 합니다.", "Use o elevador da arena", "Отправьтесь на лифте на арену", "乘坐升降机前往竞技场", "上升降梯進入競技場", }, 
{ "Prepare for battle", "Bereitet Euch auf den Kampf vor.", "Prepárate para la batalla.", "Prepárate para la batalla", "Une bataille à préparer", "Preparati alla battaglia.", "전투를 준비해야 합니다.", "Preparar-se para a batalha", "Готовьтесь к бою", "准备战斗", "準備作戰", }, 
{ "Slay all opposing gladiators", "Tötet alle gegnerischen Gladiatoren.", "Mata a todos los gladiadores enemigos.", "Mata a todos los gladiadores contrarios", "Massacrez tous les Gladiateurs adverses.", "Uccidi tutti i gladiatori nemici.", "상대 검투사들을 모두 처치해야 합니다.", "Matar todos os gladiadores oponentes", "Убейте всех противостоящих вам гладиаторов", "击杀所有的角斗士对手", "殺光所有敵對的鬥士", }, 
},
["52"] = {
{ "Defeat the forces of the Scarlet Crusade.", "Bezwingt die Streitkräfte des Scharlachroten Kreuzzugs.", "Derrota a las fuerzas de la Cruzada Escarlata.", "Derrota a las fuerzas de la Cruzada Escarlata.", "Terrassez les troupes de la Croisade écarlate.", "Sconfiggi le forze della Crociata Scarlatta.", "붉은십자군 병력을 처치해야 합니다.", "Derrote as forças da Cruzada Escarlate.", "Победите силы Алого ордена.", "击败血色十字军。", "消滅血色十字軍的部隊。", }, 
},
["72"] = {
{ "Slay Alliance captains and rig powder barrels on all ships.", "Tötet Allianzkapitäne und manipuliert Pulverfässer auf allen Schiffen.", "Mata a los Capitanes de la Alianza y prepara los barriles de pólvora en todos los barcos.", "Mata a los Capitanes de la Alianza y prepara los barriles de pólvora en todos los barcos.", "Tuez tous les capitaines de l’Alliance et placez des barils de poudre sur tous les bateaux.", "Sconfiggi i Capitani dell'Alleanza e manometti i barili di polvere esplosiva su tutte le navi.", "얼라이언스 부대장을 처치하고 모든 배에 있는 화약통을 조작해야 합니다.", "Mate capitães da Aliança e posicione barris de pólvora em todos os navios.", "Убейте капитанов Альянса и подготовьте бочки с порохом на всех кораблях к взрыву.", "击败联盟队长并在全船安放炸药桶。", "殺了聯盟船長並在所有船上安置火藥桶。", }, 
{ "Inform Blastmaster Sparkfuse of your success.", "Informiert Sprengmeister Zündlunte über Euren Erfolg.", "Informa al maestro destructor Mechacentella de tu éxito.", "Informa al maestro destructor Mechacentella de tu éxito.", "Informez le maître-dynamiteur Mèchétincelle de votre réussite.", "Informa lo Scoppiomastro Brillamiccia del tuo successo.", "항구 입구에 있는 폭발물전문가 스파크퓨즈에게 화약통 조작을 완료했다는 사실을 알려야 합니다.", "Informe o Explodista Fagulhuzível sobre o seu sucesso.", "Сообщите подрывнику Бомбастеру об успехе операции.", "将你成功的消息告诉爆破大师光油。", "通知爆破專家火星塞你的成功。", }, 
{ "Slay Baldruc and his gryphons.", "Tötet Baldruc und seine Greifen.", "Asesina a Baldruc y a sus grifos.", "Asesina a Baldruc y a sus grifos.", "Tuez Baldruc et ses griffons.", "Sconfiggi Baldruc e i suoi Grifoni.", "발드럭과 그의 그리핀을 처치해야 합니다.", "Mate Baldruc e os grifos dele.", "Убейте Бальдрука и его грифонов.", "杀死巴德拉克和他的狮鹫。", "殺死巴德拉克和他的獅鷲獸。", }, 
{ "Destroy Big Bessa and sabotage any unmanned tanks.", "Zerstört die Dicke Bessa und sabotiert alle unbemannten Panzer.", "Acaba con Gran Bessa y sabotea todos los tanques desocupados.", "Acaba con Gran Bessa y sabotea todos los tanques desocupados.", "Détruisez la Grosse Bessa et sabotez tous les chars inoccupés.", "Distruggi la Grande Bessa e sabota i Carri Senza Equipaggio.", "무적의 베사를 파괴하고 무인 전차를 파괴해야 합니다.", "Destrua a Grande Mimosa e sabote os tanques não tripulados.", "Уничтожьте Большую Бессу и выведите из строя пустые танки.", "摧毁大贝莎，并破坏无人驾驶的坦克。", "摧毀大貝紗，並且破壞任何無人駕駛的坦克。", }, 
{ "Slay Hedric Evencane and free Thalen Songweaver from Foothold Citadel.", "Tötet Hedric Ebenstab und befreit Thalen Sangweber aus der Wehrzitadelle.", "Asesina a Hedric Cañalisa y libera a Thalen Tejecanto de la Ciudadela Garrida.", "Asesina a Hedric Cañalisa y libera a Thalen Tejecanto de la Ciudadela Garrida.", "Tuez Hédric Cannelisse et libérez Thalen Tissechant de la citadelle de Theramore.", "Sconfiggi Hedric Fracassa e libera Thalen Tessicanto nella Cittadella di Theramore.", "헤드릭 이븐케인을 처치하고 거점 요새에서 탈렌 송위버를 구출해야 합니다.", "Mate Hedric Canajusta e liberte Thalen Tececanto da Cidadela do Esteio.", "Убейте Хедрика Ровноступа и вызволите Талена Созвучие Песни из Цитадели.", "杀死赫德里克·伊文凯恩并释放囚禁在塞拉摩堡垒的萨伦·织歌者。", "殺死海瑞克·伊文凱恩，然後在據點城塞救出塔倫·織歌者。", }, 
},
["647"] = {
{ "Defeat Blackthorn's Lieutenants", "Bezwingt Schwarzdorns Leutnants", "Derrota a los tenientes de Espina Negra.", "Derrota a los Tenientes de Espina Negra", "Triomphez des lieutenants de Noirépine.", "Sconfiggi i Luogotenenti di Spinanera.", "블랙쏜의 부관들을 처치해야 합니다.", "Derrote os Tenentes de Abrunhal", "Победите приспешников Черношипа", "击败布莱克松的党羽", "擊敗黑棘的副官", }, 
{ "Defeat Death Speaker Blackthorn", "Bezwingt Todessprecher Schwarzdorn", "Derrota al portavoz de la muerte Espina Negra.", "Derrota al portavoz de la muerte Espina Negra", "Triomphez du nécrorateur Noirépine.", "Sconfiggi l'Oratore della Morte Spinanera.", "죽음예언자 블랙쏜을 처치해야 합니다.", "Derrote o Morta-voz Abrunhal", "Победите вестника смерти Черношипа", "击败亡语者布莱克松", "擊敗亡語者黑棘。", }, 
{ "Defeat Amnennar the Coldbringer", "Bezwingt Amnennar den Kältebringer", "Derrota a Amnennar el Gélido.", "Derrota a Amnennar el Gélido", "Triomphez d’Amnennar le Porte-Froid.", "Sconfiggi Amnennar l'Araldo del Freddo.", "혹한의 암네나르를 처치해야 합니다.", "Derrote Amnennar, o Frigífero.", "Победите Амненнара Хладовея", "击败寒冰之王亚门纳尔", "擊敗『寒冰使者』亞門納爾", }, 
},
["547"] = {
{ "Defeat all of the Echoes in End Time.", "Besiegt alle Echos in der Endzeit.", "Derrota a todos los ecos en el Fin de los Días.", "Derrota a todos los Ecos en el Fin de los Días.", "Terrassez tous les échos de la Fin des temps.", "Sconfiggi gli Echi nella Fine dei Tempi.", "시간의 끝 안에 있는 모든 환영을 처치해야 합니다.", "Derrote todos os Ecos no Fim dos Tempos.", "Победите все эха в Конце Времен.", "击败时光之末的所有残影。", "在終焉之刻擊敗所有回音", }, 
{ "Defeat Murozond in End Time.", "Besiegt Murozond in der Endzeit.", "Derrota a Murozond en el Fin de los Días.", "Derrota a Murozond en el Fin de los Días.", "Terrassez Murozond dans la Fin des temps.", "Sconfiggi Murozond nella Fine dei Tempi.", "시간의 끝 안에 있는 무르도즈노를 처치해야 합니다.", "Derrote Murozond no Fim dos Tempos.", "Победите Дорнозму в Конце Времен.", "击败时光之末的姆诺兹多。", "在終焉之刻擊敗姆多茲諾。", }, 
},
["247"] = {
{ "Step 1 description.", "Beschreibung für Schritt 1", "Step 1 description.", "Step 1 description.", "Description de l’étape 1.", "Descrizione fase 1.", "1단계 설명", "Descrição do passo 1.", "Описание 1-го этапа.", "第1阶段描述。", "步驟1說明。", }, 
{ "Step 2 description.", "Beschreibung für Schritt 2", "Step 2 description.", "Step 2 description.", "Description de l’étape 2.", "Descrizione fase 2.", "2단계 설명", "Descrição do passo 2.", "Описание 2-го этапа.", "第2阶段描述。", "步驟2說明。", }, 
{ "Step 3 description.", "Beschreibung für Schritt 3", "Step 3 description.", "Step 3 description.", "Description de l’étape 3.", "Descrizione fase 3.", "3단계 설명", "Descrição do passo 3.", "Описание 3-го этапа.", "第3阶段描述。", "步驟3說明。", }, 
{ "Step 4 description.", "Beschreibung für Schritt 4", "Step 4 description.", "Step 4 description.", "Description de l’étape 4.", "Descrizione fase 4.", "4단계 설명", "Descrição do passo 4.", "Описание 4-го этапа.", "第4阶段描述。", "步驟4說明。", }, 
{ "Step 5 description.", "Beschreibung für Schritt 5", "Step 5 description.", "Step 5 description.", "Description de l’étape 5.", "Descrizione fase 5.", "5단계 설명", "Descrição do passo 5.", "Описание 5-го этапа.", "第5阶段描述。", "步驟5說明。", }, 
{ "Step 6 description.", "Beschreibung für Schritt 6", "Step 6 description.", "Step 6 description.", "Description de l’étape 6.", "Descrizione fase 6.", "6단계 설명", "Descrição do passo 6.", "Описание 6-го этапа.", "第6阶段描述。", "步驟6說明。", }, 
},
["950"] = {
{ "Follow Geth'xun's trail of fel blood.", "Folgt Geth'xuns Teufelsblutspur.", "Sigue el rastro de sangre vil de Geth'xun.", "Sigue el rastro de sangre vil de Geth'xun.", "Suivre les traces de gangresang de Geth’xun", "Segui la traccia di vilsangue di Geth'xun.", "지옥 피 흔적을 따라 게트순을 추적해야 합니다.", "Siga a trilha de sangue vil de Geth'xun.", "Следуйте за Гет'зуном по его кровавому следу.", "追踪格斯逊洒下的魔血。", "追蹤蓋斯勳的魔化之血。", }, 
{ "Defeat the devouring imps.", "Bezwingt die verschlingenden Wichtel.", "Derrota a los diablillos devoradores.", "Derrota a los diablilos devoradores.", "Terrassez les diablotins dévorants.", "Sconfiggi gli Imp Divoratori.", "걸신스러운 임프를 물리쳐야 합니다.", "Derrote os diabretes devoradores.", "Победите бесов-пожирателей.", "击败贪吃的小鬼。", "擊敗吞噬小鬼。", }, 
{ "Follow Geth'xun's trail of fel blood.", "Folgt Geth'xuns Teufelsblutspur.", "Sigue el rastro de sangre vil de Geth'xun.", "Sigue el rastro de sangre vil de Geth'xun.", "Suivre les traces de gangresang de Geth’xun", "Segui la traccia di vilsangue di Geth'xun.", "지옥 피 흔적을 따라 게트순을 추적해야 합니다.", "Siga a trilha de sangue vil de Geth'xun.", "Следуйте за Гет'зуном по его кровавому следу.", "追踪格斯逊洒下的魔血。", "追蹤蓋斯勳的魔化之血。", }, 
{ "Defeat the Corrupted Gyreworm.", "Bezwingt den verderbten Schleifwurm.", "Derrota al gusaespiral corrupto.", "Derrota al Gusaespiral corrupto.", "Terrassez le girever corrompu.", "Sconfiggi il Cicloverme Corrotto.", "타락한 소용돌이벌레를 처치해야 합니다.", "Derrote o Litoverme Corrompido.", "Убейте оскверненного червинта.", "击败腐化的旋岩虫。", "擊倒腐化的渦旋蟲。", }, 
{ "Follow the trail to find Geth'xun.", "Folgt der Spur, um Geth'xun zu finden.", "Sigue el rastro para encontrar a Geth'xun.", "Sigue el rastro para encontrar a Geth'xun.", "Suivre la piste pour trouver Geth’xun", "Segui le tracce fino a trovare Geth'xun.", "흔적을 쫓아 게트순을 찾아야 합니다.", "Siga a trilha para encontrar Geth'xun.", "Идите по следу Гет'зуна, чтобы нагнать его.", "追踪线索，找到格斯逊。", "依循線索找到蓋斯勳。", }, 
{ "Acquire the Doomhammer!", "Bringt den Schicksalshammer in Euren Besitz!", "¡Hazte con el Martillo Maldito!", "¡Adquiere el Martillo Maldito!", "Récupérez Marteau-du-Destin !", "Ottieni Martelfato!", "둠해머를 획득해야 합니다!", "Obtenha o Martelo da Perdição!", "Заберите Молот Рока!", "获取毁灭之锤！", "取得末日錘！", }, 
{ "Use the Doomhammer to destroy Geth'xun.", "Benutzt den Schicksalshammer, um Geth'xun zu vernichten.", "Usa el Martillo Maldito para destruir a Geth'xun.", "Usa el Martillo Maldito para destruir a Geth'xun!", "Utilisez Marteau-du-Destin pour anéantir Geth’xun.", "Usa Martelfato per distruggere Geth'xun.", "둠해머를 휘둘러 게트순을 처치해야 합니다.", "Use o Martelo da Perdição para destruir Geth'xun.", "Используйте Молот Рока, чтобы уничтожить Гет'зуна.", "使用毁灭之锤毁灭格斯逊。", "用末日錘擊倒蓋斯勳。", }, 
{ "Help Stormcaller Mylra.", "Helft Sturmruferin Mylra.", "Ayuda a la clamatormentas Mylra.", "Ayuda a Clamatormentas Mylra.", "Aider la mande-foudre Mylra", "Aiuta l'Invocatrice delle Tempeste Mylra.", "폭풍소환사 마일라를 도와야 합니다.", "Ajude Tempestária Mylra.", "Помогите буревестнице Милре.", "帮助风暴召唤者米尔拉。", "協助風暴召喚者米爾拉。", }, 
},
["650"] = {
{ "Defeat the bosses of the Scarlet Halls.", "Bezwingt die Bosse der Scharlachroten Hallen.", "Derrota a los jefes de las Cámaras Escarlata.", "Derrota a los jefes de las Cámaras Escarlata.", "Triomphez des boss des salles Écarlates.", "Sconfiggi i boss delle Sale Scarlatte.", "붉은십자군 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões Escarlates.", "Победите боссов в Залах Алого ордена.", "击败血色大厅的首领。", "擊敗血色大廳的首領。", }, 
{ "Defeat Armsmaster Harlan.", "Bezwingt Waffenmeister Harlan.", "Derrota al maestro de armas Harlan.", "Derrota al maestro de armas Harlan.", "Triomphez du maître d’armes Harlan.", "Sconfiggi il Maestro d'Armi Harlan.", "무기전문가 할란을 처치해야 합니다.", "Derrote o Mestre Armeiro Harlan.", "Победите воителя Гарлана.", "击败武器大师哈兰。", "擊敗武器大師哈倫。", }, 
},
["1256"] = {
{ "Board the Naglfar and face Helya in her own domain.", "Geht an Bord der Naglfar und tretet Helya in ihrem eigenen Reich entgegen.", "Sube a bordo del Naglfar y enfréntate a Helya en su propio territorio.", "Aborda el Naglfar y enfrenta a Helya en sus propios dominios.", "Montez à bord du Naglfar et affrontez Helya sur son propre terrain.", "Abborda la Naglfar e affronta Helya nel suo territorio.", "나글파르에 탑승하여, 헬리아의 영역에서 헬리아와 맞서야 합니다.", "Suba em Naglfar e enfrente Helya em seus próprios domínios.", "Проберитесь на борт \"Нагльфара\" и сразитесь с Хелией на ее территории.", "登上纳格法尔号，在海拉的领域面对她。", "登上奈格法號，在黑爾雅的地盤上對付她。", }, 
},
["1306"] = {
{ "Speak with Skylord Shadegrove", "Sprecht mit Himmelsfürst Schattenhain.", "Habla con el señor del cielo Frondagrís.", "Habla con el Señor del cielo Crecesombra", "Parlez au seigneur du ciel Sylvebrume.", "Parla con il Signore dei Cieli Boscombroso.", "하늘군주 셰이드그로브와 대화", "Fale com o Senhor Celeste Bosquescuro.", "Поговорите с повелителем небес Тенистой Рощей.", "与啸天者沙德格弗交谈", "與傲天者影林交談", }, 
{ "Kill demons attacking the Shrine", "Tötet Dämonen, die den Schrein angreifen.", "Acaba con los demonios que atacan el santuario.", "Mata a los demonios que atacan el santuario.", "Tuez les démons qui attaquent le sanctuaire.", "Uccidi i demoni che stanno assaltando il Santuario", "제단을 공격하는 악마를 처치해야 합니다.", "Mate os demônios que estão atacando o Santuário.", "Убейте демонов, атакующих святилище.", "击杀攻击神殿的恶魔。", "殺死攻擊聖壇的惡魔", }, 
{ "Return to the Shrine and investigate the screams", "Kehrt zum Schrein zurück und ermittelt den Ursprung der Schreie.", "Regresa al santuario e investiga los gritos.", "Regresa al santuario e investiga el origen de los gritos.", "Retournez au sanctuaire et tâchez de découvrir l’origine des cris.", "Torna al Santuario e indaga sulle urla.", "제단으로 돌아가 비명을 조사해야 합니다.", "Retorne ao Santuário e investigue os gritos.", "Вернитесь в святилище и выясните, что там произошло.", "返回圣殿，调查尖叫声。", "返回聖壇調查哀嚎聲的來源", }, 
{ "Reveal the traitor in the Shrine", "Entlarvt den Verräter am Schrein.", "Descubre al traidor del santuario.", "Revela al traidor en el santuario", "Démasquez le traître dans le sanctuaire.", "Rivela il traditore nel Santuario.", "제단에서 배신자를 색출해야 합니다.", "Desmascare o traidor no Santuário.", "Выявите предателя в святилище.", "找出圣殿里的叛徒", "找出聖壇裡的叛徒", }, 
{ "(Optional) Use Teleport: Dreamway", "(Optional) Verwendet 'Teleport: Traumpfad'.", "(Opcional) Utiliza Teletransporte a: Camino del Sueño.", "(Opcional) Usa Teletransporte: Senda de los sueños", "(Optionnel) Utilisez Téléportation : chemin du Rêve.", "(Facoltativo) Usa il Teletrasporto: Metasogno.", "(선택) 순간이동 사용: 꿈길", "(Opcional) Use Teleporte: Estrada Onírica", "Используйте \"Телепортацию: Путь Снов\" (необязательно).", "（可选）使用传送：梦境之路", "(可跳過)使用傳送器：翡翠夢途", }, 
},
["1203"] = {
{ "Secure the Grand Promenade.", "Sichert die Große Promenade.", "Asegura el Gran Paseo.", "Asegura el Gran Paseo.", "Sécurisez la Grande promenade.", "Prendi il controllo della Gran Terrazza.", "대정원을 확보해야 합니다.", "Tome o Grande Passeio.", "Захватите Центральный променад.", "肃清大步道", "占領漫步宏園。", }, 
{ "Defeat the Ancient Shieldguard", "Bezwingt den uralten Schildwächter", "Derrota al guardia protector antiguo.", "Derrota al Escudero ancestral", "Vaincre l’ancien garde-bouclier.", "Sconfiggi lo Scudiero Antico.", "고대 방패수호병 처치", "Derrote o Guarda de Elite Antigo", "Победите древнего стража щита", "击败上古神盾卫士", "擊敗遠古盾衛", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["329"] = {
{ "Kill inhabitants of rooms to extinguish runes.", "Tötet die Bewohner der Räume, um Runen zu löschen.", "Mata a los moradores de las habitaciones para extinguir runas.", "Mata a moradores de salas para extinguir las runas.", "Tuez les occupants des pièces pour éteindre les runes.", "Uccidi i nemici nelle stanze per estinguere le rune.", "방 안의 생명체들을 처치해 룬을 꺼뜨려야 합니다.", "Mate os habitantes das salas para extinguir as runas.", "Убивайте обитателей покоев, чтобы погасить руны.", "消灭房间内的人以熄灭符文。", "殺死房內的敵人以熄滅符文。", }, 
{ "Defeat the Ironmarch forces occupying the halls of the Spire.", "Besiegt die Truppen des Eisernen Marsches, die die Hallen der Schwarzfelsspitze besetzen.", "Derrota a las tropas de La Marcha de Hierro que ocupan las salas de la Cumbre.", "Derrota a las fuerzas Marcha Férrea que ocupan las cámaras de la Cumbre.", "Terrassez les troupes marchefer qui occupent les salles du pic Rochenoire.", "Sconfiggi le forze della Marcia di Ferro che hanno occupato le sale dei Bastioni di Roccianera.", "첨탑을 장악한 강철선봉대 군대를 무찔러야 합니다.", "Derrote as tropas da Marcha de Ferro que ocupam os salões do Pináculo.", "Победите войска Железного Марша, занявшие залы пика.", "击败占据了黑石塔大厅的铁军部队。", "擊敗佔據了黑石塔上層的鋼鐵戰線部隊。", }, 
},
["629"] = {
{ "Defeat the bosses within Mana-Tombs", "Bezwingt die Bosse in der Managruft.", "Derrota a los jefes de las Tumbas de Maná.", "Derrota a los jefes en las Tumbas de Maná.", "Terrassez les boss de Tombes-mana.", "Sconfiggi i boss delle Tombe del Mana.", "마나 무덤 우두머리들을 처치해야 합니다.", "Derrote os chefes das Tumbas de Mana", "Победите боссов в Гробницах Маны", "击败法力陵墓的首领", "擊敗法力墓地的首領", }, 
{ "Defeat Yor", "Bezwingt Yor", "Derrota a Yor.", "Derrota a Yor.", "Terrassez Yor.", "Sconfiggi Yor.", "요르를 처치해야 합니다.", "Derrote Yor", "Победите Йора", "击败尤尔", "擊敗約兒", }, 
},
["429"] = {
{ "Stop the Grimrail from delivering its deadly payload.", "Verhindert, dass der Grimmzug seine tödliche Fracht abliefert.", "Evita que el Malavía entregue su cargamento mortal.", "Detén al Riel Siniestro para que no entregue su carga mortal.", "Empêchez le Tristerail d’acheminer sa cargaison mortelle.", "Impedisci al Frecciacupa di consegnare il suo mortale carico.", "파멸철로 기차가 목적지에 도착하지 못하게 막아야 합니다.", "Impeça que o Carrilcruel entregue sua carga mortal.", "Не допустите, чтобы поезд Мрачных Путей доставил свой смертельный груз.", "阻止恐轨号将它致命的货物运抵目的地。", "阻止恐軌列車運送致命的武器。", }, 
},
["248"] = {
{ "The trial is about to begin.", "Die Prüfung beginnt in Kürze.", "La prueba está a punto de comenzar.", "La prueba está a punto de comenzar.", "L’épreuve est sur le point de commencer.", "La prova sta per cominciare.", "시험이 곧 시작됩니다.", "O teste está prestes a começar.", "Испытание вот-вот начнется.", "试炼即将开始。", "試煉即將開始。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["548"] = {
{ "Defeat the bosses of Throne of the Tides.", "Besiegt die Bosse im Thron der Gezeiten.", "Derrota a los jefes del Trono de las Mareas.", "Derrota a los jefes del Trono de las Mareas.", "Terrassez les boss du Trône des marées.", "Sconfiggi i boss del Trono delle Maree.", "파도의 왕좌 우두머리들을 처치해야 합니다.", "Derrote os chefes do Trono das Marés.", "Победите боссов у Трона Приливов.", "击败潮汐王座的首领。", "擊敗海潮王座的首領。", }, 
{ "Rescue Erunak Stonespeaker from Mindbender Ghur'sha.", "Rettet Erunak Steinsprecher vor Geistbeuger Ghur'sha.", "Rescata a Erunak Hablapiedra del dominamentes Ghur'sha.", "Rescata a Erunak Hablapiedra de los dominamentes Ghur'sha.", "Sauvez Erunak Parlepierre du torve-esprit Ghur’sha.", "Salva Erunak Parlapietra da Ghur'sha il Plagiamente.", "환각술사 구르샤에게서 에루낙 스톤스피커를 구출해야 합니다.", "Resgate Erunak Falapedra do Dobramentes Ghur'sha.", "Вызволите Эрунака Говорящего с Камнем из плена подчиняющего разум Гур'ши.", "将石语者埃鲁纳克从蛊心魔古厄夏手中救出。", "從屈心者哥爾薩的手中解救伊魯納克‧石語者。", }, 
},
["646"] = {
{ "The key to lifting the curse of this place rests in the final death of Darkmaster Gandling.", "Nur der endgültige Tod von Dunkelmeister Gandling kann diesen Ort von dem Fluch befreien, der darauf lastet.", "La clave para acabar con la maldición de este lugar está en la muerte del maestro oscuro Gandling.", "La clave para acabar con la maldición de este lugar reside en acabar con el maestro oscuro Gandling.", "Le seul moyen de lever la malédiction qui règne sur cet endroit est d’éliminer le Sombre Maître Gandling.", "La chiave per rimuovere la maledizione presente in questo luogo risiede nella morte del Maestro Oscuro Gandling.", "이곳에 드리운 저주를 없애려면 암흑스승 간들링을 처치해야만 합니다.", "Apenas a morte final do Umbromestre Gandling pode quebrar a maldição deste lugar.", "Проклятие не покинет это место, пока жив темный магистр Гандлинг.", "解除此地诅咒的关键就在于彻底杀死黑暗院长加丁。", "要解除這個地方的詛咒，關鍵就在於黑暗院長加丁的死亡。", }, 
},
["648"] = {
{ "Defeat the bosses of Uldaman", "Bezwingt die Bosse von Uldaman.", "Derrota a los jefes de Uldaman.", "Derrota a los jefes de Uldaman", "Triomphez des boss d’Uldaman.", "Sconfiggi i boss di Uldaman.", "울다만 우두머리들을 처치해야 합니다.", "Derrote os chefes de Uldaman", "Победите боссов в Ульдамане", "击败奥达曼的首领", "擊敗奧達曼的首領", }, 
{ "Defeat the Obsidian Sentinel", "Bezwingt den Obsidianwächter", "Derrota al centinela obsidiana.", "Derrota al centinela Obsidiana", "Triomphez de la Sentinelle d’obsidienne.", "Sconfiggi la Sentinella di Ossidiana.", "흑요석 파수꾼을 처치해야 합니다.", "Derrote a Sentinela de Obsidiana", "Победите Обсидианового часового", "击败黑曜石哨兵", "擊敗黑曜石哨兵", }, 
{ "Defeat the Ancient Stone Keeper", "Bezwingt den uralten Steinbewahrer", "Derrota al vigilante de piedra anciano.", "Derrota al Vigilante de piedra anciano", "Triomphez de l’Ancien gardien en pierre.", "Sconfiggi il Protettore Antico della Pietra.", "고대 바위 문지기를 처치해야 합니다.", "Derrote o Antigo Protetor de Pedra", "Победите Древнего каменного хранителя", "击败远古巨石卫士", "擊敗上古石之守衛者", }, 
{ "Defeat Galgann Firehammer", "Bezwingt Galgann Feuerhammer", "Derrota a Galgann Flamartillo.", "Derrota a Galgann Flamartillo.", "Triomphez de Galgann Martel-de-feu.", "Sconfiggi Galgann Ardimartello.", "갈간 파이어해머를 처치해야 합니다.", "Derrote Galnann Martelígneo", "Победите Галганна Огнемолота", "击败加加恩·火锤", "擊敗加加恩‧火錘", }, 
{ "Defeat Grimlok", "Bezwingt Grimlok", "Derrota a Grimlok.", "Derrota a Grimlok", "Triomphez de Grimelok.", "Sconfiggi Tetrok.", "그림로크를 처치해야 합니다.", "Derrote Grimlok", "Победите Гримлока", "击败格瑞姆洛克", "擊敗格瑞姆洛克", }, 
},
["897"] = {
{ "Defend against the Legion threat at the Sentinel Hill.", "Schlagt die Legionsbedrohung bei Späherkuppe zurück.", "Defiende Colina del Centinela de la amenaza de la Legión.", "Lucha contra la amenaza de la Legión en la Colina del Centinela.", "Repoussez l’assaut de la Légion à la colline des Sentinelles.", "Neutralizza la minaccia della Legione a Guardiacolle.", "군단의 위협에 맞서 감시의 언덕을 방어해야 합니다.", "Defenda o Morro da Sentinela da Legião.", "Ликвидируйте угрозу Легиона для Сторожевого холма.", "解除燃烧军团对哨兵岭的威胁。", "在哨兵嶺對抗燃燒軍團的威脅。", }, 
{ "Defeat the Legion Commander threatening Sentinel Hill.", "Bezwingt den Kommandanten der Legion, der Späherkuppe bedroht.", "Derrota al comandante de la Legión que amenaza Colina del Centinela.", "Derrota al comandante de la Legión que amenaza la Colina del Centinela.", "Terrassez le commandant de la Légion qui menace la colline des Sentinelles.", "Sconfiggi il Comandante della Legione che minaccia Guardiacolle.", "감시의 언덕을 위협하는 군단 사령관을 처치해야 합니다.", "Derrote o Comandante de Legião que ameaça o Morro da Sentinela.", "Победите командира Легиона, угрожающего Сторожевому холму.", "击败威胁哨兵岭的军团指挥官。", "擊敗威脅哨兵嶺的燃燒軍團指揮官", }, 
{ "Repel the Legion's forces throughout Westfall.", "Schlagt die Streitkräfte der Legion in ganz Westfall zurück.", "Rechaza a los ejércitos de la Legión de los Páramos de Poniente.", "Repele a las fuerzas de la Legión en Páramos de Poniente.", "Repoussez les troupes de la Légion dans la marche de l’Ouest.", "Respingi le forze della Legione sparse nelle Marche Occidentali.", "서부 몰락지대 전역에 있는 군단 세력을 격퇴해야 합니다.", "Rechace as forças da Legião em Cerro Oeste.", "Отразите вторжение сил Легиона в Западном Крае.", "击退西部荒野的军团部队。", "在西部荒野各地擊退燃燒軍團。", }, 
{ "Defeat the Demon Lord commanding the invasion.", "Bezwingt den Dämonenfürsten, der die Invasion befehligt.", "Derrota al señor demoníaco que lidera la invasión.", "Derrota al señor de los demonios que comanda la invasión.", "Terrassez le seigneur démon à la tête de l’armée d’invasion.", "Sconfiggi il Signore Eredar della Legione Infuocata.", "침공을 지휘하는 악마 군주를 처치해야 합니다.", "Derrote o lorde-demônio que comanda a invasão.", "Победите повелителя демонов, командующего вторжением.", "击败指挥入侵的恶魔领主。", "擊敗指揮入侵行動的惡魔領主。", }, 
},
["997"] = {
{ "test", "Blah", "Blah", "Bla", "Blah", "Prova", "test", "test", "Blah", "测试", "test", }, 
},
["596"] = {
{ "Defeat the bosses of Utgarde Keep", "Bezwingt die Bosse der Burg Utgarde.", "Derrota a los jefes de la Fortaleza de Utgarde.", "Derrota a los jefes de la Fortaleza de Utgarde.", "Terrassez les boss du donjon d’Utgarde.", "Sconfiggi i boss del Forte Utgarde.", "우트가드 성채 우두머리들을 처치해야 합니다.", "Derrote os chefes do Bastilha Utgarde.", "Победите боссов в крепости Утгард", "击败乌特加德城堡的首领", "擊敗俄特加德要塞的首領", }, 
},
["593"] = {
{ "Defeat the bosses of Ahn'kahet: The Old Kingdom", "Bezwingt die Bosse von Ahn'kahet: Das Alte Königreich.", "Derrota a los jefes de Ahn’kahet: El Antiguo Reino.", "Derrota a los jefes de Ahn'kahet: El Antiguo Reino.", "Terrassez les boss d’Ahn’kahet : l’Ancien royaume.", "Sconfiggi i boss di Ahn'kahet, il Regno Antico.", "안카헤트: 고대 왕국의 우두머리들을 처치해야 합니다.", "Derrote os chefes de Ahn'kahet: O Velho Reino", "Победите боссов в Ан'кахете: Старом Королевстве", "击败安卡赫特：古代王国的首领", "擊敗安卡罕特：古王國的首領", }, 
{ "Defeat Amanitar", "Besiegt Amanitar", "Derrota a Amanitar.", "Derrota Amanitar.", "Terrassez Amanitar", "Sconfiggi Amanitar.", "아마니타르를 처치해야 합니다.", "Derrote Amanitar", "Победите Аманитара", "击败埃曼尼塔", "擊敗毒蕈魔", }, 
},
["1136"] = {
{ "Speak to Khadgar when you are ready for him to begin channeling his essence into the arcance vessel.", "Sprecht mit Khadgar, wenn Ihr bereit seid und er damit beginnen kann, seine Essenz in das arkane Gefäß zu kanalisieren.", "Habla con Khadgar cuando quieras que empiece a canalizar su esencia en el recipiente Arcano.", "Habla con Khadgar cuando estés listo para comenzar a canalizar su esencia a la vasija arcana.", "Parlez à Khadgar lorsque vous voudrez qu’il commence à canaliser son essence dans le calice arcanique.", "Parla con Khadgar quando sarai $gpronto:pronta; a iniziare a incanalare la sua essenza nel contenitore arcano.", "준비되면 카드가와 대화하여 정수를 비전 용기에 집중하도록 해야 합니다.", "Quando estiver pronto, fale com Hadggar para que ele canalize a própria essência para o receptáculo arcano.", "Поговорите с Кадгаром, когда будете готовы, чтобы он начал переносить свою сущность в чародейский сосуд.", "当你准备好后，和卡德加谈谈，开始将他的精华注入到奥术容器中。", "等你準備好開始把卡德加的靈魂引導到秘法容器中時，就去跟卡德加交談。", }, 
{ "Watch over Archmage Khadgar as he channels his essence into the arcane vessel.", "Wacht über Erzmagier Khadgar, während er seine Essenz in das arkane Gefäß kanalisiert.", "Vigila al archimago Khadgar mientras canaliza su esencia en el recipiente Arcano.", "Vigila al Archimago Khadgar mientras canaliza su esencia a la vasija arcana.", "Protégez l’archimage Khadgar pendant qu’il canalise son essence dans le calice arcanique.", "Difendi l'Arcimago Khadgar mentre incanala la sua essenza nel contenitore arcano.", "대마법사 카드가가 그의 정수를 비전 용기에 집중하는 동안 그를 보호해야 합니다.", "Proteja o Arquimago Hadggar enquanto ele canaliza a própria essência para o receptáculo arcano.", "Смотрите, как верховный маг Кадгар переносит свою сущность в чародейский сосуд.", "在大法师卡德加引导精华注入到容器中时，照看他的四周。", "在大法師卡德加把靈魂引導到秘法容器中的過程中保護他。", }, 
{ "Use your Flare to see if Hakkar has taken the bait.", "Benutzt das Leuchtfeuer, um zu sehen, ob Hakkar angebissen hat.", "Usa tu bengala para ver si Hakkar ha mordido el anzuelo.", "Usa tu Bengala para ver si Hakkar ha mordido la carnada.", "Utilisez votre fusée éclairante pour voir si Hakkar a mordu à l’appât.", "Usa il tuo Bengala per scoprire se Hakkar è caduto nella trappola.", "섬광을 사용하여 학카르가 미끼를 물었는지 확인해야 합니다.", "Use o archote para ver se Hakkar mordeu a isca.", "Воспользуйтесь \"Осветительной ракетой\", чтобы узнать, проглотил ли Хаккар наживку.", "用照明弹查看哈卡是否上钩。", "用你的照明彈，看哈卡爾是否上鉤。", }, 
{ "Defeat Hakkar's felhounds, Kreenam and Czaadym.", "Bezwingt Hakkars Teufelshunde Kreenam und Czaadym.", "Derrota a los canes manáfagos de Hakkar, a Kreenam y Czaadym.", "Derrota a los canes manáfagos de Hakkar, Kreenam y Czaadym.", "Terrassez Kreenam et Czaadym, les gangrechiens d’Hakkar.", "Sconfiggi i Vilsegugi di Hakkar, Kreenam e Czaadym.", "학카르의 지옥사냥개 크리남과 크자딤을 처치해야 합니다.", "Derrote os canisvis de Hakkar, Krynam e Czaadym.", "Одолейте гончих Скверны Хаккара – Кринама и Чаадыма.", "击败哈卡的地狱犬克里纳姆和扎迪姆。", "擊敗哈卡爾的惡魔犬，克力南和紮丁姆。", }, 
{ "Defeat Hakkar the Houndmaster within the Violet Hold.", "Besiegt Hakkar den Hundemeister in der Violetten Festung.", "Derrota a Hakkar, el maestro de canes, en El Bastión Violeta.", "Derrota a Hakkar el Maestro de los canes dentro del Bastión Violeta.", "Terrassez Hakkar le dresseur de molosses dans l’enceinte du fort Pourpre.", "Sconfiggi Hakkar il Maestro dei Segugi nella Fortezza Violacea.", "보랏빛 요새에 있는 사냥개조련사 학카르를 처치해야 합니다.", "Derrote Hakkar, o Mestre de Matilha, dentro do Castelo Violeta.", "Победите псаря Хаккара в Аметистовой крепости.", "在紫罗兰监狱中击败驯犬者哈卡。", "在紫羅蘭堡擊敗『馴犬者』哈卡爾。", }, 
{ "Let Archmage Khadgar know that Dalaran will be safe, thanks to your heroic actions.", "Lasst Erzmagier Khadgar wissen, dass Dalaran dank Eurer heldenhaften Taten in Zukunft sicher sein wird.", "Informa al archimago Khadgar de que Dalaran estará a salvo gracias a tus actos heroicos.", "Asegúrale al Archimago Khadgar que Dalaran estará a salvo gracias a tus actos heroicos.", "Informez l’archimage Khadgar que Dalaran est en sécurité grâce à vos actes héroïques.", "Informa l'Arcimago Khadgar che Dalaran è al sicuro grazie alle tue azioni eroiche.", "당신의 영웅적인 활약 덕에 이제 달라란은 안전하다고 대마법사 카드가에게 알려야 합니다.", "Comunique ao Arquimago Hadggar que Dalaran estará segura, graças aos seus feitos heroicos.", "Верховный маг Кадгар должен узнать, что теперь Даларан в безопасности – благодаря вашей отваге.", "让大法师卡德加知道，由于你的英勇举动，达拉然会安然无恙。", "告訴大法師卡德加，因為你的英勇行為，達拉然現在安然無恙。", }, 
},
["1085"] = {
{ "You've emerged upon a ship of the Burning Legion to find your allies have become seperated in battle. Help Vindicator Boros recover from his injuries.", "Ihr seid auf einem Schiff der Brennenden Legion angekommen und müsst feststellen, dass Eure Verbündeten im Kampf getrennt wurden. Helft Verteidiger Boros, sich von seinen Verletzungen zu erholen.", "Has aparecido en una nave de la Legión Ardiente solo para descubrir que tus aliados se han separado durante la batalla. Ayuda al vindicador Boros a recuperarse de sus heridas.", "Llegaste a una nave de La Legión Ardiente y descubriste que tus aliados están perdiendo la batalla. Ayuda al Vindicador Boros a recuperarse de sus heridas.", "Vous voilà sur un vaisseau de la Légion ardente à la recherche de vos alliés dispersés au combat. Aidez le redresseur de torts Boros à panser ses blessures.", "Ti ritrovi su una nave della Legione Infuocata alla ricerca dei tuoi alleati, che si sono separati durante la battaglia. Aiuta il Vendicatore Boros a riprendersi dalle sue ferite.", "당신은 전투 중 흩어진 아군을 찾으려고 불타는 군단의 함선에 왔습니다. 구원자 보로스가 원기를 회복하는 것을 도와야 합니다.", "Você emergiu em um navio da Legião Ardente e descobriu que seus aliados se separaram em combate. Ajude o Vindicante Boros a se recuperar dos ferimentos.", "Вы оказались на борту корабля Легиона и обнаружили, что в пылу битвы ваши союзники разделились. Помогите Боросу оправиться от ран.", "你出现在了一艘燃烧军团的飞船上，此处的战友们正在背水一战。快给守备官波鲁斯治疗伤势。", "你出現在一艘燃燒軍團的飛船上，發現跟夥伴在戰鬥中走散了。為復仇者波羅斯療傷。", }, 
{ "Follow Vindicator Boros and assist Jace.", "Folgt Verteidiger Boros und helft Jace.", "Sigue al vindicador Boros y ayuda a Jace.", "Sigue al Vindicador Boros y ayuda a Jace.", "Suivez le redresseur de torts Boros et aidez Jace.", "Segui il Vendicatore Boros e aiuta Jace.", "구원자 보로스를 따라가서 제이스를 도와야 합니다.", "Siga o Vindicante Boros e ajude Jace.", "Следуйте за воздаятелем Боросом и помогите Джейсу.", "跟随守备官波鲁斯，并帮助杰斯。", "跟隨復仇者波羅斯並且協助捷斯。", }, 
{ "Assist your allies and escape the hold of the Burning Legion ship.", "Unterstützt Eure Verbündeten und flieht aus dem Frachtraum des Schiffs der Brennenden Legion.", "Ayuda a tus aliados y escapa de la nave de la Legión Ardiente.", "Ayuda a tus aliados y escapa del fuerte de la nave de La Legión Ardiente.", "Aidez vos alliés et fuyez la soute du vaisseau de la Légion ardente.", "Aiuta i tuoi alleati e fuggite dalla stiva della nave della Legione Infuocata.", "아군을 도와 불타는 군단 함선 선창에서 탈출해야 합니다.", "Ajude seus aliados e escape do porão da nave da Legião Ardente.", "Помогите вашим союзникам и покиньте корабляьПылающего Легиона.", "帮助你的战友逃出燃烧军团的战舰。", "協助你的夥伴，然後逃出燃燒軍團的飛船。", }, 
{ "Open the cage to free the captured prisoner and defeat Captain Naranoth.", "Öffnet den Käfig, um den Gefangenen zu befreien, und bezwingt Hauptmann Naranoth.", "Abre la jaula para liberar a la prisionera capturada y derrota al capitán Naranoth.", "Abre la jaula para liberar al prisionero capturado y derrota al capitán Naranoth.", "Ouvrez la cage pour libérer le prisonnier et terrassez le capitaine Naranoth.", "Apri la gabbia per liberare il prigioniero e sconfiggi il Capitano Naranoth.", "우리를 열어 사로잡힌 포로를 해방한 다음 대장 나라노스를 처치해야 합니다.", "Abra a jaula para libertar o prisioneiro e derrote o Capitão Naranoth.", "Откройте клетку и освободите пленницу, после чего победите капитана Наранота.", "打开牢笼解救被俘的囚犯，并击败纳拉诺斯队长。", "打開牢籠釋放囚犯，然後擊敗納拉諾斯隊長。", }, 
{ "Defeat Lord Naranoth.", "Bezwingt Lord Naranoth.", "Derrota a lord Naranoth.", "Derrota a Lord Naranoth.", "Terrassez le seigneur Naranoth.", "Sconfiggi Naranoth.", "대장 나라노스를 처치해야 합니다.", "Derrote Lorde Naranoth.", "Победите капитана Наранота.", "击败纳拉诺斯领主。", "擊敗納拉諾斯領主。", }, 
{ "Defeat Lady Calindris with the help of your allies.", "Bezwingt Lady Calindris mit der Hilfe Eurer Verbündeten.", "Derrota a lady Calindris con la ayuda de tus aliados.", "Derrota a Lady Calindris con ayuda de tus aliados.", "Terrassez dame Calindris avec l’aide de vos alliés.", "Sconfiggi Dama Calindris con l'aiuto dei tuoi alleati.", "아군의 도움을 받아 여군주 칼린드리스를 처치해야 합니다.", "Derrote Lady Calindris com a ajuda dos seus aliados.", "Вместе с вашими союзниками победите леди Калиндрию.", "在你的战友的帮助下击败卡琳迪丝夫人。", "在盟友的幫助下，擊敗卡琳卓絲女士。", }, 
{ "With Lady Calindris dead the staff is now yours. Take it and leave Niskara.", "Mit Lady Calindris' Tod ist ihr Stab Euer. Nehmt ihn und verlasst Niskara.", "Tras la muerte de lady Calindris, el bastón es tuyo. Cógelo y sal de Niskara.", "Ahora que Lady Calindris está muerta, el bastón es tuyo. Tómalo y vete de Niskara.", "À présent que dame Calindris est morte, le bâton est à vous. Prenez-le et quittez Niskara.", "Con la morte di Dama Calindris, il Bastone ora è tuo. Prendilo e fuggi da Niskara.", "여군주 칼린드리스가 죽었으니 그 지팡이는 이제 당신의 것입니다. 지팡이를 가지고 니스카라를 떠나야 합니다.", "Com Lady Calindris morta, o cajado agora é seu. Pegue-o e deixe Niskara.", "Теперь, когда с леди Калиндрией покончено, посох ваш. Заберите его и покиньте Нискару.", "卡琳迪丝夫人已死，法杖是你的了。带着它离开尼斯卡拉。", "卡琳卓絲女士死了，法杖是你的了。拿起法杖，離開尼斯卡拉。", }, 
},
["1174"] = {
{ "Confront Dargrul within the depth's of the drogbar capital.", "Stellt Dargrul in den Tiefen der Drogbarhauptstadt.", "Enfréntate a Dargrul en las profundidades de la capital drógbar.", "Enfrenta a Dargrul en lo profundo de la capital drogbar.", "Affrontez Dargrul dans les profondeurs de la capitale drogbar.", "Affronta Dargrul nelle profondità della capitale dei Drogbar.", "드로그바 수도 깊은 곳에 있는 다르그룰과 맞서야 합니다.", "Confronte Dargrul nas profundezas da capital drogbar.", "Сразитесь с Даргрулом в глубинах столицы дрогбаров.", "在卓格巴尔都城的深渊里与达古尔作战。", "在卓格巴首都的深淵中面對達古爾。", }, 
},
["597"] = {
{ "Defeat the bosses of Utgarde Keep", "Bezwingt die Bosse der Burg Utgarde.", "Derrota a los jefes de la Fortaleza de Utgarde.", "Derrota a los jefes de la Fortaleza de Utgarde.", "Terrassez les boss du donjon d’Utgarde.", "Sconfiggi i boss del Forte Utgarde.", "우트가드 성채 우두머리들을 처치해야 합니다.", "Derrote os chefes do Bastilha Utgarde.", "Победите боссов в крепости Утгард", "击败乌特加德城堡的首领", "擊敗俄特加德要塞的首領", }, 
},
["239"] = {
{ "Protect the Ship!  Defeat the Alliance Boarding party.", "Beschützt das Schiff! Bezwingt die Entermannschaft der Allianz.", "¡Protege el barco! Derrota al grupo de abordaje de la Alianza.", "¡Protege el barco! Derrota al grupo de abordaje de la Alianza.", "Protégez le navire ! Repoussez la section d’abordage de l’Alliance !", "Proteggi la nave! Sconfiggi la squadra d'assalto dell'Alleanza.", "배를 보호하십시오! 얼라이언스 승선대를 처치해야 합니다.", "Proteja o navio! Derrote o Grupo de Abordagem da Aliança.", "Защитите корабль! Одержите победу над абордажной командой Альянса.", "保护舰船！击退联盟登船小队。", "保護船隻!打敗聯盟登船小隊。", }, 
{ "Steal Explosives from enemy Demolitionists.", "Stehlt Sprengladungen von feindlichen Demolierern.", "Róbales explosivos a los demoledores enemigos.", "Róbales explosivos a los demoledores enemigos.", "Volez des explosifs aux démolisseurs ennemis.", "Ruba degli esplosivi dai Demolitori nemici.", "적군 폭파병에게서 폭탄을 훔쳐야 합니다.", "Roube explosivos dos Demolidores.", "Украдите взрывчатку у вражеских подрывников.", "从敌方爆破手处窃取炸药。", "從敵方爆破專家那邊偷取炸藥。", }, 
{ "Plant explosives on the Alliance Ship to destroy it!", "Platziert Sprengladungen auf dem Allianzschiff, um es zu zerstören!", "¡Coloca explosivos en el barco de la Alianza para destruirlo!", "¡Coloca explosivos en el barco de la Alianza para destruirlo!", "Placez des explosifs sur le vaisseau de l’Alliance pour le détruire !", "Piazza dell'esplosivo sulla nave dell'Alleanza per distruggerla!", "얼라이언스 함선에 폭탄을 설치해 파괴하십시오!", "Plante explosivos no navio da Aliança para destruí-lo!", "Установите взрывчатку на корабле Альянса, чтобы потопить его!", "在联盟舰船上安放炸药并将其摧毁！", "在聯盟船隻上安置炸藥來摧毀它!", }, 
{ "Defeat Admiral Hodgson.", "Besiegt Admiral Hodgson.", "Derrota al almirante Hodgson.", "Derrota al almirante Hodgson.", "Terrassez l’amiral Hodgson.", "Sconfiggi l'Ammiraglio Hodgson.", "제독 호지슨을 처치해야 합니다.", "Derrote o Almirante Hodgson.", "Победите адмирала Ходжсона.", "击败海军上将霍奇逊。", "擊敗霍森上將。", }, 
{ "Complete the Bonus Objective to receive bonus Valor.", "Erfüllt die Bonusziele, um zusätzliche Tapferkeitspunkte zu erhalten.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Accomplissez les objectifs bonus pour recevoir des points de vaillance supplémentaires.", "Completa l'obiettivo bonus per ricevere Punti Valore aggiuntivi.", "추가 목표를 완료하면 용맹 점수를 더 얻을 수 있습니다.", "Complete o objetivo bônus para receber Bravura extra.", "Выполните дополнительную задачу, чтобы получить бонусные очки доблести.", "完成奖励目标，获得额外的勇气点数。", "完成獎勵目標以獲得額外的勇氣點數。", }, 
},
["1303"] = {
{ "Speak with Matron Mother Malevolence.", "Sprecht mit Matronenmutter Malicia.", "Habla con la madre matriarca Malevolencia.", "Habla con la Madre Matrona Malevolencia.", "Parlez à la matrone Maléficiae.", "Parla con la Matrona Suprema Malevola.", "모군주 말레볼런스와 대화해야 합니다.", "Fale com a Mãe Matrona Malévola.", "Поговорите с верховной матерью Злобой.", "与主母玛沃伦丝交谈。", "與懷惡族母交談。", }, 
{ "Fight with Lixahl until it submits to you.", "Kämpft mit Lixahl, bis das Tier sich Euch unterwirft.", "Lucha contra Lixahl hasta que se someta.", "Pelea con Lixahl hasta que se rinda ante ti.", "Combattez Lixahl jusqu’à ce qu’elle se plie à votre volonté.", "Combatti contro Lixahl per domarla.", "릭사흘이 당신에게 굴복할 때까지 릭사흘과 싸워야 합니다.", "Lute com Lixahl até ela se submeter a você.", "Бейтесь с Ликшалом до тех пор, пока он вам не покорится.", "与丽克萨尔战斗，直到将其制伏。", "與黎克沙爾戰鬥，直到牠被你制服。", }, 
{ "Track Lixahl's blood until you find it. You can use your Spectral Sight to assist with the tracking.", "Verfolgt Lixahls Blutspur, bis ihr das Tier findet. Vergesst nicht, Eure Geistersicht einzusetzen, um es besser verfolgen zu können.", "Rastrea la sangre de Lixahl hasta que lo encuentres. Puedes utilizar tu Visión espectral para ayudarte.", "Sigue el rastro de sangre de Lixahl hasta encontrarlo. Puedes usar tu Visión espectral para facilitar el rastreo.", "Suivez les traces de sang de Lixahl pour la localiser. Aidez-vous de votre vision spectrale.", "Segui le tracce di sangue di Lixahl per trovare dove si nasconde. La tua Vista Spettrale potrebbe aiutarti.", "릭사흘의 피를 추적해 릭사흘을 찾아야 합니다. 영혼 시야를 사용하면 추적을 조금 더 쉽게 할 수 있습니다.", "Siga o sangue de Lixahl até encontrá-la. Use sua Visão Espectral para ajudar no rastreamento.", "Найдите Ликшала по следу крови. Призрачное зрение поможет вам в этом.", "追踪丽克萨尔的血迹，直至找到它为止。你可以使用幽灵视觉协助追踪。", "追蹤黎克沙爾的血跡，直到找到牠為止。你可以使用靈視協助追蹤。", }, 
{ "Once again, attempt to fight with Lixahl until it submits to you.", "Kämpft erneut mit Lixahl, bis das Tier sich Euch unterwirft.", "Una vez más, intenta luchar contra Lixahl hasta que se someta.", "Una vez más, intenta luchar contra Lixahl hasta que se rinda ante ti.", "Combattez à nouveau Lixahl jusqu’à ce qu’elle se plie à votre volonté.", "Combatti di nuovo contro Lixahl per domarla.", "다시 한 번, 릭사흘이 당신에게 굴복할 때까지 릭사흘과 싸워야 합니다.", "Mais uma vez, tente lutar com a Asavil Selvagem até ela se submeter a você.", "Бейтесь с Ликшалом до тех пор, пока он вам не покорится.", "再次与丽克萨尔战斗，直到将其制伏。", "再次與黎克沙爾戰鬥，直到牠被你制服。", }, 
{ "Continue to track the trail of blood Lixahl left behind. Remember that your Spectral Sight can be utililzed to help with this endeavor.", "Verfolgt die von Lixahl hinterlassene Blutspur weiter. Denkt daran, dass Eure Geistersicht es Euch einfacher machen kann.", "Continúa siguiendo el rastro de sangre que ha dejado Lixahl. Recuerda que tu Visión espectral puede ayudarte en esta tarea.", "Continúa siguiendo el rastro de sangre que ha dejado Lixahl. Recuerda que tu Visión espectral puede ayudarte con esta tarea.", "Continuez à suivre les traces de sang de Lixahl. Votre vision spectrale vous sera d’une grande utilité.", "Continua a seguire le tracce di sangue che Lixahl si è lasciata alle spalle. Ricorda che la tua Vista Spettrale potrebbe aiutarti.", "릭사흘이 남긴 핏자국을 계속 추적해야 합니다. 영혼 시야를 사용하면 추적을 조금 더 쉽게 할 수 있습니다.", "Continue a seguir o rastro de sangue que Lixahl deixou para trás. Lembre-se, sua Visão Espectral pode ser utilizada para ajudar nesta empreitada.", "Продолжайте искать Ликшала по следу крови. Не забывайте использовать \"Призрачное зрение\".", "继续追踪丽克萨尔留下的血迹。记住，你可以使用幽灵视觉协助追踪。", "繼續追蹤黎克沙爾先前的蹤跡。記住你可以使用靈視協助進行追蹤。", }, 
{ "Jump and glide to your prey.", "Springt und gleitet zu Eurer Beute.", "Salta y planea hacia tu presa.", "Salta y planea hasta tu presa.", "Sautez et planez jusqu’à votre proie.", "Salta e plana verso la tua preda.", "도약하여 사냥감이 있는 곳으로 활공해야 합니다.", "Salte e plane até a sua presa.", "Прыгайте с обрыва и планируйте к сквернотопырю.", "跳起，滑翔到猎物身边。", "跳起來並滑翔追捕獵物。", }, 
{ "Finish subduing Lixahl until it submits.", "Kämpft mit Lixahl, bis das Tier sich Euch endgültig unterwirft.", "Termina de subyugar a Lixahl hasta que se someta.", "Continúa luchando contra Lixahl hasta que se rinda.", "Terminez de soumettre Lixahl.", "Affronta definitivamente Lixahl per domarla.", "릭사흘과 계속 싸워 끝까지 굴복시켜야 합니다.", "Termine de subjugar Lixahl até ela se render.", "Бейтесь с Ликшалом, чтобы окончательно подчинить его.", "彻底制伏丽克萨尔。", "與黎克沙爾戰鬥，直到牠被你制服。", }, 
{ "Ride Lixahl back to the demon hunter camp.", "Reitet auf Lixahl zurück zum Lager der Dämonenjäger.", "Monta sobre Lixahl y vuelve al campamento de los cazadores de demonios.", "Monta a Lixahl y regresa al campamento de los cazadores de demonios.", "Retournez au camp des chasseurs de démons en chevauchant Lixahl.", "Cavalca Lixahl verso l'accampamento dei Cacciatori di Demoni.", "릭사흘을 타고 악마사냥꾼 야영지로 돌아가야 합니다.", "Monte em Lixahl para voltar até o acampamento dos caçadores de demônios.", "Оседлайте Ликшала и возвращайтесь в лагерь охотников на демонов.", "骑上丽克萨尔，返回恶魔猎手的营地。", "騎乘黎克沙爾蝙蝠回到惡魔獵人營地。", }, 
},
["639"] = {
{ "Defeat the bosses in Hellfire Ramparts", "Bezwingt die Bosse im Höllenfeuerbollwerk.", "Derrota a los jefes de las Murallas del Fuego Infernal.", "Derrota a los jefes de las Murallas del Fuego Infernal.", "Terrassez les boss des remparts des Flammes infernales.", "Sconfiggi i boss dei Bastioni del Fuoco Infernale.", "지옥불 성루 우두머리들을 처치해야 합니다.", "Derrote os chefes da Muralha Fogo do Inferno", "Победите боссов в Бастионах Адского Пламени", "击败地狱火城墙的首领", "擊敗地獄火壁壘的首領", }, 
},
["539"] = {
{ "Defeat the bosses within the Temple of the Jade Serpent.", "Besiegt die Bosse im Tempel der Jadeschlange.", "Derrota a los jefes del Templo del Dragón de Jade.", "Derrota a los jefes en El Templo del Dragón de Jade.", "Terrassez les boss du temple du Serpent de jade.", "Sconfiggi i boss del Tempio della Serpe di Giada.", "옥룡사 우두머리들을 처치해야 합니다.", "Derrote os chefes no Templo da Serpente de Jade.", "Победите боссов в храме Нефритовой Змеи.", "击败青龙寺的首领。", "擊敗玉蛟寺的首領。", }, 
},
["1255"] = {
{ "Prove your worth and claim the Aegis of Aggramar.", "Beweist, dass Ihr würdig seid und sichert Euch die Aegis von Aggramar.", "Demuestra tu valía y hazte con la Égida de Aggramar.", "Prueba que eres digno y reclama la Égida de Aggramar.", "Prouvez votre valeur et emparez-vous de l’Égide d’Aggramar.", "Prova le tue capacità e ottieni l'Egida di Aggramar.", "자신의 가치를 증명하고 아그라마르의 아이기스를 차지하십시오.", "Prove seu valor e obtenha a Égide de Aggramar.", "Проявите доблесть и добудьте Эгиду Агграмара.", "证明你的实力，并夺取阿格拉玛之盾。", "證明你的資格，並取得阿格拉瑪之盾。", }, 
},
["598"] = {
{ "Defeat the bosses of The Nexus and free Keristrasza.", "Besiegt die Bosse im Nexus und befreit Keristrasza.", "Derrota a los jefes de El Nexo y libera a Keristrasza.", "Derrota a los jefes de El Nexo y libera a Keristrasza.", "Terrassez les boss du Nexus et libérer Keristrasza.", "Sconfiggi i boss del Nexus e libera Keristrasza.", "마력의 탑 우두머리들을 처치하고 케리스트라자를 풀어줘야 합니다.", "Derrote os chefes do Nexus e liberte Keristrasza.", "Победите боссов в Нексусе и освободите Керистразу.", "击败魔枢的首领并释放克莉斯塔萨。", "擊敗奧核之心的首領並救出凱瑞史卓莎。", }, 
},
["696"] = {
{ "The timer should start here.", "Der Timer sollte hier starten.", "El temporizador debería iniciarse aquí.", "El temporizador debería empezar aquí.", "Le décompte devrait commencer ici.", "Ora inizia il conto alla rovescia.", "여기서부터 초읽기가 시작됩니다.", "O tempo tem que iniciar aqui.", "Отсчет времени должен начинаться здесь.", "计时器将在这里开始。", "由此開始計時。", }, 
},
["182"] = {
{ "Protect the Ship!  Defeat the Horde Boarding party.", "Beschützt das Schiff! Bezwingt die Entermannschaft der Horde.", "¡Protege el barco! Derrota al grupo de abordaje de la Horda.", "¡Protege el barco! Derrota al grupo de abordaje de la Horda.", "Protégez le navire ! Repoussez la section d’abordage de la Horde !", "Proteggi la nave! Sconfiggi la squadra d'assalto dell'Orda.", "배를 보호하십시오! 호드 승선대를 처치해야 합니다.", "Proteja o navio! Derrote o Grupo de Abordagem da Horda.", "Защитите корабль! Одержите победу над абордажной командой Орды.", "保护舰船！击退部落登船小队。", "保護船隻!打敗部落登船小隊。", }, 
{ "Steal Explosives from enemy Demolitionists.", "Stehlt Sprengladungen von feindlichen Demolierern.", "Róbales explosivos a los demoledores enemigos.", "Róbales explosivos a los demoledores enemigos.", "Volez des explosifs aux démolisseurs ennemis.", "Ruba degli esplosivi dai Demolitori nemici.", "적군 폭파병에게서 폭탄을 훔쳐야 합니다.", "Roube explosivos dos Demolidores.", "Украдите взрывчатку у вражеских подрывников.", "从敌方爆破手处窃取炸药。", "從敵方爆破專家那邊偷取炸藥。", }, 
{ "Plant explosives on the Horde Ship to destroy it!", "Platziert Sprengladungen auf dem Hordeschiff, um es zu zerstören!", "¡Coloca explosivos en el barco de la Horda para destruirlo!", "¡Coloca explosivos en el barco de la Horda para destruirlo!", "Placez des explosifs sur le vaisseau de la Horde pour le détruire !", "Piazza dell'esplosivo sulla nave dell'Orda per distruggerla!", "호드 함선에 폭탄을 설치해 파괴하십시오!", "Plante explosivos no navio da Horda para destruí-lo!", "Установите взрывчатку на корабле Орды, чтобы потопить его.", "在部落舰船上安放炸药并将其摧毁！", "在部落船隻上安置炸藥來摧毀它!", }, 
{ "Defeat Admiral Hagman.", "Besiegt Admiral Hagman.", "Derrota al almirante Hagman.", "Derrota al almirante Hagman.", "Terrassez l’amiral Hagman.", "Sconfiggi l'Ammiraglio Hagman.", "제독 해그먼을 처치해야 합니다.", "Derrote o Almirante Hagman.", "Победите адмирала Хагмана.", "击败海军上将哈格曼。", "擊敗海格曼上將。", }, 
{ "Complete the Bonus Objective to receive bonus Valor.", "Erfüllt die Bonusziele, um zusätzliche Tapferkeitspunkte zu erhalten.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Accomplissez les objectifs bonus pour recevoir des points de vaillance supplémentaires.", "Completa l'obiettivo bonus per ricevere Punti Valore aggiuntivi.", "추가 목표를 완료하면 용맹 점수를 더 얻을 수 있습니다.", "Complete o objetivo bônus para receber Bravura extra.", "Выполните дополнительную задачу, чтобы получить бонусные очки доблести.", "完成奖励目标以获取额外的勇气点数。", "完成獎勵目標以獲得額外的勇氣點數。", }, 
},
["1244"] = {
{ "Gain access to the ship's computer system.", "Verschafft Euch Zugang zum Computersystem des Schiffs.", "Obtén acceso al sistema informático de la nave.", "Accede al sistema de la computadora de la nave.", "Accédez à l’ordinateur de bord du vaisseau.", "Ottieni l'accesso al sistema computerizzato della nave.", "전함 컴퓨터에 접속하십시오.", "Obtenha acesso ao sistema de computadores da nau.", "Получите доступ к компьютерной системе корабля.", "进入飞船的计算机系统", "連接到船艦的電腦系統。", }, 
{ "Overload the shield generators.", "Überladet die Schildgeneratoren.", "Sobrecarga los generadores de escudos.", "Sobrecarga los generadores de escudo.", "Surchargez les générateurs de boucliers.", "Sovraccarica i generatori degli scudi.", "방어막 발생기를 과부하 걸리게 하십시오.", "Sobrecarregue os geradores do escudo.", "Устройте перегрузку генераторов защитного поля.", "令护盾发生器过载。", "讓護盾產生器超載。", }, 
{ "Initialize the self-destruct sequence.", "Startet die Selbstzerstörungssequenz.", "Inicia la secuencia de autodestrucción.", "Inicia la secuencia de autodestrucción.", "Activez la séquence d’autodestruction.", "Inizializza la sequenza di autodistruzione.", "자폭 장치를 가동하십시오.", "Inicie a sequência de autodestruição.", "Запустите процесс самоуничтожения.", "初始化自毁序列。", "啟動自動毀滅程序。", }, 
{ "Defeat Mephistroth.", "Bezwingt Mephistroth.", "Derrota a Mephistroth.", "Derrota a Mephistroth.", "Terrassez Méphistroth.", "Sconfiggi Mefistroth.", "메피스트로스를 처치해야 합니다.", "Derrote Mephistroph.", "Победите Мефистрота.", "击败孟菲斯托斯", "擊敗梅菲斯托。", }, 
},
["1125"] = {
{ "Follow Caretaker G33-WH12 through the Antechamber.", "Folgt Verwalter G33-WH12 durch die Vorkammer.", "Sigue al custodio G33-WH12 a través de la Antecámara.", "Sigue al Custodio G33-WH12 por la Antecámara.", "Suivez le conservateur G33-WH12 dans l’antichambre.", "Segui il Custode G33-WH12 attraverso l'Anticamera.", "관리자 G33-WH12를 따라서 대기실을 통과해야 합니다.", "Siga o zelador G33-WH12 pela antecâmara.", "Следуйте за Смотрителем Г33-ВХ12 через вестибюль Ульдуара.", "跟随G33-WH12号管理员穿过前厅。", "跟隨G33-WH12管理員，穿越前廳。", }, 
{ "Defeat the invaders.", "Besiegt die Eindringlinge.", "Derrota a los invasores.", "Derrota a los invasores.", "Terrassez les envahisseurs.", "Sconfiggi gli invasori!", "침입자를 물리쳐야 합니다.", "Derrote os invasores.", "Победите захватчиков.", "击败入侵者。", "擊敗入侵者。", }, 
{ "Find Magni Bronzebeard. The caretaker said he'd be in the Celestial Planetarium.", "Findet Magni Bronzebart. Der Verwalter gab an, er wäre im Himmlischen Planetarium.", "Busca a Magni Barbabronce. El custodio dijo que estaría en El Planetario Celestial.", "Encuentra a Magni Barbabronce. El cuidador dijo que estaría en el Planetario Celestial.", "Trouvez Magni Barbe-de-Bronze. D’après le conservateur, il doit se trouver dans le planétarium céleste.", "Trova Magni Barbabronzea. Il Curatore ha detto che dovrebbe trovarsi nel Planetario Celeste.", "마그니 브론즈비어드를 찾아야 합니다. 관리인의 말에 따르면, 마그니는 별자리 투영관에 있다고 합니다.", "Encontre Magni Barbabronze. O zelador disse que ele estaria no Planetário Celestial.", "Найдите Магни Бронзоборода. Смотритель сказал, что он должен быть в Священном планетарии.", "找到麦格尼·铜须。管理员说他在天文台。", "找到麥格尼‧銅鬚。管理員說他會在星穹渾天儀。", }, 
{ "Give Archmage Khadgar the signal to bring the fel barrier down.", "Gebt Erzmagier Khadgar das Signal, die Teufelsbarriere zu zerstören.", "Hazle al archimago Khadgar la señal para que destruya la barrera vil.", "Da al Archimago Khadgar la señal para que derribe la barrera vil.", "Signalez à l’archimage Khadgar de neutraliser la barrière gangrenée.", "Invia all'Arcimago Khadgar il segnale per abbattere la barriera.", "대마법사 카드가에게 신호를 보내 지옥 방벽을 제거해야 합니다.", "Sinalize para que o Arquimago Hadggar traga abaixo a barreira vil.", "Дайте верховному магу Кадгару сигнал развеять барьер Скверны.", "给大法师卡德加发信号，解除邪能屏障。", "示意大法師卡德解除魔化屏障。", }, 
{ "Defeat Inquisitor Ha'zaduum and his minions to save Magni.", "Bezwingt Inquisitor Ha'zaduum und seine Diener, um Magni zu retten.", "Derrota al inquisidor Ha'zaduum y a sus esbirros para salvar a Magni.", "Derrota al Inquisidor Ha'zaduum y sus secuaces para salvar a Magni.", "Terrassez l’inquisiteur Ha’zaduum et ses serviteurs pour sauver Magni.", "Sconfiggi l'Inquisitore Ha'zaduum e i suoi servitori per salvare Magni.", "심문관 하자둠과 그의 하수인을 처치하고 마그니를 구해야 합니다.", "Derrote o Inquisidor Ha'zaduum e seus lacaios para salvar Magni.", "Победите инквизитора Ха'задуума и его прислужников, чтобы спасти Магни.", "击败审判官哈扎杜姆和他的爪牙，救下麦格尼。", "擊敗審判官哈札頓和他的手下以拯救麥格尼。", }, 
{ "Walk with Magni Bronzebeard to the Celestial Planetarium.", "Geht mit Magni Bronzebart zum Himmlischen Planetarium.", "Acompaña a Magni Barbabronce hasta El Planetario Celestial.", "Camina junto a Magni Barbabronce hacia el Planetario Celestial.", "Accompagnez Magni Barbe-de-Bronze au planétarium céleste.", "Cammina con Magni Barbabronzea fino al Planetario Celeste.", "마그니 브론즈비어드와 함께 별자리 투영관에 가야 합니다.", "Vá com Magni Barbabronze até o Planetário Celestial.", "Отправляйтесь с Магни Бронзобородом в Священный планетарий.", "陪麦格尼·铜须一起来到天文台。", "跟麥格尼‧銅鬚一同前往星穹渾天儀。", }, 
{ "Ask Magni to open the door to the Celestial Planetarium.", "Bittet Magni, die Tür zum Himmlischen Planetarium zu öffnen.", "Pídele a Magni que abra la puerta de El Planetario Celestial.", "Pide a Magni que abra la puerta al Planetario Celestial.", "Demandez à Magni de vous ouvrir la porte menant au planétarium céleste.", "Chiedi a Magni di aprire la porta del Planetario Celeste.", "마그니에게 별자리 투영관으로 들어가는 문을 열어 달라고 해야 합니다.", "Peça a Magni que abra a porta para o Planetário Celestial.", "Попросите Магни открыть дверь в Священный планетарий.", "让麦格尼打开天文台的大门。", "請麥格尼開啟星穹渾天儀的入口。", }, 
{ "Listen to the information Magni Bronzebeard wants to share with you.", "Hört Euch die Informationen an, die Magni Bronzebart Euch mitteilen möchte.", "Escucha la información que Magni Barbabronce quiere compartir contigo.", "Escucha la información que Magni Barbabronce tiene para darte.", "Écoutez les informations que Magni Barbe-de-Bronze souhaite partager avec vous.", "Ascolta le informazioni che Magni Barbabronzea vuole condividere con te.", "마그니 브론즈비어드가 알려주려는 정보를 들어야 합니다.", "Ouça a informação que Magni Barbabronze quer lhe transmitir.", "Выслушайте, что хочет вам сказать Магни Бронзобород.", "听取麦格尼·铜须想跟你分享的信息。", "聆聽麥格尼‧銅鬚要跟你分享的消息。", }, 
},
["1145"] = {
{ "Man the artillery console and use the Fel Hammer's batteries to lay waste to the Legion forces below.", "Bemannt die Artilleriekonsole und benutzt die Batterien der Teufelshammer, um die Legionsstreitkräfte unten auszulöschen.", "Controla la consola de artillería y usa las baterías del Martillo Vil para devastar a las fuerzas de la Legión que hay abajo.", "Encárgate de la consola de artillería y usa las baterías del Martillo Vil para destrozar a las fuerzas de la Legión.", "Postez-vous à la console d’artillerie et utilisez les batteries du Marteau gangrené pour anéantir les troupes de la Légion en contrebas.", "Usa la console dell'artiglieria e l'armamento della Vilmartello per devastare le forze della Legione sottostanti.", "지옥화포 제어 장치를 작동시킨 다음, 지옥 망치호의 함포를 사용하여 아래에 있는 군단 세력을 초토화해야 합니다.", "Entre na cabine da artilharia e use as baterias do Martelo Vil para devastar as forças da Legião abaixo.", "Расставьте солдат у пульта управления артиллерийским огнем и уничтожьте войска Легиона с помощью батарей \"Молота Скверны\".", "控制火炮的操作台，用邪能之槌号的舰炮摧毁下方燃烧军团的部队。", "操作砲台，利用魔錘號的火砲消滅下方的燃燒軍團部隊。", }, 
{ "Speak with Kayn Sunfury to deploy your forces and then use your Glide ability to get down to the rendezvous point below.", "Sprecht mit Kayn Sonnenzorn, um Eure Streitkräfte einzusetzen, und benutzt danach Eure Fähigkeit 'Gleiten', um zum Treffpunkt unten zu gelangen.", "Habla con Kayn Furia del Sol para desplegar tus fuerzas y luego usa tu facultad Planear para ir al punto de encuentro de más abajo.", "Habla con Kayn Furia del Sol para implementar tus fuerzas y luego usa tu habilidad de deslizamiento para bajar al punto de encuentro.", "Parlez à Kayn Solfurie pour déployer vos troupes puis utilisez votre technique Planer pour descendre au point de rendez-vous.", "Parla con Kayn Furiasolare per schierare le tue forze, quindi usa l'abilità Planata per raggiungere il punto di ritrovo sottostante.", "카인 선퓨리와 대화하여 병력을 배치하고, 활공 능력을 사용하여 아래쪽 집결 지점으로 내려가야 합니다.", "Peça a Kayn Solfúria que posicione as tropas. Em seguida, use a habilidade Planar para descer ao local de encontro.", "Поговорите с Кайном Яростью Солнца о размещении войск, затем с помощью \"Планирования\" спуститесь к месту встречи.", "和凯恩·日怒谈谈，部署你的部队，然后用你的滑翔技能落在下方的集合点。", "跟凱恩‧日怒交談，部署你的軍隊，然後使用滑翔技能前往下方的集合點。", }, 
{ "Kill Caria and Varedis's lieutenants, and destroy all of the portals they are using to summon in reinforcements.", "Tötet die Leutnants von Caria und Varedis und zerstört alle Portale, die sie zum Herbeirufen von Verstärkung benutzen.", "Mata a los tenientes de Caria y Varedis y destruye todos los portales que están usando para invocar refuerzos.", "Mata a los tenientes de Caria y Varedis y destruye todos los portales que usen para convocar a sus refuerzos.", "Tuez les lieutenants de Caria et Varedis et détruisez tous les portails qu’ils utilisent pour appeler des renforts.", "Uccidi i luogotenenti di Caria e Varedis e distruggi tutti i portali che stanno usando per evocare i rinforzi.", "카리아와 베레디스의 부관을 처치하고 그들이 지원군 소환에 사용하는 모든 차원문을 파괴해야 합니다.", "Mate Caria e os tenentes de Varedis, e destrua os portais que utilizam para evocar reforços.", "Убейте лейтенантов Карии и Варедиса и уничтожьте все порталы, через которые к ним прибывает подкрепление.", "杀死凯丽娅和瓦雷迪斯的副官，摧毁他们用来召唤援军的所有传送门。", "殺死凱莉亞和瓦瑞迪斯的副官，然後摧毀所有他們用來召喚援軍的傳送門。", }, 
{ "Speak with Kayn in front of the command center where Caria and Varedis are protected behind a Fel Barrier.", "Sprecht mit Kayn vor der Kommandozentrale, wo Caria und Varedis hinter einer Teufelsbarriere geschützt sind.", "Habla con Kayn delante del centro de mando, donde Caria y Varedis están protegidos por una barrera vil.", "Habla con Kayn frente al centro de mando, donde Caria y Varedis se refugian detrás de una barrera vil.", "Parlez à Kayn devant le centre de commandement, où Caria et Varedis sont protégés par une barrière gangrenée.", "Parla con Kayn di fronte al Centro di Comando, dove Caria e Varedis si trovano protetti dietro una Vilbarriera.", "카리아와 베레디스는 지옥 방벽 뒤의 사령부에 있습니다. 그 앞에 있는 카인과 대화해야 합니다.", "Fale com Kayn em frente ao centro de comando, onde Caria e Varedis protegem-se atrás de uma Barreira Vil.", "Поговорите с Кайном возле флагманского корабля, где Кария и Варедис закрыты барьером Скверны.", "和奥图里斯在指挥中心前方谈谈，凯丽娅和瓦雷迪斯正在那里，而且受到邪能屏障的保护。", "前往凱莉亞跟瓦瑞迪斯受到魔化屏障保護的指揮中心前方，跟凱恩交談。", }, 
{ "Order the Fel Hammer to move into position and fire upon the other command center. This will bring down the Fel Barrier and allow entry.", "Befehlt der Teufelshammer, sich in Position zu bringen und auf die andere Kommandozentrale zu feuern. Das wird die Teufelsbarriere zu Fall bringen und den Zugang ermöglichen.", "Ordena al Martillo Vil colocarse en posición y disparar al otro centro de mando. Eso eliminará la barrera vil y permitirá el paso.", "Ordena al Martillo Vil que tome posición y dispare al otro centro de mando. Esto derribará la barrera vil y te permitirá entrar.", "Ordonnez au Marteau gangrené de prendre position pour tirer sur l’autre centre de commandement afin de neutraliser la barrière gangrenée et vous permettre d’entrer.", "Ordina alla Vilmartello di muoversi in posizione e fare fuoco sul Centro di Comando Nemico. Così facendo, abbatterai la Vilbarriera e potrai entrare.", "지옥 망치호를 이동시켜 사령부에 포격을 가해야 합니다. 공격이 성공하면 지옥 방벽이 해제되어 목표에 접근할 수 있을 것입니다.", "Ordene que o Martelo Vil assuma posição e dispare contra o outro centro de comando para derrubar a Barreira Vil e permitir a entrada.", "Распорядитесь, чтобы \"Молот Скверны\" занял позицию, и откройте огонь по флагманскому кораблю врага. Это разрушит барьер Скверны, и вы смо", "命令邪能之槌号进入位置，然后向向另一个指挥中心开火。这样可以击溃邪能屏障，使其门户大开。", "命令魔錘號進入攻擊位置，朝另一座指揮中心開火。這能摧毀他們的魔化屏障，讓我們得以前進。", }, 
{ "Kill Caria and Varedis Felsoul.", "Tötet Caria und Varedis Teufelsseele.", "Mata a Caria y Varedis Alma Vil.", "Mata a Caria y Varedis Almavil.", "Tuez Caria et Varedis Gangrâme.", "Uccidi Caria e Varedis Vilanima.", "카리아 펠소울과 베레디스 펠소울을 처치해야 합니다.", "Mate Caria e Varedis Almavil.", "Убейте Карию и Варедиса Оскверненную Душу.", "消灭凯丽娅和瓦雷迪斯·邪魂。", "殺死凱莉亞和瓦瑞迪斯‧魔魂", }, 
{ "Caria and Varedis are dead. Speak with Kayn and have Matron Mother Malevolence teleport all of you back to the Fel Hammer.", "Caria und Varedis sind tot. Sprecht mit Kayn und lasst Euch von Matronenmutter Malicia zurück auf die Teufelshammer teleportieren.", "Caria y Varedis están muertos. Habla con Kayn y haz que la madre matriarca Malevolencia os teletransporte a todos de vuelta al Martillo Vil.", "Caria y Varedis están muertos. Habla con Kayn y haz que la Madre Matrona Malevolencia los teletransporte nuevamente al Martillo Vil.", "Caria et Varedis sont morts. Parlez à Kayn et demandez à la matrone Maléficiae de tous vous renvoyer à bord du Marteau gangrené.", "Caria e Varedis sono morti. Parla con Kayn e chiedi alla Matrona Suprema Malevola di teletrasportarvi alla Vilmartello.", "카리아와 베레디스는 죽었습니다. 카인과 대화한 다음 모군주 말레볼런스의 도움을 받아 아군과 함께 지옥 망치호로 순간이동해야 합니다.", "Caria e Varedis estão mortos. Fale com Altruis para que a Mãe Matrona Malévola teleporte a todos de volta ao Martelo Vil.", "Кария и Варедис мертвы. Поговорите с Кайном и попросите верховную мать Злобу телепортировать всех вас обратно на \"Молот Скверны\".", "凯丽娅和瓦雷迪斯已死。和凯恩谈谈，让主母玛沃伦丝将所有人传送回邪能之槌号。", "凱莉亞和瓦瑞迪斯都死了。跟凱恩交談，請懷惡族母把你們全都傳送回魔錘號。", }, 
},
["1037"] = {
{ "Twilight cultists are camped near the entrance. Investigate what they are doing here.", "Schattenhammerkultisten lagern in der Nähe des Eingangs. Untersucht, was sie dort vorhaben.", "Han acampado cultores Crepusculares cerca de la entrada. Investiga qué están haciendo ahí.", "Los cultores crepusculares acampan cerca de la entrada. Investiga qué es lo que hacen allí.", "Des sectateurs du Crépuscule sont postés près de l’entrée. Découvrez ce qu’ils font ici.", "I cultisti del Crepuscolo si sono accampati presso l'ingresso. Scopri cosa stanno facendo.", "황혼의 이교도가 입구 근처에서 야영하고 있습니다. 그들이 이곳에서 무엇을 하고 있는지 조사해야 합니다.", "Sectários do Crepúsculo estão acampados perto da entrada. Investigue o que estão fazendo aqui.", "Сектанты Сумеречного Молота стали лагерем возле гробницы. Выясните, что они здесь делают.", "暮光教徒在入口附近建设了营地。调查他们来此的目的。", "暮光教徒就在入口附近紮營。調查他們在這裡做什麼。", }, 
{ "The ghost of Thoradin is being tortured by the cultists. Slay the ritualists and free him.", "Der Geist von Thoradin wird von den Kultisten gefoltert. Tötet die Ritualisten und befreit ihn.", "Los cultores están torturando al fantasma de Thoradin. Acaba con los ritualistas y libéralo.", "El fantasma de Thoradin está siento torturado por los cultores. Elimina a los ritualistas y libéralo.", "Les sectateurs torturent le fantôme de Thoradin. Tuez les ritualistes et libérez-le.", "I cultisti stanno torturando il fantasma di Thoradin. Uccidili e liberalo.", "이교도들이 소라딘의 유령을 고문하고 있습니다. 의식술사를 처치하고 소라딘의 유령을 해방시켜야 합니다.", "O fantasma de Thoradin está sendo torturado pelos sectários. Mate-os e o liberte.", "Сектанты истязают дух Торадина. Убейте сектантов и освободите его.", "索拉丁的灵魂正受到教徒的折磨。消灭那些祭司并解救他。", "索拉丁的鬼魂正受到教徒的折磨。殺死祭儀師，解救他。", }, 
{ "The ghost has much information. Follow Thoradin and listen to his tale.", "Der Geist besitzt viele Informationen. Folgt Thoradin und hört seiner Erzählung zu.", "El fantasma tiene mucha información. Sigue a Thoradin y escucha su historia.", "El fantasma tiene mucha información. Sigue a Thoradin y escucha su historia.", "Le fantôme en sait long. Suivez Thoradin et écoutez son récit.", "Il fantasma è in possesso di molte informazioni. Segui Thoradin e ascolta la sua storia.", "그 유령은 많은 것을 알고 있습니다. 소라딘의 유령을 따라가 그의 이야기를 들어야 합니다.", "O fantasma tem muita informação. Siga Thoradin e escute sua história.", "Этот призрак владеет ценной информацией. Проследуйте за Торадином и выслушайте его историю.", "这个灵魂知道许多的情报。跟随索拉丁，听听他的故事。", "這個鬼魂知道很多事情。跟隨索拉丁，聆聽他的故事。", }, 
{ "The broken seal beckons from the lake bottom. Enter the Tomb of Tyr.", "Das zerbrochene Siegel ruft Euch vom Grunde des Sees. Betretet Tyrs Grabmal.", "El sello roto llama desde el fondo del lago. Entra en la Tumba de Tyr.", "El sello roto te llama desde el fondo del lago. Entra a la tumba de Tyr.", "Au fond du lac, le sceau brisé vous attire irrésistiblement. Entrez dans le tombeau de Tyr.", "Il sigillo infranto chiama dal fondo del lago. Entra nella Tomba di Tyr.", "호수 아래 깊숙이 있는 망가진 봉인이 눈에 들어옵니다. 티르의 무덤에 들어가야 합니다.", "O selo partido chama do fundo do lago. Entre na tumba de Tyr.", "Сломанная печать на дне озера словно манит вас к себе. Войдите в гробницу Тира.", "破碎的封印在湖底闪烁。进入提尔之墓。", "破碎的封印在湖底對你呼喚。進入提爾之墓。", }, 
{ "The prison entrance is blocked with corruption. Cleanse the tomb of the corrupting void tendrils.", "Der Gefängniseingang wird von Verderbnis blockiert. Läutert das Grab von den verderbenden Leerententakeln.", "La entrada a la prisión está bloqueada con corrupción. Acaba con los tentáculos del vacío que corrompen la tumba.", "La entrada de la prisión está bloqueada con corrupción. Purifica la tumba de los tentáculos del vacío que la corrompen.", "L’entrée de la prison est bloquée par la corruption. Purifiez la tombe des tentacules du Vide corrupteurs.", "L'ingresso alla prigione è bloccato dalla corruzione. Libera la tomba dai Tentacoli del Vuoto.", "감옥 입구가 타락체로 막혀있습니다. 무덤을 둘러싼 타락한 공허의 촉수를 정화해야 합니다.", "A entrada da prisão está bloqueada com corrupção. Purifique a tumba dos tentáculos corruptores do caos.", "Вход в темницу преграждает порча. Очистите гробницу от оскверняющих щупалец Бездны.", "监狱的入口由堕落力量封锁着。清除污染墓穴的虚空触须。", "監獄入口受到腐化的阻擋。消滅墓穴中的腐化虛無觸鬚。", }, 
{ "The corrupter has finally appeared. Slay Soth'ozz and complete the cleansing of the tomb.", "Der Verderber ist endlich erschienen. Tötet Soth'ozz und schließt die Läuterung des Grabes ab.", "El corruptor ha aparecido por fin. Mata a Soth'ozz y termina de purificar la tumba.", "El corruptor apareció finalmente. Asesina a Soth'ozz y completa la purificación de la tumba.", "Le corrupteur s’est enfin décidé à se montrer. Tuez Soth’ozz et achevez la purification de la tombe.", "Il corruttore si è finalmente rivelato. Uccidi Soth'ozz e completa la purificazione della tomba.", "마침내 타락자가 모습을 드러냈습니다. 소스오즈를 처치하여 무덤을 완전히 정화해야 합니다.", "O corruptor finalmente apareceu. Mate Soth'ozz e complete a purificação da tumba.", "Осквернитель наконец-то явил себя. Убейте Сот'озза и завершите процесс очищения гробницы.", "腐化者终于现身了。消灭索斯奥兹，完成对墓穴的净化。", "腐化源頭終於出現了。殺死索斯奧茲，完成淨化墓穴的任務。", }, 
{ "The way below is uncovered, make your way to the prison of Zakajz.", "Der untere Weg ist ungeschützt, bahnt Euch einen Weg zum Gefängnis von Zakajz.", "Se ha despejado el camino hacia abajo. Ve a la prisión de Zakajz.", "El camino que hay adelante ya está despejado. Llega hasta la prisión de Zakajz.", "Le passage souterrain est révélé. Frayez-vous un chemin jusqu’à la prison de Zakajz.", "La strada verso il basso è scoperta, raggiungi la prigione di Zakajz.", "지하로 향하는 길이 드러났습니다. 자카이즈의 감옥으로 가야 합니다.", "O caminho para baixo foi revelado, siga até a prisão de Zakajz.", "Путь вниз открыт. Ступайте к темнице Закажа.", "下方的道路已经敞开了，前往扎卡兹的监狱。", "往下的通道開啟了，繼續前往扎卡茲的牢獄。", }, 
{ "Zakajz is struggling to defend itself. Draw out the sword and perform the final blow!", "Zakajz kann sich kaum noch verteidigen. Zieht das Schwert heraus und versetzt ihm den Todesstoß!", "Zakajz está intentando defenderse. ¡Saca la espada y asesta el golpe final!", "Zakajz lucha por defenderse. ¡Desenfunda tu espada y dale el golpe de gracia!", "Zakajz est en fâcheuse posture. Dégainez l’épée et donnez-lui le coup de grâce !", "Zakajz sta cercando di difendersi. Estrai la spada e infliggigli il colpo di grazia!", "자카이즈는 자신을 방어할 수 없습니다. 소라딘의 검을 빼내 마지막 일격을 가해야 합니다!", "Zakajz está com dificuldades de se defender. Saque a espada e aplique o golpe de misericórdia!", "Закаж отчаянно пытается защищаться. Вытащите меч и нанесите ему последний удар!", "扎卡兹仍在垂死挣扎。将宝剑拔出来，给它最后一击！", "扎卡茲奮力想保護自己。把劍拔出，使出最後一擊！", }, 
{ "Zakajz is awake but neither fully healed or fully in control of its mind. Fight it back into unconsciousness!", "Zakajz ist wach, jedoch weder vollständig geheilt noch im vollen Besitz seines Verstandes. Schlagt ihn in die Bewusstlosigkeit zurück!", "Zakajz está despierto, pero no está sanado por completo ni ha recuperado el control total de su mente. ¡Lucha con él hasta que vuelva a quedar inconsciente!", "Zakajz está despierto, pero está herido y perdió el control de sí mismo. ¡Déjalo inconsciente!", "Zakajz est conscient, mais il est mal en point et n’est pas maître de lui-même. Frappez jusqu’à ce qu’il perde à nouveau connaissance !", "Zakajz si è svegliato, ma non è completamente guarito o cosciente. Ricaccialo nell'oblio!", "자카이즈가 깨어났습니다. 그러나 완전히 회복되진 않았으며, 온전히 정신을 통제할 수 없는 상태입니다. 자카이즈와 싸워 다시 의식을 잃게 해야 합니다!", "Zakajz está acordado, mas não está de todo curado, nem em completo controle da mente. Enfrente-o até que volte à inconsciência!", "Закаж пробудился, но еще не восстановил здоровье и не контролирует свой разум. Верните его в забытье!", "扎卡兹醒来了，但他尚未恢复体力，也还无法控制自己的心智。重新把它打晕！", "扎卡茲醒了，但是身體跟神智都沒有完全恢復。再把他打昏！", }, 
{ "Zakajz has been defeated again, but it is not permanent. Take up Strom'kar and deal the final true blow.", "Zakajz wurde erneut besiegt, jedoch nicht dauerhaft. Hebt Strom'kar auf und versetzt Zakajz den endgültigen, wahren Todesstoß.", "Zakajz ha sido derrotado de nuevo, pero no de forma permanente. Coge a Strom'kar y asesta el auténtico golpe final.", "Zakajz fue derrotado una vez más, pero no es permanente. Toma la Strom'kar e inflige el golpe de gracia definitivo.", "Zakajz a été vaincu une fois de plus, mais il n’a pas encore dit son dernier mot. Prenez Strom’kar et donnez-lui le coup de grâce.", "Zakajz è stato nuovamente sconfitto, ma non in modo permanente. Prendi Strom'kar e infliggi il colpo definitivo.", "자카이즈는 다시 패배했지만, 영원히 끝난 게 아닙니다. 스트롬카르를 들고 진정한 최후를 안기십시오.", "Uma vez mais Zakajz foi derrotado, mas não completamente. Empunhe Strom'kar e desfira o golpe derradeiro.", "Закаж снова побежден, но не уничтожен окончательно. Возьмите в руки Стром'кар и нанесите Закажу удар, чтобы прикончить его раз и навсегда", "扎卡兹又一次被击败了，但这只是暂时的。举起斯多姆卡，给他致命一击。", "扎卡茲又被打敗了，不過這只是暫時的。拿起斯托姆卡，對他使出真正的最後一擊。", }, 
},
["589"] = {
{ "Defeat the bosses of Violet Hold", "Besiegt die Bosse der Violetten Festung", "Derrota a los jefes del Bastión Violeta.", "Derrota a los jefes del bastión Violeta", "Triomphez des boss du fort Pourpre.", "Sconfiggi i boss della Fortezza Violacea.", "보랏빛 요새 우두머리들을 처치해야 합니다.", "Derrote os chefes do Castelo Violeta", "Победите боссов в Аметистовой крепости", "击败紫罗兰监狱的首领", "擊敗紫羅蘭堡的首領", }, 
},
["689"] = {
{ "Defeat the Adherents of Rukhmar atop Skyreach.", "Bezwingt die Jünger von Rukhmar auf der Himmelsnadel.", "Derrota a los Adeptos de Rukhmar en lo alto del Trecho Celestial.", "Derrota a los Partidarios de Rukhmar en lo alto del Trecho Celestial.", "Terrassez les adhérents de Rukhmar au sommet d’Orée-du-Ciel.", "Sconfiggi i Proseliti di Rukhmar in cima a Vetta dei Cieli.", "하늘탑 꼭대기에 있는 루크마르의 신봉자들을 처치해야 합니다.", "Derrote os Seguidores de Rukhmar no topo de Beira-céu.", "Одолейте Приверженцев Рухмар в Небесном Пути.", "击败通天峰的鲁克玛信徒。", "擊敗擎天峰頂的魯克馬爾擁護者", }, 
},
["1155"] = {
{ "The Shadow Council is most likely looking for a prisoner. The cell blocks are a good choice to start.", "Der Schattenrat sucht höchstwahrscheinlich nach einem Gefangenen. Es wäre bestimmt gut, in den Zellenblocks anzufangen.", "El Consejo de la Sombra andará buscando un prisionero. Los módulos de celdas son un buen sitio donde empezar.", "El Consejo de las Sombras debe estar buscando a un prisionero. Las celdas son un buen lugar para empezar.", "Le Conseil des ombres cherche très certainement un prisonnier. Les quartiers de détention sont le meilleur endroit où entamer vos recherches.", "Il Concilio dell'Ombra sta cercando un prigioniero. Le celle sono un buon posto dove iniziare.", "어둠의 의회가 포로를 찾고 있는 게 분명합니다. 감방부터 찾아보는 게 좋을 것 같습니다.", "O Concílio das Sombras deve estar procurando por algum prisioneiro. O bloco das celas é um bom lugar por onde começar.", "Совет Теней, вероятно, ищет узника. Лучше всего начать поиски с тюремных блоков.", "暗影议会很可能是在寻找一名囚犯。从牢房开始找很不错。", "暗影議會很有可能在找一名囚犯。從牢房區開始找會是個好主意。", }, 
{ "The remaining Council aspirants have been greatly thinned. Meet up with the survivors and find out their plans.", "Die verbliebenen Ratsanwärter wurden ziemlich dezimiert. Trefft Euch mit den Überlebenden und findet ihre Pläne heraus.", "Los aspirantes al Consejo restantes están muy diezmados. Reúnete con los supervivientes y averigua sus planes.", "Mataron a varios de los aspirantes al Consejo restantes. Reúnete con los sobrevivientes y ponte al tanto de sus planes.", "Les rangs des aspirants restants du conseil ont été bien clairsemés. Rejoignez les survivants et tâchez d’apprendre ce qu’ils comptent faire.", "Gli aspiranti membri del Concilio rimasti sono stati ridotti notevolmente di numero. Incontra i sopravvissuti e scopri i loro piani.", "의회 지원자의 수가 급격히 줄어들었습니다. 남은 생존자들과 만나 그들의 계획을 알아내야 합니다.", "São poucos os aspirantes remanescentes do concílio. Encontre os sobreviventes e descubra seus planos.", "Претендентов на должность членов Совета осталось очень мало. Встретьтесь с выжившими и узнайте, что они собираются делать.", "剩下的议会候选者被严重削弱了。和幸存者会面，了解他们的计划。", "剩餘的議會成員人數大幅銳減。跟生還者碰頭，得知他們的計畫是什麼。", }, 
{ "Tyranis Malem was sent ahead deeper into D-Block. Head into the cells, find him, and find out what he knows.", "Tyranis Malem wurde vorausgeschickt, um tiefer in Block D vorzudringen. Geht in die Zellen und findet heraus, was er weiß.", "Tyranis Malem recibió órdenes de adentrarse en el Bloque D. Dirígete a las celdas, localízalo y averigua lo que sabe.", "Tyranis Malem fue enviado más hacia el interior del Bloque D. Dirígete hacia las celdas, encuéntralo y averigua lo que sabe.", "Tyranis Malem est parti en reconnaissance dans le bloc D. Entrez dans les cellules, trouvez-le et découvrez ce qu’il sait.", "Tyranis Malem è stato mandato a esplorare il Blocco-D. Dirigiti verso le celle, trovalo e scopri tutto ciò che sa.", "티라니스 말렘이 D 구역 깊은 곳으로 갔습니다. 감방으로 가서 티라니스 말렘을 찾고 그가 무엇을 알고 있는지 확인해야 합니다.", "Tyranis Malem foi enviado para a parte final do Bloco D. Dirija-se até as celas, encontre-o e descubra o que ele sabe.", "Тираниса Малема отправили в глубины блока Д. Пойдите туда, найдите его и узнайте, что ему известно.", "泰拉尼斯·玛雷姆被送到了恶魔监狱深处。前往牢房，找到他，搞清楚他知道多少事情。", "泰拉尼斯‧瑪雷姆奉命深入D區。進入牢房，找到他，然後問出他知道些什麼。", }, 
{ "It is easier to get more credit with less help. Tyranis should suffer an unfortunate accident. Break the chain he holds or leave him to his fate.", "Weniger Hilfe bedeutet mehr Ruhm. Tyranis sollte einen bedauerlichen Unfall erleiden. Durchbrecht die Kette, die ihn hält, oder überlasst ihn seinem Schicksal.", "Es más fácil recibir más crédito con menos ayuda. Tyranis debería sufrir un desgraciado accidente. Rompe la cadena que sostiene o abandónalo a su suerte.", "Es más fácil quedarse con los créditos cuando recibes menos ayuda. Tyranis debe sufrir un desafortunado accidente. Rompe la cadena que lleva y abandónalo a su suerte.", "Il est plus aisé de s’attribuer plus de mérite quand on reçoit moins d’aide. Tyranis va être victime d’un accident malencontreux. Brisez sa chaîne ou abandonnez-le à son sort.", "È più facile prendersi il merito da soli, ma Tyranis sa troppe cose. Forse dovrebbe capitargli qualcosa di brutto. Rompi le sue catene o lascialo al suo destino.", "돕는 이가 적어야 공적이 커지는 법입니다. 티라니스는 불행한 사고를 당하는 것이 최선입니다. 그를 묶고 있는 사슬을 깨뜨리거나 운명에 그를 맡기십시오.", "Recebe-se mais crédito quando se recebe menos ajuda. Tyranis deveria sofrer um lamentável acidente. Quebre a corrente ou abandone-o à própria sorte.", "Теперь все лавры достанутся только вам. Оставьте Тираниса на произвол судьбы или разорвите его цепь. Толку от него все равно никакого.", "帮手越少，就越容易获得信任。泰拉尼斯应该遭受了不幸的事故。打破他的锁链，或者让他自生自灭。", "參與協助的人越少，個人功勞就越大。最好讓泰拉尼斯遭遇不幸的意外。斷開鎖鍊，或是丟下他自生自滅。", }, 
{ "The manifest isn't here, time to continue the search elsewhere.", "Die Liste ist nicht hier, also sollte ich anderswo suchen.", "El manifiesto no está aquí. Es hora de continuar la búsqueda en otra parte.", "El manifiesto no está aquí, debemos continuar la búsqueda en otro lado.", "Le manifeste n’est pas là. Il est temps de poursuivre les recherches ailleurs.", "L'elenco non è qui, continua a cercare.", "감옥 명부는 이곳에 없습니다. 다른 곳을 수색해야 합니다.", "O manifesto não está aqui, hora de procurar em outro lugar.", "Списка узников здесь нет, нужно продолжить поиски в другом месте.", "名册不在这里，该继续搜索其他地方了。", "名冊不在這裡，再去其它地方找找。", }, 
{ "Nagaz needs \"help with something\", probably a trap. Wait for him to spring it, then turn the tables.", "Nagaz braucht \"bei etwas Hilfe\". Wahrscheinlich ist das eine Falle. Wartet darauf, dass er sie auslöst, und wendet dann das Blatt.", "Nagaz necesita \"ayuda con algo\". Probablemente sea una trampa. Espera a que la active y luego cambia las tornas de la situación.", "Nagaz necesita \"ayuda con algo\". Probablemente sea una trampa. Espera a que te la tienda y luego revierte las cosas a tu favor.", "Nagaz a besoin d’aide pour « quelque chose ». C’est sûrement un piège. Attendez qu’il l’actionne, puis inversez les rôles.", "Nagaz ha bisogno di \"un piccolo aiuto\", ma probabilmente si tratta di una trappola. Attendi il suo arrivo per far scattare la trappola, poi agisci.", "나가즈가 뭔가 \"도움\"이 필요하다고 합니다. 아마도 당신을 노리는 함정이겠죠. 본색을 드러낼 때까지 기다린 후 상황을 역전시켜야 합니다.", "Nagaz precisa de \"ajuda com algo\". Uma armadilha, provavelmente. Espere que ele revele suas intenções, e, então, vire o jogo.", "Нагаз просит помощи \"с кое-чем\" – похоже, это ловушка. Как только он откроет свои истинные намерения, \"воспользуйтесь ситуацией\".", "纳伽兹说是需要“帮忙”，可能是个陷阱。等他图穷匕见后，再改变局势吧。", "納伽茲有某件事「需要你幫忙」，很有可能是陷阱。等他先下手，再反將他一軍。", }, 
{ "Continue searching for the prison manifest in the cell block.", "Sucht weiter im Zellenblock nach der Gefängnisliste.", "Sigue buscando el manifiesto de prisión en el módulo de celdas.", "Continúa la búsqueda del manifiesto de prisión en el bloque de celdas.", "Continuez à chercher le manifeste de la prison dans le quartier de détention.", "Continua a cercare l'elenco dei detenuti della prigione nel blocco detentivo.", "감옥에서 감옥 명부를 계속 찾아야 합니다.", "Continue a procurar o manifesto no bloco das celas.", "Продолжайте поиски списка узников в тюремном блоке.", "继续在牢房中搜索囚犯名册。", "繼續搜索牢房，找出監獄名冊。", }, 
{ "Allaris believes the manifest to be here. Accompany him and find it.", "Allaris glaubt, dass sich die Liste hier befindet. Begleitet ihn und findet sie.", "Allaris cree que el manifiesto está aquí. Acompáñalo y encuéntralo.", "Allaris cree que el manifiesto está aquí. Acompáñalo a buscarlo.", "Allaris pense que le manifeste est ici. Accompagnez-le et trouvez le document.", "Allaris crede che l'elenco sia qui. Accompagnalo e trova il documento.", "알라리스는 감옥 명부가 이곳에 있다고 생각합니다. 그와 함께 감옥 명부를 찾아야 합니다.", "Allaris acredita que o manifesto esteja aqui. Acompanhe-o na busca.", "Алларис считает, что список узников где-то рядом. Отправляйтесь на его поиски вместе.", "奥莱利斯认为名册就在这里。陪他一起找到名册。", "埃拉里斯認為名冊就在這裡。跟他一起找出名冊。", }, 
{ "The manifest indicates that the target is in Baradin Hold. Go there with Allaris and find the creature.", "Die Liste deutet an, dass sich das Ziel in der Baradinfestung befindet. Begebt Euch mit Allaris dorthin und findet die Kreatur.", "El manifiesto indica que el objetivo está en el Bastión de Baradin. Ve allí con Allaris y encuentra a la criatura.", "El manifiesto indica que el objetivo está en el Bastión de Baradin. Ve allí con Allaris y encuentra a la criatura.", "Le manifeste indique que la cible se trouve au bastion de Baradin. Rendez-vous sur place avec Allaris et trouvez la créature.", "L'elenco indica che l'obiettivo si trova nel Forte di Baradin. Vai lì con Allaris e trova la creatura.", "감옥 명부를 통해, 목표물이 바라딘 요새에 있다는 걸 알았습니다. 알라리스와 함께 가서 그 생물을 찾아야 합니다.", "O manifesto diz que o alvo está na Guarnição Baradin. Vá até o local com Allaris e encontre a criatura.", "Согласно списку, цель следует искать в крепости Барадин. Отправляйтесь туда вместе с Алларисом и найдите это существо.", "名册表明，目标就在巴拉丁监狱。和奥莱利斯一起前往那里，找到那个生物。", "名冊指出目標位於巴拉丁堡。跟埃拉里斯一同找到那個生物。", }, 
{ "The massive void terror has consumed the Eye. Kill it to retrieve the Eye.", "Der riesige Schrecken der Leere hat das Auge verschlungen. Tötet ihn, um das Auge wiederzubekommen.", "El inmenso terror del Vacío ha consumido el Ojo. Mátalo para recuperarlo.", "El inmedible terror del vacío ha consumido el Ojo. Mátalo para recuperarlo.", "L’énorme terreur du Vide a avalé l’œil. Tuez-la pour le récupérer.", "L'enorme Terrore del Vuoto ha consumato l'Occhio. Uccidilo per recuperarlo.", "거대한 공허의 괴물이 눈을 먹어 치웠습니다. 어서 처치하고 눈을 되찾아야 합니다.", "O olho foi consumido pelo terror do caos. Mate a criatura para reavê-lo.", "Огромный ужасень Бездны поглотил Око. Убейте зверя и верните Око.", "巨大的虚空恐魔吞噬了达拉然之眼。杀死它，取得达拉然之眼。", "巨大的虛無恐獸吞噬了眼睛。殺死它，奪回達拉然之眼。", }, 
},
["581"] = {
{ "Defeat the bosses within the Halls of Lightning", "Besiegt die Bosse in den Hallen der Blitze.", "Derrota a los jefes dentro de las Cámaras de Relámpagos.", "Derrota a los jefes en las Cámaras de Relámpagos.", "Terrassez les boss des salles de Foudre.", "Sconfiggi i boss delle Sale del Fulmine.", "번개의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes nos Salões Relampejantes", "Победите боссов в Чертогах Молний", "击败闪电大厅的首领", "擊敗雷光大廳的首領", }, 
},
["681"] = {
{ "Defeat the Bloodmaul slavers operating the Slag Mines.", "Besiegt die Sklaventreiber der Blutschläger, die die Blutschlägermine betreiben.", "Derrota a los esclavistas Machacasangre que manejan las Minas Machacasangre.", "Derrota a los esclavos Machacasangre que operan en las Minas de Escoria.", "Terrassez les esclavagistes de la mine de la Masse-Sanglante.", "Sconfiggi gli Schiavisti Magliorosso che gestiscono le miniere.", "잿가루 광산을 관리하는 피망치 노예사냥꾼들을 처치해야 합니다.", "Derrote os feitores do Malho Sangrento nas Minas de Escória.", "Победите поработителей из клана Кровавого Молота в Шлаковых шахтах.", "击败经营着血槌炉渣矿井的血槌奴隶主。", "擊敗營運熔渣礦場的血槌奴隸商人。", }, 
},
["181"] = {
{ "Launch an assault on the island of Zan'vess.", "Leitet einen Angriff auf die Insel Zan'vess ein.", "Asalta la isla de Zan'vess.", "Asalta la isla de Zan'vess.", "Lancez une attaque sur l’île de Zan’vess.", "Lancia un assalto contro l'isola di Zan'vess.", "잔베스 섬을 공격해야 합니다.", "Lance um ataque na ilha de Zan'vess.", "Присоединитесь к атаке на Зан'весс.", "对扎尼维斯岛发动袭击。", "對贊斐斯島發動攻擊。", }, 
{ "Destroy the Sonic Towers and deactivate the Zan'vess Defense Shield.", "Zerstört die Schalltürme und deaktiviert das Verteidigungsfeld von Zan'vess.", "Destruye las torres sónicas y desactiva el escudo defensivo de Zan'vess.", "Destruye las torres sónicas y desactiva el escudo defensivo de Zan'vess.", "Détruisez les tours de contrôle soniques et désactivez le bouclier défensif de Zan’vess.", "Distruggi le Torri Soniche e disattiva lo Scudo Difensivo di Zan'vess.", "음파 제어탑을 파괴하고 잔베스 수비 보호막을 비활성화시켜야 합니다.", "Destrua as Torres Sônicas e desative o Escudo de Defesa de Zan'vess", "Разрушьте звуковые колонны и отключите защитный щит Зан'весса.", "摧毁声波塔并关闭扎尼维斯的防护盾。", "摧毀音波控制哨塔並關閉贊斐斯防護盾。", }, 
{ "Storm the beach and reach the Heart of Zan'vess.", "Erstürmt den Strand und erreicht das Herz von Zan'vess.", "Irrumpe en la playa y llega hasta el corazón de Zan'vess.", "Irrumpe en la playa y llega hasta el corazón de Zan'vess.", "Débarquez sur la plage et avancez jusqu’au cœur de Zan’vess.", "Assalta la spiaggia e raggiungi il Cuore di Zan'vess.", "해변을 급습해 잔베스 중심부로 가야 합니다.", "Invada a praia e chegue ao Coração de Zan'vess.", "Захватите плацдарм на берегу и доберитесь до Сердца Зан'весса.", "突袭海滩并抵达扎尼维斯之心。", "攻擊沙灘並抵達贊斐斯之心。", }, 
{ "Defeat Commander Tel'vrak and retrieve the Mantid weapon cache.", "Bezwingt Kommandant Tel'vrak und besorgt die Waffen der Mantis.", "Derrota al comandante Tel'vrak y recupera el alijo de armas mántide.", "Derrota al comandante Tel'vrak y recupera el alijo de armas mántide.", "Terrassez le commandant Tel’vrak et récupérez le contenu de la cache d’armes des mantides.", "Sconfiggi il Comandante Tel'vrak e recupera lo scrigno delle armi dei Mantid.", "사령관 텔브라크를 처치한 뒤 사마귀 무기를 확보해야 합니다.", "Derrote o Comandante Tel'vrak e recupere o carregamento de armas mantídeo.", "Победите командора Тел'врака и найдите склад оружия богомолов.", "击败指挥官泰尔伏拉克并夺回螳螂妖武器库。", "打敗指揮官泰弗瑞克並取回螳螂人武器貯藏箱。", }, 
},
["682"] = {
{ "Fight your way through the Depot to board the Grimrail.", "Kämpft Euch durch das Depot, um den Grimmzug zu besteigen.", "Ábrete paso a través de la terminal y sube al Malavía.", "Ábrete paso a través del Depósito y sube abordo del Riel Siniestro.", "Frayez-vous un chemin dans le dépôt pour monter à bord du Tristerail.", "Apriti la strada attraverso il deposito e sali sul Frecciacupa.", "정비소 안에서 전진해 파멸철로 기차에 올라타야 합니다.", "Abra caminho pela Central para embarcar no Carrilcruel.", "Проберитесь через депо и сядьте на поезд Мрачных Путей.", "杀进车站，登上恐轨号。", "擊敗敵人，從車站登上恐軌列車。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["582"] = {
{ "Defeat the bosses within the Halls of Stone", "Besiegt die Bosse in den Hallen des Steins.", "Derrota a los jefes dentro de las Cámaras de Piedra.", "Derrota a los jefes en las Cámaras de Piedra.", "Terrassez les boss des salles de Pierre.", "Sconfiggi i boss delle Sale della Pietra.", "돌의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes nos Salões Rochosos", "Победите боссов в Чертогах Камня", "击败岩石大厅的首领", "擊敗石之大廳的首領", }, 
},
["528"] = {
{ "Defeat the bosses of Mogu'shan Palace.", "Besiegt die Bosse im Mogu'shanpalast.", "Derrota a los jefes del Palacio Mogu'shan.", "Derrota a los jefes del Palacio Mogu'shan.", "Terrassez les boss du palais Mogu’shan.", "Sconfiggi i boss del Palazzo Mogu'shan.", "모구샨 궁전 우두머리들을 처치해야 합니다.", "Derrote os chefes do Palácio Mogu'shan.", "Победите боссов во дворце Могу'шан.", "击败魔古山宫殿的首领。", "擊敗魔古山宮的首領。", }, 
},
["428"] = {
{ "Defeat the Ner'zhul's dark sect of Shadowmoon cultists.", "Besiegt Ner'zhuls finstere Sekte der Schattenmondkultisten.", "Derrota a la secta oscura de cultores Sombraluna de Ner'zhul.", "Derrota a la secta oscura de Ner'zhul de los cultores Sombraluna.", "Triomphez des Sectateurs ombrelunes qui composent la secte noire de Ner’zhul.", "Sconfiggi l'oscura setta dei cultisti Torvaluna di Ner'zhul.", "넬쥴과 어둠달 이교도들을 무찔러야 합니다.", "Derrote o secto sombrio de sectários sombrios da Lua Negra de Ner'zhul.", "Одолейте сектантов Призрачной Луны из темной секты Нер'зула.", "击败耐奥祖的黑暗教派中的影月邪教徒。", "擊敗耐祖奧的影月教徒", }, 
},
["824"] = {
{ "Report to Lady Sylvanas Windrunner.", "Meldet Euch bei Fürstin Sylvanas Windläufer.", "Preséntate ante lady Sylvanas Brisaveloz.", "Vuelve con Lady Sylvanas Brisaveloz.", "Présentez-vous à dame Sylvanas Coursevent.", "Fai rapporto a Dama Sylvanas Ventolesto.", "여군주 실바나스 윈드러너에게 보고해야 합니다.", "Fale com a Grande Dama Sylvana Correventos.", "Поговорите с леди Сильваной Ветрокрылой.", "向希尔瓦娜斯·风行者报告", "向希瓦娜斯‧風行者女士回報。", }, 
{ "Ride with Nathanos to the Eternity and use a Forsaken Catapult to shoot down Skyfire Gryphon Riders.", "Reitet mit Nathanos zur Ewigkeit und nutzt ein Katapult der Verlassenen, um Greifenreiter der Himmelsfeuer abzuschießen.", "Ve con Nathanos hasta La Eternidad y usa una catapulta de los Renegados para derribar a los jinetes de grifo de El Abrasacielos.", "Acompaña a Nathanos a la Eternidad y usa la Catapulta de los Renegados para derribar a los Jinetes de Grifos del Abrasacielos.", "Rendez-vous sur l’Éternité avec Nathanos et utilisez une catapulte des Réprouvés pour abattre les chevaucheurs de griffon du Brûleciel.", "Cavalca con Nathanos fino all'Eternità Infinita e usa la Catapulta dei Reietti per abbattere i Cavalieri di Grifoni della Fuoco Celeste.", "나타노스와 함께 영원호로 가서, 포세이큰 투석기로 하늘불꽃호 그리핀 기수들을 격추해야 합니다.", "Vá com Nathanos até o Eternidade e use uma Catapulta dos Renegados para derrubar os Cavalga-grifos do Celesfogo.", "Отправляйтесь с Натаносом на \"Вечность\" и сбивайте наездников на грифоне \"Небесного огня\" из катапульты Отрекшихся.", "与纳萨诺斯一同前往永恒号，使用被遗忘者投石车击落天火号狮鹫骑士。", "跟納薩諾斯一同前往永恆之境，然後使用被遺忘者投石車擊落天火號獅鷲騎士。", }, 
{ "Ride with Nathanos to the Blightcaller and slay incoming 7th Legion forces.", "Reitet mit Nathanos zur Pestrufer und tötet eintreffende Truppen der 7. Legion.", "Ve con Nathanos hasta El Clamañublo y acaba con las oleadas de los ejércitos de la Séptima Legión.", "Acompaña a Nathanos al Clamañublo y acaba con las fuerzas de la Séptima Legión.", "Rendez-vous sur le Flétrisseur avec Nathanos et tuez les troupes de la 7e Légion en approche.", "Cavalca con Nathanos fino all'Invocatrice del Morbo ed elimina le forze della VII Legione.", "나타노스와 함께 역병소환사호에 승선하여, 공격해 들어오는 7군단을 격퇴해야 합니다.", "Voe com Nathanos até o Pestífero e mate as forças da 7ª Legião.", "Отправляйтесь с Натаносом на \"Призыватель гибели\" и уничтожьте атакующие силы 7-го легиона.", "与纳萨诺斯一同前往凋零使徒号，消灭所有来袭的第七军团部队。", "跟納薩諾斯一同去找凋零者，然後消滅來襲的第七軍團部隊。", }, 
{ "Ride with Nathanos to the Black Rose and rid the ship of worgen.", "Reitet mit Nathanos zur Schwarzen Rose und befreit das Schiff von Worgen.", "Ve con Nathanos hasta La Rosa Negra y vacía el barco de huargen.", "Acompaña a Nathanos a la Rosa Negra y saca a los huargen del barco.", "Rendez-vous sur la Rose noire avec Nathanos et débarrassez le navire des worgens.", "Cavalca con Nathanos fino alla Rosa Nera e sbarazzati della nave Worgen.", "나타노스와 함께 흑장미호에 승선하여 늑대인간을 함선에서 제거해야 합니다.", "Voe com Nathanos até o Rosa Negra e livre o navio de worgens.", "Отправляйтесь с Натаносом на \"Черную Розу\" и очистите корабль от воргенов.", "与纳萨诺斯一同前往黑玫瑰号，清除船上的狼人。", "跟納薩諾斯一同前往黑玫瑰號，然後殺死船上的狼人。", }, 
{ "Ride with Nathanos to the Skyfire and rig Volatile Flares to the ammunition stockpiles.", "Reitet mit Nathanos zur Himmelsfeuer und platziert instabile Mischungen am Munitionsvorrat.", "Ve con Nathanos hasta El Abrasacielos y coloca explosivos volátiles en las reservas de munición.", "Acompaña a Nathanos al Abrasacielos e instala bengalas volátiles en las reservas de munición.", "Rendez-vous sur le Brûleciel avec Nathanos et fixez des décoctions instables sur les réserves de munitions.", "Cavalca con Nathanos fino alla Fuoco Celeste e piazza le Fialabengala Instabili sui Depositi di Munizioni.", "나타노스와 함께 하늘불꽃호에 승선하여 탄약 더미에 불안정한 폭발물을 설치해야 합니다.", "Vá com Nathanos até o Celesfogo e instale Sinalizadores Voláteis no estoque de munição.", "Отправляйтесь с Натаносом на \"Небесный огонь\" и разместите нестабильную взрывчатую смесь среди его боеприпасов.", "与纳萨诺斯一同突袭天火号，在军火物资旁放置易爆炸弹。", "跟納薩諾斯一同前往天火號，然後在彈藥儲藏處放置高爆燃炎彈。", }, 
{ "Battle Genn Greymane on the deck of the Skyfire.", "Bekämpft Genn Graumähne auf dem Deck der Himmelsfeuer.", "Enfréntate a Genn Cringrís en la cubierta de El Abrasacielos.", "Lucha con Genn Cringris en la cubierta del Abrasacielos.", "Affrontez Genn Grisetête sur le pont du Brûleciel.", "Affronta Genn Mantogrigio sul ponte della Fuoco Celeste.", "하늘불꽃호 갑판에 있는 겐 그레이메인과 싸워야 합니다.", "Enfrente Genn Greymane no convés do Celesfogo.", "Сразитесь с Генном Седогривом на палубе \"Небесного огня\".", "在天火号的甲板上与吉恩·格雷迈恩交战。", "在天火號的甲板上與吉恩‧葛雷邁恩作戰。", }, 
},
["873"] = {
{ "Quell the Infernal Uprising on Kirin Tor Shore.", "Befriedet den Aufstand der Höllenbestien an der Küste der Kirin Tor.", "Apacigua el levantamiento infernal en la Costa del Kirin Tor.", "Extingue la rebelión infernal en la costa del Kirin Tor.", "Réprimez le soulèvement des infernaux sur le rivage du Kirin Tor.", "Ferma l'avanzata degli Infernali sulla Spiaggia del Kirin Tor.", "키린 토 해안에서 난동을 부리는 지옥불정령을 처치해야 합니다.", "Sufoque o levante infernal na Costa do Kirin Tor.", "Остановите нашествие инферналов на берег Кирин-Тора.", "压制肯瑞托海滩的地狱火攻势。", "鎮壓祈倫托之岸的煉獄火暴亂。", }, 
{ "Close the Demon Portals.", "Schließt die Dämonenportale.", "Cierra los portales de demonios.", "Cierra los Portales de demonios.", "Fermez les portails démoniaques.", "Chiudi i Portali Demoniaci.", "악마의 차원문을 닫아야 합니다.", "Feche os portais demoníacos.", "Закройте порталы демонов.", "关闭恶魔之门。", "關閉惡魔傳送門。", }, 
{ "Defend the research station from the Fel Lord.", "Verteidigt die Forschungsstation gegen den Teufelslord.", "Defiende la estación de investigación del señor vil.", "Defiende la estación de investigación del Señor vil.", "Défendez le centre de recherche contre le gangreseigneur.", "Difendi la stazione di ricerca dal Vilsignore.", "지옥 군주로부터 연구 기지를 방어해야 합니다.", "Defenda a estação de pesquisas do Lorde Vil.", "Защитите исследовательскую станцию от повелителя Скверны.", "保卫研究站，抵抗邪能领主。", "抵抗惡魔領主，保護研究站。", }, 
},
["673"] = {
{ "The timer should start here.", "Der Timer sollte hier starten.", "El temporizador debería iniciarse aquí.", "El temporizador debería empezar aquí.", "Le décompte devrait commencer ici.", "Ora inizia il conto alla rovescia.", "여기서부터 초읽기가 시작됩니다.", "O tempo tem que iniciar aqui.", "Отсчет времени должен начинаться здесь.", "计时器将在这里开始。", "由此開始計時。", }, 
{ "You got past the timer", "Ihr habt die Zeit überstanden", "Has sobrepasado el tiempo", "Te pasaste del tiempo", "Vous avez dépassé le temps imparti.", "Non hai finito nel tempo richiesto.", "제한 시간을 초과했습니다.", "Você passou do tempo", "Время вышло", "你的时间用完了", "你在時間結束前完成了", }, 
},
["1166"] = {
{ "Deal with the restless spirits of Black Rook Hold.", "Kümmert Euch um die ruhelosen Geister der Rabenwehr.", "Ocúpate de los espíritus inquietos del Torreón Grajo Negro.", "Encárgate de los espíritus sin descanso del Fuerte Torre Oscura.", "Occupez-vous des esprits sans repos du bastion du Freux.", "Occupati degli spiriti irrequieti di Forte Corvonero.", "검은 떼까마귀 요새 안의 잠 못 드는 영혼을 상대해야 합니다.", "Lide com os irrequietos espíritos do Castelo Corvo Negro.", "Разберитесь с беспокойными духами крепости Черной Ладьи.", "应对黑鸦堡垒中躁动的灵魂。", "解決玄鴉堡內的怨靈。", }, 
},
["1336"] = {
{ "At last we breach the Tomb of Sargeras, but the Legion will not be caught off guard.", "Endlich verschaffen wir uns Zutritt zum Grabmal des Sargeras, aber die Legion wird nicht unvorbereitet sein.", "Por fin penetramos en la Tumba de Sargeras, pero la Legión estará esperando.", "Por fin logramos entrar en la Tumba de Sargeras... pero la Legión seguramente está vigilando.", "Nous avons enfin pénétré dans la tombe de Sargeras, mais la Légion ne sera pas prise de court.", "Alla fine abbiamo fatto breccia nella Tomba di Sargeras, ma la Legione non si farà prendere di sorpresa.", "드디어 살게라스의 무덤에 침투하였습니다. 하지만 군단이 가만히 앉아서 당하진 않을 겁니다.", "Finalmente adentramos a Tumba de Sargeras, mas a Legião não se deixará pegar despreparada.", "Наконец-то мы проникли в гробницу Саргераса, но Легион уже поджидает нас.", "我们终于攻破了萨格拉斯之墓，但燃烧军团肯定早有准备。", "我們終於進入薩格拉斯之墓，但燃燒軍團一定早就做好萬全的準備了。", }, 
},
["988"] = {
{ "Make your way into the Dark Riders' catacombs beneath Karazhan.", "Bahnt Euch einen Weg in die Katakomben der Dunklen Reiter unter Karazhan.", "Ábrete paso hasta las catacumbas de los jinetes oscuros que hay bajo Karazhan.", "Llega hasta las catacumbas de los Jinetes oscuros, situadas en lo profundo de Karazhan.", "Frayez-vous un chemin dans les catacombes des cavaliers noirs qui s’étendent sous Karazhan.", "Fatti strada nelle catacombe dei Cavalieri Oscuri sotto Karazhan.", "카라잔 아래에 있는 암흑 기수의 지하무덤에 들어가야 합니다.", "Entre nas catacumbas dos Cavalgantes Negros, sob Karazhan.", "Проникните в катакомбы Темных всадников под Каражаном.", "前往卡拉赞下方的黑暗骑士墓穴。", "進入卡拉贊地下墓穴追查黑騎兵的下落。", }, 
{ "Find a way to cross Ariden's spirit barrier.", "Findet einen Weg, um Aridens Geisterbarriere zu überwinden.", "Encuentra el modo de atravesar la barrera de espíritus de Ariden.", "Encuentra un modo de atravesar la barrera espiritual de Ariden.", "Trouvez un moyen de franchir la barrière spirituelle d’Ariden.", "Trova un modo per attraversare la barriera spirituale di Ariden.", "아리덴의 영혼 방벽을 통과할 방법을 찾아야 합니다.", "Encontre um jeito de atravessar a barreira espiritual de Ariden.", "Найдите способ преодолеть духовную преграду Аридена.", "想办法穿过埃瑞丁的灵魂屏障。", "想辦法越過埃瑞丁的靈魂屏障。", }, 
{ "Defeat the guardian of the Dark Riders' vault.", "Bezwingt den Wächter des Gewölbes der Dunklen Reiter.", "Derrota al guardián de la cámara de los jinetes oscuros.", "Derrota al guardián de la bóveda de los Jinetes oscuros.", "Terrassez le gardien du caveau des Cavaliers noirs.", "Sconfiggi il Conservatore dei Cavalieri Oscuri.", "암흑 기수 금고의 관리자를 물리쳐야 합니다.", "Derrote o guardião da câmara dos Cavalgantes Negros.", "Победите хранителя сокровищ Темных всадников.", "击败黑暗骑士宝库的守护者。", "擊敗黑騎兵寶庫的保護者。", }, 
{ "Find the Deadwind Harvester among the Dark Riders' artifacts.", "Sucht nach der Sense der Totenwinde unter den Artefakten der Dunklen Reiter.", "Encuentra la Falce del Paso de la Muerte entre los artefactos de los jinetes oscuros.", "Encuentra la Cosechadora Vientomuerto entre los artefactos de los Jinetes oscuros.", "Trouvez la faux de Deuillevent parmi les armes prodigieuses des Cavaliers noirs.", "Trova la Mietitrice di Ventomorto tra gli artefatti dei Cavalieri Oscuri.", "암흑 기수의 유물 중 저승바람 수확기를 찾아야 합니다.", "Encontre a Ceifadora do Vento Morto entre os artefatos dos Cavalgantes Negros.", "Найдите Жнеца Мертвого Ветра среди артефактов Темных всадников.", "在黑暗骑士的神器中找到逆风收割者。", "在黑騎兵的寶藏中找到逆風收割者。", }, 
{ "Follow Ariden into the depths of the Karazhan catacombs.", "Folgt Ariden in die Tiefen der Katakomben von Karazhan.", "Sigue a Ariden hasta las profundidades de las Catacumbas de Karazhan.", "Sigue a Ariden hacia las profundidades de las catacumbas de Karazhan.", "Suivez Ariden dans les profondeurs des catacombes de Karazhan.", "Segui Ariden nelle profondità delle catacombe di Karazhan.", "카라잔 지하무덤 깊은 곳으로 도망친 아리덴을 추격해야 합니다.", "Siga Ariden até as profundezas das catacumbas de Karazhan.", "Следуйте за Ариденом вглубь катакомб Каражана.", "跟随埃瑞丁深入卡拉赞墓穴。", "深入卡拉贊地下墓穴，追上埃瑞丁。", }, 
{ "Defeat Ariden.", "Bezwingt Ariden.", "Derrota a Ariden.", "Derrota a Ariden.", "Terrassez Ariden.", "Sconfiggi Ariden.", "아리덴을 처치해야 합니다.", "Derrote Ariden.", "Победите Аридена.", "击败埃瑞丁。", "擊敗埃瑞丁。", }, 
{ "Claim the Deadwind Harvester.", "Nehmt die Sense der Totenwinde an Euch.", "Hazte con la Falce del Paso de la Muerte.", "Reclama la Cosechadora Vientomuerto.", "Récupérez la faux de Deuillevent.", "Recupera la Mietitrice di Ventomorto.", "저승바람 수확기를 획득해야 합니다.", "Tome a Ceifadora do Vento Morto.", "Заберите Жнеца Мертвого Ветра.", "获取逆风收割者。", "取得逆風收割者。", }, 
},
["573"] = {
{ "Defeat the bosses of the Halls of Reflection", "Besiegt die Bosse in den Hallen der Reflexion.", "Derrota a los jefes de Las Cámaras de Reflexión.", "Derrota a los jefes de Las Cámaras de Reflexión.", "Terrassez les boss de la salle des Reflets.", "Sconfiggi i boss delle Sale dei Riflessi.", "투영의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões da Reflexão", "Победите боссов в Залах Отражений", "击败映像大厅的首领", "擊敗倒影大廳的首領", }, 
},
["680"] = {
{ "Defeat the Bloodmaul slavers operating the Slag Mines.", "Besiegt die Sklaventreiber der Blutschläger, die die Blutschlägermine betreiben.", "Derrota a los esclavistas Machacasangre que manejan las Minas Machacasangre.", "Derrota a los esclavos Machacasangre que operan en las Minas de Escoria.", "Terrassez les esclavagistes de la mine de la Masse-Sanglante.", "Sconfiggi gli Schiavisti Magliorosso che gestiscono le miniere.", "잿가루 광산을 관리하는 피망치 노예사냥꾼들을 처치해야 합니다.", "Derrote os feitores do Malho Sangrento nas Minas de Escória.", "Победите поработителей из клана Кровавого Молота в Шлаковых шахтах.", "击败经营着血槌炉渣矿井的血槌奴隶主。", "擊敗營運熔渣礦場的血槌奴隸商人。", }, 
},
["580"] = {
{ "Defeat the bosses within the Halls of Lightning", "Besiegt die Bosse in den Hallen der Blitze.", "Derrota a los jefes dentro de las Cámaras de Relámpagos.", "Derrota a los jefes en las Cámaras de Relámpagos.", "Terrassez les boss des salles de Foudre.", "Sconfiggi i boss delle Sale del Fulmine.", "번개의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes nos Salões Relampejantes", "Победите боссов в Чертогах Молний", "击败闪电大厅的首领", "擊敗雷光大廳的首領", }, 
},
["499"] = {
{ "Follow the Sergeant", "Folgt dem Unteroffizier", "Sigue al Sargento.", "Sigue al sargento", "Suivez le sergent.", "Segui il Sergente.", "하사관을 따라가야 합니다.", "Siga o Sargento", "Следуйте за сержантом", "追随中士", "跟隨士官", }, 
{ "Defeat the Goren Ambush.", "Wehrt den Hinterhalt der Goren ab.", "Detén la emboscada goren.", "Derrota la emboscada goren.", "Déjouez l’embuscade des gorens.", "Resisti all'imboscata dei Goren.", "고렌의 습격을 막아내야 합니다.", "Derrote a Emboscada Goren.", "Отбейтесь от горенов, устроивших засаду.", "击败鬣蜥人的突击。", "擊敗戈倫的伏擊", }, 
{ "Endure the Goren Assault.", "Haltet dem Angriff der Goren stand.", "Resiste al asalto goren.", "Aguanta el asalto goren.", "Survivez à l’attaque des gorens.", "Resisti all'Assalto dei Goren.", "고렌의 공격을 막아내야 합니다.", "Resista ao ataque Goren.", "Отразите нападение горенов.", "顶住鬣蜥人的攻击。", "撐過戈倫的攻擊。", }, 
{ "Defeat the remaining Goren forces.", "Besiegt die verbleibenden Goren.", "Derrota a las fuerzas goren restantes.", "Derrota a las fuerzas goren restantes.", "Terrassez ce qui reste des gorens.", "Sconfiggi le forze restanti dei Goren.", "남은 고렌 병력을 물리쳐야 합니다.", "Derrote as forças Goren restantes.", "Одержите победу над оставшимися горенами.", "击败鬣蜥人的残余部队。", "擊敗剩下的戈倫部隊。", }, 
{ "Return to the town center.", "Kehrt zur Ortsmitte zurück.", "Vuelve al centro de la ciudad.", "Vuelve al centro del pueblo.", "Retournez dans le centre-ville.", "Torna al centro del villaggio.", "마을 중앙으로 가야 합니다.", "Retorne ao centro da cidade.", "Вернитесь в центр гарнизона.", "返回镇中心。", "返回城鎮中心。", }, 
{ "Defeat the Gronn.", "Bezwingt den Gronn.", "Derrota a los gronns.", "Derrota al Gronn.", "Terrassez le gronn.", "Sconfiggi il Gronn.", "그론을 처치해야 합니다.", "Derrote o Gronn.", "Победите гронна.", "击败戈隆。", "擊敗古羅。", }, 
{ "Bronze: Earn 300 Points", "Bronze: Verdient 300 Punkte.", "Bronce: Gana 300 puntos.", "Bronce: obtén 300 puntos", "Bronze : Obtenir 300 points", "Bronzo: ottieni 300 punti.", "동메달: 300점을 획득해야 합니다.", "Bronze: Obter 300 Pontos", "Бронза: заработайте 300 очков", "青铜：获得300点", "青銅：獲得300分", }, 
{ "Silver: Earn 600 Points", "Silber: Verdient 600 Punkte.", "Plata: Gana 600 puntos.", "Plata: obtén 600 puntos", "Argent : Obtenir 600 points.", "Argento: ottieni 600 punti.", "은메달: 600점을 획득해야 합니다.", "Prata: Obter 600 Pontos", "Серебро: заработайте 600 очков", "白银：获得600点", "白銀：獲得600分", }, 
{ "Gold: Earn 1000 Points", "Gold: Verdient 1000 Punkte.", "Oro: Gana 1000 puntos.", "Oro: obtén 1000 puntos", "Or : Obtenir 1 000 points", "Oro: ottieni 1.000 punti.", "금메달: 1000점을 획득해야 합니다.", "Ouro: Obter 1000 Pontos", "Золото: заработайте 1000 очков", "黄金：获得1000点", "黃金：獲得1000分", }, 
{ "Platinum: Earn 1300 Points", "Platin: Verdient 1300 Punkte.", "Platino: Gana 1300 puntos", "Platino: obtén 1300 puntos", "Platine : Obtenir 1 300 points", "Platino: ottieni 1.300 punti.", "백금메달: 1300점을 획득해야 합니다.", "Platina: Obter 1300 pontos", "Платина: заработайте 1300 очков", "白金：获得1300点", "白金：獲得1300分", }, 
},
["215"] = {
{ "You will only have a limited amount of time to gather as much treasure as you can.  Speak to Taoshi when you're ready to begin.", "Euch steht nur ein begrenzter Zeitraum zur Verfügung, um so viele Schätze aufzusammeln, wie Ihr nur könnt. Sprecht mit Taoshi, wenn Ihr bereit seid.", "Solo tendrás un tiempo limitado para reunir tantos tesoros como puedas. Habla con Taoshi cuando quieras empezar.", "Solo tendrás un tiempo limitado para reunir tantos tesoros como puedas. Habla con Taoshi cuando quieras empezar.", "Vous disposez d’un temps limité pour récupérer autant de butin que vous pouvez. Parlez à Taoshi quand vous voudrez commencer.", "Avrai un tempo limitato per raccogliere il maggior numero di tesori possibile. Parla con Taoshi quando vuoi cominciare.", "제한된 시간 내에 보물을 최대한 많이 챙겨야 합니다. 시작할 준비가 끝나면 타오스와 대화하십시오.", "Você terá apenas um tempo limitado para coletar o máximo de tesouro que conseguir. Fale com Taoshi quando estiver pronto para começar.", "В течение ограниченного времени соберите как можно больше сокровищ. Поговорите с Таоши, когда будете готовы начать.", "你必须在有限的时间内尽可能多夺取一些宝藏。当你准备好开始后，就与陶矢谈一谈。", "你只有有限的時間盡可能地收集寶藏。等你準備好開始時，跟陶氏說話。", }, 
{ "Grab as much treasure as you can and reach the exit before the timer expires.", "Greift Euch so viel Beute, wie Ihr könnt, und erreicht den Ausgang, bevor die Zeit ausläuft.", "Coge todo el tesoro que puedas y alcanza la salida antes de que se acabe el tiempo.", "Toma todo el tesoro que puedas y alcanza la salida antes de que se acabe el tiempo.", "Emportez autant de trésors que possible et atteignez la sortie avant que le décompte ne soit terminé.", "Recupera il maggior numero di tesori e raggiungi l'uscita prima dello scadere del tempo.", "제한된 시간이 끝날 때까지 보물을 획득한 후 출구로 가야 합니다.", "Pegue todos os tesouros que puder e alcance a saída antes que o tempo se esgote.", "Соберите как можно больше сокровищ и дойдите до выхода, пока не истекло время.", "在倒计时结束前尽可能多夺取一些宝藏并抵达出口。", "盡可能地收集寶藏然後在時間結束前抵達出口。", }, 
},
["599"] = {
{ "Defeat the bosses of The Nexus and free Keristrasza.", "Besiegt die Bosse im Nexus und befreit Keristrasza.", "Derrota a los jefes de El Nexo y libera a Keristrasza.", "Derrota a los jefes de El Nexo y libera a Keristrasza.", "Terrassez les boss du Nexus et libérer Keristrasza.", "Sconfiggi i boss del Nexus e libera Keristrasza.", "마력의 탑 우두머리들을 처치하고 케리스트라자를 풀어줘야 합니다.", "Derrote os chefes do Nexus e liberte Keristrasza.", "Победите боссов в Нексусе и освободите Керистразу.", "击败魔枢的首领并释放克莉斯塔萨。", "擊敗奧核之心的首領並救出凱瑞史卓莎。", }, 
{ "Defeat Commander Stoutbeard.", "Besiegt Kommandant Starkbart.", "Derrota al comandante Barbarrecia.", "Derrota al Comandante Barbarrecia.", "Terrassez le commandant Rudebarbe.", "Sconfiggi il Comandante Barbaforte.", "사령관 스타우트비어드를 처치해야 합니다.", "Derrote o Comandante Barbacã.", "Победите командира Пивоборода.", "击败指挥官斯托比德。", "擊敗指揮官厚鬚。", }, 
},
["515"] = {
{ "Defeat the inhabitants of Wailing Caverns.", "Besiegt die Bewohner der Höhlen des Wehklagens.", "Derrota a los habitantes de las Cuevas de los Lamentos.", "Derrota a los habitantes de las Cuevas de los Lamentos.", "Terrassez les occupants des cavernes des Lamentations.", "Sconfiggi gli abitanti della Caverna dei Lamenti.", "통곡의 동굴 거주민들을 처치해야 합니다.", "Derrote os habitantes da Caverna Ululante.", "Победите жителей Пещер Стенаний.", "击败哀嚎洞穴的住民。", "擊敗怒焰裂谷的敵人", }, 
{ "Protect Muyoh as he performs the awakening ritual", "Beschützt Muyoh, während er das Erweckungsritual durchführt.", "Protege a Muyoh mientras realiza el ritual del despertar.", "Protege a Muyoh mientras realiza el ritual del despertar.", "Protégez Muyoh pendant qu’il accomplit le rituel de réveil.", "Proteggi Muyoh mentre esegue la cerimonia del risveglio.", "무요가 의식을 치르는 동안 그를 보호해야 합니다.", "Proteja Muyoh enquanto ele realiza o ritual de despertar", "Защищайте Муйона, пока он проводит обряд пробуждения", "保护穆约完成唤醒仪式", "當繆幽執行喚醒儀式時保護他", }, 
{ "Defeat Kresh", "Besiegt Kresh.", "Derrota a Kresh.", "Derrota a Kresh.", "Terrassez Kresh.", "Sconfiggi Kresh.", "크레쉬를 처치해야 합니다.", "Derrote Cresh", "Победите Крига", "击败克雷什", "擊敗克雷什", }, 
{ "Defeat Skum", "Besiegt Skum.", "Derrota a Skum.", "Derrota a Skum.", "Terrassez Skum.", "Sconfiggi Skum", "스컴을 처치해야 합니다.", "Derrotar Skória", "Победите Шкама", "击败斯卡姆", "擊敗斯卡姆", }, 
{ "Defeat Verdan the Everliving", "Besiegt Verdan den Ewiglebenden.", "Derrota a Verdan el Eterno.", "Derrota a Verdan el Eterno.", "Terrassez Verdan l’Immortel", "Sconfiggi Verdan il Sempreverde.", "영생의 베르단을 처치해야 합니다.", "Derrote Verdan, o Sempre-vivo", "Победите Вердана Вечноживущего", "击败永生者沃尔丹", "擊敗永生的沃爾丹", }, 
},
["615"] = {
{ "Defeat the bosses of The Mechanar", "Bezwingt die Bosse der Mechanar.", "Derrota a los jefes de El Mechanar.", "Derrota a los jefes de El Mechanar.", "Terrassez les boss du Méchanar.", "Sconfiggi i boss di Mecanar.", "메카나르 우두머리들을 처치해야 합니다.", "Derrote os chefes do Mecanar", "Победите боссов в Механаре", "击败能源舰的首领", "擊敗麥克納爾的首領", }, 
},
["591"] = {
{ "Defeat the bosses of Drak'Tharon Keep", "Bezwingt die Bosse der Feste Drak'Tharon.", "Derrota a los jefes de la Fortaleza de Drak'Tharon.", "Derrota a los jefes de la Fortaleza de Drak'Tharon.", "Terrassez les boss du donjon de Drak’Tharon.", "Sconfiggi i boss del Forte di Drak'Tharon.", "드락타론 성채 우두머리들을 처치해야 합니다.", "Derrote os chefes da Bastilha Drak'Tharon", "Победите боссов в крепости Драк'Тарон", "击败达克萨隆要塞的首领", "擊敗德拉克薩隆要塞的首領", }, 
},
["992"] = {
{ "Board the Naglfar and face Helya in her own domain.", "Geht an Bord der Naglfar und tretet Helya in ihrem eigenen Reich entgegen.", "Sube a bordo del Naglfar y enfréntate a Helya en su propio territorio.", "Aborda el Naglfar y enfrenta a Helya en sus propios dominios.", "Montez à bord du Naglfar et affrontez Helya sur son propre terrain.", "Abborda la Naglfar e affronta Helya nel suo territorio.", "나글파르에 탑승하여, 헬리아의 영역에서 헬리아와 맞서야 합니다.", "Suba em Naglfar e enfrente Helya em seus próprios domínios.", "Проберитесь на борт \"Нагльфара\" и сразитесь с Хелией на ее территории.", "登上纳格法尔号，并在海拉的国度中挑战她。", "登上奈格法號，在黑爾雅的地盤上對付她。", }, 
},
["678"] = {
{ "Root out the corruption within Auchindoun.", "Beseitigt die Verderbnis in Auchindoun.", "Acaba con la corrupción en Auchindoun.", "Erradica la corrupción en Auchindoun.", "Débarrassez Auchindoun de la corruption.", "Sradica la corruzione all'interno di Auchindoun.", "아킨둔 안의 타락을 뿌리 뽑아야 합니다.", "Elimine a corrupção em Auchindoun.", "Искорените скверну в Аукиндоне.", "铲除奥金顿中的腐败。", "根除奧齊頓裡的腐化勢力。", }, 
},
["592"] = {
{ "Defeat the bosses of Ahn'kahet: The Old Kingdom", "Bezwingt die Bosse von Ahn'kahet: Das Alte Königreich.", "Derrota a los jefes de Ahn’kahet: El Antiguo Reino.", "Derrota a los jefes de Ahn'kahet: El Antiguo Reino.", "Terrassez les boss d’Ahn’kahet : l’Ancien royaume.", "Sconfiggi i boss di Ahn'kahet, il Regno Antico.", "안카헤트: 고대 왕국의 우두머리들을 처치해야 합니다.", "Derrote os chefes de Ahn'kahet: O Velho Reino", "Победите боссов в Ан'кахете: Старом Королевстве", "击败安卡赫特：古代王国的首领", "擊敗安卡罕特：古王國的首領", }, 
},
["278"] = {
{ "Seat and serve the customers as they show up. Don't let 5 patrons get away without being served.", "Weist so vielen Gästen wie möglich Plätze zu und bedient sie. Lasst nicht zu, dass mehr als 5 Gäste gehen, ohne bedient worden zu sein.", "Sienta y sirve a los clientes a medida que lleguen. No dejes que los clientes se marchen sin servirles.", "Sienta y sirve a los clientes a medida que lleguen. No dejes que los clientes se marchen sin servirles.", "Faites asseoir puis servez les clients au fur et à mesure qu’ils arrivent. Ne laissez pas plus de cinq clients partir sans avoir été servis.", "Fai sedere e servi i clienti man mano che arrivano. Non farne allontanare più di 5 prima di averli serviti.", "손님이 오면 자리를 마련하고 요리를 대접해야 합니다. 5명 이상의 손님이 대접받지 못한 채 떠나지 않게 해야 합니다.", "Acomode e sirva os fregueses à medida que forem chegando. Não deixe 5 cidadãos irem embora sem serem servidos.", "Рассаживайте клиентов и обслуживайте их. Не дайте 5 клиентам уйти, не дождавшись, пока их обслужат.", "尽你所能招呼更多的客人。因受冷落而离开的客人不能超过5个。", "招呼與服務上門的客人。別讓還沒用餐就離開的客人超過5名。", }, 
{ "Get a score of at least 30,000", "Erreicht einen Punktestand von mindestens 30.000", "Consigue una puntuación mínima de 30000.", "Consigue una puntuación mínima de 30000.", "Obtenez un score d’au moins 30 000.", "Ottieni un punteggio di almeno 30.000", "30,000점 이상의 점수를 획득해야 합니다.", "Conseguir uma pontuação de pelo menos 30.000", "Наберите по меньшей мере 30 000 очков.", "获得至少30000分。", "獲得至少30,000點分數", }, 
},
["1335"] = {
{ "Defeat Mephistroth and place the Aegis of Aggramar within the top of the tomb before you are overrun by the Legion.", "Bezwingt Mephistroth und platziert die Aegis von Aggramar im oberen Bereich des Grabmals, bevor Ihr von der Legion überrannt werdet.", "Derrota a Mephistroth y coloca la Égida de Aggramar en lo alto de la tumba antes de que la Legión lo invada todo.", "Derrota a Mephistroth y coloca la Égida de Aggramar en la cumbre de la tumba antes de que las fuerzas de la Legión arrasen contigo.", "Battez Méphistroth et placez l’Égide d’Aggramar au sommet de la tombe avant que la Légion vous submerge.", "Sconfiggi Mefistroth e piazza l'Egida di Aggramar nella sala in cima alla Cattedrale prima dell'invasione della Legione.", "군단에 짓밟히기 전에 메피스트로스를 처치하고 아그라마르의 아이기스를 무덤 꼭대기에 놓아야 합니다.", "Derrote Mephistroph e ponha a Égide de Aggramar no topo da tumba antes que a Legião subjugue você.", "Победите Мефистрота и установите Эгиду Агграмара на верхнем ярусе гробницы, пока силы Легиона не одолели вас.", "击败孟菲斯托斯，并在军团占领这里前把阿格拉玛之盾放置在墓穴顶层。", "在你被燃燒軍團消滅之前，擊敗梅菲斯托並且將阿格拉瑪之盾放置在墓地頂端。", }, 
{ "Defeat Mephistroth and place the Aegis of Aggramar within the top of the tomb before you are overrun by the Legion.", "Bezwingt Mephistroth und platziert die Aegis von Aggramar im oberen Bereich des Grabmals, bevor Ihr von der Legion überrannt werdet.", "Derrota a Mephistroth y coloca la Égida de Aggramar en lo alto de la tumba antes de que la Legión lo invada todo.", "Derrota a Mephistroth y coloca la Égida de Aggramar en la cumbre de la tumba antes de que las fuerzas de la Legión arrasen contigo.", "Battez Méphistroth et placez l’Égide d’Aggramar au sommet de la tombe avant que la Légion vous submerge.", "Sconfiggi Mefistroth e piazza l'Egida di Aggramar nella sala in cima alla Cattedrale prima dell'invasione della Legione.", "군단에 짓밟히기 전에 메피스트로스를 처치하고 아그라마르의 아이기스를 무덤 꼭대기에 놓아야 합니다.", "Derrote Mephistroph e ponha a Égide de Aggramar no topo da tumba antes que a Legião subjugue você.", "Победите Мефистрота и установите Эгиду Агграмара на верхнем ярусе гробницы, пока силы Легиона не одолели вас.", "击败孟菲斯托斯，并在军团占领这里前把阿格拉玛之盾放置在墓穴顶层。", "在你被燃燒軍團消滅之前，擊敗梅菲斯托並且將阿格拉瑪之盾放置在墓地頂端。", }, 
},
["614"] = {
{ "Defeat the bosses of The Mechanar", "Bezwingt die Bosse der Mechanar.", "Derrota a los jefes de El Mechanar.", "Derrota a los jefes de El Mechanar.", "Terrassez les boss du Méchanar.", "Sconfiggi i boss di Mecanar.", "메카나르 우두머리들을 처치해야 합니다.", "Derrote os chefes do Mecanar", "Победите боссов в Механаре", "击败能源舰的首领", "擊敗麥克納爾的首領", }, 
},
["983"] = {
{ "Follow Li Li and protect her from the dangers of Skywall.", "Folgt Li Li und beschützt sie vor den Gefahren des Himmelswalls.", "Sigue a Li Li y protégela de los peligros del Muro Celeste.", "Sigue a Li Li y protégela de los peligros de Muro Celeste.", "Suivez Li Li et protégez-la des dangers de Mur-Céleste.", "Segui Li Li e proteggila dai pericoli di Celaria.", "리 리를 따라가 하늘담의 위험으로부터 그녀를 보호해야 합니다.", "Siga Li Li e a proteja dos perigos da Muralha Celeste.", "Следуйте за Ли Ли и защитите ее от опасностей в Небесной выси.", "跟随丽丽，以免她在天空之墙中遭受危险。", "跟隨莉莉，並且保護她避開天空之牆的危險。", }, 
{ "Li Li has ran off ahead! Catch up with her.", "Li Li ist vorgelaufen! Schließt zu ihr auf.", "¡Li Li se ha adelantado! Alcánzala.", "¡Li Li se alejó demasiado! Alcánzala.", "Li Li est partie devant ! Rattrapez-la.", "Li Li è corsa avanti! Raggiungila.", "리 리가 앞으로 치고 나갑니다! 그녀를 따라잡아야 합니다.", "Li Li saiu correndo! Alcance-a.", "Ли Ли убежала вперед! Догоните ее.", "丽丽跑到前头去了！追上她！", "莉莉跑到前面去了！跟上她。", }, 
{ "Your foes are using the Stormtouched Orbs to empower themselves. Destroy the orbs and break through the Raging Winds.", "Eure Gegner benutzen die sturmberührten Kugeln, um sich mit Macht zu erfüllen. Zerstört die Kugeln und durchbrecht die tobenden Winde.", "Tus enemigos están usando los orbes tocados por la tormenta para potenciarse. Destruye los orbes y ábrete paso a través de los vientos arrasadores.", "Tus enemigos utilizan los orbes tocados por la tormenta para aumentar su poder. Destruye los orbes y atraviesa los Vientos feroces.", "Vos adversaires utilisent les orbes touchés par la tempête pour décupler leurs forces. Détruisez les orbes et frayez-vous un passage à travers les vents déchaînés.", "I tuoi nemici stanno utilizzando dei Globi Toccati dalla Tempesta per potenziarsi. Distruggi i globi e attraversa i Venti Furenti.", "적이 폭풍 깃든 구슬을 사용하여 힘을 강화하고 있습니다. 그 구슬을 파괴한 다음 울부짖는 바람을 돌파해야 합니다.", "Seus inimigos estão usando os Orbes Tocados pela Tempestade para se fortalecer. Destrua os orbes e penetre os Ventos Furiosos.", "Ваши противники усиливают себя при помощи наэлектризованных сфер. Уничтожьте сферы и прорвитесь через бушующие ветра.", "你的敌人使用风触之球强化了自身。摧毁这些球能让你穿过狂怒之风。", "你的敵人使用了風觸之球來強化自己。摧毀風觸之球，並且擊敗狂怒的風元素。", }, 
{ "Typhinius has summoned his servants, survive the assault!", "Typhinius hat seine Diener beschworen. Überlebt ihren Angriff!", "Typhinius ha invocado a sus sirvientes. ¡Sobrevive al ataque!", "Typhinius invocó a sus siervos. ¡Sobrevive al ataque!", "Typhinius a invoqué ses serviteurs. Survivez à leur assaut !", "Tifinius ha evocato i suoi servitori. Sopravvivi all'assalto!", "타이피니우스가 하수인들을 소환했습니다. 맹공에서 살아남아야 합니다!", "Typhinius convocou os servos, sobreviva ao ataque!", "Тайфуний призвал своих слуг. Отбейте их атаку!", "泰菲缪斯召唤了他的奴仆，努力在战斗中活下来！", "泰菲尼斯召喚了他的僕從，在這場突襲中活下來！", }, 
{ "You've weakened the Storm Dragon. Leap upon the beast and use it to reach Typhinius.", "Ihr habt den Sturmdrachen geschwächt. Springt auf den Rücken der Bestie und setzt sie ein, um Typhinius zu erreichen.", "Has debilitado al dragón de tormenta. Salta sobre la bestia y úsala para llegar hasta Typhinius.", "Debilitaste al Dragón de la tormenta. Salta sobre la bestia y úsala para llegar hasta Typhinius.", "Vous avez affaibli le dragon des tempêtes. Sautez sur la bête et utilisez-la pour atteindre Typhinius.", "Hai indebolito il Drago della Tempesta. Salta sul dorso della bestia e usala per raggiungere Tifinius.", "폭풍 용을 약화시켰습니다. 용의 등에 올라타 타이피니우스에게 가야 합니다.", "Você enfraqueceu o Dragão da Tempestade. Salte na fera e use-a para chegar até Typhinius.", "Вы ослабили грозового дракона. Запрыгните на него и доберитесь до Тайфуния.", "你削弱了风暴巨龙。跳上他的背，并前往泰菲缪斯的所在地。", "你成功弱化了風暴龍。跳到牠的身上，飛向泰菲尼斯。", }, 
{ "Defeat Typhinius", "Bezwingt Typhinius.", "Derrota a Typhinius.", "Derrota a Typhinius", "Vaincre Typhinius", "Sconfiggi Tifinius.", "타이피니우스를 물리쳐야 합니다.", "Derrote Typhinius", "Победите Тайфуния.", "击败泰菲缪斯", "擊敗泰菲尼斯。", }, 
{ "The Fists of the Heavens are yours, take them.", "Die Fäuste der Himmel sind Euer, nehmt sie.", "Los Puños de los Cielos son tuyos. Cógelos.", "Los Puños de los Cielos son tuyos, tómalos.", "Les Poings des cieux sont à vous. Prenez-les.", "I Pugni del Cielo sono tuoi, prendili.", "이제 하늘의 주먹은 당신의 것입니다. 무기를 획득하십시오.", "Os Punhos do Paraíso são seus, pegue-os.", "Кулаки Небес теперь ваши. Заберите их.", "诸天之拳是你的了，拿走它吧。", "蒼天之拳是你的了，拿起它們。", }, 
},
["1134"] = {
{ "Speak with Thassarian.", "Sprecht mit Thassarian.", "Habla con Thassarian.", "Habla con Thassarian.", "Parlez à Thassarian.", "Parla con Thassarian.", "타사리안과 대화해야 합니다.", "Fale com Thassarian.", "Поговорите с Тассарианом.", "和萨萨里安谈谈。", "與薩沙理安交談。", }, 
{ "Escort Thassarian through the Undercity.", "Begleitet Thassarian durch Unterstadt.", "Escolta a Thassarian por Entrañas.", "Escolta a Thassarian por las Entrañas.", "Escortez Thassarian à travers Fossoyeuse.", "Scorta Thassarian attraverso Sepulcra.", "언더시티에서 이동하는 동안 타사리안을 호위해야 합니다.", "Escolte Thassarian pela Cidade Baixa.", "Сопровождайте Тассариана по пути через Подгород.", "护送萨萨里安穿过幽暗城。", "護送薩沙理安通過幽暗城。", }, 
{ "Rescue Koltira from the Apothecarium.", "Rettet Koltira aus dem Apothekarium.", "Rescata a Koltira de El Apothecarium.", "Rescata a Koltira del Apothecarium.", "Sauvez Koltira dans l’Apothicarium.", "Salva Koltira dal Quartiere degli Speziali.", "연금술 실험실에 있는 콜티라를 구출해야 합니다.", "Resgate Koltirus do Boticarium.", "Освободите Кольтиру из темницы в районе Фармацевтов.", "从炼金房中救出库尔迪拉。", "救寇爾提拉離開鍊金房。", }, 
},
["207"] = {
{ "Mount your Thunderwing!", "Steigt auf Euren Donnerflügel!", "¡Súbete en Alatrueno!", "¡Súbete en Alatrueno!", "Chevauchez votre Aile-Tonnerre !", "Cavalca il tuo alatonante!", "천둥날개에 올라타십시오!", "Monte no seu Trovoasa!", "Оседлайте Громокрыла!", "骑上你的雷霆翼龙！", "騎上你的雷翅翼手龍!", }, 
{ "The Zandalari have spotted you! Defeat your attackers!", "Die Zandalari haben Euch entdeckt! Besiegt Eure Angreifer!", "¡Los Zandalari te han encontrado! ¡Derrota a tus atacantes!", "¡Los Zandalari te han encontrado! ¡Derrota a tus atacantes!", "Les Zandalari vous ont repéré ! Terrassez vos attaquants !", "Gli Zandalari ti hanno individuato! Sconfiggi gli assalitori!", "잔달라가 당신을 발견했습니다! 처치하십시오!", "Os Zandalari viram você! Derrote os agressores!", "Зандалары заметили вас! Убейте атакующих!", "赞达拉巨魔发现你了！击败进攻者！", "贊達拉看見你了!擊敗敵人!", }, 
{ "Horaki has knocked you from your mount! Defeat him!", "Horaki hat Euch von Eurem Reittier geschossen! Besiegt ihn!", "¡Horaki te ha tirado de la montura! ¡Derrótalo!", "¡Horaki te ha tirado de la montura! ¡Derrótalo!", "Horaki vous a désarçonné ! Terrassez-le !", "Horaki ti ha disarcionato dalla tua cavalcatura! Sconfiggilo!", "호라키가 당신을 탈것에서 떨어뜨렸습니다! 처치해버리십시오!", "Horaki derrubou você da montaria! Derrote-o!", "Хораки сбросил вас с вашего средства передвижения! Победите его!", "胡拉奇把你打下了坐骑！打败他！", "霍拉奇將你從坐騎上擊落!打敗他!", }, 
{ "Meet up with Taoshi, your Shado-Pan Contact.", "Trefft Euch mit Taoshi, Eurem Kontakt bei den Shado-Pan.", "Reúnete con Taoshi, el contacto del Shadopan.", "Reúnete con Taoshi, el contacto del Shadopan.", "Allez voir Taoshi, votre contact pandashan.", "Incontra Taoshi, il tuo contatto Shandaren.", "음영파 연락책인 타오스와 만나야 합니다.", "Encontre-se com Taoshi, seu contato Shado-pan.", "Встретьтесь с Таоши, вашей связной из Шадо-Пан.", "与你的影踪派联络人陶矢会面。", "與你的影潘聯絡人陶氏碰面。", }, 
{ "Make your way to the mine's main door.", "Bahnt Euch den Weg durch das Haupttor der Mine.", "Ve hasta la puerta principal de la mina.", "Ve hasta la puerta principal de la mina.", "Frayez-vous un chemin jusqu’à la porte principale de la mine.", "Raggiungi l'ingresso principale delle miniere.", "광산 정문으로 이동해야 합니다.", "Vá até a entrada principal da mina.", "Проберитесь к главному входу в шахту.", "抵达矿洞的主大门处。", "想辦法前往礦坑大門。", }, 
{ "Cover Taoshi while she deactivates the lock on the mine door, and defeat Slavemaster Shiaxu.", "Gebt Taoshi Deckung, während sie das Schloss am Minentor deaktiviert, und besiegt Sklavenmeister Shiaxu.", "Cubre a Taoshi mientras ella desactiva el cierre de la puerta de la mina y derrota al maestro de esclavos Shiaxu.", "Cubre a Taoshi mientras ella desactiva el cierre de la puerta de la mina y derrota al maestro de esclavos Shiaxu.", "Couvrez Taoshi pendant qu’elle désactive le verrou sur la porte de la mine et terrassez l’esclavagiste Shiaxu.", "Proteggi Taoshi mentre scassina la serratura dell'ingresso alla miniera e sconfiggi Shiaxu l'Aguzzino.", "타오스가 광산문의 자물쇠를 해체하는 동안 엄호하고, 노예감독 스아쉬를 처치해야 합니다.", "Dê cobertura a Taoshi enquanto ela desativa as trancas na porta da mina e derrote o Senhor dos Escravos Shiaxu.", "Прикройте Таоши, пока она деактивирует замок на двери шахты, а затем победите надсмотрщика Шиаксу.", "在陶矢解除矿脉门锁时掩护她，并击败奴隶主夏旭。", "在陶氏替礦坑大門開鎖時掩護她，並擊敗奴隸主夏許。", }, 
},
["583"] = {
{ "Chromie has asked you to accompany Arthas in the Culling of Stratholme, you must see to it that he defeats Mal'Ganis!", "Chromie möchte, dass Ihr Arthas beim Ausmerzen von Stratholme begleitet. Sorgt dafür, dass er Mal'Ganis besiegt!", "Cromi te ha pedido que acompañes a Arthas en La Matanza de Stratholme. ¡Asegúrate de que derrota a Mal'Ganis!", "Cromi te pidió que acompañes a Arthas en La Matanza de Stratholme, ¡debes hacerlo hasta que derrote a Mal'Ganis!", "Chromie vous a demandé d’accompagner Arthas dans l’épuration de Stratholme. Vous devez veiller à ce qu’il triomphe de Mal’Ganis !", "Cromie ti ha chiesto di accompagnare Arthas nell'Epurazione di Stratholme affinché sconfigga Mal'Ganis.", "크로미가 아서스와 함께 옛 스트라솔름에 가 달라고 부탁했습니다. 아서스가 말가니스를 무찌르게 도와줘야 합니다!", "Crona pediu a você que acompanhe Arthas no Expurgo de Stratholme. Você deve cuidar para que ele derrote Mal'ganis!", "Хроми попросила вас сопровождать Артаса во время очищения Стратхольма. Помогите ему победить Мал'Ганиса!", "克罗米要你陪伴阿尔萨斯完成清洗斯坦索姆的任务，你必须确保他击败玛尔加尼斯！", "克羅米要求你，在斯坦索姆的抉擇中，隨侍於阿薩斯身側，你必須協助他擊敗瑪爾加尼斯！", }, 
},
["46"] = {
{ "Defeat the forces opposing you within the Shado-Pan Monastery.", "Bezwingt die Streitkräfte, die sich Euch im Shado-Pan-Kloster entgegenstellen.", "Derrota a las fuerzas que te hagan frente dentro del Monasterio del Shadopan.", "Derrota a las fuerzas que te hagan frente dentro del Monasterio del Shadopan.", "Terrassez les troupes qui s’opposent à vous dans le monastère des Pandashan.", "Sconfiggi le forze avverse nel Monastero degli Shandaren.", "음영파 수도원 내부에서 당신을 공격하는 적들을 처치해야 합니다.", "Derrote as forças que se opõem a você no Monastério Shado-pan.", "Победите врагов в монастыре Шадо-Пан.", "击败影踪禅院内和你作对的敌人。", "擊敗在影潘僧院裡阻撓你的對手。", }, 
},
["707"] = {
{ "Follow the Sergeant", "Folgt dem Unteroffizier", "Sigue al Sargento.", "Sigue al sargento", "Suivez le sergent.", "Segui il Sergente.", "하사관을 따라가야 합니다.", "Siga o Sargento", "Следуйте за сержантом", "追随中士", "跟隨士官", }, 
{ "Defeat the Lashers", "Besiegt die Peitscher.", "Derrota a los azotadores.", "Derrota a los Azotadores.", "Terrassez les Flagellants.", "Sconfiggi le Piante Sferzanti.", "덩굴손들을 처치해야 합니다.", "Derrote as Açoitadoras", "Победите плеточников", "击败鞭笞者", "擊敗鞭笞者", }, 
{ "Endure the Primals' assault.", "Haltet dem Ansturm der Ursprünglichen stand.", "Resiste al asalto de los primigenios.", "Aguanta el asalto de los primigenios.", "Survivez à l’attaque des primordiaux.", "Resisti all'assalto dei Primordiali.", "원시생물의 공격을 막아내야 합니다.", "Resistir ao ataque dos Primevos.", "Переживите нападение изначальных.", "顶住原兽的攻击。", "撐過源生者的攻擊。", }, 
{ "Defeat the remaining Botani forces.", "Besiegt die verbleibenden Truppen der Botani.", "Derrota a las fuerzas botani restantes.", "Derrota a las fuerzas botani restantes.", "Terrassez ce qui reste des botani.", "Sconfiggi le forze restanti dei Botani.", "남은 신록지기 병력을 물리쳐야 합니다.", "Derrote as forças Botanis restantes.", "Одержите победу над оставшимися ботани.", "击败木精的残余部队。", "擊敗剩下的波塔尼部隊。", }, 
{ "Return to the town center.", "Kehrt zur Ortsmitte zurück.", "Vuelve al centro de la ciudad.", "Vuelve al centro del pueblo.", "Retournez dans le centre-ville.", "Torna al centro del villaggio.", "마을 중앙으로 가야 합니다.", "Retorne ao centro da cidade.", "Вернитесь в центр гарнизона.", "返回镇中心。", "返回城鎮中心。", }, 
{ "Defeat the Ancient and its tenders.", "Besiegt das Urtum und seine Hüter.", "Derrota al anciano y a sus cuidadores.", "Derrota al Ancestro y a sus cuidadores.", "Terrassez l’Ancien et ses sylveniers.", "Sconfiggi l'Antico e i suoi guardiani.", "고대정령과 그 수호자들을 처치해야 합니다.", "Derrote o Anciente e seus tratadores.", "Победите древнего и его хранителей.", "击败古树和它的护卫。", "擊敗古樹與其照顧者。", }, 
{ "Bronze: Earn 300 Points", "Bronze: Verdient 300 Punkte.", "Bronce: Gana 300 puntos.", "Bronce: obtén 300 puntos", "Bronze : Obtenir 300 points", "Bronzo: ottieni 300 punti.", "동메달: 300점을 획득해야 합니다.", "Bronze: Obter 300 Pontos", "Бронза: заработайте 300 очков", "青铜：获得300点", "青銅：獲得300分", }, 
{ "Silver: Earn 600 Points", "Silber: Verdient 600 Punkte.", "Plata: Gana 600 puntos.", "Plata: obtén 600 puntos", "Argent : Obtenir 600 points.", "Argento: ottieni 600 punti.", "은메달: 600점을 획득해야 합니다.", "Prata: Obter 600 Pontos", "Серебро: заработайте 600 очков", "白银：获得600点", "白銀：獲得600分", }, 
{ "Gold: Earn 1000 Points", "Gold: Verdient 1000 Punkte.", "Oro: Gana 1000 puntos.", "Oro: obtén 1000 puntos", "Or : Obtenir 1 000 points", "Oro: ottieni 1.000 punti.", "금메달: 1000점을 획득해야 합니다.", "Ouro: Obter 1000 Pontos", "Золото: заработайте 1000 очков", "黄金：获得1000点", "黃金：獲得1000分", }, 
{ "Platinum: Earn 1300 Points", "Platin: Verdient 1300 Punkte.", "Platino: Gana 1300 puntos", "Platino: obtén 1300 puntos", "Platine : Obtenir 1 300 points", "Platino: ottieni 1.300 punti.", "백금메달: 1300점을 획득해야 합니다.", "Platina: Obter 1300 pontos", "Платина: заработайте 1300 очков", "白金：获得1300点", "白金：獲得1300分", }, 
},
["607"] = {
{ "Defeated the bosses of The Shattered Halls.", "Bosse der Zerschmetterten Hallen bezwungen.", "Derrota a los jefes de las Salas Arrasadas.", "Derrota a los jefes de Las Salas Arrasadas.", "Terrassez les boss des salles Brisées.", "Sconfiggi i boss delle Sale della Devastazione.", "으스러진 손의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões Despedaçados.", "Победите боссов в Разрушенных залах.", "击败破碎大厅的首领。", "擊敗破碎大廳的首領。", }, 
},
["183"] = {
{ "Assist the two groups of laborers in the construction of their defenses.", "Unterstützt die beiden Arbeitergruppen bei der Errichtung ihrer Verteidigungsanlagen.", "Ayuda a los dos grupos de obreros a construir sus defensas.", "Ayuda a los dos grupos de obreros a construir sus defensas.", "Aidez les deux groupes de travailleurs à construire leurs défenses.", "Aiuta i due gruppi di braccianti nella costruzione delle difese.", "수비진을 만드는 두 무리의 일꾼을 도와야 합니다.", "Ajude os dois grupos de trabalhadores na construção das defesas.", "Помогите как минимум двум группам рабочих построить укрепления.", "协助两队劳工建造防御工事。", "幫助兩組苦力建立他們的防衛力量。", }, 
{ "Defeat Commander Scargash and reclaim the Temple of the Red Crane.", "Bezwingt Kommandant Schlitznarbe und erobert den Tempel des Roten Kranichs zurück.", "Derrota al comandante Sangrescara y reclama el Templo de la Grulla Roja.", "Derrota al comandante Sangrescara y reclama el Templo de la Grulla Roja.", "Terrassez le commandant Coupentaille et reprenez le temple de la Grue rouge.", "Sconfiggi il Comandante Sventracuori e riprendi il Tempio della Gru Rossa.", "사령관 스카가쉬를 처치한 뒤 주학사를 되찾아야 합니다.", "Derrote o Comandante Escorchaga e tome o Templo da Garça Vermelha.", "Победить командира Глубокого Шрама и вернуть храм Красного Журавля.", "击败指挥官斯卡戈什并夺回朱鹤寺。", "打敗指揮官疤口並收復紅鶴寺。", }, 
},
["206"] = {
{ "Mount the Sunreaver Bloodhawk and fly with Scout Captain Elsia over the island.", "Steigt auf den Blutfalken der Sonnenhäscher und fliegt mit Späherhauptmann Elsia über die Insel.", "Monta en el halcón de sangre Atracasol y sobrevuela la isla con la capitana de exploradores Elsia.", "Monta en el halcón de sangre Atracasol y sobrevuela la isla con la capitana de exploradores Elsia.", "Chevauchez le faucon-de-sang saccage-soleil et survolez l’île avec le capitaine des éclaireurs Elsia.", "Cavalca il Falco del Sangue dei Predatori del Sole e vola con il Capitano degli Esploratori Elsia sopra l'isola.", "선리버 혈매를 타고 정찰대장 엘시아와 함께 섬 위를 비행해야 합니다.", "Monte o Falcossangre Fendessol e sobrevoe a ilha com a Capitã dos Batedores Elsia.", "Сядьте на кровавого ястреба Похитителей Солнца и пролетите над островом с капитаном разведчиков Эльсией.", "骑上夺日者血鹰，与斥候队长艾尔希娅一起飞过岛屿。", "騎上奪日者血鷹並與斥候隊長艾爾西雅飛往島嶼。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["734"] = {
{ "Defeat the bosses of Lower Blackrock Spires", "Bezwingt die Bosse der Unteren Schwarzfelsspitze.", "Derrota a los jefes de Cumbre de Roca Negra Inferior.", "Derrota a los jefes de las Cumbres de Roca Negra inferiores", "Terrassez les boss du Bas du pic Rochenoire.", "Sconfiggi i boss dei Bastioni di Roccianera Inferiori.", "검은바위 첨탑 하층 우두머리들을 처치해야 합니다.", "Derrote os chefes do Pico da Rocha Negra Inferior", "Одолейте боссов в нижней части пика Черной горы.", "击败黑石塔下层的首领", "擊敗黑石塔下層裡的頭目", }, 
{ "Urok Doomhowl defeated", "Urok Schreckensbote besiegt.", "Urok Aullasino derrotado.", "Urok Aullasino derrotado.", "Urok Hurleruine vaincu", "Sconfiggi Urok Urlonero.", "우로크 둠하울을 처치해야 합니다.", "Urok Uivo-da-ruína derrotado", "Аррок Смертный Вопль побежден", "击败乌洛克", "擊敗烏洛克‧末日嚎", }, 
},
["590"] = {
{ "Defeat the bosses of Drak'Tharon Keep", "Bezwingt die Bosse der Feste Drak'Tharon.", "Derrota a los jefes de la Fortaleza de Drak'Tharon.", "Derrota a los jefes de la Fortaleza de Drak'Tharon.", "Terrassez les boss du donjon de Drak’Tharon.", "Sconfiggi i boss del Forte di Drak'Tharon.", "드락타론 성채 우두머리들을 처치해야 합니다.", "Derrote os chefes da Bastilha Drak'Tharon", "Победите боссов в крепости Драк'Тарон", "击败达克萨隆要塞的首领", "擊敗德拉克薩隆要塞的首領", }, 
},
["569"] = {
{ "Defeat the bosses of the Pit of Saron", "Besiegt die Bosse in der Grube von Saron.", "Derrota a los jefes del Foso de Saron.", "Derrota a los jefes de El Foso de Saron.", "Terrassez les boss de la fosse de Saron.", "Sconfiggi i boss della Fossa di Saron.", "사론의 구덩이 우두머리들을 처치해야 합니다.", "Derrote os chefes do Fosso de Saron", "Победите боссов в Яме Сарона", "击败萨隆矿坑的首领", "擊敗薩倫之淵的首領", }, 
},
["669"] = {
{ "Defeat the bosses in the Detention Block", "Bezwingt die Bosse des Gefängnisblocks.", "Derrota a los jefes del Bloque de Detención.", "Derrota a los jefes del Bloque de Detención", "Triomphez des boss du Mitard.", "Sconfiggi i boss del Blocco di Detenzione.", "감금 구역 우두머리들을 처치해야 합니다.", "Derrote os chefes no Bloco de Detenção.", "Победите боссов в Тюремном блоке", "击败禁闭室的首领", "擊敗禁閉室的首領", }, 
{ "Complete the Ring of Law", "Schließt den Ring des Gesetzes ab", "Completa el Círculo de la Ley.", "Completa el Círculo de la Ley", "Venez à bout du Cercle de la loi.", "Completa l'Anello della Legge.", "법의 심판장을 완료해야 합니다.", "Completar o Círculo da Lei", "Выживите в Зале Правосудия", "完成秩序竞技场", "完成秩序競技場", }, 
{ "Defeat High Interrogator Gerstahn", "Besiegt Verhörmeisterin Gerstahn", "Derrota a la alta interrogadora Gerstahn.", "Derrota a la Alta interrogadora Gerstahn", "Triomphez de la grande Interrogatrice Gerstahn.", "Sconfiggi Gerstahn la Grande Accusatrice.", "대심문관 게르스탄을 처치해야 합니다.", "Derrote a Suprema Interrogadora Gerstahn", "Победите верховного дознавателя Герштан", "击败审讯官格斯塔恩", "擊敗高階審問者格斯塔恩", }, 
{ "Defeat Bael'Gar", "Bezwingt Bael'Gar", "Derrota a Bael'Gar.", "Derrota a Bael'Gar", "Triomphez de Bael’Gar.", "Sconfiggi Bael'gar.", "밸가르를 처치해야 합니다.", "Derrote Bael'gar", "Победите Бейл'Гора", "击败贝尔加", "擊敗貝爾加", }, 
},
["180"] = {
{ "Destroy the orbs of protection and make your way into the fortress.", "Zerstört die Kugeln des Schutzes und begebt Euch in die Festung.", "Destruye los orbes de protección y entra en la fortaleza.", "Destruye los orbes de protección y entra en la fortaleza.", "Détruisez les orbes de protection et frayez-vous un chemin dans la forteresse.", "Distruggi i Globi di Protezione e penetra dentro la fortezza.", "보호의 수정을 파괴한 뒤 요새 안으로 이동해야 합니다.", "Destrua os orbes de proteção e entre na fortaleza.", "Разрушьте охранные сферы и проникните в крепость.", "摧毁防御宝珠并进入堡垒。", "摧毀然後進入堡壘。", }, 
{ "Grab as much treasure as you can before the titan construct is released.", "Schnappt Euch so viele Schätze Ihr nur könnt, bevor das titanische Konstrukt freigesetzt wird.", "Hazte con todos los tesoros que puedas antes de que se libere el ensamblaje titánico.", "Hazte con todos los tesoros que puedas antes de que se libere el ensamblaje titánico.", "Ramassez autant de butin que vous pouvez avant que la créature des titans soit lâchée.", "Recupera il maggior numero di tesori prima che il costrutto dei Titani venga liberato.", "티탄 구조물이 풀려나기 전에 보물을 최대한 많이 획득해야 합니다.", "Pegue todos os tesouros que puder antes que o constructo titânico seja solto.", "Наберите как можно больше сокровищ, пока создание титанов не оказалось на свободе.", "在泰坦构造体出现前尽力攫取宝藏。", "在泰坦傀儡被施放之前拿走越多寶物越好。", }, 
},
["525"] = {
{ "Defeat the bosses of Siege of Niuzao Temple.", "Besiegt die Bosse bei der Belagerung des Niuzaotempels.", "Derrota a los jefes del Asedio del Templo de Niuzao.", "Derrota a los jefes del Asedio del Templo de Niuzao.", "Terrassez les boss du siège du temple de Niuzao.", "Sconfiggi i boss dell'Assedio al Tempio di Niuzao.", "니우짜오 사원 공성전투 우두머리들을 처치해야 합니다.", "Derrote os chefes do Cerco ao Templo Niuzao.", "Победите боссов во время осады храма Нюцзао.", "击败围攻砮皂寺的首领。", "擊敗圍攻怒兆寺的首領。", }, 
},
["425"] = {
{ "Defeat the Bloodmaul slavers operating the Slag Mines.", "Besiegt die Sklaventreiber, die die Blutschlägermine betreiben.", "Derrota a los esclavistas Machacasangre que manejan las Minas Machacasangre.", "Derrota a los esclavos Machacasangre que operan en las Minas de Escoria.", "Terrassez les esclavagistes de la mine de la Masse-Sanglante.", "Sconfiggi gli Schiavisti Magliorosso che gestiscono le miniere.", "잿가루 광산을 감독하는 피망치 노예사냥꾼들을 처치해야 합니다.", "Derrote os feitores do Malho Sangrento nas Minas de Escória.", "Победите поработителей из клана Кровавого Молота в Шлаковых шахтах.", "击败经营着血槌炉渣矿井的血槌奴隶主。", "擊敗營運熔渣礦場的血槌奴隸商人。", }, 
},
["625"] = {
{ "Defeat the bosses of Old Hillsbrad", "Bezwingt die Bosse im Vorgebirge des Alten Hügellands.", "Derrota a los jefes de las Antiguas Laderas de Trabalomas.", "Derrota a los jefes de las Antiguas Trabalomas.", "Terrassez les boss des contreforts de Hautebrande d’antan.", "Sconfiggi i boss del Passato di Colletorto.", "옛 언덕마루 구릉지 우두머리들을 처치해야 합니다.", "Derrote os chefes da Antiga Eira dos Montes", "Победите боссов в старом Хилсбраде", "击败旧希尔斯布莱德的首领", "擊敗希爾斯布萊德丘陵舊址的首領", }, 
},
["962"] = {
{ "Listen to Ritssyn.", "Hört Ritssyn zu.", "Escucha a Ritssyn.", "Escucha a Ritssyn.", "Écoutez Ritssyn.", "Ascolta Ritssyn.", "릿신의 이야기를 들어야 합니다.", "Escute Ritssyn.", "Выслушайте Ритцуна.", "听从雷特森的建议。", "聆聽瑞特辛的話。", }, 
{ "Enslave the jailer Beshtal to free yourself from his cage, then defeat him with Ritssyn's aid.", "Versklavt den Wärter Beshtal, um Euch aus seinem Käfig zu befreien und besiegt ihn dann mit Ritssyns Hilfe.", "Esclaviza al carcelero Beshtal para liberarte de su jaula y después derrótalo con la ayuda de Ritssyn.", "Esclaviza al carcelero Beshtal para liberarte de su jaula y luego derrótalo con la ayuda de Ritssyn.", "Asservissez le geôlier Beshtal pour sortir de sa cage puis terrassez-le avec l’aide de Ritssyn.", "Obbliga il Carceriere Beshtal a liberarti dalla sua gabbia, quindi sconfiggilo con l'aiuto di Ritssyn.", "간수 베쉬탈을 지배하여 우리에서 풀려난 후, 릿신의 도움을 받아 간수를 처치해야 합니다.", "Escravize Beshtal, o carcereiro, para que liberte você da cela. Em seguida, derrote-o, com o auxílio de Ritssyn.", "Подчините тюремщика Бештала, чтобы выбраться из его клетки, а затем вместе с Ритцуном победите его.", "奴役狱卒贝什塔尔，让他放你出去，然后在雷特森的帮助下击败他。", "奴役獄卒貝許塔爾並逃出他的牢籠，然後跟瑞特辛一起擊敗他。", }, 
{ "Rescue Jubeka Shadowbreaker, Zinnin Smythe, and Shinfel Blightsworn.", "Rettet Jubeka Schattenbrecher, Zinnin Smythe und Shinfel Pestschwur.", "Rescata a Jubeka Domasombras, Zinnin Smythe y Shinfel Jurañublo.", "Rescata a Jubeka Domasombras, Zinnin Smythe y Shinfel Juraplaga.", "Secourez Jubeka Brisombre, Zinnin Smythe et Shinfel Chancrelige.", "Salva Jubeka Spezzaombre, Zinnin Smythe e Shinfel Giurapiaga.", "주베카 섀도브레이커, 지닌 스마이드, 신펠 블라이트스원을 구출해야 합니다.", "Resgate Jubeka Quebrassombra, Zinnin Smythe e Shinfel Jura de Praga.", "Спасите Джубеку Тенелом, Зиннина Смайта и Шинфель Преданную Погибели.", "救出裘碧卡·碎影、泽宁·斯米瑟和辛菲儿·疫誓。", "拯救裘貝卡‧破影者、辛尼‧斯麥瑟，和馨菲‧疫誓。", }, 
{ "Meet with Calydus on the bridge past the fel flame barrier.", "Trefft Euch mit Calydus auf der Brücke jenseits der Teufelsflammenbarriere.", "Reúnete con Calydus en el puente que hay tras la barrera de llamas viles.", "Reúnete con Calydus en el puente que está detrás de la barrera de llama vil.", "Retrouvez Calydus sur le pont qui se trouve derrière la barrière de gangreflammes.", "Incontra Calydus sul ponte, oltre la barriera di Vilfiamma.", "지옥 불꽃 방벽 너머의 다리에서 칼리두스와 만나야 합니다.", "Encontre Calydus na ponte que fica além da barreira das chamas vis.", "Встретьтесь с Калидом на мосту за барьером пламени Скверны.", "在邪能烈焰屏障另一边的桥上与卡里杜斯会面。", "跟卡萊德斯在惡魔火焰屏障另一邊的橋上碰面。", }, 
{ "Follow Calydus to the archives to uncover information about the artifacts Jagganoth hunts.", "Folgt Calydus zu den Archiven, um Informationen über die Artefakte zu erhalten, hinter denen Jagganoth her ist.", "Sigue a Calydus a los archivos para descubrir información sobre los artefactos que busca Jagganoth.", "Sigue a Calydus hasta los archivos para descubrir información sobre los artefactos que busca Jagganoth.", "Suivez Calydus jusqu’aux archives pour en savoir plus sur les armes prodigieuses que recherche Jagganoth.", "Segui Calydus agli archivi per scoprire informazioni sugli artefatti che Jagganoth sta cercando.", "칼리두스를 따라 기록실로 가서 자가노스가 뒤쫓는 유물에 대한 정보를 밝혀야 합니다.", "Siga Calydus até os arquivos para descobrir mais informações sobre os artefatos que Jagganoth busca.", "Проследуйте за Калидом в архивы, чтобы отыскать информацию об артефактах, за которыми охотится Джагганот.", "跟随卡里杜斯前往档案馆，了解贾格诺斯所要寻找的神器的情报。", "跟隨卡萊德斯前往檔案室，調查賈岡諾斯所尋找的神器線索。", }, 
{ "Follow Calydus to escape from Dreadscar Rift.", "Folgt Calydus, um aus der Schreckensnarbe zu entkommen.", "Sigue a Calydus para escapar de la Falla Cicatriz del Terror.", "Sigue a Calydus para escapar de la Falla Cicatriz Aterradora.", "Suivez Calydus pour fuir la faille de Scareffroi.", "Segui Calydus per fuggire dalla Faglia Malosfregio.", "칼리두스를 따라가 공포흉터 균열에서 탈출해야 합니다.", "Siga Calydus para escapar da Fenda Chagamedo.", "Следуйте за Калидом и покиньте разлом Зловещего Шрама.", "跟随卡里杜斯逃离恐痕裂隙。", "跟隨卡萊德斯逃出懼痕裂隙。", }, 
},
["688"] = {
{ "Defeat the Adherents of Rukhmar atop Skyreach.", "Bezwingt die Jünger von Rukhmar auf der Himmelsnadel.", "Derrota a los Adeptos de Rukhmar en lo alto del Trecho Celestial.", "Derrota a los Partidarios de Rukhmar en lo alto del Trecho Celestial.", "Terrassez les adhérents de Rukhmar au sommet d’Orée-du-Ciel.", "Sconfiggi i Proseliti di Rukhmar in cima a Vetta dei Cieli.", "하늘탑 꼭대기에 있는 루크마르의 신봉자들을 처치해야 합니다.", "Derrote os Seguidores de Rukhmar no topo de Beira-céu.", "Одолейте Приверженцев Рухмар в Небесном Пути.", "击败通天峰的鲁克玛信徒。", "擊敗擎天峰頂的魯克馬爾擁護者", }, 
},
["588"] = {
{ "Defeat the bosses of Violet Hold", "Besiegt die Bosse der Violetten Festung", "Derrota a los jefes del Bastión Violeta.", "Derrota a los jefes del bastión Violeta", "Triomphez des boss du fort Pourpre.", "Sconfiggi i boss della Fortezza Violacea.", "보랏빛 요새 우두머리들을 처치해야 합니다.", "Derrote os chefes do Castelo Violeta", "Победите боссов в Аметистовой крепости", "击败紫罗兰监狱的首领", "擊敗紫羅蘭堡的首領", }, 
},
["524"] = {
{ "Defeat the bosses of Siege of Niuzao Temple.", "Besiegt die Bosse bei der Belagerung des Niuzaotempels.", "Derrota a los jefes del Asedio del Templo de Niuzao.", "Derrota a los jefes del Asedio del Templo de Niuzao.", "Terrassez les boss du siège du temple de Niuzao.", "Sconfiggi i boss dell'Assedio al Tempio di Niuzao.", "니우짜오 사원 공성전투 우두머리들을 처치해야 합니다.", "Derrote os chefes do Cerco ao Templo Niuzao.", "Победите боссов во время осады храма Нюцзао.", "击败围攻砮皂寺的首领。", "擊敗圍攻怒兆寺的首領。", }, 
},
["624"] = {
{ "Defeat the bosses of Old Hillsbrad Foothills", "Bezwingt die Bosse im Vorgebirge des Alten Hügellands.", "Derrota a los jefes de las Antiguas Laderas de Trabalomas.", "Derrota a los jefes de Antiguas Laderas de Trabalomas.", "Terrassez les boss des contreforts de Hautebrande d’antan.", "Sconfiggi i boss del Passato di Colletorto.", "옛 언덕마루 구릉지 우두머리들을 처치해야 합니다.", "Derrote os chefes do Antigo Contraforte de Eira dos Montes", "Победите боссов в старых предгорьях Хилсбрада", "击败旧希尔斯布莱德丘陵的首领", "擊敗希爾斯布萊德丘陵舊址的首領", }, 
},
["724"] = {
{ "Follow the Sergeant", "Folgt dem Unteroffizier", "Sigue al Sargento.", "Sigue al sargento", "Suivez le sergent.", "Segui il Sergente.", "하사관을 따라가야 합니다.", "Siga o Sargento", "Следуйте за сержантом", "追随中士", "跟隨士官", }, 
{ "Defeat the assault", "Wehrt den Angriff ab.", "Derrota a los asaltantes.", "Supera el asalto", "Survivez à l’assaut.", "Respingi l'assalto.", "습격을 막아내야 합니다.", "Derrote os agressores", "Убейте нападающих", "击退突袭的敌人", "擊退襲擊者", }, 
{ "Endure the ogre onslaught.", "Haltet dem Ansturm der Oger stand.", "Resiste el embate de los ogros.", "Aguanta el embate ogro", "Survivez à l’attaque des ogres.", "Resisti al massacro degli Ogre.", "오우거의 공격을 막아내야 합니다.", "Suportar o massacre dos ogros.", "Выдержите атаку огров.", "顶住食人魔的攻击。", "撐過巨魔的攻擊。", }, 
{ "Defeat the remaining Gorian forces.", "Besiegt die verbleibenden Truppen des gorianischen Imperiums.", "Derrota a las fuerzas gorianas restantes.", "Derrota a las fuerzas gorian restantes.", "Terrassez les derniers adversaires goriens.", "Sconfiggi le forze restanti dei Gorian.", "남은 고리안 병력을 물리쳐야 합니다.", "Derrote as forças Gorianas restantes.", "Одержите победу над оставшимися силами горианцев.", "击败高里亚帝国的残余部队。", "擊敗剩下的戈利安部隊。", }, 
{ "Go to the town center.", "Geht zur Ortsmitte.", "Vuelve al centro de la ciudad.", "Ve al centro del pueblo.", "Gagnez le centre-ville.", "Torna al centro del villaggio.", "마을 중앙으로 가야 합니다.", "Vá para o centro da cidade.", "Отправляйтесь в центр гарнизона.", "前往镇中心。", "前往城鎮中心。", }, 
{ "Defeat the Gorian Champion.", "Bezwingt den gorianischen Champion.", "Derrota al campeón goriano.", "Derrota al campeón gorian.", "Terrassez le champion gorien.", "Sconfiggi il campione dei Gorian.", "고리안 용사를 처치해야 합니다.", "Derrote o Campeão Goriano.", "Убейте горианского чемпиона.", "击败高里亚勇士。", "擊敗戈利安勇士", }, 
{ "Bronze: Earn 300 Points", "Bronze: Verdient 300 Punkte.", "Bronce: Gana 300 puntos.", "Bronce: obtén 300 puntos", "Bronze : Obtenir 300 points", "Bronzo: ottieni 300 punti.", "동메달: 300점을 획득해야 합니다.", "Bronze: Obter 300 Pontos", "Бронза: заработайте 300 очков", "青铜：获得300点", "青銅：獲得300分", }, 
{ "Silver: Earn 600 Points", "Silber: Verdient 600 Punkte.", "Plata: Gana 600 puntos.", "Plata: obtén 600 puntos", "Argent : Obtenir 600 points.", "Argento: ottieni 600 punti.", "은메달: 600점을 획득해야 합니다.", "Prata: Obter 600 Pontos", "Серебро: заработайте 600 очков", "白银：获得600点", "白銀：獲得600分", }, 
{ "Gold: Earn 1000 Points", "Gold: Verdient 1000 Punkte.", "Oro: Gana 1000 puntos.", "Oro: obtén 1000 puntos", "Or : Obtenir 1 000 points", "Oro: ottieni 1.000 punti.", "금메달: 1000점을 획득해야 합니다.", "Ouro: Obter 1000 Pontos", "Золото: заработайте 1000 очков", "黄金：获得1000点", "黃金：獲得1000分", }, 
{ "Platinum: Earn 1300 Points", "Platin: Verdient 1300 Punkte.", "Platino: Gana 1300 puntos", "Platino: obtén 1300 puntos", "Platine : Obtenir 1 300 points", "Platino: ottieni 1.300 punti.", "백금메달: 1300점을 획득해야 합니다.", "Platina: Obter 1300 pontos", "Платина: заработайте 1300 очков", "白金：获得1300点", "白金：獲得1300分", }, 
},
["71"] = {
{ "Defend the ship from oncoming Horde.", "Verteidigt das Schiff gegen die anstürmende Horde.", "Defiende el barco de la Horda.", "Defiende el barco de la Horda.", "Défendez le navire contre la Horde.", "Sconfiggi la nave d'assalto dell'Orda.", "호드의 공격으로부터 배를 방어해야 합니다.", "Defenda o navio contra os atacantes da Horda.", "Защитите корабль от войск Орды.", "保护船只免遭部落的侵袭。", "保護船隻不被進攻的部落所傷。", }, 
{ "Defeat the Horde in the harbor.", "Bezwingt die Horde im Hafen.", "Derrota a la Horda en el puerto.", "Derrota a la Horda en el puerto.", "Terrassez la Horde dans le port.", "Sconfiggi le forze dell'Orda al porto.", "항구에 있는 호드를 처치해야 합니다.", "Derrote a Horda no porto.", "Одержите победу над Ордой в гавани.", "击败海港内的部落之敌。", "消滅港口裡的部落成員。", }, 
{ "Fight past the enemy into the heart of ruined Theramore.", "Kämpft Euch durch die Gegner bis zum Herz der Ruinen von Theramore vor.", "Ábrete paso entre el enemigo hasta el corazón de las ruinas de Theramore.", "Ábrete paso entre el enemigo hasta el corazón de las ruinas de Theramore.", "Traversez les lignes ennemies pour pénétrer au cœur des ruines de Theramore.", "Fatti strada tra i nemici nel cuore delle rovine di Theramore.", "폐허가 된 테라모어 중심부에서 적과 싸워 승리해야 합니다.", "Combata os inimigos no seu caminho até chegar ao centro das ruínas de Theramore.", "Прорвитесь на руины Терамора через ряды противника.", "杀开一条血路，深入塞拉摩废墟的核心。", "殺出一條血路，進入已被摧毀的塞拉摩中心。", }, 
{ "Locate Jaina in the Mana Bomb crater.", "Findet Jaina im Krater der Manabombe.", "Localiza a Jaina en el cráter de la bomba de maná.", "Localiza a Jaina en el cráter de la bomba de maná.", "Retrouvez Jaina dans le cratère de la bombe de mana.", "Trova Jaina nel cratere della Bomba di Mana.", "마나 폭탄 분화구에 있는 제이나에게 가야 합니다.", "Encontre Jaina na cratera da bomba de mana.", "Найдите Джайну в кратере мана-бомбы.", "在法力炸弹的弹坑内找到吉安娜。", "到法力炸彈的坑口尋找珍娜。", }, 
{ "Destroy the siege engine at the west gate and recover the stolen standards.", "Zerstört die Belagerungsmaschine am Westtor und holt die gestohlenen Standarten zurück.", "Destruye la máquina de asedio en la puerta oeste y recupera los confalones robados.", "Destruye la máquina de asedio en la puerta oeste y recupera los confalones robados.", "Détruisez l’engin de siège à la porte ouest et récupérez les étendards volés.", "Distruggi la macchina d'assedio alla porta occidentale e recupera gli stendardi rubati.", "서쪽 문에 있는 공성 전차를 파괴하고 도난당한 깃발을 되찾아야 합니다.", "Destrua as máquinas de cerco no portão oeste e recupere os estandartes roubados.", "Уничтожьте осадную машину у западных ворот и найдите украденные штандарты.", "摧毁西边城门的攻城车，并找回失窃的旗帜。", "破壞西門的攻城器械，並且取回失竊的軍旗。", }, 
{ "Protect Jaina while she attunes to the Focusing Iris.", "Beschützt Jaina, während sie sich auf die fokussierende Iris einstimmt.", "Protege a Jaina mientras sintoniza el iris de enfoque.", "Protege a Jaina mientras sintoniza el Iris de enfoque.", "Protégez Jaina pendant qu’elle s’accorde à l’iris de focalisation.", "Proteggi Jaina mentre entra in sintonia con l'Iride Focalizzante.", "제이나가 집중의 눈동자와 동화되는 동안 보호해야 합니다.", "Proteja Jaina enquanto ela harmoniza a Íris Focalizadora.", "Защищайте Джайну, пока она открывает доступ к Радужному Средоточию.", "在吉安娜调校聚焦之虹时保护她。", "保護珍娜，讓她能和聚源虹膜的魔法進行同化。", }, 
},
["653"] = {
{ "Send High Inquisitor Whitemane to her final rest and put an end to the Scarlet Crusade.", "Legt Hochinquisitorin Weißsträhne für immer das Handwerk und macht dem Scharlachroten Kreuzzug ein Ende.", "Acaba de una vez por todas con la alta inquisidora Melenablanca y pon fin a la Cruzada Escarlata.", "Envía a la alta inquisidora Melenablanca a su descanso final y ponle un fin a los Cruzada Escarlata.", "Offrez le repos éternel à la grande inquisitrice Blanchetête et mettez fin à la Croisade écarlate.", "Elimina la Grande Inquisitrice Biancachioma e metti fine alla Crociata Scarlatta.", "종교재판관 화이트메인을 안식에 들게 하여 붉은십자군의 악행에 종지부를 찍어야 합니다.", "Enviar a Alta-inquisidora Cristalba para seu descanso final e dar um fim à Cruzada Escarlate.", "Помогите верховному инквизитору Вайтмейн обрести вечный покой и покончите с Алым орденом.", "让大检察官怀特迈恩安息并消灭血色十字军。", "讓高階審判官懷特邁恩安息，替血色十字軍劃下句點。", }, 
},
["256"] = {
{ "Destroy the abomination that haunts the Black Ox Temple.", "Vernichtet die Monstrosität, die den Tempel des Schwarzen Ochsen heimsucht.", "Destruye la abominación que ronda por el Templo del Buey Negro.", "Destruye la abominación que ronda por el Templo del Buey Negro.", "Détruisez l’abomination qui hante le temple du Buffle noir.", "Distruggi gli abomini che infestano il Tempio dello Yak Nero.", "흑우사에 출몰하는 누더기골렘을 처치해야 합니다.", "Destrua a abominação que assombra o Templo do Boi Negro.", "Уничтожьте чудовище, поселившееся в Храме Черного Быка.", "消灭玄牛寺内的畸体。", "消滅擾亂玄牛寺的魔物。", }, 
},
["572"] = {
{ "Defeat the bosses of the Halls of Reflection", "Besiegt die Bosse in den Hallen der Reflexion.", "Derrota a los jefes de Las Cámaras de Reflexión.", "Derrota a los jefes de Las Cámaras de Reflexión.", "Terrassez les boss de la salle des Reflets.", "Sconfiggi i boss delle Sale dei Riflessi.", "투영의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões da Reflexão", "Победите боссов в Залах Отражений", "击败映像大厅的首领", "擊敗倒影大廳的首領", }, 
},
["557"] = {
{ "Defeat the bosses of the Lost City of the Tol'vir", "Besiegt die Bosse in der Verlorenen Stadt der Tol'vir.", "Derrota a los jefes de la Ciudad Perdida de los Tol'vir.", "Derrota a los jefes de la Ciudad Perdida de los Tol'vir.", "Terrassez les boss de la cité perdue des Tol’vir.", "Sconfiggi i boss della Città Perduta dei Tol'vir.", "톨비르의 잃어버린 도시 우두머리들을 처치해야 합니다.", "Derrote os chefes da Cidade Perdida dos Tol'vir", "Победите боссов в затерянном городе Тол'вире.", "击败托维尔失落之城的首领", "擊敗托維爾的失落之城的首領。", }, 
},
["1298"] = {
{ "Place the Xorothian Calling Stone.", "Platziert den xorothianischen Rufstein.", "Coloca la piedra de llamada de Xoroth.", "Coloca la Piedra de llamada xorothiana.", "Placez la pierre d’appel xorothienne.", "Piazza la Pietra dell'Evocazione Xorotiana.", "소로시안 소환석을 놓습니다.", "Posicione a Pedra de Evocação Zorothiana.", "Активируйте зоротианский камень призыва.", "放置克索诺斯召唤石。", "放置克索諾斯召喚石。", }, 
{ "Hold off Arax'ath's minions.", "Schlagt Arax'aths Schergen zurück.", "Contén a los esbirros de Arax'ath.", "Detén a los esbirros de Arax'ath.", "Repoussez les serviteurs d’Arax’ath.", "Respingi i servitori di Arax'ath.", "아락스아트의 하수인을 막아야 합니다.", "Detenha os lacaios de Arax'ath.", "Сдерживайте прислужников Аракс'ата.", "挡住阿拉萨斯的爪牙。", "擋住亞瑞克薩斯的手下。", }, 
{ "Defeat Arax'ath and enslave the Wrathsteed.", "Besiegt Arax'ath und versklavt das Zornross.", "Derrota a Arax'ath y esclaviza al corcel de cólera.", "Derrota a Arax'ath y captura al corcel iracundo.", "Triomphez d’Arax’ath et domptez le destrier du courroux.", "Sconfiggi Arax'ath e assoggetta il Destriero dell'Ira.", "아락스아트를 처치하고 분노마를 지배해야 합니다.", "Derrote Arax'ath e dome o Corcel Iracundo.", "Одолейте Аракс'ата и подчините себе скакуна гнева.", "击败阿拉萨斯并奴役愤怒战马。", "擊敗亞瑞克薩斯並奴役憤怒戰馬。", }, 
},
["257"] = {
{ "Defeat three champions of Pandaria in a pet battle.", "Bezwingt drei Champions von Pandaria in Haustierkämpfen.", "Derrota a tres campeones de Pandaria en un duelo de mascotas.", "Derrota a tres campeones de Pandaria en un duelo de mascotas.", "Triomphez de trois champions de la Pandarie dans un combat de mascottes.", "Sconfiggi tre campioni di Pandaria in uno scontro tra mascotte.", "판다리아의 용사 셋을 상대로 애완동물 대전에서 승리해야 합니다.", "Derrotar três campeões de Pandária numa batalha de mascotes.", "Победите трех чемпионов Пандарии в битвах питомцев.", "在一场宠物对战中击败三名潘达利亚勇士。", "在寵物對戰中擊敗三名潘達利亞之傑。", }, 
{ "Defeat each of the Celestials in a pet battle.", "Bezwingt jeden der Erhabenen in einem Haustierkampf.", "Derrota a todos los Celestiales en un duelo de mascotas.", "Derrota a todos los Celestiales en un duelo de mascotas.", "Triomphez de chacun des Astres vénérables dans un combat de mascottes.", "Sconfiggi tutti i Venerabili Celestiali in uno scontro tra mascotte.", "각각의 천신을 상대로 애완동물 대전에서 승리해야 합니다.", "Derrotar cada um dos Celestiais numa batalha de mascotes.", "Победите всех Небожителей в битвах питомцев.", "在宠物对战中分别击败四位至尊天神。", "在寵物對戰中擊敗每一名聖獸天尊。", }, 
},
["553"] = {
{ "Defeat the bosses of Grim Batol", "Besiegt die Bosse von Grim Batol.", "Derrota a los jefes de Grim Batol.", "Derrota a los jefes de Grim Batol.", "Terrassez les boss de Grim Batol.", "Sconfiggi i boss di Grim Batol.", "그림 바톨 우두머리들을 처치해야 합니다.", "Derrote os chefes de Grim Batol", "Победите боссов в Грим Батоле", "击败格瑞姆巴托的首领", "擊敗格瑞姆巴托的首領", }, 
},
["679"] = {
{ "Root out the corruption within Auchindoun.", "Beseitigt die Verderbnis in Auchindoun.", "Acaba con la corrupción en Auchindoun.", "Erradica la corrupción en Auchindoun.", "Débarrassez Auchindoun de la corruption.", "Sradica la corruzione all'interno di Auchindoun.", "아킨둔 안의 타락을 뿌리 뽑아야 합니다.", "Elimine a corrupção em Auchindoun.", "Искорените скверну в Аукиндоне.", "铲除奥金顿中的腐败。", "根除奧齊頓裡的腐化勢力。", }, 
},
["579"] = {
{ "Defeat the bosses of Utgarde Pinnacle.", "Besiegt die Bosse in Turm Utgarde.", "Derrota a los jefes de Pináculo de Utgarde.", "Derrota a los jefes del Pináculo de Utgarde.", "Terrassez les boss de la cime d’Utgarde.", "Sconfiggi i boss del Pinnacolo di Utgarde.", "우트가드 첨탑 우두머리들을 처치해야 합니다.", "Derrote os chefes do Pináculo Utgarde.", "Победите боссов на Вершине Утгард.", "击败乌特加德之巅的首领。", "擊敗俄特加德之巔的首領。", }, 
},
["179"] = {
{ "Speak with Vol'jin to begin the search for the Saurok cave.", "Sprecht mit Vol'jin, um die Suche nach der Saurokhöhle zu beginnen.", "Habla con Vol'jin para empezar la búsqueda de la cueva saurok.", "Habla con Vol'jin para empezar la búsqueda de la cueva saurok.", "Parlez à Vol’jin pour vous mettre à la recherche de la caverne des sauroks.", "Parla con Vol'jin per iniziare l'esplorazione della Caverna dei Saurok.", "볼진과 대화해 사우록 동굴 조사를 시작해야 합니다.", "Fale com Vol'jin para começar a busca pela caverna Saurok.", "Поговорите с Вол'джином, чтобы приступить к поискам пещеры сауроков.", "与沃金交谈并开始搜索蜥蜴人洞穴。", "與沃金交談來開始尋找薩烏洛克洞穴。", }, 
{ "Find the entrance to the Saurok Cave.", "Findet den Eingang zur Saurokhöhle", "Encuentra la entrada de la cueva saurok.", "Encuentra la entrada de la cueva saurok.", "Trouvez l’entrée de la caverne des sauroks.", "Trova l'ingresso della Caverna dei Saurok.", "사우록 동굴 입구를 찾아야 합니다.", "Encontre a entrada da Caverna Saurok.", "Найдите вход в пещеру сауроков.", "找到蜥蜴人洞穴的入口。", "尋找薩烏洛克洞穴的入口。", }, 
{ "Defeat the Saurok guarding the cave.", "Besiegt die Saurok, die die Höhle bewachen.", "Derrota a los saurok que vigilan la cueva.", "Derrota a los saurok que vigilan la cueva.", "Terrassez les sauroks qui gardent la caverne.", "Sconfiggi i Saurok che fanno la guardia alla caverna.", "동굴을 지키는 사우록을 처치해야 합니다.", "Derrote o Saurok que vigia a caverna.", "Победите сауроков, охраняющих пещеру.", "击败守卫洞穴的蜥蜴人。", "打敗看守洞穴的薩烏洛克。", }, 
{ "Make your way deeper into the cave.", "Dringt tiefer in die Höhle vor.", "Ábrete paso hasta el fondo de la cueva.", "Ábrete paso hasta el fondo de la cueva.", "Enfoncez-vous dans les profondeurs de la grotte.", "Addentrati nel cuore della caverna.", "동굴 깊숙한 곳으로 가야 합니다.", "Vá até o ponto mais profundo da caverna.", "Проникните вглубь пещеры.", "深入洞穴。", "進入洞穴的更深處。", }, 
{ "Find the source of the Saurok.", "Findet heraus, woher die Saurok stammen.", "Descubre el origen de los saurok.", "Descubre el origen de los saurok.", "Découvrir d’où viennent les sauroks.", "Scopri l'origine dei Saurok.", "사우록의 근원을 찾아야 합니다.", "Encontre a fonte dos sauroks.", "Найдите источник происхождения сауроков.", "找到蜥蜴人的源头。", "找出薩烏洛克的來源。", }, 
{ "Defeat Broodmaster Noshi.", "Bezwingt Brutmeister Noshi.", "Derrota al maestro de linaje Noshi.", "Derrota al maestro de linaje Noshi.", "Terrassez le maître des couvées Noshi.", "Sconfiggi il Maestro della Progenie Noshi.", "무리두목 노쉬를 처치해야 합니다.", "Derrote a Prolemestre Noshi.", "Победите праматерь Ноши.", "击败孵化大师诺什。", "打敗育主諾許。", }, 
{ "Investigate the Mogu Statues.", "Untersucht die Mogustatuen.", "Investiga las estatuas mogu.", "Investiga las estatuas mogu.", "Examinez les statues mogu.", "Esamina le statue dei Mogu.", "모구 석상을 조사해야 합니다.", "Investigue as Estátuas Mogus.", "Осмотрите статуи могу.", "调查魔古雕像。", "調查魔古雕像。", }, 
{ "Fend off the Kor'kron ambush.", "Wehrt den Angriff der Kor'kron ab.", "Esquiva la emboscada Kor'kron.", "Esquiva la emboscada Kor'kron.", "Repoussez l’embuscade kor’kronne.", "Respingi l'imboscata dei Kor'kron.", "코르크론 군대의 기습을 막아야 합니다.", "Rechace a Emboscada Kor'kron.", "Отразите кор'кронское нападение.", "抵挡库卡隆的伏击。", "擊退柯爾克隆的突襲。", }, 
},
["1146"] = {
{ "Ascend into the gates of Niskara.", "Betretet das Tor von Niskara.", "Asciende a las puertas de Niskara.", "Sube a las puertas de Niskara.", "Atteindre les portes de Niskara.", "Attraversa i cancelli di Niskara.", "니스카라 관문으로 올라가야 합니다.", "Suba aos portões de Niskara.", "Поднимитесь к вратам Нискары.", "进入尼斯卡拉的大门。", "進入通往尼斯卡拉的傳送門。", }, 
{ "Leap on Felbats and defeat their riders.", "Springt auf Teufelsfledermäuse und bezwingt ihre Reiter.", "Salta sobre los murciélagos viles y derrota a sus jinetes.", "Salta sobre los murciélagos viles y derrota a sus jinetes.", "Sautez sur des gangroptères et terrassez leurs cavaliers.", "Salta in groppa ai vilpipistrelli per sconfiggere i cavalieri.", "지옥박쥐에 올라탄 후 기수를 처치해야 합니다.", "Salte nos Morcevis e derrote seus cavalgantes.", "Запрыгивайте на сквернотопырей и расправляйтесь с их наездниками.", "跳上魔蝠，击败骑手。", "跳上魔化蝙蝠並且擊敗那些騎士。", }, 
{ "Dive near Thorim.", "Macht einen Sturzflug in der Nähe von Thorim.", "Desciende cerca de Thorim.", "Aparécete junto a Thorim.", "Plongez près de Thorim.", "Atterra vicino a Thorim.", "토림 근처로 강하해야 합니다.", "Mergulhe ao lado de Thorim.", "Спикируйте к Ториму.", "来到托里姆附近。", "落到索林姆身旁。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "Slay the Hateful Corruptors and rescue Hodir.", "Tötet die hasserfüllten Verderber und rettet Hodir.", "Aniquila a los corruptores odiosos y rescata a Hodir.", "Asesina a los aborrecibles corruptores y rescata a Hodir.", "Éliminez les corrupteurs haineux et secourez Hodir.", "Uccidi i Corruttori Perfidi e salva Hodir.", "혐오스러운 타락자를 처치하고 호디르를 구출해야 합니다.", "Mate os Corruptores Odiosos e resgate Hodir.", "Убейте злобных осквернителей и спасите Ходира.", "消灭可憎的腐蚀者，救下霍迪尔。", "殺死仇恨腐化者以解救霍迪爾。", }, 
{ "Hodir has been overcome by fel energies and must be stopped.", "Hodir wurde von Teufelsenergien vereinnahmt und muss aufgehalten werden.", "Hodir está poseído por energías viles y hay que detenerlo.", "Hodir fue poseído por energías viles y debe ser detenido.", "Hodir a succombé aux énergies gangrenées, il faut l’empêcher de nuire.", "Hodir è stato sopraffatto dalle energie vili e deve essere fermato.", "호디르는 지옥 마력에 완전히 잠식당했습니다. 어쩔 수 없이 그를 처치해야 합니다.", "Hodir foi dominado por energias vis e deve ser detido.", "Ходир попал под влияние энергии Скверны, и его нужно остановить.", "霍迪尔已经被邪能控制，必须阻止他。", "霍迪爾遭魔化能量吞噬，一定要阻止他。", }, 
},
["1124"] = {
{ "You have successfully pierced the holy barriers protecting the Black Temple. Confer with Altruis the Sufferer and prepare to confront Akama.", "Ihr habt die heiligen Barrieren, die den Schwarzen Tempel schützen, erfolgreich durchbrochen. Beratet Euch mit Altruis dem Leidenden und bereitet Euch auf die Konfrontation mit Akama vor.", "Has conseguido penetrar las barreras benditas que protegen el Templo Oscuro. Consulta con Altruis el Sufridor y prepárate para enfrentarte a Akama.", "Lograste atravesar las barreras sagradas que protegen el Templo Oscuro. Ve a hablar con Altruis el Sufridor y prepárate para enfrentarte a Akama.", "Vous avez réussi à percer les barrières sacrées protégeant le Temple noir. Discutez avec Altruis le Souffrant et préparez-vous à affronter Akama.", "Hai penetrato con successo le barriere sacre a protezione del Tempio Nero. Parla con Altruis il Sofferente e affronta Akama.", "드디어 검은 사원을 보호하는 신성한 방벽을 뚫었습니다. 고뇌의 알트루이스와 의논하여 아카마와의 대면을 준비해야 합니다.", "Você conseguiu atravessar as barreiras sagradas que protegem o Templo Negro. Consulte Altruis, o Sofredor, e prepare-se para enfrentar Akama.", "Вы преодолели барьеры Света, защищающие Черный храм. Поговорите с Алтруисом и приготовьтесь встретиться с Акамой.", "你成功穿透了保护着黑暗神殿的神圣屏障。和受难者奥图里斯谈谈，准备和阿卡玛对峙。", "你成功穿過保護黑暗神廟的神聖屏障。跟『受難者』奧翠司商討，準備對抗阿卡瑪。", }, 
{ "The gates to the Temple Summit proper are closed. Akama is on the other side. Have your Illidari force a way in.", "Die Tore zur Tempelspitze sind fest verschlossen. Akama befindet sich auf der anderen Seite. Eure Illidari sollen sich gewaltsam Zutritt verschaffen.", "Las puertas de la Cima del Templo propiamente dicha están cerradas. Akama está al otro lado. Haz que tus Illidari encuentren el modo de entrar.", "Las puertas de la Cima del Templo están cerradas. Akama está del otro lado. Haz que tus Illidari entren por la fuerza.", "Les portes menant au sommet du temple sont fermées. Akama se trouve de l’autre côté. Dites à vos Illidari de forcer le passage.", "I cancelli della Sommità del Tempio sono chiusi e Akama è dall'altra parte. Ordina ai tuoi Illidari di farsi strada all'interno.", "사원 정상으로 가는 관문이 닫혀있습니다. 아카마는 관문 너머에 있습니다. 일리다리 군대를 앞세워 길을 뚫어야 합니다.", "Os portões do Ápice do Templo estão fechados. Akama encontra-se do outro lado. Faça com que seus Illidari providenciem uma entrada.", "Врата на Храмовую вершину закрыты. Акама по другую сторону. Пусть иллидари расчистят путь.", "通往神殿之巅的大门完全关闭了。阿卡玛在门里面。让你的伊利达雷强行突入。", "前往神廟頂層的大門關住了。阿卡瑪就在另一邊。命你的伊利達瑞強行突破。", }, 
{ "Enter the Temple Summit and confront Akama. Convince him to join you in taking the fight to the Burning Legion's worlds.", "Betretet die Tempelspitze und stellt Akama zur Rede. Überzeugt ihn, den Kampf gegen die Brennende Legion mit Euch in ihre Welten zu bringen.", "Entra en la Cima del Templo y enfréntate a Akama. Convéncelo de que se una a tu lucha en los mundos de la Legión Ardiente.", "Entra a la Cima del Templo y confróntalo a Akama. Convéncelo de que te ayude a llevar la guerra a los mundos de la Legión Ardiente.", "Accédez au sommet du temple et affrontez Akama. Persuadez-le d’attaquer avec vous les mondes de la Légion ardente.", "Raggiungi la Sommità del Tempio e affronta Akama. Convincilo a unirsi a te nella battaglia contro la Legione Infuocata.", "사원 정상으로 올라가 아카마와 대면해야 합니다. 그리고 불타는 군단의 세계를 함께 침공하자고 설득해야 합니다.", "Entre no Ápice do Templo e confronte Akama. Convença-o a unir forçar e levar o combate ao mundo da Legião Ardente.", "Взойдите на Храмовую вершину и сразитесь с Акамой. Убедите его принять вашу сторону и атаковать миры Пылающего Легиона.", "进入神殿之巅，与阿卡玛对峙。说服他加入你的队伍，并肩抵抗燃烧军团。", "進入神廟頂層，挑戰阿卡瑪。試圖說服他加入你的部隊，共同朝燃燒軍團的世界進攻。", }, 
{ "Akama will not be persuaded by words. Perhaps force will do the trick. But, how to win and not lose in doing so?", "Akama wird sich nicht durch Worte überzeugen lassen. Vielleicht hilft etwas Zwang. Doch wie soll man dabei gewinnen und nicht verlieren?", "Akama no se deja persuadir con palabras. Quizás la fuerza funcione. Pero ¿cómo ganar y no perder al mismo tiempo?", "Akama no se dejará llevar por palabras. Quizás la fuerza sea la clave. Sin embargo, no será fácil ganar sin perder al mismo tiempo.", "Il faudra plus que des mots pour convaincre Akama. La force fera peut-être l’affaire. Mais comment l’emporter sans risquer de tout perdre ?", "Akama non sarà persuaso da semplici parole, quindi sarà necessaria un po' di forza. Ma come possiamo essere sicuri che sia la strada giusta da seguire?", "아카마를 말로 설득할 수는 없을 겁니다. 강한 힘을 보여주는 편이 나을지 모릅니다. 어떻게 제압해야 가장 피해가 적을까요?", "Palavras não convencerão Akama. Usar a força talvez resolva. Mas como não ser derrotado no processo?", "Словами Акаму не убедить. Может быть, это удастся сделать силой. Но как одолеть столь серьезного противника?", "言辞无法说服阿卡玛。也许要用武力强迫才行。但是即使使用武力，又要怎样才能让他就范，而不会落得双输的局面呢？", "單用說的無法說服阿卡瑪。或許要用力量威逼才行。不過，要怎麼確保我們獲得勝利卻不會失去重要的助力？", }, 
{ "Akama is defeated. Speak with him and convince him to join you.", "Akama wurde besiegt. Sprecht mit ihm und überzeugt ihn davon, sich Euch anzuschließen.", "Akama ha sido derrotado. Habla con él y convéncelo de que se te una.", "Akama está derrotado. Habla con él y convéncelo de que se te una.", "Akama est vaincu. Parlez-lui pour le convaincre de se rallier à vous.", "Akama è sconfitto. Parla con lui e convincilo a unirsi a te.", "아카마를 제압했습니다. 이제 그와 대화하여 힘을 빌려달라고 설득해야 합니다.", "Akama está derrotado. Convença-o a ser seu aliado.", "Акама побежден. Поговорите с ним и убедите принять вашу сторону.", "阿卡玛被击败了。和他谈谈，说服他加入你。", "擊敗阿卡瑪了。跟他說話，說服他加入你。", }, 
},
["972"] = {
{ "Survey the rise ahead and eliminate Legion patrols.", "Späht die Anhöhe vor Euch aus und beseitigt Patrouillen der Legion.", "Explora la elevación y elimina a las patrullas de la Legión.", "Estudia la colina más adelante y elimina a las patrullas de la Legión.", "Inspectez le talus droit devant et éliminez les patrouilles de la Légion.", "Esamina l'altura più avanti ed elimina le pattuglie della Legione.", "전방의 오르막길을 조사하고 군단 순찰대를 처치해야 합니다.", "Faça reconhecimento da colina adiante e elimine as patrulhas da Legião.", "Разведайте возвышенность, что лежит перед вами, и ликвидируйте патрули демонов.", "调查前方的高地，消灭军团的巡逻队。", "勘察前方的高地並消滅燃燒軍團的巡邏兵。", }, 
{ "Defeat the eredar summoners before they bring in more demons.", "Bezwingt die Beschwörer der Eredar, bevor sie mehr Dämonen herbeiholen.", "Derrota a los invocadores eredar antes de que traigan más demonios.", "Derrota a los invocadores eredar antes de que llamen a más demonios.", "Terrassez les invocateurs érédars avant qu’ils n’appellent d’autres démons.", "Sconfiggi gli Evocatori Eredar prima che evochino altri demoni.", "에레다르 소환사가 악마를 더 소환하기 전에 처치해야 합니다.", "Derrote os evocadores eredares antes que eles tragam mais demônios.", "Победите эредарских призывателей, пока они не успели призвать новых демонов.", "击败艾瑞达召唤者，以免他们召唤出更多的恶魔。", "擊敗埃雷達爾召喚師，別讓他們召喚更多惡魔。", }, 
{ "Go deeper into Legion territory to locate Alleria and Orestes.", "Stoßt tiefer in das Territorium der Legion vor und sucht nach Alleria und Orestes.", "Adéntrate más en el territorio de la Legión para encontrar a Alleria y Orestes.", "Adéntrate en el territorio de la Legión y localiza a Alleria y Orestes.", "Enfoncez-vous dans le territoire de la Légion pour trouver Alleria et Oreste.", "Addentrati nel territorio della Legione e trova Alleria e Oreste.", "군단 영토 깊숙이 들어가 알레리아와 오레스테스를 찾아야 합니다.", "Vá mais fundo no território da Legião para encontrar Alleria e Orestes.", "Отправляйтесь вглубь территории Легиона и попытайтесь отыскать Аллерию и Ореста.", "深入军团的领地，找到奥蕾莉亚和俄瑞斯忒斯。", "深入燃燒軍團的領地，找出艾蘭里亞和歐瑞斯提的下落。", }, 
{ "Slay Mistress Torvis and save Orestes.", "Tötet Herrin Torvis und rettet Orestes.", "Mata a la maestra Torvis y salva a Orestes.", "Mata a la señora Torvis y salva a Orestes.", "Tuez la maîtresse Torvis et sauvez Oreste.", "Uccidi la Signora Torvis e salva Oreste.", "여조련사 토르비스를 처치하고 오레스테스를 구해야 합니다.", "Mate a Senhora Torvis e salve Orestes.", "Убейте госпожу Торвис и спасите Ореста.", "消灭托维斯夫人并解救俄瑞斯忒斯。", "殺死托薇絲女士並拯救歐瑞斯提。", }, 
{ "Enter the cathedral and defeat Herald Xarbizuld.", "Betretet die Kathedrale und bezwingt Herold Xarbizuld.", "Entra en la catedral y derrota al heraldo Xarbizuld.", "Entra a la catedral y derrota al Heraldo Xarbizuld.", "Entrer dans la cathédrale et vaincre le héraut Xarbizuld", "Entra nella cattedrale e sconfiggi l'Alfiere Xarbizuld.", "대성당에 들어가서 전령 자르비줄드를 처치해야 합니다.", "Entre na catedral e derrote o Arauto Xarbizuld.", "Войдите в собор и победите глашатая Зарбизульда.", "进入城堡，击败使徒扎比祖德。", "進入大教堂並擊敗信使薩比祖德。", }, 
{ "Defeat High Inquisitor Qormaladon and his guardian eyes.", "Bezwingt Hochinquisitor Qormaladon und seine Wächteraugen.", "Derrota al alto inquisidor Qormaladon y a sus ojos guardianes.", "Deerrota al Alto Inquisidor Qormaladon y a sus ojos guardianes.", "Terrassez le grand inquisiteur Qormaladon et ses yeux gardiens.", "Sconfiggi il Gran Inquisitore Qormaladon e i suoi occhi guardiani.", "심문관 코르말라돈과 감시자 눈알들을 처치해야 합니다.", "Derrote o Alto-inquisidor Qormaladon e seus olhos guardiões.", "Победите верховного инквизитора Кормаладона и его глаза-стражи.", "击败大审判官奎玛拉顿和他的守护之眼。", "擊敗高階審判官奎瑪拉敦和他的守護者之眼。", }, 
{ "Help Vereesa search the Inquisitor's overlook for Alleria.", "Helft Vereesa, die Warte des Inquisitors nach Alleria abzusuchen.", "Ayuda a Vereesa a buscar a Alleria en el mirador del inquisidor.", "Ayuda a Vereesa a buscar el Mirador del inquisidor para Alleria.", "Aider Vereesa à chercher Alleria au surplomb de l’inquisiteur", "Aiuta Vereesa a cercare Alleria presso l'osservatorio dell'Inquisitore.", "베리사를 도와 심문관의 전망대에서 알레리아를 찾아야 합니다.", "Ajude Vereesa a vasculhar o mirante do Inquisidor em busca de Alleria.", "Помогите Верисе осмотреть логово инквизитора в поисках Аллерии.", "帮助温蕾萨搜索审判官的看台，寻找奥蕾莉亚的踪迹。", "幫凡蕾莎搜索審判官的瞰臺，尋找艾蘭里亞的蹤影。", }, 
{ "Wield Thas'dorah, Legacy of the Windrunners.", "Rüstet Euch mit Thas'dorah, Erbstück von Haus Windläufer aus.", "Blande a Thas'dorah, Legado de los Brisaveloz.", "Empuña a Thas'dorah, el Legado de los Brisaveloz.", "Emparez-vous de Thas’dorah, héritage des Coursevent.", "Impugna Thas'dorah, Eredità dei Ventolesto.", "타스도라 - 윈드러너의 유산을 손에 넣어야 합니다.", "Empunhe Thas'dorah, Legado dos Correventos.", "Возьмите в руки Тас'дору, наследие Ветрокрылых.", "获得萨斯多拉，风行者的遗产", "裝備薩斯朵拉，風行者之遺。", }, 
},
["1254"] = {
{ "Enter the Eye of Azshara and stop the Wrath of Azshara from being unleashed upon the Broken Isles.", "Begebt Euch in das Auge Azsharas und verhindert, dass Azsharas Zorn auf die Verheerten Inseln entfesselt wird.", "Entra en el Ojo de Azshara y evita que la Cólera de Azshara se desate sobre las Islas Abruptas.", "Entra al Ojo de Azshara y evita que la Cólera de Azshara se desate sobre las Islas Quebradas.", "Entrez dans l’Œil d’Azshara et empêchez le Courroux d’Azshara de se déchaîner sur les îles Brisées.", "Entra nell'Occhio di Azshara e impedisci che l'Ira di Azshara venga scatenata sulle Isole Disperse.", "아즈샤라의 눈으로 들어간 다음, 아즈샤라의 분노가 부서진 섬을 파괴하기 전에 막아야 합니다.", "Entre no Olho de Azshara e impeça que a Ira de Azshara seja liberada sobre as Ilhas Partidas.", "Войдите в Око Азшары и остановите Гнев Азшары, пока он не обрушился на Расколотые острова.", "进入艾萨拉之眼，阻止艾萨拉之怒席卷整个破碎群岛。", "前往艾薩拉之眼，阻止艾薩拉之怒力量釋放席捲破碎群島。", }, 
},
["1135"] = {
{ "Repel the legion invasion by closing their portals and sending them back to the twisting nether.", "Wehrt die Legionsinvasion ab, indem Ihr ihre Portale schließt und sie in den Wirbelnden Nether zurückschleudert.", "Repele la invasión de la Legión cerrando sus portales y mandando a sus fuerzas de vuelta a El Vacío Abisal.", "Repele la invasión de la Legión. Para ello, cierra sus portales y envíalos de vuelta al Vacío Abisal.", "Repoussez l’invasion de la Légion en fermant ses portails et en renvoyant ses troupes dans le Néant distordu.", "Respingi l'invasione della Legione chiudendo i suoi portali e rimandandola nella Distorsione Fatua.", "악마를 뒤틀린 황천으로 돌려보내고 차원문을 닫아 군단 침공을 저지해야 합니다.", "Feche os portais para conter a invasão e enviar a Legião de volta à espiral etérea.", "Остановите вторжение Легиона, закрывая порталы и отправляя демонов обратно в Круговерть Пустоты.", "关闭军团的传送门，并将它们送回扭曲虚空，从而击退军团的入侵。", "關閉燃燒軍團的傳送門並把他們打回扭曲虛空，藉此阻止軍團入侵。", }, 
{ "Use an arcane portal to travel to the center Band of Transmutation", "Benutzt ein arkanes Portal, um Euch zum zentralen Ring der Transmutation zu begeben.", "Usa un portal Arcano para viajar al Anillo de Transmutación central.", "Utiliza el Portal Arcano para viajar al Anillo de Transmutación central.", "Utilisez un portail des Arcanes pour vous rendre au centre de la bague de transmutation.", "Usa un portale arcano per raggiungere il centro dell'Anello della Trasmutazione.", "비전 차원문을 사용하여 변환의 고리 중앙으로 이동해야 합니다.", "Use um portal arcano para chegar à Faixa de Transmutação central", "С помощью чародейского портала отправляйтесь в центр Кольца трансмутации.", "使用奥术传送门前往转化之环的中心处。", "使用秘法傳送門前往轉化之環的中心。", }, 
{ "Defeat the three legion magi imprisoning Archmage Vargoth.", "Besiegt die drei Legionsmagier, die Erzmagier Vargoth gefangen halten.", "Derrota a los tres magos de la Legión encerrando al archimago Vargoth.", "Derrota a los tres magos de la Legión que tienen preso al Archimago Vargoth.", "Terrassez les trois mages de la Légion qui retiennent l’archimage Vargoth.", "Sconfiggi i tre Maghi della Legione che tengono imprigionato l'Arcimago Vargoth.", "대마법사 바르고스를 구속하고 있는 군단 마법사 세 명을 처치해야 합니다.", "Derrote os três magos da legião que estão mantendo o Arquimago Vargoth preso.", "Победите трех магов Легиона, которые держат в заточении верховного мага Варгота.", "击败3个囚禁大法师瓦格斯的军团魔法师。", "擊敗三名囚禁大法師瓦戈斯的燃燒軍團魔導師。", }, 
{ "Talk to Archmage Vargoth", "Sprecht mit Erzmagier Vargoth.", "Habla con el archimago Vargoth.", "Habla con el Archimago Vargoth", "Parlez à l’archimage Vargoth.", "Parla con l'Arcimago Vargoth.", "대마법사 바르고스와 대화해야 합니다.", "Fale com Arquimago Vargoth", "Поговорите с верховным магом Варготом.", "和大法师瓦格斯谈谈。", "跟大法師瓦戈斯談話。", }, 
{ "Talk to Archmage Vargoth to teleport to ground level", "Sprecht mit Erzmagier Vargoth, um Euch zum Boden zu teleportieren.", "Habla con el archimago Vargoth para teletransportarte al nivel del suelo.", "Habla con el Archimago Vargoth para teletransportarte al nivel del suelo.", "Parlez à l’archimage Vargoth pour vous téléporter au rez-de-chaussée.", "Parla con l'Arcimago Vargoth per teletrasportarti al piano terra.", "대마법사 바르고스와 대화하여 지상으로 순간이동해야 합니다.", "Fale com Arquimago Vargoth para ser teleportado para o nível do solo", "Поговорите с верховным магом Варготом, чтобы телепортироваться на нижний ярус.", "和大法师瓦格斯谈谈，传送到地面。", "跟大法師瓦戈斯交談，傳送到地面。", }, 
{ "Find a way into the Nexus building", "Findet einen Weg in das Nexusgebäude.", "Encuentra una forma de entrar en el edificio de El Nexo", "Encuentra una forma de entrar al edificio del Nexo.", "Trouvez un moyen d’entrer dans le bâtiment du Nexus.", "Trova un modo per entrare nel Nexus.", "마력의 탑에 들어갈 방법을 찾아야 합니다.", "Encontre uma entrada para o Nexus", "Найдите способ пробраться в Нексус", "找到进入魔枢建筑的路。", "設法進入奧核的建築內。", }, 
{ "Defeat Kathra'natir by imprisoning him inside the Nightborne Soulstone", "Besiegt Kathra'natir, indem Ihr ihn in einem Seelenstein der Nachtgeborenen einfangt.", "Derrota a Kathra'natir encerrándolo en la piedra de alma Nocheterna.", "Derrota a Kathra'natir y encarcélalo dentro de la piedra de alma de la Pesadilla.", "Venez à bout de Kathra’natir en l’emprisonnant dans la pierre d’âme sacrenuit.", "Sconfiggi Kathra'natir imprigionandolo all'interno della Pietra dell'Anima dei Nobili Oscuri.", "나이트본 영혼석에 카트라나티르를 가두어 그를 물리쳐야 합니다.", "Para derrotar Kathra'natir, aprisione-o na Pedra da Alma dos Filhos da Noite", "Одолейте Катра'натира, пленив его в камне души ночнорожденных.", "击败卡萨纳提尔，将其囚禁在夜之子灵魂石中。", "把卡斯拉納提爾囚禁在夜裔靈魂石中以將其擊敗。", }, 
},
["556"] = {
{ "Incur the wrath of Jin'do the Godbreaker.", "Beschwört den Zorn von Jin'do dem Götterbrecher herauf.", "Provoca la ira de Jin'do el Sojuzgadioses.", "Despierta la ira de Jin'do el Sojuzgadioses.", "S’attirer le courroux de Jin’do le Briseur de dieux.", "Incorri nell'ira di Jin'do l'Annientadei.", "신파괴자 진도가 분노하게 만들어야 합니다.", "Provoque a ira de Jin'do, o Doma-deus.", "Навлеките на себя гнев Джин'до Низвергателя Богов.", "引发碎神者金度的怒火。", "引發破神者金度的憤怒", }, 
{ "Defeat Jin'do the Godbreaker.", "Besiegt Jin'do den Götterbrecher.", "Derrota a Jin'do el Sojuzgadioses.", "Derrota a Jin'do el Sojuzgadioses.", "Terrassez Jin’do le Briseur de dieux.", "Sconfiggi Jin'do l'Annientadei.", "신파괴자 진도를 처치해야 합니다.", "Derrote Jin'do, o Doma-deus.", "Победите Джин'до Низвергателя Богов.", "击败碎神者金度。", "擊敗破神者金度。", }, 
{ "Defeat the bosses of Zul'Gurub.", "Besiegt die Bosse von Zul'Gurub.", "Derrota a los jefes de Zul'Gurub.", "Derrota a los jefes de Zul'Gurub.", "Terrassez les boss de Zul’Gurub.", "Sconfiggi i boss di Zul'Gurub.", "줄구룹 우두머리들을 처치해야 합니다.", "Derrote os chefes de Zul'Gurub.", "Победите боссов в Зул'Гурубе.", "击败祖尔格拉布的首领。", "擊敗祖爾格拉布的首領。", }, 
{ "Complete the Edge of Madness event in Zul'Gurub.", "Schließt das Ereignis Rand des Wahnsinns in Zul'Gurub ab.", "Completa el evento de Cabo de la Locura en Zul'Gurub.", "Termina el evento de Cabo de la Locura en Zul'Gurub.", "Terminer l’évènement « la frontière de la folie » à Zul’Gurub.", "Completa l'evento Orlo della Follia a Zul'Gurub.", "줄구룹 안의 광란의 경계 이벤트를 완료해야 합니다.", "Complete o eventos Beira da Loucura em Zul'Gurub.", "Завершите событие \"Грань Безумия\" в Зул'Гурубе.", "完成祖尔格拉布的疯狂之缘事件。", "完成祖爾格拉布的瘋狂之緣事件。", }, 
},
["70"] = {
{ "[PH] Defeat the three masters.", "Bezwingt die drei Meister.", "[PH] Defeat the three masters.", "[PH] Defeat the three masters.", "Terrassez les trois maîtres.", "[PH] Sconfiggi i tre maestri.", "[PH] 사부를 처치해야 합니다.", "[PH] Derrote os três mestres.", "[PH] Defeat the three masters.", "[PH]击败三位大师。", "[PH] Defeat the three masters.", }, 
},
["40"] = {
{ "Defeat the monsters attacking the Greenstone villagers.", "Bezwingt die Monster, die die Dorfbewohner von Grünstein angreifen.", "Derrota a los monstruos que atacan a los habitantes de Verdemar.", "Derrota a los monstruos que atacan a los habitantes de Verdemar.", "Terrassez les monstres qui attaquent les villageois de Pierre-Verte.", "Sconfiggi i mostri che attaccano gli abitanti di Pietraverde.", "녹옥 마을을 공격하는 괴물들을 처치해야 합니다.", "Derrote os monstros que estão atacando os aldeões da Rocha Verde.", "Одолейте монстров, атакующих жителей деревни Зеленой Скалы.", "击败那些攻击绿石村民的怪物。", "消滅攻擊綠石村村民的怪物。", }, 
{ "Defeat the monsters attacking Greenstone's dojo.", "Bezwingt die Monster, die den Dojo von Grünstein angreifen.", "Derrota a los monstruos que están atacando el dojo de Verdemar.", "Derrota a los monstruos que están atacando el dojo de Verdemar.", "Terrassez les monstres qui attaquent le dojo de Pierre-Verte.", "Sconfiggi i mostri che attaccano il Dojo di Pietraverde.", "녹옥 도장을 공격하는 몬스터를 처치해야 합니다.", "Derrote os monstros que estão atacando o dojo da Rocha Verde.", "Уничтожьте монстров, атакующих додзё Зеленой Скалы.", "击败围攻绿石道场的怪物。", "擊敗攻擊綠石道場的怪物。", }, 
{ "Find burgled brew barrels in the forest and return them to the village dojo.", "Findet gestohlene Braufässer im Wald und bringt sie zum Dojo des Dorfes zurück.", "Encuentra los barriles robados en el bosque y devuélveselos al dojo de la aldea.", "Encuentra los barriles robados en el bosque y devuélveselos al dojo de la aldea.", "Trouvez les barils de bière volée dans la forêt et rapportez-les au dojo du village.", "Trova i barili di Birra Rubata nella foresta e riportali al dojo del villaggio.", "숲에서 서리당한 맥주통을 찾은 뒤 마을에 있는 도장으로 가져와야 합니다.", "Encontre os barris de cerveja roubados na floresta e devolva-os ao dojo da aldeia.", "Найдите в лесу украденные бочонки и верните их в додзё деревни.", "从森林里找回失窃的酒桶，并将它们送回村里的道场。", "在森林尋找遭竊的酒桶，然後送回村莊的道場。", }, 
{ "Travel to the Masons' Quarter and awaken the unconscious villagers.", "Reist zum Steinmetzviertel und weckt die bewusstlosen Dorfbewohner auf.", "Viaja al Barrio de Canteros y despierta a los aldeanos inconscientes.", "Viaja al Barrio de Canteros y despierta a los aldeanos inconscientes.", "Rendez-vous dans le quartier des Maçons et réveillez les villageois inconscients.", "Raggiungi il Quartiere dei Muratori e risveglia gli abitanti incoscienti.", "녹옥 석공의 집으로 가서 의식불명의 주민을 깨워야 합니다.", "Viaje até o Distrito dos Pedreiros e desperte os aldeões inconscientes.", "Отправьтесь в Поселок Каменщиков и приведите в сознание жителей.", "前往绿石工匠区并唤醒失去意识的村民。", "前往石匠區，喚醒昏迷的村民。", }, 
{ "Defeat Vengeful Hui.", "Bezwingt den rachsüchtigen Hui.", "Derrota a Hui el Vengativo.", "Derrota a Hui el Vengativo.", "Terrassez Hui le Vengeur.", "Sconfiggi Hui il Vendicativo.", "복수심에 불타는 후이를 처치해야 합니다.", "Derrote Hui Vingativo.", "Одолейте Мстительного Хуэя.", "击败仇灰。", "殺死復仇之穢。", }, 
},
["50"] = {
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["978"] = {
{ "Defeat the forces of Xavius at the base of Shaladrassil.", "Bezwingt die Streitmacht von Xavius an den Wurzeln von Shaladrassil.", "Derrota a los ejércitos de Xavius en la base de Shaladrassil.", "Derrota a las fuerzas de Xavius en la base de Shaladrassil.", "Terrassez les forces de Xavius au pied de Shaladrassil.", "Sconfiggi le forze di Xavius alla base di Shaladrassil.", "샬라드라실 아래에 있는 자비우스의 군대를 물리쳐야 합니다.", "Derrote as forças de Xavius na base de Shaladrassil.", "Разгромите силы Ксавия у корней Шаладрассила.", "在莎拉达希尔的根部击败萨维斯的部队。", "在夏達希爾的根部擊敗薩維斯的部隊。", }, 
},
["542"] = {
{ "Defeat the bosses of Blackrock Caverns", "Besiegt die Bosse der Schwarzfelshöhlen.", "Derrota a los jefes de las Cavernas Roca Negra.", "Derrota a los jefes de las Cavernas Roca Negra.", "Terrassez les boss des cavernes de Rochenoire.", "Sconfiggi i boss delle Caverne di Roccianera.", "검은바위 동굴 우두머리들을 처치해야 합니다.", "Derrote os chefes da Caverna Rocha Negra", "Победите боссов в пещерах Черной горы", "击败黑石岩窟的首领", "擊敗黑石洞穴的首領", }, 
{ "Defeat Beauty", "Besiegt Bella", "Derrota a Bella.", "Derrota a Bella.", "Terrassez la Belle.", "Sconfiggi Bella.", "아름이를 처치해야 합니다.", "Derrote a Bela", "Победите Красавицу", "击败如花", "擊敗美麗", }, 
},
["567"] = {
{ "Assist Illidan in disabling the three demon portals.", "Helft Illidan, die drei Dämonenportale zu deaktivieren.", "Ayuda a Illidan a desactivar los tres portales de demonios.", "Ayuda a Illidan a desactivar los tres portales demoníacos.", "Aider Illidan à désactiver les trois portails démoniaques.", "Aiuta Illidan a disattivare i tre Portali Demoniaci.", "일리단을 도와 악마의 차원문 세 개를 닫아야 합니다.", "Ajude Illidan a desativar os três portais demoníacos.", "Помогите Иллидану отключить три портала демонов.", "协助伊利丹关闭三座恶魔之门。", "協助伊利丹關閉三個惡魔之門。", }, 
{ "Assist Illidan in slaying the demon leader.", "Helft Illidan, den Anführer der Dämonen zu töten.", "Ayuda a Illidan a matar al líder demonio.", "Ayuda a Illidan a matar al líder demoníaco.", "Aider Illidan à tuer le chef des démons.", "Aiuta Illidan a uccidere il capo dei demoni.", "일리단을 도와 악마 지도자를 처치해야 합니다.", "Ajude Illidan a matar o líder dos demônios.", "Помогите Иллидану убить предводителя демонов.", "协助伊利丹击杀恶魔首领。", "協助伊利丹擊敗惡魔領袖。", }, 
{ "Prevent Queen Azshara from interfering with Nozdormu's plans.", "Verhindert, dass Königin Azshara Nozdormus Pläne durchkreuzt.", "Evita que la reina Azshara interfiera en los planes de Nozdormu.", "Evita que la Reina Azshara interfiera en los planes de Nozdormu.", "Empêcher Azshara de perturber les plans de Nozdormu.", "Impedisci alla Regina Azshara di interferire con i piani di Nozdormu.", "여왕 아즈샤라가 노즈도르무의 계획을 방해하지 못하게 막아야 합니다.", "Impeça a Rainha Azshara de interferir nos planos de Nozdormu.", "Помешайте королеве Азшаре сорвать планы Ноздорму.", "防止艾萨拉女王破坏诺兹多姆的计划。", "避免艾薩拉女王干擾諾茲多姆的計畫。", }, 
{ "Assist Illidan in defeating Mannoroth.", "Helft Illidan, Mannoroth zu besiegen.", "Ayuda a Illidan a derrotar a Mannoroth.", "Ayuda a Illidan a derrotar a Mannoroth.", "Aider Illidan à vaincre Mannoroth.", "Aiuta Illidan a sconfiggere Mannoroth.", "일리단을 도와 만노로스를 처치해야 합니다.", "Ajude Illidan a derrotar Mannoroth.", "Помогите Иллидану победить Маннорота.", "协助伊利丹击败玛诺洛斯。", "協助伊利丹擊敗瑪諾洛斯。", }, 
},
["1274"] = {
{ "Locate the lost Titan vault near the Maelstrom.", "Findet das vergessene Titanengewölbe in der Nähe des Mahlstroms.", "Localiza la cámara de los titanes perdida cerca de La Vorágine.", "Encuentra la bóveda perdida del titán cerca de la Vorágine.", "Trouvez le caveau des titans oublié près du Maelström.", "Trova l'antica Volta dei Titani perduta presso il Maelstrom.", "혼돈의 소용돌이 근처에 있는 잊혀진 티탄의 석실을 찾아야 합니다.", "Encontre a câmara titânica perdida perto da Voragem.", "Отыщите затерянное хранилище титанов у Водоворота.", "找到大漩涡附近失落的泰坦宝库。", "找出大漩渦附近的失落泰坦遺址。", }, 
{ "Enter the Titan vault.", "Betretet das Titanengewölbe.", "Entra en la cámara de los titanes.", "Entra a la bóveda del titán.", "Entrez dans le caveau des titans.", "Entra nella Volta dei Titani.", "티탄 석실에 들어가야 합니다.", "Entre na câmara titânica.", "Войдите в хранилище титанов.", "进入泰坦的宝库。", "進入泰坦遺址。", }, 
{ "Activate the console to power up the custodian.", "Schaltet die Konsole ein, um den Verwalter zu aktivieren.", "Activa la consola para activar al custodio.", "Activa la consola para darle energía al custodio.", "Activez la console pour alimenter le gardien.", "Attiva la console per avviare il Custode.", "제어 장치를 활성화하여 관리인을 깨워야 합니다.", "Ative o console para fortalecer o zelador.", "Активируйте смотрителя с помощью консоли.", "激活控制台，为管理员充能。", "啟動控制臺，喚醒管理人。", }, 
{ "Listen to the custodian's story.", "Hört Euch die Geschichte des Verwalters an.", "Escucha la historia del custodio.", "Escucha la historia del custodio.", "Écoutez l’histoire du gardien.", "Ascolta la storia del Custode.", "관리인의 이야기를 들어야 합니다.", "Ouça a história do zelador.", "Выслушайте рассказ смотрителя.", "听管理员讲他的故事。", "聆聽管理人的故事。", }, 
{ "Defend yourself against the vault's defense mechanisms.", "Wehrt Euch gegen die Verteidigungsmechanismen.", "Defiéndete de los mecanismos de defensa de la cámara.", "Defiéndete de los mecanismos de defensa de la bóveda.", "Protégez-vous contre les mécanismes de défense du caveau.", "Difenditi contro i sistemi di difesa della Volta.", "석실의 방어 병력에 맞서 자신을 지켜야 합니다.", "Proteja-se dos mecanismos de defesa da câmara.", "Справьтесь с защитными механизмами хранилища.", "保护你自己不受保护防御系统的伤害。", "對抗遺址中的防禦機制。", }, 
},
["1339"] = {
{ "The Deceiver awaits...", "Der Betrüger wartet...", "El Impostor espera...", "El Falsario espera...", "Le Trompeur nous attend…", "L'Ingannatore attende...", "기만자가 기다립니다...", "O Enganador aguarda...", "Искуситель ждет...", "欺诈者在等着你……", "欺詐者在等待著…", }, 
},
["1337"] = {
{ "A sealed portion Temple of Elune has been breached by the Legion and has created unthinkable horrors.", "Ein versiegelter Bereich des Tempels von Elune wurde von der Legion aufgebrochen und hat undenkbare Schrecken hervorgebracht.", "La Legión ha conseguido entrar en una sección sellada del Templo de Elune y ha creado horrores inimaginables.", "La Legión ha penetrado en un sector sellado del Templo de Elune y ha creado horrores inimaginables.", "La légion a pénétré dans une partie scellée du temple d’Élune et créé des horreurs inimaginables.", "Una zona protetta del Tempio di Elune è stata invasa dalla Legione e ha generato orrori inimmaginabili.", "엘룬의 사원의 봉인된 구역에 군단이 침입하여, 상상할 수도 없는 공포를 만들어냈습니다.", "Uma parte interditada do Templo de Eluna foi invadida pela Legião, criando horrores inimagináveis.", "Демоны Легиона проникли в потайную часть храма Элуны, и теперь там царит невообразимый ужас.", "月神殿中被封印起来的区域，被燃烧军团攻破后已成为恐怖横行之地。", "燃燒軍團闖進伊露恩神殿中某個密室，並且製造出難以想像的可怕怪物。", }, 
},
["205"] = {
{ "Ride Thunderwing to scout Stormsea Landing from the air.", "Reitet den Donnerflügel, um den Sturmgepeitschten Hafen aus der Luft zu erkunden.", "Móntate en Alatrueno para explorar el Muelle Aguaturbia desde el aire.", "Móntate en Alatrueno para explorar el Muelle Aguaturbia desde el aire.", "Utilisez Aile-Tonnerre pour faire une reconnaissance aérienne du débarcadère de la mer des Tempêtes.", "Monta sull'alatonante ed esplora l'Approdo della Tempesta dall'alto.", "천둥날개를 타고 폭풍바다 선착장을 하늘에서 정찰해야 합니다.", "Monte o Trovoasa para patrulhar o Ancoradouro do Mar Revolto pelo ar.", "Оседлайте Громокрыла и разведайте обстановку на Пристани Бушующих Волн с воздуха.", "骑乘雷霆翼龙从空中侦察风暴之海码头。", "騎乘雷翅翼手龍從空中偵察狂濤港。", }, 
{ "Drop smoke bombs on sentry totems to deactivate them.", "Setzt Rauchbomben gegen Totems des Wachens ein, um sie zu blenden.", "Lanza bombas de humo a los tótems avizores para desactivarlos.", "Lanza bombas de humo a los tótems avizores para desactivarlos.", "Larguez des bombes fumigènes sur les totems sentinelles pour les désactiver.", "Lancia delle bombe fumogene sui Totem Avvistatori per neutralizzarli.", "감시의 토템에 연막탄을 던져 작동을 중지시켜야 합니다.", "Jogue bombas de fumaça nos totens-sentinela para desativá-los.", "Сбросьте дымовые шашки на сторожевые тотемы, чтобы деактивировать их.", "对岗哨图腾投掷烟雾弹，使其瘫痪。", "把煙霧彈扔在崗哨圖騰上來癱瘓它們。", }, 
{ "Knock Out the crew members marked by Taoshi and sneak to the siege weapons at the front of the ship.", "Macht die Besatzungsmitglieder unschädlich, die von Taoshi markiert wurden und schleicht zu den Belagerungswaffen am Bug des Schiffes.", "Noquea a los miembros de la tripulación marcados por Taoshi, cuélate en el barco y busca las armas de asedio en la proa.", "Noquea a los miembros de la tripulación marcados por Taoshi, cuélate en el barco y busca las armas de asedio en la proa.", "Assommez les membres d’équipage désignés par Taoshi, puis déplacez-vous silencieusement jusqu’aux armes de siège à l’avant du navire.", "Stordisci i membri della ciurma marcati da Taoshi e raggiungi le armi d'assedio sulla prua della nave.", "타오스가 지정한 선원들을 제압하고 배 앞부분에 있는 공성 무기에 침투해야 합니다.", "Nocauteie os tripulantes marcados por Taoshi e esgueire-se até as armas de cerco na frente do navio.", "Нейтрализуйте членов команды, которых отметила Таоши, и проберитесь к осадным орудиям на носу корабля.", "击倒被陶矢标记的船员，并溜到位于船只前方的攻城武器处。", "打暈陶氏標記的船員並潛行到船頭的攻城武器旁。", }, 
{ "Head below decks and assassinate Captain Halu'kal.", "Begebt Euch unter Deck und tötet Kapitän Halu'kal.", "Asesina al capitán Halu'kal bajo cubierta.", "Asesina al capitán Halu'kal bajo cubierta.", "Rendez-vous sous le pont et assassinez le capitaine Halu’kal.", "Scendi sotto coperta ed elimina il Capitano Halu'kal.", "갑판 아래로 이동해 선장 할루칼을 처치해야 합니다.", "Vá para o porão e assassine o Capitão Halu'kal.", "Проберитесь на нижние палубы и убейте капитана Халу'кала.", "走下甲板并刺杀哈鲁卡尔船长。", "到甲板下刺殺哈魯寇船長。", }, 
{ "Sneak across the shipyard and up the hill to reach Hu'seng the Gatekeeper.", "Schleicht Euch durch die Werft auf den Hügel, um Hu'seng den Torwächter zu erreichen.", "Cruza el astillero y sube la colina hasta llegar a Hu'seng el Guardián de la Puerta.", "Cruza el astillero y sube la colina hasta llegar a Hu'seng el Guardián de la Puerta.", "Faufilez-vous à travers le chantier naval jusqu’en haut de la colline pour atteindre Hu’seng, le gardien de la porte.", "Attraversa di nascosto il porto, sali sulla collina e raggiungi Hu'seng il Guardiano delle Porte.", "조선소로 침투해 언덕에 올라 문지기 후썽에게 가야 합니다.", "Passe furtivamente pelo estaleiro e suba a colina para chegar a Hu'seng, o Guarda-pórtico.", "Прокрадитесь по пристани до вершины холма, чтобы добраться до Ху'шэня, стража врат.", "潜行穿过船坞并继续上山，直到找到守门人虎申。", "潛過船塢，並往上前進到『門將』胡聖那裡。", }, 
{ "Slay Hu'seng the Gatekeeper and recover his key.", "Tötet Hu'seng den Torwächter und nehmt seinen Schlüssel an Euch.", "Mata a Hu'seng el Guardián de la Puerta y hazte con su llave.", "Mata a Hu'seng el Guardián de la Puerta y recupera con su llave.", "Tuez Hu’seng le gardien de la porte et récupérez sa clé.", "Sconfiggi Hu'seng il Guardiano delle Porte e recupera la sua chiave.", "문지기 후썽을 처치한 뒤 열쇠를 빼앗아야 합니다.", "Mate Hu'seng, o Guarda-pórtico, e pegue a chave dele.", "Убейте стража врат Ху'шэня и заберите у него сферу привратника.", "击败守门人虎申并获得他的钥匙。", "殺死『門將』胡聖並取得他的鑰匙。", }, 
{ "Use the Gatekeeper's Orb to open the gate to the Bloodied Crossing.", "Benutzt die Torwächterkugel, um das Tor zur Blutigen Kreuzung zu öffnen.", "Usa el orbe del Guardián de la Puerta para abrir la puerta del Cruce Sangriento.", "Usa el orbe del Guardián de la Puerta para abrir la puerta del Cruce Sangriento.", "Utilisez l’Orbe du gardien de la porte pour ouvrir les portes de la croisée Ensanglantée.", "Usa il Globo del Guardiano delle Porte per aprire l'accesso al Crocevia Insanguinato.", "문지기의 보주를 이용해 선혈의 십자로로 가는 문을 열어야 합니다.", "Use o Guarda-pórtico para abrir o portão para a Encruzilhada Rubra.", "Воспользуйтесь сферой привратника, чтобы открыть врата в Кровавый перекресток.", "使用守门人的宝珠，打开通向血腥岔路口的大门。", "使用守門者寶珠來打開染血路口的門。", }, 
},
["1323"] = {
{ "Defeat Mephistroth and place the Aegis of Aggramar within the top of the tomb before you are overrun by the Legion.", "Bezwingt Mephistroth und platziert die Aegis von Aggramar im oberen Bereich des Grabmals, bevor Ihr von der Legion überrannt werdet.", "Derrota a Mephistroth y coloca la Égida de Aggramar en lo alto de la tumba antes de que la Legión lo invada todo.", "Derrota a Mephistroth y coloca la Égida de Aggramar en la cumbre de la tumba antes de que las fuerzas de la Legión arrasen contigo.", "Battez Méphistroth et placez l’Égide d’Aggramar au sommet de la tombe avant que la Légion vous submerge.", "Sconfiggi Mefistroth e piazza l'Egida di Aggramar nella sala in cima alla Cattedrale prima dell'invasione della Legione.", "군단에 짓밟히기 전에 메피스트로스를 처치하고 아그라마르의 아이기스를 무덤 꼭대기에 놓아야 합니다.", "Derrote Mephistroph e ponha a Égide de Aggramar no topo da tumba antes que a Legião subjugue você.", "Победите Мефистрота и установите Эгиду Агграмара на верхнем ярусе гробницы, пока силы Легиона не одолели вас.", "击败孟菲斯托斯，并在军团占领这里前把阿格拉玛之盾放置在墓穴顶层。", "在你被燃燒軍團消滅之前，擊敗梅菲斯托並且將阿格拉瑪之盾放置在墓地頂端。", }, 
},
["324"] = {
{ "Speak with Durotan.", "Sprecht mit Durotan.", "Habla con Durotan.", "Habla con Durotan.", "Parlez à Durotan.", "Parla con Durotan.", "듀로탄과 대화해야 합니다.", "Fale com Durotan.", "Поговорите с Дуротаном.", "与杜隆坦交谈。", "和杜洛坦交談。", }, 
{ "Protect Frostfire against waves of Iron Horde attackers.", "Verteidigt den Frostfeuergrat gegen Wellen von Angreifern der Eisernen Horde.", "Protege Fuego Glacial de las oleadas de atacantes de la Horda de Hierro.", "Defiende a Pirofrío de las oleadas de atacantes de la Horda de Hierro.", "Protégez Givrefeu des vagues d’attaquants de la Horde de Fer.", "Proteggi Fuocogelo dalle ondate di aggressori dell'Orda di Ferro.", "강철 호드 공격자들에 맞서 서리불꽃을 지켜야 합니다.", "Proteja Fogofrio contra as ondas de atacantes da Horda de Ferro.", "Защищайте Хребет Ледяного Огня, отбивая атаки Железной Орды.", "保卫霜火岭，抵抗钢铁部落的进攻。", "抵擋鋼鐵部落的攻勢，守住霜火峰。", }, 
{ "Destroy the Iron Clusterpult.", "Zerstört das Eiserne Katapult.", "Destruye la matapulta de la Horda de Hierro.", "Destruye la clusterpulta de hierro.", "Détruisez le canon à mitraille de Fer.", "Distruggi la Sparagrappoli di Ferro.", "강철 집속탄 투석기를 파괴해야 합니다.", "Destrua o Lança-bombas de Ferro.", "Уничтожьте железную мегапушку.", "摧毁钢铁集簇投掷炮。", "摧毀鋼鐵集束砲。", }, 
{ "Protect Frostfire against waves of Iron Horde attackers.", "Verteidigt den Frostfeuergrat gegen Wellen von Angreifern der Eisernen Horde.", "Protege Fuego Glacial de las oleadas de atacantes de la Horda de Hierro.", "Defiende a Pirofrío de las oleadas de atacantes de la Horda de Hierro.", "Protégez Givrefeu des vagues d’attaquants de la Horde de Fer.", "Proteggi Fuocogelo dalle ondate di aggressori dell'Orda di Ferro.", "강철 호드 공격자들에 맞서 서리불꽃을 지켜야 합니다.", "Proteja Fogofrio contra as ondas de atacantes da Horda de Ferro.", "Защищайте Хребет Ледяного Огня, отбивая атаки Железной Орды.", "保卫霜火岭，抵抗钢铁部落的进攻。", "抵擋鋼鐵部落的攻勢，守住霜火峰。", }, 
{ "Protect Drek'thar from Iron Horde attackers.", "Beschützt Drek'thar vor den Angreifern der Eisernen Horde.", "Protege a Drek'Thar de los atacantes de la Horda de Hierro.", "Protege a Drek'Thar de los atacantes de la Horda de Hierro.", "Protégez Drek’thar des attaquants de la Horde de Fer.", "Proteggi Drek'thar dagli attacchi dell'Orda di Ferro.", "강철 호드 공격자들에게서 드렉타르를 지켜야 합니다.", "Proteja Drek'Thar dos atacantes da Horda de Ferro.", "Защищайте Дрек'Тара от бойцов Железной Орды.", "保护德雷克塔尔，挡住钢铁部落的袭击者。", "在鋼鐵部落的攻擊之下保護德雷克塔爾。", }, 
{ "Protect Frostfire against waves of Iron Horde attackers.", "Verteidigt den Frostfeuergrat gegen Wellen von Angreifern der Eisernen Horde.", "Protege Fuego Glacial de las oleadas de atacantes de la Horda de Hierro.", "Defiende a Pirofrío de las oleadas de atacantes de la Horda de Hierro.", "Protégez Givrefeu des vagues d’attaquants de la Horde de Fer.", "Proteggi Fuocogelo dalle ondate di aggressori dell'Orda di Ferro.", "강철 호드 공격자들에 맞서 서리불꽃을 지켜야 합니다.", "Proteja Fogofrio contra as ondas de atacantes da Horda de Ferro.", "Защищайте Хребет Ледяного Огня, отбивая атаки Железной Орды.", "保卫霜火岭，抵抗钢铁部落的进攻。", "抵擋鋼鐵部落的攻勢，守住霜火峰。", }, 
{ "Defeat Malgrim Stormhand.", "Bezwingt Malgrim Sturmhand.", "Derrota a Malgrim Mano Tormenta.", "Derrota a Malgrim Manotormenta.", "Terrassez Malgrim Foudremain.", "Sconfiggi Malgrim Manotonante.", "말그림 스톰핸드를 처치해야 합니다.", "Derrote Malgrim Mão Tempestuosa.", "Победите Малгрима Грозового Кулака.", "击败马尔格林·风暴之手。", "擊敗瑪格林‧風臂。", }, 
{ "Protect Frostfire against waves of Iron Horde attackers.", "Verteidigt den Frostfeuergrat gegen Wellen von Angreifern der Eisernen Horde.", "Protege Fuego Glacial de las oleadas de atacantes de la Horda de Hierro.", "Defiende a Pirofrío de las oleadas de atacantes de la Horda de Hierro.", "Protégez Givrefeu des vagues d’attaquants de la Horde de Fer.", "Proteggi Fuocogelo dalle ondate di aggressori dell'Orda di Ferro.", "강철 호드 공격자들에 맞서 서리불꽃을 지켜야 합니다.", "Proteja Fogofrio contra as ondas de atacantes da Horda de Ferro.", "Защищайте Хребет Ледяного Огня, отбивая атаки Железной Орды.", "保卫霜火岭，抵抗钢铁部落的进攻。", "抵擋鋼鐵部落的攻勢，守住霜火峰。", }, 
{ "Slay Maggoc.", "Tötet Maggoc.", "Mata a Maggoc.", "Asesina a Maggoc.", "Tuez Maggoc.", "Uccidi Maggoc.", "마그고크를 처치해야 합니다.", "Mate Maggoc.", "Убейте Маггока.", "击败玛古克。", "殺死瑪格歐克。", }, 
},
["705"] = {
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "Kill 10 Orcs", "Tötet 10 Orcs.", "Mata a 10 orcos.", "Mata 10 orcos", "Tuez 10 Orcs.", "Uccidi 10 Orchi.", "오크 10명을 처치해야 합니다.", "Matar 10 Orcs", "Убейте 10 орков", "击杀10个兽人", "殺死10個獸人", }, 
{ "Kill 20 Orcs", "Tötet 20 Orcs", "Mata a 20 orcos.", "Mata 20 orcos", "Tuer 20 orcs", "Uccidi 20 Orchi.", "오크 20명을 처치해야 합니다.", "Matar 20 Orcs", "Убейте 20 орков", "击杀20个兽人", "殺死20個獸人", }, 
{ "Kill 30 Orcs", "Tötet 30 Orcs", "Mata a 30 orcos.", "Mata 30 orcos", "Tuer 30 orcs", "Uccidi 30 Orchi.", "오크 30명을 처치해야 합니다.", "Matar 30 Orcs", "Убейте 30 орков", "击杀30个兽人", "殺死30個獸人", }, 
},
["605"] = {
{ "Defeat the bosses of The Nexus and free Keristrasza.", "Besiegt die Bosse im Nexus und befreit Keristrasza.", "Derrota a los jefes de El Nexo y libera a Keristrasza.", "Derrota a los jefes de El Nexo y libera a Keristrasza.", "Terrassez les boss du Nexus et libérer Keristrasza.", "Sconfiggi i boss del Nexus e libera Keristrasza.", "마력의 탑 우두머리들을 처치하고 케리스트라자를 풀어줘야 합니다.", "Derrote os chefes do Nexus e liberte Keristrasza.", "Победите боссов в Нексусе и освободите Керистразу.", "击败魔枢的首领并释放克莉斯塔萨。", "擊敗奧核之心的首領並救出凱瑞史卓莎。", }, 
{ "Defeat Commander Kolurg.", "Besiegt Kommandant Kolurg.", "Derrota al comandante Kolurg.", "Derrota al Comandante Kolurg.", "Terrassez le commandant Kolurg.", "Sconfiggi il Comandante Kolurg.", "사령관 콜루르그를 처치해야 합니다.", "Derrote o Comandante Kolurg.", "Победите командира Колурга.", "击败指挥官库鲁尔格。", "擊敗指揮官寇勒格。", }, 
},
["1132"] = {
{ "Learn about being a Mage.", "Erfahrt etwas über das Leben als Magier.", "Infórmate sobre ser un mago.", "Averigua sobre ser un Mago.", "Apprenez-en davantage sur les mages.", "Impara il significato di essere un Mago.", "마법사란 어떤 존재인지 배워야 합니다.", "Aprenda sobre os Magos.", "Узнайте, что значит быть магом.", "学习如何成为一名法师。", "學習如何當一名法師。", }, 
{ "Learn about Summon Water Elemental.", "Erfahrt mehr über 'Wasserelementar beschwören'.", "Infórmate sobre Invocar elemental de agua.", "Averigua más sobre Invocar elemental de agua.", "Apprenez-en davantage sur Invocation d’un élémentaire d’eau.", "Impara come usare Evocazione: Elementale dell'Acqua.", "물의 정령 소환에 대해 배워야 합니다.", "Aprenda sobre Evocar Elemental da Água.", "Научитесь призывать элементаля воды.", "学习召唤水元素。", "學習如何使用召喚水元素。", }, 
{ "Learn about Frostbolt.", "Erfahrt mehr über 'Frostblitz'.", "Infórmate sobre Descarga de Escarcha.", "Averigua más sobre Descarga de Escarcha.", "Apprenez-en davantage sur Éclair de givre.", "Impara come usare Dardo di Gelo.", "얼음 화살에 대해 배워야 합니다.", "Aprenda sobre Seta de Gelo.", "Научитесь применять \"Ледяную стрелу\".", "学习寒冰箭。", "學習如何使用寒冰箭。", }, 
{ "Learn about Ice Lance.", "Erfahrt mehr über 'Eislanze'", "Infórmate sobre Lanza de hielo.", "Averigua más sobre Lanza de hielo.", "Apprenez-en davantage sur Javelot de glace.", "Impara come usare Lancia di Ghiaccio.", "얼음창에 대해 배워야 합니다.", "Aprenda sobre Lança de Gelo.", "Научитесь применять \"Ледяное копье\".", "学习冰枪术。", "學習如何使用冰霜長矛。", }, 
{ "Learn about Ice Lance and Fingers of Frost.", "Erfahrt mehr über 'Eislanze' und 'Eisige Finger'.", "Infórmate sobre Lanza de hielo y Dedos de Escarcha.", "Averigua más sobre Lanza de hielo y Dedos de Escarcha.", "Apprenez-en davantage sur Javelot de glace et Doigts de givre.", "Impara come usare Lancia di Ghiaccio e Dita di Gelo.", "얼음창 및 서리의 손가락에 대해 배워야 합니다.", "Aprenda sobre Lança de Gelo e Dedos Glaciais.", "Научитесь применять \"Ледяное копье\" и \"Ледяные пальцы\".", "学习冰枪术和寒冰指。", "學習如何使用冰霜長矛和冰霜之指。", }, 
{ "Learn about Flurry.", "Erfahrt mehr über 'Hagel'.", "Infórmate sobre Aluvión.", "Averigua más sobre Aluvión.", "Apprenez-en davantage sur Rafale.", "Impara come usare Raffica di Colpi.", "진눈깨비에 대해 배워야 합니다.", "Aprenda sobre Ímpeto.", "Научитесь применять \"Шквал\".", "学习冰风暴。", "學會如何使用冰雪紛飛。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Blink.", "Erfahrt mehr über 'Blinzeln'.", "Infórmate sobre Traslación.", "Averigua más sobre Traslación.", "Apprenez-en davantage sur Transfert.", "Impara come usare Traslazione.", "점멸에 대해 배워야 합니다.", "Aprenda sobre Lampejo.", "Научитесь применять \"Скачок\".", "学习闪现术。", "學習如何使用閃現術。", }, 
{ "Learn about Frost Nova.", "Erfahrt mehr über 'Frostnova'.", "Infórmate sobre Nova de Escarcha.", "Averigua más sobre Nova de Escarcha.", "Apprenez-en davantage sur Nova de givre.", "Impara come usare Esplosione Gelida.", "얼음 회오리에 대해 배워야 합니다.", "Aprenda sobre Nova Congelante.", "Научитесь применять \"Кольцо льда\".", "学习冰霜新星。", "學習如何使用冰霜新星。", }, 
{ "Learn about Blizzard.", "Erfahrt mehr über 'Blizzard'.", "Infórmate sobre Ventisca.", "Averigua más sobre Ventisca.", "Apprenez-en davantage sur Blizzard.", "Impara come usare Tormenta.", "눈보라에 대해 배워야 합니다.", "Aprenda sobre Nevasca.", "Научитесь применять \"Снежную бурю\".", "学习暴风雪。", "學習如何使用暴風雪。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["1046"] = {
{ "Prove your worth and claim the Aegis of Aggramar.", "Beweist, dass Ihr würdig seid und sichert Euch die Aegis von Aggramar.", "Demuestra tu valía y hazte con la Égida de Aggramar.", "Prueba que eres digno y reclama la Égida de Aggramar.", "Prouvez votre valeur et emparez-vous de l’Égide d’Aggramar.", "Prova le tue capacità e ottieni l'Egida di Aggramar.", "자신의 가치를 증명하고 아그라마르의 아이기스를 차지하십시오.", "Prove seu valor e obtenha a Égide de Aggramar.", "Докажите, что вы достойны, и добудьте Эгиду Агграмара.", "证明你的实力，并夺取阿格拉玛之盾。", "證明你的資格，並取得阿格拉瑪之盾。", }, 
},
["204"] = {
{ "Acquire the Heavy Explosives.", "Beschafft den schweren Sprengstoff.", "Hazte con los explosivos pesados.", "Consigue los explosivos pesados.", "Obtenez les explosifs lourds.", "Recupera gli Esplosivi ad Alto Potenziale.", "거대 폭탄을 획득해야 합니다.", "Obtenha os Explosivos Pesados.", "Найдите мощную взрывчатку.", "找到重磅炸药。", "尋找強力炸藥。", }, 
{ "Speak with Vereesa at the city wall.", "Sprecht an der Stadtmauer mit Vereesa.", "Habla con Vereesa en la muralla de la ciudad.", "Habla con Vereesa en la muralla de la ciudad.", "Parlez à Vereesa au mur de la ville.", "Parla con Vereesa alle mura della cittadella.", "도시 성벽에 있는 베리사와 대화해야 합니다.", "Fale com Vereesa na muralha da cidade.", "Поговорите с Верисой у городской стены.", "去城墙边和温蕾萨交谈。", "跟在城牆外的凡蕾莎交談。", }, 
{ "Light the fuse on the Heavy Explosives.", "Entzündet die Zündschnur des schweren Sprengstoffs.", "Enciende la mecha de los explosivos pesados.", "Enciende la mecha de los explosivos pesados.", "Allumez la mèche des explosifs lourds.", "Accendi la miccia degli Esplosivi ad Alto Potenziale.", "거대 폭탄의 도화선에 불을 붙여야 합니다.", "Acenda o pavio dos Explosivos Pesados.", "Подожгите фитиль мощной взрывчатки.", "点燃重磅炸药的引线。", "點燃強力炸藥的引信。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["568"] = {
{ "Defeat the bosses within The Forge of Souls", "Bezwingt die Bosse in der Seelenschmiede.", "Derrota a los jefes dentro de La Forja de Almas.", "Derrota a los jefes de La Forja de Almas.", "Terrassez les boss de la forge des Âmes.", "Sconfiggi i boss della Forgia delle Anime.", "영혼의 제련소 우두머리들을 처치해야 합니다.", "Derrote os chefes na Forja das Almas", "Победите боссов в Кузне Душ", "击败灵魂洪炉的首领", "擊敗眾魂熔爐的首領", }, 
},
["942"] = {
{ "Defeat Dargrul's legions and recover the Hammer of Khaz'goroth before Highmountain is destroyed.", "Bezwingt Dargruls Legionen und erlangt den Hammer von Khaz'goroth zurück, bevor der Hochberg zerstört wird.", "Derrota a las legiones de Dargrul y recupera el Martillo de Khaz'goroth antes de que Monte Alto quede destruido.", "Derrota a las legiones de Dargrul y recupera el Martillo de Khaz'goroth antes de que Altamontaña sea destruida.", "Terrassez les légions de Dargrul et récupérez le marteau de Khaz’goroth avant que Haut-Roc ne soit détruit.", "Sconfiggi le legioni di Dargrul e recupera il Martello di Khaz'goroth prima che Alto Monte venga distrutta.", "높은산이 파괴되기 전에 다르그룰의 군단을 무찌르고 카즈고로스의 망치를 되찾아야 합니다.", "Derrote as legiões de Dargrul e recupere o Martelo de Khaz'goroth antes que Alta Montanha seja destruída.", "Сокрушите легионы Даргрула и заберите Молот Каз'горота, пока Крутогорье не пало.", "在至高岭被彻底毁灭前击败达古尔的军团，并夺回卡兹格罗斯之锤。", "擊敗達古爾的軍隊，並且在高嶺毀滅之前取得卡茲格羅斯之錘。", }, 
},
["1096"] = {
{ "Learn about being a Druid.", "Erfahrt etwas über das Leben als Druide.", "Infórmate sobre ser un druida.", "Averigua más sobre ser un druida.", "Apprenez-en davantage sur les druides.", "Impara il significato di essere un Druido.", "드루이드에 대해 배워야 합니다.", "Aprenda sobre os Druidas.", "Узнайте, что значит быть друидом.", "学习如何成为一名德鲁伊。", "學習如何當一名德魯伊。", }, 
{ "Learn about Cat Form.", "Erfahrt mehr über 'Katzengestalt'.", "Infórmate sobre Forma felina.", "Averigua más sobre Forma felina.", "Apprenez-en davantage sur Forme de félin.", "Impara come usare Forma Felina.", "표범 변신에 대해 배워야 합니다.", "Aprenda sobre Forma de Felino.", "Научитесь применять \"Облик кошки\".", "学习猎豹形态。", "學習如何使用獵豹形態。", }, 
{ "Learn about Prowl.", "Erfahrt mehr über 'Schleichen'.", "Infórmate sobre Acechar.", "Averigua más sobre Acechar.", "Apprenez-en davantage sur Rôder.", "Impara come usare Movimento Furtivo.", "숨기에 대해 배워야 합니다.", "Aprenda sobre Espreitar.", "Научитесь применять способность \"Крадущийся зверь\".", "学习潜行。", "學習如何使用潛行。", }, 
{ "Learn about Rake.", "Erfahrt mehr über 'Krallenhieb'.", "Infórmate sobre Arañazo.", "Averigua más sobre Arañazo.", "Apprenez-en davantage sur Griffure.", "Impara come usare Graffio.", "갈퀴 발톱에 대해 배워야 합니다.", "Aprenda sobre Estraçalhar.", "Научитесь применять \"Глубокую рану\".", "学习斜掠。", "學習如何使用掃擊。", }, 
{ "Learn about Shred.", "Erfahrt mehr über 'Schreddern'.", "Infórmate sobre Triturar.", "Averigua más sobre Triturar.", "Apprenez-en davantage sur Lambeau.", "Impara come usare Artigliata.", "칼날 발톱에 대해 배워야 합니다.", "Aprenda sobre Despedaçar.", "Научитесь применять способность \"Полоснуть\".", "学习撕碎。", "學習如何使用撕碎。", }, 
{ "Learn about Ferocious Bite.", "Erfahrt mehr über 'Wilder Biss'.", "Infórmate sobre Mordedura feroz.", "Averigua más sobre Mordedura feroz.", "Apprenez-en davantage sur Morsure féroce.", "Impara come usare Morso Feroce.", "흉포한 이빨에 대해 배워야 합니다.", "Aprenda sobre Mordida Feroz.", "Научитесь применять \"Свирепый укус\".", "学习凶猛撕咬。", "學習如何使用兇猛撕咬。", }, 
{ "Learn about Rip.", "Erfahrt mehr über 'Zerfetzen'.", "Infórmate sobre Destripar.", "Averigua más sobre Destripar.", "Apprenez-en davantage sur Déchirure.", "Impara come usare Squarcio.", "도려내기에 대해 배워야 합니다.", "Aprenda sobre Rasgar.", "Научитесь применять способность \"Разорвать\".", "学习割裂。", "學習如何使用撕扯。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Dash.", "Erfahrt mehr über 'Spurt'.", "Infórmate sobre Carrerilla.", "Averigua más sobre Carrerilla.", "Apprenez-en davantage sur Célérité.", "Impara come usare Slancio.", "질주에 대해 배워야 합니다.", "Aprenda sobre Arremetida.", "Научитесь применять \"Порыв\".", "学习急奔。", "學習如何使用突進。", }, 
{ "Learn about Regrowth.", "Erfahrt mehr über 'Nachwachsen'.", "Infórmate sobre Recrecimiento.", "Averigua más sobre Recrecimiento.", "Apprenez-en davantage sur Rétablissement.", "Impara come usare Ricrescita.", "재생에 대해 배워야 합니다.", "Aprenda sobre Recrescimento.", "Научитесь применять \"Восстановление\".", "学习愈合。", "學習如何使用癒合。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["1265"] = {
{ "Stop Sigryn from confronting Odyn.", "Verhindert, dass Sigryn Odyn konfrontiert.", "Evita que Sigryn se enfrente a Odyn.", "Impide que Sigryn se enfrente a Odyn.", "Empêchez Sigryn de défier Odyn.", "Impedisci a Sigryn di confrontarsi con Odyn.", "시그린이 오딘을 대면하지 못하게 막아야 합니다.", "Impeça Sigryn de confrontar Odyn.", "Помешайте Сигрин вступить в бой с Одином.", "阻止希格林挑战奥丁。", "阻止曦格琳去找歐丁對質。", }, 
{ "Defeat Sigryn and her fel council.", "Besiegt Sigryn und ihren dämonischen Rat.", "Derrota a Sigryn y su consejo vil.", "Derrota a Sigryn y a su consejo vil.", "Triomphez de Sigryn et de son entourage gangrené.", "Sconfiggi Sigryn e il suo Vilconcilio.", "시그린과 그녀의 지옥 동료들을 쓰러뜨려야 합니다.", "Derrote Sigryn e seu concílio vil.", "Одолейте Сигрин и ее союзников.", "击败希格林和她的邪能议会。", "擊敗曦格琳和她的惡魔議會。", }, 
},
["704"] = {
{ "Follow the Sergeant.", "Folgt dem Unteroffizier.", "Sigue al Sargento.", "Sigue al sargento.", "Suivez le sergent.", "Segui il Sergente.", "하사관을 따라가야 합니다.", "Siga o Sargento.", "Следуйте за сержантом.", "追随中士", "跟隨士官", }, 
{ "Defeat the Iron Horde scouting party.", "Besiegt den Eisernen Spähtrupp.", "Derrota al grupo de exploración de la Horda de Hierro.", "Derrota al grupo explorador de la Horda de Hierro.", "Neutralisez le groupe d’éclaireurs de la Horde de Fer.", "Sconfiggi il gruppo di esploratori dell'Orda di Ferro.", "강철 호드 정찰대를 물리쳐야 합니다.", "Derrote o grupo de batedores da Horda de Ferro.", "Убейте разведывательный отряд Железной Орды.", "击败钢铁部落的斥候小队。", "擊敗鋼鐵部落偵察隊。", }, 
{ "Endure the Iron Horde assault.", "Übersteht den Ansturm der Eisernen Horde.", "Resiste el asalto de la Horda de Hierro.", "Aguanta el ataque de la Horda de Hierro.", "Survivez à l’attaque de la Horde de Fer.", "Resisti all'Assalto dell'Orda di Ferro.", "강철 호드의 공격을 막아내야 합니다.", "Resista ao ataque da Horda de Ferro.", "Отразите атаку Железной Орды.", "顶住钢铁部落的攻击。", "撐過鋼鐵部落的攻擊。", }, 
{ "Defeat the remaining Iron Horde forces.", "Besiegt die verbleibenden Truppen der Eisernen Horde.", "Derrota a las tropas restantes de la Horda de Hierro.", "Derrota a las fuerzas de la Horda de Hierro restantes.", "Terrassez les derniers soldats de la Horde de Fer.", "Sconfiggi le forze restanti dell'Orda di Ferro.", "남은 강철 호드 병력을 물리쳐야 합니다.", "Derrote as forças restantes da Horda de Ferro.", "Одержите победу над оставшимися силами Железной Орды.", "击败钢铁部落的残余部队。", "擊敗剩下的鋼鐵部落部隊。", }, 
{ "Return to the town center.", "Kehrt zur Ortsmitte zurück.", "Vuelve al centro de la ciudad.", "Vuelve al centro del pueblo.", "Retournez dans le centre-ville.", "Torna al centro del villaggio.", "마을 중앙으로 가야 합니다.", "Retorne ao centro da cidade.", "Вернитесь в центр гарнизона.", "返回镇中心。", "返回城鎮中心。", }, 
{ "Defeat the Iron Horde commander.", "Besiegt den Kommandanten der Eisernen Horde.", "Derrota al comandante de la Horda de Hierro.", "Derrota al comandante de la Horda de Hierro.", "Terrassez le commandant de la Horde de Fer.", "Sconfiggi il comandante dell'Orda di Ferro.", "강철 호드 지휘관을 처치해야 합니다.", "Derrote o comandante da Horda de Ferro.", "Победите полководца Железной Орды.", "击败钢铁部落指挥官。", "擊敗鋼鐵部落指揮官。", }, 
{ "Bronze: Earn 300 Points", "Bronze: Verdient 300 Punkte.", "Bronce: Gana 300 puntos.", "Bronce: obtén 300 puntos", "Bronze : Obtenir 300 points", "Bronzo: ottieni 300 punti.", "동메달: 300점을 획득해야 합니다.", "Bronze: Obter 300 Pontos", "Бронза: заработайте 300 очков", "青铜：获得300点", "青銅：獲得300分", }, 
{ "Silver: Earn 600 Points", "Silber: Verdient 600 Punkte.", "Plata: Gana 600 puntos.", "Plata: obtén 600 puntos", "Argent : Obtenir 600 points.", "Argento: ottieni 600 punti.", "은메달: 600점을 획득해야 합니다.", "Prata: Obter 600 Pontos", "Серебро: заработайте 600 очков", "白银：获得600点", "白銀：獲得600分", }, 
{ "Gold: Earn 1000 Points", "Gold: Verdient 1000 Punkte.", "Oro: Gana 1000 puntos.", "Oro: obtén 1000 puntos", "Or : Obtenir 1 000 points", "Oro: ottieni 1.000 punti.", "금메달: 1000점을 획득해야 합니다.", "Ouro: Obter 1000 Pontos", "Золото: заработайте 1000 очков", "黄金：获得1000点", "黃金：獲得1000分", }, 
{ "Platinum: Earn 1300 Points", "Platin: Verdient 1300 Punkte.", "Platino: Gana 1300 puntos", "Platino: obtén 1300 puntos", "Platine : Obtenir 1 300 points", "Platino: ottieni 1.300 punti.", "백금메달: 1300점을 획득해야 합니다.", "Platina: Obter 1300 pontos", "Платина: заработайте 1300 очков", "白金：获得1300点", "白金：獲得1300分", }, 
},
["566"] = {
{ "Defeat the bosses within The Forge of Souls", "Bezwingt die Bosse in der Seelenschmiede.", "Derrota a los jefes dentro de La Forja de Almas.", "Derrota a los jefes de La Forja de Almas.", "Terrassez les boss de la forge des Âmes.", "Sconfiggi i boss della Forgia delle Anime.", "영혼의 제련소 우두머리들을 처치해야 합니다.", "Derrote os chefes na Forja das Almas", "Победите боссов в Кузне Душ", "击败灵魂洪炉的首领", "擊敗眾魂熔爐的首領", }, 
},
["666"] = {
{ "Defeat the bosses of the Capital Gardens", "Bezwingt die Bosse der Hauptstadtgärten.", "Derrota a los jefes de los Jardines de la Capital", "Derrota a los jefes de los Jardines de la Capital", "Triomphez des boss des Grands jardins.", "Sconfiggi i boss dei Giardini della Capitale.", "수도 정원 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Jardins Capitais", "Победите боссов в Центральном саду", "击败中心花园的首领", "擊敗中心花園的首領", }, 
{ "Defeat Prince Tortheldrin", "Bezwingt Prinz Tortheldrin", "Derrota al príncipe Tortheldrin", "Derrota al príncipe Tortheldrin", "Triomphez du prince Tortheldrin.", "Sconfiggi il Principe Tortheldrin.", "왕자 토르텔드린을 처치해야 합니다.", "Derrote o Príncipe Tortheldrin", "Победите принца Тортелдрина", "击败托塞德林王子", "擊敗托塞德林王子", }, 
},
["633"] = {
{ "Defeat the bosses of The Slave Pens", "Bezwingt die Bosse der Sklavenunterkünfte.", "Derrota a los jefes de Recinto de los Esclavos.", "Derrota a los jefes del Recinto de los Esclavos.", "Terrassez les boss des enclos aux esclaves.", "Sconfiggi i boss delle Fosse degli Schiavi.", "강제 노역소 우두머리들을 처치해야 합니다.", "Derrote os chefes do Pátio dos Escravos", "Победите боссов в Узилище", "击败奴隶围栏的首领", "擊敗奴隸監獄的首領", }, 
},
["1266"] = {
{ "Tugar has gone to ground in the Bloodtotem Ritual Cave. Its time to put an end to him.", "Tugar hat sich in der Ritualhöhle der Bluttotems eingenistet. Es ist Zeit, ihm ein Ende zu bereiten.", "Tugar se ha escondido en la Cueva Ritual Tótem Sangriento. Es hora de acabar con él.", "Tugar ha huido hacia la cueva del ritual de Tótem de sangre. Llegó la hora de ponerle fin a su vida.", "Tugar se terre dans la grotte rituelle des Totems-de-Sang. Il est temps de le tuer.", "Tugar si è rifugiato nella Caverna Rituale dei Totem Sanguinario. È giunta l'ora di mettere fine alla sua esistenza.", "투가르가 핏빛토템 의식 동굴로 갔습니다. 그를 끝장낼 시간입니다.", "Tugar se retirou para a Caverna Ritualística do Totem de Sangue. Está na hora de dar um fim nele.", "Тугар затаился в ритуальной пещере Кровавого Тотема. Пора покончить с ним.", "图加进入了鲜血图腾仪式洞穴。是时候了结他了。", "圖加躲進了血圖騰儀式洞穴，該是把他一舉消滅的時候了。", }, 
{ "Defeat Tugar Bloodtotem and Jormog the Behemoth.", "Besiegt Tugar Bluttotem und Jormog das Ungetüm.", "Derrota a Tugar Tótem Sangriento y a Jormog el Behemoth.", "Derrota a Tugar Tótem de sangre y a Jormog, el Behemoth.", "Terrassez Tugar Totem-de-Sang et Jormog le Béhémoth.", "Sconfiggi Tugar Totem Sanguinario e Jormog il Behemoth.", "투가르 블러드토템과 거수 요르모그를 처치해야 합니다.", "Derrote Tugar Totem de Sangue e Jormog, o Beemote.", "Одолейте Тугара Кровавого Тотема и Йормога Чудовищного.", "击败图加·鲜血图腾和“巨兽”乔莫格。", "擊敗圖加‧血圖騰和『巨蟲』尤瑪葛。", }, 
},
["1309"] = {
{ "Return to Karazhan and defeat the tower inhabitants.", "Kehrt nach Karazhan zurück und besiegt die Bewohner des Turms.", "Vuelve a Karazhan y derrota a los habitantes de la torre.", "Regresa a Karazhan y derrota a los habitantes de la torre.", "Retournez à Karazhan et terrassez les habitants des tours.", "Torna a Karazhan e sconfiggi gli abitanti della torre.", "카라잔으로 돌아가 탑의 거주자들을 처치해야 합니다.", "Retorne a Karazhan e derrote os ocupantes da torre.", "Вернитесь в Каражан и одолейте обитателей башни.", "重返卡拉赞，并击败塔楼内的居民。", "回到卡拉贊擊倒高塔中的敵人。", }, 
},
["333"] = {
{ "Defeat the bosses of Blackfathom Deeps", "Bezwingt die Bosse der Tiefschwarzen Grotte.", "Derrota a los jefes de las Cavernas de Brazanegra.", "Derrota a los jefes de las Cavernas de Brazanegra", "Triomphez des boss des profondeurs de Brassenoire.", "Sconfiggi i seguenti boss negli Abissi di Fondocupo.", "검은심연 나락 우두머리들을 처치해야 합니다.", "Derrote os chefes das Profundezas Negras", "Победите боссов в Непроглядной Пучине", "击败黑暗深渊的首领", "擊敗黑澗深淵的首領", }, 
{ "Defeat Domina", "Bezwingt Domina", "Derrota a Domina.", "Derrota a Domina", "Triomphez de Domina.", "Sconfiggi Domina.", "도미나를 처치해야 합니다.", "Derrote Dômina", "Победите Домину", "击败多米尼娜", "擊敗朵米娜", }, 
{ "Defeat Subjugator Kor'ul", "Bezwingt Unterwerfer Kor'ul", "Derrota al subyugador Kor'ul.", "Derrota al subyugador Kor'ul", "Triomphez du subjugateur Kor’ul.", "Sconfiggi il Plagiatore Kor'ul.", "정복자 코르울을 처치해야 합니다.", "Derrote o Subjugador Kor'ul", "Победите поработителя Кор'ула", "击败征服者克鲁尔", "擊敗征服者寇烏爾", }, 
{ "Defeat the Guardian of the Deep", "Bezwingt den Wächter der Tiefe", "Derrota al guardián de las profundidades.", "Derrota al Guardián de las profundidades", "Triomphez du Gardien des profondeurs.", "Sconfiggi il Guardiano del Profondo.", "심연의 수호자를 처치해야 합니다.", "Derrote o Guardião das Profundezas", "Победите Стража пучины", "击败深渊守护者", "擊敗深淵守護者", }, 
},
["1012"] = {
{ "Commandeer the Horizon's Edge.", "Kapert die Ende des Horizonts.", "Toma posesión del Filo del Horizonte.", "Incauta la Frontera del Horizonte.", "Réquisitionnez l’Horizon.", "Prendi il controllo della Orizzonte degli Eventi.", "지평선의 끝호를 빼앗아야 합니다.", "Tome o comando do Gume do Horizonte.", "Захватите \"Край горизонта\".", "夺取大地之末号。", "奪取海緣號。", }, 
{ "Find the Dread Admiral Eliza in the Temple of a Thousand Lights.", "Sucht nach Schreckensadmiralin Eliza im Tempel der Tausend Lichter.", "Encuentra a la almirante aterradora Eliza en el Templo de las Mil Luces.", "Encuentra a la Almirante del terror Eliza en el Templo de las Mil Luces.", "Trouvez l’amiral de l’effroi Eliza dans le temple des Mille lumières.", "Trova l'Ammiraglio del Terrore Eliza nel Tempio delle Mille Luci.", "천 갈래 빛의 사원에 있는 공포의 제독 엘리자를 찾아야 합니다.", "Encontre a Almirante do Medo Elisa no Templo de Mil Luzes.", "Отыщите жуткого адмирала Элизу в храме Тысячи Огней.", "在千光神殿中找到亡灵舰长伊丽扎。", "在千燈神廟找到驚懼上將伊莉莎。", }, 
{ "Defeat Lord Brinebeard.", "Bezwingt Lord Salzbart.", "Derrota a lord Barbasalmuera.", "Derrota a Lord Barbamar.", "Terrassez le seigneur Barbe-Salée.", "Sconfiggi Ser Barbabrina.", "군주 바다수염을 처치해야 합니다.", "Derrote Lorde Barba Salobra.", "Победите владыку Солеборода.", "击败盐须领主。", "擊敗鹽鬍子領主。", }, 
{ "Pursue the Dread Admiral Eliza into the temple depths.", "Verfolgt Schreckensadmiralin Eliza in die Tiefen des Tempels.", "Persigue a la almirante aterradora Eliza hasta las profundidades del templo.", "Persigue a la Almirante del terror Eliza hacia lo profundo del templo.", "Poursuivez l’amiral de l’effroi Eliza jusque dans les profondeurs du temple.", "Insegui l'Ammiraglio del Terrore Eliza nelle profondità del tempio.", "공포의 제독 엘리자를 쫓아 신전 깊은 곳으로 들어가야 합니다.", "Siga a Almirante do Medo Elisa até as profundezas do templo.", "Следуйте в храм за жутким адмиралом Элизой.", "追踪亡灵舰长伊丽扎深入神殿。", "進入神廟追殺驚懼上將伊莉莎。", }, 
{ "Defeat the Dread Admiral Eliza and claim the Dreadblades", "Bezwingt die Schreckensadmiralin Eliza und nehmt die Schreckensklingen an Euch.", "Derrota a la almirante aterradora Eliza y reclama las Hojas Pérfidas.", "Derrota a la Almirante del terror Eliza y reclama los Filos del Terror.", "Terrassez l’amiral de l’effroi Eliza et récupérez les lames d’effroi.", "Sconfiggi l'Ammiraglio del Terrore Eliza e prendi le sue Lame dell'Oscurità.", "공포의 제독 엘리자를 처치하고 공포의 검을 획득해야 합니다.", "Derrote a Almirante do Medo Elisa e obtenha os Alfanjes do Terror", "Победите жуткого адмирала Элизу и заберите Клинки Ужаса.", "击败亡灵舰长伊丽扎并夺取恐惧之刃。", "擊敗驚懼上將伊莉莎，奪取驚懼雙刀。", }, 
},
["1252"] = {
{ "Infiltrate the Court of Stars and confront Grand Magistrix Elisande.", "Infiltriert den Hof der Sterne und stellt Großmagistrix Elisande.", "Infíltrate en la Corte de las Estrellas y enfréntate a la gran magistrix Elisande.", "Infíltrate en la Corte de Estrellas y confronta a la Gran Magistrix Elisande.", "Infiltrez-vous dans la cour des Étoiles et affrontez la grande magistrice Élisande.", "Infiltrati nella Corte delle Stelle e affronta la Gran Magistra Elisande.", "별의 궁정에 잠입한 다음 대마법학자 엘리산드를 상대해야 합니다.", "Infiltre-se no Pátio das Estrelas e confronte a Grã-magistra Elisande.", "Проникните в Квартал Звезд и бросьте вызов Великому магистру Элисанде.", "渗透进群星庭院，与大魔导师艾利桑德对峙。", "潛入眾星之廷，面對大博學者艾莉珊德。", }, 
},
["1148"] = {
{ "Fight your way to the Observation Ring", "Kämpft Euch zum Beobachtungsring durch", "Ábrete camino hasta el Círculo de Observación", "Ábrete paso hasta el Círculo de Observación.", "Frayez-vous un chemin jusqu’au cercle d’observation.", "Fatti strada verso l'Anello d'Osservazione.", "적을 처치하면서 관찰 지구까지 가야 합니다.", "Abra caminho, lutando, até o Círculo de Observação", "Пробейтесь к Кругу Наблюдения.", "杀出一条血路，前往观测场。", "一路殺進觀察之環。", }, 
{ "Follow the Iron Dwarf", "Folgt dem Eisenzwerg.", "Sigue al enano férreo.", "Sigue al Enano férreo.", "Suivez le nain de fer.", "Segui il Nano di Ferro.", "무쇠 드워프를 따라가야 합니다.", "Siga o Anão de Ferro", "Следуйте за железным дворфом.", "跟随铁矮人。", "跟隨鐵矮人。", }, 
{ "Pull the door open", "Zieht die Tür auf.", "Abre la puerta.", "Tira de la puerta para abrirla.", "Ouvrez la porte.", "Apri la porta.", "문을 열어야 합니다.", "Abra a porta", "Выломайте дверь.", "把门拉开。", "把門拉開。", }, 
{ "Rescue Hodir!", "Rettet Hodir!", "¡Rescata a Hodir!", "¡Rescata a Hodir!", "Sauvez Hodir !", "Salva Hodir!", "호디르를 구출해야 합니다!", "Resgate Hodir!", "Спасите Ходира!", "营救霍迪尔！", "拯救霍迪爾！", }, 
{ "Follow Hodir to the Clash of Thunder", "Folgt Hodir zum Donnerschlag.", "Sigue a Hodir a El Fragor del Trueno", "Sigue a Hodir hacia el Fragor del Trueno.", "Suivez Hodir jusqu’au Fracas du tonnerre.", "Segui Hodir nella Sala del Tuono.", "호디르를 따라 천둥의 울림으로 가야 합니다.", "Siga Hodir até o Estrondo do Trovão", "Следуйте за Ходиром в Раскаты Грома.", "跟随霍迪尔，前往雷霆角斗场。", "跟隨霍迪爾前往雷鳴之廳。", }, 
{ "Get through the Legion gauntlet", "Bringt den Hindernislauf durch die Legion hinter Euch", "Supera la prueba de la Legión.", "Soporta los embates de la Legión.", "Surmontez l’épreuve de la Légion.", "Supera la barricata della Legione.", "군단의 시련을 이겨내야 합니다.", "Atravesse o mar de horrores da Legião", "Прорвитесь сквозь полчища Легиона.", "达成军团的挑战。", "通過燃燒軍團的阻礙。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["552"] = {
{ "Defeat the bosses of The Vortex Pinnacle", "Besiegt die Bosse auf dem Vortexgipfel.", "Derrota a los jefes de la Cumbre del Vórtice.", "Derrota a los jefes de La Cumbre del Vórtice.", "Terrassez les boss de la cime du Vortex.", "Sconfiggi i boss del Pinnacolo del Vortice.", "소용돌이 누각 우두머리들을 처치해야 합니다.", "Derrote os chefes do Pináculo do Vórtice.", "Победите боссов на Вершине Смерча", "击败旋云之巅的首领", "擊敗漩渦尖塔的首領", }, 
},
["1090"] = {
{ "Learn about being a Priest.", "Erfahrt etwas über das Leben als Priester.", "Infórmate sobre ser un sacerdote.", "Averigua más sobre ser un sacerdote.", "Apprenez-en davantage sur les prêtres.", "Impara il significato di essere un Sacerdote.", "사제에 대해 배워야 합니다.", "Aprenda sobre os Sacerdotes.", "Узнайте, что значит быть жрецом.", "学习如何成为一名牧师。", "學習如何當一名牧師。", }, 
{ "Learn about Shadow Word: Pain.", "Erfahrt mehr über 'Schattenwort: Schmerz'.", "Infórmate sobre Palabra de las Sombras: dolor.", "Averigua más sobre Palabra de las Sombras: dolor", "Apprenez-en davantage sur Mot de l’ombre : Douleur.", "Impara come usare Parola d'Ombra: Dolore.", "어둠의 권능: 고통에 대해 배워야 합니다.", "Aprenda sobre Palavra Sombria: Dor.", "Научитесь применять \"Слово Тьмы: Боль\".", "学习暗言术：痛。", "學習如何使用暗言術：痛。", }, 
{ "Learn about Penance.", "Erfahrt mehr über 'Sühne'.", "Infórmate sobre Penitencia.", "Averigua más sobre Penitencia.", "Apprenez-en davantage sur Pénitence.", "Impara come usare Contrizione.", "회개에 대해 배워야 합니다.", "Aprenda sobre Penitência.", "Научитесь применять \"Исповедь\".", "学习苦修。", "學習如何使用懺悟。", }, 
{ "Learn about Smite.", "Erfahrt mehr über 'Heilige Pein'.", "Infórmate sobre Punición.", "Averigua más sobre Punición.", "Apprenez-en davantage sur Châtiment.", "Impara come usare Punizione.", "성스러운 일격에 대해 배워야 합니다.", "Aprenda sobre Punição.", "Научитесь применять \"Кару\".", "学习惩击。", "學習如何使用懲擊。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Psychic Scream", "Erfahrt mehr über 'Psychischer Schrei'.", "Infórmate sobre Alarido psíquico.", "Averigua más sobre Alarido psíquico.", "Apprenez-en davantage sur Cri psychique.", "Impara come usare Urlo Psichico.", "영혼의 절규에 대해 배워야 합니다.", "Aprenda sobre Grito Psíquico", "Научитесь применять \"Ментальный крик\".", "学习心灵尖啸。", "學習如何使用心靈尖嘯。", }, 
{ "Learn about Power Word: Shield.", "Erfahrt mehr über 'Machtwort: Schild'.", "Infórmate sobre Palabra de poder: escudo.", "Averigua más sobre Palabra de poder: escudo.", "Apprenez-en davantage sur Mot de pouvoir : Bouclier.", "Impara come usare Parola del Potere: Scudo.", "신의 권능: 보호막에 대해 배워야 합니다.", "Aprenda sobre Palavra de Poder: Escudo.", "Научитесь применять \"Слово Силы: Щит\".", "学习真言术：盾。", "學習如何使用真言術：盾。", }, 
{ "Learn about Plea.", "Erfahrt mehr über 'Bittgebet'.", "Infórmate sobre Súplica.", "Averigua más sobre Súplica.", "Apprenez-en davantage sur Supplique.", "Impara come usare Supplica.", "탄원에 대해 배워야 합니다.", "Aprenda sobre Súplica.", "Научитесь применять \"Мольбу\".", "学习恳求。", "學習如何使用祈求。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["1050"] = {
{ "Infiltrate the Court of Stars and confront Grand Magistrix Elisande.", "Infiltriert den Hof der Sterne und stellt Großmagistrix Elisande.", "Infíltrate en la Corte de las Estrellas y enfréntate a la gran magistrix Elisande.", "Infíltrate en la Corte de Estrellas y confronta a la Gran magistrix Elisande.", "Infiltrez-vous dans la cour des Étoiles et affrontez la grande magistrice Élisande.", "Infiltrati nella Corte delle Stelle e affronta la Gran Magistra Elisande.", "별의 궁정에 잠입한 다음 대마법학자 엘리산드를 상대해야 합니다.", "Infiltre-se no Pátio das Estrelas e confronte a Grã-magistra Elisande.", "Проникните в Квартал Звезд и бросьте вызов Великому магистру Элисанде.", "渗透进群星庭院，与大魔导师艾利桑德对峙。", "潛入眾星之廷，面對大博學者艾莉珊德。", }, 
},
["1220"] = {
{ "The High Tinker's forces are preparing for battle. They'll need your help to stop Themaplugg in time.", "Die Streitkräfte des Hochtüftlers machen sich kampfbereit. Sie brauchen Eure Hilfe, um Thermadraht rechtzeitig aufzuhalten.", "Las fuerzas del Manitas Mayor se preparan para la batalla. Necesitarán tu ayuda para detener a Termochufe a tiempo.", "Las fuerzas de Manitas Mayor se preparan para la batalla. Necesitarán tu ayuda para detener a Termochufe antes de que sea demasiado tarde.", "Les troupes du Grand Bricoleur se préparent au combat. Votre aide leur sera nécessaire pour arrêter Thermojoncteur à temps.", "Le forze del Gran Meccanista si preparano alla battaglia. Avranno bisogno del tuo aiuto per fermare Termospin in tempo.", "땜장이 왕의 병력이 전투를 준비 중입니다. 텔마플러그를 제때 막으려면 당신의 도움이 필요합니다.", "As forças do Grão-faz-tudo estão se preparando para a batalha. Elas vão precisar da sua ajuda para deter Termaplugue a tempo.", "Отряд главного механика готовится к бою. Им нужна ваша помощь, чтобы вовремя остановить Термоштепселя.", "大工匠的部队已经做好了战斗准备。要想及时阻止瑟玛普拉格，他们还需要你的帮助。", "大工匠的部隊正在備戰。他們需要你及時阻止瑟瑪普拉格。", }, 
{ "Let High Tinker Mekkatorque know when you are ready.", "Gebt Hochtüftler Mekkadrill Bescheid, wenn Ihr bereit seid.", "Habla con el manitas mayor Mekkatorque cuando quieras.", "Avisa a Manitas Mayor Mekkatorque cuando quieras continuar.", "Faites savoir au Grand Bricoleur Mekkanivelle que vos préparatifs sont terminés.", "Fai sapere al Gran Meccanista Meccatork quando vuoi procedere.", "준비가 되면 땜장이왕 멕카토크에게 알려야 합니다.", "Avise o Grão-faz-tudo Mekkatorque quando você estiver tudo pronto.", "Когда будете готовы, поговорите с главным механиком Меггакрутом.", "做好准备后告诉大工匠梅卡托克。", "讓大工匠梅卡托克知道你準備好了。", }, 
{ "You must prevent Thermaplugg's missile from launching to the Broken Isles!", "Ihr müsst verhindern, dass Thermadraht seine Rakete auf die Verheerten Inseln abfeuert!", "¡Debes evitar que el misil de Termochufe despegue hacia la Costa Abrupta!", "¡Debes impedir que el misil de Termochufe se lance hacia las Islas Quebradas!", "Vous devez empêcher le lancement du missile de Thermojoncteur sur les îles Brisées !", "Devi impedire il lancio del missile di Termospin verso le Isole Disperse!", "텔마클러그가 미사일을 부서진 섬으로 발사하지 못하게 막아야 합니다.", "Você precisa impedir que o míssil do Termaplugue seja lançado contra as Ilhas Partidas!", "Предотвратите запуск ракеты Термоштепселя на Расколотые острова.", "必须阻止瑟玛普拉格向破碎群岛发射导弹！", "你必須阻止瑟瑪普拉格朝破碎群島發射飛彈！", }, 
{ "It's time to put an end to Sicco Thermaplugg's reign of terror once and for all.", "Es ist Zeit, Sicco Thermadrahts Schreckensherrschaft ein für alle Mal zu beenden.", "Es hora de poner fin al reinado de terror de Sicco Termochufe de una vez por todas.", "Es hora de terminar con el reino del terror de Sicco Termochufe de una vez por todas.", "Il est temps de mettre fin au règne de terreur de Psiko Thermojoncteur.", "È giunta l'ora di porre fine una volta per tutte al regno di terrore di Sicco Termospin.", "시코 텔마플러그의 공포 통치를 영원히 끝내야 할 때가 왔습니다.", "Está na hora de pôr um fim ao reinado de terror de Lok Termaplugue de uma vez por todas.", "Пора положить конец террору Сикко Термоштепселя раз и навсегда.", "是时候了，一举终结希科·瑟玛普拉格的恐怖统治吧。", "該讓希科·瑟瑪普拉格的恐怖統治到此結束了。", }, 
},
["1282"] = {
{ "Free the captured Storm Drakes.", "Befreit die gefangenen Sturmdrachen.", "Libera a los dracos de tormenta capturados.", "Libera a los dracos de la tormenta.", "Libérez les drakes-tempête captifs.", "Libera i Drachi della Tempesta catturati.", "사로잡힌 폭풍 비룡을 풀어줘야 합니다.", "Liberte os Dracos da Tempestade capturados.", "Освободите пленных штормовых драконов.", "救出被俘的风暴幼龙。", "解救被俘虜的風暴飛龍。", }, 
{ "Use the storm drakes to eliminate the Legion's ground forces.", "Setzt die Sturmdrachen ein, um die Bodentruppen der Legion auszuschalten.", "Utiliza los dracos de tormenta para eliminar a las tropas de la Legión.", "Usa los dracos para eliminar a las fuerzas terrestres de la Legión.", "Utilisez les drakes-tempête pour anéantir les troupes au sol.", "Usa i Drachi della Tempesta per eliminare le forze di terra della Legione.", "폭풍 비룡을 사용해 군단의 지상 병력을 제거해야 합니다.", "Use os Dracos da Tempestade para eliminar as forças terrestres da Legião.", "С помощью драконов ликвидируйте наземные войска Легиона.", "使用风暴幼龙消灭军团的地面部队。", "用風暴飛龍來消滅燃燒軍團的地面部隊。", }, 
{ "Get to the Legion Ship.", "Gelangt zum Legionsschiff.", "Ve a la nave de la Legión.", "Sube a la nave de la Legión.", "Atteignez le vaisseau de la Légion.", "Raggiungi la Nave della Legione.", "군단 함선으로 가야 합니다.", "Chegue à nave da Legião.", "Проберитесь на корабль Легиона.", "登上军团战舰。", "登上燃燒軍團船艦。", }, 
{ "Sabotage the Legion forces on board the ship.", "Sabotiert die Streitkräfte der Legion an Bord des Schiffs.", "Sabotea a las tropas de la Legión a bordo de la nave.", "Sabotea las fuerzas de la Legión a bordo de la nave.", "Sabotez les installations de la Légion à bord du vaisseau.", "Sabota le forze della Legione sulla nave.", "함선 위의 군단 병력을 처치해야 합니다.", "Sabote as forças da Legião a bordo do navio.", "Устройте диверсию на борту корабля Легиона.", "消灭战舰上的军团部队。", "消滅燃燒軍團在船艦上的部隊。", }, 
{ "Defeat Lord Commander Alexius and disable the ship's capabilities.", "Besiegt Lordkommandant Alexius und macht das Schiff unschädlich.", "Derrota al lord comandante Alexius e inutiliza la nave.", "Derrota al comandante Lord Alexius y anula las capacidades de la nave.", "Tuez le seigneur-commandant Alexius et neutralisez le vaisseau.", "Sconfiggi il Sire Comandante Alexius e metti fuori uso la nave.", "군주 사령관 알렉시우스를 처치하고 함선의 기능을 무력화해야 합니다.", "Derrote o Lorde Comandante Alexius e desative as capacidades do navio.", "Победите лорда-командующего Алексиса и устройте диверсию на корабле.", "击败总指挥官艾里克苏斯并破坏战舰的功能。", "擊敗領主指揮官埃勒克席斯並且癱瘓船艦。", }, 
{ "Use the Storm Drakes to extract.", "Verschwindet mithilfe der Sturmdrachen.", "Utiliza a los dracos de tormenta para la extracción.", "Utiliza a los dracos de la tormenta para escapar.", "Utilisez les drakes-tempête pour vous enfuir.", "Usa i Drachi della Tempesta per fuggire.", "폭풍 비룡을 사용해 빠져나와야 합니다.", "Use os Dracos da Tempestade para escapar.", "Покиньте корабль на штормовых драконах.", "使用风暴幼龙撤离。", "利用風暴飛龍撤離。", }, 
},
["1181"] = {
{ "Learn about being a Druid.", "Erfahrt etwas über das Leben als Druide.", "Infórmate sobre ser un druida.", "Averigua más sobre ser un druida.", "Apprenez-en davantage sur les druides.", "Impara il significato di essere un Druido.", "드루이드에 대해 배워야 합니다.", "Aprenda sobre os Druidas.", "Узнайте, что значит быть друидом.", "学习如何成为一名德鲁伊。", "學習如何當一名德魯伊。", }, 
{ "Learn about Moonkin Form.", "Erfahrt mehr über 'Mondkingestalt'.", "Infórmate sobre Forma de lechúcico lunar.", "Averigua más sobre la Forma de lechúcico lunar.", "Apprenez-en davantage sur Forme de sélénien.", "Impara come usare la Forma di Lunagufo.", "달빛야수 변신에 대해 배워야 합니다.", "Aprender sobre Forma de Luniscante.", "Научитесь применять \"Облик лунного совуха\".", "学习枭兽形态", "學習如何使用梟獸形態。", }, 
{ "Learn about Moonfire and Sunfire.", "Erfahrt mehr über 'Mondfeuer' und 'Sonnenfeuer'.", "Infórmate sobre Fuego lunar y Fuego solar.", "Averigua más sobre Fuego lunar y Fuego solar.", "Apprenez-en davantage sur Éclat lunaire et Éclat solaire.", "Impara come usare Fuoco Lunare e Fuoco Solare.", "달빛섬광과 태양섬광에 대해 배워야 합니다.", "Aprender sobre Fogo Lunar e Fogo Solar.", "Научитесь применять \"Лунный огонь\" и \"Солнечный огонь\".", "学习月火术和阳炎术。", "學習如何使用月火術和日炎術。", }, 
{ "Learn about Solar Wrath.", "Erfahrt mehr über 'Solarzorn'.", "Infórmate sobre Cólera solar.", "Averigua más sobre Cólera solar.", "Apprenez-en davantage sur Courroux solaire.", "Impara come usare Ira Solare.", "태양의 격노에 대해 배워야 합니다.", "Aprender sobre Ira Solar.", "Научитесь применять \"Солнечный гнев\".", "学习阳炎之怒。", "學習如何使用太陽之怒。", }, 
{ "Learn about Starsurge.", "Erfahrt mehr über 'Sternensog'.", "Infórmate sobre Oleada de estrellas.", "Averigua más sobre Oleada de estrellas.", "Apprenez-en davantage sur Éruption stellaire.", "Impara come usare Cometa Arcana.", "별빛쇄도에 대해 배워야 합니다.", "Aprenda sobre Surto Estelar.", "Научитесь применять \"Звездный поток\".", "学习星涌术。", "學習如何使用星湧術。", }, 
{ "Learn about Lunar Strike.", "Erfahrt mehr über 'Lunarschlag'.", "Infórmate sobre Golpe lunar.", "Averigua sobre el Golpe lunar.", "Apprenez-en davantage sur Frappe lunaire.", "Impara come usare Ira Lunare.", "달의 일격에 대해 배워야 합니다.", "Aprenda sobre Golpe Lunar.", "Научитесь применять \"Лунный удар\".", "学习明月打击。", "學會如何使用月光之擊。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Healing Touch.", "Erfahrt mehr über 'Heilende Berührung'.", "Infórmate sobre Toque de sanación.", "Averigua más sobre Toque de sanación.", "Apprenez-en davantage sur Toucher guérisseur.", "Impara come usare Tocco Curativo.", "치유의 손길에 대해 배워야 합니다.", "Aprenda sobre Toque de Cura.", "Научитесь применять \"Целительное прикосновение\".", "学习治疗之触。", "學習如何使用治療之觸。", }, 
{ "Learn about Entangling Roots.", "Erfahrt mehr über 'Wucherwurzeln'.", "Infórmate sobre Raíces enredadoras.", "Averigua más sobre Raíces enredadoras.", "Apprenez-en davantage sur Sarments.", "Impara come usare Radici Avvolgenti.", "휘감는 뿌리에 대해 배워야 합니다.", "Aprender sobre Raízes Enredantes.", "Научитесь применять \"Гнев деревьев\".", "学习纠缠根须。", "學習如何使用糾纏根鬚。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你学会的技艺击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你学会的技艺同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["664"] = {
{ "Defeat the bosses of Maraudon", "Bezwingt die Bosse von Maraudon.", "Derrota a los jefes de Maraudon", "Derrota a los jefes de Maraudon", "Triomphez des boss de Maraudon.", "Sconfiggi i boss di Maraudon.", "마라우돈 우두머리들을 처치해야 합니다.", "Derrote os chefes de Maraudon", "Победите боссов в Мародоне", "击败玛拉顿的首领", "擊敗的首領", }, 
{ "Defeat Rotgrip", "Bezwingt Faulschnapper", "Derrota a Escamapodrida", "Derrota a Escamapodrida", "Triomphez de Grippe-charogne.", "Sconfiggi Morsodrillo.", "썩은아귀를 처치해야 합니다.", "Derrote Putrigarra", "Победите Гнилопасть", "击败洛特格里普", "擊敗洛特格里普", }, 
},
["1275"] = {
{ "Choose 2 paladins to accompany you through Stratholme.", "Wählt zwei Paladine aus, die Euch durch Stratholme begleiten sollen.", "Elige a 2 paladines para que te acompañen por Stratholme.", "Elige a 2 paladines para que te acompañen en Stratholme.", "Choisissez deux paladins pour vous accompagner à Stratholme.", "Scegli 2 Paladini che ti accompagnino attraverso Stratholme.", "스트라솔름에서 함께할 2명의 성기사를 선택해야 합니다.", "Escolha 2 paladinos para acompanharem você em Stratholme.", "Выберите двух паладинов, которые будут сопровождать вас в Стратхольме.", "选择两名圣骑士陪伴你穿过斯坦索姆。", "選2名聖騎士陪你進入斯坦索姆。", }, 
{ "Search Stratholme for stashes of holy water and the three missing paladins. Destroy any unholy abominations you come across.", "Durchsucht Stratholme nach Weihwasser und den drei vermissten Paladinen. Vernichtet unheilige Monstrositäten, falls Ihr ihnen begegnet.", "Busca alijos de agua bendita y encuentra a los tres paladines perdidos en Stratholme. Destruye a las abominaciones profanas que te encuentres.", "Busca reservas de agua bendita en Stratholme y encuentra a los tres paladines perdidos. Destruye todas las abominaciones profanas que se te crucen en el camino.", "Fouillez Stratholme à la recherche de caches d’eau bénite et des trois paladins portés disparus. Détruisez toutes les abominations impies que vous rencontrez.", "Esplora Stratholme alla ricerca dell'Acqua Santa e dei tre Paladini dispersi. Elimina qualsiasi abominio empio dovessi incontrare.", "스트라솔름을 수색하여 성수가 담긴 상자와 3명의 사라진 성기사를 찾고, 마주치는 모든 불경한 피조물을 쓰러뜨려야 합니다.", "Procure água benta e os três paladinos perdidos em Stratholme. Destrua todas as abominações profanas que encontrar pela frente.", "Отыщите в Стратхольме тайники со святой водой и трех пропавших паладинов. Уничтожьте всех монстров, что встретятся вам на пути.", "搜索斯坦索姆，寻找藏匿的圣水和三位失踪的圣骑士。消灭你遇到的一切邪恶怪物。", "在斯坦索姆尋找聖水和三名失蹤的聖騎士。消滅你遇到的邪惡怪物。", }, 
{ "Retrun to Grayson and give him the holy water.", "Kehrt zu Grayson zurück und gebt ihm das Weihwasser.", "Vuelve con Grayson y entrégale el agua bendita.", "Regresa con Grisillo y entrégale el agua bendita.", "Retournez voir Grayson et confiez-lui l’eau bénite.", "Porta l'Acqua Santa a Grayson.", "그레이슨에게 돌아가 성수를 주어야 합니다.", "Fale novamente com Grayson e entregue a água benta.", "Вернитесь к Грейсону и отдайте ему святую воду.", "回到格雷森处并将圣水交给他。", "把聖水拿回去給格雷森。", }, 
{ "Channel your holy power through your artifact weapon onto the barding.", "Kanalisiert Eure heilige Kraft durch Eure Artefaktwaffe und in das Geschirr.", "Utiliza tu artefacto para canalizar tu poder Sagrado hacia la barda.", "Canaliza el poder sagrado en la gualdrapa a través de tu artefacto.", "Transférez votre puissance sacrée au caparaçon à l’aide de votre arme prodigieuse.", "Canalizza i tuoi poteri sacri sulla bardatura attraverso il tuo Artefatto.", "유물 무기를 통해 마갑에 신성한 힘을 주입해야 합니다.", "Canalize poder sagrado para a barda com a sua arma-artefato.", "Направьте энергию Света из своего артефакта в конский доспех.", "引导你的神圣能量，通过神器将其灌注给骑甲。", "用你的神兵武器引導聖能，注入坐騎護具。", }, 
{ "Find Baron Rivendare's remains in his crypt at the heart of Stratholme.", "Findet die Überreste von Baron Totenschwur in seiner Gruft mitten in Stratholme.", "Encuentra los restos del barón Osahendido en su cripta, en el corazón de Stratholme.", "Encuentra los restos del Barón Osahendido en su cripta, en el centro de Stratholme.", "Trouvez la dépouille du baron Vaillefendre dans sa crypte, au cœur de Stratholme.", "Trova i resti del Barone Fieramorte nella sua cripta nel cuore di Stratholme.", "스트라솔름 중심부에 위치한 남작 리븐데어의 지하 묘지에서 그의 유해를 찾아야 합니다.", "Encontre os restos mortais do Barão Rivendare na cripta dele no coração de Stratholme.", "Найдите останки барона Ривендера в его склепе в Стратхольме.", "在斯坦索姆中心的瑞文戴尔男爵的墓穴里找到他的遗体。", "前往斯坦索姆，在瑞文戴爾男爵的墓穴中找到他的遺骸。", }, 
{ "Kill Raemien the Soultaker", "Tötet Raemien den Seelenräuber.", "Mata a Raemien el Robaalmas.", "Mata a Raemien, el Robaalmas", "Tuez Raëmien le Faucheur d’âmes.", "Uccidi Raemien il Ladro d'Anime.", "영혼강탈자 래미엔을 쓰러뜨려야 합니다.", "Mate Raemien, o Tomalmas.", "Убейте Рэмиена Собирателя Душ.", "击杀夺魂者雷曼", "殺死『奪魂者』瑞密安", }, 
{ "When you're ready to leave, speak with Grayson and he'll see you returned to Light's Hope Chapel.", "Sprecht mit Grayson, wenn Ihr zum Aufbruch bereit seid, dann bringt er Euch zur Kapelle des Hoffnungsvollen Lichts zurück.", "Cuando quieras partir, habla con Grayson y te devolverá a la Capilla de la Esperanza de la Luz.", "Cuando quieras partir, habla con Grisillo y él se encargará de que regreses a la Capilla de la Esperanza de la Luz.", "Au moment de partir, allez voir Grayson qui vous aidera à retourner la chapelle de l’Espoir de Lumière.", "Quando vuoi partire, parla con Grayson e ti farà tornare alla Cappella della Luce.", "떠날 준비가 되면, 그레이슨과 대화하십시오. 그가 희망의 빛 예배당으로 보내 줄 것입니다.", "Quando quiser partir, fale com Grayson e ele levará você de volta à Capela Esperança da Luz.", "Поговорите с Грейсоном, когда будете готовы вернуться в часовню Последней Надежды.", "你准备好离开后，就与格雷森谈一谈。他会将你送回圣光之愿礼拜堂。", "等你準備好離開，就跟格雷森交談，他會幫助你回到聖光之願禮拜堂。", }, 
},
["733"] = {
{ "Follow the Sergeant", "Folgt dem Unteroffizier", "Sigue al Sargento.", "Sigue al sargento", "Suivez le sergent.", "Segui il Sergente.", "하사관을 따라가야 합니다.", "Siga o Sargento", "Следуйте за сержантом", "追随中士", "跟隨士官", }, 
{ "Defeat the assault", "Wehrt den Angriff ab.", "Derrota a los asaltantes.", "Supera el asalto", "Survivez à l’assaut.", "Respingi l'assalto.", "습격을 막아내야 합니다.", "Derrote os agressores", "Убейте нападающих", "击退突袭的敌人", "擊退襲擊者", }, 
{ "Hold against the Shadow Council", "Haltet die Stellung gegen den Schattenrat.", "Aguanta contra el Consejo de la Sombra.", "Resiste contra el Consejo de la Sombra.", "Tenez contre le Conseil des ombres.", "Resisti all'attacco del Concilio dell'Ombra", "어둠의 의회의 공격을 막아내야 합니다.", "Resistir contra o Concílio das Sombras", "Продержитесь против Совета Теней", "击退暗影议会", "抵抗暗影議會的侵攻", }, 
{ "Defeat the remaining Shadow Council forces", "Besiegt die verbleibenden Truppen des Schattenrats.", "Derrota a las fuerzas del Consejo de la Sombra restantes.", "Derrota a las fuerzas del Consejo de la Sombra restantes", "Terrassez les derniers agents du Conseil des ombres.", "Sconfiggi le forze restanti del Concilio dell'Ombra.", "남은 어둠의 의회 병력을 물리쳐야 합니다.", "Derrote as forças restantes do Concílio das Sombras", "Одержите победу над оставшимися силами Совета Теней.", "击败暗影议会的残余部队。", "擊敗剩下的暗影議會部隊。", }, 
{ "Go to the Town Center.", "Geht zur Ortsmitte.", "Vuelve al centro de la ciudad.", "Ve al centro del pueblo.", "Gagnez le centre-ville.", "Raggiungi il centro del villaggio.", "마을 중앙으로 가야 합니다.", "Ir para o centro da cidade.", "Отправляйтесь в центр гарнизона.", "前往镇中心。", "前往城鎮中心。", }, 
{ "Defeat the Abyssal Invader.", "Bezwingt den Abyssaleindringling.", "Derrota al invasor abisal.", "Derrota al invasor abisal.", "Terrassez l’envahisseur abyssal.", "Sconfiggi l'Invasore Abissale.", "심연의 침략자를 처치해야 합니다.", "Derrotar o Invasor Abissal", "Победите абиссала-захватчика.", "击败深渊入侵者。", "擊敗深淵入侵者。", }, 
{ "Bronze: Earn 300 Points", "Bronze: Verdient 300 Punkte.", "Bronce: Gana 300 puntos.", "Bronce: obtén 300 puntos", "Bronze : Obtenir 300 points", "Bronzo: ottieni 300 punti.", "동메달: 300점을 획득해야 합니다.", "Bronze: Obter 300 Pontos", "Бронза: заработайте 300 очков", "青铜：获得300点", "青銅：獲得300分", }, 
{ "Silver: Earn 600 Points.", "Silber: Verdient 600 Punkte.", "Plata: Gana 600 puntos.", "Plata: obtén 600 puntos.", "Argent : Obtenir 600 points.", "Argento: ottieni 600 punti.", "은메달: 600점을 획득해야 합니다.", "Prata: Obter 600 Pontos.", "Серебро: заработайте 600 очков", "白银：获得600点", "白銀：獲得600分", }, 
{ "Gold: Earn 1000 Points", "Gold: Verdient 1000 Punkte.", "Oro: Gana 1000 puntos.", "Oro: obtén 1000 puntos", "Or : Obtenir 1 000 points", "Oro: ottieni 1.000 punti.", "금메달: 1000점을 획득해야 합니다.", "Ouro: Obter 1000 Pontos", "Золото: заработайте 1000 очков", "黄金：获得1000点", "黃金：獲得1000分", }, 
{ "Platinum: Earn 1300 Points", "Platin: Verdient 1300 Punkte.", "Platino: Gana 1300 puntos", "Platino: obtén 1300 puntos", "Platine : Obtenir 1 300 points", "Platino: ottieni 1.300 punti.", "백금메달: 1300점을 획득해야 합니다.", "Platina: Obter 1300 pontos", "Платина: заработайте 1300 очков", "白金：获得1300点", "白金：獲得1300分", }, 
},
["254"] = {
{ "Stage 0", "Phase 0", "Fase 0.", "Fase 0", "Stage 0", "Fase 0", "0단계", "Estágio 0", "Этап 0", "Stage 0", "階段0", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "The End!", "Das Ende!", "¡Fin!", "¡Fin!", "La fin !", "La fine!", "완료했습니다!", "Fim!", "Конец!", "尾声！", "結束！", }, 
},
["662"] = {
{ "Defeat the bosses of Foulspore Caverns", "Bezwingt die Bosse der Faulsporenhöhlen.", "Derrota a los jefes de las Grutas de la Espora Fétida", "Derrota a los jefes de las Grutas de la Espora Fétida", "Triomphez des boss de la caverne Vilespore.", "Sconfiggi i boss della Caverna Spora Funesta.", "썩은포자 동굴 우두머리들을 처치해야 합니다.", "Derrote os chefes da Caverna Esporelama", "Победите боссов в Зловонной пещере", "击败毒菇洞穴的首领", "擊敗毒菇洞穴的首領", }, 
},
["668"] = {
{ "Defeat the bosses of Dire Maul", "Bezwingt die Bosse von Düsterbruch.", "Derrota a los jefes de La Masacre.", "Derrota a los jefes de La Masacre", "Triomphez des boss de Hache-Tripes.", "Sconfiggi i boss di Maglio Infausto.", "혈투의 전장 우두머리들을 처치해야 합니다.", "Derrote os chefes do Gládio Cruel", "Победите боссов в Забытом Городе", "击败厄运之槌的首领", "擊敗厄運之槌的首領", }, 
{ "Defeat Stomper Kreeg", "Bezwingt Stampfer Kreeg", "Derrota al vapuleador Kreeg.", "Derrotar a Vapuleador Kreeg", "Triomphez de Kreeg le Marteleur.", "Sconfiggi Kreeg il Pestatore.", "천둥발 크리그를 처치해야 합니다.", "Derrote o Pisoteador Kreeg", "Победите Топотуна Крига", "击败践踏者克雷格", "擊敗踐踏者克雷格", }, 
{ "Defeat Cho'Rush the Observer", "Bezwingt Cho'Rush den Beobachter", "Derrota a Cho'Rush el Observador.", "Derrota a Cho'Rush el Observador", "Triomphez de Cho’Rush l’Observateur.", "Sconfiggi Cho'rush l'Osservatore.", "정찰병 초루쉬를 처치해야 합니다.", "Derrote Ez'Magg, o Observador", "Победите Чо'Раша Наблюдателя", "击败观察者克鲁什", "擊敗『觀察者』克魯什", }, 
{ "Defeat Prince Tortheldrin", "Bezwingt Prinz Tortheldrin", "Derrota al príncipe Tortheldrin.", "Derrota al príncipe Tortheldrin", "Triomphez du prince Tortheldrin.", "Sconfiggi il Principe Tortheldrin.", "왕자 토르텔드린을 처치해야 합니다.", "Derrote o Príncipe Tortheldrin", "Победите принца Тортелдрина", "击败托塞德林王子", "擊敗托塞德林王子", }, 
},
["1169"] = {
{ "Cleanse the area of Azshara's servants.", "Löscht alle Diener Azsharas in der Umgebung aus.", "Despeja la zona de sirvientes de Azshara.", "Despeja el área de los sirvientes de Azshara.", "Éliminez les serviteurs d’Azshara présents dans la zone.", "Purifica l'area dai servi di Azshara.", "아즈샤라의 하수인들을 없애야 합니다.", "Remova da área os servidores de Azshara.", "Очистите территорию от слуг Азшары.", "净化艾萨拉仆从的区域。", "掃蕩那個區域，殺光艾薩拉的手下。", }, 
},
["555"] = {
{ "Defeat the bosses of the Lost City of the Tol'vir", "Besiegt die Bosse in der Verlorenen Stadt der Tol'vir.", "Derrota a los jefes de la Ciudad Perdida de los Tol'vir.", "Derrota a los jefes de la Ciudad Perdida de los Tol'vir.", "Terrassez les boss de la cité perdue des Tol’vir.", "Sconfiggi i boss della Città Perduta dei Tol'vir.", "톨비르의 잃어버린 도시 우두머리들을 처치해야 합니다.", "Derrote os chefes da Cidade Perdida dos Tol'vir", "Победите боссов в затерянном городе Тол'вире.", "击败托维尔失落之城的首领", "擊敗托維爾的失落之城的首領。", }, 
},
["785"] = {
{ "Drive back the fel invaders. #1", "", "", "Expulsa a los invadores viles. #1", "", "Respingi i Vilinvasori. #1", "지옥의 침략자를 물리쳐야 합니다. #1", "Rechace os invasores vis. #1", "", "击退邪能入侵者。#1", "擊退魔化入侵者。#1", }, 
{ "Defeat Lord Jaraxxus.", "Bezwingt Lord Jaraxxus.", "Derrota a lord Jaraxxus.", "Derrota a Lord Jaraxxus.", "Terrassez le seigneur Jaraxxus.", "Sconfiggi Sire Jaraxxus.", "군주 자락서스를 처치해야 합니다.", "Derrote Lorde Jaraxxus.", "Победите лорда Джараксуса.", "击败加拉克苏斯大王。", "擊敗賈拉克瑟斯領主。", }, 
},
["1026"] = {
{ "Make your way into the Dark Riders' catacombs beneath Karazhan.", "Bahnt Euch einen Weg in die Katakomben der Dunklen Reiter unter Karazhan.", "Ábrete paso hasta las catacumbas de los jinetes oscuros que hay bajo Karazhan.", "Llega hasta las catacumbas de los Jinetes oscuros, situadas en lo profundo de Karazhan.", "Frayez-vous un chemin dans les catacombes des cavaliers noirs qui s’étendent sous Karazhan.", "Fatti strada nelle catacombe dei Cavalieri Oscuri sotto Karazhan.", "카라잔 아래에 있는 암흑 기수의 지하무덤에 들어가야 합니다.", "Entre nas catacumbas dos Cavalgantes Negros, sob Karazhan.", "Проникните в катакомбы Темных всадников под Каражаном.", "前往卡拉赞下方的黑暗骑士的墓穴。", "進入卡拉贊地下墓穴追查黑騎兵的下落。", }, 
{ "Find a way to cross Ariden's spirit barrier.", "Findet einen Weg, um Aridens Geisterbarriere zu überwinden.", "Encuentra el modo de atravesar la barrera de espíritus de Ariden.", "Encuentra un modo de atravesar la barrera espiritual de Ariden.", "Trouvez un moyen de franchir la barrière spirituelle d’Ariden.", "Trova un modo per attraversare la barriera spirituale di Ariden.", "아리덴의 영혼 보호막을 통과할 방법을 찾아야 합니다.", "Encontre um jeito de atravessar a barreira espiritual de Ariden.", "Найдите способ преодолеть духовную преграду Аридена.", "想办法穿过埃瑞丁的灵魂屏障。", "想辦法越過埃瑞丁的靈魂屏障。", }, 
{ "Defeat the guardian of the Dark Riders' vault.", "Bezwingt den Wächter des Gewölbes der Dunklen Reiter.", "Derrota al guardián de la cámara de los jinetes oscuros.", "Derrota al guardián de la bóveda de los Jinetes oscuros.", "Terrassez le gardien du caveau des Cavaliers noirs.", "Sconfiggi il guardiano dei Cavalieri Oscuri.", "암흑 기수 금고의 관리자를 물리쳐야 합니다.", "Derrote o guardião da câmara dos Cavalgantes Negros.", "Победите хранителя сокровищ Темных всадников.", "击败黑暗骑士宝库的守护者。", "擊敗黑騎兵寶庫的保護者。", }, 
{ "Find Apocalypse among the Dark Riders' artifacts.", "Findet Apokalypse unter den Artefakten der Dunklen Reiter.", "Encuentra a Apocalipsis entre los artefactos de los jinetes oscuros.", "Encuentra a Apocalipsis entre los artefactos de los Jinetes oscuros.", "Trouvez Apocalypse parmi les armes prodigieuses des Cavaliers noirs.", "Trova Apocalisse tra gli artefatti dei Cavalieri Oscuri.", "암흑 기수의 유물을 뒤져 대재앙을 찾아야 합니다.", "Encontre Apocalipse entre os artefatos dos Cavalgantes Negros.", "Найдите Апокалипсис среди артефактов Темных всадников.", "在黑暗骑士的神器中找到天启。", "在黑騎兵的寶藏中找到天啟。", }, 
{ "Follow Ariden into the depths of the Karazhan catacombs.", "Folgt Ariden in die Tiefen der Katakomben von Karazhan.", "Sigue a Ariden hasta las profundidades de las Catacumbas de Karazhan.", "Sigue a Ariden hacia las profundidades de las catacumbas de Karazhan.", "Suivez Ariden dans les profondeurs des catacombes de Karazhan.", "Segui Ariden nelle profondità delle catacombe di Karazhan.", "카라잔 지하무덤 깊은 곳으로 도망친 아리덴을 추격해야 합니다.", "Siga Ariden até as profundezas das catacumbas de Karazhan.", "Следуйте за Ариденом вглубь катакомб Каражана.", "跟随埃瑞丁深入卡拉赞墓穴。", "深入卡拉贊地下墓穴，追上埃瑞丁。", }, 
{ "Follow and defeat Ariden.", "Folgt Ariden und bezwingt ihn.", "Sigue y derrota a Ariden.", "Sigue y derrota a Ariden.", "Suivez Ariden et terrassez-le.", "Segui e sconfiggi Ariden.", "아리덴을 추적한 다음 처치해야 합니다.", "Siga e derrote Ariden.", "Проследуйте за Ариденом, бросьте ему вызов и победите его.", "跟随并击败埃瑞丁。", "追上並擊敗埃瑞丁。", }, 
{ "Claim Apocalypse.", "Nehmt Apokalypse an Euch.", "Hazte con Apocalipsis.", "Reclama a Apocalipsis.", "Récupérez Apocalypse.", "Ottieni Apocalisse.", "대재앙을 획득해야 합니다.", "Tome Apocalipse.", "Заберите Апокалипсис.", "获取天启。", "取得天啟。", }, 
},
["1078"] = {
{ "Engage Akaari Shadowgore while you have the element of surprise.", "Greift Akaari Schattenblut an, während Ihr das Überraschungsmoment auf Eurer Seite habt.", "Enfréntate a Akaari Sangrenegra mientras cuentas con el factor sorpresa.", "Ataca a Akaari Sombrarboleda mientras que tengas el elemento de la sorpresa.", "Attaquez Akaari Sombre-Sang tant que vous bénéficiez de l’effet de surprise.", "Affronta Akaari Squartaombre sfruttando l'effetto sorpresa.", "아카리 섀도고어를 기습해야 합니다.", "Ataque Akaari Sombrassangue enquanto você ainda tem o elemento da surpresa.", "Атакуйте Акаари Кровавую Тьму, воспользовавшись элементом внезапности.", "对阿卡丽·影血展开突然袭击。", "趁有機會的時候，對艾可莉‧影血發動奇襲。", }, 
{ "The Soulkeeper is in a deep trance. Obtain the key he has dangling from his belt.", "Der Seelenbewahrer befindet sich einer tiefen Trance. Bringt den Schlüssel, der an seinem Gürtel baumelt, in Euren Besitz.", "El guardián de almas está en un trance profundo. Consigue la llave que cuelga de su cinturón.", "El Guardián de almas está en un profundo trance. Obtén la llave que cuelga de su cinturón.", "Le gardien d’âmes est plongé dans une transe profonde. Profitez-en pour prendre la clé suspendue à sa ceinture.", "Il Custode delle Anime è in uno stato di trance profondo. Recupera la chiave appesa alla sua cintura.", "영혼지킴이가 무아지경 상태입니다. 그의 허리띠에 매달려 있는 열쇠를 얻어야 합니다.", "O Devoralmas está num transe profundo. Obtenha a chave que está pendurada no cinto dele.", "Хранитель душ погружен в глубокий транс. Снимите у него с пояса ключ.", "缚魂者目前心无旁骛，把他腰带上的钥匙摘下来。", "靈魂守衛者陷入深層的沉思。拿走吊在他腰帶上的鑰匙。", }, 
{ "Now that you have the key, free yourself from the cage and reclaim your weapons.", "Jetzt, da Ihr den Schlüssel habt, könnt Ihr Euch aus dem Käfig befreien und Eure Waffen wieder an Euch nehmen.", "Ahora que tienes la llave, sal de la jaula y recupera tus armas.", "Ahora que tienes la llave, sal de la jaula y recupera tus armas.", "Maintenant que vous détenez la clé, sortez de votre cage et récupérez vos armes.", "Ora che possiedi la chiave, liberati dalla gabbia e impossessati delle armi.", "열쇠를 구했으니 철창에서 나와 무기를 회수해야 합니다.", "Agora que você tem a chave, liberte-se da jaula e recupere suas armas.", "Ключ у вас. Выберитесь из клетки и верните свое оружие.", "你已经有了钥匙，逃出牢笼并夺取你的武器。", "現在你拿到鑰匙了，逃出牢籠然後取回你的武器。", }, 
{ "Akaari has sent Inquisitor Xirus to stop you.", "Akaari hat Inquisitor Xirus entsandt, um Euch aufzuhalten.", "Akaari ha enviado al inquisidor Xirus para que te detenga.", "Akaari envió al Inquisidor Xirus a detenerte.", "Akaari a envoyé l’inquisiteur Xirus pour vous arrêter.", "Akaari ha inviato l'Inquisitore Xirus per fermarti.", "아카리가 심문관 지러스를 보내 당신을 저지하려 합니다.", "Akaari mandou o Inquisidor Xirus deter você.", "Акаари отправила инквизитора Зируса остановить вас.", "阿卡丽派审判官瑟鲁斯来阻止你。", "艾可莉派出審判官席羅斯來阻止你。", }, 
{ "Find Akaari Shadowgore atop the citadel.", "Sucht nach Akaari Schattenblut auf der Zitadelle.", "Encuentra a Akaari Sangrenegra en la cima de la ciudadela.", "Encuentra a Akaari Sombrarboleda en la parte superior de la ciudadela.", "Allez trouver Akaari Sombre-Sang au sommet de la citadelle.", "Trova Akaari Squartaombre sulla cima della cittadella.", "성채 꼭대기에 있는 아카리 섀도고어를 찾아야 합니다.", "Encontre Akaari Sombrassangue no alto da cidadela.", "Разыщите Акаари Кровавую Тьму на верхнем ярусе цитадели.", "找到位于城堡顶部的阿卡丽·影血。", "在要塞頂端找到艾可莉‧影血。", }, 
{ "Kill Akaari Shadowgore.", "Tötet Akaari Schattenblut.", "Mata a Akaari Sangrenegra.", "Mata a Akaari Sombrarboleda.", "Tuez Akaari Sombre-Sang.", "Uccidi Akaari Squartaombre.", "아카리 섀도고어를 처치해야 합니다.", "Mate Akaari Sombrassangue.", "Убейте Акаари Кровавую Тьму.", "消灭阿卡丽·影血。", "殺死艾可莉‧影血", }, 
{ "Wield the Fangs of the Devourer.", "Rüstet Euch mit den Reißzähnen des Verschlingers aus.", "Blande los Colmillos del Devorador.", "Blande los Colmillos del Devorador.", "Équipez-vous des crocs du Dévoreur.", "Recupera le Zanne del Divoratore.", "포식자의 송곳니를 획득해야 합니다.", "Empunhe as Presas do Devorador.", "Возьмите в руки Клыки Пожирателя.", "获取吞噬者之牙。", "取得吞噬者之牙。", }, 
},
["652"] = {
{ "Send High Inquisitor Whitemane to her final rest and put an end to the Scarlet Crusade.", "Legt Hochinquisitorin Weißsträhne für immer das Handwerk und macht dem Scharlachroten Kreuzzug ein Ende.", "Acaba de una vez por todas con la alta inquisidora Melenablanca y pon fin a la Cruzada Escarlata.", "Envía a la alta inquisidora Melenablanca a su descanso final y ponle un fin a los Cruzada Escarlata.", "Offrez le repos éternel à la grande inquisitrice Blanchetête et mettez fin à la Croisade écarlate.", "Elimina la Grande Inquisitrice Biancachioma e metti fine alla Crociata Scarlatta.", "종교재판관 화이트메인을 안식에 들게 하여 붉은십자군의 악행에 종지부를 찍어야 합니다.", "Enviar a Alta-inquisidora Cristalba para seu descanso final e dar um fim à Cruzada Escarlate.", "Помогите верховному инквизитору Вайтмейн обрести вечный покой и покончите с Алым орденом.", "让大检察官怀特迈恩安息并消灭血色十字军。", "讓高階審判官懷特邁恩安息，替血色十字軍劃下句點。", }, 
},
["430"] = {
{ "Investigate the overgrown Kirin Tor outpost.", "Untersucht den überwucherten Außenposten der Kirin Tor.", "Investiga la frondosa avanzada del Kirin Tor.", "Investiga el puesto de avanzada sobrecrecido del Kirin Tor.", "Explorez l’avant-poste du Kirin Tor envahi par la végétation.", "Ispeziona l'avamposto del Kirin Tor infestato dalla vegetazione.", "과성장이 벌어진 키린 토 전초기지를 조사해야 합니다.", "Investigue o posto avançado abandonado do Kirin Tor.", "Исследуйте заросшую заставу Кирин-Тора.", "调查植物丛生的肯瑞托岗哨。", "調查永茂林的祈倫托哨站。", }, 
},
["1175"] = {
{ "Board the Naglfar and face Helya in her own domain.", "Geht an Bord der Naglfar und tretet Helya in ihrem eigenen Reich entgegen.", "Sube a bordo del Naglfar y enfréntate a Helya en su propio territorio.", "Aborda el Naglfar y enfrenta a Helya en sus propios dominios.", "Montez à bord du Naglfar et affrontez Helya sur son propre terrain.", "Abborda la Naglfar e affronta Helya nel suo territorio.", "나글파르에 탑승하여, 헬리아의 영역에서 헬리아와 맞서야 합니다.", "Suba em Naglfar e enfrente Helya em seus próprios domínos.", "Проберитесь на борт \"Нагльфара\" и сразитесь с Хелией на ее территории.", "登上纳格法尔号，在海拉的领域面对她。", "登上奈格法號，在黑爾雅的地盤上對付她。", }, 
},
["630"] = {
{ "Defeat the bosses of The Underbog", "Bezwingt die Bosse des Tiefensumpfs.", "Derrota a los jefes de La Sotiénaga.", "Derrota a los jefes de La Sotiénaga.", "Terrassez les boss de la Basse-tourbière.", "Sconfiggi i boss della Torbiera Sotterranea.", "지하수렁 우두머리들을 처치해야 합니다.", "Derrote os chefes do Brejo Oculto", "Победите боссов в Нижетопи", "击败幽暗沼泽的首领", "擊敗深幽泥沼的首領", }, 
},
["1236"] = {
{ "Break down the door!", "Schlagt die Tür ein!", "¡Derriba la puerta!", "¡Derriba la puerta!", "Abattez la porte !", "Abbatti la porta!", "문을 부숴야 합니다!", "Derrube a porta!", "Выбейте дверь!", "打破大门！", "打破大門！", }, 
{ "Detox diseased Brewers and recover 8 Barrels of Storm Brew.", "Entgiftet erkrankte Brauer und bergt 8 Fässer Sturmgebräu.", "Desintoxica a los cerveceros enfermos y recupera 8 barriles de brebaje de tormenta.", "Desintoxica a los cerveceros enfermos y recupera 8 barriles de brebaje de tormenta.", "Détoxifiez les brasseurs malades et récupérez 8 tonneaux de breuvage des tempêtes.", "Disintossica i Birrai ammalati e recupera 8 Barili di Idromele della Tempesta.", "중독된 양조장이들을 해독하고 폭풍주 통 8개를 되찾아야 합니다.", "Desintoxique cervejeiros doentes e recupere 8 Barris de Cerva Tempestuosa.", "Примените заклинание \"Детоксикация\" к пораженным Скверной хмелеварам и соберите 8 бочек штормового меда.", "对中毒的酿酒师使用清创生血，并夺回8桶风暴蜜酒。", "為生病的釀酒師解毒並取回8桶風暴蜜酒。", }, 
{ "Break down to front doors to get outside.", "Schlagt die Vordertür ein, um nach draußen zu gelangen.", "Derriba las puertas principales y sal al exterior.", "Derriba las puertas de entrada para salir.", "Abattez les portes d’entrée pour sortir.", "Sfonda le porte principali per uscire all'esterno.", "정문을 부수고 밖으로 나가야 합니다.", "Quebre as portas da frente para poder sair.", "Сломайте парадную дверь и войдите.", "打破前门离开。", "打破前門出去。", }, 
{ "Drink the Storm Brew. You won't explode. Unless you are secretly a demon...", "Trinkt das Sturmgebräu. Ihr werdet nicht explodieren. Außer, Ihr seid in Wahrheit ein Dämon...", "Bebe el brebaje de tormenta. No explotarás. A no ser que seas un demonio encubierto...", "Bebe el brebaje de tormenta. No explotarás, a menos que seas un demonio encubierto...", "Buvez le breuvage des tempêtes sans crainte, vous ne risquez pas d’exploser. Du moins, si vous n’êtes pas un démon…", "Bevi l'Idromele della Tempesta. Non esploderai... a meno che tu non sia un demone...", "폭풍주를 마시십시오. 폭발하지 않을 겁니다. 당신이 변장한 악마가 아니라면요...", "Beba a Cerva Tempestuosa. Você não explodirá. A não ser que seja um demônio disfarçado...", "Выпейте штормовой мед. Он не разорвет вас на куски. Ну, если только вы не замаскировавшийся демон...", "饮用风暴蜜酒。你不会爆炸的，除非你是伪装的恶魔……", "把風暴蜜酒喝了。不會爆炸的。除非你的真實身分是惡魔…", }, 
{ "Close the legion portals to stop the attack on the brewery!", "Schließt die Legionsportale, um den Angriff auf die Brauerei aufzuhalten!", "¡Cierra los portales de la Legión para detener el ataque a la cervecería!", "¡Cierra los portales de la Legión para detener el ataque a la cervecería!", "Fermez les portails de la Légion pour endiguer l’attaque de la brasserie !", "Chiudi i portali della Legione per fermare l'attacco al birrificio!", "군단 차원문을 닫고 양조장에 대한 공격을 막아야 합니다!", "Feche os portais da Legião para impedir o ataque à cervejaria!", "Закройте порталы Легиона, чтобы отстоять хмелеварню.", "关闭军团传送门，阻止对酿酒厂的攻击！", "關閉燃燒軍團傳送門，阻止它們攻擊酒坊！", }, 
{ "Find Brewmaster Blanche!", "Findet Braumeisterin Blanche!", "¡Encuentra a la maestra cervecera Clara!", "¡Encuentra a la Maestra cervecera Clara!", "Trouvez la maître brasseuse Blanche !", "Trova il Mastro Birraio Blanche!", "양조사 블랜치를 찾아야 합니다!", "Encontre a Mestre Cervejeira Blanche!", "Найдите хмелевара Бланш!", "找到酒仙布兰琪！", "找到釀酒大師白蘭琪！", }, 
},
["1235"] = {
{ "Deviate the deviate critters that are flourishing in the caverns.", "Vernichtet die Deviatkleintiere, die in den Höhlen gedeihen.", "Evita a las criaturas descarriadas que proliferan en las cavernas.", "Vence a las alimañas descarriadas que proliferan en las cavernas.", "Éliminez les bestioles déviantes qui se multiplient dans ces cavernes.", "Elimina gli animaletti degeneri che hanno invaso queste caverne.", "동굴에 창궐하는 돌연변이 생물을 상대해야 합니다.", "Afaste as criaturas aberrantes que estão crescendo nas cavernas.", "Разберитесь с искаженными зверьками, обитающими в пещерах.", "击败哀嚎洞穴中滋生的变异小动物。", "擊敗洞穴中的變異小動物。", }, 
{ "The Son of Skum has awakened and blocks your way!", "Der Sohn des Skum ist erwacht und versperrt Euch den Weg!", "¡El hijo de Skum ha despertado y te bloquea el paso!", "¡El Hijo de Skum se ha despertado y te bloquea el paso!", "Le fils de Skum s’est réveillé et se met en travers de votre chemin !", "Il Figlio di Skum si è risvegliato e ti blocca la via!", "스컴의 자손이 깨어나 길을 막습니다!", "O Filho de Skória acordou e está bloqueando o nosso caminho!", "Потомок Шкама пробудился и преградил вам путь!", "斯卡姆之子醒来了，挡住了你的去路！", "斯卡姆之子甦醒，擋住了你的去路！", }, 
{ "Battle the companions of the cavern's former druid inhabitants.", "Bekämpft die Haustiere der früher in der Höhle wohnenden Druiden.", "Lucha contra los compañeros de los druidas que solían habitar la caverna.", "Lucha contra los compañeros de los druidas que habitaban las cavernas.", "Affrontez les mascottes des druides qui habitaient autrefois ces cavernes.", "Affronta i famigli dei Druidi che un tempo abitavano le caverne.", "한때 드루이드였던 이 동굴의 거주자들이 데리고 있는 친구들과 전투를 벌여야 합니다.", "Enfrente as mascotes dos druidas que moravam na caverna.", "Сразитесь со спутниками бывших друидов, населяющих пещеру.", "与曾经居住在洞穴中的德鲁伊的伙伴战斗。", "跟原本住在洞穴裡的德魯伊的夥伴戰鬥。", }, 
{ "Serpentis' own pet waits for you ahead.", "Serpentis' eigenes Haustier wartet weiter vorne auf Euch.", "La mascota de Serpentis te espera ahí delante.", "La mascota de Serpentis te espera más adelante.", "Le compagnon de Serpentis en personne vous attend.", "Il famiglio di Serpentis ti attende.", "서펜티스의 애완동물이 앞에서 당신을 기다립니다.", "O ajudante de Serpentis aguarda você mais à frente.", "Питомец Серпентиса ждет вас.", "瑟芬迪斯的宠物就在前面等你。", "瑟芬迪斯的寵物在前方等你。", }, 
{ "Deviate ectoplasm continues to grow within the cavern. Clear it out.", "Mutiertes Ektoplasma wuchert weiter in der Höhle. Beseitigt es.", "El ectoplasma descarriado sigue creciendo dentro de la caverna. Límpiala.", "Elimina el ectoplasma perverso que aún prolifera dentro de la caverna.", "Les ectoplasmes déviants se multiplient dans ces cavernes. Éradiquez-les.", "Un ectoplasma degenere continua a rigenerarsi all'interno della caverna. Eliminalo.", "돌연변이 세포괴물이 동굴 안에서 계속 자라나고 있습니다. 처리해야 합니다.", "Ectoplasma aberrante continua crescendo na caverna. Elimine-o.", "Искаженная эктоплазма все еще растет в пещере. Зачистите ее.", "变异细胞仍然在洞穴中繁殖。去清除它。", "變異軟漿怪持續在洞穴中生長。消滅它。", }, 
{ "Someone else is here! Confront them!", "Es ist noch jemand hier! Konfrontiert ihn!", "¡Aquí hay alguien más! ¡A por él!", "¡Tenemos compañía! ¡Debemos enfrentarla!", "Quelqu’un se cache ici ! Affrontez cet intrus !", "C'è qualcun altro qui! Affrontalo!", "누군가 여기 있습니다! 맞닥뜨려야 합니다!", "Tem mais alguém aqui! Enfrente-o!", "Здесь кто-то есть! Вступите в бой.", "这里有其他人！战胜他们！", "有人在這裡！去對付他們！", }, 
{ "A spore of Verdan the Everliving is re-growing. Destroy it before it grows to full strength.", "Eine Spore von Verdan dem Ewiglebenden wächst nach. Zerstört sie, bevor sie ihre volle Kraft entfalten kann.", "Una espora de Verdan el Eterno está volviendo a crecer. Destrúyela antes de que alcance todo su poder.", "Una espora de Verdan el Eterno está volviendo a crecer. Destrúyela antes de que alcance su fuerza máxima.", "Une spore de Verdan l’Immortel est en pleine croissance. Détruisez-la avant qu’elle n’arrive à maturité.", "Una spora di Verdan il Sempreverde sta ricrescendo. Distruggila prima che raggiunga il massimo della sua forza.", "영생의 베르단의 포자가 다시 자라고 있습니다. 완전한 힘을 갖추기 전에 물리쳐야 합니다.", "Um esporo de Verdan, o Sempre-vivo, está crescendo. Destrua-o antes que recupere toda a força.", "Спора Вердана Вечноживущего разрастается. Уничтожьте ее, пока она не обрела полную силу.", "永生者沃尔丹的孢子又开始生长了。在它恢复全部力量前摧毁它。", "永生的沃爾丹的孢子又重新生長出來了。摧毀它，別讓它完全成長。", }, 
},
["683"] = {
{ "Fight your way through the Depot to board the Grimrail.", "Kämpft Euch durch das Depot, um den Grimmzug zu besteigen.", "Ábrete paso a través de la terminal y sube al Malavía.", "Ábrete paso a través del Depósito y sube abordo del Riel Siniestro.", "Frayez-vous un chemin dans le dépôt pour monter à bord du Tristerail.", "Apriti la strada attraverso il deposito e sali sul Frecciacupa.", "정비소 안에서 전진해 파멸철로 기차에 올라타야 합니다.", "Abra caminho pela Central para embarcar no Carrilcruel.", "Проберитесь через депо и сядьте на поезд Мрачных Путей.", "杀进车站，登上恐轨号。", "擊敗敵人，從車站登上恐軌列車。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["1219"] = {
{ "asdf", "asdf", "asdf", "asdf", "asdf", "asdf", "asdf", "asdf", "asdf", "asdf", "asdf", }, 
{ "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", "asdfasdfasdf", }, 
},
["643"] = {
{ "Defeat the bosses of the Deadmines.", "Bezwingt die Bosse der Todesminen.", "Derrota a los jefes de Las Minas de la Muerte.", "Derrota a los jefes de las Minas de la Muerte.", "Triomphez des boss des Mortemines.", "Sconfiggi i boss delle Miniere della Morte.", "죽음의 폐광 우두머리들을 처치해야 합니다.", "Derrote os chefes das Minas Mortas.", "Победите боссов в Мертвых копях.", "击败死亡矿井的首领。", "擊敗死亡礦坑的首領。", }, 
},
["1202"] = {
{ "The teleport failed and you are outside the Sanctum. Find a way in.", "Der Teleport ist fehlgeschlagen und ihr seid außerhalb des Sanktums. Findet einen Weg ins Innere.", "El teletransporte ha fallado y estás fuera del Santuario. Encuentra la forma de entrar.", "La teletransportación falló y estás afuera del Sagrario. Encuentra la forma de entrar.", "La téléportation a échoué et vous êtes à l’extérieur du sanctum. Trouvez un moyen d’entrer.", "Il teletrasporto non ha funzionato e sei fuori dal Santuario. Trova un modo per entrare.", "순간이동이 실패하고 당신은 성소 밖에 남았습니다. 들어갈 방법을 찾으십시오.", "O teleporte não deu certo, e você ficou fora do Sacrário. Dê um jeito de entrar.", "Телепорт дал сбой, и вы оказались за пределами Святилища. Найдите способ пробраться внутрь.", "传送失败了，你位于大殿外面。找到进去的路。", "傳送失敗了，你現在位於秩序聖所外。想辦法進去。", }, 
{ "A magical barrier bars the way. Find someway to break it.", "Eine magische Barriere blockiert den Weg. Findet einen Weg, sie zu durchdringen.", "Un escudo mágico impide el paso. Encuentra la forma de romperlo.", "Una barrera mágica bloquea el camino. Busca la manera de romperla.", "Une barrière magique vous barre la route. Trouvez un moyen de la détruire.", "Una barriera magica blocca il passaggio. Trova un modo per sfondarla.", "마법 방벽이 길을 막았습니다. 파괴할 방법을 찾으십시오.", "Uma barreira mágica está no caminho. Dê um jeito de quebrá-la.", "Путь вам преграждает магический барьер. Найдите способ развеять его.", "魔法屏障挡住了路。想办法破坏它。", "這條路被某種魔法屏障擋住了。想辦法闖進去。", }, 
{ "Kill the ritualists at each Mana Generator to take down the barrier.", "Tötet die Ritualisten bei jedem Managenerator, um die Barriere zum Einsturz zu bringen.", "Mata a los ritualistas de cada generador de maná para destruir el escudo.", "Mata a los ritualistas en cada generador de maná para derribar la barrera.", "Tuez les ritualistes près de chaque générateur de mana pour détruire la barrière.", "Uccidi i Ritualisti presso ogni Generatore di Mana per disattivare la barriera.", "각각의 마나 생성기에 있는 의식술사들을 처치하고 방벽을 제거해야 합니다.", "Mate os ritualistas em cada gerador de mana para acabar com a barreira.", "Убейте ритуалистов у каждого из генераторов маны, чтобы развеять барьер.", "消灭每个法力发生器附近的祭仪师，消除屏障。", "殺死每個法力產生裝置旁的祭儀師，解除屏障。", }, 
{ "Armsmaster Dalion stands guard at the entrance. Slay him to proceed.", "Waffenmeister Dalion bewacht den Eingang. Tötet ihn, um ins Innere zu gelangen.", "El maestro de armas Dalion vigila la entrada. Mátalo para poder avanzar.", "El maestro de armas Dalion protege la entrada. Elimínalo para continuar.", "Le maître d’armes Dalion garde l’entrée. Tuez-le pour passer.", "Il Maestro d'Armi Dalion è a guardia dell'entrata. Devi eliminarlo per procedere.", "무기전문가 달리온이 입구를 지킵니다. 그를 처치해야 계속 전진할 수 있습니다.", "O Mestre Armeiro Dalion está vigiando a entrada. Mate-o para avançar.", "Вход охраняет воитель Далион. Убейте его и двигайтесь дальше.", "武器大师达里昂守卫在入口。消灭他，继续前进。", "武器大師達利昂擋在入口。殺死他，繼續前進。", }, 
{ "Make your way deep into the Sanctum of Order and find the breach.", "Stoßt tief ins Sanktum der Ordnung vor und findet die Bresche.", "Adéntrate en las profundidades del Santuario del Orden y encuentra la brecha.", "Adéntrate en el Sagrario de la Orden y encuentra la brecha.", "Enfoncez-vous dans le sanctum de l’Ordre et trouvez la brèche.", "Raggiungi le profondità del Santuario dell'Ordine e trova la breccia.", "질서의 성소 깊은 곳으로 들어가 균열을 찾아야 합니다.", "Vá às profundezas do Sacrário da Ordem e encontre a brecha.", "Проникните в самую глубину Святилища Порядка и отыщите пролом.", "深入秩序大殿，找到突破口。", "前往秩序聖所深處，找到缺口。", }, 
{ "Use Withered to Drain Andaris's shield.", "Setzt die Verdorrten ein, um Andaris' Schild zu schwächen.", "Usa a los Marchitos para drenar el escudo de Andaris.", "Usa a los marchitos para drenar el escudo de Andaris.", "Utilisez les Flétris pour drainer le bouclier d’Andaris.", "Usa Avvizzimento per indebolire lo scudo di Andaris.", "메마른 자들을 사용하여 안다리스의 보호막을 흡수하십시오.", "Use fenecidos para drenar o escudo de Andaris.", "Используйте иссохших, чтобы вытянуть энергию из щита Андарис.", "使用枯法者吸取安达丽斯的护盾。", "利用凋萎者吸收安妲麗絲的護盾。", }, 
{ "Andaris has fallen back to the breach. Slay her.", "Andaris hat sich zur Bresche zurückgezogen. Tötet sie.", "Andaris se ha retirado a la brecha. Mátala.", "Andaris retrocedió hacia la brecha. Mátala.", "Andaris s’est repliée vers la brèche. Tuez-la.", "Andaris si è ritirata presso la breccia. Uccidila.", "안다리스가 균열로 물러났습니다. 처치하십시오.", "Andaris recuou para a brecha. Mate-a.", "Андарис отступила к пролому. Убейте ее.", "安达丽斯退回到突破口了。干掉她。", "安妲麗絲退回缺口了。殺了她。", }, 
{ "The way is clear to the Nighthold. Secure the entrance.", "Der Weg zur Nachtfestung ist frei. Sichert den Eingang.", "El camino al Bastión Nocturno está despejado. Asegura la entrada.", "El camino hacia la Fortaleza Nocturna está despejado. Asegura la entrada.", "La voie est dégagée jusqu’au palais Sacrenuit. Sécurisez l’entrée.", "La strada per la Rocca della Notte è libera. Prendi il controllo dell'ingresso.", "밤의 요새로 통하는 길이 뚫렸습니다. 입구를 확보하십시오.", "O caminho está livre até o Baluarte da Noite. Proteja a entrada.", "Путь в Цитадель Ночи расчищен. Закрепитесь у входа.", "通向暗夜要塞的路已经打开了。肃清入口。", "通往暗夜堡的路已經清出來了。攻下入口。", }, 
},
["1310"] = {
{ "Find out what's happening to Akazamzarak's rabbits.", "Findet heraus, was mit Akazamzaraks Kaninchen geschieht.", "Descubre qué pasa con los conejos de Akazamzarak.", "Descubre lo que sucede con los conejos de Akazamzarak.", "Découvrez ce qui arrive aux lapins d’Akazamzarak.", "Scopri cosa sta succedendo ai conigli di Akazamzarak.", "아카잠자락의 토끼에게 무슨 일이 생겼는지 확인해야 합니다.", "Descubra o que está acontecendo com os coelhos de Akazamzarak.", "Выясните, что происходит с кроликами Ахалаймахалая.", "搞清楚阿卡扎曼扎拉克的兔子出了什么问题。", "看看阿卡贊札拉克的兔子發生了什麼事。", }, 
{ "Kill the Voracious Wolf that's eating Akazamzarak's rabbits.", "Tötet den hungrigen Wolf, der Akazamzaraks Kaninchen frisst.", "Mata al lobo voraz que se está comiendo a los conejos de Akazamzarak.", "Mata al lobo voraz que se está comiendo a los conejos de Akazamzarak.", "Tuez le loup vorace qui dévore les lapins d’Akazamzarak.", "Uccidi il Lupo Vorace che sta divorando i conigli di Akazamzarak.", "아카잠자락의 토끼를 먹고 있는 게걸스러운 늑대를 처치해야 합니다.", "Mate o lobo voraz que está comendo os coelhos de Akazamzarak.", "Убейте прожорливого волка, который охотится на кроликов Ахалаймахалая.", "击杀正在吃阿卡扎曼拉克兔子的贪吃的狼。", "殺死吃掉阿卡贊札拉克的兔子的貪噬狼。", }, 
{ "Leave Akazamzarak's Hat.", "Verlasst Akazamzaraks Hut.", "Sal del sombrero de Akazamzarak.", "Sal del sombrero de Akazamzarak.", "Sortez du chapeau d’Akazamzarak.", "Esci dal Cappello di Akazamzarak.", "아카잠자락의 모자를 떠나야 합니다.", "Saia do chapéu de Akazamzarak.", "Выйдите из шляпы Ахалаймахалая.", "离开阿卡扎曼拉克的帽子。", "離開阿卡贊札拉克的帽子。", }, 
},
["943"] = {
{ "The masters of the Peak of Serenity have gathered for a conclave.", "Die Meister des Gipfels der Ruhe sind zu einem Rat zusammengekommen.", "Los maestros del Pico de la Serenidad se han reunido para un cónclave.", "Los maestros del Pico de la Serenidad se reunieron para un cónclave.", "Les maîtres du pic de la Sérénité sont réunis en conclave.", "I maestri del Picco della Serenità si sono riuniti per un concilio.", "평온의 봉우리의 사부들이 논의를 위해 모였습니다.", "Os mestres do Pico da Serenidade se reuniram para um conclave.", "Мастера пика Безмятежности собрались на совет.", "晴日峰的宗师们聚集在一起召开会议。", "寂靜峰上的大師集結準備召開議會。", }, 
{ "Rescue Master Crane", "Rettet die Kranichmeisterin", "Rescata a la maestra Grulla.", "Rescata a la Maestra Grulla.", "Secourez la Grande grue.", "Salva il Maestro della Gru.", "주학 유파 사부를 구해야 합니다.", "Resgate Mestre Garça", "Спасите мастера школы Журавля.", "协助神鹤大师", "拯救鶴上師", }, 
{ "With Master Crane's help, reach the west temple grounds", "Erreicht mit der Hilfe des Kranichmeisters das westliche Tempelgelände.", "Llega a las tierras del templo del oeste con la ayuda de la maestra Grulla.", "Con ayuda de la Maestra Grulla, llega hasta las tierras al oeste del templo.", "Accédez à l’ouest du temple avec l’aide de la Grande grue.", "Con l'aiuto del Maestro della Gru, raggiungi la parte occidentale del tempio.", "주학 유파 사부의 도움을 받아 서쪽 사원 정원에 도착해야 합니다.", "Com a ajuda do Mestre Garça, alcance o pátio do templo oeste", "С помощью мастера школы Журавля доберитесь до западных храмовых земель.", "在神鹤大师的帮助下，抵达寺院西边的广场。", "透過鶴上師的協助，抵達西邊的寺廟", }, 
{ "Chen Stormstout was leading a children's class when the attack began. Rescue him and the children!", "Chen Sturmbräu gab gerade Kindern eine Lehrstunde, als der Angriff begann. Rettet ihn und die Kinder!", "Chen Cerveza de Trueno estaba dando clase a unos niños cuando comenzó el ataque. ¡Rescata a Chen y a los niños!", "Chen Cerveza de Trueno estaba impartiendo una clase de niños cuando comenzó el ataque. ¡Rescátalo a él y a los niños!", "Chen Brune d’Orage faisait la classe à de jeunes enfants quand l’attaque a commencé. Secourez-les, lui et ses élèves !", "Quando è cominciato l'attacco, Chen Triplo Malto stava tenendo una lezione ai bambini. Salvali!", "공격이 시작됐을 때 첸 스톰스타우트는 아이들을 가르치고 있었습니다. 첸과 아이들을 구해야 합니다!", "Chen Malte do Trovão estava com uma turma de crianças quando o ataque começou. Resgate todos!", "Чэнь Буйный Портер выводил юных учеников из храма, но на них напали демоны. Спасите Чэня и детей!", "袭击爆发时，陈·风暴烈酒正在给一群孩子上课。快去救他和那些孩子们！", "老陳‧風暴烈酒還在教導孩童時，攻擊就開始了。解救他跟孩童！", }, 
{ "Accompany Chen and the children back to the Temple.", "Begleitet Chen und die Kinder zurück zum Tempel.", "Acompaña a Chen y a los niños de regreso al templo.", "Acompaña a Chen y a los niños de regreso al Templo.", "Raccompagnez Chen et les enfants au temple.", "Accompagna Chen e i bambini nel tempio.", "첸과 아이들을 사원까지 데려가야 합니다.", "Acompanhe Chen e as crianças de volta ao Templo.", "Проводите Чэня и учеников до храма.", "获送陈和孩子们返回寺院。", "伴隨老陳跟孩童返回寺廟。", }, 
{ "The Demon known as Jorvinax has opened a gigantic portal! You must close it before the Legion can turn the Peak of Serenity into a foothold.", "Der als Jorvinax bekannte Dämon hat ein gigantisches Portal geöffnet! Ihr müsst es schließen, bevor die Legion den Gipfel der Ruhe zu einer ihrer Basen machen kann.", "El demonio conocido como Jorvinax ha abierto un portal gigantesco. Tienes que cerrarlo antes de que la Legión convierta el Pico de la Serenidad en su base.", "¡El Demonio conocido como Jorvinaz abrió un portal gigantesco! Debes cerrarlo antes de que la Legión se apodere del Pico de la Serenidad.", "Un démon du nom de Jorvinax a ouvert un portail colossal ! Vous devez le refermer avant que la Légion ne prenne pied au pic de la Sérénité.", "Il demone conosciuto come Jorvinax ha aperto un gigantesco portale! Devi chiuderlo prima che la Legione allestisca un avamposto al Picco della Serenità.", "악마 조르비낙스가 거대한 차원문을 열었습니다! 군단이 평온의 봉우리를 그들의 거점으로 삼기 전에 차원문을 닫아야 합니다.", "O demônio conhecido como Jorvinax abriu um imenso portal! Você tem que fechá-lo antes que a Legião transforme o Pico da Serenidade numa cabeça de ponte.", "Демон Жорвинакс открыл огромный портал! Вы должны закрыть его, пока Легион не превратил пик Безмятежности в свою базу.", "一个名叫乔维纳克斯的恶魔打开了一扇巨大的传送门！你必须关闭它，否则晴日峰将沦为军团的又一座桥头堡。", "有個叫做裘維納斯的惡魔開啟了一座巨大的傳送門！你務必要關閉它，別讓燃燒軍團踏平寂靜峰。", }, 
{ "With Jorvinax dead the portal is left unguarded. Find a way to destroy it!", "Mit Jorvinax' Tod ist das Portal unbewacht. Findet einen Weg, es zu zerstören!", "Con la muerte de Jorvinax, el portal ha quedado sin vigilancia. ¡Encuentra la forma de destruirlo!", "Con la muerte de Jorvinaz, el portal está deprotegido. ¡Busca la manera de destruirlo!", "Maintenant que Jorvinax est mort, le portail est sans défense. Trouvez un moyen de le détruire !", "Con la morte di Jorvinax, il portale è senza difese. Trova un modo per distruggerlo!", "조르비낙스가 죽자 차원문이 무방비 상태가 되었습니다. 차원문을 파괴할 방법을 찾아야 합니다!", "Com a morte de Jorvinax, o portal ficou desprotegido. Encontre um jeito de destruí-lo!", "Жорвинакс мертв, и портал остался без охраны. Найдите способ уничтожить его!", "乔维纳克斯已死，传送门已无人保护。想办法摧毁它！", "裘維納斯死後，傳送門就無人看守了。想辦法摧毀它！", }, 
},
["1204"] = {
{ "Xylem is draining Azeroth's Ley lines. You must stop him!", "Xylem entzieht den Leylinien Azeroths die Energie. Ihr müsst ihn aufhalten!", "Xylem está drenando las líneas Ley de Azeroth. ¡Debes detenerlo!", "Xylem está drenando las líneas ley de Azeroth. ¡Tienes que detenerlo!", "Xylem draine l’énergie des lignes telluriques d’Azeroth. Vous devez l’arrêter !", "Xylem sta risucchiando le linee di faglia di Azeroth. Devi fermarlo!", "실렘이 아제로스의 지맥을 고갈시키고 있습니다. 그를 막아야 합니다!", "Tauriel está drenando as linhas de meridiano de Azeroth. Você tem que impedi-lo!", "Ксилем вытягивает энергию из силовых линий Азерота. Его надо остановить!", "克希雷姆正在吸取艾泽拉斯的魔网能量。你必须阻止他！", "賽倫正在破壞艾澤拉斯的地脈。你得阻止他！", }, 
{ "Stop Xylem from channeling on the Focusing Iris.", "Haltet Xylem davon ab, auf die fokussierende Iris zu kanalisieren.", "Evita que Xylem canalice el iris de enfoque.", "Impide que Xylem siga canalizando energía a través del Iris de enfoque.", "Empêchez Xylem de siphonner l’iris de focalisation.", "Impedisci a Xylem di canalizzare l'Iride Focalizzante.", "실렘이 집중의 눈동자에 정신 집중하지 못하게 막아야 합니다.", "Impeça Tauriel de canalizar a Íris Focalizadora.", "Остановите верховного мага Ксилема.", "阻止克希雷姆对聚焦之虹进行引导。", "阻止賽倫引導聚源虹膜。", }, 
{ "The shadows within Xylem have been let loose! Protect Xylem as he restores the ley energy to Azeroth.", "Die Schatten in Xylem wurden entfesselt! Beschützt Xylem, während er Azeroths Leyenergie wiederherstellt.", "¡Las sombras del interior de Xylem se han desatado! Protege a Xylem mientras restaura la energía Ley en Azeroth.", "¡Las sombras ocultas en Xylem se han liberado! Protege a Xylem mientras devuelve la energía ley a Azeroth.", "Les ombres qui s’étaient insinuées dans l’esprit de Xylem l’ont enfin quitté ! Protégez-le pendant qu’il restaure l’énergie tellurique d’Azeroth.", "Xylem è preda della sua ombra interiore! Proteggilo mentre ripristina l'energia di faglia verso Azeroth.", "실렘을 지배하던 어둠이 풀려났습니다! 실렘이 마력을 아제로스에 돌려놓는 동안 그를 보호해야 합니다.", "As sombras dentro de Tauriel foram libertadas! Proteja Tauriel enquanto ele devolve a energia meridiana a Azeroth.", "Тьма, терзавшая Ксилема, вырвалась на свободу! Защищайте верховного мага, пока он возвращает энергию силовым линиям.", "克希雷姆身体中的阴影就要释放出来了！在克希雷姆为艾泽拉斯恢复魔网能量时保护好他。", "賽倫體內的黑暗竄出來了！保護賽倫，讓他恢復艾澤拉斯的地脈能量。", }, 
},
["1178"] = {
{ "Infiltrate the party being hosted by Advisor Melandrus.", "Schleicht Euch auf der von Berater Melandrus veranstalteten Feier ein.", "Infíltrate en la fiesta que da el consejero Melandrus.", "Cólate en la fiesta que organizó el Consejero Melandrus.", "Infiltrez-vous dans la soirée organisée par le conseiller Melandrus.", "Intrufolati alla festa del Consigliere Melandrus.", "조언가 멜란드루스가 주최하는 파티에 숨어들어가야 합니다.", "Infiltre-se no grupo recebido pelo Conselheiro Melandrus.", "Проникните на прием, который устраивает советник Меландр.", "混进顾问麦兰杜斯举行的宴会。", "潛入諫言者梅朗卓斯舉行的派對。", }, 
},
["1137"] = {
{ "You've entered the temple grounds. Meet with The Monkey King and prepare to head deeper into the complex.", "Ihr habt das Tempelgelände betreten. Trefft Euch mit dem Affenkönig und bereitet Euch darauf vor, tiefer in den Komplex vorzudringen.", "Has accedido a las tierras del templo. Reúnete con el Rey Mono y prepárate para adentrarte más en el complejo.", "Has entrado a las tierras del templo. Reúnete con el Rey Mono y prepárate para adentrarte más en el complejo.", "Vous avez pénétré dans l’enceinte du temple. Retrouvez le roi-singe et préparez-vous à vous enfoncer dans le complexe.", "Hai raggiunto il territorio del tempio. Incontra il Signore delle Scimmie e preparati a dirigerti nelle profondità del complesso.", "사원에 도착했습니다. 원숭이 왕을 만난 다음 사원 내부 깊숙이 들어갈 준비를 해야 합니다.", "Você adentrou as dependências do templo. Encontre o Rei Macaco e prepare-se para mergulhar fundo nas águas da complexidade.", "Итак, вы на территории храма. Встретьтесь с Королем обезьян и приготовьтесь следовать вглубь комплекса.", "你已经进入了寺庙的庭院中。和风涌大师谈谈，准备进入寺庙深处。", "你進入寺廟中了。跟美猴王碰面，準備繼續深入。", }, 
{ "The scribes are trapped within Scrollkeeper's Sanctum. Break in and rescue them!", "Die Schreiber sind im Sanktum des Schriftrollenhüters gefangen. Brecht ein und rettet sie!", "Los escribas están atrapados en El Sagrario del Escribiente. ¡Entra y rescátalos!", "Los escribas están atrapados dentro del Sagrario del Escribiente. ¡Irrumpe en él y rescátalos!", "Les scribes sont pris au piège dans le sanctum du Gardien des parchemins. Introduisez-vous à l’intérieur et sauvez-les !", "Gli scribi sono intrappolati all'interno del Santuario delle Pergamene. Fai irruzione e salvali!", "주문각인사들이 두루마리 관리인의 성소에 갇혔습니다. 성소에 침입하여 그들을 구출해야 합니다!", "Os escribas estão presos no Sacrário do Guardião dos Pergaminhos. Entre no lugar e os resgate!", "Начертатели пойманы в ловушку в Святилище хранителя свитков. Ворвитесь туда и спасите их.", "篆书人被困在藏卷人密室中。闯进去救他们！", "抄寫員被困在藏卷閣裡面。闖進去，救他們出來！", }, 
{ "A powerful demon has killed Lorewalker Stonestep! Avenge his death and look for any further survivors.", "Ein mächtiger Dämon hat Lehrensucher Steinschritt getötet! Rächt seinen Tod und sucht nach Überlebenden.", "¡Un poderoso demonio ha asesinado al eremita Senda Pétrea! Venga su muerte y busca posibles supervivientes.", "¡Un poderoso demonio ha matado al Eremita Senda Pétrea! Venga su muerte y busca sobrevivientes.", "Un puissant démon a tué le chroniqueur Pas de Pierre ! Vengez sa mort et cherchez d’autres survivants.", "Un potente demone ha ucciso il Ramingo della Sapienza Passo Fermo! Vendica la sua morte e cerca altri sopravvissuti.", "강력한 악마가 전승지기 스톤스텝을 살해했습니다! 그의 복수를 한 다음 남아있는 생존자가 있는지 확인해야 합니다.", "Um demônio poderoso matou o Andarilho das Lendas Pisapedra! Vingue sua morte e procure por sobreviventes.", "Могущественный демон убил хранителя истории Каменную Поступь. Отомстите за его смерть и поищите выживших.", "一个强大的恶魔杀死了游学者石步！为他报仇，并寻找任何可能的幸存者。", "有個很強的惡魔殺死了博學行者石步！替他報仇，然後尋找有沒有生還者。", }, 
{ "Search the Sanctum for any additional survivors.", "Durchsucht das Sanktum nach weiteren Überlebenden.", "Busca más supervivientes en el Sagrario.", "Busca más sobrevivientes en el Sagrario.", "Cherchez d’autres survivants dans le sanctum.", "Perlustra il santuario alla ricerca di altri sopravvissuti.", "성소를 탐색하여 남아있는 생존자를 찾아야 합니다.", "Vasculhe o Sacrário à procura de sobreviventes.", "Поищите в Святилище других выживших.", "在密殿搜寻其他幸存者。", "搜索聖所，尋找生還者。", }, 
{ "Follow The Monkey King into the temple.", "Folgt dem Affenkönig in den Tempel hinein.", "Sigue al Rey Mono al interior del templo.", "Sigue al Rey Mono hacia el interior del templo.", "Suivez le roi-singe dans le temple.", "Segui il Signore delle Scimmie nel tempio.", "원숭이 왕을 따라 사원으로 들어가야 합니다.", "Siga o Rei Macaco e entre no templo.", "Следуйте за Королем обезьян в храм.", "跟随美猴王进入寺院。", "跟隨美猴王進入神廟。", }, 
{ "Yu'lon, the Jade Serpent, has been injured! Defend her from the demonic attackers!", "Yu'lon, die Jadeschlange wurde verwundet! Verteidigt sie gegen die dämonischen Angreifer!", "¡Han herido a Yu'lon, el Dragón de Jade! ¡No dejes que sufra ataques de los demonios!", "¡Han herido a Yu'lon, la Dragona de Jade! ¡Defiéndela de los atacantes demoníacos!", "Yu’lon, le Serpent de jade, a été blessé ! Défendez-la contre les assaillants démoniaques !", "Yu'lon, la Serpe di Giada, è rimasta ferita! Difendila dagli attacchi dei demoni!", "옥룡 위론이 부상당했습니다! 악마에게서 그녀를 보호해야 합니다!", "Yu'lon, a Serpente de Jade, foi ferida! Defenda-a dos agressores demoníacos!", "Юй-лун, Нефритовая змея, ранена. Защитите ее от нападающих демонов.", "青龙玉珑受伤了！保护她，挡住恶魔进攻者的攻击！", "玉龍受傷了！保護她，對抗攻擊她的惡魔！", }, 
{ "The Eredar Lord Korithis is attacking the temple! Stop him!", "Der Eredarlord Korithis greift den Tempel an! Haltet ihn auf!", "¡El eredar lord Korithis está atacando el templo! ¡Detenlo!", "¡El señor eredar Korithis está atacando el templo! ¡Detenlo!", "Le seigneur érédar Korithis attaque le temple ! Arrêtez-le !", "Il Signore Eredar Korithis sta attaccando il tempio! Fermalo!", "에레다르 군주 코리티스가 사원을 공격합니다! 그를 막아야 합니다!", "O lorde eredar Korithis está atacando o templo! Detenha-o!", "Храм атакует эредарский лорд Корифий! Остановите его!", "艾瑞达领主克里提斯正在攻击寺院！阻止他！", "埃雷達爾的寇利西斯領主正在攻擊寺廟！阻止他！", }, 
{ "Korithis has been defeated! Claim Fu Zan for your own!", "Korithis wurde besiegt! Nehmt Fu Zan an Euch!", "¡Korithis ha caído derrotado! ¡Aprópiate de Fu Zan!", "¡Korithis ha sido derrotado! ¡Apodérate de Fu Zan!", "Korithis est vaincu ! Emparez-vous de Fu Zan !", "Korithis è stato sconfitto! Recupera Fu Zan!", "코리티스를 처치했습니다! 푸 잔을 획득해야 합니다!", "Korithis foi derrotado! Tome Fu Zan para si!", "Корифий побежден! Теперь Фу Цань ваш – возьмите его.", "克里提斯被击败了！快去获取福枬！", "寇利西斯被擊倒了！快拿起福山之杖！", }, 
{ "With Fu Zan in hand, ride upon Yu'lon to return to the Wandering Isle.", "Da sich Fu Zan sich jetzt in Eurer Hand befindet, schwingt Euch auf Yu'lon und kehrt zur Wandernden Insel zurück.", "Con Fu Zan en tu poder, sube a lomos de Yu'lon para volver a La Isla Errante.", "Con Fu Zan en mano, monta a Yu'lon para regresar a la Isla Errante.", "En brandissant Fu Zan, chevauchez Yu’lon pour regagner l’île Vagabonde.", "Brandendo Fu Zan, salta in groppa a Yu'lon per tornare sull'Isola Errante.", "푸 잔을 갖고 위론과 함께 유랑도로 돌아가야 합니다.", "Volte à Ilha Errante, em Yu'lon, empunhando Fu Zan.", "Теперь, когда Фу Цань у вас, возвращайтесь на Скитающийся остров верхом на Юй-лун.", "拿到福枬，骑上玉珑，回到迷踪岛。", "拿著福山之杖，騎乘玉龍返回漂流島。", }, 
},
["48"] = {
{ "Defeat the Mantid forces assaulting the Gate of the Setting Sun.", "Bezwingt die Streitkräfter der Mantis, die das Tor der Untergehenden Sonne angreifen.", "Derrota a las fuerzas mántides que asaltan la Puerta del Sol Poniente.", "Derrota a las fuerzas mántides que asaltan la Puerta del Sol Poniente.", "Terrassez les troupes mantides qui assaillent la porte du Soleil couchant.", "Sconfiggi le forze dei Mantid che stanno attaccando la Porta del Sole Calante.", "석양문을 공격하는 사마귀 병력을 처치해야 합니다.", "Derrote as tropas mantídeas que estão atacando o Portal do Sol Poente.", "Победите силы богомолов, атакующие Врата Заходящего Солнца.", "击败攻击残阳关的螳螂妖军队。", "擊敗攻擊落陽關的螳螂人部隊。", }, 
},
["622"] = {
{ "Defeat the bosses of Sethekk Halls", "Bezwingt die Bosse der Sethekkhallen.", "Derrota a los jefes de las Salas Sethekk.", "Derrota a los jefes de Salas Sethekk.", "Terrassez les boss des salles de Sethtekk.", "Sconfiggi i boss delle Sale dei Sethekk.", "세데크 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões dos Sethekk", "Победите боссов в Сетеккских залах", "击败塞泰克大厅的首领", "擊敗塞司克大廳的首領", }, 
},
["1173"] = {
{ "Investigate the overrun Vault of the Wardens.", "Untersucht, wie das Verlies der Wächterinnen überrannt werden konnte.", "Investiga la invasión de la Cámara de las Celadoras.", "Investiga la Bóveda infestada de las Celadoras.", "Inspectez le caveau des Gardiennes envahi.", "Ispeziona le Segrete delle Custodi.", "적이 득시글대는 감시관의 금고를 조사해야 합니다.", "Investigue a Câmara das Guardiãs, que foi tomada.", "Разведайте обстановку в захваченных Казематах Стражей.", "调查被占领的守望者地窟。", "調查被攻陷的看守者鐵獄。", }, 
},
["1025"] = {
{ "Slay all of the murlocs on the island.", "Tötet alle Murlocs auf der Insel.", "Mata a todos los múrlocs de la isla.", "Mata a todos los múrlocs de la isla.", "Tuez tous les murlocs de l’île.", "Uccidi tutti i Murloc sull'isola.", "섬에 있는 모든 멀록을 처치해야 합니다.", "Mate todos os murlocs do ilha.", "Истребите всех мурлоков на острове.", "击杀岛上所有的鱼人。", "殺死島上的所有魚人。", }, 
{ "Fish up the Gloaming Frenzies.", "Angelt Dämmerfrenzys.", "Pesca los peces furia del Ocaso.", "Pesca los frenesíes del ocaso.", "Pêchez les furies du déclin", "Pesca i Crepuscolari Frenetici.", "으스름 광포어를 낚아야 합니다.", "Pesque Frenesis do Anoitecer.", "Выловите сумеречных бешенок.", "钓起薄暮狂鱼。", "釣起薄暮狂魚。", }, 
{ "Give Nat your Gloaming Frenzies.", "Gebt Nat Eure Dämmerfrenzys.", "Dale a Nat tus peces furia del Ocaso.", "Dale a Nat tus frenesíes del ocaso.", "Donnez vos furies du déclin à Nat.", "Consegna a Nat i tuoi Crepuscolari Frenetici.", "내트에게 으스름 광포어를 줘야 합니다.", "Entregue os Frenesis do Anoitecer a Nat.", "Отдайте Нату свой улов сумеречных бешенок.", "把你的薄暮狂鱼交给纳特。", "把你的薄暮狂魚交給納特。", }, 
{ "Fish up what's been disturbing the frenzies.", "Zieht an Land, was auch immer die Frenzys in Aufruhr versetzt.", "Pesca lo que está molestando a los peces furia.", "Atrapa a lo que molesta a los frenesíes.", "Pêchez ce qui perturbe les furies.", "Pesca ciò che sta disturbando i crepuscolari.", "광포어를 광분하게 만든 원인을 낚아야 합니다.", "Pesque aquilo que vem incomodado os frenesis.", "Выловите то, что распугивает обезумевшую рыбу.", "钓起惊扰狂鱼的东西。", "釣起在驚擾狂魚的東西。", }, 
{ "Slay Mglrrp.", "Tötet Mglrrp.", "Mata a Mglrrp.", "Mata a Mglrrp.", "Tuez Mglrrp.", "Uccidi Mglrrp.", "아옳옲을 처치해야 합니다.", "Mate Mglrrp.", "Убейте Мглррпа.", "消灭墨勒普。", "殺死莫咕哺。", }, 
},
["322"] = {
{ "Kill the guards in Stonard.", "Tötet die Wachen in Steinard.", "Mata a los guardias del Rocal.", "Mata a los guardias de Rocal.", "Tuez les gardes de Pierrêche.", "Uccidi le guardie a Pietrachiusa.", "스토나드 경비병들을 처치해야 합니다.", "Mate os guardas em Pedregal.", "Убейте стражников в Каменоре.", "消灭斯通纳德里的守卫。", "殺死斯通納德守衛。", }, 
{ "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "送出事件 36841", }, 
{ "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "sendevent 36841", "送出事件 36841", }, 
},
["1122"] = {
{ "Meryl is here preparing for the assault. Speak with him and Alodi to begin preparations.", "Meryl ist hier und macht sich zum Sturmangriff bereit. Sprecht mit ihm und Alodi, um mit den Vorbereitungen zu beginnen.", "Meryl está aquí preparándose para el ataque. Habla con él y con Alodi para que comiencen los preparativos.", "Meryl está aquí preparándose para el asalto. Habla con él y con Alodi para comenzar con los preparativos.", "Meryl est ici pour préparer l’assaut. Discutez avec Alodi et lui pour commencer les préparatifs.", "Meryl è qui e sta preparando l'assalto. Parla con lui e Alodi per iniziare i preparativi.", "메릴은 이곳에서 습격을 준비하려고 합니다. 메릴과 알로디와 대화하고 준비를 시작해야 합니다.", "Meryl está presente, preparando-se para o ataque. Fale com ele e com Alodi para dar início aos preparativos.", "Мерил уже здесь и готовится к нападению. Поговорите с ним и с Алоди, чтобы начать приготовления.", "梅瑞尔在这里，正在为突袭做准备。和他还有阿洛迪谈谈，开始准备工作。", "莫爾在這裡準備進攻。跟他和艾洛岱交談來開始準備工作。", }, 
{ "The Fel Dampening Wards must be placed at highly visible locations to be seen. Fight to the locations, setup the wards, and defend them.", "Der Teufelsdämpfungszauberschutz muss an gut sichtbaren Stellen platziert werden, damit man ihn bemerkt. Kämpft Euch zu diesen Orten durch, errichtet die Zauberschutze und verteidigt sie.", "Los resguardos de atenuación vil deben colocarse en lugares muy visibles. Lucha hasta llegar a los enclaves elegidos, coloca los resguardos y defiéndelos.", "Los Resguardos de disminución viles deben colocarse en ubicaciones altamente visibles para que se les pueda ver. Ábrete paso hacia esos lugares, construye los resguardos y defiéndelos.", "Il faut placer les protections atténuant la gangrène à des endroits très visibles. Frayez-vous un chemin jusqu’à ces endroits, installez les protections et défendez-les.", "Le Protezioni Smorzavile devono essere posizionate in luoghi ben visibili. Fatti strada, posiziona le Protezioni e difendile.", "지옥 감쇠 수호물이 잘 보이도록 높은 곳에 설치해야 합니다. 수호물을 설치할 장소를 확보한 다음, 수호물을 설치하고 방어해야 합니다.", "As proteções contra vileza devem ser posicionadas em locais bem visíveis. Chegue até esses locais, posicione as proteções e as defenda.", "Обереги подавления Скверны должны быть хорошо видны. Пробейтесь к подходящим точкам, установите обереги и защищайте их.", "邪能抑制结界必须放在可见度很高的地点，让人能够看到。杀出一条路，前往指定地点，设置好结界，然后保护结界。", "抑魔結界必須放置在非常顯眼的位置才看得見。一路戰鬥並前往這些位置，設置結界，然後保護它們。", }, 
{ "The wards are activated, it is time to begin the ritual. Go to the Altar of End Times and speak with Meryl Felstorm.", "Die Zauberschutze sind aktiviert und nun ist es Zeit, mit dem Ritual zu beginnen. Geht zum Altar der Endzeit und sprecht mit Meryl Teufelssturm.", "Los resguardos están activados. Es hora de comenzar el ritual. Ve al Altar del Fin de los Tiempos y habla con Meryl Tormenta Vil.", "Los resguardos están activados, es hora de comenzar con el ritual. Ve al Altar del fin de los días y habla con Meryl Tormenta Vil.", "Les protections sont activées. Il est temps de commencer le rituel. Rendez-vous à l’autel de la Fin des temps et parlez à Meryl Gangrorage.", "Le difese sono attivate, è tempo di dare inizio al rituale. Vai all'Altare della Fine dei Tempi e parla con Meryl Viltempesta.", "수호물이 활성화되었으니 의식을 시작할 수 있습니다. 종말의 제단으로 간 다음 메릴 펠스톰과 대화해야 합니다.", "As proteções foram ativadas, é hora de dar início ao ritual. Vá até o Altar do Fim dos Tempos e fale com Meryl Tempestavil.", "Обереги активированы, пора начинать ритуал. Подойдите к алтарю Конца Времен и поговорите с Мерилом Бурей Скверны.", "结界激活，是时候开始仪式了。前往末世祭坛，和梅瑞尔·邪风谈谈。", "結界全部啟動，該開始進行儀式了。前往終焉祭壇與莫爾‧魔風交談。", }, 
{ "Use the Ritual Focus whenever possible to complete the ritual.", "Benutzt sooft wie möglich den Ritualfokus, um das Ritual abzuschließen.", "Usa el foco de ritual cuando sea posible para completar el ritual.", "Usa el enfoque del ritual cada vez que puedas para completar el ritual.", "Utilisez le focalisateur aussi souvent que possible pour accomplir le rituel.", "Usa il Focus Rituale quando possibile per completare il rituale.", "언제든 가능할 때 의식 집중점을 사용하여 의식을 완료해야 합니다.", "Use o Foco do Ritual sempre que possível para completar o ritual.", "По возможности активируйте средоточие, чтобы завершить ритуал.", "抓紧一切时机使用仪式焦镜，完成仪式。", "盡可能地使用儀式法器來完成儀式。", }, 
{ "Balaadur has swept you up into his realm. Slay the eredar lord.", "Balaadur hat Euch in sein Reich hineingezogen. Tötet den Eredarfürsten.", "Balaadur te ha arrastrado a su reino. Mata al señor eredar.", "Balaadur te arrastró hacia su reino. Asesina al señor eredar.", "Balaadar a réussi à vous attirer dans son royaume. Tuez-le.", "Balaadur ti ha trascinato nel suo regno. Uccidi il Signore degli Eredar.", "발라두르의 힘에 휩쓸려 그의 세계로 들어왔습니다. 에레다르 군주 발라두르를 처치해야 합니다.", "Balaadur arrastou você para o mundo dele. Mate o lorde eredar.", "Балаадур забросил вас в свои владения. Убейте эредарского повелителя.", "巴拉杜尔将你扔进他的世界。杀死这个艾瑞达领主。", "巴拉杜爾把你帶進了他的領域。殺死這個埃雷達爾領主。", }, 
{ "Ebonchill lies near the fallen demon. Claim it for your own.", "Schwarzfrost liegt neben dem gefallenen Dämon. Beansprucht ihn für Euch.", "Ébano Glacial está cerca del demonio caído. Reclámalo.", "Frío del ébano yace cerca del demonio caído. Ve por él.", "Frissébène se trouve près du démon vaincu. Emparez-vous-en.", "Gelonero si trova vicino al demone caduto. Devi prenderlo.", "쓰러진 악마 주변에 칠흑한기가 놓여있습니다. 지팡이를 획득해야 합니다.", "Ébano Gélido jaz ao lado do demônio caído. Tome-o para si.", "Полярная Ночь ждет вас рядом с павшим демоном. Заберите ее.", "黑檀之寒就在死去恶魔的旁边。自己去取得它。", "黯凜就在倒下惡魔的身旁。把它據為己有。", }, 
},
["613"] = {
{ "Defeat the bosses of The Botanica", "Bezwingt die Bosse der Botanika.", "Derrota a los jefes de El Invernáculo.", "Derrota a los jefes de El Invernáculo.", "Terrassez les boss de la Botanica.", "Sconfiggi i boss di Botanica.", "신록의 정원 우두머리들을 처치해야 합니다.", "Derrote os chefes do Jardim Botânico", "Победите боссов в Ботанике", "击败生态船的首领", "擊敗波塔尼卡的首領", }, 
},
["1170"] = {
{ "Confront Akama.", "Stellt Akama.", "Enfréntate a Akama.", "Enfréntate a Akama.", "Affrontez Akama.", "Affronta Akama.", "아카마와 맞서야 합니다.", "Confronte Akama.", "Встретьтесь с Акамой лицом к лицу.", "与阿卡玛对峙。", "面對阿卡瑪。", }, 
{ "Survive until your reinforcements arrive.", "Überlebt, bis die Verstärkung eingetroffen ist.", "Sobrevive hasta que lleguen tus refuerzos.", "Sobrevive hasta que lleguen tus refuerzos.", "Survivez jusqu’à l’arrivée de vos renforts.", "Sopravvivi fino all'arrivo dei rinforzi.", "지원군이 올 때까지 살아남아야 합니다.", "Sobreviva até que cheguem os reforços.", "Продержитесь до прибытия подкрепления.", "坚持到援军的到来。", "撐到援軍抵達。", }, 
{ "Summon the Flames of Azzinoth and eliminate your enemies from the sky.", "Beschwört die Flammen von Azzinoth und vernichtet Eure Feinde vom Himmel aus.", "Invoca las llamas de Azzinoth y elimina a tus enemigos desde el cielo.", "Invoca las Llamas de Azzinoth y elimina a tus enemigos desde el cielo.", "Invoquez les flammes d’Azzinoth et éliminez vos ennemis depuis le ciel.", "Evoca le Fiamme di Azzinoth e ripulisci il Cielo dai tuoi nemici.", "아지노스의 불꽃을 소환하고, 공중으로 떠올라 적을 제거해야 합니다.", "Evoque as Chamas de Azzinoth e elimine seus inimigos à partir dos céus.", "Призовите Пламя Аззинота и уничтожьте врагов сверху.", "召唤埃辛诺斯之焰，从天空中毁灭你的敌人。", "召喚埃辛諾斯火焰從天而降，消滅你的敵人。", }, 
{ "Unleash the hatred of ten thousand years.", "Entfesselt den Hass von zehntausend Jahren.", "Desata el odio de diez mil años.", "Suelta el odio de diez mil años.", "Déchaînez la puissance de dix mille ans de haine.", "Scatena l'odio vecchio di diecimila anni.", "만 년 동안 응어리진 증오를 보여줘야 합니다.", "Libere o ódio de dez mil anos.", "Высвободите ненависть десяти тысяч лет.", "释放一万年的仇恨。", "釋放一萬年以來累積的仇恨。", }, 
{ "Annihilate your enemies.", "Vernichtet Eure Feinde.", "Aniquila a tus enemigos.", "Aniquila a tus enemigos.", "Annihilez vos ennemis.", "Distruggi i tuoi nemici.", "적을 몰살해야 합니다.", "Aniquile os inimigos.", "Уничтожьте ваших противников.", "歼灭敌人。", "消滅敵人。", }, 
{ "Defeat Maiev", "Besiegt Maiev.", "Derrota a Maiev.", "Derrota a Maiev", "Triomphez de Maiev.", "Sconfiggi Maiev.", "마이에브를 처치해야 합니다.", "Derrote Maiev", "Победите Майев", "击败玛维。", "擊敗瑪翼夫", }, 
},
["1138"] = {
{ "Seek out Prophet Velen in the Vault of Lights.", "Sucht Prophet Velen in der Halle des Lichts auf.", "Busca al profeta Velen en el Arca de las Luces.", "Busca al profeta Velen en el Arca de las Luces.", "Allez trouver le prophète Velen à la Voûte des lumières.", "Cerca il Profeta Velen nella Volta delle Luci.", "빛의 전당에 있는 예언자 벨렌을 찾아야 합니다.", "Procure pelo Profeta Velen na Cripta das Luzes.", "Найдите пророка Велена в Чертоге Света.", "在圣光穹顶中找到先知维伦", "在聖光地窖裡面找到預言者費倫。", }, 
{ "Rescue terrified citizens found throughout the Exodar and destroy Legion fel portals.", "Rettet entsetzte Bürger überall in der Exodar und zerstört die Teufelsportale der Legion.", "Rescata a ciudadanos aterrados por todo El Exodar y destruye los portales viles de la Legión.", "Rescata a los ciudadanos aterrorizados que están en el Exodar y destruye los portales viles de la Legión.", "Secourez des citoyens terrifiés dans l’Exodar et détruisez les gangreportails de la Légion.", "Salva i cittadini terrorizzati in tutta Exodar e distruggi i vilportali della Legione.", "엑소다르 전역에 있는 겁에 질린 시민을 구출하고 군단의 지옥 차원문을 닫아야 합니다.", "Resgate os cidadãos aterrorizados que encontrar pela Exodar e destrua os portais-vis da Legião.", "Спасите перепуганных жителей Экзодара и уничтожьте порталы Скверны Легиона.", "救出埃索达中所发现的惊恐的平民，并摧毁军团的邪能传送门。", "拯救在艾克索達各地惶恐的居民，並且摧毀燃燒軍團的惡魔傳送門。", }, 
{ "Return to Prophet Velen in the Vault of Lights.", "Kehrt zu Prophet Velen in der Halle des Lichts zurück.", "Vuelve con el profeta Velen en El Arca de las Luces.", "Regresa con el profeta Velen en el Arca de las Luces.", "Retournez voir le prophète Velen à la Voûte des lumières.", "Torna dal Profeta Velen nella Volta delle Luci.", "빛의 전당에 있는 예언자 벨렌에게 가야 합니다.", "Fale novamente com o Profeta Velen na Cripta das Luzes.", "Вернитесь к пророку Велену в Чертог Света.", "回到圣光穹顶中，找到先知维伦。", "返回聖光地窖找預言者費倫。", }, 
{ "Let Prophet Velen examine the Mysterious Lightbound Object.", "Lasst den Propheten das mysteriöse lichtgebundene Objekt untersuchen.", "Deja que el profeta Velen examine el objeto misterioso vinculado a la Luz.", "Deja que el profeta Velen examine el misterioso objeto", "Laissez le prophète Velen examiner l’objet mystérieux empreint de Lumière.", "Lascia che il Profeta Velen esamini l'Oggetto Misterioso Vincolato alla Luce.", "예언자 벨렌이 신비로운 빛의 결속체를 조사하게 해야 합니다.", "Permitia que o Profeta Velen examine o Misterioso Objeto Envolto em Luz.", "Дайте пророку Велену загадочный светоносный объект, чтобы тот мог его изучить.", "让先知维伦检查这个神秘的缚光物体。", "讓預言者費倫檢視神秘光縛物品。", }, 
{ "Speak to Prophet Velen, then escort him to the Seat of the Naaru.", "Sprecht mit Prophet Velen und begleitet ihn anschließend zum Sitz der Naaru.", "Habla con el profeta Velen y luego escóltalo hasta el Trono de los Naaru.", "Habla con el Profeta Velen y luego escóltalo al Trono de los Naaru.", "Parlez au prophète Velen puis escortez-le au Siège du naaru.", "Parla con il Profeta Velen, poi accompagnalo al Trono dei Naaru.", "예언자 벨렌과 대화한 후, 그를 나루의 보좌까지 호위해야 합니다.", "Fale com o Profeta Velen e escolte-o até a Sede dos Naarus.", "Поговорите с пророком Веленом и сопроводите его к Трону Наару.", "与先知维伦交谈，然后护送他前往纳鲁之座。", "與預言者費倫交談，然後護送他前往那魯之座。", }, 
{ "Defeat High General Rakeesh.", "Bezwingt Hochgeneral Rakeesh.", "Derrota al alto general Rakeesh.", "Derrota al Alto general Rakeesh.", "Terrassez le grand général Rakeesh.", "Sconfiggi il Gran Generale Rakeesh.", "고위사령관 라키쉬를 처치해야 합니다.", "Derrote o General de Exército Rakeesh.", "Одолейте верховного генерала Ракиша.", "击败拉基什将军。", "擊敗拉克許大將軍。", }, 
},
["1299"] = {
{ "Secure the upper portion of Thunder Totem.", "Sichert den oberen Bereich von Donnertotem.", "Asegura la parte superior de Tótem del Trueno.", "Asegura la parte superior de Tótem del Trueno.", "Sécurisez la partie supérieure de Totem-du-Tonnerre.", "Metti al sicuro l'area superiore di Totem del Fulmine.", "천둥 토템 상층부를 확보해야 합니다.", "Proteja a parte superior de Totem do Trovão.", "Отбейте у демонов верхний ярус Громового Тотема.", "肃清雷霆图腾的上层。", "保衛雷霆圖騰的上層。", }, 
{ "Rendezvous with Mayla in the lower portion of Thunder Totem.", "Trefft Euch mit Mayla im unteren Bereich Donnertotems.", "Encuéntrate con Mayla en la parte inferior de Tótem del Trueno.", "Reúnete con Mayla en la parte inferior de Tótem del Trueno.", "Retrouvez Mayla dans la partie inférieure de Totem-du-Tonnerre.", "Incontra Mayla nell'area inferiore di Totem del Fulmine.", "천둥 토템 하층부에 있는 마일라와 만나야 합니다.", "Encontre-se com Mayla na parte inferior de Totem do Trovão.", "Встретьтесь с Майлой Крутогор в нижней части Громового Тотема.", "在雷霆图腾下层与梅拉汇合。", "跟梅拉在雷霆圖騰下層會合。", }, 
{ "Defend the area from incoming enemy attacks.", "Wehrt die feindlichen Angriffe auf das Gebiet ab.", "Defiende la zona de los ataques enemigos.", "Defiende el área de los ataques del enemigo.", "Défendez la zone contre les attaques ennemies.", "Difendi la zona dagli attacchi dei nemici.", "적의 공격으로부터 지역을 방어해야 합니다.", "Defenda a área dos ataques inimigos.", "Защищайте геоманта от атакующих демонов.", "保卫阵地，挡住来袭的敌人。", "防守這個區域，抵禦敵人攻擊。", }, 
{ "Eliminate the lieutenant leading the assault.", "Schaltet den Anführer des Angriffs aus.", "Elimina al teniente que lidera el asalto.", "Elimina al teniente que lidera el asalto.", "Éliminez le lieutenant menant l’assaut.", "Elimina il luogotenente al comando dell'assalto.", "공격을 이끄는 부관을 제거해야 합니다.", "Elimine o tenente que está liderando o ataque.", "Устраните демона, командующего наступлением.", "消灭指挥攻击的首领。", "消滅領導這場攻擊行動的副官。", }, 
{ "Escort Mayla to meet up with Lasan outside of Thunder Totem.", "Eskortiert Mayla und trefft Euch mit Lasan außerhalb von Donnertotem.", "Escolta a Mayla y llévala con Lasan en las afueras de Tótem del Trueno.", "Escolta a Mayla a su encuentro con Lasan fuera de Tótem del Trueno.", "Escortez Mayla à la rencontre de Lasan, devant Totem-du-Tonnerre.", "Scorta Mayla da Lasan Corno Celeste fuori da Totem del Fulmine.", "마일라를 호위하여 천둥 토템 밖에 있는 라산과 만나야 합니다.", "Escolte Mayla até o encontro com Lasan, nos arredores de Totem do Trovão.", "Сопроводите Майлу за пределы Громового Тотема и встретьтесь с Ласаном.", "护送梅拉与雷霆图腾外的拉善汇合。", "護送梅拉到雷霆圖騰外面與拉桑會合。", }, 
{ "Use Lasan's War Eagles to reach the Legion Ship.", "Setzt Lasans Kriegsadler ein, um das Legionsschiff zu erreichen.", "Utiliza las águilas de guerra de Lasan para llegar a la nave de la Legión.", "Usa las águilas de guerra de Lasan para llegar hasta la nave de la Legión.", "Volez jusqu’au vaisseau de la Légion grâce aux aigles de guerre de Lasan.", "Usa le Aquile da Guerra di Lasan per raggiungere la Nave della Legione.", "라산의 전쟁 독수리를 이용해 군단 함선까지 가야 합니다.", "Use as Águias de Guerra de Lasan para chegar à nave da Legião.", "Доберитесь до корабля Легиона на боевых орлах Ласана.", "使用拉善的作战雄鹰前往军团战舰。", "騎乘拉桑的戰鷹登上燃燒軍團船艦。", }, 
{ "Rescue the highmountain tauren captured by the Legion.", "Rettet die von der Legion gefangenen Hochbergtauren.", "Rescata a los tauren Monte Alto capturados por la Legión.", "Rescata a los tauren de Altamontaña que han sido capturados por la Legión.", "Libérez les taurens de Haut-Roc capturés par la Légion.", "Salva i Tauren di Alto Monte catturati dalla Legione.", "군단에 사로잡힌 높은산 타우렌을 구출해야 합니다.", "Resgate os taurens de Alta Montanha capturados pela Legião.", "Освободите тауренов Крутогорья, захваченных в плен Легионом.", "救出被军团俘虏的至高岭牛头人。", "解救被燃燒軍團擄走的高嶺牛頭人。", }, 
{ "Set explosives at key points throughout the ship.", "Platziert den Sprengstoff an wichtigen Punkten auf dem Schiff.", "Coloca explosivos en los puntos clave de la nave.", "Coloca explosivos en puntos clave de la nave.", "Placez des explosifs à divers points clés du vaisseau.", "Piazza gli esplosivi nei punti chiave all'interno della nave.", "함선 곳곳의 주요 지점에 폭발물을 설치해야 합니다.", "Plante explosivos em pontos estratégicos do navio.", "Заложите взрывчатку в ключевых точках корабля.", "在战舰的关键位置安放炸药。", "在船上的關鍵地點設置炸藥。", }, 
{ "Assist Lasan in the fight against the Legion Commander.", "Unterstützt Lasan im Kampf gegen den Legionskommandanten.", "Ayuda a Lasan en la lucha contra el comandante de la Legión.", "Ayuda a Lasan en su lucha contra el Comandante de la Legión.", "Aidez Lasan dans le combat contre le commandant de la Légion.", "Aiuta Lasan nel combattimento contro il Comandante della Legione.", "라산을 도와 군단 사령관과 싸워야 합니다.", "Ajude Lasan na luta contra o Comandante de Legião.", "Помогите Ласану победить командира Легиона.", "协助拉善战胜军团指挥官。", "協助拉桑擊敗燃燒軍團指揮官。", }, 
{ "Use the eagles to get off the ship.", "Nutzt die Adler, um vom Schiff zu kommen.", "Utiliza las águilas para abandonar la nave.", "Usa las águilas para escapar de la nave.", "Quittez le vaisseau grâce aux aigles.", "Usa le aquile per allontanarti dalla nave.", "독수리를 사용해 함선에서 빠져나와야 합니다.", "Use as águias para sair do navio.", "Покиньте корабль на орлах Ласана.", "使用雄鹰离开船。", "騎乘戰鷹離開船艦。", }, 
},
["1168"] = {
{ "Join the battle at Netherlight Temple.", "Nehmt an der Schlacht am Netherlichttempel teil.", "Únete a la batalla en el Templo de la Luz Abisal.", "Únete a la batalla en el Templo Luz Abisal.", "Joignez-vous à la bataille du temple Halo-du-Néant.", "Unisciti alla battaglia al Tempio di Lucefatua.", "황천빛 사원 전투에 참가해야 합니다.", "Junte-se à batalha no Templo Eterluz.", "Присоединитесь к битве в Храме света Пустоты.", "加入到虚空之光神殿的战斗中。", "加入在虛空之光神殿的戰鬥。", }, 
{ "Defeat Ogoroth and Torenai the Souleater.", "Bezwingt Ogoroth und Torenai den Seelenfresser.", "Derrota a Ogoroth y a Torenai el Devoraalmas.", "Derrota a Ogoroth y Torenai el Comealmas.", "Terrassez Ogoroth et Torenai le Dévoreur d’âmes.", "Sconfiggi Ogoroth e Torenai il Mangiatore d'Anime.", "오그로스와 영혼포식자 토레나이를 처치해야 합니다.", "Derrote Ogoroth e Torenai, o Devoralmas.", "Одолейте Огороса и Тореная Пожирателя Душ.", "击败奥格罗斯和食魂者托瑞纳。", "擊敗歐格洛斯和『噬魂者』托倫奈伊。", }, 
{ "Destroy 4 Legion portals.", "Zerstört 4 Legionsportale.", "Destruye 4 portales de la Legión.", "Destruye 4 portales de la Legión.", "Détruisez 4 portails de la Légion.", "Distruggi 4 Portali della Legione.", "군단 차원문 4개를 파괴해야 합니다.", "Destrua 4 portais da Legião.", "Уничтожьте 4 портала Легиона.", "摧毁4个军团传送门。", "摧毀4座燃燒軍團傳送門。", }, 
{ "Slay Balnazzar.", "Tötet Balnazzar.", "Mata a Balnazzar.", "Asesina a Balnazzar.", "Éliminez Balnazzar.", "Uccidi Balnazzar.", "발나자르를 처치해야 합니다.", "Mate Balnazzar.", "Убейте Бальназара.", "消灭巴纳扎尔。", "殺死巴納札爾。", }, 
},
["432"] = {
{ "Defeat the Ironmarch forces occupying the halls of the Spire.", "Besiegt die Truppen des Eisernen Marsches, die die Hallen der Schwarzfelsspitze besetzen.", "Derrota a las tropas de La Marcha de Hierro que ocupan las salas de la Cumbre.", "Derrota a las fuerzas Marcha Férrea que ocupan las cámaras de la Cumbre.", "Terrassez les troupes marchefer qui occupent les salles du Pic Rochenoire.", "Sconfiggi le forze della Marcia di Ferro che hanno occupato le sale dei Bastioni di Roccianera.", "첨탑을 장악한 강철선봉대 군대를 무찔러야 합니다.", "Derrote as tropas da Marcha de Ferro que ocupam os salões do Pináculo.", "Победите войска Железного Марша, занявшие залы пика.", "击败占据了黑石塔大厅的铁军部队。", "擊敗佔據了黑石塔上層的鋼鐵戰線部隊。", }, 
},
["621"] = {
{ "Defeat the bosses of The Arcatraz.", "Bezwingt die Bosse der Arkatraz.", "Derrota a los jefes de El Arcatraz.", "Derrota a los jefes de El Arcatraz.", "Terrassez les boss de l’Arcatraz.", "Sconfiggi i boss di Arcatraz.", "알카트라즈 우두머리들을 처치해야 합니다.", "Derrote os chefes de Arcatraz.", "Победите боссов в Аркатраце.", "击败禁魔监狱的首领。", "擊敗亞克崔茲的首領。", }, 
},
["665"] = {
{ "Defeat the bosses of the Warpwood Quarter", "Bezwingt die Bosse des Wucherborkenviertels.", "Derrota a los jefes del Barrio Alabeo", "Derrota a los jefes del Barrio Alabeo", "Triomphez des boss du quartier de Crochebois.", "Sconfiggi i boss del Quartiere di Legnotorto.", "굽이나무 지구 우두머리들을 처치해야 합니다.", "Derrote os chefes do Distrito Lenhatorta", "Победите боссов в Квартале Криводревов", "击败扭木广场的首领", "擊敗扭木廣場的首領", }, 
},
["565"] = {
{ "Defeat the bosses of the Halls of Origination", "Besiegt die Bosse in den Hallen des Ursprungs.", "Derrota a los jefes de las Cámaras de los Orígenes.", "Derrota a los jefes de Las Cámaras de los Orígenes.", "Terrassez les boss des salles de l’Origine.", "Sconfiggi i boss delle Sale della Creazione.", "시초의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões Primordiais", "Победите боссов в Чертогах Созидания", "击败起源大厅的首领", "擊敗起源大廳的首領", }, 
{ "Defeat Isiset, Construct of Magic", "Besiegt Isiset, Konstrukt der Magie.", "Derrota a Isiset, Ensamblaje de magia.", "Derrota a Isiset, Ensamblaje de magia.", "Terrassez Isiset, assemblage de magie.", "Sconfiggi Isiset, Costrutto della Magia.", "마법의 지배신 이시세트를 처치해야 합니다.", "Derrote Isiset, o Constructo Mágico", "Победите Изисет, Творение Магии", "击败伊希斯特，魔法的造物", "擊敗伊希賽特，魔法造物", }, 
{ "Defeat Ammunae, Construct of Life", "Besiegt Ammunae, Konstrukt des Lebens.", "Derrota a Ammunae, Ensamblaje de vida.", "Derrota a Ammunae, Ensamblaje de vida.", "Terrassez Ammunae, assemblage de vie.", "Sconfiggi Ammunae, Costrutto della Vita.", "생명의 지배신 아뮤내를 처치해야 합니다.", "Derrote Ammunae, o Constructo Vital", "Победите Аммунаэ, Творение Жизни", "击败阿穆纳伊，生命的造物", "擊敗安姆內，生命造物", }, 
{ "Defeat Setesh, Construct of Destruction", "Besiegt Setesh, Konstrukt der Zerstörung.", "Derrota a Setesh, Ensamblaje de destrucción.", "Derrota a Setesh, Ensamblaje de destrucción.", "Terrassez Setesh, assemblage de destruction.", "Sconfiggi Setesh, Costrutto della Distruzione.", "파괴의 지배신 세테쉬를 처치해야 합니다.", "Derrote Setesh, Constructo Destrutivo", "Победите Сетеша, Творение Разрушения", "击败塞特斯，毁灭的造物", "擊敗賽特胥，毀滅造物", }, 
},
["1160"] = {
{ "Join the battle at Netherlight Temple.", "Nehmt an der Schlacht am Netherlichttempel teil.", "Únete a la batalla en el Templo de la Luz Abisal.", "Únete a la batalla en el Templo Luz Abisal.", "Joignez-vous à la bataille du temple Halo-du-Néant.", "Unisciti alla battaglia al Tempio di Lucefatua.", "황천빛 사원 전투에 참가해야 합니다.", "Junte-se à batalha no Templo Eterluz.", "Присоединитесь к битве в Храме света Пустоты.", "加入到虚空之光神殿的战斗中。", "加入在虛空之光神殿的戰鬥。", }, 
{ "Defeat Ogoroth and Torenai the Souleater.", "Bezwingt Ogoroth und Torenai den Seelenfresser.", "Derrota a Ogoroth y a Torenai el Devoraalmas.", "Derrota a Ogoroth y Torenai el Comealmas.", "Terrassez Ogoroth et Torenai le Dévoreur d’âmes.", "Sconfiggi Ogoroth e Torenai il Mangiatore d'Anime.", "오그로스와 영혼포식자 토레나이를 처치해야 합니다.", "Derrote Ogoroth e Torenai, o Devoralmas.", "Одолейте Огороса и Тореная Пожирателя Душ.", "击败奥格罗斯和食魂者托瑞纳。", "擊敗歐格洛斯和『噬魂者』托倫奈伊。", }, 
{ "Destroy 4 Legion portals.", "Zerstört 4 Legionsportale.", "Destruye 4 portales de la Legión.", "Destruye 4 portales de la Legión.", "Détruisez 4 portails de la Légion.", "Distruggi 4 Portali della Legione.", "군단 차원문 4개를 파괴해야 합니다.", "Destrua 4 portais da Legião.", "Уничтожьте 4 портала Легиона.", "摧毁4个军团传送门。", "摧毀4座燃燒軍團傳送門。", }, 
{ "Slay Balnazzar.", "Tötet Balnazzar.", "Mata a Balnazzar.", "Asesina a Balnazzar.", "Éliminez Balnazzar.", "Uccidi Balnazzar.", "발나자르를 처치해야 합니다.", "Mate Balnazzar.", "Убейте Бальназара.", "消灭巴纳扎尔。", "殺死巴納札爾。", }, 
},
["631"] = {
{ "Defeat the bosses of The Underbog", "Bezwingt die Bosse des Tiefensumpfs.", "Derrota a los jefes de La Sotiénaga.", "Derrota a los jefes de La Sotiénaga.", "Terrassez les boss de la Basse-tourbière.", "Sconfiggi i boss della Torbiera Sotterranea.", "지하수렁 우두머리들을 처치해야 합니다.", "Derrote os chefes do Brejo Oculto", "Победите боссов в Нижетопи", "击败幽暗沼泽的首领", "擊敗深幽泥沼的首領", }, 
},
["1159"] = {
{ "Slay the Duskwatch Archivists to escape the Forgotten Library.", "Tötet die Archivare der Dämmerwache, um aus der Vergessenen Bibliothek zu entkommen.", "Mata a los archivistas Vigías del ocaso para escapar de la Biblioteca Olvidada.", "Asesina a los archivistas de la Guardia Umbría para escapar de la Biblioteca olvidada.", "Tuez les archivistes de la Garde crépusculaire pour fuir la bibliothèque oubliée.", "Uccidi gli Archivisti della Guardia del Vespro per fuggire dalla Biblioteca Dimenticata.", "황혼감시대 기록관을 처치해 잊힌 도서관에서 탈출해야 합니다.", "Mate os Arquivistas da Vigia Crepuscular e escape da Biblioteca Esquecida.", "Убейте архивариусов Сумеречной стражи, чтобы выбраться из заброшенной библиотеки.", "消灭暮色卫队档案员，逃离被遗忘的图书馆。", "殺死暮衛古卷管理者來離開佚忘書庫", }, 
{ "Reach the door to the Nightflow Conduit.", "Erreicht die Tür zur Nachtflussleitung.", "Usa la puerta al Conducto Nocturno.", "Llega hasta la puerta al Conducto del flujo nocturno.", "Atteignez la porte menant à l’artère Ruissenuit.", "Raggiungi la porta per il Condotto Oscuro.", "밤흐름 도관으로 통하는 문에 도착해야 합니다.", "Alcançe a porta para o Conduíte da Noite.", "Доберитесь до двери к проводнику Ночного Колодца.", "到达通往夜流水渠的大门。", "抵達夜流中樞的大門", }, 
{ "Defend Arluin while he opens the door to the Nightflow Conduit.", "Haltet Arluin den Rücken frei, während er die Tür zur Nachtflussleitung öffnet.", "Defiende a Arluin mientras abre la puerta del Conducto Nocturno.", "Defiende a Arluin mientras abre la puerta al Conducto del flujo nocturno.", "Défendez Arluin pendant qu’il ouvre la porte de l’artère Ruissenuit.", "Proteggi Arluin mentre apre le porte per il Condotto Oscuro.", "알루인이 밤흐름 도관으로 통하는 문을 여는 동안 그를 보호해야 합니다.", "Defenda Arluin enquanto ele abre a porta para o Conduíte da Noite.", "Защищайте Арлуина, пока он открывает дверь к проводнику.", "在阿鲁因打开通往夜流水渠的门时保护他。", "保護亞魯因，讓他打開通往夜流中樞的門", }, 
{ "Place the Ephemeral Manastorm Projector in the Nightflow Conduit.", "Platziert den ephemeren Manasturmprojektor in der Nachtflussleitung.", "Coloca el proyector de tormenta de maná efímera en el Conducto Nocturno.", "Coloca el Proyector de tormenta de maná efímera en el Conducto del flujo nocturno.", "Placez le projecteur de tempête de mana éphémère dans l’artère Ruissenuit.", "Metti il Proiettore di Tempeste di Mana nel Condotto Oscuro.", "밤흐름 도관에 단기 마나폭풍 투영기를 설치해야 합니다.", "Posicione o Projetor Manavento Efêmero no Conduíte da Noite.", "Поместите эфемерный проектор манашторма в проводник Ночного Колодца.", "将瞬灭法力风暴发射器放置在夜流水渠中。", "在夜流中樞放置瞬效法力風暴發射器。", }, 
{ "Survive the manastorm.", "Überlebt den Manasturm.", "Sobrevive a la tormenta de maná.", "Sobrevive a la tormenta de maná.", "Survivez à la tempête de mana.", "Sopravvivi alla tempesta di mana.", "마나폭풍에서 살아남아야 합니다.", "Sobreviva à tempestade de mana.", "Переживите манашторм.", "在法力风暴中活下来。", "在法力風暴中活下來", }, 
},
["1230"] = {
{ "Listen to Kalec's Instruction", "Hört Euch Kalecs Instruktionen an.", "Escucha las instrucciones de Kalec.", "Escucha las instrucciones de Kalec", "Écoutez les instructions de Kalec.", "Ascolta le istruzioni di Kalec.", "칼렉의 설명을 들어야 합니다.", "Ouça as instruções de Kalec.", "Выслушайте указания Кейлека.", "听取卡雷的介绍", "聽從卡雷克的指示", }, 
{ "Disperse the disruptive elements in each disc.", "Bändigt die störenden Elemente in jeder Scheibe.", "Dispersa los elementos perturbadores de cada disco.", "Dispersa los elementos perturbadores de cada disco.", "Dispersez les éléments perturbateurs dans chaque disque.", "Disperdi gli elementi distruttivi presenti in ogni disco.", "각 원반 안의 방해의 마력을 제거해야 합니다.", "Disperse os elementos fora de controle em cada disco.", "Рассейте разрушительную избыточную энергию в каждом фрагменте диска.", "消散每个飞碟中的元素。", "分散稜碟裡的毀滅力量。", }, 
},
["275"] = {
{ "Speak with Vindicator Maraad.", "Sprecht mit Verteidiger Maraad.", "Habla con el vindicador Maraad.", "Habla con el vindicador Maraad.", "Parlez au redresseur de torts Maraad.", "Parla con il Vendicatore Maraad.", "구원자 마라아드와 대화해야 합니다.", "Fale com o Vindicante Maraad.", "Поговорите с воздаятелем Мараадом.", "与守备官玛尔拉德谈一谈。", "與復仇者瑪銳德交談。", }, 
{ "Slay Orrok the Spearmaster.", "Tötet Orrok den Speermeister.", "Mata a Orrok el Maestro de Lanzas.", "Mata a Orrok el Maestro de Lanzas.", "Tuez Orrok le Maître-Lance.", "Uccidi Orrok il Maestro delle Lance.", "창의 달인 오로크를 처치해야 합니다.", "Mate Orrok, o Mestre das Lanças.", "Убейте Оррока Мастера Копья.", "击败长枪战神奥罗克", "殺死『戰矛大師』歐若克。", }, 
{ "Kill all orcs in Grommar.", "Tötet alle Orcs in Grommar.", "Mata a todos los orcos de Grommar.", "Mata a todos los orcos en Grommar.", "Tuez tous les orcs de Grommar.", "Uccidi tutti gli Orchi a Grommar.", "그롬마르에 있는 모든 오크를 처치해야 합니다.", "Mate todos os orcs em Grommar.", "Убейте всех орков в Громмаре.", "消灭格罗玛尔的所有兽人。", "殺光葛羅瑪的獸人。", }, 
{ "Clear the remaining orcs from the docks and slay Commander Vorka.", "Befreit die Docks von den restlichen Orcs und tötet Kommandant Vorka.", "Acaba con los orcos que quedan en los muelles y mata al comandante Vorka.", "Acaba con los orcos restantes en los muelles y mata al comandante Vorka.", "Débarrassez les docks des orcs restants et tuez le commandant Vorka.", "Elimina gli Orchi ancora presenti nel porto e uccidi il Comandante Vorka.", "부두에서 남은 오크를 제거하고 사령관 보르카를 처치해야 합니다.", "Elimine os orcs que sobraram nas docas e mate o Comandante Vorka.", "Перебейте оставшихся орков в доках и убейте командира Ворку.", "肃清码头上的兽人残兵并击败指挥官沃尔卡。", "清光碼頭來的剩餘獸人，殺死指揮官沃爾卡。", }, 
},
["575"] = {
{ "Defeat the bosses of The Oculus", "Besiegt die Bosse im Oculus.", "Derrota a los jefes de El Oculus.", "Derrota a los jefes de El Oculus.", "Terrassez les boss de l’Oculus.", "Sconfiggi i boss dell'Oculus.", "마력의 눈 우두머리들을 처치해야 합니다.", "Derrote os chefes do Óculus.", "Победите боссов в Окулусе", "击败魔环的首领", "擊敗奧核之眼的首領", }, 
},
["1133"] = {
{ "Learn about being a Rogue.", "Erfahrt etwas über das Leben als Schurke.", "Infórmate sobre ser un pícaro.", "Averigua más sobre ser un pícaro.", "Apprenez-en davantage sur les voleurs.", "Impara il significato di essere un Ladro.", "도적에 대해 배워야 합니다.", "Aprenda sobre os Ladinos.", "Узнайте, что значит быть разбойником.", "学习如何成为一名潜行者。", "學習如何當一名盜賊。", }, 
{ "Learn about Deadly Poison.", "Erfahrt mehr über 'Tödliches Gift'.", "Infórmate sobre Veneno mortal.", "Averigua más sobre Veneno mortal.", "Apprenez-en davantage sur Poison mortel.", "Impara come usare Veleno Mortale.", "맹독에 대해 배워야 합니다.", "Aprenda sobre Veneno Mortal.", "Научитесь применять \"Смертоносный яд\".", "学习致命药膏。", "學習如何使用致命毒藥。", }, 
{ "Learn about Stealth", "Erfahrt mehr über 'Verstohlenheit'.", "Infórmate sobre Sigilo.", "Averigua más sobre Sigilo.", "Apprenez-en davantage sur Camouflage.", "Impara come usare Furtività.", "은신에 대해 배워야 합니다.", "Aprenda sobre Furtividade", "Научитесь применять \"Незаметность\".", "学习潜行。", "學習如何使用潛行。", }, 
{ "Learn about Garrote.", "Erfahrt mehr über 'Erdrosseln'.", "Infórmate sobre Garrote.", "Averigua más sobre Garrote.", "Apprenez-en davantage sur Garrot.", "Impara come usare Garrota.", "목조르기에 대해 배워야 합니다.", "Aprenda sobre Garrote.", "Научитесь применять \"Гарроту\".", "学习锁喉。", "學習如何使用絞喉。", }, 
{ "Learn about Mutilate.", "Erfahrt mehr über 'Verstümmeln'.", "Infórmate sobre Mutilar.", "Averigua más sobre Mutilar.", "Apprenez-en davantage sur Estropier.", "Impara come usare Mutilazione.", "절단에 대해 배워야 합니다.", "Aprenda sobre Mutilar.", "Научитесь применять \"Расправу\".", "学习毁伤。", "學習如何使用截肢。", }, 
{ "Learn about Rupture.", "Erfahrt mehr über 'Blutung'.", "Infórmate sobre Ruptura.", "Averigua más sobre Ruptura.", "Apprenez-en davantage sur Rupture.", "Impara come usare Perforazione.", "파열에 대해 배워야 합니다.", "Aprenda sobre Ruptura.", "Научитесь применять \"Рваную рану\".", "学习割裂。", "學習如何使用割裂。", }, 
{ "Learn about Envenom.", "Erfahrt mehr über 'Vergiften'.", "Infórmate sobre Envenenar.", "Averigua más sobre Envenenar.", "Apprenez-en davantage sur Envenimer.", "Impara come usare Affondo Venefico.", "독살에 대해 배워야 합니다.", "Aprenda sobre Envenenar.", "Научитесь применять \"Отравление\".", "学习毒伤。", "學習如何使用毒化。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Vanish.", "Erfahrt mehr über 'Verschwinden'.", "Infórmate sobre Esfumarse.", "Averigua más sobre Esfumarse.", "Apprenez-en davantage sur Disparition.", "Impara come usare Sparizione.", "소멸에 대해 배워야 합니다.", "Aprenda sobre Sumir.", "Научитесь применять \"Исчезновение\".", "学习消失。", "學習如何使用消失。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["423"] = {
{ "Defeat the Adherents of Rukhmar atop Skyreach.", "Bezwingt die Jünger von Rukhmar auf der Himmelsnadel.", "Derrota a los Adeptos de Rukhmar en lo alto del Trecho Celestial.", "Derrota a los Partidarios de Rukhmar en lo alto del Trecho Celestial.", "Terrassez les Adhérents de Rukhmar au sommet d’Orée-du-Ciel.", "Sconfiggi i Proseliti di Rukhmar in cima a Vetta dei Cieli.", "하늘탑 꼭대기에 있는 루크마르의 신봉자들을 처치해야 합니다.", "Derrote os Seguidores de Rukhmar no topo de Beira-céu.", "Одолейте Приверженцев Рухмар в Небесном Пути.", "击败通天峰的鲁克玛信徒。", "擊敗擎天峰頂的魯克馬爾擁護者", }, 
},
["674"] = {
{ "Defeat the bosses of The Stonecore", "Bezwingt die Bosse des Steinernen Kerns.", "Derrota a los jefes de El Núcleo Pétreo.", "Derrota a los jefes de El Núcleo Pétreo", "Triomphez des boss du Cœur-de-Pierre.", "Sconfiggi i boss del Nucleo di Pietra.", "바위심장부 우두머리들을 처치해야 합니다.", "Derrote os chefes do Litocerne", "Победите боссов в Каменных Недрах", "击败巨石之核的首领", "擊敗石岩之心的首領", }, 
},
["527"] = {
{ "Defeat the bosses of Gate of the Setting Sun.", "Besiegt die Bosse beim Tor der Untergehenden Sonne.", "Derrota a los jefes de la Puerta del Sol Poniente.", "Derrota a los jefes de la Puerta del Sol Poniente.", "Terrassez les boss de la porte du Soleil couchant.", "Sconfiggi i boss della Porta del Sole Calante.", "석양문 우두머리들을 처치해야 합니다.", "Derrote os chefes do Portal do Sol Poente.", "Победите боссов у Врат Заходящего Солнца.", "击败残阳关的首领。", "擊敗落陽關的首領", }, 
},
["634"] = {
{ "Defeat the bosses of The Blood Furnace", "Bezwingt die Bosse des Blutkessels.", "Derrota a los jefes de El Horno de Sangre.", "Derrota a los jefes de El Horno de Sangre.", "Terrassez les boss de la Fournaise du sang.", "Sconfiggi i boss della Forgia del Sangue.", "피의 용광로 우두머리들을 처치해야 합니다.", "Derrote os chefes da Fornalha de Sangue", "Победите боссов в Кузне Крови", "击败鲜血熔炉的首领", "擊敗血熔爐的首領", }, 
},
["1131"] = {
{ "You have successfully pierced the holy barriers protecting the Black Temple. Confer with Kayn Sunfury and prepare to confront Akama.", "Ihr habt die heiligen Barrieren, die den Schwarzen Tempel schützen, erfolgreich durchbrochen. Beratet Euch mit Kayn Sonnenzorn und bereitet Euch auf die Konfrontation mit Akama vor.", "Has conseguido penetrar las barreras benditas que protegen el Templo Oscuro. Consulta con Kayn Furia del Sol y prepárate para enfrentarte a Akama.", "Has logrado atravesar las barreras sagradas que protegen el Templo Oscuro. Ve a hablar con Kayn Furia del Sol y prepárate para plantarte ante Akama.", "Vous avez réussi à percer les barrières sacrées protégeant le Temple noir. Discutez avec Kayn Solfurie et préparez-vous à affronter Akama.", "Hai penetrato con successo le barriere sacre a protezione del Tempio Nero. Parla con Kayn Furiasolare e affronta Akama.", "검은 사원을 보호하는 신성한 방벽을 뚫었습니다. 카인 선퓨리와 의논하여 아카마와의 대면을 준비해야 합니다.", "Você conseguiu atravessar as barreiras sagradas que protegem o Templo Negro. Consulte Kayn Solfúria e prepare-se para enfrentar Akama.", "Вы преодолели барьеры Света, защищающие Черный храм. Поговорите с Кайном и приготовьтесь встретиться с Акамой.", "你成功穿透了保护着黑暗神殿的神圣屏障。和凯恩·日怒谈谈，准备与阿卡玛对峙。", "你已經成功穿過保護黑暗神廟的神聖屏障。跟凱恩‧日怒商討，準備對抗阿卡瑪。", }, 
{ "The gates to the Temple Summit proper are closed. Akama is on the other side. Have your Illidari force a way in.", "Die Tore zur Tempelspitze sind fest verschlossen. Akama befindet sich auf der anderen Seite. Eure Illidari sollen sich gewaltsam Zutritt verschaffen.", "Las puertas de la Cima del Templo propiamente dicha están cerradas. Akama está al otro lado. Haz que tus Illidari encuentren el modo de entrar.", "Las puertas de la Cima del Templo están cerradas. Akama está del otro lado. Haz que tus Illidari entren por la fuerza.", "Les portes menant au sommet du temple sont fermées. Akama se trouve de l’autre côté. Dites à vos Illidari de forcer le passage.", "I cancelli della Sommità del Tempio sono chiusi e Akama è dall'altra parte. Ordina ai tuoi Illidari di farsi strada all'interno.", "사원 정상으로 가는 관문이 닫혀있습니다. 아카마는 관문 너머에 있습니다. 일리다리 군대를 앞세워 길을 뚫어야 합니다.", "Os portões do Ápice do Templo estão fechados. Akama encontra-se do outro lado. Faça com que seus Illidari providenciem uma entrada.", "Врата на Храмовую вершину закрыты. Акама по другую сторону. Найдите для иллидари способ войти.", "通往神殿之巅的大门完全关闭了。阿卡玛在门里面。让你的伊利达雷强行突入。", "前往神廟頂層的大門關住了。阿卡瑪就在另一邊。命你的伊利達瑞強行突破。", }, 
{ "Enter the Temple Summit and confront Akama. Convince him to join you in taking the fight to the Burning Legion's worlds.", "Betretet die Tempelspitze und stellt Akama zur Rede. Überzeugt ihn, den Kampf gegen die Brennende Legion mit Euch in ihre Welten zu bringen.", "Entra en la Cima del Templo y enfréntate a Akama. Convéncelo de que se una a tu lucha en los mundos de la Legión Ardiente.", "Entra a la Cima del Templo y confróntalo a Akama. Convéncelo de que te ayude a llevar la guerra a los mundos de la Legión Ardiente.", "Accédez au sommet du temple et affrontez Akama. Persuadez-le d’attaquer avec vous les mondes de la Légion ardente.", "Raggiungi la Sommità del Tempio e affronta Akama. Convincilo a unirsi a te nella battaglia contro la Legione Infuocata.", "사원 정상으로 올라가 아카마와 대면해야 합니다. 그리고 불타는 군단의 세계를 함께 침공하자고 설득해야 합니다.", "Entre no Ápice do Templo e confronte Akama. Convença-o a unir forçar e levar o combate ao mundo da Legião Ardente.", "Взойдите на Храмовую вершину и сразитесь с Акамой. Убедите его принять вашу сторону и атаковать миры Пылающего Легиона.", "进入神殿之巅，与阿卡玛对峙。说服他加入你的队伍，并肩抵抗燃烧军团。", "進入神廟頂層，挑戰阿卡瑪。試圖說服他加入你的部隊，共同朝燃燒軍團的世界進攻。", }, 
{ "Akama will not be persuaded by words. Perhaps force will do the trick. But, how to win and not lose in doing so?", "Akama wird sich nicht durch Worte überzeugen lassen. Vielleicht hilft etwas Zwang. Doch wie soll man dabei gewinnen und nicht verlieren?", "Akama no se deja persuadir con palabras. Quizás la fuerza funcione. Pero ¿cómo ganar y no perder al mismo tiempo?", "Akama no se dejará llevar por palabras. Quizás la fuerza sea la clave. Sin embargo, no será fácil ganar sin perder al mismo tiempo.", "Il faudra plus que des mots pour convaincre Akama. La force fera peut-être l’affaire. Mais comment l’emporter sans risquer de tout perdre ?", "Akama non sarà persuaso da semplici parole, quindi sarà necessaria un po' di forza. Ma come possiamo essere sicuri che sia la strada giusta da seguire?", "아카마를 말로 설득할 수는 없을 겁니다. 강한 힘을 보여주는 편이 나을지 모릅니다. 어떻게 제압해야 가장 피해가 적을까요?", "Palavras não convencerão Akama. Usar a força talvez resolva. Mas como não ser derrotado no processo?", "Словами Акаму не убедить. Может быть, это удастся сделать силой. Но как одолеть столь серьезного противника?", "言辞无法说服阿卡玛。也许要用武力强迫才行。但是即使使用武力，又要怎样才能让他就范，而不会落得双输的局面呢？", "單用說的無法說服阿卡瑪。或許要用力量威逼才行。不過，要怎麼確保我們只勝不敗呢？", }, 
{ "Akama is defeated. Speak with him and convince him to join you.", "Akama wurde besiegt. Sprecht mit ihm und überzeugt ihn davon, sich Euch anzuschließen.", "Akama ha sido derrotado. Habla con él y convéncelo de que se te una.", "Akama está derrotado. Habla con él y convéncelo de que se te una.", "Akama est vaincu. Parlez-lui pour le convaincre de se rallier à vous.", "Akama è sconfitto. Parla con lui e convincilo a unirsi a te.", "아카마를 제압했습니다. 이제 그와 대화하여 힘을 빌려달라고 설득해야 합니다.", "Akama está derrotado. Convença-o a ser seu aliado.", "Акама побежден. Поговорите с ним и убедите принять вашу сторону.", "阿卡玛被击败了。和他谈谈，说服他加入你。", "擊敗阿卡瑪了。跟他說話，說服他加入你。", }, 
},
["1321"] = {
{ "Defeat Mephistroth and place the Aegis of Aggramar within the top of the tomb before you are overrun by the Legion.", "Bezwingt Mephistroth und platziert die Aegis von Aggramar im oberen Bereich des Grabmals, bevor Ihr von der Legion überrannt werdet.", "Derrota a Mephistroth y coloca la Égida de Aggramar en lo alto de la tumba antes de que la Legión lo invada todo.", "Derrota a Mephistroth y coloca la Égida de Aggramar en la cumbre de la tumba antes de que las fuerzas de la Legión arrasen contigo.", "Battez Méphistroth et placez l’Égide d’Aggramar au sommet de la tombe avant que la Légion vous submerge.", "Sconfiggi Mefistroth e piazza l'Egida di Aggramar nella sala in cima alla Cattedrale prima dell'invasione della Legione.", "군단에 짓밟히기 전에 메피스트로스를 처치하고 아그라마르의 아이기스를 무덤 꼭대기에 놓아야 합니다.", "Derrote Mephistroph e ponha a Égide de Aggramar no topo da tumba antes que a Legião subjugue você.", "Победите Мефистрота и установите Эгиду Агграмара на верхнем ярусе гробницы, пока силы Легиона не одолели вас.", "击败孟菲斯托斯，并在军团占领这里前把阿格拉玛之盾放置在墓穴顶层。", "在你被燃燒軍團消滅之前，擊敗梅菲斯托並且將阿格拉瑪之盾放置在墓地頂端。", }, 
},
["1123"] = {
{ "Master Mathias Shaw awaits at the Stormwind gates.", "Meister Mathias Shaw wartet bei den Toren von Sturmwind.", "El maestro Mathias Shaw te aguarda en las puertas de Ventormenta.", "El Maestro Mathias Shaw espera en las puertas de Ventormenta.", "Maître Mathias Shaw attend aux portes de Hurlevent.", "Il Maestro Mathias Shaw attende ai cancelli di Roccavento.", "단장 마티아스 쇼가 스톰윈드 성문을 감시하고 있습니다.", "O mestre Mathias Shaw aguarda aos portões de Ventobravo.", "Мастер Матиас Шоу ждет у врат Штормграда.", "马迪亚斯·肖尔大师在暴风城大门等着你。", "馬迪亞斯‧肖爾大師在暴風城大門等候。", }, 
{ "Meet with Elling Trias and obtain a smoke bomb.", "Treffet Euch mit Elling Trias und beschafft eine Rauchbombe.", "Reúnete con Elling Trias y consigue una bomba de humo.", "Reúnete con Elling Trias y obtén una bomba de humo.", "Retrouvez Elling Trias et obtenez une bombe fumigène.", "Incontra Elling Trias e ottieni una bomba fumogena.", "엘링 트리아스를 만나서 연막탄을 얻어야 합니다.", "Encontre Elling Trias e consiga uma bomba de fumaça.", "Встретьтесь с Иллингом Триасом и возьмите у него дымовую шашку.", "和埃林·提亚斯会面，获得一枚烟雾弹。", "和伊林·提亞斯見面，取得煙霧彈。", }, 
{ "Use the smoke bomb to create a distraction in the Trader's Hall.", "Setzt die Rauchbombe im Auktionshaus als Ablenkungsmanöver ein.", "Usa la bomba de humo para crear una distracción en la Sala de mercaderes.", "Usa la bomba de humo para generar una distracción en la Sala de mercaderes.", "Utilisez la bombe fumigène pour créer une diversion dans le hall du Commerce.", "Usa la bomba fumogena per creare un diversivo nella Sala del Commerciante.", "교역의 전당에서 연막탄을 사용해 혼란을 조성해야 합니다.", "Use a bomba de fumaça para criar uma distração no Salão dos Comerciantes.", "Используйте дымовую шашку для отвлекающего маневра в Торговом зале.", "用烟雾弹在交易者大厅分散人们的注意力。", "在貿易大廳使用煙霧彈，製造騷動。", }, 
{ "Obtain information about where the cultists are meeting within Stormwind.", "Beschafft Informationen darüber, wo die Kultisten sich in Sturmwind treffen.", "Consigue información sobre dónde se reúnen los cultores en Ventormenta.", "Obtén información sobre la ubicación en donde se reúnen los cultores dentro de Ventormenta.", "Obtenez des informations sur l’endroit où les sectateurs se retrouvent à Hurlevent.", "Ottieni informazioni sul luogo d'incontro dei cultisti a Roccavento.", "스톰윈드에서 이교도들이 만나는 장소에 관한 정보를 입수해야 합니다.", "Consiga informações sobre onde os sectários se reúnem em Ventobravo.", "Разузнайте как можно больше о месте встречи сектантов в Штормграде.", "获得教徒在暴风城的集会地点的情报。", "收集情報，找出教徒在暴風城的集會地點。", }, 
{ "Escape the chaos and meet Garona at the Pig and Whistle Tavern in Old Town.", "Entflieht dem Chaos und trefft Euch mit Garona in der Taverne \"Zum Pfeifenden Schwein\" in der Altstadt.", "Huye del caos y reúnete con Garona en la taberna El Cerdo Borracho en el Casco Antiguo.", "Escapa del caos y reúnete con Garona en El Cerdo Borracho, en el Casco Antiguo.", "Échappez au chaos et rejoignez Garona à la taverne du Cochon siffleur dans la Vieille ville.", "Fuggi dal caos e incontra Garona alla Taverna del Porco Urlante nella Città Vecchia.", "혼란을 뚫고 구 시가지의 돼지와 휘파람 선술집에 있는 가로나와 만나야 합니다.", "Escape do caos e encontre Garona, na Taberna do Javatusco Saltitante, na Cidade Velha.", "Прорвитесь сквозь хаос и встретьтесь с Гароной в таверне \"Свинья и Свисток\" в Старом городе.", "逃离混乱，在旧城区的猪和哨声旅店与迦罗娜会面。", "逃離混亂的局面，到舊城區的豬和哨聲旅店找迦羅娜。", }, 
{ "Enter the tavern and make Althea Ebonlocke tell you where her master lies.", "Betretet die Taverne und bringt Althea Schwarzhaupt dazu, Euch zu sagen, wo ihr Meister ist.", "Entra en la taberna y haz que Althea Cerranegro te diga dónde está su maestro.", "Entra a la taberna y haz que Althea Cerranegro te diga dónde yace su maestro.", "Entrez dans la taverne et obligez Althea Bouclenoire à vous dire où se trouve son maître.", "Entra nella taverna e costringi Althea Serranero a rivelarti dove si trova il suo maestro.", "선술집에 들어가서 알시아 에본로크가 그녀의 주군이 있는 장소를 실토하게 해야 합니다.", "Entre na taverna e faça com que Aldora Ebanez revele o paradeiro de seu mestre.", "Отправляйтесь в таверну и заставьте Алтею Чернодрев признаться, где прячется ее повелитель.", "进入旅店，让阿尔泰娅·埃伯洛克告诉你，她的师傅躺在哪里。", "走進旅店，要奧爾希雅‧埃伯洛克告訴你她的主人在那裡。", }, 
{ "You must find the Herald in Stormwind Keep before he summons the Legion into the city!", "Ihr müsst den Herold auf Burg Sturmwind finden, bevor er die Legion in die Stadt holt!", "¡Tienes que localizar al Heraldo en el Castillo de Ventormenta antes de que invoque a la Legión en la ciudad!", "¡Debes encontrar al Heraldo en el Castillo de Ventormenta antes de que convoque a la Legión a la ciudad!", "Trouvez le héraut dans le donjon de Hurlevent avant qu’il n’invoque la Légion dans la ville !", "Trova l'Alfiere al Forte di Roccavento prima che evochi la Legione nella città!", "스톰윈드 왕궁에 있는 전령이 군단을 소환하기 전에 찾아내야 합니다!", "Você deve encontrar o Arauto na Bastilha Ventobravo antes que ele evoque a Legião, dentro da cidade!", "Найдите Глашатая в крепости Штормграда до того, как он призовет демонов Легиона в город.", "你必须在暴风要塞中找到传令官，否则他就会将军团召唤到暴风城里！", "你必須在信使召喚燃燒軍團進入暴風要塞之前找到他！", }, 
{ "It's up to you to assassinate Melris and put and end to this once and for all.", "Es liegt an Euch, Melris zu töten und all dem ein für alle Mal eine Ende zu bereiten.", "Debes asesinar a Melris y poner fin a esto de una vez por todas.", "Depende de ti asesinar a Melris y poner fin a esto de una vez por todas.", "C’est vous qui devez assassiner Melris pour mettre un terme définitif à toute cette histoire.", "Uccidi Melris e metti fine a tutto questo.", "당신만이 멜리스를 암살할 수 있습니다. 그자의 목숨을 확실히 끊어놔야 합니다.", "Cabe a você assassinar Melris e colocar um fim nisso tudo, de uma vez por todas.", "Если вы хотите положить всему этому конец раз и навсегда, вам нужно ликвидировать Мерлиса.", "只能靠你去刺杀梅里斯了，一劳永逸地解决这件事吧。", "你必須暗殺梅里斯，永遠解決這件事。", }, 
{ "Take up the Kingslayers as your own.", "Nehmt die Königsmörder an Euch.", "Aprópiate de las Matarreyes.", "Apodérate de las Matarreyes.", "Emparez-vous des Régicides.", "Brandisci le Lame Sterminatrici di Re.", "국왕 시해자를 획득해야 합니다.", "Tome as Regicidas para si.", "Возьмите Убийцы Королей.", "拿起弑君者。", "把弒君之刃取為己用。", }, 
{ "Mathias Shaw has kindly provided you with transportation to Dalaran.", "Mathias Shaw hat für Euch freundlicherweise ein Portal nach Dalaran öffnen lassen.", "Mathias Shaw ha tenido la amabilidad de brindarte transporte a Dalaran.", "Mathias Shaw te ofreció muy amablemente transporte a Dalaran.", "Mathias Shaw a eu la bonté de vous trouver un moyen de transport pour Dalaran.", "Mathias Shaw è pronto a portarti a Dalaran.", "마티아스 쇼가 친절하게도 달라란으로 가는 차원문을 제공해주었습니다.", "Mathias Shaw providenciou-lhe, gentilmente, um transporte até Dalaran.", "Матиас Шоу любезно предоставил вам транспорт до Даларана.", "马迪亚斯·肖尔体贴地为你提供了前往达拉然的交通方式。", "馬迪亞斯·肖爾好心提供你前往達拉然的運輸工具。", }, 
},
["65"] = {
{ "Assist Blanche in brewing her famous Boomer's Brew.", "Helft Blanche dabei, ihr berühmtes Hammerbräu zu brauen.", "Ayuda a Clara a fermentar su famosa cerveza relámpago.", "Ayuda a Clara a fermentar su famosa cerveza relámpago.", "Aidez Blanche à brasser sa célèbre bière qui détone.", "Assisti Blanche a preparare la sua famosa Birra Esplosiva.", "블랜치가 유명한 폭발 맥주 만드는 것을 도와야 합니다.", "Ajude Blanche a preparar a lendária Cerveja Explosiva.", "Помогите Бланш сварить ее легендарный \"Громобой\".", "帮助布兰琪酿造她远近闻名的闪电佳酿。", "協助白蘭琪釀造她遠近馳名的轟隆酒。", }, 
{ "Escort Blanche down Thunderpaw Road.", "Eskortiert Blanche entlang des Donnerpfotenpfads.", "Escolta a Clara por el camino a Zarpa Atronadora.", "Escolta a Clara por el camino a Zarpa Atronadora.", "Escortez Blanche le long de la route de Patte-du-Tonnerre.", "Scorta Blanche lungo la strada degli Zampa Tonante.", "블랜치를 썬더포우까지 호위해야 합니다.", "Escolte Blanche pela estrada de Pata do Trovão.", "Проводите Бланш по дороге Громовой Лапы.", "护送布兰琪前往雷掌之路。", "護送白蘭琪安全通過雷爪路。", }, 
{ "Defeat Borokhula the Destroyer.", "Bezwingt Borokhula den Zerstörer.", "Derrota a Borokhula el Destructor.", "Derrota a Borokhula el Destructor.", "Terrassez Borokhula le Destructeur.", "Sconfiggi Borokhula il Distruttore.", "파괴자 보로쿨라를 처치해야 합니다.", "Derrote Borokhula, a Destruição.", "Одолейте Борохалу Разрушителя.", "击败毁灭者波罗库拉。", "殺死『毀滅者』波羅庫拉。", }, 
{ "Complete the Bonus Objective to receive bonus Valor.", "Erfüllt das Bonusziel, um zusätzliche Tapferkeitspunkte zu erhalten.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Accomplissez l’objectif bonus pour recevoir des points de vaillance supplémentaires.", "Completa l'obiettivo bonus per ricevere Punti Valore aggiuntivi.", "추가 목표를 완료하면 용맹 점수를 더 얻을 수 있습니다.", "Complete o objetivo bônus para receber Bravura extra.", "Выполните дополнительную задачу, чтобы получить бонусные очки доблести.", "完成奖励目标，获得额外的勇气点数。", "完成獎勵目標以獲取額外的勇氣點數。", }, 
},
["1177"] = {
{ "Explore the sprawling depths of The Arcway.", "Erforscht die verzweigten Tiefen des Arkus.", "Explora las inmensas profundidades de La Arquería.", "Explora las extensivas profundidades del Arco.", "Explorez les vastes profondeurs de l’Arcavia.", "Esplora le profondità sconosciute dell'Arcavia.", "제멋대로 뻗어 나가는 비전로를 탐험해야 합니다.", "Explore a as intrincadas profundezas do Arcâneo.", "Исследуйте глубины катакомб Сурамара.", "探索魔法回廊延展的深处。", "探索錯綜複雜的幽暗地道。", }, 
},
["45"] = {
{ "Defeat the forces creating chaos within the Stormstout Brewery.", "Bezwingt die Kräfte, die in der Brauerei Sturmwind Chaos anrichten.", "Derrota a las fuerzas que están creando el caos en la Cervecería del Trueno.", "Derrota a las fuerzas que están creando el caos en la Cervecería del Trueno.", "Terrassez les troupes qui sèment le chaos dans la brasserie Brune d’Orage.", "Sconfiggi le forze che hanno gettato il caos nel Birrificio Triplo Malto.", "스톰스타우트 양조장에서 혼란을 야기하는 적들을 처치해야 합니다.", "Derrote as forças que estão criando caos na Cervejaria Malte do Trovão.", "Победите силы хаоса в хмелеварне Буйных Портеров.", "击败在风暴烈酒酿造厂内制造混换的敌人。", "擊敗在風暴烈酒酒坊作亂的部隊。", }, 
},
["920"] = {
{ "Enter the Eye of Azshara and stop the Wrath of Azshara from being unleashed upon the Broken Isles.", "Begebt Euch in das Auge Azsharas und verhindert, dass Azsharas Zorn auf die Verheerten Inseln entfesselt wird.", "Entra en el Ojo de Azshara y evita que la Cólera de Azshara se desate sobre las Islas Abruptas.", "Entra al Ojo de Azshara y evita que la Cólera de Azshara se desate sobre las Islas Quebradas.", "Entrez dans l’Œil d’Azshara et empêchez le Courroux d’Azshara de se déchaîner sur les îles Brisées.", "Entra nell'Occhio di Azshara e impedisci che l'Ira di Azshara venga scatenata sulle Isole Disperse.", "아즈샤라의 눈으로 들어간 다음, 아즈샤라의 분노가 부서진 섬을 파괴하기 전에 막아야 합니다.", "Entre no Olho de Azshara e impeça que a Ira de Azshara seja liberada sobre as Ilhas Partidas.", "Войдите в Око Азшары и остановите Гнев Азшары, пока он не обрушил свою ярость на Расколотые острова.", "进入艾萨拉之眼，阻止艾萨拉之怒席卷整个破碎群岛。", "前往艾薩拉之眼，阻止艾薩拉之怒力量釋放席捲破碎群島。", }, 
},
["1099"] = {
{ "Converse with Thorim and prepare for Prustaga's arrival.", "Unterhaltet Euch mit Thorim und bereitet Euch auf Prustagas Ankunft vor.", "Habla con Thorim y prepárate para la llegada de Prustaga.", "Habla con Thorim y prepárate para la llegada de Prustaga.", "Discutez avec Thorim et préparez l’arrivée de Prustaga.", "Parla con Thorim e preparati all'arrivo di Prustaga.", "토림과 대화하고, 프루스타가의 공격에 대비해야 합니다.", "Converse com Thorim e prepare-se para a chegada de Prustaga.", "Поговорите с Торимом и готовьтесь к приходу Прустаги.", "与托里姆交谈，准备应对普斯塔佳的到来。", "跟索林姆對話，準備迎接普洛絲塔加抵達。", }, 
{ "Fend off Prustaga's vrykul allies.", "Verteidigt Euch gegen Prustagas Vrykulverbündete.", "Detén a los aliados vrykuls de Prustaga.", "Elimina a los aliados vrykul de Prustaga.", "Repoussez les alliés vrykuls de Prustaga.", "Respingi gli alleati Vrykul di Prustaga.", "프루스타가의 브리쿨 동맹의 공격을 막아야 합니다.", "Rechace os aliados vraikalen de Prustaga.", "Отбейте нападение врайкулов, союзников Прустаги.", "抵挡普斯塔佳的维库大军。", "擊退普洛絲塔加的維酷人同伴。", }, 
{ "Prustaga is absorbing Titanstrike's power. She must be stopped!", "Prustaga absorbiert die Macht von Titanenblitz. Sie muss aufgehalten werden!", "Prustaga está absorbiendo el poder de la Furia Titánica. ¡Hay que detenerla!", "Prustaga está absorbiendo el poder de Titánica. ¡Hay que detenerla!", "Prustaga absorbe la puissance de Choc des Titans. Il faut l’en empêcher !", "Prustaga sta assorbendo il potere di Titanassalto. Deve essere fermata!", "프루스타가가 티탄분쇄자의 힘을 흡수하고 있습니다. 저지해야 합니다!", "Prustaga está absorvendo o poder do Trovão Titânico. Você tem que detê-la!", "Прустага пытается вобрать в себя силу Мощи Титанов. Ее нужно остановить!", "普斯塔佳正在吸取泰坦之击的能量。快阻止她！", "普洛絲塔加正在吸收泰坦之擊的能量。阻止她！", }, 
{ "Bind Hati's spirit to your own to save her life.", "Bindet Hatis Geist an den Euren, um ihr Leben zu retten.", "Vincula el espíritu de Hati al tuyo para salvarle la vida.", "Une el espíritu de Hati al tuyo para salvarle la vida.", "Liez l’esprit de Hati au vôtre pour lui sauver la vie.", "Vincola lo spirito di Hati al tuo per salvarle la vita.", "하티의 생명을 구하려면 그 영혼을 당신의 영혼에 결속해야 합니다.", "Vincule o espirito de Hati ao seu para salvar a vida dela.", "Свяжите дух Хати с вашим собственным, чтобы спасти его.", "将哈提的灵魂与你绑定以拯救她的生命。", "將哈提的靈魂與你相連來救他一命。", }, 
{ "You must wield Titanstrike so Hati's absorbed power can return to the legendary rifle.", "Ihr müsst Titanenblitz führen, damit Hatis absorbierte Macht in das legendäre Gewehr zurückkehren kann.", "Tienes que blandir la Furia Titánica para que el poder absorbido de Hati pueda volver al legendario rifle.", "Debes usar a Titánica para que el poder que le quitaron a Hati pueda volver al legendario rifle.", "Vous devez brandir Choc des Titans pour que la puissance absorbée par Hati réintègre le fusil légendaire.", "Devi impugnare Titanassalto affinché il potere assorbito di Hati possa tornare al fucile leggendario.", "티탄분쇄자를 사용해 하티의 흡수된 힘이 전설의 라이플로 돌아가게끔 해야 합니다.", "Você tem que usar o Trovão Titânico para que o poder absorvido de Hati possa voltar ao rifle lendário.", "Вы должны взять Мощь Титанов в руки, чтобы сила, поглощенная Хати, смогла вернуться в легендарное ружье.", "你必须带着泰坦之击，这样哈提所吸收的能量就能返还到这把传奇武器中。", "你必須使用泰坦之擊，才能讓被哈提吸收的力量回到傳奇步槍中。", }, 
{ "Return to Dalaran with Grif.", "Kehrt mit Grif nach Dalaran zurück.", "Vuelve a Dalaran con Grif.", "Vuelve a Dalaran con Grif.", "Regagnez Dalaran avec Grif.", "Torna a Dalaran con Grif.", "그리프와 함께 달라란으로 귀환해야 합니다.", "Volte a Dalaran com Grif.", "Возвращайтесь в Даларан вместе с Грифом.", "与格瑞夫一起回达拉然。", "和格瑞夫一同返回達拉然。", }, 
},
["632"] = {
{ "Defeat the bosses of The Slave Pens", "Bezwingt die Bosse der Sklavenunterkünfte.", "Derrota a los jefes de Recinto de los Esclavos.", "Derrota a los jefes del Recinto de los Esclavos.", "Terrassez les boss des enclos aux esclaves.", "Sconfiggi i boss delle Fosse degli Schiavi.", "강제 노역소 우두머리들을 처치해야 합니다.", "Derrote os chefes do Pátio dos Escravos", "Победите боссов в Узилище", "击败奴隶围栏的首领", "擊敗奴隸監獄的首領", }, 
},
["944"] = {
{ "The village is shrouded in mists. Light the bonfire to clear it and provoke the Helarjar.", "Das Dorf ist in Nebel gehüllt. Entzündet das Feuer, um ihn zu vertreiben und die Helarjar zu provozieren.", "La aldea está envuelta en niebla. Enciende la hoguera para despejarla y provocar a los Helarjar.", "La aldea está sumida en la niebla. Enciende la fogata para despejarla y provoca al Helarjar.", "Le village est enveloppé de brumes. Allumez le feu de joie pour les dissiper et provoquer les Helarjar.", "Il villaggio è avvolto dalle nebbie. Accendi il falò per disperderle e provocare gli Helarjar.", "마을이 안개에 파묻혔습니다. 화톳불을 피워 안개를 몰아내고 헬라리아르를 도발해야 합니다.", "A vila está envolta em névoa. Acenda a fogueira para afastar a bruma e provocar os helarjares.", "Деревня окутана туманами. Зажгите костер, чтобы рассеять их и спровоцировать хеларьяров.", "这个村庄被迷雾包围了。点燃篝火以清除迷雾，向海拉加尔挑衅。", "村落籠罩在濃濃的迷霧中。點燃篝火驅散迷霧，挑釁黑爾拉亞士兵。", }, 
{ "The kvaldir are enraged at the loss of the mists. Survive their assault until the commanding helarjar arrives, then kill him.", "Die Kvaldir sind über den Verlust der Nebel erbost. Überlebt ihren Angriff, bis der kommandierende Helarjar eintrifft, und tötet ihn dann.", "Los Kvaldir están furiosos por la pérdida de la niebla. Sobrevive a su ataque hasta que llegue el comandante Helarjar y mátalo.", "Los kvaldir están enfurecidos por haber perdido las nieblas. Sobrevive a su ataque hasta que llegue el comandante helarjar, y luego mátalo.", "Les kvaldirs sont furieux qu’on ait osé dissiper les brumes. Survivez à leur assaut jusqu’à l’arrivée du commandant helarjar, puis tuez-le.", "I Kvaldir sono infuriati dalla perdita delle nebbie. Sopravvivi al loro assalto fino all'arrivo del comandante Helarjar, quindi uccidilo.", "안개가 걷히자 크발디르가 광포해집니다. 헬라리아르 지휘관이 도착할 때까지 버틴 다음, 처치해야 합니다.", "Os kvaldir estão furiosos com a perda das névoas. Sobreviva ao ataque até que o helarjar comandante chegue e então o mate.", "Когда туман рассеялся, квалдиры словно взбесились. Отбивайте их атаки, пока не появится командир хеларьяров, после чего убейте его.", "迷雾的散去激怒了克瓦迪尔。抵挡住他们的攻势，直到他们的海拉加尔指挥官抵达，然后消灭他。", "驅散迷霧的舉動激怒了科瓦迪爾。撐過他們的攻擊，直到指揮的黑爾拉亞現身，然後殺了他。", }, 
{ "Vigfus and his souls are below, kill the mystics defending the path down and reach the docks.", "Vigfus und seine Seelen sind unten. Tötet die Mystiker, die den Weg nach unten bewachen, und gelangt an die Docks.", "Vigfus y sus almas están abajo. Mata a los místicos que defienden el paso y llega hasta los muelles.", "Vigfus y sus almas están abajo. Mata a los místicos que defienden el camino y llega hasta el embarcadero.", "Vigfus et ses âmes sont là, en bas. Tuez les mystiques qui gardent le chemin et descendez sur les quais.", "Vigfus e le sue anime sono qui sotto. Uccidi i mistici che difendono il sentiero e raggiungi il porto.", "비그푸스와 그의 영혼들이 아래에 있습니다. 길을 막고 있는 비술사를 처치한 다음 부두로 가야 합니다.", "Vigfus e suas almas estão lá embaixo. Mate os místicos que guardam o caminho e vá até as docas.", "Вигфус и похищенные им души находятся внизу. Убейте мистиков, охраняющих тропу, ведущую вниз, и доберитесь до пристани.", "维格弗斯和他的那些灵魂就在下面，消灭把守道路的秘法师并抵达码头。", "維格弗斯和他的靈魂就在下方，殺掉阻擋去路的秘術使，抵達碼頭。", }, 
{ "Vigfus continues to ignore your presence. Free his cargo of souls to draw him out.", "Vigfus ignoriert weiterhin Eure Anwesenheit. Befreit seine Seelenladung, um ihn hervorzulocken.", "Vigfus sigue ignorando tu presencia. Libera su cargamento de almas para atraerlo.", "Vigfus sigue ignorando tu presencia. Libera su cargamento de almas para obligarlo a salir.", "Vigfus continue à vous ignorer superbement. Libérez sa cargaison d’âmes pour le faire réagir.", "Vigfus continua a ignorare la tua presenza. Libera il suo carico di anime per attirarlo allo scoperto.", "비그푸스가 여전히 당신의 존재를 무시하고 있습니다. 비그푸스의 영혼의 짐을 해방하여 관심을 끌어야 합니다.", "Vigfus continua ignorando sua presença. Solte a carga de almas para atraí-lo.", "Вигфус продолжает игнорировать вас. Освободите плененные им души, чтобы выманить его из укрытия.", "维格弗斯仍然没有理会你。把他关押的那些灵魂都放出来，引他出来。", "維格弗斯繼續無視你的存在。釋放他奪來的靈魂，逼他現身。", }, 
{ "The Bladewind has made an appearance. Slay him!", "Der Klingenwind ist erschienen. Tötet ihn!", "Corriente de Hojas ha aparecido. ¡Mátalo!", "Corriente de hojas hizo su aparición. ¡Destrúyelo!", "Vigfus Vent-de-Lames vient de faire son apparition. Tuez-le !", "Tagliavento ha fatto la sua comparsa. Uccidilo!", "비그푸스 블레이드윈드가 나타났습니다. 그를 처치해야 합니다!", "O Lâmina de Vento fez uma aparição. Mate-o!", "А вот и Вихрь Клинков собственной персоной. Убейте его!", "刀风现身了，消灭他！", "維格弗斯‧刃風終於現身了。殺了他！", }, 
{ "The Bladewind is escaping into the shallows, find and kill him.", "Der Klingenwind flieht in die Untiefen, sucht und tötet ihn.", "Corriente de Hojas se escapa hacia los bajíos. Encuéntralo y mátalo.", "Corriente de hojas escapa hacia los bajos. Encuéntralo y mátalo.", "Vigfus Vent-de-Lames s’échappe par les bas-fonds. Trouvez-le, puis tuez-le.", "Tagliavento sta fuggendo. Trovalo e uccidilo.", "비그푸스가 여울로 탈출하고 있습니다. 그를 찾아낸 다음 처치해야 합니다.", "O Lâmina de Vento está fugindo para a várzea. Encontre-o e mate-o.", "Вихрь Клинков скрылся на отмели. Найдите и убейте его.", "刀风躲进了浅滩，找到并消灭他。", "維格弗斯逃向淺灘了，追過去殺了他！", }, 
{ "The Warswords of the Bladewind are yours. Take them.", "Die Kriegsschwerter des Klingenwinds sind Euer. Nehmt sie.", "Las Espadas de Guerra de los Corriente de Hojas son tuyas. Cógelas.", "Las Espadas de guerra de los Corriente de hojas son tuyas. Tómalas.", "Les épées de guerre du Vent de lames sont à vous. Prenez-les.", "Le spade da guerra dei Turbilama sono tue. Prendile.", "칼바람의 전쟁검은 당신의 것입니다. 검을 획득하십시오.", "As Armíferas do Lâmina de Vento são suas. Pegue-as.", "Боевые мечи Вихря Клинков теперь ваши. Заберите их.", "刀风的战剑是你的了，带走它们。", "刃風戰劍是你的了。拿起它們。", }, 
},
["1179"] = {
{ "Report to Kur'talos Ravencrest.", "Erstattet Kur'talos Rabenkrone Bericht.", "Informa a Kur'talos Cresta Cuervo.", "Informa a Kur'talos Cresta Cuervo.", "Aller voir Kur’talos Corvaltus.", "Fai rapporto a Kur'talos Crinocorvo.", "쿠르탈로스 레이븐크레스트에게 보고해야 합니다.", "Reporte-se a Kur'talos Cristacorvo.", "Поговорите с Кур'талосом Гребнем Ворона.", "向库塔洛斯·拉文凯斯汇报。", "向克塔羅斯‧黑羽回報。", }, 
{ "Repair the Deactivated Moon Guard Portal.", "Repariert das deaktivierte Mondwachenportal.", "Repara el portal de la Guardia Lunar desactivado.", "Repara el portal de la Guardia lunar desactivado.", "Réparez le portail de la garde de la Lune désactivé.", "Ripara il Portale delle Guardie della Luna Disattivato.", "비활성화된 달빛 수호자 차원문을 수리해야 합니다.", "Conserte o Portal da Guarda da Lua Desativado.", "Восстановите неактивный портал Лунных стражей.", "修复关闭的月之守卫传送门。", "修理失去能量的月之守衛傳送門。", }, 
{ "Secure the rampart by defeating Xalian Felblaze.", "Sichert den Wall, indem Ihr Xalian Teufelslohe tötet.", "Asegura la muralla derrotando a Xalian Llamarada Vil.", "Derrota a Xalian de Llamarada vil para poner a salvo las murallas.", "Sécuriser le rempart en triomphant de Xalian Gangrebrasier.", "Metti al sicuro il bastione sconfiggendo Xalian Vilfiamma.", "잘리안 펠블레이즈를 처치해 망루를 확보하십시오.", "Derrote Xalian Brasavil para proteger a muralha.", "Захватите стены, победив Ксалианну Пламя Скверны.", "击败萨里安·邪焰，保卫城墙。", "擊敗薩利安‧魔炎，奪下壁壘。", }, 
{ "Enter the upper ramparts of the courtyard.", "Betretet die oberen Festungswälle des Hofes.", "Ve a las murallas superiores del patio.", "Entra por las murallas superiores del patio.", "Gagnez les remparts supérieurs de la cour.", "Raggiungi il bastione superiore del cortile.", "궁정 위쪽 성벽에 진입해야 합니다.", "Vá para as muralhas superiores do pátio.", "Пробейтесь на верхний ярус стен во дворе.", "进入庭院上层壁垒。", "進入庭院的上層壁壘。", }, 
{ "Activate the remaining Moon Guard portals.", "Aktiviert die verbleibenden Mondwachenportale.", "Activa el resto de portales de la Guardia Lunar.", "Activa los portales restantes de la Guardia lunar.", "Activez les portails de la garde de la Lune restants.", "Attiva i portali delle Guardie della Luna rimanenti.", "다른 달빛 수호자 차원문들을 활성화해야 합니다.", "Ative os portais da Guarda da Lua remanescentes.", "Активируйте оставшиеся порталы Лунных стражей.", "激活剩余的月之守卫传送门。", "啟動剩餘的月之守衛傳送門。", }, 
{ "Destroy the Nihilam Portal and slay Balaadur to end the invasion.", "Zerstört das Portal nach Nihilam und vernichtet Balaadur, um die Invasion zu beenden.", "Destruye el portal a Nihilam y mata a Balaadur para acabar con la invasión.", "Destruye el portal de Nihilam y asesina a Balaadur para terminar con la invasión.", "Détruisez le portail vers Nihilam et tuez Balaadar pour mettre un terme à l’invasion.", "Distruggi il Portale per Nihilam e uccidi Balaadur per porre fine all'invasione.", "니힐람 차원문을 파괴하고 발라두르를 처치하여 침공을 막아야 합니다.", "Destrua o portal Nihilam e mate Balaadur para acabar com a invasão.", "Уничтожьте нигиламский портал и убейте Балаадура, чтобы положить конец вторжению.", "摧毁奈兰传送门并消灭巴拉杜尔以终结入侵。", "破壞奈厄拉姆傳送門與殺死巴拉杜爾，終結惡魔入侵。", }, 
{ "Enter Raven's Glory and destroy the Colossal Siegebreaker.", "Betretet Rabenruhm und zerstört den gigantischen Belagerungsbrecher.", "Ve a Gloria del Cuervo y destruye el rompedor de asedio colosal.", "Entra a la Gloria del Cuervo y destruye al Rompedor de asedio colosal.", "Pénétrez dans l’arène de la Gloire du corbeau et détruisez le brise-siège colossal.", "Entra nella Gloria del Corvo e distruggi lo Spezzassedio Colossale.", "까마귀의 영예에 들어가 거대 공성파괴자를 파괴해야 합니다.", "Entre na Glória do Corvo e destrua o Quebra-cerco Colossal.", "Уничтожьте инфернала-стенолома на арене Славы Ворона.", "进入渡鸦之耀并摧毁巨型攻城地狱火。", "進入玄鴉榮耀競技場，摧毀巨型破陣者。", }, 
},
["744"] = {
{ "Kill inhabitants of rooms to extinguish runes.", "Tötet die Bewohner der Räume, um Runen zu löschen.", "Mata a los moradores de las habitaciones para extinguir runas.", "Mata a moradores de salas para extinguir las runas.", "Tuez les occupants des pièces pour éteindre les runes.", "Uccidi i nemici nelle stanze per estinguere le rune.", "방 안의 생명체들을 처치해 룬을 꺼뜨려야 합니다.", "Mate os habitantes das salas para extinguir as runas.", "Убивайте обитателей покоев, чтобы погасить руны.", "消灭房间内的人以熄灭符文。", "殺死房內的敵人以熄滅符文。", }, 
{ "Defeat the Ironmarch forces occupying the halls of the Spire.", "Besiegt die Truppen des Eisernen Marsches, die die Hallen der Schwarzfelsspitze besetzen.", "Derrota a las tropas de La Marcha de Hierro que ocupan las salas de la Cumbre.", "Derrota a las fuerzas Marcha Férrea que ocupan las cámaras de la Cumbre.", "Terrassez les troupes marchefer qui occupent les salles du pic Rochenoire.", "Sconfiggi le forze della Marcia di Ferro che hanno occupato le sale dei Bastioni di Roccianera.", "첨탑을 장악한 강철선봉대 군대를 무찔러야 합니다.", "Derrote as tropas da Marcha de Ferro que ocupam os salões do Pináculo.", "Победите войска Железного Марша, занявшие залы пика.", "击败占据了黑石塔大厅的铁军部队。", "擊敗佔據了黑石塔上層的鋼鐵戰線部隊。", }, 
},
["616"] = {
{ "Kael'thas has risen from the ashes, he must be stopped!", "Kael'thas ist aus der Asche auferstanden, er muss aufgehalten werden!", "¡Kael'thas ha resurgido de sus cenizas, hay que detenerlo!", "Kael'thas se levantó de las cenizas, ¡hay que detenerlo!", "Kael’thas a pu renaître de ses cendres. Il faut l’arrêter !", "Kael'thas è risorto dalle ceneri, deve essere fermato!", "캘타스가 잿더미에서 일어섰습니다. 그를 막아야 합니다!", "Kael'thas se ergueu das cinzas. Ele precisa ser parado!", "Кель'тас восстал из праха. Его нужно остановить!", "凯尔萨斯又涅槃重生了，你必须阻止他！", "凱爾薩斯從從失敗的灰燼中復甦了，一定要阻止他！", }, 
},
["516"] = {
{ "Defeat the bosses of Shadowfang Keep.", "Besiegt die Bosse von Burg Schattenfang.", "Derrota a los jefes del Castillo de Colmillo Oscuro.", "Derrota a los jefes del Castillo de Colmillo Oscuro.", "Terrassez les boss du donjon d’Ombrecroc.", "Sconfiggi i boss del Forte di Zannascura.", "그림자송곳니 성채 우두머리들을 처치해야 합니다.", "Derrote os chefes da Bastilha da Presa Negra.", "Победите боссов в Крепости Темного Клыка.", "击败影牙要塞的首领。", "擊敗影牙城堡的首領。", }, 
{ "Defeat Baron Silverlaine within Shadowfang Keep.", "Besiegt Baron Silberlein in Burg Schattenfang.", "Derrota al barón Filargenta en el Castillo de Colmillo Oscuro.", "Derrota al Barón Filargenta en el Castillo de Colmillo Oscuro.", "Terrassez le baron d’Argelaine dans le donjon d’Ombrecroc.", "Sconfiggi il Barone Argenius nel Forte di Zannascura.", "그림자송곳니 성채 안에 있는 남작 실버레인을 처치해야 합니다.", "Derrote o Barão Silverlaine na Bastilha da Presa Negra.", "Победите барона Сильверлейна в Крепости Темного Клыка.", "击败影牙要塞的席瓦莱恩男爵。", "在影牙城堡裡面擊敗席瓦萊恩男爵。", }, 
{ "Defeat Commander Springvale within Shadowfang Keep.", "Besiegt Kommandant Grüntal in Burg Schattenfang.", "Derrota al comandante Vallefont en el Castillo de Colmillo Oscuro.", "Derrota a Comandante Vallefont en Castillo de Colmillo Oscuro.", "Terrassez le commandant Printeval dans le donjon d’Ombrecroc.", "Sconfiggi il Comandante Primavalle nel Forte di Zannascura.", "그림자송곳니 성채 안에 있는 사령관 스프링베일을 처치해야 합니다.", "Derrote o Comandante Floraval na Bastilha da Presa Negra.", "Победите командира Спрингвейла в Крепости Темного Клыка.", "击败影牙要塞的指挥官斯普林瓦尔。", "在影牙城堡內擊敗指揮官斯普林瓦爾。", }, 
},
["644"] = {
{ "Defeat the bosses of Zul'Farrak", "Bezwingt die Bosse von Zul'Farrak.", "Derrota a los jefes de Zul'Farrak.", "Derrota a los jefes de Zul'Farrak", "Triomphez des boss de Zul’Farrak.", "Sconfiggi i boss di Zul'Farrak.", "줄파락 우두머리들을 처치해야 합니다.", "Derrote os chefes de Zul'Farrak", "Победите боссов в Зул'Фарраке", "击败祖尔法拉克的首领", "擊敗祖爾法拉克的首領", }, 
{ "Defeat Antu'sul", "Bezwingt Antu'sul", "Derrota a Antu'sul.", "Derrota a Antu'sul", "Triomphez d’Antu’sul.", "Sconfiggi Antu'sul.", "안투술을 처치해야 합니다.", "Derrote Antu'sul", "Победите Анту'сула", "击败安图苏尔", "擊敗安圖蘇爾", }, 
{ "Defeat Theka the Martyr", "Bezwingt Theka den Märtyrer", "Derrota a Theka el Mártir.", "Derrota a Theka el Mártir", "Triomphez de Theka le Martyr.", "Sconfiggi Theka il Martire.", "순교자 데카를 처치해야 합니다.", "Derrote Theka, o Mártir", "Победите Теку Мученика", "击败殉教者塞卡", "擊敗『殉教者』塞卡", }, 
{ "Defeat Witch Doctor Zum'rah", "Bezwingt Hexendoktor Zum'rah", "Derrota al médico brujo Zum'rah.", "Derrota al médico brujo Zum'rah", "Triomphez du féticheur Zum’rah.", "Sconfiggi il Taumaturgo Zum'rah.", "의술사 줌라를 처치해야 합니다.", "Derrote o Mandingueiro Zum'rah", "Победите знахаря Зум'раха", "击败巫医祖穆拉恩", "擊敗巫醫祖穆拉恩", }, 
{ "Defeat Hydromancer Velratha", "Bezwingt Hydromantin Velratha", "Derrota a la hidromántica Velratha.", "Derrota a la hidromántica Velratha", "Triomphez de l’hydromancienne Velratha.", "Sconfiggi l'Idromante Velratha.", "유체술사 벨라타를 처치해야 합니다.", "Derrote o Hidromante Velratha", "Победите гидроманта Велрату", "击败水占师维蕾萨", "擊敗水占師維蕾薩", }, 
{ "Defeat Gahz'rilla", "Bezwingt Gahz'rilla", "Derrota a Gahz'rilla.", "Derrota a Gahz'rilla", "Triomphez de Gahz’rilla.", "Sconfiggi Gahz'rilla.", "가즈릴라를 처치해야 합니다.", "Derrote Gahz'rilla", "Победите Газ'риллу", "击败加兹瑞拉", "擊敗加茲瑞拉", }, 
},
["1027"] = {
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
},
["331"] = {
{ "Allied forces, under the guidance of the Archmage Khadgar, are ready to begin the battle of Shattrath.", "Verbündete Streitkräfte unter Führung von Erzmagier Khadgar sind bereit, sich in die Schlacht um Shattrath zu stürzen.", "Las fuerzas aliadas, bajo el mando del archimago Khadgar, están listas para comenzar la batalla de Shattrath.", "Las fuerzas aliadas, bajo el liderazgo del archimago Khadgar, están listas para comenzar la batalla de Shattrath.", "Les forces alliées commandées par l’archimage Khadgar sont prêtes à se lancer dans la bataille de Shattrath.", "Le forze alleate, sotto il comando dell'Arcimago Khadgar, sono pronte a cominciare la battaglia per Shattrath.", "대마법사 카드가의 지도 아래 뭉친 연합군이 샤트라스 전투를 벌일 준비를 끝냈습니다.", "Forças aliadas, sob o comando do Arquimago Hadggar, estão prontas para começar a batalha de Shattrath.", "Силы союзников под руководством верховного мага Кадгара готовы вступить в битву за Шаттрат.", "集中军力，在大法师卡德加的庇护下，准备发动沙塔斯之战。", "在大法師卡德加的帶領之下，聯盟的軍隊已經準備好進行撒塔斯的戰役。", }, 
{ "Gazlowe and Thaelin have repaired an Iron Star that can take you to the harbor.", "Gazlowe und Thaelin haben einen eisernen Stern repariert, mit dem Ihr den Hafen erreichen könnt.", "Gazlowe y Thaelin han reparado una estrella de hierro que puede llevarte al puerto.", "Gazlowe y Thaelin repararon una Estrella de Hierro que puede llevarte al puerto.", "Gazleu et Thaelin ont réparé une Étoile de Fer qui pourra vous emmener jusqu’au Port.", "Sparachiodi e Thaelin hanno riparato una Pirostella che può farti raggiungere il porto.", "가즈로와 테일린이 당신을 항구로 데려다 줄 강철의 별을 수리했습니다.", "Gasganete e Thaelin consertaram uma Estrela de Ferro que pode levar você até o porto.", "Газлоу и Телин починили железную звезду, с помощью которой можно попасть в гавань.", "加兹鲁维和塞林弄到了一台可以送你前往港口的钢铁之星。", "加茲魯維和塞林已經修好了可以把你送到碼頭的鋼鐵之星。", }, 
{ "Clear the way to the harbor with the Iron Star.", "Macht den Weg zum Hafen mit dem eisernen Stern frei.", "Despeja el camino al puerto con la estrella de hierro.", "Despeja el camino al puerto con la Estrella de Hierro.", "Frayez-vous un chemin jusqu’au Port avec l’Étoile de Fer.", "Apriti la strada fino al porto con l'aiuto della Pirostella.", "강철의 별을 이용해 항구까지 길을 뚫어야 합니다.", "Limpe o caminho até o porto com a Estrela de Ferro.", "Расчистите путь в гавань с помощью железной звезды.", "坐着钢铁之星扫清通向港口的道路。", "用鋼鐵之星清出通到港邊的路。", }, 
{ "The Iron Horde has amassed on the docks. Protect Khadgar while he prepares a spell to neutralize the harbor.", "Die Eiserne Horde hat ihre Streitkräfte in den Docks gesammelt. Beschützt Khadgar, während er einen Zauber vorbereitet, der den Hafen neutralisieren soll.", "La Horda de Hierro se ha reunido en los muelles. Protege a Khadgar mientras prepara un hechizo para neutralizar el puerto.", "La Horda de Hierro se reunió en los muelles. Protege a Khadgar mientras prepara un hechizo para neutralizar el puerto.", "La Horde de Fer s’est rassemblée sur les docks. Protégez Khadgar pendant qu’il prépare un sort pour neutraliser le port.", "L'Orda di Ferro ha ammassato le sue forze sul molo. Proteggi Khadgar mentre prepara un incantesimo per rendere sicuro il porto.", "강철 호드가 항구에 결집했습니다. 카드가가 적들을 무력화시킬 주문을 시전할 동안 그를 보호해야 합니다.", "A Horda de Ferro se reuniu nas docas. Proteja Hadggar enquanto ele prepara um feitiço para neutralizar as docas.", "Железная Орда расположила свои силы в гавани. Защищайте Кадгара, пока он подготавливает нейтрализующее заклинание.", "钢铁部落已经集结在钢铁码头。在卡德加准备横扫港口的法术时保护他。", "鋼鐵部落已經集結在碼頭。保護卡德加，讓他能夠專心準備清理港灣的法術。", }, 
{ "The Iron Horde's fabled weapon is in the harbor. Take over the ship. Your allies will work to keep Blackhand out of your way on the flagship.", "Die legendäre Waffe der Eisernen Horde befindet sich im Hafen. Ergreift die Kontrolle über das Schiff. Eure Verbündeten werden Schwarzfaust auf dem Flaggschiff von Euch fernhalten.", "La famosa arma de la Horda de Hierro está en el puerto. Hazte con el control del barco. Tus aliados se encargarán de mantener a Puño Negro alejado de ti en el buque insignia.", "La legendaria arma de la Horda de Hierro está en el puerto. Apodérate del barco. Tus aliados trabajarán para mantener lejos a Puño Negro de tu camino hacia la nave insignia.", "L’arme principale de la Horde de Fer se trouve dans le Port. Prenez le contrôle du navire. Vos alliés tâcheront de tenir Main-Noire à distance pendant que votre assaut du vaisseau amiral.", "La famigerata arma dell'Orda di Ferro è arrivata al porto. Prendi il controllo della nave. I tuoi alleati cercheranno di tenere occupato Manonera.", "선박 하나에 강철 호드의 강력한 무기가 실려 있습니다. 그 선박을 탈취하십시오. 동료들은 기함에 있는 블랙핸드가 방해하지 못하도록 발을 묶을 것입니다.", "A famosa arma da Horda de Ferro está no porto. Tome a embarcação. Seus aliados vão afastar Mão Negra do seu caminho na nau capitânia.", "Легендарное орудие Железной Орды в гавани. На абордаж! Ваши союзники отвлекут Чернорука на флагманском корабле.", "钢铁部落传说中的武器已经抵达了港口。去占领舰船吧。你的盟友会拖住黑手，不让他阻挠你在旗舰上的工作。", "鋼鐵部落的傳說武器就在港灣裡。拿下那艘旗艦，你的盟友會協助排除想阻礙你的黑手氏族。", }, 
{ "Help defeat Blackhand on the Iron Horde's flagship.", "Helft dabei, Schwarzfaust auf dem Flaggschiff der Eisernen Horde zu bezwingen.", "Ayuda a derrotar a Puño Negro en el buque insignia de la Horda de Hierro.", "Ayuda a derrotar a Puño Negro en la nave insignia de la Horda.", "Contribuez à la défaite de Main-Noire sur le vaisseau amiral de la Horde de Fer.", "Aiuta a sconfiggere Manonera sull'ammiraglia dell'Orda di Ferro.", "강철 호드의 기함에 있는 블랙핸드를 쓰러뜨리는 걸 도와야 합니다.", "Ajude a derrotar Mão Negra na Nau capitânia da Horda de Ferro.", "Помогите победить Чернорука на флагмане Железной Орды.", "在钢铁部落的旗舰上帮忙击败黑手。", "在黑鐵部落旗艦上擊敗黑手。", }, 
},
["318"] = {
{ "Mine as much as you can before you run out of Steam Power!", "Baut so viele Rohstoffe wie möglich ab, bevor Euch die Dampfkraft ausgeht!", "¡Extrae todo lo que puedas antes de que te quedes sin energía de vapor!", "¡Extrae todo lo que puedas de la mina antes de que te quedes sin energía de vapor!", "Minez autant de ressources que possible avant de tomber à court de puissance de vapeur !", "Estrai tutto il minerale possibile prima che si esaurisca la Potenza Vapore!", "증기력이 떨어지기 전에 최대한 많은 자원을 모아야 합니다!", "Minere tudo o que puder antes de ficar sem Energia a Vapor!", "Постарайтесь добыть как можно больше руды, пока не иссяк запас паровой мощи!", "在失去蒸汽能力前尽可能多采集一些矿石！", "在蒸汽動力用完之前盡量採礦！", }, 
},
["531"] = {
{ "Defeat the bosses of Shado-Pan Monastery.", "Besiegt die Bosse des Schado-Pan-Klosters.", "Derrota a los jefes del Monasterio del Shadopan.", "Derrota a los jefes del Monasterio del Shadopan.", "Terrassez les boss du monastère des Pandashan.", "Sconfiggi i boss del Monastero degli Shandaren.", "음영파 수도원 우두머리들을 처치해야 합니다.", "Derrote os chefes do Monastério Shado-pan.", "Победите боссов в монастыре Шадо-Пан.", "击败影踪禅院的首领。", "擊敗影潘僧院的首領。", }, 
},
["932"] = {
{ "Prove your worth and claim the Aegis of Aggramar.", "Beweist, dass Ihr würdig seid und sichert Euch die Aegis von Aggramar.", "Demuestra tu valía y hazte con la Égida de Aggramar.", "Prueba que eres digno y reclama la Égida de Aggramar.", "Prouvez votre valeur et emparez-vous de l’Égide d’Aggramar.", "Prova le tue capacità e ottieni l'Egida di Aggramar.", "자신의 가치를 증명하고 아그라마르의 아이기스를 차지하십시오.", "Prove seu valor e obtenha a Égide de Aggramar.", "Докажите, что вы достойны, и добудьте Эгиду Агграмара.", "证明你的实力，并夺取阿格拉玛之盾", "證明你的資格，並取得阿格拉瑪之盾。", }, 
},
["574"] = {
{ "Defeat the bosses of Zul'Aman.", "Besiegt die Bosse von Zul'Aman.", "Derrota a los jefes de Zul'Aman.", "Derrota a los jefes de Zul'Aman.", "Terrassez les boss de Zul’Aman.", "Sconfiggi i boss di Zul'Aman.", "줄아만 우두머리들을 처치해야 합니다.", "Derrote os chefes de Zul'Aman.", "Победите боссов в Зул'Амане.", "击败祖阿曼的首领。", "擊敗祖阿曼的首領。", }, 
},
["535"] = {
{ "Defeat the bosses of Shado-Pan Monastery.", "Besiegt die Bosse des Schado-Pan-Klosters.", "Derrota a los jefes del Monasterio del Shadopan.", "Derrota a los jefes del Monasterio del Shadopan.", "Terrassez les boss du monastère des Pandashan.", "Sconfiggi i boss del Monastero degli Shandaren.", "음영파 수도원 우두머리들을 처치해야 합니다.", "Derrote os chefes do Monastério Shado-pan.", "Победите боссов в монастыре Шадо-Пан.", "击败影踪禅院的首领。", "擊敗影潘僧院的首領。", }, 
},
["635"] = {
{ "Defeat the bosses of The Blood Furnace", "Bezwingt die Bosse des Blutkessels.", "Derrota a los jefes de El Horno de Sangre.", "Derrota a los jefes de El Horno de Sangre.", "Terrassez les boss de la Fournaise du sang.", "Sconfiggi i boss della Forgia del Sangue.", "피의 용광로 우두머리들을 처치해야 합니다.", "Derrote os chefes da Fornalha de Sangue", "Победите боссов в Кузне Крови", "击败鲜血熔炉的首领", "擊敗血熔爐的首領", }, 
},
["510"] = {
{ "Defeat the prisoners of The Stockade.", "Besiegt die Gefangenen im Verlies.", "Derrota a los prisioneros de Las Mazmorras.", "Derrota a los prisioneros de las Mazmorras.", "Terrassez les détenus de la prison.", "Sconfiggi i prigionieri delle Segrete di Roccavento.", "스톰윈드 지하감옥 죄수들을 처치해야 합니다.", "Derrote os prisioneiros do Cárcere.", "Победите заключенных в Тюрьме.", "击败监狱的囚犯。", "擊敗監獄的犯人", }, 
},
["15"] = {
{ "Bring Brewmaster Bo to the Unga Ingoo Brewing Cauldron.", "Bringt Braumeister Bo zum Braukessel von Unga Ingu.", "Lleva al maestro cervecero Bo hasta el caldero de fermentación de Unga Ingoo.", "Lleva al maestro cervecero Bo hasta el caldero de fermentación de Unga Ingoo.", "Amenez le maître brasseur Bo au chaudron de brassage d’Unga Ingou.", "Scorta il Mastro Birraio Bo al Tino di Fermentazione a Unga Ingu.", "양조사 보를 웅가 잉구 양조 가마솥에 데려가야 합니다.", "Escolte o Mestre Cervejeiro Bô até o Caldeirão de Brassagem de Ungá Ingô.", "Проведите хмелевара Бо к кипящему котлу Унга-Ингу.", "护送珀酒仙去盎迦猴岛的酿酒大锅。", "帶釀酒大師阿波到仰加印古的釀酒鍋。", }, 
{ "Bring 200 Unga Jungle Brew to the Brewing Cauldron.", "Bringt 200 Becher Ungadschungelbräu zum Braukessel.", "Lleva 200 brebajes de jungla de Unga al caldero de fermentación.", "Lleva 200 brebajes de jungla de Unga al caldero de fermentación.", "Apportez 200 brassejungles d’Unga au chaudron de brassage.", "Porta 200 Birre della Giungla di Unga al Tino di Fermentazione.", "양조 가마솥에 웅가 밀림 맥주 200개를 가져가야 합니다.", "Leve 200 Cervejas Selvagens de Ungá para o Caldeirão de Brassagem.", "Вылейте в хмелеваренный котел 200 порций тропического отвара Унга.", "带上200桶盎迦丛林酒去酿酒大锅。", "帶200個仰加叢林酒到釀酒鍋。", }, 
{ "Defeat Captain Ook.", "Bezwingt Kapitän Uuk.", "Derrota al capitán Ook.", "Derrota al capitán Ook.", "Terrassez le capitaine Ouk.", "Sconfiggi Capitan Gancino.", "선장 우끼를 처치해야 합니다.", "Derrote o Capitão Fedô.", "Одолейте капитана Ука.", "击败乌克头领。", "殺死烏克船長。", }, 
},
["1014"] = {
{ "Make your way into the Dark Riders' catacombs beneath Karazhan.", "Bahnt Euch einen Weg in die Katakomben der Dunklen Reiter unter Karazhan.", "Ábrete paso hasta las catacumbas de los jinetes oscuros que hay bajo Karazhan.", "Llega hasta las catacumbas de los Jinetes oscuros, situadas en lo profundo de Karazhan.", "Frayez-vous un chemin dans les catacombes des cavaliers noirs qui s’étendent sous Karazhan.", "Fatti strada nelle catacombe dei Cavalieri Oscuri sotto Karazhan.", "카라잔 아래에 있는 암흑 기수의 지하묘지에 들어가야 합니다.", "Entre nas catacumbas dos Cavalgantes Negros, sob Karazhan.", "Проникните в катакомбы Темных всадников под Каражаном.", "前往卡拉赞下方的黑暗骑士的墓穴。", "進入卡拉贊地下墓穴追查黑騎兵的下落。", }, 
{ "Find a way to cross Ariden's spirit barrier.", "Findet einen Weg, um Aridens Geisterbarriere zu überwinden.", "Encuentra el modo de atravesar la barrera de espíritus de Ariden.", "Encuentra un modo de atravesar la barrera espiritual de Ariden.", "Trouvez un moyen de franchir la barrière spirituelle d’Ariden.", "Trova un modo per attraversare la barriera spirituale di Ariden.", "아리덴의 영혼 보호막을 통과할 방법을 찾아야 합니다.", "Encontre um jeito de atravessar a barreira espiritual de Ariden.", "Найдите способ преодолеть духовную преграду Аридена.", "想办法穿过埃瑞丁的灵魂屏障。", "想辦法越過埃瑞丁的靈魂屏障。", }, 
{ "Defeat the guardian of the Dark Riders' vault.", "Bezwingt den Wächter des Gewölbes der Dunklen Reiter.", "Derrota al guardián de la cámara de los jinetes oscuros.", "Derrota al guardián de la bóveda de los Jinetes oscuros.", "Terrassez le gardien du caveau des Cavaliers noirs.", "Sconfiggi il guardiano dei Cavalieri Oscuri.", "암흑 기수 금고의 관리자를 물리쳐야 합니다.", "Derrote o guardião da câmara dos Cavalgantes Negros.", "Победите хранителя сокровищ Темных всадников.", "击败黑暗骑士宝库的守护者。", "擊敗黑騎兵寶庫的保護者。", }, 
{ "Find the Scythe of Elune among the Dark Riders' artifacts.", "Sucht nach der Sichel von Elune unter den Artefakten der Dunklen Reiter.", "Encuentra la Guadaña de Elune entre los artefactos de los jinetes oscuros.", "Encuentra la Guadaña de Elune entre los artefactos de los Jinetes oscuros.", "Trouvez la faux d’Élune parmi les armes prodigieuses des Cavaliers noirs.", "Trova la Falce di Elune tra gli artefatti dei Cavalieri Oscuri.", "암흑 기수의 유물을 뒤져 엘룬의 낫을 찾아야 합니다.", "Encontre a Foice de Eluna entre os artefatos dos Cavalgantes Negros.", "Найдите Косу Элуны среди артефактов Темных всадников.", "在黑暗骑士的神器中找到月神镰刀。", "在黑騎兵的寶藏中找到伊露恩之鐮。", }, 
{ "Follow Ariden into the depths of the Karazhan catacombs.", "Folgt Ariden in die Tiefen der Katakomben von Karazhan.", "Sigue a Ariden hasta las profundidades de las Catacumbas de Karazhan.", "Sigue a Ariden hacia las profundidades de las catacumbas de Karazhan.", "Suivez Ariden dans les profondeurs des catacombes de Karazhan.", "Segui Ariden nelle profondità delle catacombe di Karazhan.", "카라잔 지하무덤 깊은 곳으로 도망친 아리덴을 추격해야 합니다.", "Siga Ariden até as profundezas das catacumbas de Karazhan.", "Следуйте за Ариденом вглубь катакомб Каражана.", "跟随埃瑞丁深入卡拉赞墓穴。", "深入卡拉贊地下墓穴，追上埃瑞丁。", }, 
{ "Defeat Ariden.", "Bezwingt Ariden.", "Derrota a Ariden.", "Derrota a Ariden.", "Terrassez Ariden.", "Sconfiggi Ariden.", "아리덴을 처치해야 합니다.", "Derrote Ariden.", "Победите Аридена.", "击败埃瑞丁。", "擊敗埃瑞丁。", }, 
{ "Claim the Scythe of Elune.", "Nehmt die Sichel von Elune an Euch.", "Hazte con la Guadaña de Elune.", "Reclama la Guadaña de Elune.", "Récupérez la faux d’Élune.", "Recupera la Falce di Elune.", "엘룬의 낫을 획득해야 합니다.", "Tome a Foice de Eluna.", "Заберите Косу Элуны.", "获得月神镰刀。", "取得伊露恩之鐮。", }, 
},
["1108"] = {
{ "You've come to the ruins of Falanaar in search of Verstok and the Fangs of Ashamane. Search for clues as to where Verstok has disappeared to.", "Ihr seid auf der Suche nach Verstok und den Fängen von Ashamane zu den Ruinen von Falanaar gekommen. Sucht nach Hinweisen darauf, wohin Verstok verschwunden ist.", "Has llegado a las ruinas de Falanaar en busca de Verstok y los Colmillos de Crinceniza. Busca pistas sobre el paradero de Verstok.", "Viniste a las ruinas de Falanaar en busca de Verstok y los Colmillos de Ashamane. Consigue pistas que indiquen hacia dónde escapó Verstok.", "Vous avez gagné les ruines de Falanaar pour trouver Verstok et les Crocs d’Ashamane. Cherchez des indices pouvant vous mener là où a disparu Verstok.", "Hai raggiunto le rovine di Falanaar in cerca di Verstok e delle Zanne di Grigiomanto. Cerca indizi sulla possibile posizione di Verstok.", "버스토크와 아샤메인의 송곳니를 찾아 팔라나아르 폐허에 왔습니다. 버스토크가 어디로 사라졌는지 알아내는 데 도움이 될 만한 단서를 찾으십시오.", "Você veio até as ruínas de Falanaar à procura de Verstok e das presas de ashamane. Encontre pistas sobre o paradeiro de Verstok.", "Вы пришли к руинам Фаланаара в поисках Верстока и Клыков Пеплошкурой. Найдите подсказки, которые укажут, куда подевался Версток.", "你来到了法兰纳尔的废墟，搜寻维斯托克和阿莎曼之牙。搜寻线索，找出维斯托克消失后，去了哪里。", "你來到法拉納爾廢墟，要尋找佛史托克以及亞夏曼之牙。搜尋佛史托克失蹤下落的線索。", }, 
{ "Verstok's scent leads into the ruins, but the door is sealed shut. Find a way to open it.", "Verstoks Spur führt in die Ruinen, aber die Tore sind fest verschlossen. Findet einen Weg, sie zu öffnen.", "El rastro de Verstok conduce a las ruinas, pero la puerta está cerrada. Averigua el modo de abrirla.", "El rastro de Verstok nos lleva a las ruinas, pero la puerta está sellada. Busca la forma de abrirla.", "La piste de Verstok mène dans les ruines, mais la porte est condamnée. Trouvez un moyen de l’ouvrir.", "L'odore di Verstok conduce verso le rovine, ma la porta è sigillata. Trova un modo per aprirla.", "버스토크의 체취가 폐허 내부로 이어져 있지만, 문이 굳게 닫혀있습니다. 문을 열 방법을 알아내야 합니다.", "O cheiro de Verstok vem das ruínas, mas a porta está trancada. Encontre uma maneira de abri-la.", "Запах Верстока ведет в развалины, но дверь запечатана. Найдите способ открыть ее.", "维斯托克的味道一路延伸到废墟之中，但门是紧紧关闭的。想办法打开它。", "佛史托克的氣味指向廢墟，但是門被封印住了。想辦法開啟它。", }, 
{ "Follow Verstok's trail into the temple depths.", "Folgt Verstoks Spur bis in die Tiefen des Tempels.", "Sigue el rastro de Verstok a las profundidades del templo.", "Sigue el rastro de Verstok hacia lo profundo del templo.", "Suivez la piste de Verstok dans les profondeurs du temple.", "Segui le tracce di Verstok all'interno del tempio.", "버스토크의 흔적을 따라 신전 깊은 곳으로 들어가야 합니다.", "Siga o rastro de Verstok até as profundezas do templo.", "Идите по следу Верстока вглубь храма.", "追寻维斯托克的足迹，进入神殿深处。", "追蹤佛史托克進入神廟深處。", }, 
{ "The power of the Fangs has driven Verstok insane. Subdue him.", "Die Macht der Reißzähne hat Verstok in den Wahnsinn getrieben. Beruhigt ihn.", "El poder de los Colmillos ha hecho perder el juicio a Verstok. Domínalo.", "El poder de los Colmillos llevó a Verstok a la locura. Doblégalo.", "Le pouvoir des crocs a rendu Verstok fou. Soumettez-le.", "Il potere delle zanne ha condotto Verstok alla pazzia. Cerca di soggiogarlo.", "송곳니의 힘 때문에 버스토크가 광기에 휩싸였습니다. 그를 제압해야 합니다.", "O poder das presas enlouqueceu Verstok. Subjugue-o.", "Сила Клыков лишила Верстока рассудка. Усмирите его.", "阿莎曼之牙的力量让维斯托克变得疯狂。制服他。", "尖牙的力量讓佛史托克發瘋了。制伏他。", }, 
{ "Verstok has fled into a series of caves beneath the ruins, find him.", "Verstok ist in ein Höhlensystem unterhalb der Ruinen geflohen. Findet ihn.", "Verstok ha huido a una serie de cuevas que hay bajo las ruinas. Localízalo.", "Verstok huyó hacia un conjunto de cuevas debajo de las ruinas. Encuéntralo.", "Verstok s’est enfui dans un réseau de grottes sous les ruines. Trouvez-le.", "Verstok è fuggito attraverso una serie di caverne sotto le rovine. Trovalo.", "폐허 아래 동굴로 달아난 버스토크를 찾아야 합니다.", "Verstok fugiu para as cavernas sob as ruínas, encontre-o.", "Версток скрылся в лабиринтах пещер под развалинами. Найдите его.", "维斯托克逃入了废墟下的洞穴中，找到他。", "佛史托克逃進了廢墟底下的洞穴，找到他。", }, 
{ "You've found Verstok caught in the web of a horrific creature. Slay it.", "Ihr habt Verstok aufgespürt - eingesponnen von einer grässlichen Kreatur. Tötet sie.", "Has encontrado a Verstok atrapado en la red de una criatura horrenda. Mátala.", "Encontraste a Verstok atrapado en la red de una criatura espantosa. Asesínala.", "Vous avez trouvé Verstok pris au piège dans la toile d’une horrible créature. Tuez-la.", "Hai trovato Verstok intrappolato nella tela di una terrificante creatura. Eliminala.", "버스토크를 찾았지만, 그는 무시무시한 괴물이 쳐 놓은 거미줄에 잡혀있습니다. 우선 괴물을 처치해야 합니다.", "Você encontrou Verstok preso na teia de uma criatura horrenda. Mate-a.", "Вы нашли Верстока: он попался в паутину ужасного существа. Убейте это существо.", "你发现维斯托克被困在恐怖生物的网中。干掉它。", "你發現佛史托克被一個可怕怪物的網子給困住了。殺死怪物。", }, 
{ "The Fangs of Ashamane are yours. Take them.", "Die Fänge von Ashamane gehören Euch. Nehmt sie.", "Los Colmillos de Crinceniza son tuyos. Cógelos.", "Los Colmillos de Ashamane son tuyos. Tómalos.", "Les Crocs d’Ashamane sont à vous. Prenez-les.", "Le Zanne di Grigiomanto sono tue. Prendile.", "이제 아샤메인의 송곳니는 당신의 것입니다. 송곳니를 획득해야 합니다.", "As presas de Ashamane são suas. Pegue-as.", "Клыки Пеплошкурой теперь ваши. Заберите их.", "阿莎曼之牙属于你了。带走它们。", "亞夏曼之牙是你的了。拿走它們。", }, 
{ "Ride upon Ebonfang to return to the Dreamgrove.", "Reitet auf Schwarzzahn, um zum Hain der Träume zurückzukehren.", "Monta en Colmillo de Ébano para volver a la Arboleda de los Sueños.", "Viaje al lomo de Colmillo de Ébano de regreso a la Arboleda de los Sueños.", "Chevauchez Croc-d’Ébène pour regagner la Sylverêve.", "Cavalca Zanna d'Ebano per tornare al Bosco dei Sogni.", "칠흑송곳니를 타고 꿈숲으로 돌아가야 합니다.", "Volte ao Bosque Onírico em Presa de Ébano.", "Вернитесь в Рощу Снов верхом на Черном Клыке.", "骑乘乌牙，回到梦境林地。", "騎乘黯牙返回幻夢之林。", }, 
},
["1312"] = {
{ "Meet Thisalee near Rhut'van Peak", "Trefft Euch mit Thisalee in der Nähe des Gipfels von Rhut'van.", "Encuéntrate con Thisalee cerca de la Cumbre de Rhut'van.", "Encuentra a Thisalee cerca de la Cima de Rhut'van", "Allez voir Thisalee près du pic de Rhut’van.", "Incontra Thisalee vicino al Picco di Rhut'van.", "루트반 봉우리 근처에서 티살리를 만나야 합니다.", "Encontre Tessália perto do Pico de Rhut'van.", "Встретьтесь с Тизали у пика Рут'ван.", "在鲁特凡峰附近找到希萨莉。", "去魯特凡山峰附近找黎沙莉", }, 
{ "Prowl and follow Thisalee into the Legion encampment", "Folgt Thisalee schleichend in das Lager der Legion.", "Usa Acechar y sigue a Thisalee hasta el campamento de la Legión.", "Sigue sigilosamente a Thisalee hasta el campamento de la Legión.", "Camouflez-vous et suivez Thisalee dans le campement de la Légion.", "Segui Thisalee muovendoti furtivamente nell'accampamento della Legione.", "티살리를 따라 군단 야영지로 은밀하게 가야 합니다.", "Espreite e siga Tessália até o acampamento da Legião.", "Прокрадитесь следом за Тизали в лагерь Легиона.", "跟随希萨莉潜入军团营地。", "潛行並跟隨黎沙莉進入燃燒軍團營地", }, 
{ "Watch Infazzar and determine his plans", "Beobachtet Infazzar und deckt seine Pläne auf.", "Vigila a Infazzar y descubre sus planes.", "Observa a Infazzar y averigua sus planes", "Espionnez Infazzar pour en apprendre plus sur ses projets.", "Osserva Infazzar e scopri i suoi piani.", "인파자르를 지켜보고 그의 계획을 확인해야 합니다.", "Observe Infazzar e descubra os planos dele.", "Проследите за Инфаззаром и узнайте его планы.", "监视伊法扎尔制定计划。", "監視因法薩爾並得知他的計畫", }, 
{ "Fight off the attacking demons and fel harpies", "Schlagt die angreifenden Dämonen und Teufelsharpyien zurück.", "Resiste el ataque de los demonios y las arpías viles.", "Repele los ataques de los demonios y las arpías viles.", "Repoussez l’assaut des démons et des harpies gangrenées.", "Sconfiggi i demoni e le Arpie vili in arrivo", "공격해 오는 악마와 지옥 하피를 물리쳐야 합니다.", "Rechace os demônios e harpias vis que estão atacando.", "Отбейте нападение демонов и гарпий Скверны.", "击退进攻的恶魔和邪能鹰身人", "擊退前來攻擊的惡魔和魔化鷹身人", }, 
{ "Follow Infazzar to his ship", "Folgt Infazzar zu seinem Schiff.", "Sigue a Infazzar hasta su nave.", "Sigue a Infazzar hasta su nave", "Suivez Infazzar jusqu’à son vaisseau.", "Segui Infazzar sulla nave.", "인파자르를 추적해 그의 함선까지 가야 합니다.", "Siga Infazzar até o navio dele.", "Следуйте за Инфаззаром на его корабль.", "跟踪伊法扎尔前往他的战舰", "跟隨因法薩爾登上他的船艦", }, 
{ "Fight your way to Infazzar and retrieve the Idol of Aviana", "Kämpft Euch zu Infazzar vor und beschafft den Götzen von Aviana.", "Ábrete camino hasta Infazzar y recupera el Ídolo de Aviana.", "Lucha hasta llegar a Infazzar y recupera el Ídolo de Aviana.", "Frayez-vous un chemin jusqu’à Infazzar et récupérez l’idole d’Aviana.", "Fatti strada verso Infazzar e recupera l'Idolo di Aviana.", "적을 뚫고 인파자르가 있는 곳까지 가서 아비아나의 우상을 회수해야 합니다.", "Vá lutando até Infazzar e recupere o Ídolo de Aviana.", "Пробейтесь к Инфаззару и заберите идол Авианы.", "杀到伊法扎尔面前，夺回艾维娜雕像。", "一路殺往因法薩爾並奪回艾維娜塑像", }, 
{ "(Optional) Use Teleport: Dreamway", "(Optional) Verwendet 'Teleport: Traumpfad'.", "(Opcional) Utiliza Teletransporte a: Camino del Sueño.", "(Opcional) Usa Teletransporte: Senda de los sueños", "(Optionnel) Utilisez Téléportation : chemin du Rêve.", "(Facoltativo) Usa il Teletrasporto: Metasogno.", "(선택) 순간이동 사용: 꿈길", "(Opcional) Use Teleporte: Estrada Onírica", "Используйте \"Телепортацию: Путь Снов\" (необязательно).", "（可选）使用传送：梦境之路", "(可跳過)使用傳送器：翡翠夢途", }, 
},
["210"] = {
{ "Contact the Dark Iron Mountaineers atop Shimmer Ridge and find a way to stop the storm.", "Kontaktiert die Dunkeleisengebirgsjäger am Schimmergrat und findet einen Weg, den Sturm zum Erliegen zu bringen.", "Ponte en contacto con los montaraces Hierro Negro en lo alto del Monte Luz y descubre la forma de detener la tormenta.", "Ponte en contacto con los montaraces Hierro Negro en lo alto del Monte Luz y descubre la forma de detener la tormenta.", "Contactez les montagnards sombrefers au sommet de la crête Scintillante et trouvez un moyen de mettre fin à la tempête.", "Contatta i Montanari Ferroscuro alla Cresta Brillante e trova un modo per interrompere la tempesta.", "아지랑이 마루 위에 있는 검은무쇠 산악경비대와 만나 폭풍을 멈출 방법을 찾아야 합니다.", "Contate os Montanhistas Ferro Negro no topo da Cordilheira Cintilante e encontre uma maneira de parar a tempestade.", "Поговорите с горными пехотинцами из клана Черного Железа на вершине Мерцающего хребта и узнайте способ остановить бурю.", "到闪光岭上与黑铁巡山人联络并找出终止风暴的方法。", "聯絡閃光嶺上面的黑鐵巡山人，然後找到辦法阻止風暴。", }, 
{ "Free Scout Stonebeard from the trolls' roasting spit.", "Rettet Späher Steinbart vom Bratspieß der Trolle.", "Libera al explorador Barbapétrea del asador trol.", "Libera al explorador Barbapétrea del asador trol.", "Libérez l’éclaireur Barbe-de-Pierre du tournebroche des trolls.", "Libera l'Esploratore Barbapietra dallo spiedo dei Troll.", "트롤의 구이 꼬챙이에 묶인 정찰병 스톤비어드를 풀어줘야 합니다.", "Liberte o Batedor Barbarrocha do espeto de churrasco dos trolls.", "Спасите разведчика Камнеборода, которого пытаются поджарить тролли.", "救下巨魔烤肉架上的斥候石须。", "從食人妖的烤肉鐵叉解救斥候石鬚。", }, 
{ "Slay the trolls trying to cook Scout Boldbrew.", "Tötet die Trolle, die Späherin Kühnbräu braten wollen.", "Mata a los trols que intentan cocinar a la exploradora Birraudaz.", "Mata a los trols que intentan cocinar a la exploradora Birraudaz.", "Tuez les trolls qui essayent de faire cuire l’éclaireuse Bièrafeu.", "Uccidi i Troll che vogliono cucinare l'Esploratrice Birrardita.", "정찰병 볼드브루를 요리하려는 트롤을 처치해야 합니다.", "Mate os trolls que estão tentando cozinhar a Batedora Cervamarga.", "Убейте троллей, пытающихся сварить разведчицу Резковар.", "消灭试图烹饪斥候粗酿的巨魔。", "殺死要把斥候勇釀煮來吃的食人妖。", }, 
{ "Slay the trolls about to sacrifice Scout Forgefellow.", "Tötet die Trolle, die Späher Schmiedebalg opfern wollen.", "Mata a los trols que están a punto de sacrificar al explorador Forjaleal.", "Mata a los trols que están a punto de sacrificar al explorador Forjaleal.", "Tuez les trolls sur le point de sacrifier l’éclaireur Forgepair.", "Uccidi i Troll che vogliono sacrificare l'Esploratore Granforgia.", "정찰병 포지펠로를 제물로 바치려는 트롤을 처치해야 합니다.", "Mate os trolls que estão prestes a sacrificar o Batedor Forjamigo.", "Убейте троллей, собирающихся принести в жертву разведчика Кузнебрата.", "消灭打算献祭斥候炉匠的巨魔。", "殺死要把斥候鍛扈當成祭品的食人妖。", }, 
{ "Slay the elemental spirit in the ice cave to end the snowstorm.", "Besiegt den Elementargeist in der Eishöhle, um den Schneesturm zum Erliegen zu bringen.", "Mata al espíritu elemental en la cueva de hielo para poner fin a la tormenta de nieve.", "Mata al espíritu elemental en la cueva de hielo para poner fin a la tormenta de nieve.", "Tuez l’esprit élémentaire dans la grotte de glace pour mettre fin à la tempête de neige.", "Uccidi lo spirito elementale nella caverna ghiacciata per porre fine alla tempesta di neve.", "얼음 동굴에 있는 원소 정령을 처치해 눈폭풍을 멈춰야 합니다.", "Mate o espírito elemental na caverna de gelo para acabar com a tempestade de neve.", "Убейте духа стихий в ледяной пещере, чтобы метель прекратилась.", "杀死冰封洞穴中的元素之灵以终止暴风雪。", "殺死冰穴裡的元素之靈來停止這場暴風雪。", }, 
{ "Join Moira's forces, slay the Zandalari leader, and capture the Frostmane village.", "Schließt Euch Moiras Truppen an, besiegt den Anführer der Zandalari und nehmt das Frostmähnendorf ein.", "Únete a las tropas de Moira, mata al líder Zandalari y toma la aldea Peloescarcha.", "Únete a las tropas de Moira, mata al líder Zandalari y toma la aldea Peloescarcha.", "Joignez-vous aux troupes de Moira, tuez le chef zandalari et prenez le village des Crins-de-Givre.", "Unisciti alle forze di Moira, uccidi il capo degli Zandalari e conquista il villaggio dei Mantogelido.", "모이라의 군대에 합류해 잔달라 지도차를 처치한 뒤에 서리갈기 마을을 점령해야 합니다.", "Junte-se às forças de Moira, derrote o líder Zandalari e capture a Vila Jubafria.", "Объединитесь с силами Мойры, убейте вожака зандаларов и захватите деревню Мерзлогривов.", "加入茉艾拉的部队，击败赞达拉领袖并占领霜鬃村落。", "加入茉艾拉的部隊，殺死贊達拉領袖，然後佔領霜鬃村。", }, 
{ "Complete the Bonus Objective to receive bonus Valor.", "Erfüllt das Bonusziel, um zusätzliche Tapferkeitspunkte zu erhalten.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Accomplissez l’objectif bonus pour recevoir des points de vaillance supplémentaires.", "Completa l'obiettivo bonus per ricevere Punti Valore aggiuntivi.", "추가 목표를 완료하면 용맹 점수를 더 얻을 수 있습니다.", "Complete o objetivo bônus para receber Bravura extra.", "Выполните дополнительную задачу, чтобы получить бонусные очки доблести.", "完成奖励目标，获得额外的勇气点数。", "完成獎勵目標以獲取額外的勇氣點數。", }, 
},
["975"] = {
{ "Repel the demons invading the Fel Hammer", "Schlagt die Dämonen zurück, die die Teufelshammer angreifen.", "Repele a los demonios que invaden el Martillo Vil.", "Expulsa a los demonios que intentan invadir el Martillo vil", "Repoussez l’invasion de démons sur le Marteau gangrené.", "Respingi i demoni che hanno invaso la Vilmartello.", "지옥 망치호를 공격하는 악마들을 격퇴해야 합니다.", "Rechace os demônios que estão invadindo o Martelo Vil.", "Отбейте атаку демонов, вторгшихся на \"Молот Скверны\".", "驱逐入侵邪能之槌号的恶魔", "擊退入侵魔錘號的惡魔。", }, 
{ "Retake the forge room", "Erobert den Schmiederaum zurück.", "Recupera la sala de forja.", "Recupera la Sala de la forja", "Reprenez la forge.", "Riprendi il controllo della forgia.", "가열로실을 되찾아야 합니다.", "Retome a sala da forja.", "Отбейте кузницу.", "夺回熔炉室", "奪回熔爐房", }, 
{ "Retake the control room", "Erobert den Kontrollraum zurück.", "Recupera la sala de control.", "Recupera la Sala de control", "Reprenez la salle de contrôle.", "Riprendi il controllo della sala comandi.", "제어실을 되찾아야 합니다.", "Retome a sala de comando.", "Отбейте зал управления.", "夺回控制室", "奪回控制房", }, 
{ "Destroy the Legion ships", "Zerstört die Legionsschiffe.", "Destruye las naves de la Legión.", "Destruye las naves de la Legión.", "Détruisez les vaisseaux de la Légion.", "Distruggere le navi della Legione", "군단 함선을 파괴해야 합니다.", "Destrua as naves da Legião.", "Уничтожьте корабли Легиона.", "摧毁军团舰船", "摧毀燃燒軍團船艦", }, 
},
["216"] = {
{ "Speak with Grizzle Gearslip.", "Sprecht mit Grizzle Radflutsch.", "Habla con Llorica Tuercafloja.", "Habla con Grizzle Engranasuelto.", "Parlez à Geignard Glissécrou.", "Parla con Grizzle Slittaruota.", "그리즐 기어슬립과 대화해야 합니다.", "Fale com Grislo Engrenário.", "Поговорите с Гриззлом Скрипетолом.", "与格里兹尔·轮滑交谈。", "與格里斯·輪滑交談。", }, 
{ "Destroy the greater elemental ravaging the Big Blossom Excavation site.", "Zerstört den großen Elementar, der in der Großblütenausgrabung sein Unwesen treibt.", "Destruye el elemental superior que está devastando la Excavación de la Gran Flor.", "Destruye el elemental superior que está devastando la Excavación de la Gran Flor.", "Détruisez l’élémentaire supérieur qui dévaste les excavations du Grand Printemps.", "Distruggi l'elementale superiore che sta devastando gli Scavi di Fioreterno.", "만개화 발굴현장에서 날뛰는 상급 원소 정령을 처치해야 합니다.", "Destrua o elemental superior que assola o sítio de escavação do Florescer Perene.", "Уничтожьте великого духа стихий, свирепствующего в приисках Пышного Цветения.", "消灭破坏繁盛挖掘场的大型元素生物。", "消滅在繁花挖掘場肆虐的巨型元素。", }, 
{ "Collect artifacts for Gearslip while his workers clear the mine entrance.", "Sammelt für Radflutsch Artefakte, während seine Arbeiter den Mineneingang räumen.", "Recoge artefactos para Tuercafloja mientras sus obreros despejan la entrada de la mina.", "Recoge artefactos para Engranasuelto mientras sus obreros despejan la entrada de la mina.", "Ramassez des artéfacts pour Glissécrou pendant que ses ouvriers dégagent l’entrée de la mine.", "Raccogli i manufatti per Slittaruota mentre i suoi lavoratori sgombrano l'ingresso alla miniera.", "기어슬립의 일꾼들이 광산 입구를 정리하는 동안 유물을 수집해야 합니다.", "Colete artefatos para Engrenário enquanto seus trabalhadores liberam a entrada da mina.", "Соберите артефакты для Скрипетола, пока его рабочие расчищают местность перед рудником.", "在轮滑的手下们清理矿洞入口的同时帮他收集遗物。", "在等待輪滑的工人清除礦坑入口時，幫忙輪滑收集文物。", }, 
{ "Travel deep into the Big Blossom Mine and blast open the wall.", "Dringt tief in die Großblütenmine ein und sprengt die Mauer.", "Adéntrate en la Mina de la Gran Flor y vuela el muro por los aires.", "Adéntrate en la Mina de la Gran Flor y vuela el muro por los aires.", "Allez dans les profondeurs de la mine du Grand Printemps et faites sauter le mur.", "Raggiungi le profondità della Miniera di Fioreterno e crea una breccia nel muro.", "만개화 광산 깊은 곳으로 이동한 뒤 벽을 폭파시켜 열어야 합니다.", "Penetre na Mina Florescer Perene e exploda a parede.", "Спуститесь в рудник Пышного Цветения и взорвите стену.", "深入繁盛矿洞并炸开洞壁。", "深入繁花礦坑並轟開一面牆。", }, 
{ "Destroy the Echo of Y'Shaarj.", "Zerstört das Echo von Y'Shaarj.", "Destruye al eco de Y'Shaarj.", "Destruye al eco de Y'Shaarj.", "Détruisez l’Echo d’Y’Shaarj.", "Distruggi l'Eco di Y'shaarj.", "이샤라즈의 환영을 처치해야 합니다.", "Destrua o Eco de Y'Shaarj.", "Уничтожьте Эхо И'Шараджа.", "消灭亚煞极的回响。", "消滅亞煞拉懼的分身。", }, 
{ "Complete the Bonus Objective to receive bonus Valor.", "Erfüllt das Bonusziel, um zusätzliche Tapferkeitspunkte zu erhalten.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Accomplissez l’objectif bonus pour recevoir des points de vaillance supplémentaires.", "Completa l'obiettivo bonus per ricevere Punti Valore aggiuntivi.", "추가 목표를 완료하면 용맹 점수를 더 얻을 수 있습니다.", "Complete o objetivo bônus para receber Bravura extra.", "Выполните дополнительную задачу, чтобы получить бонусные очки доблести.", "完成奖励目标，获得额外的勇气点数。", "完成獎勵目標以獲取額外的勇氣點數。", }, 
},
["523"] = {
{ "Defeat the bosses of Shadowfang Keep.", "Besiegt die Bosse von Burg Schattenfang.", "Derrota a los jefes del Castillo de Colmillo Oscuro.", "Derrota a los jefes del Castillo de Colmillo Oscuro.", "Terrassez les boss du donjon d’Ombrecroc.", "Sconfiggi i boss del Forte di Zannascura.", "그림자송곳니 성채 우두머리들을 처치해야 합니다.", "Derrote os chefes da Bastilha da Presa Negra.", "Победите боссов в Крепости Темного Клыка.", "击败影牙要塞的首领。", "擊敗影牙城堡的首領。", }, 
{ "Defeat Baron Silverlaine within Shadowfang Keep.", "Besiegt Baron Silberlein in Burg Schattenfang.", "Derrota al barón Filargenta en el Castillo de Colmillo Oscuro.", "Derrota al Barón Filargenta en el Castillo de Colmillo Oscuro.", "Terrassez le baron d’Argelaine dans le donjon d’Ombrecroc.", "Sconfiggi il Barone Argenius nel Forte di Zannascura.", "그림자송곳니 성채 안에 있는 남작 실버레인을 처치해야 합니다.", "Derrote o Barão Silverlaine na Bastilha da Presa Negra.", "Победите барона Сильверлейна в Крепости Темного Клыка.", "击败影牙要塞的席瓦莱恩男爵。", "在影牙城堡裡面擊敗席瓦萊恩男爵。", }, 
{ "Defeat Commander Springvale within Shadowfang Keep.", "Besiegt Kommandant Grüntal in Burg Schattenfang.", "Derrota al comandante Vallefont en el Castillo de Colmillo Oscuro.", "Derrota a Comandante Vallefont en Castillo de Colmillo Oscuro.", "Terrassez le commandant Printeval dans le donjon d’Ombrecroc.", "Sconfiggi il Comandante Primavalle nel Forte di Zannascura.", "그림자송곳니 성채 안에 있는 사령관 스프링베일을 처치해야 합니다.", "Derrote o Comandante Floraval na Bastilha da Presa Negra.", "Победите командира Спрингвейла в Крепости Темного Клыка.", "击败影牙要塞的指挥官斯普林瓦尔。", "在影牙城堡內擊敗指揮官斯普林瓦爾。", }, 
},
["623"] = {
{ "Defeat the bosses of Sethekk Halls", "Bezwingt die Bosse der Sethekkhallen.", "Derrota a los jefes de las Salas Sethekk.", "Derrota a los jefes de Salas Sethekk.", "Terrassez les boss des salles de Sethtekk.", "Sconfiggi i boss delle Sale dei Sethekk.", "세데크 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões dos Sethekk", "Победите боссов в Сетеккских залах", "击败塞泰克大厅的首领", "擊敗塞司克大廳的首領", }, 
},
["323"] = {
{ "Stop the Bleeding Hollow Soul Shaman from reanimating the Fomor skeleton.", "Hindert die Seelenschamanen des Blutenden Auges daran, das Fomorskelett wiederzubeleben.", "Evita que el chamán de almas Foso Sangrante reanime al esqueleto del fomor.", "Impide que el chamán de Alma Foso Sangrante reanime al esqueleto de Fomor.", "Empêchez les chamans-esprits des ruines de l’Orbite-Sanglante de réanimer le squelette de fomor.", "Impedisci allo Sciamano delle Anime dei Guerci Insanguinati di rianimare lo scheletro Fomor.", "피눈물 영혼 주술사가 포모르 해골을 되살리는 것을 막아야 합니다.", "Impeça o Xamã das Almas dos Olhos Sangrentos de reanimar o esqueleto de Fomor.", "Помешайте шаману душ из клана Кровавой Глазницы оживить скелет Фомора.", "阻止血环灵魂萨满复活匠灵的遗骸。", "阻止血之谷薩滿復活佛莫的骷髏。", }, 
{ "Defend Thrall until he breaches the inner chamber.", "Verteidigt Thrall, bis er in die innere Kammer durchbricht.", "Defiende a Thrall hasta que logre entrar en la cámara interior.", "Protege a Thrall hasta que irrumpa en la cámara interior.", "Protégez Thrall jusqu’à ce qu’il atteigne la chambre intérieure.", "Difendi Thrall fino alla breccia della camera interna.", "스랄이 안쪽 방으로 들어가는 문을 여는 동안 그를 보호해야 합니다.", "Defenda Thrall até ele alcançar a câmara interior.", "Защищайте Тралла, пока он не пробьется во внутренние покои.", "保护萨尔攻入内部大厅。", "護送索爾，直到他進入內室。", }, 
{ "Confront Kilrogg Deadeye and stop the dark ritual.", "Konfrontiert Kilrogg Totauge und beendet das dunkle Ritual.", "Enfréntate a Kilrogg Mortojo y detén el ritual oscuro.", "Confronta a Kilrogg Ojo Muerto y detén el ritual oscuro.", "Affrontez Kilrogg Œil-Mort et mettez un terme au rituel.", "Affronta Kilrogg Occhiotetro e ferma il rituale oscuro.", "킬로그 데드아이와 맞서고 어둠의 의식을 멈춰야 합니다.", "Enfrente Kilrogg Olho Morto e impeça o ritual sombrio.", "Вступите в бой с Килроггом Мертвым Глазом и помешайте ему провести темный обряд.", "击败基尔罗格·死眼并阻止黑暗仪式。", "正面迎戰基爾羅格‧亡眼並阻止黑暗儀式。", }, 
{ "Kill 5 Dudes", "Tötet 5 Typen.", "Mata a 5 tíos.", "Mata a 5 tipejos", "Tuez 5 quidams.", "Uccidi 5 nemici.", "5마리 처치해야 합니다.", "Matar 5 caras", "Убейте 5 парней.", "击杀5个敌人", "殺了5個敵人", }, 
{ "Kill 10 Dudes", "Tötet 10 Typen.", "Mata a 10 tíos.", "Mata a 10 tipejos", "Tuez 10 quidams.", "Uccidi 10 nemici.", "10마리 처치해야 합니다.", "Matar 10 caras", "Убейте 10 парней.", "击杀10个敌人", "殺了10個敵人", }, 
},
["1221"] = {
{ "Defeat Agatha", "Besiegt Agatha.", "Derrota a Agatha.", "Derrota a Agatha.", "Terrassez Agatha.", "Sconfiggi Agatha.", "아가타를 처치해야 합니다.", "Derrote Ágata.", "Победите Агату.", "击败败阿加莎", "擊敗亞加薩", }, 
},
["1093"] = {
{ "Learn about being a Warrior.", "Erfahrt etwas über das Leben als Krieger.", "Infórmate sobre ser un guerrero.", "Averigua más sobre ser un guerrero.", "Apprenez-en davantage sur les guerriers.", "Impara il significato di essere un Guerriero.", "전사에 대해 배워야 합니다.", "Aprenda sobre os Guerreiros.", "Узнайте, что значит быть воином.", "学习如何成为一名战士。", "學習如何當一名戰士。", }, 
{ "Learn about Charge.", "Erfahrt mehr über 'Sturmangriff'.", "Infórmate sobre Cargar.", "Averigua más sobre Cargar.", "Apprenez-en davantage sur Charge.", "Impara come usare Carica.", "돌진에 대해 배워야 합니다.", "Aprenda sobre Investida.", "Научитесь применять \"Рывок\".", "学习冲锋。", "學習如何使用衝鋒。", }, 
{ "Learn about Mortal Strike.", "Erfahrt mehr über 'Tödlicher Stoß'.", "Infórmate sobre Golpe mortal.", "Averigua más sobre Golpe mortal.", "Apprenez-en davantage sur Frappe mortelle.", "Impara come usare Assalto Mortale.", "필사의 일격에 대해 배워야 합니다.", "Aprenda sobre Golpe Mortal.", "Научитесь применять \"Смертельный удар\".", "学习致死打击。", "學習如何使用致死打擊。", }, 
{ "Learn about Slam.", "Erfahrt mehr über 'Zerschmettern'.", "Infórmate sobre Embate.", "Averigua más sobre Embate.", "Apprenez-en davantage sur Heurtoir.", "Impara come usare Contusione.", "격돌에 대해 배워야 합니다.", "Aprenda sobre Batida.", "Научитесь применять \"Мощный удар\".", "学习猛击。", "學習如何使用猛擊。", }, 
{ "Learn about Colossus Smash.", "Erfahrt mehr über 'Kolossales Schmettern'.", "Infórmate sobre Machaque colosal.", "Averigua más sobre Machaque colosal.", "Apprenez-en davantage sur Frappe du colosse.", "Impara come usare Colpo del Colosso.", "거인의 강타에 대해 배워야 합니다.", "Aprenda sobre Golpe Colossal.", "Научитесь применять \"Удар колосса\".", "学习巨人打击。", "學習如何使用千鈞潰擊。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Victory Rush.", "Erfahrt mehr über 'Siegesrausch'.", "Infórmate sobre Ataque de la victoria.", "Averigua más sobre Ataque de la victoria.", "Apprenez-en davantage sur Ivresse de la victoire.", "Impara come usare Frenesia di Vittoria.", "연전연승에 대해 배워야 합니다.", "Aprenda sobre Ímpeto da Vitória.", "Научитесь применять \"Победный раж\".", "学习乘胜追击。", "學習如何使用勝利衝擊。", }, 
{ "Learn about Whirlwind.", "Erfahrt mehr über 'Wirbelwind'.", "Infórmate sobre Torbellino.", "Averigua más sobre Torbellino.", "Apprenez-en davantage sur Tourbillon.", "Impara come usare Turbine.", "소용돌이에 대해 배워야 합니다.", "Aprenda sobre Redemoinho.", "Научитесь применять \"Вихрь\".", "学习旋风斩。", "學習如何使用旋風斬。", }, 
{ "Learn about Heroic Leap.", "Erfahrt mehr über 'Heldenhafter Sprung'.", "Infórmate sobre Salto heroico.", "Averigua más sobre Salto heroico.", "Apprenez-en davantage sur Bond héroïque.", "Impara come usare Balzo Eroico.", "영웅의 도약에 대해 배워야 합니다.", "Aprenda sobre Salto Heroico.", "Научитесь применять \"Героический прыжок\".", "学习英勇飞跃。", "學習如何使用英勇躍擊。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["627"] = {
{ "Defeat the bosses of Auchenai Crypts", "Bezwingt die Bosse der Auchenaikrypta.", "Derrota a los jefes de las Criptas Auchenai.", "Derrota a los jefes de las Criptas Auchenai.", "Terrassez les boss des cryptes Auchenaï.", "Sconfiggi i boss delle Cripte degli Auchenai.", "아키나이 납골당 우두머리들을 처치해야 합니다.", "Derrote os chefes das Catacumbas Auchenai", "Победите боссов в Аукенайских гробницах", "击败奥金尼地穴的首领", "擊敗奧奇奈地穴的首領", }, 
},
["1271"] = {
{ "Speak with Cenarius to begin the assault.", "Sprecht mit Cenarius, um mit dem Angriff zu beginnen.", "Habla con Cenarius para iniciar el asalto.", "Habla con Cenarius para comenzar el asalto.", "Parlez à Cénarius pour lancer l’assaut.", "Parla con Cenarius per iniziare l'assalto.", "세나리우스와 대화하고 공격을 개시해야 합니다.", "Fale com Cenarius para iniciar o ataque.", "Поговорите с Кенарием, чтобы начать сражение.", "与塞纳留斯交谈以开始突袭。", "跟塞納留斯交談以開始攻擊。", }, 
{ "Aid Cenarius and his forces in defeating Crushfist.", "Helft Cenarius und seinen Streitkräften dabei, Quetschfaust zu besiegen.", "Ayuda a Cenarius y sus fuerzas a derrotar a Puño Aplastante.", "Ayuda a Cenarius y a sus fuerzas a derrotar a Aplastalonte.", "Aidez Cénarius et ses troupes à vaincre Poing-Rageur.", "Aiuta Cenarius e le sue forze a sconfiggere Sfondapugni.", "세나리우스와 그의 병력을 도와 뭉개주먹을 처치해야 합니다.", "Ajude Cenarius e suas forças a derrotar Murraça.", "Помогите Кенарию и его союзникам победить Каменного Кулака.", "协助塞纳留斯和他的部队击败碾拳。", "協助塞納留斯和他的部隊擊敗碎拳。", }, 
{ "Destroy the barrier blocking the tower entrance.", "Zerstört die Barriere, die den Eingang zum Turm blockiert.", "Destruye la barrera que bloquea la entrada de la torre.", "Destruye la barrera que bloquea la entrada a la torre.", "Détruisez la barrière qui bloque l’entrée de la tour.", "Distruggi la barriera che blocca l'ingresso alla torre.", "탑의 입구를 막고 있는 방벽을 파괴해야 합니다.", "Destrua a barreira que bloqueia a entrada da torre.", "Уничтожьте барьер, преграждающий вход в башню.", "摧毁挡住塔楼入口的屏障。", "摧毀擋住高塔入口的屏障。", }, 
{ "Reach the top of the tower.", "Erreicht die Spitze des Turms.", "Llega a lo alto de la torre.", "Llega a la cima de la torre.", "Atteignez le sommet de la tour.", "Raggiungi la cima della torre.", "탑 꼭대기에 도착해야 합니다.", "Chegue ao topo da torre.", "Доберитесь до вершины башни.", "到达塔楼顶层。", "前往塔頂。", }, 
{ "Eliminate Wrath-Lord Akrazar.", "Eliminiert Zornfürst Akrazar.", "Elimina al señor de la cólera Akrazar.", "Elimina al Señor de cólera Akrazar.", "Éliminez le seigneur du courroux Akrazar.", "Elimina il Signore dell'Ira Akrazar.", "분노군주 아크라자르를 제거해야 합니다.", "Elimine o Senhor da Ira Akrazar.", "Убейте повелителя гнева Акразара.", "消灭愤怒领主阿卡扎尔。", "消滅憤怒領主亞克札爾。", }, 
{ "Use the Fel Cannons to clear the airspace around the tower.", "Verwendet die Teufelskanonen, um den Luftraum um den Turm zu säubern.", "Utiliza los cañones viles para despejar el espacio aéreo cercano a la torre.", "Usa los cañones viles para liberar el espacio aéreo alrededor de la torre.", "Utilisez les gangrecanons pour dégager l’espace aérien autour de la tour.", "Usa i Vilcannoni per liberare lo spazio aereo intorno alla torre.", "지옥 대포를 사용해 탑 주위의 상공을 정리해야 합니다.", "Use os canhões vis para liberar o espaço aéreo em torno da torre.", "С помощью пушек Скверны очистите небо вокруг башни от нетопырей.", "使用邪能火炮肃清塔楼周围的空域。", "用惡魔火砲掃蕩高塔周圍的天空。", }, 
{ "Ride the Dreamweavers' Hippogryphs up to the Legion Command Ship .", "Reitet auf dem Hippogryphen der Traumweber zum Kommandoschiff der Legion.", "Móntate en un hipogrifo de los Tejesueños y vuela hasta la nave de mando de la Legión.", "Monta a los hipogrifos de los Tejesueños rumbo a la nave de mando de la Legión.", "Chevauchez les hippogriffes des Tisse-Rêves pour gagner le vaisseau de commandement de la Légion.", "Cavalca gli ippogrifi dei Plasmasogni fino all'Ammiraglia della Legione.", "몽술사의 히포그리프를 타고 군단 지휘함까지 올라가야 합니다.", "Voe nos Hipogrifos do Tece-sonhos para chegar à Nave de Comando da Legião.", "Оседлайте гиппогрифов Ткачей Снов и отправляйтесь на флагманский корабль Легиона.", "骑乘织梦者的角鹰兽登上军团指挥舰。", "騎乘織夢者的角鷹獸飛往燃燒軍團船艦。", }, 
{ "Rout the invasion by defeating the Legion Commander overseeing the attack.", "Schlagt die Invasion zurück, indem Ihr den Legionskommandanten besiegt, der sie anführt.", "Frustra la invasión derrotando al comandante de la Legión que supervisa el ataque.", "Derrota al Comandante de la Legión que supervisa el ataque y dispersa la invasión.", "Contrecarrez l’invasion en éliminant le commandant de la Légion qui la dirige.", "Sbaraglia l'invasione sconfiggendo il Comandante della Legione al comando dell'attacco.", "공격을 지휘하는 군단 사령관을 처치하고 침공을 좌절시켜야 합니다.", "Impeça a invasão derrotando o Comandante de Legião que supervisiona o ataque.", "Отбейте вторжение, победив командира Легиона, который им руководит.", "击败监督进攻的军团指挥官，击溃入侵者。", "擊倒監督攻擊行動的燃燒軍團指揮官，瓦解這波入侵行動。", }, 
{ "Jump off the ship to escape.", "Springt vom Schiff, um zu fliehen.", "Salta de la nave para escapar.", "Salta de la nave para escapar.", "Fuyez du vaisseau en sautant par-dessus bord.", "Salta giù dalla nave per fuggire.", "함선에서 뛰어내려 탈출해야 합니다.", "Pule do navio para fugir.", "Спрыгните с корабля, чтобы покинуть его.", "跳船逃离。", "跳下船艦離開。", }, 
},
["44"] = {
{ "Defeat the Sha corrupted forces inside the Temple of the Jade Serpent.", "Bezwingt die vom Sha korrumpierten Streitkräfte im Tempel der Jadeschlange.", "Derrota a las fuerzas corruptas del Sha en el interior del Templo del Dragón de Jade.", "Derrota a las fuerzas corruptas del Sha en el interior del Templo del Dragón de Jade.", "Terrassez les troupes corrompues du sha dans le temple du Serpent de jade.", "Sconfiggi le forze corrotte dallo Sha nel Tempio della Serpe di Giada.", "옥룡사 내부에서 샤에 오염된 병사들을 처치해야 합니다.", "Derrote as forças corrompidas pelo Sha no Templo da Serpente de Jade.", "Победите оскверненные Ша войска в храме Нефритовой Змеи.", "击败青龙寺内被煞能腐蚀的敌人。", "殺死玉蛟寺裡的煞之邪力。", }, 
},
["1091"] = {
{ "Learn about being a Shaman.", "Erfahrt etwas über das Leben als Schamane.", "Infórmate sobre ser un chamán.", "Averigua más sobre ser un chamán.", "Apprenez-en davantage sur les chamans.", "Impara il significato di essere uno Sciamano.", "주술사에 대해 배워야 합니다.", "Aprenda sobre os Xamãs.", "Узнайте, что значит быть шаманом.", "学习如何成为一名萨满。", "學習如何當一名薩滿。", }, 
{ "Learn about Flame Shock.", "Erfahrt mehr über 'Flammenschock'.", "Infórmate sobre Choque de llamas.", "Averigua más sobre Choque de llamas.", "Apprenez-en davantage sur Horion de flammes.", "Impara come usare Folgore del Fuoco.", "화염 충격에 대해 배워야 합니다.", "Aprenda sobre Choque Flamejante.", "Научитесь применять \"Огненный шок\".", "学习烈焰震击。", "學習如何使用烈焰震擊。", }, 
{ "Learn about Lava Burst.", "Erfahrt mehr über 'Lavaeruption'.", "Infórmate sobre Ráfaga de lava.", "Averigua más sobre Ráfaga de lava.", "Apprenez-en davantage sur Explosion de lave.", "Impara come usare Getto di Lava.", "용암 폭발에 대해 배워야 합니다.", "Aprenda sobre Estouro de Lava.", "Научитесь применять \"Выброс лавы\".", "学习熔岩爆裂", "學習如何使用熔岩爆發。", }, 
{ "Learn about Lightning Bolt.", "Erfahrt mehr über 'Blitzschlag'.", "Infórmate sobre Descarga de relámpagos.", "Averigua más sobre Descarga de relámpagos.", "Apprenez-en davantage sur Éclair.", "Impara come usare Dardo Fulminante.", "번개 화살에 대해 배워야 합니다.", "Aprenda sobre Raio.", "Научитесь применять \"Молнию\".", "学习闪电箭。", "學習如何使用閃電箭。", }, 
{ "Learn about Earth Shock.", "Erfahrt mehr über 'Erdschock'.", "Infórmate sobre Choque de tierra.", "Averigua más sobre Choque de tierra.", "Apprenez-en davantage sur Horion de terre.", "Impara come usare Folgore della Terra.", "대지 충격에 대해 배워야 합니다.", "Aprenda sobre Choque Terreno.", "Научитесь применять \"Земной шок\".", "学习大地震击。", "學習如何使用大地震擊。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Hex.", "Erfahrt mehr über 'Verhexen'.", "Infórmate sobre Maleficio.", "Averigua más sobre Maleficio.", "Apprenez-en davantage sur Maléfice.", "Impara come usare Maleficio.", "사술에 대해 배워야 합니다.", "Aprenda sobre Bagata.", "Научитесь применять \"Сглаз\".", "学习妖术。", "學習如何使用妖術。", }, 
{ "Learn about Chain Lightning.", "Erfahrt mehr über 'Kettenblitzschlag'.", "Infórmate sobre Cadena de relámpagos.", "Averigua más sobre Cadena de relámpagos.", "Apprenez-en davantage sur Chaîne d’éclairs.", "Impara come usare Catena di Fulmini.", "연쇄 번개에 대해 배워야 합니다.", "Aprenda sobre Cadeia de Raios.", "Научитесь применять \"Цепную молнию\".", "学习闪电链。", "學習如何使用閃電鏈。", }, 
{ "Learn about Healing Surge.", "Erfahrt mehr über 'Heilende Woge'.", "Infórmate sobre Oleada de sanación.", "Averigua más sobre Oleada de sanación.", "Apprenez-en davantage sur Afflux de soins.", "Impara come usare Eruzione Benefica.", "치유의 파도에 대해 배워야 합니다.", "Aprenda sobre Maré Curativa.", "Научитесь применять \"Исцеляющий всплеск\".", "学习治疗之涌", "學習如何使用洶湧治療。", }, 
{ "Learn about Fire Elemental.", "Erfahrt mehr über 'Feuerelementar'.", "Infórmate sobre Elemental de Fuego.", "Averigua más sobre Elemental de Fuego.", "Apprenez-en davantage sur Élémentaire de feu.", "Impara come usare Evocazione: Elementale del Fuoco.", "불의 정령에 대해 배워야 합니다.", "Aprenda sobre Elemental do Fogo.", "Научитесь призывать элементаля огня.", "学习火元素。", "學習如何使用火元素。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["1045"] = {
{ "How to fill a bar!", "Wie man eine Leiste füllt!", "¡Cómo se llena una barra!", "¡Cómo llenar una barra!", "Comment remplir une barre !", "Come riempire una barra!", "주점 가득 채우는 법!", "Como preencher uma barra!", "Как заполнить панель!", "如何填满进度条！", "如何補滿能量條！", }, 
{ "This is the final step! (cm 109970)", "Dies ist der letzte Schritt! (cm 109970)", "¡Este es el último paso! (cm 109970)", "¡Este es el último paso! (cm 109970)", "C’est la dernière étape ! (cm 109970)", "This is the final step! (cm 109970)", "마지막 단계입니다! (cm 109970)", "Este é o último passo! (cm 109970)", "Это последний шаг! (cm 109970)", "这是最后一步！(cm 109970)", "這真的是最後一步了！(cm 109970)", }, 
},
["1150"] = {
{ "Speak with Thalyssra to assemble your withered army.", "Sprecht mit Thalyssra, um Eure Verdorrtenarmee aufzustellen.", "Habla con Thalyssra para reunir a tu ejército de Marchitos.", "Habla con Thalyssra para reunir a tu ejército de marchitos.", "Parlez à Thalyssra pour rassembler votre armée de flétris.", "Parla con Thalyssra per creare la tua armata di Avvizziti.", "탈리스라와 대화하여 메마른 자의 군대를 집합시켜야 합니다.", "Fale com Thalyssra para reunir seu exército de fenecidos.", "Поговорите с Талисрой, чтобы собрать армию иссохших.", "和塔莉萨谈谈，集合你的枯法者部队。", "跟薩莉瑟拉交談來組織你的凋萎者軍隊。", }, 
{ "Enter the Collapse and proceed as far as you can. Dying, losing all your withered, or speaking with Thalyssra again will end the scenario.", "Betretet den Kollaps und dringt so weit wie möglich vor. Wenn Ihr sterbt, all Eure Verdorrten verliert oder wieder mit Thalyssra sprecht, wird das Szenario automatisch beendet.", "Entra en El Derrumbamiento y avanza todo lo posible. Si mueres, pierdes a todos tus Marchitos o vuelves a hablar con Thalyssra, se acabará la gesta.", "Entra a El derrumbamiento y avanza todo lo que puedas. Morir, perder todos tus marchitos o hablar con Thalyssra nuevamente pondrá fin al escenario.", "Entrez dans l’Effondrement et avancez le plus loin possible. Mourir, perdre tous vos flétris ou parler à nouveau à Thalyssra mettra fin au scénario.", "Entra nella zona del crollo ed esplorala il più possibile. Morire, perdere tutti i tuoi Avvizziti o parlare con Thalyssra ancora una volta metterà fine allo scenario.", "붕괴지 내부로 최대한 깊이 들어가야 합니다. 죽거나, 메마른 자들을 모두 잃거나, 탈리스라와 대화하면 시나리오가 종료됩니다.", "Entre no Colapso e prossiga até onde conseguir. Morrer, perder todos os fenecidos ou falar com Thalyssra novamente encerrará o cenário.", "Войдите в Обрушенный проход и продвиньтесь как можно дальше. Данный сценарий прервется после вашей смерти, потери всех иссохших или при", "进入大陷坑，尽量向深处探索。你所有的枯法者全部死亡、失踪或与塔莉萨再次交谈后可结束场景战役。", "進入崩塌遺跡，盡你所能深入探索。死亡、所有凋萎者死亡、或再次與薩莉瑟拉交談都會中斷事件。", }, 
{ "Return to the entrance of the Collapse and collect any rewards that you found.", "Kehrt zum Eingang des Kollapses zurück und sammelt alle gefundenen Belohnungen ein.", "Vuelve a la entrada de El Derrumbamiento y recoge las recompensas que encuentres.", "Vuelve a la entrada del derrumbamiento y recoge todas las recompensas que encuentres.", "Retournez à l’entrée de l’Effondrement et récupérez toutes les récompenses que vous avez trouvées.", "Torna all'entrata del Collasso per ottenere tutte le ricompense che hai trovato.", "붕괴지 입구로 돌아와서 발견한 모든 보상을 수집해야 합니다.", "Retorne à entrada do Colapso e recolha as recompensas que encontrar.", "Вернитесь к входу в Обрушенный проход и соберите все трофеи, какие сможете найти.", "回到大陷坑的入口，获取你所发现的所有奖励。", "返回崩塌遺跡的入口，收集你找到的獎勵。", }, 
},
["1083"] = {
{ "Learn about being a Hunter.", "Erfahrt etwas über das Leben als Jäger.", "Infórmate sobre ser un cazador.", "Averigua más sobre ser un cazador.", "Apprenez-en davantage sur les chasseurs.", "Impara il significato di essere un Cacciatore.", "사냥꾼에 대해 배워야 합니다.", "Aprenda sobre os Caçadores.", "Узнайте, что значит быть охотником.", "学习如何成为一名猎人。", "學習如何當一名獵人。", }, 
{ "Learn about Call Pet.", "Erfahrt mehr über 'Begleiter rufen'.", "Infórmate sobre Llamar a mascota.", "Averigua más sobre Llamar a mascota.", "Apprenez-en davantage sur Appel du familier.", "Impara come usare Richiamo: Famiglio.", "야수 부르기에 대해 배워야 합니다.", "Aprenda sobre Chamar Ajudante.", "Научитесь применять \"Призыв питомца\".", "学习召唤宠物。", "學習如何使用召喚寵物。", }, 
{ "Learn about Kill Command.", "Erfahrt mehr über 'Tötungsbefehl'.", "Infórmate sobre Matar.", "Averigua más sobre Matar.", "Apprenez-en davantage sur Ordre de tuer.", "Impara come usare Ordine di Morte.", "살상 명령에 대해 배워야 합니다.", "Aprendar sobre Comando para Matar.", "Научитесь применять способность «Команда \"Взять!\"»", "学习杀戮命令。", "學習如何使用擊殺命令。", }, 
{ "Learn about Dire Beast.", "Erfahrt mehr über 'Alphatier'.", "Infórmate sobre Bestia temible.", "Averigua más sobre Bestia temible.", "Apprenez-en davantage sur Bête féroce.", "Impara come usare Bestia Feroce.", "광포한 야수에 대해 배워야 합니다.", "Aprenda sobre Fera Atroz.", "Научитесь применять способность \"Ужасный зверь\".", "学习凶暴野兽。", "學習如何使用凶暴野獸。", }, 
{ "Learn about Cobra Shot.", "Erfahrt mehr über 'Kobraschuss'.", "Infórmate sobre Disparo de cobra.", "Averigua más sobre Disparo de cobra.", "Apprenez-en davantage sur Tir du cobra.", "Impara come usare Tiro del Cobra.", "코브라 사격에 대해 배워야 합니다.", "Aprenda sobre Disparo da Naja.", "Научитесь применять \"Выстрел кобры\".", "学习眼镜蛇射击", "學習如何使用眼鏡蛇射擊。", }, 
{ "Learn about Bestial Wrath.", "Erfahrt mehr über 'Zorn des Wildtiers'.", "Infórmate sobre Cólera de las bestias.", "Averigua más sobre Cólera de las bestias.", "Apprenez-en davantage sur Courroux bestial.", "Impara come usare Ira Bestiale.", "야수의 격노에 대해 배워야 합니다.", "Aprenda sobre Ira Bestial.", "Научитесь применять \"Звериный гнев\".", "学习狂野怒火", "學習如何使用狂野怒火。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Multi-Shot.", "Erfahrt mehr über 'Mehrfachschuss'.", "Infórmate sobre Multidisparo.", "Averigua más sobre Multidisparo.", "Apprenez-en davantage sur Flèches multiples.", "Impara come usare Tiro Multiplo.", "일제 사격에 대해 배워야 합니다.", "Aprenda sobre Tiro Múltiplo.", "Научитесь применять \"Залп\".", "学习多重射击。", "學習如何使用多重射擊。", }, 
{ "Learn about Feign Death.", "Erfahrt mehr über 'Totstellen'.", "Infórmate sobre Fingir muerte.", "Averigua más sobre Fingir muerte.", "Apprenez-en davantage sur Feindre la mort.", "Impara come usare Morte Apparente.", "죽은 척하기에 대해 배워야 합니다.", "Aprender sobre Fingir de Morto.", "Научитесь применять способность \"Притвориться мертвым\".", "学习假死。", "學習如何使用假死。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["654"] = {
{ "Defeat the bosses of Razorfen Kraul", "Bezwingt die Bosse des Krals der Klingenhauer.", "Derrota a los jefes de Horado Rajacieno.", "Derrota a los jefes de Horado Rajacieno", "Triomphez des boss du kraal de Tranchebauge.", "Sconfiggi i boss delle Gallerie di Lamaspina.", "가시덩굴 우리 우두머리들을 처치해야 합니다.", "Derrote os chefes do Urzal dos Tuscos", "Победите боссов в лабиринтах Иглошкурых", "击败剃刀沼泽的首领", "擊敗剃刀沼澤的首領", }, 
},
["1338"] = {
{ "Deep within the the Tomb of Sargeras the Fallen Avatar has been awoken.", "Tief im Inneren des Grabmals des Sargeras ist der gefallene Avatar erwacht.", "En las profundidades de la Tumba de Sargeras, el Avatar Caído se ha despertado.", "En las profundidades de la Tumba de Sargeras, el Avatar caído ha despertado.", "Dans les profondeurs de la tombe de Sargeras, l’avatar déchu a été réveillé.", "L'Avatar Caduto si è risvegliato nelle profondità della Tomba di Sargeras.", "살게라스의 무덤 깊은 곳에서 몰락한 화신이 깨어났습니다.", "Nas profundezas da Tumba de Sargeras, o Avatar Caído foi despertado.", "В глубинах гробницы Саргераса пробудилась аватара Падшего.", "萨格拉斯之墓深处的堕落的化身已经苏醒了。", "墮落化身在薩格拉斯之墓深處甦醒過來了。", }, 
},
["426"] = {
{ "Disrupt the Iron Horde's naval forces.", "Stört die Operationen der Seestreitkräfte der Eisernen Horde.", "Desestabiliza las fuerzas navales de la Horda de Hierro.", "Interrumpe a las fuerzas navales de la Horda de Hierro.", "Mettez en déroute les troupes navales de la Horde de Fer.", "Distruggi le forze navali dell'Orda di Ferro.", "강철 호드 해군에 타격을 입혀야 합니다.", "Desbarate as forças navais da Horda de Ferro.", "Помешайте флоту Железной Орды.", "干扰钢铁部落的海军部队。", "破壞鋼鐵部落的海軍部隊。", }, 
},
["526"] = {
{ "Defeat the bosses of Gate of the Setting Sun.", "Besiegt die Bosse beim Tor der Untergehenden Sonne.", "Derrota a los jefes de la Puerta del Sol Poniente.", "Derrota a los jefes de la Puerta del Sol Poniente.", "Terrassez les boss de la porte du Soleil couchant.", "Sconfiggi i boss della Porta del Sole Calante.", "석양문 우두머리들을 처치해야 합니다.", "Derrote os chefes do Portal do Sol Poente.", "Победите боссов у Врат Заходящего Солнца.", "击败残阳关的首领。", "擊敗落陽關的首領", }, 
},
["909"] = {
{ "Find Magnar's Tomb with Hruthnir.", "Sucht mit Hruthnir nach Magnars Ruhestätte.", "Encuentra la tumba de Magnar con Hruthnir.", "Encuentra la tumba de Magnar con Hruthnir.", "Trouvez la tombe de Magnar avec Hruthnir.", "Trova la Tomba di Magnar con Hruthnir.", "흐루스니르와 함께 마그나르의 무덤을 찾아야 합니다.", "Encontre a tumba de Magnar com Hruthnir.", "Вместе с Хрутниром отыщите гробницу Магнара.", "与胡尼尔一起寻找马格纳之墓。", "和赫魯茲納一起找到麥格納爾的墓穴。", }, 
{ "Defeat the Legion forces.", "Bezwingt die Streitkräfte der Legion.", "Derrota a las tropas de la Legión.", "Derrota a las fuerzas de la Legión.", "Terrassez les troupes de la Légion.", "Sconfiggi le forze della Legione.", "군단 세력을 격퇴해야 합니다.", "Derrote as forças da Legião.", "Разгромите силы Легиона.", "击败军团的部队。", "擊敗燃燒軍團軍隊。", }, 
{ "Find Magnar's resting place within the tomb.", "Sucht im Grab nach Magnars Ruhestätte.", "Encuentra el lugar de descanso de Magnar en el interior de la tumba.", "Encuentra el lugar de descanso de Magnar dentro de la tumba.", "Trouvez la sépulture de Magnar au sein du tombeau.", "Trova il luogo dove riposa Magnar all'interno della tomba.", "무덤 내부에 있는 마그나르의 안식처를 찾아야 합니다.", "Encontre o repouso final de Magnar dentro da tumba.", "Найдите в усыпальнице место упокоения Магнара.", "在墓穴中找到马格纳的安息之地。", "在墓穴裡找到麥格納爾長眠的地方。", }, 
{ "Defend Hruthnir from Magnar's forces.", "Verteidigt Hruthnir gegen Magnars Streitkräfte.", "Defiende a Hruthnir de los ejércitos de Magnar.", "Defiende a Hruthnir de las fuerzas de Magnar.", "Défendez Hruthnir contre les troupes de Magnar.", "Difendi Hruthnir dalle forze di Magnar.", "마그나르의 군대로부터 흐루스니르를 지켜야 합니다.", "Defenda Hruthnir das forças de Magnar.", "Защитите Хрутнира от воинов Магнара.", "保护胡尼尔不受马格纳的部队伤害。", "在麥格納爾軍隊攻擊時保護赫魯茲納。", }, 
{ "Defeat Magnar Icebreaker.", "Bezwingt Magnar Eisbrecher.", "Derrota a Magnar Rompehielo.", "Derrota a Magnar Rompehielo.", "Terrassez Magnar Brise-Glace.", "Sconfiggi Magnar Spezzaghiacci.", "마그나르 아이스브레이커를 처치해야 합니다.", "Derrote Magnar Quebragelo.", "Победите Магнара Ледоруба.", "击败马格纳·破冰者。", "擊敗麥格納爾‧碎冰者。", }, 
{ "The sword and shield are yours, claim them.", "Schwert und Schild sind Euer, nehmt sie an Euch.", "La espada y el escudo son tuyos. Reclámalos.", "La espada y el escudo son tuyos, reclámalos.", "L’épée et le bouclier sont à vous. Prenez-les.", "La spada e lo scudo sono tuoi, prendili.", "마그나르의 검과 방패는 당신의 것입니다. 장비를 획득하십시오.", "A espada e o escudo são seus, tome-os.", "Щит и меч теперь ваши – заберите их.", "剑和盾都是你的了，拿去吧。", "劍和盾都是你的了，收下吧。", }, 
},
["1082"] = {
{ "You've arrived at Shield's Rest. Meet up with Orik and prepare to enter the tomb.", "Ihr seid auf der Schildruhinsel angekommen. Trefft Euch mit Orik und bereitet Euch darauf vor, das Grab zu betreten.", "Has llegado a Reposo del Escudo. Reúnete con Orik y prepárate para entrar en la tumba.", "Llegaste al Reposo del Escudo. Reúnete con Orik y prepárate para entrar a la tumba.", "Vous voilà au Repos du bouclier. Allez trouver Orik et préparez-vous à entrer dans la tombe.", "Hai raggiunto Riposo dello Scudo. Incontra Orik e preparati a entrare nella tomba.", "방패의 안식처에 도착했습니다. 오리크를 만난 다음 무덤으로 들어갈 준비를 해야 합니다.", "Você alcançou o Pouso do Escudo. Encontre-se com Orik e prepare-se para entrar na tumba.", "Вы прибыли на остров Брошенного Щита. Встретьтесь с Ориком и приготовьтесь войти в гробницу.", "你已经抵达了盾憩岛，与欧瑞克会面，并准备进入古墓。", "你已經抵達盾息之島。跟歐利克會合，做好進入墓穴的準備。", }, 
{ "Inside the tomb lies the Shrine of the Truthguard. Overcome any defenses and find the shrine.", "Innerhalb des Grabes liegt der Schrein des Wahrheitshüters. Überwältigt die Verteidigung und sucht nach dem Schrein.", "En el interior de la tumba se encuentra el Santuario de la Veraguardia. Supera las defensas y encuentra el santuario.", "Dentro de la tumba se encuentra el santuario de la Veraguardia. Derrota a las defensas y encuentra el santuario.", "Au sein de la tombe se dresse le sanctuaire de Garde-Vérité. Déjouez les défenses et trouvez le sanctuaire.", "Nella tomba sorge il Santuario dello Scudo della Verità. Supera eventuali ostacoli e raggiungilo.", "무덤 내부에 진실의 수호자의 제단이 있습니다. 앞을 가로막는 방어자들을 극복하고 제단을 찾아야 합니다.", "Dentro da tumba fica o Santuário da Guarda Fiel. Supere todas as defesas e encontre o santuário.", "Святилище Стража Истины находится в гробнице. Пробейтесь внутрь и отыщите святилище.", "这座墓穴中沉睡着真理守护者的祭坛。克服一路上的试炼并找到那座祭坛。", "真理之盾神殿就在墓穴當中。突破防禦，找到神殿。", }, 
{ "The door to the shrine is the first trial. Survive its test.", "Die Tür des Schreins ist die erste Prüfung. Überlebt den Test.", "La puerta al santuario es la primera prueba. Supera el reto.", "La puerta al santuario será la primera prueba. Sobrevívela.", "La porte du sanctuaire est la première épreuve. Tâchez d’y survivre.", "La porta verso il santuario è la prima prova. Cerca di sopravvivere.", "제단으로 통하는 문이 첫 번째 시험입니다. 시험에서 살아남으십시오.", "A porta para o santuário é o primeiro teste. Sobreviva a ele.", "Дверь в святилище – это первое испытание. Вы должны выжить, чтобы пройти его.", "通往祭坛的门是第一个试炼。在考验中存活下来。", "神殿之門是第一個試煉。在這場測試中活下來。", }, 
{ "The way is open and the shrine awaits. The shield is below somewhere. Find it.", "Der Weg ist frei und der Schrein wartet. Der Schild ist irgendwo unten. Sucht ihn.", "El camino está abierto y el santuario nos espera. El escudo está ahí abajo, en algún lugar. Encuéntralo.", "El camino está despejado y el santuario espera. El escudo está abajo en alguna parte. Encuéntralo.", "La voie est libre et le sanctuaire vous attend. Le bouclier est quelque part là-dessous. Trouvez-le.", "La via è aperta e il santuario ti attende. Lo scudo deve essere nascosto qui sotto. Trovalo.", "제단으로 향하는 길이 열렸습니다. 아래쪽 어딘가에 있는 방패를 찾아야 합니다.", "O caminho está aberto e o santuário aguarda. O escudo está em algum lugar lá embaixo. Encontre-o.", "Путь свободен, и святилище ждет вас. Щит должен быть где-то там. Отыщите его.", "通往祭坛的道路敞开了。盾牌就在下面的某处，找到它。", "通道開啟了，神殿就在前方。神盾就在底下的某處。找到它。", }, 
{ "Yrgrim, wielder of the Truthguard has challenged you to a trial by combat. Complete the trial to earn his respect.", "Yrgrim, Besitzer des Wahrheitshüters, hat Euch zu einem Gerichtskampf herausgefordert. Schließt seine Prüfung ab, um Euch seinen Respekt verdienen.", "Yrgrim, portador de la Veraguardia, te ha desafiado a una prueba de combate. Completa la prueba para ganarte su respeto.", "Yrgrim, portador de la Veraguardia, te desafió a un combate. Derrótalo para ganarte su respeto.", "Yrgrim, détenteur de Garde-Vérité, vous défie en duel. Surmontez cette épreuve pour gagner son respect.", "Yrgrim, possessore dello Scudo della Verità, ti sfida in combattimento. Completa la prova per ottenere il suo rispetto.", "진실의 수호자를 지키는 위르그림이 전투의 시험을 제안했습니다. 위르그림의 도전을 통과하여 그의 호의를 얻어야 합니다.", "Yrgrim, portador da Guarda Fiel, desafiou você a um julgamento por combate. Complete o julgamento para ganhar o respeito dele.", "Иргрим, владелец Стража Истины, вызвал вас на испытание боем. Пройдите испытание, чтобы заслужить его уважение.", "真理守护者的主人伊格瑞姆向你发出挑战。完成这一试炼以赢得他的尊重。", "厄格林，真理之盾持有者，挑戰你進行一場競技的試煉。完成這場試煉來得到他的尊重。", }, 
{ "The trial is over. Take up the Truthguard.", "Die Prüfung ist abgeschlossen. Ergreift den Wahrheitshüter.", "La prueba ha terminado. Coge la Veraguardia.", "El desafío terminó. Recoge la Veraguardia.", "L’épreuve est terminée. Prenez Garde-Vérité.", "La prova è finita. Recupera lo Scudo della Verità.", "시험이 끝났습니다. 진실의 수호자를 들어올리십시오.", "O julgamento acabou. Assuma a Guarda Fiel.", "Испытание пройдено. Возьмите Страж Истины.", "试炼结束了，拿起真理守护者。", "試煉結束了。拿起真理之盾。", }, 
},
["826"] = {
{ "Man the Deck Guns", "Bemannt die Deckkanonen.", "Encárgate de los cañones de cubierta.", "Preparen el fuego de cubierta", "Armez les canons du pont.", "Prepara i cannoni.", "갑판의 함포에 올라타야 합니다.", "Assuma os canhões de convés", "Займите пост у палубного орудия.", "操作甲板炮", "操作甲板砲。", }, 
{ "Use the Deck Guns to shoot down Forsaken Dreadwings", "Benutzt die Deckkanonen, um Unheilschwingen der Verlassenen abzuschießen.", "Usa los cañones de cubierta para derribar a los alatemibles Renegados.", "Usa las armas de cubierta para derribar a los Alatemibles renegados.", "Utilisez les canons du pont pour abattre les ailes de l’effroi réprouvées.", "Usa i cannoni per abbattere gli Alatorva dei Reietti.", "함포를 발사해 포세이큰 공포날개를 격추시켜야 합니다.", "Use os Canhões do Convés para derrubar os Terrorasas Renegados", "Сбивайте грознокрылов Отрекшихся из палубных орудий.", "使用甲板炮击落被遗忘者恐翼蝙蝠", "使用甲板砲擊落被遺忘者懼翼蝙蝠。", }, 
{ "Head below decks and use a Skyfire Parachute to board the Forsaken ships and defeat their captains.", "Begebt Euch unter Deck und nutzt einen Fallschirm der Himmelsfeuer, um an Bord der Schiffe der Verlassenen zu gehen und ihre Kapitäne zu töten.", "Baja a las cubiertas inferiores y usa un paracaídas de El Abrasacielos para abordar los barcos de los Renegados y derrotar a sus capitanes.", "Dirígete a la cubierta y usa un Paracaídas de El Abrasacielos para abordar los barcos de los Renegados y derrotar a sus capitanes.", "Rendez-vous sous le pont et utilisez un parachute du Brûleciel pour vous poser sur les navires réprouvés et terrasser leurs capitaines.", "Dirigiti sotto coperta e usa il Paracadute della Fuoco Celeste per abbordare le navi dei Reietti e sconfiggere i loro capitani.", "갑판 아래쪽에 있는 하늘불꽃호 낙하산을 사용해 포세이큰 함선에 승선해, 선장을 처치해야 합니다.", "Siga para os conveses inferiores e use um Paraquedas do Celesfogo para abordar as naus renegadas e derrotar seus capitães.", "Спуститесь под палубу и воспользуйтесь парашютом \"Небесного огня\", чтобы взять на абордаж корабли Отрекшихся и перебить их капитанов.", "前往甲板下方，使用天火号降落伞登上被遗忘者的战舰，击败他们的舰长。", "到下層甲板使用天火號降落傘，登上被遺忘者的飛船並且擊敗其船長。", }, 
{ "Remove Volatile Flares from Skyfire bomb bay.", "Entfernt instabile Mischungen aus dem Bombenschacht der Himmelsfeuer.", "Elimina los explosivos volátiles del compartimento de armas de El Abrasacielos.", "Elimina las bengalas volátiles de la bahía de bombas Abrasacielos.", "Retirez les décoctions instables de la soute à armement du Brûleciel.", "Rimuovi le Fialabengala Instabili dalla polveriera della Fuoco Celeste.", "하늘불꽃호 내부에서 불안정한 폭발물을 제거해야 합니다.", "Remova os Sinalizadores Voláteis do compartimento de bombas do Celesfogo.", "Сбросьте нестабильную взрывчатую смесь за борт из бомбового отсека \"Небесного огня\".", "移除天火号弹药舱中的易爆炸弹。", "移除天火號炸彈艙中的高爆燃炎彈。", }, 
{ "Defeat Nathanos Blightcaller on the deck of the Skyfire.", "Bezwingt Nathanos Pestrufer auf dem Deck der Himmelsfeuer.", "Derrota a Nathanos Clamañublo en la cubierta de El Abrasacielos.", "Derrota a Nathanos Clamañublo en la cubierta del Abrasacielos.", "Terrassez Nathanos le Flétrisseur sur le pont du Brûleciel.", "Sconfiggi Nathanos Selvamorta sul ponte della Fuoco Celeste.", "하늘불꽃호 갑판에서 나타노스 블라이트콜러를 처치해야 합니다.", "Derrote Nathanos Arauto da Praga no convés do Celesfogo.", "Победите Натаноса Гнилостеня на палубе \"Небесного огня\".", "在天火号的甲板上击败纳萨诺斯·凋零者。", "在天火號甲板上擊敗納薩諾斯‧凋零者。", }, 
},
["1005"] = {
{ "Search the Vault of the Wardens for Cordana Felsong and defeat her.", "Durchsucht das Verlies der Wächterinnen nach Cordana Teufelsang und besiegt sie.", "Busca a Cordana Cantovil en la Cámara de las Celadoras y derrótala.", "Busca la Piedra angular Sargeri en la Bóveda de las Celadoras.", "Cherchez Cordana Gangrechant dans le caveau des Gardiennes et terrassez-la.", "Cerca Cordana Vilcanto nelle Segrete delle Custodi e sconfiggila.", "감시관의 금고에서 콜다나 펠송을 찾아 처치해야 합니다.", "Procure por Cordana Vilcanto na Câmara das Guardiãs e a derrote.", "Найдите в Казематах Стражей Кордану Оскверненную Песнь и победите ее.", "搜索守望者地窟，找到科达娜·邪歌，并将其击败。", "在看守者鐵獄尋找寇達娜‧魔歌並且擊敗她。", }, 
},
["509"] = {
{ "Speak with Durotan to begin the Horde's assault upon Grommashar.", "Sprecht mit Durotan, um mit dem Angriff der Horde auf Grommashar zu beginnen.", "Habla con Durotan para comenzar el ataque de la Horda contra Grommashar.", "Habla con Durotan para comenzar el asalto de la Horda sobre Grommashar.", "Parlez à Durotan pour lancer l’assaut de la Horde sur Grommashar.", "Parla con Durotan per avviare l'assalto dell'Orda su Grommashar.", "듀로탄과 대화해 그롬마쉬아르에 대한 호드의 총공격을 시작해야 합니다.", "Fale com Durotan para começar o ataque da Horda a Grommashar.", "Поговорите с Дуротаном, чтобы Орда начала штурм Громмашара.", "与杜隆坦交谈，开始部落对格罗玛什尔的攻击。", "和杜洛坦交談，開始部落對葛羅瑪夏的進攻。", }, 
{ "Gather the Horde forces at the first bend up ahead and strategize with Aggra.", "Sammelt die Streitkräfte der Horde an der ersten Kurve dort vorne und beredet die Pläne mit Aggra.", "Reúne a las fuerzas de la Horda en la siguiente curva y planea una estrategia con Aggra.", "Reúne las fuerzas de la Horda en la primera curva y crea una estrategia con Aggra.", "Regroupez les soldats de la Horde au prochain tournant et élaborez une stratégie avec Aggra.", "Raduna le forze dell'Orda alla prima svolta e discuti una strategia con Aggra.", "길이 굽어지는 곳에서 호드 군대를 규합하고 아그라와 전략을 짜야 합니다.", "Reunir as forças da Horda na primeira curva adiante e traçar uma estratégia com Aggra.", "Соберите силы Орды впереди, сразу за первым поворотом, и разработайте план действий вместе с Аггрой.", "与部落部队在前方第一个弯道汇合，并与阿格娜一同制定战略。", "在前方的第一個彎路集結部落兵力，並與阿格拉共同制訂戰略。", }, 
{ "The might of the Warsong clan rests in their wolfriders. Flank the packmaster and the core of the clan's power will crumble.", "Die Macht des Kriegshymnenklans ist von ihren Wolfsreitern abhängig. Wenn Ihr den Rottenkommandanten überrascht, wird die Macht des Klans zerbröckeln.", "El poder del clan Grito de Guerra reside en sus jinetes de lobos. Flanquea al maestro de manada y el núcleo del poder del clan se vendrá abajo.", "El poderío del clan Grito de Guerra reside en sus jinetes de lobos. Flanquea al maestro de la manada y el núcleo del poder del clan se derrumbará.", "La puissance du clan Chanteguerre réside dans ses Chevaucheurs de loups. Débordez le Maître de la meute et le clan s’effondrera de lui-même.", "La potenza del Clan Cantaguerra è nei loro Cavalcalupi. Attacca al fianco il Mastrobranco e il cuore della loro armata andrà in frantumi.", "늑대기수들은 전쟁노래 부족의 핵심입니다. 무리지도자를 꺾으면 부족의 힘이 매우 약해질 것입니다.", "O poder do Clã Brado Guerreiro está em seus cavalga-lobos. Flanqueie o líder da alcateia e o centro do poder do clã cairá.", "Сила клана Песни Войны – в его наездниках на волках. Атакуйте властителя стаи с фланга.", "战歌氏族的战斗力源于他们的狼骑兵。从侧面袭击他们的兽王，氏族的核心力量就会瓦解。", "戰歌氏族的力量來自於他們的狼騎兵，只要從側翼攻擊狼王就能瓦解戰歌氏族的力量核心。", }, 
{ "Move ahead through the Warsong onslaught. Regroup with the Horde forces up the path and speak with Durotan.", "Drängt Euch durch den Ansturm des Kriegshymnenklans. Trefft Euch mit den Streitkräften der Horde entlang des Pfads und sprecht mit Durotan.", "Ábrete paso a través del ataque de los Grito de Guerra. Reagrúpate con las fuerzas de la Horda, en lo alto del camino, y habla con Durotan.", "Avanza a través del embate de los Grito de Guerra. Reagrúpate con las fuerzas de la Horda y habla con Durotan.", "Frayez-vous un chemin parmi les Chanteguerres. Rejoignez les troupes de la Horde sur le chemin et parlez à Durotan.", "Avanza attraverso le truppe d'attacco dei Cantaguerra. Raggiungi le forze dell'Orda lungo il percorso e parla con Durotan.", "전쟁노래 부족의 맹공격을 헤쳐 나가, 길 끝에서 호드 군대와 합류하고 듀로탄과 대화해야 합니다.", "Avance em meio ao massacre do Brado Guerreiro. Reagrupe-se com as forças da Horda mais à frente e fale com Durotan.", "Перебейте орков клана Песни Войны. Поднимитесь по тропе к ожидающим вас силам Орды и поговорите с Дуротаном.", "顶着战歌氏族的猛攻前进。与部落部队在小路汇合，并与杜隆坦对话。", "在戰歌氏族的猛烈攻勢下推進，重整部落兵力並與杜洛坦談話。", }, 
{ "Thunderlord clan members of the Iron Horde have enslaved the mighty gronn, Durn the Hungerer. Slay him.", "Die Mitglieder der Eisernen Horde aus dem Donnerfürstenklan haben den mächtigen Gronn, Durn den Nimmersatten, versklavt. Tötet ihn.", "Los miembros del clan Señor del Trueno de la Horda de Hierro han esclavizado al poderoso gronn, Durn el Hambriento. Mátalo.", "Los miembros del clan Señor del Trueno de la Horda de Hierro domaron al poderoso gronn, Durn el Hambriento. Mátalo.", "Des membres de la Horde de Fer issus du clan Sire-Tonnerre ont réduit en esclavage un puissant Gronn nommé Durn l’Affameur. Tuez-le.", "I membri del Clan Spaccatuono dell'Orda di Ferro hanno schiavizzato un possente Gronn, Durn il Famelico. Uccidilo.", "강철 호드의 일원인 천둥군주 부족이 강대한 그론, 굶주린 두른을 노예로 만들었습니다. 두른을 처치해야 합니다.", "Membros do clã Senhor do Trovão da Horda de Ferro escravizaram Durn, o Famélico, um poderoso gronn. Mate-o.", "Клан Громоборцев Железной Орды пленил могучего гронна Дарна Ненасытного. Убейте его.", "钢铁部落的雷神氏族成员奴役了一头强大的戈隆——饥饿者杜恩。快去干掉他吧。", "鋼鐵部落中雷霆王氏族的成員奴役了有巨大力量的古羅，『飢餓者』唐恩。殺了他。", }, 
{ "Speak with Durotan at the gates to the Grommashar Throne.", "Sprecht mit Durotan an den Toren zu Grommashars Thron.", "Habla con Durotan en las puertas de entrada al Trono de Grommashar.", "Habla con Durotan en las puertas del trono de Grommashar.", "Parlez à Durotan aux portes de Grommashar.", "Parla con Durotan ai cancelli del Trono di Grommash.", "그롬마쉬아르 옥좌로 통하는 문 앞에서 듀로탄과 대화해야 합니다.", "Fale com Durotan nos Portões que levam ao Trono de Grommashar.", "Поговорите с Дуротаном у ворот на пути к трону Громмашара.", "在通往格罗玛什尔王座的大门前与杜隆坦交谈。", "在葛羅瑪夏王座大門與杜洛坦談話。", }, 
{ "The time has come for you and Durotan to confront Warlord Garrosh Hellscream.", "Die Zeit ist gekommen, dass Ihr und Durotan den Kriegsherrn Garrosh Höllschrei konfrontiert.", "Ha llegado la hora de que Durotan y tú os enfrentéis al señor de la guerra Garrosh Grito Infernal.", "Por fin llegó el momento para que tú y Durotan confronten al Señor de la Guerra Garrosh Grito Infernal.", "Le temps est venu pour Durotan et pour vous d’affronter le Seigneur de guerre Garrosh Hurlenfer.", "È giunta l'ora per te e Durotan di affrontare il Signore della Guerra Garrosh Malogrido.", "듀로탄과 함께 전쟁군주 가로쉬 헬스크림과 맞설 때입니다.", "Chegou a hora de você e Durotan confrontarem o Senhor da Guerra Garrosh Grito Infernal.", "Пришло время вам с Дуротаном встретиться лицом к лицу с вождем Гаррошем Адским Криком.", "你和杜隆坦终于要面对督军加尔鲁什·地狱咆哮了。", "你和杜洛坦的時機來了，迎戰卡爾洛斯‧地獄吼。", }, 
},
["201"] = {
{ "Join up with Kromthar.", "Schließt Euch Kromthar an.", "Únete a Kromthar.", "Únete a Kromthar.", "Rejoignez Kromthar.", "Raggiungi Kromthar.", "크롬타르와 합류해야 합니다.", "Junte-se a Kromthar.", "Примите в отряд Кромтар.", "与库姆萨尔汇合。", "加入克隆莎。", }, 
{ "Fight your way through the burning refinery to General Nazgrim.", "Kämpft Euch durch die brennende Raffinerie zu General Nazgrim.", "Ábrete paso a través de la refinería en llamas del general Nazgrim.", "Ábrete paso a través de la refinería en llamas del general Nazgrim.", "Frayez-vous un chemin à travers la raffinerie en flammes jusqu’au général Nazgrim.", "Apriti la strada attraverso la raffineria in fiamme fino al Generale Nazgrim.", "불타는 정제소에서 적을 처치해가며 길을 확보해 장군 나즈그림에게 가야 합니다.", "Abra caminho pela refinaria em chamas e chegue até o General Nazgrim.", "Пробейтесь через горящий нефтезавод к генералу Назгриму.", "杀进着火的炼油厂，去找纳兹戈林将军。", "一路奮戰，穿過燃燒的精煉廠去找納茲格寧姆將軍。", }, 
{ "Defeat the Alliance forces assaulting the keep.", "Besiegt die Streitkräfte der Allianz, die die Burg angreifen.", "Derrota a las fuerzas de la Alianza que asaltan el bastión.", "Derrota a las fuerzas de la Alianza que asaltan el bastión.", "Terrassez les troupes de l’Alliance prenant d’assaut le donjon.", "Sconfiggi le forze dell'Alleanza di fronte al forte.", "요새를 공격하는 얼라이언스 병력을 처치해야 합니다.", "Derrote as forças da Aliança que estão atacando a fortaleza.", "Разбейте силы Альянса, осаждающие крепость.", "击败攻打要塞的联盟部队。", "打敗攻擊要塞的聯盟軍隊。", }, 
{ "Locate Warlord Bloodhilt and help repel the Alliance assault.", "Findet Kriegsfürst Blutheft und helft dabei, den Angriff der Allianz abzuwehren.", "Localiza al señor de la guerra Sangrastil y ayuda a repeler el asalto de la Alianza.", "Localiza al señor de la guerra Sangrastil y ayuda a repeler el asalto de la Alianza.", "Retrouvez le seigneur de guerre Garde-Sanglante et aidez-le à repousser l’attaque de l’Alliance.", "Trova il Signore della Guerra Elsarossa e aiutalo a respingere l'assalto dell'Alleanza.", "장군 블러드힐트를 찾아 얼라이언스의 공격을 격퇴해야 합니다.", "Encontre o Senhor da Guerra Punhossangue e ajude a repelir o ataque da Aliança.", "Найдите полководца Кровавого Эфеса и помогите отразить нападение Альянса.", "找到血柄督军并帮忙击退联盟的袭击。", "找到督軍血柄並幫忙擊退入侵的聯盟。", }, 
{ "Gather information about the Alliance and Horde forces.", "Sammelt Informationen über die Streitkräfte der Allianz und Horde.", "Reúne información sobre las fuerzas de la Alianza y la Horda.", "Reúne información sobre las fuerzas de la Alianza y la Horda.", "Rassemblez des informations sur les troupes de l’Alliance et de la Horde.", "Recupera informazioni sulle forze dell'Alleanza e dell'Orda.", "얼라이언스와 호드 군대의 정보를 입수해야 합니다.", "Reúna informações sobre as forças da Horda e da Aliança.", "Соберите информацию о силах Орды и Альянса.", "收集联盟和部落军队的情报。", "收集關於聯盟和部落軍隊的相關資訊。", }, 
{ "Set up Rivett's weapons and prepare to defend the keep!", "Macht Nietis Waffen bereit und wappnet Euch für die Verteidigung der Burg!", "¡Monta las armas de Perno y prepárate para defender el bastión!", "¡Monta las armas de Perno y prepárate para defender el bastión!", "Installez les armes de Rivett et préparez-vous à défendre le donjon !", "Piazza gli armamenti di Rivett e prepara la difesa del forte!", "리벳의 무기를 설치하고 요새를 방어할 준비를 해야 합니다!", "Prepare as armas de Pinno e prepare-se para defender a fortaleza!", "Установите орудия Риветта и приготовьтесь защищать крепость!", "组装利维特的武器并准备守卫要塞！", "準備好理弗特的武器，等著保衛要塞!", }, 
{ "Hold the gate against waves of Alliance invaders and their commander.", "Haltet das Tor gegen den Ansturm der Allianztruppen und ihren Kommandanten.", "Protege la puerta contra las oleadas de invasores de la Alianza y su comandante.", "Protege la puerta contra las oleadas de invasores de la Alianza y su comandante.", "Tenez le château en repoussant les vagues d’envahisseurs de l’Alliance et leur commandant.", "Proteggi le porte da numerose ondate di invasori dell'Alleanza e dal loro comandante.", "얼라이언스 병사들 및 사령관의 공격에서 정문을 지켜내야 합니다.", "Proteja o portão contras as ondas de invasores da Aliança e seu comandante.", "Защитите ворота от атаки Альянса и возглавляющего ее командира.", "守住大门，击退联盟入侵者及其指挥官。", "保衛要塞抵抗源源不絕的聯盟入侵者與他們的指揮官。", }, 
},
["709"] = {
{ "Investigate the overgrown Kirin Tor outpost.", "Untersucht den überwucherten Außenposten der Kirin Tor.", "Investiga la frondosa avanzada del Kirin Tor.", "Investiga el puesto de avanzada sobrecrecido del Kirin Tor.", "Explorez l’avant-poste du Kirin Tor envahi par la végétation.", "Ispeziona l'avamposto del Kirin Tor infestato dalla vegetazione.", "과성장이 벌어진 키린 토 전초기지를 조사해야 합니다.", "Investigue o posto avançado abandonado do Kirin Tor.", "Исследуйте заросшую заставу Кирин-Тора.", "调查植物丛生的肯瑞托岗哨。", "調查永茂林的祈倫托哨站。", }, 
{ "Defeat Xeri'tek", "Bezwingt Xeri'tek.", "Derrotar a Xeri'tek.", "Derrota a Xeri'tek", "Terrassez Xeri’tek.", "Sconfiggi Xeri'tek.", "제리타크를 처치해야 합니다.", "Derrote Xeri'tac", "Победите Зери'так", "击败艾里塔克", "擊敗希瑞泰克", }, 
},
["545"] = {
{ "Defeat the bosses of Blackrock Caverns.", "Besiegt die Bosse der Schwarzfelshöhlen.", "Derrota a los jefes de las Cavernas Roca Negra.", "Derrota a los jefes de las Cavernas Roca Negra.", "Terrassez les boss des cavernes de Rochenoire.", "Sconfiggi i boss delle Caverne di Roccianera.", "검은바위 동굴 우두머리들을 처치해야 합니다.", "Derrote os chefes da Caverna Rocha Negra.", "Победите боссов в пещерах Черной горы.", "击败黑石岩窟的首领。", "擊敗黑石洞穴的首領。", }, 
{ "Defeat Beauty.", "Besiegt Bella.", "Derrota a Bella.", "Derrota a Bella.", "Terrassez la Belle.", "Sconfiggi Bella.", "아름이를 처치해야 합니다.", "Derrote a Bela.", "Победите Красавицу.", "击败如花。", "擊敗美麗。", }, 
},
["684"] = {
{ "Disrupt the Iron Horde's naval forces.", "Stört die Operationen der Seestreitkräfte der Eisernen Horde.", "Desestabiliza las fuerzas navales de la Horda de Hierro.", "Interrumpe a las fuerzas navales de la Horda de Hierro.", "Mettez en déroute les troupes navales de la Horde de Fer.", "Distruggi le forze navali dell'Orda di Ferro.", "강철 호드 해군에 타격을 입혀야 합니다.", "Desbarate as forças navais da Horda de Ferro.", "Помешайте флоту Железной Орды.", "干扰钢铁部落的海军部队。", "破壞鋼鐵部落的海軍部隊。", }, 
},
["320"] = {
{ "Speak with Durotan.", "Sprecht mit Durotan.", "Habla con Durotan.", "Habla con Durotan.", "Parlez à Durotan.", "Parla con Durotan.", "듀로탄과 대화해야 합니다.", "Fale com Durotan.", "Поговорите с Дуротаном.", "与杜隆坦谈一谈。", "和杜洛坦交談。", }, 
{ "Escort your group northward, toward the Machinehouse.", "Eskortiert Eure Gruppe nach Norden in Richtung des Maschinenhauses.", "Escolta a tu grupo en dirección al norte, hacia la Casamáquina.", "Lleva a tu grupo hacia el norte, a la casa de máquinas.", "Accompagnez votre groupe vers le nord jusqu’à la machinerie.", "Scorta il tuo gruppo a nord, verso l'Officina Bellica.", "일행을 호위해 북쪽에 있는 기계작업장으로 가야 합니다.", "Escolte o seu grupo para o norte, na direção da Casa de Máquinas.", "Сопроводите отряд на север, к машинному залу.", "护送你的队伍前往北边的机房。", "護衛你的小隊前往北方的機械室", }, 
{ "Slay Goraluk Anvilcrack, High Machinist of the Naval Base.", "Tötet Goraluk Hammerbruch, den Hochmaschinisten der Marinebasis.", "Mata a Goraluk Yunquegrieta, gran maquinista de la base naval.", "Mata a Goraluk Yunquegrieta, maquinista supremo de la base naval.", "Tuez Goraluk Brisenclume, grand machiniste de la base navale.", "Uccidi Goraluk Spaccaroccia, Gran Macchinista della Base Navale.", "해군 기지의 수석기계병인 고랄루크 앤빌크랙을 처치해야 합니다.", "Mate Goraluk Rachadastra, Alto Maquinista da Base Naval.", "Убейте Горалука Треснувшую Наковальню, главного механика морской базы.", "击败海军基地的高级技师古拉鲁克。", "殺死古拉魯克，海軍基地的機械工人。", }, 
{ "Get to the Supply Depot.", "Erreicht das Vorratslager.", "Ve al depósito de suministros.", "Ve al depósito de suministros.", "Atteignez le dépôt de ravitaillement.", "Raggiungi il Deposito Rifornimenti.", "보급고에 가야 합니다.", "Vá para o Depósito de Suprimentos.", "Доберитесь до склада.", "前往补给站。", "前往補給站。", }, 
{ "Survive against waves of Iron Horde orcs.  Use explosive barrels against them.", "Überlebt die Wellen von Orcs der Eisernen Horde. Setzt explosive Fässer gegen sie ein.", "Sobrevive a las oleadas de orcos de la Horda de Hierro. Usa barriles explosivos contra ellos.", "Sobrevive a las oleadas de orcos de la Horda de Hierro. Usa los barriles explosivos contra ellos.", "Tenez bon face aux vagues d’orcs de la Horde de Fer. Utilisez des barils explosifs pour les repousser.", "Sopravvivi alle ondate di Orchi dell'Orda di Ferro. Usa i barili esplosivi contro di loro.", "강철 호드의 거듭된 공격에 맞서 살아남아야 합니다. 폭탄 통을 잘 활용하십시오.", "Sobreviva às levas de orcs da Horda de Ferro. Use barris explosivos contra eles.", "Отбейтесь от орков Железной Орды. Используйте в бою взрывающиеся бочки.", "抵挡住钢铁部落兽人如潮水般的攻势。使用炸药桶对付他们。", "使用火藥桶抵擋鋼鐵部落獸人的攻擊並存活下來。", }, 
{ "Get to the Central Dock so you can board the Wavemurder Barge.", "Erreicht den zentralen Kai, um an Bord der 'Wellenmord' zu gelangen.", "Llega al muelle central para embarcar en la barcaza Mataolas.", "Ve al muelle central para abordar la barcaza Mataolas.", "Rendez-vous au quai central pour monter à bord de la péniche Crime-des-Flots.", "Raggiungi il Molo Centrale per salire sulla Chiatta Tsunami.", "물결궂힘 화물선에 승선할 수 있도록 중앙 부두로 가야 합니다.", "Vá à Doca Central e embarque na Barcaça Mata-onda.", "Доберитесь до центрального дока и прыгните на борт разбивающего волны баркаса.", "前往中央码头区，登上镇潮号舰艇。", "前往中央碼頭並登上弒浪者駁船。", }, 
{ "Speak with Rokk to get launched onto the Wavemurder Barge.", "Sprecht mit Rokk, um an Bord der 'Wellenmord' zu gelangen.", "Habla con Rokk para subir a la barcaza Mataolas.", "Habla con Rokk para que lancen a la barcaza Mataolas.", "Parlez à Rokk pour sauter à bord de la péniche Crime-des-Flots.", "Parla con Rokk affinché ti lanci sulla Chiatta Tsunami.", "록크와 대화해 물결궂힘 화물선으로 쏘아올려져야 합니다.", "Fale com Rokk para ser lançado na Barcaça Mata-onda.", "Поговорите с Рокком, чтобы вас забросили на разбивающий волны баркас.", "与罗克交谈，在它的帮助下登上镇潮号舰艇。", "和羅科交談，他會將你發射到弒浪者駁船上。", }, 
{ "Destroy the Wavemurder Barge.", "Zerstört die 'Wellenmord'.", "Destruye la barcaza Mataolas.", "Destruye la barcaza Mataolas.", "Sabordez la péniche Crime-des-Flots.", "Distruggi la Chiatta Tsunami.", "물결궂힘 화물선을 파괴해야 합니다.", "Destrua a Barcaça Mata-onda.", "Уничтожьте разбивающий волны баркас.", "摧毁镇潮号舰艇。", "摧毀弒浪者駁船。", }, 
},
["620"] = {
{ "Defeat the bosses of The Arcatraz.", "Bezwingt die Bosse der Arkatraz.", "Derrota a los jefes de El Arcatraz.", "Derrota a los jefes de El Arcatraz.", "Terrassez les boss de l’Arcatraz.", "Sconfiggi i boss di Arcatraz.", "알카트라즈 우두머리들을 처치해야 합니다.", "Derrote os chefes de Arcatraz.", "Победите боссов в Аркатраце.", "击败禁魔监狱的首领。", "擊敗亞克崔茲的首領。", }, 
},
["1307"] = {
{ "Convince Rohash, Nezir and Anshal to swear allegiance to Thunderaan.", "Überzeugt Rohash, Nezir und Anshal, Donneraan die Treue zu schwören.", "Convence a Rohash, Nezir y Anshal para que juren lealtad a Thunderaan.", "Convence a Rohash, Nezir y Anshal de jurar lealtad a Thunderaan.", "Persuadez Rohash, Nezir et Anshal de prêter allégeance à Tonneraan.", "Convinci Rohash, Nezir e Anshal a giurare lealtà a Tuonelaar.", "로하시, 네지르, 안샬이 썬더란에게 충성을 맹세하도록 설득해야 합니다.", "Convença Rohash, Nezir e Anshal a jurar lealdade a Trovejardus.", "Убедите Рохаша, Незира и Аншала присягнуть на верность Громораану.", "说服洛哈西、尼希尔和安舍尔宣誓效忠桑德兰。", "說服洛哈許、涅茲爾和安蕭爾對桑德蘭效忠。", }, 
{ "Take a whirlwind to the center platform.", "Reitet auf einem Wirbelwind zur Plattform in der Mitte.", "Súbete a un torbellino para llegar a la plataforma central.", "Utiliza un torbellino para llegar a la plataforma central.", "Empruntez un tourbillon vers la plateforme centrale.", "Prendi un vortice per arrivare alla piattaforma centrale.", "회오리를 타고 중앙 단상으로 가야 합니다.", "Leve um redemoinho para a plataforma central.", "Доберитесь на вихре до центральной платформы.", "乘坐旋风前往中央平台。", "乘著旋風前往中心平台。", }, 
},
["901"] = {
{ "The Lich King awaits your return to the citadel.", "Der Lichkönig erwartet Eure Rückkehr zur Zitadelle.", "El Rey Exánime espera tu regreso a la ciudadela.", "El Rey Exánime espera tu retorno a la ciudadela.", "Le roi-liche attend votre retour à la citadelle.", "Il Re dei Lich attende il tuo ritorno alla Cittadella.", "리치 왕이 당신이 성채로 돌아오기를 기다리고 있습니다.", "O Lich Rei aguarda seu retorno à cidadela.", "Король-лич ждет вашего возвращения в Цитадель.", "巫妖王在等待着你返回冰冠堡垒。", "巫妖王在冰冠城塞等你回去。", }, 
{ "Enter Icecrown Citadel.", "Betretet die Eiskronenzitadelle.", "Entra en la Ciudadela de la Corona de Hielo.", "Entra en la Ciudadela de la Corona de Hielo.", "Entrez dans la citadelle de la Couronne de glace.", "Entra nella Rocca della Corona di Ghiaccio.", "얼음왕관 성채에 들어가야 합니다.", "Entre na Cidadela da Coroa de Gelo.", "Войдите в Цитадель Ледяной Короны.", "进入冰冠堡垒", "進入冰冠城塞。", }, 
{ "Collect Fragments within Icecrown Citadel.", "Sammelt Fragmente in der Eiskronenzitadelle.", "Reúne fragmentos en la Ciudadela de la Corona de Hielo.", "Recolecta fragmentos dentro de la Ciudadela de la Corona de Hielo.", "Récupérez des fragments dans la citadelle de la Couronne de glace.", "Recupera i frammenti all'interno della Rocca della Corona di Ghiaccio.", "얼음왕관 성채에 있는 서리한 조각을 모아야 합니다.", "Colete fragmentos na Cidadela da Coroa de Gelo.", "Соберите обломки Ледяной Скорби в Цитадели Ледяной Короны.", "在冰冠堡垒中收集碎片。", "在冰冠城塞收集碎片。", }, 
{ "Use the Scourge Teleporter within the Spire.", "Benutzt den Teleporter der Geißel innerhalb der Bastion.", "Usa el teletransportador de la Plaga en La Aguja.", "Usa el Teletransportador de la Plaga dentro de la Aguja.", "Utilisez le téléporteur du Fléau dans la Flèche.", "Usa il Teletrasporto del Flagello all'interno della Guglia.", "첨탑 내부에 있는 스컬지 순간이동기를 사용해야 합니다.", "Use o teleportador do Flagelo no Pináculo.", "Воспользуйтесь транспортером Плети на Шпиле.", "使用尖塔中的天灾传送器。", "使用冰冠尖塔的天譴傳送器。", }, 
{ "Reforge the fragments and form your weapon.", "Schmiedet die Fragmente um und erschafft Eure Waffe.", "Reforja los fragmentos y crea tu arma.", "Vuelve a forjar los fragmentos y forma tu arma.", "Reforgez les fragments et façonnez votre arme.", "Riforgia i frammenti per formare la tua arma.", "조각을 제련하고 무기를 제작해야 합니다.", "Reforje os fragmentos e forme sua arma.", "Перекуйте обломки Ледяной Скорби и создайте свое оружие.", "将碎片重铸为你的武器。", "將碎片重鑄成你的武器。", }, 
{ "Purge the blades of the malevolent souls within.", "Bannt die bösartigen Seelen aus der Klinge.", "Purga las almas malvadas que contienen las hojas.", "Purga las almas malévolas del interior de las espadas.", "Purgez les lames des âmes maléfiques qui les habitent.", "Purifica le lame dalle anime malevole che le infestano.", "사악한 영혼이 깃든 검을 정화해야 합니다.", "Expurgue as lâminas das almas malévolas que elas contêm.", "Очистите клинки от заточенных в них злобных душ.", "净化剑中的怨魂。", "淨化雙劍中的兇殘怨魂。", }, 
{ "The Blades are purged of the corruption. Claim them as your own.", "Die Klingen sind von der Verderbnis geläutert. Nehmt sie als die Euren.", "Las hojas están limpias de corrupción. Reclámalas.", "Las Hojas fueron purgadas de la corrupción. Reclámalas como tuyas.", "Les lames ont été purifiées de toute corruption. Prenez-les.", "Le lame sono state purificate dalla corruzione. Impadroniscitene.", "검에 깃든 타락이 사라졌습니다. 검을 차지해야 합니다.", "As Lâminas foram purgadas de corrupção. Tome-as para si.", "Клинки очищены от порчи. Заберите их себе.", "剑中的腐化已经被清除了。将它们据为己有。", "雙劍的腐化已經淨化了，將它們取為己用。", }, 
{ "Obtain the Lich King's Blessing.", "Erhaltet den Segen des Lichkönigs.", "Obtén la bendición del Rey Exánime.", "Obtén la bendición del Rey Exánime.", "Obtenez la bénédiction du roi-liche.", "Ottieni la Benedizione del Re dei Lich.", "리치 왕의 축복을 받아야 합니다.", "Obtenha a bênção do Lich Rei.", "Получите благословение Короля-лича.", "获得巫妖王的祝福。", "獲得巫妖王的祝福。", }, 
{ "Depart the Frozen Throne by taking the Acherus Waygate.", "Verlasst den Frostthron durch das Tor von Acherus.", "Abandona el Trono Helado por la puerta de Acherus.", "Toma la Puerta de Acherus para salir del Trono Helado.", "Rendez-vous au Trône de glace en utilisant le portail d’accès d’Achérus.", "Lascia il Trono di Ghiaccio attraversando il Portale di Acherus.", "아케루스 차원문을 사용해 얼어붙은 왕좌에서 떠나야 합니다.", "Deixe o Trono de Gelo pelo Pórtico de Áquerus.", "Покиньте Ледяной Трон, пройдя через врата на Акерус.", "使用阿彻鲁斯传送门离开冰封王座。", "使用亞榭洛傳送門離開冰封王座。", }, 
},
["1092"] = {
{ "Travard's team is set up in the abandoned Twilight camp. Meet up with him.", "Travards Team hat sich im verlassenen Stützpunkt des Schattenhammers eingerichtet. Trefft Euch mit ihm.", "El equipo de Travard se ha asentado en el Campamento Crepuscular abandonado. Reúnete con él.", "El equipo de Travard se encuentra en el Campamento Crepuscular abandonado. Reúnete con él.", "L’équipe de Travard s’est installée dans le campement du Crépuscule abandonné. Allez le trouver.", "La squadra di Travard si è radunata nell'accampamento abbandonato del Crepuscolo. Raggiungila.", "트래바드와 그의 동료들이 버려진 황혼의 야영지에서 준비를 마쳤습니다. 트래바드를 만나야 합니다.", "A equipe de Travard se instalou no acampamento vazio do Crepúsculo. Encontre-se com ele.", "Отряд Травара расположился в заброшенном лагере Сумеречного Молота. Встретьтесь с ним.", "塔瓦德的小队驻扎在了废弃的暮光营地了。去和他见面。", "崔瓦的團隊已在廢棄的暮光營地中完成設置工作。去跟他們會合。", }, 
{ "Enter the tomb complex with Travard and get to Tyr's crypt.", "Betretet den Grabkomplex mit Travard und sucht nach Tyrs Gruft.", "Entra en el complejo de la tumba con Travard y llega a la cripta de Tyr.", "Entra a la tumba con Travard y dirígete a la cripta de Tyr.", "Entrez dans le complexe funéraire avec Travard et trouvez la crypte de Tyr.", "Entra nel complesso di tombe con Travard e raggiungi la cripta di Tyr.", "트래바드와 무덤에 들어간 다음 티르의 납골당으로 가야 합니다.", "Entre no complexo funerário com Travard e alcance a cripta de Tyr.", "Вместе с Траваром проникните в гробницу и доберитесь до склепа Тира.", "与塔瓦德一同进入墓葬群，前往提尔的陵墓。", "跟崔瓦一同進入墓地，找到提爾的墓穴。", }, 
{ "Tyr's crypt is overrun with crazed aberrations. Clear them out to begin the ritual.", "Tyrs Gruft ist von wahnsinnigen Entartungen überrannt. Beseitigt sie, um mit dem Ritual zu beginnen.", "La cripta de Tyr está repleta de aberraciones enloquecidas. Acaba con ellas para comenzar el ritual.", "La cripta de Tyr está repleta de aberraciones despiadadas. Despeja el lugar para iniciar el ritual.", "La crypte de Tyr est infestée d’aberrations enragées. Liquidez-les pour commencer le rituel.", "La cripta di Tyr è infestata da folli aberrazioni. Eliminale prima di iniziare il rituale.", "티르의 납골당이 광기에 사로잡힌 돌연변이로 넘쳐납니다. 의식을 시작하려면 그들을 소탕해야 합니다.", "A cripta de Tyr foi tomada por aberrações insanas. Extermine-as para começar o ritual.", "Склеп Тира кишит обезумевшими аберрациями. Перебейте их перед тем, как начинать ритуал.", "疯狂的怪物盘踞在提尔的陵墓里。清理他们以开始仪式。", "提爾的墓穴到處都是發狂的變異怪。掃蕩它們，然後開始進行儀式。", }, 
{ "Travard wants to begin the ritual. Aid him.", "Travard will mit dem Ritual beginnen. Unterstützt ihn.", "Travard quiere empezar el ritual. Ayúdale.", "Travard quiere comenzar el ritual. Ayúdalo.", "Travard veut commencer le rituel. Aidez-le.", "Travard vuole iniziare il rituale. Aiutalo.", "트래바드가 의식을 시작하려고 합니다. 그를 도와야 합니다.", "Travald quer iniciar o ritual. Ajude-o.", "Травар готов приступить к ритуалу. Помогите ему.", "塔瓦德想要开始仪式。协助他。", "崔瓦想開始進行儀式。協助他。", }, 
{ "A critical part of the ritual was taken below. Retrieve the piece.", "Ein wichtiges Teil für das Ritual wurde nach unten gebracht. Bringt es zurück.", "Se han llevado abajo una parte crucial del ritual. Recuperala.", "Se llevaron una parte critica del ritual abajo. Recupera la pieza.", "Un élément essentiel au rituel a été emporté dans les profondeurs. Récupérez-le.", "Un elemento fondamentale del rituale è stato portato di sotto. Recuperalo.", "의식의 핵심 재료를 빼앗겼습니다. 아래로 내려가 되찾아야 합니다.", "Uma parte importantíssima do ritual foi levada para baixo. Recupere a peça.", "Враги утащили в нижние помещения гробницы необходимый для проведения ритуала фрагмент. Его нужно вернуть.", "完成仪式所需的一个重要成分丢失了。找回它。", "儀式的關鍵要件被帶到底下去了。把它拿回來。", }, 
{ "The giant aberration has the piece. Slay it and retrieve the piece.", "Die riesige Entartung hat das Stück. Tötet sie und nehmt es an Euch.", "La aberración gigante tiene el fragmento. Acaba con ella y recupéralo.", "Esa enorme aberración tiene la pieza. Mátalo y quítasela.", "L’aberration colossale détient l’élément. Tuez-la et récupérez-le.", "La gigantesca aberrazione ha quello che serve. Uccidila e recuperalo.", "거대한 돌연변이가 불꽃을 가지고 있습니다. 돌연변이를 처치하고 불꽃을 회수해야 합니다.", "A aberração gigante tem a peça. Mate-a e recupere a peça.", "Фрагмент в руках гигантской аберрации. Уничтожьте чудовище и заберите его.", "碎片在那个巨型畸变怪身上，干掉它并夺回碎片。", "那個巨大的變異怪擁有碎片。殺死它，奪回碎片。", }, 
{ "Unstable void energies are gathering, follow Travard back up to the crypt before the area is consumed.", "Instabile Leerenenergien sammeln sich. Folgt Travard zurück hinauf in die Gruft, bevor der Bereich ganz verzehrt wird.", "Las energías inestables del vacío se reúnen. Sigue a Travard de vuelta a la cripta antes de que la zona se consuma.", "Se acumulan unas energías del vacío inestables, sigue a Travard a la cripta antes de que se consuma el área.", "Des énergies du Vide instables se rassemblent. Suivez Travard jusqu’à la crypte avant que la zone ne soit détruite.", "Si stanno accumulando energie del Vuoto instabili. Segui Travard fino alla cripta prima che l'area venga consumata.", "불안정한 공허의 에너지가 모이고 있습니다. 공허의 힘이 이 지역을 통째로 삼켜버리기 전에 트래바드를 따라 납골당으로 가야 합니다.", "Energias instáveis do caos estão se reunindo, siga Travard de volta à cripta antes que a área seja consumida.", "Вокруг вас появляются сгустки нестабильной энергии Бездны. Следуйте за Траваром обратно в склеп, пока они не поглотили вас.", "不稳定的虚空能量正在聚集，赶在这个区域被吞噬前跟随塔瓦德回到陵墓中。", "不穩定的虛無能量正在集結，在這個區域被吞噬之前，跟隨崔瓦回到墓地。", }, 
{ "Some of the paladins are wounded or covered in void magic. Free them by cleansing and healing them.", "Einige der Paladine sind verwundet oder von Leerenmagie bedeckt. Befreit sie, indem Ihr sie läutert und heilt.", "Algunos paladines están heridos o cubiertos de magia del vacío. Purifícalos y sánalos para liberarlos.", "Algunos paladines están heridos o cubiertos de magia. Purifícalos o sánalos para liberarlos.", "Certains des paladins sont blessés ou couverts de magie du Vide. Libérez-les en les purifiant et en les soignant.", "Alcuni dei Paladini sono feriti o ricoperti dalla magia del Vuoto. Liberali purificandoli e curali.", "성기사들이 부상당하거나 공허 마법에 사로잡혀있습니다. 상처를 치유하거나 마법을 정화하여 그들이 다시 일어설 수 있게 해줘야 합니다.", "Alguns dos paladinos estão feridos ou cobertos de magia do caos. Liberte-os por meio de limpeza ou cura.", "Некоторые паладины ранены или находятся под влиянием магии Бездны. Исцелите раненых и очистите тронутых порчей.", "有几个圣骑士受伤了，也有人被虚空魔法所困。治疗或净化他们。", "有些聖騎士受了傷，或是受到虛無魔法包覆。淨化並治療他們，把他們解救出來。", }, 
{ "Everyone is out of the passage, but something large and malevolent is coming up from below. Run with Travard to the crypt.", "Es ist niemand mehr in der Passage, doch etwas Großes und Bösartiges nähert sich von unten. Lauft mit Travard zur Gruft.", "Todos han salido del pasadizo, pero hay algo grande y maligno que se acerca desde las profundidades. Corre con Travard a la cripta.", "Todos están fuera del pasaje, pero algo grande y malévolo se aproxima desde abajo. Corre con Travard hacia la cripta.", "Le passage est dégagé, mais une chose monstrueuse et malveillante arrive des profondeurs. Réfugiez-vous dans la crypte avec Travard.", "Sono fuggiti tutti, ma qualcosa di grosso e malvagio sta uscendo dai sotterranei. Raggiungi subito la cripta con Travard.", "모두 통로를 빠져나갔지만, 아래에서 거대하고 사악한 무언가가 다가오고 있습니다. 트래바드와 함께 납골당으로 도망가야 합니다.", "Todos deixaram a passagem, mas tem algo grande e malévolo vindo de baixo. Corra com Travard até a cripta.", "Все покинули опасное место, но на поверхность прорывается нечто ужасное. Бегите в склеп за Траваром.", "所有人都逃出通道了，但某种可怕的怪物出现在了下方。与塔瓦德一起逃往陵墓。", "大家都已離開通道，但是有個巨大且邪惡的傢伙從下方上來了。跟崔瓦一同奔入地穴。", }, 
{ "Travard must complete the ritual to unlock the hammer from the wards. Defend the crypt until he is finished!", "Travard muss das Ritual abschließen, um den Hammer aus den Zauberschutzen zu befreien. Verteidigt die Gruft, bis er fertig ist!", "Travard tiene que cumplir el ritual para liberar el martillo de los resguardos. ¡Defiende la cripta hasta que haya terminado!", "Travar debe completar el ritual para liberar el martillo de los resguardos. ¡Defiende la cripta hasta que termine!", "Travard doit mener à bien le rituel permettant de libérer le marteau des protections. Défendez la crypte le temps qu’il en finisse !", "Travard deve completare il rituale per sbloccare il martello dalle protezioni. Difendi la cripta finché non avrà finito!", "수호물을 해제하고 망치를 얻으려면 트래바드가 의식을 완료해야 합니다. 그가 의식을 마칠 때까지 납골당을 방어하십시오!", "Travard tem que completar o ritual para libertar o martelo das proteções. Defenda a cripta até que ele termine!", "Травар должен завершить ритуал, чтобы снять обереги и получить доступ к молоту. Обороняйте склеп, пока он не закончит!", "塔瓦德需要完成仪式才能从结界中取出战锤。在他完成仪式前保护他！", "崔瓦必須完成儀式才能從結界中解開神錘。在他完成之前守禦墓地！", }, 
{ "The Silver Hand is free. Claim it before Mordoth overwhelms the defenders!", "Die Silberne Hand ist frei. Nehmt sie an Euch, bevor Mordoth die Verteidiger überwältigt!", "La Mano de Plata está libre. ¡Recupérala antes de que Mordoth supere a los defensores!", "La Mano de Plata es libre. ¡Recógela antes de que Mordoth derrote a los protectores!", "Main-d’Argent est libre. Récupérez-la avant que Mordoth ne submerge les défenseurs !", "La Mano d'Argento è libera. Prendila prima che Mordoth travolga i difensori!", "이제 은빛 손을 획득할 수 있습니다! 모르도스가 모두를 압도하기 전에 은빛 손을 확보해야 합니다.", "O Punho de Prata está livre. Pegue-o antes que Mordoth supere os defensores!", "Серебряная Длань ждет вас. Заберите ее, пока Мордот не сломил сопротивление защитников склепа!", "白银之手被解放了。在守卫者被莫多斯歼灭前取下它！", "白銀之手自由了。在摩多斯擊敗防禦者之前拿取它！", }, 
},
["907"] = {
{ "Defend against the Legion threat at the Crossroads.", "Schlagt die Legionsbedrohung beim Wegekreuz zurück.", "Defiende El Cruce de la amenaza de la Legión.", "Lucha contra la amenaza de la Legión en el Cruce.", "Repoussez l’assaut de la Légion à la Croisée.", "Neutralizza la minaccia della Legione al Crocevia.", "군단의 위협에 맞서 십자로를 방어해야 합니다.", "Enfrente a ameaça da Legião na Encruzilhada.", "Ликвидируйте угрозу Легиона для Перекрестка.", "清除十字路口的军团威胁。", "在十字路口對抗燃燒軍團的威脅。", }, 
{ "Defeat the Legion Commander threatening the Crossroads.", "Bezwingt den Legionskommandanten, der das Wegekreuz bedroht.", "Derrota al comandante de la Legión que amenaza El Cruce.", "Derrota al comandante de la Legión que amenaza el Cruce.", "Terrassez le commandant de la Légion qui menace la Croisée.", "Sconfiggi il Comandante della Legione che minaccia il Crocevia.", "십자로를 위협하는 군단 사령관을 처치해야 합니다.", "Derrote o Comandante de Legião que ameaça a Encruzilhada.", "Победите командира Легиона, угрожающего Перекрестку.", "击败威胁十字路口的军团指挥官。", "擊敗威脅十字路口的燃燒軍團指揮官。", }, 
{ "Repel the Legion's forces throughout Northern Barrens.", "Schlagt die Streitkräfte der Legion im gesamten Nördlichen Brachland zurück.", "Rechaza a los ejércitos de la Legión de Los Baldíos del Norte.", "Repele a las fuerzas de la Legión en Baldíos del Norte.", "Repoussez les troupes de la Légion dans les Tarides du Nord.", "Respingi le forze della Legione sparse nelle Savane Settentrionali.", "북부 불모의 땅 전역에 있는 군단 세력을 격퇴해야 합니다.", "Rechace as forças da Legião nos Sertões Setentrionais.", "Отразите вторжение сил Легиона в Северных степях.", "击退军团对北贫瘠之地的进攻。", "在北貧瘠之地擊退燃燒軍團的部隊。", }, 
{ "Defeat the demon lord commanding the invasion at the Crossroads.", "Bezwingt den Dämonenfürsten, der die Invasion beim Wegekreuz befehligt.", "Derrota al señor demoníaco que lidera la invasión en El Cruce.", "Derrota al señor de los demonios que comanda la invasión en El Cruce.", "Terrassez le seigneur démon à la tête de l’armée d’invasion à la Croisée.", "Sconfiggi il Signore dei Demoni al comando dell'invasione al Crocevia.", "십자로 침공을 지휘하는 악마 군주를 처치해야 합니다.", "Derrote o lorde-demônio que comanda a invasão à Encruzilhada.", "Победите повелителя демонов, командующего вторжением в Перекресток.", "击败指挥入侵十字路口的恶魔领主。", "在十字路口擊敗指揮入侵行動的惡魔領主。", }, 
},
["611"] = {
{ "Defeat the bosses of The Black Morass", "Bezwingt die Bosse des Schwarzen Morasts.", "Derrota a los jefes de La Ciénaga Negra.", "Derrota a los jefes de La Ciénaga Negra.", "Terrassez les boss du Noir marécage.", "Sconfiggi i boss della Palude Nera.", "검은늪 우두머리들을 처치해야 합니다.", "Derrote os chefes do Lamaçal Negro", "Победите боссов в Черных топях", "击败黑色沼泽的首领", "擊敗黑色沼澤的首領", }, 
},
["677"] = {
{ "Defeat the Grand Champions", "Besiegt die Großchampions", "Derrota a los Grandes Campeones.", "Derrota a los Grandes Campeones", "Terrassez les Grands champions.", "Sconfiggi i Gran Campioni.", "최고 용사들을 처치해야 합니다.", "Derrote os Grandes Campeões", "Победите абсолютных чемпионов", "击败总冠军", "擊敗大勇士", }, 
{ "Overcome the second Argent Trial", "Besteht die zweite Argentumprüfung", "Supera la segunda prueba Argenta.", "Supera la segunda prueba argenta", "Réussissez la deuxième Épreuve d’argent.", "Supera la seconda Prova d'Argento.", "두 번째 은빛십자군의 시험을 극복해야 합니다.", "Vença o segundo Torneio Argênteo", "Пройдите второе испытание Серебряного авангарда", "赢得第二场银色试炼", "通過第二次銀白試煉", }, 
{ "Defeat the Black Knight", "Bezwingt den Schwarzen Ritter.", "Derrota al Caballero Negro", "Derrota al Caballero Negro", "Terrassez le Chevalier noir.", "Sconfiggi il Cavaliere Nero.", "흑기사를 처치해야 합니다.", "Derrote o Cavaleiro Negro", "Победите Черного рыцаря", "击败黑骑士", "擊敗黑騎士。", }, 
},
["1066"] = {
{ "Heal and recruit the beleaguered sea giant.", "Heilt und rekrutiert den bedrängten Meeresriesen.", "Sana y recluta al gigante de mar atormentado.", "Sana y recluta al pobre gigante de mar.", "Soignez et recrutez le géant des mers aux abois.", "Cura e recluta il Gigante del Mare assediato.", "포위된 바다 거인을 치유하고 동료로 삼아야 합니다.", "Cure e recrute o gigante do mar importunado.", "Вылечите изможденного морского великана и заручитесь его поддержкой.", "治疗并招募被围攻的海巨人。", "治療並招募遭受圍攻的海巨人。", }, 
{ "Find and free the missing shaman, Wavespeaker Adelee.", "Sucht die fehlende Schamanin, Wellensprecherin Adelee, und befreit sie.", "Busca y libera a la chamán perdida, la hablaolas Adelee.", "Encuentra y libera a la chamán desaparecida, Hablaolas Adelee.", "Trouvez et libérez la chamane disparue, la parle-vague Adelee.", "Trova e libera la Sciamana sparita, la Parlaonde Adelee.", "실종된 주술사인 파도예언자 아델리를 찾은 다음 풀어주어야 합니다.", "Encontre e liberte a xamã desaparecida, Falaondas Adelee.", "Отыщите пропавшую шаманку, говорящую с волнами Адель, и освободите ее.", "找到并解救失踪的萨满，波涛语者安德莉。", "找到並釋放消失的薩滿，語濤者愛德麗。", }, 
{ "Defeat Kra'liss.", "Bezwingt Kra'liss.", "Derrota a Kra'liss.", "Derrota a Kra'liss.", "Terrassez Kra’liss.", "Sconfiggi Kra'liss.", "크라리스를 처치해야 합니다.", "Derrote Kra'liss.", "Победите Кра'лисса.", "击败克拉里斯。", "擊敗克拉利斯。", }, 
{ "Ascend to the upper level and lead your party through the waves.", "Steigt zur oberen Ebene auf und führt Eure Gruppe durch die Wellen.", "Sube al nivel superior y lidera a tu grupo a través de las olas.", "Asciende al nivel superior y lidera a tu equipo a través de las olas.", "Accédez au niveau supérieur et guidez votre groupe sur les flots.", "Raggiungi il livello superiore e guida il tuo gruppo attraverso le ondate.", "위층으로 올라간 다음 동료들을 이끌고 파도를 통과해야 합니다.", "Suba ao nível superior e lidere seu grupo pelas ondas.", "Поднимитесь на верхний уровень и проведите свою группу через волны.", "抵达上层，带领你的部队穿过波涛。", "登到上一層並帶領你的隊伍穿過浪潮。", }, 
{ "Defeat Lady Zithreen.", "Bezwingt Lady Zithreen.", "Derrota a lady Zithreen.", "Derrota a Lady Zithreen.", "Terrassez dame Zithreen.", "Sconfiggi Dama Zithreen.", "여군주 지스린을 꺾어야 합니다.", "Derrote Lady Zithreen.", "Одолейте Леди Зитрин.", "击败吉斯林。", "擊敗澤瑟琳女士。", }, 
{ "Pick up Sharas'dal.", "Hebt Sharas'dal auf.", "Recoge Sharas'dal.", "Toma a Sharas'dal.", "Ramassez Sharas’dal.", "Raccogli Sharas'dal.", "샤라스달을 손에 넣어야 합니다.", "Pegue Sharas'dal.", "Возьмите Шарас'дал.", "拾起莎拉达尔。", "拿起薩拉達爾。", }, 
},
["1189"] = {
{ "Travel to the Broken Shore.", "Reist zur Verheerten Küste.", "Ve a la Costa Abrupta.", "Viaja a la Costa Quebrada.", "Rendez-vous sur le rivage Brisé.", "Raggiungi la Riva Dispersa.", "부서진 해변으로 가야 합니다.", "Vá até a Costa Partida.", "Отправьтесь на Расколотый берег.", "前往破碎海滩。", "前往破碎海岸。", }, 
{ "Destroy all demons and structures on the beach.", "Vernichtet alle Dämonen und Strukturen am Strand.", "Acaba con todos los demonios y las estructuras de la playa.", "Destruye a todos los demonios y las estructuras de la playa.", "Anéantissez tous les démons et bâtiments sur la plage.", "Elimina tutti i demoni e distruggi le strutture sulla spiaggia.", "해변에 있는 모든 악마와 건물을 파괴해야 합니다.", "Destrua todos os demônios e estruturas da praia.", "Уничтожьте всех демонов и все строения на побережье.", "消灭海滩上所有的恶魔，毁掉所有建筑。", "摧毀海灘上的所有惡魔與建築。", }, 
{ "Slay Fel Commander Azgalor.", "Tötet Teufelskommandant Azgalor.", "Mata al comandante vil Azgalor.", "Asesina al comandante vil Azgalor.", "Éliminez le commandant gangrené Azgalor.", "Uccidi il Vilcomandante Azgalor.", "지옥 사령관 아즈갈로를 처치해야 합니다.", "Mate o Comandante Vil Azgalor.", "Убейте командира повелителей Скверны Азгалора.", "杀死邪能指挥官阿兹加洛。", "殺死惡魔首領阿茲迦洛。", }, 
{ "Locate Sylvanas and Baine.", "Findet Sylvanas und Baine.", "Localiza a Sylvanas y Baine.", "Localiza a Sylvanas y Baine.", "Localisez Sylvanas et Baine.", "Trova Sylvanas e Baine.", "실바나스와 바인을 찾아야 합니다.", "Encontre Sylvana e Baine.", "Найдите Сильвану и Бейна.", "找到希尔瓦娜斯和贝恩。", "找出希瓦娜斯和貝恩的所在地。", }, 
{ "Destroy the demon portal to stop reinforcements.", "Vernichtet das Dämonenportal, um die Verstärkungstruppen aufzuhalten.", "Destruye el portal de demonios para detener a los refuerzos.", "Destruye el portal de demonios para detener a los refuerzos.", "Détruisez le portail démoniaque pour empêcher l’arrivée des renforts.", "Distruggi il portale dei demoni per impedire l'arrivo di rinforzi.", "악마의 차원문을 파괴하여 지원군이 오지 못하게 해야 합니다.", "Destrua o portal demoníaco para impedir a chegada de reforços.", "Уничтожьте портал демонов, чтобы остановить поток подкреплений.", "摧毁恶魔之门以阻挡援军。", "摧毀惡魔傳送門以阻擋其援軍。", }, 
{ "Assault the demon city.", "Greift die Dämonenstadt an.", "Asalta la ciudad demoníaca.", "Ataca la ciudad de los demonios.", "Attaquez la cité démoniaque.", "Assalta la città dei demoni.", "악마의 도시를 공격해야 합니다.", "Ataque a cidade demoníaca.", "Нападите на город демонов.", "突袭恶魔城市。", "突襲惡魔之城", }, 
{ "Get to Tirion.", "Stoßt zu Tirion.", "Llega hasta Tirion.", "Llega hasta Tirion.", "Rejoignez Tirion.", "Raggiungi Tirion.", "티리온 폴드링에게 가야 합니다.", "Chegue até Tirion.", "Доберитесь до Тириона.", "赶到提里奥身边。", "找到提里奧。", }, 
{ "Kill Krosus.", "Tötet Krosus.", "Mata a Krosus.", "Mata a Krosus.", "Tuez Krosus.", "Uccidi Krosus.", "크로서스를 처치해야 합니다.", "Mate Krosus.", "Убейте Кроса.", "消灭克洛苏斯。", "殺死克羅索斯。", }, 
{ "Hold the ridge until the Alliance have stopped Gul'dan.", "Haltet den Grat, bis die Allianz Gul'dan aufgehalten hat.", "Defiende la cresta hasta que la Alianza haya detenido a Gul'dan.", "Mantén la cresta hasta que la Alianza detenga a Gul'dan.", "Tenez la crête jusqu’à ce que l’Alliance ait arrêté Gul’dan.", "Difendi la cresta per permettere all'Alleanza di fermare Gul'dan.", "얼라이언스가 굴단을 막을 때까지 마루를 방어해야 합니다.", "Defenda o cume até que a Aliança tenha parado Gul'dan.", "Удерживайте высоту, пока силы Альянса не остановят Гул'дана.", "守住山脊，直到联盟阻止古尔丹。", "守住山脊直到聯盟成功阻止古爾丹。", }, 
},
["977"] = {
{ "Defeat the forces of Xavius at the base of Shaladrassil.", "Bezwingt die Streitmacht von Xavius an den Wurzeln von Shaladrassil.", "Derrota a los ejércitos de Xavius en la base de Shaladrassil.", "Derrota a las fuerzas de Xavius en la base de Shaladrassil.", "Terrassez les forces de Xavius au pied de Shaladrassil.", "Sconfiggi le forze di Xavius alla base di Shaladrassil.", "샬라드라실 아래에 있는 자비우스의 군대를 물리쳐야 합니다.", "Derrote as forças de Xavius na base de Shaladrassil.", "Разгромите силы Ксавия у корней Шаладрассила.", "在莎拉达希尔的根部击败萨维斯的部队。", "在夏達希爾的根部擊敗薩維斯的部隊。", }, 
},
["619"] = {
{ "Defeat the bosses of The Steamvault", "Besiegt die Bosse der Dampfkammer", "Derrota a los jefes de La Cámara de Vapor.", "Derrota a los jefes de La Cámara de Vapor.", "Terrassez les boss du caveau de la Vapeur.", "Sconfiggi i boss dell'Antro dei Vapori.", "증기 저장고 우두머리들을 처치해야 합니다.", "Derrote os chefes da Câmara dos Vapores", "Победите боссов в Паровом подземелье", "击败蒸汽地窟的首领", "擊敗蒸汽洞窟的首領", }, 
},
["900"] = {
{ "Fly into Felsoul Hold.", "Fliegt in die Teufelsseelenbastion.", "Vuela al Bastión Alma Vil.", "Vuela hasta el Bastión Almavil.", "Volez vers le bastion Gangrâme.", "Vola al Forte Vilanima.", "지옥영혼 요새로 날아가야 합니다.", "Voe até o Castelo Almavil.", "Полетите в оплот Оскверненной Души.", "飞往邪魂堡垒。", "飛進魔魂堡。", }, 
{ "Dive into the fray.", "Stürzt Euch in den Kampf.", "Lánzate a la refriega.", "Únete a la refriega.", "Se jeter dans la mêlée.", "Gettati nella mischia.", "전투에 뛰어들어야 합니다.", "Mergulhe nas pelejas.", "Пикируйте в гущу боя.", "加入战斗。", "加入戰鬥。", }, 
{ "Destroy the wards protecting Varedis and absorb the souls of his minions.", "Vernichtet die Zauberschutze, die Varedis abschirmen, und absorbiert die Seelen seiner Diener.", "Destruye los resguardos que protegen a Varedis y absorbe las almas de sus esbirros.", "Destruye los resguardos que protegen a Varedis y absorbe las almas de sus secuaces.", "Détruisez les protections de Varedis et absorbez les âmes de ses serviteurs.", "Distruggi le difese di Varedis e assorbi le anime dei suoi servitori.", "베레디스의 성소를 보호하는 수호물을 파괴하고, 그 졸개들의 영혼을 흡수해야 합니다.", "Destrua as proteções de Varedis e absorva a alma de seus lacaios.", "Уничтожьте тотемы, преграждающие путь к Варедису, и поглотите души его прислужников.", "摧毁保护瓦雷迪斯的结界，并吸收他的爪牙的灵魂。", "摧毀保護瓦瑞迪斯的結界，吸收他手下的靈魂。", }, 
{ "Kill Varedis Felsoul.", "Tötet Varedis Teufelsseele.", "Mata a Varedis Alma Vil.", "Mata a Varedis Almavil y obtén las Espadas Gemelas del Falsario.", "Tuez Varedis Gangrâme.", "Uccidi Varedis Vilanima.", "베레디스 펠소울를 처치해야 합니다.", "Mate Varedis Almavil.", "Убейте Варедиса Оскверненную Душу.", "击杀瓦雷迪斯·邪魂。", "殺死瓦瑞迪斯‧魔魂。", }, 
{ "Wield the Twinblades of the Deceiver.", "Führt die Zwillingsklingen des Betrügers.", "Blande las Hojas Gemelas del Impostor.", "Blande las Espadas Gemelas del Impostor.", "Maniez les lames jumelles du Trompeur.", "Impugna le Lame Gemelle dell'Ingannatore.", "기만자의 쌍날검을 획득해야 합니다.", "Empunhe as Lâminas Gêmeas do Enganador.", "Возьмите Парные клинки Искусителя.", "挥舞欺诈者的双刃。", "取得欺詐者雙刃。", }, 
},
["576"] = {
{ "Defeat the bosses of The Oculus", "Besiegt die Bosse im Oculus.", "Derrota a los jefes de El Oculus.", "Derrota a los jefes de El Oculus.", "Terrassez les boss de l’Oculus.", "Sconfiggi i boss dell'Oculus.", "마력의 눈 우두머리들을 처치해야 합니다.", "Derrote os chefes do Óculus.", "Победите боссов в Окулусе", "击败魔环的首领", "擊敗奧核之眼的首領", }, 
},
["294"] = {
{ "Defeat the forces of the Death's Head Quilboar inside their city of Razorfen Kraul.", "Bezwingt die Streitkräfte der Totenkopfstacheleber im Kral der Klingenhauer.", "Derrota a las fuerzas de los jabaespines Caramuerte en su ciudad del Horado Rajacieno.", "Derrota a las fuerzas del jabaespín principal de la Muerta que están en el Horado Rajacieno.", "Terrassez les hurans de la Tête de mort dans leur bastion du kraal de Tranchebauge.", "Sconfiggi le forze dei Verrospino Testamorta dentro la loro città nelle Gallerie di Lamaspina.", "가시덩굴 우리 안에 있는 죽음의 머리교 가시멧돼지들을 처치해야 합니다.", "Derrote as forças dos javatuscos Cabeça da Morte dentro do Urzal dos Tuscos.", "Разгромите свинобразов Мертвой Головы в лабиринтах Иглошкурых.", "击败剃刀沼泽内的亡首野猪人大军。", "在剃刀沼澤的野豬人城市中擊敗亡首野豬人勢力。", }, 
},
["1065"] = {
{ "Free Azuregos from the ethereals by defeating the Voidtouched Channelers binding him and restore his health.", "Befreit Azuregos von den Astralen, indem Ihr die leerenberührten Kanalisierer bezwingt, die ihn binden, und seine Gesundheit wiederherstellt.", "Libera a Azuregos de los etéreos derrotando a los canalizadores tocados por el vacío que lo retienen, y restaura su salud.", "Libera a Azuregos de los etéreos derrotando a los Canalizadores Tocados por el vacío que lo atan, y restaura su salud.", "Libérez Azuregos de l’emprise des éthériens en terrassant les canalisateurs touchés par le Vide qui le retiennent captif, puis soignez-le.", "Libera Azuregos dagli Eterei sconfiggendo i Salmodianti Toccati dal Vuoto che lo tengono imprigionato, quindi curalo completamente.", "공허에 물든 역술사를 처치하여 아주어고스를 풀어준 다음 그를 치유해야 합니다.", "Liberte Azuregos dos etéreos derrotando os Canalizadores Maculados pelo Caos que o atam e recuperando a saúde dele.", "Освободите Азурегоса от влияния эфириалов, победив сковавших его отмеченных Бездной чародеев, и помогите ему восстановить здоровье.", "击败灵媒引导者，将艾索雷苟斯从虚灵的手中救出来，并恢复他的生命值。", "擊敗束縛艾索雷苟斯的虛無之觸導魔師，把他從以太族手中救出來並治好他的傷勢。", }, 
{ "Reach the Librarium to find a way into the Nexus Vault.", "Erreicht das Librarium, um einen Weg in die Nexuskammer zu finden.", "Llega hasta el Librarium para encontrar una forma de entrar en la Cámara del Nexo.", "Llega al Librarium para encontrar una forma de entrar a la Bóveda del Nexo.", "Atteignez le Librarium pour trouver un passage menant au caveau du Nexus.", "Raggiungi il Librarium per trovare un modo di accedere alla Volta del Nexus.", "기록 보존소에 가서 마력의 금고로 가는 길을 알아내야 합니다.", "Vá ao Librarium para encontrar uma entrada para Câmara do Nexus.", "Доберитесь до библиотеки, чтобы отыскать вход в хранилище Нексуса.", "抵达图书馆，想办法进入魔枢宝库。", "前往藏書所找出方法進入奧核寶庫。", }, 
{ "Defeat Judgment's Flame.", "Bezwingt die Flamme des Richturteils.", "Derrota a la llama de sentencia.", "Derrota a la Llama del Juicio.", "Terrassez la flamme du jugement.", "Sconfiggi la Fiamma del Giudizio.", "심판의 불길을 물리쳐야 합니다.", "Derrote a Chama do Julgamento.", "Победите Пламя Правосудия.", "击败审判烈焰。", "擊敗審判之焰。", }, 
{ "Reach the Rift.", "Erreicht den Riss.", "Llega a La Falla.", "Llega a la Falla.", "Atteignez la faille.", "Raggiungi la Faglia.", "균열의 공간에 도착해야 합니다.", "Alcance a Fissura.", "Доберитесь до разлома.", "抵达裂痕。", "前往裂隙。", }, 
{ "Defeat Nexus-Prince Bilaal.", "Bezwingt Nexusprinz Bilaal.", "Derrota al príncipe-nexo Bilaal.", "Derrota al príncipe-nexo Bilaal.", "Terrassez le prince-nexus Bilaal.", "Sconfiggi il Principe del Nexus Bilaal.", "연합왕자 바이랄을 처치해야 합니다.", "Derrote o Príncipe do Nexus Balaal.", "Убейте принца Билаала.", "击败节点亲王拜拉尔", "擊敗奈薩斯王子彼列爾。", }, 
{ "Seize control of Light's Wrath.", "Erringt Kontrolle über den Zorn des Lichts.", "Toma el control de la Cólera de la Luz.", "Toma el control de la Cólera de luz.", "Prenez le contrôle de Courroux-de-Lumière.", "Prendi il controllo dell'Ira della Luce.", "빛의 분노를 통제해야 합니다.", "Tome o controle sobre a Ira da Luz.", "Завладейте Яростью Света.", "夺取圣光之怒的控制权。", "控制聖光之怒。", }, 
{ "Claim Light's Wrath and leave the Nexus Vault.", "Nehmt den Zorn des Lichts an Euch und verlasst die Nexuskammer.", "Recupera la Cólera de la Luz y sal de la Cámara del Nexo.", "Reclama a la Cólera de luz y abandona La bóveda del Nexo.", "Récupérez Courroux-de-Lumière, puis quittez le caveau du Nexus.", "Recupera l'Ira della Luce e abbandona la Volta del Nexus.", "빛의 분노를 획득하고 마력의 금고를 떠나야 합니다.", "Tome a Ira da Luz e deixe a Câmara do Nexus.", "Заберите Ярость Света и покиньте хранилище Нексуса.", "获得圣光之怒并离开魔枢宝库。", "取得聖光之怒然後離開奧核寶庫。", }, 
},
["908"] = {
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["1061"] = {
{ "Something terrible has happened here - speak to Skylord Omnuron to get answers.", "Etwas Schreckliches ist hier geschehen. Sprecht mit Himmelsfürst Omnuron, um Antworten zu bekommen.", "Aquí ha ocurrido algo terrible. Habla con el señor del Cielo Omnuron para hallar respuestas.", "Ocurrió algo terrible aquí. Habla con el Señor del Cielo Omnuron para obtener respuestas.", "Il s’est passé quelque chose de terrible ici. Parlez au seigneur du ciel Omnuron pour obtenir des réponses.", "Qui è successo qualcosa di terribile. Parla con il Signore del Cielo Omnuron per ottenere delle risposte.", "이곳에서 끔찍한 일이 일어났습니다. 하늘군주 옴누론과 대화하여 어떻게 된 일인지 알아내야 합니다.", "Aconteceu alguma coisa terrível aqui. Fale com o Senhor Celeste Omnuron para obter respostas.", "Здесь произошло что-то ужасное. Поговорите с повелителем небес Омнуроном и выясните, что случилось.", "这儿发生了什么？与啸天者欧穆隆交谈以获得答案。", "這裡發生了可怕的事 - 跟傲天者歐姆奴隆交談以了解狀況。", }, 
{ "Archdruid Hamuul Runetotem and his allies' wounds require your aid.", "Die Wunden des Erzdruiden Hamuul Runentotem und seiner Verbündeten bedürfen Eurer Hilfe.", "Las heridas del archidruida Hamuul Tótem de Runa y sus aliados necesitan de tus cuidados.", "Las heridas del Archidruida Hamuul Tótem de Runa y las de sus aliados requieren tu auxilio.", "L’archidruide Hamuul Totem-Runique et ses alliés sont blessés. Ils ont besoin de votre aide.", "Le ferite dell'Arcidruido Hamuul Totem Runico e dei suoi alleati richiedono la tua attenzione.", "대드루이드 하뮬 룬토템과 그의 동료들의 상처를 돌봐야 합니다.", "O Arquidruida Hamuul Runa Totem e seus aliados precisam que você os ajude com os ferimentos.", "Исцелите раны верховного друида Хамуула Рунического Тотема и его союзников.", "大德鲁伊哈缪尔·符文图腾和他的盟友们受伤了，他们需要你的援助。", "大德魯伊哈繆爾‧符文圖騰以及他的夥伴，需要你協助療傷。", }, 
{ "Speak to Lyessa to begin the cleansing ritual.", "Sprecht mit Lyessa, um mit dem Läuterungsritual zu beginnen.", "Habla con Lyessa para comenzar el ritual de purificación.", "Habla con Lyessa para comenzar el ritual de purificación.", "Parlez à Lyessa pour commencer le rituel de purification.", "Parla con Lyessa per iniziare il rituale di purificazione.", "라이사와 대화하여 정화의 의식을 시작해야 합니다.", "Fale com Lyessa para iniciar o ritual de limpeza.", "Поговорите с Лиессой, чтобы начать ритуал очищения.", "与莱莎交谈以开始净化仪式。", "與萊耶莎交談以進行淨化儀式。", }, 
{ "Protect Lyessa while she completes the ritual.", "Beschützt Lyessa, während sie das Ritual abschließt.", "Protege a Lyessa mientras completa el ritual.", "Protege a Lyessa mientras ella completa el ritual.", "Protégez Lyessa pendant qu’elle accomplit le rituel.", "Proteggi Lyessa mentre termina il rituale.", "라이사가 의식을 마칠 때까지 보호해야 합니다.", "Proteja Lyessa enquanto ela completa o ritual.", "Защитите Лиессу и дайте ей завершить ритуал.", "在莱莎进行仪式的时候保护她。", "在萊耶莎完成儀式的時候保護她。", }, 
{ "Give the staff to Lyessa to complete the ritual.", "Überreicht den Stab an Lyessa, um das Ritual abzuschließen.", "Dale el bastón a Lyessa para que complete el ritual.", "Dale el bastón a Lyessa para completar el ritual.", "Remettez le bâton à Lyessa afin de terminer le rituel.", "Consegna il bastone a Lyessa per completare il rituale.", "지팡이를 라이사에게 주고 의식을 마쳐야 합니다.", "Entregue o cajado a Lyessa para completar o ritual.", "Отдайте Лиессе посох, чтобы завершить ритуал.", "把法杖交给莱莎以开始仪式。", "將法杖交給萊耶莎來完成儀式。", }, 
{ "Wield G'Hanir, the Mother Tree.", "Führt G'Hanir, den Mutterbaum", "Blande G'Hanir, el Árbol Madre.", "Blande a G'Hanir, el Árbol Madre.", "Équipez-vous de G’Hanir, l’Arbre-Mère.", "Impugna G'hanir, l'Albero Madre.", "그하니르 - 어머니 나무를 손에 넣어야 합니다.", "Empunhe G'hanir, a Árvore Mãe.", "Возьмите в руки Г'ханир, Изначальное Древо.", "获得加尼尔，母亲之树。", "拿著格哈尼爾，始祖之樹。", }, 
{ "Call upon the souls of the forest and eliminate Destromath.", "Ruft die Geister des Waldes und schaltet Destromath aus.", "Invoca a las almas del bosque y elimina a Destromath.", "Llama a las almas del bosque y elimina a Destromath.", "Appelez les âmes de la forêt et éliminez Destromath.", "Chiedi aiuto alle anime della foresta per eliminare Destromath.", "숲의 영혼을 불러내 데스트로매스를 제거해야 합니다.", "Convoque as almas da floresta e elimine Destrumath.", "Призовите духов леса и уничтожьте Измора.", "召唤森林之魂消灭迪托马斯。", "呼喚森林的靈魂，消滅代斯特麥斯。", }, 
},
["612"] = {
{ "Defeat the bosses of The Botanica", "Bezwingt die Bosse der Botanika.", "Derrota a los jefes de El Invernáculo.", "Derrota a los jefes de El Invernáculo.", "Terrassez les boss de la Botanica.", "Sconfiggi i boss di Botanica.", "신록의 정원 우두머리들을 처치해야 합니다.", "Derrote os chefes do Jardim Botânico", "Победите боссов в Ботанике", "击败生态船的首领", "擊敗波塔尼卡的首領", }, 
},
["1068"] = {
{ "Speak with Grif and meet his vrykul guide, Prustaga.", "Sprecht mit Grif und trefft Euch mit seiner Vrykulführerin, Prustaga.", "Habla con Grif y reúnete con su guía vrykul, Prustaga.", "Habla con Grif y reúnete con su guía vrykul, Prustaga.", "Parlez à Grif et faites la connaissance de sa guide vrykule, Prustaga.", "Parla con Grif e incontra la sua guida Vrykul, Prustaga.", "그리프와 이야기한 다음 그의 브리쿨 길잡이 프루스타가를 만나야 합니다.", "Fale com Grif e conheça o guia vraikal dele, Prustaga.", "Поговорите с Грифом и познакомьтесь с его проводницей-врайкулом Прустагой.", "与格瑞夫交谈，并和他的维库向导普斯塔佳碰面。", "與格瑞夫交談，並與維酷人嚮導普洛絲塔加見面。", }, 
{ "Fnd the entrance to the tomb of Warlord Volund inside the Tomb of Ancient Kings.", "Sucht den Eingang zum Grab des Kriegsfürsten Volund im Grab der Uralten Könige.", "Encuentra la entrada de la tumba del señor de la guerra Volund, dentro de la Tumba de los Antiguos Reyes.", "Encuentra la entrada a la tumba del Señor de la Guerra Volund en la Tumba de los reyes antiguos.", "Trouvez l’entrée de la tombe du seigneur de guerre Volund dans le tombeau des anciens rois.", "Trova l'ingresso alla cripta del Signore della Guerra Volund nella Tomba dei Sovrani Antichi.", "옛 왕들의 무덤 내부에 있는 전쟁군주 볼룬드의 무덤 입구를 찾아야 합니다.", "Encontre a entrada da tumba do Senhor da Guerra Volund dentro da Tumba dos Reis Ancestrais.", "Найдите вход в склеп вождя Волунда в Гробнице древних королей.", "在远古列王陵墓中找到督军沃伦德墓穴的入口。", "在遠古諸王之墓當中找到督軍沃隆德的墓穴入口。", }, 
{ "Assist Prustaga in opening the door to Volund's tomb.", "Unterstützt Prustaga, indem Ihr die Tür zu Volunds Grab öffnet.", "Ayuda a Prustaga a abrir la puerta de la tumba de Volund.", "Ayuda a Prustaga a abrir la puerta de la tumba de Volund.", "Aidez Prustaga à ouvrir la porte de la tombe de Volund.", "Aiuta Prustaga ad aprire la tomba di Volund.", "프루스타가를 도와 볼룬드의 무덤 문을 열어야 합니다.", "Ajude Prustaga a abrir a porta da tumba de Volund.", "Помогите Прустаге открыть дверь склепа Волунда.", "帮助普斯塔佳打开通往沃伦德墓穴的大门。", "協助普洛絲塔加開啟沃隆德墓穴的門。", }, 
{ "Scour Volund's Hoard for a sign of Titanstrike.", "Durchwühlt Volunds Beutekammer nach einem Zeichen von Titanenblitz.", "Registra el Tesoro de Volund en busca del rastro de la Furia Titánica.", "Revisa las provisiones de Volund para encontrar algún rastro de Titánica.", "Écumez le trésor de Volund à la recherche d’indices sur Choc des Titans.", "Ispeziona il tesoro di Volund alla ricerca di Titanassalto.", "볼룬드의 저장고를 샅샅이 뒤져 티탄분쇄자의 흔적을 찾아야 합니다.", "Vasculhe o tesouro de Volund atrás de algum sinal do Trovão Titânico.", "Поищите Мощь Титанов в сокровищнице Волунда.", "在沃伦德的宝库搜索泰坦之击。", "搜尋沃隆德的寶庫，尋找泰坦之擊。", }, 
{ "Warlord Volund seeks to stop you from claiming Titanstrike.", "Kriegsfürst Volund versucht zu verhindern, dass Ihr Euch Titanenblitz nähert.", "El señor de la guerra Volund quiere evitar que recuperes la Furia Titánica.", "El Señor de la Guerra Volund quiere evitar que obtengas a Titánica.", "Le seigneur de guerre Volund cherche à vous empêcher de mettre la main sur Choc des Titans.", "Il Signore della Guerra Volund vuole impedirti di recuperare Titanassalto.", "전쟁군주 볼룬드가 당신이 티탄분쇄자를 차지하는 것을 저지하려 합니다.", "O Senhor da Guerra Volund que impedir que você obtenha o Trovão Titânico.", "Вождь Волунд хочет помешать вам получить Мощь Титанов.", "督军沃伦德想要阻止你得到泰坦之击。", "督軍沃隆德想阻止你取得泰坦之擊。", }, 
{ "Use the teleportation pad to join Mimiron in Ulduar.", "Benutzt die Teleportationsplattform, um zu Mimiron in Ulduar zu gelangen.", "Usa la plataforma de teletransporte para reunirte con Mimiron en Ulduar.", "Usa la plataforma de teletransporte para unirte a Mimiron en Ulduar.", "Utilisez la plateforme de téléportation pour rejoindre Mimiron à Ulduar.", "Usa la Piattaforma di Teletrasporto per raggiungere Mimiron a Ulduar.", "순간이동 장치를 사용하여 울두아르에 있는 미미론에게 가야 합니다.", "Use a plataforma de teleporte para encontrar Mimiron em Ulduar.", "Шагните на площадку телепортера, чтобы переместиться к Мимирону в Ульдуар.", "使用传送台前往奥杜尔，与米米尔隆会面。", "使用傳送器前往奧杜亞找彌米倫。", }, 
},
["508"] = {
{ "Speak with Vindicator Yrel to begin the Alliance's assault upon Grommashar.", "Sprecht mit Verteidigerin Yrel, um mit dem Angriff der Allianz auf Grommashar zu beginnen.", "Habla con la vindicadora Yrel para comenzar el ataque de la Alianza contra Grommashar.", "Habla con la vindicadora Yrel para comenzar el asalto de la Alianza a Grommashar.", "Parlez à la redresseuse de torts Yrel pour lancer l’assaut de l’Alliance sur Grommashar.", "Parla con la Vendicatrice Yrel per avviare l'assalto dell'Alleanza su Grommashar.", "구원자 이렐과 대화해 그롬마쉬아르에 대한 얼라이언스의 총공격을 시작해야 합니다.", "Fale com o Vindicante Yrel para começar o ataque da Aliança a Grommashar.", "Поговорите с воздаятельницей Ирель, чтобы Альянс начал штурм Громмашара.", "与守备官伊瑞尔交谈，开始联盟对格罗玛什尔的攻击。", "和復仇者伊芮爾交談，開始聯盟對葛羅瑪夏的進攻。", }, 
{ "Gather the Alliance forces at the first bend up ahead and strategize with Rangari D'kaan.", "Sammelt die Streitkräfte der Allianz an der ersten Kurve dort vorne und beredet die Pläne mit Rangari D'kaan.", "Reúne a las fuerzas de la Alianza en la siguiente curva y planea una estrategia con el Rangari D'kaan.", "Reúne las fuerzas de la Alianza en la primera curva y crea una estrategia con Rangari D'kaan.", "Regroupez les soldats de l’Alliance au prochain tournant et élaborez une stratégie avec le Rangari D’kaan.", "Raduna le forze dell'Alleanza alla prima svolta e discuti una strategia con il Guardaselve D'kaan.", "길이 굽어지는 곳에서 얼라이언스 군대를 규합하고 랑가리 드칸과 전략을 짜야 합니다.", "Reunir as forças da Aliança na primeira curva adiante e traçar uma estratégia com o Rangari D'kaan.", "Соберите силы Альянса впереди, сразу за первым поворотом, и разработайте план действий вместе с рангари Д'кааном.", "与联盟部队在前方第一个弯道汇合，并与游侠达坎一同制定战略。", "在前方的第一個彎路集結聯盟兵力，並與遊俠德坎共同制訂戰略。", }, 
{ "The might of the Warsong clan rests in their wolfriders. Flank the packmaster and the core of the clan's power will crumble.", "Die Macht des Kriegshymnenklans ist von ihren Wolfsreitern abhängig. Wenn Ihr den Rottenkommandanten überrascht, wird die Macht des Klans zerbröckeln.", "El poder del clan Grito de Guerra reside en sus jinetes de lobos. Flanquea al maestro de manada y el núcleo del poder del clan se vendrá abajo.", "El poderío del clan Grito de Guerra reside en sus jinetes de lobos. Flanquea al maestro de la manada y el núcleo del poder del clan se derrumbará.", "La puissance du clan Chanteguerre réside dans ses Chevaucheurs de loups. Débordez le Maître de la meute et le clan s’effondrera de lui-même.", "La potenza del Clan Cantaguerra è nei loro Cavalcalupi. Attacca al fianco il Mastrobranco e il cuore della loro armata andrà in frantumi.", "늑대기수들은 전쟁노래 부족의 핵심입니다. 무리지도자를 꺾으면 부족의 힘이 매우 약해질 것입니다.", "O poder do Clã Brado Guerreiro está em seus cavalga-lobos. Flanqueie o líder da alcateia e o centro do poder do clã cairá.", "Сила клана Песни Войны – в его наездниках на волках. Атакуйте властителя стаи с фланга.", "战歌氏族的战斗力源于他们的狼骑兵。从侧面袭击他们的兽王，氏族的核心力量就会瓦解。", "戰歌氏族的力量來自於他們的狼騎兵，只要從側翼攻擊狼王就能瓦解戰歌氏族的力量核心。", }, 
{ "Move ahead through the Warsong onslaught. Regroup with the Alliance forces up the path and speak with Vindicator Yrel.", "Drängt Euch durch den Ansturm des Kriegshymnenklans. Trefft Euch mit den Streitkräften der Allianz entlang des Pfads und sprecht mit Verteidigerin Yrel.", "Ábrete paso a través del ataque de los Grito de Guerra. Reagrúpate con las fuerzas de la Alianza, en lo alto del camino, y habla con la vindicadora Yrel.", "Avanza a través del embate de los Grito de Guerra. Reagrúpate con las fuerzas de la Alianza y habla con la vindicadora Yrel.", "Frayez-vous un chemin parmi les Chanteguerres. Rejoignez les troupes de l’Alliance sur le chemin et parlez à la Redresseuse de torts Yrel.", "Avanza attraverso le truppe d'attacco dei Cantaguerra. Raggiungi le forze dell'Alleanza lungo il percorso e parla con la Vendicatrice Yrel.", "전쟁노래 부족의 맹공격을 헤쳐 나가, 길 끝에서 얼라이언스 군대와 합류하고 구원자 이렐과 대화해야 합니다.", "Avance em meio ao massacre do Brado Guerreiro. Reagrupe-se com as forças da Aliança mais à frente e fale com a Vindicante Yrel.", "Перебейте орков из клана Песни Войны. Поднимитесь по тропе к ожидающим вас силам Альянса и поговорите с воздаятельницей Ирель.", "顶着战歌氏族的猛攻前进。与联盟部队在小路汇合，并与守备官伊瑞尔对话。", "在戰歌氏族的猛烈攻勢下推進，重整聯盟兵力並與復仇者伊芮爾談話。", }, 
{ "Thunderlord clan members of the Iron Horde have enslaved the mighty gronn, Durn the Hungerer. Slay him.", "Die Mitglieder der Eisernen Horde aus dem Donnerfürstenklan haben den mächtigen Gronn, Durn den Nimmersatten, versklavt. Tötet ihn.", "Los miembros del clan Señor del Trueno de la Horda de Hierro han esclavizado al poderoso gronn, Durn el Hambriento. Mátalo.", "Los miembros del clan Señor del Trueno de la Horda de Hierro domaron al poderoso gronn, Durn el Hambriento. Mátalo.", "Des membres de la Horde de Fer issus du clan Sire-Tonnerre ont réduit en esclavage un puissant Gronn nommé Durn l’Affameur. Tuez-le.", "I membri del Clan Spaccatuono dell'Orda di Ferro hanno schiavizzato un possente Gronn, Durn il Famelico. Uccidilo.", "강철 호드의 일원인 천둥군주 부족이 강대한 그론, 굶주린 두른을 노예로 만들었습니다. 두른을 처치해야 합니다.", "Membros do clã Senhor do Trovão da Horda de Ferro escravizaram Durn, o Famélico, um poderoso gronn. Mate-o.", "Клан Громоборцев Железной Орды пленил могучего гронна Дарна Ненасытного. Убейте его.", "钢铁部落的雷神氏族成员奴役了一头强大的戈隆——饥饿者杜恩。快去干掉他吧。", "鋼鐵部落中雷霆王氏族的成員奴役了有巨大力量的古羅，『飢餓者』唐恩。殺了他。", }, 
{ "Speak with Vindicator Yrel at the gates to the Grommashar Throne.", "Sprecht mit Verteidigerin Yrel an den Toren zu Grommashars Thron.", "Habla con la vindicadora Yrel en las puertas de entrada al Trono de Grommashar.", "Habla con la vindicadora Yrel en las puertas del trono de Grommashar.", "Parlez à la Redresseuse de torts Yrel aux portes de Grommashar.", "Parla con la Vendicatrice Yrel ai cancelli del Trono di Grommash.", "그롬마쉬아르 옥좌로 통하는 문 앞에서 구원자 이렐과 대화해야 합니다.", "Fale com a Vindicante Yrel nos portões que levam ao Trono de Grommashar.", "Поговорите с воздаятельницей Ирель у ворот на пути к трону Громмашара.", "在通往格罗玛什尔王座的大门前与守备官伊瑞尔交谈。", "在葛羅瑪夏王座大門與復仇者伊芮爾談話。", }, 
{ "The time has come for you and Vindicator Yrel to confront Warlord Garrosh Hellscream.", "Die Zeit ist gekommen, dass Ihr und Verteidigerin Yrel den Kriegsherrn Garrosh Höllschrei konfrontiert.", "Ha llegado la hora de que tú y la vindicadora Yrel os enfrentéis al señor de la guerra Garrosh Grito Infernal.", "Por fin llegó el momento para que tú y la vindicadora Yrel confronten al Señor de la Guerra Garrosh Grito Infernal.", "Le temps est venu pour la redresseuse de torts Yrel et pour vous d’affronter le Seigneur de guerre Garrosh Hurlenfer.", "È giunta l'ora per te e la Vendicatrice Yrel di affrontare il Signore della Guerra Garrosh Malogrido.", "구원자 이렐과 함께 전쟁군주 가로쉬 헬스크림과 맞설 때입니다.", "Chegou a hora de você e a Vindicante Yrel confrontarem o Senhor da Guerra Garrosh Grito Infernal.", "Пришло время вам с воздаятельницей Ирель встретиться лицом к лицу с вождем Гаррошем Адским Криком.", "你和守备官伊瑞尔终于要面对督军加尔鲁什·地狱咆哮了。", "你和復仇者伊芮爾的時機來了，迎戰卡爾洛斯‧地獄吼。", }, 
},
["1051"] = {
{ "Infiltrate the Court of Stars and confront Grand Magistrix Elisande.", "Infiltriert den Hof der Sterne und stellt Großmagistrix Elisande.", "Infíltrate en la Corte de las Estrellas y enfréntate a la gran magistrix Elisande.", "Infíltrate en la Corte de Estrellas y confronta a la Gran magistrix Elisande.", "Infiltrez-vous dans la cour des Étoiles et affrontez la grande magistrice Élisande.", "Infiltrati nella Corte delle Stelle e affronta la Gran Magistra Elisande.", "별의 궁정에 잠입한 다음 대마법학자 엘리산드를 상대해야 합니다.", "Infiltre-se no Pátio das Estrelas e confronte a Grã-magistra Elisande.", "Проникните в Квартал Звезд и бросьте вызов Великому магистру Элисанде.", "渗透进群星庭院，与大魔导师艾利桑德对峙。", "潛入眾星之廷，面對大博學者艾莉珊德。", }, 
},
["577"] = {
{ "Defeat the bosses of Utgarde Pinnacle.", "Besiegt die Bosse in Turm Utgarde.", "Derrota a los jefes de Pináculo de Utgarde.", "Derrota a los jefes del Pináculo de Utgarde.", "Terrassez les boss de la cime d’Utgarde.", "Sconfiggi i boss del Pinnacolo di Utgarde.", "우트가드 첨탑 우두머리들을 처치해야 합니다.", "Derrote os chefes do Pináculo Utgarde.", "Победите боссов на Вершине Утгард.", "击败乌特加德之巅的首领。", "擊敗俄特加德之巔的首領。", }, 
},
["1308"] = {
{ "Return to Karazhan and stop Viz'aduum the Watcher from opening portals to Legion worlds.", "Kehrt nach Karazhan zurück und verhindert, dass Viz'aduum der Beobachter Portale zu Legionswelten öffnet.", "Vuelve a Karazhan e impide que Viz'aduum el Observador abra portales a los mundos de la Legión.", "Regresa a Karazhan e impide que Viz'aduum el Observador abra portales a los mundos de la Legión.", "Retournez à Karazhan et empêchez Viz’aduum l’Observateur d’ouvrir des portails vers les mondes de la Légion.", "Torna a Karazhan e impedisci a Viz'aduum il Guardiano di aprire portali verso i mondi della Legione.", "카라잔으로 돌아가 감시자 비즈아둠이 군단 세계로 통하는 차원문을 열지 못하게 막아야 합니다.", "Retorne a Karazhan e impeça Viz'aduum, o Vigia, de abrir portais para os mundos da Legião.", "Вернитесь в Каражан и помешайте Виз'адууму Всевидящему открыть порталы в миры Легиона.", "重返卡拉赞，并阻止监视者维兹艾德姆打开通往军团世界的传送门。", "回到卡拉贊，阻止『監視者』維茲亞頓開啟通往燃燒軍團世界的傳送門。", }, 
},
["795"] = {
{ "Dispel the naga scouting party.", "Bannt den Spähtrupp der Naga.", "Dispersa al grupo de exploración naga.", "Disipa al grupo de exploradores naga.", "Dispersez la patrouille d’éclaireurs nagas.", "Fai disperdere il gruppo di esploratori dei Naga.", "나가 정찰대 제거", "Dissipe o grupo de reconhecimento naga.", "Рассейте разведотряд наг.", "清除纳迦巡逻队。", "擊退納迦的斥候部隊。", }, 
{ "Speak with Senegos.", "Sprecht mit Senegos.", "Habla con Senegos.", "Habla con Senegos.", "Parlez à Sénégos.", "Parla con Senegos.", "세네고스와 대화해야 합니다.", "Fale com Sênegos.", "Поговорите с Сенегосом.", "与塞纳苟斯交谈。", "與賽諾苟斯交談。", }, 
{ "Protect the Tidestone from the naga.", "Beschützt den Gezeitenstein vor den Naga.", "Protege la Piedramar de los nagas.", "Protege la Maretista de los naga.", "Protégez la Pierre-des-Marées des nagas.", "Proteggi la Pietra delle Maree dai Naga.", "나가로부터 해일석을 지켜야 합니다.", "Proteja a Pedramar das nagas.", "Защитите Приливный камень от наг.", "保护潮汐之石不落入纳迦之手。", "保護潮石不被納迦奪走。", }, 
{ "Slay Majh'Tua and Deeplord Havocbrine.", "Tötet Majh'Tua und Tiefenfürst Todesgischt.", "Mata a Majh'Tua y al señor de las profundidades Marestragos.", "Mata a Majh'Tua y al Señor de las profundidades Maestragos.", "Tuez Majh’tua et le seigneur des profondeurs Ravagemer.", "Uccidi Majh'tua e il Signore delle Profondità Spezzabrina.", "마즈투아와 심연군주 하보크브린을 처치해야 합니다.", "Mate Majh'Tua e Lorde Profundo Caos Salobro.", "Убейте Мадж'Туа и повелителя глубин Морегуба.", "消灭玛乔图和深海领主哈沃布尼", "殺死瑪吉圖瓦與深淵領主鹽厄。", }, 
{ "Slay the nightfallen that are feeding on the Tidestone.", "Tötet die Nachtsüchtigen, die vom Gezeitenstein zehren.", "Mata a los Caídos de la Noche que se están alimentando de la Piedramar.", "Mata a los caídos de la noche que se alimentan de la Maretista.", "Tuez les Souffrenuit qui se nourrissent de la Pierre-des-Marées.", "Uccidi gli Esuli Oscuri che si stanno nutrendo della Pietra delle Maree.", "해일석의 힘을 흡수하는 나이트폴른을 처치해야 합니다.", "Mate os noctívoros que se alimentam da Pedramar.", "Убейте помраченных, подпитывающихся энергией Приливного камня.", "消灭试图吸取潮汐之石力量的堕夜精灵。", "殺死吸取潮石力量的夜落精靈。", }, 
{ "Protect the Tidestone from the withered.", "Beschützt den Gezeitenstein vor den Verdorrten.", "Protege la Piedramar de los Marchitos.", "Protege la Maretista de los marchitos.", "Protégez la Pierre-des-Marées des Flétris.", "Proteggi la Pietra delle Maree dagli Avvizziti.", "메마른 자들로부터 해일석을 지켜야 합니다.", "Proteja a Pedramar dos fenecidos.", "Защитите Приливный камень от иссохших.", "保护潮汐之手不落入枯法者之手。", "保護潮石不被凋萎者奪走。", }, 
{ "Slay Runas the Shamed.", "Tötet Runas den Geschmähten.", "Mata a Runas el Avergonzado.", "Mata a Runas el Humillado.", "Tuez Runas le Gueux.", "Uccidi Runas il Disonorato.", "수치스러운 루나스를 처치해야 합니다.", "Mate Runas, o Humilhado.", "Убейте Рунаса Постыдного.", "消灭可耻的鲁纳斯。", "殺死『蒙羞者』魯那斯。", }, 
},
["1038"] = {
{ "Speak with Nobundo.", "Sprecht mit Nobundo.", "Habla con Nobundo.", "Habla con Nobundo.", "Parlez à Nobundo.", "Parla con Nobundo.", "노분도와 대화해야 합니다.", "Fale com Nobambo.", "Поговорите с Нобундо.", "与努波顿交谈。", "與諾柏多談話。", }, 
{ "Help the scattered shaman.", "Helft den versprengten Schamanen.", "Ayuda a los chamanes dispersos.", "Ayuda a los chamanes dispersos.", "Aidez les chamans dispersés.", "Aiuta gli Sciamani dispersi.", "흩어진 주술사들을 도와야 합니다.", "Ajude os xamãs espalhados.", "Помогите растерянным шаманам.", "帮助四处的萨满。", "幫助四散的薩滿。", }, 
{ "Defeat the Infernals.", "Bezwingt die Höllenbestien.", "Derrota a los infernales.", "Derrota a los Infernales.", "Terrassez les infernaux.", "Sconfiggi gli Infernali.", "지옥불정령을 처치해야 합니다.", "Derrote os Infernais.", "Победите инферналов.", "击败地狱火。", "擊敗煉獄火。", }, 
{ "Use Torra's spear to bring down the felbat Falthus.", "Benutzt Torras Speer, um die Teufelsfledermaus Falthus herunterzuholen.", "Usa la lanza de Torra para derribar al murciélago vil Falthus.", "Usa la lanza de Torra para derribar al murciélago vil Falthus.", "Utilisez la lance de Torra pour abattre Falthus le gangroptère.", "Usa la lancia di Torra per abbattere il vilpipistrello Falthus.", "토라의 창으로 지옥박쥐 팔더스를 처치해야 합니다.", "Use a lança de Torra para derrubar o morcevil Falthus.", "Поразите копьем Торры сквернотопыря Фальтия.", "使用托拉的矛击落魔蝠法尔瑟斯。", "使用托菈的矛把法瑟斯射下來。", }, 
{ "Activate the Maelstrom Pillar to defeat Geth'xun.", "Aktiviert die Mahlstromsäule, um Geth'xun zu bezwingen.", "Activa el pilar de La Vorágine para derrotar a Geth'xun.", "Activa el Pilar de la Vorágine para derrotar a Geth'xun.", "Activez le pilier du Maelström pour vaincre Geth’xun.", "Attiva il Pilastro del Maelstrom per sconfiggere Geth'xun.", "소용돌이의 근원을 활성화하여 게트순을 처치해야 합니다.", "Ative o Pilar de Voragem para derrotar Geth'xun.", "Активируйте Столп Водоворота, чтобы победить Гет'зуна.", "激活漩涡之柱并击败格斯逊。", "啟動漩渦之柱，擊敗蓋斯勳。", }, 
},
["995"] = {
{ "Board the Naglfar and face Helya in her own domain.", "Geht an Bord der Naglfar und tretet Helya in ihrem eigenen Reich entgegen.", "Sube a bordo del Naglfar y enfréntate a Helya en su propio territorio.", "Aborda el Naglfar y enfrenta a Helya en sus propios dominios.", "Montez à bord du Naglfar et affrontez Helya sur son propre terrain.", "Abborda la Naglfar e affronta Helya nel suo territorio.", "나글파르에 탑승하여, 헬리아의 영역에서 헬리아와 맞서야 합니다.", "Suba em Naglfar e enfrente Helya em seus próprios domínios.", "Проберитесь на борт \"Нагльфара\" и сразитесь с Хелией на ее территории.", "登上纳格法尔号，并在海拉的国度中挑战她。", "登上奈格法號，在黑爾雅的地盤上對付她。", }, 
},
["211"] = {
{ "Speak with Wrathion to figure out how to activate the Thunder Forge.", "Sprecht mit Furorion, um herauszufinden, wie Ihr die Donnerschmiede aktivieren könnt.", "Habla con Wrathion para averiguar cómo se activa la Forja del Trueno.", "Habla con Wrathion para averiguar cómo se activa la Forja del Trueno.", "Parlez à Irion pour comprendre comment activer la forge du Tonnerre.", "Parla con Irathion e scopri come attivare la Forgia dei Fulmini.", "래시온과 대화해 천둥 제련소 작동법을 알아내야 합니다.", "Fale com Wrathion para descobrir como ativar a Forja do Trovão.", "Поговорите с Гневионом, чтобы узнать, как активировать Кузню Грома.", "与拉希奥交谈，找出激活雷霆熔炉的方法。", "與怒西昂交談以想出啟動雷霆熔爐的方法。", }, 
{ "Pour the trillium into the molds and begin charging the Thunder Forge.", "Gießt das Trillium in die Formen und beginnt damit, die Donnerschmiede aufzuladen.", "Vierte el trillium en los moldes para empezar a cargar las Forjas del Trueno.", "Vierte el trillium en los moldes para empezar a cargar las Forjas del Trueno.", "Versez le trillium dans les moules et commencez à charger la forge du Tonnerre.", "Versa il trillio negli stampi e inizia a caricare la Forgia dei Fulmini.", "트릴리움을 틀에 부어 넣고 천둥 제련소 충전을 시작해야 합니다.", "Despeje o trílio nos moldes e comece a carregar a Forja do Trovão.", "Вылейте триллий в формы и начните заряжать Кузню Грома.", "将延极矿倒入模具并开始为雷霆熔炉充能。", "把延齡石倒進模子裡並開始替雷霆熔爐充能。", }, 
{ "Defend Wrathion while the Thunder Forge charges.", "Verteidigt Furorion, während sich die Donnerschmiede auflädt.", "Defiende a Wrathion mientras se carga la Forja del Trueno.", "Defiende a Wrathion mientras se carga la Forja del Trueno.", "Défendez Irion pendant que la forge du Tonnerre se charge.", "Difendi Irathion mentre la Forgia dei Fulmini si carica.", "천둥 제련소가 충전되는 동안 래시온을 보호해야 합니다.", "Defenda Wrathion enquanto a Forja do Trovão carrega.", "Защищайте Гневиона, пока заряжается Кузня Грома.", "在雷霆熔炉充能时保护拉希奥。", "在怒西昂替雷霆熔爐充能時保護他。", }, 
{ "Talk to Wrathion to start the Thunder Forge", "Sprecht mit Furorion, um die Donnerschmiede in Betrieb zu nehmen.", "Habla con Wrathion para activar la Forja del Trueno.", "Habla con Wrathion para activar la Forja del Trueno.", "Parlez à Irion pour activer la forge du Tonnerre.", "Parla con Irathion per avviare la Forgia dei Fulmini.", "래시온과 대화해 천둥 제련소를 가동해야 합니다.", "Falar com Wrathion para ativar a Forja do Trovão", "Поговорите с Гневионом, чтобы развести огонь в Кузне Грома", "与拉希奥交谈以启动雷霆熔炉", "與怒西昂交談來啟動雷霆熔爐", }, 
{ "Defend the Celestial Blacksmith while it forges the Lightning Lance.", "Verteidigt den himmlischen Schmied während er die Blitzlanze schmiedet.", "Defiende al herrero celestial mientras forja la lanza del relámpago.", "Defiende al herrero celestial mientras forja la lanza del relámpago.", "Défendez le forgeron céleste pendant qu’il forge le javelot de foudre.", "Difendi il Fabbro Celestiale mentre forgia la Lancia della Folgore.", "천공의 대장장이가 번개 창을 제련하는 동안 방어해야 합니다.", "Defenda o Ferreiro Celestial enquanto ele forja a Lança de Raio.", "Защищайте Небесного кузнеца, пока он кует Копье молний.", "在天界工匠锻铸闪电长枪时保护他。", "在星穹鐵匠打造閃電長槍時保護他。", }, 
{ "Defeat the Sha Amalgamation assaulting the Thunder Forge.", "Besiegt die Sha-Verschmelzung, die die Donnerschmiede angreift.", "Derrota a la amalgama de sha que ataca la Forja del Trueno.", "Derrota a la amalgama de sha que ataca la Forja del Trueno.", "Terrassez l’amalgame sha en train d’attaquer la forge du Tonnerre.", "Distruggi l'Amalgama di Sha che sta assaltando la Forgia dei Fulmini.", "천둥 제련소를 공격하는 샤 융합체를 처치해야 합니다.", "Derrote o Amálgama de Sha que está atacando a Forja do Trovão.", "Победите слияние ша, атакующее Кузню Грома.", "击败袭击雷霆熔炉的融合之煞。", "擊敗襲擊雷霆熔爐的煞的融合體。", }, 
},
["1257"] = {
{ "Defeat Dargrul's legions and recover the Hammer of Khaz'goroth before Highmountain is destroyed.", "Bezwingt Dargruls Legionen und erlangt den Hammer von Khaz'goroth zurück, bevor der Hochberg zerstört wird.", "Derrota a las legiones de Dargrul y recupera el Martillo de Khaz'goroth antes de que Monte Alto quede destruido.", "Derrota a las legiones de Dargrul y recupera el Martillo de Khaz'goroth antes de que destruyan Altamontaña.", "Terrassez les légions de Dargrul et récupérez le marteau de Khaz’goroth avant que Haut-Roc ne soit détruit.", "Sconfiggi le legioni di Dargrul e recupera il Martello di Khaz'goroth prima che Alto Monte venga distrutta.", "높은산이 파괴되기 전에 다르그룰의 군단을 무찌르고 카즈고로스의 망치를 되찾아야 합니다.", "Derrote as legiões de Dargrul e recupere o Martelo de Khaz'goroth antes que Alta Montanha seja destruída.", "Сокрушите легионы Даргрула и заберите Молот Каз'горота, пока Крутогорье не пало.", "在至高岭被彻底毁灭前击败达古尔的军团，并夺回卡兹格罗斯之锤。", "擊敗達古爾的軍隊，並且在高嶺毀滅之前取得卡茲格羅斯之錘。", }, 
},
["594"] = {
{ "Defeat the bosses of Azjol-Nerub.", "Bezwingt die Bosse von Azjol-Nerub.", "Derrota a los jefes de Azjol-Nerub.", "Derrota a los jefes de Azjol-Nerub.", "Terrassez les boss d’Azjol-Nérub.", "Sconfiggi i boss di Azjol-Nerub.", "아졸네룹 우두머리들을 처치해야 합니다.", "Derrote os chefes de Azjol-Nerub.", "Победите боссов в Азжол-Нерубе.", "击败艾卓-尼鲁布的首领。", "擊敗阿茲歐-奈幽的首領。", }, 
},
["570"] = {
{ "Assist Thrall in defeating the Twilight Hammer.", "Helft Thrall, den Schattenhammerkult zu besiegen.", "Ayuda a Thrall a derrotar al Martillo Crepuscular.", "Ayuda a Thrall a derrotar al Martillo Crepuscular.", "Aider Thrall à vaincre le Marteau du crépuscule.", "Aiuta Thrall a sconfiggere il Martello del Crepuscolo.", "스랄을 도와 황혼의 망치단을 무찔러야 합니다.", "Ajude Thrall a derrotar o Martelo do Crepúsculo.", "Помогите Траллу победить Сумеречный Молот.", "协助萨尔击败暮光之锤。", "協助索爾擊敗暮光之錘。", }, 
},
["219"] = {
{ "Breach the main chamber and stop the abductions.", "Verschafft Euch Zugang zur Hauptkammer und haltet die Entführungen auf.", "Entra en la cámara principal y detén los secuestros.", "Entra en la cámara principal y detén los secuestros.", "Pénétrez dans la chambre principale et mettez un terme aux enlèvements.", "Penetra nella sala principale e ferma i rapimenti.", "주 저장실로 침투해 납치를 막아야 합니다.", "Invada a câmara principal e ponha um fim aos sequestros.", "Прорвитесь в главную комнату и остановите похищения.", "攻破主厅并阻止绑架犯。", "攻入主室，並阻止綁架事件。", }, 
{ "Investigate the main chamber.", "Seht Euch in der Hauptkammer um.", "Investiga la cámara principal.", "Investiga la cámara principal.", "Examinez la chambre principale.", "Esamina la sala principale.", "주 저장실을 조사해야 합니다.", "Investigue a câmara principal.", "Осмотрите главную комнату.", "调查主厅。", "調查主室。", }, 
{ "Help Ticker build a device to open the next gate.", "Helft Ticker, ein Gerät zum Öffnen des nächsten Tors zu bauen.", "Ayuda a Tictac a montar un dispositivo para abrir la siguiente puerta.", "Ayuda a Tictac a montar un dispositivo para abrir la siguiente puerta.", "Aidez Tocant à construire un dispositif pour ouvrir la prochaine porte.", "Aiuta Schiaffo a costruire un dispositivo per aprire il prossimo portale.", "다음 문을 열기 위해 티커가 장치를 만드는 것을 도와야 합니다.", "Ajude o Tique a construir um dispositivo para abrir o próximo portão.", "Помогите Тиккеру создать механизм для открывания следующих ворот.", "帮助钟摆建造装置以打开下一道大门。", "幫助提克爾製造裝置來打開下一道門。", }, 
{ "Defend the Gob Squad while Patch establishes an escape route.", "Verteidigt den Goblintrupp, während Flick den Teleporter bereit macht.", "Defiende al Escuadrón Gob mientras Parche establece una ruta de huida.", "Defiende al Escuadrón Gob mientras Parche establece una ruta de huida.", "Défendez la Brigade gob pendant que Rustine établit une voie de retraite.", "Difendi la Squadra Gob mentre P.E. Parancus apre una via di fuga.", "탈출 장치를 만드는 동안 고블린 분대를 보호해야 합니다.", "Defenda o G.O.P.E. enquanto Mathiaz estabelece uma rota de fuga.", "Защитите подрывной отряд, пока Патч ищет путь к отступлению.", "在补丁启动逃生装置时保护地精小队。", "當派奇建立逃脫路徑時保護哥布林戰隊。", }, 
{ "Complete all Bonus Objectives to receive bonus Valor.", "Erfüllt alle Bonusziele, um zusätzliche Tapferkeitspunkte zu erhalten.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Accomplissez tous les objectifs bonus pour recevoir des points de vaillance supplémentaires.", "Completa tutti gli obiettivi bonus per ricevere Punti Valore aggiuntivi.", "추가 목표를 완료하면 용맹 점수를 더 얻을 수 있습니다.", "Complete todos os objetivos bônus para receber Bravura extra.", "Выполните все дополнительные задачи, чтобы получить бонусные очки доблести.", "完成所有的奖励目标，额外获得勇气点数。", "完成獎勵目標以獲取額外的勇氣點數。", }, 
},
["676"] = {
{ "Defeat the Grand Champions", "Besiegt die Großchampions", "Derrota a los Grandes Campeones.", "Derrota a los Grandes Campeones", "Terrassez les Grands champions.", "Sconfiggi i Gran Campioni.", "최고 용사들을 처치해야 합니다.", "Derrote os Grandes Campeões", "Победите абсолютных чемпионов", "击败总冠军", "擊敗大勇士", }, 
{ "Overcome the second Argent trial", "Besteht die zweite Argentumprüfung", "Supera la segunda prueba Argenta.", "Supera la segunda prueba argenta", "Réussissez la deuxième Épreuve d’argent.", "Supera la seconda Prova d'Argento.", "두 번째 은빛십자군의 시험을 극복해야 합니다.", "Vença o segundo Torneio Argênteo", "Пройдите второе испытание Серебряного авангарда", "赢得第二场银色试炼", "通過第二次銀白試煉", }, 
{ "Defeat The Black Knight", "Bezwingt den Schwarzen Ritter", "Derrota al Caballero Negro.", "Derrota a El Caballero Negro", "Terrassez le Chevalier noir.", "Sconfiggi il Cavaliere Nero.", "흑기사를 처치해야 합니다.", "Derrote o Cavaleiro Negro", "Победите Черного рыцаря", "击败黑骑士", "擊敗黑騎士", }, 
},
["976"] = {
{ "Speak with the White Tiger.", "Sprecht mit dem Weißen Tiger.", "Habla con el Tigre Blanco.", "Habla con El Tigre Blanco.", "Parler au Tigre blanc", "Parla con la Tigre Bianca.", "백호와 대화해야 합니다.", "Fale com o Tigre Branco.", "Поговорите с Белым Тигром.", "与白虎交谈。", "與白虎交談。", }, 
{ "Challenge and triumph over Sigurd the Giantslayer.", "Fordert Sigurd den Riesentöter heraus und triumphiert.", "Desafía y vence a Sigurd el Matagigantes.", "Desafía y vence a Sigurd, el destripador de gigantes.", "Défiez Sigurd le Tueur de géants et terrassez-le.", "Sfida e sconfiggi Sigurd l'Ammazzagiganti.", "거인학살자 시구르드에게 도전하여 승리해야 합니다.", "Desafie e vença Sigurd, o Matador de Gigantes.", "Бросьте вызов Сигурду Убийце Великанов и победите его.", "赢得巨人屠夫希格德的挑战。", "挑戰並擊敗『巨人殺手』西格德。", }, 
{ "Earn a team victory with Rehgar.", "Erringt mit Rehgar einen Teamsieg.", "Consigue una victoria de equipo con Rehgar.", "Obtén una victoria de equipo con Rehgar.", "Remportez une victoire en équipe avec Rehgar.", "Ottieni una vittoria di squadra con Rehgar.", "레가르와 함께 대결에서 승리해야 합니다.", "Conquiste uma vitória de equipe com Rehgar.", "Одержите командную победу вместе с Регаром.", "与雷加尔组队获得胜利。", "和雷加組隊贏得勝利。", }, 
{ "Equip and master the Weapons of the Storm.", "Legt die Waffen des Sturms an und meistert sie.", "Equípate y domina las armas de la tormenta.", "Equipa y domina las Armas de la tormenta.", "Équipez-vous des armes de la tempête et maîtrisez-les.", "Equipaggia e perfeziona l'uso delle Armi della Tempesta.", "폭풍의 무기를 장착하고 완벽하게 제어해야 합니다.", "Equipe e domine as Armas da Tempestade.", "Возьмите в руки оружие бури и подчините себе его силу.", "装备并掌控风暴武器。", "裝備並精通風暴神兵。", }, 
{ "Defeat Lord Kra'vos", "Bezwingt Lord Kra'vos.", "Derrota a lord Kra'vos.", "Derrota a Lord Kra'vos.", "Vaincre le seigneur Kra’vos", "Sconfiggi Sire Kra'vos", "군주 크라보스를 처치해야 합니다.", "Derrote Lorde Kra'vos", "Победите лорда Кра'воса", "击败领主卡拉沃斯", "擊敗克拉沃斯領主。", }, 
},
["876"] = {
{ "Legion Activities Disrupted", "Aktivitäten der Legion unterbrochen", "Actividades de la Legión interrumpidas.", "Actividades de la Legión interrumpidas.", "Activités de la Légion interrompues.", "Ferma le attività della Legione.", "군단 활동을 방해해야 합니다.", "Atividades da Legião atrapalhadas", "Планы Легиона сорваны", "破坏军团的活动", "阻擾燃燒軍團行動。", }, 
},
["1017"] = {
{ "Travel to the Broken Shore. (H)", "", "", "Viaja a la Costa Quebrada. (H)", "", "Raggiungi la Riva Dispersa (Orda).", "부서진 해변으로 가야 합니다. (H)", "Vá à Costa Partida. (H)", "", "前往破碎海滩。", "前往破碎海岸。(部落)", }, 
},
["911"] = {
{ "You made it through the Portal", "Ihr habt es durch das Portal geschafft.", "Has conseguido atravesar el portal.", "Lograste cruzar el Portal.", "Vous avez passé le portail.", "Attraversa il portale.", "차원문을 성공적으로 통과했습니다.", "Você atravessou o Portal", "Вы успешно прошли через портал", "你穿过了传送门", "成功通過傳送門。", }, 
{ "Steal food from the three storage locations and three Wyrmtogue Meatholders in the city below.", "Stehlt Nahrung aus drei Lagern und von drei Fleischhaltern der Wyrmzungen in der unteren Stadt.", "Roba comida de los tres lugares de almacenamiento y de los tres portacarnes Lenguavermis en la ciudad de abajo.", "Roba comida de los tres depósitos y los tres Contenedores de carne de Lenguavermis en la ciudad.", "Dérobez de la nourriture dans les trois réserves et aux trois viandards langues-de-wyrms de la ville en contrebas.", "Ruba del cibo dai tre magazzini e dai tre Brandicarne Drachilingua nella città di sotto.", "지하 도시에 있는 저장고 3개와 고룡혓바닥 고기운반자 3마리에게서 음식을 훔쳐야 합니다.", "Roube comida dos três depósitos e três Guarda-carnes Língua de Serpe na cidade abaixo.", "Украдите еду с трех складов и у трех змееустов-мясников в городе внизу.", "进入下方的城市，从三处储藏室和三名虫语运肉者的身上偷取食物。", "從下方城市盜取食物，你可以在三個儲藏地點以及三個蟲舌肉商那裡找到食物。", }, 
{ "Head out to the back and place the bait.", "Geht nach hinten hinaus und platziert den Köder.", "Dirígete a la parte trasera y coloca el cebo.", "Ve a la parte de atrás y coloca el cebo.", "Rendez-vous à l’arrière et placez l’appât.", "Vai sul retro e posiziona l'esca.", "뒤쪽으로 가서 미끼를 설치해야 합니다.", "Saia pelos fundos e coloque a isca.", "Возвращайтесь назад и положите приманку.", "前往后门，放置诱饵。", "到後頭放置誘餌。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "Retrieve the Fangs and Return to Dalaran.", "Nehmt die Fänge an Euch und kehrt nach Dalaran zurück.", "Recupera los Colmillos y vuelve a Dalaran.", "Recupera los Colmillos y regresa a Dalaran.", "Récupérez les crocs et regagnez Dalaran.", "Recupera le zanne e torna a Dalaran.", "송곳니를 회수한 다음 달라란으로 귀환해야 합니다.", "Recupere as Presas e volte a Dalaran.", "Заберите Клыки и возвращайтесь в Даларан.", "夺取獠牙，并返回达拉然。", "把尖牙帶回達拉然。", }, 
},
["586"] = {
{ "Defeat the bosses of Gundrak", "Besiegt die Bosse von Gundrak", "Derrota a los jefes de Gundrak.", "Derrota a los jefes de Gundrak.", "Terrassez les boss de Gundrak.", "Sconfiggi i boss di Gundrak.", "군드락 우두머리들을 처치해야 합니다.", "Derrote os chefes de Gundrak", "Победите боссов в Гундраке", "击败古达克的首领", "擊敗剛德拉克的首領", }, 
},
["595"] = {
{ "Defeat the bosses of Azjol-Nerub.", "Bezwingt die Bosse von Azjol-Nerub.", "Derrota a los jefes de Azjol-Nerub.", "Derrota a los jefes de Azjol-Nerub.", "Terrassez les boss d’Azjol-Nérub.", "Sconfiggi i boss di Azjol-Nerub.", "아졸네룹 우두머리들을 처치해야 합니다.", "Derrote os chefes de Azjol-Nerub.", "Победите боссов в Азжол-Нерубе.", "击败艾卓-尼鲁布的首领。", "擊敗阿茲歐-奈幽的首領。", }, 
},
["1029"] = {
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
},
["687"] = {
{ "Defeat the bosses of the Shadowmoon Burial Grounds", "Bezwingt die Bosse der Schattenmondgrabstätte.", "Derrota a los jefes del Cementerio de Sombraluna.", "Derrota a los jefes de Cementerios de Sombraluna.", "Terrassez les boss des Terres sacrées d’Ombrelune.", "Sconfiggi i boss della Necropoli dei Torvaluna.", "어둠달 지하묘지 우두머리들을 처치해야 합니다.", "Derrote os chefes do Sepulcrário da Lua Negra", "Убейте боссов Некрополя Призрачной Луны", "击败影月墓地的首领", "擊敗影月墓地的首領", }, 
},
["554"] = {
{ "Defeat the bosses of Grim Batol", "Besiegt die Bosse von Grim Batol.", "Derrota a los jefes de Grim Batol.", "Derrota a los jefes de Grim Batol.", "Terrassez les boss de Grim Batol.", "Sconfiggi i boss di Grim Batol.", "그림 바톨 우두머리들을 처치해야 합니다.", "Derrote os chefes de Grim Batol", "Победите боссов в Грим Батоле", "击败格瑞姆巴托的首领", "擊敗格瑞姆巴托的首領", }, 
},
["1084"] = {
{ "Learn about being a Warlock.", "Erfahrt etwas über das Leben als Hexenmeister.", "Infórmate sobre ser un brujo.", "Averigua más sobre ser un brujo.", "Apprenez-en davantage sur les démonistes.", "Impara il significato di essere uno Stregone.", "흑마법사에 대해 배워야 합니다.", "Aprenda sobre os Bruxos.", "Узнайте, что значит быть чернокнижником.", "学习如何成为一名术士。", "學習如何當一名術士。", }, 
{ "Learn about summoning a Voidwalker.", "Erfahrt mehr darüber, wie man einen Leerwandler beschwört.", "Infórmate sobre invocar a un abisario.", "Averigua más sobre Invocar a un Abisario.", "Apprenez-en davantage sur l’invocation d’un marcheur du Vide.", "Impara come usare Evocazione: Ombra del Vuoto.", "공허방랑자를 소환하는 법을 배워야 합니다.", "Aprenda sobre evocar um Emissário do Caos.", "Научитесь призывать демона Бездны.", "学习召唤虚空行者。", "學習如何召喚虛無行者。", }, 
{ "Learn about Agony.", "Erfahrt mehr über 'Agonie'.", "Infórmate sobre Agonía.", "Averigua más sobre Agonía.", "Apprenez-en davantage sur Agonie.", "Impara come usare Agonia.", "고통에 대해 배워야 합니다.", "Aprenda sobre Agonia.", "Научитесь применять \"Агонию\".", "学习痛楚。", "學習如何使用痛苦。", }, 
{ "Learn about Corruption.", "Erfahrt mehr über 'Verderbnis'.", "Infórmate sobre Corrupción.", "Averigua más sobre Corrupción.", "Apprenez-en davantage sur Corruption.", "Impara come usare Corruzione.", "부패에 대해 배워야 합니다.", "Aprenda sobre Corrupção.", "Научитесь применять \"Порчу\".", "学习腐蚀术。", "學習如何使用腐蝕術。", }, 
{ "Learn about Drain Soul.", "Erfahrt mehr über 'Seelendieb'.", "Infórmate sobre Drenar alma.", "Averigua más sobre Drenar Alma.", "Apprenez-en davantage sur Drain d’âme.", "Impara come usare Risucchio d'Anima.", "영혼 흡수에 대해 배워야 합니다.", "Aprenda sobre Drenar Alma.", "Научитесь применять \"Похищение души\".", "学习吸取灵魂。", "學習如何使用吸取靈魂。", }, 
{ "Learn about Unstable Affliction.", "Erfahrt mehr über 'Instabiles Gebrechen'.", "Infórmate sobre Aflicción inestable.", "Averigua más sobre Aflicción inestable.", "Apprenez-en davantage sur Affliction instable.", "Impara come usare Afflizione Instabile.", "불안정한 고통에 대해 배워야 합니다.", "Aprenda sobre Agonia Instável.", "Научитесь применять \"Нестабильное колдовство\".", "学习痛苦无常。", "學習如何使用痛苦動盪。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Life Tap.", "Erfahrt mehr über 'Aderlass'.", "Infórmate sobre Transfusión de vida.", "Averigua más sobre Transfusión de vida.", "Apprenez-en davantage sur Connexion.", "Impara come usare Conversione Vitale.", "생명력 전환에 대해 배워야 합니다.", "Aprenda sobre Conversão de Vida.", "Научитесь применять \"Жизнеотвод\".", "学习生命分流。", "學習如何使用生命分流。", }, 
{ "Learn about Fear.", "Erfahrt mehr über 'Furcht'.", "Infórmate sobre Miedo.", "Averigua más sobre Miedo.", "Apprenez-en davantage sur Peur.", "Impara come usare Paura.", "공포에 대해 배워야 합니다.", "Aprenda sobre Medo.", "Научитесь применять \"Страх\".", "学习恐惧。", "學習如何使用恐懼術。", }, 
{ "Learn about greater demons.", "Erfahrt mehr über mächtigere Dämonen.", "Infórmate sobre los demonios superiores.", "Averigua más sobre los demonios mayores.", "Apprenez-en davantage sur les démons supérieurs.", "Impara come usare i demoni superiori.", "상급 악마에 대해 배워야 합니다.", "Aprenda sobre demônios mais poderosos.", "Узнайте как можно больше о больших демонах.", "了解强力恶魔。", "學習如何使用上級惡魔。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["910"] = {
{ "Defeat Dargrul's legions and recover the Hammer of Khaz'goroth before Highmountain is destroyed.", "Bezwingt Dargruls Legionen und erlangt den Hammer von Khaz'goroth zurück, bevor der Hochberg zerstört wird.", "Derrota a las legiones de Dargrul y recupera el Martillo de Khaz'goroth antes de que Monte Alto quede destruido.", "Derrota a las legiones de Dargrul y recupera el Martillo de Khaz'goroth antes de que destruyan Altamontaña.", "Terrassez les légions de Dargrul et récupérez le marteau de Khaz’goroth avant que Haut-Roc ne soit détruit.", "Sconfiggi le legioni di Dargrul e recupera il Martello di Khaz'goroth prima che Alto Monte venga distrutta.", "높은산이 파괴되기 전에 다르그룰의 군단을 무찌르고 카즈고로스의 망치를 되찾아야 합니다.", "Derrote as legiões de Dargrul e recupere o Martelo de Khaz'goroth antes que Alta Montanha seja destruída.", "Сокрушите легионы Даргрула и заберите Молот Каз'горота, пока Крутогорье не пало.", "在至高岭被彻底毁灭前击败达古尔的军团，并夺回卡兹格罗斯之锤。", "擊敗達古爾的軍隊，並且在高嶺毀滅之前取得卡茲格羅斯之錘。", }, 
},
["1023"] = {
{ "Ascend Black Rook Hold to track the risen Lord Ravencrest.", "Steigt zur Rabenwehr auf, um den wiederauferstandenen Lord Rabenkrone zu verfolgen.", "Sube al Torreón Grajo Negro para seguir a lord Cresta Cuervo resucitado.", "Sube el Fuerte Torre Oscura para rastrear al Señor Cresta Cuervo resucitado.", "Gravissez le bastion du Freux pour retrouver la piste du seigneur Corvaltus ressuscité.", "Raggiungi la cima del Forte Corvonero per trovare il risorto Ser Crinocorvo.", "검은 떼까마귀 요새로 올라가 되살아난 군주 레이븐크레스트를 추적해야 합니다.", "Ascenda o Castelo Corvo Negro para rastrear o Senhor Cristacorvo.", "Отыщите восставшего лорда Гребня Ворона на верхних ярусах крепости Черной Ладьи.", "攀登黑鸦堡垒，追踪被复生的拉文凯斯领主的踪迹。", "登上玄鴉堡，追蹤黑羽堡主。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["1258"] = {
{ "Search the Vault of the Wardens for Cordana Felsong and defeat her.", "Durchsucht das Verlies der Wächterinnen nach Cordana Teufelsang und besiegt sie.", "Busca a Cordana Cantovil en la Cámara de las Celadoras y derrótala.", "Busca a Cordana Cancionvil en la Bóveda de las Celadoras y derrótala.", "Cherchez Cordana Gangrechant dans le caveau des Gardiennes et terrassez-la.", "Cerca Cordana Vilcanto nelle Segrete delle Custodi e sconfiggila.", "감시관의 금고에서 콜다나 펠송을 찾아 처치해야 합니다.", "Encontre e derrote Cordana Vilcanto na Câmara das Guardiãs.", "Найдите в Казематах Стражей Кордану Оскверненную Песнь и победите ее.", "搜索守望者地窟，找到科达娜·邪歌，并将其击败。", "在看守者鐵獄尋找寇達娜‧魔歌並且擊敗她。", }, 
},
["203"] = {
{ "Launch an assault on the island of Zan'vess.", "Leitet einen Angriff auf die Insel Zan'vess ein.", "Asalta la isla de Zan'vess.", "Asalta la isla de Zan'vess.", "Lancez une attaque sur l’île de Zan’vess.", "Lancia un assalto contro l'isola di Zan'vess.", "잔베스 섬을 공격해야 합니다.", "Lance um ataque na ilha de Zan'vess.", "Присоединитесь к атаке на Зан'весс.", "对扎尼维斯岛发动袭击。", "對贊斐斯島發動攻擊。", }, 
{ "Destroy the Sonic Towers and deactivate the Zan'vess Defense Shield.", "Zerstört die Schalltürme und deaktiviert das Verteidigungsfeld von Zan'vess.", "Destruye las torres sónicas y desactiva el escudo defensivo de Zan'vess.", "Destruye las torres sónicas y desactiva el escudo defensivo de Zan'vess.", "Détruisez les tours de contrôle soniques et désactivez le bouclier défensif de Zan’vess.", "Distruggi le Torri Soniche e disattiva lo Scudo Difensivo di Zan'vess.", "음파 제어탑을 파괴하고 잔베스 수비 보호막을 비활성화시켜야 합니다.", "Destrua as Torres Sônicas e desative o Escudo de Defesa de Zan'vess", "Разрушьте звуковые колонны и отключите защитный щит Зан'весса.", "摧毁声波塔并关闭扎尼维斯的防护盾。", "摧毀音波控制哨塔並關閉贊斐斯防護盾。", }, 
{ "Storm the beach and reach the Heart of Zan'vess.", "Erstürmt den Strand und erreicht das Herz von Zan'vess.", "Irrumpe en la playa y llega hasta el corazón de Zan'vess.", "Irrumpe en la playa y llega hasta el corazón de Zan'vess.", "Débarquez sur la plage et avancez jusqu’au cœur de Zan’vess.", "Assalta la spiaggia e raggiungi il Cuore di Zan'vess.", "해변을 급습해 잔베스 중심부로 가야 합니다.", "Invada a praia e chegue ao Coração de Zan'vess.", "Захватите плацдарм на берегу и доберитесь до Сердца Зан'весса.", "突袭海滩并抵达扎尼维斯之心。", "攻擊沙灘並抵達贊斐斯之心。", }, 
{ "Defeat Commander Tel'vrak and retrieve the Mantid weapon cache.", "Bezwingt Kommandant Tel'vrak und besorgt die Waffen der Mantis.", "Derrota al comandante Tel'vrak y recupera el alijo de armas mántide.", "Derrota al comandante Tel'vrak y recupera el alijo de armas mántide.", "Terrassez le commandant Tel’vrak et récupérez le contenu de la cache d’armes des mantides.", "Sconfiggi il Comandante Tel'vrak e recupera lo scrigno delle armi dei Mantid.", "사령관 텔브라크를 처치한 뒤 사마귀 무기를 확보해야 합니다.", "Derrote o Comandante Tel'vrak e recupere o carregamento de armas mantídeo.", "Победите командора Тел'врака и найдите склад оружия богомолов.", "击败指挥官泰尔伏拉克并夺回螳螂妖武器库。", "打敗指揮官泰弗瑞克並取回螳螂人武器貯藏箱。", }, 
},
["918"] = {
{ "Enter the Eye of Azshara and stop the Wrath of Azshara from being unleashed upon the Broken Isles.", "Begebt Euch in das Auge Azsharas und verhindert, dass Azsharas Zorn auf die Verheerten Inseln entfesselt wird.", "Entra en el Ojo de Azshara y evita que la Cólera de Azshara se desate sobre las Islas Abruptas.", "Entra al Ojo de Azshara y evita que la Cólera de Azshara se desate sobre las Islas Quebradas.", "Entrez dans l’Œil d’Azshara et empêchez le Courroux d’Azshara de se déchaîner sur les îles Brisées.", "Entra nell'Occhio di Azshara e impedisci che l'Ira di Azshara venga scatenata sulle Isole Disperse.", "아즈샤라의 눈으로 들어간 다음, 아즈샤라의 분노가 부서진 섬을 파괴하기 전에 막아야 합니다.", "Entre no Olho de Azshara e impeça que a Ira de Azshara seja liberada sobre as Ilhas Partidas.", "Войдите в Око Азшары и остановите Гнев Азшары, пока он не обрушил свою ярость на Расколотые острова.", "进入艾萨拉之眼，阻止艾萨拉之怒席卷整个破碎群岛。", "前往艾薩拉之眼，阻止艾薩拉之怒的力量被釋放席捲破碎群島。", }, 
},
["958"] = {
{ "Defend against the Legion threat at the Orgrimmar Rear Gate.", "Schlagt die Legionsbedrohung am hinteren Tor von Orgrimmar zurück.", "Defiende la Puerta Trasera de Orgrimmar de la amenaza de la Legión.", "Lucha contra la amenaza de la Legión en la Puerta Trasera de Orgrimmar.", "Repoussez l’assaut de la Légion à la porte d’Azshara.", "Neutralizza la minaccia della Legione all'Ingresso Posteriore di Orgrimmar.", "군단의 위협에 맞서 오그리마 뒷문을 방어해야 합니다.", "Defenda o Portão Traseiro de Orgrimmar contra as forças Legião.", "Ликвидируйте угрозу Легиона для Задних врат Оргриммара.", "在奥格瑞玛后门抵抗燃烧军团的威胁。", "在奧格瑪後門對抗燃燒軍團的威脅。", }, 
{ "Defeat the Legion Commander threatening Orgrimmar Rear Gate.", "Bezwingt den Legionskommandanten, der das hintere Tor von Orgrimmar bedroht.", "Derrota al comandante de la Legión que amenaza la Puerta Trasera de Orgrimmar.", "Derrota al comandante de la Legión que amenaza la Puerta Trasera de Orgrimmar.", "Terrassez le commandant de la Légion qui menace la porte d’Azshara.", "Sconfiggi il Comandante della Legione che minaccia l'Ingresso Posteriore di Orgrimmar.", "오그리마 뒷문을 위협하는 군단 사령관을 처치해야 합니다.", "Derrote o Comandante de Legião que ameaça o Portão Traseiro de Orgrimmar.", "Победите командира Легиона, угрожающего Задним вратам Оргриммара.", "击败威胁奥格瑞玛后门的军团指挥官。", "擊敗威脅奧格瑪後門的燃燒軍團指揮官。", }, 
{ "Repel the Legion's forces throughout Azshara.", "Schlagt die Streitkräfte der Legion in ganz Azshara zurück.", "Rechaza a los ejércitos de la Legión de Azshara.", "Repele a las fuerzas de la Legión en Azshara.", "Repoussez les troupes de la Légion aux quatre coins d’Azshara.", "Respingi le forse della Legione sparse ad Azshara.", "아즈샤라 전역에 있는 군단 세력을 격퇴해야 합니다.", "Rechace as forças da Legião em Azshara.", "Отразите вторжение сил Легиона в Азшаре.", "击退艾萨拉各地的燃烧军团部队。", "在艾薩拉各地擊退燃燒軍團。", }, 
{ "Defeat the demon lord commanding the invasion at the Orgrimmar Rear Gate.", "Bezwingt den Dämonenfürsten, der die Invasion am hinteren Tor von Orgrimmar befehligt.", "Derrota al señor demoníaco que lidera la invasión en la Puerta Trasera de Orgrimmar.", "Derrota al señor de los demonios que comanda la invasión en la Puerta Trasera de Orgrimmar.", "Terrassez le seigneur démon à la tête de l’armée d’invasion à la porte d’Azshara.", "Sconfiggi il Signore dei Demoni al comando dell'invasione all'Ingresso Posteriore di Orgrimmar.", "오그리마 뒷문 침공을 지휘하는 악마 군주를 처치해야 합니다.", "Derrote o lorde-demônio que comanda a invasão ao Portão Traseiro de Orgrimmar.", "Победите повелителя демонов, командующего вторжением в Задние врата Оргриммара.", "击败指挥入侵奥格瑞玛后门的恶魔领主。", "在奧格瑪後門擊敗指揮入侵行動的惡魔領主。", }, 
},
["618"] = {
{ "Defeat the bosses of The Steamvault", "Bezwingt die Bosse der Dampfkammer.", "Derrota a los jefes de La Cámara de Vapor.", "Derrota a los jefes de La Cámara de Vapor.", "Terrassez les boss du caveau de la Vapeur.", "Sconfiggi i boss dell'Antro dei Vapori.", "증기 저장고 우두머리들을 처치해야 합니다.", "Derrote os chefes da Câmara dos Vapores", "Победите боссов в Паровом подземелье", "击败蒸汽地窟的首领", "擊敗蒸汽洞窟的首領", }, 
},
["587"] = {
{ "Defeat the bosses of Gundrak", "Besiegt die Bosse von Gundrak", "Derrota a los jefes de Gundrak.", "Derrota a los jefes de Gundrak.", "Terrassez les boss de Gundrak.", "Sconfiggi i boss di Gundrak.", "군드락 우두머리들을 처치해야 합니다.", "Derrote os chefes de Gundrak", "Победите боссов в Гундраке", "击败古达克的首领", "擊敗剛德拉克的首領", }, 
{ "Defeat Eck the Ferocious", "Besiegt den wilden Eck", "Derrota a Eck el Feroz.", "Derrota a Eck el Feroz.", "Terrassez Eck le Féroce.", "Sconfiggi Eck il Feroce.", "사나운 엑크를 처치해야 합니다.", "Derrote Eck, o Feroz", "Победите Эка Свирепого", "击败凶残的伊克", "擊敗『兇猛』埃克", }, 
},
["715"] = {
{ "Follow the Sergeant", "Folgt dem Unteroffizier", "Sigue al Sargento.", "Sigue al sargento", "Suivez le sergent.", "Segui il Sergente.", "하사관을 따라가야 합니다.", "Siga o Sargento", "Следуйте за сержантом", "追随中士", "跟隨士官", }, 
{ "Defeat the invaders", "Besiegt die Eindringlinge", "Derrota a los invasores.", "Derrota a los invasores", "Terrassez les envahisseurs.", "Sconfiggi gli invasori.", "침략자들을 처치해야 합니다.", "Derrote os invasores", "Победите захватчиков", "击败入侵者", "擊敗入侵者", }, 
{ "Endure the Shadowmoon assault.", "Haltet dem Angriff des Schattenmondklans stand.", "Resiste el asalto Sombraluna.", "Aguanta el asalto Sombraluna.", "Survivez à l’attaque des Ombrelunes.", "Resisti all'assalto dei Torvaluna.", "어둠달 부족의 공격을 막아내야 합니다.", "Resista ao ataque da Lua Negra.", "Выдержите нападение клана Призрачной Луны.", "顶住影月氏族的攻击。", "撐過影月氏族的攻擊。", }, 
{ "Defeat the remaining Shadowmoon forces.", "Besiegt die verbleibenden Truppen des Schattenmondklans.", "Derrota a las tropas Sombraluna restantes.", "Derrota a las fuerzas Sombraluna restantes.", "Terrassez les derniers soldats d’Ombrelune.", "Sconfiggi le forze restanti dei Torvaluna.", "남은 어둠달 병력을 물리쳐야 합니다.", "Derrote as forças da Lua Negra restantes.", "Одержите победу над оставшимися силами клана Призрачной Луны.", "击败影月氏族的残余部队。", "擊敗剩下的影月氏族部隊。", }, 
{ "Return to the town center.", "Kehrt zur Ortsmitte zurück.", "Vuelve al centro de la ciudad.", "Vuelve al centro del pueblo.", "Retournez dans le centre-ville.", "Torna al centro del villaggio.", "마을 중앙으로 가야 합니다.", "Retorne ao centro da cidade.", "Вернитесь в центр гарнизона.", "返回镇中心。", "返回城鎮中心。", }, 
{ "Defeat the Void Spawn.", "Besiegt die Ausgeburt der Leere.", "Derrota al engendro del vacío.", "Derrota al engendro del vacío.", "Terrassez le Rejeton du Vide.", "Sconfiggi la Creatura del Vuoto.", "공허의 피조물을 처치해야 합니다.", "Derrote o Rebento do Caos.", "Победите отродье Бездны.", "击败虚空爪牙。", "擊敗虛無生靈。", }, 
{ "Bronze: Earn 300 Points", "Bronze: Verdient 300 Punkte.", "Bronce: Gana 300 puntos.", "Bronce: obtén 300 puntos", "Bronze : Obtenir 300 points", "Bronzo: ottieni 300 punti.", "동메달: 300점을 획득해야 합니다.", "Bronze: Obter 300 Pontos", "Бронза: заработайте 300 очков", "青铜：获得300点", "青銅：獲得300分", }, 
{ "Silver: Earn 600 Points", "Silber: Verdient 600 Punkte.", "Plata: Gana 600 puntos.", "Plata: obtén 600 puntos", "Argent : Obtenir 600 points.", "Argento: ottieni 600 punti.", "은메달: 600점을 획득해야 합니다.", "Prata: Obter 600 Pontos", "Серебро: заработайте 600 очков", "白银：获得600点", "白銀：獲得600分", }, 
{ "Gold: Earn 1000 Points", "Gold: Verdient 1000 Punkte.", "Oro: Gana 1000 puntos.", "Oro: obtén 1000 puntos", "Or : Obtenir 1 000 points", "Oro: ottieni 1.000 punti.", "금메달: 1000점을 획득해야 합니다.", "Ouro: Obter 1000 Pontos", "Золото: заработайте 1000 очков", "黄金：获得1000点", "黃金：獲得1000分", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["1288"] = {
{ "Return to Karazhan and stop Viz'aduum the Watcher from opening portals to Legion worlds.", "Kehrt nach Karazhan zurück und verhindert, dass Viz'aduum der Beobachter Portale zu Legionswelten öffnet.", "Vuelve a Karazhan e impide que Viz'aduum el Observador abra portales a los mundos de la Legión.", "Regresa a Karazhan e impide que Viz'aduum el Observador abra portales a los mundos de la Legión.", "Retournez à Karazhan et empêchez Viz’aduum l’Observateur d’ouvrir des portails vers les mondes de la Légion.", "Torna a Karazhan e impedisci a Viz'aduum il Guardiano di aprire portali verso i mondi della Legione.", "카라잔으로 돌아가 감시자 비즈아둠이 군단 세계로 통하는 차원문을 열지 못하게 막아야 합니다.", "Retorne a Karazhan e impeça Viz'aduum, o Vigia, de abrir portais para os mundos da Legião.", "Вернитесь в Каражан и помешайте Виз'адууму Всевидящему открыть порталы в миры Легиона.", "重返卡拉赞，并阻止监视者维兹艾德姆打开通往军团世界的传送门。", "回到卡拉贊，阻止『監視者』維茲亞頓開啟通往燃燒軍團世界的傳送門。", }, 
},
["1172"] = {
{ "Rescue Malfurion from the clutches of Xavius.", "Rettet Malfurion aus den Klauen von Xavius.", "Rescata a Malfurion de las garras de Xavius.", "Rescata a Malfurion de las garras de Xavius.", "Sauvez Malfurion des griffes de Xavius.", "Salva Malfurion dalle grinfie di Xavius.", "자비우스의 손아귀에서 말퓨리온을 구출해야 합니다.", "Livre Malfurion das garras de Xavius.", "Вызволите Малфуриона из плена Ксавия.", "从萨维斯手中救下玛法里奥。", "拯救瑪法里恩脫離薩維斯的掌握。", }, 
},
["208"] = {
{ "Work with your allies to assault Bloodied Crossing.", "Arbeitet mit Euren Verbündeten zusammen, um die Blutige Kreuzung anzugreifen.", "Colabora con tus aliados para asaltar el Cruce Sangriento.", "Colabora con tus aliados para asaltar el Cruce Sangriento.", "Unissez-vous aux troupes alliées pour attaquer la croisée Ensanglantée.", "Supporta i tuoi alleati durante l'assalto al Crocevia Insanguinato.", "아군과 함께 움직여 선혈의 십자로를 공격해야 합니다.", "Trabalhe com seus aliados para atacar a Encruzilhada Rubra.", "Помогите войскам союзников в атаке на Кровавый перекресток.", "与你的盟友一起突袭血腥岔路口。", "與盟友們一起攻擊染血路口。", }, 
{ "Defeat the Palace Gatekeepers to unlock the gates.", "Besiegt die Palasttorwächter, um die Tore zu öffnen.", "Derrota a los guardianes de palacio para abrir las puertas.", "Derrota a los guardianes de palacio para abrir las puertas.", "Terrassez les gardiens de la porte du palais pour débloquer les portes.", "Sconfiggi i Guardiani delle Porte del Palazzo per aprire le porte.", "궁전 문지기를 처치해 문을 열어야 합니다.", "Derrote os Guarda-pórticos do Palácio para destrancar os portões.", "Убейте стражей дворцовых врат, чтобы открыть врата.", "击败宫殿守门人并且打开大门。", "擊敗宮殿守門人來打開門鎖。", }, 
{ "Defeat Shan Bu's Mogu and Zandalari defenders.", "Besiegt die Mogu von Shan'Bu und die Zandalariverteidiger.", "Derrota a los defensores mogu y Zandalari de Shan Bu.", "Derrota a los defensores mogu y Zandalari de Shan Bu.", "Terrassez les défenseurs mogu et zandalari de Shan Bu.", "Sconfiggi i Mogu di Shan Bu e i difensori Zandalari.", "샨 부의 모구와 잔달라 방어병들을 처치해야 합니다.", "Derrote os mogus de Shan Bu e os defensores Zandalari.", "Победить могу Шань-Бу и зандаларских защитников.", "击败山怖麾下的魔古族和赞达拉防御者。", "擊敗衫布的魔古和贊達拉防衛者。", }, 
{ "Assist Taran Zhu and Yalia in bringing down Shan Bu.", "Helft Taran Zhu und Yalia dabei, Shan'Bu zu besiegen.", "Ayuda a Taran Zhu y a Yalia a acabar con Shan Bu.", "Ayuda a Taran Zhu y a Yalia a acabar con Shan Bu.", "Aidez Taran Zhu et Yalia à renverser Shan Bu.", "Aiuta Taran Zhu e Yalia a sconfiggere Shan Bu.", "타란 주와 야리아를 도와 샨 부를 처치해야 합니다.", "Ajude Taran Zhu e Yalia a derrubar Shan Bu.", "Помогите Тажаню Чжу и Ялии убить Шань-Бу.", "协助祝踏岚和雅丽亚打倒山怖。", "協助塔蘭·祝和雅里亞擊敗衫布。", }, 
},
["661"] = {
{ "Defeat the bosses of The Wicked Grotto", "Bezwingt die Bosse der Tückischen Grotte.", "Derrota a los jefes de La Gruta Maldita", "Derrota a los jefes de la Gruta Maldita", "Triomphez des boss de la grotte Maudite.", "Sconfiggi i boss della Grotta Perversa.", "악의 동굴 우두머리들을 처치해야 합니다.", "Derrote os chefes da Gruta Malévola", "Победите боссов в Оскверненном гроте", "击败邪恶洞穴的首领", "擊敗邪惡洞穴的首領", }, 
},
["998"] = {
{ "Defeat Jagganoth in Dreadscar Rift.", "Bezwingt Jagganoth in der Schreckensnarbe.", "Derrota a Jagganoth en la Falla Cicatriz del Terror.", "Derrota a Jagganoth en la Falla Cicatriz Aterradora.", "Terrassez Jagganoth à la faille de Scareffroi.", "Sconfiggi Jagganoth nella Faglia Malosfregio.", "공포흉터 균열에 있는 자가노스를 처치해야 합니다.", "Derrote Jagganoth na Fenda Chagamedo.", "Победите Джагганота в разломе Зловещего Шрама.", "在恐痕裂隙击败贾格诺斯。", "在懼痕裂隙擊敗賈岡諾斯。", }, 
{ "Collect the Heart of the Overlord.", "Nehmt das Herz des Oberanführers an Euch.", "Consigue el corazón del Señor supremo.", "Recoge el corazón del Señor Supremo.", "Récupérez le cœur du suzerain.", "Ottieni il Cuore del Supremo.", "대군주의 심장을 획득해야 합니다.", "Recolha o Coração do Lorde Supremo.", "Заберите Сердце Властителя.", "夺取大领主之心。", "取得主宰之心。", }, 
{ "Place the Heart of the Overlord above the altar in the Seat of the Overlord to take command of his armies.", "Platziert das Herz des Oberanführers über dem Altar im Sitz des Oberanführers, um Befehl über seine Armeen zu ergreifen.", "Coloca el corazón del Señor supremo sobre el altar, en el Trono del Señor supremo, para tomar el mando de sus ejércitos.", "Coloca el corazón del Señor Supremo sobre el altar del Asiento del Señor Supremo para tomar el mando de sus ejércitos.", "Placez le cœur du suzerain sur l’autel du Siège du suzerain pour prendre la tête de ses armées.", "Posiziona il Cuore del Supremo sull'altare del Seggio del Supremo per prendere il comando delle sue armate.", "대군주의 군대를 지휘하려면 대군주의 권좌에 있는 제단에 대군주의 심장을 올려놓아야 합니다.", "Coloque o Coração do Lorde Supremo sobre o altar no Trono do Lorde Supremo para comandar os exércitos dele.", "Положите Сердце Властителя на алтарь у Трона Властителя, чтобы принять командование войском.", "把大领主之心放到恐痕裂隙的大领主之座上，并接管他的军队。", "在主宰王座把主宰之心放在祭壇上方，然後號令其大軍。", }, 
},
["961"] = {
{ "Free Allari from her chains.", "Befreit Allari von ihren Ketten.", "Libera a Allari de sus cadenas.", "Libera a Allari de sus cadenas.", "Libérez Allari de ses chaînes.", "Libera Allari dalle sue catene.", "묶여 있는 알라리를 풀어줘야 합니다.", "Liberte Allari das correntes.", "Освободите Аллари от ее оков.", "解开阿莱利的镣铐。", "釋放艾萊莉。", }, 
{ "Cut through the demon hordes and destroy their portals.", "Schlagt Euch durch die Dämonenhorden und zerstört ihre Portale.", "Masacra a las hordas de demonios y destruye sus portales.", "Atraviesa las hordas de demonios y destruye sus portales.", "Frayez-vous un chemin à travers les hordes démoniaques et détruisez leurs portails.", "Supera le orde di demoni e distruggi i loro portali.", "악마의 군단을 뚫고 차원문을 파괴해야 합니다.", "Abra caminho pelas hordas demoníacas e destrua os portais.", "Пробейтесь к порталам через полчища демонов и уничтожьте их.", "在恶魔大军中杀出一条血路，摧毁他们的传送门。", "在惡魔大軍當中殺出一條血路，然後摧毀它們的傳送門。", }, 
{ "Two of Caria's lieutenants are performing a dark ritual. They must be stopped.", "Zwei von Carias Leutnants führen ein dunkles Ritual durch. Sie müssen aufgehalten werden.", "Dos de los lugartenientes de Caria están llevando a cabo un ritual oscuro. Debemos detenerlos.", "Dos de los tenientes de Caria están realizando un ritual oscuro. Deben ser detenidos.", "Deux des lieutenants de Caria sont en train d’accomplir un rituel ténébreux. Il faut à tout prix les arrêter.", "Due dei luogotenenti di Caria stanno celebrando un rituale oscuro. Devono essere fermati.", "카리아의 부관 두 명이 암흑의 소환 의식을 행하고 있습니다. 그들을 막아야 합니다.", "Dois dos tenentes de Cária estão executando um ritual sombrio. Você precisa detê-los.", "Двое подчиненных Карии осуществляют темный ритуал. Их нужно остановить.", "凯丽娅的两名副官正在执行一个黑暗的仪式。必须阻止他们。", "凱莉亞的兩名手下正在進行黑暗儀式。一定要阻止他們。", }, 
{ "Gorgonnash has risen to stop your assault.", "Gorgonnash hat sich erhoben, um Euren Angriff zu stoppen.", "Gorgonnash se ha alzado para detener tu ataque.", "Gorgonnash se alzó para detener tu ataque.", "Gorgonnash intervient pour déjouer votre assaut.", "Gorgonnash si è destato per fermare la tua avanzata.", "고르고나쉬가 당신의 습격을 저지하려고 일어났습니다.", "Gorgonnash se ergueu para deter seu ataque.", "Горгоннаш поднялся на бой, намереваясь остановить ваше нападение.", "戈古纳斯来阻止你了。", "戈古納斯現身阻止你進攻。", }, 
{ "Use your demonic senses to pickup Caria's trail.", "Nutzt Eure dämonischen Sinne, um Carias Spur aufzunehmen.", "Usa tus sentidos demoníacos para seguir el rastro de Caria.", "Usa tus sentidos demoníacos para detectar la pista de Caria.", "Utilisez vos sens démoniaques pour retrouver la piste de Caria.", "Usa i tuoi sensi demoniaci per seguire le tracce di Caria.", "악마의 감각을 이용해 카리아의 흔적을 찾아야 합니다.", "Use seus sentidos demoníacos para encontrar a trilha de Cária.", "Воспользуйтесь своим демоническим чутьем, чтобы взять след Карии.", "使用幽灵视觉寻找凯丽娅的踪迹。", "使用你的惡魔感官來找出凱莉亞的蹤跡。", }, 
{ "Caria Felsoul's time has come.", "Die Stunde von Caria Teufelsseele hat geschlagen.", "Ha llegado la hora de Caria Alma Vil.", "Ha llegado la hora de Caria Alma vil.", "L’heure de Caria Gangrâme a sonné.", "L'ora di Caria Vilanima è giunta.", "카리아 펠소울이 대가를 치를 시간입니다.", "Chegou a hora de Cária Almavil.", "Время Карии Оскверненной Души подошло к концу.", "凯丽娅·邪魂的死期到了。", "凱莉亞‧魔魂的死期到了。", }, 
{ "Claim the Aldrachi Warblades as your own.", "Nehmt die Kriegsklingen der Aldrachi als die Euren an Euch.", "Hazte con las Hojas de Guerra Aldrachi.", "Reclama las Hojas de guerra Aldrachi.", "Emparez-vous des Lames de guerre des Aldrachi.", "Ottieni le Lame da Guerra degli Aldrachi.", "알드라치 전투검을 획득해야 합니다.", "Tome as Lâminas de Guerra Aldrachi para si.", "Заберите Альдрахийские боевые клинки.", "将奥达奇战刃据为己有。", "把奧達奇戰刃取為己用。", }, 
},
["1259"] = {
{ "You must destroy Kruul permanently in the Twisting Nether before he overruns your forces at the Broken Shore!", "Ihr müsst Kruul im Wirbelnden Nether dauerhaft vernichten, bevor er Eure Streitkräfte an der Verheerten Küste überwältigt!", "¡Debes destruir a Kruul para siempre en El Vacío Abisal antes de que sobrepase a tus fuerzas en la Costa Abrupta!", "¡Debes destruir a Kruul definitivamente en el Vacío Abisal antes de que arrase con tus fuerzas en la Costa Quebrada!", "Faites disparaître Kruul à jamais dans le Néant distordu, avant qu’il ne submerge vos troupes au rivage Brisé !", "Devi distruggere permanentemente Kruul nella Distorsione Fatua prima che sconfigga le tue forze alla Riva Dispersa!", "크룰이 부서진 해변에서 당신의 병력을 덮치기 전에 뒤틀린 황천에서 크룰을 처치해야 합니다!", "Você precisa destruir Kruul de uma vez por todas na Espiral Etérea antes que ele vença as suas forças na Costa Partida!", "Вы должны уничтожить Круула в Круговерти Пустоты, пока его войска не атаковали ваши позиции на Расколотом берегу.", "你必须在库鲁尔毁灭你们在破碎海滩的部队前，在扭曲虚空中彻底消灭库鲁尔！", "你必須在扭曲虛空殺死卡魯歐，阻止他蹂躪你在破碎海岸的部隊！", }, 
{ "Inquisitor Variss stands in the way of Kruul. Destroy him!", "Inquisitor Variss versperrt Euren Weg zu Kruul. Vernichtet ihn!", "El inquisidor Variss se interpone en el camino de Kruul. ¡Acaba con él!", "El Inquisidor Variss bloquea el camino hacia Kruul. ¡Destrúyelo!", "L’inquisiteur Variss se dresse entre vous et Kruul. Débarrassez-vous de lui !", "L'Inquisitore Variss blocca la via d'accesso a Kruul. Distruggilo!", "심문관 바리스가 크룰에게 가는 길을 막고 있습니다. 그를 처치해야 합니다!", "O Inquisidor Variss está entre você e Kruul. Acabe com ele!", "Путь к Круулу преградил инквизитор Варисс. Уничтожьте его!", "审判官瓦里斯保护着库鲁尔。消灭他！", "審判官瓦里茲擋在卡魯歐面前。消滅他！", }, 
{ "Kruul has landed, now is your chance! Defeat him once and for all!", "Kruul ist gelandet. Das ist Eure Chance! Besiegt ihn ein für alle Mal!", "Kruul ha aterrizado, ¡es tu oportunidad! ¡Derrótalo de una vez por todas!", "¡Kruul ha aterrizado, esta es tu oportunidad! ¡Derrótalo de una vez por todas!", "Kruul est au sol ! C’est le moment ou jamais de le vaincre une bonne fois pour toutes !", "Kruul è arrivato, è la tua occasione! Sconfiggilo una volta per tutte!", "크룰이 내려왔습니다. 지금이 기회입니다! 그를 완전히 처치해야 합니다!", "Kruul desembarcou, agora é a sua chance! Derrote-o de uma vez por todas!", "Круул опустился на землю – это ваш шанс! Расправьтесь с ним!", "库鲁尔着陆了，你的机会来了！彻底击败他吧！", "卡魯歐落地了，趁現在！一勞永逸地解決他！", }, 
},
["989"] = {
{ "Meet with Archmage Khadgar inside Karazhan.", "Trefft Euch mit Erzmagier Khadgar in Karazhan.", "Reúnete con el archimago Khadgar en Karazhan.", "Reúnete con el Archimago Khadgar dentro de Karazhan.", "Retrouvez l’archimage Khadgar dans l’enceinte de Karazhan.", "Incontra l'Arcimago Khadgar all'interno di Karazhan.", "카라잔 안에 있는 대마법사 카드가를 만나야 합니다.", "Encontre-se com o Arquimago Hadggar no interior de Karazhan.", "Встретьтесь с верховным магом Кадгаром в Каражане.", "进入卡拉赞与大法师卡德加会面。", "在卡拉贊內與大法師卡德加碰面。", }, 
{ "Learn the secrets of Karazhan's past.", "Lernt die Geheimnisse von Karazhans Vergangenheit kennen.", "Descubre los secretos del pasado de Karazhan.", "Aprende los secretos del pasado de Karazhan.", "Découvrez les secrets du passé de Karazhan.", "Scopri i segreti del passato di Karazhan.", "카라잔의 과거에 얽힌 비밀을 알아내야 합니다.", "Descubra os segredos sobre o passado de Karazhan.", "Узнайте тайны прошлого Каражана.", "了解卡拉赞过去的秘密。", "得知卡拉贊過去的秘密。", }, 
{ "Disable the Arcane Protector activated by Medivh.", "Schaltet den Arkanbeschützer aus, den Medivh aktiviert hat.", "Desactiva el protector Arcano activado por Medivh.", "Deshabilita el Protector Arcano que activó Medivh.", "Neutralisez le protecteur arcanique activé par Medivh.", "Disattiva il Protettore Arcano attivato da Medivh.", "메디브가 작동시킨 비전 파수병을 정지시켜야 합니다.", "Desative o Protetor Arcano ativado por Medivh.", "Выведите из строя волшебного заступника, которого активировал Медив.", "关闭被麦迪文开启的奥术保卫者。", "關閉麥迪文啟動的秘法保衛者。", }, 
{ "Stay with Khadgar.", "Bleibt bei Khadgar.", "Quédate con Khadgar.", "Quédate con Khadgar.", "Restez avec Khadgar.", "Resta con Khadgar.", "카드가의 곁에 머물러야 합니다.", "Fique com Hadggar.", "Оставайтесь с Кадгаром.", "跟上卡德加。", "留在卡德加身邊。", }, 
{ "Assist Khadgar by deactivating the protective rune.", "Unterstützt Khadgar, indem Ihr die Schutzrune deaktiviert.", "Ayuda a Khadgar desactivando la runa protectora.", "Desactiva la runa protectora para ayudar a Khadgar.", "Aidez Khadgar en désactivant la rune de protection.", "Aiuta Khadgar disattivando la Runa Protettiva.", "방어의 룬을 비활성화하여 카드가를 도와야 합니다.", "Ajude Hadggar, desativando a runa protetora.", "Помогите Кадгару, деактивировав защитную руну.", "协助卡德加关闭保护符文。", "協助卡德加解除防禦符文。", }, 
{ "Read from the Guardian's Arcanum to escape to the library.", "Lest im Arkanum des Wächters, um in die Bibliothek zu entkommen.", "Lee el arcanum de guardián para escapar a la biblioteca.", "Lee del Arcanum de guardián para escapar hacia la biblioteca.", "Lisez l’Arcanum du gardien pour vous échapper de la bibliothèque.", "Leggi l'Arcanum del Guardiano per riuscire a scappare alla Biblioteca.", "수호자의 비밀을 읽어, 도서관으로 달아나야 합니다.", "Leia o Arcano do Guardião para fugir para a biblioteca.", "Прочтите заклинание из книги \"Тайны Хранителя\", чтобы перенестись в библиотеку.", "阅读守护者的奥秘，设法从图书馆里逃脱。", "誦唸守護者的秘紋以逃出圖書館。", }, 
{ "Destroy the Agitated Tomes.", "Vernichtet die aufgebrachten Folianten.", "Destruye los tomos perturbados.", "Destruye los Tomos agitados.", "Détruisez les tomes agités.", "Distruggi i Tomi Agitati.", "격랑의 마법서를 파괴해야 합니다.", "Destrua os Tomos Agitados.", "Уничтожьте потревоженные фолианты.", "摧毁焦躁的书籍。", "摧毀激動的典籍。", }, 
{ "Assist Khadgar by weakening the guardians.", "Unterstützt Khadgar, indem Ihr die Wächter schwächt.", "Ayuda a Khadgar debilitando a los guardianes.", "Debilita a los guardias para ayudar a Khadgar.", "Aidez Khadgar en affaiblissant les gardiens.", "Aiuta Khadgar indebolendo i Protettori.", "수호자들을 약화시켜 카드가를 도와야 합니다.", "Ajude Hadggar, enfraquecendo os guardiões.", "Помогите Кадгару, ослабив стражей.", "削弱保护者以协助卡德加。", "幫卡德加削弱守護者。", }, 
{ "Assist Khadgar by attuning the protectors to defend Karazhan.", "Unterstützt Khadgar, indem Ihr die Wächter auf die Verteidigung Karazhans einstimmt.", "Ayuda a Khadgar sintonizando a los protectores para defender Karazhan.", "Ayuda a Khadgar a armonizar a los protectores para defender Karazhan.", "Aidez Khadgar en harmonisant les protecteurs pour défendre Karazhan.", "Aiuta Khadgar sintonizzando i Protettori alla difesa di Karazhan.", "파수병이 카라잔을 보호하도록 조율하여 카드가를 도와야 합니다.", "Ajude Hadggar, sintonizando os protetores, para defesa de Karazhan.", "Помогите Кадгару, настроив защитников для обороны Каражана.", "协助卡德加调试守护者，保护卡拉赞。", "幫卡德加調校保衛者來保護卡拉贊。", }, 
{ "Find the tome containing information about the Pillars of Creation.", "Findet den Folianten mit den Informationen über die Säulen der Schöpfung.", "Encuentra el libro que contiene información sobre los Pilares de la Creación.", "Encuentra el tomo que contiene información sobre los Pilares de la Creación.", "Trouvez le tome contenant des informations sur les piliers de la Création.", "Trova il tomo contenente informazioni sui Pilastri della Creazione.", "창조의 근원에 대한 정보가 담긴 책을 찾아야 합니다.", "Encontre o tomo que contém informações sobre os Pilares da Criação.", "Найдите книгу, содержащую сведения о Столпах Созидания.", "找到包含创世之柱情报的书籍。", "找到記有關於創世之柱資訊的書籍。", }, 
{ "Listen to Khadgar's instructions regarding the tome.", "Hört Euch Khadgars Anweisungen zum Folianten an.", "Escucha las instrucciones de Khadgar acerca del tomo.", "Escucha las instrucciones de Khadgar respecto al tomo.", "Écoutez les instructions de Khadgar à propos du tome.", "Ascolta le istruzioni di Khadgar riguardo il Tomo.", "고서에 대한 카드가의 설명을 들어야 합니다.", "Ouça as considerações de Hadggar sobre o tomo.", "Выслушайте указания Кадгара насчет книги.", "听从卡德加关于书籍的讲解。", "聆聽卡德加有關書籍的指示。", }, 
},
["1101"] = {
{ "Free Azuregos from the ethereals.", "Befreit Azuregos von den Astralen.", "Libera a Azuregos de los etéreos.", "Libera a Azuregos de los etéreos.", "Libérez Azuregos de l’emprise des éthériens.", "Libera Azuregos dagli Eterei.", "에테리얼에게 붙잡힌 아주어고스를 풀어주어야 합니다.", "Liberte Azuregos dos etéreos.", "Освободите Азурегоса из плена эфириалов.", "从虚灵手中救出艾索雷苟斯。", "從以太族手中救出艾索雷苟斯。", }, 
{ "Reach the Librarium to find a way into the Nexus Vault.", "Erreicht das Librarium, um einen Weg in die Nexuskammer zu finden.", "Llega hasta el Librarium para encontrar una forma de entrar en la Cámara del Nexo.", "Llega al Librarium para encontrar una forma de entrar a la Bóveda del Nexo.", "Atteignez le Librarium pour trouver un passage menant au caveau du Nexus.", "Raggiungi il Librarium per trovare un modo di accedere alla Volta del Nexus.", "기록 보존소에 가서 마력의 금고로 가는 길을 알아내야 합니다.", "Chegue até o Librarium e encontre uma forma de adentrar a Câmara do Nexus.", "Доберитесь до библиотеки, чтобы отыскать вход в хранилище Нексуса.", "抵达图书馆，想办法进入魔枢宝库。", "前往藏書所找出方法進入奧核寶庫。", }, 
{ "Defeat the Echo of Aluneth.", "Bezwingt das Echo von Aluneth.", "Derrota al eco de Aluneth.", "Derrota al Eco de Aluneth.", "Terrassez l’écho d’Aluneth.", "Sconfiggi l'Eco di Aluneth.", "알루네스의 메아리를 물리쳐야 합니다.", "Derrote o Eco de Aluneth.", "Победите Эхо Алунета.", "击败艾露尼斯的回响。", "擊敗亞魯涅斯的回響。", }, 
{ "Reach the Rift.", "Erreicht den Riss.", "Llega a La Falla.", "Llega a la Falla.", "Atteignez la faille.", "Raggiungi la Faglia.", "균열에 도착해야 합니다.", "Alcance a fissura.", "Доберитесь до Разлома.", "抵达裂痕。", "前往裂隙。", }, 
{ "Defeat Nexus-Prince Bilaal.", "Bezwingt Nexusprinz Bilaal.", "Derrota al príncipe-nexo Bilaal.", "Derrota al príncipe del Nexo Bilaal.", "Terrassez le prince-nexus Bilaal.", "Sconfiggi il Principe del Nexus Bilaal.", "연합왕자 바이랄을 처치해야 합니다.", "Derrote o Príncipe do Nexus Balaal.", "Убейте принца Билаала.", "击败节点亲王拜拉尔。", "擊敗奈薩斯王子彼列爾。", }, 
{ "Sieze control of Aluneth.", "Erringt Kontrolle über Aluneth.", "Toma el control de Aluneth.", "Toma control de Aluneth.", "Prenez le contrôle d’Aluneth.", "Prendi il controllo di Aluneth.", "알루네스를 제어해야 합니다.", "Tome controle de Aluneth.", "Подчините себе Алунета.", "获得艾露尼斯的控制权。", "控制亞魯涅斯。", }, 
{ "Claim Aluneth and leave the Nexus Vault.", "Nehmt Aluneth an Euch und verlasst die Nexuskammer.", "Hazte con Aluneth y sal de la Cámara del Nexo.", "Reclama a Aluneth y abandona La bóveda del Nexo.", "Récupérez Aluneth et quittez le caveau du Nexus.", "Recupera Aluneth e abbandona la Volta del Nexus.", "알루네스를 획득한 다음 마력의 금고를 떠나야 합니다.", "Tome Aluneth e saia da Câmara do Nexus.", "Заберите Алунета и покиньте хранилище Нексуса.", "夺取艾露尼斯并离开魔枢宝库。", "取得亞魯涅斯然後離開奧核寶庫。", }, 
},
["990"] = {
{ "Journey into the lair and locate the Claws of Ursoc.", "Erkundet den Unterschlupf und sucht nach Ursocs Klauen.", "Viaja hasta la guarida y encuentra las Garras de Ursoc.", "Viaja a la guarida y localiza las Garras de Ursoc.", "Aventurez-vous dans la tanière et trouvez les Griffes d’Ursoc.", "Raggiungi l'Antro e recupera gli Artigli di Ursoc.", "우르속의 보금자리에 들어가 우르속의 발톱을 찾아야 합니다.", "Vá até o covil e encontre as Garras de Ursoc.", "Отправляйтесь в логово и отыщите Когти Урсока.", "进入巢穴，找到乌索克之爪。", "進入獸穴，找出厄索克之爪。", }, 
{ "Creatures of the Nightmare are attacking the Spirit of Ursoc! Slay them!", "Alptraumkreaturen greifen den Geist von Ursoc an! Tötet sie!", "¡Las criaturas de la Pesadilla están atacando al espíritu de Ursoc! ¡Mátalas!", "¡Las Criaturas de la Pesadilla están atacando el Espíritu de Ursoc! ¡Mátalas!", "Des créatures du Cauchemar s’en prennent à l’esprit d’Ursoc ! Tuez-les !", "Le creature dell'Incubo stanno attaccando lo Spirito di Ursoc! Uccidile!", "악몽의 피조물이 우르속의 영혼을 공격하고 있습니다! 그들을 처치해야 합니다!", "Criaturas do Pesadelo estão atacando o Espírito de Ursoc! Acabe com elas!", "Создания Кошмара напали на дух Урсока! Убейте их!", "梦魇生物正在攻击乌索克之魂！消灭它们！", "夢魘怪物在攻擊厄索克的靈魂！殺死它們！", }, 
{ "Lea Stonepaw has begun the ritual to remove the last barrier protecting the Claws of Ursoc. Guard her from the creatures of the Nightmare while she performs the ritual!", "Lea Steinpfote hat mit dem Ritual begonnen, das die letzte Schutzbarriere um Ursocs Klauen entfernt. Beschützt sie vor den Kreaturen des Alptraums, während sie das Ritual durchführt.", "Lea Zarpapétrea ha comenzado el ritual para eliminar la última barrera que protege las Garras de Ursoc. ¡Protégela de las criaturas de la Pesadilla mientras realiza el ritual!", "Lea Garra pétrea comenzó el ritual para retirar la última barrera que protege a las Garras de Ursoc. ¡Protégela de las criaturas de la Pesadilla mientras realiza el ritual!", "Léa Rochepatte a commencé le rituel pour lever la dernière barrière qui garde les Griffes d’Ursoc. Protégez-la des créatures du Cauchemar le temps qu’elle termine !", "Lea Pietrazampa ha iniziato il rituale per rimuovere l'ultima barriera che protegge gli Artigli di Ursoc. Difendila dalle creature dell'Incubo finché non avrà finito!", "레아 스톤포우가 우르속의 발톱을 보호하는 마지막 보호막을 제거하는 의식을 시작했습니다. 그녀가 의식을 치르는 동안 악몽의 피조물로부터 그녀를 보호해야 합니다!", "Lea Patapétrea iniciou o ritual para remover a última barreira que protege as garras de Ursoc. Proteja-a das criaturas do Pesadelo enquanto ela executa o ritual!", "Леа начала ритуал, чтобы снять преграду, укрывающую Когти. Защищайте ее от порождений Кошмара!", "莉娅·石爪开始了一个仪式，试图移除保护乌索克之爪的最后屏障。在仪式期间保护好她不受梦魇生物的伤害！", "莉雅‧石爪開始進行儀式，要移除保護厄索克之爪的最後一道屏障。在她進行儀式的時候保護她，別讓她被夢魘怪物攻擊。", }, 
{ "A second wave of invaders are approaching!", "Eine zweite Angriffswelle nähert sich!", "¡Se acerca una segunda oleada de invasores!", "¡Se aproxima una segunda oleada de invasores!", "Une deuxième vague d’envahisseurs approche !", "Una seconda ondata di invasori si avvicina!", "침략자들이 다시 몰려옵니다!", "Uma segunda onda de invasores está se aproximando!", "Приближается вторая волна атакующих!", "第二波入侵者来了！", "第二波入侵者開始進攻了！", }, 
{ "A third wave of invaders are approaching!", "Eine dritte Angriffswelle nähert sich!", "¡Se acerca una tercera oleada de invasores!", "¡Se aproxima una tercera oleada de invasores!", "Une troisième vague d’envahisseurs approche !", "Una terza ondata di invasori si avvicina!", "적의 공세가 아직 끝나지 않았습니다!", "Uma terceira onda de invasores está se aproximando!", "Приближается третья волна атакующих!", "第三波入侵者来了！", "第三波入侵者開始進攻了！", }, 
{ "The ritual is nearly complete! Protect Lea from a final wave of invaders.", "Das Ritual ist beinahe abgeschlossen! Beschützt Lea vor der letzten Angriffswelle.", "¡El ritual está casi completo! Protege a Lea de la última oleada de invasores.", "¡El ritual está casi completado! Protege a Lea de la última oleada de invasores.", "Le rituel est presque terminé ! Protégez Léa de la dernière vague d’envahisseurs.", "Il rituale è quasi terminato! Proteggi Lea dall'ondata finale di invasori.", "의식이 거의 끝나갑니다! 침략자의 마지막 공격에서 레아를 보호해야 합니다.", "O ritual está quase completo! Proteja Lea da última onda de invasores.", "Ритуал уже почти завершен! Защитите Леа от последней волны атакующих.", "仪式快结束了！保护好莉娅，挡住最后一波入侵者。", "儀式快完成了！保護莉雅不受最後一波入侵者攻擊。", }, 
{ "The Lord of Nightmares has captured Ursoc and empowered his disciple with the Claws!", "Der Herr des Alptraums hat Ursoc entführt und seinem Schüler mit den Klauen große Macht verliehen!", "¡El Señor de las Pesadillas ha capturado a Ursoc y ha potenciado su discípulo con las Garras!", "¡El Señor de las Pesadillas capturó a Ursoc y aumentó el poder de sus discípulos con las Garras!", "Le seigneur du Cauchemar a capturé Ursoc et décuplé les forces de son disciple à l’aide des griffes !", "Il Signore dell'Incubo ha catturato Ursoc e potenziato il suo discepolo con gli Artigli!", "악몽의 군주가 우르속을 구속하고, 우르속의 발톱을 이용해 자신의 신도를 강화하고 있습니다!", "O Senhor dos Pesadelos capturou Ursoc e equipou seu discípulo com as Garras!", "Владыка Кошмара пленил Урсока и отдал Когти своему слуге!", "梦魇之王俘虏了乌索克，并用乌索克之爪的力量强化了他的信徒！", "夢魘之王俘虜了厄索克，並且利用爪子強化他的手下！", }, 
{ "The forces of the Nightmare have been defeated. The claws are now yours for the taking.", "Die Streitkräfte des Alptraums wurden bezwungen. Die Klauen sind nun Euer.", "Los ejércitos de la Pesadilla han sido derrotados. Ahora las Garras son tuyas.", "Las fuerzas de la Pesadilla han sido derrotadas. Ya puedes reclamar las garras como tuyas.", "Les troupes du Cauchemar ont été vaincues. Les Griffes d’Ursoc sont à vous.", "Le forze dell'Incubo sono state sconfitte. Puoi finalmente recuperare gli Artigli.", "악몽의 세력을 격퇴했습니다. 우르속의 발톱은 이제 당신의 것입니다.", "As forças do Pesadelo foram derrotadas. As garras agora estão à sua disposição.", "Силы Кошмара разбиты. Теперь вы можете взять Когти, они ваши по праву.", "梦魇大军被击退了，你可以去拿乌索克之爪了。", "夢魘部隊已經消滅。爪子是你的了。", }, 
},
["973"] = {
{ "Wuho should have located a good spot to start. Wait for his signal, then regroup at the landing site.", "Wuho sollte einen guten Startpunkt gefunden haben. Wartet auf sein Signal und gruppiert Euch dann an der Anlandestelle neu.", "Wuho debe de haber encontrado un buen lugar para empezar. Espera a su señal y después reagrupaos en la zona de desembarco.", "Wuho debe ubicar un buen sitio para comenzar. Espera su señal, y luego reúnete en el lugar de desembarco.", "Wuho a dû repérer un bon point de départ. Attendez son signal, puis regroupez-vous au site d’atterrissage.", "Wuho ha identificato un buon punto dove iniziare. Attendi il suo segnale, quindi raggiungi il punto di sbarco.", "우호가 시작하기 좋은 위치를 차지했기를 바랍니다. 그의 신호를 기다린 다음 착륙지에서 재집결해야 합니다.", "Wuho deve ter encontrado um bom ponto de partida. Espere o sinal dele, depois vá até o local de pouso.", "Вухо должен был найти подходящее место. Дождитесь его сигнала, после чего встретьтесь с ним на месте высадки.", "乌霍找到了一处不错的起始地点。等待他的信号，然后在登陆点再次集合。", "伍赫應該已經找到了適合的地方。等候他的信號，然後到降落地點會合。", }, 
{ "Kvaldir wards bar the way further into the swamp. Investigate Tideskorn Harbor to find a way through.", "Zauberschutze der Kvaldir versperren den Weg tiefer in den Sumpf. Durchsucht den Wellenskornhafen nach einem Weg hindurch.", "Los guardias Kvaldir bloquean el paso hacia el pantano. Investiga el Puerto Mareskorn para encontrar la forma de pasar.", "Los resguardos kvaldir bloquean el paso hacia el pantano. Investiga el Puerto Marvilis para encontrar la manera de pasar.", "Des protections kvaldirs barrent l’accès au marais. Explorez le port des Mörgestran pour trouver un passage.", "Le protezioni dei Kvaldir sbarrano la strada verso l'interno della palude. Esplora il Porto degli Abiskorn per trovare una via.", "크발디르 수호물이 늪으로 들어가는 길을 막고 있습니다. 타이드스코른 항구를 조사하여 수호물을 통과할 방법을 알아내야 합니다.", "Proteções kvaldir bloqueiam a trilha para dentro do pântano. Investigue o Porto Mareskárnio para encontrar um caminho.", "Обереги квалдиров преграждают путь вглубь отмели. Осмотрите Волнскорнскую гавань, чтобы найти способ пробраться туда.", "克瓦迪尔的结界挡住了深入沼泽的道路。调查蔑潮港，寻找通过的方法。", "科瓦迪爾結界擋住了進入沼澤的路。調查蔑潮港，找出前進的方式。", }, 
{ "The Mist Warders manage the wards. Use a Freezing Trap or slay them to steal their wardstones.", "Die Nebelwärter betreuen die Zauberschutze. Nutzt eine Eiskältefalle oder tötet sie, um ihre Schutzsteine zu stehlen.", "Los depositarios de niebla se encargan de los resguardos. Usa una trampa congelante o mátalos para robarles sus piedras de resguardo.", "Los Guardianes de la niebla dirigen los resguardos. Usa una Trampa congelante o mátalos para robar sus piedras de resguardo.", "Les protections sont entretenues par les gardiens de la brume. Utilisez un piège givrant ou tuez-les pour voler leurs pierres gardiennes.", "I Custodi della Nebbia si occupano di gestire le protezioni. Usa una Trappola Congelante o uccidili per rubare le loro Pietre Custodi.", "안개 감시자가 수호물을 관리하고 있습니다. 안개 감시자를 처치하거나 빙결 덫으로 얼린 후에 감시석을 훔쳐야 합니다.", "Os Protetores Nebulosos controlam as proteções. Use uma Armadilha Congelante ou mate-os para roubar as pedras de proteção deles.", "Оберегами управляют стражи туманов. Воспользуйтесь замораживающей ловушкой или просто убейте их и заберите сторожевые камни.", "迷雾守护者管理着那些结界，击杀他们或使用冰冻陷阱困住他们，偷走他们的结界石。", "迷霧結界師控制這些結界。使用冰凍陷阱或殺死他們，以偷走結界石。", }, 
{ "Steal the Wardstone now that the Warder is taken care of.", "Stehlt den Schutzstein, da Ihr Euch bereits um den Wärter gekümmert habt.", "Roba la piedra de resguardo ahora que te has ocupado del guardián.", "Ahora que ya te encargaste del guardián, roba las piedras de resguardo.", "À présent que le gardien est hors d’état de nuire, emparez-vous de la pierre gardienne.", "Ora che il custode non costituisce più un problema, ruba la Pietra Custode.", "감시관이 관리하던 감시석을 훔쳐야 합니다.", "Roube a Pedra de Proteção agora que já deu um jeito no Guardador.", "Вы покончили со стражем и можете забрать сторожевой камень.", "守护者已经完蛋了，拿走结界石吧。", "解決結界師了，快封印結界石。", }, 
{ "More wardstones will be needed to breach the wall. Collect more wardstones from the kvaldir in the harbor.", "Mehr Schutzsteine sind vonnöten, um den Wall zu durchbrechen. Sammelt mehr Schutzsteine von den Kvaldir im Hafen.", "Se necesitarán más piedras de resguardo para abrir una brecha en el muro. Reúne más piedras de resguardo de los Kvaldir en el puerto.", "Necesiitaremos más piedras de resguardo para atravesar el muro. Recoge más de ellas de los kvaldir del puerto.", "Il va falloir davantage de pierres gardiennes pour ouvrir une brèche dans le mur. Récupérez-en d’autres auprès des kvaldirs du port.", "Servono altre Pietre Custodi per sfondare il muro. Recuperane altre dai Kvaldir presso il porto.", "수호물을 파괴하려면 감시석이 더 필요할 것 같습니다. 항구에 있는 크발디르에게서 감시석을 구해야 합니다.", "Mais pedras de proteção serão necessárias para romper a muralha. Colete mais pedras de proteção dos kvaldir no porto.", "Чтобы преодолеть барьер, потребуется больше сторожевых камней. Отберите сторожевые камни у квалдиров в порту.", "我们需要更多的结界石才能打破这堵墙。从港口的克瓦迪尔身上夺取更多的结界石。", "需要更多結界石才能突破這道牆。在港口從科瓦迪爾收集更多的結界石。", }, 
{ "Apata and Wuho are out near the wards, find them and find a way to breach the wards.", "Apata und Wuho sind draußen in der Nähe der Zauberschutze. Findet sie und einen Weg, die Zauberschutze zu durchbrechen.", "Apata y Wuho están cerca de los resguardos. Encuéntralos y halla la forma de romper los resguardos.", "Apata y Wuho están cerca de los resguardos. Encuéntralos y busca la forma de atravesar los resguardos.", "Apata et Wuho se trouvent près des protections. Rejoignez-les et trouvez un moyen de passer outre.", "Apata e Wuho sono vicini al muro. Trovali e scopri un modo per superarle.", "아파타와 우호가 수호물 근처에 있습니다. 그들을 찾고 수호물을 파괴할 방법을 알아내야 합니다.", "Apata e Wuho estão perto das proteções. Encontre-os e procurem uma forma de romper as proteções.", "Апата и Вухо уже должны быть у оберегов. Разыщите их и найдите способ преодолеть барьер.", "阿帕塔和乌霍去结界那边了，找到他们，并想办法破解结界。", "雅帕塔和伍赫在結界附近，找到他們並想辦法解除結界。", }, 
{ "Harpoons and runes in hand, the fog barrier can be breached. Use a harpoon to cross the wards.", "Mit den Harpunen und Runen zur Hand kann die Nebelbarriere durchbrochen werden. Nutzt die Harpune, um die Zauberschutze zu überwinden.", "Con los arpones y las runas se podrá romper la barrera de niebla. Usa un arpón para atravesar los resguardos.", "Puedes atravesar la barrera de niebla con arpones y runas. Usa un arpón para cruzar a través de los resguardos.", "Avec les harpons et les runes, il est possible d’ouvrir une brèche dans la barrière de brume. Servez-vous du harpon pour franchir les protections.", "Con gli arpioni e le Rune di Protezione, possiamo attraversare il muro di nebbia. Usa un arpione per superare la barriera.", "작살과 룬을 이용해 안개의 벽을 뚫을 수 있습니다. 작살을 사용하여 수호물을 통과해야 합니다.", "Com arpões e runas nas mãos, a barreira de névoa pode ser rompida. Use um arpão para cruzar as proteções.", "У вас есть и гарпуны, и руны. Туманный барьер не остановит вас. Переберитесь через обереги с помощью гарпуна.", "鱼叉和符文都到手了，你可以打破屏障了。使用鱼叉穿过结界吧。", "只要有魚叉和符文，就能解除這道迷霧屏障。使用魚叉來穿過結界。", }, 
{ "Apata wants to get the lay of the land carefully, follow her around the swamp.", "Apata will sich einen Überblick über das Gebiet verschaffen. Folgt ihr durch den Sumpf.", "Apata quiere tantear el terreno minuciosamente. Síguela por el pantano.", "Apata quiere que recorrer la tierra con cuidado. Síguela por el pantano.", "Apata tient à reconnaître les lieux. Suivez-la dans le marais.", "Apata vuole scoprire con cura i segreti di questa terra. Seguila in giro per la palude.", "아파타가 조심스럽게 주변을 조사하고자 합니다. 그녀를 따라가야 합니다.", "Apata quer fazer um reconhecimento cuidadoso do terreno. Siga-a pelo pântano.", "Апата хочет как следует разведать местность. Следуйте за ней вглубь отмели.", "阿帕塔希望能仔细勘察这片土地，跟随她走遍沼泽。", "雅帕塔想仔細勘察這一帶的地形，跟著她一同繞行沼澤。", }, 
{ "Dakarr is sending illusionary stalkers at you, defend yourself!", "Dakarr entsendet illusionäre Pirscher. Verteidigt Euch!", "Dakarr te envía acechadores ilusorios. ¡Defiéndete!", "Dakarr te envía acechadores ilusorios. ¡Defiéndete!", "Dakarr vous envoie des traqueurs illusoires, défendez-vous !", "Dakarr sta mandando Inseguitori Illusori contro di te. Difenditi!", "다카르가 당신에게 추적자 환영을 보내고 있습니다. 방어해야 합니다!", "Dakarr envia espreitadores ilusórios contra você. Defenda-se!", "Дакарр направил против вас иллюзорных ловцов. Защищайтесь!", "达喀尔派出幻影来追捕你了，保护好自己！", "達卡爾對你派出了虛幻潛獵者，做好防禦的準備！", }, 
{ "Dakarr hides in deep mists, go into them and lay traps to catch him.", "Dakarr versteckt sich in tiefen Nebeln. Begebt Euch hinein und legt Fallen aus, um ihn zu fangen.", "Dakarr se oculta en lo más profundo de la niebla. Adéntrate en ella y pon trampas para capturarlo.", "Dakarr se oculta en lo profundo de la niebla. Entra en ella y coloca trampas para atraparlo.", "Dakarr se cache dans les brumes. Sillonnez la zone et truffez-la de pièges pour le capturer.", "Dakarr si nasconde nelle fitte nebbie. Addentrati e posiziona delle trappole per catturarlo.", "다카르가 안개 깊숙이 숨어 있습니다. 안개 속으로 들어가 다카르를 잡을 덫을 설치해야 합니다.", "Dakarr se esconde nas névoas profundas. Entre nelas e coloque armadilhas para pegá-lo.", "Дакарр скрывается в густом тумане. Ступайте в туман и установите ловушку, чтобы поймать его.", "达喀尔隐入了迷雾的深处。深入迷雾中布下陷阱，抓住它。", "達卡爾躲藏在濃霧中。進入濃霧，設置陷阱捕捉他。", }, 
{ "The beast has fled to another lair of mist, trap it again and avenge Wuho.", "Die Bestie ist in ein anderes Versteck geflohen, setzt sie wieder fest und rächt Wuho.", "La bestia ha huido hacia otra guarida de niebla. Vuelve a atraparla y venga a Wuho.", "La bestia huyó hacia otra guarida de niebla. Vuelve a atraparla y venga a Wuho.", "La bête s’est réfugiée dans un autre repaire brumeux. Piégez-la à nouveau et vengez Wuho.", "La bestia è fuggita in un'altra tana di nebbia. Imprigionala di nuovo e vendica Wuho.", "야수가 또 다른 안개 낀 은신처로 달아났습니다. 덫으로 야수를 다시 잡고 우호의 복수를 해야 합니다.", "A fera fugiu para outro covil de névoa. Prenda-a de novo e vingue Wuho.", "Зверь скрылся в туманах. Поймайте его снова и отомстите за Вухо.", "那头野兽逃进了另一处迷雾巢穴，再次抓住它，为乌霍报仇。", "那隻怪物逃到霧中的另一個巢穴了，想辦法再抓到它，幫伍赫報仇。", }, 
{ "Dakarr has fled to his true lair, but is too weak to hide behind fog. Finish him in his lair.", "Dakarr ist zu seinem wahren Versteck geflohen, ist jedoch zu schwach, um sich im Nebel zu verstecken. Versetzt ihm in seinem Versteck den Todesstoß.", "Dakarr ha huido a su auténtica guarida, pero está demasiado débil para ocultarse tras la niebla. Acaba con él en su guarida.", "Dakarr huyó a su verdadera guarida, pero está muy débil como para ocultarse tras la niebla. Aniquílalo en su guarida.", "Dakarr s’est réfugié dans son vrai repaire, mais il est trop affaibli pour se cacher encore dans les brumes. Achevez-le.", "Dakarr è fuggito nella sua vera tana, ma è troppo debole per nascondersi. Finiscilo.", "다카르가 마침내 진짜 은신처로 달아났습니다. 다행히 다카르는 너무 약해져 더는 안개 속에 숨을 수 없습니다. 은신처에 있는 다카르를 처치해야 합니다.", "Dakarr fugiu para seu verdadeiro covil, mas está fraco demais para se esconder detrás da névoa. Acabe com ele no covil.", "Дакарр ушел в свое настоящее логово, но теперь он слишком слаб, чтобы прятаться в тумане. Прикончите его.", "达喀尔逃进了它真正的巢穴，这次它已经虚弱得无法躲进迷雾里了。在它的巢穴里了结它。", "達卡爾逃回他真正的巢穴了，但是已經太虛弱無法再用濃霧掩藏行跡。到他的巢穴解決他。", }, 
{ "The foul beast is dead and the path to the Spear is open. Take up Talonclaw.", "Die widerliche Bestie ist tot und der Pfad zum Speer steht offen. Nehmt Fangklaue an Euch.", "Esa bestia inmunda está muerta y el camino hacia la lanza está despejado. Coge la Garra Feroz.", "La horrible bestia está muerta y el camino a la lanza está despejado. Recoge a Garfa Corva.", "La bête féroce est morte et la lance est désormais accessible. Emparez-vous de Griffe-Serre.", "La vile bestia è morta e la via verso la Lancia è finalmente a portata di mano. Vai a prendere Grinfiartiglio.", "흉악한 야수가 죽었으니 이제 칼날갈퀴는 당신의 것입니다. 창을 획득하십시오.", "A fera imunda está morta e o caminho até a Lança está aberto. Tome Garranha.", "Гнусное чудовище повержено, и копье теперь ваше. Заберите Хищный Коготь.", "那头凶残的野兽终于死了，没有人能阻止你获得雄鹰之爪了。把它拿起来吧。", "凶猛的野獸已死，通往神矛的路暢通無阻。拿起猛禽之爪。", }, 
},
["686"] = {
{ "Defeat the bosses of the Shadowmoon Burial Grounds", "Bezwingt die Bosse der Schattenmondgrabstätte.", "Derrota a los jefes del Cementerio de Sombraluna.", "Derrota a los jefes de Cementerios de Sombraluna.", "Terrassez les boss des Terres sacrées d’Ombrelune.", "Sconfiggi i boss della Necropoli dei Torvaluna.", "어둠달 지하묘지 우두머리들을 처치해야 합니다.", "Derrote os chefes do Sepulcrário da Lua Negra", "Убейте боссов Некрополя Призрачной Луны", "击败影月墓地的首领", "擊敗影月墓地的首領", }, 
},
["786"] = {
{ "Travel to the Broken Shore.", "Reist zur Verheerten Küste.", "Ve a la Costa Abrupta.", "Viaja a la Costa Quebrada.", "Rendez-vous au rivage Brisé.", "Raggiungi la Riva Dispersa.", "부서진 해변으로 가야 합니다.", "Vá até a Costa Partida.", "Отправьтесь на Расколотый берег.", "前往破碎海滩。", "前往破碎海岸。", }, 
{ "Destroy all demons and structures on the beach.", "Vernichtet alle Dämonen und Strukturen am Strand.", "Acaba con todos los demonios y las estructuras de la playa.", "Destruye a todos los demonios y las estructuras de la playa.", "Anéantissez tous les démons et les bâtiments sur la plage.", "Elimina tutti i demoni e distruggi le strutture sulla spiaggia.", "해변에 있는 모든 악마와 건물을 파괴해야 합니다.", "Destrua todos os demônios e estruturas na praia.", "Уничтожьте всех демонов и все строения на побережье.", "消灭海滩上所有的恶魔，毁掉所有建筑。", "摧毀海灘上的所有惡魔與建築。", }, 
{ "Slay Dread Commander Arganoth.", "Tötet Schreckenskommandant Arganoth.", "Mata al comandante aterrador Arganoth.", "Asesina al comandante aterrador Arganoth.", "Éliminez le commandant de l’effroi Arganoth.", "Uccidi il Comandante del Terrore Arganoth.", "공포의 사령관 아르가노스를 처치해야 합니다.", "Mate o Comandante Medonho Arganoth.", "Убейте командира повелителей ужаса Арганота.", "消灭恐怖指挥官阿加诺斯。", "殺死驚懼指揮官亞岡諾斯。", }, 
{ "Locate King Varian Wrynn.", "Sucht nach König Varian Wrynn.", "Encuentra al rey Varian Wrynn.", "Localiza al Rey Varian Wrynn.", "Trouvez le roi Varian Wrynn.", "Trova Re Varian Wrynn.", "국왕 바리안 린을 찾아야 합니다.", "Localize o Rei Varian Wrynn.", "Отыщите короля Вариана Ринна.", "找到瓦里安·乌瑞恩国王。", "找到瓦里安·烏瑞恩國王。", }, 
{ "Destroy the demon portal to stop reinforcements.", "Vernichtet das Dämonenportal, um die Verstärkungstruppen aufzuhalten.", "Destruye el portal de demonios para detener a los refuerzos.", "Destruye el portal de demonios para detener a los refuerzos.", "Détruisez le portail démoniaque pour empêcher l’arrivée des renforts.", "Distruggi il portale dei demoni per impedire l'arrivo di rinforzi.", "악마의 차원문을 파괴하여 지원군이 오지 못하게 해야 합니다.", "Destrua o portal demoníaco para deter os reforços.", "Уничтожьте портал демонов, чтобы остановить поток подкреплений.", "摧毁恶魔之门以阻挡援军。", "摧毀惡魔傳送門以阻擋援軍。", }, 
{ "Assault the demon city.", "Greift die Dämonenstadt an.", "Asalta la ciudad demoníaca.", "Ataca la ciudad de los demonios.", "Attaquez la cité démoniaque.", "Assalta la città dei demoni.", "악마의 도시를 공격해야 합니다.", "Ataque a cidade demoníaca.", "Нападите на город демонов.", "突袭恶魔城市", "突襲惡魔之城。", }, 
{ "Get to Tirion.", "Stoßt zu Tirion.", "Llega hasta Tirion.", "Llega hasta Tirion.", "Rejoignez Tirion.", "Raggiungi Tirion.", "티리온 폴드링에게 가야 합니다.", "Fale com Tirion.", "Доберитесь до Тириона.", "赶到提里奥身边。", "去找提里奧。", }, 
{ "Kill Krosus.", "Tötet Krosus.", "Mata a Krosus.", "Mata a Krosus.", "Tuez Krosus.", "Uccidi Krosus.", "크로서스를 처치해야 합니다.", "Mate Krosus.", "Убейте Кроса.", "消灭克洛苏斯。", "殺死克羅索斯。", }, 
{ "Stop Gul'dan from summoning the Legion.", "Haltet Gul'dan davon ab, die Legion zu beschwören.", "Evita que Gul'dan invoque a la Legión.", "Detén a Gul'dan para que no invoque a la Legión.", "Empêchez Gul’dan d’invoquer la Légion.", "Impedisci a Gul'dan di evocare la Legione.", "굴단이 군단을 소환하지 못하게 막아야 합니다.", "Impeça que Gul'dan evoque a Legião.", "Помешайте Гул'дану призвать еще больше демонов Легиона.", "阻止古尔丹召唤军团。", "阻止古爾丹召喚燃燒軍團。", }, 
},
["1095"] = {
{ "Learn about being a Monk.", "Erfahrt etwas über das Leben als Mönch.", "Infórmate sobre ser un monje.", "Averigua más sobre ser un monje.", "Apprenez-en davantage sur les moines.", "Impara il significato di essere un Monaco.", "수도사에 대해 배워야 합니다.", "Aprenda sobre os Monges.", "Узнайте, что значит быть монахом.", "学习如何成为一名武僧。", "學習如何當一名武僧。", }, 
{ "Learn about Tiger Palm.", "Erfahrt mehr über 'Tigerklaue'.", "Infórmate sobre Palma del tigre.", "Averigua más sobre Palma del tigre.", "Apprenez-en davantage sur Paume du tigre.", "Impara come usare Palmo della Tigre.", "범의 장풍에 대해 배워야 합니다.", "Aprenda sobre Palma do Tigre.", "Научитесь применять \"Лапу тигра\".", "学习猛虎掌。", "學習如何使用虎掌。", }, 
{ "Learn about Rising Sun Kick.", "Erfahrt mehr über den 'Tritt der aufgehenden Sonne'.", "Infórmate sobre Patada del sol naciente.", "Averigua más sobre Patada del sol naciente.", "Apprenez-en davantage sur Coup de pied du soleil levant.", "Impara come usare Calcio del Sole Nascente.", "해오름차기에 대해 배워야 합니다.", "Aprenda sobre Chute do Sol Nascente.", "Научитесь применять \"Удар восходящего солнца\".", "学习旭日东升踢。", "學習如何使用翔陽腳。", }, 
{ "Learn about Blackout Kick.", "Erfahrt mehr über 'Blackout-Tritt'.", "Infórmate sobre Patada oscura.", "Averigua más sobre Patada oscura.", "Apprenez-en davantage sur Frappe du voile noir.", "Impara come usare Calcio dell'Oscuramento.", "후려차기에 대해 배워야 합니다.", "Aprender sobre Chute Blecaute.", "Научитесь применять \"Нокаутирующий удар\".", "学习幻灭踢。", "學習如何使用滅寂腿。", }, 
{ "Learn about Fists of Fury.", "Erfahrt mehr über 'Furorfäuste'.", "Infórmate sobre Puños de furia.", "Averigua más sobre Puños de furia.", "Apprenez-en davantage sur Poings de fureur.", "Impara come usare Pugni della Furia.", "분노의 주먹에 대해 배워야 합니다.", "Aprenda sobre Punhos da Fúria.", "Научитесь применять \"Неистовые кулаки\".", "学习怒雷破。", "學習如何使用狂拳連打。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Roll.", "Erfahrt mehr über 'Rollen'.", "Infórmate sobre Rodar.", "Averigua más sobre Rodar.", "Apprenez-en davantage sur Roulade.", "Impara come usare Capriola.", "구르기에 대해 배워야 합니다.", "Aprenda sobre Rolamento.", "Научитесь применять \"Кувырок\".", "学习滚地翻。", "學習如何使用迅空翻。", }, 
{ "Learn about Effuse.", "Erfahrt mehr über 'Überschwang'.", "Infórmate sobre Efundir.", "Averigua más sobre Efundir.", "Apprenez-en davantage sur Effusion.", "Impara come usare Emanazione.", "발산에 대해 배워야 합니다.", "Aprenda sobre Efusão.", "Научитесь применять \"Излияние\".", "学习真气贯通。", "學習如何使用流洩。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["967"] = {
{ "Explore the sprawling depths of The Arcway.", "Erforscht die verzweigten Tiefen des Arkus.", "Explora las inmensas profundidades de La Arquería.", "Explora las extensivas profundidades del Arco.", "Explorez les vastes profondeurs de l’Arcavia.", "Esplora le profondità sconosciute dell'Arcavia.", "제멋대로 뻗어 나가는 비전로를 탐험해야 합니다.", "Explore a as intrincadas profundezas do Arcâneo.", "Исследуйте глубины катакомб Сурамара.", "探索魔法回廊延展的深处。", "探索錯綜複雜的幽暗地道。", }, 
{ "Explore the sprawling depths of The Arcway.", "Erforscht die verzweigten Tiefen des Arkus.", "Explora las inmensas profundidades de La Arquería.", "Explora las extensas profundidades del Arco.", "Explorez les vastes profondeurs de l’Arcavia.", "Esplora le profondità sconosciute dell'Arcavia.", "제멋대로 뻗어 나가는 비전로를 탐험해야 합니다.", "Explore a as intrincadas profundezas do Arcâneo.", "Исследуйте глубины катакомб Сурамара.", "探索魔法回廊延展的深处。", "探索錯綜複雜的幽暗地道。", }, 
},
["200"] = {
{ "Avoid the guards and enter the Sanctuary of Shadows.", "Meidet die Wachen und betretet die Zuflucht der Schatten.", "Evita a los guardias y entra en el Santuario de las Sombras.", "Evita a los guardias y entra en el Santuario de las Sombras.", "Évitez les gardes et entrez dans le sanctuaire des Ombres.", "Evita le guardie ed entra nel Santuario delle Ombre.", "경비병을 피해 어둠의 성역에 들어가야 합니다.", "Evite os guardas e entre no Santuário das Sombras.", "Проскользните мимо стражи и проникните в Святилище Теней.", "躲开守卫，进入暗影圣殿。", "閃避守衛進入暗影聖堂。", }, 
{ "Find the Council of the Black Harvest's trail.", "Findet die Spur des Rats der Schwarzen Ernte.", "Encuentra el rastro del Consejo de la Cosecha Oscura.", "Encuentra el rastro del Consejo de la Cosecha Oscura.", "Trouvez la piste du Conseil de la Moisson noire.", "Trova le tracce del Concilio della Mietitura Oscura.", "암흑의 수확 의회의 흔적을 찾아야 합니다.", "Encontre a trilha do Conselho da Colheita Negra.", "Найдите след Совета Мрачной Жатвы.", "找到黑暗收割议会的踪迹。", "尋找黑穫議會的蹤跡。", }, 
{ "Walk with Akama to the Shrine of Lost Souls.", "Begleitet Akama zum Schrein der Verlorenen Seelen.", "Anda con Akama hasta el Santuario de las Almas Perdidas.", "Anda con Akama hasta el Santuario de las Almas Perdidas.", "Marchez avec Akama jusqu’au sanctuaire des Âmes perdues.", "Cammina con Akama fino al Santuario delle Anime Perdute.", "아카마와 함께 길 잃은 영혼의 제단으로 가야 합니다.", "Caminhe com Akama até o Santuário das Almas Perdidas.", "Следуйте за Акамой в Святилище Потерянных Душ.", "与阿卡玛一同前往失落灵魂神殿。", "與阿卡瑪一起前往失落靈魂神殿。", }, 
{ "Investigate the Shrine of Lost Souls.", "Untersucht den Schrein der Verlorenen Seelen.", "Investiga el Santuario de las Almas Perdidas.", "Investiga el Santuario de las Almas Perdidas.", "Examinez le sanctuaire des Âmes perdues.", "Indaga nel Santuario delle Anime Perdute.", "길 잃은 영혼의 제단을 조사해야 합니다.", "Investigue o Santuário das Almas Perdidas.", "Осмотрите Святилище Потерянных Душ.", "调查失落灵魂神殿。", "調查失落靈魂神殿。", }, 
{ "Claim the soul crystal left behind by the Council of the Black Harvest.", "Erlangt den Seelenkristall, der vom Rat der Schwarzen Ernte zurückgelassen wurde.", "Reclama el cristal de alma que ha abandonado el Consejo de la Cosecha Oscura.", "Reclama el cristal de alma que ha abandonado el Consejo de la Cosecha Oscura.", "Récupérez le cristal d’âme abandonné par le Conseil de la Moisson noire.", "Recupera il Cristallo d'Anima lasciato dal Concilio della Mietitura Oscura.", "암흑의 수확 의회가 남긴 영혼의 수정을 확보해야 합니다.", "Tome o cristal da alma deixado pelo Conselho da Colheita Negra.", "Заберите кристалл души, брошенный советом Мрачной Жатвы.", "夺取黑暗收割议会留下的灵魂水晶。", "取得黑穫議會留下的靈魂水晶。", }, 
{ "Fight off the demons unleashed by the Reliquary and return to Akama in the Halls of Anguish.", "Wehrt die Dämonen ab, die vom Reliquiar entfesselt wurden, und kehrt zu Akama in den Hallen der Pein zurück.", "Lucha contra los demonios que ha liberado El Relicario y vuelve con Akama a las Salas de Angustia.", "Lucha contra los demonios que ha liberado El Relicario y vuelve con Akama a las Salas de Angustia.", "Repoussez les démons libérés par le Reliquaire et retournez voir Akama dans les salles de l’Angoisse.", "Combatti i demoni rilasciati dalla Reliquia e torna da Akama nelle Sale del Tormento.", "성물함에서 해방된 악마와 싸운 뒤 고뇌의 전당에 있는 아카마에게 가야 합니다.", "Derrote os demônios soltos pelo Relicário e fale novamente com Akama nos Salões da Angústia.", "Отбейте атаку демонов, выпущенных Реликварием, и вернитесь к Акаме в Залы Страданий.", "击退灵魂之匣施放出的恶魔并返回苦痛大厅找阿卡玛。", "擊退聖匣所釋放的惡魔，接著回去苦痛大廳找阿卡瑪。", }, 
{ "Grab as much treasure as you can before time runs out.", "Schnappt Euch so viele Schätze, wie Ihr nur könnt, bevor die Zeit abläuft.", "Hazte con todos los tesoros que puedas antes de que el tiempo se acabe.", "Hazte con todos los tesoros que puedas antes de que el tiempo se acabe.", "Ramassez autant de butin que vous pouvez avant que le temps ne soit écoulé.", "Recupera il maggior numero di tesori prima dello scadere del tempo.", "제한된 시간 내에 보물을 최대한 많이 챙겨야 합니다.", "Pegue todos os tesouros que puder antes que o tempo se esgote.", "Соберите как можно больше сокровищ, пока не истекло время.", "在时间用完前尽可能多的夺取宝藏。", "在時間結束前盡可能搜括寶物。", }, 
{ "Take the Empowered Soulcore to the Temple Summit.", "Bringt den verstärkten Seelenkern zur Tempelspitze.", "Lleva el núcleo de alma potenciado a la cima del templo.", "Lleva el núcleo de alma potenciado a la cima del templo.", "Apportez le noyau d’âme investi au sommet du temple.", "Porta il Nucleo d'Anima Potenziato alla Sommità del Tempio.", "마력이 깃든 영혼핵을 사원 정상으로 가져가야 합니다.", "Leve o Âmago das Almas Potencializado ao Ápice do Templo.", "Отнесите заряженную сущность души в Черный Храм.", "获得充能的灵魂之核并前往神殿之巅。", "帶著強能靈魂之核前往神廟頂層。", }, 
{ "Place the Empowered Soulcore in the Demonic Soulwell, and defeat Kanrethad.", "Legt den verstärkten Seelenkern in den dämonischen Seelenbrunnen und besiegt Kanrethad.", "Coloca el núcleo de alma potenciado en el pozo de alma demoníaca y derrota a Kanrethad.", "Coloca el núcleo de alma potenciado en el pozo de alma demoníaca y derrota a Kanrethad.", "Placez le noyau d’âme investi dans le puits des âmes démoniaque et terrassez Kanrethad.", "Piazza il Nucleo d'Anima Potenziato nel Pozzo dell'Anima Demoniaco e sconfiggi Kanrethad.", "마력이 깃든 영혼핵을 악마의 영혼샘에 놓은 뒤 칸레타드를 처치해야 합니다.", "Coloque o Núcleo Anímico Potencializado no Poço das Almas Demoníaco e derrote Kanrethad.", "Поместите заряженную сущность души в демонический источник душ и победите Канретада.", "将充能的灵魂之核放入恶魔灵魂井并击败坎雷萨德。", "把強能靈魂之核放在惡魔靈魂井中，並擊敗坎瑞薩德。", }, 
},
["1018"] = {
{ "Travel to the Broken Shore. (A)", "", "", "Viaja a la Costa Quebrada. (A)", "", "Raggiungi la Riva Dispersa (Alleanza).", "부서진 해변으로 가야 합니다. (A)", "Vá à Costa Partida. (A)", "", "前往破碎海滩。", "前往破碎海岸。(聯盟)", }, 
},
["957"] = {
{ "Defeat the Iceborn Conjurer.", "Bezwingt die eisige Beschwörerin.", "Derrota a la conjuradora Hielonato.", "Derrota al conjurador hielonato.", "Terrassez l’adjuratrice née-de-glace.", "Sconfiggi l'Evocatrice della Genia Glaciale.", "얼음살이 창조술사를 처치해야 합니다.", "Derrote Conjurador Nascido em Gelo.", "Победите ледорожденную чародейку.", "击败冰魂咒术师。", "擊敗冰裔咒術師。", }, 
{ "The servants of the Lich King have conjured walls of ice to block your path. Destroy them.", "Die Diener des Lichkönigs haben Eiswälle beschworen, um Euren Weg zu blockieren. Zerstört sie.", "Los sirvientes del Rey Exánime han invocado muros de hielo para bloquearte el paso. Destrúyelos.", "Los siervos del Rey Exánime invocaron muros de hielo para bloquearte el paso. Destrúyelos.", "Les serviteurs du roi-liche ont invoqué des murs de glace pour vous barrer la route. Détruisez-les.", "I servitori del Re dei Lich hanno creato mura di ghiaccio per bloccarti il passaggio. Distruggile.", "리치 왕의 하수인이 얼음의 벽을 세워 길을 막았습니다. 벽을 파괴해야 합니다.", "Os servos do Lich Rei conjuraram muralhas de gelo para bloquear seu caminho. Destrua-os.", "Слуги Короля-лича воздвигли ледяные стены, чтобы преградить вам путь. Уничтожьте их.", "巫妖王的奴仆们召唤了冰墙拦住你的去路。摧毁它们。", "巫妖王的手下召喚出冰牆阻擋你的去路。破壞它們。", }, 
{ "Survive the assault of the burning dead.", "Überlebt den Angriff der brennenden Toten.", "Sobrevive al ataque de los muertos ardientes.", "Sobrevive al ataque de los muertos ardientes.", "Survivez à l’assaut des défuntes créatures ardentes.", "Sopravvivi all'assalto dei morti infuocati.", "불타는 망자의 공격에서 살아남아야 합니다.", "Sobreviva ao ataque dos mortos ardentes.", "Переживите атаку горящих мертвецов.", "抵挡灼热亡者的攻势", "撐過燃燒的不死怪物的攻擊。", }, 
{ "Slay Lyandra Sunstrider.", "Tötet Lyandra Sonnenwanderer.", "Mata a Lyandra Caminante del Sol.", "Mata a Lyandra Caminante del Sol", "Tuez Lyandra Haut-Soleil.", "Uccidi Lyandra Solealto.", "리안드라 선스트라이더를 처치해야 합니다.", "Mate Lyandra Andassol.", "Убейте Лиандру Солнечную Скиталицу.", "消灭莉安达·逐日者。", "殺死黎安德菈‧逐日者。", }, 
{ "Felo'melorn is yours. Take it.", "Felo'melorn ist Euer. Nehmt ihn.", "Felo'melorn es tuya. Cógela.", "Felo'melorn es tuya. Tómala.", "Felo’melorn est à vous. Prenez-la.", "Felo'melorn è tua. Prendila.", "이제 펠로멜로른은 당신의 것입니다. 검을 획득하십시오.", "Felo'melorn é sua. Pegue-a.", "Теперь Фело'мелорн ваш. Заберите его.", "烈焰之击是你的了。拿走吧。", "費羅米隆是你的了。拿起它。", }, 
},
["723"] = {
{ "Confront Commander Gar.", "Konfrontiert Kommandant Gar.", "Enfréntate al comandante Gar.", "Enfréntate al comandante Gar.", "Affrontez le commandant Gar.", "Affronta il Comandante Gar.", "사령관 가르와 대면해야 합니다.", "Confronte o Comandante Gar.", "Бросьте вызов командиру Гару.", "对抗指挥官加尔。", "挑戰指揮官加爾。", }, 
{ "Use the artifact to eliminate your enemies.", "Verwendet das Artefakt, um Eure Gegner zu besiegen.", "Usa el artefacto para eliminar a tus enemigos.", "Usa el artefacto para eliminar a tus enemigos.", "Utilisez l’artéfact pour éliminer vos ennemis.", "Usa il manufatto per eliminare i nemici.", "유물을 사용하여 적을 처치해야 합니다.", "Use o Artefato para eliminar seus inimigos.", "Устраните врагов с помощью артефакта.", "使用神器消灭你的敌人。", "使用神器的力量消滅敵人。", }, 
{ "Defeat the incoming enemies using the power of the artifact.", "Bezwingt die anrückenden Feinde mit der Macht des Artefakts.", "Derrota a los enemigos que se aproximen con el poder del artefacto.", "Derrota a los enemigos que llegan usando el poder del artefacto.", "Terrassez les attaquants en approche à l’aide de l’artéfact.", "Sconfiggi i nemici in arrivo usando il potere del manufatto.", "다가오는 적을 유물의 힘을 이용해 물리쳐야 합니다.", "Derrote os inimigos que estão vindo usando o poder do artefato.", "Победите наступающих противников с помощью силы артефакта.", "使用神器力量击败来犯的敌人。", "使用神器的力量消滅來襲的敵人。", }, 
{ "Defeat Goc.", "Bezwingt Goc.", "Derrota a Goc.", "Derrota a Goc.", "Triomphez de Goc.", "Sconfiggi Goc.", "고크를 처치해야 합니다.", "Derrote Goc", "Убейте Гока.", "击败苟克。", "擊敗苟克。", }, 
{ "Defeat Commander Gar.", "Bezwingt Kommandant Gar.", "Derrota al comandante Gar.", "Derrota al comandante Gar.", "Terrassez le commandant Gar.", "Sconfiggi il Comandante Gar.", "사령관 가르를 처치해야 합니다.", "Derrote o Comandante Gar", "Убейте командира Гара.", "击败指挥官加尔。", "擊敗指揮官加爾。", }, 
},
["540"] = {
{ "Defeat the bosses within the Temple of the Jade Serpent.", "Besiegt die Bosse im Tempel der Jadeschlange.", "Derrota a los jefes del Templo del Dragón de Jade.", "Derrota a los jefes en El Templo del Dragón de Jade.", "Terrassez les boss du temple du Serpent de jade.", "Sconfiggi i boss del Tempio della Serpe di Giada.", "옥룡사 우두머리들을 처치해야 합니다.", "Derrote os chefes no Templo da Serpente de Jade.", "Победите боссов в храме Нефритовой Змеи.", "击败青龙寺的首领。", "擊敗玉蛟寺的首領。", }, 
},
["933"] = {
{ "A strange group of vrykul are here battling demons. They don't seem hostile. Approach them and learn their purpose.", "Eine seltsame Gruppe von Vrykul kämpft hier gegen Dämonen. Sie scheinen Euch nicht feindlich gesinnt zu sein. Nähert Euch ihnen und bringt ihr Ziel in Erfahrung.", "Un extraño grupo de vrykuls está combatiendo a los demonios. No parecen hostiles. Acércate y averigua qué pretenden.", "Hay un extraño grupo de vrykul luchando contra los demonios. No parecen hostiles. Acércate a ellos y averigua su propósito.", "Un groupe étrange de Vrykuls affronte les démons. Ils n’ont pas l’air hostiles. Allez leur parler et tâchez de découvrir leur but.", "Uno strano gruppo di Vrykul sta combattendo contro i demoni. Non sembrano essere ostili. Prova ad avvicinarti a loro per scoprire le loro intenzioni.", "이상한 브리쿨 무리가 이곳에서 악마와 싸우고 있습니다. 그들에게 접근해 목적을 알아내야 합니다.", "Um estranho grupo de vraikalen combate os demônios. Eles não parecem ser hostis. Aproxime-se e descubra suas intenções.", "С демонами сражается необычная группа врайкулов. Враждебными они не выглядят. Подойдите к ним и узнайте, какова их цель.", "有一群奇怪的维库人再次与恶魔作战。他们看起来并非敌人。接近他们，弄清楚他们的意图。", "一群奇怪的維酷人在和惡魔戰鬥。他們看來沒有敵意。接近他們，了解他們的來意。", }, 
{ "Another group of demons is attacking, aid the warband in crushing these foes.", "Eine weitere Gruppe Dämonen greift an. Helft dem Kriegstrupp dabei, diese Gegner zu vernichten.", "Otro grupo de demonios está atacando. Ayuda a la banda guerrera a aplastar a los enemigos.", "Otro grupo de demonios está atacando. Ayuda a la banda de guerra a aplastar a estos enemigos.", "Un autre groupe de démons donne l’assaut. Aidez la troupe de guerre à écraser l’ennemi.", "Un altro gruppo di demoni sta attaccando. Aiuta i Vrykul a spazzare via i nemici.", "또 다른 악마 무리가 공격합니다. 전투부대를 지원하여 적을 섬멸해야 합니다.", "Um outro grupo de demônios ataca, ajude a destruí-los.", "Еще одна группа демонов перешла в наступление. Помогите отряду сокрушить врага.", "又一群恶魔发动了进攻，帮助这支兵团碾碎这些敌人。", "另一群惡魔開始攻擊了，協助維酷人擊敗這些敵人。", }, 
{ "A golden val'kyr named Danica has arrived to collect the souls of the worthy. Watch the ritual.", "Eine goldene Val'kyr namens Danica ist eingetroffen, um die Seelen der Würdigen mit sich zu nehmen. Beobachtet das Ritual.", "Una Val'kyr dorada llamada Danica ha llegado para reunir las almas de los dignos. Observa el ritual.", "Una val'kyr dorada llamada Danica llegó a recoger las almas de los dignos. Observa el ritual.", "Une val’kyr dorée du nom de Danica vient d’arriver pour recueillir les âmes des valeureux. Assistez au rituel.", "Una Val'kyr Dorata di nome Danica è arrivata per raccogliere le anime di chi è degno. Osserva il rituale.", "다니카라는 황금 발키르가 나타나 가치 있는 자의 영혼을 회수하려 합니다. 의식을 지켜보십시오.", "Uma val'kyr dourada chamada Danica chegou para levar as almas dos valorosos. Observe o ritual.", "Золотая валь'кира по имени Даника прилетела собирать души достойных. Понаблюдайте за ритуалом.", "一位名叫丹妮卡的金色瓦格里抵达了战场，并将英雄们的灵魂迎向英灵殿。见证这个仪式吧。", "名叫丹妮卡的黃金華爾琪降臨戰場，迎接勇士的靈魂。觀看整個過程。", }, 
{ "Demonic reinforcements approach with a large mo'arg. Defeat Bezzeredes and his allies.", "Dämonische Verstärkungstruppen nähern sich mit einem großen Mo'arg. Bezwingt Bezzeredes und seine Verbündeten.", "Los refuerzos demoníacos se acercan con un Mo'arg enorme. Derrota a Bezzeredes y a sus aliados.", "Se aproximan refuerzos demoníacos con un enorme mo'arg. Derrota a Bezzeredes y a sus aliados.", "Les renforts démoniaques approchent avec un mastodonte mo’arg. Terrassez Bezzérédès et ses alliés.", "I rinforzi demoniaci si avvicinano con un colossale Mo'arg. Sconfiggi Bezzeredes e i suoi alleati.", "거대한 모아그를 앞세운 악마 지원군이 다가오고 있습니다. 베제레데스와 그의 군대를 처치해야 합니다.", "Reforços demoníacos se aproximam com um grande mo'arg. Derrote Bezzeredes e os aliados dele.", "Приближается подкрепление демонов во главе с крупным мо'аргом. Победите Беззереда и его союзников.", "恶魔的援军过来了，其中还有一只巨大的莫尔葛。击败贝泽德斯和他的部队。", "惡魔援軍出現了，當中還有一隻巨大的莫阿格。擊敗貝茲瑞德斯和他的手下。", }, 
{ "Malgalor, Lord of Butchery has arrived to kill everyone. Stand with what remains of the warband. Kill Malgalor or die trying.", "Malgalor der Schlächterfürst ist eingetroffen, um alle zu töten. Haltet mit den Überlebenden Eures Trupps die Stellung. Bezwingt Malgalor oder sterbt bei dem Versuch.", "Malgalor, Señor de la Matanza, ha llegado para aniquilar a todo el mundo. Quédate con los guerreros restantes. Acaba con Malgalor o muere en el intento.", "Malgalor, Señor de la Carnicería, llegó a matarlos a todos. Resiste junto a lo que quede de la banda de guerra. Mata a Malgalor o muere en el intento.", "Malgalor, seigneur du carnage, vient d’arriver pour perpétrer un massacre. Battez-vous aux côtés des survivants de la troupe de guerre et tuez Malgalor au péril de votre vie.", "Malgalor il Signore del Massacro è giunto per uccidere tutti. Resisti con il resto della squadra eliminando Malgalor o muori provandoci.", "도륙의 군주 말갈로가 모두를 말살하고자 전장에 나타났습니다. 남은 병력으로 그에게 맞서야 합니다. 죽을 힘을 다해 말갈로를 처치해야 합니다.", "Malgalor, o Senhor da Carnificina, chegou para matar todo mundo. Resista junto ao que resta do bando guerreiro. Mate Malgalor, nem que tenha que morrer.", "Мясник Малгалор прибыл, чтобы лично убить всех. Вместе с остатками отряда дайте ему бой. Сразите Малгалора – или достойно умрите.", "屠戮者马加洛来了，所有人都难逃一死。与兵团中剩下的成员共同进退，与马加洛决一死战。", "屠殺之王馬爾加洛現身戰場，企圖殺光所有抵抗者。和剩下的維酷勇士並肩作戰，殺掉馬爾加洛，或是奮戰到死。", }, 
},
["1097"] = {
{ "The skull should be within Felsoul Hold. Make your way down the path and search for it.", "Der Schädel sollte sich in der Teufelsseelenbastion befinden. Kämpft Euch den Weg entlang und sucht danach.", "El cráneo debe de estar en el Bastión Alma Vil. Ábrete paso por el camino y búscalo.", "El cráneo debe estar dentro del Bastión Almavil. Entra y búscalo.", "Le crâne doit se trouver dans l’enceinte du bastion Gangrâme. Suivez le chemin et cherchez-le.", "Il teschio dovrebbe trovarsi all'interno del Forte Vilanima. Segui il sentiero e trovalo.", "해골은 지옥영혼 요새 안에 있을 겁니다. 길을 따라가며 해골을 찾아야 합니다.", "A caveira deve estar no Castelo Almavil. Desça pela trilha e procure.", "Череп должен быть где-то в оплоте Оскверненной Души. Идите дальше и попытайтесь отыскать его.", "颅骨应该在邪魂堡垒里。沿路下去找吧。", "顱骨應該就在魔魂堡。沿著這個通道往下，找到它。", }, 
{ "Defeat the Felborn Overfiend.", "Bezwingt den teufelsgeborenen Oberdämon.", "Derrota al gran maligno vilnato.", "Derrota al gran maligno vilnato.", "Terrassez le démon supérieur gangrelien.", "Sconfiggi il Signore dei Demoni Vilnato.", "지옥살이 거대마귀를 처치해야 합니다.", "Derrote o Demônio Superior Vilanesco.", "Победите порожденного Скверной архидемона.", "击败邪脉大恶魔。", "擊敗魔裔將領。", }, 
{ "Mephistroth has escaped with the skull. Find a way across his trap and chase after him!", "Mephistroth ist mitsamt dem Schädel geflohen. Findet einen Weg an seiner Falle vorbei und verfolgt ihn!", "Mephistroth ha escapado con el cráneo. ¡Encuentra el modo de superar su trampa y persíguelo!", "Mephistroth escapó con el cráneo. ¡Logra pasar por su trampa y síguelo!", "Méphistroth s’est enfui avec le crâne. Trouvez un moyen de passer son piège et lancez-vous à sa poursuite !", "Mefistroth è fuggito con il teschio. Trova un modo per superare la sua trappola e inseguilo!", "메피스트로스가 해골을 가지고 탈출했습니다. 덫을 통과하고 메피스트로스를 추격해야 합니다!", "Mephistroph escapou com a caveira. Encontre um caminho através da armadilha e vá atrás dele!", "Мефистрот сбежал вместе с Черепом. Обойдите его ловушку и отправляйтесь за ним в погоню!", "孟菲斯托斯带着颅骨逃走了。想办法绕过他的陷阱并追击他。", "梅菲斯托拿到顱骨逃走了。想辦法通過他的陷阱，追捕他！", }, 
{ "Mephistroth has sent his minions after you. Survive their assault until Lady Tyrana and Pain Mistress Nikta arrives, then kill them.", "Mephistroth hat seine Diener gegen Euch entsandt. Überlebt ihren Angriff, bis Lady Tyrana und Schmerzmeisterin Nikta eintreffen, und tötet die beiden.", "Mephistroth ha enviado a sus esbirros tras de ti. Sobrevive a su ataque hasta que lleguen lady Tyrana y la maestra del dolor Nikta, entonces mátalas.", "Mephistroth mando a sus esbirros tras de ti. Sobrevive al asalto hasta que lleguen Lady Tyranna y la Maestra del Dolor Nikta, y luego mátalas.", "Méphistroth a envoyé ses serviteurs à vos trousses. Survivez à leur assaut jusqu’à l’arrivée de dame Tyrana et de la maîtresse de la souffrance Nikta, puis tuez-les toutes les deux.", "Mefistroth ti ha inviato contro i suoi servitori. Sopravvivi al loro assalto finché Dama Tyrana e la Signora del Dolore Nikta non arriveranno, poi eliminale.", "메피스트로스의 하수인들이 몰려오고 있습니다. 적의 공세를 막아내다가 여군주 티라나와 고통의 여주인 니크타가 나타나면 모두 처치해야 합니다.", "Mephistroph mandou seus lacaios atrás de você. Sobreviva ao ataque até que Lady Tyrana e Senhora da Dor Nikta cheguem, então acabe com elas.", "Мефистрот бросил против вас своих прислужников. Продержитесь до прибытия леди Тираны и владычицы боли Никты и перебейте всех врагов.", "孟菲斯托斯派他的爪牙来对付你。抵挡他们的攻击，直到提拉娜夫人和痛苦女妖妮塔登场，然后干掉她们。", "梅菲斯托派出手下來對付你。對抗他們的攻擊，直到泰蘭娜女士和痛苦仕女妮珂塔抵達，然後殺掉她們。", }, 
{ "Mephistroth is attempting to destroy the skull! Clear the way to his ritual site and stop him!", "Mephistroth beabsichtigt, den Schädel zu zerstören! Bahnt Euch einen Weg zu seinem Ritualort und haltet ihn auf!", "¡Mephistroth intenta destruir el cráneo! ¡Despeja el camino hasta el lugar del ritual y detenlo!", "¡Mephistroth intenta destruir el cráneo! ¡Despeja el camino al lugar de su ritual y detenlo!", "Méphistroth cherche à détruire le crâne ! Frayez-vous un passage jusqu’au site du rituel et arrêtez-le !", "Mefistroth sta cercando di distruggere il teschio! Raggiungi il luogo dove sta compiendo il rituale e fermalo!", "메피스트로스가 해골을 파괴하려고 합니다! 적을 뚫고 메피스트로스의 의식 장소로 가서 막아야 합니다!", "Mephistroph quer destruir a caveira! Abra caminho até o local do ritual e o detenha!", "Мефистрот пытается уничтожить Череп! Пробейтесь к месту проведения ритуала и остановите его!", "孟菲斯托斯想要毁掉颅骨！前往他的仪式地点并阻止他！", "梅菲斯托試圖要摧毀顱骨！一路掃蕩並前往他的儀式地點，然後阻止他！", }, 
{ "Mephistroth has escaped but the skull is intact. Take it.", "Mephistroth ist geflohen, doch der Schädel ist intakt. Nehmt ihn an Euch.", "Mephistroth ha escapado, pero el cráneo está intacto. Cógelo.", "Mephistroth escapó pero el cráneo está intacto. Llévatelo.", "Méphistroth a filé, mais le crâne est intact. Prenez-le.", "Mefistroth è fuggito ma il teschio è intatto: prendilo.", "메피스트로스는 탈출했지만, 다행히 해골은 무사합니다. 해골을 획득하십시오.", "Mephistroph escapou, mas a caveira está intacta. Pegue-a.", "Мефистроту удалось скрыться, но Череп не пострадал. Заберите его.", "孟菲斯托斯逃走了，所幸颅骨并未受损。带走它。", "梅菲斯托逃走了，但是顱骨沒事。拿走它。", }, 
{ "The skull is yours! Step through its portal to depart this place.", "Der Schädel ist Euer! Tretet durch das Portal, um diesen Ort zu verlassen.", "¡El cráneo es tuyo! Atraviesa su portal para salir de este lugar.", "¡El cráneo es tuyo! Pasa por el portal para salir de aquí.", "Le crâne est à vous ! Empruntez son portail pour quitter les lieux.", "Hai recuperato il Teschio! Entra nel suo portale per abbandonare questo luogo.", "해골을 손에 넣었습니다! 차원문을 통해 이곳을 떠나야 합니다.", "O crânio é seu! Entre no portal para deixar este lugar.", "Череп ваш! Шагните в его портал, чтобы покинуть это место.", "颅骨是你的了！穿过传送门，离开这个地方。", "顱骨是你的了！進入傳送門來離開這個地方。", }, 
},
["708"] = {
{ "Investigate the overgrown Kirin Tor outpost.", "Untersucht den überwucherten Außenposten der Kirin Tor.", "Investiga la frondosa avanzada del Kirin Tor.", "Investiga el puesto de avanzada sobrecrecido del Kirin Tor.", "Explorez l’avant-poste du Kirin Tor envahi par la végétation.", "Ispeziona l'avamposto del Kirin Tor infestato dalla vegetazione.", "과성장이 벌어진 키린 토 전초기지를 조사해야 합니다.", "Investigue o posto avançado abandonado do Kirin Tor.", "Исследуйте заросшую заставу Кирин-Тора.", "调查植物丛生的肯瑞托岗哨。", "調查永茂林的祈倫托哨站。", }, 
{ "Defeat Xeri'tek", "Bezwingt Xeri'tek.", "Derrotar a Xeri'tek.", "Derrota a Xeri'tek", "Terrassez Xeri’tek.", "Sconfiggi Xeri'tek.", "제리타크를 처치해야 합니다.", "Derrote Xeri'tac", "Победите Зери'так", "击败艾里塔克", "擊敗希瑞泰克", }, 
},
["511"] = {
{ "Defeat the bosses of Ragefire Chasm.", "Besiegt die Bosse im Flammenschlund.", "Derrota a los jefes de la Sima Ígnea.", "Derrota a los jefes de Sima Ígnea.", "Terrassez les boss du gouffre de Ragefeu.", "Sconfiggi i boss del Baratro di Fiamma Furente.", "성난불길 협곡 우두머리들을 처치해야 합니다.", "Derrote os chefes das Cavernas Ígneas.", "Победите боссов в Огненной Пропасти.", "击败怒焰裂谷的首领。", "擊敗怒焰裂谷的首領。", }, 
},
["212"] = {
{ "Mount the Silver Covenant Hippogryph and fly with Ranger General Vereesa Windrunner over the island.", "Steigt auf den Hippogryphen des Silberbunds und fliegt mit Waldläufergeneralin Vereesa Windläufer über die Insel.", "Monta en el hipogrifo de El Pacto de Plata y sobrevuela la isla con la General Forestal Vereesa Brisaveloz.", "Monta en el hipogrifo de El Pacto de Plata y sobrevuela la isla con la General Forestal Vereesa Brisaveloz.", "Montez sur l’hippogriffe du Concordat argenté et survolez l’île avec le général des forestiers, Vereesa Coursevent.", "Cavalca l'Ippogrifo del Patto d'Argento e vola con il Generale dei Guardaboschi Vereesa Ventolesto sopra l'isola.", "은빛 서약단 히포그리프를 타고 순찰대 사령관 베리사 윈드러너와 함께 섬 위를 비행해야 합니다.", "Monte no Hipogrifo do Pacto de Prata e sobrevoe a ilha com a General Patrulheira Vereesa Correventos.", "Сядьте на гиппогрифа Серебряного союза и вместе с предводительницей следопытов Верисой Ветрокрылой пролетите над островом.", "骑上银色盟约角鹰兽，与游侠将军温蕾萨·风行者一起飞过岛屿。", "騎上白銀誓盟角鷹獸並與遊俠將軍凡蕾莎·風行者飛往島嶼。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["929"] = {
{ "Prove your worth and claim the Aegis of Aggramar.", "Beweist, dass Ihr würdig seid und sichert Euch die Aegis von Aggramar.", "Demuestra tu valía y hazte con la Égida de Aggramar.", "Prueba que eres digno y reclama la Égida de Aggramar.", "Prouvez votre valeur et emparez-vous de l’Égide d’Aggramar.", "Prova le tue capacità e ottieni l'Egida di Aggramar.", "자신의 가치를 증명하고 아그라마르의 아이기스를 차지하십시오.", "Prove seu valor e obtenha a Égide de Aggramar.", "Докажите, что вы достойны, и добудьте Эгиду Агграмара.", "证明你的实力，并夺取阿格拉玛之盾", "證明你的資格，並取得阿格拉瑪之盾。", }, 
},
["608"] = {
{ "Defeated the bosses of The Shattered Halls.", "Bosse der Zerschmetterten Hallen bezwungen.", "Derrota a los jefes de las Salas Arrasadas.", "Derrota a los jefes de Las Salas Arrasadas.", "Terrassez les boss des salles Brisées.", "Sconfiggi i boss delle Sale della Devastazione.", "으스러진 손의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões Despedaçados.", "Победите боссов в Разрушенных залах.", "击败破碎大厅的首领。", "擊敗破碎大廳的首領。", }, 
},
["731"] = {
{ "Kill inhabitants of rooms to extinguish runes.", "Tötet die Bewohner der Räume, um Runen zu löschen.", "Mata a los moradores de las habitaciones para extinguir runas.", "Mata a moradores de salas para extinguir las runas.", "Tuez les occupants des pièces pour éteindre les runes.", "Uccidi i nemici nelle stanze per estinguere le rune.", "방 안의 생명체들을 처치해 룬을 꺼뜨려야 합니다.", "Mate os habitantes das salas para extinguir as runas.", "Убивайте обитателей покоев, чтобы погасить руны.", "消灭房间内的人以熄灭符文。", "殺死房內的敵人以熄滅符文。", }, 
{ "Defeat the Ironmarch forces occupying the halls of the Spire.", "Besiegt die Truppen des Eisernen Marsches, die die Hallen der Schwarzfelsspitze besetzen.", "Derrota a las tropas de La Marcha de Hierro que ocupan las salas de la Cumbre.", "Derrota a las fuerzas Marcha Férrea que ocupan las cámaras de la Cumbre.", "Terrassez les troupes marchefer qui occupent les salles du Pic Rochenoire.", "Sconfiggi le forze della Marcia di Ferro che hanno occupato le sale dei Bastioni di Roccianera.", "첨탑을 장악한 강철선봉대 군대를 무찔러야 합니다.", "Derrote as tropas da Marcha de Ferro que ocupam os salões do Pináculo.", "Победите войска Железного Марша, занявшие залы пика.", "击败占据了黑石塔大厅的铁军部队。", "擊敗佔據了黑石塔上層的鋼鐵戰線部隊。", }, 
},
["49"] = {
{ "Defeat the Mantid forces sieging the Niuzao Temple.", "Bezwingt die Streitkräfte der Mantis, die den Niuzaotempel belagern.", "Derrota a las fuerzas mántides que asedian el Templo de Niuzao.", "Derrota a las fuerzas mántides que asedian el Templo de Niuzao.", "Terrassez les troupes mantides qui assiègent le temple de Niuzao.", "Sconfiggi le forze dei Mantid che stanno assediando il Tempio di Niuzao.", "니우짜오 사원을 공격하는 사마귀 병력을 처치해야 합니다.", "Derrote as forças dos mantídeos que estão cercando o Templo Niuzao.", "Победите силы богомолов, атакующие храм Нюцзао.", "击败围攻砮皂寺的螳螂妖军队。", "消滅圍攻怒兆寺的螳螂人部隊。", }, 
},
["39"] = {
{ "Defeat the corrupted Shado-Pan Leader.", "Bezwingt den verderbten Anführer der Shado-Pan.", "Derrota al líder del Shadopan corrupto.", "Derrota al líder del Shadopan corrupto.", "Terrassez le chef pandashan.", "Sconfiggi il capo corrotto degli Shandaren.", "타락한 음영파 대장을 처치해야 합니다.", "Derrote o líder Shado-pan corrompido.", "Одолейте поддавшегося скверне лидера Шадо-Пан.", "击败被腐蚀的影踪派高手。", "殺死腐化的影潘首領。", }, 
{ "Cleanse the Sha corruption from the Pool of Life.", "Läutert den Teich des Lebens von der Sha-Verderbnis.", "Limpia la corrupción sha de la Poza de vida.", "Limpia la corrupción sha de la Poza de vida.", "Purifiez le bassin de vie de la corruption du sha.", "Purifica la Pozza della Vita dalla corruzione dello Sha.", "생명의 웅덩이에서 샤의 오염을 정화해야 합니다.", "Purgue a corrupção do Sha da Fonte de Vida.", "Очистите источник жизни от скверны ша.", "为生命之池消除煞能腐蚀。", "淨化煞對生命之池的污染。", }, 
{ "Delve deeper into the crypt and search the bottom level.", "Geht tiefer in die Krypta hinein und durchsucht die untere Ebene.", "Investiga más a fondo la cripta y rastrea el nivel inferior.", "Investiga más a fondo la cripta y rastrea el nivel inferior.", "Enfoncez-vous dans les profondeurs de la crypte et fouillez le niveau inférieur.", "Addentrati nella cripta e raggiungi il livello inferiore.", "납골당 내부로 더욱 깊이 들어가 최하층을 수색해야 합니다.", "Adentre-se ainda mais na cripta e vasculhe o nível mais baixo.", "Спуститесь еще глубже и обыщите нижний уровень гробниц.", "深度挖掘地穴并搜索地穴的底层。", "深入墓穴，到底層進行搜索。", }, 
{ "Destroy the Abomination of Anger.", "Bezwingt die Monstrosität des Zorns.", "Acaba con la Abominación de ira.", "Acaba con la Abominación de ira.", "Détruisez l’abomination de colère.", "Distruggi l'Abominio della Rabbia.", "분노의 흉물을 처치해야 합니다.", "Derrote a Abominação da Ira.", "Уничтожьте Порождение Гнева.", "消灭怒煞畸体。", "消滅憤怒的憎惡獸。", }, 
{ "Complete the Bonus Objective to receive bonus Valor.", "Erfüllt das Bonusziel, um zusätzliche Tapferkeitspunkte zu erhalten.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Completa todos los objetivos de bonificación para recibir valor extra.", "Accomplissez l’objectif bonus pour recevoir des points de vaillance supplémentaires.", "Completa l'obiettivo bonus per ricevere Punti Valore aggiuntivi.", "추가 목표를 완료하면 용맹 점수를 더 얻을 수 있습니다.", "Complete o objetivo bônus para receber Bravura extra.", "Выполните дополнительную задачу, чтобы получить бонусные очки доблести.", "完成奖励目标，获得额外的勇气点数。", "完成獎勵目標以獲取額外的勇氣點數。", }, 
},
["916"] = {
{ "Defend against the Legion threat at Tarren Mill.", "Schlagt die Legionsbedrohung bei Tarrens Mühle zurück.", "Defiende Molino Tarren de la amenaza de la Legión.", "Lucha contra la amenaza de la Legión en el Molino Tarren.", "Repoussez l’assaut de la Légion à Moulin-de-Tarren.", "Neutralizza la minaccia della Legione al Mulino di Tarren.", "군단의 위협에 맞서 타렌 제분소를 방어해야 합니다.", "Defenda Serraria Tarren contra a Legião.", "Ликвидируйте угрозу Легиона для мельницы Таррен.", "在塔伦米尔抵抗燃烧军团的威胁。", "在塔倫米爾對抗燃燒軍團的威脅。", }, 
{ "Defeat the Legion Commander threatening Tarren Mill.", "Bezwingt den Legionskommandanten, der Tarrens Mühle bedroht.", "Derrota al comandante de la Legión que amenaza Molino Tarren.", "Derrota al comandante de la Legión que amenaza el Molino Tarren.", "Terrassez le commandant de la Légion qui menace Moulin-de-Tarren.", "Sconfiggi il Comandante della Legione che minaccia il Mulino di Tarren.", "타렌 제분소를 위협하는 군단 사령관을 처치해야 합니다.", "Derrote o Comandante de Legião que ameaça Serraria Tarren.", "Победите командира Легиона, угрожающего мельнице Таррен.", "击败威胁塔伦米尔的军团指挥官。", "擊敗威脅塔倫米爾的燃燒軍團指揮官。", }, 
{ "Repel the Legion's forces throughout Hillsbrad Foothills.", "Schlagt die Streitkräfte der Legion im gesamten Vorgebirge des Hügellands zurück.", "Rechaza a los ejércitos de la Legión en las Laderas de Trabalomas.", "Repele a las fuerzas de la Legión de las Laderas de Trabalomas.", "Repoussez les troupes de la Légion aux quatre coins des contreforts de Hautebrande.", "Respingi le forze della Legione sparse per le Alture di Colletorto.", "언덕마루 구릉지 전역에 있는 군단 세력을 격퇴해야 합니다.", "Rechace as forças da Legião em Contraforte de Eira dos Montes.", "Отразите вторжение сил Легиона в предгорьях Хилсбрада.", "击退希尔斯布莱德丘陵各地的燃烧军团部队。", "在希爾斯布萊德丘陵各地擊退燃燒軍團。", }, 
{ "Defeat the demon lord commanding the invasion at Tarren Mill.", "Bezwingt den Dämonenfürsten, der die Invasion von Tarrens Mühle befehligt.", "Derrota al señor demoníaco que lidera la invasión en Molino Tarren.", "Derrota al señor de los demonios que comanda la invasión en el Molino Tarren.", "Terrassez le seigneur démon à la tête de l’armée d’invasion à Moulin-de-Tarren.", "Sconfiggi il Signore dei Demoni al comando dell'invasione alle Alture di Colletorto.", "타렌 제분소 침공을 지휘하는 악마 군주를 처치해야 합니다.", "Derrote o lorde-demônio que comanda a invasão à Serraria Tarren.", "Победите повелителя демонов, командующего вторжением на мельницу Таррен.", "击败指挥入侵塔伦米尔的恶魔领主。", "在塔倫米爾擊敗指揮入侵行動的惡魔領主。", }, 
},
["551"] = {
{ "Defeat the bosses of The Vortex Pinnacle", "Besiegt die Bosse auf dem Vortexgipfel.", "Derrota a los jefes de la Cumbre del Vórtice.", "Derrota a los jefes de La Cumbre del Vórtice.", "Terrassez les boss de la cime du Vortex.", "Sconfiggi i boss del Pinnacolo del Vortice.", "소용돌이 누각 우두머리들을 처치해야 합니다.", "Derrote os chefes do Pináculo do Vórtice.", "Победите боссов на Вершине Смерча", "击败旋云之巅的首领", "擊敗漩渦尖塔的首領", }, 
},
["1073"] = {
{ "Learn about being a Paladin.", "Erfahrt etwas über das Leben als Paladin.", "Infórmate sobre ser un paladín.", "Averigua más sobre ser un paladín.", "Apprenez-en davantage sur les paladins.", "Impara il significato di essere un Paladino.", "성기사에 대해 배워야 합니다.", "Aprenda sobre os Paladinos.", "Узнайте, что значит быть паладином.", "学习如何成为一名圣骑士。", "學習如何當一名聖騎士。", }, 
{ "Learn how to use Judgment.", "Erfahrt mehr über 'Richturteil'.", "Aprende a usar Sentencia.", "Te enseña a usar Sentencia.", "Apprenez à utiliser Jugement.", "Impara come usare Giudizio.", "심판 사용법을 배워야 합니다.", "Aprenda a usar Julgamento.", "Научитесь применять \"Правосудие\".", "学习如何使用审判。", "學習如何使用審判。", }, 
{ "Learn how to use Blade of Justice.", "Erfahrt mehr über 'Klinge der Gerechtigkeit'.", "Aprende a usar Hoja de justicia.", "Te enseña a usar Cuchilla de justicia.", "Apprenez à utiliser Lame de Justice.", "Impara come usare Lama della Giustizia.", "심판의 칼날을 어떻게 사용하는지 배워야 합니다.", "Aprender a usar Lâmina da Justiça.", "Научитесь применять \"Клинок Справедливости\".", "学习如何使用公正之剑。", "學習如何使用正義之刃。", }, 
{ "Learn how to use Crusader Strike.", "Erfahrt mehr über 'Kreuzfahrerstoß'.", "Aprende a usar Golpe de cruzado.", "Te enseña a usar Golpe de cruzado.", "Apprenez à utiliser Frappe du croisé.", "Impara come usare Assalto del Crociato.", "성전사의 일격 사용법을 배워야 합니다.", "Aprenda a usar Golpe do Cruzado.", "Научитесь применять \"Удар воина Света\".", "学习使用十字军打击。", "學習如何使用十字軍聖擊。", }, 
{ "Learn how to use Templar's Verdict.", "Erfahrt mehr über 'Urteil des Templers'.", "Aprende a usar Veredicto del templario.", "Te enseña a usar Veredicto del templario.", "Apprenez à utiliser Verdict du templier.", "Impara come usare Verdetto dei Templari.", "기사단의 선고 사용법을 배워야 합니다.", "Aprenda a usar Veredito do Templário.", "Научитесь применять \"Вердикт храмовника\".", "学习如何使用圣殿骑士的裁决。", "學習如何使用聖殿騎士之裁決。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn how to use Divine Storm.", "Erfahrt mehr über 'Göttlicher Sturm'.", "Aprende a usar Tormenta divina.", "Te enseña a usar Tormenta divina.", "Apprenez à utiliser Tempête divine.", "Impara come usare Tempesta Divina.", "천상의 폭풍을 사용하는 법을 배워야 합니다.", "Aprenda a usar Tempestade Divina.", "Научитесь применять \"Божественную бурю\".", "学习使用神圣风暴。", "學習如何使用神性風暴。", }, 
{ "Learn how to use Divine Shield.", "Erfahrt mehr über 'Gottesschild'.", "Aprende a usar Escudo divino.", "Te enseña a usar Escudo divino.", "Apprenez à utiliser Bouclier divin.", "Impara come usare Scudo Divino.", "천상의 보호막 사용법을 배워야 합니다.", "Aprenda a usar Escudo Divino.", "Научитесь применять \"Божественный щит\".", "学习如何使用圣盾术。", "學習如何使用聖盾術。", }, 
{ "Learn how to use Flash of Light.", "Erfahrt mehr über 'Lichtblitz'.", "Aprende a usar Destello de Luz.", "Te enseña a usar Destello de Luz.", "Apprenez à utiliser Éclair lumineux.", "Impara come usare Lampo di Luce.", "빛의 섬광 사용법을 배워야 합니다.", "Aprenda a usar Clarão de Luz.", "Научитесь применять \"Вспышку Света\".", "学习如何使用圣光闪现。", "學習如何使用聖光閃現。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "You're ready for the Assault!  Join up and bring justice to the Legion.", "Ihr seid bereit für den Sturmangriff! Sammelt Euch und lasst der Legion Gerechtigkeit widerfahren.", "¡Todo listo para el asalto! Únete y ajusticia a la Legión.", "¡Estás listo para el asalto! Únete y ajusticia a la Legión.", "Vous avez tout ce qu’il faut pour l’assaut ! Rejoignez nos armées pour châtier la Légion.", "È arrivato il momento dell'assalto! Vai e fai piovere giustizia sulla Legione!", "공격을 준비해야 합니다! 즉시 합류하여 군단에 정의의 심판을 내려야 합니다.", "Tudo pronto! Entre no combate e mostre à Legião a face da justiça.", "Вы готовы к нападению! Пора показать Легиону, кто здесь хозяин.", "你准备好开始突袭了！加入战斗，伸张正义，击败燃烧军团。", "你已經為這場突襲做好準備了！加入戰鬥，讓燃燒軍團得到制裁。", }, 
},
["538"] = {
{ "Defeat the bosses of Stormstout Brewery.", "Besiegt die Bosse in der Brauerei Sturmbräu.", "Derrota a los jefes de la Cervecería del Trueno.", "Derrota a los jefes de la Cervecería del Trueno.", "Terrassez les boss de la brasserie Brune d’Orage.", "Sconfiggi i boss del Birrificio Triplo Malto.", "스톰스타우트 양조장 우두머리들을 처치해야 합니다.", "Derrote os chefes da Cervejaria Malte do Trovão.", "Победите боссов в хмелеварне Буйных Портеров.", "击败风暴烈酒酿造厂的首领。", "擊敗風暴烈酒酒坊的首領。", }, 
},
["209"] = {
{ "Acquire the Heavy Explosives.", "Beschafft den schweren Sprengstoff.", "Hazte con los explosivos pesados.", "Consigue los explosivos pesados.", "Obtenez les explosifs lourds.", "Recupera gli Esplosivi ad Alto Potenziale.", "거대 폭탄을 획득해야 합니다.", "Obtenha os Explosivos Pesados.", "Найдите мощную взрывчатку.", "找到重磅炸药。", "尋找強力炸藥。", }, 
{ "Speak to Elsia at the city wall.", "Sprecht an der Stadtmauer mit Elsia.", "Habla con Elsia en la muralla de la ciudad.", "Habla con Elsia en la muralla de la ciudad.", "Parlez à Elsia au mur de la ville.", "Parla con Elsia alle mura della cittadella.", "도시 성벽에 있는 정찰대장 엘시아와 대화해야 합니다.", "Fale com Elsia na muralha da cidade.", "Поговорите с Эльсией у городской стены.", "去城墙边和艾尔希娅交谈。", "跟在城牆外的艾爾西雅交談。", }, 
{ "Light the fuse on the Heavy Explosives.", "Entzündet die Zündschnur des schweren Sprengstoffs.", "Enciende la mecha de los explosivos pesados.", "Enciende la mecha de los explosivos pesados.", "Allumez la mèche des explosifs lourds.", "Accendi la miccia degli Esplosivi ad Alto Potenziale.", "거대 폭탄의 도화선에 불을 붙여야 합니다.", "Acenda o pavio dos Explosivos Pesados.", "Подожгите запал мощной взрывчатки.", "点燃重磅炸药的引线。", "點燃強力炸藥的引信。", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["645"] = {
{ "The key to lifting the curse of this place rests in the final death of Darkmaster Gandling.", "Nur der endgültige Tod von Dunkelmeister Gandling kann diesen Ort von dem Fluch befreien, der darauf lastet.", "La clave para acabar con la maldición de este lugar está en la muerte del maestro oscuro Gandling.", "La clave para acabar con la maldición de este lugar reside en acabar con el maestro oscuro Gandling.", "Le seul moyen de lever la malédiction qui règne sur cet endroit est d’éliminer le Sombre Maître Gandling.", "La chiave per rimuovere la maledizione presente in questo luogo risiede nella morte del Maestro Oscuro Gandling.", "이곳에 드리운 저주를 없애려면 암흑스승 간들링을 처치해야만 합니다.", "Apenas a morte final do Umbromestre Gandling pode quebrar a maldição deste lugar.", "Проклятие не покинет это место, пока жив темный магистр Гандлинг.", "解除此地诅咒的关键就在于彻底杀死黑暗院长加丁。", "要解除這個地方的詛咒，關鍵就在於黑暗院長加丁的死亡。", }, 
},
["671"] = {
{ "Defeat the bosses of Blackrock Depths", "Besiegt die Bosse der Schwarzfelstiefen", "Derrota a los jefes de las Profundidades de Roca Negra.", "Derrota a los jefes de las Profundidades de Roca Negra", "Triomphez des boss des profondeurs de Rochenoire.", "Sconfiggi i boss dei Sotterranei di Roccianera.", "검은바위 나락 우두머리들을 처치해야 합니다.", "Derrote os chefes do Abismo Rocha Negra", "Победите боссов в Глубинах Черной горы", "击败黑石深渊的首领", "擊敗黑石深淵的首領", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
{ "Defeat High Interrogator Gerstahn", "Besiegt Verhörmeisterin Gerstahn", "Derrota a la alta interrogadora Gerstahn.", "Derrota a la Alta interrogadora Gerstahn", "Triomphez de la grande Interrogatrice Gerstahn.", "Sconfiggi Gerstahn la Grande Accusatrice.", "대심문관 게르스탄을 처치해야 합니다.", "Derrote a Suprema Interrogadora Gerstahn", "Победите верховного дознавателя Герштан", "击败审讯官格斯塔恩", "擊敗高階審問者格斯塔恩", }, 
{ "Defeat Bael'Gar", "Bezwingt Bael'Gar", "Derrota a Bael'Gar.", "Derrota a Bael'Gar", "Triomphez de Bael’Gar.", "Sconfiggi Bael'gar.", "밸가르를 처치해야 합니다.", "Derrote Bael'gar", "Победите Бейл'Гора", "击败贝尔加", "擊敗貝爾加", }, 
{ "Defeat the bosses in the Grim Guzzler", "Bezwingt die Bosse im Grimmigen Säufer.", "Derrota a los jefes del Tragapenas.", "Derrota a los jefes del Tragapenas", "Triomphez des boss du Sinistre écluseur.", "Sconfiggi i boss del Torvo Beone.", "험상궂은 주정뱅이 선술집 우두머리들을 처치해야 합니다.", "Derrote os chefes no Glutão Implacável", "Победите боссов в трактире \"Угрюмый Обжора\"", "击败黑铁酒吧的首领", "擊敗黑鐵酒吧的首領", }, 
{ "Defeat Phalanx", "Bezwingt Phalanx", "Derrota a Falange.", "Derrota a Falange", "Triomphez de Phalange.", "Sconfiggi Falange.", "팔랑크스를 처치해야 합니다.", "Derrote Falange", "Победите Фалангу", "击败法拉克斯", "擊敗法拉克斯", }, 
},
["675"] = {
{ "Defeat the bosses of The Stonecore", "Bezwingt die Bosse des Steinernen Kerns.", "Derrota a los jefes de El Núcleo Pétreo.", "Derrota a los jefes de El Núcleo Pétreo", "Triomphez des boss du Cœur-de-Pierre.", "Sconfiggi i boss del Nucleo di Pietra.", "바위심장부 우두머리들을 처치해야 합니다.", "Derrote os chefes do Litocerne", "Победите боссов в Каменных Недрах", "击败巨石之核的首领", "擊敗石岩之心的首領", }, 
},
["775"] = {
{ "Lead the paladins of the Argent Crusade into battle.", "Führt die Paladine des Argentumkreuzzugs in die Schlacht.", "Dirige a los paladines de la Cruzada Argenta a la batalla.", "Lidera a los paladines de la Cruzada Argenta en la batalla.", "Menez les paladins de la Croisade d’argent au combat.", "Guida i Paladini della Crociata d'Argento in battaglia.", "은빛십자군 성기사들을 이끌고 전투에 나서야 합니다.", "Lidere os paladinos da Cruzada Argêntea em combate.", "Поведите паладинов Серебряного Авангарда за собой в битву.", "率领银色北伐军的圣骑士奔赴战场。", "率領銀白十字的聖騎士參戰。", }, 
{ "Destroy the demon army.", "Vernichtet die Dämonenarmee.", "Destruye el ejército demoníaco.", "Destruye al ejército de demonios.", "Anéantissez l’armée démoniaque.", "Distruggi l'armata di demoni.", "악마 군대를 격퇴해야 합니다.", "Destrua o exército demoníaco.", "Уничтожьте армию демонов.", "摧毁恶魔大军。", "消滅惡魔部隊。", }, 
{ "Destroy Jailer Zerus and save Highlord Tirion Fordring.", "Vernichtet Wärter Zerus und rettet Hochlord Tirion Fordring.", "Acaba con el carcelero Zerus y salva al alto señor Tirion Vadín.", "Destruye al carcelero Zerus y salva al Alto señor Tirion Vadín.", "Éliminez le geôlier Zerus et sauvez le généralissime Tirion Fordring.", "Elimina il Carceriere Zerus e salva il Gran Signore Tirion Fordring.", "간수 제루스를 처치하고 대영주 티리온 폴드링을 구해야 합니다.", "Destrua o Carcereiro Zerus e salve o Grão-lorde Tirion Fordring.", "Убейте тюремщика Зеруса и спасите Верховного лорда Тириона Фордринга.", "消灭狱卒泽鲁斯并解救大领主提里奥·弗丁。", "消滅獄卒澤魯斯，救出大領主提里奧‧弗丁。", }, 
{ "Find the Ashbringer within the Lost Temple.", "Findet den Aschenbringer im Verlorenen Tempel.", "Encuentra la Crematoria en el Templo Perdido.", "Encuentra la Crematoria en el Templo Perdido.", "Trouvez Porte-Cendres dans l’enceinte du temple Perdu.", "Trova Brandicenere all'interno del Tempio Disperso.", "잃어버린 사원에서 파멸의 인도자를 찾아야 합니다.", "Encontre a Crematória no Templo Perdido.", "Найдите Испепелитель в разрушенном храме.", "在失落的神庙中找到灰烬使者。", "進入失落神殿尋找灰燼使者。", }, 
{ "Call upon the power of the Ashbringer to break free from Balnazzar's control.", "Ruft die Macht des Aschenbringers an, um Euch Balnazzars Gedankenkontrolle zu entziehen.", "Invoca el poder de la Crematoria para liberarte del control de Balnazzar.", "Invoca el poder de la Crematoria para liberarte del control de Balnazzar.", "Faites appel au pouvoir de Porte-Cendres pour vous libérer de l’emprise de Balnazzar.", "Invoca il potere di Brandicenere per liberarti dal controllo di Balnazzar.", "파멸의 인도자의 힘을 사용하여 발나자르의 지배에서 벗어나야 합니다.", "Convoque o poder da Crematória para livrar-se do controle de Balnazzar.", "Обратитесь к силе Испепелителя, чтобы освободиться от контроля Бальназара.", "召唤灰烬使者的力量，摆脱巴纳扎尔的控制。", "呼喚灰燼使者之力以擺脫巴納札爾的控制。", }, 
{ "Defeat Balnazzar.", "Bezwingt Balnazzar.", "Derrota a Balnazzar.", "Derrota a Balnazzar.", "Terrassez Balnazzar.", "Sconfiggi Balnazzar.", "발나자르를 처치해야 합니다.", "Derrote Balnazzar.", "Победите Бальназара.", "击败巴纳扎尔", "擊敗巴納札爾。", }, 
{ "Return to Tirion Fordring.", "Kehrt zu Tirion Fordring zurück.", "Vuelve con Tirion Vadín.", "Vuelve con Tirion Vadín.", "Retournez voir Tirion Fordring.", "Torna da Tirion Fordring.", "티리온 폴드링에게 가야 합니다.", "Fale novamente com Tirion Fordring.", "Вернитесь к Тириону Фордрингу.", "回到提里奥·弗丁身边。", "回去找提里奧‧弗丁。", }, 
},
["450"] = {
{ "Follow Prophet Velen.", "Folgt Prophet Velen.", "Sigue al profeta Velen.", "Sigue al profeta Velen.", "Suivez le Prophète Velen.", "Segui il Profeta Velen.", "예언자 벨렌을 따라가야 합니다.", "Siga o Profeta Velen.", "Следуйте за пророком Веленом.", "跟随先知维伦。", "跟隨預言者費倫。", }, 
{ "Defeat Krull.", "Bezwingt Krull.", "Derrota a Krull.", "Derrota a Krull.", "Terrassez Krull.", "Sconfiggi Krull.", "크룰을 처치해야 합니다.", "Derrote Krull.", "Победите Крулла.", "击败库鲁尔。", "擊敗克魯爾。", }, 
{ "Witness Commander Vorka's arrival.", "Beobachtet Kommandant Vorkas Ankunft.", "Presencia la llegada del comandante Vorka.", "Atestigua la llegada del comandante Vorka.", "Assistez à l’arrivée du commandant Vorka.", "Assisti all'arrivo del Comandante Vorka.", "사령관 보르카가 도착하는 장면을 목격해야 합니다.", "Testemunhe a chegada do Comandante Vorka.", "Станьте свидетелем прибытия командира Ворки.", "见证指挥官沃尔卡的到来。", "見證指揮官沃爾卡的到來。", }, 
{ "Speak to Prophet Velen on the Karabor stairs.", "Sprecht mit Prophet Velen auf den Stufen von Karabor.", "Habla con el profeta Velen en las escaleras de Karabor.", "Habla con el profeta Velen en los escalones de Karabor.", "Adressez-vous au prophète Velen sur les marches de Karabor.", "Parla con il Profeta Velen sulla scalinata di Karabor.", "카라보르 계단 위에 있는 예언자 벨렌과 대화해야 합니다.", "Fale com o Profeta Velen nas escadarias de Karabor.", "Поговорите с пророком Веленом на лестнице Карабора.", "在卡拉波台阶上与先知维伦交谈", "在卡拉伯爾階梯與預言者費倫交談。", }, 
},
["550"] = {
{ "Defeat the bosses of Throne of the Tides.", "Besiegt die Bosse im Thron der Gezeiten.", "Derrota a los jefes del Trono de las Mareas.", "Derrota a los jefes del Trono de las Mareas.", "Terrassez les boss du Trône des marées.", "Sconfiggi i boss del Trono delle Maree.", "파도의 왕좌 우두머리들을 처치해야 합니다.", "Derrote os chefes do Trono das Marés.", "Победите боссов у Трона Приливов.", "击败潮汐王座的首领。", "擊敗海潮王座的首領。", }, 
{ "Rescue Erunak Stonespeaker from Mindbender Ghur'sha.", "Rettet Erunak Steinsprecher vor Geistbeuger Ghur'sha.", "Rescata a Erunak Hablapiedra del dominamentes Ghur'sha.", "Rescata a Erunak Hablapiedra de los dominamentes Ghur'sha.", "Sauvez Erunak Parlepierre du torve-esprit Ghur’sha.", "Salva Erunak Parlapietra da Ghur'sha il Plagiamente.", "환각술사 구르샤에게서 에루낙 스톤스피커를 구출해야 합니다.", "Resgate Erunak Falapedra do Dobramentes Ghur'sha.", "Вызволите Эрунака Говорящего с Камнем из плена подчиняющего разум Гур'ши.", "将石语者埃鲁纳克从蛊心魔古厄夏手中救出。", "從屈心者哥爾薩的手中解救伊魯納克‧石語者。", }, 
},
["609"] = {
{ "Defeat the bosses of the Shadow Labyrinth", "Besiegt die Bosse des Schattenlabyrinths", "Derrota a los jefes de Laberinto de las Sombras.", "Derrota a los jefes del Laberinto de las Sombras.", "Terrassez les boss du labyrinthe des Ombres.", "Sconfiggi i boss del Labirinto delle Ombre.", "어둠의 미궁 우두머리들을 처치해야 합니다.", "Derrote os chefes do Labirinto Soturno", "Победите боссов в Темном лабиринте", "击败暗影迷宫的首领", "擊敗暗影迷宮的首領", }, 
},
["1280"] = {
{ "Reach the Broken Shore", "Erreicht die Verheerte Küste.", "Llega a la Costa Abrupta.", "Llega a la Costa Quebrada.", "Atteignez le rivage Brisé.", "Raggiungi la Riva Dispersa.", "부서진 해변에 도착해야 합니다.", "Chegue à Costa Partida.", "Доберитесь до Расколотого берега.", "抵达破碎海滩", "抵達破碎海岸", }, 
{ "Secure the beach", "Sichert den Strand", "Asegurar la playa", "Asegurar la playa", "Sécurisez la plage.", "Metti al sicuro la spiaggia.", "해변을 확보해야 합니다.", "Proteger a praia", "Закрепитесь на берегу.", "肃清海滩", "守住海灘", }, 
{ "Defeat Lord Kalgorath", "Besiegt Lord Kalgorath.", "Derrota a lord Kalgorath.", "Derrota a Lord Kalgorath", "Terrassez le seigneur Kalgorath.", "Sconfiggi Sire Kalgorath.", "군주 칼고라스를 처치해야 합니다.", "Derrote o Lorde Kalgorath.", "Победите лорда Калгората.", "击败卡格拉斯", "擊敗凱戈洛茲領主", }, 
{ "Close the portals and defeat Dread Commander Arganoth's forces", "Schließt die Portale und bezwingt die Streitkräfte von Schreckenskommandant Arganoth.", "Cierra los portales y derrota a las tropas del comandante aterrador Arganoth.", "Cierra los portales y derrota a las fuerzas del comandante aterrador Arganoth.", "Fermez les portails et terrassez les troupes du commandant de l’effroi Arganoth.", "Chiudi i portali e sconfiggi le forze del Comandante del Terrore Arganoth.", "차원문을 닫고 공포의 사령관 아르가노스의 병력을 처치해야 합니다.", "Feche os portais e derrote as forças do Comandante Medonho Arganoth", "Закройте порталы и одержите победу над войсками командира повелителей ужаса Арганота.", "关闭传送门并击败恐怖指挥官阿加诺斯的部队。", "關閉傳送門並擊敗驚懼指揮官亞岡諾斯的部隊", }, 
{ "Defeat Dread Commander Arganoth", "Bezwingt Schreckenskommandant Arganoth.", "Derrota al comandante aterrador Arganoth.", "Derrota al comandante aterrador Arganoth.", "Terrassez le commandant de l’effroi Arganoth.", "Sconfiggi il Comandante del Terrore Arganoth.", "공포의 사령관 아르가노스를 처치해야 합니다.", "Derrote o Comandante Medonho Arganoth.", "Победите командира повелителей ужаса Арганота.", "击败恐怖指挥官阿加诺斯", "擊敗驚懼指揮官亞岡諾斯", }, 
{ "Take the Demonic Gateway to the base of the command ship.", "Gelangt mithilfe des dämonischen Tors zum Kommandoschiff.", "Usa el portal demoníaco que lleva a la base de la nave de mando.", "Usa el portal demoníaco para llegar a la base de la nave de mando.", "Empruntez la porte des démons pour rejoindre la base du vaisseau de commandement.", "Entra nel Varco Demoniaco e raggiungi la Nave Ammiraglia.", "악마의 관문을 이용하여 지휘함 하부로 침투해야 합니다.", "Usar o Portal Demoníaco para chegar à base da nave de comando.", "Используйте демонические врата и проникните на флагманский корабль.", "使用恶魔传送门前往指挥舰底层。", "通過惡魔之門抵達指揮艦底層。", }, 
{ "Place Arcane Bombs in Mephistroth's command ship.", "Platziert arkane Bomben auf Mephistroths Kommandoschiff.", "Coloca bombas Arcanas en la nave de mando de Mephistroth.", "Coloca bombas arcanas en la nave de mando de Mephistroth.", "Placez les bombes des Arcanes dans le vaisseau de commandement de Méphistroth.", "Piazza le Bombe Arcane nella Nave Ammiraglia di Mefistroth.", "메피스트로스의 지휘함에 비전 폭탄을 설치해야 합니다.", "Plantar as Bombas Arcanas na nave de comando de Mephistroph.", "Установите чародейские бомбы на флагманском корабле Мефистрота.", "在孟菲斯托斯的指挥舰上放置奥术炸弹。", "在梅菲斯托的指揮艦放置秘法炸彈。", }, 
{ "Defeat Mephistroth.", "Bezwingt Mephistroth.", "Derrota a Mephistroth.", "Derrota a Mephistroth.", "Terrassez Méphistroth.", "Sconfiggi Mefistroth.", "메피스트로스를 처치해야 합니다.", "Derrotar Mephistroph.", "Победите Мефистрота.", "击败孟菲斯托斯", "擊敗梅菲斯托。", }, 
},
["1007"] = {
{ "Help Taran Zhu recover from his battle injuries.", "Helft Taran Zhu, sich von seinen im Kampf erlittenen Wunden zu erholen.", "Ayuda a Taran Zhu a recuperarse de sus heridas de batalla.", "Ayuda a Taran Zhu a recuperarse de sus heridas de batalla.", "Aidez Taran Zhu à panser ses blessures de guerre.", "Aiuta Taran Zhu a riprendersi dalle ferite riportate in battaglia.", "타란 주가 전투에서 입은 부상에서 회복할 수 있도록 도와주어야 합니다.", "Ajude Taran Zhu a se recuperar de seus ferimentos de batalha.", "Помогите Тажаню Чжу оправиться от полученных в бою ран.", "帮助祝踏岚恢复伤势。", "幫塔蘭‧祝恢復他的傷勢。", }, 
{ "Open the cages to free the captured Shado-Pan and defeat Hellwarden Xaphan.", "Öffnet die Käfige, um die gefangenen Shado-Pan zu befreien, und bezwingt Höllenwärter Xaphan.", "Abre las jaulas para liberar a los miembros del Shadopan capturados y derrota al celador de infierno Xaphan.", "Abre las jaulas para liberar a los Shadopan capturados y derrota al Guardia infernal Xaphan.", "Ouvrez les cages pour libérer les Pandashan retenus captifs et terrassez le gardien infernal Xaphan.", "Apri le gabbie per liberare gli Shandaren e sconfiggi il Guardiano Infernale Xaphan.", "철창을 열어 사로잡힌 음영파를 해방한 다음 지옥감시자 제이판을 처치해야 합니다.", "Abra as jaulas para libertar os Shado-Pan capturados e derrotar o Guardião Infernal Xaphan.", "Откройте клетки и освободите пленных монахов Шадо-Пан, а затем победите стража преисподней Кзафана.", "打开笼子，释放被关押的影踪派成员，然后击败地狱卫士萨潘。", "打開牢籠釋放影潘，然後擊敗地獄守衛薩凡。", }, 
{ "Speak with each of the Shadow-Pan to coordinate your attack on the corrupted terrace.", "Sprecht mit jedem der Shado-Pan, um Euren Angriff auf die verderbte Terrasse zu koordinieren.", "Habla con cada uno de los miembros del Shadopan para coordinar el ataque contra el bancal corrupto.", "Habla con cada uno de los Shadopan para coordinar tu ataque a la terraza corrupta.", "Parlez à chacun des Pandashan pour coordonner votre attaque de la terrasse corrompue.", "Parla con ogni Shandaren per coordinare l'assalto alla terrazza corrotta.", "음영파 대원들과 대화하여 오염된 정원에서 어떻게 공격할 것인지 상의해야 합니다.", "Fale com cada um dos shado-pans para coordenar seu ataque contra o terraço corrompido.", "Поговорите с каждым из монахов Шадо-Пан, чтобы согласовать план атаки на оскверненную террасу.", "与每个影踪派成员交谈，安排对腐化的永春台的攻击。", "跟每個影潘交談，協調對腐化豐泉台的攻擊行動。", }, 
{ "Defeat Aspersius with the help of the Shado-Pan.", "Bezwingt Aspersius mit der Hilfe der Shado-Pan.", "Derrota a Aspersius con la ayuda del Shadopan.", "Derrota a Aspersius con la ayuda de los Shadopan.", "Terrassez Aspersius avec l’aide des Pandashan.", "Sconfiggi Aspersius con l'aiuto degli Shandaren.", "음영파의 도움을 받아 아스페르시우스를 처치해야 합니다.", "Derrote Aspersius com a ajuda dos Shado-Pan.", "Вместе с монахами Шадо-Пан сразите Асперсия.", "在影踪派的帮助下击败阿斯帕修斯。", "在影潘熊貓人的協助下擊敗埃斯柏休斯。", }, 
{ "Acquire Sheilun, Staff of the Mists.", "Bringt Sheilun, Stab der Nebel, in Euren Besitz.", "Hazte con Sheilun, Bastón de la Niebla.", "Adquiere a Sheliun, Bastón de la Niebla.", "Obtenir Sheilun, bâton des brumes.", "Recupera Sheilun, Bastone delle Nebbie.", "셰이룬 - 안개의 지팡이를 획득해야 합니다.", "Obtenha Sheilun, Cajado das Brumas.", "Заберите Шей-лун, Посох Туманов.", "神龙，迷雾之杖", "取得雪崙，迷霧之杖。", }, 
},
["626"] = {
{ "Defeat the bosses of Auchenai Crypts", "Bezwingt die Bosse der Auchenaikrypta.", "Derrota a los jefes de las Criptas Auchenai.", "Derrota a los jefes de las Criptas Auchenai.", "Terrassez les boss des cryptes Auchenaï.", "Sconfiggi i boss delle Cripte degli Auchenai.", "아키나이 납골당 우두머리들을 처치해야 합니다.", "Derrote os chefes das Catacumbas Auchenai", "Победите боссов в Аукенайских гробницах", "击败奥金尼地穴的首领", "擊敗奧奇奈地穴的首領", }, 
},
["1094"] = {
{ "Learn about being a Death Knight.", "Erfahrt etwas über das Leben als Todesritter.", "Infórmate sobre ser un caballero de la Muerte.", "Averigua más sobre ser un caballero de la Muerte.", "Apprenez-en davantage sur les chevaliers de la mort.", "Impara il significato di essere un Cavaliere della Morte.", "죽음의 기사에 대해 배워야 합니다.", "Aprenda sobre os Cavaleiros da Morte.", "Узнайте, что значит быть рыцарем смерти.", "学习如何成为一名死亡骑士。", "學習如何當一名死亡騎士。", }, 
{ "Learn about Raise Dead.", "Erfahrt mehr über 'Totenerweckung'.", "Infórmate sobre Levantar muerto.", "Averigua más sobre Levantar a los muertos.", "Apprenez-en davantage sur Réanimation morbide.", "Impara come usare Rianima Cadavere.", "시체 되살리기에 대해 배워야 합니다.", "Aprenda sobre Reviver Morto.", "Научитесь применять \"Воскрешение мертвых\".", "学习亡者复生。", "學習如何使用死者復生。", }, 
{ "Learn about Outbreak.", "Erfahrt mehr über 'Ausbruch'.", "Infórmate sobre Brote.", "Averigua más sobre Brote.", "Apprenez-en davantage sur Poussée de fièvre.", "Impara come usare Contagio.", "돌발 열병에 대해 배워야 합니다.", "Aprenda sobre Eclosão.", "Научитесь применять \"Вспышку болезни\".", "学习爆发。", "學習如何使用疫病爆發。", }, 
{ "Learn about Festering Strike.", "Erfahrt mehr über 'Schwärender Stoß'.", "Infórmate sobre Golpe purulento.", "Averigua más sobre Golpe purulento.", "Apprenez-en davantage sur Frappe purulente.", "Impara come usare Assalto Putrescente.", "고름 일격에 대해 배워야 합니다.", "Aprenda sobre Ataque Supurante.", "Научитесь применять \"Удар разложения\".", "学习脓疮打击。", "學習如何使用膿瘡潰擊。", }, 
{ "Learn about Scourge Strike.", "Erfahrt mehr über 'Geißelstoß'.", "Infórmate sobre Golpe de la Plaga.", "Averigua más sobre Golpe de la Plaga.", "Apprenez-en davantage sur Frappe du Fléau.", "Impara come usare Assalto del Flagello.", "스컬지의 일격에 대해 배워야 합니다.", "Aprenda sobre Golpe do Flagelo.", "Научитесь применять \"Удар Плети\".", "学习天灾打击。", "學習如何使用天譴打擊。", }, 
{ "Learn about Death Coil.", "Erfahrt mehr über 'Todesmantel'.", "Infórmate sobre Espiral de la muerte.", "Averigua más sobre Espiral de la muerte.", "Apprenez-en davantage sur Voile mortel.", "Impara come usare Spira Mortale.", "죽음의 고리에 대해 배워야 합니다.", "Aprenda sobre Espiral da Morte.", "Научитесь применять \"Лик смерти\".", "学习凋零缠绕。", "學習如何使用死亡纏繞。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Death Strike.", "Erfahrt mehr über 'Todesstoß'.", "Infórmate sobre Golpe letal.", "Averigua más sobre Golpe letal.", "Apprenez-en davantage sur Frappe de mort.", "Impara come usare Assalto della Morte.", "죽음의 일격에 대해 배워야 합니다.", "Aprenda sobre Golpe da Morte.", "Научитесь применять \"Удар смерти\".", "学习灵界打击。", "學習如何使用死亡打擊。", }, 
{ "Learn about Death Grip.", "Erfahrt mehr über 'Todesgriff'.", "Infórmate sobre Atracción letal.", "Averigua más sobre Atracción letal.", "Apprenez-en davantage sur Poigne de la mort.", "Impara come usare Presa Mortale.", "죽음의 손아귀에 대해 배워야 합니다.", "Aprenda sobre Garra da Morte.", "Научитесь применять \"Хватку смерти\".", "学习死亡之握。", "學習如何使用死亡之握。", }, 
{ "Learn about Army of the Dead.", "Erfahrt mehr über 'Armee der Toten'.", "Infórmate sobre Ejército de muertos.", "Averigua más sobre Ejército de los muertos.", "Apprenez-en davantage sur Armée des morts.", "Impara come usare Armata dei Morti.", "사자의 군대에 대해 배워야 합니다.", "Aprenda sobre Exército dos Mortos.", "Научитесь применять \"Войско мертвых\".", "学习亡者大军。", "學習如何使用亡靈大軍。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["742"] = {
{ "Follow the Sergeant", "Folgt dem Unteroffizier", "Sigue al Sargento.", "Sigue al sargento", "Suivez le sergent.", "Segui il Sergente.", "하사관을 따라가야 합니다.", "Siga o Sargento", "Следуйте за сержантом", "追随中士", "跟隨士官", }, 
{ "Defeat the Iron Horde scouting party.", "Besiegt den Eisernen Spähtrupp.", "Derrota al grupo de exploración de la Horda de Hierro.", "Derrota al grupo explorador de la Horda de Hierro.", "Neutralisez le groupe d’éclaireurs de la Horde de Fer.", "Sconfiggi il gruppo di esploratori dell'Orda di Ferro.", "강철 호드 정찰대를 물리쳐야 합니다.", "Derrote o grupo de batedores da Horda de Ferro.", "Убейте разведывательный отряд Железной Орды.", "击败钢铁部落的斥候小队。", "擊敗鋼鐵部落偵察隊。", }, 
{ "Endure the Iron Horde assault.", "Übersteht den Angriff der Eisernen Horde.", "Resiste el asalto de la Horda de Hierro.", "Aguanta el ataque de la Horda de Hierro.", "Survivez à l’attaque de la Horde de Fer.", "Resisti all'assalto dell'Orda di Ferro.", "강철 호드의 공격을 막아내야 합니다.", "Resista ao ataque da Horda de Ferro.", "Выдержите атаку Железной Орды.", "顶住钢铁部落的攻击。", "撐過鋼鐵部落的攻擊。", }, 
{ "Defeat the remaining Thunderlord forces.", "Besiegt die verbleibenden Truppen der Donnerfürsten.", "Derrota a las fuerzas Señor del Trueno restantes.", "Derrota a las fuerzas Señor del Trueno restantes.", "Terrassez les derniers soldats sire-tonnerre.", "Sconfiggi le forze restanti degli Spaccatuono.", "남은 천둥군주 병력을 물리쳐야 합니다.", "Derrote as forças dos Senhor do Trovão restantes.", "Одержите победу над оставшимися силами клана Громоборцев.", "击败雷神氏族的残余部队。", "擊敗剩下的雷霆王部隊。", }, 
{ "Return to the town center.", "Kehrt zur Ortsmitte zurück.", "Vuelve al centro de la ciudad.", "Vuelve al centro del pueblo.", "Retournez dans le centre-ville.", "Torna al centro del villaggio.", "마을 중앙으로 가야 합니다.", "Retorne ao centro da cidade.", "Вернитесь в центр гарнизона.", "返回镇中心。", "返回城鎮中心。", }, 
{ "Defeat the Iron Horde commander.", "Besiegt den Kommandanten der Eisernen Horde.", "Derrota al comandante de la Horda de Hierro.", "Derrota al comandante de la Horda de Hierro.", "Terrassez le commandant de la Horde de Fer.", "Sconfiggi il comandante dell'Orda di Ferro.", "강철 호드 지휘관을 처치해야 합니다.", "Derrote o comandante da Horda de Ferro.", "Победите полководца Железной Орды.", "击败钢铁部落指挥官。", "擊敗鋼鐵部落指揮官。", }, 
},
["663"] = {
{ "Defeat the bosses of Earth Song Falls", "Bezwingt die Bosse der Fälle des Irdenen Gesangs.", "Derrota a los jefes de las Cascadas del Canto de la Tierra", "Derrota a los jefes de las Cascadas del Canto de la Tierra", "Triomphez des boss des chutes de Chanteterre.", "Sconfiggi i boss delle Cascate Cantaterra.", "대지노래 폭포 우두머리들을 처치해야 합니다.", "Derrote os chefes de Cachoeiras da Canção Telúrica", "Победите боссов у Поющих водопадов", "击败地歌瀑布的首领", "擊敗地歌瀑布的首領", }, 
{ "Defeat Rotgrip", "Bezwingt Faulschnapper", "Derrota a Escamapodrida", "Derrota a Escamapodrida", "Triomphez de Grippe-charogne.", "Sconfiggi Morsodrillo.", "썩은아귀를 처치해야 합니다.", "Derrote Putrigarra", "Победите Гнилопасть", "击败洛特格里普", "擊敗洛特格里普", }, 
},
["558"] = {
{ "Defeat the bosses of the Halls of Origination", "Besiegt die Bosse in den Hallen des Ursprungs.", "Derrota a los jefes de las Cámaras de los Orígenes.", "Derrota a los jefes de Las Cámaras de los Orígenes.", "Terrassez les boss des salles de l’Origine.", "Sconfiggi i boss delle Sale della Creazione.", "시초의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes dos Salões Primordiais", "Победите боссов в Чертогах Созидания", "击败起源大厅的首领", "擊敗起源大廳的首領", }, 
{ "Defeat Isiset, Construct of Magic", "Besiegt Isiset, Konstrukt der Magie.", "Derrota a Isiset, Ensamblaje de magia.", "Derrota a Isiset, Ensamblaje de magia.", "Terrassez Isiset, assemblage de magie.", "Sconfiggi Isiset, Costrutto della Magia.", "마법의 지배신 이시세트를 처치해야 합니다.", "Derrote Isiset, o Constructo Mágico", "Победите Изисет, Творение Магии", "击败伊希斯特，魔法的造物", "擊敗伊希賽特，魔法造物", }, 
{ "Defeat Ammunae, Construct of Life", "Besiegt Ammunae, Konstrukt des Lebens.", "Derrota a Ammunae, Ensamblaje de vida.", "Derrota a Ammunae, Ensamblaje de vida.", "Terrassez Ammunae, assemblage de vie.", "Sconfiggi Ammunae, Costrutto della Vita.", "생명의 지배신 아뮤내를 처치해야 합니다.", "Derrote Ammunae, o Constructo Vital", "Победите Аммунаэ, Творение Жизни", "击败阿穆纳伊，生命的造物", "擊敗安姆內，生命造物", }, 
{ "Defeat Setesh, Construct of Destruction", "Besiegt Setesh, Konstrukt der Zerstörung.", "Derrota a Setesh, Ensamblaje de destrucción.", "Derrota a Setesh, Ensamblaje de destrucción.", "Terrassez Setesh, assemblage de destruction.", "Sconfiggi Setesh, Costrutto della Distruzione.", "파괴의 지배신 세테쉬를 처치해야 합니다.", "Derrote Setesh, Constructo Destrutivo", "Победите Сетеша, Творение Разрушения", "击败塞特斯，毁灭的造物", "擊敗賽特胥，毀滅造物", }, 
},
["571"] = {
{ "Defeat the bosses of the Pit of Saron", "Besiegt die Bosse in der Grube von Saron", "Derrota a los jefes del Foso de Saron.", "Derrota a los jefes de El Foso de Saron.", "Terrassez les boss de la fosse de Saron.", "Sconfiggi i boss della Fossa di Saron.", "사론의 구덩이 우두머리들을 처치해야 합니다.", "Derrote os chefes do Fosso de Saron", "Победите боссов в Яме Сарона", "击败萨隆矿坑的首领", "擊敗薩倫之淵的首領", }, 
},
["1182"] = {
{ "Learn about being a Shaman.", "Erfahrt etwas über das Leben als Schamane.", "Infórmate sobre ser un chamán.", "Averigua más sobre ser un chamán.", "Apprenez-en davantage sur les chamans.", "Impara il significato di essere uno Sciamano.", "주술사에 대해 배워야 합니다.", "Aprenda sobre os Xamãs.", "Узнайте, что значит быть шаманом.", "学习如何成为一名萨满。", "學習如何當一名薩滿。", }, 
{ "Learn about Flametongue.", "Erfahrt mehr über 'Flammenzunge'.", "Infórmate sobre Lengua de Fuego.", "Averigua más sobre Lengua de Fuego.", "Apprenez-en davantage sur Langue de feu.", "Impara come usare Lingua di Fuoco.", "불꽃혓바닥에 대해 배워야 합니다.", "Aprenda sobre Labareda.", "Научитесь применять \"Язык пламени\".", "学习火舌。", "學習如何使用火舌打擊。", }, 
{ "Learn about Rockbiter.", "Erfahrt mehr über 'Felsbeißer'.", "Infórmate sobre Muerdepiedras.", "Averigua más sobre Muerdepiedras.", "Apprenez-en davantage sur Croque-roc.", "Impara a usare Roccia Dura.", "대지이빨에 대해 배워야 합니다.", "Aprenda sobre Trinca-pedra.", "Научитесь применять \"Камнедробитель\".", "学习石化。", "學習如何使用石化打擊。", }, 
{ "Learn about Lava Lash.", "Erfahrt mehr über 'Lavapeitsche'.", "Infórmate sobre Latigazo de lava.", "Averigua más sobre Latigazo de lava.", "Apprenez-en davantage sur Fouet de lave.", "Impara come usare Sferzata Lavica.", "용암 채찍에 대해 배워야 합니다.", "Aprenda sobre Açoite de Lava.", "Научитесь применять \"Вскипание лавы\".", "学习熔岩猛击。", "學習如何使用熔岩暴擊。", }, 
{ "Learn about Stormstrike.", "Erfahrt mehr über 'Sturmschlag'.", "Infórmate sobre Golpe de tormenta.", "Averigua más sobre Golpe de tormenta.", "Apprenez-en davantage sur Frappe-tempête.", "Impara come usare Assalto della Tempesta.", "폭풍의 일격에 대해 배워야 합니다.", "Aprenda sobre Ataque da Tempestade.", "Научитесь применять \"Удар бури\".", "学习风暴打击。", "學習如何使用風暴打擊。", }, 
{ "Use all your new abilities on the target dummy.", "Setzt all Eure neuen Fähigkeiten gegen die Zielattrappe ein.", "Usa todas tus nuevas facultades contra el muñeco-diana.", "Usa todas tus nuevas facultades contra el muñeco de práctica.", "Utilisez toutes vos nouvelles techniques contre le mannequin d’entraînement.", "Usa tutte le tue nuove abilità sul Manichino d'Addestramento.", "새로 배운 모든 기술을 표적 허수아비에 사용해야 합니다.", "Teste todas as habilidades novas no boneco-alvo.", "Примените все свои новые способности к манекену.", "在假人身上使用你所有的新技能。", "對假人使用你所有的新技能。", }, 
{ "Learn about Hex.", "Erfahrt mehr über 'Verhexen'.", "Infórmate sobre Maleficio.", "Averigua más sobre Maleficio.", "Apprenez-en davantage sur Maléfice.", "Impara come usare Maleficio.", "사술에 대해 배워야 합니다.", "Aprenda sobre Bagata.", "Научитесь применять \"Сглаз\".", "学习妖术。", "學習如何使用妖術。", }, 
{ "Learn about Healing Surge.", "Erfahrt mehr über 'Heilende Woge'.", "Infórmate sobre Oleada de sanación.", "Averigua más sobre Oleada de sanación.", "Apprenez-en davantage sur Afflux de soins.", "Impara come usare Eruzione Benefica.", "치유의 파도에 대해 배워야 합니다.", "Aprenda sobre Maré Curativa.", "Научитесь применять \"Исцеляющий всплеск\".", "学习治疗之涌。", "學習如何使用洶湧治療。", }, 
{ "Learn about Feral Spirit.", "Erfahrt mehr über 'Wildgeist'.", "Infórmate sobre Espíritu feral.", "Averigua más sobre Espíritu feral.", "Apprenez-en davantage sur Esprit farouche.", "Impara come usare Lupi Spirituali.", "야수 정령에 대해 배워야 합니다.", "Aprenda sobre Espírito Feral.", "Научитесь применять \"Дух дикого зверя\".", "学习野性狼魂。", "學習如何使用野性之魂。", }, 
{ "Use what you have learned to defeat a solo opponent.", "Setzt das Gelernte gegen einen einzelnen Gegner ein.", "Usa lo que has aprendido para derrotar a un solo oponente.", "Usa lo que aprendiste para derrotar a un oponente mano a mano.", "Servez-vous de ce que vous avez appris pour vaincre un adversaire seul.", "Usa ciò che hai imparato per sconfiggere un avversario.", "배운 것을 활용하여 적 한 명을 물리쳐야 합니다.", "Aplique o que aprendeu e derrote um oponente individual.", "Используйте все недавно освоенные способности, предназначенные для боя с одним противником.", "用你所学，击败一个单独的对手。", "學以致用，擊敗一名對手。", }, 
{ "Use what you have learned to defeat two opponents at the same time.", "Setzt das Gelernte im Kampf gegen zwei Gegner gleichzeitig ein.", "Usa lo que has aprendido para derrotar a dos oponentes al mismo tiempo.", "Usa lo que aprendiste para derrotar a dos oponentes al mismo tiempo.", "Utilisez ce que vous avez appris pour vaincre deux adversaires à la fois.", "Usa ciò che hai imparato per sconfiggere due avversari allo stesso tempo.", "배운 것을 활용하여 적 두 명과 동시에 싸워야 합니다.", "Aplique o que aprendeu e derrote dois oponentes ao mesmo tempo.", "Используйте все недавно освоенные способности, предназначенные для боя с двумя противниками одновременно.", "用你所学，同时击败两个对手。", "學以致用，同時擊敗兩名對手。", }, 
{ "The Legion is attacking.  Defend the airship!", "Die Legion greift an. Verteidigt das Luftschiff!", "La Legión ataca. ¡Defiende la nave!", "La Legión nos ataca. ¡Defiende la nave!", "La Légion attaque. Défendez le vaisseau !", "La Legione sta attaccando. Difendi la cannoniera!", "군단이 공격하고 있습니다. 비행선을 지켜야 합니다!", "A Legião está atacando. Defenda a aeronave!", "Легион атакует. Защитите воздушный корабль!", "军团正在发动攻击。保卫飞艇！", "燃燒軍團正在攻擊。守禦飛船！", }, 
{ "Leave the airship and join the assault.", "Verlasst das Luftschiff und schließt Euch dem Angriff an.", "Deja la nave y únete al ataque.", "Sal de la nave y únete al asalto.", "Quittez le vaisseau et prenez part à l’attaque.", "Abbandona la cannoniera e unisciti all'assalto.", "비행선을 떠나 공격에 참여해야 합니다.", "Deixe a aeronave e participe do ataque.", "Покиньте воздушный корабль и примите участие в битве.", "离开飞艇，加入突袭。", "離開飛船，加入突襲行動。", }, 
},
["806"] = {
{ "Defend against the Legion threat at Gadgetzan.", "Schlagt die Legionsbedrohung bei Gadgetzan zurück.", "Defiende Gadgetzan de la amenaza de la Legión.", "Lucha contra la amenaza de la Legión en Gadgetzan.", "Repoussez l’assaut de la Légion à Gadgetzan.", "Neutralizza la minaccia della Legione a Meccania.", "군단의 위협에 맞서 가젯잔을 방어해야 합니다.", "Defenda Geringontzan da ameaça da Legião.", "Ликвидируйте угрозу Легиона в Прибамбасске.", "解除燃烧军团对加基森的威胁。", "在加基森對抗燃燒軍團的威脅。", }, 
{ "Defeat the Legion Commanders threatening Gadgetzan.", "Bezwingt die Kommandanten der Legion, die Gadgetzan bedrohen.", "Derrota a los comandantes de la Legión que amenazan Gadgetzan.", "Derrota a los comandantes de la Legión que amenazan Gadgetzan.", "Terrassez les commandants de la Légion qui menacent Gadgetzan.", "Sconfiggi i comandanti della Legione che minacciano Meccania.", "가젯잔을 위협하는 군단 사령관을 처치해야 합니다.", "Derrote os Comandantes de Legião que ameaçam Geringontzan.", "Победите командиров Легиона, угрожающих Прибамбасску.", "击败威胁加基森的军团指挥官。", "擊敗威脅加基森的燃燒軍團指揮官。", }, 
{ "Repel the Legion's forces throughout Tanaris.", "Schlagt die Streitkräfte der Legion in ganz Tanaris zurück.", "Rechaza a los ejércitos de la Legión de Tanaris.", "Repele a las fuerzas de la Legión en Tanaris.", "Repoussez les troupes de la Légion en Tanaris.", "Respingi le forze della Legione sparse a Tanaris.", "타나리스 전역에 있는 군단 세력을 격퇴해야 합니다.", "Rechace as forças da Legião em Tanaris.", "Отразите вторжение сил Легиона в Танарисе.", "击退塔纳利斯的军团部队。", "在塔納利斯各地擊退燃燒軍團。", }, 
{ "Defeat the demon lord commanding the invasion at Gadgetzan.", "Bezwingt den Dämonenfürsten, der die Invasion von Gadgetzan befehligt.", "Derrota al señor demoníaco que lidera la invasión en Gadgetzan.", "Derrota al señor de los demonios que comanda la invasión en Gadgetzan.", "Terrassez le seigneur démon à la tête de l’armée d’invasion à Gadgetzan.", "Sconfiggi il Signore dei Demoni al comando dell'invasione a Meccania.", "가젯잔 침공을 지휘하는 악마 군주를 처치해야 합니다.", "Derrote o lorde-demônio que comanda a invasão à Geringontzan.", "Победите повелителя демонов, командующего вторжением в Прибамбасск.", "击败指挥入侵加基森的恶魔领主。", "在加基森擊敗指揮入侵行動的惡魔領主。", }, 
},
["610"] = {
{ "Defeat the bosses of The Black Morass", "Bezwingt die Bosse des Schwarzen Morasts.", "Derrota a los jefes de La Ciénaga Negra.", "Derrota a los jefes de La Ciénaga Negra.", "Terrassez les boss du Noir marécage.", "Sconfiggi i boss della Palude Nera.", "검은늪 우두머리들을 처치해야 합니다.", "Derrote os chefes do Lamaçal Negro", "Победите боссов в Черных топях", "击败黑色沼泽的首领", "擊敗黑色沼澤的首領", }, 
},
["1251"] = {
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
{ "Defend the Violet Hold against the Legion incursion.", "Verteidigt die Violette Festung gegen das Eindringen der Legion.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Defiende el Bastión Violeta de la incursión de la Legión.", "Défendez le fort Pourpre contre l’incursion de la Légion.", "Difendi la Fortezza Violacea dall'incursione della Legione.", "군단의 공격에 맞서 보랏빛 요새를 지켜야 합니다.", "Defenda o Castelo Violeta contra a incursão da Legião.", "Защитите Аметистовую крепость от войск Легиона.", "保卫紫罗兰监狱，击退军团的入侵。", "保護紫羅蘭堡，抵抗進犯的燃燒軍團。", }, 
},
["1273"] = {
{ "Confront Raest.", "Konfrontiert Raest.", "Enfréntate a Raest.", "Enfrenta a Raest.", "Affrontez Raëst.", "Affronta Raest.", "라이스트와 맞서야 합니다.", "Confronte Raest.", "Сразитесь с Рейстом.", "挑战莱斯特。", "挑戰雷斯特。", }, 
{ "Defeat Raest and Karam.", "Besiegt Raest und Karam.", "Derrota a Raest y Karam.", "Derrota a Raest y a Karam.", "Terrassez Raëst et Karam.", "Sconfiggi Raest e Karam.", "라이스트와 카람을 처치해야 합니다.", "Derrote Raest e Karam.", "Победите Рейста и Карама.", "击败莱斯特和卡兰姆。", "擊敗雷斯特與卡拉孟。", }, 
},
["617"] = {
{ "Kael'thas has risen from the ashes, he must be stopped!", "Kael'thas ist aus der Asche auferstanden, er muss aufgehalten werden!", "¡Kael'thas ha resurgido de sus cenizas, hay que detenerlo!", "Kael'thas se levantó de las cenizas, ¡hay que detenerlo!", "Kael’thas a pu renaître de ses cendres. Il faut l’arrêter !", "Kael'thas è risorto dalle ceneri, deve essere fermato!", "캘타스가 잿더미에서 일어섰습니다. 그를 막아야 합니다!", "Kael'thas se ergueu das cinzas. Ele precisa ser parado!", "Кель'тас восстал из праха. Его нужно остановить!", "凯尔萨斯又涅槃重生了，你必须阻止他！", "凱爾薩斯從從失敗的灰燼中復甦了，一定要阻止他！", }, 
},
["745"] = {
{ "Follow the Sergeant", "Folgt dem Unteroffizier", "Sigue al Sargento.", "Sigue al sargento", "Suivez le sergent.", "Segui il Sergente.", "하사관을 따라가야 합니다.", "Siga o Sargento", "Следуйте за сержантом", "追随中士", "跟隨士官", }, 
{ "Defeat the invaders", "Besiegt die Eindringlinge", "Derrota a los invasores.", "Derrota a los invasores", "Terrassez les envahisseurs.", "Sconfiggi gli invasori.", "침략자들을 처치해야 합니다.", "Derrote os invasores", "Победите захватчиков", "击败入侵者", "擊敗入侵者", }, 
{ "Endure the Shadowmoon assault.", "Haltet dem Angriff des Schattenmondklans stand.", "Resiste el asalto Sombraluna.", "Aguanta el asalto Sombraluna.", "Survivez à l’attaque des Ombrelunes.", "Resisti all'assalto dei Torvaluna.", "어둠달 부족의 공격을 막아내야 합니다.", "Resista ao ataque da Lua Negra.", "Выдержите нападение клана Призрачной Луны.", "顶住影月氏族的攻击。", "撐過影月氏族的攻擊。", }, 
{ "Defeat the remaining Shadowmoon forces.", "Besiegt die verbleibenden Truppen des Schattenmondklans.", "Derrota a las tropas Sombraluna restantes.", "Derrota a las fuerzas Sombraluna restantes.", "Terrassez les derniers soldats d’Ombrelune.", "Sconfiggi le forze restanti dei Torvaluna.", "남은 어둠달 병력을 물리쳐야 합니다.", "Derrotar as forças da Lua Negra restantes.", "Одержите победу над оставшимися силами клана Призрачной Луны.", "击败影月氏族的残余部队。", "擊敗剩下的影月氏族部隊。", }, 
{ "Return to the town center.", "Kehrt zur Ortsmitte zurück.", "Vuelve al centro de la ciudad.", "Vuelve al centro del pueblo.", "Retournez dans le centre-ville.", "Torna al centro del villaggio.", "마을 중앙으로 가야 합니다.", "Retorne ao centro da cidade.", "Вернитесь в центр гарнизона.", "返回镇中心。", "返回城鎮中心。", }, 
{ "Defeat the Void Spawn.", "Besiegt die Ausgeburt der Leere.", "Derrota al engendro del vacío.", "Derrota al engendro del vacío.", "Terrassez le rejeton du Vide.", "Sconfiggi la Creatura del Vuoto.", "공허의 피조물을 처치해야 합니다.", "Derrote o Rebento do Caos.", "Победите отродье Бездны.", "击败虚空爪牙。", "擊敗虛無生靈。", }, 
},
["1034"] = {
{ "Help Meryl Felstorm battle the dreadlord Kathra'natir.", "Helft Meryl Teufelssturm, den Schreckenslord Kathra'natir zu bekämpfen.", "Ayuda a Meryl Tormenta Vil a combatir al señor del Terror Kathra'natir.", "Ayuda a Meryl Tormenta Vil a luchar contra el señor del terror Kathra'natir.", "Aidez Meryl Gangrorage à combattre le seigneur de l’effroi Kathra’natir.", "Aiuta Meryl Viltempesta a sconfiggere il Signore del Terrore Kathra'natir.", "메릴 펠스톰을 도와 공포의 군주 카트라나티르와 싸워야 합니다.", "Ajude Meryl Tempestavil a combater o senhor do medo Kathra'natir.", "Помогите Мерилу Буре Скверны в бою с повелителем ужаса Катра'натиром.", "帮助梅瑞尔·邪风对抗恐惧魔王卡萨纳提尔", "協助莫爾‧魔風作戰，攻擊驚懼領主卡斯拉納提爾。", }, 
{ "Destroy the Siphoning Rifts that are draining the Forge of the Guardian of its power.", "Vernichtet die entziehenden Risse, die die Energie der Schmiede des Wächters absaugen.", "Acaba con las fallas succionadoras que están drenando el poder de la Forja del Guardián.", "Destruye las fallas de succión que le están quitando su poder a La Forja del Guardián.", "Détruisez les failles siphons qui drainent la puissance de la Forge du Gardien.", "Distruggi le Fenditure Risucchianti che stanno assorbendo il potere della Forgia del Guardiano.", "수호자의 가열로의 힘을 흡수하고 있는 흡수의 균열을 파괴해야 합니다.", "Destrua as Fissuras Sifonantes que drenam o poder da Forja do Guardião.", "Уничтожьте вытягивающие разломы, которые похищают силу Горнила Хранителя.", "摧毁正在吸取守护者熔炉之力的虹吸裂隙。", "消滅正在吸取守護者熔爐力量的虹吸裂隙。", }, 
{ "Activate the Forge of the Guardian.", "Aktiviert die Schmiede des Wächters.", "Activa la Forja del Guardián.", "Activa la Forja del Guardián.", "Activez la Forge du Gardien.", "Attiva la Forgia del Guardiano.", "수호자의 가열로를 활성화해야 합니다.", "Ative a Forja do Guardião.", "Активируйте Горнило Хранителя.", "激活守护者熔炉。", "啟動守護者熔爐。", }, 
{ "Use the power granted by the Forge of the Guardian to defeat Kathra'natir.", "Benutzt die von der Schmiede des Wächters gewährte Kraft, um Kathra'natir zu bezwingen.", "Usa el poder que te ha otorgado la Forja del Guardián para derrotar a Kathra'natir.", "Usa el poder que te otorga la Forja del Guardián para derrotar a Kathra'natir.", "Utilisez la puissance conférée par la Forge du Gardien pour vaincre Kathra’natir.", "Usa il potere fornito dalla Forgia dei Guardiani per sconfiggere Kathra'natir.", "수호자의 가열로에서 얻은 힘으로 카트라나티르를 처치해야 합니다.", "Use o poder concedido pela Forja do Guardião para derrotar Kathra'natir.", "Воспользуйтесь силой, дарованной вам Горнилом Хранителя, чтобы сразить Катра'натира.", "使用守护者熔炉的力量击败卡萨纳提尔。", "使用守護者熔爐賦予的力量擊敗卡斯拉納提爾。", }, 
{ "Listen to Meryl Felstorm.", "Hört Meryl Teufelssturm zu.", "Escucha a Meryl Tormenta Vil.", "Escucha a Meryl Tormenta Vil.", "Écouter Meryl Gangrorage.", "Ascolta Meryl Viltempesta.", "메릴 펠스톰의 이야기를 들어야 합니다.", "Ouça o que Meryl Tempestavil tem a dizer.", "Выслушайте Мерила Бурю Скверны.", "听梅瑞尔·邪风讲话。", "聆聽莫爾‧魔風說的話。", }, 
{ "Help Meryl Felstorm and Alodi to transport the Forge of the Guardian to a safe location.", "Helft Meryl Teufelssturm und Alodi, die Schmiede des Wächters an einen sicheren Ort zu bringen.", "Ayuda a Meryl Tormenta Vil y Alodi a transportar la Forja del Guardián a un lugar seguro.", "Ayuda a Meryl Tormenta Vil a transportar la Forja del Guardián a una ubicación segura.", "Aidez Meryl Gangrorage et Alodi à transporter la Forge du Gardien en lieu sûr.", "Aiuta Meryl Viltempesta e Alodi a trasportare la Forgia dei Guardiani in un luogo sicuro.", "메릴 펠스톰과 알로디를 도와 수호자의 가열로를 안전한 곳으로 옮겨야 합니다.", "Ajude Meryl Tempestavil e Alodi a transportar a Forja do Guardião a um lugar seguro.", "Помогите Мерилу Буре Скверны и Алоди перенести Горнило Хранителя в безопасное место.", "帮助梅瑞尔·邪风和阿洛迪将守护者熔炉转移到安全地带。", "協助莫爾‧魔風和艾洛岱，將守護者熔爐運送到安全的地方。", }, 
},
["427"] = {
{ "Root out the corruption within Auchindoun.", "Beseitigt die Verderbnis in Auchindoun.", "Acaba con la corrupción en Auchindoun.", "Erradica la corrupción en Auchindoun.", "Débarrassez Auchindoun de la corruption.", "Sradica la corruzione all'interno di Auchindoun.", "아킨둔 안의 타락을 뿌리 뽑아야 합니다.", "Elimine a corrupção em Auchindoun.", "Искорените скверну в Аукиндоне.", "铲除奥金顿中的腐败。", "根除奧齊頓裡的腐化勢力。", }, 
},
["670"] = {
{ "Defeat the bosses of Upper City", "Bezwingt die Bosse des Oberen Viertels.", "Derrota a los jefes del Alto Arrabal.", "Derrota a los jefes de la Ciudad superior", "Triomphez des boss de la Ville haute.", "Sconfiggi i boss della Città Alta.", "상부 도시 우두머리들을 처치해야 합니다.", "Derrote os chefes da Cidade Alta", "Победите боссов в Верхнем Городе", "击败上层区的首领", "擊敗上城區的首領", }, 
},
["58"] = {
{ "Summon and defeat the mighty dragon turtle, Scar-Shell.", "Beschwört und bezwingt die mächtige Drachenschildkröte Narbenpanzer.", "Invoca y derrota a la poderosa tortuga dragón, Escaraza.", "Invoca y derrota a la poderosa tortuga dragón, Escaraza.", "Invoquez et terrassez la puissante tortue-dragon, Écaille-Balafrée.", "Evoca e sconfiggi Gamara, la possente testuggine draconica.", "용거북인 흉터껍질을 소환해 처치해야 합니다.", "Evoque e derrote Conchagas, a tartalisca-dragão potente.", "Призовите и одолейте могучую драконью черепаху Потертый Панцирь.", "召唤并击败强大的龙龟——刀疤壳。", "召喚並擊敗強大的龍龜疤殼!", }, 
{ "Summon and defeat the grummle-eating, snow-stalking horror, Jol'Grum.", "Beschwört und bezwingt den grummelfressenden, schneepirschenden Schrecken Jol'Grum.", "Invoca y derrota al horror comedor de grúmel y acechador de las nieves, Jol'Grum.", "Invoca y derrota al horror comedor de grúmel y acechador de las nieves, Jol'Grum.", "Invoquez et terrassez l’horreur qui rôde dans la neige et mange les grumelots, Jol’Grum.", "Evoca e sconfiggi il mangiagrumyan, conosciuto anche come l'Orrore delle Nevi, Jol'grum.", "그루멀을 잡아먹는 눈밭의 공포, 졸그럼을 소환해 처치해야 합니다.", "Evoque e derrote Jol'Grum, o abominável horror das neves que come grômulos.", "Призовите и одолейте грозу груммелей, снежного ужаса, Джол'Грума.", "召唤并击败土地精的梦魇、雪山的魔王——乔古鲁。", "召喚並擊敗專吃咕嚕摩的冰雪恐懼:悠格魯姆。", }, 
{ "Summon and defeat the playful fire spirit, Liuyang.", "Beschwört und bezwingt den verspielten Feuergeist, Liuyang.", "Invoca y derrota a la juguetona espíritu del fuego, Liuyang.", "Invoca y derrota a la juguetona espíritu del fuego, Liuyang.", "Invoquez et terrassez l’esprit du feu espiègle, Liuyang.", "Evoca e sconfiggi Liuyang, lo spirito giocoso del fuoco.", "장난기 넘치는 불의 정령인 꼬마 리우양을 소환해 처치해야 합니다.", "Evoque e derrote Liuyang, o espírito brincalhão do fogo.", "Призовите и одолейте игривого духа огня Люян.", "召唤并击败淘气的火灵——小流炀。", "召喚並擊敗好動的火靈，劉楊。", }, 
{ "Summon and defeat the wandering yaungol warrior, Chagan Firehoof.", "Beschwört und bezwingt den wandernden Yaungolkrieger Chagan Feuerhuf.", "Invoca y derrota al guerrero yaungol errante, Chagan Pezuña Ígnea.", "Invoca y derrota al guerrero yaungol errante, Chagan Pezuña Ígnea.", "Invoquez et terrassez le guerrier yaungol errant, Chagan Sabot-de-Feu.", "Evoca e sconfiggi il guerriero Yaungol errante, Chagan Ardizampa.", "방랑하는 야운골 전사 차간 파이어후프를 소환해 처치해야 합니다.", "Evoque e derrote Chagan Casco de Fogo, o guerreiro yaungol errante.", "Призовите и одолейте странствующего яунгола-воина Чагана Огненное Копыто.", "召唤并击败流浪的野牛人战士——查干·焰蹄。", "召喚並擊敗流浪的揚古戰士，查剛·火蹄。", }, 
{ "Summon and defeat the final challenger and then claim your reward from Wodin!", "Beschwört und bezwingt den letzten Herausforderer und holt Euch bei Wodin Eure Belohnung ab!", "Invoca y derrota al contendiente final y reclama tu recompensa a Wodin.", "Invoca y derrota al contendiente final y reclama tu recompensa a Wodin.", "Invoquez et terrassez l’adversaire final, puis réclamez votre récompense auprès de Wodin !", "Evoca e sconfiggi l'ultimo sfidante e rivendica la tua ricompensa da Wodin.", "마지막 도전자를 소환해 처치하고 우딘에게서 보상을 획득해야 합니다!", "Evoque e derrote o desafiante final e reivindique sua recompensa com Wodin!", "Вызовите и одолейте последнего противника и получите награду у Водина.", "召唤并击败最终的挑战者，然后向伍迪索要奖品！", "召喚並擊敗最後一位挑戰者，然後向烏丁領取獎賞!", }, 
},
["991"] = {
{ "The Twilight's Hammer has set up a temporary camp up here. Investigate the camp for clues.", "Der Schattenhammer hat hier ein temporäres Lager errichtet. Durchsucht das Lager nach Hinweisen.", "El Martillo Crepuscular ha establecido aquí un campamento provisional. Investiga el campamento en busca de pistas.", "El Martillo Crepuscular estableció un campamento temporal en este lugar. Investiga el campamento en busca de pistas.", "Le Marteau du crépuscule a établi un campement provisoire ici. Fouillez les lieux à la recherche d’indices.", "Il Martello del Crepuscolo ha allestito un accampamento temporaneo. Ispeziona il campo alla ricerca di indizi.", "황혼의 망치단이 이곳에 임시 야영지를 세웠습니다. 야영지를 조사하여 실마리를 찾아야 합니다.", "O Martelo do Crepúsculo estabeleceu um acampamento temporário aqui em cima. Investigue-o e veja o que pode descobrir.", "Культ Сумеречного Молота организовал здесь временный лагерь. Осмотрите лагерь в поисках подсказок.", "暮光之锤在这里建立了一处临时营地。调查营地中的线索。", "暮光之錘在這裡設立了臨時營地。調查這座營地，看看有沒有什麼線索。", }, 
{ "The cultists have entered a tomb complex at the bottom of the lake. The ritual must be happening in there.", "Die Kultisten haben einen Grabkomplex am Grunde des Sees betreten. Das Ritual muss dort stattfinden.", "Los cultores han entrado en un complejo funerario que hay en el fondo del lago. Deben de estar celebrando allí el ritual.", "Los cultores entraron a un complejo de tumbas situado en el fondo del lago. El ritual debe estar ocurriendo allí.", "Les sectateurs sont entrés dans un complexe funéraire au fond du lac. C’est à l’intérieur que doit se dérouler le rituel.", "I cultisti sono entrati in un complesso di tombe sul fondo del lago. È lì che il rituale si sta compiendo.", "이교도가 호수 바닥에 있는 무덤 구조물로 들어갔습니다. 그곳에서 의식을 치르려는 게 분명합니다.", "Os sectários entraram num complexo funerário no fundo do lago. O ritual deve estar acontecendo lá.", "Сектанты проникли в гробницу на дне озера. Очевидно, ритуал должен проводиться в ней.", "教徒们进入了湖底的一座墓穴中。他们一定是打算在那里举行仪式。", "教徒進入了湖泊底下的墓地。儀式場所一定就在那裡。", }, 
{ "The cultists have breached the tomb of an ancient titan keeper! Slay the guards and open the way into the complex.", "Die Kultisten haben das Grab eines uralten Titanenhüters geöffnet! Tötet die Wächter und macht den Weg in den Komplex frei.", "¡Los cultores han entrado en la tumba de un antiguo guardián de los titanes! Acaba con los guardias y ábrete camino hasta el complejo.", "¡Los cultores profanaron la tumba de un antiguo guardián titánico! Mata a los guardias y ábrete paso hacia el complejo.", "Les sectateurs ont violé la tombe d’un antique gardien titan ! Tuez les gardes et frayez-vous un chemin dans le complexe.", "I cultisti sono entrati nella tomba dell'antico guardiano dei Titani! Uccidi le guardie per accedere al complesso.", "이교도가 고대 티탄 수호자의 무덤에 침입했습니다! 수호병을 처치한 다음 무덤으로 들어가는 길을 열어야 합니다.", "Os sectários invadiram a tumba de um antigo guardião titânico! Mate os guarda e abra caminho até o complexo.", "Сектанты проникли в гробницу древнего хранителя титанов! Перебейте стражников и расчистите себе путь внутрь.", "邪教徒们攻占了一座古代泰坦守护者的墓穴！消灭那些卫兵，肃清通往墓穴的路。", "邪教徒已經闖入古老泰坦守衛者的陵墓！殺掉衛兵，開啟通往裡面的道路。", }, 
{ "Slaghammer knows the ritual is further inside. Enter the tomb room and deal with the cultists.", "Schlackenhammer weiß, dass das Ritual weiter drinnen stattfindet. Betretet die Grabkammer und kümmert Euch um die Kultisten.", "Martillo de Escoria sabe que el ritual es más adentro. Entra en la sala de la tumba y encárgate de los cultores.", "Martillo de escoria sabe que el ritual se encuentra aún más hacia el interior. Entra a la sala de la tumba y encárgate de los cultores.", "Martel-Scories sait que le rituel se déroule dans les profondeurs du complexe. Pénétrez dans la salle du tombeau et éliminez les sectateurs.", "Mazzascoria sa che il rituale si sta svolgendo in profondità. Entra nella tomba e occupati dei cultisti.", "슬래그해머는 의식이 더 깊은 곳에서 벌어지고 있음을 압니다. 방으로 들어가 이교도들을 처리해야 합니다.", "Skoriamalho sabe que o ritual acontece mais para dentro. Lide com os sectários na sala dos túmulos.", "Шлакомолот знает, где будет проведен ритуал. Войдите в гробницу и разберитесь с сектантами.", "熔锤知道，仪式位于更深处。进入墓室中解决邪教徒。", "渣錘知道儀式在更裡面的地方舉行。進入墓穴，解決教徒。", }, 
{ "Cultists are dampening the holy wards of the tomb. Dispel their defenses and kill the ritualists to break the barrier.", "Kultisten dämpfen die heiligen Zauberschutze des Grabes. Bannt ihre Verteidigungen und tötet die Ritualisten, um die Barriere zu durchbrechen.", "Los cultores están atenuando los resguardos sagrados de la tumba. Disipa sus defensas y mata a los ritualistas para romper la barrera.", "Los cultistas están degradando las protecciones sagradas de la tumba. Disipa sus defensas y mata a los ritualistas para romper la barrera.", "Des sectateurs compromettent les protections sacrées de la tombe. Neutralisez leurs défenses et tuez les ritualistes pour lever la barrière.", "I cultisti stanno distruggendo le guardie sacre della tomba. Dissolvi le loro difese e uccidi i cultisti per spezzare la barriera.", "이교도가 무덤의 신성한 수호물을 약화시키고 있습니다. 그들의 방어를 무효화하고 보호막을 파괴하려는 의식술사를 처치해야 합니다.", "Sectários estão enfraquecendo as proteções sagradas da tumba. Dissipe as defesas deles e mate os ritualistas para romper a barreira.", "Сектанты ослабляют священные обереги гробницы. Рассейте их защиту и перебейте ритуалистов, чтобы убрать барьер.", "邪教徒正试图破解墓穴的神圣结界。清除他们的防御力量并消灭那些祭师以破坏屏障。", "教徒弱化了墓穴裡面的神聖結界。擋下他們的防禦，然後殺死祭儀師來解除屏障。", }, 
{ "The ritual has been thwarted but void energy remains! Defeat it!", "Das Ritual wurde verhindert, doch es bleibt Leerenenergie zurück! Bezwingt sie!", "¡El ritual se ha frustrado, pero la energía del Vacío permanece! ¡Derrótala!", "¡El ritual fue interrumpido, pero aún queda energía del vacío! ¡Destrúyela!", "Le rituel a été interrompu, mais l’énergie du Vide perdure ! Venez-en à bout !", "Il rituale è stato fermato, ma l'energia del Vuoto persiste! Distruggila!", "의식은 저지했지만, 공허의 에너지가 남아있습니다! 제거해야 합니다!", "O ritual foi impedido, mas a energia do caos permanece! Derrote-a!", "Ритуал сорван, но энергия Бездны еще не рассеяна! Покончите с ней!", "仪式被打断了，但虚空能量依然存留着！击败它！", "我們阻止了儀式，但是虛無能量還在！摧毀它！", }, 
{ "The way is open to the prison. Continue down the unsealed passage to whatever waits below.", "Der Weg zum Gefängnis ist frei. Begebt Euch tiefer in die entsiegelte Passage, was auch immer dort auf Euch wartet.", "El camino hacia la prisión está despejado. Sigue bajando por el pasadizo abierto y enfréntate a lo que te espera abajo.", "El camino está libre para la prisión. Continúa bajando por el camino que no está sellado hacia lo que sea que te espera ahí abajo.", "La voie de la prison est libre. Suivez le passage ouvert pour découvrir ce qui vous attend dans les profondeurs.", "La strada per la prigione è aperta. Continua lungo il passaggio e affronta ciò che ti attende.", "감옥으로 향하는 길이 열렸습니다. 무엇이 기다리고 있는지 알 수 없지만 계속 아래로 내려가야 합니다.", "O caminho está livre até a prisão. Siga a passagem aberta até o que quer que aguarde abaixo.", "Путь в темницу свободен. Идите по открывшемуся проходу навстречу своей судьбе.", "通往监狱的道路敞开了。沿着解封的道路继续前进，迎接下面潜伏的危险。", "通往監獄的道路敞開了。繼續沿著開放的通道往下，迎接底下的挑戰。", }, 
{ "The Twilight Deacon is trying to bring the killer of Tyr back to life! Stop him!", "Der Zwielichtdiakon versucht, den Mörder von Tyr zurück ins Leben zu rufen! Haltet ihn auf!", "¡El diácono Crepuscular está tratando de devolverle la vida al asesino de Tyr! ¡Detenlo!", "¡El Diácono del Crepúsculo intenta resucitar al asesino de Tyr! ¡Deténlo!", "Le diacre du Crépuscule essaie de ressusciter l’assassin de Tyr ! Arrêtez-le !", "Il Diacono del Crepuscolo sta cercando di riportare in vita l'assassino di Tyr! Devi fermarlo.", "황혼의 부제가 티르를 죽인 존재를 다시 살리려고 합니다! 그를 막아야 합니다!", "O Diácono do Crepúsculo tenta fazer o assassino de Tyr voltar à vida! Detenha-o!", "Сумеречный Дьякон пытается вернуть к жизни убийцу Тира! Остановите его!", "暮光执事正试图复活那些杀死提尔的怪物们！阻止他！", "暮光執事企圖復活殺死提爾的怪物！阻止他！", }, 
{ "With the Deacon dead the blade is now yours. Take it.", "Mit dem Tod des Diakons ist die Klinge Euer. Nehmt sie.", "Tras la muerte del diácono, la daga es tuya. Cógela.", "Ahora que el Diácono está muerto, la espada es tuya. Tómala.", "À présent que le diacre est mort, la lame est à vous. Prenez-la.", "Con la morte del Diacono, la lama è finalmente tua. Prendila.", "부제가 죽었으니 비수는 이제 당신의 것입니다. 손에 넣으십시오.", "Com o Diácono morto, a lâmina é sua. Pegue-a.", "Теперь, когда с Дьяконом покончено, клинок ваш. Заберите его.", "暮光执事已死，黑暗帝国之刃是你的了。拿起它。", "暮光執事已死，這把刀刃是你的了。拿起它。", }, 
{ "The C'Thraxxi general is still a threat. Use the Blade to kill it forever.", "Der General der C'Thraxxi stellt immer noch eine Bedrohung dar. Benutzt die Klinge, um ihn für immer auszuschalten.", "El general C'Thraxxi sigue siendo una amenaza. Usa la daga para matarlo para siempre.", "El general C'Thraxxi sigue siendo una amenaza. Usa la Espada para ponerle fin a su vida.", "Le général c’thraxxi représente toujours une menace. Utilisez la lame pour le tuer à jamais.", "Il generale dei C'thraxi rappresenta ancora una minaccia. Usa la Lama per ucciderlo una volta per tutte.", "크트락시 장군은 여전히 위협입니다. 검을 사용해 완전히 끝장내야 합니다.", "O general C'Thraxxi ainda é uma ameaça. Dê-lhe um fim definitivo, com a lâmina.", "Генерал К'Тракси все еще представляет собой угрозу. Используйте клинок, чтобы уничтожить тварь раз и навсегда.", "这名克拉西斯将军依然具有威胁。使用匕首将它永远杀死。", "克蘇拉希將軍未來仍可能對我們造成威脅。我們必須使用匕首，確保它徹底死亡。", }, 
},
["269"] = {
{ "Learn how to run the noodle stand.", "Lernt, wie man den Nudelstand betreibt.", "Aprende a llevar el puesto de fideos.", "Aprende a llevar el puesto de fideos.", "Apprenez à diriger le stand de nouilles.", "Impara a gestire il Chiosco degli Spaghetti.", "국수 포장마차 운영법을 배워야 합니다.", "Aprenda a administrar a barraquinha de macarrão.", "Научиться управляться со стойкой c лапшой.", "学习如何经营面档。", "學會如何經營拉麵攤。", }, 
{ "Seat and serve the customers as they show up. Don't let 5 patrons get away without being served.", "Weist den eintreffenden Gästen Sitze zu und bedient sie. Lasst nicht zu, dass 5 Gäste gehen, ohne bedient worden zu sein.", "Sienta y sirve a los clientes a medida que vengan. No dejes que 5 parroquianos se marchen sin servirles.", "Sienta y sirve a los clientes a medida que vengan. No dejes que 5 parroquianos se marchen sin servirles.", "Faites asseoir puis servez les clients au fur et à mesure qu’ils arrivent. Ne laissez pas plus de cinq clients partir sans avoir été servis.", "Fai sedere e servi i clienti man mano che arrivano. Non farne allontanare più di 5 prima di averli serviti.", "손님이 오면 자리를 마련하고 요리를 대접해야 합니다. 5명 이상의 손님이 대접받지 못한 채 떠나지 않게 해야 합니다.", "Acomode e sirva os fregueses à medida que forem chegando. Não deixe 5 cidadãos irem embora sem serem servidos.", "Рассаживайте клиентов и обслуживайте их. Не дайте 5 клиентам уйти, не дождавшись, пока их обслужат.", "在客人出现后招呼他们落座并为其上菜。因受冷落而离开的客人不能超过5个。", "讓登門的客人就座並送上餐點。別讓5名以上的客人還沒用餐就離開。", }, 
},
["628"] = {
{ "Defeat the bosses within Mana-Tombs", "Bezwingt die Bosse in der Managruft.", "Derrota a los jefes de las Tumbas de Maná.", "Derrota a los jefes en las Tumbas de Maná.", "Terrassez les boss de Tombes-mana.", "Sconfiggi i boss delle Tombe del Mana.", "마나 무덤 우두머리들을 처치해야 합니다.", "Derrote os chefes das Tumbas de Mana", "Победите боссов в Гробницах Маны", "击败法力陵墓的首领", "擊敗法力墓地的首領", }, 
},
["1281"] = {
{ "Gain entrance to Black Rook Hold through the landing.", "Verschafft Euch über die Landestelle Zutritt zur Rabenwehr.", "Consigue entrar en el Torreón Grajo Negro a través del rellano.", "Accede al Fuerte Torre oscura a través del alto.", "Accédez au bastion du Freux via le hall.", "Accedi al Forte Corvonero attraverso l'approdo.", "층계참을 지나 검은 떼까마귀 요새로 들어가는 입구를 확보해야 합니다.", "Entre no Castelo Corvo Negro pela plataforma.", "Пробейтесь в крепость Черной Ладьи.", "通过平台进入黑鸦堡垒。", "經由平臺前往玄鴉堡入口。", }, 
{ "Commander Thorn is inside Black Rook Hold. Follow Jarod Shadowsong into the depths of the hold to find your foe.", "Kommandant Dorn befindet sich in der Rabenwehr. Folgt Jarod Schattensang in die Tiefen der Burg, um Euren Feind zu finden.", "El comandante Espina está en el Torreón Grajo Negro. Sigue a Jarod Cantosombrío hasta sus profundidades para encontrar a tu enemigo.", "El comandante Espina se encuentra dentro del Fuerte Torre oscura. Sigue a Jarod Cantosombrío hacia las profundidades del fuerte para encontrar a tu enemigo.", "Le commandant Erdris Épine se cache dans le bastion du Freux. Suivez Jarod Chantelombre dans les profondeurs de la forteresse pour débusquer votre ennemi.", "Il Comandante Thorn si è nascosto nel Forte Corvonero. Segui Jarod Cantombroso nelle profondità del Forte per trovare il tuo nemico.", "사령관 쏜이 검은 떼까마귀 요새 안에 있습니다. 제로드 섀도송을 따라 요새 깊숙한 곳으로 들어가 적을 찾아야 합니다.", "O Comandante Cardo está dentro do Castelo Corvo Negro. Siga Jared Cantonegro até as profundezas do castelo e encontre seu inimigo.", "Командир Торн обосновался в крепости Черной Ладьи. Следуйте за Джеродом Песнью Теней и найдите врага.", "指挥官索恩就在黑鸦堡垒里。跟随加洛德·影歌深入堡垒，找到敌人。", "刺棘指揮官在玄鴉堡內。跟著亞羅德‧影歌深入堡內找出你的敵人。", }, 
{ "Your allies have been captured! Rescue them before their souls are corrupted!", "Eure Verbündeten wurden gefangen genommen! Rettet sie, bevor ihre Seelen verderbt werden!", "¡Han capturado a tus aliados! ¡Rescátalos antes de que sus almas se corrompan!", "¡Han capturado a tus aliados! ¡Rescátalos antes de que corrompan sus almas!", "Vos alliés ont été capturés ! Sauvez-les avant que leurs âmes ne soient corrompues !", "I tuoi alleati sono stati catturati! Salvali prima che la loro anima venga corrotta!", "아군들이 붙잡혔습니다! 그들의 영혼이 타락하기 전에 구출해야 합니다!", "Os seus aliados foram capturados! Resgate-os antes que a alma deles seja corrompida!", "Ваши союзники захвачены в плен! Освободите пленников, пока их души не поддались порче!", "你的盟友被俘了！在他们的灵魂被腐蚀前救出他们！", "你的盟友被抓了！在他們的靈魂被腐化之前解救他們！", }, 
{ "Your allies seem injured but will move on your command.", "Eure Verbündeten scheinen verletzt zu sein, folgen aber Eurem Befehl.", "Tus aliados parecen heridos, pero avanzarán a tu señal.", "Tus aliados parecen estar heridos pero se moverán si les das la orden.", "Malgré leurs blessures, vos alliés obéiront à vos ordres.", "I tuoi alleati sono feriti, ma si muoveranno al tuo comando.", "동료들이 부상을 당한 듯하나 당신의 명령에 움직일 것입니다.", "Os seus aliados parecem feridos, mas obedecerão às suas ordens.", "Ваши союзники ранены, но способны стоять на ногах и ждут вашей команды.", "你的盟友似乎受伤了，但还能听你指挥。", "你的盟友似乎受傷了，但還是會聽你的指令行動。", }, 
{ "Your allies have gone mad! Save them from each other while stopping Erdris from raising an army of souls.", "Eure Verbündeten sind wahnsinnig geworden! Beschützt sie voreinander und verhindert, dass Erdris eine Seelenarmee aufstellt.", "¡Tus aliados se han vuelto locos! Salva a los unos de los otros mientras evitas que Erdris resucite un ejército de almas.", "¡Tus aliados han enloquecido! Sálvalos de atacarse entre sí mientras impides que Erdris cree un ejército de almas.", "Vos alliés ont perdu la tête ! Empêchez-les de s’entretuer et empêchez Erdris de lever une armée de ressuscités.", "I tuoi alleati sono impazziti! Fermali prima che si uccidano a vicenda e impedisci a Erdris di creare un esercito di anime.", "동료들이 미쳐 버렸습니다! 에르드리스가 영혼의 군대를 일으키지 못하도록 막으면서, 동료들을 서로에게서 구해야 합니다.", "Os seus aliados enlouqueceram! Salve-os uns dos outros e, ao mesmo tempo, impeça Erdris de erguer um exército de almas.", "Ваши союзники впали в безумие! Не дайте им перебить друг друга и помешайте Эрдрису создать армию душ.", "你的盟友们发疯了！阻止他们自相残杀，并阻止艾德里斯复活幽灵大军。", "你的盟友瘋了！別讓他們自相殘殺，也別讓厄德里斯建立亡靈部隊。", }, 
{ "Erdris has commanded his soldiers to Rise. Defeat them!", "Erdris hat seinen Soldaten befohlen, sich zu erheben. Besiegt sie!", "Erdris ha ordenado a sus soldados que se alcen. ¡Derrótalos!", "Erdris les ha ordenado a sus soldados que se levanten. ¡Derrótalos!", "Erdris a ressuscité ses soldats. Tuez-les une nouvelle fois !", "Erdris ha ordinato ai suoi soldati di risorgere. Sconfiggili!", "에르드리스가 병사들에게 되살아나라고 명령했습니다. 병사들을 쓰러뜨려야 합니다!", "Erdris ordenou que seus soldados se erguessem. Derrote-os!", "Эрдрис приказал своим воинам восстать. Победите их!", "艾德里斯复活了他的士兵。击败他们！", "厄德里斯讓他的士兵復活。擊敗他們！", }, 
{ "Slay Erdris Thorn.", "Tötet Erdris Dorn.", "Acaba con lord Erdris Espina.", "Mata a Erdris Espina.", "Tuez Erdris Épine.", "Uccidi Erdris Rovospina.", "에르드리스 쏜을 처치해야 합니다.", "Mate Erdris Cardo.", "Убейте Эрдриса Тернового Шипа.", "击杀艾德里斯·索恩。", "殺死厄德里斯‧刺棘。", }, 
},
["68"] = {
{ "Find Scholar Shue.", "Findet die Gelehrte Shue.", "Encuentra a la erudita Shue.", "Encuentra a la erudita Shue.", "Trouvez l’érudite Shue.", "Trova la Studiosa Shue.", "학자 슈에를 찾아야 합니다.", "Encontre a Erudita Shue.", "Исследовательница Шуэ", "找到学者舒卫。", "找到學者舒業。", }, 
{ "Rescue the captured Golden Lotus expedition.", "Rettet die Gefangenen der Expedition des Goldenen Lotus.", "Rescata a la expedición capturada de El Loto Dorado.", "Rescata a la expedición capturada de El Loto Dorado.", "Sauvez l’expédition du Lotus doré capturée.", "Salva i membri catturati della spedizione del Loto Dorato.", "생포당한 황금 연꽃 원정대를 구출해야 합니다.", "Resgate os membros da expedição do Lótus Dourado capturados.", "Освободите пленных членов экспедиции Золотого Лотоса.", "营救被抓的金莲教远征队。", "救出被捕的金蓮會成員。", }, 
{ "Stop Lorewalker Fu's execution.", "Haltet die Hinrichtung von Lehrensucher Fu auf.", "Detén la ejecución del eremita Fu.", "Detén la ejecución del eremita Fu.", "Empêchez l’exécution du chroniqueur Fu.", "Impedisci l'esecuzione del Ramingo della Sapienza Fu.", "전승지기 푸의 사형을 저지해야 합니다.", "Impeça a execução do Andarilho das Lendas Fu.", "Остановите казнь хранителя истории Фу.", "阻止游学者福云被处死。", "阻止處決博學行者阿傅。", }, 
{ "Defeat the defenders of the four ancient Mogu artifacts.", "Bezwingt die Verteidiger der vier uralten Moguartefakte.", "Derrota a los defensores de los cuatro artefactos mogu antiguos.", "Derrota a los defensores de los cuatro artefactos mogu antiguos.", "Venez à bout des défenseurs des quatre artéfacts mogu antiques.", "Sconfiggi i difensori dei quattro Manufatti dei Mogu.", "네 개의 모구 유물을 지키는 수호자들을 처치해야 합니다.", "Derrote os defensores dos quatro artefatos mogu ancestrais.", "Победите защитников четырех древних реликвий могу.", "击败守护四个古代魔古神器的守护者。", "擊敗四個遠古魔古神器的守護者。", }, 
{ "Defeat General Zhun, Herald of the Thunder King.", "Bezwingt General Zhun, Herold des Donnerkönigs.", "Derrota al general Zhun, heraldo del Rey del Trueno.", "Derrota al general Zhun, heraldo del Rey del Trueno.", "Terrassez le général Zhun, héraut du roi-tonnerre.", "Sconfiggi il Generale Zhun, Alfiere del Re del Tuono.", "천둥왕의 사자인 장군 준을 처치해야 합니다.", "Derrote o General Zhun, o Arauto do Rei Trovão", "Убейте генерала Чжуня, вестника Властелина Грома.", "击败雷电之王的传令官——烛桓将军。", "殺死曾將軍，雷王的先鋒大將。", }, 
},
["667"] = {
{ "Defeat the bosses of the Gordok Commons", "Bezwingt die Bosse der Gordokhallen.", "Derrota a los jefes del Ágora de Gordok", "Derrota a los jefes de la Ágora de Gordok", "Triomphez des boss des Communs gordok.", "Sconfiggi i boss delle Sale di Gordok.", "고르독 광장 우두머리들을 처치해야 합니다.", "Derrote os chefes do Pátio Gordok", "Победите боссов в палатах Гордока", "击败戈多克议会的首领", "擊敗戈多克平民區的首領", }, 
{ "Defeat Stomper Kreeg", "Bezwingt Stampfer Kreeg", "Derrota al vapuleador Kreeg", "Derrotar a Vapuleador Kreeg", "Triomphez de Kreeg le Marteleur.", "Sconfiggi Kreeg il Pestatore.", "천둥발 크리그를 처치해야 합니다.", "Derrote o Pisoteador Kreeg", "Победите Топотуна Крига", "击败践踏者克雷格", "擊敗踐踏者克雷格", }, 
{ "Defeat Cho'Rush the Observer", "Bezwingt Cho'Rush den Beobachter", "Derrota a Cho'Rush el Observador", "Derrota a Cho'Rush el Observador", "Triomphez de Cho’Rush l’Observateur.", "Sconfiggi Cho'rush l'Osservatore.", "정찰병 초루쉬를 처치해야 합니다.", "Derrote Ez'Magg, o Observador", "Победите Чо'Раша Наблюдателя", "击败观察者克鲁什", "擊敗『觀察者』克魯什", }, 
},
["1289"] = {
{ "Return to Karazhan and defeat the tower inhabitants.", "Kehrt nach Karazhan zurück und besiegt die Bewohner des Turms.", "Vuelve a Karazhan y derrota a los habitantes de la torre.", "Regresa a Karazhan y derrota a los habitantes de la torre.", "Retournez à Karazhan et terrassez les habitants des tours.", "Torna a Karazhan e sconfiggi gli abitanti della torre.", "카라잔으로 돌아가 탑의 거주자들을 처치해야 합니다.", "Retorne a Karazhan e derrote os ocupantes da torre.", "Вернитесь в Каражан и одолейте обитателей башни.", "重返卡拉赞，并击败塔楼内的居民。", "回到卡拉贊擊倒高塔中的敵人。", }, 
},
["184"] = {
{ "Join up with Daggin Windbeard.", "Schließt Euch Daggin Windbart an.", "Únete a Daggin Barbaviento.", "Únete a Daggin Barbaviento.", "Rejoignez Daggin Barbe-du-Vent.", "Raggiungi Daggin Barbariosa.", "대긴 윈드비어드와 합류해야 합니다.", "Junte-se a Daggin Barba ao Vento.", "Примите в отряд Даггина Ветроборода.", "与达金·风须汇合。", "加入達金·風鬚。", }, 
{ "Fight your way through the docks to Admiral Taylor.", "Kämpft Euch durch die Gegner bis zu Admiral Taylor auf den Docks.", "Ábrete paso a través de los muelles hasta el almirante Taylor.", "Ábrete paso a través de los muelles hasta el almirante Taylor.", "Frayez-vous un chemin sur les quais jusqu’à l’amiral Taylor.", "Apriti la strada sui moli fino all'Ammiraglio Taylor.", "부두에서 적을 처치해가며 길을 확보해 제독 테일러에게 가야 합니다.", "Abra caminho pelas docas e chegue até o Almirante Taylor.", "Пробейтесь к пристани, где находится адмирал Тейлор.", "杀进码头，去找海军上将泰勒。", "奮戰穿越碼頭去找泰勒上將。", }, 
{ "Defeat the Horde forces assaulting the keep.", "Besiegt die Streitkräfte der Horde, die die Burg angreifen.", "Derrota a las fuerzas de la Horda que asaltan el bastión.", "Derrota a las fuerzas de la Horda que asaltan el bastión.", "Terrassez les troupes de la Horde prenant d’assaut le donjon.", "Sconfiggi le forze dell'Orda che assaltano il forte.", "요새를 공격하는 호드 병력을 처치해야 합니다.", "Derrote as forças da Horda que estão atacando a fortaleza.", "Одержите победу над силами Орды, атакующими крепость.", "击败攻打要塞的部落部队。", "打敗攻擊要塞的部落軍隊。", }, 
{ "Locate High Marshal Twinbraid and help repel the Horde assault.", "Findet Hochmarschall Doppelzopf und helft dabei, den Angriff der Horde abzuwehren.", "Localiza al alto mariscal Trenzado y ayuda a repeler el asalto de la Horda.", "Localiza al alto mariscal Trenzado y ayuda a repeler el asalto de la Horda.", "Retrouvez le haut maréchal Doublenattes et aidez-le à repousser l’attaque de la Horde.", "Trova il Gran Maresciallo Trecciadoppia e aiutalo a respingere l'assalto dell'Orda.", "대장군 트윈브레이드를 찾아 호드의 공격을 격퇴해야 합니다.", "Localize o Grão-marechal Duas-tranças e ajude a repelir o ataque da Horda.", "Найдите Верховного маршала Двукоссу и помогите отразить нападение Орды.", "找到大元帅双辫并帮忙击退部落的袭击。", "找到大元帥塔文布萊德並幫忙擊退入侵的部落。", }, 
{ "Gather information from the SI:7 team.", "Erlangt Informationen von den Agenten des SI:7.", "Reúne información del equipo del IV:7.", "Reúne información del equipo del IV:7.", "Rassemblez des informations sur l’équipe du SI:7.", "Raccogli informazioni dalla squadra dell'IR:7.", "SI:7에서 정보를 입수해야 합니다.", "Colete informações com a equipe da AVIN.", "Получите информацию от команды ШРУ.", "从军情七处队伍中收集情报。", "從軍情七處小隊那裡收集資訊。", }, 
{ "Set up Sully's weapons and prepare to defend the keep!", "Macht Sullys Waffen bereitet und wappnet Euch für die Verteidigung der Burg!", "¡Monta las armas de Sully y prepárate para defender el bastión!", "¡Monta las armas de Sully y prepárate para defender el bastión!", "Installez les armes de Sully et préparez-vous à défendre le donjon !", "Piazza gli armamenti di Sully e prepara la difesa del forte!", "설리의 무기를 설치하고 요새를 방어할 준비를 해야 합니다!", "Prepare as armas de Sully e prepare-se para defender a fortaleza!", "Установите орудия Салли и приготовьтесь защищать крепость!", "组装苏利的武器并准备守卫要塞！", "準備好蘇利的武器，等著保衛要塞!", }, 
{ "Hold the keep against waves of Horde invaders and their commander.", "Verteidigt die Burg gegen die Angriffswellen der Horde und ihren Kommandanten.", "Protege el bastión contra las oleadas de invasores de la Horda y su comandante.", "Protege el bastión contra las oleadas de invasores de la Horda y su comandante.", "Tenez le château en repoussant les vagues d’envahisseurs de la Horde et leur commandant.", "Proteggi il forte da numerose ondate di invasori dell'Orda e dal loro comandante.", "호드 병사들 및 사령관의 공격에서 요새를 지켜내야 합니다.", "Proteja a fortaleza contra as ondas de invasores da Horda e seu comandante.", "Защитите крепость от атаки Орды и возглавляющего ее командира.", "守住堡垒，击退部落入侵者及其指挥官。", "保衛要塞抵抗源源不絕的部落入侵者與他們的指揮官。", }, 
},
["641"] = {
{ "Defeat the bosses of the Deadmines.", "Bezwingt die Bosse der Todesminen.", "Derrota a los jefes de Las Minas de la Muerte.", "Derrota a los jefes de las Minas de la Muerte.", "Triomphez des boss des Mortemines.", "Sconfiggi i boss delle Miniere della Morte.", "죽음의 폐광 우두머리들을 처치해야 합니다.", "Derrote os chefes das Minas Mortas.", "Победите боссов в Мертвых копях.", "击败死亡矿井的首领。", "擊敗死亡礦坑的首領。", }, 
},
["685"] = {
{ "Disrupt the Iron Horde's naval forces.", "Stört die Operationen der Seestreitkräfte der Eisernen Horde.", "Desestabiliza las fuerzas navales de la Horda de Hierro.", "Interrumpe a las fuerzas navales de la Horda de Hierro.", "Mettez en déroute les troupes navales de la Horde de Fer.", "Distruggi le forze navali dell'Orda di Ferro.", "강철 호드 해군에 타격을 입혀야 합니다.", "Desbarate as forças navais da Horda de Ferro.", "Помешайте флоту Железной Орды.", "干扰钢铁部落的海军部队。", "破壞鋼鐵部落的海軍部隊。", }, 
},
["449"] = {
{ "Fight your way to the back gates and defeat Arnokk the Burner.", "Kämpft Euch bis zum hinteren Tor durch und bezwingt Arnokk den Brenner.", "Ábrete camino hasta las puertas traseras y derrota a Arnokk el Quemador.", "Ábrete paso hasta las puertas traseras y derrota a Arnokk el Abrasador.", "Frayez-vous un chemin jusqu’aux portes arrières et terrassez Arnokk le Brûleur.", "Apriti la strada attraverso la porta posteriore e sconfiggi Arnokk il Piromane.", "뒷문까지 전진하여 방화광 아르노크를 처치해야 합니다.", "Abra caminho lutando até os portões dos fundos e derrote Arnokk, o Incendiário.", "Пробейтесь к задним вратам и победите Арнокка Сжигателя.", "闯到后门处并击败炽燃者阿诺克。", "殺至後門並擊敗『燃燒者』阿諾克。", }, 
{ "Fight your way to the Karabor Harbor", "Kämpft Euch bis zum Hafen von Karabor durch.", "Ábrete camino hasta el Puerto de Karabor.", "Ábrete paso hasta el Puerto de Karabor", "Frayez-vous un chemin jusqu’au port de Karabor.", "Apriti la strada fino al Porto di Karabor.", "카라보르 항만까지 전진해야 합니다.", "Abra caminho lutando até o Porto de Karabor.", "Пробейтесь к гавани Карабора.", "闯入卡拉波港口", "一路殺進卡拉伯爾港", }, 
{ "Protect K'ara until it becomes fully empowered.", "Beschützt K'ara, bis er vollständig Macht angesammelt hat.", "Protege a K'ara hasta que esté completamente potenciado.", "Defiende a K'ara hasta que esté completamente potenciada.", "Protégez K’ara jusqu’à ce qu’il atteigne sa puissance maximale.", "Proteggi K'ara finché non è completamente potenziato.", "크아라의 힘이 완전해질 때까지 보호해야 합니다.", "Proteja K'ara até ele ficar completamente fortalecido.", "Защищайте К'ару, пока он не обретет полную силу.", "保护卡拉，直至其充能完毕。", "在卡拉完全強化之前保護它。", }, 
{ "Stop the Bombardment of Karabor!", "Haltet die Bombardierung Karabors auf!", "¡Detén el bombardeo de Karabor!", "¡Detén el bombardeo de Karabor!", "Mettez fin au bombardement de Karabor !", "Ferma il bombardamento su Karabor!", "카라보르 폭격을 막아야 합니다!", "Pare o bombardeio de Karabor!", "Остановите бомбардировку Карабора!", "阻止针对卡拉波的轰炸！", "阻止卡拉伯爾轟炸！", }, 
},
["584"] = {
{ "Defeat the bosses within the Halls of Stone", "Besiegt die Bosse in den Hallen des Steins.", "Derrota a los jefes dentro de las Cámaras de Piedra.", "Derrota a los jefes en las Cámaras de Piedra.", "Terrassez les boss des salles de Pierre.", "Sconfiggi i boss delle Sale della Pietra.", "돌의 전당 우두머리들을 처치해야 합니다.", "Derrote os chefes nos Salões Rochosos", "Победите боссов в Чертогах Камня", "击败岩石大厅的首领", "擊敗石之大廳的首領", }, 
},
["649"] = {
{ "Defeat Mekgineer Thermaplugg.", "Bezwingt Robogenieur Thermadraht.", "Derrota al mekigeniero Termochufe.", "Derrota al mekigeniero Termochufe.", "Vaincre le mekgénieur Thermojoncteur.", "Sconfiggi il Mekgeniere Termospin.", "기계박사 텔마플러그를 처치해야 합니다.", "Derrote o Mecangenheiro Termaplugue.", "Убейте анжинера Термоштепселя.", "击败机械师瑟玛普拉格。", "擊敗機電師瑟瑪普拉格。", }, 
{ "Defeat Grubbis.", "Bezwingt Grubbis.", "Derrota a Grubbis.", "Derrota a Grubbis", "Triomphez de Grubbis.", "Sconfiggi Grubbis.", "그루비스를 처치해야 합니다.", "Derrote Grúdio.", "Победите Грязнюка.", "击败格鲁比斯。", "擊敗格魯比斯。", }, 
{ "Defeat Viscous Fallout.", "Bezwingt die verflüssigte Ablagerung.", "Derrota al radiactivo viscoso.", "Derrota a Radiactivo viscoso.", "Triomphez de la Retombée visqueuse.", "Sconfiggi la Scoria Viscosa.", "방사성 폐기물을 처치해야 합니다.", "Derrote a Precipitação Radioativa Viscosa.", "Победите Липкую муть.", "击败粘性辐射尘。", "擊敗黏性輻射塵。", }, 
{ "Defeat Electrocutioner 6000.", "Bezwingt den Elektrokutor 6000.", "Derrota al Electrocutor 6000.", "Derrota a Electrocutor 6000.", "Triomphez de l’Électrocuteur 6000.", "Sconfiggi Elettrocuz 6000.", "기계화 문지기 6000을 처치해야 합니다.", "Derrote o Eletrocutor 6000.", "Победите \"Электрошокер-6000\"", "击败电刑器6000型。", "擊敗電刑器6000型。", }, 
{ "Defeat Crowd Pummeler 9-60.", "Bezwingt den Meuteverprügler 9-60.", "Derrota al Golpeamasa 9-60.", "Derrota a Golpeamasa 9-60.", "Triomphez du Faucheur de foule 9-60.", "Sconfiggi il Pungolatore 9-60.", "고철 압축기 9-60을 처치해야 합니다.", "Derrote o Espanca-gente 9-60.", "Победите \"Толпогон 9-60\"", "击败群体打击者9-60。", "擊敗群體打擊者9-60。", }, 
},
["1157"] = {
{ "Speak with Darion Mograine.", "Sprecht mit Darion Mograine.", "Habla con Darion Mograine.", "Habla con Darion Mograine.", "Parlez à Darion Mograine.", "Parla con Darion Mograine.", "다리온 모그레인과 대화해야 합니다.", "Fale com Dárion Mograine.", "Поговорите с Дарионом Могрейном.", "和达里安·莫格莱尼谈谈。", "跟達瑞安·莫格萊尼交談。", }, 
{ "Prepare for the invasion of Light's Hope Chapel.", "Bereitet Euch auf die Invasion der Kapelle des Hoffnungsvollen Lichts vor.", "Prepárate para la invasión de la Capilla de la Esperanza de la Luz.", "Prepárate para la invasión de la Capilla de la Esperanza de la Luz.", "Préparez-vous à l’invasion de la chapelle de l’Espoir de Lumière.", "Preparati all'invasione della Cappella della Luce.", "희망의 빛 예배당 침공을 준비해야 합니다.", "Prepare-se para a invasão à Capela Esperança da Luz.", "Подготовьтесь к вторжению в часовню Последней Надежды.", "准备入侵圣光之愿礼拜堂。", "準備入侵聖光之願禮拜堂。", }, 
{ "Speak with Highlord Darion Mograine to begin the invasion.", "Sprecht mit Hochlord Darion Mograine, um mit der Invasion zu beginnen.", "Habla con el alto señor Darion Mograine para iniciar la invasión.", "Habla con el Alto señor Darion Mograine para comenzar la invasión.", "Parlez au généralissime Darion Mograine pour lancer l’invasion.", "Parla con il Gran Signore Darion Mograine per iniziare l'invasione.", "대영주 다리온 모그레인과 대화하여 침공을 시작해야 합니다.", "Fale com o Grão-lorde Dárion Mograine para iniciar a invasão.", "Поговорите с Верховным лордом Дарионом Могрейном, чтобы приступить к вторжению.", "和大领主达里安·莫格莱尼交谈来开始进军。", "跟大領主達瑞安·莫格萊尼交談，然後開始進攻。", }, 
{ "Raise the dead in the tomb behind Light's Hope Chapel.", "Erweckt die Toten in dem Grab hinter der Kapelle des Hoffnungsvollen Lichts.", "Resucita a los muertos en la tumba de detrás de la Capilla de la Esperanza de la Luz.", "Levanta a los muertos de la tumba detrás de la Capilla de la Esperanza de la Luz.", "Ranimez les morts du tombeau derrière la chapelle de l’Espoir de Lumière.", "Rianima i morti nella tomba dietro la Cappella della Luce.", "희망의 빛 예배당 뒤편의 무덤에서 망자를 일으켜야 합니다.", "Erga os mortos da tumba localizada atrás da Capela Esperança da Luz.", "Поднимите мертвецов в склепе под часовней Последней Надежды.", "复活圣光之愿礼拜堂后面的墓地中的亡者。", "在聖光之願禮拜堂後面的墓穴喚醒亡者。", }, 
{ "Meet with Highlord Darion Mograine in the Chapel.", "Trefft Euch mit Hochlord Darion Mograine in der Kapelle.", "Reúnete con el alto señor Darion Mograine en la Capilla.", "Reúnete con el Alto señor Darion Mograine en la Capilla.", "Retrouvez le généralissime Darion Mograine dans la chapelle.", "Incontra il Gran Signore Darion Mograine nella Cappella della Luce.", "예배당에서 대영주 다리온 모그레인과 만나야 합니다.", "Encontre o Grão-lorde Dárion Mograine na Capela.", "Встретьтесь с Верховным лордом Дарионом Могрейном в Часовне.", "在礼拜堂和和大领主达里安·莫格莱尼会面。", "在禮拜堂和大領主達瑞安·莫格萊尼見面。", }, 
{ "Fight your way to the Hall of Champions.", "Kämpft Euch zur Halle der Helden durch.", "Ábrete camino hasta la Sala de los Campeones.", "Ábrete paso hasta la Sala de los Campeones.", "Frayez-vous un chemin jusqu’au hall des Champions.", "Fatti strada verso il Salone dei Campioni.", "적을 처치하면서 용사의 전당까지 가야 합니다.", "Abra caminho, lutando, até o Salão dos Campeões.", "Пробейтесь в Чертог защитников.", "杀出一条血路，前往勇士大厅。", "設法進入勇士大廳。", }, 
{ "Defeat Lady Liadrin in the Hall of Champions.", "Bezwingt Lady Liadrin in der Halle der Helden.", "Derrota a lady Liadrin en la Sala de los Campeones.", "Derrota a Lady Liadrin en la Sala de los Campeones.", "Venez à bout de dame Liadrin dans le hall des Champions.", "Sconfiggi Dama Liadrin nel Salone dei Campioni.", "용사의 전당에서 여군주 리아드린을 꺾어야 합니다.", "Derrote Lady Liadrin no Salão dos Campeões.", "Победите леди Лиадрин в Чертоге защитников.", "在勇士大厅击败女伯爵莉亚德琳。", "在勇士大廳擊敗莉雅德倫女士。", }, 
{ "Open the Tomb of Tirion Fordring.", "Öffnet das Grabmal von Tirion Fordring.", "Abre la tumba de Tirion Vadín.", "Abre la tumba de Tirion Vadín.", "Ouvrez le tombeau de Tirion Fordring.", "Apri la Tomba di Tirion Fordring.", "티리온 폴드링의 무덤을 열어야 합니다.", "Abra a tumba de Tirion Fordring.", "Откройте гробницу Тириона Фордринга.", "打开提里奥·弗丁之墓", "開啟提里奧‧弗丁的墓穴。", }, 
},
["1283"] = {
{ "Challenge Damrul the Stronk to fight and defeat him.", "Fordert Damrul den Schtarken heraus und bezwingt ihn.", "Reta a Damrul el Forte a un combate y véncelo.", "Desafía a Damrul el Forzuto a una pelea y derrótalo.", "Défiez Damrouf le Kostau et remportez le combat.", "Sfida Damrul il Grozzo e sconfiggilo.", "힘센 담룰에게 도전하고 승리해야 합니다.", "Desafie Vitorbel, o Forti, para uma luta e derrote-o.", "Вызовите на бой и одолейте Дамрула Силача.", "挑战强壮的丹鲁尔并击败他。", "挑戰『強者』丹魯爾，與其戰鬥並擊敗他。", }, 
{ "Challenge Omanawkwa Steelhoof to fight and defeat him.", "Fordert Omanawkwa Stahlhuf heraus und bezwingt ihn.", "Desafía a Omanawkwa Pezuña de Acero a un combate y derrótalo.", "Desafía a Omanawkwa Pezuñacero a una pelea y derrótalo.", "Défiez Omanawkwa Sabot-d’Acier et remportez le combat.", "Sfida Omanawkwa Zoccolo Ferreo e sconfiggilo.", "오마노크와 스틸후프에게 도전하고 승리해야 합니다.", "Desafie Omanawkwa Casco de Aço para uma luta e derrote-o.", "Вызовите на бой и одолейте Оманавкву Стальное Копыто.", "挑战奥马纳克瓦·钢蹄并击败他。", "挑戰歐瑪納庫‧鋼蹄，與其戰鬥並擊敗他。", }, 
{ "Challenge Asrea Moonblade to fight and defeat her.", "Fordert Asrea Mondklinge heraus und bezwingt sie.", "Desafía a Asrea Filoluna a un combate y derrótala.", "Desafía a Asrea Filoluna a una pelea y derrótala.", "Défiez Asrea Lamelune et remportez le combat.", "Sfida Asrea Lamaluna e sconfiggila.", "아스레아 문블레이드에게 도전하고 승리해야 합니다.", "Desafie Asrea Lamiluna para uma luta e derrote-a.", "Вызовите на бой и одолейте Азрию Лунный Клинок.", "挑战阿斯丽娅·月刃并击败她。", "挑戰挑戰艾絲蕾‧月刃，與其戰鬥並擊敗他。", }, 
{ "Go to the designated area and defeat your final opponent.", "Begebt Euch zum markierten Bereich und bezwingt Euren letzten Gegner.", "Dirígete a la zona designada y derrota a tu oponente final.", "Dirígete al área designada y derrota a tu último oponente.", "Rendez-vous dans la zone indiquée et triomphez de votre dernier adversaire.", "Raggiungi l'area bersaglio e sconfiggi l'avversario finale.", "표시 구역으로 가 마지막 상대에게 승리해야 합니다.", "Vá para a área indicada e derrote o seu adversário final.", "Встаньте на руну и одолейте последнего противника.", "前往指定区域并击败最后一个对手。", "前往指定區域並擊敗你最後的對手。", }, 
},
["1290"] = {
{ "Join the blue dragons in their assault against the Legion.", "Schließt Euch dem Angriff der blauen Drachen auf die Legion an.", "Únete a los dragones Azules en su asalto contra la Legión.", "Acompaña a los dragones azules en su asalto contra la Legión.", "Rejoignez les dragons bleus dans leur assaut contre la Légion.", "Unisciti ai Draghi Blu nel loro assalto contro la Legione.", "푸른용들과 합류해 군단을 공격해야 합니다.", "Junte-se aos dragões azuis no ataque à Legião.", "Присоединитесь к атаке синих драконов на Легион.", "与蓝龙一同攻击燃烧军团。", "跟藍龍一起攻擊燃燒軍團。", }, 
{ "Reach the blue drakes to acquire transport to the Legion ship.", "Erreicht die blauen Drachen, um Euch zum Legionsschiff befördern zu lassen.", "Llega hasta los dracos azules para conseguir un transporte a la nave de la Legión.", "Llega hasta los dracos azules que te transportarán hasta la nave de la Legión.", "Rejoignez les drakes bleus pour vous faire transporter vers le vaisseau de la Légion.", "Chiedi aiuto ai Drachi Blu per raggiungere la nave della Legione.", "푸른 비룡이 있는 곳으로 가 군단 함선까지 갈 탈것을 얻어야 합니다.", "Encontre os dracos azuis para obter transporte para a nave da Legião.", "Отправляйтесь к синим драконам – они доставят вас на корабль Легиона.", "找到幼年蓝龙并前往军团战舰。", "去找藍龍，並且登上燃燒軍團船艦。", }, 
{ "Reach the Legion ship.", "Erreicht das Legionsschiff.", "Llega a la nave de la Legión.", "Llega hasta la nave de la Legión.", "Atteignez le vaisseau de la Légion.", "Raggiungi la Nave della Legione.", "군단 함선에 도착해야 합니다.", "Chegue à nave da Legião.", "Доберитесь до корабля Легиона.", "抵达军团战舰。", "抵達燃燒軍團船艦", }, 
{ "Reach Felweaver Axtris and defeat him.", "Erreicht Teufelsweber Axtris und besiegt ihn.", "Alcanza al tejeyel Axtris y derrótalo.", "Llega hasta Axtris Tejevil y derrótalo.", "Arrivez jusqu’au gangretisseur Axtris et terrassez-le.", "Raggiungi il Vilmistico Axtris e sconfiggilo.", "지옥술사 악스트리스에게 가서 그를 처치해야 합니다.", "Vá até Tecevil Axtris e derrote-o.", "Доберитесь до заклинателя Скверны Акстриса и одолейте его.", "找到织邪者阿克特里斯并击败他。", "打敗魔織者艾克崔斯。", }, 
{ "Eliminate Fel Lord Xeritas.", "Schaltet Teufelslord Xeritas aus.", "Acaba con el señor vil Xeritas.", "Elimina al Señor vil Xeritas.", "Éliminez le gangreseigneur Xéritas.", "Elimina il Vilsignore Xeritas.", "지옥 군주 제리타스를 처치해야 합니다.", "Elimine o Lorde Vil Zeritas.", "Устраните повелителя Скверны Ксеритаса.", "消灭邪能领主瑟瑞塔斯。", "消滅惡魔領主瑟利塔斯。", }, 
{ "Use the drakes to escape the Legion ship before it is destroyed.", "Flieht mithilfe der Drachen vom Legionsschiff, bevor es zerstört wird.", "Utiliza los dracos para escapar de la nave de la Legión antes de su destrucción.", "Usa los dracos para escapar de la nave de la Legión antes de que sea destruida.", "Fuyez du vaisseau de la Légion avant sa destruction grâce aux drakes.", "Usa i Drachi della Tempesta per fuggire dalla Nave della Legione prima che venga distrutta.", "비룡을 타고 군단 함선이 파괴되기 전에 함선을 탈출해야 합니다.", "Use os dracos para escapar antes que a nave da Legião seja destruída.", "Покиньте корабль Легиона на драконах прежде, чем он будет уничтожен.", "使用幼龙逃离即将被摧毁的军团战舰。", "騎上飛龍，在燃燒軍團船艦被摧毀之前逃離。", }, 
},
["1305"] = {
{ "Locate the legendary animal spirits and put them to rest.", "Findet die legendären Tiergeister und bettet sie zur Ruhe.", "Localiza los espíritus de los animales legendarios y ayúdalos a encontrar la paz.", "Encuentra los espíritus de los animales legendarios y ayúdalos a encontrar la paz.", "Localisez les esprits des animaux légendaires et accordez-leur le repos.", "Trova i leggendari spiriti animali e mettili a riposo.", "전설의 동물 영혼을 찾아 안식에 들게 해야 합니다.", "Encontre os espíritos dos animais lendários e faça com que descansem.", "Выследите духов легендарных зверей и верните им покой.", "找到传说中的兽灵并让它们安息。", "找出傳說野獸的靈魂並且讓牠們安息。", }, 
{ "Put the spirits of the Wolf and Hawk to rest.", "Bettet die Geister von Wolf und Falke zur Ruhe.", "Otorga el descanso a los espíritus del lobo y el halcón.", "Haz que los espíritus del lobo y el halcón encuentren la paz.", "Apaisez les esprits du loup et du faucon.", "Dai riposo agli spiriti del Lupo e del Falco.", "늑대와 독수리의 영혼을 안식에 들게 해야 합니다.", "Faça com que os espíritos do Lobo e do Falcão descansem.", "Верните покой духам волка и ястреба.", "让巨狼和巨鹰之灵安息。", "讓大地之霸和天空之王的靈魂安息", }, 
{ "Challenge the Wolfhawk.", "Fordert den Wolfsfalken heraus.", "Reta al lobohalcón.", "Desafía al Lobohalcón.", "Défiez le loup-faucon.", "Sfida il Falcolupo.", "늑대매에 도전해야합니다.", "Desafie o Falcolobo.", "Бросьте вызов звероястребу.", "挑战狼鹰。", "挑戰狼鷹。", }, 
{ "Return to Odyn and feast the night away.", "Kehrt zu Odyn zurück und feiert die Nacht durch.", "Vuelve con Odyn y pasa toda la noche festejando.", "Regresa con Odyn y disfruta del festín toda la noche.", "Retournez voir Odyn et festoyez toute la nuit.", "Torna da Odyn e festeggia tutta la notte.", "오딘에게 돌아가서 밤새 연회를 즐겨야 합니다.", "Fale novamente com Odyn e farreie a noite inteira.", "Вернитесь к Одину на ночное пиршество.", "向奥丁复命并彻夜欢宴。", "回去找歐丁，盡情享受宴會。", }, 
},
["638"] = {
{ "Defeat the bosses in Hellfire Ramparts", "Bezwingt die Bosse im Höllenfeuerbollwerk.", "Derrota a los jefes de las Murallas del Fuego Infernal.", "Derrota a los jefes de las Murallas del Fuego Infernal.", "Terrassez les boss des remparts des Flammes infernales.", "Sconfiggi i boss dei Bastioni del Fuoco Infernale.", "지옥불 성루 우두머리들을 처치해야 합니다.", "Derrote os chefes da Muralha Fogo do Inferno", "Победите боссов в Бастионах Адского Пламени", "击败地狱火城墙的首领", "擊敗地獄火壁壘的首領", }, 
},
["585"] = {
{ "Chromie has asked you to accompany Arthas in the Culling of Stratholme, you must see to it that he defeats Mal'Ganis!", "Chromie möchte, dass Ihr Arthas beim Ausmerzen von Stratholme begleitet. Sorgt dafür, dass er Mal'Ganis besiegt!", "Cromi te ha pedido que acompañes a Arthas en La Matanza de Stratholme. ¡Asegúrate de que derrota a Mal'Ganis!", "Cromi te pidió que acompañes a Arthas en La Matanza de Stratholme, ¡debes hacerlo hasta que derrote a Mal'Ganis!", "Chromie vous a demandé d’accompagner Arthas dans l’épuration de Stratholme. Vous devez veiller à ce qu’il triomphe de Mal’Ganis !", "Cromie ti ha chiesto di accompagnare Arthas nell'Epurazione di Stratholme affinché sconfigga Mal'Ganis.", "크로미가 아서스와 함께 옛 스트라솔름에 가 달라고 부탁했습니다. 아서스가 말가니스를 무찌르게 도와줘야 합니다!", "Crona pediu a você que acompanhe Arthas no Expurgo de Stratholme. Você deve cuidar para que ele derrote Mal'ganis!", "Хроми попросила вас сопровождать Артаса во время очищения Стратхольма. Помогите ему победить Мал'Ганиса!", "克罗米要你陪伴阿尔萨斯完成清洗斯坦索姆的任务，你必须确保他击败玛尔加尼斯！", "克羅米要求你，在斯坦索姆的抉擇中，隨侍於阿薩斯身側，你必須協助他擊敗瑪爾加尼斯！", }, 
{ "Complete the timed event in under twenty-five minutes and defeat the Infinite Corruptor.", "Schließt dieses Ereignis mit Zeitbegrenzung innerhalb von 25 Minuten ab und besiegt den Ewigen Verderber.", "Completa el evento cronometrado en menos de veinticinco minutos y derrota al corruptor infinito.", "Finaliza el evento cronometrado en menos de 25 minutos y derrota al Corruptor Infinito.", "Terminer l’évènement contre la montre en moins de vingt-cinq minutes et vaincre le corrupteur infini.", "Completa l'evento a tempo entro 25 minuti e sconfiggi il Corruttore dell'Infinito.", "25분 안에 시간 제한 이벤트를 완료하고, 무한의 타락자를 처치해야 합니다.", "Complete o evento cronometrado em menos de vinte e cinco minutos e derrote o Corruptor Infinito.", "Пройдите событие за двадцать пять минут или быстрее и победите Осквернителя из рода Бесконечности.", "在25分钟内完成限时事件并击败永恒腐蚀者。", "在二十五分鐘內完成計時事件並擊敗恆龍墮落者。", }, 
},
["51"] = {
{ "Defeat the necromantic forces within Scholomance.", "Bezwingt die Todenbeschwörer in der Scholomance.", "Derrota a las fuerzas nigrománticas de Scholomance.", "Derrota a las fuerzas nigrománticas de Scholomance.", "Terrassez les troupes nécromantiques de la Scholomance.", "Sconfiggi le forze negromantiche all'interno di Scholomance.", "스칼로맨스 내부의 강령술 병력을 처치해야 합니다.", "Destrua as forças necromânticas de Scolomântia.", "Победите нежить в Некроситете", "击败通灵学院内的巫师军团。", "消滅通靈學院裡的死靈勢力。", }, 
},
["1144"] = {
{ "Man the artillery console and use the Fel Hammer's batteries to lay waste to the Legion forces below.", "Bemannt die Artilleriekonsole und benutzt die Batterien der Teufelshammer, um die Legionsstreitkräfte unten auszulöschen.", "Controla la consola de artillería y usa las baterías del Martillo Vil para devastar a las fuerzas de la Legión que hay abajo.", "Encárgate de la consola de artillería y usa las baterías del Martillo Vil para destrozar a las fuerzas de la Legión.", "Postez-vous à la console d’artillerie et utilisez les batteries du Marteau gangrené pour anéantir les troupes de la Légion en contrebas.", "Usa la console dell'artiglieria e l'armamento della Vilmartello per devastare le forze della Legione sottostanti.", "지옥화포 제어 장치를 작동시킨 다음, 지옥 망치호의 함포를 사용하여 아래에 있는 군단 세력을 초토화해야 합니다.", "Entre na cabine da artilharia e use as baterias do Martelo Vil para devastar as forças da Legião abaixo.", "Расставьте солдат у пульта управления артиллерийским огнем и уничтожьте войска Легиона с помощью батарей \"Молота Скверны\".", "控制火炮的操作台，用邪能之槌号的舰炮摧毁下方燃烧军团的部队。", "操作砲台，利用魔錘號的火砲消滅下方的燃燒軍團部隊。", }, 
{ "Speak with Altruis the Sufferer to deploy your forces and then use your Glide ability to get down to the rendezvous point below.", "Sprecht mit Altruis dem Leidenden, um Eure Streitkräfte einzusetzen, und benutzt danach Eure Fähigkeit 'Gleiten', um zum Treffpunkt unten zu gelangen.", "Habla con Altruis el Sufridor para desplegar tus fuerzas y luego usa tu facultad Planear para ir al punto de encuentro de más abajo.", "Habla con Altruis el Sufridor para implementar tus fuerzas y luego usa tu habilidad de deslizamiento para bajar al punto de encuentro.", "Parlez à Altruis le Souffrant pour déployer vos troupes, puis utilisez votre technique Planer pour descendre au point de rendez-vous.", "Parla con Altruis il Sofferente per schierare le tue forze, quindi usa l'abilità Planata per raggiungere il punto di ritrovo sottostante. Parla di nuovo con lui una volta a terra.", "고뇌의 알트루이스와 대화하여 병력을 배치하고, 활공 능력을 사용하여 아래쪽 집결 지점으로 내려가야 합니다.", "Peça a Altruis, o Sofredor, que posicione as tropas. Em seguida, use a habilidade Planar para descer ao local de encontro.", "Поговорите с Алтруисом Страдальцем о размещении войск, затем с помощью \"Планирования\" спуститесь к месту встречи.", "和受难者奥图里斯谈谈，部署你的部队，然后用你的滑翔技能落在下方的集合点。", "跟『受難者』奧翠司交談，部署你的軍隊，然後使用滑翔技能前往下方的集合點。", }, 
{ "Kill Caria and Varedis's lieutenants, and destroy all of the portals they are using to summon in reinforcements.", "Tötet die Leutnants von Caria und Varedis und zerstört alle Portale, die sie zum Herbeirufen von Verstärkung benutzen.", "Mata a los tenientes de Caria y Varedis y destruye todos los portales que están usando para invocar refuerzos.", "Mata a los tenientes de Caria y Varedis y destruye todos los portales que usen para convocar a sus refuerzos.", "Tuez les lieutenants de Caria et Varedis et détruisez tous les portails qu’ils utilisent pour appeler des renforts.", "Uccidi i luogotenenti di Caria e Varedis e distruggi tutti i portali che stanno usando per evocare i rinforzi.", "카리아와 베레디스의 부관을 처치하고 그들이 지원군 소환에 사용하는 모든 차원문을 파괴해야 합니다.", "Mate Caria e os tenentes de Varedis, e destrua os portais que utilizam para evocar reforços.", "Убейте лейтенантов Карии и Варедиса и уничтожьте все порталы, через которые к ним прибывает подкрепление.", "杀死凯丽娅和瓦雷迪斯的副官，摧毁他们用来召唤援军的所有传送门。", "殺死凱莉亞和瓦瑞迪斯的副官，然後摧毀所有他們用來召喚援軍的傳送門。", }, 
{ "Speak with Altruis in front of the command center, where Caria and Varedis are protected behind a Fel Barrier.", "Sprecht mit Altruis vor der Kommandozentrale, wo Caria und Varedis hinter einer Teufelsbarriere geschützt sind.", "Habla con Altruis delante del centro de mando, donde Caria y Varedis están protegidos por una barrera vil.", "Habla con Altruis frente al centro de mando, donde Caria y Varedis se refugian detrás de una barrera vil.", "Parlez à Altruis devant le centre de commandement, où Caria et Varedis sont protégés par une barrière gangrenée.", "Parla con Altruis di fronte al Centro di Comando, dove Caria e Varedis si trovano protetti dietro una Vilbarriera.", "카리아와 베레디스는 지옥 방벽 뒤의 사령부에 있습니다. 그 앞에 있는 알트루이스와 대화해야 합니다.", "Fale com Altruis em frente ao centro de comando, onde Caria e Varedis protegem-se atrás de uma Barreira Vil.", "Поговорите с Алтруисом возле флагманского корабля, где Кария и Варедис закрыты барьером Скверны.", "和奥图里斯在指挥中心前方谈谈，凯丽娅和瓦雷迪斯正在那里，而且受到邪能屏障的保护。", "前往凱莉亞跟瓦瑞迪斯受到魔化屏障保護的指揮中心前方，跟奧翠司交談。", }, 
{ "Order the Fel Hammer to move into position and fire upon the other command center. This will bring down the Fel Barrier and allow entry.", "Befehlt der Teufelshammer, sich in Position zu bringen und auf die andere Kommandozentrale zu feuern. Das wird die Teufelsbarriere zu Fall bringen und den Zugang ermöglichen.", "Ordena al Martillo Vil colocarse en posición y disparar al otro centro de mando. Eso eliminará la barrera vil y permitirá el paso.", "Ordena al Martillo Vil que tome posición y dispare al otro centro de mando. Esto derribará la barrera vil y te permitirá entrar.", "Ordonnez au Marteau gangrené de prendre position pour tirer sur l’autre centre de commandement afin de neutraliser la barrière gangrenée et vous permettre d’entrer.", "Ordina alla Vilmartello di muoversi in posizione e fare fuoco sul Centro di Comando Nemico. Così facendo, abbatterai la Vilbarriera e potrai entrare.", "지옥 망치호를 이동시켜 사령부에 포격을 가해야 합니다. 공격이 성공하면 지옥 방벽이 해제되어 목표에 접근할 수 있을 것입니다.", "Ordene que o Martelo Vil assuma posição e dispare contra o outro centro de comando para derrubar a Barreira Vil e permitir a entrada.", "Распорядитесь, чтобы \"Молот Скверны\" занял позицию, и откройте огонь по флагманскому кораблю врага. Это разрушит барьер Скверны, и вы смо", "命令邪能之槌号进入位置，然后向另一个指挥中心开火。这样可以击溃邪能屏障，使其门户大开。", "命令魔錘號進入攻擊位置，朝另一座指揮中心開火。這能摧毀他們的魔化屏障，讓我們得以前進。", }, 
{ "Kill Caria and Varedis Felsoul.", "Tötet Caria und Varedis Teufelsseele.", "Mata a Caria y Varedis Alma Vil.", "Mata a Caria y Varedis Almavil.", "Tuez Caria et Varedis Gangrâme.", "Uccidi Caria e Varedis Vilanima.", "카리아 펠소울과 베레디스 펠소울을 처치해야 합니다.", "Mate Caria e Varedis Almavil.", "Убейте Карию и Варедиса Оскверненную Душу.", "消灭凯丽娅和瓦雷迪斯·邪魂。", "殺死凱莉亞和瓦瑞迪斯‧魔魂", }, 
{ "Caria and Varedis are dead. Speak with Altruis and have Matron Mother Malevolence teleport all of you back to the Fel Hammer.", "Caria und Varedis sind tot. Sprecht mit Altruis und lasst Euch von Matronenmutter Malicia zurück auf die Teufelshammer teleportieren.", "Caria y Varedis están muertos. Habla con Altruis y haz que la madre matriarca Malevolencia os teletransporte a todos de vuelta al Martillo Vil.", "Caria y Varedis están muertos. Habla con Altruis y haz que la Madre Matrona Malevolencia los teletransporte nuevamente al Martillo Vil.", "Caria et Varedis sont morts. Parlez à Altruis et demandez à la matrone Maléficiae de tous vous renvoyer à bord du Marteau gangrené.", "Caria e Varedis sono morti. Parla con Altruis e chiedi alla Matrona Suprema Malevola di teletrasportarvi alla Vilmartello.", "카리아와 베레디스는 죽었습니다. 알트루이스와 대화한 다음 모군주 말레볼런스의 도움을 받아 아군과 함께 지옥 망치호로 순간이동해야 합니다.", "Caria e Varedis estão mortos. Fale com Altruis para que a Mãe Matrona Malévola teleporte a todos de volta ao Martelo Vil.", "Кария и Варедис мертвы. Поговорите с Алтруисом и попросите верховную мать Злобу телепортировать всех вас обратно на \"Молот Скверны\".", "凯丽娅和瓦雷迪斯已死。和奥图里斯谈谈，让主母玛沃伦丝将所有人传送回邪能之槌号。", "凱莉亞和瓦瑞迪斯都死了。跟奧翠司交談，請懷惡族母把你們全都傳送回魔錘號。", }, 
},
["606"] = {
{ "Defeat the bosses of the Shadow Labyrinth", "Besiegt die Bosse des Schattenlabyrinths", "Derrota a los jefes de Laberinto de las Sombras.", "Derrota a los jefes del Laberinto de las Sombras.", "Terrassez les boss du labyrinthe des Ombres.", "Sconfiggi i boss del Labirinto delle Ombre.", "어둠의 미궁 우두머리들을 처치해야 합니다.", "Derrote os chefes do Labirinto Soturno", "Победите боссов в Темном лабиринте", "击败暗影迷宫的首领", "擊敗暗影迷宮的首領", }, 
},
};
