-- $Id: Lib-ScenariosStepsDB.lua 19 2020-10-26 15:51:41Z arith $
local FOLDER_NAME, private = ...

local Steps = {}
if not private.Scenarios then private.Scenarios = {} end
private.Scenarios.Steps = Steps

--[[
LibScenariosStepsTempDB = { 
	--{ "Scenario ID", "Step ID", "Steps", "enUS", "deDE", "esES", "esMX", "frFR", "itIT", "koKR", "ptBR", "ruRU", "zhCN", "zhTW" },
	{ "15", "24", "0", "Escort Brewmaster Bo", "Eskortiert Braumeister Bo", "Escolta al maestro cervecero Bo", "Escolta al maestro cervecero Bo", "Escorter le maître brasseur Bo", "Scorta il Mastro Birraio Bo", "양조사 보 호위", "Escolte o Mestre Cervejeiro Bô", "Сопровождение хмелевара Бо", "护送珀酒仙", "護送釀酒大師阿波" },
	{ "15", "25", "1", "Fill the Brewing Cauldron", "Füllt den Braukessel", "Llena el caldero de fermentación", "Llena el caldero de fermentación", "Remplir le chaudron de brassage", "Riempi il Tino di Fermentazione", "양조 가마솥 채우기", "Encha o Caldeirão de Brassagem", "Наполнение хмелеваренного котла", "装满酿酒大锅", "倒滿釀酒鍋" },
	{ "15", "26", "2", "Defeat Captain Ook", "Bezwingt Kapitän Uuk", "Derrota al capitán Ook.", "Derrota al capitán Ook.", "Vaincre le capitaine Ouk", "Sconfiggi Capitan Gancino", "선장 우끼 처치", "Derrote o Capitão Fedô", "Победа над капитаном Уком", "击败乌克头领", "殺死烏克船長" };
}
]]

Steps.DB = { 
["53"] = { 
{ "Scarlet Monastery", "Scharlachrotes Kloster", "Monasterio Escarlata", "Monasterio Escarlata", "Monastère Écarlate", "Monastero Scarlatto", "붉은십자군 수도원", "Monastério Escarlate", "Монастырь Алого ордена", "血色修道院", "血色修道院", }, 
},
["63"] = {
{ "The Brewmoon Festival!", "Das Braumondfest!", "El Festival de la Cerveza Lunar", "El Festival de la Cerveza Lunar", "Le festival de Brasse-Lune", "Festival di Birraluna", "맥주달 축제", "Festival da Cerveja da Lua!", "Фестиваль Хмельнолуния!", "酿月祭", "酒月節", }, 
{ "The Scouts Report.", "Berichte der Späher", "El informe de los exploradores", "El informe de los exploradores", "Le rapport des éclaireurs", "Rapporto degli esploratori", "정찰병의 보고", "O Relatório do Batedor", "Результаты разведки", "斥候来报。", "偵察報告", }, 
{ "The Yaungol attack!", "Die Yaungol greifen an!", "¡El ataque yaungol!", "¡El ataque yaungol!", "L’attaque yaungole !", "Attacco degli Yaungol", "야운골이 공격한다!", "O Ataque dos Yaungóis!", "Атака яунголов!", "野牛人入侵！", "揚古入侵！", }, 
{ "Warbringer Qobi", "Kriegshetzer Qobi", "Belisario Qobi", "Belisario Qobi", "Porteguerre Qobi", "Araldo della Guerra Qobi", "전쟁인도자 코비", "Armipotente Qobi", "Воитель Коби", "战争使者虬碧", "戰爭使者闊畢", }, 
},
["537"] = {
{ "Stormstout Brewery", "Brauerei Sturmbräu", "Cervecería del Trueno", "Cervecería del Trueno", "Brasserie Brune d’Orage", "Birrificio Triplo Malto", "스톰스타우트 양조장", "Cervejaria Malte do Trovão", "Хмелеварня Буйных Портеров", "风暴烈酒酿造厂", "風暴烈酒酒坊", }, 
},
["637"] = {
{ "Disable the Ziggurats", "Deaktiviert die Ziggurats", "Desactiva los zigurats", "Desactiva los zigurats.", "Désactiver les ziggourats", "Disattiva le Ziggurat", "지구라트 정지", "Desative os Zigurates", "Отключите зиккураты", "关闭通灵塔", "關閉通靈塔", }, 
{ "The Slaughterhouse", "Das Schlachthaus", "El Degolladero", "El Matadero", "L’abattoir", "Mattatoio", "도살장", "O Abatedouro", "Бойня", "屠宰房", "屠宰房", }, 
{ "Ramstein the Gorger", "Ramstein der Verschlinger", "Ramstein el Empachador", "Ramstein el Empachador", "Ramstein Grandgosier", "Sconfiggi Ramstein il Bramacarne", "먹보 람스타인", "Ramstein, o Devorador", "Рамштайн Ненасытный", "吞咽者拉姆斯登", "『暴食者』拉姆斯登", }, 
{ "Lord Aurius Rivendare", "Baron Aurius Totenschwur", "Lord Aurius Osahendido", "Lord Aurius Osahendido", "Seigneur Aurius Vaillefendre", "Ser Aurius Fieramorte", "군주 아우리우스 리븐데어", "Lorde Aurius Rivendare", "Лорд Аурий Ривендер", "奥里克斯·瑞文戴尔领主", "奧里爾斯·瑞文戴爾領主", }, 
{ "Magistrate Barthilas defeated", "Magistrat Barthilas bezwungen", "Magistrado Barthilas derrotado", "Magistrado Barthilas derrotado.", "Magistrat Barthilas vaincu", "Sconfiggi il Magistrato Barthilas", "집정관 발실라스 처치", "Magistrado Barthilas derrotado", "Мировой судья Бартилас повержен", "击败巴瑟拉斯镇长", "擊敗巴瑟拉斯鎮長", }, 
},
["940"] = {
{ "Hunting the Hunters", "Jagd auf die Jäger", "Cazar a los cazadores", "Cazar a los cazadores", "La chasse aux chasseurs", "Caccia ai cacciatori", "사냥꾼 사냥", "Caçando os caçadores", "Охота на охотников", "猎杀猎人", "獵殺獵人", }, 
{ "Scout the Path", "Späht den Pfad aus", "Explorar el camino", "Explora el camino", "Explorer le chemin", "Esplorare la via", "길목 정찰", "Faça reconhecimento da trilha", "Разведка пути", "侦察道路", "偵察路徑", }, 
{ "Breaching the Defenses", "Durchbrechen der Verteidigung", "Traspasar las defensas", "Traspasando las defensas", "Faille défensive", "Sfondare le difese", "불의 벽을 넘어", "O romper das defesas", "Брешь в обороне", "突破防御", "突破防線", }, 
{ "The Search Continues", "Die Suche geht weiter", "La búsqueda continúa", "La búsqueda continúa", "La recherche continue", "La ricerca continua", "계속되는 수색", "A busca continua", "Поиски продолжаются", "继续搜寻", "繼續搜尋", }, 
{ "End of the Inquisition", "Das Ende der Inquisition", "El fin de la Inquisición", "El fin de la Inquisición", "La fin de l’inquisition", "Fine dell'Inquisizione", "심문관의 최후", "Fim da Inquisição", "С инквизицией покончено", "结束审判", "審判終結", }, 
{ "Back to the Prisoner", "Zurück zum Gefangenen", "Volver con el prisionero", "De vuelta al prisionero", "Retour à la geôle", "Ritorno dal prigioniero", "죄수 해방", "De volta ao prisioneiro", "Возвращение к пленнику", "返回监狱", "回去找囚犯", }, 
{ "Sieging the Citadel", "Belagerung der Zitadelle", "Asediar la ciudadela", "Asedio a la ciudadela", "Le siège de la citadelle", "Assedio alla cittadella", "성채 포위", "Cerco à cidadela", "Осада цитадели", "围攻城堡", "圍攻城塞", }, 
{ "Into the Depths", "In die Tiefen", "En las profundidades", "En las profundidades", "Dans les profondeurs", "Negli abissi", "깊숙한 곳으로", "Nas profundezas", "В глубины", "进入深渊", "邁入深淵", }, 
{ "The Fleshripper", "Der Fleischreißer", "El Desgarracarnes", "El Desgarrador", "Le Déchire-chair", "Lo Squartacarne", "살점분리자", "O Ripa-carne", "Раздиратель Плоти", "裂肉者", "裂肉狂魔", }, 
{ "The Maw of the Damned", "Der Schlund der Verdammten", "La Fauce del Maldito", "La Fauce de los Malditos", "Gueule-du-Damné", "Il Morso del Dannato", "저주받은 자의 아귀", "A Gorja dos Condenados", "Проклятый Пожиратель", "诅咒之喉", "遭譴者之顎", }, 
{ "The Call of Icecrown", "Der Ruf der Eiskronenzitadelle", "La llamada de Corona de Hielo", "El llamado de Corona de Hielo", "L’appel de la Couronne de glace", "Chiamata della Corona di Ghiaccio", "얼음왕관의 부름", "O chamado da Coroa de Gelo", "Зов Ледяной Короны", "冰冠的召唤", "寒冰皇冠的呼喚", }, 
},
["237"] = {
{ "Select a Trial", "Wählt eine Prüfung", "Elige una prueba", "Elige una prueba", "Choisir une épreuve", "Scegli una prova", "시험 선택", "Escolha um teste", "Выбор испытания", "选择试炼", "選擇一項試煉", }, 
},
["640"] = {
{ "The Temple of Atal'hakkar", "Der Tempel von Atal'Hakkar", "El Templo de Atal'Hakkar", "El Templo de Atal'Hakkar", "Le temple d’Atal’Hakkar", "Tempio di Atal'Hakkar", "아탈학카르 신전", "O Templo de Atal'hakkar", "Храм Атал'Хаккара", "阿塔哈卡神庙", "阿塔哈卡神廟", }, 
},
["1253"] = {
{ "Darkheart Thicket", "Das Finsterherzdickicht", "Arboleda Corazón Oscuro", "Matorral Corazón Oscuro", "Fourré Sombrecœur", "Boschetto Cuortetro", "어둠심장 숲", "Bosque Corenegro", "Чаща Темного Сердца", "黑心林地", "暗心灌木林", }, 
},
["1214"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al Combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Call a Friend", "Einen Freund rufen", "Llama a un amigo", "Llamar a un amigo", "Appel à un ami", "Amici più di prima", "친구 부르기", "Chamar um amigo", "Помощь друга", "召唤小伙伴", "呼喚朋友", }, 
{ "Here I Come!", "Bin da, wer noch?", "¡Allá voy!", "¡Allá voy!", "Me voilà !", "Eccomi!", "간다!", "Aí vou eu!", "А вот и я!", "我来了！", "我來了！", }, 
{ "Just A Flesh Wound", "Nur 'ne Fleischwunde", "Es solo un rasguño", "Heridas superficiales", "Juste une égratignure", "È solo un graffio", "얕은 상처일 뿐", "Só um arranhão", "Всего лишь царапина", "只是皮肉伤", "區區皮肉傷", }, 
{ "Attacking From All Sides", "Angriff von allen Seiten", "Ataque por todos los flancos", "Ataque por los cuatro costados", "De tous les côtés", "Attacchi da ogni dove", "모든 측면의 공격", "Ataque de todos os lados", "Атака со всех сторон", "全方位打击", "四面楚歌", }, 
{ "Clever Girl", "Cleveres Kerlchen", "Buen trabajo", "Empatía animal", "Petite futée", "Ragazza furba", "영리한 소녀", "Garota esperta", "Хорошая девочка", "聪明宝宝", "聰明的女孩", }, 
{ "Bite, Bite, Goose!", "Süß, aber tödlich!", "El mordisco de la mangosta", "¡Muérdelo, muérdelo, ganso!", "Attention à la mangouste !", "Mordi, mordi!", "물어라, 물어, 살쾡이!", "Me gusta Mangusto!", "Куси, куси его!", "咬吧，猫鼬，咬吧！", "咬！咬啊！", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Carve Them Up!", "Skalpell, bitte!", "¡Hazlos pedacitos!", "¡Córtalos a todos!", "Écharpez-les !", "Falciali tutti!", "모두 저며라!", "Bê-á-bá do Trinchar", "Всех на мясо!", "削他们！", "解決他們！", }, 
{ "Playing Possum", "Kein Puls, keine Regung", "Hacerse el muerto", "Hacerse el muerto", "Simulacre de mort", "Fare il Morto", "죽은 척하기", "Fingindo de Morto", "Притвориться мертвым", "负鼠爱装死", "裝死", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defesa contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["651"] = {
{ "Scarlet Halls", "Die Scharlachroten Hallen", "Cámaras Escarlata", "Cámaras Escarlata", "Salles Écarlates", "Sale Scarlatte", "붉은십자군 전당", "Salões Escarlates", "Залы Алого ордена", "血色大厅", "血色大廳", }, 
{ "Armsmaster Harlan defeated", "Waffenmeister Harlan bezwungen", "Maestro de armas Harlan derrotado", "Maestro de armas Harlan derrotado", "Maître d’armes Harlan vaincu", "Sconfiggi il Maestro d'Armi Harlan", "무기전문가 할란 처치", "Mestre Armeiro Harlan derrotado", "Воитель Гарлан повержен", "击败武器大师哈兰", "擊敗武器大師哈倫", }, 
},
["1328"] = {
{ "Uncharted Territory", "Unerforschtes Gebiet", "Territorio inexplorado", "Territorio no explorado", "En territoire inconnu", "Territorio inesplorato", "미지의 땅", "Território Desconhecido", "Неизведанная территория", "未知领域", "未知的領域", }, 
{ "The Frozen Span", "Der Frostübergang", "El Tramo Congelado", "El Puente gélido", "Le viaduc Gelé", "Baratro Congelato", "얼어붙은 교각", "O Vão Glacial", "Ледяные просторы", "冰封之桥", "冰封大橋", }, 
{ "Essence of the Red", "Die Essenz des Roten", "Esencia de lo Rojo", "Esencia del rojo", "Essence des Rouges", "Essenza del Rosso", "적색의 정수", "Essência do Vermelho", "Сущность красных драконов", "红龙精华", "紅龍精華", }, 
{ "Life to Death", "Leben zu Tod", "De vida a muerte", "Vida a muerte", "De la vie à la mort", "Dalla vita alla morte", "생명에서 죽음으로", "Da Vida à Morte", "Жизнь и смерть", "向死而生", "由生轉死", }, 
{ "Unholy Resurrection", "Unheilige Auferstehung", "Resurrección profana", "Resurrección profana", "Résurrection impie", "Resurrezione empia", "부정한 부활", "Ressurreição Profana", "Нечестивое воскрешение", "邪恶复生", "穢邪復生", }, 
},
["959"] = {
{ "Defend Kharanos", "Verteidigt Kharanos", "Defiende Kharanos", "Defiende Kharanos", "La défense de Kharanos", "Difendere Kharanos", "카라노스 방어", "Defenda Kharanos", "Оборона Караноса", "保卫卡拉诺斯", "守禦卡拉諾斯", }, 
{ "Defeat the Demon Commander", "Bezwingt den Dämonenkommandanten", "Derrota al comandante demoníaco", "Derrota al Comandante demoníaco", "Terrasser le commandant démon", "Sconfiggere il comandante demoniaco", "악마 사령관 처치", "Derrotar o Demônio Comandante", "Победа над командиром демонов", "击败恶魔指挥官", "擊敗惡魔指揮官", }, 
{ "Repel the Legion Forces", "Schlagt die Streitkräfte der Legion zurück", "Rechaza a los ejércitos de la Legión", "Repele a las fuerzas de la Legión", "Repousser les troupes de la Légion", "Respingere le forze della Legione", "군단 격퇴", "Rechaçar as forças da Legião", "Отражение натиска Легиона", "击退燃烧军团的部队", "擊退燃燒軍團", }, 
{ "Defeat the Demon Lord", "Bezwingt den Dämonenfürsten", "Derrota al señor demoníaco", "Derrota al Señor demoníaco", "Terrasser le seigneur démon", "Sconfiggere il Signore dei Demoni", "악마 군주 처치", "Derrotar o lorde-demônio", "Смерть повелителю демонов", "击败恶魔领主", "擊敗惡魔領主", }, 
},
["636"] = {
{ "The Dreadlord Balnazzar", "Der Schreckenslord Balnazzar", "El Señor del Terror Balnazzar", "El Señor del Terror Balnazzar", "Le Seigneur de l’effroi Balnazzar", "Signore del Terrore Balnazzar", "공포의 군주 발나자르", "O Senhor do Medo Balnazzar", "Повелитель Ужаса Бальназар", "恐惧魔王巴纳扎尔", "驚懼領主巴納札爾", }, 
{ "The Unforgiven defeated", "Den Unverziehenen bezwungen", "La Imperdonable derrotada", "La Imperdonable derrotada.", "Le Condamné vaincu", "Sconfiggi L'Implacabile", "용서받지 못한 자 처치", "O Imperdoável derrotado", "Непрощенный повержен", "击败不可宽恕者", "擊敗不可寬恕者", }, 
{ "Hearthsinger Forresten defeated", "Herdsinger Forresten bezwungen", "Cantachimeneas Forresten derrotado", "Cantachimeneas Forresten derrotado.", "Chanteloge Forrestin vaincu", "Sconfiggi Forresten il Cantastorie", "하스싱어 포레스턴 처치", "Cantalar Forresten derrotado", "Певчий Форрестен повержен", "击败弗雷斯特恩", "擊敗爐邊歌手弗瑞斯坦", }, 
{ "Timmy the Cruel defeated", "Timmy den Grausamen bezwungen", "Timmy el Cruel derrotado", "Timmy el Cruel derrotado.", "Timmy le Cruel vaincu", "Sconfiggi Timmy il Crudele", "잔혹한 티미 처치", "Tico, o Cruel derrotado", "Тимми Беспощадный повержен", "击败悲惨的提米", "擊敗殘忍的提米", }, 
{ "Postmaster Malown defeated", "Postmeister Malown bezwungen", "Jefe de correos Gassol derrotado", "Jefe de correos Gassol derrotado.", "Postier Malown vaincu", "Sconfiggi il Postino Malown", "우체국장 말로운 처치", "Chefe do Correio Malown derrotado", "Почтальон Мэлоун повержен", "击败邮差马龙", "擊敗郵政局長瑪羅恩", }, 
{ "Commander Malor defeated", "Kommandant Malor bezwungen", "Comandante Malor derrotado", "Comandante Malor derrotado.", "Commandant Malor vaincu", "Sconfiggi il Comandante Malor", "사령관 말로 처치", "Comandante Malor derrotado", "Командир Малор повержен", "击败指挥官玛洛尔", "已擊敗指揮官瑪洛爾", }, 
{ "Willey Hopebreaker defeated", "Willey Hoffnungsbrecher bezwungen", "Willey Rompeesperanzas derrotado", "Willey Rompeesperanzas derrotado.", "Willey Mutilespoir vaincu", "Sconfiggi Willey Frangifede", "윌리 호프브레이커 처치", "Gualter Quebrafé derrotado", "Вилли Разбивающий Надежды повержен", "击败希望破坏者威利", "擊敗威利‧希望破除者", }, 
{ "Instructor Galford defeated", "Instrukteur Galford bezwungen", "Instructor Galford derrotado", "Instructor Galford derrotado.", "Instructeur Galford vaincu", "Sconfiggi l'Istruttore Galford", "교관 갈포드 처치", "Instrutor Galford derrotado", "Инструктор Галфорд повержен", "击败档案管理员加尔福特", "擊敗古卷管理者加爾福特", }, 
},
["536"] = {
{ "Mogu'shan Palace", "Mogu'shanpalast", "Palacio Mogu'shan", "Palacio Mogu'shan", "Palais Mogu’shan", "Palazzo Mogu'shan", "모구샨 궁전", "Palácio Mogu'shan", "Дворец Могу'шан", "魔古山宫殿", "魔古山宮", }, 
},
["736"] = {
{ "A Gladiator's Welcome", "Heimkehr des Gladiators", "Una bienvenida de gladiador", "Una bienvenida de Gladiador", "Un accueil de gladiateur", "Un gladiatorio benvenuto", "검투사의 환영", "Boas-vindas ao Gladiador", "Добро пожаловать в гладиаторы", "角斗士的欢迎", "歡迎鬥士入場", }, 
{ "My Name is Gladiator", "Mein Name ist Gladiator", "Mi nombre es Gladiador", "Me llamo Gladiador", "Mon nom est Gladiateur", "Il mio nome è Gladiatore", "진정한 검투사", "Meu nome é Gladiador", "Меня зовут Гладиатор", "我的名字是角斗士", "我的名字叫鬥士", }, 
{ "Fight, Kill, Salute", "Kampf, Sieg, Gruß", "¡Luchar, matar, saludar!", "Luchar, matar, rendir pleitesía", "Morituri te salutant", "Combattere, uccidere, rendere onore", "싸워라, 죽여라, 경례하라", "Lutar, matar, saudar", "Кровь, смерть, триумф", "战斗！杀戮！欢呼！", "戰鬥、殺戮，致敬！", }, 
},
["52"] = {
{ "Scarlet Halls", "Scharlachrote Hallen", "Cámaras Escarlata", "Cámaras Escarlata", "Salles Écarlates", "Sale Scarlatte", "붉은십자군 전당", "Salões Escarlate", "Залы Алого ордена", "血色大厅", "血色大廳", }, 
},
["72"] = {
{ "To the Waterline!", "Ein Schlag ins Wasser!", "¡A la línea de flotación!", "¡A la línea de flotación!", "Sur la ligne de flottaison !", "Alla linea di galleggiamento!", "해안선을 확보하라!", "Antes mesmo de levantar âncora!", "До ватерлинии!", "沉下去吧！", "前往水岸!", }, 
{ "The Blastmaster", "Der Sprengmeister", "El maestro destructor", "El maestro destructor", "Le maître-dynamiteur", "Lo Scoppiomastro", "폭발물전문가", "O Explodista", "Подрывник", "爆破大师", "爆破專家", }, 
{ "Gryphon, Down", "Greif am Boden", "Grifo derribado", "Grifo derribado", "Un griffon, fon, fon", "A cuccia, Grifone!", "그리핀이 추락했다", "Grifo voando, um perigo", "Конец грифонам", "狮鹫坠落", "獅鷲獸墜落", }, 
{ "Tanks for Nothing!", "Das wird 'ne hübsche Überraschung", "¡Tanques para nada!", "¡Tanques para nada!", "Arrête ton char !", "Occhio ai carri!", "전차를 파괴하라!", "Tanque Cheio e Tanque Vazio", "Танкобойня", "让坦克见鬼去吧！", "消失吧，坦克!", }, 
{ "Fly, Spy!", "Auf der Flucht!", "¡Vuela, espía!", "¡Vuela, espía!", "Espionnage aérien !", "Vola, spia, vola!", "날아라, 첩자!", "Sai da prisão, espião!", "Лети, шпион!", "自由了！", "飛吧，間諜!", }, 
},
["647"] = {
{ "Blackthorn's Lieutenants", "Schwarzdorns Leutnants", "Los tenientes de Espina Negra", "Tenientes de Espina Negra", "Les lieutenants de Noirépine", "Luogotenenti di Spinanera", "블랙쏜의 부관들", "Tenentes de Abrunhal", "Приспешники Черношипа", "布莱克松的党羽", "黑棘的副官", }, 
{ "Death Speaker Blackthorn", "Todessprecher Schwarzdorn", "Portavoz de la muerte Espina Negra", "Portavoz de la muerte Espina Negra", "Nécrorateur Noirépine", "Oratore della Morte Spinanera", "죽음예언자 블랙쏜 처치", "Morta-voz Abrunhal", "Вестник смерти Черношип", "亡语者布莱克松", "亡語者黑棘", }, 
{ "Amnennar the Coldbringer", "Amnennar der Kältebringer", "Amnennar el Gélido", "Amnennar el Gélido", "Amnennar le Porte-Froid", "Amnennar l'Araldo del Freddo", "혹한의 암네나르", "Amnennar, o Frigífero", "Амненнар Хладовей", "寒冰之王亚门纳尔", "『寒冰使者』亞門納爾", }, 
},
["547"] = {
{ "Defeat Echoes", "Besiegt die Echos", "Derrotar a los ecos", "Derrota Ecos", "Vaincre les échos", "Sconfiggi gli Echi", "환영 처치", "Derrote os Ecos", "Победите эха", "击败残影", "擊敗回音", }, 
{ "Defeat Murozond", "Besiegt Murozond", "Derrota a Murozond", "Derrota a Murozond.", "Vaincre Murozond", "Sconfiggi Murozond", "무르도즈노 처치", "Derrote Murozond", "Победите Дорнозму", "击败姆诺兹多", "擊敗姆多茲諾", }, 
},
["247"] = {
{ "Step 1", "Schritt 1", "Step 1", "Step 1", "Étape 1", "Fase 1", "1단계", "Passo 1", "1 этап", "第1阶段", "步驟1", }, 
{ "Step 2", "Schritt 2", "Step 2", "Step 2", "Étape 2", "Fase 2", "2단계", "Passo 2", "2 этап", "第2阶段", "步驟2", }, 
{ "Step 3", "Schritt 3", "Step 3", "Step 3", "Étape 3", "Fase 3", "3단계", "Passo 3", "3 этап", "第3阶段", "步驟3", }, 
{ "Step 4", "Schritt 4", "Step 4", "Step 4", "Étape 4", "Fase 4", "4단계", "Passo 4", "4 этап", "第4阶段", "步驟4", }, 
{ "Step 5", "Schritt 5", "Step 5", "Step 5", "Étape 5", "Fase 5", "5단계", "Passo 5", "5 этап", "第5阶段", "步驟5", }, 
{ "Step 6", "Schritt 6", "Step 6", "Step 6", "Étape 6", "Fase 6", "6단계", "Passo 6", "6 этап", "第6阶段", "步驟6", }, 
},
["950"] = {
{ "Demon Down", "Dämon am Boden", "La caída del demonio", "Demonio abajo", "Démon à terre", "Demone abbattuto", "피 흘리는 악마", "Demônio caído", "Демон повержен", "摔落的恶魔", "降伏惡魔", }, 
{ "Corruption in the Deep", "Verderbnis in der Tiefe", "Corrupción en las profundidades", "Corrupción en lo profundo", "La corruption des profondeurs", "Corruzione nel profondo", "심연의 타락", "Corrupção nas profundezas", "Порча в глубине", "深岩的腐化", "深淵裡的腐化", }, 
{ "Hot on the Trail", "Auf den Fersen", "Pisándole los talones", "Pisándole los talones", "La piste est toute chaude", "In cerca di indizi", "뜨거운 추격", "Trilha quente", "По горячим следам", "如影随形", "奮力追擊", }, 
{ "Cleansing the Earth", "Läutern der Erde", "Purificar la tierra", "Purificando la tierra", "Purge souterraine", "Purificare la terra", "대지 정화", "Purificação da terra", "Очищение земли", "净化大地", "淨化大地", }, 
{ "The Demon Below", "Der Dämon in der Tiefe", "El demonio de las profundidades", "El demonio debajo", "Le démon des profondeurs", "Il demone delle profondità", "지하의 악마", "O demônio abaixo", "Демон из глубин", "地底的恶魔", "底下的惡魔", }, 
{ "The Doomhmamer Calls", "Der Schicksalshammer ruft", "El Martillo Maldito llama", "El Martillo Maldito te llama", "L’appel de Marteau-du-Destin", "Il richiamo di Martelfato", "둠해머의 부름", "Chamado do Martelo da Perdição", "Молот Рока зовет", "毁灭之锤的召唤", "末日錘的呼喚", }, 
{ "Finishing the Job", "Eine unvollendete Aufgabe", "Terminar el trabajo", "Terminando el trabajo", "Finir le boulot", "Finire il lavoro", "마무리", "Serviço completo", "Завершение начатого", "临门一脚", "完成工作", }, 
{ "A Ring Eternal", "Ein ewiger Ring", "Un anillo eterno", "Un anillo eterno", "Le cercle éternel", "Un anello eterno", "영원한 고리", "Harmonia eterna", "Служители вечны", "永恒之环", "議會永存", }, 
},
["650"] = {
{ "Scarlet Halls", "Die Scharlachroten Hallen", "Cámaras Escarlata", "Cámaras Escarlata", "Salles Écarlates", "Sale Scarlatte", "붉은십자군 전당", "Salões Escarlates", "Залы Алого ордена", "血色大厅", "血色大廳", }, 
{ "Armsmaster Harlan defeated", "Waffenmeister Harlan bezwungen", "Maestro de armas Harlan derrotado", "Maestro de armas Harlan derrotado", "Maître d’armes Harlan vaincu", "Sconfiggi il Maestro d'Armi Harlan", "무기전문가 할란 처치", "Mestre Armeiro Harlan derrotado", "Воитель Гарлан повержен", "击败武器大师哈兰", "擊敗武器大師哈倫", }, 
},
["1256"] = {
{ "Maw of Souls", "Der Seelenschlund", "Fauce de Almas", "Fauces de almas", "Gueule des âmes", "Fauci delle Anime", "영혼의 아귀", "Gorja das Almas", "Утроба душ", "噬魂之喉", "靈魂之喉", }, 
},
["1306"] = {
{ "Report to the Shrine", "Meldet Euch am Schrein", "Presentarse en el santuario", "Preséntate en el santuario", "Rapport au sanctuaire", "Rapporto al Santuario", "제단에 보고", "Apresentar-se ao santuário", "Прибытие в святилище", "去神殿报到", "返回聖壇", }, 
{ "Defend the Shrine", "Verteidigung des Schreins", "Defender el santuario", "Defiende el santuario", "Défense du sanctuaire", "Difendere il Santuario", "제단 방어", "Defesa do santuário", "Оборона святилища", "保卫神殿", "保衛聖壇", }, 
{ "Return to the Shrine", "Rückkehr zum Schrein", "Regresa al santuario", "Regresa al santuario", "Retour au sanctuaire", "Ritorno al Santuario", "다시 제단으로", "De volta ao santuário", "Возвращение в святилище", "回到圣殿", "重回聖壇", }, 
{ "Uncover the Traitor", "Entlarvt den Verräter", "Descubrir al traidor", "Descubre al traidor", "Démasquer le traître", "Scoprire il traditore", "배신자 색출", "Desmascarar o traidor", "Выявление предателя", "发现叛徒", "揪出叛徒", }, 
{ "Return to the Dreamgrove", "Rückkehr zum Hain der Träume", "Retorno a la Arboleda de los Sueños", "Regresa a la Arboleda de los Sueños", "Retour à la Sylverêve", "Ritorno al Bosco dei Sogni", "다시 꿈숲으로", "Retorno ao Bosque Onírico", "Возвращение в Рощу Снов", "返回梦境林地", "重回幻夢之林", }, 
},
["1203"] = {
{ "Secure the Promenade", "Sichert die Promenade", "Asegura el Paseo", "Asegura el Paseo", "Sécuriser la Promenade", "Rendere sicura la Gran Terrazza", "대정원 확보", "Tomada do Passeio", "Захват променада", "肃清大步道", "占領漫步宏園", }, 
{ "Defeat the Ancient Shieldguard", "Bezwingt den uralten Schildwächter", "Derrota al guardia protector antiguo", "Derrota al Escudero ancestral", "Vaincre l’ancien garde-bouclier.", "Sconfiggi lo Scudiero Antico.", "고대 방패수호병 처치", "Derrote o Guarda de Elite Antigo", "Победите древнего стража щита", "击败上古神盾卫士", "擊敗遠古盾衛", }, 
{ "Secure the Concourse of Destiny", "Sichert den Laufsteg des Schicksals", "Asegura el Atrio del Destino", "Asegura el Vestíbulo del Destino", "Sécuriser le corridor de la Destinée", "Prendi il controllo del Viale del Destino", "운명의 대로 확보", "Tomada do Átrio do Destino", "Захват Двора Судьбы", "肃清命运广场", "占領命運集合場", }, 
{ "Trigger the Telemancy Trap", "Löst die telemantische Falle aus", "Activa la trampa de telemancia", "Activa la trampa de telemancia", "Le piège de télémancie", "Attivare la Trappola Telemantica", "이동술 함정 발동", "Acionamento da Armadilha de Telemancia", "Вызовите срабатывание телемантической ловушки", "触发传送陷阱", "觸發傳送陷阱", }, 
},
["329"] = {
{ "Extinguish Runes", "Löscht die Runen", "Extinción de runas", "Extinguir runas", "Éteindre les runes", "Estingui le rune", "룬 꺼뜨리기", "Extinguir runas", "Погасить руны", "熄灭符文", "熄滅符文", }, 
{ "Upper Blackrock Spire", "Obere Schwarzfelsspitze", "Cumbre de Roca Negra Superior", "Cumbre de Roca Negra superior", "Sommet du pic Rochenoire", "Bastioni di Roccianera Superiori", "검은바위 첨탑 상층", "Pico da Rocha Negra Superior", "Убейте боссов верхней части пика Черной горы", "黑石塔上层", "黑石塔上層", }, 
},
["629"] = {
{ "Mana-Tombs", "Managruft", "Tumbas de Maná", "Tumbas de Maná", "Tombes-mana", "Tombe del Mana", "마나 무덤", "Tumbas de Mana", "Гробницы Маны", "法力陵墓", "法力墓地", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["429"] = {
{ "Grimrail Depot", "Grimmgleisdepot", "Terminal Malavía", "Depósito Riel siniestro", "Dépôt de Tristerail", "Treno Frecciacupa", "파멸철로 정비소", "Central do Carrilcruel", "Депо Мрачных Путей", "恐轨车站", "恐軌車站", }, 
},
["248"] = {
{ "Get Ready...", "Macht Euch bereit…", "Prepárate...", "Prepárate...", "Prêt…", "Preparati...", "준비...", "Prepare-se...", "Приготовьтесь", "做好准备……", "做好準備...", }, 
{ "Proving Grounds", "Feuerprobe", "Terreno de Pruebas", "Terreno de Pruebas", "Ordalie", "Arena d'Addestramento", "수련의 장", "Campo de Testes", "Арена испытаний", "试炼场", "試煉場", }, 
},
["548"] = {
{ "Throne of the Tides", "Thron der Gezeiten", "Trono de las Mareas", "Trono de las Mareas", "Trône des marées", "Trono delle Maree", "파도의 왕좌", "Trono das Marés", "Трон Приливов", "潮汐王座", "海潮王座", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["646"] = {
{ "Scholomance", "Scholomance", "Scholomance", "Scholomance", "Scholomance", "Scholomance", "스칼로맨스", "Scolomântia", "Некроситет", "通灵学院", "通靈學院", }, 
},
["648"] = {
{ "Uldaman", "Uldaman", "Uldaman", "Uldaman", "Uldaman", "Uldaman", "울다만", "Uldaman", "Ульдаман", "奥达曼", "奧達曼", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["897"] = {
{ "Defend Sentinel Hill", "Verteidigt Späherkuppe", "Defiende Colina del Centinela", "Defiende la Colina del Centinela", "Défendre la colline des Sentinelles", "Difendere Guardiacolle", "감시의 언덕 방어", "Defenda o Morro da Sentinela", "Оборона Сторожевого холма", "保卫哨兵岭", "保衛哨兵嶺", }, 
{ "Defeat the Demon Commander", "Bezwingt den Dämonenkommandanten", "Derrota al comandante demoníaco", "Derrota al Comandante demoníaco", "Terrasser le commandant démon", "Sconfiggere il comandante demoniaco", "악마 사령관 처치", "Derrote o Demônio Comandante", "Победа над командиром демонов", "击败恶魔指挥官", "擊敗惡魔指揮官", }, 
{ "Repel the Legion Forces", "Schlagt die Streitkräfte der Legion zurück", "Rechaza a los ejércitos de la Legión", "Repele a las fuerzas de la Legión", "Repousser les troupes de la Légion", "Respingere le forze della Legione", "군단 격퇴", "Rechace as forças da Legião", "Отражение натиска Легиона", "击退军团部队", "擊退燃燒軍團", }, 
{ "Defeat the Demon Lord", "Bezwingt den Dämonenfürsten", "Derrota al señor demoníaco", "Derrota al Señor demoníaco", "Terrasser le seigneur démon", "Sconfiggere il Signore dei Demoni", "악마 군주 처치", "Derrote o Lorde Demônio", "Смерть повелителю демонов", "击败恶魔领主", "擊敗惡魔領主", }, 
},
["997"] = {
{ "test", "Willkommen", "Bienvenido", "Bienvenido", "Accueil", "Prova", "test", "test", "Добро пожаловать!", "测试", "test", }, 
},
["596"] = {
{ "Utgarde Keep", "Burg Utgarde", "Fortaleza de Utgarde", "Fortaleza de Utgarde", "Donjon d’Utgarde", "Forte Utgarde", "우트가드 성채", "Bastilha Utgarde", "Крепость Утгард", "乌特加德城堡", "俄特加德要塞", }, 
},
["593"] = {
{ "Ahn'kahet: The Old Kingdom", "Ahn'kahet: Das Alte Königreich", "Ahn'kahet: El Antiguo Reino", "Ahn'kahet: El Antiguo Reino", "Ahn’kahet : l’Ancien royaume", "Ahn'kahet, il Regno Antico", "안카헤트: 고대 왕국", "Ahn'kahet: O Velho Reino", "Ан'кахет: Старое Королевство", "安卡赫特：古代王国", "安卡罕特:古王國", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["1136"] = {
{ "Arcane Essence", "Arkane Essenz", "Esencia Arcana", "Esencia arcana", "L’essence arcanique", "Essenza Arcana", "비전 정수", "Essência arcana", "Чародейская сущность", "奥术精华", "秘法精華", }, 
{ "Becoming the Bait", "Zum Köder werden", "El arte de ser cebo", "Convirtiéndose en cebo", "Appât arcanique", "Diventare l'esca", "미끼가 된 대마법사", "Fazer-se de isca", "Наживку – на крючок", "成为诱饵", "成為誘餌", }, 
{ "Discovering Demons", "Dämonen entdecken", "Descubrir demonios", "Descubriendo demonios", "Découverte de démons", "Discernendo i demoni", "어디, 월척이 잡혔나?", "Descobrir demônios", "Игра в прятки с демонами", "发现恶魔", "發現惡魔", }, 
{ "Defeat Kreenam and Czaadym", "Kreenam und Czaadym bezwingen", "Derrota a Kreenam y Czaadym", "Derrota a Kreenam y Czaadym", "Terrasser Kreenam et Czaadym", "Sconfiggere Kreenam e Czaadym", "크리남과 크자딤 처치", "Derrotar Krynam e Czaadym", "Кринам и Чаадым", "击败克里纳姆和扎迪姆", "擊敗克力南和紮地姆", }, 
{ "Defeat Hakkar the Houndmaster", "Bezwingt Hakkar den Hundemeister", "Derrota a Hakkar, el maestro de canes", "Derrota a Hakkar el Maestro de los canes", "Vaincre Hakkar le dresseur de molosses", "Sconfiggere Hakkar il Maestro dei Segugi", "사냥개조련사 학카르 처치", "Derrotar Hakkar, o Mestre de Matilha.", "Победа над псарем Хаккаром", "击败驯犬者哈卡", "擊敗『馴犬者』哈卡爾", }, 
{ "Speak to Archmage Khadgar", "Sprecht mit Erzmagier Khadgar", "Habla con el archimago Khadgar", "Habla con el archimago Khadgar", "Parler à l’archimage Khadgar", "Due chiacchiere con l'Arcimago Khadgar", "대마법사 카드가와 대화", "Falar com Arquimago Hadggar", "Разговор с верховным магом Кадгаром", "和大法师卡德加谈谈", "與大法師卡德加交談", }, 
},
["1085"] = {
{ "Heal Vindicator Boros", "Heilt Verteidiger Boros", "Sanar al vindicador Boros", "Sana al Vindicador Boros", "Soigner le redresseur de torts Boros", "Cura il Vendicatore Boros", "구원자 보로스 치유", "Cure o Vindicante Boros", "Исцеление воздаятеля Бороса", "治疗守备官波鲁斯", "治療復仇者波羅斯", }, 
{ "To the Rescue", "Rettung in der Not", "Al rescate", "Al rescate", "Prêter main-forte", "Al salvataggio", "구출의 손길", "Ao resgate", "Путь к спасению", "生死救援", "救援行動", }, 
{ "Breaking Out", "Ausbruch", "La huida", "La fuga", "La gangr’évasion", "Fuga", "탈출", "A fuga", "На свободу", "生死逃亡", "越獄", }, 
{ "A Friend in Need", "Ein Freund in der Not", "Una amiga en apuros", "Un amigo en apuros", "Un ami dans le besoin", "Un amico in difficoltà", "도움이 필요한 친구", "Um amigo em apuros", "Друг в беде", "患难与共", "需要幫助的朋友", }, 
{ "What Evil Comes", "Welch Böses auch kommt", "El mal que surge", "La maldad que se aproxima", "L’origine du mal", "L'origine del male", "다가오는 악마의 정체", "Que mal virá", "Зло не дремлет", "无名邪恶", "邪惡降臨", }, 
{ "The Den of Evil", "Der Hort des Bösen", "La guarida del mal", "La guarida del mal", "L’antre du mal", "L'antro del male", "악의 소굴", "O antro do mal", "Логово зла", "恶之巢", "邪惡之巢", }, 
{ "The Beacon Relighted", "Das Leuchtfeuer neu entfacht", "La baliza se vuelve a encender", "La baliza vuelve a prenderse", "Le guide ravivé", "Riaccensione del faro", "다시 켜진 봉화", "O sinal reacendido", "Возвращение Светоча", "信标重燃", "重拾聖光", }, 
},
["1174"] = {
{ "Neltharion's Lair", "Neltharions Hort", "Guarida de Neltharion", "Guarida de Neltharion", "Repaire de Neltharion", "Antro di Neltharion", "넬타리온의 둥지", "Covil de Neltharion", "Логово Нелтариона", "奈萨里奥的巢穴", "奈薩里奧巢穴", }, 
},
["597"] = {
{ "Utgarde Keep", "Burg Utgarde", "Fortaleza de Utgarde", "Fortaleza de Utgarde", "Donjon d’Utgarde", "Forte Utgarde", "우트가드 성채", "Bastilha Utgarde", "Крепость Утгард", "乌特加德城堡", "俄特加德要塞", }, 
},
["239"] = {
{ "Boarding Party!", "Nicht klar zum Entern!", "¡Al abordaje!", "¡Al abordaje!", "On nous aborde !", "Squadra d'assalto!", "승선대다!", "Grupo de Abordagem!", "Абордаж!", "登船小队！", "登船小隊!", }, 
{ "Explosives Acquisition", "Sprengstoffakquisition", "Adquisición de explosivos", "Adquisición de explosivos", "Acquisition d’explosifs", "Recupero esplosivi", "폭탄물 획득", "Aquisição de Explosivos", "Добыть взрывчатку", "获取炸药", "取得炸藥", }, 
{ "To Smithereens!", "Zerstört das Allianzschiff!", "¡En mil pedazos!", "¡En mil pedazos!", "En mille morceaux !", "Falla a pezzi!", "산산조각내라!", "Pelos ares!", "В щепки!", "粉身碎骨！", "炸成碎片!", }, 
{ "Defeat the Admiral!", "Bezwingt den Admiral!", "¡Derrota al almirante!", "¡Derrota al almirante!", "À bas l’amiral !", "Sconfiggi l'Ammiraglio!", "제독을 처치하라!", "Derrote o Almirante!", "Победите адмирала!", "击败海军上将！", "打敗上將!", }, 
{ "Bonus Objectives", "Bonusziele", "Objetivos de bonificación", "Objetivos de bonificación", "Objectifs bonus", "Obiettivi bonus", "추가 목표", "Objetivos bônus", "Дополнительные задачи", "奖励目标", "獎勵目標", }, 
},
["1303"] = {
{ "Speak with Matron Mother Malevolence", "Auf ein Wort", "Hablar con la madre matriarca Malevolencia", "Habla con la Madre Matrona Malevolencia.", "Parler à la matrone Maléficiae", "La Matrona Suprema Malevola", "모군주 말레볼런스와 대화", "Falar com a Mãe Matrona Malévola", "Встреча с верховной матерью", "与主母玛沃伦丝交谈", "與懷惡族母交談", }, 
{ "Bat-Breaking", "Der Widerspenstigen Zähmung", "Doma de murciélagos", "Murciélago malote", "Chauve-domptage", "Spezzapipistrelli", "박쥐 길들이기", "Quebra-morcego", "Подчинение нетопыря", "驯养蝙蝠", "制服魔蝠", }, 
{ "The Scent of Blood", "Der Geruch des Blutes", "El aroma de la sangre", "El aroma de la sangre", "L’odeur du sang", "L'odore del sangue", "피의 향기", "Cheiro de Sangue", "Запах крови", "血之气息", "追血循跡", }, 
{ "A Strong Will", "Ein starker Wille", "Una voluntad fuerte", "Una voluntad férrea", "Volonté de fer", "Una volontà forte", "강한 의지", "A força da determinação", "Сильная воля", "坚强意志", "堅強的意志", }, 
{ "You Can Run...", "Kein Entkommen", "Puedes correr...", "Puedes huir...", "Cours toujours…", "Puoi scappare...", "도망쳐 봐야...", "Você Pode Correr...", "От меня не спрячешься", "无路可逃……", "儘管逃吧…", }, 
{ "Leap of Faith", "So nah und doch so fern", "Salto de fe", "Salto de fe", "Saut de foi", "Balzo della Fede", "신의의 도약", "Salto de Fé", "Прыжок в неизвестность", "信仰飞跃", "跳起來就對了", }, 
{ "Fel Dominance", "Teuflische Dominanz", "Dominancia vil", "Dominación vil", "Dressage final", "Vildominio", "지옥 정복", "Dominância Vil", "Подчинение Скверной", "邪能压制", "壓制魔蝠", }, 
{ "The Slayer's Steed", "Das Ross des Rächers", "El corcel del asesino", "La montura del Destripador", "La monture du vengeur", "Il destriero del Flagello dei Demoni", "학살자의 날개", "O Corcel do Matador", "Крылья истребителя", "屠魔者的坐骑", "斬魔者的戰騎", }, 
},
["639"] = {
{ "Hellfire Ramparts", "Höllenfeuerbollwerk", "Murallas del Fuego Infernal", "Murallas del Fuego Infernal", "Remparts des Flammes infernales", "Bastioni del Fuoco Infernale", "지옥불 성루", "Muralha Fogo do Inferno", "Бастионы Адского Пламени", "地狱火城墙", "地獄火壁壘", }, 
},
["539"] = {
{ "Temple of the Jade Serpent", "Tempel der Jadeschlange", "Templo del Dragón de Jade", "Templo del Dragón de Jade", "Temple du Serpent de jade", "Tempio della Serpe di Giada", "옥룡사", "Templo da Serpente de Jade", "Храм Нефритовой Змеи", "青龙寺", "玉蛟寺", }, 
},
["1255"] = {
{ "Halls of Valor", "Die Hallen der Tapferkeit", "Cámaras del Valor", "Salones del Valor", "Salles des Valeureux", "Sale del Valore", "용맹의 전당", "Salões da Bravura", "Чертоги Доблести", "英灵殿", "英靈殿", }, 
},
["598"] = {
{ "Prisoner of War", "Kriegsgefangene", "Prisionero de Guerra", "Prisionera de guerra", "Prisonnière de guerre", "Prigioniero di guerra", "전쟁 포로", "Prisioneiro de Guerra", "Пленница", "战俘", "戰俘", }, 
},
["696"] = {
{ "Start Timer", "Timer starten", "Iniciar temporizador", "Iniciar temporizador", "Démarrer le chronomètre", "Avvio conto alla rovescia", "초읽기 시작", "Inicie o tempo", "Запуск таймера", "开始计时器", "開始計時", }, 
},
["182"] = {
{ "Boarding Party!", "Nicht klar zum Entern!", "¡Al abordaje!", "¡Al abordaje!", "On nous aborde !", "Squadra d'assalto!", "승선대다!", "Grupo de Abordagem!", "Абордаж!", "登船小队！", "登船小隊!", }, 
{ "Explosives Acquisition", "Sprengstoffakquisition", "Adquisición de explosivos", "Adquisición de explosivos", "Acquisition d’explosifs", "Recupero esplosivi", "폭탄물 획득", "Aquisição de Explosivos", "Добыть взрывчатку", "获取炸药", "取得炸藥", }, 
{ "To Smithereens!", "Zerstört das Hordeschiff!", "¡En mil pedazos!", "¡En mil pedazos!", "En mille morceaux !", "Falla a pezzi!", "산산조각내라!", "Pelos ares!", "В щепки!", "粉身碎骨！", "炸成碎片!", }, 
{ "Defeat the Admiral!", "Bezwingt den Admiral!", "¡Derrota al almirante!", "¡Derrota al almirante!", "À bas l’amiral !", "Sconfiggi l'Ammiraglio!", "제독을 처치하라!", "Derrote o Almirante!", "Победите адмирала!", "击败海军上将！", "打敗上將!", }, 
{ "Bonus Objectives", "Bonusziele", "Objetivos de bonificación", "Objetivos de bonificación", "Objectifs bonus", "Obiettivi bonus", "추가 목표", "Objetivos bônus", "Дополнительные задачи", "奖励目标", "獎勵目標", }, 
},
["1244"] = {
{ "First Contact", "Erstkontakt", "Primer contacto", "Primer contacto", "Premier contact", "Primo contatto", "첫 조우", "Primeiro contato", "Первый контакт", "第一次接触", "第一次接觸", }, 
{ "System Overload", "Systemüberladung", "Sobrecarga del sistema", "Sobrecarga del sistema", "Surchauffe du système", "Sovraccarico del sistema", "시스템 과부하", "Sobrecarga do sistema", "Перегрузка системы", "系统过载", "系統超載", }, 
{ "This Ship Will Self-Destruct in...", "Selbstzerstörung des Schiffs in...", "La nave se autodestruirá en...", "Esta nave se autodestruirá en...", "Ce navire explosera dans…", "Questa nave si autodistruggerà entro...", "함선 자폭까지 남은 시간...", "Esta nau vai se autodestruir em...", "Корабль самоуничтожится через...", "本舰船即将自毁……", "這艘船艦即將自爆…", }, 
{ "Lord Mephistroth", "Lord Mephistroth", "Lord Mephistroth", "Lord Mephistroth", "Seigneur Méphistroth", "Sire Mefistroth", "군주 메피스트로스", "Lorde Mephistroph", "Владыка Мефистрот", "孟菲斯托斯", "梅菲斯托領主", }, 
},
["1125"] = {
{ "Follow the Caretaker", "Dem Verwalter folgen", "Sigue al custodio", "Sigue al Custodio", "Suivre le conservateur", "Seguire il Custode", "관리자 따라가기", "Siga o zelador", "Провожатый", "跟随管理员", "跟隨管理員", }, 
{ "Remove the Infestation", "Die Plage beseitigen", "Elimina la infestación", "Elimina la infestación", "Suppression des envahisseurs", "Rimuovere l'infestazione", "침입자 소탕", "Desinfestar", "Расправа над вредителями", "去除侵扰", "移除蟲害", }, 
{ "Locate Magni", "Findet Magni", "Localiza a Magni", "Localiza a Magni", "À la recherche de Magni", "Trovare Magni", "마그니 찾기", "Encontrar Magni", "Найти Магни", "找到麦格尼", "找到麥格尼", }, 
{ "Bring Down the Barrier", "Nieder mit der Barriere", "Destruye la barrera", "Derriba la barrera", "À bas la barrière", "Abbattere la barriera", "방벽 제거", "Rompendo barreiras", "Устранение барьера", "解除屏障", "解除屏障", }, 
{ "Defeat the Demons", "Die Dämonen bezwingen", "Derrota a los demonios", "Derrota a los demonios", "Terrasser les démons", "Sconfiggere i demoni", "악마 무리 처치", "Derrotar os demônios", "Одолеть демонов", "击败恶魔", "擊敗惡魔", }, 
{ "Escort Magni", "Begleitet Magni", "Escolta a Magni", "Escolta a Magni", "Escorter Magni", "Scortare Magni", "마그니 호위", "Escoltar Magni", "Сопровождение Магни", "护送麦格尼", "護送麥格尼", }, 
{ "Enter the Planetarium", "Betretet das Planetarium", "Entra en el Planetario", "Entra al Planetario", "Visite du planétarium", "Entrare nel Planetario", "투영관에 들어가기", "O Planetário", "Войти в планетарий", "进入天文台", "進入渾天儀", }, 
{ "The Diamond King's Message", "Die Botschaft des Diamantenkönigs", "El mensaje del rey de diamantes", "El mensaje del rey diamante", "Le message du roi de diamant", "Il messaggio del re dei diamanti", "다이아몬드 왕의 전언", "Mensagem do rei de diamante", "Слова алмазного короля", "钻石之王的消息", "鑽石之王有話要說", }, 
},
["1145"] = {
{ "Commence Bombardment!", "Das Bombardement beginnen", "¡Que comience el bombardeo!", "¡Comiencen el bombardeo!", "Feu à volonté !", "Fuoco alle polveri!", "폭격 개시!", "Iniciar o bombardeio!", "Готовсь... Цельсь... Пли!", "开始轰炸！", "開始轟炸！", }, 
{ "Glide Down to the Rendezvous", "Zum Treffpunkt hinuntergleiten", "Planea hasta el punto de encuentro", "Deslizamiento en descenso hacia el encuentro", "Planer jusqu’au point de rendez-vous", "Planare verso il punto di ritrovo", "고공 낙하", "Desça, planando, até o local de encontro", "Спуск к месту встречи", "滑翔到集合点", "滑翔前往集結地點", }, 
{ "Destroy the Legion", "Zerstört die Legion", "Destruye a la Legión", "Destruye a la Legión", "Détruire la Légion", "Annientare la Legione", "군단 섬멸", "Destrua a Legião", "Уничтожить Легион!", "消灭军团", "消滅燃燒軍團", }, 
{ "Regroup In Front of the Command Center", "Vor der Kommandozentrale versammeln", "Reagrupamiento frente al centro de mando", "Reagrupamiento frente al centro de mando", "Regroupement devant le centre de commandement", "Raduno al Centro di Comando", "사령부 앞에서 재집결", "Reagrupem-se em frente ao Centro de Comando", "Перегруппировка у флагманского корабля", "在指挥部前方重新集结", "在指揮中心前面重新整隊", }, 
{ "Fel Hammer, Fire!", "Teufelshammer, Feuer frei!", "¡Martillo Vil, fuego!", "¡Martillo Vil, fuego!", "Marteau gangrené, feu !", "Vilmartello, fuoco!", "지옥 망치호, 발사!", "Martelo Vil, fogo!", "Огонь!", "邪能之槌号，开火！", "魔錘號，射擊！", }, 
{ "Caria and Varedis At Last", "Caria und Varedis, endlich", "Caria y Varedis al fin", "Caria y Varedis, al fin", "Caria et Varedis, enfin…", "Caria e Varedis, alla fine ci incontriamo", "카리아와 베레디스의 최후", "Caria e Varedis, finalmente.", "Наказать предателей", "最后，只剩下凯丽娅和瓦雷迪斯", "凱莉亞和瓦瑞迪斯的終點", }, 
{ "Malevolence, Get Us Out of Here", "Malicia, bringt uns hier weg", "Malevolencia, sácanos de aquí", "Malevolencia, sácanos de aquí", "Maléficiae ! Nous devons sortir d’ici !", "Malevola, tiraci fuori da qui", "말레볼런스의 지원", "Malevolência, tire-nos daqui", "Злоба, вытащи нас отсюда.", "玛沃伦丝，带我们离开这里", "懷惡族母，帶我們離開這裡", }, 
},
["1037"] = {
{ "Culling the Cultists", "Kultisten knüppeln", "Diezmar a los cultores", "Sacrificando a los cultores", "Sectionner les sectateurs", "Epurare i cultisti", "이교도 혼내주기", "Extermínio de sectários", "Истребление сектантов", "屠杀教徒", "滅除教徒", }, 
{ "The Ghost King", "Der Geisterkönig", "El rey fantasma", "El Rey Fantasma", "Le roi fantôme", "Il re fantasma", "유령 왕", "O fantasma rei", "Король-призрак", "古王幽魂", "王魂", }, 
{ "Thoradin's Folly", "Thoradins Torheit", "La locura de Thoradin", "La locura de Thoradin", "La folie de Thoradin", "La follia di Thoradin", "소라딘의 어리석음", "O erro de Thoradin", "Ошибка Торадина", "索拉丁的愚行", "索拉丁的愚行", }, 
{ "The Tomb of Tyr", "Tyrs Grabmal", "La Tumba de Tyr", "La Tumba de Tyr", "Le tombeau de Tyr", "Tomba di Tyr", "티르의 무덤", "A tumba de Tyr", "Гробница Тира", "提尔之墓", "提爾之墓", }, 
{ "Cleansing the Desecration", "Läutern der Entweihung", "Purificar la profanación", "Purificando la profanación", "Purification de la corruption", "Purificare la dissacrazione", "황폐화 정화", "A limpeza da profanação", "Очищение от осквернения", "净化亵渎", "淨化穢瀆之物", }, 
{ "The Root of the Corruption", "Die Wurzel des Übels", "La raíz de la corrupción", "La raíz de la corrupción", "La corruption à sa source", "Le radici del male", "부패의 근원", "A raiz da corrupção", "Источник порчи", "堕落的根源", "腐化的根源", }, 
{ "The Dark Passage", "Die dunkle Passage", "El pasadizo oscuro", "El pasaje oscuro", "Le passage obscur", "Passaggio oscuro", "어두운 통로", "A passagem sombria", "Темный путь", "黑暗通道", "黑暗通道", }, 
{ "A Quick Execution", "Eine schnelle Hinrichtung", "Una ejecución rápida", "Una ejecución rápida", "Une prompte exécution", "Una rapida esecuzione", "빠른 처형", "Uma execução rápida", "Быстрая казнь", "高效处决", "引劍成一快", }, 
{ "To Kill a C'Thraxxi", "Einen C'Thraxxi töten", "Matar a un C'Thraxxi", "Matar a un C'Thraxxi", "Mort au C’Thraxxi", "Uccidere un C'thraxi", "크트락시 처치", "Crônica de um C'Thraxxi anunciado", "Смерть К'Тракси", "克拉西斯之死", "殺死克蘇拉希", }, 
{ "The Warbreaker", "Der Kriegsbrecher", "La Belígera", "El Belicista", "Le Brise-Guerre", "Spezzaguerra", "전쟁파괴자", "A Senhora da Guerra", "Миротворец", "灭战者", "破戰巨劍", }, 
},
["589"] = {
{ "The Violet Hold", "Die Violette Festung", "El Bastión Violeta", "El Bastión Violeta", "Le fort Pourpre", "Fortezza Violacea", "보랏빛 요새", "Castelo Violeta", "Аметистовая крепость", "紫罗兰监狱", "紫羅蘭堡", }, 
},
["689"] = {
{ "Skyreach", "Himmelsnadel", "Trecho Celestial", "Trecho Celestial", "Orée-du-Ciel", "Vetta dei Cieli", "하늘탑", "Beira-céu", "Небесный Путь", "通天峰", "擎天峰", }, 
},
["1155"] = {
{ "Where Are They?", "Wo sind sie?", "¿Dónde están?", "¿Dónde están?", "Où sont-ils ?", "Dove sono?", "포로 찾기", "Onde estarão?", "Где же они?", "他们在哪里？", "他們在哪裡？", }, 
{ "The Other Players", "Die anderen Spieler", "Los otros jugadores", "Los otros jugadores", "Les autres acteurs", "Gli altri partecipanti", "남은 자들", "Os outros jogadores", "Оставшиеся в строю", "剩余人士", "其他的角逐者", }, 
{ "The Third One", "Der Dritte", "El tercero", "El tercero", "Le troisième", "Il terzo", "세 번째 인원", "A terceira", "Третий", "第三个", "第三位", }, 
{ "An Unfortunate Accident", "Ein bedauernswerter Unfall", "Un desafortunado accidente", "Un desafortunado accidente", "Un accident des plus malencontreux", "Uno sfortunato incidente", "불행한 사고", "Um lamentável acidente", "Досадная случайность", "不幸的事故", "不幸的意外", }, 
{ "Back to Searching", "Weitersuchen", "Reanudar la búsqueda", "Una nueva búsqueda", "Reprise des recherches", "Continuare la ricerca", "수색 재개", "De volta à procura", "Поиски продолжаются", "继续搜索", "繼續搜索", }, 
{ "A Secret Meeting", "Geheimtreffen", "Una reunión secreta", "Una reunión secreta", "Rendez-vous secret", "Un incontro segreto", "비밀 만남", "Encontro secreto", "Тайная встреча", "秘密会见", "秘密會晤", }, 
{ "Back to the Manifest", "Nochmal von vorne", "De vuelta al manifiesto", "De vuelta al manifiesto", "Revenons-en au manifeste", "Di nuovo all'elenco", "감옥 명부", "De volta ao manifesto", "Продолжение поисков", "继续寻找名册", "繼續找名冊", }, 
{ "The Final Wing", "Der letzte Flügel", "La última ala", "La última ala", "La dernière aile", "L'ultima ala", "마지막 구역", "A última ala", "Последнее место для поисков", "最终之厅", "最後一區", }, 
{ "Baradin Hold", "Baradinfestung", "Bastión de Baradin", "Bastión de Baradin", "Le bastion de Baradin", "Forte di Baradin", "바라딘 요새", "Guarnição Baradin", "Крепость Барадин", "巴拉丁监狱", "巴拉丁堡", }, 
{ "The Eye of the Beast", "Das Auge der Bestie", "El ojo de la bestia", "El Ojo de la bestia", "L’œil de la Bête", "L'Occhio della Bestia", "괴물의 눈", "O olho da fera", "Око зверя", "野兽之眼", "野獸之眼", }, 
},
["581"] = {
{ "Halls of Lightning", "Die Hallen der Blitze", "Cámaras de Relámpagos", "Cámaras de Relámpagos", "Les salles de Foudre", "Sale del Fulmine", "번개의 전당", "Salões Relampejantes", "Чертоги Молний", "闪电大厅", "雷光大廳", }, 
},
["681"] = {
{ "Bloodmaul Slag Mines", "Blutschlägermine", "Minas Machacasangre", "Minas de Escoria Machacasangre", "Mine de la Masse-Sanglante", "Miniere dei Magliorosso", "피망치 잿가루 광산", "Minas de Escória do Malho Sangrento", "Шлаковые шахты Кровавого Молота", "血槌炉渣矿井", "熔渣礦場", }, 
},
["181"] = {
{ "Assault on Zan'vess", "Angriff auf Zan'vess", "Asalto a Zan'vess", "Asalto a Zan'vess", "L’attaque de Zan’vess", "Assalto a Zan'vess", "잔베스 강습", "Ataque a Zan'vess", "Атака на Зан'весс", "突袭扎尼维斯", "襲擊贊斐斯", }, 
{ "Defenses of Zan'vess", "Verteidigung von Zan'vess", "Defensas de Zan'vess", "Defensas de Zan'vess", "Les défenses de Zan’vess", "Difese di Zan'vess", "잔베스 수비진", "Defesas de Zan'vess", "Защитное поле Зан'весса", "防御扎尼维斯", "贊斐斯的防禦", }, 
{ "The Heart of Zan'vess", "Das Herz von Zan'vess", "El corazón de Zan'vess", "El corazón de Zan'vess", "Le cœur de Zan’vess", "Cuore di Zan'vess", "잔베스 중심부", "O Coração de Zan'vess", "Сердце Зан'весса", "扎尼维斯之心", "贊斐斯之心", }, 
{ "Weapons of Zan'vess", "Die Waffen von Zan'vess", "Armas de Zan'vess", "Armas de Zan'vess", "Les armes de Zan’vess", "Armi di Zan'vess", "잔베스의 무기들", "Armas de Zan'vess", "Оружие Зан'весса", "扎尼维斯的武装", "贊斐斯的武器", }, 
},
["682"] = {
{ "Grimrail Depot", "Grimmgleisdepot", "Terminal Malavía", "Depósito Riel siniestro", "Dépôt de Tristerail", "Treno Frecciacupa", "파멸철로 정비소", "Central do Carrilcruel", "Депо Мрачных Путей", "恐轨车站", "恐軌車站", }, 
{ "The Grimrail", "Der Grimmzug", "Malavía", "El Riel siniestro", "Le Tristerail", "Treno Frecciacupa", "파멸철로", "O Carrilcruel", "Мрачный Путь", "恐轨号", "恐軌列車", }, 
},
["582"] = {
{ "Halls of Stone", "Die Hallen des Steins", "Cámaras de Piedra", "Las Cámaras de Piedra", "Les salles de Pierre", "Sale della Pietra", "돌의 전당", "Salões Rochosos", "Чертоги Камня", "岩石大厅", "石之大廳", }, 
},
["528"] = {
{ "Mogu'shan Palace", "Mogu'shanpalast", "Palacio Mogu'shan", "Palacio Mogu'shan", "Palais Mogu’shan", "Palazzo Mogu'shan", "모구샨 궁전", "Palácio Mogu'shan", "Дворец Могу'шан", "魔古山宫殿", "魔古山宮", }, 
},
["428"] = {
{ "Shadowmoon Burial Grounds", "Schattenmondgrabstätte", "Cementerio de Sombraluna", "Cementerios de Sombraluna", "Terres sacrées d’Ombrelune", "Necropoli dei Torvaluna", "어둠달 지하묘지", "Sepulcrário da Lua Negra", "Некрополь Призрачной Луны", "影月墓地", "影月墓地", }, 
},
["824"] = {
{ "The Windrunner", "Die Windläufer", "El Brisaveloz", "El Brisaveloz", "Le Coursevent", "Ventolesto", "윈드러너호", "O Correventos", "\"Ветрокрылая\"", "风行者", "風行者", }, 
{ "The Eternity", "Die Ewigkeit", "La Eternidad", "La eternidad", "L’Éternité", "Eternità Infinita", "영원호", "O Eternidade", "\"Вечность\"", "永恒号", "永恆之境", }, 
{ "The Blightcaller", "Die Pestrufer", "El Clamañublo", "El Clamañublo", "Le Flétrisseur", "Invocatrice del Morbo", "역병소환사호", "O Pestífero", "\"Призыватель гибели\"", "凋零使徒号", "凋零者", }, 
{ "The Black Rose", "Die Schwarze Rose", "La Rosa Negra", "La Rosa Negra", "La Rose noire", "Rosa Nera", "흑장미호", "Rosa Negra", "\"Черная Роза\"", "黑玫瑰号", "黑玫瑰號", }, 
{ "Boarding the Skyfire", "An Bord der Himmelsfeuer", "Abordar El Abrasacielos", "Abordar el Abrasacielos", "Abordage du Brûleciel", "Abbordare la Fuoco Celeste", "하늘불꽃호 승선", "Abordagem do Celesfogo", "Высадка на \"Небесный огонь\"", "登上天火号", "登上天火號", }, 
{ "Queen Takes King", "Dame schlägt König", "La reina se come al rey", "La reina derrota al rey", "Échec au roi", "Regina mangia Re", "여왕이 왕을 잡다", "Rainha toma rei", "Королева бьет короля", "后吃王", "女王對國王", }, 
},
["873"] = {
{ "Pushing Them Back", "Drängt sie zurück", "Hacerlos retroceder", "Rechazarlos", "Nettoyage en règle", "Respingere i nemici", "동작 그만!", "Façam-nos recuar", "Остановите нашествие", "击退他们", "擊退敵人", }, 
{ "Suppressing the Source", "Die Quelle unterdrücken", "Suprimir la fuente", "Suprimir la fuente", "Tarir la source", "Bloccare la fonte", "동력 차단", "Supressão da fonte", "Ликвидация источника", "掐灭源头", "截斷來源", }, 
{ "Defend the Outpost", "Verteidigt den Außenposten", "Defiende la avanzada", "Defiende el Puesto de avanzada", "Défendre l’avant-poste", "Difendere l'avamposto", "전초기지 방어", "Defenda o posto-avançado", "Защита аванпоста", "保卫岗哨", "防衛哨站", }, 
},
["673"] = {
{ "Start Timer", "Timer starten", "Iniciar temporizador", "Iniciar temporizador", "Démarrer le chronomètre", "Avvio contro alla rovescia", "초읽기 시작", "Inicie o tempo", "Запуск таймера", "开始计时器", "開始計時", }, 
{ "Timer Over", "Zeit abgelaufen", "Temporizador finalizado", "Temporizador terminado", "Temps dépassé", "Tempo esaurito", "제한 시간 종료", "Acabou o tempo", "Время истекло", "时间到", "時間結束", }, 
},
["1166"] = {
{ "Black Rook Hold", "Die Rabenwehr", "Torreón Grajo Negro", "Fuerte Torre Oscura", "Le bastion du Freux", "Forte Corvonero", "검은 떼까마귀 요새", "Castelo Corvo Negro", "Крепость Черной Ладьи", "黑鸦堡垒", "玄鴉堡", }, 
},
["1336"] = {
{ "The Tidestone's Rest", "Die Rast des Gezeitensteins", "Reposo de la Piedramar", "El descanso de la Maretista", "Repos de la Pierre-des-Marées", "Requie della Pietra delle Maree", "해일석의 안식처", "Repouso da Pedramar", "Покои Приливного камня", "潮汐之眠", "潮石之息", }, 
},
["988"] = {
{ "The Downward Spiral", "Die Abwärtsspirale", "La espiral descendente", "La espiral descendente", "Spirale descendante", "La spirale discendente", "지하로 내려가기", "A espiral descendente", "Вниз по винтовой лестнице", "逆塔", "往下的迴旋樓梯", }, 
{ "Grasp of the Damned", "Umklammerung der Verdammten", "En manos de los malditos", "El alcance de los malditos", "L’emprise des damnés", "Presa dei dannati", "저주받은 자의 손아귀", "Garras dos condenados", "Хватка проклятых", "亡者之握", "詛咒之握", }, 
{ "Removal Protocols", "Entfernungsprotokolle", "Protocolos de eliminación", "Protocolos de eliminación", "Protocoles d’élimination", "Protocolli di rimozione", "작동규약 제거", "Protocolos de remoção", "Протоколы ликвидации", "清除协议", "移除程序", }, 
{ "Reap the Harvester", "Mäht den Ernter nieder", "Alzarse con la Falce", "Siega la Cosechadora", "Faucher la faux", "Mietere la Mietitrice", "수확기 수확", "Ceife a Ceifadora", "Жатва Жнеца", "收割者将被收割", "奪得收割者", }, 
{ "The Rider's Prize", "Der Preis des Reiters", "El trofeo del jinete", "El premio del jinete", "Le trophée du cavalier", "Il premio dei Cavalieri", "기수의 유물", "O prêmio do cavalgante", "Трофей всадника", "黑骑士的财宝", "黑騎兵的寶物", }, 
{ "Ulthalesh Feasts", "Ulthalesh labt sich", "El festín de Ulthalesh", "Festines de Ulthalesh", "Le festin d’Ulthalesh", "Il banchetto di Ulthalesh", "울타레쉬의 포식", "Ulthalesh se deleita", "Пир Ултхалеша", "乌萨勒斯的盛宴", "烏薩萊許大快朵頤", }, 
{ "0", "", "", "", "", "", "", "", "", "", "", }, 
},
["573"] = {
{ "Halls of Reflection", "Hallen der Reflexion", "Cámaras de Reflexión", "Cámaras de Reflexión", "Salles des Reflets", "Sale dei Riflessi", "투영의 전당", "Salões da Reflexão", "Залы Отражений", "映像大厅", "倒影大廳", }, 
},
["680"] = {
{ "Bloodmaul Slag Mines", "Blutschlägermine", "Minas Machacasangre", "Minas de escoria Machacasangre", "Mine de la Masse-Sanglante", "Miniere dei Magliorosso", "피망치 잿가루 광산", "Minas de Escória do Malho Sangrento", "Шлаковые шахты Кровавого Молота", "血槌炉渣矿井", "血槌熔渣礦場", }, 
},
["580"] = {
{ "Halls of Lightning", "Die Hallen der Blitze", "Cámaras de Relámpagos", "Cámaras de Relámpagos", "Les salles de Foudre", "Sale del Fulmine", "번개의 전당", "Salões Relampejantes", "Чертоги Молний", "闪电大厅", "雷光大廳", }, 
},
["499"] = {
{ "Invasion!", "Invasion!", "¡Invasión!", "¡Invasión!", "Alerte aux envahisseurs !", "Invasione!", "침략!", "Invasão!", "Вторжение!", "入侵！", "入侵！", }, 
{ "Ambush", "Hinterhalt", "Emboscada", "Emboscada", "Embuscade", "Imboscata", "습격", "Emboscada", "Засада", "伏击", "伏擊", }, 
{ "The Holdout", "Durchhaltevermögen", "La resistencia", "La resistencia", "Le baroud", "Resistenza", "항전", "A Resistência", "Продержаться подольше", "坚持到底", "堅持到底", }, 
{ "Cleanup", "Aufräumkommando", "Limpieza", "Limpieza", "Nettoyage", "Ripulitura", "소탕", "Limpeza", "Зачистка", "摧枯拉朽", "收拾殘局", }, 
{ "The Calm", "Ruhe nach dem Sturm", "La calma", "La calma", "Le calme", "La calma", "정적", "A Calma", "Затишье", "风平浪静", "歇息備戰", }, 
{ "It is Near", "Es ist in der Nähe", "Está cerca", "Está cerca", "C’est tout près", "È vicino", "무언가 다가온다", "Esté perto", "Оно уже рядом", "它过来了", "就在眼前", }, 
{ "Bronze", "Bronze", "Bronce", "Bronce", "Bronze", "Bronzo", "동메달", "Bronze", "Бронза", "青铜级", "青銅", }, 
{ "Silver", "Silber", "Plata", "Plata", "Argent", "Argento", "은메달", "Prata", "Серебро", "白银级", "白銀", }, 
{ "Gold", "Gold", "Oro", "Oro", "Or", "Oro", "금메달", "Ouro", "Золото", "黄金级", "黃金", }, 
{ "Platinum", "Platin", "Platino", "Platino", "Platine", "Platino", "백금메달", "Platina", "Платина", "白金", "白金", }, 
},
["215"] = {
{ "Speak to Taoshi", "Sprecht mit Taoshi", "Habla con Taoshi", "Habla con Taoshi", "Parler à Taoshi", "Parla con Taoshi", "타오스와 대화", "Falar com Taoshi", "Поговорить с Таоши", "与陶矢交谈", "與陶氏說話", }, 
{ "Reach the Exit", "Erreicht den Ausgang", "Alcanza la salida", "Alcanza la salida", "Atteindre la sortie", "Raggiungi l'uscita", "출구로 이동", "Alcançar a Saída", "Добраться до выхода", "到达出口", "抵達出口", }, 
},
["599"] = {
{ "Prisoner of War", "Kriegsgefangene", "Prisionero de Guerra", "Prisionera de guerra", "Prisonnière de guerre", "Prigioniero di guerra", "전쟁 포로", "Prisioneiro de Guerra", "Пленница", "战俘", "戰俘", }, 
{ "Commander Stoutbeard defeated", "Kommandant Starkbart bezwungen", "Comandante Barbarrecia derrotado", "Comandante Barbarrecia derrotado.", "Commandant Rudebarbe vaincu", "Sconfiggi il Comandante Barbaforte", "사령관 스타우트비어드 처치", "Comandante Barbacã derrotado", "Командир Пивобород повержен", "击败指挥官斯托比德", "已擊敗指揮官厚鬚", }, 
},
["515"] = {
{ "Disciples of Naralex", "Jünger von Naralex", "Discípulos de Naralex", "Discípulos de Naralex", "Les disciples de Naralex", "Discepoli di Naralex", "나랄렉스의 제자", "Discípulos de Naralex", "Послушники Наралекса", "纳拉雷克斯的信徒", "納拉雷克斯侍徒", }, 
{ "Disciples of Naralex", "Jünger von Naralex", "Discípulos de Naralex", "Discípulos de Naralex", "Les disciples de Naralex", "Discepoli di Naralex", "나랄렉스의 제자", "Discípulos de Naralex", "Послушники Наралекса", "纳拉雷克斯的信徒", "納拉雷克斯侍徒", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["615"] = {
{ "The Mechanar", "Die Mechanar", "El Mechanar", "El Mechanar", "Le Méchanar", "Mecanar", "메카나르", "Mecanar", "Механар", "能源舰", "麥克納爾", }, 
},
["591"] = {
{ "Drak'Tharon Keep", "Feste Drak'Tharon", "Fortaleza de Drak'Tharon", "Fortaleza de Drak'Tharon", "Donjon de Drak’Tharon", "Forte di Drak'Tharon", "드락타론 성채", "Bastilha Drak'Tharon", "Крепость Драк'Тарон", "达克萨隆要塞", "德拉克薩隆要塞", }, 
},
["992"] = {
{ "Maw of Souls", "Der Seelenschlund", "Fauce de Almas", "Fauces de almas", "Gueule des âmes", "Fauci delle Anime", "영혼의 아귀", "Gorja das Almas", "Утроба душ", "噬魂之喉", "靈魂之喉", }, 
},
["678"] = {
{ "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "아킨둔", "Auchindoun", "Аукиндон", "奥金顿", "奧齊頓", }, 
},
["592"] = {
{ "Ahn'kahet: The Old Kingdom", "Ahn'kahet: Das Alte Königreich", "Ahn'kahet: El Antiguo Reino", "Ahn'kahet: El Antiguo Reino", "Ahn’kahet : l’Ancien royaume", "Ahn'kahet, il Regno Antico", "안카헤트: 고대 왕국", "Ahn'kahet: O Velho Reino", "Ан'кахет: Старое Королевство", "安卡赫特：古代王国", "安卡罕特:古王國", }, 
},
["278"] = {
{ "Noodle Time", "Nudelzeit", "La hora de los fideos", "La hora de los fideos", "L’heure des nouilles", "Spaghetti a volontà", "국수 시간", "Hora do Macarrão", "Час лапши", "汤面时间", "湯麵時刻", }, 
{ "Bonus: Go for the Gold!", "Bonus: Siegertreppchen!", "Bonus: ¡A por el oro!", "Bonus: ¡Ve por el oro!", "Bonus : tentez l’or !", "Bonus: punta all'oro!", "보너스: 금메달을 향해!", "Bônus: Tente o ouro!", "Бонус: золото ждать не будет!", "奖励：冲向黄金！", "獎勵目標:金牌挑戰", }, 
},
["1335"] = {
{ "Cathedral of Eternal Night", "Kathedrale der Ewigen Nacht", "Catedral de la Noche Eterna", "Catedral de la Noche eterna", "Cathédrale de la Nuit éternelle", "Cattedrale della Notte Eterna", "영원한 밤의 대성당", "Catedral da Noite Eterna", "Собор Вечной Ночи", "永夜大教堂", "永夜聖殿", }, 
{ "Cathedral of Eternal Night", "Kathedrale der Ewigen Nacht", "Catedral de la Noche Eterna", "Catedral de la Noche eterna", "Cathédrale de la Nuit éternelle", "Cattedrale della Notte Eterna", "영원한 밤의 대성당", "Catedral da Noite Eterna", "Собор Вечной Ночи", "永夜大教堂", "永夜聖殿", }, 
},
["614"] = {
{ "The Mechanar", "Die Mechanar", "El Mechanar", "El Mechanar", "Le Méchanar", "Mecanar", "메카나르", "Mecanar", "Механар", "能源舰", "麥克納爾", }, 
},
["983"] = {
{ "Into the Skies", "In die Lüfte", "Hacia los cielos", "Hasta el cielo", "Dans les cieux", "Nel cuore del cielo", "저 하늘 위로", "Céus acima", "В небеса", "一步登天", "進入天空", }, 
{ "Running In The Clouds", "Rennen in den Wolken", "Correr por las nubes", "Corriendo entre las nubes", "Course dans les nuages", "A spasso tra le nubi", "구름을 달리다", "Corrida nas nuvens", "Бегущие по облакам", "腾云驾雾", "奔跑在雲端", }, 
{ "A Shocking Development", "Eine schockierende Entwicklung", "Un desarrollo impactante", "Un progreso impactante", "Ambiance survoltée", "Uno sviluppo sconcertante", "비약적인 발전", "Um acontecimento chocante", "Шокирующий поворот", "惊天动地", "驚人的發展", }, 
{ "Against The Storm", "Gegen den Sturm", "Contra la tormenta", "Contra la tormenta", "À l’épreuve des tempêtes", "Contro la tempesta", "폭풍에 맞서기", "Contra a tempestade", "Противостояние буре", "抗击风暴", "抵抗風暴", }, 
{ "Dragon Wrangling", "Drachenringen", "Doma de dragones", "Dragón atrapado", "Domptage draconique", "Domatore di draghi", "폭풍용을 타고", "Como domar um dragão", "Объездка дракона", "降龙伏虎", "與龍激鬥", }, 
{ "The Tyrant of Skywall", "Der Tyrann des Himmelswalls", "El tirano del Muro Celeste", "El tirano de Muro Celeste", "Le tyran de Mur-Céleste", "Il tiranno di Celaria", "하늘담의 폭군", "O tirano da Muralha Celeste", "Тиран Небесной выси", "天空之墙的统治者", "天空之牆的暴君", }, 
{ "Fists of the Heavens", "Fäuste der Himmel", "Puños de los Cielos", "Puños de los Cielos", "Poings des cieux", "Pugni del Cielo", "하늘의 주먹", "Punhos do Paraíso", "Кулаки Небес", "诸天之拳", "蒼天之拳", }, 
},
["1134"] = {
{ "A Personal Request", "Eine persönliche Bitte", "Un favor personal", "Una petición personal", "Une requête personnelle", "Una richiesta personale", "개인적인 부탁", "Um pedido pessoal", "Личная просьба", "私人请求", "私人請求", }, 
{ "A Bold Rescue", "Eine kühne Rettung", "Un rescate atrevido", "Un rescate audaz", "Un sauvetage des plus audacieux", "Un salvataggio audace", "대담한 구출", "Resgate ousado", "Дерзкое спасение", "大胆的营救", "大膽援救", }, 
{ "Prisoner No More", "Nie wieder Gefangener", "Fin del cautiverio", "Prisionero, ya no más", "Liberté retrouvée", "Mai più prigioniero", "그대에게 자유를", "Chega de ser prisioneiro", "На свободу!", "不再是阶下囚", "重獲自由", }, 
},
["207"] = {
{ "Taking Off...", "Abgehoben…", "¡Despegando!", "¡Despegando!", "Décollage…", "Decollo...", "이륙...", "Decolando...", "Взлетаем!", "起飞……", "動身...", }, 
{ "Intercepted!", "Abgefangen!", "¡Te han interceptado!", "¡Te han interceptado!", "Intercepté !", "Intercettato!", "발각!", "Interceptado!", "Перехват!", "遭遇拦截！", "攔截!", }, 
{ "Master the Beastmaster", "Meistert den Bestienmeister", "Domina al maestro de bestias", "Domina al maestro de bestias", "Maîtriser le belluaire", "Domare il Maestro delle Bestie", "야수조련사 조련하기", "Dominar o Senhor das Feras", "Обуздать повелителя зверей", "击败兽王", "馴服馴獸者", }, 
{ "Into the Mines", "In die Minen", "Hacia las minas", "Hacia las minas", "Dans la mine", "Nelle miniere", "광산으로", "Entrando nas minas", "В шахту!", "进入矿洞", "進入礦坑", }, 
{ "What's Yours is Mine!", "Meine Mine!", "¡Lo tuyo es mío!", "¡Lo tuyo es mío!", "Vous avez bonne mine !", "Quel che è tuo è mio!", "네 것은 내 것!", "A mina da hora!", "Было твое, стало мое!", "你的矿洞就是我的矿洞！", "你的礦就是我的礦!", }, 
{ "Cover Me!", "Gebt mir Deckung!", "¡Cúbreme!", "¡Cúbreme!", "Couvrez-moi !", "Coprimi!", "엄호해줘요!", "Me dê cobertura!", "Прикрой меня!", "掩护我！", "掩護我!", }, 
},
["583"] = {
{ "A Royal Escort", "Die Eskorte des Königs", "Una escolta real", "Una escolta real", "Une escorte royale", "Scorta reale", "왕 호위", "Uma escolta real", "Королевский эскорт", "皇家护卫", "護送皇室", }, 
},
["46"] = {
{ "Shado-Pan Monastery", "Shado-Pan-Kloster", "Monasterio del Shadopan", "Monasterio del Shadopan", "Monastère des Pandashan", "Monastero degli Shandaren", "음영파 수도원", "Monastério Shado-pan", "Монастырь Шадо-Пан", "影踪禅院", "影潘僧院", }, 
},
["707"] = {
{ "Invasion!", "Invasion!", "¡Invasión!", "¡Invasión!", "Alerte aux envahisseurs !", "Invasione!", "침략!", "Invasão!", "Вторжение!", "入侵！", "入侵！", }, 
{ "Ambush", "Hinterhalt", "Emboscada", "Emboscada", "Embuscade", "Imboscata", "습격", "Emboscada", "Засада", "伏击", "伏擊", }, 
{ "The Holdout", "Durchhaltevermögen", "La resistencia", "La resistencia", "Le baroud", "Resistenza", "항전", "A Resistência", "Продержаться подольше", "坚持到底", "堅持到底", }, 
{ "Cleanup", "Aufräumkommando", "Limpieza", "Limpieza", "Nettoyage", "Ripulitura", "소탕", "Limpeza", "Зачистка", "摧枯拉朽", "收拾殘局", }, 
{ "The Calm", "Ruhe nach dem Sturm", "La calma", "La calma", "Le calme", "La calma", "정적", "A Calma", "Затишье", "风平浪静", "歇息備戰", }, 
{ "The Forest Walks", "Ränkespiele", "El bosque anda", "Los caminos del bosque", "La forêt en marche", "La foresta cammina", "숲이 걸어온다", "A floresta se move", "Лес движется", "移动的森林", "森林動起來", }, 
{ "Bronze", "Bronze", "Bronce", "Bronce", "Bronze", "Bronzo", "동메달", "Bronze", "Бронза", "青铜级", "青銅", }, 
{ "Silver", "Silber", "Plata", "Plata", "Argent", "Argento", "은메달", "Prata", "Серебро", "白银级", "白銀", }, 
{ "Gold", "Gold", "Oro", "Oro", "Or", "Oro", "금메달", "Ouro", "Золото", "黄金级", "黃金", }, 
{ "Platinum", "Platin", "Platino", "Platino", "Platine", "Platino", "백금메달", "Platina", "Платина", "白金", "白金", }, 
},
["607"] = {
{ "The Shattered Halls", "Die Zerschmetterten Hallen", "Las Salas Arrasadas", "Las Salas Arrasadas", "Les salles Brisées", "Sale della Devastazione", "으스러진 손의 전당", "Salões Despedaçados", "Разрушенные залы", "破碎大厅", "破碎大廳", }, 
},
["183"] = {
{ "Prepare the Defenses", "Bereitet die Verteidigung vor", "Prepara las defensas", "Prepara las defensas", "Préparer les défenses", "Prepara le difese", "수비를 준비하라", "Prepare as defesas", "Подготовка укреплений", "准备防御", "防守準備", }, 
{ "Kill Commander Scargash", "Tötet Kommandant Schlitznarbe", "Mata al comandante Sangrescara", "Mata al comandante Sangrescara", "Tuer le commandant Coupentaille", "Uccidi il Comandante Sventracuori", "사령관 스카가쉬 살상 명령", "Mate o Comandante Escorchaga", "Убить командира Глубокого Шрама", "击败指挥官斯卡戈什", "殺了指揮官疤口", }, 
},
["206"] = {
{ "Rendezvous with Scout Captain Elsia", "Trefft Euch mit Späherhauptmann Elsia", "Reúnete con la capitana de exploradores Elsia", "Reúnete con la capitana de exploradores Elsia", "Rendez-vous avec le capitaine des éclaireurs Elsia", "Incontra il Capitano degli Esploratori Elsia", "정찰대장 엘시아와 접선", "Encontrar-se com a Capitã dos Batedores Elsia", "Встреча с капитаном разведчиков Эльсией", "与斥候队长艾尔希娅会合", "和斥候隊長艾爾西雅會合", }, 
{ "Survive the Ambush", "Überlebt den Überfall", "Sobrevive a la emboscada", "Sobrevive a la emboscada", "Survivre à l’embuscade", "Sopravvivi all'imboscata", "기습에서 생존", "Sobreviva à emboscada", "Пережить нападение", "在伏击中幸存下来", "撐過敵人的埋伏", }, 
{ "Destroy the Barricades", "Zerstört die Barrikaden", "Destruye las barricadas", "Destruye las barricadas", "Détruire les barricades", "Distruggi le barricate", "방벽 파괴", "Destruir as barricadas", "Разрушить баррикады", "摧毁屏障", "摧毀路障", }, 
{ "Kill Kresh the Ripper", "Tötet Kresh den Reißer", "Mata a Kresh el Destripador", "Mata a Kresh el Destripador", "Tuer Kresh l’éventreur", "Uccidi Kresh lo Squartatore", "학살자 크레쉬 처치", "Matar Cresh, o Estripador", "Убить Креша Раздирателя", "击败撕裂者科尔什", "殺死『撕裂者』克雷什", }, 
{ "Kill Arcanital Tula'chek and his Spirit Mask", "Tötet Arkanital Tula'chek und seine Geistermaske", "Mata al arcanital Tula'chek y a su máscara espíritu", "Mata al arcanital Tula'chek y a su máscara espíritu", "Tuer le rituarcaniste Tula’chek et son masque d’esprit", "Elimina Tula'chek e la Maschera Spiritica", "비전주술사 툴라첵과 영혼 가면 처치", "Matar o Arcanital Tula'chek e sua Máscara Espiritual", "Убить чародея-ритуалиста Тула'чека и его маску духов", "击败魔术士图拉奇克和他的灵魂面具", "殺死秘宗圖拉切與他的靈魂面具", }, 
},
["734"] = {
{ "Lower Blackrock Spires", "Untere Schwarzfelsspitze", "Cumbre de Roca Negra Inferior", "Cumbres de Roca Negra inferiores", "Bas du pic Rochenoire", "Bastioni di Roccianera Inferiori", "검은바위 첨탑 하층", "Picos da Rocha Negra Inferior", "Нижняя часть пика Черной горы", "黑石塔下层", "黑石塔下層", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["590"] = {
{ "Drak'Tharon Keep", "Feste Drak'Tharon", "Fortaleza de Drak'Tharon", "Fortaleza de Drak'Tharon", "Donjon de Drak’Tharon", "Forte di Drak'Tharon", "드락타론 성채", "Bastilha Drak'Tharon", "Крепость Драк'Тарон", "达克萨隆要塞", "德拉克薩隆要塞", }, 
},
["569"] = {
{ "Pit of Saron", "Grube von Saron", "Foso de Saron", "Foso de Saron", "Fosse de Saron", "Fossa di Saron", "사론의 구덩이", "Fosso de Saron", "Яма Сарона", "萨隆矿坑", "薩倫之淵", }, 
},
["669"] = {
{ "Detention Block", "Gefängnisblock", "Bloque de Detención", "Bloque de Detención", "Le mitard", "Blocco di Detenzione", "감금 구역", "Bloco de Detenção", "Тюремный блок", "禁闭室", "禁閉室", }, 
{ "Ring of Law", "Ring des Gesetzes", "Círculo de la Ley", "Círculo de la Ley", "Cercle de la loi", "Anello della Legge", "법의 심판장", "Círculo da Lei", "Зал Правосудия", "秩序竞技场", "秩序競技場", }, 
{ "High Interrogator Gerstahn", "Verhörmeisterin Gerstahn", "Alta interrogadora Gerstahn", "Alta interrogadora Gerstahn", "Grande interrogatrice Gerstahn", "Gerstahn la Grande Accusatrice", "대심문관 게르스탄", "Suprema Interrogadora Gerstahn", "Верховный дознаватель Герштан", "审讯官格斯塔恩", "高階審問者格斯塔恩", }, 
{ "Bael'Gar", "Bael'Gar", "Bael'Gar", "Bael'Gar", "Bael’Gar", "Bael'gar", "밸가르", "Bael'gar", "Бейл'Гор", "贝尔加", "貝爾加", }, 
},
["180"] = {
{ "Infiltrate the Ancient Fortress", "Infiltration der uralten Festung", "Infíltrate en la antigua fortaleza", "Infíltrate en la antigua fortaleza", "Infiltrer l’ancienne forteresse", "Penetra nell'Antica Fortezza", "고대 요새 침투", "Infiltre-se na Fortaleza Ancestral", "Проникнуть в древнюю крепость", "潜入远古堡垒", "潛入遠古堡壘", }, 
{ "Stealing for Profit", "Auf Beutezug", "El beneficio del robo", "El beneficio del robo", "Voler pour s’enrichir", "Profitto a tutti i costi", "훔칠수록 이득", "Roubando pelo Lucro", "Украсть ради наживы", "偷来横财", "偷盜得利", }, 
},
["525"] = {
{ "Siege of Niuzao Temple", "Belagerung des Niuzaotempels", "Asedio del Templo de Niuzao", "Asedio del Templo de Niuzao", "Siège du temple de Niuzao", "Assedio al Tempio di Niuzao", "니우짜오 사원 공성전투", "Cerco ao Templo Niuzao", "Осада храма Нюцзао", "围攻砮皂寺", "圍攻怒兆寺", }, 
},
["425"] = {
{ "Bloodmaul Slag Mines", "Blutschlägermine", "Minas Machacasangre", "Minas de escoria Machacasangre", "Mine de la Masse-Sanglante", "Miniere dei Magliorosso", "피망치 잿가루 광산", "Minas de Escória do Malho Sangrento", "Шлаковые шахты Кровавого Молота", "血槌炉渣矿井", "血槌熔渣礦場", }, 
},
["625"] = {
{ "Old Hillsbrad Foothills", "Vorgebirge des Alten Hügellands", "Antiguas Laderas de Trabalomas", "Antiguas Laderas de Trabalomas", "Contreforts de Hautebrande d’antan", "Passato di Colletorto", "옛 언덕마루 구릉지", "Antigo Contraforte de Eira dos Montes", "Старые предгорья Хилсбрада", "旧希尔斯布莱德丘陵", "希爾斯布萊德丘陵舊址", }, 
},
["962"] = {
{ "Far From Home", "Fern der Heimat", "Lejos de casa", "Lejos de casa", "Loin du foyer", "Lontani da casa", "집 떠나와", "Longe de casa", "Вдали от дома", "背井离乡", "遠離家園", }, 
{ "The Dread Warden", "Der Schreckenswächter", "El celador aterrador", "El celador del terror", "Le gardien de l’effroi", "Il Guardiano del Terrore", "공포의 감시관", "O carcereiro medonho", "Жуткий тюремщик", "可怕的狱卒", "驚懼獄卒", }, 
{ "The Shattered Council", "Der zerschmetterte Rat", "El consejo dispersado", "El consejo destrozado", "Le conseil brisé", "Il concilio infranto", "산산이 조각난 의회", "O conselho despedaçado", "Рассеянный Совет", "破碎的议会", "破碎的議會", }, 
{ "Jailbreak", "Ausbruch aus dem Gefängnis", "Fuga", "Fuga", "Évasion", "Evasione", "탈옥", "Fuga para a vitória", "Побег из тюрьмы", "越狱", "越獄", }, 
{ "The Pit Lord's Secrets", "Die Geheimnisse des Grubenlords", "Los secretos del señor del foso", "Los secretos del señor del foso", "Les secrets du seigneur des abîmes", "I segreti del Signore delle Fosse", "지옥의 군주의 비밀", "Os segredos do lorde abissal", "Секреты властителя преисподней", "深渊领主的秘密", "深淵領主的秘密", }, 
{ "To Fight Another Day", "Die Schlacht vertagen", "Luchar otro día", "Para luchar un día más", "Survivre pour mieux combattre", "Vivere per combattere un altro giorno", "또 하루를 싸우려", "Não é fuga, é retirada", "Мы еще сразимся", "留得青山在", "留得青山在", }, 
},
["688"] = {
{ "Skyreach", "Himmelsnadel", "Trecho Celestial", "Trecho Celestial", "Orée-du-Ciel", "Vetta dei Cieli", "하늘탑", "Beira-céu", "Небесный Путь", "通天峰", "擎天峰", }, 
},
["588"] = {
{ "The Violet Hold", "Die Violette Festung", "El Bastión Violeta", "El Bastión Violeta", "Le fort Pourpre", "Fortezza Violacea", "보랏빛 요새", "Castelo Violeta", "Аметистовая крепость", "紫罗兰监狱", "紫羅蘭堡", }, 
},
["524"] = {
{ "Siege of Niuzao Temple", "Belagerung des Niuzaotempels", "Asedio del Templo de Niuzao", "Asedio del Templo de Niuzao", "Siège du temple de Niuzao", "Assedio al Tempio di Niuzao", "니우짜오 사원 공성전투", "Cerco ao Templo Niuzao", "Осада храма Нюцзао", "围攻砮皂寺", "圍攻怒兆寺", }, 
},
["624"] = {
{ "Old Hillsbrad Foothills", "Vorgebirge des Alten Hügellands", "Antiguas Laderas de Trabalomas", "Antiguas Laderas de Trabalomas", "Contreforts de Hautebrande d’antan", "Passato di Colletorto", "옛 언덕마루 구릉지", "Antigo Contraforte de Eira dos Montes", "Старые предгорья Хилсбрада", "旧希尔斯布莱德丘陵", "希爾斯布萊德丘陵舊址", }, 
},
["724"] = {
{ "Invasion!", "Invasion!", "¡Invasión!", "¡Invasión!", "Alerte aux envahisseurs !", "Invasione!", "침략!", "Invasão!", "Вторжение!", "入侵！", "入侵！", }, 
{ "Assault", "Sturmangriff", "Asalto", "Asalto", "Assaut", "Assalto", "습격", "Ataque", "Нападение", "突袭", "襲擊", }, 
{ "The Holdout", "Durchhaltevermögen", "La resistencia", "La resistencia", "Le baroud", "Resistenza", "항전", "A Resistência", "Продержаться подольше", "坚持到底", "堅持到底", }, 
{ "Cleanup", "Aufräumkommando", "Limpieza", "Limpieza", "Nettoyage", "Ripulitura", "소탕", "Limpeza", "Зачистка", "摧枯拉朽", "收拾殘局", }, 
{ "The Calm", "Ruhe nach dem Sturm", "La calma", "La calma", "Le calme", "La calma", "정적", "A Calma", "Затишье", "风平浪静", "歇息備戰", }, 
{ "A Challenger Appears", "Ein Herausforderer erscheint", "Aparece un contendiente", "Surge un contendiente", "Place à l’adversaire !", "Arriva uno sfidante", "도전자 등장", "Um desafiante aparece", "А вот и соперник", "挑战者出现", "挑戰者出現", }, 
{ "Bronze", "Bronze", "Bronce", "Bronce", "Bronze", "Bronzo", "동메달", "Bronze", "Бронза", "青铜级", "青銅", }, 
{ "Silver", "Silber", "Plata", "Plata", "Argent", "Argento", "은메달", "Prata", "Серебро", "白银级", "白銀", }, 
{ "Gold", "Gold", "Oro", "Oro", "Or", "Oro", "금메달", "Ouro", "Золото", "黄金级", "黃金", }, 
{ "Platinum", "Platin", "Platino", "Platino", "Platine", "Platino", "백금메달", "Platina", "Платина", "白金", "白金", }, 
},
["71"] = {
{ "Welcome to Theramore", "Willkommen in Theramore", "Bienvenidos a Theramore", "Bienvenidos a Theramore", "Bienvenue à Theramore", "Benvenuti a Theramore", "테라모어에 오신 것을 환영합니다", "Bem-vindo a Theramore", "Добро пожаловать в Терамор!", "欢迎来到塞拉摩", "歡迎來到塞拉摩", }, 
{ "Sweep the Harbor", "Kehrstunde im Hafen", "Arrasa el puerto", "Arrasa el puerto", "Balayer le port", "Ripulisci il porto", "항구를 공격하라", "Limpando o Porto", "Освобождение гавани", "大扫除", "掃蕩港口", }, 
{ "Into the Ruins", "In die Ruinen", "En las ruinas", "En las ruinas", "Dans les ruines", "Alle rovine", "폐허 속으로", "Nas Ruínas", "К руинам", "深入废墟", "進入廢墟", }, 
{ "The Lady Proudmoore", "Lady Prachtmeer", "Lady Valiente", "Lady Valiente", "Dame Portvaillant", "Dama Marefiero", "여군주 프라우드무어", "Grã-senhora Proudmore", "Леди Праудмур", "普罗德摩尔女士", "普勞德摩爾女士", }, 
{ "Destroy the Destroyer", "Zerstört den Zerstörer", "Destruir el destructor", "Destruir el destructor", "Détruire le Destructeur", "Demolisci il Demolitore", "공성 전차를 파괴하라", "Destrua o Destruidor", "Разрушение разрушителя", "摧毁攻城车", "破壞毀滅者", }, 
{ "The Last Stand", "Das letzte Gefecht", "La resistencia final", "La resistencia final", "La bataille finale", "L'ultima difesa", "최후의 저항", "A Resistência Final", "Последняя битва", "背水一战", "背水一戰", }, 
},
["653"] = {
{ "Scarlet Monastery", "Das Scharlachrote Kloster", "Monasterio Escarlata", "Monasterio Escarlata", "Monastère Écarlate", "Monastero Scarlatto", "붉은십자군 수도원", "Monastério Escarlate", "Монастырь Алого ордена", "血色修道院", "血色修道院", }, 
},
["256"] = {
{ "He Who Has No Life", "Er, der kein Leben hat.", "El Exánime", "El Exánime", "Celui qui n’avait pas de vie", "Colui Che Non Ha Vita", "생명이 없는 자", "Aquele Que Não Possui Vida", "Тот, У Кого Нет Жизни", "亡者", "無魂之生者", }, 
},
["572"] = {
{ "Halls of Reflection", "Hallen der Reflexion", "Cámaras de Reflexión", "Cámaras de Reflexión", "Salles des Reflets", "Sale dei Riflessi", "투영의 전당", "Salões da Reflexão", "Залы Отражений", "映像大厅", "倒影大廳", }, 
},
["557"] = {
{ "Lost City of the Tol'vir", "Die Verlorene Stadt der Tol'vir", "Ciudad Perdida de los Tol'vir", "Ciudad Perdida de los Tol'vir", "Cité perdue des Tol’vir", "Città Perduta dei Tol'vir", "톨비르의 잃어버린 도시", "Cidade Perdida dos Tol'vir", "Затерянный город Тол'вир", "托维尔失落之城", "托維爾的失落之城", }, 
},
["1298"] = {
{ "The Calling Stone", "Der Rufstein", "La piedra de llamada", "La piedra de llamada", "La pierre d’appel", "Pietra dell'Evocazione", "소환석", "A pedra de evocação", "Камень призыва", "召唤石", "召喚石", }, 
{ "The Minions of Xoroth", "Die Schergen Xoroths", "Los esbirros de Xoroth", "Los esbirros de Xoroth", "Les serviteurs de Xoroth", "I servitori di Xoroth", "소로스의 하수인", "Os lacaios de Zoroth", "Зоротианские приспешники", "克诺索斯的爪牙", "克索諾斯惡魔爪牙", }, 
{ "The Fel Knight", "Der Teufelsritter", "El caballero vil", "El caballero vil", "Le gangrechevalier", "Il Vilcavaliere", "지옥 기사", "O cavaleiro vil", "Рыцарь Скверны", "邪能骑士", "魔化騎士", }, 
},
["257"] = {
{ "Champions of Pandaria", "Champions von Pandaria", "Campeones de Pandaria", "Campeones de Pandaria", "Champions de la Pandarie", "Campioni di Pandaria", "판다리아의 용사", "Campeões de Pandária", "Чемпионы Пандарии", "潘达利亚勇士", "潘達利亞之傑", }, 
{ "Celestial Combat", "Kampf den Erhabenen", "Duelo Celestial", "Duelo Celestial", "Combat vénérable", "Combattimento dei Celestiali", "천신 전투", "Combate Celestial", "Небесные бойцы", "天神之战", "天尊之戰", }, 
},
["553"] = {
{ "Grim Batol", "Grim Batol", "Grim Batol", "Grim Batol", "Grim Batol", "Grim Batol", "그림 바톨", "Grim Batol", "Грим Батол", "格瑞姆巴托", "格瑞姆巴托", }, 
},
["679"] = {
{ "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "아킨둔", "Auchindoun", "Аукиндон", "奥金顿", "奧齊頓", }, 
},
["579"] = {
{ "Utgarde Pinnacle", "Turm Utgarde", "Pináculo de Utgarde", "Pináculo de Utgarde", "Cime d’Utgarde", "Pinnacolo di Utgarde", "우트가드 첨탑", "Pináculo Utgarde", "Вершина Утгард", "乌特加德之巅", "俄特加德之巔", }, 
},
["179"] = {
{ "The Mission...", "Die Mission...", "La misión...", "La misión...", "La mission…", "La missione...", "임무...", "A Missão...", "Миссия…", "任务是……", "任務...", }, 
{ "We Ride!", "Unterwegs!", "1, 2, al escondite saurok", "1, 2, al escondite saurok", "En route !", "In sella!", "출발!", "Agora Cavalgamos!", "Мы едем!", "骑马前进！", "我們策騎奔馳!", }, 
{ "Guards!", "Wachen!", "¡Guardias!", "¡Guardias!", "Des gardes !", "Guardie!", "보초다!", "Guardas!", "Стража!", "守卫！", "守衛!", }, 
{ "Into the Cave", "In die Höhle", "En la cueva", "En la cueva", "Dans la grotte", "Dentro la caverna", "동굴 안으로", "Na Caverna", "В пещеру", "进入洞穴", "進入洞穴", }, 
{ "The Source", "Der Ursprung", "Origen", "Origen", "La source", "L'origine dei Saurok", "사우록의 근원", "A Fonte", "Происхождение", "起源", "源頭", }, 
{ "The Broodmaster", "Der Brutmeister", "El maestro de linaje", "El maestro de linaje", "Le maître des couvées", "Il Maestro della Progenie", "무리두목", "A Prolemestre", "Праматерь", "孵化大师", "育主", }, 
{ "Investigation", "Untersuchung", "Investigación", "Investigación", "Enquête", "Esame delle statue", "조사", "Investigação", "Осмотр", "调查", "調查", }, 
{ "Ambush!", "Hinterhalt!", "¡Emboscada!", "¡Emboscada!", "C’est une embuscade !", "Imboscata!", "기습이다!", "Emboscada!", "Нападение!", "有埋伏！", "突襲!", }, 
},
["1146"] = {
{ "The Final Battle", "Der letzte Kampf", "La batalla final", "La batalla final", "La bataille finale", "Lo scontro finale", "마지막 전투", "A batalha final", "Последняя битва", "最终之战", "最後一戰", }, 
{ "Defeat the Felbat Riders", "Die Reiter der Teufelsfledermäuse bezwingen", "Derrota a los jinetes de murciélago vil", "Derrota a los jinetes de murciélagos vil", "Terrasser les cavaliers des gangroptères", "Sconfiggere i Cavalieri di Vilpipistrelli", "지옥박쥐 기수 처치", "Derrotar os cavalgantes dos morcevis", "Наездники на сквернотопырях", "击败魔蝠骑手", "擊敗魔蝠騎士", }, 
{ "Crash Landing", "Bruchlandung", "Aterrizaje forzoso", "Aterrizaje forzoso", "Atterrissage en catastrophe", "Atterraggio d'emergenza", "불시착", "Aterrissagem forçada", "Жесткая посадка", "迫降", "緊急迫降", }, 
{ "Aiding Thorim", "Thorim helfen", "Ayudar a Thorim", "Una ayuda a Thorim", "Aider Thorim", "Aiutare Thorim", "토림 지원", "Auxílio a Thorim", "Помощь Ториму", "协助托里姆", "協助索林姆", }, 
{ "Save Hodir", "Hodir retten", "Salva a Hodir", "Salva a Hodir", "Il faut sauver Hodir", "Salvare Hodir", "호디르 구출", "Salvar Hodir", "Спасение Ходира", "拯救霍迪尔", "拯救霍迪爾", }, 
{ "Defeat Hodir", "Hodir bezwingen", "Derrota a Hodir", "Derrota a Hodir", "Vaincre Hodir", "Sconfiggere Hodir", "호디르에게 안식을", "Derrotar Hodir", "Остановить Ходира", "击败霍迪尔", "擊敗霍迪爾", }, 
},
["1124"] = {
{ "You CAN Go Home", "Ihr KÖNNT nach Hause gehen", "PUEDES irte a casa", "PUEDES irte a casa", "Retour au bercail possible", "Di nuovo a casa", "돌아온 일리다리", "Você PODE ir para casa", "Домой!", "你们可以回家了", "回家真好", }, 
{ "Nothing Will Bar Our Way", "Nichts wird sich uns in den Weg stellen", "Nada se interpondrá en nuestro camino", "Nada se interpondrá en nuestro camino", "Rien ne nous empêchera de passer !", "Niente ci sbarrerà la strada", "진격의 일리다리", "Nada obstruirá nosso caminho", "Нам преграды нипочем", "我们不可阻挡", "勢如破竹", }, 
{ "Confronting an Old Foe", "Konfrontation mit einem alten Feind", "Ante un viejo enemigo", "Confrontando a un viejo enemigo", "Un vieil adversaire", "Faccia a faccia contro un vecchio nemico", "숙적과의 조우", "Confronto com um antigo inimigo", "Старый враг", "面对老对手", "好久不見", }, 
{ "If He Will Not Listen to Reason...", "Und bist du nicht willig...", "Si no atiende a razones...", "Si no quiere entrar en razón...", "S’il ne veut pas entendre raison…", "Se non ascolterà la ragione...", "말을 듣지 않으면...", "Já que não quer ser razoável...", "Когда красноречие бессильно", "如果他不听劝……", "要是他不講道理…", }, 
{ "A Final Attempt at Diplomacy", "Ein letzter Versuch der Diplomatie", "Un último intento diplomático", "Un último intento de usar la diplomacia", "Une dernière tentative diplomatique", "Un ultimo tentativo di diplomazia", "마지막 제안", "Uma última chance à diplomacia", "Еще немного дипломатии", "外交上的最后努力", "最後一次嘗試溝通", }, 
},
["972"] = {
{ "The Rescue", "Die Rettung", "El rescate", "El rescate", "Le sauvetage", "Il salvataggio", "구출", "O resgate", "Спасение", "救援", "救援行動", }, 
{ "Stop the Summoners", "Haltet die Beschwörer auf", "Detener a los invocadores", "Detén a los invocadores", "Arrêter les invocateurs", "Fermare gli Evocatori", "소환사 저지", "Detenha os evocadores", "Остановите призывателей", "阻止召唤者", "阻止召喚師", }, 
{ "Search for Your Allies", "Sucht nach Euren Verbündeten", "Buscar a tus aliados", "Busca a tus aliados", "Chercher vos alliés", "Alla ricerca di alleati", "아군 수색", "Procure seus aliados", "В поисках союзников", "寻找你的盟友", "搜救盟友", }, 
{ "Defeat the Hound Mistress", "Bezwingt die Herrin der Hunde", "Derrota a la maestra de canes", "Derrota a la maestra de los sabuesos", "Vaincre la maîtresse-chien", "Sconfiggere la Signora dei Segugi", "토르비스 처치", "Derrote a Senhora dos Cães", "Повелительница гончих", "击败猎犬女王", "擊敗獵犬魔女", }, 
{ "Quiet the Herald", "Bringt den Herold zum Schweigen", "Silenciar al heraldo", "Silencia al heraldo", "Le silence du héraut", "Silenziare l'Alfiere", "전령의 침묵", "Cale o Arauto", "Утихомиривание глашатая", "歼灭使徒", "消滅信使", }, 
{ "End the Inquisition", "Beendet die Inquisition", "Acabar con la Inquisición", "El fin de la Inquisición", "Mettre fin à l’inquisition", "Porre fine all'inquisizione", "심문관의 최후", "Encerre a Inquisição", "Покончите с инквизицией", "终结审判", "終結審判官", }, 
{ "Where Is She?", "Wo ist sie?", "¿Dónde está?", "¿Dónde está?", "Où est-elle passée ?", "Dov'è?", "알레리아는 어디에?", "Onde está ela?", "Где же она?", "她在哪儿？", "她在哪裡？", }, 
{ "A Bow of Legend", "Ein legendärer Bogen", "Un arco de leyenda", "Un arco legendario", "Un arc de légende", "Un arco leggendario", "전설의 활", "Um arco de lendas", "Легендарный лук", "传奇之弓", "傳奇神弓", }, 
},
["1254"] = {
{ "Eye of Azshara", "Das Auge Azsharas", "Ojo de Azshara", "Ojo de Azshara", "Œil d’Azshara", "Occhio di Azshara", "아즈샤라의 눈", "Olho de Azshara", "Око Азшары", "艾萨拉之眼", "艾薩拉之眼", }, 
},
["1135"] = {
{ "Falling Skies", "Der Himmel stürzt herab", "El cielo cae sobre nuestras cabezas", "Desprendimiento de los cielos", "Quand le ciel s’effondre", "Cieli infuocati", "무너지는 하늘", "Céu desmoronando", "Падающие небеса", "陨落星辰", "天塌下來了", }, 
{ "Center of Gravity", "Das Zentrum der Schwerkraft", "Centro de gravedad", "Centro de gravedad", "Centre de gravité", "Centro di gravità", "중력의 중심", "Centro de gravidade", "Центр притяжения", "重力中心", "引力中心", }, 
{ "Twisting in the Wind", "Wirbeln im Wind", "Retorciéndose al viento", "El abismo del viento", "Porté par le vent", "Liberi nel vento", "뒤틀린 바람", "Retorcer ao vento", "Завихрение ветра", "在风中凌乱", "風中殘燭", }, 
{ "Archmage Vargoth", "Erzmagier Vargoth", "Archimago Vargoth", "Archimago Vargoth", "Archimage Vargoth", "Arcimago Vargoth", "대마법사 바르고스", "Arquimago Vargoth", "Верховный маг Варгот", "大法师瓦格斯", "大法師瓦戈斯", }, 
{ "Grounded", "Geerdet", "En tierra", "En tierra", "Retour au sol", "Immobilizzato", "지상으로", "Em terra", "Самый быстрый путь вниз", "落地", "落地", }, 
{ "Stealth Philosophy", "Verstohlenheitsphilosophie", "Filosofía sigilosa", "Filosofía del sigilo", "La philosophie de la furtivité", "Filosofia furtiva", "은신의 왕도", "A filosofia da furtividade", "Деликатный подход", "潜行的哲学", "潛行的藝術", }, 
{ "The Soulstone's Power", "Die Macht des Seelensteins", "El poder de la piedra de alma", "El poder de la piedra de alma", "Le pouvoir de la pierre d’âme", "Il potere della Pietra dell'Anima", "영혼석의 힘", "O poder da Pedra da Alma", "Сила камня души", "灵魂石的力量", "靈魂石的力量", }, 
},
["556"] = {
{ "Incur Jin'do's Wrath", "Beschwört Jin'dos Zorn herauf", "Provoca la ira de Jin'do", "Despierta la ira de Jin'do.", "Le courroux de Jin’do", "Ira di Jin'do", "진도의 분노 부르기", "Provoque a Ira de Jin'do", "Навлеките на себя гнев Джин'до", "引发金度的怒火", "引發金度的憤怒", }, 
{ "Jin'do the Godbreaker", "Jin'do der Götterbrecher", "Jin'do el Sojuzgadioses", "Jin'do el Sojuzgadioses", "Jin’do le Briseur de dieux", "Jin'do l'Annientadei", "신파괴자 진도", "Jin'do, o Doma-deus", "Джин'до Низвергатель Богов", "碎神者金度", "破神者金度", }, 
{ "Bosses Defeated", "Bosse besiegt", "Jefes derrotados", "Jefes derrotados.", "Boss vaincus", "Boss sconfitti", "우두머리 처치", "Chefes derrotados", "Боссы повержены", "击败首领", "已擊敗的首領", }, 
{ "The Cache of Madness", "Der Hort des Wahnsinns", "El Extremo de la Locura", "El Extremo de la Locura", "L’antre de la Folie", "Scrigno della Follia", "광란의 은닉처", "Antro da Loucura", "Тайник Безумия", "疯狂之缘", "狂性儲納所", }, 
},
["70"] = {
{ "[PH] Defeat Masters", "[PH] Defeat Masters", "[PH] Defeat Masters", "[PH] Defeat Masters", "Vaincre les maîtres", "[PH] Sconfiggi i Maestri", "[PH] 사부를 처치해야 합니다.", "[PH] Derrote os Mestres", "[PH] Defeat Masters", "[PH]击败大师", "[PH] Defeat Masters", }, 
},
["40"] = {
{ "Rescue the Villagers", "Rettet die Dorfbewohner", "Salva a los habitantes", "Salva a los habitantes", "Sauver les villageois", "Salva gli abitanti", "녹옥 마을 주민 구출", "Resgate os Aldeões", "Спасение жителей деревни", "拯救村民", "拯救村民", }, 
{ "Rescue the Dojo", "Rettet den Dojo", "Salva el dojo", "Salva el dojo", "Sauver le dojo", "Salva il Dojo", "도장을 구하라", "Salve o Dojo", "Спасение додзё", "拯救道场", "拯救道場", }, 
{ "Recover Burgled Barrels", "Findet die gestohlenen Fässer", "Recupera los barriles robados", "Recupera los barriles robados", "Récupérer les barils volés", "Recupera i barili rubati", "서리당한 맥주통 회수", "Recupere os Barris Roubados", "Возвращение украденных бочонков", "找回失窃的桶", "取回遭竊的酒桶", }, 
{ "Rescue Greenstone Masons", "Rettet die Steinmetze von Grünstein", "Rescata a los canteros de Verdemar", "Rescata a los canteros de Verdemar", "Sauver les maçons de Pierre-Verte", "Salva i muratori di Pietraverde", "녹옥 석공 구출", "Resgate os Pedreiros da Rocha Verde", "Спасение каменщиков Зеленой Скалы", "拯救绿石工匠区", "拯救綠石石匠區", }, 
{ "Defeat Vengeful Hui", "Bezwingt den rachsüchtigen Hui", "Derrota a Hui el Vengativo", "Derrota a Hui el Vengativo", "Vaincre Hui le Vengeur", "Sconfiggi Hui il Vendicativo", "복수심에 불타는 후이 처치", "Derrotar Hui Vingativo", "Победа над Мстительным Хуэем", "击败仇灰", "殺死復仇之穢", }, 
},
["50"] = {
{ "Mogu'shan Palace", "Mogu'shanpalast", "Palacio Mogu'shan", "Palacio Mogu'shan", "Palais Mogu’shan", "Palazzo Mogu'shan", "모구샨 궁전", "Palácio Mogu'shan", "Дворец Могу'шан", "魔古山宫殿", "魔古山宮", }, 
},
["978"] = {
{ "Darkheart Thicket", "Das Finsterherzdickicht", "Arboleda Corazón Oscuro", "Matorral Corazón Oscuro", "Fourré Sombrecœur", "Boschetto Cuortetro", "어둠심장 숲", "Bosque Corenegro", "Чаща Темного Сердца", "黑心林地", "暗心灌木林", }, 
},
["542"] = {
{ "Blackrock Caverns", "Die Schwarzfelshöhlen", "Cavernas Roca Negra", "Cavernas Roca Negra", "Cavernes de Rochenoire", "Caverne di Roccianera", "검은바위 동굴", "Caverna Rocha Negra", "Пещеры Черной горы", "黑石岩窟", "黑石洞穴", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["567"] = {
{ "Disable Demon Portals", "Deaktiviert die Dämonenportale.", "Desactiva los portales de demonios", "Desactiva los portales demoníacos.", "Désactiver les portails démoniaques", "Disattiva i Portali Demoniaci", "악마의 차원문 닫기", "Desative os Portais Demoníacos", "Отключите порталы демонов", "关闭恶魔之门", "解除惡魔之門", }, 
{ "Slay Peroth'arn", "Tötet Peroth'arn", "Mata a Peroth'arn", "Mata a Peroth'arn.", "Tuer Peroth’arn", "Uccidi Peroth'arn", "페로스안 처치", "Mate Peroth'arn", "Убейте Перот'арна", "击败佩罗萨恩", "殺死佩洛薩恩", }, 
{ "Distract Queen Azshara", "Lenkt Königin Azshara ab", "Distrae a la reina Azshara", "Distrae a la Reina Azshara.", "Distraire la reine Azshara", "Distrai la Regina Azshara", "여왕 아즈샤라 방해", "Distraia a Rainha Azshara", "Отвлеките королеву Азшару", "拖住艾萨拉女王", "分散艾薩拉女王的注意力", }, 
{ "Defeat Mannoroth", "Besiegt Mannoroth", "Derrota a Mannoroth", "Derrota a Mannoroth.", "Terrassez Mannoroth", "Sconfiggi Mannoroth", "만노로스 처치", "Derrote Mannoroth", "Победите Маннорота", "击败玛诺洛斯", "擊敗瑪諾洛斯", }, 
},
["1274"] = {
{ "A Call from the Depths", "Ein Ruf aus der Tiefe", "Una llamada desde las profundidades", "El llamado de las profundidades", "L’appel des profondeurs", "Una chiamata dalle profondità", "심연의 부름", "Chamado das profundezas", "Зов из глубин", "深渊的召唤", "深淵的呼喚", }, 
{ "The Lost Observatory", "Das vergessene Observatorium", "El observatorio perdido", "El observatorio perdido", "L’observatoire oublié", "L'osservatorio perduto", "잊혀진 관측소", "O observatório perdido", "Затерянная обсерватория", "失落的观察室", "失落的觀測所", }, 
{ "Custodial Matters", "Verwaltungssache", "Cuestiones de custodia", "Temas de custodia", "Affaires de garde", "Problemi di custodia", "깨어나는 관리인", "Questão de zelo", "Работа смотрителя", "管理问题", "管理人很重要", }, 
{ "The Seekers", "Die Sucher", "Los buscadores", "Los buscadores", "Les veilleurs", "Gli Osservatori", "길잡이", "Os perscrutadores", "Дозорные", "寻觅者", "追尋者", }, 
{ "Constructs Awaken", "Erwachende Konstrukte", "El despertar de los ensamblajes", "El despertar de los ensamblajes", "L’éveil des assemblages", "Il risveglio dei costrutti", "깨어난 파수꾼", "O despertar dos constructos", "Защитные механизмы", "苏醒的构造体", "甦醒的造物", }, 
},
["1339"] = {
{ "Deceiver's Fall", "Niedergang des Betrügers", "Caída del Impostor", "La caída del Falsario", "La chute du Trompeur", "Caduta dell'Ingannatore", "기만자의 몰락", "Queda do Enganador", "Падение Искусителя", "欺诈者之陨", "欺詐者末路", }, 
},
["1337"] = {
{ "Wailing Halls", "Die Klagenden Hallen", "Cámaras de los Lamentos", "Salones de los lamentos", "Salles des Lamentations", "Sale dei Lamenti", "통곡의 전당", "Salões Ululantes", "Залы Стенаний", "哀嚎大厅", "哀嚎大廳", }, 
},
["205"] = {
{ "Blending In", "Ganz unauffällig", "Panorama para matar", "Panorama para matar", "Se fondre dans le paysage", "Passare inosservati", "은밀한 정찰", "Infiltrando-se", "Разведка с воздуха", "乔装潜入", "混入其中", }, 
{ "Path of Smoke", "Rauchpfad", "Camino de humo", "Camino de humo", "La voie de la fumée", "Sentiero fumoso", "연기 자욱", "Caminho da Fumaça", "Путь дыма", "烟雾之径", "煙霧之途", }, 
{ "Shadows in the Storm", "Schatten im Sturm", "Sombras en la tormenta", "Sombras en la tormenta", "Des ombres dans la tempête", "Ombre nella tempesta", "폭풍 속의 그림자", "Sombras na Tempestade", "Тени шторма", "风暴中的阴影", "風暴中的陰影", }, 
{ "Wetwork", "Ein nasses Grab", "Trabajo sucio", "Trabajo sucio", "Se mouiller", "Massacro", "지저분한 일", "Matança", "Мокрое дело", "湿漉漉的任务", "刺殺任務", }, 
{ "Keep Quiet", "Ganz leise", "Guarda silencio", "Guarda silencio", "Rester discret", "Fai silenzio", "은밀한 이동", "Silêncio!", "Ни звука", "保持安静", "保持安靜", }, 
{ "Light Up the Night", "Licht in der Nacht", "Luz en la penumbra", "Luz en la penumbra", "Une lumière dans la nuit", "Illuminare la notte", "밤을 밝혀라", "Acendendo a Noite", "Ночь полна огня", "点亮夜晚", "照亮夜晚", }, 
{ "Breaking Out", "Ausbruch", "Salida", "Salida", "Évasion", "Fuga", "탈출", "Escapando", "Прорыв", "突破", "逃脫", }, 
},
["1323"] = {
{ "Cathedral of Eternal Night", "Die Kathedrale der Ewigen Nacht", "Catedral de la Noche Eterna", "Catedral de la Noche eterna", "Cathédrale de la Nuit éternelle", "Cattedrale della Notte Eterna", "영원한 밤의 대성당", "Catedral da Noite Eterna", "Собор Вечной Ночи", "永夜大教堂", "永夜聖殿", }, 
},
["324"] = {
{ "The Battle Begins", "Die Schlacht beginnt", "Comienza la batalla", "Comienza la batalla", "La bataille commence", "Inizio della battaglia", "전투 시작", "A batalha começa", "Битва начинается", "一触即发", "大戰將至", }, 
{ "Hold the Choke Point", "Haltet den Engpass", "Protege el cuello de botella", "Mantén el cuello de botella", "Tenez le goulet d’étranglement.", "Proteggi la strettoia", "협곡 지키기", "Defender o gargalo", "Удержать теснину", "扼守要道", "守住隘口", }, 
{ "The Iron Clusterpult", "Das Eiserne Katapult", "La matapulta de la Horda de Hierro", "La clusterpulta de hierro", "Le canon à mitraille de Fer", "Sparagrappoli di Ferro", "강철 집속탄 투석기", "O Lança-bombas de Ferro", "Железная мегапушка", "钢铁集簇投掷炮", "鋼鐵集束砲", }, 
{ "A Good Defense", "Eine gute Verteidigung", "Una buena defensa", "Una buena defensa", "Une bonne défense", "Una buona difesa", "훌륭한 방어", "Uma boa defesa", "Хорошая защита", "坚守阵地", "良好的防禦", }, 
{ "Defending Drek'thar", "Verteidigt Drek'thar", "Defender a Drek'Thar", "Proteger a Drek'Thar", "La défense de Drek’thar", "Difendi Drek'thar", "드렉타르 보호", "Defendendo Drek'thar", "Защита Дрек'Тара", "保护德雷克塔尔", "保護德雷克塔爾", }, 
{ "Iron Thunderlords", "Eiserne Donnerfürsten", "Guerreros Señor del Trueno de la Horda de Hierro", "Señores del Trueno de hierro", "Les Sire-Tonnerre de Fer", "Spaccatuono di Ferro", "강철의 천둥군주", "Senhores do Trovão de Ferro", "Железные Громоборцы", "钢铁雷神", "鋼鐵雷霆王", }, 
{ "Malgrim Stormhand", "Malgrim Sturmhand", "Malgrim Mano Tormenta", "Malgrim Manotormenta", "Malgrim Foudremain", "Malgrim Manotonante", "말그림 스톰핸드", "Malgrim Mão Tempestuosa", "Малгрим Грозовой Кулак", "马尔格林·风暴之手", "瑪格林‧風臂", }, 
{ "The Final Defense", "Die letzte Verteidigung", "La última línea de defensa", "La última defensa", "L’ultime défense", "Difesa finale", "최후의 항전", "A defesa final", "Решающий бой", "最后的防线", "最終防禦", }, 
{ "Slay Maggoc", "Tötet Maggoc", "Mata a Maggoc", "Asesina a Maggoc", "Tuer Maggoc", "Uccidi Maggoc", "마그고크 처치", "Mate Maggoc", "Убить Маггока", "击败玛古克", "殺死瑪格歐克", }, 
},
["705"] = {
{ "Never ending step", "Der endlose Schritt", "Paso sin fin", "Paso interminable", "L’étape sans fin", "Fase senza fine", "끝나지 않는 과정", "Passo sem fim", "Бесконечная лестница", "永不止步", "無盡的步驟", }, 
{ "Progressive Bonus 1", "Progressive Bonus 1", "Progressive Bonus 1", "Bonus progresivo 1", "Progressive Bonus 1", "Bonus progressivo 1", "누진 보너스 1", "Bônus Progressivo 1", "Progressive Bonus 1", "进度奖励 1", "進度獎勵1", }, 
{ "Progressive Bonus 2", "Progressive Bonus 2", "Progressive Bonus 2", "Bonus progresivo 2", "Progressive Bonus 2", "Bonus progressivo 2", "누진 보너스 2", "Bônus Progressivo 2", "Progressive Bonus 2", "进度奖励 2", "進度獎勵2", }, 
{ "Progressive Bonus 3", "Progressive Bonus 3", "Progressive Bonus 3", "Bonus progresivo 3", "Progressive Bonus 3", "Bonus progressivo 3", "누진 보너스 3", "Bônus Progressivo 3", "Progressive Bonus 3", "进度奖励 3", "進度獎勵3", }, 
},
["605"] = {
{ "Prisoner of War", "Kriegsgefangene", "Prisionero de Guerra", "Prisionera de guerra", "Prisonnière de guerre", "Prigioniero di guerra", "전쟁 포로", "Prisioneiro de Guerra", "Пленница", "战俘", "戰俘", }, 
{ "Commander Kolurg defeated", "Kommandant Kolurg bezwungen", "Comandante Kolurg derrotado", "Comandante Kolurg derrotado.", "Commandant Kolurg vaincu", "Sconfiggi il Comandante Kolurg", "사령관 콜루르그 처치", "Comandante Kolurg derrotado", "Командир Колург повержен", "击败指挥官库鲁尔格", "已擊敗指揮官寇勒格", }, 
},
["1132"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "A Frosty Friend", "Ein frostiger Freund", "Un amigo gélido", "Un amigo gélido", "Un ami glacial", "Una gelida amicizia", "차가운 친구", "Um amigo frio", "Кто со льдом дружен...", "酷酷的伙伴", "冰冷的朋友", }, 
{ "A Bolt Best Served Cold", "Kalt erwischt", "La escarcha se sirve fría", "Una descarga es mejor cuando se sirve fría", "Ça jette un froid", "Un dardo che va servito freddo", "차디찬 기운", "Uma seta que se atira fria", "Стрела, которую подают холодной", "冰镇的箭才是好箭", "冷箭的滋味", }, 
{ "Icy Death", "Eisiger Tod", "Muerte gélida", "Muerte glacial", "Mort de froid", "Morte glaciale", "치명적인 얼음", "Morte gélida", "Смерть с налетом инея", "寒冰死亡", "冷死人了", }, 
{ "Frozen Fingers", "Gefrorene Finger", "Dedos congelados", "Dedos helados", "Doigts gelés", "Dita gelide", "얼어붙은 손길", "Dedos congelados", "Мертвая хватка холода", "寒冰指", "連手指都藍了", }, 
{ "A Flurry of Frost", "Jetzt hagelt's Frost", "Un aluvión de escarcha", "Un aluvión gélido", "Rafale de givre", "Una raffica gelida", "냉기의 진눈깨비", "Ímpeto gélido", "Морозный шквал", "冰霜风暴", "冰霜漫舞", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Hey, I'm Over Here Now!", "Erst hier, dann dort, dann fort!", "¡Eh, ahora estoy aquí!", "¡Oye, estoy por aquí!", "Ohé, je suis là, maintenant !", "Ehi, sono qui!", "나 잡아봐라!", "Ei, estou aqui, agora!", "Эй, я здесь!", "嘿，我在这儿呢！", "嗨，我在這裡啦！", }, 
{ "Freezing Roots", "Eisige Wurzeln", "Raíces congelantes", "Raíces heladas", "Racines glaçantes", "Radici gelide", "그대로 멈춰라!", "Raízes congelando", "Глубокая заморозка", "冻在原地", "冰根凍柢", }, 
{ "Dropping Ice from the Sky", "Eis vom Himmel werfen", "Cae hielo del cielo", "Lluvia de hielo desde el cielo", "De la glace tombée du ciel", "Ghiaccio dal cielo", "휘몰아치는 눈발", "Fazendo gelo cair do céu", "Ледяной обвал", "从天而降的冰雪", "天降寒冰", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["1046"] = {
{ "Halls of Valor", "Die Hallen der Tapferkeit", "Cámaras del Valor", "Salones del Valor", "Salles des Valeureux", "Sale del Valore", "용맹의 전당", "Salões da Bravura", "Чертоги Доблести", "英灵殿", "英靈殿", }, 
},
["204"] = {
{ "Find Lost Explosives", "Findet den verlorenen Sprengstoff", "Encuentra los explosivos perdidos", "Encuentra los explosivos perdidos", "Trouver les explosifs perdus", "Trova gli esplosivi perduti", "잃어버린 폭탄을 찾아라", "Encontrar os explosivos perdidos", "Найти потерянную взрывчатку", "找到遗失的炸药", "尋找遺失的炸藥", }, 
{ "Deliver Explosives", "Liefert den Sprengstoff", "Entrega los explosivos", "Entrega los explosivos", "Livrer les explosifs", "Consegna gli esplosivi", "폭탄 전달", "Entregar os Explosivos", "Доставить взрывчатку", "运送炸药", "遞送炸藥", }, 
{ "Detonate Explosives", "Detoniert den Sprengstoff", "Detona los explosivos", "Detona los explosivos", "Faire détoner les explosifs", "Fai detonare gli esplosivi", "폭탄 폭파", "Detonar Explosivos", "Взрыв", "引爆炸药", "引爆炸藥", }, 
{ "Kill War-God Al'chukla", "Tötet Kriegsgott Al'chukla", "Mata al dios de la guerra Al'chukla", "Mata al dios de la guerra Al'chukla", "Tuer le dieu-guerrier Al’chukla", "Uccidi il Dio della Guerra Al'chukla", "전쟁신 알축라 처치", "Mate o Deus da Guerra Al'chukla", "Убейте бога войны Ал'чуклу", "击败战神阿尔图克拉", "殺死戰神阿裘卡拉", }, 
},
["568"] = {
{ "The Forge of Souls", "Die Seelenschmiede", "La Forja de Almas", "La Forja de Almas", "La Forge des Âmes", "Forgia delle Anime", "영혼의 제련소", "Forja das Almas", "Кузня Душ", "灵魂洪炉", "眾魂熔爐", }, 
},
["942"] = {
{ "Neltharion's Lair", "Neltharions Hort", "La Guarida de Neltharion", "Guarida de Neltharion", "Repaire de Neltharion", "Antro di Neltharion", "넬타리온의 둥지", "Covil de Neltharion", "Логово Нелтариона", "奈萨里奥的巢穴", "奈薩里奧巢穴", }, 
},
["1096"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Embrace the Feline Side", "Die feline Seite ausleben", "Abraza el lado felino", "Acepta tu lado felino", "Miaou !", "Abbracciare il lato felino", "날렵한 움직임", "Entregar-se ao lado felino", "Кошачья грация", "拥抱猎豹", "貓力與你同在", }, 
{ "Skulking Around", "Sich davonstehlen", "Merodeando", "Merodeando por aquí", "Toujours à l’affût", "Questione di delicatezza", "꼭꼭 숨어라, 머리카락 보인다", "Na manha do gato", "Надежное укрытие", "潜伏于此", "悄悄行動", }, 
{ "Break out the Claws", "Die Krallen ausfahren", "Saca las garras", "Libérate de las zarpas", "Sortir les griffes", "Tirare fuori le zanne", "발톱 세우기", "Mostrar as garras", "Выпустить когти", "伸出利爪", "好像弄斷爪子了", }, 
{ "Shred them to Pieces", "Verarbeitet sie zu Hackfleisch", "Hazlos pedacitos", "Que no quede nada de ellos", "Déchiquetage en règle", "Farli a pezzi", "갈가리 찢기", "Despedaçá-los", "Смертоносные когти", "把他们撕成碎片", "把它們撕碎", }, 
{ "Bite 'em", "Ein kräftiger Biss", "A mordisco limpio", "Muérdelos", "Coup de dents", "Mordili!", "물어뜯기", "Morder", "Взять их!", "咬他们", "咬給他死", }, 
{ "Rip It Up", "In Stücke reißen", "En canal", "Arráncales las tripas", "Tout déchirer", "Squarciali tutti", "사정없이 찢기", "Botar pra rasgar", "Потрошитель", "裂成两半", "撕給他爛", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Dashing Around", "Im Eilschritt marsch", "A toda velocidad", "Arrasándolo todo", "Ne pas confondre vitesse et précipitation", "Slanci aggraziati", "거침없이 달려들기", "Arremeter contra tudo", "Прыжок кошки", "横冲直撞", "衝來衝去", }, 
{ "Mending Your Wounds", "Wunden heilen", "Sanar tus heridas", "Curando las heridas", "Panser ses blessures", "Curare le ferite", "상처 치유", "Curar as feridas", "Исцеление ран", "治疗你的伤口", "治療你的傷口", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["1265"] = {
{ "Defending the Halls", "Verteidigung der Hallen", "Defender las cámaras", "Defensa de los salones", "Défense des salles", "Difendere le Sale", "전당 방어", "Defender os salões", "Защита Чертогов", "保卫英灵殿", "保衛英靈殿", }, 
{ "The Fallen Shieldmaiden", "Die gefallene Schildmaid", "La doncella escudera caída", "La doncella escudera caída", "La vierge déchue", "La Signora dello Scudo Caduta", "몰락한 방패여전사", "A dama escudeira caída", "Падшая дева щита", "堕落的女武神", "墮落的女盾侍", }, 
},
["704"] = {
{ "Invasion", "Invasion", "Invasión", "Invasión", "L'invasion", "Invasione", "침략", "Invasão", "Вторжение", "入侵", "入侵", }, 
{ "The Scouting Party", "Der Spähtrupp", "El grupo de exploración", "El grupo explorador", "Le groupe d’éclaireurs", "Il gruppo di esploratori", "정찰대", "O Grupo de Batedores", "Разведывательный отряд", "斥候小队", "偵察隊", }, 
{ "Hold Out!", "Haltet durch!", "¡Aguanta!", "¡Aguanta!", "Accrochez-vous !", "Non cedere!", "항전!", "Aguentem!", "Стоять до последнего!", "坚持住！", "堅持到底！", }, 
{ "Cleanup", "Aufräumkommando", "Limpieza", "Limpieza", "Nettoyage", "Ripulitura", "소탕", "Limpeza", "Зачистка", "摧枯拉朽", "收拾殘局", }, 
{ "The Calm", "Ruhe nach dem Sturm", "La calma", "La calma", "Le calme", "La calma", "정적", "A Calma", "Затишье", "风平浪静", "歇息備戰", }, 
{ "Commander's Fall", "Fall des Kommandanten", "La caída del comandante", "La caída del comandante", "La chute d’un commandant", "La caduta del comandante", "지휘관의 죽음", "A Ruína do Comandante", "Падение вождя", "指挥官的陨落", "指揮官之殞", }, 
{ "Bronze", "Bronze", "Bronce", "Bronce", "Bronze", "Bronzo", "동메달", "Bronze", "Бронза", "青铜级", "青銅", }, 
{ "Silver", "Silber", "Plata", "Plata", "Argent", "Argento", "은메달", "Prata", "Серебро", "白银级", "白銀", }, 
{ "Gold", "Gold", "Oro", "Oro", "Or", "Oro", "금메달", "Ouro", "Золото", "黄金级", "黃金", }, 
{ "Platinum", "Platin", "Platino", "Platino", "Platine", "Platino", "백금메달", "Platina", "Платина", "白金", "白金", }, 
},
["566"] = {
{ "The Forge of Souls", "Die Seelenschmiede", "La Forja de Almas", "La Forja de Almas", "La Forge des Âmes", "Forgia delle Anime", "영혼의 제련소", "Forja das Almas", "Кузня Душ", "灵魂洪炉", "眾魂熔爐", }, 
},
["666"] = {
{ "Capital Gardens", "Hauptstadtgärten", "Jardines de la Capital", "Jardines de la Capital", "Grands jardins", "Giardini della Capitale", "수도 정원", "Jardins Capitais", "Центральный сад", "中心花园", "中心花園", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["633"] = {
{ "The Slave Pens", "Die Sklavenunterkünfte", "Recinto de los Esclavos", "Recinto de los Esclavos", "Les enclos aux esclaves", "Fosse degli Schiavi", "강제 노역소", "O Pátio dos Escravos", "Узилище", "奴隶围栏", "奴隸監獄", }, 
},
["1266"] = {
{ "Taking Down Tugar", "Tod dem Tugar", "Eliminar a Tugar", "La caída de Tugar", "Élimination de Tugar", "Abbattere Tugar", "투가르 처치", "Acabar com Tugar", "Охота на Тугара", "了结图加", "消滅圖加", }, 
{ "Feltotem's Fall", "Sturz der Teufelstotems", "La caída de los Tótem Vil", "La caída de Viltótem", "La chute des Totems-Fétides", "La caduta dei Totem Vile", "지옥토템의 몰락", "Queda do Totem Vil", "Падение Тотема Скверны", "邪能图腾之陨", "魔化圖騰的落敗", }, 
},
["1309"] = {
{ "Lower Return to Karazhan", "Untere Rückkehr nach Karazhan", "Regreso a Karazhan inferior", "Regreso inferior a Karazhan", "Retour à Karazhan (bas)", "Ritorno a Karazhan Inferiore", "다시 찾은 카라잔 하층", "Retorno a Karazhan inferior", "Возвращение в Каражан (нижняя часть)", "重返卡拉赞（下层）", "重返卡拉贊下層", }, 
},
["333"] = {
{ "Blackfathom Deeps", "Tiefschwarze Grotte", "Cavernas de Brazanegra", "Cavernas de Brazanegra", "Profondeurs de Brassenoire", "Abissi di Fondocupo", "검은심연 나락", "Profundezas Negras", "Непроглядная Пучина", "黑暗深渊", "黑澗深淵", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["1012"] = {
{ "Maritime Diplomacy", "Maritime Diplomatie", "Diplomacia marítima", "Diplomacia marítima", "Diplomatie maritime", "Diplomazia marittima", "해양 외교", "Diplomacia marítima", "Морская дипломатия", "海事外交", "海事交涉", }, 
{ "Blood and Plunder", "Blut und fette Beute", "Sangre y saqueo", "Sangre y saqueo", "Sang et pillage", "Sangue e bottino", "피와 약탈", "Sangue e saque!", "Кровь и золото", "鲜血与掠夺", "鮮血與掠奪", }, 
{ "Eliza's Gambit", "Elizas Schachzug", "El gambito de Eliza", "La estrategia de Eliza", "Le stratagème d’Eliza", "La scommessa di Eliza", "엘리자의 계략", "A jogada de Elisa", "Гамбит Элизы", "伊丽扎的战术", "伊莉莎的賭注", }, 
{ "Into the Depths", "In die Tiefen", "En las profundidades", "En las profundidades", "Dans les profondeurs", "Negli abissi", "깊숙한 곳으로", "Nas profundezas", "В храм", "深入神殿", "深入追擊", }, 
{ "Claiming the Prize", "Die Eroberung des Schatzes", "Obtener el trofeo", "Reclamando el premio", "Obtention du trophée", "Conquistare il premio", "제독의 선물", "A conquista do prêmio", "Долгожданный трофей", "夺取宝藏", "奪取戰利品", }, 
},
["1252"] = {
{ "Court of Stars", "Der Hof der Sterne", "Corte de las Estrellas", "Corte de Estrellas", "La cour des Étoiles", "Corte delle Stelle", "별의 궁정", "Pátio das Estrelas", "Квартал Звезд", "群星庭院", "眾星之廷", }, 
},
["1148"] = {
{ "Demons, Demons, Everywhere...", "Dämonen, Dämonen überall...", "Demonios, demonios por todas partes...", "Demonios, demonios, por todas partes", "Des démons partout…", "Demoni, demoni ovunque...", "온누리에 악마", "Demônios, demônios por todas as partes...", "Демоны, всюду демоны...", "恶魔，到处都是恶魔...", "到處都是惡魔…", }, 
{ "Small But Mighty", "Klein, aber oho", "Pequeño, pero matón", "Pequeño pero poderoso", "Petit, mais costaud", "Piccolo ma forte", "작은 고추가 매운 법", "Pequeno, mas potente.", "Мал, да удал", "身型虽小，力大无穷", "人小志氣高", }, 
{ "A Feat of Strength", "Heldentat", "Una proeza de fuerza", "Una proeza de fuerza", "Un tour de force", "Una prova di forza", "엄청난 힘", "Proeza para os fortes", "Триумф грубой силы", "力量的壮举", "偉業", }, 
{ "Hodir, Hodir, Hodir!", "Hodir, Hodir, Hodir!", "¡Hodir, Hodir, Hodir!", "¡Hodir, Hodir, Hodir!", "Hodir, Hodir, Hodir !", "Hodir, Hodir, Hodir!", "호디르, 호디르, 호디르!", "Hodir, Hodir, Hodir!", "Ходир, я иду к тебе!", "霍迪尔，霍迪尔，霍迪尔！", "霍迪爾、霍迪爾、霍迪爾！", }, 
{ "The Clash Of Thunder", "Der Donnerschlag", "El Fragor del Trueno", "El Fragor del Trueno", "Le Fracas du tonnerre", "La Sala del Tuono", "천둥의 울림", "Estrondo do Trovão", "Раскаты Грома", "雷霆角斗场", "雷鳴之廳", }, 
{ "A Feat of Battle", "Heldentat des Kampfes", "Una proeza de combate", "Una proeza en batalla", "Un exploit martial", "Un'impresa di guerra", "실력을 보여라", "Proeza para os senhores da guerra", "На войне как на войне", "战斗的壮举", "戰況激昂", }, 
{ "Rescue Thorim", "Rettet Thorim", "Rescata a Thorim", "Rescata a Thorim", "Le sauvetage de Thorim", "Salvare Thorim", "토림 구출", "Resgate de Thorim", "Спасение Торима", "营救托里姆", "解救索林姆", }, 
{ "Talk to Thorim", "Sprecht mit Thorim", "Habla con Thorim", "Habla con Thorim", "Entretien avec Thorim", "Parlare con Thorim", "토림과 대화", "Falar com Thorim", "Поговорить с Торимом", "和托里姆谈谈", "跟索林姆交談", }, 
},
["552"] = {
{ "The Vortex Pinnacle", "Der Vortexgipfel", "La Cumbre del Vórtice", "La Cumbre del Vórtice", "La cime du Vortex", "Pinnacolo del Vortice", "소용돌이 누각", "Pináculo do Vórtice", "Вершина Смерча", "旋云之巅", "漩渦尖塔", }, 
},
["1090"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "A Little Bit of Pain", "Ein wenig Schmerz", "Un poquito de dolor", "Una pequeña pizca de dolor", "Une légère douleur", "Un po' di dolore", "고통의 결실", "Uma pitada de dor", "Болезненные методы", "有一点点痛", "會有一點點痛", }, 
{ "Holy Bolts", "Heilige Blitze", "Descargas Sagradas", "Descargas Sagradas", "Éclairs sacrés", "Atto di contrizione", "거룩한 신념", "Setas Sagradas", "Разящий Свет", "神圣飞弹", "神聖之光", }, 
{ "In Smite of Overwhelming Obstacles", "Schmerz lass nach", "Punición infinita", "Sorteando obstáculos inmensos", "Crime et Châtiment", "Punire i cattivi", "압도적인 성스러움", "Apesar dos enormes obstáculos", "Карающая длань", "重压下的惩击", "無所不用懲擊", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Playing Mind Games", "Gedankenspiele", "Jugar a juegos mentales", "Jugando a juegos mentales", "Maux d’esprit", "Giochi mentali", "공포 조장", "Jogos Mentais", "Вопль, вселяющий ужас", "玩弄人心", "心理遊戲", }, 
{ "A Shield From Your Enemies", "Abgeschirmt von Euren Feinden", "Un escudo contra tus enemigos", "Un escudo contra tus enemigos", "Un bouclier à toute épreuve", "Difendersi dai propri nemici", "거룩한 보호", "Proteção vinda dos inimigos", "Щит против врага", "御敌的护盾", "光盾護身", }, 
{ "A Small Plea", "Eine kleine Bitte", "Una pequeña súplica", "Una pequeña súplica", "Une petite supplique", "Una piccola supplica", "작은 간청", "Uma pequena súplica", "Мольбу услышат небеса", "小小的恳求", "小小的祈求", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["1050"] = {
{ "Court of Stars", "Der Hof der Sterne", "Corte de las Estrellas", "Corte de Estrellas", "Cour des Étoiles", "Corte delle Stelle", "별의 궁정", "Pátio das Estrelas", "Квартал Звезд", "群星庭院", "眾星之廷", }, 
},
["1220"] = {
{ "A Helping Hand", "Eine helfende Hand", "Echar una mano", "Una mano de ayuda", "La main tendue", "Aiuto prezioso", "도움의 손길", "Mão amiga", "Рука помощи", "援护之手", "伸出援手", }, 
{ "Operation Preparation", "Einsatzvorbereitung", "Preparación de la operación", "Preparación de la operación", "Préparatifs de l’opération", "Preparazione all'operazione", "작전 준비", "Preparativos para a operação", "Подготовка к операции", "行动准备", "行動前的準備", }, 
{ "Imminent Launch", "Bevorstehender Start", "Lanzamiento inminente", "Lanzamiento inminente", "Mise à feu imminente", "Lancio imminente", "발사 직전", "Lançamento iminente", "Подготовка к запуску", "即将发射", "情勢緊張", }, 
{ "Thermaplugg's End", "Thermadrahts Ende", "El fin de Termochufe", "El fin de Termochufe", "La fin de Thermojoncteur", "La fine di Termospin", "텔마플러그의 최후", "Desconectando o Termaplugue", "Смерть Термоштепселю", "瑟玛普拉格的末日", "瑟瑪普拉格的末日", }, 
},
["1282"] = {
{ "Freedom", "Freiheit", "Libertad", "Libertad", "Liberté", "Libertà", "자유", "Liberdade", "Свобода", "自由", "自由", }, 
{ "Siege Breaker", "Belagerungsbrecher", "Sicario del Asedio", "Rompeasedios", "Briseur de siège", "Demolitore d'Assedio", "공성 파괴단", "Rompe-cerco", "Прорыв осады", "突围者", "攻城毀滅者", }, 
{ "Insertion", "Eindringen", "Inserción", "Inserción", "Infiltration", "Infiltrazione", "투입", "Inserção", "Проникновение", "潜伏", "敵後行動", }, 
{ "Taken Down From Within", "Von innen heraus vernichtet", "Derribado desde dentro", "Destrucción desde adentro", "Sapée de l’intérieur", "Abbatterli dall'interno", "내부로부터의 공격", "Destruir de dentro", "Удар изнутри", "祸起萧墙", "從內部破壞", }, 
{ "Commander Takedown", "Dem Kommandanten an den Kragen", "La caída del comandante", "La caída del comandante", "Capitulation du commandant", "Sconfiggere il comandante", "사령관 제거", "Comandante derrubado", "Ликвидация командира", "消灭指挥官", "擊殺指揮官", }, 
{ "Get Out of There", "Nichts wie raus", "Fuera de ahí", "Sal de ahí", "Échappée belle", "Fuga per la vittoria", "벗어나기", "Saia daí", "Быстрей отсюда!", "离开那儿", "撤離行動", }, 
},
["1181"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Doing the Moonwalk", "Mondsüchtig", "Formas lunares", "A paso lunar", "Marcher sur la lune", "Luna piena", "달과 야수", "Moonwalk", "Прогулка под луной", "月球漫步", "梟獸學步", }, 
{ "Balancing The Moon and Sun", "Gleichgewicht von Sonne und Mond", "Equilibrio entre sol y luna", "Equilibrio entre la Luna y el Sol", "L’équilibre du soleil et de la lune", "Equilibrio tra Sole e Luna", "해와 달의 조화", "Balancear a Lua e o Sol", "Сила светил", "日月平衡", "日月平衡", }, 
{ "The Power of the Sun", "Die Macht der Sonne", "El poder del sol", "El poder del Sol", "Le pouvoir du soleil", "Il potere del Sole", "태양의 힘", "O poder do Sol", "Испепеляющее солнце", "太阳能", "日炎之力", }, 
{ "A Surge Forward", "Im Sog der Sterne", "Una oleada estelar", "Un avance repentino", "Des astres bouillonnants", "Seguire la Cometa", "샘솟는 별빛", "Surtando", "Звездный час", "滚滚向前", "星如湧泉", }, 
{ "Striking a Balance", "Auf einen Schlag zum Gleichgewicht", "A golpe de equilibrio", "Llegando a un acuerdo", "Atteindre l’équilibre", "Trovare un compromesso", "조화 이루기", "Em busca do equilíbrio", "Установление равновесия", "平衡之道", "平衡之道", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Mending Your Wounds", "Wunden heilen", "Sanar tus heridas", "Curando las heridas", "Panser ses blessures", "Curare le ferite", "상처 보살피기", "Curar as feridas", "Исцеление ран", "治疗你的伤口", "治療你的傷口", }, 
{ "Grasping At Feet", "Fußfesseln", "Trampas enredadoras", "Agarre con los pies", "Par les pieds", "Un abbraccio stringente", "발목 잡기", "Agarrando-se aos pés", "Цепкие корни", "裹足不前", "糾纏不清", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["664"] = {
{ "Maraudon", "Maraudon", "Maraudon", "Maraudon", "Maraudon", "Maraudon", "마라우돈", "Maraudon", "Мародон", "玛拉顿", "瑪拉頓", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["1275"] = {
{ "Choose Your Allies", "Wählt Eure Verbündeten", "Elegir a tus aliados", "Elige a tus aliados", "Choisir ses alliés", "Scegliere gli alleati", "동료 선택", "Escolha seus aliados", "Выбор союзников", "选择盟友", "選擇同伴", }, 
{ "Search the City", "Durchsuchung der Stadt", "Registrar la ciudad", "Registra la ciudad", "Fouiller la ville", "Ricerca in città", "도시 수색", "Vasculhar a cidade", "Прочесывание города", "全城大搜", "搜索城市", }, 
{ "Return to Grayson", "Rückkehr zu Grayson", "Volver con Grayson", "Regresa con Grisillo", "Retourner voir Grayson", "Grayson", "다시 그레이슨에게로", "Falar novamente com Grayson", "Возвращение к Грейсону", "向格雷森复命", "回去找格雷森", }, 
{ "Imbue the Barding", "Erfüllt das Geschirr mit heiliger Kraft", "Imbuir la barda", "Infunde la gualdrapa", "Imprégnation du caparaçon", "Infondere la bardatura", "마갑에 신성한 힘 주입", "Imbuir a barda", "Усиление барда", "为骑甲灌魔", "為坐騎護具灌注神聖能量", }, 
{ "Ride to Rivendare's Crypt", "Ritt zu Totenschwurs Gruft", "Viaje a la cripta de Osahendido", "Cabalga hacia la cripta de Osahendido", "Voyage vers la crypte de Vaillefendre", "La cripta di Fieramorte", "리븐데어의 지하 묘지", "Viagem à cripta de Rivendare", "Склеп Ривендера", "前往瑞文戴尔的墓穴", "前往瑞文戴爾的墓穴", }, 
{ "Defeat Raemien", "Besiegt Raemien", "Derrotar a Raemien", "Derrota a Raemien", "Terrasser Raëmien", "Sconfiggere Raemien", "래미엔 처치", "Derrotar Raemien", "Победа над Рэмиеном", "击败雷曼", "擊敗瑞密安", }, 
{ "Speak With Grayson", "Sprecht mit Grayson", "Habla con Grayson.", "Habla con Grisillo", "Parler à Grayson", "Parla con Grayson", "그레이슨과 대화", "Falar com Grayson", "Возвращение в часовню", "与格雷森交谈", "跟格雷森交談", }, 
},
["733"] = {
{ "Invasion!", "Invasion!", "¡Invasión!", "¡Invasión!", "Alerte aux envahisseurs !", "Invasione!", "침략!", "Invasão!", "Нападение!", "入侵！", "入侵！", }, 
{ "Assault", "Sturmangriff", "Asalto", "Asalto", "Assaut", "Assalto", "습격", "Ataque", "Нападение", "突袭", "襲擊", }, 
{ "The Holdout", "Durchhaltevermögen", "La resistencia", "La resistencia", "Le baroud", "Resistenza", "항전", "A Resistência", "Продержаться подольше", "坚持到底", "堅持到底", }, 
{ "Cleanup", "Aufräumkommando", "Limpieza", "Limpieza", "Nettoyage", "Ripulitura", "소탕", "Limpeza", "Зачистка", "摧枯拉朽", "收拾殘局", }, 
{ "The Calm", "Ruhe nach dem Sturm", "La calma", "La calma", "Le calme", "La calma", "정적", "A Calma", "Затишье", "风平浪静", "歇息備戰", }, 
{ "Fire from the Skies", "Feuer vom Himmel", "Fuego por doquier", "Fuego de los cielos", "Le feu du ciel", "Fuoco dai cieli", "불벼락", "Fogo dos Céus", "Огонь с небес", "天降火雨", "天降大火", }, 
{ "Bronze", "Bronze", "Bronce", "Bronce", "Bronze", "Bronzo", "동메달", "Bronze", "Бронза", "青铜级", "青銅", }, 
{ "Silver", "Silber", "Plata", "Plata", "Argent", "Argento", "은메달", "Prata", "Серебро", "白银级", "白銀", }, 
{ "Gold", "Gold", "Oro", "Oro", "Or", "Oro", "금메달", "Ouro", "Золото", "黄金级", "黃金", }, 
{ "Platinum", "Platin", "Platino", "Platino", "Platine", "Platino", "백금메달", "Platina", "Платина", "白金", "白金", }, 
},
["254"] = {
{ "Test Stage 0", "Testphase 0", "Prueba de fase 0", "Prueba de fase 0", "Test Stage 0", "Prova fase 0", "시험 단계 0", "Estágio de teste 0", "Тестовый этап 0", "Test Stage 0", "測試階段0", }, 
{ "Step 1", "Schritt 1", "Paso 1", "Step 1", "Étape 1", "Fase 1", "1단계", "Passo 1", "1 этап", "第1阶段", "步驟1", }, 
{ "Step 2", "Schritt 2", "Paso 2", "Step 2", "Étape 2", "Fase 2", "2단계", "Passo 2", "2 этап", "第2阶段", "步驟2", }, 
{ "Step 3", "Schritt 3", "Paso 3", "Step 3", "Étape 3", "Fase 3", "3단계", "Passo 3", "3 этап", "第3阶段", "步驟3", }, 
{ "Step 4", "Schritt 4", "Paso 4", "Step 4", "Étape 4", "Fase 4", "4단계", "Passo 4", "4 этап", "第4阶段", "步驟4", }, 
{ "Step 5", "Schritt 5", "Paso 5", "Step 5", "Étape 5", "Fase 5", "5단계", "Passo 5", "5 этап", "第5阶段", "步驟5", }, 
},
["662"] = {
{ "Foulspore Caverns", "Faulsporenhöhlen", "Grutas de la Espora Fétida", "Grutas de la Espora Fétida", "Caverne Vilespore", "Caverna Spora Funesta", "썩은포자 동굴", "Caverna Esporelama", "Зловонная пещера", "毒菇洞穴", "毒菇洞穴", }, 
},
["668"] = {
{ "Dire Maul", "Düsterbruch", "La Masacre", "La Masacre", "Hache-Tripes", "Maglio Infausto", "혈투의 전장", "Martelo do Gládio Cruel", "Забытый Город", "厄运之槌", "厄運之槌", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["1169"] = {
{ "Eye of Azshara", "Das Auge Azsharas", "Ojo de Azshara", "Ojo de Azshara", "Œil d’Azshara", "Occhio di Azshara", "아즈샤라의 눈", "Olho de Azshara", "Око Азшары", "艾萨拉之眼", "艾薩拉之眼", }, 
},
["555"] = {
{ "Lost City of the Tol'vir", "Die Verlorene Stadt der Tol'vir", "Ciudad Perdida de los Tol'vir", "Ciudad Perdida de los Tol'vir", "Cité perdue des Tol’vir", "Città Perduta dei Tol'vir", "톨비르의 잃어버린 도시", "Cidade Perdida dos Tol'vir", "Затерянный город Тол'вир", "托维尔失落之城", "托維爾的失落之城", }, 
},
["785"] = {
{ "Felfire in the Sky #1", "", "", "Fuego vil en el cielo #1", "", "Vilfuoco nel cielo #1", "하늘 속 지옥불 #1", "Fogovil no céu #1", "", "天降邪火#1", "空降魔火#1", }, 
{ "You Face Jaraxxus", "Ihr tretet Jaraxxus entgegen", "Te enfrentas a Jaraxxus", "Enfrentas a Jaraxxus", "Devant vous se tient Jaraxxus", "Affrontate Jaraxxus!", "자락서스 대면", "Você encara Jaraxxus", "Перед вами Джараксус", "挑战加拉克苏斯", "面對賈拉克瑟斯", }, 
},
["1026"] = {
{ "The Downward Spiral", "Die Abwärtsspirale", "La espiral descendente", "La espiral descendente", "Spirale descendante", "La spirale discendente", "비틀린 심연으로", "A espiral descendente", "Вниз по винтовой лестнице", "逆塔", "往下的迴旋樓梯", }, 
{ "Grasp of the Damned", "Umklammerung der Verdammten", "En manos de los malditos", "El alcance de los malditos", "L’emprise des damnés", "Presa dei dannati", "저주받은 자의 손아귀", "Garras dos condenados", "Хватка проклятых", "亡者的爪缚", "詛咒之握", }, 
{ "Removal Protocols", "Entfernungsprotokolle", "Protocolos de eliminación", "Protocolos de eliminación", "Protocoles d’élimination", "Protocolli di rimozione", "제거 프로토콜", "Protocolos de remoção", "Протоколы ликвидации", "清除协议", "移除程序", }, 
{ "The World-Ender", "Der Weltenender", "El exterminador de mundos", "El fin del mundo", "Le destructeur de monde", "Il Devastatore di Mondi", "세상의 파괴자", "A Destruidora de Mundos", "Губитель миров", "灭世者", "世界終結者", }, 
{ "The Rider's Prize", "Der Preis des Reiters", "El trofeo del jinete", "El premio del jinete", "Le trophée du cavalier", "Il premio dei Cavalieri", "기수의 유물", "O prêmio do cavalgante", "Трофей всадника", "黑暗骑士的财宝", "黑騎兵的寶物", }, 
{ "The Fate of the Son", "Das Schicksal des Sohnes", "El destino del hijo", "El destino del hijo", "Le destin du fils", "Il destino del figlio", "아들의 운명", "O destino do filho", "Судьба сына", "父子的命运", "人子的命運", }, 
{ "Apocalypse", "Apokalypse", "Apocalipsis", "Apocalipsis", "Apocalypse", "Apocalisse", "대재앙", "Apocalipse", "Апокалипсис", "天启", "天啟", }, 
},
["1078"] = {
{ "The Unseen Blade", "Die ungesehene Klinge", "La hoja oculta", "La espada oculta", "La lame invisible", "La lama invisibile", "보이지 않는 검", "A lâmina oculta", "Незримый клинок", "无形之刃", "無形之刃", }, 
{ "The Key", "Der Schlüssel", "La llave", "La llave", "La clé", "Chiave Infernale", "열쇠", "A chave", "Ключ", "钥匙", "關鍵鑰匙", }, 
{ "Escape Artist", "Entfesselungskünstler", "Artista del escape", "Artista del escape", "Maître de l’évasion", "Artista della fuga", "탈출의 명수", "Artista da fuga", "Мастер побега", "逃命专家", "逃命專家", }, 
{ "The Eyes of the Deceiver", "Die Augen des Betrügers", "Los ojos del Impostor", "Los Ojos del Falsario", "Les yeux du Trompeur", "Gli occhi dell'ingannatore", "기만자의 눈", "Os olhos do enganador", "Глаза Искусителя", "欺诈者之眼", "欺詐者的雙眼", }, 
{ "Ascension", "Aufstieg", "Ascensión", "Ascensión", "Ascension", "Ascensione", "등반", "Ascensão", "Восхождение", "上升", "晉升", }, 
{ "A Duel of Fate", "Ein Duell des Schicksals", "Un duelo del destino", "Un duelo del destino", "Le duel du sort", "Un duello del destino", "운명의 대결", "Um duelo do destino", "Судьбоносный поединок", "宿命的决斗", "命運的決鬥", }, 
{ "Master of Shadows", "Meister der Schatten", "Maestro de las Sombras", "Maestro de las Sombras", "Maître des Ombres", "Maestro delle ombre", "어둠의 대가", "Mestre das sombras", "Мастер теней", "暗影大师", "暗影大師", }, 
},
["652"] = {
{ "Scarlet Monastery", "Das Scharlachrote Kloster", "Monasterio Escarlata", "Monasterio Escarlata", "Monastère Écarlate", "Monastero Scarlatto", "붉은십자군 수도원", "Monastério Escarlate", "Монастырь Алого ордена", "血色修道院", "血色修道院", }, 
},
["430"] = {
{ "The Everbloom", "Der Immergrüne Flor", "El Vergel Eterno", "El Sempibrote", "La Flore éternelle", "Verdeterno", "상록숲", "Floretérnia", "Вечное Цветение", "永茂林地", "永茂林", }, 
},
["1175"] = {
{ "Maw of Souls", "Der Seelenschlund", "Fauce de Almas", "Fauces de almas", "Gueule des âmes", "Fauci delle Anime", "영혼의 아귀", "Gorja das Almas", "Утроба душ", "噬魂之喉", "靈魂之喉", }, 
},
["630"] = {
{ "The Underbog", "Der Tiefensumpf", "La Sotiénaga", "La Sotiénaga", "La Basse-tourbière", "Torbiera Sotterranea", "지하수렁", "O Brejo Oculto", "Нижетопь", "幽暗沼泽", "深幽泥沼", }, 
},
["1236"] = {
{ "Knock Knock...", "Klopf, klopf...", "Toc toc...", "Toc, toc...", "Toc, toc…", "Toc toc...", "똑똑...", "Toc, toc...", "Тук-тук...", "笃笃笃……", "敲敲門…", }, 
{ "Detoxification", "Entgiftung", "Desintoxicación", "Depuración", "Détoxification", "Disintossicazione", "해독", "Desintoxicação", "Детоксикация", "解毒", "解毒", }, 
{ "Maniacal Laughter...", "Irres Gelächter...", "Risa maníaca...", "Risa maniática...", "Rire dément…", "Muahahahah", "광기의 웃음...", "Risada maníaca...", "Безумный смех", "疯狂的笑声……", "瘋狂的笑聲…", }, 
{ "Chug It!", "Prost!", "¡Traga!", "¡De un trago!", "Cul sec !", "Alla goccia", "마셔!", "Vira!", "Пей до дна!", "干了啦！", "灌下去！", }, 
{ "Demon Overload", "Dämonenüberladung", "Sobrecarga de demonios", "Sobrecarga demoníaca", "Surcharge de démons", "Sovraccarico demoniaco", "악마 과다", "Sobrecarga demoníaca", "Слишком много демонов", "恶魔过载", "太多惡魔", }, 
{ "Brewmasters Attack!", "Die Braumeisterin", "¡Maestros cerveceros al ataque!", "¡El ataque de los maestros cerveceros!", "Maîtres brasseurs, à l’attaque !", "L'attacco dei Mastri Birrai", "양조사 나가신다!", "Ataque dos mestres cervejeiros!", "Хмелевары, вперед!", "酒仙出击！", "釀酒大師進攻！", }, 
},
["1235"] = {
{ "Deviate Dangers", "Mutierte Gefahren", "Evita el peligro", "Peligros descarriados", "Dangers déviants", "Pericoli degeneri", "돌연변이 위험", "Perigos aberrantes", "Невиданная угроза", "变异危机", "危險變異怪", }, 
{ "Son of Skum", "Sohn des Skum", "Hijo de Skum", "Hijo de Skum", "Fils de Skum", "Figlio di Skum", "스컴의 자손", "Filho de Skória", "Потомок Шкама", "斯卡姆之子", "斯卡姆之子", }, 
{ "Legacy of Fangs", "Vermächtnis der Fangzähne", "Legado de colmillos", "Legado de los colmillos", "L’héritage des crocs", "Eredità delle zanne", "송곳니의 유산", "Legado das presas", "Ядовитое наследие", "毒牙的遗产", "尖牙遺毒", }, 
{ "Call of the Serpent", "Ruf der Schlange", "La llamada de la serpiente", "Llamado de la serpiente", "L’appel du serpent", "Richiamo del serpente", "독사의 부름", "Chamado de Serpentis", "Зов змеи", "毒蛇的召唤", "毒蛇之喚", }, 
{ "Ectoplasmic Growth", "Wachsendes Ektoplasma", "Crecimiento ectoplásmico", "Crecimiento ectoplásmico", "Expansion ectoplasmique", "Rigenerazione ectoplasmatica", "성장 세포", "Crescimento ectoplásmico", "Рост эктоплазмы", "细胞繁殖", "持續生長的軟漿怪", }, 
{ "Confront Shadowy Figure", "Schattenhafte Gestalt konfrontieren", "Enfrentarse a la figura enigmática", "Enfrenta a la figura enigmática", "Affronter la silhouette mystérieuse", "La Figura Ombrosa", "정체불명의 인물", "Confrontar o vulto sombrio", "Бой с таинственным некромантом", "战胜阴暗的人影", "面對幽暗人影", }, 
{ "Everliving", "Ewiges Leben", "El Eterno", "El Eterno", "Immortelle", "Sempreverde", "영생", "Sempre-vivo", "Вечноживущий враг", "永生者", "永生", }, 
},
["683"] = {
{ "Grimrail Depot", "Grimmgleisdepot", "Terminal Malavía", "Depósito Riel siniestro", "Dépôt de Tristerail", "Treno Frecciacupa", "파멸철로 정비소", "Central do Carrilcruel", "Депо Мрачных Путей", "恐轨车站", "恐軌車站", }, 
{ "The Grimrail", "Der Grimmzug", "Malavía", "El Riel siniestro", "Le Tristerail", "Treno Frecciacupa", "파멸철로", "O Carrilcruel", "Мрачный Путь", "恐轨号", "恐軌列車", }, 
},
["1219"] = {
{ "step 1", "Schritt 1", "Paso 1", "paso 1", "Étape 1", "Fase 1", "1단계", "Estágio 1", "Шаг 1", "step 1", "第1步", }, 
{ "step 2", "Schritt 2", "Paso 2", "paso 2", "Étape 2", "Fase 2", "2단계", "Estágio 2", "Шаг 2", "step 2", "第2步", }, 
},
["643"] = {
{ "The Deadmines", "Die Todesminen", "Las Minas de la Muerte", "Las Minas de la Muerte", "Les Mortemines", "Miniere della Morte", "죽음의 폐광", "Minas Mortas", "Мертвые копи", "死亡矿井", "死亡礦坑", }, 
},
["1202"] = {
{ "The New Plan", "Neuer Plan", "El nuevo plan", "El nuevo plan", "Plan B", "Un nuovo piano", "새로운 계획", "Um novo plano", "Новый план", "新计划", "新計畫", }, 
{ "Magic Bars the Way", "Magie versperrt den Weg", "La magia bloquea el camino", "La magia bloquea el camino", "Barrière magique", "La magia sbarra la strada", "마법이 길을 막는다", "Magia no meio do caminho", "Магия преграждает путь", "魔法拦路", "魔法擋路", }, 
{ "Breaking the Barrier", "Die Barriere durchbrechen", "Rompiendo la barrera", "Rompiendo la barrera", "La poche dimensionnelle", "Una barriera da spezzare", "방벽 파괴", "Rompendo a barreira", "Убрать барьер", "突破屏障", "打破屏障", }, 
{ "The Fall of Dalion", "Dalion fällt", "La caída de Dalion", "La caída de Dalion", "La chute de Dalion", "La caduta di Dalion", "달리온의 몰락", "A queda de Dalion", "Падение Далиона", "达里昂之陨", "達利昂之死", }, 
{ "Breaking Through", "Durchbruch", "Abrirse paso", "Abriéndose paso", "L'intrusion", "Il medium", "돌파", "Abrindo caminho", "Прорыв", "过关斩将", "突破", }, 
{ "Finally, Andaris", "Endlich, Andaris.", "Andaris, por fin", "Por fin, Andaris.", "Enfin, Andaris", "Alla fine, Andaris", "마침내, 안다리스", "Enfim, Andaris", "И, наконец, Андарис", "轮到你了，安达丽斯", "終於，安妲麗絲", }, 
{ "Death to Andaris", "Andaris muss sterben", "Muerte a Andaris", "Muerte a Andaris", "Mort à Andaris", "Morte ad Andaris", "안다리스에게 죽음을", "Morte a Andaris", "Смерть Андарис!", "安达丽斯之死", "殺死安妲麗絲", }, 
{ "The Nighthold Beckons", "Die Nachtfestung ruft", "El Bastión Nocturno llama", "El llamado de la Fortaleza Nocturna", "L’appel du palais Sacrenuit", "La Rocca della Notte chiama", "밤의 요새가 부른다", "O chamado do Baluarte da Noite", "Цитадель зовет", "暗夜要塞在召唤", "暗夜堡的呼喚", }, 
},
["1310"] = {
{ "Into the Rabbit Hole", "In den Kaninchenbau", "Dentro de la madriguera", "En la madriguera", "Dans le terrier du lapin", "Nella tana del coniglio", "토끼 굴 속으로", "Na toca do coelho", "В кроличью нору", "深入兔子洞", "進入兔子洞", }, 
{ "Lupine Fiasco", "Knurrende Katastrophe", "Fiasco lupino", "Lupine Fiasco", "Gros méchant loup", "Fiasco lupesco", "늑대 소동", "Quem tem medo do lobo mau?", "Волчий голод", "狼的惨败", "惡狼伏誅", }, 
{ "Now For My Next Trick", "Jetzt zu meinem nächsten Trick", "Y como siguiente número...", "Para mi siguiente truco...", "Et maintenant, pour mon prochain tour !", "E ora il prossimo numero", "자, 다음 마술은", "E para o meu próximo truque", "А теперь – следующий фокус...", "下一个戏法", "看我的下一個戲法", }, 
},
["943"] = {
{ "The Council of Masters", "Der Rat der Meister", "El consejo de los maestros", "El Consejo de Maestros", "Le conseil des maîtres", "Il concilio dei maestri", "사부들의 의회", "O Conselho dos mestres", "Совет мастеров", "宗师大会", "大師議會", }, 
{ "The Cry of the Crane", "Der Schrei des Kranichs", "El grito de la grulla", "El grito de la grulla", "La complainte de la grue", "Il pianto della gru", "학의 울음", "O grito da garça", "Крик журавля", "神鹤的悲鸣", "鶴之悲鳴", }, 
{ "Journey to the East", "Reise in den Osten", "Viaje al este", "Viaje al este", "Voyage vers l’est", "Viaggio verso est", "동쪽으로의 여정", "Jornada ao oriente", "На запад!", "一路向东", "東遊記", }, 
{ "Tangle with a Tiger", "Erweckt den Tiger", "Luchar con un tigre", "Enredo con un tigre", "La férocité du tigre", "In coppia con la tigre", "호랑이 콧털을 건드리면...", "Enfrente o tigre", "Не шутите с тигром", "与虎谋皮", "與虎相鬥", }, 
{ "Precious Cargo", "Wertvolle Fracht", "Un cargamento preciado", "Un cargamento preciado", "Une cargaison précieuse", "Prezioso carico", "소중한 동행", "Carga valiosa", "Драгоценный груз", "珍贵的货物", "珍愛之寶", }, 
{ "Mastering the Odds", "Gegen jede Chance", "Vencer a las probabilidades", "Maestro de las probabilidades", "Contre vents et marées", "Dominare il fato", "있어서는 안 될 일", "Aumentar as chances", "Воспользуйтесь шансом", "克服万难", "克服逆境", }, 
{ "Portal Problems", "Portalprobleme", "Problemas en el portal", "Problemas en el portal", "Problèmes de portail", "Problemi di portali", "골치 아픈 차원문", "Portal problema", "Проблемы с порталом", "传送问题", "惱人的傳送門", }, 
},
["1204"] = {
{ "The Confrontation", "Die Konfrontation", "El enfrentamiento", "La confrontación", "L’affrontement", "Il confronto", "대면", "O confronto", "Противостояние", "决战", "決戰", }, 
{ "Gaining Power", "Machtgewinn", "Acumulación de poder", "Más poder", "Pouvoir grandissant", "Acquistare potenza", "커지는 힘", "De olho no poder", "Обретение силы", "获取力量", "獲得力量", }, 
{ "The Shadow Within", "Der innere Schatten", "La sombra interior", "La sombra interna", "L’ombre intérieure", "L'ombra interiore", "내부의 어둠", "Sombras interiores", "Тьма внутри", "心中阴影", "內在的黑暗", }, 
},
["1178"] = {
{ "Court of Stars", "Der Hof der Sterne", "Corte de las Estrellas", "Corte de Estrellas", "Cour des Étoiles", "Corte delle Stelle", "별의 궁정", "Pátio das Estrelas", "Квартал Звезд", "群星庭院", "眾星之廷", }, 
},
["1137"] = {
{ "Crisis in the Temple", "Krise im Tempel", "Crisis en el templo", "Crisis en el templo", "Crise au temple", "Crisi al tempio", "사원의 위기", "Crise no templo", "Обстановка в храме", "寺庙中的危机", "寺廟的危機", }, 
{ "Checking Out", "Auschecken", "Echar un ojo", "Revisión general", "Scribes en détresse", "Biglietto di ritorno", "구출 작전", "De saída", "Прочь с насиженного места", "查房", "我只是來借書", }, 
{ "Hungering for Revenge", "Rachedurst", "Con ganas de venganza", "Sed de venganza", "Soif de vengeance", "Sete di vendetta", "복수는 나의 것", "Sede de vingança", "Жажда возмездия", "渴望复仇", "渴望報仇", }, 
{ "Down But Not Out", "Erloschen, aber nicht erledigt", "Derribado, pero no acabado", "Abatido, pero jamás rendido", "À terre, mais en vie", "Non è ancora finita", "희망을 잃지 마세요", "Caído, mas acordado", "Помощь выжившим", "虽然失败，依旧坚持", "被打趴了但還能站起來", }, 
{ "Death from Above", "Tod von oben", "La muerte cae desde el cielo", "La muerte cae desde el cielo", "La mort venue d’en haut", "Morte dall'Alto", "하늘의 저승사자", "A Morte Vem de Cima", "Смерть с небес", "死从天降", "死從天降", }, 
{ "The Battle of the Serpent", "Der Kampf der Schlange", "La batalla del dragón", "La batalla de la dragona", "La bataille du Serpent", "La battaglia della serpe", "옥룡의 전투", "A batalha da serpente", "Битва Змеи", "神龙之战", "玉龍之戰", }, 
{ "On Fel Wings", "Auf Teufelsschwingen", "Sobre alas viles", "Sobre alas viles", "Sur des ailes gangrenées", "Su ali vili", "지옥 날개를 타고", "Nas asas vis", "На крыльях Скверны", "魔翼翱翔", "魔化之翼", }, 
{ "Fu Zan, the Wanderer's Companion", "Fu Zan, Gefährte des Wanderers", "Fu Zan, el Compañero del Errante", "Fu Zan, el Compañero del Vagabundo", "Fu Zan, compagnon de l’explorateur", "Fu Zan, Compagno del Viandante", "푸 잔 - 방랑자의 친구", "Fu Zan, Companheiro do Andarilho", "Фу Цань, Спутник Странников", "福枬，云游者之友", "福山之杖，漫行者之伴", }, 
{ "The Wanderer Awakens", "Der Wanderer erwacht", "El errante despierta", "El vagabundo despierta", "L’explorateur s’éveille", "Il risveglio del viandante", "깨어난 방랑자", "O despertar do errante", "Дух странствий", "云游者觉醒", "漫行者甦醒", }, 
},
["48"] = {
{ "Gate of the Setting Sun", "Tor der Untergehenden Sonne", "Puerta del Sol Poniente", "Puerta del Sol Poniente", "Porte du Soleil couchant", "Porta del Sole Calante", "석양문", "Portal do Sol Poente", "Врата Заходящего Солнца", "残阳关", "落陽關", }, 
},
["622"] = {
{ "Sethekk Halls", "Sethekkhallen", "Salas Sethekk", "Salas Sethekk", "Les salles des Sethekk", "Sale dei Sethekk", "세데크 전당", "Salões dos Sethekk", "Сетеккские залы", "塞泰克大厅", "塞司克大廳", }, 
},
["1173"] = {
{ "Vault of the Wardens", "Das Verlies der Wächterinnen", "Cámara de las Celadoras", "Bóveda de las Celadoras", "Caveau des Gardiennes", "Segrete delle Custodi", "감시관의 금고", "Câmara das Guardiãs", "Казематы Стражей", "守望者地窟", "看守者鐵獄", }, 
},
["1025"] = {
{ "Kill Murlocs", "Tötet Murlocs", "Mata múrlocs", "Mata múrlocs", "Élimination des murlocs", "Uccidere i Murloc", "멀록 처치", "Matar Murlocs.", "Смерть мурлокам", "消灭鱼人", "殺死魚人", }, 
{ "Fishing", "Angeln", "Pesca", "Pesca", "Pêche", "Pesca", "낚시", "Pesca", "Рыбная ловля", "钓鱼", "釣魚", }, 
{ "Delivery", "Zustellung", "Entrega", "Entrega", "Livraison", "Consegna", "배달", "Entrega", "Доставка", "送达", "送達", }, 
{ "What's below?", "Was ist da unten?", "¿Qué hay ahí abajo?", "¿Qué hay debajo?", "Qu’y a-t-il là-dessous ?", "Misteri del profondo", "범인은 누구?", "O que tem lá embaixo?", "Что прячется в глубинах", "下面是什么？", "下面有什麼？", }, 
{ "Mglrrp", "Mglrrp", "Mglrrp", "Mglrrp", "Mglrrp", "Mglrrp", "아옳옲", "Mglrrp", "Мглррп", "墨勒普", "莫咕哺", }, 
},
["322"] = {
{ "Kill Zem, Kill Zem All", "Tötet sie! Tötet sie alle!", "Mátalos a todos, todos, todos", "Matadlos, matadlos a todos", "Fous devez les tuer tous", "Uccidili! Uccidili tutti!", "모두 없애라", "Mata, mata todo mundo", "Убей их, убей их всех", "杀死他们，不留活口！", "全部殺光", }, 
{ "Step 2", "Schritt 2", "Paso 2", "Step 2", "Étape 2", "Fase 2", "2단계", "Passo 2", "2 этап", "第2阶段", "步驟2", }, 
{ "Step 3", "Schritt 3", "Paso 3", "Step 3", "Étape 3", "Fase 3", "3단계", "Passo 3", "3 этап", "第3阶段", "步驟3", }, 
},
["1122"] = {
{ "Preparations", "Vorbereitungen", "Preparativos", "Preparativos", "Les préparatifs", "Preparativi", "준비", "Os preparativos", "Приготовления", "准备就绪", "做好準備", }, 
{ "Placing the Wards", "Die Zauberschutze platzieren", "Colocación de resguardos", "Colocando los resguardos", "Installation des protections", "Posizionare le protezioni", "수호물 설치", "Posicionar proteções", "Установка оберегов", "设置结界", "放置結界", }, 
{ "The Altar of End Times", "Der Altar der Endzeit", "El Altar del Fin de los Tiempos", "El Altar del fin de los días", "L’autel de la Fin des temps", "L'Altare della Fine dei Tempi", "종말의 제단", "O Altar do Fim dos Tempos", "Алтарь Конца Времен", "末世祭坛", "終焉祭壇", }, 
{ "The Great Ritual", "Das große Ritual", "El gran ritual", "El gran ritual", "Le grand rituel", "Il grande rituale", "웅장한 의식", "O grande ritual", "Великий ритуал", "大型仪式", "偉大儀式", }, 
{ "Showdown in the Realm of Madness", "Kräftemessen im Reich des Wahnsinns", "Enfrentamiento en el reino de la locura", "Enfrentamiento en el reino de la Locura", "Affrontement dans le royaume de la folie", "Scontro finale nel Reame del Cacciatore di Maghi", "광기의 세계에서의 사투", "Confronto final nos domínios da loucura", "Битва в царстве Безумия", "决战疯狂世界", "瘋狂之境的對決", }, 
{ "Ebonchill", "Schwarzfrost", "Ébano Glacial", "Frío del ébano", "Frissébène", "Gelonero", "칠흑한기", "Ébano Gélido", "Полярная Ночь", "黑檀之寒", "黯凜", }, 
},
["613"] = {
{ "The Botanica", "Die Botanika", "El Invernáculo", "El Invernáculo", "La Botanica", "Botanica", "신록의 정원", "Jardim Botânico", "Ботаника", "生态船", "波塔尼卡", }, 
},
["1170"] = {
{ "His Duplicity is Hardly Surprising", "Seine Doppelzüngigkeit ist keine Überraschung", "Su falsedad no sorprende", "Su duplicidad no es muy sorprendente.", "Une duplicité guère surprenante", "La sua doppiezza non mi sorprende", "놀랍지도 않은 이중성", "Sua duplicidade não surpresa", "Его истинное лицо", "他的两面三刀并不会让人感到意外", "意料之中的背叛", }, 
{ "You Are Not Prepared!", "Ihr seid nicht vorbereitet!", "¡No estás preparado!", "¡No están preparados!", "Vous n’êtes pas prêts !", "Voi non siete pronti!", "너흰 아직 준비가 안 됐다!", "Você não está preparado!", "Ты не готов!", "你们这是自寻死路！", "你們還沒準備好！", }, 
{ "To The Skies", "In die Lüfte", "Al cielo", "Hacia los cielos", "En route vers les cieux", "Verso il Cielo!", "공중으로", "Para os céus", "В небо!", "天空召唤", "從天而降", }, 
{ "The Final Countdown", "Der letzte Countdown", "La última cuenta atrás", "La última cuenta regresiva", "Le compte à rebours final", "Conto alla rovescia", "최후의 순간", "Contagem regressiva final", "Обратный отсчет", "最后的倒计时", "最後倒數", }, 
{ "The Demon Within", "Der innere Dämon", "El demonio interior", "El demonio interno", "Le démon intérieur", "Il demone interiore", "악마가 깃든 자", "O demônio interior", "Внутренний демон", "心魔", "內在的惡魔", }, 
{ "The Huntress", "Die Jägerin", "La Cazadora", "La cazadora", "La chasseresse", "La cacciatrice", "여사냥꾼", "A caçadora", "Охотница", "女猎手", "女獵人", }, 
},
["1138"] = {
{ "The Prophet and the Butcher", "Der Prophet und der Schlächter", "El profeta y el carnicero", "El profeta y el carnicero", "Le prophète et le Boucher", "Il profeta e il macellaio", "예언자와 도살자", "O profeta e o açougueiro", "Пророк и Палач", "先知与屠夫", "預言者與屠夫", }, 
{ "In Defense of the Exodar", "Verteidigung der Exodar", "En defensa de El Exodar", "En defensa del Exodar", "La défense de l’Exodar", "In difesa della Exodar", "엑소다르 방어", "Em defesa da Exodar", "Оборона Экзодара", "保卫埃索达", "防衛艾克索達", }, 
{ "Return to the Prophet", "Kehrt zum Propheten zurück.", "Vuelve con el profeta", "Regresa con el profeta", "Retourner voir le prophète", "Ritorno dal profeta", "예언자에게 돌아가기", "Fale novamente com o Profeta", "Возвращение к пророку", "回去找到先知", "回去找預言者", }, 
{ "The Light's Heart", "Das Herz des Lichts", "El Corazón de la Luz", "El corazón de la Luz", "Le Cœur de la Lumière", "Il Cuore della Luce", "빛의 심장", "O Coração da Luz", "Сердце Света", "圣光之心", "聖光之心", }, 
{ "A Long Way Down...", "Ein langer Weg nach unten...", "Un largo descenso...", "Un largo camino de descenso...", "Une longue descente…", "Una lunga caduta...", "먼 길", "Uma bela queda...", "Долгий путь вниз", "下方是条漫长的路……", "往下的漫漫長路…", }, 
{ "Revelations...", "Offenbarungen...", "Revelaciones...", "Revelaciones...", "Révélations…", "Rivelazioni", "폭로...", "Revelações...", "Откровения", "启示录……", "啟示…", }, 
},
["1299"] = {
{ "Securing Thunder Totem", "Donnertotem sichern", "Asegurar Tótem del Trueno", "Asegura Tótem del Trueno", "Sécuriser Totem-du-Tonnerre", "Proteggere Totem del Fulmine", "천둥 토템 확보", "Proteger Totem do Trovão", "Защита Громового Тотема", "保卫雷霆图腾", "保衛雷霆圖騰", }, 
{ "Base Defense", "Basisverteidigung", "Defensa de la base", "Defensa de la base", "Défense de base", "Difesa della base", "기지 방어", "Defesa básica", "Защита базы", "基地防御", "防禦基地", }, 
{ "Incoming!", "Achtung, Angriff!", "¡Enemigos!", "¡Enemigos al ataque!", "En approche !", "In arrivo!", "적의 공격이다!", "Ataque inimigo!", "Враг атакует!", "来了！", "敵人來了！", }, 
{ "Last Defense", "Letzte Verteidigung", "Última defensa", "La última defensa", "Dernière ligne de défense", "Ultima difesa", "최후의 방어", "Última defesa", "Последний рубеж", "最后的防线", "最後防線", }, 
{ "Regroup", "Neu formieren", "Reorganización", "Reagrúpate", "Regroupement des troupes", "Raggrupparsi", "재집결", "Reagrupar", "Перегруппировка", "重整旗鼓", "重整旗鼓", }, 
{ "To the Ship!", "Zum Schiff!", "¡A la nave!", "¡A la nave!", "Au vaisseau !", "Alla nave!", "함선으로!", "Para o navio!", "На корабль!", "登上战舰！", "朝船艦出發！", }, 
{ "Free our people.", "Befreit unser Volk", "Liberar a nuestra gente", "Libera a nuestro pueblo.", "Libération de notre peuple", "Liberare la nostra gente", "동족 구출", "Liberte o nosso povo", "Освобождение тауренов", "拯救人民", "解救我們的族人。", }, 
{ "Destroyed from within.", "Von innen heraus zerstört", "Destruido desde el interior", "Destrucción desde adentro", "Détruit de l’intérieur", "Distrutti dall'interno", "내부로부터의 파괴", "Destruído de dentro", "Уничтожить изнутри", "由内而外", "從內部破壞。", }, 
{ "The final fight", "Die letzte Schlacht", "La batalla final", "La batalla final", "Combat final", "Il combattimento finale", "최후의 전투", "A luta final", "Последний бой", "最后一战", "最終戰鬥", }, 
{ "Time to go.", "Zeit zu gehen", "Es la hora.", "Hora de irse", "L’heure est venue", "Ora di partire", "가야 할 시간", "Hora de ir", "Пора!", "该出发了。", "該離開了。", }, 
},
["1168"] = {
{ "Join the Battle", "Stürzt Euch in die Schlacht", "Únete a la batalla", "Únete a la batalla", "Rejoindre la bataille", "Unisciti alla battaglia", "참전", "Juntar-se à batalha", "В бой!", "加入战斗", "加入戰鬥", }, 
{ "Defeat Balnazzar's Lieutenants", "Balnazzars Hauptmänner bezwingen", "Derrota a los tenientes de Balnazzar", "Derrota a los tenientes de Balnazzar", "Terrasser les lieutenants de Balnazzar", "Sconfiggere i Luogotenenti di Balnazzar", "발나자르의 부관 처치", "Derrotar os tenentes de Balnazzar", "Одолеть приспешников Бальназара", "击败巴纳扎尔的副官", "擊敗巴納札爾的副官", }, 
{ "Destroy Legion portals.", "Legionsportale zerstören", "Destruye portales de la Legión", "Destruye portales de la Legión.", "Destruction de portails de la Légion", "Distruggere i portali della Legione", "군단 차원문 파괴", "Destruir portais da Legião.", "Уничтожение порталов Легиона", "摧毁军团传送门。", "摧毀燃燒軍團傳送門", }, 
{ "Defeat Balnazzar", "Balnazzar bezwingen", "Derrota a Balnazzar", "Derrota a Balnazzar", "Terrasser Balnazzar", "Sconfiggi Balnazzar", "발나자르 처치", "Derrotar Balnazzar", "Победа над Бальназаром", "击败巴纳扎尔", "擊敗巴納札爾", }, 
},
["432"] = {
{ "Upper Blackrock Spire", "Obere Schwarzfelsspitze", "Cumbre de Roca Negra Superior", "Cumbre de Roca Negra superior", "Sommet du pic Rochenoire", "Bastioni di Roccianera Superiori", "검은바위 첨탑 상층", "Pico da Rocha Negra Superior", "Верхняя часть пика Черной горы", "黑石塔上层", "黑石塔上層", }, 
},
["621"] = {
{ "The Arcatraz", "Die Arkatraz", "El Arcatraz", "El Arcatraz", "L’Arcatraz", "Arcatraz", "알카트라즈", "Arcatraz", "Аркатрац", "禁魔监狱", "亞克崔茲", }, 
},
["665"] = {
{ "Warpwood Quarter", "Wucherborkenviertel", "Barrio Alabeo", "Barrio Alabeo", "Quartier de Crochebois", "Quartiere di Legnotorto", "굽이나무 지구", "Distrito Lenhatorta", "Квартал Криводревов", "扭木广场", "扭木廣場", }, 
},
["565"] = {
{ "Halls of Origination", "Hallen des Ursprungs", "Cámaras de los Orígenes", "Cámaras de los Orígenes", "Salles de l’Origine", "Sale della Creazione", "시초의 전당", "Salões Primordiais", "Чертоги Созидания", "起源大厅", "起源大廳", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["1160"] = {
{ "Join the Battle", "Stürzt Euch in die Schlacht", "Únete a la batalla", "Únete a la batalla", "Rejoindre la bataille", "Unisciti alla battaglia", "참전", "Juntar-se à batalha", "В бой!", "加入战斗", "加入戰鬥", }, 
{ "Defeat Balnazzar's Lieutenants", "Balnazzars Hauptmänner bezwingen", "Derrota a los tenientes de Balnazzar", "Derrota a los tenientes de Balnazzar", "Terrasser les lieutenants de Balnazzar", "Sconfiggere i Luogotenenti di Balnazzar", "발나자르의 부관 처치", "Derrotar os tenentes de Balnazzar", "Одолеть приспешников Бальназара", "击败巴纳扎尔的副官", "擊敗巴納札爾的副官", }, 
{ "Destroy Legion portals.", "Legionsportale zerstören", "Destruye portales de la Legión", "Destruye portales de la Legión.", "Destruction de portails de la Légion", "Distruggere i portali della Legione", "군단 차원문 파괴", "Destruir portais da Legião.", "Уничтожение порталов Легиона", "摧毁军团传送门。", "摧毀燃燒軍團傳送門", }, 
{ "Defeat Balnazzar", "Balnazzar bezwingen", "Derrota a Balnazzar", "Derrota a Balnazzar", "Terrasser Balnazzar", "Sconfiggi Balnazzar", "발나자르 처치", "Derrotar Balnazzar", "Победа над Бальназаром", "击败巴纳扎尔", "擊敗巴納札爾", }, 
},
["631"] = {
{ "The Underbog", "Der Tiefensumpf", "La Sotiénaga", "La Sotiénaga", "La Basse-tourbière", "Torbiera Sotterranea", "지하수렁", "O Brejo Oculto", "Нижетопь", "幽暗沼泽", "深幽泥沼", }, 
},
["1159"] = {
{ "Hitting the Books", "Es steht geschrieben", "Hincar los codos", "Golpear los libros", "Rat de bibliothèque", "Concentrarsi sui libri", "기록 소거", "De cara nos livros", "Копание в книгах", "书籍研究", "讀書破卷", }, 
{ "The Nightflow Conduit", "Die Nachtflussleitung", "El Conducto Nocturno", "El conducto del flujo nocturno", "L’artère Ruissenuit", "Il Condotto Oscuro", "밤흐름 도관", "O Conduíte da Noite", "Проводник Ночного Колодца", "夜流水渠", "夜流中樞", }, 
{ "Knock Knock", "Klopf, klopf", "Toc toc", "Toc, toc", "Toc, toc", "Toc toc!", "똑똑", "Toc, toc", "Тук-тук", "咚咚咚", "有人在嗎？", }, 
{ "E.M.P.", "E.M.P.", "PTME", "P.E.M.", "Projection de mana", "Generatore di Tempeste di Mana Effimere", "E.M.P.", "P.E.M.", "ЭПМ", "E.M.P.", "電磁脈衝", }, 
{ "Weather the Storm", "Den Sturm überstehen", "Capea la tormenta", "Sobrevive a la tormenta", "Une tempête à braver", "Affrontare la tempesta", "폭풍을 견뎌라", "Suportar a tempestade", "У природы нет плохой погоды", "度过风暴", "撐過風暴", }, 
},
["1230"] = {
{ "Prepare the Discs", "Die Scheiben vorbereiten", "Preparar los discos", "Prepara los discos", "Préparer les disques", "Preparare i dischi", "원반 준비", "Preparar os discos", "Подготовка дисков", "准备飞碟", "準備稜碟", }, 
{ "Disperse the Elements", "Elementare Bändigung", "Dispersar los elementos", "Dispersa los elementos", "Disperser les éléments", "Disperdere gli elementi", "마력 분산", "Dispersar os elementos", "Рассеивание энергии", "消散元素", "分散力量", }, 
},
["275"] = {
{ "Chosen by K'ara", "Von K'ara auserwählt", "La elección de K'ara", "El elegido de K'ara", "Le choix de K’ara", "Scelto da K'ara", "크아라의 용사", "Escolhido por K'ara", "Избранники К'ары", "卡拉的选民", "卡拉的選擇", }, 
{ "The Gates of Grommar", "Das Tor von Grommar", "Las puertas de Grommar", "Las Puertas de Grommar", "Les portes de Grommar", "Cancelli di Grommar", "그롬마르 관문", "Os Portões de Grommar", "Врата Громмара", "格罗玛尔之门", "葛羅瑪大門", }, 
{ "The Purge of Grommar", "Die Säuberung Grommars", "La Purga de Grommar", "La purga de Grommar", "La purge de Grommar", "Epurazione di Grommar", "그롬마르 정화", "O Expurgo de Grommar", "Очищение Громмара", "血洗格罗玛尔", "葛羅瑪掃蕩行動", }, 
{ "Fire From the Skies", "Feuer aus dem Himmel", "Fuego por doquier", "Fuego de los cielos", "Le feu du ciel", "Fuoco dai cieli", "불벼락", "Fogo dos Céus", "Огонь с небес", "天降火雨", "天降大火", }, 
},
["575"] = {
{ "The Oculus", "Das Oculus", "El Oculus", "El Oculus", "L’Oculus", "Oculus", "마력의 눈", "Óculus", "Окулус", "魔环", "奧核之眼", }, 
},
["1133"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Coating Your Daggers", "Vergiftete Klingen", "Cubrir tus dagas", "Ensuciando dagas", "Enduire ses dagues", "Intingere i pugnali", "독한 단검", "Untar as adagas", "Яд для кинжалов", "给你的匕首涂毒", "匕首淬毒", }, 
{ "Sneaking Around", "Auf leisen Sohlen", "Sin levantar sospechas", "Husmeando por ahí", "En toute discrétion", "Movimenti furtivi", "살금살금", "Sorrateiramente", "Осторожность превыше всего", "来去无踪", "步伐放輕", }, 
{ "Slitting Throats", "An die Kehle", "Rebanar pescuezos", "Cortando gargantas", "Un vrai coupe-gorge", "Tagliagole", "조여드는 손", "Rasgar gargantas", "Берегите горло", "割开喉咙", "割喉戰", }, 
{ "When One Dagger Just Isn't Enough", "Ein Dolch ist nicht genug", "Cuando una daga no basta", "Cuando una daga no es suficiente", "Quand une dague ne suffit pas…", "Quando un pugnale non basta", "단검 하나로는 부족해", "Quando só uma adaga não basta", "В каждую руку – по кинжалу", "一把匕首可不够", "兩把剛剛好", }, 
{ "The Gift That Keeps On Giving", "Tropfen für Tropfen für Tropfen", "La ofrenda que sigue dando", "La ofrenda que sigue dando", "La joie d’offrir", "Il dono infinito", "아낌없는 공격", "O aspirador de almas", "Подарок с подвохом", "惊喜连连", "一次次受傷", }, 
{ "More Poison, Please!", "Mehr Gift, bitte!", "¡Más veneno, por favor!", "¡Más veneno, por favor!", "Du rab’ de poison, s’il vous plaît !", "Altro veleno, grazie!", "독, 추가요!", "Mais veneno, por favor!", "Еще яда!", "请再来点药膏，谢谢！", "再毒一點，拜託！", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Slipping Into The Shadows", "Mit den Schatten verschmelzen", "Deslizarse a las sombras", "Desaparición entre las sombras", "Se fondre dans les ombres", "Sparire nelle ombre", "그림자에 스며들기", "Sumindo nas sombras", "Шаг в тень", "遁入阴影之中", "消失在暗影之中", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["423"] = {
{ "Skyreach", "Himmelsnadel", "Trecho Celestial", "Trecho Celestial", "Orée-du-Ciel", "Vetta dei Cieli", "하늘탑", "Beira-céu", "Небесный Путь", "通天峰", "擎天峰", }, 
},
["674"] = {
{ "The Stonecore", "Der Steinerne Kern", "El Núcleo Pétreo", "El Núcleo Pétreo", "Le Cœur-de-Pierre", "Nucleo di Pietra", "바위심장부", "Litocerne", "Каменные Недра", "巨石之核", "石岩之心", }, 
},
["527"] = {
{ "Gate of the Setting Sun", "Tor der Untergehenden Sonne", "Puerta del Sol Poniente", "Puerta del Sol Poniente", "Porte du Soleil couchant", "Porta del Sole Calante", "석양문", "Portal do Sol Poente", "Врата Заходящего Солнца", "残阳关", "落陽關", }, 
},
["634"] = {
{ "The Blood Furnace", "Der Blutkessel", "El Horno de Sangre", "El Horno de Sangre", "La Fournaise du sang", "Forgia del Sangue", "피의 용광로", "A Fornalha de Sangue", "Кузня Крови", "鲜血熔炉", "血熔爐", }, 
},
["1131"] = {
{ "You CAN Go Home", "Ihr KÖNNT nach Hause gehen", "PUEDES irte a casa", "PUEDES irte a casa", "Retour au bercail possible", "Di nuovo a casa", "돌아온 일리다리", "Você PODE ir para casa", "Домой!", "你们可以回家了", "回家真好", }, 
{ "Nothing Will Bar Our Way", "Nichts wird sich uns in den Weg stellen", "Nada se interpondrá en nuestro camino", "Nada se interpondrá en nuestro camino", "Rien ne nous empêchera de passer !", "Niente ci sbarrerà la strada", "진격의 일리다리", "Nada obstruirá nosso caminho", "Нам преграды нипочем", "我们不可阻挡", "勢如破竹", }, 
{ "Confronting an Old Foe", "Konfrontation mit einem alten Feind", "Ante un viejo enemigo", "Confrontando a un viejo enemigo", "Un vieil adversaire", "Faccia a faccia contro un vecchio nemico", "숙적과의 조우", "Confronto com um antigo inimigo", "Старый враг", "面对老对手", "好久不見", }, 
{ "If He Will Not Listen to Reason...", "Und bist du nicht willig...", "Si no atiende a razones...", "Si no quiere entrar en razón...", "S’il ne veut pas entendre raison…", "Se non ascolterà la ragione...", "말을 듣지 않으면...", "Já que não quer ser razoável...", "Когда красноречие бессильно", "如果他不听劝……", "要是他不講道理…", }, 
{ "A Final Attempt at Diplomacy", "Ein letzter Versuch der Diplomatie", "Un último intento diplomático", "Un último intento de usar la diplomacia", "Une dernière tentative diplomatique", "Un ultimo tentativo di diplomazia", "마지막 제안", "Uma última chance à diplomacia", "Еще немного дипломатии", "外交上的最后努力", "最後一次嘗試溝通", }, 
},
["1321"] = {
{ "Cathedral of Eternal Night", "Die Kathedrale der Ewigen Nacht", "Catedral de la Noche Eterna", "Catedral de la Noche eterna", "Cathédrale de la Nuit éternelle", "Cattedrale della Notte Eterna", "영원한 밤의 대성당", "Catedral da Noite Eterna", "Собор Вечной Ночи", "永夜大教堂", "永夜聖殿", }, 
},
["1123"] = {
{ "On High Alert", "Höchste Alarmstufe", "En máxima alerta", "En alerta máxima", "En alerte", "Massima Allerta", "삼엄한 경계", "Em nível alto de alerta", "Повышенная готовность", "高度戒备", "高度警戒", }, 
{ "Live Drop", "Rauch ohne Feuer", "Un regalito", "Un botín con vida", "Ça va faire boum !", "Bomba in buca", "은밀한 교환", "Pessoalmente", "Дымовая операция", "当面传递", "即時投彈", }, 
{ "Tricks of the Trade", "Das A und O des Handelns", "Secretos del oficio", "Secretos del oficio", "Les ficelles du métier", "Trucchi del Mestiere", "장사의 비법", "Truques do Ofício", "Маленькие хитрости", "商业机密", "交易的訣竅", }, 
{ "To Catch a Cultist", "Einen Kultisten fangen", "Atrapar a un cultor", "La caza del cultor", "La capture d’un sectateur", "Catturare un cultista", "이교도 추적", "Como prender um sectário", "Охота на сектантов", "为了抓住一名教徒", "逮住教徒", }, 
{ "Rendezvous", "Rendezvous", "Punto de encuentro", "Encuentro", "Rendez-vous", "Raduno", "약속 지점", "Encontro marcado", "Встреча", "汇合点", "會合點", }, 
{ "We Need Answers", "Wir brauchen Antworten", "Necesitamos respuestas", "Necesitamos respuestas", "Il nous faut des réponses !", "Ci servono risposte", "실토", "Queremos respostas", "В поисках ответов", "我们需要答案", "我們需要答案", }, 
{ "On the Trail", "Auf den Fersen", "Siguiendo la pista", "Sobre la pista", "À la trace", "Sulle Tracce", "추적", "No Rastro", "Погоня по следу", "跟踪追击", "緊追不捨", }, 
{ "Marked for Death", "Todesurteil", "Marcado para morir", "Marcado para morir", "Désigné pour mourir", "Marchiato per morire", "죽음의 표적", "Marcado para morrer", "Метка смерти", "死亡标记", "死亡標記", }, 
{ "A Dark Gift", "Ein dunkles Geschenk", "Un oscuro regalo", "Un regalo oscuro", "Un sombre présent", "Un dono oscuro", "어둠의 선물", "Presente sinistro", "Темный дар", "黑暗的礼物", "黑暗贈禮", }, 
{ "Taking Your Leave", "Abschied nehmen", "Despedida", "Emprendiendo la huida", "Prendre congé", "Ossequi", "다음에 만나요", "Indo embora", "Отбытие", "离开一下", "告辭離開", }, 
},
["65"] = {
{ "Make Boomer's Brew", "Braut Hammerbräu", "Fermenta cerveza relámpago", "Fermenta cerveza relámpago", "Faire de la bière détonante", "Crea la Birra Esplosiva", "폭발 맥주 만들기", "Cerveja Explosiva", "Варка \"Громобоя\"", "酿造闪电陈酿", "釀造轟隆酒", }, 
{ "Road to Thunderpaw", "Donnerpfotenpfad", "Camino a Zarpa Atronadora", "Camino a Zarpa Atronadora", "Faire route vers Patte-du-Tonnerre", "Strada degli Zampa Tonante", "썬더포우로의 여정", "A Estrada para Pata do Trovão", "Дорога к пику Громовой Лапы", "雷掌之路", "前往雷爪靜修居", }, 
{ "Save Thunderpaw Refuge", "Rettet das Donnerpfotenrefugium", "Salva el Refugio Zarpa Atronadora", "Salva el Refugio Zarpa Atronadora", "Sauver le refuge Patte-du-Tonnerre", "Salva la dimora degli Zampa Tonante", "썬더포우 은거처를 구하라", "Salve o Refúgio Pata de Trovão", "Защита Укрытия Громовой Лапы", "拯救雷掌阁", "拯救雷爪靜修居", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["1177"] = {
{ "The Arcway", "Der Arkus", "La Arquería", "El Arco", "L’Arcavia", "L'Arcavia", "비전로", "O Arcâneo", "Катакомбы Сурамара", "魔法回廊", "幽暗地道", }, 
},
["45"] = {
{ "Stormstout Brewery", "Brauerei Sturmbräu", "Cervecería del Trueno", "Cervecería del Trueno", "Brasserie Brune d’Orage", "Birrificio Triplo Malto", "스톰스타우트 양조장", "Cervejaria Malte do Trovão", "Хмелеварня Буйных Портеров", "风暴烈酒酿造厂", "風暴烈酒酒坊", }, 
},
["920"] = {
{ "Eye of Azshara", "Das Auge Azsharas", "Ojo de Azshara", "Ojo de Azshara", "Œil d’Azshara", "Occhio di Azshara", "아즈샤라의 눈", "Olho de Azshara", "Око Азшары", "艾萨拉之眼", "艾薩拉之眼", }, 
},
["1099"] = {
{ "Thorim, Lord of Thunder", "Thorim, Herr des Donners", "Thorim, señor del trueno", "Thorim, Señor del Trueno", "Thorim, le seigneur du tonnerre", "Thorim, Re del Tuono", "천둥의 지배자 토림", "Thorim, Senhor do Trovão", "Торим, Повелитель Грома", "托里姆，雷电之王", "『雷霆之王』索林姆", }, 
{ "Battle is Joined", "Auf in die Schlacht", "La batalla comienza", "Unido a la batalla", "La bataille fait rage", "Unirsi alla battaglia", "전투 시작", "Entrando em batalha", "Битва началась", "战斗开始", "加入戰鬥", }, 
{ "Madness of the Usurper", "Wahnsinn des Thronräubers", "La locura de la usurpadora", "La locura del usurpador", "La démence de l’usurpatrice", "Follia dell'Usurpatrice", "강탈자의 광기", "Loucura do usurpador", "Безумие захватчицы", "篡神者的疯狂", "篡位者的瘋狂", }, 
{ "Heart of Thunder", "Herz des Sturms", "Corazón de trueno", "Corazón de trueno", "Cœur de tonnerre", "Cuore di Tuono", "천둥의 심장", "Coração do trovão", "Сердце грозы", "雷霆之心", "雷霆之心", }, 
{ "The Power of the Titans", "Die Macht der Titanen", "El poder de los titanes", "El poder de los titanes", "La puissance des titans", "La potenza dei Titani", "티탄의 힘", "O poder dos titãs", "Сила титанов", "泰坦的力量", "泰坦之力", }, 
{ "Odyssey's End", "Ende der Odyssee", "El final de la odisea", "Fin de la odisea", "La fin de l’odyssée", "Fine dell'odissea", "서사시의 끝", "Fim da odisseia", "Конец Одиссеи", "冒险结束", "旅程的尾聲", }, 
},
["632"] = {
{ "The Slave Pens", "Die Sklavenunterkünfte", "Recinto de los Esclavos", "Recinto de los Esclavos", "Les enclos aux esclaves", "Fosse degli Schiavi", "강제 노역소", "O Pátio dos Escravos", "Узилище", "奴隶围栏", "奴隸監獄", }, 
},
["944"] = {
{ "Into the Mists", "In die Nebel", "Entre la niebla", "Entre la niebla", "Dans les brumes", "Nelle nebbie", "안개 속으로", "Brumas adentro", "Сквозь туман", "深入迷雾", "勇闖迷霧", }, 
{ "Village of the Damned", "Dorf der Verdammten", "La aldea de los Malditos", "La aldea de los Malditos", "Village des Damnés", "Il villaggio dei dannati", "저주받은 마을", "Vila dos malditos", "Деревня проклятых", "罪人村", "詛咒村落", }, 
{ "Deeper Into the Fog", "Tiefer in den Nebel", "En lo más profundo de la niebla", "En lo profundo de la niebla", "En plein brouillard", "Nel profondo della nebbia", "자욱한 안개 속으로", "Névoa adentro", "Все глубже в туман", "继续深入迷雾", "深入迷霧", }, 
{ "The Stolen Souls", "Die gestohlenen Seelen", "Las almas robadas", "Las almas robadas", "Les âmes volées", "Le anime rubate", "도난당한 영혼", "As almas roubadas", "Украденные души", "偷来的灵魂", "失竊的靈魂", }, 
{ "Vigfus Himself", "Vigfus höchstpersönlich", "El mismísimo Vigfus", "El propio Vigfus", "Vigfus en chair et en os", "Vigfus in persona", "비그푸스 블레이드윈드", "Vigfus em pessoa", "А вот и сам Вигфус", "维格弗斯亲至", "維格弗斯", }, 
{ "On The Trail", "Auf den Fersen", "Siguiendo la pista", "Pisándole los talones", "À la trace", "Seguire le tracce", "추적", "No rastro", "Погоня по следу", "蛛丝马迹", "緊追不捨", }, 
{ "The Warswords", "Die Kriegsschwerter", "Las Espadas de Guerra", "Las Espadas de Guerra", "Les épées de guerre", "Le spade da guerra", "전쟁검", "As Armíferas", "Боевые мечи", "战剑", "戰劍", }, 
},
["1179"] = {
{ "Surrounded by Darkness", "Umgeben von Dunkelheit", "Rodeados de oscuridad", "Rodeado de oscuridad", "Nimbés de ténèbres", "Circondati dall'oscurità", "어둠에 둘러싸여", "Envolto em escuridão", "В окружении тьмы", "被黑暗包围", "黑暗環伺", }, 
{ "Preparing for the Apocalypse", "Vorbereitung auf die Apokalypse", "Preparándose para el Apocalipsis", "Preparándose para el Apocalipsis", "Préparatifs en vue de l’apocalypse", "Preparativi per l'apocalisse", "재앙에 대비하라", "Preparando-se para o apocalipse", "Подготовка к апокалипсису", "准备迎接天启。", "備戰末日", }, 
{ "The Road to Fel", "Teufelstechnik", "El camino a la vileza", "El camino vil", "La route de la gangrène", "La via verso il vile", "지옥 마법으로의 길", "Estrada para a vileza", "Скверный путь", "邪能之路", "魔化之路", }, 
{ "Behold, the Endless March", "Seht, der endlose Marsch", "Contemplad la marcha interminable", "Observen, la Marcha Eterna", "La marche sans fin", "La marcia infinita", "보라, 끝없는 행진을", "Contemplem; a marcha sem fim", "Неисчислимое воинство", "看，无尽的大军", "無盡行軍", }, 
{ "No Man An Island", "Niemand ist eine Insel", "Ningún hombre es una isla", "Isla de nadie", "Aucun homme n’est une île", "L'isola di nessuno", "혼자가 아니다", "Ninguém é uma ilha", "Один в поле не воин", "吾道不孤", "無人是孤島", }, 
{ "True Sacrifice", "Ein echtes Opfer", "Verdadero sacrificio", "Un verdadero sacrificio", "Véritable sacrifice", "Un grande sacrificio", "진정한 희생", "Sacrifício verdadeiro", "Истинное самопожертвование", "真正的牺牲", "真正的犧牲", }, 
{ "When Good Men Do Nothing", "Wenn die Guten wegsehen", "Cuando los hombres buenos no hacen nada", "Cuando los buenos no hacen nada", "L’inaction des hommes de bien", "Quando i buoni non combinano nulla", "누군가는 해야 할 일", "Quando os bons cruzam os braços", "Когда честные бездействуют", "当好人袖手旁观", "當正義無作為", }, 
},
["744"] = {
{ "Extinguish Runes", "Löscht die Runen", "Extinción de runas", "Extinguir runas", "Éteindre les runes", "Estingui le rune", "룬 꺼뜨리기", "Extinguir runas", "Погасить руны", "熄灭符文", "熄滅符文", }, 
{ "Upper Blackrock Spire", "Obere Schwarzfelsspitze", "Cumbre de Roca Negra Superior", "Cumbre de Roca Negra superior", "Sommet du pic Rochenoire", "Bastioni di Roccianera Superiori", "검은바위 첨탑 상층", "Pico da Rocha Negra Superior", "Верхняя часть пика Черной горы", "黑石塔上层", "黑石塔上層", }, 
},
["616"] = {
{ "Magisters' Terrace", "Terrasse der Magister", "Bancal del Magister", "El Bancal del Magister", "La terrasse des Magistères", "Terrazza dei Magisteri", "마법학자의 정원", "Terraço dos Magísteres", "Терраса Магистров", "魔导师平台", "博學者殿堂", }, 
},
["516"] = {
{ "Shadowfang Keep", "Burg Schattenfang", "Castillo de Colmillo Oscuro", "Castillo de Colmillo Oscuro", "Donjon d’Ombrecroc", "Forte di Zannascura", "그림자송곳니 성채", "Bastilha da Presa Negra", "Крепость Темного Клыка", "影牙城堡", "影牙城堡", }, 
{ "Bonus Objective: Defeat Baron Silverlaine", "Bonusziel: Besiegt Baron Silberlein", "Objetivo de bonificación: Derrota al barón Filargenta", "Objetivo de bonificación: derrota al Barón Filargenta.", "Objectif bonus : vaincre le baron d’Argelaine", "Obiettivo bonus: sconfiggi il Barone Argenius", "추가 목표: 남작 실버레인 처치", "Objetivo bônus: Derrote o Barão Silverlaine", "Дополнительная задача: победите барона Сильверлейна", "奖励目标：击败席瓦莱恩男爵", "獎勵目標：擊敗席瓦萊恩男爵", }, 
{ "Bonus Objective: Defeat Commander Springvale", "Bonusziel: Besiegt Kommandant Grüntal", "Objetivo de bonificación: Derrota al comandante Vallefont", "Objetivo de bonificación: derrota al Comandante Vallefont.", "Objectif bonus : vaincre le commandant Printeval", "Obiettivo bonus: sconfiggi il Comandante Primavalle", "추가 목표: 사령관 스프링베일 처치", "Objetivo bônus: Derrote o Comandante Floraval", "Дополнительная задача: победите командира Спрингвейла", "奖励目标：击败指挥官斯普林瓦尔", "獎勵目標：指揮官斯普林瓦爾", }, 
},
["644"] = {
{ "Zul'Farrak", "Zul'Farrak", "Zul'Farrak", "Zul'Farrak", "Zul’Farrak", "Zul'Farrak", "줄파락", "Zul'Farrak", "Зул'Фаррак", "祖尔法拉克", "祖爾法拉克", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["1027"] = {
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
},
["331"] = {
{ "Preparations", "Vorbereitungen", "Preparativos", "Preparativos", "Les préliminaires", "Preparativi", "준비", "Os preparativos", "Приготовления", "准备就绪", "做好準備", }, 
{ "The Iron Star", "Der Eiserne Stern", "La estrella de hierro", "La Estrella de Hierro", "L’étoile de Fer", "La Pirostella", "강철의 별", "A Estrela de Ferro", "Железная звезда", "钢铁之星", "鋼鐵之星", }, 
{ "The Battle is Joined", "Auf in die Schlacht!", "Batalla coordinada", "Comenzó la batalla", "La bataille fait rage", "Unirsi alla battaglia", "전투 시작", "A Batalha Começou", "Союзники вступают в бой", "战斗打响", "盟友參戰", }, 
{ "The Iron Harbor", "Der Eiserne Hafen", "El puerto de la Horda de Hierro", "El puerto de hierro", "Le port de Fer", "Darsena di Ferro", "강철 항구", "O Porto de Ferro", "Железная гавань", "钢铁海港", "鋼鐵港灣", }, 
{ "The Weapon", "Die Waffe", "El arma", "El arma", "L’arme", "L'arma", "무기", "A Arma", "Орудие", "武器", "傳說武器", }, 
{ "Blackhand", "Schwarzfaust", "Puño Negro", "Puño Negro", "Main-Noire", "Manonera", "블랙핸드", "Mão Negra", "Чернорук", "黑手", "黑手", }, 
},
["318"] = {
{ "Collect Resources", "Sammelt Rohstoffe", "Reúne recursos", "Consigue recursos", "La collecte de ressources", "Raccogli le risorse", "자원 모으기", "Coletar recursos", "Добыча ресурсов", "收集资源", "收集資源", }, 
},
["531"] = {
{ "Shado-Pan Monastery", "Shado-Pan-Kloster", "Monasterio del Shadopan", "Monasterio del Shadopan", "Monastère des Pandashan", "Monastero degli Shandaren", "음영파 수도원", "Monastério Shado-pan", "Монастырь Шадо-Пан", "影踪禅院", "影潘僧院", }, 
},
["932"] = {
{ "Halls of Valor", "Die Hallen der Tapferkeit", "Cámaras del Valor", "Salones del Valor", "Les salles des Valeureux", "Sale del Valore", "용맹의 전당", "Salões da Bravura", "Чертоги Доблести", "英灵殿", "英靈殿", }, 
},
["574"] = {
{ "Zul'Aman", "Zul'Aman", "Zul'Aman", "Zul'Aman", "Zul’Aman", "Zul'Aman", "줄아만", "Zul'Aman", "Зул'Аман", "祖阿曼", "祖阿曼", }, 
},
["535"] = {
{ "Shado-Pan Monastery", "Shado-Pan-Kloster", "Monasterio del Shadopan", "Monasterio del Shadopan", "Monastère des Pandashan", "Monastero degli Shandaren", "음영파 수도원", "Monastério Shado-pan", "Монастырь Шадо-Пан", "影踪禅院", "影潘僧院", }, 
},
["635"] = {
{ "The Blood Furnace", "Der Blutkessel", "El Horno de Sangre", "El Horno de Sangre", "La Fournaise du sang", "Forgia del Sangue", "피의 용광로", "A Fornalha de Sangue", "Кузня Крови", "鲜血熔炉", "血熔爐", }, 
},
["510"] = {
{ "The Stockade", "Das Verlies", "Las Mazmorras", "Las Mazmorras", "La Prison", "Segrete di Roccavento", "스톰윈드 지하감옥", "O Cárcere", "Тюрьма", "监狱", "監獄", }, 
},
["15"] = {
{ "Escort Brewmaster Bo", "Eskortiert Braumeister Bo", "Escolta al maestro cervecero Bo", "Escolta al maestro cervecero Bo", "Escorter le maître brasseur Bo", "Scorta il Mastro Birraio Bo", "양조사 보 호위", "Escolte o Mestre Cervejeiro Bô", "Сопровождение хмелевара Бо", "护送珀酒仙", "護送釀酒大師阿波", }, 
{ "Fill the Brewing Cauldron", "Füllt den Braukessel", "Llena el caldero de fermentación", "Llena el caldero de fermentación", "Remplir le chaudron de brassage", "Riempi il Tino di Fermentazione", "양조 가마솥 채우기", "Encha o Caldeirão de Brassagem", "Наполнение хмелеваренного котла", "装满酿酒大锅", "倒滿釀酒鍋", }, 
{ "Defeat Captain Ook", "Bezwingt Kapitän Uuk", "Derrota al capitán Ook.", "Derrota al capitán Ook.", "Vaincre le capitaine Ouk", "Sconfiggi Capitan Gancino", "선장 우끼 처치", "Derrote o Capitão Fedô", "Победа над капитаном Уком", "击败乌克头领", "殺死烏克船長", }, 
},
["1014"] = {
{ "The Downward Spiral", "Die Abwärtsspirale", "La espiral descendente", "La espiral descendente", "Spirale descendante", "La spirale discendente", "악순환", "A espiral descendente", "Вниз по винтовой лестнице", "逆塔", "往下的迴旋樓梯", }, 
{ "Grasp of the Damned", "Umklammerung der Verdammten", "En manos de los malditos", "El alcance de los malditos", "L’emprise des damnés", "Presa dei dannati", "저주받은 자의 손아귀", "Garras dos condenados", "Хватка проклятых", "亡者的爪缚", "詛咒之握", }, 
{ "Removal Protocols", "Entfernungsprotokolle", "Protocolos de eliminación", "Protocolos de eliminación", "Protocoles d’élimination", "Protocolli di rimozione", "작동규약 제거", "Protocolos de remoção", "Протоколы ликвидации", "清除协议", "移除程序", }, 
{ "Elune's Prize", "Elunes Trophäe", "El trofeo de Elune", "El premio de Elune", "Le trophée d’Élune", "Il premio di Elune", "엘룬의 유물", "O prêmio de Eluna", "Трофей Элуны", "艾露恩的宝物", "伊露恩的寶藏", }, 
{ "The Rider's Prize", "Der Preis des Reiters", "El trofeo del jinete", "El premio del jinete", "Le trophée du cavalier", "Il premio dei Cavalieri", "기수의 유물", "O prêmio do cavalgante", "Трофей всадника", "黑骑士的财宝", "黑騎兵的寶物", }, 
{ "Reaping the Riders", "Jetzt ist Sense für die Reiter", "Segar a los jinetes", "Segando a los jinetes", "Faucher les cavaliers", "Mietere i Cavalieri", "암흑 기수의 최후", "A ceifa dos cavalgantes", "Жатва Всадников", "收割黑骑士", "劫掠騎兵的寶物", }, 
{ "The Scythe Reclaimed", "Die zurückeroberte Sichel", "Guadaña reclamada", "La Guadaña recuperada", "Récupération de la faux", "La Falce recuperata", "되찾은 낫", "A foice recuperada", "Возвращение Косы", "镰刀回归", "奪回鐮刀", }, 
},
["1108"] = {
{ "On the Prowl", "Auf der Lauer", "Al acecho", "Merodear", "La bête rôde", "A caccia", "탐색", "À espreita", "В поисках", "潜伏徘徊", "潛行", }, 
{ "Where There's a Withered There's a Way", "Verwirrt, verdorrt, versperrt", "Las ruinas no te detienen", "Donde se pierde la ilusión, un marchito es la solución", "Par ici mon flétri", "Dove c'è un Avvizzito c'è gioia", "메마른 자가 있는 곳에 길이 있다", "Quando fenecidos não faltam, abre-se um caminho", "Способ есть всегда", "有枯法者，事竟成", "有凋萎者事竟成", }, 
{ "Onward, Upward, and Downward", "Vorwärts, aufwärts, abwärts", "Arriba, abajo y para dentro", "Hacia adelante, hacia arriba, hacia abajo", "Tout droit, en haut et en bas", "Avanti, indietro, giù", "앞, 아래, 위, 위, 아래", "Pra frente, pra cima e pra baixo", "Вперед, в неизвестность", "向前，向上，向下", "前進、往上、往下", }, 
{ "It's a Furball", "Braves Kätzchen", "Bola de pelo", "Es una bola de pelos", "C’est une boule de poils !", "È una palla di pelo!", "감당할 수 없는 힘", "Bola de pelos", "Снова белый и пушистый", "可爱的毛球", "一團毛球", }, 
{ "Into the Darkness", "In die Finsternis", "En la oscuridad", "Hacia la oscuridad", "Dans les ténèbres", "Nell'oscurità", "어둠 속으로", "Escuridão adentro", "Тьма и сырость", "进入黑暗", "進入黑暗", }, 
{ "In a Tangled Web", "Gefangen im Netz", "Enredo en la red", "En una red enmarañada", "Dans une toile enchevêtrée", "In una tela intricata", "휘감는 거미줄", "Numa teia emaranhada", "Попавшийся в сети", "身陷缠绕之网", "身不由己", }, 
{ "The Fangs of Ashamane", "Die Fänge von Ashamane", "Los Colmillos de Crinceniza", "Los Colmillos de Ashamane", "Les Crocs d’Ashamane", "Le Zanne di Grigiomanto", "아샤메인의 송곳니", "As presas de Ashamane", "Клыки Пеплошкурой", "阿莎曼之牙", "亞夏曼之牙", }, 
{ "To the Grove", "Auf zum Hain", "A la Arboleda", "Hacia la Arboleda", "Vers la Sylverêve", "Verso il bosco", "꿈숲으로", "Rumo ao Bosque", "Назад, в Рощу", "前往林地", "前往林地", }, 
},
["1312"] = {
{ "Meet Up with Thisalee", "Treffen mit Thisalee", "Reunión con Thisalee", "Reúnete con Thisalee", "Retrouver Thisalee", "Incontro con Thisalee", "티살리 상봉", "Encontrar Tessália", "Встреча с Тизали", "与希萨莉汇合", "跟黎沙莉會合", }, 
{ "Infiltrate the Legion Encampment", "Infiltration des Legionslagers", "Infiltrarse en el campamento de la Legión", "Infíltrate en el campamento de la Legión", "Infiltrer le campement de la Légion", "Nell'accampamento della Legione", "군단 야영지 침투", "Penetrar no acampamento da Legião", "Проникновение в лагерь Легиона", "潜入军团营地", "潛入燃燒軍團營地", }, 
{ "Scouting Infazzar's Plans", "Infazzars Pläne aufdecken", "Descubrir los planes de Infazzar", "Averigua los planes de Infazzar", "Dévoiler les plans d’Infazzar", "I piani di Infazzar", "인파자르의 계획 염탐", "Descobrir os planos de Infazzar", "Планы Инфаззара", "探查伊法扎尔的计划", "探查因法薩爾的計畫", }, 
{ "Flying Abominations", "Fliegende Monstrositäten", "Abominaciones voladoras", "Abominaciones voladoras", "Abominations volantes", "Abomini volanti", "날개 달린 괴물", "Abominações voadoras", "Летающие твари", "飞行的怪物", "飛翼怪物", }, 
{ "Follow Infazzar", "Folgt Infazzar", "Seguir a Infazzar", "Sigue a Infazzar", "Suivre Infazzar", "Seguire Infazzar", "인파자르 추적", "Seguir Infazzar", "Погоня за Инфаззаром", "跟踪伊法扎尔", "跟蹤因法薩爾", }, 
{ "Kill Infazzar", "Tötet Infazzar", "Matar a Infazzar", "Mata a Infazzar", "Tuer Infazzar", "Uccidi Infazzar", "인파자르 처치", "Matar Infazzar", "Смерть Инфаззару!", "击杀伊法扎尔", "殺死因法薩爾", }, 
{ "Return to the Dreamgrove", "Rückkehr zum Hain der Träume", "Retorno a la Arboleda de los Sueños", "Regresa a la Arboleda de los Sueños", "Retour à la Sylverêve", "Ritorno al Bosco dei Sogni", "다시 꿈숲으로", "Retorno ao Bosque Onírico", "Возвращение в Рощу Снов", "返回梦境林地", "返回幻夢之林", }, 
},
["210"] = {
{ "The Mountaineers", "Die Gebirgsjäger", "Los montaraces", "Los montaraces", "Les montagnards", "I Montanari", "산악경비대원들", "Os Montanhistas", "Горная пехота", "巡山人", "巡山人", }, 
{ "Save Scout Stonebeard", "Rettet Späher Steinbart", "Salva al explorador Barbapétrea", "Salva al explorador Barbapétrea", "Sauver l’éclaireur Barbe-de-Pierre", "Salva l'Esploratore Barbapietra", "정찰병 스톤비어드 구출", "Resgatar o Batedor Barbarrocha", "Спасение разведчика Камнеборода", "解救斥候石须", "解救斥候石鬚", }, 
{ "Save Scout Boldbrew", "Rettet Späherin Kühnbräu", "Salva a la exploradora Birraudaz", "Salva a la exploradora Birraudaz", "Sauver l’éclaireuse Bièrafeu", "Salva l'Esploratrice Birrardita", "정찰병 볼드브루 구출", "Resgatar a Batedora Cervamarga", "Спасение разведчицы Резковар", "解救斥候粗酿", "解救斥候勇釀", }, 
{ "Save Scout Forgefellow", "Rettet Späher Schmiedebalg", "Salva al explorador Forjaleal", "Salva al explorador Forjaleal", "Sauver l’éclaireur Forgepair", "Salva l'Esploratore Granforgia", "정찰병 포지펠로 구출", "Resgatar o Batedor Forjamigo", "Спасение разведчика Кузнебрата", "解救斥候炉匠", "解救斥候鍛扈", }, 
{ "The Cold Cave", "Die kalte Höhle", "La cueva de hielo", "La cueva de hielo", "La grotte glacée", "La grotta gelida", "차가운 동굴", "A Caverna Gelada", "Ледяная пещера", "寒冷的洞穴", "冰穴", }, 
{ "Victory or Death", "Sieg oder Tod", "Victoria o muerte", "Victoria o muerte", "La victoire ou la mort", "Vittoria o morte", "승리가 아니면 죽음을", "Vitória ou Morte", "Победа или смерть", "不成功，就成仁", "不勝即亡", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["975"] = {
{ "Repel the Invaders", "Gegenwehr", "Repeler a los invasores", "Expulsa a los invasores", "Repousser les envahisseurs", "Respingere gli invasori", "침략자 격퇴", "Rechaçar os invasores", "Отпор захватчикам", "驱逐入侵者", "擊退入侵者", }, 
{ "The Mother's Revenge", "Die Rache der Mutter", "La venganza de la madre", "La venganza de la madre", "Vengeance maternelle", "Vendetta della madre", "어미의 복수", "A revanche da mãe", "Месть матери", "母亲的复仇", "族母的復仇", }, 
{ "Gaining Control", "Die Kontrolle gewinnen", "Recuperar el control", "Bajo control", "Prise de contrôle", "Prendere il controllo", "제어권 획득", "Tomar o comando", "Восстановление контроля", "获取控制权", "取得控制", }, 
{ "Mutual Destruction", "Wie du mir, so ich dir", "Destrucción mutua", "Destrucción mutua", "Destruction mutuelle", "Distruzione reciproca", "상호 파괴", "Destruição mútua", "Взаимное уничтожение", "同归于尽", "相互毀滅", }, 
},
["216"] = {
{ "Talk to the Boss", "Sprecht mit dem Boss", "Habla con el jefe", "Habla con el jefe", "Parler au patron", "Parla col capo", "대장에게 말해봐", "Falar com o Chefe", "Разговор с вожаком", "跟老板谈谈", "與工頭交談", }, 
{ "Rock Grinding", "Felsen mahlen", "Roca pulverizada", "Roca pulverizada", "Casser du caillou", "Frantumare la roccia", "날뛰는 원소 정령", "Triturando rochas", "Грохот камней", "碎石机", "研磨石頭", }, 
{ "Economic Recovery", "Wirtschaftsaufschwung", "Recuperación económica", "Recuperación económica", "Reprise économique", "Recupero economico", "경제를 살리자", "Recuperação econômica", "Набить карманы", "经济复苏", "經濟復甦", }, 
{ "End of the Mine", "Das Ende der Mine", "Fin de la mina", "Fin de la mina", "Le fond de la mine", "In fondo alla miniera", "광산의 끝", "Fim da Mina", "Конец рудника", "矿洞的末端", "礦坑終點", }, 
{ "Heartbreak", "Gebrochenes Herz", "Corazón partido", "Corazón partido", "Cœur brisé", "Crepacuore", "심장을 노려라!", "Coração Partido", "Разбитое сердце", "心碎", "心碎", }, 
{ "Bonus Objectives", "Bonusziele", "Objetivos de bonificación", "Objetivos de bonificación", "Objectifs bonus", "Obiettivi bonus", "추가 목표", "Objetivos bônus", "Дополнительные задачи", "奖励目标", "獎勵目標", }, 
},
["523"] = {
{ "Shadowfang Keep", "Burg Schattenfang", "Castillo de Colmillo Oscuro", "Castillo de Colmillo Oscuro", "Donjon d’Ombrecroc", "Forte di Zannascura", "그림자송곳니 성채", "Bastilha da Presa Negra", "Крепость Темного Клыка", "影牙城堡", "影牙城堡", }, 
{ "Bonus Objective: Defeat Baron Silverlaine", "Bonusziel: Besiegt Baron Silberlein", "Objetivo de bonificación: Derrota al barón Filargenta", "Objetivo de bonificación: derrota al Barón Filargenta.", "Objectif bonus : vaincre le baron d’Argelaine", "Obiettivo bonus: sconfiggi il Barone Argenius", "추가 목표: 남작 실버레인 처치", "Objetivo bônus: Derrote o Barão Silverlaine", "Дополнительная задача: победите барона Сильверлейна", "奖励目标：击败席瓦莱恩男爵", "獎勵目標：擊敗席瓦萊恩男爵", }, 
{ "Bonus Objective: Defeat Commander Springvale", "Bonusziel: Besiegt Kommandant Grüntal", "Objetivo de bonificación: Derrota al comandante Vallefont", "Objetivo de bonificación: derrota al Comandante Vallefont.", "Objectif bonus : vaincre le commandant Printeval", "Obiettivo bonus: sconfiggi il Comandante Primavalle", "추가 목표: 사령관 스프링베일 처치", "Objetivo bônus: Derrote o Comandante Floraval", "Дополнительная задача: победите командира Спрингвейла", "奖励目标：击败指挥官斯普林瓦尔", "獎勵目標：指揮官斯普林瓦爾", }, 
},
["623"] = {
{ "Sethekk Halls", "Sethekkhallen", "Salas Sethekk", "Salas Sethekk", "Les salles des Sethekk", "Sale dei Sethekk", "세데크 전당", "Salões dos Sethekk", "Сетеккские залы", "塞泰克大厅", "塞司克大廳", }, 
},
["323"] = {
{ "Stop the Ritual", "Beendet das Ritual", "Detén el ritual", "Detén el ritual", "Arrêter le rituel", "Ferma il rituale", "의식 멈추기", "Impeça o Ritual", "Прервать ритуал", "终止仪式", "阻止儀式", }, 
{ "Army of Souls", "Seelenarmee", "Ejército de almas", "Ejército de almas", "L’armée des âmes", "Armata di anime", "영혼의 군대", "Exército de Almas", "Армия душ", "幽灵大军", "靈魂大軍", }, 
{ "Kilrogg Deadeye", "Kilrogg Totauge", "Kilrogg Mortojo", "Kilrogg Ojo Muerto", "Kilrogg Oeil-Mort", "Kilrogg Occhiotetro", "킬로그 데드아이", "Kilrogg Olho Morto", "Килрогг Мертвый Глаз", "基尔罗格·死眼", "基爾羅格‧亡眼", }, 
{ "5 Bonus", "5er-Bonus", "5 bonificaciones", "Bonus 5", "Bonus de 5", "5 bonus", "5 보너스", "5 bônus", "Еще 5", "5连斩奖励", "5的獎勵", }, 
{ "10 Bonus", "10er-Bonus", "10 bonificaciones", "Bonus 10", "Bonus de 10", "10 bonus", "10 보너스", "10 bônus", "Еще 10", "10连斩奖励", "10的獎勵", }, 
},
["1221"] = {
{ "Agatha's Lair", "Agathas Hort", "Guarida de Agatha", "Guarida de Agatha", "L’antre d’Agatha", "L'antro di Agatha", "아가타의 소굴", "Covil de Ágata", "Логово Агаты", "阿加莎的巢穴", "亞加薩巢穴", }, 
},
["1093"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Charging Headfirst Into Battle", "Mit dem Kopf voran in den Kampf", "De cabeza al combate", "De cabeza a la batalla", "Foncer tête baissée", "A testa bassa in battaglia", "일단 돌진", "Mergulhar de cabeça na batalha", "Рывок на передовую", "一头冲进战斗", "直衝戰場", }, 
{ "Take A Big Swing At It", "Einmal richtig Schwung holen", "Dar el golpe", "Intento de golpe", "Et v’lan !", "Manutenzione percussiva", "큰 거 한 방", "Com toda a força", "Бей, круши!", "用力挥舞", "這會打死人的", }, 
{ "Slamming it Home", "Ins Ziel schmettern", "Golpetazo monumental", "Corrida a base", "Coup de boutoir", "Una bella botta", "강력한 충돌", "Rebatida pra isolar", "Всем ударам удар", "击回老家", "勇猛的攻擊", }, 
{ "Smash Them To Pieces", "Kurz und klein schlagen", "Hazlos picadillo", "Hazlos pedazos", "Façon puzzle", "Farli a pezzi", "산산조각 부수기", "Estrago colossal", "Кулак гиганта", "打成碎片", "把它們擊碎", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Such a Rush", "Berauschend", "Con las prisas", "Qué prisa", "Montée d’adrénaline", "Che divertimento!", "패배는 없다", "Sem conter o ímpeto", "Абсолютный триумф", "急匆匆", "血氣衝上心頭", }, 
{ "Take It For A Spin", "Immer schön im Kreis drehen", "Dar una vuelta", "Échalo a rodar", "Ça tourne !", "Andare a farsi un giro", "뱅글뱅글", "Dando umas voltas", "Головокружение до изнеможения", "来转一圈看看", "轉吧轉吧", }, 
{ "Jump Into The Fray", "Sprung mitten ins Geschehen", "Salto a la refriega", "Métete a la refriega", "Bond dans la mêlée", "Nel vivo della lotta!", "격전 속으로", "Pular de cabeça", "Прыжок в гущу боя", "跳入战场", "跳入戰場", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["627"] = {
{ "Auchenai Crypts", "Auchenaikrypta", "Criptas Auchenai", "Criptas Auchenai", "Cryptes Auchenaï", "Cripte degli Auchenai", "아키나이 납골당", "Catacumbas Auchenai", "Аукенайские гробницы", "奥金尼地穴", "奧奇奈地穴", }, 
},
["1271"] = {
{ "Speak with Cenarius", "Sprecht mit Cenarius", "Hablar con Cenarius", "Habla con Cenarius", "Parler à Cénarius", "Parla con Cenarius", "세나리우스와 대화", "Falar com Cenarius", "Встреча с Кенарием", "与塞纳留斯谈一谈", "與塞納留斯交談", }, 
{ "Secure a Foothold", "Sichert eine Stellung", "Asegurar la posición", "Asegura una posición", "S’assurer une base", "Conquistare un avamposto", "거점 확보", "Garantir uma posição", "Укрепление позиций", "立足之地", "佔領據點", }, 
{ "Open the Way", "Freie Bahn", "Abrir el camino", "Abre el camino", "Ouvrir la voie", "Aprire la via", "길 확보", "Abrir caminho", "Расчистить путь", "打开道路", "開啟通道", }, 
{ "Moving on up", "Es geht aufwärts", "Llegar a lo más alto", "Hacia arriba", "Toujours plus haut", "Risalita", "위로 이동", "Sobe!", "Путь наверх", "登高望远", "登上高處", }, 
{ "Lord of the Tower", "Herr des Turms", "Señor de la torre", "Señor de la torre", "Seigneur de la tour", "Signore della torre", "탑의 군주", "Senhor da torre", "Повелитель башни", "塔楼里的领主", "高塔之主", }, 
{ "Clear the skies", "Den Luftraum säubern", "Despejar los cielos", "Hay que despejar los cielos", "Dégager l’espace aérien", "Ripulire i cieli", "하늘 청소", "Limpar os céus", "Чистое небо", "肃清空域", "掃蕩天空", }, 
{ "Up and Away", "Auf und davon", "¡Hasta el cielo y más allá!", "Allá vamos", "On décolle", "Sempre più in alto", "위로 더 위로", "Para o alto e avante", "Вверх, под облака", "远走高飞", "遠走高飛", }, 
{ "Defeat the Legion Commander", "Bezwingt den Kommandanten der Legion", "Derrota al comandante de la Legión", "Derrota al Comandante de la Legión", "Terrasser le commandant de la Légion", "Sconfiggere il Comandante della Legione", "군단 사령관 처치", "Derrotar o Comandante de legião", "Победа над командиром Легиона", "击败军团指挥官", "擊敗燃燒軍團指揮官", }, 
{ "Escape!", "Flieht!", "¡Huida!", "¡Escapa!", "Fuyez !", "Fuga!", "탈출!", "Fuja!", "Побег!", "逃亡！", "脫逃！", }, 
},
["44"] = {
{ "Temple of the Jade Serpent", "Tempel der Jadeschlange", "Templo del Dragón de Jade", "Templo del Dragón de Jade", "Temple du Serpent de jade", "Tempio della Serpe di Giada", "옥룡사", "Templo da Serpente de Jade", "Храм Нефритовой Змеи", "青龙寺", "玉蛟寺", }, 
},
["1091"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "A Pinch Of Fire", "Eine Prise Feuer", "Una pizca de fuego", "Una pequeña llama", "Une pincée de feu", "Un pizzico di Fuoco", "뜨거운 맛", "Um pouco de fogo", "Дай жару!", "一小撮火焰", "一點火花", }, 
{ "Lava Launcher", "Lavawerfer", "Lanzalava", "Lanzador de lava", "Lanceur de lave", "Lanciatore di lava", "치솟는 용암", "Lança-lava", "Сила вулкана", "熔岩发射器", "熔岩發射器", }, 
{ "Lightning Bolt! Lightning Bolt!", "Blitzschlag! Blitzschlag!", "¡Descarga de relámpagos!", "¡Descarga de relámpagos! ¡Descarga de relámpagos!", "Électrifiant !", "Dardo Fulminante! Dardo Fulminante!", "파지직! 파지직!", "Raios!", "Гром и молния", "闪电箭！闪电箭！", "閃電箭！閃電箭！", }, 
{ "Let It Rock", "Rollende Steine", "Impacto pétreo", "Que empiece la fiesta", "Ça va secouer !", "Spacca!", "요동하는 대지", "Rock n' roll", "Могущество из самых недр", "摇摆起来", "搖滾大地", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Ribbit,  Ribbit.", "Quaaak, quaaak.", "Croac, croac", "Croac, croac.", "Coâ, coâ !", "Cra, cra!", "개굴, 개굴", "Croac, croac.", "Кто сказал \"ква\"?", "呱，呱", "嘓嘓。", }, 
{ "Shocking the World", "Ein Schock für die Welt", "Descarga al mundo", "Un impacto para el mundo", "Électriser le monde", "Scioccante!", "충격적인 세계", "Abalando o mundo", "Потрясение для всего мира", "电击世界", "震撼世界", }, 
{ "Dousing Your Wounds", "Eine Welle der Heilung", "Empapa tus heridas", "Empapando las heridas", "Doux apaisement", "Lavarsi le ferite", "상처 돌보기", "Fechar as feridas", "Ванна из целебного бальзама", "浸泡伤口", "清理傷口", }, 
{ "Unleashing The Elements", "Die Elemente entfesseln", "Liberación de elementos", "Liberando los elementos", "Libérer les éléments", "Scatenare gli elementi", "정령 해방", "Libertar os elementos", "Освобождение стихий", "释放元素", "釋放元素", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["1045"] = {
{ "Fill the bar", "Füllt die Leiste", "Llenar la barra", "Rellena la barra", "Remplir la barre", "Riempire la barra", "주점 채우기", "Preencha a barra", "Заполните панель", "填满进度条", "補滿能量條", }, 
{ "A Final Step", "Ein letzter Schritt", "Un último paso", "El último paso", "Dernière étape", "L'ultimo passo", "마지막 단계", "Um último passo", "Последний шаг", "最后一步", "最後一步", }, 
},
["1150"] = {
{ "Loadout", "Verladen", "Equipamiento", "Carga total", "Battre le rappel", "Pronti e carichi", "군장", "Equipamento", "Начало операции", "战略物资", "整裝待發", }, 
{ "Down in the Depths", "Hinab in die Tiefen", "En las profundidades", "Bien en lo profundo", "Descente dans les profondeurs", "Giù nelle profondità", "깊이, 더 깊이", "Nas profundezas", "Вниз, к самым глубинам", "迈入深渊", "深入遺跡", }, 
{ "Spoils of War", "Kriegsbeute", "Botín de guerra", "Botín de guerra", "Butin de guerre", "Spoglie di Guerra", "전쟁의 전리품", "Espólios da Guerra", "Трофеи войны", "战争横财", "戰利品", }, 
},
["1083"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Call a Friend", "Einen Freund rufen", "Llama a un amigo", "Llamar a un amigo", "Appel à un ami", "Amici più di prima", "친구 부르기", "Chamar um amigo", "Помощь друга", "召唤小伙伴", "呼喚朋友", }, 
{ "Pet, Attack!", "Fass!", "¡Mascota, ataca!", "¡Mascota, ataca!", "Attaque, mon mignon !", "Famiglio, attacca!", "착하지, 물어!", "Ajudante, atacar!", "Фас!", "宠物，进攻！", "寵物，攻擊！", }, 
{ "Looking for More", "Auf der Suche nach mehr", "Buscar más", "Buscar más", "Recherche de compagnons", "Lo spirito della bestia", "타격 그 이상", "Procurando mais", "Инстинкт хищника", "还要更多", "想要更多", }, 
{ "Getting In On The Action", "Mittendrin statt nur dabei", "Entrar en acción", "Directo hacia la acción", "Un peu d’action", "Entrare in azione", "사격 개시", "Botando pra quebrar", "Выстрел в темноте", "开始行动", "實地使用", }, 
{ "You Won't Like Us When We're Mad...", "Wehe, wenn sie losgelassen...", "No te conviene enfadarnos...", "No te gustará vernos enojados...", "Je vais devoir me fâcher…", "Non ti piacerà vederli arrabbiati...", "드러난 광기", "Não vai gostar de ver-nos bravos...", "В гневе мы страшны", "我们发怒的样子可不好看……", "你不會想惹怒我們的…", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Shooting Every Target", "Jeder Schuss ein Treffer", "Disparar a todos los objetivos", "Un disparo para cada objetivo", "Un carquois bien plein", "Piazza pulita", "집중 사격", "Atirando em todos os alvos", "Стрельба по тарелочкам", "射击每一个目标", "射擊每個目標", }, 
{ "Playing Possum", "Kein Puls, keine Regung", "Hacerse el muerto", "Hacerse el muerto", "Simulacre de mort", "Giocare a fare il morto", "죽은 척하기", "Fingindo de morto", "Притвориться мертвым", "负鼠爱装死", "裝死", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["654"] = {
{ "Razorfen Kraul", "Kral der Klingenhauer", "Horado Rajacieno", "Horado Rajacieno", "Kraal de Tranchebauge", "Gallerie di Lamaspina", "가시덩굴 우리", "Urzal dos Tuscos", "Лабиринты Иглошкурых", "剃刀沼泽", "剃刀沼澤", }, 
},
["1338"] = {
{ "Chamber of the Avatar", "Die Kammer des Avatars", "Cámara del Avatar", "Cámara del Avatar", "Chambre de l’Avatar", "Sala dell'Avatar", "화신의 방", "Câmara do Avatar", "Зал аватары", "化身密室", "化身密室", }, 
},
["426"] = {
{ "Iron Docks", "Eisendocks", "Puerto de Hierro", "Muelles de Hierro", "Quais de Fer", "Darsena di Ferro", "강철 선착장", "Docas de Ferro", "Железные доки", "钢铁码头", "鋼鐵碼頭", }, 
},
["526"] = {
{ "Gate of the Setting Sun", "Tor der Untergehenden Sonne", "Puerta del Sol Poniente", "Puerta del Sol Poniente", "Porte du Soleil couchant", "Porta del Sole Calante", "석양문", "Portal do Sol Poente", "Врата Заходящего Солнца", "残阳关", "落陽關", }, 
},
["909"] = {
{ "The Sealed Tomb", "Das versiegelte Grab", "La tumba sellada", "La tumba sellada", "Le tombeau scellé", "La tomba sigillata", "봉인된 무덤", "A tumba lacrada", "Запечатанная гробница", "封锁的墓穴", "封印之墓", }, 
{ "The Disturbance", "Die Störung", "La perturbación", "La perturbación", "Trouble-fête", "Disturbare i morti", "방해", "A perturbação", "Расхитители гробниц", "骚扰", "動亂", }, 
{ "Crypt Crawl", "Gruft abgrasen", "Adéntrate en la cripta", "Exploración de la cripta", "Exploration des cryptes", "Strisciare nella cripta", "납골당 수색", "Busca na cripta", "Обшаривание склепа", "探索墓穴", "潛入墓穴", }, 
{ "The Confrontation", "Die Konfrontation", "El enfrentamiento", "La confrontación", "L’affrontement", "Il confronto", "대치", "O confronto", "Противостояние", "决战", "對峙", }, 
{ "The Greatest Warrior", "", "", "El mejor guerrero", "", "Il guerriero più grande", "가장 위대한 전사", "O maior guerreiro", "", "最伟大的战士", "最偉大的戰士", }, 
{ "Armaments of the Black Wyrm", "Waffen des schwarzen Wyrms", "Armamentos del dragón Negro", "Los armamentos del Dragón Negro", "Arsenal des wyrms noirs", "Armamenti del Dragone Nero", "검은 고룡의 장비", "Armamentos da Serpe Negra", "Оружие Черного змея", "黑龙的守护", "黑龍武裝", }, 
},
["1082"] = {
{ "Island Landing", "Insulare Anlandung", "Llegada a la isla", "Peñón de la isla", "Débarquement insulaire", "Approdo all'isola", "섬 도착", "Chegada à ilha", "Высадка на острове", "登陆岛屿", "降落島嶼", }, 
{ "Into the Tomb", "Ins Grab", "Hacia la tumba", "Hacia la tumba", "Dans la tombe", "Nella tomba", "무덤 속으로", "Tumba adentro", "В гробницу", "墓穴之中", "深入墓穴", }, 
{ "Opening the Door", "Öffnen der Tür", "Abrir la puerta", "Abrir la puerta", "Ouvrir la porte", "Aprire la porta", "문 열기", "De portas abertas", "Дверь", "开门", "開門", }, 
{ "Shrine of the Truthguard", "Der Schrein des Wahrheitshüters", "Santuario de la Veraguardia", "Santuario de la Veraguardia", "Sanctuaire de Garde-Vérité", "Santuario dello Scudo della Verità", "진실의 수호자의 제단", "Santuário da Guarda Fiel", "Святилище Стража Истины", "真理守护者祭坛", "真理之盾神殿", }, 
{ "Yrgrim's Challenge", "Yrgrims Herausforderung", "Desafío de Yrgrim", "El desafío de Yrgrim", "Le défi d’Yrgrim", "La sfida di Yrgrim", "위르그림의 도전", "Desafio de Yrgrim", "Испытание Иргрима", "伊格瑞姆的挑战", "厄格林的挑戰", }, 
{ "The Truthguard", "Der Wahrheitshüter", "Veraguardia", "La Veraguardia", "Garde-Vérité", "Lo Scudo della Verità", "진실의 수호자", "A Guarda Fiel", "Страж Истины", "真理守护者", "真理之盾", }, 
},
["826"] = {
{ "Prepare for Battle", "Bereit für die Schlacht", "Prepararse para la batalla", "Prepárate para la batalla", "Une bataille à préparer", "Prepararsi alla battaglia", "전투 준비", "Preparação para a batalha", "Подготовка к битве", "准备作战", "準備戰鬥", }, 
{ "Fire at Will!", "Feuer frei!", "¡Fuego a discreción!", "¡Fuego a discreción!", "Feu à volonté !", "Fuoco a volontà!", "함포 발사!", "Atire quando quiser!", "Огонь по готовности!", "自由射击！", "全面射擊！", }, 
{ "Justice from Above", "Gerechtigkeit von oben", "Justicia desde el cielo", "Justicia desde el cielo", "La justice des cieux", "Una pioggia di giustizia", "하늘에서 정의가", "Justiça das alturas", "Правосудие свыше", "从天而降的正义", "正義從天而降", }, 
{ "Bats in the Bomb Bay", "Fledermäuse im Bombenschacht", "Murciélagos entre las armas", "Murciélagos en la Bahía de bombas", "Des chauves-souris dans la soute", "Pipistrelli nella polveriera", "조명탄 제거", "Morcegos no compartimento de bombas", "Нетопыри в бомбовом отсеке", "弹药舱中的蝙蝠", "炸彈艙的危機", }, 
{ "Last Stand", "Das letzte Gefecht", "Resistencia final", "Resistencia final", "Dans les derniers retranchements", "L'ultimo baluardo", "최후의 결전", "Resistência final", "Ни шагу назад", "破釜沉舟", "背水一戰", }, 
},
["1005"] = {
{ "Vault of the Wardens", "Das Verlies der Wächterinnen", "Cámara de las Celadoras", "Bóveda de las Celadoras", "Caveau des Gardiennes", "Segrete delle Custodi", "감시관의 금고", "Câmara das Guardiãs", "Казематы Стражей", "守望者地窟", "看守者鐵獄", }, 
},
["509"] = {
{ "Launch the Attack", "Zum Angriff blasen", "Inicia el ataque", "Lanza el ataque", "Lancer l’attaque", "Avvia l'attacco", "공격 개시", "Inicie o ataque", "В атаку", "开始攻击", "開始攻擊", }, 
{ "Regroup at the Bend", "An der Kurve treffen", "Reagruparse en la curva", "Reagruparse en la curva", "Regroupement au tournant", "Radunata presso la svolta", "재집결", "Reagrupar-se na Curva", "Перегруппировка за поворотом", "弯道集合", "在彎路重整", }, 
{ "Defeat the Packmaster", "Besiegt den Rottenkommandanten", "Derrota al maestro de manada", "Derrota al Maestro de la manada", "Vaincre le maître de la meute", "Sconfiggi il Mastrobranco", "무리지도자 처치", "Derrote o Líder da Alcateia", "Победите властителя стаи", "击败兽王", "擊敗狼王", }, 
{ "Survive the Gauntlet", "Spießrutenlauf", "Sobrevive al ataque", "Sobrevive al ataque", "Survivre au Défi", "Sopravvivi alla sfida", "시련", "Sobreviva à Forquilha", "Выживите на Улице Испытаний", "挡住敌人的夹击", "一線生機", }, 
{ "Slay Durn the Hungerer", "Tötet Durn den Nimmersatten", "Mata a Durn el Hambriento", "Mata a Durn el Hambriento.", "Vaincre Durn l’Affameur", "Uccidi Durn il Famelico", "굶주린 두른 처치", "Mate Durn, o Famélico", "Убейте Дарна Ненасытного", "击败饥饿者杜恩", "殺死『飢餓者』唐恩", }, 
{ "The Final Gates", "Die letzten Tore", "Las puertas finales", "La puerta final", "Les portes du trône", "I cancelli finali", "마지막 관문", "Os Portões Finais", "Последние врата", "最后关头", "最後的大門", }, 
{ "Confront Warlord Garrosh Hellscream", "Konfrontiert Kriegsherr Garrosh Höllschrei", "Enfréntate al señor de la guerra Garrosh Grito Infernal", "Confronta al Señor de la Guerra Garrosh Grito Infernal.", "Affronter le seigneur de guerre Garrosh Hurlenfer", "Affronta il Signore della Guerra Garrosh Malogrido", "전쟁군주 가로쉬 헬스크림과 대면", "Confronte o Senhor da Guerra Garrosh Grito Infernal", "Сразитесь с вождем Гаррошем Адским Криком", "对抗督军加尔鲁什·地狱咆哮", "迎戰卡爾洛斯‧地獄吼酋長", }, 
},
["201"] = {
{ "The Flight Master", "Die Flugmeisterin", "El maestro de vuelo", "El maestro de vuelo", "Le maître de vol", "Il Maestro di Volo", "비행 조련사", "O Mestre de Voo", "Распорядитель полетов", "飞行管理员", "飛行管理員", }, 
{ "A.C.E.s High", "Spaß mit A.S.S.", "El fuego de la venganza", "El fuego de la venganza", "Un as dans la manche", "Assalto dal cielo", "훌륭한 전투", "Uma Prova de Fogo", "А.С. на высоте", "A.C.E.空袭", "A.C.E.部隊來襲", }, 
{ "Reclaim the Court!", "Die Rückeroberung des Hofes!", "¡Reclama la corte!", "¡Reclama la corte!", "Reprenez la cour !", "Riconquista la corte!", "요새를 되찾아라!", "Domine o Pátio!", "Возвращение контроля над двором", "夺回庭院！", "收復中庭!", }, 
{ "The Warlord", "Der Kriegsfürst", "El señor de la guerra", "El señor de la guerra", "Le seigneur de guerre", "Il Signore della Guerra", "장군", "O Senhor da Guerra", "Полководец", "督军", "督軍", }, 
{ "Legwork", "Lauferei", "Trabajo preliminar", "Trabajo preliminar", "Travail sur le terrain", "Raccolta informazioni", "탐문 조사", "Pernadas", "Беготня", "外勤工作", "跑腿", }, 
{ "Setting Up", "Vorbereitung", "Tanto monta, monta tanto", "Tanto monta, monta tanto", "Préparatifs", "Preparare le difese", "방어 준비", "Preparar Armas", "Установка", "装备中", "做好準備", }, 
{ "Hold the Line!", "Weicht nicht zurück!", "¡Mantén la formación!", "¡Mantén la formación!", "Tenir le front !", "Difendi la posizione!", "전선을 사수하라!", "Mantenham a Formação!", "Держать строй!", "坚守阵地！", "守住陣線!", }, 
},
["709"] = {
{ "The Everbloom", "Der Immergrüne Flor", "El Vergel Eterno", "El Sempibrote", "La Flore éternelle", "Verdeterno", "상록숲", "Floretérnia", "Вечное Цветение", "永茂林地", "永茂林", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["545"] = {
{ "Blackrock Caverns", "Die Schwarzfelshöhlen", "Cavernas Roca Negra", "Cavernas Roca Negra", "Cavernes de Rochenoire", "Caverne di Roccianera", "검은바위 동굴", "Caverna Rocha Negra", "Пещеры Черной горы", "黑石岩窟", "黑石洞穴", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["684"] = {
{ "Iron Docks", "Eisendocks", "Puerto de Hierro", "Muelles de Hierro", "Quais de Fer", "Darsena di Ferro", "강철 선착장", "Docas de Ferro", "Железные доки", "钢铁码头", "鋼鐵碼頭", }, 
},
["320"] = {
{ "Speak with Durotan", "Sprecht mit Durotan", "Habla con Durotan", "Habla con Durotan", "Parler à Durotan", "Parla con Durotan", "듀로탄과 대화", "Fale com Durotan", "Поговорите с Дуротаном.", "与杜隆坦的谈话", "和杜洛坦交談。", }, 
{ "Get to the Machinehouse", "Erreicht das Maschinenhaus", "Ve a la Casamáquina", "Ve a la casa de máquinas", "À la machinerie", "Raggiungi l'Officina Bellica", "기계작업장", "Vá para a Casa de Máquinas", "Добраться до машинного зала", "前往机房", "前往機械室", }, 
{ "Goraluk Anvilcrack", "Goraluk Hammerbruch", "Goraluk Yunquegrieta", "Goraluk Yunquegrieta", "Goraluk Brisenclume", "Goraluk Spaccaroccia", "고랄루크 앤빌크랙", "Goraluk Rachadastra", "Горалук Треснувшая Наковальня", "古拉鲁克", "古拉魯克", }, 
{ "Get to Supply Depot", "Erreicht das Vorratslager", "Ve al depósito de suministros", "Ve al depósito de suministros", "Au dépôt", "Raggiungi il Deposito Rifornimenti", "보급고", "Vá para o Depósito de Suprimentos", "Добраться до склада", "前往补给站", "前往補給站", }, 
{ "Survive Iron Horde Onslaught", "Überlebt den Ansturm der Eisernen Horde", "Sobrevive a la masacre de la Horda de Hierro", "Sobrevive al embate de la Horda de Hierro", "Survivre à l’attaque de la Horde de Fer", "Sopravvivi all'attacco dell'Orda di Ferro", "강철 호드의 맹공격 견디기", "Sobreviva ao Massacre da Horda de Ferro", "Пережить атаку Железной Орды", "中流砥柱", "在鋼鐵部落的突襲中存活", }, 
{ "Get to Central Dock", "Erreicht den zentralen Kai", "Llega al muelle central", "Ve al muelle central", "Atteindre le quai central", "Raggiungi il Molo Centrale", "중앙 부두", "Vá à Doca Central", "Добраться до центрального дока", "前往中央码头区", "前往中央碼頭", }, 
{ "Get on the Barge", "Gelangt an Bord", "Sube a la barcaza", "Sube a la barcaza", "Monter à bord de la péniche", "Abborda la Chiatta", "승선", "Entre na Barcaça.", "Попасть на баркас", "登上舰艇", "登上駁船。", }, 
{ "Destroy the Wavemurder Barge", "Zerstört die 'Wellenmord'", "Destruye la barcaza Mataolas", "Destruye la barcaza Mataolas", "Détruire la péniche Crime-des-Flots", "Distruggi la Chiatta Tsunami", "물결궂힘 화물선 파괴", "Destrua a Barcaça Mata-onda", "Уничтожить разбивающий волны баркас", "摧毁镇潮号舰艇", "摧毀弒浪者駁船", }, 
},
["620"] = {
{ "The Arcatraz", "Die Arkatraz", "El Arcatraz", "El Arcatraz", "L’Arcatraz", "Arcatraz", "알카트라즈", "Arcatraz", "Аркатрац", "禁魔监狱", "亞克崔茲", }, 
},
["1307"] = {
{ "The Lords of Wind", "Die Herren des Windes", "Los Señores del Viento", "Los Señores del viento", "Les seigneurs du Vent", "I Signori del Vento", "바람의 군주들", "Os senhores do vento", "Повелители ветров", "风之领主", "御風領主", }, 
{ "The Skylord Returns", "Die Rückkehr des Himmelsfürsten", "El regreso del Señor del Cielo", "El regreso del Señor del cielo", "Le retour du seigneur du ciel", "Il ritorno del Signore dei Cieli", "하늘군주의 귀환", "O Senhor Celeste retorna", "Возвращение повелителя небес", "啸天者归来", "天空領主歸位", }, 
},
["901"] = {
{ "The Call of the North", "Der Ruf des Nordens", "La llamada del norte", "El llamado del Norte", "L’appel du Nord", "Il richiamo del nord", "노스렌드의 부름", "O chamado do Norte", "Зов Севера", "北地的召唤", "北地的呼喚", }, 
{ "The Gates Are Open", "Die Tore sind offen", "Las puertas están abiertas", "Las puertas están abiertas", "Opération portes ouvertes", "Le porte sono aperte", "활짝 열린 관문", "Os portões estão abertos", "Врата открыты", "敞开的大门", "門已開啟", }, 
{ "Seek the Fragments", "Sucht die Fragmente", "Buscar los fragmentos", "Busca los fragmentos", "Chercher les fragments", "Cercare i frammenti", "조각 모으기", "Procure os fragmentos", "В поисках обломков", "寻找碎片", "尋找碎片", }, 
{ "Travel to the Frozen Throne", "Reist zum Frostthron", "Viajar al Trono Helado", "Viaja al Trono Congelado", "Voyage vers le Trône de glace", "Raggiungere il Trono di Ghiaccio", "얼어붙은 왕좌로", "Vá até o Trono de Gelo", "Подъем к Ледяному Трону", "前往冰封王座", "前往冰封王座", }, 
{ "Power Overwhelming", "Die Macht ist überwältigend", "Poder sobrecogedor", "Sobredosis de poder", "Puissance accablante", "Potere travolgente", "압도적인 힘", "Poder esmagador", "Переполняющая мощь", "无上之力", "壓倒性的力量", }, 
{ "The Purge", "Die Reinigung", "La purga", "La Purga", "La purge", "La purificazione", "정화", "O expurgo", "Очищение", "净化", "淨化", }, 
{ "The Hungering Cold", "Die zehrende Kälte", "El frío voraz", "El frío voraz", "Le Froid dévorant", "Freddo penetrante", "갈망의 한기", "O frio voraz", "Алчущий холод", "饥饿之寒", "飢寒之力", }, 
{ "Death's March", "Tödlicher Marsch", "La marcha de la muerte", "La Marcha de la muerte", "Marche funèbre", "La marcia della morte", "죽음의 행진", "Marcha da morte", "Марш смерти", "死亡远征", "亡靈進軍", }, 
{ "You Have Your Orders", "Ihr habt Eure Befehle", "Tienes tus órdenes", "Tienes tus órdenes", "Vous connaissez les ordres", "Hai i tuoi ordini", "명령을 수행하라", "Você já tem as ordens", "Приказ есть приказ", "听命行事", "你聽到命令了", }, 
},
["1092"] = {
{ "The Empty Camp", "Das leere Lager", "El campamento vacío", "El campamento vacío", "Le campement désert", "Accampamento abbandonato", "버려진 야영지", "O acampamento vazio", "Опустевший лагерь", "空营", "空蕩蕩的營地", }, 
{ "Clearing the Way", "Den Weg frei machen", "Despejando el camino", "Despejando el camino", "Faire place nette", "Ripulire la strada", "길 뚫기", "Abrindo caminho", "Расчистка пути", "清除路障", "清除障礙", }, 
{ "Keeper's Rest", "Die Rast des Hüters", "Reposo del Vigilante", "Reposo del Vigilante", "Le repos du Vigilant", "Riposo del Guardiano", "수호자의 안식처", "Pouso do Guardião", "Последнее пристанище Хранителя", "守护者之眠", "守護者之憩", }, 
{ "The Broken Ritual", "Das Ritual der Zerschlagenen", "El ritual destrozado", "El ritual roto", "Le rituel interrompu", "Rituale infranto", "중단된 의식", "O ritual partido", "Прерванный ритуал", "失败的仪式", "破碎的儀式", }, 
{ "Into the Dark", "In das Dunkel", "Hacia la oscuridad", "En la oscuridad", "Dans les ténèbres", "Nelle tenebre", "어둠 속으로", "Treva adentro", "Спуск во тьму", "在黑暗中", "進入黑暗", }, 
{ "The Maw of the Beast", "Der Schlund der Bestie", "Las fauces de la bestia", "Las fauces de la bestia", "La gueule de la bête", "Il morso della bestia", "괴수의 아귀", "A gorja da fera", "Пасть чудовища", "野兽之喉", "勇闖虎穴", }, 
{ "Escaping the Prison", "Gefängnisflucht", "Escapar de la prisión", "Huida de la prisión", "Sortir de la prison", "Fuga dalla prigione", "감옥 탈출", "Fuga da prisão", "Побег из темницы", "脱狱", "逃出監牢", }, 
{ "Aid to the Fallen", "Hilfe für die Gefallenen", "Ayuda para los caídos", "Ayuda para los caídos", "Aider les blessés", "Aiuto ai caduti", "성기사 구제", "Ajuda aos caídos", "Помощь павшим", "援助掉队者", "救人要緊", }, 
{ "Something is Coming", "Etwas nähert sich", "Algo se acerca", "Algo se acerca", "Quelque chose approche", "Qualcosa è in arrivo", "사악한 존재의 엄습", "Tem alguma coisa chegando", "Что-то грядет...", "它来了", "有什麼東西過來了", }, 
{ "Ritual Defense", "Ritualverteidigung", "La defensa del ritual", "La defensa del ritual", "Défense de rituel", "Difesa del rituale", "의식 방어", "Defesa do ritual", "Безопасность ритуала", "仪式保卫", "儀式攻防", }, 
{ "The Silver Hand", "Die Silberne Hand", "La Mano de Plata", "La Mano de Plata", "La Main-d’Argent", "Mano d'Argento", "은빛 손", "O Punho de Prata", "Серебряная Длань", "白银之手", "白銀之手", }, 
},
["907"] = {
{ "Defend the Crossroads", "Verteidigt das Wegekreuz", "Defiende El Cruce", "Defiende el Cruce", "Défendre la Croisée", "Difendere il Crocevia", "십자로 방어", "Defenda a Encruzilhada", "Оборона Перекрестка", "保卫十字路口", "守禦十字路口", }, 
{ "Defeat the Demon Commander", "Bezwingt den Dämonenkommandanten", "Derrota al comandante demoníaco", "Derrota al Comandante demoníaco", "Terrasser le commandant démon", "Sconfiggere il comandante demoniaco", "악마 사령관 처치", "Derrotar o Demônio Comandante", "Победа над командиром демонов", "击败恶魔指挥官", "擊敗惡魔指揮官", }, 
{ "Repel the Legion Forces", "Schlagt die Streitkräfte der Legion zurück", "Rechaza a los ejércitos de la Legión", "Repele a las fuerzas de la Legión", "Repousser les troupes de la Légion", "Respingere le forze della Legione", "군단 격퇴", "Rechace as forças da Legião", "Отражение натиска Легиона", "击退军团部队", "擊退燃燒軍團", }, 
{ "Defeat the Demon Lord", "Bezwingt den Dämonenfürsten", "Derrota al señor demoníaco", "Derrota al Señor demoníaco", "Terrasser le seigneur démon", "Sconfiggere il Signore dei Demoni", "악마 군주 처치", "Derrote o Lorde Demônio", "Смерть повелителю демонов", "击败恶魔领主", "擊敗惡魔領主", }, 
},
["611"] = {
{ "The Black Morass", "Der Schwarze Morast", "La Ciénaga Negra", "La Ciénaga Negra", "Le Noir marécage", "Palude Nera", "검은늪", "Lamaçal Negro", "Черные топи", "黑色沼泽", "黑色沼澤", }, 
},
["677"] = {
{ "Grand Champions", "Großchampions", "Grandes Campeones", "Grandes Campeones", "Grands champions", "Gran Campioni", "최고 용사", "Grandes campeões", "Абсолютные чемпионы", "总冠军", "大勇士", }, 
{ "Argent Trial", "Argentumprüfung", "Prueba Argenta", "Prueba argenta", "Épreuve d’argent", "Prova d'Argento", "은빛십자군의 시험", "Torneio Argênteo", "Испытание Серебряного авангарда", "银色试炼", "銀白試煉", }, 
{ "The Black Knight", "Der schwarze Ritter", "El Caballero Negro", "El Caballero Negro", "Le Chevalier noir", "Cavaliere Nero", "흑기사", "O Cavaleiro Negro", "Черный рыцарь", "黑骑士", "黑騎士", }, 
},
["1066"] = {
{ "Big Help", "Große Hilfe", "Gran ayuda", "Gran ayuda", "Un appui de taille", "Un grande aiuto", "생명의 은인", "Grande ajuda", "Большой помощник", "大救星", "莫大的幫助", }, 
{ "Rescue Wavespeaker Adelee", "Rettet Wellensprecherin Adelee", "Rescatar a la hablaolas Adelee", "Rescata a Hablaolas Adelee", "Secourir la parle-vague Adelee", "Salvare la Parlaonde Adelee", "파도예언자 아델리 구출", "Resgate a Falaondas Adelee", "Спасение говорящей с волнами Адель", "解救波涛语者安德莉", "拯救語濤者愛德麗", }, 
{ "Secure the Central Junction", "Sichert die zentrale Kreuzung", "Asegurar el cruce central", "Asegura la Intersección central", "Prendre le contrôle du croisement central", "Controllo del bivio centrale", "중앙 교차로 확보", "Conquiste a Junção Central", "Центральное пересечение", "清理中央路口", "占領中央匯合點", }, 
{ "Water Gauntlet", "Der Wasserspießrutenlauf", "Reto de agua", "Guantelete de agua", "La fureur des flots", "La prova dell'acqua", "파도의 시련", "Provação aquática", "Испытание водой", "水护手", "激流障壁", }, 
{ "Destroy the Sea Witch", "Vernichtet die Seehexe", "Acaba con la bruja del mar", "Destruye a la Bruja del mar", "Anéantir la sorcière des mers", "Distruggere la Strega di Mare", "바다 마녀 처치", "Destruam a Bruxa do Mar", "Смерть морской ведьмы", "消灭海巫", "消滅海巫", }, 
{ "Acquire Sharas'dal", "Bringt Sharas'dal in Euren Besitz", "Hazte con Sharas'dal", "Obtén Sharas'dal", "Obtenir Sharas’dal", "Ottenere Sharas'dal", "샤라스달 획득", "Obter Sharas'dal", "Завладеть Шарас'далом", "获得莎拉达尔", "取得薩拉達爾", }, 
},
["1189"] = {
{ "The Broken Shore", "Die Verheerte Küste", "Costa Abrupta", "La Costa Quebrada", "Rivage Brisé", "Riva Dispersa", "부서진 해변", "A Costa Partida", "Расколотый берег", "破碎海滩", "破碎海岸", }, 
{ "Storm The Beach", "Erstürmt den Strand", "Asalta la playa", "Asalta la playa", "Le grand débarquement", "Assalto alla spiaggia", "해변 청소", "Tomar a praia", "Штурм побережья", "抢滩登陆", "興師海灘", }, 
{ "Defeat the Commander", "Bezwingt den Kommandanten", "Derrota al comandante", "Derrota al Comandante", "Terrasser le commandant", "Sconfiggere il comandante", "사령관 처치", "Derrotar o Comandante", "Убить командира", "击败指挥官", "擊敗指揮官", }, 
{ "Find The Others", "Die anderen finden", "Encuentra a los otros", "Encuentra a los demás", "Trouver les autres", "Trova gli altri", "다른 이 찾기", "Encontrar os outros", "Найти остальных", "找到其他人", "找到其他人", }, 
{ "Destroy the Portal", "Vernichtet das Portal", "Destruye el portal", "Destruye el portal", "Destruction du portail", "Distruggere il portale", "차원문 파괴", "Destruir o portal", "Разрушение портала", "摧毁传送门", "摧毀傳送門", }, 
{ "Raze the Black City", "Legt die Schwarze Stadt in Schutt und Asche", "Arrasar la Ciudad Negra", "Arrasa la Ciudad Negra", "Le sac de la ville Noire", "Assalto alla Città Oscura", "검은 도시 공격", "Arrasar a Cidade Negra", "Предайте огню Черный город", "扫荡黑色之城", "夷平黑城", }, 
{ "The Highlord", "Der Hochlord", "El Alto Señor", "El Alto Señor", "Le généralissime", "Il Gran Signore", "대영주", "O grão-lorde", "Верховный лорд", "大领主", "大領主", }, 
{ "Krosus", "Krosus", "Krosus", "Krosus", "Krosus", "Krosus", "크로서스", "Krosus", "Крос", "克洛苏斯", "克羅索斯", }, 
{ "Hold The Ridge", "Haltet den Grat", "Defiende la cresta", "Mantener la cresta", "Tenir la crête", "Difendi la cresta", "마루 방어", "Defenda o cume", "Удержать высоту", "死守山脊", "守住山脊", }, 
},
["977"] = {
{ "Darkheart Thicket", "Das Finsterherzdickicht", "Arboleda Corazón Oscuro", "Matorral Corazón Oscuro", "Fourré Sombrecœur", "Boschetto Cuortetro", "어둠심장 숲", "Bosque Corenegro", "Чаща Темного Сердца", "黑心林地", "暗心灌木林", }, 
},
["619"] = {
{ "The Steamvault", "Dampfkammer", "La Cámara de Vapor", "La Cámara de Vapor", "Le caveau de la Vapeur", "Antro dei Vapori", "증기 저장고", "Câmara dos Vapores", "Паровое подземелье", "蒸汽地窟", "蒸汽洞窟", }, 
},
["900"] = {
{ "Stalking Your Prey", "Der Beute auf der Spur", "Acechar a tu presa", "Acechar tu presa", "Traquer votre proie", "Inseguire la preda", "먹이 추적", "No rastro da presa", "Преследование жертвы", "追踪你的猎物", "跟蹤獵物", }, 
{ "They Are Not Prepared", "Sie wissen nicht, was sie erwartet", "No están preparados", "No están preparados", "Ils ne sont pas prêts", "Loro non sono pronti", "아직 준비가 안 된 자들", "Eles não estão preparados", "Они не готовы", "他们这是自寻死路", "他們還沒準備好", }, 
{ "Wrath of the Illidari", "Zorn der Illidari", "Cólera de los Illidari", "Ira de los Illidari", "La colère des Illidari", "L'ira degli Illidari", "일리다리의 분노", "Ira dos Illidari", "Гнев иллидари", "伊利达雷之怒", "伊利達瑞之怒", }, 
{ "Unleashed Havoc", "Entfesselte Verwüstung", "Estragos desatados", "Las Espadas Gemelas del Falsario", "Dévastation déchaînée", "Caos scatenato", "샘솟는 파멸", "Devastação desenfreada", "Полное истребление", "释放的浩劫", "災虐降臨", }, 
{ "The Twinblades of the Deceiver", "Die Zwillingsklingen des Betrügers", "Las Hojas Gemelas del Impostor", "Las Espadas Gemelas del Falsario", "Les lames jumelles du Trompeur", "Le Lame Gemelle dell'Ingannatore", "기만자의 쌍날검", "As Lâminas Gêmeas do Enganador", "Парные клинки Искусителя", "欺诈者的双刃", "欺詐者雙刃", }, 
},
["576"] = {
{ "The Oculus", "Das Oculus", "El Oculus", "El Oculus", "L’Oculus", "Oculus", "마력의 눈", "Óculus", "Окулус", "魔环", "奧核之眼", }, 
},
["294"] = {
{ "Razorfen Kraul", "Kral der Klingenhauer", "Horado Rajacieno", "Horado Rajacieno", "Kraal de Tranchebauge", "Gallerie di Lamaspina", "가시덩굴 우리", "Urzal dos Tuscos", "Лабиринты Иглошкурых", "剃刀沼泽", "剃刀沼澤", }, 
},
["1065"] = {
{ "The Azure Prisoner", "Der Azurgefangene", "El prisionero azur", "El Prisionero Azur", "Le prisonnier d’Azur", "Il prigioniero azzurro", "하늘빛 포로", "O prisioneiro lazúli", "Лазурный пленник", "碧蓝囚徒", "藍龍俘虜", }, 
{ "Seeking Answers", "Antworten suchen", "Buscando respuestas", "Buscando respuestas", "Chercher des réponses", "In cerca di risposte", "답 구하기", "Em busca de respostas", "В поисках ответов", "寻找答案", "找尋解答", }, 
{ "Cleansed by Holy Fire", "Von heiligem Feuer geläutert", "Purificado con Fuego Sagrado", "Limpiado por el Fuego Sagrado", "Purification par les flammes sacrées", "Purificato dal Fuoco Sacro", "신성한 불꽃의 정화", "Purgado por Fogo Sagrado", "Очищение священным огнем", "圣火的净化", "聖火淨化", }, 
{ "The Way Out is Through", "Da müsst Ihr durch", "La salida es a través", "Para salir hay que atravesar", "La seule issue", "L'uscita è attraverso", "나가는 유일한 방법은...", "A saída é pelo meio", "Единственный путь – вперед", "道路通畅", "穿過去是唯一的路", }, 
{ "Consumed by Void", "Von Leere verschlungen", "Consumido por el vacío", "Consumido por el Vacío", "Consumé par le Vide", "Consumato dal Vuoto", "공허의 흡수", "Consumidos pelo caos", "Поглощение Бездной", "虚空吞噬", "被虛無吞噬", }, 
{ "A Will of Fire", "Ein feuriger Wille", "Una voluntad de fuego", "Una voluntad de fuego", "Volonté de feu", "Una volontà di fuoco", "화염의 의지", "Vontade de fogo", "Воля огня", "圣火的意志", "烈焰意志", }, 
{ "To Wield the Flame", "Die Flamme führen", "Blandir la llama", "Blandir la llama", "Flamme en main", "Impugnare la fiamma", "불꽃 휘두르기", "O brandir da chama", "Огонь в руках", "玩火者", "操弄烈焰", }, 
},
["908"] = {
{ "Show Faction Specific Criteria", "Fraktionsspezifische Kriterien anzeigen", "Mostrar los criterios específicos de la facción", "Mostrar los criterios específicos de las facciones", "Montrer les critères spécifiques de faction", "Show Faction Specific Criteria", "진영 구체적인 조건 보이기", "Mostrar critérios por facção", "Показать критерии фракций", "显示阵营指定条件", "Show Faction Specific Criteria", }, 
{ "A Final Step", "Ein letzter Schritt", "Un último paso", "El último paso", "Dernière étape", "L'ultimo passo", "마지막 단계", "Um último passo", "Последний шаг", "最后一步", "最後一步", }, 
},
["1061"] = {
{ "The Legion's Devastation", "Das Wüten der Legion", "La devastación de la Legión", "La Devastación de la Legión", "Les ravages de la Légion", "Devastazione della Legione", "군단의 만행", "A devastação da Legião", "Опустошение Легиона", "军团的袭击", "燃燒軍團的破壞", }, 
{ "Saving the Injured", "Rettung der Verletzten", "Salvar a los heridos", "Salva a los Heridos", "Sauver les blessés", "Salvare i feriti", "부상자 구하기", "Resgate dos feridos", "Спасение раненых", "救治伤员", "拯救傷者", }, 
{ "The Renewal Begins", "Die Erneuerung beginnt", "Empieza la renovación", "La Renovación comienza", "Prélude au renouveau", "La purificazione ha inizio", "소생의 시작", "A renovação começa", "Начало возрождения", "重获新生", "淨化開始", }, 
{ "Cleansing the Corruption", "Läutern der Verderbnis", "Limpiar la corrupción", "Purificar la corrupción", "Halte à la corruption", "Purificare la corruzione", "타락 정화", "Purificar a corrupção", "Очищение от порчи", "清除腐化", "清除腐化", }, 
{ "The Moment of Truth", "Der Moment der Wahrheit", "La hora de la verdad", "El Momento de la verdad", "L’instant de vérité", "Il momento della verità", "진실의 시간", "A hora da verdade", "Момент истины", "真理时刻", "關鍵的一刻", }, 
{ "G'Hanir Reborn", "G'Hanirs Wiedergeburt", "G'Hanir renacido", "G'Hanir renacido", "G’Hanir réincarné", "G'hanir risorto", "부활한 그하니르", "G'hanir renascida", "Перерожденный Г'ханир", "加尼尔重生", "格哈尼爾重生", }, 
{ "Nature's Wrath", "Zorn der Natur", "Cólera de la Naturaleza", "Ira de la Naturaleza", "Courroux de la nature", "Ira Naturale", "자연의 격노", "Fúria da natureza", "Ярость природы", "自然之怒", "自然之怒", }, 
},
["612"] = {
{ "The Botanica", "Die Botanika", "El Invernáculo", "El Invernáculo", "La Botanica", "Botanica", "신록의 정원", "Jardim Botânico", "Ботаника", "生态船", "波塔尼卡", }, 
},
["1068"] = {
{ "Making Introductions", "Vorstellungsrunde", "Hacer las presentaciones", "Empezando a conocerse", "Présentations", "Presentazioni", "친구 소개", "Apresentações", "Знакомство", "介绍一下", "彼此介紹", }, 
{ "Tomb Raider", "Die Gruft ruft!", "Asaltatumbas", "Cazador de tumbas", "Pilleur de tombes", "Incursione nelle tombe", "무덤 탐험가", "Saqueadores de tumbas", "Расхитители гробниц", "古墓丽影", "古墓奇兵", }, 
{ "Volund's Hoard", "Volunds Beutekammer", "Tesoro de Volund", "Reserva de Volund", "Le trésor de Volund", "Il tesoro di Volund", "볼룬드의 저장고", "O tesouro de Volund", "Сокровищница Волунда", "沃伦德的宝库", "沃隆德的寶庫", }, 
{ "Every Nook and Cranny", "Jede Nische und Ritze", "Hasta el último rincón", "Cada esquina y rincón", "Fouille en règle", "Cerca in ogni angolo", "구석구석 샅샅이", "Cada cantinho", "Перевернуть все вверх дном", "翻箱倒柜", "翻遍每一個角落", }, 
{ "Volund's Last Stand", "Volunds letztes Gefecht", "La última batalla de Volund", "El último ataque de Volund", "Le baroud de Volund", "L'ultima difesa di Volund", "볼룬드의 최후의 저항", "A resistência final de Volund", "Последний бой Волунда", "沃伦德的最后一战", "沃隆德的最後一搏", }, 
{ "Answering the Call", "Dem Ruf folgen", "Responder a la llamada", "Respondiendo al llamado", "Répondre à l’appel", "Rispondere alla chiamata", "기계노움의 부름", "Atendendo ao chamado", "Новый зов", "响应召唤", "回應呼喚", }, 
},
["508"] = {
{ "Launch the Attack", "Zum Angriff blasen", "Inicia el ataque", "Lanza el ataque", "Lancer l’attaque", "Avvia l'attacco", "공격 개시", "Inicie o ataque", "В атаку", "开始攻击", "開始攻擊", }, 
{ "Gather at the Bend", "An der Kurve sammeln", "Reunión en la curva", "Reunión en la curva", "Rassemblement au tournant", "Radunata presso la svolta", "재집결", "Reunir-se na Curva", "Сбор за поворотом", "弯道集合", "在彎路集結", }, 
{ "Defeat the Packmaster", "Besiegt den Rottenkommandanten", "Derrota al maestro de manada", "Derrota al Maestro de la manada", "Vaincre le maître de la meute", "Sconfiggi il Mastrobranco", "무리지도자 처치", "Derrote o Líder da Alcateia", "Победите властителя стаи", "击败兽王", "擊敗狼王", }, 
{ "Survive the Gauntlet", "Spießrutenlauf", "Sobrevive al ataque", "Sobrevive al ataque", "Survivre au Défi", "Sopravvivi alla sfida", "시련", "Sobreviva à Forquilha", "Выживите на Улице Испытаний", "挡住敌人的夹击", "一線生機", }, 
{ "Slay Durn the Hungerer", "Tötet Durn den Nimmersatten", "Mata a Durn el Hambriento", "Mata a Durn el Hambriento.", "Vaincre Durn l’Affameur", "Uccidi Durn il Famelico", "굶주린 두른 처치", "Mate Durn, o Famélico", "Убейте Дарна Ненасытного", "击败饥饿者杜恩", "殺死『飢餓者』唐恩", }, 
{ "The Final Gates", "Die letzten Tore", "Las puertas finales", "La puerta final", "Les portes du trône", "I cancelli finali", "마지막 관문", "Os Portões Finais", "Последние врата", "最后关头", "最後的大門", }, 
{ "Confront Warlord Garrosh Hellscream", "Konfrontiert Kriegsherr Garrosh Höllschrei", "Enfréntate al señor de la guerra Garrosh Grito Infernal", "Confronta al Señor de la Guerra Garrosh Grito Infernal.", "Affronter le seigneur de guerre Garrosh Hurlenfer", "Affronta il Signore della Guerra Garrosh Malogrido", "전쟁군주 가로쉬 헬스크림과 대면", "Confronte o Senhor da Guerra Garrosh Grito Infernal", "Сразитесь с вождем Гаррошем Адским Криком", "对抗督军加尔鲁什·地狱咆哮", "迎戰卡爾洛斯‧地獄吼酋長", }, 
},
["1051"] = {
{ "Court of Stars", "Der Hof der Sterne", "Corte de las Estrellas", "Corte de Estrellas", "Cour des Étoiles", "Corte delle Stelle", "별의 궁정", "Pátio das Estrelas", "Квартал Звезд", "群星庭院", "眾星之廷", }, 
},
["577"] = {
{ "Utgarde Pinnacle", "Turm Utgarde", "Pináculo de Utgarde", "Pináculo de Utgarde", "Cime d’Utgarde", "Pinnacolo di Utgarde", "우트가드 첨탑", "Pináculo Utgarde", "Вершина Утгард", "乌特加德之巅", "俄特加德之巔", }, 
},
["1308"] = {
{ "Upper Return to Karazhan", "Obere Rückkehr nach Karazhan", "Regreso a Karazhan superior", "Regreso superior a Karazhan", "Retour à Karazhan (sommet)", "Ritorno a Karazhan Superiore", "다시 찾은 카라잔 상층", "Retorno a Karazhan superior", "Возвращение в Каражан (верхняя часть)", "重返卡拉赞（上层）", "重返卡拉贊上層", }, 
},
["795"] = {
{ "Wait For Players", "Wartet auf Spieler", "Esperar a jugadores", "Espera a los jugadores", "En attente de joueurs", "Attendi gli altri giocatori", "플레이어 기다리기", "Aguarde jogadores", "Ожидание игроков", "等待玩家", "等待救援*", }, 
{ "Tides of Glory", "Die Wellen des Ruhms", "Mareas de Gloria", "Mareas de gloria", "Les marées de la gloire", "Maree della gloria", "영광의 해일", "Mares da glória", "Волны Славы", "荣光滔滔", "榮耀之潮", }, 
{ "The Tidestone's Call", "Der Ruf des Gezeitensteins", "La llamada de la Piedramar", "La llamada de la Maretista", "L’appel de la Pierre-des-Marées", "Chiamata della Pietra delle Maree", "해일석의 부름", "O chamado da Pedramar", "Зов Приливного камня", "潮汐之石的召唤", "潮石的呼喚", }, 
{ "The Siegebreakers", "Die Belagerungsbrecher", "Los rompedores de asedio", "Los Rompedores de Asedio", "Les brise-siège", "Gli Spezzassedi", "공성파괴자", "Os quebra-cercos", "Стеноломы", "破城者", "突圍者", }, 
{ "Feeding on the Tidestone", "Zehren vom Gezeitenstein", "Alimentarse de la Piedramar", "Alimentándose de la Maretista", "Déprédateurs de la Pierre-des-Marées", "Consumare la Pietra delle Maree", "해일석의 힘 흡수", "Predadores da Pedramar", "Истощение Приливного камня", "吸取潮汐之石", "吸取潮石之力", }, 
{ "The Hunger", "Der Hunger", "El hambre", "El ansia", "La faim", "La fame", "굶주림", "A fome", "Голод", "饥渴", "極度飢餓", }, 
{ "As Two-Faced As They Come", "Hinterhältiger geht's nicht", "Falsos como ellos solos", "Se acercan los hipócritas", "Le gueux aux deux visages", "Due facce della stessa medaglia", "두 얼굴의 자들", "Mais duas caras, impossível", "Двуличнее не бывает", "两面三刀的下场", "全是表裡不一的傢伙", }, 
},
["1038"] = {
{ "A Ring Unbroken", "Ein ungebrochener Ring", "Un anillo intacto", "Un anillo intacto", "Un cercle toujours vaillant", "Il circolo intatto", "부서지지 않은 고리", "Um círculo intacto", "Несломленные Служители", "不屈之环", "重建陶土議會", }, 
{ "We Glorious Few", "Eine glorreiche Handvoll", "Unos pocos gloriosos", "Un puñado de gloria", "Les derniers braves", "Pochi ma buoni", "얼마 남지 않은 영광의 주인공들", "Nós, os gloriosos", "Горстка героев", "光荣的坚持", "光榮的倖存者", }, 
{ "Melee at the Maelstrom", "Kampf am Mahlstrom", "Cuerpo a cuerpo en La Vorágine", "Pelea en La Vorágine", "Du rififi au Maelström", "Scontro nel Maelstrom", "혼돈의 소용돌이에서의 난전", "Refrega na voragem", "Разборки у Водоворота", "大漩涡的战斗", "混戰大漩渦", }, 
{ "Felling the Felbat", "Teufelsfledermaustöten", "Derribar al murciélago vil", "Derribando al murciélago vil", "Abattre le gangroptère", "Eliminazione del vilpipistrello", "지옥박쥐의 추락", "A queda do morcevil", "Сбейте сквернотопыря", "击落魔蝠", "擊落魔化蝙蝠", }, 
{ "Master of Storms", "Meister der Stürme", "Maestro de las tormentas", "Maestro de las tormentas", "Maître des tempêtes", "Signore della Tempesta", "폭풍의 주인", "Mestre das Tempestades", "Повелитель грозы", "风暴主宰", "風暴主宰", }, 
},
["995"] = {
{ "Maw of Souls", "Der Seelenschlund", "Fauce de Almas", "Fauces de almas", "Gueule des âmes", "Fauci delle Anime", "영혼의 아귀", "Gorja das Almas", "Утроба душ", "噬魂之喉", "靈魂之喉", }, 
},
["211"] = {
{ "Speak with Wrathion", "Sprecht mit Furorion", "Habla con Wrathion", "Habla con Wrathion", "Parler à Irion", "Parla con Irathion", "래시온과 대화", "Falar com Wrathion", "Поговорить с Гневионом", "与拉希奥交谈", "與怒西昂交談", }, 
{ "Forged from Trillium", "Aus Trillium geschmiedet", "Forjado con trillium", "Forjado con trillium", "Forgé dans le trillium", "Forgiato con il trillio", "트릴리움으로 만들어진", "Forjado em Trílio", "Выковано из триллия", "锻造延极矿", "由延齡石打造而成", }, 
{ "Charging Up", "Aufladen", "Cargando", "Cargando", "Charge en cours", "Attivazione", "충전", "Carregando", "Зарядка", "充能中", "充能中", }, 
{ "Into the Forge", "Ab in die Schmiede", "En las forjas", "En las forjas", "Dans la forge", "Nella forgia", "제련소 안으로 이동", "Para dentro da forja", "В кузню", "深入熔炉", "進入熔爐", }, 
{ "Corruption Detected", "Korruption entdeckt", "Corrupción detectada", "Corrupción detectada", "Corruption détectée", "Corruzione rilevata", "오염물 발견!", "Corrupção detectada", "Обнаружена скверна", "发现腐化物", "偵測到腐化", }, 
{ "Manifested Corruption", "Manifestation der Verderbnis", "Manifestación de la corrupción", "Manifestación de la corrupción", "Corruption manifeste", "Manifestazione della corruzione", "드러난 오염물", "Corrupção manifesta", "Проявление осквернения", "腐化的具象", "腐化現身", }, 
},
["1257"] = {
{ "Neltharion's Lair", "Neltharions Hort", "Guarida de Neltharion", "Guarida de Neltharion", "Repaire de Neltharion", "Antro di Neltharion", "넬타리온의 둥지", "Covil de Neltharion", "Логово Нелтариона", "奈萨里奥的巢穴", "奈薩里奧巢穴", }, 
},
["594"] = {
{ "Azjol-Nerub", "Azjol-Nerub", "Azjol-Nerub", "Azjol-Nerub", "Azjol-Nérub", "Azjol-Nerub", "아졸네룹", "Azjol-Nerub", "Азжол-Неруб", "艾卓-尼鲁布", "阿茲歐-奈幽", }, 
},
["570"] = {
{ "The Hour of Twilight", "Die Stunde des Zwielichts", "La Hora del Crepúsculo", "La Hora del Crepúsculo", "L’Heure du Crépuscule", "L'Ora del Crepuscolo", "황혼의 시간", "A Hora do Crepúsculo", "Время Сумерек", "暮光审判", "暮光之時", }, 
},
["219"] = {
{ "Infiltration", "Infiltration", "Infiltración", "Infiltración", "Infiltration", "Infiltrazione", "침투", "Infiltração", "Проникновение", "渗透", "滲透", }, 
{ "Reconnaissance", "Erkundung", "Reconocimiento", "Reconocimiento", "Reconnaissance", "Ricognizione", "정찰", "Reconhecimento", "Разведка", "侦查", "偵察", }, 
{ "The Sealed Gate", "Das versiegelte Tor", "La puerta sellada", "La puerta sellada", "La porte scellée", "L'ingresso sigillato", "봉인된 관문", "O Portão Lacrado", "Запертые ворота", "封闭的大门", "上鎖的門", }, 
{ "Holdout", "Die Stellung halten", "Resistencia", "Resistencia", "Faire barrage", "Protezione", "저항", "Resistência", "Задержка", "坚持到底", "抵抗", }, 
{ "Bonus Objectives", "Bonusziele", "Objetivos de bonificación", "Objetivos de bonificación", "Objectifs bonus", "Obiettivi bonus", "추가 목표", "Objetivos bônus", "Дополнительные задачи", "奖励目标", "獎勵目標", }, 
},
["676"] = {
{ "Grand Champions", "Großchampions", "Grandes Campeones", "Grandes Campeones", "Grands champions", "Gran Campioni", "최고 용사", "Grandes Campeões", "Абсолютные чемпионы", "总冠军", "大勇士", }, 
{ "Argent Trial", "Argentumprüfung", "Prueba Argenta", "Prueba argenta", "Épreuve d’argent", "Prova d'Argento", "은빛십자군의 시험", "Torneio Argênteo", "Испытание Серебряного авангарда", "银色试炼", "銀白試煉", }, 
{ "The Black Knight", "Der schwarze Ritter", "El Caballero Negro", "El Caballero Negro", "Le Chevalier noir", "Cavaliere Nero", "흑기사", "O Cavaleiro Negro", "Черный рыцарь", "黑骑士", "黑騎士", }, 
},
["976"] = {
{ "Proving Your Worth", "Bewährungsprobe", "Demostrar tu valía", "Demuestra lo que vales", "Prouver votre valeur", "Provare il valore", "실력 증명", "Prova de valor", "Доказательство силы", "证明你的实力", "證明你的價值", }, 
{ "Defeat the Giantslayer", "Bezwingt den Riesentöter", "Derrota al Matagigantes", "Derrota al destripador de gigantes", "Vaincre le Tueur de géants", "Sconfiggere l'Ammazzagiganti", "거인학살자와의 승부", "Derrote o Matador de Gigantes", "Победа над Убийцей Великанов", "击败巨人屠夫。", "擊敗巨人殺手", }, 
{ "Heroes of the Storm", "Helden des Sturms", "Héroes de la tormenta", "Héroes de la tormenta", "Héros du Nexus", "Eroi della Tempesta", "폭풍의 영웅", "Heróis da tempestade", "Герои бури", "风暴英雄", "風暴英雄", }, 
{ "Weapons of the Storm", "Waffen des Sturms", "Armas de la tormenta", "Armas de la tormenta", "Les armes de la tempête", "Armi della Tempesta", "폭풍의 무기", "Armas da Tempestade", "Оружие бури", "风暴武器", "風暴神兵", }, 
{ "Demonic Interruption", "Dämonische Unterbrechung", "Interrupción demoníaca", "Interrupción demoníaca", "Interruption démoniaque", "Interruzione demoniaca", "사악한 방해", "Interrupção demoníaca", "Демоническое вмешательство", "恶魔的打扰", "惡魔之擾", }, 
},
["876"] = {
{ "Push Back the Legion Assault", "Schlagt den Angriff der Legion zurück", "Rechazar el asalto de la Legión", "Haz retroceder el ataque de la Legión", "Repousser l’assaut de la Légion", "Respingere l'assalto della Legione", "군단 습격 저지", "Rechace o ataque da Legião", "Остановите натиск Легиона", "击退军团的攻势", "擊退進逼的燃燒軍團", }, 
},
["1017"] = {
{ "The Broken Shore (H)", "", "", "La Costa Quebrada (H)", "", "Riva Dispersa (Orda)", "부서진 해변 (H)", "A Costa Partida. (H)", "", "破碎海滩", "破碎海岸(部落)", }, 
},
["911"] = {
{ "Safe Entrance", "Sicherer Einstieg", "Entrada segura", "Entrada segura", "Accès sécurisé", "Entrata di sicurezza", "안전한 입구", "Entrada segura", "Безопасный вход", "安全入口", "安全通關", }, 
{ "Obtain the Bait", "Holt den Köder", "Conseguir el cebo", "Obtén el cebo", "Obtenir l’appât", "Ottenere l'esca", "미끼 구하기", "Obtenha a isca", "Добыча приманки", "获取诱饵", "取得誘餌", }, 
{ "Place the Bait", "Platziert den Köder", "Colocar el cebo", "Coloca el cebo", "Placer l’appât", "Posizionare l'esca", "미끼 설치", "Coloque a isca", "Положить приманку", "放置诱饵", "放置誘餌", }, 
{ "Slay the Hound", "Tötet den Hund", "Matar al can", "Mata al sabueso", "Tuer le chien", "Uccidere il Mastino", "사냥개 처치", "Mate o canaz", "Убейте гончую", "灭犬行动", "殺死獵犬", }, 
{ "Retrieve the Fangs", "Nehmt die Fänge an Euch", "Recuperar los Colmillos", "Recupera los Colmillos", "Récupérer les crocs", "Recuperare le zanne", "송곳니 회수", "Recupere as Presas", "Заберите Клыки", "夺取獠牙", "取回尖牙", }, 
},
["586"] = {
{ "Gundrak", "Gundrak", "Gundrak", "Gundrak", "Gundrak", "Gundrak", "군드락", "Gundrak", "Гундрак", "古达克", "剛德拉克", }, 
},
["595"] = {
{ "Azjol-Nerub", "Azjol-Nerub", "Azjol-Nerub", "Azjol-Nerub", "Azjol-Nérub", "Azjol-Nerub", "아졸네룹", "Azjol-Nerub", "Азжол-Неруб", "艾卓-尼鲁布", "阿茲歐-奈幽", }, 
},
["1029"] = {
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
},
["687"] = {
{ "Shadowmoon Burial Grounds", "Schattenmondgrabstätte", "Cementerio de Sombraluna", "Cementerios de Sombraluna", "Terres sacrées d’Ombrelune", "Necropoli dei Torvaluna", "어둠달 지하묘지", "Sepulcrário da Lua Negra", "Некрополь Призрачной Луны", "影月墓地", "影月墓地", }, 
},
["554"] = {
{ "Grim Batol", "Grim Batol", "Grim Batol", "Grim Batol", "Grim Batol", "Grim Batol", "그림 바톨", "Grim Batol", "Грим Батол", "格瑞姆巴托", "格瑞姆巴托", }, 
},
["1084"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Demonic Bidding", "Geheiß der Dämonen", "Órdenes demoníacas", "Vinculación demoníaca", "Obéissance démoniaque", "Volere demoniaco", "명령을 따르는 악마", "Lance demoníaco", "Обитатель Бездны", "恶魔召唤", "惡魔交易", }, 
{ "Curses!", "Verflucht!", "¡Maldición!", "¡Maldición!", "Malédiction !", "Maledizioni!", "저주!", "Maldição!", "Проклятие!", "诅咒！", "可惡！", }, 
{ "Corrupting Power", "Macht der Verderbnis", "Poder corruptor", "Poder corruptor", "Le pouvoir corrompt", "Potere corrompente", "부패의 힘", "Poder Corruptor", "Оскверняющая сила", "腐蚀的力量", "腐化力量", }, 
{ "Stealing Health", "Geben und nehmen", "Robo de salud", "Robo de vida", "Vol de vie", "Rubare la vita", "적의 고통은 나의 힘", "Roubar Vida", "Кража жизненных сил", "偷取生命", "盜取生命力", }, 
{ "Add Some Instability", "Stabilität wird überbewertet", "Añade inestabilidad", "Un pequeño aumento de inestabilidad", "Une touche d’instabilité", "Un pizzico di instabilità", "불안정함 더하기", "Um pouco de instabilidade", "Эффект неожиданности", "生死无常", "動盪因子", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Life Tap", "Tauschhandel", "Transfusión de vida", "Transfusión de vida", "Connexion", "Conversione Vitale", "생명력 전환", "Conversão de vida", "Жизнеотвод", "生命分流", "生命分流", }, 
{ "Fear", "Angst und Schrecken", "Miedo", "Miedo", "Peur", "Paura", "공포", "Medo", "Страх", "恐惧", "恐懼", }, 
{ "We're Going To Need A Bigger Demon", "Auf die Größe kommt es an", "Necesitaremos un demonio más grande", "Un demonio, pero más grande", "Il va nous falloir un plus gros démon !", "Ci serve un demone più grosso", "상급 악마가 더 필요하겠어", "Precisaremos de um demônio maior", "Размер имеет значение", "我们需要一个更大的恶魔", "我們需要更大隻的惡魔", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Challenge Accepted", "Herausforderung angenommen", "Desafío aceptado", "Desafío aceptado", "Défi accepté", "Sfida accettata", "더 큰 도전", "Desafio aceito", "Вызов принят", "接受挑战", "接受挑戰", }, 
{ "Defend Against the Legion Attack", "Den Angriff der Legion abwehren", "Defiéndete del ataque de la Legión", "Defensa contra el ataque de la Legión", "Défense contre l’attaque de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "抵抗燃烧军团的攻击", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["910"] = {
{ "Neltharion's Lair", "Neltharions Hort", "La Guarida de Neltharion", "Guarida de Neltharion", "Repaire de Neltharion", "Antro di Neltharion", "넬타리온의 둥지", "Covil de Neltharion", "Логово Нелтариона", "奈萨里奥的巢穴", "奈薩里奧巢穴", }, 
},
["1023"] = {
{ "Black Rook Hold", "Die Rabenwehr", "Torreón Grajo Negro", "Fuerte Torre Oscura", "Bastion du Freux", "Forte Corvonero", "검은 떼까마귀 요새", "Castelo Corvo Negro", "Крепость Черной Ладьи", "黑鸦堡垒", "玄鴉堡", }, 
{ "Black Rook Hold", "Die Rabenwehr", "Torreón Grajo Negro", "Fuerte Torre Oscura", "Bastion du Freux", "Forte Corvonero", "검은 떼까마귀 요새", "Castelo Corvo Negro", "Крепость Черной Ладьи", "黑鸦堡垒", "玄鴉堡", }, 
{ "Black Rook Hold", "Die Rabenwehr", "Torreón Grajo Negro", "Fuerte Torre Oscura", "Bastion du Freux", "Forte Corvonero", "검은 떼까마귀 요새", "Castelo Corvo Negro", "Крепость Черной Ладьи", "黑鸦堡垒", "玄鴉堡", }, 
},
["1258"] = {
{ "Vault of the Wardens", "Das Verlies der Wächterinnen", "Cámara de las Celadoras", "Bóveda de las Celadoras", "Caveau des Gardiennes", "Segrete delle Custodi", "감시관의 금고", "Câmara das Guardiãs", "Казематы Стражей", "守望者地窟", "看守者鐵獄", }, 
},
["203"] = {
{ "Assault on Zan'vess", "Angriff auf Zan'vess", "Asalto a Zan'vess", "Asalto a Zan'vess", "L’attaque de Zan’vess", "Assalto a Zan'vess", "잔베스 강습", "Ataque a Zan'vess", "Атака на Зан'весс", "突袭扎尼维斯", "襲擊贊斐斯", }, 
{ "Defenses of Zan'vess", "Verteidigung von Zan'vess", "Defensas de Zan'vess", "Defensas de Zan'vess", "Les défenses de Zan’vess", "Difese di Zan'vess", "잔베스 수비진", "Defesas de Zan'vess", "Защитное поле Зан'весса", "防御扎尼维斯", "贊斐斯的防禦", }, 
{ "The Heart of Zan'vess", "Das Herz von Zan'vess", "El corazón de Zan'vess", "El corazón de Zan'vess", "Le cœur de Zan’vess", "Cuore di Zan'vess", "잔베스 중심부", "O Coração de Zan'vess", "Сердце Зан'весса", "扎尼维斯之心", "贊斐斯之心", }, 
{ "Weapons of Zan'vess", "Die Waffen von Zan'vess", "Armas de Zan'vess", "Armas de Zan'vess", "Les armes de Zan’vess", "Armi di Zan'vess", "잔베스의 무기들", "Armas de Zan'vess", "Оружие Зан'весса", "扎尼维斯的武装", "贊斐斯的武器", }, 
},
["918"] = {
{ "Eye of Azshara", "Das Auge Azsharas", "Ojo de Azshara", "Ojo de Azshara", "Œil d’Azshara", "Occhio di Azshara", "아즈샤라의 눈", "Olho de Azshara", "Око Азшары", "艾萨拉之眼", "艾薩拉之眼", }, 
},
["958"] = {
{ "Defend the Rear Gate", "Verteidigt das hintere Tor", "Defiende la Puerta Trasera", "Defiende la puerta trasera", "La défense de la porte d’Azshara", "Difendere l'Ingresso Posteriore di Orgrimmar", "뒷문 방어", "Defender o Portão Traseiro", "Оборона Задних врат", "保卫后门", "守禦後門", }, 
{ "Defeat the Demon Commander", "Bezwingt den Dämonenkommandanten", "Derrota al comandante demoníaco", "Derrota al Comandante demoníaco", "Terrasser le commandant démon", "Sconfiggere il comandante demoniaco", "악마 사령관 처치", "Derrotar o Demônio Comandante", "Победа над командиром демонов", "击败恶魔指挥官", "擊敗惡魔指揮官", }, 
{ "Repel the Legion Forces", "Schlagt die Streitkräfte der Legion zurück", "Rechaza a los ejércitos de la Legión", "Repele a las fuerzas de la Legión", "Repousser les troupes de la Légion", "Respingere le forze della Legione", "군단 격퇴", "Rechaçar as forças da Legião", "Отражение натиска Легиона", "击退燃烧军团的部队", "擊退燃燒軍團", }, 
{ "Defeat the Demon Lord", "Bezwingt den Dämonenfürsten", "Derrota al señor demoníaco", "Derrota al Señor demoníaco", "Terrasser le seigneur démon", "Sconfiggere il Signore dei Demoni", "악마 군주 처치", "Derrotar o lorde-demônio", "Смерть повелителю демонов", "击败恶魔领主", "擊敗惡魔領主", }, 
},
["618"] = {
{ "The Steamvault", "Dampfkammer", "La Cámara de Vapor", "La Cámara de Vapor", "Le caveau de la Vapeur", "Antro dei Vapori", "증기 저장고", "Câmara dos Vapores", "Паровое подземелье", "蒸汽地窟", "蒸汽洞窟", }, 
},
["587"] = {
{ "Gundrak", "Gundrak", "Gundrak", "Gundrak", "Gundrak", "Gundrak", "군드락", "Gundrak", "Гундрак", "古达克", "剛德拉克", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["715"] = {
{ "Invasion!", "Invasion!", "¡Invasión!", "¡Invasión!", "Alerte aux envahisseurs !", "Invasione!", "침략!", "Invasão!", "Вторжение!", "入侵！", "入侵！", }, 
{ "Ambush", "Hinterhalt", "Emboscada", "Emboscada", "Embuscade", "Imboscata", "습격", "Emboscada", "Засада", "伏击", "伏擊", }, 
{ "The Holdout", "Durchhaltevermögen", "La resistencia", "La resistencia", "Le baroud", "Resistenza", "항전", "A Resistência", "Продержаться подольше", "坚持到底", "堅持到底", }, 
{ "Cleanup", "Aufräumkommando", "Limpieza", "Limpieza", "Nettoyage", "Ripulitura", "소탕", "Limpeza", "Зачистка", "摧枯拉朽", "收拾殘局", }, 
{ "The Calm", "Ruhe nach dem Sturm", "La calma", "La calma", "Le calme", "La calma", "정적", "A Calma", "Затишье", "风平浪静", "歇息備戰", }, 
{ "Shadows Gather", "Der Schatten wächst", "Las sombras se ciernen", "Las sombras se reúnen", "Les ombres se rassemblent", "Le ombre si addensano", "어둠이 드리운다", "A reunião das sombras", "Тени сгущаются", "暗影蔽日", "暗影集結", }, 
{ "Bronze", "Bronze", "Bronce", "Bronce", "Bronze", "Bronzo", "동메달", "Bronze", "Бронза", "青铜级", "青銅", }, 
{ "Silver", "Silber", "Plata", "Plata", "Argent", "Argento", "은메달", "Prata", "Серебро", "白银级", "白銀", }, 
{ "Gold", "Gold", "Oro", "Oro", "Or", "Oro", "금메달", "Ouro", "Золото", "黄金级", "黃金", }, 
{ "Platinum", "Platin", "Platino", "Platino", "Platine", "Platino", "백금메달", "Platina", "Платиновая", "白金", "白金", }, 
},
["1288"] = {
{ "Upper Return to Karazhan", "Obere Rückkehr nach Karazhan", "Regreso a Karazhan superior", "Regreso superior a Karazhan", "Retour à Karazhan (sommet)", "Ritorno a Karazhan Superiore", "다시 찾은 카라잔 상층", "Retorno a Karazhan superior", "Возвращение в Каражан (верхняя часть)", "重返卡拉赞（上层）", "重返卡拉贊上層", }, 
},
["1172"] = {
{ "Darkheart Thicket", "Das Finsterherzdickicht", "Arboleda Corazón Oscuro", "Matorral Corazón Oscuro", "Fourré Sombrecœur", "Boschetto Cuortetro", "어둠심장 숲", "Bosque Corenegro", "Чаща Темного Сердца", "黑心林地", "暗心灌木林", }, 
},
["208"] = {
{ "Bloodied Crossing", "Blutige Kreuzung", "Cruce Sangriento", "Cruce Sangriento", "Croisée Ensanglantée", "Crocevia Insanguinato", "선혈의 십자로", "Encruzilhada Rubra", "Кровавый перекресток", "血腥岔路口", "染血路口", }, 
{ "Destroy the Gatekeepers", "Zerstört die Torwächter", "Destruye a los guardianes", "Destruye a los guardianes", "Détruire les gardiens de la porte", "Distruggi i Guardiani delle Porte", "문지기를 처치하라", "Destruir os Guarda-pórticos", "Убить стражей дворцовых врат", "摧毁守门人", "擊敗守門人", }, 
{ "The Foot of Lei Shen", "Der Fuß des Lei Shen", "El Atrio de Lei Shen", "El Atrio de Lei Shen", "Le Seuil de Lei Shen", "Atrio di Lei Shen", "레이 션의 발치", "O Pé de Lei Shen", "Подступы ко дворцу Лэй Шэня", "雷神之基", "雷神之足", }, 
{ "Defeat Shan Bu", "Besiegt Shan'Bu", "Derrota a Shan Bu", "Derrota a Shan Bu", "Vaincre Shan Bu", "Sconfiggi Shan Bu", "샨 부 처치", "Derrotar Shan Bu", "Победить Шань-Бу", "击败山怖", "擊敗衫布", }, 
},
["661"] = {
{ "The Wicked Grotto", "Die Tückische Grotte", "La Gruta Maldita", "La Gruta Maldita", "La grotte Maudite", "Grotta Perversa", "악의 동굴", "Gruta Malévola", "Оскверненный грот", "邪恶洞穴", "邪惡洞穴", }, 
},
["998"] = {
{ "The Council's Vengeance", "Die Rache des Rates", "La venganza del Consejo", "La venganza del Consejo", "La vengeance du conseil", "La vendetta del concilio", "의회의 복수", "A vingança do Conselho", "Отмщение Совета", "议会的复仇", "議會的復仇", }, 
{ "Cut Out the Heart", "Das Herz herausschneiden", "Arrancar el corazón", "Arráncale el alma", "Droit au cœur", "Estirpare il cuore", "심장 도려내기", "Arranque o coração", "Сердце Властителя", "剖腹剜心", "直搗黃龍", }, 
{ "Becoming the Overlord", "Werdet zum Oberanführer", "Convertirse en el Señor supremo", "Convirtiéndose en el Señor Supremo", "La succession du suzerain", "Il nuovo Supremo", "대군주의 자격", "Ascensão a lorde supremo", "Станьте Властителем", "成为大领主", "成為主宰", }, 
},
["961"] = {
{ "Picking Up the Pieces", "Die, die übrig blieb", "Recoger los pedazos", "Recoger los pedazos", "Ramasser les morceaux", "Raccogliere i pezzi", "탈출시키기", "Juntando as peças", "Взять на себя ответственность", "收拾残局", "撿起碎片", }, 
{ "Their Blood Will Flow", "Ihr Blut wird fließen", "Correrá su sangre", "Correrá su sangre", "Bain de sang", "Scorrerà il sangue", "피가 강을 이루리니", "O sangue vai correr", "Их кровь потечет рекой", "血流成河", "腥風血雨", }, 
{ "A River of Souls", "Ein Fluss aus Seelen", "Un río de almas", "Un río de almas", "La rivière des âmes", "Un fiume d'anime", "영혼의 강", "Um rio de almas", "Река душ", "灵魂之河", "靈魂之流", }, 
{ "In the Darkness of the Pit", "In der Dunkelheit der Grube", "En la oscuridad del foso", "En la oscuridad del foso", "Dans les ténèbres de la fosse", "Nell'oscurità della fossa", "균열의 어둠 속에서", "Nas trevas do fosso", "Во мраке преисподней", "在深渊的黑暗中", "身處黑暗深淵", }, 
{ "Nowhere to Hide", "Kein Versteck ist sicher", "Sin escapatoria", "Sin escapatoria", "Tu ne m’échapperas pas", "Senza un posto dove nascondersi", "숨을 곳은 없다", "Não há onde se esconder", "Негде спрятаться", "无处可藏", "無處可躲", }, 
{ "Vengeance for the Illidari", "Rache für die Illidari", "Venganza por los Illidari", "Venganza para los Illidari", "La vengeance des Illidari", "Vendetta per gli Illidari", "일리다리의 복수", "Vingança pelos Illidari", "Месть за иллидари", "为伊利达雷复仇", "伊利達瑞的復仇", }, 
{ "Right by Ascension", "Recht durch Aufstieg", "Derecho por ascensión", "Derecho por ascensión", "Droit d’ascension", "Tue di diritto", "합당한 자격", "Direito por ascensão", "По праву восхождения", "升格之道", "晉升之權", }, 
},
["1259"] = {
{ "The Highlord's Return", "Rückkehr des Hochlords", "El retorno del Alto Señor", "El regreso del Alto señor", "Le retour du généralissime", "Il ritorno del Gran Signore", "돌아온 대군주", "O retorno do grão-lorde", "Возвращение верховного лорда", "魔王归来", "大領主歸來", }, 
{ "Twisting the Nether", "Den Nether aufwirbeln", "El abisal vacío", "Vaciando el abismo", "Le Néant distordu", "Distorcere il Fatuo", "황천 뒤틀기", "Espiralando o éter", "Круговерчение Пустоты", "扭曲虚空", "讓虛空扭曲", }, 
{ "Goodbye Kruul World", "In Kruulitäten geraten", "Adiós, mundo Kruul", "Adiós, mundo Kruuel", "Adieu monde kruuel", "La fine di Kruul", "잘 가, 크룰!", "Adeus, mundo kruuel", "Прощай, Круул", "再见了，有库鲁尔的世界", "卡魯歐的世界永別了", }, 
},
["989"] = {
{ "The Archmage", "Der Erzmagier", "El archimago", "El Archimago", "L’archimage", "L'Arcimago", "대마법사", "O Arquimago", "Верховный маг", "大法师", "大法師", }, 
{ "Visions of the Past", "Visionen der Vergangenheit", "Visiones del pasado", "Visiones del pasado", "Visions du passé", "Visioni del Passato", "과거의 환영", "Visões do passado", "Призраки прошлого", "往日的幻象", "往日的幻象", }, 
{ "Medivh's Defenses", "Medivhs Verteidigung", "Las defensas de Medivh", "Las defensas de Medivh", "Les défenses de Medivh", "Le difese di Medivh", "메디브의 방어", "Defesas de Medivh", "Охрана Медива", "麦迪文的防御", "麥迪文的防禦", }, 
{ "We Are Not Alone", "Wir sind nicht allein", "No estamos solos", "No estamos solos", "Nous ne sommes pas seuls", "Non siamo soli", "혼자가 아니야", "Não estamos sozinhos", "Враг близко", "我们并不孤单", "我們並不孤單", }, 
{ "Breaking In", "Einbruch", "Irrupción", "Forzando la entrada", "Effraction", "Irruzione", "침입", "Arrombamento", "Проникновение", "突破", "闖入", }, 
{ "Wisped Away", "Irrgeleitet", "Desvanecido", "Llevado lejos", "Partir en fumée", "Sussurri dispersi", "밝혀진 비밀", "Evanescente", "Улетевшие огоньки", "逃逸", "幽光消逝", }, 
{ "Bookkeeping", "Buchhaltung", "Ocuparse de los libros", "Contabilidad", "Tenue des livres", "Gestire la libreria", "고서 폐기", "Biblioteconomia", "Книгоучет", "图书管理", "整理書目", }, 
{ "Not the Intruders You're Looking For", "Nicht die Eindringlinge, nach denen ihr sucht", "No son los intrusos que buscáis", "No son los intrusos que estás buscando", "Un intrus peut en cacher un autre", "Non gli intrusi che ti aspettavi", "예상치 못한 침입자", "Não são os intrusos que você está procurando", "Это не те незваные гости, которых вы ищете", "我们不是你要找的入侵者", "不是你要找的入侵者", }, 
{ "Defenders of Karazhan", "Verteidiger von Karazhan", "Defensores de Karazhan", "Defensores de Karazhan", "Les défenseurs de Karazhan", "Difensori di Karazhan", "카라잔의 수호자", "Defensores de Karazhan", "Защитники Каражана", "卡拉赞的保卫者", "卡拉贊保衛者", }, 
{ "Knowledge is Key", "Wissen ist der Schlüssel", "El conocimiento es clave", "La clave está en el conocimiento", "Des connaissances essentielles", "La conoscenza è la chiave", "지식이 곧 열쇠", "O conhecimento é a chave", "Знание – сила", "知识才是关键。", "知識是關鍵", }, 
{ "Words of the Wise", "Worte des Weisen", "Palabras sabias", "Palabras de los sabios", "Les conseils du sage", "Parole di saggezza", "현자의 말", "Palavras do sábio", "Слова мудрости", "睿智之语", "智者之言", }, 
},
["1101"] = {
{ "The Azure Prisoner", "Der Azurgefangene", "El prisionero azur", "El Prisionero Azur", "Le prisonnier d’Azur", "Il prigioniero azzurro", "하늘빛 포로", "O prisioneiro lazúli", "Лазурный пленник", "碧蓝囚徒", "藍龍囚犯", }, 
{ "Seeking Answers", "Antworten suchen", "Buscando respuestas", "Buscando respuestas", "Chercher des réponses", "In cerca di risposte", "답 구하기", "Em busca de respostas", "В поисках ответов", "寻找答案", "找尋解答", }, 
{ "Echoes of Ancient Power", "Echos uralter Kraft", "Ecos de un poder antiguo", "Ecos de poder antiguo", "Les échos du pouvoir antique", "Echi di antico potere", "고대의 힘의 메아리", "Ecos de poder antigo", "Эхо древнего могущества", "远古之力的回响", "上古之力的回響", }, 
{ "The Way Out is Through", "Da müsst Ihr durch", "La salida es a través", "Para salir hay que atravesar", "La seule issue", "L'uscita è attraverso", "나가는 유일한 방법", "A saída é pelo meio", "Единственный путь – вперед", "道路通畅", "穿過去是唯一的路", }, 
{ "Consumed by Void", "Von Leere verschlungen", "Consumido por el vacío", "Consumido por el Vacío", "Consumé par le Vide", "Consumato dal Vuoto", "공허의 흡수", "Consumidos pelo caos", "Поглощение Бездной", "虚空吞噬", "被虛無吞噬", }, 
{ "Breaking and Binding", "Brechen und Binden", "Romper y vincular", "Rompiendo y unificando", "Recréer le lien", "Spezzare e vincolare", "구속과 해방", "Quebrar e atar", "Подчинение и связывание", "突破与禁锢", "突破與禁錮", }, 
{ "The Power of Aegwyn", "Die Macht von Aegwynn", "El poder de Aegwynn", "El poder de Aegwyn", "La puissance d’Aegwynn", "Il potere di Aegwynn", "에이그윈의 힘", "O poder de Aegwyn", "Сила Эгвин", "艾格文的力量", "艾格文之力", }, 
},
["990"] = {
{ "Ursoc's Lair", "Ursocs Unterschlupf", "Guarida de Ursoc", "Guarida de Ursoc", "Tanière d’Ursoc", "Antro di Ursoc", "우르속의 보금자리", "Covil de Ursoc", "Логово Урсока", "乌索克之巢", "厄索克巢穴", }, 
{ "The Light In The Dark", "Das Licht im Dunkel", "La luz en la oscuridad", "La Luz en la Oscuridad", "Une lueur dans les ténèbres", "La luce nell'oscurità", "암흑 속 한 줄기 빛", "A luz na escuridão", "Свет во тьме", "黑暗中的光明", "黑暗中的光明", }, 
{ "The Nightmare Approaches", "Der Alptraum beginnt", "Se acerca la Pesadilla", "La Pesadilla se aproxima", "Le Cauchemar approche", "L'Incubo si avvicina", "다가오는 악몽", "O Pesadelo se aproxima", "Кошмар приближается", "梦魇临近", "夢魘逼近", }, 
{ "The Nightmare Continues", "Der Alptraum geht weiter", "Continúa la Pesadilla", "La Pesadilla continúa", "Le Cauchemar continue", "L'Incubo continua", "계속되는 악몽", "O Pesadelo continua", "Кошмар не отступает", "梦魇不绝", "夢魘不息", }, 
{ "The Nightmare Continues", "Der Alptraum geht weiter", "Continúa la Pesadilla", "La Pesadilla continúa", "Le Cauchemar continue", "L'Incubo continua", "계속되는 악몽", "O Pesadelo continua", "Кошмар не отступает", "梦魇不绝", "夢魘不息", }, 
{ "The Nightmare Continues", "Der Alptraum geht weiter", "Continúa la Pesadilla", "La Pesadilla continúa", "Le Cauchemar continue", "L'Incubo continua", "계속되는 악몽", "O Pesadelo continua", "Кошмар не отступает", "梦魇不绝", "夢魘不息", }, 
{ "The Fallen One", "Der Gefallene", "El caído", "El caído", "Le déchu", "Il Caduto", "쓰러진 자", "O Tombado", "Падший", "堕落者", "亡者", }, 
{ "The Claws Reclaimed", "Die zurückeroberten Klauen", "Las Garras reclamadas", "Reclama las Garras", "Récupération des griffes", "Gli Artigli recuperati", "되찾은 곰 신의 유물", "As garras retomadas", "Возвращение Когтей", "夺回乌索克之爪", "取回神爪", }, 
},
["973"] = {
{ "Landing", "Landung", "Desembarco", "Peñón", "Atterrissage", "Approdo", "착륙", "Pouso", "Высадка", "登陆", "降落", }, 
{ "The Haunted Harbor", "Der heimgesuchte Hafen", "El puerto embrujado", "El Puerto hechizado", "Le port hanté", "Il porto infestato", "귀신 들린 항구", "O porto assombrado", "Порт призраков", "港湾鬼影", "鬧鬼的港口", }, 
{ "Distracting Them Wisely", "Kluge Ablenkung", "Distraerlos sabiamente", "Distráelos con prudencia", "Sage diversion", "Distrarli con saggezza", "도둑질의 방법", "Sábia distração", "Продуманное отвлечение", "巧学活用", "以智取勝", }, 
{ "Easy Pickings", "Leichte Aufgabe", "Blancos fáciles", "Blancos fáciles", "Des cibles faciles", "Un gioco da ragazzi", "슬쩍하기", "Presas fáceis", "Легкая добыча", "轻而易举", "不是對手", }, 
{ "Just a Few More", "Nur noch ein paar mehr", "Solo unas cuantas más", "Solo unos pocos más", "Toujours plus", "Ancora qualcuna", "감시석이 더 필요해", "Só mais alguns", "Еще немного, еще чуть-чуть...", "再来点儿", "再多幾個", }, 
{ "The Wall of Fog", "Die Nebelmauer", "El muro de niebla", "El muro de niebla", "Le mur de brume", "Il muro di nebbia", "안개의 벽", "A muralha de névoa", "Стена тумана", "迷雾之墙", "迷霧之牆", }, 
{ "Into the Mists", "In die Nebel", "Entre la niebla", "Entre la niebla", "Dans les brumes", "Nelle nebbie", "안개 속으로", "Brumas adentro", "Сквозь туман", "深入迷雾", "進入霧中", }, 
{ "The Shallows of Death", "Die Untiefen des Todes", "Los bajíos de muerte", "Los bajos de la muerte", "Les bas-fonds de la mort", "La riviera della morte", "죽음의 여울", "A várzea da morte", "Отмель смерти", "死亡浅滩", "死亡低地", }, 
{ "Deadly Shadows", "Tödliche Schatten", "Sombras mortales", "Sombras letales", "Ombres meurtrières", "Ombre letali", "치명적인 그림자", "Sombras mortais", "Смертоносные тени", "致命阴影", "致命的暗影", }, 
{ "The Hunter or the Hunted", "Jäger oder Gejagter", "El cazador o la presa", "El cazador o la presa", "Le chasseur ou la proie", "Cacciatore o preda", "사냥하거나 혹은 사냥당하거나", "A caça ou o caçador", "Кто был охотник, кто добыча...", "猎人还是猎物？", "獵殺或是被獵", }, 
{ "For the Fallen", "Für die Gefallenen", "Por los caídos", "Por los caídos", "Au nom des disparus", "Per i caduti", "망자의 복수", "Pelos caídos", "Месть за павших", "复仇之战", "為了倒下的同伴", }, 
{ "The Lair of the Beast", "Der Hort der Bestie", "La guarida de la bestia", "La guarida de la bestia", "Le repaire de la bête", "La tana della bestia", "야수의 둥지", "O covil da fera", "Логово чудовища", "野兽之巢", "野獸巢穴", }, 
{ "Talonclaw", "Fangklaue", "Garra Feroz", "Garfa Corva", "Griffe-Serre", "Grinfiartiglio", "칼날갈퀴", "Garranha", "Хищный Коготь", "雄鹰之爪", "猛禽之爪", }, 
},
["686"] = {
{ "Shadowmoon Burial Grounds", "Schattenmondgrabstätte", "Cementerio de Sombraluna", "Cementerios de Sombraluna", "Terres sacrées d’Ombrelune", "Necropoli dei Torvaluna", "어둠달 지하묘지", "Sepulcrário da Lua Negra", "Некрополь Призрачной Луны", "影月墓地", "影月墓地", }, 
},
["786"] = {
{ "The Broken Shore", "Die Verheerte Küste", "Costa Abrupta", "La Costa Quebrada", "Rivage Brisé", "Riva Dispersa", "부서진 해변", "A Costa Partida", "Расколотый берег", "破碎海滩", "破碎海岸", }, 
{ "Storm The Beach", "Erstürmt den Strand", "Asalta la playa", "Asalta la playa", "Le grand débarquement", "Assalto alla spiaggia", "해변 청소", "Tomar a praia", "Штурм побережья", "抢滩登陆", "掃蕩海灘", }, 
{ "Defeat the Commander", "Bezwingt den Kommandanten", "Derrota al comandante", "Derrota al Comandante", "Terrasser le commandant", "Sconfiggere il comandante", "사령관 처치", "Derrotar o Comandante", "Убить командира", "击败指挥官", "擊敗指揮官", }, 
{ "Find Varian", "Findet Varian", "Encontrar a Varian", "Encuentra a Varian", "Trouver Varian", "Trovare Varian", "바리안 찾기", "Encontre Varian", "Найти Вариана", "找到瓦里安", "找到瓦里安", }, 
{ "Destroy the Portal", "Vernichtet das Portal", "Destruye el portal", "Destruye el portal", "Destruction du portail", "Distruggere il portale", "차원문 파괴", "Destrua o portal", "Разрушение портала", "摧毁传送门", "摧毀傳送門", }, 
{ "Raze the Black City", "Legt die Schwarze Stadt in Schutt und Asche", "Arrasar la Ciudad Negra", "Arrasa la Ciudad Negra", "Le sac de la ville Noire", "Assalto alla Città Oscura", "검은 도시 공격", "Arrase a Cidade Negra", "Предайте огню Черный город", "扫荡黑色之城", "夷平黑城", }, 
{ "The Highlord", "Der Hochlord", "El Alto Señor", "El Alto Señor", "Le généralissime", "Il Gran Signore", "대영주", "O grão-lorde", "Верховный лорд", "大领主", "大領主", }, 
{ "Krosus", "Krosus", "Krosus", "Krosus", "Krosus", "Krosus", "크로서스", "Krosus", "Крос", "克洛苏斯", "克羅索斯", }, 
{ "Stop Gul'dan", "Haltet Gul'dan auf", "Detener a Gul'dan", "Detén a Gul'dan", "Arrêter Gul’dan", "Fermare Gul'dan", "굴단을 막아라", "Detenha Gul'dan", "Остановите Гул'дана", "阻止古尔丹", "阻止古爾丹", }, 
},
["1095"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Ferocious Strike", "Wilder Schlag", "Ataque feroz", "Ataque feroz", "Frappe féroce", "Assalto feroce", "가혹한 일격", "Ataque Feroz", "Дикая ярость", "凶猛打击", "虎虎生風", }, 
{ "A Kick to the Face", "Ein Tritt ins Gesicht", "Una patada en la cara", "Una patada en la cara", "Un coup de pied au visage", "Un calcio in faccia", "면상 발차기", "Chute na cara", "Пинок по лицу", "照脸直踢", "踢他臉", }, 
{ "Kick It Again", "Nachtreten", "Patea con saña", "Patéala de nuevo", "Dégagement", "Un altro calcio", "연이어 발차기", "Chutar de novo", "Удар, лишающий чувств", "再踢一脚", "再踢一次", }, 
{ "A Thousand Strikes", "Tausend und ein Schlag", "Miles de golpes", "Mil golpes", "Un millier de coups", "Un migliaio di colpi", "주먹 작렬", "Mil Golpes", "Один удар вместо тысячи", "一瞬千击", "打一千次", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Keep on Rollin'", "Nicht aus der Rolle fallen", "Rodar y rodar", "Sigue rodando", "Ça roule, ma poule !", "Rotolando verso sud", "데굴데굴", "Vai rolando", "Трюк, достойный акробата", "翻滚不停", "翻滾吧！", }, 
{ "Well, Effuse Me!", "Übermut tut selten gut", "¡Efúndeme si puedes!", "Muy bien, ¡efúndeme!", "Effusions bienvenues", "Emanami questo!", "치유의 기술", "Bom, manda uma efusão!", "Излей мне душу", "让真气贯通我吧！", "不好意思，洩洩！", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["967"] = {
{ "The Arcway", "Der Arkus", "La Arquería", "El Arco", "L’Arcavia", "L'Arcavia", "비전로", "O Arcâneo", "Катакомбы Сурамара", "魔法回廊", "幽暗地道", }, 
{ "The Arcway", "Der Arkus", "La Arquería", "El Arco", "L’Arcavia", "Arcavia", "비전로", "O Arcâneo", "Катакомбы Сурамара", "魔法回廊", "幽暗地道", }, 
},
["200"] = {
{ "Enter the Black Temple", "Betretet den Schwarzen Tempel", "Entra en el Templo Oscuro", "Entra en el Templo Oscuro", "L’entrée du Temple noir", "Entra nel Tempio Nero", "검은 사원에 입장", "Entre no Templo Negro", "Войти в Черный храм", "进入黑暗神殿", "進入黑暗神廟", }, 
{ "Search for signs of the Council's Presence", "Findet Anzeichen für die Anwesenheit des Rates", "Busca señales de la presencia del Consejo", "Busca señales de la presencia del Consejo", "Trouver des traces de la présence du Conseil", "Cerca le tracce della presenza del Concilio", "의회가 존재한다는 증거를 찾아서", "Busque sinais da Presença do Conselho", "Найти следы присутствия Совета Мрачной Жатвы", "搜索议会存在的证据", "尋找議會存在的跡象", }, 
{ "Follow Akama to the Shrine of Lost Souls", "Folgt Akama zum Schrein der Verlorenen Seelen", "Sigue a Akama hasta el Santuario de las Almas Perdidas", "Sigue a Akama hasta el Santuario de las Almas Perdidas", "Suivre Akama jusqu’au sanctuaire des Âmes perdues", "Segui Akama fino al Santuario delle Anime Perdute", "아카마를 따라 길 잃은 영혼의 제단으로 이동", "Siga Akama até o Santuário das Almas Perdidas", "Идти за Акамой в Святилище Потерянных Душ", "跟随阿卡玛前往失落灵魂神殿。", "跟著阿卡瑪前往失落靈魂神殿", }, 
{ "Uncover the Council's Plan", "Den Plan des Rates aufdecken", "Descubre el plan del Consejo", "Descubre el plan del Consejo", "Découvrir le plan du Conseil", "Scopri i piani del Concilio", "의회의 계획을 밝혀라", "Descobrir o plano do Conselho", "Раскрыть план Совета", "揭示议会的计划", "揭發議會的計畫", }, 
{ "Defeat the Essence of Order", "Bezwingt die Essenz der Ordnung", "Derrota a la esencia de orden", "Derrota a la esencia de orden", "Vaincre l’essence de l’ordre", "Sconfiggi l'Essenza dell'Ordine", "질서의 정수를 처치하라", "Derrote a Essência da Ordem", "Победить сущность порядка", "击败秩序精华", "打敗秩序精華", }, 
{ "Escape the Shrine of Lost Souls", "Entkommt aus dem Schrein der Verlorenen Seelen", "Escapa del Santuario de las Almas Perdidas", "Escapa del Santuario de las Almas Perdidas", "Fuir le sanctuaire des Âmes perdues", "Fuga dal Santuario delle Anime Perdute", "길 잃은 영혼의 제단 탈출", "Fuja do Santuário das Almas Perdidas", "Бежать из Святилища Потерянных Душ", "逃出失落灵魂神殿", "逃離失落靈魂神殿", }, 
{ "Plunder the Den of Mortal Delights", "Plündert den Hof der Irdischen Gelüste", "Saquea la Guarida de los Placeres Mortales", "Saquea la Guarida de los Placeres Mortales", "Piller la tanière des Délices mortelles", "Saccheggia l'Antro delle Delizie Mortali", "향락의 소굴을 털어라", "Saquear Covil dos Prazeres Mortais", "Ограбление Приюта Земных Наслаждений", "劫掠欢愉之园", "劫掠凡慾邪窟", }, 
{ "Head to the Temple Summit", "Begebt Euch zur Tempelspitze", "Dirígete a la cima del templo", "Dirígete a la cima del templo", "Vers le sommet du temple", "Raggiungi la Sommità del Tempio", "사원 정상으로", "Vá para o Ápice do Templo", "К Храмовой вершине", "前往神殿之巅", "前往神廟頂層", }, 
{ "Defeat Kanrethad", "Besiegt Kanrethad", "Derrota a Kanrethad", "Derrota a Kanrethad", "Battre Kanrethad", "Sconfiggi Kanrethad", "칸레타드 처치", "Derrotar Kanrethad", "Победить Канретада", "击败坎雷萨德", "擊敗坎瑞薩德", }, 
},
["1018"] = {
{ "The Broken Shore (A)", "", "", "La Costa Quebrada (A)", "", "Riva Dispersa (Alleanza)", "부서진 해변 (A)", "A Costa Partida (A)", "", "破碎海滩", "破碎海岸(聯盟)", }, 
},
["957"] = {
{ "The Frozen Halls", "Die Gefrorenen Hallen", "Las Cámaras Heladas", "Las Cámaras Heladas", "Les salles Gelées", "Sale Gelide", "얼어붙은 전당", "Salões Gelados", "Ледяные залы", "冰封大殿", "冰封大廳", }, 
{ "Meltdown", "Kernschmelze", "Fusión", "Fusión", "Dégel", "Scioglimento", "얼음 녹이기", "Derretimento", "Оттепель", "熔毁", "融化", }, 
{ "Hot On The Trail", "Auf den Fersen", "Pisándole los talones", "Pisándole los talones", "La piste est toute chaude", "La notte dei morti infuocati", "뜨거운 추격", "Trilha quente", "По горячим следам", "热力追踪", "奮力追擊", }, 
{ "Playing With Fire", "Spiel mit dem Feuer", "Jugando con fuego", "Jugando con fuego", "Jouer avec le feu", "Giocare col fuoco", "불장난은 나빠요", "Brincando com fogo", "Игра с огнем", "玩火自焚", "玩火自焚", }, 
{ "The Flamestrike", "Der Flammenstoß", "El Fogonazo", "El Fogonazo", "Le Choc de flammes", "Colonne di fuoco", "불기둥", "Golpe Flamejante", "Огненный столб", "烈焰之击", "烈焰之擊", }, 
},
["723"] = {
{ "The Confrontation", "Die Konfrontation", "El enfrentamiento", "La confrontación", "L’affrontement", "Il confronto", "대면", "O Confronto", "Противостояние", "决战", "決戰", }, 
{ "Harnessing the Power", "Nutzung der Macht", "Dominar el poder", "Aprovechando el poder", "La puissance maîtrisée", "Ottenere il potere", "유물의 힘", "Reunindo Poder", "Обузданная мощь", "驾驭神力", "駕馭神力", }, 
{ "Bolstering their Forces", "Ihre Streitkräfte stärken", "Aumentar sus fuerzas", "Reforzando el ataque", "L’exaltation des troupes", "Sfruttare il potere", "계속되는 공격", "Reforçando as tropas deles", "Укрепление сил", "顶住他们的进攻", "鞏固部隊", }, 
{ "The Son of Gruul", "Der Sohn von Gruul", "El hijo de Gruul", "El hijo de Gruul", "Le fils de Gruul", "Il Figlio di Gruul", "그룰의 아들", "O Filho de Gruul", "Сын Груула", "格鲁尔之子", "戈魯爾之子", }, 
{ "The Final Confrontation", "Die letzte Konfrontation", "El enfrentamiento final", "La confrontación final", "L’affrontement final", "Il confronto finale", "결전", "O Confronto Final", "Кульминация противостояния", "最后的决战", "最後決戰", }, 
},
["540"] = {
{ "Temple of the Jade Serpent", "Tempel der Jadeschlange", "Templo del Dragón de Jade", "Templo del Dragón de Jade", "Temple du Serpent de jade", "Tempio della Serpe di Giada", "옥룡사", "Templo da Serpente de Jade", "Храм Нефритовой Змеи", "青龙寺", "玉蛟寺", }, 
},
["933"] = {
{ "Another Battle", "Ein weiterer Kampf", "Otra batalla", "Otra batalla", "Un autre combat", "Un'altra battaglia", "또 다른 전투", "Uma outra batalha", "Очередная битва", "新的战场", "另一個戰場", }, 
{ "A Desperate Charge", "Ein verzweifelter Ansturm", "Una carga desesperada", "Una carga desesperada", "Baroud d’honneur", "Una carica disperata", "필사의 돌격", "Uma investida desesperada", "Отчаянный натиск", "最后的冲锋", "背水一戰", }, 
{ "The Val'kyr", "Die Val'kyr", "La Val'kyr", "La Val'kyr", "Les Val’kyrs", "Val'kyr", "발키르", "As Val'kyren", "Валь'кира", "瓦格里", "華爾琪", }, 
{ "Reinforcing the Warband", "Die Truppen verstärken", "Reforzar a los guerreros", "Reforzando la banda de guerra", "Épauler la troupe de guerre", "Rinforzi alla squadra", "전투부대 지원", "Reforço do bando guerreiro", "Подкрепление", "援助兵团", "支援作戰", }, 
{ "Just A Pit Lord", "Nur ein Grubenlord", "Un mero señor del foso", "Solo un Señor del foso", "Une simple formalité", "Un comune Signore delle Fosse", "겨우 지옥의 군주 한 명에게...", "Um mero lorde abissal", "Всего лишь властитель преисподней", "深渊领主而已", "深淵領主", }, 
},
["1097"] = {
{ "Searching the Hold", "Die Festung durchsuchen", "Buscar en el Bastión", "Explorando el bastión", "La fouille du bastion", "Ricerche nel forte", "요새 수색", "Vasculhando o castelo", "Поиски в Оплоте", "搜索堡垒", "搜索要塞", }, 
{ "Getting Over the Overfiend", "Oberdämon zu unterst", "Acabar con el gran maligno", "Superando al gran maligno", "Supérieur au démon", "Abbattere il Vilnato", "거대마귀 처치", "Superando o Demônio Superior", "Сразите архидемона", "比大恶魔还大", "越級上報", }, 
{ "Demon Hunting", "Dämonenjagd", "Cazando demonios", "Caza de demonios", "Chasse aux démons", "Caccia al Demone", "악마 사냥", "Caçada demoníaca", "Охота на демонов", "恶魔追猎", "惡魔狩獵", }, 
{ "The Legion", "Die Legion", "La Legión", "La Legión", "La Légion", "La Legione", "군단", "A Legião", "Легион", "军团", "燃燒軍團", }, 
{ "Screams of the Skull", "Schreie des Schädels", "Los gritos del cráneo", "Los gritos del cráneo", "Les cris du crâne", "Urla del teschio", "해골의 절규", "Gritos da caveira", "Вопли черепа", "颅骨的尖啸", "顱骨的尖嘯", }, 
{ "The Skull of the Man'ari", "Der Schädel der Man'ari", "El Cráneo del Man'ari", "El Cráneo de los Man'ari", "Le Crâne du Man’ari", "Teschio dei Man'ari", "만아리의 해골", "A Caveira dos Man'ari", "Череп Ман'ари", "堕落者之颅", "曼那瑞的顱骨", }, 
{ "There's a New Master in Town", "Ein neuer Meister ist in der Stadt", "Hay un nuevo maestro en la ciudad", "Un nuevo maestro ha llegado", "Changement de propriétaire", "Un nuovo maestro in città", "주인은 갈아타라고 있는 것", "Tem um novo mestre na área", "Новый хозяин", "旧物换新主", "我才是老大", }, 
},
["708"] = {
{ "The Everbloom", "Der Immergrüne Flor", "El Vergel Eterno", "El Sempibrote", "La Flore éternelle", "Verdeterno", "상록숲", "Floretérnia", "Вечное Цветение", "永茂林地", "永茂林", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["511"] = {
{ "Ragefire Chasm", "Der Flammenschlund", "Sima Ígnea", "Sima Ígnea", "Gouffre de Ragefeu", "Baratro di Fiamma Furente", "성난불길 협곡", "Cavernas Ígneas", "Огненная Пропасть", "怒焰裂谷", "怒焰裂谷", }, 
},
["212"] = {
{ "Rendezvous with Ranger General Vereesa Windrunner", "Trefft Euch mit Waldläufergeneralin Vereesa Windläufer", "Reúnete con la General Forestal Vereesa Brisaveloz", "Reúnete con la General Forestal Vereesa Brisaveloz", "Rendez-vous avec le général des forestiers Vereesa Coursevent", "Incontra Vereesa Ventolesto", "순찰대 사령관 베리사 윈드러너와 접선", "Encontrar-se com a General Patrulheira Vereesa Correventos", "Встреча с предводительницей следопытов Верисой Ветрокрылой", "与游侠将军温蕾萨·风行者会合", "和遊俠將軍凡蕾莎·風行者會合", }, 
{ "Survive the Ambush", "Überlebt den Überfall", "Sobrevive a la emboscada", "Sobrevive a la emboscada", "Survivre à l’embuscade", "Sopravvivi all'imboscata", "기습에서 생존", "Sobreviva à emboscada", "Пережить нападение", "在伏击中幸存下来", "撐過敵人的埋伏", }, 
{ "Destroy the Barricades", "Zerstört die Barrikaden", "Destruye las barricadas", "Destruye las barricadas", "Détruire les barricades", "Distruggi le barricate", "방벽 파괴", "Destruir as barricadas", "Разрушить баррикады", "摧毁屏障", "摧毀路障", }, 
{ "Kill Anki and Beastcaller Pakutesh", "Tötet Anki und Bestienrufer Pakutesh", "Mata a Anki y al clamabestias Pakutesh", "Mata a Anki y al clamabestias Pakutesh", "Tuer Anki et le mande-bête Pakutesh", "Uccidi Anki e l'Invocatore delle Bestie Pakutesh", "안키와 야수소환사 파쿠테쉬 처치", "Matar Anki e o Chama-feras Pakutesh", "Убить Анки и заклинателя зверей Пакутеша", "击败安基和驭兽师帕库特什", "殺死安奇及喚獸者帕古它許", }, 
{ "Kill Arcanital Mara'kah and his Spirit Mask", "Tötet Arkanital Mara'kah und seine Geistermaske", "Mata al arcanital Mara'kah y a su máscara espíritu", "Mata al arcanital Mara'kah y a su máscara espíritu", "Tuer le rituarcaniste Mara’kah et son masque d’esprit", "Elimina Mara'kah e la Maschera Spiritica", "비전주술사 마라카와 영혼 가면 처치", "Matar o Arcanital Mara'kah e sua Máscara Espiritual", "Убить чародея-ритуалиста Мара'каха и его маску духов", "击败魔术士玛拉卡和他的灵魂面具", "殺死秘宗瑪拉卡與他的靈魂面具", }, 
},
["929"] = {
{ "Halls of Valor", "Die Hallen der Tapferkeit", "Cámaras del Valor", "Salones del Valor", "Les salles des Valeureux", "Sale del Valore", "용맹의 전당", "Salões da Bravura", "Чертоги Доблести", "英灵殿", "英靈殿", }, 
},
["608"] = {
{ "The Shattered Halls", "Die Zerschmetterten Hallen", "Las Salas Arrasadas", "Las Salas Arrasadas", "Les salles Brisées", "Sale della Devastazione", "으스러진 손의 전당", "Salões Despedaçados", "Разрушенные залы", "破碎大厅", "破碎大廳", }, 
},
["731"] = {
{ "Extinguish Runes", "Löscht die Runen", "Extinción de runas", "Extinguir runas", "Éteindre les runes", "Estingui le rune", "룬 꺼뜨리기", "Extinguir runas", "Погасить руны", "熄灭符文", "熄滅符文", }, 
{ "Upper Blackrock Spire", "Obere Schwarzfelsspitze", "Cumbre de Roca Negra Superior", "Cumbre de Roca Negra superior", "Sommet du pic Rochenoire", "Bastioni di Roccianera Superiori", "검은바위 첨탑 상층", "Pico da Rocha Negra Superior", "Верхняя часть пика Черной горы", "黑石塔上层", "黑石塔上層", }, 
},
["49"] = {
{ "Siege of Niuzao Temple", "Belagerung des Niuzaotempels", "Asedio del Templo de Niuzao", "Asedio del Templo de Niuzao", "Siège du temple de Niuzao", "Assedio al Tempio di Niuzao", "니우짜오 사원 공성전투", "Cerco ao Templo Niuzao", "Осада храма Нюцзао", "围攻砮皂寺", "圍攻怒兆寺", }, 
},
["39"] = {
{ "End the Terror", "Beendet den Alptraum", "Acaba con el terror", "Acaba con el terror", "Mettre fin à la terreur", "Fine del terrore", "공포의 종식", "O Fim do Terror", "Конец ужаса", "终结恐惧", "終結恐懼", }, 
{ "The Pool of Life", "Der Teich des Lebens", "La Poza de vida", "La Poza de vida", "Le bassin de vie", "La Pozza della Vita", "생명의 웅덩이", "A Fonte de Vida", "Источник жизни", "生命之池", "生命之池", }, 
{ "Search the Crypt", "Durchsucht die Krypta", "Investiga la cripta", "Investiga la cripta", "Fouiller la crypte", "Esplora la cripta", "납골당 수색", "Vasculhar a Cripta", "Поиски в гробнице", "搜索地穴", "搜尋墓穴", }, 
{ "Destroy the Sha", "Bezwingt das Sha", "Acaba con el sha", "Acaba con el sha", "Détruire le sha", "Distruggi l'Abominio", "샤를 파괴하라", "Destrua o Sha", "Уничтожьте ша", "消灭煞魔", "消滅煞", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["916"] = {
{ "Defend Tarren Mill", "Verteidigt Tarrens Mühle", "Defiende Molino Tarren", "Defiende el Molino Tarren", "La défense de Moulin-de-Tarren", "Difendere il Mulino di Tarren", "타렌 제분소 방어", "Defender Serraria Tarren", "Оборона мельницы Таррен", "保卫塔伦米尔", "守禦塔倫米爾", }, 
{ "Defeat the Demon Commander", "Bezwingt den Dämonenkommandanten", "Derrota al comandante demoníaco", "Derrota al Comandante demoníaco", "Terrasser le commandant démon", "Sconfiggere il comandante demoniaco", "악마 사령관 처치", "Derrotar o Demônio Comandante", "Победа над командиром демонов", "击败恶魔指挥官", "擊敗惡魔指揮官", }, 
{ "Repel the Legion Forces", "Schlagt die Streitkräfte der Legion zurück", "Rechaza a los ejércitos de la Legión", "Repele a las fuerzas de la Legión", "Repousser les troupes de la Légion", "Respingere le forze della Legione", "군단 격퇴", "Rechaçar as forças da Legião", "Отражение натиска Легиона", "击退燃烧军团的部队", "擊退燃燒軍團", }, 
{ "Defeat the Demon Lord", "Bezwingt den Dämonenfürsten", "Derrota al señor demoníaco", "Derrota al Señor demoníaco", "Terrasser le seigneur démon", "Sconfiggere il Signore dei Demoni", "악마 군주 처치", "Derrotar o lorde-demônio", "Смерть повелителю демонов", "击败恶魔领主", "擊敗惡魔領主", }, 
},
["551"] = {
{ "The Vortex Pinnacle", "Der Vortexgipfel", "La Cumbre del Vórtice", "La Cumbre del Vórtice", "La cime du Vortex", "Pinnacolo del Vortice", "소용돌이 누각", "Pináculo do Vórtice", "Вершина Смерча", "旋云之巅", "漩渦尖塔", }, 
},
["1073"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Judging Your Enemies", "Richtet Eure Feinde", "Juzgar a tus enemigos", "Enemigos bajo juicio", "Juger ses ennemis", "Giudicare i nemici", "심판의 날", "Julgar os inimigos", "Суд идет", "审判你的敌人", "審判敵人", }, 
{ "Bring Some Justice", "Im Namen der Gerechtigkeit", "Imparte justicia", "Que se haga justicia", "Rendre la justice", "Sete di giustizia", "심판을 받아라", "Trazendo a justiça", "Высшая мера наказания", "正义使者", "維護正義", }, 
{ "Crusading Around", "Kreuzfahrt", "Poderío cruzado", "Cruce de cruzadas", "En croisade", "Tra una crociata e l'altra", "신성한 기운", "Soltando o cruzado", "Во имя добра", "十字军征伐", "遍地聖擊", }, 
{ "What's the Verdict?", "Wie lautet das Urteil?", "¿Cuál es el veredicto?", "¿Cuál es el veredicto?", "Quel est le verdict ?", "Qual è il verdetto?", "신성한 선고", "Qual é o veredito?", "Каков ваш вердикт?", "裁决结果是？", "裁決結果如何？", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "A Storm Is Rising", "Ein Sturm zieht auf", "Se avecina una tormenta", "Se levanta una tormenta", "Une tempête se lève", "C'è una tempesta in arrivo", "몰려드는 폭풍", "Uma tempestade está se formando", "Грядет буря", "风暴来临", "風暴將至", }, 
{ "You're So Divine", "Ihr seid göttlich", "Eres divino", "Eres una divinura", "La divinité incarnée", "Hai un aspetto divino!", "천상의 사랑을 당신에게", "És divino", "Божественная недосягаемость", "如此圣洁", "你好神聖", }, 
{ "Flashing Lights", "Blitzlichter", "Luces deslumbrantes", "Luces resplandecientes", "Des éclairs de lumière", "Lampi luminosi", "섬광", "Luzes dardejantes", "Свет, дарующий исцеление", "闪现的圣光", "聖光閃閃", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault the Broken Shore", "Sturmangriff auf die Verheerte Küste", "Asalta la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 강습", "Ataque à Costa Partida", "Нападение на Расколотый берег", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["538"] = {
{ "Stormstout Brewery", "Brauerei Sturmbräu", "Cervecería del Trueno", "Cervecería del Trueno", "Brasserie Brune d’Orage", "Birrificio Triplo Malto", "스톰스타우트 양조장", "Cervejaria Malte do Trovão", "Хмелеварня Буйных Портеров", "风暴烈酒酿造厂", "風暴烈酒酒坊", }, 
},
["209"] = {
{ "Find Lost Explosives", "Findet den verlorenen Sprengstoff", "Encuentra los explosivos perdidos", "Encuentra los explosivos perdidos", "Trouver les explosifs perdus", "Trova gli esplosivi perduti", "잃어버린 폭탄을 찾아라", "Encontrar os explosivos perdidos", "Найти потерянную взрывчатку", "找到遗失的炸药", "尋找遺失的炸藥", }, 
{ "Deliver Explosives", "Liefert den Sprengstoff", "Entrega los explosivos", "Entrega los explosivos", "Livrer les explosifs", "Consegna gli esplosivi", "폭탄 전달", "Entregar os Explosivos", "Доставить взрывчатку", "运送炸药", "遞送炸藥", }, 
{ "Detonate Explosives", "Detoniert den Sprengstoff", "Detona los explosivos", "Detona los explosivos", "Faire détoner les explosifs", "Fai detonare gli esplosivi", "폭탄 폭파", "Detonar Explosivos", "Взрыв", "引爆炸药", "引爆炸藥", }, 
{ "Kill War-God Al'chukla", "Tötet Kriegsgott Al'chukla", "Mata al dios de la guerra Al'chukla", "Mata al dios de la guerra Al'chukla", "Tuer le dieu-guerrier Al’chukla", "Uccidi il Dio della Guerra Al'chukla", "전쟁신 알축라 처치", "Matar o Deus da Guerra Al'chukla", "Убейте бога войны Ал'чуклу", "击败战神阿尔图克拉", "殺死戰神阿裘卡拉", }, 
},
["645"] = {
{ "Scholomance", "Scholomance", "Scholomance", "Scholomance", "Scholomance", "Scholomance", "스칼로맨스", "Scolomântia", "Некроситет", "通灵学院", "通靈學院", }, 
},
["671"] = {
{ "Blackrock Depths", "Schwarzfelstiefen", "Profundidades de Roca Negra", "Profundidades de Roca Negra", "Profondeurs de Rochenoire", "Sotterranei di Roccianera", "검은바위 나락", "Abismo Rocha Negra", "Глубины Черной горы", "黑石深渊", "黑石深淵", }, 
{ "Ring of Law", "Ring des Gesetzes", "Círculo de la Ley", "Círculo de la Ley", "Cercle de la loi", "Anello della Legge", "법의 심판장", "Círculo da Lei", "Зал Правосудия", "秩序竞技场", "秩序競技場", }, 
{ "High Interrogator Gerstahn", "Verhörmeisterin Gerstahn", "Alta interrogadora Gerstahn", "Alta interrogadora Gerstahn", "Grande interrogatrice Gerstahn", "Gerstahn la Grande Accusatrice", "대심문관 게르스탄", "Suprema Interrogadora Gerstahn", "Верховный дознаватель Герштан", "审讯官格斯塔恩", "高階審問者格斯塔恩", }, 
{ "Bael'Gar", "Bael'Gar", "Bael'Gar", "Bael'Gar", "Bael’Gar", "Bael'gar", "밸가르", "Bael'gar", "Бейл'Гор", "贝尔加", "貝爾加", }, 
{ "The Grim Guzzler", "Zum Grimmigen Säufer", "Tragapenas", "Tragapenas", "Le Sinistre écluseur", "Il Torvo Beone", "험상궂은 주정뱅이 선술집", "O Glutão Implacável", "Трактир \"Угрюмый обжора\"", "黑铁酒吧", "黑鐵酒吧", }, 
{ "Phalanx", "Phalanx", "Falange", "Falange", "Phalange", "Falange", "팔랑크스", "Falange", "Фаланга", "法拉克斯", "法拉克斯", }, 
},
["675"] = {
{ "The Stonecore", "Der Steinerne Kern", "El Núcleo Pétreo", "El Núcleo Pétreo", "Le Cœur-de-Pierre", "Nucleo di Pietra", "바위심장부", "Litocerne", "Каменные Недра", "巨石之核", "石岩之心", }, 
},
["775"] = {
{ "Sounding the Charge", "Die Ladung ausloten", "Tocar a carga", "Sondeando la carga", "Sonner la charge", "All'attacco", "돌격하라!", "O soar da investida", "Сигнал к бою", "鸣响冲锋号", "出征的號角", }, 
{ "Crusaders' March", "Marsch der Kreuzfahrer", "La marcha de los cruzados", "Marcha de los Cruzados", "La marche des croisés", "La marcia dei crociati", "성전사들의 행진", "Marcha dos cruzados", "Марш рыцарей", "北伐军的远征", "十字軍的進擊", }, 
{ "Holy Vengeance", "Heilige Rache", "Venganza sagrada", "Venganza sagrada", "Vengeance sacrée", "Sacra vendetta", "성스러운 복수", "Vingança sagrada", "Священная месть", "神圣复仇", "神聖復仇", }, 
{ "The Ashbringer", "Der Aschenbringer", "La Crematoria", "La Crematoria", "Porte-Cendres", "Brandicenere", "파멸의 인도자", "A Crematória", "Испепелитель", "灰烬使者", "灰燼使者", }, 
{ "One Final Blessing", "Ein letzter Segen", "Una última bendición", "Una última bendición", "Une dernière bénédiction", "Un'ultima benedizione", "마지막 은총", "Uma bênção final", "Последнее благословение", "最后的祝福", "最後的祝福", }, 
{ "Balnazzar the Risen", "Balnazzar der Auferstandene", "Balnazzar el Alzado", "Balnazzar el Resucitado", "Balnazzar le Ressuscité", "Balnazzar il Risorto", "발나자르의 등장", "Balnazzar, o Ascendido", "Бальназар Восставший", "复生者巴纳扎尔", "復活的巴納札爾", }, 
{ "The Fate of the Highlord", "Das Schicksal des Hochlords", "El destino del Alto Señor", "El destino del Alto señor", "Le destin du généralissime", "Il destino del Gran Signore", "대영주의 운명", "O destino do Grão-Lorde", "Судьба Верховного лорда", "大领主的命运", "大領主的命運", }, 
},
["450"] = {
{ "A Vision Revealed", "Eine offenbarte Vision", "Una visión desvelada", "Una visión revelada", "Une vision révélée", "Una visione rivelatrice", "드러난 환영", "Uma Visão Revelada", "Видение прояснилось", "眼前的幻象", "揭露異象", }, 
{ "Enemy Onslaught", "Feindlicher Ansturm", "Ataque del enemigo", "Ataque enemigo", "Attaque ennemie", "Massacro dei nemici", "맹공격", "Massacre dos Inimigos", "Натиск врага", "敌军的突袭", "敵方猛攻", }, 
{ "Commander Vorka", "Kommandant Vorka", "Comandante Vorka", "Comandante Vorka", "Le commandant Vorka", "Comandante Vorka", "사령관 보르카", "Comandante Vorka", "Командир Ворка", "指挥官沃尔卡", "指揮官沃爾卡", }, 
{ "The Final Defense", "Die letzte Verteidigung", "La última línea de defensa", "La última defensa", "L’ultime défense", "Difesa finale", "최후의 항전", "A defesa final", "Решающий бой", "最后的防线", "最終防禦", }, 
},
["550"] = {
{ "Throne of the Tides", "Thron der Gezeiten", "Trono de las Mareas", "Trono de las Mareas", "Trône des marées", "Trono delle Maree", "파도의 왕좌", "Trono das Marés", "Трон Приливов", "潮汐王座", "海潮王座", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["609"] = {
{ "Shadow Labyrinth", "Schattenlabyrinth", "Laberinto de las Sombras", "Laberinto de las Sombras", "Labyrinthe des Ombres", "Labirinto delle Ombre", "어둠의 미궁", "Labirinto Soturno", "Темный лабиринт", "暗影迷宫", "暗影迷宮", }, 
},
["1280"] = {
{ "Into the Fray", "Auf ins Getümmel", "En el fragor de la batalla", "A la refriega", "Dans la mêlée", "Nel vivo della lotta", "참전", "Ao combate", "В гущу боя", "投入战斗", "身先士卒", }, 
{ "Vanguard of the Assault", "Vorhut des Angriffs", "Vanguardia del asalto", "Vanguardia del asalto", "L’avant-garde de l’assaut", "Avanguardia dell'assalto", "공격의 선봉", "Vanguarda do ataque", "Авангард нападения", "突击先锋", "突擊先鋒", }, 
{ "Might of the Legion", "Macht der Legion", "El poderío de la Legión", "El poder de la Legión", "Puissance de la Légion", "Vigore della Legione", "군단의 힘", "Poder da Legião", "Мощь Легиона", "军团力量", "軍團之力", }, 
{ "Rifts of Chaos", "Risse des Chaos", "Fallas del caos", "Fisuras del caos", "Failles de chaos", "Fenditure del caos", "혼돈의 균열", "Fissuras de caos", "Источник хаоса", "混乱裂隙", "混沌裂隙", }, 
{ "The Doomguard's Command", "Der Schreckenskommandant", "La orden del guardia apocalíptico", "La orden del guardia apocalíptico", "Le commandement la Garde funeste", "Il comandante dei Demoni Guardiani", "파멸수호병 사령관", "O comando do demonarca", "Командир повелителей ужаса", "末日守卫的命令", "末日守衛的命令", }, 
{ "Gateway to Ruin", "Weg in den Ruin", "Portal a la ruina", "Portal hacia las ruinas", "Portail vers le vaisseau de la Légion Ruine", "Sull'ammiraglia della Legione", "파멸로 가는 관문", "Portal para a ruína", "Врата разрушения", "毁灭之门", "通往毀滅", }, 
{ "Pillar of Fire", "Feuersäule", "Pilar de fuego", "Pilar de fuego", "Pilier de feu", "Distruggere l'Ammiraglia", "불기둥", "Pilar de Fogo", "Столп огня", "火焰之柱", "烈焰火柱", }, 
{ "Mephistroth", "Mephistroth", "Mephistroth", "Mephistroth", "Méphistroth", "Mefistroth", "메피스트로스", "Mephistroth", "Мефистрот", "孟菲斯托斯", "梅菲斯托", }, 
},
["1007"] = {
{ "Heal Taran Zhu", "Heilt Taran Zhu", "Sanar a Taran Zhu", "Sana a Taran Zhu", "Soigner Taran Zhu", "Curare Taran Zhu", "타란 주 치유", "Cure Taran Zhu", "Исцеление Тажаня Чжу", "治疗祝踏岚", "治療塔蘭‧祝", }, 
{ "Rescue the Shado-Pan", "Rettet die Shado-Pan", "Rescatar a los miembros del Shadopan", "Rescata a los Shadopan", "Sauver les Pandashan", "Salvare gli Shandaren", "음영파 구출", "Resgate os Shado-Pan", "Спасение Шадо-Пан", "解救影踪派", "解救影潘", }, 
{ "The Shado-Plan", "Der Shado-Plan", "El Shadoplan", "El plan de los Shadopan", "Le plan-dashan", "Gli Shandaren", "음영파", "O Shado-Plano", "Шадо-План", "影踪派", "影潘計畫", }, 
{ "Don't Drink the Water", "Trinkt nicht das Wasser", "Agua que no has de beber...", "Agua que no has de beber...", "Ne buvez pas l’eau", "Non bere l'acqua", "마실 수 없는 물", "Água que passarinho não bebe", "Не пей эту воду!", "这水有毒", "別喝那裡的水", }, 
{ "The Emperor's Final Gift", "Das letzte Geschenk des Kaisers", "El último regalo del Emperador", "El don final del emperador", "Le dernier cadeau de l’empereur", "Il dono finale dell'Imperatore", "황제의 마지막 선물", "O último presente do imperador", "Последний дар императора", "皇帝最后的礼物", "大帝的遺贈", }, 
},
["626"] = {
{ "Auchenai Crypts", "Auchenaikrypta", "Criptas Auchenai", "Criptas Auchenai", "Cryptes Auchenaï", "Cripte degli Auchenai", "아키나이 납골당", "Catacumbas Auchenai", "Аукенайские гробницы", "奥金尼地穴", "奧奇奈地穴", }, 
},
["1094"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "Bringing Out The Dead", "Die Toten auf den Plan rufen", "Recurrir a los muertos", "Aparición de los muertos", "Apportez vos morts !", "Rianimare i morti", "망자의 부활", "Trazer os mortos", "Беспокойство для покойных", "召唤亡者", "人死可以復生", }, 
{ "Spreading your Disease", "Eure Krankheit verbreiten", "Contagio masivo", "Propagando el virus", "Propagation de la maladie", "Diffondere il morbo", "질병 퍼뜨리기", "Disseminando a doença", "Расползающаяся зараза", "传播你的疾病", "傳染疾病", }, 
{ "It Festers", "Es schwärt so schön...", "Pus a espuertas", "Efecto degenerativo", "Écoulement de pus", "Problemi di infezione", "부패하는 상처", "Isso infecciona", "Гниющие раны", "溃烂吧！", "大爛人", }, 
{ "Harnessing the Scourge", "Die Geißel zunutze machen", "Dominar la Plaga", "Controlando la Plaga", "Le Fléau maîtrisé", "Scatenare il Flagello", "스컬지의 힘으로", "Controlando o Flagelo", "Овладеть силой Плети", "驾驭天灾的力量", "駕馭天譴", }, 
{ "Coiled, and Ready to Attack", "Den Mantel des Todes ausbreiten", "Espiral de ataque", "Enrollada y lista para atacar", "Décharge d’énergie impie", "Morte imminente", "치명적인 고리", "Bote armado, e pronto para atacar", "Лик, внушающий страх", "缠绕攻击", "纏繞突襲", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Healing on the Offense", "Offensives Heilen", "Sanación ofensiva", "Sanación de la ofensiva", "Attaque curative", "La miglior difesa è l'attacco", "공격적인 치유", "Cura na ofensiva", "Нападение вместо лекарства", "进攻亦是治疗", "攻擊是最好的防守", }, 
{ "Get Over Here!", "Hierher!", "¡Ven aquí!", "¡Ven aquí!", "Par ici !", "Vieni qui!", "걸려들어라!", "Venha aqui!", "Ближе. Еще ближе...", "过来吧！", "給我過來！", }, 
{ "Raising Some Friends", "Aufgeweckte Freunde", "Despertar a unos amigos", "Reclutando a algunos amigos", "Amis nécrosés", "Radunare alcuni amici", "죽은 자의 귀환", "Levantar alguns amigos", "Подмога с того света", "呼朋唤友", "找些好兄弟", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["742"] = {
{ "Invasion", "Invasion", "Invasión", "Invasión", "L'invasion", "Invasione", "침략", "Invasão", "Нападение", "入侵", "入侵", }, 
{ "The Scouting Party", "Der Spähtrupp", "El grupo de exploración", "El grupo explorador", "Le groupe d’éclaireurs", "Il gruppo di esploratori", "정찰대", "O Grupo de Batedores", "Разведывательный отряд", "斥候小队", "偵察隊", }, 
{ "Hold Out!", "Haltet durch!", "¡Aguanta!", "¡Aguanta!", "Accrochez-vous !", "Non cedere!", "항전!", "Aguentem!", "Стоять до последнего!", "坚持住！", "堅持到底！", }, 
{ "Cleanup", "Aufräumkommando", "Limpieza", "Limpieza", "Nettoyage", "Ripulitura", "소탕", "Limpeza", "Зачистка", "摧枯拉朽", "收拾殘局", }, 
{ "The Calm", "Ruhe nach dem Sturm", "La calma", "La calma", "Le calme", "La calma", "정적", "A Calma", "Затишье", "风平浪静", "歇息備戰", }, 
{ "Commander's Fall", "Fall des Kommandanten", "La caída del comandante", "La caída del comandante", "La chute d’un commandant", "La caduta del comandante", "지휘관의 죽음", "A Ruína do Comandante", "Падение вождя", "指挥官的陨落", "指揮官之死", }, 
},
["663"] = {
{ "Earth Song Falls", "Fälle des Irdenen Gesangs", "Cascadas del Canto de la Tierra", "Cascadas del Canto de la Tierra", "Chutes de Chanteterre", "Cascate Cantaterra", "대지노래 폭포", "Cachoeiras da Canção Telúrica", "Поющие водопады", "地歌瀑布", "地歌瀑布", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["558"] = {
{ "Halls of Origination", "Hallen des Ursprungs", "Cámaras de los Orígenes", "Cámaras de los Orígenes", "Salles de l’Origine", "Sale della Creazione", "시초의 전당", "Salões Primordiais", "Чертоги Созидания", "起源大厅", "起源大廳", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["571"] = {
{ "Pit of Saron", "Grube von Saron", "Foso de Saron", "Foso de Saron", "Fosse de Saron", "Fossa di Saron", "사론의 구덩이", "Fosso de Saron", "Яма Сарона", "萨隆矿坑", "薩倫之淵", }, 
},
["1182"] = {
{ "Combat Training", "Kampftraining", "Instrucción de combate", "Instrucción de combate", "Entraînement au combat", "Addestramento al combattimento", "전투 훈련", "Treino de combate", "Боевые учения", "战斗训练", "戰鬥訓練", }, 
{ "A Lick of Fire", "Ein Schlückchen Feuer", "Un chorrito de fuego", "Un chorrito de fuego", "La bouche en feu", "Una punta di fuoco", "불 한 입", "Uma pincelada de fogo", "Капельку огня", "烈焰舔舐", "添些火焰", }, 
{ "Can't Stop The Rock", "Den Stein ins Rollen bringen", "Roca invencible", "Un movimiento imparable", "Rien n’arrête le roc", "Rocce implacabili", "바위를 막을 순 없다", "Não se pode deter a Pedra", "Тверд, как скала", "无法阻挡巨石", "巨石強身", }, 
{ "Lashing Out", "Die Peitsche schwingen", "A latigazo limpio", "Gran arremetida", "Flagellation", "Battute sferzanti", "채찍을 휘둘러라", "Só no açoite", "Иногда нужно выпустить пар", "猛击", "火口噴人", }, 
{ "Hero of the Storm", "Held des Sturms", "Héroe de la tormenta", "Héroe de la Tormenta", "Héros de la tempête", "Eroe della Tempesta", "폭풍의 영웅", "Herói da tempestade", "Герой бури", "风暴英雄", "風暴英雄", }, 
{ "Putting It All Together", "Das große Ganze", "Juntar las piezas", "Todas las piezas juntas", "Mise en pratique", "Mettersi alla prova", "종합주문세트", "Fixação de conteúdo", "Сборная солянка", "综合在一起", "準備完善", }, 
{ "Ribbit,  Ribbit.", "Quaaak, quaaak.", "Croac, croac", "Croac, croac.", "Coâ, coâ !", "Cra, cra!", "개굴, 개굴", "Croac, croac.", "Кто сказал \"ква\"?", "呱，呱", "嘓嘓，嘓嘓", }, 
{ "Dousing Your Wounds", "Eine Welle der Heilung", "Empapa tus heridas", "Empapando las heridas", "Doux apaisement", "Lavarsi le ferite", "상처 돌보기", "Fechar as feridas", "Ванна из целебного бальзама", "浸泡伤口", "清理傷口", }, 
{ "Spiritual Assistance", "Geistiger Beistand", "Ayuda espiritual", "Ayuda espiritual", "Assistance spirituelle", "Supporto Spirituale", "영적 도움", "Auxílio espiritual", "Помощники из тонкого мира", "灵魂协助", "靈魂相助", }, 
{ "A Quick Test", "Schnelltest", "Una prueba rápida", "Una prueba rápida", "Un test rapide", "Una piccola prova", "깜짝 시험", "Teste rápido", "Испытание тет-а-тет", "快速测试", "隨堂考", }, 
{ "Twice the Challenge", "Doppelte Herausforderung", "Desafío por partida doble", "Un desafío doble", "Double défi", "Doppia sfida", "난이도 두 배", "Desafio em dose dupla", "Двойной вызов", "双倍挑战", "雙重挑戰", }, 
{ "Defend Against the Legion Assault", "Den Angriff der Legion abwehren", "Defiéndete del asalto de la Legión", "Defiéndete contra el ataque de la Legión", "Défense contre l’assaut de la Légion", "Difesa contro la Legione", "군단의 공격 막아내기", "Defender contra o ataque da Legião", "Оборона против Легиона", "在军团的攻击下保卫飞艇", "抵擋燃燒軍團的攻擊", }, 
{ "Assault on Broken Shore", "Angriff auf die Verheerte Küste", "Asalto a la Costa Abrupta", "Asalto a la Costa Quebrada", "L’assaut du rivage Brisé", "Assalto alla Riva Dispersa", "부서진 해변 공격", "Ataque à Costa Partida", "Штурм Расколотого берега", "突袭破碎海滩", "突襲破碎海岸", }, 
},
["806"] = {
{ "Defend Gadgetzan", "Verteidigt Gadgetzan", "Defiende Gadgetzan", "Protege a Gadgetzan", "La défense de Gadgetzan", "Difendi Meccania", "가젯잔 방어", "Defenda Geringontzan", "Оборона Прибамбасска", "保卫加基森", "守禦加基森", }, 
{ "Defeat the Demon Commanders", "Bezwingt den Dämonenkommandanten", "Derrota a los comandantes demoníacos", "Derrota a los Comandantes demoníacos", "Terrasser les commandants démons", "Sconfiggere i comandanti demoniaci", "악마 사령관 처치", "Derrote os Demônios Comandantes", "Победа над командирами Легиона", "击败恶魔指挥官", "擊敗惡魔指揮官", }, 
{ "Repel the Legion Forces", "Schlagt die Streitkräfte der Legion zurück", "Rechaza a los ejércitos de la Legión", "Repele a las fuerzas de la Legión", "Repousser les troupes de la Légion", "Respingere le forze della Legione", "군단 격퇴", "Rechace as forças da Legião", "Отражение натиска Легиона", "击退军团部队", "擊退燃燒軍團", }, 
{ "Defeat the Demon Lord", "Bezwingt den Dämonenfürsten", "Derrota al señor demoníaco", "Derrota al Señor demoníaco", "Terrasser le seigneur démon", "Sconfiggere il Signore dei Demoni", "악마 군주 처치", "Derrotar o lorde-demônio", "Смерть повелителю демонов", "击败恶魔领主", "擊敗惡魔領主", }, 
},
["610"] = {
{ "The Black Morass", "Der Schwarze Morast", "La Ciénaga Negra", "La Ciénaga Negra", "Le Noir marécage", "Palude Nera", "검은늪", "Lamaçal Negro", "Черные топи", "黑色沼泽", "黑色沼澤", }, 
},
["1251"] = {
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
{ "Assault on Violet Hold", "Sturm auf die Violette Festung", "Asalto al Bastión Violeta", "Ataque al Bastión Violeta", "L’assaut sur le fort Pourpre", "Assalto alla Fortezza Violacea", "보랏빛 요새 침공", "Ataque ao Castelo Violeta", "Штурм Аметистовой крепости", "突袭紫罗兰监狱", "紫羅蘭堡之襲", }, 
},
["1273"] = {
{ "A Brother Betrayed", "Der betrogene Bruder", "Traición fraternal", "Traición fraternal", "La trahison d’un frère", "Fratello traditore", "배신당한 형제", "Traição fraterna", "Преданный брат", "背叛的手足", "背叛的兄弟", }, 
{ "The Prophecy Denied", "Der Prophezeiung zum Trotze", "La profecía negada", "La profecía rechazada", "Prophétie annulée", "La profezia negata", "빗나간 예언", "Profecia negada", "Несбывшееся пророчество", "未实现的预言", "預言成空", }, 
},
["617"] = {
{ "Magisters' Terrace", "Terrasse der Magister", "Bancal del Magister", "El Bancal del Magister", "La terrasse des Magistères", "Terrazza dei Magisteri", "마법학자의 정원", "Terraço dos Magísteres", "Терраса Магистров", "魔导师平台", "博學者殿堂", }, 
},
["745"] = {
{ "Invasion!", "Invasion!", "¡Invasión!", "¡Invasión!", "Alerte aux envahisseurs !", "Invasione!", "침략!", "Invasão!", "Нападение!", "入侵！", "入侵！", }, 
{ "Ambush", "Hinterhalt", "Emboscada", "Emboscada", "Embuscade", "Imboscata", "습격", "Emboscada", "Засада", "伏击", "伏擊", }, 
{ "The Holdout", "Durchhaltevermögen", "La resistencia", "La resistencia", "Le baroud", "Resistenza", "항전", "A Resistência", "Продержаться подольше", "坚持到底", "堅持到底", }, 
{ "Cleanup", "Aufräumkommando", "Limpieza", "Limpieza", "Nettoyage", "Ripulitura", "소탕", "Limpeza", "Зачистка", "摧枯拉朽", "收拾殘局", }, 
{ "The Calm", "Ruhe nach dem Sturm", "La calma", "La calma", "Le calme", "La calma", "정적", "A Calma", "Затишье", "风平浪静", "歇息備戰", }, 
{ "Shadows Gather", "Der Schatten wächst", "Las sombras se ciernen", "Las sombras se reúnen", "Les ombres se rassemblent", "Le ombre si addensano", "어둠이 드리운다", "A reunião das sombras", "Тени сгущаются", "暗影蔽日", "暗影集結", }, 
},
["1034"] = {
{ "Engage the Enemy", "Schlachterzwingung", "Enfrentarse al enemigo", "Enfréntate al enemigo", "Sus à l’ennemi", "Affrontare il nemico", "공포의 군주와 교전", "Enfrente o inimigo", "Столкновение с врагом", "交战", "與敵人交戰", }, 
{ "The Forge Restrained", "Die gebundene Schmiede", "La Forja bajo control", "La Forja contenida", "La forge amoindrie", "Contenere la Forgia", "억제된 가열로", "A forja diminuída", "Скованное Горнило", "熔炉重生", "受制的熔爐", }, 
{ "The Power of the Guardians", "Die Macht der Wächter", "El poder de los guardianes", "El poder de los Guardianes", "Le pouvoir des Gardiens", "Il potere dei Guardiani", "수호자의 힘", "O poder dos Guardiões", "Сила Хранителей", "守护者之力", "守護者的力量", }, 
{ "The Dreadlord's Downfall", "Der Niedergang des Schreckenslords", "La caída del Señor del Terror", "La caída del Señor del Terror", "La chute du seigneur de l’effroi", "La caduta del Signore del Terrore", "공포의 군주 처치", "A queda do Senhor do Medo", "Падение повелителя ужаса", "恐惧魔王的败亡", "驚懼領主的落敗", }, 
{ "A Small Victory", "Ein kleiner Sieg", "Una pequeña victoria", "Una pequeña victoria", "Modeste victoire", "Una piccola vittoria", "작은 승리", "Uma pequena vitória", "Маленькая победа", "小小的胜利", "小小的勝利", }, 
{ "Keep it Secret, Keep it Safe", "Haltet es geheim, bewahrt es gut", "En secreto y a salvo", "No se lo digas a nadie", "Un secret bien gardé", "Mettere al sicuro", "은밀하게 안전하게", "O segredo do negócio é o segredo", "Тайное и надежное место", "注意保密，注意安全", "保守秘密，保守安全", }, 
},
["427"] = {
{ "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "Auchindoun", "아킨둔", "Auchindoun", "Аукиндон", "奥金顿", "奧齊頓", }, 
},
["670"] = {
{ "Upper City", "Oberes Viertel", "Alto Arrabal", "Ciudad superior", "Ville haute", "Città Alta", "상부 도시", "Cidade Alta", "Верхний Город", "上层区", "上城區", }, 
},
["58"] = {
{ "Scar-Shell", "Narbenpanzer", "Escaraza", "Escaraza", "Ecaille-balafrée", "Gamara", "흉터껍질", "Conchagas", "Потертый Панцирь", "刀疤壳", "疤殼", }, 
{ "Jol'Grum", "Jol'Grum", "Jol'Grum", "Jol'Grum", "Jol’Grum", "Jol'grum", "졸그럼", "Jol'Grum", "Джол'Грум", "乔古鲁", "悠格魯姆", }, 
{ "Little Liuyang", "Klein Liuyang", "Pequeña Liuyang", "Pequeña Liuyang", "Petite Liuyang", "Piccola Liuyang", "꼬마 리우양", "Pequena Liuyang", "Малышка Люян", "小流炀", "小劉楊", }, 
{ "Chagan Firehoof", "Chagan Feuerhuf", "Chagan Pezuña Ígnea", "Chagan Pezuña Ígnea", "Chagan Sabot-de-Feu", "Chagan Ardizampa", "차간 파이어후프", "Chagan Casco de Fogo", "Чаган Огненное Копыто", "查干·焰蹄", "查剛·火蹄", }, 
{ "Defeat the Final Challenger!", "Bezwingt den letzten Herausforderer!", "¡Derrota al contendiente final!", "¡Derrota al contendiente final!", "Vaincre l’adversaire final !", "Sconfiggi lo Sfidante Finale!", "마지막 도전자를 처치하라!", "Derrote o Desafiante Final!", "Победите последнего противника!", "击败最终的挑战者！", "擊敗最後挑戰者!", }, 
},
["991"] = {
{ "The Twilight Camp", "Der Stützpunkt des Schattenhammers", "El Campamento Crepuscular", "El campamento del Martillo Crepuscular", "Le campement du Crépuscule", "L'accampamento del Crepuscolo", "황혼의 야영지", "O Acampamento do Crepúsculo", "Сумеречный лагерь", "暮光营地", "暮光營地", }, 
{ "Raiding the Tomb Raiders", "Die Grabräuber berauben", "Asaltar a los asaltantes de tumbas", "Asalto a los cazadores de tumbas", "Sus aux pilleurs de tombe", "Incursione contro i Predatori di Tombe", "도굴꾼의 최후", "Saqueando os saqueadores de tumbas", "Ограбление грабителей могил", "螳螂捕蝉", "追殺盜墓者", }, 
{ "The Desecrated Tomb", "Das entweihte Grab", "La tumba profanada", "La tumba profanada", "Le tombeau profané", "La tomba sconsacrata", "훼손된 무덤", "A tumba profanada", "Оскверненная гробница", "被亵渎的古墓", "被褻瀆的陵墓", }, 
{ "The Tomb of Tyr", "Tyrs Grabmal", "La Tumba de Tyr", "La Tumba de Tyr", "Le tombeau de Tyr", "Tomba di Tyr", "티르의 무덤", "A tumba de Tyr", "Гробница Тира", "提尔之墓", "提爾之墓", }, 
{ "Reconsecration", "Wiederweihe", "Nueva consagración", "Reconsagración", "Réhabilitation sacrée", "Riconsacrazione", "신성불가침", "Reconsagração", "Повторное освящение", "再次净化", "再次奉獻", }, 
{ "Don't Fear the Reaper", "Keine Angst vorm Eisenmann", "No temas al segador", "No temas al segador", "Ne craignez pas le faucheur", "Non temere il mietitore", "공허를 두려워 말라", "Não tema o ceifador", "Не бойся Жнеца", "浑身是胆", "別害怕死亡", }, 
{ "Dark Passage", "Dunkle Passage", "Pasadizo oscuro", "Pasaje oscuro", "Passage obscur", "Passaggio oscuro", "어둠의 통로", "Passagem sombria", "Темный путь", "黑暗通道", "黑暗通道", }, 
{ "Death to the Deacon", "Tod dem Diakon", "Muerte al diácono", "Muerte al Diácono", "Mort au diacre", "Morte al Diacono", "부제에게 죽음을", "Morte ao Diácono", "Смерть Дьякону", "执事之死", "執事之死", }, 
{ "The Blade of the Black Empire", "Die Klinge des schwarzen Imperiums", "La Daga del Imperio Negro", "La Espada del Imperio Negro", "La lame de l’empire noir", "La Lama dell'Impero Nero", "검은 제국의 비수", "A Lâmina do Império Negro", "Клинок Темной Империи", "黑暗帝国之刃", "黑暗帝國之刃", }, 
{ "The True Death of Zakajz", "Der wahre Tod von Zakajz", "La verdadera muerte de Zakajz", "La muerte definitiva de Zakajz", "La véritable mort de Zakajz", "La vera morte di Zakajz", "마침내 죽은 자카이즈", "A verdadeira morte de Zakajz", "Окончательная смерть Закажа", "扎卡兹的彻底死亡", "扎卡茲真正死亡", }, 
},
["269"] = {
{ "Tutorial", "Einweisung", "Tutorial", "Tutorial", "Apprentissage", "Tutorial", "연습", "Tutorial", "Обучение", "教学", "教學導覽", }, 
{ "Noodle Time", "Nudelzeit", "La hora de los fideos", "La hora de los fideos", "L’heure des nouilles", "Spaghetti a volontà", "국수 시간", "Hora do Macarrão", "Час лапши", "汤面时间", "湯麵時刻", }, 
},
["628"] = {
{ "Mana-Tombs", "Managruft", "Tumbas de Maná", "Tumbas de Maná", "Tombes-mana", "Tombe del Mana", "마나 무덤", "Tumbas de Mana", "Гробницы Маны", "法力陵墓", "法力墓地", }, 
},
["1281"] = {
{ "The Landing", "Die Landestelle", "El rellano", "El alto", "L’entrée", "L'approdo", "층계참", "A plataforma", "Гнездовье", "平台", "平臺", }, 
{ "Searching for the Rook", "Suche in der Rabenwehr", "En busca del grajo", "La búsqueda de la torre", "La fouille du Freux", "Forte Corvonero", "떼까마귀 탐색", "Vasculhar o castelo", "Поиски в крепости", "搜索堡垒", "搜查玄鴉堡", }, 
{ "Desperate Times", "Verzweifelte Zeiten", "Tiempos desesperados", "Tiempos desesperados", "Une situation désespérée", "Tempi duri", "절박한 시간", "Tempos de desespero", "Большие проблемы", "情势危急", "危急時刻", }, 
{ "What Lies Ahead", "Der Weg vor uns", "Lo que espera", "Lo que espera adelante", "Un avenir incertain", "Cosa ci attende", "저 앞에 기다리는 것", "O que há à frente", "Это еще не все", "前方的路", "前往何方", }, 
{ "Erdris and the Risen", "Erdris und die Auferstandenen", "Erdris y los resucitados", "Erdris y los resucitados", "Erdris et les ressuscités", "Erdris e i risorti", "에르드리스와 되살아난 자들", "Erdris e os Reerguidos", "Эрдрис и его восставшая армия", "艾德里斯与亡者", "厄德里斯與亡靈部隊", }, 
{ "Rise, Soldiers!", "Erhebt Euch, Soldaten!", "¡Alzaos, soldados!", "¡Levántense, soldados!", "Levez-vous, soldats !", "Risorgete, soldati!", "일어나라, 병사들이여!", "Ergam-se, soldados!", "Восстаньте, воины!", "站起来，士兵们！", "起來吧，士兵！", }, 
{ "A Thorn in the Side", "Ein Dorn im Auge", "Una espina en el costado", "Una espina clavada", "Une épine dans le flanc", "Una spina nel fianco", "내가 쏜 우두머리", "Um espinho no flanco", "Корень зла", "肉中刺", "芒刺在背", }, 
},
["68"] = {
{ "The Lorewalker's Fate", "Das Schicksal der Lehrensucherin", "El destino del eremita", "El destino del eremita", "Le destin de la chroniqueuse", "Il destino del Ramingo della Sapienza", "전승지기의 운명", "O Destino da Andarilha das Lendas", "Судьба хранителя истории", "游学者的命运", "博學行者的命運", }, 
{ "Rescue the Golden Lotus", "Rettet den Goldenen Lotus", "Rescata a El Loto Dorado", "Rescata a El Loto Dorado", "Sauver le Lotus doré", "Salva il Loto Dorato", "황금 연꽃 원정대 구출", "Resgate o Lótus Dourado", "Спасение Золотого Лотоса", "拯救金莲教", "拯救金蓮會", }, 
{ "Stop the Execution", "Stoppt die Hinrichtung", "Detén la ejecución", "Detén la ejecución", "Empêcher l’exécution", "Impedisci l'esecuzione", "처형을 막아라", "Impeça a Execução", "Остановка казни", "刀下留人", "刀下留人", }, 
{ "Capture the Artifacts", "Erobert die Artefakte", "Hazte con los artefactos", "Hazte con los artefactos", "Capturer les artéfacts", "Conquista i Manufatti", "유물 확보", "Capture os Artefatos", "Захват реликвий", "夺取神器", "奪取神器", }, 
{ "Kill General Zhun", "Tötet General Zhun", "Mata al general Zhun", "Mata al general Zhun", "Tuer le général Zhun", "Uccidi il Generale Zhun", "장군 준 처치", "Mate o General Zhun", "Убийство генерала Чжуня", "杀死烛桓将军", "殺死曾將軍", }, 
},
["667"] = {
{ "Gordok Commons", "Gordokhallen", "Ágora de Gordok", "Ágora de Gordok", "Communs gordok", "Sale di Gordok", "고르독 광장", "Pátio Gordok", "Палаты Гордока", "戈多克议会", "戈多克平民區", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
{ "Bonus Objective", "Bonusziel", "Objetivo de bonificación", "Objetivo de bonificación", "Objectif bonus", "Obiettivo bonus", "추가 목표", "Objetivo bônus", "Дополнительная задача", "奖励目标", "獎勵目標", }, 
},
["1289"] = {
{ "Lower Return to Karazhan", "Untere Rückkehr nach Karazhan", "Regreso a Karazhan inferior", "Regreso inferior a Karazhan", "Retour à Karazhan (bas)", "Ritorno a Karazhan Inferiore", "다시 찾은 카라잔 하층", "Retorno a Karazhan inferior", "Возвращение в Каражан (нижняя часть)", "重返卡拉赞（下层）", "重返卡拉贊下層", }, 
},
["184"] = {
{ "The Flight Master", "Der Flugmeister", "El maestro de vuelo", "El maestro de vuelo", "Le maître de vol", "Il Maestro di Volo", "비행 조련사", "O Mestre de Voo", "Распорядитель полетов", "飞行管理员", "飛行管理員", }, 
{ "Death on the Docks", "Tod auf den Docks", "Muerte en los muelles", "Muerte en los muelles", "Mort sur les quais", "Morte sui moli", "부두에서의 격전", "Morte nas Docas", "Смерть на пристани", "死守码头", "死亡碼頭", }, 
{ "Reclaim the Court!", "Die Rückeroberung des Hofes!", "¡Reclama la corte!", "¡Reclama la corte!", "Reprenez la cour !", "Riconquista la corte!", "요새를 되찾아라!", "Domine o Pátio!", "Возвращение контроля над двором", "夺回庭院！", "收復中庭!", }, 
{ "The High Marshal", "Der Hochmarschall", "El alto mariscal", "El alto mariscal", "Le haut maréchal", "Il Gran Maresciallo", "대장군", "O Grão-marechal", "Верховный маршал", "大元帅", "大元帥", }, 
{ "Legwork", "Lauferei", "Trabajo preliminar", "Trabajo preliminar", "Travail sur le terrain", "Raccolta informazioni", "탐문 조사", "Pernadas", "Беготня", "外勤工作", "跑腿", }, 
{ "Setting Up", "Vorbereitung", "Tanto monta, monta tanto", "Tanto monta, monta tanto", "Préparatifs", "Preparare le difese", "방어 준비", "Preparar Armas", "Установка", "装备中", "做好準備", }, 
{ "Hold the Line!", "Weicht nicht zurück!", "¡Mantén la formación!", "¡Mantén la formación!", "Tenir le front !", "Difendi la posizione!", "전선을 사수하라!", "Mantenham a Formação!", "Держать строй!", "坚守阵地！", "守住陣線!", }, 
},
["641"] = {
{ "The Deadmines", "Die Todesminen", "Las Minas de la Muerte", "Las Minas de la Muerte", "Les Mortemines", "Miniere della Morte", "죽음의 폐광", "Minas Mortas", "Мертвые копи", "死亡矿井", "死亡礦坑", }, 
},
["685"] = {
{ "Iron Docks", "Eisendocks", "Puerto de Hierro", "Muelles de Hierro", "Quais de Fer", "Darsena di Ferro", "강철 선착장", "Docas de Ferro", "Железные доки", "钢铁码头", "鋼鐵碼頭", }, 
},
["449"] = {
{ "Defeat Arnokk the Burner", "Bezwingt Arnokk den Brenner", "Derrota a Arnokk el Quemador", "Derrota a Arnokk el Abrasador", "Vaincre Arnokk le Brûleur", "Sconfiggi Arnokk il Piromane", "방화광 아르노크 처치", "Derrotar Arnokk, o Incendiário", "Победите Арнокка Сжигателя", "击败炽燃者阿诺克", "擊敗『燃燒者』阿諾克", }, 
{ "Meet Yrel at the Karabor Harbor", "Trefft Yrel am Hafen von Karabor", "Reúnete con Yrel en el Puerto de Karabor", "Reúnete con Yrel en el Puerto de Karabor", "Rencontrer Yrel au port de Karabor", "Raggiungi Yrel presso il Porto di Karabor", "카라보르 항만에서 이렐 만나기", "Encontre Yrel no Porto de Karabor", "Встреча с Ирель в гавани Карабора", "在卡拉波港口与伊瑞尔见面", "在卡拉伯爾港與伊芮爾碰面", }, 
{ "Protect K'ara from the invading forces", "Beschützt K'ara vor den eindringenden Streitkräften", "Protege a K'ara de los invasores", "Protege a K'ara de las fuerzas invasoras", "Protéger K’ara des envahisseurs", "Proteggi K'ara dagli assalitori", "칩입자에게서 크아라 지키기", "Proteger K'ara das forças invasoras.", "Защитите К'ару от захватчиков", "保护卡拉不受入侵者的伤害", "保護卡拉不受入侵敵軍的威脅", }, 
{ "Kill Commander Vorka!", "Tötet Kommandant Vorka!", "¡Mata al comandante Vorka!", "¡Mata al comandante Vorka!", "Vaincre le commandant Vorka", "Uccidi il Comandante Vorka", "사령관 보르카 처치!", "Mate o Comandante Vorka!", "Убить командира Ворку!", "击败指挥官沃尔卡！", "殺死指揮官沃爾卡！", }, 
},
["584"] = {
{ "Halls of Stone", "Die Hallen des Steins", "Cámaras de Piedra", "Las Cámaras de Piedra", "Les salles de Pierre", "Sale della Pietra", "돌의 전당", "Salões Rochosos", "Чертоги Камня", "岩石大厅", "石之大廳", }, 
},
["649"] = {
{ "Gnomeregan", "Gnomeregan", "Gnomeregan", "Gnomeregan", "Gnomeregan", "Gnomeregan", "놈리건", "Gnomeregan", "Гномреган", "诺莫瑞根", "諾姆瑞根", }, 
{ "Grubbis defeated", "Grubbis bezwungen", "Grubbis derrotado", "Grubbis derrotado", "Grubbis vaincu", "Sconfiggi Grubbis", "그루비스 처치", "Grúdio derrotado", "Грязнюк повержен", "击败格鲁比斯", "擊敗格魯比斯", }, 
{ "Viscous Fallout defeated", "Verflüssigte Ablagerung bezwungen", "Radiactivo viscoso derrotado", "Radiactivo viscoso derrotado", "Retombée visqueuse vaincue", "Sconfiggi la Scoria Viscosa", "방사성 폐기물 처치", "Precipitação Radioativa Viscosa derrotada", "Липкая муть повержена", "击败粘性辐射尘", "擊敗黏性輻射塵", }, 
{ "Electrocutioner 6000 defeated", "Elektrokutor 6000 bezwungen", "Electrocutor 6000 derrotado", "Electrocutor 6000 derrotado", "Electrocuteur 6000 vaincu", "Elettrocuz 6000", "기계화 문지기 6000 처치", "Eletrocutor 6000 derrotado", "\"Электрошокер 6000\" повержен", "击败电刑器6000型", "擊敗電刑器6000型", }, 
{ "Crowd Pummeler 9-60 defeated", "Meuteverprügler 9-60 bezwungen", "Golpeamasa 9-60 derrotado", "Golpeamasa 9-60 derrotado", "Faucheur de foule 9-60 vaincu", "Sconfiggi il Pungolatore 9-60", "고철 압축기 9-60 처치", "Espanca-gente 9-60 derrotado", "\"Толпогон 9-60\" повержен", "击败群体打击者9-60", "擊敗群體打擊者9-60", }, 
},
["1157"] = {
{ "The Return to Light's Hope", "Rückkehr zum Hoffnungsvollen Licht", "El regreso a Esperanza de la Luz", "El regreso a la Esperanza de la Luz", "Le retour à l’Espoir de Lumière", "Ritorno alla Cappella della Luce", "희망의 빛으로 돌아가기", "Retorno à Esperança da Luz", "Возвращение в Часовню Последней Надежды", "回到圣光之愿", "回到聖光之願", }, 
{ "Preparations", "Vorbereitungen", "Preparativos", "Preparativos", "Les préparatifs", "Preparativi", "준비", "Os preparativos", "Приготовления", "备战", "做好準備", }, 
{ "Upon the Hill of No Return", "Auf dem Hügel ohne Widerkehr", "En la colina sin retorno", "Sobre la Colina del Retorno Negado", "Sur la colline sans retour", "Punto di non ritorno", "돌아설 수 없는 길목", "Nas colinas do adeus", "Точка невозврата", "无言的山丘", "視死如歸", }, 
{ "The Dead Shall Rise", "Die Toten werden wiederauferstehen", "Los muertos se alzarán", "Los muertos deben alzarse", "Les morts se relèveront", "I morti risorgono", "망자여, 일어나라", "Os mortos erguer-se-ão", "Мертвые, восстаньте!", "亡者复生", "亡者復甦", }, 
{ "The Highlord Awaits", "Der Hochlord wartet", "El Alto Señor aguarda", "El Alto Señor espera", "Le généralissime attend", "Il Gran Signore attende", "대영주와의 만남", "Grão-lorde a sua espera", "Верховный лорд ждет", "大领主在等着你", "大領主等著", }, 
{ "The Sanctum of Light", "Das Sanktum des Lichts", "El Sagrario de la Luz", "El Santuario de la Luz", "Le sanctum de la Lumière", "Il Santuario della Luce", "빛의 성소", "O Sacrário da Luz", "Обитель Света", "圣光秘殿", "聖光會堂", }, 
{ "Lady of the Light", "Lady des Lichts", "La señora de la Luz", "Señora de la Luz", "La dame de Lumière", "La Dama della Luce", "빛의 여인", "Lady da Luz", "Госпожа Света", "圣光女伯爵", "聖光女士", }, 
{ "An Unholy Fate", "Ein unheiliges Schicksal", "Una suerte profana", "Un destino profano", "Un destin impie", "Un destino empio", "지독한 운명", "Um destino horrível", "Злая судьба", "亵渎命运", "不潔的命運", }, 
},
["1283"] = {
{ "Challenge and Defeat Your First Opponent", "Die erste Herausforderung", "Retar y derrotar a tu primer oponente", "Desafía y derrota a tu primer oponente", "Défier et terrasser votre premier adversaire", "Il primo avversario", "첫 번째 상대에게 도전하고 승리하기", "Desafiar e derrotar seu primeiro adversário", "Победа над первым противником", "挑战并击败第一个对手", "挑戰並擊敗你的第一個對手", }, 
{ "Challenge and Defeat Your Second Opponent", "Die zweite Herausforderung", "Retar y derrotar a tu segundo oponente", "Desafía y derrota a tu segundo oponente", "Défier et terrasser votre deuxième adversaire et le terrasser", "Il secondo avversario", "두 번째 상대에게 도전하고 승리하기", "Desafiar e derrotar seu segundo adversário", "Победа над вторым противником", "挑战并击败第二个对手", "挑戰並擊敗你的第二個對手", }, 
{ "Challenge and Defeat Your Third Opponent", "Die dritte Herausforderung", "Retar y derrotar a tu tercer oponente", "Desafía y derrota a tu tercer oponente", "Défier et terrasser votre troisième adversaire", "Il terzo avversario", "세 번째 상대에게 도전하고 승리하기", "Desafiar e derrotar seu terceiro adversário", "Победа над третьим противником", "挑战并击败第三个对手", "挑戰並擊敗你的第三個對手", }, 
{ "Defeat Your Final Opponent", "Der letzte Gegner", "Derrotar a tu oponente final", "Derrota al último oponente", "Triompher de votre dernier adversaire", "L'avversario finale", "마지막 상대에게 승리하기", "Derrotar seu adversário final", "Победа над последним противником", "击败最后一个对手", "擊敗你最後的對手", }, 
},
["1290"] = {
{ "Assist the blue dragons", "Hilfe für die blauen Drachen", "Ayudar a los dragones Azules", "Ayuda a los dragones azules", "Aide aux dragons bleus", "Aiutare i Draghi Blu", "푸른용들을 도와야 합니다.", "Ajudar os dragões azuis", "Помощь синим драконам", "协助蓝龙", "協助藍龍", }, 
{ "Meet up with the Blue drakes", "Treffen mit den blauen Drachen", "Reunión con los dracos azules", "Encuentra a los dracos azules", "Rencontre avec les drakes bleus", "Incontrare i Drachi Blu", "푸른 비룡들과 만나기", "Encontrar os dracos azuis", "Встреча с синими драконами", "找到幼年蓝龙", "與藍龍會合", }, 
{ "Reach the Legion Ship", "Erreicht das Legionsschiff", "Llegar a la nave de la Legión", "Llega hasta la nave de la Legión", "Atteindre le vaisseau de la Légion", "Raggiungere la Nave della Legione", "군단 함선에 도착", "Chegar à nave da Legião", "Корабль Легиона", "抵达军团战舰", "抵達燃燒軍團船艦", }, 
{ "Get on up there", "Hoch hinaus", "Subir ahí arriba", "Súbete ahí", "Vertige interdit", "Fin lassù", "저 위로", "Suba lá", "Верхний ярус", "一路向上", "到上面去", }, 
{ "Take down the Leader", "Schaltet den Anführer aus", "Acabar con el líder", "Acaba con el líder", "Éliminer le chef", "Sconfiggere il capo", "지휘관 처치", "Derrotar o líder", "Смерть предводителю!", "擒贼擒王", "消滅首領", }, 
{ "Escape!", "Flieht!", "¡Huida!", "¡Escapa!", "Fuyez !", "Fuga!", "탈출!", "Fuja!", "Побег", "逃亡！", "脫逃！", }, 
},
["1305"] = {
{ "The Hunt Begins", "Die Jagd beginnt", "Empieza la caza", "Empieza la caza", "La traque commence", "La caccia è aperta", "사냥 개시", "A caça começa", "Охота началась", "狩猎开始", "狩獵開始", }, 
{ "Night of Claw and Talon", "Nacht der Krallen und Klauen", "Noche de garras y zarpas", "La noche de la garra y la garfa", "La nuit des griffes et serres", "La notte dell'artiglio e dell'unghia", "발톱의 밤", "Noite de garras", "Ночь хищников", "利爪之夜", "凶禽與猛獸之夜", }, 
{ "Haukenulfnir", "Haukenulfnir", "Haukenulfnir", "Haukenulfnir", "Haukenulfnir", "Haukenulfnir", "하케누피니르", "Haukenulfnir", "Хаукенульфнир", "霍克努夫尼尔", "霍肯沃尼爾", }, 
{ "Revel The Night Away", "Die Nacht durchfeiern", "Celebra toda la noche", "Fiesta nocturna", "Festivités nocturnes", "Bisboccia Notturna", "오늘 밤은 연회와 함께", "Farreando a noite inteira", "Пир на весь мир", "彻夜狂欢", "狂歡晚宴", }, 
},
["638"] = {
{ "Hellfire Ramparts", "Höllenfeuerbollwerk", "Murallas del Fuego Infernal", "Murallas del Fuego Infernal", "Remparts des Flammes infernales", "Bastioni del Fuoco Infernale", "지옥불 성루", "Muralha Fogo do Inferno", "Бастионы Адского Пламени", "地狱火城墙", "地獄火壁壘", }, 
},
["585"] = {
{ "A Royal Escort", "Die Eskorte des Königs", "Una escolta real", "Una escolta real", "Une escorte royale", "Scorta reale", "왕 호위", "Uma escolta real", "Королевский эскорт", "皇家护卫", "護送皇室", }, 
{ "Infinite Corruptor Defeated", "Ewiger Verderber besiegt", "Corruptor infinito derrotado", "Corruptor Infinito derrotado.", "Corrupteur infini vaincu", "Sconfiggi il Corruttore dell'Infinito", "무한의 타락자 처치", "Corruptor Infinito derrotado", "Осквернитель из рода Бесконечности повержен", "击败永恒腐蚀者", "擊敗恆龍墮落者", }, 
},
["51"] = {
{ "Scholomance", "Scholomance", "Scholomance", "Scholomance", "Scholomance", "Scholomance", "스칼로맨스", "Scolomântia", "Некроситет", "通灵学院", "通靈學院", }, 
},
["1144"] = {
{ "Commence Bombardment!", "Das Bombardement beginnen", "¡Que comience el bombardeo!", "¡Comiencen el bombardeo!", "Feu à volonté !", "Fuoco alle polveri!", "폭격 개시!", "Iniciar o bombardeio!", "Готовсь... Цельсь... Пли!", "开始轰炸！", "開始轟炸！", }, 
{ "Glide Down to the Rendezvous", "Zum Treffpunkt hinuntergleiten", "Planea hasta el punto de encuentro", "Deslizamiento en descenso hacia el encuentro", "Planer jusqu’au point de rendez-vous", "Planare verso il punto di ritrovo", "고공 낙하", "Desça, planando, até o local de encontro", "Спуск к месту встречи", "滑翔到集合点", "滑翔前往集結地點", }, 
{ "Destroy the Legion", "Zerstört die Legion", "Destruye a la Legión", "Destruye a la Legión", "Détruire la Légion", "Annientare la Legione", "군단 섬멸", "Destrua a Legião", "Уничтожить Легион!", "消灭军团", "消滅燃燒軍團", }, 
{ "Regroup In Front of the Command Center", "Vor der Kommandozentrale versammeln", "Reagrupamiento frente al centro de mando", "Reagrupamiento frente al centro de mando", "Regroupement devant le centre de commandement", "Raduno al Centro di Comando", "사령부 앞에서 재집결", "Reagrupem-se em frente ao Centro de Comando", "Перегруппировка у флагманского корабля", "在指挥部前方重新集结", "在指揮中心前面重新整隊", }, 
{ "Fel Hammer, Fire!", "Teufelshammer, Feuer frei!", "¡Martillo Vil, fuego!", "¡Martillo Vil, fuego!", "Marteau gangrené, feu !", "Vilmartello, fuoco!", "지옥 망치호, 발사!", "Martelo Vil, fogo!", "Огонь!", "邪能之槌号，开火！", "魔錘號，射擊！", }, 
{ "Caria and Varedis At Last", "Caria und Varedis, endlich", "Caria y Varedis al fin", "Caria y Varedis, al fin", "Caria et Varedis, enfin…", "Caria e Varedis, alla fine ci incontriamo", "카리아와 베레디스의 최후", "Caria e Varedis, finalmente", "Наказать предателей", "最后，只剩下凯丽娅和瓦雷迪斯", "凱莉亞和瓦瑞迪斯的終點", }, 
{ "Malevolence, Get Us Out of Here", "Malicia, bringt uns hier weg", "Malevolencia, sácanos de aquí", "Malevolencia, sácanos de aquí", "Maléficiae ! Nous devons sortir d’ici !", "Malevola, tiraci fuori da qui", "말레볼런스의 지원", "Malevolência, tire-nos daqui", "Злоба, вытащи нас отсюда.", "玛沃伦丝，带我们离开这里", "懷惡族母，帶我們離開這裡", }, 
},
["606"] = {
{ "Shadow Labyrinth", "Schattenlabyrinth", "Laberinto de las Sombras", "Laberinto de las Sombras", "Labyrinthe des Ombres", "Labirinto delle Ombre", "어둠의 미궁", "Labirinto Soturno", "Темный лабиринт", "暗影迷宫", "暗影迷宮", }, 
},
};
