--Title: Lei Shen Coordinator
--Version: 3.00.xx
--Author: Lazare (Lazzy)


local LeiShenCoordinator = CreateFrame("frame","LeiShenCoordinatorFrame")
LeiShenCoordinator:SetBackdrop({
      bgFile="Interface\\DialogFrame\\UI-DialogBox-Background", 
      edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border", 
      tile = true, tileSize=16, edgeSize=16, 
      insets={left=3, right=3, top=5, bottom=3}
})
LeiShenCoordinator:SetWidth(165)
LeiShenCoordinator:SetHeight(275)
LeiShenCoordinator:SetPoint("CENTER",UIParent)
LeiShenCoordinator:EnableMouse(true)
LeiShenCoordinator:SetMovable(true)
LeiShenCoordinator:Hide()
LeiShenCoordinator:RegisterForDrag("LeftButton")
LeiShenCoordinator:SetScript("OnDragStart", function(self) self:StartMoving() end)
LeiShenCoordinator:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end)
LeiShenCoordinator:SetFrameStrata("FULLSCREEN_DIALOG")
LeiShenCoordinator:CreateFontString("LeiShenCoordinator_Title", "OVERLAY", "GameFontNormal")

local closeLeiShenCoordinatorButton = CreateFrame("Button", nil, LeiShenCoordinatorFrame, "UIPanelCloseButton")
closeLeiShenCoordinatorButton:SetPoint("TOPRIGHT", LeiShenCoordinatorFrame, "BOTTOMRIGHT")

local LeiShenCoordinatortext = LeiShenCoordinator:CreateFontString(nil, "ARTWORK", "GameFontHighlight")
LeiShenCoordinatortext:SetPoint("TOP")
LeiShenCoordinatortext:SetText("\nLeiShen Coordinator\n\n\n\nWorld Marker Buttons\n\n\n\n\n\n\n\n\nDestroyed Conduit\nButtons")
LeiShenCoordinatortext:SetTextColor(1, 0.8196079, 0, 1)



  --basic button func
local function CreateBasicButton(parent, name, text, tooltipText)
    local button = CreateFrame("Button", name, parent, "SecureActionButtonTemplate, UIPanelButtonTemplate")
    button.text = _G[button:GetName().."Text"]
    button.text:SetText(text)
    button:SetWidth(30)
    button:SetHeight(30)
    button:SetScript("OnEnter", function(self)
      GameTooltip:SetOwner(self, "ANCHOR_TOP")
      GameTooltip:AddLine(tooltipText, 0, 1, 0.5, 1, 1, 1)
      GameTooltip:Show()
    end)
    button:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
    return button
end

    
local CreateButton; do-- Prototype for function
--  Tooltip Handlers
    local function OnEnter(self)
        if self.Tooltip then
            GameTooltip:SetOwner(self,"ANCHOR_TOP");
            GameTooltip:AddLine(self.Tooltip,0,1,0.5,1,1,1);
            GameTooltip:Show();
        end
    end
local function OnLeave(self) if GameTooltip:IsOwned(self) then GameTooltip:Hide(); end end
 
--  Button Generator (this will be assigned to the upvalue noted as a function prototype)
function CreateButton(parent,name,texture,text,tooltip)
        tooltip=tooltip or text;--  If no tooltip, use button text
 
--      Create our button
        local btn=CreateFrame("Button",name,parent,"SecureActionButtonTemplate");
        btn:RegisterForClicks("AnyUp");--   Register all buttons
        btn:SetSize(25,25);
 
--      Setup button text
        btn:SetNormalFontObject("GameFontNormalSmall");
        btn:SetHighlightFontObject("GameFontHighlightSmall");
        btn:SetDisabledFontObject("GameFontDisableSmall");
        btn:SetText(text);
 
--      Setup button's backgorund, you can use :SetNormalTexture() and other functions to set state-based textures
        local tex=btn:CreateTexture(nil,"BACKGROUND");
        tex:SetAllPoints(btn);
        tex:SetTexture(texture);
        btn.Texture=tex;
 
--      Register handlers
		btn:SetScript("OnEnter",OnEnter);
		btn:SetScript("OnLeave",OnLeave);
		btn.Tooltip=tooltip;
 
--      Return our button
      return btn;

    end
end

--World marker 1
local button=CreateButton(LeiShenCoordinator,"LeiShenCoordinatorWorldMarkerButton1","Interface\\TargetingFrame\\UI-RaidTargetingIcon_6",nil,"Raid Marker 1\nRight-click to clear");
button:SetPoint("TOPRIGHT",-120,-80);-- Anchors always default to an object's parent
button:SetAttribute("type","macro");--  "type" without a number will handle all clicks unless a more specific attribute is found
button:SetAttribute("macrotext1",SLASH_WORLD_MARKER1.." 1");--      Adds world marker 1 on left-click
button:SetAttribute("macrotext2",SLASH_CLEAR_WORLD_MARKER1.." 1");--    Clears world marker 1 on right-click

        
--World marker 2
local button=CreateButton(LeiShenCoordinator,"LeiShenCoordinatorWorldMarkerButton2","Interface\\TargetingFrame\\UI-RaidTargetingIcon_4",nil,"Raid Marker 2\nRight-click to clear");
button:SetPoint("TOPRIGHT",-85,-80);-- Anchors always default to an object's parent
button:SetAttribute("type","macro");--  "type" without a number will handle all clicks unless a more specific attribute is found
button:SetAttribute("macrotext1",SLASH_WORLD_MARKER2.." 2");--      Adds world marker 2 on left-click
button:SetAttribute("macrotext2",SLASH_CLEAR_WORLD_MARKER2.." 2");--    Clears world marker 2 on right-click
    
    
--World marker 3
local button=CreateButton(LeiShenCoordinator,"LeiShenCoordinatorWorldMarkerButton3","Interface\\TargetingFrame\\UI-RaidTargetingIcon_3",nil,"Raid Marker 3\nRight-click to clear");
button:SetPoint("TOPRIGHT",-50,-80);-- Anchors always default to an object's parent
button:SetAttribute("type","macro");--  "type" without a number will handle all clicks unless a more specific attribute is found
button:SetAttribute("macrotext1",SLASH_WORLD_MARKER3.." 3");--      Adds world marker 3 on left-click
button:SetAttribute("macrotext2",SLASH_CLEAR_WORLD_MARKER3.." 3");--    Clears world marker 3 on right-click

    
--World marker 4
local button=CreateButton(LeiShenCoordinator,"LeiShenCoordinatorWorldMarkerButton4","Interface\\TargetingFrame\\UI-RaidTargetingIcon_7",nil,"Raid Marker 4\nRight-click to clear");
button:SetPoint("TOPRIGHT",-15,-80);-- Anchors always default to an object's parent
button:SetAttribute("type","macro");--  "type" without a number will handle all clicks unless a more specific attribute is found
button:SetAttribute("macrotext1",SLASH_WORLD_MARKER4.." 4");--      Adds world marker 4 on left-click
button:SetAttribute("macrotext2",SLASH_CLEAR_WORLD_MARKER4.." 4");--    Clears world marker 4 on right-click


-- help button
    local HelpButton = CreateFrame("Button", "HelpButton", LeiShenCoordinatorFrame, "SecureActionButtonTemplate, UIPanelButtonTemplate")
    HelpButton:SetText("Intructions/Help")
    HelpButton:SetWidth(119)
    HelpButton:SetHeight(23)
    HelpButton:SetPoint("TOPRIGHT", LeiShenCoordinator, -20, -30)
    HelpButton:Raise()
    HelpButton:RegisterForClicks("AnyUp", "AnyDown")
	HelpButton:SetScript("OnClick", function(self) LSCAboutFrame:Show() end)
	--HelpButton:SetAttribute("type", "macro")
--    HelpButton:SetAttribute("macrotext", format("/lazzy h"))
    HelpButton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_TOP")
		GameTooltip:AddLine("Instructions / Help Window", 0, 1, 0.5, 1, 1, 1)
		GameTooltip:Show()
    end)
    HelpButton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)

local function GroupMarkerAnnounce()
	SendChatMessage('Group / Marker Setup: GRP 1 {square},  GRP 2 {cross}, GRP 3 {triangle}, GRP 4 {diamond}, GRP 5 SPREAD OUT' , "RAID_WARNING")
end

local function BlueDestroyedAnnounce()
	SendChatMessage('BLUE DESTROYED! - GRP 2 {cross}, GRP 3 {triangle}, GRP 4 {diamond}, GRP 5 and 1 SPREAD OUT....' , "RAID_WARNING")
end

local function GreenDestroyedAnnounce()
	SendChatMessage('GREEN DESTROYED! - GRP 1 {square},  GRP 2 {cross}, GRP 4 {diamond}, GRP 5 and 3 SPREAD OUT....' , "RAID_WARNING")
end

local function PurpleDestroyedAnnounce()
	SendChatMessage('PURPLE DESTROYED! - GRP 1 {square},  GRP 2 {cross}, GRP 3 {triangle}, GRP 5 and 4 SPREAD OUT....' , "RAID_WARNING")
end

local function RedDestroyedAnnounce()
	SendChatMessage('RED DESTROYED! - RED DESTROYED! - GRP 1 {square}, GRP 3 {triangle}, GRP 4 {diamond}, GRP 5 and 2  SPREAD OUT....' , "RAID_WARNING")
end

-- ready Check button
 local ReadyCheckButton = CreateFrame("Button", "ReadyCheckButton", LeiShenCoordinatorFrame, "SecureActionButtonTemplate, UIPanelButtonTemplate")
    ReadyCheckButton:SetText("Ready Check")
    ReadyCheckButton:SetWidth(130)
    ReadyCheckButton:SetHeight(23)
    ReadyCheckButton:RegisterForClicks("AnyUp", "AnyDown")
    ReadyCheckButton:SetPoint("TOPRIGHT", LeiShenCoordinator, -20, -115)
    ReadyCheckButton:Raise()
    ReadyCheckButton:SetScript("OnClick", function(self) DoReadyCheck() end)
	ReadyCheckButton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_TOP")
		GameTooltip:AddLine("Click for Ready Check", 0, 1, 0.5, 1, 1, 1)
		GameTooltip:Show()
    end)
   ReadyCheckButton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
    
-- announce marker groups button
 local GroupMarkerButton = CreateFrame("Button", "GroupMarkerButton", LeiShenCoordinatorFrame, "SecureActionButtonTemplate, UIPanelButtonTemplate")
    GroupMarkerButton:SetText("Announce Markers")
    GroupMarkerButton:SetWidth(130)
    GroupMarkerButton:SetHeight(23)
    GroupMarkerButton:SetPoint("TOPRIGHT", LeiShenCoordinator, -20, -145)
    GroupMarkerButton:Raise()
    GroupMarkerButton:RegisterForClicks("AnyUp", "AnyDown")
	GroupMarkerButton:SetScript("OnClick", function(self) GroupMarkerAnnounce() end)
	GroupMarkerButton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_TOP")
		GameTooltip:AddLine("Announce Group\n/ Raid Msrkers", 0, 1, 0.5, 1, 1, 1)
		GameTooltip:Show()
    end)
    GroupMarkerButton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
    


-- blue conduit destroyed
 local BlueDestroyedButton = CreateFrame("Button", "BlueDestroyedButton", LeiShenCoordinatorFrame, "SecureActionButtonTemplate, UIPanelButtonTemplate")
    BlueDestroyedButton:SetText("Blue")
    BlueDestroyedButton:SetWidth(50)
    BlueDestroyedButton:SetHeight(23)
    BlueDestroyedButton:SetPoint("TOPRIGHT", LeiShenCoordinator, -90, -200)
    BlueDestroyedButton:Raise()
	BlueDestroyedButton:RegisterForClicks("AnyUp", "AnyDown")
	BlueDestroyedButton:SetScript("OnClick", function(self) BlueDestroyedAnnounce() end)
    BlueDestroyedButton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_TOP")
		GameTooltip:AddLine("Blue Conduit Destroyed", 0, 1, 0.5, 1, 1, 1)
		GameTooltip:Show()
    end)
    BlueDestroyedButton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
    
-- green conduit destroyed
 local GreenDestroyedButton = CreateFrame("Button", "GreenDestroyedButton", LeiShenCoordinatorFrame, "SecureActionButtonTemplate, UIPanelButtonTemplate")
    GreenDestroyedButton:SetText("Green")
    GreenDestroyedButton:SetWidth(50)
    GreenDestroyedButton:SetHeight(23)
    GreenDestroyedButton:SetPoint("TOPRIGHT", LeiShenCoordinator, -90, -230)
    GreenDestroyedButton:Raise()
	GreenDestroyedButton:RegisterForClicks("AnyUp", "AnyDown")
	GreenDestroyedButton:SetScript("OnClick", function(self) GreenDestroyedAnnounce() end)
   	GreenDestroyedButton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_TOP")
		GameTooltip:AddLine("Green Conduit Destroyed", 0, 1, 0.5, 1, 1, 1)
		GameTooltip:Show()
    end)
    GreenDestroyedButton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
    
    
-- purple conduit destroyed
 local PurpleDestroyedButton = CreateFrame("Button", "PurpleDestroyedButton", LeiShenCoordinatorFrame, "SecureActionButtonTemplate, UIPanelButtonTemplate")
    PurpleDestroyedButton:SetText("Purple")
    PurpleDestroyedButton:SetWidth(50)
    PurpleDestroyedButton:SetHeight(23)
    PurpleDestroyedButton:SetPoint("TOPRIGHT", LeiShenCoordinator, -20, -200)
    PurpleDestroyedButton:Raise()
    PurpleDestroyedButton:RegisterForClicks("AnyUp", "AnyDown")
	PurpleDestroyedButton:SetScript("OnClick", function(self) PurpleDestroyedAnnounce() end)
  	PurpleDestroyedButton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_TOP")
		GameTooltip:AddLine("Purple Conduit Destroyed", 0, 1, 0.5, 1, 1, 1)
		GameTooltip:Show()
    end)
    PurpleDestroyedButton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
    
-- red conduit destroyed
 local RedDestroyedButton = CreateFrame("Button", "RedDestroyedButton", LeiShenCoordinatorFrame, "SecureActionButtonTemplate, UIPanelButtonTemplate")
    RedDestroyedButton:SetText("Red")
    RedDestroyedButton:SetWidth(50)
    RedDestroyedButton:SetHeight(23)
    RedDestroyedButton:SetPoint("TOPRIGHT", LeiShenCoordinator, -20, -230)
    RedDestroyedButton:Raise()
    RedDestroyedButton:RegisterForClicks("AnyUp", "AnyDown")
	RedDestroyedButton:SetScript("OnClick", function(self) RedDestroyedAnnounce() end)
    RedDestroyedButton:SetScript("OnEnter", function(self)
		GameTooltip:SetOwner(self, "ANCHOR_TOP")
		GameTooltip:AddLine("Red Conduit Destroyed", 0, 1, 0.5, 1, 1, 1)
		GameTooltip:Show()
    end)
    RedDestroyedButton:SetScript("OnLeave", function(self) GameTooltip:Hide() end)
    
-- help/about frame
aboutFrame = CreateFrame("Frame", "LSCAboutFrame", UIParent)
tinsert(UISpecialFrames, "AboutFrame")
aboutFrame:SetBackdrop({
      bgFile = [[Interface\DialogFrame\UI-DialogBox-Background]],
      edgeFile = [[Interface\DialogFrame\UI-DialogBox-Border]],
      tile = true, tileSize = 16, edgeSize = 16,
      insets = { left = 3, right = 3, top = 5, bottom = 3 }
})
aboutFrame:SetBackdropColor(0,0,0,1)
aboutFrame:SetWidth(400)
aboutFrame:SetHeight(450)
aboutFrame:SetPoint("CENTER", UIParent, "CENTER")
aboutFrame:Hide()
aboutFrame:SetFrameStrata("DIALOG")
aboutFrame:SetToplevel(true)

local scrollArea = CreateFrame("ScrollFrame", "LSCAboutScroll", aboutFrame, "UIPanelScrollFrameTemplate")
scrollArea:SetPoint("TOPLEFT", aboutFrame, "TOPLEFT", 8, -30)
scrollArea:SetPoint("BOTTOMRIGHT", aboutFrame, "BOTTOMRIGHT", -30, 8)

local editBox = CreateFrame("EditBox", nil, aboutFrame)
editBox:SetMultiLine(true)
editBox:SetMaxLetters(99999)
editBox:EnableMouse(true)
editBox:SetAutoFocus(false)
editBox:EnableKeyboard(disable)
editBox:EnableMouse(disable)
editBox:SetFontObject(ChatFontNormal)
editBox:SetWidth(360)
editBox:SetHeight(425)
editBox:SetText("Lei Shen Coordinator Instructions:\n\nThis addon is to make the Lei Shen encounter easier.\n\nYou need to make sure that before using it, you are either the raid LEADER or have ASSIST as the world markers and RAID WARNINGs require it.\n\nMake sure there is one healer at least per group.\nSeparate your tanks also. \n\nWorld Marker Buttons:\n\nSet a world marker for each corner: (Blue {square}, Green {triangle}, Purple {diamond}, Red {cross} are used in this addon. Left-click sets the marker, right-click clears it.\n\nBefore the pull, make sure to hit the Announce Markers button to let raid members know which group goes to which marker.\n\nThere is a button for Ready Check and the buttons below that are for announcing pre-pull group/raid marker areas. The buttons below the Announce Markers are for the areas that have been destroyed. So if (Blue {square} conduit has been destroyed, then in the Transition phase click the Blue Destroyed button. The same applies for the rest.\n\nCommands for this addon are:\n\n/lsc or /leishen will show the main window\n/lsc c or /leishen c will close the main window (along with using the close button)\n/lsc h, /lsc help or /leishen h, /leishen help, will bring up this help/Instruction window")

--phase 1



editBox:SetScript("OnEscapePressed", function() aboutFrame:Show() end)
aboutFrame.editBox = editBox
scrollArea:SetScrollChild(editBox)

local close = CreateFrame("Button", nil, aboutFrame, "UIPanelCloseButton")
close:SetPoint("TOPRIGHT", aboutFrame, "TOPRIGHT")  
  
SLASH_LeiShenCoordinatorFrame1 = "/lsc"
SLASH_LeiShenCoordinatorFrame2 = "/leishen"
local function handler(msg, editbox)
 if msg == "c" or msg == "close" then
  LeiShenCoordinatorFrame:Hide();
  elseif msg == "h"  or msg == "help" then
  	aboutFrame:Show()
elseif msg == "" then
  LeiShenCoordinatorFrame:Show()
 end
end
SlashCmdList["LeiShenCoordinatorFrame"] = handler; -- Also a valid assignment strategy
