-- Legendary Equip Sounds V 2.0.1 (Beta) for WoW 7.3
--[[
-------- Changelog - v 2.0.1 (Beta) --------
 - Updated toc to 70300
 
-------- Changelog - v 2.0 --------
 - Code clean up, using variables for items
 - Fixed Bug where Thunderfury was only procing sound and emote on main hand slot, not off hand slot, Val'anyr would have done the same.
 - fixed caveat about swapping one handed weapons from one slot to another causing multiple LES sound/emote procs
 - fixed caveat about swapping legendary ring from one slot to another causing multiple LES sound/emote prics
 ]]

--variables used to determine if an equipment change was triggered by a equipment set change
local setchange = false
local plural = ""

--Legendary Weapon variables
local dragonwrath = 71086 --71086
local sulfuras = 17182 --17182
local warglaivemain = 32837 --32837
local warglaiveoff = 32838 --32838
local thunderfury = 19019 --19019
local shadowmourne = 49623 --49623
local thoridal = 34334 --34334
local valanyr = 46017 --46017
local golad = 77949 --77949, Mainhand Fangs of the Father
local tiriosh = 77950 --77950, Offhand Fangs of the Father
local atieshmage = 22589 --22589, Atiesh Mage
local atieshlock = 22630 --22630, Atiesh Warlock
local atieshpriest = 22631 --22631, Atiesh Priest
local atieshdruid = 22632 --22632, Atiesh Druid

--Legendary Ring variables
local thorasus = 124634 --124634
local nithramus = 124635 --124635
local maalus = 124636 --124636
local sanctus = 124637 --124637
local etheralus = 124638 --124638

local LES = CreateFrame("Frame") -- Create Frame LegendaryEquipSounds
LES:RegisterEvent("PLAYER_LOGIN") --PERSONAL FOR ASAGRON USAGE
LES:RegisterEvent("PLAYER_EQUIPMENT_CHANGED") -- Register event for equipment change to the frame
LES:RegisterEvent("EQUIPMENT_SWAP_PENDING") -- Register event that indicates when an equipment change was triggered by the equipment manager
-- set the onevent script
LES:SetScript("OnEvent",
	function(self,event,...)
		--PERSONAL FOR ASAGRON USAGE, REMOVE FOR PUBLIC RELEASE VERSIONS OF LES
		if (event == "PLAYER_LOGIN") then
			ChatFrame3:SetClampedToScreen(false)
			ChatFrame4:SetClampedToScreen(false)
			ChatFrame5:SetClampedToScreen(false)
			ChatFrame6:SetClampedToScreen(false)
			ChatFrame1EditBox:SetPoint("TOPLEFT",GeneralDockManager,"TOPLEFT")
		end
		if (event == "EQUIPMENT_SWAP_PENDING") then -- if triggered event is due to the equipment manager, set variables to be used in the equipment changed event
			setchange = true
			plural = "s"
		end
		if (event == "PLAYER_EQUIPMENT_CHANGED") then
			local slot, equipped = ...
			-- Get inv id values for comparisons
			local mainhand = GetInventoryItemID("Player", 16) or "Empty"
			local offhand = GetInventoryItemID("player", 17) or "Empty"
			local ring1 = GetInventoryItemID("player", 11) or "Empty"
			local ring2 = GetInventoryItemID("player", 12) or "Empty"

			--if the mainhand slot caused the event to fire
			if (slot == 16) then
				if(mainhand == dragonwrath) then
					PlaySoundFile("Sound/creature/TARECGOSA/VO_QUEST_42_TARECGOSA_WHISPER_B_01.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Dragonwrath you hear Tarecgosa's words of confidence!\124h\124r")
					
				elseif(mainhand == sulfuras) then
					PlaySoundFile("Sound/creature/RAGNAROS/VO_FL_RAGNAROS_PURGE_01.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Sulfuras you hear Ragnaros' voice threaten your existance!\124h\124r")
					
				--play sound if: mainhand equipped and no offhand already equipped OR mainhand and offhand equipped together by set manager
				elseif ((mainhand == warglaivemain) and ((offhand ~= warglaiveoff) or setchange == true)) then 
						PlaySoundFile("Sound/creature/Illidan/BLACK_Illidan_04.ogg")
						DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip your Warglaive"..plural.." you hear Illidan taunting you!\124h\124r")
				
				elseif (mainhand == thunderfury) then
					PlaySoundFile("Sound/creature/Thunderaan/ThunderaanAggro.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Thunderfury a distant sound reminds you of your fight with Thunderaan!\124h\124r")
				
				elseif (mainhand == shadowmourne) then
					PlaySoundFile("Sound/creature/LichKing/IC_Lich King_SM12.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Shadowmourne you are reminded of the Lich King taunting you!\124h\124r")
				
				elseif (mainhand == thoridal) then
					PlaySoundFile("Sound/creature/KilJaeden/KILJAEDENPHASE03.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Thori'dal you are reminded of your fight with Kil'Jaedan!\124h\124r")
				
				elseif (mainhand == valanyr) then
					PlaySoundFile("Sound/creature/YoggSaron/AK_YoggSaron_HowlingFjordWhisper02.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Val'anyr you are reminded of the horrors that you faced in Ulduar!\124h\124r")
					
				--play sound if: mainhand equipped and no offhand already equipped OR mainhand and offhand equipped together by set manager
				elseif ((mainhand == golad) and ((offhand ~= tiriosh) or setchange == true)) then
						PlaySoundFile("Sound/creature/Deathwing/VO_53_Deathwing_Legendary_04.OGG")
						DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip your dagger"..plural.." you recall the threats of Deathwing!\124h\124r")

				elseif ((mainhand == atieshmage) or (mainhand == atieshlock) or (mainhand == atieshpriest) or (mainhand == atieshdruid))then
					PlaySoundFile("Sound/creature/KelThuzad/KEL_NAXX_SLAY01.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Atiesh you hear the sounds of Kel'Thuzad taunting you!\124h\124r") 
				end
			end
			
			--if the offhand slot caused the event to fire
			if (slot == 17) then
				--play sound if: offhand equipped and no mainhand already equipped
				if ((offhand == warglaiveoff) and (mainhand ~= warglaivemain))then
					PlaySoundFile("Sound/creature/Illidan/BLACK_Illidan_04.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip your Warglaive you hear Illidan taunting you!\124h\124r")
				
				--play sound if: offhand equipped and no mainhand already equipped
				elseif ((offhand == tiriosh) and (mainhand ~= golad))then 
					PlaySoundFile("Sound/creature/Deathwing/VO_53_Deathwing_Legendary_04.OGG")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip your dagger you recall the threats of Deathwing!\124h\124r")
				
				elseif (offhand == thunderfury) then
					PlaySoundFile("Sound/creature/Thunderaan/ThunderaanAggro.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Thunderfury a distant sound reminds you of your fight with Thunderaan!\124h\124r")
				
				elseif (offhand == valanyr) then
					PlaySoundFile("Sound/creature/YoggSaron/AK_YoggSaron_HowlingFjordWhisper02.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip Val'anyr you are reminded of the horrors that you faced in Ulduar!\124h\124r")
				end
			end
		
			--if a ring slot caused the event to fire
			if ((slot == 11) or (slot == 12)) then
				if (
				((slot == 11) and ((ring1 == thorasus) or (ring1 == nithramus) or (ring1 == maalus) or (ring1 == sanctus) or (ring1 == etheralus))) or
				((slot == 12) and ((ring2 == thorasus) or (ring2 == nithramus) or (ring2 == maalus) or (ring2 == sanctus) or (ring2 == etheralus)))
				) then
					PlaySoundFile("Sound/creature/Khadgar/VO_60_LQ_KHADGAR_RING_02.ogg")
					DEFAULT_CHAT_FRAME:AddMessage("\124c00ff8833\124hAs you equip your ring you hear Archmage Khadgar's voice in your head!\124h\124r")
				end
			end
			--reset Equipment manager variables here
			setchange = false
			plural = ""
		end
	end)