local pingFrame = CreateFrame("Frame", "LagMonitorFrame", UIParent);
local statsFrame = CreateFrame("Frame", "ItemLevelFrame", UIParent);
local pingLocal = pingFrame:CreateFontString("PLocal", "OVERLAY");
local pingWorld = pingFrame:CreateFontString("PWorld", "OVERLAY");
local pLocal = pingFrame:CreateFontString("PLocal", "OVERLAY");
local pWorld = pingFrame:CreateFontString("PWorld", "OVERLAY");
local gFPS = pingFrame:CreateFontString("GFPS", "OVERLAY");
local gameFPS = pingFrame:CreateFontString("GFPS", "OVERLAY");
local ilevel = statsFrame:CreateFontString("ILVL", "OVERLAY");
local ilevelStats = statsFrame:CreateFontString("ILVLS", "OVERLAY");
local LSM = LibStub("LibSharedMedia-3.0");
local updateInterval = 0;
local addonLoadedMessage = 'v1.8';
local defaultFont = 1;
local defaultFrameHeight = 60;
local defaultFrameWidth = 160;
local statsFrameHeight = 25;
local isHidden = false;
local setHeight = 0;
LagMonitor = LibStub("AceAddon-3.0"):NewAddon("LagMonitor", "AceConsole-3.0", "AceEvent-3.0")

--Global variable
local userFont = {
		"Frizqt(Game - Default)",
		"Skurri(Game)",
		"Morpheus(Game)",
		"Arialn(Game)",
		"Shangri-la",
		"Bascula College",
		"Sigismundus",
		"Seasrn",
		"Caviar Dreams",
		"Blkchry",
		"Carnevalee Freakshow",
		"Good Times",
		"Price Down"
}

local userEdge = "Edge1";

local myFont = LSM:Fetch("font",userFont);
local edgeFile = LSM:Fetch("edge", userEdge);

--LagFrame
local LagBorder=pingFrame:CreateTexture(nil,"BACKGROUND")
local LagBody=pingFrame:CreateTexture(nil,"ARTWORK")

--StatsFrame
local StatsBorder=statsFrame:CreateTexture(nil,"BACKGROUND")
local StatsBody=statsFrame:CreateTexture(nil,"ARTWORK")

--Set frame moveable (PingFrame)
pingFrame:SetMovable(true)
pingFrame:SetResizable(true)
pingFrame:EnableMouse(true)
pingFrame:RegisterForDrag("LeftButton")
pingFrame:SetScript("OnDragStart", pingFrame.StartMoving)
pingFrame:SetScript("OnDragStop", pingFrame.StopMovingOrSizing)

--Set frame moveable (StatsFrame)
statsFrame:EnableMouse(false);
statsFrame:SetMovable(false);
statsFrame:SetResizable(false);
statsFrame:RegisterForDrag("LeftButton");

statsFrame:SetScript("OnDragStart", statsFrame.StartMoving);
statsFrame:SetScript("OnDragStop", statsFrame.StopMovingOrSizing);

--Set frame (StatsFrame)
statsFrame:SetPoint("TOP", pingFrame, "BOTTOM", 0, -10)
statsFrame:SetSize(defaultFrameWidth, statsFrameHeight)

--Set Frame (PingFrame)
pingFrame:SetPoint("TOP", UIParent, "CENTER", 0, 0)
pingFrame:SetSize(defaultFrameWidth, defaultFrameHeight)

--Register addon loaded
pingFrame:RegisterEvent("ADDON_LOADED");
statsFrame:RegisterEvent("ADDON_LOADED");
--Register player logout
pingFrame:RegisterEvent("PLAYER_LOGOUT");
statsFrame:RegisterEvent("PLAYER_LOGOUT");

--Slash commands
SLASH_PING1 = "/ping";
SLASH_PING2 = "/latency";
SLASH_PING3 = "/ms";
SLASH_HELP1 = "/lmhelp";
SLASH_FPS1 = "/lmfps";
SLASH_FPS2 = "/framerate";
SLASH_FPS3 = "/fps";
SLASH_STATUS1 = "/status";
SLASH_STATUS2 = "/lmstatus";
SLASH_STATUS3 = "/stats";
SLASH_CLOSE1 = "/lmclose";
SLASH_DISPLAY1 = "/lmdisplay";
SLASH_RESET1 = "/lmreset";
SLASH_LOCK1 = "/lmlock";
SLASH_LOCK2 = "lmlocked";
SLASH_RELEASE1 = "/lmrelease";
SLASH_RELEASE2 = "/lmfree";
SLASH_CLAMP1 = "/lmclamp";
SLASH_CLAMP2 = "/lmclamped";
SLASH_ITEM1 = "/lmilvl";
SLASH_ITEM2 = "/ilvl";

SlashCmdList["ITEM"] = function(self, txt)
	local overall, equipped = GetAverageItemLevel();
	LagMonitor:Print("Equipped Gear Item Level: " .. equipped);
	LagMonitor:Print("Overall Gear Item Level: " .. overall);
end

SlashCmdList["STATUS"] = function(self, txt)
	local fps = GetFramerate();
	local up, down, home, world = GetNetStats();
	LagMonitor:Print("Home ping: " .. home);
	LagMonitor:Print("World ping: " .. world);
	LagMonitor:Print("Framerate: " .. floor(fps));
end

SlashCmdList["CLAMP"] = function(self, txt)
	LagMonitor.db.profile.clamped = true
	pingFrame:SetClampedToScreen(true);
	statsFrame:SetClampedToScreen(true);
end

SlashCmdList["FPS"] = function(self, txt)
	local fps = GetFramerate();
	LagMonitor:Print("Framerate: " .. floor(fps));
end

SlashCmdList["DISPLAY"] = function(self, txt)
    LagMonitor.db.profile.closed = false
	pingFrame:Show();
	statsFrame:Show();
end

SlashCmdList["CLOSE"] = function(self, txt)
	LagMonitor.db.profile.closed = true
	pingFrame:Hide();
	statsFrame:Hide();
end

SlashCmdList["RESET"] = function(self, txt)
	ResetSettings();
end

SlashCmdList["LOCK"] = function(self, txt)
	LagMonitor.db.profile.locked = true
	pingFrame:EnableMouse(false)
	LagMonitor:Print("is locked!");
end

SlashCmdList["RELEASE"] = function(self, txt)
	LagMonitor.db.profile.locked = false
	pingFrame:EnableMouse(true);
	LagMonitor:Print("is unlocked!");
end

SlashCmdList["HELP"] = function(self, txt)
	LagMonitor:Print("Use /ping, /ms, /latency to dispay home and world ping!");
	LagMonitor:Print("Use /lmreset to reset everything to default settings!");
	LagMonitor:Print("Use /lmclose to close the addon!");
	LagMonitor:Print("Use /lmdisplay to display the addon!");
	LagMonitor:Print("Use /lmfps, /fps, /framerate to display current framerate!");
	LagMonitor:Print("Use /lmstatus, /status, /stats to display Latency and framerate!");
	LagMonitor:Print("Use /lmlock, /lmlocked to lock the frame in its current position!");
	LagMonitor:Print("Use /lmrelease, /lmfree to unlock the frame!");
	LagMonitor:Print("Use /lmclamp, /lmclamped to clamp the LagMonitor frame to the screen!");
	LagMonitor:Print("Use /lmilvl, /ilvl to display overall and equipped gear item level!");
end

SlashCmdList["PING"] = function(self, txt)
	local up, down, home, world = GetNetStats();
	LagMonitor:Print("Home ping: " .. home);
	LagMonitor:Print("World ping: " .. world);
end

function round(number, decimals)
	return (("%%.%df"):format(decimals)):format(number)
end

local options = {
    name = "LagMonitor " .. addonLoadedMessage,
    handler = LagMonitor,
    type = 'group',
    args = {
	
        showColText = {
            type = "toggle",
            name = "Toggle Colors",
			order = 1,
            desc = "Enable/disable colors stating quality of gameplay, for example: Green is Optimal, Orange/Yellow is Playable and Red is Poor",
            get = "IsShowColText",
            set = "ToggleShowColText",
        },
		fontThickOutline = {
			type = "toggle",
			name = "Font Thick Outline",
			order = 2,
			desc = "Enable/disable a thick font outline!",
			get = "IsThickOutline",
			set = "ToggleThickOutline"
		},
		locked = {
			type = "toggle",
			name = "Lock Ping Frame",
			order = 3,
			desc = "Locks the frame in its current position!",
			get = "IsLocked",
			set = "ToggleIsLocked"
		},
			statsframeUnlock = {
			type = "toggle",
			name = "Unlock Stats Frame",
			order = 4,
			desc = "Enable/disable the ability to move the stats frame!",
			get = "IsUnlocked",
			set = "ToggleIsUnlocked"
		},
			framesPerScond = {
			type = "toggle",
			name = "FPS",
			order = 5,
			desc = "Enable/disable FPS being displayed!",
			get = "FPSDisplayed",
			set = "ToggleFPS"
		},
		homePing = {
			type = "toggle",
			name = "Home Ping",
			order = 6,
			desc = "Enable/disable Home ping being displayed!",
			get = "homePingDisplayed",
			set = "ToggleHomePing"
		},
		worldPing = {
			type = "toggle",
			name = "World Ping",
			order = 7,
			desc = "Enable/disable World Ping being displayed!",
			get = "worldPingDisplayed",
			set = "ToggleWorldPing"
		},
		clamped = {
			type = "toggle",
			name = "Clamp To Screen",
			order = 8,
			desc = "Controls wheter the LagMonitor frame can be dragged offscreen!",
			get = "IsClamped",
			set = "ToggleIsClamped"
		},
		itemlevel = {
			type = "toggle",
			name = "Show Item Level",
			order = 9,
			desc = "Show/Hide a frame displaying your Item Level!",
			get = "ilevelDisplayed",
			set = "ToggleItemLevel"
		},
		anchor = {
			type = "toggle",
			name = "Anchor Stats Frame",
			order = 10,
			desc = "Anchors the stats frame to the ping frame!",
			get = "IsAnchored",
			set = "ToggleIsAnchored"
		},
        closed = {
            type = "toggle",
            name = "Close",
			order = 11,
            desc = "Toggles the visibility of the addon",
            get = "IsClosed",
            set = "ToggleIsClosed"
        },
		bordercol = {
			type = "range",
			name = "Outer Transparency",
			order = 12,
			min = 0,
			max = 1,
			get = "currentBorderCol",
			set = "changeBorderCol",
			desc = "Change the transparency of the outer background!",
			step = 0.01
		},
		backgroundcol = {
			type = "range",
			name = "Inner Transparency",
			order = 13,
			min = 0,
			max = 1,
			get = "currentBackgroundCol",
			set = "changeBackgroundCol",
			desc = "Change the transparency of the inner background!",
			step = 0.01
		},
		changeFrameHeight = {
			type = "range",
			name = "Change Height",
			order = 14,
			min = 25,
			max = 500,
			get = "currentFrameHeight",
			set = "changeFrameHeight",
			step = 1
		},
		changeFrameWidth = {
			type = "range",
			name = "Change Width",
			order = 15,
			min = 50,
			max = 500,
			get = "currentFrameWidth",
			set = "changeFrameWidth",
			step = 0.1
		},
		changeFont = {
			type = "range",
			name = "Change Font Size",
			order = 16,
			min = 7,
			max = 32,
			desc = "Changes the size of the fonts! NOTE: Change the size of the frame if the font size is too big or does not fit!",
			get = "currentFontSize",
			set = "changeFontSize",
			step = 1
		},
		activeFont = {
			type = "select",
			name = "Fonts",
			order = 17,
			values = userFont,
			get = "currentFont",
			set = "changeFont"
		},
		reset = {
			type = "execute",
			name = "Reset",
			order = 18,
			desc = "Reset all the settings back to the default settings!",
			func = "ToggleIsReset"
		},
    },
}

function LagMonitor:IsAnchored(info)
	return self.db.profile.IsAnchored;
end

function LagMonitor:ToggleIsAnchored(info, value)
	self.db.profile.IsAnchored = value;
	if self.db.profile.IsAnchored == true then
		self.db.profile.statsFrameUnlock = false;
		statsFrame:EnableMouse(false);
		statsFrame:SetMovable(false);
		statsFrame:SetResizable(false);
		statsFrame:ClearAllPoints();
		statsFrame:SetPoint("TOP", pingFrame, "BOTTOM", 0, -10);
	end
	if self.db.profile.IsAnchored == false then
		statsFrame:SetMovable(true);
		statsFrame:SetResizable(true);
	end
end

function LagMonitor:IsUnlocked(info)
	return self.db.profile.statsFrameUnlock;
end

function LagMonitor:ToggleIsUnlocked(info, value)
	self.db.profile.statsFrameUnlock = value;
	self.db.profile.IsAnchored = false;
	StatsFrameMove();
end

function LagMonitor:ilevelDisplayed(info)
	return self.db.profile.ilvldisplay;
end

function LagMonitor:ToggleItemLevel(info, value)
	self.db.profile.ilvldisplay = value;
	if value == true and self.db.profile.closed == false then
		statsFrame:Show();
	end
	if value == false then
		statsFrame:Hide();
	end
end

function LagMonitor:IsThickOutline(info)
	return self.db.profile.thickOutline;
end

function LagMonitor:ToggleThickOutline(info, value)
	self.db.profile.thickOutline = value;
end

function LagMonitor:FPSDisplayed(info)
	return self.db.profile.fpsShow;
end

function LagMonitor:ToggleFPS(info, value)
	self.db.profile.fpsShow = value;
	self.db.profile.changedHeight = true;
	SortOrder();
	if isHidden == true then
		pingFrame:Show();
		isHidden = false;
	end
		if value == true then
			gFPS:Show();
			gameFPS:Show();
	end
		if value == false then
			gFPS:Hide();
			gameFPS:Hide();
	end
end

function LagMonitor:worldPingDisplayed(info)
	return self.db.profile.worldPingShow;
end

function LagMonitor:ToggleWorldPing(info, value)
	self.db.profile.worldPingShow = value;
	self.db.profile.changedHeight = true;
	SortOrder();
	if isHidden == true then
		pingFrame:Show();
		isHidden = false;
	end
	
	if value == true then
		pWorld:Show();
		pingWorld:Show();
	end
	if value == false then
		pWorld:Hide();	
		pingWorld:Hide();
	end
end

function LagMonitor:homePingDisplayed(info)
	return self.db.profile.homePingShow;
end

function LagMonitor:ToggleHomePing(info, value)
	self.db.profile.homePingShow = value;
	self.db.profile.changedHeight = true;
	SortOrder();
	if isHidden == true then
		pingFrame:Show();
		isHidden = false;
	end
	if value == true then
		pLocal:Show();
		pingLocal:Show();
	end
	if value == false then
	pLocal:Hide();
	pingLocal:Hide();
	end
end

function LagMonitor:currentFrameHeight(info)
	return self.db.profile.frameHeight;
end

function LagMonitor:changeFrameHeight(info, value)
		self.db.profile.frameHeight = value;
		pingFrame:SetHeight(value);
		self.db.profile.changedHeight = false;
end

function LagMonitor:currentFrameWidth(info)
	return self.db.profile.frameWidth;
end

function LagMonitor:changeFrameWidth(info, value)
	self.db.profile.frameWidth = value;
	pingFrame:SetWidth(value);
	statsFrame:SetWidth(value);
end

function LagMonitor:currentFont(info)
	return self.db.profile.activeFont;
end

function LagMonitor:changeFont(info, value)
	self.db.profile.activeFont = value;
	myFont = LSM:Fetch("font","Font" .. value);
end

function LagMonitor:currentFontSize(info)
	return self.db.profile.fontSize
end

function LagMonitor:IsClamped(info)
	return self.db.profile.clamped
end

function LagMonitor:ToggleIsClamped(info, value)
	self.db.profile.clamped = value
	
	if value == true then
	pingFrame:SetClampedToScreen(true);
	statsFrame:SetClampedToScreen(true);
	end
	if value == false then
	pingFrame:SetClampedToScreen(false);
	statsFrame:SetClampedToScreen(false);
	end
end

function LagMonitor:currentBorderCol(info)
	return self.db.profile.bordercol
end

function LagMonitor:currentBackgroundCol(info)
	return self.db.profile.backgroundcol
end

function LagMonitor:changeBorderCol(info, value)
	self.db.profile.bordercol = value;
	LagBorder:SetVertexColor(0.85, 0.85, 0.85, value);
	StatsBorder:SetVertexColor(0.85, 0.85, 0.85, value);
end

function LagMonitor:changeBackgroundCol(info, value)
	self.db.profile.backgroundcol = value;
	LagBody:SetVertexColor(0.1, 0.1, 0.1, value);
	StatsBody:SetVertexColor(0.1, 0.1, 0.1, value);
end

function LagMonitor:changeFontSize(info, value)
	self.db.profile.fontSize = value;
end

function LagMonitor:ToggleIsReset(info, value)
	ResetSettings();
end

function LagMonitor:IsLocked(info)
	return self.db.profile.locked
end

function LagMonitor:ToggleIsLocked(info, value)
	self.db.profile.locked = value
	
	if value == true then
	pingFrame:EnableMouse(false);
	end
	if value == false then
	pingFrame:EnableMouse(true);
	end
end

function LagMonitor:IsShowColText(info)
    return self.db.profile.showColText
end

function LagMonitor:ToggleShowColText(info, value)
    self.db.profile.showColText = value
	ShowColText();
end

function LagMonitor:IsClosed(info)
    return self.db.profile.closed
end

function LagMonitor:ToggleIsClosed(info, value)
    self.db.profile.closed = value
	
	if value == true then
	pingFrame:Hide();
	statsFrame:Hide();
	end
	if value == false then
	pingFrame:Show();
		if self.db.profile.ilvldisplay == true then
			statsFrame:Show();
		end
	end
end

local defaults = {
    profile = {
        showColText = true,
		locked = false,
        closed = false,
		clamped = false,
		homePingShow = true,
		worldPingShow = true,
		ilvldisplay = false,
		statsFrameUnlock = false,
		fpsShow = true,
		fontSize = 15,
		bordercol = 0.5,
		backgroundcol = 1,
		changedHeight = true,
		activeFont = defaultFont,
		thickOutline = false,
		frameHeight = defaultFrameHeight,
		frameWidth = defaultFrameWidth,
		isAnchored = true;
    },
}

function LagMonitor:OnInitialize()
    -- Called when the addon is loaded
	self:Print(addonLoadedMessage .. " Loaded!")
	self.db = LibStub("AceDB-3.0"):New("LagMonitorDB", defaults, true)
    LibStub("AceConfig-3.0"):RegisterOptionsTable("LagMonitor", options)
    self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("LagMonitor", "LagMonitor")
end

function statsFrame:OnEvent(event, arg1)
	if event == "ADDON_LOADED" and arg1 == "LagMonitor" then
		
		AddonLoaded();
		
		declareFont();
		
		statsFrameDeclare();
	
		StatsFrameMove();
		
		StatsBorder:SetTexture(edgeFile)
		StatsBorder:SetPoint("TOPLEFT",-5,5)
		StatsBorder:SetPoint("BOTTOMRIGHT",5,-5)
		StatsBorder:SetVertexColor(0.85, 0.85, 0.85, LagMonitor.db.profile.bordercol)

		
		StatsBody:SetTexture("Interface\\ChatFrame\\ChatFrameBackground")
		StatsBody:SetAllPoints(statsFrame)
		StatsBody:SetVertexColor(0.1, 0.1, 0.1, LagMonitor.db.profile.backgroundcol)
	end
end

statsFrame:SetScript("OnEvent", statsFrame.OnEvent);

local function onUpdate(self, elapsed)
iLevelSetting();

OutlineSetting();

FontUpdate();

end

statsFrame:SetScript("OnUpdate", onUpdate);

function pingFrame:OnEvent(event, arg1)
	if event == "ADDON_LOADED" and arg1 == "LagMonitor" then
	
		AddonLoaded();
		
		declareFont();
		
		pingFrameDeclare();
		
		--First used textures:
		--"Interface\\ChatFrame\\ChatFrameBackground"  = LagBorder
		
		--"Interface\\ChatFrame\\ChatFrameBackground"  = LagBody

		
		LagBorder:SetTexture(edgeFile)
		LagBorder:SetPoint("TOPLEFT",-5,5)
		LagBorder:SetPoint("BOTTOMRIGHT",5,-5)
		LagBorder:SetVertexColor(0.85, 0.85, 0.85, LagMonitor.db.profile.bordercol)

		
		LagBody:SetTexture("Interface\\ChatFrame\\ChatFrameBackground")
		LagBody:SetAllPoints(pingFrame)
		LagBody:SetVertexColor(0.1, 0.1, 0.1, LagMonitor.db.profile.backgroundcol)
	end
end

pingFrame:SetScript("OnEvent", pingFrame.OnEvent);

local function onUpdate(self, elapsed)
FrameSizeSetting();

OutlineSetting();

FontUpdate();

SortOrder();
	
updateInterval = updateInterval + elapsed
	if updateInterval >= 1 then	
		ShowColText();	
		updateInterval = 0;
	end
end

function statsFrameDeclare()
		statsFrame:SetHeight(statsFrameHeight);
		statsFrame:SetWidth(LagMonitor.db.profile.frameWidth);
		
		ilevel:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE");
		ilevel:SetPoint("LEFT", statsFrame, "LEFT", 0, 0);
		
		ilevelStats:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE");
		ilevelStats:SetPoint("RIGHT", statsFrame, "RIGHT", 0, 0);
		ilevelStats:SetTextColor(1, 1, 0, 1);
		
		ilevel:SetTextColor(1, 1, 0, 1);
		ilevel:SetFormattedText("ILevel:");
end

function pingFrameDeclare()
		pingFrame:SetHeight(LagMonitor.db.profile.frameHeight);
		pingFrame:SetWidth(LagMonitor.db.profile.frameWidth);
	
		--Declare font being used
		
	
		--Assign Local ping fonts
		pingLocal:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE");
		pingLocal:SetPoint("RIGHT", pingFrame, "TOPRIGHT", 0, -12);
	
		--Assign World ping fonts
		pingWorld:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE");
		pingWorld:SetPoint("RIGHT", pingFrame, "RIGHT", 0, 0);
	
		
		--Assign Game fps fonts
		gameFPS:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE");
		gameFPS:SetPoint("RIGHT", pingFrame, "BOTTOMRIGHT" , 0, 12);
		
--PASTE BUTTON HERE
		
		--Assign Game fps fonts
		pLocal:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE");
		pLocal:SetPoint("LEFT", pingFrame, "TOPLEFT", 0, -12);
		
		--Assign Game fps fonts
		pWorld:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE");
		pWorld:SetPoint("LEFT", pingFrame, "LEFT", 0, 0);
		
		--Assign Game fps fonts
		gFPS:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE");
		gFPS:SetPoint("LEFT", pingFrame, "BOTTOMLEFT", 0, 12);
		
		pLocal:SetTextColor(1, 1, 0, 1);
		pLocal:SetFormattedText("Home(ms):");
		
		pWorld:SetTextColor(1, 1, 0, 1);
		pWorld:SetFormattedText("World(ms):");
		
		gFPS:SetTextColor(1, 1, 0, 1);
		gFPS:SetFormattedText("FPS:");
end

function StatsFrameMove()
	if LagMonitor.db.profile.statsFrameUnlock == true then
		LagMonitor.db.profile.isAnchored = false;
		statsFrame:EnableMouse(true);
		statsFrame:SetMovable(true);
		statsFrame:SetResizable(true);
	end
	if LagMonitor.db.profile.statsFrameUnlock == false and LagMonitor.db.profile.isAnchored == true then
		statsFrame:EnableMouse(false);
		statsFrame:SetMovable(false);
		statsFrame:SetResizable(false);
	end
	if LagMonitor.db.profile.statsFrameUnlock == false and LagMonitor.db.profile.isAnchored == false then
		statsFrame:EnableMouse(false);
		statsFrame:SetMovable(true);
		statsFrame:SetResizable(true);
	end
end

function declareFont()
myFont = LSM:Fetch("font","Font" .. LagMonitor.db.profile.activeFont);
end

function AddonLoaded()
		if LagMonitor.db.profile.closed == true then
			pingFrame:Hide();
			statsFrame:Hide();
		end
		if LagMonitor.db.profile.closed == false then
			pingFrame:Show();
			statsFrame:Show();
		end
		if LagMonitor.db.profile.locked == true then
			pingFrame:EnableMouse(false);
		end
		if LagMonitor.db.profile.locked == false then
			pingFrame:EnableMouse(true);
		end
		if LagMonitor.db.profile.clamped == true then
			pingFrame:SetClampedToScreen(true);
			statsFrame:SetClampedToScreen(true);
		end
		if LagMonitor.db.profile.clamped == false then
			pingFrame:SetClampedToScreen(false);
			statsFrame:SetClampedToScreen(false);
		end
		if LagMonitor.db.profile.homePingShow == false then
			pLocal:Hide();
			pingLocal:Hide();
		end
		if LagMonitor.db.profile.worldPingShow == false then
			pWorld:Hide();
			pingWorld:Hide();
		end
		if LagMonitor.db.profile.fpsShow == false then
			gFPS:Hide();
			gameFPS:Hide();
		end	
		if LagMonitor.db.profile.ilvldisplay == true then
			statsFrame:Show();
		end
		if LagMonitor.db.profile.ilvldisplay == false then
			statsFrame:Hide();
		end
end

function FrameSizeSetting()	
	if LagMonitor.db.profile.frameWidth ~= defaultFrameWidth then
		pingFrame:SetWidth(LagMonitor.db.profile.frameWidth);
	end
	if LagMonitor.db.profile.frameWidth == defaultFrameWidth then
		pingFrame:SetWidth(defaultFrameWidth);
	end
	if LagMonitor.db.profile.frameHeight ~= defaultFrameHeight and LagMonitor.db.profile.changedHeight == false then
		pingFrame:SetHeight(LagMonitor.db.profile.frameHeight);
	end
end

function iLevelSetting()
	local overall, equipped = GetAverageItemLevel();
	rOverall = round(overall, 1);
	rEquipped = round(equipped, 1);
	if equipped ~= overall then
		ilevelStats:SetFormattedText(rEquipped .. "/" .. rOverall);
	end
	if equipped == overall then
		ilevelStats:SetFormattedText(rEquipped);
	end
end

function FontUpdate()
if LagMonitor.db.profile.activeFont == defaultFont then
	LagMonitor.db.profile.activeFont = defaultFont;
end
if LagMonitor.db.profile.activeFont == defaultFont then
	LagMonitor.db.profile.activeFont = defaultFont;
end
end

function OutlineSetting()
--Change font sizes
if LagMonitor.db.profile.thickOutline == false then
pingLocal:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE")
pingWorld:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE")
gameFPS:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE")
pLocal:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE")
pWorld:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE")
gFPS:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE")
ilevel:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE")
ilevelStats:SetFont(myFont,LagMonitor.db.profile.fontSize,"OUTLINE")
end

if LagMonitor.db.profile.thickOutline == true then
pingLocal:SetFont(myFont,LagMonitor.db.profile.fontSize,"THICKOUTLINE")
pingWorld:SetFont(myFont,LagMonitor.db.profile.fontSize,"THICKOUTLINE")
gameFPS:SetFont(myFont,LagMonitor.db.profile.fontSize,"THICKOUTLINE")
pLocal:SetFont(myFont,LagMonitor.db.profile.fontSize,"THICKOUTLINE")
pWorld:SetFont(myFont,LagMonitor.db.profile.fontSize,"THICKOUTLINE")
gFPS:SetFont(myFont,LagMonitor.db.profile.fontSize,"THICKOUTLINE")
ilevel:SetFont(myFont,LagMonitor.db.profile.fontSize,"THICKOUTLINE")
ilevelStats:SetFont(myFont,LagMonitor.db.profile.fontSize,"THICKOUTLINE")
end
end

function ShowColText()
	local up, down, home, world = GetNetStats();
	local fps = GetFramerate();

				if LagMonitor.db.profile.showColText == true then
				if home < 250 then
				pingLocal:SetTextColor(0, 1, 0, 1);
				end
				if ((home >= 250) and (home < 400)) then
				pingLocal:SetTextColor(1, 1, 0, 1);
				end
				if home >= 400 then
				pingLocal:SetTextColor(1, 0, 0, 1);
				end
			end
			if LagMonitor.db.profile.showColText == false then
				pingLocal:SetTextColor(1, 1, 0, 1);
			end
			--Display Local ping
			pingLocal:SetFormattedText(home);
	
				if LagMonitor.db.profile.showColText == true then
				if world < 250 then
				pingWorld:SetTextColor(0, 1, 0, 1);
				end
				if ((world >= 250) and (world < 400)) then
				pingWorld:SetTextColor(1, 1, 0, 1);
				end
				if world >= 400 then
				pingWorld:SetTextColor(1, 0, 0, 1);
				end
			end
			if LagMonitor.db.profile.showColText == false then
				pingWorld:SetTextColor(1, 1, 0, 1);
			end
			--Display World ping
			pingWorld:SetFormattedText(world);

			--Display Game FPS
				if LagMonitor.db.profile.showColText == true then
				if floor(fps) <= 30 then
				gameFPS:SetTextColor(1, 0, 0, 1);
				end
				if ((floor(fps) > 30) and (floor(fps) <= 60)) then
				gameFPS:SetTextColor(1, 1, 0, 1);
				end
				if floor(fps) > 60 then
				gameFPS:SetTextColor(0, 1, 0, 1);
				end
			end
			if LagMonitor.db.profile.showColText == false then
				gameFPS:SetTextColor(1, 1, 0, 1);
			end
			gameFPS:SetFormattedText(floor(fps));
end

function ResetSettings()
	LagMonitor.db.profile.showColText = true;
	LagMonitor.db.profile.closed = false;
	LagMonitor.db.profile.fontSize = 15;
	LagMonitor.db.profile.locked = false;
	LagMonitor.db.profile.backgroundcol = 1;
	LagMonitor.db.profile.bordercol = 0.5;
	LagMonitor.db.profile.clamped = false;
	LagMonitor.db.profile.ilvldisplay = false;
	LagMonitor.db.profile.changedHeight = true;
	LagMonitor.db.profile.statsFrameUnlock = false;
	LagMonitor.db.profile.IsAnchored = true;
	
	pingFrame:Show();
	statsFrame:Hide();
	pingFrame:ClearAllPoints();
	pingFrame:SetPoint("CENTER");
	pingFrame:EnableMouse(true);
	statsFrame:EnableMouse(false);
	
	LagBorder:SetVertexColor(0.85, 0.85, 0.85, LagMonitor.db.profile.bordercol);
	LagBody:SetVertexColor(0.1, 0.1, 0.1, LagMonitor.db.profile.backgroundcol);
	StatsBorder:SetVertexColor(0.85, 0.85, 0.85, LagMonitor.db.profile.bordercol);
	StatsBody:SetVertexColor(0.1, 0.1, 0.1, LagMonitor.db.profile.backgroundcol);
	statsFrame:ClearAllPoints();
	statsFrame:SetPoint("TOP", pingFrame, "BOTTOM", 0, -10);
	
	pingFrame:SetClampedToScreen(false);
	statsFrame:SetClampedToScreen(false);
	
	LagMonitor.db.profile.activeFont = defaultFont;
	myFont = LSM:Fetch("font","Font" .. defaultFont);
	
	pingFrame:SetHeight(defaultFrameHeight);
	statsFrame:SetHeight(statsFrameHeight);
	LagMonitor.db.profile.frameHeight = defaultFrameHeight;
	
	pingFrame:SetWidth(defaultFrameWidth);
	statsFrame:SetWidth(defaultFrameWidth);
	LagMonitor.db.profile.frameWidth = defaultFrameWidth;
	
	gFPS:Show();
	gameFPS:Show();
	pWorld:Show();
	pingWorld:Show();
	pLocal:Show();
	pingLocal:Show();
	
	LagMonitor.db.profile.homePingShow = true;
	LagMonitor.db.profile.worldPingShow = true;
	LagMonitor.db.profile.fpsShow = true;
	LagMonitor.db.profile.changedHeight = true;
	LagMonitor.db.profile.thickOutline = false;
	LagMonitor:Print("Reset to default settings!");
end

function SortOrder()

	if LagMonitor.db.profile.changedHeight == true then
	if LagMonitor.db.profile.homePingShow == false and LagMonitor.db.profile.worldPingShow == true and LagMonitor.db.profile.fpsShow == false then
		pingWorld:SetPoint("RIGHT", pingFrame, "TOPRIGHT", 0, -12);
		pWorld:SetPoint("LEFT", pingFrame, "TOPLEFT", 0, -12);
		pingFrame:SetHeight(25);
		LagMonitor.db.profile.frameHeight = 25;
	end
	if LagMonitor.db.profile.homePingShow == false and LagMonitor.db.profile.worldPingShow == true and LagMonitor.db.profile.fpsShow == true then
		pingWorld:SetPoint("RIGHT", pingFrame, "TOPRIGHT", 0, -12);
		pWorld:SetPoint("LEFT", pingFrame, "TOPLEFT", 0, -12);
		gameFPS:SetPoint("RIGHT", pingFrame, "BOTTOMRIGHT" , 0, 12);
		gFPS:SetPoint("LEFT", pingFrame, "BOTTOMLEFT" , 0, 12);
		pingFrame:SetHeight(45);
		LagMonitor.db.profile.frameHeight = 45;
	end
	if LagMonitor.db.profile.homePingShow == false and LagMonitor.db.profile.worldPingShow == false and LagMonitor.db.profile.fpsShow == true then
		gameFPS:SetPoint("RIGHT", pingFrame, "TOPRIGHT" , 0, -12);
		gFPS:SetPoint("LEFT", pingFrame, "TOPLEFT" , 0, -12);
		pingFrame:SetHeight(25);
		LagMonitor.db.profile.frameHeight = 25;
	end
	if LagMonitor.db.profile.homePingShow == true and LagMonitor.db.profile.worldPingShow == true and LagMonitor.db.profile.fpsShow == false then
		pingLocal:SetPoint("RIGHT", pingFrame, "TOPRIGHT", 0, -12);
		pLocal:SetPoint("LEFT", pingFrame, "TOPLEFT", 0, -12);
		pingWorld:SetPoint("RIGHT", pingFrame, "BOTTOMRIGHT", 0, 12);
		pWorld:SetPoint("LEFT", pingFrame, "BOTTOMLEFT", 0, 12);
		pingFrame:SetHeight(45);
		LagMonitor.db.profile.frameHeight = 45;
	end
	if LagMonitor.db.profile.homePingShow == true and LagMonitor.db.profile.worldPingShow == true and LagMonitor.db.profile.fpsShow == true then
		pingLocal:SetPoint("RIGHT", pingFrame, "TOPRIGHT", 0, -12);
		pLocal:SetPoint("LEFT", pingFrame, "TOPLEFT", 0, -12);
		pingWorld:SetPoint("RIGHT", pingFrame, "RIGHT", 0, 0);
		pWorld:SetPoint("LEFT", pingFrame, "LEFT", 0, 0);
		gameFPS:SetPoint("RIGHT", pingFrame, "BOTTOMRIGHT" , 0, 12);
		gFPS:SetPoint("LEFT", pingFrame, "BOTTOMLEFT" , 0, 12);
		pingFrame:SetHeight(defaultFrameHeight);
		LagMonitor.db.profile.frameHeight = defaultFrameHeight;
	end
	if LagMonitor.db.profile.homePingShow == true and LagMonitor.db.profile.worldPingShow == false and LagMonitor.db.profile.fpsShow == true then
		pingLocal:SetPoint("RIGHT", pingFrame, "TOPRIGHT", 0, -12);
		pLocal:SetPoint("LEFT", pingFrame, "TOPLEFT", 0, -12);
		gameFPS:SetPoint("RIGHT", pingFrame, "BOTTOMRIGHT" , 0, 12);
		gFPS:SetPoint("LEFT", pingFrame, "BOTTOMLEFT" , 0, 12);
		pingFrame:SetHeight(45);
		LagMonitor.db.profile.frameHeight = 45;
	end
	if LagMonitor.db.profile.homePingShow == true and LagMonitor.db.profile.worldPingShow == false and LagMonitor.db.profile.fpsShow == false then
		pingLocal:SetPoint("RIGHT", pingFrame, "TOPRIGHT", 0, -12);
		pLocal:SetPoint("LEFT", pingFrame, "TOPLEFT", 0, -12);
		pingFrame:SetHeight(25);
		LagMonitor.db.profile.frameHeight = 25;
	end
	if LagMonitor.db.profile.homePingShow == false and LagMonitor.db.profile.worldPingShow == false and LagMonitor.db.profile.fpsShow == false then
		pingFrame:Hide();
		isHidden = true;
	end
end
end

pingFrame:SetScript("OnUpdate", onUpdate);