--[[
   KahLua KonferSK - a suicide kings loot distribution addon.
     WWW: http://kahluamod.com/ksk
     Git: https://github.com/kahluamods/konfersk
     IRC: #KahLua on irc.freenode.net
     E-mail: cruciformer@gmail.com
   Please refer to the file LICENSE.txt for the Apache License, Version 2.0.

   Copyright 2008-2018 James Kean Johnston. All rights reserved.
   
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
]]

local K = LibStub:GetLibrary("KKore")

if (not K) then
  error ("KahLua KonferSK: Impossible de trouver KahLua Kore.", 2)
end

local L = K:RegisterI18NTable("KKonferSK", "frFR")
if (not L) then
  return
end

-- Translated from English to French by Grimal for "les gardiens de l'ombre" - Alliance PvE Guild @ Sinstralis - EU
-- version 1.1 Release




L["MODTITLE"] = "KonferSK"
L["MODNAME"] = "konfersk"
L["MODABBREV"] = "KSK"
L["CMDNAME"] = "ksk"
L["CMD_CONFIG"] = "config"
L["CMD_USERS"] = "joueurs"
L["CMD_HELP"] = "aide"
L["CMD_LOOT"] = "loot"
L["CMD_LISTS"] = "listes"
L["CMD_SYNC"] = "synchro"
L["CMD_VERSION"] = "version"
L["CMD_RESETPOS"] = "resetpos"
L["CMD_REPAIR"] = "reparer"
L["CMD_SUSPEND"] = "suspendre"
L["CMD_RESUME"] = "reprendre"
L["CMD_VERSIONCHECK"] = "versioncheck"
L["CMD_SELECTCONFIG"] = "selectconfig"
L["CMD_CREATECONFIG"] = "creerconfig"
L["CMD_DELETECONFIG"] = "supprconfig"
L["CMD_RENAMECONFIG"] = "renommerconfig"
L["CMD_COPYCONFIG"] = "copierconfig"
L["CMD_CREATEUSER"] = "creerjoueur"
L["CMD_DELETEUSER"] = "supprjoueur"
L["CMD_RENAMEUSER"] = "renommerjoueur"
L["CMD_SELECTLIST"] = "selectliste"
L["CMD_CREATELIST"] = "creerliste"
L["CMD_DELETELIST"] = "supprliste"
L["CMD_RENAMELIST"] = "renommerliste"
L["CMD_COPYLIST"] = "copierliste"
L["CMD_ADDITEM"] = "addobjet"
L["CMD_ADDLOOT"] = "addloot"
L["CMD_IMPORTGUILDUSERS"] = "importerjoueurguilde"
L["CMD_SHOW"] = "afficher"
L["SUBCMD_HELP"] = "aide"
L["SUBCMD_LOOT"] = "loot"
L["SUBCMD_ROLLS"] = "rolls"
L["SUBCMD_ADMIN"] = "admin"
L["SUBCMD_ASSIGN"] = "attrib"
L["SUBCMD_ITEMS"] = "objets"
L["SUBCMD_HISTORY"] = "historique"

L["ABOUT1"] = "Un probl\195\168me, un commentaire, une suggestion ?"
L["ABOUT2"] = "Adressez-les \195\160 <%s>. Merci !"
L["ABOUT3"] = "Rendez-vous sur %s pour davantage d'informations"

L["WHISPERCMD_BID"] = "bid"
L["WHISPERCMD_RETRACT"] = "retract"
L["WHISPERCMD_SUICIDE"] = "suicide"
L["WHISPERCMD_STANDBY"] = "standby"
L["WHISPERCMD_HELP"] = "ksk"

--
-- Main localisation strings start here
--

L["VCTITLE"] = "%s %s Version Check"
L["Version"] = "Version"
L["In Raid"] = "In Raid"
L["NEWMSG"] = "Entrez le nom du nouvel espace de configuration ci-dessous. Notez bien que ce nouvel espace ne partage absolument pas de donn\195\169es avec un autre espace de configuration. Cette nouvelle configuration sera trait\195\169e come si c'\195\169tait une copie enti\195\168re de Konfer qui tournait."
L["DELMSG"] = "Etes-vous vraiment s\195\187r de supprimer cette configuration ? Il n'est pas possible d'annuler cette op\195\169ration, et toutes les listes, permissions joueurs, historique de raid et 'user loot information' associ\195\169 avec cette configuration seront perdus. Si vous \195\170tes le possesseur de cette configuration et avez partag\195\169e celle-ci avec d'autres joueurs, vous devriez attendre que vous ayez transf\195\169r\195\169 la possession \195\160 un autre joueur, sinon ils ne pourront pas \195\169diter les configurations li\195\169es \195\160 la s\195\169curit\195\169 sur la liste. Soyez s\195\187r que la bonne liste est affich\195\169e ci-dessus avant de r\195\169aliser ceci."
L["DELUSER"] = "Etes-vous vraiment s\195\187r de vouloir supprimer ce joueur ? Il n'est pas possible d'annuler cette op\195\169ration ; tout l'historique du joueur et ses informations seront perdues, et le joueur sera supprim\195\169 de toutes les listes dans toutes les configurations, pas seulement dans celle active. Si ce joueur est un main et qu'il a des rerolls d\195\169finis, ils seront supprim\195\169s \195\169galement. Soyez bien s\195\187r que le bon joueur est affich\195\169 ci-dessus avant de r\195\169aliser ceci."
L["NEWLIST"] = "Entrer le nom de la nouvelle liste ci-dessous. Une fois la liste cr\195\169\195\169e, vous pourrez y ajouter des joueurs ou importer des joueurs depuis le roster de guilde. Vous pouvez aussi configurer diff\195\169rentes options en s\195\169lectionnant l'onglet \"Configuration\" en haut de la fen\195\170tre de gestion de liste."
L["DELLIST"] = "Etes-vous vraiment s\195\187r de supprimer cette liste ? Il n'est pas possible d'annuler cette op\195\169ration et tout l'historique de la liste et le classement seront perdus. Soyez s\195\187r d'avoir la bonne liste affich\195\169e ci-dessus avant de r\195\169aliser ceci."
L["AUTOASSIGN"] = "Cet objet est d\195\169fini pour \195\170tre automatiquement attribu\195\169 \195\160 %q. Cliquez sur 'Ok' pour donner l'objet \195\160 %s ou sur 'Annuler' pour ignorer le param\195\168tre d'auto-attribution."
L["AUTOSUICIDE"] = "Si vous d\195\169cidez de d\195\169cerner cet objet \195\160 %s, il ou elle sera automatiquement suicid\195\169 sur la liste %q."
L["AUTOLOOT"] = "Cet objet a \195\169t\195\169 gagn\195\169 par %s. CLiquez sur 'Ok' pour attribuer automatiquement l'objet \195\160 %s. Si vous cliquez sur 'Annuler', l'objet sera tout de m\195\170me supprim\195\169 de la liste, et vous aurez \195\160 l'attribuer \195\160 %s via l'interface joueur standard."
L["AUTODENCH"] = "Cet objet n'a pas de 'parieurs' L'enchanteur %q est connect\195\169 et dans le raid. Cliquez sur 'Ok' pour attribuer l'objet \195\160 %s. Cliquez sur 'Annuler' si vous voulez attribuer l'objet manuellement ou le rendre disponible au rand (l'objet restera dans la liste si cliquez sur 'Annuler')."
L["AUTODENCHNR"] = "Personne n'a rand sur cet objet. L'enchanteur %q est connect\195\169 et dans le raid. Cliquez sur 'Ok' pour attribuer l'objet \195\160 %s. Cliquez sur 'Annuler' si vous souhaitez attribuer cet objet manuellement (l'objet sera supprim\195\169 de la liste mais pas du cadavre ou du coffre)."
L["PUGCONFIG"] = "Le joueur %q a \195\169mis la configuration pick-up ci-dessus. S'il s'agit d'un groupe pick-up r\195\169gulier qui utilise %s pour administrer les loots, et si vous souhaitez garder la trace de tous les loots, les listes et membres, cliquez sur 'Ok' pour accepter et cr\195\169er cette configuration (vous ne recevrez pas d'autres confirmations pour cette configuration). Si vous d\195\169cidez de ne pas accepter cette diffusion, cliquez sur 'Annuler' (vous verrez cependant ce message chaque fois que le raid leader diffuse cette configuration)."
L["LISTPOSMSG"] = "%s : Ci-dessous se trouvent vos places dans la configuration %q. Au lieu d'utiliser cette commande, pourquoi ne pas t\195\169l\195\169charger %s et garder la trace des listes utilisant cet add-on ?"
L["RECOVERMSG"] = "Vous \195\170tes le possesseur de cette configuration et avez demand\195\169 une restauration depuis le joueur %q. Sachez que pour que la restauration fonctionne, %s doit \195\170tre enti\195\168rement synchronis\195\169 avec tous les autres administrateurs. Si vous lancez cette restauration, vous effacerez toute votre configuration (mais pas vos param\195\168tres locaux), dont les listes, joueurs, objets et historiques de loot. Proc\195\169der \195\160 une restauration doit \195\170tre le dernier recours pour faire face \195\160 une configuration corrompue. Si vous n'avez pas fait de back-up de votre fichier existant savedvariables, vous devriez d'abord fermer le jeu compl\195\168tement et le faire maintenant. Soyez vraiment s\195\187r que c'est ce que vous souhaitez faire. C'est une mesure radicale."

L["HELPMSG1"] = "%s : Pour utiliser %s, chuchotez l'une de ces commandes \195\160 un administrateur. Pour parier sur un objet ou pour vous r\195\169tracter, vous devez chuchoter au ma\195\174tre du butin. Toutes les autres commandes pevuent \195\170tre envoyer \195\160 n'importe quel administrateur %s."
L["HELPMSG2"] = "%s : %s - Ench\195\169rir sur l'objet actuel"
L["HELPMSG3"] = "%s : %s - R\195\169tracter (annuler) votre ench\195\168re actuelle"
L["HELPMSG4"] = "%s : %s - Afficher votre place sur les listes"
L["HELPMSG5"] = "%s : %s - Indique que vous \195\170tes disponible pour raider"

L["USER_RESERVED"] = "R"
L["USER_ENCHANTER"] = "E"
L["USER_FROZEN"] = "F"

L["error: "] = "erreur : "
L["Suicide Kings loot distribution system."] = "Syst\195\168me de loot Suicide Kings"
L["%s<%s>%s %s (version %d) - %s"] = "%s<%s>%s %s (Version %d) - %s"
L["/%s [command [arg [arg...]]]"] = "/%s [commande [arg [arg...]]]"
L["Usage: "] = "Emploi : "
L["  Open the list management window."] = "Ouvre la fen\195\170tre de gestion de liste."
L["  Opens the user list management window."] = "Ouvre la fen\195\170tre de gestion des joueurs."
L["  Opens the loot management window."] = "Ouvre la fen\195\170tre de gestion de loot."
L["  Opens the sync manager window."] = "Ouvre la fen\195\170tre de gestion de synchronisation."
L["  Suspend %s (no auto-open on loot, no missing member warnings etc)."] = "Suspendre %s (pas d'ouverture auto au loot, pas d'avertissement de membre manquant, etc)."
L["  Resume normal %s operations."] = "  Reprendre les activits normales de %s."
L["  Set up various options and manage configurations."] = " Configurer diverses options et g\195\169rer les configurations."
L["  %s - configure lists and list options"] = "  %s - Configurer les listes et les options de liste"
L["  %s - set up loot related options"] = "  %s - Configurer les options li\195\169es au loot"
L["  %s - set up roll related options"] = "  %s - Configurer les options li\195\169es au rand"
L["  %s - set up config spaces and permissions options"] = "  %s - Configurer les espaces de configuration et les options de permission"
L["  %s - open the loot assignment window"] = "  %s - Ouvrir la fen\195\170tre d'attribution de loot"
L["  %s - open the item editor window"] = "  %s - Ouvrir la fen\195\170tre d'\195\169dition d'objets"
L["  %s - open the item history window"] = "  %s - Ouvrir la fen\195\170tde d'historique des objets"
L["/%s %s name"] = "/%s %s nom" 
L["/%s %s [itemid | itemlink]"] = "/%s %s [IDObjet | LienObjet]"
L["  Adds a new item to the item list."] = " Ajoute un nouvel objet \195\160 la liste d'objets"
L["  Adds a new item to the loot list."] = "  Ajoute un nouvel objet \195\160 la liste de loot"
L["/%s %s oldname newname"] = "/%s %s ancienNom nouveauNom"
L["  Selects the specified configuration as the current one."] = " D\195\169finit la configuration comme l'actuel." 
L["  Create the specified configuration."] = "  Cr\195\169e la configuration."
L["  Delete the specified configuration."] = "  Supprime la configuration."
L["  Renames the specified configuration."] = "  Renomme la configuration."
L["  Copies the specified configuration to a new one, with options."] = "  Copie la configuration vers une nouvelle, avec ses options."
L["/%s %s name class"] = "/%s %s nom classe"
L["  Adds a new user to the users list."] = "  Ajoute un nouveau joueur \195\160 la liste de joueurs."
L["  Removes a user from the users list."] = "  Supprime un joueur de la liste de joueurs."
L["  Renames a user after a paid name change."] = "  Renomme un joueur apr\195\168s un changement de nom payant."
L["%q is not a valid command. Type %s for help."] = "%q n'est pas une commande valide. Tapez %s pour plus d'aide."
L["Create Configuration"] = "Cr\195\169er configuration"
L["Delete Configuration"] = "Supprimer configuration"
L["Rename Configuration"] = "Renommer configuration"
L["Old Name"] = "Ancien nom"
L["New Name"] = "Nouveau nom"
L["Copy Configuration"] = "Copier la configuration"
L["Source Configuration"] = "Configuration source"
L["Destination Configuration"] = "Configuration cible"
L["Roll Lists to Copy"] = "Listes \195\160 copier"
L["Copy Co-admins"] = "Copier les co-admins"
L["Copy Configuration Options"] = "Copier les options de configuration"
L["Copy Raid History"] = "Copier l'historique de raid"
L["Copy Item Options"] = "Copier les options d'objets"
L["Copy All User Flags"] = "Copier tous les tags des joueurs"
L["usage: %s/%s %s name%s"] = "Usage : %s/%s %s Nom%s"
L["usage: %s/%s %s oldname newname%s"] = "Usage : %s/%s %sancienNom nouveauNom%s"
L["usage: %s/%s %s name class%s"] = "Usage : %s/%s %s nom classe%s"
L["Auto-open Bid Panel When Corpse Looted"] = "Ouvrir auto la fen\195\170tre d'ench\195\168res lors du loot"
L["Silent Bidding"] = "Ench\195\168res silencieuses ?"
L["Display Tooltips in Loot List"] = "Afficher les infos-bulles dans la liste"
L["Enable Chat Message Filter"] = "Masquer les chuchotements SK"
L["Record Loot Assignment History"] = "Enregistrer l'historique d'attribution de loot"
L["Open Roll Timeout"] = "Temps restant pour le rand"
L["Roll Timeout Extension"] = "Extension de temps pour rand"
L["Use Default Roll List"] = "Utiliser la liste par d\195\169faut"
L["Auto-assign Loot When Bids Close"] = "Attribution auto du loot quand les ench\195\168res sont termin\195\169es"
L["When there are no successful bids ..."] = "Quand personne n'a ench\195\169ri...."
L["Try Open Roll"] = "Lancer les rands"
L["Assign BoE Items to Master Looter"] = "Attribuer les objets LqE au ma\195\174tre du butin"
L["Assign To Enchanter"] = "Attribuer \195\160 un enchanteur"
L["invalid configuration name. Please try again."] = "Nom de configuration invalide. R\195\169essayez."
L["configuration %q created."] = "Configuration %q cr\195\169\195\169e."
L["configuration %q already exists. Try again."] = "La configuration %q existe d\195\169j\195\160. R\195\169ssayez."
L["configuration %q does not exist. Try again."] = "La configuration %q n'existe pas. R\195\169essayez."
L["Lists"] = "Listes"
L["List Manager"] = "Gestion des listes"
L["Members"] = "Membres"
L["Config"] = "Configuration"
L["Users"] = "Joueurs"
L["User List Manager"] = "Gestion de la liste de joueurs"
L["Loot"] = "Loot"
L["Loot Manager"] = "Gestion des loots"
L["Assign Loot"] = "Attribution de loots"
L["Item Editor"] = "Edition d'objets"
L["Sync"] = "Synchronisation"
L["Rolls"] = "Rands"
L["Sync Manager"] = "Gestion des synchronisations"
L["Config Manager"] = "Gestion des configurations"
L["Admin"] = "Admin"
L["Create"] = "Cr\195\169er"
L["Add"] = "Ajouter"
L["Delete"] = "Supprimer"
L["Rename"] = "Renommer"
L["Copy"] = "Copier"
L["Update"] = "M\195\160J"
L["Set As Default"] = "D\195\169finir par d\195\169faut"
L["Reset"] = "Reset"
L["Select"] = "S\195\169lectionner"
L["Config Owner"] = "Possesseur de config"
L["Alts Tethered to Mains"] = "Rerolls attach\195\169s aux mains"
L["cannot delete configuration %q - KonferSK requires at least one configuration."] = "Impossible de supprimer la configuration %q - KonferSK n\195\169cessite au moins une configuration."
L["configuration %q deleted."] = "Configuration %q supprim\195\169e."
L["user %q deleted."] = "joueur %q supprim\195\169."
L["roll list %q deleted."] = "Liste %q supprim\195\169e."
L["NOTICE: default configuration changed to %q."] = "Avertissement : configuration par d\195\169faut pass\195\169e \195\160 %q."
L["NOTICE: configuration %q renamed to %q."] = "Avertissement : Configuration %q renomm\195\169e en %q."
L["NOTICE: user %q renamed to %q."] = "Avertissement : joueur %q renomm\195\169 en %q."
L["NOTICE: roll list %q renamed to %q."] = "Avertissement : Liste %q renomm\195\169e en %q."
L["Co-admins"] = "Co-Admins"
L["User Role"] = "R\195\180le du joueur"
L["Not Set"] = "Non d\195\169fini"
L["Tank"] = "Tank"
L["Ranged DPS"] = "DPS distant"
L["Melee DPS"] = "DPS CaC"
L["Healer"] = "Heal"
L["Spellcaster"] = "DPS magique"
L["User is an Enchanter"] = "Le joueur est un enchanteur"
L["User is an Alt of"] = "Le joueur est un reroll"
L["User is Frozen"] = "Le joueur est gel\195\169"
L["Guild Import"] = "Import de guilde"
L["user %q already exists. Try again."] = "Le joueur %q existe d\195\169j\195\160. R\195\169essayez."
L["user %q does not exist. Try again."] = "Le joueur %q n'existe pas. R\195\169essayez."
L["user %q created."] = "joueur %q cr\195\169\195\169."
L["cannot complete command until a configuration space exists."] = "Ne peut pas achever la commande tant qu'un espace de configuration n'existe pas."
L["invalid class %q specified. Valid classes are:"] = "Classe %q invalide. Les classes valides sont :"
L["cannot delete user %q as they are the owner of the configuration."] = "Impossible de supprimer le joueur %q car il s'agit du posesseur de la configuration"
L["Delete All Alts of User"] = "Supprimer tous les rerolls du joueur"
L["Create User"] = "Cr\195\169er joueur"
L["Delete User"] = "Supprimer joueur"
L["Rename User"] = "Renommer joueur"
L["User Name"] = "Nom du joueur"
L["User Class"] = "Classe du joueur"
L["you must set a user class."] = "Vous devez d\195\169finir une classe."
L["you must specify a character name."] = "Vous devez d\195\169finir le nom du personnage."
L["Import Guild Users"] = "Importer les joueurs depuis la guilde"
L["Guild Rank"] = "Rang de guilde"
L["added %d user(s)."] = "%d joueur(s) ajout\195\169(s)."
L["Assign Mains to Alts"] = "Assign Mains to Alts" -- WTF ?
L["Select Enchanter"] = "Choisir un enchanteur"
L["Select Co-admin"] = "Choisir un co-admin"
L["Currently Selected: "] = "Actuellement s\195\169lectionn\195\169 : "
L["Create Roll List"] = "Cr\195\169er une liste"
L["Delete Roll List"] = "Supprimer une liste"
L["Rename Roll List"] = "Renommer une liste"
L["Copy Roll List"] = "Copier une liste"
L["Source List"] = "Liste source"
L["Destination List"] = "Liste cible"
L["Broadcast"] = "Diffuser"
L["Announce"] = "Annoncer"
L["Announce All"] = "Annoncer tout"
L["invalid roll list name. Please try again."] = "Nom de liste invalide. R\195\169essayez."
L["roll list %q already exists. Try again."] = "La liste %q existe d\195\169j\195\160. R\195\169essayez."
L["roll list %q does not exist. Try again."] = "La liste %q n'existe pas. R\195\169essayez."
L["roll list %q created."] = "Lise %q cr\195\169\195\169e."
L["you do not have permission to do that in this configuration."] = "Vous n'avez pas les permissions de faire ceci dans cette configuration."
L["you are not an administrator of this configuration. Your access to it is read-only."] = "Vous n'\195\170tes pas un administrateur de cette configuration. Votre acc\195\168s est en lecture seule."
L["you are the master looter but not an administrator of this configuration. You will be unable to loot effectively. Either change master looter or have the owner of the configuration assign you as an administrator."] = "Vous \195\170tes le ma\195\174tre du butin mais pas un administrateur de cette configuration. Vous serez incapable de looter efficacement. Changez le ma\195\174tre du butin ou demandez au possesseur de la configuration de vous d\195\169signer comme administrateur." -- \195\160 revoir
L["no active configuration. Either create one with %s or wait for a guild admin to broadcast the guild list."] = "Pas de configuration active.  Cr\195\169ez-en une avec %q ou attendez qu'un administrateur de la guilde diffuse la liste de guilde."
L["Insert"] = "Ins\195\169rer"
L["Delete"] = "Supprimer"
L["King"] = "Roi"
L["Move Up"] = "Monter"
L["Move Down"] = "Descendre"
L["Suicide"] = "Suicider"
L["Reserve"] = "R\195\169server"
L["Unreserve"] = "Annuler r\195\169servation"
L["Add Missing"] = "Ajouter les manquants"
L["NOTICE: user %q is in the raid but not in the user list."] = "Attention : le joueur %q est dans le raid mais pas dans la liste de joueurs."
L["Insert Roll List Member"] = "Ins\195\169rer un membre de la liste"
L["Insert Randomly"] = "Ins\195\169rer au hasard"
L["Sort Order"] = "Ordre de tri"
L["Strict Class Armor Filtering"] = "Filtre strict sur les classes d'armure"
L["Strict Role Filtering"] = "Filtre strict sur les r\195\180les"
L["Suicide on Additional List"] = "Suicider aussi sur une autre liste"
L["Show Tethered Alts"] = "Afficher les rerolls associ\195\169s"
L["None"] = "Aucun" 
L["Open Roll"] = "Rand ouvert"
L["Import"] = "Import"
L["Export"] = "Export"
L["Import List Members"] = "Importer les membres d'une liste"
L["Export List Members"] = "Exporter les membres d'une liste"
L["Guild Rank to Import"] = "Rang de guilde \195\160 importer"
L["CSV Import"] = "Import CSV"
L["Class Filter"] = "Filtre \195\160 classe"
L["Other Filters"] = "Autres filtres"
L["Strict Class Armor"] = "Classe d'armure strict"
L["Strict Role Filter"] = "Filtre strict sur les r\195\180les"
L["Bid"] = "Ench\195\169rir"
L["Retract"] = "Se r\195\169tracter"
L["Force Bid"] = "Faire ench\195\169rir"
L["Force Retract"] = "Faire r\195\169tracter"
L["Open Bids"] = "Ouvrir les ench\195\168res"
L["Close Bids"] = "Fermer les ench\195\168res"
L["Pause"] = "Pause"
L["End Roll"] = "Finir les rands"
L["Resume"] = "Reprendre"
L["Remove"] = "Supprimer"
L["Ignore Item"] = "Ignorer l'objet"
L["Roll on Specific List"] = "Attribuer sur une liste sp\195\169cifique"
L["Class Restriction"] = "Restriction de classe"
L["Role Restriction"] = "Restriction de r\195\180le"
L["Assign Next Drop to User"] = "Attribuer le prochain loot au joueur"
L["Auto-Remove When Assigned"] = "Suppression auto lors de l'attribution"
L["Suicide User on List"] = "Suicider le joueur sur la liste"
L["your version of %s is out of date. Please update it."] = "Votre version de %s n'est pas \195\160 jour. T\195\169l\195\169chargez-la sur le site des GDO."
L["Announce Loot"] = "Annoncer le loot"
L["Announce Winners in Guild Chat"] = "Annoncer les gagnants sur le canal de guilde"
L["Nowhere"] = "Nulle part"
L["In Guild Chat"] = "En guilde"
L["In Raid Chat"] = "En raid"
L["Loot from %s: "] = "Loot\195\169 sur %s : "
L["Chest"] = "Coffre"
L["Config Type"] = "Type de configuration"
L["Guild"] = "Guilde"
L["PUG"] = "Pick-up"
L["item %s already exists."] = "L'objet %s existe d\195\169j\195\160."
L["item %d is an invalid item."] = "L'objet %d est un objet invalide"
L["Initial Guild Rank Filter"] = "Filtre sur le rang de guilde de d\195\169part"
L["Request Sync"] = "Demande synchro"
L["Request Sync (All)"] = "Demande synchro (tous)"
L["Broadcast"] = "Diffuser"
L["Recover"] = "Restaurer"
L["sync request received from %q but I do not recognise them as an admin. Please sync with the config owner (%q)."] = "Demande de synchronisation re\195\167ue de %q mais il n'est pas reconnu en tant qu'administrateur. Veuillez vous synchroniser avec le possesseur de la configuration(%q)."
L["Bids now open for %s on the %q list."] = "Les ench\195\168res sont maintenant ouvertes pour %s sur la liste %q."
L["Bid list changed to %q for %s."] = "Liste d'ench\195\168res chang\195\169e \195\160 %q pour %s"
L["%s: to bid on %s, whisper %s the word %q. For general help using %s, whisper an admin the word %q."] = "%s : Pour ench\195\169rir sur %s, chuchotez \195\160 %s le mot %q. Pour une aide g\195\169n\195\169rale sur %s, chuchotez \195\160 un administrateur le mot %q."
L["%s: bids closing in: %d"] = "%s : Ench\195\168res termin\195\169es dans : %d"
L["%s: %s%s (group %d) won %s. Grats!"] = "%s : %s%s (Groupe %d) a gagn\195\169 %s. GG !"
L["%s: %s%s won %s. Grats!"] = "%s : %s%s a gagn\195\169 %s. GG !"
L["%s: %s was auto-assigned %s."] = "%s : %s a \195\169t\195\169 attribu\195\169 automatiquement \195\160 %s."
L["%s: to retract your bid whisper %s the word %q."] = "%s : Pour r\195\169tracter votre ench\195\168re chuchotez \195\160 %s le mot %q."
L["%s: bid retracted"] = "%s : Ench\195\168re' r\195\169tract\195\169e"
L["%s: no item currently being bid on."] = "%s : Il n'y actuellement pas d'objet mis aux ench\195\168res."
L["%s: you are not a member of the current list (%q) - bid ignored."] = "%s: Vous ne faites pas partie de la liste actuelle (%q) - ench\195\168re ignor\195\16e9."  
L["%s: you do not meet the current guild rank requirement (%q) - %s ignored."] = "%s : Vous ne remplissez pas les conditions de rang de guilde (%q) - %s ignor\195\169."
L["%s: you do not meet the current role requirement (%q). Your current role is %q - %s ignored."] = "%s : Vous ne remplissez pas les conditions de r\195\180le (%q) - %s ignor\195\169."
L["%s: you do not meet the current class restrictions (%s) - %s ignored."] = "%s : Vous ne remplissez pas les restrictions de classe (%s) - %s ignor\195\169."
L["Auto-assign Loot"] = "Attribution auto du loot"
L["bid"] = "Ench\195\168re"
L["roll"] = "Rand"
L["retracted"] = "s'est r\195\169tract\195\169" 
L["%s: there is no item currently open for bids."] = "%s : Il n'y a pas d'objet actuellement mis aux ench\195\168res."
L["%s: you are not eligible to receive loot - %s ignored."] = "%s : Vous n'\195\170tes pas autoris\195\169 \195\160 recevoir ce loot - %s ignor\195\169."
L["%s: I am not the master looter - %q is."] = "%s: Je ne suis pas le ma\195\174tre du butin - %q l'est."
L["%s: I am not the master looter."] = "%s: je ne suis pas le ma\195\174tre du butin."
L["%s: loot method is not master looter, there is no bidding."] = "%s : Le type de butin n'est pas le ma\195\174tre du butin, il n'y a pas de mises aux ench\195\168res." 
L["%s: you were not found in the user list. Contact an admin for help."] = "%s : Vous n'avez pas \195\169t\195\169 trouv\195\169 dans la liste. Contactez un administrateur pour de l'aide."
L["%s: you are not in my guild - bid ignored."] = "%s : Vous n'\195\170tes pas dans la guilde - ench\195\168re ignor\195\169e."
L["user %q has no role defined - permitting %s."] = "Le joueur %q n'a pas de r\195\180le d\195\169fini - permitting %s." -- WTF ?
L["%s: you are not a member of the %q list - bid ignored."] = "%s : Vous ne faites pas partie de la liste %q - ench\195\168re ignor\195\169e."
L["%q attempted to bid on the %q list but is not a member."] = "%q a essay\195\169 d'ench\195\169rir sur la liste %q mais il n'en fait pas partie."
L["%s: you have already bid on that item. Whisper %s the word %q to retract your bid."] = "%s : Vous avez d\195\169j\195\160 ench\195\169ri sur cet objet. Chuchotez  %s le mot %q pour vous r\195\169tracter."
L["%s: new bid received. Number of bidders: %d."] = "%s : nouvelle ench\195\168re reue. Nombre d'ench\195\169risseurs : %d."
L["%s: bid retracted. Number of bidders: %d."] = "%s : Ench\195\168re r\195\169tract\195\169e. Nombre d'ench\195\169risseurs : %d."
L["%s: %s (position %d) has bid (highest bidder is %s)."] = "%s : %s (Place n\194\176 %d) a ench\195\169ri (le plus haut ench\195\169risseur est %s)."
L["%s: %s has retracted (highest bidder is %s)."] = "%s : %s s'est r\195\169tract\195\169 (le plus haut ench\195\169risseur est %s)."
L["%s: %s has retracted (no other bidders)."] = "%s : %s s'est r\195\169tract\195\169."
L["%s: no successful bids for %s."] = "%s : Personne n'a ench\195\169ri pour %s."
L["Note: only top 5 rolls shown."] = "Note :Seulement les 5 meilleurs rands sont montr\195\169s."
L["Roll for %s within %d seconds."] = "Rand pour %s dans les %d secondes."
L["Suicide Roll (on list %q) for %s within %d seconds."] = "Rand suicide (sur la liste %q) pour %s dans les %d secondes."
L["%s: type '/roll' for main spec, '/roll 101-200' for off-spec or '/roll 1-1' to cancel a roll."] = "%s : Tapez '/rand' pour un +1, '/rand 101-200' pour un +2 ou '/rand 1-1' pour annuler un rand."
L["%s: type '/roll' for main spec or '/roll 1-1' to cancel a roll."] = "%s : Tapez '/rand' pour un +1 ou '/rand 1-1' pour annuler un rand."
L["%s: roll closing in: %d"] = "%s : Les rands se terminent dans : %d"
L["Roll closing in %s"] = "Les rands se terminent dans %s"
L["%s: invalid roll. Use '/roll' for main spec, '/roll 101-200' for off-spec or '/roll 1-1' to cancel a roll."] = "%s : Rand invalide. Tapez '/rand' pour un +1, '/rand 101-200' pour un +2 ou '/rand 1-1' pour annuler un rand."
L["%s: invalid roll. Use '/roll' for main spec or '/roll 1-1' to cancel a roll."] = "%s : Rand invalide. Tapez '/rand' pour un +1 ou '/rand 1-1' pour annuler un rand."
L["%s: you already rolled %d. New roll ignored."] = "%s : Vous avez d\195\169j\195\160 rand %d. Nouveau rand ignor\195\169."
L["top main spec rollers: %s"] = "Classement des rands en +1 : %s"
L["top off-spec rollers: %s"] = "Classement des rands en +2 : %s"
L["%s: the following users tied with %d: %s. Roll again."] = "%s : Les joueurs suivants ont fait un ex-aequo avec %d : %s. Faites un nouveau rand."
L["%s: sorry you are not allowed to roll right now."] = "%s : D\195\169sol\195\169, vous n'\195\170tes pas autoris\195\169s \195\160 rand maintenant."
L["no-one rolled for %s."] = "Personne n'a rand pour %s"
L["%s %s on %s on the %s list."] = "%s %s sur %s sur la liste %s."
L["%s: relative positions of all currrent raiders for the %q list (ordered highest to lowest): "] = "%s : Positions relatives de tous les raideurs actuels pour la liste %q (class\195\169 du plus haut au plus bas) :"
L["%s: members of the %q list (ordered highest to lowest): "] = "%s : Membres de la liste %q (class\195\169 du plus haut au plus bas) : "
L["Accept Configuration"] = "Accepter la configuration"
L["configuration %q updated by %q"] = "Configuration %q mise \195\160 jour par %q"
L["Checksum: 0x%s"] = "Cl\195\169 de v\195\169rification : 0x%s"
L["Up to date"] = "A jour"
L["My checksum: %s"] = "Ma cl\195\169 de v\195\169rification : %s"
L["Not active!"] = "Inactif !"
L["maximum number of co-admins (36) reached"] = "Nombre maximum de co-admins (36) atteint"
L["%s: %s - #%d (#%d in raid)"] = "%s : %s - n\194\176%d (n\194\176%d dans le raid)"
L["%s: %s - #%d"] = "%s : %s - n%d"
L["%s: (End of list)"] = "%s : (fin de la liste)"
L["%s: you are not on any roll lists (yet)."] = "%s : Vous n'\195\170tes sur aucune liste (actuellement)."
L["sync with user %s complete."] = "Synchronisation avec le joueur %s termin\195\169e."
L["sending sync data to user %s."] = "Envoi des donn\195\169es de synchro au joueur %s."
L["%s: %s cancelled!"] = "%s : %s a annul\195\169 !"
L["Set List to Imported Values"] = "Ecraser la liste actuelle"
L["Add to Existing Members"] = "Ajouter en fin de liste"
L["Randomly Add to Existing Members"] = "Ajouter alatoirement"
L["The following users are missing from the user list: %s"] = "Les joueurs suivants ne font pas partie de la liste de joueurs : %s"
L["Import from the CSV string cannot continue until these users are added."] = "L'import depuis le texte CSV ne peut pas continuer tant que ces joueurs ne sont pas ajout\195\169s."
L["Nothing"] = "Rien"
L["Export current list as CSV"] = "Exporter la liste actuelle au format CSV"
L["Export current list as XML"] = "Exporter la liste actuelle au format XML"
L["Export current list as BBcode"] = "Exporter la liste actuelle au format BBcode"
L["Export all lists as XML"] = "Exporter toutes les listes au format XML"
L["Export all lists as BBcode"] = "Exporter toutes les listes au format BBcode"
L["Export string"] = "Texte export\195\169"
L["Press Ctrl+C to copy the export string"] = "Appuyez sur CTRL+C pour copier le texte export\195\169"
L["Current list: %s"] = "Liste actuelle : %s"
L["%s using version %s"] = "%s utilise la version %s"
L["(in raid)"] = "(dans le raid)"
L["busy syncing with %q. Please try again when complete."] = "Synchronisation en cours avec %q. R\195\169essayez quand elle sera termin\195\169e."
L["History"] = "Historique"
L["Clear All"] = "Effacer tout"
L["Clear all except last week"] = "Effacer tout sauf la semaine derni\195\168re"
L["Clear all except last month"] = "Effacer tout sauf le mois dernier"
L["When"] = "Quand"
L["What"] = "Quoi"
L["Who"] = "Qui"
L["How"] = "Comment"
L["Disenchanted"] = "D\195\169senchant\195\169"
L["Bid: %s"] = "Ench\195\168re : %s"
L["Won Roll"] = "Rand gagn\195\169"
L["BoE assigned to ML"] = "LqE attribu\195\169 au ML" 
L["Auto-assigned"] = "Attribu\195\169 auto"
L["can only add items when in a raid and you are the master looter."] = "Vous pouvez seulement ajouter des objets lorsque vous \195\170tes dans un raid et que vous \195\170tes le ma\195\174tre du butin."
L["Note: player will need to pick item up manually."] = "Attention : le joueur devra ramasser l'objet manuellement."
L["User %s / %s lists"] = "joueur %s / %s la liste"
L["on"] = "dans"
L["not on"] = "pas dans"
L["Other Announcements"] = "Autres annonces"
L["Announce Bid List Changes"] = "Annoncer les changements sur la liste"
L["Announce Winners in Raid"] = "Annoncer les vainqueurs dans le raid"
L["Announce Bid Progression"] = "Annoncer la progression des ench\195\168res"
L["Usage Message When Bids Open"] = "Instructions \195\160 l'ouverture des ench\195\168res"
L["Usage Message When Rolls Open"] = "Instructions \195\160 l'ouverture des rands"
L["Announce Open Roll Countdown"] = "Annoncer le compte \195\160 rebours des rands"
L["Announce Open Roll Ties"] = "Annoncer les ex-aequo des rands"
L["Announce Bid / Roll Cancelation"] = "Annoncer les annulations de rands / ench\195\168res" 
L["Announce When No Successful Bids"] = "Annoncer lorsque les ench\195\168res ont \195\169chou\195\169"
L["Hide Absent Members in Loot Lists"] = "Cacher les membres absents sur les listes"
L["Enable Off-spec (101-200) Rolls"] = "Autoriser les rands pour les +2 (101-200)"
L["Enable Suicide Rolls by Default"] = "Activer le suicide sur rands par d\195\169faut"
L["Recover Configuration"] = "Restaurer la configuration"
L["waiting for recovery reply from %s. Do not use KSK until recovery is complete."] = "En attente d'une r\195\169ponse de restauration de %s. N'utilisez pas KSK tant que la restauration n'est pas termin\195\169e"
L["recovery from user %s complete."] = "Restauration depuis le joueur %s termin\195\169e."
L["Use Guild Rank Priorities"] = "Utiliser les priorit\195\169s sur rangs de guilde"
L["Edit"] = "Sauver"
L["Edit Rank Priorities"] = "Modifier les priorit\195\169s sur rangs"
L["Priority"] = "Priorit\195\169"
L["Add Missing Members"] = "Ajouter des membres manquants"
L["Add Missing Raid Members"] = "Ajouter des membres de raid manquants"
L["Add All Missing Members"] = "Ajouter tous les membres manquants"
L["added %s to list %q at position %s."] = "%s ajout\195\169 \195\160 la liste %q \195\160 la place %s."
L["Export Loot History"] = "Exporter l'historique des loots"
L["Undo"] = "Annuler"
L["Are you absolutely sure you want to undo this suicide?"] = "Etes-vous vraiment s\195\187r de vouloir annuler ce suicide ?"
L["User"] = "joueur"
L["List"] = "Liste"
L["Item"] = "Objet"
L["Minimum Level"] = "Niveau minimum"
L["Roll (main)"] = "Rand (+1)"
L["Roll (offspec)"] = "Rand (+2)"
L["Cancel Roll"] = "Annuler rand"
L["Bid / Roll Threshold"] = "Seuil de rand / ench\195\168re"
L["Auto-disenchant Items Below Threshold"] = "D\195\169senchanter automatiquement les objets en-dessous du seuil"
L["Auto-assign to Enchanter"] = "Auto-attribuer \195\160 un enchanteur"
L["Auto-assign to Master Looter"] = "Auto-attribuer au ma\195\174tre du butin"
L["Raiders Not on Current List"] = "Raideurs qui ne sont pas sur la liste actuelle"
L["users not on the %q list: %s"] = "joueurs qui ne sont pas sur la liste %q : %s"
L["User Search"] = "Rechercher un joueur"
L["Edit Officer Ranks"] = "Edit Officer Ranks"
L["Set Guild Officer Ranks"] = "Set Guild Officer Ranks"

--
-- Tooltip text.
--
L["TIP001"] = "Activer cette option pour que la fen\195\170tre de distribution de loot de KSK s'ouvre automatiquement au loot d'un corps qui a des objets qui correspondent au seuil du ma\195\174tre du butin."
L["TIP002"] = "Lorsqu'elle est activ\195\169e, cette option permet d'annoncer au raid qui a ench\195\169ri et qui est plus haut ench\195\169risseur. D\195\169sactiver cette option d\195\169sactivera ces messages."
L["TIP003"] = "Active l'affichage de l'info-bulle de l'objet lorsque la souris survole un objet dans la liste de distribution de loot."
L["TIP004"] = "Activer cette option pour cacher les chuchotements entrants d'ench\195\168res de joueurs et la plupart des chuchotements et avertissements envoy\195\169s. Ceci r\195\169duit les chances de manquer les vrais chuchotements des joueurs durant la phase de loot."
L["TIP005"] = "Activer cette option pour enregistrer qui a re\195\167u quel loot, quand et pourquoi. Si d\195\169sactiv\195\169, la fen\195\170tre d'historique des loots n'affichera que les loots des autres administrateurs qui n'ont pas d\195\169sactiv\195\169 cette option."
L["TIP006"] = "D\195\169signe o\195\185 KSK annoncera les loots trouv\195\169s sur un corps ou dans un coffre."
L["TIP006.1"] = "Ne pas annoncer les loots trouv\195\169s sur un corps ou dans un coffre."
L["TIP006.2"] = "Annoncer les loots trouv\195\169s sur un corps ou dans un coffre sur le canal guilde."
L["TIP006.3"] = "Annoncer les loots trouv\195\169s sur un corps ou dans un coffre sur le canal de raid."
L["TIP007"] = "Contr\195\180le exactement quels messages KSK diffuse aux joueurs dans le raid ou \195\160 la guilde durant la phase de loot."
L["TIP007.1"] = "Envoie un message au raid si le ma\195\174tre du butin change la liste sur laquelle les ench\195\168res ont lieu actuellement."
L["TIP007.2"] = "Envoie un message au raid lorsqu'une ench\195\168re a \195\169t\195\169 remport\195\169e et est donc termin\195\169e."
L["TIP007.3"] = "Envoie un message \195\160 la guilde lorsqu'une ench\195\168re a \195\169t\195\169 remport\195\169e et est donc termin\195\169e. Ceci s'applique uniquement aux configurations de guilde. Les configurations pick-up n'annoncent jamais sur le canal guilde."
L["TIP007.4"] = "Envoie un message chaque fois qu'une nouvelle ench\195\168re a \195\169t\195\169 re\195\167ue ou lorsqu'une ench\195\168re a \195\169t\195\169 annul\195\169e, avec l'ench\195\169risseur le plus haut actuellement. Le message n'est pas envoy\195\169 si l'ench\195\168re silencieuse est activ\195\169e."
L["TIP007.5"] = "A l'ouverture des ench\195\168res, envoie le message d'instructions qui d\195\169crit comment ench\195\169rir, se r\195\169tracter ou v\195\169rifier sa position dans la liste actuelle."
L["TIP007.6"] = "Lorsque vous d\195\169marrez un rand sur un objet, envoie le message d'instructions qui d\195\169crit comment rand pour sa sp\195\169 principale et pour sa seconde sp\195\169."
L["TIP007.7"] = "Lorsque vous lancez des rands sur un objet, affiche un compte \195\160 rebours lorsque le rand est sur le point de finir, et lorsque le compte \195\160 rebours est repouss\195\169 \195\160 cause de nouveaux rands re\195\167us en retard."
L["TIP007.8"] = "Lorsque vous lancez des rands sur un objet et qu'il y a des ex-aequo, annonce l'ex-aequo et relance les rands pour les ex-aequo."
L["TIP007.9"] = "Envoie un message lorsque le ma\195\174tre du butin annuler une ench\195\168re ou rand."
L["TIP007.10"] = "Lorsque personne n'a ench\195\169ri sur un objet, annonce au raid que l'objet va \195\170tre d\195\169senchant\195\169"
L["TIP007.11"] = "Lorsque vous changez de liste ou lorsque les loots commencent, affiche une liste de tous les raideurs actuelles qui ne sont pas sur la liste s\195\169lectionn\195\169e"
L["TIP008"] = "D\195\169finit combien de temps attendre pour les rands avant de d\195\169cider d'un vainqueur. Vous pouvez mettre en pause et terminer un rand une fois qu'il a \195\169t\195\169 lanc\195\169."
L["TIP009"] = "D\195\169finit le nombre de secondes suppl\195\169mentaires \195\160 ajouter au compte \195\160 rebours lorsqu'un rand a \195\169t\195\169 re\195\167u dans les 5 derni\195\168res secondes du compte \195\160 rebours."
L["TIP010"] = "S\195\169lectionne la liste \195\160 utiliser par d\195\169faut si aucune liste n'a \195\169t\195\169 automatiquement choisie pour l'objet dans l'\195\169diteur d'objets."
L["TIP011"] = "Si vous n'utilisez pas les priorit\195\169s sur les rangs de guilde, d\195\169finit le rang par d\195\169faut \195\160 partir duquel les joueurs peuvent ench\195\169rir."
L["TIP012"] = "Cache les joueurs qui ne sont pas raid de la liste des membres dans la fen\195\170tre de loot. Ceci n'a pas d'effet sur la liste des membres dans la gestion des listes, qui affiche toujours la liste compl\195\168te des membres. Activer cette option rend juste plus claire la lecture de la liste pour savoir qui est dans le raid et leurs positions relatives."
L["TIP013"] = "Cochez cette case pour utiliser la priorit\195\169s sur les rangs de la guilde, qui s'assurera qu'un membre avec un rang \195\160 priorit\195\169 plus \195\169lev\195\169e gagnera toujours face \195\160 un joueur avec un rang \195\160 priorit\195\169 moindre, m\195\170me si ce dernier est plus haut dans la liste."
L["TIP014"] = "Cliquez ici pour ouvrir l'\195\169diteur de priorit\195\169s des rangs de la guilde, qui permet de d\195\169finir la priorit\195\169 pour chaque rang de la guilde."
L["TIP015"] = "Si cette option est activ\195\169e et qu'un objet li\195\169 quand \195\169quip\195\169 n'a pas d'ench\195\169risseurs, l'objet est automatiquement attribu\195\169 au ma\195\174tre du butin."
L["TIP016"] = "Si cette option est activ\195\169e et qu'un objet n'a pas d'ench\195\169risseurs, on tentera de s'en d\195\169barasser en lan\195\167ant des rands."
L["TIP017"] = "Si cette option est activ\195\169e et qu'un objet n'a pas d'ench\195\169risseurs, qu'aucun joueur n'a rand dessus, et si l'un des enchanteurs d\195\169finis est connect\195\169, l'objet sera attribu\195\169 \195\160 l'un d'entre eux pour \195\170tre d\195\169senchant\195\169."
L["TIP018"] = "Cliquez pour choisir un enchanteur dans la liste des enchanteurs disponibles. Pour marquer un joueur comme \195\169tant enchanteur, rendez vous dans l'\195\169diteur de joueurs."
L["TIP019"] = "Cliquez pour cr\195\169er un nouvel espace de configuration."
L["TIP020"] = "Cliquez pour supprimer l'espace de configuration actuellement s\195\169lectionn\195\169."
L["TIP021"] = "Cliquez pour renommer l'espace de configuration actuellement s\195\169lectionn\195\169."
L["TIP022"] = "Cliquez pour copier l'espace de configuration actuellement s\195\169lectionn\195\169 vers une nouvelle configuration (avec options)."
L["TIP023"] = "Entrez le nom du joueur (qui doit \195\170tre pr\195\169sent dans la liste des joueurs) qui sera le possesseur de la nouvelle configuration."
L["TIP024"] = "Si cette option est activ\195\169e et qu'un joueur est d\195\169fini comme \195\169tant le reroll d'un autre joeuur, le main et ses rerolls occuperont la m\195\170me place sur toutes les listes. Si d\195\169sactiv\195\169e, le main et ses rerolls seront totalement ind\195\169pendants."
L["TIP025"] = "S\195\169lectionne le type de configuration. Une configuration de guilde se synchronisera via le canal d'add-on de guilde, tandis que la configuration pick-up le fera \195\160 travers le canal de raid."
L["TIP026"] = "Cliquez pour ajouter un nouveau co-admin \195\160 la liste."
L["TIP027"] = "Cliquez pour supprimer le co-admin actuellement s\195\169lectionn\195\169."
L["TIP028.0"] = "S\195\169lection de la configuration"
L["TIP028.1"] = "S\195\169lectionner la configuration \195\160 rendre active. Les configurations pour lesquelles vous \195\170tes un administrateur ou le possesseur sont en |cff00ff00vert|r, les autres en |cffffffffblanc|r."
L["TIP029"] = "Cliquez pour envoyer un message au raid qui liste tous les membres du raid actuels et leur position dans la liste. Si vous avez activ\195\169 le filtre de messages, vous ne verrez pas le texte qui est envoy\195\169 au raid, mais il sera bien envoy\195\169. Maintenez Shift enfonc\195\169 et cliquez pour annoncer sur le chat de guilde au lieu du canal de raid."
L["TIP030"] = "Cliquez pour ins\195\169rer un joueur dans la liste, soit \195\160 la fin ou \195\160 une place al\195\169atoire. Le joueur doit d'abord \195\170tre d\195\169fini dans l'\195\169diteur de joueurs. Seuls les joueurs qui ne sont pas d\195\169j\195\160 dans la liste seront affich\195\169s."
L["TIP031"] = "Cliquez pour supprimer le joueur actuellement s\195\169lectionn\195\169."
L["TIP032"] = "Cliquez pour d\195\169placer le joueur en haut de la liste."
L["TIP033"] = "Cliquez pour faire gagner une place au joueur."
L["TIP034"] = "Cliquez pour faire perdre une place au joueur."
L["TIP035"] = "Cliquez pour d\195\169placer le joueur en bas de la liste. Si vous \195\170tes dans un raid, le joueur sera d\195\169plac\195\169 \195\160 la place la plus basse des joueurs actuellements dans le raid. Si le joueur est d\195\169j\195\160 \195\160 cette place, il sera d\195\169plac\195\169 \195\160 la toute fin de la liste. Si vous n'\195\170tes pas dans un raid, d\195\169place toujours le joueur \195\160 l'extr\195\170me fin de la liste."
L["TIP036"] = "Cliquez pour marquer le joueur comme 'r\195\169serv\195\169'. Un joueur r\195\169serv\195\169 sera trait\195\169 comme s'il faisait aprtie du raid, m\195\170me s'il est hors-ligne ou pas dans le raid. On utilise cette option pour les joueurs qui ne sont pas dans le raid pour pouvoir qu\195\170ter, mais qui sont en attente de rejoindre le raid."
L["TIP037"] = "D\195\169finit l'ordre de tri de la liste pour d\195\169finir l'ordre selon lequel les listes seront affich\195\169es. Les listes sont tri\195\169es du plus petit nombre au plus grand, et deux listes ayant le m\195\170me ordre de tri seront tri\195\169es par ordre alphab\195\169tique."
L["TIP038"] = "D\195\169finit la valeur du filtre du rang de guilde par d\195\169faut lorsque la liste est s\195\169lectionn\195\169e. D\195\169finir cette option \195\160 autre chose que 'Aucun' remplacera le param\195\168tre global par d\195\169faut. Toutefois, les configurations propres aux objets remplaceront ce param\195\168tre."
L["TIP039"] = "Activer pour forcer le fitre strict sur les classes d'armure. Aura pour effet de rejeter les ench\195\168res sur des objets qui ne sont pas de la plus haute classe d'armures. Par exemple, cela rejettera l'ench\195\168re d'un druide sur un objet en tissu car les druides peuvent porter du cuir."
L["TIP040"] = "Activer cette option pour forcer le filtre strict sur les r\195\180les. Ceci n\195\169cessite que les joueurs aient leurs r\195\180les d\195\169finis (tank, heal, DPS CaC, etc.) et que le ma\195\174tre du butin d\195\169finisse le filtre de r\195\180le pour l'objet avant d'ouvrir les ench\195\168res. Tout joueur n'ayant pas le r\195\180le sp\195\169cifi\195\169 ne pourra pas ench\195\169rir sur l'objet."
L["TIP041"] = "SI vous voulez qu'une ench\195\168re remport\195\169e fasse \195\169galement suicider le joueur sur une autre liste, s\195\169lectionnez-la ici. Ceci est utile si la polotique de la guilde demande de suicider un joueur sur une liste de stuff normal s'il a re\195\167u un objet d'un ensemble de set par exemple."
L["TIP042"] = "Cliquez pour sauvegarder les changements appliqu\195\169s \195\160 cette liste. Tous les changements apport\195\169s \195\160 la liste sur cet \195\169cran ne seront pas sauvegard\195\169s tant que vous ne cliquez pas sur ce bouton."
L["TIP043"] = "Cr\195\169er une nouvelle liste vide."
L["TIP044"] = "Supprime la liste actuellement s\195\169lectionn\195\169e."
L["TIP045"] = "Renomme la liste actuellement s\195\169lectionn\195\169e."
L["TIP046"] = "Copier la liste actuellement s\195\169lectionn\195\169e vers une nouvelle, conservant toutes les positions des joueurs sur la liste."
L["TIP047"] = "Importer les joueurs vers cette liste \195\160 partir de diff\195\169rentes sources, telles que l'import par rang de guilde ou d'autres add-ons si vous faites une mise \195\160 jour."
L["TIP048"] = "Exporter cette liste ou toutes les listes vers un format XML, CSV ou BBcode (forum), pour l'uploader sur un site web."
L["TIP049"] = "Ajoute les joueurs qui sont actuellement dans le raid mais pas dans la liste, ou les joueurs dans la base de donn\195\169es qui ne sont pas dans la liste. Les joueurs peuvent \195\170tre ajout\195\169s \195\160 la fin ou \195\160 une place al\195\169atoire dans la liste."
L["TIP050"] = "Ce texte export\195\169 est \195\160 copier (Ctrl+C) coller (Ctrl+V) sur le site web ou sur une quelconque application que vous utilisez pour traiter l'historique de loots."
L["TIP051"] = "S\195\169lectionne le sueil de rang de guilde (s'il existe). Tout membre de la guilde en-dessous de ce rang ne sera pas autoris\195\169 \195\160 ench\195\169rir ou \195\160 rand pour cet objet. Vous pouvez cliquer sur '-' \195\160 droite pour diminuer automatiquement le rang d'un niveau si vous n'avez pas d'ench\195\169risseurs \195\160 ce rang actuel."
L["TIP052.0"] = "Ouvrir ou terminer les ench\195\168res / rands"
L["TIP052"] = "Cliquez pour ouvrir les ench\195\168res sur l'objet actuellement s\195\169lectionn\195\169, ou les terminer si l'ench\195\168re est d\195\169j\195\160 ouverte. Selon les options choisies sur l'\195\169cran de distribution de loot, cl\195\180re une ench\195\168re qui n'a pas d'ench\195\169risseurs peut lancer les rands ou attribuer l'objet \195\160 un d\195\169senchanteur. Si les rands sont en cours, ceci terminera les rands avec le gagnant actuel (s'il existe) si vous souhaitez raccourcir le compte \195\160 rebours."
L["TIP053.0"] = "Ouvrir les ench\195\168res / Mettre en pause"
L["TIP053"] = "Cliquez pour d\195\169marrer les rands, ou mettre en pause le compte \195\160 rebours si un rand est d\195\169j\195\160 en cours. Si vous restez appuy\195\169 sur 'Shift' en cliquant pour d\195\169marrer les rands, ceci lancera \195\160 la place un 'rand suicide', qui fera se suicider le joueur gagnant sur la liste actuellement s\195\169lectionn\195\169e."
L["TIP054.0"] = "Supprimer /Annuler"
L["TIP054"] = "Cliquez pour supprimer un objet de la liste d'objets, ou pour annuler une ench\195\168re ou un rand en cours."
L["TIP055.0"] = "Ench\195\169rir / Se r\195\169tracter"
L["TIP055"] = "Cliquez pour enregistrer ou annuler votre propre ench\195\168re sur un objet."
L["TIP056"] = "Cliquez pour forcer un joueur \195\160 ench\195\169rir sur un objet. Le joueur doit avoir \195\169t\195\169 s\195\169lectionn\195\169 dans la liste \195\160 gauche."
L["TIP057"] = "Cliquez pour forcer un joueur \195\160 se r\195\169tracter sur cette ench\195\168re. Vous devez avoir s\195\169lectionn\195\169 l'un des ench\195\169risseurs de la liste."
L["TIP058"] = "Annule la derni\195\168re ench\195\168re. Plus d'un objet peut \195\170tre annul\195\169. Lorsque vous rechargez votre UI ou red\195\169marrez le jeu, il n'est plus possible d'annuler les actions ant\195\169rieures. Un message de configrmation sera affich\195\169, montrant l'objet et la liste affect\195\169s. Vous pouvez annuler plusieurs ench\195\168res mais dans l'ordre anti-chronologique ; vous ne pouvez d\195\169faire une action sp\195\169cifique."
L["TIP059"] = "Cliquez pour que l'objet soit ignor\195\169 par KSK. Si un objet est ignor\195\169, il ne sera pas affich\195\169 dans la liste des loots s'il est fouill\195\169 sur un corps ou dans un coffre, et vous devrez l'atribuer manuellement."
L["TIP060"] = "D\195\169finit la liste \195\160 choisir par d\195\169faut lorsque cet objet est s\195\169lectionn\195\169 dans la fen\195\170tre de loot. Si vous avez une liste par d\195\169faut s\195\169lectionn\195\169e, d\195\169finir cette valeur remplacera le param\195\168tre global."
L["TIP061"] = "D\195\169finit le filtre de rang pour cet objet. Ceci remplacera le rang par d\195\169faut s'il est d\195\169finit. Si vous changez de liste apr\195\168s avoir s\195\169lectionn\195\169 un objet, le rang initial peut changer si la liste que vous avez s\195\169lectionn\195\169e a un filtre de rang par d\195\169faut d\195\169fini."
L["TIP062"] = "Cliquez pour faire en sorte que l'objet sera donn\195\169 \195\160 un joueur sp\195\169cifique la prochaine fois qu'il tombe. Si vous activez ceci, vous devrez choisir le joueur et pourrez d\195\169cidez si cela devra se faire une fois ou \195\160 chaque fois que l'objet tombe. Vous pouvez \195\169galement d\195\169cider si le joueur devra \195\170tre suicid\195\169 sur une liste donn\195\169e lorsque l'objet lui sera automatiquement attribu\195\169."
L["TIP063"] = "Cliquez pour s\195\169lectionner le joueur qui recevra l'objet la prochaine fois qu'il tombe."
L["TIP064"] = "S\195\169lectionnez cette option si vous d\195\169sirez que l'enregistrement de cette auto-attribution soit automatiquement supprim\195\169 de la base de donn\195\169es d'objets lorsque l'objet tombe \195\160 nouveau et est attribu\195\169 au joueur. Conseil : s\195\169lectionnez cette option pour un assignement unique ; si cet objet a besoin d'\195\170tre farm\195\169, par exemple un fragment d'arme, d\195\169sactivez cette option pour attribuer l'objet \195\160 chaque fois qu'il tombe au joueur."
L["TIP065"] = "D\195\169finit la liste (si elle existe) sur laquelle le joueur sera suicid\195\169 s'il re\195\167oit cet objet par auto-attribution."
L["TIP066"] = "Cliquez pour supprimer l'objet de la base de donn\195\169es."
L["TIP067"] = "Supprime tout l'historique des loots. Notez que cela supprimera seulement votre historique local, ceci n'affectera pas l'historique des autres administrateurs."
L["TIP068"] = "Supprime tout l'historique des loots except\195\169 les loots re\195\167us ces 7 derniers jours. Notez que cela supprimera seulement votre historique local, ceci n'affectera pas l'historique des autres administrateurs."
L["TIP069"] = "Supprime tout l'historique des loots except\195\169 les loots re\195\167us ce mois-ci (30 jours). Notez que cela supprimera seulement votre historique local, ceci n'affectera pas l'historique des autres administrateurs."
L["TIP070"] = "Cliquez pour exporter l'historique des loots au format XML, pour uploader par exemple sur un site web."
L["TIP071"] = "S\195\169lectionne le r\195\180le que joue le joueur dans le raid  la guilde. Ceci est utilis\195\169 pour d\195\169finir des filtres pour restreindre les ench\195\169risseurs aux joueurs qui remplissent un certain r\195\180le, dans le cas o\195\185 un objet pourrait \195\170tre davatange utile \195\160 un type de joueurs. Par exemple, vous pourrez d\195\169cider que cet objet est pour heal, m\195\170me si les DPS magique peuvent le convoiter."
L["TIP072"] = "Entrez le nom exact du joueur."
L["TIP073"] = "S\195\169lectionnez la classe du joueur. Vous devez d\195\169finir une classe pr\195\169cise car ceci affectera le filtre des classes."
L["TIP074"] = "S\195\169lectionnez le niveau minumu pour accepter les joueurs. Les membres de guilde en-dessous de ce niveau ne seront pas import\195\169s."
L["TIP075"] = "S\195\169lectionnez ceci pour dire que le joueur est un enchanteur. Les joueurs marqu\195\169s en tant que enchanteurs sont susceptibles d'\195\170tre s\195\169lectionner comme enchanteurs pour le raid dans l'\195\169cran de la configuration de loot."
L["TIP076"] = "S\195\169lectionnez ceci si un joueur est un reroll d'un autre personnage. C'est une bonne id\195\169e de tenir ceci \195\160 jour, dans le cas o\195\185 vous d\195\169ciez que les rerolls soient attach\195\169s aux mains. Si les rerolls sont attach\195\169s aux mains, ils occuperont la m\195\170me place sur la liste sous le nom de leur main. Si le lien reroll/main est activ\195\169, les rerolls et les mains seront trait\195\169s ind\195\169pendamment."
L["TIP077"] = "Cliquez pour s\195\169lectionner le main du joueur. Seul les joueurs qui ne sont pas encore des rerolls d'autres personnages seront affich\195\169s."
L["TIP078"] = "S\195\169lectionnez ceci pour geler un joueur sur place, g\195\169n\195\169ralement lorsqu'il est absent du jeu pendant un moment. Un joueur gel\195\169 gardera sa place actuelle sur toutes les listes, et les autres joueurs bougeront autour de lui lorsque quelqu'un se suicide sur la liste."
L["TIP080"] = "Cliquez pour rendre ces changements permanents. Tant que vous ne cliquez pas sur ce bouton, aucun changement ne sera sauvegard\195\169."
L["TIP081"] = "Cliquez pour cr\195\169er un nouveau joueur."
L["TIP082"] = "Cliquez pour supprimer le joueur actuellement s\195\169lectionn\195\169. Ceci supprime \195\169galement le joueur de toutes les listes. Un message de confirmation sera affich\195\169, et si le personnage est le main d'autres personnages, vous aurez la possibilit\195\169 de supprimer tous les rerolls du joueur \195\169galement."
L["TIP083"] = "Cliquez pour renommer le joueur s\195\169lectionn\195\169, g\195\169n\195\169ralement pour corriger une faute de frappe dans le nom du joueur ou s'il a changer son nom avec le service payant de Blizzard."
L["TIP084"] = "Cliquez pour importer les joueurs du roster de guilde."
L["TIP086"] = "Cliquez pour ajouter les joueurs qui sont actuellement dans le raid mais pas dans la liste des joueurs."
L["TIP087"] = "Cliquez pour faire une demande de synchronisation avec le joueur s\195\169lectionn\195\169. Le joueur doit \195\170tre connect\195\169."
L["TIP088"] = "Cliquez pour faire une demande de synchronisation avec les administrateurs connect\195\169s. S'il s'agit d'une configuration de guilde, la demande sera diffus\195\169e \195\160 la guilde. S'il s'agit d'une configuraiton pick-up, la requ\195\170te sera diffus\195\169e au raid. Les membres de la guilde ou du raid qui sont administrateurs enverront les donn\195\169es de synchronisation."
L["TIP089"] = "Cliquez pour diffuser la configuration actuelle \195\160 la guilde ou au raid, selon le type de configuration. Cela mettra \195\160 jour tous les membres de la guilde ou les donn\195\169es des raideurs s'ils utilisent KSK. Si un joueur qui a \195\169t\195\169 r\195\169cemment nomm\195\169 co-admin, il pourra lancer une synchronisation avec vous apr\195\168s que vous ayez diffus\195\169 la configuration. Ceci occupe \195\169norm\195\169ment la bande passante du canal pour add-ons, il est donc pr\195\169f\195\169rable de faire ceci uniquement lorsque le raid est compl\195\169tement form\195\169."
L["TIP090"] = "Le possesseur d'une configuration peut cliquez ici pour restaurer sa configuration \195\160 partir d'un autre administrateur dans le cas o\195\185 il aurait perdu totalement ses donn\195\169es apr\195\168s un crash."
L["TIP091"] = "Supprime le rand de la liste. Les joueurs peuvent supprimer leurs propres rands en faisant '/rand 1-1', mais ceci permet au ma\195\174tre du butin de supprimer un joueur de la liste manuellement."
L["TIP092"] = "Activer cette option pour que le gestionnaire de rands diff\195\169rencie les +1 (1-100) des +2 (101-200). Si cette option est d\195\169sactiv\195\169e et qu'un joueur essaie de faire un '/rand 101-200', il sera ignor\195\169."
L["TIP093"] = "Si cette option est activ\195\169e, le bouton 'Rand ouvert' dans la fen\195\170tre de distribution de loot sera un rand suicide (un rand qui suicide le gagnant sur la liste actuelle) par d\195\169faut. Il faudra rester appuy\195\169 sur 'Shift' pour faire un rand qui ne suicide pas. Si l'option est d\195\169sactiv\195\169e, ce sera l'inverse (rand normal par d\195\169faut, shift+click pour un rand suicide)."
L["TIP094"] = "Affiche le classement des membres pour la liste actuelle au raid. Contrairement au bouton 'Annoncer' qui n'affiche que les membres du groupe de raid, ceci affichera la liste enti\195\168re avec le classement absolu. Si vous maintenez 'Shift' enfonc\195\169, le classement sera envoy\195\169 sur le canal de guilde au lieu du canal de raid."
L["TIP095"] = "D\195\169finit le niveau minimum d'objet pour lancer les ench\195\168res ou les rands. Si vous d\195\169finissez ce param\195\168tre \195\160 une valeur sup\195\169rieure au seuil du ma\195\174tre du butin, vous pourrez faire d\195\169senchanter automatiquement les objets compris entre les deux paliers ; pour activer cette option, cochez la case suivante."
L["TIP096"] = "Si vous avez d\195\169fini le seuil d'ench\195\168re et qu'il est plus \195\169lev\195\169 que le seuil de ma\195\174tre du butin, activer cette option pour que tous les objets en-dessous du seul d'ench\195\168re soit automatiquement envoy\195\169 \195\160 un d\195\169senchanteur du raid. Si aucun enchanteur n'est connect\195\169, les objets concern\195\169s seront attribu\195\169s au ma\195\174tre du butin."
L["TIP097"] = "Activer cette option pour que l'objet soit automatiquement attribu\195\169 \195\160 un enchanteur du raid et qu'il saute l'\195\169tape des ench\195\168res ou des rands. Si aucun enchanteur n'est connect\195\169, il sera donn\195\169 au ma\195\174tre du butin."
L["TIP098"] = "Activer cette option pour que l'objet soit automatiquement attribu\195\169 au ma\195\174tre du butin, et qu'il saute l'\195\169tape des ench\195\168res ou des rands."
L["TIP099"] = "Commencez \195\160 saisir le nom du joueur que vous recherchez. Cela peut-\195\170tre n'importe quelle partie du nom du joueur. Le premier joueur trouv\195\169 est surlign\195\169 est s\195\169lectionn\195\169."
L["TIP100"] = "Mark which guild ranks are officer ranks. Only officers will be permitted to broadcast configs to the entire guild."

--
-- Shared Konfer dialog. These strings are used by all Konfer addons.
--
L["KONFER_SEL_TITLE"] = "S\195\169lectionner le module Konfer %s actif"
L["KONFER_SEL_HEADER"] = "Vous avez plusieurs add-ons Konfer %s install\195\169s, et plus d'un est actif et configur\195\169 pour s'ouvrir automatiquement lors du loot d'un corps ou d'un coffre. Ceci peut provoquer des conflits, vous devez donc choisir lequel activer, tous les autres seront d\195\169sactiv\195\169s."
L["KONFER_SEL_DDTITLE"] = "Choisir le module \195\160 activer"
L["KONFER_ACTIVE"] = "activ\195\169"
L["KONFER_SUSPENDED"] = "d\195\169sactiv\195\169"
L["KONFER_SUSPEND_OTHERS"] = "Vous venez d'activer le module Konfer %s ci-dessus, mais d'autres modules Konfer sont \195\169galement activ\195\169s. Avoir plusieurs modules Konfer actifs en m\195\170me temps peut g\195\169n\195\169rer des probl\195\168mes, notamment si plus d'un est configur\195\169 pour s'ouvrir automatiquement lors d'un loot. Nous vous conseillons de d\195\169sactiver tous les autres add-ons Konfer. Pour suivre ce conseil et faire de ce module le seul actif, cliquez sur 'Ok'. Si vous \195\170tes certain de vouloir laisser plusieurs add-ons Konfer actifs, cliquez sur 'Annuler'."
