--[[
   KahLua KonferSK - a suicide kings loot distribution addon.
     WWW: http://kahluamod.com/ksk
     Git: https://github.com/kahluamods/konfersk
     IRC: #KahLua on irc.freenode.net
     E-mail: cruciformer@gmail.com
   Please refer to the file LICENSE.txt for the Apache License, Version 2.0.

   Copyright 2008-2018 James Kean Johnston. All rights reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
]]

local K = LibStub:GetLibrary("KKore")

if (not K) then
  error ("KahLua KonferSK: could not find KahLua Kore.", 2)
end

local L = K:RegisterI18NTable("KKonferSK", "enUS")
if (not L) then
  error ("KahLua KonferSK: could not initialize I18N.", 2)
end

--
-- NOTE TO PEOPLE LOCALISING THIS FILE:
-- PLEASE BE SURE TO VIEW THE LOCALISATION INSTRUCTIONS FOUND AT
-- http://kahluamod.com/l10n BEFORE STARTING ANY TRANSLATIONS OF
-- THIS FILE. THANK YOU.
--

L["MODTITLE"] = "KonferSK"
L["MODNAME"] = "konfersk"
L["MODABBREV"] = "KSK"
L["CMDNAME"] = "ksk"
L["CMD_CONFIG"] = "config"
L["CMD_USERS"] = "users"
L["CMD_HELP"] = "help"
L["CMD_LOOT"] = "loot"
L["CMD_LISTS"] = "lists"
L["CMD_SYNC"] = "sync"
L["CMD_VERSION"] = "version"
L["CMD_RESETPOS"] = "resetpos"
L["CMD_REPAIR"] = "repair"
L["CMD_SUSPEND"] = "suspend"
L["CMD_RESUME"] = "resume"
L["CMD_VERSIONCHECK"] = "versioncheck"
L["CMD_SELECTCONFIG"] = "selectconfig"
L["CMD_CREATECONFIG"] = "createconfig"
L["CMD_DELETECONFIG"] = "deleteconfig"
L["CMD_RENAMECONFIG"] = "renameconfig"
L["CMD_COPYCONFIG"] = "copyconfig"
L["CMD_CREATEUSER"] = "createuser"
L["CMD_DELETEUSER"] = "deleteuser"
L["CMD_RENAMEUSER"] = "renameuser"
L["CMD_SELECTLIST"] = "selectlist"
L["CMD_CREATELIST"] = "createlist"
L["CMD_DELETELIST"] = "deletelist"
L["CMD_RENAMELIST"] = "renamelist"
L["CMD_COPYLIST"] = "copylist"
L["CMD_ADDITEM"] = "additem"
L["CMD_ADDLOOT"] = "addloot"
L["CMD_IMPORTGUILDUSERS"] = "importguildusers"
L["CMD_SHOW"] = "show"
L["SUBCMD_HELP"] = "help"
L["SUBCMD_LOOT"] = "loot"
L["SUBCMD_ROLLS"] = "rolls"
L["SUBCMD_ADMIN"] = "admin"
L["SUBCMD_ASSIGN"] = "assign"
L["SUBCMD_ITEMS"] = "items"
L["SUBCMD_HISTORY"] = "history"

L["ABOUT1"] = "Please report any problems, comments or suggestions"
L["ABOUT2"] = "to <%s>. Thank you!"
L["ABOUT3"] = "Visit %s for more details."

L["WHISPERCMD_BID"] = "bid"
L["WHISPERCMD_RETRACT"] = "retract"
L["WHISPERCMD_SUICIDE"] = "suicide"
L["WHISPERCMD_STANDBY"] = "standby"
L["WHISPERCMD_HELP"] = "ksk"

--
-- Main localisation strings start here
--

L["VCTITLE"] = "%s %s Version Check"
L["Version"] = true
L["In Raid"] = true
L["NEWMSG"] = "Enter the name of a new configuration space below. Please remember that this new space shares absolutely no data with any other configuration space. This new configuration will be treated as if it was an entirely separate copy of Konfer running."
L["DELMSG"] = "Are you absolutely sure you want to delete this configuration? It is not possible to undo this operation, and all roll lists, user permissions, raid history and user loot information associated with this configuration will be lost. If you are the owner of this configuration and you have shared it with other users, you should wait until you have transfered ownership to another user, else they will be unable to edit any security related settings on the list. Please be very sure the correct list is displayed above before proceeding."
L["DELUSER"] = "Are you absolutely sure you want to delete this user? It is not possible to undo this operation, and all user history and information will be lost, and the user will be removed from all roll lists in all configurations, not just the active one. If this user is a main and has alts defined, they can all be removed as well. Please be very sure the correct user is displayed above before proceeding."
L["NEWLIST"] = "Enter the name of a new roll list below. Once the list has been created you can add users to the list or import users from the guild roster. You can also configure various list options by selecting the Config tab at the top of the list manager window."
L["DELLIST"] = "Are you absolutely sure you want to delete this roll list? It is not possible to undo this operation, and all list history and positions will be lost. Please be very sure that the correct list is displayed above before proceeding."
L["AUTOASSIGN"] = "This item is set to be auto-looted to %q. Press 'Ok' to assign the item to %s or 'Cancel' to ignore the auto-assignment setting."
L["AUTOSUICIDE"] = "If you do decide to award this item to %s, they will automatically be suicided on the %s list."
L["AUTOLOOT"] = "This item was won by %s. Press 'Ok' to automatically assign the item to %s. If you press 'Cancel' the item will still be removed from the loot list, and you will need to assign it to %s using the standard user interface."
L["AUTODENCH"] = "The item above had no bidders. Disenchanter %q is online and in the raid. Press 'Ok' to assign this item to %s. Press 'Cancel' if you want to assign the item manually or make it available for open roll (the item will be left in the loot list if you press 'Cancel')."
L["AUTODENCHNR"] = "No-one rolled on the above item. Disenchanter %q is online and in the raid. Press 'Ok' to assign this item to %s. Press 'Cancel' if you want to assign the item manually (the item will be removed from the loot list but not from the corpse or chest)."
L["PUGCONFIG"] = "Player %q has broadcast the PUG configuration above. If this is a regular PUG that uses %s to administer loot, and you wish to keep track of all loot events, lists and members, press 'Ok' to accept and create this configuration (you will receieve no further confirmations for this configuration). If you decide not to accept this broadcast, press 'Cancel' below (you will however see this message each time the raid leader broadcasts it)."
L["LISTPOSMSG"] = "%s: below are your list positions in the %q configuration. Instead of using this command why not download %s and keep track of the lists using the mod itself?"
L["RECOVERMSG"] = "You are the owner of the above config and you have requested list recovery from user %q. Please note that in order for recovery to work, %s must be fully synced with all other admins. If you proceed with recovery, you will erase your entire configuration (but not your local settings) including lists, users, items and loot history. Using recovery should be a last-ditch effort to recover a corrupted configuration. If you have not backed up your existing savedvariables file you should exit the game completely and do so now. Please be absolutely sure this is what you want to do. It is a fairly drastic step."

L["HELPMSG1"] = "%s: To use %s, whisper one of the following commands to an admin. To bid on a loot item or to retract your bid you must whisper the master looter. All other commands can be sent to any %s admin."
L["HELPMSG2"] = "%s: %s - bid on current loot item"
L["HELPMSG3"] = "%s: %s - retract (cancel) your current bid"
L["HELPMSG4"] = "%s: %s - display your position on roll lists"
L["HELPMSG5"] = "%s: %s - indicate you are available to raid"

L["USER_RESERVED"] = "R"
L["USER_ENCHANTER"] = "E"
L["USER_FROZEN"] = "F"

L["error: "] = true
L["Suicide Kings loot distribution system."] = true
L["%s<%s>%s %s (version %d) - %s"] = true
L["/%s [command [arg [arg...]]]"] = true
L["Usage: "] = true
L["  Open the list management window."] = true
L["  Opens the user list management window."] = true
L["  Opens the loot management window."] = true
L["  Opens the sync manager window."] = true
L["  Suspend %s (no auto-open on loot, no missing member warnings etc)."] = true
L["  Resume normal %s operations."] = true
L["  Set up various options and manage configurations."] = true
L["  %s - configure lists and list options"] = true
L["  %s - set up loot related options"] = true
L["  %s - set up roll related options"] = true
L["  %s - set up config spaces and permissions options"] = true
L["  %s - open the loot assignment window"] = true
L["  %s - open the item editor window"] = true
L["  %s - open the item history window"] = true
L["/%s %s name"] = true
L["/%s %s [itemid | itemlink]"] = true
L["  Adds a new item to the item list."] = true
L["  Adds a new item to the loot list."] = true
L["/%s %s oldname newname"] = true
L["  Selects the specified configuration as the current one."] = true
L["  Create the specified configuration."] = true
L["  Delete the specified configuration."] = true
L["  Renames the specified configuration."] = true
L["  Copies the specified configuration to a new one, with options."] = true
L["/%s %s name class"] = true
L["  Adds a new user to the users list."] = true
L["  Removes a user from the users list."] = true
L["  Renames a user after a paid name change."] = true
L["%q is not a valid command. Type %s for help."] = true
L["Create Configuration"] = true
L["Delete Configuration"] = true
L["Rename Configuration"] = true
L["Old Name"] = true
L["New Name"] = true
L["Copy Configuration"] = true
L["Source Configuration"] = true
L["Destination Configuration"] = true
L["Roll Lists to Copy"] = true
L["Copy Co-admins"] = true
L["Copy Configuration Options"] = true
L["Copy Raid History"] = true
L["Copy Item Options"] = true
L["Copy All User Flags"] = true
L["usage: %s/%s %s name%s"] = true
L["usage: %s/%s %s oldname newname%s"] = true
L["usage: %s/%s %s name class%s"] = true
L["Auto-open Bid Panel When Corpse Looted"] = true
L["Silent Bidding"] = true
L["Display Tooltips in Loot List"] = true
L["Enable Chat Message Filter"] = true
L["Record Loot Assignment History"] = true
L["Open Roll Timeout"] = true
L["Roll Timeout Extension"] = true
L["Use Default Roll List"] = true
L["Auto-assign Loot When Bids Close"] = true
L["When there are no successful bids ..."] = true
L["Try Open Roll"] = true
L["Assign BoE Items to Master Looter"] = true
L["Assign To Enchanter"] = true
L["invalid configuration name. Please try again."] = true
L["invalid list name. Please try again."] = true
L["configuration %q created."] = true
L["configuration %q already exists. Try again."] = true
L["configuration %q does not exist. Try again."] = true
L["Lists"] = true
L["List Manager"] = true
L["Members"] = true
L["Config"] = true
L["Users"] = true
L["User List Manager"] = true
L["Loot"] = true
L["Loot Manager"] = true
L["Assign Loot"] = true
L["Item Editor"] = true
L["Sync"] = true
L["Rolls"] = true
L["Sync Manager"] = true
L["Config Manager"] = true
L["Admin"] = true
L["Create"] = true
L["Add"] = true
L["Delete"] = true
L["Rename"] = true
L["Copy"] = true
L["Update"] = true
L["Set As Default"] = true
L["Reset"] = true
L["Select"] = true
L["Config Owner"] = true
L["Alts Tethered to Mains"] = true
L["cannot delete configuration %q - KonferSK requires at least one configuration."] = true
L["configuration %q deleted."] = true
L["user %q deleted."] = true
L["roll list %q deleted."] = true
L["NOTICE: default configuration changed to %q."] = true
L["NOTICE: configuration %q renamed to %q."] = true
L["NOTICE: user %q renamed to %q."] = true
L["NOTICE: roll list %q renamed to %q."] = true
L["Co-admins"] = true
L["User Role"] = true
L["Not Set"] = true
L["Tank"] = true
L["Ranged DPS"] = true
L["Melee DPS"] = true
L["Healer"] = true
L["Spellcaster"] = true
L["User is an Enchanter"] = true
L["User is an Alt of"] = true
L["User is Frozen"] = true
L["Guild Import"] = true
L["user %q already exists. Try again."] = true
L["user %q does not exist. Try again."] = true
L["user %q created."] = true
L["cannot complete command until a configuration space exists."] = true
L["invalid class %q specified. Valid classes are:"] = true
L["cannot delete user %q as they are the owner of the configuration."] = true
L["Delete All Alts of User"] = true
L["Create User"] = true
L["Delete User"] = true
L["Rename User"] = true
L["User Name"] = true
L["User Class"] = true
L["you must set a user class."] = true
L["you must specify a character name."] = true
L["Import Guild Users"] = true
L["Guild Rank"] = true
L["added %d user(s)."] = true
L["Assign Mains to Alts"] = true
L["Select Enchanter"] = true
L["Select Co-admin"] = true
L["Currently Selected: "] = true
L["Create Roll List"] = true
L["Delete Roll List"] = true
L["Rename Roll List"] = true
L["Copy Roll List"] = true
L["Source List"] = true
L["Destination List"] = true
L["Broadcast"] = true
L["Announce"] = true
L["Announce All"] = true
L["invalid roll list name. Please try again."] = true
L["roll list %q already exists. Try again."] = true
L["roll list %q does not exist. Try again."] = true
L["roll list %q created."] = true
L["you do not have permission to do that in this configuration."] = true
L["you are not an administrator of this configuration. Your access to it is read-only."] = true
L["you are the master looter but not an administrator of this configuration. You will be unable to loot effectively. Either change master looter or have the owner of the configuration assign you as an administrator."] = true
L["no active configuration. Either create one with %s or wait for a guild admin to broadcast the guild list."] = true
L["Insert"] = true
L["Delete"] = true
L["King"] = true
L["Move Up"] = true
L["Move Down"] = true
L["Suicide"] = true
L["Reserve"] = true
L["Unreserve"] = true
L["Add Missing"] = true
L["NOTICE: user %q is in the raid but not in the user list."] = true
L["Insert Roll List Member"] = true
L["Insert Randomly"] = true
L["Sort Order"] = true
L["Strict Class Armor Filtering"] = true
L["Strict Role Filtering"] = true
L["Suicide on Additional List"] = true
L["Show Tethered Alts"] = true
L["None"] = true
L["Open Roll"] = true
L["Import"] = true
L["Export"] = true
L["Import List Members"] = true
L["Export List Members"] = true
L["Guild Rank to Import"] = true
L["CSV Import"] = true
L["SKG Import"] = true
L["Class Filter"] = true
L["Other Filters"] = true
L["Strict Class Armor"] = true
L["Strict Role Filter"] = true
L["Bid"] = true
L["Retract"] = true
L["Force Bid"] = true
L["Force Retract"] = true
L["Open Bids"] = true
L["Close Bids"] = true
L["Pause"] = true
L["End Roll"] = true
L["Resume"] = true
L["Remove"] = true
L["Ignore Item"] = true
L["Roll on Specific List"] = true
L["Class Restriction"] = true
L["Role Restriction"] = true
L["Assign Next Drop to User"] = true
L["Auto-Remove When Assigned"] = true
L["Suicide User on List"] = true
L["your version of %s is out of date. Please update it."] = true
L["Announce Loot"] = true
L["Announce Winners in Guild Chat"] = true
L["Nowhere"] = true
L["In Guild Chat"] = true
L["In Raid Chat"] = true
L["Loot from %s: "] = true
L["Chest"] = true
L["Config Type"] = true
L["Guild"] = true
L["PUG"] = true
L["item %s already exists."] = true
L["item %d is an invalid item."] = true
L["Initial Guild Rank Filter"] = true
L["Request Sync"] = true
L["Request Sync (All)"] = true
L["Broadcast"] = true
L["Recover"] = true
L["sync request received from %q but I do not recognise them as an admin. Please sync with the config owner (%q)."] = true
L["Bids now open for %s on the %q list."] = true
L["Bid list changed to %q for %s."] = true
L["%s: to bid on %s, whisper %s the word %q. For general help using %s, whisper an admin the word %q."] = true
L["%s: bids closing in: %d"] = true
L["%s: %s%s (group %d) won %s. Grats!"] = true
L["%s: %s%s won %s. Grats!"] = true
L["%s: %s was auto-assigned %s."] = true
L["%s: to retract your bid whisper %s the word %q."] = true
L["%s: bid retracted"] = true
L["%s: no item currently being bid on."] = true
L["%s: you are not a member of the current list (%q) - bid ignored."] = true
L["%s: you do not meet the current guild rank requirement (%q) - %s ignored."] = true
L["%s: you do not meet the current role requirement (%q). Your current role is %q - %s ignored."] = true
L["%s: you do not meet the current class restrictions (%s) - %s ignored."] = true
L["Auto-assign Loot"] = true
L["bid"] = true
L["roll"] = true
L["retracted"] = true
L["%s: there is no item currently open for bids."] = true
L["%s: you are not eligible to receive loot - %s ignored."] = true
L["%s: I am not the master looter - %q is."] = true
L["%s: I am not the master looter."] = true
L["%s: loot method is not master looter, there is no bidding."] = true
L["%s: you were not found in the user list. Contact an admin for help."] = true
L["%s: you are not in my guild - bid ignored."] = true
L["user %q has no role defined - permitting %s."] = true
L["%s: you are not a member of the %q list - bid ignored."] = true
L["%q attempted to bid on the %q list but is not a member."] = true
L["%s: you have already bid on that item. Whisper %s the word %q to retract your bid."] = true
L["%s: new bid received. Number of bidders: %d."] = true
L["%s: bid retracted. Number of bidders: %d."] = true
L["%s: %s (position %d) has bid (highest bidder is %s)."] = true
L["%s: %s has retracted (highest bidder is %s)."] = true
L["%s: %s has retracted (no other bidders)."] = true
L["%s: no successful bids for %s."] = true
L["Note: only top 5 rolls shown."] = true
L["Roll for %s within %d seconds."] = true
L["Suicide Roll (on list %q) for %s within %d seconds."] = true
L["%s: type '/roll' for main spec, '/roll 101-200' for off-spec or '/roll 1-1' to cancel a roll."] = true
L["%s: type '/roll' for main spec or '/roll 1-1' to cancel a roll."] = true
L["%s: roll closing in: %d"] = true
L["Roll closing in %s"] = true
L["%s: invalid roll. Use '/roll' for main spec, '/roll 101-200' for off-spec or '/roll 1-1' to cancel a roll."] = true
L["%s: invalid roll. Use '/roll' for main spec or '/roll 1-1' to cancel a roll."] = true
L["%s: you already rolled %d. New roll ignored."] = true
L["top main spec rollers: %s"] = true
L["top off-spec rollers: %s"] = true
L["%s: the following users tied with %d: %s. Roll again."] = true
L["%s: sorry you are not allowed to roll right now."] = true
L["no-one rolled for %s."] = true
L["%s %s on %s on the %s list."] = true
L["%s: relative positions of all currrent raiders for the %q list (ordered highest to lowest): "] = true
L["%s: members of the %q list (ordered highest to lowest): "] = true
L["Accept Configuration"] = true
L["configuration %q updated by %q"] = true
L["Checksum: 0x%s"] = true
L["Up to date"] = true
L["My checksum: %s"] = true
L["Not active!"] = true
L["maximum number of co-admins (36) reached"] = true
L["%s: %s - #%d (#%d in raid)"] = true
L["%s: (End of list)"] = true
L["%s: you are not on any roll lists (yet)."] = true
L["sync with user %s complete."] = true
L["sending sync data to user %s."] = true
L["%s: %s cancelled!"] = true
L["Set List to Imported Values"] = true
L["Add to Existing Members"] = true
L["Randomly Add to Existing Members"] = true
L["The following users are missing from the user list: %s"] = true
L["Import from the CSV string cannot continue until these users are added."] = true
L["Nothing"] = true
L["Export current list as CSV"] = true
L["Export current list as XML"] = true
L["Export current list as BBcode"] = true
L["Export all lists as XML"] = true
L["Export all lists as BBcode"] = true
L["Export string"] = true
L["Press Ctrl+C to copy the export string"] = true
L["Current list: %s"] = true
L["%s using version %s"] = true
L["(in raid)"] = true
L["busy syncing with %q. Please try again when complete."] = true
L["History"] = true
L["Clear All"] = true
L["Clear all except last week"] = true
L["Clear all except last month"] = true
L["When"] = true
L["What"] = true
L["Who"] = true
L["How"] = true
L["Disenchanted"] = true
L["Bid: %s"] = true
L["Won Roll"] = true
L["BoE assigned to ML"] = true
L["Auto-assigned"] = true
L["can only add items when in a raid and you are the master looter."] = true
L["Note: player will need to pick item up manually."] = true
L["User %s / %s lists"] = true
L["on"] = true
L["not on"] = true
L["Other Announcements"] = true
L["Announce Bid List Changes"] = true
L["Announce Winners in Raid"] = true
L["Announce Bid Progression"] = true
L["Usage Message When Bids Open"] = true
L["Usage Message When Rolls Open"] = true
L["Announce Open Roll Countdown"] = true
L["Announce Open Roll Ties"] = true
L["Announce Bid / Roll Cancelation"] = true
L["Announce When No Successful Bids"] = true
L["Hide Absent Members in Loot Lists"] = true
L["Enable Off-spec (101-200) Rolls"] = true
L["Enable Suicide Rolls by Default"] = true
L["Recover Configuration"] = true
L["waiting for recovery reply from %s. Do not use KSK until recovery is complete."] = true
L["recovery from user %s complete."] = true
L["Use Guild Rank Priorities"] = true
L["Edit"] = true
L["Edit Rank Priorities"] = true
L["Priority"] = true
L["Add Missing Members"] = true
L["Add Missing Raid Members"] = true
L["Add All Missing Members"] = true
L["added %s to list %q at position %s."] = true
L["Export Loot History"] = true
L["Undo"] = true
L["Are you absolutely sure you want to undo this suicide?"] = true
L["User"] = true
L["List"] = true
L["Item"] = true
L["Minimum Level"] = true
L["Roll (main)"] = true
L["Roll (offspec)"] = true
L["Cancel Roll"] = true
L["Bid / Roll Threshold"] = true
L["Auto-disenchant Items Below Threshold"] = true
L["Auto-assign to Enchanter"] = true
L["Auto-assign to Master Looter"] = true
L["Raiders Not on Current List"] = true
L["users not on the %q list: %s"] = true
L["User Search"] = true
L["Edit Officer Ranks"] = true
L["Set Guild Officer Ranks"] = true

--
-- Tooltip text.
--
L["TIP001"] = "Enable this option to have the KSK loot distribution window open automatically when you loot a corpse that has items that match the master loot threshold."
L["TIP002"] = "When enabled, KSK will announce to the raid who has bid and who the current highest bidder is. Disabling this option will silence those messages."
L["TIP003"] = "Enable the display of the item tooltip when the mouse hovers over an item in the loot distribution list."
L["TIP004"] = "Enable this option to hide incoming bid whispers and most outgoing whispers and warnings. This reduces the chances you miss real whispers from users during the loot process."
L["TIP005"] = "Enable this to record who received what loot, when, and why. If this is disabled, the loot item history window will only display looted items from other admins that do not have this option disabled."
L["TIP006"] = "Select where KSK announces the loot found on a corpse or in a chest, if at all."
L["TIP006.1"] = "Do not announce the loot found on a corpse or in a chest."
L["TIP006.2"] = "Announce the loot found on a corpse or in a chest in guild chat."
L["TIP006.3"] = "Announce the loot found on a corpse or in a chest in raid chat."
L["TIP007"] = "Control exactly which messages KSK broadcasts to users in the raid or guild during the loot process."
L["TIP007.1"] = "Send a message to the raid if the master looter changes the list that is currently being bid on."
L["TIP007.2"] = "Send a message to the raid when a winning bid has been received and the bids close."
L["TIP007.3"] = "Send a message to the guild when a winning bid has been received and the bids close. This only applies to guild configurations. PUG configurations never announce in guild chat."
L["TIP007.4"] = "Send a message each time a new bid is received or a bid is retracted, along with the current highest bidder. This is not sent if silent bidding is enabled."
L["TIP007.5"] = "When bids open, send out the message that instructs users how to bid, retract or check their current list positions."
L["TIP007.6"] = "When you start an open roll for an item, send out the message instructing users how to roll for main spec and off-spec."
L["TIP007.7"] = "When you are open rolling on an item, display a countdown when the roll is about to close, and when the roll timeout is extended due to new rolls being received late."
L["TIP007.8"] = "When you are open rolling on an item and the winning roll was tied between two or more users, announce the tie and re-roll that is valid just for those users."
L["TIP007.9"] = "Send out a message when the master looter cancels a bid or open roll."
L["TIP007.10"] = "When there are no successful bids on an item, announce to the raid that the item is going to be disenchanted."
L["TIP007.11"] = "When you switch lists or looting begins, display a list of all of the current raiders who are not on the selected list."
L["TIP008"] = "Set how long to wait for incoming rolls before deciding on a winner. You can pause and finish a roll once it has been started."
L["TIP009"] = "Sets the number of seconds to extend the roll timer by when a roll is received within the last 5 seconds of the countdown."
L["TIP010"] = "Select the list to use by default (if any) if no list is automatically selected for the item in the item editor."
L["TIP011"] = "If you are not using guild rank priorities, set the default rank to begin the bidding at."
L["TIP012"] = "When enabled, hide any users who are not currently in the raid from the members list in the loot window. This has no effect on the members list in the list manager, which always displays the full member list for a given roll list. Enabling this just makes it easier to see who is in raid and their positions relative to each other."
L["TIP013"] = "Select this to use guild rank priorities, which will ensure that guild members with a higher rank priority always win over users with a lower priority, even if the user has a higher list position."
L["TIP014"] = "Press this button to open the guild rank priority editor, which allows you to set the priority for each guild rank."
L["TIP015"] = "When selected, and an item that is bind-on-equip has no bidders, assign the item to the master looter."
L["TIP016"] = "When selected and an item has no bidders, try to get rid of it by starting an open roll."
L["TIP017"] = "When selected and an item has no bidders, and no users rolled on it, if any of the configured enchanters are online, assign the item to them for disenchanting."
L["TIP018"] = "Press to select an enchanter from the list of available and unassigned enchanters. You mark a user as an enchanter in the user editor."
L["TIP019"] = "Press to create a new configuration space."
L["TIP020"] = "Press to delete the currently highlighted configuration space."
L["TIP021"] = "Press to rename the currently highlighted configuration space."
L["TIP022"] = "Press to copy the currently highlighted configuration space to a new configuration, with options."
L["TIP023"] = "Enter the name of the user (who must already exist in the user list) that is to be the new configuration owner."
L["TIP024"] = "If selected and a user is marked as an alt of another user, have the main and all alts occupy a single position on all roll lists. If not selected, the main and all alts are completely independent."
L["TIP025"] = "Select the configuration type. A guild configuration will synchronize through the guild addon channel, whereas a PUG configuration synchronizes and broadcasts just to the current raid."
L["TIP026"] = "Press to add a new co-admin to the list."
L["TIP027"] = "Press to delete the currently selected co-admin."
L["TIP028.0"] = "Configuration Selection"
L["TIP028.1"] = "Select the configuration to make active. Configurations for which you are an owner or administrator are |cff00ff00green|r, all others are |cffffffffwhite|r."
L["TIP029"] = "Press to send a message to the raid that lists all current raid members and their position on the list. If you have message filtering enabled, you will not see the text that is sent to the raid, but it will be sent. If you Shift-click the button it will announce to guild chat instead of the default raid chat."
L["TIP030"] = "Press to insert a user into the list, either at the bottom or in a random position. The user must first have been defined in the user editor. Only users not already on the list are shown in the popup."
L["TIP031"] = "Press to delete the currently selected user."
L["TIP032"] = "Press to move the user to the top of the list."
L["TIP033"] = "Press to move the user up one position on the list."
L["TIP034"] = "Press to move the user down one position on the list."
L["TIP035"] = "Press to move the user to the bottom of the list. If you are in a raid, will move the user to the lowest position currently occupied by all raiders. If the user is already at that slot, move them to the extreme bottom of the list. If you are not in a raid, always move the user to the extreme bottom of the list."
L["TIP036"] = "Press to mark a user as 'reserved'. A reserved user is treated as if they were in the raid, even if they are offline or not currently in the raid group. Usually set for users that are not in the raid group so they can quest, but are on standby to join the raid."
L["TIP037"] = "Set the sort order for the list to control the order in which lists are displayed. Lists are sorted from the lowest number to highest, and two lists with the same sort order will be sorted alphabetically."
L["TIP038"] = "Set the default guild rank filter value when this list is selected. Setting this to anything other than 'None' will override the global default guild rank setting. However, item-specific settings will override this setting."
L["TIP039"] = "Set this to force strict class armor filtering. This will reject bids on items that are not your highest armor class. For example, it would reject a druid bidding on a cloth item because druids can wear leather."
L["TIP040"] = "Set this to force strict role filtering. This will require the user to have their role (tank, healer, melee DPS etc) defined and for the loot master to set the role filter for the item before opening bids. Any user who is not of the specified role will not be able to bid on the item."
L["TIP041"] = "If you want a winning bid to also suicide the user on an additional list, select that list here. This is useful if it is your guild policy to suicide a user on a normal gear list if they receive an item on a tier gear list."
L["TIP042"] = "Press to save the changes to this list. Until the list is updated any changes made on this screen will have no effect."
L["TIP043"] = "Create a new empty roll list."
L["TIP044"] = "Delete the currently selected list."
L["TIP045"] = "Rename the currently selected list."
L["TIP046"] = "Copy the currently selected list to a new list, preserving all current user positions."
L["TIP047"] = "Import users into this list from various sources, such as by guild rank or from other mods if you are upgrading."
L["TIP048"] = "Export either this or all lists in either XML, CSV or BBcode format, possibly for uploading to a website."
L["TIP049"] = "Add either users who are currently in the raid but not on this list, or all users in the user database who are not on the list. Users can be added either at the end of the list or at random positions within the list."
L["TIP050"] = "This export string should be copied (using Ctrl-C) and then pasted *using Ctrl-V) into your website or whatever application you are using for processing the item history list."
L["TIP051"] = "Select the guild rank (if any) threshold. Any guild member who is below this rank will not be allowed to bid on or roll for the item. You can press the little '-' button to the right to automatically decrease this by one rank if you have no bidders of the current rank."
L["TIP052.0"] = "Open or Close Bids / End Roll"
L["TIP052"] = "Press this to open bids on the currently selected item, or to close bids if the bid was already open. Depending on the options chosen in the loot distribution screen closing a bid where there were no bidders may start an open roll or it may assign the item to a disenchanter. If an open roll is taking place, this will end the roll with the current winner (if any) in case you have a long countdown timer."
L["TIP053.0"] = "Open Roll / Pause Roll"
L["TIP053"] = "Press this to start an open roll, or to pause the countdown timer if a roll is already in progress. If you hold down the Shift key when you press this to start an open roll, it will instead do a 'suicide roll', where the winner of the roll is suicided on the currently selected list."
L["TIP054.0"] = "Remove / Cancel"
L["TIP054"] = "Press this to remove an item from the list of items, or to cancel a bid or roll that is currently in progress."
L["TIP055.0"] = "Bid / Retract"
L["TIP055"] = "Press this button to register or retract your own bid on an item."
L["TIP056"] = "Press this to force a user to bid on an item. The user must have been selected from the roll list members list to the left."
L["TIP057"] = "Press this to force a user to retract a bid. You must have selected one of the current bidders from the bidders list."
L["TIP058"] = "Undo the last bid. More than 1 item can be undone this way. When you reload your UI or you restart the game, all undo information is lost. This will ask for confirmation and show you the item and list that will be affected. You can undo many bids, but only in reverse order. You can not select a specific action to undo."
L["TIP059"] = "Select this to have the item be ignored by KSK. If an item is ignored, even if it is found on the corpse of a mob or in a chest, it will not be displayed in the loot list, and you will need to manually dispose of the item."
L["TIP060"] = "Set the list to select by default when this item is clicked in the loot items window. If you have a global default list selected, setting this value will override that default."
L["TIP061"] = "Set the rank filter for the item. This will override the global default rank, if set. If you change lists after selecting an item, the initial rank filter may change if the list you select also has a default rank filter set."
L["TIP062"] = "Select this if you want to ensure that the item is given to a specific user the next time it drops. If you enable this you must select the user, and you can decide if this should happen just once or for each drop. You can also decide if the user should be suicided on a given list when the item is auto-assigned to them."
L["TIP063"] = "Press this to select the user to receive the item the next time it drops."
L["TIP064"] = "Select this option if you want this auto-assignment record to be automatically removed from the item database when the item next drops and is assigned to the user. You would select this for a 'once-off' assignment. If this item is one that needs to be collected, for example a fragment of a weapon, you may want to disable this to assign all such drops to the user."
L["TIP065"] = "Set the list (if any) that the user should be suicided on if they receieve this item due to auto-asignment."
L["TIP066"] = "Press this to delete this item from the items database."
L["TIP067"] = "Clear all loot history. Note this only clears your own local history list, it does not affect the history for any other admins."
L["TIP068"] = "Clear all loot history except loot received in the last 7 days. Note this only clears your own local history list, it does not affect the history for any other admins."
L["TIP069"] = "Clear all loot history except loot received in the last month. Note this only clears your own local history list, it does not affect the history for any other admins."
L["TIP070"] = "Press this to export the loot assignment history as an XML string, possibly for uploading to a website."
L["TIP071"] = "Select the role the user plays in the raid / guild. This is used to set filters to restrict bidders to users who fulfill a certain role, in the case where an item may be useful to more than one type of player. For example you may decide that an item is better for healers, even though spellcasters may want it too."
L["TIP072"] = "Enter the user's name. This must be an exact match for their character name."
L["TIP073"] = "Select the user's class. You must assign their class and it must be accurate, as it affects the class filters."
L["TIP074"] = "Select the minimum level to accept for users. Any guild members below this level will not be imported."
L["TIP075"] = "Select this if the user is an enchanter. Users who are marked as enchanters are eligible to be selected as enchanters for the raid in the loot configuration screen."
L["TIP076"] = "Select this if a user is an alt of another user. It is a good idea to always keep this accurate, in case you ever decide to enable alt tethering. When alts are tethered to mains, they occupt the same spot on all lists as their main. When tethering is disabled, alts an mains are treated independently."
L["TIP077"] = "Press this to select the users main. Only users who are not already alts of another character will be displayed in the selection popup."
L["TIP078"] = "Select this to freeze a user in place, usually when they are going to be absent from the game for a while. A frozen user will retain their current position on all lists, and other users will 'move around' them when someone suicides on the list."
L["TIP080"] = "Press this to make these changes to the user attributes permanent. Until you press this no actual changes have been made to the user record."
L["TIP081"] = "Press this to create a new user."
L["TIP082"] = "Press this to delete the currently selected user, and remove them from all roll lists. You will be asked for confirmation, and if this user is the main user of several characters, you will be given the opportunity to delete all alts of the user too."
L["TIP083"] = "Press this to rename the current user, usually to correct a typing error in the users name or if they have changed their name using the Blizzard paid name change service."
L["TIP084"] = "Press this to import users from the guild roster."
L["TIP086"] = "Press this to add users who are current in the raid but not in the user list."
L["TIP087"] = "Press this to request sync information from the selected user. The user must be online."
L["TIP088"] = "Press this to request sync information from all admins currently online. If this is a guild configuration, the request is broadcast to the guild. If it is a PUG configuration, the request is broadcast to the raid. Any guild or raid members online who are admins will respond with their sync data."
L["TIP089"] = "Press this to broadcast the current configuration to the guild or raid, depending on the configuration type. This will update all guild members or raiders data if they are using KSK. Any user who was recently made a co-admin will be able to perform an initial sync with you after you broadcast the configuration. This generates a fair amount of traffic, so it is advisable to only do it when the raid is fully formed."
L["TIP090"] = "The owner of a configuration can press this to recover their configuration from another admin in the event that they completely lose their data after a crash."
L["TIP091"] = "Remove this roll from the list. Users can remove their own rolls using '/roll 1-1' but this gives the master looter the oportunity to remove a user from the roll list manually."
L["TIP092"] = "Enable this to have the open roll manager differentiate between main spec (1-100) and off-spec (101-200) rolls. If this is disabled and a user attempts to '/roll 101-200' it will be ignored."
L["TIP093"] = "If this option is set, then the 'Open Roll' button in the loot distribution window will be a suicide roll (a roll that suicides the winner on the current list) by default, and to get an open roll that does not suicide you will need to Shift-click the roll button. When this is not set, these two roll styles are reversed (open roll by default, suicide roll on Shift-click)."
L["TIP094"] = "Send the ordered list of members for the given roll list to the raid. Unlike the 'Announce' button which only lists the current raiders, this will send the full list, with no raid relative positions. If you Shift-click this button it will be sent to guild chat instead of raid chat."
L["TIP095"] = "Set the minimum item level that will be available for bids / rolls. If you set this to a value higher than the master loot threshold, you may want to have all items below this level automatically disenchanted. If so check the option next to this one."
L["TIP096"] = "If you have the bid item level threshold set and it is set to a level higher than the master loot threshold, enable this option to have all items below the bid threshold automatically sent to the raid disenchanter. If no enchanters are online, items below the bid threshold will be looted to the master looter."
L["TIP097"] = "Enable this option to have the item automatically sent to a raid enchanter and completely bypass bidding or rolling. If an enchanter is not online, it will be given to the master looter."
L["TIP098"] = "Enable this option to have the item automatically sent to the master looter, and completely bypass bidding and rolling."
L["TIP099"] = "Start typing the name of a user you wish to search for. This can be any part of the user's name. The first user that matches is highlighted and selected."
L["TIP100"] = "Mark which guild ranks are officer ranks. Only officers will be permitted to broadcast configs to the entire guild."

--
-- Shared Konfer dialog. These strings are used by all Konfer addons.
--
L["KONFER_SEL_TITLE"] = "Select Active %s Konfer Module"
L["KONFER_SEL_HEADER"] = "You have multiple %s Konfer modules installed, and more than one of them is active and set to auto-open when you loot a corpse or chest. This can cause conflicts and you need to select which one of the modules should be the active one. All others will be suspended."
L["KONFER_SEL_DDTITLE"] = "Select Module to Make Active"
L["KONFER_ACTIVE"] = "active"
L["KONFER_SUSPENDED"] = "suspended"
L["KONFER_SUSPEND_OTHERS"] = "You have just activated the %s Konfer module above, but other Konfer modules are also currently active. Having multiple Konfer modules active at the same time can cause problems, especially if more than one of them is set to auto-open on loot. It is suggested that you suspend all other Konfer modules. If you would like to do this and make the module above the only active one, press 'Ok' below. If you are certain you want to leave multiple Konfer modules running, press 'Cancel'."
