--[[
   KahLua KonferSK - a suicide kings loot distribution addon.
     WWW: http://kahluamod.com/ksk
     Git: https://github.com/kahluamods/konfersk
     IRC: #KahLua on irc.freenode.net
     E-mail: cruciformer@gmail.com
   Please refer to the file LICENSE.txt for the Apache License, Version 2.0.

   Copyright 2008-2018 James Kean Johnston. All rights reserved.
   Copyright 2009-2010 Stefan Junghanns. All rights reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
]]

local K = LibStub:GetLibrary("KKore")

if (not K) then
  error ("KahLua KonferSK: KahLua Kore konnte nicht gefunden werden.", 2)
end

local L = K:RegisterI18NTable("KKonferSK", "deDE")
if (not L) then
  return
end

--
-- NOTE TO PEOPLE LOCALISING THIS FILE:
-- PLEASE BE SURE TO VIEW THE LOCALISATION INSTRUCTIONS FOUND AT
-- http://kahluamod.com/l10n BEFORE STARTING ANY TRANSLATIONS OF
-- THIS FILE. THANK YOU.
--

L["MODTITLE"] = "KonferSK"
L["MODNAME"] = "konfersk"
L["MODABBREV"] = "KSK"
L["CMDNAME"] = "ksk"
L["CMD_CONFIG"] = "einstellung"
L["CMD_USERS"] = "nutzer"
L["CMD_HELP"] = "hilfe"
L["CMD_LOOT"] = "loot"
L["CMD_LISTS"] = "listen"
L["CMD_SYNC"] = "sync"
L["CMD_VERSION"] = "version"
L["CMD_RESETPOS"] = "resetpos"
L["CMD_REPAIR"] = "repair"
L["CMD_SUSPEND"] = "suspend"
L["CMD_RESUME"] = "resume"
L["CMD_VERSIONCHECK"] = "versionscheck"
L["CMD_SELECTCONFIG"] = "configauswählen"
L["CMD_CREATECONFIG"] = "configerstellen"
L["CMD_DELETECONFIG"] = "configlöschen"
L["CMD_RENAMECONFIG"] = "configumbenennen"
L["CMD_COPYCONFIG"] = "configkopieren"
L["CMD_CREATEUSER"] = "usererstellen"
L["CMD_DELETEUSER"] = "userlöschen"
L["CMD_RENAMEUSER"] = "userumbenennen"
L["CMD_SELECTLIST"] = "listeauswählen"
L["CMD_CREATELIST"] = "listeerstellen"
L["CMD_DELETELIST"] = "listelöschen"
L["CMD_RENAMELIST"] = "listeumbenennen"
L["CMD_COPYLIST"] = "listekopieren"
L["CMD_ADDITEM"] = "additem"
L["CMD_ADDLOOT"] = "addloot"
L["CMD_IMPORTGUILDUSERS"] = "importgildenmitglieder"
L["CMD_SHOW"] = "zeige"
L["SUBCMD_HELP"] = "hilfe"
L["SUBCMD_LOOT"] = "loot"
L["SUBCMD_ROLLS"] = "rolls"
L["SUBCMD_ADMIN"] = "admin"
L["SUBCMD_ASSIGN"] = "zuteilen"
L["SUBCMD_ITEMS"] = "items"
L["SUBCMD_HISTORY"] = "historie"

L["ABOUT1"] = "Bitte meldet alle Probleme, Kommentare oder Vorschläge"
L["ABOUT2"] = "an <%s>. Danke!"
L["ABOUT3"] = "Besucht %s für weitere Details."

L["WHISPERCMD_BID"] = "bid"
L["WHISPERCMD_RETRACT"] = "retract"
L["WHISPERCMD_SUICIDE"] = "suicide"
L["WHISPERCMD_STANDBY"] = "standby"
L["WHISPERCMD_HELP"] = "ksk"

--
-- Main localisation strings start here
--

L["VCTITLE"] = "%s %s Version Check"
L["Version"] = "Version"
L["In Raid"] = "In Raid"
L["NEWMSG"] = "Gebe den Namen einer neuen Konfiguration unten ein. Bitte denke daran, dass diese neue Konfiguration keine Daten mit einer anderen Konfiguration austauscht. Diese neue Konfiguration wird als komplett separate Kopie von Konfer behandelt."
L["DELMSG"] = "Bist du absolut sicher, dass du diese Konfiguration löschen möchtest? Es ist nicht möglich, diese Handlung rückgängig zu machen und alle Loot-Listen, Nutzerrechte, vergangenen Raids und Loot-Informationen, die an diese Konfiguration geknüpft sind, gehen verloren. Wenn du der Besitzer dieser Konfiguration bist, solltest du warten, bis du eine andere Person zum Besitzer erklärt hast. Sonst können sie die sicherheitsrelevanten Einstellungen nicht verändern. Bitte sei dir absolut sicher, dass dort oben die richtige Liste dargestellt ist, bevor du fortfährst."
L["DELUSER"] = "Bist du absolut sicher, dass du diesen Nutzer löschen möchtest? Es ist nicht möglich, diese Handlung rückgängig zu machen und die kompletten Nutzer-Informationen gehen verloren. Außerdem wird der Nutzer von allen Listen, nicht nur von der aktiven, gelöscht. Wenn der Nutzer ein Main-Charakter ist und Twinks festgelegt wurden, werden auch alle Twinks gelöscht. Bitte sei dir absolut sicher, dass der richtige Nutzer dort oben steht, bevor du fortfährst."
L["NEWLIST"] = "Gebe den Namen der neuen Loot-Liste unten ein. Wenn die Liste einmal erstellt wurde, kannst du Nutzer zur Liste hinzufügen oder Nutzer aus der Gilde importieren. Du kannst außerdem unterschiedliche Listen-Optionen einstellen wenn du den Tab 'Einstellungen' oben im Listen-Manager-Fenster auswählst."
L["DELLIST"] = "Bist du dir absolut sicher, dass du diese Loot-Liste löschen möchtest? Es ist nicht möglich, dies rückgängig zu machen und die ganze Listen-Historie und ihre Positionen gehen verloren. Bitte sei dir wirklich sicher, dass dies die richtige Liste ist, bevor du fortfährst."
L["AUTOASSIGN"] = "Dieses Item ist mit der Auto-Loot-Funktion dem Nutzer %q zugewiesen. Drücke 'OK' um das Item %s zuzuweisen oder 'Abbrechen', um die automatische Zuordnung zu ignorieren."
L["AUTOSUICIDE"] = "Wenn du entscheidest, dieses Item an %s zu vergeben, wird der Nutzer automatisch 'suicided' auf der Liste %s."
L["AUTOLOOT"] = "Dieses Item wurde von %s gewonnen. Drücke 'OK', um das Item %s automatisch zuzuteilen. Wenn du 'Abbrechen' drückst, wird das Item trotzdem von der Loot-Liste entfernt und du musst es %s mit dem Standard User Interface zuteilen."
L["AUTODENCH"] = "Das Item hat keine Bieter. Entzauberer %q ist online und im Raid. Drücke 'Ok' um %s das Item zuzuteilen. Drücke 'Abbrechen' wenn du das Item manuell zuweisen möchtest oder wenn du es zum Würfeln freigeben möchtest (Das Item bleibt in der Loot-Liste wenn du 'Abbrechen' drückst)."
L["AUTODENCHNR"] = "Niemand hat auf das Item gewürfelt. Entzauberer %q ist online und im Raid. Drücke 'Ok', um %s das Item zuzuteilen. Drücke 'Abbrechen' wenn du das Item manuell zuweisen möchtest (Das Item wird von der Loot-Liste entfernt, aber nicht aus dem Leichnam oder aus der Truhe)."
L["PUGCONFIG"] = "Spieler %q hat die oben genannte PUG Konfiguration gesendet. Wenn dies eine normale PUG ist, die %s benutzt, um den Loot zu verwalten und du alle Loot Ereignisse, Listen und Mitglieder nachvollziehen möchtest, drücke 'OK' um zu Akzeptieren und diese Konfiguration zu erstellen (Du wirst für diese Konfiguration keine weiteren Bestätigungen bekommen). Wenn du diese Sendung nicht akzeptieren willst, drücke 'Abbrechen' (Du wirst diese Nachricht trotzdem immer sehen, wenn der Raidleiter die Liste sendet)."
L["LISTPOSMSG"] = "%s: Unten siehst du die Listen-Positionen in der Konfiguration %q. Warum lädst du nicht %s runter, dann kannst du selber die Listen verfolgen, anstatt immer dieses Kommando zu schreiben."
L["RECOVERMSG"] = "Du bist der Besitzer der oben genannten Konfiguration und du hast eine Wiederherstellung der Liste von dem Nutzer %q angefragt. Bitte beachte, dass %s mit allen Admins synchronisiert sein muss, damit die Wiederherstellung funktioniert. Wenn du mit der Wiederherstellung fortfährst, löschst du deine komplette Konfiguration (aber nicht deine lokalen Einstellungen) eingeschlossen alle Listen, Nutzer, Items und Loot-Historien. Die Benutzung der Wiederherstellungsfunktion sollte dein allerletzter Versuch sein, eine beschädigte Konfiguration zu reparieren. Wenn du kein BackUp von deinen 'SavedVariables' hast, solltest du jetzt das Spiel schließen und dies tun. Bitte sei dir absolut sicher, dass du das tun möchtest. Es ist wirklich ein drastischer Schritt."

L["HELPMSG1"] = "%s: Um %s zu benutzen, flüstere eines der folgenden Kommandos an einen Admin. Um auf ein Item zu bieten oder dein Gebot zurückzuziehen musst du an den Plündermeister flüstern. Alle anderen Kommandos können an jeden %s Admin gesendet werden."
L["HELPMSG2"] = "%s: %s - biete auf das aktuelle Loot-Item"
L["HELPMSG3"] = "%s: %s - ziehe dein aktuelles Gebot zurück"
L["HELPMSG4"] = "%s: %s - zeige deine Position in den Loot-Listen"
L["HELPMSG5"] = "%s: %s - zeige, dass du zum Raiden verfügbar bist"

L["USER_RESERVED"] = "R"
L["USER_ENCHANTER"] = "E"
L["USER_FROZEN"] = "F"

L["error: "] = "Fehler: "
L["Suicide Kings loot distribution system."] = "Suicide Kings Loot-System"
L["%s<%s>%s %s (version %d) - %s"] = "%s<%s>%s %s (Version %d) - %s"
L["/%s [command [arg [arg...]]]"] = "/%s [Kommando [arg [arg...]]]"
L["Usage: "] = "Verwendung: "
L["  Open the list management window."] = "  Öffnet das Listen-Management-Fenster."
L["  Opens the user list management window."] = "  Öffnet das User-Listen-Management-Fenster."
L["  Opens the loot management window."] = "  Öffnet das Loot-Management-Fenster."
L["  Opens the sync manager window."] = "  Öffnet das Sync-Management-Fenster."
L["  Suspend %s (no auto-open on loot, no missing member warnings etc)."] = "  Unterdrücke %s (kein Auto-Loot, kein fehlenden Mitglieder)."
L["  Resume normal %s operations."] = "  Wiederaufnahme normaler %s Operationen."
L["  Set up various options and manage configurations."] = "  Setzt verschiedene Optionen und verwaltet die Konfigurationen."
L["  %s - configure lists and list options"] = "  %s - bearbeitet Listen und Listenoptionen"
L["  %s - set up loot related options"] = "  %s - legt das Loot betreffende Optionen fest"
L["  %s - set up roll related options"] = "  %s - legt das Würfeln betreffende Optionen fest"
L["  %s - set up config spaces and permissions options"] = "  %s - Konfigurationen und Berechtigungen einstellen"
L["  %s - open the loot assignment window"] = "  %s - Öffnet das Loot-Vergabe-Fenster"
L["  %s - open the item editor window"] = "  %s - Öffnet das Item-Editor-Fenster"
L["  %s - open the item history window"] = "  %s - Öffnet das Item-Historie-Fenster"
L["/%s %s name"] = "/%s %s Name"
L["/%s %s [itemid | itemlink]"] = "/%s %s [ItemID | Item-Link]"
L["  Adds a new item to the item list."] = "  Fügt ein neues Item zur Item-Liste hinzu."
L["  Adds a new item to the loot list."] = "  Fügt ein neues Item zur Loot-Liste hinzu."
L["/%s %s oldname newname"] = "/%s %s alterName neuerName"
L["  Selects the specified configuration as the current one."] = " Wählt eine andere Konfiguration als die aktuelle aus." 
L["  Create the specified configuration."] = "  Erstellt eine festgelegte Konfiguration."
L["  Delete the specified configuration."] = "  Löscht eine festgelegte Konfiguration."
L["  Renames the specified configuration."] = "  Benennt eine festgelegte Konfiguration um."
L["  Copies the specified configuration to a new one, with options."] = "  Kopiere eine festgelegte Konfiguration und ihre Optionen in eine neue."
L["/%s %s name class"] = "/%s %s Name Klasse"
L["  Adds a new user to the users list."] = "  Fügt einen neuen Nutzer zur Nutzer-Liste hinzu."
L["  Removes a user from the users list."] = "  Löscht einen Nutzer von der Nutzer-Liste."
L["  Renames a user after a paid name change."] = "  Benenne einen Nutzer nach einem bezahlten Namenswechsel um."
L["%q is not a valid command. Type %s for help."] = "%q ist kein gültiges Kommando. Tippe %s für Hilfe."
L["Create Configuration"] = "Erstellt eine Konfiguration"
L["Delete Configuration"] = "Löscht die Konfiguration"
L["Rename Configuration"] = "Benennt die Konfiguration um"
L["Old Name"] = "Alter Name"
L["New Name"] = "Neuer Name"
L["Copy Configuration"] = "Kopiert die Konfiguration"
L["Source Configuration"] = "Quell-Konfiguration"
L["Destination Configuration"] = "Ziel-Konfiguration"
L["Roll Lists to Copy"] = "Zu kopierende Loot-Listen"
L["Copy Co-admins"] = "Kopiere Co-Admins"
L["Copy Configuration Options"] = "Kopiere Konfigurationsoptionen"
L["Copy Raid History"] = "Kopiert die Raid-Historie"
L["Copy Item Options"] = "Kopiert die Item-Optionen"
L["Copy All User Flags"] = "Kopiert alle Nutzerrechte"
L["usage: %s/%s %s name%s"] = "Verwendung: %s/%s %s Name%s"
L["usage: %s/%s %s oldname newname%s"] = "Verwendung: %s/%s %s alterName neuerName%s"
L["usage: %s/%s %s name class%s"] = "Verwendung: %s/%s %s Name Klasse%s"
L["Auto-open Bid Panel When Corpse Looted"] = "Öffnet das Gebotsfenster automatisch, wenn ein Leichnam gelootet wird"
L["Silent Bidding"] = "Stilles Bieten"
L["Display Tooltips in Loot List"] = "Zeigt die Tooltipps in der Loot-Liste"
L["Enable Chat Message Filter"] = "Aktiviert den Chat-Filter"
L["Record Loot Assignment History"] = "Zeichnet die Loot-Zuteilung auf"
L["Open Roll Timeout"] = "Timeout für das Würfeln"
L["Roll Timeout Extension"] = "Erweiterung des Wurf-TimeOuts"
L["Use Default Roll List"] = "Benutze die Standard-Wurfliste"
L["Auto-assign Loot When Bids Close"] = "Teilt Loot automatisch zu, wenn Gebote geschlossen wurden"
L["When there are no successful bids ..."] = "Wenn keine erfolgreichen Gebote vorhanden sind..."
L["Try Open Roll"] = "Versuche Open Roll"
L["Assign BoE Items to Master Looter"] = "teile BoE-Items dem Plündermeister zu"
L["Assign To Enchanter"] = "teile das item dem Entzauberer zu"
L["invalid configuration name. Please try again."] = "Ungültiger Konfigurationsname. Bitte versuche es erneut."
L["invalid list name. Please try again."] = "Ungültiger Listensname. Bitte versuche es erneut."
L["configuration %q created."] = "Konfiguration %q wurde erstellt."
L["configuration %q already exists. Try again."] = "Konfiguration %q besteht bereits. Versuche es erneut."
L["configuration %q does not exist. Try again."] = "Konfiguration %q gibt es nicht. Versuche es erneut."
L["Lists"] = "Listen"
L["List Manager"] = "Listen-Manager"
L["Members"] = "Mitglieder"
L["Config"] = "Konfiguration"
L["Users"] = "Nutzer"
L["User List Manager"] = "Nutzer-Listen-Manager"
L["Loot"] = "Loot"
L["Loot Manager"] = "Loot-Manager"
L["Assign Loot"] = "Loot zuteilen"
L["Item Editor"] = "Item-Editor"
L["Sync"] = "Sync"
L["Rolls"] = "Würfeln"
L["Sync Manager"] = "Sync Manager"
L["Config Manager"] = "Konfigurationsmanager"
L["Admin"] = "Admin"
L["Create"] = "Erstellen"
L["Add"] = "Hinzufügen"
L["Delete"] = "Löschen"
L["Rename"] = "Umbenennen"
L["Copy"] = "Kopieren"
L["Update"] = "Updaten"
L["Set As Default"] = "Als Standard setzen"
L["Reset"] = "Zurücksetzen"
L["Select"] = "Auswählen"
L["Config Owner"] = "Konfigurationsbesitzer"
L["Alts Tethered to Mains"] = "Twinks an Main gekoppelt"
L["cannot delete configuration %q - KonferSK requires at least one configuration."] = "Kann die Konfiguration %q nicht löschen - KonferSK benötigt mindestens eine Konfiguration."
L["configuration %q deleted."] = "Konfiguration %q wurde gelöscht."
L["user %q deleted."] = "Nutzer %q wurde gelöscht."
L["roll list %q deleted."] = "Loot-Liste %q wurde gelöscht."
L["NOTICE: default configuration changed to %q."] = "ACHTUNG: Standard-Konfiguration geändert zu %q."
L["NOTICE: configuration %q renamed to %q."] = "ACHTUNG: Konfiguration %q wurde in %q umbenannt."
L["NOTICE: user %q renamed to %q."] = "ACHTUNG: Nutzer %q wurde zu %q umbenannt."
L["NOTICE: roll list %q renamed to %q."] = "ACHTUNG: Wurf-Liste %q wurde zu %q umbenannt."
L["Co-admins"] = "Co-Admins"
L["User Role"] = "Nutzerrolle"
L["Not Set"] = "Nicht festgelegt"
L["Tank"] = "Tank"
L["Ranged DPS"] = "Ranged DPS"
L["Melee DPS"] = "Melee DPS"
L["Healer"] = "Healer"
L["Spellcaster"] = "Spellcaster"
L["User is an Enchanter"] = "Nutzer ist ein Verzauberer"
L["User is an Alt of"] = "Nutzer ist ein Twink von"
L["User is Frozen"] = "Nutzer ist eingefroren"
L["Guild Import"] = "Gilden-Import"
L["user %q already exists. Try again."] = "Nutzer %q existiert bereits. Versuche es nochmal."
L["user %q does not exist. Try again."] = "Nutzer %q existiert nicht. Versuche es nochmal."
L["user %q created."] = "User %q wurde erstellt."
L["cannot complete command until a configuration space exists."] = "Befehl kann nicht abgeschlossen werden, bis ein Konfigurationsplatz existiert."
L["invalid class %q specified. Valid classes are:"] = "ungültige Klasse %q angegeben. Gültige Klassen sind:"
L["cannot delete user %q as they are the owner of the configuration."] = "Kann den Nutzer %q nicht löschen, wenn er der Besitzer der Konfiguration ist."
L["Delete All Alts of User"] = "Lösche alle Twinks des Users"
L["Create User"] = "Erstelle Nutzer"
L["Delete User"] = "Lösche Nutzer"
L["Rename User"] = "Nutzer umbenennen"
L["User Name"] = "User-Name"
L["User Class"] = "User-Klasse"
L["you must set a user class."] = "Du musst eine Klasse festlegen."
L["you must specify a character name."] = "Du musst einen Charakternamen festlegen."
L["Import Guild Users"] = "Importiere Gildenmitglieder"
L["Guild Rank"] = "Gildenrang"
L["added %d user(s)."] = "%d Nutzer hinzugefügt."
L["Assign Mains to Alts"] = "Teile die Mains den Twinks zu"
L["Select Enchanter"] = "Wähle Verzauberer aus"
L["Select Co-admin"] = "Wähle Co-Admin aus"
L["Currently Selected: "] = "Aktuell ausgewählt: "
L["Create Roll List"] = "Erstelle Wurf-Liste"
L["Delete Roll List"] = "Lösche Wurf-Liste"
L["Rename Roll List"] = "Wurf-Liste umbenennen"
L["Copy Roll List"] = "Wurf-Liste kopieren"
L["Source List"] = "Quell-Liste"
L["Destination List"] = "Ziel-Liste"
L["Broadcast"] = "Rundsenden"
L["Announce"] = "Verkünden"
L["Announce All"] = "Allen verkünden"
L["invalid roll list name. Please try again."] = "ungültiger Wurf-Listen-Name. Bitte versuche es erneut."
L["roll list %q already exists. Try again."] = "Wurf-Liste %q existiert bereits. Versuche es erneut."
L["roll list %q does not exist. Try again."] = "Wurf-Liste %q existiert nicht. Versuche es erneut."
L["roll list %q created."] = "Wurf-Liste %q wurde erstellt."
L["you do not have permission to do that in this configuration."] = "Du hast nicht ausreichend Rechte, dies in dieser Konfiguration zu tun."
L["you are not an administrator of this configuration. Your access to it is read-only."] = "Du bist kein Administrator von dieser Konfiguration. Du kannst die Konfiguration nur lesen."
L["you are the master looter but not an administrator of this configuration. You will be unable to loot effectively. Either change master looter or have the owner of the configuration assign you as an administrator."] = "Du bist der Plündermeister, aber kein Administrator dieser Konfiguration. Du wirst nicht effektiv looten können. Ändere entweder den Plündermeister oder bitte den Besitzer der Konfiguration, dich als Administrator einzutragen."
L["no active configuration. Either create one with %s or wait for a guild admin to broadcast the guild list."] = "Keine aktive Konfiguration. Entweder erstelle eine mit %s oder warte auf einen Administrator, der dir die Gildenliste sendet."
L["Insert"] = "Einfügen"
L["Delete"] = "Löschen"
L["King"] = "King"
L["Move Up"] = "Nach oben"
L["Move Down"] = "Nach unten"
L["Suicide"] = "Suicide"
L["Reserve"] = "Reservieren"
L["Unreserve"] = "Reservieren aufheben"
L["Add Missing"] = "Fehlende hinzufügen"
L["NOTICE: user %q is in the raid but not in the user list."] = "ACHTUNG: Nutzer %q ist im Raid, aber nicht auf der Nutzerliste."
L["Insert Roll List Member"] = "Wurf-Listen-Mitglieder einfügen"
L["Insert Randomly"] = "Zufällig einfügen"
L["Sort Order"] = "Reihenfolge"
L["Strict Class Armor Filtering"] = "Klassen-Rüstungsfilter"
L["Strict Role Filtering"] = "Rollen Filter"
L["Suicide on Additional List"] = "Suicide auf zusätzlicher Liste"
L["Show Tethered Alts"] = "Zeige verknüpfte Twinks"
L["None"] = "Keine"
L["Open Roll"] = "Würfeln freigeben"
L["Import"] = "Import"
L["Export"] = "Export"
L["Import List Members"] = "Listen Mitglieder importieren"
L["Export List Members"] = "Listen Mitglieder exportieren"
L["Guild Rank to Import"] = "Zu importierender Gildenrang"
L["CSV Import"] = "CSV Import"
L["Class Filter"] = "Klassenfilter"
L["Other Filters"] = "Andere Filter"
L["Strict Class Armor"] = "Klassen-Rüstungsfilter"
L["Strict Role Filter"] = "Rollen-Filter"
L["Bid"] = "Bieten"
L["Retract"] = "Zurückziehen"
L["Force Bid"] = "Gebot erzwingen"
L["Force Retract"] = "Gebotsrücknahme erzwingen"
L["Open Bids"] = "Gebote öffnen"
L["Close Bids"] = "Gebote schließen"
L["Pause"] = "Pause"
L["End Roll"] = "Wurfende"
L["Resume"] = "Weiter"
L["Remove"] = "Entfernen"
L["Ignore Item"] = "Item ignorieren"
L["Roll on Specific List"] = "Auf spezieller Liste würfeln"
L["Class Restriction"] = "Klassen-Einschränkung"
L["Role Restriction"] = "Rollen-Einschränkung"
L["Assign Next Drop to User"] = "Teile nächstes Item dem Nutzer zu"
L["Auto-Remove When Assigned"] = "Auto-Löschen, wenn zugeteilt"
L["Suicide User on List"] = "Nutzer auf der Liste 'suiciden'"
L["your version of %s is out of date. Please update it."] = "Deine Version von %s ist nicht aktuell. Bitte aktualisiere sie."
L["Announce Loot"] = "Loot verkünden"
L["Announce Winners in Guild Chat"] = "Gewinner im Gilden-Chat verkünden"
L["Nowhere"] = "Nirgendwo"
L["In Guild Chat"] = "Im Gilden-Chat"
L["In Raid Chat"] = "Im Raid-Chat"
L["Loot from %s: "] = "Loot von %s: "
L["Chest"] = "Brust"
L["Config Type"] = "Konfigurations-Typ"
L["Guild"] = "Gilde"
L["PUG"] = "PUG"
L["item %s already exists."] = "Item %s existiert bereits."
L["item %d is an invalid item."] = "Item %d ist ein ungültiges Item."
L["Initial Guild Rank Filter"] = "Initialisiere Gildenrang-Filter"
L["Request Sync"] = "Sync anfragen"
L["Request Sync (All)"] = "Sync anfragen (alle)"
L["Broadcast"] = "Rundsenden"
L["Recover"] = "Wiederherstellen"
L["sync request received from %q but I do not recognise them as an admin. Please sync with the config owner (%q)."] = "Sync-Anfrage von %q bekommen aber der Nutzer wurde nicht als Admin erkannt. Bitte synchronisiere mit dem Konfigurationsbesitzer (%q)."
L["Bids now open for %s on the %q list."] = "Bieten geöffnet für %s auf der Liste %q."
L["Bid list changed to %q for %s."] = "Gebots-Liste gewechselt zu %q für %s."
L["%s: to bid on %s, whisper %s the word %q. For general help using %s, whisper an admin the word %q."] = "%s: Um auf %s zu bieten, flüstere %s das Wort %q. Für allgemeine Hilfe flüstere einem Admin das Wort %q."
L["%s: bids closing in: %d"] = "%s: Gebote enden in: %d"
L["%s: %s%s (group %d) won %s. Grats!"] = "%s: %s%s (Gruppe %d) hat %s gewonnen. GW!"
L["%s: %s%s won %s. Grats!"] = "%s: %s%s hat %s gewonnen. GW!"
L["%s: %s was auto-assigned %s."] = "%s: %s wurde %s automatisch zugeteilt."
L["%s: to retract your bid whisper %s the word %q."] = "%s: Um dein Gebot zurückzuziehen, flüstere %s das Wort %q."
L["%s: bid retracted"] = "%s: Gebot zurückgezogen"
L["%s: no item currently being bid on."] = "%s: Es wird im Moment auf kein Item geboten."
L["%s: you are not a member of the current list (%q) - bid ignored."] = "%s: Du stehst nicht auf der aktuellen Liste (%q) - Gebot ignoriert."
L["%s: you do not meet the current guild rank requirement (%q) - %s ignored."] = "%s: Du erfüllst nicht den benötigten Gildenrang (%q) - %s ignoriert."
L["%s: you do not meet the current role requirement (%q). Your current role is %q - %s ignored."] = "%s: Du erfüllst nicht die benötigte Rolle (%q). Deine aktuelle Rolle ist %q - %s ignoriert."
L["%s: you do not meet the current class restrictions (%s) - %s ignored."] = "%s: Du bist kein Mitglied der aktuellen Klassen-Einschränkungen (%s) - %s ignoriert."
L["Auto-assign Loot"] = "Loot automatisch zuteilen"
L["bid"] = "Bieten"
L["roll"] = "Würfeln"
L["retracted"] = "Zurückgezogen"
L["%s: there is no item currently open for bids."] = "%s: Es wird im Moment auf kein Item geboten."
L["%s: you are not eligible to receive loot - %s ignored."] = "%s: Du bist nicht dazu berechtigt, Loot zu erhalten - %s ignoriert."
L["%s: I am not the master looter - %q is."] = "%s: Ich bin nicht der Plündermeister - %q ist es."
L["%s: I am not the master looter."] = "%s: Ich bin nicht der Plündermeister."
L["%s: loot method is not master looter, there is no bidding."] = "%s: Die Loot-Methode ist zurzeit nicht Plündermeister, es wird also nicht geboten."
L["%s: you were not found in the user list. Contact an admin for help."] = "%s: Du wurdest nicht in der Nutzer-Liste gefunden. Kontaktiere einen Admin für weiter Hilfe."
L["%s: you are not in my guild - bid ignored."] = "%s: Du bist nicht in meiner Gilde - Gebot ignoriert."
L["user %q has no role defined - permitting %s."] = "Nutzer %q wurde keine Rolle zugewiesen - erlaube %s."
L["%s: you are not a member of the %q list - bid ignored."] = "%s: Du bist kein Mitglied der Liste %q - Gebot ignoriert."
L["%q attempted to bid on the %q list but is not a member."] = "%q versuchte auf die Liste %q zu bieten, ist aber kein Mitglied."
L["%s: you have already bid on that item. Whisper %s the word %q to retract your bid."] = "%s: Du hast schon auf dieses Item geboten. Flüstere %s das Wort %q um dein Gebot zurückzuziehen."
L["%s: new bid received. Number of bidders: %d."] = "%s: neues Gebot erhalten. Anzahl der Bieter: %d."
L["%s: bid retracted. Number of bidders: %d."] = "%s: Gebot zurückgezogen. Anzahl der Bieter: %d."
L["%s: %s (position %d) has bid (highest bidder is %s)."] = "%s: %s (Position %d) hat geboten (höchster Bieter ist %s)."
L["%s: %s has retracted (highest bidder is %s)."] = "%s: %s hat zurückgezogen (höchster Bieter ist %s)."
L["%s: %s has retracted (no other bidders)."] = "%s: %s hat zurückgezogen (keine anderen Bieter)."
L["%s: no successful bids for %s."] = "%s: Keine erfolgreichen Gebote für %s."
L["Note: only top 5 rolls shown."] = "Nur die ersten 5 Würfe werden gezeigt."
L["Roll for %s within %d seconds."] = "Würfeln für %s innerhalb %d Sekunden."
L["Suicide Roll (on list %q) for %s within %d seconds."] = "Suicide Würfeln (auf Liste %q) für %s innerhalb %d Sekunden."
L["%s: type '/roll' for main spec, '/roll 101-200' for off-spec or '/roll 1-1' to cancel a roll."] = "%s: Benutze '/roll' für Main-Spec, '/roll 101-200' für Off-Spec oder '/roll 1-1' um den Wurf abzubrechen."
L["%s: type '/roll' for main spec or '/roll 1-1' to cancel a roll."] = "%s: Benutze '/roll' für Main-Spec oder '/roll 1-1' um den Wurf abzubrechen."
L["%s: roll closing in: %d"] = "%s: Würfe enden in: %d"
L["Roll closing in %s"] = "Würfeln endet in %s"
L["%s: invalid roll. Use '/roll' for main spec, '/roll 101-200' for off-spec or '/roll 1-1' to cancel a roll."] = "%s: Ungültiger Wurf. Benutze '/roll' für Main-Spec, '/roll 101-200' für Off-Spec oder '/roll 1-1' um den Wurf abzubrechen."
L["%s: invalid roll. Use '/roll' for main spec or '/roll 1-1' to cancel a roll."] = "%s: Ungültiger Wurf. Benutze '/roll' für Main-Spec oder '/roll 1-1' um den Wurf abzubrechen."
L["%s: you already rolled %d. New roll ignored."] = "%s: Du hast bereits %d gewürfelt. Neuer Wurf ignoriert."
L["top main spec rollers: %s"] = "Top First-Need Würfler: %s"
L["top off-spec rollers: %s"] = "Top Second-Need Würfler: %s"
L["%s: the following users tied with %d: %s. Roll again."] = "%s: Folgende Nutzer würfelten unentschieden mit %d: %s. Würfelt erneut."
L["%s: sorry you are not allowed to roll right now."] = "%s: Sorry, dir ist im Moment nicht erlaubt, zu würfeln."
L["no-one rolled for %s."] = "Niemand hat für %s gewürfelt."
L["%s %s on %s on the %s list."] = "%s %s auf %s auf der Liste %s."
L["%s: relative positions of all currrent raiders for the %q list (ordered highest to lowest): "] = "%s: Relative Positionen aller aktuellen Raid-Mitglieder auf der Liste %q (geordnet vom Höchsten zum Niedrigsten): "
L["%s: members of the %q list (ordered highest to lowest): "] = "%s: Mitglieder auf der %q Liste (geordnet vom Höchsten zum Niedrigsten): "
L["Accept Configuration"] = "Konfiguration annehmen"
L["configuration %q updated by %q"] = "Konfiguration %q updated by %q"
L["Checksum: 0x%s"] = "Prüfsumme: 0x%s"
L["Up to date"] = "Aktuell"
L["My checksum: %s"] = "Meine Prüfsumme: %s"
L["Not active!"] = "Nicht aktiv!"
L["maximum number of co-admins (36) reached"] = "Die maximale Anzahl an Co-Admins wurde erreicht (36)"
L["%s: %s - #%d (#%d in raid)"] = "%s: %s - #%d (#%d im Raid)"
L["%s: %s - #%d"] = "%s: %s - #%d"
L["%s: (End of list)"] = "%s: (Ende der Liste)"
L["%s: you are not on any roll lists (yet)."] = "%s: Du bist auf keiner Wurf-Liste (bis jetzt)."
L["sync with user %s complete."] = "Sync mit Nutzer %s abgeschlossen."
L["sending sync data to user %s."] = "Sende Sync-Daten zu Nutzer %s."
L["%s: %s cancelled!"] = "%s: %s hat abgebrochen!"
L["Set List to Imported Values"] = "Setze Liste zu importierten Werten"
L["Add to Existing Members"] = "Zu bestehenden Nutzern hinzufügen"
L["Randomly Add to Existing Members"] = "Zufällig zu bestehenden Nutzern hinzufügen"
L["The following users are missing from the user list: %s"] = "Folgende Nutzer fehlen auf der Nutzer Liste: %s"
L["Import from the CSV string cannot continue until these users are added."] = "Der Import vom CSV-String kann nicht fortgeführt werden, bis diese Nutzer hinzugefügt sind."
L["Nothing"] = "Nichts"
L["Export current list as CSV"] = "Exportiere aktuelle Liste als CSV"
L["Export current list as XML"] = "Exportiere aktuelle Liste als XML"
L["Export current list as BBcode"] = "Exportiere aktuelle Liste als BBcode"
L["Export all lists as XML"] = "Exportiere alle Listen als XML"
L["Export all lists as BBcode"] = "Exportiere alle Listen als BBcode"
L["Export string"] = "Export String"
L["Press Ctrl+C to copy the export string"] = "Drücke Strg+C um den exportierten String zu kopieren"
L["Current list: %s"] = "Aktuelle Liste: %s"
L["%s using version %s"] = "%s benutzt Version %s"
L["(in raid)"] = "(im Raid)"
L["busy syncing with %q. Please try again when complete."] = "Laufende Synchronisation mit %q. Versuche es bitte wieder, wenn sie abgeschlossen ist."
L["History"] = "Historie"
L["Clear All"] = "Alles löschen"
L["Clear all except last week"] = "Alles außer letzte Woche löschen"
L["Clear all except last month"] = "Alles außer letztem Monat löschen"
L["When"] = "Wann"
L["What"] = "Was"
L["Who"] = "Wer"
L["How"] = "Wie"
L["Disenchanted"] = "Entzaubert"
L["Bid: %s"] = "Gebot: %s"
L["Won Roll"] = "Hat Wurf gewonnen"
L["BoE assigned to ML"] = "BoE wurde PM zugeteilt"
L["Auto-assigned"] = "Automatisch zugeteilt"
L["can only add items when in a raid and you are the master looter."] = "Kann nur Items hinzufügen, wenn du in einem Raid und wenn du Plündermeister bist."
L["Note: player will need to pick item up manually."] = "Notiz: Spieler muss Item manuell aufnehmen."
L["User %s / %s lists"] = "Nutzer %s / %s Listen"
L["on"] = "auf"
L["not on"] = "nicht auf"
L["Other Announcements"] = "Andere Ankündigungen"
L["Announce Bid List Changes"] = "Gebotslisten-Änderungen ankündigen"
L["Announce Winners in Raid"] = "Gewinner im Raid verkünden"
L["Announce Bid Progression"] = "Gebotsfortschritt ankündigen"
L["Usage Message When Bids Open"] = "Verwende Nachricht, wenn Gebote eröffnet werden"
L["Usage Message When Rolls Open"] = "Verwende Nachricht, wenn Würfe eröffnet werden"
L["Announce Open Roll Countdown"] = "Wurf-Countdown ankündigen"
L["Announce Open Roll Ties"] = "Unentschiedene Würfe ankündigen"
L["Announce Bid / Roll Cancelation"] = "Gebot-/Wurf-Abbruch ankündigen"
L["Announce When No Successful Bids"] = "Ankündigen, wenn keine erfolgreichen Gebote vorhanden"
L["Hide Absent Members in Loot Lists"] = "Abwesende Mitglieder in der Loot-Liste verstecken"
L["Enable Off-spec (101-200) Rolls"] = "Aktiviere Off-Spec (101-200) Würfeln"
L["Enable Suicide Rolls by Default"] = "Aktiviere Suicide-Würfeln als Standard"
L["Recover Configuration"] = "Konfiguration wiederherstellen"
L["waiting for recovery reply from %s. Do not use KSK until recovery is complete."] = "Warte auf die Antwort von %s. Benutze KSK nicht bevor es vollständig wiederhergestellt wurde."
L["recovery from user %s complete."] = "Wiederherstellung von Nutzer %s ist fertig."
L["Use Guild Rank Priorities"] = "Benutze Gildenrang-Prioritäten"
L["Edit"] = "Bearbeiten"
L["Edit Rank Priorities"] = "Gildenrang-Prioritäten bearbeiten"
L["Priority"] = "Priorität"
L["Add Missing Members"] = "Fehlende Mitglieder hinzufügen"
L["Add Missing Raid Members"] = "Fehlende Raid Mitglieder hinzufügen"
L["Add All Missing Members"] = "Alle fehlenden Mitglieder hinzufügen"
L["added %s to list %q at position %s."] = "%s wurde zur Liste %q auf Position %s hinzugefügt."
L["Export Loot History"] = "Exportiere Loot-Historie"
L["Undo"] = "Rückgängig"
L["Are you absolutely sure you want to undo this suicide?"] = "Bist du sicher, dass du diesen 'Suicide' rückgängig machen willst?"
L["User"] = "Nutzer"
L["List"] = "Liste"
L["Item"] = "Item"
L["Minimum Level"] = "Minimum-Level"
L["Roll (main)"] = "Wurf (MainSpec)"
L["Roll (offspec)"] = "Wurf (OffSpec)"
L["Cancel Roll"] = "Wurf Abbrechen"
L["Bid / Roll Threshold"] = "Gebots/Würfel-Schwelle"
L["Auto-disenchant Items Below Threshold"] = "Auto-Entzaubern von Itmes unterhalb Schwelle"
L["Auto-assign to Enchanter"] = "Auto-Zuweisung zu Entzauberer"
L["Auto-assign to Master Looter"] = "Auto-Zuweisung zu Plündermeister"
L["Raiders Not on Current List"] = "Raidmitglieder nicht auf aktueller Liste"
L["users not on the %q list: %s"] = "Nutzer nicht auf der %q - Liste: %s"
L["User Search"] = "Nutzer-Suche"
L["Edit Officer Ranks"] = "Edit Officer Ranks"
L["Set Guild Officer Ranks"] = "Set Guild Officer Ranks"

--
-- Tooltip text.
--
L["TIP001"] = "Aktiviere diese Option, um das KSK Loot-Fenster automatisch zu öffnen, wenn du einen Leichnam plünderst, der ein gültiges Item enthält."
L["TIP002"] = "Bei Aktivierung wird KSK dem Raid verkünden, wer geboten hat und wer aktuell der höchste Bieter ist. Das Abschalten dieser Option verhindert diese Meldungen."
L["TIP003"] = "Aktiviere diese Option für die Anzeige des Item-Tooltipps wenn die Maus über einen Eintrag in der Loot-Liste geführt wird."
L["TIP004"] = "Aktiviere diese Option, um geflüsterte eingehende Gebote bzw. die meisten ausgehenden Gebote und Warnungen zu verstecken. Das reduziert die Gefahr, reale Gebote zu verpassen."
L["TIP005"] = "Bei Aktivierung wird aufgezeichnet, wer wann und warum welchen Loot erhalten hat. Ist es deaktiviert, zeigt die Loot-Historie nur die Items von anderen Administratoren an, die diese Option nicht deaktiviert haben."
L["TIP006"] = "Wähle aus, wie KSK den Loot verkünden soll, wenn welcher existiert."
L["TIP006.1"] = "Keine Verkündung des Loots, der in einem Leichnam/einer Truhe gefunden wurde."
L["TIP006.2"] = "Verkünde im Gilden-Chat den Loot, der in einem Leichnam/einer Truhe gefunden wurde."
L["TIP006.3"] = "Verkünde im Raid-Chat den Loot, der in einem Leichnam/einer Truhe gefunden wurde."
L["TIP007"] = "Legt fest, welche Nachrichten KSK an den Raid oder die Gilde während des Loot-Prozesses sendet."
L["TIP007.1"] = "Sende eine Nachricht an den Raid, wenn der Plündermeister die Liste wechselt auf die aktuell geboten wird."
L["TIP007.2"] = "Sende eine Nachricht an den Raid, wenn ein gewinnendes Gebot erhalten und das Bieten geschlossen wurde."
L["TIP007.3"] = "Sende eine Nachricht an die Gilde, wenn ein gewinnendes Gebot erhalten und das Bieten geschlossen wurde. Dies gilt nur für Gilden-Konfigurationen. PUG-Konfigurationen werden nie im Gilden-Chat etwas verkünden."
L["TIP007.4"] = "Sende eine Nachricht immer dann, wenn ein neues Gebot eingegangen ist oder ein Gebot zurück gezogen wurde, zusammen mit dem aktuell Meistbietenden. Dies wird nicht gesendet, wenn stille Gebote aktiviert sind."
L["TIP007.5"] = "Wenn die Gebote geöffnet sind, sende eine Nachricht an die Bieter, wie sie Gebote abgeben und zurück nehmen oder wie sie ihre aktuelle Listen-Position erfahren können."
L["TIP007.6"] = "Wenn das Würfeln für ein Item eröffnet ist, sende eine Nachricht an die Bieter, wie sie auf Main-Spec und Off-Spec würfeln können."
L["TIP007.7"] = "Wenn das Würfeln für ein Item eröffnet ist, wird ein Countdown angezeigt wann das Würfeln beendet ist und wenn ein Wurf zu spät eingegangen ist."
L["TIP007.8"] = "Wenn das Würfeln für ein Item eröffnet ist und es mehrere Bieter mit gleichem Wurf gibt, wird der Gleichstand verkündet und die betreffenden Bieter gebeten, erneut zu würfeln."
L["TIP007.9"] = "Sende eine Nachricht, wenn der Plündermeister das Bieten oder Würfeln abbricht."
L["TIP007.10"] = "Wenn keine erfolgreichen Gebote auf ein Item vorhanden sind, wird dem Raid verkündet, dass dieses Item entzaubert wird."
L["TIP007.11"] = "Beim Wechsel einer Liste oder Beginn des Lootens wird eine Auflistung aller aktuellen Raidmitglieder angezeigt, die NICHT auf der ausgewählten Liste sind."
L["TIP008"] = "Setzt die Dauer, wie lange auf eingehende Würfe gewartet wird, bevor der Sieger ermittelt wird. Wenn es gestartet ist, kannst du das Würfeln anhalten oder beenden."
L["TIP009"] = "Setzt die Anzahl der Sekunden, die den Würfel-Timer verlängern, wenn ein Wurf in den letzten 5 Sekunden des Countdowns eingegangen ist."
L["TIP010"] = "Wählt die Liste als Standard aus (wenn vorhanden). Wenn deaktiviert, wird für das Item automatisch die Liste benutzt, die im Item-Editor ausgewählt ist."
L["TIP011"] = "Wenn keine Gildenrang-Prioritäten benutzt werden, wird der Standard-Rang zum Beginn des Bieten gesetzt."
L["TIP012"] = "Wenn aktiviert, werden im Loot-Fenster alle Nutzer versteckt, die nicht im Raid sind. Dies hat keinen Effekt auf die Mitglieder im Listen-Manager, welcher immer alle Mitglieder für eine Würfel-Liste anzeigt. Die Aktivierung macht es leichter, zu sehen, welche Mitglieder aktuell im Raid sind und an welchen Positionen sie stehen."
L["TIP013"] = "Bei Aktivierung werden die Gildenrang-Prioritäten benutzt, die gewährleisten, dass ein Gildenmitglied mit einer höheren Rang-Priorität immer gegen ein Mitglied mit niedriger Priorität gewinnt, auch wenn dieses eine höhere Listen-Position hat."
L["TIP014"] = "Drücke diesen Button, um den Gildenrang-Prioritäten-Editor zu öffnen, welcher dir erlaubt, die Prioritäten für jeden Rang zu setzen."
L["TIP015"] = "Wenn aktiviert und ein Item, das BoE ist, erhält keine Gebote, wird das Item dem Plündermeister zugewiesen."
L["TIP016"] = "Wenn aktiviert und ein Item erhält keine Gebote, wird versucht, es über Würfeln zu verteilen."
L["TIP017"] = "Wenn aktiviert und ein Item erhält keine Gebote bzw. niemand würfelt dafür und ein zugewiesener Verzauberer ist dabei, wird ihm das Item zum Entzaubern übergeben."
L["TIP018"] = "Klicken, um einen Verzauberer aus der Liste der verfügbaren und nicht zugeordneten Verzauberer auszuwählen. Du bestimmst einen Nutzer als Verzauberer im Nutzer-Editor."
L["TIP019"] = "Klicken, um eine neue Konfiguration zu erstellen."
L["TIP020"] = "Klicken, um die aktuell ausgewählte Konfiguration zu löschen."
L["TIP021"] = "Klicken, um die aktuell ausgewählte Konfiguration umzubenennen."
L["TIP022"] = "Klicken, um eine Kopie der aktuell ausgewählte Konfiguration mit seinen Optionen als neue Konfiguration zu erstellen."
L["TIP023"] = "Gib den Namen des Nutzers ein (er muss bereits in der Nutzer-Liste existieren), der der Besitzer der neuen Konfiguration ist."
L["TIP024"] = "Wenn aktiviert und ein Nutzer ist als Twink eines anderen Nutzers markiert, dann haben der Main und alle Twinks die gleiche Position in allen Würfel-Listen. Wenn deaktiviert, sind Main und Twinks komplett unabhängig."
L["TIP025"] = "Wähle den Konfigurationstyp aus. Eine Gilden-Konfiguration wird synchronisiert durch den Gilden-Addon-Channel, während eine PUG-Konfiguration nur im aktuellen Raid synchronisiert und gesendet wird."
L["TIP026"] = "Drücke, um einen Co-Admin der Liste hinzuzufügen."
L["TIP027"] = "Drücke, um den aktuell ausgewählten Co-Admin zu löschen."
L["TIP028.0"] = "Konfigurationsauswahl"
L["TIP028.1"] = "Wähle die Konfiguration aus, um sie zu aktivieren. Konfigurationen, bei denen du Besitzer oder Administrator bist, sind |cff00ff00grün|r, alle anderen sind |cffffffffweiss|r."
L["TIP029"] = "Klicken, um eine Nachricht an den Raid zu senden, die alle aktuellen Raidmitglieder mit ihrer Position in der Liste anzeigt. Wenn Du den Nachrichtenfilter aktiviert hast, wirst Du die Nachricht nicht sehen, aber sie wird trotzdem an den Raid gesendet. Mit Shift-Klick wird es im Gilden-Chat anstatt im Raid-Chat (standard) verkündet."
L["TIP030"] = "Klicken, um einen Nutzer in die Liste einzufügen, entweder an das Ende oder eine zufällige Position. Der Nutzer muss im Nutzer-Editor angelegt sein. Nur Nutzer, die nicht bereits in der Liste sind, werden im Popup angezeigt."
L["TIP031"] = "Klicken, um den aktuell ausgewählten Nutzer zu löschen."
L["TIP032"] = "Klicken, um den Nutzer an den Anfang der Liste zu setzen."
L["TIP033"] = "Klicken, um den Nutzer eine Position höher in der Liste zu setzen."
L["TIP034"] = "Klicken, um den Nutzer eine Position tiefer in der Liste zu setzen."
L["TIP035"] = "Klicken, um den Nutzer an das Ende der Liste zu setzen. Wenn du in einem Raid bist, wird der Nutzer an die niedrigste Position gesetzt, die ein aktuelles Raid-Mitglied besetzt hat. Wenn der Nutzer bereits auf dieser Position ist, wird er an das Ende der gesamten Liste gesetzt. Wenn du nicht in einem Raid bist, wird der Nutzer immer an das Ende der gesamten Liste gesetzt."
L["TIP036"] = "Klicken, um einen Nutzer als 'Reserve' zu markieren. Reserve-Nutzer werden behandelt, als wären sie im Raid, auch wenn sie offline oder nicht aktuell in der Raid-Gruppe sind. Im Normalfall wird es gesetzt für Nutzer, die nicht in der Raidgruppe sind, sodass sie questen können, während sie bereit sind, bei Bedarf in den Raid zu kommen (Ersatz)."
L["TIP037"] = "Legt die Sortierfolge für die Liste fest, um die Reihenfolge, wie die Listen angezeigt werden, zu kontrollieren. Listen werden von der niedrigsten zum höchsten Zahl und zwei Listen mit der gleichen Sortierung in alphabetischer Reihenfolge sortiert."
L["TIP038"] = "Legt den Wert für den Standard-Gildenrang-Filter fest, wenn die Liste ausgewählt ist. Alles was nicht 'None' ist, überschreibt die allgemeinen Standard-Gildenrang-Einstellungen. Allerdings überschreiben item-spezifische Einstellungen diese Einstellung."
L["TIP039"] = "Legt eine strenge Rüstungsklassen-Filterung fest. Dies weist Gebote zurück für Items, die nicht der höchsten Rüstungsklasse entsprechen. Zum Beispiel wäre es einem Druiden verboten, auf ein Stoff-Item zu bieten, weil Druiden Leder tragen können."
L["TIP040"] = "Legt eine strenge Rollen-Filterung fest. Dies setzt voraus, dass die Rollen für alle Nutzer (Tank, Heiler, Melee DPS etc) definiert sind und dass der Plündermeister den Rollen-Filter für das Item vor dem Start der Gebotsabgaben aktiviert hat. Alle Nutzer, die nicht die entsprechende Rolle haben, können keine Gebote abgeben."
L["TIP041"] = "Wenn du willst, dass ein siegreiches Gebot den Nutzer auch auf einer zusätzlichen Liste 'suicided', wähle diese Liste hier aus. Dies ist nützlich, wenn deine Gildenpolitik den 'Suicide' eines Nutzers auf einer normalen Liste vorschreibt, wenn er ein Tier-Item auf der Tier-Liste erhält."
L["TIP042"] = "Klicken, um die Änderungen an dieser Liste zu speichern. Bis die Liste aktualisiert ist, haben alle Änderungen, die auf diesem Bildschirm gemacht werden, keinen Effekt."
L["TIP043"] = "Erzeugt eine neue leere Würfel-Liste."
L["TIP044"] = "Löscht die aktuell ausgewählte Liste."
L["TIP045"] = "Benennt die aktuell ausgewählte Liste um."
L["TIP046"] = "Kopiert die aktuell ausgewählte Liste in eine neue Liste unter Beibehaltung der aktuellen Nutzer-Positionen."
L["TIP047"] = "Importiert Nutzer in diese Liste von verschiedenen Quellen, z.B. SK-Listen, Gilde oder eine CSV-Datei."
L["TIP048"] = "Exportiert entweder diese oder alle Listen im XML- oder CSV- oder BBcode-Format, möglicherweise zum Hochladen auf eine Website."
L["TIP049"] = "Fügt entweder Nutzer, die im Raid sind, aber nicht in der Liste oder alle Nutzer aus der Nutzer-Datenbank, die nicht in der Liste sind, ein."
L["TIP050"] = "Diese exportierte Zeichenkette kann kopiert (Strg+C) werden und in deine Webseite oder eine andere Anwendung, die du benutzt, um die Loot-Historie anzuzeigen, eingefügt (Strg+V) werden."
L["TIP051"] = "Wählt die Gildenrang-Schwelle (falls vorhanden) aus. Allen Gildenmitgliedern, die unter diesem Rang sind, ist es nicht erlaubt, zu bieten oder zu würfeln für ein Item. Du kannst auch rechts den kleinen '-' Button klicken, um den Rang automatisch um eine Stufe zu verringern, wenn es keine Bieter im aktuellen Rang gibt."
L["TIP052.0"] = "Start und Ende Bieten / Ende Würfeln"
L["TIP052"] = "Klicken, um das Bieten für das aktuell ausgewählte Item zu starten oder das Bieten zu beenden, wenn es schon läuft. Abhängig von den Optionen die im Loot-Verteilungsfenster  ausgewählt waren, kann das Ende des Bietens durch den Start des Würfelns oder eine Zuweisung an einen Verzauberer erfolgen. Wenn ein Würfeln stattfindet, wird es beendet durch einen aktuellen Gewinner (falls vorhanden), wenn ein langer Countdown-Timer eingestellt ist."
L["TIP053.0"] = "Start Würfeln / Pause Würfeln"
L["TIP053"] = "Klicken, um das Würfeln zu starten, oder den Count-Down-Timer zu pausieren, wenn das Würfeln bereits läuft. Wenn du die Shift-Taste festhältst, wenn du diesen Knopf zum Start des Würfeln drückst, wird ein 'Suicide Würfeln' gestartet, wo der Sieger 'suicided' wird auf der aktuellen Liste."
L["TIP054.0"] = "Entfernen / Abbrechen"
L["TIP054"] = "Klicken, um ein Item aus der item-Liste zu entfernen oder ein laufendes Bieten bzw. Würfeln abzubrechen."
L["TIP055.0"] = "Gebot / Rücknahme"
L["TIP055"] = "Klicken, um ein eigenes Gebot auf ein Item abzugeben oder zurückzuziehen."
L["TIP056"] = "Klicken, um eine Nutzer zu zwingen, auf ein Item zu bieten. Der Nutzer muss aus der Mitglieder-Liste links ausgewählt werden."
L["TIP057"] = "Klicken, um einen Benutzer zu zwingen, ein Gebot zurückzunehmen. Sie müssen den aktuellen Bieter aus der Bieter-Liste ausgewählt haben."
L["TIP058"] = "Rückgängigmachen des letzten Bietens. Mehr als 1 Item kann auf diese Weise rückgängig gemacht werden. Wenn du deine Benutzeroberfläche neu lädst oder das Spiel neu startest, gehen alle rückgängig gemachten Informationen verloren. Es wird nach einer Bestätigung gefragt und es werden die Position und die Liste, die betroffen sind, angezeigt. Du kannst viele Gebote rückgängig zu machen, aber nur in umgekehrter Reihenfolge."
L["TIP059"] = "Wähle dies, damit ein Item durch KSK ignoriert wird. Wenn ein Item ignoriert wird, wird es - auch wenn es sich in einem Leichnam / einer Truhe befindet - nicht in der Loot-Liste angezeigt. Es muss manuell eingeordnet werden."
L["TIP060"] = "Setzt die Liste, die standardmäßig ausgewählt wird, wenn ein Item im Loot-Fenster angeklickt wird. Wenn du eine allgemeine Standard-Liste ausgewählt hast, wird das Setzen dieses Wertes den Standard überschreiben."
L["TIP061"] = "Setzt den Rang-Filter für das Item. Dies überschreibt den allgemeinen Standard-Rang. Wenn du Listen wechselst, nachdem ein Item ausgewählt wurde, kann sich der initialisierte Rang-Filter ändern, wenn die von dir ausgewählte Liste auch einen Standard-Rang-Filter besitzt."
L["TIP062"] = "Wähle dies, um sicher zu stellen, dass ein Item an einen bestimmten Nutzer zugewiesen wird, wenn es das nächste Mal fällt. Dazu musst du den Nutzer auswählen und du kannst entscheiden, ob die automatische Zuweisung nur einmal passiert oder jedes Mal. Du kannst auch entscheiden, ob der Nutzer bei der Zuweisung des Items auf einer gewählten Liste 'suicided' wird."
L["TIP063"] = "Klicken, um einen Nutzer auszuwählen, der das Item beim nächsten Drop erhalten soll."
L["TIP064"] = "Wähle diese Option, wenn diese Auto-Zuordnungsaufzeichnung automatisch aus der Artikel-Datenbank entfernt werden soll, wenn das Item das nächste Mal fällt und dem Nutzer zugewiesen wird. Du kannst dies auswählen für eine einmalige Zuweisung. Wenn dieses Item ein zu sammelndes Item ist, zum Beispiel ein Fragment für eine Waffe, kannst du auch die Zuweisung solcher Item-Drops an den Nutzer deaktivieren."
L["TIP065"] = "Setzt in der Liste (falls vorhanden), dass der Nutzer 'suicided' wird, wenn er ein Item durch automatische Zuweisung erhält."
L["TIP066"] = "Klicken, um ein Item aus der Item-Datenbank zu löschen."
L["TIP067"] = "Löscht die gesamte Loot-Historie. Beachte, dass nur deine lokale Loot-Historie gelöscht wird, es hat keine Auswirkung auf Historien anderer Administratoren."
L["TIP068"] = "Löscht die gesamte Loot-Historie mit Ausnahme der letzten 7 Tage. Beachte, dass nur deine lokale Loot-Historie gelöscht wird, es hat keine Auswirkung auf Historien anderer Administratoren."
L["TIP069"] = "Löscht die gesamte Loot-Historie mit Ausnahme des letzten Monat. Beachte, dass nur deine lokale Loot-Historie gelöscht wird, es hat keine Auswirkung auf Historien anderer Administratoren."
L["TIP070"] = "Klicken, um die Loot-Historie als XML-Zeichenkette zu exportieren, möglicherweise zum Hochladen auf eine Website."
L["TIP071"] = "Wähle aus, welche Rolle der Nutzer im Raid / in der Gilde spielt. Dies wird benutzt, um einen Filter zu setzten, um Nutzer beim Bieten zu beschränken, wenn sie eine bestimmte Rolle haben. Dieser Fall tritt ein, wenn ein Item für mehr als einen Spielertyp sinnvoll ist. Zum Beispiel kannst du entscheiden, dass ein Item besser für Heiler ist, auch wenn es Spellcaster ebenfalls wollen."
L["TIP072"] = "Gib den Namen des Nutzers ein. Er muss genau mit seinem Charakternamen übereinstimmen."
L["TIP073"] = "Wähle die Klasse des Nutzers aus. Du musst die richtige Klasse zuweisen, damit die Klassenfilter richtig funktionieren."
L["TIP074"] = "Wähle das Mindest-Level, um einen Nutzer zu akzeptieren. Alle Gildenmitglieder unter diesem Level werden nicht importiert."
L["TIP075"] = "Wähle dies, wenn der Nutzer ein Verzauberer ist. Nutzer, die als Verzauberer gekennzeichnet sind, können im Loot-Konfigurationsfenster als Entzauberer für den Raid ausgewählt werden."
L["TIP076"] = "Wähle dies, wenn ein Nutzer ein Twink eines anderen Nutzers ist. Das ist sinnvoll, wenn die Twinks mit dem Main-Nutzer verbunden werden sollen, da sie dann den gleichen Platz in allen listen belegen wie der Main. Ist die Anbindung deaktiviert, werden die Twinks unabhängig von den Mains behandelt."
L["TIP077"] = "Klicken, um dem Main-Charakter eines Nutzers auszuwählen. Nur Nutzer, die keine Twinks von anderen Nutzern sind, werden im Popup angezeigt."
L["TIP078"] = "Wähle dies, um einen Nutzer auf seinem Platz einzufrieren. Das ist sinnvoll, wenn der Nutzer für einen Weile offline ist. Ein eingefrorener Nutzer behält seine aktuelle Position in allen Listen, die anderen Nutzer werden ihn überspringen, wenn ein 'Suicide' auf der Liste stattfindet."
L["TIP080"] = "Klicken, um alle Änderungen für den Nutzer permanent zu übernehmen. Vorher werden keinen Änderungen am Nutzerprofil wirksam."
L["TIP081"] = "Klicken, um einen neuen Nutzer zu erstellen."
L["TIP082"] = "Klicken, um den ausgewählten Nutzer zu löschen und von allen Wurf-Listen zu entfernen. Du wirst nach einer Bestätigung gefragt. Wenn der Nutzer ein Main von verschiedenen Charakteren ist, bekommst du die Möglichkeit, auch alles seine Twinks zu löschen."
L["TIP083"] = "Klicken, um einen Nutzer umzubenennen. Sinnvoll, um Tippfehler zu korrigieren oder wenn ein Nutzer seinen Namen geändert hat."
L["TIP084"] = "Klicken, um Nutzer aus der Gilde zu importieren."
L["TIP086"] = "Klicken, um Nutzer hinzuzufügen, die im aktuellen Raid sind, aber nicht in der Nutzer-Liste."
L["TIP087"] = "Klicken, um die Informationen mit dem ausgewählten Benutzer zu synchronisieren. Der Nutzer muss online sein."
L["TIP088"] = "Klicken, um die Informationen mit allen Administratoren, die aktuell online sind, zu synchronisieren. Wenn dies eine  Gilden-Konfiguration ist, wird die Anfrage an die Gilde gesendet. Ist es eine PUG-Konfiguration, wird die Anfrage an den Raid gesendet. Alle Gilden- oder Raidmitglieder, die auch Administratoren sind, werden dann diese Anfrage beantworten und die Daten synchronisieren."
L["TIP089"] = "Klicken, um die aktuelle Konfiguration an die Gilde oder den Raid, abhängig von Konfigurationstyp, zu senden. Dies erzeugt einen hohen Datenverkehr, es wird empfohlen, dies nur zu tun, wenn der Raid vollständig aufgestellt ist."
L["TIP090"] = "Als Besitzer der Konfiguration kann du dies klicken, um deine Konfiguration von einem anderen Administrator wieder herstellen zu können. Das kann der Fall sein, wenn deine ganzen Daten verloren gegangen sind, z.B. nach einem Crash."
L["TIP091"] = "Entfernt die Würfe aus der Liste. Ein Nutzer kann seinen Wurf durch die Eingabe von '/roll 1-1' rückgängig machen, aber es gibt dem Plündermeister die Möglichkeit einen Nutzer aus der aktuellen Wurf-Runde manuell zu löschen."
L["TIP092"] = "Aktiviere dies, damit der Würfel-Manager zwischen Main-Spec (1-100) und Off-Spec (101-200) unterscheidet. Wenn es deaktiviert ist, und ein Nutzer benutzt '/roll 101-200' wird das ignoriert."
L["TIP093"] = "Wenn diese Option gesetzt ist, dann wird der 'Würfel-Button' im Loot-Verteilungsfenster ein 'suicide'-Würfeln (das den Gewinner in der aktuellen Liste 'suicided'). Um dies zu verhindern, kann man die Shift-Taste zusätzlich drücken. Wenn nicht aktiviert, wird standardmäßig ohne 'Suicide' gewürfelt und bei Shift-Klick mit 'Suicide'."
L["TIP094"] = "Sendet die geordnete Liste der Mitglieder für die Würfel-Liste an den Raid. Im Gegensatz zum 'Verkünden'-Button, der nur die aktuellen Raidmitglieder auflistet, wird hier die gesamte Liste ohne raid-relative Positionen gesendet. Wird die Shift-Taste gedrückt, wird die Liste an die Gilde statt an den Raid gesendet."
L["TIP095"] = "Setzt das Minimum-Item-Level, welches für Gebote / Würfe verfügbar ist. Wenn es größer als das Plündermeister-Level gesetzt ist, werden alle Items unter diese Marke automatisch entzaubert. Wenn dem so ist, dann überprüfe die nächste Option." 
L["TIP096"] = "Wenn du eine Item-Level-Marke für Gebote gesetzt hast und sie ist höher als die Plündermeister-Marke, aktiviere diese Option, um alle Items unterhalb dieser Marke automatisch an den Entzauberer zu senden. Wenn kein Entzauberer vorhanden ist, wird das Item dem Plündermeister zugewiesen."
L["TIP097"] = "Aktiviere diese Option, um das Item automatisch an den Entzauberer zu senden und nicht zum Bieten / Würfeln zuzulassen. Wenn kein Entzauberer vorhanden ist, wird das Item dem Plündermeister zugewiesen."
L["TIP098"] = "Aktiviere diese Option, um das Item automatisch an den Plündermeister zu senden und nicht zum Bieten / Würfeln zuzulassen."
L["TIP099"] = "Gib den Namen des Nutzers ein, den Du suchen willst. Dies kann auch nur ein Teil des Nutzer-Namens sein. Der erste gefundenen Nutzer wird hervorgehoben und ausgewählt."
L["TIP100"] = "Mark which guild ranks are officer ranks. Only officers will be permitted to broadcast configs to the entire guild."

--
-- Shared Konfer dialog. These strings are used by all Konfer addons.
--
L["KONFER_SEL_TITLE"] = "Auswahl des aktiven %s Konfer-Moduls"
L["KONFER_SEL_HEADER"] = "Du hast %s Konfer-Module installiert und mehr als eines von ihnen ist aktiv und eingestellt auf automatisches Öffnen, wenn ein Leichnam oder eine Kiste/Truhe geplündert wird. Dies kann Konflikte verursachen, du solltest eines der Module als aktives auswählen. Alle anderen werden dann ausgeschlossen."
L["KONFER_SEL_DDTITLE"] = "Modul-Auswahl zum Aktivieren"
L["KONFER_ACTIVE"] = "aktiv"
L["KONFER_SUSPENDED"] = "ausgeschlossen"
L["KONFER_SUSPEND_OTHERS"] = "Du hast das %s Konfer-Modul gerade aktiviert, aber andere Konfer-Module sind ebenfalls aktiv. Mehrere Module zur selben Zeit aktiv zu haben, kann Probleme verursachen, besonders wenn mehr als eins sich beim Looten automatisch öffnet. Es wird empfohlen, die anderen Module zu deaktivieren. Wenn du dies tun willst und nur das ausgewählte aktivieren willst, drücke den 'OK'-Button. Wenn du sicher bist, dass mehrere Konfer-Module laufen sollen, dann drücke 'Abbrechen'."
