local addonName = "Killicon"
local db
local frame

-- Icono OFICIAL de Legion 7.3.5 → la daga plateada exacta que pediste
local swordTex = [[Interface\TargetingFrame\UI-TargetingFrame-Skull]]

local function GetNamePlates()
    if C_NamePlate and C_NamePlate.GetNamePlates then
        return C_NamePlate.GetNamePlates()
    else
        local plates = {}
        for i = 1, 64 do
            local p = _G["NamePlate" .. i]
            if p and p:IsShown() then
                tinsert(plates, p)
            end
        end
        return plates
    end
end

local function UpdateNameplate(plate)
    local hb = plate.healthBar or (plate.UnitFrame and plate.UnitFrame.healthBar)
    if not hb or not hb:IsShown() then
        if plate.killIcon then plate.killIcon:Hide() end
        return
    end

    local r, g, b = hb:GetStatusBarColor()
    local isEnemy = r > 0.3 and g < 0.6   -- rojo/naranja → enemigo

    local icon = plate.killIcon
    if not icon then
        icon = plate:CreateTexture(nil, "OVERLAY", nil, 7)
        icon:SetTexture(swordTex)
        icon:SetSize(20, 20)                     -- tamaño perfecto
        icon:SetPoint("RIGHT", hb, "LEFT", -6, 0) -- posición idéntica a la original de Legion
        icon:SetTexCoord(0.1, 0.9, 0.1, 0.9)       -- recorta un poco los bordes para que quede más limpia
        plate.killIcon = icon
    end

    if db.enabled and isEnemy then
        icon:Show()
    else
        icon:Hide()
    end
end

local function UpdateAll()
    for _, plate in ipairs(GetNamePlates()) do
        UpdateNameplate(plate)
    end
end

local function Toggle()
    db.enabled = not db.enabled
    if not db.enabled then
        for _, plate in ipairs(GetNamePlates()) do
            if plate.killIcon then plate.killIcon:Hide() end
        end
    else
        UpdateAll()
    end
end

frame = CreateFrame("Frame", nil, UIParent)
frame.t = 0
frame:SetScript("OnUpdate", function(self, elapsed)
    self.t = self.t + elapsed
    if self.t > 0.1 then
        self.t = 0
        UpdateAll()
    end
end)

frame:RegisterEvent("ADDON_LOADED")
frame:RegisterEvent("PLAYER_LOGIN")
frame:SetScript("OnEvent", function(self, event, arg1)
    if event == "ADDON_LOADED" and arg1 == addonName then
        KilliconDB = KilliconDB or {enabled = true}
        db = KilliconDB
        self:UnregisterEvent("ADDON_LOADED")
    elseif event == "PLAYER_LOGIN" then
        C_Timer.After(2, UpdateAll)
        self:UnregisterEvent("PLAYER_LOGIN")
    end
end)

SLASH_KI1 = "/ki"
SLASH_KI2 = "/killicon"
SlashCmdList["KI"] = Toggle