-- localization file for Traditional Chinese
local L = LibStub("AceLocale-3.0"):NewLocale("KeystoneRunner", "zhTW")
if not L then return end

-- abbr. of dungeon names
L["DIDv7_197"] = "艾眼"
L["DIDv7_198"] = "暗心"
L["DIDv7_199"] = "玄鴉"
L["DIDv7_200"] = "英靈"
L["DIDv7_206"] = "奈薩"
L["DIDv7_207"] = "看守"
L["DIDv7_208"] = "靈喉"
L["DIDv7_209"] = "地道"
L["DIDv7_210"] = "眾星"
L["DIDv7_227"] = "卡下"
L["DIDv7_233"] = "永夜"
L["DIDv7_234"] = "卡上"
L["DIDv7_239"] = "三傑"

-- abbr. of classes
L["ABBR_HUNTER"] = "獵"
L["ABBR_WARLOCK"] = "術"
L["ABBR_PRIEST"] = "牧"
L["ABBR_PALADIN"] = "騎"
L["ABBR_MAGE"] = "法"
L["ABBR_ROGUE"] = "賊"
L["ABBR_DRUID"] = "德"
L["ABBR_SHAMAN"] = "薩"
L["ABBR_WARRIOR"] = "戰"
L["ABBR_DEATHKNIGHT"] = "DK"
L["ABBR_MONK"] = "僧"
L["ABBR_DEMONHUNTER"] = "DH"

local KSRPrefix = "<Keystone Runner> "
local KSRPrefixWColor = "|cFFFF7D0A<Keystone Runner>|r "
-- messages
L["msgHeadnote_new"] = KSRPrefix.."報告新鑰石："
L["msgHeadnote_all"] = KSRPrefix.."報告所有鑰石："
L["msgListEmpty"] = " · 目前沒有任何鑰石被記錄下來哦。"
L["msgDespFullAutoReply"] = KSRPrefix.."發現關鍵字「%s」並因此自動發送了鑰石列表。"
L["msgWeeklyCleanup"] = KSRPrefixWColor.."新的一週開始了，上週的數據已經清除。"
L["msgWeeklyBest"] = "<保底%s>"
L["msgLogSum"] = "找到了 %s 條M+挑戰日誌 <<"
L["msgLogEmpty"] = " · 目前沒有任何M+挑戰被記錄下來哦。"
L["msgLogEntryBody"] = "%s %s(+%s) { %s } 耗時：%s 鑰石升級：+%s"
-- review mark
L["msgSelfDesp"] = KSRPrefixWColor.."快捷組建你的地城挑戰隊伍：搜尋Battle.net好友并和他們互通鑰石信息。"
L["msgSearchBoxHint"] = "連按兩下Ctrl鍵"
L["msgUsageDetail"] = "命令行：\n/ksr - 切換 Keystone Runner 視窗的顯示\n/ksr p - 報告到小隊頻道\n/ksr g - 報告到公會頻道\n/ksr s - 報告到say頻道\n/ksr w [角色名字-伺服器] - 密語報告給特定角色\n/ksr w - 密語報告給上一個發來消息的玩家\n/ksr r - 報告給上一個發來的消息中包含特定關鍵詞（例如：鑰石）的玩家\n/ksr log - 查看大秘境日誌\n/ksr log <keyword1> <keyword2> ... - 以關鍵詞檢索大秘境日誌\n/ksr opt mythicautoreply - 切換大秘境自動回覆開關\n/ksr opt keyautoreply - 切換鑰石自動報告(#key)開關\n/ksr wipelog - 清除大秘境日誌\n/ksr clear - 清除所有數據"
L["msgCantSendMsg"] = KSRPrefixWColor.."沒有指定發送消息的目標"
L["msgNotInGroup"] = KSRPrefixWColor.."你現在不在隊伍中"
L["msgNotInGuild"] = KSRPrefixWColor.."你現在沒有公會"
L["msgMPlusDND"] = KSRPrefix.."%s 正在挑戰：%s(+%s)，擊殺首領：%s/%s，%s：%s，已耗時：%s。向我發送 %s 查看我的所有鑰石。<15分鐘之內不會再次自動回覆>"
L["msgHintSemiAutoReply"] = KSRPrefixWColor.."發現對話中提到了「%s」，使用 /ksr r 即可報告所有鑰石給「%s」。"
L["msgParty"] = "小隊"
L["msgToggleMPlusAutoReply"] = KSRPrefixWColor.."允許大秘境挑戰時自動回覆：%s"
L["msgToggleKeyAutoReply"] = KSRPrefixWColor.."允許自動回覆 #key 指令：%s"
L["msgUnknownOptCmd"] = KSRPrefixWColor.."無效的選項指令"
L["msgNoKeystone"] = "(沒有鑰石記錄)"
L["msgFriendStat_Updated"] = "更新于：%s%s"
L["msgFriendStat_NotPlayingWoW"] = "好友沒有在遊玩魔獸世界"
L["msgFriendStat_WFR"] = "...等待鑰石查詢消息返回"
L["msgFriendStat_NotInstalled"] = "好友沒有使用 Keystone Runner"
L["msgConfirmReportKeys"] = "發送我的鑰石列表給好友：\n\n"..FRIENDS_BNET_NAME_COLOR_CODE.."%s"..FONT_COLOR_CODE_CLOSE.."\n"
L["msgInviteSelFriend"] = KSRPrefixWColor.."邀請好友"..FRIENDS_BNET_NAME_COLOR_CODE.." %s "..FONT_COLOR_CODE_CLOSE.."加入隊伍"
L["msgSuggestInviteSelFriend"] = KSRPrefixWColor.."建議邀請好友"..FRIENDS_BNET_NAME_COLOR_CODE.." %s "..FONT_COLOR_CODE_CLOSE.."加入隊伍"
L["msgRequestInviteSelFriend"] = KSRPrefixWColor.."請求加入好友"..FRIENDS_BNET_NAME_COLOR_CODE.." %s "..FONT_COLOR_CODE_CLOSE.."的隊伍"

-- for components
L["strMyKeystones"] = "--- 我持有的鑰石 -----------------------------------"
L["tooltipWhisper"] = "悄悄話\n連按兩下 Alt 鍵發送悄悄話"
L["tooltipInvite"] = "邀請\n連按兩下 Insert 鍵邀請好友"
L["tooltipReportKeys"] = "發送鑰石列表給好友"
L["tooltipQueryKeys"] = "刷新好友的鑰石列表"
L["tooltipQueryDGInfo"] = "查看好友當前大秘境的進度"
L["strToggleFriendsFrame"] = "切換 Battle.net 好友窗口"
L["btnLabelBattlenetFriends"] = "Battle.net好友"
L["btnLabelMyKeystones"] = "我的鑰石"
L["btnLabelSendToParty"] = "發送到小隊"
L["btnLabelSendToGuild"] = "發送到公會"
L["btnLabelSendToSay"] = "白字「說」"
-- others
L["msgDontSpam"] = KSRPrefix.."這就是好奇的代價！(對你施放沈默)<短時間內無法再使用自動報告鑰石功能打擾我>"