KeystoneRollCall = LibStub('AceAddon-3.0'):NewAddon('KeystoneRollCall', 'AceEvent-3.0', 'AceConsole-3.0','AceTimer-3.0');
_G.KeystoneRollCall = KeystoneRollCall;
KeystoneRollCall.tabs = {}
KeystoneRollCall.AceGUI = LibStub('AceGUI-3.0');	
KeystoneRollCall.Registry = LibStub('AceConfigRegistry-3.0')
KeystoneRollCall.RealmsLib = LibStub('LibRealmInfo')
KeystoneRollCall.ScrollingTable = LibStub('ScrollingTable');
KeystoneRollCall.MAX_REWARD_LEVEL = 15;

local _,i
local MSG_PREFIX = "KRC-MSG"
local lastBagUpdate = 0;
local guildSynced, partySynced, raidSynced, instanceSynced, friendsSynced = false, false, false, false, false

KeystoneRollCall.sortFields = {{"name",true}}
KeystoneRollCall.version = GetAddOnMetadata("KeystoneRollCall", "Version");
KeystoneRollCall.newestVersionFound = KeystoneRollCall.version;
KeystoneRollCall.loaded = false;
KeystoneRollCall.initialLoaded = false;
KeystoneRollCall.runInProgress = false;

KeystoneRollCall.columnSort = function (table, rowa, rowb, sortbycol)
	local field = table.cols[sortbycol].field or table.cols[sortbycol].name:lower();
	local asc = table.cols[sortbycol].sort == "asc"
	local ka = KeystoneRollCall.tableData[rowa][1]
	local kb = KeystoneRollCall.tableData[rowb][1]
	
	if KeystoneRollCall.sortFields[1][1] == field then
		KeystoneRollCall.sortFields[1][2] = asc
	else
		for i = 2, #KeystoneRollCall.sortFields do
			if KeystoneRollCall.sortFields[i] and KeystoneRollCall.sortFields[i][1] == field then
				tremove(KeystoneRollCall.sortFields,i)
			end
		end
		tinsert(KeystoneRollCall.sortFields,1,{field,true})
	end
	
	return KeystoneRollCall:CompareKeystones(ka, kb);
end

function KeystoneRollCall:SuggestAddon(channel,target)
	ChatThrottleLib:SendChatMessage("BULK", MSG_PREFIX, KRCLocal:GetRandomSuggestion(), channel, "Common", target)
end

function KeystoneRollCall:DoSort()
	if not KeystoneRollCall.tableData then
		return
	end
	table.sort(KeystoneRollCall.tableData, function(ka,kb) 
		return self:CompareKeystones(ka[1],kb[1])
	end);
end

function KeystoneRollCall:getGroupChatChannel()
	if IsInGroup(LE_PARTY_CATEGORY_INSTANCE) then
		return "INSTANCE_CHAT";
	elseif UnitInRaid("player") then
		return "RAID";
	elseif IsInGroup() then
		return "PARTY";
	else
		return "SAY";
	end
end

function KeystoneRollCall:SendKeystone(requestSync,keystone,channel,target)
	if keystone then
		local msg = table.concat({requestSync, self:extractKeystone(keystone)}, ",") 
		if channel == "BNET" then
			ChatThrottleLib:BNSendGameData("BULK",MSG_PREFIX, msg, target)
		else
			ChatThrottleLib:SendAddonMessage("BULK",MSG_PREFIX, msg, channel, target)
		end
	end
end

function KeystoneRollCall:BroadcastKey(keystone,channel,target)
	ChatThrottleLib:SendChatMessage("BULK",MSG_PREFIX,self:keystoneToString(keystone), channel, "Common", target)
end

function KeystoneRollCall:BroadcastListedKeys(channel,target)
	self:DoSort()
	if not KeystoneRollCall.tableData or #KeystoneRollCall.tableData == 0 then
		print(KRCLocal:Get("no_keystone_broadcast"));
	else
		ChatThrottleLib:SendChatMessage("BULK",MSG_PREFIX,KRCLocal:Get("title").." (" .. #KeystoneRollCall.tableData .. "):",channel, "Common",target)
		for i,entry in ipairs(KeystoneRollCall.tableData) do
			if i > 25 then
				break;
			end
			ChatThrottleLib:SendChatMessage("BULK",MSG_PREFIX,"     " .. self:keystoneToString(entry[1]), channel, "Common", target)
		end
		if #KeystoneRollCall.tableData > 25 then
			ChatThrottleLib:SendChatMessage("BULK",MSG_PREFIX,KRCLocal:Get("title",#KeystoneRollCall.tableData-25), channel, "Common", target)
		end
	end	
end

function KeystoneRollCall:OnInitialize() 
	self:RegisterChatCommand("krc", "SlashCommand")
	self:RegisterSettings()
end

function KeystoneRollCall:SlashCommand(args)
	if args == "version" then
		print(KeystoneRollCall.version);
	else
		if not KeystoneRollCall.frame or not KeystoneRollCall.frame:IsVisible() then
			KeystoneRollCall:Show()
		end
	end
end

function KeystoneRollCall:SendAltKeystones(channel,target)
	local playerKeystone = self:getPlayerKeystone()
	for i, keystone in ipairs(KeystoneRollCall.db.global.keystones) do
		if playerKeystone.name ~= keystone.name and keystone.isPlayers then
			self:SendKeystone(0,keystone,channel,target)
		end
	end
end

function KeystoneRollCall:RequestKeystoneSync()		
	local keystone = self:getPlayerKeystone()
	local groupType = self:getGroupChatChannel()

	if groupType == "INSTANCE_CHAT" then
		self:SendKeystone(instanceSynced and "0" or "1",keystone,groupType)
		if not instanceSynced then
			self:SendAltKeystones(groupType)
		end
		instanceSynced = true
	elseif groupType == "RAID" then
		self:SendKeystone(raidSynced and "0" or "1",keystone,groupType)
		if not raidSynced then
			self:SendAltKeystones(groupType)
		end
		raidSynced = true
	elseif groupType == "PARTY" then
		self:SendKeystone(partySynced and "0" or "1",keystone,groupType)
		if not partySynced then
			self:SendAltKeystones(groupType)
		end
		partySynced = true
	end
	
	if  GetGuildInfo("player")  then
		self:SendKeystone(guildSynced and "0" or "1",keystone,"GUILD")
		if not guildSynced then
			self:SendAltKeystones("GUILD")
		end
		guildSynced = true
	end
	
	for i = 1, select(2, GetNumFriends()) do
		local fullName = GetFriendInfo(i)
		if not string.match(fullName, "-") then
			fullName = fullName .. "-" .. KeystoneRollCall.playerRealm;
		end
		
		self:SendKeystone(friendsSynced and "0" or "1",keystone,"WHISPER",fullName)
		if not friendsSynced then
			self:SendAltKeystones("WHISPER", fullName)
		end
	end
	
	if BNConnected()  then
		for i = 1, BNGetNumFriends() do
			local characterName, bnetIDGameAccount, client = select(5,BNGetFriendInfo(i))
			if bnetIDGameAccount and characterName and client == "WoW" then
				self:SendKeystone(friendsSynced and "0" or "1",keystone,"BNET", bnetIDGameAccount)
				if not friendsSynced then
					self:SendAltKeystones("BNET", bnetIDGameAccount)
				end
			end
		end
	end
	friendsSynced = true;
end

function KeystoneRollCall:AnnounceNewPlayerKeystone(keystone,oldKeystone)
	if keystone then
		local isNew = keystone.level and keystone.level > 0 and (not oldKeystone or keystone.level ~= oldKeystone.level or keystone.dungeon ~= oldKeystone.dungeon)
		if isNew then
			if KeystoneRollCall.db.global.printPlayerNewKey then
				print(KRCLocal:Get("announce_new_keystone_player").." +" ..  KeystoneRollCall:colorLevelDifficulty(keystone.level,keystone.level) .. " "..KeystoneRollCall:getDungeonName(keystone.dungeon) )
			end
			if KeystoneRollCall.db.global.partyPlayerNewKey and IsInGroup() then
				ChatThrottleLib:SendChatMessage("BULK",MSG_PREFIX, KRCLocal:Get("announce_new_keystone",UnitName("Player")).." +" .. keystone.level .. " " .. KeystoneRollCall:getDungeonName(keystone.dungeon), "PARTY", "Common")
			end
			if KeystoneRollCall.db.global.guildPlayerNewKey and GetGuildInfo("player") then
				ChatThrottleLib:SendChatMessage("BULK",MSG_PREFIX, KRCLocal:Get("announce_new_keystone",UnitName("Player")).." +" .. keystone.level .. " " .. KeystoneRollCall:getDungeonName(keystone.dungeon), "GUILD", "Common")
			end
		end
	end
end

function KeystoneRollCall:AnnounceNewPlayerBestRun(keystone,oldKeystone)
	if keystone then
		local isNewBest = keystone.bestLevel and keystone.bestLevel > 0 and (not oldKeystone or keystone.bestLevel > oldKeystone.bestLevel)
		if isNewBest then
			if KeystoneRollCall.db.global.printPlayerBestRun then
				print(KRCLocal:Get("announce_new_record_player").." +" .. keystone.bestLevel .. " "..KeystoneRollCall:getDungeonName(keystone.bestDungeon).."" )
			end
			if KeystoneRollCall.db.global.partyPlayerBestRun and IsInGroup() then
				ChatThrottleLib:SendChatMessage("BULK",MSG_PREFIX,KRCLocal:Get("announce_new_record",UnitName("Player")).." +" .. keystone.bestLevel .. " " .. KeystoneRollCall:getDungeonName(keystone.bestDungeon), "PARTY", "Common")
			end
			if KeystoneRollCall.db.global.guildPlayerBestRun and GetGuildInfo("player") then
				ChatThrottleLib:SendChatMessage("BULK",MSG_PREFIX,KRCLocal:Get("announce_new_record",UnitName("Player")).." +" .. keystone.bestLevel .. " " .. KeystoneRollCall:getDungeonName(keystone.bestDungeon), "GUILD", "Common")
			end
		end
	end
end

local function processAddonMessage(prefix,msg,channel,sender) 
	if prefix == MSG_PREFIX then
		if sender == KeystoneRollCall.playerName then
			return
		end
		local msgParts =  {strsplit(",",msg)};
		if msgParts[1] == "1" then
			for i, keystone in ipairs(KeystoneRollCall.db.global.keystones) do
				if keystone.isPlayers and keystone.level and keystone.level > 0 then
					KeystoneRollCall:SendKeystone(0,keystone,channel,sender)
				end
			end
		end
		tremove(msgParts,1)
		if channel == "BNET" then
			local characterName, _, realm = select(2,BNGetGameAccountInfo(sender));
			sender = characterName .. "-" .. realm;
		end
		local keystone, oldKeystone = KeystoneRollCall:buildKeystone(msgParts,sender)
		if keystone then		
			if KeystoneRollCall.db.global.printOthersBestRuns and keystone.bestLevel and keystone.bestLevel > 0 and (not oldKeystone or keystone.bestLevel > oldKeystone.bestLevel) then
				print(KRCLocal:Get("announce_new_record",KeystoneRollCall:colorClass(keystone.name,keystone.class)).." +" .. KeystoneRollCall:colorLevelDifficulty(keystone.bestLevel,keystone.bestLevel) .. " "..KeystoneRollCall:getDungeonName(keystone.bestDungeon).."" )
			end
		
			if KeystoneRollCall.db.global.printOthersNewKeys and keystone.level and keystone.level > 0 and (not oldKeystone or keystone.level ~= oldKeystone.level or keystone.dungeon ~= oldKeystone.dungeon) then
				print(KRCLocal:Get("announce_new_keystone",KeystoneRollCall:colorClass(keystone.name,keystone.class)).." +" ..  KeystoneRollCall:colorLevelDifficulty(keystone.level,keystone.level) .. " "..KeystoneRollCall:getDungeonName(keystone.dungeon) )
			end
			
			if keystone.version and tonumber(keystone.version) and tonumber(keystone.version) > tonumber(KeystoneRollCall.newestVersionFound) then
				KeystoneRollCall.newestVersionFound = keystone.version
				print(KRCLocal:Get("new_version_warning"))
			end
		end
	end
end

local function EventFunc(self, event, ...)
	if event == "PLAYER_LEAVING_WORLD" then
		KeystoneRollCall.loaded = false;
	elseif event == "PLAYER_LOGIN" then
		guildSynced, partySynced, raidSynced, instanceSynced, friendsSynced = false, false, false, false, false
		local name, realm = UnitFullName("player")
		KeystoneRollCall.playerName = name .."-" .. realm
		KeystoneRollCall.playerRealm = realm
		RegisterAddonMessagePrefix(MSG_PREFIX)
		KeystoneRollCall:PurgeExpiredKeystones()
	elseif event == "GROUP_JOINED" then
		partySynced, raidSynced, instanceSynced = false, false, false
		C_ChallengeMode.RequestMapInfo(); 
		C_ChallengeMode.RequestRewards();
	elseif event == "PLAYER_ENTERING_WORLD" or (event == "BAG_UPDATE" and KeystoneRollCall.loaded) then
		if event ~= "BAG_UPDATE" or lastBagUpdate ~= time() then
			lastBagUpdate = time() 
			C_ChallengeMode.RequestMapInfo();
			C_ChallengeMode.RequestRewards();
		end
	elseif event == "CHALLENGE_MODE_MAPS_UPDATE" or event == "CHALLENGE_MODE_NEW_RECORD" then
		if KeystoneRollCall.runInProgress then
			return
		end
	
		local keystone,oldKeystone = KeystoneRollCall:buildPlayerKeystone()
		if KeystoneRollCall.initialLoaded and keystone then
			guildSynced, partySynced, raidSynced, instanceSynced, friendsSynced = false, false, false, false, false
			KeystoneRollCall:AnnounceNewPlayerBestRun(keystone,oldKeystone)
			KeystoneRollCall:AnnounceNewPlayerKeystone(keystone,oldKeystone)
		end

		KeystoneRollCall.loaded = true;
		KeystoneRollCall.initialLoaded = true;
		
		KeystoneRollCall:RequestKeystoneSync()
	elseif event == "CHAT_MSG_ADDON" then
		processAddonMessage(...)
	elseif event == "BN_CHAT_MSG_ADDON" then
		local prefix, msg, _, sender = ...
		processAddonMessage(prefix, msg, "BNET", sender)
	elseif event == "CHALLENGE_MODE_RESET" or event == "CHALLENGE_MODE_COMPLETED" then
		KeystoneRollCall.runInProgress = false;
		C_ChallengeMode.RequestMapInfo();
		C_ChallengeMode.RequestRewards();
	elseif event == "CHALLENGE_MODE_START" then
		KeystoneRollCall.runInProgress = true;
		
		local dungeon = C_ChallengeMode.GetActiveChallengeMapID()
		local dungeonName = C_ChallengeMode.GetMapInfo(dungeon) 
		local level = C_ChallengeMode.GetActiveKeystoneInfo()

		if IsInGroup() and level and level > 0 and dungeonName then
			for i=1, 5 do
				local unit = "party"..i
				if UnitExists(unit) and not UnitIsUnit("player",unit) then
					local name = KeystoneRollCall:getFullName(unit)
					local data = KeystoneRollCall:getCharacterData(name)
					if not data.jointRuns then
						data.jointRuns = {};
					end
					local entry = {
						['level'] = level, 
						['dungeon'] = dungeon 
					}
					tinsert(data.jointRuns,1,entry)
				end
			end
		end
	end
end

local eventHandler = CreateFrame("Frame", nil, WorldFrame)
eventHandler:SetScript("OnEvent", EventFunc)
eventHandler:RegisterEvent("PLAYER_LEAVING_WORLD")
eventHandler:RegisterEvent("PLAYER_LOGIN")
eventHandler:RegisterEvent("PLAYER_ENTERING_WORLD")
eventHandler:RegisterEvent("CHALLENGE_MODE_NEW_RECORD")
eventHandler:RegisterEvent("GROUP_JOINED")
eventHandler:RegisterEvent("CHALLENGE_MODE_MAPS_UPDATE")
eventHandler:RegisterEvent("BAG_UPDATE")
eventHandler:RegisterEvent("CHAT_MSG_ADDON")
eventHandler:RegisterEvent("BN_CHAT_MSG_ADDON")
eventHandler:RegisterEvent("BN_FRIEND_TOON_ONLINE")
eventHandler:RegisterEvent("FRIENDLIST_UPDATE")
eventHandler:RegisterEvent("CHALLENGE_MODE_START")
eventHandler:RegisterEvent("CHALLENGE_MODE_RESET")
eventHandler:RegisterEvent("CHALLENGE_MODE_COMPLETED")