local tab = {}
tab.index = 200
tab.text = KRCLocal:Get("tab_group");
tab.value = "party";
tab.propertyShowComplete = "partyShowComplete";
tab.propertyShowAlts = "partyShowAlts";
tab.propertyShowKeyless = "partyShowKeyless";
tab.propertyShowOffline = "partyShowOffline";
tab.showFilterResultsEditBox = true;

local function addUnit(unit)
	if UnitExists(unit) and UnitIsPlayer(unit) and GetUnitName(unit, true) and UnitClass(unit) then
		local class = UnitClass(unit) or "Warrior"
		local role = UnitGroupRolesAssigned(unit) or ""

		local fullName = GetUnitName(unit, true)
		local nParts =  {strsplit("-",fullName or"")}
		if not nParts[2] or nParts[2] == "" then
			nParts[2] = KeystoneRollCall.playerRealm
			fullName = nParts[1] .. "-" .. KeystoneRollCall.playerRealm
		end

		local data  = KeystoneRollCall:getCharacterData(fullName)
		data.class = class
		data.level = UnitLevel(unit)
		data.name = fullName
		data.characterName = nParts[1]
		data.realm = nParts[2]
		data.race = UnitRace(unit)
		data.faction = UnitFactionGroup(unit) == "Alliance"


		local keystone = KeystoneRollCall:getKeystoneByUnit(unit)
		if not keystone then
			keystone = {['name'] =fullName,['class'] = class,dungeon = 0,level = 0,dummy=true}
		end
		KeystoneRollCall:AddListing(keystone,UnitIsConnected(unit));
	end
end

tab.populate = function()
	
	addUnit("player")
		
	if UnitInRaid("player") then
		for i = 1,40 do
			addUnit("raid"..i)
		end
	elseif IsInGroup() then
		for i = 1,5 do
			addUnit("party"..i)
		end
	end
end


KeystoneRollCall.tabs[tab.value] = tab;