local includeAlts, includeOffline, includeKeyless
local tab = {}
tab.index = 400
tab.text = KRCLocal:Get("tab_guild");
tab.value = "guild";
tab.propertyShowComplete = "guildShowComplete";
tab.propertyShowAlts = "guildShowAlts";
tab.propertyShowKeyless = "guildShowKeyless";
tab.propertyShowOffline = "guildShowOffline";
tab.showFilterResultsEditBox = true;

tab.populate = function()
	for i = 1, GetNumGuildMembers() do
		local fullName, rank, rankIndex, level, class, zone, note, officernote, online, status, classFileName, achievementPoints, achievementRank, isMobile, canSoR, reputation = GetGuildRosterInfo(i)
		local nameParts =  {strsplit("-",fullName)};
		
		local data  = KeystoneRollCall:getCharacterData(fullName)
		data.class = class
		data.level = level
		data.name = fullName
		data.characterName = nameParts[1]
		data.realm = nameParts[2]
		data.faction = UnitFactionGroup("player") == "Alliance"

		local keystone = KeystoneRollCall:getKeystone(fullName)
		if not keystone then
			keystone = {['name'] =fullName,['class'] = class,dungeon = 0,level = 0,dummy=true}
		end
		KeystoneRollCall:AddListing(keystone,online);
	end
end

KeystoneRollCall.tabs[tab.value] = tab;