local includeAlts, includeOffline, includeKeyless
local tab = {}
tab.index = 500
tab.text = KRCLocal:Get("tab_friends");
tab.value = "friends";
tab.propertyShowComplete = "friendsShowComplete";
tab.propertyShowAlts = "friendsShowAlts";
tab.propertyShowKeyless = "friendsShowKeyless";
tab.propertyShowOffline = "friendsShowOffline";
tab.showFilterResultsEditBox = true;

tab.populate = function()
	for i = 1, GetNumFriends() do
		local name, level, class, _, online = GetFriendInfo(i)
		local fullName = name
		local realm
		if not string.match(name, "-") then
			fullName = name .. "-" .. KeystoneRollCall.playerRealm;
			realm = KeystoneRollCall.playerRealm
		else
			realm = select(2,strsplit("-",fullName))
		end
		
		local data  = KeystoneRollCall:getCharacterData(fullName)
		data.class = class
		data.level = level
		data.name = fullName
		data.characterName = name
		data.realm = realm
		data.faction = UnitFactionGroup("player") == "Alliance"
		
		local keystone = KeystoneRollCall:getKeystone(fullName)
		if not keystone then
			keystone = {['name'] =fullName,['class'] = class,dungeon = 0,level = 0,dummy=true}
		end
		KeystoneRollCall:AddListing(keystone,online);
	end
	
	if BNConnected()  then
		for i = 1, BNGetNumFriends() do
			local _, _, _, _, characterName, bnetIDGameAccount, client, online = BNGetFriendInfo(i)
			if bnetIDGameAccount and characterName and client == "WoW" then
				local _, characterName, _, realm, _, faction, race, class, guild, _, level = BNGetGameAccountInfo(bnetIDGameAccount);
				local fullName = characterName .. "-" .. realm;
						
				local data  = KeystoneRollCall:getCharacterData(fullName)
				data.class = class
				data.level = level
				data.name = fullName
				data.race = race
				data.guild = guild
				data.characterName = characterName
				data.realm = realm
				data.faction = faction == "Alliance"
				
				local keystone = KeystoneRollCall:getKeystone(fullName)
				if not keystone then
					keystone = {['name'] =fullName,['class'] = class,dungeon = 0,level = 0,dummy=true}
				end
				KeystoneRollCall:AddListing(keystone,online);
			end
		end
	end
end

KeystoneRollCall.tabs[tab.value] = tab;