local i, keystone,_,bag,bagSize

function KeystoneRollCall:PurgeExpiredKeystones()
	local currentWeeklyIndex = KeystoneRollCall:GetWeekIndexByTime(GetServerTime());
	for i = 1, #self.db.global.keystones do
		local keystone = self.db.global.keystones[i];
		local isOld = true;
		if keystone and (not keystone.lastSeen or KeystoneRollCall:GetWeekIndexByTime(keystone.lastSeen) ~= currentWeeklyIndex) then
			keystone.dungeon = 0
			keystone.level = 0
			keystone.affix1 = 0
			keystone.affix2 = 0
			keystone.affix3 = 0
			keystone.bestLevel = 0
			keystone.bestDungeon = 0
		end
	end
end

function KeystoneRollCall:extractKeystone(k)
	if not k then
		return
	end
	return (k.name or ""), (k.class or ""),(k.faction and 1 or 0),(k.dungeon or 0),(k.level or 0),(k.affix1 or 0),(k.affix2 or 0),(k.affix3 or 0),(k.bestLevel or 0),(k.bestDungeon or 0),(KeystoneRollCall.version or 0),(k.ilvl or 0),(k.equippedIlvl or 0)
end

function KeystoneRollCall:buildKeystone(args,owner)
	local keystone = {}	
	keystone.name = args[1]
	keystone.class = args[2]
	keystone.faction = args[3] == "1"
	keystone.dungeon = tonumber(args[4])
	keystone.level = tonumber(args[5])
	keystone.affix1 = tonumber(args[6])
	keystone.affix2 = tonumber(args[7])
	keystone.affix3 = tonumber(args[8])
	keystone.bestLevel = tonumber(args[9])
	keystone.bestDungeon = tonumber(args[10])
	keystone.version = args[11]
	keystone.ilvl = tonumber(args[12])
	keystone.equippedIlvl = tonumber(args[13])
	keystone.isPlayers = false;
	keystone.owner = owner
	keystone.lastSeen = GetServerTime()
	
	local oldKeystoneIndex = self:getKeystoneIndex(keystone.name)
	if oldKeystoneIndex and oldKeystoneIndex > 0 then
		local oldKeystone = self.db.global.keystones[oldKeystoneIndex]
		if oldKeystone.isPlayers then
			keystone.isPlayers = true;
		end
	end

	self:populateCharacterData(keystone)
	return self:saveKeystone(keystone)
end


function KeystoneRollCall:saveKeystone(keystone)
	if not keystone then
		return nil, nil;
	end
	
	local oldKeystone = self:getKeystone(keystone.name);
	if oldKeystone then
		local oldKeystoneIndex = self:getKeystoneIndex(keystone.name);
		self.db.global.keystones[oldKeystoneIndex] = keystone;
	else
		tinsert(self.db.global.keystones,keystone);
	end
	
	KeystoneRollCall:PurgeExpiredKeystones()
	return keystone, oldKeystone;
end 

function KeystoneRollCall:buildPlayerKeystone()
	local mapTable = C_ChallengeMode.GetMapTable();
	local bestLevel = 0;
	local bestDungeon;
	for i, dungeonId in pairs(mapTable) do
		local x, weeklyBestTime, weeklyBestLevel = C_ChallengeMode.GetMapPlayerStats(dungeonId);
		if weeklyBestLevel and weeklyBestLevel > bestLevel then
			bestLevel = weeklyBestLevel;
			bestDungeon = dungeonId;
		end
	end
	
	local ilvl, equippedIlvl = GetAverageItemLevel()
	
	local keystone = {}
	keystone.name = KeystoneRollCall.playerName;
	keystone.class = UnitClass("player");
	keystone.weeklyIndex = self:GetWeeklyIndex()
	keystone.isPlayers = true;
	keystone.bestLevel = bestLevel
	keystone.bestDungeon = bestDungeon
	keystone.faction = UnitFactionGroup("player") == "Alliance"
	keystone.dungeon = 0;
	keystone.ilvl = math.floor(ilvl) 
	keystone.equippedIlvl = math.floor(equippedIlvl)
	keystone.level = 0;
	keystone.version = KeystoneRollCall.version
	keystone.lastSeen = GetServerTime()
	local newKey = false;
	for bag = 0, NUM_BAG_SLOTS do
		bagSize = GetContainerNumSlots(bag);
		if bagSize > 0 then
			for i = 1, bagSize do
				if (GetContainerItemID(bag, i) == 138019) then
					local keyParts = { strsplit(':[', GetContainerItemLink(bag, i)) }
					local dungeonId, level, a1, a2, a3 = GetContainerItemLink(bag, i):gsub('\124', '\124\124'):match(':(%d+):(%d+):(%d+):(%d+):(%d+)')					
					keystone.dungeon = tonumber(dungeonId);
					keystone.level = tonumber(level);
					keystone.affix1 = tonumber(a1) or 0;
					keystone.affix2 = tonumber(a2) or 0;
					keystone.affix3 = tonumber(a3) or 0;
					self:populateCharacterData(keystone)
					return self:saveKeystone(keystone)
				end
			end
		end
	end

	self:populateCharacterData(keystone)
	return self:saveKeystone(keystone)
end

function KeystoneRollCall:populateCharacterData(keystone)
	if not keystone or not keystone.name then
		return
	end
	local data = self:getCharacterData(keystone.name)
	if not data.bestRuns then
		data.bestRuns = {}
	end
	if keystone.bestLevel and keystone.bestLevel >0 then
		local runEntry = {level = keystone.bestLevel, dungeon = keystone.bestDungeon, affix1 = keystone.affix1, affix2 = keystone.affix2, affix3 = keystone.affix3}
		
		local newAffix1 = data.bestRuns[1] and (tonumber(data.bestRuns[1].affix1) and tonumber(data.bestRuns[1].affix1) >0 and tonumber(data.bestRuns[1].affix1) ~= runEntry.affix1 );
		local newAffix2 = data.bestRuns[1] and (tonumber(data.bestRuns[1].affix2) and tonumber(data.bestRuns[1].affix2) >0 and tonumber(data.bestRuns[1].affix2) ~= runEntry.affix2 );
		local newAffix3 = data.bestRuns[1] and (tonumber(data.bestRuns[1].affix3) and tonumber(data.bestRuns[1].affix3) >0 and tonumber(data.bestRuns[1].affix3) ~= runEntry.affix3 );
		if data.bestRuns[1] and data.bestRuns[1].affix1 and (newAffix1 or newAffix2 or newAffix3)then
			tinsert(data.bestRuns,1,runEntry)
		else
			data.bestRuns[1] = runEntry
		end
	end

	data.class = keystone.class
	data.faction = keystone.faction
	data.isPlayers = keystone.isPlayers
	data.ilvl = keystone.ilvl
	data.equippedIlvl = keystone.equippedIlvl
	if not data.bestLevel or data.bestLevel < keystone.bestLevel then
		data.bestLevel = keystone.bestLevel
		data.bestDungeon = keystone.bestDungeon
	end
	data.lastSeen = time()
end

function KeystoneRollCall:getKeystoneIndex(characterName)
	for i, keystone in pairs(self.db.global.keystones) do
		if keystone.name == characterName then
			return i
		end
	end
	return -1
end

function KeystoneRollCall:getIlvlLine(keystone)
	local ilvlLine = ""

	if keystone.ilvl and tonumber(keystone.ilvl) > 0 then
		local dif = keystone.ilvl - keystone.equippedIlvl
		if dif == 0 then
			ilvlLine = tostring(keystone.equippedIlvl)
		else
			ilvlLine = keystone.equippedIlvl .." +"..(keystone.ilvl - keystone.equippedIlvl)..""
		end
	end
	return ilvlLine
end

function KeystoneRollCall:forEachAlt(main,callable)
	local mainKeystone = self:getKeystone(main)
	for i, keystone in pairs(self.db.global.keystones) do
		if mainKeystone and keystone.owner == mainKeystone.owner and keystone.name ~= mainKeystone.name then
			callable(keystone, mainKeystone)
		end
	end
end

function KeystoneRollCall:getKeystoneByUnit(unit)
	local name = KeystoneRollCall:getFullName(unit)
	for i, keystone in pairs(self.db.global.keystones) do
		if keystone.name == name then
			return keystone
		end
	end
	return nil
end

function KeystoneRollCall:getKeystone(characterName)
	for i, keystone in pairs(self.db.global.keystones) do
		if keystone.name == characterName then
			return keystone
		end
	end
	return nil
end

function KeystoneRollCall:getPlayerKeystoneIndex()
	return self:getKeystoneIndex(KeystoneRollCall.playerName)
end

function KeystoneRollCall:getPlayerKeystone()
	return self:getKeystone(KeystoneRollCall.playerName)
end

function KeystoneRollCall:getFullName(unit)
	local name, realm = UnitFullName(unit)
	realm = realm and realm ~= "" and realm or KeystoneRollCall.playerRealm
	if not realm then
		local playerName, playerRealm = UnitFullName("player")
		KeystoneRollCall.playerName = playerName
		KeystoneRollCall.playerRealm = playerRealm
		realm = playerRealm
	end
	local fullName = name .. "-" .. realm
	return fullName
end

function KeystoneRollCall:getCharacterData(fullName)
	local data = self.db.global.characters[fullName]
	if not data then
		data = {}
		self.db.global.characters[fullName]	=	data
	end
	return data
end

function KeystoneRollCall:getDungeonName(dungeon)
	return dungeon and C_ChallengeMode.GetMapInfo(dungeon) or ""
end

function KeystoneRollCall:getBestRunLine(bestLevel,bestDungeon)
	local bestLevelLine = ""
	if bestLevel and bestLevel > 0 and bestDungeon then
		bestLevelLine = "+" .. KeystoneRollCall:colorLevelMaxReward(bestLevel,bestLevel).." |cFFFFFFFF" .. KeystoneRollCall:getDungeonName(bestDungeon).."|r"
	end
	return bestLevelLine
end

function KeystoneRollCall:getBestRunLineOffline(bestLevel,bestDungeon)
	if bestLevel and bestLevel > 0 and bestDungeon then
		return KeystoneRollCall:colorOffline("+" .. bestLevel .. " " .. KeystoneRollCall:getDungeonName(bestDungeon))
	end
	return ""
end

function KeystoneRollCall:showTooltip(fullName,anchorFrame)
	local data = self:getCharacterData(fullName)
	if data and data.characterName and data.characterName~= "" then
		local keystone = self:getKeystone(fullName)
		GameTooltip_SetDefaultAnchor( GameTooltip, UIParent )
		GameTooltip:ClearAllPoints();
		GameTooltip:SetPoint("TOPLEFT",anchorFrame,"BOTTOMRIGHT");

		data.characterName = data.characterName or ""
		data.class = data.class or ""
		GameTooltip:SetText(self:colorClass(data.characterName or "",data.class or ""))
		GameTooltip:AddDoubleLine(" ");
		GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_realm"),data.realm);
		if data.faction ~= nil then
			GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_faction"),KeystoneRollCall:colorFaction(data.faction and "Alliance" or "Horde",data.faction));
		end
		if data.race then
			GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_race"),data.race);
		end
		GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_class"),self:colorClass(data.class,data.class));
		if data.level then
			GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_level"),data.level);
		end
		if data.ilvl and data.equippedIlvl then
			GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_item_level"),self:getIlvlLine(data));
		end

		if data.jointRuns and #data.jointRuns > 0 then
			GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_joint_history"));
			for i = 1,3 do
				if i <= #data.jointRuns then 
					GameTooltip:AddLine("      |cFFFFFFFF"..KeystoneRollCall:getBestRunLine(data.jointRuns[i].level,data.jointRuns[i].dungeon).."|r");
				end
			end
		end

		if data.bestRuns and #data.bestRuns > 0 then
			GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_best_history"));
			for i = 1,3 do
				if i <= #data.bestRuns then 
					GameTooltip:AddLine("      |cFFFFFFFF"..KeystoneRollCall:getBestRunLine(data.bestRuns[i].level,data.bestRuns[i].dungeon).."|r");
				end
			end
		end
		
		local count = 0
		KeystoneRollCall:forEachAlt(fullName,function(altKeystone,mainsKeystone)
			if altKeystone.name then
				if count == 0 then
					GameTooltip:AddDoubleLine(" "..KRCLocal:Get("tooltip_known_alts"));
				end
				if count <5 then
					local altNameParts =  {strsplit("-",altKeystone.name)};
					GameTooltip:AddLine("      "..self:colorClass(altNameParts[1],altKeystone.class));
				end
				count = count + 1
			end
		end)
		
		if count > 5 then
			GameTooltip:AddLine("      |cFFFFFFFF" .. KRCLocal:Get("broadcast_and_more",count) .. "|r");
		end

		if data.lastSeen then
			GameTooltip:AddDoubleLine(" ");
			GameTooltip:AddDoubleLine(keystone and keystone.version or " ",date("%m/%d/%y",data.lastSeen))
		end

		if not GameTooltip.bg then
			GameTooltip.bg = GameTooltip:CreateTexture(nil,"BACKGROUND",nil,1)
			GameTooltip.bg:SetPoint("TOPLEFT",3,-3)
			GameTooltip.bg:SetPoint("BOTTOMRIGHT",-3,3)
			GameTooltip.bg:SetColorTexture(0,0,0,1)
		end
		GameTooltip.bg:Show()
		GameTooltip:Show()
	end
end

function KeystoneRollCall:CompareKeystones(ka,kb)
	for i = 1, #KeystoneRollCall.sortFields do
		
		local av
		local bv
		if KeystoneRollCall.sortFields[i][1] == "owner" then
			if ka.isPlayers then
				av = KeystoneRollCall.playerName.. (KeystoneRollCall.playerName == ka.name and "A" or "B")
			else
				av = (ka.owner == ka.name) and (ka.owner or "") .. "A" or (ka.owner or ka.name or "") .. "B"	
			end
			if kb.isPlayers then
				bv = KeystoneRollCall.playerName.. (KeystoneRollCall.playerName == kb.name and "A" or "B")
			else
				bv = (kb.owner == kb.name) and (kb.owner or "") .. "A" or (kb.owner or kb.name or "") .. "B"	
			end
		elseif KeystoneRollCall.sortFields[i][1] == "dungeon" then
			av = KeystoneRollCall:getDungeonName(ka.dungeon) or "ZZZ"
			bv = KeystoneRollCall:getDungeonName(kb.dungeon) or "ZZZ"
		elseif KeystoneRollCall.sortFields[i][1] == "realm" then
			local nameParts =  {strsplit("-",ka.name or"")}
			av = nameParts[2] or""
			nameParts =  {strsplit("-",kb.name or"")}
			bv = nameParts[2] or""
		elseif KeystoneRollCall.sortFields[i][1] == "bestLevel" or KeystoneRollCall.sortFields[i][1] == "level" or KeystoneRollCall.sortFields[i][1] == "ilvl" or KeystoneRollCall.sortFields[i][1] == "equippedIlvl" then
			av =  ka[KeystoneRollCall.sortFields[i][1]] or 0
			bv =  kb[KeystoneRollCall.sortFields[i][1]] or 0
		else
			av =  ka[KeystoneRollCall.sortFields[i][1]] or ""
			bv =  kb[KeystoneRollCall.sortFields[i][1]] or ""
		end
		if av < bv then
			return KeystoneRollCall.sortFields[i][2];
		elseif av > bv then
			return not KeystoneRollCall.sortFields[i][2];
		end
	end
	return 
end

function KeystoneRollCall:keystoneToString(keystone)
	if keystone.dummy then
		return KRCLocal:Get("broadcast_no_addon",keystone.name)
	elseif keystone.level == 0 then
		return KRCLocal:Get("broadcast_no_keystone",keystone.name)
	end
	return "+" .. keystone.level .. " "  ..  KeystoneRollCall:getDungeonName(keystone.dungeon) .. "  -  " ..  keystone.name
end