local WEEK_SECONDS = 604800;

local WEEKLY_AFFIXES = {
	{5,14,10},
	{6,4,9},
	{7,2,10},
	{5,3,9},
	{8,12,10},
	{7,13,9},
	{11,14,10},
	{6,3,9},
	{5,13,10},
	{7,12,9},
	{8,3,10},
	{11,2,9}
}

-------------------------------------------------------------------------------------
-- Get the initial lauch time / reset day for the player's region
-------------------------------------------------------------------------------------
local function GetLaunchTime()
	local region = KeystoneRollCall.RealmsLib:GetCurrentRegion();
	if region == "EU" then
		return 1500447600;
	else
		return 1500390000;
	end
end

-------------------------------------------------------------------------------------
-- How many weeks long is the mythic+ affix schedule before it starts to repeat?
-------------------------------------------------------------------------------------
function KeystoneRollCall:GetWeekCount()
	return #WEEKLY_AFFIXES
end

-------------------------------------------------------------------------------------
-- What are the affixes for this week (plus offset)?
-------------------------------------------------------------------------------------
function KeystoneRollCall:GetWeeklyAffixes(offset)
	return unpack(WEEKLY_AFFIXES[KeystoneRollCall:GetWeeklyIndex(offset)])
end

-------------------------------------------------------------------------------------
-- How many weeks into the mythic+ affix schedule are we?
-------------------------------------------------------------------------------------
function KeystoneRollCall:GetWeeklyIndex(offset) 
	local weeklyIndex = (math.floor( (GetServerTime() - GetLaunchTime())/ WEEK_SECONDS) + (offset or 0)) % 12
	return weeklyIndex == 0 and 12 or weeklyIndex
end

-------------------------------------------------------------------------------------
-- Get the month and day that a given week's keystone reset.
-------------------------------------------------------------------------------------
function KeystoneRollCall:GetStartDate(offset)
	local week = math.floor( (GetServerTime() - GetLaunchTime())/ WEEK_SECONDS)+ (offset or 0)
	return date("%m/%d",week*WEEK_SECONDS+GetLaunchTime())
end

-------------------------------------------------------------------------------------
-- Get the week index in which the given time exists.
-------------------------------------------------------------------------------------
function KeystoneRollCall:GetWeekIndexByTime(time)
	return (math.floor((time - GetLaunchTime())/ WEEK_SECONDS) + (offset or 0)) 
end