local addonName, shared = ...

-- JustInTime by syndenbock
-- inspired by SafeQueue by Jordon

-- raids can have multiple queues, but you can only receive the queue time for
-- the latest queue, so we store these times for reloads/relogs/dcs

pveQueueTimes = pveQueueTimes or {}
options = options or { announce = 'self' }

local UPDATE_INTERVAL = 0.1

local addonFrame = CreateFrame('Frame')
local pvpQueue = 0
local updateTimeStamp = 0
local pveRemaining = 0
local pvpQueueTimes = {}
local events = {}
local pveCleaning = 0

PVPReadyDialog.leaveButton:Hide()
PVPReadyDialog.leaveButton.Show = function () end -- prevent other mods from showing the button
PVPReadyDialog.enterButton:ClearAllPoints()
PVPReadyDialog.enterButton:SetPoint('BOTTOM', PVPReadyDialog, 'BOTTOM', 0, 25)
PVPReadyDialog.label:SetPoint('TOP', 0, -22)

LFGDungeonReadyDialog.leaveButton:Hide()
LFGDungeonReadyDialog.leaveButton.Show = function () end -- prevent other mods from showing the button
LFGDungeonReadyDialog.enterButton:ClearAllPoints()
LFGDungeonReadyDialog.enterButton:SetPoint('BOTTOM', LFGDungeonReadyDialog, 'BOTTOM', 0, 25)
LFGDungeonReadyDialog.label:SetPoint('TOP', 0, -22)

-- the text of the LFG dialog label randomly changes back, so we override the function to prevent that
local updateLFGDialogLabel = LFGDungeonReadyDialog.label.SetText
LFGDungeonReadyDialog.label.SetText = function () end

--[[
///*****************************************************************************
/// general functions
///*****************************************************************************
--]]

local function printTable (table)
  for i,v in pairs(table) do
    print(i, ' - ', v)
  end
end

local function Print (msg)
	DEFAULT_CHAT_FRAME:AddMessage('|cff33ff99JIT|r: ' .. msg)
end

local function printTime (time)
	local announce = options.announce

	if (announce == 'off') then
		return
	end

	local secs, str, mins = floor(GetTime() - time), 'Queue popped '

	if (secs < 1) then
		str = str .. 'instantly!'
	else
		str = str .. 'after '

		if (secs >= 60) then
			mins = floor(secs / 60)
			str = str .. mins .. 'm '
			secs = secs % 60
		end

		if (secs % 60) ~= 0 then
			str = str .. secs .. 's'
		end
	end
	if (announce == 'self' or
		  not IsInGroup()) then
		Print(str)
	else
		local group = IsInRaid() and 'RAID' or 'PARTY'

		SendChatMessage(str, group)
	end
end

--[[
///#############################################################################
/// PVP queue stuff
///#############################################################################
--]]

local function showPVPTimer (self, elapsed)
	updateTimeStamp = updateTimeStamp + elapsed

	if (updateTimeStamp < UPDATE_INTERVAL) then
		return
	end

	updateTimeStamp = 0

	if PVPReadyDialog_Showing(pvpQueue) then
		local secs = GetBattlefieldPortExpiration(pvpQueue)

		if (secs and secs > 0) then
			local color = secs > 20 and 'f20ff20' or secs > 10 and 'fffff00' or 'fff0000'

			PVPReadyDialog.label:SetText('Expires in |cf'..color.. SecondsToTime(secs) .. '|r')
		end
	else
		pvpQueue = 0
		addonFrame:SetScript('OnUpdate', nil)
	end
end

function events:UPDATE_BATTLEFIELD_STATUS (index)
	local status = GetBattlefieldStatus(index)

	if (status == 'queued') then
		-- we are always updating this, because Blizzard actually returns the time
		-- from the last queue on the first call
		pvpQueueTimes[index] = GetTime() - GetBattlefieldTimeWaited(index) / 1000
	elseif (status == 'confirm') then
		if (pvpQueueTimes[index] ~= nil) then
			printTime(pvpQueueTimes[index])
			pvpQueueTimes[index] = nil
			updateTimeStamp = UPDATE_INTERVAL
			pvpQueue = index
			addonFrame:SetScript('OnUpdate', showPVPTimer)
		end
	else
		pvpQueueTimes[index] = nil
	end
end

--[[
///#############################################################################
/// PVE queue stuff
///#############################################################################
--]]

local function showPVETimer (self, elapsed)
	updateTimeStamp = updateTimeStamp + elapsed

	if (updateTimeStamp < UPDATE_INTERVAL) then
		return
	end

	local secs

	pveRemaining = pveRemaining - updateTimeStamp
	updateTimeStamp = 0
	secs = math.floor(pveRemaining)

	-- I didn't find a function to check if the dialog is still displayed, so we stop updating after the time is over
	if pveRemaining > 0 then
		local color = secs > 20 and 'f20ff20' or secs > 10 and 'fffff00' or 'fff0000'

		updateLFGDialogLabel(LFGDungeonReadyDialog.label, 'Expires in |cf' .. color .. SecondsToTime(secs) .. '|r')
	else
		addonFrame:SetScript('OnUpdate', nil)
	end
end

local function showDungeonPopped (id)
	if (pveQueueTimes[id] == nil) then
		return
	end

	printTime(pveQueueTimes[id])
	pveQueueTimes[id] = nil
end

local function cleanPveList (cleaningList)
	for i = 1, #cleaningList do
		pveQueueTimes[cleaningList[i]] = nil
	end
end

local function checkCleaning (queueList)
	local cleaningList = {}

	for key, value in pairs(pveQueueTimes) do
		if (queueList[key] == nil) then
			table.insert(cleaningList, key)
		end
	end

	if (#cleaningList <= 0) then return end

	local time = GetTime()

	if (pveCleaning >= time) then
		return
	end

	pveCleaning = time

	-- we need to wait a second because Blizzard's very bad and inconsistent order
	-- and timing of events can SOMETIMES trigger this multiple times right before
	-- LFG_PROPOSAL_SHOW (a few frames before or on the same frame)
	C_Timer.After(1, function ()
		cleanPveList(cleaningList)
	end)
end

-- you can have multiple seperate queues for raids
local function checkQueues (queueList)
	checkCleaning(queueList)

	for key, value in pairs(queueList) do
		-- we are always updating this, because Blizzard actually returns the time
		-- from the last queue on the first call
		pveQueueTimes[key] = queueList[key]
	end
end

local function getQueueList ()
	local queueList = {}

	for i = 1, 6 do -- queue subtype constants range from 1 to 6
		local categoryList = GetLFGQueuedList(i)
		local time = select(17, GetLFGQueueStats(i))

		time = tonumber(time)

		for key, value in pairs(categoryList) do
			queueList[key] = time
		end
	end

	return queueList
end

function events:LFG_UPDATE ()
	local queueList = getQueueList()

	checkQueues(queueList)
end

function events:LFG_PROPOSAL_SHOW ()
	local info = {GetLFGProposal()}
	-- local category = info[4]
	local id = info[2]

	showDungeonPopped(id)

	pveRemaining = 40 + UPDATE_INTERVAL
	updateTimeStamp = UPDATE_INTERVAL
	addonFrame:SetScript('OnUpdate', showPVETimer)
end

--[[
///#############################################################################
/// event handling
///#############################################################################
--]]

function events:ADDON_LOADED (name)
	if (name ~= addonName) then
		return
	end
	-- checkCategoryQueues(LFG_SUBTYPEID_RAID)
	events:LFG_UPDATE(nil)
end

local function eventHandler (self, event, ...)
  events[event](self, ...)
end

addonFrame:SetScript('OnEvent', eventHandler)

for k, v in pairs(events) do
  addonFrame:RegisterEvent(k)
end

--[[
///*****************************************************************************
/// slashcommand handlers
///*****************************************************************************
--]]

local slashCommands = {}

function slashCommands:announce (arg)
	if (arg == 'off' or arg == 'self' or arg == 'group') then
		options.announce = arg
		Print('Announce set to ' .. arg)
	elseif (arg == '') then
		Print('Announce is currently set to ' .. options.announce)
	else
		Print('Invalid announce setting')
		Print('Announce types are \'off\', \'self\', and \'group\'')
	end
end

function slashCommands:default ()
	DEFAULT_CHAT_FRAME:AddMessage('|cff33ff99JustInTime v1.0|r')
end

local function slashHandler (msg)
	msg = msg or ''
	local cmd, arg = string.split(' ', msg, 2)
	cmd = string.lower(cmd or '')
	arg = string.lower(arg or '')

	if (slashCommands[cmd] ~= nil) then
		slashCommands[cmd](nil, arg)
		return
	end

	Print('Unknown command "' .. msg .. '"')
end

SLASH_JustInTime1 = '/justintime'
SLASH_JustInTime2 = '/jit'
SlashCmdList.JustInTime = slashHandler
