﻿local JSPEC_BAR_SIZE = 30;
local JSPEC_BAR_GAP	= 7;
local JSPEC_EQUIP_SIZE = 182;

local addon = CreateFrame("Frame", "JSpecBar", UIParent);
local equip = CreateFrame("Frame", "JSpecEquip", addon);
local loot = CreateFrame("Button", "JSpecBarLoot", addon);
local buttons = {};
local l2i = {};

local left = addon:CreateTexture("JSpecBarLeft");
local mid = addon:CreateTexture("JSpecBarMiddle");
local right = addon:CreateTexture("JSpecBarRight");

addon:SetClampedToScreen(true);
addon:SetMovable(true);
addon:EnableMouse(false);
addon:RegisterForDrag("MiddleButton");

local function Initialize()
	if (MultiBarBottomRight and MultiBarBottomRight:IsShown()) and (MultiBarBottomRightButton1 and MultiBarBottomRightButton1:IsShown()) then
		addon:SetParent(MainMenuBar);
	else
		addon:SetParent(UIParent);
	end
	local numSpecs = GetNumSpecializations();
	addon:SetSize((JSPEC_BAR_SIZE * numSpecs) + (JSPEC_BAR_GAP * (numSpecs - 1)), JSPEC_BAR_SIZE);
	for i = 1, numSpecs do
		local id, specName, specExp, tex, specJob = GetSpecializationInfo(i);

		local button = CreateFrame("Button", "JSpecButton"..i, addon, "ActionButtonTemplate");
		button:SetSize(JSPEC_BAR_SIZE, JSPEC_BAR_SIZE);
		button:ClearAllPoints();
		button:SetPoint("BOTTOMLEFT", addon, "BOTTOMLEFT", ((i - 1) * (JSPEC_BAR_SIZE + JSPEC_BAR_GAP))+1, 0);

		button.icon:SetAllPoints();
		button.icon:SetTexture(tex);
		button.icon:SetTexCoord(0, 1, 0, 1);
		button.icon:SetSize(JSPEC_BAR_SIZE, JSPEC_BAR_SIZE);
		button.icon:ClearAllPoints();
		button.icon:SetPoint("CENTER", button, "CENTER", 0, 0);

		button.SpellHighlightTexture:SetAllPoints();
		button.SpellHighlightTexture:ClearAllPoints();
		button.SpellHighlightTexture:SetPoint("Center", 0, 0);
		button.SpellHighlightTexture:SetTexCoord(0.1,0.9,0.1,0.9);
		button.SpellHighlightTexture:SetSize(JSPEC_BAR_SIZE-4, JSPEC_BAR_SIZE-4);

		button.NormalTexture:SetAllPoints();
		button.NormalTexture:ClearAllPoints();
		button.NormalTexture:SetPoint("Center", 0, 0);

		button.SpellHighlightTexture:SetDrawLayer("BACKGROUND", 1);
		button.NormalTexture:SetDrawLayer("BORDER", 0);

		button:RegisterForClicks("LeftButtonUp", "RightButtonUp", "MiddleButtonDown", "MiddleButtonUp");
		button:SetScript("OnClick", function(self, mButton, down)
			if mButton == "LeftButton" then
				if i ~= GetSpecialization() and UnitLevel("player") >= 10 then
					SetSpecialization(i);
				end
			elseif mButton == "RightButton" then
				if GetLootSpecialization() == id then
					SetLootSpecialization(0);
				else
					SetLootSpecialization(id);
				end
			end
		end);
		
		button:SetScript("OnMouseDown", function(self, mButton, down)
			if mButton == "MiddleButton" then
				addon:StartMoving();
				SetPoint();
				equip:Hide();
				GameTooltip:Hide();
				self.FlyoutBorder:Hide();
				self.FlyoutBorderShadow:Hide();
			end
		end);

		button:SetScript("OnMouseUp", function(self, mButton, down)
			if mButton == "MiddleButton" then
				addon:StopMovingOrSizing();
				equip:Show();
				self.FlyoutBorder:Show();
				self.FlyoutBorderShadow:Show();
			end
		end);

		button:SetScript("OnDoubleClick", function(self, mButton, down)
			if mButton == "MiddleButton" then
				addon:StopMovingOrSizing();
				addon:ClearAllPoints();
				--addon:SetPoint("BOTTOMRIGHT", MainMenuBar, "TOPRIGHT", 0, 0);
				SetPoint();
				equip:Hide();
			end			
		end);

		button:SetScript("OnEnter", function(self)
			GameTooltip:SetOwner(self);
			GameTooltip:ClearLines();
			GameTooltip:AddLine(specName, nil, nil, nil);
			GameTooltip:AddLine(specJob, 0.5, 0.5, 0.5);
			GameTooltip:AddLine(specExp, 1, 1, 1, 1);
			GameTooltip:Show();
			self.FlyoutBorder:Show();
			self.FlyoutBorderShadow:Show();
			SetEquip(i, specName);
		end);
		button:SetScript("OnLeave", function(self)
			GameTooltip:Hide();
			local focus = GetMouseFocus();
			if focus and focus ~= equip and focus:GetParent() ~= equip then
				self.FlyoutBorder:Hide();
				self.FlyoutBorderShadow:Hide();
				equip:Hide();
			end
		end);
		
		
		buttons[i] = button;
		l2i[id] = i;
	end

	loot:SetSize(JSPEC_BAR_SIZE, JSPEC_BAR_SIZE);
	local tex = loot:CreateTexture();
	tex:SetAllPoints();
	tex:SetTexture("Interface/GROUPFRAME/UI-Group-MasterLooter.PNG");
	loot.tex = tex;
	loot:Hide();
	loot:SetFrameLevel(5);
	loot:SetSize(JSPEC_BAR_SIZE/2, JSPEC_BAR_SIZE/2);
	loot:EnableMouse(false);

	left:SetAllPoints();
	left:SetTexture("Interface/ShapeshiftBar/ShapeshiftBar");
	left:SetTexCoord(0, 0.734375, 0, 0.296875);
	left:SetSize(47, 38);
	left:ClearAllPoints();
	left:SetPoint("BOTTOMLEFT", addon,"BOTTOMLEFT", -10, -3);

	if numSpecs > 2 then
		mid:SetAllPoints();
		mid:SetTexture("Interface/ShapeshiftBar/ShapeshiftBarMiddle", true);
		mid:SetTexCoord(0, numSpecs-2, 0, 1);
		mid:SetSize((JSPEC_BAR_SIZE * (numSpecs-2)) + (JSPEC_BAR_GAP * (numSpecs-2)), 38);
		mid:ClearAllPoints();
		mid:SetPoint("LEFT", left,"RIGHT", 0, 0);
	end

	right:SetAllPoints();
	right:SetTexture("Interface/ShapeshiftBar/ShapeshiftBar");
	right:SetTexCoord(0.328125, 1, 0.3125, 0.6015625);
	right:SetSize(40, 38);
	right:ClearAllPoints();
	if numSpecs > 2 then
		right:SetPoint("LEFT", mid,"RIGHT", 0, 0);
	else
		right:SetPoint("LEFT", left,"RIGHT", 0, 0);
	end

	equip:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
        edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
        tile = true, tileSize = 16, edgeSize = 16, 
		insets = { left = 4, right = 4, top = 4, bottom = 4 }
	});
	equip:SetBackdropColor(0,0,0,1);
	equip:ClearAllPoints();
	equip:SetPoint("BOTTOM", addon, "BOTTOM", 0, JSPEC_BAR_SIZE);
	--equip:SetSize(100,100);
	equip:Hide();

	equip:SetScript("OnLeave", function(self)
		local focus = GetMouseFocus();
		if focus and focus ~= self and focus:GetParent() ~= self then
			self:Hide();
			for id, button in pairs(buttons) do
				button.FlyoutBorder:Hide();
				button.FlyoutBorderShadow:Hide();
			end
		end
	end);

	addon:SetScript("OnLeave", function(self)
		local focus = GetMouseFocus();
		if focus and focus ~= equip and focus:GetParent() ~= equip then
			for id, button in pairs(buttons) do
				button.FlyoutBorder:Hide();
				button.FlyoutBorderShadow:Hide();
			end
			equip:Hide();
		end
	end);
	
	equip.list = {};

	
	SetPoint();
end

function FixBuG()
	local nSpec = GetNumSpecializations();
	local nSet = C_EquipmentSet.GetNumEquipmentSets();

	local aSpec = {};
	for s = 1, nSpec do
		aSpec[s] = C_EquipmentSet.GetEquipmentSetForSpec(s);
	end

	for i = 1, nSet do
		for s = 1, nSpec do
			C_EquipmentSet.AssignSpecToEquipmentSet(i-1, s);
			C_EquipmentSet.UnassignEquipmentSetSpec(i-1)
		end
	end

	for s = 1, nSpec do
		local set = aSpec[s]
		if set then
			C_EquipmentSet.AssignSpecToEquipmentSet(set, s);
		end
	end
end

function SetEquip(oSpeci, oSpecName)
	local nSet = C_EquipmentSet.GetNumEquipmentSets();
	local nSpecSet = 0;
	local nSpec = GetNumSpecializations();
	local cSpec = GetSpecialization();
	local cSpecId, cSpecName, cSpecExp, cSpecTex, cSpecJob = GetSpecializationInfo(cSpec);
	local viewSet = {};

	FixBuG();

	for i = 1, nSet do
		local name,texture,setIndex,isEquipped,numItems,equippedItems,availableItems,missingItems,ignoredSlots = GetEquipmentSetInfo(i);

		if string.find(name, oSpecName) then
			table.insert(viewSet, i);
		end
		

		local t = false;
		for s = 1, nSpec do
			local _,specName,_,_,_ = GetSpecializationInfo(s);
			if string.find(name, oSpecName) then
				t = true
			elseif string.find(name, specName) then
				t = true;
			end
		end

		if not t then
			table.insert(viewSet, i);
		end
	end

	if getn(viewSet) == 0 then
		return;
	end

	equip:SetSize(JSPEC_EQUIP_SIZE, JSPEC_BAR_GAP*1.5+getn(viewSet)*(JSPEC_BAR_SIZE+JSPEC_BAR_GAP/2));

	for i,v in ipairs(equip.list) do
		equip.list[i]:Hide();
		equip.list[i]:SetParent(nil);
		equip.list[i]:ClearAllPoints();
		tremove(equip.list[i]);
	end

	for i,v in ipairs(viewSet) do
		local name,texture,setIndex,isEquipped,numItems,equippedItems,availableItems,missingItems,ignoredSlots = GetEquipmentSetInfo(v);
		local button = CreateFrame("Button", "JSpecEquipSet"..i, equip, "GearSetButtonTemplate");

		button:ClearAllPoints();
		button:SetSize(JSPEC_EQUIP_SIZE-JSPEC_BAR_GAP*2, JSPEC_BAR_SIZE);
		button:SetPoint("TOPLEFT", equip, "TOPLEFT", JSPEC_BAR_GAP, -JSPEC_BAR_GAP-(i-1)*(JSPEC_BAR_SIZE+JSPEC_BAR_GAP/2));

		button.BgBottom:ClearAllPoints();
		button.BgBottom:SetPoint("BOTTOMLEFT",0,0);
		button.BgMiddle:SetHeight(JSPEC_BAR_SIZE-16);

		button.text:SetText(name);
		if missingItems > 0 then
			button.text:SetTextColor(1,0,0);
		end
		

		button.SpecRing:ClearAllPoints();
		button.SpecIcon:ClearAllPoints();
		button.SpecRing:SetPoint("LEFT", button, "LEFT", 14, -10);
		button.SpecIcon:SetPoint("CENTER", button.SpecRing, "CENTER", 0, 0);
		button.SpecIcon:SetMask("Interface/CHARACTERFRAME/TempPortraitAlphaMaskSmall");
		
		if isEquipped then
			button.Check:Show()
		end

		local sS = C_EquipmentSet.GetEquipmentSetAssignedSpec(v-1);
		
		if sS then
			local _,_,_,tex,_ = GetSpecializationInfo(sS);
			button.SpecIcon:SetTexture(tex);
		else
			button.SpecRing:Hide();
			button.SpecIcon:Hide();
		end
		
		button.icon:SetAllPoints();
		button.icon:SetTexture(texture);
		button.icon:SetTexCoord(0, 1, 0, 1);
		button.icon:SetSize(JSPEC_BAR_SIZE-2, JSPEC_BAR_SIZE-2);
		button.icon:ClearAllPoints();
		button.icon:SetPoint("LEFT", button, "LEFT", 0, 0);

		button:RegisterForClicks("LeftButtonUp", "RightButtonUp", "MiddleButtonUp");
		button:SetScript("OnClick", function(self, mButton, down)
			if mButton == "LeftButton" then
				if sS then
					local prev = C_EquipmentSet.GetEquipmentSetForSpec(sS);
					if prev then
						C_EquipmentSet.UnassignEquipmentSetSpec(prev);
					end
				end
				C_EquipmentSet.AssignSpecToEquipmentSet(v-1, oSpeci);
				if oSpeci == cSpec then
					if not isEquipped then
						C_EquipmentSet.UseEquipmentSet(v-1)
					end
				else
					SetSpecialization(oSpeci);
				end
				--SetEquip(oSpeci, oSpecName);
				equip:Hide();
				for id, button in pairs(buttons) do
					button.FlyoutBorder:Hide();
					button.FlyoutBorderShadow:Hide();
				end
			elseif mButton == "RightButton" then
				--C_EquipmentSet.AssignSpecToEquipmentSet(v-1, oSpeci);
				if not isEquipped then
					local _,_,ei = GetEquipmentSetInfo(v);
					C_EquipmentSet.UseEquipmentSet(ei)
				end
				--SetEquip(oSpeci, oSpecName);
				equip:Hide();
				for id, button in pairs(buttons) do
					button.FlyoutBorder:Hide();
					button.FlyoutBorderShadow:Hide();
				end
			else
				--C_EquipmentSet.UnassignEquipmentSetSpec(v-1)
				C_EquipmentSet.UnassignEquipmentSetSpec(v-1)
				SetEquip(oSpeci, oSpecName);
			end

		end);

		button:SetScript("OnEnter", function(self)
			--numItems,equippedItems,availableItems,missingItems
			self.HighlightBar:Show();
			GameTooltip:SetOwner(self);
			GameTooltip:ClearLines();
			GameTooltip:AddLine(name, nil, nil, nil);
			GameTooltip:AddLine(availableItems.."/"..numItems, 1, 1, 0);
			--GameTooltip:AddLine(equippedItems+availableItems.."/"..numItems, 1, 1, 0);
			GameTooltip:AddLine(numItems-missingItems.."/"..numItems, 0.5, 0.5, 0.5);
			GameTooltip:Show();
		end);
		
		button:SetScript("OnLeave", function(self)
			self.HighlightBar:Hide();
			GameTooltip:Hide();
			local focus = GetMouseFocus();
			if focus and focus ~= equip and focus:GetParent() ~= equip then
				for id, button in pairs(buttons) do
					button.FlyoutBorder:Hide();
					button.FlyoutBorderShadow:Hide();
				end
				equip:Hide();
			end
		end);
		equip.list[i] = button;
	end
	
	equip:Show();
end

MultiBarBottomRight:HookScript("OnHide", function()
	SetPoint(false);
end)

MultiBarBottomRight:HookScript("OnShow", function()
	SetPoint(true);
end)

function SetPoint(over)
	local _,toggle,_,_ = GetActionBarToggles();
	local p,a,_,_,_ = addon:GetPoint();
	
	if over ~= nil then
		toggle = over;
	end

	if not p then
		if not MultiBarBottomRight:GetParent():GetName() then
			addon:SetPoint("CENTER", nil ,"CENTER", 0, 0);
		else
			p = "BOTTOMRIGHT";
			a = MultiBarBottomRight;
		end
	end
	
	if toggle or not a then
		if p == "BOTTOMRIGHT" and a then
			addon:ClearAllPoints();
			addon:SetPoint("BOTTOMRIGHT", MultiBarBottomRight, "TOPRIGHT", -34, 7);
		end
		left:Hide();
		mid:Hide();
		right:Hide();
		for id, button in pairs(buttons) do
			button.NormalTexture:SetSize(53, 53);
		end
	else
		addon:ClearAllPoints();
		addon:SetPoint("BOTTOMRIGHT", MultiBarBottomRight, "TOPRIGHT", -34, -40);
		left:Show();
		mid:Show();
		right:Show();
		for id, button in pairs(buttons) do
			button.NormalTexture:SetSize(60, 60);
		end
	end
end

addon:RegisterEvent("PLAYER_ENTERING_WORLD");
addon:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED");
addon:RegisterEvent("PLAYER_LOOT_SPEC_UPDATED");
addon:SetScript("OnEvent", function(_, event)
	if event == "PLAYER_ENTERING_WORLD" and getn(buttons) == 0 then
		Initialize();
	end
	
	local current = GetSpecialization();

	for id, button in pairs(buttons) do
		if id == current then
			loot:Show();
			button:SetAlpha(1);
			button.SpellHighlightTexture:Show();
		else
			if UnitLevel("player") < 10 then
				button:SetAlpha(0.5);
				button.SpellHighlightTexture:Hide();
			else
				button:SetAlpha(1);
				button.SpellHighlightTexture:Hide();
			end
		end
	end

	current = GetLootSpecialization();
	
	if current == 0 then
		loot:Hide();
	else
		loot:SetPoint("BOTTOMLEFT", ((l2i[current]-1) * (JSPEC_BAR_SIZE + JSPEC_BAR_GAP)) + JSPEC_BAR_SIZE/2, 0);
	end
end);