﻿JPHF_Settings = {MinimapPos = 45}

UIPanelWindows["JPHF_AchievementFrame"] = { area = "doublewide", pushable = 0, xoffset = 80, whileDead = 1 };

JPHF_ACHIEVEMENTUI_CATEGORIES = {};

JPHF_ACHIEVEMENTUI_GOLDBORDER_R = 1;
JPHF_ACHIEVEMENTUI_GOLDBORDER_G = 0.675;
JPHF_ACHIEVEMENTUI_GOLDBORDER_B = 0.125;
JPHF_ACHIEVEMENTUI_GOLDBORDER_A = 1;

JPHF_ACHIEVEMENTUI_REDBORDER_R = 0.7;
JPHF_ACHIEVEMENTUI_REDBORDER_G = 0.15;
JPHF_ACHIEVEMENTUI_REDBORDER_B = 0.05;
JPHF_ACHIEVEMENTUI_REDBORDER_A = 1;

JPHF_ACHIEVEMENTUI_BLUEBORDER_R = 0.129;
JPHF_ACHIEVEMENTUI_BLUEBORDER_G = 0.671;
JPHF_ACHIEVEMENTUI_BLUEBORDER_B = 0.875;
JPHF_ACHIEVEMENTUI_BLUEBORDER_A = 1;

JPHF_ACHIEVEMENTUI_CATEGORIESWIDTH = 175;

JPHF_ACHIEVEMENTUI_MAX_SUMMARY_ACHIEVEMENTS = 4;

JPHF_ACHIEVEMENTUI_MAXCONTENTWIDTH = 330;
JPHF_ACHIEVEMENTUI_CRITERIACHECKWIDTH = 20;
local JPHF_ACHIEVEMENTUI_FONTHEIGHT;						-- set in AchievementButton_OnLoad
local JPHF_ACHIEVEMENTUI_MAX_LINES_COLLAPSED = 3;		-- can show 3 lines of text when achievement is collapsed

JPHF_ACHIEVEMENT_CATEGORY_NORMAL_R = 0;
JPHF_ACHIEVEMENT_CATEGORY_NORMAL_G = 0;
JPHF_ACHIEVEMENT_CATEGORY_NORMAL_B = 0;
JPHF_ACHIEVEMENT_CATEGORY_NORMAL_A = .9;

JPHF_ACHIEVEMENT_CATEGORY_HIGHLIGHT_R = 0;
JPHF_ACHIEVEMENT_CATEGORY_HIGHLIGHT_G = .6;
JPHF_ACHIEVEMENT_CATEGORY_HIGHLIGHT_B = 0;
JPHF_ACHIEVEMENT_CATEGORY_HIGHLIGHT_A = .65;

JPHF_ACHIEVEMENTBUTTON_LABELWIDTH = 320;

JPHF_ACHIEVEMENT_FILTER_ALL = 1;
JPHF_ACHIEVEMENT_FILTER_COMPLETE = 2;
JPHF_ACHIEVEMENT_FILTER_INCOMPLETE = 3;

local JPHF_FORCE_COLUMNS_MAX_WIDTH = 220;				-- if no columns normally, force 2 if max criteria width is <= this and number of criteria >= MIN_CRITERIA
local JPHF_FORCE_COLUMNS_MIN_CRITERIA = 20;
local JPHF_FORCE_COLUMNS_LEFT_OFFSET = -10;				-- offset for left column
local JPHF_FORCE_COLUMNS_RIGHT_OFFSET = 24;				-- offset for right column
local JPHF_FORCE_COLUMNS_RIGHT_COLUMN_SPACE = 150;		-- max room for first entry of the right column due to achievement shield

JPHF_AchievementFrameFilterStrings = {ACHIEVEMENT_FILTER_ALL_EXPLANATION, ACHIEVEMENT_FILTER_COMPLETE_EXPLANATION, ACHIEVEMENT_FILTER_INCOMPLETE_EXPLANATION};

local JPHF_TEXTURES_OFFSET = 0;

JPHF_Onglet_Select = 1;

function JPHF_MSG(msg)
	DEFAULT_CHAT_FRAME:AddMessage(tostring(msg));
end

local JPHF_trackedAchievements = {};
local JPHF_achievementFunctions;

local function JPHF_updateTrackedAchievements (...) 
	local count = select("#", ...);
	for i = 1, count do
		JPHF_trackedAchievements[select(i, ...)] = true;
	end
end

-- [[ Minimap Button]] --

function JPHF_MinimapButton_OnLoad (self)
   JPHF_MinimapButton:RegisterForClicks("LeftButtonUp","RightButtonUp")
   JPHF_MinimapButton:RegisterForDrag("LeftButton","RightButton")
   JPHF_MinimapButton:RegisterEvent('ADDON_LOADED')
   JPHF_MinimapButton:SetScript('OnEvent', function(self, event, ...)
     if event == 'ADDON_LOADED' and ... == 'JPHF' then
       JPHF_MinimapButton:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-(80*cos(JPHF_Settings.MinimapPos)),(80*sin(JPHF_Settings.MinimapPos))-52)
	 end
   end)
end

function JPHF_MinimapButton_Reposition ()
	JPHF_MinimapButton:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-(80*cos(JPHF_Settings.MinimapPos)),(80*sin(JPHF_Settings.MinimapPos))-52)
end

function JPHF_MinimapButton_DraggingFrame_OnUpdate ()

	local xpos,ypos = GetCursorPosition()
	local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom()

	xpos = xmin-xpos/UIParent:GetScale()+70 -- get coordinates as differences from the center of the minimap
	ypos = ypos/UIParent:GetScale()-ymin-70

	JPHF_Settings.MinimapPos = math.deg(math.atan2(ypos,xpos)) -- save the degrees we are relative to the minimap center
	JPHF_MinimapButton_Reposition() -- move the button
end

function JPHF_MinimapButton_OnClick (button)
	if (button == "LeftButton") then
		JPHF_AchievementFrame_ToggleAchievementFrame()
	end
end

function JPHF_MinimapButton_OnEnter (self)
	if (self.dragging) then
		return
	end
	GameTooltip:SetOwner(self or UIParent, "ANCHOR_LEFT")
	GameTooltip:SetText("JPHF")
end


-- Cadre principale

function JPHF_AchievementFrame_ToggleAchievementFrame ()
	JPHF_AchievementFrameTab_OnClick = JPHF_AchievementFrameBaseTab_OnClick;
	if (JPHF_AchievementFrame:IsShown()) then
		JPHF_AchievementFrame:Hide();
	else
		JPHF_AchievementFrame:Show();
		JPHF_AchievementFrameTab_OnClick(JPHF_Onglet_Select)
	end
end

function JPHF_AchievementFrame_OnLoad (self)
	SLASH_JPHF1 = "/jphf";
	SlashCmdList["JPHF"] = JPHF_SlashCommand;
	tinsert(UISpecialFrames, "JPHF_AchievementFrame")
	JPHF_AchievementFrameTab1.text:SetText(JPHF_Onglet_Select_Valeur[1])
	for i = 2, JPHF_NombreModule do
		local frame = CreateFrame("BUTTON", "JPHF_AchievementFrameTab" ..i, JPHF_AchievementFrame, "JPHF_AchievementFrameTabButtonTemplate");
		frame:SetID(i)
		frame:SetPoint("LEFT", "JPHF_AchievementFrameTab" ..i-1,"RIGHT",-5,0)
		frame.text:SetText(JPHF_Onglet_Select_Valeur[i])
		frame:Show()
	end
	
	PanelTemplates_SetNumTabs(self, JPHF_NombreModule);
	self.selectedTab = 1;
	PanelTemplates_UpdateTabs(self);
	JPHF_AchievementFrameSummary.forceOnShow = JPHF_AchievementFrameSummary_OnShow;
	JPHF_AchievementFrameAchievements.forceOnShow = JPHF_AchievementFrameAchievements_OnShow;
end

function JPHF_AchievementFrame_OnShow (self)
	PlaySound(13832, "Master");
	JPHF_AchievementFrameHeaderTitle:SetText(ACHIEVEMENT_TITLE .." "..JPHF_Onglet_Select_Valeur[JPHF_Onglet_Select])
	TotalHFPoint = JPHF_NombrePointHF()
	JPHF_AchievementFrameHeaderPoints:SetText(TotalHFPoint);	
	
	if ( not JPHF_AchievementFrame.wasShown ) then
		JPHF_AchievementFrame.wasShown = true;
		JPHF_AchievementCategoryButton_OnClick(JPHF_AchievementFrameCategoriesContainerButton1);
	end	
end

function JPHF_AchievementFrame_OnHide (self)
	PlaySound(13833, "Master");
end

function JPHF_AchievementFrame_UpdateTabs(clickedTab)
	PanelTemplates_Tab_OnClick(_G["JPHF_AchievementFrameTab"..clickedTab], JPHF_AchievementFrame);
	local tab;
	--onglet
	for i = 1, JPHF_NombreModule do
		tab = _G["JPHF_AchievementFrameTab"..i];
		if ( i == clickedTab ) then
			tab.text:SetPoint("CENTER", 0, -5);
		else
			tab.text:SetPoint("CENTER", 0, -3);
		end
	end
end

function JPHF_AchievementFrameBaseTab_OnClick (id)
	JPHF_AchievementFrame_UpdateTabs(id);
	JPHF_Onglet_Select = id
	local isSummary = false;
	local swappedView = false;
	
	JPHF_AchievementFrameCategories_GetCategoryList(JPHF_ACHIEVEMENTUI_CATEGORIES, id); -- This needs to happen before AchievementFrame_ShowSubFrame (fix for bug 157885)
	if ( JPHF_Categorie_Select[id] == 1 ) then
		isSummary = true;
		JPHF_AchievementFrame_ShowSubFrame(JPHF_AchievementFrameSummary);
	else
		JPHF_AchievementFrame_ShowSubFrame(JPHF_AchievementFrameAchievements);
	end	
	JPHF_AchievementFrameAchievements_OnShow()
	JPHF_AchievementFrameHeaderTitle:SetText(ACHIEVEMENT_TITLE .." "..JPHF_Onglet_Select_Valeur[JPHF_Onglet_Select])
	TotalHFPoint = JPHF_NombrePointHF()
	JPHF_AchievementFrameHeaderPoints:SetText(TotalHFPoint);
	
	JPHF_AchievementFrameCategories_Update();
	if ( not isSummary ) then
		JPHF_AchievementFrameAchievements_Update();
	end	
end

JPHF_AchievementFrameTab_OnClick = JPHF_AchievementFrameBaseTab_OnClick;

JPHF_ACHIEVEMENTFRAME_SUBFRAMES = {"JPHF_AchievementFrameSummary",	"JPHF_AchievementFrameAchievements"};

function JPHF_AchievementFrame_ShowSubFrame(...)
	local subFrame, show;
	for _, name in next, JPHF_ACHIEVEMENTFRAME_SUBFRAMES  do
		subFrame = _G[name];
		show = false;
		for i=1, select("#", ...) do
			if ( subFrame ==  select(i, ...)) then
				show = true
			end
		end
		if ( show ) then
			-- force the OnShow to run if we need to swap views on the subFrame
			if ( subFrame.forceOnShow and subFrame:IsShown() ) then
				subFrame.forceOnShow();
			else
				subFrame:Show();
			end
		else
			subFrame:Hide();
		end
	end
end

-- Cadre categorie

function JPHF_AchievementFrameCategories_OnLoad (self)
	self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_GOLDBORDER_R, JPHF_ACHIEVEMENTUI_GOLDBORDER_G, JPHF_ACHIEVEMENTUI_GOLDBORDER_B, JPHF_ACHIEVEMENTUI_GOLDBORDER_A);
	self.buttons = {};
	self:RegisterEvent("ADDON_LOADED");
	self:SetScript("OnEvent", JPHF_AchievementFrameCategories_OnEvent);
end

function JPHF_AchievementFrameCategories_OnEvent (self, event, ...)
	if ( event == "ADDON_LOADED" ) then
		local addonName = ...;
		if ( addonName and addonName ~= "JPHF" ) then
			return;
		end
		
		JPHF_AchievementFrameCategories_GetCategoryList(JPHF_ACHIEVEMENTUI_CATEGORIES, 1);
		
		JPHF_AchievementFrameCategoriesContainerScrollBar.Show = 
			function (self)
				JPHF_ACHIEVEMENTUI_CATEGORIESWIDTH = 175;
				JPHF_AchievementFrameCategories:SetWidth(175);
				JPHF_AchievementFrameCategoriesContainer:GetScrollChild():SetWidth(175);
				JPHF_AchievementFrameAchievements:SetPoint("TOPLEFT", "$parentCategories", "TOPRIGHT", 22, 0);
				--JPHF_AchievementFrameStats:SetPoint("TOPLEFT", "$parentCategories", "TOPRIGHT", 22, 0);
				--JPHF_AchievementFrameComparison:SetPoint("TOPLEFT", "$parentCategories", "TOPRIGHT", 22, 0)
				JPHF_AchievementFrameWaterMark:SetWidth(145);
				JPHF_AchievementFrameWaterMark:SetTexCoord(0, 145/256, 0, 1);
				for _, button in next, JPHF_AchievementFrameCategoriesContainer.buttons do
					JPHF_AchievementFrameCategories_DisplayButton(button, button.element)
				end
				getmetatable(self).__index.Show(self);
			end
			
		JPHF_AchievementFrameCategoriesContainerScrollBar.Hide = 
			function (self)
				JPHF_ACHIEVEMENTUI_CATEGORIESWIDTH = 197;
				JPHF_AchievementFrameCategories:SetWidth(197);
				JPHF_AchievementFrameCategoriesContainer:GetScrollChild():SetWidth(197);
				JPHF_AchievementFrameAchievements:SetPoint("TOPLEFT", "$parentCategories", "TOPRIGHT", 0, 0);
				--JPHF_AchievementFrameStats:SetPoint("TOPLEFT", "$parentCategories", "TOPRIGHT", 0, 0);
				--JPHF_AchievementFrameComparison:SetPoint("TOPLEFT", "$parentCategories", "TOPRIGHT", 0, 0)
				JPHF_AchievementFrameWaterMark:SetWidth(167);
				JPHF_AchievementFrameWaterMark:SetTexCoord(0, 167/256, 0, 1);
				for _, button in next, JPHF_AchievementFrameCategoriesContainer.buttons do
					JPHF_AchievementFrameCategories_DisplayButton(button, button.element);
				end
				getmetatable(self).__index.Hide(self);
			end
			
		JPHF_AchievementFrameCategoriesContainerScrollBarBG:Show();
		JPHF_AchievementFrameCategoriesContainer.update = JPHF_AchievementFrameCategories_Update;
		HybridScrollFrame_CreateButtons(JPHF_AchievementFrameCategoriesContainer, "JPHF_AchievementCategoryTemplate", 0, 0, "TOP", "TOP", 0, 0, "TOP", "BOTTOM");
		JPHF_AchievementFrameCategories_Update();
		self:UnregisterEvent(event)		
	end
end

function JPHF_AchievementFrameCategories_OnShow (self)
	JPHF_AchievementFrameCategories_Update();
end

function JPHF_AchievementFrameCategories_GetCategoryList (categories, onglet) --La mienne
	local cats
	local parent
	cats = JPHF_Categorie[onglet]

	for i in next, categories do
		categories[i] = nil;
	end

	for i, id in next, cats do
		parent = cats[i].parent
		if ( parent == 0 ) then
			tinsert(categories, {["id"] = cats[i].id, ["parent"] = cats[i].parent, ["parentlevel"] = cats[i].parentlevel, ["name"] = cats[i].name, ["hidden"] = cats[i].hidden})
		end
	end
	local parent;
	for i = #cats, 1, -1 do 
		parent = cats[i].parent;
		if (cats[i].parentlevel == 1) then
			for j, category in next, categories do
				if ( category.id == parent ) then
					category.collapsed = true;
					tinsert(categories, j+1, {["id"] = cats[i].id, ["parent"] = cats[i].parent, ["parentlevel"] = cats[i].parentlevel, ["name"] = cats[i].name, ["hidden"] = cats[i].hidden});
				end
			end
		end
	end
	for i = #cats, 1, -1 do 
		parent = cats[i].parent;
		if (cats[i].parentlevel == 2) then
			for j, category in next, categories do
				if ( category.id == parent ) then
					category.collapsed = true;
					tinsert(categories, j+1, {["id"] = cats[i].id, ["parent"] = cats[i].parent, ["parentlevel"] = cats[i].parentlevel, ["name"] = cats[i].name, ["hidden"] = cats[i].hidden});
				end
			end
		end
	end
end




local JPHF_displayCategories = {};

function JPHF_AchievementFrameCategories_Update ()
	local scrollFrame = JPHF_AchievementFrameCategoriesContainer
	local categories = JPHF_ACHIEVEMENTUI_CATEGORIES;
	local offset = HybridScrollFrame_GetOffset(scrollFrame);
	local buttons = scrollFrame.buttons;	
	
	local displayCategories = JPHF_displayCategories;
	
	for i in next, displayCategories do
		displayCategories[i] = nil;
	end
	
	local selection =  JPHF_Categorie_Select[JPHF_Onglet_Select];
	
	local parent;
	local parent1;

	parent = JPHF_Categorie[JPHF_Onglet_Select][selection].parent
	if JPHF_Categorie[JPHF_Onglet_Select][selection].parentlevel == 2 then
		parent1 = JPHF_Categorie[JPHF_Onglet_Select][parent].parent
	end

	for i, category in next, categories do
		if ( not category.hidden ) then
			tinsert(displayCategories, category);
		elseif ( parent and category.parent and category.parent == parent ) then
			category.hidden = false;
			tinsert(displayCategories, category);
		elseif ( parent1 and category.parent and category.parent == parent1 ) then
			category.hidden = false;
			tinsert(displayCategories, category);		
		end
	end
	
	local numCategories = #displayCategories;
	local numButtons = #buttons;
	
	local totalHeight = numCategories * buttons[1]:GetHeight();
	local displayedHeight = 0;
	
	local element
	for i = 1, numButtons do
		element = displayCategories[i + offset];
		displayedHeight = displayedHeight + buttons[i]:GetHeight();
		if ( element ) then
			JPHF_AchievementFrameCategories_DisplayButton(buttons[i], element);
			if ( selection and element.id == selection ) then
				buttons[i]:LockHighlight();
			else
				buttons[i]:UnlockHighlight();
			end
			buttons[i]:Show();
		else
			buttons[i].element = nil;
			buttons[i]:Hide();
		end
	end
	
	HybridScrollFrame_Update(scrollFrame, totalHeight, displayedHeight);
	
	return displayCategories;
end

function JPHF_AchievementFrameCategories_DisplayButton (button, element)
	if ( not element ) then
		button.element = nil;
		button:Hide();
		return;
	end
	
	button:Show();

	if ( element.parentlevel == 0 ) then
		button:SetWidth(JPHF_ACHIEVEMENTUI_CATEGORIESWIDTH - 10);
		button.label:SetFontObject("GameFontNormal");
		button.parentID = element.parent;
		button.background:SetVertexColor(1, 1, 1);	
	elseif ( element.parentlevel == 1 ) then
		button:SetWidth(JPHF_ACHIEVEMENTUI_CATEGORIESWIDTH - 25);
		button.label:SetFontObject("GameFontHighlight");
		button.parentID = element.parent;
		button.background:SetVertexColor(0.75, 0.75, 0.75);
	elseif ( element.parentlevel == 2 ) then
		button:SetWidth(JPHF_ACHIEVEMENTUI_CATEGORIESWIDTH - 40);
		button.label:SetFontObject("GameFontHighlightSmall");
		button.parentID = element.parent;
		button.background:SetVertexColor(0.5, 0.5, 0.5);		
	end	
	
	local numAchievements, numCompleted = 0, 0
	
	local id = element.id;
	
	-- kind of janky
	if ( id == 1 ) then
		for i = 2 , #JPHF_Categorie[JPHF_Onglet_Select] do
			JPHF_Temp_Achivement, JPHF_Temp_Completed = JPHF_AchievementFrame_GetCategoryNumAchievements_All(i)
			numAchievements = numAchievements + JPHF_Temp_Achivement
			numCompleted = numCompleted + JPHF_Temp_Completed
		end	
	else
		numAchievements, numCompleted = JPHF_AchievementFrame_GetCategoryTotalNumAchievements(id, true);
	end
	
	
	
	button.label:SetText(element.name);
	button.categoryID = id;
	button.element = element;

	-- For the tooltip
	button.name = element.name;
	button.text = nil;
	button.numAchievements = numAchievements;
	button.numCompleted = numCompleted;
	button.numCompletedText = numCompleted.."/"..numAchievements;
	button.showTooltipFunc = JPHF_AchievementFrameCategory_StatusBarTooltip;
end

function JPHF_AchievementFrameCategory_StatusBarTooltip(self)
	GameTooltip_SetDefaultAnchor(GameTooltip, self);
	GameTooltip:SetMinimumWidth(128, true);
	GameTooltip:SetText(self.name, 1, 1, 1, nil, true);
	GameTooltip_ShowStatusBar(GameTooltip, 0, self.numAchievements, self.numCompleted, self.numCompletedText);
	GameTooltip:Show();
end

function JPHF_AchievementFrameCategories_UpdateTooltip()
	local container = JPHF_AchievementFrameCategoriesContainer;
	if ( not container:IsVisible() or not container.buttons ) then
		return;
	end
	
	for _, button in next, JPHF_AchievementFrameCategoriesContainer.buttons do
		if ( button:IsMouseOver() and button.showTooltipFunc ) then
			button:showTooltipFunc();
			break;
		end
	end
end

function JPHF_QUOI ()

end

function JPHF_AchievementFrameCategories_SelectButton (button)
	local id = button.element.id;
	if button.element.parentlevel == 0 then
		-- Is top level category (can expand/contract)
		if ( button.isSelected and button.element.collapsed == false ) then
			--Contract si resélectionner
			button.element.collapsed = true;
			for i, category in next, JPHF_ACHIEVEMENTUI_CATEGORIES do
				if ( category.parent == id ) then
					category.hidden = true;
				end
			end
		else
			for i, category in next, JPHF_ACHIEVEMENTUI_CATEGORIES do
				if ( category.parent == id ) then
					--Expand si sélectionner
					category.hidden = false;
				elseif ( category.parentlevel == 0 ) then
					category.collapsed = true;
				elseif ( category.parent ~= 0) then
					--Cache les autres
					category.hidden = true;
				end
			end
			button.element.collapsed = false;
		end
	elseif (button.element.parentlevel == 1) then
		if ( button.isSelected and button.element.collapsed == false ) then
			button.element.collapsed = true;
			for i, category in next, JPHF_ACHIEVEMENTUI_CATEGORIES do
				if ( category.parent == id and category.parentlevel == 2) then
					category.hidden = true;
				end
			end
		else
			for i, category in next, JPHF_ACHIEVEMENTUI_CATEGORIES do
				if ( category.parent == id and category.parentlevel == 2) then
					category.hidden = false;
				elseif ( category.parentlevel == 0 ) then
					category.collapsed = true;
				elseif ( category.parent and category.parentlevel == 2) then
					category.hidden = true;
				end
			end
			button.element.collapsed = false;
		end		
	end

	local buttons = JPHF_AchievementFrameCategoriesContainer.buttons;
	for _, button in next, buttons do
		button.isSelected = nil;
	end
	
	button.isSelected = true;

	
	--Intercept "summary" category
	if ( id == 1 ) then
		JPHF_AchievementFrame_ShowSubFrame(JPHF_AchievementFrameSummary);
		JPHF_Categorie_Select[JPHF_Onglet_Select] = id;
		JPHF_AchievementFrameFilterDropDown:Hide();
		JPHF_AchievementFrameHeaderLeftDDLInset:Hide();
		return;			
	else	
		JPHF_AchievementFrame_ShowSubFrame(JPHF_AchievementFrameAchievements);
		JPHF_Categorie_Select[JPHF_Onglet_Select] = id;
		JPHF_AchievementFrameFilterDropDown:Show();
		JPHF_AchievementFrameHeaderLeftDDLInset:Show();
	end
	
	if ( JPHF_AchievementFrameAchievements_ClearSelection ) then
		JPHF_AchievementFrameAchievements_ClearSelection();
	end
	JPHF_AchievementFrameAchievementsContainerScrollBar:SetValue(0);
	JPHF_AchievementFrameAchievements_Update();
end

function JPHF_AchievementFrameCategories_ClearSelection ()
	local buttons = JPHF_AchievementFrameCategoriesContainer.buttons;
	for _, button in next, buttons do
		button.isSelected = nil;
		button:UnlockHighlight();
	end
	
	for i, category in next, JPHF_ACHIEVEMENTUI_CATEGORIES do	
		if ( category.parent == true ) then
			category.collapsed = true;
		elseif ( category.parent ) then
			category.hidden = true;
		end
	end
end

function JPHF_AchievementFrameAchievements_OnShow()
	if (JPHF_Categorie_Select[JPHF_Onglet_Select] == 1 ) then
		JPHF_AchievementFrameFilterDropDown:Hide();
		JPHF_AchievementFrameHeaderLeftDDLInset:Hide();
	else
		JPHF_AchievementFrameFilterDropDown:Show();
		JPHF_AchievementFrameHeaderLeftDDLInset:Show();	
	end
	JPHF_AchievementFrameAchievementsContainerScrollBar:SetValue(0);
	JPHF_AchievementFrameAchievements_Update();
end


-- Bouton categorie

function JPHF_AchievementCategoryButton_OnLoad (button)
	button:EnableMouse(true);
	button:EnableMouseWheel(true);
end

function JPHF_AchievementCategoryButton_OnClick (button)
	JPHF_AchievementFrameCategories_SelectButton(button);
	JPHF_AchievementFrameCategories_Update();
end

--Cadre HF

function JPHF_AchievementFrameAchievements_OnLoad (self)
	JPHF_AchievementFrameAchievementsContainerScrollBar.Show = 
		function (self)
			JPHF_AchievementFrameAchievements:SetWidth(504);
			for _, button in next, JPHF_AchievementFrameAchievementsContainer.buttons do
				button:SetWidth(496);
			end
			getmetatable(self).__index.Show(self);
		end
		
	JPHF_AchievementFrameAchievementsContainerScrollBar.Hide = 
		function (self)
			JPHF_AchievementFrameAchievements:SetWidth(530);
			for _, button in next, JPHF_AchievementFrameAchievementsContainer.buttons do
				button:SetWidth(522);
			end
			getmetatable(self).__index.Hide(self);
		end
		
	self:RegisterEvent("ADDON_LOADED");
	JPHF_AchievementFrameAchievementsContainerScrollBarBG:Show();
	JPHF_AchievementFrameAchievementsContainer.update = JPHF_AchievementFrameAchievements_Update;
	HybridScrollFrame_CreateButtons(JPHF_AchievementFrameAchievementsContainer, "JPHF_AchievementTemplate", 0, -2);
end

function JPHF_AchievementFrameAchievements_OnEvent (self, event, ...)
	if ( event == "ADDON_LOADED" ) then
		self:RegisterEvent("ACHIEVEMENT_EARNED");
		self:RegisterEvent("CRITERIA_UPDATE");
		self:RegisterEvent("TRACKED_ACHIEVEMENT_LIST_CHANGED");
		
		JPHF_updateTrackedAchievements(GetTrackedAchievements());
	elseif ( event == "ACHIEVEMENT_EARNED" ) then
		local achievementID = ...;
		JPHF_AchievementFrameCategories_Update();
		JPHF_AchievementFrameCategories_UpdateTooltip();
		-- This has to happen before AchievementFrameAchievements_ForceUpdate() in order to achieve the behavior we want, since it clears the selection for progressive achievements.
		local selection = JPHF_AchievementFrameAchievements.selection;
		JPHF_AchievementFrameAchievements_ForceUpdate();
		if ( JPHF_AchievementFrameAchievementsContainer:IsShown() and selection == achievementID ) then
			JPHF_AchievementFrame_SelectAchievement(selection, true);
		end
		TotalHFPoint = JPHF_NombrePointHF()
		JPHF_AchievementFrameHeaderPoints:SetText(TotalHFPoint);
	elseif ( event == "CRITERIA_UPDATE" ) then
		if ( JPHF_AchievementFrameAchievements.selection ) then
			local id = JPHF_AchievementFrameAchievementsObjectives.id;
			local button = JPHF_AchievementFrameAchievementsObjectives:GetParent();
			JPHF_AchievementFrameAchievementsObjectives.id = nil;
			if ( self:IsVisible() ) then
				JPHF_AchievementButton_DisplayObjectives(button, id, button.completed);
				JPHF_AchievementFrameAchievements_Update();
			end
		else
			JPHF_AchievementFrameAchievementsObjectives.id = nil; -- Force redraw
		end
	elseif ( event == "TRACKED_ACHIEVEMENT_LIST_CHANGED" ) then
		local JPHF_TrackedID = select(1, ...);
		JPHF_AchievementButton_ToggleTracking(JPHF_TrackedID)
		if AchievementButton_ToggleTracking then
			AchievementButton_ToggleTracking(JPHF_TrackedID)
		end
		for k, v in next, JPHF_trackedAchievements do
			JPHF_trackedAchievements[k] = nil;
		end
		JPHF_updateTrackedAchievements(GetTrackedAchievements());
	end
end

function JPHF_AchievementFrameAchievementsBackdrop_OnLoad (self)
	self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_GOLDBORDER_R, JPHF_ACHIEVEMENTUI_GOLDBORDER_G, JPHF_ACHIEVEMENTUI_GOLDBORDER_B, JPHF_ACHIEVEMENTUI_GOLDBORDER_A);
	self:SetFrameLevel(self:GetFrameLevel()+1);
end

function JPHF_AchievementFrameAchievements_Update ()
	local category = JPHF_Categorie_Select[JPHF_Onglet_Select]
	if ( category == 1 ) then
		return;
	end
	local scrollFrame = JPHF_AchievementFrameAchievementsContainer
	
	local offset = HybridScrollFrame_GetOffset(scrollFrame);
	local buttons = scrollFrame.buttons;
	local numAchievements, numCompleted, completedOffset = JPHF_ACHIEVEMENTUI_SELECTEDFILTER(category);
	local numButtons = #buttons;
	
	local selection = JPHF_AchievementFrameAchievements.selection;
	if ( selection ) then
		JPHF_AchievementButton_ResetObjectives();
	end
	
	local extraHeight = scrollFrame.largeButtonHeight or JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT

	local achievementIndex;
	local displayedHeight = 0;
	for i = 1, numButtons do
		achievementIndex = i + offset + completedOffset;
		if ( achievementIndex > numAchievements + completedOffset ) then
			buttons[i]:Hide();
		else
			JPHF_AchievementButton_DisplayAchievement(buttons[i], category, achievementIndex, selection);
			displayedHeight = displayedHeight + buttons[i]:GetHeight();
		end
	end
	
	local totalHeight = numAchievements * JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT;
	totalHeight = totalHeight + (extraHeight - JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT);
	HybridScrollFrame_Update(scrollFrame, totalHeight, displayedHeight);

	if ( selection ) then
		JPHF_AchievementFrameAchievements.selection = selection;
	else
		HybridScrollFrame_CollapseButton(scrollFrame);
	end
end

function JPHF_AchievementFrameAchievements_ForceUpdate ()
	if ( JPHF_AchievementFrameAchievements.selection ) then
		local nextID = GetNextAchievement(JPHF_AchievementFrameAchievements.selection);
		local id, _, _, completed = GetAchievementInfo(JPHF_AchievementFrameAchievements.selection);
		if ( nextID and completed ) then
			JPHF_AchievementFrameAchievements.selection = nil;
		end
	end
	JPHF_AchievementFrameAchievementsObjectives:Hide();
	JPHF_AchievementFrameAchievementsObjectives.id = nil;

	local buttons = JPHF_AchievementFrameAchievementsContainer.buttons;
	for i, button in next, buttons do
		button.id = nil;
	end
	
	JPHF_AchievementFrameAchievements_Update();
end

function JPHF_AchievementFrameAchievements_ClearSelection ()
	JPHF_AchievementButton_ResetObjectives();
	for _, button in next, JPHF_AchievementFrameAchievementsContainer.buttons do
		button:Collapse();
		if ( not button:IsMouseOver() ) then
			button.highlight:Hide();
		end
		button.selected = nil;
		if ( not button.tracked:GetChecked() ) then
			button.tracked:Hide();
		end
		button.description:Show();
		button.hiddenDescription:Hide();
	end
	
	JPHF_AchievementFrameAchievements.selection = nil;
end

-- [[ Achievement Icon ]] --

function JPHF_AchievementIcon_Desaturate (self)
	self.bling:SetVertexColor(.6, .6, .6, 1);
	self.frame:SetVertexColor(.75, .75, .75, 1);
	self.texture:SetVertexColor(.55, .55, .55, 1);
end

function JPHF_AchievementIcon_Saturate (self)
	self.bling:SetVertexColor(1, 1, 1, 1);
	self.frame:SetVertexColor(1, 1, 1, 1);
	self.texture:SetVertexColor(1, 1, 1, 1);
end

function JPHF_AchievementIcon_OnLoad (self)
	self.Desaturate = JPHF_AchievementIcon_Desaturate;
	self.Saturate = JPHF_AchievementIcon_Saturate;
end

-- [[ Achievement Shield ]] --

function JPHF_AchievementShield_Desaturate (self)
	self.icon:SetTexCoord(.5, 1, JPHF_TEXTURES_OFFSET, JPHF_TEXTURES_OFFSET + 0.5);
end

function JPHF_AchievementShield_Saturate (self)
	self.icon:SetTexCoord(0, .5, JPHF_TEXTURES_OFFSET, JPHF_TEXTURES_OFFSET + 0.5);
end

function JPHF_AchievementShield_OnLoad (self)
	self.Desaturate = JPHF_AchievementShield_Desaturate;
	self.Saturate = JPHF_AchievementShield_Saturate;
end

-- [[ AchievementButton ]] --

JPHF_ACHIEVEMENTBUTTON_DESCRIPTIONHEIGHT = 20;
JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT = 84;
JPHF_ACHIEVEMENTBUTTON_CRITERIAROWHEIGHT = 15;
JPHF_ACHIEVEMENTBUTTON_METAROWHEIGHT = 14;
JPHF_ACHIEVEMENTBUTTON_MAXHEIGHT = 232;
JPHF_ACHIEVEMENTBUTTON_TEXTUREHEIGHT = 128;

function JPHF_AchievementButton_UpdatePlusMinusTexture (button)
	local id = button.id;
	if ( not id ) then
		return; -- This happens when we create buttons
	end

	local display = false;
	if ( GetAchievementNumCriteria(id) ~= 0 ) then
		display = true;
	end
	
	if ( display ) then
		button.plusMinus:Show();
		if ( button.collapsed and button.saturatedStyle ) then
			button.plusMinus:SetTexCoord(0, .5, JPHF_TEXTURES_OFFSET, JPHF_TEXTURES_OFFSET + 0.25);
		elseif ( button.collapsed ) then
			button.plusMinus:SetTexCoord(.5, 1, JPHF_TEXTURES_OFFSET, JPHF_TEXTURES_OFFSET + 0.25);
		elseif ( button.saturatedStyle ) then
			button.plusMinus:SetTexCoord(0, .5, JPHF_TEXTURES_OFFSET + 0.25, JPHF_TEXTURES_OFFSET + 0.50);
		else
			button.plusMinus:SetTexCoord(.5, 1, JPHF_TEXTURES_OFFSET + 0.25, JPHF_TEXTURES_OFFSET + 0.50);
		end
	else
		button.plusMinus:Hide();
	end
end

function JPHF_AchievementButton_Collapse (self)
	if ( self.collapsed ) then
		return;
	end
	
	self.collapsed = true;
	JPHF_AchievementButton_UpdatePlusMinusTexture(self);
	self:SetHeight(JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT);	
	self.background:SetTexCoord(0, 1, 1-(JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT / 256), 1);
	if ( not self.tracked:GetChecked() ) then
		self.tracked:Hide();
	end
end

function JPHF_AchievementButton_Expand (self, height)
	if ( not self.collapsed ) then
		return;
	end
	
	self.collapsed = nil;
	JPHF_AchievementButton_UpdatePlusMinusTexture(self);
	self:SetHeight(height);
	self.background:SetTexCoord(0, 1, max(0, 1-(height / 256)), 1);
end

function JPHF_AchievementButton_Saturate (self)
	self.background:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Parchment-Horizontal");
	if ( self.accountWide ) then
		self.titleBar:SetTexture("Interface\\AchievementFrame\\AccountLevel-AchievementHeader");
		self.titleBar:SetTexCoord(0, 1, 0, 0.375);
		self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_BLUEBORDER_R, JPHF_ACHIEVEMENTUI_BLUEBORDER_G, JPHF_ACHIEVEMENTUI_BLUEBORDER_B, JPHF_ACHIEVEMENTUI_BLUEBORDER_A);
		self.saturatedStyle = "account";
	else
		self.titleBar:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Borders");
		self.titleBar:SetTexCoord(0, 1, 0.66015625, 0.73828125);
		self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_REDBORDER_R, JPHF_ACHIEVEMENTUI_REDBORDER_G, JPHF_ACHIEVEMENTUI_REDBORDER_B, JPHF_ACHIEVEMENTUI_REDBORDER_A);
		self.saturatedStyle = "normal";
	end
	self.shield.points:SetVertexColor(1, 1, 1);

	self.glow:SetVertexColor(1.0, 1.0, 1.0);
	self.icon:Saturate();
	self.shield:Saturate();
	self.reward:SetVertexColor(1, .82, 0);
	self.label:SetVertexColor(1, 1, 1);
	self.description:SetTextColor(0, 0, 0, 1);
	self.description:SetShadowOffset(0, 0);
	JPHF_AchievementButton_UpdatePlusMinusTexture(self);
end

function JPHF_AchievementButton_Desaturate (self)
	self.saturatedStyle = nil;
	self.background:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Parchment-Horizontal-Desaturated");
	if ( self.accountWide ) then
		self.titleBar:SetTexture("Interface\\AchievementFrame\\AccountLevel-AchievementHeader");
		self.titleBar:SetTexCoord(0, 1, 0.40625, 0.78125);
	else
		self.titleBar:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Borders");
		self.titleBar:SetTexCoord(0, 1, 0.91796875, 0.99609375);
	end
	self.glow:SetVertexColor(.22, .17, .13);
	self.icon:Desaturate();
	self.shield:Desaturate();
	self.shield.points:SetVertexColor(.65, .65, .65);
	self.reward:SetVertexColor(.8, .8, .8);
	self.label:SetVertexColor(.65, .65, .65);
	self.description:SetTextColor(1, 1, 1, 1); 
	self.description:SetShadowOffset(1, -1);
	JPHF_AchievementButton_UpdatePlusMinusTexture(self);
	self:SetBackdropBorderColor(.5, .5, .5);
end

function JPHF_AchievementButton_OnLoad (self)
	self.dateCompleted = self.shield.dateCompleted;
	if ( not JPHF_ACHIEVEMENTUI_FONTHEIGHT ) then
		local _, fontHeight = self.description:GetFont();
		JPHF_ACHIEVEMENTUI_FONTHEIGHT = fontHeight;
	end
	self.description:SetHeight(JPHF_ACHIEVEMENTUI_FONTHEIGHT * JPHF_ACHIEVEMENTUI_MAX_LINES_COLLAPSED);
	self.description:SetWidth(JPHF_ACHIEVEMENTUI_MAXCONTENTWIDTH);			
	self.hiddenDescription:SetWidth(JPHF_ACHIEVEMENTUI_MAXCONTENTWIDTH);
	
	self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_REDBORDER_R, JPHF_ACHIEVEMENTUI_REDBORDER_G, JPHF_ACHIEVEMENTUI_REDBORDER_B, JPHF_ACHIEVEMENTUI_REDBORDER_A);
	self.Collapse = JPHF_AchievementButton_Collapse;
	self.Expand = JPHF_AchievementButton_Expand;
	self.Saturate = JPHF_AchievementButton_Saturate;
	self.Desaturate = JPHF_AchievementButton_Desaturate;
	
	self:Collapse();
end

function JPHF_AchievementButton_OnClick (self, button, down, ignoreModifiers)
	if(IsModifiedClick() and not ignoreModifiers) then
		local handled = nil;
		if ( IsModifiedClick("CHATLINK") ) then
			local achievementLink = GetAchievementLink(self.id);
			if ( ChatEdit_GetActiveWindow() and achievementLink ) then
				ChatEdit_InsertLink(achievementLink);
				handled = true;
			elseif ( SocialPostFrame and Social_IsShown() and achievementLink ) then
				Social_InsertLink(achievementLink);
				handled = true;
			end
		end
		if ( not handled and IsModifiedClick("QUESTWATCHTOGGLE") ) then
			JPHF_AchievementButton_ToggleTracking(self.id);
		end
		return;		
	end

	if ( self.selected ) then
		if ( not self:IsMouseOver() ) then
			self.highlight:Hide();
		end
		JPHF_AchievementFrameAchievements_ClearSelection()
		HybridScrollFrame_CollapseButton(JPHF_AchievementFrameAchievementsContainer);
		JPHF_AchievementFrameAchievements_Update();
		return;
	end
	JPHF_AchievementFrameAchievements_ClearSelection()
	JPHF_AchievementFrameAchievements_SelectButton(self);
	JPHF_AchievementButton_DisplayAchievement(self, JPHF_Categorie_Select[JPHF_Onglet_Select], self.index, self.id);
	HybridScrollFrame_ExpandButton(JPHF_AchievementFrameAchievementsContainer, ((self.index - 1) * JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT), self:GetHeight());
	JPHF_AchievementFrameAchievements_Update();
	if ( not ignoreModifiers ) then
		JPHF_AchievementFrameAchievements_AdjustSelection();
	end
end

function JPHF_AchievementButton_ToggleTracking (id)
	if ( JPHF_trackedAchievements[id] ) then
		RemoveTrackedAchievement(id);
		JPHF_AchievementFrameAchievements_ForceUpdate();
		return;
	end
	
	local count = GetNumTrackedAchievements();
	
	if ( count >= MAX_TRACKED_ACHIEVEMENTS ) then
		UIErrorsFrame:AddMessage(format(ACHIEVEMENT_WATCH_TOO_MANY, MAX_TRACKED_ACHIEVEMENTS), 1.0, 0.1, 0.1, 1.0);
		return;
	end
	
	local _, _, _, _, _, _, _, _, _, _, _, _, wasEarnedByMe = GetAchievementInfo(id)
	if ( wasEarnedByMe ) then
		UIErrorsFrame:AddMessage(ERR_ACHIEVEMENT_WATCH_COMPLETED, 1.0, 0.1, 0.1, 1.0);
		return;
	end
	
	AddTrackedAchievement(id);
	JPHF_AchievementFrameAchievements_ForceUpdate();
	return true;
end

function JPHF_AchievementButton_DisplayAchievement (button, category, achievement, selectionID, renderOffScreen)
	local id, name, points, completed, month, day, year, description, flags, icon, rewardText, isGuild, wasEarnedByMe, earnedBy = GetAchievementInfo(JPHF_Classement(category, achievement));
	if ( not id ) then
		button:Hide();
		return;
	else
		button:Show();
	end

	button.index = achievement;
	button.element = true;
	
	if ( button.id ~= id ) then
		local saturatedStyle;
		if ( bit.band(flags, ACHIEVEMENT_FLAGS_ACCOUNT) == ACHIEVEMENT_FLAGS_ACCOUNT ) then
			button.accountWide = true;
			saturatedStyle = "account";
		else
			button.accountWide = nil;
			saturatedStyle = "normal";
		end
		button.id = id;
		button.label:SetWidth(JPHF_ACHIEVEMENTBUTTON_LABELWIDTH);
		button.label:SetText(name)
	
		JPHF_AchievementShield_SetPoints(points, button.shield.points, AchievementPointsFont, AchievementPointsFontSmall);
		
			
		if ( points > 0 ) then
			button.shield.icon:SetTexture([[Interface\AchievementFrame\UI-Achievement-Shields]]);
		else
			button.shield.icon:SetTexture([[Interface\AchievementFrame\UI-Achievement-Shields-NoPoints]]);
		end

		
		button.shield.wasEarnedByMe = not (completed and not wasEarnedByMe);
		button.shield.earnedBy = earnedBy;
		

		button.shield.id = id;
		button.description:SetText(description);
		button.hiddenDescription:SetText(description);
		button.numLines = ceil(button.hiddenDescription:GetHeight() / JPHF_ACHIEVEMENTUI_FONTHEIGHT);
		button.icon.texture:SetTexture(icon);
		if ( completed or wasEarnedByMe ) then
			button.completed = true;
			button.dateCompleted:SetText(string.format(SHORTDATE, day, month, year));
			button.dateCompleted:Show();
			if ( button.saturatedStyle ~= saturatedStyle ) then
				button:Saturate();
			end
		else
			button.completed = nil;
			button.dateCompleted:Hide();
			button:Desaturate();
		end
		
		if ( rewardText == "" ) then
			button.reward:Hide();
			button.rewardBackground:Hide();
		else
			button.reward:SetText(rewardText);
			button.reward:Show();
			button.rewardBackground:Show();
			if ( button.completed ) then
				button.rewardBackground:SetVertexColor(1, 1, 1);
			else
				button.rewardBackground:SetVertexColor(0.35, 0.35, 0.35);
			end
		end		
		
		if ( IsTrackedAchievement(id) ) then
			button.check:Show();
			button.label:SetWidth(button.label:GetStringWidth() + 4); -- This +4 here is to fudge around any string width issues that arize from resizing a string set to its string width. See bug 144418 for an example.
			button.tracked:SetChecked(true);
			button.tracked:Show();
		else
			button.check:Hide();
			button.tracked:SetChecked(false);
			button.tracked:Hide();
		end
		
		JPHF_AchievementButton_UpdatePlusMinusTexture(button);
	end
	
	if ( id == selectionID ) then
		local achievements = JPHF_AchievementFrameAchievements;
		
		achievements.selection = button.id;
		achievements.selectionIndex = button.index;
		button.selected = true;
		button.highlight:Show();
		local height = JPHF_AchievementButton_DisplayObjectives(button, button.id, button.completed, renderOffScreen);
		if ( height == JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT ) then
			button:Collapse();
		else
			button:Expand(height);
		end
		if ( not completed or (not wasEarnedByMe and not isGuild) ) then
			button.tracked:Show();
		end
	elseif ( button.selected ) then
		button.selected = nil;
		if ( not button:IsMouseOver() ) then
			button.highlight:Hide();
		end
		button:Collapse();
		button.description:Show();
		button.hiddenDescription:Hide();
	end
	
	return id;
end

function JPHF_AchievementFrameAchievements_SelectButton (button)
	local achievements = JPHF_AchievementFrameAchievements;
	
	achievements.selection = button.id;
	achievements.selectionIndex = button.index;
	button.selected = true;
		
	SetFocusedAchievement(button.id);
end

function JPHF_AchievementButton_ResetObjectives ()
	JPHF_AchievementFrameAchievementsObjectives:Hide();
end

function JPHF_AchievementButton_DisplayObjectives (button, id, completed, renderOffScreen)
	local objectives = JPHF_AchievementFrameAchievementsObjectives;
	if (renderOffScreen) then
		objectives = JPHF_AchievementFrameAchievementsObjectivesOffScreen;
	end
	local topAnchor = button.hiddenDescription;
	objectives:ClearAllPoints();
	objectives:SetParent(button);
	objectives:Show();
	objectives.completed = completed;
	local height = JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT;
	if ( objectives.id == id and not renderOffScreen ) then
		local ACHIEVEMENTMODE_CRITERIA = 1;
		if ( objectives.mode == ACHIEVEMENTMODE_CRITERIA ) then
			if ( objectives:GetHeight() > 0 ) then
				objectives:SetPoint("TOP", topAnchor, "BOTTOM", 0, -8);
				objectives:SetPoint("LEFT", "$parentIcon", "RIGHT", -5, 0);
				objectives:SetPoint("RIGHT", "$parentShield", "LEFT", -10, 0);
			end
		else
			objectives:SetPoint("TOP", topAnchor, "BOTTOM", 0, -8);
		end
	elseif ( completed and GetPreviousAchievement(id) ) then
		objectives:SetHeight(0);
		JPHF_AchievementButton_ResetCriteria(renderOffScreen);
		JPHF_AchievementButton_ResetProgressBars(renderOffScreen);
		JPHF_AchievementButton_ResetMiniAchievements(renderOffScreen);
		JPHF_AchievementButton_ResetMetas(renderOffScreen);
		-- Don't show previous achievements when we render this offscreeen
		objectives:SetPoint("TOP", topAnchor, "BOTTOM", 0, -8);
	else
		objectives:SetHeight(0);
		JPHF_AchievementButton_ResetCriteria(renderOffScreen);
		JPHF_AchievementButton_ResetProgressBars(renderOffScreen);
		JPHF_AchievementButton_ResetMiniAchievements(renderOffScreen);
		JPHF_AchievementButton_ResetMetas(renderOffScreen);
		JPHF_AchievementObjectives_DisplayCriteria(objectives, id, renderOffScreen);
		if ( objectives:GetHeight() > 0 ) then
			objectives:SetPoint("TOP", topAnchor, "BOTTOM", 0, -8);
			objectives:SetPoint("LEFT", "$parentIcon", "RIGHT", -5, -25);
			objectives:SetPoint("RIGHT", "$parentShield", "LEFT", -10, 0);
		end
	end
	height = height + objectives:GetHeight();
	
	if ( height ~= JPHF_ACHIEVEMENTBUTTON_COLLAPSEDHEIGHT or button.numLines > JPHF_ACHIEVEMENTUI_MAX_LINES_COLLAPSED ) then
		button.hiddenDescription:Show();
		button.description:Hide();
		local descriptionHeight = button.hiddenDescription:GetHeight();
		height = height + descriptionHeight - JPHF_ACHIEVEMENTBUTTON_DESCRIPTIONHEIGHT;
		if ( button.reward:IsShown() ) then
			height = height + 4;
		end
	end
	
	-- Don't cache if we are rendering offscreen
	if (not renderOffScreen) then
		objectives.id = id;
	end
	return height;
end

function JPHF_AchievementShield_SetPoints(points, pointString, normalFont, smallFont)
	if ( points == 0 ) then
		pointString:SetText("");
		return;
	end
	if ( points < 100 ) then
		pointString:SetFontObject(normalFont);
	else
		pointString:SetFontObject(smallFont);
	end
	pointString:SetText(points);
end

function JPHF_AchievementButton_ResetTable (t)
	for k, v in next, t do
		v:Hide();
	end
end

local JPHF_criteriaTable = {}
local JPHF_criteriaTableOffScreen = {};

function JPHF_AchievementButton_ResetCriteria (renderOffScreen)
	if (renderOffScreen) then
		JPHF_AchievementFrameAchievementsObjectivesOffScreen.repCriteria:Hide();
		JPHF_AchievementButton_ResetTable(JPHF_criteriaTableOffScreen);
	else
		JPHF_AchievementFrameAchievementsObjectives.repCriteria:Hide();
		JPHF_AchievementButton_ResetTable(JPHF_criteriaTable);
	end
end

function JPHF_AchievementButton_GetCriteria (index, renderOffScreen)
	local criTable = JPHF_criteriaTable;
	local offscreenName = "";
	if (renderOffScreen) then
		criTable = JPHF_criteriaTableOffScreen;
		offscreenName = "OffScreen";
	end
	
	if ( criTable[index] ) then
		return criTable[index];
	end
	
	local frame = CreateFrame("FRAME", "JPHF_AchievementFrameCriteria" .. offscreenName .. index, JPHF_AchievementFrameAchievements, "JPHF_AchievementCriteriaTemplate");
	criTable[index] = frame;
	
	return frame;
end

-- Petite table dans WoW
local JPHF_miniTable = {}

function JPHF_AchievementButton_ResetMiniAchievements (renderOffScreen)
	-- We don't render mini achievements offscreen, so don't reset it if renderOffScreen is true
	if (not renderOffScreen) then
		JPHF_AchievementButton_ResetTable(JPHF_miniTable);
	end
end

function JPHF_AchievementButton_GetMiniAchievement (index)
	local miniTable = JPHF_miniTable;
	if ( miniTable[index] ) then
		return miniTable[index];
	end
	
	local frame = CreateFrame("FRAME", "JPHF_AchievementFrameMiniAchievement" .. index, JPHF_AchievementFrameAchievements, "JPHF_MiniAchievementTemplate");
	miniTable[index] = frame;
	
	return frame;
end

local JPHF_progressBarTable = {};
local JPHF_progressBarTableOffScreen = {};

function JPHF_AchievementButton_ResetProgressBars (renderOffScreen)
	if (renderOffScreen) then
		JPHF_AchievementButton_ResetTable(JPHF_progressBarTableOffScreen);
	else
		JPHF_AchievementButton_ResetTable(JPHF_progressBarTable);
	end
end

function JPHF_AchievementButton_GetProgressBar (index, renderOffScreen)
	local pgTable = JPHF_progressBarTable;
	local offscreenName = "";
	if (renderOffScreen) then
		pgTable = JPHF_progressBarTableOffScreen;
		offscreenName = "OffScreen";
	end
	if ( pgTable[index] ) then
		return pgTable[index];
	end
	
	local frame = CreateFrame("STATUSBAR", "JPHF_AchievementFrameProgressBar" .. offscreenName .. index, JPHF_AchievementFrameAchievements, "JPHF_AchievementProgressBarTemplate");
	pgTable[index] = frame;
	
	return frame;
end


local JPHF_metaCriteriaTable = {};
local JPHF_metaCriteriaTableOffScreen = {};

function JPHF_AchievementButton_ResetMetas (renderOffScreen)
	if (renderOffScreen) then
		JPHF_AchievementButton_ResetTable(JPHF_metaCriteriaTableOffScreen);
	else
		JPHF_AchievementButton_ResetTable(JPHF_metaCriteriaTable);
	end
end

function JPHF_AchievementButton_GetMeta (index, renderOffScreen)
	local mcTable = JPHF_metaCriteriaTable;
	local offscreenName = "";
	if (renderOffScreen) then
		mcTable = JPHF_metaCriteriaTableOffScreen;
		offscreenName = "OffScreen";
	end
	if ( not mcTable[index] ) then
		local frame = CreateFrame("BUTTON", "JPHF_AchievementFrameMeta" .. offscreenName .. index, JPHF_AchievementFrameAchievements, "JPHF_MetaCriteriaTemplate");
		mcTable[index] = frame;
	end
	return mcTable[index];
end

function JPHF_AchievementFrame_GetCategoryNumAchievements_All (categoryID)
	local numAchievements = 0
	local numCompleted = 0
	local numIncomplete = 0
	for i = 1, #JPHF_HF[JPHF_Onglet_Select][categoryID] do
		_, _, _, JPHF_Complet = GetAchievementInfo(JPHF_HF[JPHF_Onglet_Select][categoryID][i])
		numAchievements = numAchievements + 1
		if (JPHF_Complet) then
			numCompleted = numCompleted + 1
		else
			numIncomplete = numIncomplete + 1
		end
	end		
	return numAchievements, numCompleted, 0;
end

function JPHF_AchievementFrame_GetCategoryNumAchievements_Complete (categoryID)
	local numAchievements = 0
	local numCompleted = 0
	local numIncomplete = 0

	for i = 1, #JPHF_HF[JPHF_Onglet_Select][categoryID] do
		_, _, _, JPHF_Complet = GetAchievementInfo(JPHF_HF[JPHF_Onglet_Select][categoryID][i])
		numAchievements = numAchievements + 1
		if (JPHF_Complet) then
			numCompleted = numCompleted + 1
		else
			numIncomplete = numIncomplete + 1
		end
	end	
	
	return numCompleted, numCompleted, 0;
end

function JPHF_AchievementFrame_GetCategoryNumAchievements_Incomplete (categoryID)
	local numAchievements = 0
	local numCompleted = 0
	local numIncomplete = 0

	for i = 1, #JPHF_HF[JPHF_Onglet_Select][categoryID] do
		_, _, _, JPHF_Complet = GetAchievementInfo(JPHF_HF[JPHF_Onglet_Select][categoryID][i])
		numAchievements = numAchievements + 1
		if (JPHF_Complet) then
			numCompleted = numCompleted + 1
		else
			numIncomplete = numIncomplete + 1
		end
	end	
	
	return numIncomplete, 0, numAchievements-numIncomplete;
end

JPHF_ACHIEVEMENTUI_SELECTEDFILTER = JPHF_AchievementFrame_GetCategoryNumAchievements_All;

JPHF_AchievementFrameFilters = { {text=ACHIEVEMENTFRAME_FILTER_ALL, func= JPHF_AchievementFrame_GetCategoryNumAchievements_All},
 {text=ACHIEVEMENTFRAME_FILTER_COMPLETED, func=JPHF_AchievementFrame_GetCategoryNumAchievements_Complete},
{text=ACHIEVEMENTFRAME_FILTER_INCOMPLETE, func=JPHF_AchievementFrame_GetCategoryNumAchievements_Incomplete} };

function JPHF_AchievementFrameFilterDropDown_OnLoad (self)
	self.relativeTo = "JPHF_AchievementFrameFilterDropDown"
	self.xOffset = -14;
	self.yOffset = 10;
	UIDropDownMenu_Initialize(self, JPHF_AchievementFrameFilterDropDown_Initialize);
end

function JPHF_AchievementFrameFilterDropDown_Initialize (self)
	local info = UIDropDownMenu_CreateInfo();
	for i, filter in ipairs(JPHF_AchievementFrameFilters) do
		info.text = filter.text;
		info.value = i;
		info.func = JPHF_AchievementFrameFilterDropDownButton_OnClick;
		info.tooltipOnButton = 1;
		info.tooltipTitle = ACHIEVEMENT_FILTER_TITLE;
		info.tooltipText = JPHF_AchievementFrameFilterStrings[i];
		if ( filter.func == JPHF_ACHIEVEMENTUI_SELECTEDFILTER ) then
			info.checked = 1;
			UIDropDownMenu_SetText(self, filter.text);
			self.value =  i;
		else
			info.checked = nil;
		end
		UIDropDownMenu_AddButton(info);
	end
end

function JPHF_AchievementFrameFilterDropDownButton_OnClick (self)
	JPHF_AchievementFrame_SetFilter(self.value);
end

function JPHF_AchievementFrame_SetFilter(value)
	local func = JPHF_AchievementFrameFilters[value].func;
	if ( func ~= JPHF_ACHIEVEMENTUI_SELECTEDFILTER ) then
		JPHF_ACHIEVEMENTUI_SELECTEDFILTER = func;
		UIDropDownMenu_SetText(JPHF_AchievementFrameFilterDropDown, JPHF_AchievementFrameFilters[value].text)
		JPHF_AchievementFrameAchievementsContainerScrollBar:SetValue(0);
		JPHF_AchievementFrameAchievements_ForceUpdate();
		JPHF_AchievementFrameFilterDropDown.value = value;
	end
end

function JPHF_AchievementObjectives_DisplayCriteria (objectivesFrame, id, renderOffScreen)
	if ( not id ) then
		return;
	end

	local initialOffset = 0;
	local ACHIEVEMENTMODE_CRITERIA = 1;
	local numRows = 0;
	local extraRows = 0;
	

	local numCriteria = GetAchievementNumCriteria(id);	
	if ( numCriteria == 0 ) then
		objectivesFrame.mode = ACHIEVEMENTMODE_CRITERIA;
		objectivesFrame:SetHeight(0);
		return;
	end
	
	-- text check width
	if ( not objectivesFrame.textCheckWidth ) then
		local criteria = JPHF_AchievementButton_GetCriteria(1, renderOffScreen);
		criteria.name:SetText("- ");
		objectivesFrame.textCheckWidth = criteria.name:GetStringWidth();
	end
	
	local frameLevel = objectivesFrame:GetFrameLevel() + 1;
	
	-- Why textStrings? You try naming anything just "string" and see how happy you are.
	local textStrings, progressBars, metas = 0, 0, 0;
	
	local maxCriteriaWidth = 0;
	local yPos;
	for i = 1, numCriteria do	
		local criteriaString, criteriaType, completed, quantity, reqQuantity, charName, flags, assetID, quantityString = GetAchievementCriteriaInfo(id, i);
		
		if ( criteriaType == CRITERIA_TYPE_ACHIEVEMENT and assetID ) then
			metas = metas + 1;
			local metaCriteria = JPHF_AchievementButton_GetMeta(metas, renderOffScreen);
			
			if ( metas == 1 ) then
				metaCriteria:SetPoint("TOP", objectivesFrame, "TOP", 0, -4 + initialOffset);
				numRows = numRows + 2;
			elseif ( math.fmod(metas, 2) == 0 ) then
				yPos = -((metas/2 - 1) * 28) - 8;
				JPHF_AchievementButton_GetMeta(metas-1, renderOffScreen):SetPoint("TOPLEFT", objectivesFrame, "TOPLEFT", 20, yPos + initialOffset);
				metaCriteria:SetPoint("TOPLEFT", objectivesFrame, "TOPLEFT", 210, yPos + initialOffset);
			else
				metaCriteria:SetPoint("TOPLEFT", objectivesFrame, "TOPLEFT", 20, -(math.ceil(metas/2 - 1) * 28) - 8 + initialOffset);
				numRows = numRows + 2;
			end
			
			local id, achievementName, points, achievementCompleted, month, day, year, description, flags, iconpath = GetAchievementInfo(assetID);
			
			if ( month ) then
				metaCriteria.date = string.format(SHORTDATE, day, month, year);
			else
				metaCriteria.date = nil;
			end
			
			metaCriteria.id = id;
			metaCriteria.label:SetText(achievementName);
			metaCriteria.icon:SetTexture(iconpath);

			-- have to check if criteria is completed here, can't just check if achievement is completed.
			-- This is because the criteria could have modifiers on it that prevent completion even though the achievement is earned.
			if ( objectivesFrame.completed and completed ) then
				metaCriteria.check:Show();
				metaCriteria.border:SetVertexColor(1, 1, 1, 1);
				metaCriteria.icon:SetVertexColor(1, 1, 1, 1);
				metaCriteria.label:SetShadowOffset(0, 0)
				metaCriteria.label:SetTextColor(0, 0, 0, 1);
			elseif ( completed ) then
				metaCriteria.check:Show();
				metaCriteria.border:SetVertexColor(1, 1, 1, 1);
				metaCriteria.icon:SetVertexColor(1, 1, 1, 1);
				metaCriteria.label:SetShadowOffset(1, -1)
				metaCriteria.label:SetTextColor(0, 1, 0, 1);
			else
				metaCriteria.check:Hide();
				metaCriteria.border:SetVertexColor(.75, .75, .75, 1);
				metaCriteria.icon:SetVertexColor(.55, .55, .55, 1);
				metaCriteria.label:SetShadowOffset(1, -1)
				metaCriteria.label:SetTextColor(.6, .6, .6, 1);
			end
			
			metaCriteria:SetParent(objectivesFrame);
			metaCriteria:Show();
		elseif ( bit.band(flags, EVALUATION_TREE_FLAG_PROGRESS_BAR) == EVALUATION_TREE_FLAG_PROGRESS_BAR ) then
			-- Display this criteria as a progress bar!
			progressBars = progressBars + 1;
			local progressBar = JPHF_AchievementButton_GetProgressBar(progressBars, renderOffScreen);
			
			if ( progressBars == 1 ) then
				progressBar:SetPoint("TOP", objectivesFrame, "TOP", 4, -4 + initialOffset);
			else
				progressBar:SetPoint("TOP", JPHF_AchievementButton_GetProgressBar(progressBars-1, renderOffScreen), "BOTTOM", 0, 0);
			end
			
			progressBar.text:SetText(string.format("%s", quantityString));
			progressBar:SetMinMaxValues(0, reqQuantity);
			progressBar:SetValue(quantity);
			
			progressBar:SetParent(objectivesFrame);
			progressBar:Show();
			
			numRows = numRows + 1;
		else
			textStrings = textStrings + 1;
			local criteria = JPHF_AchievementButton_GetCriteria(textStrings, renderOffScreen);
			criteria:ClearAllPoints();
			if ( textStrings == 1 ) then
				if ( numCriteria == 1 ) then
					criteria:SetPoint("TOP", objectivesFrame, "TOP", -14, initialOffset);
				else
					criteria:SetPoint("TOPLEFT", objectivesFrame, "TOPLEFT", 0, initialOffset);
				end
				
			else
				criteria:SetPoint("TOPLEFT", JPHF_AchievementButton_GetCriteria(textStrings-1, renderOffScreen), "BOTTOMLEFT", 0, 0);
			end
			
			if ( objectivesFrame.completed and completed ) then
				criteria.name:SetTextColor(0, 0, 0, 1);
				criteria.name:SetShadowOffset(0, 0);
			elseif ( completed ) then
				criteria.name:SetTextColor(0, 1, 0, 1);
				criteria.name:SetShadowOffset(1, -1);
			else
				criteria.name:SetTextColor(.6, .6, .6, 1);
				criteria.name:SetShadowOffset(1, -1);
			end
			
			local stringWidth = 0;
			local maxCriteriaContentWidth;
			if ( completed ) then
				maxCriteriaContentWidth = JPHF_ACHIEVEMENTUI_MAXCONTENTWIDTH - JPHF_ACHIEVEMENTUI_CRITERIACHECKWIDTH;
				criteria.check:SetPoint("LEFT", 18, -3);
				criteria.name:SetPoint("LEFT", criteria.check, "RIGHT", 0, 2);
				criteria.check:Show();
				criteria.name:SetText(criteriaString);
				stringWidth = min(criteria.name:GetStringWidth(),maxCriteriaContentWidth);
			else
				maxCriteriaContentWidth = JPHF_ACHIEVEMENTUI_MAXCONTENTWIDTH - objectivesFrame.textCheckWidth;
				criteria.check:SetPoint("LEFT", 0, -3);
				criteria.name:SetPoint("LEFT", criteria.check, "RIGHT", 5, 2);
				criteria.check:Hide();
				criteria.name:SetText("- "..criteriaString);
				stringWidth = min(criteria.name:GetStringWidth() - objectivesFrame.textCheckWidth,maxCriteriaContentWidth);	-- don't want the "- " to be included in the width
			end
			if ( criteria.name:GetWidth() > maxCriteriaContentWidth ) then
				criteria.name:SetWidth(maxCriteriaContentWidth);
			end
			criteria:SetParent(objectivesFrame);
			criteria:Show();
			criteria:SetWidth(stringWidth + JPHF_ACHIEVEMENTUI_CRITERIACHECKWIDTH);
			maxCriteriaWidth = max(maxCriteriaWidth, stringWidth + JPHF_ACHIEVEMENTUI_CRITERIACHECKWIDTH);

			numRows = numRows + 1;
		end
	end

	if ( textStrings > 0 and progressBars > 0 ) then
		-- If we have text criteria and progressBar criteria, display the progressBar criteria first and position the textStrings under them.
		local criTable = JPHF_AchievementButton_GetCriteria(1, renderOffScreen);
		criTable:ClearAllPoints();
		if ( textStrings == 1 ) then
			criTable:SetPoint("TOP", JPHF_AchievementButton_GetProgressBar(progressBars, renderOffScreen), "BOTTOM", -14, -4);
		else
			criTable:SetPoint("TOP", JPHF_AchievementButton_GetProgressBar(progressBars, renderOffScreen), "BOTTOM", 0, -4);
			criTable:SetPoint("LEFT", objectivesFrame, "LEFT", 0, 0);
		end		
	elseif ( textStrings > 1 ) then
		-- Figure out if we can make multiple columns worth of criteria instead of one long one
		local numColumns = floor(JPHF_ACHIEVEMENTUI_MAXCONTENTWIDTH/maxCriteriaWidth);
		-- But if we have a lot of criteria, force 2 columns
		local forceColumns = false;
		if ( numColumns == 1 and textStrings >= JPHF_FORCE_COLUMNS_MIN_CRITERIA and maxCriteriaWidth <= JPHF_FORCE_COLUMNS_MAX_WIDTH ) then
			numColumns = 2;
			forceColumns = true;
			-- if top right criteria would run into the achievement shield, move them all down 1 row
			-- this assumes description is 1 or 2 lines, otherwise this wouldn't be a problem
			if ( JPHF_AchievementButton_GetCriteria(2, renderOffScreen).name:GetStringWidth() > JPHF_FORCE_COLUMNS_RIGHT_COLUMN_SPACE and progressBars == 0 ) then
				initialOffset = initialOffset - JPHF_AchievementButton_GetCriteria(2, renderOffScreen):GetHeight();
				extraRows = extraRows + 1;
			end
		end	
		if ( numColumns > 1 ) then
			local step;
			local rows = 1;
			local position = 0;
			local criTable = JPHF_criteriaTable;
			if (renderOffScreen) then
				criTable = criteriaTableOffScreen;
			end
			for i=1, #criTable do
				position = position + 1;
				if ( position > numColumns ) then
					position = position - numColumns;
					rows = rows + 1;
				end
				
				if ( rows == 1 ) then
					criTable[i]:ClearAllPoints();
					local xOffset = 0;
					if ( forceColumns ) then
						if ( position == 1 ) then
							xOffset = JPHF_FORCE_COLUMNS_LEFT_OFFSET;
						elseif ( position == 2 ) then
							xOffset = JPHF_FORCE_COLUMNS_RIGHT_OFFSET;
						end
					end
					criTable[i]:SetPoint("TOPLEFT", objectivesFrame, "TOPLEFT", (position - 1)*(JPHF_ACHIEVEMENTUI_MAXCONTENTWIDTH/numColumns) + xOffset, initialOffset);
				else
					criTable[i]:ClearAllPoints();
					criTable[i]:SetPoint("TOPLEFT", criTable[position + ((rows - 2) * numColumns)], "BOTTOMLEFT", 0, 0);
				end
			end
			numRows = ceil(numRows/numColumns);
		end
	end

	numRows = numRows + extraRows;
	if ( metas > 0 or progressBars > 0 ) then
		objectivesFrame:SetHeight(numRows * JPHF_ACHIEVEMENTBUTTON_METAROWHEIGHT + 10);
	else
		objectivesFrame:SetHeight(numRows * JPHF_ACHIEVEMENTBUTTON_CRITERIAROWHEIGHT);
	end
	objectivesFrame.mode = ACHIEVEMENTMODE_CRITERIA;
end

-- Cadre Sommaire
function JPHF_AchievementFrameSummary_OnShow()
	local tCategories;
	tCategories = JPHF_ACHIEVEMENTUI_SUMMARYCATEGORIES[JPHF_Onglet_Select]
	for i = 1, JPHF_ACHIEVEMENTUI_MAX_SUMMARY_ACHIEVEMENTS do
		local button = _G["JPHF_AchievementFrameSummaryAchievement"..i];
		if (button) then
			button.icon.frame:SetTexture("Interface\\AchievementFrame\\UI-Achievement-IconFrame");
			button.icon.frame:SetTexCoord(0, 0.5625, 0, 0.5625);
			button.icon.frame:SetPoint("CENTER", -1, 2);
			button.glow:SetTexCoord(0, 1, 0.00390625, 0.25390625);
			button.titleBar:SetAlpha(0.5);
		end
	end	

	for i = 1, 12 do
		local statusBar = _G["JPHF_AchievementFrameSummaryCategoriesCategory"..i];
		if ( tCategories[i] ) then
			local categoryName = JPHF_Categorie[JPHF_Onglet_Select][tCategories[i]].name
			statusBar.label:SetText(categoryName);
			statusBar:Show();
			statusBar:SetID(tCategories[i]);
			JPHF_AchievementFrameSummaryCategory_OnShow(statusBar);	-- to calculate progress
		else
			statusBar:SetID(2)
			statusBar:Hide();
		end
	end	

	JPHF_AchievementFrameSummary:SetWidth(530);
	JPHF_AchievementFrameSummary_Update();
end

function JPHF_AchievementFrameSummary_Update()
	JPHF_AchievementFrameSummaryCategoriesStatusBar_Update();
	JPHF_AchievementFrameSummary_UpdateAchievements(JPHF_AchievementDernierTerminer());
end

function JPHF_AchievementFrameSummary_UpdateAchievements(JPHF_HFRecent)
	local numAchievements = #JPHF_HFRecent;
	local id, name, points, completed, month, day, year, description, flags, icon, rewardText, isGuild, wasEarnedByMe, earnedBy;
	local buttons = JPHF_AchievementFrameSummaryAchievements.buttons;
	local button, anchorTo, achievementID;
	local defaultAchievementCount = 1;
	for i=1, JPHF_ACHIEVEMENTUI_MAX_SUMMARY_ACHIEVEMENTS do
		if ( buttons ) then
			button = buttons[i];
		end
		if ( not button ) then
			button = CreateFrame("Button", "JPHF_AchievementFrameSummaryAchievement"..i, JPHF_AchievementFrameSummaryAchievements, "JPHF_SummaryAchievementTemplate");
			if ( i == 1 ) then
				button:SetPoint("TOPLEFT",JPHF_AchievementFrameSummaryAchievementsHeader, "BOTTOMLEFT", 18, 2 );
				button:SetPoint("TOPRIGHT",JPHF_AchievementFrameSummaryAchievementsHeader, "BOTTOMRIGHT", -18, 2 );
			else
				anchorTo = _G["JPHF_AchievementFrameSummaryAchievement"..i-1];
				button:SetPoint("TOPLEFT",anchorTo, "BOTTOMLEFT", 0, 3 );
				button:SetPoint("TOPRIGHT",anchorTo, "BOTTOMRIGHT", 0, 3 );
			end
			if ( not buttons ) then
				buttons = JPHF_AchievementFrameSummaryAchievements.buttons;
			end
			button.isSummary = true;
		end;
		
		if ( i <= numAchievements ) then
			achievementID = JPHF_HFRecent[i];
			id, name, points, completed, month, day, year, description, flags, icon, rewardText, isGuild, wasEarnedByMe, earnedBy = GetAchievementInfo(achievementID);

			local saturatedStyle;
			if ( bit.band(flags, ACHIEVEMENT_FLAGS_ACCOUNT) == ACHIEVEMENT_FLAGS_ACCOUNT ) then
				button.accountWide = true;
				saturatedStyle = "account";
			else
				button.accountWide = nil;
				saturatedStyle = "normal";
			end

			button.label:SetText(name);
			button.description:SetText(description);
			JPHF_AchievementShield_SetPoints(points, button.shield.points, GameFontNormal, GameFontNormalSmall);
			if ( points > 0 ) then
				button.shield.icon:SetTexture([[Interface\AchievementFrame\UI-Achievement-Shields]]);
			else
				button.shield.icon:SetTexture([[Interface\AchievementFrame\UI-Achievement-Shields-NoPoints]]);
			end

			button.shield.wasEarnedByMe = not (completed and not wasEarnedByMe);
			button.shield.earnedBy = earnedBy;
			
			button.icon.texture:SetTexture(icon);
			button.id = id;

			if ( completed ) then
				button.dateCompleted:SetText(string.format(SHORTDATE, day, month, year));
			else
				button.dateCompleted:SetText("");
			end
			
			if ( button.saturatedStyle ~= saturatedStyle ) then
				button:Saturate();
			end
			button.tooltipTitle = nil;
			button:Show();
		else
--			local tAchievements;
--			if ( IN_GUILD_VIEW ) then
	--			tAchievements = ACHIEVEMENTUI_DEFAULTGUILDSUMMARYACHIEVEMENTS;
		--	else
			--	tAchievements = ACHIEVEMENTUI_DEFAULTSUMMARYACHIEVEMENTS;
			--end
	--		for i=defaultAchievementCount, ACHIEVEMENTUI_MAX_SUMMARY_ACHIEVEMENTS do
	--			achievementID = tAchievements[defaultAchievementCount];
	--			if ( not achievementID ) then
	--				break;
	--			end
	--			id, name, points, completed, month, day, year, description, flags, icon, rewardText, isGuild, wasEarnedByMe, earnedBy = GetAchievementInfo(achievementID);
	--			if ( completed ) then
	--				defaultAchievementCount = defaultAchievementCount+1;
	--			else
	--				button.label:SetText(name);
	--				button.description:SetText(description);
	--				AchievementShield_SetPoints(points, button.shield.points, GameFontNormal, GameFontNormalSmall);
	--				if ( points > 0 ) then
	--					button.shield.icon:SetTexture([[Interface\AchievementFrame\UI-Achievement-Shields]]);
	--				else
	--					button.shield.icon:SetTexture([[Interface\AchievementFrame\UI-Achievement-Shields-NoPoints]]);
	--				end
	--				button.shield.wasEarnedByMe = not (completed and not wasEarnedByMe);
	--				button.shield.earnedBy = earnedBy;
	--				button.icon.texture:SetTexture(icon);
	--				button.id = id;
	--				if ( month ) then
	--					button.dateCompleted:SetText(string.format(SHORTDATE, day, month, year));
	--				else
	--					button.dateCompleted:SetText("");
	--				end
	--				button:Show();
	--				defaultAchievementCount = defaultAchievementCount+1;
	--				button:Desaturate();
	--				button.tooltipTitle = SUMMARY_ACHIEVEMENT_INCOMPLETE;
	--				button.tooltip = SUMMARY_ACHIEVEMENT_INCOMPLETE_TEXT;
	--				break;
	--			end 
				
	--		end ]]--
			button:Hide();
		end
	end
	if ( numAchievements == 0 ) then
		JPHF_AchievementFrameSummaryAchievementsEmptyText:Show();
	else
		JPHF_AchievementFrameSummaryAchievementsEmptyText:Hide();
	end
end

function JPHF_AchievementFrameSummaryCategoriesStatusBar_Update()
	local total, completed;
	
	total = #JPHF_HF_Total[JPHF_Onglet_Select]
	completed = 0
	for i = 1, total do
		_, _, _, hfcompleted = GetAchievementInfo(JPHF_HF_Total[JPHF_Onglet_Select][i])
		if (hfcompleted) then
			completed = completed + 1
		end
	end	
	JPHF_AchievementFrameSummaryCategoriesStatusBar:SetMinMaxValues(0, total);
	JPHF_AchievementFrameSummaryCategoriesStatusBar:SetValue(completed);
	JPHF_AchievementFrameSummaryCategoriesStatusBarText:SetText(completed.."/"..total);
end

function JPHF_AchievementFrameSummaryAchievement_OnLoad(self)
	JPHF_AchievementComparisonPlayerButton_OnLoad(self);
	JPHF_AchievementFrameSummaryAchievements.buttons = JPHF_AchievementFrameSummaryAchievements.buttons or {};
	tinsert(JPHF_AchievementFrameSummaryAchievements.buttons, self);
	self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_REDBORDER_R, JPHF_ACHIEVEMENTUI_REDBORDER_G, JPHF_ACHIEVEMENTUI_REDBORDER_B, 0.5);
	self.titleBar:SetVertexColor(1,1,1,0.5);
	self.dateCompleted:Show();
end

function JPHF_AchievementFrameSummaryAchievement_OnClick(self)
	local id = self.id
	if ( IsModifiedClick("CHATLINK") ) then
		local achievementLink = GetAchievementLink(self.id);
		if ( ChatEdit_GetActiveWindow() and achievementLink ) then
			ChatEdit_InsertLink(achievementLink);
			return;
		elseif ( SocialPostFrame and Social_IsShown() and achievementLink ) then
			Social_InsertLink(achievementLink);
			return;
		end
	end
	
	JPHF_AchievementFrame_SelectAchievement(id);
end

function JPHF_AchievementFrameSummary_OnLoad(self)
	JPHF_AchievementFrameSummary_OnShow();
end

function JPHF_AchievementFrameSummaryAchievement_OnEnter(self)
	self.highlight:Show();
	if ( self.tooltipTitle ) then
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:SetText(self.tooltipTitle,1,1,1);
		GameTooltip:AddLine(self.tooltip, nil, nil, nil, true);
		GameTooltip:Show();
	end
end

function JPHF_AchievementFrameSummaryCategoryButton_OnClick (self)
	local id = self:GetParent():GetID();
	for _, button in next, JPHF_AchievementFrameCategoriesContainer.buttons do
		if ( button.categoryID == id ) then
			button:Click();
			return;
		end
	end
end

function JPHF_AchievementFrameSummaryCategory_OnLoad (self)
	self:SetMinMaxValues(0, 100);
	self:SetValue(0);
	local categoryName = "Oups";
	self.label:SetText(categoryName);
end

function JPHF_AchievementFrame_GetCategoryTotalNumAchievements (id)
	-- Not recursive because we only have one deep and this saves time.
	local totalAchievements, totalCompleted = 0, 0;
	local numAchievements, numCompleted = JPHF_AchievementFrame_GetCategoryNumAchievements_All(id);
	totalAchievements = totalAchievements + numAchievements;
	totalCompleted = totalCompleted + numCompleted;

	
	for i = 1, #JPHF_Categorie[JPHF_Onglet_Select] do
		if (id	== JPHF_Categorie[JPHF_Onglet_Select][i].parent) then
			numAchievements, numCompleted = JPHF_AchievementFrame_GetCategoryNumAchievements_All (JPHF_Categorie[JPHF_Onglet_Select][i].id)
			totalAchievements = totalAchievements + numAchievements
			totalCompleted = totalCompleted + numCompleted
			for j = 1, #JPHF_Categorie[JPHF_Onglet_Select] do
				if (JPHF_Categorie[JPHF_Onglet_Select][i].id == JPHF_Categorie[JPHF_Onglet_Select][j].parent) then
					numAchievements, numCompleted = JPHF_AchievementFrame_GetCategoryNumAchievements_All (JPHF_Categorie[JPHF_Onglet_Select][j].id)
					totalAchievements = totalAchievements + numAchievements
					totalCompleted = totalCompleted + numCompleted
				end
			end
		end
	end	
	
	return totalAchievements, totalCompleted;
end

function JPHF_AchievementFrameSummaryCategory_OnEvent (self, event, ...)
	JPHF_AchievementFrameSummaryCategory_OnShow(self);
end

function JPHF_AchievementFrameSummaryCategory_OnShow (self)

	local totalAchievements, totalCompleted = JPHF_AchievementFrame_GetCategoryTotalNumAchievements(self:GetID());
	
	self.text:SetText(string.format("%d/%d", totalCompleted, totalAchievements));
	self:SetMinMaxValues(0, totalAchievements);
	self:SetValue(totalCompleted);
	self:RegisterEvent("ACHIEVEMENT_EARNED");
end

function JPHF_AchievementFrameSummaryCategory_OnHide (self)
	self:UnregisterEvent("ACHIEVEMENT_EARNED");
end

function JPHF_AchievementFrame_SelectAchievement(id, forceSelect)
	if ( not JPHF_AchievementFrame:IsShown() and not forceSelect ) then
		return;
	end
	
	local _, _, _, achCompleted, _, _, _, _, flags = GetAchievementInfo(id);
	if ( achCompleted and (JPHF_ACHIEVEMENTUI_SELECTEDFILTER == JPHF_AchievementFrameFilters[JPHF_ACHIEVEMENT_FILTER_INCOMPLETE].func) ) then
		JPHF_AchievementFrame_SetFilter(JPHF_ACHIEVEMENT_FILTER_ALL);
	elseif ( (not achCompleted) and (JPHF_ACHIEVEMENTUI_SELECTEDFILTER == JPHF_AchievementFrameFilters[JPHF_ACHIEVEMENT_FILTER_COMPLETE].func) ) then
		JPHF_AchievementFrame_SetFilter(JPHF_ACHIEVEMENT_FILTER_ALL);
	end
	
	local tabIndex = 1;
	local category, tabIndex = JPHF_TrouverCategorie_HF(id, JPHF_Onglet_Select);
	if category == 50000000 then
		JPHF_MSG("Bug  1906")
	end
	
	JPHF_AchievementFrameSummary:Hide();
	JPHF_AchievementFrameAchievements:Show();

	JPHF_AchievementFrameCategories_ClearSelection();
		
	JPHF_Categorie_Select[tabIndex] = category;
	

	
	JPHF_AchievementFrameTab_OnClick(tabIndex)
	JPHF_AchievementFrameCategoriesContainerScrollBar:SetValue(0);
	JPHF_AchievementFrameCategories_Update();
	
	local shown = false;
	while ( not shown ) do
		for _, button in next, JPHF_AchievementFrameCategoriesContainer.buttons do
			if ( button.categoryID == category and math.ceil(button:GetBottom()) >= math.ceil(JPHF_AchievementFrameAchievementsContainer:GetBottom())) then
				shown = true;
			end
		end
		
		if ( not shown ) then
			local _, maxVal = JPHF_AchievementFrameCategoriesContainerScrollBar:GetMinMaxValues();
			if ( JPHF_AchievementFrameCategoriesContainerScrollBar:GetValue() == maxVal ) then
				--assert(false)
				return;
			else
				HybridScrollFrame_OnMouseWheel(JPHF_AchievementFrameCategoriesContainer, -1);
			end			
		end
	end		
	
	local container, scrollBar = JPHF_AchievementFrameAchievementsContainer, JPHF_AchievementFrameAchievementsContainerScrollBar;

	
	JPHF_AchievementFrameAchievements_ClearSelection();
	JPHF_AchievementFrameAchievements_Update();
	scrollBar:SetValue(0);
	
	local shown = false;
	local previousScrollValue;
	while ( not shown ) do
		for _, button in next, container.buttons do
			if ( button.id == id and math.ceil(button:GetTop()) >= math.ceil(container:GetBottom())) then
				-- The "True" here ignores modifiers, so you don't accidentally track or link this achievement. :P
				JPHF_AchievementButton_OnClick(button, nil, nil, true)
				
				-- We found the button!
				shown = button;
				break;
			end
		end			
		
		local _, maxVal = scrollBar:GetMinMaxValues();
		if ( shown ) then
			-- If we can, move the achievement we're scrolling to to the top of the screen.
			local newHeight = scrollBar:GetValue() + container:GetTop() - shown:GetTop();
			newHeight = min(newHeight, maxVal);
			scrollBar:SetValue(newHeight);
		else
			local scrollValue = scrollBar:GetValue();
			if ( scrollValue == maxVal or scrollValue == previousScrollValue ) then
				--assert(false, "Failed to find achievement " .. id .. " while jumping!")
				return;
			else
				previousScrollValue = scrollValue;
				HybridScrollFrame_OnMouseWheel(container, -1);
			end			
		end
	end
end

function JPHF_AchievementFrameAchievements_FindSelection()
	local _, maxVal = JPHF_AchievementFrameAchievementsContainerScrollBar:GetMinMaxValues();
	local scrollHeight = JPHF_AchievementFrameAchievementsContainer:GetHeight();
	local newHeight = 0;
	JPHF_AchievementFrameAchievementsContainerScrollBar:SetValue(0);	
	while ( true ) do
		for _, button in next, JPHF_AchievementFrameAchievementsContainer.buttons do
			if ( button.selected ) then
				newHeight = JPHF_AchievementFrameAchievementsContainerScrollBar:GetValue() + JPHF_AchievementFrameAchievementsContainer:GetTop() - button:GetTop();
				newHeight = min(newHeight, maxVal);
				JPHF_AchievementFrameAchievementsContainerScrollBar:SetValue(newHeight);					
				return;
			end
		end		
		if ( JPHF_AchievementFrameAchievementsContainerScrollBar:GetValue() == maxVal ) then		
			return;
		else
			newHeight = newHeight + scrollHeight;
			newHeight = min(newHeight, maxVal);
			JPHF_AchievementFrameAchievementsContainerScrollBar:SetValue(newHeight);
		end
	end
end

function JPHF_AchievementFrameAchievements_AdjustSelection()
	local selectedButton;	
	-- check if selection is visible
	for _, button in next, JPHF_AchievementFrameAchievementsContainer.buttons do
		if ( button.selected ) then
			selectedButton = button;
			break;
		end
	end	
	
	if ( not selectedButton ) then
		JPHF_AchievementFrameAchievements_FindSelection();
	else
		local newHeight;
		if ( selectedButton:GetTop() > JPHF_AchievementFrameAchievementsContainer:GetTop() ) then
			newHeight = JPHF_AchievementFrameAchievementsContainerScrollBar:GetValue() + JPHF_AchievementFrameAchievementsContainer:GetTop() - selectedButton:GetTop();
		elseif ( selectedButton:GetBottom() < JPHF_AchievementFrameAchievementsContainer:GetBottom() ) then
			if ( selectedButton:GetHeight() > JPHF_AchievementFrameAchievementsContainer:GetHeight() ) then
				newHeight = JPHF_AchievementFrameAchievementsContainerScrollBar:GetValue() + JPHF_AchievementFrameAchievementsContainer:GetTop() - selectedButton:GetTop();
			else
				newHeight = JPHF_AchievementFrameAchievementsContainerScrollBar:GetValue() + JPHF_AchievementFrameAchievementsContainer:GetBottom() - selectedButton:GetBottom();
			end
		end
		if ( newHeight ) then
			local _, maxVal = JPHF_AchievementFrameAchievementsContainerScrollBar:GetMinMaxValues();
			newHeight = min(newHeight, maxVal);
			JPHF_AchievementFrameAchievementsContainerScrollBar:SetValue(newHeight);					
		end
	end
end

function JPHF_AchievementMeta_OnEnter(self)
	if ( self.date ) then
		GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
		GameTooltip:AddLine(string.format(ACHIEVEMENT_META_COMPLETED_DATE, self.date), 1, 1, true);
		GameTooltip:Show();
	end
end

function JPHF_AchievementMeta_OnLeave(self)
	GameTooltip:Hide();
end

function JPHF_AchievementShield_OnEnter(self)
	local parent = self:GetParent();
	GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
	if ( parent.accountWide ) then
		if ( parent.completed ) then
			GameTooltip:AddLine(ACCOUNT_WIDE_ACHIEVEMENT_COMPLETED);
		else
			GameTooltip:AddLine(ACCOUNT_WIDE_ACHIEVEMENT);
		end
		GameTooltip:Show();
		return;
	end
	if ( self.earnedBy ) then
		GameTooltip:AddLine(format(ACHIEVEMENT_EARNED_BY,self.earnedBy));
		local me = UnitName("player")
		if ( not self.wasEarnedByMe ) then
			GameTooltip:AddLine(format(ACHIEVEMENT_NOT_COMPLETED_BY, me));
		elseif ( me ~= self.earnedBy ) then
			GameTooltip:AddLine(format(ACHIEVEMENT_COMPLETED_BY, me));
		end
		GameTooltip:Show();
		return;
	end
	-- pass-through to the achievement button
	local func = parent:GetScript("OnEnter");
	if ( func ) then
		func(parent);
	end
	GameTooltip:Show();
end

function JPHF_AchievementShield_OnLeave(self)
	-- pass-through to the achievement button
	local parent = self:GetParent();
	local func = parent:GetScript("OnLeave");
	if ( func ) then
		func(parent);
	end
	GameTooltip:Hide();
end

function JPHF_AchievementFrameFilterDropDown_OnEnter(self)
	local currentFilter = JPHF_AchievementFrameFilterDropDown.value;
	GameTooltip:SetOwner(JPHF_AchievementFrameFilterDropDown, "ANCHOR_RIGHT", -18, 0);
	GameTooltip:AddLine(JPHF_AchievementFrameFilterStrings[currentFilter]);
	GameTooltip:Show();
end

function JPHF_AchievementComparisonPlayerButton_Saturate (self)
	local name = self:GetName();
	self.background:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Parchment-Horizontal");	
	self.shield.points:SetVertexColor(1, 1, 1);
	if ( self.accountWide ) then
		self.titleBar:SetTexture("Interface\\AchievementFrame\\AccountLevel-AchievementHeader");
		self.titleBar:SetTexCoord(0, 1, 0, 0.375);
		self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_BLUEBORDER_R, JPHF_ACHIEVEMENTUI_BLUEBORDER_G, JPHF_ACHIEVEMENTUI_BLUEBORDER_B, JPHF_ACHIEVEMENTUI_BLUEBORDER_A);
		self.saturatedStyle = "account";
	else
		self.titleBar:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Borders");
		self.titleBar:SetTexCoord(0, 1, 0.66015625, 0.73828125);
		self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_REDBORDER_R, JPHF_ACHIEVEMENTUI_REDBORDER_G, JPHF_ACHIEVEMENTUI_REDBORDER_B, JPHF_ACHIEVEMENTUI_REDBORDER_A);			
		self.saturatedStyle = "normal";
	end
	if ( self.isSummary ) then
		if ( self.accountWide ) then
			self.titleBar:SetAlpha(1);
		else
			self.titleBar:SetAlpha(0.5);
		end
	end
	self.glow:SetVertexColor(1.0, 1.0, 1.0);
	self.icon:Saturate();
	self.shield:Saturate();
	self.label:SetVertexColor(1, 1, 1);
	self.description:SetTextColor(0, 0, 0, 1);
	self.description:SetShadowOffset(0, 0);
end

function JPHF_AchievementComparisonPlayerButton_Desaturate (self)
	self.saturatedStyle = nil;
	local name = self:GetName();
	self.background:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Parchment-Horizontal-Desaturated");
	if ( self.accountWide ) then
		self.titleBar:SetTexture("Interface\\AchievementFrame\\AccountLevel-AchievementHeader");
		self.titleBar:SetTexCoord(0, 1, 0.40625, 0.78125);
	else
		self.titleBar:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Borders");
		self.titleBar:SetTexCoord(0, 1, 0.91796875, 0.99609375);
	end
	if ( self.isSummary ) then
		if ( self.accountWide ) then
			self.titleBar:SetAlpha(1);
		else
			self.titleBar:SetAlpha(0.5);
		end
	end
	self.glow:SetVertexColor(.22, .17, .13);
	self.icon:Desaturate();
	self.shield:Desaturate();
	self.shield.points:SetVertexColor(.65, .65, .65);
	self.label:SetVertexColor(.65, .65, .65);
	self.description:SetTextColor(1, 1, 1, 1);
	self.description:SetShadowOffset(1, -1);
	self:SetBackdropBorderColor(.5, .5, .5);
end

function JPHF_AchievementComparisonPlayerButton_OnLoad (self)
	self:SetBackdropBorderColor(JPHF_ACHIEVEMENTUI_REDBORDER_R, JPHF_ACHIEVEMENTUI_REDBORDER_G, JPHF_ACHIEVEMENTUI_REDBORDER_B, JPHF_ACHIEVEMENTUI_REDBORDER_A);
	self.Saturate = JPHF_AchievementComparisonPlayerButton_Saturate;
	self.Desaturate = JPHF_AchievementComparisonPlayerButton_Desaturate;
	
	self:Desaturate();
	
	-- AchievementFrameComparison.buttons = AchievementFrameComparison.buttons or {};
	-- tinsert(AchievementFrameComparison.buttons, self);
end

-- JPHF_

function JPHF_AchievementFrameStats_OnLoad (self)
end

function JPHF_AchievementFrameStats_OnEvent (self, event, ...)
end

--JPJPJP
--JPJPJP
--JPJPJP
function JPHF_AchievementFrameHeaderPoints_OnEnter(self)

	GameTooltip_SetDefaultAnchor(GameTooltip, self);
	GameTooltip:SetMinimumWidth(128, 1);
	
	GameTooltip:SetText(ACHIEVEMENT_TITLE .." "..JPHF_Onglet_Select_Valeur[JPHF_Onglet_Select])

	CompletedHFPoint, TotalHFPoint = JPHF_NombrePointHF()
	GameTooltip_ShowStatusBar(GameTooltip, 0, TotalHFPoint, CompletedHFPoint, CompletedHFPoint .."/" ..TotalHFPoint);
	GameTooltip:Show();
end

function JPHF_AchievementFrameHeaderPoints_OnLeave(self)
	GameTooltip:Hide();
end

function JPHF_NombrePointHF()
	local JPHF_NombrePointHFTotal = 0
	local JPHF_NombrePointHFTerminer = 0
	for i = 1, #JPHF_HF_Total[JPHF_Onglet_Select] do
		_, _, JPHF_Point, JPHF_Terminer = GetAchievementInfo(JPHF_HF_Total[JPHF_Onglet_Select][i])
		if JPHF_Terminer then
			JPHF_NombrePointHFTerminer = JPHF_NombrePointHFTerminer + JPHF_Point
		end
		JPHF_NombrePointHFTotal = JPHF_NombrePointHFTotal + JPHF_Point
	end
	return JPHF_NombrePointHFTerminer, JPHF_NombrePointHFTotal;
end

function JPHF_Classement(categorie,achievement)
	JPHF_HF_List = {};
	JPHF_HF_List2 = {};	
	
	local JPHF_rendu = 1;
	for i = 1, #JPHF_HF[JPHF_Onglet_Select][categorie] do
		_, _, _, completed = GetAchievementInfo(JPHF_HF[JPHF_Onglet_Select][categorie][i])
		if (completed) then
			tinsert(JPHF_HF_List, JPHF_rendu, JPHF_HF[JPHF_Onglet_Select][categorie][i])
			JPHF_rendu = JPHF_rendu + 1
		else
			tinsert(JPHF_HF_List, JPHF_HF[JPHF_Onglet_Select][categorie][i])
		end
	end	


	local JPHF_rendu = 1;
	for i = 1, #JPHF_HF_List do
		_, _, _, completed, _, _, _, _, flags = GetAchievementInfo(JPHF_HF_List[i])
		if (bit.band(flags, ACHIEVEMENT_FLAGS_ACCOUNT) == ACHIEVEMENT_FLAGS_ACCOUNT and completed) then
			tinsert(JPHF_HF_List2, JPHF_rendu, JPHF_HF_List[i])
			JPHF_rendu = JPHF_rendu + 1
		else
			tinsert(JPHF_HF_List2, JPHF_HF_List[i])
		end
	end		
	return JPHF_HF_List2[achievement]
end

function JPHF_AchievementDernierTerminer()
	local JPHF_Classement = {};
	local JPHF_Classer = {};
	local JPHF_ClassementFait = false;

	local JPHF_Terminer = false
	local JPHF_Jour = 0;
	local JPHF_Mois = 0;
	local JPHF_Anne = 0;
	local JPHF_Date = 0;
	for i = 1, #JPHF_HF_Total[JPHF_Onglet_Select] do
		_, _, _, JPHF_Terminer, JPHF_Mois, JPHF_Jour, JPHF_Anne = GetAchievementInfo(JPHF_HF_Total[JPHF_Onglet_Select][i])
		
		if JPHF_Terminer then
			if JPHF_Mois <= 9 then
				JPHF_Mois = "0" ..JPHF_Mois
			end
			if JPHF_Jour <= 9 then
				JPHF_Jour = "0" ..JPHF_Jour
			end
			JPHF_Date = JPHF_Anne ..JPHF_Mois ..JPHF_Jour
			JPHF_Date = tonumber(JPHF_Date)
			tinsert(JPHF_Classement, {["Date"] = JPHF_Date, ["id"] = JPHF_HF_Total[JPHF_Onglet_Select][i]})
		end
	end


	JPHF_Classer[1] = JPHF_Classement[1]
	for i = 2, #JPHF_Classement do
		JPHF_ClassementFait = false
		for j = 1, #JPHF_Classer do
			if JPHF_Classement[i].Date >= JPHF_Classer[j].Date then
				tinsert(JPHF_Classer, j, JPHF_Classement[i])
				JPHF_ClassementFait = true
				break;
			end
		end
		if JPHF_ClassementFait == false then
			tinsert(JPHF_Classer, JPHF_Classement[i])
		end
	end
	JPHF_Boucle = min(4, #JPHF_Classer);
	JPHF_Classement = {};
	for i = 1, JPHF_Boucle do
		tinsert(JPHF_Classement, JPHF_Classer[i].id)
	end

	return JPHF_Classement;
end

function JPHF_TrouverCategorie_HF(id, onglet)
	for i = 2, #JPHF_HF[onglet] do
		for j = 1, #JPHF_HF[onglet][i] do
			if JPHF_HF[onglet][i][j] == id then
				return i, onglet;
			end
		end
	end
	for ij = 1, JPHF_NombreModule do
		if (onglet ~= ij) then
			for i = 2, #JPHF_HF[ij] do
				for j = 1, #JPHF_HF[ij][i] do
					if JPHF_HF[ij][i][j] == id then
						return i, ij;
					end
				end
			end	
		end
	end
	return 5000000
end

