function AddTabCloseButton(tab, chat)
	local button = CreateFrame('Button', 'MyButtonName', tab, 'UIPanelCloseButton')
	button:SetPoint('TOPRIGHT', 4,-5)
	button:SetSize(16, 16)
	button:SetScript('OnClick', function()
		FCF_Close(chat)
	end)
end

function CloseChat(pageID)
	local chatFrame, curTab = ChatFrame_FindPage(pageID);
	if(not chatFrame)then
		return;
	end
	FCF_Close(chatFrame);
end

-- Chat Window creation
function NewChatWindow()
	local chat = FCF_GetCurrentChatFrame()
	if _G[chat:GetName().."Tab"]:GetText():match(PET_BATTLE_COMBAT_LOG) then
		FCF_Close(chat)
		return
	end

	tab = _G[chat:GetName().."Tab"]
	AddTabCloseButton(tab, chat)
end

-- hookup the open new window event function
hooksecurefunc("FCF_OpenNewWindow", NewChatWindow)
hooksecurefunc("FCF_OpenTemporaryWindow", NewChatWindow)