--------------------------------------
-- Namespaces
--------------------------------------
local _, core = ...

core.Instances = {
    BattleForAzeroth = {
        Raids = {
            Uldir = {
                name = "Uldir",
                boss1 = {
                    name = "Taloc",
                    bossIDs = {},
                    achievement = 12937,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "MOTHER",
                    bossIDs = {},
                    achievement = 12938,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Fetid Devourer",
                    bossIDs = {},
                    achievement = 12823,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Zek'voz",
                    bossIDs = {},
                    achievement = 12828,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Vectis",
                    bossIDs = {},
                    achievement = 12772,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss6 = {
                    name = "Zul Reborn",
                    bossIDs = {},
                    achievement = 12830,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss7 = {
                    name = "Mythrax the Unraveler",
                    bossIDs = {},
                    achievement = 12836,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss8 = {
                    name = "G'huun",
                    bossIDs = {},
                    achievement = 12551,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            Azeroth = {
                name = "Azeroth",
                boss1 = {
                    name = "Temp",
                    bossIDs = {},
                    achievement = 12937,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
        },

        Dungeons = {
            AtalDazar = {
                name = "Atal Dazar",
                boss1 = {
                    name = "Other 52",
                    bossIDs = {},
                    achievement = 12270,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Priestess Alun'za",
                    bossIDs = {},
                    achievement = 12272,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.AtalDazar:PriestessAlunza() end,
					partial = false,
                },
                boss3 = {
                    name = "Yazma",
                    bossIDs = {},
                    achievement = 12273,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            Freehold = {
                name = "Freehold",
                boss1 = {
                    name = "Skycap'n Kragg",
                    bossIDs = {},
                    achievement = 12548,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Freehold:SkycapnKragg() end,
					partial = false,
                },
                boss2 = {
                    name = "Ring of Booty",
                    bossIDs = {},
                    achievement = 12550,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Harlan Sweete",
                    bossIDs = {},
                    achievement = 12998,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            KingsRest = {
                name = "Kings Rest",
                boss1 = {
                    name = "Mchimba the Embalmer",
                    bossIDs = {},
                    achievement = 12721,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Other 53",
                    bossIDs = {},
                    achievement = 12723,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Other 54",
                    bossIDs = {},
                    achievement = 12722,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            ShrineOfTheStorm = {
                name = "Shrine of the Storm",
                boss1 = {
                    name = "Lord Stormsong",
                    bossIDs = {},
                    achievement = 12601,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Vol'zith",
                    bossIDs = {},
                    achievement = 12602,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Other 51",
                    bossIDs = {},
                    achievement = 12600,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            SiegeOfBoralus = {
                name = "Siege of Boralus",
                boss1 = {
                    name = "Dread Captain Lockwood",
                    bossIDs = {},
                    achievement = 12727,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Viq'Goth",
                    bossIDs = {},
                    achievement = 12726,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            TempleOfSethraliss = {
                name = "Temple of Sethraliss",
                boss1 = {
                    name = "Merektha",
                    bossIDs = {},
                    achievement = 12507,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Avatar of Sethraliss",
                    bossIDs = {},
                    achievement = 12508,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Other 30",
                    bossIDs = {},
                    achievement = 12503,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            TheMotherlode = {
                name = "The Motherlode",
                boss1 = {
                    name = "Coin-Operated Crowd Pummeler",
                    bossIDs = {},
                    achievement = 12855,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheMotherlode:CoinOperatedCrowdPummeler() end,
					partial = false,
                },
                boss2 = {
                    name = "Mogul Razdunk",
                    bossIDs = {},
                    achievement = 12854,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            TheUnderrot = {
                name = "The Underrot",
                boss1 = {
                    name = "Elder Leaxa",
                    bossIDs = {},
                    achievement = 12498,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheUnderrot:ElderLeaxa() end,
					partial = false,
                },
                boss2 = {
                    name = "Sporecaller Zancha",
                    bossIDs = {},
                    achievement = 12549,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheUnderrot:SporecallerZancha() end,
					partial = false,
                },
                boss3 = {
                    name = "Unbound Abomination",
                    bossIDs = {},
                    achievement = 12499,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheUnderrot:UnboundAbomination() end,
					partial = false,
                },                
            },
            TolDagor = {
                name = "Tol Dagor",
                boss1 = {
                    name = "Knight Captain Valyri",
                    bossIDs = {},
                    achievement = 12457,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Overseer Korgus",
                    bossIDs = {},
                    achievement = 12462,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
            WaycrestManor = {
                name = "Waycrest Manor",
                boss1 = {
                    name = "Soulbound Goliath",
                    bossIDs = {},
                    achievement = 12495,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.WaycrestManor:SoulboundGoliath() end,
					partial = false,
                },
                boss2 = {
                    name = "Gorak Tul",
                    bossIDs = {},
                    achievement = 12490,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Other 50",
                    bossIDs = {},
                    achievement = 12489,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
        },
    },

    Legion = {
        Raids = {
            TheEmeraldNightmare = {
                name = "The Emerald Nightmare",
                boss1 = {
                    name = "Nythendra",
                    bossIDs = {102672},
                    achievement = 10555,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "During the Heart of the Swarm phase, glow bugs will spawn around the edges of the room. Once they spawn players need to click on the bugs to squish them. Once 15 bugs have been squished you can kill the boss. 5 bugs spawn each phase so you will need a minimum of 3 Heart of the Swarm phases to complete this achievement.",
                    enabled = true,
                    track = function() core.TheEmeraldNightmare:Nythendra() end,
					partial = false,
                },
                boss2 = {
                    name = "Ursoc",
                    bossIDs = {100497},
                    achievement = 10753,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill the trash to the right hand side before of the entrance to the boss room. Free Tur Ragepaw and wait for him to reach the boss. Nuke the boss down while keeping Tur Ragepaw alive.",
                    enabled = true,
                    track = function() core.TheEmeraldNightmare:Ursoc() end,
					partial = false,
                },
                boss3 = {
                    name = "Dragons of Nightmare",
                    bossIDs = {102683,102682,102681,102679},
                    achievement = 10663,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "There are 4 portals around the boss room. Everyone in the group must go into each of the 4 portals and collect 1 mist from each portal which gives them a buff. Once all players in the group have 4 buffs you can kill the boss. The easiest way to do this is to split the group up into 2 then have half the group collect the 4 buffs at once.",
                    enabled = true,
                    track = function() core.TheEmeraldNightmare:DragonsOfNightmare() end,
					partial = false,
                },
                boss4 = {
                    name = "Elerethe Renferal",
                    bossIDs = {}, --106087
                    achievement = 10771,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Il'gynoth, Heart of Corruption",
                    bossIDs = {105906,105721},
                    achievement = 10830,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Wait for 20 Nightmare Explosions to spawn. Once you have enough adds, everyone should stand in front of the eye, then AOE down all the adds together. Once 20 adds have been killed in 10 seconds on the eye, you can kill the boss.",
                    enabled = true,
                    track = function() core.TheEmeraldNightmare:Ilgynoth() end,
					partial = false,
                },
                boss6 = {
                    name = "Cenarius",
                    bossIDs = {},
                    achievement = 10772,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement will take 2 weeks to complete. Drag the boss to one of the four corners of the room and burn it down. This will complete 3/4 parts of the achievement. On the next lockout drag the boss to a different corner of the room to complete the last requirement.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss7 = {
                    name = "Xavius",
                    bossIDs = {103769},
                    achievement = 10755,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "To complete this achievement, you will need a Demon Hunter to use his spectral sight ability. Around the outer edges of the boss rooms, a Creature in the Dark will spawn at 3 points during the fight. The Demon Hunter will need to use his spectral sight ability to find the add and drag it into the centre of the room. The adds spawn at 100-65%, 65%-30% and below 30%. Once all 3 Creatures in the dark have been killed, you can nuke the boss.",
                    enabled = true,
                    track = function() core.TheEmeraldNightmare:Xavius() end,
					partial = false,
                },
            },

            TrialOfValor = {
                name = "Trial of Valor",
                boss1 = {
                    name = "Odyn 2",
                    bossIDs = {114263},
                    achievement = 11337,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TrialOfValor:Odyn() end,
					partial = false,
                },
                boss2 = {
                    name = "Guarm",
                    bossIDs = {114323},
                    achievement = 11386,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
                boss3 = {
                    name = "Helya",
                    bossIDs = {114537},
                    achievement = 11377,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TrialOfValor:Helya() end,
					partial = false,
                },
            },

            TheNighthold = {
                name = "The Nighthold",
                boss1 = {
                    name = "Skorpyron",
                    bossIDs = {}, --102263
                    achievement = 10678,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Everyone in the group must stay in the inner ring of the boss room. When the boss cast shockwave, every player in the group must hide behind the crystalline fragments placed down by the boss, you should get a buff called Broken Shard which will prevent you getting knocked back from the shockwave. If any players get knocked out of the inner ring then the achievement will fail.",
                    enabled = true,
                    track = function() core.TheNighthold:Skorpyron() end,
                    partial = false,
                    encounterID = 1849,
                },
                boss2 = {
                    name = "Chronomatic Anomaly",
                    bossIDs = {},
                    achievement = 10697,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement is easier to complete in heroic mode. Random players will get a timebomb debuff. These players need to stand on the blue circles around the boss room until the timebomb debuff expires. Once it expires you should see a spotlight appear at each of the blue circles around the room. Once atleast 8 circles around the room have spotlights, you can kill the boss.",
                    enabled = false,
                    track = nil,
                    partial = false,
                },
                boss3 = {
                    name = "Trilliax",
                    bossIDs = {}, --104288
                    achievement = 10742,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down and ignore picking up the toxic slices.",
                    enabled = true,
                    track = function() core.TheNighthold:Trilliax() end,
					partial = false,
                    nameplateCheck = true,
                    encounterID = 1867,
                },
                boss4 = {
                    name = "Spellblade Aluriel",
                    bossIDs = {},
                    achievement = 10817,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Star Augur Etraeus",
                    bossIDs = {103758},
                    achievement = 10851,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheNighthold:StarAugurEtraeus() end,
					partial = false,
                },
                boss6 = {
                    name = "High Botanist Tel'arn",
                    bossIDs = {104528},
                    achievement = 10754,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheNighthold:HighBotanistTelarn() end,
					partial = false,
                },
                boss7 = {
                    name = "Krosus",
                    bossIDs = {101002}, 
                    achievement = 10575,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheNighthold:Krosus() end,
					partial = false,
                },
                boss8 = {
                    name = "Tichondrius",
                    bossIDs = {103685},
                    achievement = 10704,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement is a personal achievement. When the boss casts his Echoes of the Void ability, hide behind the pillars around the room to avoid taking damage.",
                    enabled = true,
                    track = function() core.TheNighthold:Tichondrius() end,
					partial = false,
                },
                boss9 = {
                    name = "Elisande",
                    bossIDs = {106643},
                    achievement = 10699,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "For this achievement you will need to summon a Infinite Whelp pet. You then need to overlap the slow and fast time bubbles over one another. Next drag the Infinite Whelp pet into the overlapping bubbles. This will spawn a Infinite Whelpling which needs to be killed before killing the boss.",
                    enabled = true,
                    track = function() core.TheNighthold:Elisande() end,
					partial = false,
                },
                boss10 = {
                    name = "Gul'dan",
                    bossIDs = {104154},
                    achievement = 10696,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "During phase 2, spread out around the room and wait for the eyes to spawn. Once 16 Eyes of Gul'dan have spawned, nuke them down within 3 seconds of one another. If you can’t kill them quick enough you may need to reduce the health of the eyes slightly before killing them.",
                    enabled = true,
                    track = function() core.TheNighthold:Guldan() end,
					partial = false,
                },
            },

            TombOfSargeras = {
                name = "Tomb of Sargeras",
                boss1 = {
                    name = "Goroth",
                    bossIDs = {},
                    achievement = 11724,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Ranged DPS and healers need to stack up together so the Infernal Spikes spawn together. Once the boss targets someone with his Shattering Star ability, they need to hide behind the pillars so that they get destroyed. Once 30 Infernal Spikes have been destroyed with the Shattering Star ability you can kill the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Demonic Inquisition",
                    bossIDs = {116689,116691},
                    achievement = 11696,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "DPS the boss down to around 3-5% health. Once the boss has reached 3-5% health everyone in the raid needs to get to 100 Torment. The quickest way to do this is to stand in the Fel Squall ability that Belac casts. Once everyone has Unbearable Torment you can nuke boss. You will want to save any cooldowns for the last 5% health since the unbearable torment significantly reduces the damage you deal and healing that can be done.",
                    enabled = true,
                    track = function() core.TombOfSargeras:DemonicInquisition() end,
					partial = false,
                },
                boss3 = {
                    name = "Harjatan",
                    bossIDs = {116407},
                    achievement = 11699,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then someone in the raid Summon Elder Murk-Eye using the Mrgrglhjorn toy. Kill the add then kill the boss as usual.",
                    enabled = true,
                    track = function() core.TombOfSargeras:Harjatan() end,
					partial = false,
                },
                boss4 = {
                    name = "Mistress Sassz'ine",
                    bossIDs = {},
                    achievement = 11676,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Sisters of the Moon",
                    bossIDs = {118523,118374,118518},
                    achievement = 11773,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "In the room full of trash before the boss you will want to find the Twilight Soul and keep this add alive. Pull the boss and complete the encounter as usual till 20% health. Keep the Twilight Soul to one side of the room and ignore it till the boss reaches 20% health. At 20% health the Twilight Soul will change colour, at this point you can nuke down the add then just kill the boss as normal.",
                    enabled = true,
                    track = function() core.TombOfSargeras:SistersOfTheMoon() end,
					partial = false,
                },
                boss6 = {
                    name = "The Desolate Host",
                    bossIDs = {},
                    achievement = 11674,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss7 = {
                    name = "Maiden of Vigilance",
                    bossIDs = {},
                    achievement = 11675,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss8 = {
                    name = "Fallen Avatar",
                    bossIDs = {},
                    achievement = 11683,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss9 = {
                    name = "Kil'jaeden",
                    bossIDs = {117269},
                    achievement = 11770,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TombOfSargeras:Kiljaeden() end,
					partial = false,
                },
            },

            AntorusTheBurningThrone = {
                name = "Antorus the Burning Throne",
                boss1 = {
                    name = "Garothi Worldbreaker",
                    bossIDs = {},
                    achievement = 11930,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Felhounds of Sargeras",
                    bossIDs = {122477,122135},
                    achievement = 12065,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.AntorusTheBurningThrone:FelhoundsOfSargeras() end,
					partial = false,
                },
                boss3 = {
                    name = "Antoran High Command",
                    bossIDs = {122367,130184,122369},
                    achievement = 12129,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.AntorusTheBurningThrone:AntoranHighCommand() end,
					partial = false,
                },
                boss4 = {
                    name = "Portal Keeper Hasabel",
                    bossIDs = {122104},
                    achievement = 11928,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.AntorusTheBurningThrone:PortalKeeperHasabel() end,
					partial = false,
                },
                boss5 = {
                    name = "Eonar",
                    bossIDs = {},
                    achievement = 12067,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss6 = {
                    name = "Imonar the Soulhunter",
                    bossIDs = {},
                    achievement = 11949,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss7 = {
                    name = "Kin-garoth",
                    bossIDs = {122578},
                    achievement = 12030,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.AntorusTheBurningThrone:KinGaroth() end,
					partial = false,
                },
                boss8 = {
                    name = "Varimathras",
                    bossIDs = {122366},
                    achievement = 11948,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.AntorusTheBurningThrone:Varimathras() end,
					partial = false,
                },
                boss9 = {
                    name = "Coven of Shivarra",
                    bossIDs = {},
                    achievement = 12046,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss10 = {
                    name = "Aggramar",
                    bossIDs = {121975},
                    achievement = 11915,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.AntorusTheBurningThrone:Aggramar() end,
					partial = false,
                },
                boss11 = {
                    name = "Argus",
                    bossIDs = {124828},
                    achievement = 12257,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
            },
        },

        Dungeons = {
            SeatOfTheTriumvirate = {
                name = "Seat of the Triumvirate",
                boss1 = {
                    name = "Zuraal the Ascended",
                    bossIDs = {122313},
                    achievement = 12004,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.SeatOfTheTriumvirate:ZuraalTheAscended() end,
					partial = false,
                },
                boss2 = {
                    name = "Saprish",
                    bossIDs = {},
                    achievement = 12005,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "L'ura",
                    bossIDs = {124729},
                    achievement = 12009,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.SeatOfTheTriumvirate:Lura() end,
					partial = false,
                },
            },

            AssaultOnVioletHold = {
                name = "Assault on Violet Hold",
                boss1 = {
                    name = "Millificent Manastorm",
                    bossIDs = {},
                    achievement = 10553,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Festerface",
                    bossIDs = {101995},
                    achievement = 10554,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.AssaultOnVioletHold:Festerface() end,
					partial = false,
                },
            },

            EyeOfAzshara = {
                name = "Eye of Azshara",
                boss1 = {
                    name = "Warlord Parjesh",
                    bossIDs = {91784},
                    achievement = 10456,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.EyeOfAzshara:WarlordParjesh() end,
					partial = false,
                },
                boss2 = {
                    name = "Lady Hatecoil",
                    bossIDs = {91789},
                    achievement = 10457,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.EyeOfAzshara:LadyHatecoil() end,
					partial = false,
                },
                boss3 = {
                    name = "Wrath of Azshara",
                    bossIDs = {96028},
                    achievement = 10458,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.EyeOfAzshara:WrathOfAzshara() end,
					partial = false,
                },
            },

            DarkheartThicket = {
                name = "Darkheart Thicket",
                boss1 = {
                    name = "Dresaron",
                    bossIDs = {99200},
                    achievement = 10766,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.DarkheartThicket:Dresaron() end,
					partial = false,
                },
                boss2 = {
                    name = "Shade of Xavius",
                    bossIDs = {99192},
                    achievement = 10769,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.DarkheartThicket:ShadeOfXavius() end,
					partial = false,
                },
            },

            HallsOfValor = {
                name = "Halls of Valor",
                boss1 = {
                    name = "Other 1",
                    bossIDs = {99891},
                    achievement = 10544,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.HallsOfValor:StagParty() end,
					partial = false,
                },
                boss2 = {
                    name = "Other 2",
                    bossIDs = {},
                    achievement = 10542,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Odyn",
                    bossIDs = {95676},
                    achievement = 10543,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.HallsOfValor:Odyn() end,
					partial = false,
                },
            },

            NeltharionSLair = {
                name = "NeltharionS Lair",
                boss1 = {
                    name = "Other 3",
                    bossIDs = {},
                    achievement = 10996,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Naraxas",
                    bossIDs = {91005},
                    achievement = 10875,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.NeltharionSLair:Naraxas() end,
					partial = false,
                },
            },

            VaultOfTheWardens = {
                name = "Vault of the Wardens",
                boss1 = {
                    name = "Ash'Golm",
                    bossIDs = {95886},
                    achievement = 10679,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.VaultOfTheWardens:AshGolm() end,
					partial = false,
                },
                boss2 = {
                    name = "Cordana",
                    bossIDs = {95888},
                    achievement = 10680,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.VaultOfTheWardens:Cordana() end,
					partial = false,
                },
                boss3 = {
                    name = "Other 4",
                    bossIDs = {},
                    achievement = 10707,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            BlackRookHold = {
                name = "Black Rook Hold",
                boss1 = {
                    name = "Other 5",
                    bossIDs = {},
                    achievement = 10709,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Amalgam of Souls",
                    bossIDs = {98542},
                    achievement = 10710,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.BlackRookHold:AmalgamOfSouls() end,
					partial = false,
                },
                boss3 = {
                    name = "Illysanna Ravencrest",
                    bossIDs = {98696},
                    achievement = 10711,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.BlackRookHold:IllysannaRavencrest() end,
					partial = false,
                },
            },

            MawOfSouls = {
                name = "Maw of Souls",
                boss1 = {
                    name = "Ymiron",
                    bossIDs = {96756},
                    achievement = 10413,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.MawOfSouls:Ymiron() end,
					partial = false,
                },
                boss2 = {
                    name = "Helya",
                    bossIDs = {},
                    achievement = 10412,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Other 6",
                    bossIDs = {},
                    achievement = 10411,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            TheArcway = {
                name = "The Arcway",
                boss1 = {
                    name = "Ivanyr",
                    bossIDs = {98203},
                    achievement = 10773,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheArcway:Ivanyr() end,
					partial = false,
                },
                boss2 = {
                    name = "Corstilax",
                    bossIDs = {},
                    achievement = 10775,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Advisor Vandros",
                    bossIDs = {98208},
                    achievement = 10776,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheArcway:AdvisorVandros() end,
					partial = false,
                },
            },

            CourtOfStars = {
                name = "Court of Stars",
                boss1 = {
                    name = "Patrol Captain Gerdo",
                    bossIDs = {},
                    achievement = 10610,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Other 7",
                    bossIDs = {},
                    achievement = 10611,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            ReturnToKarazhan = {
                name = "Return to Karazhan",
                boss1 = {
                    name = "Other 8",
                    bossIDs = {},
                    achievement = 11433,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Opera Hall",
                    bossIDs = {},
                    achievement = 11335,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Moroes",
                    bossIDs = {},
                    achievement = 11338,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Shade of Medivh",
                    bossIDs = {},
                    achievement = 11432,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Mana Devourer",
                    bossIDs = {},
                    achievement = 11431,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss6 = {
                    name = "Other 9",
                    bossIDs = {},
                    achievement = 11430,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            CathedralOfEternalNight = {
                name = "Cathedral of Eternal Night",
                boss1 = {
                    name = "Agronox",
                    bossIDs = {},
                    achievement = 11768,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Thrashbite the Scornful",
                    bossIDs = {117194},
                    achievement = 11769,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.CathedralOfEternalNight:ThrashbiteTheScornful() end,
					partial = false,
                },
                boss3 = {
                    name = "Mephistroth",
                    bossIDs = {},
                    achievement = 11703,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
        },
    },

    WarlordsOfDraenor = {
        Raids = {
            Highmaul = {
                name = "Highmaul",
                boss1 = {
                    name = "Kargath Bladefist",
                    bossIDs = {78714},
                    achievement = 8948,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke the boss down.",
                    enabled = true,
                    track = function() core.Highmaul:KargathBladefist() end,
					partial = false,
                },
                boss2 = {
                    name = "The Butcher",
                    bossIDs = {77404},
                    achievement = 8947,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Highmaul:TheButcher() end,
					partial = false,
                },
                boss3 = {
                    name = "Tectus",
                    bossIDs = {}, --78948
                    achievement = 8974,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just nuke the boss down for the first and second split. On the third split wait for all 8 versions of the boss to spawn, then AOE them down within 10 seconds of one another.",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
                boss4 = {
                    name = "Brackenspore",
                    bossIDs = {78491},
                    achievement = 8975,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Before pulling the boss pick up the flamethrower fun. Damage the boss to below 50% health so that the green moss starts growing from the edges of the room. Once the room is full of green moss, start pressing the flamethrower button over the boss. Keep pressing the flamethrower button every time it comes off cooldown until you reach 15 stacks of Burning Infusion. Once you have 15 stacks you can kill the boss. The stacks do need to stay on you once you reach 15.",
                    enabled = true,
                    track = function() core.Highmaul:Brackenspore() end,
					partial = false,
                },
                boss5 = {
                    name = "Twin Ogron",
                    bossIDs = {78237,78238},
                    achievement = 8958,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke the bosses down. Make sure they are standing next to each other.",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
                boss6 = {
                    name = "Ko'ragh",
                    bossIDs = {79015},
                    achievement = 8976,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Highmaul:Koragh() end,
					partial = false,
                },
                boss7 = {
                    name = "Imperator Mar'gok",
                    bossIDs = {},
                    achievement = 8977,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            BlackrockFoundry = {
                name = "Blackrock Foundry",
                boss1 = {
                    name = "Beastlord Darmac",
                    bossIDs = {76865},
                    achievement = 8981,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Takes 3 kills to complete. Boss will mount the beast that is closest to him. DPS the boss down slowly and wait for boss to mount beast before killing.",
                    enabled = true,
                    track = function() core.BlackrockFoundry:BeastlordDarmac() end,
                    partial = false,
                },
                boss2 = {
                    name = "Operator Thogar",
                    bossIDs = {76906},
                    achievement = 8982,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Wait 10 seconds after pulling the boss then place Toy train set and then immediately after the wind up train wrecker on the first set of tracks as you enter the boss room. Achievement will be earned as soon as the requirements have been met.",
                    enabled = true,
                    track = function() core.BlackrockFoundry:OperatorThogar() end,
                    partial = false,
                },
                boss3 = {
                    name = "Iron Maidens",
                    bossIDs = {77477, 77557, 77231},
                    achievement = 8984,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Nuke all 3 bosses within 10 seconds of one another",
                    enabled = true,
                    track = function() core.BlackrockFoundry:TheIronMaidens() end,
                    partial = false,
                },
                boss4 = {
                    name = "Hans'gar & Franzok",
                    bossIDs = {76973, 76974},
                    achievement = 8980,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Nuke boss down as quick as possible without anyone in the group getting hit by a stamping press. The stamping press display an orange glow on the floor a few seconds before stamping.",
                    enabled = true,
                    track = function() core.BlackrockFoundry:HansgarFranzok() end,
                    partial = false,
                },
                boss5 = {
                    name = "Flamebender Ka'graz",
                    bossIDs = {76814},
                    achievement = 8929,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "1 person tank Aknor Stellbringer away from the boss.  Everyone else single target the boss down.",
                    enabled = true,
                    track = function() core.BlackrockFoundry:FlamebenderKagraz() end,
                    partial = false,
                },
                boss6 = {
                    name = "Kromog",
                    bossIDs = {77692},
                    achievement = 8983,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Requires atleast 10 players but more players makes achievement easier. Spread out around the room and wait for orange runes to spawn. When they spawn each player stand on their own rune. When hands spawn from runes and grab players nuke hands down as quickly as possible.",
                    enabled = true,
                    track = function() core.BlackrockFoundry:Kromog() end,
                    partial = false,
                },
                boss7 = {
                    name = "Gruul",
                    bossIDs = {},
                    achievement = 8978,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "1 player tank boss at entrance to room with boss facing into the center of the room. Everyone else stand underneath the ore which is positioned on the ceiling of the boss room. When boss casts overhead smash, players will be flung into the air. Click on the ore on the ceiling to collect it. Once all 3 ores have been collected you can nuke boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss8 = {
                    name = "Oregorger",
                    bossIDs = {},
                    achievement = 8979,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss9 = {
                    name = "Blast Furnace",
                    bossIDs = {76806},
                    achievement = 8930,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Completed during phase 2. During phase 2, 4 random players will be targeted by slag elementals. If you have a slag elemental following you, run to one of the primal elementalists which doesn’t have a slag elemental already on. Once there is slag elemental on each primal elementalists you can nuke down the slag elemental then primal elementalists as quick as possible. Getting all 4 primal elementalists down within 10 seconds will reward this achievement. ",
                    enabled = true,
                    track = function() core.BlackrockFoundry:BlastFurnace() end,
                    partial = false,
                },
                boss10 = {
                    name = "Blackhand",
                    bossIDs = {77325},
                    achievement = 8952,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "DPS the boss down to 30% to reach phase 3. Ashes will then start falling from the ceiling. Spread out around the platform and stand underneath the falling ashes until it lands on you. Once the group has collected 20 falling ashes you can nuke boss. The more players you have the easy this achievement is.",
                    enabled = true,
                    track = function() core.BlackrockFoundry:Blackhand() end,
                    partial = false,
                },
            },
            
            HellfireCitadel = {
                name = "Hellfire Citadel",
                boss1 = {
                    name = "Hellfire Assault",
                    bossIDs = {93023},
                    achievement = 10026,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, simply nuke down all the mobs/vehicles as quick as possible. Make sure to keep an eye on the Felfire Crushers and Artillery especially",
                    enabled = true,
                    track = function() end,
                    partial = false,
                    nameplateCheck = true,
                },
                boss2 = {
                    name = "Iron Reaver",
                    bossIDs = {}, --90284
                    achievement = 10057,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "On the ledges to the left and right of the boss there are untargetable Hellfire Guardians. Bring the boss up against these ledges facing the boss towards the Hellfire Guardians. When the boss casts barrage, this should kill the mobs.",
                    enabled = true,
                    track = function() core.HellfireCitadel:IronReaver() end,
                    partial = false,
                    encounterID = 1785,
                },
                boss3 = {
                    name = "Kormrok",
                    bossIDs = {90435},
                    achievement = 10013,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Personal Achievement. Nuke down boss and avoid getting hit by any waves during the encounter.",
                    enabled = true,
                    track = function() core.HellfireCitadel:Kormrok() end,
                    partial = false,
                },
                boss4 = {
                    name = "Hellfire High Council",
                    bossIDs = {92144, 92146, 92142},
                    achievement = 10054,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Nuke down all 3 bosses so that they die within 10 seconds of one another",
                    enabled = true,
                    track = function() core.HellfireCitadel:HellfireHighCouncil() end,
                    partial = false,
                },
                boss5 = {
                    name = "Kilrogg Deadeye",
                    bossIDs = {90378},
                    achievement = 9972,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just simply nuke down the boss",
                    enabled = true,
                    track = function() end,
                    partial = false,
                },
                boss6 = {
                    name = "Gorefiend",
                    bossIDs = {90199},
                    achievement = 9979,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "During Feasts of Soul phase, players who do not have the Gorefiends Corruption debuff need to die. This can be done by standing in the pool the boss is sitting in. Once dead the players will get teleported into the belly of the boss. They need to kill the Fragment of the crone once inside. Once the fragment of the crone is dead, the soul of the crone will spawn in the boss room which can then be killed by the group.",
                    enabled = true,
                    track = function() core.HellfireCitadel:Gorefiend() end,
                    partial = false,
                },
                boss7 = {
                    name = "Shadow-Lord Iskar",
                    bossIDs = {90316},
                    achievement = 9988,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just simply nuke down the boss without picking up the Eye of Anzu",
                    enabled = true,
                    track = function() core.HellfireCitadel:ShadowLordIskar() end,
                    partial = false,
                },
                boss8 = {
                    name = "Socrethar the Eternal",
                    bossIDs = {90296},
                    achievement = 10086,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "During phase 2. Use the robot to put up a prison at the blue portal. Continue to use the prison at the portal to trap the adds until 20 Haunting Souls are trapped. Once this is done, leave the vehicle and aoe all the adds down. Players can also cc the adds to keep them in place. Do not kill the adds with the robot.",
                    enabled = true,
                    track = function() core.HellfireCitadel:SocretharTheEternal() end,
                    partial = false,
                },
                boss9 = {
                    name = "Tyrant Velhari",
                    bossIDs = {93439},
                    achievement = 9989,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "1 person tank the Ancient Enforcer away from the group. Everyone else nuke the boss down",
                    enabled = true,
                    track = function() core.HellfireCitadel:TyrantVelhari() end,
                    partial = false,
                },
                boss10 = {
                    name = "Fel Lord Zakuun",
                    bossIDs = {89890},
                    achievement = 10012,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down",
                    enabled = true,
                    track = function() core.HellfireCitadel:FelLordZakuun() end,
                    partial = false,
                },
                boss11 = {
                    name = "Xhul'horac",
                    bossIDs = {93068},
                    achievement = 10087,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply just nuke the boss down",
                    enabled = true,
                    track = function() core.HellfireCitadel:Xhulhorac() end,
                    partial = false,
                },
                boss12 = {
                    name = "Mannoroth",
                    bossIDs = {91349, 91305},
                    achievement = 10030,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At the start of the fight kill the green & purple summoner. Wait for a player to get curse of the legion debuff before killing the red summoner. Once the curse of the legion debuff runs out or is dispelled, a doom lord will spawn. Get the doom lord down to 5% health. Next dps down Mannoroth to 30% health. Once this is done place the doom lord in front of the boss and wait for it to get killed by Mannoroth Empowered Fel Seeker ability. Once the doom lord has been killed by the boss, you can kill the boss.",
                    enabled = true,
                    track = function() core.HellfireCitadel:Mannoroth() end,
                    partial = false,
                },
                boss13 = {
                    name = "Archimonde",
                    bossIDs = {91331},
                    achievement = 10073,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Wait for the Doomfire Spirit to spawn then nuke down boss. The Doomfire Spirit does not need to stay alive",
                    enabled = true,
                    track = function() core.HellfireCitadel:Archimonde() end,
					partial = false,
                },
            },
        },

        Dungeons = {
            BloodmaulSlagMines = {
                name = "Bloodmaul Slag Mines",
                boss1 = {
                    name = "Slave Watcher Crushto",
                    bossIDs = {},
                    achievement = 9005,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Magmolatus",
                    bossIDs = {74366},
                    achievement = 8993,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, dps down the boss slowly so that both Calamity and Ruination have a chance to spawn",
                    enabled = true,
                    track = function() core.BloodmaulSlagMines:Magmolatus() end,
					partial = false,
                },
                boss3 = {
                    name = "Gug'rokk",
                    bossIDs = {74790},
                    achievement = 9008,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, single target the boss down so that no Unstable Slags are killed",
                    enabled = true,
                    track = function() core.BloodmaulSlagMines:Gugrokk() end,
					partial = false,
                },
            },

            IronDocks = {
                name = "Iron Docks",
                boss1 = {
                    name = "Fleshrender Nok'gar",
                    bossIDs = {81305, 83026, 84520, 81603},
                    achievement = 9083,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.IronDocks:FleshrenderNokgar() end,
					partial = false,
                },
                boss2 = {
                    name = "Other 11",
                    bossIDs = {},
                    achievement = 9081,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Skulloc",
                    bossIDs = {83612},
                    achievement = 9082,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.IronDocks:Skulloc() end,
					partial = false,
                },
            },

            Auchindoun = {
                name = "Auchindoun",
                boss1 = {
                    name = "Soulbinder Nyami",
                    bossIDs = {},
                    achievement = 9023,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Azzakel",
                    bossIDs = {},
                    achievement = 9551,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Teron'gor",
                    bossIDs = {},
                    achievement = 9552,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            Skyreach = {
                name = "Skyreach",
                boss1 = {
                    name = "Ranjit",
                    bossIDs = {75964},
                    achievement = 9033,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Skyreach:Ranjit() end,
					partial = false,
                },
                boss2 = {
                    name = "Rukhran",
                    bossIDs = {},
                    achievement = 9035,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "High Sage Viryx",
                    bossIDs = {76266},
                    achievement = 9036,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Skyreach:HighSageViryx() end,
					partial = false,
                },
                boss4 = {
                    name = "High Sage Viryx 2",
                    bossIDs = {},
                    achievement = 9034,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = nil,
					partial = false,
                },
            },

            GrimrailDepot = {
                name = "Grimrail Depot",
                boss1 = {
                    name = "Rocketspark and Borka",
                    bossIDs = {77803,77816},
                    achievement = 9024,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.GrimrailDepot:RocketsparkAndBorka() end,
					partial = false,
                },
                boss2 = {
                    name = "Nitrogg Thundertower",
                    bossIDs = {},
                    achievement = 9007,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            TheEverbloom = {
                name = "The Everbloom",
                boss1 = {
                    name = "Witherbark",
                    bossIDs = {81522},
                    achievement = 9017,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheEverbloom:Witherbark() end,
					partial = false,
                },
                boss2 = {
                    name = "Archmage Sol",
                    bossIDs = {},
                    achievement = 9493,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Yalnu",
                    bossIDs = {}, --83846
                    achievement = 9223,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            ShadowmoonBurialGrounds = {
                name = "Shadowmoon Burial Grounds",
                boss1 = {
                    name = "Sadana Bloodfury",
                    bossIDs = {},
                    achievement = 9018,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Bonemaw",
                    bossIDs = {77006, 75452},
                    achievement = 9025,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ShadowmoonBurialGrounds:Bonemaw() end,
					partial = true,
                },
                boss3 = {
                    name = "Ner'zhul",
                    bossIDs = {76407},
                    achievement = 9026,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ShadowmoonBurialGrounds:Nerzhul() end,
					partial = false,
                },
            },

            UpperBlackrockSpire = {
                name = "Upper Blackrock Spire",
                boss1 = {
                    name = "Orebender Gor'ashan",
                    bossIDs = {76413},
                    achievement = 9045,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.UpperBlackrockSpire:OrebenderGorashan() end,
					partial = false,
                },
                boss2 = {
                    name = "Other 12",
                    bossIDs = {},
                    achievement = 9058,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Ragewing the Untamed",
                    bossIDs = {76585},
                    achievement = 9056,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.UpperBlackrockSpire:RagewingTheUntamed() end,
					partial = false,
                },
                boss4 = {
                    name = "Warlord Zaela",
                    bossIDs = {77120},
                    achievement = 9057,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.UpperBlackrockSpire:WarlordZaela() end,
					partial = false,
                },
            },
        },
    },

    MistsOfPandaria = {
        Raids = {
            TerraceOfEndlessSpring = {
                name = "Terrace of Endless Spring",
                boss1 = {
                    name = "Protectors of the Endless",
                    bossIDs = {60583, 60586, 60585},
                    achievement = 6717,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement takes 3 weeks to complete. All you need to do is rotate which 1 of the 3 bosses is to be killed last each week",
                    enabled = true,
                    track = function() core.TerraceOfEndlessSpring:ProtectorsOfTheEndless() end,
                    partial = false,
                },
                boss2 = {
                    name = "Tsulong",
                    bossIDs = {62442},
                    achievement = 6933,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply nuke the boss since it takes ~70 seconds for the enchanted plant to die without any healing",
                    enabled = true,
                    track = function() core.TerraceOfEndlessSpring:Tsulong() end,
                    partial = false,
                },
                boss3 = {
                    name = "Lei Shi",
                    bossIDs = {62983},
                    achievement = 6824,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Once you have started the fight. Every player must go down the steps to left and right of the boss into the water and walk up to a Parasitoid Sha. Once a player is close enough to the Parasitoid Sha it will attach itself to the head of that player. Once everyone in the raid has a Parasitoid Sha on their head, you can single target the boss down. Do not use multi-target abilities since you may accidently kill a Parasitoid Sha",
                    enabled = true,
                    track = function() core.TerraceOfEndlessSpring:LeiShi() end,
                    partial = false,
                },
                boss4 = {
                    name = "Sha of Fear",
                    bossIDs = {60999},
                    achievement = 6825,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply nuke the boss. Make sure you stand in the light to avoid getting feared",
                    enabled = true,
                    track = function() core.TerraceOfEndlessSpring:ShaOfFear() end,
                    partial = false,
                },
            },

            ThroneOfThunder = {
                name = "Throne of Thunder",
                boss1 = {
                    name = "Jin'rokh the Breaker",
                    bossIDs = {},
                    achievement = 8094,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "The boss will randomly cast Focused Lighting Orbs on players. If the orb reaches the player it will explode. 2 players need to get the focused lighting orbs to explode into each other. To do this run away from the orb if it has been targeted on you. Once a 2nd orb has spawned, run your orb into the other players orb.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Horridon",
                    bossIDs = {68476},
                    achievement = 8038,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply nuke the boss down before any Zandalari Dinomancers spawn.",
                    enabled = true,
                    track = function() core.ThroneOfThunder:Horridon() end,
                    partial = false,
                },
                boss3 = {
                    name = "Council of Elders",
                    bossIDs = {},
                    achievement = 8073,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply nuke down the boss. Make sure everyone is in the inner circle before pulling the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Tortos",
                    bossIDs = {67977},
                    achievement = 8077,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill at least 6 Whirl Turtles in a line next to one another. Once you have enough Whirl Turtles. Click on one the whirl turtle at either end of the line to kick it into the other turtles. Make sure you are facing towards the other turtles so it gets sent in the correct direction.",
                    enabled = true,
                    track = function() core.ThroneOfThunder:Tortos() end,
                    partial = false,
                },
                boss5 = {
                    name = "Megaera",
                    bossIDs = {70235, 70212, 70247},
                    achievement = 8082,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement takes 3 kills to complete. During the encounter only kill 2 of the heads leaving out a different head each time.",
                    enabled = true,
                    track = function() core.ThroneOfThunder:Megaera() end,
					partial = false,
                },
                boss6 = {
                    name = "Ji-Kun",
                    bossIDs = {69712},
                    achievement = 8097,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "The golden egg will fall from the nest in the ceiling to the right of the boss from where you land. To do this achievement 1 player needs to jump down to the nest to the right below the platform 10 seconds after pulling the boss. Once the player is down there they need to kill the adds. This should give them a special action ability which they can use to fly up to the nest in the celling. Once there they need to watch out for the golden egg and click on it as quickly as possible. Once they have caught the egg you need a priest to cast leap of faith on that player back onto the platform. Once the egg is safely on the platform, the player with the egg must avoid all damage otherwise they will drop the egg. Nuke down the boss as soon as the egg is on the platform.",
                    enabled = true,
                    track = function() core.ThroneOfThunder:JiKun() end,
                    partial = false,
                },
                boss7 = {
                    name = "Durumu the Forgotten",
                    bossIDs = {68036},
                    achievement = 8098,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Throughout the fight there will be 3 flashes of white light somewhere on the platform. To complete this achievement the 3 players that get targeted with the beams need to stand on top of the white fog to reveal one of 3 fog beasts (orange, purple and green). Once all fog beasts have been revealed you can nuke the boss.",
                    enabled = true,
                    track = function() core.ThroneOfThunder:DurumuTheForgotten() end,
                    partial = false,
                },
                boss8 = {
                    name = "Primordius",
                    bossIDs = {69017},
                    achievement = 8037,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke down the boss. Do not stand in any puddles on the ground.",
                    enabled = true,
                    track = function() core.ThroneOfThunder:Primordius() end,
                    partial = false,
                },
                boss9 = {
                    name = "Dark Animus",
                    bossIDs = {},
                    achievement = 8081,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement may take more than 1 run to complete although you can have multiple attempts during the same lockout. If you kill the Dark Ritualists without pulling the boss, you can reset the instance since they are counted as trash mobs. To do this convert the raid to heroic after killing the ritualists. Wait for a prompt to appear on your screen asking you to leave the instance. Once you are out of the instance, change the instance mode back to normal and then reset the instance. This can be done 9 time before you get locked out of the instance.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss10 = {
                    name = "Iron Qon",
                    bossIDs = {68078},
                    achievement = 8087,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke down the boss.",
                    enabled = true,
                    track = function() core.ThroneOfThunder:IronQon() end,
                    partial = false,
                },
                boss11 = {
                    name = "Twin Consorts",
                    bossIDs = {68905, 68904},
                    achievement = 8086,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, nuke down Lu’lin first then kill Suen.",
                    enabled = true,
                    track = function() core.ThroneOfThunder:TwinConsorts() end,
                    partial = false,
                },
                boss12 = {
                    name = "Lei Shen",
                    bossIDs = {68397},
                    achievement = 8090,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement takes 4 kills to complete. Around the corners of the room there are 4 conduits. The boss will teleport to each conduit. Each week pick a different conduit to pull the boss at. Wait for the conduit to reach 3 stacks and overload then nuke the boss down.",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
            },

            SiegeOfOrgrimmar = {
                name = "Siege of Orgrimmar",
                boss1 = {
                    name = "Immerseus",
                    bossIDs = {71543},
                    achievement = 8536,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "During the split phase, crowd control the Sha Puddles on the ground. Keep them crowed controlled until they turn into Tears of the vale. At which point you can kill them. Kill 10 Tears of the vale to gain the achievement.",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:Immerseus() end,
                    partial = false,
                },
                boss2 = {
                    name = "The Fallen Protectors",
                    bossIDs = {}, --71475, 71479, 71480
                    achievement = 8528,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 66% the boss will place " .. GetSpellLink(144365) .. " on a random player. You need to transfer this mark to 5 players by using the special action button on your screen which will appear once you have the debuff. You also need to transfer the Mark of Anguish at least 200 yards around the room. Spread the group around the room 40yards apart and continue to transfer the mark until the achievement goes white.",
                    enabled = false,
                    track = nil,
                    partial = true,
                },
                boss3 = {
                    name = "Amalgam of Corruption",
                    bossIDs = {72276},
                    achievement = 8532,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply just nuke the boss to gain the achievement",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:AmalgamOfCorruption() end,
                    partial = false,
                },
                boss4 = {
                    name = "Sha of Pride",
                    bossIDs = {71734},
                    achievement = 8521,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply just nuke the boss to gain the achievement",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:ShaOfPride() end,
                    partial = true,
                },
                boss5 = {
                    name = "Galakras",
                    bossIDs = {72311},
                    achievement = 8530,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply just nuke the adds and boss to gain the achievement",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:Galakras() end,
                    partial = true,
                },
                boss6 = {
                    name = "Iron Juggernaut",
                    bossIDs = {71466},
                    achievement = 8520,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "During the Siege phase, a random player will get targeted with the " .. GetSpellLink(144918) .. ". This player needs to kite the laser through the mines on the ground. Once the mines have been run over by the laser they will turn superheated. At this point click on the mines to stomp on them. Stomp on 6 superheated mines to earn the achievement.",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:IronJuggernaut() end,
                    partial = false,
                },
                boss7 = {
                    name = "Kor'kron Dark Shaman",
                    bossIDs = {},
                    achievement = 8453,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Warning: Do not AOE trash after Iron Juggernaut. 1.) Kill the Oversear with the axe to save Ji Firepaw (you only have a few seconds after entering the room to do this). 2.) Save either the Theramore citizens being held by Overseer Thathung (do not kill the citizens) or save the orcs being held by Overseer Mojka (do not kill the orcs).  3.) Collect a key from Mokuar the Treasurer and unlock a cage of prisoners.",
                    enabled = true,
                    track = function()  end,
                },
                boss8 = {
                    name = "General Nazgrim",
                    bossIDs = {71515},
                    achievement = 8448,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Release Gamon from the chains just outside the entrance to The Drag. Wait for Gamon to reach the boss before pulling, then just nuke the boss down.",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:GeneralNazgrim() end,
                    partial = false,
                },
                boss9 = {
                    name = "Malkorok",
                    bossIDs = {71454},
                    achievement = 8538,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Drag the Corrupted Skullsplitter mob from the bottom of the stairs to Malkorok. Place the Corrupted Skullsplitter in the area the boss casts his Arcing Smash ability in. If the boss does not cast this ability then you need to dps the boss down the little. The boss will eventually cast Breath of Y'shaarj which should turn the Corrupted Skullspitter into a Corrupted Amalgamation. Once this happens nuke the add & boss.",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:Malkorok() end,
                    partial = false,
                },
                boss10 = {
                    name = "Spoils of Pandaria",
                    bossIDs = {71385, 71398, 71383, 71397, 71405, 73951, 71409, 71388, 73948, 73949, 71380, 72535, 71392, 71433, 71378, 71395, 71393, 71408, 73723, 73724, 73725},
                    achievement = 8529,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Requires at least 2 players. Split the group into 2. One group should only kill Mantid mobs and the other group should only kill Mogu mobs. This is done by one group clearing each mob type on one side of the room then using the hook to move to move back up and across to the other side of the room. Do not go through the door in the middle of the two rooms.",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:SecuredStockpileOfPandarenSpoils() end,
                    partial = false,
                },
                boss11 = {
                    name = "Thok the Bloodthirsty",
                    bossIDs = {}, --71529
                    achievement = 8527,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Requires at least 5 players. All players in the group need to reduce health to 50% or lower. Once this has happened the boss will move into the next phase. In this phase If you get fixated by the boss run away otherwise you will be instant killed. Kill the Kor’kron Jailer that spawns, pick up the key that drops and open the cage to the left of the room as you entered. Once the cage has been unlocked 3 times, the snail will come out. Nuke down the boss and wait for the snail to eat the remains.",
                    enabled = false,
                    track = nil,
                    partial = false,
                },
                boss12 = {
                    name = "Siegecrafter Blackfuse",
                    bossIDs = {71504},
                    achievement = 8543,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply just nuke the boss to gain the achievement",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:SiegecrafterBlackfuse() end,
                    partial = false,
                },
                boss13 = {
                    name = "Paragons of the Klaxxi",
                    bossIDs = {71158, 71152, 71155, 71153, 71157, 71160, 71156, 71154, 71161},
                    achievement = 8531,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement takes 3 kills to complete. Once each of bosses is killed, click on the boss to gain one of the appearances. Your role will dictate which bosses you gain appearances from. Nuke the bosses down slowly to make sure you get an appearance.",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:Paragons() end,
                    partial = false,
                },
                boss14 = {
                    name = "Garrosh Hellscream",
                    bossIDs = {71865},
                    achievement = 8537,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Wait for 18 Kor’kron Warbringers to spawn. While waiting kill the siege engineers so that the Iron Stars are not launched. Also kill the shamans so they don’t heal the mobs later on. Once you have enough mobs stand at the opposite end and facing one the iron stars (this is done so the mobs are not accidently killed by the other iron star). Stop killing the engineers and wait for the Warbringers to get killed.",
                    enabled = true,
                    track = function() core.SiegeOfOrgrimmar:GarroshHellscream() end,
                    partial = false,
                },
            },

            HeartOfFear = {
                name = "Heart of Fear",
                boss1 = {
                    name = "Imperial Vizier Zor'lok",
                    bossIDs = {62980},
                    achievement = 6937,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "The " .. GetSpellLink(125785) .. " bugs spawn at the four pillars around the center of the room. 2 Zealous Parasite spawn at each pillar at a time. Every player needs to click on one of these Zealous Parasite to gain a debuff. Once every player in the group has got the debuff you can kill the boss. All players in the raid need to be alive and have the debuff to gain the achievement.",
                    enabled = true,
                    track = function() core.HeartOfFear:ImperialVizierZorlok() end,
                    partial = false,
                },
                boss2 = {
                    name = "Blade Lord Ta'yak",
                    bossIDs = {},
                    achievement = 6936,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "There are 4 Braziers in the center of the room and 2 braziers to the far left and far right of the room as you are looking at the boss. Once the boss has reached 20% health you need to click on the braziers in the middle of the room which are lit up to gain the " .. GetSpellLink(128949) .. " buff. You then need to run to one of the brazier on the far right/left to light it up. Once all 4 far braziers are lit up you can kill the boss",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Garalon",
                    bossIDs = {62164, 63053},
                    achievement = 6553,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can single target the boss to gain the achievement. Avoid AOE as this may kill the legs",
                    enabled = true,
                    track = function() core.HeartOfFear:Garalon() end,
                    partial = false,
                },
                boss4 = {
                    name = "Wind Lord Mel'jarak",
                    bossIDs = {},
                    achievement = 6683,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply just nuke the boss to gain this achievement",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Amber-Shaper Un'sok",
                    bossIDs = {},
                    achievement = 6518,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "For this achievement you will need atleast 2 players. Once you pull the boss, kill the Living Amber so that the pools that spawn once these adds are killed are stacked on top of one another. Once you have 8 pools stacked ontop of one another, you can nuke the boss. If a player becomes an Amber Monster then nuke that player down to 20% health to free them",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss6 = {
                    name = "Grand Empress Shek'zeer",
                    bossIDs = {62837},
                    achievement = 6922,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "For this achievement you need a way to taunt the boss between 2 targets to manage the " .. GetSpellLink(123707) .. " debuff. 2 players will need to taunt at 4 stacks of the debuff to avoid dying. This will keep happening until the boss reaches 0 energy at which points the adds will spawn. Nuke down the 2 Kor'thik Reavers within 10 seconds of each other and then kill the boss to gain this achievement",
                    enabled = true,
                    track = function() core.HeartOfFear:GrandEmpressShekzeer() end,
                    partial = false,
                },
            },

            MoguShanVaults = {
                name = "MoguShan Vaults",
                boss1 = {
                    name = "The Stone Guard",
                    bossIDs = {},
                    achievement = 6823,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "For this achievement every player must have a canine companion pet summoned. The following pets definately work with the achievement: " .. GetSpellLink(70613) .. " " .. GetSpellLink(69452) .. " " .. GetSpellLink(90637),
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Feng the Accursed",
                    bossIDs = {60009},
                    achievement = 6674,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "For this achievment you need to reverse the following abilities: " .. GetSpellLink(116936) .. " " .. GetSpellLink(118307) .. " " .. GetSpellLink(118194) .. " " .. GetSpellLink(115730) .. " " .. GetSpellLink(116938) .. ". To reverse these abilities a tank spec'ed player need to pick up the " .. GetSpellLink(115911) .. " which is located to left of the boss. Phase 1: 95%; Epicenter is cast by boss; Lighting fists has to be reversed on a player who gets stunned by soaking the ability. Phase 2: 66%; Wildfire Spark is cast on a player. Phase 3: At 33%; Arcane Velocity is cast by boss; Arcane Resonance is cast on a player. Once all 5 abilities have been reversed you can kill boss. Note: if you do the instance on heroic difficulty the phases may be in a different order",
                    enabled = true,
                    track = function() core.MoguShanVaults:FengTheAccursed() end,
                    partial = false,
                },
                boss3 = {
                    name = "Gara'jal the Spiritbinder",
                    bossIDs = {},
                    achievement = 7056,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "The Spirit Kings",
                    bossIDs = {},
                    achievement = 6687,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Elegon",
                    bossIDs = {60410},
                    achievement = 6686,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.MoguShanVaults:Elegon() end,
					partial = false,
                },
                boss6 = {
                    name = "Will of the Emperor",
                    bossIDs = {60400, 60399},
                    achievement = 6455,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.MoguShanVaults:WillOfTheEmperor() end,
					partial = false,
                },
            },
        },

        Dungeons = {
            StormstoutBrewery = {
                name = "Stormstout Brewery",
                boss1 = {
                    name = "Ook-Ook",
                    bossIDs = {56637},
                    achievement = 6089,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.StormstoutBrewery:OokOok() end,
                    partial = false,
                },
                boss2 = {
                    name = "Other 13",
                    bossIDs = {},
                    achievement = 6400,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = nil,
                    partial = false,
                },                
                boss3 = {
                    name = "Hoptallus",
                    bossIDs = {59426, 59460, 56718, 59459, 59461, 59551},
                    achievement = 6420,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.StormstoutBrewery:Hoptallus() end,
                    partial = false,
                },
                boss4 = {
                    name = "Other 14",
                    bossIDs = {},
                    achievement = 6402,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            ScarletHalls = {
                name = "Scarlet Halls",
                boss1 = {
                    name = "Houndmaster Braun",
                    bossIDs = {58876, 58674, 59309},
                    achievement = 6684,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ScarletHalls:HoundmasterBraun() end,
					partial = true,
                },
                boss2 = {
                    name = "Armsmaster Harlan",
                    bossIDs = {58632},
                    achievement = 6427,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ScarletHalls:ArmsmasterHarlan() end,
					partial = false,
                },
            },

            ScarletMonastery = {
                name = "Scarlet Monastery",
                boss1 = {
                    name = "Thalnos the Soulrender",
                    bossIDs = {59789},
                    achievement = 6946,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ScarletMonastery:ThalnosTheSoulrender() end,
					partial = false,
                },
                boss2 = {
                    name = "Brother Korloff",
                    bossIDs = {},
                    achievement = 6928,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "High Inquisitor Whitemane",
                    bossIDs = {60040, 3977},
                    achievement = 6929,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ScarletMonastery:HighInquisitorWhitemane() end,
					partial = false,
                },
            },

            Scholomance = {
                name = "Scholomance",
                boss1 = {
                    name = "Jandice Barov",
                    bossIDs = {},
                    achievement = 6531,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Rattlegore",
                    bossIDs = {59153},
                    achievement = 6394,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Scholomance:Rattlegore() end,
					partial = false,
                },
                boss3 = {
                    name = "Other 15",
                    bossIDs = {59368},
                    achievement = 6396,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Scholomance:Sanguinarian() end,
					partial = true,
                },
                boss4 = {
                    name = "Other 16",
                    bossIDs = {},
                    achievement = 6821,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Other 17",
                    bossIDs = {},
                    achievement = 6715,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            TempleOfTheJadeSerpent = {
                name = "Temple of the Jade Serpent",
                boss1 = {
                    name = "Wise Mari",
                    bossIDs = {56448},
                    achievement = 6460,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TempleOfTheJadeSerpent:WiseMari() end,
					partial = false,
                },
                boss2 = {
                    name = "Sha of Doubt",
                    bossIDs = {56439},
                    achievement = 6671,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TempleOfTheJadeSerpent:ShaOfDoubt() end,
					partial = false,
                },
                boss3 = {
                    name = "Sha of Doubt 2",
                    bossIDs = {56439},
                    achievement = 6475,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TempleOfTheJadeSerpent:ShaOfDoubt2() end,
					partial = false,
                },
            },

            MoguShanPalace = {
                name = "MoguShan Palace",
                boss1 = {
                    name = "Gekkan",
                    bossIDs = {},
                    achievement = 6478,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Xin the Weaponmaster",
                    bossIDs = {61398},
                    achievement = 6736,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.MoguShanPalace.XinTheWeaponmaster() end,
					partial = false,
                },
                boss3 = {
                    name = "Other Mogu",
                    bossIDs = {},
                    achievement = 6713,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            ShadoPanMonastery = {
                name = "Shado Pan Monastery",
                boss1 = {
                    name = "Master Snowdrift",
                    bossIDs = {},
                    achievement = 6477,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Sha of Violence",
                    bossIDs = {56719},
                    achievement = 6472,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ShadoPanMonastery:ShaOfViolence() end,
					partial = false,
                },
                boss3 = {
                    name = "Taran Zhu",
                    bossIDs = {56884},
                    achievement = 6471,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ShadoPanMonastery:TaranZhu() end,
					partial = false,
                },
            },
    
            SiegeOfNiuzaoTemple = {
                name = "Siege of Niuzao Temple",
                boss1 = {
                    name = "Commander Vo'jak",
                    bossIDs = {63106,61699,61670,61701,61634},
                    achievement = 6688,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.SiegeOfNiuzaoTemple:CommanderVojak() end,
					partial = true,
                },
                boss2 = {
                    name = "General Pa'valak",
                    bossIDs = {61485},
                    achievement = 6485,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.SiegeOfNiuzaoTemple:GeneralPaValak() end,
					partial = false,
                },
                boss3 = {
                    name = "Wing Leader Ner'onok",
                    bossIDs = {62205},
                    achievement = 6822,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.SiegeOfNiuzaoTemple:WingLeaderNeronok() end,
					partial = false,
                },
            },

            GateOfTheSettingSun = {
                name = "Gate of the Setting Sun",
                boss1 = {
                    name = "Saboteur Kip'tilak",
                    bossIDs = {56906},
                    achievement = 6479,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.GateOfTheSettingSun:SaboteurKiptilak() end,
					partial = false,
                },
                boss2 = {
                    name = "Other 18",
                    bossIDs = {},
                    achievement = 6476,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Raigonn",
                    bossIDs = {56877},
                    achievement = 6945,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.GateOfTheSettingSun:Raigonn() end,
					partial = false,
                },
            },
        },
    },

    Cataclysm = {
        Raids = {
            DragonSoul = {
                name = "Dragon Soul",
                boss1 = {
                    name = "Morchok",
                    bossIDs = {},
                    achievement = 6174,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Warlord Zon'ozz",
                    bossIDs = {55308},
                    achievement = 6128,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss but don’t kill him. When a purple ball spawns, run into it. Every time you run into the purple ball it will change direction. Run into the purple ball 10 times then nuke the boss. Try to aim the purple ball away from the boss so that it doesn’t get absorbed by the boss.",
                    enabled = true,
                    track = function() core.DragonSoul:WarlordZonozz() end,
                    partial = false,
                },
                boss3 = {
                    name = "Yor'sahj the Unsleeping",
                    bossIDs = {55312},
                    achievement = 6129,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss but don’t kill him. Wait for the oozes around the edge of the room to reach the boss. Once all 4 colour combinations have reached the boss (Black & Yellow, Black & Blue, Red & Green & Purple & Yellow) you can kill him. This will take several ooze phases to get all the combinations. It doesn’t matter if the other oozes reach the boss that are not listed as a colour combination. Therefore, you can just AFK until the requirements of the achievement have been met.",
                    enabled = true,
                    track = function() core.DragonSoul:YorsahjTheUnsleeping() end,
                    partial = false,
                },
                boss4 = {
                    name = "Hagara the Stormbinder",
                    bossIDs = {},
                    achievement = 6175,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Ultraxion",
                    bossIDs = {55294},
                    achievement = 6084,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.DragonSoul:Ultraxion() end,
                    partial = false,
                },
                boss6 = {
                    name = "Warmaster Blackhorn",
                    bossIDs = {56598},
                    achievement = 6105,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "For this achievement you will need a ranged dps ability. As soon as Twilight Assault Drakes spawn kill them as soon as they come in range. If you kill these drakes before they reach the ship, then you don’t have to worry about soaking any abilities. This is the only requirements to the achievement, any other damage to the ship such as Twilight Onslaught does not need to be absorbed.",
                    enabled = true,
                    track = function() core.DragonSoul:Skyfire() end,
                    partial = false,
                },
                boss7 = {
                    name = "Spine of Deathwing",
                    bossIDs = {53879},
                    achievement = 6133,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.DragonSoul:SpineOfDeathwing() end,
                    partial = false,
                },
                boss8 = {
                    name = "Madness of Deathwing",
                    bossIDs = {},
                    achievement = 6180,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() end,
                    partial = false,
                },
            },

            BlackwingDescent = {
                name = "Blackwing Descent",
                boss1 = {
                    name = "Magmaw",
                    bossIDs = {41570},
                    achievement = 5306,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.BlackwingDescent:Magmaw() end,
                    partial = false,
                },
                boss2 = {
                    name = "Omnotron Defense System",
                    bossIDs = {42178, 42179, 42180, 42166},
                    achievement = 5307,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.BlackwingDescent:OminitronDefenseSystem() end,
                    partial = false,
                },
                boss3 = {
                    name = "Maloriak",
                    bossIDs = {41378},
                    achievement = 5310,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Damage the boss down to 25%. Be careful you don’t 1 shot the boss. Once 12 abbreviations have spawned AOE them down then kill boss. Make sure you don’t kill the boss before the adds have been AOE’d down.",
                    enabled = true,
                    track = function() core.BlackwingDescent:Maloriak() end,
                    partial = false,
                },
                boss4 = {
                    name = "Atramedes",
                    bossIDs = {41442},
                    achievement = 5308,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() end,
                    partial = false,
                },
                boss5 = {
                    name = "Chimaeron",
                    bossIDs = {43296},
                    achievement = 5309,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.BlackwingDescent:Chimaeron() end,
                    partial = false,
                },
                boss6 = {
                    name = "Nefarian",
                    bossIDs = {41270, 41376},
                    achievement = 4849,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.BlackwingDescent:Nefarian() end,
                    partial = false,
                },
            },

            BastionOfTwilight = {
                name = "Bastion of Twilight",
                boss1 = {
                    name = "Halfus Wyrmbreaker",
                    bossIDs = {44600},
                    achievement = 5300,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss but kill him. Free 2 of the dragons around the room by interacting with them. The whelps count as 1 dragon as well. Kill the 2 dragons within 10 seconds of one another then kill the boss.",
                    enabled = true,
                    track = function() core.BastionOfTwilight:HalfusWyrmbreaker() end,
                    partial = false,
                },
                boss2 = {
                    name = "Valiona And Theralion",
                    bossIDs = {45992},
                    achievement = 4852,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull then bosses but don’t kill them. Wait for the spell Dazzling Destruction to cast. Once the boss has cast the spell stand in the pool that was created by the spell so that you get transferred to the shadow realm. Once you are in the shadow realm, kill 6 Twilight Fiends. Once the requirements have been met you can kill boss.",
                    enabled = true,
                    track = function() core.BastionOfTwilight_ValionaAndTheralion() end,
                    partial = false,
                },
                boss3 = {
                    name = "Ascendant Council",
                    bossIDs = {},
                    achievement = 5311,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Cho'gall",
                    bossIDs = {43324},
                    achievement = 5312,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke boss down.",
                    enabled = true,
                    track = function() end,
                    partial = false,
                },
            },

            ThroneOfTheFourWinds = {
                name = "Throne of the Four Winds",
                boss1 = {
                    name = "Conclave of Wind",
                    bossIDs = {},
                    achievement = 5304,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Al'Akir",
                    bossIDs = {},
                    achievement = 5305,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            Firelands = {
                name = "Firelands",
                boss1 = {
                    name = "Beth'tilac",
                    bossIDs = {52498},
                    achievement = 5821,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke down the boss.",
                    enabled = true,
                    track = function() core.Firelands:Bethtilac() end,
                    partial = false,
                },
                boss2 = {
                    name = "Lord Rhyolith",
                    bossIDs = {52558},
                    achievement = 5810,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Single target dps down the right leg. Do not touch the left leg.",
                    enabled = true,
                    track = function() end,
                    partial = false,
                },
                boss3 = {
                    name = "Alysrazor",
                    bossIDs = {52530},
                    achievement = 5813,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke down the boss.",
                    enabled = true,
                    track = function() core.Firelands:Alysrazor() end,
                    partial = false,
                },
                boss4 = {
                    name = "Shannox",
                    bossIDs = {},
                    achievement = 5829,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Baleroc",
                    bossIDs = {53494},
                    achievement = 5830,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke down the boss.",
                    enabled = true,
                    track = function() core.Firelands:Baleroc() end,
                    partial = false,
                },
                boss6 = {
                    name = "Majordomo Staghelm",
                    bossIDs = {},
                    achievement = 5799,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
                boss7 = {
                    name = "Ragnaros",
                    bossIDs = {52409},
                    achievement = 5855,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Firelands:Ragnaros() end,
					partial = false,
                },
            },
        },

        Dungeons = {
            BlackrockCaverns = {
                name = "Blackrock Caverns",
                boss1 = {
                    name = "Rom'ogg Bonecrusher",
                    bossIDs = {39665},
                    achievement = 5281,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.BlackrockCaverns:RomoggBonecrusher() end,
					partial = false,
                }, 
                boss2 = {
                    name = "Corla",
                    bossIDs = {39679},
                    achievement = 5282,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "After pulling the boss wait for the three zealots evolve. This is done by not standing in the way of the beams being channelled to the mobs. Once they have all evolved you can nuke the boss.",
                    enabled = true,
                    track = function() core.BlackrockCaverns:Corla() end,
					partial = false,
                },  
                boss3 = {
                    name = "Karsh Steelbender",
                    bossIDs = {39698},
                    achievement = 5283,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss into the fire in the middle of the room until he reaches 15 stacks of Superheated Quicksilver Armor. Once he has 15 stacks you can nuke the boss.",
                    enabled = true,
                    track = function() core.BlackrockCaverns:KarshSteelbender() end,
					partial = false,
                },  
                boss4 = {
                    name = "Ascendant Lord Obsidius",
                    bossIDs = {39705},
                    achievement = 5284,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply just nuke the boss",
                    enabled = true,
                    track = function() core.BlackrockCaverns:AscendantLordObsidius() end,
					partial = false,
                },                 
            },

            ThroneOfTheTides = {
                name = "Throne of the Tides",
                boss1 = {
                    name = "Lady Naz'Jar",
                    bossIDs = {40586},
                    achievement = 5285,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Damage the boss down to about 40% health. Be careful that you don’t 1 shot the boss. When the boss transitions to the next phase, kill the 2 caster adds but keep the melee add up. Once the geyser spawns drag the remaining add into the geyser until it gets killed. This may have to done multiple times. Once the add has been killed by the geyser, you can kill the boss.",
                    enabled = true,
                    track = function() core.ThroneOfTheTides:LadyNazjar() end,
					partial = false,
                },
                boss2 = {
                    name = "Ozumat",
                    bossIDs = {44658, 44715, 44648},
                    achievement = 5286,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ThroneOfTheTides:Ozumat() end,
					partial = false,
                },                  
            },

            TheStonecore = {
                name = "The Stonecore",
                boss1 = {
                    name = "High Priestess Azil",
                    bossIDs = {42333},
                    achievement = 5287,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheStonecore:HighPriestessAzil() end,
					partial = false,
                },               
            },

            TheVortexPinnacle = {
                name = "The Vortex Pinnacle",
                boss1 = {
                    name = "Asaad",
                    bossIDs = {43875},
                    achievement = 5288,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.TheVortexPinnacle:Asaad() end,
					partial = false,
                },
                boss2 = {
                    name = "Other 19",
                    bossIDs = {},
                    achievement = 5289,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },                
            },

            GrimBatol = {
                name = "Grim Batol",
                boss1 = {
                    name = "General Umbriss",
                    bossIDs = {39625},
                    achievement = 5297,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for a Malignant Trogg to spawn. Kill the Malignant Trogg next to the boss. Once the boss has got the Modgud's Malice from the killed add then you can kill the boss.",
                    enabled = true,
                    track = function() core.GrimBatol:GeneralUmbriss() end,
					partial = false,
                },
                boss2 = {
                    name = "Erudax",
                    bossIDs = {40484},
                    achievement = 5298,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.GrimBatol:Erudax() end,
					partial = false,
                },               
            },

            HallsOfOrigination = {
                name = "Halls of Origination",
                boss1 = {
                    name = "Temple Guardian Anhuur",
                    bossIDs = {39425},
                    achievement = 5293,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.HallsOfOrigination:TempleGuardianAnhuur() end,
					partial = false,
                },
                boss2 = {
                    name = "Earthrager Ptah",
                    bossIDs = {39428},
                    achievement = 5294,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Mount one of the camels to the left or right of the boss before going up the steps. Once you have mounted a camel, just nuke down the boss.",
                    enabled = true,
                    track = function() core.HallsOfOrigination:EarthragerPtah() end,
					partial = false,
                },
                boss3 = {
                    name = "Other Halls",
                    bossIDs = {},
                    achievement = 5296,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just complete the encounter as usual.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Rajh",
                    bossIDs = {39378},
                    achievement = 5295,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.HallsOfOrigination:Rajh() end,
					partial = false,
                },           
            },

            LostCityOfTheTolVir = {
                name = "Lost City of The TolVir",
                boss1 = {
                    name = "Lockmaw",
                    bossIDs = {43614},
                    achievement = 5291,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss and wait for 20 Frenzied Crocolisk to spawn. Once they have spawned nuke them down within 10 seconds. Make sure you don’t kill the boss before nuking down the adds.",
                    enabled = true,
                    track = function() core.LostCityOfTheTolVir:Lockmaw() end,
					partial = false,
                },  
                boss2 = {
                    name = "High Prophet Barim",
                    bossIDs = {43612},
                    achievement = 5290,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.LostCityOfTheTolVir:HighProphetBarim() end,
					partial = false,
                },  
                boss3 = {
                    name = "Siamat",
                    bossIDs = {44819},
                    achievement = 5292,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.LostCityOfTheTolVir:Siamat() end,
					partial = false,
                },           
            },

            Deadmines = {
                name = "Deadmines",
                boss1 = {
                    name = "Glubtok",
                    bossIDs = {47162},
                    achievement = 5366,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Deadmines:Glubtok() end,
					partial = false,
                },
                boss2 = {
                    name = "Helix Gearbreaker",
                    bossIDs = {47296},
                    achievement = 5367,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss and wait for him to pick you up and charge down the room. Once he has done this Mine Rats will spawn around the room. After you have killed 20 Mine Rats you can kill the boss. The boss will have to do multiple charges so that enough Mine Rats to spawn.",
                    enabled = true,
                    track = function() core.Deadmines:HelixGearbreaker() end,
					partial = false,
                },  
                boss3 = {
                    name = "Foe Reaper 5000",
                    bossIDs = {},
                    achievement = 5368,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110 you can leave the Prototype Reaper alone and just nuke down the boss.",
                    enabled = false,
                    track = nil,
					partial = true,
                },  
                boss4 = {
                    name = "Admiral Ripsnarl",
                    bossIDs = {47626},
                    achievement = 5369,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Damage Ripsnarl until he enters the vapour phase. Be careful that you don’t one shot the boss. Once he enters the vapour phase, wait until 3 Freezing Vapors cast Coalesce before killing boss.",
                    enabled = true,
                    track = function() core.Deadmines:AdmiralRipsnarl() end,
					partial = false,
                },  
                boss5 = {
                    name = "'Captain' Cookie",
                    bossIDs = {47739},
                    achievement = 5370,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, Wait for the boss to enter the pot and attempt to cast Throw Food before killing the boss. If you kill the boss before this has happened, the achievement will not get rewarded.",
                    enabled = true,
                    track = function() core.Deadmines:CaptainCookie() end,
					partial = false,
                },  
                boss6 = {
                    name = "Vanessa VanCleef",
                    bossIDs = {49541},
                    achievement = 5371,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just complete the encounter as quick as possible.",
                    enabled = true,
                    track = function() core.Deadmines:VanessaVanCleef() end,
					partial = false,
                },            
            },

            ShadowfangKeep = {
                name = "Shadowfang Keep",
                boss1 = {
                    name = "Baron Ashbury",
                    bossIDs = {46962},
                    achievement = 5503,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.ShadowfangKeep:BaronAshbury() end,
					partial = false,
                },
                boss2 = {
                    name = "Commander Springvale",
                    bossIDs = {4278},
                    achievement = 5504,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.ShadowfangKeep:CommanderSpringvale() end,
					partial = false,
                },            
                boss3 = {
                    name = "Lord Godfrey",
                    bossIDs = {46964},
                    achievement = 5505,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for the Bloodthirsty Ghouls to spawn. Place the boss in front of the Bloodthirsty Ghouls and wait for the boss to kill the Bloodthirsty Ghouls with his Pistol Barrage ability. Once 12 Ghouls have been killed, you can nuke the boss.",
                    enabled = true,
                    track = function() core.ShadowfangKeep:LordGodfrey() end,
					partial = false,
                },   
            },

            ZulGurub = {
                name = "Zul Gurub",
                boss1 = {
                    name = "Other 20",
                    bossIDs = {},
                    achievement = 5744,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "High Priest Venoxis",
                    bossIDs = {52155},
                    achievement = 5743,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss and wait for him to turn into the snake. While waiting make sure you avoid green stuff on the floor. Once the boss has turned into a snake you can kill him.",
                    enabled = true,
                    track = function() core.ZulGurub:HighPriestVenoxis() end,
					partial = false,
                },
                boss3 = {
                    name = "Bloodlord Mandokir",
                    bossIDs = {52151},
                    achievement = 5762,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke down the boss.",
                    enabled = true,
                    track = function() core.ZulGurub:BloodlordMandokir() end,
					partial = false,
                },
                boss4 = {
                    name = "High Priestess Kilnara",
                    bossIDs = {52059},
                    achievement = 5765,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.ZulGurub:HighPriestessKilnara() end,
					partial = false,
                },
                boss5 = {
                    name = "Jin'do",
                    bossIDs = {52148, 52624},
                    achievement = 5759,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Damage the boss down to below 70% health. Wait for 20 Twisted Spirts to spawn then nuke them down. Once you have killed 20 Twisted spirits in 15 seconds you can kill boss.",
                    enabled = true,
                    track = function() core.ZulGurub:Jindo() end,
					partial = false,
                },
            },

            ZulAman = {
                name = "Zul Aman",
                boss1 = {
                    name = "Halazzi",
                    bossIDs = {23577},
                    achievement = 5750,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.ZulAman:Halazzi() end,
					partial = false,
                },
                boss2 = {
                    name = "Other 21",
                    bossIDs = {},
                    achievement = 5761,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Other 22",
                    bossIDs = {},
                    achievement = 5858,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Daakara",
                    bossIDs = {},
                    achievement = 5760,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down while in the rectangular turquoise stonework.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            EndTime = {
                name = "End Time",
                boss1 = {
                    name = "Echo of Tyrande",
                    bossIDs = {},
                    achievement = 5995,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, run the gauntlet without any player in healing spec. This way you don’t need to worry about a healer taking any damage.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Echo of Sylvanas",
                    bossIDs = {54123},
                    achievement = 6130,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for the Risen Ghouls to spawn. Once the Risen Ghouls have spawned, kill two of them then kill boss.",
                    enabled = true,
                    track = function() core.EndTime:EchoOfSylvanas() end,
					partial = false,
                },
            },

            WellOfEternity = {
                name = "Well of Eternity",
                boss1 = {
                    name = "Peroth'arn",
                    bossIDs = {55085},
                    achievement = 6127,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.WellOfEternity:Perotharn() end,
					partial = false,
                },
                boss2 = {
                    name = "Mannoroth",
                    bossIDs = {54969, 55419},
                    achievement = 6070,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.WellOfEternity:Mannoroth() end,
					partial = false,
                },
            },

            HourOfTwilight = {
                name = "Hour of Twilight",
                boss1 = {
                    name = "Archbishop Benedictus",
                    bossIDs = {54938},
                    achievement = 6132,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Get the boss health down to 50%. Be careful that you don’t 1 shot the boss. Once the boss has entered his shadow form, run round the edges of the room and kill 10 Twilight Sparks. Once 10 Twilight Sparks have been killed, you can kill the boss.",
                    enabled = true,
                    track = function() core.HourOfTwilight:ArchbishopBenedictus() end,
					partial = false,
                },
            },
        },
    },

    WrathOfTheLichKing = {
        Raids = {
            ObsidianSanctum10Man = {
                name = "Obsidian Sanctum 10 Man",
                boss1 = {
                    name = "Sartharion the Onyx Guardian 1",
                    bossIDs = {},
                    achievement = 624,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill the boss with less than 9 players in the group.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Sartharion the Onyx Guardian 2",
                    bossIDs = {},
                    achievement = 2047,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                },  
                boss3 = {
                    name = "Sartharion the Onyx Guardian 3",
                    bossIDs = {},
                    achievement = 2049,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just kill Sartharion and ignore all the other bosses to get this achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                },  
                boss4 = {
                    name = "Sartharion the Onyx Guardian 4",
                    bossIDs = {},
                    achievement = 2050,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just kill Sartharion and ignore all the other bosses to get this achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                },  
                boss5 = {
                    name = "Sartharion the Onyx Guardian 5",
                    bossIDs = {},
                    achievement = 2051,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just kill Sartharion and ignore all the other bosses to get this achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                },                               
            },

            ObsidianSanctum25Man = {
                name = "Obsidian Sanctum 25 Man",
                boss1 = {
                    name = "Sartharion the Onyx Guardian 1",
                    bossIDs = {},
                    achievement = 1877,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill the boss with less than 21 players in the group.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Sartharion the Onyx Guardian 2",
                    bossIDs = {},
                    achievement = 2048,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                },  
                boss3 = {
                    name = "Sartharion the Onyx Guardian 3",
                    bossIDs = {},
                    achievement = 2052,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just kill Sartharion and ignore all the other bosses to get this achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                },  
                boss4 = {
                    name = "Sartharion the Onyx Guardian 4",
                    bossIDs = {},
                    achievement = 2053,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just kill Sartharion and ignore all the other bosses to get this achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                },  
                boss5 = {
                    name = "Sartharion the Onyx Guardian 5",
                    bossIDs = {},
                    achievement = 2054,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just kill Sartharion and ignore all the other bosses to get this achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                },                               
            },

            TheEyeOfEternity10Man = {
                name = "The Eye of Eternity 10 Man",
                boss1 = {
                    name = "Malygos 1",
                    bossIDs = {28859},
                    achievement = 1874,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.TheEyeOfEternity:YouDontHaveAnEternity() end,
					partial = false,
                },
                boss2 = {
                    name = "Malygos 2",
                    bossIDs = {28859},
                    achievement = 1869,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill the boss with fewer than the 9 players in the group.",
                    enabled = true,
                    track = function() core.TheEyeOfEternity:APokeInTheEye() end,
					partial = false,
                }, 
                boss3 = {
                    name = "Malygos 3",
                    bossIDs = {28859},
                    achievement = 2148,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "DPS the boss down below 50% health so that he enters phase 2. Once the boss has entered phase 2 kill one of the Nexus Lord then mount the disc the mob was on. Once you are riding on a disk you can kill a scion of eternity to complete the achievement.",
                    enabled = true,
                    track = function() core.TheEyeOfEternity:DenyinTheScion() end,
					partial = false,
                },                             
            },

            TheEyeOfEternity25Man = {
                name = "The Eye of Eternity 25 Man",
                boss1 = {
                    name = "Malygos 1 25",
                    bossIDs = {28859},
                    achievement = 1875,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.TheEyeOfEternity:YouDontHaveAnEternity() end,
					partial = false,
                },
                boss2 = {
                    name = "Malygos 2 25",
                    bossIDs = {28859},
                    achievement = 1870,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill the boss with fewer than the 21 players in the group.",
                    enabled = true,
                    track = function() core.TheEyeOfEternity:APokeInTheEye() end,
					partial = false,
                }, 
                boss3 = {
                    name = "Malygos 3 25",
                    bossIDs = {28859},
                    achievement = 2149,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "DPS the boss down below 50% health so that he enters phase 2. Once the boss has entered phase 2 kill one of the Nexus Lord then mount the disc the mob was on. Once you are riding on a disk you can kill a scion of eternity to complete the achievement.",
                    enabled = true,
                    track = function() core.TheEyeOfEternity:DenyinTheScion() end,
					partial = false,
                },                             
            },

            OnyxiaSLair10Man = {
                name = "OnyxiaS Lair 10 Man",
                boss1 = {
                    name = "Onyxia 1",
                    bossIDs = {10184},
                    achievement = 4402,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.OnyxiaSLair:Onyxia2() end,
					partial = false,
                },
                boss2 = {
                    name = "Onyxia 2",
                    bossIDs = {},
                    achievement = 4403,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Onyxia 3",
                    bossIDs = {10184},
                    achievement = 4404,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.OnyxiaSLair:Onyxia1() end,
					partial = false,
                },                          
            },

            OnyxiaSLair25Man = {
                name = "OnyxiaS Lair 25 Man",
                boss1 = {
                    name = "Onyxia 1 25",
                    bossIDs = {10184},
                    achievement = 4405,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.OnyxiaSLair:Onyxia2() end,
					partial = false,
                },
                boss2 = {
                    name = "Onyxia 2 25",
                    bossIDs = {}, 
                    achievement = 4406,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Onyxia 3 25",
                    bossIDs = {10184},
                    achievement = 4407,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.OnyxiaSLair:Onyxia1() end,
					partial = false,
                },                          
            },

            TrialOfTheCrusader10Man = {
                name = "Trial of the Crusader 10 Man",
                boss1 = {
                    name = "Icehowl",
                    bossIDs = {34796},
                    achievement = 3797,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down. Make sure you don’t kill the Snobolds that fall of Gormok back after killing him.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:UpperBackPain() end,
					partial = false,
                },
                boss2 = {
                    name = "Acidmaw and Dreadscale",
                    bossIDs = {34796,35144,34799},
                    achievement = 3936,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, nuke down boss bosses within 10 seconds of each other.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:NotOneButTwoJormungars() end,
					partial = false,
                }, 
                boss3 = {
                    name = "Lord Jaraxxus",
                    bossIDs = {34780},
                    achievement = 3996,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, pull the boss then wait for two Mistresses of Pain to spawn. Once they have spawned, single target down the boss.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:ThreeSixtyPainSpike() end,
					partial = false,
                }, 
                boss4 = {
                    name = "Faction Champions",
                    bossIDs = {34461,34460,34469,34467,34468,34465,34471,34466,34473,34472,34463,34470,34474,34475,34458,34451,34459,34448,34449,34445,34456,34447,34441,34454,34455,34444,34450,34453},
                    achievement = 3798,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, nuke down all the enemy heroes within 60 seconds of one another.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:FactionChampions() end,
					partial = false,
                }, 
                boss5 = {
                    name = "Twin Val'kyr",
                    bossIDs = {34497,34496},
                    achievement = 3799,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just simply nuke down one of the bosses since they share the same health pool.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:TwinValkyr() end,
					partial = false,
                }, 
                boss6 = {
                    name = "Anub'arak",
                    bossIDs = {34564},
                    achievement = 3800,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for 25 Swarm Scarabs to spawn. Once enough adds have spawned. AOE them down. Be careful you don’t kill the boss first.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:Anubarak() end,
					partial = false,
                },                     
            },

            TrialOfTheCrusader25Man = {
                name = "Trial of the Crusader 25 Man",
                boss1 = {
                    name = "Icehowl 25 ",
                    bossIDs = {34796},
                    achievement = 3813,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down. Make sure you don’t kill the Snobolds that fall of Gormok back after killing him.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:UpperBackPain() end,
					partial = false,
                },
                boss2 = {
                    name = "Acidmaw and Dreadscale 25",
                    bossIDs = {34796,35144,34799},
                    achievement = 3937,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, nuke down boss bosses within 10 seconds of each other.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:NotOneButTwoJormungars() end,
					partial = false,
                }, 
                boss3 = {
                    name = "Lord Jaraxxus 25",
                    bossIDs = {34780},
                    achievement = 3997,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, pull the boss then wait for two Mistresses of Pain to spawn. Once they have spawned, single target down the boss.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:ThreeSixtyPainSpike() end,
					partial = false,
                }, 
                boss4 = {
                    name = "Twin Val'kyr 25",
                    bossIDs = {34497,34496},
                    achievement = 3815,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just simply nuke down one of the bosses since they share the same health pool.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:TwinValkyr() end,
					partial = false,
                }, 
                boss5 = {
                    name = "Anub'arak 25",
                    bossIDs = {34564},
                    achievement = 3816,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for 25 Swarm Scarabs to spawn. Once enough adds have spawned. AOE them down. Be careful you don’t kill the boss first.",
                    enabled = true,
                    track = function() core.TrialOfTheCrusader:Anubarak() end,
					partial = false,
                },                     
            },

            VaultOfArchavon10Man = {
                name = "Vault of Archavon 10 Man",
                boss1 = {
                    name = "Archavon & Emalon & Koralon",
                    bossIDs = {},
                    achievement = 4016,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },                   
            },

            VaultOfArchavon25Man = {
                name = "Vault of Archavon 25 Man",
                boss1 = {
                    name = "Archavon & Emalon & Koralon",
                    bossIDs = {},
                    achievement = 4017,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },                   
            },

            Ulduar = {
                name = "Ulduar",
                boss1 = {
                    name = "Other 23",
                    bossIDs = {33572},
                    achievement = 12312,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, this achievement is a lot easier to complete without a vehicle. Just run up between 2 of the pillars towards the boss. Wait for 100 adds to attack you then just AOE all the adds down.",
                    enabled = true,
                    track = function() core.Ulduar:Dwarfageddon() end,
					partial = true,
                },
                boss2 = {
                    name = "Other 24",
                    bossIDs = {},
                    achievement = 12313,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill the boss without going over any of the repair pads located at the entrance to the boss room on the right and right.",
                    enabled = true,
                    track = function() end,
					partial = false,
                }, 
                boss3 = {
                    name = "Flame Leviathan 1",
                    bossIDs = {},
                    achievement = 12314,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement will take 3 runs to complete since you will need to mount a different vehicle each time.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss4 = {
                    name = "Flame Leviathan 2",
                    bossIDs = {33113},
                    achievement = 12315,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement requires at least 2 players. The player not going for the achievement needs to drive a demolisher and the player going for the achievements needs to be the passenger of the demolisher. Once you have pulled the boss, load the passenger into the catapult and throw them at the turrets on the boss. Once the player is up on the boss, they need to kill the turret to gain the achievement.",
                    enabled = true,
                    track = function() core.Ulduar:FlameLeviathanTakeOutThoseTurrets() end,
					partial = false,
                }, 
                boss5 = {
                    name = "Flame Leviathan 3",
                    bossIDs = {33113},
                    achievement = 12316,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:FlameLeviathanShutout() end,
					partial = false,
                }, 
                boss6 = {
                    name = "Flame Leviathan 4",
                    bossIDs = {},
                    achievement = 12317,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement can only be completed on the hard mode of the encounter. Hard mode is started by talking to Lore Keeper of Norgannon. This achievement will be awarded if at least one tower is kept alive. At 110 you can simply ignore all the towers and just kill the boss to get the achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss7 = {
                    name = "Flame Leviathan 5",
                    bossIDs = {},
                    achievement = 12318,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement can only be completed on the hard mode of the encounter. Hard mode is started by talking to Lore Keeper of Norgannon. This achievement will be awarded if at least two towers are kept alive. At 110 you can simply ignore all the towers and just kill the boss to get the achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss8 = {
                    name = "Flame Leviathan 6",
                    bossIDs = {},
                    achievement = 12319,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement can only be completed on the hard mode of the encounter. Hard mode is started by talking to Lore Keeper of Norgannon. This achievement will be awarded if at least three towers are kept alive. At 110 you can simply ignore all the towers and just kill the boss to get the achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss9 = {
                    name = "Flame Leviathan 7",
                    bossIDs = {},
                    achievement = 12320,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement can only be completed on the hard mode of the encounter. Hard mode is started by talking to Lore Keeper of Norgannon. This achievement will be awarded if all four towers are kept alive. At 110 you can simply ignore all the towers and just kill the boss to get the achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss10 = {
                    name = "Razorscale 1",
                    bossIDs = {33186},
                    achievement = 12321,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:RazorscaleAQuickShave() end,
					partial = false,
                }, 
                boss11 = {
                    name = "Razorscale 2",
                    bossIDs = {33186},
                    achievement = 12322,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Wait for 25 Dark Rune Guardian Dwarves to spawn then use the harpoons to pull Razorscale down. Once Razorscale is down dps the boss down to below 50% so the boss is permanently grounded. Be careful you don’t one shot the boss. Once the boss is grounded, place the Dark Rune Guardians in front of the boss until they are killed by Razorscale breath ability.",
                    enabled = true,
                    track = function() core.Ulduar:RazorscaleIronDwarfMediumRare() end,
					partial = false,
                }, 
                boss12 = {
                    name = "Ignis the Furnace Master 1",
                    bossIDs = {33118},
                    achievement = 12323,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for 2 Iron Constructs to spawn. Place the 2 Iron Constructs in the fire on the ground until they gain 10 stacks of the Heat Buff. Next drag the 2 Iron Constructs into the water so they turn to stone. Finally nuke down the 2 adds within 5 seconds of one another. Once both adds have died you can kill boss.",
                    enabled = true,
                    track = function() core.Ulduar:IgnisTheFurnaceMasterShattered() end,
					partial = false,
                }, 
                boss13 = {
                    name = "Ignis the Furnace Master 2",
                    bossIDs = {},
                    achievement = 12324,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement requires 2 players or a player with a pet class. The boss will randomly pick players to enter the pot that do not have aggro of the boss. Just pull the boss and wait till everyone gets thrown into the pot.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss14 = {
                    name = "Ignis the Furnace Master 3",
                    bossIDs = {33118},
                    achievement = 12325,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:IgnisTheFurnaceMasterStokinTheFurnace() end,
					partial = false,
                }, 
                boss15 = {
                    name = "XT-002 Deconstructor 1",
                    bossIDs = {33293},
                    achievement = 12326,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:XT002DeconstructorNerfEngineering() end,
					partial = false,
                }, 
                boss16 = {
                    name = "XT-002 Deconstructor 2",
                    bossIDs = {33293},
                    achievement = 12327,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Ulduar:XT002DeconstructorNerfScrapbots() end,
					partial = false,
                }, 
                boss17 = {
                    name = "XT-002 Deconstructor 3",
                    bossIDs = {33293},
                    achievement = 12328,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:XT002DeconstructorNerfGravityBombs() end,
					partial = false,
                }, 
                boss18 = {
                    name = "XT-002 Deconstructor 4",
                    bossIDs = {33293},
                    achievement = 12329,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:XT002DeconstructorMustDeconstructFaster() end,
					partial = false,
                }, 
                boss19 = {
                    name = "XT-002 Deconstructor 5",
                    bossIDs = {33293},
                    achievement = 12330,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss and dps down until you reach 75%, 50% or 25% to start the heart phase. Careful you don’t one shot the boss. Once the heart is exposed nuke it down then kill the boss.",
                    enabled = true,
                    track = function() core.Ulduar:XT002DeconstructorHeartbreaker() end,
					partial = false,
                }, 
                boss20 = {
                    name = "Assembly of Iron 1",
                    bossIDs = {32867,32927,32857},
                    achievement = 12332,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just kill Runemaster Molgeim last.",
                    enabled = true,
                    track = function() core.Ulduar:AssemblyOfIronIChooseYouRunemasterMolgeim() end,
					partial = false,
                }, 
                boss21 = {
                    name = "Assembly of Iron 2",
                    bossIDs = {32867,32927,32857},
                    achievement = 12333,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just kill Stormcaller Brundir last.",
                    enabled = true,
                    track = function() core.Ulduar:AssemblyOfIronIChooseYouStormcallerBrundir() end,
					partial = false,
                }, 
                boss22 = {
                    name = "Assembly of Iron 3",
                    bossIDs = {32867,32927,32857},
                    achievement = 12334,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just kill Steelbreaker last.",
                    enabled = true,
                    track = function() core.Ulduar:AssemblyOfIronIChooseYouSteelbreaker() end,
					partial = false,
                }, 
                boss23 = {
                    name = "Assembly of Iron 4",
                    bossIDs = {},
                    achievement = 12335,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, use the Iron Boot Flask toy then nuke down the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss24 = {
                    name = "Assembly of Iron 5",
                    bossIDs = {32867,32927,32857},
                    achievement = 12336,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "After pulling the boss you must interrupt the first cast of Chain Lightning from Stormcaller Brundir before killing him. Once you have interrupted the spell, nuke down Stormcaller Brundir and then kill the other two bosses.",
                    enabled = true,
                    track = function() core.Ulduar:AssemblyOfIronCantDoThatWhileStunned() end,
					partial = false,
                }, 
                boss25 = {
                    name = "Kologarn 1",
                    bossIDs = {32930,32934,32933},
                    achievement = 12337,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just single target down the boss without killing the arms.",
                    enabled = true,
                    track = function() core.Ulduar:KologarnWithOpenArms() end,
					partial = false,
                }, 
                boss26 = {
                    name = "Kologarn 2",
                    bossIDs = {},
                    achievement = 12338,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, single target down the two arms then kill the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss27 = {
                    name = "Kologarn 3",
                    bossIDs = {32930,32934,32933},
                    achievement = 12339,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:KologarnIfLooksCouldKill() end,
					partial = false,
                }, 
                boss28 = {
                    name = "Kologarn 4",
                    bossIDs = {32930,32934,32933},
                    achievement = 12340,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "After pulling the boss kill the arms until 25 Rubble has spawned. Don’t damage the boss since killing the arms already does a lot of damage to the boss.",
                    enabled = true,
                    track = function() core.Ulduar:KologarnRubbleAndRoll() end,
					partial = false,
                }, 
                boss29 = {
                    name = "Auriaya 1",
                    bossIDs = {33515, 34014},
                    achievement = 12341,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just single target down the boss.",
                    enabled = true,
                    track = function() core.Ulduar:AuriayaCrazyCatLady() end,
                    partial = false,
                    nameplateCheck = true,
                }, 
                boss30 = {
                    name = "Auriaya 2",
                    bossIDs = {33515, 34014},
                    achievement = 12342,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "After pulling the boss wait for the Feral Defender to spawn. Once the Feral Defender has spawned kill him. He will then respawn after a short amount of time. Once the Feral Defender has been killed 9 times you can kill the boss.",
                    enabled = true,
                    track = function() core.Ulduar:AuriayaNineLives() end,
                    partial = false,
                    nameplateCheck = true,
                }, 
                boss31 = {
                    name = "Hodir 1",
                    bossIDs = {32845},
                    achievement = 12343,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke down the boss.",
                    enabled = true,
                    track = function() core.Ulduar:HodirCheeseTheFreeze() end,
					partial = false,
                }, 
                boss32 = {
                    name = "Hodir 2",
                    bossIDs = {32845},
                    achievement = 12344,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, free the adds from the ice tombs then nuke down the boss.",
                    enabled = true,
                    track = function() core.Ulduar:HodirIHaveTheCoolestFriends() end,
					partial = false,
                }, 
                boss33 = {
                    name = "Hodir 3",
                    bossIDs = {32845},
                    achievement = 12345,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke down the boss.",
                    enabled = true,
                    track = function() core.Ulduar:HodirGettingColdInHere() end,
					partial = false,
                }, 
                boss34 = {
                    name = "Hodir 4",
                    bossIDs = {32845},
                    achievement = 12347,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke down the boss.",
                    enabled = true,
                    track = function() core.Ulduar:HodirICouldSayThatThisCacheWasRare() end,
					partial = false,
                }, 
                boss35 = {
                    name = "Hodir 5",
                    bossIDs = {},
                    achievement = 12346,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss36 = {
                    name = "Thorim 1",
                    bossIDs = {32865},
                    achievement = 12348,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke down the boss.",
                    enabled = true,
                    track = function() core.Ulduar:ThorimDontStandInTheLightning() end,
					partial = false,
                }, 
                boss37 = {
                    name = "Thorim 2",
                    bossIDs = {},
                    achievement = 12349,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, complete the gauntlet part of the encounter to gain this achievement.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss38 = {
                    name = "Thorim 3",
                    bossIDs = {},
                    achievement = 12350,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss39 = {
                    name = "Thorim 4",
                    bossIDs = {},
                    achievement = 12351,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke down the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss40 = {
                    name = "Thorim 5",
                    bossIDs = {},
                    achievement = 12352,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke down the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss41 = {
                    name = "Freya Mini Bosses",
                    bossIDs = {32914, 32913, 32915},
                    achievement = 12360,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull Elder Brightleaf, Elder Ironbranch and Elder Stonebark together in the Freya boss room and kill them within 15 seconds of one another.",
                    enabled = true,
                    track = function() core.Ulduar:FreyaLumberjacked() end,
					partial = false,
                }, 
                boss42 = {
                    name = "Freya 1",
                    bossIDs = {}, --33430, 33431, 33528, 33527, 33526, 33525, 32914, 32913, 33354, 33355, 32915
                    achievement = 12361,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "For the achievement just kill the boss within 20 minutes of killing the first creature in the Freya boss room.",
                    enabled = false,
                    track = nil,
					partial = true,
                }, 
                boss43 = {
                    name = "Freya 2",
                    bossIDs = {32906},
                    achievement = 12362,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for 2 Ancient Water Spirits, 2 Storm Lashers and 2 Snaplashers to spawn. Once these have spawned aoe them down within 10 seconds of one another. Be careful that you don’t kill the boss first.",
                    enabled = true,
                    track = function() core.Ulduar:FreyaDeforestation() end,
					partial = false,
                }, 
                boss44 = {
                    name = "Freya 3",
                    bossIDs = {32906},
                    achievement = 12363,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:FreyaGettingBackToNature() end,
					partial = false,
                }, 
                boss45 = {
                    name = "Freya 4",
                    bossIDs = {},
                    achievement = 12364,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Defeat Freya leaving at least one of the following mini bosses alive: Elder Brightleaf, Elder Ironbranch and Elder Stonebark. At 110, just nuke down the boss within killing the mini bosses.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss46 = {
                    name = "Freya 5",
                    bossIDs = {},
                    achievement = 12365,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Defeat Freya leaving at least two of the following mini bosses alive: Elder Brightleaf, Elder Ironbranch and Elder Stonebark. At 110, just nuke down the boss within killing the mini bosses.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss47 = {
                    name = "Freya 6",
                    bossIDs = {},
                    achievement = 12366,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Defeat Freya leaving all three of the following mini bosses alive: Elder Brightleaf, Elder Ironbranch and Elder Stonebark. At 110, just nuke down the boss within killing the mini bosses.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss48 = {
                    name = "Mimiron 1",
                    bossIDs = {33350, 33432},
                    achievement = 12367,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down. If a bomb bot spawns, make sure you kill it before it reaches you.",
                    enabled = true,
                    track = function() core.Ulduar:MimironSetUpUsTheBomb() end,
					partial = false,
                }, 
                boss49 = {
                    name = "Mimiron 2",
                    bossIDs = {33350, 33432},
                    achievement = 12368,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Ulduar:MimironNotSoFriendlyFire() end,
					partial = false,
                }, 
                boss50 = {
                    name = "Mimiron 3",
                    bossIDs = {33350, 33432},
                    achievement = 12369,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Push the red button behind the boss to active hard mode to earn this achievement.",
                    enabled = true,
                    track = function() end,
					partial = false,
                }, 
                boss51 = {
                    name = "General Vezax 1",
                    bossIDs = {33271},
                    achievement = 12372,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:Shadowdodger() end,
					partial = false,
                }, 
                boss52 = {
                    name = "General Vezax 2",
                    bossIDs = {33271},
                    achievement = 12373,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for the Saronite Animus to spawn. Once the Saronite Animus has spawned, kill it then kill the boss. The Saronite Animus takes about 5 minutes to spawn.",
                    enabled = true,
                    track = function() core.Ulduar:ILoveTheSmellOfSaroniteInTheMorning() end,
					partial = false,
                }, 
                boss53 = {
                    name = "Yogg-Saron 1",
                    bossIDs = {33134},
                    achievement = 12384,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "After bring Sara down to 0% at the start of phase one, she will turn angry. Use /kiss on her to complete this achievement at this point.",
                    enabled = true,
                    track = function() core.Ulduar:KissAndMakeUp() end,
					partial = false,
                }, 
                boss54 = {
                    name = "Yogg-Saron 2",
                    bossIDs = {},
                    achievement = 12385,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down, provided you have not spoken to more than 3 keepers.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss55 = {
                    name = "Yogg-Saron 3",
                    bossIDs = {},
                    achievement = 12386,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down, provided you have not spoken to more than 2 keepers.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss56 = {
                    name = "Yogg-Saron 4",
                    bossIDs = {},
                    achievement = 12387,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down, provided you have not spoken to more than 1 keeper.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss57 = {
                    name = "Yogg-Saron 5",
                    bossIDs = {},
                    achievement = 12388,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down, provided you have not spoken to any of the keepers.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss58 = {
                    name = "Yogg-Saron 6",
                    bossIDs = {33134},
                    achievement = 12395,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:DriveMeCrazy() end,
					partial = false,
                }, 
                boss59 = {
                    name = "Yogg-Saron 7",
                    bossIDs = {33134},
                    achievement = 12396,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Ulduar:HesNotGettingAnyOlder() end,
					partial = false,
                }, 
                boss60 = {
                    name = "Yogg-Saron 8",
                    bossIDs = {33134},
                    achievement = 12397,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "After starting the encounter, run into the clouds around the room to spawn Guardians of Yogg-Saron. Once 9 Guardians of Yogg-Saron have spawned, AOE then down within 12 seconds of one another. You can then kill the boss.",
                    enabled = true,
                    track = function() core.Ulduar:TheyreComingOutOfTheWalls() end,
					partial = false,
                }, 
                boss61 = {
                    name = "Yogg-Saron 9",
                    bossIDs = {},
                    achievement = 12398,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement takes multiple runs to complete since it’s random which vision the boss will spawn. You can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                }, 
                boss62 = {
                    name = "Algalon the Observer",
                    bossIDs = {},
                    achievement = 12400,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },                    
            },

            Naxxramas10Man = {
                name = "Naxxramas 10 Man",
                boss1 = {
                    name = "Other 25",
                    bossIDs = {},
                    achievement = 578,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill the boss with less than 9 players in the group.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Maexxna",
                    bossIDs = {15956,15952},
                    achievement = 1858,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just nuke down the bosses in the Arachnid Quarter to gain this achievement.",
                    enabled = true,
                    track = function() core.Naxxramas:Arachnophobia() end,
					partial = false,
                },
                boss3 = {
                    name = "Patchwerk",
                    bossIDs = {16028},
                    achievement = 1856,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:Patchwerk() end,
					partial = false,
                },
                boss4 = {
                    name = "Heigan the Unclean",
                    bossIDs = {15936},
                    achievement = 1996,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:HeiganTheUnclean() end,
					partial = false,
                },
                boss5 = {
                    name = "Grand Widow Faerlina",
                    bossIDs = {15953},
                    achievement = 1997,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:GrandWidowFaerlina() end,
					partial = false,
                },
                boss6 = {
                    name = "Thaddius 1",
                    bossIDs = {15928,15930,15929},
                    achievement = 2178,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:Shocking() end,
					partial = false,
                },
                boss7 = {
                    name = "Thaddius 2",
                    bossIDs = {15928,15930,15929},
                    achievement = 2180,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Just nuke the boss down with fewer than 9 players in the group.",
                    enabled = true,
                    track = function() core.Naxxramas:Subtraction() end,
					partial = false,
                },
                boss8 = {
                    name = "Loatheb",
                    bossIDs = {16011},
                    achievement = 2182,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:Loatheb() end,
					partial = false,
                },
                boss9 = {
                    name = "Four Horsemen",
                    bossIDs = {16063,16064,16065,30549},
                    achievement = 2176,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill all 4 horsemen without 15 seconds of one another. After pulling the boss wait till they split before damaging them otherwise the encounter will reset if you one shot any of the horsemen.",
                    enabled = true,
                    track = function() core.Naxxramas:FourHorsemen() end,
					partial = false,
                },
                boss10 = {
                    name = "Sapphiron",
                    bossIDs = {},
                    achievement = 2146,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss11 = {
                    name = "Kel'Thuzad",
                    bossIDs = {23562,23563,23561,16427,16429,16428},
                    achievement = 2184,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Naxxramas:KelThuzad() end,
					partial = false,
                },                          
            },

            Naxxramas25Man = {
                name = "Naxxramas 25 Man",
                boss1 = {
                    name = "Other 26",
                    bossIDs = {},
                    achievement = 579,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill the boss with less than 21 players in the group.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Maexxna",
                    bossIDs = {15956,15952},
                    achievement = 1859,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just nuke down the bosses in the Arachnid Quarter to gain this achievement.",
                    enabled = true,
                    track = function() core.Naxxramas:Arachnophobia() end,
					partial = false,
                },
                boss3 = {
                    name = "Patchwerk",
                    bossIDs = {16028},
                    achievement = 1857,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:Patchwerk() end,
					partial = false,
                },
                boss4 = {
                    name = "Heigan the Unclean",
                    bossIDs = {15936},
                    achievement = 2139,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:HeiganTheUnclean() end,
					partial = false,
                },
                boss5 = {
                    name = "Grand Widow Faerlina",
                    bossIDs = {15953},
                    achievement = 2140,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, single target the boss down without touching any of the adds.",
                    enabled = true,
                    track = function() core.Naxxramas:GrandWidowFaerlina() end,
					partial = false,
                },
                boss6 = {
                    name = "Thaddius 1",
                    bossIDs = {15928,15930,15929},
                    achievement = 2179,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:Shocking() end,
					partial = false,
                },
                boss7 = {
                    name = "Thaddius 2",
                    bossIDs = {15928,15930,15929},
                    achievement = 2181,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Just nuke the boss down with fewer than 21 players in the group.",
                    enabled = true,
                    track = function() core.Naxxramas:Subtraction() end,
					partial = false,
                },
                boss8 = {
                    name = "Loatheb",
                    bossIDs = {16011},
                    achievement = 2183,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Naxxramas:Loatheb() end,
					partial = false,
                },
                boss9 = {
                    name = "Four Horsemen",
                    bossIDs = {16063,16064,16065,30549},
                    achievement = 2177,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Kill all 4 horsemen without 15 seconds of one another. After pulling the boss wait till they split before damaging them otherwise the encounter will reset if you one shot any of the horsemen.",
                    enabled = true,
                    track = function() core.Naxxramas:FourHorsemen() end,
					partial = false,
                },
                boss10 = {
                    name = "Sapphiron",
                    bossIDs = {},
                    achievement = 2147,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss11 = {
                    name = "Kel'Thuzad",
                    bossIDs = {23562,23563,23561,16427,16429,16428},
                    achievement = 2185,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Naxxramas:KelThuzad() end,
					partial = false,
                },                          
            },

            IcecrownCitadel10Man = {
                name = "Icecrown Citadel 10 Man",
                boss1 = {
                    name = "Lord Marrowgar",
                    bossIDs = {36612},
                    achievement = 4534,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:LordMarrowgar() end,
                    partial = false,
                },
                boss2 = {
                    name = "Lady Deathwhisper",
                    bossIDs = {36855},
                    achievement = 4535,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.IcecrownCitadel:LadyDeathwhisper() end,
                    partial = false,
                },     
                boss3 = {
                    name = "Gunship Battle",
                    bossIDs = {37215},
                    achievement = 4536,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just complete the encounter as normal by firing the cannons at the enemy ship.",
                    enabled = false,
                    track = nil,
                    partial = false,
                },     
                boss4 = {
                    name = "Deathbringer Saurfang",
                    bossIDs = {37813},
                    achievement = 4537,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:DeathbringerSaurfang() end,
                    partial = false,
                },     
                boss5 = {
                    name = "Festergut",
                    bossIDs = {36626},
                    achievement = 4577,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:Festergut() end,
                    partial = false,
                },     
                boss6 = {
                    name = "Rotface",
                    bossIDs = {36627},
                    achievement = 4538,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:Rotface() end,
                    partial = false,
                },     
                boss7 = {
                    name = "Professor Putricide",
                    bossIDs = {36678},
                    achievement = 4578,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:ProfessorPutricide() end,
                    partial = false,
                },     
                boss8 = {
                    name = "Valithria Dreamwalker",
                    bossIDs = {36789},
                    achievement = 4579,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement requires a healing class to complete. At 110, the healer can just heal the at the start of the fight. You do not need to wait for the portals to spawn if you can heal the boss to full in under 45 seconds.",
                    enabled = false,
                    track = nil,
					partial = false,
                },     
                boss9 = {
                    name = "Sindragosa",
                    bossIDs = {36853},
                    achievement = 4580,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:Sindragosa() end,
                    partial = false,
                },     
                boss10 = {
                    name = "Blood Prince Council",
                    bossIDs = {37970},
                    achievement = 4582,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
                    partial = false,
                },     
                boss11 = {
                    name = "Blood-Queen Lana'thel",
                    bossIDs = {37955},
                    achievement = 4539,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement will take 2 kills to complete. At 110 to complete the ‘Defeat Blood-Queen Lana'thel without becoming a vampire’ criteria just simply nuke the boss down. To complete the ‘Defeat Blood-Queen Lana'thel while a vampire’ criteria, wait until you get the Essence of the Blood Queen debuff then nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },     
                boss12 = {
                    name = "The Lich King 1",
                    bossIDs = {36597},
                    achievement = 4601,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.IcecrownCitadel:LichKing() end,
                    partial = false,
                },
                boss13 = {
                    name = "The Lich King 2",
                    bossIDs = {},
                    achievement = 4581,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },                                
            },

            IcecrownCitadel25Man = {
                name = "Icecrown Citadel 25 Man",
                boss1 = {
                    name = "Lord Marrowgar 25",
                    bossIDs = {36612},
                    achievement = 4610,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:LordMarrowgar() end,
                    partial = false,
                },
                boss2 = {
                    name = "Lady Deathwhisper 25",
                    bossIDs = {36855},
                    achievement = 4611,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.IcecrownCitadel:LadyDeathwhisper() end,
                    partial = false,
                },     
                boss3 = {
                    name = "Gunship Battle 25",
                    bossIDs = {37215},
                    achievement = 4612,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just complete the encounter as normal by firing the cannons at the enemy ship.",
                    enabled = false,
                    track = nil,
                    partial = false,
                },     
                boss4 = {
                    name = "Deathbringer Saurfang 25",
                    bossIDs = {37813},
                    achievement = 4613,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:DeathbringerSaurfang() end,
                    partial = false,
                },     
                boss5 = {
                    name = "Festergut 25",
                    bossIDs = {36626},
                    achievement = 4615,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:Festergut() end,
                    partial = false,
                },     
                boss6 = {
                    name = "Rotface 25",
                    bossIDs = {36627},
                    achievement = 4614,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:Rotface() end,
                    partial = false,
                },     
                boss7 = {
                    name = "Professor Putricide 25",
                    bossIDs = {36678},
                    achievement = 4616,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:ProfessorPutricide() end,
                    partial = false,
                },     
                boss8 = {
                    name = "Valithria Dreamwalker 25",
                    bossIDs = {36789},
                    achievement = 4619,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement requires a healing class to complete. At 110, the healer can just heal the at the start of the fight. You do not need to wait for the portals to spawn if you can heal the boss to full in under 45 seconds.",
                    enabled = false,
                    track = nil,
					partial = false,
                },     
                boss9 = {
                    name = "Sindragosa 25",
                    bossIDs = {36853},
                    achievement = 4620,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.IcecrownCitadel:Sindragosa() end,
                    partial = false,
                },     
                boss10 = {
                    name = "Blood Prince Council 25",
                    bossIDs = {37970},
                    achievement = 4617,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
                    partial = false,
                },     
                boss11 = {
                    name = "Blood-Queen Lana'thel 25",
                    bossIDs = {37955},
                    achievement = 4618,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement will take 2 kills to complete. At 110 to complete the ‘Defeat Blood-Queen Lana'thel without becoming a vampire’ criteria just simply nuke the boss down. To complete the ‘Defeat Blood-Queen Lana'thel while a vampire’ criteria, wait until you get the Essence of the Blood Queen debuff then nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },     
                boss12 = {
                    name = "The Lich King 1 25",
                    bossIDs = {36597},
                    achievement = 4621,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.IcecrownCitadel:LichKing() end,
                    partial = false,
                },
                boss13 = {
                    name = "The Lich King 2 25",
                    bossIDs = {},
                    achievement = 4622,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },                               
            },
        },

        Dungeons = {
            UtgardeKeep = {
                name = "Utgarde Keep",
                boss1 = {
                    name = "Prince Keleseth",
                    bossIDs = {23953},
                    achievement = 1919,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.UtgardeKeep:PrinceKeleseth() end,
					partial = false,
                },
            },

            TheNexus = {
                name = "The Nexus",
                boss1 = {
                    name = "Grand Magus Telestra",
                    bossIDs = {26731},
                    achievement = 2150,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.TheNexus:GrandMagusTelestra() end,
					partial = false,
                },
                boss2 = {
                    name = "Anomalus",
                    bossIDs = {26763},
                    achievement = 2037,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Damage the boss down to 45%, be careful you don’t 1 shot the boss. Wait for the add to finish casting the indestructible buff on the boss. Once this has finished you can kill the boss. Make sure you don’t kill the chaotic rift.",
                    enabled = true,
                    track = function() core.TheNexus:Anomalus() end,
					partial = false,
                },
                boss3 = {
                    name = "Keristrasza",
                    bossIDs = {26723},
                    achievement = 2036,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.TheNexus:Keristrasza() end,
					partial = false,
                },
            },

            TheCullingOfStratholme = {
                name = "The Culling of Stratholme",
                boss1 = {
                    name = "Other 27",
                    bossIDs = {27737},
                    achievement = 1872,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheCullingOfStratholme:ZombieFest() end,
					partial = false,
                },
                boss2 = {
                    name = "Other 28",
                    bossIDs = {},
                    achievement = 1817,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            AzjolNerub = {
                name = "Azjol Nerub",
                boss1 = {
                    name = "Krik'thir the Gatewatcher",
                    bossIDs = {},
                    achievement = 1296,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just single target the boss down without killing any of the mobs around him.",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
                boss2 = {
                    name = "Hadronox",
                    bossIDs = {},
                    achievement = 1297,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just go straight down to the boss ignoring all adds in the way. Nuke the boss down as soon as you reach him. Don’t wait for the boss to come to you.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Anub'arak",
                    bossIDs = {29120},
                    achievement = 1860,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.AzjolNerub:Anubarak() end,
					partial = false,
                },
            },

            AhnKahetTheOldKingdom = {
                name = "AhnKahet The Old Kingdom",
                boss1 = {
                    name = "Elder Nadox",
                    bossIDs = {29309},
                    achievement = 2038,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.AhnKahetTheOldKingdom:ElderNadox() end,
					partial = false,
                },
                boss2 = {
                    name = "Jedoga Shadowseeker",
                    bossIDs = {29310},
                    achievement = 2056,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.AhnKahetTheOldKingdom:JedogaShadowseeker() end,
					partial = false,
                },
                boss3 = {
                    name = "Herald Volazj",
                    bossIDs = {29311},
                    achievement = 1862,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.AhnKahetTheOldKingdom:HeraldVolazj() end,
					partial = false,
                },
            },

            DrakTharonKeep = {
                name = "Drak Tharon Keep",
                boss1 = {
                    name = "Trollgore",
                    bossIDs = {26630},
                    achievement = 2151,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.DrakTharonKeep:Trollgore() end,
					partial = false,
                },
                boss2 = {
                    name = "Novos the Summoner",
                    bossIDs = {},
                    achievement = 2057,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Stand at the top of the stairs and kill the undead adds and Crystal Handlers until all 4 Crystal Handlers have been killed. At this point phase 2 starts and you can kill the boss.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "King Dred",
                    bossIDs = {27483},
                    achievement = 2039,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss and pull 6 Drakkari Gutrippers and/or Drakkari Scytheclaw but don’t kill them. Once you in combat with the boss, single target down the raptors 1 by 1 until 6 are killed. Once this is done you can kill the boss.",
                    enabled = true,
                    track = function() core.DrakTharonKeep:KingDred() end,
					partial = false,
                },
            },

            VioletHold = {
                name = "Violet Hold",
                boss1 = {
                    name = "Cyanigosa",
                    bossIDs = {},
                    achievement = 1816,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "For the achievement you must not use any of the red crystal around the room and none of the mobs can reach the entrance.",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
                boss2 = {
                    name = "Other 29",
                    bossIDs = {},
                    achievement = 1865,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement will take multiple runs to complete since it’s random which bosses are going to spawn.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "Ichoron",
                    bossIDs = {},
                    achievement = 2041,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Zuramat the Obliterator",
                    bossIDs = {29314},
                    achievement = 2153,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.VioletHold:ZuramatTheObliterator() end,
					partial = false,
                },
            },

            Gundrak = {
                name = "Gundrak",
                boss1 = {
                    name = "Slad'ran",
                    bossIDs = {29304},
                    achievement = 2058,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Gundrak:Sladran() end,
					partial = false,
                },
                boss2 = {
                    name = "Moorabi",
                    bossIDs = {29305},
                    achievement = 2040,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.Gundrak:Moorabi() end,
					partial = false,
                },
                boss3 = {
                    name = "Gal'darah 1",
                    bossIDs = {},
                    achievement = 1864,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Gal'darah 2",
                    bossIDs = {29306},
                    achievement = 2152,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.Gundrak:Galdarah() end,
					partial = false,
                },
            },

            HallsOfStone = {
                name = "Halls of Stone",
                boss1 = {
                    name = "Maiden of Grief",
                    bossIDs = {27975},
                    achievement = 1866,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.HallsOfStone:MaidenOfGrief() end,
					partial = false,
                },
                boss2 = {
                    name = "Tribunal of Ages",
                    bossIDs = {27983},
                    achievement = 2154,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just complete the encounter without letting the adds reach Brann Bronzebeard.",
                    enabled = true,
                    track = function() core.HallsOfStone:TribunalOfAges() end,
					partial = false,
                },
                boss3 = {
                    name = "Sjonnir The Ironshaper",
                    bossIDs = {27978},
                    achievement = 2155,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "Pull the boss then wait for the Malformed Ooze to form into one Iron Sludge. Once the Iron Sludge is formed, kill it then kill the boss.",
                    enabled = true,
                    track = function() core.HallsOfStone:SjonnirTheIronshaper() end,
					partial = false,
                },
            },

            HallsOfLightning = {
                name = "Halls of Lightning",
                boss1 = {
                    name = "General Bjarngrim",
                    bossIDs = {28586},
                    achievement = 1834,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just wait for the boss to gain Temporary Electrical Charge buff before pulling him. Once he has the buff pull the boss, wait for him to get his defensive stance up then kill him.",
                    enabled = true,
                    track = function() core.HallsOfLightning:GeneralBjarngrim() end,
					partial = false,
                },
                boss2 = {
                    name = "Volkhan",
                    bossIDs = {28587},
                    achievement = 2042,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.HallsOfLightning:Volkhan() end,
					partial = false,
                },
                boss3 = {
                    name = "Loken",
                    bossIDs = {28923},
                    achievement = 1867,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.HallsOfLightning:Loken() end,
					partial = false,
                },
            },

            TheOculus = {
                name = "The Oculus",
                boss1 = {
                    name = "Ley-Guardian Eregos 1",
                    bossIDs = {},
                    achievement = 1871,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Ley-Guardian Eregos 2",
                    bossIDs = {},
                    achievement = 1868,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
                boss3 = {
                    name = "Ley-Guardian Eregos 3",
                    bossIDs = {},
                    achievement = 2044,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "Ley-Guardian Eregos 4",
                    bossIDs = {},
                    achievement = 2045,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss5 = {
                    name = "Ley-Guardian Eregos 5",
                    bossIDs = {},
                    achievement = 2046,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },

            UtgardePinnacle = {
                name = "Utgarde Pinnacle",
                boss1 = {
                    name = "Svala Sorrowgrave",
                    bossIDs = {},
                    achievement = 2043,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Skadi the Ruthless 1",
                    bossIDs = {26690, 26693},
                    achievement = 1873,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just complete the encounter as quickly as possible.",
                    enabled = true,
                    track = function() core.UtgardePinnacle:SkadiTheRuthless() end,
					partial = false,
                },
                boss3 = {
                    name = "Skadi the Ruthless 2",
                    bossIDs = {},
                    achievement = 2156,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss4 = {
                    name = "King Ymiron",
                    bossIDs = {26861},
                    achievement = 2157,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.UtgardePinnacle:KingYmiron() end,
					partial = false,
                },
            },

            TrialOfTheChampion = {
                name = "Trial of the Champion",
                boss1 = {
                    name = "Argent Confessor Paletress",
                    bossIDs = {},
                    achievement = 3802,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "This achievement will take multiple runs to complete. At 110, you can simply nuke down the boss to supress one of the memories.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss2 = {
                    name = "Eadric the Pure ",
                    bossIDs = {},
                    achievement = 3803,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = false,
                    track = nil,
					partial = false,
                },
                boss3 = {
                    name = "The Black Knight",
                    bossIDs = {35451},
                    achievement = 3804,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.TrialOfTheChampion:TheBlackKnight() end,
					partial = false,
                },
            },

            TheForgeOfSouls = {
                name = "The Forge of Souls",
                boss1 = {
                    name = "Bronjahm",
                    bossIDs = {36497},
                    achievement = 4522,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "",
                    enabled = true,
                    track = function() core.TheForgeOfSouls:Bronjahm() end,
					partial = false,
                },
                boss2 = {
                    name = "Devourer of Souls",
                    bossIDs = {36502},
                    achievement = 4523,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.TheForgeOfSouls:DevourerOfSouls() end,
					partial = false,
                },
            },

            PitOfSaron = {
                name = "Pit of Saron",
                boss1 = {
                    name = "Forgemaster Garfrost",
                    bossIDs = {36494},
                    achievement = 4524,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, you can simply just nuke the boss down.",
                    enabled = true,
                    track = function() core.PitOfSaron:ForgemasterGarfrost() end,
					partial = false,
                },
                boss2 = {
                    name = "Pit of Saron Tunnel",
                    bossIDs = {},
                    achievement = 4525,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "When you run through the tunnel after the 2nd boss, no player in the group can hit by any of the icicles on the floor. The ground is marked where these icicles will fall so just make sure no one is standing in those areas.",
                    enabled = true,
                    track = function() end,
					partial = false,
                },
            },

            HallsOfReflection = {
                name = "Halls of Reflection",
                boss1 = {
                    name = "Wrath of the Lich King",
                    bossIDs = {},
                    achievement = 4526,
                    players = {"(Enter instance to start scanning)"},
                    tactics = "At 110, just complete the gauntlet as quickly as possible.",
                    enabled = false,
                    track = nil,
					partial = false,
                },
            },
        },
    },
}