local f = CreateFrame("Frame")
local marked = {}
local slaves = {}
local master = ""
local player = UnitName("player")
local init = false
RegisterAddonMessagePrefix("EnRT_MS")
f:RegisterEvent("UNIT_AURA")
f:RegisterEvent("CHAT_MSG_ADDON")
f:RegisterEvent("ENCOUNTER_START")
f:RegisterEvent("PLAYER_LOGIN")
f:SetScript("OnEvent", function(self, event, ...)
	if event == "UNIT_AURA" and player == master and EnRT_MistressSasszineEnabled then
		local unit = ...
		local unitName = GetUnitName(unit, true)
		if UnitDebuff(unit, GetSpellInfo(230143)) then
			if not EnRT_Contains(marked, unitName) then
				marked[#marked+1] = unitName
				SetRaidTarget(unitName, EnRT_Contains(marked, unitName))
				if UnitIsConnected(unitName) then
					SendAddonMessage("EnRT_MS", EnRT_Contains(marked, unitName), "WHISPER", unitName)
				end
				if not init then
					init = true
					C_Timer.After(0.3, function(self) 
						EnRT_MS_AssignGroups()
					end)
					C_Timer.After(8, function(self) 
						init = false
						slaves = {}
						marked = {}
					end)
				end
			end
		else
			if EnRT_Contains(marked, unitName) then
				marked[EnRT_Contains(marked, unitName)] = nil
				SetRaidTarget(unitName, 0)
			end
		end
	elseif event == "PLAYER_LOGIN" then
		if EnRT_MistressSasszineEnabled == nil then EnRT_MistressSasszineEnabled = true end
	elseif event == "ENCOUNTER_START" then
		local eID = ...
		local difficulty = select(3, GetInstanceInfo())
		if eID == 2037 and difficulty == 16 then
			master = EnRT_GetRaidLeader()
		end
	elseif event == "CHAT_MSG_ADDON" then
		local prefix, msg, channel, sender = ...
		if prefix == "EnRT_MS" then
			local mark = ""
			if msg == "1" then
				mark = "STAR"
			elseif msg == "2" then
				mark = "CIRCLE"
			elseif msg == "3" then
				mark = "DIAMOND"
			elseif msg == "4" then
				mark = "TRIANGLE"
			end
			EnRT_PopupShow("\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_"..msg..":30\124t".." MOVE TO " .. mark.. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_"..msg..":30\124t", 8)
			PlaySoundFile("Interface\\AddOns\\EndlessRaidTools\\Sound\\"..mark..".ogg", "Master")
		end
	end
end)
--[[
	Checking if a table PGF_Contains a given value and if it does, what index is the value located at
	param(arr) table
	param(value) T - value to check exists
	return boolean or integer / returns false if the table does not contain the value otherwise it returns the index of where the value is locatedd
]]
function EnRT_Contains(arr, value)
	if value == nil then
		return false
	end
	if arr == nil then
		return false
	end
	for k, v in pairs(arr) do
		if v == value then
			return k
		end
	end
	return false
end
function EnRT_MS_AssignGroups()
	local counter = 1
	local printText = "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_1:14\124t"
	for i = 1, GetNumGroupMembers() do
		local raider = "raid"..i
		local raiderName = GetUnitName(raider, true)
		if not EnRT_Contains(marked, raiderName) and not EnRT_Contains(slaves, raiderName) and UnitIsVisible(raider) and not UnitDebuff(raiderName, GetSpellInfo(239362)) then
			if counter <= 3 and UnitIsConnected(raiderName) then --Assign Star
				slaves[#slaves+1] = raiderName
				SendAddonMessage("EnRT_MS", 1, "WHISPER", raiderName)
				printText = printText .. raiderName .. ","
				if counter == 3 then
					printText = printText .. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_1:14\124t"
					print(printText)
					printText = "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_2:14\124t"
				end
			elseif counter <= 6 and UnitIsConnected(raiderName) then --Assign circle
				slaves[#slaves+1] = raiderName
				SendAddonMessage("EnRT_MS", 2, "WHISPER", raiderName)
				printText = printText .. raiderName .. ","
				if counter == 6 then
					printText = printText .. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_2:14\124t"
					print(printText)
					printText = "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_3:14\124t"
				end
			elseif counter <= 8 and UnitIsConnected(raiderName) then -- Assign purple
				slaves[#slaves+1] = raiderName
				SendAddonMessage("EnRT_MS", 3, "WHISPER", raiderName)
				printText = printText .. raiderName .. ","
				if counter == 8 then
					printText = printText .. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_3:14\124t"
					print(printText)
					printText = "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_4:14\124t"
				end
			elseif counter <= 10 and UnitIsConnected(raiderName) then -- assign triangle
				slaves[#slaves+1] = raiderName
				SendAddonMessage("EnRT_MS", 4, "WHISPER", raiderName)
				printText = printText .. raiderName .. ","
				if counter == 10 then
					printText = printText .. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_4:14\124t"
					print(printText)
					printText = "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_1:14\124t Extra: "
				end
			elseif counter <= 11 and UnitIsConnected(raiderName) then
				slaves[#slaves+1] = raiderName
				SendAddonMessage("EnRT_MS", 1, "WHISPER", raiderName)
				printText = printText .. raiderName .. ","
				if counter == 11 then
					printText = printText .. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_1:14\124t"
					print(printText)
					printText = "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_2:14\124t Extra: "
				end
			elseif counter <= 12 and UnitIsConnected(raiderName) then --Assign circle
				slaves[#slaves+1] = raiderName
				SendAddonMessage("EnRT_MS", 2, "WHISPER", raiderName)
				printText = printText .. raiderName .. ","
				if counter == 12 then
					printText = printText .. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_2:14\124t"
					print(printText)
					printText = "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_3:14\124t Extra: "
				end
			elseif counter <= 13 and UnitIsConnected(raiderName) then -- Assign purple
				slaves[#slaves+1] = raiderName
				SendAddonMessage("EnRT_MS", 3, "WHISPER", raiderName)
				printText = printText .. raiderName .. ","
				if counter == 13 then
					printText = printText .. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_3:14\124t"
					print(printText)
					printText = "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_4:14\124t Extra: "
				end
			elseif UnitIsConnected(raiderName) then -- assign triangle
				slaves[#slaves+1] = raiderName
				SendAddonMessage("EnRT_MS", 4, "WHISPER", raiderName)
				printText = printText .. raiderName .. ","
				if counter == 15 or counter == 16 then
					printText = printText .. "\124TInterface\\TargetingFrame\\UI-RaidTargetingIcon_4:14\124t"
					print(printText)
				end
			end
			counter = counter + 1 
		end
	end
end