local f = CreateFrame("Frame")
local raiders = {}
local tanks = {}
local healers = {}
local dps = {}
local melee = {}
local ranged = {}
local mobilityDPS = {}
local player = UnitName("player")
local master = ""
local infusions = {
	light = 1, 
	fel = 1,
}
--GetInstanceInfo() to check for mythic
local init = false
RegisterAddonMessagePrefix("EnRT_MOV")
f:RegisterEvent("ENCOUNTER_START")
f:RegisterEvent("UNIT_AURA")
f:RegisterEvent("PLAYER_LOGIN")
f:RegisterEvent("CHAT_MSG_ADDON")
f:SetScript("OnEvent", function(self, event, ...)
	if event == "ENCOUNTER_START" and EnRT_MaidenOfVigilanceEnabled then
		local eID = ...
		local difficulty = select(3, GetInstanceInfo())
		if eID == 2052 and difficulty == 16 then
			master = EnRT_GetRaidLeader()
			EnRT_MOV_InitRaid()
		end
	elseif event == "PLAYER_LOGIN" then
		if EnRT_MaidenOfVigilanceEnabled == nil then EnRT_MaidenOfVigilanceEnabled = true end
	elseif event == "CHAT_MSG_ADDON" then
		local prefix, msg, channel, sender = ...
		if prefix == "EnRT_MOV" then
			EnRT_PopupShow(msg, 20)
		end
	elseif event == "UNIT_AURA" and player == master and EnRT_MaidenOfVigilanceEnabled then
		local raider = ...
		local raiderName = GetUnitName(raider, true)
		if UnitDebuff(raiderName, GetSpellInfo(235213)) and EnRT_MOV_GetInfusion(raiderName) ~= "Light" then -- Light Infusion
			raiders[raiderName].infusion = "light"
		end
		if UnitDebuff(raiderName, GetSpellInfo(235240)) and EnRT_MOV_GetInfusion(raiderName) ~= "Fel" then -- Fel Infusion
			raiders[raiderName].infusion = "fel"
		end
		if UnitDebuff(raiderName, GetSpellInfo(248812)) and not init then -- Stun Blowback
			init = true
			EnRT_MOV_AssignPositions()
			C_Timer.After(20, function()
				for k,v in pairs(infusions) do
					infusions[k] = 1
				end
				init = false
			end)
		end
	end
end)
function EnRT_MOV_InitRaid()
	healers = {}
	dps = {}
	tanks = {}
	raiders = {}
	for i = 1, 20 do
		local raider = "raid"..i
		local raiderName = GetUnitName(raider, true)
		local role = UnitGroupRolesAssigned(raider)
		local class = select(2, UnitClass(raider))
		--Tanks will be tanks, Healers will be healers and dps will be ordered from raid1 to raidn which creates prioritzation
		if role == "TANK" then
			tanks[#tanks+1] = raiderName
		elseif role == "HEALER" then
			healers[#healers+1] = raiderName
		else
			if raiderName ~= "Ant" then
				dps[#dps+1] = raiderName
			end
		end
		if UnitIsConnected(raider) and UnitIsVisible(raider) then
			raiders[raiderName] = {
				infusion = "",
				role = role,
				class = select(2, UnitClass(raider)),
				marker = 0,
				lane = "",
				assignment = "",
				side = ""
			}
		end
	end
end
function EnRT_MOV_AssignPositions()
	for k,v in pairs(infusions) do
		print("Doing " .. k .. " assignments:")
		--Assigning Tanks to inner lane on ranged
		for i,raiderName in pairs(tanks) do
			if raiders[raiderName].infusion == k then
				infusions[k] = infusions[k] + 1
				SendAddonMessage("EnRT_MOV", "RANGED INNER", "WHISPER", raiderName)
				print(raiderName .. ": Ranged inner")
			end
		end
		--Assigning Healers to middle and outer on ranged
		for i,raiderName in pairs(healers) do
			if raiders[raiderName].infusion == k then
				if infusions[k] == 2 then
					infusions[k] = infusions[k] + 1
					SendAddonMessage("EnRT_MOV", "RANGED MIDDLE", "WHISPER", raiderName)
					print(raiderName .. ": Ranged middle")
				elseif infusions[k] == 3 then
					infusions[k] = infusions[k] + 1
					SendAddonMessage("EnRT_MOV", "RANGED OUTER", "WHISPER", raiderName)
					print(raiderName .. ": Ranged outer")
				else
					SendAddonMessage("EnRT_MOV", "STANDBY", "WHISPER", raiderName)
					print(raiderName .. ": Standby")
				end
			end
		end
		--Assigning Dps to all melee positions and standbys
		for i,raiderName in pairs(dps) do
			if raiders[raiderName].infusion == k then
				if infusions[k] == 4 then
					infusions[k] = infusions[k] + 1
					SendAddonMessage("EnRT_MOV", "MELEE INNER", "WHISPER", raiderName)
					print(raiderName .. ": Melee inner")
				elseif infusions[k] == 5 then
					infusions[k] = infusions[k] + 1
					SendAddonMessage("EnRT_MOV", "MELEE MIDDLE", "WHISPER", raiderName)
					print(raiderName .. ": Melee middle")
				elseif infusions[k] == 6 then
					infusions[k] = infusions[k] + 1
					SendAddonMessage("EnRT_MOV", "MELEE OUTER", "WHISPER", raiderName)
					print(raiderName .. ": Melee outer")
				elseif infusions[k] == 7 then
					SendAddonMessage("EnRT_MOV", "STANDBY", "WHISPER", raiderName)
				end
			end
		end
	end
end
function EnRT_GetRaidLeader()
	for i = 1, GetNumGroupMembers() do
		local raider = "raid"..i
		if select(2, GetRaidRosterInfo(i)) == 2 then
			return GetUnitName(raider, true)
		end
	end
	return ""
end
function EnRT_MOV_GetInfusion(raiderName)
	if raiders[raiderName] then
		return raiders[raiderName].infusion
	end
end