local spellNames = {"Counterspell", "Counter Shot", "Mind Freeze", "Strangulate", "Solar Beam", "Rebuke", "Silance", "Kick", "Wind Shear", "Pummel", "Spear Hand Strike", "Arcane Torrent"}
local f = CreateFrame("Frame")
SLASH_ENDLESSINTERRUPT1 = "/endlessinterrupt"
f:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
RegisterAddonMessagePrefix("EndlessInterrupt")
f:RegisterEvent("CHAT_MSG_ADDON")
f:RegisterEvent("PLAYER_LOGIN")
local interruptNext = false
local function handler(msg, editbox)
	if EnRT_InterruptEnabled then
		if msg == "toggle" then
			EnRT_PopupMove()
		elseif not msg:match(";") then
			RunScript("EnRT_InterruptList = " .. msg)
		end
	end
end
SlashCmdList["ENDLESSINTERRUPT"] = handler
f:SetScript("OnEvent", function(self, event, ...)
	if EnRT_InterruptEnabled then
		if event == "UNIT_SPELLCAST_SUCCEEDED" and EnRT_InterruptList ~= nil then
			local unit, spell = ...
			if unit == "player" then
				if Endless_Contains(spellNames, spell) then
					if interruptNext then
						EnRT_PopupHide()
						interruptNext = false
					end
					local nextIndex = Endless_Contains(EnRT_InterruptList, Ambiguate(UnitName("player"),"short"))
					if nextIndex ~= false then
						if nextIndex == #EnRT_InterruptList then
							nextIndex = 1
						else
							nextIndex = nextIndex + 1
						end
						if UnitIsConnected(EnRT_InterruptList[nextIndex]) and IsInGroup() and (UnitInParty(EnRT_InterruptList[nextIndex]) or UnitInRaid(EnRT_InterruptList[nextIndex])) then
							SendAddonMessage("EndlessInterrupt", "", "WHISPER", EnRT_InterruptList[nextIndex])
						end
					end
				end
			end
		elseif event == "CHAT_MSG_ADDON" then
			local prefix, msg, channel, sender = ...
			if prefix == "EndlessInterrupt" then
				EnRT_PopupShow("NEXT INTERRUPT IS YOURS!", 7)
				interruptNext = true
			end
		end
	end
	if event == "PLAYER_LOGIN" then
		if EnRT_InterruptEnabled == nil then EnRT_InterruptEnabled = true end
		if EnRT_InterruptArcaneTorrent == nil then EnRT_InterruptArcaneTorrent = false end
		EnRT_UpdateInterrupts()
	end
end)
--[[
	Checking if a table contains a given value and if it does, what index is the value located at
	param(arr) table
	param(value) T - value to check exists
	return boolean or integer / returns false if the table does not contain the value otherwise it returns the index of where the value is locatedd
]]
function Endless_Contains(arr, value)
	if value == nil then
		return false
	end
	if arr == nil then
		return false
	end
	for k, v in pairs(arr) do
		if v == value then
			return k
		end
	end
	return false
end

function EnRT_UpdateInterrupts()
	if EnRT_InterruptArcaneTorrent then
		spellNames = {"Counterspell", "Counter Shot", "Mind Freeze", "Strangulate", "Solar Beam", "Rebuke", "Silance", "Kick", "Wind Shear", "Pummel", "Spear Hand Strike", "Arcane Torrent"}
	else
		spellNames = {"Counterspell", "Counter Shot", "Mind Freeze", "Strangulate", "Solar Beam", "Rebuke", "Silance", "Kick", "Wind Shear", "Pummel", "Spear Hand Strike"}
	end
end