local f = CreateFrame("Frame")
local slaves = {}
local player = UnitName("player")
local ticks = 0
local debuffed = false
local timer = ""
local queue = {}
local nearby = {}
local safe = true
local master = ""
f:RegisterEvent("ENCOUNTER_START")
f:RegisterEvent("CHAT_MSG_ADDON")
f:RegisterEvent("UNIT_AURA")
f:RegisterEvent("RAID_TARGET_UPDATE")
f:RegisterEvent("PLAYER_LOGIN")
RegisterAddonMessagePrefix("EnRT_ITSHealer")
RegisterAddonMessagePrefix("EnRT_ITSMarks") --Nearby
RegisterAddonMessagePrefix("EnRT_ITSMove")
--RegisterAddonMessagePrefix("EnRT_ITSComplete")
f:SetScript("OnUpdate",function(self, elapsed)
	if debuffed and EnRT_ImonarSoulhunterEnabled then
		ticks = ticks + elapsed
		if ticks > 0.05 then
			safe = true
			for i = 1, GetNumGroupMembers() do
				local raider = "raid"..i
				local name = GetUnitName(raider, true)
				if UnitIsVisible(raider) and GetRaidTargetIndex(raider) and UnitIsDead(raider) and EnRT_Contains(nearby, name) then
					SendAddonMessage("EnRT_ITSMarks", "AWAY"..name, "WHISPER", master)
					nearby[EnRT_Contains(nearby, name)] = nil
				end
				if UnitIsVisible(raider) and GetUnitName(raider, true) ~= player and not UnitIsDead(raider) then
					if CheckInteractDistance(raider, 3) and UnitIsConnected(master) and not EnRT_Contains(nearby, name) then --Duel range 10y
						safe = false
						nearby[#nearby+1] = name
						SendAddonMessage("EnRT_ITSMarks", "NEARBY|"..name, "WHISPER", master)
						SendAddonMessage("EnRT_ITSMove", "NEARBY", "WHISPER", name)
					elseif CheckInteractDistance(raider, 3) and UnitIsConnected(master) then
						safe = false
					elseif not CheckInteractDistance(raider, 3) and UnitIsConnected(master) and EnRT_Contains(nearby, name) then
						nearby[EnRT_Contains(nearby, name)] = nil
						SendAddonMessage("EnRT_ITSMarks", "AWAY|"..name, "WHISPER", master)
						SendAddonMessage("EnRT_ITSMove", "AWAY", "WHISPER", name)
					end
				end
			end
			if safe and UnitIsConnected(master) and UnitDebuff(player, GetSpellInfo(247552)) then--247552 alternative check if nearby is empty?
				SendAddonMessage("EnRT_ITSHealer", "SHOW", "RAID")
			elseif not safe and UnitIsConnected(master) and UnitDebuff(player, GetSpellInfo(247552))then
				SendAddonMessage("EnRT_ITSHealer", "HIDE", "RAID")
			end
			ticks = 0
		end
	end
end)
f:SetScript("OnEvent", function(self, event, ...)
	if event == "ENCOUNTER_START" and EnRT_ImonarSoulhunterEnabled then
		queue = {}
		nearby = {}
		local eID = ...
		if eID == 2082 then--2082
			master = EnRT_GetRaidLeader()
		end
	elseif event == "PLAYER_LOGIN" then
		if EnRT_ImonarSoulhunterEnabled == nil then EnRT_ImonarSoulhunterEnabled = true end
	elseif event == "RAID_TARGET_UPDATE" and EnRT_ImonarSoulhunterEnabled then
		for k, v in pairs(queue) do
			if GetRaidTargetIndex(k) and v == "mark" then
				queue[k] = nil
			elseif not GetRaidTargetIndex(k) and v == "unmark" then
				queue[k] = nil
			end
		end
	elseif event == "CHAT_MSG_ADDON" and EnRT_ImonarSoulhunterEnabled then
		local prefix, msg, channel, sender = ...
		if prefix == "EnRT_ITSHealer" then
			sender = Ambiguate(sender, "short")
			if UnitGroupRolesAssigned("player") == "HEALER" then
				if msg == "SHOW" then
					if not EnRT_PopupIsShown() or not EnRT_PopupGetText():match("DISPEL") then
						timer = EnRT_PopupShow("DISPEL " .. sender, 500)
					elseif EnRT_PopupIsShown() and EnRT_PopupGetText():match("DISPEL") and not EnRT_PopupGetText():match(sender) then
						local getText = EnRT_PopupGetText()
						timer:Cancel()
						timer = EnRT_PopupShow(getText .. " AND " .. sender, 500)
					end
				elseif msg == "HIDE" and EnRT_PopupGetText():match(sender) then
					if EnRT_PopupIsShown() and EnRT_PopupGetText():match("DISPEL") then
						EnRT_PopupHide()
						if timer ~= "" then
							timer:Cancel()
							timer = ""
						end
					end
				end
			end
		elseif prefix == "EnRT_ITSMove" then
			sender = Ambiguate(sender, "short")
			if msg == "NEARBY" then
				if timer ~= "" then
					timer:Cancel()
				end
				if EnRT_PopupIsShown() and EnRT_PopupGetText():match("DISPEL") then
					EnRT_PopupHide()
				end
				if not EnRT_PopupIsShown() then 
					timer = EnRT_PopupShow("GET AWAY FROM: " .. sender, 500)
				else
					local getText = EnRT_PopupGetText()
					timer:Cancel()
					timer = EnRT_PopupShow(getText .. " and " .. sender, 500)
				end
			elseif msg == "AWAY" and EnRT_PopupGetText() and EnRT_PopupGetText():match(sender) then
				EnRT_PopupHide()
				if timer ~= "" then
					timer:Cancel()
					timer = ""
				end
			elseif msg == "AWAY" and channel == "RAID" and sender ~= player and debuffed then
				nearby = {}
			end
		elseif prefix == "EnRT_ITSMarks" and player == master then
			local loc, name = msg:match("(.*)|(.*)") -- capture everything until | and then capture everything after |
			if loc == "NEARBY" and not EnRT_Contains(nearby, name) then
				nearby[EnRT_GetAvailableQueueSpot(nearby)] = name
				--nearby[#nearby+1] = name
			elseif loc == "AWAY" and EnRT_Contains(nearby, name) then
				nearby[EnRT_Contains(nearby, name)] = nil
			end
			local isNearby = EnRT_Contains(nearby, name)
			if isNearby then
				if GetRaidTargetIndex(name) == nil and not EnRT_ContainsKey(queue, name) then
					queue[name] = "mark"
					if EnRT_Contains(nearby, name) < 8 then --check if there are available marks
						SetRaidTarget(name, EnRT_Contains(nearby, name)+#slaves)
					end
				end
			else
				if GetRaidTargetIndex(name) and not EnRT_ContainsKey(queue, name) then
					queue[name] = "unmark"
					SetRaidTarget(name, 0)
				end
			end
			if loc == "AWAY" then -- everytime someone leaves see if anyone needs to be moved
				local movingPlayer = EnRT_GetPlayerAfterCap(nearby, 9-#slaves)
				local availableMark = EnRT_GetAvailableMarkWithCap(nearby, 9-#slaves)
				local oldIndex = EnRT_Contains(nearby, movingPlayer)
				if availableMark and movingPlayer then
					nearby[availableMark] = movingPlayer
					nearby[oldIndex] = nil
					queue[movingPlayer] = "mark"
					SetRaidTarget(movingPlayer, availableMark+#slaves)
				end
			end
		end
	elseif event == "UNIT_AURA" and EnRT_ImonarSoulhunterEnabled then
		if player == master then
			local unit = ...
			local unitName = GetUnitName(unit, true)
			if UnitDebuff(unit, GetSpellInfo(247552)) then --Sleep canister
				if not EnRT_Contains(slaves, unitName) then
					slaves[#slaves+1] = unitName
					SetRaidTarget(unitName, #slaves)
				end
			else
				if EnRT_Contains(slaves, unitName) then
					slaves[EnRT_Contains(slaves, unitName)] = nil
					SetRaidTarget(unitName, 0)
					nearby = {}
					for i = 1, GetNumGroupMembers() do
						local raider = "raid"..i
						if GetRaidTargetIndex(raider) then
							SetRaidTarget(raider, 0)
						end
					end
					for k, v in pairs(slaves) do
						local tName = v
						slaves[k] = nil
						local spot = EnRT_GetAvailableQueueSpot(slaves)
						slaves[spot] = tName
						SetRaidTarget(tName, spot)
					end
					queue = {}
				end
			end
		end
		if UnitDebuff(player, GetSpellInfo(247552)) then
			debuffed = true
		else
			if debuffed then
				debuffed = false
				nearby = {}
				SendAddonMessage("EnRT_ITSHealer", "HIDE", "RAID")
				SendAddonMessage("EnRT_ITSMove", "AWAY", "RAID")
				--SendAddonMessage("EnRT_ITSComplete", "", "WHISPER", master)
			end
		end
	end
end)
--[[
	Checking if a table PGF_Contains a given value and if it does, what index is the value located at
	param(arr) table
	param(value) T - value to check exists
	return boolean or integer / returns false if the table does not contain the value otherwise it returns the index of where the value is locatedd
]]
function EnRT_Contains(arr, value)
	if value == nil then
		return false
	end
	if arr == nil then
		return false
	end
	for k, v in pairs(arr) do
		if v == value then
			return k
		end
	end
	return false
end
--[[
	Checking if a table contains a given value and if it does, what index is the value located at
	param(arr) table
	param(value) T - value to check exists
	return boolean or integer / returns false if<< the table does not contain the value otherwise it returns the index of where the value is locatedd
]]
function EnRT_ContainsKey(arr, value)
	if value == nil then
		return false
	end
	if arr == nil then
		return false
	end
	for k, v in pairs(arr) do
		if k == value then
			return true
		end
	end
	return false
end

function EnRT_GetRaidLeader()
	for i = 1, GetNumGroupMembers() do
		local raider = "raid"..i
		if select(2, GetRaidRosterInfo(i)) == 2 then
			return GetUnitName(raider, true)
		end
	end
	return ""
end

function EnRT_GetAvailableMarkWithCap(arr,cap)
	for i = 1, cap+1 do
		if i > cap then
			return false
		elseif arr[i] == nil then
			return i
		end
	end
end

function EnRT_GetAvailableQueueSpot(arr)
	for i = 1, #arr+1 do
		if arr[i] == nil then
			return i
		end
	end
end

function EnRT_GetPlayerAfterCap(arr, cap)
	for i = cap+1, 100 do
		if arr[i] then
			return arr[i]
		end
	end
	return false
end

function EnRT_UsedArrayIndexes(arr)
	local count = 0
	for i = 1, 100 do
		if arr[i] then
			count = count + 1
		end
	end
	return count
end