local f = CreateFrame("Frame")
local healers = {}
local dispeller = ""
local bestTime = 0
local slaves = {}
local player = UnitName("player")
local ticks = 0
local debuffed = false
local queue = {}
local master = ""
f:RegisterEvent("ENCOUNTER_START")
f:RegisterEvent("CHAT_MSG_ADDON")
f:RegisterEvent("UNIT_AURA")
f:RegisterEvent("RAID_TARGET_UPDATE")
f:RegisterEvent("PLAYER_LOGIN")
RegisterAddonMessagePrefix("EnRT_DI")
f:SetScript("OnUpdate",function(self, elapsed)
	if debuffed and EnRT_DemonicInquisitionEnabled then
		ticks = ticks + elapsed
		if ticks > 0.05 then
			local safe = false
			for i = 1, GetNumGroupMembers() do
				local raider = "raid"..i
				if UnitIsVisible(raider) and GetUnitName(raider, true) ~= player then
					if IsItemInRange(63427, raider) and UnitIsConnected(master) then
						safe = false
						break
					end
					if UnitIsConnected(master) then
						safe = true
					end
				end
			end
			if safe and UnitIsConnected(master) and UnitDebuff(player, GetSpellInfo(233983)) and not GetRaidTargetIndex(player) then
				SendAddonMessage("EnRT_DI", "true", "WHISPER", master)
			elseif not safe and UnitIsConnected(master) and UnitDebuff(player, GetSpellInfo(233983)) and GetRaidTargetIndex(player) then
				SendAddonMessage("EnRT_DI", "false", "WHISPER", master)
			end
			ticks = 0
		end
	end
end)
f:SetScript("OnEvent", function(self, event, ...)
	if event == "ENCOUNTER_START" and EnRT_DemonicInquisitionEnabled then
		queue = {}
		local eID = ...
		if eID == 2048 then
			master = EnRT_GetRaidLeader()
		end
	elseif event == "PLAYER_LOGIN" then
		if EnRT_DemonicInquisitionEnabled == nil then EnRT_DemonicInquisitionEnabled = true end
	elseif event == "RAID_TARGET_UPDATE" and EnRT_DemonicInquisitionEnabled then
		for k, v in pairs(queue) do
			if GetRaidTargetIndex(k) and v == "mark" then
				queue[k] = nil
			elseif not GetRaidTargetIndex(k) and v == "unmark" then
				queue[k] = nil
			end
		end
	elseif event == "CHAT_MSG_ADDON" and EnRT_DemonicInquisitionEnabled then
		local prefix, msg, channel, sender = ...
		if prefix == "EnRT_DI" and player == master then
			sender = Ambiguate(sender, "short")
			if msg == "true" then
				if GetRaidTargetIndex(sender) == nil and EnRT_Contains(slaves, sender) and not EnRT_ContainsKey(queue, sender) then
					queue[sender] = "mark"
					SetRaidTarget(sender, EnRT_Contains(slaves, sender))
				end
			else
				if GetRaidTargetIndex(sender) and EnRT_Contains(slaves, sender) and not EnRT_ContainsKey(queue, sender) then
					queue[sender] = "unmark"
					SetRaidTarget(sender, 0)
				end
			end
		end
	elseif event == "UNIT_AURA" and EnRT_DemonicInquisitionEnabled then
		if player == master then
			local unit = ...
			local unitName = GetUnitName(unit, true)
			if UnitDebuff(unit, GetSpellInfo(233983)) then --Ecohing Anguish
				if not EnRT_Contains(slaves, unitName) then
					slaves[#slaves+1] = unitName
				end
			else
				if EnRT_Contains(slaves, unitName) then
					slaves[EnRT_Contains(slaves, unitName)] = nil
					SetRaidTarget(unitName, 0)
				end
			end
		end
		if UnitDebuff(player, GetSpellInfo(233983)) then
			debuffed = true
		else
			debuffed = false
		end
	end
end)
--[[
	Checking if a table PGF_Contains a given value and if it does, what index is the value located at
	param(arr) table
	param(value) T - value to check exists
	return boolean or integer / returns false if the table does not contain the value otherwise it returns the index of where the value is locatedd
]]
function EnRT_Contains(arr, value)
	if value == nil then
		return false
	end
	if arr == nil then
		return false
	end
	for k, v in pairs(arr) do
		if v == value then
			return k
		end
	end
	return false
end
--[[
	Checking if a table contains a given value and if it does, what index is the value located at
	param(arr) table
	param(value) T - value to check exists
	return boolean or integer / returns false if<< the table does not contain the value otherwise it returns the index of where the value is locatedd
]]
function EnRT_ContainsKey(arr, value)
	if value == nil then
		return false
	end
	if arr == nil then
		return false
	end
	for k, v in pairs(arr) do
		if k == value then
			return true
		end
	end
	return false
end
function EnRT_GetRaidLeader()
	for i = 1, GetNumGroupMembers() do
		local raider = "raid"..i
		if select(2, GetRaidRosterInfo(i)) == 2 then
			return GetUnitName(raider, true)
		end
	end
	return ""
end
