local f = CreateFrame("Frame")
local addon = ...
SLASH_ENDLESSRAIDTOOLS1 = "/endlessraidtools"
SLASH_ENDLESSRAIDTOOLS2 = "/enrt"
local playersChecked = {}
local initCheck = false
local function handler(msg, editbox)
	local arg = string.lower(msg)
	if arg ~= nil and arg == "vc" then
		SendAddonMessage("EnRT_VC", "vc", "RAID")
	elseif arg ~= nil and arg == "mistress" then
		EnRT_PopupMove()
	elseif arg ~= nil and arg == "maiden" then
		EnRT_PopupMove()
	else
		InterfaceOptionsFrame_OpenToCategory(EnRT_GeneralModules)
		if not EnRT_GeneralModules:IsVisible() then
			InterfaceOptionsFrame_OpenToCategory(EnRT_GeneralModules)
		end
	end
end
SlashCmdList["ENDLESSRAIDTOOLS"] = handler
f:RegisterEvent("CHAT_MSG_ADDON")
f:RegisterEvent("ADDON_LOADED")
RegisterAddonMessagePrefix("EnRT_VC")
f:SetScript("OnEvent", function(self, event, ...)
	if event == "CHAT_MSG_ADDON" then
		local prefix, msg, channel, sender = ...
		if prefix == "EnRT_VC" then
			if msg == "vc" then
				SendAddonMessage("EnRT_VC", GetAddOnMetadata(addon, "Version"), "WHISPER", sender)
			else
				if not initCheck then
					initCheck = true
					C_Timer.After(2, function() 
						EnRT_FindMissingPlayers()
						playersChecked = {}
						initCheck = false
					end)
				end
				sender = Ambiguate(sender, "short")
				playersChecked[#playersChecked+1] = sender
				print(sender .. "-" .. msg)
			end
		end
	elseif event == "ADDON_LOADED" and addon == ... then
		if EnRT_PopupTextPosition ~= nil then
			EnRT_PopupSetPosition(EnRT_PopupTextPosition.point, EnRT_PopupTextPosition.relativeTo, EnRT_PopupTextPosition.relativePoint, EnRT_PopupTextPosition.xOffset, EnRT_PopupTextPosition.yOffset)
		elseif EnRT_PopupTextFontSize == nil then
			EnRT_PopupTextFontSize = 28
		end
		EnRT_PopupUpdateFontSize()
	end
end)
function EnRT_FindMissingPlayers()
	for i = 1, GetNumGroupMembers() do
		if not Endless_Contains(playersChecked, UnitName("raid"..i)) and UnitName("raid"..i) ~= UnitName("player") then
			print(GetUnitName("raid"..i, true) .. "-not installed")
		end
	end
end
--[[
	Checking if a table contains a given value and if it does, what index is the value located at
	param(arr) table
	param(value) T - value to check exists
	return boolean or integer / returns false if the table does not contain the value otherwise it returns the index of where the value is locatedd
]]
function Endless_Contains(arr, value)
	if value == nil then
		return false
	end
	if arr == nil then
		return false
	end
	for k, v in pairs(arr) do
		if v == value then
			return k
		end
	end
	return false
end