IKickedData = {
	KickMessage = "player interrupted caster's spell";
	ChatType = "SAY";
	Enabled = false;
}

SLASH_RELOADUI1 = "/rl";
SlashCmdList.RELOADUI = ReloadUI;

SLASH_FRAMESTK1 = "/fs";
SlashCmdList.FRAMESTK = function()
	LoadAddOn('Blizzard_DebugTools');
	FrameStackTooltip_Toggle();
end

SLASH_IKICKED1 = "/ikicked";
SLASH_IKICKED2 = "/ik";
SlashCmdList["IKICKED"] = function(args, editbox)
	local tbl = {};
	for v in string.gmatch(args, "[^ ]+") do
		tinsert(tbl, v);
	end
	if(tbl[1] ~= "") then
		if(tbl[1] == nil or string.lower(tbl[1]) == "help") then
			print("Current available commands:");
			print("|cff00cc66/ik set 'message'|r - Set the interrupt message, this will replace the words 'player', 'caster' and 'spell'. Make sure the keywords are completely lowercase.");
			print("|cff00cc66/ik get|r - Displays the current interrupt message and output channel.");
			print("|cff00cc66/ik channel 'channel'|r - Sets the output channel of the addon. Example: '/ik output raidwarning'.");
			print("|cff00cc66/ik toggle|r - Toggles the verbal interrupts.\n");
			elseif(string.lower(tbl[1]) == "toggle") then
			if(IKickedData.Enabled) then
				IKickedData.Enabled = false;
				print("IKicked has been |cffcc0000disabled|r.");
			else
				IKickedData.Enabled = true;
				print("IKicked has been |cff00cc00enabled|r.");
			end
		elseif(string.lower(tbl[1]) == "set" and table.getn(tbl) > 1) then
			local msg = "";
			for i = 2, table.getn(tbl), 1 do
				msg = (msg .. tbl[i] .. " ");
			end
			IKickedData.KickMessage = msg;
			msg = string.gsub(msg, "player", "|cff00cc66Player|r");
			msg = string.gsub(msg, "caster", "|cFF00cc66caster|r");
			msg = string.gsub(msg, "spell", "|cFF00cc66spell|r");
			print("Successfully saved message: " .. msg);
		elseif(string.lower(tbl[1]) == "get") then
			local msg = IKickedData.KickMessage;
			msg = string.gsub(msg, "player", "|cff00cc66Player|r");
			msg = string.gsub(msg, "caster", "|cFF00cc66caster|r");
			msg = string.gsub(msg, "spell", "|cFF00cc66spell|r");
			print("The current interrupt message is " .. msg);
			print("The current output channel is |cFF00cc66" .. IKickedData.ChatType .. "|r.\n");
		elseif(string.lower(tbl[1]) == "channel") then
			if (string.lower(tbl[2]) == "say") then
				IKickedData.ChatType = "SAY";
			elseif(string.lower(tbl[2]) == "rw" or tbl[2] == "raidwarning") then
				IKickedData.ChatType = "RAID_WARNING";
			elseif(string.lower(tbl[2]) == "raid") then
				IKickedData.ChatType = "RAID";
			elseif(string.lower(tbl[2]) == "yell") then
				IKickedData.ChatType = "YELL";
			elseif(string.lower(tbl[2]) == "party") then
				IKickedData.ChatType = "PARTY";
			elseif(string.lower(tbl[2]) == "instance") then
				IKickedData.ChatType = "INSTANCE_CHAT";
			elseif(string.lower(tbl[2]) == nil) then
				--print("The current output channel is |cFF00cc66" .. IKickedData.ChatType .. "|r.\n");
			else
				IKickedData.ChatType = "SAY";
				print("Invalid channel type, defaulting...");
			end
			print("Output channel set to |cFF00cc66" .. IKickedData.ChatType .. "|r.");
		else
			print("Please use |cff00cc66/ik help|r for information on how to use the commands.");
		end
	end
end

local IKicked = CreateFrame("Frame");

local function EventHappened(self, event, ...)
	local dispatch = self[event]

	if dispatch then
		dispatch(self, ...)
	end
end

IKicked:SetScript("OnEvent", EventHappened)
IKicked:RegisterEvent("ADDON_LOADED")
IKicked:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")

function IKicked:ADDON_LOADED(...)
	if not IKickedData.KickMessage then
		IKickedData.KickMessage = "[player] interrupted [caster]'s [spell]";
	end
	if not IKickedData.Enabled then
		IKickedData.Enabled = true;
	end
	if not IKickedData.ChatType then
		IKickedData.ChatType = "SAY";
	end
	self:UnregisterEvent("ADDON_LOADED")
end

function IKicked:COMBAT_LOG_EVENT_UNFILTERED(...)
	local eventHappened = select(2, ...);		--which event happened
	local eventSource = select(5, ...);			--which was the source of the event happening
	local eventDest = select(9, ...);			--which was the destination of the event
	local spellID = select(15, ...);			--spell id	
	local spellLink = GetSpellLink(spellID);
	if(IKickedData.Enabled) then
		if(eventHappened == "SPELL_INTERRUPT") then
			if(eventSource == UnitName("PLAYER")) then
				local tempOutput = IKickedData.KickMessage;
				tempOutput = string.gsub(tempOutput, "player", eventSource);
				tempOutput = string.gsub(tempOutput, "caster", eventDest);
				tempOutput = string.gsub(tempOutput, "spell", spellLink);
				SendChatMessage(tempOutput, IKickedData.ChatType, nil, nil);
			end
		end
	end
end