HCQ_UI = {};
-- Генерация основного окна
HCQ_UI_Main = CreateFrame("Frame", "HCQ_UI_Main_Frame", UIParent, "BasicFrameTemplate")
HCQ_UI_Main.views = true;
HCQ_UI_Main:SetSize(300, 230)
HCQ_UI_Main:SetPoint("CENTER", UIParent, "CENTER")
HCQ_UI_Main:SetMovable(true)
HCQ_UI_Main:EnableMouse(true)
HCQ_UI_Main:SetUserPlaced(true)
HCQ_UI_Main:SetScript("OnMouseDown", HCQ_UI_Main.StartMoving)
HCQ_UI_Main:SetScript("OnMouseUp", HCQ_UI_Main.StopMovingOrSizing)
HCQ_UI_Main:Hide();
HCQ_UI_Main.HCQ_Title = HCQ_UI_Main:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
HCQ_UI_Main.HCQ_Title:SetPoint("TOP", HCQ_UI_Main, "TOP", 0, -4)
HCQ_UI_Main.HCQ_Title:SetText("Homma Ckeck Quest")
HCQ_UI_Main.HCQ_Title:SetFont("Fonts\\MORPHEUS_CYR.TTF", 12, "OUTLINE")

HCQ_UI_Main.HCQ_inputBox_Title = HCQ_UI_Main:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
HCQ_UI_Main.HCQ_inputBox_Title:SetPoint("TOP", HCQ_UI_Main, "TOP", 0, -35)
HCQ_UI_Main.HCQ_inputBox_Title:SetFont("Fonts\\MORPHEUS_CYR.TTF", 12, "OUTLINE")

HCQ_UI_Main.inputBox = CreateFrame("EditBox", nil, HCQ_UI_Main, "InputBoxTemplate")
HCQ_UI_Main.inputBox:SetSize(200, 30)
HCQ_UI_Main.inputBox:SetPoint("TOP", HCQ_UI_Main, "TOP", 0, -50)
HCQ_UI_Main.inputBox:SetAutoFocus(false)
HCQ_UI_Main.inputBox:SetScript("OnEnterPressed", function(self) self:ClearFocus() end)
local function CheckQuestStatus(questInput)
    local questID = tonumber(questInput)
    if questID then
        if C_QuestLog.IsQuestFlaggedCompleted(questID) then
            HCQ_UI_Main.resultText:SetText(HCQ_Settings.Localization.searchSuccess)
            HCQ_UI_Main.resultText:SetTextColor(0, 1, 0)
        else
            HCQ_UI_Main.resultText:SetText(HCQ_Settings.Localization.searchError)
            HCQ_UI_Main.resultText:SetTextColor(1, 0, 0)
        end
    end
end
HCQ_UI_Main.searchButton = CreateFrame("Button", nil, HCQ_UI_Main, "GameMenuButtonTemplate")
HCQ_UI_Main.searchButton:SetPoint("TOP", HCQ_UI_Main.inputBox, "BOTTOM", 0, -10)
HCQ_UI_Main.searchButton:SetSize(100, 30)
HCQ_UI_Main.searchButton:SetNormalFontObject("GameFontNormalLarge")
HCQ_UI_Main.searchButton:SetHighlightFontObject("GameFontHighlightLarge")
HCQ_UI_Main.searchButton:SetScript("OnClick", function()
    local questInput = HCQ_UI_Main.inputBox:GetText()
    if questInput and questInput ~= "" then
        CheckQuestStatus(questInput)
    end
end)

HCQ_UI_Main.resultText = HCQ_UI_Main:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
HCQ_UI_Main.resultText:SetPoint("TOP", HCQ_UI_Main.searchButton, "BOTTOM", 0, -20)
HCQ_UI_Main.resultText:SetText("")
HCQ_UI_Main.resultText:SetFont("Fonts\\MORPHEUS_CYR.TTF", 18, "OUTLINE")





local function InitializeDropdown(self, level)
    local info = UIDropDownMenu_CreateInfo()
    info.text = "Русский"
    info.value = "ru"
    info.func = function()
        HommaCkeckQuest_DB.Localization = "ru"
        loadLocalization()
    end
    UIDropDownMenu_AddButton(info, level)

    info.text = "English"
    info.value = "en"
    info.func = function()
        HommaCkeckQuest_DB.Localization = "en"
        loadLocalization()
    end
    UIDropDownMenu_AddButton(info, level)
end


HCQ_UI_Main.dropdown = CreateFrame("Frame", "HCQ_LocalizationDropdown", HCQ_UI_Main, "UIDropDownMenuTemplate")
HCQ_UI_Main.dropdown:SetPoint("BOTTOMLEFT", HCQ_UI_Main, "BOTTOMLEFT", 0, 5)
UIDropDownMenu_SetWidth(HCQ_UI_Main.dropdown, 80)
UIDropDownMenu_SetText(HCQ_UI_Main.dropdown, "Выберите язык")
UIDropDownMenu_Initialize(HCQ_UI_Main.dropdown, InitializeDropdown)






-- Кнопки дополнительных окон
--
--HCQ_UI_Main.LeftButton = {}
--HCQ_UI_Main.LeftButton['1'] =  CreateFrame("Frame", "HCQ_UI_Main_LeftButton", HCQ_UI_Main, BackdropTemplateMixin and "BackdropTemplate")
--HCQ_UI_Main.LeftButton['1']:ClearAllPoints()
--HCQ_UI_Main.LeftButton['1']:SetSize(35, 50)
--HCQ_UI_Main.LeftButton['1']:SetBackdrop({
--    bgFile = "Interface/Buttons/UI-SilverButtonLG-Left-Down",
--    tile = true,
--    tileSize = 50});
--HCQ_UI_Main.LeftButton['1']:SetPoint("TOPLEFT", -37, -20)
--HCQ_UI_Main.LeftButton['1']:SetScript("OnMouseDown", function(self)
--    HCQ_navigation(1);
--end)
--HCQ_UI_Main.LeftButton['1'].icon = CreateFrame("Frame", "RaidRoll_RespMining_ItemForm", HCQ_UI_Main.LeftButton['1'], BackdropTemplateMixin and "BackdropTemplate")
--HCQ_UI_Main.LeftButton['1'].icon:ClearAllPoints()
--HCQ_UI_Main.LeftButton['1'].icon:SetSize(35, 35)
--HCQ_UI_Main.LeftButton['1'].icon:SetPoint("TOPLEFT", 5, -6)
--HCQ_UI_Main.LeftButton['1'].icon:SetBackdrop({bgFile = "Interface\\HELPFRAME\\ReportLagIcon-Loot",  tile = false});
--
--HCQ_UI_Main.LeftButton['2'] =  CreateFrame("Frame", "HCQ_UI_Main_LeftButton", HCQ_UI_Main, BackdropTemplateMixin and "BackdropTemplate")
--HCQ_UI_Main.LeftButton['2']:ClearAllPoints()
--HCQ_UI_Main.LeftButton['2']:SetSize(35, 50)
--HCQ_UI_Main.LeftButton['2']:SetBackdrop({bgFile = "Interface/Buttons/UI-SilverButtonLG-Left-Down",  tile = true, tileSize = 50});
--HCQ_UI_Main.LeftButton['2']:SetPoint("TOPLEFT", -37, -70)
--HCQ_UI_Main.LeftButton['2']:SetScript("OnMouseDown", function(self)
--    print(2);
--end)
--
--HCQ_UI_Main.LeftButton['2'].icon = CreateFrame("Frame", "RaidRoll_RespMining_ItemForm", HCQ_UI_Main.LeftButton['2'], BackdropTemplateMixin and "BackdropTemplate")
--HCQ_UI_Main.LeftButton['2'].icon:ClearAllPoints()
--HCQ_UI_Main.LeftButton['2'].icon:SetSize(35, 35)
--HCQ_UI_Main.LeftButton['2'].icon:SetPoint("TOPLEFT", 5, -6)
--HCQ_UI_Main.LeftButton['2'].icon:SetBackdrop({bgFile = "Interface\\HELPFRAME\\HelpIcon-KnowledgeBase",  tile = false});
--
--
--HCQ_UI_Main.LeftButton['3'] =  CreateFrame("Frame", "HCQ_UI_Main_LeftButton", HCQ_UI_Main, BackdropTemplateMixin and "BackdropTemplate")
--HCQ_UI_Main.LeftButton['3']:ClearAllPoints()
--HCQ_UI_Main.LeftButton['3']:SetSize(35, 50)
--HCQ_UI_Main.LeftButton['3']:SetBackdrop({bgFile = "Interface/Buttons/UI-SilverButtonLG-Left-Down",  tile = true, tileSize = 50});
--HCQ_UI_Main.LeftButton['3']:SetPoint("TOPLEFT", -37, -120)
--HCQ_UI_Main.LeftButton['3']:SetScript("OnMouseDown", function(self)
--    HCQ_navigation(3);
--end)
--
--
--HCQ_UI_Main.LeftButton['3'].icon = CreateFrame("Frame", "RaidRoll_RespMining_ItemForm", HCQ_UI_Main.LeftButton['3'], BackdropTemplateMixin and "BackdropTemplate")
--HCQ_UI_Main.LeftButton['3'].icon:ClearAllPoints()
--HCQ_UI_Main.LeftButton['3'].icon:SetSize(35, 35)
--HCQ_UI_Main.LeftButton['3'].icon:SetPoint("TOPLEFT", 5, -6)
--HCQ_UI_Main.LeftButton['3'].icon:SetBackdrop({bgFile = "Interface\\HELPFRAME\\HelpIcon-CharacterStuck",  tile = false});
--

function HCQ_navigation(id)
    if (id == 1) then
        HCQ_UI_Main.ItemListMainPanel:Show();
    else
        HCQ_UI_Main.ItemListMainPanel:Hide();
    end
    if (id == 3) then
        HCQ_UI_Main.SettingsPanel:Show();
        buttonSettings(0);
    else
        buttonSettings(0);
        HCQ_UI_Main.SettingsPanel:Hide();
    end
    HCQ_UI_Main.ItemInfoMainPanel:Hide()
end
