local f = CreateFrame("FRAME");
f:RegisterEvent("HEARTHSTONE_BOUND");
f:RegisterEvent("PLAYER_LOGIN");

local function eventHandler(self, event, ...)
 if event == "HEARTHSTONE_BOUND" then
	HearthZone_BoundZone = GetZoneText();
 end
 if event == "PLAYER_LOGIN" then
	if not HearthZone_BoundZone then
		print ("|cff00ffecREMINDER: HearthZone will not work until the first time you bind your Hearthstone after installing this addon!|r");
	end
 end
end

local function HearthTooltip(tooltip)
	local itemName, itemLink = tooltip:GetItem();
	if itemName == "Hearthstone" then
		if HearthZone_BoundZone then
			GameTooltip:AddLine("Zone: "..HearthZone_BoundZone..".",0,0.75,1,true);
			GameTooltip:Show();
		end
	end
end

f:SetScript("OnEvent", eventHandler);

GameTooltip:HookScript("OnTooltipSetItem", HearthTooltip);