local myname, ns = ...
local mod = ns:NewModule("items")
local core = ns:GetModule("core")

local commendations, achievements

function mod:OnLoad()
    self:HookScript(GameTooltip, "OnTooltipSetItem")
    self:HookScript(ItemRefTooltip, "OnTooltipSetItem")
    self:HookScript(ShoppingTooltip1, "OnTooltipSetItem")
    self:HookScript(ShoppingTooltip2, "OnTooltipSetItem")
    -- self:HookScript(ShoppingTooltip3, "OnTooltipSetItem")
end

function mod:OnTooltipSetItem(tooltip)
    local name, link = tooltip:GetItem()
    if not name then
        return
    end
    local name, link, quality, ilvl, reqlvl, class, subclass, maxstack, equipslot, texture, vendorprice = GetItemInfo(link)
    if not name then
        -- Honestly, this is incredibly unlikely.
        return
    end
    local id = tonumber(link:match("item:(%d+):"))
    if not id then
        -- Similarly unlikely.
        return
    end

    -- and now the types
    if core.db.achievements then
        for achievementid, items in pairs(achievements) do
            if items == false then
                items = {}
                for i=1, GetAchievementNumCriteria(achievementid) do
                    local _, _, _, _, _, _, _, itemid, _, criteriaid = GetAchievementCriteriaInfo(achievementid, i)
                    if itemid and criteriaid then
                        items[itemid] = criteriaid
                        achievements[achievementid] = items
                    end
                end
            end
            if items and items.items then
                local mapped_items = self:CriteriaIDForItems(achievementid, items.items)
                if mapped_items then
                    achievements[achievementid] = mapped_items
                    items = mapped_items
                end
            end
            if items and items[id] then
                local _, a_name, _, complete = GetAchievementInfo(achievementid)
                if core.db.done_achievements or not complete then
                    local desc, done
                    if items[id] < 0 then
                        desc, _, done = GetAchievementCriteriaInfo(achievementid, -items[id])
                    else
                        desc, _, done = GetAchievementCriteriaInfoByID(achievementid, items[id])
                    end
                    if core.db.done_criteria or not done then
                        self:AddTooltipLine(tooltip, done, a_name, NEED, DONE)
                    end
                end
            end
        end
    end

    -- and this is a different check
    if core.db.commendations and commendations[id] then
        local hasBonusRepGain = select(15, GetFactionInfoByID(commendations[id]))
        self:AddTooltipLine(tooltip, hasBonusRepGain, BONUS_REPUTATION_TITLE, NEED, DONE)
    end

    -- refresh!
    tooltip:Show()
end

function mod:CriteriaIDForItems(achievementid, itemid_table)
    -- takes an achievement and a table of {itemid1 = itemid2}, and maps that table into {itemid1 = criteriaid}
    -- where criteriaid is the criteria associated with itemid2, either by itemid in the criteriainfo, or by name
    local itemid_to_criteria = {}
    local name_to_criteria = {}
    for i=1, GetAchievementNumCriteria(achievementid) do
        local desc, _, _, _, _, _, _, itemid, _, criteriaid = GetAchievementCriteriaInfo(achievementid, i)
        criteriaid = (not criteriaid or criteriaid == 0) and -i or criteriaid
        if itemid and itemid > 0 then
            itemid_to_criteria[itemid] = criteriaid
        else
            name_to_criteria[desc] = criteriaid
        end
    end
    local ret = {}
    for k, itemid in pairs(itemid_table) do
        if itemid_to_criteria[itemid] then
            ret[k] = itemid_to_criteria[itemid]
        else
            local name = GetItemInfo(itemid)
            if name and name_to_criteria[name] then
                ret[k] = name_to_criteria[name]
            else
                -- abort!
                return
            end
        end
        ret[itemid] = ret[k]
    end
    return ret
end

-- big ol' lists

commendations = {
    -- itemid = factionid
    [93220] = 1270, -- shado-pan
    [92522] = 1337, -- klaxxi
    [93230] = 1345, -- lorewalkers
    [93226] = 1272, -- tillers
    [93229] = 1271, -- cloud serpent
    [93215] = 1269, -- golden lotus
    [93224] = 1341, -- august celestials
    [93225] = 1302, -- anglers
    [95548] = 1388, -- sunreaver onslaught
    [93232] = 1375, -- dominance offensive
    [95545] = 1387, -- kirin tor offensive
    [93231] = 1376, -- operation shieldwall
}

achievements = {
    [5753] = false, -- cataclysmically delicious
    [5754] = false, -- drown your sorrows
    [7329] = false, -- pandaren cuisine
    [7330] = false, -- pandaren delicacies
    [9502] = false, -- draenor cuisine
    [10596] = {
        items = {
            -- azsuna
            [133701] = 133725, -- Leyshimmer Blenny (skrog toenail)
            [133702] = 133725, -- Leyshimmer Blenny (murloc slime)
            [133703] = 133726, -- Nar'thalas Hermet (pearlescent conch)
            [133704] = 133727, -- Ghostly Queenfish (rusty queenfish brooch)
            -- val'sharah
            [133705] = 133730, -- Ancient Mossgill (rotten fishbone)
            [133708] = 133729, -- Thorned Flounder (Drowned Thistleleaf)
            [133707] = 133728, -- Terrorfin (nightmare nightcrawler)
            -- highmountain
            [133709] = 133733, -- Ancient Highmountain Salmon (funky sea snail)
            [133710] = 133733, -- Ancient Highmountain Salmon (salmon lure)
            [133711] = 133731, -- Mountain Puffer (Swollen Murloc Egg)
            [133712] = 133732, -- Coldriver Carp (Frost Worm)
            -- Stormheim
            [133713] = 133736, -- Thundering Stormray (Moosehorn Hook)
            [133714] = 133736, -- Thundering Stormray (Silverscale Minnow)
            [133715] = 133734, -- Oodelfjisk (Ancient Vrykul Ring)
            [133716] = 133735, -- Graybelly Lobster (Soggy Drakescale)
            -- Suramar
            [133717] = 133737, -- Magic-Eater Frog (Enchanted Lure)
            [133719] = 133738, -- Seerspine Puffer (Sleeping Murloc)
            [133720] = 133739, -- Tainted Runescale Koi (Demonic Detritus)
            -- Ocean
            [133721] = 133740, -- Axefish (Message in a Beer Bottle)
            [133722] = 133740, -- Axefish (Axefish Lure)
            [133723] = 133741, -- Seabottom Squid (Stunned, Angry Shark)
            [133724] = 133742, -- Ancient Black Barracuda (Decayed Whale Blubber)
            [133795] = 133742, -- Ancient Black Barracuda (Ravenous fly)
        },
    },
    [5755] = { -- tabards
        [5976] = 2340,
        [11364] = 2922,
        [15196] = 2908,
        [15197] = 2909,
        [15198] = 2903,
        [15199] = 2915,
        [19031] = 2899,
        [19032] = 2916,
        [19160] = 2898,
        [19505] = 2933,
        [19506] = 2912,
        [20131] = 2894,
        [20132] = 2335,
        [22999] = 2925,
        [23192] = 2928,
        [23388] = 2932,
        [23705] = 2918,
        [23709] = 2919,
        [23999] = 2901,
        [24004] = 2931,
        [24344] = 2927,
        [25549] = 2895,
        [28788] = 2338,
        [31404] = 2900,
        [31405] = 2337,
        [31773] = 2906,
        [31774] = 2904,
        [31775] = 2914,
        [31776] = 2336,
        [31777] = 2902,
        [31778] = 2905,
        [31779] = 2893,
        [31780] = 2910,
        [31781] = 2911,
        [31804] = 2896,
        [32445] = 2913,
        [32828] = 2907,
        [35221] = 2929,
        [35279] = 2923,
        [35280] = 2339,
        [36941] = 2897,
        [38309] = 2921,
        [38310] = 2924,
        [38311] = 2930,
        [38312] = 2917,
        [38313] = 2920,
        [38314] = 2926,
        [40643] = 12600,
        [43154] = 6976,
        [43155] = 6977,
        [43156] = 6978,
        [43157] = 6979,
        [43300] = 6151,
        [43348] = 6171,
        [43349] = 6172,
        [45574] = 11306,
        [45577] = 11305,
        [45578] = 11304,
        [45579] = 11302,
        [45580] = 11303,
        [45581] = 11378,
        [45582] = 11299,
        [45583] = 11300,
        [45584] = 11301,
        [45585] = 11298,
        [45983] = 12598,
        [46817] = 11307,
        [46818] = 11308,
        [46874] = 11309,
        [49052] = 11760,
        [49054] = 11761,
        [49086] = 12599,
        [51534] = 13242,
        [52252] = 13241,
        [56246] = 16329,
        [63378] = 16328,
        [63379] = 16327,
        [64882] = 16326,
        [64884] = 16325,
        [65904] = 16324,
        [65905] = 16323,
        [65906] = 16322,
        [65907] = 16321,
        [65908] = 16320,
        [65909] = 16319,
        [69209] = 16885,
        [69210] = 16886,
        [83079] = 21693,
        [83080] = 21692,
        [89196] = 22626,
        [89401] = 22625,
        [89784] = 22624,
        [89795] = 22623,
        [89796] = 22622,
        [89797] = 22621,
        [89798] = 22620,
        [89799] = 22619,
        [89800] = 22618,
    },
    [1832] = { -- tastes like chicken
        [1017] = 6988,
        [1082] = 6918,
        [11109] = 7015,
        [1113] = 6529,
        [1114] = 6537,
        [11415] = 6882,
        [11444] = 6708,
        [11584] = 6481,
        [117] = 7102,
        [11950] = 7989,
        [11951] = 7116,
        [11952] = 7963,
        [12209] = 6740,
        [12210] = 6923,
        [12211] = 7028,
        [12212] = 6735,
        [12213] = 6484,
        [12214] = 6892,
        [12215] = 6720,
        [12216] = 7018,
        [12217] = 6577,
        [12218] = 6885,
        [12224] = 6547,
        [12238] = 6564,
        [12763] = 7099,
        [1326] = 6972,
        [13546] = 6470,
        [13724] = 6583,
        [13754] = 7967,
        [13755] = 7111,
        [13756] = 7980,
        [13758] = 7974,
        [13759] = 7972,
        [13760] = 7981,
        [13810] = 6468,
        [13851] = 6731,
        [13888] = 7953,
        [13889] = 7982,
        [13893] = 7960,
        [13927] = 6541,
        [13928] = 6707,
        [13929] = 6730,
        [13930] = 6676,
        [13931] = 6894,
        [13932] = 6908,
        [13933] = 6742,
        [13934] = 6878,
        [13935] = 7312,
        [1487] = 6536,
        [14894] = 8687,
        [16166] = 6455,
        [16167] = 7096,
        [16168] = 6718,
        [16169] = 7113,
        [16170] = 7041,
        [16171] = 6990,
        [16766] = 7098,
        [16971] = 6526,
        [1707] = 7047,
        [17119] = 6569,
        [17197] = 6693,
        [17198] = 4681,
        [17199] = 6452,
        [17222] = 7035,
        [17344] = 6483,
        [17406] = 6724,
        [17407] = 6699,
        [17408] = 7030,
        [18045] = 7094,
        [18254] = 6933,
        [18255] = 6932,
        [18632] = 6887,
        [18633] = 7088,
        [18635] = 6457,
        [19060] = 8688,
        [19061] = 8689,
        [19062] = 8690,
        [19223] = 7313,
        [19224] = 6915,
        [19225] = 6567,
        [19301] = 6448,
        [19304] = 7017,
        [19305] = 6903,
        [19306] = 6552,
        [19696] = 6711,
        [19994] = 6713,
        [19995] = 6710,
        [19996] = 6712,
        [20031] = 6584,
        [20062] = 8692,
        [20063] = 8691,
        [20064] = 8693,
        [20074] = 6719,
        [20222] = 8694,
        [20223] = 8695,
        [20224] = 8696,
        [20225] = 8697,
        [20226] = 8698,
        [20227] = 8699,
        [20388] = 8700,
        [20389] = 8701,
        [20390] = 8702,
        [20452] = 7004,
        [20516] = 6471,
        [20557] = 8703,
        [2070] = 6565,
        [20857] = 6726,
        [21023] = 6576,
        [21030] = 6566,
        [21031] = 6480,
        [21033] = 6909,
        [21071] = 7976,
        [21072] = 7006,
        [21153] = 7968,
        [21215] = 6700,
        [21217] = 6934,
        [21235] = 7107,
        [21236] = 7108,
        [21240] = 7110,
        [21254] = 7109,
        [21537] = 8704,
        [21552] = 7115,
        [22019] = 6531,
        [22236] = 8705,
        [22237] = 8706,
        [22238] = 8707,
        [22239] = 8708,
        [22324] = 7112,
        [22645] = 6554,
        [2287] = 6714,
        [22895] = 6530,
        [23160] = 6687,
        [23172] = 6919,
        [23175] = 8709,
        [23211] = 8710,
        [23326] = 8711,
        [23327] = 8712,
        [23435] = 8713,
        [23495] = 7040,
        [23756] = 6543,
        [24008] = 6581,
        [24009] = 6579,
        [24072] = 6970,
        [24105] = 6927,
        [24338] = 6722,
        [24408] = 8714,
        [24421] = 8715,
        [24539] = 6875,
        [24540] = 8716,
        [2679] = 6521,
        [2680] = 7027,
        [2681] = 6924,
        [2682] = 6540,
        [2683] = 6545,
        [2684] = 6544,
        [2685] = 7090,
        [2687] = 6582,
        [27635] = 6870,
        [27636] = 6454,
        [27651] = 6479,
        [27655] = 6911,
        [27656] = 7039,
        [27657] = 6462,
        [27658] = 6925,
        [27659] = 7118,
        [27660] = 7092,
        [27661] = 6465,
        [27662] = 6586,
        [27663] = 6464,
        [27664] = 6704,
        [27665] = 6904,
        [27666] = 6695,
        [27667] = 7032,
        [27854] = 7008,
        [27855] = 6872,
        [27856] = 6996,
        [27857] = 6690,
        [27858] = 7122,
        [27859] = 7105,
        [28112] = 7097,
        [28486] = 6888,
        [28501] = 6912,
        [2888] = 6456,
        [29292] = 6721,
        [29293] = 6473,
        [29393] = 6574,
        [29394] = 6871,
        [29412] = 6733,
        [29448] = 6873,
        [29449] = 6467,
        [29450] = 7119,
        [29451] = 6528,
        [29452] = 7104,
        [29453] = 7038,
        [30155] = 6524,
        [30355] = 6706,
        [30357] = 6898,
        [30358] = 6897,
        [30359] = 6900,
        [30361] = 6899,
        [30458] = 7087,
        [30610] = 7003,
        [30816] = 7016,
        [31672] = 6884,
        [31673] = 6553,
        [3220] = 6469,
        [32685] = 6896,
        [32686] = 6880,
        [32721] = 6998,
        [32722] = 4683,
        [33004] = 6527,
        [33024] = 18622,
        [33025] = 18623,
        [33026] = 18624,
        [33043] = 7987,
        [33048] = 7044,
        [33052] = 6682,
        [33053] = 6728,
        [33218] = 8717,
        [33226] = 8718,
        [33246] = 7957,
        [33254] = 8030,
        [33443] = 7013,
        [33449] = 6556,
        [33451] = 6678,
        [33452] = 6727,
        [33454] = 6969,
        [33825] = 6997,
        [33866] = 7046,
        [33867] = 6478,
        [33872] = 7034,
        [33874] = 6737,
        [33924] = 6572,
        [34062] = 6532,
        [34063] = 18619,
        [34064] = 18620,
        [34065] = 18621,
        [34125] = 6992,
        [34410] = 7959,
        [3448] = 6989,
        [34747] = 6895,
        [34748] = 6874,
        [34749] = 6993,
        [34750] = 7106,
        [34751] = 6929,
        [34752] = 6920,
        [34753] = 6701,
        [34754] = 6877,
        [34755] = 7103,
        [34756] = 7029,
        [34757] = 7095,
        [34758] = 6879,
        [34759] = 7005,
        [34760] = 6702,
        [34761] = 6971,
        [34762] = 6705,
        [34763] = 7007,
        [34764] = 6906,
        [34765] = 6902,
        [34766] = 6907,
        [34767] = 6680,
        [34768] = 7031,
        [34769] = 6732,
        [34770] = 6542,
        [34780] = 6893,
        [35285] = 7958,
        [35287] = 7961,
        [35563] = 6520,
        [35565] = 6734,
        [35710] = 6570,
        [35947] = 7014,
        [35948] = 6985,
        [35949] = 7100,
        [35950] = 7091,
        [35951] = 6905,
        [35952] = 6476,
        [35953] = 6876,
        [3662] = 6551,
        [3663] = 6890,
        [3664] = 6550,
        [3665] = 6558,
        [3666] = 6697,
        [36831] = 7045,
        [37252] = 6689,
        [3726] = 6459,
        [3727] = 6729,
        [3728] = 7121,
        [3729] = 7012,
        [37452] = 6585,
        [37582] = 8719,
        [37583] = 8720,
        [37584] = 8721,
        [37585] = 8722,
        [3770] = 6891,
        [3771] = 7114,
        [38427] = 6901,
        [38428] = 6930,
        [38706] = 6474,
        [3927] = 6679,
        [39691] = 7089,
        [40202] = 6995,
        [40356] = 6709,
        [40358] = 6914,
        [40359] = 6685,
        [414] = 6563,
        [41729] = 7043,
        [41751] = 6460,
        [422] = 7314,
        [42342] = 8723,
        [42350] = 8724,
        [42428] = 6519,
        [42429] = 6916,
        [42430] = 6562,
        [42431] = 6560,
        [42432] = 6458,
        [42433] = 6522,
        [42434] = 6869,
        [42778] = 6555,
        [42779] = 7042,
        [42942] = 6451,
        [42993] = 7033,
        [42994] = 6921,
        [42995] = 6717,
        [42996] = 7009,
        [42997] = 6466,
        [42998] = 6559,
        [42999] = 6463,
        [43000] = 6578,
        [43001] = 7101,
        [43004] = 6549,
        [43005] = 7019,
        [43015] = 6681,
        [43087] = 6546,
        [43088] = 7952,
        [43268] = 6561,
        [43478] = 6692,
        [43480] = 7000,
        [43488] = 6738,
        [43490] = 7093,
        [43491] = 6450,
        [43492] = 6715,
        [43518] = 6533,
        [43523] = 6534,
        [43571] = 9518,
        [43572] = 7962,
        [43647] = 7984,
        [44049] = 7956,
        [44071] = 8004,
        [44072] = 7983,
        [4457] = 6453,
        [4536] = 6991,
        [4537] = 7120,
        [4538] = 7010,
        [4539] = 6696,
        [4540] = 7125,
        [4541] = 6686,
        [4542] = 6883,
        [4544] = 6889,
        [45901] = 15473,
        [4592] = 6868,
        [45932] = 10658,
        [4593] = 6477,
        [4594] = 6931,
        [4599] = 6557,
        [4601] = 7011,
        [4602] = 6886,
        [4603] = 7979,
        [4604] = 6684,
        [4605] = 6917,
        [4606] = 7037,
        [4607] = 6571,
        [4608] = 6913,
        [4656] = 7001,
        [5057] = 6922,
        [5066] = 6683,
        [5095] = 6910,
        [5349] = 6535,
        [5472] = 6736,
        [5473] = 6987,
        [5474] = 6926,
        [5476] = 6677,
        [5477] = 7123,
        [5478] = 6575,
        [5479] = 6548,
        [5480] = 6739,
        [5525] = 6472,
        [5526] = 6525,
        [5527] = 6694,
        [58258] = 16991,
        [58259] = 16971,
        [58260] = 16980,
        [58261] = 16959,
        [58262] = 16990,
        [58263] = 16967,
        [58264] = 16992,
        [58265] = 16970,
        [58266] = 16999,
        [58267] = 16985,
        [58268] = 16981,
        [58269] = 16976,
        [58275] = 16968,
        [58276] = 16965,
        [58277] = 16988,
        [58278] = 16996,
        [58279] = 16994,
        [58280] = 16993,
        [59227] = 16982,
        [59228] = 16998,
        [59231] = 16978,
        [59232] = 16997,
        [6038] = 6691,
        [62649] = 16964,
        [62651] = 16974,
        [62652] = 16986,
        [62653] = 16983,
        [62654] = 16972,
        [62655] = 16958,
        [62656] = 17000,
        [62657] = 16975,
        [62658] = 16995,
        [62659] = 16969,
        [62660] = 16979,
        [62661] = 17001,
        [62662] = 16966,
        [62663] = 16973,
        [62664] = 16961,
        [62665] = 16954,
        [62666] = 16962,
        [62667] = 16977,
        [62668] = 16956,
        [62669] = 16989,
        [62670] = 16955,
        [62671] = 16987,
        [62676] = 16957,
        [62677] = 16963,
        [62680] = 16960,
        [6289] = 7970,
        [6290] = 6475,
        [6291] = 7965,
        [6299] = 6994,
        [6303] = 7977,
        [6308] = 7966,
        [6316] = 6743,
        [6317] = 7969,
        [6361] = 7973,
        [6362] = 7975,
        [6458] = 7964,
        [6522] = 6573,
        [65499] = 18629,
        [65500] = 18625,
        [65515] = 18626,
        [65516] = 18627,
        [65517] = 18628,
        [6657] = 6973,
        [67270] = 17402,
        [67271] = 17403,
        [67272] = 17404,
        [67273] = 17405,
        [6807] = 6688,
        [68687] = 16984,
        [6887] = 7986,
        [6888] = 6723,
        [6890] = 7002,
        [7097] = 6741,
        [7228] = 7124,
        [724] = 6698,
        [73260] = 18596,
        [733] = 7117,
        [74921] = 18595,
        [75027] = 18597,
        [75028] = 18598,
        [75029] = 18599,
        [75030] = 18600,
        [75031] = 18601,
        [75032] = 18602,
        [75033] = 18603,
        [75034] = 18604,
        [75035] = 18605,
        [75036] = 18606,
        [7806] = 6867,
        [7807] = 6482,
        [7808] = 6523,
        [787] = 6999,
        [8075] = 6538,
        [8076] = 6539,
        [8243] = 6986,
        [8364] = 6881,
        [8365] = 7971,
        [8543] = 7988,
        [8932] = 6449,
        [8948] = 6580,
        [8950] = 6725,
        [8952] = 6928,
        [8953] = 6568,
        [8957] = 7036,
        [8959] = 7978,
        [961] = 6716,
        [9681] = 6703,
    },
    [1774] = { -- happy hour
        [10841] = 4691,
        [1119] = 6942,
        [1179] = 4695,
        [11846] = 6951,
        [12003] = 4677,
        [1205] = 4697,
        [1262] = 9498,
        [1322] = 8985,
        [13813] = 8988,
        [15723] = 8989,
        [159] = 4705,
        [1645] = 4699,
        [17048] = 8990,
        [1708] = 4717,
        [17196] = 4693,
        [17198] = 4681,
        [17199] = 6452,
        [17402] = 4692,
        [17403] = 4715,
        [17404] = 4659,
        [18269] = 8991,
        [18284] = 8992,
        [18287] = 4685,
        [18288] = 4698,
        [18300] = 6953,
        [19221] = 4678,
        [19222] = 4665,
        [19299] = 4687,
        [19300] = 4661,
        [19318] = 8993,
        [19997] = 8994,
        [20709] = 4708,
        [21114] = 4707,
        [21151] = 4706,
        [21241] = 8995,
        [2136] = 4673,
        [21721] = 4700,
        [22018] = 4669,
        [22778] = 8996,
        [22779] = 8997,
        [2288] = 4668,
        [23161] = 8998,
        [23164] = 8999,
        [23176] = 9000,
        [23246] = 9001,
        [23492] = 10505,
        [23584] = 9002,
        [23585] = 9003,
        [23586] = 5190,
        [23704] = 6954,
        [23848] = 4702,
        [24006] = 9004,
        [24007] = 9005,
        [2593] = 4689,
        [2594] = 4688,
        [2595] = 6943,
        [2596] = 4710,
        [2686] = 6944,
        [2723] = 4660,
        [27553] = 9006,
        [27860] = 4704,
        [28284] = 4679,
        [28399] = 4686,
        [2894] = 6945,
        [29112] = 4664,
        [29395] = 4684,
        [29401] = 4712,
        [29454] = 4709,
        [29482] = 9007,
        [30309] = 9008,
        [30457] = 4690,
        [30499] = 9009,
        [30615] = 9010,
        [30703] = 4672,
        [30858] = 9011,
        [31451] = 9012,
        [32424] = 9013,
        [32453] = 4714,
        [32455] = 4713,
        [32667] = 4654,
        [32668] = 4680,
        [32722] = 4683,
        [33028] = 8883,
        [33029] = 8884,
        [33030] = 8885,
        [33031] = 8879,
        [33032] = 8880,
        [33033] = 8881,
        [33034] = 8878,
        [33035] = 8882,
        [33036] = 9014,
        [33042] = 4655,
        [33234] = 9015,
        [33236] = 9016,
        [33444] = 6955,
        [33445] = 6956,
        [33929] = 18611,
        [33956] = 9017,
        [34017] = 8891,
        [34018] = 8886,
        [34019] = 8887,
        [34020] = 8888,
        [34021] = 8889,
        [34022] = 8890,
        [34411] = 4694,
        [34412] = 9018,
        [34832] = 4663,
        [35720] = 6957,
        [35954] = 6958,
        [36748] = 9019,
        [3703] = 4711,
        [37253] = 6959,
        [37488] = 10978,
        [37489] = 10501,
        [37490] = 5192,
        [37491] = 10504,
        [37492] = 10506,
        [37493] = 5194,
        [37494] = 9020,
        [37495] = 10500,
        [37496] = 5196,
        [37497] = 10498,
        [37498] = 10499,
        [37499] = 10503,
        [3772] = 4675,
        [37898] = 9499,
        [37899] = 10502,
        [37900] = 5191,
        [37901] = 9500,
        [37902] = 9501,
        [37903] = 5193,
        [37904] = 9502,
        [37905] = 9021,
        [37906] = 5195,
        [37907] = 9022,
        [37908] = 9023,
        [37909] = 9024,
        [38294] = 9025,
        [38300] = 9026,
        [38320] = 9027,
        [38350] = 6960,
        [38429] = 4658,
        [38430] = 4657,
        [38431] = 4656,
        [38432] = 4703,
        [38466] = 4716,
        [38698] = 6961,
        [39520] = 6962,
        [39738] = 9028,
        [40035] = 6963,
        [40036] = 6964,
        [40042] = 6485,
        [40357] = 6966,
        [41731] = 8866,
        [42381] = 9029,
        [42777] = 6967,
        [43086] = 6968,
        [43695] = 9030,
        [43696] = 9031,
        [44570] = 8872,
        [44571] = 8874,
        [44573] = 8875,
        [44574] = 8877,
        [44575] = 8873,
        [44616] = 8867,
        [44617] = 8868,
        [44618] = 8869,
        [44619] = 8870,
        [44620] = 8871,
        [44716] = 8876,
        [44941] = 18609,
        [4595] = 4696,
        [4600] = 4666,
        [46319] = 10618,
        [46399] = 18612,
        [46400] = 18613,
        [46401] = 18614,
        [46402] = 18615,
        [46403] = 18616,
        [4791] = 4682,
        [4952] = 8986,
        [4953] = 8987,
        [5265] = 6946,
        [5342] = 6947,
        [5350] = 4676,
        [58256] = 16952,
        [58257] = 16949,
        [58274] = 16945,
        [59029] = 16947,
        [59229] = 16950,
        [59230] = 16946,
        [61982] = 16829,
        [61983] = 16828,
        [61984] = 16831,
        [61985] = 16827,
        [61986] = 16830,
        [62672] = 16951,
        [62674] = 16948,
        [62675] = 16953,
        [62790] = 17002,
        [74822] = 18610,
        [7676] = 4718,
        [8077] = 4671,
        [8078] = 4674,
        [8079] = 4667,
        [81406] = 20597,
        [81407] = 20863,
        [81414] = 20604,
        [81415] = 20864,
        [81923] = 20861,
        [81924] = 20862,
        [82343] = 20865,
        [82344] = 20866,
        [83094] = 20867,
        [83095] = 20868,
        [8766] = 4701,
        [9260] = 6948,
        [9360] = 6949,
        [9361] = 6950,
        [9451] = 4662,
    },
}
-- HIDTa = achievements
