﻿-- Created by  : Linty
-- Create Date : 2/13/2010 11:08:52 AM
hwm.browser.Selected=0;
hwm.browser.Position=0;
hwm.browser.Count=0;
hwm.browser.List={};
hwm.browser.SessionOnly=false;
hwm.browser.ServerOnly=false;
hwm.browser.PopularOnly=false;


function hwm.browser:Show()
	HWM_Browse_Frame:Show();
end

function hwm.browser:CreateFriendButt()
	CreateFrame("Button", "HWM_FriendButt",FriendsFrame,"UIPanelButtonTemplate")
	HWM_FriendButt:SetPoint("TOPLEFT",210,1);
	HWM_FriendButt:SetHeight(22);
	HWM_FriendButt:SetWidth(106);
	HWM_FriendButt:SetText("Have We Met?");
	HWM_FriendButt:Show();
	
	HWM_FriendButt:SetScript("OnClick",hwm.browser.Show);

end
function hwm.browser:IsPopular(pserv, pname)
	local prating, pdata=hwm:PlayerInfo(pserv,pname);
	if (prating>0) then
		if (prating>3 or pdata.Rating>3 or pdata.LastGroup+(60*24*7)>time()) then
			return true
		end
	end
	
	return false;
end

function hwm.browser:Sort(row1, row2)
	if (row1==nil or row2==nil) then
		return false;
	end
	
	return row1.Player<row2.Player;
end

function hwm.browser:Query()
--hwm.utils:Chat("--query--");
	-- Get Filter Options
	hwm.browser.SessionOnly = (HWM_Browse_Frame_FilterSession:GetChecked()~=false);
	hwm.browser.ServerOnly = (HWM_Browse_Frame_FilterServer:GetChecked()~=false);
	hwm.browser.PopularOnly = (HWM_Browse_Frame_FilterPopular:GetChecked()~=false);
	
	hwm.browser.List={};
	-- process if all
	if (hwm.browser.SessionOnly==false and hwm.browser.ServerOnly==false) then
	--	hwm.utils:Chat("- Get all.");
		for skey, server in pairs(HWM_Global.Players) do
		--	hwm.utils:Chat("got "..skey);
			for pkey, player in pairs(HWM_Global.Players[skey]) do
			
				if (hwm.browser.PopularOnly==false or hwm.browser:IsPopular(skey,pkey)) then
					table.insert(hwm.browser.List,{Server=skey,Player=pkey});
				end
			end
		end
		--Process all for server
	elseif (hwm.browser.SessionOnly==false and hwm.browser.ServerOnly==true) then
	--hwm.utils:Chat("- server.");
			skey=GetRealmName();
			if (HWM_Global.Players[skey]~=nil) then
				for pkey, player in pairs(HWM_Global.Players[skey]) do
					if (hwm.browser.PopularOnly==false or hwm.browser:IsPopular(skey,pkey)) then
						table.insert(hwm.browser.List,{Server=skey,Player=pkey});
					end
				end
			end
		--All session only
	elseif (hwm.browser.SessionOnly==true and hwm.browser.ServerOnly==false) then
		--hwm.utils:Chat("- session.");
			if (hwm.vars.sessionddata~=nil) then
				for pkey, player in pairs(hwm.vars.sessionddata) do
					if (hwm.browser.PopularOnly==false or hwm.browser:IsPopular(player.Server,player.Name)) then
							table.insert(hwm.browser.List,{Server=player.Server,Player=player.Name});
					end
				end
			end
	--- Serve/Session only
	elseif (hwm.browser.SessionOnly==true and hwm.browser.ServerOnly==true) then
			--hwm.utils:Chat("- server+session.");
			if (hwm.vars.sessionddata~=nil) then
				for pkey, player in pairs(hwm.vars.sessionddata) do
					if (player.Server==GetRealmName()) then
						if (hwm.browser.PopularOnly==false or hwm.browser:IsPopular(player.Server,player.Name)) then
							table.insert(hwm.browser.List,{Server=player.Server,Player=player.Name});
						end
					end
				end
			end
	end
	
	--hwm.utils:Chat("Selected "..#hwm.browser.List.." rows.");
	
	hwm.browser.Count=#hwm.browser.List;
	
	if (#hwm.browser.List~=0) then
		HWM_Browse_Frame_ScrollBar:SetMinMaxValues(1,hwm.browser.Count);
		sort(hwm.browser.List,function(a,b) return a.Player<b.Player end)
		
		
	else
		
		HWM_Browse_Frame_ScrollBar:SetMinMaxValues(1,1);
		
		
		
		
	end
	hwm.browser.Position=1;
	
	HWM_Browse_Frame_ScrollBar:SetValueStep(1);
	HWM_Browse_Frame_ScrollBar:SetValue(1);
	HWM_Browse_Frame_ScrollBarLow:SetText("");
	HWM_Browse_Frame_ScrollBarHigh:SetText("");
	
	hwm.browser:Update();
	hwm.browser:Select(1);
	
end
function hwm.browser:Find()
	--hwm.utils:Chat("Find..");
	local ftext=strupper(HWM_Browse_Frame_FindTxt:GetText());
	for i=hwm.browser.Position+1,hwm.browser.Count,1 do
		local st,fin = strfind(strupper(hwm.browser.List[i].Player),ftext);
		if (st~=nil) then
				--hwm.utils:Chat("Found: "..ftext.." -> "..hwm.browser.List[i].Player);
			HWM_Browse_Frame_ScrollBar:SetValue(i);
			return;
		end
	end

end
function hwm.browser:Scroll()
	hwm.browser.Position=math.floor(HWM_Browse_Frame_ScrollBar:GetValue());
	hwm.browser:Update();
	hwm.browser:Select(1);
end

function hwm.browser:ScrollUp()
	if (hwm.browser.Position-7<1) then
	HWM_Browse_Frame_ScrollBar:SetValue(1)
		return;
	end
	HWM_Browse_Frame_ScrollBar:SetValue(hwm.browser.Position-7);
end

function hwm.browser:ScrollDown()
	if (hwm.browser.Position+7>hwm.browser.Count) then
		HWM_Browse_Frame_ScrollBar:SetValue(hwm.browser.Count)
		return;
	end
	HWM_Browse_Frame_ScrollBar:SetValue(hwm.browser.Position+7);
end

function hwm.browser:Goto(row)
	HWM_Browse_Frame_ScrollBar:SetValue(row);
	
	
end

function hwm.browser:Update()

	for i=1,8, 1 do
		local row=math.floor(hwm.browser.Position+i-1);
		
		if  (row>hwm.browser.Count or #hwm.browser.List<1) then
			_G["HWM_Browse_Frame_r"..i.."c1"]:SetText("");
			_G["HWM_Browse_Frame_r"..i.."c2"]:SetText("");
			--_G["HWM_Browse_Frame_r"..i.."c3"]:SetText("");
			_G["HWM_Browse_Frame_r"..i.."c4"]:SetText("");
			_G["HWM_Browse_Frame_r"..i.."c5"]:SetText("");
			_G["HWM_Browse_Frame_r"..i.."c6"]:SetText("");
			_G["HWM_Browse_Frame_backrow"..i]:SetTexture(0,0,0,0);
		
		elseif (hwm.browser.List[row]==nil or hwm.browser.List[row].Server==nil or hwm.browser.List[row].Player==nil) then -- Something wrong with the entry
			_G["HWM_Browse_Frame_r"..i.."c1"]:SetText("Unknown");
			_G["HWM_Browse_Frame_r"..i.."c2"]:SetText("**err**");
			_G["HWM_Browse_Frame_r"..i.."c4"]:SetText("");
			_G["HWM_Browse_Frame_r"..i.."c5"]:SetText("");
			_G["HWM_Browse_Frame_r"..i.."c6"]:SetText("");
				hwm.utils:Chat("Data Error: "..row);
			_G["HWM_Browse_Frame_backrow"..i]:SetTexture(0,0,0,0);
		

		else
		
			
			local prating, pdata=hwm:PlayerInfo(hwm.browser.List[row].Server,hwm.browser.List[row].Player);
			
	
			--hwm.utils:Chat("prating "..prating);
			_G["HWM_Browse_Frame_r"..i.."c1"]:SetText("|Cffffffff"..hwm.browser.List[row].Player);
			if (prating>0) then
				_G["HWM_Browse_Frame_r"..i.."c2"]:SetText("|cff"..hwm.lang.tt_ratingcol[prating]..hwm.lang.tt_rating[prating]);
				_G["HWM_Browse_Frame_r"..i.."c4"]:SetText(hwm.utils:TimeString(time()-pdata.LastGroup));
				_G["HWM_Browse_Frame_r"..i.."c5"]:SetText("|cffcccccc"..hwm.browser.List[row].Server);
				_G["HWM_Browse_Frame_r"..i.."c6"]:SetText("|cff"..hwm.lang.RateColors[pdata.Rating]..
					hwm.lang.RateLabels[pdata.Rating]..": "..pdata.Note);
				
				local cr= hwm.lang.RateHighlight[pdata.Rating][1];
				local cg = hwm.lang.RateHighlight[pdata.Rating][2];
				local cb=hwm.lang.RateHighlight[pdata.Rating][3];
				local ca =hwm.lang.RateHighlight[pdata.Rating][4];
				
				---hwm.utils:Chat("Color "..cr..","..cg..","..cb..","..ca);
				
				_G["HWM_Browse_Frame_backrow"..i]:SetTexture(cr,cg,cb,ca);
				---_G["HWM_Browse_Frame_backrow"..i]:SetTexture(1,1,1,0.5);
			else
				_G["HWM_Browse_Frame_r"..i.."c2"]:SetText("**err**");
				_G["HWM_Browse_Frame_r"..i.."c4"]:SetText("");
				_G["HWM_Browse_Frame_r"..i.."c5"]:SetText("");
				_G["HWM_Browse_Frame_r"..i.."c6"]:SetText("");
					hwm.utils:Chat("prating error: "..row);
				_G["HWM_Browse_Frame_backrow"..i]:SetTexture(0,0,0,0);
			end
			--_G["HWM_Browse_Frame_r"..i.."c3"]:SetText("");
			
		end
	
		HWM_Browse_Frame_Status:SetText("|cff00ff00"..string.format(hwm.lang.BrowStatus,hwm.browser.Position,hwm.browser.Count));
		
	end

end
function hwm.browser:Edit(row)
	
	if (row==nil) then
		row=hwm.browser.Selected;
	end
	
--	hwm.utils:Chat("edit position:: "..row);
	
	if (row<1 or row>8 or hwm.browser.Count<hwm.browser.Position-1+row) then
		return;
	end
	
--	hwm.utils:Chat("edit item:: "..hwm.browser.Position-1+row);
	local sunit = hwm.browser.List[hwm.browser.Position-1+row];
	
	HWM_Rate_Show(sunit.Server, sunit.Player);
	
		
end

function hwm.browser:Whisper()
	
		row=hwm.browser.Selected;
	
	if (row<1 or row>8 or hwm.browser.Count<hwm.browser.Position-1+row) then
		return;
	end
	
	
	local sunit = hwm.browser.List[hwm.browser.Position-1+row];
	
	--ChatFrameEditBox:Show();
	--ChatFrameEditBox:SetText("/w "..sunit.Player);
	
	
	--local activeWindow = ChatEdit_GetActiveWindow();
	--if ( activeWindow ) then
	--	activeWindow:SetText("/w "..sunit.Player);
	--end
	---ChatEdit_FocusActiveWindow()
	
	--local bxSend=ChatEdit_ChooseBoxForSend()
	--bxSend:SetAttribute("tellTarget",sunit.Player)
	--bxSend:SetAttribute("chatType", "WISPER") 
	ChatFrame_OpenChat("/w "..sunit.Player.." ")
end

function hwm.browser:Who()
	
		row=hwm.browser.Selected;
	
	if (row<1 or row>8 or hwm.browser.Count<hwm.browser.Position-1+row) then
		return;
	end
	
	
	local sunit = hwm.browser.List[hwm.browser.Position-1+row];
	SetWhoToUI(0);
	SendWho(sunit.Player);
	
		
end
function hwm.browser:Select(row)
	if (hwm.browser.Count<hwm.browser.Position-1+row) then
		row=-1;
	end


	for i=1,8, 1 do
   
		local srow="HWM_Browse_Frame_row" .. i;
		if (_G[srow]~= nil) then
			if (i==row ) then 
				_G[srow]:SetAlpha(0.4);
				hwm.browser.Selected=row;
			else
				_G[srow]:SetAlpha(0);
			end
		end
   
	end
			
	

end

function hwm.browser:Highlight(row)
		if (hwm.browser.Count<hwm.browser.Position-1+row) then
			return;
		end
   
		local srow="HWM_Browse_Frame_row" .. row;
		if (_G[srow]~= nil) then
			if (_G[srow]:GetAlpha()~=0.4) then 
				_G[srow]:SetAlpha(0.2);
			end
		end
		
		local sunit = hwm.browser.List[hwm.browser.Position-1+row];
	-- hwm.utils:Chat(arg)
		if (sunit==nil) then
			GameTooltip_SetDefaultAnchor(GameTooltip, HWM_Browse_Frame);
			GameTooltip:SetText("|cffff0000Unit could not be found!!");
			GameTooltip:Show();
			return;
		end
		
		GameTooltip_SetDefaultAnchor(GameTooltip, HWM_Browse_Frame);
		GameTooltip:SetText(sunit.Player);
		GameTooltip:AddLine(sunit.Server);
				
		hwm:AppendTooltip(sunit.Server, sunit.Player);
		GameTooltip:Show();


end

function hwm.browser:Hide(row)
	
	local srow="HWM_Browse_Frame_row" .. row;
		if (_G[srow]~= nil) then
			if (_G[srow]:GetAlpha()~=0.4) then 
				_G[srow]:SetAlpha(0);
			end
		end
		GameTooltip:Hide();	
	

end