if not LibStub then return end

local LDB = LibStub("LibDataBroker-1.1")
local tip = LibStub('LibQTip-1.0')


HWM_Broker = LibStub("AceAddon-3.0"):NewAddon("Broker_HaveWeMet", "AceConsole-3.0", "AceTimer-3.0", "AceEvent-3.0")



local function HWMBTooltip_ClickLine(line, setName, button)
	if (setName=="Browse Players") then HWM_Browse_Frame:Show() end
	if (setName=="Current Session") then hwm.utils:SessionToggle() end
	if (setName=="Configure") then hwm_config.config.AceDialog:Open("hwm"); end
	
	HWM_Broker.tooltip:Hide();
	
end

local function HWMBTooltip_ClickPlaya(line, setName, button)
	
	local sunit = hwm.vars.sessionddata[setName];
	if (sunit==nil) then
		return;
	end
	HWM_Rate_Show(sunit.Server, sunit.Name);
	HWM_Broker.tooltip:Hide();
	
end

local function HWMBTooltip_Show(frame)
	if tip:IsAcquired("Broker_HWM") then tip:Release(HWM_Broker.tooltip) end
	HWM_Broker.tooltip = tip:Acquire("Broker_HWM", 2, "LEFT", "LEFT")
	
	--write Menu Items
		HWM_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Helmet_44.blp:16|t", "Browse Players","10")
		HWM_Broker.tooltip:SetLineScript(1, "OnMouseDown", HWMBTooltip_ClickLine, "Browse Players")
		HWM_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Misc_Bone_OrcSkull_01.blp:16|t", "Current Session")
		HWM_Broker.tooltip:SetLineScript(2, "OnMouseDown", HWMBTooltip_ClickLine, "Current Session")
		HWM_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Holiday_Christmas_Present_01.blp:16|t", "Configure")
		HWM_Broker.tooltip:SetLineScript(3, "OnMouseDown", HWMBTooltip_ClickLine, "Configure")
		
	-- Write recent History
	if hwm.vars.sessionddata~=nil then
		HWM_Broker.tooltip:AddSeparator(1, .5, .5, .5, 1)
		HWM_Broker.tooltip:AddHeader("", "|cff00ff00Recent Players|r")
		
		table.sort(hwm.vars.sessionddata, function(ta, tb) return time()-ta.LastSeen>time()-tb.LastSeen end); -- Sort descending;
		
		local tmpcnt=0
		local shade_row=false
		for key,data in pairs(hwm.vars.sessionddata) do
			if (tmpcnt<30) then
				local row, col = HWM_Broker.tooltip:AddLine("", "|cff"..data.Color.code..key.." - " .. data.Race.." "..data.Class..
										"|r ("..hwm.utils:TimeString(time()-data.LastSeen)..")")
				HWM_Broker.tooltip:SetLineScript(row, "OnMouseDown", HWMBTooltip_ClickPlaya, key)
				
				if shade_row then 
					 HWM_Broker.tooltip:SetLineColor(row,0.047,0.188,.266,1)
				end
				
				shade_row= not shade_row;
			end
			tmpcnt=tmpcnt+1
		end
	end
	
	-- end menu Items
	
	
	
	HWM_Broker.tooltip:SmartAnchorTo(frame)
	HWM_Broker.tooltip:SetAutoHideDelay(1, frame)
	HWM_Broker.tooltip:Show()
end

function HWM_Broker:OnInitialize()
    -- Called when the addon is loaded
    self.lDBObject = {
		type = 'data source',
		text = 'Have We Met?',
		icon = 'Interface\\Icons\\Ability_Hunter_Readiness',
		OnEnter = HWMBTooltip_Show,
	}
	
	LDB:NewDataObject("HWM", self.lDBObject)
end
