local trigvs = {
	"!trivia",
        "!winners",
	"!answer"
}
local winnervs = {
	 { name = "Cidamnese", points = 10000, redux = 0 }
}
	-- { , answer = "", clue = "", points=25 }
local trivalvs = {
	{ 1, answer = "September 2, 2001", clue = "What date was the World of Warcraft originally announced?", points=25 },
	{ 2, answer = "November 23, 2004", clue = "What date was the World of Warcraft originally released?", points=25 },
	{ 3, answer = "K2", clue = "What is the highest mountain on Earth?", points=25 },
	{ 4, answer = "Timelord", clue = "What is the proper name for a person from Galifrey?", points=25 },
	{ 5, answer = "Sonic Screwdriver", clue = "What is \"the Doctor\"'s tool of choice?", points=25 },
	{ 6, answer = "Tenchi Muyo", clue = "From what series does \"Washu\" come?", points=25 },
	{ 7, answer = "Girls", clue = "What is the missing word: \"Who Runs The World\" by Beyonce?", points=25 },
	{ 8, answer = "Jean Valjean", clue = "Who is the leading character for \"Les Miserables\"?", points=25 },
	{ 9, answer = "Guild", clue = "By default Key Bindings, what one word best describes what \"J\" works with?", points=25 },
	{ 10, answer = "16", clue = "What are the Maximum character you can *currently* have per Realm?", points=25 },
	{ 11, answer = "50", clue = "What is the maximum amount of characters you can have per email account?", points=25 },
	{ 12, answer = "toon", clue = "What is the slang term for World of Warcraft characters?", points=25 },
	{ 13, answer = "Orgrimmar", clue = "What is the capital city for the Horde?", points=25 },
	{ 14, answer = "Cid", clue = "What is the name of the engineer character of Squaresoft's \"Final Fantasy\" franchise fame?", points=100 },
	{ 15, answer = "60", clue = "What is the level cap of \"Vanilla\" World of Warcraft?", points=25 },
	{ 16, answer = "Blackberry", clue = "What was the name of the only Canadian smartphone market entry?", points=25 },
	{ 17, answer = "me", clue = "Who is the real winner here?", points=1 },
	{ 18, answer = "What is JEOPARDY?", clue = "This show is known for clues like this.", points=200 },
	{ 19, answer = "Galifrey", clue = "\"the Doctor\" comes from what planet?", points=25 },
	{ 20, answer = "Sol", clue = "What programming language did \"Lua\" originate from?", points=25 }
}
local activeTriv = false
local currTriv = 0
local lastTriv = 0
local stop = false
function recallback()
    if activeTriv then
	C_ChatInfo.SendAddonMessage("GBM", "There were no winners.", "GUILD");
	lastTriv = currTriv
	currTriv = 0
	activeTriv = false
    else
	currTriv = math.random(#trivalvs)
	activeTriv = true
	C_ChatInfo.SendAddonMessage("GBM", trivalvs[currTriv].clue, "GUILD");
	if not stop then C_Timer.After(120, recallback) end
    end
end
local Trivia_EventFrame = CreateFrame("Frame")
Trivia_EventFrame:RegisterEvent("CHAT_MSG_ADDON")
Trivia_EventFrame:SetScript("OnEvent", function(self, event, prefix, msg, dis_type, sender)
	if event == "ADDON_LOADED" then
		if arg1 == "GuildyBot" and C_ChatInfo.RegisterAddonMessagePrefix("GBS") and C_ChatInfo.RegisterAddonMessagePrefix("GBM") then
			print("|cFF00FF00" ..event.. "|cFFFF0000 GuildyBot registered|r . . ." );
		elseif arg1 == "GuildyBot" then print("|cFF00FF00" ..event.. "|cFFFF0000 failed|r . . ." ); end
	else
		local sSender, sRealm = strsplit("-", sender, 2);
		msg = msg:lower()
		if currTriv > 0 then tmp = trivalvs[currTriv].answer:lower() end
		local itest = false
		if currTriv > 0 and msg:match(tmp) then
			-- got the answer!!
			if not stop then C_Timer.After(math.random(120, 240), recallback) end
			for _, v in ipairs(winnervs) do
				if v.name == sSender then
					itest = true
					v.points = v.points + trivalvs[currTriv].points
					v.redux = v.redux + 1
					break;
				end
			end
			if not itest then table.insert(winnervs, {name = sSender, points = trivalvs[currTriv].points, redux = 1}) end
			C_ChatInfo.SendAddonMessage("GBM", "  " ..sSender.. " won for " ..tostring(trivalvs[currTriv].points).. " points!", "GUILD");
			lastTriv = currTriv
			currTriv = 0
			activeTriv = false
		elseif msg:match(trigvs[1]) then 
            -- the message contains "!trivia" keyword
			if not activeTriv then
				currTriv = math.random(#trivalvs)
				activeTriv = true
				C_ChatInfo.SendAddonMessage("GBM", trivalvs[currTriv].clue, "GUILD");
				if not stop then C_Timer.After(120, recallback) end
			else
				stop = true
			end
		elseif msg:match(trigvs[2]) then
			-- the message contains "!winners" keyword
			C_ChatInfo.SendAddonMessage("GBM", "There are " ..#winnervs.. " winners!", "GUILD");
			for _, v in pairs(winnervs) do
				C_ChatInfo.SendAddonMessage("GBM", "  " .. v.name .. " with " .. tostring(v.redux) .. " correct answers and " .. tostring(v.points) .. " points!", "GUILD");
			end
		elseif msg:match(trigvs[3]) then
			-- the message contains "!answer" keyword
			if lastTriv == 0 then
				C_ChatInfo.SendAddonMessage("GBM", "There are no previous answers registered!", "GUILD");
			else
				C_ChatInfo.SendAddonMessage("GBM", "The answer for \"" ..trivalvs[lastTriv].clue.. "\" was \"" ..trivalvs[lastTriv].answer.. "\"!", "GUILD");
			end
		end
	end
end)