-- This file is loaded from "mailexport.toc"

--Send message to chatlog when Guild Bank is opened
local frame = CreateFrame("Frame")
frame:RegisterEvent("GUILDBANKFRAME_OPENED")
frame:SetScript("OnEvent", function(self, event, ...)
 print("|cffff0000 GuildExport: |r Type |cffffff00 /guildexport |r to export your gbank into CSV format.")
end)

--Create parent frame with default "BasicFrameTemplate" template
local frame = CreateFrame("Frame","GuildExportFrame",UIParent,"BasicFrameTemplate")
frame:SetSize(600,600)
frame:SetPoint("CENTER")
frame:Hide()
--Make this frame close when ESC is hit
tinsert(UISpecialFrames,"GuildExportFrame")

--Create scrollable editbox with default "InputScrollFrameTemplate" template
frame.scrollFrame = CreateFrame("ScrollFrame","GuildExportScrollFrame",frame,"InputScrollFrameTemplate")
frame.scrollFrame:SetPoint("TOPLEFT",8,-30)
frame.scrollFrame:SetPoint("BOTTOMRIGHT",-12,9)

--Set up the editbox defined above
local editBox = frame.scrollFrame.EditBox --Already created in above template
editBox:SetFontObject("ChatFontNormal")
editBox:SetAllPoints(true)
editBox:SetWidth(frame.scrollFrame:GetWidth()) --Multiline editboxes need a width declared!!
--When ESC is hit while editbox has focus, clear focus (a second ESC closes window)
editBox:SetScript("OnEscapePressed",editBox.ClearFocus)

-- set up /guildexport slash command to dump guildbank to editbox
SLASH_GUILDEXPORT1 = "/guildexport"
--SlashCmdList["GUILDEXPORT"] = handler;

function SlashCmdList.GUILDEXPORT(msg)
   local startTab = 0
   local endTab = 0
   
   if msg=="" then
      startTab = 1
      endTab = GetNumGuildBankTabs()
   else
      startTab = tonumber(strsub(msg,1,1))
      endTab = tonumber(strsub(msg,3))
   end

   print("Starting Tab is: "..tostring(startTab))
   print("Ending Tab is : "..tostring(endTab))
  local list = {}
  tinsert(list,"Gold;")
  tinsert(list,GetGuildBankMoney())
  tinsert(list,"\n")
   --for i=1,GetNumGuildBankTabs() do, this line commented out as workaround for selecting specific tabs for export.  TODO: Add way to select tabs to export
   local currentTab = startTab
   while currentTab <= endTab do
    for j=1,(7*14) do
       local tab = currentTab
       local slot = j
       if GetGuildBankItemLink(tab,slot) then
          local itemName = select(1,GetItemInfo(GetGuildBankItemLink(tab,slot)))
          local quantity = select(2,GetGuildBankItemInfo(tab,slot))

          tinsert(list,itemName)
          tinsert(list,";")
          tinsert(list,quantity)
          tinsert(list,"\n")
       end
    end
    currentTab = currentTab+1
 end
  --Send them to editbox
  editBox:SetText(table.concat(list))
  --Show frame and highlight text just added for copy-pasting
  frame:Show()
  editBox:HighlightText()
  editBox:SetFocus(true)
end
