
--[[
Abstract = {"Ability", "Spell", "Trade"}
Armor = {"Belt", "Boots", "Bracer", "Chestpiece", "Gauntlet", "Helmet", "Cape", "Pants", "Shield", "Shirt", "Shoulder" },
Consumeable = {"Herb", "Liquid", "Potion", "Solid" },
Weapons = {"Ammo", "Axe", "Halbard", "Hammer", "Mace", "Ranged", "Spear", "Staff", "Sword", "Wand" }
Professions = {Echancnting
Items = {"Container", "Craft", "Gizmo", "Jewelry", "Misc", "Trophy", "Valuable", "Written" }, keys

new:  Keys
]]
local setup = false;
function GHM_LoadIconList()
	if setup == true then return end
	setup = true;

	GHM_IconCategories = { "Abstract", "Items", "Consumeable", "Professions", "Armor", "Weapons", "Achievement", "Races" }

	GHM_IconSubcategories = {
		Abstract = { "Ability", "Spell", "Trade", "Death Knight","Druid","Hunter","Mage","Monk","Paladin","Priest","Rogue","Shaman","Warlock","Warrior","Racial",},
		Armor = { "Belt", "Boots", "Bracer", "Chestpiece", "Gauntlet", "Helmet", "Cape", "Pants", "Shield", "Shirt", "Shoulder" },
		Consumeable = { "Drinkable", "Potion", "Food" },
		Items = { "Container", "Jewelry", "Misc", "Lights", "Trophy", "Valuable", "Readable", "Keys", "Magical Items", "Banners", "Pets", "Mounts", },
		Weapons = { "Ammo", "Axe", "Polearm", "Hammer", "Mace", "Ranged", "Spear", "Staff", "Sword", "Wand", "Fist", "Knife" },
		Professions = { "Archaeology", "Leatherworking", "Engineering", "Fishing", "Herbalism", "Enchanting", "Tailoring", "First Aid", "Mining", "Jewelcrafting", "Inscription" },
		Achievement = { "Zones", "Arena", "Battleground", "Boss", "Character", "Dungeon", "Misc Achievement", "PvP", "Quest", "Guild" },
		Races = { "Horde", "Alliance" },
	}

	GHM_StockIcons = {}
	
	GHM_StockIcons["Death Knight"] = {
		"ability_deathknight_boneshield",
		"ability_deathknight_brittlebones",
		"ability_deathknight_desolation",
		"ability_deathknight_hemorrhagicfever",
		"ability_deathknight_pillaroffrost",
		"ability_deathknight_runicimpowerment",
		"ability_deathknight_sanguinfortitude",
		"ability_deathknight_summongargoyle",
		"Ability_DeathKnight_AoeDeathGrip", 
		"Ability_DeathKnight_Asphixiate", 
		"Ability_DeathKnight_DeathSiphon", 
		"Ability_DeathKnight_DeathSiphon2", 
		"Ability_DeathKnight_DesecratedGround", 
		"Ability_DeathKnight_IcyGrip", 
		"Ability_DeathKnight_RemorselessWinters", 
		"Ability_DeathKnight_RemorselessWinters2", 
		"Ability_DeathKnight_RoilingBlood", 
		"Ability_DeathKnight_SoulReaper",
		"Spell_DeathKnight_AntiMagicZone",
		"Spell_DeathKnight_ArmyOfTheDead",
		"Spell_DeathKnight_BladedArmor",
		"Spell_DeathKnight_BloodBoil",
		"Spell_DeathKnight_BloodPlague",
		"Spell_Deathknight_BloodPresence",
		"Spell_DeathKnight_BloodTap",
		"Spell_DeathKnight_Butcher",
		"Spell_DeathKnight_Butcher2",
		"Spell_Deathknight_ClassIcon",
		"Spell_DeathKnight_DarkConviction",
		"Spell_Deathknight_DeathStrike",
		"Spell_DeathKnight_EmpowerRuneBlade",
		"Spell_DeathKnight_EmpowerRuneBlade2",
		"Spell_DeathKnight_Explode_Ghoul",
		"Spell_DeathKnight_FrostFever",
		"Spell_Deathknight_FrostPresence",
		"Spell_DeathKnight_FrozenRuneWeapon",
		"Spell_DeathKnight_Gnaw_Ghoul",
		"Spell_DeathKnight_IceBoundFortitude",
		"Spell_DeathKnight_IceTouch",
		"Spell_Deathknight_IcyTalons", -- [991]
		"Spell_DeathKnight_MindFreeze",
		"Spell_DeathKnight_PathOfFrost",
		"Spell_Deathknight_PlagueStrike",
		"Spell_DeathKnight_RuneTap",
		"Spell_DeathKnight_ScourgeStrike",
		"Spell_DeathKnight_SpellDeflection",
		"Spell_DeathKnight_Strangulate",
		"Spell_DeathKnight_Subversion",
		"Spell_DeathKnight_SummonDeathCharger",
		"Spell_DeathKnight_Thrash_Ghoul",
		"Spell_Deathknight_UnholyPresence",
		"Spell_DeathKnight_Vendetta",
		"Spell_DeathKnight_Festering_strike", 	
		"Spell_Deathknight_Breathofsindragosa", 
		"Spell_Deathknight_Defile", 
		"Spell_Deathknight_Necroticplague", 		
	}
	GHM_StockIcons["Druid"] = {
		"Spell_Druid_feralchargecat",
		"spell_druid_stamedingroar",
		"spell_druid_thrash",
		"spell_druid_wildmushroom",
		"Spell_druid_astralstorm", 
		"Spell_druid_bearhug", 
		"Spell_druid_displacement", 
		"Spell_druid_incarnation", 
		"Spell_druid_ironbark", 
		"Spell_druid_massentanglement", 
		"Spell_druid_mightofursoc", 
		"Spell_druid_swarm", 
		"Spell_druid_symbiosis", 
		"Spell_druid_tirelesspursuit", 
		"Spell_druid_ursolsvortex", 
		"Spell_druid_wildburst", 
		"Spell_druid_wildcharge", 
		"Spell_druid_wildmushroom_bloom", 
		"Spell_druid_wildmushroom_frenzy",
		"Ability_Druid_AquaticForm",
		"Ability_Druid_AstralStorm",
		"Ability_Druid_BalanceofPower",
		"Ability_Druid_Bash",
		"Ability_Druid_Berserk",
		"Ability_Druid_CatForm",
		"Ability_Druid_CatFormAttack",
		"Ability_Druid_ChallangingRoar",
		"Ability_Druid_Cower",
		"Ability_Druid_Cyclone",
		"Ability_Druid_Dash",
		"ABILITY_DRUID_DEMORALIZINGROAR",
		"Ability_Druid_Disembowel",
		"Ability_Druid_Dreamstate",
		"Ability_Druid_EarthandSky",
		"Ability_Druid_Eclipse",
		"Ability_Druid_EclipseOrange",
		"Ability_Druid_EmpoweredRejuvination",
		"Ability_Druid_EmpoweredTouch",
		"Ability_Druid_Enrage",
		"Ability_Druid_FerociousBite",
		"Ability_Druid_FlightForm",
		"Ability_Druid_Flourish",
		"Ability_Druid_ForceofNature",
		"Ability_Druid_GaleWinds",
		"Ability_Druid_GiftoftheEarthmother",
		"Ability_Druid_HealingInstincts",
		"Ability_Druid_ImprovedMoonkinForm",
		"Ability_Druid_ImprovedTreeForm",
		"Ability_Druid_InfectedWound",
		"Ability_Druid_KingoftheJungle",
		"Ability_Druid_Lacerate",
		"Ability_Druid_LunarGuidance",
		"Ability_Druid_ManaTree",
		"Ability_Druid_Mangle",
		"Ability_Druid_Mangle2",
		"Ability_Druid_MasterShapeshifter",
		"Ability_Druid_Maul",
		"Ability_Druid_NaturalPerfection",
		"Ability_Druid_Nourish",
		"Ability_Druid_OwlkinFrenzy",
		"Ability_Druid_PredatoryInstincts",
		"Ability_Druid_PrimalAgression",
		"Ability_Druid_PrimalPrecision",
		"Ability_Druid_PrimalTenacity",
		"Ability_Druid_Prowl",
		"Ability_Druid_Rake",
		"Ability_Druid_Ravage",
		"Ability_Druid_Replenish",
		"Ability_Druid_SkinTeeth",
		"Ability_Druid_Starfall",
		"Ability_Druid_SupriseAttack",
		"Ability_Druid_Swipe",
		"Ability_Druid_TigersRoar",
		"Ability_Druid_TravelForm",
		"Ability_Druid_TreeofLife",
		"Ability_Druid_TwilightsWrath",
		"Ability_Druid_Typhoon",
		 "Ability_Druid_StellarFlare", 
		"Spell_Druid_BloodyThrash", 
		"Spell_Druid_BristlingFur", 
		"Spell_Druid_Equinox", 
		"Spell_Druid_Germination", 
		"Spell_Druid_Germination_Rejuvenation", 
		"Spell_Druid_GuardianofElune", 
		"Spell_Druid_LunarInspiration", 
		"Spell_Druid_MalfurionsTenacity", 
		"Spell_Druid_MomentofClarity", 
		"Spell_Druid_PrimalTenacity", 
		"Spell_Druid_RampantGrowth", 
		"Spell_Druid_Savagery", 
		"Spell_Druid_Sunfall", 
	}
	GHM_StockIcons["Hunter"] = {
		"Spell_Hunter_AspectOfTheHawk", 
		"Spell_Hunter_AspectOfTheIronHawk", 
		"Spell_Hunter_BlackIceTrap", 
		"Spell_Hunter_IceTrap",
		"Ability_Hunter_AimedShot",
		"Ability_Hunter_AnimalHandler",
		"Ability_Hunter_AspectMastery",
		"Ability_Hunter_AspectoftheFox",
		"Ability_Hunter_AspectOfTheMonkey",
		"Ability_Hunter_AspectoftheViper",
		"Ability_Hunter_Assassinate",
		"Ability_Hunter_Assassinate2",
		"Ability_Hunter_BeastCall",
		"Ability_Hunter_BeastCall02",
		"Ability_Hunter_BeastMastery",
		"Ability_Hunter_BeastSoothe",
		"Ability_Hunter_BeastTaming",
		"Ability_Hunter_BeastTraining",
		"Ability_Hunter_BeastWithin",
		"ability_hunter_bestialdiscipline",
		"Ability_Hunter_Camouflage",
		"Ability_Hunter_CatlikeReflexes",
		"Ability_Hunter_ChimeraShot2",
		"ability_hunter_cobrashot",
		"Ability_Hunter_CobraStrikes",
		"Ability_Hunter_CombatExperience",
		"Ability_Hunter_CriticalShot",
		"Ability_Hunter_DisarmingShot",
		"Ability_Hunter_Displacement",
		"Ability_Hunter_EagleEye",
		"ability_hunter_efficiency",
		"ability_hunter_efficiency_brown",
		"Ability_Hunter_ExplosiveShot",
		"Ability_Hunter_FerociousInspiration",
		"Ability_Hunter_FocusedAim",
		"Ability_Hunter_Fervor",
		"ability_hunter_focusfire",
		"Ability_Hunter_GoForTheThroat",
		"Ability_Hunter_Harass",
		"Ability_Hunter_HunterVsWild",
		"Ability_Hunter_HuntingParty",
		"Ability_Hunter_ImprovedSteadyShot",
		"Ability_Hunter_ImprovedTracking",
		"Ability_Hunter_Invigeration",
		"Ability_Hunter_KillCommand",
		"Ability_Hunter_LockAndLoad",
		"Ability_Hunter_Longevity",
		"Ability_Hunter_LongShots",
		"Ability_Hunter_MarkedForDeath",
		"Ability_Hunter_MasterMarksman",
		"Ability_Hunter_MastersCall",
		"Ability_Hunter_MasterTactitian",
		"Ability_Hunter_MendPet",
		"Ability_Hunter_Misdirection",
		"ability_hunter_onewithnature",
		"Ability_Hunter_Pathfinding",
		"ability_hunter_pathfinding2",
		"Ability_Hunter_Pet_Assist",
		"Ability_Hunter_Pet_Bat",
		"Ability_Hunter_Pet_Bear",
		"Ability_Hunter_Pet_Boar",
		"Ability_Hunter_Pet_Cat",
		"Ability_Hunter_Pet_Chimera",
		"Ability_Hunter_Pet_CoreHound",
		"Ability_Hunter_Pet_Crab",
		"Ability_Hunter_Pet_Crocolisk",
		"Ability_Hunter_Pet_Devilsaur",
		"Ability_Hunter_Pet_DragonHawk",
		"Ability_Hunter_Pet_Gorilla",
		"ability_hunter_pet_goto",
		"Ability_Hunter_Pet_Hyena",
		"Ability_Hunter_Pet_Moth",
		"Ability_Hunter_Pet_NetherRay",
		"Ability_Hunter_Pet_Owl",
		"Ability_Hunter_Pet_Raptor",
		"Ability_Hunter_Pet_Ravager",
		"Ability_Hunter_Pet_Rhino",
		"Ability_Hunter_Pet_Scorpid",
		"Ability_Hunter_Pet_Silithid",
		"Ability_Hunter_Pet_Spider",
		"Ability_Hunter_Pet_Sporebat",
		"Ability_Hunter_Pet_TallStrider",
		"Ability_Hunter_Pet_Turtle",
		"Ability_Hunter_Pet_Vulture",
		"Ability_Hunter_Pet_WarpStalker",
		"Ability_Hunter_Pet_Wasp",
		"Ability_Hunter_Pet_WindSerpent",
		"Ability_Hunter_Pet_Wolf",
		"Ability_Hunter_Pet_Worm",
		"Spell_Beastmaster_clefthoof", 
		"Spell_Beastmaster_Elekk", 
		"Spell_Beastmaster_Rylak", 
		"Spell_Beastmaster_wolf", 
		"Ability_Hunter_PiercingShots",
		"Ability_Hunter_PointofNoEscape",
		"ability_hunter_posthaste",
		"Ability_Hunter_PotentVenom",
		"Ability_Hunter_Quickshot",
		"Ability_Hunter_RapidKilling",
		"Ability_Hunter_RapidRegeneration",
		"Ability_Hunter_Readiness",
		"ability_hunter_resistanceisfutile",
		"Ability_Hunter_Resourcefulness",
		"Ability_Hunter_RunningShot",
		"Ability_Hunter_SeparationAnxiety",
		"Ability_Hunter_SerpentSwiftness",
		"ability_hunter_sickem",
		"Ability_Hunter_SilentHunter",
		"Ability_Hunter_SnakeTrap",
		"Ability_Hunter_SniperShot",
		"Ability_Hunter_SniperTraining",
		"Ability_Hunter_SteadyShot",
		"Ability_Hunter_SurvivalInstincts",
		"Ability_Hunter_SwiftStrike",
		"Ability_Hunter_ThrilloftheHunt",
		"ability_hunter_traplauncher",
		"Ability_Hunter_WildQuiver",
		"Ability_Hunter_ZenArchery",
		"Ability_GlaiveToss", 
		"Ability_Hunter_AspectoftheIronHawk", 
		"Ability_Hunter_BlackIceTrap", 
		"Ability_Hunter_Blindingshot", 
		"Ability_Hunter_Crossfire", 
		"Ability_Hunter_GlacialTrap", 
		"Ability_Hunter_MurderofCrows",
		"Spell_Hunter_Adaptation", 
		"Spell_Hunter_ExoticMunitions_Frozen", 
		"Spell_Hunter_ExoticMunitions_Incendiary", 
		"Spell_Hunter_ExoticMunitions_Poisoned", 
		"Spell_Hunter_FocusingShot", 
		"Spell_Hunter_LoneWolf", 
	}
	GHM_StockIcons["Mage"] = {
		"ABILITY_MAGE_INVISIBILITY",
		"ABILITY_MAGE_MOLTENARMOR",
		"Spell_Arcane_Blast",
		"Spell_Arcane_Blink",
		"Spell_MageArmor",
		"spell_mage_curtainoffrost",
		"spell_mage_flameorb",
		"Spell_Mage_AlterTime", 
		"Spell_Mage_ConjuredManaBuns", 
		"Spell_Mage_ConjuredManaPudding", 
		"Spell_Mage_FrostBomb", 
		"Spell_Mage_IceFlows", 
		"Spell_Mage_InfernoBlast", 
		"spell_Mage_NetherTempest", 
		"Spell_Mage_PresenceOfMind", 
		"Spell_Mage_RuneOfPower", 
		"Spell_Mage_TemporalShield",
		"Ability_Mage_ArcaneBarrage",
		"Ability_Mage_BrainFreeze",
		"Ability_Mage_Burnout",
		"Ability_Mage_ChilledToTheBone",
		"Ability_Mage_ColdAsIce",
		"Ability_Mage_ConjureFoodRank10",
		"Ability_Mage_ConjureFoodRank12",
		"Ability_Mage_ConjureFoodRank9",
		"Ability_Mage_ConjureWater11",
		"Ability_Mage_DeepFreeze",
		"Ability_Mage_FieryPayback",
		"Ability_Mage_FireStarter",
		"Ability_Mage_FrostFireBolt",
		"Ability_Mage_HotStreak",
		"Ability_Mage_IncantersAbsorbtion",
		"Ability_Mage_Invisibility",
		"Ability_Mage_LivingBomb",
		"Ability_Mage_MissileBarrage",
		"Ability_Mage_MoltenArmor",
		"Ability_Mage_NetherWindPresence",
		"Ability_Mage_PotentSpirit",
		"Ability_Mage_ShatterShield",
		"Ability_Mage_StudentOfTheMind",
		"ability_mage_timewarp",
		"Ability_Mage_TormentOfTheWeak",
		"Ability_Mage_WintersGrasp",
		"Ability_Mage_WorldInFlames",
		"Ability_mage_worldinflamesgreen",
		"Ability_Mage_FrostJaw", 
		"ability_mage_GreaterInvisibility", 
		"Ability_Mage_ImprovedPolymorph",
		"Spell_Arcane_PortalDalaran",
		"Spell_Arcane_PortalDarnassus",
		"Spell_Arcane_PortalExodar",
		"Spell_Arcane_PortalIronForge",
		"Spell_Arcane_PortalOrgrimmar",
		"Spell_Arcane_PortalShattrath",
		"Spell_Arcane_PortalSilvermoon",
		"Spell_Arcane_PortalStonard",
		"Spell_Arcane_PortalStormWind",
		"Spell_Arcane_PortalTheramore",
		"Spell_Arcane_PortalThunderBluff",
		"Spell_Arcane_PortalTolBarad",
		"Spell_Arcane_PortalUnderCity",
		"Spell_Arcane_PortalDalaranCrater", 
		"Spell_Arcane_TeleportDalaranCrater",
		"Spell_Arcane_PrismaticCloak",
		"Spell_Arcane_Rune", -- [990]
		"Spell_Arcane_StarFire",
		"Spell_Arcane_StudentOfMagic",
		"Spell_Arcane_TeleportDalaran",
		"Spell_Arcane_TeleportDarnassus",
		"Spell_Arcane_TeleportExodar",
		"Spell_Arcane_TeleportIronForge",
		"Spell_Arcane_TeleportMoonglade",
		"Spell_Arcane_TeleportOrgrimmar",
		"Spell_Arcane_TeleportShattrath",
		"Spell_Arcane_TeleportSilvermoon",
		"Spell_Arcane_TeleportStonard",
		"Spell_Arcane_TeleportStormWind",
		"Spell_Arcane_TeleportTheramore",
		"Spell_Arcane_TeleportThunderBluff",
		"spell_arcane_teleporttolbarad",
		"Spell_Arcane_TeleportUnderCity",
		"Spell_Fire_BurningSpeed",
		"Spell_Fire_FireArmor",
		"Spell_Fire_Fireball",
		"Spell_Fire_Fireball02",
		"spell_burningsoul",
		"spell_firefrost orb",
		"Spell_Frost_FrozenOrb",
		"Spell_Frost_FrostArmor",
		"Spell_Frost_FrostArmor02",
		"Spell_Frost_Frostbolt",
		"Spell_Frost_FrostBolt02",
		"Spell_Frost_FrostNova",
		"Spell_Frost_FrostWard",
		"Spell_Frost_FrozenCore",
		"Spell_Frost_Ring of Frost",
		"Spell_Frost_SummonWaterElemental",
		"Spell_Frost_SummonWaterElemental_2",
		"Spell_Mage_AlterTime_Active", 
		"Spell_Mage_ArcaneOrb", 
		"Spell_Mage_CometStorm", 
		"Spell_Mage_Evanesce", 
		"Spell_Mage_FocusingCrystal", 
		"Spell_Mage_IceNova", 
		"Spell_Mage_Kindling", 
		"Spell_Mage_Meteor", 
		"Spell_Mage_Overpowered", 
		"Spell_Mage_Supernova", 
		"Spell_Mage_ThermalVoid", 
		"Spell_Mage_UnstableMagic", 
	}
	GHM_StockIcons["Monk"] = {
		"Spell_Monk_BrewmasterTraining", 
		"Spell_Monk_Brewmaster_Spec", 
		"Spell_Monk_MistWeaver_Spec", 
		"Spell_Monk_WindWalker_Spec",
		"Passive_Monk_TeachingsofMonastery",
		"Ability_Monk_ZenFlight",
		"Ability_Monk_Ascension", 
		"ability_monk_BlackoutKick", 
		"Ability_monk_BoughStrike", 
		"Ability_Monk_BreathofFire", 
		"Ability_Monk_ChargingOxWave", 
		"ability_Monk_ChiBrew", 
		"Ability_Monk_ChiCocoon", 
		"Ability_Monk_ChiWave", 
		"Ability_Monk_ClashingOxCharge", 
		"Ability_Monk_CracklingJadeLightning", 
		"ability_monk_cranekick", 
		"Ability_Monk_CraneKick_New", 
		"Ability_Monk_DampenHarm", 
		"Ability_Monk_DeadlyReach", 
		"ability_monk_dpsstance", 
		"ability_monk_dragonkick", 
		"Ability_Monk_DrunkenHaze", 
		"Ability_Monk_ElusiveAle", 
		"Ability_Monk_EnergizingWine", 
		"Ability_Monk_ExpelHarm", 
		"Ability_Monk_ExplodingJadeBlossom", 
		"Ability_Monk_FlyingDragonKick", 
		"Ability_Monk_ForceSphere", 
		"Ability_Monk_FortifyingAle", 
		"Ability_Monk_FortifyingAle_New", 
		"Ability_Monk_Guard", 
		"Ability_Monk_HealthSphere", 
		"ability_monk_Jab", 
		"Ability_Monk_JasmineForceTea", 
		"Ability_Monk_LeeroftheOx", 
		"Ability_Monk_LegacyOfTheEmperor", 
		"Ability_Monk_LegSweep", 
		"ability_monk_PalmStrike", 
		"Ability_Monk_Paralysis", 
		"Ability_Monk_PowerStrikes", 
		"Ability_Monk_PrideOfTheTiger", 
		"Ability_Monk_Provoke", 
		"ability_Monk_QuiPunch", 
		"ability_monk_QuiTornado", 
		"Ability_Monk_RenewingMists", 
		"Ability_Monk_RisingSunKick", 
		"ability_monk_roll", 
		"ability_monk_roundhousekick", 
		"Ability_Monk_RushingJadeWind", 
		"Ability_Monk_Shuffle", 
		"Ability_Monk_SoothingMists", 
		"Ability_Monk_Sparring", 
		"Ability_Monk_SpearHand", 
		"ability_monk_staffstrike", 
		"ability_monk_standingkick", 
		"Ability_Monk_SummonSerpentStatue", 
		"Ability_Monk_SummonTigerStatue", 
		"Ability_Monk_SurgingMist", 
		"Ability_Monk_ThunderFocusTea", 
		"Ability_Monk_TigereyeBrandy", 
		"Ability_Monk_TigerPalm", 
		"Ability_Monk_TigersLust", 
		"Ability_Monk_TouchOfDeath", 
		"Ability_Monk_TouchofKarma", 
		"Ability_Monk_Uplift", 
		"Ability_Monk_ZenMeditation", 
		"Monk_Ability_AvertHarm", 
		"Monk_Ability_CherryManaTea", 
		"Monk_Ability_FistofFury", 
		"Monk_Ability_SummonOxStatue", 
		"Monk_Ability_Transcendence", 
		"Monk_Stance_DrunkenOx", 
		"Monk_Stance_WhiteTiger", 
		"Monk_Stance_WiseSerpent",
		"Monk_Stance_RedCrane",		
		"ABILITY_MONK_CHIEXPLOSION", 
		"ABILITY_MONK_CHISWIRL", 
		"ABILITY_MONK_HURRICANESTRIKE", 
		"ABILITY_MONK_JADESERPENTBREATH", 
		"ABILITY_MONK_PATHOFMISTS", 
		"ABILITY_MONK_SERENITY", 
		"ABILITY_MONK_SOULDANCE", 
		 "Spell_Monk_Revival",
	}
	GHM_StockIcons["Paladin"] = {
		"spell_paladin_divinecircle",
		"Spell_Paladin_ExecutionSentence", 
		"Spell_Paladin_HammerOfWrath", 
		"Spell_Paladin_HolyPrism", 
		"spell_Paladin_LightsHammer",
		"Ability_Paladin_ArtofWar",
		"Ability_Paladin_BeaconofLight",
		"Ability_Paladin_BlessedHands",
		"Ability_Paladin_BlessedMending",
		"ability_paladin_conviction",
		"Ability_Paladin_DivineStorm",
		"Ability_Paladin_EnlightenedJudgements",
		"Ability_Paladin_GaurdedbytheLight",
		"Ability_Paladin_HammeroftheRighteous",
		"Ability_Paladin_InfusionofLight",
		"Ability_Paladin_JudgementBlue",
		"Ability_Paladin_JudgementofthePure",
		"Ability_Paladin_JudgementoftheWise",
		"Ability_Paladin_JudgementRed",
		"Ability_Paladin_JudgementsoftheJust",
		"ability_paladin_protectoroftheinnocent",
		"Ability_Paladin_RighteousVengeance",
		"Ability_Paladin_SacredCleansing",
		"Ability_Paladin_SanctifiedWrath",
		"Ability_Paladin_SheathofLight",
		"Ability_Paladin_ShieldoftheTemplar",
		"Ability_Paladin_ShieldofVengeance",
		"Ability_Paladin_SwiftRetribution",
		"Ability_Paladin_TouchedbyLight",
		 "Ability_Paladin_BlindingLight", 
		"Ability_Paladin_BlindingLight2", 
		"ability_Paladin_Clemency", 
		"Ability_Paladin_HolyAvenger", 
		"Ability_Paladin_LongArmoftheLaw", 
		"Ability_Paladin_SelflessHealer", 
		"Ability_Paladin_SpeedofLight", 
		"Ability_Paladin_TurnEvil", 
		"ability_Paladin_Veneration",
		"Paladin_Protection", 
		"Paladin_Retribution",
		"paladin_icon_speedoflight",
		 "Ability_Paladin_BeaconOfInsight", 
		"Ability_Paladin_BeaconsOfLight", 
		"Ability_Paladin_EmpoweredSeals", 
		"Ability_Paladin_EmpoweredSealsInsight", 
		"Ability_Paladin_EmpoweredSealsJustice", 
		"Ability_Paladin_EmpoweredSealsRighteous", 
		"Ability_Paladin_EmpoweredSealsTruth", 
		"Ability_Paladin_FinalVerdict", 
		"Ability_Paladin_SavedByTheLight", 
		"Ability_Paladin_Seraphim", 
	}
	GHM_StockIcons["Priest"] = {
		"priest_icon_chakra",
		"priest_icon_chakra_blue",
		"priest_icon_chakra_green",
		"priest_icon_chakra_red",
		"priest_icon_innewill",
		"priest_spell_leapoffaith_a",
		"priest_spell_leapoffaith_b",
		"spell_priest_mindspike",
		"spell_priest_shadoworbs",
		"Spell_Priest_AngelicBulwark", 
		"Spell_Priest_BurningWill", 
		"Spell_Priest_DivineStar", 
		"Spell_Priest_DivineStar_Holy", 
		"Spell_Priest_DivineStar_Shadow", 
		"Spell_Priest_DivineStar_Shadow2", 
		"Spell_Priest_FinalPrayer", 
		"Spell_Priest_PathofDevout", 
		"SPELL_PRIEST_PSYFIEND", 
		"Spell_Priest_VoidShift", 
		"SPELL_PRIEST_VOIDTENDRILS", 
		"Spell_Priest_VowofUnity",
		"ability_priest_archangel",
		"ability_priest_atonement",
		"ability_priest_bindingprayers",
		"ability_priest_darkness",
		"ability_priest_evangelism",
		"ability_priest_focusedwill",
		"ability_priest_heavanlyvoice",
		"ability_priest_reflectiveshield",
		"ability_priest_shadowyapparition",
		"Ability_Priest_AngelicBulwark", 
		"Ability_Priest_AngelicFeather", 
		"Ability_Priest_Cascade", 
		"Ability_Priest_Cascade_Shadow", 
		"Ability_Priest_Flashoflight", 
		"Ability_Priest_Halo", 
		"Ability_Priest_Halo_Shadow", 
		"Ability_Priest_PathofTheDevout", 
		"Ability_Priest_Phantasm", 
		"Ability_Priest_SurgeOfDarkness", 
		"Ability_Priest_VoidShift", 
		"ability_priest_silence",
		"ability_priest_soulwarding",
		"Ability_Priest_Ascendance", 
		"Ability_Priest_Ascension", 
		"Ability_Priest_AuspiciousSpirits", 
		"Ability_Priest_ClarityofPower", 
		"Ability_Priest_ClarityofPurpose", 
		"Ability_Priest_ClarityofWill", 
		"Ability_Priest_HolyBolts01", 
		"Ability_Priest_SavingGrace", 
		"Ability_Priest_VoidEntropy", 
		"Ability_Priest_WordsofMeaning", 
	}
	GHM_StockIcons["Rogue"] = {
		"Ability_Rogue_Ambush",
		"ability_rogue_blackjack",
		"Ability_Rogue_BladeTwisting",
		"Ability_Rogue_BloodSplatter",
		"Ability_Rogue_BloodyEye",
		"Ability_Rogue_CheatDeath",
		"ability_rogue_combatexpertise",
		"ability_rogue_combatexpertisetga",
		"ability_rogue_combatreadiness",
		"Ability_Rogue_CutToTheChase",
		"Ability_Rogue_DeadenedNerves",
		"ability_rogue_deadliness",
		"Ability_Rogue_DeadlyBrew",
		"ability_rogue_deadlymomentum",
		"Ability_Rogue_DeviousPoisons",
		"ability_rogue_dirtydeeds",
		"Ability_Rogue_Disembowel",
		"Ability_Rogue_Disguise",
		"Ability_Rogue_Dismantle",
		"Ability_Rogue_Distract",
		"Ability_Rogue_DualWeild",
		"Ability_Rogue_EnvelopingShadows",
		"Ability_Rogue_Eviscerate",
		"Ability_Rogue_FanofKnives",
		"Ability_Rogue_FeignDeath",
		"Ability_Rogue_Feint",
		"Ability_Rogue_FindWeakness",
		"Ability_Rogue_FleetFooted",
		"Ability_Rogue_FocusedAttacks",
		"Ability_Rogue_Garrote",
		"Ability_Rogue_HonorAmongstThieves",
		"Ability_Rogue_HungerforBlood",
		"ability_rogue_improvedrecuperate",
		"ability_rogue_imrovedrecuperate",
		"Ability_Rogue_KidneyShot",
		"Ability_Rogue_MasterOfSubtlety",
		"Ability_Rogue_MurderSpree",
		"Ability_Rogue_NervesOfSteel",
		"ability_rogue_preparation",
		"Ability_Rogue_PreyontheWeak",
		"Ability_Rogue_QuickRecovery",
		"ability_rogue_recuperate",
		"ability_rogue_redirect",
		"ability_rogue_reinforcedleather",
		"ability_rogue_restlessblades",
		"Ability_Rogue_Rupture",
		"ability_rogue_ruthlessness",
		"ability_rogue_sanguinaryvein",
		"ability_rogue_sealfate",
		"Ability_Rogue_ShadowDance",
		"Ability_Rogue_Shadowstep",
		"Ability_Rogue_ShadowStrikes",
		"Ability_Rogue_SinisterCalling",
		"Ability_Rogue_SlaughterfromtheShadows",
		"Ability_Rogue_SliceDice",
		"ability_rogue_smoke",
		"Ability_Rogue_Sprint",
		 "Ability_Rogue_Sprint_Blue", 
		"Ability_Rogue_StayofExecution",
		"ability_rogue_sturdyrecuperate",
		"Ability_Rogue_SurpriseAttack",
		"Ability_Rogue_ThrowingSpecialization",
		"Ability_Rogue_TricksOftheTrade",
		"Ability_Rogue_Trip",
		"Ability_Rogue_TurntheTables",
		"Ability_Rogue_UnfairAdvantage",
		"ability_rogue_vendetta",
		"ability_rogue_venomouswounds",
		"ability_rogue_vigor",
		"Ability_Rogue_Waylay",
		"Ability_Rogue_WrongfullyAccused",
		"Ability_Rogue_ShroudOfConcealment", 
		"Ability_Rogue_SurpriseAttack2", 
		"Ability_Rogue_Versatility", 
		"Rogue_BurstofSpeed", 
		"Rogue_DirtyTricks", 
		"Rogue_Leeching_Poison", 
		"Rogue_Nerve _Strike", 
		"Rogue_Paralytic_Poison", 
		"Rogue_ShadowFocus", 
		"Rogue_Subterfuge", 
		"Ability_Sap",
		"Rogue_VenomZest", 
		"Spell_Rogue_DeathFromAbove", 
		"Spell_Rogue_Shadow_Reflection", 
	}
	GHM_StockIcons["Shaman"] = {
		"Spell_Shaman_AncestralAwakening",
		"Spell_Shaman_AstralShift",
		"spell_shaman_bindelemental",
		"Spell_Shaman_BlessingOfEternals",
		"Spell_Shaman_BlessingOfTheEternals",
		"spell_shaman_convection",
		"Spell_Shaman_Dropall_01",
		"Spell_Shaman_Dropall_02",
		"Spell_Shaman_Dropall_03",
		"Spell_Shaman_EarthlivingWeapon",
		"spell_shaman_earthquake",
		"Spell_Shaman_ElementalOath",
		"Spell_Shaman_FeralSpirit",
		"spell_shaman_firenova",
		"spell_shaman_focusedstrikes",
		"Spell_Shaman_GiftEarthmother",
		"Spell_Shaman_Hex",
		"Spell_Shaman_ImprovedEarthShield",
		"spell_shaman_improvedfirenova",
		"spell_shaman_improvedreincarnation",
		"Spell_Shaman_ImprovedStormstrike",
		"spell_shaman_improvelavalash",
		"Spell_Shaman_LavaBurst",
		"Spell_Shaman_LavaFlow",
		"spell_shaman_lavasurge",
		"Spell_Shaman_MaelstromWeapon",
		"spell_shaman_measuredinsight",
		"spell_shaman_primalstrike",
		"Spell_Shaman_SpectralTransformation",
		"Spell_Shaman_SpiritLink",
		"spell_shaman_spiritwalkersgrace",
		"Spell_Shaman_StaticShock",
		"Spell_Shaman_StormEarthFire",
		"Spell_Shaman_ThunderStorm",
		"Spell_Shaman_TidalWaves",
		"Spell_Shaman_TotemRecall",
		"spell_shaman_unleashweapon_earth",
		"spell_shaman_unleashweapon_frost",
		"spell_shaman_unleashweapon_life",
		"spell_shaman_unleashweapon_wind",
		"Ability_Shaman_CleanseSpirit",
		"Ability_Shaman_Heroism",
		"Ability_Shaman_Lavalash",
		"Ability_Shaman_Stormstrike",
		"Ability_Shaman_WaterShield",
		"Ability_Shaman_AncestralGuidance", 
		"Ability_Shaman_Ascendance", 
		"Ability_Shaman_AstralShift", 
		"Ability_Shaman_EchooftheElements", 
		"Ability_Shaman_FortifyingWaters", 
		"Ability_Shaman_FreedomWolf", 
		"Ability_Shaman_HealingTide", 
		"Ability_Shaman_MultiTotemActivation", 
		"Ability_Shaman_RepulsionTotem", 
		"Ability_Shaman_StoneBulwark", 
		"Ability_Shaman_TotemCooldownRefund", 
		"Ability_Shaman_TotemRelocation", 
		"Ability_Shaman_TranquilMindTotem", 
		"Ability_Shaman_WindwalkTotem", 
		 "Ability_Shaman_CondensationTotem",
		"Spell_Shaman_HighTide", 
		"Spell_Shaman_ShockingLava", 
		"Spell_Shaman_SpewLava", 
		"Spell_Shaman_StormTotem", 
	}
	GHM_StockIcons["Warlock"] = {
		"ability_warlock_ancientgrimoire",
		"Ability_Warlock_Avoidance",
		"Ability_Warlock_Backdraft",
		"ability_warlock_baneofhavoc",
		"Ability_Warlock_ChaosBolt",
		"ability_warlock_cremation",
		"ability_warlock_darkarts",
		"Ability_Warlock_DemonicEmpowerment",
		"Ability_Warlock_DemonicPower",
		"Ability_Warlock_EmpoweredImp",
		"Ability_Warlock_Eradication",
		"Ability_Warlock_EverlastingAffliction",
		"Ability_Warlock_FireandBrimstone",
		"Ability_Warlock_Haunt",
		"Ability_Warlock_ImprovedDemonicTactics",
		"Ability_Warlock_ImprovedSoulLeech",
		"ability_warlock_inferno",
		"ability_warlock_jinx",
		"Ability_Warlock_MoltenCore",
		"Ability_Warlock_ShadowFlame",
		"ability_warlock_soulsiphon",
		"ability_warlock_Coil2", 
		"ability_warlock_Coil3", 
		"ability_warlock_handofguldan", 
		"Ability_warlock_HowlofTerror", 
		"ability_warlock_MortalCoil", 
		"ability_warlock_shadowfurytga", 
		"ability_warlock_SoulLink",
		"Warlock_ Bloodstone", 
		"Warlock_ Healthstone", 
		"Warlock_Curse_Shadow", 
		"Warlock_Curse_Shadow_Aura", 
		"Warlock_Curse_Weakness", 
		"Warlock_Curse_Weakness_Aura", 
		"Warlock_GrimoireofCommand", 
		"Warlock_GrimoireofSacrifice", 
		"Warlock_GrimoireofService", 
		"Warlock_HourOfTwilight",
		"Warlock_Sacrificial_Pact",
		"Warlock_SiphonLife",
		"Warlock_SpellDrain",
		"Warlock_Summon_ Beholder",
		"Warlock_Summon_ Shivan",
		"Warlock_Summon_ Voidlord",
		"Warlock_Summon_DoomGuard",
		"spell_warlock_demonsoul",
		"spell_warlock_focusshadow",
		"spell_warlock_soulburn",
		"Spell_Warlock_DarkRegeneration",
		"Spell_Warlock_DemonicPortal_Green",
		"Spell_Warlock_DemonicPortal_Purple",
		"Spell_Warlock_HarvestofLife",
		"Spell_Warlock_SummonAbyssal",
		"Spell_Warlock_SummonImpOutland",
		"Spell_Warlock_SummonTerrorGuard",
		"Spell_Warlock_SummonWrathguard",
		"Spell_Fire_FelFire",
		"Spell_Fire_FelFireNova",
		"Spell_Fire_FelFireward",
		"Spell_Fire_FelFlameBolt",
		"Spell_Fire_FelFlameBreath",
		"Spell_Fire_FelFlameRing",
		"Spell_Fire_FelFlameStrike",
		"Spell_Fire_FelHellfire",
		"Spell_Fire_FelImmolation",
		"Spell_Fire_FelPyroblast",
		"Spell_Fire_FelRainOfFire",
		"Spell_Fire_FireBolt",
		"Spell_Fire_FireBolt02",
		"Spell_Fire_Immolation",
		"Spell_Fire_Incinerate",	
		"Spell_Warlock_Demonbolt", 
		"Spell_Warlock_DemonicServitude", 
		"Spell_Warlock_Soulburn_Haunt", 
		"Spell_Warrior_GladiatorStance", 
		"Warlock_CharredRemains", 
				
	}
	GHM_StockIcons["Warrior"] = {
		"warrior_talent_icon_blitz",
		"warrior_talent_icon_bloodandthunder",
		"warrior_talent_icon_deadlycalm",
		"warrior_talent_icon_furyintheblood",
		"warrior_talent_icon_innerrage",
		"warrior_talent_icon_lambstotheslaughter",
		"warrior_talent_icon_mastercleaver",
		"warrior_talent_icon_singlemindedfury",
		"warrior_talent_icon_skirmisher",
		"warrior_talent_icon_thunderstruck",
		"Spell_warrior_wildstrike",
		"Ability_Warrior_BattleShout",
		"Ability_Warrior_Bladestorm",
		"Ability_Warrior_BloodBath",
		"Ability_Warrior_BloodFrenzy",
		"Ability_Warrior_BloodNova",
		"Ability_Warrior_Bloodsurge",
		"Ability_Warrior_BullRush",
		"Ability_Warrior_Challange",
		"Ability_Warrior_Charge",
		"Ability_Warrior_Cleave",
		"Ability_Warrior_CommandingShout",
		"Ability_Warrior_CriticalBlock",
		"Ability_Warrior_DecisiveStrike",
		"Ability_Warrior_DefensiveStance",
		"Ability_Warrior_Devastate",
		"Ability_Warrior_Disarm",
		"Ability_Warrior_EndlessRage",
		"Ability_Warrior_FocusedRage",
		"Ability_Warrior_FuriousResolve",
		"Ability_Warrior_ImprovedDisciplines",
		"Ability_Warrior_Incite",
		"Ability_Warrior_InnerRage",
		"Ability_Warrior_IntensifyRage",
		"Ability_Warrior_Intervene",
		"Ability_Warrior_OffensiveStance",
		"Ability_Warrior_PunishingBlow",
		"Ability_Warrior_RallyingCry",
		"Ability_Warrior_Rampage",
		"Ability_Warrior_Revenge",
		"Ability_Warrior_Riposte",
		"Ability_Warrior_Safeguard",
		"Ability_Warrior_SavageBlow",
		"Ability_Warrior_SecondWind",
		"Ability_Warrior_ShatteringThrow", -- [43]
		"Ability_Warrior_ShieldBash",
		"Ability_Warrior_ShieldBreak",
		"Ability_Warrior_ShieldGuard",
		"Ability_Warrior_ShieldMastery",
		"Ability_Warrior_ShieldReflection",
		"Ability_Warrior_ShieldWall",
		"Ability_Warrior_Shockwave",
		"Ability_Warrior_StalwartProtector",
		"Ability_Warrior_StrengthOfArms",
		"Ability_Warrior_Sunder",
		"Ability_Warrior_SwordandBoard",
		"ability_warrior_throwdown",
		"ability_warrior_throwdown_2",
		"Ability_Warrior_TitansGrip",
		"Ability_Warrior_Trauma",
		"Ability_Warrior_UnrelentingAssault",
		"Ability_Warrior_VictoryRush",
		"Ability_Warrior_Vigilance",
		"Ability_Warrior_Warbringer",
		"Ability_Warrior_WarCry",
		"Ability_Warrior_WeaponMastery",
		"Ability_Warrior_DragonRoar", 
		"Ability_WarStomp",
		"Ability_Whirlwind",
		"Warrior_DisruptingShout", 
		"Warrior_DoubleTime", 
		"warrior_skullbanner", 
		"Warrior_talent_icon_Avatar", 
		"Warrior_talent_icon_Stormbolt", 
		"Warrior_Wild_strike", 
		"Warrior_talent_icon_AngerManagement", 
		"Warrior_talent_icon_GladiatorsResolve", 
		"Warrior_talent_icon_IgniteWeapon", 
		"Warrior_talent_icon_Ravager", 
	}
	GHM_StockIcons["Racial"] = {
		"PandarenRacial_Bouncy", 
		"PandarenRacial_Epicurean", 
		"PandarenRacial_Gourmand", 
		"PandarenRacial_InnerPeace", 
		"PandarenRacial_QuiveringPain",
		"Ability_Racial_Aberration",
		"Ability_Racial_bestdealsanywhere",
		"ability_racial_betterlivingthroughchemistry",
		"Ability_Racial_Darkflight",
		"Ability_Racial_Flayer",
		"Ability_Racial_PackHobgoblin",
		"Ability_Racial_RocketBarrage",
		"Ability_Racial_RocketJump",
		"Ability_Racial_RunningWild",
		"ability_racial_timeismoney",
		"Ability_Racial_TwoForms",
		"Ability_Worgen_DarkFlight",
		"Racial_Dwarf_FindTreasure",
		"Racial_Orc_BerserkerStrength",
		"Racial_Troll_Berserk",
		"Ability_Racial_Avatar",
		"Ability_Racial_BearForm",
		"Ability_Racial_BloodRage",
		"Ability_Racial_Cannibalize",
		"Ability_Racial_ShadowMeld",
		"Ability_Racial_Ultravision",	
		"Spell_Arcane_ArcaneTorrent",
		"Spell_Arcane_ManaTap",
		
	}
	GHM_StockIcons["Spell"] = {
		--- all ok
		"Spell_Arcane_Arcane01",
		"Spell_Arcane_Arcane02",
		"Spell_Arcane_Arcane03",
		"Spell_Arcane_Arcane04",
		"Spell_Arcane_ArcanePotency",
		"Spell_Arcane_ArcaneResilience",
		"spell_arcane_arcanetactics",
		"Spell_Arcane_FocusedPower",
		"spell_arcane_invocation",
		"Spell_Arcane_MassDispel",
		"Spell_Arcane_MindMastery",
		"spell_brew_bolt_dark", 
		"spell_brew_bolt_medium", 
		"spell_brew_bolt_wheat", 
		"spell_brew_dark", 
		"spell_brew_medium", 
		"spell_brew_wheat", 
		"Spell_BrokenHeart",
		"Spell_ChargeNegative",
		"Spell_ChargePositive",
		"Spell_FireResistanceTotem_01",
		"Spell_Fire_BlueCano",
		"Spell_Fire_BlueFire",
		"Spell_Fire_BlueFireNova",
		"Spell_Fire_BlueFireward",
		"Spell_Fire_BlueFlameBolt",
		"Spell_Fire_BlueFlameBreath",
		"Spell_Fire_BlueFlameRing",
		"Spell_Fire_BlueFlameStrike",
		"Spell_Fire_BlueHellfire",
		"Spell_Fire_BlueImmolation",
		"Spell_Fire_BluePyroblast",
		"Spell_Fire_BlueRainOfFire",
		"Spell_Fire_Burnout",
		"Spell_Fire_ElementalDevastation",
		"Spell_Fire_Elemental_Totem",
		"Spell_Fire_EnchantWeapon",
		"Spell_Fire_Felcano",
		"Spell_Fire_Fire",
		"Spell_Fire_FlameBlades",
		"Spell_Fire_FlameBolt",
		"Spell_Fire_FlameShock",
		"Spell_Fire_FlameTounge",
		"Spell_Fire_Flare",
		"Spell_Fire_FrostResistanceTotem",
		"Spell_Fire_LavaSpawn",
		"Spell_Fire_MasterOfElements",
		"Spell_Fire_MeteorStorm",
		"Spell_Fire_MoltenBlood",
		"Spell_Fire_PlayingWithFire",
		"Spell_Fire_Ragnaros_LavaBolt",
		"Spell_Fire_Ragnaros_MoltenInferno",
		"Spell_Fire_Ragnaros_SplittingBlow",
		"Spell_Fire_Ragnaros_Supernova",
		"Spell_Fire_Rune", -- [993]
		"Spell_Fire_SealOfFire",
		"Spell_Fire_SearingTotem",
		"Spell_Fire_SelfDestruct",
		"Spell_Fire_SoulBurn",
		"Spell_Fire_SunKey",
		"Spell_Fire_TotemOfWrath",
		"spell_fire_twilightcano",
		"spell_fire_twilightfire",
		"spell_fire_twilightfireward",
		"spell_fire_twilightflamebolt",
		"spell_fire_twilightflamebreath",
		"spell_fire_twilightflamestrike",
		"spell_fire_twilighthellfire",
		"spell_fire_twilightimmolation",
		"spell_fire_twilightnova",
		"spell_fire_twilightpyroblast",
		"spell_fire_twilightrainoffire",
		"Spell_Fire_Volcano",
		"Spell_Fire_WindsofWoe",
		"Spell_FrostResistanceTotem_01",
		"Spell_Frost_ArcticWinds",
		"Spell_Frost_ChainsOfIce",
		"Spell_Frost_ChillingArmor",
		"Spell_Frost_ChillingBlast",
		"Spell_Frost_ChillingBolt",
		"Spell_Frost_ColdHearted",
		"Spell_Frost_FireResistanceTotem",
		"Spell_Frost_FreezingBreath",
		"Spell_Frost_Frost",
		"Spell_Frost_FrostBlast",
		"Spell_Frost_FrostBrand",
		"Spell_Frost_FrostShock",
		"Spell_Frost_Glacier",
		"spell_frost_ice shards",
		"Spell_Frost_IceClaw",
		"Spell_Frost_IceFloes",
		"Spell_Frost_IceShard",
		"Spell_Frost_IceShock",
		"Spell_Frost_IceStorm",
		"Spell_Frost_ManaBurn",
		"Spell_Frost_ManaRecharge",
		"spell_frost_piercing chill",
		"Spell_Frost_Stun",
		"Spell_Frost_WindWalkOn",
		"Spell_Frost_Wisp",
		"Spell_Frost_WizardMark",
		"Spell_Holiday_ToW_SpiceCloud",
		"Spell_Holy_Absolution",
		"Spell_Holy_ArcaneIntellect",
		"Spell_Holy_ArdentDefender",
		"Spell_Holy_AshesToAshes",
		"Spell_Holy_Aspiration",
		"Spell_Holy_AuraMastery",
		"Spell_Holy_AuraOfLight",
		"Spell_Holy_AvengersShield",
		"Spell_Holy_AvengineWrath",
		"SPELL_HOLY_AVENGINEWRATH", -- [994]
		"Spell_Holy_BlessedLife",
		"Spell_Holy_BlessedRecovery",
		"Spell_Holy_BlessedResillience",
		"Spell_Holy_BlessingOfAgility",
		"Spell_Holy_BlessingOfProtection",
		"Spell_Holy_BlessingOfStamina",
		"Spell_Holy_BlessingOfStrength",
		"Spell_Holy_BlindingHeal",
		"SPELL_HOLY_BORROWEDTIME",
		"Spell_Holy_ChampionsBond",
		"Spell_Holy_ChampionsGrace",
		"Spell_Holy_Chastise",
		"Spell_Holy_CircleOfRenewal",
		"Spell_Holy_ConsumeMagic",
		"Spell_Holy_Crusade",
		"Spell_Holy_CrusaderAura",
		"Spell_Holy_CrusaderStrike",
		"Spell_Holy_DevineAegis",
		"Spell_Holy_Devotion",
		"SPELL_HOLY_DEVOTIONAURA",
		"Spell_Holy_DispelMagic",
		"Spell_Holy_DivineHymn",
		"Spell_Holy_DivineIllumination",
		"Spell_Holy_DivineIntervention",
		"Spell_Holy_DivineProtection",
		"Spell_Holy_DivineProvidence",
		"Spell_Holy_DivinePurpose",
		"Spell_Holy_DivineShield",
		"Spell_Holy_DivineSpirit",
		"Spell_Holy_Dizzy",
		"Spell_Holy_ElunesGrace",
		"Spell_Holy_EmpowerChampion",
		"Spell_Holy_Excorcism",
		"Spell_Holy_Excorcism_02",
		"Spell_Holy_EyeforanEye",
		"Spell_Holy_Fanaticism",
		"Spell_Holy_FistOfJustice",
		"Spell_Holy_FlashHeal",
		"Spell_Holy_GreaterBlessingofKings",
		"Spell_Holy_GreaterBlessingofLight",
		"Spell_Holy_GreaterBlessingofSalvation",
		"Spell_Holy_GreaterBlessingofSanctuary",
		"Spell_Holy_GreaterBlessingofWisdom",
		"Spell_Holy_GreaterHeal",
		"Spell_Holy_GuardianSpirit",
		"Spell_Holy_HarmUndeadAura",
		"Spell_Holy_Heal",
		"Spell_Holy_Heal02",
		"Spell_Holy_HealingAura",
		"Spell_Holy_HealingFocus",
		"Spell_Holy_Heroism",
		"Spell_Holy_HolyBolt",
		"Spell_Holy_HolyGuidance",
		"Spell_Holy_HolyNova",
		"Spell_Holy_HolyProtection",
		"Spell_Holy_HolySmite",
		"Spell_Holy_HopeAndGrace",
		"Spell_Holy_ImpHolyConcentration",
		"Spell_Holy_ImprovedResistanceAuras",
		"Spell_Holy_InnerFire",
		"Spell_Holy_LastingDefense",
		"Spell_Holy_LayOnHands",
		"Spell_Holy_LesserHeal",
		"Spell_Holy_LesserHeal02",
		"Spell_Holy_LightsGrace",
		"Spell_Holy_MagicalSentry",
		"Spell_Holy_MindSooth",
		"Spell_Holy_MindVision",
		"Spell_Holy_NullifyDisease",
		"Spell_Holy_PainSupression",
		"Spell_Holy_Penance",
		"Spell_Holy_Persecution",
		"Spell_Holy_PersuitofJustice",
		"Spell_Holy_Power",
		"Spell_Holy_PowerInfusion",
		"Spell_Holy_PowerWordBarrier",
		"Spell_Holy_PowerWordBarrier", -- [995]
		"Spell_Holy_PowerWordShield",
		"Spell_Holy_PrayerOfFortitude",
		"Spell_Holy_PrayerOfHealing",
		"Spell_Holy_PrayerOfHealing02",
		"Spell_Holy_PrayerOfMendingtga",
		"Spell_Holy_PrayerofShadowProtection",
		"Spell_Holy_PrayerofSpirit",
		"Spell_Holy_ProclaimChampion",
		"Spell_Holy_ProclaimChampion_02",
		"Spell_Holy_PureOfHeart",
		"Spell_Holy_Purify",
		"Spell_Holy_PurifyingPower",
		"Spell_Holy_Rapture",
		"Spell_Holy_Rebuke",
		"Spell_Holy_Redemption",
		"Spell_Holy_RemoveCurse",
		"Spell_Holy_Renew",
		"Spell_Holy_Restoration",
		"Spell_Holy_Resurrection",
		"Spell_Holy_Retribution",
		"Spell_Holy_RetributionAura",
		"Spell_Holy_ReviveChampion",
		"Spell_Holy_RighteousFury",
		"Spell_Holy_RighteousnessAura",
		"Spell_Holy_Rune", -- [996]
		"Spell_Holy_SealOfBlood",
		"Spell_Holy_SealOfFury",
		"Spell_Holy_SealOfMight",
		"Spell_Holy_SealOfProtection",
		"Spell_Holy_SealOfRighteousness",
		"Spell_Holy_SealOfSacrifice",
		"Spell_Holy_SealOfSalvation",
		"Spell_Holy_SealOfValor",
		"Spell_Holy_SealOfVengeance",
		"Spell_Holy_SealOfWisdom",
		"Spell_Holy_SealOfWrath",
		"Spell_Holy_SearingLight",
		"Spell_Holy_SearingLightPriest",
		"Spell_Holy_SenseUndead",
		"Spell_Holy_Serendipity",
		"Spell_Holy_Silence",
		"Spell_Holy_SpellWarding",
		"Spell_Holy_SpiritualGuidence",
		"Spell_Holy_Stoicism",
		"Spell_Holy_SummonChampion",
		"Spell_Holy_SummonLightwell",
		"Spell_Holy_SurgeOfLight",
		"Spell_Holy_SymbolOfHope",
		"Spell_Holy_TestOfFaith",
		"Spell_Holy_TurnUndead",
		"Spell_Holy_UnyieldingFaith",
		"Spell_Holy_Vindication",
		"Spell_Holy_WeaponMastery",
		"Spell_Holy_WordFortitude",	
		"Spell_Ice_Lament",
		"Spell_Ice_MagicDamage",
		"Spell_Ice_Rune", -- [997]
		"Spell_lfieblood",
		"spell_lifegivingseed",
		"SPELL_LIFEGIVINGSPEED",
		"Spell_Lightning_LightningBolt01",
		"Spell_Magic_FeatherFall",
		"Spell_Magic_GreaterBlessingofKings",
		"Spell_Magic_LesserInvisibilty",
		"Spell_Magic_MageArmor",
		"Spell_Magic_ManaGain",
		"Spell_Magic_PolymorphChicken",
		"Spell_Magic_PolymorphPig",
		"Spell_Magic_PolymorphRabbit",
		"Spell_Magic_PolymorphRabbit", -- [998]
		"Spell_Misc_ConjureManaJewel",
		"Spell_Misc_Drink",
		"Spell_Misc_EmotionAfraid",
		"Spell_Misc_EmotionAngry",
		"Spell_Misc_EmotionHappy",
		"Spell_Misc_EmotionSad",
		"Spell_Misc_Food",
		"Spell_Misc_HellifrePVPCombatMorale",
		"Spell_Misc_HellifrePVPHonorHoldFavor",
		"Spell_Misc_HellifrePVPThrallmarFavor",
		"Spell_Misc_WarsongBrutal",
		"Spell_Misc_WarsongFocus",
		"Spell_Misc_PetHeal", 
		"Spell_Misc_WateringCan", 
		"Spell_Nature_AbolishMagic",
		"Spell_Nature_Acid_01",
		"Spell_Nature_AgitatingTotem",
		"Spell_Nature_AncestralGuardian",
		"Spell_Nature_AstralRecal",
		"Spell_Nature_AstralRecalGroup",
		"Spell_Nature_BloodLust",
		"Spell_Nature_Brilliance",
		"Spell_Nature_CallStorm",
		"Spell_Nature_ChainLightning",
		"Spell_Nature_CorrosiveBreath",
		"Spell_Nature_CrystalBall",
		"Spell_Nature_Cyclone",
		"Spell_Nature_DiseaseCleansingTotem",
		"Spell_Nature_Drowsy",
		"Spell_Nature_DryadDispelMagic",
		"Spell_Nature_EarthBind",
		"Spell_Nature_EarthBindTotem",
		"Spell_Nature_EarthElemental_Totem",
		"Spell_Nature_Earthquake",
		"Spell_Nature_EarthShock",
		"Spell_Nature_ElementalAbsorption",
		"Spell_Nature_ElementalPrecision_1",
		"Spell_Nature_ElementalPrecision_2",
		"Spell_Nature_ElementalShields",
		"Spell_Nature_EnchantArmor",
		"Spell_Nature_EyeOfTheStorm",
		"Spell_Nature_FaerieFire",
		"Spell_Nature_FarSight",
		"Spell_Nature_FocusedMind",
		"Spell_Nature_ForceOfNature",
		"Spell_Nature_GiftoftheWaterSpirit",
		"Spell_Nature_GiftoftheWild",
		"Spell_Nature_GroundingTotem",
		"Spell_Nature_GuardianWard",
		"Spell_Nature_HealingTouch",
		"Spell_Nature_HealingWaveGreater",
		"Spell_Nature_HealingWaveLesser",
		"SPELL_NATURE_HEALINGWAY",
		"Spell_Nature_InsectSwarm",
		"Spell_Nature_InvisibilityTotem",
		"Spell_Nature_Invisibilty",
		"Spell_Nature_Lightning",
		"Spell_Nature_LightningBolt",
		"Spell_Nature_LightningOverload",
		"Spell_Nature_LightningShield",
		"Spell_Nature_MagicImmunity",
		"Spell_Nature_ManaRegenTotem",
		"Spell_Nature_MassTeleport",
		"Spell_Nature_MentalQuickness",
		"Spell_Nature_MirrorImage",
		"Spell_Nature_MoonGlow",
		"Spell_Nature_MoonKey",
		"Spell_Nature_NatureBlessing",
		"Spell_Nature_NatureGuardian",
		"Spell_Nature_NatureResistanceTotem",
		"Spell_Nature_NaturesBlessing",
		"Spell_Nature_NaturesWrath",
		"Spell_Nature_NatureTouchDecay",
		"Spell_Nature_NatureTouchGrow",
		"Spell_Nature_NullifyDisease",
		"Spell_Nature_NullifyPoison",
		"Spell_Nature_NullifyPoison_02",
		"Spell_Nature_NullWard",
		"Spell_Nature_PoisonCleansingTotem",
		"Spell_Nature_Polymorph",
		"Spell_Nature_Polymorph_Cow",
		"Spell_Nature_Preservation",
		"Spell_Nature_ProtectionformNature",
		"Spell_Nature_Purge",
		"Spell_Nature_RavenForm",
		"Spell_Nature_Regenerate",
		"Spell_Nature_Regeneration",
		"Spell_Nature_Regeneration_02",
		"Spell_Nature_Reincarnation",
		"Spell_Nature_Rejuvenation",
		"Spell_Nature_RemoveCurse",
		"Spell_Nature_RemoveDisease",
		"Spell_Nature_ResistMagic",
		"Spell_Nature_ResistNature",
		"Spell_Nature_Riptide",
		"Spell_Nature_Riptide", -- [999]
		"Spell_Nature_RockBiter",
		"Spell_Nature_Rune", -- [1000]
		"Spell_Nature_Sentinal",
		"Spell_Nature_ShamanRage",
		"Spell_Nature_SkinofEarth",
		"Spell_Nature_Sleep",
		"Spell_Nature_Slow",
		"Spell_Nature_SlowingTotem",
		"Spell_Nature_SlowPoison",
		"Spell_Nature_SpiritArmor",
		"Spell_Nature_SpiritWolf",
		"Spell_Nature_StarFall",
		"Spell_Nature_StoneClawTotem",
		"Spell_Nature_StoneSkinTotem",
		"Spell_Nature_StormReach",
		"Spell_Nature_StrangleVines",
		"Spell_Nature_Strength",
		"Spell_Nature_StrengthOfEarthTotem02",
		"Spell_Nature_Swiftness",
		"Spell_Nature_Thorns",
		"Spell_Nature_ThunderClap",
		"Spell_Nature_TimeStop",
		"Spell_Nature_Tranquility",
		"Spell_Nature_TremorTotem",
		"Spell_Nature_UndyingStrength",
		"Spell_Nature_UnleashedRage",
		"Spell_Nature_UnrelentingStorm",
		"Spell_Nature_UnyeildingStamina",
		"Spell_Nature_Web",
		"Spell_Nature_Windfury",
		"Spell_Nature_WispHeal",
		"Spell_Nature_WispSplode",
		"Spell_Nature_WispSplodeGreen",
		"Spell_Nature_WrathofAir _Totem",
		"Spell_Nature_WrathV2",
		"Spell_Nature_DoublePolymorph1", 
		"Spell_Nature_DoublePolymorph2", 
		"Spell_Nature_HeavyPolymorph1", 
		"Spell_Nature_HeavyPolymorph2", 
		"spell_nature_insect_swarm2", 
		"Spell_Nature_SicklyPolymorph",
		"Spell_Shadow_AbominationExplosion",
		"Spell_Shadow_AnimateDead",
		"Spell_Shadow_AntiMagicShell",
		"Spell_Shadow_AntiShadow",
		"Spell_Shadow_AuraOfDarkness",
		"Spell_Shadow_BlackPlague",
		"Spell_Shadow_BloodBoil",
		"Spell_Shadow_Brainwash",
		"Spell_Shadow_BurningSpirit",
		"Spell_Shadow_CallofBone",
		"Spell_Shadow_CarrionSwarm",
		"Spell_Shadow_Charm",
		"Spell_Shadow_ChillTouch",
		"Spell_Shadow_ConeOfSilence",
		"Spell_Shadow_Contagion",
		"Spell_Shadow_CorpseExplode",
		"Spell_Shadow_CreepingPlague",
		"Spell_Shadow_Cripple",
		"Spell_Shadow_Curse",
		"Spell_Shadow_CurseOfAchimonde",
		"Spell_Shadow_CurseOfMannoroth",
		"Spell_Shadow_CurseOfSargeras",
		"Spell_Shadow_CurseOfTounges",
		"Spell_Shadow_DarkRitual",
		"Spell_Shadow_DarkSummoning",
		"Spell_Shadow_DeadofNight",
		"Spell_Shadow_DeathAndDecay",
		"Spell_Shadow_DeathCoil",
		"Spell_Shadow_DeathPact",
		"Spell_Shadow_DeathScream",
		"Spell_Shadow_DeathsEmbrace",
		"Spell_Shadow_DemonBreath",
		"Spell_Shadow_DemonForm",
		"Spell_Shadow_DemonicCircleSummon",
		"Spell_Shadow_DemonicCircleTeleport",
		"Spell_Shadow_DemonicEmpathy",
		"Spell_Shadow_DemonicFortitude",
		"Spell_Shadow_DemonicPact",
		"Spell_Shadow_DemonicTactics",
		"Spell_Shadow_DestructiveSoul",
		"Spell_Shadow_DetectInvisibility",
		"Spell_Shadow_DetectLesserInvisibility",
		"spell_shadow_devouringplague",
		"Spell_Shadow_DevouringPlague", -- [1002]
		"Spell_Shadow_DevouringPlague.", -- [1001]
		"Spell_Shadow_Dispersion",
		"Spell_Shadow_EnslaveDemon",
		"Spell_Shadow_EvilEye",
		"Spell_Shadow_FelArmour",
		"Spell_Shadow_FelMending",
		"Spell_Shadow_FingerOfDeath",
		"Spell_Shadow_FocusedPower",
		"Spell_Shadow_Fumble",
		"Spell_Shadow_GatherShadows",
		"Spell_Shadow_GhostKey",
		"Spell_Shadow_GrimWard",
		"Spell_Shadow_Haunting",
		"Spell_Shadow_ImpPhaseShift",
		"Spell_Shadow_ImprovedVampiricEmbrace",
		"Spell_Shadow_LastingAffliction",
		"Spell_Shadow_LastingAfflictions",
		"Spell_Shadow_LifeDrain",
		"Spell_Shadow_LifeDrain02",
		"Spell_Shadow_ManaBurn",
		"Spell_Shadow_ManaFeed",
		"Spell_Shadow_Metamorphosis",
		"Spell_Shadow_MindBomb",
		"spell_shadow_mindflay",
		"Spell_Shadow_MindRot",
		"Spell_Shadow_MindShear",
		"Spell_Shadow_MindSteal",
		"Spell_Shadow_MindTwisting",
		"Spell_Shadow_Misery",
		"Spell_Shadow_NetherCloak",
		"Spell_Shadow_NetherProtection",
		"Spell_Shadow_NightOfTheDead",
		"Spell_Shadow_PainAndSuffering",
		"Spell_Shadow_PainfulAfflictions",
		"Spell_Shadow_PainSpike",
		"Spell_Shadow_PlagueCloud",
		"Spell_Shadow_Possession",
		"Spell_Shadow_PsychicHorrors",
		"Spell_Shadow_PsychicScream",
		"Spell_Shadow_RagingScream",
		"Spell_Shadow_RainOfFire",
		"Spell_Shadow_RaiseDead",
		"Spell_Shadow_Requiem",
		"Spell_Shadow_RitualOfSacrifice",
		"Spell_Shadow_Rune", -- [1003]
		"Spell_Shadow_SacrificialShield",
		"Spell_Shadow_ScourgeBuild",
		"Spell_Shadow_SealOfKings",
		"Spell_Shadow_SeedOfDestruction",
		"Spell_Shadow_Shadesofdarkness",
		"Spell_Shadow_ShadeTrueSight",
		"Spell_Shadow_ShadowandFlame",
		"Spell_Shadow_ShadowBolt",
		"Spell_Shadow_ShadowEmbrace",
		"Spell_Shadow_Shadowfiend",
		"Spell_Shadow_Shadowform",
		"Spell_Shadow_Shadowfury",
		"Spell_Shadow_ShadowMend",
		"Spell_Shadow_ShadowPact",
		"Spell_Shadow_ShadowPower",
		"Spell_Shadow_ShadowWard",
		"Spell_Shadow_ShadowWordDominate",
		"Spell_Shadow_ShadowWordPain",
		"Spell_Shadow_SiphonMana",
		"Spell_Shadow_Skull",
		"Spell_Shadow_SoothingKiss",
		"Spell_Shadow_SoulGem",
		"Spell_Shadow_SoulLeech",
		"Spell_Shadow_SoulLeech_1",
		"Spell_Shadow_SoulLeech_2",
		"Spell_Shadow_SoulLeech_3",
		"Spell_Shadow_SpectralSight",
		"Spell_Shadow_SummonFelGuard",
		"Spell_Shadow_SummonFelHunter",
		"Spell_Shadow_SummonImp",
		"Spell_Shadow_SummonInfernal",
		"Spell_Shadow_SummonSuccubus",
		"Spell_Shadow_SummonVoidWalker",
		"Spell_Shadow_Teleport",
		"Spell_Shadow_Twilight",
		"Spell_Shadow_TwistedFaith",
		"Spell_Shadow_UnholyFrenzy",
		"Spell_Shadow_UnholyStrength",
		"Spell_Shadow_UnstableAffliction_1",
		"Spell_Shadow_UnstableAffliction_2",
		"Spell_Shadow_UnstableAffliction_3",
		"Spell_Shadow_UnstableAfllictions",
		"Spell_Shadow_UnsummonBuilding",
		"Spell_Shadow_VampiricAura",
		"Spell_Totem_WardOfDraining",
		"Spell_unused",
		"Spell_unused2",
		"spell_misc_zandalari_council_soulswap", 
		"Spell_quicksand", 
		"Spell_Sandbolt", 
		"Spell_sandelemental", 
		"Spell_SandExplosion", 
		"Spell_Sandstorm", 
		"Sha_Ability_Rogue_BloodyEye", 
		"Sha_ability_rogue_sturdyrecuperate", 
		"Sha_Spell_Fire_Ragnaros_Supernova", 
		"Sha_spell_warlock_demonsoul", 
		"Spell_BurningBladeShaman_Blazing_Radiance", 
		"Spell_BurningBladeShaman_LavaSlash", 
		"Spell_BurningBladeShaman_Molten_Torrent", 
		--"spell_shaman_unleashweapon_fire",
	}
	GHM_StockIcons["Ability"] = {
		-- o
		"Ability_AnimusDraw", 
		"Ability_AnimusOrbs", 
		"Ability_TouchofAnimus", 
		"Ability_Ambush",
		"Ability_BackStab",
		"Ability_BullRush",
		"Ability_CheapShot",
		"ability_boss_lordanthricystgreen",
		"Ability_Creature_Amber_01", --mop
		"Ability_Creature_Amber_02", --mop
		"Ability_Creature_Cursed_01",
		"Ability_Creature_Cursed_02",
		"Ability_Creature_Cursed_03",
		"Ability_Creature_Cursed_04",
		"Ability_Creature_Cursed_05",
		"Ability_Creature_Disease_01",
		"Ability_Creature_Disease_02",
		"Ability_Creature_Disease_03",
		"Ability_Creature_Disease_04",
		"Ability_Creature_Disease_05",
		"Ability_Creature_Poison_01",
		"Ability_Creature_Poison_02",
		"Ability_Creature_Poison_03",
		"Ability_Creature_Poison_04",
		"Ability_Creature_Poison_05",
		"Ability_Creature_Poison_06",
		"Ability_CriticalStrike",
		"Ability_Crown_of_the_Heavens_Icon",
		"ability_deathwing_assualtaspects",
		"ability_deathwing_cataclysm",
		"ability_deathwing_shrapnel",
		"ability_deathwing_bloodcorruption_death",
		"ability_deathwing_bloodcorruption_earth",
		"ability_deathwing_fierygrip",
		"ability_deathwing_grasping_tendrils",
		"ability_deathwing_grasping_tendrilsgreen",
		"ability_deathwing_sealarmorbreachtga",
		"Ability_deathwing_sealarmorbreachgreen",
		"Ability_Defend",
		"Ability_Devour",
		"Ability_DualWield",
		"Ability_DualWieldSpecialization",
		"Ability_Ensnare",
		"Ability_EyeOfTheOwl",
		"Ability_FiegnDead",
		"Ability_Fixated_State_Blue",
		"Ability_Fixated_State_Green",
		"Ability_Fixated_State_Orange",
		"Ability_Fixated_State_Purple",
		"Ability_Fixated_State_Red",
		"Ability_Fixated_State_Yellow",
		"Ability_GhoulFrenzy",
		"Ability_GolemStormBolt",
		"Ability_GolemThunderClap",
		"Ability_Gouge",
		"Ability_HeroicLeap",
		"Ability_Hibernation",
		"Ability_ImpalingBolt",
		"Ability_Kick",		
		"Ability_Marksmanship", 
		"Ability_MeleeDamage",
		"Ability_Miling",
		"Ability_Parry",
		"Ability_Physical_Taunt",
		"Ability_PierceDamage",
		"Ability_PoisonArrow",
		"ABILITY_POISONS",
		"Ability_PoisonSting",
		"ABILITY_POISONSTING", -- [22]
		"Ability_Repair",
		"Ability_RewindTime",
		"Ability_Rhyolith_Immolation",
		"Ability_Rhyolith_LavaPool",
		"Ability_Rhyolith_MagmaFlow_Wave",
		"Ability_Rhyolith_MagmaFlow_Whole",
		"Ability_Rhyolith_Volcano",
		"Ability_Seal",
		"Ability_SearingArrow",
		"Ability_ShockWave",
		"Ability_ShootWand",
		"Ability_Smash",
		"Ability_Spy",
		"Ability_Stealth",
		"Ability_SteelMelee",
		"Ability_Suffocate",
		"ability_tetanus",
		"Ability_TheBlackArrow",
		"Ability_Throw",
		"Ability_ThunderBolt",
		"Ability_ThunderClap",
		"ability_toughness",
		"Ability_TownWatch",
		"Ability_Tracking",
		"Ability_TrueShot",
		"Ability_UpgradeMoonGlaive",
		"Ability_Vanish",
		"Ability_Vehicle_DemolisherFlameCatapult", -- [25]
		"Ability_Vehicle_DemolisherRam", -- [26]
		"Ability_Vehicle_ElectroCharge", -- [27]
		"Ability_Vehicle_LaunchPlayer", -- [28]
		"Ability_Vehicle_LiquidPyrite_blue", -- [29]
		"Ability_Vehicle_LiquidPyrite", -- [30]
		"Ability_Vehicle_LoadSelfCatapult", -- [31]
		"Ability_Vehicle_OilJets", -- [32]
		"Ability_Vehicle_PlagueBarrel", -- [33]
		"Ability_Vehicle_PlayerLoaded", -- [34]
		"Ability_Vehicle_PowertoWheels", -- [35]
		"Ability_Vehicle_ReloadAmmo", -- [36]
		"Ability_Vehicle_RocketBoost", -- [37]
		"Ability_Vehicle_ShellShieldGenerator", -- [38]
		"Ability_Vehicle_SiegeEngineCannon", -- [39]
		"Ability_Vehicle_SiegeEngineCharge", -- [40]
		"Ability_Vehicle_SiegeEngineRam", -- [41]
		"Ability_Vehicle_SonicShockwave", -- [42]
		"Ability_WIntergrasp_rank1",
		"Ability_WIntergrasp_rank2",
		"Ability_WIntergrasp_rank3",
		"inv_misc_stonedragonblue",
		"inv_misc_stonedragonorange",
		"inv_misc_stonedragonpurple",
		"inv_misc_stonedragonred",
		"inv_misc_stormdragongreen",
		"inv_misc_stormdragonpale",
		"inv_misc_stormdragonpurple",
		"inv_misc_stormdragonred",
		"Ability_Garrosh_Empowered_Whirling_Corruption", 
		"Ability_Garrosh_Hellscreams_Warsong", 
		"Ability_Garrosh_Siege_Engine", 
		"Ability_Garrosh_Touch_Of_Yshaarj", 
		"Ability_Garrosh_Whirling_Corruption", 
		"Ability_Hisek_Aim", 
		"Ability_Iyyokuk_Bomb_Blue", 
		"Ability_Iyyokuk_Bomb_Green", 
		"Ability_Iyyokuk_Bomb_Purple", 
		"Ability_Iyyokuk_Bomb_Red", 
		"Ability_Iyyokuk_Bomb_White", 
		"Ability_Iyyokuk_Bomb_Yellow", 
		"Ability_Iyyokuk_Calculate", 
		"Ability_Iyyokuk_Drum_Blue", 
		"Ability_Iyyokuk_Drum_Green", 
		"Ability_Iyyokuk_Drum_Purple", 
		"Ability_Iyyokuk_Drum_Red", 
		"Ability_Iyyokuk_Drum_White", 
		"Ability_Iyyokuk_Drum_Yellow", 
		"Ability_Iyyokuk_Mantid_Blue", 
		"Ability_Iyyokuk_Mantid_Green", 
		"Ability_Iyyokuk_Mantid_Purple", 
		"Ability_Iyyokuk_Mantid_Red", 
		"Ability_Iyyokuk_Mantid_White", 
		"Ability_Iyyokuk_Mantid_Yellow", 
		"Ability_Iyyokuk_Staff_Blue", 
		"Ability_Iyyokuk_Staff_Green", 
		"Ability_Iyyokuk_Staff_Purple", 
		"Ability_Iyyokuk_Staff_Red", 
		"Ability_Iyyokuk_Staff_White", 
		"Ability_Iyyokuk_Staff_Yellow", 
		"Ability_Iyyokuk_Sword_Blue", 
		"Ability_Iyyokuk_Sword_Green", 
		"Ability_Iyyokuk_Sword_Purple", 
		"Ability_Iyyokuk_Sword_Red", 
		"Ability_Iyyokuk_Sword_White", 
		"Ability_Iyyokuk_Sword_Yellow", 
		"Ability_Karoz_Leap", 
		"Ability_Kaztik_DominateMind", 
		"Ability_Kilruk_Reave", 
		"Ability_Malkorok_BlightofYshaarj_Green", 
		"Ability_Malkorok_BlightofYshaarj_Red", 
		"Ability_Malkorok_BlightofYshaarj_Yellow", 
		"Ability_Rikkal_Genetics", 
		"Ability_ShaWaterElemental_Reform", 
		"Ability_ShaWaterElemental_Split", 
		"Ability_ShaWaterElemental_Swirl", 
		"Ability_Siege_Engineer_Automatic_repair_beam", 
		"Ability_Siege_Engineer_Death_from_above", 
		"Ability_Siege_Engineer_detonate", 
		"Ability_Siege_Engineer_Magnetic_Crush", 
		"Ability_Siege_Engineer_Magnetic_Lasso", 
		"Ability_Siege_Engineer_Overload", 
		"Ability_Siege_Engineer_pattern_recognition", 
		"Ability_Siege_Engineer_Protective_Frenzy", 
		"Ability_Siege_Engineer_Purification_beam", 
		"Ability_Siege_Engineer_Sockwave_Missile", 
		"Ability_Siege_Engineer_Superheated", 
		"Ability_Skeer_BloodLetting", 
		"Ability_TitanKeeper_Amalgam", 
		"Ability_TitanKeeper_Cleanse", 
		"Ability_TitanKeeper_CleansingOrb", 
		"Ability_TitanKeeper_Corrupt", 
		"Ability_TitanKeeper_CorruptionDot", 
		"Ability_TitanKeeper_ExpelCorruption", 
		"Ability_TitanKeeper_ExtractCorruption", 
		"Ability_TitanKeeper_Phasing", 
		"Ability_TitanKeeper_PiercingCorruption", 
		"Ability_TitanKeeper_Quarantine", 
		"Ability_TitanKeeper_ResidualCorruption", 
		"Ability_TitanKeeper_TestofConfidence", 
		"Ability_TitanKeeper_TestofSerenity", 
		"Ability_TitanKeeper_TitanicSmash", 
		"Ability_TitanKeeper_UncheckedCorruption", 
		"Ability_Xaril_MasterPoisoner_Blue", 
		"Ability_Xaril_MasterPoisoner_Green", 
		"Ability_Xaril_MasterPoisoner_Orange", 
		"Ability_Xaril_MasterPoisoner_Purple", 
		"Ability_Xaril_MasterPoisoner_Red", 
		"Ability_Xaril_MasterPoisoner_White", 
		"Ability_Xaril_MasterPoisoner_Yellow", 
		"6BF_Blackrock_Nova", 
		"6BF_Explosive_Shard", 
		"6BF_Retched_Blackrock", 
		"6BF_Rolling_Fury", 
		"Ability_Accretion", 
		"Ability_Arakkoa_Spinning_Blade", 
		"Ability_Blackhand_AttachedSlagbombs", 
		"Ability_Blackhand_Demolition", 
		"Ability_Blackhand_Marked4Death", 
		"Ability_Blackhand_Slagbombs", 
		"Ability_Butcher_Cleave", 
		"Ability_Butcher_Exsanguination", 
		"Ability_Butcher_GushingWounds", 
		"Ability_Butcher_Heavyhanded", 
		"Ability_Butcher_Whirl", 
		"Ability_Creature_The_Living_Mountain", 
		"Ability_EarthenFury_GiftofEarth", 
		"Ability_Earthen_Pillar", 
		"Ability_Faultline", 
		"Ability_Fomor_Boss_Pillar01", 
		"Ability_Fomor_Boss_Pillar02", 
		"Ability_Fomor_Boss_Rune_Brown", 
		"Ability_Fomor_Boss_Rune_Green", 
		"Ability_Fomor_Boss_Rune_Red", 
		"Ability_Fomor_Boss_Rune_Yellow", 
		"Ability_Fomor_Boss_Rune__Yellow", 
		"Ability_Fomor_Boss_Shout", 
		"Ability_Foundryraid_Bellows", 
		"Ability_Foundryraid_BlastWave", 
		"Ability_Foundryraid_Demolition", 
		"Ability_Foundryraid_Dormant", 
		"Ability_Foundryraid_HeatRegulators", 
		"Ability_Foundryraid_Melt", 
		"Ability_Foundryraid_Taze", 
		"Ability_Foundryraid_TrainDeath", 
		"Ability_Gift_of_Earth", 
		"Ability_HanzandFranz_BodySlam", 
		"Ability_HanzandFranz_ChestBump", 
		"Ability_IronMaidens_BladeRush", 
		"Ability_IronMaidens_BloodRitual", 
		"Ability_IronMaidens_Bombardment", 
		"Ability_IronMaidens_BoomerangRush", 
		"Ability_IronMaidens_ConvulsiveShadows", 
		"Ability_IronMaidens_CorruptedBlood", 
		"Ability_IronMaidens_DarkHunt", 
		"Ability_IronMaidens_DeployTurret", 
		"Ability_IronMaidens_DetonationSequence", 
		"Ability_IronMaidens_GrapeshotBlast", 
		"Ability_IronMaidens_Impale", 
		"Ability_IronMaidens_IncindiaryDevice", 
		"Ability_IronMaidens_IronShot", 
		"Ability_IronMaidens_IronWill", 
		"Ability_IronMaidens_MaraksBloodcalling", 
		"Ability_IronMaidens_RapidFire", 
		"Ability_IronMaidens_SanguineStrikes", 
		"Ability_IronMaidens_SorkasPrey", 
		"Ability_IronMaidens_SwirlingVortex", 
		"Ability_IronMaidens_WhirlofBlood",
		"Ability_Skyreach_Castdown", 
		"Ability_Skyreach_Dismount", 
		"Ability_Skyreach_Empower", 
		"Ability_Skyreach_Empowered", 
		"Ability_Skyreach_Energize", 
		"Ability_Skyreach_Flash_Bang", 
		"Ability_Skyreach_Flying_Charge", 
		"Ability_Skyreach_FourBlades", 
		"Ability_Skyreach_Four_Wind", 
		"Ability_Skyreach_Lens_Flare", 
		"Ability_Skyreach_Overwhelmed", 
		"Ability_Skyreach_Piercing_Rush", 
		"Ability_Skyreach_Shielded", 
		"Ability_Skyreach_Solar_Burst", 
		"Ability_Skyreach_Spinning_Blade", 
		"Ability_Skyreach_Swarm", 
		"Ability_Skyreach_Wind", 
		"Ability_Skyreach_Wind_Wall", 
		"Ability_Socererking_arcaneacceleration", 
		"Ability_Socererking_arcanefortification", 
		"Ability_Socererking_arcanemines", 
		"Ability_Socererking_arcanereplication", 
		"Ability_Socererking_arcanewrath", 
		"Ability_Socererking_forcenova", 
		"Ability_Socererking_Summonaberration", 
		"Ability_Tectonic_Upheaval", 		
		}
	GHM_StockIcons["Ammo"] = {
		-- ok
		"INV_Ammo_Arrow_01",
		"INV_Ammo_Arrow_02",
		"INV_Ammo_Arrow_03",
		"INV_Ammo_Arrow_03", -- [206]
		"INV_Ammo_Arrow_04",
		"INV_Ammo_Arrow_04", -- [207]
		"INV_Ammo_Arrow_05",
		"INV_Ammo_Arrow_05", -- [208]
		"INV_Ammo_Arrow_06",
		"INV_Ammo_Arrow_06", -- [209]
		"INV_Misc_Ammo_Arrow_01",
		"INV_Misc_Ammo_Arrow_02",
		"INV_Misc_Ammo_Arrow_03",
		"INV_Misc_Ammo_Arrow_04",
		"INV_Misc_Ammo_Arrow_05",
		"INV_Ammo_Bullet_01",
		"INV_Ammo_Bullet_02",
		"INV_Ammo_Bullet_03",
		"INV_Ammo_Bullet_04",
		"INV_Ammo_Bullet_04", -- [210]
		"INV_Ammo_Bullet_05",
		"INV_Ammo_Bullet_05", -- [211]
		"INV_Ammo_Bullet_06",
		"INV_Ammo_Bullet_06", -- [212]
		"INV_Ammo_Bullet_07",
		"INV_Ammo_Bullet_07", -- [213]
		"INV_Ammo_Bullet_08",
		"INV_Ammo_Bullet_08", -- [214]
		"INV_Misc_Ammo_Bullet_01",
		"INV_Misc_Ammo_Bullet_02",
		"INV_Misc_Ammo_Bullet_03",
		"INV_Misc_Ammo_Bullet_04",
		"INV_Misc_Ammo_Bullet_05",
		"INV_Misc_Ammo_Bullet_06",
		"INV_Misc_Ammo_Gunpowder_01",
		"INV_Misc_Ammo_Gunpowder_02",
		"Inv_Misc_ammo_Gunpowder_03",
		"Inv_Misc_ammo_Gunpowder_04",
		"Inv_Misc_ammo_Gunpowder_05",
		"Inv_Misc_ammo_Gunpowder_06",
		"Inv_Misc_ammo_Gunpowder_07",
		"INV_Ammo_FireTar",
		"INV_Ammo_Snowball",
	}
	GHM_StockIcons["Axe"] = {
		-- ok
		"inv_axe_01",
		"inv_axe_02",
		"inv_axe_03",
		"inv_axe_04",
		"inv_axe_05",
		"inv_axe_06",
		"inv_axe_07",
		"inv_axe_08",
		"inv_axe_09",
		"inv_axe_10",
		"inv_axe_11",
		"inv_axe_12",
		"inv_axe_13",
		"inv_axe_14",
		"inv_axe_15",
		"inv_axe_16",
		"inv_axe_17",
		"inv_axe_18",
		"inv_axe_19",
		"inv_axe_20",
		"inv_axe_21",
		"inv_axe_22",
		"inv_axe_23",
		"inv_axe_24",
		"inv_axe_25",
		"inv_axe_26",
		"inv_axe_29",
		"inv_axe_30",
		"inv_axe_32",
		"inv_axe_33",
		"inv_axe_34",
		"inv_axe_35",
		"inv_axe_36",
		"inv_axe_37",
		"inv_axe_38",
		"inv_axe_39",
		"inv_axe_40",
		"inv_axe_44",
		"inv_axe_45",
		"inv_axe_46",
		"inv_axe_49",
		"inv_axe_50",
		"inv_axe_51",
		"inv_axe_52",
		"inv_axe_53",
		"inv_axe_54",
		"inv_axe_55",
		"inv_axe_56",
		"inv_axe_57",
		"inv_axe_59",
		"inv_axe_60",
		"inv_axe_61",
		"inv_axe_62",
		"inv_axe_63",
		"inv_axe_64",
		"inv_axe_65",
		"inv_axe_66",
		"inv_axe_67",
		"inv_axe_68",
		"inv_axe_69",
		"inv_axe_70",
		"inv_axe_71",
		"inv_axe_72",
		"inv_axe_73",
		"inv_axe_75",
		"inv_axe_76",
		"inv_axe_77",
		"inv_axe_78",
		"inv_axe_79",
		"inv_axe_80",
		"inv_axe_81",
		"inv_axe_82",
		"inv_axe_83",
		"inv_axe_84",
		"inv_axe_85",
		"inv_axe_86",
		"inv_axe_87",
		"inv_axe_88",
		"inv_axe_89",
		"inv_axe_90",
		"inv_axe_91",
		"inv_axe_93",
		"inv_axe_94",
		"inv_axe_95",
		"inv_axe_96",
		"inv_axe_97",
		"inv_axe_98",
		"inv_axe_99",
		"inv_axe_100",
		"inv_axe_101",
		"inv_axe_102",
		"inv_axe_103",
		"inv_axe_104",
		"inv_axe_105",
		"inv_axe_106",
		"inv_axe_107",
		"inv_axe_108",
		"inv_axe_109",
		"inv_axe_110",
		"inv_axe_111",
		"inv_axe_112",
		"inv_axe_113",
		"inv_axe_114",
		"inv_axe_115",
		"inv_axe_116",
		"inv_axe_117",
		"inv_axe_118",
		"inv_axe_119",
		"inv_axe_120",
		"inv_axe_121",
		"inv_axe_122",
		"INV_Axe_1h_430NightElf_C_01",
		"INV_Axe_1h_430NightElf_C_02",
		"inv_axe_1H_BlackSmithing_01",
		"inv_axe_1H_BlackSmithing_02",
		"inv_axe_1H_BlackSmithing_03",
		"inv_axe_1H_BWDRaid_D_01",
		"inv_axe_1H_Cataclysm_B_01",
		"inv_axe_1H_Cataclysm_B_02",
		"inv_axe_1H_Cataclysm_C_01",
		"INV_Axe_1h_DeathwingRaidDW_D_01",
		"INV_Axe_1h_DeathwingRaid_D_01",
		"INV_Axe_1h_DeathwingRaid_D_02",
		"inv_axe_1H_FirelandsRaid_D_01",
		"inv_axe_1H_FirelandsRaid_D_02",
		"inv_axe_1H_PVP400_C_01",
		"inv_axe_1H_PVP410_C_01",
		"INV_Axe_1h_PVPCataclysmS3_C_01",
		"INV_Axe_2H_430Future_C_01",
		"inv_axe_2H_Cataclysm_B_01",
		"inv_axe_2H_Cataclysm_B_02",
		"inv_axe_2H_Cataclysm_C_01",
		"INV_Axe_2h_DeathwingRaid_D_01",
		"inv_axe_2H_FirelandsRaid_D_01",
		"inv_axe_2H_GrimBatolRaid_D_01",
		"inv_axe_2H_PVP400_C_01",
		"inv_axe_2h_PVP410_C_01",
		"INV_Axe_2h_PVPCataclysmS3_C_01",
		"inv_axe_2h_stratholme_d_01",
		"INV_ThrowingAxePvP320_07", -- [705]
		"INV_ThrowingAxePvP330_08", -- [706]
		"INV_Axe2H_PandariaTradeskill_C_01", 
		"INV_Axe_1h_PandaRaid_D_01", 
		"INV_Axe_1h_PandariaQuest_B_01", 
		"INV_Axe_1H_PandariaTradeskill_C_01", 
		"INV_Axe_1H_PanProg_B_01", 
		"INV_Axe_1h_PanStart_A_01", 
		"INV_Axe_1h_PVPPandariaS1_D_01", 
		"INV_Axe_2h_PandaRaid_D_01", 
		"INV_Axe_2h_PandariaQuest_B_01", 
		"INV_Axe_2h_PanProg_B_01", 
		"INV_Axe_2h_PVPPandariaS1_D_01", 
		"INV_Legendary_Axe", 
		"INV_Axe_1H_Gnome_C_01", 
		"INV_Axe_1h_PVPPandariaS2_C_01", 
		"INV_Axe_1H_ThunderIsleRaid_D_01", 
		"INV_Axe_1h_ThunderIsleRaid_D_02", 
		"INV_Axe_1h_ThunderIsleRaid_D_031", 
		"INV_Axe_2H_OrcWarrior_C_01", 
		"INV_Axe_2h_PVPPandariaS2_C_01Alliance", 
		"INV_Axe_2h_PVPPandariaS2_C_01Green", 
		"INV_Axe_2h_PVPPandariaS2_C_01Horde", 
		"INV_Axe_2h_PVPPandariaS2_C_01Silver", 
		"INV_Axe_2h_ThunderIsleRaid_D_01", 
		"INV_Axe_1h_OrgrimmarRaid_D_01", 
		"INV_Axe_1H_OrgrimmarRaid_D_02", 
		"INV_Axe_1h_OrgrimmarRaid_D_03", 
		"INV_Axe_1h_PVPHorde_D_01_UpRes", 
		"INV_Axe_1H_PVPPandariaS3_C_01", 
		"INV_Axe_2H_OrgrimmarRaid_D_01", 
		"INV_Axe_2H_PVPHorde_A_01BlackHigh", 
		"INVAxe_1H_DraenorRaid_D_01", 
		"INV_axe_1h_6dr_pickaxe_a_01", 
		"INV_axe_1h_6miningpick", 
		"INV_Axe_1H_Draenei_B_02", 
		"INV_Axe_1H_Draenei_C_02", 
		"INV_Axe_1h_DraenorChallenge_D_01", 
		"INV_Axe_1h_DraenorCrafted_D_01_A_Alliance", 
		"INV_Axe_1h_DraenorCrafted_D_01_A_Horde", 
		"INV_Axe_1h_DraenorCrafted_D_01_B_Alliance", 
		"INV_Axe_1h_DraenorCrafted_D_01_B_Horde", 
		"INV_Axe_1h_DraenorCrafted_D_01_C_Alliance", 
		"INV_Axe_1h_DraenorCrafted_D_01_C_Horde", 
		"INV_Axe_1h_DraenorCrafted_D_02_A_Alliance", 
		"INV_Axe_1h_DraenorCrafted_D_02_A_horde", 
		"INV_Axe_1h_DraenorCrafted_D_02_B_Alliance", 
		"INV_Axe_1h_DraenorCrafted_D_02_B_horde", 
		"INV_Axe_1h_DraenorCrafted_D_02_C_Alliance", 
		"INV_Axe_1h_DraenorCrafted_D_02_C_horde", 
		"INV_Axe_1h_DraenorDungeon_C_01", 
		"INV_Axe_1h_DraenorDungeon_C_02", 
		"INV_AXE_1H_DRAENORHONOR_C_01", 
		"INV_Axe_1H_DraenorOgre_B_01", 
		"INV_Axe_1h_DraenorQuest95_B_01", 
		"INV_Axe_1h_DraenorQuest_B_01", 
		"INV_Axe_1h_DraenorRaid_D_02", 
		"INV_Axe_1h_DraenorRaid_D_02b", 
		"INV_Axe_1h_DraenorRaid_D_03", 
		"INV_Axe_1H_DreanorOgre_B_01", 
		"INV_axe_1h_garrison_a_01", 
		"INV_axe_1h_garrison_a_02", 
		"INV_axe_1h_garrison_a_03", 
		"INV_Axe_1H_Horde_B_01_HD", 
		"INV_axe_1h_orcclan_b_01", 
		"INV_Axe_1h_PVPDraenorS1_D_01", 
		"INV_Axe_1h_WarsongClan_C_01", 
		"INV_Axe_2h_6miningpick", 
		"INV_Axe_2h_DraenorCrafted_D_01_A", 
		"INV_Axe_2h_DraenorCrafted_D_01_B", 
		"INV_Axe_2h_DraenorCrafted_D_01_C", 
		"INV_Axe_2h_DraenorDungeon_C_01", 
		"INV_Axe_2h_DraenorHonor_C_01", 
		"INV_AXE_2H_DRAENORQUEST95_B_01", 
		"INV_Axe_2h_DraenorQuest_B_01", 
		"INV_Axe_2h_DraenorRaid_D_01", 
		"INV_Axe_2H_DreanorOgre_B_01", 
		"INV_axe_2h_garrison_a_01", 
		"INV_Axe_2H_Gorehowl_D_01_HD", 
		"INV_axe_2h_horde_D_01_HD", 
		"INV_Axe_2h_PVPDraenorS1_D_01", 
		"INV_Axe_2h_WarsongClan_C_01", 
		"INV_axe_2h_war_B_02_HD", 
	}
	GHM_StockIcons["Belt"] = {
		-- ok
		"inv_belt_01",
		"inv_belt_02",
		"inv_belt_03",
		"inv_belt_04",
		"inv_belt_05",
		"inv_belt_06",
		"inv_belt_07",
		"inv_belt_08",
		"inv_belt_09",
		"inv_belt_10",
		"inv_belt_100",
		"inv_belt_101",
		"inv_belt_102",
		"inv_belt_103",
		"inv_belt_104",
		"inv_belt_11",
		"inv_belt_12",
		"inv_belt_13",
		"inv_belt_14",
		"inv_belt_15",
		"inv_belt_16",
		"inv_belt_17",
		"inv_belt_18",
		"inv_belt_19",
		"inv_belt_20",
		"inv_belt_21",
		"inv_belt_22",
		"inv_belt_23",
		"inv_belt_24",
		"inv_belt_25",
		"inv_belt_26",
		"inv_belt_27",
		"inv_belt_28",
		"inv_belt_29",
		"inv_belt_30",
		"inv_belt_31",
		"inv_belt_32",
		"inv_belt_33",
		"inv_belt_34",
		"inv_belt_35",
		"inv_belt_36",
		"inv_belt_37",
		"inv_belt_37A",
		"inv_belt_37B",
		"inv_belt_37C",
		"inv_belt_38",
		"inv_belt_38A",
		"inv_belt_38B",
		"inv_belt_38C",
		"inv_belt_39",
		"inv_belt_39A",
		"inv_belt_39B",
		"inv_belt_39C",
		"inv_belt_40",
		"inv_belt_40A",
		"inv_belt_40B",
		"inv_belt_40C",
		"inv_belt_41",
		"inv_belt_41A",
		"inv_belt_41B",
		"inv_belt_41C",
		"inv_belt_42",
		"inv_belt_42A",
		"inv_belt_42B",
		"inv_belt_42C",
		"inv_belt_43",
		"inv_belt_43A",
		"inv_belt_43B",
		"inv_belt_43C",
		"inv_belt_44",
		"inv_belt_44A",
		"inv_belt_44B",
		"inv_belt_44C",
		"inv_belt_45",
		"inv_belt_45A",
		"inv_belt_45B",
		"inv_belt_45C",
		"inv_belt_46",
		"inv_belt_46A",
		"inv_belt_46B",
		"inv_belt_46C",
		"inv_belt_47",
		"inv_belt_47A",
		"inv_belt_47B",
		"inv_belt_47C",
		"inv_belt_48",
		"inv_belt_48A",
		"inv_belt_48B",
		"inv_belt_48C",
		"inv_belt_49",
		"inv_belt_49A",
		"inv_belt_49B",
		"inv_belt_49C",
		"inv_belt_50",
		"inv_belt_51",
		"inv_belt_52",
		"inv_belt_56",
		"inv_belt_56Purple",
		"inv_belt_56Red",
		"inv_belt_57",
		"inv_belt_57Black",
		"inv_belt_58",
		"inv_belt_59",
		"inv_belt_60",
		"inv_belt_61",
		"inv_belt_62",
		"inv_belt_63",
		"inv_belt_64",
		"inv_belt_65",
		"inv_belt_66",
		"inv_belt_66Black",
		"inv_belt_66Green",
		"inv_belt_66Purple",
		"inv_belt_67",
		"inv_belt_68",
		"inv_belt_69",
		"inv_belt_70",
		"inv_belt_71",
		"inv_belt_72",
		"inv_belt_73",
		"inv_belt_74",
		"inv_belt_77",
		"inv_belt_78",
		"inv_belt_79",
		"inv_belt_79v2",
		"inv_belt_79v3",
		"inv_belt_79v4",
		"inv_belt_80",
		"inv_belt_80v2",
		"inv_belt_80v3",
		"inv_belt_80v4",
		"inv_belt_82",
		"inv_belt_83",
		"inv_belt_84",
		"inv_belt_84v2",
		"inv_belt_84v3",
		"inv_belt_84v4",
		"inv_belt_85",
		"inv_belt_85v2",
		"inv_belt_85v3",
		"inv_belt_85v4",
		"inv_belt_86",
		"inv_belt_86v1",
		"inv_belt_86v2",
		"inv_belt_86v3",
		"inv_belt_87",
		"inv_belt_87v1",
		"inv_belt_87v2",
		"inv_belt_87v3",
		"inv_belt_88",
		"inv_belt_88v1",
		"inv_belt_88v2",
		"inv_belt_88v3",
		"inv_belt_89",
		"inv_belt_89v1",
		"inv_belt_89v2",
		"inv_belt_89v3",
		"inv_belt_90",
		"inv_belt_90v1",
		"inv_belt_90v2",
		"inv_belt_90v3",
		"inv_belt_91",
		"inv_belt_91v1",
		"inv_belt_91v2",
		"inv_belt_91v3",
		"inv_belt_92",
		"inv_belt_92v2",
		"inv_belt_92v3",
		"inv_belt_92v4",
		"inv_belt_93",
		"inv_belt_93v1",
		"inv_belt_93v2",
		"inv_belt_93v3",
		"inv_belt_94",
		"inv_belt_94v1",
		"inv_belt_94v2",
		"inv_belt_94v3",
		"inv_belt_95",
		"inv_belt_95v1",
		"inv_belt_95v2",
		"inv_belt_95v3",
		"inv_belt_96",
		"inv_belt_96v1",
		"inv_belt_96v2",
		"inv_belt_96v3",
		"inv_belt_97",
		"inv_belt_97v2",
		"inv_belt_97v3",
		"inv_belt_97v4",
		"inv_belt_98",
		"inv_belt_98v1",
		"inv_belt_98v2",
		"inv_belt_98v3",
		"inv_belt_99",
		"inv_belt_99v1",
		"inv_belt_99v2",
		"inv_belt_99v3",
		"inv_belt_Cloth_Cataclysm_B_01",
		"inv_belt_Cloth_Cataclysm_B_02",
		"inv_belt_Cloth_C_04",
		"inv_belt_Cloth_PVPMage_C_01",
		"inv_belt_Cloth_PVPMage_C_02",
		"inv_belt_Cloth_PVPWarlock_C_01",
		"inv_belt_Cloth_PVPWarlock_C_02",
		"inv_belt_Cloth_RaidPriest_I_01",
		"inv_belt_Cloth_RaidWarlock_I_01",
		"inv_belt_LeatherRaidRogue_I_01",
		"inv_belt_Leather_Cataclysm_B_01",
		"inv_belt_Leather_Cataclysm_B_02",
		"INV_Belt_Leather_DungeonLeather_C_05",
		"inv_belt_Leather_FirelandsDruid_D_01",
		"inv_belt_Leather_PVPDruid_C_01",
		"inv_belt_Leather_PVPDruid_C_02",
		"INV_Belt_Leather_PVPDruid_D_01",
		"inv_belt_Leather_PVPRogue_C_01",
		"inv_belt_Leather_PVPRogue_C_02",
		"INV_Belt_Leather_PVPRogue_D_01",
		"inv_belt_Leather_RaidDruid_I_01",
		"inv_belt_Leather_RaidDruid_J_01",
		"INV_Belt_Leather_RaidDruid_K_01",
		"inv_belt_Leather_RaidRogue_J_01",
		"INV_Belt_Leather_RaidRogue_K_01",
		"inv_belt_Mail_DungeonMail_C_03",
		"inv_belt_Mail_DungeonMail_C_04",
		"inv_belt_Mail_PVPHunter_C_01",
		"inv_belt_Mail_PVPHunter_C_02",
		"INV_Belt_Mail_PVPHunter_D_01",
		"inv_belt_Mail_PVPShaman_C_01",
		"inv_belt_Mail_PVPShaman_C_02",
		"INV_Belt_Mail_PVPShaman_D_01",
		"inv_belt_Mail_RaidHunter_I_01",
		"inv_belt_Mail_RaidHunter_J_01",
		"INV_Belt_Mail_RaidHunter_K_01",
		"inv_belt_Mail_RaidShaman_I_01",
		"inv_belt_Mail_RaidShaman_J_01",
		"INV_Belt_Mail_RaidShaman_K_01",
		"inv_belt_Plate_Cataclysm_B_02",
		"inv_belt_Plate_DungeonPlate_C_03",
		"inv_belt_Plate_DungeonPlate_C_04",
		"INV_Belt_Plate_DungeonPlate_C_06",
		"inv_belt_Plate_PVPDeathKnight_C_01",
		"inv_belt_Plate_PVPDeathKnight_C_02",
		"INV_Belt_Plate_PVPDeathKnight_D_01",
		"inv_belt_Plate_PVPPaladin_C_01",
		"inv_belt_Plate_PVPPaladin_C_02",
		"INV_Belt_Plate_PVPPaladin_D_01",
		"inv_belt_Plate_PVPWarrior_C_01",
		"inv_belt_Plate_PVPWarrior_C_02",
		"INV_Belt_Plate_PVPWarrior_D_01",
		"inv_belt_Plate_RaidDeathKnight_I_01",
		"inv_belt_Plate_RaidDeathKnight_J_01",
		"inv_belt_Plate_RaidPaladin_I_01",
		"inv_belt_Plate_RaidPaladin_J_01",
		"INV_Belt_Plate_RaidPaladin_K_01",
		"inv_belt_Plate_RaidWarrior_I_01",
		"inv_belt_Plate_RaidWarrior_J_01",
		"INV_Belt_Plate_RaidWarrior_K_01",
		"inv_belt_Plate_TwilightHammer_C_01",
		"inv_belt_Robe_Common_C_01",
		"inv_belt_Robe_Common_C_01v1",
		"inv_belt_Robe_Common_C_01v2",
		"inv_belt_Robe_Common_C_01v3",
		"inv_belt_Robe_DungeonRobe_C_03",
		"inv_belt_Robe_DungeonRobe_C_04",
		"INV_Belt_Robe_DungeonRobe_C_05",
		"INV_Belt_Robe_PVPMage_D_01",
		"inv_belt_Robe_PVPPriest_C_01",
		"inv_belt_Robe_PVPPriest_C_02",
		"INV_Belt_Robe_PVPPriest_D_01",
		"INV_Belt_Robe_PVPWarlock_D_01",
		"inv_belt_Robe_RaidMage_I_01",
		"inv_belt_Robe_RaidMage_J_01",
		"INV_Belt_Robe_RaidMage_K_01",
		"inv_belt_Robe_RaidPriest_J_01",
		"INV_Belt_Robe_RaidPriest_K_01",
		"inv_belt_Robe_RaidWarlock_J_01",
		"INV_Belt_Robe_RaidWarlock_K_01",
		"INV_Belt_Mail_DungeonMail_C_05",
		"INV_Belt_Plate_DungeonPlate_C_05",
		"Plate_RaidDeathKnight_K_01_Belt",
		"INV_Belt_ChallengeDruid_D_01", 
		"INV_Belt_Cloth_ChallengeMage_D_01", 
		"INV_Belt_Cloth_ChallengePriest_D_01", 
		"INV_Belt_Cloth_DungeonCloth_C_06", 
		"INV_Belt_Cloth_Panda_B_01", 
		"INV_Belt_Cloth_Panda_B_01_Green", 
		"INV_Belt_Cloth_Panda_B_01_Red", 
		"INV_Belt_Cloth_Panda_B_02", 
		"INV_Belt_Cloth_Panda_B_02_Blue", 
		"INV_Belt_Cloth_Panda_B_02_White", 
		"INV_Belt_Cloth_Panstart_A_01", 
		"INV_Belt_Cloth_RaidPriest_L_01", 
		"INV_Belt_Cloth_RaidWarlock_L_01", 
		"INV_Belt_Cloth_Reputation_C_01", 
		"INV_Belt_Leather_ChallengeMonk_D_01", 
		"INV_Belt_Leather_ChallengeRogue_D_01", 
		"INV_Belt_Leather_DungeonLeather_C_06", 
		"INV_Belt_Leather_Panda_B_01", 
		"INV_Belt_Leather_Panda_B_01Dark", 
		"INV_Belt_Leather_Panda_B_01Light", 
		"INV_Belt_Leather_Panda_B_01Red", 
		"INV_Belt_Leather_Panda_B_02", 
		"INV_Belt_Leather_Panda_B_02_Brown", 
		"INV_Belt_Leather_Panda_B_02_Crimson", 
		"INV_Belt_Leather_Panda_B_02_Indigo", 
		"INV_Belt_Leather_PanProg_B_01", 
		"INV_Belt_Leather_PVPDruid_E_01", 
		"INV_Belt_Leather_PVPMonk_E_01", 
		"INV_Belt_Leather_PVPRogue_E_01", 
		"INV_Belt_Leather_RaidDruid_L_01", 
		"INV_Belt_Leather_RaidMonk_L_01", 
		"INV_Belt_Leather_RaidRogue_L_01", 
		"INV_Belt_Leather_Reputation_C_01", 
		"INV_Belt_Mail_ChallengeHunter_D_01", 
		"INV_Belt_Mail_ChallengeShaman_D_01", 
		"INV_Belt_Mail_DungeonMail_C_06", 
		"INV_Belt_Mail_Panda_B_01", 
		"INV_Belt_Mail_Panda_B_01Green", 
		"INV_Belt_Mail_Panda_B_01White", 
		"INV_Belt_Mail_Panda_B_02", 
		"INV_Belt_Mail_PanProg_B_01", 
		"INV_Belt_Mail_PVPHunter_E_01", 
		"INV_Belt_Mail_PVPShaman_E_01", 
		"INV_Belt_Mail_RaidHunter_L_01", 
		"INV_Belt_Mail_RaidShaman_L_01", 
		"INV_Belt_Mail_Reputation_C_01", 
		"INV_Belt_Plate_ChallengeDeathKnight_D_01", 
		"INV_Belt_Plate_ChallengePaladin_D_01", 
		"INV_Belt_Plate_ChallengeWarrior_D_01", 
		"INV_Belt_Plate_DungeonPlate_C_07", 
		"INV_Belt_Plate_Panda_B_01", 
		"INV_Belt_Plate_Panda_B_01Blue", 
		"INV_Belt_Plate_Panda_B_01Gold", 
		"INV_Belt_Plate_Panda_B_02", 
		"INV_Belt_Plate_Panda_B_02Green", 
		"INV_Belt_Plate_Panda_B_02Purple", 
		"INV_Belt_Plate_Panda_B_02Yellow", 
		"INV_Belt_Plate_PVPDeathKnight_E_01", 
		"INV_Belt_Plate_PVPPaladin_E_01", 
		"INV_Belt_Plate_PVPWarrior_E_01", 
		"INV_Belt_Plate_RaidDeathKnight_L_01", 
		"INV_Belt_Plate_RaidPaladin_L_01", 
		"INV_Belt_Plate_RaidWarrior_L_01", 
		"INV_Belt_Plate_Reputation_C_01", 
		"INV_Belt_PVPPriest_E_01", 
		"INV_Belt_PVPWarlock_E_01", 
		"INV_Belt_RaidMage_L_01", 
		"INV_Belt_Robe_Panda_A_02", 
		"INV_Belt_Robe_PanProg_B_01", 
		"INV_Belt_Robe_PVPMage_E_01", 
		"INV_Robe_Cloth_RaidPriest_L_01", 
		"INV_Robe_Leather_PVPDruid_E_01", 
		"INV_Robe_Leather_RaidDruid_L_01", 
		"INV_Robe_Mail_RaidShaman_L_01", 
		"INV_Robe_RaidMage_L_01", 
		"INV_Belt_Cloth_PVPMage_F_01", 
		"INV_Belt_Cloth_PVPPriest_F_01", 
		"INV_Belt_Cloth_RaidMage_M_01", 
		"INV_Belt_Cloth_RaidWarlock_M_01", 
		"INV_Belt_Leather_PVPMonk_F_01", 
		"INV_Belt_Leather_PVPRogue_F_01", 
		"INV_Belt_Leather_RaidMonk_M_01", 
		"INV_Belt_Leather_RaidRogue_M_01", 
		"INV_Belt_Mail_PVPHunter_F_01", 
		"INV_Belt_Mail_PVPShaman_F_01", 
		"INV_Belt_Mail_RaidHunter_M_01", 
		"INV_Belt_Mail_RaidShaman_M_01", 
		"INV_Belt_Plate_DeathKnight_M_01", 
		"INV_Belt_Plate_PVPDeathKnight_F_01", 
		"INV_Belt_Plate_PVPPaladin_F_01Bronze", 
		"INV_Belt_Plate_PVPPaladin_F_01Red", 
		"INV_Belt_Plate_PVPPaladin_F_01White", 
		"INV_Belt_Plate_RaidPaladin_M_01", 
		"INV_Belt_Plate_RaidWarrior_M_01", 
		"INV_Belt_PVPWarrior_F_01", 
		"INV_Cloth_RaidPriest_M_01Belt", 
		"INV_Belt_Cloth_PVPPriest_G_01", 
		"INV_Belt_Cloth_RaidMage_N_01", 
		"INV_Belt_Cloth_RaidWarlock_N_01", 
		"INV_Belt_Leather_PVPMonk_G_01", 
		"INV_Belt_Leather_PVPRogue_G_01", 
		"INV_Belt_Leather_RaidMonk_N_01", 
		"INV_Belt_Leather_RaidRogue_N_01", 
		"INV_Belt_Mail_KorKronShaman_D_01", 
		"INV_Belt_Mail_PVPHunter_G_01", 
		"INV_Belt_Mail_PVPShaman_G_01", 
		"INV_Belt_Mail_RaidHunter_N_01", 
		"INV_Belt_Plate_PVPPaladin_G_01", 
		"INV_Belt_Plate_RaidDeathKnight_N_01", 
		"Inv_Belt_Plate_RaidWarrior_N_01", 
		"INV_Buckle_Cloth_PVPMage_G_01", 
		"INV_Buckle_Leather_PVPDruid_G_01", 
		"INV_Buckle_Leather_PVPRogue_G_01", 
		   
		"INV_Cloth_PVPWarlock_G_01Belt", 
		"INV_Cloth_RaidPriest_N_01Belt",
		"INV_Leather_RaidDruid_N_01Belt", 
		"INV_Mail_RaidShaman_N_01Belt",  
		"INV_Plate_PVPDeathKnight_G_01_BELT", 
		"INV_Plate_PVPWarrior_G_01Belt", 
		"INV_Plate_RaidPaladin_N_01Belt",
		 "INV_Belt_Cloth_Draenei_C_01", 
		"INV_Belt_Cloth_DraenorHonor_C_01", 
		"INV_Belt_Cloth_DraenorLFR_C_01", 
		"INV_Belt_Cloth_DraenorQuest90_B_01", 
		"INV_Belt_Cloth_PVPMageGladiator_O_01", 
		"INV_Belt_Cloth_PVPMage_O_01", 
		"INV_Belt_Cloth_PVPPriestGladiator_O_01", 
		"INV_Belt_Cloth_PVPPriest_O_01", 
		"INV_Belt_Cloth_PVPWarlock_O_01", 
		"INV_Belt_Cloth_RaidMageMythic_O_01", 
		"INV_Belt_Cloth_RaidMage_O_01", 
		"INV_Belt_Cloth_RaidPriestMythic_O_01", 
		"INV_Belt_Cloth_RaidPriest_O_01", 
		"INV_Belt_Cloth_ShadowmoonClan_B_01", 
		"INV_Belt_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Belt_Leather_DraenorCrafted_D_01_Horde", 
		"INV_Belt_Leather_DraenorQuest90_B_01", 
		"INV_Belt_Leather_PvPMonkGladiator_O_01", 
		"INV_Belt_Leather_PvPMonk_O_01", 
		"INV_Belt_Leather_PvPRogueGladiator_O_01", 
		"INV_Belt_Leather_PVPRogue_O_01", 
		"INV_belt_Mail_DraenorCrafted_D_01_alliance", 
		"INV_belt_Mail_DraenorCrafted_D_01_Horde", 
		"INV_Belt_Mail_DraenorDungeon_C_01", 
		"INV_belt_Mail_DraenorHonor_C_01", 
		"INV_belt_Mail_DraenorLFR_C_01", 
		"INV_Belt_Mail_DraenorQuest95_B_01", 
		"INV_Belt_Mail_PvPHunterGladiator_O_01", 
		"INV_BELT_Mail_PVPHunter_O_01", 
		"INV_Belt_Mail_PvPShamanGladiator_O_01", 
		"INV_Belt_Mail_PVPShaman_O_01", 
		"INV_belt_Mail_RaidHunterMythic_O_01", 
		"INV_belt_Mail_RaidHunter_O_01", 
		"INV_belt_Mail_RaidShamanMythic_O_01", 
		"INV_Belt_Mail_RaidShaman_O_01", 
		"INV_Belt_Mail_WarsongClan_B_01", 
		"INV_Belt_Pant_Plate_PvPDeathKnightGladiator_O_01", 
		"INV_Belt_plate_draenordungeon_c_01", 
		"INV_Belt_Plate_DraenorHonor_C_01", 
		"INV_Belt_Plate_DraenorQuest95_B_01", 
		"INV_Belt_Plate_PvPDeathKnight_O_01", 
		"INV_Belt_Plate_PVPPaladinGladiator_O_01", 
		"INV_Belt_Plate_PVPPaladin_O_01", 
		"INV_Belt_Plate_RaidPaladinMythic_O_01", 
		"INV_Belt_Plate_RaidPaladin_O_01", 
		"INV_Buckle_Leather_DraenorLFR_C_01", 
		"INV_buckle_Mail_DraenorHonor_C_01", 
		"INV_buckle_Mail_DraenorLFR_C_01", 
		"INV_Cloth_DraenorCrafted_D_01Belt", 
		"INV_Cloth_DraenorCrafted_D_01Belt_Horde",  
		"INV_Cloth_DraenorDungeon_C_01Buckle", 
		"INV_Cloth_DraenorQuest95_B_01Belt", 
		"INV_Cloth_RaidWarlockMythic_O_01Belt",  
		"INV_Cloth_RaidWarlock_O_01Belt", 
		"INV_Leather_DraenorDungeon_C_01Belt", 
 "INV_Leather_DraenorHonor_C_01Buckle", 
 "INV_Leather_DraenorQuest95_B_01Belt", 
 "INV_Leather_PvPDruidGladiator_O_01Buckle", 
  "INV_Leather_PvPDruid_O_01Buckle", 
 "INV_Leather_RaidDruidMythic_O_01Buckle",
 "INV_Leather_RaidDruid_O_01Buckle",
 "INV_Leather_RaidRogueMythic_O_01Buckle",  
  "INV_Leather_RaidRogue_O_01Buckle", 
  "INV_Leather_RaidMonk_O_01Belt", 
   "INV_Mail_DraenorQuest90_B_01Belt", 
    "INV_Mail_ThunderLordClan_B_01Belt", 
    "INV_Plate_BlackrockClan_B_01Buckle", 
    "INV_Plate_DraenorCrafted_D_01Buckle", 
    "INV_Plate_DraenorLFR_C_01Belt", 
    "INV_Plate_DraenorQuest90_B_01Belt",
	 "INV_Plate_Plate_PvPWarriorGladaitor_O_01Belt",
	 "INV_Plate_Plate_PvPWarrior_O_01Belt", 
	 "INV_Plate_RaidDeathKnightMythic_O_01Buckle", 
	 "INV_Plate_RaidDeathKnight_O_01Buckle",
   
   }
	GHM_StockIcons["Boots"] = {
		-- ok
		"inv_boot_Leather_PVPDruid_C_02",
		"inv_boots_01",
		"inv_boots_02",
		"inv_boots_03",
		"inv_boots_04",
		"inv_boots_05",
		"inv_boots_06",
		"inv_boots_07",
		"inv_boots_08",
		"inv_bootS_09",
		"inv_boots_Chain_01",
		"inv_boots_Chain_02",
		"inv_boots_Chain_03",
		"inv_boots_Chain_04",
		"inv_boots_Chain_05",
		"inv_boots_Chain_06",
		"inv_boots_Chain_07",
		"inv_boots_Chain_08",
		"inv_boots_Chain_09",
		"inv_boots_Chain_10",
		"inv_boots_Chain_11",
		"inv_boots_Chain_12",
		"inv_boots_Chain_13",
		"inv_boots_Christmas01",
		"inv_boots_Cloth_01",
		"inv_boots_Cloth_02",
		"inv_boots_Cloth_03",
		"inv_boots_Cloth_04",
		"inv_boots_Cloth_05",
		"inv_boots_Cloth_06",
		"inv_boots_Cloth_07",
		"inv_boots_Cloth_08",
		"inv_boots_Cloth_09",
		"inv_boots_Cloth_10",
		"inv_boots_Cloth_11",
		"inv_boots_Cloth_12",
		"inv_boots_Cloth_13",
		"inv_boots_Cloth_14",
		"inv_boots_Cloth_15",
		"inv_boots_Cloth_16",
		"inv_boots_Cloth_17",
		"inv_boots_Cloth_18",
		"inv_boots_Cloth_19",
		"inv_boots_Cloth_20",
		"inv_boots_Cloth_21",
		"inv_boots_Cloth_22",
		"inv_boots_Cloth_23",
		"inv_boots_Cloth_24",
		"inv_boots_Cloth_25",
		"inv_boots_Cloth_25Black",
		"inv_boots_Cloth_25Green",
		"inv_boots_Cloth_25Purple",
		"inv_boots_Cloth_26",
		"inv_boots_Cloth_27",
		"inv_boots_Cloth_28",
		"inv_boots_Cloth_29",
		"inv_boots_Cloth_30",
		"inv_boots_Cloth_31",
		"inv_boots_Cloth_31v2",
		"inv_boots_Cloth_31v3",
		"inv_boots_Cloth_31v4",
		"inv_boots_Cloth_32",
		"inv_boots_Cloth_33",
		"inv_boots_Cloth_33v2",
		"inv_boots_Cloth_33v3",
		"inv_boots_Cloth_33v4",
		"inv_boots_Cloth_34",
		"inv_boots_Cloth_34v2",
		"inv_boots_Cloth_34v3",
		"inv_boots_Cloth_34v4",
		"inv_boots_Cloth_35",
		"inv_boots_Cloth_35v2",
		"inv_boots_Cloth_35v3",
		"inv_boots_Cloth_35v4",
		"inv_boots_Cloth_Cataclysm_B_01",
		"inv_boots_Cloth_Cataclysm_B_02",
		"inv_boots_Cloth_PVPMage_C_01",
		"inv_boots_Cloth_PVPMage_C_02",
		"inv_boots_Cloth_PVPWarlock_C_01",
		"inv_boots_Cloth_PVPWarlock_C_02",
		"inv_boots_Cloth_RaidPriest_I_01",
		"inv_boots_Cloth_RaidWarlock_I_01",
		"inv_boots_Fabric_01",
		"inv_boots_Leather01",
		"inv_boots_Leather_02",
		"inv_boots_Leather_03A",
		"inv_boots_Leather_03B",
		"inv_boots_Leather_04A",
		"inv_boots_Leather_04B",
		"inv_boots_Leather_05",
		"inv_boots_Leather_05Purple",
		"inv_boots_Leather_05Red",
		"inv_boots_Leather_07",
		"inv_boots_Leather_10",
		"inv_boots_Leather_10v2",
		"inv_boots_Leather_10v3",
		"inv_boots_Leather_10v4",
		"inv_boots_Leather_11",
		"inv_boots_Leather_11v1",
		"inv_boots_Leather_11v2",
		"inv_boots_Leather_11v3",
		"inv_boots_Leather_12",
		"inv_boots_Leather_12v1",
		"inv_boots_Leather_12v2",
		"inv_boots_Leather_12v3",
		"inv_boots_Leather_13",
		"inv_boots_Leather_13v1",
		"inv_boots_Leather_13v2",
		"inv_boots_Leather_13v3",
		"inv_boots_Leather_14",
		"inv_boots_Leather_14v1",
		"inv_boots_Leather_14v2",
		"inv_boots_Leather_14v3",
		"inv_boots_Leather_15",
		"inv_boots_Leather_16",
		"inv_boots_Leather_6",
		"inv_boots_Leather_8",
		"inv_boots_Leather_9",
		"inv_boots_Leather_Cataclysm_B_01",
		"inv_boots_Leather_Cataclysm_B_02",
		"INV_Boots_Leather_DungeonLeather_C_05",
		"inv_boots_Leather_FirelandsDruid_D_01",
		"inv_boots_Leather_PVPDruid_C_01",
		"INV_Boots_Leather_PVPDruid_D_01",
		"inv_boots_Leather_PVPRogue_C_01",
		"inv_boots_Leather_RaidDruid_I_01",
		"inv_boots_Leather_RaidDruid_J_01",
		"INV_Boots_Leather_RaidRogue_K_01",
		"inv_boots_Mail_01",
		"inv_boots_Mail_02",
		"inv_boots_Mail_04",
		"inv_boots_Mail_04Black",
		"inv_boots_Mail_04Silver",
		"inv_boots_Mail_05",
		"inv_boots_Mail_06",
		"inv_boots_Mail_07",
		"inv_boots_Mail_08",
		"inv_boots_Mail_10",
		"inv_boots_Mail_11",
		"inv_boots_Mail_11v2",
		"inv_boots_Mail_11v3",
		"inv_boots_Mail_11v4",
		"inv_boots_Mail_12",
		"inv_boots_Mail_12v1",
		"inv_boots_Mail_12v2",
		"inv_boots_Mail_12v3",
		"inv_boots_Mail_13",
		"inv_boots_Mail_13v1",
		"inv_boots_Mail_13v2",
		"inv_boots_Mail_13v3",
		"inv_boots_Mail_14",
		"inv_boots_Mail_14v1",
		"inv_boots_Mail_14v2",
		"inv_boots_Mail_14v3",
		"inv_boots_Mail_15",
		"inv_boots_Mail_15v1",
		"inv_boots_Mail_15v2",
		"inv_boots_Mail_15v3",
		"inv_boots_Mail_16",
		"inv_boots_Mail_17",
		"inv_boots_Mail_DungeonMail_C_03",
		"inv_boots_Mail_DungeonMail_C_04",
		"inv_boots_Mail_PVPHunter_C_01",
		"inv_boots_Mail_PVPHunter_C_02",
		"INV_Boots_Mail_PVPHunter_D_01",
		"inv_boots_Mail_PVPShaman_C_01",
		"inv_boots_Mail_PVPShaman_C_02",
		"INV_Boots_Mail_PVPShaman_D_01",
		"inv_boots_Mail_RaidHunter_I_01",
		"inv_boots_Mail_RaidHunter_J_01",
		"INV_Boots_Mail_RaidHunter_K_01",
		"inv_boots_Mail_RaidShaman_J_01",
		"INV_Boots_Mail_RaidShaman_K_01",
		"inv_boots_Plate_01",
		"inv_boots_Plate_02",
		"inv_boots_Plate_03",
		"inv_boots_Plate_04",
		"inv_boots_Plate_05",
		"inv_boots_Plate_06",
		"inv_boots_Plate_07",
		"inv_boots_Plate_08",
		"inv_boots_Plate_09",
		"inv_boots_Plate_10",
		"inv_boots_Plate_11",
		"inv_boots_Plate_12",
		"inv_boots_Plate_13",
		"inv_boots_Plate_14",
		"inv_boots_Plate_15",
		"inv_boots_Plate_18",
		"inv_boots_Plate_19",
		"inv_boots_Plate_19v1",
		"inv_boots_Plate_19v2",
		"inv_boots_Plate_19v3",
		"inv_boots_Plate_20",
		"inv_boots_Plate_20v1",
		"inv_boots_Plate_20v2",
		"inv_boots_Plate_20v3",
		"inv_boots_Plate_21",
		"inv_boots_Plate_21v1",
		"inv_boots_Plate_21v2",
		"inv_boots_Plate_21v3",
		"inv_boots_Plate_22",
		"inv_boots_Plate_22v1",
		"inv_boots_Plate_22v2",
		"inv_boots_Plate_22v3",
		"inv_boots_Plate_23",
		"inv_boots_Plate_Cataclysm_B_02",
		"inv_boots_Plate_DungeonPlate_C_03",
		"inv_boots_Plate_DungeonPlate_C_04",
		"INV_Boots_Plate_DungeonPlate_C_05",
		"INV_Boots_Plate_DungeonPlate_C_06",
		"inv_boots_Plate_D_02Gold",
		"inv_boots_Plate_PVPDeathKnight_C_01",
		"inv_boots_Plate_PVPDeathKnight_C_02",
		"INV_Boots_Plate_PVPDeathKnight_D_01",
		"inv_boots_Plate_PVPPaladin_C_01",
		"inv_boots_Plate_PVPPaladin_C_02",
		"INV_Boots_Plate_PVPPaladin_D_01",
		"inv_boots_Plate_PVPWarrior_C_01",
		"inv_boots_Plate_PVPWarrior_C_02",
		"INV_Boots_Plate_PVPWarrior_D_01",
		"inv_boots_Plate_RaidDeathKnight_I_01",
		"inv_boots_Plate_RaidPaladin_I_01",
		"inv_boots_Plate_RaidPaladin_J_01",
		"INV_Boots_Plate_RaidPaladin_K_01",
		"inv_boots_Plate_RaidWarrior_J_01",
		"INV_Boots_Plate_RaidWarrior_K_01",
		"inv_boots_Plate_TwilightHammer_C_01",
		"inv_boots_RaidShaman_I_01",
		"inv_boots_RaidWarrior_I_01",
		"inv_boots_Robe_Common_C_01",
		"inv_boots_Robe_Common_C_01v1",
		"inv_boots_Robe_Common_C_01v2",
		"inv_boots_Robe_Common_C_01v3",
		"inv_boots_Robe_DungeonRobe_C_03",
		"inv_boots_Robe_DungeonRobe_C_04",
		"INV_Boots_Robe_DungeonRobe_C_05",
		"inv_boots_Robe_PVPPriest_C_01",
		"inv_boots_Robe_PVPPriest_C_02",
		"INV_Boots_Robe_PVPWarlock_D_01",
		"inv_boots_Robe_RaidMage_I_01",
		"inv_boots_Robe_RaidMage_J_01",
		"INV_Boots_Robe_RaidMage_K_01",
		"inv_boots_Robe_RaidPriest_J_01",
		"INV_Boots_Robe_RaidPriest_K_01",
		"inv_boots_Robe_RaidWarlock_J_01",
		"INV_Boots_Robe_RaidWarlock_K_01",
		"inv_boots_Wolf",
		"inv_boot_LeatherRaidRogue_I_01",
		"inv_boot_Leather_PVPRogue_C_02",
		"INV_Boot_Leather_PVPRogue_D_01",
		"INV_Boot_Leather_RaidDruid_K_01",
		"inv_boot_Leather_RaidRogue_J_01",
		"inv_boot_Plate_RaidDeathKnight_J_01",
		"INV_Boot_Robe_PVPMage_D_01",
		"INV_Boot_Robe_PVPPriest_D_01",
		"Plate_RaidDeathKnight_K_01_Boot",
		"INV_Boots_Cloth_ChallengePriest_D_01", 
		"INV_Boots_Cloth_DungeonCloth_C_06", 
		"INV_Boots_Cloth_Panda_B_01", 
		"INV_Boots_Cloth_Panda_B_01_Green", 
		"INV_Boots_Cloth_Panda_B_01_Red", 
		"INV_Boots_Cloth_Panda_B_02", 
		"INV_Boots_Cloth_Panda_B_02_Blue", 
		"INV_Boots_Cloth_Panda_B_02_White", 
		"INV_Boots_Cloth_Reputation_C_01", 
		"INV_Boots_Leather_ChallengeMonk_D_01", 
		"INV_Boots_Leather_ChallengeRogue_D_01", 
		"INV_Boots_Leather_DungeonLeather_C_06", 
		"INV_Boots_Leather_Panda_B_01", 
		"INV_Boots_Leather_Panda_B_01Dark", 
		"INV_Boots_Leather_Panda_B_01Light", 
		"INV_Boots_Leather_Panda_B_01Red", 
		"INV_Boots_Leather_Panda_B_02", 
		"INV_Boots_Leather_Panda_B_02_Brown", 
		"INV_Boots_Leather_Panda_B_02_Crimson", 
		"INV_Boots_Leather_Panda_B_02_Indigo", 
		"INV_Boots_Leather_PVPMonk_E_01", 
		"INV_Boots_Leather_PVPRogue_E_01", 
		"INV_Boots_Leather_RaidDruid_L_01", 
		"INV_Boots_Mail_Panda_B_01", 
		"INV_Boots_Mail_Panda_B_01Green", 
		"INV_Boots_Mail_Panda_B_01White", 
		"INV_Boots_Mail_Panda_B_02", 
		"INV_Boots_Mail_PVPShaman_E_01", 
		"INV_Boots_Mail_RaidShaman_L_01", 
		"INV_Boots_Plate_ChallengeDeathKnight_D_01", 
		"INV_Boots_Plate_DungeonPlate_C_07", 
		"INV_Boots_Plate_Panda_B_02", 
		"INV_Boots_Plate_Panda_B_02Green", 
		"INV_Boots_Plate_Panda_B_02Purple", 
		"INV_Boots_Plate_Panda_B_02Yellow", 
		"INV_Boots_Plate_PVPPaladin_E_01", 
		"INV_Boots_Plate_PVPWarrior_E_01", 
		"INV_Boots_Plate_RaidDeathKnight_L_01", 
		"INV_Boots_Plate_RaidWarrior_L_01", 
		"INV_Boots_PVPPriest_E_01", 
		"INV_Boots_PVPWarlock_E_01", 
		"INV_Boots_Robe_Panda_A_02", 
		"INV_Boots_Robe_PanProg_B_01", 
		"INV_Boot_Bracer_RaidMage_L_01", 
		"INV_Boot_Cloth_ChallengeMage_D_01", 
		"INV_Boot_Cloth_RaidPriest_L_01", 
		"INV_Boot_Cloth_RaidWarlock_L_01", 
		"INV_Boot_Leather_PanProg_B_01", 
		"INV_Boot_Leather_PVPDruid_E_01", 
		"INV_Boot_Leather_RaidMonk_L_01", 
		"INV_Boot_Leather_RaidRogue_L_01", 
		"INV_Boot_Leather_Reputation_C_01", 
		"INV_Boot_Mail_ChallengeHunter_D_01", 
		"INV_Boot_Mail_ChallengeShaman_D_01", 
		"INV_Boot_Mail_DungeonMail_C_06", 
		"INV_Boot_Mail_PanProg_B_01", 
		"INV_Boot_Mail_PVPHunter_E_01", 
		"INV_Boot_Mail_RaidHunter_L_01", 
		"INV_Boot_Mail_Reputation_C_01", 
		"INV_Boot_Plate_ChallengePaladin_D_01", 
		"INV_Boot_Plate_ChallengeWarrior_D_01", 
		"INV_Boot_Plate_Panda_B_01", 
		"INV_Boot_Plate_Panda_B_01Blue", 
		"INV_Boot_Plate_Panda_B_01Gold", 
		"INV_Boot_Plate_PVPDeathKnight_E_01", 
		"INV_Boot_Plate_RaidPaladin_L_01", 
		 "INV_Boot_Plate_Reputation_C_01", 
		"INV_Boot_Robe_PVPMage_E_01",
		"INV_Boots_Cloth_PVPMage_F_01", 
		"INV_Boots_Leather_PVPRogue_F_01", 
		"INV_Boots_Mail_PVPShaman_F_01", 
		"INV_Boots_Plate_DeathKnight_M_01", 
		"INV_Boots_Plate_PVPDeathKnight_F_01", 
		"INV_Boots_Plate_PVPPaladin_F_01Bronze", 
		"INV_Boots_Plate_PVPPaladin_F_01Red", 
		"INV_Boots_Plate_PVPPaladin_F_01White", 
		"INV_Boots_Plate_RaidWarrior_M_01", 
		"INV_Boots_PVPWarrior_F_01", 
		"INV_Boot_Cloth_PVPPriest_F_01", 
		"INV_Boot_Cloth_RaidMage_M_01", 
		"INV_Boot_Cloth_RaidWarlock_M_01", 
		"INV_Boot_Leather_PVPMonk_F_01", 
		"INV_Boot_Leather_RaidMonk_M_01", 
		"INV_Boot_Leather_RaidRogue_M_01", 
		"INV_Boot_Mail_RaidHunter_M_01", 
		"INV_Boot_Mail_RaidShaman_M_01", 
		"INV_Boot_Plate_RaidPaladin_M_01",
 		
		"INV_Cloth_PVPWarlock_F_01Boot", 

		"INV_Cloth_RaidPriest_M_01Boot", 
		"INV_Leather_RaidDruid_M_01Boot", 

		"INV_Boots_Leather_PVPRogue_G_01", 
		"INV_Boots_Mail_PVPHunter_G_01", 
		"INV_Boots_Plate_DeathKnight_M_01", 
		"INV_Boots_Plate_RaidDeathKnight_N_01", 
		"Inv_Boots_Plate_RaidWarrior_N_01", 
		"INV_Boot_Cloth_PVPMage_G_01", 
		"INV_Boot_Cloth_PVPPriest_G_01", 
		"INV_Boot_Cloth_RaidMage_N_01", 
		"INV_Boot_Cloth_RaidWarlock_N_01", 
		"INV_Boot_Leather_PVPDruid_G_01", 
		"INV_Boot_Leather_PVPMonk_G_01", 
		"INV_Boot_Leather_RaidMonk_N_01", 
		"INV_Boot_Leather_RaidRogue_N_01", 
		"INV_Boot_Mail_KorKronShaman_D_01", 
		"INV_Boot_Mail_PVPShaman_G_01", 
		"INV_Boot_Mail_RaidHunter_N_01", 
		"INV_Boot_Plate_PVPPaladin_G_01", 
		"INV_Cloth_PVPWarlock_G_01Boot", 
		"INV_Cloth_RaidPriest_N_01Boot", 
		"INV_Leather_RaidDruid_N_01Boot", 
		"INV_Mail_RaidShaman_N_01Boot",  
		"INV_Plate_PVPDeathKnight_G_01_BOOT", 
		"INV_Plate_PVPWarrior_G_01Boot", 
		"INV_Plate_RaidPaladin_N_01Boot",
		"INV_Boot_Cloth_Draenei_C_01", 
		"INV_Boot_Cloth_DraenorHonor_C_01", 
		"INV_Boot_Cloth_DraenorLFR_C_01", 
		"INV_Boot_Cloth_DraenorQuest90_B_01", 
		"INV_Boot_Cloth_PVPMageGladiator_O_01", 
		"INV_Boot_Cloth_PVPMage_O_01", 
		"INV_Boot_Cloth_PVPPriestGladiator_O_01", 
		"INV_Boot_Cloth_PVPPriest_O_01", 
		"INV_Boot_Cloth_PVPWarlock_O_01", 
		"INV_Boot_Cloth_RaidMageMythic_O_01", 
		"INV_Boot_Cloth_RaidMage_O_01", 
		"INV_Boot_Cloth_RaidPriestMythic_O_01", 
		"INV_Boot_Cloth_RaidPriest_O_01", 
		"INV_Boot_Cloth_ShadowmoonClan_B_01", 
		"INV_Boot_helm_draenordungeon_c_01", 
		"INV_Boot_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Boot_Leather_DraenorCrafted_D_01_Horde", 
		"INV_Boot_Leather_DraenorLFR_C_01", 
		"INV_Boot_Leather_DraenorQuest90_B_01", 
		"INV_Boot_Leather_PvPMonkGladiator_O_01", 
		"INV_Boot_Leather_PvPMonk_O_01", 
		"INV_Boot_Leather_PvPRogueGladiator_O_01", 
		"INV_Boot_Leather_PVPRogue_O_01", 
		"INV_boot_Mail_DraenorCrafted_D_01_alliance", 
		"INV_boot_Mail_DraenorCrafted_D_01_horde", 
		"INV_Boot_Mail_DraenorDungeon_C_01", 
		"INV_boot_Mail_DraenorHonor_C_01", 
		"INV_boot_Mail_DraenorLFR_C_01", 
		"INV_Boot_Mail_DraenorQuest95_B_01", 
		"INV_Boot_Mail_PvPHunterGladiator_O_01", 
		"INV_BOOT_Mail_PVPHunter_O_01", 
		"INV_Boot_Mail_PvPShamanGladiator_O_01", 
		"INV_Boot_Mail_PVPShaman_O_01", 
		"INV_boot_Mail_RaidHunterMythic_O_01", 
		"INV_BOOT_Mail_RaidHunter_O_01", 
		"INV_boot_Mail_RaidShamanMythic_O_01", 
		"INV_Boot_Mail_RaidShaman_O_01", 
		"INV_Boot_Mail_WarsongClan_B_01", 
		"INV_Boot_plate_draenordungeon_c_01", 
		"INV_Boot_Plate_DraenorHonor_C_01", 
		"INV_Boot_Plate_DraenorQuest95_B_01", 
		"INV_Boot_Plate_PvPDeathKnightGladiator_O_01", 
		"INV_Boot_Plate_PvPDeathKnight_O_01", 
		"INV_Boot_Plate_PVPPaladinGladiator_O_01", 
		"INV_Boot_Plate_PVPPaladin_O_01", 
		"INV_Boot_Plate_RaidPaladinMythic_O_01", 
		"INV_Boot_Plate_RaidPaladin_O_01",
		"INV_Cloth_DraenorCrafted_D_01Boots", 
		"INV_Cloth_DraenorCrafted_D_01Boots_Horde",
		"INV_Cloth_DraenorDungeon_C_01Boot", 
		"INV_Cloth_DraenorQuest95_B_01Boot", 
		"INV_Cloth_RaidWarlock_O_01Boots",  		
		"INV_Leather_DraenorDungeon_C_01Boot", 
		"INV_Leather_DraenorHonor_C_01Boot", 
		"INV_Leather_DraenorQuest95_B_01Boot",
		"INV_Leather_PvPDruidGladiator_O_01Boot", 
		"INV_Leather_PvPDruid_O_01Boot", 
		"INV_Leather_RaidDruid_O_01Boot",
		"INV_Leather_PvPDruid_O_01Boot", 
		"INV_Leather_PvPDruid_O_01Boot", 
		"INV_Leather_RaidDruid_O_01Boot",
		"INV_Leather_RaidMonk_O_01Boot", 
		"INV_Leather_RaidRogueMythic_O_01Boot", 
		"INV_Leather_RaidRogue_O_01Boot", 
		"INV_Mail_DraenorQuest90_B_01Boot",
		"INV_Mail_ThunderLordClan_B_01Boot",
		"INV_Plate_BlackrockClan_B_01Boot", 
		"INV_Plate_DraeneiGuard_C_01Boot",
		"INV_Plate_DraenorCrafted_D_01Boot", 
		"INV_Plate_DraenorLFR_C_01Boots",
		"INV_Plate_DraenorQuest90_B_01Boot",
		"INV_Plate_Plate_PvPWarriorGladaitor_O_01Boots", 
		"INV_Plate_Plate_PvPWarrior_O_01Boots",
		"INV_Plate_RaidDeathKnightMythic_O_01Boot",
		"INV_Plate_RaidDeathKnight_O_01Boot",  
		"INV_Plate_RaidWarrior_O_01Boots", 
	}
	GHM_StockIcons["Lights"] = {
		"Achievement_WorldEvent_Lunar",
		"INV_Misc_Candle_01",
		"INV_Misc_Candle_02",
		"INV_Misc_Candle_03",
		"INV_Misc_Lantern_01",
		"INV_Offhand_Naxxramas_04",
		"INV_Offhand_OutlandRaid_03blue",
		"INV_Offhand_OutlandRaid_03orange",
		"INV_Offhand_OutlandRaid_03white",
		"INV_Torch_Lit",
		"INV_Torch_Thrown",
		"INV_Torch_Unlit",
		"Inv_misc_trinket6oIH_lanternA1", 
		"Inv_misc_trinket6oIH_lanternA2", 
		"Inv_misc_trinket6oIH_lanternA3", 
		"Inv_misc_trinket6oIH_lanternB1", 
		"Inv_misc_trinket6oIH_lanternB2", 
		"Inv_misc_trinket6oIH_lanternB3", 
	}
	GHM_StockIcons["Container"] = {
		-- ok
		"INV_Box_01",
		"INV_Box_02",
		"INV_Box_03",
		"INV_Box_04",
		"INV_Box_Birdcage_01",
		"INV_Box_PetCarrier_01",
		"INV_Cask_01",
		"INV_Cask_02",
		"INV_Cask_03",
		"INV_Cask_04",
		"INV_Crate_01",
		"achievement_guildperk_bountifulbags",
		"INV_Holiday_Christmas_Present_01",
		"INV_Holiday_Christmas_Present_02",
		"INV_Holiday_Christmas_Present_03",
		"INV_Holiday_Thanksgiving_Empty_Cornucopia", -- [397]
		"INV_Misc_Basket_01",
		"INV_Misc_Basket_02",
		"INV_Misc_Basket_03",
		"INV_Misc_Basket_04",
		"INV_Misc_Basket_05",
		"INV_Misc_Gift_01",
		"INV_Misc_Gift_02",
		"INV_Misc_Gift_03",
		"INV_Misc_Gift_04",
		"INV_Misc_Gift_05",
		"INV_Misc_Urn_01",
		"INV_Crate_02",
		"INV_Crate_03",
		"INV_Crate_04",
		"INV_Crate_05",
		"INV_Crate_06",
		"INV_Crate_07",
		"INV_Crate_08",
		"Inv_misc_bag_01",
		"Inv_misc_bag_02",
		"Inv_misc_bag_03",
		"Inv_misc_bag_04",
		"Inv_misc_bag_05",
		"Inv_misc_bag_06",
		"Inv_misc_bag_07",
		"Inv_misc_bag_07_Black",
		"Inv_misc_bag_07_Blue",
		"Inv_misc_bag_07_Green",
		"Inv_misc_bag_07_Red",
		"Inv_misc_bag_08",
		"Inv_misc_bag_09",
		"Inv_misc_bag_09_Black",
		"Inv_misc_bag_09_Blue",
		"Inv_misc_bag_09_Green",
		"Inv_misc_bag_09_Red",
		"Inv_misc_bag_10",
		"Inv_misc_bag_10_Black",
		"Inv_misc_bag_10_BLUE",
		"Inv_misc_bag_10_Green",
		"Inv_misc_bag_10_Red",
		"Inv_misc_bag_11",
		"Inv_misc_bag_12",
		"Inv_misc_bag_13",
		"Inv_misc_bag_14",
		"Inv_misc_bag_15",
		"Inv_misc_bag_16",
		"Inv_misc_bag_17",
		"Inv_misc_bag_18",
		"Inv_misc_bag_19",
		"Inv_misc_bag_20",
		"Inv_misc_bag_21",
		"Inv_misc_bag_22",
		"Inv_misc_bag_23_Netherweave",
		"Inv_misc_bag_24_Netherweave_Imbued",
		"Inv_misc_bag_25_Mooncloth",
		"Inv_misc_bag_26_Spellfire",
		"Inv_misc_bag_27",
		"Inv_misc_bag_28_Halloween",
		"Inv_misc_bag_29",
		"Inv_misc_bag_30",
		"Inv_misc_bag_31",
		"Inv_misc_bag_32",
		"Inv_misc_bag_33",
		"Inv_misc_bag_34",
		"Inv_misc_bag_35",
		"Inv_misc_bag_36",
		"Inv_misc_bag_37",
		"Inv_misc_bag_BigBagofEnchantments",
		"Inv_misc_bag_CenarionHerbBag",
		"Inv_misc_bag_CoreFelclothBag",
		"Inv_misc_bag_EnchantedMageweave",
		"Inv_misc_bag_EnchantedRunecloth",
		"Inv_misc_bag_FelclothBag",
		"Inv_misc_bag_HerbPouch",
		"Inv_misc_bag_SatchelofCenarius",
		"Inv_misc_bag_Soulbag",
		"INV_Misc_OrnateBox",
		"INV_MISC_Lockboxghostiron", 
		"INV_MISC_Lockbox_1",
		"inv_misc_bag_cooking", 
		"INV_MISC_BAG_ADVANCED_REFRIDGERATION_UNIT",
		"inv_misc_5potionbag_special", 
		"inv_misc_coinbag_special", 
		"Battleground_Strongbox_Bronze_Alliance", 
		"Battleground_Strongbox_Bronze_Horde", 
		"Battleground_Strongbox_Gold_Alliance", 
		"Battleground_Strongbox_Gold_Horde", 
		"Battleground_Strongbox_Silver_Alliance", 
		"Battleground_Strongbox_Silver_Horde", 
		"Battleground_Strongbox_Skirmish_Alliance", 
		"Battleground_Strongbox_Skirmish_Horde", 
		"Garrison_GoldChestAlliance", 
		"Garrison_GoldChestHorde", 		
	}
	GHM_StockIcons["Bracer"] = {
		-- ok


		"INV_Misc_Desecrated_ClothBracer",
		"INV_Misc_Desecrated_LeatherBracer",
		"INV_Misc_Desecrated_MailBracer",
		"INV_Misc_Desecrated_PlateBracer",
		"INV_Qiraj_BindingsCommand",
		"INV_Qiraj_BindingsDominance",
		"INV_Bracers_Leather_DungeonLeather_C_05",
		"INV_Bracers_Leather_PVPDruid_D_01",
		"Inv_bracer_01",
		"Inv_bracer_02",
		"Inv_bracer_03",
		"Inv_bracer_04",
		"Inv_bracer_05",
		"Inv_bracer_06",
		"Inv_bracer_07",
		"Inv_bracer_08",
		"Inv_bracer_09",
		"Inv_bracer_10",
		"Inv_bracer_11",
		"Inv_bracer_12",
		"Inv_bracer_13",
		"Inv_bracer_14",
		"Inv_bracer_15",
		"Inv_bracer_16",
		"Inv_bracer_17",
		"Inv_bracer_18",
		"Inv_bracer_19",
		"Inv_bracer_20",
		"Inv_bracer_20A",
		"Inv_bracer_20B",
		"Inv_bracer_21",
		"Inv_bracer_21A",
		"Inv_bracer_21B",
		"Inv_bracer_21C",
		"Inv_bracer_22",
		"Inv_bracer_22A",
		"Inv_bracer_22B",
		"Inv_bracer_22C",
		"Inv_bracer_23",
		"Inv_bracer_23A",
		"Inv_bracer_23B",
		"Inv_bracer_24",
		"Inv_bracer_24A",
		"Inv_bracer_24B",
		"Inv_bracer_25",
		"Inv_bracer_25A",
		"Inv_bracer_25B",
		"Inv_bracer_26",
		"Inv_bracer_26A",
		"Inv_bracer_26B",
		"Inv_bracer_27",
		"Inv_bracer_27A",
		"Inv_bracer_27B",
		"Inv_bracer_28",
		"Inv_bracer_28A",
		"Inv_bracer_28B",
		"Inv_bracer_29",
		"Inv_bracer_29A",
		"Inv_bracer_29B",
		"Inv_bracer_30",
		"Inv_bracer_30A",
		"Inv_bracer_30B",
		"Inv_bracer_30C",
		"Inv_bracer_31",
		"Inv_bracer_31A",
		"Inv_bracer_31B",
		"Inv_bracer_32",
		"Inv_bracer_32A",
		"Inv_bracer_32B",
		"Inv_bracer_33",
		"Inv_bracer_34",
		"Inv_bracer_35A",
		"Inv_bracer_35B",
		"Inv_bracer_36A",
		"Inv_bracer_36B",
		"Inv_bracer_37",
		"Inv_bracer_38",
		"Inv_bracer_39",
		"Inv_bracer_40",
		"Inv_bracer_41",
		"Inv_bracer_42",
		"Inv_bracer_43",
		"Inv_bracer_44",
		"Inv_bracer_45",
		"Inv_bracer_45Black",
		"Inv_bracer_45Green",
		"Inv_bracer_45Purple",
		"Inv_bracer_46",
		"Inv_bracer_47",
		"Inv_bracer_48",
		"Inv_bracer_49",
		"Inv_bracer_50",
		"Inv_bracer_51",
		"Inv_bracer_52",
		"Inv_bracer_53",
		"Inv_bracer_56",
		"Inv_bracer_57",
		"Inv_bracer_59",
		"Inv_bracer_60",
		"Inv_bracer_61",
		"Inv_bracer_61v2",
		"Inv_bracer_61v3",
		"Inv_bracer_61v4",
		"Inv_bracer_62",
		"Inv_bracer_62v2",
		"Inv_bracer_62v3",
		"Inv_bracer_62v4",
		"Inv_bracer_63",
		"Inv_bracer_63v1",
		"Inv_bracer_63v2",
		"Inv_bracer_63v3",
		"Inv_bracer_64",
		"Inv_bracer_64v1",
		"Inv_bracer_64v2",
		"Inv_bracer_64v3",
		"Inv_bracer_65",
		"Inv_bracer_65v1",
		"Inv_bracer_65v2",
		"Inv_bracer_65v3",
		"Inv_bracer_66",
		"Inv_bracer_66v1",
		"Inv_bracer_66v2",
		"Inv_bracer_66v3",
		"Inv_bracer_67",
		"Inv_bracer_67v1",
		"Inv_bracer_67v2",
		"Inv_bracer_67v3",
		"Inv_bracer_68",
		"Inv_bracer_68v1",
		"Inv_bracer_68v2",
		"Inv_bracer_68v3",
		"Inv_bracer_69",
		"Inv_bracer_69v2",
		"Inv_bracer_69v3",
		"Inv_bracer_69v4",
		"Inv_bracer_70",
		"Inv_bracer_70v1",
		"Inv_bracer_70v2",
		"Inv_bracer_70v3",
		"Inv_bracer_71",
		"Inv_bracer_71v1",
		"Inv_bracer_71v2",
		"Inv_bracer_71v3",
		"Inv_bracer_72",
		"Inv_bracer_72v1",
		"Inv_bracer_72v2",
		"Inv_bracer_72v3",
		"Inv_bracer_73",
		"Inv_bracer_73v2",
		"Inv_bracer_73v3",
		"Inv_bracer_73v4",
		"Inv_bracer_74",
		"Inv_bracer_74v2",
		"Inv_bracer_74v3",
		"Inv_bracer_74v4",
		"Inv_bracer_75",
		"Inv_bracer_75v1",
		"Inv_bracer_75v2",
		"Inv_bracer_75v3",
		"Inv_bracer_76",
		"Inv_bracer_76v2",
		"Inv_bracer_76v3",
		"Inv_bracer_76v4",
		"Inv_bracer_77",
		"Inv_bracer_77v1",
		"Inv_bracer_77v2",
		"Inv_bracer_77v3",
		"Inv_bracer_78",
		"Inv_bracer_78v1",
		"Inv_bracer_78v2",
		"Inv_bracer_78v3",
		"Inv_bracer_79",
		"Inv_bracer_80",
		"Inv_bracer_81",
		"Inv_bracer_82",
		"Inv_bracer_83",
		"Inv_bracer_Cloth_Cataclysm_B_01",
		"Inv_bracer_Cloth_Cataclysm_B_02",
		"Inv_bracer_Cloth_PVPMage_C_01",
		"Inv_bracer_Cloth_PVPMage_C_02",
		"Inv_bracer_Cloth_PVPWarlock_C_01",
		"Inv_bracer_Cloth_PVPWarlock_C_02",
		"Inv_bracer_Cloth_RaidPriest_I_01",
		"Inv_bracer_Cloth_RaidWarlock_I_01",
		"Inv_bracer_LeatherRaidRogue_I_01",
		"Inv_bracer_Leather_Cataclysm_B_01",
		"Inv_bracer_Leather_Cataclysm_B_02",
		"Inv_bracer_Leather_FirelandsDruid_D_01",
		"Inv_bracer_Leather_PVPDruid_C_01",
		"Inv_bracer_Leather_PVPDruid_C_02",
		"Inv_bracer_Leather_PVPRogue_C_01",
		"Inv_bracer_Leather_PVPRogue_C_02",
		"INV_Bracer_Leather_PVPRogue_D_01",
		"Inv_bracer_Leather_RaidDruid_I_01",
		"Inv_bracer_Leather_RaidDruid_J_01",
		"INV_Bracer_Leather_RaidDruid_K_01",
		"Inv_bracer_Leather_RaidRogue_J_01",
		"INV_Bracer_Leather_RaidRogue_K_01",
		"Inv_bracer_Mail_DungeonMail_C_03",
		"Inv_bracer_Mail_DungeonMail_C_04",
		"INV_Bracer_Mail_DungeonMail_C_05",
		"Inv_bracer_Mail_PVPHunter_C_01",
		"Inv_bracer_Mail_PVPHunter_C_02",
		"INV_Bracer_Mail_PVPHunter_D_01",
		"Inv_bracer_Mail_PVPShaman_C_01",
		"Inv_bracer_Mail_PVPShaman_C_02",
		"INV_Bracer_Mail_PVPShaman_D_01",
		"Inv_bracer_Mail_RaidHunter_I_01",
		"Inv_bracer_Mail_RaidHunter_J_01",
		"INV_Bracer_Mail_RaidHunter_K_01",
		"INV_Bracer_Mail_RaidShaman_K_01",
		"Inv_bracer_Plate_Cataclysm_B_02",
		"Inv_bracer_Plate_DungeonPlate_C_03",
		"Inv_bracer_Plate_DungeonPlate_C_04",
		"INV_Bracer_Plate_DungeonPlate_C_05",
		"INV_Bracer_Plate_DungeonPlate_C_06",
		"Inv_bracer_Plate_PVPDeathKnight_C_01",
		"Inv_bracer_Plate_PVPDeathKnight_C_02",
		"INV_Bracer_Plate_PVPDeathKnight_D_01",
		"Inv_bracer_Plate_PVPPaladin_C_01",
		"Inv_bracer_Plate_PVPPaladin_C_02",
		"INV_Bracer_Plate_PVPPaladin_D_01",
		"Inv_bracer_Plate_PVPWarrior_C_01",
		"Inv_bracer_Plate_PVPWarrior_C_02",
		"INV_Bracer_Plate_PVPWarrior_D_01",
		"Inv_bracer_Plate_RaidDeathKnight_I_01",
		"Inv_bracer_Plate_RaidDeathKnight_J_01",
		"Inv_bracer_Plate_RaidPaladin_I_01",
		"Inv_bracer_Plate_RaidPaladin_J_01",
		"INV_Bracer_Plate_RaidPaladin_K_01",
		"Inv_bracer_Plate_RaidWarrior_I_01",
		"Inv_bracer_Plate_RaidWarrior_J_01",
		"INV_Bracer_Plate_RaidWarrior_K_01",
		"Inv_bracer_Plate_TwilightHammer_C_01",
		"Inv_bracer_RaidShaman_I_01",
		"Inv_bracer_Robe_Common_C_01",
		"Inv_bracer_Robe_Common_C_01v1",
		"Inv_bracer_Robe_Common_C_01v2",
		"Inv_bracer_Robe_Common_C_01v3",
		"Inv_bracer_Robe_DungeonRobe_C_03",
		"Inv_bracer_Robe_DungeonRobe_C_04",
		"INV_Bracer_Robe_DungeonRobe_C_05",
		"INV_Bracer_Robe_PVPMage_D_01",
		"Inv_bracer_Robe_PVPPriest_C_01",
		"Inv_bracer_Robe_PVPPriest_C_02",
		"INV_Bracer_Robe_PVPPriest_D_01",
		"INV_Bracer_Robe_PVPWarlock_D_01",
		"Inv_bracer_Robe_RaidMage_I_01",
		"Inv_bracer_Robe_RaidMage_J_01",
		"INV_Bracer_Robe_RaidMage_K_01",
		"Inv_bracer_Robe_RaidPriest_J_01",
		"INV_Bracer_Robe_RaidPriest_K_01",
		"Inv_bracer_Robe_RaidWarlock_J_01",
		"INV_Bracer_Robe_RaidWarlock_K_01",
		"inv_misc_addsocketbracer",
		"Plate_RaidDeathKnight_K_01_Bracer",
		 "INV_Bracers_Mail_RaidShaman_L_01", 
		"INV_Bracers_Plate_RaidWarrior_L_01", 
		"INV_Bracer_ChallengeDruid_D_01", 
		"INV_Bracer_Cloth_ChallengeMage_D_01", 
		"INV_Bracer_Cloth_ChallengePriest_D_01", 
		"INV_Bracer_Cloth_DungeonCloth_C_06", 
		"INV_Bracer_Cloth_Panda_B_01", 
		"INV_Bracer_Cloth_Panda_B_01_Green", 
		"INV_Bracer_Cloth_Panda_B_01_Red", 
		"INV_Bracer_Cloth_Panda_B_02", 
		"INV_Bracer_Cloth_Panda_B_02_Blue", 
		"INV_Bracer_Cloth_Panda_B_02_White", 
		"INV_Bracer_Cloth_Panstart_A_01", 
		"INV_Bracer_Cloth_RaidPriest_L_01", 
		"INV_Bracer_Cloth_RaidWarlock_L_01", 
		"INV_Bracer_Cloth_Reputation_C_01", 
		"INV_Bracer_Leather_ChallengeMonk_D_01", 
		"INV_Bracer_Leather_ChallengeRogue_D_01", 
		"INV_Bracer_Leather_DungeonLeather_C_06", 
		"INV_Bracer_Leather_Panda_B_01", 
		"INV_Bracer_Leather_Panda_B_01Dark", 
		"INV_Bracer_Leather_Panda_B_01Light", 
		"INV_Bracer_Leather_Panda_B_01Red", 
		"INV_Bracer_Leather_Panda_B_02", 
		"INV_Bracer_Leather_Panda_B_02_Brown", 
		"INV_Bracer_Leather_Panda_B_02_Crimson", 
		"INV_Bracer_Leather_Panda_B_02_Indigo", 
		"INV_Bracer_Leather_PanProg_B_01", 
		"INV_Bracer_Leather_PVPDruid_E_01", 
		"INV_Bracer_Leather_PVPMonk_E_01", 
		"INV_Bracer_Leather_PVPRogue_E_01", 
		"INV_Bracer_Leather_RaidDruid_L_01", 
		"INV_Bracer_Leather_RaidMonk_L_01", 
		"INV_Bracer_Leather_RaidRogue_L_01", 
		"INV_Bracer_Leather_Reputation_C_01", 
		"INV_Bracer_Mail_ChallengeHunter_D_01", 
		"INV_Bracer_Mail_ChallengeShaman_D_01", 
		"INV_Bracer_Mail_DungeonMail_C_06", 
		"INV_Bracer_Mail_Panda_B_01", 
		"INV_Bracer_Mail_Panda_B_01Green", 
		"INV_Bracer_Mail_Panda_B_01White", 
		"INV_Bracer_Mail_Panda_B_02", 
		"INV_Bracer_Mail_PanProg_B_01", 
		"INV_Bracer_Mail_PVPHunter_E_01", 
		"INV_Bracer_Mail_PVPShaman_E_01", 
		"INV_Bracer_Mail_RaidHunter_L_01", 
		"INV_Bracer_Mail_Reputation_C_01", 
		"INV_Bracer_Plate_ChallengeDeathKnight_D_01", 
		"INV_Bracer_Plate_ChallengePaladin_D_01", 
		"INV_Bracer_Plate_ChallengeWarrior_D_01", 
		"INV_Bracer_Plate_DungeonPlate_C_07", 
		"INV_Bracer_Plate_Panda_B_01", 
		"INV_Bracer_Plate_Panda_B_01Blue", 
		"INV_Bracer_Plate_Panda_B_01Gold", 
		"INV_Bracer_Plate_Panda_B_02", 
		"INV_Bracer_Plate_Panda_B_02Green", 
		"INV_Bracer_Plate_Panda_B_02Purple", 
		"INV_Bracer_Plate_Panda_B_02Yellow", 
		"INV_Bracer_Plate_PVPDeathKnight_E_01", 
		"INV_Bracer_Plate_PVPPaladin_E_01", 
		"INV_Bracer_Plate_PVPWarrior_E_01", 
		"INV_Bracer_Plate_RaidDeathKnight_L_01", 
		"INV_Bracer_Plate_RaidPaladin_L_01", 
		"INV_Bracer_Plate_Reputation_C_01", 
		"INV_Bracer_PVPPriest_E_01", 
		"INV_Bracer_PVPWarlock_E_01", 
		"INV_Bracer_RaidMage_L_01", 
		"INV_Bracer_Robe_PanProg_B_01", 
		"INV_Bracer_Robe_PVPMage_E_01", 
		"INV_Bracers_Leather_PVPRogue_F_01", 
		"INV_Bracers_Plate_PVPDeathKnight_F_01", 
		"INV_Bracers_PVPWarrior_F_01", 
		"INV_Bracer_Cloth_PVPMage_F_01", 
		"INV_Bracer_Cloth_PVPPriest_F_01", 
		"INV_Bracer_Cloth_RaidMage_M_01", 
		"INV_Bracer_Cloth_RaidWarlock_M_01", 
		"INV_Bracer_Leather_PVPMonk_F_01", 
		"INV_Bracer_Leather_RaidMonk_M_01", 
		"INV_Bracer_Leather_RaidRogue_M_01", 
		"INV_Bracer_Mail_PVPShaman_F_01", 
		"INV_Bracer_Mail_RaidHunter_M_01", 
		"INV_Bracer_Mail_RaidShaman_M_01", 
		"INV_Bracer_Plate_DeathKnight_M_01", 
		"INV_Bracer_Plate_PVPPaladin_F_01Bronze", 
		"INV_Bracer_Plate_PVPPaladin_F_01Red", 
		"INV_Bracer_Plate_PVPPaladin_F_01White", 
		"INV_Bracer_Plate_RaidPaladin_M_01", 
		"INV_Bracer_Plate_RaidWarrior_M_01", 
		
		"INV_Cloth_RaidPriest_M_01Bracer",	
		"INV_Cloth_PVPWarlock_F_01Bracer",  
		"INV_Leather_RaidDruid_M_01Bracer", 
		"INV_Bracers_Leather_PVPRogue_G_01", 
		"INV_Bracer_Cloth_PVPMage_G_01", 
		"INV_Bracer_Cloth_PVPPriest_G_01", 
		"INV_Bracer_Cloth_RaidMage_N_01", 
		"INV_Bracer_Cloth_RaidWarlock_N_01", 
		"INV_Bracer_Leather_PVPDruid_G_01", 
		"INV_Bracer_Leather_PVPMonk_G_01", 
		"INV_Bracer_Leather_RaidMonk_N_01", 
		"INV_Bracer_Leather_RaidRogue_N_01", 
		"INV_Bracer_Mail_KorKronShaman_D_01", 
		"INV_Bracer_Mail_PVPHunter_G_01", 
		"INV_Bracer_Mail_PVPShaman_G_01", 
		"INV_Bracer_Mail_RaidHunter_N_01", 
		"INV_Bracer_Plate_PVPPaladin_G_01", 
		"INV_Bracer_Plate_RaidDeathKnight_N_01", 
		"Inv_Bracer_Plate_RaidWarrior_N_01",
		"INV_Cloth_PVPWarlock_G_01Bracer",  
		"INV_Cloth_RaidPriest_N_01Bracer", 	
		"INV_Leather_RaidDruid_N_01Bracer", 
		"INV_Mail_RaidShaman_N_01Bracer",
		"INV_Plate_PVPDeathKnight_G_01_BRACER", 
		"INV_Plate_PVPWarrior_G_01Bracer", 
		"INV_Plate_RaidPaladin_N_01Bracer",
		"INV_Bracer_Cloth_Draenei_C_01", 
		"INV_Bracer_Cloth_DraenorHonor_C_01", 
		"INV_Bracer_Cloth_DraenorLFR_C_01", 
		"INV_Bracer_Cloth_DraenorQuest90_B_01", 
		"INV_Bracer_Cloth_PVPMageGladiator_O_01", 
		"INV_Bracer_Cloth_PVPMage_O_01", 
		"INV_Bracer_Cloth_PVPPriestGladiator_O_01", 
		"INV_Bracer_Cloth_PVPPriest_O_01", 
		"INV_Bracer_Cloth_PVPWarlock_O_01", 
		"INV_Bracer_Cloth_RaidMageMythic_O_01", 
		"INV_Bracer_Cloth_RaidMage_O_01", 
		"INV_Bracer_Cloth_RaidPriestMythic_O_01", 
		"INV_Bracer_Cloth_RaidPriest_O_01", 
		"INV_Bracer_Cloth_ShadowmoonClan_B_01", 
		"INV_Bracer_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Bracer_Leather_DraenorCrafted_D_01_horde", 
		"INV_Bracer_Leather_DraenorLFR_C_01", 
		"INV_Bracer_Leather_DraenorQuest90_B_01", 
		"INV_Bracer_Leather_PvPMonkGladiator_O_01", 
		"INV_Bracer_Leather_PvPMonk_O_01", 
		"INV_Bracer_Leather_PvPRogueGladiator_O_01", 
		"INV_Bracer_Leather_PVPRogue_O_01", 
		"INV_bracer_Mail_DraenorCrafted_D_01_alliance", 
		"INV_bracer_Mail_DraenorCrafted_D_01_Horde", 
		"INV_Bracer_Mail_DraenorDungeon_C_01", 
		"INV_Bracer_Mail_DraenorHonor_C_01", 
		"INV_Bracer_Mail_DraenorLFR_C_01", 
		"INV_Bracer_Mail_DraenorQuest95_B_01", 
		"INV_Bracer_Mail_PvPHunterGladiator_O_01", 
		"INV_BRACER_Mail_PVPHunter_O_01", 
		"INV_Bracer_Mail_PvPShamanGladiator_O_01", 
		"INV_Bracer_Mail_PVPShaman_O_01", 
		"INV_bracer_Mail_RaidHunterMythic_O_01", 
		"INV_bracer_Mail_RaidHunter_O_01", 
		"INV_Bracer_Mail_RaidShamanMythic_O_01", 
		"INV_Bracer_Mail_RaidShaman_O_01", 
		"INV_Bracer_Mail_WarsongClan_B_01", 
		"INV_Bracer_plate_draenordungeon_c_01", 
		"INV_Bracer_Plate_DraenorHonor_C_01", 
		"INV_Bracer_Plate_DraenorQuest95_B_01", 
		"INV_Bracer_Plate_PvPDeathKnightGladiator_O_01", 
		"INV_Bracer_Plate_PvPDeathKnight_O_01", 
		"INV_Bracer_Plate_PVPPaladinGladiator_O_01", 
		"INV_Bracer_Plate_PVPPaladin_O_01", 
		"INV_Bracer_Plate_RaidPaladinMythic_O_01", 
		"INV_Bracer_Plate_RaidPaladin_O_01", 
		"INV_Cloth_DraenorCrafted_D_01Bracer", 
		"INV_Cloth_DraenorCrafted_D_01Bracer_Horde",  
		"INV_Cloth_DraenorDungeon_C_01Bracer", 
		"INV_Cloth_DraenorQuest95_B_01Bracer", 
		"INV_Cloth_RaidWarlock_O_01Bracer",  
		"INV_Leather_DraenorDungeon_C_01Bracer", 
		"INV_Leather_DraenorHonor_C_01Bracer", 
		"INV_Leather_DraenorQuest95_B_01Bracer", 
		"INV_Leather_PvPDruidGladiator_O_01Bracer", 
		"INV_Leather_PvPDruid_O_01Bracer", 
		"INV_Leather_RaidDruid_O_01Bracer", 
		"INV_Leather_RaidMonk_O_01Boot", 
		"INV_Leather_RaidMonk_O_01Bracer", 
		"INV_Leather_RaidRogueMythic_O_01Bracer", 
		"INV_Leather_RaidRogue_O_01Bracer", 
		"INV_Mail_DraenorQuest90_B_01Bracer", 
		"INV_Mail_ThunderLordClan_B_01Bracer", 
		"INV_Plate_BlackrockClan_B_01Bracer", 
		"INV_Plate_DraeneiGuard_C_01Bracer", 
		"INV_Plate_DraenorCrafted_D_01Bracer", 
		"INV_Plate_DraenorLFR_C_01Wrist", 
		"INV_Plate_DraenorQuest90_B_01Bracer", 
		"INV_Plate_Plate_PvPWarriorGladaitor_O_01Bracer",  "INV_Plate_Plate_PvPWarrior_O_01Bracer", 
		"INV_Plate_RaidDeathKnightMythic_O_01Bracer", 
		"INV_Plate_RaidDeathKnight_O_01Bracer", 
		"INV_Plate_RaidWarrior_O_01Bracer", 		

		
	}
	GHM_StockIcons["Chestpiece"] = {
		--ok
		"Inv_chest_Chain",
		"INV_Robe_Leather_PVPDruid_D_01",
		"INV_Chest_Leather_DungeonLeather_C_05",
		"Inv_chest_Chain_03",
		"Inv_chest_Chain_04",
		"Inv_chest_Chain_05",
		"Inv_chest_Chain_06",
		"Inv_chest_Chain_07",
		"Inv_chest_Chain_08",
		"Inv_chest_Chain_09",
		"Inv_chest_Chain_10",
		"Inv_chest_Chain_11",
		"Inv_chest_Chain_12",
		"Inv_chest_Chain_13",
		"Inv_chest_Chain_14",
		"Inv_chest_Chain_15",
		"Inv_chest_Chain_16",
		"Inv_chest_Chain_17",
		"Inv_chest_Christmas01",
		"Inv_chest_Christmas02",
		"Inv_chest_Cloth_01",
		"Inv_chest_Cloth_02",
		"Inv_chest_Cloth_03",
		"Inv_chest_Cloth_04",
		"Inv_chest_Cloth_05",
		"Inv_chest_Cloth_06",
		"Inv_chest_Cloth_07",
		"Inv_chest_Cloth_08",
		"Inv_chest_Cloth_09",
		"Inv_chest_Cloth_10",
		"Inv_chest_Cloth_11",
		"Inv_chest_Cloth_12",
		"Inv_chest_Cloth_13",
		"Inv_chest_Cloth_14",
		"Inv_chest_Cloth_15",
		"Inv_chest_Cloth_16",
		"Inv_chest_Cloth_17",
		"Inv_chest_Cloth_18",
		"Inv_chest_Cloth_19",
		"Inv_chest_Cloth_20",
		"Inv_chest_Cloth_21",
		"Inv_chest_Cloth_22",
		"Inv_chest_Cloth_23",
		"Inv_chest_Cloth_24",
		"Inv_chest_Cloth_25",
		"Inv_chest_Cloth_26",
		"Inv_chest_Cloth_27",
		"Inv_chest_Cloth_28",
		"Inv_chest_Cloth_29",
		"Inv_chest_Cloth_30",
		"Inv_chest_Cloth_31",
		"Inv_chest_Cloth_32",
		"Inv_chest_Cloth_33",
		"Inv_chest_Cloth_34",
		"Inv_chest_Cloth_35",
		"Inv_chest_Cloth_36",
		"Inv_chest_Cloth_37",
		"Inv_chest_Cloth_38",
		"Inv_chest_Cloth_39",
		"Inv_chest_Cloth_40",
		"Inv_chest_Cloth_41",
		"Inv_chest_Cloth_42",
		"Inv_chest_Cloth_43",
		"Inv_chest_Cloth_44",
		"Inv_chest_Cloth_45",
		"Inv_chest_Cloth_46",
		"Inv_chest_Cloth_47",
		"Inv_chest_Cloth_48",
		"Inv_chest_Cloth_49",
		"Inv_chest_Cloth_50",
		"Inv_chest_Cloth_51",
		"Inv_chest_Cloth_52",
		"Inv_chest_Cloth_53",
		"Inv_chest_Cloth_54",
		"Inv_chest_Cloth_55",
		"Inv_chest_Cloth_56",
		"Inv_chest_Cloth_57",
		"Inv_chest_Cloth_58",
		"Inv_chest_Cloth_59",
		"Inv_chest_Cloth_60",
		"Inv_chest_Cloth_61",
		"Inv_chest_Cloth_62",
		"Inv_chest_Cloth_63",
		"Inv_chest_Cloth_64",
		"Inv_chest_Cloth_65",
		"Inv_chest_Cloth_66",
		"Inv_chest_Cloth_67",
		"Inv_chest_CLOTH_68",
		"Inv_chest_Cloth_69",
		"Inv_chest_Cloth_70",
		"Inv_chest_Cloth_71",
		"Inv_chest_Cloth_72",
		"Inv_chest_Cloth_73",
		"Inv_chest_Cloth_74",
		"Inv_chest_Cloth_75",
		"Inv_chest_Cloth_76",
		"Inv_chest_Cloth_77",
		"Inv_chest_Cloth_78",
		"Inv_chest_Cloth_78Black",
		"Inv_chest_Cloth_78Green",
		"Inv_chest_Cloth_78Purple",
		"Inv_chest_Cloth_79",
		"Inv_chest_Cloth_80",
		"Inv_chest_Cloth_81",
		"Inv_chest_Cloth_82",
		"Inv_chest_Cloth_83",
		"Inv_chest_Cloth_84",
		"Inv_chest_Cloth_84v2",
		"Inv_chest_Cloth_84v3",
		"Inv_chest_Cloth_84v4",
		"Inv_chest_Cloth_85",
		"Inv_chest_Cloth_86",
		"Inv_chest_Cloth_86v2",
		"Inv_chest_Cloth_86v3",
		"Inv_chest_Cloth_86v4",
		"Inv_chest_Cloth_87",
		"Inv_chest_Cloth_87v2",
		"Inv_chest_Cloth_87v3",
		"Inv_chest_Cloth_87v4",
		"Inv_chest_Cloth_88",
		"Inv_chest_Cloth_88v2",
		"Inv_chest_Cloth_88v3",
		"Inv_chest_Cloth_88v4",
		"Inv_chest_Cloth_Cataclysm_B_01",
		"Inv_chest_Cloth_Cataclysm_B_02",
		"Inv_chest_Cloth_PVPMage_C_01",
		"Inv_chest_Cloth_PVPMage_C_02",
		"Inv_chest_Cloth_PVPWarlock_C_01",
		"Inv_chest_Cloth_PVPWarlock_C_02",
		"Inv_chest_Cloth_RaidPriest_I_01",
		"Inv_chest_Cloth_RaidWarlock_I_01",
		"Inv_chest_Fur",
		"Inv_chest_LeatherRaidRogue_I_01",
		"Inv_chest_Leather_01",
		"Inv_chest_Leather_02",
		"Inv_chest_Leather_03",
		"Inv_chest_Leather_04",
		"Inv_chest_Leather_05",
		"Inv_chest_Leather_06",
		"Inv_chest_Leather_07",
		"Inv_chest_Leather_08",
		"Inv_chest_Leather_09",
		"Inv_chest_Leather_10",
		"Inv_chest_Leather_11",
		"Inv_chest_Leather_12",
		"Inv_chest_Leather_13",
		"Inv_chest_Leather_14",
		"Inv_chest_LEATHER_15",
		"Inv_chest_LEATHER_16",
		"Inv_chest_Leather_17A",
		"Inv_chest_Leather_17B",
		"Inv_chest_Leather_18A",
		"Inv_chest_Leather_18B",
		"Inv_chest_Leather_19",
		"Inv_chest_Leather_19Purple",
		"Inv_chest_Leather_19Red",
		"Inv_chest_Leather_20",
		"Inv_chest_Leather_21",
		"Inv_chest_Leather_22",
		"Inv_chest_Leather_23",
		"Inv_chest_Leather_24",
		"Inv_chest_Leather_25",
		"Inv_chest_Leather_26",
		"Inv_chest_Leather_26v2",
		"Inv_chest_Leather_26v3",
		"Inv_chest_Leather_26v4",
		"Inv_chest_Leather_27",
		"Inv_chest_Leather_27v1",
		"Inv_chest_Leather_27v2",
		"Inv_chest_Leather_27v3",
		"Inv_chest_Leather_28",
		"Inv_chest_Leather_28v1",
		"Inv_chest_Leather_28v2",
		"Inv_chest_Leather_28v3",
		"Inv_chest_Leather_29",
		"Inv_chest_Leather_29v1",
		"Inv_chest_Leather_29v2",
		"Inv_chest_Leather_29v3",
		"Inv_chest_Leather_30",
		"Inv_chest_Leather_30v1",
		"Inv_chest_Leather_30v2",
		"Inv_chest_Leather_30v3",
		"Inv_chest_Leather_31",
		"Inv_chest_Leather_32",
		"Inv_chest_Leather_Cataclysm_B_01",
		"Inv_chest_Leather_Cataclysm_B_02",
		"Inv_chest_Leather_FirelandsDruid_D_01",
		"Inv_chest_Leather_PVPDruid_C_01",
		"Inv_chest_Leather_PVPDruid_C_02",
		"INV_Chest_Leather_PVPDruid_D_01",
		"Inv_chest_Leather_PVPRogue_C_02",
		"INV_Chest_Leather_PVPRogue_D_01",
		"Inv_chest_Leather_RaidDruid_I_01",
		"Inv_chest_Leather_RaidDruid_J_01",
		"INV_Chest_Leather_RaidDruid_K_01",
		"Inv_chest_Leather_RaidRogue_J_01",
		"INV_Chest_Leather_RaidRogue_K_01",
		"Inv_chest_MAIL_02",
		"Inv_chest_MAIL_03",
		"Inv_chest_MAIL_04",
		"Inv_chest_Mail_05",
		"Inv_chest_Mail_06",
		"Inv_chest_Mail_07",
		"Inv_chest_Mail_08",
		"Inv_chest_Mail_09",
		"Inv_chest_Mail_09Black",
		"Inv_chest_Mail_09Silver",
		"Inv_chest_Mail_10",
		"Inv_chest_Mail_11",
		"Inv_chest_Mail_12",
		"Inv_chest_Mail_13",
		"Inv_chest_Mail_15",
		"Inv_chest_Mail_16",
		"Inv_chest_Mail_16v2",
		"Inv_chest_Mail_16v3",
		"Inv_chest_Mail_16v4",
		"Inv_chest_Mail_17",
		"Inv_chest_Mail_17v1",
		"Inv_chest_Mail_17v2",
		"Inv_chest_Mail_17v3",
		"Inv_chest_Mail_18",
		"Inv_chest_Mail_18v1",
		"Inv_chest_Mail_18v2",
		"Inv_chest_Mail_18v3",
		"Inv_chest_Mail_19",
		"Inv_chest_Mail_19v1",
		"Inv_chest_Mail_19v2",
		"Inv_chest_Mail_19v3",
		"Inv_chest_Mail_20",
		"Inv_chest_Mail_20v1",
		"Inv_chest_Mail_20v2",
		"Inv_chest_Mail_20v3",
		"Inv_chest_Mail_21",
		"Inv_chest_Mail_22",
		"Inv_chest_Mail_DungeonMail_C_03",
		"Inv_chest_Mail_DungeonMail_C_04",
		"INV_Chest_Mail_DungeonMail_C_05",
		"Inv_chest_Mail_PVPHunter_C_01",
		"Inv_chest_Mail_PVPHunter_C_02",
		"INV_Chest_Mail_PVPHunter_D_01",
		"Inv_chest_Mail_PVPShaman_C_01",
		"Inv_chest_Mail_PVPShaman_C_02",
		"INV_Chest_Mail_PVPShaman_D_01",
		"Inv_chest_Mail_RaidHunter_I_01",
		"Inv_chest_Mail_RaidHunter_J_01",
		"INV_Chest_Mail_RaidHunter_K_01",
		"Inv_chest_Mail_RaidShaman_J_01",
		"INV_Chest_Mail_RaidShaman_K_01",
		"Inv_chest_Plate01",
		"Inv_chest_Plate02",
		"Inv_chest_Plate03",
		"Inv_chest_Plate04",
		"Inv_chest_Plate05",
		"Inv_chest_Plate06",
		"Inv_chest_Plate07",
		"Inv_chest_Plate08",
		"Inv_chest_Plate09",
		"Inv_chest_Plate10",
		"Inv_chest_Plate11",
		"Inv_chest_Plate12",
		"Inv_chest_Plate13",
		"Inv_chest_Plate14",
		"Inv_chest_Plate15",
		"Inv_chest_Plate16",
		"Inv_chest_Plate18",
		"Inv_chest_Plate19",
		"Inv_chest_Plate20",
		"Inv_chest_Plate21",
		"Inv_chest_Plate22",
		"Inv_chest_Plate23",
		"Inv_chest_Plate26",
		"Inv_chest_Plate27",
		"Inv_chest_Plate27v1",
		"Inv_chest_Plate27v2",
		"Inv_chest_Plate27v3",
		"Inv_chest_Plate28",
		"Inv_chest_Plate28v1",
		"Inv_chest_Plate28v2",
		"Inv_chest_Plate28v3",
		"Inv_chest_Plate29",
		"Inv_chest_Plate29v1",
		"Inv_chest_Plate29v2",
		"Inv_chest_Plate29v3",
		"Inv_chest_Plate30",
		"Inv_chest_Plate30v1",
		"Inv_chest_Plate30v2",
		"Inv_chest_Plate30v3",
		"Inv_chest_PLATE_22",
		"Inv_chest_PLATE_23",
		"Inv_chest_Plate_24",
		"Inv_chest_PLATE_25",
		"Inv_chest_Plate_26",
		"Inv_chest_Plate_31",
		"Inv_chest_Plate_Cataclysm_B_02",
		"Inv_chest_Plate_DungeonPlate_C_03",
		"Inv_chest_Plate_DungeonPlate_C_04",
		"INV_Chest_Plate_DungeonPlate_C_05",
		"INV_Chest_Plate_DungeonPlate_C_06",
		"Inv_chest_Plate_PVPDeathKnight_C_01",
		"Inv_chest_Plate_PVPDeathKnight_C_02",
		"INV_Chest_Plate_PVPDeathKnight_D_01",
		"Inv_chest_Plate_PVPPaladin_C_01",
		"Inv_chest_Plate_PVPPaladin_C_02",
		"INV_Chest_Plate_PVPPaladin_D_01",
		"Inv_chest_Plate_PVPWarrior_C_01",
		"Inv_chest_Plate_PVPWarrior_C_02",
		"INV_Chest_Plate_PVPWarrior_D_01",
		"Inv_chest_Plate_RaidDeathKnight_I_01",
		"Inv_chest_Plate_RaidDeathKnight_J_01",
		"Inv_chest_Plate_RaidPaladin_I_01",
		"Inv_chest_Plate_RaidPaladin_J_01",
		"INV_Chest_Plate_RaidPaladin_K_01",
		"Inv_chest_Plate_RaidWarrior_I_01",
		"Inv_chest_Plate_RaidWarrior_J_01",
		"INV_Chest_Plate_RaidWarrior_K_01",
		"Inv_chest_Plate_TwilightHammer_C_01",
		"Inv_chest_RaidShaman_I_01",
		"Inv_chest_Robe_Common_C_01",
		"Inv_chest_Robe_Common_C_01v1",
		"Inv_chest_Robe_Common_C_01v2",
		"Inv_chest_Robe_Common_C_01v3",
		"Inv_chest_Robe_DungeonRobe_C_03",
		"Inv_chest_Robe_DungeonRobe_C_04",
		"INV_Chest_Robe_DungeonRobe_C_05",
		"Inv_chest_Robe_PVPPriest_C_01",
		"Inv_chest_Robe_PVPPriest_C_02",
		"INV_Chest_Robe_PVPPriest_D_01",
		"INV_Chest_Robe_PVPWarlock_D_01",
		"Inv_chest_Robe_RaidMage_I_01",
		"Inv_chest_Robe_RaidMage_J_01",
		"INV_Chest_Robe_RaidMage_K_01",
		"Inv_chest_Robe_RaidPriest_J_01",
		"INV_Chest_Robe_RaidPriest_K_01",
		"Inv_chest_Robe_RaidWarlock_J_01",
		"INV_Chest_Robe_RaidWarlock_K_01",
		"Inv_chest_Samurai",
		"Inv_chest_Wolf",
		"INV_Misc_Desecrated_ClothChest",
		"INV_Misc_Desecrated_LeatherChest",
		"INV_Misc_Desecrated_MailChest",
		"INV_Misc_Desecrated_PlateChest",
		"INV_Robe_Robe_PVPMage_D_01",
		"INV_Robe_Robe_PVPPriest_D_01",
		"Plate_RaidDeathKnight_K_01_Chest",
		 "INV_Chest_ChallengeDruid_D_01", 
		"INV_Chest_Cloth_ChallengeMage_D_01", 
		"INV_Chest_Cloth_ChallengePriest_D_01", 
		"INV_Chest_Cloth_DungeonCloth_C_06", 
		"INV_Chest_Cloth_Holiday_Christmas_A_02", 
		"INV_Chest_Cloth_Panda_B_01", 
		"INV_Chest_Cloth_Panda_B_01_Green", 
		"INV_Chest_Cloth_Panda_B_01_Red", 
		"INV_Chest_Cloth_Panda_B_02", 
		"INV_Chest_Cloth_Panda_B_02_Blue", 
		"INV_Chest_Cloth_Panda_B_02_White", 
		"INV_Chest_Cloth_Panstart_A_01", 
		"INV_Chest_Cloth_RaidPriest_L_01", 
		"INV_Chest_Cloth_RaidWarlock_L_01", 
		"INV_Chest_Cloth_Reputation_C_01", 
		"INV_Chest_Leather_ChallengeMonk_D_01", 
		"INV_Chest_Leather_ChallengeRogue_D_01", 
		"INV_Chest_Leather_DungeonLeather_C_06", 
		"INV_Chest_Leather_Panda_B_01", 
		"INV_Chest_Leather_Panda_B_01Dark", 
		"INV_Chest_Leather_Panda_B_01Light", 
		"INV_Chest_Leather_Panda_B_01Red", 
		"INV_Chest_Leather_Panda_B_02", 
		"INV_Chest_Leather_Panda_B_02_Brown", 
		"INV_Chest_Leather_Panda_B_02_Crimson", 
		"INV_Chest_Leather_Panda_B_02_Indigo", 
		"INV_Chest_Leather_PanProg_B_01", 
		"INV_Chest_Leather_PVPDruid_E_01", 
		"INV_Chest_Leather_PVPMonk_E_01", 
		"INV_Chest_Leather_PVPRogue_E_01", 
		"INV_Chest_Leather_RaidDruid_L_01", 
		"INV_Chest_Leather_RaidMonk_L_01", 
		"INV_Chest_Leather_RaidRogue_L_01", 
		"INV_Chest_Leather_Reputation_C_01", 
		"INV_Chest_Mail_ChallengeHunter_D_01", 
		"INV_Chest_Mail_ChallengeShaman_D_01", 
		"INV_Chest_Mail_DungeonMail_C_06", 
		"INV_Chest_Mail_Panda_B_01", 
		"INV_Chest_Mail_Panda_B_01Green", 
		"INV_Chest_Mail_Panda_B_01White", 
		"INV_Chest_Mail_Panda_B_02", 
		"INV_Chest_Mail_PanProg_B_01", 
		"INV_Chest_Mail_PVPHunter_E_01", 
		"INV_Chest_Mail_PVPShaman_E_01", 
		"INV_Chest_Mail_RaidHunter_L_01", 
		"INV_Chest_Mail_RaidShaman_L_01", 
		"INV_Chest_Mail_Reputation_C_01", 
		"INV_Chest_Plate_ChallengeDeathKnight_D_01", 
		"INV_Chest_Plate_ChallengePaladin_D_01", 
		"INV_Chest_Plate_ChallengeWarrior_D_01", 
		"INV_Chest_Plate_DungeonPlate_C_07", 
		"INV_Chest_Plate_Panda_B_01", 
		"INV_Chest_Plate_Panda_B_01Blue", 
		"INV_Chest_Plate_Panda_B_01Gold", 
		"INV_Chest_Plate_Panda_B_02", 
		"INV_Chest_Plate_Panda_B_02Green", 
		"INV_Chest_Plate_Panda_B_02Purple", 
		"INV_Chest_Plate_Panda_B_02Yellow", 
		"INV_Chest_Plate_PVPDeathKnight_E_01", 
		"INV_Chest_Plate_PVPPaladin_E_01", 
		"INV_Chest_Plate_PVPWarrior_E_01", 
		"INV_Chest_Plate_RaidDeathKnight_L_01", 
		"INV_Chest_Plate_RaidPaladin_L_01", 
		"INV_Chest_Plate_RaidWarrior_L_01", 
		"INV_Chest_Plate_Reputation_C_01", 
		"INV_Chest_PVPPriest_E_01", 
		"INV_Chest_PVPWarlock_E_01", 
		"INV_Chest_RaidMage_L_01", 
		"INV_Chest_Robe_Panda_A_02", 
		"INV_Chest_Robe_PanProg_B_01", 
		"INV_Chest_Robe_PVPMage_E_01", 
		"INV_Cloth_ChallengeWarlock_D_01Belt", 
		"INV_Cloth_ChallengeWarlock_D_01Boot", 
		"INV_Cloth_ChallengeWarlock_D_01Bracer", 
		"INV_Cloth_ChallengeWarlock_D_01Chest", 
		"INV_Cloth_ChallengeWarlock_D_01Glove", 
		"INV_Cloth_ChallengeWarlock_D_01Helm", 
		"INV_Cloth_ChallengeWarlock_D_01Pant", 
		"INV_Cloth_ChallengeWarlock_D_01Shoulder", 
		 "INV_Chest_Cloth_PVPMage_F_01", 
		"INV_Chest_Cloth_PVPPriest_F_01", 
		"INV_Chest_Cloth_RaidMage_M_01", 
		"INV_Chest_Cloth_RaidWarlock_M_01", 
		"INV_Chest_Leather_PVPMonk_F_01", 
		"INV_Chest_Leather_PVPRogue_F_01", 
		"INV_Chest_Leather_RaidMonk_M_01", 
		"INV_Chest_Leather_RaidRogue_M_01", 
		"INV_Chest_Mail_PVPShaman_F_01", 
		"INV_Chest_Mail_RaidHunter_M_01", 
		"INV_Chest_Mail_RaidShaman_M_01", 
		"INV_Chest_Plate_DeathKnight_M_01", 
		"INV_Chest_Plate_PVPDeathKnight_F_01", 
		"INV_Chest_Plate_PVPPaladin_F_01Bronze", 
		"INV_Chest_Plate_PVPPaladin_F_01Red", 
		"INV_Chest_Plate_PVPPaladin_F_01White", 
		"INV_Chest_Plate_PVPWarrior_F_01", 
		"INV_Chest_Plate_RaidPaladin_M_01", 
		"INV_Chest_Plate_RaidWarrior_M_01", 
		 "INV_Cloth_PVPWarlock_F_01Belt", 
 
		 "INV_Cloth_PVPWarlock_F_01Robe", 
		 "INV_Leather_RaidDruid_M_01Robe", 
		 "INV_Cloth_RaidPriest_M_01Robe",
		 "INV_Leather_RaidDruid_M_01Belt",
		  "INV_Robe_Cloth_PVPPriest_F_01", 
		"INV_Robe_Cloth_RaidWarlock_M_01", 
		"INV_Robe_Leather_RaidMonk_M_01", 
		"INV_Chest_Cloth_PVPMage_G_01", 
		"INV_Chest_Cloth_PVPPriest_G_01", 
		"INV_Chest_Cloth_RaidMage_N_01", 
		"INV_Chest_Leather_PVPDruid_G_01", 
		"INV_Chest_Leather_PVPMonk_G_01", 
		"INV_Chest_Leather_PVPRogue_G_01", 
		"INV_Chest_Leather_RaidMonk_N_01", 
		"INV_Chest_Leather_RaidRogue_N_01", 
		"INV_Chest_Mail_KorKronShaman_D_01", 
		"INV_Chest_Mail_PVPHunter_G_01", 
		"INV_Chest_Mail_PVPShaman_G_01", 
		"INV_Chest_Mail_RaidHunter_N_01", 
		"INV_Chest_Plate_PVPPaladin_G_01", 
		"INV_Chest_Plate_RaidDeathKnight_N_01", 
		"Inv_Chest_Plate_RaidWarrior_N_01",
		"INV_Cloth_PVPWarlock_G_01Chest",  
		"INV_Cloth_RaidPriest_N_01Chest",

		"INV_Cloth_RaidPriest_N_01Robe", 
		"INV_Cloth_PVPWarlock_G_01Robe", 	
		"INV_Leather_RaidDruid_N_01Chest",
		"INV_Mail_RaidShaman_N_01Chest",
		"INV_Robe_Cloth_RaidWarlock_N_01", 
		"INV_Robe_Leather_PVPMonk_G_01", 
		"INV_Robe_Leather_RaidMonk_N_01",
		"INV_Plate_PVPDeathKnight_G_01_CHEST", 
		"INV_Plate_PVPWarrior_G_01Chest", 
		"INV_Plate_RaidPaladin_N_01Robe", 	
		"INV_Leather_RaidDruid_N_01Helm", 
		"INV_Mail_RaidShaman_N_01Helm", 
		"INV_Plate_PVPDeathKnight_G_01_HELM", 
		"INV_Plate_PVPWarrior_G_01Helm", 	
		"INV_Chest_Cloth_Draenei_C_01", 
		"INV_Chest_Cloth_DraenorHonor_C_01", 
		"INV_Chest_Cloth_DraenorLFR_C_01", 
		"INV_Chest_Cloth_DraenorQuest90_B_01", 
		"INV_Chest_Cloth_PVPMageGladiator_O_01", 
		"INV_Chest_Cloth_PVPMage_O_01", 
		"INV_Chest_Cloth_PVPPriestGladiator_O_01", 
		"INV_Chest_Cloth_PVPPriest_O_01", 
		"INV_Chest_Cloth_PVPWarlock_O_01", 
		"INV_Chest_Cloth_RaidMageMythic_O_01", 
		"INV_Chest_Cloth_RaidMage_O_01", 
		"INV_Chest_Cloth_RaidPriestMythic_O_01", 
		"INV_Chest_Cloth_RaidPriest_O_01", 
		"INV_Chest_Cloth_ShadowmoonClan_B_01", 
		"INV_Chest_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Chest_Leather_DraenorCrafted_D_01_Horde", 
		"INV_Chest_Leather_DraenorLFR_C_01", 
		"INV_Chest_Leather_DraenorQuest90_B_01", 
		"INV_Chest_Leather_PvPMonkGladiator_O_01", 
		"INV_Chest_Leather_PvPMonk_O_01", 
		"INV_Chest_Leather_PvPRogueGladiator_O_01", 
		"INV_Chest_Leather_PVPRogue_O_01", 
		"INV_chest_Mail_DraenorCrafted_D_01_alliance", 
		"INV_chest_Mail_DraenorCrafted_D_01_Horde", 
		"INV_Chest_Mail_DraenorDungeon_C_01", 
		"INV_chest_Mail_DraenorHonor_C_01", 
		"INV_chest_Mail_DraenorLFR_C_01", 
		"INV_Chest_Mail_DraenorQuest95_B_01", 
		"INV_Chest_Mail_PvPHunterGladiator_O_01", 
		"INV_chest_Mail_PVPHunter_O_01", 
		"INV_Chest_Mail_PvPShamanGladiator_O_01", 
		"INV_chest_Mail_PVPShaman_O_01", 
		"INV_chest_Mail_RaidHunterMythic_O_01", 
		"INV_chest_Mail_RaidHunter_O_01", 
		"INV_chest_Mail_RaidShamanMythic_O_01", 
		"INV_Chest_Mail_RaidShaman_O_01", 
		"INV_Chest_Mail_WarsongClan_B_01", 
		"INV_Chest_Pant_Plate_PvPDeathKnightGladiator_O_01", 
		"INV_Chest_plate_draenordungeon_c_01", 
		"INV_Chest_Plate_DraenorHonor_C_01", 
		"INV_Chest_Plate_DraenorQuest95_B_01", 
		"INV_Chest_Plate_PvPDeathKnight_O_01", 
		"INV_Chest_Plate_PVPPaladinGladiator_O_01", 
		"INV_Chest_Plate_PVPPaladin_O_01", 
		"INV_Chest_Plate_RaidPaladinMythic_O_01", 
		"INV_Chest_Plate_RaidPaladin_O_01", 
		"INV_Robe_Cloth_Draenei_C_01", 
		"INV_Robe_Cloth_DraenorLFR_C_01", 
		"INV_Robe_Cloth_DraenorQuest90_B_01", 
		"INV_Robe_Cloth_PVPMageGladiator_O_01", 
		"INV_Robe_Cloth_PVPMage_O_01", 
		"INV_Robe_Cloth_PVPPriestGladiator_O_01", 
		"INV_Robe_Cloth_PVPPriest_O_01", 
		"INV_Robe_Cloth_RaidMageMythic_O_01", 
		"INV_Robe_Cloth_RaidMage_O_01", 
		"INV_Robe_Cloth_RaidPriestMythic_O_01", 
		"INV_Robe_Cloth_RaidPriest_O_01", 
		"INV_Robe_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Robe_Leather_DraenorCrafted_D_01_Horde", 
		"INV_Robe_Mail_PvPShamanGladiator_O_01", 
		"INV_Robe_Mail_PVPShaman_O_01", 
		"INV_robe_Mail_RaidShamanMythic_O_01", 
		"INV_Robe_Mail_RaidShaman_O_01", 
		"INV_Cloth_DraenorCrafted_D_01Chest", 
		"INV_Cloth_DraenorDungeon_C_01Robe", 
		"INV_Cloth_DraenorCrafted_D_01Chest_Horde", 
		"INV_Cloth_DraenorQuest95_B_01Chest", 
		"INV_Cloth_DraenorQuest95_B_01Robe", 
		"INV_Cloth_DraenorCrafted_D_01Robe", 
		"INV_Cloth_DraenorCrafted_D_01Robe_Horde", 
		"INV_Cloth_RaidWarlock_O_01Robe",  
		"INV_Cloth_RaidWarlock_O_01Chest",
		"INV_Leather_DraenorHonor_C_01Chest", 
		"INV_LEATHER_DRAENORDUNGEON_C_01CHEST", 
		"INV_Leather_DraenorQuest95_B_01Chest", 
		"INV_Leather_PvPDruidGladiator_O_01Robe", 
		"INV_Leather_PvPDruid_O_01Robe", 

		"INV_Leather_RaidDruid_O_01Chest", 
		"INV_Leather_RaidRogueMythic_O_01Chest", 
		"INV_Leather_RaidMonk_O_01Chest", 

		"INV_Leather_RaidRogue_O_01Chest", 
		"INV_Mail_DraenorQuest90_B_01Chest", 
		"INV_Mail_ThunderLordClan_B_01Chest", 
		"INV_Plate_BlackrockClan_B_01Chest",
		"INV_Plate_DraeneiGuard_C_01Chest",
		"INV_Plate_DraenorCrafted_D_01Chest",
		"INV_Plate_DraenorLFR_C_01Chest", 
		"INV_Plate_DraenorQuest90_B_01Chest", 
		"INV_Plate_Plate_PvPWarriorGladaitor_O_01Chest", 
		"INV_Plate_Plate_PvPWarrior_O_01Chest", 
		"INV_Plate_RaidDeathKnightMythic_O_01Chest",
		"INV_Plate_RaidDeathKnight_O_01Chest",
		"INV_Plate_RaidWarrior_O_01Chest", 		
	}
	GHM_StockIcons["Drinkable"] = {
		--ok

		"INV_Cask_01",
		"INV_Drink_02",
		"INV_Drink_03",
		"INV_Drink_04",
		"INV_Drink_05",
		"INV_Drink_06",
		"INV_Drink_07",
		"INV_Drink_08",
		"INV_Drink_09",
		"INV_Drink_10",
		"INV_Drink_11",
		"INV_Drink_12",
		"INV_Drink_13",
		"INV_Drink_14",
		"INV_Drink_15",
		"INV_Drink_16",
		"INV_Drink_17",
		"INV_Drink_18",
		"INV_Drink_19",
		"INV_Drink_Milk_01",
		"INV_Drink_Milk_02",
		"INV_Drink_Milk_03",
		"INV_Drink_Milk_04",
		"INV_Drink_Milk_05",
		"INV_Cask_02",
		"INV_Cask_03",
		"INV_Cask_04",
		"INV_Drink_01",
		"INV_Drink_20",
		"INV_Drink_21",
		"INV_Drink_22",
		"INV_Drink_27_BlueSoup",
		"INV_Drink_Waterskin_01",
		"INV_Drink_Waterskin_02",
		"INV_Drink_Waterskin_03",
		"INV_Drink_Waterskin_04",
		"INV_Drink_Waterskin_05",
		"INV_Drink_Waterskin_06",
		"INV_Drink_Waterskin_07",
		"INV_Drink_Waterskin_08",
		"INV_Drink_Waterskin_09",
		"INV_Drink_Waterskin_10",
		"INV_Drink_Waterskin_11",
		"INV_Drink_Waterskin_12",
		"INV_Holiday_BrewfestBuff_01",
		"INV_Holiday_ToW_SpicePotion01",
		"INV_Holiday_ToW_SpicePotion02",
		"INV_Holiday_ToW_SpicePotion03",
		"INV_Misc_Beer_01",
		"INV_MISC_BEER_02",
		"INV_Misc_Beer_03",
		"INV_Misc_Beer_04",
		"INV_Misc_Beer_05",
		"INV_Misc_Beer_06",
		"INV_Misc_Beer_07",
		"INV_Misc_Beer_08",
		"INV_Misc_Beer_09",
		"INV_Misc_Beer_10",
		"inv_misc_goblincup01",
		"INV_Drink_23",
		"INV_Drink_28_GilneanFortifiedBrandy",
		"INV_Drink_29_SunkissedWine",
		"INV_Drink_30_BlackheartGrog",
		"INV_Drink_31_EmbalmingFluid",
		"INV_Drink_32_DisgustingRotgut",
		"INV_Drink_33_BloodRedAle",
		"inv_misc_goblincup02",
		"inv_misc_potionseta",
		"inv_misc_potionsetb",

		"Achievement_Cooking_MasteroftheStill", 
		"inv_misc_food_cooked_jadewitchbrew",
		"inv_misc_food_cooked_Ginsengtea",  
		"inv_misc_food_cooked_madbrewbreakfast", 
		"Inv_Misc_PearlMilkTea",
        		

	}
	GHM_StockIcons["Food"] = {
		-- ok
		"INV_Egg_02",
		"INV_Egg_03",
		"INV_Egg_04",
		"INV_Egg_05",
		"INV_Misc_Fish_01",
		"INV_Misc_Fish_02",
		"INV_Misc_Fish_03",
		"INV_Misc_Fish_04",
		"INV_Misc_Fish_05",
		"INV_Misc_Fish_06",
		"INV_Misc_Fish_07",
		"INV_Misc_Fish_08",
		"INV_Misc_Fish_09",
		"INV_Misc_Fish_10",
		"INV_Misc_Fish_11",
		"INV_Misc_Fish_12",
		"INV_Misc_Fish_13",
		"INV_Misc_Fish_14",
		"INV_Misc_Fish_15",
		"INV_Misc_Fish_16",
		"INV_Misc_Fish_17",
		"INV_Misc_Fish_18",
		"INV_Misc_Fish_19",
		"INV_Misc_Fish_20",
		"INV_Misc_Fish_21",
		"INV_Misc_Fish_22",
		"INV_Misc_Fish_23",
		"INV_Misc_Fish_24",
		"INV_Misc_Fish_25",
		"INV_Misc_Fish_26",
		"INV_Misc_Fish_27",
		"INV_Misc_Fish_28",
		"INV_Misc_Fish_29",
		"INV_Misc_Fish_30",
		"INV_Misc_Fish_31",
		"INV_Misc_Fish_32",
		"INV_Misc_Fish_33",
		"INV_Misc_Fish_Turtle_01",
		"INV_Misc_Fish_Turtle_02",
		"INV_Misc_Fish_Turtle_03",
		"INV_Misc_Food_01",
		"INV_Misc_Food_02",
		"INV_Misc_Food_03",
		"INV_Misc_Food_04",
		"INV_Misc_Food_05",
		"INV_Misc_Food_06",
		"INV_Misc_Food_07",
		"INV_Misc_Food_08",
		"INV_Misc_Food_09",
		"INV_Misc_Food_10",
		"INV_Misc_Food_11",
		"INV_Misc_Food_12",
		"INV_Misc_Food_13",
		"INV_Misc_Food_14",
		"INV_Misc_Food_15",
		"INV_Misc_Food_16",
		"INV_Misc_Food_17",
		"INV_Misc_Food_18",
		"INV_Misc_Food_19",
		"INV_Misc_Food_20",
		"INV_Misc_Food_21",
		"INV_Misc_Food_22",
		"INV_Misc_Food_23",
		"INV_Misc_Food_24",
		"INV_Misc_Food_25",
		"INV_Misc_Food_26",
		"INV_Misc_Food_27",
		"INV_Misc_Food_28",
		"INV_Misc_Food_29",
		"INV_Misc_Food_30",
		"INV_Misc_Food_31",
		"INV_Misc_Food_32",
		"INV_Misc_Food_33",
		"INV_Misc_Food_34",
		"INV_Misc_Food_35",
		"INV_Misc_Food_36",
		"INV_Misc_Food_37",
		"INV_Misc_Food_38",
		"INV_Misc_Food_39",
		"INV_Misc_Food_40",
		"INV_Misc_Food_41",
		"INV_Misc_Food_42",
		"INV_Misc_Food_43",
		"INV_Misc_Food_44",
		"INV_Misc_Food_45",
		"INV_Misc_Food_46",
		"INV_Misc_Food_47",
		"INV_Misc_Food_48",
		"INV_Misc_Food_49",
		"INV_Misc_Food_50",
		"INV_Misc_Food_51",
		"INV_Misc_Food_52",
		"INV_Misc_Food_53",
		"INV_Misc_Food_54",
		"INV_Misc_Food_55",
		"INV_Misc_Food_56",
		"INV_Misc_Food_57",
		"INV_Misc_Food_58",
		"INV_Misc_Food_59",
		"INV_Misc_Food_60",
		"INV_Misc_Food_61",
		"INV_Misc_Food_62",
		"INV_Misc_Food_63",
		"INV_Misc_Food_64",
		"INV_Misc_Food_65",
		"INV_Misc_Food_66",
		"INV_Misc_Food_67",
		"INV_Misc_Food_68",
		"INV_Misc_Food_69",
		"INV_Misc_Food_70",
		"INV_Misc_Food_71",
		"INV_Misc_Food_72",
		"INV_Misc_Food_Wheat_01",
		"INV_Misc_Food_Wheat_02",
		"INV_Misc_Fork&Knife",
		"INV_MISC_FOOD_164_FISH_SEADOG",
		"Achievement_Noblegarden_Chocolate_Egg", -- [175]
		"INV_Egg_01",
		"INV_Egg_06",
		"INV_Egg_07",
		"INV_Egg_08",
		"INV_Food_ChristmasFruitCake_01",
		"INV_Holiday_BeerfestPretzel01",
		"INV_Holiday_BeerfestSausage01",
		"INV_Holiday_BeerfestSausage02",
		"INV_Holiday_BeerfestSausage03",
		"INV_Holiday_BeerfestSausage04",
		"INV_Holiday_Thanksgiving_Cornucopia", -- [396]
		"INV_Holiday_ToW_SpiceBowl",
		"INV_Holiday_ToW_SpiceBrownie",
		"INV_Misc_Bowl_01",
		"INV_Misc_BreadoftheDead", -- [465]
		"INV_Misc_CandySkull", -- [466]
		"INV_Misc_CelebrationCake_01",
		"INV_Misc_EasterBasket", -- [475]
		"INV_Misc_Fish_34",
		"INV_Misc_Fish_35",
		"INV_Misc_Fish_36",
		"INV_Misc_Fish_37",
		"INV_Misc_Fish_38",
		"INV_Misc_Fish_39",
		"INV_Misc_Fish_40",
		"INV_Misc_Fish_41",
		"INV_Misc_Fish_42",
		"INV_Misc_Fish_43",
		"INV_Misc_Fish_44",
		"INV_Misc_Fish_45",
		"INV_Misc_Fish_46",
		"INV_Misc_Fish_47",
		"INV_Misc_Fish_48",
		"INV_Misc_Fish_49",
		"INV_Misc_Fish_50",
		"INV_Misc_Fish_51",
		"INV_Misc_Fish_52",
		"INV_Misc_Fish_53",
		"INV_Misc_Fish_54",
		"INV_Misc_Fish_55",
		"INV_Misc_Fish_56",
		"INV_Misc_Fish_57",
		"INV_Misc_Fish_58",
		"INV_Misc_Fish_59",
		"INV_Misc_Fish_60",
		"INV_Misc_Fish_61",
		"INV_Misc_Fish_62",
		"INV_Misc_Fish_63",
		"INV_Misc_Fish_64",
		"INV_Misc_Fish_65",
		"INV_Misc_Fish_66",
		"INV_Misc_Fish_67",
		"INV_Misc_Fish_68",
		"INV_Misc_Fish_69",
		"INV_Misc_Fish_70",
		"INV_Misc_Fish_71",
		"INV_Misc_Fish_72",
		"INV_Misc_Fish_73",
		"INV_Misc_Fish_74",
		"INV_Misc_Fish_75",
		"INV_Misc_Fish_76",
		"INV_Misc_Food_100",
		"INV_Misc_Food_100_HardCheese",
		"INV_Misc_Food_101_SourCheese",
		"INV_Misc_Food_102_FlatBread",
		"INV_Misc_Food_103_PotatoBread",
		"INV_Misc_Food_104_TundraBerries",
		"INV_Misc_Food_105_SnowPlum",
		"INV_Misc_Food_106_FjordPeach",
		"INV_Misc_Food_107_Venison",
		"INV_Misc_Food_108_MeadCaribou",
		"INV_Misc_Food_109_HoneyLichen",
		"INV_Misc_Food_110_EmperorSalmon",
		"INV_Misc_Food_111_IcefinFillet",
		"INV_Misc_Food_112_Frostcaps",
		"INV_Misc_Food_114_OrcaBlubber",
		"INV_Misc_Food_115_CondorSoup",
		"INV_Misc_Food_116_CondorLeg",
		"INV_Misc_Food_117_HeartySoup",
		"INV_Misc_Food_119_RhinoMeat",
		"INV_Misc_Food_120_SharkMeat",
		"INV_Misc_Food_121_ButterMeat",
		"INV_Misc_Food_122_Steak",
		"INV_Misc_Food_123_Roast",
		"INV_Misc_Food_124_Skewer",
		"INV_Misc_Food_125_FishChunk",
		"INV_Misc_Food_126_ClamMeat",
		"INV_Misc_Food_127_Fish",
		"INV_Misc_Food_128_Fish",
		"INV_Misc_Food_129_Fish",
		"INV_Misc_Food_130_Fish",
		"INV_Misc_Food_131_Fish",
		"INV_Misc_Food_132_Meat",
		"INV_Misc_Food_133_Meat",
		"INV_Misc_Food_134_Meat",
		"INV_Misc_Food_135_Meat",
		"INV_Misc_Food_136_Fish",
		"INV_Misc_Food_137_Meat",
		"INV_Misc_Food_138_Fish",
		"INV_Misc_Food_139_Fish",
		"INV_Misc_Food_140_Fish",
		"INV_Misc_Food_141_Fish",
		"INV_Misc_Food_142_Fish",
		"INV_Misc_Food_143_Fish",
		"INV_Misc_Food_144_CakeSlice",
		"INV_Misc_Food_145_Cake",
		"INV_Misc_Food_146_CakeSlice",
		"INV_Misc_Food_147_Cake",
		"INV_Misc_Food_148_CupCake",
		"INV_Misc_Food_149_CupCake",
		"INV_Misc_Food_150_Cookie",
		"INV_Misc_Food_151_Cookie",
		"INV_Misc_Food_152_Doughnut",
		"INV_Misc_Food_153_Doughnut",
		"inv_misc_food_154_fish_77green",
		"INV_MISC_FOOD_26",
		"INV_Misc_Food_73CinnamonRoll",
		"INV_Misc_Food_74",
		"INV_Misc_Food_75",
		"INV_Misc_Food_76",
		"INV_Misc_Food_77",
		"INV_Misc_Food_78",
		"INV_Misc_Food_79",
		"INV_MISC_FOOD_80",
		"INV_MISC_FOOD_81",
		"INV_MISC_FOOD_82",
		"INV_MISC_FOOD_83_TALBUKSTEAK",
		"INV_Misc_Food_84_RoastClefthoof",
		"INV_Misc_Food_85_StegadonBite",
		"INV_Misc_Food_86_Basilisk",
		"INV_Misc_Food_87_SporelingSnack",
		"INV_Misc_Food_88_RavagerNuggets",
		"INV_Misc_Food_89",
		"INV_Misc_Food_90",
		"INV_Misc_Food_91",
		"INV_Misc_Food_92_Lobster",
		"INV_Misc_Food_93_SkethylBerries ",
		"INV_Misc_Food_94_GaradarSharp ",
		"INV_Misc_Food_95_Grainbread",
		"INV_Misc_Food_96_ZangarCaps",
		"INV_Misc_Food_97_SunspringCarp",
		"INV_Misc_Food_98_Talbuk",
		"INV_Misc_Food_99",
		"INV_Misc_Food_DimSum",
		"INV_Misc_Food_PineNut",
		"INV_Misc_Foot_Kodo",
		"INV_SummerFest_Smorc",
		"INV_THANKSGIVING_CRANBERRYSAUCE", -- [695]
		"INV_ThanksGiving_CranberrySauce_ACT", -- [696]
		"INV_ThanksGiving_PumpkinPie", -- [697]
		"INV_ThanksGiving_PumpkinPie_ACT", -- [698]
		"INV_ThanksGiving_Stuffing", -- [699]
		"INV_ThanksGiving_Stuffing_ACT", -- [700]
		"INV_ThanksGiving_SweetPotato ", -- [701]
		"INV_ThanksGiving_SweetPotato_ACT ", -- [702]
		"INV_ThanksGiving_Turkey", -- [703]
		"INV_ThanksGiving_Turkey_ACT", -- [704]
		"INV_ValentinesBoxOfChocolates01",
		"INV_ValentinesBoxOfChocolates02",
		"INV_ValentinesCandy",
		"INV_ValentinesCandySack",
		"INV_ValentinesChocolate01",
		"INV_ValentinesChocolate02",
		"INV_ValentinesChocolate03",
		"INV_ValentinesChocolate04",
		"INV_Egg_09",
		"inv_misc_food_155_fish_78blue",
		"inv_misc_food_155_fish_78pink",
		"inv_misc_food_156_fish_yellow",
		"inv_misc_food_159_fish_white",
		"inv_misc_food_162_fish_90blue",
		"inv_misc_fortunecookie",
		 "Achievement_Cooking_MasteroftheGrill", 
		"Achievement_Cooking_MasteroftheOven", 
		"Achievement_Cooking_MasterofthePot", 
		"Achievement_Cooking_MasteroftheSteamer", 
		"Achievement_Cooking_MasteroftheWok",
		"Inv_Misc_CookedNoodles", 
		"Inv_Misc_DriedPeaches",  
		"INV_Misc_Fish_100", 
		"INV_Misc_Fish_101", 
		"INV_Misc_Fish_102", 
		"INV_Misc_Fish_103", 
		"inv_misc_fish_104", 
		"inv_misc_fish_105", 
		"INV_Misc_Fish_92", 
		"INV_Misc_Fish_93", 
		"INV_Misc_Fish_94", 
		"INV_Misc_Fish_95", 
		"INV_Misc_Fish_96", 
		"INV_Misc_Fish_97", 
		"INV_Misc_Fish_98", 
		"INV_Misc_Fish_99", 
		"INV_misc_food_165_bambooshoot01", 
		"INV_misc_food_166_bambooshoot02", 
		"INV_misc_food_167_sugarcane", 
		"INV_misc_food_168_ricecake01", 
		"inv_misc_food_cooked_braisedturtle", 
		"inv_misc_food_cooked_eternalblossomfish", 
		"inv_misc_food_cooked_firespiritsalmon", 
		"inv_misc_food_cooked_Fishcake", 
		"inv_misc_food_cooked_GoldCarpConsomme", 
		"inv_misc_food_cooked_greatpabanquet_brew", 
		"inv_misc_food_cooked_greatpabanquet_general", 
		"inv_misc_food_cooked_greatpabanquet_grill", 
		"inv_misc_food_cooked_greatpabanquet_oven", 
		"inv_misc_food_cooked_greatpabanquet_pot", 
		"inv_misc_food_cooked_greatpabanquet_steamer", 
		"inv_misc_food_cooked_greatpabanquet_wok", 
		"inv_misc_food_cooked_mogufishstew", 
		"inv_misc_food_cooked_pabanquet_brew", 
		"inv_misc_food_cooked_pabanquet_general", 
		"inv_misc_food_cooked_pabanquet_grill", 
		"inv_misc_food_cooked_pabanquet_oven", 
		"inv_misc_food_cooked_pabanquet_pot", 
		"inv_misc_food_cooked_pabanquet_steamer", 
		"inv_misc_food_cooked_pabanquet_wok", 
		"inv_misc_food_cooked_ribsandshrimp", 
		"inv_misc_food_cooked_sauteedcarrots", 
		"inv_misc_food_cooked_seamistricenoodles", 
		"inv_misc_food_cooked_shrimpdumplings", 
		"inv_misc_food_cooked_springrolls", 
		"inv_misc_food_cooked_steamcrabsurprise", 
		"inv_misc_food_cooked_swirlingmistsoup", 
		"inv_misc_food_cooked_tigersteak", 
		"inv_misc_food_cooked_twinfishplatter", 
		"inv_misc_food_cooked_valleystirfry", 
		"inv_misc_food_cooked_wildfowlroast", 
		"INV_Misc_Food_Meat_CrabMeat", 
		"INV_Misc_Food_Meat_ForestBoarMeat", 
		"INV_Misc_Food_Meat_GoatChops", 
		"INV_Misc_Food_Meat_MincedMeat", 
		"INV_Misc_Food_Meat_OxRibs", 
		"INV_Misc_Food_Meat_PheasantBreast", 
		"INV_Misc_Food_Meat_RawTigerSteak", 
		"INV_Misc_Food_Meat_ToughWolfFlank", 
		"INV_Misc_Food_Meat_YakFlanks", 
		"INV_Misc_Food_Vendor_BlackPepper", 
		"INV_Misc_Food_Vendor_Carrot", 
		"INV_Misc_Food_Vendor_Ginseng", 
		"INV_Misc_Food_Vendor_GreenCabbage", 
		"INV_Misc_Food_Vendor_GreenFishBonesCurry", 
		"INV_Misc_Food_Vendor_GreenFishCurry", 
		"INV_Misc_Food_Vendor_InstantNoodles", 
		"INV_Misc_Food_Vendor_JadeSquash", 
		"INV_Misc_Food_Vendor_MoguPumpkin", 
		"INV_Misc_Food_Vendor_PinkTurnip", 
		"INV_Misc_Food_Vendor_RedBeanBun", 
		"INV_Misc_Food_Vendor_RedBlossomLeek", 
		"INV_Misc_Food_Vendor_Rice", 
		"INV_Misc_Food_Vendor_RoastedBarlyTea", 
		"INV_Misc_Food_Vendor_Scallions", 
		"INV_Misc_Food_Vendor_SlicedPeaches", 
		"INV_Misc_Food_Vendor_SoySauce", 
		"INV_Misc_Food_Vendor_StripedMelon", 
		"INV_Misc_Food_Vendor_TangyPeachYogurt", 
		"INV_Misc_Food_Vendor_WhiteTurnip", 
		"INV_Misc_Food_Vendor_Witchberries", 
		
		"Inv_Misc_SkeweredPeanutChicken", 
		"INV_Misc_1H_PA_Pan_A_01", 
		"Inv_Misc_1H_PA_Spoon_A_01", 
		"INV_Misc_Food_Mango_ice", 
		"INV_Misc_Food_Strawberry_ice", 
		"INV_Misc_Noodle_Cart_Base_Level", 
		"INV_Misc_Noodle_Cart_Epic_Level", 
		"INV_Misc_Noodle_Cart_Intermediate_Level", 
		"INV_Misc_Noodle_Soup_Base_Level", 
		"INV_Misc_Noodle_Soup_Epic_Level", 
		"INV_Misc_Noodle_Soup_Intermediate_Level", 
		"INV_Fishing_F_Ammonite1", 
		"INV_Fishing_F_Ammonite2", 
		"INV_Fishing_F_Ammonite3", 
		"INV_Fishing_F_Gulper1", 
		"INV_Fishing_F_Gulper2", 
		"INV_Fishing_F_Gulper3", 
		"INV_Fishing_F_Saberfish1", 
		"INV_Fishing_F_Saberfish2", 
		"INV_Fishing_F_Saberfish3", 
		"INV_Fishing_F_SeaScorpion1", 
		"INV_Fishing_F_SeaScorpion2", 
		"INV_Fishing_F_SeaScorpion3", 
		"INV_Fishing_F_Skulker1", 
		"INV_Fishing_F_Skulker2", 
		"INV_Fishing_F_Skulker3", 
		"INV_Fishing_F_Sleeper1", 
		"INV_Fishing_F_Sleeper2", 
		"INV_Fishing_F_Sleeper3", 
		"INV_Fishing_F_Sturgeon1", 
		"INV_Fishing_F_Sturgeon2", 
		"INV_Fishing_F_Sturgeon3", 
		"INV_Fishing_F_Whiptail1", 
		"INV_Fishing_F_Whiptail2", 
		"INV_Fishing_F_Whiptail3", 
		"INV_Fishing_Innards_Bones", 
		"INV_Fishing_Innards_Eggs", 
		"INV_Fishing_Innards_Eye", 
		"INV_Fishing_Innards_Guts", 
		"INV_Fishing_Innards_Isopod", 
		"INV_Fishing_Innards_Meat_Ammonite", 
		"INV_Fishing_Innards_Meat_Gulper", 
		"INV_Fishing_Innards_Meat_Saberfish", 
		"INV_Fishing_Innards_Meat_SeaScorpion", 
		"INV_Fishing_Innards_Meat_Skulker", 
		"INV_Fishing_Innards_Meat_Sleeper", 
		"INV_Fishing_Innards_Meat_Sturgeon", 
		"INV_Fishing_Innards_Meat_Whiptail", 
		 "INV_misc_blackrockbarbeque", 
		"INV_misc_blackrockham", 
		"INV_misc_braisedriverbeast", 
		"INV_misc_calamaricrepes",
		"INV_misc_clefhoofpotroast", 
		"INV_misc_clefhoofsausages", 
		"INV_misc_deepfriedriverbeast", 
		"INV_Misc_Food_Draenor_CrispyFriedScorpion", 
		"INV_Misc_Food_Draenor_FatSleeperCakes", 
		"INV_Misc_Food_Draenor_FieryCalamari", 
		"INV_Misc_Food_Draenor_GrilledGulper", 
		"INV_Misc_Food_Draenor_GrilledSaberfish", 
		"INV_Misc_Food_Draenor_RawBasiliskFlesh", 
		"INV_Misc_Food_Draenor_RawBoarFlesh", 
		"INV_Misc_Food_Draenor_RawClefthoofFlesh", 
		"INV_Misc_Food_Draenor_RawElekFlesh", 
		"INV_Misc_Food_Draenor_RawRiverbeastFlesh", 
		"INV_Misc_Food_Draenor_RawRylakEgg", 
		"INV_Misc_Food_Draenor_RawTalkbukFlesh", 
		"INV_Misc_Food_Draenor_SaberfishBroth", 
		"INV_Misc_Food_Draenor_SaltedSkulker", 
		"INV_Misc_Food_Draenor_SteamedScorpion", 
		"INV_Misc_Food_Draenor_SturgeonStew", 
		"INV_Misc_Food_Draenor_WhiptailChowder", 
		"INV_misc_frostystew", 
		"INV_misc_gorgrondchowder",
		"INV_Tradeskill_Cooking_FeastofBlood", 
		"INV_Tradeskill_Cooking_FeastoftheWater", 
		




	}
	GHM_StockIcons["Gauntlet"] = {
		--ok

		"INV_Gauntlet_Pants_Robe_RaidPriest_K_01",
		"INV_Glove_Leather_PVPRogue_D_01",
		"INV_Misc_Desecrated_ClothGlove",
		"INV_Misc_Desecrated_LeatherGlove",
		"INV_Misc_Desecrated_MailGlove",
		"INV_Misc_Desecrated_PlateGloves",
		"INV_Gauntlets_01",
		"INV_Gauntlets_02",
		"INV_Gauntlets_03",
		"INV_Gauntlets_04",
		"INV_Gauntlets_05",
		"INV_Gauntlets_06",
		"INV_Gauntlets_07",
		"INV_Gauntlets_08",
		"INV_Gauntlets_09",
		"INV_Gauntlets_10",
		"INV_Gauntlets_100",
		"INV_Gauntlets_101",
		"INV_Gauntlets_102",
		"INV_Gauntlets_102v2",
		"INV_Gauntlets_102v3",
		"INV_Gauntlets_102v4",
		"INV_Gauntlets_103",
		"INV_Gauntlets_104",
		"INV_Gauntlets_105",
		"INV_Gauntlets_105v2",
		"INV_Gauntlets_105v3",
		"INV_Gauntlets_105v4",
		"INV_Gauntlets_106",
		"INV_Gauntlets_106v2",
		"INV_Gauntlets_106v3",
		"INV_Gauntlets_106v4",
		"INV_Gauntlets_107",
		"INV_Gauntlets_107v1",
		"INV_Gauntlets_107v2",
		"INV_Gauntlets_107v3",
		"INV_Gauntlets_108",
		"INV_Gauntlets_108v1",
		"INV_Gauntlets_108v2",
		"INV_Gauntlets_108v3",
		"INV_Gauntlets_109",
		"INV_Gauntlets_109v1",
		"INV_Gauntlets_109v2",
		"INV_Gauntlets_109v3",
		"INV_Gauntlets_11",
		"INV_Gauntlets_110",
		"INV_Gauntlets_110v1",
		"INV_Gauntlets_110v2",
		"INV_Gauntlets_110v3",
		"INV_Gauntlets_111",
		"INV_Gauntlets_111v2",
		"INV_Gauntlets_111v3",
		"INV_Gauntlets_111v4",
		"INV_Gauntlets_112",
		"INV_Gauntlets_112v1",
		"INV_Gauntlets_112v2",
		"INV_Gauntlets_112v3",
		"INV_Gauntlets_113",
		"INV_Gauntlets_113v1",
		"INV_Gauntlets_113v2",
		"INV_Gauntlets_113v3",
		"INV_Gauntlets_114",
		"INV_Gauntlets_114v2",
		"INV_Gauntlets_114v3",
		"INV_Gauntlets_114v4",
		"INV_Gauntlets_115",
		"INV_Gauntlets_115v1",
		"INV_Gauntlets_115v2",
		"INV_Gauntlets_115v3",
		"INV_Gauntlets_116",
		"INV_Gauntlets_116v1",
		"INV_Gauntlets_116v2",
		"INV_Gauntlets_116v3",
		"INV_Gauntlets_117",
		"INV_Gauntlets_117v1",
		"INV_Gauntlets_117v2",
		"INV_Gauntlets_117v3",
		"INV_Gauntlets_118",
		"INV_Gauntlets_118v2",
		"INV_Gauntlets_118v3",
		"INV_Gauntlets_118v4",
		"INV_Gauntlets_119",
		"INV_Gauntlets_119v1",
		"INV_Gauntlets_119v2",
		"INV_Gauntlets_119v3",
		"INV_Gauntlets_12",
		"INV_Gauntlets_120",
		"INV_Gauntlets_120v1",
		"INV_Gauntlets_120v2",
		"INV_Gauntlets_120v3",
		"INV_Gauntlets_121",
		"INV_Gauntlets_121v1",
		"INV_Gauntlets_121v2",
		"INV_Gauntlets_121v3",
		"INV_Gauntlets_122",
		"INV_Gauntlets_123",
		"INV_Gauntlets_124",
		"INV_Gauntlets_125",
		"INV_Gauntlets_126",
		"INV_Gauntlets_13",
		"INV_Gauntlets_14",
		"INV_Gauntlets_15",
		"INV_Gauntlets_16",
		"INV_Gauntlets_17",
		"INV_Gauntlets_18",
		"INV_Gauntlets_19",
		"INV_Gauntlets_20",
		"INV_Gauntlets_21",
		"INV_Gauntlets_22",
		"INV_Gauntlets_23",
		"INV_Gauntlets_24",
		"INV_Gauntlets_25",
		"INV_Gauntlets_26",
		"INV_Gauntlets_27",
		"INV_Gauntlets_28",
		"INV_Gauntlets_29",
		"INV_Gauntlets_30",
		"INV_Gauntlets_31",
		"INV_Gauntlets_32",
		"INV_Gauntlets_40",
		"INV_Gauntlets_41",
		"INV_Gauntlets_44",
		"INV_Gauntlets_47",
		"INV_Gauntlets_48",
		"INV_Gauntlets_49",
		"INV_Gauntlets_50",
		"INV_Gauntlets_51",
		"INV_Gauntlets_52",
		"INV_Gauntlets_53",
		"INV_Gauntlets_54",
		"INV_Gauntlets_55",
		"INV_Gauntlets_56",
		"INV_Gauntlets_57",
		"INV_Gauntlets_58",
		"INV_Gauntlets_59",
		"INV_Gauntlets_60",
		"INV_Gauntlets_61",
		"INV_Gauntlets_62",
		"INV_Gauntlets_63",
		"INV_Gauntlets_64",
		"INV_Gauntlets_65",
		"INV_Gauntlets_66",
		"INV_Gauntlets_67",
		"INV_Gauntlets_68",
		"INV_Gauntlets_69",
		"INV_Gauntlets_70",
		"INV_Gauntlets_71",
		"INV_Gauntlets_72",
		"INV_Gauntlets_73",
		"INV_Gauntlets_74",
		"INV_Gauntlets_75",
		"INV_Gauntlets_76",
		"INV_Gauntlets_77A",
		"INV_Gauntlets_77B",
		"INV_Gauntlets_78A",
		"INV_Gauntlets_78B",
		"INV_Gauntlets_79",
		"INV_Gauntlets_80",
		"INV_Gauntlets_81",
		"INV_Gauntlets_81Purple",
		"INV_Gauntlets_81Red",
		"INV_Gauntlets_82",
		"INV_Gauntlets_82Black",
		"INV_Gauntlets_82Silver",
		"INV_Gauntlets_83",
		"INV_Gauntlets_84",
		"INV_Gauntlets_85",
		"INV_Gauntlets_86",
		"INV_Gauntlets_87",
		"INV_Gauntlets_88",
		"INV_Gauntlets_89",
		"INV_Gauntlets_90",
		"INV_Gauntlets_90Black",
		"INV_Gauntlets_90Green",
		"INV_Gauntlets_90Purple",
		"INV_Gauntlets_91",
		"INV_Gauntlets_92",
		"INV_Gauntlets_93",
		"INV_Gauntlets_94",
		"INV_Gauntlets_95",
		"INV_Gauntlets_96",
		"INV_Gauntlets_97",
		"INV_Gauntlets_99",
		"INV_Gauntlets_Cloth_Cataclysm_B_01",
		"INV_Gauntlets_Cloth_Cataclysm_B_02",
		"INV_Gauntlets_Cloth_PVPMage_C_01",
		"INV_Gauntlets_Cloth_PVPMage_C_02",
		"INV_Gauntlets_Cloth_PVPWarlock_C_01",
		"INV_Gauntlets_Cloth_PVPWarlock_C_02",
		"INV_Gauntlets_Cloth_RaidPriest_I_01",
		"INV_Gauntlets_CLOTH_RAIDWARLOCK_I_01",
		"INV_Gauntlets_Leather_Cataclysm_B_01",
		"INV_Gauntlets_Leather_Cataclysm_B_02",
		"INV_Gauntlets_Leather_DungeonLeather_C_05",
		"INV_Gauntlets_Leather_PVPDruid_D_01",
		"INV_Gauntlets_Leather_RaidDruid_I_01",
		"INV_Gauntlets_Leather_RaidDruid_J_01",
		"INV_Gauntlets_Leather_RaidRogue_K_01",
		"INV_Gauntlets_Mail_DungeonMail_C_03",
		"INV_Gauntlets_Mail_DungeonMail_C_04",
		"INV_Gauntlets_Mail_PVPHunter_C_02",
		"INV_Gauntlets_Mail_PVPShaman_C_01",
		"INV_Gauntlets_Mail_PVPShaman_D_01",
		"INV_Gauntlets_Mail_RaidShaman_J_01",
		"INV_Gauntlets_Mail_RaidShaman_K_01",
		"INV_Gauntlets_Plate_Cataclysm_B_02",
		"INV_Gauntlets_Plate_DungeonPlate_C_04",
		"INV_Gauntlets_Plate_PVPDeathKnight_C_01",
		"INV_Gauntlets_Plate_RaidDeathKnight_I_01",
		"INV_Gauntlets_Plate_RaidPaladin_I_01",
		"INV_Gauntlets_Plate_RaidPaladin_J_01",
		"INV_Gauntlets_Plate_RaidWarrior_I_01",
		"INV_Gauntlets_Plate_RaidWarrior_K_01",
		"INV_Gauntlets_Plate_TwilightHammer_C_01",
		"INV_Gauntlets_Robe_Common_C_01",
		"INV_Gauntlets_Robe_Common_C_01v1",
		"INV_Gauntlets_Robe_Common_C_01v2",
		"INV_Gauntlets_Robe_Common_C_01v3",
		"INV_Gauntlets_Robe_DungeonRobe_C_03",
		"INV_Gauntlets_Robe_DungeonRobe_C_04",
		"INV_Gauntlets_Robe_PVPPriest_C_01",
		"INV_Gauntlets_Robe_PVPPriest_C_02",
		"INV_Gauntlets_Robe_RaidMage_J_01",
		"INV_Gauntlets_Robe_RaidPriest_J_01",
		"INV_Gauntlets_Robe_RaidWarlock_K_01",
		"INV_Gauntlet_Leather_RaidRogue_J_01",
		"INV_Gauntlet_Plate_PVPDeathKnight_C_02",
		"INV_Gauntlet_Plate_PVPDeathKnight_D_01",
		"INV_Gauntlet_Plate_RaidPaladin_K_01",
		"inv_glove_leather_pvpdruid_c_01",
		"INV_Glove_Leather_RaidDruid_K_01",
		"INV_Glove_Mail_DungeonMail_C_05",
		"inv_glove_mail_pvphunter_c_01",
		"INV_Glove_Mail_PVPHunter_D_01",
		"INV_Glove_Mail_RaidHunter_K_01",
		"INV_Glove_Plate_DungeonPlate_C_05",
		"INV_Glove_Plate_DungeonPlate_C_06",
		"inv_glove_plate_pvppaladin_c_01",
		"INV_Glove_Plate_PVPPaladin_D_01",
		"INV_Glove_Plate_PVPWarrior_D_01",
		"INV_Glove_Robe_DungeonRobe_C_05",
		"INV_Glove_Robe_PVPMage_D_01",
		"INV_Glove_Robe_PVPPriest_D_01",
		"INV_Glove_Robe_PVPWarlock_D_01",
		"INV_Glove_Robe_RaidMage_K_01",
		"inv_misc_desecrated_leatherglove",
		"Plate_RaidDeathKnight_K_01_Glove",
		"INV_Gauntlets_Cloth_ChallengePriest_D_01", 
		"INV_Gauntlets_Cloth_DungeonCloth_C_06", 
		"INV_Gauntlets_Cloth_Panda_B_02", 
		"INV_Gauntlets_Cloth_Panda_B_02_Blue", 
		"INV_Gauntlets_Cloth_Panda_B_02_White", 
		"INV_Gauntlets_Cloth_Reputation_C_01", 
		"INV_Gauntlets_Leather_ChallengeRogue_D_01", 
		"INV_Gauntlets_Leather_DungeonLeather_C_06", 
		"INV_Gauntlets_Leather_Panda_B_01", 
		"INV_Gauntlets_Leather_Panda_B_01Dark", 
		"INV_Gauntlets_Leather_Panda_B_01Light", 
		"INV_Gauntlets_Leather_Panda_B_01Red", 
		"INV_Gauntlets_Leather_RaidRogue_L_01", 
		"INV_Gauntlets_Mail_Panda_B_01", 
		"INV_Gauntlets_Mail_Panda_B_01Green", 
		"INV_Gauntlets_Mail_Panda_B_01White", 
		"INV_Gauntlets_Plate_DungeonPlate_C_07", 
		"INV_Gauntlets_Plate_Panda_B_02", 
		"INV_Gauntlets_Plate_Panda_B_02Green", 
		"INV_Gauntlets_Plate_Panda_B_02Purple", 
		"INV_Gauntlets_Plate_Panda_B_02Yellow", 
		"INV_Gauntlets_Plate_PVPPaladin_E_01", 
		"INV_Gauntlets_Plate_PVPWarrior_E_01", 
		"INV_Gauntlets_Plate_RaidDeathKnight_L_01", 
		"INV_Gauntlets_PVPPriest_E_01", 
		"INV_Gauntlet_Cloth_RaidPriest_L_01", 
		"INV_Gauntlet_Plate_RaidWarrior_L_01", 
		"INV_Gloves_Cloth_Panda_B_01", 
		"INV_Gloves_Cloth_Panda_B_01_Green", 
		"INV_Gloves_Cloth_Panda_B_01_Red", 
		"INV_Gloves_Mail_Panda_B_02", 
		"INV_Glove_ChallengeDruid_D_01", 
		"INV_Glove_Cloth_ChallengeMage_D_01", 
		"INV_Glove_Cloth_RaidWarlock_L_01", 
		"INV_Glove_Leather_ChallengeMonk_D_01", 
		"INV_Glove_Leather_Panda_B_02", 
		"INV_Glove_Leather_Panda_B_02_Brown", 
		"INV_Glove_Leather_Panda_B_02_Crimson", 
		"INV_Glove_Leather_Panda_B_02_Indigo", 
		"INV_Glove_Leather_PanProg_B_01", 
		"INV_Glove_Leather_PVPDruid_E_01", 
		"INV_Glove_Leather_PVPMonk_E_01", 
		"INV_Glove_Leather_PVPRogue_E_01", 
		"INV_Glove_Leather_RaidDruid_L_01", 
		"INV_Glove_Leather_RaidMonk_L_01", 
		"INV_Glove_Leather_Reputation_C_01", 
		"INV_Glove_Mail_ChallengeHunter_D_01", 
		"INV_Glove_Mail_ChallengeShaman_D_01", 
		"INV_Glove_Mail_DungeonMail_C_06", 
		"INV_Glove_Mail_PanProg_B_01", 
		"INV_Glove_Mail_PVPHunter_E_01", 
		"INV_Glove_Mail_PVPShaman_E_01", 
		"INV_Glove_Mail_RaidHunter_L_01", 
		"INV_Glove_Mail_RaidShaman_L_01", 
		"INV_Glove_Mail_Reputation_C_01", 
		"INV_Glove_Plate_ChallengeDeathKnight_D_01", 
		"INV_Glove_Plate_ChallengePaladin_D_01", 
		"INV_Glove_Plate_ChallengeWarrior_D_01", 
		"INV_Glove_Plate_Panda_B_01", 
		"INV_Glove_Plate_Panda_B_01Blue", 
		"INV_Glove_Plate_Panda_B_01Gold", 
		"INV_Glove_Plate_PVPDeathKnight_E_01", 
		"INV_Glove_Plate_RaidPaladin_L_01", 
		"INV_Glove_Plate_Reputation_C_01", 
		"INV_Glove_PVPWarlock_E_01", 
		"INV_Glove_RaidMage_L_01", 
		"INV_Glove_Robe_PanProg_B_01", 
		"INV_Glove_Robe_PVPMage_E_01", 
		
		"INV_Cloth_RaidPriest_M_01Glove", 
		"INV_Cloth_PVPWarlock_F_01Glove", 
		"INV_Gauntlets_Leather_PVPRogue_F_01", 
		"INV_Gauntlets_Plate_PVPDeathKnight_F_01", 
		"INV_Gauntlets_Plate_PVPPaladin_F_01Bronze", 
		"INV_Gauntlets_Plate_PVPPaladin_F_01Red", 
		"INV_Gauntlets_Plate_PVPPaladin_F_01White", 
		"INV_Gauntlet_PVPWarrior_F_01", 
		"INV_Gloves_Cloth_PVPMage_F_01", 
		"INV_Gloves_Plate_DeathKnight_M_01", 
		"INV_Gloves_Plate_RaidWarrior_M_01", 
		"INV_Glove_Cloth_PVPPriest_F_01", 
		"INV_Glove_Cloth_RaidMage_M_01", 
		"INV_Glove_Cloth_RaidWarlock_M_01", 
		"INV_Glove_Leather_PVPMonk_F_01", 
		"INV_Glove_Leather_RaidMonk_M_01", 
		"INV_Glove_Leather_RaidRogue_M_01", 
		"INV_Glove_Mail_PVPShaman_F_01", 
		"INV_Glove_Mail_RaidHunter_M_01", 
		"INV_Glove_Mail_RaidShaman_M_01", 
		"INV_Glove_Plate_RaidPaladin_M_01", 
		"INV_Leather_RaidDruid_M_01Glove",
		"INV_Cloth_RaidPriest_N_01Glove",
		"INV_Cloth_PVPWarlock_G_01Glove", 	
		"INV_Gauntlets_Leather_PVPRogue_G_01", 
		"Inv_Gauntlet_Plate_RaidWarrior_N_01", 
		"INV_Gloves_Plate_RaidDeathKnight_N_01", 
		"INV_Glove_Cloth_PVPMage_G_01", 
		"INV_Glove_Cloth_PVPPriest_G_01", 
		"INV_Glove_Cloth_RaidMage_N_01", 
		"INV_Glove_Cloth_RaidWarlock_N_01", 
		"INV_Glove_Leather_PVPDruid_G_01", 
		"INV_Glove_Leather_PVPMonk_G_01", 
		"INV_Glove_Leather_RaidMonk_N_01", 
		"INV_Glove_Leather_RaidRogue_N_01", 
		"INV_Glove_Mail_KorKronShaman_D_01", 
		"INV_Glove_Mail_PVPHunter_G_01", 
		"INV_Glove_Mail_PVPShaman_G_01", 
		"INV_Glove_Mail_RaidHunter_N_01", 
		"INV_Glove_Plate_PVPPaladin_G_01", 
		"INV_Leather_RaidDruid_N_01Glove",
		"INV_Mail_RaidShaman_N_01Glove", 
		"INV_Plate_PVPDeathKnight_G_01_GLOVE",   
		"INV_Plate_RaidPaladin_N_01Glove",
		"INV_Plate_PVPWarrior_G_01Glove",   
		"INV_Glove_Cloth_Draenei_C_01", 
		"INV_Glove_Cloth_DraenorHonor_C_01", 
		"INV_Glove_Cloth_DraenorLFR_C_01", 
		"INV_Glove_Cloth_DraenorQuest90_B_01", 
		"INV_Glove_Cloth_PVPMageGLadiator_O_01", 
		"INV_Glove_Cloth_PVPMage_O_01", 
		"INV_Glove_Cloth_PVPPriestGladiator_O_01", 
		"INV_Glove_Cloth_PVPPriest_O_01", 
		"INV_Glove_Cloth_PVPWarlock_O_01", 
		"INV_Glove_Cloth_RaidMageMythic_O_01", 
		"INV_Glove_Cloth_RaidMage_O_01", 
		"INV_Glove_Cloth_RaidPriestMythic_O_01", 
		"INV_Glove_Cloth_RaidPriest_O_01", 
		"INV_Glove_Cloth_ShadowmoonClan_B_01", 
		"INV_Glove_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Glove_Leather_DraenorCrafted_D_01_Horde", 
		"INV_Glove_Leather_DraenorLFR_C_01", 
		"INV_Glove_Leather_DraenorQuest90_B_01", 
		"INV_Glove_Leather_PvPMonkGladiator_O_01", 
		"INV_Glove_Leather_PvPMonk_O_01", 
		"INV_Glove_Leather_PvPRogueGladiator_O_01", 
		"INV_Glove_Leather_PVPRogue_O_01", 
		"INV_glove_Mail_DraenorCrafted_D_01_Alliance]", 
		"INV_glove_Mail_DraenorCrafted_D_01_Horde", 
		"INV_Glove_Mail_DraenorDungeon_C_01", 
		"INV_glove_Mail_DraenorHonor_C_01", 
		"INV_glove_Mail_DraenorLFR_C_01", 
		"INV_Glove_Mail_DraenorQuest95_B_01", 
		"INV_Glove_Mail_PvPHunterGladiator_O_01", 
		"INV_GLOVE_Mail_PVPHunter_O_01", 
		"INV_Glove_Mail_PvPShamanGladiator_O_01", 
		"INV_Glove_Mail_PVPShaman_O_01", 
		"INV_glove_Mail_RaidHunterMythic_O_01", 
		"INV_glove_Mail_RaidHunter_O_01", 
		"INV_Glove_Mail_RaidShamanMythic_O_01", 
		"INV_Glove_Mail_RaidShaman_O_01", 
		"INV_Glove_Mail_WarsongClan_B_01", 
		"INV_Glove_plate_draenordungeon_c_01", 
		"INV_Glove_Plate_DraenorHonor_C_01", 
		"INV_Glove_Plate_DraenorQuest95_B_01", 
		"INV_Glove_Plate_PvPDeathKnightGladiator_O_01", 
		"INV_Glove_Plate_PvPDeathKnight_O_01", 
		"INV_Glove_Plate_PVPPaladinGladiator_O_01", 
		"INV_Glove_Plate_PVPPaladin_O_01", 
		"INV_Glove_Plate_RaidPaladinMythic_O_01", 
		"INV_Glove_Plate_RaidPaladin_O_01", 
 
		"INV_Cloth_DraenorCrafted_D_01Gloves", 
		"INV_Cloth_DraenorCrafted_D_01Gloves_Horde", 
		"INV_Cloth_DraenorDungeon_C_01Glove", 
		"INV_Cloth_DraenorQuest95_B_01Glove", 
		"INV_Cloth_RaidWarlock_O_01Gloves", 
		"INV_Leather_DraenorDungeon_C_01Glove", 
		"INV_Leather_DraenorHonor_C_01Glove",
		"INV_Leather_DraenorQuest95_B_01Glove",
		"INV_Leather_PvPDruidGladiator_O_01Glove", 
		"INV_Leather_PvPDruid_O_01Glove", 
		"INV_Leather_RaidDruid_O_01Glove", 
		"INV_Leather_RaidMonk_O_01Glove", 
		"INV_Leather_RaidRogueMythic_O_01Glove",
		"INV_Leather_RaidRogue_O_01Glove", 
		"INV_Mail_DraenorQuest90_B_01Glove", 
		"INV_Mail_ThunderLordClan_B_01Glove", 		
		"INV_Plate_BlackrockClan_B_01Glove",
		"INV_Plate_DraeneiGuard_C_01Glove",
		"INV_Plate_DraenorCrafted_D_01Glove", 
		"INV_Plate_DraenorLFR_C_01Glove", 
		"INV_Plate_DraenorQuest90_B_01Glove",
		"INV_Plate_Plate_PvPWarriorGladaitor_O_01Gloves",
		"INV_Plate_Glove_DraenorHonor_C_01", 
		"INV_Plate_Plate_PvPWarrior_O_01Gloves", 
		"INV_Plate_RaidDeathKnightMythic_O_01Glove", 
		"INV_Plate_RaidDeathKnight_O_01Glove", 
		"INV_Plate_RaidWarrior_O_01Gloves",




  
	}
	GHM_StockIcons["Hammer"] = {
		-- ok
		"INV_hammer_01",
		"INV_Hammer_32",
		"INV_hammer_02",
		"INV_hammer_03",
		"INV_hammer_04",
		"INV_hammer_05",
		"INV_hammer_06",
		"INV_hammer_07",
		"INV_hammer_08",
		"INV_hammer_09",
		"INV_hammer_10",
		"INV_hammer_11",
		"INV_hammer_12",
		"INV_hammer_13",
		"INV_hammer_14",
		"INV_hammer_15",
		"INV_hammer_16",
		"INV_hammer_17",
		"INV_hammer_18",
		"INV_hammer_19",
		"INV_hammer_20",
		"INV_hammer_21",
		"INV_hammer_22",
		"INV_hammer_23",
		"INV_hammer_24",
		"INV_hammer_25",
		"INV_hammer_26",
		"INV_hammer_27",
		"INV_hammer_28",
		"INV_hammer_29",
		"INV_hammer_31",
		"INV_hammer_Unique_Sulfuras",
		"INV_Hammer_1H_DraeneiPaladin_C_01", 
		"INV_Hammer_1H_PVPHorde_A_01Red_UpRes",
	}
	GHM_StockIcons["Helmet"] = {
		-- ok
		"INV_Circlet_Firelands_D_01",
		"INV_Crown_01",
		"INV_Crown_13",
		"INV_Crown_14",
		"INV_Crown_15",
		"INV_Helm_Mask_ZulGurub_D_01",
		"INV_Mask_03",
		"INV_Mask_04",
		"INV_Mask_05",
		"INV_Mask_06",
		"INV_Misc_Desecrated_ClothHelm",
		"INV_Misc_Desecrated_LeatherHelm",
		"INV_Misc_Desecrated_MailHelm",
		"INV_Misc_Desecrated_PlateHelm",
		"INV_Crown_02",
		"INV_Mask_01",
		"INV_Mask_02",
		"INV_Misc_Bandana_01",
		"INV_Misc_Bandana_03",
		"INV_Helm_Mail_PVPHunter_D_01",
		"INV_Helmet128",
		"INV_Helmet_01",
		"INV_Helmet_02",
		"INV_Helmet_03",
		"INV_Helmet_04",
		"INV_Helmet_05",
		"INV_Helmet_06",
		"INV_Helmet_07",
		"INV_Helmet_08",
		"INV_Helmet_09",
		"INV_Helmet_10",
		"INV_HelmET_100",
		"INV_HelmET_101",
		"INV_HelmET_102",
		"INV_HelmET_103",
		"INV_Helmet_104",
		"INV_Helmet_105",
		"INV_Helmet_106",
		"INV_Helmet_107",
		"INV_Helmet_108",
		"INV_Helmet_109",
		"INV_Helmet_11",
		"INV_Helmet_110",
		"INV_Helmet_111",
		"INV_Helmet_112",
		"INV_Helmet_113",
		"INV_Helmet_114",
		"INV_Helmet_115",
		"INV_Helmet_116",
		"INV_Helmet_117",
		"INV_Helmet_118",
		"INV_Helmet_119",
		"INV_Helmet_12",
		"INV_Helmet_120",
		"INV_Helmet_121",
		"INV_Helmet_122",
		"INV_Helmet_124",
		"INV_Helmet_125",
		"INV_Helmet_126",
		"INV_HelmET_127",
		"INV_Helmet_129",
		"INV_Helmet_13",
		"INV_Helmet_130",
		"INV_Helmet_131",
		"INV_Helmet_132",
		"INV_Helmet_133",
		"INV_Helmet_134",
		"INV_Helmet_135",
		"INV_Helmet_136",
		"INV_Helmet_137",
		"INV_Helmet_138",
		"INV_Helmet_139",
		"INV_Helmet_14",
		"INV_Helmet_140",
		"INV_Helmet_141",
		"INV_Helmet_142",
		"INV_Helmet_144A",
		"INV_Helmet_144B",
		"INV_Helmet_145A",
		"INV_Helmet_145B",
		"INV_Helmet_146",
		"INV_Helmet_147",
		"INV_Helmet_148",
		"INV_Helmet_149",
		"INV_Helmet_15",
		"INV_Helmet_150",
		"INV_Helmet_150Black",
		"INV_Helmet_150Green",
		"INV_Helmet_150Purple",
		"INV_Helmet_150Red",
		"INV_Helmet_151",
		"INV_Helmet_152",
		"INV_Helmet_153",
		"INV_Helmet_154",
		"INV_Helmet_155",
		"INV_Helmet_156",
		"INV_Helmet_157",
		"INV_Helmet_158",
		"INV_Helmet_159",
		"INV_Helmet_16",
		"INV_Helmet_160",
		"INV_Helmet_161",
		"INV_Helmet_164",
		"INV_Helmet_165",
		"INV_Helmet_166",
		"INV_Helmet_168",
		"INV_Helmet_169",
		"INV_Helmet_17",
		"INV_Helmet_170",
		"INV_Helmet_171",
		"INV_Helmet_173",
		"INV_Helmet_173v2",
		"INV_Helmet_173v3",
		"INV_Helmet_173v4",
		"INV_Helmet_174",
		"INV_Helmet_174v1",
		"INV_Helmet_174v2",
		"INV_Helmet_174v3",
		"INV_Helmet_175",
		"INV_Helmet_175v1",
		"INV_Helmet_175v2",
		"INV_Helmet_175v3",
		"INV_Helmet_176",
		"INV_Helmet_177",
		"INV_Helmet_177v1",
		"INV_Helmet_177v2",
		"INV_Helmet_177v3",
		"INV_Helmet_178",
		"INV_Helmet_178v1",
		"INV_Helmet_178v2",
		"INV_Helmet_178v3",
		"INV_Helmet_179",
		"INV_Helmet_179v1",
		"INV_Helmet_179v2",
		"INV_Helmet_179v3",
		"INV_Helmet_18",
		"INV_Helmet_180",
		"INV_Helmet_180v1",
		"INV_Helmet_180v2",
		"INV_Helmet_180v3",
		"INV_Helmet_181",
		"INV_Helmet_181v2",
		"INV_Helmet_181v3",
		"INV_Helmet_181v4",
		"INV_Helmet_182",
		"INV_Helmet_182v1",
		"INV_Helmet_182v2",
		"INV_Helmet_182v3",
		"INV_Helmet_183",
		"INV_Helmet_183v1",
		"INV_Helmet_183v2",
		"INV_Helmet_183v3",
		"INV_Helmet_184",
		"INV_Helmet_184v1",
		"INV_Helmet_184v2",
		"INV_Helmet_184v3",
		"INV_Helmet_185",
		"INV_Helmet_185v1",
		"INV_Helmet_185v2",
		"INV_Helmet_185v3",
		"INV_Helmet_186",
		"INV_Helmet_186v2",
		"INV_Helmet_186v3",
		"INV_Helmet_186v4",
		"INV_Helmet_187",
		"INV_Helmet_187v1",
		"INV_Helmet_187v2",
		"INV_Helmet_187v3",
		"INV_Helmet_188",
		"INV_Helmet_188v1",
		"INV_Helmet_188v2",
		"INV_Helmet_188v3",
		"INV_Helmet_189",
		"INV_Helmet_19",
		"INV_Helmet_190",
		"INV_Helmet_191",
		"INV_Helmet_192",
		"INV_Helmet_193",
		"INV_Helmet_20",
		"INV_Helmet_21",
		"INV_Helmet_22",
		"INV_Helmet_23",
		"INV_Helmet_24",
		"INV_Helmet_25",
		"INV_Helmet_26",
		"INV_Helmet_27",
		"INV_Helmet_28",
		"INV_Helmet_29",
		"INV_Helmet_30",
		"INV_Helmet_31",
		"INV_Helmet_32",
		"INV_Helmet_33",
		"INV_Helmet_34",
		"INV_Helmet_35",
		"INV_Helmet_36",
		"INV_Helmet_37",
		"INV_Helmet_38",
		"INV_Helmet_39",
		"INV_Helmet_40",
		"INV_Helmet_41",
		"INV_Helmet_42",
		"INV_Helmet_43",
		"INV_Helmet_44",
		"INV_Helmet_45",
		"INV_Helmet_46",
		"INV_Helmet_47",
		"INV_Helmet_48",
		"INV_Helmet_49",
		"INV_Helmet_50",
		"INV_Helmet_51",
		"INV_Helmet_52",
		"INV_Helmet_53",
		"INV_Helmet_54",
		"INV_Helmet_55",
		"INV_Helmet_56",
		"INV_Helmet_57",
		"INV_Helmet_58",
		"INV_Helmet_59",
		"INV_Helmet_60",
		"INV_Helmet_61",
		"INV_Helmet_62",
		"INV_Helmet_63",
		"INV_Helmet_64",
		"INV_Helmet_65",
		"INV_Helmet_66",
		"INV_Helmet_67",
		"INV_Helmet_68",
		"INV_Helmet_69",
		"INV_Helmet_70",
		"INV_Helmet_71",
		"INV_Helmet_72",
		"INV_Helmet_73",
		"INV_Helmet_74",
		"INV_Helmet_77",
		"INV_Helmet_78",
		"INV_Helmet_81",
		"INV_Helmet_84",
		"INV_Helmet_85",
		"INV_Helmet_86",
		"INV_Helmet_87",
		"INV_Helmet_88",
		"INV_Helmet_89",
		"INV_Helmet_90",
		"INV_Helmet_91",
		"INV_Helmet_92",
		"INV_HelmET_93",
		"INV_HelmET_94",
		"INV_HelmET_95",
		"INV_HelmET_96",
		"INV_HelmET_97",
		"INV_HelmET_98",
		"INV_Helmet_99",
		"INV_Helmet_Cloth_Cataclysm_B_01",
		"INV_Helmet_Cloth_Cataclysm_B_02",
		"INV_Helmet_Cloth_PVPMage_C_02",
		"INV_Helmet_Cloth_PVPWarlock_C_01",
		"INV_Helmet_Cloth_PVPWarlock_C_02",
		"INV_Helmet_Cloth_RaidPriest_I_01",
		"INV_Helmet_Cloth_RaidWarlock_I_01",
		"INV_Helmet_LeatherRaidRogue_I_01",
		"INV_Helmet_Leather_Cataclysm_B_01",
		"INV_Helmet_Leather_Cataclysm_B_02",
		"INV_Helmet_Leather_DungeonLeather_C_05",
		"INV_Helmet_Leather_PVPDruid_D_01",
		"INV_Helmet_Leather_PVPRogue_C_01",
		"INV_Helmet_Leather_PVPRogue_C_02",
		"INV_Helmet_Leather_PVPRogue_D_01",
		"INV_Helmet_Leather_RaidDruid_I_01",
		"INV_Helmet_Leather_RaidDruid_J_01",
		"INV_Helmet_Leather_RaidDruid_K_01",
		"INV_Helmet_Leather_RaidRogue_J_01",
		"INV_Helmet_Leather_RaidRogue_K_01",
		"INV_Helmet_Mail_DungeonMail_C_03",
		"INV_Helmet_Mail_DungeonMail_C_04",
		"INV_Helmet_Mail_DungeonMail_C_05",
		"INV_Helmet_Mail_PVPHunter_C_02",
		"INV_Helmet_Mail_PVPShaman_C_01",
		"INV_Helmet_Mail_PVPShaman_D_01",
		"INV_Helmet_Mail_RaidShaman_J_01",
		"INV_Helmet_Mail_RaidShaman_K_01",
		"INV_Helmet_Plate_Cataclysm_B_02",
		"INV_Helmet_Plate_DungeonPlage_C_04",
		"INV_Helmet_Plate_DungeonPlate_C_03",
		"INV_Helmet_Plate_PVPPaladin_D_01",
		"INV_Helmet_Plate_RaidDeathKnight_I_01",
		"INV_Helmet_Plate_RaidDeathKnight_J_01",
		"INV_Helmet_Plate_RaidPaladin_I_01",
		"INV_Helmet_Plate_RaidPaladin_J_01",
		"INV_Helmet_Plate_RaidWarrior_I_01",
		"INV_Helmet_Plate_RaidWarrior_K_01",
		"INV_Helmet_RaidShaman_I_01",
		"INV_Helmet_Robe_Common_C_01",
		"INV_Helmet_Robe_Common_C_01v1",
		"INV_Helmet_Robe_Common_C_01v2",
		"INV_Helmet_Robe_Common_C_01v3",
		"INV_Helmet_Robe_DungeonRobe_C_03",
		"INV_Helmet_Robe_PVPMage_D_01",
		"INV_Helmet_Robe_PVPWarlock_D_01",
		"INV_Helmet_Robe_RaidMage_J_01",
		"INV_Helmet_Robe_RaidPriest_J_01",
		"INV_Helmet_Robe_RaidWarlock_K_01",
		"INV_Helm_Circlet_Firelands_D_01",
		"INV_Helm_Cloth_PVPMage_C_01",
		"INV_Helm_Leather_FirelandsDruid_D_01",
		"INV_Helm_Leather_PVPDruid_C_01",
		"INV_Helm_Leather_PVPDruid_C_02",
		"INV_Helm_Mail_D_01",
		"INV_Helm_Mail_PVPHunter_C_01",
		"INV_Helm_Mail_PVPShaman_C_02",
		"INV_Helm_Mail_RaidHunter_I_01",
		"INV_Helm_Mail_RaidHunter_J_01",
		"INV_Helm_Mail_RaidHunter_K_01",
		"INV_Helm_Mask_ZulGurub_D_01",
		"INV_Helm_Plate_DungeonPlate_C_05",
		"INV_Helm_Plate_DungeonPlate_C_06",
		"INV_Helm_Plate_PVPDeathKnight_C_01",
		"INV_Helm_Plate_PVPDeathKnight_C_02",
		"INV_Helm_Plate_PVPDeathKnight_D_01",
		"INV_Helm_Plate_PVPPaladin_C_01",
		"INV_Helm_Plate_PVPPaladin_C_02",
		"INV_Helm_Plate_PVPWarrior_C_01",
		"INV_Helm_Plate_PVPWarrior_C_02",
		"INV_Helm_Plate_PVPWarrior_D_01",
		"INV_Helm_Plate_RaidPaladin_K_01",
		"INV_Helm_Plate_RaidWarrior_J_01",
		"INV_Helm_Plate_TwilightHammer_C_01",
		"INV_Helm_Robe_DungeonRobe_C_04",
		"INV_Helm_Robe_DungeonRobe_C_05",
		"INV_Helm_Robe_PVPPriest_C_01",
		"INV_Helm_Robe_PVPPriest_C_02",
		"INV_Helm_Robe_PVPPriest_D_01",
		"INV_Helm_Robe_RaidMage_I_01",
		"INV_Helm_Robe_RaidMage_K_01",
		"INV_Helm_Robe_RaidPriest_K_01",
		"INV_Helm_Robe_RaidWarlock_J_01",
		"Plate_RaidDeathKnight_K_01_Helm",
		"INV_Helmet_ChallengeDruid_D_01", 
		"INV_Helmet_Cloth_ChallengePriest_D_01", 
		"INV_Helmet_Cloth_DungeonCloth_C_06", 
		"INV_Helmet_Cloth_Panda_B_01", 
		"INV_Helmet_Cloth_Panda_B_01_Green", 
		"INV_Helmet_Cloth_Panda_B_01_Red", 
		"INV_Helmet_Cloth_Panda_B_02", 
		"INV_Helmet_Cloth_Panda_B_02_Blue", 
		"INV_Helmet_Cloth_Panda_B_02_White", 
		"INV_Helmet_Cloth_RaidWarlock_L_01", 
		"INV_Helmet_Cloth_Reputation_C_01", 
		"INV_Helmet_Cloth_Shadowpan_A_02", 
		"INV_Helmet_Goggles_PandariaTradeskill_D_01", 
		"INV_Helmet_Leather_ChallengeRogue_D_01", 
		"INV_Helmet_Leather_DungeonLeather_C_06", 
		"INV_Helmet_Leather_Panda_B_01", 
		"INV_Helmet_Leather_Panda_B_01Dark", 
		"INV_Helmet_Leather_Panda_B_01Light", 
		"INV_Helmet_Leather_Panda_B_01Red", 
		"INV_Helmet_Leather_RaidMonk_L_01", 
		"INV_Helmet_Leather_RaidRogue_L_01", 
		"INV_Helmet_Mail_ChallengeHunter_D_01", 
		"INV_Helmet_Mail_ChallengeShaman_D_01", 
		"INV_Helmet_Mail_Panda_B_01", 
		"INV_Helmet_Mail_Panda_B_01Green", 
		"INV_Helmet_Mail_Panda_B_01White", 
		"INV_Helmet_Mail_Panda_B_02", 
		"INV_Helmet_Mail_PVPHunter_E_01", 
		"INV_Helmet_Plate_ChallengePaladin_D_01", 
		"INV_Helmet_Plate_DungeonPlate_C_07", 
		"INV_Helmet_Plate_Panda_B_01", 
		"INV_Helmet_Plate_Panda_B_02", 
		"INV_Helmet_Plate_Panda_B_02Green", 
		"INV_Helmet_Plate_Panda_B_02Purple", 
		"INV_Helmet_Plate_Panda_B_02Yellow", 
		"INV_Helmet_Plate_PVPDeathKnight_E_01", 
		"INV_Helmet_Plate_PVPPaladin_E_01", 
		"INV_Helmet_Plate_PVPWarrior_E_01", 
		"INV_Helmet_Plate_RaidPaladin_L_01", 
		"INV_Helmet_Plate_Reputation_C_01", 
		"INV_Helmet_PVPPriest_E_01", 
		"INV_Helmet_PVPWarlock_E_01", 
		"INV_Helm_ChallengeDruid_D_01", 
		"INV_Helm_Cloth_ChallengeMage_D_01", 
		"INV_Helm_Cloth_RaidPriest_L_01", 
		"INV_Helm_Cloth_SunHat_B_01", 
		"INV_Helm_Leather_ChallengeMonk_D_01", 
		"INV_Helm_Leather_Panda_B_02", 
		"INV_Helm_Leather_Panda_B_02_Brown", 
		"INV_Helm_Leather_Panda_B_02_Crimson", 
		"INV_Helm_Leather_Panda_B_02_Indigo", 
		"INV_Helm_Leather_PVPDruid_E_01", 
		"INV_Helm_Leather_PVPMonk_E_01", 
		"INV_Helm_Leather_PVPRogue_E_01", 
		"INV_Helm_Leather_RaidDruid_L_01", 
		"INV_Helm_Leather_Reputation_C_01", 
		"INV_Helm_Mail_DungeonMail_C_06", 
		"INV_Helm_Mail_PVPShaman_E_01", 
		"INV_Helm_Mail_RaidHunter_L_01", 
		"INV_Helm_Mail_RaidShaman_L_01", 
		"INV_Helm_Mail_Reputation_C_01", 
		"INV_Helm_Plate_ChallengeDeathKnight_D_01", 
		"INV_Helm_Plate_ChallengeWarrior_D_01", 
		"INV_Helm_Plate_PandaGuard_A_01", 
		"INV_Helm_Plate_PandaGuard_B_01", 
		"INV_Helm_Plate_Panda_B_01Blue", 
		"INV_Helm_Plate_Panda_B_01Gold", 
		"INV_Helm_Plate_RaidDeathKnight_L_01", 
		"INV_Helm_Plate_RaidWarrior_L_01", 
		"INV_Helm_RaidMage_L_01", 
		"INV_Helm_Robe_PVPMage_E_01", 
		"INV_Misc_Beerhat_A_01",
		"INV_Gnomish_XRAY_Specs", 
		"INV_Helm_Cloth_PetSafari_A_01", 
		"INV_Helm_Misc_ConePartyHat", 
		"INV_Helm_Misc_FireworkPartyHat", 
		"INV_Helm_Misc_FishPartyHat", 
		"INV_Helm_Misc_SquidPartyHat", 
		"INV_Helm_Misc_StarPartyHat", 
		"INV_Helm_Misc_VikingPartyHat", 
		"INV_Cloth_RaidPriest_M_01Helm", 
		"INV_Cloth_PVPWarlock_F_01Helm", 
		"INV_Helmet_Leather_PVPMonk_F_01", 
		"INV_Helmet_Plate_DeathKnight_M_01", 
		"INV_Helmet_Plate_PVPPaladin_F_01Bronze", 
		"INV_Helmet_Plate_PVPPaladin_F_01Red", 
		"INV_Helmet_Plate_PVPPaladin_F_01White", 
		"INV_Helmet_Plate_RaidPaladin_M_01", 
		"INV_Helmet_Plate_RaidWarrior_M_01", 
		"INV_Helm_Cloth_PVPMage_F_01", 
		"INV_Helm_Cloth_PVPPriest_F_01", 
		"INV_Helm_Cloth_RaidMage_M_01", 
		"INV_Helm_Cloth_RaidWarlock_M_01", 
		"INV_Helm_Leather_PVPRogue_F_01", 
		"INV_Helm_Leather_RaidDruid_M_01", 
		"INV_Helm_Leather_RaidMonk_M_01", 
		"INV_Helm_Leather_RaidRogue_M_01", 
		"INV_Helm_Mail_PVPHunter_F_01", 
		"INV_Helm_Mail_PVPShaman_F_01", 
		"INV_Helm_Mail_RaidHunter_M_01", 
		"INV_Helm_Mail_RaidShaman_M_01", 
		"INV_Helm_Plate_PVPDeathKnight_F_01", 
		"INV_Helm_Plate_PVPWarrior_F_01", 
		"INV_Cloth_PVPWarlock_G_01Helm",  
		"INV_Cloth_RaidPriest_N_01Helm", 
		"INV_Helmet_Mail_PVPHunter_G_01", 
		"INV_Helmet_Mail_PVPShaman_G_01", 
		"INV_Helmet_Plate_RaidDeathKnight_N_01", 
		"Inv_Helmet_Plate_RaidWarrior_N_01", 
		"INV_Helm_Cloth_PVPMage_G_01", 
		"INV_Helm_Cloth_PVPPriest_G_01", 
		"INV_Helm_Cloth_RaidMage_N_01", 
		"INV_Helm_Cloth_RaidWarlock_N_01", 
		"INV_Helm_Leather_PVPDruid_G_01", 
		"INV_Helm_Leather_PVPMonk_G_01", 
		"INV_Helm_Leather_PVPRogue_G_01", 
		"INV_Helm_Leather_RaidMonk_N_01", 
		"INV_Helm_Leather_RaidRogue_N_01", 
		"INV_Helm_Mail_KorKronShaman_D_01", 
		"INV_Helm_Mail_RaidHunter_N_01", 
		"INV_Helm_Plate_PVPPaladin_G_01", 
		"INV_Helm_Plate_RaidPaladin_N_01", 
		"INV_Helmet_123", 
		"INV_Helm_Cloth_CharCreateWarlock_B_01", 
		"INV_Helm_Cloth_Draenei_C_01", 
		"INV_Helm_Cloth_DraenorHonor_C_01", 
		"INV_Helm_Cloth_DraenorLFR_C_01", 
		"INV_Helm_Cloth_DraenorQuest90_B_01", 
		"INV_Helm_Cloth_PVPMageGladiator_O_01", 
		"INV_Helm_Cloth_PVPMage_O_01", 
		"INV_Helm_Cloth_PVPPriestGladiator_O_01", 
		"INV_Helm_Cloth_PVPPriest_O_01", 
		"INV_Helm_Cloth_PVPWarlock_O_01", 
		"INV_Helm_Cloth_RaidMageMythic_O_01", 
		"INV_Helm_Cloth_RaidMage_O_01", 
		"INV_Helm_Cloth_RaidPriestMythic_O_01", 
		"INV_Helm_Cloth_RaidPriest_O_01", 
		"INV_Helm_Cloth_ShadowmoonClan_B_01", 
		"INV_Helm_Cloth_SunHat_B_01CharCreate_Black", 
		"INV_helm_draenordungeon_c_01", 
		"INV_Helm_Goggles_DraenorTradeSkill_D_01", 
		"INV_Helm_LaughingSkull_01", 
		"INV_Helm_leather_CharCreateDruid_B_01", 
		"INV_Helm_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Helm_Leather_DraenorCrafted_D_01_Horde", 
		"INV_Helm_Leather_DraenorLFR_C_01", 
		"INV_Helm_Leather_DraenorQuest90_B_01", 
		"INV_Helm_Leather_PvPMonkGladiator_O_01", 
		"INV_Helm_Leather_PvPMonk_O_01", 
		"INV_Helm_Leather_PvPRogueGladiator_O_01", 
		"INV_Helm_Leather_PVPRogue_O_01", 
		"INV_Helm_Mail_CharCreateHunter_B_01", 
		"INV_helm_Mail_DraenorCrafted_D_01_alliance", 
		"INV_helm_Mail_DraenorCrafted_D_01_Horde", 
		"INV_Helm_Mail_DraenorDungeon_C_01", 
		"INV_helm_Mail_DraenorHonor_C_01", 
		"INV_helm_Mail_DraenorLFR_C_01", 
		"INV_Helm_Mail_DraenorQuest95_B_01", 
		"INV_Helm_Mail_PvPHunterGladiator_O_01", 
		"INV_HELM_Mail_PVPHunter_O_01", 
		"INV_Helm_Mail_PvPShamanGladiator_O_01", 
		"INV_Helm_Mail_PVPShaman_O_01", 
		"INV_helm_Mail_RaidHunterMythic_O_01", 
		"INV_helm_Mail_RaidHunter_O_01", 
		"INV_Helm_Mail_RaidShamanMythic_O_01", 
		"INV_Helm_Mail_RaidShaman_O_01", 
		"INV_Helm_Mail_WarsongClan_B_01", 
		"INV_Helm_Plate_CharCreatePaladin_B_01", 
		"INV_Helm_Plate_DraenorHonor_C_01", 
		"INV_Helm_Plate_DraenorQuest95_B_01", 
		"INV_Helm_Plate_Northrend_D_01CharCreate_Black", 
		"INV_Helm_Plate_PvPDeathKnightGladiator_O_01", 
		"INV_Helm_Plate_PvPDeathKnight_O_01", 
		"INV_Helm_Plate_PVPPaladinGladiator_O_01", 
		"INV_Helm_Plate_PVPPaladin_O_01", 
		"INV_Helm_Plate_RaidPaladinMythic_O_01", 
		"INV_Helm_Plate_RaidPaladin_O_01", 
		 "INV_Cloth_DraenorCrafted_D_01Helm", 
		"INV_Cloth_DraenorCrafted_D_01Helm_Horde", 
		"INV_Cloth_DraenorDungeon_C_01Helm", 
		"INV_Cloth_DraenorQuest95_B_01Helm", 
		"INV_Cloth_PVPWarlockGladiator_O_01Helm", 
		"INV_Cloth_RaidWarlockMythic_O_01Helm", 
		"INV_Cloth_RaidWarlock_O_01Helm", 
		"INV_Leather_DraenorDungeon_C_01Helm",
		"INV_Leather_DraenorQuest95_B_01Helm", 
		"INV_Leather_PvpDruidGladiator_O_01Helm", 
		"INV_Leather_PvpDruid_O_01Helm", 
		"INV_Leather_RaidDruidMythic_O_01Helm", 
		"INV_Leather_RaidDruid_O_01Helm", 
		"INV_Leather_RaidMonkMythic_O_01Helm", 
		"INV_Leather_RaidMonk_O_01Helm",
		"INV_Leather_RaidRogueMythic_O_01Helm", 
		"INV_Leather_RaidRogue_O_01Helm",
		"INV_Mail_DraenorQuest90_B_01Helm", 
		"INV_Mail_ThunderLordClan_B_01Pant",
		"INV_Mail_ThunderLordClan_B_01Helm",
		"INV_Plate_BlackrockClan_B_01Helm", 
		"INV_Plate_DraeneiGuard_C_01Helm", 
		"INV_Plate_DraenorCrafted_D_01Helm",		
		"INV_Plate_DraenorLFR_C_01Helm", 
		"INV_Plate_DraenorQuest90_B_01Helm",
		"INV_Plate_Plate_PvPWarriorGladaitor_O_01Helm", 
		"INV_Plate_Plate_PvPWarrior_O_01Helm", 
		"INV_Plate_RaidDeathKnightMythic_O_01Helm",
		"INV_Plate_RaidDeathKnight_O_01Helm", 
		"INV_Plate_RaidWarriorMythic_O_01Helm", 
		"INV_Plate_RaidWarrior_O_01Helm", 
  
  
  
  

	}
	GHM_StockIcons["Jewelry"] = {
		-- ok
		"INV_Jewelry_Amulet_01",
		"INV_Jewelry_Amulet_02",
		"INV_Jewelry_Amulet_03",
		"INV_Jewelry_Amulet_04",
		"INV_Jewelry_Amulet_05",
		"INV_Jewelry_Amulet_06",
		"INV_Jewelry_Amulet_07",
		"INV_Jewelry_Necklace_01",
		"INV_Jewelry_Necklace_02",
		"INV_Jewelry_Necklace_03",
		"INV_Jewelry_Necklace_04",
		"INV_Jewelry_Necklace_05",
		"INV_Jewelry_Necklace_06",
		"INV_Jewelry_Necklace_07",
		"INV_Jewelry_Necklace_08",
		"INV_Jewelry_Necklace_09",
		"INV_Jewelry_Necklace_10",
		"INV_Jewelry_Necklace_11",
		"INV_Jewelry_Ring_01",
		"INV_Jewelry_Ring_02",
		"INV_Jewelry_Ring_03",
		"INV_Jewelry_Ring_04",
		"INV_Jewelry_Ring_05",
		"INV_Jewelry_Ring_06",
		"INV_Jewelry_Ring_07",
		"INV_Jewelry_Ring_08",
		"INV_Jewelry_Ring_09",
		"INV_Jewelry_Ring_10",
		"INV_Jewelry_Ring_11",
		"INV_Jewelry_Ring_12",
		"INV_Jewelry_Ring_13",
		"INV_Jewelry_Ring_14",
		"INV_Jewelry_Ring_15",
		"INV_Jewelry_Ring_16",
		"INV_Jewelry_Ring_17",
		"INV_Jewelry_Ring_18",
		"INV_Jewelry_Ring_19",
		"INV_Jewelry_Ring_20",
		"INV_Jewelry_Ring_21",
		"INV_Jewelry_Ring_22",
		"INV_Jewelry_Ring_23",
		"INV_Jewelry_Ring_24",
		"INV_Jewelry_Ring_25",
		"INV_Jewelry_Ring_26",
		"INV_Jewelry_Ring_27",
		"INV_Jewelry_Ring_28",
		"INV_Jewelry_Ring_29",
		"INV_Jewelry_Ring_30",
		"INV_Jewelry_Ring_31",
		"INV_Jewelry_Ring_32",
		"INV_Jewelry_Ring_33",
		"Inv_Misc_EpicRing_A1", 
		"Inv_Misc_EpicRing_A2", 
		"Inv_Misc_EpicRing_A3", 
		"Inv_Misc_EpicRing_B1", 
		"Inv_Misc_EpicRing_B2", 
		"Inv_Misc_EpicRing_B3", 
		"INV_Jewelry_Talisman_01",
		"INV_Jewelry_Talisman_02",
		"INV_Jewelry_Talisman_03",
		"INV_Jewelry_Talisman_04",
		"INV_Jewelry_Talisman_05",
		"INV_Jewelry_Talisman_06",
		"INV_Jewelry_Talisman_07",
		"INV_Jewelry_Talisman_08",
		"INV_Jewelry_Talisman_09",
		"INV_Jewelry_Talisman_10",
		"INV_Jewelry_Talisman_11",
		"INV_Jewelry_Talisman_12",
		"INV_Jewelry_Talisman_13",
		"INV_Jewelry_Talisman_14",
		"INV_Jewelry_Necklace_54",
		"inv_misc_neck_generic_1",
		"INV_Jewelry_FrostwolfTrinket_01",
		"INV_Jewelry_FrostwolfTrinket_02",
		"INV_Jewelry_FrostwolfTrinket_03",
		"INV_Jewelry_FrostwolfTrinket_04",
		"INV_Jewelry_FrostwolfTrinket_05",
		"INV_Jewelry_Necklace_12",
		"INV_Jewelry_Necklace_13",
		"INV_Jewelry_Necklace_14",
		"INV_Jewelry_Necklace_15",
		"INV_JEWELRY_NECKLACE_15", -- [413]
		"INV_Jewelry_Necklace_16",
		"INV_Jewelry_Necklace_17",
		"INV_Jewelry_Necklace_18",
		"INV_Jewelry_Necklace_19",
		"INV_Jewelry_Necklace_20",
		"INV_Jewelry_Necklace_21",
		"INV_Jewelry_Necklace_22",
		"INV_Jewelry_Necklace_23",
		"INV_Jewelry_Necklace_24",
		"INV_Jewelry_Necklace_25",
		"INV_Jewelry_Necklace_26",
		"INV_Jewelry_Necklace_27",
		"INV_Jewelry_Necklace_27Naxxramas",
		"INV_Jewelry_Necklace_28",
		"INV_Jewelry_Necklace_28Naxxramas",
		"INV_Jewelry_Necklace_29",
		"INV_Jewelry_Necklace_29Naxxramas",
		"INV_Jewelry_Necklace_30",
		"INV_Jewelry_Necklace_30Naxxramas",
		"INV_Jewelry_Necklace_31",
		"INV_Jewelry_Necklace_32",
		"INV_Jewelry_Necklace_33",
		"INV_Jewelry_Necklace_34",
		"INV_Jewelry_Necklace_35",
		"INV_Jewelry_Necklace_36",
		"INV_Jewelry_Necklace_37",
		"INV_Jewelry_Necklace_38",
		"INV_Jewelry_Necklace_39",
		"INV_Jewelry_Necklace_40",
		"INV_Jewelry_Necklace_41",
		"INV_Jewelry_Necklace_42",
		"INV_Jewelry_Necklace_43",
		"INV_Jewelry_Necklace_44",
		"INV_Jewelry_Necklace_45",
		"INV_Jewelry_Necklace_46",
		"INV_Jewelry_Necklace_47",
		"INV_Jewelry_Necklace_48", -- [414]
		"INV_Jewelry_Necklace_49", -- [415]
		"INV_Jewelry_Necklace_50", -- [416]
		"INV_Jewelry_Necklace_52", -- [417]
		"INV_Jewelry_Necklace_53", -- [418]
		"INV_Jewelry_Necklace_AhnQiraj_01",
		"INV_Jewelry_Necklace_AhnQiraj_02",
		"INV_Jewelry_Necklace_AhnQiraj_03",
		"INV_Jewelry_Necklace_AhnQiraj_04",
		"INV_Jewelry_Ring_34",
		"INV_Jewelry_Ring_35",
		"INV_Jewelry_Ring_36",
		"INV_Jewelry_Ring_37",
		"INV_Jewelry_Ring_38",
		"INV_Jewelry_Ring_39",
		"INV_Jewelry_Ring_40",
		"INV_Jewelry_Ring_41",
		"INV_Jewelry_Ring_42",
		"INV_Jewelry_Ring_43",
		"INV_Jewelry_Ring_44",
		"INV_Jewelry_Ring_45",
		"INV_Jewelry_Ring_46",
		"INV_Jewelry_Ring_47",
		"INV_Jewelry_Ring_48Naxxramas",
		"INV_Jewelry_Ring_49Naxxramas",
		"INV_Jewelry_Ring_50Naxxramas",
		"INV_Jewelry_Ring_51Naxxramas",
		"INV_Jewelry_Ring_52Naxxramas",
		"INV_Jewelry_Ring_53Naxxramas",
		"INV_Jewelry_Ring_54",
		"INV_Jewelry_Ring_55",
		"INV_Jewelry_Ring_56",
		"INV_Jewelry_Ring_57",
		"INV_Jewelry_Ring_58",
		"INV_Jewelry_Ring_59",
		"INV_Jewelry_Ring_60",
		"INV_Jewelry_Ring_61",
		"INV_Jewelry_Ring_62",
		"INV_Jewelry_Ring_63",
		"INV_Jewelry_Ring_64",
		"INV_Jewelry_Ring_65",
		"INV_Jewelry_Ring_66",
		"INV_Jewelry_Ring_67",
		"INV_Jewelry_Ring_68",
		"INV_Jewelry_Ring_69",
		"INV_Jewelry_Ring_70",
		"INV_Jewelry_Ring_71",
		"INV_Jewelry_Ring_72",
		"INV_JEWELRY_RING_73",
		"INV_JEWELRY_RING_74",
		"INV_JEWELRY_RING_75",
		"INV_JEWELRY_RING_76",
		"INV_JEWELRY_RING_77",
		"INV_JEWELRY_RING_78",
		"INV_JEWELRY_RING_79",
		"INV_JEWELRY_RING_80",
		"INV_Jewelry_Ring_81", -- [419]
		"INV_Jewelry_Ring_82", -- [420]
		"INV_Jewelry_Ring_83", -- [421]
		"INV_Jewelry_Ring_84", -- [422]
		"INV_Jewelry_Ring_85", -- [423]
		"INV_Jewelry_Ring_86", -- [424]
		"INV_Jewelry_Ring_87",
		"INV_Jewelry_Ring_AhnQiraj_01",
		"INV_Jewelry_Ring_AhnQiraj_02",
		"INV_Jewelry_Ring_AhnQiraj_03",
		"INV_Jewelry_Ring_AhnQiraj_04",
		"INV_Jewelry_Ring_AhnQiraj_05",
		"INV_Jewelry_Ring_AhnQiraj_06",
		"INV_Jewelry_StormPikeTrinket_01",
		"INV_Jewelry_StormPikeTrinket_02",
		"INV_Jewelry_StormPikeTrinket_03",
		"INV_Jewelry_StormPikeTrinket_04",
		"INV_Jewelry_StormPikeTrinket_05",
		"INV_Jewelry_Talisman_15",
		"INV_Jewelry_Talisman_16",
		"INV_Jewelry_Talisman_17",
		"INV_Jewelry_Talisman_18",
		"INV_Jewelry_TrinketPVP_01",
		"INV_Jewelry_TrinketPVP_02",
		"INV_Jewelry_Trinket_01", -- [425]
		"INV_Jewelry_Trinket_02", -- [426]
		"INV_Jewelry_Trinket_03", -- [427]
		"INV_Jewelry_Trinket_04", -- [428]
		"INV_Jewelry_Trinket_05", -- [429]
		"INV_Jewelry_Trinket_06", -- [430]
		"INV_Misc_AhnQirajTrinket_01",
		"INV_Misc_AhnQirajTrinket_02",
		"INV_Misc_AhnQirajTrinket_03",
		"INV_Misc_AhnQirajTrinket_04",
		"INV_Misc_AhnQirajTrinket_05",
		"INV_Misc_AhnQirajTrinket_06",
		"INV_Misc_FrostEmblem_01", -- [477]
		"INV_Misc_Idol_01",
		"INV_Misc_Idol_02",
		"INV_Misc_Idol_03",
		"INV_Misc_Idol_04",
		"INV_Misc_Idol_05",
		"Inv_misc_necklace_firelands_1",
		"INV_Misc_StoneTablet_01",
		"INV_Misc_StoneTablet_02",
		"INV_Misc_StoneTablet_03",
		"INV_Misc_StoneTablet_04",
		"INV_Misc_StoneTablet_05",
		"INV_Misc_StoneTablet_06",
		"INV_Misc_StoneTablet_07",
		"INV_Misc_StoneTablet_08",
		"INV_Misc_StoneTablet_09",
		"INV_Misc_StoneTablet_10",
		"INV_Misc_StoneTablet_11",
		"INV_Misc_Token_ArgentDawn",
		"INV_Misc_Token_ArgentDawn2",
		"INV_Misc_Token_ArgentDawn3",
		"INV_Misc_Token_HonorHold",
		"INV_Misc_Token_ScarletCrusade",
		"INV_Misc_Token_Thrallmar",
		"INV_Qiraj_RingCeremonial",
		"INV_Qiraj_RingMagisterial",
		"INV_Trinket_HonorHold",
		"INV_Trinket_Naxxramas01",
		"INV_Trinket_Naxxramas02",
		"INV_Trinket_Naxxramas03",
		"INV_Trinket_Naxxramas04",
		"INV_Trinket_Naxxramas05",
		"INV_Trinket_Naxxramas06",
		"INV_Trinket_Thrallmar",
		"Item_IcecrownnecklaceA", -- [980]
		"Item_icecrownnecklaceB", -- [981]
		"Item_IcecrownnecklaceC", -- [982]
		"Item_icecrownnecklaceD", -- [983]
		"Item_icecrownringa", -- [984]
		"Item_icecrownringB", -- [985]
		"Item_icecrownringD", -- [987]
		"INV_Jewelry_Ring_100",
		"INV_Jewelry_Ring_101",
		"INV_Jewelry_Ring_102",
		"INV_Jewelry_Ring_103",
		"INV_Jewelry_Ring_104",
		"INV_Jewelry_Ring_105",
		"INV_Jewelry_Ring_106",
		"INV_Jewelry_Ring_107",
		"INV_Jewelry_Ring_88",
		"INV_Jewelry_Ring_89",
		"INV_Jewelry_Ring_90",
		"INV_Jewelry_Ring_91",
		"INV_Jewelry_Ring_92",
		"INV_Jewelry_Ring_93",
		"INV_Jewelry_Ring_94",
		"INV_Jewelry_Ring_95",
		"INV_Jewelry_Ring_96",
		"INV_Jewelry_Ring_97",
		"INV_Jewelry_Ring_98",
		"INV_Jewelry_Ring_99",
		"INV_Jewelry_Ring_FirelandsRaid_01A",
		"INV_Jewelry_Ring_FirelandsRaid_01B",
		"INV_Jewelry_Ring_FirelandsRaid_01C",
		"INV_Jewelry_Ring_FirelandsRaid_02A",
		"INV_Jewelry_Ring_FirelandsRaid_02B",
		"INV_Jewelry_Ring_FirelandsRaid_02C",
		"INV_Jewelry_Ring_FirelandsRaid_03A",
		"INV_Jewelry_Ring_FirelandsRaid_03B",
		"INV_Jewelry_Ring_FirelandsRaid_03C",
		"inv_misc_bonenecklace",
		"inv_misc_diamondring1",
		"inv_misc_diamondring2",
		"inv_misc_diamondring3",
		"inv_misc_emeraldstonering",
		"inv_misc_forestnecklace",
		"inv_misc_kingsring1",
		"inv_misc_kingsring2",
		"inv_misc_moodring1",
		"inv_misc_moodring2",
		"Inv_misc_necklace13",
		"Inv_misc_necklace14",
		"Inv_misc_necklace15",
		"Inv_misc_necklace_firelands_2",
		"inv_misc_pearlring1",
		"inv_misc_pearlring2",
		"inv_misc_ring_generic_1",
		"inv_misc_ring_generic_2",
		"inv_misc_ring_generic_3",
		"inv_misc_ring_generic_4",
		"inv_misc_rubystar",
		"inv_misc_silverjadenecklace",
		"inv_misc_starring1",
		"inv_misc_starring2",
		"inv_misc_starring3",
		"inv_misc_stonenecklace",
		"inv_misc_stonenecklace2",
		"inv_misc_stonering1",
		"inv_misc_stonering2",
		"inv_misc_thornnecklace",
		"inv_misc_tolvyr",
		"inv_misc_tolvyr2",
		"inv_misc_vinering",
		"inv_jewelry_necklace_100", 
		"inv_jewelry_necklace_101", 
		"inv_jewelry_necklace_102", 
		"inv_jewelry_necklace_103", 
		"inv_jewelry_necklace_104", 
		"inv_jewelry_necklace_105", 
		"inv_jewelry_necklace_106", 
		"inv_jewelry_necklace_107", 
		"inv_jewelry_necklace_108", 
		"inv_jewelry_necklace_109", 
		"inv_jewelry_necklace_110", 
		"inv_jewelry_necklace_111", 
		"inv_jewelry_necklace_112", 
		"inv_jewelry_necklace_113", 
		"inv_jewelry_necklace_114", 
		"INV_Jewelry_Necklace_55", 
		"INV_Jewelry_Necklace_56", 
		"INV_Jewelry_Necklace_57", 
		"INV_Jewelry_Necklace_58", 
		"INV_Jewelry_Necklace_59", 
		"INV_Jewelry_Necklace_60", 
		"INV_Jewelry_Necklace_61", 
		"INV_Jewelry_Necklace_62", 
		"INV_Jewelry_Necklace_63", 
		"INV_Jewelry_Necklace_64", 
		"INV_Jewelry_Necklace_65", 
		"INV_Jewelry_Necklace_66", 
		"INV_Jewelry_Necklace_67", 
		"INV_Jewelry_Necklace_68", 
		"INV_Jewelry_Necklace_69", 
		"INV_Jewelry_Necklace_70", 
		"INV_Jewelry_Necklace_71", 
		"INV_Jewelry_Necklace_72", 
		"INV_Jewelry_Necklace_73", 
		"INV_Jewelry_Necklace_74", 
		"INV_Jewelry_Necklace_75", 
		"INV_Jewelry_Necklace_76", 
		"INV_Jewelry_Necklace_77", 
		"INV_Jewelry_Necklace_78", 
		"inv_jewelry_necklace_79", 
		"inv_jewelry_necklace_80", 
		"inv_jewelry_necklace_81", 
		"INV_Jewelry_Necklace_82", 
		"INV_Jewelry_Necklace_83", 
		"INV_Jewelry_Necklace_84", 
		"INV_Jewelry_Necklace_85", 
		"INV_Jewelry_Necklace_86", 
		"INV_Jewelry_Necklace_87", 
		"INV_Jewelry_Necklace_88", 
		"INV_Jewelry_Necklace_89", 
		"INV_Jewelry_Necklace_90", 
		"INV_Jewelry_Necklace_91", 
		"INV_Jewelry_Necklace_92", 
		"INV_Jewelry_Necklace_93", 
		"inv_jewelry_necklace_94", 
		"inv_jewelry_necklace_95", 
		"inv_jewelry_necklace_96", 
		"inv_jewelry_necklace_97", 
		"inv_jewelry_necklace_98", 
		"inv_jewelry_necklace_99", 
		"INV_Jewelry_Ring_108", 
		"INV_Jewelry_Ring_109", 
		"INV_Jewelry_Ring_110", 
		"INV_Jewelry_Ring_111", 
		"INV_Jewelry_Ring_112", 
		"INV_Jewelry_Ring_113", 
		"INV_Jewelry_Ring_114", 
		"INV_Jewelry_Ring_115", 
		"INV_Jewelry_Ring_116", 
		"INV_Jewelry_Ring_117", 
		"INV_Jewelry_Ring_118", 
		"INV_Jewelry_Ring_119", 
		"INV_Jewelry_Ring_120", 
		"INV_Jewelry_Ring_121", 
		"INV_Jewelry_Ring_122", 
		"INV_Jewelry_Ring_123", 
		"INV_Jewelry_Ring_124", 
		"INV_Jewelry_Ring_125", 
		"INV_Jewelry_Ring_126", 
		"INV_Jewelry_Ring_127", 
		"INV_Jewelry_Ring_128", 
		"INV_Jewelry_Ring_129", 
		"INV_Jewelry_Ring_130", 
		"INV_Jewelry_Ring_131", 
		"INV_Jewelry_Ring_132", 
		"INV_Jewelry_Ring_133", 
		"INV_Jewelry_Ring_134", 
		"INV_Jewelry_Ring_135", 
		"INV_Jewelry_Ring_136", 
		"INV_Jewelry_Ring_137", 
		"INV_Jewelry_Ring_138", 
		"INV_Jewelry_Ring_139", 
		"INV_Jewelry_Ring_140", 
		"INV_Jewelry_Ring_141", 
		"INV_Jewelry_Ring_142", 
		"inv_jewelry_ring_143", 
		"inv_jewelry_ring_144", 
		"INV_jewelry_ring_145", 
		"inv_jewelry_ring_146", 
		"INV_Jewelry_ring_147", 
		"INV_jewelry_ring_148", 
		"INV_Jewelry_ring_149", 
		"INV_Jewelry_ring_150", 
		"INV_Jewelry_Ring_151", 
		"INV_Jewelry_Ring_152", 
		"INV_Jewelry_Ring_153", 
		"INV_Jewelry_Ring_154", 
		"INV_Jewelry_Trinket_07", 
		"INV_Jewelry_Trinket_08", 
		"INV_Jewelry_Trinket_09", 
		"INV_Jewelry_Trinket_10", 
		"INV_Jewelry_Trinket_11", 
		"INV_Jewelry_Trinket_12", 
		"INV_Jewelry_Trinket_13", 
		"INV_Jewelry_Trinket_14", 
		"INV_Jewelry_Trinket_15", 
		"INV_Jewelry_Trinket_16", 
		"INV_Jewelry_Trinket_17", 
		"INV_Jewelry_Trinket_18", 
		"INV_Jewelry_Trinket_19", 
		"INV_Jewelry_Trinket_20", 
		"INV_Jewelry_Trinket_21", 
		"INV_Jewelry_Trinket_22", 
		"Inv_Misc_PVP_Neck_A1", 
		"Inv_Misc_PVP_Neck_A2", 
		"Inv_Misc_PVP_Neck_A3", 
		"Inv_Misc_PVP_RingC1", 
		"Inv_Misc_PVP_RingC2", 
		"Inv_Misc_PVP_RingC3", 
		"Inv_Misc_PVP_Trinket",
		"INV_Misc_TrinketPanda_01", 
		"INV_Misc_TrinketPanda_02", 
		"INV_Misc_Trinketpanda_03", 
		"INV_Misc_Trinketpanda_04", 
		"INV_Misc_Trinketpanda_05", 
		"INV_Misc_Trinketpanda_06", 
		"inv_misc_trinketpanda_07", 
		"inv_misc_trinketpanda_08", 
		"inv_misc_trinketpanda_09", 
		"inv_misc_trinketpanda_10", 
		"inv_misc_trinketpanda_11", 
		"inv_misc_trinketpanda_12", 
		"INV_misc_trinketpanda_13", 
		"Inv_Misc_Trinket_GoldenHarp",  
		"inv_jewelry_necklace_118", 
		"inv_jewelry_necklace_119", 
		"inv_jewelry_necklace_120", 
		"INV_jewelry_necklace_121", 
		"INV_jewelry_necklace_122", 
		"INV_jewelry_necklace_123", 
		"INV_jewelry_necklace_124", 
		"INV_jewelry_necklace_125", 
		"INV_jewelry_necklace_126", 
		"INV_jewelry_necklace_127", 
		"INV_jewelry_necklace_128", 
		"INV_jewelry_necklace_129", 
		"INV_jewelry_necklace_130", 
		"INV_jewelry_necklace_131", 
		"INV_jewelry_necklace_132", 
		"INV_jewelry_necklace_133", 
		"INV_jewelry_necklace_134", 
		"INV_jewelry_necklace_135", 
		"INV_Jewelry_Necklace_136", 
		"INV_Jewelry_Necklace_137", 
		"INV_Jewelry_Necklace_138", 
		"INV_Jewelry_Necklace_139", 
		"INV_Jewelry_Necklace_140", 
		"INV_Jewelry_Necklace_141", 
		"INV_Jewelry_Ring_155", 
		"INV_Jewelry_Ring_156", 
		"INV_Jewelry_Ring_157", 
		"INV_Jewelry_Ring_158", 
		"INV_Jewelry_Ring_159", 
		"INV_Jewelry_Ring_160", 
		"INV_Jewelry_Ring_161", 
		"INV_Jewelry_Ring_162", 
		"INV_Jewelry_Ring_163", 
		"INV_Jewelry_Ring_164", 
		"INV_Jewelry_Ring_165", 
		"INV_Jewelry_Ring_166", 
		"INV_Jewelry_Ring_167", 
		"INV_Jewelry_Ring_168", 
		"INV_Jewelry_Ring_169", 
		"INV_Jewelry_Ring_170", 
		"INV_Jewelry_Ring_171", 
		"INV_Jewelry_Ring_172", 
		"INV_Jewelry_Ring_173", 
		"INV_Jewelry_Ring_174", 
		"INV_Jewelry_Ring_175", 
		"INV_Jewelry_Ring_176", 
		"INV_Jewelry_Ring_177", 
		"INV_Jewelry_Ring_178", 
		"INV_Jewelry_Ring_179", 
		"INV_Jewelry_Ring_180", 
		"INV_Jewelry_Ring_181", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_01", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_02", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_03", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_04", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_05", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_06", 
		"INV_Jewelry_OrgrimmarRaid_Trinket_07", 
		"INV_Jewelry_OrgrimmarRaid_Trinket_08", 
		"INV_Jewelry_OrgrimmarRaid_Trinket_09", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_10", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_11", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_12", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_13", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_14", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_15", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_16", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_17", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_18", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_19", 
		"Inv_Jewelry_OrgrimmarRaid_Trinket_20", 
		"INV_MISC_Necklace_mop1", 
		"INV_MISC_Necklace_mop2", 
		"INV_MISC_Necklace_mop3", 
		"INV_MISC_Necklace_mop4", 
		"INV_MISC_Necklace_mop5", 
		"INV_MISC_Necklace_mop6", 
		"INV_MISC_Necklace_mop7", 
		"INV_MISC_Necklace_mop8", 
		"INV_MISC_Necklace_mop9", 
		"INV_MISC_Ring_2", 
		"INV_MISC_Ring_3", 
		"INV_MISC_Ring_4", 
		"INV_MISC_Ring_mop10", 
		"INV_MISC_Ring_mop11", 
		"INV_MISC_Ring_mop12", 
		"INV_MISC_Ring_mop13", 
		"INV_MISC_Ring_mop14", 
		"INV_MISC_Ring_mop15", 
		"INV_MISC_Ring_mop16", 
		"INV_MISC_Ring_mop17", 
		"INV_Misc_Ring_mop18", 
		"INV_Misc_Ring_mop19", 
		"INV_Misc_Ring_mop20", 
		"INV_MISC_Ring_mop3", 
		"INV_MISC_Ring_mop4", 
		"INV_MISC_Ring_mop5", 
		"INV_MISC_Ring_mop9", 
		"INV_60Crafted_Ring1A", 
 "INV_60Crafted_Ring1B", 
		"INV_60Crafted_Ring1C", 
		"INV_60Crafted_Ring1D", 
		"INV_60Crafted_Ring2A", 
		"INV_60Crafted_Ring2B", 
		"INV_60Crafted_Ring2C", 
		"INV_60Crafted_Ring2D", 
		"INV_60Crafted_Ring3A", 
		"INV_60Crafted_Ring3B", 
		"INV_60Crafted_Ring3C", 
		"INV_60Crafted_Ring3D", 
		"INV_60Crafted_Ring4A", 
		"INV_60Crafted_Ring4B", 
		"INV_60Crafted_Ring4C", 
		"INV_60Crafted_Ring4D", 
		"INV_60Dungeon_Neck1A", 
		"INV_60Dungeon_Neck1B", 
		"INV_60Dungeon_Neck1C", 
		"INV_60Dungeon_Neck1D", 
		"INV_60Dungeon_Neck2A", 
		"INV_60Dungeon_Neck2B", 
		"INV_60Dungeon_Neck2C", 
		"INV_60Dungeon_Neck2D", 
		"INV_60Dungeon_Neck3A", 
		"INV_60Dungeon_Neck3B", 
		"INV_60Dungeon_Neck3C", 
		"INV_60Dungeon_Neck3D", 
		"INV_60Dungeon_Neck4A", 
		"INV_60Dungeon_Neck4B", 
		"INV_60Dungeon_Neck4C", 
		"INV_60Dungeon_Neck4D", 
		"INV_60Dungeon_Ring1A", 
		"INV_60Dungeon_Ring1B", 
		"INV_60Dungeon_Ring1C", 
		"INV_60Dungeon_Ring1D", 
		"INV_60Dungeon_Ring2A", 
		"INV_60Dungeon_Ring2B", 
		"INV_60Dungeon_Ring2C", 
		"INV_60Dungeon_Ring2D", 
		"INV_60Dungeon_Ring3A", 
		"INV_60Dungeon_Ring3B", 
		"INV_60Dungeon_Ring3C", 
		"INV_60Dungeon_Ring3D", 
		"INV_60Dungeon_Ring4A", 
		"INV_60Dungeon_Ring4B", 
		"INV_60Dungeon_Ring4C", 
		"INV_60Dungeon_Ring4D", 
		"INV_60Dungeon_Ring5A", 
		"INV_60Dungeon_Ring5B", 
		"INV_60Dungeon_Ring5C", 
		"INV_60Dungeon_Ring5D", 
		"INV_60Dungeon_Ring6A", 
		"INV_60Dungeon_Ring6B", 
		"INV_60Dungeon_Ring6C", 
		"INV_60Dungeon_Ring6D", 
		"INV_60Dungeon_Ring7A", 
		"INV_60Dungeon_Ring7B", 
		"INV_60Dungeon_Ring7C", 
		"INV_60Dungeon_Ring7D", 
		"INV_60Dungeon_Ring8A", 
		"INV_60Dungeon_Ring8B", 
		"INV_60Dungeon_Ring8C", 
		"INV_60Dungeon_Ring8D", 
		"INV_60PVP_Neck1A", 
		"INV_60PVP_Neck1B", 
		"INV_60PVP_Neck1C", 
		"INV_60PVP_Neck1D", 
		"INV_60PVP_Neck2A", 
		"INV_60PVP_Neck2B", 
		"INV_60PVP_Neck2C", 
		"INV_60PVP_Neck2D", 
		"INV_60PVP_Ring1A", 
		"INV_60PVP_Ring1B", 
		"INV_60PVP_Ring1C", 
		"INV_60PVP_Ring1D", 
		"INV_60PVP_Ring2A", 
		"INV_60PVP_Ring2B", 
		"INV_60PVP_Ring2C", 
		"INV_60PVP_Ring2D", 
		"INV_60PVP_Ring3A", 
		"INV_60PVP_Ring3B", 
		"INV_60PVP_Ring3C", 
		"INV_60PVP_Ring3D", 
		"INV_60PVP_Ring4A", 
		"INV_60PVP_Ring4B", 
		"INV_60PVP_Ring4C", 
		"INV_60PVP_Ring4D", 
		 "INV_6_0Raid_Necklace_1a", 
		"INV_6_0Raid_Necklace_1b", 
		"INV_6_0Raid_Necklace_1c", 
		"INV_6_0Raid_Necklace_1d", 
		"INV_6_0Raid_Necklace_2a", 
		"INV_6_0Raid_Necklace_2b", 
		"INV_6_0Raid_Necklace_2c", 
		"INV_6_0Raid_Necklace_2d", 
		"INV_6_0Raid_Necklace_3a", 
		"INV_6_0Raid_Necklace_3b", 
		"INV_6_0Raid_Necklace_3c", 
		"INV_6_0Raid_Necklace_3d", 
		"INV_6_0Raid_Necklace_4a", 
		"INV_6_0Raid_Necklace_4b", 
		"INV_6_0Raid_Necklace_4c", 
		"INV_6_0Raid_Necklace_4d", 
		"INV_jewelcrafting_necklace1_blue", 
		"INV_jewelcrafting_necklace1_red", 
		"INV_jewelcrafting_necklace1_yellow", 
		"INV_jewelcrafting_necklace2_blue", 
		"INV_jewelcrafting_necklace2_red", 
		"INV_jewelcrafting_necklace2_yellow", 
		"INV_jewelcrafting_necklace3_blue", 
		"INV_jewelcrafting_necklace3_red", 
		"INV_jewelcrafting_necklace3_yellow",
		"Inv_Misc_60Raid_Ring_1a", 
		"Inv_Misc_60Raid_Ring_1b", 
		"Inv_Misc_60Raid_Ring_1c", 
		"Inv_Misc_60Raid_Ring_1d", 
		"Inv_Misc_60Raid_Ring_2a", 
		"Inv_Misc_60Raid_Ring_2b", 
		"Inv_Misc_60Raid_Ring_2c", 
		"Inv_Misc_60Raid_Ring_2d", 
		"Inv_Misc_60Raid_Ring_3a", 
		"Inv_Misc_60Raid_Ring_3b", 
		"Inv_Misc_60Raid_Ring_3c", 
		"Inv_Misc_60Raid_Ring_3d", 
		"INV_MISC_6oRing_BlueLv1", 
		"INV_MISC_6oRing_BlueLv2", 
		"INV_MISC_6oRing_BlueLv3", 
		"INV_MISC_6oRing_BlueLv4", 
		"INV_MISC_6oRing_GreenLv1", 
		"INV_MISC_6oRing_GreenLv2", 
		"INV_MISC_6oRing_GreenLv3", 
		"INV_MISC_6oRing_GreenLv4", 
		"INV_MISC_6oRing_PurpleLv1", 
		"INV_MISC_6oRing_PurpleLv2", 
		"INV_MISC_6oRing_PurpleLv3", 
		"INV_MISC_6oRing_PurpleLv4", 
		"INV_MISC_6oRing_RedLv1", 
		"INV_MISC_6oRing_RedLv2", 
		"INV_MISC_6oRing_RedLv3", 
		"INV_MISC_6oRing_RedLv4", 
		"INV_MISC_6oRing_SilverLv1", 
		"INV_MISC_6oRing_SilverLv2", 
		"INV_MISC_6oRing_SilverLv3", 
		"INV_MISC_6oRing_SilverLv4", 
		"INV_MISC_6oRing_Solium", 
		"INV_MISC_Necklace_6_0_001", 
		"INV_MISC_Necklace_6_0_002", 
		"INV_MISC_Necklace_6_0_003", 
		"INV_MISC_Necklace_6_0_004", 
		"INV_MISC_Necklace_6_0_005", 
		"INV_MISC_Necklace_6_0_006", 
		"INV_MISC_Necklace_6_0_007", 
		"INV_MISC_Necklace_6_0_008", 
		"INV_MISC_Necklace_6_0_009", 
		"INV_MISC_Necklace_6_0_010", 
		"INV_MISC_Necklace_6_0_011", 
		"INV_MISC_Necklace_6_0_012", 
		"INV_MISC_Necklace_6_0_013", 
		"INV_MISC_Necklace_6_0_014", 
		"INV_MISC_Necklace_6_0_015", 
		"INV_MISC_Necklace_6_0_016", 
		"INV_MISC_Necklace_6_0_017", 
		"INV_MISC_Necklace_6_0_018", 
		"INV_MISC_Necklace_6_0_019", 
		"INV_MISC_Necklace_6_0_020", 
		"INV_MISC_Necklace_6_0_021", 
		"INV_MISC_Necklace_6_0_022", 
		"INV_MISC_Necklace_6_0_023", 
		"INV_MISC_Necklace_6_0_024", 
		"INV_MISC_Necklace_6_0_025", 
		"INV_MISC_Necklace_6_0_026", 
		"INV_MISC_Necklace_6_0_027", 
		"INV_MISC_Necklace_6_0_028", 
		"INV_MISC_Necklace_6_0_029", 
		"INV_MISC_Necklace_6_0_030", 
		"INV_MISC_Necklace_6_0_031", 
		"INV_MISC_Necklace_6_0_032", 
		"INV_MISC_Necklace_6_0_033", 
		"INV_MISC_Necklace_6_0_034", 
		"INV_MISC_Necklace_6_0_035", 
		"INV_MISC_Necklace_6_0_036", 
		"INV_MISC_Necklace_6_0_037", 
		"INV_MISC_Necklace_6_0_038", 
		"INV_MISC_Necklace_6_0_039", 
		"INV_MISC_Necklace_6_0_040", 
		"INV_MISC_Necklace_6_0_041", 
		"INV_MISC_Necklace_6_0_042", 
		"INV_MISC_Necklace_6_0_043", 
		"INV_MISC_Necklace_6_0_044", 
		"INV_MISC_Necklace_6_0_045", 	
		"INV_MISC_Ring_6_0_001", 
		"INV_MISC_Ring_6_0_002", 
		"INV_MISC_Ring_6_0_003", 
		"INV_MISC_Ring_6_0_004", 
		"INV_MISC_Ring_6_0_005", 
		"INV_MISC_Ring_6_0_006", 
		"INV_MISC_Ring_6_0_007", 
		"INV_MISC_Ring_6_0_008", 
		"INV_MISC_Ring_6_0_009", 
		"INV_MISC_Ring_6_0_010", 
		"INV_MISC_Ring_6_0_011", 
		"INV_MISC_Ring_6_0_012", 
		"INV_MISC_Ring_6_0_013", 
		"INV_MISC_Ring_6_0_014", 
		"INV_MISC_Ring_6_0_015", 
		"INV_MISC_Ring_6_0_016", 
		"INV_Ringwod_1", 
		"INV_Ringwod_1b", 
		"INV_Ringwod_1c", 
		"INV_Ringwod_1d", 
		"INV_Ringwod_2", 
		"INV_Ringwod_2b", 
		"INV_Ringwod_2c", 
		"INV_Ringwod_2d", 
		"INV_Ringwod_3", 
		"INV_Ringwod_3b", 
		"INV_Ringwod_3c", 
		"INV_Ringwod_3d", 
		"INV_Ringwod_4", 
		"INV_Ringwod_4b", 
		"INV_Ringwod_4c", 
		"INV_Ringwod_4d", 
		"INV_Ringwod_5", 
		"INV_Ringwod_5B", 
		"INV_Ringwod_5C", 
		"INV_Ringwod_5D", 
		"INV_Ringwod_6", 
		"INV_Ringwod_6B", 
		"INV_Ringwod_6C", 
		"INV_Ringwod_6D", 
		"INV_Ringwod_7", 
		"INV_Ringwod_7b", 
		"INV_Ringwod_7c", 
		"INV_Ringwod_7d", 
		"INV_Ringwod_8", 
		"INV_Ringwod_8b", 
		"INV_Ringwod_8c", 
		"INV_Ringwod_8d", 
		"INV_Ringwod_D2_1", 
		"INV_Ringwod_D2_2", 
		"INV_Ringwod_D2_3", 
		"INV_Ringwod_D2_4", 
		"INV_Ringwod_D3_1", 
		"INV_Ringwod_D3_2", 
		"INV_Ringwod_D3_3", 
		"INV_Ringwod_D3_4", 
		"INV_Ringwod_D4_1", 
		"INV_Ringwod_D4_2", 
		"INV_Ringwod_D4_3", 
		"INV_Ringwod_D4_4", 
		"INV_Ringwod_D5_1", 
		"INV_Ringwod_D5_2", 
		"INV_Ringwod_D5_3", 
		"INV_Ringwod_D5_4", 
		"INV_Ringwod_D_1", 
		"INV_Ringwod_D_2", 
		"INV_Ringwod_D_3", 
		"INV_Ringwod_D_4", 		
		}
	GHM_StockIcons["Knife"] = {
		"inv_misc_skinningknife",
		"inv_knife_1h_cataclysm_c_05",
		"inv_knife_1h_cataclysm_c_06",
		"inv_knife_1h_cataclysm_c_01",
		"inv_knife_1h_cataclysm_c_03",
		"inv_knife_1h_cataclysm_c_04",
		"INV_Knife_1h_430Future_C_01",
		"INV_Knife_1h_430OldGod_C_01",
		"INV_Knife_1h_430OldGod_C_02",
		"INV_Knife_1h_DeathwingRaid_D_02",
		"INV_Knife_1H_DeathwingRaid_E_01",
		"INV_Knife_1H_DeathwingRaid_E_02",
		"INV_Knife_1H_DeathwingRaid_E_03",
		"INV_Knife_1h_DeathwingRaidDW_D_01",
		"INV_Knife_1h_PVPCataclysmS3_C_01",
		"INV_Knife_1h_PVPCataclysmS3_C_02",
		 "INV_Knife_1H_Common_B_01Green", 
		"INV_Knife_1H_Mantid_01", 
		"INV_Knife_1H_Mantid_02", 
		"INV_Knife_1H_PandaRaid_D_01", 
		"INV_knife_1h_pandaraid_d_02", 
		"INV_Knife_1H_PandariaQuest_B_01", 
		"INV_Knife_1H_PandariaQuest_B_02", 
		"INV_Knife_1H_PandariaQuest_B_03", 
		"INV_Knife_1H_PandariaTradeskill_C_01", 
		"INV_Knife_1h_PanDung_C_01", 
		"INV_Knife_1h_PanDung_C_02", 
		"INV_Knife_1h_PanDung_C_03", 
		"INV_Knife_1h_PanProg_B_01", 
		"INV_Knife_1h_PanProg_B_02", 
		"INV_Knife_1h_PanStart_A_01", 
		"INV_Knife_1h_PVPPandariaS1_C_01", 
		"INV_Knife_1H_PVPPandariaS1_C_02", 
		"INV_Legendary_Knife", 
		"INV_Knife_1H_GoblinRouge_C_01", 
		"INV_Knife_1H_Jinyu_D_01", 
		"INV_Knife_1H_PVPPandariaS2_C_01", 
		"INV_Knife_1H_PVPPandariaS2_C_02", 
		"INV_Knife_1H_Saurok_01", 
		"INV_Knife_1H_ThunderIsleRaid_D_01", 
		"INV_Knife_1h_ThunderIsleRaid_D_02", 
		"INV_Knife_1h_ThunderIsleRaid_D_03", 
		"INV_Knife_1H_ThunderIsleRaid_D_04", 
		"INV_Knife_1H_UndeadRogue_C_01", 
		"INV_Knife_1h_OrgrimmarRaid_D_01", 
		"INV_Knife_1h_OrgrimmarRaid_D_02", 
		"INV_Knife_1H_OrgrimmarRaid_D_04", 
		"INV_Knife_1H_PVPHorde_A_01", 
		"INV_Knife_1h_PVPPandariaS3_C_02", 
		 "INV_Knife_1H_Draenei_C_01", 
		"INV_Knife_1h_DraenorChallenge_D_01", 
		"INV_Knife_1h_DraenorChallenge_D_02", 
		"INV_Knife_1h_DraenorCrafted_D_01_A_Alliance", 
		"INV_Knife_1h_DraenorCrafted_D_01_A_Horde", 
		"INV_Knife_1h_DraenorCrafted_D_01_B_Alliance", 
		"INV_Knife_1h_DraenorCrafted_D_01_B_Horde", 
		"INV_Knife_1h_DraenorCrafted_D_01_C_Alliance", 
		"INV_Knife_1h_DraenorCrafted_D_01_C_Horde", 
		"INV_Knife_1h_DraenorCrafted_D_02_A_Alliance", 
		"INV_Knife_1h_DraenorCrafted_D_02_A_Horde", 
		"INV_Knife_1h_DraenorCrafted_D_02_B_Alliance", 
		"INV_Knife_1h_DraenorCrafted_D_02_B_Horde", 
		"INV_Knife_1h_DraenorCrafted_D_02_C_Alliance", 
		"INV_Knife_1h_DraenorCrafted_D_02_C_Horde", 
		"INV_Knife_1h_DraenorDungeon_C_01", 
		"INV_Knife_1h_DraenorDungeon_C_02", 
		"INV_Knife_1h_DraenorHonor_C_01", 
		"INV_Knife_1h_DraenorHonor_C_02", 
		"INV_Knife_1h_DraenorQuest95_B_01", 
		"INV_Knife_1h_DraenorQuest95_B_02", 
		"INV_Knife_1h_DraenorQuest_B_01", 
		"INV_Knife_1h_DraenorQuest_B_02", 
		"INV_Knife_1h_DraenorRaid_D_01", 
		"INV_Knife_1h_DraenorRaid_D_02", 
		"INV_Knife_1h_DraenorRaid_D_03", 
		"INV_knife_1h_garrison_a_01", 
		"INV_Knife_1h_PVPDraenorS1_D_01", 
		"INV_Knife_1h_PVPDraenorS1_D_02", 
		"INV_Knife_1h__DraenorGuard_B_02_Alliance", 
		"INV_Knife_1h__DraenorGuard_B_02_Horde", 
	}
	GHM_StockIcons["Mace"] = {
		-- ok
		"INV_Mace_01",
		"INV_Mace_02",
		"INV_Mace_03",
		"INV_Mace_04",
		"INV_Mace_05",
		"INV_Mace_06",
		"INV_Mace_07",
		"INV_Mace_08",
		"INV_Mace_09",
		"INV_Mace_10",
		"INV_Mace_11",
		"INV_Mace_12",
		"INV_Mace_13",
		"INV_Mace_14",
		"INV_Mace_15",
		"INV_Mace_16",
		"INV_Mace22",
		--"INV_Mace23", --Icon Missing.
		"INV_Mace_100", -- [446]
		"INV_Mace_101", -- [447]
		"INV_Mace_102", -- [448]
		"INV_Mace_103", -- [449]
		"INV_Mace_104", -- [450]
		"INV_Mace_105", -- [451]
		"INV_Mace_106", -- [452]
		"INV_Mace_107", -- [453]
		"INV_Mace_110", -- [454]
		"INV_Mace_111", -- [455]
		"INV_Mace_112", -- [456]
		"INV_Mace_113", -- [457]
		"INV_Mace_114", -- [458]
		"INV_Mace_115", -- [459]
		"INV_Mace_116", -- [460]
		"INV_Mace_117", -- [461]
		"INV_Mace_118", -- [462]
		"INV_Mace_119", -- [463]
		"INV_Mace_120", -- [464]
		"inv_mace_127",
		"INV_Mace_17",
		"INV_Mace_18",
		"INV_Mace_19",
		"INV_Mace_1H_Stratholme_D_01",
		"INV_Mace_1H_Stratholme_D_02",
		"INV_Mace_20",
		"INV_Mace_21",
		--"INV_Mace_22", --Icon Missing.
		"INV_Mace_23",
		"INV_Mace_24",
		"INV_Mace_25",
		"INV_Mace_26",
		"INV_Mace_27",
		"INV_Mace_28",
		"INV_Mace_29",
		"INV_Mace_2H_Blacksmithing_01",
		"INV_Mace_2H_Blacksmithing_02",
		"INV_Mace_2H_Blacksmithing_03",
		"INV_Mace_30",
		"INV_Mace_31",
		"INV_Mace_32",
		"INV_Mace_33",
		"INV_Mace_34",
		"INV_Mace_35",
		"INV_Mace_36",
		"INV_Mace_37",
		"INV_Mace_38",
		"INV_Mace_39",
		"INV_Mace_40",
		"INV_Mace_41",
		"INV_Mace_42",
		"INV_MACE_42", -- [434]
		"INV_Mace_43",
		"INV_Mace_44",
		"INV_Mace_45",
		"INV_Mace_46",
		"INV_Mace_47",
		"INV_Mace_48",
		"INV_Mace_49",
		"INV_Mace_50",
		"INV_Mace_51",
		"INV_Mace_52",
		"INV_Mace_53",
		"INV_Mace_54",
		"INV_Mace_55",
		"INV_Mace_56",
		"INV_Mace_57",
		"INV_Mace_58",
		"INV_Mace_59",
		"INV_Mace_60",
		"INV_Mace_61",
		"INV_Mace_62",
		"INV_Mace_63",
		"INV_Mace_64",
		"INV_Mace_65",
		"INV_MACE_66",
		"INV_Mace_67",
		"INV_Mace_68",
		"INV_Mace_69",
		"INV_Mace_70",
		"INV_Mace_71",
		"INV_Mace_72",
		"INV_Mace_73",
		"INV_Mace_74",
		"INV_Mace_75",
		"INV_Mace_76",
		"INV_Mace_77",
		"INV_Mace_78",
		"INV_Mace_79",
		"INV_Mace_80",
		"INV_Mace_81",
		"INV_Mace_82",
		"INV_Mace_83",
		"INV_Mace_84",
		"INV_Mace_85",
		"INV_Mace_86",
		"INV_Mace_87",
		"INV_Mace_88",
		"INV_Mace_89", -- [435]
		"INV_Mace_90", -- [436]
		"INV_Mace_91", -- [437]
		"INV_Mace_92", -- [438]
		"INV_Mace_93", -- [439]
		"INV_Mace_94", -- [440]
		"INV_Mace_95", -- [441]
		"INV_Mace_96", -- [442]
		"INV_Mace_97", -- [443]
		"INV_Mace_98", -- [444]
		"INV_Mace_1h_430Future_C_01",
		"INV_Mace_1h_430Future_C_02",
		"INV_Mace_1h_430NightElf_C_02",
		"inv_mace_1h_cataclysm_c_01",
		"inv_mace_1h_cataclysm_c_02",
		"inv_mace_1h_cataclysm_c_03",
		"inv_mace_1h_cataclysm_c_04",
		"inv_mace_1h_cataclysm_c_05",
		"INV_Mace_1h_DeathwingRaidDW_D_01",
		"INV_Mace_1h_DeathwingRaid_D_01",
		"INV_Mace_1h_DeathwingRaid_D_02",
		"INV_Mace_1H_FirelandsRaid_D_02",
		"INV_Mace_1H_FirelandsRaid_D_03",
		"INV_Mace_1H_FirelandsRaid_D_04",
		"INV_Mace_1H_GrimBatolRaid_D_01",
		"INV_Mace_1H_GrimBatolRaid_D_02",
		"inv_mace_1h_hammeroftwilight_d_01",
		"inv_mace_1h_pvp400_c_01",
		"INV_Mace_1h_PVP410_C_01",
		"INV_Mace_1h_PVPCataclysmS3_C_01",
		"INV_Mace_2h_430NightElf_C_01",
		"INV_Mace_2h_DeathwingRaid_D_01",
		"inv_mace_2h_deathwing_d_01",
		"INV_Mace_2H_FirelandsRaid_D_01",
		"INV_Mace_2H_GrimBatolRaid_D_01",
		"inv_mace_2h_hammeroftwilight_d_01",
		"INV_Mace_2h_PVPCataclysmS3_C_01",
		 "INV_Mace_1H_PandaRaid_D_01", 
		 "INV_Mace_1H_PandariaQuest_B_02", 
		 "INV_Mace_1H_PandariaQuest_B_03", 
		 "INV_Mace_1H_PandariaTradeskill_C_01", 
		 "INV_Mace_1h_PanDung_C_01", 
		 "INV_Mace_1h_PanDung_C_02", 
		 "INV_Mace_1h_PanProg_B_01", 
		 "INV_Mace_1h_PanProg_B_02", 
		 "INV_Mace_1h_PanProg_B_03", 
		 "INV_Mace_1h_PanStart_A_01", 
		 "INV_Mace_1H_PVPPandariaS1_C_02", 
		 "INV_Mace_1h_PVPPandariaS1_D_01", 
		 "INV_Mace_2h_PandariaQuest_B_01", 
		 "INV_Mace_2h_PanDung_C_01", 
		 "INV_Mace_2H_PVPPandariaS1_C_01", 
		 "INV_Legendary_Mace", 
		"INV_Mace_1H_PVPPandariaS2_C_01", 
		"INV_Mace_1h_ThunderIsleRaid_D_01", 
		"INV_Mace_1h_ThunderIsleRaid_D_02", 
		"INV_Mace_1H_ThunderIsleRaid_D_03", 
		"INV_Mace_1H_Zandalari_C_01", 
		"INV_Mace_2h_ThunderIsleRaid_D_01", 
		"INV_Mace_2H_ThunderIsleRaid_D_02", 
		"INV_Mace_1h_OrgrimmarRaid_D_01", 
		"INV_Mace_1H_OrgrimmarRaid_D_02", 
		"INV_Mace_1h_OrgrimmarRaid_D_03", 
		"INV_Mace_1H_OrgrimmarRaid_D_04", 
		"INV_Mace_1H_PVPPandariaS3_C_01", 
		"INV_Mace_1H_PVPPandariaS3_C_02", 
		"INV_Mace_2H_OrgrimmarRaid_D_01", 
		 "INV_mace_1H_arakkoa_C_01", 
		"INV_Mace_1H_Doomhammer", 
		"INV_Mace_1H_Draenei_B_01", 
		"INV_Mace_1H_Draenei_C_01", 
		"INV_Mace_1h_DraenorChallenge_D_01", 
		"INV_Mace_1h_DraenorChallenge_D_02", 
		"INV_Mace_1H_DraenorCrafted_D_01_A", 
		"INV_Mace_1H_DraenorCrafted_D_01_B", 
		"INV_Mace_1H_DraenorCrafted_D_01_C", 
		"INV_Mace_1h_DraenorCrafted_D_02_A", 
		"INV_Mace_1h_DraenorCrafted_D_02_B", 
		"INV_Mace_1h_DraenorCrafted_D_02_C", 
		"INV_Mace_1h_DraenorDungeon_C_01", 
		"INV_Mace_1h_DraenorDungeon_C_02", 
		"INV_Mace_1h_DraenorDungeon_C_03", 
		"INV_Mace_1h_DraenorGuard_B_02_A", 
		"INV_Mace_1h_DraenorHonor_C_01", 
		"INV_Mace_1h_DraenorHonor_C_02", 
		"INV_Mace_1H_DraenorOgre_B_01", 
		"INV_Mace_1h_DraenorQuest95_B_01", 
		"INV_Mace_1h_DraenorQuest95_B_02", 
		"INV_Mace_1h_DraenorQuest_B_01", 
		"INV_Mace_1h_DraenorQuest_B_02", 
		"INV_Mace_1h_DraenorRaid_D_01", 
		"INV_Mace_1h_DraenorRaid_D_02", 
		"INV_Mace_1h_DraenorRaid_D_03", 
		"INV_Mace_1h_DraenorRaid_D_04green", 
		"INV_Mace_1h_DraenorRaid_D_04Purple", 
		"INV_Mace_1h_DraenorRaid_D_04red", 
		"INV_Mace_1h_DraenorRaid_D_04yellow", 
		"INV_Mace_1H_DreanorOgre_B_01", 
		"INV_Mace_1h_FrostwolfClan_C_01", 
		"INV_Mace_1h_PVPDraenorS1_D_01", 
		"INV_Mace_1h_PVPDraenorS1_D_02", 
		"INV_Mace_2H_Draenei_B_01", 
		"INV_Mace_2h_DraenorChallenge_D_01", 
		"INV_Mace_2h_DraenorCrafted_D_01_A_Alliance", 
		"INV_Mace_2h_DraenorCrafted_D_01_A_Horde", 
		"INV_Mace_2h_DraenorCrafted_D_01_B_Alliance", 
		"INV_Mace_2h_DraenorCrafted_D_01_B_Horde", 
		"INV_Mace_2h_DraenorCrafted_D_01_C_Alliance", 
		"INV_Mace_2h_DraenorCrafted_D_01_C_Horde", 
		"INV_Mace_2h_DraenorDungeon_C_01", 
		"INV_Mace_2h_DraenorGuard_B_01_Alliance", 
		"INV_Mace_2h_DraenorGuard_B_01_Horde", 
		"INV_Mace_2h_DraenorHonor_C_01", 
		"INV_Mace_2h_DraenorQuest95_B_01", 
		"INV_Mace_2h_DraenorQuest_B_01", 
		"INV_Mace_2h_DraenorRaid_D_01", 
		"INV_Mace_2h_DraenorRaid_D_02_Blackhand", 
		"INV_Mace_2H_DraenorRaid_D_03", 
		"INV_Mace_2H_DreanorOgre_B_01", 
		"INV_Mace_2H_DreanorOgre_B_02", 
		"INV_Mace_2H_DreanorOgre_B_03", 
		"INV_Mace_2h_PVPDraenorS1_D_01", 
	}
	GHM_StockIcons["Trophy"] = {
		-- ok
		"INV_Feather_01",
		"INV_Feather_02",
		"INV_Feather_03",
		"INV_Feather_04",
		"INV_Feather_05",
		"INV_Feather_06",
		"INV_Feather_07",
		"INV_Feather_08",
		"INV_Feather_09",
		"INV_Feather_10",
		"INV_Feather_11",
		"INV_Feather_12",
		"INV_Feather_13",
		"INV_Feather_14",
		"INV_Feather_15",
		"INV_Feather_16",
		"INV_Misc_Birdbeck_01",
		"INV_Misc_Birdbeck_02",
		"INV_Misc_Bone_01",
		"INV_Misc_Bone_02",
		"INV_Misc_Bone_03",
		"INV_Misc_Bone_04",
		"INV_Misc_Bone_05",
		"INV_Misc_Bone_06",
		"INV_Misc_Bone_07",
		"INV_Misc_Bone_08",
		"INV_Misc_Bone_09",
		"INV_Misc_Bone_10",
		"INV_Misc_Bone_DwarfSkull_01",
		"INV_Misc_Bone_ElfSkull_01",
		"INV_Misc_Bone_HumanSkull_01",
		"INV_Misc_Bone_OrcSkull_01",
		"INV_Misc_Bone_TaurenSkull_01",
		"INV_Misc_Ear_Human_01",
		"INV_Misc_Ear_Human_02",
		"INV_Misc_Ear_NightElf_01",
		"INV_Misc_Ear_NightElf_02",
		"INV_Misc_Eye_01",
		"INV_Misc_Foot_Centaur",
		"INV_Misc_Foot_Kodo",
		"INV_Misc_Head_02",
		"INV_Misc_Head_Dragon_01",
		"INV_Misc_Head_Dwarf_01",
		"INV_Misc_Head_Dwarf_02",
		"INV_Misc_Head_Elf_01",
		"INV_Misc_Head_Elf_02",
		"INV_Misc_Head_Gnoll_01",
		"INV_Misc_Head_Gnome_01",
		"INV_Misc_Head_Gnome_02",
		"INV_Misc_Head_Human_01",
		"INV_Misc_Head_Human_02",
		"INV_Misc_Head_Kobold_01",
		"INV_Misc_Head_Murloc_01",
		"INV_Misc_Head_Orc_01",
		"INV_Misc_Head_Orc_02",
		"INV_Misc_Head_Quillboar_01",
		"INV_Misc_Head_Scourge_01",
		"INV_Misc_Head_Tauren_01",
		"INV_Misc_Head_Tauren_02",
		"INV_Misc_Head_Tiger_01",
		"INV_Misc_Head_Troll_01",
		"INV_Misc_Head_Troll_02",
		"INV_Misc_Head_Undead_01",
		"INV_Misc_Head_Undead_02",
		"INV_Misc_Horn_01",
		"INV_Misc_Horn_02",
		"INV_Misc_Horn_03",
		"INV_Misc_MonsterClaw_01",
		"INV_Misc_MonsterClaw_02",
		"INV_Misc_MonsterClaw_03",
		"INV_Misc_MonsterClaw_04",
		"INV_Misc_MonsterFang_01",
		"INV_Misc_MonsterHead_01",
		"INV_Misc_MonsterHead_02",
		"INV_Misc_MonsterHead_03",
		"INV_Misc_MonsterHead_04",
		"INV_Misc_MonsterScales_01",
		"INV_Misc_MonsterScales_02",
		"INV_Misc_MonsterScales_03",
		"INV_Misc_MonsterScales_04",
		"INV_Misc_MonsterScales_05",
		"INV_Misc_MonsterScales_06",
		"INV_Misc_MonsterScales_07",
		"INV_Misc_MonsterScales_08",
		"INV_Misc_MonsterScales_09",
		"INV_Misc_MonsterScales_10",
		"INV_Misc_MonsterScales_11",
		"INV_Misc_MonsterScales_12",
		"INV_Misc_MonsterScales_13",
		"INV_Misc_MonsterScales_14",
		"INV_Misc_MonsterScales_15",
		"INV_Misc_MonsterScales_16",
		"INV_Misc_MonsterScales_17",
		"INV_Misc_MonsterScales_18",
		"INV_Misc_MonsterSpiderCarapace_01",
		"INV_Misc_MonsterTail_01",
		"INV_Misc_MonsterTail_02",
		"INV_Misc_MonsterTail_03",
		"INV_Misc_Organ_01",
		"INV_Misc_Organ_02",
		"INV_Misc_Organ_03",
		"INV_Misc_Organ_04",
		"INV_Misc_Organ_05",
		"INV_Misc_Organ_06",
		"INV_Bone_Skull_04",
		"inv_misc_boarshead",
		"INV_Misc_Bone_HumanSkull_02",
		"INV_Misc_Bone_Skull_01",
		"INV_Misc_Bone_Skull_02",
		"INV_Misc_Bone_Skull_03",
		"inv_misc_cat_trinket11",
		"INV_Misc_DragonKite_01",
		"INV_Misc_DragonKite_02",
		"INV_Misc_DragonKite_03",
		"INV_Misc_DragonKite_04",
		"INV_Misc_Eye_02",
		"INV_Misc_Eye_03",
		"INV_Misc_Eye_04",
		"INV_Misc_Head_ClockworkGnome_01",
		"INV_Misc_Head_Dragon_Black",
		"INV_Misc_Head_Dragon_Blue",
		"INV_Misc_Head_Dragon_Bronze",
		"INV_Misc_Head_Dragon_Green",
		"INV_Misc_Head_Dragon_Red",
		"INV_Misc_Head_Nerubian_01",
		"INV_Misc_Head_Tuskarr",
		"INV_Misc_Head_Vrykul",
		"INV_Misc_Horn_04",
		"INV_Misc_Horn_05",
		"INV_Misc_MonsterClaw_05",
		"INV_Misc_MonsterClaw_06",
		"INV_Misc_MonsterClaw_07",
		"INV_Misc_MonsterClaw_08",
		"INV_Misc_MonsterClaw_09",
		"INV_Misc_MonsterClaw_10",
		"INV_Misc_MonsterFang_02",
		"INV_Misc_MonsterHorn_01",
		"INV_Misc_MonsterHorn_02",
		"INV_Misc_MonsterHorn_03",
		"INV_Misc_MonsterHorn_04",
		"INV_Misc_MonsterHorn_05",
		"INV_Misc_MonsterHorn_06",
		"INV_Misc_MonsterHorn_07",
		"INV_Misc_MonsterHorn_08",
		"INV_Misc_MonsterScales_19",
		"INV_Misc_MonsterScales_20",
		"INV_Misc_MonsterTail_04",
		"INV_Misc_MonsterTail_05",
		"INV_Misc_MonsterTail_06",
		"INV_Misc_MonsterTail_07",
		"INV_Misc_NerubianChitin_01", -- [483]
		"INV_Misc_Shell_01",
		"INV_Misc_Shell_02",
		"INV_Misc_Shell_03",
		"INV_Misc_Shell_04",
		"INV_Misc_Slime_01",
		"inv_misc_cat_trinket12",
		"inv_misc_magtheridonshead",
		"INV_Offhand_1h_430NightElf_C_01",
		"INV_Offhand_1h_DeathwingRaid_D_01",
		"INV_Offhand_1h_PVPCataclysmS3_C_01",
		"INV_Cloudserpent_Egg_Black", 
		"INV_Cloudserpent_Egg_Blue", 
		"INV_Cloudserpent_Egg_Green", 
		"INV_Cloudserpent_Egg_Red", 
		"INV_Cloudserpent_Egg_Yellow", 
		"Inv_Misc_PhoenixEgg",
		"Inv_Bullroarer", 
		"INV_misc_blacksaberonfang", 
		"INV_misc_ancientarrakoafeather", 
		"INV_Misc_Blingtron",
		"INV_misc_boilingblood",
		"INV_MISC_HEAD_ORC1_BRN", 
		"INV_MISC_HEAD_ORC2_BRN",
		"INV_misc_permafrostshard", 
		"INV_misc_redsaberonfang", 
		"INV_misc_rylakclaw", 
		"Inv_misc_trinket6oIH_clefthoof1", 
		"Inv_misc_trinket6oIH_clefthoof2", 
		"Inv_misc_trinket6oIH_horn1", 
		"Inv_misc_trinket6oIH_horn2", 
		"Inv_misc_trinket6oIH_ironskull1", 
		"Inv_misc_trinket6oIH_ironskull2", 
		"Inv_misc_trinket6oIH_wolf1", 
		"Inv_misc_trinket6oIH_wolf2", 
		"Inv_misc_trinket6oOG_2Heads1", 
		"Inv_misc_trinket6oOG_2Heads2", 
		"Inv_misc_trinket6oOG_2Heads3", 
		"Inv_misc_trinket6oOG_CyclopianPig1", 
		"Inv_misc_trinket6oOG_CyclopianPig2", 
		"Inv_misc_trinket6oOG_CyclopianPig3", 
		"Inv_misc_trinket6oOG_Gronn1", 
		"Inv_misc_trinket6oOG_Gronn2", 
		"Inv_misc_trinket6oOG_Gronn3", 
		"Inv_misc_trinket6oOG_Handeye", 
		"Inv_misc_trinket6oOG_Handeye2", 
		"Inv_misc_trinket6oOG_Handeye3", 
		"Inv_misc_trinket6oOG_Idol1", 
		"Inv_misc_trinket6oOG_Idol2", 
		"Inv_misc_trinket6oOG_Idol3", 
		"Inv_misc_trinket6oOG_Isoceles1", 
		"Inv_misc_trinket6oOG_Isoceles2", 
		"Inv_misc_trinket6oOG_Isoceles3", 
		"Inv_misc_trinket6oOG_Mask1", 
		"Inv_misc_trinket6oOG_Stonefist1", 
		"Inv_misc_trinket6oOG_Stonefist2", 
		"Inv_misc_trinket6oOG_Stonefist3", 
		"Inv_misc_trinket6oOG_Tablet1", 
		"Inv_misc_trinket6oOG_Tablet2", 
		"Inv_misc_trinket6oOG_Tablet3", 
		"Inv_misc_trinket6oOG_Talisman1", 
		"Inv_misc_trinket6oOG_Talisman2", 
		"Inv_misc_trinket6oOG_Talisman3", 
		 "INV_misc_twinyolkedegg", 
		"INV_misc_wailingbone", 
		"INV__wod_Arakoa1", 
		"INV__wod_Arakoa2", 
		"INV__wod_Arakoa3", 
		"INV__wod_Arakoa4", 
		"INV__wod_Arakoa5", 
		"INV__wod_Arakoa6", 
		"Item_Hearthstone_Card", 
		"Oshugun_CrystalFragments", 

	}
	GHM_StockIcons["Pets"] = {
		"INV_pandarenserpentpet",
		"inv_misc_babyarmadillopet",
		"inv_misc_darkphoenixpet_01",
		"INV_Misc_PenguinPet", -- [489]
		"INV_Misc_Pet_01", -- [490]
		"INV_Misc_Pet_02", -- [491]
		"INV_Misc_Pet_03", -- [492]
		"INV_Misc_Pet_04", -- [493]
		"INV_Misc_Pet_05", -- [494]
		"INV_Misc_PheonixPet_01",
		"INV_Misc_Rabbit", -- [496]
		"INV_Misc_Rabbit_2", -- [497]
		"INV_Misc_Rabbit_Ears", -- [498]
		"INV_Misc_Sandbox_SpectralTiger_01", -- [503]
		"INV_Pet_BabyBlizzardBear", -- [571]
		"INV_Pet_BabyShark", -- [572]
		"INV_Pet_BlueMurlocEgg", -- [573]
		"INV_Pet_ChromaticDragon",
		"INV_Pet_Cockroach", -- [574]
		"INV_Pet_Egbert", -- [575]
		"INV_PET_FROSTWYRM", -- [576]
		"INV_Pet_LilSmoky", -- [577]
		"INV_Pet_MagicalCradadBox", -- [578]
		"INV_Pet_NurturedPenguinEgg", -- [579]
		"INV_Pet_PinkMurlocEgg", -- [580]
		"INV_Pet_RatCage", -- [581]
		"INV_Pet_ScorchedStone", -- [582]
		"INV_Pet_SleepyWilly", -- [583]
		"inv_dragonwhelpcataclysm",
		"inv_misc_bearcubbrown",
		"inv_misc_seagullpet_01",
		 "INV_Misc_PetApprenticeSousChef",
		"Ability_Pet_Baneling",
		"INV_Misc_Balloon_01", 
		"INV_Misc_Balloon_02", 
		"INV_Misc_Balloon_03", 
		"INV_Misc_Balloon_04",
		"INV_Pet_BabyCloudSerpent", 
		"INV_Pet_BabyCloudSerpent_Gold", 
		"INV_Pet_BabyCrane", 
		"INV_Pet_BabyCrocodile_Chuck", 
		"INV_Pet_BabyCrocodile_Muchbreath", 
		"INV_Pet_BabyCrocodile_Snarly", 
		"INV_Pet_BabyCrocodile_Toothy", 
		"INV_Pet_BabyHippogryph", 
		"INV_Pet_BabyMurlocs_Blue", 
		"INV_Pet_BabyMurlocs_Pink", 
		"INV_Pet_BabyMurlocs_White", 
		"INV_Pet_BabyPengu", 
		"INV_Pet_Baby_Elekk_Blue", 
		"INV_Pet_Baby_Elekk_Gray", 
		"INV_Pet_Baby_Elekk_Green", 
		"INV_Pet_Baby_Elekk_Red", 
		"INV_Pet_BattlePetTraining", 
		"INV_Pet_Beaver", 
		"INV_Pet_Broom", 
		"INV_Pet_Cats_BlackTabbyCat", 
		"INV_Pet_Cats_BombayCat", 
		"INV_Pet_Cats_CalicoCat", 
		"INV_Pet_Cats_CornishRexCat", 
		"INV_Pet_Cats_OrangeTabbyCat", 
		"INV_Pet_Cats_SiameseCat", 
		"INV_Pet_Cats_SilverTabbyCat", 
		"INV_Pet_Cats_WhiteKitten", 
		"INV_Pet_Cricket", 
		"INV_Pet_Deathy", 
		"INV_Pet_DiseasedSquirrel", 
		"INV_Pet_ExitBattle", 
		"INV_Pet_Fawn", 
		"Inv_Pet_Grunty", 
		"INV_Pet_MechanicalChicken", 
		"INV_Pet_MechanicalSquirrel", 
		"INV_Pet_Mole", 
		"INV_Pet_Mouse", 
		"INV_Pet_Otter", 
		"Inv_pet_PandarenElemental", 
		"INV_Pet_PetTrap", 
		"INV_Pet_PetTrap01", 
		"INV_Pet_PetTrap02", 
		"INV_Pet_Porcupine", 
		"INV_Pet_PrairieDog", 
		"INV_Pet_Raccoon", 
		"INV_Pet_Skunk", 
		"INV_Pet_Snowman", 
		"Inv_Pet_Speedy", 
		"INV_Pet_Sprite_Darter_Hatchling", 
		"INV_Pet_SwapPet", 
		"INV_Pet_TurnipPet", 
		"INV_Pet_Vermin", 
		"INV_Pet_WaterStrider", 
		"INV_Misc_FireKitty", 
		"Inv_Pet_LilSmokey2", 
		"INV_Pet_MechanicalBearCub", 
		"INV_Pet_MechanicalRaptorPet", 
		"INV_Pet_MechanicalTigerCub", 
		"INV_Pet_PandarenElemental_Air", 
		"INV_Pet_PandarenElemental_Earth", 
		"INV_Pet_PandarenElemental_Fire", 
		"Inv_pet_PandarenElementa_earthl", 
		"Inv_pet_PandarenElementa_Fire", 
		"INV_Pet_Peacock_blue", 
		"INV_Pet_Peacock_gold", 
		"INV_Pet_Peacock_green", 
		"INV_Pet_RedPanda", 
		"INV_Misc_foxkit_White", 
		"INV_Misc_Head_Dragon_Nexus", 
		"INV_Misc_Pet_Pandaren_Yeti", 
		"INV_quilinpet", 
		"INV_Pet_ArcaneGolem", 
		"INV_Pet_BabyThunderCrocodile", 
		"inv_pet_cookbot", 
		"INV_Pet_PythonBlack", 
		"INV_Pet_PythonBrown", 
		"INV_Pet_PythonGreen", 
		"INV_Pet_RedPanda_Blue", 
		"INV_Pet_RedPanda_Brown", 
		"INV_Pet_RedPanda_Red", 
		"INV_Pet_RedPanda_White", 
		"INV_Pet_SpectralPorcupineBlue", 
		"INV_Pet_SpectralPorcupineGreen", 
		"INV_Pet_SpectralPorcupineRed", 
		"INV_Pet_ThunderBeaver_blue", 
		"INV_Pet_ThunderIsleBabyBird", 
		"INV_Pet_Toad_Black", 
		"INV_Pet_Toad_Blue", 
		"INV_Pet_Toad_Brown", 
		"INV_Pet_Toad_Green", 	
		"INV_ZandalariBabyRaptorBlack", 
		"INV_ZandalariBabyRaptorBlue", 
		"INV_ZandalariBabyRaptorRed", 
		"INV_ZandalariBabyRaptorWhite",
		"INV_WorseRobot", 		
		"INV_Pet_ Basilisk", 
		"INV_Pet_ Goat", 
		"INV_Pet_ ShaleSpider", 
		"INV_Pet_Crane", 
		"INV_Pet_CraneGod", 
		"INV_Pet_Direhorn", 
		"INV_Pet_JadeSerpentPet", 
		"INV_Pet_Mastiff", 
		"INV_Pet_Monkey", 
		"INV_Pet_TigerGodCub", 
		"INV_Pet_YakGod",
		"INV_BabyHippo01", 
		"INV_BabyHippo01_blue", 
		"INV_BabyHippo01_green", 
		"INV_BabyHippo01_white", 
		"INV_BabySpaceGoat",
		"INV_DragonflyPet_blue", 
		"INV_DragonflyPet_bone", 
		"INV_DragonflyPet_green", 
		"INV_DragonflyPet_red", 
		"INV_DragonflyPet_yellow",  
		"INV_FrostWolfPup", 
		"INV_Grommloc",	
		"INV_Podling_blue", 
		"INV_Podling_green", 
		"INV_Podling_orange", 
		"INV_Podling_purple", 
		"INV_Podling_red", 
		"INV_Podling_yellow", 	
		"INV_Ravager2Pet_black", 
		"INV_Ravager2Pet_blue", 
		"INV_Ravager2Pet_red", 
		"INV_Ravager2Pet_white", 
		"INV_tailoring_Elekkplushie", 
		"INV_Toucan_color1", 
		"INV_Toucan_color2", 
		"INV_Toucan_color3", 
		"INV_Toucan_color4", 
		"INV_Toucan_Engineering",
		"INV_StBernardDogPet",
 "INV_moltenCorgi", 		
		"Icon_PetFamily_Beast", 
		"Icon_PetFamily_Critter", 
		"Icon_PetFamily_Dragon", 
		"Icon_PetFamily_Elemental", 
		"Icon_PetFamily_Flying", 
		"Icon_PetFamily_Humanoid", 
		"Icon_PetFamily_Magical", 
		"Icon_PetFamily_Mechanical", 
		"Icon_PetFamily_Undead", 
		"Icon_PetFamily_Water", 
		"PetBattle_Attack-Down", 
		"PetBattle_Attack", 
		"PetBattle_Health-Down", 
		"PetBattle_Health", 
		"PetBattle_Speed-Down", 
		"PetBattle_Speed", 
		"Pet_Type_Beast", 
		"Pet_Type_Critter", 
		"Pet_Type_Dragon", 
		"Pet_Type_Elemental", 
		"Pet_Type_Flying", 
		"Pet_Type_Humanoid", 
		"Pet_Type_Magical", 
		"Pet_Type_Mechanical", 
		"Pet_Type_Undead", 
		"Pet_Type_Water", 
		"Icon_UpgradeStone_Beast_Epic", 
	    "Icon_UpgradeStone_Beast_Rare", 
	    "Icon_UpgradeStone_Beast_Uncommon",
		"Icon_UpgradeStone_Beast_legendary", 		
	    "Icon_UpgradeStone_Critter_Epic", 
	    "Icon_UpgradeStone_Critter_Rare",
		"Icon_UpgradeStone_Critter_legendary", 
	
	    "Icon_UpgradeStone_Critter_Uncommon", 
	    "Icon_UpgradeStone_Dragon_Epic", 
	    "Icon_UpgradeStone_Dragon_Rare", 
	    "Icon_UpgradeStone_Dragon_Uncommon",
		"Icon_UpgradeStone_Dragon_legendary", 
	    "Icon_UpgradeStone_Epic", 
	    "Icon_UpgradeStone_Fire_Epic", 
	    "Icon_UpgradeStone_Fire_Rare", 
	    "Icon_UpgradeStone_Fire_Uncommon", 
		"Icon_UpgradeStone_Fire_legendary", 
	    "Icon_UpgradeStone_Flying_Epic", 
	    "Icon_UpgradeStone_Flying_Rare", 
	    "Icon_UpgradeStone_Flying_Uncommon", 
		"Icon_UpgradeStone_Flying_legendary", 
	    "Icon_UpgradeStone_Humanoid_Epic", 
	    "Icon_UpgradeStone_Humanoid_Rare", 
	    "Icon_UpgradeStone_Humanoid_Uncommon",
		"Icon_UpgradeStone_Humanoid_legendary", 
		"Icon_UpgradeStone_Water_legendary", 			
	    "Icon_UpgradeStone_Magical_Epic", 
	    "Icon_UpgradeStone_Magical_Rare", 
	    "Icon_UpgradeStone_Magical_Uncommon",
		"Icon_UpgradeStone_legendary", 
		"Icon_UpgradeStone_Magical_legendary", 
	    "Icon_UpgradeStone_Mechanical_Epic", 
	    "Icon_UpgradeStone_Mechanical_Rare", 
	    "Icon_UpgradeStone_Mechanical_Uncommon", 
		"Icon_UpgradeStone_Mechanical_legendary", 
	    "Icon_UpgradeStone_Rare", 
	    "Icon_UpgradeStone_Uncommon", 
	    "Icon_UpgradeStone_Undead_Epic", 
	    "Icon_UpgradeStone_Undead_Rare", 
	    "Icon_UpgradeStone_Undead_Uncommon", 
		"Icon_UpgradeStone_Undead_legendary", 		
	    "Icon_UpgradeStone_Water_Epic", 
	    "Icon_UpgradeStone_Water_Rare", 
	    "Icon_UpgradeStone_Water_Uncommon",
		"Icon_UpgradeStone_Water_legendary", 	
		 "Icon_DragonflyGold", 
		"Icon_DragonflySilver", 
		"Icon_HippoGold", 
		"Icon_HippoSilver", 
		"Icon_PodlingGold", 
		"Icon_PodlingSilver", 
		"Icon_RavagerGold", 
		"Icon_RavagerSilver", 
		"Icon_ToucanGold", 
		"Icon_ToucanSilver", 

 

		
	}
	GHM_StockIcons["Mounts"] = {
		"Ability_Mount_BigBlizzardBear", -- [3]
		"Ability_Mount_BlackBattlestrider", -- [4]
		"Ability_Mount_BlackDireWolf",
		"Ability_Mount_BlackPanther",
		"Ability_Mount_BlueWindRider",
		"Ability_Mount_Charger",
		"Ability_Mount_CockatriceMount",
		"Ability_Mount_CockatriceMountElite",
		"Ability_Mount_CockatriceMountElite_Black",
		"Ability_Mount_CockatriceMountElite_Blue",
		"Ability_Mount_CockatriceMountElite_Green",
		"Ability_Mount_CockatriceMountElite_Purple",
		"Ability_Mount_CockatriceMountElite_White",
		"Ability_Mount_CockatriceMount_Black",
		"Ability_Mount_CockatriceMount_Blue",
		"Ability_Mount_CockatriceMount_Green",
		"Ability_Mount_CockatriceMount_Purple",
		"Ability_Mount_Drake_Albino", -- [6]
		"Ability_Mount_Drake_Azure",
		"Ability_Mount_Drake_Blue",
		"Ability_Mount_Drake_Bronze",
		"Ability_Mount_Drake_Proto",
		"Ability_Mount_Drake_Red",
		"Ability_Mount_Drake_Twilight",
		"Ability_Mount_Dreadsteed",
		"Ability_Mount_EbonBlade", -- [7]
		"Ability_Mount_EbonGryphon", -- [8]
		"Ability_Mount_FlyingCarpet",
		"Ability_Mount_GoldenGryphon", -- [9]
		"Ability_Mount_GreenWindRider", -- [10]
		"Ability_Mount_Gryphon_01",
		"Ability_Mount_Gyrocoptor",
		"Ability_Mount_GyrocoptorElite",
		"Ability_Mount_JungleTiger",
		"Ability_Mount_Kodo_01",
		"Ability_Mount_Kodo_02",
		"Ability_Mount_Kodo_03",
		"Ability_Mount_KotoBrewfest",
		"Ability_Mount_MagnificentFlyingCarpet", -- [11]
		"Ability_Mount_Mammoth_Black",
		"Ability_Mount_Mammoth_Black_3seater",
		"Ability_Mount_Mammoth_Brown",
		"Ability_Mount_Mammoth_Brown_3seater",
		"Ability_Mount_Mammoth_White",
		"Ability_Mount_Mammoth_White_3seater",
		"Ability_Mount_MechaStrider",
		"Ability_Mount_MountainRam",
		"Ability_Mount_NetherDrakeElite",
		"Ability_Mount_NetherdrakePurple",
		"Ability_Mount_NightmareHorse",
		"Ability_Mount_Pegasus", -- [12]
		"Ability_Mount_PinkTiger",
		"Ability_Mount_PolarBear_Black",
		"Ability_Mount_PolarBear_Brown",
		"Ability_Mount_PolarBear_White",
		"Ability_Mount_Raptor",
		"Ability_Mount_Razorscale", -- [13]
		"Ability_Mount_RedFrostwyrm_01", -- [14]
		"Ability_Mount_RidingElekk",
		"Ability_Mount_RidingElekkElite",
		"Ability_Mount_RidingElekkElite_Blue",
		"Ability_Mount_RidingElekkElite_Green",
		"Ability_Mount_RidingElekkElite_Purple",
		"Ability_Mount_RidingElekk_Grey",
		"Ability_Mount_RidingElekk_Purple",
		"Ability_Mount_RidingHorse",
		"Ability_Mount_RocketMount",
		"Ability_Mount_RocketMountBlue",
		"Ability_Mount_Seahorse",
		"Ability_Mount_SnowyGryphon", -- [15]
		"Ability_Mount_SpectralGryphon",
		"Ability_Mount_SpectralTiger", -- [16]
		"Ability_Mount_SpectralWyvern",
		"Ability_Mount_SwiftGreenWindRider", -- [17]
		"Ability_Mount_SwiftPurpleWindRider", -- [18]
		"Ability_Mount_SwiftRedWindRider", -- [19]
		"Ability_Mount_SwiftYellowWindRider", -- [20]
		"Ability_Mount_TawnyWindRider", -- [21]
		"Ability_Mount_Undeadhorse",
		"Ability_Mount_WarHippogryph",
		"Ability_Mount_WhiteDireWolf",
		"Ability_Mount_WhiteTiger",
		"Ability_Mount_Wyvern_01",
		"ability_mount_camel_brown",
		"ability_mount_camel_tan",
		"ability_mount_fossilizedraptor",
		"Ability_Mount_AlliancePVPMount",
		"INV_AlliancePVPMount",
		"Ability_Mount_CraneMount", 
		"INV_PandarenSerpentGodMount_Black", 
		"INV_PandarenSerpentGodMount_Red", 
		"INV_PandarenSerpentMount", 
		"INV_PandarenSerpentMount_Blue", 
		"INV_PandarenSerpentMount_Green", 
		"INV_PandarenSerpentMount_Lightning", 
		"INV_PandarenSerpentMount_Lightning_Green", 
		"INV_PandarenSerpentMount_Lightning_Yellow", 
		"INV_PandarenSerpentMount_Yellow", 
		"Ability_Mount_OnyxPanther_Green", 
		"Ability_Mount_SwiftWindsteed", 		
		"INV_Misc_EliteGryphon", 
		"INV_Misc_EliteGryphonArmored", 
		"INV_Misc_EliteWyvern", 
		"INV_Misc_EliteWyvernArmored", 
		"Ability_Mount_EpicBatMount", 
		"Ability_Mount_PandarenKiteMount_Green", 
		"Ability_Mount_PandarenKiteMount_Yellow", 
		"Ability_Mount_PterodactylMount", 
		"Ability_Mount_Raptor_Black", 
		"Ability_Mount_Raptor_white", 
		"ABILITY_MOUNT_skyclaw_blue", 
		"ABILITY_MOUNT_skyclaw_green", 
		"ABILITY_MOUNT_skyclaw_red", 
		"Ability_Mount_TriceratopsMount", 
		"Ability_Mount_TriceratopsMount_Blue", 
		"Ability_Mount_TriceratopsMount_Green", 
		"Ability_Mount_TriceratopsMount_Grey", 
		"Ability_Mount_TriceratopsMount_Yellow", 
		"INV_GhostlyCharger", 
		"INV_PandarenSerpentMount_Lightning_Blue", 
		"INV_PandarenSerpentMount_White", 
		"Ability_Mount_CelestialHorse",
		"Ability_Mount_DragonHawkArmorAllliance",
		"Ability_Mount_DragonHawkArmorHorde",
		"Ability_Mount_EpicBatMount",
		"Ability_Mount_SwiftWindsteed",
		"Ability_Mount_AlliancePVPMount",
		"Ability_Mount_ArmoredBlueWindRider",
		"Ability_Mount_BigBlizzardBear", -- [3]
		"Ability_Mount_BlackBattlestrider", -- [4]
		"Ability_Mount_BlackDireWolf",
		"Ability_Mount_BlackPanther",
		"Ability_Mount_BlueWindRider",
		"Ability_Mount_BlueWindRider", -- [5]
		"ability_mount_camel_brown",
		"ability_mount_camel_tan",
		"Ability_Mount_Charger",
		"Ability_Mount_CockatriceMount",
		"Ability_Mount_CockatriceMountElite",
		"Ability_Mount_CockatriceMountElite_Black",
		"Ability_Mount_CockatriceMountElite_Blue",
		"Ability_Mount_CockatriceMountElite_Green",
		"Ability_Mount_CockatriceMountElite_Purple",
		"Ability_Mount_CockatriceMountElite_White",
		"Ability_Mount_CockatriceMount_Black",
		"Ability_Mount_CockatriceMount_Blue",
		"Ability_Mount_CockatriceMount_Green",
		"Ability_Mount_CockatriceMount_Purple",
		"Ability_Mount_Drake_Albino", -- [6]
		"Ability_Mount_Drake_Azure",
		"Ability_Mount_Drake_Blue",
		"Ability_Mount_Drake_Bronze",
		"Ability_Mount_Drake_Proto",
		"Ability_Mount_Drake_Red",
		"Ability_Mount_Drake_Twilight",
		"Ability_Mount_Dreadsteed",
		"Ability_Mount_EbonBlade", -- [7]
		"Ability_Mount_EbonGryphon", -- [8]
		"Ability_Mount_FlyingCarpet",
		"ability_mount_fossilizedraptor",
		"Ability_Mount_GoldenGryphon", -- [9]
		"Ability_Mount_GreenWindRider", -- [10]
		"Ability_Mount_Gryphon_01",
		"Ability_Mount_Gyrocoptor",
		"Ability_Mount_GyrocoptorElite",
		"Ability_Mount_JungleTiger",
		"Ability_Mount_Kodo_01",
		"Ability_Mount_Kodo_02",
		"Ability_Mount_Kodo_03",
		"Ability_Mount_KotoBrewfest",
		"Ability_Mount_MagnificentFlyingCarpet", -- [11]
		"Ability_Mount_Mammoth_Black",
		"Ability_Mount_Mammoth_Black_3seater",
		"Ability_Mount_Mammoth_Brown",
		"Ability_Mount_Mammoth_Brown_3seater",
		"Ability_Mount_Mammoth_White",
		"Ability_Mount_Mammoth_White_3seater",
		"Ability_Mount_MechaStrider",
		"Ability_Mount_MountainRam",
		"Ability_Mount_NetherDrakeElite",
		"Ability_Mount_NetherdrakePurple",
		"Ability_Mount_NightmareHorse",
		"Ability_Mount_Pegasus", -- [12]
		"Ability_Mount_PinkTiger",
		"Ability_Mount_PolarBear_Black",
		"Ability_Mount_PolarBear_Brown",
		"Ability_Mount_PolarBear_White",
		"Ability_Mount_Raptor",
		"Ability_Mount_Razorscale", -- [13]
		"Ability_Mount_RedFrostwyrm_01", -- [14]
		"Ability_Mount_RidingElekk",
		"Ability_Mount_RidingElekkElite",
		"Ability_Mount_RidingElekkElite_Blue",
		"Ability_Mount_RidingElekkElite_Green",
		"Ability_Mount_RidingElekkElite_Purple",
		"Ability_Mount_RidingElekk_Grey",
		"Ability_Mount_RidingElekk_Purple",
		"Ability_Mount_RidingHorse",
		"Ability_Mount_RocketMount",
		"Ability_Mount_RocketMountBlue",
		"Ability_Mount_Seahorse",
		"Ability_Mount_SnowyGryphon", -- [15]
		"Ability_Mount_SpectralGryphon",
		"Ability_Mount_SpectralTiger", -- [16]
		"Ability_Mount_SpectralWyvern",
		"Ability_Mount_SwiftGreenWindRider", -- [17]
		"Ability_Mount_SwiftPurpleWindRider", -- [18]
		"Ability_Mount_SwiftRedWindRider", -- [19]
		"Ability_Mount_SwiftYellowWindRider", -- [20]
		"Ability_Mount_TawnyWindRider", -- [21]
		"Ability_Mount_Undeadhorse",
		"Ability_Mount_WarHippogryph",
		"Ability_Mount_WhiteDireWolf",
		"Ability_Mount_WhiteTiger",
		"Ability_Mount_Wyvern_01",
		"Ability_Mount_CloudMount", 
		"Ability_Mount_CraneMount", 
		"Ability_Mount_CraneMountBlue", 
		"Ability_Mount_CraneMountPurple", 
		"Ability_Mount_GoatMount", 
		"Ability_Mount_GoatMountBlack", 
		"Ability_Mount_GoatMountBrown", 
		"Ability_Mount_GoatMountWhite", 
		"Ability_Mount_HordeScorpionAmber", 
		"Ability_Mount_OnyxPanther", 
		"Ability_Mount_OnyxPanther_Black", 
		"Ability_Mount_OnyxPanther_Blue", 
		"Ability_Mount_OnyxPanther_Red", 
		"Ability_Mount_OnyxPanther_Yellow", 
		"Ability_Mount_PandaranMount", 
		"Ability_Mount_PandaranMountBlack", 
		"Ability_Mount_PandaranMountBlue", 
		"Ability_Mount_PandaranMountBrown", 
		"Ability_Mount_PandaranMountEpic", 
		"Ability_Mount_PandaranMountEpicBlack", 
		"Ability_Mount_PandaranMountEpicBlue", 
		"Ability_Mount_PandaranMountEpicBrown", 
		"Ability_Mount_PandaranMountEpicPurple", 
		"Ability_Mount_PandaranMountEpicRed", 
		"Ability_Mount_PandaranMountGreen", 
		"Ability_Mount_PandaranMountPurple", 
		"Ability_Mount_PandaranMountRed", 
		"Ability_Mount_PandarenKiteMount", 
		"Ability_Mount_PandarenKiteMount_blue", 
		"Ability_Mount_PandarenPhoenix", 
		"Ability_Mount_PandarenPhoenix_green", 
		"Ability_Mount_PandarenPhoenix_purple", 
		"Ability_Mount_PandarenPhoenix_red", 
		"Ability_Mount_PandarenPhoenix_yellow", 
		"Ability_Mount_QuilenFlyingMount", 
		"Ability_Mount_QuilenMount", 
		"ability_mount_rocketmount3", 
		"ability_mount_rocketmount4", 
		"Ability_Mount_SiberianTigerMount", 
		"Ability_Mount_SiberianTigerMountGreen", 
		"Ability_Mount_SiberianTigerMountRed", 
		"Ability_Mount_TravellersYakMount", 
		"Ability_Mount_YakMount", 
		"Ability_Mount_YakMountBlack", 
		"Ability_Mount_YakMountBrown", 
		"Ability_Mount_YakMountGrey", 
		"Ability_Mount_YakMountWhite",
		"INV_CelestialSerpentMount",
		"INV_MushanBeastMount",
		"Ability_Mount_CraneMountBlue", 
		"Ability_Mount_CraneMountPurple", 
		"Ability_Mount_GoatMount", 
		"Ability_Mount_GoatMountBlack", 
		"Ability_Mount_GoatMountBrown", 
		"Ability_Mount_GoatMountWhite", 
		"Ability_Mount_HordeScorpionAmber", 
		"Ability_Mount_OnyxPanther_Black", 
		"Ability_Mount_OnyxPanther_Blue", 
		"Ability_Mount_OnyxPanther_Red", 
		"Ability_Mount_OnyxPanther_Yellow", 
		"Ability_Mount_OnyxPanther", 
		"Ability_Mount_PandaranMount", 
		"Ability_Mount_PandaranMountBlack", 
		"Ability_Mount_PandaranMountBlue", 
		"Ability_Mount_PandaranMountBrown", 
		"Ability_Mount_PandaranMountEpic", 
		"Ability_Mount_PandaranMountEpicBlack", 
		"Ability_Mount_PandaranMountEpicBlue", 
		"Ability_Mount_PandaranMountEpicBrown", 
		"Ability_Mount_PandaranMountEpicPurple", 
		"Ability_Mount_PandaranMountEpicRed", 
		"Ability_Mount_PandaranMountGreen", 
		"Ability_Mount_PandaranMountPurple", 
		"Ability_Mount_PandaranMountRed", 
		"Ability_Mount_PandarenKiteMount_blue", 
		"Ability_Mount_PandarenKiteMount", 
		"Ability_Mount_PandarenPhoenix_green", 
		"Ability_Mount_PandarenPhoenix_purple", 
		"Ability_Mount_PandarenPhoenix_red", 
		"Ability_Mount_PandarenPhoenix_yellow", 
		"Ability_Mount_PandarenPhoenix", 
		"Ability_Mount_QuilenFlyingMount", 
		"Ability_Mount_QuilenMount", 
		"ability_mount_rocketmount3", 
		"ability_mount_rocketmount4", 
		"Ability_Mount_SiberianTigerMount", 
		"Ability_Mount_SiberianTigerMountGreen", 
		"Ability_Mount_SiberianTigerMountRed", 
		"Ability_Mount_TravellersYakMount", 
		"Ability_Mount_YakMount", 
		"Ability_Mount_YakMountBlack", 
		"Ability_Mount_YakMountBrown", 
		"Ability_Mount_YakMountGrey", 
		"Ability_Mount_YakMountWhite", 
		"Ability_Mount_ArmoredBlueWindRider",
		"Ability_Mount_IronJuggernautMount", 
		"Ability_Mount_KorKronProtodrake", 
		"Ability_Mount_ShredderMount", 
		"Ability_Mount_StormCrowMount", 
		"Ability_Mount_WarNightSaber", 
		"INV_MushanBeastMountBlack", 
		"INV_PandarenSerpentGodMount_Gold", 
		"INV_PandarenSerpentMount_Lightning_Black", 
		"INV_SkeletalWarhorse", 
		"inv_mount_allianceliong",
		"inv_mount_darkphoenixa",
		"inv_mount_darkphoenixb",
		"inv_mount_hordescorpiong",
		"inv_mount_spectralhorse",
		"inv_mount_spectralwolf",
		"Ability_Mount_IronChimera",
		"INV_tailoring_purplecarpet",
		"INV_tailoring_blackcarpet",
		"Ability_Mount_ElekkDraenorMount", 
		"Ability_Mount_TalbukDraenorMount", 
		"Ability_Mount_ViciousWarRaptor", 
		"INV_ClefthoofDraenorMount_Blue", 
		"INV_GiantBoarMount_Brown", 
		"INV_Iron Horde Elekk", 
		"INV_IronHordeClefthoof", 
		"INV_LavaHorse", 
		"INV_LesserGronnMount_Red", 
		"INV_Mount_DarkPhoenixB", 
		"INV_TalbukDraenor_white", 
		"INV_WolfDraenorMountBrown", 
		"INV_WolfDraenorMountFrost", 
		"INV_WolfDraenorMountRed", 
		"INV_WolfDraenorMountShadow", 
		"Item_Summon_Cinderwolf", 

		
	}
	GHM_StockIcons["Cape"] = {
		-- ok
		"INV_Misc_Cape_01",
		"INV_Misc_Cape_02",
		"INV_Misc_Cape_03",
		"INV_Misc_Cape_04",
		"INV_Misc_Cape_05",
		"INV_Misc_Cape_06",
		"INV_Misc_Cape_07",
		"INV_Misc_Cape_08",
		"INV_Misc_Cape_09",
		"INV_Misc_Cape_10",
		"INV_Misc_Cape_11",
		"INV_Misc_Cape_12",
		"INV_Misc_Cape_13",
		"INV_Misc_Cape_14",
		"INV_Misc_Cape_15",
		"INV_Misc_Cape_16",
		"INV_Misc_Cape_17",
		"INV_Misc_Cape_18",
		"INV_Misc_Cape_19",
		"INV_Misc_Cape_20",
		"INV_Misc_Cape_21",
		"INV_Misc_Cape_22",
		"INV_Misc_Cape_Naxxramas_01",
		"INV_Misc_Cape_Naxxramas_02",
		"INV_Misc_Cape_Naxxramas_03",
		"INV_Misc_Cape_23", -- [467]
		"INV_Misc_Cape_25", -- [468]
		"INV_Misc_Cape_26", -- [469]
		"Item_icecrowncape", -- [978]
		"Item_icecrowncloak", -- [979]

		"inv_guild_cloak_alliance_a",
		"inv_guild_cloak_alliance_b",
		"inv_guild_cloak_alliance_c",
		"inv_guild_cloak_horde_a",
		"inv_guild_cloak_horde_b",
		"inv_guild_cloak_horde_c",
		"inv_misc_cape_cataclysm_caster_b_01",
		"inv_misc_cape_cataclysm_caster_c_01",
		"inv_misc_cape_cataclysm_melee_b_01",
		"inv_misc_cape_cataclysm_melee_c_01",
		"inv_misc_cape_cataclysm_melee_d_01",
		"INV_Cape_Firelands_FireSet_D_01",

		"INV_MISC_Cape_DarkmoonFaire_C_01",
		"INV_MISC_Cape_DeathwingRaid_D_01",
		"INV_MISC_Cape_DeathwingRaid_D_02",
		"INV_MISC_Cape_DeathwingRaid_D_03",
		"INV_Cape_430Dungeon_C_04",
		 "INV_Cape_PandariaPVP_D_01", 
		"INV_Cape_PandariaPVP_D_02", 
		"INV_Cape_Pandaria_B_01", 
		"INV_Cape_Pandaria_B_02", 
		"INV_Cape_Pandaria_B_03", 
		"INV_Cape_Pandaria_B_04", 
		"INV_Cape_Pandaria_C_01", 
		"INV_Cape_Pandaria_C_02", 
		"INV_Cape_Pandaria_C_03", 
		"INV_Cape_Pandaria_C_04", 
		"INV_Cape_Pandaria_D_01", 
		"INV_Cape_Pandaria_D_02", 
		"INV_Cape_Pandaria_D_03", 
		"INV_Cape_Pandaria_D_04", 
		"INV_Cape_PanProg_B_01", 
		"INV_Cape_PanProg_B_02",
		"INV_Cape_PVP_S14_D_01", 
		 "INV_Cape_DraenorCraftedCaster_D_01black", 
		"INV_Cape_DraenorCraftedCaster_D_01blue", 
		"INV_Cape_DraenorCraftedCaster_D_01red", 
		"INV_Cape_DraenorCrafted_D_01black", 
		"INV_Cape_DraenorCrafted_D_01blue", 
		"INV_Cape_DraenorCrafted_D_01red", 
		"INV_Cape_DraenorCrafted_D_02blue", 
		"INV_Cape_DraenorCrafted_D_02grey", 
		"INV_Cape_DraenorCrafted_D_02red", 
		"INV_Cape_DraenorCrafted_D_03_PlateAlliance", 
		"INV_Cape_DraenorCrafted_D_03_PlateHorde", 
		"INV_Cape_DraenorCrafted_D_03_PlateRed", 
		"INV_Cape_DraenorCrafted_D_04_LeatherAlliance", 
		"INV_Cape_DraenorCrafted_D_04_LeatherHorde", 
		"INV_Cape_DraenorCrafted_D_04_LeatherRed", 
		"INV_Cape_DraenorDungeon_C_01_blue", 
		"INV_Cape_DraenorDungeon_C_01_green", 
		"INV_Cape_DraenorDungeon_C_01_red", 
		"INV_Cape_DraenorDungeon_C_02_plate", 
		"INV_Cape_DraenorDungeon_C_03_mail", 
		"INV_Cape_DraenorDungeon_C_03_mail_blue", 
		"INV_Cape_DraenorDungeon_C_03_mail_brown", 
		"INV_Cape_DraenorDungeon_C_04Leather_Base", 
		"INV_Cape_DraenorDungeon_C_04Leather_Dark", 
		"INV_Cape_DraenorDungeon_C_04Leather_Light", 
		"INV_Cape_DraenorPVP_D_02caster_blue", 
		"INV_Cape_DraenorPVP_D_02caster_purple", 
		"INV_Cape_DraenorPVP_D_02caster_red", 
		"INV_Cape_DraenorPVP_D_02_Leather_Blue", 
		"INV_Cape_DraenorPVP_D_02_Leather_Purple", 
		"INV_Cape_DraenorPVP_D_02_Leather_Yellow", 
		"INV_Cape_DraenorPVP_D_03_Mail_Orange", 
		"INV_Cape_DraenorPVP_D_03_Mail_Purple", 
		"INV_Cape_DraenorPVP_D_03_Mail_Yellow", 
		"INV_Cape_DraenorQuest90_B_01_cloth", 
		"INV_Cape_DraenorQuest90_B_02_leather", 
		"INV_Cape_DraenorQuest90_B_03_mail", 
		"INV_Cape_DraenorQuest90_B_04_plate", 
		"INV_Cape_DraenorQuest95_B_01_leather", 
		"INV_Cape_DraenorQuest95_B_05_cloth", 
		"INV_Cape_DraenorQuest95_B_06_mail", 
		"INV_Cape_DraenorQuest95_B_07_leather", 
		"INV_Cape_DraenorQuest95_B_08_plate", 
		"INV_Cape_DraenorRaid_C_01_blue", 
		"INV_Cape_DraenorRaid_C_01_green", 
		"INV_Cape_DraenorRaid_C_01_red", 
		"INV_Cape_DraenorRaid_D_01caster_blue", 
		"INV_Cape_DraenorRaid_D_01caster_purple", 
		"INV_Cape_DraenorRaid_D_01caster_red", 
		"INV_Cape_DraenorRaid_D_01Leather_Druid", 
		"INV_Cape_DraenorRaid_D_01Leather_Monk", 
		"INV_Cape_DraenorRaid_D_01Leather_Rogue", 
		"INV_Cape_DraenorRaid_D_01Plate_DK", 
		"INV_Cape_DraenorRaid_D_01Plate_Paladin", 
		"INV_Cape_DraenorRaid_D_01Plate_Warrior", 
		"INV_Cape_DraenorRaid_D_02_mail_blue", 
		"INV_Cape_DraenorRaid_D_02_mail_green", 
		"INV_Cape_DraenorRaid_D_02_mail_red", 
		"INV_Cape_DungeonCrafted_D_02blue", 
		"INV_Cape_DungeonCrafted_D_02grey", 
		"INV_Cape_DungeonCrafted_D_02red", 
		"INV_Cape_PVP_S16_D_01", 
		"INV_Cape_TimeWalker_B_01",
		"INV_DraenorPVP_D_01plate_blue", 
		"INV_DraenorPVP_D_01plate_green", 
		"INV_DraenorPVP_D_01plate_purple", 	
		"INV_Mail_ThunderLordClan_B_01Cape",		
			
	}
	GHM_StockIcons["Valuable"] = {
		-- ok
		"INV_Misc_Coin_01",
		"INV_Misc_Coin_02",
		"INV_Misc_Coin_03",
		"INV_Misc_Coin_04",
		"INV_Misc_Coin_05",
		"INV_Misc_Coin_06",
		"INV_Misc_Coin_07",
		"INV_Misc_Coin_08",
		"INV_Misc_Coin_09",
		"INV_Misc_Coin_10",
		"INV_Misc_Coin_11",
		"INV_Misc_Coin_12",
		"INV_Misc_Coin_13",
		"INV_Misc_Coin_14",
		"INV_Misc_Coin_15",
		"TimelessCoin-Bloody", 
		"TimelessCoin", 
		"INV_Misc_Gem_01",
		"INV_Misc_Gem_02",
		"INV_Misc_Gem_03",
		"INV_Misc_Gem_Amethyst_01",
		"INV_Misc_Gem_Amethyst_02",
		"INV_Misc_Gem_Amethyst_03",
		"INV_Misc_Gem_Bloodstone_01",
		"INV_Misc_Gem_Bloodstone_02",
		"INV_Misc_Gem_Bloodstone_03",
		"INV_Misc_Gem_Crystal_01",
		"INV_Misc_Gem_Crystal_02",
		"INV_Misc_Gem_Crystal_03",
		"INV_Misc_Gem_Diamond_01",
		"INV_Misc_Gem_Diamond_02",
		"INV_Misc_Gem_Diamond_03",
		"INV_Misc_Gem_Emerald_01",
		"INV_Misc_Gem_Emerald_02",
		"INV_Misc_Gem_Emerald_03",
		"INV_Misc_Gem_Opal_01",
		"INV_Misc_Gem_Opal_02",
		"INV_Misc_Gem_Opal_03",
		"INV_Misc_Gem_Pearl_01",
		"INV_Misc_Gem_Pearl_02",
		"INV_Misc_Gem_Pearl_03",
		"INV_Misc_Gem_Pearl_04",
		"INV_Misc_Gem_Pearl_05",
		"INV_Misc_Gem_Pearl_06",
		"INV_Misc_Gem_Ruby_01",
		"INV_Misc_Gem_Ruby_02",
		"INV_Misc_Gem_Ruby_03",
		"INV_Misc_Gem_Sapphire_01",
		"INV_Misc_Gem_Sapphire_02",
		"INV_Misc_Gem_Sapphire_03",
		"INV_Misc_Gem_Stone_01",
		"INV_Misc_Gem_Topaz_01",
		"INV_Misc_Gem_Topaz_02",
		"INV_Misc_Gem_Topaz_03",
		"INV_Misc_Gem_Variety_01",
		"INV_Misc_Gem_Variety_02",
		
		"INV_Misc_Orb_01",
		"INV_Misc_Orb_02",
		"INV_Misc_Orb_03",
		"INV_Misc_Orb_04",
		"INV_Misc_Orb_05",
		"INV_Misc_Platnumdisks",
		"INV_Misc_Rune_01",
		"INV_Misc_Rune_02",
		"INV_Misc_Rune_03",
		"INV_Misc_Rune_04",
		"INV_Misc_Rune_05",
		"INV_Misc_Rune_06",
		"INV_Misc_Rune_07",
		"INV_Misc_Rune_08",
		"INV_Bijou_Blue",
		"INV_Bijou_Bronze",
		"INV_Bijou_Gold",
		"INV_Bijou_Green",
		"INV_Bijou_Orange",
		"INV_Bijou_Purple",
		"INV_Bijou_Red",
		"INV_Bijou_Silver",
		"INV_Bijou_Yellow",
		"INV_Misc_ElvenCoins",
		"INV_MISC_GEM_AMETHYST_03",
		"INV_Misc_Gem_BloodGem_01",
		"INV_Misc_Gem_BloodGem_02",
		"INV_Misc_Gem_BloodGem_03",
		"INV_MISC_GEM_BLOODSTONE_02",
		"INV_Misc_Gem_Pearl_07",
		"INV_Misc_Gem_Pearl_08",
		"INV_Misc_Gem_Pearl_09",
		"INV_Misc_Gem_Pearl_10",
		"INV_Misc_Gem_Pearl_11",
		"INV_Misc_Gem_Pearl_12",
		"INV_Misc_Gem_Pearl_13",
		"INV_Misc_Gem_Pearl_14",
		"INV_Misc_Coin_16",
		"INV_Misc_Coin_17",
		"INV_Misc_Coin_18",
		"INV_Misc_Coin_19",
		"INV_Scarab_Bone",
		"INV_Scarab_Bronze",
		"INV_Scarab_Clay",
		"INV_Scarab_Crystal",
		"INV_Scarab_Gold",
		--"INV_Scarab_Ivory", --Icon Missing.
		"INV_Scarab_Silver",
		"INV_Scarab_Stone",
		"INV_SummerFest_Symbol_High",
		"INV_SummerFest_Symbol_Low",
		"INV_SummerFest_Symbol_Medium",
		"INV_Misc_Trophy_Argent", -- [541]

		"pvecurrency-justice",
		"pvecurrency-valor",
		"pvpcurrency-conquest-alliance",
		"pvpcurrency-conquest-horde",
		"pvpcurrency-honor-alliance",
		"pvpcurrency-honor-horde",
		"INV_Misc_Token_Darkmoon_01",
		"inv_misc_cat_trinket01",
		"inv_misc_cat_trinket02",
		"inv_misc_cat_trinket03",
		"inv_misc_cat_trinket04",
		"inv_misc_cat_trinket05",
		"inv_misc_cat_trinket06",
		"inv_misc_cat_trinket07",
		"inv_misc_cat_trinket08",
		"inv_misc_cat_trinket09",
		"inv_misc_cat_trinket10",
		"inv_wand_1h_pvp400_c_01",
		--"inv_wand_1h_cataclysm_c_01", --Icon Missing.
		"inv_wand_1h_cataclysm_c_02",
		"inv_wand_1h_cataclysm_c_03",
		"INV_Wand_1H_PandaRaid_D_01", 
		"INV_Wand_1h_PandariaQuest_B_01", 
		"INV_Wand_1h_PanDung_C_01",
		 "INV_Apexis_Draenor", 
		"INV_Relics_6oRunestone_ArakkoaCipher", 
		"INV_Relics_6oRunestone_OgreMissive", 
		"INV_Relics_6oRunestone_OrcSpeakingStaff", 
	}
	GHM_StockIcons["Herbalism"] = {
		-- ok
		"INV_Misc_Flower_01",
		"INV_Misc_Flower_01",
		"INV_Misc_Flower_02",
		"INV_Misc_Flower_03",
		"INV_Misc_Flower_04",
		"INV_Jewelry_Talisman_03",
		"INV_Misc_Herb_01",
		"INV_Misc_Herb_02",
		"INV_Misc_Herb_03",
		"INV_Misc_Herb_04",
		"INV_Misc_Herb_05",
		"INV_Misc_Herb_06",
		"INV_Misc_Herb_07",
		"INV_Misc_Herb_08",
		"INV_Misc_Herb_09",
		"INV_Misc_Herb_10",
		"INV_Misc_Herb_11",
		"INV_Misc_Herb_12",
		"INV_Misc_Herb_13",
		"INV_Misc_Herb_14",
		"INV_Misc_Herb_15",
		"INV_Misc_Herb_16",
		"INV_Misc_Herb_17",
		"INV_Misc_Herb_18",
		"INV_Misc_Herb_19",
		"INV_Misc_Herb_BlackLotus",
		"INV_Misc_Herb_DreamFoil",
		"INV_Misc_Herb_Dreamingglory",
		"INV_Misc_Herb_Felblossom",
		"INV_Misc_Herb_FelLotus",
		"INV_Misc_Herb_Felweed",
		"INV_Misc_Herb_Flamecap",
		"INV_Misc_Herb_IceCap",
		"INV_Misc_Herb_MountainSilverSage",
		"INV_Misc_Herb_PlagueBloom",
		"INV_Misc_Herb_IceCap",
		"INV_Misc_Herb_Manathistle",
		"INV_Misc_Herb_MountainSilverSage",
		"INV_Misc_Herb_Netherbloom",
		"INV_Misc_Herb_Nightmareseed",
		"INV_Misc_Herb_Nightmarevine",
		"INV_Misc_Herb_PlagueBloom",
		"INV_Misc_Herb_Ragveil",
		"INV_Misc_Herb_SansamRoot",
		"INV_Misc_Herb_Terrocone",
		"INV_Misc_Flower_01",
		"INV_Misc_Flower_02",
		"INV_Misc_Flower_03",
		"INV_Misc_Flower_04",
		"INV_Misc_Root_01",
		"INV_Misc_Root_02",
		"INV_Misc_SpineLeaf _01",
		"INV_Mushroom_01",
		"INV_Mushroom_02",
		"INV_Mushroom_03",
		"INV_Mushroom_04",
		"INV_Mushroom_05",
		"INV_Mushroom_06",
		"INV_Mushroom_07",
		"INV_Mushroom_08",
		"INV_Mushroom_09",
		"INV_Mushroom_10",
		"INV_Mushroom_11",
		"INV_Mushroom_12",
		"INV_Mushroom_13",
		"INV_MISC_HERB_01",
		"INV_MISC_HERB_06",
		"INV_Misc_Herb_11a",
		"INV_MISC_HERB_ANCIENTLICHEN",
		"INV_Misc_Herb_ConstrictorGrass",
		"INV_Misc_Herb_EvergreenMoss",
		"INV_Misc_Herb_FrostLotus",
		"INV_Misc_Herb_GoldClover",
		"INV_Misc_Herb_IceThorn",
		"INV_Misc_Herb_TalandrasRose",
		"INV_Misc_Herb_Tigerlily",
		"INV_Misc_Herb_Whispervine",
		"INV_Misc_Plant_01",
		"INV_Misc_Plant_02",
		"INV_Misc_Plant_03",
		"INV_RoseBouquet01",
		"INV_RosePotted01",
		"INV_Holiday_Summerfest_Petals",
		"INV_Misc_Marrigolds_01", -- [481]
		"INV_Misc_Roses_01", -- [499]
		"INV_Misc_TrailofFlowers", -- [540]

		"inv_misc_embers",
		"inv_misc_lifeblood",
		"inv_misc_herb_azsharasveil",
		"inv_misc_herb_cinderbloom",
		"inv_misc_herb_dragonsteeth",
		"inv_misc_herb_heartblossom",
		"inv_misc_herb_stormvine",
		"inv_misc_herb_twilightjasmine",
		"inv_misc_herb_whiptail",
		"INV_Misc_Herb_FoolsCap", 
		"INV_Misc_Herb_GoldenLotus", 
		"INV_Misc_Herb_JadeTeaLeaf", 
		"INV_Misc_Herb_RainPoppy", 
		"INV_Misc_Herb_ShaHerb", 
		"INV_Misc_Herb_Silkweed", 
		"INV_Misc_Herb_SnowLily", 
		"INV_Misc_Herb_TornDesecratedHerb", 
		"INV_Misc_Herb_TornFoolsCap", 
		"INV_Misc_Herb_TornGoldenLotus", 
		"INV_Misc_Herb_TornGreenTeaLeaf", 
		"INV_Misc_Herb_TornRainPoppy", 
		"INV_Misc_Herb_TornSilkweed", 
		"INV_Misc_Herb_TornSnowLilly", 

		"Inv_Farm_EnchantedSeed", 
		"Inv_Farm_GoldenSeed", 
		"Inv_Farm_HerbSeed", 
		"Inv_Farm_KypariteSeed", 
		"Inv_Farm_LeatherSeed", 
		"Inv_Farm_PumpkinSeed", 
		"Inv_Farm_PumpkinSeed_Blue", 
		"Inv_Farm_PumpkinSeed_Green", 
		"Inv_Farm_PumpkinSeed_Purple", 
		"Inv_Farm_PumpkinSeed_Red", 
		"Inv_Farm_PumpkinSeed_Yellow", 
		"Inv_Farm_SeedofHarmony", 
		"Inv_Farm_SeedofHarmony2", 
		"Inv_Farm_SoybeanSeed", 
		"Inv_Farm_SuperGro", 
		"Inv_Farm_TurnipSeedga", 
		"Inv_Farm_WindshearCactus",
		"INV_Misc_Bugsprayer", 	
		 "INV_misc_brightwaterlily",
		"INV_Misc_Herb_AddersTounge_Stem", 
		"INV_Misc_Herb_AncientLichenPetal", 
		"INV_Misc_Herb_Arrowbloom", 
		"INV_Misc_Herb_ArrowbloomPetal", 
		"INV_Misc_Herb_ArthasTear_Petal", 
		"INV_Misc_Herb_AzsharasVeil_Stem", 
		"INV_Misc_Herb_Blindweed_Stalk", 
		"INV_Misc_Herb_Bruiseweed_Stem", 
		"INV_Misc_Herb_ChamLotus", 
		"INV_Misc_Herb_ChamLotusPetal", 
		"INV_Misc_Herb_Cinderbloom_Petal", 
		"INV_Misc_Herb_Deadnettle_Bramble", 
		"INV_Misc_Herb_DragonsTeeth_Leaf", 
		"INV_Misc_Herb_DreamfoilBlade", 
		"INV_Misc_Herb_DreamingGloryPetal", 
		"INV_Misc_Herb_Fadeleaf_Petal", 
		"INV_Misc_Herb_FelweedStalk", 
		"INV_Misc_Herb_FireBloom_Petal", 
		"INV_Misc_Herb_FireLeaf_Bramble", 
		"INV_Misc_Herb_Fireweed", 
		"INV_Misc_Herb_FireweedBranch", 
		"INV_Misc_Herb_Flytrap", 
		"INV_Misc_Herb_FlytrapCap", 
		"INV_Misc_Herb_FrostWeed", 
		"INV_Misc_Herb_FrostWeedBranch", 
		"INV_Misc_Herb_GhostMushroomCap", 
		"INV_Misc_Herb_Goldclover_Leaf", 
		"INV_Misc_Herb_GoldenSamsamLeaf", 
		"INV_Misc_Herb_Goldthorn_Bramble", 
		"INV_Misc_Herb_GraveMoss", 
		"INV_Misc_Herb_GraveMoss_Leaf", 
		"INV_Misc_Herb_GromsbloodLeaf", 
		"INV_Misc_Herb_Heartblossom_Petal", 
		"INV_Misc_Herb_IcecapPetal", 
		"INV_Misc_Herb_Icethorn_Bramble", 
		"INV_Misc_Herb_KhdgWhskr_Stem", 
		"INV_Misc_Herb_Kingsblood_Petal", 
		"INV_Misc_Herb_Lichbloom_Stalk", 
		"INV_Misc_Herb_Liferoot_Stem", 
		"INV_Misc_Herb_Mana_Thistle_Leaf", 
		"INV_Misc_Herb_MtnSlvrSageStalk", 
		"INV_Misc_Herb_Netherbloom_Leaf", 
		"INV_Misc_Herb_NightmareVine_Stem", 
		"INV_Misc_Herb_PurpleLotus_Petal", 
		"INV_Misc_Herb_RagveilCap", 
		"INV_Misc_Herb_SorrowmossLeaf", 
		"INV_Misc_Herb_Starflower", 
		"INV_Misc_Herb_StarflowerPetal", 
		"INV_Misc_Herb_Stormvine_Stalk", 
		"INV_Misc_Herb_Stranglekelp_Blade", 
		"INV_Misc_Herb_Sungrass_Stalk", 
		"INV_Misc_Herb_TaladorOrchid", 
		"INV_Misc_Herb_TaladorOrchidPetal", 
		"INV_Misc_Herb_TalandrasRose_Petal", 
		"INV_Misc_Herb_TeroconeLeaf", 
		"INV_Misc_Herb_TigerLily_Petal", 
		"INV_Misc_Herb_TiwlightJasmine_Petal", 
		"INV_Misc_Herb_Whiptail_Stem", 
		"INV_Misc_Herb_WldSteelBloom_Petal", 
		"INV_misc_moonwillowleaf", 
	}
	GHM_StockIcons["Ranged"] = {
		-- ok
		"INV_Weapon_Bow_01",
		"INV_Weapon_Bow_02",
		"INV_Weapon_Bow_03",
		"INV_Weapon_Bow_04",
		"INV_Weapon_Bow_05",
		"INV_Weapon_Bow_06",
		"INV_Weapon_Bow_07",
		"INV_Weapon_Bow_08",
		"INV_Weapon_Bow_09",
		"INV_Weapon_Bow_10",
		"INV_Weapon_Bow_11",
		"INV_Weapon_Bow_12",
		"INV_Weapon_Crossbow_01",
		"INV_Weapon_Crossbow_02",
		"INV_Weapon_Crossbow_03",
		"INV_Weapon_Crossbow_04",
		"INV_Weapon_Crossbow_05",
		"INV_Weapon_Crossbow_06",
		"INV_Weapon_Crossbow_07",
		"INV_Weapon_Crossbow_08",
		"INV_Weapon_Crossbow_09",
		"INV_Weapon_Crossbow_10",
		"INV_Musket_01",
		"INV_Musket_02",
		"INV_Musket_03",
		"INV_Musket_04",
		"INV_Weapon_Rifle_01",
		"INV_Weapon_Rifle_02",
		"INV_Weapon_Rifle_03",
		"INV_Weapon_Rifle_04",
		"INV_Weapon_Rifle_05",
		"INV_Weapon_Rifle_06",
		"INV_Weapon_Rifle_07",
		"INV_Weapon_Rifle_08",
		"INV_Weapon_Rifle_09",
		"INV_Misc_Quiver_01",
		"INV_Misc_Quiver_02",
		"INV_Misc_Quiver_03",
		"INV_Misc_Quiver_04",
		"INV_Misc_Quiver_05",
		"INV_Misc_Quiver_06",
		"INV_Misc_Quiver_07",
		"INV_Misc_Quiver_08",
		"INV_Misc_Quiver_09",
		"INV_Misc_Quiver_10",
		"INV_Bow_1H_Auchindoun_D_01",
		"INV_Weapon_Bow_13",
		"INV_WEAPON_BOW_14",
		"INV_Weapon_Bow_15",
		"INV_Weapon_Bow_16",
		"INV_Weapon_Bow_17",
		"INV_Weapon_Bow_18",
		"INV_Weapon_Bow_19",
		"INV_Weapon_Bow_20",
		"INV_Weapon_Bow_28",
		"INV_Weapon_Bow_30",
		"INV_Weapon_Bow_31",
		"INV_Weapon_Bow_32",
		"INV_Weapon_Bow_33",
		"INV_Weapon_Bow_34",
		"INV_Weapon_Bow_35",
		"INV_Weapon_Bow_36",
		"INV_Weapon_Bow_37",
		"INV_WEAPON_BOW_38",
		"INV_WEAPON_BOW_39",
		"INV_Weapon_Bow_40",
		"INV_Weapon_Bow_41",
		"INV_Weapon_Bow_42",
		"INV_Weapon_Bow_43",
		"INV_Weapon_Bow_44",
		"INV_Weapon_Bow_45",
		"INV_Weapon_Bow_46",
		"INV_Weapon_Bow_47",
		"INV_Weapon_Bow_48",
		"INV_Weapon_Bow_49",
		"INV_Weapon_Bow_50",
		"INV_Weapon_Crossbow_11",
		"INV_Weapon_Crossbow_12",
		"INV_Weapon_Crossbow_13",
		"INV_Weapon_Crossbow_14",
		"INV_Weapon_Crossbow_15",
		"INV_Weapon_Crossbow_16",
		"INV_Weapon_Crossbow_17",
		"INV_Weapon_Crossbow_18",
		"INV_Weapon_Crossbow_19",
		"INV_Weapon_Crossbow_20",
		"INV_Weapon_Crossbow_21",
		"INV_Weapon_Crossbow_22",
		"INV_Weapon_Crossbow_23",
		"INV_Weapon_Crossbow_24",
		"INV_Weapon_Crossbow_25",
		"INV_Weapon_Crossbow_26",
		"INV_Weapon_Crossbow_27",
		"INV_Weapon_Crossbow_28",
		"INV_Weapon_Crossbow_29",
		"INV_Weapon_Crossbow_30",
		"INV_Weapon_Crossbow_31",
		"INV_Weapon_Crossbow_32",
		"INV_Weapon_Rifle_10",
		"INV_Weapon_Rifle_11",
		"INV_Weapon_Rifle_13",
		"INV_Weapon_Rifle_14",
		"INV_Weapon_Rifle_15",
		"INV_Weapon_Rifle_16",
		"INV_Weapon_Rifle_17",
		"INV_Weapon_Rifle_18",
		"INV_Weapon_Rifle_19",
		"INV_Weapon_Rifle_20",
		"INV_Weapon_Rifle_21",
		"INV_Weapon_Rifle_22",
		"INV_Weapon_Rifle_23",
		"INV_Weapon_Rifle_24",
		"INV_Weapon_Rifle_26",
		"INV_Weapon_Rifle_27",
		"INV_Weapon_Rifle_28",
		"INV_Weapon_Rifle_29",
		"INV_Weapon_Rifle_30",
		"INV_Weapon_Rifle_31",
		"INV_WAEPON_BOW_ZULGRUB_D_01",
		"INV_WAEPON_BOW_ZULGRUB_D_02",

		"INV_Weapon_Bow_51", -- [716]
		"INV_Weapon_Bow_52", -- [717]
		"INV_Weapon_Bow_54", -- [718]
		"INV_Weapon_Bow_55", -- [719]
		"INV_Weapon_Bow_56", -- [720]
		"INV_Weapon_Crossbow_33", -- [721]
		"INV_Weapon_Crossbow_34", -- [722]
		"INV_Weapon_Crossbow_35", -- [723]
		"INV_Weapon_Crossbow_36", -- [724]
		"INV_Weapon_Crossbow_37", -- [725]
		"INV_Weapon_Crossbow_38", -- [726]
		"INV_Weapon_Rifle_33", -- [737]
		"INV_Weapon_Rifle_34", -- [738]
		"INV_WEAPON_RIFLE_35", -- [739]
		"INV_Weapon_Rifle_36", -- [740]
		"INV_Weapon_Rifle_37", -- [741]
		"INV_Weapon_Rifle_38", -- [742]
		"INV_Weapon_Rifle_39", -- [743]
		"INV_Weapon_Bow_51", -- [934]
		"INV_Weapon_Bow_52", -- [935]
		"INV_Weapon_Bow_54", -- [936]
		"INV_Weapon_Bow_55", -- [937]
		"INV_Weapon_Bow_56", -- [938]
		"INV_Weapon_Crossbow_33", -- [939]
		"INV_Weapon_Crossbow_34", -- [940]
		"INV_Weapon_Crossbow_35", -- [941]
		"INV_Weapon_Crossbow_36", -- [942]
		"INV_Weapon_Crossbow_37", -- [943]
		"INV_Weapon_Crossbow_38", -- [944]
		"INV_Weapon_Rifle_33", -- [955]
		"INV_Weapon_Rifle_34", -- [956]
		"INV_WEAPON_RIFLE_35", -- [957]
		"INV_Weapon_Rifle_36", -- [958]
		"INV_Weapon_Rifle_37", -- [959]
		"INV_Weapon_Rifle_38", -- [960]
		"INV_Weapon_Rifle_39", -- [961]

		"inv_bow_1h_pvp400_c_01",
		"inv_bow_1h_cataclysm_c_01",
		"inv_throwingchakrum_01",
		"inv_firearm_2h_rifle_cataclysm_c_01",


		"INV_Firearm_2h_Rifle_430Future_C_01",
		"INV_Firearm_2h_Rifle_DeathwingRaid_D_01",
		"INV_Firearm_2H_Rifle_PVPCataclysmS3_C_01",

		"Bow_1h_430Future_C_01",
		"INV_1H_430NightElf_C_01",
		"INV_Bow_1h_PVPCataclysmS3_C_01",
		"INV_Bow_1hDeathwingRaidDW_D_01",
		"INV_Thrown_1H_430NightElf_C_01",
		"INV_Thrown_1h_PVPCataclysmS3_C_01",

		"INV_Weapon_Crossbow_41",
		"INV_Bow_1H_PandaRaid_D_01", 
		"INV_Bow_1h_PanDung_C_01", 
		"INV_Bow_1h_PanProg_B_01", 
		"INV_Bow_1h_PanProg_B_01Blue", 
		"INV_Bow_1h_PanProg_B_01Jade", 
		"INV_Bow_1h_PVPPandariaS1_D_01", 
		"INV_Bow_2h_Crossbow_PandaRaid_D_01", 
		"INV_Bow_2h_Crossbow_PanStart_A_01",
		"INV_Firearm_2H_Rifle_PandaRaid_D_01", 
		"INV_Firearm_2h_Rifle_PandariaQuest_B_01", 
		"INV_Firearm_2H_Rifle_PanDung_C_01", 
		"INV_Firearm_2h_Rifle_PVPPandariaS1_C_01", 
		"INV_Legendary_Gun", 
		
		"INV_Bow_1H_DwarfHunter_C_01", 
		"INV_Bow_1h_ThunderIsleRaid_D_01", 
		"INV_Bow_1H_Zandalari_C_01", 
		"INV_Bow_2h_Crossbow_PVPPandariaS2_C_01", 
		"INV_Bow_2h_Crossbow_ThunderIsleRaid_D_01", 
		"INV_Firearm_2H_Rifle_Archaeology_D_01", 
		"INV_Firearm_2h_Rifle_ThunderIsleRaid_D_01", 
		"INV_Bow_1h_DraenorChallenge_D_01", 
		"INV_Bow_1h_DraenorCrafted_D_01_A_Alliance", 
		"INV_Bow_1h_DraenorCrafted_D_01_A_Horde", 
		"INV_Bow_1h_DraenorCrafted_D_01_B_Alliance", 
		"INV_Bow_1h_DraenorCrafted_D_01_B_Horde", 
		"INV_Bow_1h_DraenorCrafted_D_01_C_Alliance", 
		"INV_Bow_1h_DraenorCrafted_D_01_C_Horde", 
		"INV_Bow_1h_DraenorDungeon_C_01", 
		"INV_Bow_1h_DraenorHonor_C_01", 
		"INV_Bow_1h_DraenorQuest95_B_01", 
		"INV_Bow_1h_DraenorQuest_B_01", 
		"INV_Bow_1h_DraenorRaid_D_01", 
		"INV_Bow_1H_DraenorRaid_D_02", 
		"INV_Bow_1h_PVPDraenorS1_D_01", 
		"INV_Bow_2h_Crossbow_DraenorDungeon_C_01", 
		"INV_Bow_2H_Crossbow_DraenorQuest95_B_01", 
		"INV_BOW_2H_CROSSBOW_DRAENORQUEST_B_01", 
		"INV_Bow_2h_Crossbow_DraenorRaid_D_01", 
		"INV_bow_2h_crossbow_orcclan_b_01", 
		"INV_Bow_2h_Crossbow_PVPDraenorS1_D_01", 
		"INV_Firearm_2h_Rifle_DraenorChallenge_D_01", 
		"INV_Firearm_2h_Rifle_DraenorCrafted_D_01_A_alliance", 
		"INV_Firearm_2h_Rifle_DraenorCrafted_D_01_A_Horde", 
		"INV_Firearm_2h_Rifle_DraenorCrafted_D_01_B_alliance", 
		"INV_Firearm_2h_Rifle_DraenorCrafted_D_01_B_Horde", 
		"INV_Firearm_2h_Rifle_DraenorCrafted_D_01_C_alliance", 
		"INV_Firearm_2h_Rifle_DraenorCrafted_D_01_C_Horde", 
		"INV_Firearm_2h_Rifle_DraenorDungeon_C_01", 
		"INV_Firearm_2h_Rifle_DraenorHonor_C_01", 
		"INV_Firearm_2h_Rifle_DraenorQuest95_B_01", 
		"INV_Firearm_2h_Rifle_DraenorQuest_B_01", 
		"INV_Firearm_2h_Rifle_DraenorRaid_D_01", 
		"INV_Firearm_2h_Rifle_PVPDraenorS1_D_01", 
	}
	GHM_StockIcons["Pants"] = {
		-- ok
		"INV_Plate_Pants_PVPWarrior_E_01", 
		"INV_Pants_01",
		"INV_Pants_02",
		"INV_Pants_03",
		"INV_Pants_04",
		"INV_Pants_05",
		"INV_Pants_06",
		"INV_Pants_07",
		"INV_Pants_08",
		"INV_Pants_09",
		"INV_Pants_10",
		"INV_Pants_11",
		"INV_Pants_12",
		"INV_Pants_13",
		"INV_Pants_14",
		"INV_Pants_Wolf",
		"INV_Misc_Desecrated_ClothPants",
		"INV_Misc_Desecrated_LeatherPants",
		"INV_Misc_Desecrated_MailPants",
		"INV_Misc_Desecrated_PlatePants",
		"INV_Pants_Cloth_01",
		"INV_Pants_Cloth_02",
		"INV_Pants_Cloth_03",
		"INV_Pants_Cloth_04",
		"INV_Pants_Cloth_05",
		"INV_Pants_Cloth_06",
		"INV_Pants_Cloth_07",
		"INV_Pants_Cloth_08",
		"INV_Pants_Cloth_09",
		"INV_Pants_Cloth_10",
		"INV_Pants_Cloth_11",
		"INV_Pants_Cloth_12",
		"INV_Pants_Cloth_13",
		"INV_Pants_Cloth_14",
		"INV_Pants_Cloth_15",
		"INV_Pants_Cloth_16",
		"INV_Pants_Cloth_17",
		"INV_Pants_Cloth_18",
		"INV_Pants_Cloth_19",
		"INV_Pants_Cloth_20",
		"INV_Pants_Cloth_21",
		"INV_Pants_Cloth_22",
		"INV_Pants_Cloth_23",
		"INV_Pants_Cloth_24",
		"INV_Pants_Cloth_25",
		"INV_Pants_Cloth_26",
		"INV_Pants_Cloth_27",
		"INV_Pants_Cloth_28",
		"INV_Pants_Cloth_29",
		"INV_Pants_Leather_01",
		"INV_Pants_Leather_02",
		"INV_Pants_Leather_03",
		"INV_Pants_Leather_04",
		"INV_Pants_Leather_05",
		"INV_Pants_Leather_06",
		"INV_Pants_Leather_07",
		"INV_Pants_Leather_08",
		"INV_Pants_Leather_09",
		"INV_Pants_Leather_10",
		"INV_Pants_Leather_11",
		"INV_Pants_Leather_12",
		"INV_Pants_Leather_13",
		"INV_Pants_Leather_14",
		"INV_Pants_Leather_15",
		"INV_Pants_Leather_16",
		"INV_Pants_Leather_17",
		"INV_Pants_Leather_18",
		"INV_Pants_Leather_19",
		"INV_Pants_Leather_20",
		"INV_Pants_Leather_21",
		"INV_Pants_Leather_22",
		"INV_Pants_Leather_23",
		"INV_Pants_Leather_24",
		"INV_Pants_Leather_25",
		"INV_Pants_Leather_26",
		"INV_Pants_Leather_27",
		"INV_Pants_Mail_01",
		"INV_Pants_Mail_02",
		"INV_Pants_Mail_03",
		"INV_Pants_Mail_04",
		"INV_Pants_Mail_05",
		"INV_Pants_Mail_06",
		"INV_Pants_Mail_07",
		"INV_Pants_Mail_08",
		"INV_Pants_Mail_09",
		"INV_Pants_Mail_10",
		"INV_Pants_Mail_11",
		"INV_Pants_Mail_12",
		"INV_Pants_Mail_13",
		"INV_Pants_Mail_14",
		"INV_Pants_Mail_15",
		"INV_Pants_Mail_16",
		"INV_Pants_Mail_17",
		"INV_Pants_Mail_18",
		"INV_Pants_Mail_19",
		"INV_Pants_Mail_20",
		"INV_Pants_Mail_21",
		"INV_Pants_Mail_24",
		"INV_Pants_Mail_25",
		"INV_Pants_Plate_01",
		"INV_Pants_Plate_02",
		"INV_Pants_Plate_03",
		"INV_Pants_Plate_04",
		"INV_Pants_Plate_05",
		"INV_Pants_Plate_06",
		"INV_Pants_Plate_07",
		"INV_Pants_Plate_08",
		"INV_Pants_Plate_09",
		"INV_Pants_Plate_10",
		"INV_Pants_Plate_11",
		"INV_Pants_Plate_12",
		"INV_Pants_Plate_13",
		"INV_Pants_Plate_14",
		"INV_Pants_Plate_15",
		"INV_Pants_Plate_16",
		"INV_Pants_Plate_17",
		"INV_Pants_Plate_18",
		"INV_Pants_Plate_19",
		"INV_Pants_Plate_20",
		"INV_Pants_Plate_21",
		"INV_Pants_Plate_22",
		"INV_Pants_Plate_23",
		"INV_Pants_Plate_24",
		"INV_Pants_Plate_25",
		"INV_Pants_Plate_26",
		"INV_Pants_Plate_27",
		"INV_PANTS_CLOTH_29",
		"INV_Pants_Cloth_30",
		"INV_Pants_Cloth_31",
		"INV_PANTS_LEATHER_26",
		"INV_PANTS_LEATHER_27",
		"INV_Pants_Leather_28",
		"INV_PANTS_MAIL_24",
		"INV_PANTS_MAIL_25",
		"INV_Pants_Mail_26",
		"INV_Pants_Mail_27",
		"INV_PANTS_PLATE_26",
		"INV_PANTS_PLATE_27",
		"INV_Pants_Plate_28",
		"INV_Pants_Plate_29",
		"INV_Pants_Plate_30",
		"INV_Pants_Cloth_32", -- [549]
		"INV_Pants_Cloth_33", -- [550]
		"INV_Pants_Cloth_34", -- [551]
		"INV_Pants_Cloth_34Black", -- [552]
		"INV_Pants_Cloth_34Green", -- [553]
		"INV_Pants_Cloth_34Purple", -- [554]
		"INV_Pants_Cloth_35", -- [555]
		"INV_Pants_Leather_29A", -- [556]
		"INV_Pants_Leather_29B", -- [557]
		"INV_Pants_Leather_30A", -- [558]
		"INV_Pants_Leather_30B", -- [559]
		"INV_Pants_Leather_33", -- [560]
		"INV_Pants_Leather_34", -- [561]
		"INV_Pants_Leather_35", -- [562]
		"INV_Pants_Mail_28", -- [563]
		"INV_Pants_Mail_32", -- [564]
		"INV_Pants_Mail_33", -- [565]
		"INV_Pants_Mail_35", -- [566]
		"INV_Pants_Plate_31", -- [567]
		"INV_Pants_Plate_32", -- [568]
		"INV_Pants_Plate_33", -- [569]
		"INV_Pants_Plate_34", -- [570]
		"INV_Pants_Cloth_32", -- [767]
		"INV_Pants_Cloth_33", -- [768]
		"INV_Pants_Cloth_34", -- [769]
		"INV_Pants_Cloth_34Black", -- [770]
		"INV_Pants_Cloth_34Green", -- [771]
		"INV_Pants_Cloth_34Purple", -- [772]
		"INV_Pants_Cloth_35", -- [773]
		"INV_Pants_Leather_29A", -- [774]
		"INV_Pants_Leather_29B", -- [775]
		"INV_Pants_Leather_30A", -- [776]
		"INV_Pants_Leather_30B", -- [777]
		"INV_Pants_Leather_33", -- [778]
		"INV_Pants_Leather_34", -- [779]
		"INV_Pants_Leather_35", -- [780]
		"INV_Pants_Mail_28", -- [781]
		"INV_Pants_Mail_32", -- [782]
		"INV_Pants_Mail_33", -- [783]
		"INV_Pants_Mail_35", -- [784]
		"INV_Pants_Plate_31", -- [785]
		"INV_Pants_Plate_32", -- [786]
		"INV_Pants_Plate_33", -- [787]
		"INV_Pants_Plate_34", -- [788]
		"INV_Kilt_Cloth_02", -- [431]
		"INV_Kilt_Mail_01", -- [432]

		--"inv_pants_plate_dungeonplage_c_04", --Icon Missing.
		"inv_pants_cloth_pvpmage_c_01",
		"inv_pants_leather_cataclysm_b_01",
		"inv_pants_plate_dungeonplate_c_03",
		"inv_pants_leather_39v1",
		"inv_pants_leather_39v2",
		"inv_pants_leather_39v3",
		"inv_pants_leather_40v1",
		"inv_pants_leather_40v2",
		"inv_pants_leather_40v3",
		"inv_pants_leather_41v1",
		"inv_pants_leather_41v2",
		"inv_pants_leather_41v3",
		"inv_pants_leather_42v1",
		"inv_pants_leather_42v2",
		"inv_pants_leather_42v3",
		"inv_pants_leather_pvpdruid_c_01",
		"inv_pants_mail_37v1",
		"inv_pants_mail_37v2",
		"inv_pants_mail_37v3",
		"inv_pants_mail_38v1",
		"inv_pants_mail_38v2",
		"inv_pants_mail_38v3",
		"inv_pants_mail_39v1",
		"inv_pants_mail_39v2",
		"inv_pants_mail_39v3",
		"inv_pants_mail_40v1",
		"inv_pants_mail_40v2",
		"inv_pants_mail_40v3",
		"inv_pants_plate_38v1",
		"inv_pants_plate_38v2",
		"inv_pants_plate_38v3",
		"inv_pants_plate_39v1",
		"inv_pants_plate_39v2",
		"inv_pants_plate_39v3",
		"inv_pants_plate_40v1",
		"inv_pants_plate_40v2",
		"inv_pants_plate_40v3",
		"inv_pants_robe_common_c_01v1",
		"inv_pants_robe_common_c_01v2",
		"inv_pants_robe_common_c_01v3",

		"inv_pants_cloth_cataclysm_b_01",
		"inv_pants_cloth_raidwarlock_i_01",
		"inv_pants_leather_32",
		"inv_pants_mail_41",
		"inv_pants_mail_42",
		"inv_pants_leather_43",
		"inv_pants_plate_26",
		"inv_pant_leatherraidrogue_i_01",
		"inv_pants_leather_cataclysm_b_02",
		"inv_pants_leather_raiddruid_i_01",
		"inv_pants_plate_cataclysm_b_02",
		"inv_pants_plate_pvppaladin_c_01",
		"inv_pants_plate_pvpwarrior_c_02",
		"inv_pants_plate_raidwarrior_i_01",
		"inv_pant_mail_pvphunter_c_01",
		"inv_pants_mail_dungeonmail_c_03",
		"inv_pants_mail_41",
		"inv_pants_robe_dungeonrobe_c_03",
		"inv_pants_robe_dungeonrobe_c_04",
		"inv_pants_robe_pvppriest_c_01",
		"inv_pants_robe_common_c_01",
		"inv_pants_mail_36v4",
		"inv_pants_mail_36v3",
		"inv_pants_mail_36v2",
		"inv_pants_leather_44",
		"inv_pants_leather_38v4",
		"inv_pants_leather_38v3",
		"inv_pants_leather_38v2",
		"inv_pants_cloth_42v4",
		"inv_pants_cloth_42v3",
		"inv_pants_cloth_42v2",
		"inv_pants_cloth_41v4",
		"inv_pants_cloth_41v3",
		"inv_pants_cloth_41v2",
		"inv_pants_cloth_40v4",
		"inv_pants_cloth_40v3",
		"inv_pants_cloth_40v2",
		"inv_pants_cloth_39v4",
		"inv_pants_cloth_39v3",
		"inv_pants_cloth_39v2",
		"INV_Pant_Leather_RaidDruid_K_01",
		"INV_Pant_Robe_PVPMage_D_01",
		"INV_Pant_Robe_PVPPriest_D_01",
		"INV_Pants_Leather_DungeonLeather_C_05",
		"INV_Pants_Leather_PVPDruid_D_01",
		"INV_Pants_Leather_PVPRogue_D_01",
		"INV_Pants_Leather_RaidRogue_K_01",
		"INV_Pants_Mail_DungeonMail_C_05",
		"INV_Pants_Mail_PVPHunter_D_01",
		"INV_Pants_Mail_PVPShaman_D_01",
		"INV_Pants_Mail_RaidHunter_K_01",
		"INV_Pants_Mail_RaidShaman_K_01",
		"INV_Pants_Plate_DungeonPlate_C_05",
		"INV_Pants_Plate_DungeonPlate_C_06",
		"INV_Pants_Plate_PVPDeathKnight_D_01",
		"INV_Pants_Plate_PVPPaladin_D_01",
		"INV_Pants_Plate_PVPWarrior_D_01",
		"INV_Pants_Plate_RaidPaladin_K_01",
		"INV_Pants_Plate_RaidWarrior_K_01",
		"INV_Pants_Robe_DungeonRobe_C_05",
		"INV_Pants_Robe_PVPWarlock_D_01",
		"INV_Pants_Robe_RaidMage_K_01",
		"INV_Pants_Robe_RaidPriest_K_01",
		"INV_Pants_Robe_RaidWarlock_K_01",
		"inv_kilt_cloth_04v4",
		"inv_kilt_cloth_04v3",
		"inv_kilt_cloth_04v2",

		"INV_Kilt_Robe_RaidMage_K_01",
		"INV_Kilt_Mail_Panda_B_01", 
		"INV_Kilt_Mail_Panda_B_01Green", 
		"INV_Kilt_Mail_Panda_B_01White", 
		"INV_Kilt_Mail_PVPShaman_E_01", 
		"INV_Pants_Cloth_ChallengePriest_D_01", 
		"INV_Pants_Cloth_DungeonCloth_C_06", 
		"INV_Pants_Cloth_Panda_B_01", 
		"INV_Pants_Cloth_Panda_B_01_Green", 
		"INV_Pants_Cloth_Panda_B_01_Red", 
		"INV_Pants_Cloth_Panda_B_02", 
		"INV_Pants_Cloth_Panda_B_02_Blue", 
		"INV_Pants_Cloth_Panda_B_02_White", 
		"INV_Pants_Cloth_Panstart_A_01", 
		"INV_Pants_Cloth_RaidWarlock_L_01", 
		"INV_Pants_Cloth_Reputation_C_01", 
		"INV_Pants_Leather_ChallengeMonk_D_01", 
		"INV_Pants_Leather_ChallengeRogue_D_01", 
		"INV_Pants_Leather_DungeonLeather_C_06", 
		"INV_Pants_Leather_Panda_B_01", 
		"INV_Pants_Leather_Panda_B_01Dark", 
		"INV_Pants_Leather_Panda_B_01Light", 
		"INV_Pants_Leather_Panda_B_01Red", 
		"INV_Pants_Leather_Panda_B_02", 
		"INV_Pants_Leather_Panda_B_02_Brown", 
		"INV_Pants_Leather_Panda_B_02_Crimson", 
		"INV_Pants_Leather_Panda_B_02_Indigo", 
		"INV_Pants_Leather_PVPMonk_E_01", 
		"INV_Pants_Leather_PVPRogue_E_01", 
		"INV_Pants_Leather_RaidDruid_L_01", 
		"INV_Pants_Leather_RaidRogue_L_01", 
		"INV_Pants_Mail_ChallengeShaman_D_01", 
		"INV_Pants_Mail_Panda_B_01", 
		"INV_Pants_Mail_Panda_B_02", 
		"INV_Pants_Mail_PVPShaman_E_01", 
		"INV_Pants_Mail_RaidShaman_L_01", 
		"INV_Pants_Plate_ChallengeDeathKnight_D_01", 
		"INV_Pants_Plate_ChallengePaladin_D_01", 
		"INV_Pants_Plate_DungeonPlate_C_07", 
		"INV_Pants_Plate_Panda_B_01", 
		"INV_Pants_Plate_Panda_B_02", 
		"INV_Pants_Plate_Panda_B_02Green", 
		"INV_Pants_Plate_Panda_B_02Purple", 
		"INV_Pants_Plate_Panda_B_02Yellow", 
		"INV_Pants_Plate_PVPDeathKnight_E_01", 
		"INV_Pants_Plate_PVPPaladin_E_01", 
		"INV_Pants_Plate_RaidDeathKnight_L_01", 
		"INV_Pants_Plate_RaidWarrior_L_01", 
		"INV_Pants_Plate_Reputation_C_01", 
		"INV_Pants_PVPPriest_E_01", 
		"INV_Pants_Robe_Panda_A_02", 
		"INV_Pants_Robe_PanProg_B_01", 
		"INV_Pant_ChallengeDruid_D_01", 
		"INV_Pant_Cloth_ChallengeMage_D_01", 
		"INV_Pant_Cloth_RaidPriest_L_01", 
		"INV_Pant_Leather_PanProg_B_01", 
		"INV_Pant_Leather_PVPDruid_E_01", 
		"INV_Pant_Leather_RaidMonk_L_01", 
		"INV_Pant_Leather_Reputation_C_01", 
		"INV_Pant_Mail_ChallengeHunter_D_01", 
		"INV_Pant_Mail_DungeonMail_C_06", 
		"INV_Pant_Mail_PanProg_B_01", 
		"INV_Pant_Mail_PVPHunter_E_01", 
		"INV_Pant_Mail_RaidHunter_L_01", 
		"INV_Pant_Mail_Reputation_C_01", 
		"INV_Pant_Plate_ChallengeWarrior_D_01", 
		"INV_Pant_Plate_Panda_B_01Blue", 
		"INV_Pant_Plate_Panda_B_01Gold", 
		"INV_Pant_Plate_RaidPaladin_L_01", 
		"INV_Pant_PVPWarlock_E_01", 
		"INV_Pant_RaidMage_L_01", 
		"INV_Pant_Robe_PVPMage_E_01", 


		"Plate_RaidDeathKnight_K_01_Pant",
		"INV_Cloth_RaidPriest_M_01Pant",  	
		"INV_Cloth_PVPWarlock_F_01Pant", 
		"INV_Leather_RaidDruid_M_01Pant", 
		"INV_Pants_Cloth_PVPMage_F_01", 
		"INV_Pants_Leather_PVPMonk_F_01", 
		"INV_Pants_Leather_PVPRogue_F_01", 
		"INV_Pants_Mail_PVPShaman_F_01", 
		"INV_Pants_Plate_DeathKnight_M_01", 
		"INV_Pants_Plate_PVPDeathKnight_F_01", 
		"INV_Pants_Plate_PVPPaladin_F_01Bronze", 
		"INV_Pants_Plate_PVPPaladin_F_01Red", 
		"INV_Pants_Plate_PVPPaladin_F_01White", 
		"INV_Pants_Plate_RaidPaladin_M_01", 
		"INV_Pants_Plate_RaidWarrior_M_01", 
		"INV_Pants_PVPWarrior_F_01", 
		"INV_Pant_Cloth_PVPPriest_F_01", 
		"INV_Pant_Cloth_RaidMage_M_01", 
		"INV_Pant_Cloth_RaidWarlock_M_01", 
		"INV_Pant_Leather_RaidMonk_M_01", 
		"INV_Pant_Leather_RaidRogue_M_01", 
		"INV_Pant_Mail_RaidHunter_M_01", 
		"INV_Pant_Mail_RaidShaman_M_01",
		"INV_Kilt_Cloth_PVPPriest_G_01", 
		"INV_Kilt_Cloth_RaidMage_N_01", 
		"INV_Kilt_Mail_PVPShaman_G_01", 
		"INV_Cloth_PVPWarlock_G_01Pant",  
		"INV_Cloth_RaidPriest_N_01Pant", 
		"INV_Leather_RaidDruid_N_01Pant",
		"INV_Bow_1H_OrgrimmarRaid_D_01", 
		"INV_Bow_1h_OrgrimmarRaid_D_02", 
		"INV_Bow_1h_PVPHorde_A_01_upres", 
		"INV_Bow_1h_PVPPandariaS3_C_01", 
		"INV_Bow_2h_Crossbow_OrgrimmarRaid_D_01", 
		"INV_Firearm_2H_Rifle_OrgrimmarRaid_D_01", 
		"INV_Firearm_2h_Rifle_PVPPandariaS3_C_01",
		"INV_Mail_RaidShaman_N_01Pant", 
		"INV_Plate_PVPDeathKnight_G_01_PANT", 
		"INV_Plate_PVPWarrior_G_01Pant",
		"INV_Plate_RaidPaladin_N_01Pant",   
		"INV_Pants_Leather_PVPRogue_G_01", 
		"INV_Pants_Mail_PVPHunter_G_01", 
		"INV_Pants_Plate_RaidDeathKnight_N_01", 
		"Inv_Pants_Plate_RaidWarrior_N_01", 
		"INV_Pant_Cloth_PVPMage_G_01", 
		"INV_Pant_Cloth_PVPPriest_G_01", 
		"INV_Pant_Cloth_RaidMage_N_01", 
		"INV_Pant_Cloth_RaidWarlock_N_01", 
		"INV_Pant_Leather_PVPDruid_G_01", 
		"INV_Pant_Leather_PVPMonk_G_01", 
		"INV_Pant_Leather_RaidMonk_N_01", 
		"INV_Pant_Leather_RaidRogue_N_01", 
		"INV_Pant_Mail_KorKronShaman_D_01", 
		"INV_Pant_Mail_RaidHunter_N_01", 
		"INV_Pant_Plate_PVPPaladin_G_01", 
		"INV_Pants_Leather_DraenorLFR_C_01", 
		"INV_Pant_Cloth_DraenorHonor_C_01", 
		"INV_Pant_Cloth_DraenorLFR_C_01", 
		"INV_Pant_Cloth_DraenorQuest90_B_01", 
		"INV_Pant_Cloth_PVPMageGladiator_O_01", 
		"INV_Pant_Cloth_PVPMage_O_01", 
		"INV_Pant_Cloth_PVPPriestGladiator_O_01", 
		"INV_Pant_Cloth_PVPPriest_O_01", 
		"INV_Pant_Cloth_PVPWarlock_O_01", 
		"INV_Pant_Cloth_RaidMageMythic_O_01", 
		"INV_Pant_Cloth_RaidMage_O_01", 
		"INV_Pant_Cloth_RaidPriestMythic_O_01", 
		"INV_Pant_Cloth_RaidPriest_O_01", 
		"INV_Pant_Cloth_ShadowmoonClan_B_01", 
		"INV_Pant_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Pant_Leather_DraenorCrafted_D_01_Horde", 
		"INV_Pant_Leather_DraenorQuest90_B_01", 
		"INV_Pant_Leather_PvPMonkGladiator_O_01", 
		"INV_Pant_Leather_PvPMonk_O_01", 
		"INV_Pant_Leather_PvPRogueGladiator_O_01", 
		"INV_Pant_Leather_PVPRogue_O_01", 
		"INV_pant_Mail_DraenorCrafted_D_01_alliance", 
		"INV_pant_Mail_DraenorCrafted_D_01_Horde", 
		"INV_Pant_Mail_DraenorDungeon_C_01", 
		"INV_pant_Mail_DraenorHonor_C_01", 
		"INV_pant_Mail_DraenorLFR_C_01", 
		"INV_Pant_Mail_DraenorQuest95_B_01", 
		"INV_Pant_Mail_PvPHunterGladiator_O_01", 
		"INV_PANT_Mail_PVPHunter_O_01", 
		"INV_Pant_Mail_PvPShamanGladiator_O_01", 
		"INV_Pant_Mail_PVPShaman_O_01", 
		"INV_pant_Mail_RaidHunterMythic_O_01", 
		"INV_pant_Mail_RaidHunter_O_01", 
		"INV_pant_Mail_RaidShamanMythic_O_01", 
		"INV_Pant_Mail_RaidShaman_O_01", 
		"INV_Pant_Mail_WarsongClan_B_01", 
		"INV_pant_plate_draenordungeon_c_01", 
		"INV_Pant_Plate_DraenorHonor_C_01", 
		"INV_Pant_Plate_DraenorQuest95_B_01", 
		"INV_Pant_Plate_PvPDeathKnightGladiator_O_01", 
		"INV_Pant_Plate_PvPDeathKnight_O_01", 
		"INV_Pant_Plate_PVPPaladinGladiator_O_01", 
		"INV_Pant_Plate_PVPPaladin_O_01", 
		"INV_Pant_Plate_RaidPaladinMythic_O_01", 
		"INV_Pant_Plate_RaidPaladin_O_01", 		
		"INV_Cloth_DraenorCrafted_D_01Pants", 
		"INV_Cloth_DraenorCrafted_D_01Pants_Horde", 
		"INV_Cloth_DraenorDungeon_C_01Pant", 
		"INV_Cloth_DraenorQuest95_B_01Pant", 
		"INV_Cloth_RaidWarlock_O_01Pants",
		"INV_Leather_DraenorDungeon_C_01Pant", 
		"INV_Leather_DraenorHonor_C_01Pant", 
		"INV_Leather_DraenorQuest95_B_01Pant",
		"INV_Leather_PvPDruidGladiator_O_01Pant", 
		"INV_Leather_PvPDruid_O_01Pant", 
		"INV_Leather_RaidDruid_O_01Pant",
		"INV_Leather_RaidMonk_O_01Pant", 
		"INV_Leather_RaidRogueMythic_O_01Pant", 
		"INV_Leather_RaidRogue_O_01Pant",
		"INV_Mail_DraenorQuest90_B_01Pant",
		"INV_Plate_BlackrockClan_B_01Pant", 
		"INV_Plate_DraeneiGuard_C_01Pant", 
		"INV_Plate_DraenorCrafted_D_01Pant", 
		"INV_Plate_DraenorLFR_C_01Pant", 
		"INV_Plate_DraenorQuest90_B_01Pant", 
		"INV_Plate_Plate_PvPWarriorGladaitor_O_01Pants",
		"INV_Plate_Plate_PvPWarrior_O_01Pants", 
		"INV_Plate_RaidDeathKnightMythic_O_01Pant", 
		"INV_Plate_RaidDeathKnight_O_01Pant", 
		"INV_Plate_RaidWarrior_O_01Pants",
		"INV_Leather_DraenorDungeon_C_01Pant", 
		"INV_Leather_DraenorHonor_C_01Pant", 
		"INV_Leather_DraenorQuest95_B_01Pant",
		"INV_Leather_PvPDruidGladiator_O_01Pant", 
		"INV_Leather_PvPDruid_O_01Pant", 
		"INV_Leather_RaidDruid_O_01Pant",
		"INV_Leather_RaidMonk_O_01Pant", 
		"INV_Leather_RaidRogueMythic_O_01Pant", 
		"INV_Leather_RaidRogue_O_01Pant",
		"INV_Mail_DraenorQuest90_B_01Pant",
		"INV_Plate_BlackrockClan_B_01Pant", 
		"INV_Plate_DraeneiGuard_C_01Pant", 
		"INV_Plate_DraenorCrafted_D_01Pant", 
		"INV_Plate_DraenorLFR_C_01Pant", 
		"INV_Plate_DraenorQuest90_B_01Pant", 
		"INV_Plate_Plate_PvPWarriorGladaitor_O_01Pants",
		"INV_Plate_Plate_PvPWarrior_O_01Pants", 
		"INV_Plate_RaidDeathKnightMythic_O_01Pant", 
		"INV_Plate_RaidDeathKnight_O_01Pant", 
		"INV_Plate_RaidWarrior_O_01Pants",
  }
	GHM_StockIcons["Potion"] = {
		-- ok
		"INV_Potion_01",
		"INV_Potion_02",
		"INV_Potion_03",
		"INV_Potion_04",
		"INV_Potion_05",
		"INV_Potion_06",
		"INV_Potion_07",
		"INV_Potion_08",
		"INV_Potion_09",
		"INV_Potion_10",
		"INV_Potion_11",
		"INV_Potion_12",
		"INV_Potion_13",
		"INV_Potion_14",
		"INV_Potion_15",
		"INV_Potion_16",
		"INV_Potion_17",
		"INV_Potion_18",
		"INV_Potion_19",
		"INV_Potion_20",
		"INV_Potion_21",
		"INV_Potion_22",
		"INV_Potion_23",
		"INV_Potion_24",
		"INV_Potion_25",
		"INV_Potion_26",
		"INV_Potion_27",
		"INV_Potion_28",
		"INV_Potion_29",
		"INV_Potion_30",
		"INV_Potion_31",
		"INV_Potion_32",
		"INV_Potion_33",
		"INV_Potion_34",
		"INV_Potion_35",
		"INV_Potion_36",
		"INV_Potion_37",
		"INV_Potion_38",
		"INV_Potion_39",
		"INV_Potion_40",
		"INV_Potion_41",
		"INV_Potion_42",
		"INV_Potion_43",
		"INV_Potion_44",
		"INV_Potion_45",
		"INV_Potion_46",
		"INV_Potion_47",
		"INV_Potion_48",
		"INV_Potion_49",
		"INV_Potion_50",
		"INV_Potion_51",
		"INV_Potion_52",
		"INV_Potion_53",
		"INV_Potion_54",
		"INV_Potion_55",
		"INV_Potion_56",
		"INV_Potion_57",
		"INV_Potion_58",
		"INV_Potion_59",
		"INV_Potion_60",
		"INV_Potion_61",
		"INV_Potion_62",
		"INV_Potion_63",
		"INV_Potion_64",
		"INV_Potion_65",
		"INV_Potion_66",
		"INV_Potion_67",
		"INV_Potion_68",
		"INV_Potion_69",
		"INV_Potion_70",
		"INV_Potion_71",
		"INV_Potion_72",
		"INV_Potion_73",
		"INV_Potion_74",
		"INV_Potion_75",
		"INV_Potion_76",
		"INV_Potion_77",
		"INV_Potion_78",
		"INV_Potion_79",
		"INV_Potion_80",
		"INV_Potion_81",
		"INV_Potion_82",
		"INV_Potion_83",
		"INV_Potion_84",
		"INV_Potion_85",
		"INV_Potion_86",
		"INV_Potion_87",
		"INV_Potion_88",
		"INV_Potion_89",
		"INV_Potion_90",
		"INV_Potion_91",
		"INV_Potion_92",
		"INV_Potion_93",
		"INV_Potion_94",
		"INV_Potion_95",
		"INV_Potion_96",
		"INV_Potion_97",
		"INV_Potion_98",
		"INV_Potion_99",
		"INV_Potion_100",
		"INV_Potion_101",
		"INV_Potion_102",
		"INV_Potion_103",
		"INV_Potion_104",
		"INV_Potion_105",
		"INV_Potion_106",
		"INV_Potion_107",
		"INV_Potion_108",
		"INV_Potion_109",
		"INV_Potion_110",
		"INV_Potion_111",
		"INV_Potion_112",
		"INV_Potion_113",
		"INV_Potion_114",
		"INV_Potion_115",
		"INV_Potion_116",
		"INV_Potion_117",
		"INV_Potion_118",
		"INV_Potion_119",
		"INV_Potion_120",
		"INV_Potion_121",
		"INV_Potion_122",
		"INV_Potion_123",
		"INV_Potion_124",
		"INV_Potion_125",
		"INV_Potion_126",
		"INV_Potion_127",
		"INV_Potion_128",
		"INV_Potion_129",
		"INV_Potion_130",
		"INV_Potion_131",
		"INV_Potion_132",
		"INV_Potion_133",
		"INV_Potion_134",
		"INV_Potion_135",
		"INV_Potion_136",
		"INV_Potion_137",
		"INV_Potion_138",
		"INV_Potion_139",
		"INV_Potion_140",
		"INV_Potion_141",
		"INV_Potion_142",
		"INV_Potion_143",
		"INV_Potion_144",
		"INV_Potion_145",
		"INV_Potion_146",
		"INV_Potion_147",
		"INV_Potion_148",
		"INV_Potion_149",
		"INV_Potion_150",
		"INV_Potion_151",
		"INV_Potion_152",
		"INV_Potion_153",
		"INV_Potion_154",
		"INV_Potion_155",
		"INV_Potion_156",
		"INV_Potion_157",
		"INV_Potion_158",
		"INV_Potion_159",
		"INV_Potion_160",
		"INV_Potion_161",
		"INV_Potion_162",
		"INV_Potion_163",
		"INV_Potion_164",
		"INV_Potion_165",
		"INV_Potion_166",
		"INV_Potion_167",
		"INV_Potion_168",
		"INV_1H_Auchindoun_01",
		"INV_1H_HaremMatron_D_01",
		"INV_2H_Auchindoun_01",
		"INV_Alchemy_CrystalVial",
		"INV_Alchemy_Elixir_01",
		"INV_Alchemy_Elixir_02",
		"INV_Alchemy_Elixir_03",
		"INV_Alchemy_Elixir_04",
		"INV_Alchemy_Elixir_05",
		"INV_Alchemy_Elixir_06",
		"INV_Alchemy_Elixir_Empty",
		"INV_Alchemy_EnchantedVial",
		"INV_Alchemy_EndlessFlask_01",
		"INV_Alchemy_EndlessFlask_02",
		"INV_Alchemy_EndlessFlask_03",
		"INV_Alchemy_EndlessFlask_04",
		"INV_Alchemy_EndlessFlask_05",
		"INV_Alchemy_EndlessFlask_06",
		"INV_Alchemy_ImbuedVial",
		"INV_Alchemy_LeadedVial",
		"INV_Alchemy_Potion_01",
		"INV_Alchemy_Potion_02",
		"INV_Alchemy_Potion_03",
		"INV_Alchemy_Potion_04",
		"INV_Alchemy_Potion_05",
		"INV_Alchemy_Potion_06",
		"INV_Alchemy_Potion_Empty",
		"INV_ValentineCologneBottle",
		"INV_ValentinePerfumeBottle",
		"INV_Misc_Cauldron_Arcane",
		"INV_Misc_Cauldron_Fire",
		"INV_Misc_Cauldron_Frost",
		"INV_Misc_Cauldron_Nature",
		"INV_Misc_Cauldron_Shadow",

		"inv_misc_endlesspotion",
		"inv_misc_fieryspices",
		"inv_misc_flaskofvolatility",
		"inv_misc_potionseta",
		"inv_misc_potionsetb",
		"inv_misc_potionsetc",
		"inv_misc_potionsetd",
		"inv_misc_potionsete",
		"inv_misc_potionsetf",
		"inv_misc_stoneoil",
		"inv_misc_potiona2",
		"inv_misc_potiona3",
		"inv_misc_potiona4",
		"inv_misc_potiona5",
		"inv_misc_potiona6",
		"inv_potionc_1",
		"inv_potionc_2",
		"inv_potionc_3",
		"inv_potionc_4",
		"inv_potionc_5",
		"inv_potionc_6",
		"inv_potiond_1",
		"inv_potiond_2",
		"inv_potiond_3",
		"inv_potiond_4",
		"inv_potiond_5",
		"inv_potiond_6",
		"inv_potione_1",
		"inv_potione_2",
		"inv_potione_3",
		"inv_potione_4",
		"inv_potione_5",
		"inv_potione_6",
		"inv_potionf_1",
		"inv_potionf_2",
		"inv_potionf_3",
		"inv_potionf_4",
		"inv_potionf_5",
		"inv_potionf_6",
		"Trade_Alchemy_FoldedGhostIron", 
		"Trade_Alchemy_GhostIronRod", 
		"Trade_Alchemy_GhostIronRodRuned", 
		"Trade_Alchemy_PotionB1", 
		"Trade_Alchemy_PotionB2", 
		"Trade_Alchemy_PotionB3", 
		"Trade_Alchemy_PotionB4", 
		"Trade_Alchemy_PotionB5", 
		"Trade_Alchemy_PotionB6", 
		"Trade_Alchemy_PotionC1", 
		"Trade_Alchemy_PotionC2", 
		"Trade_Alchemy_PotionC3", 
		"Trade_Alchemy_PotionC4", 
		"Trade_Alchemy_PotionC5", 
		"Trade_Alchemy_PotionC6", 
		"Trade_Alchemy_PotionD1", 
		"Trade_Alchemy_PotionD2", 
		"Trade_Alchemy_PotionD3", 
		"Trade_Alchemy_PotionD4", 
		"Trade_Alchemy_PotionD5", 
		"Trade_Alchemy_PotionD6", 
		"Trade_Alchemy_PotionE1", 
		"Trade_Alchemy_PotionE2", 
		"Trade_Alchemy_PotionE3", 
		"Trade_Alchemy_PotionE4", 
		"Trade_Alchemy_PotionE5", 
		"Trade_Alchemy_PotionE6", 
		"INV_Trade_Alchemy_DPotion_C1A", 
		"INV_Trade_Alchemy_DPotion_C2A", 
		 "Trade_Alchemy_DPotion_A11", 
		"Trade_Alchemy_DPotion_A12", 
		"Trade_Alchemy_DPotion_A13", 
		"Trade_Alchemy_DPotion_A14", 
		"Trade_Alchemy_DPotion_A15", 
		"Trade_Alchemy_DPotion_A16", 
		"Trade_Alchemy_DPotion_A17", 
		"Trade_Alchemy_DPotion_A21", 
		"Trade_Alchemy_DPotion_A22", 
		"Trade_Alchemy_DPotion_A23", 
		"Trade_Alchemy_DPotion_A24", 
		"Trade_Alchemy_DPotion_A25", 
		"Trade_Alchemy_DPotion_A26", 
		"Trade_Alchemy_DPotion_A27", 
		"Trade_Alchemy_DPotion_A28", 
		"Trade_Alchemy_DPotion_B10", 
		"Trade_Alchemy_DPotion_B20", 
		"Trade_Alchemy_DPotion_B21", 
		"Trade_Alchemy_DPotion_C11", 
		"Trade_Alchemy_DPotion_C12", 
		"Trade_Alchemy_DPotion_C13", 
		"Trade_Alchemy_DPotion_C14", 
		"Trade_Alchemy_DPotion_C15", 
		"Trade_Alchemy_DPotion_C16", 
		"Trade_Alchemy_DPotion_C17", 
		"Trade_Alchemy_DPotion_C18", 
		"Trade_Alchemy_DPotion_C19", 
		"Trade_Alchemy_DPotion_C21", 
		"Trade_Alchemy_DPotion_C22", 
		"Trade_Alchemy_DPotion_C23", 
		"Trade_Alchemy_DPotion_C24", 
		"Trade_Alchemy_DPotion_C25", 
		"Trade_Alchemy_DPotion_C26", 
		"Trade_Alchemy_DPotion_C27", 
		"Trade_Alchemy_DPotion_C28", 
		"Trade_Alchemy_DPotion_C29", 
		"Trade_Alchemy_DPotion_D11", 
		"Trade_Alchemy_DPotion_D12", 
		"Trade_Alchemy_DPotion_D13", 
		"Trade_Alchemy_DPotion_D14", 
		"Trade_Alchemy_DPotion_E1", 
		"Trade_Alchemy_DPotion_E2", 
		"inv_misc_potionbag_special", 
		"INV_Misc_Potion_Special",
		"INV_BLACKSMITHDYE_BLACK", 
		"INV_BLACKSMITHDYE_GOLD", 
		"INV_BLACKSMITHDYE_GRAY", 
		"INV_BLACKSMITHDYE_GREEN", 
		"INV_BLACKSMITHDYE_RED", 
		"INV_BLACKSMITH_ANVIL", 
		"INV_cloakdye_blue", 
		"INV_cloakdye_purple", 
		"INV_cloakdye_red", 
		"INV_LEATHERWORKDYE_BLUE", 
		"INV_LEATHERWORKDYE_GREEN", 
		"INV_LEATHERWORKDYE_MAIL_BLUE", 
		"INV_LEATHERWORKDYE_MAIL_GREEN", 
		"INV_LEATHERWORKDYE_MAIL_ORANGE", 
		"INV_LEATHERWORKDYE_MAIL_PURPLE", 
		"INV_LEATHERWORKDYE_MAIL_RED", 
		"INV_LEATHERWORKDYE_ORANGE", 
		"INV_LEATHERWORKDYE_PURPLE", 
		"INV_LEATHERWORKDYE_RED",
		"INV_tailoringdye_blue", 
		"INV_tailoringdye_green", 
		"INV_tailoringdye_orange", 
		"INV_tailoringdye_purple", 
		"INV_tailoringdye_red",
  		
	}
	GHM_StockIcons["Shield"] = {
		-- ok
		"INV_Shield_01",
		"INV_Shield_02",
		"INV_Shield_03",
		"INV_Shield_04",
		"INV_Shield_05",
		"INV_Shield_06",
		"INV_Shield_07",
		"INV_Shield_08",
		"INV_Shield_09",
		"INV_Shield_10",
		"INV_Shield_11",
		"INV_Shield_12",
		"INV_Shield_13",
		"INV_Shield_14",
		"INV_Shield_15",
		"INV_Shield_16",
		"INV_Shield_17",
		"INV_Shield_18",
		"INV_Shield_19",
		"INV_Shield_20",
		"INV_Shield_21",
		"INV_Shield_22",
		"INV_Shield_23",
		"INV_Shield_24",
		"INV_Shield_26",
		"INV_Shield_27",
		"INV_Shield_28",
		"INV_Shield_29",
		"INV_Shield_30",
		"INV_Shield_31",
		"INV_Shield_32",
		"INV_Shield_33",
		"INV_Shield_34",
		"INV_Shield_35",
		"INV_Shield_36",
		"INV_Shield_37",
		"INV_Shield_38",
		"INV_Shield_39",
		"INV_Shield_40",
		"INV_Shield_41",
		"INV_Armor_Shield_Naxxramas_D_01",
		"INV_Armor_Shield_Naxxramas_D_02",
		"INV_Shield_42",
		"INV_Shield_43",
		"INV_Shield_44",
		"INV_Shield_45",
		"INV_Shield_46",
		"INV_Shield_47",
		"INV_Shield_48",
		"INV_Shield_49",
		"INV_Shield_50",
		"INV_Shield_51",
		"INV_Shield_52",
		"INV_Shield_53",
		"INV_Shield_54",
		"INV_Shield_55",
		"INV_Shield_56",
		"INV_Shield_57",
		"INV_Shield_58",
		"INV_Shield_59",
		"INV_Shield_60",
		"INV_Shield_61",
		"INV_Shield_63",
		"INV_Shield_64", -- [606]
		"INV_Shield_65", -- [607]
		"INV_Shield_66", -- [608]
		"INV_Shield_67", -- [609]
		"INV_Shield_68", -- [610]
		"INV_Shield_69", -- [611]
		"INV_Shield_70", -- [612]
		"INV_Shield_71", -- [613]
		"INV_Shield_72", -- [614]
		"INV_Shield_73", -- [615]
		"INV_Shield_74", -- [616]
		"INV_Shield_75", -- [617]
		"INV_Shield_64", -- [824]
		"INV_Shield_65", -- [825]
		"INV_Shield_66", -- [826]
		"INV_Shield_67", -- [827]
		"INV_Shield_68", -- [828]
		"INV_Shield_69", -- [829]
		"INV_Shield_70", -- [830]
		"INV_Shield_71", -- [831]
		"INV_Shield_72", -- [832]
		"INV_Shield_73", -- [833]
		"INV_Shield_74", -- [834]
		"INV_Shield_75", -- [835]

		"inv_shield_cataclysm_c_01",
		"INV_Shield_430Future_C_01",
		"INV_Shield_430OldGod_C_01",
		"INV_Shield_DeathwingRaid_D_01",
		"INV_Shield_DeathwingRaid_D_02",
		"INV_Shield_PVPCataclysmS3_C_02",
		 "INV_Shield_PandaRaid_D_01", 
		"INV_Shield_PandaRaid_D_02", 
		"INV_Shield_PandariaQuest_B_01", 
		"INV_Shield_PandariaQuest_B_02", 
		"INV_Shield_PandariaQuest_B_03", 
		"INV_Shield_PandariaTradeskill_C_01", 
		"INV_Shield_PandariaTradeskill_C_02", 
		"INV_Shield_PanDung_C_01", 
		"INV_Shield_PanDung_C_02", 
		"INV_Shield_PanProg_B_01", 
		"INV_Shield_PanProg_B_02", 
		"INV_Shield_PanStart_A_01", 
		"INV_Shield_PVPPandariaS1_C_01",
		"INV_Shield_PVPPandariaS1_C_02", 
		"INV_Legendary_Shield", 
		"INV_Shield_Mogu_C_01", 
		"INV_Shield_PVPPandariaS2_C_01", 
		"INV_Shield_PVPPandariaS2_C_02", 
		"INV_Shield_ThunderIsleRaid_D_01", 
		"INV_Shield_ThunderIsleRaid_D_02", 
		"INV_Shield_Zandalari_C_01", 
		"INV_Shield_Zandalari_C_02", 
		"INV_Shield_OrgrimmarRaid_D_01", 
		"INV_Shield_OrgrimmarRaid_D_02", 
		"INV_Shield_OrgrimmarRaid_D_05", 
		"INV_Shield_PVPHorde_A_01_UpRes", 
		"INV_Shield_PVPPandariaS3_C_01", 
		"INV_Shield_PVPPandariaS3_C_02", 
		"INV_Shield_Draenei_A_02_uprez", 
		"INV_Shield_DraenorChallenge_D_01", 
		"INV_Shield_DraenorChallenge_D_02", 
		"INV_Shield_DraenorCrafted_D_01_A_Alliance", 
		"INV_Shield_DraenorCrafted_D_01_A_horde", 
		"INV_Shield_DraenorCrafted_D_01_B_Alliance", 
		"INV_Shield_DraenorCrafted_D_01_B_horde", 
		"INV_Shield_DraenorCrafted_D_01_C_Alliance", 
		"INV_Shield_DraenorCrafted_D_01_C_horde", 
		"INV_Shield_DraenorDungeon_C_01", 
		"INV_Shield_DraenorDungeon_C_02", 
		"INV_Shield_DraenorDungeon_C_03", 
		"INV_Shield_DraenorGuard_B_01_A_alliance", 
		"INV_Shield_DraenorGuard_B_01_A_horde", 
		"INV_Shield_DraenorGuard_B_02_Alliance", 
		"INV_Shield_DraenorGuard_B_02_Horde", 
		"INV_Shield_DraenorHonor_C_01", 
		"INV_Shield_DraenorHonor_C_02", 
		"INV_Shield_DraenorQuest95_B_01", 
		"INV_Shield_DraenorQuest95_B_02", 
		"INV_Shield_DraenorQuest_B_01", 
		"INV_Shield_DraenorQuest_B_02", 
		"INV_Shield_DraenorRaid_D_01", 
		"INV_Shield_DraenorRaid_D_02", 
		"INV_Shield_DraenorRaid_D_03", 
		"INV_Shield_DraenorRaid_D_04", 
		"INV_shield_garrison_a_01", 
		"INV_shield_garrison_a_02", 
		"INV_Shield_IronHorde_D_01", 
		"INV_Shield_PVPDraenorS1_D_01", 
		"INV_Shield_PVPDraenorS1_D_02", 
		"INV_Shield_TimeWalker_B_01", 
		"INV_Shield_WarsongClan_B_01", 
		"INV_Shield_WarsongClan_C_01", 
		"Shield_DraenorCrafted_D_02_A_Alliance", 
		"Shield_DraenorCrafted_D_02_A_Horde", 
		"Shield_DraenorCrafted_D_02_B_Alliance", 
		"Shield_DraenorCrafted_D_02_B_Horde", 
		"Shield_DraenorCrafted_D_02_C_Alliance", 
		"Shield_DraenorCrafted_D_02_C_Horde", 


	}
	GHM_StockIcons["Shirt"] = {
		-- ok
		"INV_Shirt_01",
		"INV_Shirt_02",
		"INV_Shirt_03",
		"INV_Shirt_04",
		"INV_Shirt_05",
		"INV_Shirt_06",
		"INV_Shirt_07",
		"INV_Shirt_08",
		"INV_Shirt_09",
		"INV_Shirt_10",
		"INV_Shirt_11",
		"INV_Shirt_12",
		"INV_Shirt_13",
		"INV_Shirt_14",
		"INV_Shirt_15",
		"INV_Shirt_16",
		"INV_Shirt_17",
		"INV_Shirt_Black_01",
		"INV_Shirt_Blue_01",
		"INV_Shirt_Green_01",
		"INV_Shirt_Grey_01",
		"INV_Shirt_GuildTabard_01",
		"INV_Shirt_Orange_01",
		"INV_Shirt_Purple_01",
		"INV_Shirt_Red_01",
		"INV_Shirt_White_01",
		"INV_Shirt_Yellow_01"
	}
	GHM_StockIcons["Shoulder"] = {
		-- ok
		"INV_Shoulder_01",
		"INV_Shoulder_02",
		"INV_Shoulder_03",
		"INV_Shoulder_04",
		"INV_Shoulder_05",
		"INV_Shoulder_06",
		"INV_Shoulder_07",
		"INV_Shoulder_08",
		"INV_Shoulder_09",
		"INV_Shoulder_10",
		"INV_Shoulder_11",
		"INV_Shoulder_12",
		"INV_Shoulder_13",
		"INV_Shoulder_14",
		"INV_Shoulder_15",
		"INV_Shoulder_16",
		"INV_Shoulder_17",
		"INV_Shoulder_18",
		"INV_Shoulder_19",
		"INV_Shoulder_20",
		"INV_Shoulder_21",
		"INV_Shoulder_22",
		"INV_Shoulder_23",
		"INV_Shoulder_24",
		"INV_Shoulder_25",
		"INV_Shoulder_26",
		"INV_Shoulder_27",
		"INV_Shoulder_28",
		"INV_Shoulder_29",
		"INV_Shoulder_30",
		"INV_Shoulder_31",
		"INV_Shoulder_32",
		"INV_Shoulder_33",
		"INV_Shoulder_34",
		"INV_Shoulder_35",
		"INV_Shoulder_36",
		"INV_Shoulder_37",
		"INV_Shoulder_40",
		"INV_Shoulder_41",
		"INV_Shoulder_44",
		"INV_Shoulder_47",
		"INV_Shoulder_48",
		"INV_Shoulder_49",
		"INV_Shoulder_50",
		"INV_Shoulder_51",
		"INV_Shoulder_52",
		"INV_Shoulder_53",
		"INV_Shoulder_54",
		"INV_Shoulder_55",
		"INV_Shoulder_56",
		"INV_Shoulder_57",
		"INV_Shoulder_58",
		"INV_Shoulder_59",
		"INV_Shoulder_60",
		"INV_Shoulder_61",
		"INV_Shoulder_62",
		"INV_Shoulder_63",
		"INV_Shoulder_64",
		"INV_Shoulder_65",
		"INV_Shoulder_66",
		"INV_Shoulder_67",
		"INV_Shoulder_68",
		"INV_Shoulder_HaremMatron_D_01",
		"INV_SHOULDER_58",
		"INV_SHOULDER_59",
		"INV_SHOULDER_60",
		"INV_SHOULDER_61",
		"INV_SHOULDER_62",
		"INV_SHOULDER_67",
		"INV_SHOULDER_68",
		"INV_Shoulder_69",
		"INV_Shoulder_70",
		"INV_Shoulder_71",
		"INV_Shoulder_72",
		"INV_Shoulder_73",
		"INV_Shoulder_74",
		"INV_Shoulder_75",
		"INV_Shoulder_76",
		"INV_Shoulder_77",
		"INV_Shoulder_78",
		"INV_Shoulder_79",
		"INV_Shoulder_80",
		"INV_Shoulder_81",
		"INV_Shoulder_82",
		"INV_Shoulder_83",
		"INV_Shoulder_84",
		"INV_Shoulder_85",
		"INV_Shoulder_86",
		"INV_Shoulder_87",
		"INV_Shoulder_88",
		"INV_SHOULDER_89",
		"INV_Shoulder_90",
		"INV_Shoulder_91",
		"INV_Shoulder_92",
		"INV_Shoulder_93",
		"INV_Shoulder_94",
		"INV_Shoulder_95",
		"INV_Shoulder_96",
		"INV_Shoulder_97",
		"INV_Shoulder_98",
		"INV_Shoulder_99",
		"INV_Shoulder_100",
		"INV_Shoulder_101",
		"INV_Shoulder_102",
		"INV_Shoulder_103",
		"INV_Shoulder_104",
		"INV_Shoulder_105",
		"INV_Misc_Desecrated_ClothShoulder",
		"INV_Misc_Desecrated_LeatherShoulder",
		"INV_Misc_Desecrated_MailShoulder",
		"INV_Misc_Desecrated_PlateShoulder",

		"Plate_RaidDeathKnight_K_01_Shoulder",
		"INV_Shoulder_106", -- [618]
		"INV_Shoulder_107", -- [619]
		"INV_Shoulder_108A", -- [620]
		"INV_Shoulder_108B", -- [621]
		"INV_Shoulder_109A", -- [622]
		"INV_Shoulder_109B", -- [623]
		"INV_Shoulder_110", -- [624]
		"INV_Shoulder_111", -- [625]
		"INV_Shoulder_112", -- [626]
		"INV_Shoulder_113", -- [627]
		"INV_Shoulder_114", -- [628]
		"INV_Shoulder_115", -- [629]
		"INV_Shoulder_116", -- [630]
		"INV_Shoulder_116Black", -- [631]
		"INV_Shoulder_116Green", -- [632]
		"INV_Shoulder_116Purple", -- [633]
		"INV_Shoulder_117", -- [634]
		"INV_Shoulder_118", -- [635]
		"INV_Shoulder_119", -- [636]
		"INV_Shoulder_120", -- [637]
		"INV_Shoulder_121", -- [638]
		"INV_Shoulder_129", -- [639]
		"INV_Shoulder_130", -- [640]
		"INV_Shoulder_133", -- [641]
		"INV_Shoulder_106", -- [836]
		"INV_Shoulder_107", -- [837]
		"INV_Shoulder_108A", -- [838]
		"INV_Shoulder_108B", -- [839]
		"INV_Shoulder_109A", -- [840]
		"INV_Shoulder_109B", -- [841]
		"INV_Shoulder_110", -- [842]
		"INV_Shoulder_111", -- [843]
		"INV_Shoulder_112", -- [844]
		"INV_Shoulder_113", -- [845]
		"INV_Shoulder_114", -- [846]
		"INV_Shoulder_115", -- [847]
		"INV_Shoulder_116", -- [848]
		"INV_Shoulder_116Black", -- [849]
		"INV_Shoulder_116Green", -- [850]
		"INV_Shoulder_116Purple", -- [851]
		"INV_Shoulder_117", -- [852]
		"INV_Shoulder_118", -- [853]
		"INV_Shoulder_119", -- [854]
		"INV_Shoulder_120", -- [855]
		"INV_Shoulder_121", -- [856]
		"INV_Shoulder_129", -- [857]
		"INV_Shoulder_130", -- [858]
		"INV_Shoulder_133", -- [859]


		"inv_shoulder_cloth_pvpmage_c_01",
		"inv_shoulder_leather_cataclysm_b_01",
		"inv_shoulder_plate_dungeonplate_c_03",
		"inv_shoulder_149",
		"inv_shoulder_150",
		"inv_shoulder_151",
		"inv_shoulder_152",
		"inv_shoulder_153",
		"inv_shoulder_135v1",
		"inv_shoulder_135v2",
		"inv_shoulder_135v3",
		"inv_shoulder_136v1",
		"inv_shoulder_136v2",
		"inv_shoulder_136v3",
		"inv_shoulder_137v1",
		"inv_shoulder_137v2",
		"inv_shoulder_137v3",
		"inv_shoulder_138v1",
		"inv_shoulder_138v2",
		"inv_shoulder_138v3",
		"inv_shoulder_139v1",
		"inv_shoulder_139v2",
		"inv_shoulder_139v3",
		"inv_shoulder_140v1",
		"inv_shoulder_140v2",
		"inv_shoulder_140v3",
		"inv_shoulder_142v1",
		"inv_shoulder_142v2",
		"inv_shoulder_142v3",
		"inv_shoulder_143v1",
		"inv_shoulder_143v2",
		"inv_shoulder_143v3",
		"inv_shoulder_144v1",
		"inv_shoulder_144v2",
		"inv_shoulder_144v3",
		"inv_shoulder_146v4",
		"inv_shoulder_146v3",
		"inv_shoulder_146v2",
		"inv_shoulder_141v4",
		"inv_shoulder_141v3",
		"inv_shoulder_141v2",
		"inv_shoulder_134v4",
		"inv_shoulder_134v3",
		"inv_shoulder_134v2",
		"inv_shoulder_145v1",
		"inv_shoulder_145v2",
		"inv_shoulder_145v3",
		"inv_shoulder_147v1",
		"inv_shoulder_147v2",
		"inv_shoulder_147v3",
		"inv_shoulder_148v1",
		"inv_shoulder_148v2",
		"inv_shoulder_148v3",
		"inv_shoulder_leather_pvpdruid_c_01",
		"inv_shoulder_mail_dungeonmail_c_04",
		"inv_shoulder_robe_common_c_01v1",
		"inv_shoulder_robe_common_c_01v2",
		"inv_shoulder_robe_common_c_01v3",
		"inv_shoulder_leather_cataclysm_b_02",
		"inv_shoulder_leather_raiddruid_i_01",
		"inv_shoulder_leatherraidrogue_i_01",
		"inv_shoulder_cloth_cataclysm_b_01",
		"inv_shoulder_cloth_raidwarlock_i_01",
		"inv_shoulder_plate_cataclysm_b_02",
		"inv_shoulder_plate_pvppaladin_c_01",
		"inv_shoulder_plate_pvpwarrior_c_02",
		"inv_shoulder_plate_raidwarrior_i_01",
		"inv_shoulder_robe_dungeonrobe_c_03",
		"inv_shoulder_robe_dungeonrobe_c_04",
		"inv_shoulder_robe_pvppriest_c_01",
		"inv_shoulder_robe_common_c_01",
		"inv_shoulder_mail_pvphunter_c_01",
		"inv_shoulder_mail_dungeonmail_c_03",
		"INV_Shoulder_Leather_DungeonLeather_C_05",
		"INV_Shoulder_Leather_PVPRogue_D_01",
		"INV_Shoulder_Leather_RaidDruid_K_01",
		"INV_Shoulder_Leather_RaidRogue_K_01",
		"INV_Shoulder_Mail_DungeonMail_C_05",
		"INV_Shoulder_Mail_PVPHunter_D_01",
		"INV_Shoulder_Mail_PVPShaman_D_01",
		"INV_Shoulder_Mail_RaidHunter_K_01",
		"INV_Shoulder_Mail_RaidShaman_K_01",
		"INV_Shoulder_Plate_DungeonPlate_C_05",
		"INV_Shoulder_Plate_DungeonPlate_C_06",
		"INV_Shoulder_Plate_PVPDeathKnight_D_01",
		"INV_Shoulder_Plate_PVPPaladin_D_01",
		"INV_Shoulder_Plate_PVPWarrior_D_01",
		"INV_Shoulder_Plate_RaidPaladin_K_01",
		"INV_Shoulder_Plate_RaidWarrior_K_01",
		"INV_Shoulder_Robe_DungeonRobe_C_05",
		"INV_Shoulder_Robe_PVPMage_D_01",
		"INV_Shoulder_Robe_PVPPriest_D_01",
		"INV_Shoulder_Robe_PVPWarlock_D_01",
		"INV_Shoulder_Robe_RaidMage_K_01",
		"INV_Shoulder_Robe_RaidPriest_K_01",
		"INV_Shoulder_Robe_RaidWarlock_K_01",
		"INV_Shoulders_Leather_PVPDruid_D_01",
		 "INV_Shoulders_Plate_RaidWarrior_L_01", 
		"INV_Shoulder_ChallengeDruid_D_01", 
		"INV_Shoulder_Cloth_ChallengeMage_D_01", 
		"INV_Shoulder_Cloth_ChallengePriest_D_01", 
		"INV_Shoulder_Cloth_DungeonCloth_C_06", 
		"INV_Shoulder_Cloth_Panda_B_01", 
		"INV_Shoulder_Cloth_Panda_B_01_Green", 
		"INV_Shoulder_Cloth_Panda_B_01_Red", 
		"INV_Shoulder_Cloth_Panda_B_02", 
		"INV_Shoulder_Cloth_Panda_B_02_Blue", 
		"INV_Shoulder_Cloth_Panda_B_02_White", 
		"INV_Shoulder_Cloth_RaidPriest_L_01", 
		"INV_Shoulder_Cloth_RaidWarlock_L_01", 
		"INV_Shoulder_Cloth_Reputation_C_01", 
		"INV_Shoulder_Leather_ChallengeMonk_D_01", 
		"INV_Shoulder_Leather_ChallengeRogue_D_01", 
		"INV_Shoulder_Leather_DungeonLeather_C_06", 
		"INV_Shoulder_Leather_Panda_B_01", 
		"INV_Shoulder_Leather_Panda_B_01Dark", 
		"INV_Shoulder_Leather_Panda_B_01Light", 
		"INV_Shoulder_Leather_Panda_B_01Red", 
		"INV_Shoulder_Leather_Panda_B_02", 
		"INV_Shoulder_Leather_Panda_B_02_Brown", 
		"INV_Shoulder_Leather_Panda_B_02_Crimson", 
		"INV_Shoulder_Leather_Panda_B_02_Indigo", 
		"INV_Shoulder_Leather_PVPDruid_E_01", 
		"INV_Shoulder_Leather_PVPMonk_E_01", 
		"INV_Shoulder_Leather_PVPRogue_E_01", 
		"INV_Shoulder_Leather_RaidDruid_L_01", 
		"INV_Shoulder_Leather_RaidMonk_L_01", 
		"INV_Shoulder_Leather_RaidRogue_L_01", 
		"INV_Shoulder_Leather_Reputation_C_01", 
		"INV_Shoulder_Mail_ChallengeHunter_D_01", 
		"INV_Shoulder_Mail_ChallengeShaman_D_01", 
		"INV_Shoulder_Mail_DungeonMail_C_06", 
		"INV_Shoulder_Mail_Panda_B_01", 
		"INV_Shoulder_Mail_Panda_B_01Green", 
		"INV_Shoulder_Mail_Panda_B_01White", 
		"INV_Shoulder_Mail_Panda_B_02", 
		"INV_Shoulder_Mail_PVPHunter_E_01", 
		"INV_Shoulder_Mail_PVPShaman_E_01", 
		"INV_Shoulder_Mail_RaidHunter_L_01", 
		"INV_Shoulder_Mail_RaidShaman_L_01", 
		"INV_Shoulder_Mail_Reputation_C_01", 
		"INV_Shoulder_Plate_ChallengeDeathKnight_D_01", 
		"INV_Shoulder_Plate_ChallengePaladin_D_01", 
		"INV_Shoulder_Plate_ChallengeWarrior_D_01", 
		"INV_Shoulder_Plate_DungeonPlate_C_07", 
		"INV_Shoulder_Plate_PandaGuard_A_01", 
		"INV_Shoulder_Plate_PandaGuard_B_01", 
		"INV_Shoulder_Plate_Panda_B_01", 
		"INV_Shoulder_Plate_Panda_B_01Blue", 
		"INV_Shoulder_Plate_Panda_B_01Gold", 
		"INV_Shoulder_Plate_Panda_B_02", 
		"INV_Shoulder_Plate_Panda_B_02Green", 
		"INV_Shoulder_Plate_Panda_B_02Purple", 
		"INV_Shoulder_Plate_Panda_B_02Yellow", 
		"INV_Shoulder_Plate_PVPDeathKnight_E_01", 
		"INV_Shoulder_Plate_PVPPaladin_E_01", 
		"INV_Shoulder_Plate_PVPWarrior_E_01", 
		"INV_Shoulder_Plate_RaidDeathKnight_L_01", 
		"INV_Shoulder_Plate_RaidPaladin_L_01", 
		"INV_Shoulder_Plate_Reputation_C_01", 
		"INV_Shoulder_PVPPriest_E_01", 
		"INV_Shoulder_PVPWarlock_E_01", 
		"INV_Shoulder_RaidMage_L_01", 
		"INV_Shoulder_Robe_PVPMage_E_01", 
		"INV_Cloth_RaidPriest_M_01Shoulder", 
	

	
		"INV_Cloth_PVPWarlock_F_01Shoulder", 
		"INV_Shoulders_Leather_PVPRogue_F_01", 
		"INV_Shoulders_Plate_PVPDeathKnight_F_01", 
		"INV_Shoulders_Plate_PVPWarrior_F_01", 
		"INV_Shoulder_Cloth_PVPMage_F_01", 
		"INV_Shoulder_Cloth_PVPPriest_F_01", 
		"INV_Shoulder_Cloth_RaidMage_M_01", 
		"INV_Shoulder_Cloth_RaidWarlock_M_01", 
		"INV_Shoulder_Leather_PVPMonk_F_01", 
		"INV_Shoulder_Leather_RaidDruid_M_01", 
		"INV_Shoulder_Leather_RaidMonk_M_01", 
		"INV_Shoulder_Leather_RaidRogue_M_01", 
		"INV_Shoulder_Mail_PVPHunter_F_01", 
		"INV_Shoulder_Mail_PVPShaman_F_01", 
		"INV_Shoulder_Mail_RaidHunter_M_01", 
		"INV_Shoulder_Mail_RaidShaman_M_01", 
		"INV_Shoulder_Plate_DeathKnight_M_01", 
		"INV_Shoulder_Plate_PVPPaladin_F_01Bronze", 
		"INV_Shoulder_Plate_PVPPaladin_F_01Red", 
		"INV_Shoulder_Plate_PVPPaladin_F_01White", 
		"INV_Shoulder_Plate_RaidPaladin_M_01", 
		"INV_Shoulder_Plate_RaidWarrior_M_01",
		"INV_Cloth_PVPWarlock_G_01Shoulder", 
		"INV_Cloth_RaidPriest_N_01Shoulder", 
		"INV_Leather_RaidDruid_N_01Shoulder",
		"INV_Plate_PVPDeathKnight_G_01_SHOULDER", 
		"INV_Mail_RaidShaman_N_01Shoulder", 
		"INV_Plate_PVPWarrior_G_01Shoulder", 
		"INV_Shoulder_Cloth_PVPMage_G_01", 
		"INV_Shoulder_Cloth_PVPPriest_G_01", 
		"INV_Shoulder_Cloth_RaidMage_N_01", 
		"INV_Shoulder_Cloth_RaidWarlock_N_01", 
		"INV_Shoulder_Leather_PVPDruid_G_01", 
		"INV_Shoulder_Leather_PVPMonk_G_01", 
		"INV_Shoulder_Leather_PVPRogue_G_01", 
		"INV_Shoulder_Leather_RaidMonk_N_01", 
		"INV_Shoulder_Leather_RaidRogue_N_01", 
		"INV_Shoulder_Mail_KorKronShaman_D_01", 
		"INV_Shoulder_Mail_PVPHunter_G_01", 
		"INV_Shoulder_Mail_PVPShaman_G_01", 
		"INV_Shoulder_Mail_RaidHunter_N_01", 
		"INV_Shoulder_Plate_Garrosh_D_01", 
		"INV_Shoulder_Plate_PVPPaladin_G_01", 
		"INV_Shoulder_Plate_RaidDeathKnight_N_01", 
		"INV_Shoulder_Plate_RaidPaladin_N_01", 
		"Inv_Shoulder_Plate_RaidWarrior_N_01", 
		"INV_Shoulder_Cloth_Draenei_C_01", 
		"INV_Shoulder_Cloth_DraenorHonor_C_01", 
		"INV_Shoulder_Cloth_DraenorLFR_C_01", 
		"INV_Shoulder_Cloth_DraenorQuest90_B_01", 
		"INV_Shoulder_Cloth_PVPMageGladiator_O_01", 
		"INV_Shoulder_Cloth_PVPMage_O_01", 
		"INV_Shoulder_Cloth_PVPPriestGladiator_O_01", 
		"INV_Shoulder_Cloth_PVPPriest_O_01", 
		"INV_Shoulder_Cloth_PVPWarlock_O_01", 
		"INV_Shoulder_Cloth_RaidMageMythic_O_01", 
		"INV_Shoulder_Cloth_RaidMage_O_01", 
		"INV_Shoulder_Cloth_RaidPriestMythic_O_01", 
		"INV_Shoulder_Cloth_RaidPriest_O_01", 
		"INV_Shoulder_Cloth_ShadowmoonClan_B_01", 
		"INV_Shoulder_Leather_DraenorCrafted_D_01_Alliance", 
		"INV_Shoulder_Leather_DraenorCrafted_D_01_Horde", 
		"INV_Shoulder_Leather_DraenorLFR_C_01", 
		"INV_Shoulder_Leather_DraenorQuest90_B_01", 
		"INV_Shoulder_Leather_PvPMonkGladiator_O_01", 
		"INV_Shoulder_Leather_PvPMonk_O_01", 
		"INV_Shoulder_Leather_PvPRogueGladiator_O_01", 
		"INV_Shoulder_Leather_PVPRogue_O_01", 
		"INV_shoulder_Mail_DraenorCrafted_D_01_alliance", 
		"INV_shoulder_Mail_DraenorCrafted_D_01_Horde", 
		"INV_Shoulder_Mail_DraenorDungeon_C_01", 
		"INV_shoulder_Mail_DraenorHonor_C_01", 
		"INV_shoulder_Mail_DraenorLFR_C_01", 
		"INV_Shoulder_Mail_DraenorQuest95_B_01", 
		"INV_Shoulder_Mail_PvPHunterGladiator_O_01", 
		"INV_SHOULDER_Mail_PVPHunter_O_01", 
		"INV_Shoulder_Mail_PvPShamanGladiator_O_01", 
		"INV_shoulder_Mail_PVPShaman_O_01", 
		"INV_shoulder_Mail_RaidHunterMythic_O_01", 
		"INV_shoulder_Mail_RaidHunter_O_01", 
		"INV_shoulder_Mail_RaidShamanMythic_O_01", 
		"INV_Shoulder_Mail_RaidShaman_O_01", 
		"INV_Shoulder_Mail_WarsongClan_B_01", 
		"INV_shoulder_plate_draenordungeon_c_01", 
		"INV_Shoulder_Plate_DraenorHonor_C_01", 
		"INV_Shoulder_Plate_DraenorQuest95_B_01", 
		"INV_Shoulder_Plate_PvPDeathKnightGladiator_O_01", 
		"INV_Shoulder_Plate_PvPDeathKnight_O_01", 
		"INV_Shoulder_Plate_PVPPaladinGladiator_O_01", 
		"INV_Shoulder_Plate_PVPPaladin_O_01", 
		"INV_Shoulder_Plate_RaidPaladinMythic_O_01", 
		"INV_Shoulder_Plate_RaidPaladin_O_01", 
		"INV_Cloth_DraenorCrafted_D_01Shoulders", 
		"INV_Cloth_DraenorCrafted_D_01Shoulders_Horde", 
		"INV_Cloth_PVPWarlockGladiator_O_01Shoulder", 
		"INV_Cloth_DraenorQuest95_B_01Shoulder", 
		"INV_Cloth_RaidWarlockMythic_O_01Shoulder", 
		"INV_Cloth_RaidWarlock_O_01Shoulder",
		"INV_Cloth_DraenorDungeon_C_01Shoulder", 
		"INV_Leather_DraenorDungeon_C_01Shoulder", 
		"INV_Leather_DraenorHonor_C_01Shoulder", 
		"INV_Leather_DraenorQuest95_B_01Shoulder", 	
		"INV_Leather_PvPDruidGladiator_O_01Shoulder",
		"INV_Leather_PvPDruid_O_01Shoulder", 
		"INV_Leather_RaidDruidMythic_O_01Shoulder", 
		"INV_Leather_RaidDruid_O_01Shoulder", 
		"INV_Leather_RaidMonkMythic_O_01Shoulder", 
		"INV_Leather_RaidMonk_O_01Shoulders",
		"INV_Leather_RaidRogueMythic_O_01Shoulder",
		"INV_Leather_RaidRogue_O_01Shoulder", 
		"INV_Mail_DraenorQuest90_B_01Shoulder",

		"INV_Mail_ThunderLordClan_B_01Shoulder", 
		"INV_Plate_BlackrockClan_B_01Shoulder",
		"INV_Plate_DraeneiGuard_C_01Shoulder",
		"INV_Plate_DraenorCrafted_D_01Shoulder", 
		"INV_Plate_DraenorLFR_C_01Shoulders",
		"INV_Plate_DraenorQuest90_B_01Shoulder", 
		"INV_Plate_Plate_PvPWarriorGladaitor_O_01Shoulders", 
		"INV_Plate_Plate_PvPWarrior_O_01Shoulders", 
		"INV_Plate_RaidDeathKnightMythic_O_01Shoulder",
		"INV_Plate_RaidDeathKnight_O_01Shoulder",
		"INV_Plate_RaidWarriorMythic_O_01Shoulders", 
		"INV_Plate_RaidWarrior_O_01Shoulders", 
 }
	GHM_StockIcons["Spear"] = {
		-- ok
		"INV_Spear_01",
		"INV_Spear_02",
		"INV_Spear_03",
		"INV_Spear_04",
		"INV_Spear_05",
		"INV_Spear_06",
		"INV_Spear_07",
		"INV_Spear_08",
		"INV_Spear_09",
		"INV_Spear_10",
		"INV_Spear_11",
		"INV_Spear_12",
		"INV_Spear_13",
		"INV_Spear_14",
		"Stormspear_Empowered_Icon", 
		"Stormspear_Unempowered_Icon", 
	}
	GHM_StockIcons["Staff"] = {
		-- ok
		"INV_Staff_01",
		"INV_Staff_02",
		"INV_Staff_03",
		"INV_Staff_04",
		"INV_Staff_05",
		"INV_Staff_06",
		"INV_Staff_07",
		"INV_Staff_08",
		"INV_Staff_09",
		"INV_Staff_10",
		"INV_Staff_11",
		"INV_Staff_12",
		"INV_Staff_13",
		"INV_Staff_14",
		"INV_Staff_15",
		"INV_Staff_16",
		"INV_Staff_17",
		"INV_Staff_18",
		"INV_Staff_19",
		"INV_Staff_20",
		"INV_Staff_21",
		"INV_Staff_22",
		"INV_Staff_23",
		"INV_Staff_24",
		"INV_Staff_25",
		"INV_Staff_26",
		"INV_Staff_27",
		"INV_Staff_28",
		"INV_Staff_29",
		"INV_Staff_30",
		"INV_Staff_31",
		"INV_Staff_32",
		"INV_Staff_33",
		"INV_Staff_34",
		"INV_Staff_35",
		"INV_Staff_36",
		"INV_Staff_37",
		"INV_Staff_38",
		"INV_Staff_39",
		"INV_Staff_40",
		"INV_Staff_41",
		"INV_Staff_42",
		"INV_Staff_43",
		"INV_Staff_45",
		"INV_Staff_46",
		"INV_Staff_47",
		"INV_Staff_48",
		"INV_Staff_49",
		"INV_Staff_50",
		"INV_Staff_51",
		"INV_Staff_52",
		"INV_Staff_53",
		"INV_Staff_54",
		"INV_Staff_55",
		"INV_Staff_56",
		"INV_Staff_57",
		"INV_Staff_58",
		"INV_Staff_59",
		"INV_Staff_60",
		"INV_Staff_61",
		"INV_Staff_Draenei_A_01",
		"INV_Staff_Draenei_A_02",
		"INV_Staff_Draenei_A_03",
		"INV_Staff_Goldfeathered_01",
		"INV_Staff_Medivh",
		"INV_Staff_63",
		"INV_Staff_64",
		"INV_Staff_65",
		"INV_Staff_66",
		"INV_Staff_67",
		"INV_Staff_68",
		"INV_Staff_69",
		"INV_Staff_70",
		"INV_Staff_71",
		"INV_Staff_72",
		"INV_Staff_73",
		"INV_Staff_74",
		"INV_Staff_75",
		"INV_Staff_76",
		"INV_Staff_77",
		"INV_Staff_78",
		"INV_Staff_79",
		"INV_Staff_80",
		"INV_Staff_81",
		"INV_Staff_82",
		"INV_Staff_83",
		"INV_Staff_84",
		"INV_Staff_85",
		"INV_Staff_86",
		"INV_Staff_87",
		"INV_Staff_88",
		"INV_Staff_89",
		"INV_Staff_90",
		"INV_Staff_91",
		"INV_Staff_92", -- [647]
		"INV_Staff_93", -- [648]
		"INV_Staff_94", -- [649]
		"INV_Staff_95", -- [650]
		"INV_Staff_96", -- [651]
		"INV_Staff_97", -- [652]
		"INV_Staff_98", -- [653]
		"INV_Staff_99", -- [654]
		"INV_Staff_100", -- [655]
		"INV_Staff_101", -- [656]
		"INV_Staff_102", -- [657]
		"INV_Staff_103", -- [658]
		"INV_Staff_104", -- [659]
		"INV_Staff_105", -- [660]
		"INV_Staff_106", -- [661]
		"INV_Staff_107", -- [662]
		"INV_Staff_108", -- [663]
		"INV_Staff_109", -- [664]
		"INV_Staff_110", -- [665]
		"INV_Staff_111", -- [666]
		"INV_Staff_112", -- [667]
		"INV_Staff_92", -- [865]
		"INV_Staff_93", -- [866]
		"INV_Staff_94", -- [867]
		"INV_Staff_95", -- [868]
		"INV_Staff_96", -- [869]
		"INV_Staff_97", -- [870]
		"INV_Staff_98", -- [871]
		"INV_Staff_99", -- [872]
		"INV_Staff_100", -- [873]
		"INV_Staff_101", -- [874]
		"INV_Staff_102", -- [875]
		"INV_Staff_103", -- [876]
		"INV_Staff_104", -- [877]
		"INV_Staff_105", -- [878]
		"INV_Staff_106", -- [879]
		"INV_Staff_107", -- [880]
		"INV_Staff_108", -- [881]
		"INV_Staff_109", -- [882]
		"INV_Staff_110", -- [883]
		"INV_Staff_111", -- [884]
		"INV_Staff_112", -- [885]
		"INV_Weapon_Staff_109", -- [759]

		"inv_stave_2h_cataclysm_c_03",
		"inv_polearm_2h_cataclysm_c_01",
		"inv_staff_116",
		"inv_stave_2h_cataclysm_c_02",
		"INV_Stave_2H_FirelandsRaid_D_01",
		"INV_Stave_2H_FirelandsRaid_D_03",
		"INV_Stave_2H_FirelandsRaid_D_03_Stage1",
		"INV_Stave_2H_FirelandsRaid_D_03_Stage2",
		"Stave_2H_Tarecgosa_E_01BaseStaff",
		"Stave_2H_Tarecgosa_E_01Stage1",
		"Stave_2H_Tarecgosa_E_01Stage2",
		"Stave_2H_Tarecgosa_E_01StageFinal",
		"INV_STAFF_116",
		"INV_STAFF_2H_PVP410_C_03",
		"INV_Staff_2h_PVPCataclysmS3_C_01",
		"INV_Staff_2h_PVPCataclysmS3_C_02",
		"INV_Staff_2h_PVPCataclysmS3_C_03",
		"INV_Stave_2h_430Future_C_01",
		"INV_Stave_2H_430NightElf_C_01",
		"INV_Stave_2h_430OldGod_C_01",
		"INV_Stave_2h_DeathwingRaid_D_01",
		"INV_Stave_2h_DeathwingRaid_D_02",
		"INV_Stave_2h_DeathwingRaid_D_03",
		"INV_Stave_2h_DeathwingRaidDW_D_01",
		"INV_Stave_2H_PVP400_C_03",
		"INV_Staff_2H_Mantid_01", 
		"INV_Staff_2h_PandaRaid_D_02", 
		"INV_Staff_2H_PandaRaid_D_03", 
		"INV_Staff_2h_PandaRaid_D_04", 
		"INV_Staff_2H_PandariaQuest_B_01", 
		"INV_Staff_2H_PandariaQuest_B_02", 
		"INV_Staff_2H_PandariaQuest_B_03", 
		"INV_Staff_2H_PandariaQuest_B_04", 
		"INV_Staff_2h_PandariaTradeskill_C_01", 
		"INV_Staff_2h_PandariaTradeskill_C_02", 
		"INV_Staff_2H_PandariaTradeskill_C_04", 
		"INV_Staff_2H_PandariaTradeskill_C_05", 
		"INV_Staff_2h_PanDung_C_01", 
		"INV_Staff_2H_PanDung_C_02", 
		"INV_Staff_2H_PanDung_C_03", 
		"INV_Staff_2h_PVPPandariaS1_C_03", 
		"INV_Stave_2h_PanProg_B_01", 
		"INV_Stave_2h_PanProg_B_02", 
		"INV_Stave_2H_PanStart_A_01", 
		"INV_Stave_2h_PVPPandariaS1_C_01", 
		"INV_Stave_2h_PVPPandariaS1_C_02", 
		"INV_Stave_2h_PVPPandariaS2_C_01", 
		"INV_Stave_2h_Scholomance_D_01", 
		"INV_Legendary_Staff", 
		"INV_Staff_2H_BloodElf_C_01", 
		"INV_Staff_2h_GnomeWarlock_C_01", 
		"INV_Staff_2H_HumanPriest_C_01", 
		"INV_Staff_2H_NightElfDruid_C_01", 
		"INV_Staff_2H_Zandalari_C_01", 
		"INV_Stave_2H_PVPPandariaS2_C_02", 
		"INV_Stave_2h_PVPPandariaS2_C_03Alliance", 
		"INV_Stave_2h_PVPPandariaS2_C_03Green", 
		"INV_Stave_2h_PVPPandariaS2_C_03Horde", 
		"INV_Stave_2h_PVPPandariaS2_C_03Red", 
		"INV_Stave_2h_ThunderIsleRaid_D_01", 
		"INV_Stave_2h_ThunderIsleRaid_D_02", 
		"INV_Stave_2h_ThunderIsleRaid_D_03", 
		"INV_Stave_2h_ThunderIsleRaid_D_04", 
		"INV_Staff_2h_OrgimmarRaid_D_01", 
		"INV_Staff_2H_OrgrimmarRaid_D_02", 
		"INV_Staff_2H_OrgrimmarRaid_D_03", 
		"INV_Staff_2h_orgrimmarRaid_D_04", 
		"INV_Staff_2h_OrgrimmarRaid_D_05", 
		"INV_Staff_2H_PVPPandariaS3_C_01", 
		"INV_staff_2h_pvppandariaS3_C_02", 
		"INV_Stave_2H_PVPHorde_A_01_UpRes", 
		"INVStaff_2h_DraenorCrafted_D_03_A_Alliance", 
		"INVStaff_2h_DraenorCrafted_D_03_A_Horde", 
		"INVStaff_2h_DraenorCrafted_D_03_B_Alliance", 
		"INVStaff_2h_DraenorCrafted_D_03_B_Horde", 
		"INVStaff_2h_DraenorCrafted_D_03_C_Alliance", 
		"INVStaff_2h_DraenorCrafted_D_03_C_Horde", 
		"INVStaff_2h_DraenorDungeon_C_04", 
		"INV_staff_2h_arakkoa_C_01", 
		"INV_STAFF_2H_ARAKKOA_C_02", 
		"INV_Staff_2H_Draenei_C_01", 
		"INV_Staff_2h_DraenorChallenge_D_01", 
		"INV_Staff_2h_DraenorChallenge_D_02", 
		"INV_Staff_2h_DraenorChallenge_D_03", 
		"INV_Staff_2h_DraenorCrafted_D_01_A_Alliance", 
		"INV_Staff_2h_DraenorCrafted_D_01_A_Horde", 
		"INV_Staff_2h_DraenorCrafted_D_01_B_Alliance", 
		"INV_Staff_2h_DraenorCrafted_D_01_B_Horde", 
		"INV_Staff_2h_DraenorCrafted_D_01_C_Alliance", 
		"INV_Staff_2h_DraenorCrafted_D_01_C_Horde", 
		"INV_Staff_2h_DraenorCrafted_D_02_A_Alliance", 
		"INV_Staff_2h_DraenorCrafted_D_02_A_Horde", 
		"INV_Staff_2h_DraenorCrafted_D_02_B_Alliance", 
		"INV_Staff_2h_DraenorCrafted_D_02_B_Horde", 
		"INV_Staff_2h_DraenorCrafted_D_02_C_Alliance", 
		"INV_Staff_2h_DraenorCrafted_D_02_C_Horde", 
		"INV_Staff_2h_DraenorDungeon_C_01", 
		"INV_Staff_2h_DraenorDungeon_C_02", 
		"INV_Staff_2h_DraenorDungeon_C_03", 
		"INV_Staff_2h_DraenorDungeon_C_05", 
		"INV_Staff_2h_DraenorGuard_B_01_Alliance", 
		"INV_Staff_2h_DraenorGuard_B_01_Horde", 
		"INV_STAFF_2H_DRAENORHONOR_C_01", 
		"INV_Staff_2h_DraenorHonor_C_02", 
		"INV_Staff_2h_DraenorHonor_C_03", 
		"INV_Staff_2h_DraenorQuest95_B_01", 
		"INV_Staff_2H_DraenorQuest95_B_02", 
		"INV_Staff_2h_DraenorQuest95_B_03", 
		"INV_Staff_2h_DraenorQuest_B_01", 
		"INV_Staff_2h_DraenorQuest_B_02", 
		"INV_Staff_2h_DraenorQuest_B_03", 
		"INV_Staff_2h_DraenorRaid_D_01", 
		"INV_Staff_2h_DraenorRaid_D_02", 
		"INV_Staff_2h_DraenorRaid_D_03", 
		"INV_Staff_2h_DraenorRaid_D_04", 
		"INV_Staff_2h_DraenorRaid_D_05", 
		"INV_Staff_2h_DraenorRaid_D_06", 
		"INV_Staff_2H_Nerzhul_D_01", 
		"INV_Staff_2h_PVPDraenorS1_D_01", 
		"INV_Staff_2h_PVPDraenorS1_D_02", 
		"INV_Staff_2h_PVPDraenorS1_D_03", 
	}
	GHM_StockIcons["Sword"] = {
		-- ok
		"INV_Sword_01",
		"INV_Sword_1H_Blacksmithing_01",
		"INV_Sword_1H_Blacksmithing_02",
		"INV_Sword_1H_Blacksmithing_03",
		"INV_Sword_02",
		"INV_Sword_2H_AshbringerCorrupt",
		"INV_Sword_2H_Blacksmithing_01",
		"INV_Sword_2H_Blacksmithing_02",
		"INV_Sword_2H_Blacksmithing_03",
		"INV_Sword_2H_Blood_B_01",
		"INV_Sword_2H_Blood_B_02",
		"INV_Sword_2H_Blood_C_01",
		"INV_Sword_2H_Blood_C_02",
		"INV_Sword_2H_Blood_C_03",
		"INV_Sword_02",
		"INV_Sword_03",
		"INV_Sword_04",
		"INV_Sword_05",
		"INV_Sword_06",
		"INV_Sword_07",
		"INV_Sword_08",
		"INV_Sword_09",
		"INV_Sword_10",
		"INV_Sword_11",
		"INV_Sword_12",
		"INV_Sword_13",
		"INV_Sword_14",
		"INV_Sword_15",
		"INV_Sword_16",
		"INV_Sword_17",
		"INV_Sword_18",
		"INV_Sword_19",
		"INV_Sword_20",
		"INV_Sword_21",
		"INV_Sword_22",
		"INV_Sword_23",
		"INV_Sword_24",
		"INV_Sword_25",
		"INV_Sword_26",
		"INV_Sword_27",
		"INV_Sword_28",
		"INV_Sword_29",
		"INV_Sword_30",
		"INV_Sword_31",
		"INV_Sword_32",
		"INV_Sword_33",
		"INV_Sword_34",
		"INV_Sword_35",
		"INV_Sword_36",
		"INV_Sword_37",
		"INV_Sword_38",
		"INV_Sword_39",
		"INV_Sword_40",
		"INV_Sword_41",
		"INV_Sword_42",
		"INV_Sword_43",
		"INV_Sword_44",
		"INV_Sword_45",
		"INV_Sword_46",
		"INV_Sword_47",
		"INV_Sword_48",
		"INV_Sword_49",
		"INV_Sword_50",
		"INV_Sword_51",
		"INV_SWORD_52",
		"INV_Sword_53",
		"INV_Sword_54",
		"INV_Sword_55",
		"INV_Sword_56",
		"INV_Sword_57",
		"INV_Sword_58",
		"INV_Sword_59",
		"INV_Sword_60",
		"INV_Sword_61",
		"INV_Sword_62",
		"INV_Sword_63",
		"INV_Sword_64",
		"INV_Sword_65",
		"INV_Sword_66",
		"INV_Sword_67",
		"INV_Sword_68",
		"INV_Sword_69",
		"INV_Sword_70",
		"INV_Sword_71",
		"INV_Sword_72",
		"INV_Sword_73",
		"INV_Sword_74",
		"INV_Sword_75",
		"INV_Sword_76",
		"INV_Sword_77",
		"INV_Sword_78",
		"INV_Sword_79",
		"INV_Sword_80",
		"INV_Sword_81",
		"INV_Sword_82",
		"INV_Sword_83",
		"INV_Sword_84",
		"INV_Sword_85",
		"INV_Sword_86",
		"INV_Sword_87",
		"INV_Sword_88",
		"INV_Sword_89",
		"INV_Sword_90",
		"INV_Sword_91",
		"INV_Sword_92",
		"INV_Sword_93",
		"INV_Sword_94",
		"INV_Sword_BloodElf_03",
		"INV_Sword_Draenei_01",
		"INV_Sword_Draenei_02",
		"INV_Sword_draenei_03",
		"INV_Sword_draenei_04",
		"INV_Sword_Draenei_05",
		"INV_Sword_Draenei_06",
		"INV_Sword_Draenei_07",
		"INV_Sword_Draenei_08",
		"INV_ThrowingKnife_01",
		"INV_ThrowingKnife_02",
		"INV_ThrowingKnife_03",
		"INV_ThrowingKnife_04",
		"INV_ThrowingKnife_05",
		"INV_ThrowingKnife_06",
		"INV_Weapon_ShortBlade_01",
		"INV_Weapon_ShortBlade_02",
		"INV_Weapon_ShortBlade_03",
		"INV_Weapon_ShortBlade_04",
		"INV_Weapon_ShortBlade_05",
		"INV_Weapon_ShortBlade_06",
		"INV_Weapon_ShortBlade_07",
		"INV_Weapon_ShortBlade_08",
		"INV_Weapon_ShortBlade_09",
		"INV_Weapon_ShortBlade_10",
		"INV_Weapon_ShortBlade_11",
		"INV_Weapon_ShortBlade_12",
		"INV_Weapon_ShortBlade_13",
		"INV_Weapon_ShortBlade_14",
		"INV_Weapon_ShortBlade_15",
		"INV_Weapon_ShortBlade_16",
		"INV_Weapon_ShortBlade_17",
		"INV_Weapon_ShortBlade_18",
		"INV_Weapon_ShortBlade_19",
		"INV_Weapon_ShortBlade_20",
		"INV_Weapon_ShortBlade_21",
		"INV_Weapon_ShortBlade_22",
		"INV_Weapon_ShortBlade_23",
		"INV_Weapon_ShortBlade_24",
		"INV_Weapon_ShortBlade_25",
		"INV_Weapon_ShortBlade_26",
		"INV_Weapon_ShortBlade_27",
		"INV_Weapon_Shortblade_28",
		"INV_Weapon_Shortblade_29",
		"INV_Weapon_Shortblade_30",
		"INV_Weapon_Shortblade_31",
		"INV_Weapon_Shortblade_32",
		"INV_Weapon_Shortblade_33",
		"INV_Weapon_Shortblade_34",
		"INV_Weapon_Shortblade_35",
		"INV_Weapon_Shortblade_37",
		"INV_Weapon_Shortblade_38",
		"INV_Weapon_Shortblade_39",
		"INV_Weapon_Shortblade_40",
		"INV_Weapon_Shortblade_41",
		"INV_Weapon_Shortblade_42",
		"INV_Weapon_Shortblade_43",
		"INV_Weapon_Shortblade_44",
		"INV_Weapon_Shortblade_45",
		"INV_Weapon_Shortblade_46",
		"INV_Weapon_Shortblade_47",
		"INV_Weapon_Shortblade_48",
		"INV_Weapon_Shortblade_49",
		"INV_Weapon_Shortblade_50",
		"INV_Weapon_Shortblade_51",
		"INV_Weapon_Shortblade_52",
		"INV_Weapon_Shortblade_53",
		"INV_Weapon_Shortblade_54",
		"INV_Weapon_Shortblade_55",
		"INV_Weapon_Shortblade_56",
		"INV_Weapon_Shortblade_57",
		"INV_Weapon_Shortblade_58",
		"INV_Weapon_Shortblade_59",
		"INV_Weapon_Shortblade_60",
		"INV_Weapon_Shortblade_61",
		"INV_Weapon_Shortblade_62",
		"INV_Weapon_Shortblade_63",
		"INV_SWORD_88",
		"INV_Sword_95",
		"INV_Sword_96",
		"INV_Sword_97",
		"INV_Sword_98",
		"INV_Sword_99",
		"INV_Sword_100",
		"INV_Sword_101",
		"INV_Sword_102",
		"INV_Sword_103",
		"INV_Sword_104",
		"INV_Sword_105",
		"INV_Sword_106",
		"INV_SWORD_107",
		"INV_Sword_108",
		"INV_Sword_109",
		"INV_Sword_110",
		"INV_Sword_111",
		"INV_Sword_112",
		"INV_Sword_113",
		"INV_Sword_114",
		"INV_Sword_115",
		"INV_Sword_116",
		"INV_Sword_117",
		"INV_Sword_118",
		"INV_Sword_119",
		"INV_Sword_120",
		"INV_Sword_121",
		"INV_Sword_122",
		"INV_Sword_123",
		"INV_Sword_124",
		"INV_Sword_125",
		"INV_Sword_126",
		"INV_Sword_127",
		"INV_Sword_128",
		"INV_Sword_129",
		"INV_Sword_130",
		"INV_Sword_131",
		"INV_Weapon_Shortblade_64",
		"INV_Weapon_Shortblade_65",
		"INV_Weapon_Shortblade_66",
		"INV_Weapon_Shortblade_67",
		"INV_Weapon_Shortblade_68",
		"INV_Weapon_Shortblade_69",
		"INV_Weapon_Shortblade_70",
		"INV_WEAPON_SHORTBLADE_71",
		"INV_Weapon_Shortblade_72",
		"INV_Weapon_Shortblade_73",
		"INV_Weapon_Shortblade_74",
		"INV_Weapon_Shortblade_75",
		"INV_Weapon_Shortblade_76",
		"INV_Weapon_Shortblade_77",
		"INV_Weapon_Shortblade_78",
		"INV_Weapon_Shortblade_79",
		"INV_Weapon_Shortblade_80",
		"INV_Weapon_Shortblade_82",
		"INV_Weapon_Shortblade_83",
		"INV_Weapon_Shortblade_84",
		"INV_Weapon_Shortblade_85",
		"INV_Weapon_Shortblade_86",
		"INV_Weapon_Shortblade_87",
		"INV_Weapon_Shortblade_88",
		"INV_Weapon_Shortblade_89",
		"INV_Weapon_Shortblade_90",
		"INV_Weapon_Shortblade_91",
		"INV_Weapon_Shortblade_92",
		"INV_knife_1h_stratholme_d_01",
		"INV_knife_1h_stratholme_d_02",
		"INV_knife_1h_stratholme_d_03",
		"INV_ThrowingKnife_08",
		"INV-Sword_53",
		"INV_Weapon_Glave_01",

		"INV_SWORD_115", -- [668]
		"INV_Sword_132", -- [669]
		"INV_Sword_133", -- [670]
		"INV_Sword_134", -- [671]
		"INV_Sword_135", -- [672]
		"INV_Sword_136", -- [673]
		"INV_Sword_137", -- [674]
		"INV_Sword_138", -- [675]
		"INV_Sword_139", -- [676]
		"INV_Sword_140", -- [677]
		"INV_Sword_141", -- [678]
		"INV_Sword_142", -- [679]
		"INV_Sword_143", -- [680]
		"INV_Sword_144", -- [681]
		"INV_Sword_145", -- [682]
		"INV_Sword_146", -- [683]
		"INV_Sword_147", -- [684]
		"INV_Sword_148", -- [685]
		"INV_Sword_149", -- [686]
		"INV_Sword_150", -- [687]
		"INV_Sword_151", -- [688]
		"INV_Sword_152", -- [689]
		"INV_Sword_153", -- [690]
		"INV_Sword_154", -- [691]
		"INV_Sword_155", -- [692]
		"INV_Sword_156", -- [693]
		"INV_Sword_157", -- [694]
		"INV_Weapon_Shortblade_93", -- [744]
		"INV_Weapon_Shortblade_94", -- [745]
		"INV_Weapon_Shortblade_95", -- [746]
		"INV_Weapon_Shortblade_96", -- [747]
		"INV_Weapon_Shortblade_97", -- [748]
		"INV_Weapon_Shortblade_98", -- [749]
		"INV_Weapon_Shortblade_99", -- [750]
		"INV_Weapon_ShortBlade_100", -- [751]
		"INV_Weapon_Shortblade_101", -- [752]
		"INV_Weapon_Shortblade_102", -- [753]
		"INV_Weapon_Shortblade_103", -- [754]
		"INV_Weapon_Shortblade_104", -- [755]
		"INV_Weapon_Shortblade_105", -- [756]
		"INV_Weapon_Shortblade_106", -- [757]
		"INV_Weapon_Shortblade_107", -- [758]
		"INV_SWORD_115", -- [886]
		"INV_Sword_132", -- [887]
		"INV_Sword_133", -- [888]
		"INV_Sword_134", -- [889]
		"INV_Sword_135", -- [890]
		"INV_Sword_136", -- [891]
		"INV_Sword_137", -- [892]
		"INV_Sword_138", -- [893]
		"INV_Sword_139", -- [894]
		"INV_Sword_140", -- [895]
		"INV_Sword_141", -- [896]
		"INV_Sword_142", -- [897]
		"INV_Sword_143", -- [898]
		"INV_Sword_144", -- [899]
		"INV_Sword_145", -- [900]
		"INV_Sword_146", -- [901]
		"INV_Sword_147", -- [902]
		"INV_Sword_148", -- [903]
		"INV_Sword_149", -- [904]
		"INV_Sword_150", -- [905]
		"INV_Sword_151", -- [906]
		"INV_Sword_152", -- [907]
		"INV_Sword_153", -- [908]
		"INV_Sword_154", -- [909]
		"INV_Sword_155", -- [910]
		"INV_Sword_156", -- [911]
		"INV_Sword_157", -- [912]
		"INV_Weapon_Shortblade_93", -- [962]
		"INV_Weapon_Shortblade_94", -- [963]
		"INV_Weapon_Shortblade_95", -- [964]
		"INV_Weapon_Shortblade_96", -- [965]
		"INV_Weapon_Shortblade_97", -- [966]
		"INV_Weapon_Shortblade_98", -- [967]
		"INV_Weapon_Shortblade_99", -- [968]
		"INV_Weapon_ShortBlade_100", -- [969]
		"INV_Weapon_Shortblade_101", -- [970]
		"INV_Weapon_Shortblade_102", -- [971]
		"INV_Weapon_Shortblade_103", -- [972]
		"INV_Weapon_Shortblade_104", -- [973]
		"INV_Weapon_Shortblade_105", -- [974]
		"INV_Weapon_Shortblade_106", -- [975]
		"INV_Weapon_Shortblade_107", -- [976]
		"INV_Knife_1H_PVP320_C_02", -- [433]

		"inv_sword_1h_cataclysm_c_04",
		"inv_sword_1h_cataclysm_c_01",
		"inv_sword_1h_cataclysm_c_03",
		"inv_sword_1h_cataclysm_c_06",
		"inv_sword_2h_pvp_c_01",


		"INV_Sword_1h_430OldGod_C_01",
		"INV_Sword_1h_DeathwingRaid_D_01",
		"INV_Sword_1h_DeathwingRaidDW_D_01",
		"INV_Sword_1H_PVPCataclysmS3_C_01",
		"INV_Sword_2h_DeathwingRaidDW_D_01",
		"INV_Sword_2h_PVPCataclysmS3_C_01",
		 "INV_Sword_1H_Mantid_01", 
		"INV_Sword_1h_PandaRaid_D_01", 
		"INV_Sword_1H_PandaRaid_D_02", 
		"INV_Sword_1H_PandaRaid_D_03", 
		"INV_Sword_1H_PandariaQuest_B_01", 
		"INV_Sword_1H_PandariaQuest_B_02", 
		"INV_Sword_1H_PandariaTradeskill_C_01", 
		"INV_Sword_1H_PanDung_C_01", 
		"INV_Sword_1h_PanProg_B_01", 
		"INV_Sword_1H_PanStart_A_01", 
		"INV_Sword_1h_PVPPandariaS1_C_02", 
		"INV_Sword_1H_Raid_D_02", 
		"INV_Sword_2H_Mantid_01", 
		"INV_Sword_2h_PandaRaid_D_01", 
		"INV_Sword_2H_PandariaQuest_B_01", 
		"INV_Sword_2H_PanDung_C_01", 
		"INV_Sword_2h_PanProg_B_01", 
		"INV_Sword_2H_PanStart_A_01", 
		"INV_Sword_2h_PVPPandariaS1_C_01", 
		 "Sword_1h_PVPPandariaS1_C_01", 
		"INV_Legendary_Sword", 
		"INV_Sword_1H_MantidArch_C_01", 
		"INV_Sword_1H_Mogu_C_01", 
		"INV_Sword_1H_PVPPandariaS2_C_01", 
		"inv_sword_1h_pvppandarias2_c_02", 
		"INV_Sword_1H_Saurok_01", 
		"INV_Sword_1h_ThunderIsleRaid_D_01", 
		"INV_Sword_2H_Mogu_C_01", 
		"INV_Sword_2h_PVPPandariaS2_C_01", 
		"INV_Sword_2h_ThunderIsleRaid_D_01", 
		"INV_Sword_2H_WorgenDeathKnight_C_01", 
		"INV_Wand_1H_ThunderIsleRaid_D_01", 
		"INV_Sword_1H_OrgrimmarRaid_D_01", 
		"INV_Sword_1h_OrgrimmarRaid_D_02", 
		"INV_Sword_1h_OrgrimmarRaid_D_03", 
		"INV_Sword_1h_OrgrimmarRaid_D_04", 
		"INV_Sword_1H_PVPHorde_A_01_UpRes", 
		"INV_Sword_1h_PVPPandariaS3_C_01", 
		"INV_Sword_1H_PVPPandariaS3_C_02", 
		"INV_Sword_2h_OrgrimmarRaid_D_01", 
		"INV_Sword_2h_PVPPandariaS3_C_01", 
		"INV_Sword_135", 
		"INV_SWORD_1H_ARAKKOA", 
		"INV_Sword_1H_Arakkoa_B_01", 
		"INV_sword_1H_Arakkoa_c_01", 
		"INV_sword_1H_Arakkoa_c_02", 
		"INV_Sword_1H_Draenei_C_02", 
		"INV_Sword_1H_Draenei_C_03", 
		"INV_Sword_1h_DraenorChallenge_D_01", 
		"INV_Sword_1h_DraenorCrafted_D_01_A", 
		"INV_Sword_1h_DraenorCrafted_D_01_B", 
		"INV_Sword_1h_DraenorCrafted_D_01_C", 
		"INV_Sword_1H_DraenorCrafted_D_01_C_Alliance", 
		"INV_Sword_1H_DraenorCrafted_D_01_C_Horde", 
		"INV_Sword_1h_DraenorCrafted_D_02_A_alliance", 
		"INV_Sword_1h_DraenorCrafted_D_02_A_horde", 
		"INV_Sword_1h_DraenorCrafted_D_02_B_alliance", 
		"INV_Sword_1h_DraenorCrafted_D_02_B_horde", 
		"INV_Sword_1h_DraenorCrafted_D_02_C_alliance", 
		"INV_Sword_1h_DraenorCrafted_D_02_C_horde", 
		"INV_Sword_1h_DraenorDungeon_C_01", 
		"INV_Sword_1h_DraenorDungeon_C_02", 
		"INV_Sword_1h_DraenorGuard_B_02_a_alliance", 
		"INV_Sword_1h_DraenorGuard_B_02_a_horde", 
		"INV_Sword_1h_DraenorHonor_C_01", 
		"INV_Sword_1h_DraenorQuest95_B_01", 
		"INV_Sword_1h_DraenorQuest_B_01", 
		"INV_Sword_1h_DraenorRaid_D_01", 
		"INV_Sword_1h_DraenorRaid_D_02", 
		"inv_Sword_1h_DraenorRaid_D_03", 
		"inv_Sword_1h_DraenorRaid_D_03blue", 
		"inv_Sword_1h_DraenorRaid_D_03purple", 
		"inv_Sword_1h_DraenorRaid_D_03red", 
		"inv_Sword_1h_DraenorRaid_D_03yellow", 
		"INV_sword_1h_garrison_a_01", 
		"INV_sword_1h_garrison_a_02", 
		"INV_sword_1h_garrison_a_03", 
		"INV_sword_1h_garrison_a_04", 
		"INV_sword_1h_garrison_a_05", 
		"INV_Sword_1h_PVPDraenorS1_D_01", 
		"INV_Sword_1h_PVPDraenorS1_D_02", 
		"INV_Sword_1h_short_A_01_HD", 
		"INV_Sword_2H_Draenei_C_01", 
		"INV_Sword_2h_DraenorChallenge_D_01", 
		"INV_Sword_2h_DraenorCrafted_D_01_A", 
		"INV_Sword_2h_DraenorCrafted_D_01_B", 
		"INV_Sword_2h_DraenorCrafted_D_01_C", 
		"INV_Sword_2h_DraenorDungeon_C_01", 
		"INV_Sword_2h_DraenorHonor_C_01", 
		"INV_Sword_2H_DraenorQuest95_B_01", 
		"INV_Sword_2H_DraenorQuest_B_01", 
		"INV_Sword_2h_DraenorRaid_D_01", 
		"INV_Sword_2H_DraenorRaid_D_03", 
		"INV_Sword_2H_DreanorOgre_B_01", 
		"INV_sword_2H_orcclan_b_01", 
		"INV_Sword_2h_PVPDraenorS1_D_01", 
		}
	GHM_StockIcons["Wand"] = {
		-- ok
		"INV_Wand_01",
		"INV_Wand_02",
		"INV_Wand_03",
		"INV_Wand_04",
		"INV_Wand_05",
		"INV_Wand_06",
		"INV_Wand_07",
		"INV_Wand_08",
		"INV_Wand_09",
		"INV_Wand_10",
		"INV_Wand_11",
		"INV_Wand_12",
		"INV_Wand_14",
		"INV_Wand_15",
		"INV_Wand_16",
		"INV_Wand_17",
		"INV_Wand_18",
		"INV_Wand_19",
		"INV_Wand_20",
		"INV_Wand_21",
		"INV_Wand_1H_Stratholme_D_01",
		"INV_Wand_1H_Stratholme_D_02",
		"INV_Wand_22",
		"INV_Wand_23",
		"INV_Wand_24",
		"INV_Wand_25",
		"INV_Wand_27",
		"INV_Wand_28", -- [707]
		"INV_Wand_29", -- [708]
		"INV_Wand_30", -- [709]
		"INV_Wand_31", -- [710]
		"INV_Wand_32", -- [711]
		"INV_Wand_33", -- [712]
		"INV_Wand_34", -- [713]
		"INV_Wand_35", -- [714]
		"INV_Wand_36", -- [715]
		"INV_Wand_28", -- [925]
		"INV_Wand_29", -- [926]
		"INV_Wand_30", -- [927]
		"INV_Wand_31", -- [928]
		"INV_Wand_32", -- [929]
		"INV_Wand_33", -- [930]
		"INV_Wand_34", -- [931]
		"INV_Wand_35", -- [932]
		"INV_Wand_36", -- [933]

		"inv_wand_1h_pvp400_c_01",
		--"inv_wand_1h_cataclysm_c_01", --Icon Missing.
		"inv_wand_1h_cataclysm_c_02",
		"inv_wand_1h_cataclysm_c_03",
		"INV_Wand_1h_430NightElf_C_01",
		"INV_Wand_1h_430OldGod_C_01",
		"INV_Wand_1h_DeathwingRaid_D_01",
		"INV_Wand_1h_DeathwingRaid_D_02",
		"INV_Wand_1H_PVPCataclysmS3_C_02",
		"INV_Wand_38",
		"INV_Wand_1h_OrgrimmarRaid_D_01", 
		"INV_Wand_1h_PVPPandariaS3_C_01", 
		 "INV_wand_1h_arakkoa_c_01", 
		"INV_Wand_1h_DraenorCrafted_D_01_A", 
		"INV_Wand_1H_DraenorCrafted_D_01_A_Horde", 
		"INV_Wand_1h_DraenorCrafted_D_01_B", 
		"INV_Wand_1H_DraenorCrafted_D_01_B_Horde", 
		"INV_Wand_1h_DraenorCrafted_D_01_C", 
		"INV_Wand_1H_DraenorCrafted_D_01_C_Horde", 
		"INV_Wand_1h_DraenorDungeon_C_01", 
		"INV_Wand_1h_DraenorHonor_C_01", 
		"INV_Wand_1h_DraenorQuest95_B_01", 
		"INV_Wand_1h_DraenorQuest_B_01", 
		"INV_Wand_1h_DraenorRaid_D_01Blue", 
		"INV_Wand_1h_DraenorRaid_D_01Green", 
		"INV_Wand_1h_DraenorRaid_D_01Purple", 
		"INV_Wand_1h_DraenorRaid_D_01Red", 
		"INV_Wand_1h_PVPDraenorS1_D_01", 
		"INV_wand_h1_arakkoa_c_01", 
	}
	GHM_StockIcons["Polearm"] = {
		-- ok
		"INV_Weapon_Halbard_01",
		"INV_Weapon_Halberd_02",
		"INV_Weapon_Halberd_03",
		"INV_Weapon_Halberd_04",
		"INV_Weapon_Halberd_05",
		"INV_Weapon_Halberd_06",
		"INV_Weapon_Halberd_07",
		"INV_Weapon_Halberd_08",
		"INV_Weapon_Halberd_09",
		"INV_Weapon_Halberd_10",
		"INV_Weapon_Halberd_11",
		"INV_Weapon_Halberd_12",
		"INV_Weapon_Halberd_20",
		"INV_Weapon_Halberd_AhnQiraj",
		"INV_Weapon_Halberd13",
		"INV_Weapon_Halberd14",
		"INV_Weapon_Halberd15",
		"INV_Weapon_Halberd16",
		"INV_Weapon_Halberd17",
		"INV_Weapon_Halberd18",
		"INV_Weapon_Halberd19",
		"INV_Weapon_Halberd20",
		"INV_Weapon_Halberd21",
		"INV_Weapon_Halberd_21",
		"INV_WEAPON_HALBERD_22",
		"INV_Weapon_Halberd_23",
		"INV_Weapon_Halberd_24",
		"INV_Weapon_Halberd_25",
		"INV_Weapon_Halberd_26",
		"INV_Weapon_Halberd_27",
		"INV_Weapon_Halberd_28",
		"INV_Weapon_Halberd_29",
		"INV_Weapon_Halberd_30", -- [727]
		"INV_Weapon_Halberd_31", -- [728]
		"INV_Polearm_2h_PVPCataclysmS3_C_01",
		 "INV_Polearm_2H_Mantid_01", 
		"INV_polearm_2h_misc_spearfishingrod", 
		"INV_Polearm_2H_PandaGuard_A_01", 
		"INV_Polearm_2H_PandaGuard_B_01", 
		"INV_Polearm_2H_PandaRaid_D_01", 
		"INV_Polearm_2h_PandariaQuest_B_01", 
		"INV_Polearm_2h_PanDung_C_01", 
		"INV_Polearm_2h_PVPPandariaS1_D_01",
		"INV_Polearm_2H_Mogu_C_01", 
		"INV_Polearm_2h_ThunderIsleRaid_D_01", 
		"INV_Polearm_2H_Zandalari_B_01", 
		"INV_Polearm_2H_Zandalari_B_02", 
		"INV_Polearm_2H_OrgrimmarRaid_D_01", 
		"Inv_Polearm_2H_PVPHorde_A_01_UpRes", 
		"INV_Polearm_2h_PVPPandariaS3_C_01", 
		 "INV_POLEARM_2H_ARAKKOA_C_01", 
		"INV_Polearm_2h_DraenorChallenge_D_01_02", 
		"INV_Polearm_2h_DraenorCrafted_D_01_A", 
		"INV_Polearm_2h_DraenorCrafted_D_01_B", 
		"INV_Polearm_2h_DraenorCrafted_D_01_C", 
		"INV_Polearm_2h_DraenorDungeon_C_01", 
		"INV_Polearm_2h_DraenorHonor_C_01", 
		"INV_Polearm_2h_DraenorQuest95_B_01", 
		"INV_Polearm_2h_DraenorQuest_B_01", 
		"INV_Polearm_2H_Genesaur_B_01", 
		"INV_Polearm_2h_PVPDraenorS1_D_01", 
		"INV_Polearm_2H_ThunderLordClan_B_01",
		
	}
	GHM_StockIcons["Fist"] = {
		-- ok
		"INV_Weapon_Hand_01",
		"INV_Weapon_Hand_02",
		"INV_Weapon_Hand_03",
		"INV_Weapon_Hand_04",
		"INV_Weapon_Hand_05",
		"INV_Weapon_Hand_06",
		"INV_Weapon_Hand_07",
		"INV_WEAPON_HAND_08",
		"INV_Weapon_Hand_09",
		"INV_Weapon_Hand_10",
		"INV_Weapon_Hand_11",
		"INV_Weapon_Hand_12",
		"INV_Weapon_Hand_13",
		"INV_Weapon_Hand_14",
		"INV_Weapon_Hand_15",
		"INV_Weapon_Hand_16",
		"INV_Weapon_Hand_17",
		"INV_Weapon_Hand_18",
		"INV_Weapon_Hand_19",
		"INV_Weapon_Hand_20",
		"INV_Weapon_Hand_21",
		"INV_Offhand_Dalaran_D_01",
		"INV_Offhand_Sunwell_D_01",
		"INV_Offhand_Sunwell_D_02",
		"INV_Offhand_Utgarde_D_01",
		"INV_Offhand_ZulAman_D_01",
		"INV_Offhand_ZulAman_D_02",
		"INV_Offhand_1h_PandariaQuest_B_01", 
		"INV_Offhand_1h_PandariaTradeskill_C_01", 
		"INV_Offhand_1h_PandariaTradeskill_C_02", 
		"INV_Offhand_1h_PanDung_C_01", 
		"INV_Offhand_1H_PanProg_B_01", 
		"INV_Offhand_1h_PanStart_A_01", 
		"INV_Offhand_1h_PanStart_A_02", 
		"INV_Offhand_1h_PVPPandariaS1_C_01", 
		"INV_Offhand_1h_OrgrimmarRaid_D_01", 
		"INV_Offhand_1h_OrgrimmarRaid_D_02", 
		"INV_Offhand_1H_OrgrimmarRaid_D_03", 
		"INV_Offhand_1H_PVPPandariaS3_C_01", 

		"INV_Weapon_Hand_22", -- [729]
		"INV_Weapon_Hand_23", -- [730]
		"INV_Weapon_Hand_29", -- [731]
		"INV_Weapon_Hand_30", -- [732]
		"INV_Weapon_Hand_31", -- [733]
		"INV_Weapon_Hand_32", -- [734]
		"INV_Weapon_Hand_33", -- [735]
		"INV_Weapon_Hand_34", -- [736]
		"INV_Weapon_Hand_22", -- [947]
		"INV_Weapon_Hand_23", -- [948]
		"INV_Weapon_Hand_29", -- [949]
		"INV_Weapon_Hand_30", -- [950]
		"INV_Weapon_Hand_31", -- [951]
		"INV_Weapon_Hand_32", -- [952]
		"INV_Weapon_Hand_33", -- [953]
		"INV_Weapon_Hand_34", -- [954]

		"INV_Offhand_1H_UlduarRaid_D_01", -- [542]
		"INV_Offhand_PVEAlliance_D_01", -- [543]
		"INV_Offhand_PVP320_C_01", -- [544]
		"INV_Offhand_PVP330_D_01", -- [545]
		"INV_Offhand_PVP330_D_02", -- [546]
		"INV_Offhand_UlduarRaid_D_02", -- [547]
		"INV_Offhand_UlduarRaid_D_03", -- [548]
		"INV_Hand_1h_430OldGod_C_01",
		"INV_Hand_1H_DrakTharon_D_01", 
		"INV_Hand_1H_PandaRaid_D_01", 
		"INV_Hand_1h_PandaRaid_D_02", 
		"INV_Hand_1h_PandariaQuest_B_01", 
		"INV_Hand_1h_PanDung_C_01", 
		"INV_Hand_1H_PanProg_B_01", 
		"INV_Hand_1H_PanStart_A_01", 
		"INV_Hand_1h_PVPPandariaS1_C_01", 
		"INV_Hand_1H_ShaClaw", 
		"INV_Legendary_FistWeapon", 
		"INV_Hand_1H_PVPPandariaS2_C_01", 
		"INV_Hand_1H_TaurenShaman_C_01", 
		"INV_Hand_1h_ThunderIsleRaid_D_01", 
		"INV_Hand_1h_ThunderIsleRaid_D_02", 
		"INV_Hand_1h_ThunderIsleRaid_D_03", 
		"INV_Hand_1H_TrollShaman_C_01", 
		"INV_Hand_1H_OrgrimmarRaid_D_01", 
		"INV_Hand_1h_PVPPandariaS3_C_01", 
		"INVHand_1h_DraenorCrafted_D_01_A_Alliance", 
		"INVHand_1h_DraenorCrafted_D_01_A_Horde", 
		"INVHand_1h_DraenorCrafted_D_01_B_Alliance", 
		"INVHand_1h_DraenorCrafted_D_01_B_Horde", 
		"INVHand_1h_DraenorCrafted_D_01_C_Alliance", 
		"INVHand_1h_DraenorCrafted_D_01_C_Horde",
		"INV_Hand_1h_DraenorChallenge_D_01", 
		"INV_Hand_1h_DraenorDungeon_C_01", 
		"INV_Hand_1h_DraenorDungeon_C_02", 
		"INV_Hand_1h_DraenorGuard_B_01_A_Alliance", 
		"INV_Hand_1h_DraenorGuard_B_01_A_Horde", 
		"INV_Hand_1h_DraenorGuard_B_01_B_Alliance", 
		"INV_Hand_1h_DraenorGuard_B_01_B_Horde", 
		"INV_Hand_1h_DraenorGuard_B_01_C_Alliance", 
		"INV_Hand_1h_DraenorGuard_B_01_C_Horde", 
		"INV_Hand_1h_DraenorHonor_C_01", 
		"INV_HAND_1H_DRAENORQUEST95_B_01", 
		"INV_Hand_1h_DraenorQuest_B_01", 
		"INV_Hand_1h_DraenorRaid_D_01", 
		"INV_Hand_1H_DraenorRaid_D_03", 
		"INV_Hand_1h_PVPDraenorS1_D_01", 
	}
	GHM_StockIcons["Trade"] = {
		-- ok
		"Trade_Alchemy",
		"Trade_BlackSmithing",
		"Trade_BrewPoison",
		"Trade_Engineering",
		"Trade_Engraving",
		"Trade_Fishing",
		"Trade_Herbalism",
		"Trade_LeatherWorking",
		"Trade_Mining",
		"Trade_Tailoring",
		"trade_archaeology",
	}
	GHM_StockIcons["Readable"] = {
		-- ok
		"INV_Letter_01",
		"INV_Letter_02",
		"INV_Letter_03",
		"INV_Letter_04",
		"INV_Letter_05",
		"INV_Letter_06",
		"INV_Letter_07",
		"INV_Letter_08",
		"INV_Letter_09",
		"INV_Letter_10",
		"INV_Letter_11",
		"INV_Letter_12",
		"INV_Letter_13",
		"INV_Letter_14",
		"INV_Letter_15",
		"INV_Letter_16",
		"INV_Letter_17",
		"INV_Misc_Book_01",
		"INV_Misc_Book_02",
		"INV_Misc_Book_03",
		"INV_Misc_Book_04",
		"INV_Misc_Book_05",
		"INV_Misc_Book_06",
		"INV_Misc_Book_07",
		"INV_Misc_Book_08",
		"INV_Misc_Book_09",
		"INV_Misc_Book_10",
		"INV_Misc_Book_11",
		"INV_Misc_Book_12",
		"INV_Misc_Book_13",
		"INV_Misc_Book_14",
		"INV_Misc_Book_15",
		"INV_Misc_1H_Book_C_02Red_UpRes", 
		"INV_Misc_Note_01",
		"INV_MISC_NOTE_02",
		"INV_Misc_Note_03",
		"INV_Misc_Note_04",
		"INV_Misc_Note_05",
		"INV_MISC_NOTE_06",
		"INV_Misc_StoneTablet_01",
		"INV_Misc_StoneTablet_02",
		"INV_Misc_StoneTablet_03",
		"INV_Misc_StoneTablet_04",
		"INV_Misc_StoneTablet_05",
		"INV_Misc_StoneTablet_06",
		"INV_Misc_StoneTablet_07",
		"INV_Misc_StoneTablet_08",
		"INV_Misc_StoneTablet_09",
		"INV_Misc_StoneTablet_10",
		"INV_Misc_StoneTablet_11",
		"INV_Scroll_01",
		"INV_Scroll_02",
		"INV_Scroll_03",
		"INV_Scroll_04",
		"INV_Scroll_05",
		"INV_Scroll_06",
		"INV_Scroll_07",
		"INV_Scroll_08",
		"INV_Scroll_09",
		"INV_Scroll_10",
		"INV_Misc_LuckyMoneyEnvelope",
		"INV_Scroll_11",
		"INV_Scroll_12",
		"INV_Scroll_13",
		"INV_Scroll_14",
		"INV_Scroll_15",
		"INV_Scroll_16",
		"INV_Misc_Map02",
		"INV_Misc_Map03",
		"INV_Misc_Map04",
		"INV_Misc_Map05",
		"INV_Misc_Map06",
		"INV_Misc_Map07",
		"INV_Misc_Map08",
		"INV_Misc_Map09",
		"INV_ValentinesCard01",
		"INV_ValentinesCard02",
		"INV_ValentinesCardTornLeft",
		"INV_ValentinesCardTornRight",
		"INV_Letter_18",
		"INV_Letter_19",
		"INV_Letter_20",
		"INV_Letter_21",
		"INV_Letter_22",
		"INV_Glyph_MajorDeathKnight", -- [352]
		"INV_Glyph_MajorDruid", -- [353]
		"INV_Glyph_MajorHunter", -- [354]
		"INV_Glyph_MajorMage", -- [355]
		"INV_Glyph_MajorPaladin", -- [356]
		"INV_Glyph_MajorPriest", -- [357]
		"INV_Glyph_MajorRogue", -- [358]
		"INV_Glyph_MajorShaman", -- [359]
		"INV_Glyph_MajorWarlock", -- [360]
		"INV_Glyph_MajorWarrior", -- [361]
		"INV_Glyph_MinorDeathKnight", -- [362]
		"INV_Glyph_MinorDruid", -- [363]
		"INV_Glyph_MinorHunter", -- [364]
		"INV_Glyph_MinorMage", -- [365]
		"INV_Glyph_MinorPaladin", -- [366]
		"INV_Glyph_MinorPriest", -- [367]
		"INV_Glyph_MinorRogue", -- [368]
		"INV_Glyph_MinorShaman", -- [369]
		"INV_Glyph_MinorWarlock", -- [370]
		"INV_Glyph_MinorWarrior", -- [371]
		"inv_glyph_primedeathknight",
		"inv_glyph_primedruid",
		"inv_glyph_primehunter",
		"inv_glyph_primemage",
		"inv_glyph_primepriest",
		"inv_glyph_primerogue",
		"inv_glyph_primeshaman",
		"inv_glyph_primewarlock",
		"inv_glyph_primewarrior",
		 "INV_Glyph_MajorMonk", 
		"INV_Glyph_MinorMonk", 
		"SOR-mail",
		"INV_Misc_CodexOfXerrath_chains", 
		"INV_Misc_CodexOfXerrath_NoChains", 
		"INV_Garrison_Blueprints1", 
		"INV_Garrison_Blueprints2", 
		"INV_Garrison_Blueprints3", 
		"INV_Garrison_Hearthstone", 
		"INV_Garrison_Resource", 
		"Icon_TreasureMap", 
	}
	GHM_StockIcons["Keys"] = {
		-- ok
		"INV_Misc_Key_01",
		"INV_Misc_Key_02",
		"INV_Misc_Key_03",
		"INV_Misc_Key_04",
		"INV_Misc_Key_05",
		"INV_Misc_Key_06",
		"INV_Misc_Key_07",
		"INV_Misc_Key_08",
		"INV_Misc_Key_09",
		"INV_Misc_Key_10",
		"INV_Misc_Key_11",
		"INV_Misc_Key_12",
		"INV_Misc_Key_13",
		"INV_Misc_Key_14",
		"INV_Misc_Key_15",
		"INV_chopper_alliance", 
		"INV_chopper_horde", 

	}
	GHM_StockIcons["Leatherworking"] = {
		-- ok
		"INV_Misc_ArmorKit_01",
		"INV_Misc_ArmorKit_02",
		"INV_Misc_ArmorKit_03",
		"INV_Misc_ArmorKit_04",
		"INV_Misc_ArmorKit_05",
		"INV_Misc_ArmorKit_06",
		"INV_Misc_ArmorKit_07",
		"INV_Misc_ArmorKit_08",
		"INV_Misc_ArmorKit_09",
		"INV_Misc_ArmorKit_10",
		"INV_Misc_ArmorKit_11",
		"INV_Misc_ArmorKit_12",
		"INV_Misc_ArmorKit_14",
		"INV_Misc_ArmorKit_15",
		"INV_Misc_ArmorKit_16",
		"INV_Misc_ArmorKit_17",
		"INV_Misc_ArmorKit_18",
		"INV_Misc_ArmorKit_19",
		"INV_Misc_ArmorKit_20",
		"INV_Misc_ArmorKit_21",
		"INV_Misc_ArmorKit_22",
		"INV_Misc_ArmorKit_23",
		"INV_Misc_ArmorKit_24",
		"INV_Misc_ArmorKit_25",
		"INV_Misc_ArmorKit_26",
		"INV_Misc_ArmorKit_27",
		"Inv_Misc_ArmorKit_MOP_00", 
		"Inv_Misc_ArmorKit_MOP_01", 
		"Inv_Misc_ArmorKit_MOP_02", 
		"Inv_Misc_ArmorKit_MOP_03", 
		"Inv_Misc_ArmorKit_MOP_04", 
		"INV_Misc_LeatherScrap_01",
		"INV_Misc_LeatherScrap_02",
		"INV_Misc_LeatherScrap_03",
		"INV_Misc_LeatherScrap_04",
		"INV_Misc_LeatherScrap_05",
		"INV_Misc_LeatherScrap_06",
		"INV_Misc_LeatherScrap_07",
		"INV_Misc_LeatherScrap_08",
		"INV_Misc_LeatherScrap_09",
		"INV_Misc_LeatherScrap_10",
		"INV_Misc_LeatherScrap_11",
		"INV_Misc_LeatherScrap_12",
		"INV_Misc_LeatherScrap_13",
		"INV_Misc_LeatherScrap_14",
		"INV_Misc_Quiver_01",
		"INV_Misc_Quiver_02",
		"INV_Misc_Quiver_03",
		"INV_Misc_Quiver_04",
		"INV_Misc_Quiver_05",
		"INV_Misc_Quiver_06",
		"INV_Misc_Quiver_07",
		"INV_Misc_Quiver_08",
		"INV_Misc_Quiver_09",
		"INV_Misc_Quiver_10",
		"INV_Misc_Pelt_01",
		"INV_Misc_Pelt_02",
		"INV_Misc_Pelt_03",
		"INV_Misc_Pelt_04",
		"INV_Misc_Pelt_05",
		"INV_Misc_Pelt_06",
		"INV_Misc_Pelt_Bear_01",
		"INV_Misc_Pelt_Bear_02",
		"INV_Misc_Pelt_Bear_03",
		"INV_Misc_Pelt_Bear_Ruin_01",
		"INV_Misc_Pelt_Bear_Ruin_02",
		"INV_Misc_Pelt_Bear_Ruin_03",
		"INV_Misc_Pelt_Bear_Ruin_04",
		"INV_Misc_Pelt_Bear_Ruin_05",
		"INV_Misc_Pelt_Boar_01",
		"INV_Misc_Pelt_Boar_02",
		"INV_Misc_Pelt_Boar_Ruin_01",
		"INV_Misc_Pelt_Boar_Ruin_02",
		"INV_Misc_Pelt_Boar_Ruin_03",
		"INV_Misc_Pelt_Wolf_01",
		"INV_Misc_Pelt_Wolf_02",
		"INV_Misc_Pelt_Wolf_Ruin_01",
		"INV_Misc_Pelt_Wolf_Ruin_02",
		"INV_Misc_Pelt_Wolf_Ruin_03",
		"INV_Misc_Pelt_Wolf_Ruin_04",
		"INV_Misc_Organ_07",
		"INV_Misc_Organ_08",
		"INV_Misc_Organ_09",
		"INV_Misc_Organ_10",
		"INV_Misc_Organ_11",
		"INV_Misc_Pelt_07",
		"INV_Misc_Pelt_08",
		"INV_Misc_Pelt_09",
		"INV_Misc_Pelt_10",
		"INV_Misc_Pelt_11",
		"INV_Misc_Pelt_12",
		"INV_Misc_Pelt_13",
		"INV_Misc_Pelt_14",
		"INV_Misc_LeatherScrap_15",
		"INV_Misc_LeatherScrap_16",
		"INV_Misc_LeatherScrap_17",
		"INV_Misc_LeatherScrap_18",
		"INV_Misc_LeatherScrap_19",
		"INV_Misc_ArmorKit_28",
		"INV_Misc_ArmorKit_29",
		"INV_Misc_ArmorKit_30",
		"INV_Misc_ArmorKit_31",
		"INV_Misc_ArmorKit_32",
		"INV_Misc_ArmorKit_33",
		"INV_Misc_Pelt_Arctic_01", -- [487]
		"INV_Misc_Pelt_Arctic_02", -- [488]
		"inv_misc_deepseascales",
		"inv_misc_legarmorkit",
		"inv_misc_savagearmorkit",
		"inv_misc_heavysavagearmorkit",
		"inv_misc_desecrated_leatherglove",
		"inv_misc_leather_shellfragment",
		"INV_Tradeskill_Skinning_PrismaticScale", 
		"INV_Tradeskill_Skinning_ShaLeather", 
		"INV_Tradeskill_Skinning_ShaLeatherScraps", 
		"INV_Misc_Pelt_15", 
		"INV_Misc_BondedLeather", 
		"INV_misc_nativebeastfur", 
 "INV_Misc_NativeBeastSkin", 
 "INV_Misc_NativeBeastSkin_Scrap", 
  "INV_Misc_StarTannedLeather", 
	}
	GHM_StockIcons["Engineering"] = {
		-- ok
		"INV_Battery_01",
		"INV_Battery_02",
		"INV_Gizmo_01",
		"INV_Gizmo_02",
		"INV_Gizmo_03",
		"INV_Gizmo_04",
		"INV_Gizmo_05",
		"INV_Gizmo_06",
		"INV_Gizmo_07",
		"INV_Gizmo_08",
		"INV_Gizmo_09",
		"INV_Gizmo_BronzeFramework_01",
		"INV_Gizmo_GoblinBoomBox_01",
		"INV_Gizmo_MithrilCasing_01",
		"INV_Gizmo_MithrilCasing_02",
		"INV_Gizmo_Pipe_01",
		"INV_Gizmo_Pipe_02",
		"INV_Gizmo_Pipe_03",
		"INV_Gizmo_Pipe_04",
		"INV_Gizmo_RocketBoot_01",
		"INV_Gizmo_RocketBoot_Destroyed_02",
		"INV_Misc_Bomb_01",
		"INV_Misc_Bomb_02",
		"INV_Misc_Bomb_03",
		"INV_Misc_Bomb_04",
		"INV_Misc_Bomb_05",
		"INV_Misc_Bomb_06",
		"INV_Misc_Bomb_07",
		"INV_Misc_Bomb_08",
		"INV_Misc_Bomb_09",
		"INV_Misc_Gear_01",
		"INV_Misc_Gear_02",
		"INV_Misc_Gear_03",
		"INV_Misc_Gear_04",
		"INV_Misc_Gear_05",
		"INV_Misc_Gear_06",
		"INV_Misc_Gear_07",
		"INV_Misc_Gear_08",
		"INV_Gizmo_AdamantiteFrame",
		"INV_Gizmo_AdamantiteShells",
		"INV_Gizmo_ElementalBlastingPowder",
		"INV_Gizmo_FelIronBolts",
		"INV_Gizmo_FelIronBomb",
		"INV_Gizmo_FelIronCasing",
		"INV_Gizmo_FelIronShell",
		"INV_Gizmo_FelStabilizer",
		"INV_Gizmo_GnomishFlameTurret",
		"INV_Gizmo_GoblingTonkController",
		"INV_Gizmo_HardenedAdamantiteTube",
		"INV_Gizmo_HealthPotionPack",
		"INV_Gizmo_KhoriumPowerCore",
		"INV_Gizmo_ManaPotionPack",
		"INV_Gizmo_ManaSyphon",
		"INV_Gizmo_NewGoggles",
		"INV_Gizmo_Poltryiser_01",
		"INV_Gizmo_RocketBootExtreme",
		"INV_Gizmo_RocketLauncher",
		"INV_Gizmo_Scope01",
		"INV_Gizmo_Scope02",
		"INV_Gizmo_SuperSapperCharge",
		"INV_Gizmo_TheBiggerOne",
		"INV_Gizmo_ZapThrottleGasCollector",
		"INV_Misc_Dust_01",
		"INV_Misc_Dust_02",
		"INV_Misc_Dust_03",
		"INV_Misc_Dust_04",
		"INV_Misc_Dust_05",
		"INV_Misc_Dust_06",
		"INV_Misc_EngGizmos_01",
		"INV_Misc_EngGizmos_02",
		"INV_Misc_EngGizmos_03",
		"INV_Misc_EngGizmos_04",
		"INV_Misc_EngGizmos_05",
		"INV_Misc_EngGizmos_06",
		"INV_Misc_EngGizmos_07",
		"INV_Misc_EngGizmos_08",
		"INV_Misc_EngGizmos_09",
		"INV_Misc_EngGizmos_10",
		"INV_Misc_EngGizmos_11",
		"INV_Misc_EngGizmos_12",
		"INV_Misc_EngGizmos_13",
		"INV_Misc_EngGizmos_14",
		"INV_Misc_EngGizmos_15",
		"INV_Misc_EngGizmos_16",
		"INV_Misc_EngGizmos_17",
		"INV_Misc_EngGizmos_18",
		"INV_Misc_EngGizmos_19",
		"INV_Misc_EngGizmos_20",
		"INV_Misc_EngGizmos_21",
		"INV_Misc_EngGizmos_23",
		"INV_Misc_EngGizmos_24",
		"INV_Misc_EngGizmos_40", 
		"INV_Misc_EngGizmos_41",
		"INV_Misc_EngGizmos_EssenceDistiller",
		"INV_Misc_MissileLarge_Blue",
		"INV_Misc_MissileLarge_Green",
		"INV_Misc_MissileLarge_Purple",
		"INV_Misc_MissileLarge_Red",
		"INV_Misc_MissileLarge_White",
		"INV_Misc_MissileLarge_Yellow",
		"INV_Misc_MissileLargeCluster_Blue",
		"INV_Misc_MissileLargeCluster_Green",
		"INV_Misc_MissileLargeCluster_Purple",
		"INV_Misc_MissileLargeCluster_Red",
		"INV_Misc_MissileLargeCluster_White",
		"INV_Misc_MissileLargeCluster_Yellow",
		"INV_Misc_MissileSmall_Blue",
		"INV_Misc_MissileSmall_Green",
		"INV_Misc_MissileSmall_Purple",
		"INV_Misc_MissileSmall_Red",
		"INV_Misc_MissileSmall_White",
		"INV_Misc_MissileSmall_Yellow",
		"INV_Misc_MissileSmallCluster_Blue",
		"INV_Misc_MissileSmallCluster_Green",
		"INV_Misc_MissileSmallCluster_Purple",
		"INV_Misc_MissileSmallCluster_Red",
		"INV_Misc_MissileSmallCluster_White",
		"INV_Misc_MissileSmallCluster_Yellow",
		"INV_Misc_Powder_Adamantite",
		"INV_Misc_Powder_Black",
		"INV_Misc_Powder_Blue",
		"INV_Misc_Powder_Copper",
		"INV_Misc_Powder_Feliron",
		"INV_Misc_Powder_Green",
		"INV_Misc_Powder_Iron",
		"INV_Misc_Powder_Mithril",
		"INV_Misc_Powder_Purple",
		"INV_Misc_Powder_Thorium",
		"INV_Misc_Powder_Tin",
		"INV_Misc_ScrewDriver_01",
		"INV_Misc_ScrewDriver_02",
		"INV_Misc_Spyglass_01",
		"INV_Misc_Spyglass_02",
		"INV_Misc_Spyglass_03",
		"INV_Misc_Wrench_01",
		"INV_Misc_Wrench_02",
		"INV_Gizmo_FuelCell",
		"INV_GIZMO_MANAPOTIONPACK",
		"INV_Misc_EngGizmos_25",
		"INV_Misc_EngGizmos_26",
		"INV_Misc_EngGizmos_27",
		"INV_Misc_EngGizmos_28",
		"INV_Misc_EngGizmos_29",
		"INV_Misc_EngGizmos_30",
		"INV_Misc_EngGizmos_31",
		"INV_Misc_EngGizmos_32",
		"INV_Misc_EngGizmos_RocketChicken",
		"INV_Misc_EngGizmos_swissArmy",
		"INV_ValentinePinkRocket",
		"INV_SummerFest_GroundFlower",
		"INV_Gizmo_RunicHealthInjector", -- [350]
		"INV_Gizmo_RunicManaInjector", -- [351]
		"INV_Misc_DiscoBall_01", -- [470]
		"INV_Misc_MohawkGrenade", -- [482]

		"inv_misc_molle",
		"inv_misc_blackironbomb",
		"inv_misc_pyriumgrenade",
		"inv_misc_scopea",
		"inv_misc_scopeb",
		"inv_misc_scopec",
		"INV_Misc_Landshark",
		"INV_Eng_BottledElements", 
		"INV_Eng_ClockworkEgg", 
		"INV_Eng_Crate", 
		"INV_Eng_Crate2", 
		"INV_Eng_GearspringParts", 
		"INV_Eng_gizmo1", 
		"INV_Eng_Gizmo2", 
		"INV_Eng_Gizmo3", 
		"INV_Eng_MechanicalBoomerang", 
		"INV_Eng_MechanicalBoomerang2", 
		"INV_Eng_MetalBlingronEar", 
		"INV_Eng_PuresteelBolts", 
		}
	GHM_StockIcons["Fishing"] = {
		-- ok
		"INV_FISHINGCHAIR",
		"INV_Fishingpole_05", -- [324]
		"INV_Fishingpole_06", -- [325]
		"INV_Fishingpole_01",
		"INV_Fishingpole_02",
		"INV_Misc_Crop_01",
		"INV_Misc_Crop_02",
		"INV_Fishingpole_03",
		"INV_Misc_Hook_01",
		"INV_Misc_2H_bamboo_fishing", 
		"INV_Misc_2H_panda_fishing", 
		"Achievement_Profession_Fishing_FindFish", -- [178]
		"Achievement_Profession_Fishing_JourneymanFisher", -- [179]
		"Achievement_Profession_Fishing_NorthrendAngler", -- [180]
		"Achievement_Profession_Fishing_OldManBarlowned", -- [181]
		"Achievement_Profession_Fishing_OutlandAngler", -- [182]
		"INV_Fishing_Innards_Pearl", 
		"INV_Fishing_Innards_PearlBlack", 
		"INV_Fishing_Lure_Clam", 
		"INV_Fishing_Lure_Donut", 
		"INV_Fishing_Lure_Frogfish", 
		"INV_Fishing_Lure_Jalapeno", 
		"INV_Fishing_Lure_Kelp", 
		"INV_Fishing_Lure_Sandcrab", 
		"INV_Fishing_Lure_Starfish", 
		"INV_Fishing_Lure_Worm", 
	}
	GHM_StockIcons["Enchanting"] = {
		-- ok
		"INV_Enchant_DustDream",
		"INV_Enchant_DustIllusion",
		"INV_Enchant_DustSoul",
		"INV_Enchant_DustStrange",
		"INV_Enchant_DustVision",
		"INV_Enchant_DustArcane",
		"INV_Enchant_EssenceArcaneLarge",
		"INV_Enchant_EssenceArcaneSmall",
		"INV_Enchant_EssenceAstralLarge",
		"INV_Enchant_EssenceAstralSmall",
		"INV_Enchant_EssenceEternalLarge",
		"INV_Enchant_EssenceEternalSmall",
		"INV_Enchant_EssenceMagicLarge",
		"INV_Enchant_EssenceMagicSmall",
		"INV_Enchant_EssenceMysticalLarge",
		"INV_Enchant_EssenceMysticalSmall",
		"INV_Enchant_EssenceNetherLarge",
		"INV_Enchant_EssenceNetherSmall",
		"INV_Enchant_PrismaticSphere",
		"INV_Enchant_ShardBrilliantLarge",
		"INV_Enchant_ShardBrilliantSmall",
		"INV_Enchant_ShardGleamingSmall",
		"INV_Enchant_ShardGlimmeringLarge",
		"INV_Enchant_ShardGlimmeringSmall",
		"INV_Enchant_ShardGlowingLarge",
		"INV_Enchant_ShardGlowingSmall",
		"INV_Enchant_ShardNexusLarge",
		"INV_Enchant_ShardPrismaticLarge",
		"INV_Enchant_ShardPrismaticSmall",
		"INV_Enchant_ShardRadientLarge",
		"INV_Enchant_ShardRadientSmall",
		"INV_Enchant_VoidCrystal",
		"INV_Enchant_VoidSphere",
		"INV_Rod_Adamantite",
		"INV_Rod_EnchantedAdamantite",
		"INV_Rod_EnchantedEternium",
		"INV_Rod_EnchantedFelsteel",
		"INV_Rod_Eternium",
		"INV_Rod_Felsteel",
		"INV_Rod_Cobalt",
		"INV_Rod_EnchantedCobalt",
		"INV_Rod_Platinum",
		"INV_Rod_Titanium",
		"INV_Enchant_AbyssCrystal",
		"INV_Enchant_Disenchant",
		"INV_Enchant_DreamShard_01",
		"INV_Enchant_DreamShard_02",
		"INV_Enchant_EssenceCosmicGreater",
		"INV_Enchant_EssenceCosmicLesser",
		"INV_Enchant_FormulaEpic_01",
		"INV_Enchant_FormulaGood_01",
		"INV_Enchant_FormulaSuperior_01",
		"INV_Misc_Dust_Infinite",
		"INV_Enchant_ShardShadowfrostLarge", -- [322]

		"inv_misc_dust",
		"inv_misc_enchantedelementiumrod",
		"inv_misc_enchantedpyriumrod",
		"inv_misc_enchantedscroll",
		"inv_misc_greateressence",
		"inv_misc_lesseressence",
		"inv_misc_smallshard_superior",
		"inv_enchant_dust",
		 "Trade_Enchanting_GreaterMysteriousEssence", 
		"Trade_Enchanting_LargeEtherealShard", 
		"Trade_Enchanting_LesserMysteriousEssence", 
		"Trade_Enchanting_SmallEtherealShard", 
		"INV_Enchanting_WOD_crystal", 
		"INV_Enchanting_WOD_crystal2", 
		"INV_Enchanting_WOD_crystal3", 
		"INV_Enchanting_WOD_crystal4", 
		"INV_Enchanting_WOD_crystalbundle", 
		"INV_Enchanting_WOD_crystalshard", 
		"INV_Enchanting_WOD_crystalshard2", 
		"INV_Enchanting_WOD_crystalshard3", 
		"INV_Enchanting_WOD_crystalshard4", 
		"INV_Enchanting_WOD_dust", 
		"INV_Enchanting_WOD_dust2", 
		"INV_Enchanting_WOD_dust3", 
		"INV_Enchanting_WOD_dust4", 
		"INV_Enchanting_WOD_essence", 
		"INV_Enchanting_WOD_essence2", 
		"INV_Enchanting_WOD_essence3", 
		"INV_Enchanting_WOD_essence4", 
		"INV_Enchant_AlchemistCauldron", 
		"INV_Enchant_AlchemyCatalyst", 
		"INV_Enchant_CrescentOil", 
		"INV_Enchant_MetamorphicCrystal", 
		"INV_Enchant_PhiloStone_Lv1", 
		"INV_Enchant_PhiloStone_Lv2", 
		"INV_Enchant_ShaperEssence", 
	}
	GHM_StockIcons["Tailoring"] = {
		-- ok
		"INV_Fabric_Felcloth_Ebon",
		"INV_Fabric_FelRag",
		"INV_Fabric_Linen_01",
		"INV_Fabric_Linen_02",
		"INV_Fabric_Linen_03",
		"INV_Fabric_Mageweave_01",
		"INV_Fabric_Mageweave_02",
		"INV_Fabric_Mageweave_03",
		"INV_Fabric_MoonRag_01",
		"INV_Fabric_MoonRag_02",
		"INV_Fabric_MoonRag_Primal",
		"INV_Fabric_Netherweave",
		"INV_Fabric_Netherweave_Bolt",
		"INV_Fabric_Netherweave_Bolt_Imbued",
		"INV_Fabric_Purple_01",
		"INV_Fabric_Purple_02",
		"INV_Fabric_PurpleFire_01",
		"INV_Fabric_PurpleFire_02",
		"INV_Fabric_Silk_01",
		"INV_Fabric_Silk_02",
		"INV_Fabric_Silk_03",
		"INV_Fabric_Soulcloth",
		"INV_Fabric_Soulcloth_Bolt",
		"INV_Fabric_Spellfire",
		"INV_Fabric_Wool_01",
		"INV_Fabric_Wool_02",
		"INV_Fabric_Wool_03",
		"INV_Misc_ClothScrap_01",
		"INV_Misc_ClothScrap_02",
		"INV_Misc_ClothScrap_03",
		"INV_Misc_ClothScrap_04",
		"INV_Misc_ClothScrap_05",
		"INV_Fabric_Ebonweave",
		"INV_Fabric_Frostweave_Bolt",
		"INV_Fabric_Frostweave_ImbuedBolt",
		"INV_Fabric_Moonshroud",
		"INV_Fabric_Spellweave",
		"INV_Misc_Thread_01",
		"INV_Misc_Thread_Eternium",

		"inv_misc_embercloth",
		"inv_misc_emberclothbolt",
		"inv_misc_embroidery",
		"inv_misc_imbuedembercloth",
		"INV_Fabric_ImperialSilk", 
		"INV_Fabric_Windwool", 
		"INV_Fabric_Windwool_Bolt", 
		"INV_Fabric_Windwool_Bolt_Imbued",
		"INV_Fabric_Celestial_cloth", 	
		 
		"INV_tailoring_hexweavebag", 
		"INV_tailoring_hexweavecloth", 
		"INV_tailoring_hexweavethread", 

	}
	GHM_StockIcons["First Aid"] = {
		-- ok
		"INV_Misc_Bandage_01",
		"INV_Misc_Bandage_02",
		"INV_Misc_Bandage_03",
		"INV_Misc_Bandage_04",
		"INV_Misc_Bandage_05",
		"INV_Misc_Bandage_06",
		"INV_Misc_Bandage_07",
		"INV_Misc_Bandage_08",
		"INV_Misc_Bandage_09",
		"INV_Misc_Bandage_10",
		"INV_Misc_Bandage_11",
		"INV_Misc_Bandage_12",
		"INV_Misc_Bandage_13",
		"INV_Misc_Bandage_14",
		"INV_Misc_Bandage_15",
		"INV_Misc_Bandage_16",
		"INV_Misc_Bandage_17",
		"INV_Misc_Bandage_18",
		"INV_Misc_Bandage_19",
		"INV_Misc_Bandage_20",
		"INV_Misc_Bandage_Frostweave",
		"INV_Misc_Bandage_Frostweave_Heavy",
		"INV_Misc_Bandage_Netherweave",
		"INV_Misc_Bandage_Netherweave_Heavy",
		"INV_Holiday_ToW_SpiceBandage",

		"inv_misc_emberweavebandage",
		"inv_misc_emberweavebandagelight",
		"inv_emberweavebandage1",
		"inv_emberweavebandage2",
		"INV_Misc_Bandage_Windwool", 
		"INV_Misc_Bandage_Windwool_Heavy", 
		"INV_Firstaid_Bandage", 
		"INV_Firstaid_Bandage2", 
		"INV_Firstaid_Healingsalve", 
		"INV_Firstaid_Healingsalve2", 
	}
	GHM_StockIcons["Mining"] = {
		-- ok
		"INV_Ingot_01",
		"INV_Ingot_02",
		"INV_Ingot_03",
		"INV_Ingot_04",
		"INV_Ingot_05",
		"INV_Ingot_06",
		"INV_Ingot_07",
		"INV_Ingot_08",
		"INV_Ingot_09",
		"INV_Ingot_10",
		"INV_Ingot_11",
		"INV_Ingot_Adamantite",
		"INV_Ingot_Bronze",
		"INV_Ingot_Eternium",
		"INV_Ingot_FelIron",
		"INV_Ingot_Felsteel",
		"INV_Ingot_Iron",
		"INV_Ingot_Mithril",
		"INV_Ingot_Steel",
		"INV_Ingot_Thorium",
		"INV_Ore_Adamantium",
		"INV_Ore_Adamantium_01",
		"INV_Ore_Arcanite_01",
		"INV_Ore_Arcanite_02",
		"INV_Ore_Copper_01",
		"INV_Ore_Eternium",
		"INV_Ore_Ethernium_01",
		"INV_Ore_FelIron",
		"INV_Ore_FelIron_01",
		"INV_Ore_Gold_01",
		"INV_Ore_Iron_01",
		"INV_Ore_Khorium",
		"INV_Ore_Khorium_01",
		"INV_Ore_Mithril_01",
		"INV_Ore_Mithril_02",
		"INV_Ore_Thorium_01",
		"INV_Ore_Thorium_02",
		"INV_Ore_Tin_01",
		"INV_Ore_TrueSilver_01",
		"INV_Pick_01",
		"INV_Pick_02",
		"INV_Pick_03",
		"INV_Pick_05",
		"INV_Stone_GrindingStone_01",
		"INV_Stone_GrindingStone_02",
		"INV_Stone_GrindingStone_03",
		"INV_Stone_GrindingStone_04",
		"INV_Stone_GrindingStone_05",
		"INV_Stone_SharpeningStone_01",
		"INV_Stone_SharpeningStone_02",
		"INV_Stone_SharpeningStone_03",
		"INV_Stone_SharpeningStone_04",
		"INV_Stone_SharpeningStone_05",
		"INV_Stone_WeightStone_01",
		"INV_Stone_WeightStone_02",
		"INV_Stone_WeightStone_03",
		"INV_Stone_WeightStone_04",
		"INV_Stone_WeightStone_05",
		"INV_TradeskillItem_01",
		"INV_TradeskillItem_02",
		"INV_TradeskillItem_03",
		"INV_Stone_01",
		"INV_Stone_02",
		"INV_Stone_03",
		"INV_Stone_04",
		"INV_Stone_05",
		"INV_Stone_06",
		"INV_Stone_07",
		"INV_Stone_08",
		"INV_Stone_09",
		"INV_Stone_10",
		"INV_Stone_11",
		"INV_Stone_12",
		"INV_Stone_13",
		"INV_Stone_14",
		"INV_Stone_15",
		"INV_Stone_16",
		"INV_Ore_Cobalt",
		"INV_Ore_Platinum_01",
		"INV_Ore_Saronite_01",
		"INV_Stone_WeightStone_06",
		"INV_Stone_WeightStone_07",
		"INV_Stone_WeightStone_08",
		"INV_Stone_SharpeningStone_06",
		"INV_Stone_SharpeningStone_07",
		"INV_Ingot_Cobalt",
		"INV_Ingot_Platinum",
		"INV_Ingot_Titansteel_blue",
		"INV_Ingot_Titansteel_dark",
		"INV_Ingot_Titansteel_red",
		"INV_Ingot_Yoggthorite",
		"inv_misc_blackironore",
		"inv_misc_ebonsteelbar",
		"inv_misc_elementiumrod",
		"inv_misc_pyriumbar",
		"inv_misc_pyriumore",
		"inv_misc_pyriumrod",
		"INV_INGOT_GHOSTIRON", 
		"INV_Ingot_LivingSteel", 
		"INV_Ingot_Manticyte", 
		"INV_Ingot_Trillium", 
		"INV_ORE_GHOSTIRON", 
		"INV_Ore_Manticyte", 
		"INV_Ore_TrilliumBlack", 
		"INV_Ore_TrilliumWhite", 
		"INV_Ingot_Trillium_balanced", 
		"INV_Ore_BlackTrilliumNugget", 
		"INV_Ore_GhostIronNugget", 
		"INV_Ore_ManticyteNugget", 
		"INV_Ore_WhiteTrilliumNugget", 
		 "INV_misc_trueironingot", 
		"INV_misc_truesteelingot", 
		 "INV_Ore_Adamantite_Nugget", 
		"INV_Ore_Blackrock_Nugget", 
		"INV_Ore_Blackrock_Ore", 
		"INV_Ore_Cobalt_Nugget", 
		"INV_Ore_Elementium_Nugget", 
		"INV_Ore_Eternium_Nugget", 
		"INV_Ore_Feliron_Nugget", 
		"INV_Ore_Gold_Nugget", 
		"INV_Ore_Iron_Nugget", 
		"INV_Ore_Khorium_Nugget", 
		"INV_Ore_Mithril_Nugget", 
		"INV_Ore_Obsidium_Nugget", 
		"INV_Ore_Pyrite_Nugget", 
		"INV_Ore_Saronite_Nugget", 
		"INV_Ore_Silver_Nugget", 
		"INV_Ore_Thorium_Nugget", 
		"INV_Ore_Tin_Nugget", 
		"INV_Ore_Titanium_Nugget", 
		"INV_Ore_TrueIronOre", 
		"INV_Ore_TrueIron_Nugget", 
		"INV_Ore_Trusilver_Nugget", 
	}
	GHM_StockIcons["Inscription"] = {
		-- ok
		"INV_Inscription_ArmorScroll01",
		"INV_Inscription_ArmorScroll02",
		"INV_Inscription_ArmorScroll03",
		"INV_Inscription_Certificate",
		"INV_Inscription_InkBlack01",
		"INV_Inscription_InkBlack02",
		"INV_Inscription_InkBlack03",
		"INV_Inscription_InkBlack04",
		"INV_Inscription_InkBlueWhite01",
		"INV_Inscription_InkBlueWhite02",
		"INV_Inscription_InkBlueWhite03",
		"INV_Inscription_InkBlueWhite04",
		"INV_Inscription_InkGreen01",
		"INV_Inscription_InkGreen02",
		"INV_Inscription_InkGreen03",
		"INV_Inscription_InkGreen04",
		"INV_Inscription_InkOrange01",
		"INV_Inscription_InkOrange02",
		"INV_Inscription_InkOrange03",
		"INV_Inscription_InkOrange04",
		"INV_Inscription_InkPurple01",
		"INV_Inscription_InkPurple02",
		"INV_Inscription_InkPurple03",
		"INV_Inscription_InkPurple04",
		"INV_Inscription_InkRed01",
		"INV_Inscription_InkRed02",
		"INV_Inscription_InkRed03",
		"INV_Inscription_InkRed04",
		"INV_Inscription_InkSilver01",
		"INV_Inscription_InkSilver02",
		"INV_Inscription_InkSilver03",
		"INV_Inscription_InkSilver04",
		"INV_Inscription_InkWhite01",
		"INV_Inscription_InkWhite02",
		"INV_Inscription_InkWhite03",
		"INV_Inscription_InkWhite04",
		"INV_Inscription_InkYellow01",
		"INV_Inscription_InkYellow02",
		"INV_Inscription_InkYellow03",
		"INV_Inscription_InkYellow04",
		"INV_Inscription_MajorGlyph00",
		"INV_Inscription_MajorGlyph01",
		"INV_Inscription_MajorGlyph02",
		"INV_Inscription_MajorGlyph03",
		"INV_Inscription_MajorGlyph04",
		"INV_Inscription_MajorGlyph05",
		"INV_Inscription_MajorGlyph06",
		"INV_Inscription_MajorGlyph07",
		"INV_Inscription_MajorGlyph08",
		"INV_Inscription_MajorGlyph09",
		"INV_Inscription_MajorGlyph10",
		"INV_Inscription_MajorGlyph11",
		"INV_Inscription_MajorGlyph12",
		"INV_Inscription_MajorGlyph13",
		"INV_Inscription_MajorGlyph14",
		"INV_Inscription_MajorGlyph15",
		"INV_Inscription_MajorGlyph16",
		"INV_Inscription_MajorGlyph17",
		"INV_Inscription_MajorGlyph18",
		"INV_Inscription_MajorGlyph19",
		"INV_Inscription_MajorGlyph20",
		"INV_Inscription_MinorGlyph00",
		"INV_Inscription_MinorGlyph01",
		"INV_Inscription_MinorGlyph02",
		"INV_Inscription_MinorGlyph03",
		"INV_Inscription_MinorGlyph04",
		"INV_Inscription_MinorGlyph05",
		"INV_Inscription_MinorGlyph06",
		"INV_Inscription_MinorGlyph07",
		"INV_Inscription_MinorGlyph08",
		"INV_Inscription_MinorGlyph09",
		"INV_Inscription_MinorGlyph10",
		"INV_Inscription_MinorGlyph11",
		"INV_Inscription_MinorGlyph12",
		"INV_Inscription_MinorGlyph13",
		"INV_Inscription_MinorGlyph14",
		"INV_Inscription_MinorGlyph15",
		"INV_Inscription_MinorGlyph16",
		"INV_Inscription_MinorGlyph17",
		"INV_Inscription_MinorGlyph18",
		"INV_Inscription_MinorGlyph19",
		"INV_Inscription_MinorGlyph20",
		"INV_Inscription_Papyrus",
		"INV_Inscription_Parchment",
		"INV_Inscription_ParchmentVar01",
		"INV_Inscription_ParchmentVar02",
		"INV_Inscription_ParchmentVar03",
		"INV_Inscription_ParchmentVar04",
		"INV_Inscription_ParchmentVar05",
		"INV_Inscription_ParchmentVar06",
		"INV_Inscription_Pigment_Azure",
		"INV_Inscription_Pigment_Bug01",
		"INV_Inscription_Pigment_Bug02",
		"INV_Inscription_Pigment_Bug03",
		"INV_Inscription_Pigment_Bug04",
		"INV_Inscription_Pigment_Bug05",
		"INV_Inscription_Pigment_Bug06",
		"INV_Inscription_Pigment_Bug07",
		"INV_Inscription_Pigment_Burnt",
		"INV_Inscription_Pigment_Ebon",
		"INV_Inscription_Pigment_Emerald",
		"INV_Inscription_Pigment_Golden",
		"INV_Inscription_Pigment_Grey",
		"INV_Inscription_Pigment_Icy",
		"INV_Inscription_Pigment_Indigo",
		"INV_Inscription_Pigment_Nether",
		"INV_Inscription_Pigment_Ruby",
		"INV_Inscription_Pigment_Sapphire",
		"INV_Inscription_Pigment_Silvery",
		"INV_Inscription_Pigment_Verdant",
		"INV_Inscription_Pigment_Violet",
		"INV_Inscription_Pigment_White",
		"INV_Inscription_Scroll",
		"INV_Inscription_TarotBerserker",
		"INV_Inscription_TarotChaos",
		"INV_Inscription_TarotDeath",
		"INV_Inscription_TarotGreatness",
		"INV_Inscription_TarotIllusion",
		"INV_Inscription_TarotLords",
		"INV_Inscription_TarotPrism",
		"INV_Inscription_TarotUndeath",
		"INV_Inscription_Tradeskill01",
		"INV_Inscription_WeaponScroll01",
		"INV_Inscription_WeaponScroll02",
		"INV_Inscription_WeaponScroll03",
		"INV_Inscription_Crane", 
		"INV_Inscription_deck_BlackOx", 
		"INV_Inscription_Deck_JadeSerpent", 
		"INV_Inscription_deck_RedCrane", 
		"INV_Inscription_Deck_WhiteTiger", 
		"INV_Inscription_Frog", 
		"INV_Inscription_Ink_Dreams", 
		"INV_Inscription_Ink_Starlight", 
		"INV_Inscription_Pigment_Misty", 
		"INV_Inscription_Pigment_Shadow", 
		"INV_Inscription_RunescrollOfFortitude_Blue", 
		"INV_Inscription_RunescrollOfFortitude_Green", 
		"INV_Inscription_RunescrollOfFortitude_Red", 
		"INV_Inscription_RunescrollOfFortitude_Yellow", 
		"INV_Inscription_ScrollOfWisdom_01", 
		"INV_Inscription_ScrollOfWisdom_02", 
		"INV_Inscription_TomeOfTheClearMind", 
		"INV_Inscription_Tooltip_DarkmoonCard_MOP", 
		"INV_Inscription_Trinket_Crane", 
		"INV_Inscription_Trinket_Dragon", 
		"INV_Inscription_Trinket_Ox", 
		"INV_Inscription_Trinket_Tiger",
	"Tradeskill_Inscription_BlackOx", 
	"Tradeskill_Inscription_JadeSerpent", 
	"Tradeskill_Inscription_RedCrane", 
	"Tradeskill_Inscription_WhiteTiger", 	
	"INV_Inscription_InkCerulean01", 
	"INV_Inscription_InkCerulean02", 
	"INV_Inscription_InkCerulean03", 
	"INV_Inscription_Pigment_Cerulean", 
	"INV_Inscription_Pigment_Pink", 
	"INV_Inscription_Pigment_Silver", 
	"INV_Inscription_Scroll_Fortitude", 
	"INV_Inscription_Scroll_Kings", 
	"INV_Inscription_Tarot_6oHealerCard", 
	"INV_Inscription_Tarot_6oHealerDeck", 
	"INV_Inscription_Tarot_6oMageCard", 
	"INV_Inscription_Tarot_6oMageDeck", 
	"INV_Inscription_Tarot_6oMeleeCard", 
	"INV_Inscription_Tarot_6oMeleeDeck", 
	"INV_Inscription_Tarot_6oTankCard", 
	"INV_Inscription_Tarot_6oTankDeck", 
	"INV_Inscription_Trinket_Healer", 
	"INV_Inscription_Trinket_Mage", 
	"INV_Inscription_Trinket_Melee", 
	"INV_Inscription_Trinket_Tank", 
	"INV_Inscription_Warpaint_Blue", 
	"INV_Inscription_Warpaint_Red",  
	}
	GHM_StockIcons["Jewelcrafting"] = {
		-- ok

		"INV_Jewelcrafting_BlackPearlPanther",
		"INV_Jewelcrafting_BronzeSetting",
		"INV_Jewelcrafting_CrimsonSpinel_01",
		"INV_Jewelcrafting_CrimsonSpinel_02",
		"INV_Jewelcrafting_Dawnstone_01",
		"INV_Jewelcrafting_Dawnstone_02",
		"INV_Jewelcrafting_Dawnstone_03",
		"INV_Jewelcrafting_DelicateCopperWire",
		"INV_Jewelcrafting_EmpyreanSapphire_01",
		"INV_Jewelcrafting_EmpyreanSapphire_02",
		"INV_Jewelcrafting_GoldenHare",
		"INV_Jewelcrafting_JadeOwl",
		"INV_Jewelcrafting_Lionseye_01",
		"INV_Jewelcrafting_Lionseye_02",
		"INV_Jewelcrafting_LivingRuby_01",
		"INV_Jewelcrafting_LivingRuby_02",
		"INV_Jewelcrafting_LivingRuby_03",
		"INV_Jewelcrafting_MithrilFiligree",
		"INV_Jewelcrafting_Nightseye_01",
		"INV_Jewelcrafting_Nightseye_02",
		"INV_Jewelcrafting_Nightseye_03",
		"INV_Jewelcrafting_NobleTopaz_01",
		"INV_Jewelcrafting_NobleTopaz_02",
		"INV_Jewelcrafting_NobleTopaz_03",
		"INV_Jewelcrafting_Pyrestone_01",
		"INV_Jewelcrafting_Pyrestone_02",
		"INV_Jewelcrafting_RubySerpent",
		"INV_Jewelcrafting_SeasprayEmerald_01",
		"INV_Jewelcrafting_SeasprayEmerald_02",
		"INV_Jewelcrafting_ShadowsongAmethyst_01",
		"INV_Jewelcrafting_ShadowsongAmethyst_02",
		"INV_Jewelcrafting_StarOfElune_01",
		"INV_Jewelcrafting_StarOfElune_02",
		"INV_Jewelcrafting_StarOfElune_03",
		"INV_Jewelcrafting_Talasite_01",
		"INV_Jewelcrafting_Talasite_02",
		"INV_Jewelcrafting_Talasite_03",
		"INV_Jewelcrafting_ThoriumSetting",
		"INV_Jewelcrafting_TruesilverBoar",
		"INV_Jewelcrafting_TruesilverCrab",
		"INV_Misc_Gem_01",
		"INV_Misc_Gem_02",
		"INV_Misc_Gem_03",
		"INV_Misc_Gem_Amethyst_01",
		"INV_Misc_Gem_Amethyst_02",
		"INV_Misc_Gem_Amethyst_03",
		"INV_Misc_Gem_AmethystRough_01",
		"INV_Misc_Gem_AzureDraenite_01",
		"INV_Misc_Gem_AzureDraenite_02",
		"INV_Misc_Gem_AzureDraenite_03",
		"INV_Misc_Gem_Crystal_01",
		"INV_Misc_Gem_Crystal_02",
		"INV_Misc_Gem_Crystal_03",
		"INV_Misc_Gem_CrystalCut_01",
		"INV_Misc_Gem_DeepPeridot_01",
		"INV_Misc_Gem_DeepPeridot_02",
		"INV_Misc_Gem_DeepPeridot_03",
		"INV_Misc_Gem_Diamond_01",
		"INV_Misc_Gem_Diamond_02",
		"INV_Misc_Gem_Diamond_03",
		"INV_Misc_Gem_Diamond_04",
		"INV_Misc_Gem_Diamond_05",
		"INV_Misc_Gem_Diamond_06",
		"INV_Misc_Gem_Diamond_07",
		"INV_Misc_Gem_EbonDraenite_01",
		"INV_Misc_Gem_EbonDraenite_02",
		"INV_Misc_Gem_EbonDraenite_03",
		"INV_Misc_Gem_Emerald_01",
		"INV_Misc_Gem_Emerald_02",
		"INV_Misc_Gem_Emerald_03",
		"INV_Misc_Gem_EmeraldRough_01",
		"INV_Misc_Gem_EmeraldRough_02",
		"INV_Misc_Gem_FlameSpessarite_01",
		"INV_Misc_Gem_FlameSpessarite_02",
		"INV_Misc_Gem_FlameSpessarite_03",
		"INV_Misc_Gem_GoldenDraenite_01",
		"INV_Misc_Gem_GoldenDraenite_02",
		"INV_Misc_Gem_GoldenDraenite_03",
		"INV_Misc_Gem_LionsEye_01",
		"INV_Misc_Gem_Opal_01",
		"INV_Misc_Gem_Opal_02",
		"INV_Misc_Gem_Opal_03",
		"INV_Misc_Gem_OpalRough_01",
		"INV_Misc_Gem_Pearl_01",
		"INV_Misc_Gem_Pearl_02",
		"INV_Misc_Gem_Pearl_03",
		"INV_Misc_Gem_Pearl_04",
		"INV_Misc_Gem_Pearl_05",
		"INV_Misc_Gem_Pearl_06",
		"INV_Misc_Gem_Ruby_01",
		"INV_Misc_Gem_Ruby_02",
		"INV_Misc_Gem_Ruby_03",
		"INV_Misc_Gem_Sapphire_01",
		"INV_Misc_Gem_Sapphire_02",
		"INV_Misc_Gem_Sapphire_03",
		"INV_Misc_Gem_Stone_01",
		"INV_Misc_Gem_Topaz_01",
		"INV_Misc_Gem_Topaz_02",
		"INV_Misc_Gem_Topaz_03",
		"INV_Misc_Gem_Variety_01",
		"INV_Misc_Gem_Variety_02",
		"INV_Jewelcrafting_AzureBoar",
		"INV_Jewelcrafting_AzureCrab",
		"INV_Jewelcrafting_AzureHare",
		"INV_Jewelcrafting_AzureOwl",
		"INV_Jewelcrafting_AzureSerpent",
		"INV_Jewelcrafting_CrimsonBoar",
		"INV_Jewelcrafting_CrimsonCrab",
		"INV_Jewelcrafting_CrimsonHare",
		"INV_Jewelcrafting_CrimsonOwl",
		"INV_Jewelcrafting_DragonsEye01",
		"INV_Jewelcrafting_DragonsEye02",
		"INV_Jewelcrafting_EmeraldBoar",
		"INV_Jewelcrafting_EmeraldCrab",
		"INV_Jewelcrafting_EmeraldHare",
		"INV_Jewelcrafting_Gem_01",
		"INV_Jewelcrafting_Gem_02",
		"INV_Jewelcrafting_Gem_03",
		"INV_Jewelcrafting_Gem_04",
		"INV_Jewelcrafting_Gem_05",
		"INV_Jewelcrafting_Gem_06",
		"INV_Jewelcrafting_Gem_07",
		"INV_Jewelcrafting_Gem_08",
		"INV_Jewelcrafting_Gem_09",
		"INV_Jewelcrafting_Gem_10",
		"INV_Jewelcrafting_Gem_11",
		"INV_Jewelcrafting_Gem_12",
		"INV_Jewelcrafting_Gem_13",
		"INV_Jewelcrafting_Gem_14",
		"INV_Jewelcrafting_Gem_15",
		"INV_Jewelcrafting_Gem_16",
		"INV_Jewelcrafting_Gem_17",
		"INV_Jewelcrafting_Gem_18",
		"INV_Jewelcrafting_Gem_19",
		"INV_Jewelcrafting_Gem_20",
		"INV_Jewelcrafting_Gem_21",
		"INV_Jewelcrafting_Gem_22",
		"INV_Jewelcrafting_Gem_23",
		"INV_Jewelcrafting_Gem_24",
		"INV_Jewelcrafting_Gem_25",
		"INV_Jewelcrafting_Gem_26",
		"INV_Jewelcrafting_Gem_27",
		"INV_Jewelcrafting_Gem_28",
		"INV_Jewelcrafting_Gem_29",
		"INV_Jewelcrafting_Gem_30",
		"INV_Jewelcrafting_Gem_31",
		"INV_Jewelcrafting_Gem_32",
		"INV_Jewelcrafting_Gem_33",
		"INV_Jewelcrafting_Gem_34",
		"INV_Jewelcrafting_Gem_35",
		"INV_Jewelcrafting_Gem_36",
		"INV_Jewelcrafting_Gem_37",
		"INV_Jewelcrafting_Gem_38",
		"INV_Jewelcrafting_Gem_39",
		"INV_Jewelcrafting_Gem_40",
		"INV_Jewelcrafting_Gem_41",
		"INV_Jewelcrafting_Gem_42",
		"INV_Jewelcrafting_GoldenBoar",
		"INV_Jewelcrafting_GoldenCrab",
		"INV_Jewelcrafting_GoldenOwl",
		"INV_Jewelcrafting_GoldenSerpent",
		"INV_Jewelcrafting_IceDiamond_01",
		"INV_Jewelcrafting_IceDiamond_02",
		"INV_Jewelcrafting_JadeSerpent",
		"INV_Jewelcrafting_PurpleBoar",
		"INV_Jewelcrafting_PurpleCrab",
		"INV_Jewelcrafting_PurpleHare",
		"INV_Jewelcrafting_PurpleOwl",
		"INV_Jewelcrafting_PurpleSerpent",
		"INV_Jewelcrafting_ShadowSpirit_01",
		"INV_Jewelcrafting_ShadowSpirit_02",
		"INV_Jewelcrafting_DragonsEye03", -- [398]
		"INV_Jewelcrafting_DragonsEye04", -- [399]
		"INV_Jewelcrafting_DragonsEye05", -- [400]
		"INV_JEWELCRAFTING_GEM_31", -- [401]
		"INV_JEWELCRAFTING_GEM_32", -- [402]
		"INV_JEWELCRAFTING_GEM_33", -- [403]
		"INV_JEWELCRAFTING_GEM_34", -- [404]
		"INV_JEWELCRAFTING_GEM_35", -- [405]
		"INV_JEWELCRAFTING_GEM_36", -- [406]
		"INV_JEWELCRAFTING_GEM_37", -- [407]
		"INV_JEWELCRAFTING_GEM_38", -- [408]
		"INV_JEWELCRAFTING_GEM_39", -- [409]
		"INV_JEWELCRAFTING_GEM_40", -- [410]
		"INV_JEWELCRAFTING_GEM_41", -- [411]
		"INV_JEWELCRAFTING_GEM_42", -- [412]

		"inv_misc_crystalepic",
		"inv_misc_crystalepic2",
		"inv_misc_cutgemnormal",
		"inv_misc_cutgemnormal2",
		"inv_misc_cutgemnormal3",
		"inv_misc_cutgemnormal4",
		"inv_misc_cutgemnormal5",
		"inv_misc_cutgemsuperior",
		"inv_misc_cutgemsuperior2",
		"inv_misc_cutgemsuperior3",
		"inv_misc_cutgemsuperior4",
		"inv_misc_cutgemsuperior2",
		"inv_misc_largeshard_superior",
		"inv_misc_metagemuncut_a",
		"inv_misc_metagemuncut_b",
		"inv_misc_metagem_a",
		"inv_misc_metagem_b",
		"inv_misc_uncutgemnormal",
		"inv_misc_uncutgemnormal1",
		"inv_misc_uncutgemnormal2",
		"inv_misc_uncutgemnormal3",
		"inv_misc_uncutgemnormal4",
		"inv_misc_uncutgemnormal5",
		"inv_misc_uncutgemsuperior",
		"inv_misc_uncutgemsuperior2",
		"inv_misc_uncutgemsuperior3",
		"inv_misc_uncutgemsuperior4",
		"inv_misc_uncutgemsuperior5",
		"INV_Misc_EpicGem_01",
		"INV_Misc_EpicGem_02",
		"INV_Misc_EpicGem_03",
		"INV_Misc_EpicGem_04",
		"INV_Misc_EpicGem_05",
		"INV_Misc_EpicGem_06",
		"INV_Misc_EpicGem_Uncut_01",
		"INV_Misc_EpicGem_Uncut_02",
		"INV_Misc_EpicGem_Uncut_03",
		"INV_Misc_EpicGem_Uncut_04",
		"INV_Misc_EpicGem_Uncut_05",
		"INV_Misc_EpicGem_Uncut_06",
		 "INV_Misc_Gem_AmethystRough_03", 
		"INV_Misc_Gem_EmeraldRough_03", 
		"INV_Misc_Gem_OpalRough_03", 
		"INV_Misc_Gem_RubyRough_03", 
		"INV_Misc_Gem_SaphireRough_03", 
		"INV_Misc_Gem_TopazRough_03", 
		"INV_Misc_Gem_X4_MetaGem_Cut", 
		"INV_Misc_Gem_X4_MetaGem_Uncut", 
		"INV_Misc_Gem_X4_Rare_Cut_Blue", 
		"INV_Misc_Gem_X4_Rare_Cut_Green", 
		"INV_Misc_Gem_X4_Rare_Cut_Orange", 
		"INV_Misc_Gem_X4_Rare_Cut_Purple", 
		"INV_Misc_Gem_X4_Rare_Cut_Red", 
		"INV_Misc_Gem_X4_Rare_Cut_Yellow", 
		"INV_Misc_Gem_X4_Rare_Uncut_Blue", 
		"INV_Misc_Gem_X4_Rare_Uncut_Green", 
		"INV_Misc_Gem_X4_Rare_Uncut_Orange", 
		"INV_Misc_Gem_X4_Rare_Uncut_Purple", 
		"INV_Misc_Gem_X4_Rare_Uncut_Red", 
		"INV_Misc_Gem_X4_Rare_Uncut_Yellow", 
		"INV_Misc_Gem_X4_Uncommon_Cut_Blue", 
		"INV_Misc_Gem_X4_Uncommon_Cut_Green", 
		"INV_Misc_Gem_X4_Uncommon_Cut_Orange", 
		"INV_Misc_Gem_X4_Uncommon_Cut_Purple", 
		"INV_Misc_Gem_X4_Uncommon_Cut_Red", 
		"INV_Misc_Gem_X4_Uncommon_Cut_Yellow", 
		"INV_Misc_Gem_X4_Uncommon_PerfectCut_Blue", 
		"INV_Misc_Gem_X4_Uncommon_PerfectCut_Green", 
		"INV_Misc_Gem_X4_Uncommon_PerfectCut_Orange", 
		"INV_Misc_Gem_X4_Uncommon_PerfectCut_Purple", 
		"INV_Misc_Gem_X4_Uncommon_PerfectCut_Red", 
		"INV_Misc_Gem_X4_Uncommon_PerfectCut_Yellow",
		"INV_jewelcrafting_43", 
		"INV_jewelcrafting_44", 
		"INV_jewelcrafting_45", 
		"INV_jewelcrafting_46", 
		"INV_jewelcrafting_47", 
		"INV_jewelcrafting_48", 
		"INV_jewelcrafting_49", 
		"INV_jewelcrafting_50", 
		"INV_jewelcrafting_51", 
		"INV_jewelcrafting_52", 
		"INV_jewelcrafting_53", 
		"INV_jewelcrafting_54", 
		"INV_jewelcrafting_amplifier", 
		"INV_jewelcrafting_greateramplifier", 
		"INV_jewelcrafting_prism", 
		"INV_jewelcrafting_taladitecrystal", 
		"INV_jewelcrafting_taladiterecrystal",  
		
	}
	GHM_StockIcons["Archaeology"] = {
		"trade_archaeology_blacktrilobite",
		"trade_archaeology_carved harp of exotic wood",
		"trade_archaeology_carved wildhammer gryphon figurine",
		"trade_archaeology_decorated leather boot heel",
		"trade_archaeology_dignified draenei portrait",
		"trade_archaeology_draenei candelabra",
		"trade_archaeology_goldchamberpot",
		"trade_archaeology_insect in amber",
		"trade_archaeology_sand castle",
		"trade_archaeology_shark jaws",
		"trade_archaeology_silverdoorknocker of female dwarf",
		"trade_archaeology_skullmug",
		"trade_archaeology_trollbatidol",
		"trade_archaeology_trolllizardfootcharm",
		"trade_archaeology_trolltooth w goldfilling",
		"trade_archaeology_whitehydrafigurine",
		"trade_archaeology_bones of transformation",
		"trade_archaeology_chalice of mountainkings",
		"trade_archaeology_dinosaurskeleton",
		"trade_archaeology_draeneirelic",
		"trade_archaeology_cthunspuzzlebox",
		"trade_archaeology_druidprieststatueset",
		"trade_archaeology_generalbeauregardslaststand",
		"trade_archaeology_highbornesoulmirror",
		"trade_archaeology_kaldoreiwindchimes",
		"trade_archaeology_naarucrystal",
		"trade_archaeology_oldgodtrinket",
		"trade_archaeology_pendant of the aqir",
		"trade_archaeology_queenazshara dressinggown",
		"trade_archaeology_ring of the boyemperor",
		"trade_archaeology_sceptor of azaqir",
		"trade_archaeology_scimitar of the sirocco",
		"trade_archaeology_shriveledmonkeypaw",
		"trade_archaeology_staff of ammunrae",
		"trade_archaeology_theinnkeepersdaughter",
		"trade_archaeology_tinydinosaurskeleton",
		"trade_archaeology_tyrandesfavoritedoll",
		"trade_archaeology_wispamulet",
		"trade_archaeology_ancientorcshamanheaddress",
		"trade_archaeology_antleredcloakclasp",
		"trade_archaeology_blackenedstaff",
		"trade_archaeology_bladedorcscepter",
		"trade_archaeology_bloodysatyrscepter",
		"trade_archaeology_burningdemonscepter",
		"trade_archaeology_candlestub",
		"trade_archaeology_catstatueemeraldeyes",
		"trade_archaeology_chestoftinyglassanimals",
		"trade_archaeology_crackedcrystalvial",
		"trade_archaeology_delicatemusicbox",
		"trade_archaeology_dentedshield",
		"trade_archaeology_engravedscimitarpommel",
		"trade_archaeology_gemmeddrinkingcup",
		"trade_archaeology_hairpinsilvermalachite",
		"trade_archaeology_jeweleddwarfscepter",
		"trade_archaeology_mithrilnecklace",
		"trade_archaeology_nerubianspiderscepter",
		"trade_archaeology_notchedsword",
		"trade_archaeology_ogre2handedhammer",
		"trade_archaeology_rustedsteakknife",
		"trade_archaeology_silverdagger",
		"trade_archaeology_silverscrollcase",
		"trade_archaeology_sketchdesertpalace",
		"trade_archaeology_skullstaff",
		"trade_archaeology_soapstonescarabnecklace",
		"trade_archaeology_spinedquillboarscepter",
		"Trade_Archaeology_StaffofSorcerer_Than Thaurissan",
		"trade_archaeology_stoneshield",
		"trade_archaeology_tinybronzescorpion",
		"trade_archaeology_tinyoasismosaic",
		"trade_archaeology_trollbatscepter",
		"trade_archaeology_uldumcanopicjar",
		"trade_archaeology_wingedhelm",
		"trade_archaeology_zinrokh sword",
		"trade_archaeology_vrykul_runestick",
		"trade_archaeology_vrykul_artifactfragment",
		"trade_archaeology_tuskarr_stele",
		"trade_archaeology_tuskarr_artifactfragment",
		"trade_archaeology_troll_tablet",
		"trade_archaeology_troll_artifactfragment",
		"trade_archaeology_titan_fragment",
		"trade_archaeology_orc_bloodtext",
		"trade_archaeology_orc_artifactfragment",
		"trade_archaeology_nerubian_obelisk",
		"trade_archaeology_nerubian_artifactfragment",
		"trade_archaeology_highborne_scroll",
		"trade_archaeology_highborne_artifactfragment",
		"trade_archaeology_fossil_snailshell",
		"trade_archaeology_fossil_fern",
		"trade_archaeology_fossil_dinosaurbone",
		"trade_archaeology_dwarf_runestone",
		"trade_archaeology_dwarf_artifactfragment",
		"trade_archaeology_draenei_tome",
		"trade_archaeology_draenei_artifactfragment",
		"trade_archaeology_arakkoa_crystalshard",
		"trade_archaeology_arakkoa_artifactfragment",
		"trade_archaeology_aqir_hieroglyphic",
		"trade_archaeology_aqir_artifactfragment",
		"Archaeology_5_0_AnatomicalDummy", 
		"Archaeology_5_0_ApothecaryTins", 
		"Archaeology_5_0_CarvedBronzeMirror", 
		"Archaeology_5_0_ChangKiBoard", 
		"Archaeology_5_0_CrackedMoguRunestone", 
		"Archaeology_5_0_EdictsOfTheThunderKing", 
		"Archaeology_5_0_EmptyKegOfBrewfatherXinWoYin", 
		"Archaeology_5_0_GoldInlaidPorcelainFuneraryFigurine", 
		"Archaeology_5_0_IronAmulet", 
		"Archaeology_5_0_Keystone_Mogu", 
		"Archaeology_5_0_Keystone_Pandaren", 
		"Archaeology_5_0_ManaclesOfRebellion", 
		"Archaeology_5_0_MoguCoin", 
		"Archaeology_5_0_PandarenTeaSet", 
		"Archaeology_5_0_PearlOfYulon", 
		"Archaeology_5_0_PetrifiedBoneWhip", 
		"Archaeology_5_0_QuilenStatuette", 
		"Archaeology_5_0_SpearOfXuen", 
		"Archaeology_5_0_StandardOfNuzao", 
		"Archaeology_5_0_TerracottaArm", 
		"Archaeology_5_0_ThunderKingInsignia", 
		"Archaeology_5_0_TwinSteinSetOfBrewfatherQuanTouKuo", 
		"Archaeology_5_0_UmbrellaOfChiJi", 
		"Archaeology_5_0_WalkingCaneOfBrewfatherRenYun", 
		"Archaeology_5_0_WarlordsBrandingIron", 
		"Archaeology_5_0_WornMonumentLedger", 
		"INV_Archaeology_Ogres_Chimera_Riding_Harness", 
		"INV_Archaeology_Ogres_Figurine", 
		"INV_Archaeology_Ogres_Gladiator_Shield", 
		"INV_Archaeology_Ogres_HarGunn_Eye", 
		"INV_Archaeology_Ogres_Imperial_Decree_Stele", 
		"INV_Archaeology_Ogres_IronGob", 
		"INV_Archaeology_Ogres_MortarPestle", 
		"INV_Archaeology_Ogres_Pictogram_Tablet", 
		"INV_Archaeology_Ogres_Sorcerer_King_Toe_Ring", 
		"INV_Archaeology_Ogres_Stonemaul_Succession_Stone", 
		"INV_Archaeology_Ogres_Stone_Manacles", 
		"INV_Archaeology_Ogres_Warmaul_Chieftain", 
		"INV_Archaeology_Orcclans_Barbedhook", 
		"INV_Archaeology_Orcclans_Bellow", 
		"INV_Archaeology_Orcclans_Blackrockrazor", 
		"INV_Archaeology_Orcclans_BlazeGrease", 
		"INV_Archaeology_Orcclans_crackedidol", 
		"INV_Archaeology_Orcclans_Doomsdaytablet", 
		"INV_Archaeology_Orcclans_Frostwolfaxe", 
		"INV_Archaeology_Orcclans_Grontoothnecklace", 
		"INV_Archaeology_Orcclans_Hookeddagger", 
		"INV_Archaeology_Orcclans_Jareye", 
		"INV_Archaeology_Orcclans_Metalworkershammer", 
		"INV_Archaeology_Orcclans_Scrimshaw", 
		"INV_Archaeology_Orcclans_Snowshoe", 
		"INV_Archaeology_Orcclans_talisman", 
		"INV_Archaeology_Orcclans_Tattooknife", 
		"INV_Archaeology_Orcclans_Warsingersdrums", 
		"INV_Archaeology_Orcclans_Warsongpike", 
		"INV_Ashran_Artifact", 
		"TRADE_ARCHAEOLOGY_APEXISCRYSTAL", 
		"TRADE_ARCHAEOLOGY_APEXISFLOOR", 
		"TRADE_ARCHAEOLOGY_APEXISHIEROGLYPH", 
		"TRADE_ARCHAEOLOGY_APEXISSCROLL", 
		"TRADE_ARCHAEOLOGY_APEXISSTATUE", 
		"TRADE_ARCHAEOLOGY_OUTCASTDREAMCATCHER", 
	}
	GHM_StockIcons["Magical Items"] = {
		-- ok
		"INV_Misc_Orb_01",
		"INV_Misc_Orb_02",
		"INV_Misc_Orb_03",
		"INV_Misc_Orb_04",
		"INV_Misc_Orb_05",
		"INV_Misc_Horn_01",
		"INV_Misc_Horn_02",
		"INV_Misc_Horn_03",
		"INV_DataCrystal01",
		"INV_DataCrystal02",
		"INV_DataCrystal03",
		"INV_DataCrystal04",
		"INV_DataCrystal05",
		"INV_DataCrystal06",
		"INV_DataCrystal07",
		"INV_DataCrystal08",
		"INV_DataCrystal09",
		"INV_DataCrystal10",
		"INV_DataCrystal11",
		"INV_DataCrystal12",
		"INV_Misc_QirajiCrystal_01",
		"INV_Misc_QirajiCrystal_02",
		"INV_Misc_QirajiCrystal_03",
		"INV_Misc_QirajiCrystal_04",
		"INV_Misc_QirajiCrystal_05",
		"INV_Misc_Rune_01",
		"INV_Misc_Rune_02",
		"INV_Misc_Rune_03",
		"INV_Misc_Rune_04",
		"INV_Misc_Rune_05",
		"INV_Misc_Rune_06",
		"INV_Misc_Rune_07",
		"INV_Misc_Rune_08",
		"INV_Misc_Rune_09",
		"INV_Misc_Rune_10",
		"INV_Misc_Rune_11",
		"INV_Misc_Rune_12",
		"INV_Misc_Rune_13",
		"INV_Misc_ShadowEgg",
		"INV_Misc_Statue_01",
		"INV_Misc_Statue_02",
		"INV_Misc_Statue_03",
		"INV_Misc_Statue_04",
		"INV_Misc_Statue_05",
		"INV_Misc_Statue_06",
		"INV_Misc_Statue_07",
		"INV_Misc_Statue_08",
		"INV_Misc_Statue_09",
		"INV_Misc_Statue_10",
		"INV_Misc_SymbolofKings_01",
		"INV_Misc_Ticket_Darkmoon_01",
		"INV_Misc_Ticket_Tarot_Beasts_01",
		"INV_Misc_Ticket_Tarot_Blessings",
		"INV_Misc_Ticket_Tarot_BlueDragon_01",
		"INV_Misc_Ticket_Tarot_Crusade",
		"INV_Misc_Ticket_Tarot_Elemental_01",
		"INV_Misc_Ticket_Tarot_Furies",
		"INV_Misc_Ticket_Tarot_Heroism_01",
		"INV_Misc_Ticket_Tarot_Lunacy",
		"INV_Misc_Ticket_Tarot_Madness",
		"INV_Misc_Ticket_Tarot_Maelstrom_01",
		"INV_Misc_Ticket_Tarot_Portal_01",
		"INV_Misc_Ticket_Tarot_Stack_01",
		"INV_Misc_Ticket_Tarot_Storms",
		"INV_Misc_Ticket_Tarot_TwistingNether_01",
		"INV_Misc_Ticket_Tarot_Vengeance",
		"INV_Misc_Ticket_Tarot_Warlord_01",
		"INV_Misc_Ticket_Tarot_Wrath",
		"INV_Offhand_Blood_01",
		"INV_Offhand_Blood_02",
		"INV_Offhand_Draenei_A_01",
		"INV_Offhand_Draenei_A_02",
		"INV_Offhand_Hyjal_D_01",
		"INV_Offhand_Naxxramas_02",
		"INV_Offhand_Naxxramas_03",
		"INV_Offhand_Naxxramas_04",
		"INV_Offhand_Naxxramas_D_01",
		"INV_Offhand_OutlandRaid_01",
		"INV_Offhand_OutlandRaid_02",
		"INV_Offhand_OutlandRaid_03blue",
		"INV_Offhand_OutlandRaid_03orange",
		"INV_Offhand_OutlandRaid_03white",
		"INV_Offhand_Stratholme_A_01",
		"INV_Offhand_Stratholme_A_02",
		"INV_Misc_Statue_11",
		"INV_Misc_Statue_12",
		"INV_Relics_IdolofFerocity",
		"INV_Relics_IdolofHealth",
		"INV_Relics_IdolofRejuvenation",
		"INV_Relics_LibramofGrace",
		"INV_Relics_LibramofHope",
		"INV_Relics_LibramofTruth",
		"INV_Relics_TotemofLife",
		"INV_Relics_TotemofRage",
		"INV_Relics_TotemofRebirth",
		"INV_SpiritShard_01",
		"INV_SpiritShard_02",
		"INV_SummerFest_FireDrink",
		"INV_SummerFest_FireFlower",
		"INV_SummerFest_FirePotion",
		"INV_SummerFest_FireSpirit",
		"INV_Titanium_Shield_Spike",
		"INV_Torch_Thrown",
		"INV_ZulGurubTrinket",
		"INV-Mount_Raven_54",
		"INV_Misc_Petbiscuit_01",
		"INV_Misc_Rune_14",
		"INV_Misc_SawBlade_01",
		"INV_Misc_Web_01",
		"INV_Misc_Web_02",
		"INV_Qiraj_CarapaceOldGod",
		"INV_Qiraj_DrapeMartial",
		"INV_Qiraj_DrapeRegal",
		"INV_Qiraj_HiltOrnate",
		"INV_Qiraj_HiltSpiked",
		"INV_Qiraj_HuskOldGod",
		"INV_Qiraj_JewelBlessed", -- [584]
		"INV_Qiraj_JewelEncased", -- [585]
		"INV_Qiraj_JewelEngraved", -- [586]
		"INV_Qiraj_JewelGlyphed", -- [587]
		"INV_Qiraj_OuroHide", -- [588]
		"INV_Qiraj_SkinSandworm", -- [589]
		"INV_QirajIdol_Alabaster", -- [590]
		"INV_QirajIdol_Amber", -- [591]
		"INV_QirajIdol_Azure", -- [592]
		"INV_QirajIdol_Death", -- [593]
		"INV_QirajIdol_Jasper", -- [594]
		"INV_QirajIdol_Lambent", -- [595]
		"INV_QirajIdol_Life", -- [596]
		"INV_QirajIdol_Night", -- [597]
		"INV_QirajIdol_Obsidian", -- [598]
		"INV_QirajIdol_Onyx", -- [599]
		"INV_QirajIdol_Rebirth", -- [600]
		"INV_QirajIdol_Sage", -- [601]
		"INV_QirajIdol_Strife", -- [602]
		"INV_QirajIdol_Sun", -- [603]
		"INV_QirajIdol_Vermillion", -- [604]
		"INV_QirajIdol_War", -- [605]

		"inv_misc_enchantedpearl",
		"inv_misc_enchantedpearla",
		"inv_misc_enchantedpearlb",
		"inv_misc_enchantedpearlc",
		"inv_misc_enchantedpearld",
		"inv_misc_enchantedpearle",
		"inv_misc_enchantedpearlf",
		"inv_misc_flawlesspearl",

		"inv_misc_stormlordsfavor",
		"inv_misc_volatileair",
		"inv_misc_volatileearth",
		"inv_misc_volatilefire",
		"inv_misc_volatilelife",
		"inv_misc_volatileshadow",
		"inv_misc_volatilewater",

		"INV_Relics_Hourglass",
		"INV_Relics_Runestone",
		"INV_Relics_Sundial",
		"INV_Relics_Warpring",
		"INV_PA_CelestialMallet", 
		"INV_PA_CelestialMallet_Head", 
		"INV_PA_CelestialMallet_Shaft", 
		"INV_Elemental_SpiritofHarmony_1", 
		"INV_Elemental_SpiritofHarmony_2", 
		"INV_Enchant_DustSpirit", 
		"INV_Enchant_ShardSha", 
		"INV_Legendary_BreathofBlackPrince_AGI", 
		"INV_Legendary_BreathofBlackPrince_INT", 
		"INV_Legendary_BreathofBlackPrince_STR", 
		"INV_Legendary_ChimeraofFear", 
		"INV_Legendary_SigilofPower", 
		"INV_Legendary_SigilofWisdom", 
		"Icon_UpgradeStone_Beast_Epic", 
	    "Icon_UpgradeStone_Beast_Rare", 
	    "Icon_UpgradeStone_Beast_Uncommon", 
	    "Icon_UpgradeStone_Critter_Epic", 
	    "Icon_UpgradeStone_Critter_Rare", 
	    "Icon_UpgradeStone_Critter_Uncommon", 
	    "Icon_UpgradeStone_Dragon_Epic", 
	    "Icon_UpgradeStone_Dragon_Rare", 
	    "Icon_UpgradeStone_Dragon_Uncommon", 
	    "Icon_UpgradeStone_Epic", 
	    "Icon_UpgradeStone_Fire_Epic", 
	    "Icon_UpgradeStone_Fire_Rare", 
	    "Icon_UpgradeStone_Fire_Uncommon", 
	    "Icon_UpgradeStone_Flying_Epic", 
	    "Icon_UpgradeStone_Flying_Rare", 
	    "Icon_UpgradeStone_Flying_Uncommon", 
	    "Icon_UpgradeStone_Humanoid_Epic", 
	    "Icon_UpgradeStone_Humanoid_Rare", 
	    "Icon_UpgradeStone_Humanoid_Uncommon", 
	    "Icon_UpgradeStone_Magical_Epic", 
	    "Icon_UpgradeStone_Magical_Rare", 
	    "Icon_UpgradeStone_Magical_Uncommon", 
	    "Icon_UpgradeStone_Mechanical_Epic", 
	    "Icon_UpgradeStone_Mechanical_Rare", 
	    "Icon_UpgradeStone_Mechanical_Uncommon", 
	    "Icon_UpgradeStone_Rare", 
	    "Icon_UpgradeStone_Uncommon", 
	    "Icon_UpgradeStone_Undead_Epic", 
	    "Icon_UpgradeStone_Undead_Rare", 
	    "Icon_UpgradeStone_Undead_Uncommon", 
	    "Icon_UpgradeStone_Water_Epic", 
	    "Icon_UpgradeStone_Water_Rare", 
	    "Icon_UpgradeStone_Water_Uncommon",
		"INV_Misc_Summonable_Boss_Token",
		"INV_Offhand_1h_PVPPandariaS2_C_01", 
		"INV_Offhand_1h_ThunderIsleRaid_D_01", 
		"INV_Offhand_1H_ThunderIsleRaid_D_02", 
		"INV_60PVP_Trinket1A", 
		"INV_60PVP_Trinket1B", 
		"INV_60PVP_Trinket1C", 
		"INV_60PVP_Trinket1D", 
		"INV_60PVP_Trinket2A", 
		"INV_60PVP_Trinket2B", 
		"INV_60PVP_Trinket2C", 
		"INV_60PVP_Trinket2D", 
		"INV_60PVP_Trinket3A", 
		"INV_60PVP_Trinket3B", 
		"INV_60PVP_Trinket3C", 
		"INV_60PVP_Trinket3D", 
		"INV_60PVP_Trinket4A", 
		"INV_60PVP_Trinket4B", 
		"INV_60PVP_Trinket4C", 
		"INV_60PVP_Trinket4D", 
		"Inv_misc_trinket6oIH_orb1", 
		"Inv_misc_trinket6oIH_orb2", 
		"Inv_misc_trinket6oIH_orb3", 
		"Inv_misc_trinket6oIH_orb4",  
		"INV_Offhand_1h_DraenorChallenge_D_01", 
		"INV_Offhand_1h_DraenorCrafted_D_01_A_Alliance", 
		"INV_Offhand_1h_DraenorCrafted_D_01_A_Horde", 
		"INV_Offhand_1h_DraenorCrafted_D_01_B_Alliance", 
		"INV_Offhand_1h_DraenorCrafted_D_01_B_Horde", 
		"INV_Offhand_1h_DraenorCrafted_D_01_C_Alliance", 
		"INV_Offhand_1h_DraenorCrafted_D_01_C_Horde", 
		"INV_Offhand_1h_DraenorCrafted_D_02a", 
		"INV_Offhand_1h_DraenorCrafted_D_02b", 
		"INV_Offhand_1h_DraenorCrafted_D_02c", 
		"INV_Offhand_1h_DraenorDungeon_C_01", 
		"INV_Offhand_1h_DraenorDungeon_C_02", 
		"INV_Offhand_1h_DraenorHonor_C_01", 
		"INV_Offhand_1h_DraenorHonor_C_02", 
		"INV_Offhand_1h_DraenorQuest95_B_01", 
		"INV_Offhand_1h_DraenorQuest95_B_02", 
		"INV_Offhand_1h_DraenorQuest_B_01", 
		"INV_Offhand_1h_DraenorQuest_B_02", 
		"INV_Offhand_1h_DraenorRaid_D_01", 
		"INV_Offhand_1h_DraenorRaid_D_02", 
		"INV_Offhand_1h_DraenorRaid_D_03", 
		"INV_Offhand_1h_DraenorRaid_D_04", 
		"INV_Offhand_1h_PVPDraenorS1_D_01", 
		"INV_Offhand_1h_PVPDraenorS1_D_02", 	
		"INV_TRADESKILLITEM_LESSERSORCERERSEARTH", 
		"INV_TRADESKILLITEM_LESSERSORCERERSEARTH_TONG", 
		"INV_TRADESKILLITEM_LESSERSORCERERSFIRE", 
		"INV_TRADESKILLITEM_LESSERSORCERERSFIRE_TONG", 
		"INV_TRADESKILLITEM_LESSERSORCERERSWATER", 
		"INV_TRADESKILLITEM_LESSERSORCERERSWATER_TONG", 
		"INV_TRADESKILLITEM_LESSERSORCERERSWIND", 
		"INV_TRADESKILLITEM_LESSERSORCERERSWIND_TONG", 
		"INV_TRADESKILLITEM_SORCEREREARTH", 
		"INV_TRADESKILLITEM_SORCERERSEARTH_TONG", 
		"INV_TRADESKILLITEM_SORCERERSFIRE", 
		"INV_TRADESKILLITEM_SORCERERSFIRE_TONG", 
		"INV_TRADESKILLITEM_SORCERERSWATER", 
		"INV_TRADESKILLITEM_SORCERERSWATER_TONG", 
		"INV_TRADESKILLITEM_SORCERERSWIND", 
		"INV_TRADESKILLITEM_SORCERERSWIND_TONG", 		

	}
	GHM_StockIcons["Banners"] = {
		"INV_Banner_01",
		"INV_Banner_02",
		"INV_Banner_03",
		"INV_BannerPVP_01",
		"INV_BannerPVP_02",
		"INV_BannerPVP_03",
		"INV_BRD_Banner",
		"Inv_Misc_Tournaments_banner_Bloodelf", -- [510]
		"Inv_Misc_Tournaments_banner_Draenei", -- [511]
		"Inv_Misc_Tournaments_banner_Dwarf", -- [512]
		"Inv_Misc_Tournaments_banner_Gnome", -- [513]
		"Inv_Misc_Tournaments_banner_Human", -- [514]
		"Inv_Misc_Tournaments_banner_Nightelf", -- [515]
		"Inv_Misc_Tournaments_banner_Orc", -- [516]
		"Inv_Misc_Tournaments_banner_Scourge", -- [517]
		"Inv_Misc_Tournaments_banner_Tauren", -- [518]
		"Inv_Misc_Tournaments_banner_Troll", -- [519]
		"Inv_Misc_Tournaments_Symbol_BloodElf", -- [520]
		"Inv_Misc_Tournaments_Symbol_Draenei", -- [521]
		"Inv_Misc_Tournaments_Symbol_Dwarf", -- [522]
		"Inv_Misc_Tournaments_Symbol_Gnome", -- [523]
		"Inv_Misc_Tournaments_Symbol_Human", -- [524]
		"Inv_Misc_Tournaments_Symbol_NightElf", -- [525]
		"Inv_Misc_Tournaments_Symbol_Orc", -- [526]
		"Inv_Misc_Tournaments_Symbol_Scourge", -- [527]
		"Inv_Misc_Tournaments_Symbol_Tauren", -- [528]
		"Inv_Misc_Tournaments_Symbol_Troll", -- [529]
		"Inv_Misc_Tournaments_Tabard_BloodElf", -- [530]
		"Inv_Misc_Tournaments_Tabard_Draenei", -- [531]
		"Inv_Misc_Tournaments_Tabard_Dwarf", -- [532]
		"Inv_Misc_Tournaments_Tabard_gnome", -- [533]
		"Inv_Misc_Tournaments_Tabard_Human", -- [534]
		"Inv_Misc_Tournaments_Tabard_NightElf", -- [535]
		"Inv_Misc_Tournaments_Tabard_Orc", -- [536]
		"Inv_Misc_Tournaments_Tabard_scourge", -- [537]
		"Inv_Misc_Tournaments_Tabard_Tauren", -- [538]
		"Inv_Misc_Tournaments_Tabard_Troll", -- [539]

		"inv_banner_tolbarad_alliance",
		"inv_banner_tolbarad_horde",
		"inv_guild_standard_alliance_a",
		"inv_guild_standard_alliance_b",
		"inv_guild_standard_alliance_c",
		"inv_guild_standard_horde_a",
		"inv_guild_standard_horde_b",
		"inv_guild_standard_horde_c",
		"inv_misc_tabard_baradinwardens",
		"inv_misc_tabard_dragonmawclan",
		"inv_misc_tabard_dragonmawclanpvp",
		"inv_misc_tabard_earthenring",
		"inv_misc_tabard_explorersguild",
		"inv_misc_tabard_forsaken",
		"inv_misc_tabard_guardiansofhyjal",
		"inv_misc_tabard_hellscream",
		"inv_misc_tabard_therazane",
		"inv_misc_tabard_thereliquary",
		"inv_misc_tabard_tolvir",
		"inv_misc_tabard_wildhammerclan",
		"inv_misc_tabard_wildhammerclanpvp",
		"INV_Misc_Tabard_Lorewalkers", 
		"INV_Tabard_A_01PVPTabard_S14", 
		"INV_Tabard_A_75TimeWalker",
		"INV_Banner_Stormshield", 
		"INV_Banner_Warspear", 
		"INV_Misc_Tabard_A_01Auchenai", 
		"INV_Misc_Tabard_A_01SteamwheedlePreservationSociety",
		"INV_Tabard_A_01FrostwolfClan", 
		"INV_Tabard_A_01PVPTabard_S16", 
		"INV_Tabard_A_03IronHorde", 
		"INV_Tabard_A_76ArakkoaOutcast", 
		"INV_Tabard_A_77VoljinsSpear", 
		"INV_Tabard_A_78WrynnVanguard", 
		"INV_Tabard_A_80LaughingSkull", 
		"INV_Tabard_A_81Exarchs", 
		"INV_Tabard_A_ShatariDefense",  		
	}
	GHM_StockIcons["Misc"] = {
		"Creatureportrait_Nexus_Floating_Disc",
		"INV_Misc_Bowl_01",
		"INV_Misc_PocketWatch_01",
		"INV_Misc_PocketWatch_02",
		"INV_Misc_PocketWatch_03",
		"INV_Misc_Lantern_01",
		"INV_Misc_Noose_01",
		"INV_Misc_Map_01",
		"INV_Misc_Net_01",
		"INV_Misc_Pipe_01",
		"INV_Misc_Gift_01",
		"INV_Misc_Gift_02",
		"INV_Misc_Gift_03",
		"INV_Misc_Gift_04",
		"INV_Misc_Gift_05",
		"INV_Misc_GiftWrap_01",
		"INV_Misc_GiftWrap_02",
		"INV_Misc_GiftWrap_03",
		"INV_Misc_Flute_01",
		"INV_Misc_Bell_01",
		"INV_Misc_Branch_01",
		"INV_Misc_Candle_01",
		"INV_Misc_Candle_02",
		"INV_Misc_Candle_03",
		"INV_Misc_Comb_01",
		"INV_Misc_Comb_02",
		"INV_Misc_Drum_01",
		"INV_Misc_Drum_02",
		"INV_Misc_Drum_03",
		"INV_Misc_Drum_04",
		"INV_Misc_Drum_05",
		"INV_Misc_Drum_06",
		"INV_Misc_Drum_07",
		"INV_Misc_Ribbon_01",
		"INV_Misc_Shovel_01",
		"INV_Misc_Shovel_02",
		"INV_Misc_OgrePinata", -- [486]
		"INV_Misc_TheGoldenCheep",
		"INV_Misc_ThrowingBall_01",
		"INV_Misc_WartornScrap_Chain",
		"INV_Misc_WartornScrap_Cloth",
		"INV_Misc_WartornScrap_Leather",
		"INV_Misc_WartornScrap_Plate",
		"INV_Misc_Idol_01",
		"INV_Misc_Idol_02",
		"INV_Misc_Idol_03",
		"INV_Misc_Spyglass_01",
		"INV_Misc_Spyglass_02",
		"INV_Misc_Spyglass_03",
		"INV_Pick_01",
		"INV_Pick_02",
		"INV_Pick_03",
		"INV_Pick_05",
		"INV_Poison_MindNumbing",
		"INV_Torch_Lit",
		"INV_Torch_Unlit",
		"INV_DiabloStone",
		"INV_Elemental_Mote_Air01",
		"INV_Elemental_Mote_Earth01",
		"INV_Elemental_Mote_Fire01",
		"INV_Elemental_Mote_Life01",
		"INV_Elemental_Mote_Mana",
		"INV_Elemental_Mote_Nether",
		"INV_Elemental_Mote_Shadow01",
		"INV_Elemental_Mote_Water01",
		"INV_Elemental_Primal_Air",
		"INV_Elemental_Primal_Earth",
		"INV_Elemental_Primal_Fire",
		"INV_Elemental_Primal_Life",
		"INV_Elemental_Primal_Mana",
		"INV_Elemental_Primal_Nether",
		"INV_Elemental_Primal_Shadow",
		"INV_Elemental_Primal_Water",
		"INV_Holiday_Christmas_Wrapping_01",
		"INV_Holiday_Christmas_Wrapping_02",
		"INV_Holiday_Christmas_Wrapping_03",
		"INV_Misc_Apexis_Crystal",
		"INV_Misc_Apexis_Shard",
		"INV_MISC_FILM_01",
		"INV_Misc_GroupLooking",
		"INV_Misc_GroupNeedMore",
		"INV_Misc_Platnumdisks",
		"INV_Misc_PunchCards_Blue",
		"INV_Misc_PunchCards_Prismatic",
		"INV_Misc_PunchCards_Red",
		"INV_Misc_PunchCards_White",
		"INV_Misc_PunchCards_Yellow",
		"INV_Misc_QuestionMark",
		"INV_Poison_MindNumbing",
		"INV_Misc_SummerFest_BrazierBlue",
		"INV_Misc_SummerFest_BrazierGreen",
		"INV_Misc_SummerFest_BrazierOrange",
		"INV_Misc_SummerFest_BrazierRed",
		"INV_Misc_SurgeonGlove_01",
		"INV_Netherwhelp",
		"INV_Crystallized_Earth",
		"INV_Crystallized_Life",
		"INV_Crystallized_Water",
		"INV_Elemental_Crystal_Air",
		"INV_Elemental_Crystal_Earth",
		"INV_Elemental_Crystal_Fire",
		"INV_Elemental_Crystal_Life",
		"INV_Elemental_Crystal_Shadow",
		"INV_Elemental_Crystal_Water",
		"INV_Elemental_Eternal_Air",
		"INV_Elemental_Eternal_Earth",
		"INV_Elemental_Eternal_Fire",
		"INV_Elemental_Eternal_Life",
		"INV_Elemental_Eternal_Shadow",
		"INV_Elemental_Eternal_Water",
		"INV_Misc_Toy_01",
		"INV_Misc_Toy_02",
		"INV_Misc_Toy_03",
		"INV_Misc_Toy_04",
		"INV_Misc_Toy_05",
		"INV_Misc_Toy_06",
		"INV_Misc_Toy_07",
		"INV_Misc_Toy_08",
		"INV_Misc_Toy_09",
		"INV_Misc_Toy_10",
		"INV_Misc_Fishing_Raft", 
		"INV_MISC_FOOTBALL", 
		"INV_MISC_SOCCERBALL",
		"INV_Misc_Weathermachine_01",
		"INV_Misc_Dice_01",
		"INV_Misc_Dice_02",
		"INV_Misc_FireDancer_01", -- [476]
		"INV_Misc_RunedOrb_01", -- [502]
		"Inv_Misc_SummerFest_BrazierBlue", -- [504]
		"Inv_Misc_SummerFest_BrazierGreen", -- [505]
		"Inv_Misc_SummerFest_BrazierOrange", -- [506]
		"Inv_Misc_SummerFest_BrazierRed", -- [507]
		"INV_Sigil_Freya", -- [642]
		"INV_Sigil_Hodir", -- [643]
		"INV_Sigil_Mimiron", -- [644]
		"INV_Sigil_Thorim", -- [645]
		"INV_Sigil_UlduarAll", -- [646]
		"Mail_GMIcon",
		"Temp",
		"inv_misc_dmc01",
		"inv_misc_dmc03",
		"inv_misc_dmc_02",
		"inv_misc_dmc_destructiondeck",
		"inv_misc_dmc_04",
		"inv_misc_dmc_earthquake",
		"inv_misc_dmc_hurricane",
		"inv_misc_dmc_tsunami",
		"inv_misc_dmc_volcano",
		"inv_misc_tolbaradsearchlight",
		"inv_misc_masterofanatomy",
		"inv_misc_savageleatherscraps",
		"inv_misc_deepseascales",
		"inv_misc_skinningknife",
		"inv_misc_monsterscales_13",

		"Inv_misc_demonsoul",

		"Creature_SporeMushroom",
		"Creatureportrait_AltarofAir_01",
		"Creatureportrait_AltarofEarth_01",
		"Creatureportrait_AltarofFlame",
		"Creatureportrait_AltarofFrost_01",
		"Creatureportrait_BE_ScryingOrb_Epic",
		"Creatureportrait_Blackrock_ChainsOfWoe",
		"Creatureportrait_Blackrockv2_Shieldgong",
		"Creatureportrait_Blackrockv2_Shieldgong_02",
		"Creatureportrait_Blackrockv2_Shieldgong_Broken",
		"Creatureportrait_Bubble",
		"Creatureportrait_Cannon03",
		"Creatureportrait_Creature_Iceblock",
		"Creatureportrait_Cyclone_Nodebris",
		"Creatureportrait_Darkshoreboat",
		"Creatureportrait_FK_PlagueBarrel",
		"Creatureportrait_G_Bomb_02",
		"Creatureportrait_Goblin_Rocket",
		"Creatureportrait_IllidanCrystal01",
		"Creatureportrait_infernal_ball_02",
		"Creatureportrait_Mageportal_Undercity",
		"Creatureportrait_Plague Sprayer",
		"MountJournalPortrait",
		"Creatureportrait_portal_alteracvalleyhorde",
		"Creatureportrait_Portal_ArathiBasinAlliance",
		"Creatureportrait_portal_arathibasinhorde",
		"Creatureportrait_Portal_EyeOfTheStormAlliance",
		"Creatureportrait_portal_eyeofthestormhorde",
		"Creatureportrait_Portal_isleofconquestAlliance",
		"Creatureportrait_portal_isleofconquesthorde",
		"Creatureportrait_portal_strandoftheancients",
		"Creatureportrait_portal_warsonggulchhorde",
		"Creatureportrait_Pygmy_Drums_02",
		"Creatureportrait_RopeLadder01",
		"Creatureportrait_Saltwater_Star",
		"Creatureportrait_SC_Blighter",
		"Creatureportrait_SC_EyeofAcherus_02",
		"Creatureportrait_SC_Wagon",
		"Creatureportrait_TwilightsHammer_DragonEgg_01",
		"Creatureportrait_TwilightsHammer_DragonEgg_02",
		"Creatureportrait_TwilightsHammer_DragonEgg_Red_01",
		"Creatureportrait_Twilightshammer_lava_magicball",
		"Creatureportrait_TwilightsHammer_MagicalDevice_04",
		"Creatureportrait_TwilightsHammer_SummoningPortal_Water01",
		"Creatureportrait_UL_Chandelier",
		"Creatureportrait_Garalon", 
		"ClassIcon_DeathKnight", 
		"ClassIcon_Druid", 
		"ClassIcon_Hunter", 
		"ClassIcon_Mage", 
		"ClassIcon_Monk", 
		"ClassIcon_Paladin", 
		"ClassIcon_Priest", 
		"ClassIcon_Rogue", 
		"ClassIcon_Shaman", 
		"ClassIcon_Warlock", 
		"ClassIcon_Warrior", 
		"Class_Monk",
		"ExpansionIcon_BurningCrusade", 
		"ExpansionIcon_Cataclysm", 
		"ExpansionIcon_Classic", 
		"ExpansionIcon_MistsofPandaria", 
		"ExpansionIcon_WrathoftheLichKing",
		"INV_Legendary_TheBlackPrince",  
		"TalentSpec_Druid_Balance", 
		"TalentSpec_Druid_Feral_Bear", 
		"TalentSpec_Druid_Feral_Cat", 
		"TalentSpec_Druid_Restoration", 
		"Tracking_WildPet", 
		"RaceChange", 
		"FactionChange", 
	    "WoW_Store", 
		"Creatureportrait_FomorHand", 
		"Creature_The_Living_Mountain", 
		"Garrison_ArmorUpgrade", 
		"Garrison_BlueArmor", 
		"Garrison_BlueArmorUpgrade", 
		"Garrison_BlueWeapon", 
		"Garrison_BlueWeaponUpgrade", 
		"Garrison_BronzeChest", 
		"Garrison_Build", 
		"Garrison_Building_Armory", 
		"Garrison_Building_Barn", 
		"Garrison_Building_Barracks", 
		"Garrison_Building_Lumbermill", 
		"Garrison_Building_MageTower", 
		"Garrison_Building_Menagerie", 
		"Garrison_Building_SalvageYard", 
		"Garrison_Building_SparringArena", 
		"Garrison_Building_Stables", 
		"Garrison_Building_Storehouse", 
		"Garrison_Building_TradingPost", 
		"Garrison_Building_Workshop", 

		"Garrison_GreenArmor", 
		"Garrison_GreenArmorUpgrade", 
		"Garrison_GreenWeapon", 
		"Garrison_GreenWeaponUpgrade", 
		"Garrison_Material", 
		"Garrison_PurpleArmor", 
		"Garrison_PurpleArmorUpgrade", 
		"Garrison_PurpleWeapon", 
		"Garrison_PurpleWeaponUpgrade", 
		"Garrison_SilverChest", 
		"Garrison_Upgrade", 
		"Garrison_WeaponUpgrade", 
		"Garr_CurrencyIcon-Xp", 

		"HighmaulRaid_Range_Close", 
		"HighmaulRaid_Range_Far", 
		"HighmaulRaid_Range_Medium", 
		"INV_Misc_1H_BlacksmithChisel_A_01", 
		"INV_Misc_1h_BlacksmithHammer_A_01", 
		"INV_Misc_1H_BlacksmithShovel_A_01", 
		"INV_Misc_1h_bucket_b_01", 
		"INV_Misc_1h_bucket_c_01", 
		"INV_Misc_1H_FarmHoe_A_01", 
		"INV_Misc_1h_FarmSickle_A_01", 
		"INV_Misc_1H_InnMeatCleaver_A_01", 
		"INV_Misc_1h_IronHordeTools_A_01", 
		"INV_Misc_1h_IronHordeTools_A_02", 
		"INV_Misc_1H_JewelCraftingTool_A_03", 
		"INV_Misc_1H_JewelCraftingTool_A_04", 
		"INV_Misc_1H_JewelCraftingTool_A_05", 
		"INV_Misc_1h_LumberAxe_A_01", 
		"INV_Misc_1h_LumberMallet_A_01", 
		"INV_Misc_1H_LumbermillChisel_A_01", 
		"INV_Misc_1H_LumbermillChisel_A_02", 
		"INV_Misc_1h_OgreMiningTool_A_01", 
		"INV_Misc_1h_OgreMiningTool_A_02", 
		"INV_Misc_1H_OrcClansBlacksmithHammer_A_01", 
		"INV_Misc_1H_OrcClansBlacksmithHammer_A_02", 
		"INV_Misc_1H_OrcClansMallet_A_01", 
		"INV_Misc_1H_ThunderlordWineHammer_A_01", 
		"INV_Misc_1H_WateringCan_A_01", 
		"INV_Misc_1H_Wrench_A_02", 
		"INV_Misc_2H_DraenorFishingPole_A_01", 
		"INV_Misc_2H_DraenorFishingPole_B_01", 
		"INV_Misc_2H_FarmHoe_A_01", 
		"INV_Misc_2h_FarmPitchfork_A_01", 
		"INV_Misc_2h_FarmScythe_A_01", 
		"INV_Misc_2h_FarmShovel_A_01", 
		"INV_Misc_2H_Wrench_A_01", 
		"UI_Promotion_CharacterBoost", 
		"UI_Promotion_Garrisons", 

		"Organic_reflect01", 
		"XPBonus_Icon", 
	}
	GHM_StockIcons["Zones"] = {
		"Achievement_Zone_AlteracMountains_01",
		"Achievement_Zone_ArathiHighlands_01",
		"Achievement_Zone_Ashenvale_01",
		"Achievement_Zone_Azshara_01",
		"Achievement_Zone_AzuremystIsle_01",
		"Achievement_Zone_Badlands_01",
		"Achievement_Zone_Barrens_01",
		"Achievement_Zone_Blackrock_01",
		"Achievement_Zone_BladesEdgeMtns_01",
		"Achievement_Zone_BlastedLands_01",
		"Achievement_Zone_BloodmystIsle_01",
		"Achievement_Zone_BoreanTundra_01",
		"Achievement_Zone_BoreanTundra_02",
		"Achievement_Zone_BoreanTundra_03",
		"Achievement_Zone_BoreanTundra_04",
		"Achievement_Zone_BoreanTundra_05",
		"Achievement_Zone_BoreanTundra_06",
		"Achievement_Zone_BoreanTundra_07",
		"Achievement_Zone_BoreanTundra_08",
		"Achievement_Zone_BoreanTundra_09",
		"Achievement_Zone_BoreanTundra_10",
		"Achievement_Zone_BoreanTundra_11",
		"Achievement_Zone_BoreanTundra_12",
		"Achievement_Zone_BurningSteppes_01",
		"Achievement_Zone_CrystalSong_01",
		"Achievement_Zone_CrystalSong_02",
		"Achievement_Zone_CrystalSong_03",
		"Achievement_Zone_CrystalSong_04",
		"Achievement_Zone_Darkshore_01",
		"Achievement_Zone_Darnassus",
		"Achievement_Zone_DeadwindPass",
		"Achievement_Zone_Desolace",
		"Achievement_Zone_DragonBlight_01",
		"Achievement_Zone_DragonBlight_02",
		"Achievement_Zone_DragonBlight_03",
		"Achievement_Zone_DragonBlight_04",
		"Achievement_Zone_DragonBlight_05",
		"Achievement_Zone_DragonBlight_06",
		"Achievement_Zone_DragonBlight_07",
		"Achievement_Zone_DragonBlight_08",
		"Achievement_Zone_DragonBlight_09",
		"Achievement_Zone_DragonBlight_10",
		"Achievement_Zone_DragonBlight_11",
		"Achievement_Zone_DragonBlight_12",
		"Achievement_Zone_DunMorogh",
		"Achievement_Zone_Durotar",
		"Achievement_Zone_Duskwood",
		"Achievement_Zone_DustwallowMarsh",
		"Achievement_Zone_EasternKingdoms_01",
		"Achievement_Zone_EasternPlaguelands",
		"Achievement_Zone_ElwynnForest",
		"Achievement_Zone_EversongWoods",
		"Achievement_Zone_Felwood",
		"Achievement_Zone_Feralas",
		"Achievement_Zone_Ghostlands",
		"Achievement_Zone_GrizzlyHills_01",
		"Achievement_Zone_GrizzlyHills_02",
		"Achievement_Zone_GrizzlyHills_03",
		"Achievement_Zone_GrizzlyHills_04",
		"Achievement_Zone_GrizzlyHills_05",
		"Achievement_Zone_GrizzlyHills_06",
		"Achievement_Zone_GrizzlyHills_07",
		"Achievement_Zone_GrizzlyHills_08",
		"Achievement_Zone_GrizzlyHills_09",
		"Achievement_Zone_GrizzlyHills_10",
		"Achievement_Zone_GrizzlyHills_11",
		"Achievement_Zone_GrizzlyHills_12",
		"Achievement_Zone_HellfirePeninsula_01",
		"Achievement_Zone_HillsbradFoothills",
		"Achievement_Zone_Hinterlands_01",
		"Achievement_Zone_HowlingFjord_01",
		"Achievement_Zone_HowlingFjord_02",
		"Achievement_Zone_HowlingFjord_03",
		"Achievement_Zone_HowlingFjord_04",
		"Achievement_Zone_HowlingFjord_05",
		"Achievement_Zone_HowlingFjord_06",
		"Achievement_Zone_HowlingFjord_07",
		"Achievement_Zone_HowlingFjord_08",
		"Achievement_Zone_HowlingFjord_09",
		"Achievement_Zone_HowlingFjord_10",
		"Achievement_Zone_HowlingFjord_11",
		"Achievement_Zone_HowlingFjord_12",
		"Achievement_Zone_IceCrown_01",
		"Achievement_Zone_IceCrown_02",
		"Achievement_Zone_IceCrown_03",
		"Achievement_Zone_IceCrown_04",
		"Achievement_Zone_IceCrown_05",
		"Achievement_Zone_IceCrown_06",
		"Achievement_Zone_IceCrown_07",
		"Achievement_Zone_IceCrown_08",
		"Achievement_Zone_IceCrown_09",
		"Achievement_Zone_IceCrown_10",
		"Achievement_Zone_IceCrown_11",
		"Achievement_Zone_IceCrown_12",
		"Achievement_Zone_Ironforge",
		"Achievement_Zone_IsleOfQuelDanas",
		"Achievement_Zone_Kalimdor_01",
		"Achievement_Zone_LochModan",
		"Achievement_Zone_Mulgore_01",
		"Achievement_Zone_Nagrand_01",
		"Achievement_Zone_Netherstorm_01",
		"Achievement_Zone_Northrend_01",
		"Achievement_Zone_Outland_01",
		"Achievement_Zone_RedridgeMountains",
		"Achievement_Zone_SearingGorge_01",
		"Achievement_Zone_Shadowmoon",
		"Achievement_Zone_Sholazar_01",
		"Achievement_Zone_Sholazar_02",
		"Achievement_Zone_Sholazar_03",
		"Achievement_Zone_Sholazar_04",
		"Achievement_Zone_Sholazar_05",
		"Achievement_Zone_Sholazar_06",
		"Achievement_Zone_Sholazar_07",
		"Achievement_Zone_Sholazar_08",
		"Achievement_Zone_Sholazar_09",
		"Achievement_Zone_Sholazar_10",
		"Achievement_Zone_Sholazar_11",
		"Achievement_Zone_Sholazar_12",
		"Achievement_Zone_Silithus_01",
		"Achievement_Zone_Silverpine_01",
		"Achievement_Zone_Stonetalon_01",
		"Achievement_Zone_StormPeaks_01",
		"Achievement_Zone_StormPeaks_02",
		"Achievement_Zone_StormPeaks_03",
		"Achievement_Zone_StormPeaks_04",
		"Achievement_Zone_StormPeaks_05",
		"Achievement_Zone_StormPeaks_06",
		"Achievement_Zone_StormPeaks_07",
		"Achievement_Zone_StormPeaks_08",
		"Achievement_Zone_StormPeaks_09",
		"Achievement_Zone_StormPeaks_10",
		"Achievement_Zone_StormPeaks_11",
		"Achievement_Zone_StormPeaks_12",
		"Achievement_Zone_Stranglethorn_01",
		"Achievement_Zone_SwampSorrows_01",
		"Achievement_Zone_Tanaris_01",
		"Achievement_Zone_Terrokar",
		"Achievement_Zone_ThousandNeedles_01",
		"Achievement_Zone_TirisfalGlades_01",
		"Achievement_Zone_UnGoroCrater_01",
		"Achievement_Zone_WesternPlaguelands_01",
		"Achievement_Zone_WestFall_01",
		"Achievement_Zone_Wetlands_01",
		"Achievement_Zone_Winterspring",
		"Achievement_Zone_Zangarmarsh",
		"Achievement_Zone_ZulDrak_01",
		"Achievement_Zone_ZulDrak_02",
		"Achievement_Zone_ZulDrak_03",
		"Achievement_Zone_ZulDrak_04",
		"Achievement_Zone_ZulDrak_05",
		"Achievement_Zone_ZulDrak_06",
		"Achievement_Zone_ZulDrak_07",
		"Achievement_Zone_ZulDrak_08",
		"Achievement_Zone_ZulDrak_09",
		"Achievement_Zone_ZulDrak_10",
		"Achievement_Zone_ZulDrak_11",
		"Achievement_Zone_ZulDrak_12",

		"achievement_zone_gilneas_01",
		"achievement_zone_gilneas_02",
		"Achievement_Zone_DeepHolm",
		"Achievement_Zone_Cataclysm",
		"Achievement_Zone_Ashran", 
		"Achievement_Zone_Draenor_01", 
		"Achievement_Zone_Frostfire", 
		"Achievement_Zone_Gorgrond", 
		"Achievement_Zone_Nagrand_02", 
		"Achievement_Zone_Newshadowmoonvalley", 
		"Achievement_Zone_SpiresofArak", 
		"Achievement_Zone_Talador", 
		"Achievement_Zone_Tanaanjungle", 
	}
	GHM_StockIcons["Arena"] = {
		"Achievement_Arena_2v2_1",
		"Achievement_Arena_2v2_2",
		"Achievement_Arena_2v2_3",
		"Achievement_Arena_2v2_4",
		"Achievement_Arena_2v2_5",
		"Achievement_Arena_2v2_6",
		"Achievement_Arena_2v2_7",
		"Achievement_Arena_3v3_1",
		"Achievement_Arena_3v3_2",
		"Achievement_Arena_3v3_3",
		"Achievement_Arena_3v3_4",
		"Achievement_Arena_3v3_5",
		"Achievement_Arena_3v3_6",
		"Achievement_Arena_3v3_7",
		"Achievement_Arena_5v5_1",
		"Achievement_Arena_5v5_2",
		"Achievement_Arena_5v5_3",
		"Achievement_Arena_5v5_4",
		"Achievement_Arena_5v5_5",
		"Achievement_Arena_5v5_6",
		"Achievement_Arena_5v5_7",
		"Achievement_FeatsOfStrength_Gladiator_01",
		"Achievement_FeatsOfStrength_Gladiator_02",
		"Achievement_FeatsOfStrength_Gladiator_03",
		"Achievement_FeatsOfStrength_Gladiator_04",
		"Achievement_FeatsOfStrength_Gladiator_05",
		"Achievement_FeatsOfStrength_Gladiator_06",
		"Achievement_FeatsOfStrength_Gladiator_07",
		"Achievement_FeatsOfStrength_Gladiator_08",
		"Achievement_FeatsOfStrength_Gladiator_09",
		"Achievement_FeatsOfStrength_Gladiator_10",
	}
	GHM_StockIcons["Battleground"] = {
		"Achievement_BG_3flagcap_nodeaths",
		"Achievement_BG_AB_crosson _barrels",
		"Achievement_BG_AB_defendflags",
		"Achievement_BG_AB_kill_in_mine",
		"Achievement_BG_ABshutout",
		"Achievement_BG_captureflag_EOS",
		"Achievement_BG_captureflag_WSG",
		"Achievement_BG_DefendXtowers_AV",
		"Achievement_BG_getXflags_no_die",
		"Achievement_BG_grab_cap_flagunderXseconds",
		"Achievement_BG_hld4bases_EOS",
		"Achievement_BG_interruptX_flagcapture_attempts",
		"Achievement_BG_interruptX_flagcapture_attempts_1game",
		"Achievement_BG_kill_flag_carrier",
		"Achievement_BG_kill_flag_carrierEOS",
		"Achievement_BG_kill_flag_carrierWSG",
		"Achievement_BG_kill_on_mount",
		"Achievement_BG_KillFlagCarriers_grabFlag_CapIt",
		"Achievement_BG_killingblow_30",
		"Achievement_BG_killingblow_berserker",
		"Achievement_BG_killingblow_most",
		"Achievement_BG_killingblow_startingrock",
		"Achievement_BG_KillXEnemies_GeneralsRoom",
		"Achievement_BG_masterofallBGs",
		"Achievement_BG_most_damage_killingblow_dieleast",
		"Achievement_BG_overcome500disadvantage",
		"Achievement_BG_returnXflags_def_WSG",
		"Achievement_BG_takeXflags_AB",
		"Achievement_BG_topDPS",
		"Achievement_BG_tophealer_AB",
		"Achievement_BG_tophealer_AV",
		"Achievement_BG_tophealer_EOS",
		"Achievement_BG_tophealer_SOA",
		"Achievement_BG_tophealer_WSG",
		"Achievement_BG_trueAVshutout",
		"Achievement_BG_win_AB_X_times",
		"Achievement_BG_win_AV_X_times",
		"Achievement_BG_win_EOS_X_times",
		"Achievement_BG_win_WSG_X_times",
		"Achievement_BG_winAB",
		"Achievement_BG_winAB_5cap",
		"Achievement_BG_winAB_underXminutes",
		"Achievement_BG_winAV",
		"Achievement_BG_winAV_bothmines",
		"Achievement_BG_winAV_underXminutes",
		"Achievement_BG_winbyten",
		"Achievement_BG_winEOS",
		"Achievement_BG_winEOS_underXminutes",
		"Achievement_BG_winSOA",
		"Achievement_BG_winSOA_underXminutes",
		"Achievement_BG_winWSG",
		"Achievement_BG_winWSG_3-0",
		"Achievement_BG_winWSG_underXminutes",
		"Achievement_BG_Xkills_AVgraveyard",
		"Achievement_BG_DG_Master_of_the_deepwind_gorge", 
		"Achievement_Ashran_Tourofduty", 
	}
	GHM_StockIcons["Boss"] = {
		"Achievement_Shivan",
		"achievment_Boss_Blackhorn",
		"achievment_Boss_Hagara",
		"achievment_Boss_Madnessofdeathwing",
		"achievment_Boss_morchok",
		"achievment_Boss_spineofdeathwing",
		"achievment_Boss_ultraxion",
		"achievment_Boss_wellofeternity",
		"achievment_Boss_yorsahj",
		"achievment_Boss_zonozz",
		"achievment_raid_houroftwilight",
		"Achievement_Boss_Amnennar_the_Coldbringer",
		"Achievement_Boss_Archaedas",
		"Achievement_Boss_Archimonde ",
		"Achievement_Boss_Bazil_Akumai",
		"Achievement_Boss_Bazil_Thredd",
		"Achievement_Boss_CThun",
		"Achievement_Boss_Drakkisath",
		"Achievement_Boss_EdwinVancleef",
		"Achievement_Boss_EmperorDagranThaurissan",
		"Achievement_Boss_Exarch_Maladaar",
		"Achievement_Boss_GruulTheDragonkiller",
		"Achievement_Boss_Hakkar",
		"Achievement_Boss_Harbinger_Skyriss",
		"Achievement_Boss_Illidan",
		"Achievement_Boss_Kael'thasSunstrider_01",
		"Achievement_Boss_KelidanTheBreaker",
		"Achievement_Boss_Kiljaedan",
		"Achievement_BOSS_KINGYMIRON_01",
		"Achievement_BOSS_KINGYMIRON_02",
		"Achievement_BOSS_KINGYMIRON_03",
		"Achievement_Boss_LadyVashj",
		"Achievement_Boss_Magtheridon",
		"Achievement_Boss_Mekgineer_Thermaplugg ",
		"Achievement_Boss_Mutanus_the_Devourer",
		"Achievement_Boss_Nexus_Prince_Shaffar",
		"Achievement_Boss_Overlord_Wyrmthalak",
		"Achievement_Boss_Prince_Malchezaar",
		"Achievement_Boss_Quagmirran",
		"Achievement_Boss_TalonKingIkiss",
		"Achievement_Boss_Warlord_Kalithresh",
		"Achievement_Boss_WarpSplinter",
		"Achievement_Boss_Zuljin",
		"Achievement_Boss_Aeonus_01", -- [46]
		"Achievement_Boss_Algalon_01", -- [47]
		"Achievement_Boss_Anomalus", -- [48]
		"Achievement_Boss_Anubarak", -- [49]
		"Achievement_Boss_ArchmageArugal", -- [50]
		"Achievement_Boss_Auriaya_01", -- [51]
		"Achievement_Boss_Bronjahm", -- [52]
		"Achievement_Boss_CharlgaRazorflank", -- [53]
		"Achievement_Boss_ChiefUkorzSandscalp", -- [54]
		"Achievement_Boss_cyanigosa", -- [55]
		"Achievement_Boss_DevourerofSouls", -- [56]
		"Achievement_Boss_ElderNadox", -- [57]
		"Achievement_Boss_EpochHunter", -- [58]
		"Achievement_Boss_Eregos", -- [59]
		"Achievement_Boss_FestergutRotface", -- [60]
		"Achievement_Boss_Forgemaster", -- [61]
		"Achievement_Boss_FourHorsemen", -- [62]
		"Achievement_Boss_Freya_01", -- [63]
		"Achievement_Boss_Galdarah", -- [64]
		"Achievement_Boss_GeneralBjarngrim", -- [65]
		"Achievement_Boss_GeneralDrakkisath", -- [66]
		"Achievement_Boss_GeneralVezax_01", -- [67]
		"Achievement_Boss_GrandMagusTelestra", -- [68]
		"Achievement_Boss_GrandWidowFaerlina", -- [69]
		"Achievement_Boss_Hadronox", -- [70]
		"Achievement_Boss_HeigantheUnclean", -- [71]
		"Achievement_Boss_HeraldVolazj", -- [72]
		"Achievement_Boss_Hodir_01", -- [73]
		"Achievement_Boss_Ichoron", -- [74]
		"Achievement_Boss_Ignis_01", -- [75]
		"Achievement_Boss_InfiniteCorruptor", -- [76]
		"Achievement_Boss_JedogaShadowseeker", -- [77]
		"Achievement_Boss_KargathBladefist_01", -- [78]
		"Achievement_Boss_KelThuzad_01", -- [79]
		"Achievement_Boss_Keristrasza", -- [80]
		"Achievement_Boss_KickandTrick", -- [81]
		"ACHIEVEMENT_BOSS_KILJAEDAN", -- [82]
		"Achievement_Boss_kingdred", -- [83]
		"Achievement_Boss_KingYmiron", -- [84]
		"ACHIEVEMENT_BOSS_KINGYMIRON_01", -- [85]
		"ACHIEVEMENT_BOSS_KINGYMIRON_02", -- [86]
		"ACHIEVEMENT_BOSS_KINGYMIRON_03", -- [87]
		"Achievement_Boss_Kologarn_01", -- [88]
		"Achievement_Boss_Krikthir", -- [89]
		"Achievement_Boss_LadyDeathwhisper", -- [90]
		"ACHIEVEMENT_BOSS_LADYVASHJ", -- [91]
		"Achievement_Boss_Lanathel", -- [92]
		"Achievement_Boss_LichKing", -- [93]
		"Achievement_Boss_Loatheb", -- [94]
		"Achievement_Boss_LordMarrowgar", -- [95]
		"Achievement_Boss_maexxna", -- [96]
		"Achievement_Boss_MaidenofGrief", -- [97]
		"Achievement_Boss_Malygos_01", -- [98]
		"Achievement_Boss_Mimiron_01", -- [99]
		"Achievement_Boss_Moorabi", -- [100]
		"Achievement_Boss_Murmur", -- [101]
		"Achievement_Boss_Murmur_01", -- [102]
		"Achievement_Boss_Nefarion", -- [103]
		"Achievement_Boss_novos", -- [104]
		"Achievement_Boss_OmarTheUnscarred_01", -- [105]
		"Achievement_Boss_Onyxia", -- [106]
		"Achievement_Boss_OssirianTheUnscarred", -- [107]
		"Achievement_Boss_patchwerk", -- [108]
		"Achievement_Boss_PathaleonTheCalculator", -- [109]
		"Achievement_Boss_PrinceKeleseth", -- [110]
		"Achievement_Boss_PrinceMalchezaar_02", -- [111]
		"Achievement_Boss_PrincessTheradras", -- [112]
		"Achievement_Boss_PrinceTaldaram", -- [113]
		"Achievement_Boss_ProfPutricide", -- [114]
		"Achievement_Boss_Ragnaros", -- [115]
		"Achievement_Boss_Razorscale", -- [116]
		"Achievement_Boss_Razorscale_01", -- [117]
		"Achievement_Boss_Sapphiron_01", -- [118]
		"Achievement_Boss_Sartharion_01", -- [119]
		"Achievement_Boss_Saurfang", -- [120]
		"Achievement_Boss_ScourgelordTyrannus", -- [121]
		"Achievement_Boss_ShadeOfEranikus", -- [122]
		"Achievement_Boss_Sindragosa", -- [123]
		"Achievement_Boss_Sjonnir", -- [124]
		"Achievement_Boss_Skadi", -- [125]
		"Achievement_Boss_Skybreaker", -- [126]
		"Achievement_Boss_Sladran", -- [127]
		"Achievement_Boss_SvalaSorrowgrave", -- [128]
		"Achievement_Boss_thaddius", -- [129]
		"Achievement_Boss_theBlackStalker", -- [130]
		"Achievement_Boss_TheFlameLeviathan_01", -- [131]
		"Achievement_Boss_TheIronCouncil_01", -- [132]
		"Achievement_Boss_Thorim", -- [133]
		"Achievement_Boss_TribunalofAges", -- [134]
		"Achievement_Boss_trollgore", -- [135]
		"Achievement_Boss_Valanar", -- [136]
		"Achievement_Boss_ValithraDreamwalker", -- [137]
		"Achievement_Boss_Volkhan", -- [138]
		"Achievement_Boss_XT002Deconstructor_01", -- [139]
		"Achievement_Boss_YoggSaron_01", -- [140]
		"Achievement_Boss_Zuramat", -- [141]
		"Achievement_Festergutrotface", -- [171]
		"Achievement_Forgemaster", -- [172]
		"Achievement_kickandfrick", -- [173]
		"Achievement_Ladydeathwhisper", -- [174]

		"achievement_dungeon_blackwingdescent_raid_nefarian",
		"Achievement_Dungeon_Bastion Of Twilight_Halfus Wyrmbreaker",
		"achievement_dungeon_blackwingdescent_raid_atramedes",
		"achievement_dungeon_bastion of twilight_chogall boss",
		"achievement_dungeon_bastion of twilight_ladysinestra",
		"achievement_dungeon_bastion of twilight_twilightascendantcouncil",
		"achievement_dungeon_bastion of twilight_valiona theralion",
		"achievement_dungeon_blackwingdescent_raid_maloriak",
		"achievement_dungeon_blackwingdescent_raid_chimaron",

		"achievement_dungeon_the stonecore_ozruk",

		"achievement_dungeon_blackrockcaverns_karshsteelbender",
		"achievement_dungeon_blackrockcaverns_beauty",
		"achievement_dungeon_blackrockcaverns_ascendantlordobsidius",
		"achievement_dungeon_blackrockcaverns_corla herald of twilight",
		"achievement_dungeon_blackrockcaverns_romogg bonecrusher",
		"achievement_dungeon_blackwingdescent_raid_onyxia",
		"achievement_dungeon_grimbatol_drahga the shadowburner",
		"achievement_dungeon_grimbatol_erudax",
		"achievement_dungeon_grimbatol_general umbriss",
		"achievement_dungeon_the stonecore_corborus",
		"achievement_dungeon_throne of the tides_ozumat",

		"Achievement_Dungeon_BlackwingDescent_DarkIronCouncil",

		"achievement_dungeon_thevortexpinnacle_altairus", --Icon Was Missing.
		"achievement_dungeon_thevortexpinnacle_asaad", --Icon Was Missing.
		"achievement_dungeon_thevortexpinnacle_lordertan", --Icon Was Missing

		"achievement_dungeon_lostcity of tolvir_highprophetbarim", --Icon Was Missing.
		"achievement_dungeon_lostcity of tolvir_lockmaw", --Icon Was Missing.
		"achievement_dungeon_lostcity of tolvir_siamatlord", --Icon Was Missing.

		"achievement_dungeon_halls of origination_templeguardiananhuur",
		"achievement_dungeon_halls of origination_anraphet",
		"Achievement_Dungeon_Halls Of Origination_Ammunae",
		"Achievement_Dungeon_Halls Of Origination_Earthrager Ptah",
		"Achievement_Dungeon_Halls Of Origination_Isiset",
		"Achievement_Dungeon_Halls Of Origination_Rajh",
		"Achievement_Dungeon_Halls Of Origination_Setesh",
		"Achievement_Dungeon_The Stonecore_Slabhide",
		 
		"Achievement_Boss_CouncilofElders", 
		"Achievement_Boss_Durumu", 
		"Achievement_Boss_Horridon", 
		"Achievement_Boss_Ji-Kun", 
		"Achievement_Boss_JinrokhTheBreaker", 
		"Achievement_Boss_Megaera", 
		"Achievement_Boss_Primordius", 
		"Achievement_Boss_Ra_Den", 
		"Achievement_Boss_Tortos", 
	
		"Achievement_Raid_ForgottenDepths", 
		"Achievement_Raid_Hall_Of_Flesh", 
		"Achievement_Raid_LastStandZandalari", 
		"Achievement_Raid_Pinnacle_Of_Stroms", 
		"Achievement_Raid_Thunder_King", 
		
		
		"Achievement_Boss_Galakras", 
		"Achievement_Boss_Garrosh", 
		"Achievement_Boss_General_Nazgrim", 
		"Achievement_Boss_Golden_Lotus_Council", 
		"Achievement_Boss_Immerseus", 
		"Achievement_Boss_Ironjuggernaut", 
		"Achievement_Boss_Klaxxi_paragons", 
		"Achievement_Boss_KorkronDarkShaman", 
		"Achievement_Boss_Malkorok", 
		"Achievement_Boss_Norushen", 
		"Achievement_Boss_SiegeCrafter_Blackfuse", 
		"Achievement_Boss_spoils_of_pandaria", 
		"Achievement_Boss_ThokTheBloodthirsty", 
		"Achievement_Raid_SoO_Garrosh_Compound_Half1", 
		"Achievement_Raid_SoO_Garrosh_Compound_Half2", 
		"Achievement_Raid_SoO_Orgrimmar_outdoors", 
		"Achievement_Raid_SoO_Ruined_Vale", 
		"Achievement_Boss_Anomalus", 
		"Achievement_Boss_Blackhand", 
		"Achievement_Boss_Breaker_Darmac", 
		"Achievement_Boss_cyanigosa", 
		"Achievement_Boss_ElderNadox", 
		"Achievement_Boss_Eregos", 
		"Achievement_Boss_Flamebender_FomorSmith", 
		"Achievement_Boss_Flamebender_Kagraz", 
		"Achievement_Boss_FomorSmith", 
		"Achievement_Boss_FourHorsemen", 
		"Achievement_Boss_FuryFurnace", 
		"Achievement_Boss_Galdarah", 
		"Achievement_Boss_GeneralBjarngrim", 
		"Achievement_Boss_GrandMagusTelestra", 
		"Achievement_Boss_GrandWidowFaerlina", 
		"Achievement_Boss_Gruul", 
		"Achievement_Boss_Hadronox", 
		"Achievement_Boss_HeigantheUnclean", 
		"Achievement_Boss_HighMaul_AggronGuardian", 
		"Achievement_Boss_HighMaul_Butcher", 
		"Achievement_Boss_HighMaul_EarthenFury", 
		"Achievement_Boss_HighMaul_FelbreakerLord", 
		"Achievement_Boss_HighMaul_FungalGiant", 
		"Achievement_Boss_HighMaul_Kargath", 
		"Achievement_Boss_HighMaul_King", 
		"Achievement_Boss_Ichoron", 
		"Achievement_Boss_InfiniteCorruptor", 
		"Achievement_Boss_IronMaidens", 
		"Achievement_Boss_JedogaShadowseeker", 
		"Achievement_Boss_Keristrasza", 
		"Achievement_Boss_kingdred", 
		"Achievement_Boss_Krikthir", 
		"Achievement_Boss_Loatheb", 
		"Achievement_Boss_maexxna", 
		"Achievement_Boss_MaidenofGrief", 
		"Achievement_Boss_Moorabi", 
		"Achievement_Boss_novos", 
		"Achievement_Boss_Operator_Thogar", 
		"Achievement_Boss_Oregorger", 
		"Achievement_Boss_patchwerk", 
		"Achievement_Boss_PrinceKeleseth", 
		"Achievement_Boss_Sjonnir", 
		"Achievement_Boss_Skadi", 
		"Achievement_Boss_Sladran", 
		"Achievement_Boss_thaddius", 
		"Achievement_Boss_trollgore", 
		"Achievement_Boss_TwinOrcBrutes", 
		"Achievement_Boss_Volkhan", 
		"Achievement_Boss_Zuramat", 
 
	}
	GHM_StockIcons["Character"] = {
		"Achievement_Character_Bloodelf_Female",
		"Achievement_Character_Bloodelf_Male",
		"Achievement_Character_Draenei_Female",
		"Achievement_Character_Draenei_Male",
		"Achievement_Character_Dwarf_Female",
		"Achievement_Character_Dwarf_Male",
		"Achievement_Character_Gnome_Female",
		"Achievement_Character_Gnome_Male",
		"Achievement_Character_Human_Female",
		"Achievement_Character_Human_Male",
		"Achievement_Character_Nightelf_Female",
		"Achievement_Character_Nightelf_Male",
		"Achievement_Character_Orc_Female",
		"Achievement_Character_Orc_Male",
		"Achievement_Character_Tauren_Female",
		"Achievement_Character_Tauren_Male",
		"Achievement_Character_Troll_Female",
		"Achievement_Character_Troll_Male",
		"Achievement_Character_Undead_Female",
		"Achievement_Character_Undead_Male",
	}
	GHM_StockIcons["Dungeon"] = {
		"Achievement_Dungeon_AzjolLowercity",
		"Achievement_Dungeon_AzjolLowercity_10man",
		"Achievement_Dungeon_AzjolLowercity_25man",
		"Achievement_Dungeon_AzjolLowercity_Heroic",
		"Achievement_Dungeon_AzjolLowercity_Normal",
		"Achievement_Dungeon_AzjolUppercity",
		"Achievement_Dungeon_AzjolUppercity_10man",
		"Achievement_Dungeon_AzjolUppercity_25man",
		"Achievement_Dungeon_AzjolUppercity_Heroic",
		"Achievement_Dungeon_AzjolUppercity_Normal",
		"Achievement_Dungeon_CoABlackDragonflight",
		"Achievement_Dungeon_CoABlackDragonflight_10man",
		"Achievement_Dungeon_CoABlackDragonflight_25man",
		"Achievement_Dungeon_CoABlackDragonflight_Heroic",
		"Achievement_Dungeon_CoABlackDragonflight_Normal",
		"Achievement_Dungeon_CoTStratholme",
		"Achievement_Dungeon_CoTStratholme_10man",
		"Achievement_Dungeon_CoTStratholme_25man",
		"Achievement_Dungeon_CoTStratholme_Heroic",
		"Achievement_Dungeon_CoTStratholme_Normal",
		"Achievement_Dungeon_Drak'Tharon",
		"Achievement_Dungeon_Drak'Tharon_10man",
		"Achievement_Dungeon_Drak'Tharon_25man",
		"Achievement_Dungeon_Drak'Tharon_Heroic",
		"Achievement_Dungeon_Drak'Tharon_Normal",
		"Achievement_Dungeon_Gundrak",
		"Achievement_Dungeon_Gundrak_10man",
		"Achievement_Dungeon_Gundrak_25man",
		"Achievement_Dungeon_Gundrak_Heroic",
		"Achievement_Dungeon_Gundrak_Normal",
		"Achievement_Dungeon_Naxxramas",
		"Achievement_Dungeon_Naxxramas_10man",
		"Achievement_Dungeon_Naxxramas_25man",
		"Achievement_Dungeon_Naxxramas_Heroic",
		"Achievement_Dungeon_Naxxramas_Normal",
		"Achievement_Dungeon_Nexus70",
		"Achievement_Dungeon_Nexus70_10man",
		"Achievement_Dungeon_Nexus70_25man",
		"Achievement_Dungeon_Nexus70_Heroic",
		"Achievement_Dungeon_Nexus70_Normal",
		"Achievement_Dungeon_Nexus80",
		"Achievement_Dungeon_Nexus80_10man",
		"Achievement_Dungeon_Nexus80_25man",
		"Achievement_Dungeon_Nexus80_Heroic",
		"Achievement_Dungeon_Nexus80_Normal",
		"Achievement_Dungeon_NexusRaid",
		"Achievement_Dungeon_NexusRaid_10man",
		"Achievement_Dungeon_NexusRaid_25man",
		"Achievement_Dungeon_NexusRaid_Heroic",
		"Achievement_Dungeon_NexusRaid_Normal",
		"Achievement_Dungeon_TheVioletHold",
		"Achievement_Dungeon_TheVioletHold_10man",
		"Achievement_Dungeon_TheVioletHold_25man",
		"Achievement_Dungeon_TheVioletHold_Heroic",
		"Achievement_Dungeon_TheVioletHold_Normal",
		"Achievement_Dungeon_Ulduar77",
		"Achievement_Dungeon_Ulduar77_10man",
		"Achievement_Dungeon_Ulduar77_25man",
		"Achievement_Dungeon_Ulduar77_Heroic",
		"Achievement_Dungeon_Ulduar77_Normal",
		"Achievement_Dungeon_Ulduar80",
		"Achievement_Dungeon_Ulduar80_10man",
		"Achievement_Dungeon_Ulduar80_25man",
		"Achievement_Dungeon_Ulduar80_Heroic",
		"Achievement_Dungeon_Ulduar80_Normal",
		"Achievement_Dungeon_UtgardeKeep",
		"Achievement_Dungeon_UtgardeKeep_10man",
		"Achievement_Dungeon_UtgardeKeep_25man",
		"Achievement_Dungeon_UtgardeKeep_Heroic",
		"Achievement_Dungeon_UtgardeKeep_Normal",
		"Achievement_Dungeon_UtgardePinnacle",
		"Achievement_Dungeon_UtgardePinnacle_10man",
		"Achievement_Dungeon_UtgardePinnacle_25man",
		"Achievement_Dungeon_UtgardePinnacle_Heroic",
		"Achievement_Dungeon_UtgardePinnacle_Normal",
		"Achievement_Dungeon_ClassicDungeonMaster", -- [142]
		"Achievement_Dungeon_ClassicRaider", -- [143]
		"Achievement_Dungeon_CrimsonHall", -- [144]
		"Achievement_Dungeon_FrozenThrone", -- [145]
		"Achievement_Dungeon_GloryoftheHERO", -- [146]
		"Achievement_Dungeon_GloryoftheRaider", -- [147]
		"Achievement_Dungeon_HEROIC_GloryoftheRaider", -- [148]
		"Achievement_Dungeon_HordeAirship", -- [149]
		"Achievement_Dungeon_Icecrown_ForgeofSouls", -- [150]
		"Achievement_Dungeon_Icecrown_Frostmourne", -- [151]
		"Achievement_Dungeon_Icecrown_FrostwingHalls", -- [152]
		"Achievement_Dungeon_Icecrown_HallsofReflection", -- [153]
		"Achievement_Dungeon_Icecrown_IcecrownEntrance", -- [154]
		"Achievement_Dungeon_Icecrown_PitofSaron", -- [155]
		"Achievement_Dungeon_Outland_Dungeon_Hero", -- [156]
		"Achievement_Dungeon_Outland_DungeonMaster", -- [157]
		"Achievement_Dungeon_PlagueWing", -- [158]
		"Achievement_Dungeon_UlduarRaid_Archway_01", -- [159]
		"Achievement_Dungeon_UlduarRaid_IceGiant_01", -- [160]
		"Achievement_Dungeon_UlduarRaid_IronDwarf_01", -- [161]
		"Achievement_Dungeon_UlduarRaid_IronGolem_01", -- [162]
		"Achievement_Dungeon_UlduarRaid_IronSentinel_01", -- [163]
		"Achievement_Dungeon_UlduarRaid_Misc_01", -- [164]
		"Achievement_Dungeon_UlduarRaid_Misc_02", -- [165]
		"Achievement_Dungeon_UlduarRaid_Misc_03", -- [166]
		"Achievement_Dungeon_UlduarRaid_Misc_04", -- [167]
		"Achievement_Dungeon_UlduarRaid_Misc_05", -- [168]
		"Achievement_Dungeon_UlduarRaid_Misc_06", -- [169]
		"Achievement_Dungeon_UlduarRaid_Titan_01", -- [170]
		 "Achievement_brewery", 
		"Achievement_brewery_1", 
		"Achievement_brewery_2", 
		"Achievement_brewery_3", 
		"Achievement_brewery_4", 
		"Achievement_ChallengeMode_Bronze", 
		"Achievement_ChallengeMode_Gold", 
		"Achievement_ChallengeMode_Platinum", 
		"Achievement_ChallengeMode_Silver",
		"Achievement_Dungeon_MoguPalace", 
		"Achievement_Dungeon_SiegeofNiuzaoTemple", 
		"Achievement_JadeSerpent", 
		"Achievement_JadeSerpent_1", 
		"Achievement_JadeSerpent_2", 
		"Achievement_Moguraid_01", 
		"Achievement_Moguraid_02", 
		"Achievement_Moguraid_03", 
		"Achievement_Moguraid_04", 
		"Achievement_Moguraid_05", 
		"Achievement_Moguraid_06", 
		"Achievement_Raid_MantidRaid01", 
		"Achievement_Raid_MantidRaid02", 
		"Achievement_Raid_MantidRaid03", 
		"Achievement_Raid_MantidRaid04", 
		"Achievement_Raid_MantidRaid05", 
		"Achievement_Raid_MantidRaid06", 
		"Achievement_Raid_MantidRaid07", 
		"Achievement_Raid_SecondHalfMantid", 
		"Achievement_Raid_SecondHalfMogu", 
		"Achievement_Raid_TerraceOfEndlessSpring01", 
		"Achievement_Raid_TerraceOfEndlessSpring02", 
		"Achievement_Raid_TerraceOfEndlessSpring03", 
		"Achievement_Raid_TerraceOfEndlessSpring04", 
		"Achievement_Scenario_ArenaofAnnihilation", 
		"Achievement_Scenario_AssaultonZanvess", 
		"Achievement_Scenario_BrewingStorm", 
		"Achievement_Scenario_Brewmoon", 
		"Achievement_Scenario_GreenStone", 
		"Achievement_Scenario_TombofForgottenKings", 
		"Achievement_Scenario_UngaIngoo", 		
		"Achievement_ChallengeMode_ArakkoaSpires_Bronze", 
		"Achievement_ChallengeMode_ArakkoaSpires_Gold", 
		"Achievement_ChallengeMode_ArakkoaSpires_Hourglass", 
		"Achievement_ChallengeMode_ArakkoaSpires_Silver", 
		"Achievement_ChallengeMode_Auchindoun_Bronze", 
		"Achievement_ChallengeMode_Auchindoun_Gold", 
		"Achievement_ChallengeMode_Auchindoun_Hourglass", 
		"Achievement_ChallengeMode_Auchindoun_Silver", 
		"Achievement_ChallengeMode_BlackRockDepot_Bronze", 
		"Achievement_ChallengeMode_BlackRockDepot_Gold", 
		"Achievement_ChallengeMode_BlackRockDepot_Hourglass", 
		"Achievement_ChallengeMode_BlackRockDepot_Silver", 
		"Achievement_ChallengeMode_BlackrockDocks_Bronze", 
		"Achievement_ChallengeMode_BlackrockDocks_Gold", 
		"Achievement_ChallengeMode_BlackrockDocks_Hourglass", 
		"Achievement_ChallengeMode_BlackrockDocks_Silver", 
		"Achievement_ChallengeMode_Everbloom_Bronze", 
		"Achievement_ChallengeMode_Everbloom_Gold", 
		"Achievement_ChallengeMode_Everbloom_Hourglass", 
		"Achievement_ChallengeMode_Everbloom_Silver", 
		"Achievement_ChallengeMode_OgreSlagMines_Bronze", 
		"Achievement_ChallengeMode_OgreSlagMines_Gold", 
		"Achievement_ChallengeMode_OgreSlagMines_Hourglass", 
		"Achievement_ChallengeMode_OgreSlagMines_Silver", 
		"Achievement_ChallengeMode_ShadowMoonHideout_Bronze", 
		"Achievement_ChallengeMode_ShadowMoonHideout_Gold", 
		"Achievement_ChallengeMode_ShadowMoonHideout_Hourglass", 
		"Achievement_ChallengeMode_ShadowMoonHideout_Silver", 
		"Achievement_ChallengeMode_UpperBRSpire_Bronze", 
		"Achievement_ChallengeMode_UpperBRSpire_Gold", 
		"Achievement_ChallengeMode_UpperBRSpire_Hourglass", 
		"Achievement_ChallengeMode_UpperBRSpire_Silver", 
		"ACHIEVEMENT_CHARACTER_ORC_FEMALE_BRN", 
		"ACHIEVEMENT_CHARACTER_ORC_MALE_BRN", 
		"Achievement_Dungeon_ArakkoaSpires", 
		"Achievement_Dungeon_Auchindoun", 
		"Achievement_Dungeon_BlackRockDepot", 
		"Achievement_Dungeon_BlackrockDocks", 
		"Achievement_Dungeon_Everbloom", 
		"Achievement_Dungeon_OgreslagMines", 
		"Achievement_Dungeon_ShadowMoonHideout", 
		"Achievement_Dungeon_UpperBlackrockSpire", 
		

	}
	GHM_StockIcons["Misc Achievement"] = {
		"Achievement_General",
		"Achievement_Halloween_Bat_01",
		"Achievement_Halloween_Candy_01",
		"Achievement_Halloween_Cat_01",
		"Achievement_Halloween_Ghost_01",
		"Achievement_Halloween_RottenEgg_01",
		"Achievement_Halloween_Smiley_01",
		"Achievement_Halloween_Spider_01",
		"Achievement_Halloween_Witch_01",
		"Achievement_Halloween_Worms_01",
		"Achievement_Leader_ Thrall",
		"Achievement_Leader_Cairne Bloodhoof",
		"Achievement_Leader_King_Magni_Bronzebeard",
		"Achievement_Leader_King_Varian_Wrynn",
		"Achievement_Leader_Lorthemar_Theron ",
		"Achievement_Leader_Prophet_Velen",
		"Achievement_Leader_Sylvanas",
		"Achievement_Leader_Tyrande_Whisperwind",
		"Achievement_Level_10",
		"Achievement_Level_20",
		"Achievement_Level_30",
		"Achievement_Level_40",
		"Achievement_Level_50",
		"Achievement_Level_60",
		"Achievement_Level_70",
		"Achievement_Level_80",
		"Achievement_Level_90", 
		"Achievement_Profession_ChefHat",
		"Achievement_OgrimsHammer", -- [176]
		"Achievement_plagueworks", -- [177]
		"Achievement_Reputation_ArgentChampion", -- [183]
		"Achievement_Reputation_ArgentCrusader", -- [184]
		"Achievement_Reputation_AshtongueDeathsworn", -- [185]
		"Achievement_Reputation_GuardiansofCenarius", -- [186]
		"Achievement_Reputation_KirinTor", -- [187]
		"Achievement_Reputation_KnightsoftheEbonBlade", -- [188]
		"Achievement_Reputation_MurlocOracle", -- [189]
		
		"Achievement_Reputation_Ogre", -- [190]
		"Achievement_Reputation_timbermaw", -- [191]
		"Achievement_Reputation_Tuskarr", -- [192]
		"Achievement_Reputation_Wolvar", -- [193]
		"Achievement_Reputation_WyrmrestTemple", -- [194]
		"Achievement_Reputation_Kirintor_Offensive", 
		"Achievement_Faction_ShadoPan_Assault", 
		"Achievement_Faction_SunreaverOnslaught", 
		"Achievement_KirinTor_Offensive", 
		"ACHIEVEMENT_WIN_WINTERGRASP", -- [195]
		"Achievement_WorldEvent_Brewmaster", -- [196]
		"Achievement_WorldEvent_ChildrensWeek", -- [197]
		"Achievement_WorldEvent_LittleHelper", -- [198]
		"Achievement_WorldEvent_Lunar", -- [199]
		"Achievement_WorldEvent_Merrymaker", -- [200]
		"Achievement_WorldEvent_Mistletoe", -- [201]
		"Achievement_WorldEvent_Reindeer", -- [202]
		"Achievement_WorldEvent_Thanksgiving", -- [203]
		"Achievement_WorldEvent_Valentine", -- [204]
		"Achievement_WorldEvent_XmasOgre", -- [205]
		"INV_EssenceOfWintergrasp", -- [323]
		"achievement_general_classact",
		"achievement_general_dungeondiplomat",
		"achievement_general_raidrepresentation",
		"Achievement_Character_Pandaren_Female",
		"Achievement_Cooking_MasteroftheGrill", 
		"Achievement_Cooking_MasteroftheOven", 
		"Achievement_Cooking_MasterofthePot", 
		"Achievement_Cooking_MasteroftheSteamer", 
		"Achievement_Cooking_MasteroftheStill", 
		"Achievement_Cooking_MasteroftheWok", 
		"Achievement_Cooking_PandarianMasterChef",
		"Achievement_Faction_Anglers", 
		"Achievement_Faction_BrewMaster", 
		"Achievement_Faction_Celestials", 
		"Achievement_Faction_Craftsman", 
		"Achievement_Faction_Elders", 
		"Achievement_Faction_GoldenLotus", 
		"Achievement_Faction_Klaxxi", 
		"Achievement_Faction_LoreWalkers", 
		"Achievement_Faction_SerpentRiders", 
		"Achievement_Faction_ShadoPan", 
		"Achievement_Faction_Tillers",  
		"Achievement_GreatWall",
		"Achievement_Shadowpan_Hideout", 
		"Achievement_Shadowpan_Hideout_1", 
		"Achievement_Shadowpan_Hideout_2", 
		"Achievement_Shadowpan_Hideout_3", 
		"Achievement_Zone_DreadWastes", 
		"Achievement_Zone_DreadWastes_Loremaster", 
		"Achievement_Zone_JadeForest", 
		"Achievement_Zone_JadeForest_Loremaster", 
		"Achievement_Zone_KrasarangWilds", 
		"Achievement_Zone_KrasarangWilds_Loremaster", 
		"Achievement_Zone_KunLaiSummit", 
		"Achievement_Zone_KunLaiSummit_Loremaster", 
		"Achievement_Zone_TownlongSteppes", 
		"Achievement_Zone_TownlongSteppes_Loremaster", 
		"Achievement_Zone_ValeofEternalBlossoms", 
		"Achievement_Zone_ValeofEternalBlossoms_Loremaster", 
		"Achievement_Zone_ValleyofFourWinds", 
		"Achievement_Zone_ValleyofFourWinds_Loremaster",

		 "INV_Pet_Achievement_CaptureAPetFromEachFamily_Battle", 
	 "INV_Pet_Achievement_CaptureAWildPet", 
	 "INV_Pet_Achievement_Catch10PetsInDifferentZones", 
	 "INV_Pet_Achievement_Catch30PetsInDifferentZones", 
	 "INV_Pet_Achievement_Catch60PetsInDifferentZones", 
	 "INV_Pet_Achievement_CatchPetFamily10", 
	 "INV_Pet_Achievement_CatchPetFamily25", 
	 "INV_Pet_Achievement_CatchRarePet", 
	 "INV_Pet_Achievement_CatchRarePet_10", 
	 "INV_Pet_Achievement_CatchRarePet_50", 
	 "INV_Pet_Achievement_CatchUncommonPet", 
	 "INV_Pet_Achievement_DefeatPetTamer", 
	 "INV_Pet_Achievement_DefeatPetTamer_All", 
	 "INV_Pet_Achievement_DefeatWildPetTamers_EasternKingdom", 
	 "INV_Pet_Achievement_DefeatWildPetTamers_Kalimdor", 
	 "INV_Pet_Achievement_DefeatWildPetTamers_Northrend", 
	 "INV_Pet_Achievement_DefeatWildPetTamers_Outland", 
	 "INV_Pet_Achievement_DefeatWildPetTamers_Pandaria", 
	 "INV_Pet_Achievement_Earn100Achieve", 
	 "INV_Pet_Achievement_Earn200Achieve", 
	 "INV_Pet_Achievement_Earn300Achieve", 
	 "INV_Pet_Achievement_Earn335Achieve", 
	 "INV_Pet_Achievement_Extra01", 
	 "INV_Pet_Achievement_Extra02", 
	 "INV_Pet_Achievement_Extra03", 
	 "INV_Pet_Achievement_Pandaria", 
	 "INV_Pet_Achievement_Raise15PetsToLevel10", 
	 "INV_Pet_Achievement_Raise15PetsToLevel25", 
	 "INV_Pet_Achievement_Raise30PetsToLevel10", 
	 "INV_Pet_Achievement_Raise30PetsToLevel25", 
	 "INV_Pet_Achievement_Raise75PetsToLevel10", 
	 "INV_Pet_Achievement_Raise75PetsToLevel25", 
	 "INV_Pet_Achievement_Win10", 
	 "INV_Pet_Achievement_Win1000", 
	 "INV_Pet_Achievement_Win1000PVP", 
	 "INV_Pet_Achievement_Win10PVP", 
	 "INV_Pet_Achievement_Win250", 
	 "INV_Pet_Achievement_Win250PVP", 
	 "INV_Pet_Achievement_Win50", 
	 "INV_Pet_Achievement_Win5000", 
	 "INV_Pet_Achievement_Win5000PVP", 
	 "INV_Pet_Achievement_Win50PVP", 
		"Achievement_GarrisonFollower_Epic", 
		"Achievement_GarrisonFollower_ItemLevel600", 
		"Achievement_GarrisonFollower_ItemLevel650", 
		"Achievement_GarrisonFollower_LevelUp", 
		"Achievement_GarrisonFollower_LevelUp10", 
		"Achievement_GarrisonFollower_LevelUp100", 
		"Achievement_GarrisonFollower_LevelUp20", 
		"Achievement_GarrisonFollower_Rare", 
		"Achievement_GarrisonFollower_Recruit10", 
		"Achievement_GarrisonFollower_Recruit15", 
		"Achievement_GarrisonFollower_Recruit20", 
		"Achievement_GarrisonFollower_Recruit25", 
		"Achievement_GarrisonFollower_Recruit40", 
		"Achievement_GarrisonFollower_Recruit5", 
		"Achievement_GarrisonQuests_0005", 
		"Achievement_GarrisonQuests_0010", 
		"Achievement_GarrisonQuests_0050", 
		"Achievement_GarrisonQuests_0100", 
		"Achievement_GarrisonQuests_0500", 
		"Achievement_GarrisonQuests_1000", 
		"Achievement_Garrison_Alliance_PVE", 
		"Achievement_Garrison_blueprint20", 
		"Achievement_Garrison_blueprint40", 
		"Achievement_Garrison_blueprint60", 
		"Achievement_Garrison_blueprint_large", 
		"Achievement_Garrison_blueprint_medium", 
		"Achievement_Garrison_blueprint_small", 
		"Achievement_Garrison_Horde_PVE", 
		"Achievement_Garrison_Invasion", 
		"Achievement_Garrison_Invasion_Border", 
		"Achievement_Garrison_Invasion_Bronze", 
		"Achievement_Garrison_Invasion_Fifty", 
		"Achievement_Garrison_Invasion_Gold", 
		"Achievement_Garrison_Invasion_Silver", 
		"Achievement_Garrison_Invasion_Ten", 
		"Achievement_Garrison_Monument_Alliance_Pets", 
		"Achievement_Garrison_Monument_Alliance_Profession", 
		"Achievement_Garrison_Monument_Alliance_PVP", 
		"Achievement_Garrison_Monument_Alliance_Raid", 
		"Achievement_Garrison_Monument_Horde_Pets", 
		"Achievement_Garrison_Monument_Horde_Profession", 
		"Achievement_Garrison_Monument_Horde_PVP", 
		"Achievement_Garrison_Monument_Horde_Raid", 
		"Achievement_Garrison_Tier01_Alliance", 
		"Achievement_Garrison_Tier01_Horde", 
		"Achievement_Garrison_Tier02_Alliance", 
		"Achievement_Garrison_Tier02_Horde", 
		"Achievement_Garrison_Tier03_Alliance", 
		"Achievement_Garrison_Tier03_Horde", 
		"Achievement_Level_100", 
		"Achievement_RareGarrisonQuests_050", 
		"Achievement_RareGarrisonQuests_300", 
		"Achievement_RareGarrisonQuests_X", 
		"Achievement_Reputation_GuardiansofCenarius", 
		"Achievement_Scenario_100", 
		"Achievement_Scenario_1000", 
		"Achievement_Scenario_2500", 
		"Achievement_Scenario_500", 

		
		}
	GHM_StockIcons["PvP"] = {
		"Achievement_PVP_A_01",
		"Achievement_PVP_A_02",
		"Achievement_PVP_A_03",
		"Achievement_PVP_A_04",
		"Achievement_PVP_A_05",
		"Achievement_PVP_A_06",
		"Achievement_PVP_A_07",
		"Achievement_PVP_A_08",
		"Achievement_PVP_A_09",
		"Achievement_PVP_A_10",
		"Achievement_PVP_A_11",
		"Achievement_PVP_A_12",
		"Achievement_PVP_A_13",
		"Achievement_PVP_A_14",
		"Achievement_PVP_A_15",
		"Achievement_PVP_A_16",
		"Achievement_PVP_A_A",
		"Achievement_PVP_A_H",
		"Achievement_PVP_G_01",
		"Achievement_PVP_G_02",
		"Achievement_PVP_G_03",
		"Achievement_PVP_G_04",
		"Achievement_PVP_G_05",
		"Achievement_PVP_G_06",
		"Achievement_PVP_G_07",
		"Achievement_PVP_G_08",
		"Achievement_PVP_G_09",
		"Achievement_PVP_G_10",
		"Achievement_PVP_G_11",
		"Achievement_PVP_G_12",
		"Achievement_PVP_G_13",
		"Achievement_PVP_G_14",
		"Achievement_PVP_G_15",
		"Achievement_PVP_G_A",
		"Achievement_PVP_G_H",
		"Achievement_PVP_H_01",
		"Achievement_PVP_H_02",
		"Achievement_PVP_H_03",
		"Achievement_PVP_H_04",
		"Achievement_PVP_H_05",
		"Achievement_PVP_H_06",
		"Achievement_PVP_H_07",
		"Achievement_PVP_H_08",
		"Achievement_PVP_H_09",
		"Achievement_PVP_H_10",
		"Achievement_PVP_H_11",
		"Achievement_PVP_H_12",
		"Achievement_PVP_H_13",
		"Achievement_PVP_H_14",
		"Achievement_PVP_H_15",
		"Achievement_PVP_H_16",
		"Achievement_PVP_H_A",
		"Achievement_PVP_H_H",
		"Achievement_PVP_O_01",
		"Achievement_PVP_O_02",
		"Achievement_PVP_O_03",
		"Achievement_PVP_O_04",
		"Achievement_PVP_O_05",
		"Achievement_PVP_O_06",
		"Achievement_PVP_O_07",
		"Achievement_PVP_O_08",
		"Achievement_PVP_O_09",
		"Achievement_PVP_O_10",
		"Achievement_PVP_O_11",
		"Achievement_PVP_O_12",
		"Achievement_PVP_O_13",
		"Achievement_PVP_O_14",
		"Achievement_PVP_O_15",
		"Achievement_PVP_O_A",
		"Achievement_PVP_O_H",
		"Achievement_PVP_P_01",
		"Achievement_PVP_P_02",
		"Achievement_PVP_P_03",
		"Achievement_PVP_P_04",
		"Achievement_PVP_P_05",
		"Achievement_PVP_P_06",
		"Achievement_PVP_P_07",
		"Achievement_PVP_P_08",
		"Achievement_PVP_P_09",
		"Achievement_PVP_P_10",
		"Achievement_PVP_P_11",
		"Achievement_PVP_P_12",
		"Achievement_PVP_P_13",
		"Achievement_PVP_P_14",
		"Achievement_PVP_P_15",
		"Achievement_PVP_P_A",
		"Achievement_PVP_P_H",

		"Achievement_BG_kill_carrier_opposing_flagroom", -- [44]
		"Achievement_BG_killX_flagcarriers_before_leave_base", -- [45]

		"achievement_battleground_battleforgilneas",
		"achievement_doublejeopardy",
		"achievement_doublejeopardyally",
		"achievement_doublejeopardyhorde",
		"achievement_cloudnine",
		"achievement_doublerainbow",
		"achievement_pvp_p_250k",
		"achievement_general_allianceslayer",
		"achievement_general_cityattacker",
		"achievement_general_cityattacker2",
		"achievement_general_classicbattles",
		"achievement_general_hordeslayer",
		"achievement_goblinhead",
		"achievement_goblinheaddead",
		"achievement_worganhead",
		"Achievement_Battleground_SilvershardMines", 
		"Achievement_Battleground_TempleOfKotmogu", 
		"Achievement_Battleground_TempleOfKotmogu_02", 
		"Achievement_Battleground_TolvirArena", 
		
	}
	GHM_StockIcons["Quest"] = {
		"Achievement_Quests_Completed_01",
		"Achievement_Quests_Completed_02",
		"Achievement_Quests_Completed_03",
		"Achievement_Quests_Completed_04",
		"Achievement_Quests_Completed_05",
		"Achievement_Quests_Completed_06",
		"Achievement_Quests_Completed_07",
		"Achievement_Quests_Completed_08",
		"Achievement_Quests_Completed_Daily_01",
		"Achievement_Quests_Completed_Daily_02",
		"Achievement_Quests_Completed_Daily_03",
		"Achievement_Quests_Completed_Daily_04",
		"Achievement_Quests_Completed_Daily_05",
		"Achievement_Quests_Completed_Daily_06",
		"Achievement_Quests_Completed_Daily_07",
		"Achievement_Quests_Completed_Daily_08",
		"Achievement_Quests_Completed_Daily_x5",
		"Achievement_Reputation_01",
		"Achievement_Reputation_02",
		"Achievement_Reputation_03",
		"Achievement_Reputation_04",
		"Achievement_Reputation_05",
		"Achievement_Reputation_06",
		"Achievement_Reputation_07",
		"Achievement_Reputation_08",


		"achievement_general_25kdailyquests",
		"achievement_general_25kquests",
		"achievement_general_50kdailyquests",
		"achievement_general_50kquests",
		"achievement_general_100kdailyquests",
		"achievement_general_100kquests",
		"Achievement_General_150kDAILYquests", 
	}
	GHM_StockIcons["Guild"] = {
		"achievement_guildperk_everyones a hero", --Icon Was Missing.
		"achievement_guildperk_ladyluck",
		"achievement_guildperk_ladyluck_rank2",
		"achievement_guildperk_bartering",
		"achievement_guildperk_bountifulbags",
		"achievement_guildperk_cashflow",
		"achievement_guildperk_cashflow_rank2",
		"achievement_guildperk_chug a lug", --Icon Was Missing.
		"achievement_guildperk_chug a lug_rank2", --Icon Was Missing.
		"achievement_guildperk_everyones a hero_rank2", --Icon Was Missing.
		"achievement_guildperk_fasttrack",
		"achievement_guildperk_happyhour",
		"achievement_guildperk_gmail",
		"achievement_guildperk_hastyhearth",
		"achievement_guildperk_havegroup willtravel", --Icon Was Missing.
		"achievement_guildperk_honorablemention",
		"achievement_guildperk_honorablemention_rank2",
		"achievement_guildperk_massresurrection",
		"achievement_guildperk_mobilebanking",
		"achievement_guildperk_mountup",
		"achievement_guildperk_mrpopularity",
		"achievement_guildperk_mrpopularity_rank2",
		"achievement_guildperk_quick and dead",
		"achievement_guildperk_reinforce",
		"achievement_guildperk_reinforce_rank2",
		"achievement_guildperk_workingovertime",
		 "Achievement_Guild_DoctorIsIn", 
		"Achievement_Guild_TimeOff",
	}
	GHM_StockIcons["Alliance"] = {
		"Inv_Misc_Tournaments_banner_Draenei", -- [511]
		"Inv_Misc_Tournaments_banner_Dwarf", -- [512]
		"Inv_Misc_Tournaments_banner_Gnome", -- [513]
		"Inv_Misc_Tournaments_banner_Human", -- [514]
		"Inv_Misc_Tournaments_banner_Nightelf", -- [515]
		"Inv_Misc_Tournaments_Symbol_Draenei", -- [521]
		"Inv_Misc_Tournaments_Symbol_Dwarf", -- [522]
		"Inv_Misc_Tournaments_Symbol_Gnome", -- [523]
		"Inv_Misc_Tournaments_Symbol_Human", -- [524]
		"Inv_Misc_Tournaments_Symbol_NightElf", -- [525]
		"Inv_Misc_Tournaments_Tabard_Draenei", -- [531]
		"Inv_Misc_Tournaments_Tabard_Dwarf", -- [532]
		"Inv_Misc_Tournaments_Tabard_gnome", -- [533]
		"Inv_Misc_Tournaments_Tabard_Human", -- [534]
		"Inv_Misc_Tournaments_Tabard_NightElf", -- [535]
		"Achievement_KirinTor_Offensive", 
	}
	GHM_StockIcons["Horde"] = {
		"Inv_Misc_Tournaments_banner_Bloodelf", -- [510]

		"Inv_Misc_Tournaments_banner_Orc", -- [516]
		"Inv_Misc_Tournaments_banner_Scourge", -- [517]
		"Inv_Misc_Tournaments_banner_Tauren", -- [518]
		"Inv_Misc_Tournaments_banner_Troll", -- [519]
		"Inv_Misc_Tournaments_Symbol_BloodElf", -- [520]

		"Inv_Misc_Tournaments_Symbol_Orc", -- [526]
		"Inv_Misc_Tournaments_Symbol_Scourge", -- [527]
		"Inv_Misc_Tournaments_Symbol_Tauren", -- [528]
		"Inv_Misc_Tournaments_Symbol_Troll", -- [529]
		"Inv_Misc_Tournaments_Tabard_BloodElf", -- [530]
		"Inv_Misc_Tournaments_Tabard_Orc", -- [536]
		"Inv_Misc_Tournaments_Tabard_scourge", -- [537]
		"Inv_Misc_Tournaments_Tabard_Tauren", -- [538]
		"Inv_Misc_Tournaments_Tabard_Troll", -- [539]
		"Achievement_Faction_SunreaverOnslaught", 
	}
	
	--Making a custom icons category for the new icons unsure how to merge them in
	-- local path = "\\Interface\\AddOns\\GHM\\GHI_Icons"

	GHM_GHIIcons = {}

	GHM_GHIIcons["Spell"] = {
		"_ArcaneShot_Blue",
		"_ArcaneShot_Green",
		"_ArcaneShot_LightBlue",
		"_ArcaneShot_Orange",
		"_ArcaneShot_Purple",
		"_ArcaneShot_Red",
		"_ArcaneShot_Yellow",
		"_AntiMagie",
		"_BannishKT_Blue", 
		"_BannishKT_Orange", 
		"_BannishKT_Original", 
		"_BannishKT_Purple", 
		"_BannishKT_Red", 
		"_BannishKT_Yellow", 
		"_BearAttack_BrownFire", 
		"_BearAttack_GreyIce", 
		"_BearAttack_GreyPurple", 
		"_BearAttack_PurpleBlue", 
		"_BearAttack_PurpleGreen",
		"_BloodPact_Blue", --bloodpact recolor
		"_BloodPact_CyanPurple",
		"_BloodPact_PurpleGreen",
		"_BloodPact_RedGreen",
		"_BloodPact_YellowRed",
		"_BlueSeed", --seed of corruption recolor
		"_ChainLightingGreen",
		"_ChainLightingPurple",
		"_ChainLightingRed",
		"_ChainOfLightning_DeathKnight", 
		"_ChainOfLightning_Druid", 
		"_ChainOfLightning_Hunter", 
		"_ChainOfLightning_Mage", 
		"_ChainOfLightning_Monk", 
		"_ChainOfLightning_Paladin", 
		"_ChainOfLightning_Priest", 
		"_ChainOfLightning_Rogue", 
		"_ChainOfLightning_Shaman", 
		"_ChainOfLightning_Warlock", 
		"_ChainOfLightning_Warrior", 
		"_CurseOfSarkozy_Felfire",
		"_CurseOfSarkozy_Fire",
		"_CurseOfSarkozy_Frost",
		"_CurseOfSarkozy_GreenRed",
		"_CurseOfSarkozy_Light",
		"_CurseOfSarkozy_Shadow",
		"_CurseOfSarkozy_ShadowInvert",
		"_Curse_Blue", 
		"_Curse_Green", 
		"_Curse_Purple", 
		"_Curse_Red", 
		"_Curse_Yellow", 
		"_CORRUPTION",
		"_Create_Food", 
		"_Create_HealStone", 
		"_Create_ManaGem", 
		"_Create_SoulStone", 
		"_DeathCoilBlue",
		"_DeathCoilLightBlue",
		"_DeathCoilRed",
		"_DeathCoilV2_Acid", 
		"_DeathCoilV2_Blood", 
		"_DeathCoilV2_Blue", 
		"_DeathCoilV2_Cyan", 
		"_DeathCoilV2_LightBlue", 
		"_DeathCoilV2_Red", 
		"_DeathCoilV2_Shadow", 
		"_DeathCoilV2_YellowPurple",
		"_DemonHand_Blue",
		"_DemonHand_Purple",
		"_DemonHand_Red",
		"_DemonHand_DeathKnight", 
		"_DemonHand_Druid", 
		"_DemonHand_Hunter", 
		"_DemonHand_Mage", 
		"_DemonHand_Monk", 
		"_DemonHand_Paladin", 
		"_DemonHand_Priest", 
		"_DemonHand_Rogue", 
		"_DemonHand_Shaman", 
		"_DemonHand_Warlock", 
		"_DemonHand_Warrior", 
		 "_DarkHand_Blood", 
		"_DarkHand_Fel", 
		"_DarkHand_Fire", 
		"_DarkHand_Gold", 
		"_DarkHand_Ice", 
		"_DarkHand_Jade", 
		"_DarkHand_Sha", 
		"_DarkHand_Shadow", 
		"_DevouringCyan",
		"_DevouringShadow_Blue",
		"_DevouringShadow_Green",
		"_DevouringShadow_Orange",
		"_DevouringShadow_Pink",
		"_DevouringShadow_Purple",
		"_DevouringShadow_Red",
		"_DevouringShadow_Yellow",
		"_DrainPurple",
		"_DrainRed",
		"_DrainYellow",
		"_Fear",
		"_Frenzy_Blue",
		"_Frenzy_GreenOrange",
		"_Frenzy_Purple",
		"_Frenzy_PurpleGreen",
		"_Frenzy_RedOrange",
		"_GraineDeCorruption",
		"_Immolation",
		"_Immolation_Purple",
		"_InstableAffliction_Blue",
		"_InstableAffliction_Green",
		"_InstableAffliction_Purple",
		"_IntelligenceBleue",
		"_IntelligenceJaune",
		"_IntelligenceOrange",
		"_IntelligencePourpre",
		"_IntelligenceRouge",
		"_IntelligenceVerte",
		"_IntelligenceVertJaune",
		"_LDAKnowledge", 
		"_Engineering_BladesEdgeMtnsTP", 
		"_Engineering_NetherstormTP", 
		"_Engineering_NorthrendTP", 
		"_Engineering_PandariaTP", 
		"_Engineering_TanarisTP", 
		"_Engineering_WinterspringTP", 
		"_Mind_Control",
		"_TP_Acherus", 
		"_TP_BRD1", 
		"_TP_BRD2", 
		"_TP_DalaranCrater", 
		"_Warlock_Kilrogg", 		
		"_Purple01",
		"_Purple02",
		"_Purple03",
		"_Purple04",
		"_Purple05",
		"_Purple06",
		"_Purple07",
		"_Purple08",
		"_Purple09",
		"_Purple10",
		"_Purple11",
		"_RainOfFireBalls",
		"_Reanimation_Blue",
		"_Reanimation_Green",
		"_Reanimation_Purple",
		"_Reanimation_Red",
		"_Reanimation_RedGreen",
		"_Reanimation_White",
		"_Reanimation_Yellow",
		"_RedSeed",
		"_Reincarnation_Acid",
		"_Reincarnation_GoldenMeuh",
		"_Reincarnation_Ice",
		"_Reincarnation_PalaNoob",
		"_Reincarnation_PurpleGreen",
		"_ShadowSeed",
		"_SoulHarvest2_Blue",
		"_SoulHarvest2__Green",
		"_SoulHarvest2__Red",
		"_SoulHarvest2__Purple",
		"_SoulHarvest2__Orange",
		"_SpellCasting_Orange",
		"_SpellCasting_Green",
		"_SpellCasting_Blue",
		"_SpellCasting_Purple",
		"_SpellCasting_Red",
		"_SpellCasting_Shadow",
		"_SkullCurse_Blue",
		"_SkullCurse_Green",
		"_SkullCurse_Pink",
		"_SkullCurse_Purple",
		"_SkullCurse_Shadow",
		"_SkullCurse_Yellow",
		"_SkullCurse2_AcidIce",
		"_SkullCurse2_Arcanes",
		"_SkullCurse2_Blue",
		"_SkullCurse2_Green",
		"_SkullCurse2_Lechuck",
		"_SkullCurse2_Orange",
		"_SkullCurse2_Red",
		"_SkullCurse2_Shadow",
		"_SkullCurse2_Yellow",
		"_SoulsDevourer_Blue",
		"_SoulsDevourer_Green",
		"_SoulsDevourer_Purple",
		"_SoulsDevourer_Red",
		"_SoulsDevourer_Yellow",
		"_SoulFire_Blue", 
		"_SoulFire_Green", 
		"_SoulFire_Light", 
		"_SoulFire_Purple", 
		"_SoulFire_Red", 
		"_SoulFire_Shadow", 
		"_InnerFlame_Purple",
		"_InnerFlame_Red",
		"_InnerFlame_Orange",
		"_InnerFlame_Green",
		"_InnerFlame_Blue",
		"_IncinerateBlood",
		"_IncinerateFelFlame",
		"_IncinerateIce",
		"_IncinerateShadow",
		"_IncinerateSoul",
		"_Warlock_Plaie_Funeste",
		"_Warlock_PersonalTP",
		"_Warlock_Plaie_Agonie",
		"_Warlock_Malediction_Faiblesse",
		"_Warlock_FearScream",
		"_Warlock_Connexion",
		"_Warlock_Brise_Ame",
		"_Invisibility", 
		"_ManaBurn_Arcane", 
		"_ManaBurn_Fel", 
		"_ManaBurn_Fire", 
		"_ManaBurn_Frost", 
		"_ManaBurn_Holy", 
		"_ManaBurn_Nature", 
		"_ManaBurn_Shadow", 
		"_EnslaveSpell_Arcane", 
		"_EnslaveSpell_Astral", 
		"_EnslaveSpell_Blood", 
		"_EnslaveSpell_CorruptedBlood", 
		"_EnslaveSpell_Fire", 
		"_EnslaveSpell_Frost", 
		"_EnslaveSpell_Holy", 
		"_EnslaveSpell_Jade", 
		"_EnslaveSpell_Nature", 
		"_EnslaveSpell_Shadow",
		 "_Silence_1", 
		"_Silence_BloodElf", 
		"_Silence_NightElf_1", 
		"_Silence_NightElf_2", 
		"_Spellsteal_Blue", 
		"_Spellsteal_Green", 
		"_Spellsteal_Orange", 
		"_Spellsteal_Original", 
		"_Spellsteal_Purple", 
	}
	GHM_GHIIcons["Alliance"] = {
		"_BeastTaming_Draenei",
		"_BeastTaming_Human",
		"_BeastTaming_Nelf",
		"_BeastTaming_Worgen",
		"_WorgenFlayer_DeathKnight", 
		"_WorgenFlayer_Druid", 
		"_WorgenFlayer_Hunter", 
		"_WorgenFlayer_Mage", 
		"_WorgenFlayer_Priest", 
		"_WorgenFlayer_Rogue", 
		"_WorgenFlayer_Warlock", 
		"_WorgenFlayer_Warrior", 
		"_WorgenRunningWild_DeathKnight", 
		"_WorgenRunningWild_Druid", 
		"_WorgenRunningWild_Hunter", 
		"_WorgenRunningWild_Mage", 
		"_WorgenRunningWild_Priest", 
		"_WorgenRunningWild_Rogue", 
		"_WorgenRunningWild_Warlock", 
		"_WorgenRunningWild_Warrior", 
		"_Dwarf_01", 
		"_Dwarf_02", 
		"_Dwarf_03", 
		"_Dwarf_04", 
		"_Human_01", 
		"_Human_02", 
		"_Human_03", 
		"_Human_04", 
		"_Human_05", 
		"_Human_06", 
		"_Human_07", 
		"_MonkSpecialAttack_DodgeNightElf", 
		"_NightElf_01", 
		"_NightElf_02", 
		"_NightElf_03", 
		"_NightElf_04", 
		"_NightElf_05", 
		"_NightElf_06", 
		"_NightElf_07", 
		"_NightElf_08", 
		"_Pandaren_01",
		"BTNDwarfCar", 
		"BTNEnt", 
		"BTNDruidOfTheClaw", 
		"BTNFaerieDragon", 
	"BTNFootman", 
	"BTNGarithos",
	"BTNGryphonRider", 
	"BTNHeroArchmage", 
	"BTNHeroPaladin",
	"BTNHippogryph", 
	"BTNHippogryphRider", 
	"BTNIllidan", 
	"BTNJaina",
	"BTNMountainGiant",
	"BTNPriestessOfTheMoon", 
	"BTNProudmoore", 
	"BTNRifleman", 
	"BTNSiegeEngine",
	"BTNSteamTank", 
	"BTNTreant",
	"BTNWarden", 
	 "BTNMalfurion", 
 "BTNMilitia", 
	}
	
	GHM_GHIIcons["Ability"] = {
		"_Ability_Mount_Warlock",
		 "BTNInfernal",
		"_WorgenRunningWild_DeathKnight", 
		"_WorgenRunningWild_Druid", 
		"_WorgenRunningWild_Hunter", 
		"_WorgenRunningWild_Mage", 
		"_WorgenRunningWild_Priest", 
		"_WorgenRunningWild_Rogue", 
		"_WorgenRunningWild_Warlock", 
		"_WorgenRunningWild_Warrior", 
		"_AimedShot_Blue",
		"_AimedShot_Green",
		"_AimedShot_LightBlue",
		"_AimedShot_Orange",
		"_AimedShot_Purple",
		"_AimedShot_Red",
		"_AimedShot_Yellow",
		"_BloodBladesRain", --assuming its based on an ability
		"_BathSkull_Blue",
		"_BathSkull_Orange",
		"_BathSkull_Purple",
		"_BathSkull_Red",
		"_BeastTaming_Draenei",
		"_BeastTaming_Human",
		"_BeastTaming_Nelf",
		"_BeastTaming_Tauren",
		"_BeastTaming_Troll",
		"_BeastTaming_Undead",
		"_BeastTaming_Worgen",
		"_BloodPoison_Blue",
		"_BloodPoison_Green",
		"_BloodPoison_Red",
		"_BloodPoison_Shadow",
		"_BloodPoison_Yellow",
		"_ControleMental",
		"_HeroicStrike_Blue",
		"_HeroicStrike_Gold",
		"_HeroicStrike_Green",
		"_HeroicStrike_Pink",
		"_HeroicStrike_Purple",
		"_Invisibility",
		 "_DeathGrip_Blood", 
		"_DeathGrip_Fel", 
		"_DeathGrip_Fire", 
		"_DeathGrip_Gold", 
		"_DeathGrip_Ice", 
		"_DeathGrip_Jade", 
		"_DeathGrip_Sha", 
		"_DeathGrip_Violet", 
		"_LinkGreen",
		"_LinkHoly",
		"_LinkPurple",
		"_LinkRed",
		"_Misdirection_Blue",
		"_Misdirection_Green",
		"_Misdirection_LightBlue",
		"_Misdirection_Orange",
		"_Misdirection_Purple",
		"_Misdirection_Red",
		"_Misdirection_Yellow",
		"_MonkAbility_ChiWave_Pink", 
		"_MonkAbility_ChiWave_XuenWhite", 
		"_MonkAbility_ChiWave_Yellow", 
		"_MonkAbility_CracklingLightning_Pink", 
		"_MonkAbility_CracklingLightning_XuenWhite", 
		"_MonkAbility_CracklingLightning_Yellow", 
		"_MonkAbility_CraneKick_Pink", 
		"_MonkAbility_CraneKick_XuenWhite", 
		"_MonkAbility_CraneKick_Yellow", 
		"_MonkAbility_ExpelHarm_Pink", 
		"_MonkAbility_ExpelHarm_XuenWhite", 
		"_MonkAbility_ExpelHarm_Yellow", 
		"_MonkAbility_HealthSphere_Pink", 
		"_MonkAbility_HealthSphere_XuenWhite", 
		"_MonkAbility_HealthSphere_Yellow", 
		"_MonkAbility_RenewingMists_Pink", 
		"_MonkAbility_RenewingMists_XuenWhite", 
		"_MonkAbility_RenewingMists_Yellow", 
		"_MonkAbility_Roll_Pink", 
		"_MonkAbility_Roll_XuenWhite", 
		"_MonkAbility_Roll_Yellow", 
		"_MonkAbility_RoundHouseKick_Jade", 
		"_MonkAbility_RoundHouseKick_XuenWhite", 
		"_MonkAbility_RoundHouseKick_Yellow", 
		"_MonkAbility_RushingWind_Pink", 
		"_MonkAbility_RushingWind_XuenWhite", 
		"_MonkAbility_RushingWind_Yellow", 
		"_MonkAbility_SoothingMists_Pink", 
		"_MonkAbility_SoothingMists_XuenWhite", 
		"_MonkAbility_SoothingMists_Yellow", 
		"_MonkAbility_Tornado_Pink", 
		"_MonkAbility_Tornado_XuenWhite", 
		"_MonkAbility_Tornado_Yellow", 
		"_MonkAbility_Uplift_Pink", 
		"_MonkAbility_Uplift_XuenWhite", 
		"_MonkAbility_Uplift_Yellow", 
		"_Monk_PandariaTP", 
		"_Monk_Teleportation", 
		"_Monk_Teleportation_Cyan", 
		"_Monk_Teleportation_Pink", 
		"_Monk_Teleportation_XuenWhite", 
		"_Monk_Teleportation_Yellow", 
		"_MonkSpecialAttack_DodgeBloodElf", 
		"_MonkSpecialAttack_DodgeNightElf", 
		"_MonkSpecialAttack_DodgePandaren", 
		"_MonkSpecialAttack_FireBreath", 
		"_MonkSpecialAttack_Taunt", 
		"_PdS",
		"_PlagueCloud",
		"_PlagueCloudBlue",
		"_PlagueCloudCyan",
		"_PlagueCloudGrey",
		"_PlagueCloudOrange",
		"_PlagueCloudPurple",
		"_PlagueCloudYellow",
		"_PortalBlood",
		"_PortalDarkGreen",
		"_PortalDarkPurple",
		"_ProtoDrake_Blue",
		"_ProtoDrake_Bronze",
		"_ProtoDrake_Green",
		"_ProtoDrake_Purple",
		"_SceauBlue",
		"_SceauGreen",
		"_SceauLightBlue",
		"_SceauOrange",
		"_SceauPurple",
		"_SceauRed",
		"_SceauYellow",
		"_SceauYellowGreen",
		"_Stun",
		"_Sprint_Blue",
		"_Sprint_Green",
		"_Sprint_Purple",
		"_SpiritualSight", 
		"_VaporBlood",
		"_VaporGold",
		"_VaporGreen",
		"_VaporIce",
		"_VaporMagic",
		"_VaporWater",
		"_VuedelaToile",
		"_Vuedelesprit",
		"_Virus_Blue",
		"_Virus_Cyan",
		"_Virus_Orange",
		"_Virus_Purple",
		"_Virus_Red",
		"_Warlock_Portal",
		"_Whirlwind_Blue",
		"_Whirlwind_Green",
		"_Whirlwind_Orange",
		"_Whirlwind_Purple",
		"_Whirlwind_Red",
		"_Whirlwind_Yellow",
		"_WebSight",
		"_Diablo3_ArrowRain_DeathKnight", 
		"_Diablo3_ArrowRain_Druid", 
		"_Diablo3_ArrowRain_Hunter", 
		"_Diablo3_ArrowRain_Mage", 
		"_Diablo3_ArrowRain_Monk", 
		"_Diablo3_ArrowRain_Paladin", 
		"_Diablo3_ArrowRain_Priest", 
		"_Diablo3_ArrowRain_Rogue", 
		"_Diablo3_ArrowRain_Shaman", 
		"_Diablo3_ArrowRain_Warlock", 
		"_Diablo3_ArrowRain_Warrior", 
		"_Diablo3_Bomb_Deathknight", 
		"_Diablo3_Bomb_Druid", 
		"_Diablo3_Bomb_Hunter", 
		"_Diablo3_Bomb_Mage", 
		"_Diablo3_Bomb_Monk", 
		"_Diablo3_Bomb_Paladin", 
		"_Diablo3_Bomb_Priest", 
		"_Diablo3_Bomb_Rogue", 
		"_Diablo3_Bomb_Shaman", 
		"_Diablo3_Bomb_Warlock", 
		"_Diablo3_Bomb_Warrior", 
		"_Diablo3_Cleave_DeathKnight", 
		"_Diablo3_Cleave_Druid", 
		"_Diablo3_Cleave_Hunter", 
		"_Diablo3_Cleave_Mage", 
		"_Diablo3_Cleave_Warrior", 
		"_Diablo3_CursedMonster_Blue", 
		"_Diablo3_CursedMonster_Cyan", 
		"_Diablo3_CursedMonster_Green", 
		"_Diablo3_CursedMonster_LightBlue", 
		"_Diablo3_CursedMonster_Orange", 
		"_Diablo3_CursedMonster_Purple", 
		"_Diablo3_CursedMonster_Red", 
		"_Diablo3_CursedMonster_Yellow", 
		"_Diablo3_Execute_DeathKnight", 
		"_Diablo3_Execute_Druid", 
		"_Diablo3_Execute_Hunter", 
		"_Diablo3_Execute_Mage", 
		"_Diablo3_Execute_Paladin", 
		"_Diablo3_Execute_Priest", 
		"_Diablo3_Execute_Rogue", 
		"_Diablo3_Execute_Shaman", 
		"_Diablo3_Execute_Warlock", 
		"_Diablo3_Execute_Warrior", 
		"_Diablo3_Thunderclap_DeathKnight", 
		"_Diablo3_Thunderclap_Priest", 
		"_Diablo3_Thunderclap_Rogue", 
		"_Diablo3_Thunderclap_Shaman", 
		"_Diablo3_Thunderclap_Warlock", 
		"_Diablo3_Thunderclap_Warrior",
		"_LDASigil",	
		"_FanOfKnives_Acid", 
		"_FanOfKnives_Blue", 
		"_FanOfKnives_Fire", 
		"_FanOfKnives_Green", 
		"_FanOfKnives_Ice", 
		"_FanOfKnives_Jade", 
		"_FanOfKnives_LightBlue", 
		"_FanOfKnives_Orange", 
		"_FanOfKnives_Purple", 
		"_FanOfKnives_Red", 
		"_FanOfKnives_Yellow",
		"_Shadow_Acid", 
		"_Shadow_Blue", 
		"_Shadow_Fire", 
		"_Shadow_Green", 
		"_Shadow_Jade", 
		"_Shadow_LightBlue", 
		"_Shadow_Orange", 
		"_Shadow_Purple", 
		"_Shadow_Red", 
		"_Shadow_Shadow", 
		"_Shadow_Yellow", 
	}
	GHM_GHIIcons["Herbalism"] = {
	"_Branch_Blood", 
	"_Branch_Cold", 
	"_Branch_Corrupted", 
	"_Branch_Fel", 
	"_Branch_Ice", 
	"_Branch_Light", 
	"_Branch_Lotus", 
	"_Branch_Standard", 
	
	}
	GHM_GHIIcons["Mounts"] = {
		"_HeadlessHorsemansHorse",
		"_ProtoDrake_Blue", 
		"_ProtoDrake_Bronze", 
		"_ProtoDrake_Green", 
		"_ProtoDrake_Purple", 
	}
	GHM_GHIIcons["Ammo"] = {
		"_TirMultiple",
		"_Tir_de_Terre", --Icon was missing.
		"_ArcaneShot_Blue",
		"_ArcaneShot_Green",
		"_ArcaneShot_LightBlue",
		"_ArcaneShot_Orange",
		"_ArcaneShot_Purple",
		"_ArcaneShot_Red",
		"_ArcaneShot_Yellow",
	}
	GHM_GHIIcons["Axe "] = {}
	GHM_GHIIcons["Belt"] = {
		"_IngenieurBelt",
		"EngineeringBelt_Color_Blue", 
		"EngineeringBelt_Color_Green", 
		"EngineeringBelt_Color_Red", 
		"EngineeringBelt_Color_Yellow", 
		"EngineeringBelt_DeathKnight", 
		"EngineeringBelt_Druid", 
		"EngineeringBelt_Hunter", 
		"EngineeringBelt_Mage", 
		"EngineeringBelt_Monk", 
		"EngineeringBelt_Paladin", 
		"EngineeringBelt_Priest", 
		"EngineeringBelt_Rogue", 
		"EngineeringBelt_Shaman", 
		"EngineeringBelt_Warlock", 
		"EngineeringBelt_Warrior",
		"_BeltBuckleSilverRP_DeathKnight", 
		"_BeltBuckleSilverRP_Druid", 
		"_BeltBuckleSilverRP_Hunter", 
		"_BeltBuckleSilverRP_Mage", 
		"_BeltBuckleSilverRP_Monk", 
		"_BeltBuckleSilverRP_Paladin", 
		"_BeltBuckleSilverRP_Priest", 
		"_BeltBuckleSilverRP_Rogue", 
		"_BeltBuckleSilverRP_Shaman", 
		"_BeltBuckleSilverRP_Warlock", 
		"_BeltBuckleSilverRP_Warrior", 		
	}
	GHM_GHIIcons["Boots"] = {
		"_IngenieurBoots",
	}
	GHM_GHIIcons["Container"] = {
		"_HoradrimBox",
		"GHI_Bag_1",
		"GHI_Bag_2",
		"GHI_Bag_3",
		"GHI_Bag_4",
		"GHI_Bag_5",
		"GHI_Bag_6",
		"GHI_Bag_7",
		"GHI_Bag_8",
		"_Bag1_Acid", 
		"_Bag1_Black", 
		"_Bag1_Blue", 
		"_Bag1_Green", 
		"_Bag1_Jade", 
		"_Bag1_Lightblue", 
		"_Bag1_Magenta", 
		"_Bag1_Orange", 
		"_Bag1_Pink", 
		"_Bag1_Purple", 
		"_Bag1_Red", 
		"_Bag1_SilverRed", 
		"_Bag1_Standard", 
		"_Bag1_Violet", 
		"_Bag1_White", 
		"_Bag1_Yellow", 
		"_Bag2_Acid", 
		"_Bag2_Black",
		"_Bag2_Blue",
		"_Bag2_Green",
		"_Bag2_Jade",
		"_Bag2_Lightblue",
		"_Bag2_Magenta",
		"_Bag2_Orange",
		"_Bag2_Pink", 
		"_Bag2_Purple",
		"_Bag2_Red", 
		"_Bag2_SilverRed", 
		"_Bag2_Standard", 
		"_Bag2_Violet", 
		"_Bag2_White", 
		"_Bag2_Yellow", 
		"_Casket_Acid", 
		"_Casket_Black", 
		"_Casket_Blue", 
		"_Casket_Brown", 
		"_Casket_Green", 
		"_Casket_Jade", 
		"_Casket_Lightblue", 
		"_Casket_Magenta", 
		"_Casket_Orange", 
		"_Casket_Pink", 
		"_Casket_Purple", 
		"_Casket_Red", 
		"_Casket_SilverRed", 
		"_Casket_Violet", 
		"_Casket_White", 
		"_Casket_Yellow", 
		"_Chest_Blue", 
		"_Chest_Green", 
		"_Chest_Jade", 
		"_Chest_Lightblue", 
		"_Chest_Orange", 
		"_Chest_Purple", 
		"_Chest_Red", 
		"_Chest_SilverRed", 
		"_Chest_Standard", 
		"_Chest_Violet", 
		"_Chest_Yellow", 
		"_Merchandises_ColorBlack", 
		"_Merchandises_ColorBlue", 
		"_Merchandises_ColorGreen", 
		"_Merchandises_ColorMixGreenYellow", 
		"_Merchandises_ColorMixOrangePurple", 
		"_Merchandises_ColorMixPinkPurple", 
		"_Merchandises_ColorMixPurpleBlue", 
		"_Merchandises_ColorMixRedGreen", 
		"_Merchandises_ColorMixRedOrange", 
		"_Merchandises_ColorMixYellowBlue", 
		"_Merchandises_ColorRed", 
		"_Merchandises_ColorYellow", 
		"_Merchandises_DeathKnight", 
		"_Merchandises_Druid", 
		"_Merchandises_Hunter", 
		"_Merchandises_Mage", 
		"_Merchandises_Monk", 
		"_Merchandises_Paladin", 
		"_Merchandises_Priest", 
		"_Merchandises_Rogue", 
		"_Merchandises_Shaman", 
		"_Merchandises_Warlock", 
		"_Merchandises_Warrior",
		"_LDAMerchandise",
		"_LittleSatchel_Acid", 
		"_LittleSatchel_Arcane", 
		"_LittleSatchel_Blood", 
		"_LittleSatchel_Blue", 
		"_LittleSatchel_Fire", 
		"_LittleSatchel_Ice", 
		"_LittleSatchel_Jade", 
		"_LittleSatchel_Light", 
		"_LittleSatchel_Red", 
		"_LittleSatchel_Shadow", 
		"_LittleSatchel_Yellow",
		"_WetBag2_Blood1", 
		"_WetBag2_Blood2", 
		"_WetBag2_Blood3", 
		"_WetBag2_NighElfBlood", 
		"_WetBag2_Slime", 
		"_WetBag_Blood1", 
		"_WetBag_Blood2", 
		"_WetBag_NighElfBlood1", 
		"_WetBag_NighElfBlood2", 
		"_WetBag_Slime", 
		"_WetBag_Water",   		
	}
	GHM_GHIIcons["Bracer"] = {
		"_IngenieurBracelets",
	}
	GHM_GHIIcons["Chestpiece"] = {}
	GHM_GHIIcons["Drinkable"] = {
	 "_LDABeer",
	}
	GHM_GHIIcons["Food"] = {
	 "_The_Cake_Is_A_Lie", 
	}
	GHM_GHIIcons["Guantlet"] = {
		"_IngenieurGauntlets",
	}
	GHM_GHIIcons["Hammer"] = {}
	GHM_GHIIcons["Helmet"] = {}
	GHM_GHIIcons["Horde"] = {
		"_BloodElf_DeathKnight", --unsure on this
		"_Character_Bloodelf_Female",
		"_Character_Undead_Female",
		"_DumbOrc", --poor orc
		"_Forsaken_Priest",
		"_Forsaken_Rogue",
		"_ForsakenFemaleFace",
		"_BeastTaming_Tauren",
		"_BeastTaming_Troll",
		"_BeastTaming_Undead",
		"_Orc_01", 
		"_Orc_02", 
		"_Orc_03", 
		"_Orc_04", 
		"_Orc_05", 
		"_Orc_06", 
		"_Orc_07", 
		"_Orc_08", 
		"_Orc_09", 
		"_Orc_10", 
		"_Orc_11", 
		"_Orc_12", 
		"_Orc_13", 
		"_Pandaren_01", 
		"_MonkSpecialAttack_DodgeBloodElf", 
    	"_Tauren_01", 
		"_Tauren_02", 
		"_Troll_01", 
		"_Troll_02", 
		"_Troll_03", 
		"_Troll_04", 
		"_Troll_05", 
		"_Troll_06", 
		"_Undead_01", 
		"_Undead_02", 
		"_Undead_03", 
		"_HighElf_01", 
		"_HighElf_02", 
		"_HighElf_03", 
		"_HighElf_04", 
		"_HighElf_05", 
		"_HighElf_06", 
		"_HighElf_07", 
		"_HighElf_08", 
		"BTNAbomination", 
		"BTNDarkRanger",
		"BTNDragonHawk", 
		"BTNGrunt", 
		"BTNHeadhunter", 
		"BTNHeroFarseer", 
		"BTNHeroTaurenChieftain", 
		"BTNOrcWarlock", 
		"BTNPeon", 
		"BTNShadowHunter", 
		"BTNSpellBreaker", 
		"BTNSpiritWalker", 
		"BTNTauren", 
		"BTNTrollBatRider", 
		"BTNWitchDoctor", 
		"BTNWolf", 
	}
	GHM_GHIIcons["Jewelry"] = {
		"_PendantGreenYellow",
		"_RingBlue",
		"_RingCyan",
		"_RingGreen",
		"_RingGrey",
		"_RingOrange",
		"_RingPurple",
		"_RingRed",
		"_RingYellow",
		"_GoldenRing_DeathKnight", 
		"_GoldenRing_Druid", 
		"_GoldenRing_Hunter", 
		"_GoldenRing_Mage", 
		"_GoldenRing_Monk", 
		"_GoldenRing_Paladin", 
		"_GoldenRing_Priest", 
		"_GoldenRing_Rogue", 
		"_GoldenRing_Shaman", 
		"_GoldenRing_Warlock", 
		"_GoldenRing_Warrior",
		"_SilverRing_DeathKnight", 
		"_SilverRing_Druid", 
		"_SilverRing_Hunter", 
		"_SilverRing_Mage", 
		"_SilverRing_Monk", 
		"_SilverRing_Paladin", 
		"_SilverRing_Priest", 
		"_SilverRing_Rogue", 
		"_SilverRing_Shaman", 
		"_SilverRing_Warlock", 
		"_SilverRing_Warrior",
		"_HearthStone_Necklace_DeathKnight", 
		"_HearthStone_Necklace_Druid", 
		"_HearthStone_Necklace_Hunter", 
		"_HearthStone_Necklace_Mage", 
		"_HearthStone_Necklace_Monk", 
		"_HearthStone_Necklace_Paladin", 
		"_HearthStone_Necklace_Priest", 
		"_HearthStone_Necklace_Rogue", 
		"_HearthStone_Necklace_Shaman", 
		"_HearthStone_Necklace_Warlock", 
		"_HearthStone_Necklace_Warrior",  		
	}
	GHM_GHIIcons["Knife"] = {
		"_SacrificialDagger_Blood", 
		"_SacrificialDagger_Fire", 
		"_SacrificialDagger_Ice", 
		"_SacrificialDagger_Necromantic", 
		"_SacrificialDagger_Shadow", 
		"_SacrificialDagger_Unholy", 
	}
	GHM_GHIIcons["Mace"] = {}
	GHM_GHIIcons["Trophy"] = {
		"_Eye_Of_Kilrogg",
		"_KilroggEye",
		"_StrongBone_Blue",
		"_StrongBone_Gold",
		"_StrongBone_Ice",
		"_StrongBone_Red",
		"_StrongBone_RedPurple",
		"_EvilSkull_Green", 
		"_EvilSkull_Lightblue", 
		"_EvilSkull_Orange", 
		"_EvilSkull_Purple", 
		"_EvilSkull_Red", 
	}
	GHM_GHIIcons["Pets"] = {
	
		"_MagicEye_Arcane", 
		"_MagicEye_Arcane_Small", 
		"_MagicEye_DarkmoonFaire", 
		"_MagicEye_DarkmoonFaire_Small", 
		"_MagicEye_Kilrogg", 
		"_MagicEye_Kilrogg_Small",
	
	}
	GHM_GHIIcons["Cape"] = {
		"_IngenieurCloak",
		 "_AuraCloak_Arcanes", 
		"_AuraCloak_Felfire", 
		"_AuraCloak_Fire", 
		"_AuraCloak_Ice", 
		"_AuraCloak_Lightning", 
		"_AuraCloak_Shadow", 
		"_CasterCloak_Arcanes", 
		"_CasterCloak_Fel", 
		"_CasterCloak_Fire", 
		"_CasterCloak_Ice", 
		"_CasterCloak_Original", 
		"_CasterCloak_Shadow", 
	}
	GHM_GHIIcons["Valuable"] = {
		"_BrickHearthStoneBlue",
		"_BrickHearthStoneBrown",
		"_BrickHearthStoneGreen",
		"_BrickHearthStoneLightBlue",
		"_BrickHearthStoneOrange",
		"_BrickHearthStonePink",
		"_BrickHearthStonePurple",
		"_BrickHearthStoneWhite",
		"_BrickHearthStoneYellow",
		"_DarkHearthStoneBlue",
		"_DarkHearthStoneBrown",
		"_DarkHearthStoneGreen",
		"_DarkHearthStoneLightBlue",
		"_DarkHearthStoneOrange",
		"_DarkHearthStonePink",
		"_DarkHearthStoneRed",
		"_DarkHearthStoneWhite",
		"_DarkHearthStoneYellow",
		 "_HearthStoneDark_DeathKnight", 
		"_HearthStoneDark_Druid", 
		"_HearthStoneDark_Hunter", 
		"_HearthStoneDark_Mage", 
		"_HearthStoneDark_Monk", 
		"_HearthStoneDark_Paladin", 
		"_HearthStoneDark_Priest", 
		"_HearthStoneDark_Rogue", 
		"_HearthStoneDark_Shaman", 
		"_HearthStoneDark_Warlock", 
		"_HearthStoneDark_Warrior", 
		"_HearthStone_DeathKnight",
		"_HearthStone_Necklace_DeathKnight", 
		"_HearthStone_Necklace_Druid", 
		"_HearthStone_Necklace_Hunter", 
		"_HearthStone_Necklace_Mage", 
		"_HearthStone_Necklace_Monk", 
		"_HearthStone_Necklace_Paladin", 
		"_HearthStone_Necklace_Priest", 
		"_HearthStone_Necklace_Rogue", 
		"_HearthStone_Necklace_Shaman", 
		"_HearthStone_Necklace_Warlock", 
		"_HearthStone_Necklace_Warrior", 		
		"_DeathRuneBlue",
		"_DeathRuneLightBlue",
		"_DeathRuneGreen",
		"_DeathRuneOrange",
		"_DeathRunePurple",
		"_DeathRuneRed",
		"_HearthStoneBlue",
		"_HearthStoneGreen",
		"_HearthStoneOrange",
		"_HearthStonePurple",
		--"_HearthStoneRed", --Icon Missing
		"_HearthStoneYellow",
		 "_HearthStone_Druid", 
		"_HearthStone_Hunter", 
		"_HearthStone_Mage", 
		"_HearthStone_Monk", 
		"_HearthStone_Paladin", 
		"_HearthStone_Priest", 
		"_HearthStone_Rogue", 
		"_HearthStone_Shaman", 
		"_HearthStone_Warlock", 
		"_HearthStone_Warrior", 
		"_Runedenovablanche",
		"_Runedenovableue",
		"_Runedenovaecume",
		"_Runedenovajaune",
		"_Runedenovanoire",
		"_Runedenovanonchargee",
		"_Runedenovaorange",
		"_Runedenovapourpre",
		"_Runedenovarose",
		"_Runedenovarouge",
		"_Runedenovaverte",
		"_Runedenovavertsombre",
		"_RuneMagmaBleue",
		"_RuneMagmaCyan",
		"_RuneMagmaJaune",
		"_RuneMagmaPourpre",
		"_RuneMagmaRouge",
		"_RuneMagmaVerte",
		"_RuneMagmaVertJaune",
		"_RuneOrcBlue",
		"_RuneOrcGreen",
		"_RuneOrcLightBlue",
		"_RuneOrcOrange",
		"_RuneOrcPurple",
		"_RuneOrcRed",
		"_RuneOrcYellow",
		"_RuneOrcYellowGreen",
		"_RuneSauvageBleuClair",
		"_RuneSauvageBleue",
		"_RuneSauvageJaune",
		"_RuneSauvageOrange",
		"_RuneSauvagePourpre",
		"_RuneSauvageRouge",
		"_RuneSauvageVerte",
		--These are masks below but they d o look like her face in a way
		"_LDAMask", 
		"_Sylvanas",
		"_SylvanasGreen",
		"_SylvanasLightBlue",
		"_SylvanasOrange",
		"_SylvanasPurple",
		"_SylvanasRed",
		"_SylvanasYellow",
		"_Sylvanas_DeathKnight", 
		"_Sylvanas_Druid", 
		"_Sylvanas_Hunter", 
		"_Sylvanas_Mage", 
		"_Sylvanas_Monk", 
		"_Sylvanas_Paladin", 
		"_Sylvanas_Priest", 
		"_Sylvanas_Rogue", 
		"_Sylvanas_Warlock", 
		"_Sylvanas_Warrior", 

		---
		"_VenomOrb_Blue",
		"_VenomOrb_Brown",
		"_VenomOrb_Green",
		"_VenomOrb_LightBlue",
		"_VenomOrb_Orange",
		"_VenomOrb_Pink",
		"_VenomOrb_Purple",
		"_VenomOrb_Red",
		"_VenomOrb_White",
		"_VenomOrb_Yellow",
		"_ShamanTotam_Acid", 
		"_ShamanTotam_Blood", 
		"_ShamanTotam_Fire", 
		"_ShamanTotam_Ice", 
		"_ShamanTotam_Shadow", 
		"_ShamanTotam_Water", 
		"_ShamanTotam_Wind", 
	}
	GHM_GHIIcons["Ranged"] = {
		"_ArcaneGun_Blue",
		"_ArcaneGun_Green",
		"_ArcaneGun_LightBlue",
		"_ArcaneGun_Orange",
		"_ArcaneGun_Purple",
		"_ArcaneGun_Red",
		"_ArcaneGun_Yellow",
		"_BigArcaneGun_Blue",
		"_BigArcaneGun_Green",
		"_BigArcaneGun_LightBlue",
		"_BigArcaneGun_Orange",
		"_BigArcaneGun_Purple",
		"_BigArcaneGun_Red",
		"_BigArcaneGun_Yellow",
		"_BigGun_Blue",
		"_BigGun_Green",
		"_BigGun_LightBlue",
		"_BigGun_Orange",
		"_BigGun_Purple",
		"_BigGun_Red",
		"_BigGun_Yellow",
		"_SmallGun_Blue",
		"_SmallGun_Green",
		"_SmallGun_LightBlue",
		"_SmallGun_Orange",
		"_SmallGun_Purple",
		"_SmallGun_Red",
		"_SmallGun_Yellow",
	}
	GHM_GHIIcons["Pants"] = {}
	GHM_GHIIcons["Potion"] = {
		"_PotionRed",
		"_PotionFlammeColor_Blue", 
		"_PotionFlammeColor_Cyan", 
		"_PotionFlammeColor_GreenYellow", 
		"_PotionFlammeColor_LightBlue", 
		"_PotionFlammeColor_OrangeRed", 
		"_PotionFlammeColor_Pink", 
		"_PotionFlammeColor_Purple", 
		"_PotionFlammeColor_RedOrange", 
		"_PotionFlammeColor_White", 
		"_PotionFlammeColor_Yellow", 
		"_Potion_01", 
		"_Potion_02", 
		"_Potion_03", 
		"_Potion_04", 
		"_Potion_05", 
		"_Potion_06", 
		"_Potion_07", 
		"_Potion_08", 
		"_Potion_09", 
		"_Potion_10", 
		"_Potion_11", 
		"_Potion_12", 
		"_Parfume_Firebloom", 
		"_Parfume_GoldenLotus", 
		"_Parfume_GreenTeaLeaf", 
		"_Parfume_Jasmine", 
		"_Parfume_Kingsblood", 
		"_Parfume_Kuzco", 
		"_Parfume_ManaThistle", 
		"_Parfume_NightmareVine", 
		"_Parfume_Peacebloom", 
		"_Parfume_RainPoppy", 
		"_Parfume_Rose", 
		"_Parfume_SnowLily", 
		"_Parfume_TalandrasRose", 
		"_Parfume_Terocone", 
		"_Parfume_TigerLily", 
	}
	GHM_GHIIcons["Shield"] = {
		"_ShieldTroll_CyanGreen",
		"_ShieldTroll_PurpleRed",
		"_ShieldTroll_RedOrange",
		"_ShieldTroll_YellowBlue",
	}
	GHM_GHIIcons["Shirt"] = {}
	GHM_GHIIcons["Shoulder"] = {}
	GHM_GHIIcons["Spear"] = {}
	GHM_GHIIcons["Staff"] = {
		"_StaffOfNegation_Black", 
		"_StaffOfNegation_Fire", 
		"_StaffOfNegation_Green", 
		"_StaffOfNegation_Original", 
		"_StaffOfNegation_Purple", 
		"_StaffOfNegation_Red", 
		"_StaffOfNegation_Yellow", 
	}
	GHM_GHIIcons["Sword"] = {
		"_Execution_Acid",
		"_Execution_Blue",
		"_Execution_Green",
		"_Execution_LightBlue",
		"_Execution_Orange",
		"_Execution_Purple",
		"_Execution_White",
		"_Execution_Yellow",
	}
	GHM_GHIIcons["Wand"] = {}
	GHM_GHIIcons["Halberd"] = {}
	GHM_GHIIcons["Fist"] = {	
		"_MaievBlade_Acid", 
		"_MaievBlade_Arcane", 
		"_MaievBlade_Blood", 
		"_MaievBlade_Fire", 
		"_MaievBlade_Ice", 
		"_MaievBlade_Light", 
		"_MaievBlade_Shadow", 
		"_MaievBlade_Water", 
	}
	GHM_GHIIcons["Trade"] = {}
	GHM_GHIIcons["Readable"] = {
		"_JudgeHype",
		"_GeneralMap",
		"_SexyMapAddOnIcon",
		"_Book1_Acid", 
		"_Book1_Blue", 
		"_Book1_Brown", 
		"_Book1_Cyan", 
		"_Book1_Green", 
		"_Book1_LightBlue", 
		"_Book1_Love", 
		"_Book1_Orange", 
		"_Book1_Purple", 
		"_Book1_Red", 
		"_Book1_White", 
		"_Book1_Yellow", 
		"_Book2Motif_Alliance", 
		"_Book2Motif_ArgentCrusade", 
		"_Book2Motif_BloodElf1", 
		"_Book2Motif_BloodElf2", 
		"_Book2Motif_Dalaran", 
		"_Book2Motif_Druid", 
		"_Book2Motif_Exodar", 
		"_Book2Motif_Forsaken1", 
		"_Book2Motif_Forsaken2", 
		"_Book2Motif_Gilneas", 
		"_Book2Motif_GilneasOld", 
		"_Book2Motif_HighElf", 
		"_Book2Motif_Horde", 
		"_Book2Motif_Hurlevent", 
		"_Book2Motif_Illidan", 
		"_Book2Motif_IronForge", 
		"_Book2Motif_KaelThas", 
		"_Book2Motif_Lordaeron", 
		"_Book2Motif_LordaeronCorrupted", 
		"_Book2Motif_LordaeronLight", 
		"_Book2Motif_LordaeronScarlet", 
		"_Book2Motif_Moon", 
		"_Book2Motif_NightElf1", 
		"_Book2Motif_NightElf2", 
		"_Book2Motif_NightElf3", 
		"_Book2Motif_PaladinSamwise", 
		"_Book2Motif_Riddler", 
		"_Book2Motif_ScarletCrusade", 
		"_Book2Motif_ShadowCouncil", 
		"_Book2Motif_Silverhand", 
		"_Book2Motif_Stained_1", 
		"_Book2Motif_Stained_2", 
		"_Book2Motif_Stained_3", 
		"_Book2Motif_Stained_4", 
		"_Book2Motif_Stromgarde", 
		"_Book2Motif_Tyr", 
		"_Book2_Acid", 
		"_Book2_Blue", 
		"_Book2_Brown", 
		"_Book2_Cyan", 
		"_Book2_Green", 
		"_Book2_LightBlue", 
		"_Book2_Love", 
		"_Book2_Orange", 
		"_Book2_Purple", 
		"_Book2_Red", 
		"_Book2_White", 
		"_Book2_Yellow", 
		"_Book3_Acid", 
		"_Book3_Blue", 
		"_Book3_Brown", 
		"_Book3_Cyan", 
		"_Book3_Green", 
		"_Book3_LightBlue", 
		"_Book3_Love", 
		"_Book3_Orange", 
		"_Book3_Purple", 
		"_Book3_Red", 
		"_Book3_White", 
		"_Book3_Yellow", 
		"_Book4_Acid", 
		"_Book4_Blue", 
		"_Book4_Brown", 
		"_Book4_Cyan", 
		"_Book4_Green", 
		"_Book4_Love", 
		"_Book4_Orange", 
		"_Book4_Purple", 
		"_Book4_Red", 
		"_Book4_White", 
		"_Book4_Yellow", 
		"_Book5_Acid", 
		"_Book5_Blue", 
		"_Book5_Brown", 
		"_Book5_Cyan", 
		"_Book5_Green", 
		"_Book5_LightBlue", 
		"_Book5_Love", 
		"_Book5_Orange", 
		"_Book5_Purple", 
		"_Book5_Red", 
		"_Book5_White", 
		"_Book5_Yellow",
		 "_Book6_Acid", 
		"_Book6_Blue", 
		"_Book6_Brown", 
		"_Book6_Green", 
		"_Book6_Jade", 
		"_Book6_Lightblue", 
		"_Book6_Orange", 
		"_Book6_Pink", 
		"_Book6_Purple", 
		"_Book6_Red", 
		"_Book6_Violet", 
		"_Book6_Yellow", 

		"_Scroll1_Acid", 
		"_Scroll1_Blue", 
		"_Scroll1_Custom_Air", 
		"_Scroll1_Custom_Alliance", 
		"_Scroll1_Custom_BurningLegion", 
		"_Scroll1_Custom_Earth", 
		"_Scroll1_Custom_Fire", 
		"_Scroll1_Custom_Forsaken", 
		"_Scroll1_Custom_Horde", 
		"_Scroll1_Custom_Ironforge", 
		"_Scroll1_Custom_Water", 
		"_Scroll1_Cyan", 
		"_Scroll1_Green", 
		"_Scroll1_Ice", 
		"_Scroll1_Jade", 
		"_Scroll1_Purple", 
		"_Scroll1_Red", 
		"_Scroll1_StainedBlood", 
		"_Scroll1_StainedInk", 
		"_Scroll1_StainedSlime", 
		"_Scroll1_Violet", 
		"_Scroll1_Yellow", 
		"_ScrollOfSpeed_Corrupted", 
		"_ScrollOfSpeed_Fire", 
		"_ScrollOfSpeed_Jade", 
		"_ScrollOfSpeed_LightBlue", 
		"_ScrollOfSpeed_Purple", 
		"_ScrollOfSpeed_Red", 
		"_ScrollOfSpeed_Yellow", 		
		"_LDALetter", 
		"_LDALetterPostIt",
		"_LDABook", 
		"_LDABookMagic", 
		"_LDABookSealed", 
		"_LDABookShelf", 
		"_LDABookShelfMagic", 
		"_LDABookShelfOpened", 
		"_LDAScroll",  
		"_Note_01_Acid", 
		"_Note_01_Blue", 
		"_Note_01_Cyan", 
		"_Note_01_Green", 
		"_Note_01_Jade", 
		"_Note_01_Orange", 
		"_Note_01_Purple", 
		"_Note_01_Red", 
		"_Note_01_Stained_Blood", 
		"_Note_01_Stained_Ink", 
		"_Note_01_Stained_Jarate", 
		"_Note_01_Stained_Slime", 
		"_Note_01_Stained_Water", 
		"_Note_01_Yellow", 
		"_Letter_Acid", 
		"_Letter_ArgentCrusade", 
		"_Letter_BloodElf1", 
		"_Letter_BloodElf2", 
		"_Letter_Blue", 
		"_Letter_Brown", 
		"_Letter_Forsaken", 
		"_Letter_Green", 
		"_Letter_HighElf", 
		"_Letter_Ice", 
		"_Letter_KaelThas", 
		"_Letter_KirinTor", 
		"_Letter_Lordaeron", 
		"_Letter_LordaeronBlue", 
		"_Letter_LordaeronCorrupted", 
		"_Letter_LordaeronScarletCrusade", 
		"_Letter_Love", 
		"_Letter_Magenta", 
		"_Letter_Moon", 
		"_Letter_Orange", 
		"_Letter_Purple", 
		"_Letter_Red", 
		"_Letter_Scourge", 
		"_Letter_White", 
		"_Letter_Yellow", 
		"_Scroll2_Blue", 
		"_Scroll2_Fire", 
		"_Scroll2_Frostfire", 
		"_Scroll2_Green", 
		"_Scroll2_Holy", 
		"_Scroll2_Jade", 
		"_Scroll2_LightBlue", 
		"_Scroll2_Necro", 
		"_Scroll2_Orange", 
		"_Scroll2_Purple", 
		"_Scroll2_Red", 
		"_Scroll2_Shadow", 
		"_Scroll2_ShadowPriest", 
		"_Scroll3_BlueRed", 
		"_Scroll3_Frostfire", 
		"_Scroll3_LightYellowRed", 
		"_Scroll3_Necro", 
		"_Scroll3_Purple", 
		"_Scroll3_PurpleGreen", 
		"_Scroll3_RedBlue", 
		"_Scroll3_Shadow", 
		"_Scroll3_YellowGreen", 
	}
	GHM_GHIIcons["Keys"] = {
		"_LDAKey",
		"_SkeletalKey",
		"_KeyGhostIron", 
		"_KeyGoldAcid", 
		"_KeyGoldBlood", 
		"_KeyGoldFire", 
		"_KeyGoldShadow", 
		"_KeySilverIce", 	 
	}
	GHM_GHIIcons["Leatherworking"] = {}
	GHM_GHIIcons["Engineering"] = {
		"_GizmoHearthStoneBlue",
		"_GizmoHearthStoneBlue",
		"_GizmoHearthStoneBrown",
		"_GizmoHearthStoneGreen",
		"_GizmoHearthStoneLightBlue",
		"_GizmoHearthStoneOrange",
		"_GizmoHearthStonePink",
		"_GizmoHearthStonePurple",
		"_GizmoHearthStoneRed",
		"_GizmoHearthStoneWhite",
		"_GizmoHearthStoneYellow",
		"_Interaction_Blue",
		"_Interaction_Ecume",
		"_Interaction_Green",
		"_Interaction_GreenGoblin",
		"_Interaction_LightBlue",
		"_Interaction_Orange",
		"_Interaction_Purple",
		"_Interaction_Red",
		"_Interaction_Violet",
		"_Interaction_Yellow",
		"_Engineering_BladesEdgeMtnsTP", 
		"_Engineering_NetherstormTP", 
		"_Engineering_NorthrendTP", 
		"_Engineering_PandariaTP", 
		"_Engineering_TanarisTP", 
		"_Engineering_WinterspringTP",
		"_LDACogs", 
	}
	GHM_GHIIcons["Fishing"] = {}
	GHM_GHIIcons["Enchanting"] = {}
	GHM_GHIIcons["Tailoring"] = {}
	GHM_GHIIcons["First Aid"] = {}
	GHM_GHIIcons["Mining"] = {
		"_Saronite",
	}
	GHM_GHIIcons["Inscription"] = {
		"_Rune1",
		"_Rune2",
		"_Rune3",
		"_Rune4",
		"_Rune5",
		"_Rune6",
		"_Rune7",
		"_Rune8",
		"_Rune9",
		--"_Rune10", --Icon Missing.
		"_Rune11",
		"_Rune12",
		"_Rune13",
		"_Rune14",
		"_Rune15",
		"_Rune16",
		"_Rune17",
		"_Rune18",
		"_Rune19",
		"_Rune20",
		"_RuneGuldan1",
		"_RuneGuldan2",
		"_RuneGuldan3",
		"_RuneGuldan4",
		"_RuneGuldan5",
		"_RuneGuldan6",
		"_RuneGuldan7",
		"_RuneGuldan8",
		"_RuneGuldan9",
		
	}
	GHM_GHIIcons["Jewelcrafting"] = {}
	GHM_GHIIcons["Magical Items"] = {
		"_Controlledwater",
		"_EnergeticOrbBlue",
		"_EnergeticOrbGreen",
		"_EnergeticOrbLightBlue",
		"_EnergeticOrbOrange",
		"_EnergeticOrbPurple",
		--"_EnergeticOrbWhite",
		"_EnergeticOrbYellow",
		--"_Flammecorrompue",--corrupted flame
		--"_Flammemaitrisee",--controlled flme?
		"_ForgedRuneBlue",
		"_ForgedRuneOrange",
		"_ForgedRunePurple",
		"_ForgedRuneRed",
		"_ForgedRuneBlue",
		"_ForgedRuneBlue",
		"_ForgedRuneYellowGreen",
		--"_Foudremaitrisee",
		"_Glacemaitrisee",
		"_HealStone_Gold",
		"_HealStone_Ice",
		"_HealStone_Orange",
		"_HealStone_Purple",
		"_HealStone_RedOrange",
		--"_Lumieremaitrisee",
		--"_Magmacorrompumaitrise",
		--"_Magmamaitrise",
		--"_Manamaitrise",
		"_ManaGemBlue",
		"_ManaGemGreen",
		"_ManaGemLightBlue",
		"_ManaGemPurple",
		"_ManaGemRed",
		"_ManaGemYellow",
		"_MysticOrbBlue",
		"_MysticOrbGreen",
		"_MysticOrbLightBlue",
		"_MysticOrbOrange",
		"_MysticOrbPurple",
		"_MysticOrbRed",
		"_MysticOrbYellowGreen",
		"_Mastered_Earth",
		"_Mastered_Energy",
		"_Mastered_FelEarth",
		"_Mastered_FelFlame",
		"_Mastered_FelMagma",
		"_Mastered_Fire_Blue",
		"_Mastered_Fire_Purple",
		"_Mastered_Flame",
		"_Mastered_Life",
		"_Mastered_Light",
		"_Mastered_Magma",
		"_Mastered_Mana",
		"_Mastered_Nether",
		"_Mastered_Poison",
		"_Mastered_Shadow",
		"_Mastered_Sickness",
		"_Mastered_Saronite", 
		"_Mastered_Water",
		--"_Neantmaitrise",
		--"_Ombremaitrisee",
		"_OrbDeco_Blue",
		"_OrbDeco_GoldBlue",
		"_OrbDeco_Green",
		"_OrbDeco_LightBlue",
		"_OrbDeco_Orange",
		"_OrbDeco_Red",
		"_OrbDeco_Yellow",
		"_OrbDeco_YellowGreen",
		--- "_Poisonmaitrise",

		--"_Terreempoisonnee", --Icon Missing.
		"_ToxicOrb",
		"_Tir_de_Terre",
		"_Tir_dEau",
		"_LDAEye",
		"_StoneTablet_AzsharaLogo", 
		"_StoneTablet_Blood", 
		"_StoneTablet_Gibberish", 
		"_StoneTablet_Hellfire", 
		"_StoneTablet_Nexus", 
		"_StoneTablet_ShamanAir", 
		"_StoneTablet_ShamanEarth", 
		"_StoneTablet_ShamanFire", 
		"_StoneTablet_ShamanWater", 
		"_StoneTablet_StainedBlood", 
		"_StoneTablet_StainedSlime", 
		"_StoneTablet_Warlock_01", 
		"_StoneTablet_Warlock_02", 
		"_StoneTablet_Warlock_03", 
		"_StoneTablet_Warlock_04",
		"_InscriptionStones_Blue", 
		"_InscriptionStones_Green", 
		"_InscriptionStones_Jade", 
		"_InscriptionStones_LightBlue", 
		"_InscriptionStones_Orange", 
		"_InscriptionStones_Purple", 
		"_InscriptionStones_Red", 
		"_InscriptionStones_Yellow", 
		"_LiquidStone_Blood", 
		"_LiquidStone_Poison", 
		"_LiquidStone_Shadow", 
		"_LiquidStone_Water", 		
	}
	GHM_GHIIcons["Banners"] = {
		"_Croise", --argent crusade symbol
		"_HordeFlag_Blue",
		"_HordeFlag_Green",
		"_HordeFlag_LightBlue",
		"_HordeFlag_Orange",
		"_HordeFlag_Purple",
		"_HordeFlag_Red",
		"_HordeFlag_Yellow",
		"_KirinTor",
		"_GuildBanner_Omega_DeathKnight", 
		"_GuildBanner_Omega_Druid", 
		"_GuildBanner_Omega_Hunter", 
		"_GuildBanner_Omega_Mage", 
		"_GuildBanner_Omega_Monk", 
		"_GuildBanner_Omega_Paladin", 
		"_GuildBanner_Omega_Priest", 
		"_GuildBanner_Omega_Rogue", 
		"_GuildBanner_Omega_Shaman", 
		"_GuildBanner_Omega_Warlock", 
		"_GuildBanner_Omega_Warrior", 
	}
	GHM_GHIIcons["Misc"] = {
		"GHIcon",
		"_BloodBlue",
		"_BloodGhost",
		"_BloodGreen",
		"_BloodOrange",
		"_BloodPurple",
		"_CrossingSwords_ColorsBlue", 
		"_CrossingSwords_ColorsGreen", 
		"_CrossingSwords_ColorsPurple", 
		"_CrossingSwords_ColorsRed", 
		"_CrossingSwords_ColorsYellow", 
		"_CrossingSwords_DeathKnight", 
		"_CrossingSwords_Druid", 
		"_CrossingSwords_Hunter", 
		"_CrossingSwords_Mage", 
		"_CrossingSwords_Monk", 
		"_CrossingSwords_Paladin", 
		"_CrossingSwords_Priest", 
		"_CrossingSwords_Rogue", 
		"_CrossingSwords_Shaman", 
		"_CrossingSwords_Warlock", 
		"_CrossingSwords_Warrior", 
		"_DiceBrown",
		"_DiceGreen",
		"_DiceLightBlue",
		"_DicePink",
		"_DicePurple",
		"_DiceRed",
		"_DiceYellow",
		"_Dices_DeathKnight", 
		"_Dices_Druid", 
		"_Dices_Hunter", 
		"_Dices_Mage", 
		"_Dices_Monk", 
		"_Dices_Paladin", 
		"_Dices_Priest", 
		"_Dices_Rogue", 
		"_Dices_Shaman", 
		"_Dices_Warlock", 
		"_Dices_Warrior", 
		"_GeneralMap",
		"_SexyMapAddOnIcon",
		"_Hole_Blue",
		"_Hole_Green",
		"_Hole_Pink",
		"_Hole_LightBlue",
		"_Hole_Purple",
		"_Hole_Red",
		"_Hole_Yellow",
		"_LFG_Blue",
		"_LFG_Green",
		"_LFG_Purple",
		"_LFG_Red",
		"_LFG_Yellow",
		"_MoreBlue",
		"_MoreLightBlue",
		"_MoreGreen",
		"_MorePurple",
		"_MoreRed",
		"_Reverse_Acid",
		"_Reverse_Blue",
		"_Reverse_Brown",
		"_Reverse_Green",
		"_Reverse_LightBlue",
		"_Reverse_Orange",
		"_Reverse_Pink",
		"_Reverse_Purple",
		"_Reverse_Red",
		"_Reverse_White",
		"_Reverse_Yellow",
		"_SpiritBlue",
		"_SpiritGreen",
		"_SpiritLightBlue",
		"_SpiritRed",
		"_Chewing_gum",
		"_Foam_sword",
		"_Puke_Blue",
		"_Puke_Orange",
		"_Puke_Red",
		"_Rack_foam_sword",
		"_Interact_DeathKnight", 
		"_Interact_Druid", 
		"_Interact_Hunter", 
		"_Interact_Mage", 
		"_Interact_Monk", 
		"_Interact_Paladin", 
		"_Interact_Priest", 
		"_Interact_Rogue", 
		"_Interact_Shaman", 
		"_Interact_Warlock", 
		"_Interact_Warrior",
		"_MinusSign_DeathKnight", 
		"_MinusSign_Druid", 
		"_MinusSign_Hunter", 
		"_MinusSign_Mage", 
		"_MinusSign_Monk", 
		"_MinusSign_Paladin", 
		"_MinusSign_Priest", 
		"_MinusSign_Rogue", 
		"_MinusSign_Shaman", 
		"_MinusSign_Warlock", 
		"_MinusSign_Warrior", 
		"_PlusSign_DeathKnight", 
		"_PlusSign_Druid", 
		"_PlusSign_Hunter", 
		"_PlusSign_Mage", 
		"_PlusSign_Monk", 
		"_PlusSign_Paladin", 
		"_PlusSign_Priest", 
		"_PlusSign_Rogue", 
		"_PlusSign_Shaman", 
		"_PlusSign_Warlock", 
		"_PlusSign_Warrior",
		"_UI_Interrogation_Color_Blue", 
		"_UI_Interrogation_Color_Green", 
		"_UI_Interrogation_Color_LightBlue", 
		"_UI_Interrogation_Color_Purple", 
		"_UI_Interrogation_Color_Red", 
		"_UI_Interrogation_Color_Yellow", 
		"_UI_Interrogation_DeathKnight", 
		"_UI_Interrogation_Druid", 
		"_UI_Interrogation_Hunter", 
		"_UI_Interrogation_Mage", 
		"_UI_Interrogation_Monk", 
		"_UI_Interrogation_Paladin", 
		"_UI_Interrogation_Priest", 
		"_UI_Interrogation_Rogue", 
		"_UI_Interrogation_Shaman", 
		"_UI_Interrogation_Warlock", 
		"_UI_Interrogation_Warrior", 
		"_UI_Quest_Color_Blue", 
		"_UI_Quest_Color_Green", 
		"_UI_Quest_Color_LightBlue", 
		"_UI_Quest_Color_Purple", 
		"_UI_Quest_Color_Red", 
		"_UI_Quest_Color_Yellow", 
		"_UI_Quest_DeathKnight", 
		"_UI_Quest_Druid", 
		"_UI_Quest_Hunter", 
		"_UI_Quest_Mage", 
		"_UI_Quest_Monk", 
		"_UI_Quest_Paladin", 
		"_UI_Quest_Priest", 
		"_UI_Quest_Rogue", 
		"_UI_Quest_Shaman", 
		"_UI_Quest_Warlock", 
		"_UI_Quest_Warrior", 
		"_Time_1_Dawn", 
		"_Time_2_Daytime", 
		"_Time_3_Sunset", 
		"_Time_4_Twilight", 
		"_Time_5_Night", 
		"_Time_Dawn", 
		"_Time_Daytime", 
		"_Time_Night", 
		"_Time_Sunset", 
		 "BTNSkeletalOrc", 
		"BTNSkeletonArcher", 
		"BTNSkeletonMage", 
		"BTNSkeletonWarrior", 
		"BTNSatyr", 
		"BTNSatyrTrickster", 
		"BTNSeaGiant", 
		"BTNSeaGiantGreen", 
		"BTNSeaWitch", 
		"BTNShade", 
		"BTNNagaMyrmidon", 
		"BTNNagaMyrmidonRoyalGuard", 
		"BTNNagaSeaWitch", 
		"BTNNagaSummoner", 
		"BTNNecromancer",
		 "BTNFrostWyrm", 
		"BTNGargoyle", 
		"BTNGhoul", 
		"BTNGlaiveThrower", 
		"BTNMeatWagon", 
		"BTNHeroCryptLord", 
		"BTNHeroDreadlord",

		"BTNKelThuzad", 
		"BTNHeroLich", 
		 "BTNAcolyte", 
		"BTNCorruptedEnt", 
		"BTNCryptFiend", 
		 "BTNDemolisher", 
		  "BTNTichondrius", 
	}
	GHM_GHIIcons["Zones"] = {}
	GHM_GHIIcons["Arena"] = {}
	GHM_GHIIcons["Battleground"] = {}
	GHM_GHIIcons["Boss"] = {}
	GHM_GHIIcons["Character"] = {
		"_Stan1",
		"_Stan2",
		"_SylvanasPortrait",
		"_TSGIcon",
		"_Yargh",
		"_Forsaken_Caster", 
		"_Forsaken_Female_Rogue",
	}
	GHM_GHIIcons["Dungeon"] = {}
	GHM_GHIIcons["Misc Achievement"] = {
		"_BeltBuckleSilverRP_DeathKnight", 
		"_BeltBuckleSilverRP_Druid", 
		"_BeltBuckleSilverRP_Hunter", 
		"_BeltBuckleSilverRP_Mage", 
		"_BeltBuckleSilverRP_Monk", 
		"_BeltBuckleSilverRP_Paladin", 
		"_BeltBuckleSilverRP_Priest", 
		"_BeltBuckleSilverRP_Rogue", 
		"_BeltBuckleSilverRP_Shaman", 
		"_BeltBuckleSilverRP_Warlock", 
		"_BeltBuckleSilverRP_Warrior", 
		 "_LDARPBelt", 
	}
	GHM_GHIIcons["PvP"] = {
		"_PvP",
		"_CallToArmsBlue",
		"_CallToArmsLightBlue",
		"_CallToArmsOrange",
		"_CallToArmsPurple",
		"_CallToArmsRed",
		"_CallToArmsYellow",
		"_CallToArms_Forsaken_Blue",
		"_CallToArms_Forsaken_Cyan",
		"_CallToArms_Forsaken_Green",
		"_CallToArms_Forsaken_Original",
		"_CallToArms_Forsaken_Purple",
		"_CallToArms_Forsaken_Red",
	}
	GHM_GHIIcons["Quest"] = {
		"_UI_Interrogation_Color_Blue", 
		"_UI_Interrogation_Color_Green", 
		"_UI_Interrogation_Color_LightBlue", 
		"_UI_Interrogation_Color_Purple", 
		"_UI_Interrogation_Color_Red", 
		"_UI_Interrogation_Color_Yellow", 
		"_UI_Interrogation_DeathKnight", 
		"_UI_Interrogation_Druid", 
		"_UI_Interrogation_Hunter", 
		"_UI_Interrogation_Mage", 
		"_UI_Interrogation_Monk", 
		"_UI_Interrogation_Paladin", 
		"_UI_Interrogation_Priest", 
		"_UI_Interrogation_Rogue", 
		"_UI_Interrogation_Shaman", 
		"_UI_Interrogation_Warlock", 
		"_UI_Interrogation_Warrior", 
		"_UI_Quest_Color_Blue", 
		"_UI_Quest_Color_Green", 
		"_UI_Quest_Color_LightBlue", 
		"_UI_Quest_Color_Purple", 
		"_UI_Quest_Color_Red", 
		"_UI_Quest_Color_Yellow", 
		"_UI_Quest_DeathKnight", 
		"_UI_Quest_Druid", 
		"_UI_Quest_Hunter", 
		"_UI_Quest_Mage", 
		"_UI_Quest_Monk", 
		"_UI_Quest_Paladin", 
		"_UI_Quest_Priest", 
		"_UI_Quest_Rogue", 
		"_UI_Quest_Shaman", 
		"_UI_Quest_Warlock", 
		"_UI_Quest_Warrior", 

	
	}


end

function FindRemainingIcons()
	local t = {};
	local c = 0;
	for a = 1, #(GHM_RawIcons) do
		local new = GHM_RawIcons[a];
		local found = false;
		for _i, _category in pairs(GHM_IconCategories) do
			_subcategories = GHM_IconSubcategories[_category]
			for _j = 1, table.getn(_subcategories), 1 do if found == false then
				_icons = GHM_StockIcons[_subcategories[_j]]
				for _k = 1, table.getn(_icons), 1 do
					if (_icons[_k] == new) then
						found = true;
					end
				end
			end
			end
			GHM_StockIcons[_category] = _group
		end

		if found == false then
			table.insert(t, new);
			c = c + 1;
		end
	end
	GHI_Message(c .. " new icons found");
	return t;
end




