﻿   --
--								GHI Sound List
--									GHM_SoundList.lua
--
--		List of sounds in table format
--
--
-- 						(c)2013 The Gryphonheart Team
--								All rights reserved
--

local loaded = false;
function GHM_InitSoundList() 
	if loaded then
		return
	end
	loaded = true;
	GHM_SoundList = {
		["Sound\\"] = {
			["Ambience\\"] = {
				["GlueScreen\\"] = {
					["Wrath_Login_"] = {
						["1.ogg"] = 02.76,
						["2.ogg"] = 06.08,
						["3.ogg"] = 10.81,
						["4.ogg"] = 05.61,
					},
					["GlueScreenLogin.ogg"] = 61.00,
				},
				["Water\\"] = {
					["GreenSlimeFallsLoop1.ogg"] = 06.78,
					["GreenSlimeLoop1.ogg"] = 08.39,
					["LavaPoolLoop.ogg"] = 09.95,
					["LavaStreamLoop.ogg"] = 10.00,
					["OceanA.ogg"] = 10.22,
					["RiverFastA.ogg"] = 05.25,
					["RiverSlowA.ogg"] = 10.12,
					["River_LakeStillA.ogg"] = 10.12,
				},
				["Weather\\"] = {
					["RainHeavyLoop.ogg"] = 25.00,
					["RainLightLoop.ogg"] = 20.00,
					["RainMediumLoop.ogg"] = 30.00,
					["SandStormHeavy.ogg"] = 60.00,
					["SandStormLight.ogg"] = 60.00,
					["SandStormMedium.ogg"] = 60.00,
					["SnowHeavy.ogg"] = 40.00,
					["SnowLight.ogg"] = 29.95,
					["SnowMedium.ogg"] = 50.00,
				},
				["WMOAmbience\\"] = {
					["IceCrownRaid_"] = {
						["CrimsonHall.ogg"] = 84.61,
						["TheForgeOfSouls.ogg"] = 84.03,
						["Frostmourne_AMB.ogg"] = 66.92,
					},
					["Sholazar_"] = {
						["MakersOverlook.ogg"] = 73.42,
						["TheTribunalofAges.ogg"] = 73.42,
					},
					["Sunwell_"] = {
						["GrandMagistersAsylum.ogg"] = 90.00,
						["INT_Generic1.ogg"] = 94.05,
					},
					["UlduarRaid_"] = {
						["EngineRoom.ogg"] = 102.60,
						["General.ogg"] = 145.07,
						["LichKingWing.ogg"] = 67.28,
						["PlanetariumHallway.ogg"] = 60.54,
						["StormwindWing.ogg"] = 68.99,
						["Tram.ogg"] = 86.42,
						["Wyrmrest_Temple.ogg"] = 70.41,
						["Yogg_Saron_BrainRoom.ogg"] = 90.68,
					},
					["AhnQirajInterirorFireFlyRoom.ogg"] = 40.00,
					["AhnQirajRuinsBareRoomTone.ogg"] = 59.44,
					["AhnQirajRuinsTriangleRoom.ogg"] = 59.98,
					["AuchindounDemonWing.ogg"] = 90.00,
					["AuchindounDraineiWing.ogg"] = 87.00,
					["AuchindounEtherialWing.ogg"] = 74.00,
					["AuchindounShadowWing.ogg"] = 60.99,
					["AzjulNerubUpperCity.ogg"] = 150.00,
					["Blackfathom.ogg"] = 74.63,
					["BlackRockJail.ogg"] = 110.00,
					["BlackrockSpire.ogg"] = 75.00,
					["BlackRockSpireDrakeCalls.ogg"] = 109.23,
					["BlackSmith.ogg"] = 59.54,
					["BlackTempleCenterRoom.ogg"] = 69.00,
					["BlackTempleCHUD.ogg"] = 63.97,
					["BlackTempleIllidanTower1.ogg"] = 96.00,
					["BlackTempleReliquaryofSouls.ogg"] = 73.00,
					["CavernsOfTimeBasic.ogg"] = 60.00,
					["CavernsOfTimeCore.ogg"] = 64.04,
					["CaveSmallCold01.ogg"] = 27.59,
					["CaveSmallCold02.ogg"] = 27.59,
					["CaveSmallCold03.ogg"] = 34.13,
					["CaveSmallWarm01.ogg"] = 27.48,
					["CaveSmallWarm02.ogg"] = 27.66,
					["CaveVolcanic.ogg"] = 63.73,
					["CoilFangReservoir.ogg"] = 92.00,
					["CoilFangStandard.ogg"] = 92.00,
					["CoilFangSteamVault.ogg"] = 92.00,
					["DalaranPrison.ogg"] = 110.00,
					["DalaranSewers.ogg"] = 75.37,
					["DarnassusDay.ogg"] = 56.94,
					["DarnassusNight.ogg"] = 56.94,
					["DireMaulChamber.ogg"] = 59.54,
					["DrakTharonKeep.ogg"] = 60.00,
					["DungeonCatheadral.ogg"] = 59.44,
					["DungeonCrypt.ogg"] = 88.98,
					["DwarvenDistrict.ogg"] = 56.94,
					["ExodarCity1.ogg"] = 75.00,
					["Gnomeregan.ogg"] = 58.49,
					["GundrakGeneral.ogg"] = 103.70,
					["GundrakWaterSteam.ogg"] = 103.70,
					["HellFireBloodFurnace.ogg"] = 104.00,
					["HellfireCitadelMilitary.ogg"] = 60.00,
					["HellfireMagtheradonsLair.ogg"] = 78.00,
					["IceCrownRaidGeneral.ogg"] = 89.12,
					["IceCrownRaidPlagueWorks.ogg"] = 87.70,
					["Ironforge.ogg"] = 88.56,
					["IronforgeTheGreatForge.ogg"] = 58.18,
					["KarazhanBasementHorseStables.ogg"] = 72.00,
					["KarazhanDemonArea.ogg"] = 70.00,
					["KarazhanDiningRoom.ogg"] = 75.00,
					["KarazhanFacade.ogg"] = 60.00,
					["KarazhanGreatHall.ogg"] = 60.00,
					["KarazhanGuestChambers.ogg"] = 73.00,
					["KarazhanLibraryExterior.ogg"] = 70.00,
					["KarazhanNetherwindeBossRoom.ogg"] = 59.85,
					["KarazhanOperaBackstage.ogg"] = 60.00,
					["LargeRoomTone.ogg"] = 56.94,
					["LargeRoomToneNew.ogg"] = 59.54,
					["LordaeronBellDoodad.ogg"] = 29.07,
					["MineStandard02.ogg"] = 59.99,
					["MineStandard03.ogg"] = 59.99,
					["MineStandardDungeon.ogg"] = 56.94,
					["MineStandardNorthrend.ogg"] = 80.00,
					["mini-hive.ogg"] = 52.72,
					["NaxxramasAbominationWing.ogg"] = 60.00,
					["NaxxramasDeathknightWing.ogg"] = 59.99,
					["NaxxramasEntrance.ogg"] = 59.95,
					["NaxxramasFrostWyrm.ogg"] = 60.00,
					["NaxxramasPlagueWing.ogg"] = 59.92,
					["NaxxramasSpiderWing.ogg"] = 59.85,
					["Nexus70EnergyRoom.ogg"] = 86.14,
					["Nexus70General.ogg"] = 60.00,
					["OldStrathHolme1.ogg"] = 133.38,
					["OldStrathHolme2.ogg"] = 73.42,
					["OrgrimmarDay.ogg"] = 56.84,
					["OrgrimmarNight.ogg"] = 56.94,
					["RazorfenKraul.ogg"] = 56.94,
					["ShipExterior.ogg"] = 60.00,
					["ShipInterior.ogg"] = 60.00,
					["SilverMoonGeneralDay1.ogg"] = 59.97,
					["SilverMoonGeneralNight1.ogg"] = 55.00,
					["SmallRoomTone.ogg"] = 23.10,
					["StormwindDay.ogg"] = 56.94,
					["StormWindJail.ogg"] = 59.63,
					["StormwindNight.ogg"] = 56.94,
					["Stratholme.ogg"] = 70.94,
					["SubwayStation.ogg"] = 30.00,
					["SubwayUnderwater.ogg"] = 14.88,
					["SunkenTemple.ogg"] = 59.63,
					["SunwellProgressionLight1.ogg"] = 105.59,
					["SunwellProgressionLight2.ogg"] = 105.00,
					["Tavern.ogg"] = 60.00,
					["TavernCrowded.ogg"] = 55.90,
					["TempestKeepGeneral.ogg"] = 74.00,
					["TempestKeepRaidPhoenix01.ogg"] = 74.00,
					["ThunderBluffDay.ogg"] = 60.00,
					["ThunderBluffNight.ogg"] = 60.00,
					["Ulduar77Main.ogg"] = 107.77,
					["Undercity.ogg"] = 45.88,
					["UnderCityCrowd.ogg"] = 41.42,
					["UnderCityThorneRoom.ogg"] = 118.70,
					["UtegardeGeneral.ogg"] = 60.00,
					["VordrassilsTears.ogg"] = 70.00,
					["WailingCaverns.ogg"] = 75.00,
					["WarsongGulch.ogg"] = 90.00,
					["BlackTemple_Aqueduct.ogg"] = 60.00,
					["Karazhan_GeneralAmbience.ogg"] = 55.03,
					["Nexus70_Library.ogg"] = 93.92,
				},
				["zoneambience\\"] = {
					["AMB_"] = {
						["ASHRAN_BASE_"] = {
							["DAY.ogg"] = 150.00,
							["NIGHT.ogg"] = 150.00,
						},
						["Brawl_"] = {
							["Horde_Walla_"] = {
								["Fight.OGG"] = 30.03,
								["Prefight.OGG"] = 30.03,
							},
							["Alliance_Walla_Fight.OGG"] = 30.03,
						},
						["CityGilneas_"] = {
							["Day01.ogg"] = 117.21,
							["Night01.ogg"] = 117.40,
						},
						["CityofOrgrimmarValleyofHonor_"] = {
							["Day04.ogg"] = 129.21,
							["Night02.ogg"] = 127.49,
						},
						["CoastalBarren_"] = {
							["Day_Bits_"] = {
								["04.OGG"] = 09.00,
								["05.OGG"] = 09.00,
								["06.OGG"] = 09.00,
							},
							["Day01.ogg"] = 60.00,
							["Night01.ogg"] = 60.00,
						},
						["CoastalGrasslands_"] = {
							["Day01.ogg"] = 90.00,
							["Night01.ogg"] = 90.00,
						},
						["DreadWastes_"] = {
							["Base.OGG"] = 119.46,
							["AmberSolar_Loop.OGG"] = 106.00,
						},
						["ForestWet_"] = {
							["Day04.ogg"] = 83.07,
							["Night03.ogg"] = 83.34,
						},
						["FROSTFIRE_"] = {
							["BONETOWN_INT_BASE_LOOP.OGG"] = 118.42,
							["Cave_loop.OGG"] = 122.60,
							["HEAVY_WIND_BASE_LOOP.OGG"] = 110.71,
							["VALLEYS_WIND_LOOP.OGG"] = 102.54,
						},
						["GSS_MantidBattle_"] = {
							["01.OGG"] = 08.60,
							["02.OGG"] = 08.60,
							["03.OGG"] = 10.00,
							["07.OGG"] = 10.00,
							["08.OGG"] = 09.42,
							["09.OGG"] = 10.00,
						},
						["IndustrialMining_"] = {
							["Day01.ogg"] = 72.46,
							["Night01.ogg"] = 72.46,
						},
						["JadeForest_"] = {
							["Base_Day01.OGG"] = 137.00,
							["SerpentSpine_Day01.OGG"] = 60.00,
						},
						["JadeTemple_"] = {
							["EastTemple_Loop.OGG"] = 105.00,
							["East_Approach_Loop.OGG"] = 15.00,
							["LibraryApproach_Loop.OGG"] = 15.00,
							["Library_Loop.OGG"] = 60.00,
							["MeditationChamber_Loop.OGG"] = 90.00,
						},
						["KL_"] = {
							["Inkgill_Mere.OGG"] = 56.19,
							["Zouchin_Province.OGG"] = 60.54,
						},
						["KrasarangWilds_Base_"] = {
							["Day01.OGG"] = 105.60,
							["Night01.OGG"] = 121.57,
						},
						["Nagrand_"] = {
							["Canyon_Day_Loop.OGG"] = 96.49,
							["Day_General_Loop.OGG"] = 108.63,
							["Night_General_Loop.OGG"] = 124.41,
						},
						["OGRaid_"] = {
							["OutsideBattle_"] = {
								["Close_Sweetner_"] = {
									["Loop02.OGG"] = 09.68,
									["Loop03.OGG"] = 09.43,
									["Loop04.OGG"] = 09.47,
									["Loop05.OGG"] = 09.43,
									["Loop09.OGG"] = 09.01,
								},
								["Distant_Sweetner_"] = {
									["Loop02.OGG"] = 09.02,
									["Loop03.OGG"] = 09.03,
									["Loop04.OGG"] = 09.01,
									["Loop08.OGG"] = 09.01,
									["Loop09.OGG"] = 09.01,
									["Loop10.OGG"] = 09.02,
								},
							},
							["GarroshCompound_Base.OGG"] = 122.20,
						},
						["SHADOWMOON_"] = {
							["PLAINS_LOOP.OGG"] = 92.25,
							["STANDINGSTONES_LOOP.OGG"] = 79.70,
							["THICKFORESTAREA_LOOP.OGG"] = 76.06,
						},
						["Spires_"] = {
							["Bird_Sweetner_"] = {
								["Oneshot_"] = {
									["01.OGG"] = 06.69,
									["02.OGG"] = 06.69,
									["03.OGG"] = 06.21,
									["04.OGG"] = 06.48,
									["08.OGG"] = 06.67,
									["09.OGG"] = 05.62,
									["10.OGG"] = 07.22,
								},
							},
							["Haunting_"] = {
								["Sweetner03.OGG"] = 10.48,
								["Sweetner04.OGG"] = 10.61,
								["Sweetner05.OGG"] = 09.85,
								["Sweetner06.OGG"] = 09.91,
								["Sweetner09.OGG"] = 09.96,
							},
							["Tree_Haunt_"] = {
								["Creak_"] = {
									["01.OGG"] = 09.15,
									["02.OGG"] = 06.78,
									["03.OGG"] = 07.87,
									["04.OGG"] = 07.57,
									["08.OGG"] = 09.71,
									["09.OGG"] = 09.87,
									["10.OGG"] = 08.81,
								},
							},
							["Base_Day_Loop.OGG"] = 151.31,
						},
						["StormstoutBrewery_"] = {
							["FoyerInterior_Loop.OGG"] = 105.00,
							["MainHallInterior_Loop.OGG"] = 105.00,
							["WheelhouseFloor2_Interior_Loop.OGG"] = 86.00,
						},
						["TanaanJungle_"] = {
							["Day.OGG"] = 89.66,
							["Night.OGG"] = 80.06,
						},
						["TKRaid_"] = {
							["Sewers.OGG"] = 90.00,
							["Subterranean.OGG"] = 90.00,
						},
						["UniBreezy_"] = {
							["Day01.ogg"] = 94.00,
							["Night01.ogg"] = 94.00,
						},
						["VFW_"] = {
							["Springroad.OGG"] = 58.00,
							["Paoquan_Hollow_Base.OGG"] = 114.95,
						},
						["WI_"] = {
							["CentralTemple.OGG"] = 60.00,
							["TheRows_Base.OGG"] = 60.00,
						},
						["BlackrockCaverns.ogg"] = 85.04,
						["ChamberofIncineration.ogg"] = 89.31,
						["FirelandsLavaCavernsInterior.ogg"] = 60.00,
						["FirelandsMoltenFields.ogg"] = 60.00,
						["FirelandsSulfuronKeepInterior.ogg"] = 60.00,
						["FirelandsWindy.ogg"] = 60.00,
						["ForestBlackwald.ogg"] = 138.99,
						["Maelstrom.ogg"] = 85.00,
						["Arakkoa_Dungeon.OGG"] = 64.64,
						["Azshara_BlackmawHold_INT.ogg"] = 87.97,
						["Blackrock_TrainDepot_Base.OGG"] = 90.00,
						["BlackwingDescentLava_01.ogg"] = 91.57,
						["BlackwingDescent_02.ogg"] = 103.08,
						["CityofOrgrimmarGoblinSlums_Night03.ogg"] = 171.91,
						["CityofOrgrimmarValleyofSpirits_Day03.ogg"] = 126.53,
						["CityofOrgrimmarValleyofWisdom_Night01.ogg"] = 131.71,
						["CoastalNormal_Night01.ogg"] = 91.63,
						["DarkmoonFaireIsland_General.ogg"] = 42.15,
						["DeathwebHollow_Day.OGG"] = 97.40,
						["Deepholm_02.ogg"] = 85.00,
						["DesertHigh_Day05.ogg"] = 90.00,
						["Draenei_LargeInterior_Loop.OGG"] = 69.69,
						["DraenorOceanUnderwaterGlobal_Loop.OGG"] = 114.09,
						["ForestDryLakeMennar_NIGHT01.ogg"] = 82.19,
						["ForestDryRavencrest_DAY01.ogg"] = 60.00,
						["ForestDryRuinsOfEldarath_NIGHT01.ogg"] = 59.63,
						["ForestRainy_Day01.ogg"] = 105.25,
						["ForestStormyEerie_Day01.ogg"] = 90.00,
						["ForestStormyHeavy_Day02.ogg"] = 90.00,
						["ForestStormy_DAY03.ogg"] = 90.00,
						["Gorgrond_Base_Night.ogg"] = 110.00,
						["GrasslandsDry_Day01.ogg"] = 90.00,
						["GreatWallDungeon_OpenInterior_Loop.OGG"] = 60.00,
						["GrimBatol_Day05.ogg"] = 87.95,
						["HallsOfOrigination_02.ogg"] = 85.00,
						["IndustrialDocks_Day01.ogg"] = 146.21,
						["IndustrialDrillingPlatform_Day01.ogg"] = 90.00,
						["JF_Coastal.OGG"] = 60.00,
						["JungleOasis_Day01.ogg"] = 90.00,
						["KezanChaos_Night01.ogg"] = 95.00,
						["KunLaiSummit_Valley_Night01.OGG"] = 60.00,
						["LostCityOfTheTolvir_Day02.ogg"] = 85.00,
						["MantidDungeon_NarrowTunnel_Loop.OGG"] = 105.00,
						["MantidRaid_HeartOfFear_LL_Loop.OGG"] = 80.00,
						["Mogudungeon_Intensity3_Loop.OGG"] = 105.00,
						["MoguRaid_Interior_Loop.OGG"] = 105.00,
						["PA_BambooForest.OGG"] = 60.00,
						["ShadoPanDungeon_Interior_Loop.OGG"] = 90.00,
						["ShadowmoonDungeon_Base.OGG"] = 105.14,
						["Skywall_02.ogg"] = 85.00,
						["STVMine_WaterPoolArea_Loop.OGG"] = 60.00,
						["ThroneoftheTides_Day04.ogg"] = 90.00,
						["ThunderKingIsland_Base.OGG"] = 184.66,
						["ValeofEternalBlossoms_Base_Night01.OGG"] = 115.00,
						["Valleyofthefourwinds_Base_Night01.OGG"] = 113.92,
						["Vashjir_02.ogg"] = 90.00,
						["WanderingIsle_Base_Day01.OGG"] = 115.47,
						["WoodsEerie_Night03.ogg"] = 90.00,
					},
					["FX_"] = {
						["60_"] = {
							["EXOTICBIRD_"] = {
								["FLAVOR01.ogg"] = 03.08,
								["FLAVOR04.ogg"] = 04.13,
								["FLAVOR05.ogg"] = 05.30,
								["FLAVOR06.ogg"] = 03.62,
								["FLAVOR07.ogg"] = 03.83,
							},
							["EXOTICWILD_"] = {
								["FLAVOR01.ogg"] = 03.40,
								["FLAVOR06.ogg"] = 03.90,
								["FLAVOR08.ogg"] = 06.83,
							},
						},
						["Crowd_"] = {
							["React_"] = {
								["Cheer_Highmaul_"] = {
									["Arena_"] = {
										["01.ogg"] = 03.93,
										["02.ogg"] = 04.11,
										["03.ogg"] = 03.89,
										["04.ogg"] = 09.95,
										["05.ogg"] = 11.40,
									},
								},
								["Loose_Highmaul_Arena_01.ogg"] = 06.82,
							},
							["Walla_Loop_"] = {
								["Highmaul_Arena_"] = {
									["01.ogg"] = 09.92,
									["02.ogg"] = 09.90,
									["03.ogg"] = 09.81,
								},
							},
						},
						["DistantWolves_Warsong_"] = {
							["01.OGG"] = 07.08,
							["02.OGG"] = 04.26,
							["03.OGG"] = 01.87,
							["04.OGG"] = 01.96,
							["05.OGG"] = 04.66,
							["06.OGG"] = 06.25,
							["07.OGG"] = 03.97,
							["08.OGG"] = 01.63,
							["09.OGG"] = 08.57,
							["10.OGG"] = 06.72,
						},
						["Skybox_DistantThunder_"] = {
							["01.OGG"] = 10.00,
							["02.OGG"] = 11.00,
							["03.OGG"] = 11.00,
							["04.OGG"] = 11.00,
							["05.OGG"] = 11.00,
						},
						["SMV_"] = {
							["Bird_Distant_"] = {
								["Flavor_"] = {
									["C_"] = {
										["01.OGG"] = 01.98,
										["02.OGG"] = 01.78,
										["03.OGG"] = 02.23,
									},
									["E_"] = {
										["01.OGG"] = 02.08,
										["02.OGG"] = 02.39,
									},
									["F_"] = {
										["01.OGG"] = 01.99,
										["02.OGG"] = 02.08,
										["03.OGG"] = 02.17,
									},
									["A_01.OGG"] = 02.20,
									["B_01.OGG"] = 02.15,
									["D_01.OGG"] = 01.67,
								},
							},
							["Insect_Distant_"] = {
								["Flavor_A_"] = {
									["01.OGG"] = 01.52,
									["02.OGG"] = 01.81,
									["03.OGG"] = 01.56,
								},
							},
						},
						["Walla_"] = {
							["Alliance_"] = {
								["Call2Arms_Summon_"] = {
									["Troops_"] = {
										["01.ogg"] = 02.13,
										["02.ogg"] = 01.67,
										["03.ogg"] = 01.96,
									},
								},
								["Celebrate_Win_"] = {
									["Battle_"] = {
										["Med_"] = {
											["01.ogg"] = 07.01,
											["02.ogg"] = 07.01,
										},
										["01.ogg"] = 10.95,
										["02.ogg"] = 12.74,
									},
								},
								["FEMALE_SCREAMS_"] = {
									["01.ogg"] = 01.54,
									["02.ogg"] = 01.69,
									["03.ogg"] = 01.01,
									["04.ogg"] = 01.52,
									["05.ogg"] = 01.06,
									["06.ogg"] = 01.35,
									["07.ogg"] = 01.58,
									["08.ogg"] = 01.34,
									["09.ogg"] = 01.77,
									["10.ogg"] = 01.23,
								},
								["MALE_SCREAMS_"] = {
									["01.ogg"] = 01.52,
									["02.ogg"] = 01.96,
									["03.ogg"] = 01.59,
									["04.ogg"] = 01.28,
									["05.ogg"] = 01.59,
									["06.ogg"] = 02.29,
									["07.ogg"] = 01.45,
									["08.ogg"] = 01.58,
									["09.ogg"] = 01.85,
									["10.ogg"] = 01.85,
								},
								["Rally_Cheers_"] = {
									["LRG_"] = {
										["01.ogg"] = 03.67,
										["02.ogg"] = 04.10,
									},
									["MED_"] = {
										["01.ogg"] = 03.09,
										["02.ogg"] = 02.72,
									},
									["SML_"] = {
										["01.ogg"] = 02.79,
										["02.ogg"] = 02.90,
										["03.ogg"] = 02.72,
									},
								},
								["TAVERN_"] = {
									["LARGE_"] = {
										["01.ogg"] = 09.94,
										["02.ogg"] = 10.01,
										["03.ogg"] = 09.80,
										["04.ogg"] = 09.56,
										["05.ogg"] = 09.85,
									},
									["MEDIUM_"] = {
										["01.ogg"] = 09.90,
										["02.ogg"] = 09.75,
										["03.ogg"] = 09.95,
										["04.ogg"] = 09.98,
										["05.ogg"] = 09.42,
										["06.ogg"] = 09.75,
									},
								},
								["TERRIFIED_TOWNIES_"] = {
									["LARGE_"] = {
										["01.ogg"] = 08.17,
										["02.ogg"] = 07.95,
										["03.ogg"] = 08.02,
										["04.ogg"] = 08.08,
										["05.ogg"] = 08.29,
										["06.ogg"] = 08.42,
										["07.ogg"] = 08.43,
									},
									["MEDIUM_"] = {
										["01.ogg"] = 08.78,
										["02.ogg"] = 08.95,
										["03.ogg"] = 08.42,
										["04.ogg"] = 08.92,
										["05.ogg"] = 07.92,
										["06.ogg"] = 08.71,
										["07.ogg"] = 08.05,
									},
									["SMALL_"] = {
										["01.ogg"] = 09.28,
										["02.ogg"] = 09.22,
										["03.ogg"] = 08.87,
										["04.ogg"] = 08.72,
										["05.ogg"] = 08.90,
									},
								},
								["TOWNHALL_"] = {
									["LARGE_"] = {
										["01.ogg"] = 06.94,
										["02.ogg"] = 06.73,
										["03.ogg"] = 06.81,
										["04.ogg"] = 06.97,
										["05.ogg"] = 06.97,
										["06.ogg"] = 06.95,
										["07.ogg"] = 06.84,
										["08.ogg"] = 06.85,
									},
									["MEDIUM_"] = {
										["01.ogg"] = 06.94,
										["02.ogg"] = 07.01,
										["03.ogg"] = 06.73,
										["04.ogg"] = 06.90,
										["05.ogg"] = 06.75,
										["06.ogg"] = 06.99,
										["07.ogg"] = 06.91,
										["08.ogg"] = 07.00,
									},
								},
								["Win_Battle_"] = {
									["Somber_"] = {
										["01.ogg"] = 10.74,
										["02.ogg"] = 11.82,
									},
								},
							},
							["Brawl_"] = {
								["Alliance_CrowdReact_"] = {
									["Lose01.ogg"] = 09.10,
									["Lose02.ogg"] = 09.12,
									["Lose03.ogg"] = 08.92,
									["Negative01.ogg"] = 04.92,
									["Negative02.ogg"] = 04.15,
									["Negative03.ogg"] = 03.87,
									["Negative04.ogg"] = 04.37,
									["Negative05.ogg"] = 03.24,
									["Negative06.ogg"] = 03.37,
									["Positive01.ogg"] = 02.62,
									["Positive02.ogg"] = 03.14,
									["Positive03.ogg"] = 03.53,
									["Positive04.ogg"] = 03.60,
									["Positive05.ogg"] = 03.52,
									["Positive06.ogg"] = 03.41,
									["Win01.ogg"] = 09.51,
									["Win02.ogg"] = 09.93,
									["Win03.ogg"] = 09.88,
									["Win04.ogg"] = 09.27,
									["Win05.ogg"] = 09.61,
								},
								["Horde_CrowdReact_"] = {
									["Win_"] = {
										["01.ogg"] = 09.15,
										["02.ogg"] = 09.01,
										["03.ogg"] = 09.75,
										["04.ogg"] = 09.01,
										["05.ogg"] = 09.01,
										["06.ogg"] = 09.03,
									},
									["Lose01.ogg"] = 10.39,
									["Lose02.ogg"] = 09.41,
									["Lose03.ogg"] = 09.51,
									["Negative01.ogg"] = 03.42,
									["Negative02.ogg"] = 03.10,
									["Negative03.ogg"] = 03.96,
									["Negative04.ogg"] = 03.66,
									["Negative05.ogg"] = 03.22,
									["Negative06.ogg"] = 03.62,
									["Positive01.ogg"] = 03.35,
									["Positive02.ogg"] = 03.50,
									["Positive03.ogg"] = 03.07,
									["Positive04.ogg"] = 03.80,
									["Positive05.ogg"] = 03.13,
									["Positive06.ogg"] = 03.77,
								},
							},
							["Horde_"] = {
								["CalltoArms_Summon_"] = {
									["Troops_"] = {
										["01.ogg"] = 02.21,
										["02.ogg"] = 01.65,
										["03.ogg"] = 01.55,
									},
								},
								["Celebrate_Win_"] = {
									["Battle_Med_"] = {
										["01.ogg"] = 10.47,
										["02.ogg"] = 09.87,
									},
								},
								["Rally_Cheers_"] = {
									["LRG_"] = {
										["01.ogg"] = 04.46,
										["02.ogg"] = 03.67,
									},
									["MED_"] = {
										["01.ogg"] = 03.09,
										["02.ogg"] = 02.72,
									},
									["SML_"] = {
										["01.ogg"] = 02.93,
										["02.ogg"] = 03.10,
										["03.ogg"] = 02.92,
									},
								},
								["TAVERN_"] = {
									["LARGE_"] = {
										["01.ogg"] = 09.58,
										["02.ogg"] = 09.86,
										["03.ogg"] = 09.87,
										["04.ogg"] = 09.80,
										["05.ogg"] = 09.54,
										["06.ogg"] = 09.47,
									},
									["MEDIUM_"] = {
										["01.ogg"] = 09.95,
										["02.ogg"] = 09.95,
										["03.ogg"] = 09.90,
										["04.ogg"] = 09.95,
										["05.ogg"] = 09.76,
										["06.ogg"] = 10.00,
									},
									["SMALL_"] = {
										["01.ogg"] = 09.94,
										["02.ogg"] = 09.97,
										["03.ogg"] = 10.00,
										["04.ogg"] = 09.83,
										["05.ogg"] = 10.00,
										["06.ogg"] = 09.91,
									},
								},
								["TERRIFIED_TOWNIES_"] = {
									["LARGE_"] = {
										["01.ogg"] = 08.69,
										["02.ogg"] = 08.64,
										["03.ogg"] = 08.48,
										["04.ogg"] = 08.64,
										["05.ogg"] = 08.36,
										["06.ogg"] = 08.57,
									},
									["MEDIUM_"] = {
										["01.ogg"] = 08.45,
										["02.ogg"] = 08.60,
										["03.ogg"] = 08.60,
										["04.ogg"] = 08.37,
										["05.ogg"] = 08.48,
										["06.ogg"] = 08.60,
									},
									["SMALL_"] = {
										["01.ogg"] = 08.72,
										["02.ogg"] = 08.53,
										["03.ogg"] = 08.61,
										["04.ogg"] = 08.75,
										["05.ogg"] = 08.62,
										["06.ogg"] = 08.46,
									},
								},
								["TOWNHALL_"] = {
									["LARGE_"] = {
										["01.ogg"] = 06.80,
										["02.ogg"] = 06.81,
										["03.ogg"] = 06.95,
										["04.ogg"] = 06.91,
										["05.ogg"] = 06.92,
										["06.ogg"] = 06.90,
										["07.ogg"] = 06.40,
										["08.ogg"] = 06.52,
									},
									["MEDIUM_"] = {
										["01.ogg"] = 06.87,
										["02.ogg"] = 06.68,
										["03.ogg"] = 06.80,
										["04.ogg"] = 06.93,
										["05.ogg"] = 06.97,
										["06.ogg"] = 06.95,
										["07.ogg"] = 06.93,
										["08.ogg"] = 06.82,
									},
									["SMALL_"] = {
										["01.ogg"] = 06.92,
										["02.ogg"] = 06.76,
										["03.ogg"] = 06.64,
										["04.ogg"] = 06.99,
										["05.ogg"] = 06.89,
										["06.ogg"] = 06.96,
										["07.ogg"] = 06.80,
										["08.ogg"] = 06.78,
									},
								},
								["Win_Battle_"] = {
									["Somber_"] = {
										["01.ogg"] = 10.82,
										["02.ogg"] = 10.73,
									},
								},
							},
							["Zandalari_Arena_"] = {
								["Ambient_"] = {
									["Cheer_Loop.ogg"] = 15.02,
									["Negative_Loop.ogg"] = 15.02,
									["Positive_Loop.ogg"] = 15.02,
								},
								["Defeat_"] = {
									["01.ogg"] = 03.56,
									["02.ogg"] = 04.45,
									["03.ogg"] = 03.99,
									["04.ogg"] = 04.20,
								},
								["ReactNegative_"] = {
									["01.ogg"] = 04.48,
									["02.ogg"] = 04.20,
									["03.ogg"] = 03.84,
									["04.ogg"] = 03.11,
								},
								["ReactPositive_"] = {
									["01.ogg"] = 03.58,
									["02.ogg"] = 03.11,
									["03.ogg"] = 03.89,
									["04.ogg"] = 03.62,
								},
								["Victory_"] = {
									["01.ogg"] = 06.14,
									["02.ogg"] = 05.21,
									["03.ogg"] = 05.47,
									["04.ogg"] = 05.49,
								},
							},
						},
						["WindGust_OneShot_"] = {
							["01.OGG"] = 05.79,
							["02.OGG"] = 04.09,
							["03.OGG"] = 04.97,
							["04.OGG"] = 04.72,
							["05.OGG"] = 05.53,
							["06.OGG"] = 04.85,
							["07.OGG"] = 05.85,
						},
					},
					["LostIslesPhase1_"] = {
						["Day.ogg"] = 108.45,
						["Night.ogg"] = 83.33,
					},
					["AmaniPassDay.ogg"] = 60.00,
					["AmaniPassNight.ogg"] = 60.00,
					["AmanvaleDay.ogg"] = 60.00,
					["AmanvalenNight.ogg"] = 60.00,
					["AmmenValeCrashSiteDay.ogg"] = 60.00,
					["ArgentArena.ogg"] = 65.95,
					["AzurebreezeCoastNight.ogg"] = 59.98,
					["BeachNight.ogg"] = 56.94,
					["BlackMorass.ogg"] = 79.00,
					["BladesEdgeForest.ogg"] = 144.00,
					["BladesEdgeGlobal.ogg"] = 110.00,
					["BladesEdgeSylvanaar.ogg"] = 144.00,
					["BloodMystDay.ogg"] = 68.00,
					["BloodMystNight.ogg"] = 69.00,
					["BoneWastes1.ogg"] = 71.00,
					["BoreanTundraGeneralDay.ogg"] = 90.00,
					["BoreanTundraGeneralNight.ogg"] = 80.00,
					["CanyonDesertDay.ogg"] = 56.47,
					["ColdaraNightDay.ogg"] = 110.36,
					["DalaranCityNight.ogg"] = 116.98,
					["DeadMines.ogg"] = 56.94,
					["DeadWindPassDay.ogg"] = 46.90,
					["DragonblightPlainsNightDay.ogg"] = 110.00,
					["DragonblightRubyDragonshrine.ogg"] = 105.00,
					["EbonHoldStage1Night.ogg"] = 75.45,
					["EbonHoldStage3.ogg"] = 75.38,
					["EbonHoldStage4.ogg"] = 75.45,
					["EcoDomeAll.ogg"] = 102.00,
					["EnchangedForestDay.ogg"] = 76.90,
					["EversongAmbienceNight.ogg"] = 59.98,
					["ForestHighDay.ogg"] = 60.00,
					["ForestScaryNight.ogg"] = 59.54,
					["GhostlandsDay.ogg"] = 59.97,
					["GhostlandsDay2.ogg"] = 59.88,
					["GhostlandsNight.ogg"] = 59.98,
					["GhostlandsNight2.ogg"] = 60.00,
					["GrasslandsDay.ogg"] = 60.00,
					["GrassLandsNight.ogg"] = 60.00,
					["GrizzlyHillsDayGeneral.ogg"] = 109.15,
					["GrizzlyHillsLumberNightday.ogg"] = 75.64,
					["GrizzlyHillsNightGeneral.ogg"] = 110.00,
					["GrizzlyHillsOpenDay.ogg"] = 66.36,
					["GrizzlyHillsOpenNight.ogg"] = 81.37,
					["Hellfire.ogg"] = 60.00,
					["HowlingFjordColdNightDay.ogg"] = 94.79,
					["HowlingFjordDay.ogg"] = 59.97,
					["HowlingFjordFireArea.ogg"] = 65.00,
					["HowlingFjordNight.ogg"] = 60.00,
					["HyjalPastDay.ogg"] = 97.00,
					["HyjalPastNight.ogg"] = 93.00,
					["IceCrownGlacier.ogg"] = 115.11,
					["JungleDay.ogg"] = 60.00,
					["JungleNight.ogg"] = 60.00,
					["LakeWintergraspDay.ogg"] = 132.63,
					["LakeWintergraspNight.ogg"] = 128.36,
					["MarshDay.ogg"] = 56.94,
					["MarshNight.ogg"] = 56.94,
					["NagrandDay.ogg"] = 61.00,
					["NagrandNight.ogg"] = 61.00,
					["NetherStorm1.ogg"] = 144.00,
					["NewHearthglen.ogg"] = 130.00,
					["NortherndCoastGenericDayNight.ogg"] = 82.30,
					["NorthrendScourgeGeneral.ogg"] = 96.17,
					["PlagueLandsDay.ogg"] = 60.00,
					["PlagueLandsNight.ogg"] = 60.00,
					["PlainsDesertDay.ogg"] = 56.94,
					["PlainsDesertNight.ogg"] = 56.84,
					["RubySanctumNightDay.ogg"] = 85.06,
					["SaltFlatsDay.ogg"] = 56.94,
					["SaltFlatsNight.ogg"] = 56.94,
					["ScorchLineDay.ogg"] = 60.00,
					["ScorchLineNight.ogg"] = 60.00,
					["ShadowFang.ogg"] = 59.63,
					["ShadowMoonValley1.ogg"] = 92.00,
					["ShalandisIsle.ogg"] = 60.00,
					["Shattrath.ogg"] = 113.72,
					["SholazarBasinDay.ogg"] = 70.00,
					["SholazarBasinNight.ogg"] = 70.00,
					["SilvermoonRuinsDay.ogg"] = 65.00,
					["SilvermoonRuinsNight.ogg"] = 60.00,
					["StoneWroughtDam2.ogg"] = 11.70,
					["StormPeaksDayNight.ogg"] = 114.00,
					["TerokkarDay.ogg"] = 60.00,
					["TerokkarNight.ogg"] = 60.00,
					["TheEyeofEternity.ogg"] = 25.66,
					["ThePitofSaron.ogg"] = 143.59,
					["TheVibrantGlade.ogg"] = 60.00,
					["ValianceKeep.ogg"] = 103.12,
					["VolcanicDay.ogg"] = 56.94,
					["VolcanicNight.ogg"] = 56.94,
					["WailingCaverns.ogg"] = 56.84,
					["WestfallDay.ogg"] = 60.00,
					["WestfallNight.ogg"] = 30.00,
					["WetlandsDay.ogg"] = 60.00,
					["WetlandsNight.ogg"] = 60.00,
					["WhisperGulchDayNight.ogg"] = 58.66,
					["ZangarMarsh1.ogg"] = 104.00,
					["ZangarMarsh2.ogg"] = 104.00,
					["ZangarMarsh3.ogg"] = 98.00,
					["ZulDrakGeneralDay.ogg"] = 99.29,
					["ZulDrakGeneralNight.ogg"] = 117.50,
					["IsleOfConquest_DayNight.ogg"] = 113.84,
					["UlduarRaid_FreyaZone.ogg"] = 65.44,
				},
			},
			["character\\"] = {
				["BloodElf\\"] = {
					["BloodElfFemale_Err_"] = {
						["2h_"] = {
							["Equipped.ogg"] = 01.64,
							["SkillNotFound01.ogg"] = 01.53,
							["SkillNotFound02.ogg"] = 01.63,
						},
						["AbilityCooldown01.ogg"] = 01.79,
						["AbilityCooldown02.ogg"] = 01.36,
						["AbilityCooldown03.ogg"] = 00.87,
						["AlreadyInGroup01.ogg"] = 01.68,
						["AmmoOnly01.ogg"] = 01.18,
						["BagFull01.ogg"] = 01.07,
						["CantCreateHere01.ogg"] = 01.23,
						["CantDropSoulboundItem01.ogg"] = 01.26,
						["CantDropSoulboundItem02.ogg"] = 01.11,
						["CantEquipEver01.ogg"] = 01.85,
						["CantEquipLevel01.ogg"] = 02.06,
						["CantEquipLevel02.ogg"] = 01.40,
						["CantEquipSkill01.ogg"] = 02.54,
						["CantLearnSpell01.ogg"] = 01.49,
						["CantTradeSoulboundItem01.ogg"] = 01.30,
						["CantUseItem01.ogg"] = 01.21,
						["ChestInUse01.ogg"] = 01.71,
						["GenericNoTarget01.ogg"] = 01.09,
						["GenericNoTarget02.ogg"] = 01.97,
						["GenericNoTarget03.ogg"] = 00.96,
						["GuildPermissions01.ogg"] = 01.04,
						["GuildPermissions02.ogg"] = 01.54,
						["InvalidAttackTarget01.ogg"] = 01.64,
						["InvalidAttackTarget02.ogg"] = 01.23,
						["InventoryFull01.ogg"] = 01.27,
						["InventoryFull02.ogg"] = 01.58,
						["ItemCooldown01.ogg"] = 01.43,
						["ItemCooldown02.ogg"] = 01.23,
						["ItemCooldown03.ogg"] = 01.32,
						["ItemLocked01.ogg"] = 00.75,
						["ItemMaxCount01.ogg"] = 01.96,
						["LootDidntKill01.ogg"] = 01.10,
						["LootDidntKill02.ogg"] = 01.02,
						["LootTooFar01.ogg"] = 01.50,
						["LootTooFar02.ogg"] = 00.75,
						["LootTooFar03.ogg"] = 01.21,
						["MustEquipItem01.ogg"] = 01.74,
						["MustEquipItem02.ogg"] = 01.28,
						["NoAmmo01.ogg"] = 01.06,
						["NoEnergy01.ogg"] = 01.25,
						["NoEnergy02.ogg"] = 01.33,
						["NoMana01.ogg"] = 01.05,
						["NoMana02.ogg"] = 00.96,
						["NoMana03.ogg"] = 01.03,
						["NoRage01.ogg"] = 01.12,
						["NoRage02.ogg"] = 01.09,
						["NotABag01.ogg"] = 01.02,
						["NotEnoughMoney01.ogg"] = 01.03,
						["NotEnoughMoney02.ogg"] = 01.16,
						["NotEnoughMoney03.ogg"] = 01.24,
						["NotEquippable01.ogg"] = 01.26,
						["OutOfRange01.ogg"] = 01.34,
						["OutOfRange02.ogg"] = 01.13,
						["OutOfRange03.ogg"] = 00.98,
						["PartyFull01.ogg"] = 01.40,
						["PotionCooldown01.ogg"] = 01.17,
						["SpellCooldown01.ogg"] = 01.59,
						["SpellCooldown02.ogg"] = 01.38,
						["SpellCooldown03.ogg"] = 01.21,
					},
					["BloodElfMale_Err_"] = {
						["2h_"] = {
							["Equipped01.ogg"] = 01.84,
							["SkillNotFound01.ogg"] = 01.32,
							["SkillNotFound02.ogg"] = 02.12,
						},
						["AbilityCooldown01.ogg"] = 01.80,
						["AbilityCooldown02.ogg"] = 01.31,
						["AbilityCooldown03.ogg"] = 01.04,
						["AlreadyInGroup01.ogg"] = 01.53,
						["AmmoOnly01.ogg"] = 01.43,
						["BagFull01.ogg"] = 01.85,
						["CantCreateHere01.ogg"] = 01.26,
						["CantDropSoulboundItem01.ogg"] = 01.53,
						["CantDropSoulboundItem02.ogg"] = 01.42,
						["CantEquipEver01.ogg"] = 02.49,
						["CantEquipLevel01.ogg"] = 02.73,
						["CantEquipLevel02.ogg"] = 01.47,
						["CantEquipSkill01.ogg"] = 02.84,
						["CantLearnSpell01.ogg"] = 02.07,
						["CantTradeSoulboundItem01.ogg"] = 01.38,
						["CantUseItem01.ogg"] = 01.28,
						["ChestInUse01.ogg"] = 01.86,
						["GenericNoTarget01.ogg"] = 01.68,
						["GenericNoTarget02.ogg"] = 02.38,
						["GenericNoTarget03.ogg"] = 01.01,
						["GuildPermissions01.ogg"] = 01.45,
						["GuildPermissions02.ogg"] = 01.66,
						["InvalidAttackTarget01.ogg"] = 01.93,
						["InvalidAttackTarget02.ogg"] = 01.80,
						["InventoryFull01.ogg"] = 01.20,
						["InventoryFull02.ogg"] = 01.26,
						["ItemCooldown01.ogg"] = 01.95,
						["ItemCooldown02.ogg"] = 01.64,
						["ItemCooldown03.ogg"] = 01.46,
						["ItemLocked01.ogg"] = 00.87,
						["ItemMaxCount01.ogg"] = 01.89,
						["LootDidntKill01.ogg"] = 01.20,
						["LootDidntKill02.ogg"] = 01.76,
						["LootTooFar01.ogg"] = 01.53,
						["LootTooFar02.ogg"] = 01.03,
						["LootTooFar03.ogg"] = 01.01,
						["MustEquipItem01.ogg"] = 01.83,
						["MustEquipItem02.ogg"] = 01.30,
						["NoAmmo01.ogg"] = 00.88,
						["NoEnergy01.ogg"] = 01.16,
						["NoEnergy02.ogg"] = 01.68,
						["NoMana01.ogg"] = 01.16,
						["NoMana02.ogg"] = 01.11,
						["NoMana03.ogg"] = 01.11,
						["NoRage01.ogg"] = 01.60,
						["NoRage02.ogg"] = 01.33,
						["NotABag01.ogg"] = 01.27,
						["NotEnoughMoney01.ogg"] = 01.43,
						["NotEnoughMoney02.ogg"] = 01.17,
						["NotEnoughMoney03.ogg"] = 02.36,
						["NotEquippable01.ogg"] = 01.08,
						["OutOfRange01.ogg"] = 01.41,
						["OutOfRange02.ogg"] = 01.16,
						["OutOfRange03.ogg"] = 01.29,
						["PartyFull01.ogg"] = 01.75,
						["PotionCooldown01.ogg"] = 01.79,
						["SpellCooldown01.ogg"] = 01.77,
						["SpellCooldown02.ogg"] = 01.86,
						["SpellCooldown03.ogg"] = 01.25,
					},
					["BloodElfFemaleAttackMyTarget01.ogg"] = 01.31,
					["BloodElfFemaleAttackMyTarget02.ogg"] = 01.41,
					["BloodElfFemaleAttackMyTarget03.ogg"] = 01.51,
					["BloodElfFemaleBeg01.ogg"] = 04.07,
					["BloodElfFemaleCharge01.ogg"] = 02.55,
					["BloodElfFemaleCharge02.ogg"] = 02.29,
					["BloodElfFemaleCharge03.ogg"] = 02.40,
					["BloodElfFemaleCharge04.ogg"] = 02.79,
					["BloodElfFemaleCheer01.ogg"] = 01.46,
					["BloodElfFemaleCheer02.ogg"] = 00.90,
					["BloodElfFemaleChicken01.ogg"] = 03.66,
					["BloodElfFemaleCongratulations01.ogg"] = 01.35,
					["BloodElfFemaleCongratulations02.ogg"] = 01.18,
					["BloodElfFemaleCongratulations03.ogg"] = 01.13,
					["BloodElfFemaleCry01.ogg"] = 03.74,
					["BloodElfFemaleFlee01.ogg"] = 01.32,
					["BloodElfFemaleFlee02.ogg"] = 01.52,
					["BloodElfFemaleFlee03.ogg"] = 00.94,
					["BloodElfFemaleFlirt01.ogg"] = 04.38,
					["BloodElfFemaleFlirt02.ogg"] = 02.39,
					["BloodElfFemaleFlirt04.ogg"] = 04.61,
					["BloodElfFemaleFlirt05.ogg"] = 03.22,
					["BloodElfFemaleFlirt10.ogg"] = 02.60,
					["BloodElfFemaleFlirt11.ogg"] = 03.55,
					["BloodElfFemaleFlirt13.ogg"] = 04.30,
					["BloodElfFemaleFollowMe01.ogg"] = 00.89,
					["BloodElfFemaleFollowMe02.ogg"] = 00.58,
					["BloodElfFemaleFollowMe03.ogg"] = 01.24,
					["BloodElfFemaleGoodbye01.ogg"] = 00.63,
					["BloodElfFemaleGoodbye02.ogg"] = 01.27,
					["BloodElfFemaleGoodbye03.ogg"] = 04.07,
					["BloodElfFemaleGoodbye04.ogg"] = 01.50,
					["BloodElfFemaleHealMe01.ogg"] = 00.81,
					["BloodElfFemaleHealMe02.ogg"] = 00.55,
					["BloodElfFemaleHello01.ogg"] = 01.52,
					["BloodElfFemaleHello03.ogg"] = 02.37,
					["BloodElfFemaleHello04.ogg"] = 01.40,
					["BloodElfFemaleHelp01.ogg"] = 00.98,
					["BloodElfFemaleHelp02.ogg"] = 01.14,
					["BloodElfFemaleIncoming01.ogg"] = 00.63,
					["BloodElfFemaleKiss01.ogg"] = 00.18,
					["BloodElfFemaleLaugh01.ogg"] = 04.75,
					["BloodElfFemaleNo01.ogg"] = 01.31,
					["BloodElfFemaleNo02.ogg"] = 00.76,
					["BloodElfFemaleNo03.ogg"] = 00.62,
					["BloodElfFemaleNod01.ogg"] = 00.25,
					["BloodElfFemaleNod02.ogg"] = 00.23,
					["BloodElfFemaleNod03.ogg"] = 00.49,
					["BloodElfFemaleOpenFire01.ogg"] = 00.76,
					["BloodElfFemaleOpenFire02.ogg"] = 01.17,
					["BloodElfFemaleOutOfMana01.ogg"] = 01.27,
					["BloodElfFemaleOutOfMana02.ogg"] = 01.75,
					["BloodElfFemalePissed07.ogg"] = 09.70,
					["BloodElfFemalePissed08.ogg"] = 20.10,
					["BloodElfFemalePissed09.ogg"] = 03.98,
					["BloodElfFemalePissed10.ogg"] = 04.21,
					["BloodElfFemalePissed11.ogg"] = 02.58,
					["BloodElfFemalePissed14.ogg"] = 01.85,
					["BloodElfFemalePissed16.ogg"] = 02.37,
					["BloodElfFemaleRaspberry01.ogg"] = 00.73,
					["BloodElfFemaleRoar01.ogg"] = 03.49,
					["BloodElfFemaleSigh01.ogg"] = 01.13,
					["BloodElfFemaleThankYou01.ogg"] = 01.00,
					["BloodElfFemaleThankYou02.ogg"] = 01.87,
					["BloodElfFemaleThankYou03.ogg"] = 00.98,
					["BloodElfFemaleTrain01.ogg"] = 02.32,
					["BloodElfFemaleWaitHere01.ogg"] = 00.68,
					["BloodElfFemaleWaitHere02.ogg"] = 00.78,
					["BloodElfFemaleYawn01.ogg"] = 01.32,
					["BloodElfFemaleYes01.ogg"] = 00.53,
					["BloodElfFemaleYes02.ogg"] = 00.71,
					["BloodElfFemaleYes03.ogg"] = 00.40,
					["BloodElfFemaleYoureWelcome01.ogg"] = 00.74,
					["BloodElfFemaleYoureWelcome02.ogg"] = 01.76,
					["BloodElfFemaleYoureWelcome03.ogg"] = 01.10,
					["BloodElfMaleAttackMyTarget01.ogg"] = 01.61,
					["BloodElfMaleAttackMyTarget02.ogg"] = 01.38,
					["BloodElfMaleAttackMyTarget03.ogg"] = 01.38,
					["BloodElfMaleBeg01.ogg"] = 03.11,
					["BloodElfMaleCharge01.ogg"] = 02.74,
					["BloodElfMaleCharge02.ogg"] = 02.25,
					["BloodElfMaleCharge03.ogg"] = 02.42,
					["BloodElfMaleCharge04.ogg"] = 02.72,
					["BloodElfMaleCharge05.ogg"] = 02.74,
					["BloodElfMaleCheer01.ogg"] = 02.34,
					["BloodElfMaleCheer02.ogg"] = 00.71,
					["BloodElfMaleChicken01.ogg"] = 03.57,
					["BloodElfMaleCongratulations01.ogg"] = 01.51,
					["BloodElfMaleCongratulations02.ogg"] = 01.41,
					["BloodElfMaleCongratulations03.ogg"] = 01.55,
					["BloodElfMaleCry01.ogg"] = 04.40,
					["BloodElfMaleFlee01.ogg"] = 01.16,
					["BloodElfMaleFlee02.ogg"] = 01.59,
					["BloodElfMaleFlee03.ogg"] = 01.63,
					["BloodElfMaleFlirt02.ogg"] = 06.48,
					["BloodElfMaleFlirt05.ogg"] = 02.22,
					["BloodElfMaleFlirt06.ogg"] = 03.94,
					["BloodElfMaleFlirt09.ogg"] = 08.26,
					["BloodElfMaleFlirt10.ogg"] = 09.96,
					["BloodElfMaleFlirt15.ogg"] = 07.28,
					["BloodElfMaleFollowMe01.ogg"] = 00.87,
					["BloodElfMaleFollowMe02.ogg"] = 01.25,
					["BloodElfMaleFollowMe03.ogg"] = 01.31,
					["BloodElfMaleGoodbye01.ogg"] = 00.86,
					["BloodElfMaleGoodbye02.ogg"] = 01.32,
					["BloodElfMaleGoodbye03.ogg"] = 03.22,
					["BloodElfMaleGoodbye04.ogg"] = 01.21,
					["BloodElfMaleHealMe01.ogg"] = 00.61,
					["BloodElfMaleHealMe02.ogg"] = 00.50,
					["BloodElfMaleHello01.ogg"] = 02.03,
					["BloodElfMaleHello02.ogg"] = 01.85,
					["BloodElfMaleHello03.ogg"] = 02.61,
					["BloodElfMaleHello04.ogg"] = 01.38,
					["BloodElfMaleHelp01.ogg"] = 00.58,
					["BloodElfMaleHelp02.ogg"] = 00.98,
					["BloodElfMaleIncoming01.ogg"] = 01.04,
					["BloodElfMaleKiss01.ogg"] = 00.19,
					["BloodElfMaleLaugh01.ogg"] = 05.33,
					["BloodElfMaleNo01.ogg"] = 01.02,
					["BloodElfMaleNo02.ogg"] = 01.02,
					["BloodElfMaleNo03.ogg"] = 00.67,
					["BloodElfMaleNod01.ogg"] = 00.98,
					["BloodElfMaleNod02.ogg"] = 00.80,
					["BloodElfMaleNod03.ogg"] = 00.57,
					["BloodElfMaleOpenFire01.ogg"] = 00.63,
					["BloodElfMaleOpenFire02.ogg"] = 01.78,
					["BloodElfMaleOutOfMana01.ogg"] = 01.42,
					["BloodElfMaleOutOfMana02.ogg"] = 01.81,
					["BloodElfMalePissed01.ogg"] = 12.84,
					["BloodElfMalePissed02.ogg"] = 05.99,
					["BloodElfMalePissed04.ogg"] = 04.09,
					["BloodElfMalePissed09.ogg"] = 06.25,
					["BloodElfMalePissed12.ogg"] = 03.80,
					["BloodElfMalePissed14.ogg"] = 04.33,
					["BloodElfMalePissed17.ogg"] = 16.30,
					["BloodElfMaleRaspberry01.ogg"] = 01.39,
					["BloodElfMaleRoar01.ogg"] = 02.48,
					["BloodElfMaleSigh01.ogg"] = 01.26,
					["BloodElfMaleThankYou01.ogg"] = 00.97,
					["BloodElfMaleThankYou02.ogg"] = 01.21,
					["BloodElfMaleThankYou03.ogg"] = 01.78,
					["BloodElfMaleTrain01.ogg"] = 03.02,
					["BloodElfMaleWaitHere01.ogg"] = 00.47,
					["BloodElfMaleWaitHere02.ogg"] = 00.67,
					["BloodElfMaleYawn01.ogg"] = 02.89,
					["BloodElfMaleYes01.ogg"] = 00.52,
					["BloodElfMaleYes02.ogg"] = 00.84,
					["BloodElfMaleYes03.ogg"] = 00.66,
					["BloodElfMaleYoureWelcome01.ogg"] = 01.24,
					["BloodElfMaleYoureWelcome02.ogg"] = 01.86,
					["BloodElfMaleYoureWelcome03.ogg"] = 01.18,
				},
				["BloodElfFemalePC\\"] = {
					["VO_PCBloodElfFemale_"] = {
						["Death_"] = {
							["01.OGG"] = 01.73,
							["02.OGG"] = 01.43,
							["03.OGG"] = 01.46,
							["04.OGG"] = 01.48,
							["05.OGG"] = 01.61,
							["06.OGG"] = 02.02,
							["07.OGG"] = 01.80,
							["08.OGG"] = 02.63,
							["09.OGG"] = 01.65,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.73,
							["02.OGG"] = 01.18,
							["04.OGG"] = 00.75,
							["07.OGG"] = 00.37,
						},
						["Wound_"] = {
							["01.OGG"] = 00.57,
							["02.OGG"] = 00.53,
							["03.OGG"] = 00.30,
						},
					},
					["BloodElfFemalePCAttackA.ogg"] = 00.83,
					["BloodElfFemalePCAttackB.ogg"] = 00.80,
					["BloodElfFemalePCAttackC.ogg"] = 01.04,
					["BloodElfFemalePCAttackD.ogg"] = 00.69,
					["BloodElfFemalePCAttackE.ogg"] = 00.76,
					["BloodElfFemalePCCritA.ogg"] = 00.83,
					["BloodElfFemalePCCritB.ogg"] = 00.66,
					["BloodElfFemalePCCritC.ogg"] = 01.02,
					["BloodElfFemalePCDeath.ogg"] = 02.09,
					["BloodElfFemalePCPreAggroA.ogg"] = 01.19,
					["BloodElfFemalePCPreAggroB.ogg"] = 01.28,
					["BloodElfFemalePCWound.ogg"] = 00.27,
					["BloodElfFemalePCWoundA.ogg"] = 00.71,
					["BloodElfFemalePCWoundB.ogg"] = 00.80,
					["BloodElfFemalePCWoundD.ogg"] = 00.60,
					["BloodElfFemalePCWoundE.ogg"] = 00.30,
					["BloodElfFemalePCWoundF.ogg"] = 00.30,
					["BloodElfFemalePCWoundG.ogg"] = 00.59,
				},
				["BloodElfMalePC\\"] = {
					["VO_PCBloodElfMale_"] = {
						["Death_"] = {
							["01.OGG"] = 02.25,
							["02.OGG"] = 01.63,
							["03.OGG"] = 01.99,
							["04.OGG"] = 02.41,
							["05.OGG"] = 02.57,
							["06.OGG"] = 03.07,
							["07.OGG"] = 02.56,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.92,
							["02.OGG"] = 01.12,
							["03.OGG"] = 01.18,
							["05.OGG"] = 00.71,
						},
						["Wound_"] = {
							["01.OGG"] = 00.83,
							["02.OGG"] = 00.57,
						},
					},
					["BloodElfMalePCAttackA.ogg"] = 00.51,
					["BloodElfMalePCAttackB.ogg"] = 00.53,
					["BloodElfMalePCAttackC.ogg"] = 00.48,
					["BloodElfMalePCAttackD.ogg"] = 00.56,
					["BloodElfMalePCAttackE.ogg"] = 00.41,
					["BloodElfMalePCAttackF.ogg"] = 00.71,
					["BloodElfMalePCAttackG.ogg"] = 01.33,
					["BloodElfMalePCAttackH.ogg"] = 01.18,
					["BloodElfMalePCAttackI.ogg"] = 00.97,
					["BloodElfMalePCDeath.ogg"] = 02.88,
					["BloodElfMalePCDeath2.ogg"] = 02.66,
					["BloodElfMalePCWoundA.ogg"] = 00.45,
					["BloodElfMalePCWoundB.ogg"] = 00.39,
					["BloodElfMalePCWoundC.ogg"] = 00.49,
					["BloodElfMalePCWoundCritA.ogg"] = 00.82,
					["BloodElfMalePCWoundCritB.ogg"] = 00.67,
					["BloodElfMalePCWoundCritC.ogg"] = 00.90,
					["BloodElfMalePCWoundD.ogg"] = 00.66,
					["BloodElfMalePCWoundE.ogg"] = 00.70,
					["BloodElfMalePCWoundF.ogg"] = 00.66,
					["BloodElfMalePCWoundG.ogg"] = 00.83,
					["BloodElfMalePCWoundH.ogg"] = 00.59,
				},
				["Draenei\\"] = {
					["DraeneiFemale_Err_"] = {
						["2h_"] = {
							["Equipped01.ogg"] = 01.46,
							["SkillNotFound01.ogg"] = 01.33,
							["SkillNotFound02.ogg"] = 01.64,
						},
						["AbilityCooldown01.ogg"] = 01.96,
						["AbilityCooldown02.ogg"] = 01.12,
						["AbilityCooldown03.ogg"] = 01.07,
						["AlreadyInGroup01.ogg"] = 01.35,
						["AmmoOnly01.ogg"] = 01.11,
						["BagFull01.ogg"] = 01.13,
						["CantCreateHere01.ogg"] = 01.12,
						["CantDropSoulboundItem01.ogg"] = 01.08,
						["CantDropSoulboundItem02.ogg"] = 01.11,
						["CantEquipEver01.ogg"] = 01.86,
						["CantEquipLevel01.ogg"] = 01.91,
						["CantEquipLevel02.ogg"] = 01.17,
						["CantEquipSkill01.ogg"] = 02.74,
						["CantLearnSpell01.ogg"] = 01.33,
						["CantTradeSoulboundItem01.ogg"] = 01.09,
						["CantUseItem01.ogg"] = 01.14,
						["ChestInUse01.ogg"] = 01.28,
						["GenericNoTarget01.ogg"] = 01.31,
						["GenericNoTarget02.ogg"] = 02.04,
						["GenericNoTarget03.ogg"] = 01.37,
						["GuildPermissions01.ogg"] = 00.86,
						["GuildPermissions02.ogg"] = 01.74,
						["InvalidAttackTarget01.ogg"] = 01.60,
						["InvalidAttackTarget02.ogg"] = 01.10,
						["InventoryFull01.ogg"] = 01.32,
						["InventoryFull02.ogg"] = 01.66,
						["ItemCooldown01.ogg"] = 01.53,
						["ItemCooldown02.ogg"] = 01.19,
						["ItemCooldown03.ogg"] = 01.27,
						["ItemLocked01.ogg"] = 00.64,
						["ItemMaxCount01.ogg"] = 01.76,
						["LootDidntKill01.ogg"] = 01.06,
						["LootDidntKill02.ogg"] = 01.16,
						["LootTooFar01.ogg"] = 01.26,
						["LootTooFar02.ogg"] = 00.87,
						["LootTooFar03.ogg"] = 01.13,
						["MustEquipItem01.ogg"] = 01.67,
						["MustEquipItem02.ogg"] = 01.24,
						["NoAmmo01.ogg"] = 00.88,
						["NoEnergy01.ogg"] = 01.04,
						["NoEnergy02.ogg"] = 01.41,
						["NoMana01.ogg"] = 01.01,
						["NoMana02.ogg"] = 01.16,
						["NoMana03.ogg"] = 01.04,
						["NoRage01.ogg"] = 01.14,
						["NoRage02.ogg"] = 01.51,
						["NotABag01.ogg"] = 00.95,
						["NotEnoughMoney01.ogg"] = 01.16,
						["NotEnoughMoney02.ogg"] = 00.99,
						["NotEnoughMoney03.ogg"] = 01.21,
						["NotEquippable01.ogg"] = 01.06,
						["OutOfRange01.ogg"] = 01.15,
						["OutOfRange02.ogg"] = 00.97,
						["OutOfRange03.ogg"] = 01.18,
						["PartyFull01.ogg"] = 01.56,
						["PotionCooldown01.ogg"] = 01.57,
						["SpellCooldown01.ogg"] = 01.54,
						["SpellCooldown02.ogg"] = 01.43,
						["SpellCooldown03.ogg"] = 01.42,
					},
					["DraeneiMale_Err_"] = {
						["2h_"] = {
							["Equipped01.ogg"] = 01.77,
							["SkillNotFound01.ogg"] = 01.43,
							["SkillNotFound02.ogg"] = 01.71,
						},
						["AbilityCooldown01.ogg"] = 01.83,
						["AbilityCooldown02.ogg"] = 01.30,
						["AbilityCooldown03.ogg"] = 01.20,
						["AlreadyInGroup01.ogg"] = 02.42,
						["AmmoOnly01.ogg"] = 01.66,
						["BagFull01.ogg"] = 01.41,
						["CantCreateHere01.ogg"] = 01.20,
						["CantDropSoulboundItem01.ogg"] = 01.24,
						["CantDropSoulboundItem02.ogg"] = 01.29,
						["CantEquipEver01.ogg"] = 02.24,
						["CantEquipLevel01.ogg"] = 02.08,
						["CantEquipLevel02.ogg"] = 01.42,
						["CantEquipSkill01.ogg"] = 02.51,
						["CantLearnSpell01.ogg"] = 01.66,
						["CantTradeSoulboundItem01.ogg"] = 01.06,
						["CantUseItem01.ogg"] = 01.04,
						["ChestInUse01.ogg"] = 01.85,
						["GenericNoTarget01.ogg"] = 01.28,
						["GenericNoTarget02.ogg"] = 01.71,
						["GenericNoTarget03.ogg"] = 01.18,
						["GuildPermissions01.ogg"] = 00.96,
						["GuildPermissions02.ogg"] = 01.62,
						["InvalidAttackTarget01.ogg"] = 01.68,
						["InvalidAttackTarget02.ogg"] = 01.10,
						["InventoryFull01.ogg"] = 01.40,
						["InventoryFull02.ogg"] = 02.20,
						["ItemCooldown01.ogg"] = 02.14,
						["ItemCooldown02.ogg"] = 00.98,
						["ItemCooldown03.ogg"] = 01.15,
						["ItemLocked01.ogg"] = 00.80,
						["ItemMaxCount01.ogg"] = 01.71,
						["LootDidntKill01.ogg"] = 01.20,
						["LootDidntKill02.ogg"] = 01.94,
						["LootTooFar01.ogg"] = 01.97,
						["LootTooFar02.ogg"] = 01.51,
						["LootTooFar03.ogg"] = 01.26,
						["MustEquipItem01.ogg"] = 01.87,
						["MustEquipItem02.ogg"] = 01.32,
						["NoAmmo01.ogg"] = 01.00,
						["NoEnergy01.ogg"] = 01.79,
						["NoEnergy02.ogg"] = 01.41,
						["NoMana01.ogg"] = 01.38,
						["NoMana02.ogg"] = 01.83,
						["NoMana03.ogg"] = 01.33,
						["NoRage01.ogg"] = 01.46,
						["NoRage02.ogg"] = 01.80,
						["NotABag01.ogg"] = 01.79,
						["NotEnoughMoney01.ogg"] = 01.42,
						["NotEnoughMoney02.ogg"] = 00.93,
						["NotEnoughMoney03.ogg"] = 01.67,
						["NotEquippable01.ogg"] = 01.35,
						["OutOfRange01.ogg"] = 01.05,
						["OutOfRange02.ogg"] = 01.16,
						["OutOfRange03.ogg"] = 01.49,
						["PartyFull01.ogg"] = 01.79,
						["PotionCooldown01.ogg"] = 01.84,
						["SpellCooldown01.ogg"] = 02.23,
						["SpellCooldown02.ogg"] = 01.45,
						["SpellCooldown03.ogg"] = 01.37,
					},
					["DraeneiFemaleAttackMyTarget01.ogg"] = 01.24,
					["DraeneiFemaleAttackMyTarget02.ogg"] = 01.03,
					["DraeneiFemaleAttackMyTarget03.ogg"] = 00.88,
					["DraeneiFemaleBeg01.ogg"] = 02.45,
					["DraeneiFemaleCharge01.ogg"] = 02.18,
					["DraeneiFemaleCharge02.ogg"] = 03.00,
					["DraeneiFemaleCharge03.ogg"] = 02.00,
					["DraeneiFemaleCheer01.ogg"] = 02.43,
					["DraeneiFemaleCheer02.ogg"] = 00.73,
					["DraeneiFemaleChicken01.ogg"] = 03.55,
					["DraeneiFemaleCongratulations01.ogg"] = 01.39,
					["DraeneiFemaleCongratulations02.ogg"] = 01.49,
					["DraeneiFemaleCongratulations03.ogg"] = 00.92,
					["DraeneiFemaleCry01.ogg"] = 06.17,
					["DraeneiFemaleFlee01.ogg"] = 00.80,
					["DraeneiFemaleFlee02.ogg"] = 00.73,
					["DraeneiFemaleFlee03.ogg"] = 01.37,
					["DraeneiFemaleFlirt01.ogg"] = 04.83,
					["DraeneiFemaleFlirt02.ogg"] = 03.88,
					["DraeneiFemaleFlirt07.ogg"] = 03.30,
					["DraeneiFemaleFlirt08.ogg"] = 08.73,
					["DraeneiFemaleFlirt10.ogg"] = 13.75,
					["DraeneiFemaleFollowMe01.ogg"] = 00.64,
					["DraeneiFemaleFollowMe02.ogg"] = 01.18,
					["DraeneiFemaleFollowMe03.ogg"] = 01.35,
					["DraeneiFemaleGoodbye01.ogg"] = 01.03,
					["DraeneiFemaleGoodbye02.ogg"] = 01.76,
					["DraeneiFemaleGoodbye03.ogg"] = 02.13,
					["DraeneiFemaleGoodbye04.ogg"] = 01.32,
					["DraeneiFemaleHealMe01.ogg"] = 00.80,
					["DraeneiFemaleHealMe02.ogg"] = 01.04,
					["DraeneiFemaleHello01.ogg"] = 01.25,
					["DraeneiFemaleHello02.ogg"] = 01.71,
					["DraeneiFemaleHello03.ogg"] = 01.68,
					["DraeneiFemaleHello04.ogg"] = 02.59,
					["DraeneiFemaleHello05.ogg"] = 00.95,
					["DraeneiFemaleHelp01.ogg"] = 00.90,
					["DraeneiFemaleHelp02.ogg"] = 01.40,
					["DraeneiFemaleIncoming01.ogg"] = 01.05,
					["DraeneiFemaleKiss01.ogg"] = 00.48,
					["DraeneiFemaleLaugh01.ogg"] = 04.08,
					["DraeneiFemaleNo01.ogg"] = 00.38,
					["DraeneiFemaleNo02.ogg"] = 00.89,
					["DraeneiFemaleNo03.ogg"] = 00.51,
					["DraeneiFemaleNod01.ogg"] = 01.08,
					["DraeneiFemaleNod02.ogg"] = 00.90,
					["DraeneiFemaleNod03.ogg"] = 00.66,
					["DraeneiFemaleOpenFire01.ogg"] = 00.87,
					["DraeneiFemaleOpenFire02.ogg"] = 01.27,
					["DraeneiFemaleOutOfMana01.ogg"] = 01.33,
					["DraeneiFemaleOutOfMana02.ogg"] = 01.48,
					["DraeneiFemalePissed01.ogg"] = 05.19,
					["DraeneiFemalePissed02.ogg"] = 06.44,
					["DraeneiFemalePissed03.ogg"] = 06.34,
					["DraeneiFemalePissed07.ogg"] = 12.95,
					["DraeneiFemalePissed09.ogg"] = 03.45,
					["DraeneiFemalePissed10.ogg"] = 06.09,
					["DraeneiFemalePissed11.ogg"] = 03.32,
					["DraeneiFemalePissed13.ogg"] = 04.21,
					["DraeneiFemaleRaspberry01.ogg"] = 01.01,
					["DraeneiFemaleRoar01.ogg"] = 02.81,
					["DraeneiFemaleSigh01.ogg"] = 01.05,
					["DraeneiFemaleThankYou01.ogg"] = 01.14,
					["DraeneiFemaleThankYou02.ogg"] = 01.09,
					["DraeneiFemaleThankYou03.ogg"] = 01.85,
					["DraeneiFemaleTrain01.ogg"] = 03.85,
					["DraeneiFemaleWaitHere01.ogg"] = 00.68,
					["DraeneiFemaleWaitHere02.ogg"] = 01.01,
					["DraeneiFemaleYawn01.ogg"] = 01.95,
					["DraeneiFemaleYes01.ogg"] = 00.72,
					["DraeneiFemaleYes02.ogg"] = 00.72,
					["DraeneiFemaleYes03.ogg"] = 01.03,
					["DraeneiFemaleYoureWelcome01.ogg"] = 01.27,
					["DraeneiFemaleYoureWelcome02.ogg"] = 00.63,
					["DraeneiFemaleYoureWelcome03.ogg"] = 00.79,
					["DraeneiMaleAttackMyTarget01.ogg"] = 00.77,
					["DraeneiMaleAttackMyTarget02.ogg"] = 01.48,
					["DraeneiMaleAttackMyTarget03.ogg"] = 01.02,
					["DraeneiMaleBeg01.ogg"] = 02.74,
					["DraeneiMaleCharge01.ogg"] = 02.08,
					["DraeneiMaleCharge02.ogg"] = 03.13,
					["DraeneiMaleCharge03.ogg"] = 04.74,
					["DraeneiMaleCharge04.ogg"] = 05.03,
					["DraeneiMaleCheer01.ogg"] = 01.76,
					["DraeneiMaleCheer02.ogg"] = 01.67,
					["DraeneiMaleChicken01.ogg"] = 03.09,
					["DraeneiMaleCongratulations01.ogg"] = 01.53,
					["DraeneiMaleCongratulations02.ogg"] = 01.33,
					["DraeneiMaleCongratulations03.ogg"] = 02.12,
					["DraeneiMaleCry01.ogg"] = 03.88,
					["DraeneiMaleFlee01.ogg"] = 00.74,
					["DraeneiMaleFlee02.ogg"] = 00.55,
					["DraeneiMaleFlee03.ogg"] = 01.24,
					["DraeneiMaleFlirt01.ogg"] = 07.35,
					["DraeneiMaleFlirt03.ogg"] = 09.34,
					["DraeneiMaleFlirt04.ogg"] = 08.39,
					["DraeneiMaleFlirt05.ogg"] = 05.76,
					["DraeneiMaleFlirt07.ogg"] = 06.09,
					["DraeneiMaleFollowMe01.ogg"] = 01.43,
					["DraeneiMaleFollowMe02.ogg"] = 01.29,
					["DraeneiMaleFollowMe03.ogg"] = 01.29,
					["DraeneiMaleGoodbye01.ogg"] = 01.39,
					["DraeneiMaleGoodbye02.ogg"] = 02.27,
					["DraeneiMaleGoodbye03.ogg"] = 01.89,
					["DraeneiMaleGoodbye04.ogg"] = 02.50,
					["DraeneiMaleHealMe01.ogg"] = 00.87,
					["DraeneiMaleHealMe02.ogg"] = 01.24,
					["DraeneiMaleHello01.ogg"] = 02.01,
					["DraeneiMaleHello02.ogg"] = 01.97,
					["DraeneiMaleHello03.ogg"] = 01.88,
					["DraeneiMaleHello04.ogg"] = 01.74,
					["DraeneiMaleHello05.ogg"] = 01.15,
					["DraeneiMaleHelp01.ogg"] = 01.36,
					["DraeneiMaleHelp02.ogg"] = 00.58,
					["DraeneiMaleIncoming01.ogg"] = 00.93,
					["DraeneiMaleKiss01.ogg"] = 00.87,
					["DraeneiMaleLaugh01.ogg"] = 03.05,
					["DraeneiMaleNo01.ogg"] = 00.55,
					["DraeneiMaleNo02.ogg"] = 01.10,
					["DraeneiMaleNo03.ogg"] = 01.07,
					["DraeneiMaleNod01.ogg"] = 01.30,
					["DraeneiMaleNod02.ogg"] = 00.48,
					["DraeneiMaleNod03.ogg"] = 00.64,
					["DraeneiMaleOpenFire01.ogg"] = 00.76,
					["DraeneiMaleOpenFire02.ogg"] = 00.95,
					["DraeneiMaleOutOfMana01.ogg"] = 00.95,
					["DraeneiMaleOutOfMana02.ogg"] = 01.98,
					["DraeneiMalePissed01.ogg"] = 03.03,
					["DraeneiMalePissed04.ogg"] = 11.25,
					["DraeneiMalePissed12.ogg"] = 07.83,
					["DraeneiMalePissed14.ogg"] = 09.86,
					["DraeneiMalePissed16.ogg"] = 06.02,
					["DraeneiMalePissed17.ogg"] = 08.27,
					["DraeneiMaleRaspberry01.ogg"] = 01.45,
					["DraeneiMaleRoar01.ogg"] = 03.08,
					["DraeneiMaleSigh01.ogg"] = 02.15,
					["DraeneiMaleThankYou01.ogg"] = 01.89,
					["DraeneiMaleThankYou02.ogg"] = 01.82,
					["DraeneiMaleThankYou03.ogg"] = 01.83,
					["DraeneiMaleTrain01.ogg"] = 03.39,
					["DraeneiMaleWaitHere01.ogg"] = 00.60,
					["DraeneiMaleWaitHere02.ogg"] = 01.08,
					["DraeneiMaleYawn01.ogg"] = 01.60,
					["DraeneiMaleYes01.ogg"] = 00.55,
					["DraeneiMaleYes02.ogg"] = 01.02,
					["DraeneiMaleYes03.ogg"] = 00.89,
					["DraeneiMaleYoureWelcome01.ogg"] = 01.48,
					["DraeneiMaleYoureWelcome02.ogg"] = 00.89,
					["DraeneiMaleYoureWelcome03.ogg"] = 01.75,
				},
				["DraeneiFemalePC\\"] = {
					["VO_PCDraeneiFemale_"] = {
						["Attack_"] = {
							["01.OGG"] = 00.53,
							["02.OGG"] = 00.50,
							["03.OGG"] = 01.26,
						},
						["Death_"] = {
							["01.OGG"] = 02.05,
							["02.OGG"] = 01.63,
							["03.OGG"] = 01.17,
							["04.OGG"] = 00.60,
							["05.OGG"] = 01.96,
							["06.OGG"] = 01.22,
							["07.OGG"] = 01.90,
							["08.OGG"] = 01.94,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.54,
							["02.OGG"] = 00.65,
							["03.OGG"] = 00.71,
						},
						["Wound_"] = {
							["01.OGG"] = 00.52,
							["02.OGG"] = 00.58,
							["03.OGG"] = 00.71,
						},
					},
					["DraeneiFemalePCAttackA.ogg"] = 00.37,
					["DraeneiFemalePCAttackB.ogg"] = 00.34,
					["DraeneiFemalePCAttackC.ogg"] = 00.38,
					["DraeneiFemalePCAttackD.ogg"] = 00.65,
					["DraeneiFemalePCAttackE.ogg"] = 00.93,
					["DraeneiFemalePCAttackF.ogg"] = 00.91,
					["DraeneiFemalePCAttackG.ogg"] = 00.38,
					["DraeneiFemalePCDeath.ogg"] = 01.20,
					["DraeneiFemalePCPreAggro.ogg"] = 01.04,
					["DraeneiFemalePCWoundA.ogg"] = 00.39,
					["DraeneiFemalePCWoundB.ogg"] = 00.39,
					["DraeneiFemalePCWoundC.ogg"] = 00.32,
					["DraeneiFemalePCWoundCritA.ogg"] = 00.72,
					["DraeneiFemalePCWoundCritB.ogg"] = 00.74,
					["DraeneiFemalePCWoundCritC.ogg"] = 00.86,
					["DraeneiFemalePCWoundD.ogg"] = 00.32,
					["DraeneiFemalePCWoundE.ogg"] = 00.37,
					["DraeneiFemalePCWoundF.ogg"] = 00.62,
					["DraeneiFemalePCWoundG.ogg"] = 00.50,
				},
				["DraeneiMalePC\\"] = {
					["VO_PCDraeneiMale_"] = {
						["Attack_"] = {
							["01.OGG"] = 00.33,
							["02.OGG"] = 00.42,
						},
						["Death_"] = {
							["01.OGG"] = 02.09,
							["02.OGG"] = 02.34,
							["03.OGG"] = 01.92,
							["04.OGG"] = 02.23,
							["05.OGG"] = 02.59,
							["06.OGG"] = 02.15,
							["07.OGG"] = 01.98,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.75,
							["02.OGG"] = 00.75,
							["03.OGG"] = 00.53,
						},
						["Wound_01.OGG"] = 00.58,
					},
					["DraeneiMalePCAttackA.ogg"] = 00.78,
					["DraeneiMalePCAttackB.ogg"] = 00.42,
					["DraeneiMalePCAttackC.ogg"] = 00.47,
					["DraeneiMalePCAttackD.ogg"] = 00.71,
					["DraeneiMalePCAttackE.ogg"] = 00.76,
					["DraeneiMalePCAttackF.ogg"] = 00.55,
					["DraeneiMalePCAttackG.ogg"] = 01.06,
					["DraeneiMalePCDeath.ogg"] = 02.22,
					["DraeneiMalePCPreAggro.ogg"] = 01.01,
					["DraeneiMalePCWoundA.ogg"] = 00.40,
					["DraeneiMalePCWoundB.ogg"] = 00.42,
					["DraeneiMalePCWoundC.ogg"] = 00.44,
					["DraeneiMalePCWoundCritA.ogg"] = 01.02,
					["DraeneiMalePCWoundCritB.ogg"] = 00.79,
					["DraeneiMalePCWoundCritC.ogg"] = 01.08,
					["DraeneiMalePCWoundCritD.ogg"] = 00.77,
					["DraeneiMalePCWoundCritE.ogg"] = 00.75,
					["DraeneiMalePCWoundD.ogg"] = 00.58,
					["DraeneiMalePCWoundE.ogg"] = 00.47,
					["DraeneiMalePCWoundF.ogg"] = 00.53,
					["DraeneiMalePCWoundG.ogg"] = 00.48,
					["DraeneiMalePCWoundH.ogg"] = 00.58,
					["DraeneiMalePCWoundI.ogg"] = 00.67,
				},
				["Dwarf\\"] = {
					["DwarfFemale\\"] = {
						["DwarfFemaleAttackA.ogg"] = 00.30,
						["DwarfFemaleAttackB.ogg"] = 00.33,
						["DwarfFemaleAttackC.ogg"] = 00.38,
						["DwarfFemaleAttackD.ogg"] = 00.36,
						["DwarfFemaleChicken01.ogg"] = 01.95,
						["DwarfFemaleChooChoo01.ogg"] = 04.38,
						["DwarfFemaleCry01.ogg"] = 04.06,
						["DwarfFemaleDeathA.ogg"] = 01.61,
						["DwarfFemaleKiss01.ogg"] = 01.21,
						["DwarfFemaleLaugh01.ogg"] = 02.40,
						["DwarfFemalePreAggroA.ogg"] = 00.19,
						["DwarfFemaleSigh01.ogg"] = 01.76,
						["DwarfFemaleWoundA.ogg"] = 00.47,
						["DwarfFemaleWoundB.ogg"] = 00.48,
						["DwarfFemaleWoundC.ogg"] = 00.33,
						["DwarfFemaleWoundCritA.ogg"] = 00.45,
						["DwarfFemaleWoundCritB.ogg"] = 00.57,
						["DwarfFemaleWoundD.ogg"] = 00.26,
						["DwarfFemaleYawn01.ogg"] = 03.59,
					},
					["DwarfFemaleErrorMessages\\DwarfFemale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.00,
								["skillnotfound03.ogg"] = 01.44,
								["skillnotfound04.ogg"] = 01.83,
							},
							["abilitycooldown01.ogg"] = 01.84,
							["abilitycooldown02.ogg"] = 01.21,
							["abilitycooldown03.ogg"] = 00.92,
							["alreadyingroup02.ogg"] = 01.58,
							["ammoonly02.ogg"] = 01.18,
							["bagfull01.ogg"] = 01.03,
							["cantcreatehere03.ogg"] = 01.12,
							["cantdropsoulbounditem01.ogg"] = 00.97,
							["cantdropsoulbounditem03.ogg"] = 00.98,
							["cantequipever01.ogg"] = 01.76,
							["cantequiplevel01.ogg"] = 02.20,
							["cantequiplevel02.ogg"] = 01.45,
							["cantequipskill03.ogg"] = 02.51,
							["cantlearnspell01.ogg"] = 01.42,
							["cantloot01.ogg"] = 01.31,
							["canttradesoulbounditem01.ogg"] = 00.99,
							["cantuseitem01.ogg"] = 00.92,
							["chestinuse02.ogg"] = 01.48,
							["genericnotarget01.ogg"] = 01.31,
							["genericnotarget02.ogg"] = 02.25,
							["genericnotarget04.ogg"] = 01.27,
							["guildpermissions01.ogg"] = 01.05,
							["guildpermissions04.ogg"] = 01.45,
							["invalidattacktarget01.ogg"] = 01.72,
							["invalidattacktarget02.ogg"] = 00.99,
							["inventoryfull01.ogg"] = 01.36,
							["inventoryfull02.ogg"] = 01.34,
							["itemcooldown02.ogg"] = 01.47,
							["itemcooldown04.ogg"] = 01.14,
							["itemcooldown06.ogg"] = 01.65,
							["itemlocked01.ogg"] = 00.90,
							["itemmaxcount01.ogg"] = 01.73,
							["lootdidntkill01.ogg"] = 01.31,
							["lootdidntkill06.ogg"] = 01.44,
							["loottoofar02.ogg"] = 01.61,
							["loottoofar03.ogg"] = 01.00,
							["loottoofar04.ogg"] = 01.21,
							["mustequipitem02.ogg"] = 02.27,
							["mustequipitem03.ogg"] = 01.65,
							["noammo05.ogg"] = 01.03,
							["noenergy01.ogg"] = 01.80,
							["noenergy02.ogg"] = 01.93,
							["nomana01.ogg"] = 01.47,
							["nomana02.ogg"] = 01.07,
							["nomana03.ogg"] = 01.15,
							["norage01.ogg"] = 01.18,
							["norage05.ogg"] = 01.12,
							["notabag01.ogg"] = 01.13,
							["notenoughmoney01.ogg"] = 01.26,
							["notenoughmoney02.ogg"] = 01.16,
							["notenoughmoney03.ogg"] = 01.27,
							["notequippable01.ogg"] = 01.15,
							["outofrange02.ogg"] = 01.29,
							["outofrange04.ogg"] = 00.98,
							["outofrange05.ogg"] = 01.43,
							["partyfull03.ogg"] = 02.04,
							["potioncooldown01.ogg"] = 01.59,
							["proficiencyneeded01.ogg"] = 01.38,
							["spellcooldown01.ogg"] = 01.71,
							["spellcooldown02.ogg"] = 01.58,
							["spellcooldown03.ogg"] = 01.54,
						},
					},
					["DwarfMale\\"] = {
						["DwarfMaleAttackA.ogg"] = 01.03,
						["DwarfMaleAttackB.ogg"] = 00.61,
						["DwarfMaleAttackC.ogg"] = 00.79,
						["DwarfMaleAttackD.ogg"] = 00.67,
						["DwarfMaleChicken01.ogg"] = 03.39,
						["DwarfMaleChooChoo01.ogg"] = 05.91,
						["DwarfMaleCry01.ogg"] = 04.25,
						["DwarfMaleDeathA.ogg"] = 02.16,
						["DwarfMaleKiss01.ogg"] = 01.00,
						["DwarfMaleLaugh01.ogg"] = 03.18,
						["DwarfMaleSigh01.ogg"] = 01.34,
						["DwarfMaleWoundA.ogg"] = 00.77,
						["DwarfMaleWoundB.ogg"] = 00.35,
						["DwarfMaleWoundC.ogg"] = 00.55,
						["DwarfMaleWoundCrit.ogg"] = 00.69,
						["DwarfMaleYawn01.ogg"] = 07.65,
					},
					["DwarfMaleErrorMessages\\DwarfMale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 01.81,
								["skillnotfound03.ogg"] = 01.68,
								["skillnotfound04.ogg"] = 02.30,
							},
							["abilitycooldown01.ogg"] = 02.26,
							["abilitycooldown02.ogg"] = 01.56,
							["abilitycooldown03.ogg"] = 00.99,
							["alreadyingroup02.ogg"] = 02.25,
							["ammoonly02.ogg"] = 01.07,
							["bagfull01.ogg"] = 01.28,
							["cantcreatehere03.ogg"] = 01.35,
							["cantdropsoulbounditem01.ogg"] = 01.44,
							["cantdropsoulbounditem03.ogg"] = 01.43,
							["cantequipever01.ogg"] = 02.38,
							["cantequiplevel01.ogg"] = 02.20,
							["cantequiplevel02.ogg"] = 01.00,
							["cantequipskill03.ogg"] = 02.72,
							["cantlearnspell01.ogg"] = 01.41,
							["cantloot01.ogg"] = 01.28,
							["canttradesoulbounditem01.ogg"] = 01.10,
							["cantuseitem01.ogg"] = 01.68,
							["chestinuse02.ogg"] = 01.60,
							["genericnotarget01.ogg"] = 01.23,
							["genericnotarget02.ogg"] = 02.13,
							["genericnotarget04.ogg"] = 01.08,
							["guildpermissions01.ogg"] = 01.27,
							["guildpermissions04.ogg"] = 01.71,
							["invalidattacktarget01.ogg"] = 01.57,
							["invalidattacktarget02.ogg"] = 01.03,
							["inventoryfull01.ogg"] = 01.89,
							["inventoryfull02.ogg"] = 01.21,
							["itemcooldown02.ogg"] = 01.20,
							["itemcooldown04.ogg"] = 01.30,
							["itemcooldown06.ogg"] = 01.48,
							["itemlocked01.ogg"] = 00.99,
							["itemmaxcount01.ogg"] = 02.20,
							["lootdidntkill01.ogg"] = 01.28,
							["lootdidntkill06.ogg"] = 01.65,
							["loottoofar02.ogg"] = 01.34,
							["loottoofar03.ogg"] = 01.22,
							["loottoofar04.ogg"] = 01.23,
							["mustequipitem02.ogg"] = 01.76,
							["mustequipitem03.ogg"] = 01.30,
							["noammo05.ogg"] = 00.77,
							["noenergy01.ogg"] = 01.23,
							["noenergy02.ogg"] = 01.94,
							["nomana01.ogg"] = 00.86,
							["nomana02.ogg"] = 01.22,
							["nomana03.ogg"] = 01.66,
							["norage01.ogg"] = 01.81,
							["norage05.ogg"] = 01.65,
							["notabag01.ogg"] = 01.09,
							["notenoughmoney01.ogg"] = 01.48,
							["notenoughmoney02.ogg"] = 01.47,
							["notenoughmoney03.ogg"] = 01.50,
							["notequippable01.ogg"] = 00.92,
							["outofrange02.ogg"] = 01.22,
							["outofrange04.ogg"] = 01.18,
							["outofrange05.ogg"] = 01.34,
							["partyfull03.ogg"] = 02.09,
							["potioncooldown01.ogg"] = 02.17,
							["proficiencyneeded01.ogg"] = 01.00,
							["spellcooldown01.ogg"] = 01.46,
							["spellcooldown02.ogg"] = 01.38,
							["spellcooldown03.ogg"] = 01.38,
						},
					},
					["DwarfMaleNPC\\DwarfMaleNpc1\\"] = {
						["DwarfMaleGuard1AttackA.ogg"] = 00.44,
						["DwarfMaleWarrior1AggroA.ogg"] = 00.33,
						["DwarfMaleWarrior1AttackA.ogg"] = 00.27,
						["DwarfMaleWarrior1AttackB.ogg"] = 00.30,
						["DwarfMaleWarrior1AttackC.ogg"] = 00.45,
						["DwarfMaleWarrior1DeathA.ogg"] = 00.95,
						["DwarfMaleWarrior1PreAggro.ogg"] = 00.49,
						["DwarfMaleWarrior1WoundA.ogg"] = 00.31,
						["DwarfMaleWarrior1WoundB.ogg"] = 00.34,
						["DwarfMaleWarrior1WoundC.ogg"] = 00.64,
					},
					["DwarfVocalFemale\\"] = {
						["DwarfFemaleAttackMyTarget01.ogg"] = 01.01,
						["DwarfFemaleAttackMyTarget02.ogg"] = 01.31,
						["DwarfFemaleCharge01.ogg"] = 01.30,
						["DwarfFemaleCharge02.ogg"] = 01.58,
						["DwarfFemaleCheer01.ogg"] = 01.22,
						["DwarfFemaleCheer02.ogg"] = 01.01,
						["DwarfFemaleCongratulations01.ogg"] = 01.77,
						["DwarfFemaleCongratulations02.ogg"] = 01.48,
						["DwarfFemaleCongratulations03.ogg"] = 01.17,
						["DwarfFemaleCongratulations04.ogg"] = 00.89,
						["DwarfFemaleFlee01.ogg"] = 00.77,
						["DwarfFemaleFlee02.ogg"] = 00.62,
						["DwarfFemaleFlirt01.ogg"] = 01.95,
						["DwarfFemaleFlirt03.ogg"] = 03.48,
						["DwarfFemaleFlirt05.ogg"] = 01.84,
						["DwarfFemaleFlirt06.ogg"] = 06.37,
						["DwarfFemaleFlirt07.ogg"] = 05.07,
						["DwarfFemaleFollowMe01.ogg"] = 00.86,
						["DwarfFemaleFollowMe02.ogg"] = 00.85,
						["DwarfFemaleGoodbye01.ogg"] = 00.63,
						["DwarfFemaleGoodbye02.ogg"] = 00.64,
						["DwarfFemaleGoodbye03.ogg"] = 00.51,
						["DwarfFemaleHealMe01.ogg"] = 01.46,
						["DwarfFemaleHealMe02.ogg"] = 01.34,
						["DwarfFemaleHealMe03.ogg"] = 00.82,
						["DwarfFemaleHello01.ogg"] = 00.75,
						["DwarfFemaleHello02.ogg"] = 00.54,
						["DwarfFemaleHello03.ogg"] = 00.67,
						["DwarfFemaleHelp01.ogg"] = 00.87,
						["DwarfFemaleHelp02.ogg"] = 01.10,
						["DwarfFemaleIncoming01.ogg"] = 01.72,
						["DwarfFemaleIncoming02.ogg"] = 00.75,
						["DwarfFemaleNo01.ogg"] = 00.75,
						["DwarfFemaleNo02.ogg"] = 00.89,
						["DwarfFemaleNo03.ogg"] = 00.87,
						["DwarfFemaleOpenFire01.ogg"] = 01.23,
						["DwarfFemaleOpenFire02.ogg"] = 01.23,
						["DwarfFemaleOutOfMana01.ogg"] = 01.42,
						["DwarfFemaleOutOfMana02.ogg"] = 01.16,
						["DwarfFemalePissed01.ogg"] = 03.44,
						["DwarfFemalePissed02.ogg"] = 03.71,
						["DwarfFemalePissed03.ogg"] = 04.56,
						["DwarfFemalePissed04.ogg"] = 04.49,
						["DwarfFemalePissed05.ogg"] = 03.78,
						["DwarfFemalePissed06.ogg"] = 09.79,
						["DwarfFemaleRaspberry01.ogg"] = 00.91,
						["DwarfFemaleThankYou01.ogg"] = 00.55,
						["DwarfFemaleThankYou02.ogg"] = 01.50,
						["DwarfFemaleThankYou03.ogg"] = 00.78,
						["DwarfFemaleThankYou04.ogg"] = 04.00,
						["DwarfFemaleWaitHere01.ogg"] = 00.84,
						["DwarfFemaleWaitHere02.ogg"] = 00.91,
						["DwarfFemaleYes01.ogg"] = 00.53,
						["DwarfFemaleYes02.ogg"] = 00.81,
						["DwarfFemaleYes03.ogg"] = 00.83,
						["DwarfFemaleYoureWelcome01.ogg"] = 01.05,
						["DwarfFemaleYoureWelcome02.ogg"] = 00.92,
						["DwarfFemaleYoureWelcome03.ogg"] = 00.86,
						["VO_PCDwarfFemaleRoar01.ogg"] = 01.92,
					},
					["DwarfVocalMale\\"] = {
						["DwarfMaleAttackMyTarget01.ogg"] = 01.13,
						["DwarfMaleAttackMyTarget02.ogg"] = 01.27,
						["DwarfMaleAttackMyTarget03.ogg"] = 01.57,
						["DwarfMaleCharge01.ogg"] = 01.63,
						["DwarfMaleCharge02.ogg"] = 01.75,
						["DwarfMaleCheer01.ogg"] = 00.75,
						["DwarfMaleCheer02.ogg"] = 02.04,
						["DwarfMaleCheer03.ogg"] = 01.61,
						["DwarfMaleCongratulations01.ogg"] = 01.72,
						["DwarfMaleCongratulations02.ogg"] = 01.46,
						["DwarfMaleCongratulations03.ogg"] = 00.77,
						["DwarfMaleCongratulations04.ogg"] = 01.10,
						["DwarfMaleCongratulations05.ogg"] = 01.49,
						["DwarfMaleFlee01.ogg"] = 00.89,
						["DwarfMaleFlee02.ogg"] = 00.83,
						["DwarfMaleFlee03.ogg"] = 00.58,
						["DwarfMaleFlirt01.ogg"] = 02.63,
						["DwarfMaleFlirt02.ogg"] = 03.39,
						["DwarfMaleFlirt03.ogg"] = 03.95,
						["DwarfMaleFlirt04.ogg"] = 03.43,
						["DwarfMaleFlirt05.ogg"] = 02.27,
						["DwarfMaleFlirt06.ogg"] = 06.29,
						["DwarfMaleFollowMe01.ogg"] = 01.32,
						["DwarfMaleFollowMe02.ogg"] = 00.77,
						["DwarfMaleFollowMe03.ogg"] = 01.05,
						["DwarfMaleGoodbye01.ogg"] = 00.82,
						["DwarfMaleGoodbye02.ogg"] = 01.53,
						["DwarfMaleGoodbye03.ogg"] = 00.65,
						["DwarfMaleHealMe01.ogg"] = 01.73,
						["DwarfMaleHealMe02.ogg"] = 01.16,
						["DwarfMaleHealMe03.ogg"] = 00.93,
						["DwarfMaleHello01.ogg"] = 01.02,
						["DwarfMaleHello02.ogg"] = 00.67,
						["DwarfMaleHello03.ogg"] = 00.85,
						["DwarfMaleHello04.ogg"] = 01.08,
						["DwarfMaleHelp01.ogg"] = 00.67,
						["DwarfMaleHelp02.ogg"] = 00.99,
						["DwarfMaleIncoming01.ogg"] = 01.02,
						["DwarfMaleIncoming02.ogg"] = 00.43,
						["DwarfMaleNo01.ogg"] = 00.61,
						["DwarfMaleNo02.ogg"] = 00.50,
						["DwarfMaleNo03.ogg"] = 00.90,
						["DwarfMaleNo04.ogg"] = 01.61,
						["DwarfMaleOpenFire01.ogg"] = 01.26,
						["DwarfMaleOpenFire02.ogg"] = 01.12,
						["DwarfMaleOutOfMana01.ogg"] = 01.18,
						["DwarfMaleOutOfMana02.ogg"] = 01.05,
						["DwarfMalePissed01.ogg"] = 06.50,
						["DwarfMalePissed02.ogg"] = 03.60,
						["DwarfMalePissed03.ogg"] = 06.44,
						["DwarfMalePissed04.ogg"] = 05.40,
						["DwarfMalePissed05.ogg"] = 03.90,
						["DwarfMalePissed06.ogg"] = 04.92,
						["DwarfMalePissed07.ogg"] = 06.30,
						["DwarfMaleRaspberry01.ogg"] = 01.76,
						["DwarfMaleThankYou01.ogg"] = 00.57,
						["DwarfMaleThankYou02.ogg"] = 01.14,
						["DwarfMaleThankYou03.ogg"] = 01.79,
						["DwarfMaleThankYou04.ogg"] = 03.73,
						["DwarfMaleWaitHere01.ogg"] = 00.62,
						["DwarfMaleWaitHere02.ogg"] = 00.62,
						["DwarfMaleWaitHere03.ogg"] = 00.81,
						["DwarfMaleYes01.ogg"] = 00.44,
						["DwarfMaleYes02.ogg"] = 00.70,
						["DwarfMaleYes03.ogg"] = 00.43,
						["DwarfMaleYes04.ogg"] = 01.17,
						["DwarfMaleYoureWelcome01.ogg"] = 01.24,
						["DwarfMaleYoureWelcome02.ogg"] = 01.17,
						["DwarfMaleYoureWelcome03.ogg"] = 00.98,
						["VO_PCDwarfMaleRoar01.ogg"] = 02.18,
					},
				},
				["FOOTSTEPS\\"] = {
					["ClawedMedium\\MON_"] = {
						["Footstep_Bipedal_"] = {
							["Clawed_Medium_"] = {
								["Dirt_"] = {
									["01.ogg"] = 00.23,
									["010.ogg"] = 00.23,
									["011.ogg"] = 00.26,
									["012.ogg"] = 00.22,
									["013.ogg"] = 00.16,
									["014.ogg"] = 00.22,
									["015.ogg"] = 00.26,
									["016.ogg"] = 00.22,
									["017.ogg"] = 00.19,
									["018.ogg"] = 00.21,
									["019.ogg"] = 00.22,
									["02.ogg"] = 00.21,
									["020.ogg"] = 00.18,
									["03.ogg"] = 00.22,
									["04.ogg"] = 00.14,
									["05.ogg"] = 00.18,
									["06.ogg"] = 00.19,
									["07.ogg"] = 00.29,
									["08.ogg"] = 00.30,
									["09.ogg"] = 00.21,
								},
								["Glass_"] = {
									["01.OGG"] = 00.29,
									["010.OGG"] = 00.21,
									["011.OGG"] = 00.26,
									["012.OGG"] = 00.23,
									["013.OGG"] = 00.20,
									["014.OGG"] = 00.24,
									["015.OGG"] = 00.31,
									["016.OGG"] = 00.20,
									["017.OGG"] = 00.30,
									["018.OGG"] = 00.19,
									["019.OGG"] = 00.19,
									["02.OGG"] = 00.41,
									["020.OGG"] = 00.29,
									["03.OGG"] = 00.40,
									["04.OGG"] = 00.29,
									["05.OGG"] = 00.43,
									["06.OGG"] = 00.39,
									["07.OGG"] = 00.39,
									["08.OGG"] = 00.39,
									["09.OGG"] = 00.28,
								},
								["Grass_"] = {
									["01.OGG"] = 00.26,
									["010.OGG"] = 00.29,
									["011.OGG"] = 00.26,
									["012.OGG"] = 00.31,
									["013.OGG"] = 00.27,
									["014.OGG"] = 00.28,
									["015.OGG"] = 00.26,
									["016.OGG"] = 00.36,
									["017.OGG"] = 00.31,
									["018.OGG"] = 00.32,
									["019.OGG"] = 00.31,
									["02.OGG"] = 00.38,
									["020.OGG"] = 00.42,
									["03.OGG"] = 00.32,
									["04.OGG"] = 00.27,
									["05.OGG"] = 00.35,
									["06.OGG"] = 00.28,
									["07.OGG"] = 00.43,
									["08.OGG"] = 00.33,
									["09.OGG"] = 00.45,
								},
								["MetalGrate_"] = {
									["01.OGG"] = 00.19,
									["010.OGG"] = 00.16,
									["011.OGG"] = 00.19,
									["012.OGG"] = 00.20,
									["013.OGG"] = 00.19,
									["014.OGG"] = 00.19,
									["015.OGG"] = 00.18,
									["016.OGG"] = 00.29,
									["017.OGG"] = 00.19,
									["018.OGG"] = 00.17,
									["019.OGG"] = 00.17,
									["02.OGG"] = 00.22,
									["020.OGG"] = 00.19,
									["03.OGG"] = 00.17,
									["04.OGG"] = 00.19,
									["05.OGG"] = 00.19,
									["06.OGG"] = 00.36,
									["07.OGG"] = 00.22,
									["08.OGG"] = 00.19,
									["09.OGG"] = 00.17,
								},
								["Metal_"] = {
									["01.OGG"] = 00.21,
									["010.OGG"] = 00.24,
									["011.OGG"] = 00.23,
									["02.OGG"] = 00.22,
									["03.OGG"] = 00.17,
									["04.OGG"] = 00.27,
									["05.OGG"] = 00.22,
									["06.OGG"] = 00.22,
									["07.OGG"] = 00.23,
									["08.OGG"] = 00.19,
									["09.OGG"] = 00.22,
								},
								["Sand_"] = {
									["01.OGG"] = 00.35,
									["010.OGG"] = 00.51,
									["011.OGG"] = 00.35,
									["012.OGG"] = 00.35,
									["013.OGG"] = 00.36,
									["014.OGG"] = 00.36,
									["015.OGG"] = 00.31,
									["016.OGG"] = 00.34,
									["017.OGG"] = 00.38,
									["018.OGG"] = 00.34,
									["019.OGG"] = 00.34,
									["02.OGG"] = 00.42,
									["020.OGG"] = 00.42,
									["03.OGG"] = 00.37,
									["04.OGG"] = 00.41,
									["05.OGG"] = 00.33,
									["06.OGG"] = 00.40,
									["07.OGG"] = 00.36,
									["08.OGG"] = 00.35,
									["09.OGG"] = 00.34,
								},
								["Stone_"] = {
									["01.OGG"] = 00.19,
									["010.OGG"] = 00.20,
									["011.OGG"] = 00.21,
									["012.OGG"] = 00.17,
									["013.OGG"] = 00.20,
									["014.OGG"] = 00.24,
									["015.OGG"] = 00.20,
									["016.OGG"] = 00.19,
									["017.OGG"] = 00.21,
									["018.OGG"] = 00.21,
									["019.OGG"] = 00.20,
									["02.OGG"] = 00.17,
									["020.OGG"] = 00.18,
									["03.OGG"] = 00.19,
									["04.OGG"] = 00.25,
									["05.OGG"] = 00.25,
									["06.OGG"] = 00.22,
									["07.OGG"] = 00.18,
									["08.OGG"] = 00.20,
									["09.OGG"] = 00.20,
								},
								["Wood_"] = {
									["01.OGG"] = 00.22,
									["010.OGG"] = 00.23,
									["011.OGG"] = 00.19,
									["012.OGG"] = 00.19,
									["013.OGG"] = 00.22,
									["014.OGG"] = 00.19,
									["015.OGG"] = 00.22,
									["016.OGG"] = 00.22,
									["017.OGG"] = 00.20,
									["018.OGG"] = 00.19,
									["019.OGG"] = 00.19,
									["02.OGG"] = 00.21,
									["020.OGG"] = 00.20,
									["03.OGG"] = 00.22,
									["04.OGG"] = 00.22,
									["05.OGG"] = 00.21,
									["06.OGG"] = 00.19,
									["07.OGG"] = 00.21,
									["08.OGG"] = 00.22,
									["09.OGG"] = 00.22,
								},
							},
						},
					},
					["EnterWaterSplash\\"] = {
						["EnterWaterGiantA.ogg"] = 03.08,
						["EnterWaterMediumA.ogg"] = 01.57,
						["EnterWaterSmallA.ogg"] = 01.81,
					},
					["FootMedium\\MON_"] = {
						["Footstep_Bipedal_"] = {
							["Foot_Medium_"] = {
								["Dirt_"] = {
									["01.OGG"] = 00.28,
									["010.ogg"] = 00.41,
									["011.OGG"] = 00.42,
									["012.OGG"] = 00.37,
									["013.OGG"] = 00.43,
									["014.OGG"] = 00.38,
									["015.OGG"] = 00.29,
									["016.ogg"] = 00.40,
									["017.ogg"] = 00.34,
									["018.ogg"] = 00.31,
									["019.ogg"] = 00.31,
									["02.OGG"] = 00.39,
									["020.ogg"] = 00.33,
									["03.OGG"] = 00.32,
									["04.OGG"] = 00.35,
									["05.OGG"] = 00.30,
									["06.ogg"] = 00.37,
									["07.ogg"] = 00.28,
									["08.ogg"] = 00.34,
									["09.ogg"] = 00.34,
								},
								["Glass_"] = {
									["01.OGG"] = 00.34,
									["010.OGG"] = 00.36,
									["011.OGG"] = 00.28,
									["012.OGG"] = 00.34,
									["013.OGG"] = 00.25,
									["014.OGG"] = 00.27,
									["015.OGG"] = 00.29,
									["016.OGG"] = 00.36,
									["017.OGG"] = 00.27,
									["018.OGG"] = 00.22,
									["019.OGG"] = 00.28,
									["02.OGG"] = 00.34,
									["020.OGG"] = 00.33,
									["03.OGG"] = 00.27,
									["04.OGG"] = 00.36,
									["05.OGG"] = 00.27,
									["06.OGG"] = 00.31,
									["07.OGG"] = 00.34,
									["08.OGG"] = 00.27,
									["09.OGG"] = 00.28,
								},
								["Grass_"] = {
									["01.OGG"] = 00.39,
									["011.OGG"] = 00.35,
									["012.OGG"] = 00.38,
									["013.OGG"] = 00.43,
									["014.OGG"] = 00.38,
									["015.OGG"] = 00.45,
									["016.OGG"] = 00.38,
									["017.OGG"] = 00.45,
									["018.OGG"] = 00.44,
									["019.OGG"] = 00.37,
									["02.OGG"] = 00.47,
									["020.OGG"] = 00.45,
									["03.OGG"] = 00.42,
									["04.OGG"] = 00.38,
									["05.OGG"] = 00.45,
									["06.OGG"] = 00.48,
									["07.OGG"] = 00.40,
									["08.OGG"] = 00.42,
									["09.OGG"] = 00.42,
								},
								["Ice_"] = {
									["01.ogg"] = 00.31,
									["010.ogg"] = 00.23,
									["011.ogg"] = 00.30,
									["012.ogg"] = 00.27,
									["013.ogg"] = 00.49,
									["014.ogg"] = 00.23,
									["015.ogg"] = 00.24,
									["016.ogg"] = 00.45,
									["017.ogg"] = 00.19,
									["018.ogg"] = 00.22,
									["019.ogg"] = 00.56,
									["02.ogg"] = 00.27,
									["020.ogg"] = 00.26,
									["03.ogg"] = 00.20,
									["04.ogg"] = 00.26,
									["05.ogg"] = 00.34,
									["06.ogg"] = 00.43,
									["07.ogg"] = 00.22,
									["08.ogg"] = 00.20,
									["09.ogg"] = 00.34,
								},
								["MetalGrate_"] = {
									["01.OGG"] = 00.30,
									["010.OGG"] = 00.28,
									["011.OGG"] = 00.28,
									["012.OGG"] = 00.25,
									["013.OGG"] = 00.33,
									["014.OGG"] = 00.31,
									["015.OGG"] = 00.29,
									["016.OGG"] = 00.32,
									["017.OGG"] = 00.28,
									["018.OGG"] = 00.31,
									["019.OGG"] = 00.26,
									["02.OGG"] = 00.35,
									["020.OGG"] = 00.26,
									["03.OGG"] = 00.29,
									["04.OGG"] = 00.33,
									["05.OGG"] = 00.24,
									["06.OGG"] = 00.30,
									["07.OGG"] = 00.33,
									["08.OGG"] = 00.29,
									["09.OGG"] = 00.26,
								},
								["Metal_"] = {
									["01.OGG"] = 00.21,
									["010.OGG"] = 00.16,
									["011.OGG"] = 00.20,
									["012.OGG"] = 00.17,
									["013.OGG"] = 00.18,
									["014.OGG"] = 00.18,
									["015.OGG"] = 00.16,
									["016.OGG"] = 00.17,
									["017.OGG"] = 00.18,
									["018.OGG"] = 00.16,
									["02.OGG"] = 00.18,
									["03.OGG"] = 00.18,
									["04.OGG"] = 00.16,
									["05.OGG"] = 00.16,
									["06.OGG"] = 00.17,
									["07.OGG"] = 00.15,
									["08.OGG"] = 00.16,
									["09.OGG"] = 00.18,
								},
								["Sand_"] = {
									["01.OGG"] = 00.34,
									["010.OGG"] = 00.51,
									["011.OGG"] = 00.41,
									["012.OGG"] = 00.55,
									["013.OGG"] = 00.50,
									["014.OGG"] = 00.50,
									["015.OGG"] = 00.49,
									["016.OGG"] = 00.50,
									["017.OGG"] = 00.46,
									["018.OGG"] = 00.46,
									["019.OGG"] = 00.52,
									["02.OGG"] = 00.37,
									["020.OGG"] = 00.44,
									["03.OGG"] = 00.48,
									["04.OGG"] = 00.49,
									["05.OGG"] = 00.43,
									["06.OGG"] = 00.39,
									["07.OGG"] = 00.36,
									["08.OGG"] = 00.46,
									["09.OGG"] = 00.40,
								},
								["Stone_"] = {
									["01.OGG"] = 00.21,
									["010.OGG"] = 00.14,
									["011.OGG"] = 00.13,
									["012.OGG"] = 00.14,
									["013.OGG"] = 00.13,
									["014.OGG"] = 00.17,
									["015.OGG"] = 00.12,
									["016.OGG"] = 00.13,
									["017.OGG"] = 00.15,
									["018.OGG"] = 00.13,
									["019.OGG"] = 00.12,
									["02.OGG"] = 00.16,
									["020.OGG"] = 00.12,
									["03.OGG"] = 00.15,
									["04.OGG"] = 00.13,
									["05.OGG"] = 00.16,
									["06.OGG"] = 00.12,
									["07.OGG"] = 00.16,
									["08.OGG"] = 00.17,
									["09.OGG"] = 00.12,
								},
								["Swamp_"] = {
									["01.ogg"] = 00.48,
									["010.ogg"] = 00.46,
									["011.ogg"] = 00.49,
									["012.ogg"] = 00.49,
									["013.ogg"] = 00.38,
									["014.ogg"] = 00.51,
									["015.ogg"] = 00.63,
									["016.ogg"] = 00.51,
									["017.ogg"] = 00.51,
									["018.ogg"] = 00.35,
									["019.ogg"] = 00.49,
									["02.ogg"] = 00.51,
									["020.ogg"] = 00.51,
									["03.ogg"] = 00.46,
									["04.ogg"] = 00.43,
									["05.ogg"] = 00.48,
									["06.ogg"] = 00.41,
									["07.ogg"] = 00.51,
									["08.ogg"] = 00.40,
									["09.ogg"] = 00.41,
								},
								["Water_"] = {
									["01.ogg"] = 00.99,
									["010.ogg"] = 00.86,
									["011.ogg"] = 01.17,
									["012.ogg"] = 01.14,
									["013.ogg"] = 01.23,
									["014.ogg"] = 01.11,
									["015.ogg"] = 01.11,
									["016.ogg"] = 01.13,
									["017.ogg"] = 01.04,
									["018.ogg"] = 01.08,
									["019.ogg"] = 01.08,
									["02.ogg"] = 00.99,
									["020.ogg"] = 00.91,
									["03.ogg"] = 01.08,
									["04.ogg"] = 01.19,
									["05.ogg"] = 01.03,
									["06.ogg"] = 00.93,
									["07.ogg"] = 01.06,
									["08.ogg"] = 01.07,
									["09.ogg"] = 01.13,
								},
								["Wood_"] = {
									["01.OGG"] = 00.20,
									["010.OGG"] = 00.23,
									["011.OGG"] = 00.19,
									["012.OGG"] = 00.24,
									["013.OGG"] = 00.18,
									["014.OGG"] = 00.17,
									["015.OGG"] = 00.18,
									["02.OGG"] = 00.24,
									["03.OGG"] = 00.25,
									["04.OGG"] = 00.26,
									["05.OGG"] = 00.14,
									["06.OGG"] = 00.25,
									["07.OGG"] = 00.22,
									["08.OGG"] = 00.26,
									["09.OGG"] = 00.25,
								},
							},
						},
					},
					["FootSmall\\MON_"] = {
						["Footstep_Bipedal_"] = {
							["Foot_Small_"] = {
								["Dirt_"] = {
									["011.OGG"] = 00.32,
									["012.OGG"] = 00.43,
									["013.OGG"] = 00.46,
									["014.OGG"] = 00.48,
									["015.OGG"] = 00.30,
									["016.OGG"] = 00.33,
									["017.OGG"] = 00.42,
									["018.OGG"] = 00.37,
									["019.OGG"] = 00.44,
									["020.OGG"] = 00.41,
								},
								["Glass_"] = {
									["011.OGG"] = 00.22,
									["012.OGG"] = 00.23,
									["013.OGG"] = 00.21,
									["014.OGG"] = 00.24,
									["015.OGG"] = 00.23,
									["016.OGG"] = 00.20,
									["017.OGG"] = 00.19,
									["018.OGG"] = 00.22,
									["019.OGG"] = 00.22,
									["020.OGG"] = 00.20,
								},
								["Grass_"] = {
									["010.OGG"] = 00.33,
									["011.OGG"] = 00.40,
									["012.OGG"] = 00.36,
									["013.OGG"] = 00.34,
									["014.OGG"] = 00.39,
									["015.OGG"] = 00.39,
									["016.OGG"] = 00.39,
									["017.OGG"] = 00.41,
									["018.OGG"] = 00.38,
									["019.OGG"] = 00.36,
								},
								["Ice_"] = {
									["01.ogg"] = 00.21,
									["010.ogg"] = 00.17,
									["011.ogg"] = 00.23,
									["012.ogg"] = 00.16,
									["013.ogg"] = 00.17,
									["014.ogg"] = 00.17,
									["015.ogg"] = 00.16,
									["016.ogg"] = 00.35,
									["017.ogg"] = 00.18,
									["018.ogg"] = 00.16,
									["019.ogg"] = 00.14,
									["02.ogg"] = 00.23,
									["020.ogg"] = 00.19,
									["03.ogg"] = 00.25,
									["04.ogg"] = 00.13,
									["05.ogg"] = 00.26,
									["06.ogg"] = 00.20,
									["07.ogg"] = 00.19,
									["08.ogg"] = 00.18,
									["09.ogg"] = 00.31,
								},
								["MetalGrate_"] = {
									["011.OGG"] = 00.31,
									["012.OGG"] = 00.26,
									["013.OGG"] = 00.17,
									["014.OGG"] = 00.26,
									["015.OGG"] = 00.30,
									["016.OGG"] = 00.31,
									["017.OGG"] = 00.31,
									["018.OGG"] = 00.26,
									["019.OGG"] = 00.31,
									["020.OGG"] = 00.31,
								},
								["Metal_"] = {
									["010.OGG"] = 00.16,
									["011.OGG"] = 00.16,
									["012.OGG"] = 00.18,
									["013.OGG"] = 00.18,
									["014.OGG"] = 00.18,
									["015.OGG"] = 00.14,
									["016.OGG"] = 00.18,
									["017.OGG"] = 00.20,
									["018.OGG"] = 00.16,
									["019.OGG"] = 00.18,
								},
								["Sand_"] = {
									["01.OGG"] = 00.33,
									["010.OGG"] = 00.41,
									["011.OGG"] = 00.38,
									["012.OGG"] = 00.36,
									["013.OGG"] = 00.43,
									["014.OGG"] = 00.32,
									["015.OGG"] = 00.23,
									["016.OGG"] = 00.46,
									["017.OGG"] = 00.42,
									["018.OGG"] = 00.31,
									["019.OGG"] = 00.40,
									["02.OGG"] = 00.39,
									["020.OGG"] = 00.29,
									["03.OGG"] = 00.38,
									["04.OGG"] = 00.31,
									["05.OGG"] = 00.37,
									["06.OGG"] = 00.39,
									["07.OGG"] = 00.40,
									["08.OGG"] = 00.37,
									["09.OGG"] = 00.34,
								},
								["Snow_"] = {
									["01.ogg"] = 00.34,
									["010.ogg"] = 00.46,
									["011.ogg"] = 00.46,
									["012.ogg"] = 00.40,
									["013.ogg"] = 00.51,
									["014.ogg"] = 00.47,
									["015.ogg"] = 00.46,
									["016.ogg"] = 00.54,
									["017.ogg"] = 00.39,
									["018.ogg"] = 00.38,
									["019.ogg"] = 00.47,
									["02.ogg"] = 00.33,
									["020.ogg"] = 00.29,
									["03.ogg"] = 00.48,
									["04.ogg"] = 00.41,
									["05.ogg"] = 00.50,
									["06.ogg"] = 00.48,
									["07.ogg"] = 00.51,
									["08.ogg"] = 00.53,
									["09.ogg"] = 00.50,
								},
								["Stone_"] = {
									["011.OGG"] = 00.15,
									["012.OGG"] = 00.26,
									["013.OGG"] = 00.17,
									["014.OGG"] = 00.15,
									["015.OGG"] = 00.24,
									["016.OGG"] = 00.21,
									["017.OGG"] = 00.17,
									["018.OGG"] = 00.22,
									["019.OGG"] = 00.14,
									["020.OGG"] = 00.26,
								},
								["Swamp_"] = {
									["01.ogg"] = 00.48,
									["010.ogg"] = 00.50,
									["011.ogg"] = 00.47,
									["012.ogg"] = 00.46,
									["013.ogg"] = 00.53,
									["014.ogg"] = 00.37,
									["015.ogg"] = 00.51,
									["016.ogg"] = 00.38,
									["017.ogg"] = 00.47,
									["018.ogg"] = 00.48,
									["019.ogg"] = 00.47,
									["02.ogg"] = 00.52,
									["020.ogg"] = 00.44,
									["03.ogg"] = 00.37,
									["04.ogg"] = 00.40,
									["05.ogg"] = 00.48,
									["06.ogg"] = 00.45,
									["07.ogg"] = 00.50,
									["08.ogg"] = 00.50,
									["09.ogg"] = 00.55,
								},
								["Water_"] = {
									["01.ogg"] = 00.66,
									["010.ogg"] = 00.82,
									["011.ogg"] = 00.83,
									["012.ogg"] = 00.77,
									["013.ogg"] = 00.82,
									["014.ogg"] = 00.59,
									["015.ogg"] = 00.75,
									["016.ogg"] = 00.69,
									["017.ogg"] = 00.72,
									["018.ogg"] = 00.77,
									["019.ogg"] = 00.85,
									["02.ogg"] = 01.00,
									["020.ogg"] = 00.97,
									["03.ogg"] = 00.56,
									["04.ogg"] = 00.58,
									["05.ogg"] = 00.72,
									["06.ogg"] = 00.68,
									["07.ogg"] = 00.58,
									["08.ogg"] = 00.78,
									["09.ogg"] = 00.71,
								},
								["Wood_"] = {
									["010.OGG"] = 00.22,
									["011.OGG"] = 00.15,
									["012.OGG"] = 00.18,
									["013.OGG"] = 00.23,
									["014.OGG"] = 00.30,
									["015.OGG"] = 00.17,
									["016.OGG"] = 00.18,
									["017.OGG"] = 00.19,
									["018.OGG"] = 00.20,
									["019.OGG"] = 00.10,
								},
							},
						},
					},
					["GiantFootSteps\\"] = {
						["FootstepsGiant01.ogg"] = 00.82,
						["FootstepsGiant02.ogg"] = 00.71,
						["FootstepsGiant03.ogg"] = 00.60,
						["FootstepsGiant04.ogg"] = 00.66,
						["FootstepsGiant05.ogg"] = 00.66,
					},
					["HoovedMedium\\MON_"] = {
						["Footstep_"] = {
							["Bipedal_Hooved_"] = {
								["Medium_"] = {
									["Dirt_"] = {
										["01.OGG"] = 00.27,
										["010.OGG"] = 00.21,
										["011.OGG"] = 00.23,
										["012.OGG"] = 00.29,
										["013.OGG"] = 00.28,
										["014.OGG"] = 00.28,
										["015.OGG"] = 00.28,
										["016.OGG"] = 00.23,
										["017.OGG"] = 00.25,
										["018.OGG"] = 00.24,
										["019.OGG"] = 00.22,
										["02.OGG"] = 00.25,
										["020.OGG"] = 00.23,
										["03.OGG"] = 00.25,
										["04.OGG"] = 00.27,
										["05.OGG"] = 00.33,
										["06.OGG"] = 00.30,
										["07.OGG"] = 00.23,
										["08.OGG"] = 00.25,
										["09.OGG"] = 00.23,
									},
									["Glass_"] = {
										["01.OGG"] = 00.27,
										["010.OGG"] = 00.25,
										["011.OGG"] = 00.32,
										["012.OGG"] = 00.26,
										["013.OGG"] = 00.30,
										["014.OGG"] = 00.21,
										["015.OGG"] = 00.26,
										["016.OGG"] = 00.31,
										["017.OGG"] = 00.26,
										["018.OGG"] = 00.34,
										["019.OGG"] = 00.27,
										["02.OGG"] = 00.32,
										["020.OGG"] = 00.28,
										["03.OGG"] = 00.28,
										["04.OGG"] = 00.28,
										["05.OGG"] = 00.28,
										["06.OGG"] = 00.27,
										["07.OGG"] = 00.29,
										["08.OGG"] = 00.29,
										["09.OGG"] = 00.27,
									},
									["Grass_"] = {
										["01.OGG"] = 00.41,
										["010.OGG"] = 00.30,
										["011.OGG"] = 00.35,
										["012.OGG"] = 00.42,
										["013.OGG"] = 00.33,
										["014.OGG"] = 00.51,
										["015.OGG"] = 00.33,
										["016.OGG"] = 00.34,
										["017.OGG"] = 00.37,
										["018.OGG"] = 00.32,
										["019.OGG"] = 00.38,
										["02.OGG"] = 00.33,
										["020.OGG"] = 00.33,
										["03.OGG"] = 00.53,
										["04.OGG"] = 00.43,
										["05.OGG"] = 00.30,
										["06.OGG"] = 00.36,
										["07.OGG"] = 00.30,
										["08.OGG"] = 00.37,
										["09.OGG"] = 00.50,
									},
									["MetalGrate_"] = {
										["01.OGG"] = 00.33,
										["010.OGG"] = 00.28,
										["011.OGG"] = 00.31,
										["012.OGG"] = 00.33,
										["013.OGG"] = 00.31,
										["014.OGG"] = 00.27,
										["015.OGG"] = 00.30,
										["016.OGG"] = 00.31,
										["017.OGG"] = 00.34,
										["018.OGG"] = 00.34,
										["019.OGG"] = 00.35,
										["02.OGG"] = 00.28,
										["020.OGG"] = 00.27,
										["03.OGG"] = 00.33,
										["04.OGG"] = 00.39,
										["05.OGG"] = 00.34,
										["06.OGG"] = 00.37,
										["07.OGG"] = 00.30,
										["08.OGG"] = 00.31,
										["09.OGG"] = 00.29,
									},
									["Metal_"] = {
										["01.OGG"] = 00.45,
										["010.OGG"] = 00.46,
										["011.OGG"] = 00.46,
										["012.OGG"] = 00.45,
										["013.OGG"] = 00.46,
										["014.OGG"] = 00.45,
										["015.OGG"] = 00.46,
										["016.OGG"] = 00.51,
										["017.OGG"] = 00.45,
										["018.OGG"] = 00.46,
										["019.OGG"] = 00.45,
										["02.OGG"] = 00.27,
										["020.OGG"] = 00.49,
										["03.OGG"] = 00.46,
										["04.OGG"] = 00.51,
										["05.OGG"] = 00.46,
										["06.OGG"] = 00.45,
										["07.OGG"] = 00.45,
										["08.OGG"] = 00.44,
										["09.OGG"] = 00.48,
									},
									["Sand_"] = {
										["01.OGG"] = 00.26,
										["010.OGG"] = 00.24,
										["011.OGG"] = 00.22,
										["012.OGG"] = 00.18,
										["013.OGG"] = 00.22,
										["014.OGG"] = 00.24,
										["015.OGG"] = 00.22,
										["016.OGG"] = 00.27,
										["017.OGG"] = 00.25,
										["018.OGG"] = 00.28,
										["019.OGG"] = 00.26,
										["02.OGG"] = 00.20,
										["03.OGG"] = 00.19,
										["04.OGG"] = 00.20,
										["05.OGG"] = 00.23,
										["06.OGG"] = 00.22,
										["07.OGG"] = 00.18,
										["08.OGG"] = 00.23,
										["09.OGG"] = 00.19,
									},
									["Stone_"] = {
										["01.OGG"] = 00.23,
										["010.OGG"] = 00.14,
										["011.OGG"] = 00.15,
										["012.OGG"] = 00.15,
										["013.OGG"] = 00.15,
										["014.OGG"] = 00.18,
										["015.OGG"] = 00.14,
										["016.OGG"] = 00.13,
										["017.OGG"] = 00.14,
										["018.OGG"] = 00.12,
										["019.OGG"] = 00.17,
										["02.OGG"] = 00.18,
										["020.OGG"] = 00.13,
										["03.OGG"] = 00.15,
										["04.OGG"] = 00.15,
										["05.OGG"] = 00.13,
										["06.OGG"] = 00.15,
										["07.OGG"] = 00.14,
										["08.OGG"] = 00.16,
										["09.OGG"] = 00.14,
									},
									["Swamp_"] = {
										["01.ogg"] = 00.28,
										["010.ogg"] = 00.24,
										["011.ogg"] = 00.24,
										["012.ogg"] = 00.24,
										["013.ogg"] = 00.19,
										["014.ogg"] = 00.22,
										["015.ogg"] = 00.24,
										["016.ogg"] = 00.20,
										["017.ogg"] = 00.29,
										["018.ogg"] = 00.28,
										["019.ogg"] = 00.32,
										["02.ogg"] = 00.20,
										["020.ogg"] = 00.25,
										["03.ogg"] = 00.25,
										["04.ogg"] = 00.22,
										["05.ogg"] = 00.17,
										["06.ogg"] = 00.20,
										["07.ogg"] = 00.23,
										["08.ogg"] = 00.14,
										["09.ogg"] = 00.24,
									},
									["Wood_"] = {
										["01.OGG"] = 00.29,
										["010.OGG"] = 00.24,
										["011.OGG"] = 00.39,
										["012.OGG"] = 00.41,
										["013.OGG"] = 00.25,
										["014.OGG"] = 00.39,
										["015.OGG"] = 00.24,
										["02.OGG"] = 00.29,
										["03.OGG"] = 00.38,
										["04.OGG"] = 00.36,
										["05.OGG"] = 00.28,
										["06.OGG"] = 00.39,
										["07.OGG"] = 00.32,
										["08.OGG"] = 00.35,
										["09.OGG"] = 00.26,
									},
								},
							},
							["Quadraped_Hooved_"] = {
								["Medium_"] = {
									["Dirt_"] = {
										["01.ogg"] = 00.18,
										["010.ogg"] = 00.19,
										["011.ogg"] = 00.18,
										["012.ogg"] = 00.21,
										["013.ogg"] = 00.22,
										["014.ogg"] = 00.20,
										["015.ogg"] = 00.18,
										["016.ogg"] = 00.22,
										["017.ogg"] = 00.17,
										["018.ogg"] = 00.18,
										["019.ogg"] = 00.20,
										["02.ogg"] = 00.17,
										["020.ogg"] = 00.21,
										["03.ogg"] = 00.20,
										["04.ogg"] = 00.19,
										["05.ogg"] = 00.21,
										["06.ogg"] = 00.19,
										["07.ogg"] = 00.21,
										["08.ogg"] = 00.18,
										["09.ogg"] = 00.21,
									},
									["Glass_"] = {
										["01.ogg"] = 00.44,
										["010.ogg"] = 00.40,
										["011.ogg"] = 00.45,
										["012.ogg"] = 00.33,
										["013.ogg"] = 00.33,
										["014.ogg"] = 00.42,
										["015.ogg"] = 00.35,
										["016.ogg"] = 00.41,
										["017.ogg"] = 00.30,
										["018.ogg"] = 00.43,
										["019.ogg"] = 00.35,
										["02.ogg"] = 00.42,
										["020.ogg"] = 00.33,
										["03.ogg"] = 00.32,
										["04.ogg"] = 00.33,
										["05.ogg"] = 00.34,
										["06.ogg"] = 00.25,
										["07.ogg"] = 00.30,
										["08.ogg"] = 00.34,
										["09.ogg"] = 00.37,
									},
									["Grass_"] = {
										["01.ogg"] = 00.46,
										["010.ogg"] = 00.32,
										["011.ogg"] = 00.35,
										["012.ogg"] = 00.31,
										["013.ogg"] = 00.34,
										["014.ogg"] = 00.35,
										["015.ogg"] = 00.28,
										["016.ogg"] = 00.27,
										["017.ogg"] = 00.32,
										["018.ogg"] = 00.35,
										["019.ogg"] = 00.33,
										["02.ogg"] = 00.30,
										["020.ogg"] = 00.28,
										["03.ogg"] = 00.29,
										["04.ogg"] = 00.28,
										["05.ogg"] = 00.29,
										["06.ogg"] = 00.26,
										["07.ogg"] = 00.30,
										["08.ogg"] = 00.28,
										["09.ogg"] = 00.30,
									},
									["MetalGrate_"] = {
										["01.ogg"] = 00.21,
										["010.ogg"] = 00.19,
										["011.ogg"] = 00.19,
										["012.ogg"] = 00.22,
										["013.ogg"] = 00.24,
										["014.ogg"] = 00.24,
										["015.ogg"] = 00.24,
										["016.ogg"] = 00.23,
										["017.ogg"] = 00.23,
										["018.ogg"] = 00.25,
										["02.ogg"] = 00.26,
										["03.ogg"] = 00.22,
										["04.ogg"] = 00.21,
										["05.ogg"] = 00.18,
										["06.ogg"] = 00.20,
										["07.ogg"] = 00.25,
										["08.ogg"] = 00.25,
										["09.ogg"] = 00.26,
									},
									["Metal_"] = {
										["01.ogg"] = 00.37,
										["010.ogg"] = 00.48,
										["02.ogg"] = 00.47,
										["03.ogg"] = 00.50,
										["04.ogg"] = 00.43,
										["05.ogg"] = 00.42,
										["06.ogg"] = 00.38,
										["07.ogg"] = 00.63,
										["08.ogg"] = 00.64,
										["09.ogg"] = 00.65,
									},
									["Sand_"] = {
										["01.ogg"] = 00.28,
										["010.ogg"] = 00.21,
										["011.ogg"] = 00.13,
										["012.ogg"] = 00.25,
										["013.ogg"] = 00.21,
										["014.ogg"] = 00.28,
										["015.ogg"] = 00.26,
										["016.ogg"] = 00.36,
										["017.ogg"] = 00.24,
										["018.ogg"] = 00.29,
										["019.ogg"] = 00.28,
										["02.ogg"] = 00.30,
										["020.ogg"] = 00.25,
										["03.ogg"] = 00.29,
										["04.ogg"] = 00.15,
										["05.ogg"] = 00.20,
										["06.ogg"] = 00.21,
										["07.ogg"] = 00.21,
										["08.ogg"] = 00.26,
										["09.ogg"] = 00.19,
									},
								},
							},
						},
					},
					["MediumLargeMetalFootsteps\\MediumLargeFootstepMetal_"] = {
						["01.ogg"] = 00.25,
						["02.ogg"] = 00.22,
						["03.ogg"] = 00.26,
						["04.ogg"] = 00.28,
						["05.ogg"] = 00.24,
						["06.ogg"] = 00.24,
						["07.ogg"] = 00.23,
						["08.ogg"] = 00.16,
						["09.ogg"] = 00.24,
						["10.ogg"] = 00.27,
					},
					["PaddedMedium\\MON_"] = {
						["Footstep_Bipedal_"] = {
							["Padded_Medium_"] = {
								["Dirt_"] = {
									["01.ogg"] = 00.26,
									["010.ogg"] = 00.25,
									["011.ogg"] = 00.20,
									["012.ogg"] = 00.21,
									["013.ogg"] = 00.18,
									["014.ogg"] = 00.19,
									["015.ogg"] = 00.22,
									["016.ogg"] = 00.34,
									["017.ogg"] = 00.26,
									["018.ogg"] = 00.24,
									["019.ogg"] = 00.21,
									["02.ogg"] = 00.23,
									["020.ogg"] = 00.23,
									["03.ogg"] = 00.24,
									["04.ogg"] = 00.22,
									["05.ogg"] = 00.21,
									["06.ogg"] = 00.21,
									["07.ogg"] = 00.23,
									["08.ogg"] = 00.16,
									["09.ogg"] = 00.23,
								},
								["Glass_"] = {
									["01.ogg"] = 00.36,
									["010.ogg"] = 00.33,
									["011.ogg"] = 00.31,
									["012.ogg"] = 00.31,
									["013.ogg"] = 00.31,
									["014.ogg"] = 00.28,
									["015.ogg"] = 00.35,
									["016.ogg"] = 00.35,
									["017.ogg"] = 00.31,
									["018.ogg"] = 00.29,
									["02.ogg"] = 00.31,
									["03.ogg"] = 00.35,
									["04.ogg"] = 00.31,
									["05.ogg"] = 00.30,
									["06.ogg"] = 00.35,
									["07.ogg"] = 00.38,
									["08.ogg"] = 00.31,
									["09.ogg"] = 00.28,
								},
								["Grass_"] = {
									["01.ogg"] = 00.39,
									["010.ogg"] = 00.26,
									["011.ogg"] = 00.24,
									["012.ogg"] = 00.28,
									["013.ogg"] = 00.26,
									["014.ogg"] = 00.25,
									["015.ogg"] = 00.14,
									["016.ogg"] = 00.20,
									["017.ogg"] = 00.20,
									["018.ogg"] = 00.27,
									["019.ogg"] = 00.26,
									["02.ogg"] = 00.16,
									["020.ogg"] = 00.20,
									["03.ogg"] = 00.31,
									["04.ogg"] = 00.30,
									["05.ogg"] = 00.30,
									["06.ogg"] = 00.23,
									["07.ogg"] = 00.30,
									["08.ogg"] = 00.21,
									["09.ogg"] = 00.30,
								},
								["MetalGrate_"] = {
									["01.ogg"] = 00.28,
									["010.ogg"] = 00.29,
									["011.ogg"] = 00.28,
									["012.ogg"] = 00.24,
									["013.ogg"] = 00.30,
									["014.ogg"] = 00.24,
									["015.ogg"] = 00.19,
									["016.ogg"] = 00.24,
									["017.ogg"] = 00.27,
									["018.ogg"] = 00.25,
									["02.ogg"] = 00.28,
									["03.ogg"] = 00.34,
									["04.ogg"] = 00.34,
									["05.ogg"] = 00.35,
									["06.ogg"] = 00.31,
									["07.ogg"] = 00.28,
									["08.ogg"] = 00.29,
									["09.ogg"] = 00.21,
								},
								["Metal_"] = {
									["01.ogg"] = 00.33,
									["010.ogg"] = 00.28,
									["011.ogg"] = 00.26,
									["012.ogg"] = 00.33,
									["013.ogg"] = 00.26,
									["014.ogg"] = 00.30,
									["015.ogg"] = 00.31,
									["016.ogg"] = 00.33,
									["02.ogg"] = 00.37,
									["03.ogg"] = 00.33,
									["04.ogg"] = 00.34,
									["05.ogg"] = 00.34,
									["06.ogg"] = 00.30,
									["07.ogg"] = 00.30,
									["08.ogg"] = 00.24,
									["09.ogg"] = 00.24,
								},
								["Sand_"] = {
									["01.ogg"] = 00.36,
									["010.ogg"] = 00.39,
									["02.ogg"] = 00.34,
									["03.ogg"] = 00.40,
									["04.ogg"] = 00.28,
									["05.ogg"] = 00.31,
									["06.ogg"] = 00.26,
									["07.ogg"] = 00.22,
									["08.ogg"] = 00.35,
									["09.ogg"] = 00.28,
								},
								["Stone_"] = {
									["01.ogg"] = 00.14,
									["010.ogg"] = 00.18,
									["011.ogg"] = 00.14,
									["012.ogg"] = 00.15,
									["013.ogg"] = 00.12,
									["014.ogg"] = 00.13,
									["015.ogg"] = 00.31,
									["02.ogg"] = 00.19,
									["03.ogg"] = 00.21,
									["04.ogg"] = 00.17,
									["05.ogg"] = 00.19,
									["06.ogg"] = 00.13,
									["07.ogg"] = 00.16,
									["08.ogg"] = 00.21,
									["09.ogg"] = 00.14,
								},
								["Swamp_"] = {
									["01.ogg"] = 00.30,
									["010.ogg"] = 00.28,
									["011.ogg"] = 00.29,
									["012.ogg"] = 00.28,
									["013.ogg"] = 00.32,
									["014.ogg"] = 00.38,
									["015.ogg"] = 00.29,
									["016.ogg"] = 00.28,
									["017.ogg"] = 00.52,
									["018.ogg"] = 00.31,
									["019.ogg"] = 00.31,
									["02.ogg"] = 00.32,
									["020.ogg"] = 00.31,
									["03.ogg"] = 00.31,
									["04.ogg"] = 00.32,
									["05.ogg"] = 00.29,
									["06.ogg"] = 00.43,
									["07.ogg"] = 00.31,
									["08.ogg"] = 00.32,
									["09.ogg"] = 00.27,
								},
								["Wood_"] = {
									["01.ogg"] = 00.36,
									["010.ogg"] = 00.30,
									["011.ogg"] = 00.30,
									["012.ogg"] = 00.30,
									["013.ogg"] = 00.37,
									["014.ogg"] = 00.30,
									["015.ogg"] = 00.30,
									["016.ogg"] = 00.24,
									["02.ogg"] = 00.27,
									["03.ogg"] = 00.18,
									["04.ogg"] = 00.29,
									["05.ogg"] = 00.26,
									["06.ogg"] = 00.24,
									["07.ogg"] = 00.30,
									["08.ogg"] = 00.29,
									["09.ogg"] = 00.30,
								},
							},
						},
					},
					["WaterSplash\\"] = {
						["FootStepsHugeGiantWaterA.ogg"] = 00.53,
						["FootStepsHugeGiantWaterB.ogg"] = 00.58,
						["FootStepsHugeGiantWaterC.ogg"] = 00.50,
						["FootStepsHugeGiantWaterD.ogg"] = 00.47,
						["FootStepsHugeGiantWaterE.ogg"] = 00.64,
						["FootStepsMediumWaterA.ogg"] = 00.43,
						["FootStepsMediumWaterB.ogg"] = 00.34,
						["FootStepsMediumWaterC.ogg"] = 00.57,
						["FootStepsMediumWaterD.ogg"] = 00.40,
						["FootStepsMediumWaterE.ogg"] = 00.36,
						["FootStepsSmallWaterA.ogg"] = 00.51,
						["FootStepsSmallWaterB.ogg"] = 00.48,
						["FootStepsSmallWaterC.ogg"] = 00.48,
						["FootStepsSmallWaterD.ogg"] = 00.48,
						["FootStepsSmallWaterE.ogg"] = 00.56,
					},
					["Horse_Footstep_"] = {
						["Metal_"] = {
							["01.ogg"] = 00.26,
							["02.ogg"] = 00.25,
							["03.ogg"] = 00.16,
							["04.ogg"] = 00.20,
							["05.ogg"] = 00.20,
							["06.ogg"] = 00.30,
							["07.ogg"] = 00.28,
							["08.ogg"] = 00.30,
							["09.ogg"] = 00.24,
						},
					},
					["MON_"] = {
						["Dinosaur_"] = {
							["Large_Footsteps_"] = {
								["01.OGG"] = 00.89,
								["02.OGG"] = 00.84,
								["03.OGG"] = 00.78,
								["04.OGG"] = 00.81,
								["05.OGG"] = 00.87,
								["06.OGG"] = 00.83,
								["07.OGG"] = 00.88,
								["08.OGG"] = 00.89,
								["09.OGG"] = 00.90,
								["10.OGG"] = 00.86,
							},
							["Medium_Footsteps_"] = {
								["01.OGG"] = 00.83,
								["02.OGG"] = 00.73,
								["03.OGG"] = 00.71,
								["04.OGG"] = 00.68,
								["05.OGG"] = 00.78,
								["06.OGG"] = 00.73,
								["07.OGG"] = 00.83,
								["08.OGG"] = 00.82,
								["09.OGG"] = 00.86,
								["10.OGG"] = 00.79,
							},
						},
						["Insectoid_"] = {
							["Base_FootStep_"] = {
								["01.OGG"] = 00.20,
								["02.OGG"] = 00.23,
								["03.OGG"] = 00.21,
								["04.OGG"] = 00.20,
								["05.OGG"] = 00.27,
								["06.OGG"] = 00.23,
								["07.OGG"] = 00.23,
								["08.OGG"] = 00.24,
								["09.OGG"] = 00.22,
								["10.OGG"] = 00.22,
							},
							["Large_FootStep_"] = {
								["01.OGG"] = 00.49,
								["02.OGG"] = 00.49,
								["03.OGG"] = 00.49,
								["04.OGG"] = 00.49,
								["05.OGG"] = 00.49,
								["06.OGG"] = 00.47,
								["07.OGG"] = 00.50,
								["08.OGG"] = 00.47,
								["09.OGG"] = 00.50,
								["10.OGG"] = 00.51,
							},
							["Medium_FootStep_"] = {
								["01.OGG"] = 00.21,
								["02.OGG"] = 00.23,
								["03.OGG"] = 00.23,
								["04.OGG"] = 00.23,
								["05.OGG"] = 00.23,
								["06.OGG"] = 00.22,
								["07.OGG"] = 00.23,
								["08.OGG"] = 00.22,
								["09.OGG"] = 00.23,
								["10.OGG"] = 00.23,
							},
						},
					},
					["FlyingMountFootstepDirt1.ogg"] = 00.13,
					["FlyingMountFootstepDirt2.ogg"] = 00.14,
					["FlyingMountFootstepDirt3.ogg"] = 00.10,
					["FlyingMountFootstepDirt4.ogg"] = 00.15,
					["FlyingMountFootstepDirt5.ogg"] = 00.17,
					["FlyingMountFootstepDirt6.ogg"] = 00.16,
					["FlyingMountFootstepDirt7.ogg"] = 00.13,
					["FlyingMountFootstepDirt8.ogg"] = 00.18,
					["FlyingMountFootstepDirt9.ogg"] = 00.16,
					["FootstepFishA.ogg"] = 00.14,
					["FootstepFishB.ogg"] = 00.15,
					["FootstepFishC.ogg"] = 00.10,
					["FootstepFishD.ogg"] = 00.10,
					["FootStepsHugeWaterA.ogg"] = 00.53,
					["FootStepsHugeWaterB.ogg"] = 00.58,
					["FootStepsHugeWaterC.ogg"] = 00.50,
					["FootStepsHugeWaterD.ogg"] = 00.47,
					["FootStepsHugeWaterE.ogg"] = 00.64,
					["FootStepsMediumLargeMudA.ogg"] = 00.11,
					["FootStepsMediumLargeMudB.ogg"] = 00.11,
					["FootStepsMediumLargeMudC.ogg"] = 00.08,
					["FootStepsMediumLargeMudD.ogg"] = 00.09,
					["FootStepsMediumLargeMudE.ogg"] = 00.06,
					["mFootHugeDirtA.ogg"] = 00.64,
					["mFootHugeDirtB.ogg"] = 00.68,
					["mFootHugeDirtC.ogg"] = 00.63,
					["mFootHugeDirtD.ogg"] = 00.67,
					["mFootHugeDirtE.ogg"] = 00.67,
					["mFootHugeGiantDirtA.ogg"] = 00.64,
					["mFootHugeGiantDirtB.ogg"] = 00.68,
					["mFootHugeGiantDirtC.ogg"] = 00.63,
					["mFootHugeGiantDirtD.ogg"] = 00.67,
					["mFootHugeGiantDirtE.ogg"] = 00.67,
					["mFootHugeGiantGrassA.ogg"] = 00.61,
					["mFootHugeGiantGrassB.ogg"] = 00.65,
					["mFootHugeGiantGrassC.ogg"] = 00.59,
					["mFootHugeGiantGrassD.ogg"] = 00.63,
					["mFootHugeGiantGrassE.ogg"] = 00.59,
					["mFootHugeGiantSnowA.ogg"] = 00.76,
					["mFootHugeGiantSnowB.ogg"] = 00.82,
					["mFootHugeGiantSnowC.ogg"] = 00.67,
					["mFootHugeGiantSnowD.ogg"] = 00.74,
					["mFootHugeGiantSnowE.ogg"] = 00.60,
					["mFootHugeGiantStoneA.ogg"] = 00.59,
					["mFootHugeGiantStoneB.ogg"] = 00.65,
					["mFootHugeGiantStoneC.ogg"] = 00.65,
					["mFootHugeGiantStoneD.ogg"] = 00.65,
					["mFootHugeGiantStoneE.ogg"] = 00.66,
					["mFootHugeGrassA.ogg"] = 00.61,
					["mFootHugeGrassB.ogg"] = 00.65,
					["mFootHugeGrassC.ogg"] = 00.59,
					["mFootHugeGrassD.ogg"] = 00.63,
					["mFootHugeGrassE.ogg"] = 00.59,
					["mFootHugeSnowA.ogg"] = 00.76,
					["mFootHugeSnowB.ogg"] = 00.82,
					["mFootHugeSnowC.ogg"] = 00.67,
					["mFootHugeSnowD.ogg"] = 00.74,
					["mFootHugeSnowE.ogg"] = 00.60,
					["mFootHugeStoneA.ogg"] = 00.59,
					["mFootHugeStoneB.ogg"] = 00.65,
					["mFootHugeStoneC.ogg"] = 00.65,
					["mFootHugeStoneD.ogg"] = 00.65,
					["mFootHugeStoneE.ogg"] = 00.66,
					["mFootHugeWoodA.ogg"] = 00.77,
					["mFootHugeWoodB.ogg"] = 00.70,
					["mFootHugeWoodC.ogg"] = 00.59,
					["mFootHugeWoodD.ogg"] = 00.58,
					["mFootHugeWoodE.ogg"] = 00.62,
					["mFootMediumLargeDirtA.ogg"] = 00.45,
					["mFootMediumLargeDirtB.ogg"] = 00.52,
					["mFootMediumLargeDirtC.ogg"] = 00.48,
					["mFootMediumLargeDirtD.ogg"] = 00.45,
					["mFootMediumLargeDirtE.ogg"] = 00.46,
					["mFootMediumLargeDirtF.ogg"] = 00.33,
					["mFootMediumLargeDirtG.ogg"] = 00.20,
					["mFootMediumLargeDirtH.ogg"] = 00.38,
					["mFootMediumLargeDirtI.ogg"] = 00.30,
					["mFootMediumLargeGrassA.ogg"] = 00.43,
					["mFootMediumLargeGrassB.ogg"] = 00.35,
					["mFootMediumLargeGrassC.ogg"] = 00.45,
					["mFootMediumLargeGrassD.ogg"] = 00.43,
					["mFootMediumLargeGrassE.ogg"] = 00.43,
					["mFootMediumLargeSnowA.ogg"] = 00.56,
					["mFootMediumLargeSnowB.ogg"] = 00.52,
					["mFootMediumLargeSnowC.ogg"] = 00.47,
					["mFootMediumLargeSnowD.ogg"] = 00.47,
					["mFootMediumLargeSnowE.ogg"] = 00.46,
					["mFootMediumLargeStoneA.ogg"] = 00.29,
					["mFootMediumLargeStoneB.ogg"] = 00.38,
					["mFootMediumLargeStoneC.ogg"] = 00.47,
					["mFootMediumLargeStoneD.ogg"] = 00.36,
					["mFootMediumLargeStoneE.ogg"] = 00.40,
					["mFootMediumLargeStoneF.ogg"] = 00.36,
					["mFootMediumLargeStoneG.ogg"] = 00.24,
					["mFootMediumLargeStoneH.ogg"] = 00.41,
					["mFootMediumLargeStoneI.ogg"] = 00.19,
					["mFootMediumLargeStoneJ.ogg"] = 00.53,
					["mFootMediumLargeWoodA.ogg"] = 00.62,
					["mFootMediumLargeWoodB.ogg"] = 00.33,
					["mFootMediumLargeWoodC.ogg"] = 00.24,
					["mFootMediumLargeWoodD.ogg"] = 00.52,
					["mFootMediumLargeWoodE.ogg"] = 00.60,
					["mFootMediumLargeWoodF.ogg"] = 00.45,
					["mFootMediumLargeWoodG.ogg"] = 00.35,
					["mFootMediumLargeWoodH.ogg"] = 00.59,
					["mFootSmallDirtA.ogg"] = 00.63,
					["mFootSmallDirtB.ogg"] = 00.51,
					["mFootSmallDirtC.ogg"] = 00.53,
					["mFootSmallDirtD.ogg"] = 00.56,
					["mFootSmallDirtE.ogg"] = 00.57,
					["mFootSmallGrassA.ogg"] = 00.37,
					["mFootSmallGrassB.ogg"] = 00.35,
					["mFootSmallGrassC.ogg"] = 00.41,
					["mFootSmallGrassD.ogg"] = 00.43,
					["mFootSmallGrassE.ogg"] = 00.43,
					["mFootSmallSnowA.ogg"] = 00.45,
					["mFootSmallSnowB.ogg"] = 00.49,
					["mFootSmallSnowC.ogg"] = 00.41,
					["mFootSmallSnowD.ogg"] = 00.44,
					["mFootSmallSnowE.ogg"] = 00.40,
					["mFootSmallStoneA.ogg"] = 00.40,
					["mFootSmallStoneB.ogg"] = 00.37,
					["mFootSmallStoneC.ogg"] = 00.35,
					["mFootSmallStoneD.ogg"] = 00.43,
					["mFootSmallStoneE.ogg"] = 00.43,
					["mFootSmallWoodA.ogg"] = 00.41,
					["mFootSmallWoodB.ogg"] = 00.47,
					["mFootSmallWoodC.ogg"] = 00.46,
					["mFootSmallWoodD.ogg"] = 00.41,
					["mFootSmallWoodE.ogg"] = 00.50,
				},
				["Gnome\\"] = {
					["GnomeFemaleErrorMessages\\GnomeFemale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.04,
								["skillnotfound03.ogg"] = 01.57,
								["skillnotfound04.ogg"] = 01.46,
							},
							["abilitycooldown01.ogg"] = 01.56,
							["abilitycooldown02.ogg"] = 01.17,
							["abilitycooldown03.ogg"] = 00.75,
							["alreadyingroup02.ogg"] = 01.95,
							["ammoonly02.ogg"] = 01.49,
							["bagfull01.ogg"] = 01.05,
							["cantcreatehere03.ogg"] = 01.25,
							["cantdropsoulbounditem01.ogg"] = 01.12,
							["cantdropsoulbounditem03.ogg"] = 01.13,
							["cantequipever01.ogg"] = 01.92,
							["cantequiplevel01.ogg"] = 01.86,
							["cantequiplevel02.ogg"] = 01.19,
							["cantequipskill03.ogg"] = 02.40,
							["cantlearnspell01.ogg"] = 01.35,
							["cantloot01.ogg"] = 00.91,
							["canttradesoulbounditem01.ogg"] = 01.10,
							["cantuseitem01.ogg"] = 01.17,
							["chestinuse02.ogg"] = 01.33,
							["genericnotarget01.ogg"] = 01.03,
							["genericnotarget02.ogg"] = 01.75,
							["genericnotarget04.ogg"] = 00.98,
							["guildpermissions01.ogg"] = 01.25,
							["guildpermissions04.ogg"] = 01.63,
							["invalidattacktarget01.ogg"] = 01.44,
							["invalidattacktarget02.ogg"] = 01.16,
							["inventoryfull01.ogg"] = 01.22,
							["inventoryfull02.ogg"] = 01.97,
							["itemcooldown02.ogg"] = 01.37,
							["itemcooldown04.ogg"] = 00.81,
							["itemcooldown06.ogg"] = 01.35,
							["itemlocked01.ogg"] = 00.69,
							["itemmaxcount01.ogg"] = 01.69,
							["lootdidntkill01.ogg"] = 00.91,
							["lootdidntkill06.ogg"] = 01.52,
							["loottoofar02.ogg"] = 01.40,
							["loottoofar03.ogg"] = 00.83,
							["loottoofar04.ogg"] = 00.92,
							["mustequipitem02.ogg"] = 02.01,
							["mustequipitem03.ogg"] = 01.05,
							["noammo05.ogg"] = 01.21,
							["noenergy01.ogg"] = 01.51,
							["noenergy02.ogg"] = 01.27,
							["nomana01.ogg"] = 00.99,
							["nomana02.ogg"] = 01.01,
							["nomana03.ogg"] = 01.31,
							["norage01.ogg"] = 01.47,
							["norage05.ogg"] = 01.26,
							["notabag01.ogg"] = 00.85,
							["notenoughmoney01.ogg"] = 01.71,
							["notenoughmoney02.ogg"] = 00.84,
							["notenoughmoney03.ogg"] = 01.35,
							["notequippable01.ogg"] = 01.01,
							["outofrange02.ogg"] = 01.36,
							["outofrange04.ogg"] = 01.06,
							["outofrange05.ogg"] = 01.20,
							["partyfull03.ogg"] = 01.43,
							["potioncooldown01.ogg"] = 01.30,
							["proficiencyneeded01.ogg"] = 01.24,
							["spellcooldown01.ogg"] = 01.45,
							["spellcooldown02.ogg"] = 01.32,
							["spellcooldown03.ogg"] = 01.26,
						},
					},
					["GnomeMaleErrorMessages\\GnomeMale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 01.51,
								["skillnotfound03.ogg"] = 01.27,
								["skillnotfound04.ogg"] = 01.45,
							},
							["abilitycooldown01.ogg"] = 01.57,
							["abilitycooldown02.ogg"] = 01.14,
							["abilitycooldown03.ogg"] = 00.88,
							["alreadyingroup02.ogg"] = 01.24,
							["ammoonly02.ogg"] = 01.21,
							["bagfull01.ogg"] = 00.97,
							["cantcreatehere03.ogg"] = 01.42,
							["cantdropsoulbounditem01.ogg"] = 01.04,
							["cantdropsoulbounditem03.ogg"] = 01.11,
							["cantequipever01.ogg"] = 01.74,
							["cantequiplevel01.ogg"] = 02.06,
							["cantequiplevel02.ogg"] = 01.26,
							["cantequipskill03.ogg"] = 02.35,
							["cantlearnspell01.ogg"] = 01.37,
							["cantloot01.ogg"] = 01.28,
							["canttradesoulbounditem01.ogg"] = 01.15,
							["cantuseitem01.ogg"] = 01.09,
							["chestinuse02.ogg"] = 01.43,
							["genericnotarget01.ogg"] = 01.26,
							["genericnotarget02.ogg"] = 01.77,
							["genericnotarget04.ogg"] = 01.24,
							["guildpermissions01.ogg"] = 01.14,
							["guildpermissions04.ogg"] = 01.62,
							["invalidattacktarget01.ogg"] = 01.68,
							["invalidattacktarget02.ogg"] = 01.16,
							["inventoryfull01.ogg"] = 01.54,
							["inventoryfull02.ogg"] = 01.31,
							["itemcooldown02.ogg"] = 01.33,
							["itemcooldown04.ogg"] = 00.97,
							["itemcooldown06.ogg"] = 01.03,
							["itemlocked01.ogg"] = 00.80,
							["itemmaxcount01.ogg"] = 01.43,
							["lootdidntkill01.ogg"] = 00.98,
							["lootdidntkill06.ogg"] = 01.11,
							["loottoofar02.ogg"] = 01.01,
							["loottoofar03.ogg"] = 00.89,
							["loottoofar04.ogg"] = 01.12,
							["mustequipitem02.ogg"] = 01.38,
							["mustequipitem03.ogg"] = 01.03,
							["noammo05.ogg"] = 00.96,
							["noenergy01.ogg"] = 00.93,
							["noenergy02.ogg"] = 01.34,
							["nomana01.ogg"] = 01.19,
							["nomana02.ogg"] = 01.18,
							["nomana03.ogg"] = 01.23,
							["norage01.ogg"] = 01.48,
							["norage05.ogg"] = 00.96,
							["notabag01.ogg"] = 01.12,
							["notenoughmoney01.ogg"] = 01.11,
							["notenoughmoney02.ogg"] = 01.00,
							["notenoughmoney03.ogg"] = 01.18,
							["notequippable01.ogg"] = 01.05,
							["outofrange02.ogg"] = 01.01,
							["outofrange04.ogg"] = 01.16,
							["outofrange05.ogg"] = 01.11,
							["partyfull03.ogg"] = 01.59,
							["potioncooldown01.ogg"] = 01.73,
							["proficiencyneeded01.ogg"] = 01.17,
							["spellcooldown01.ogg"] = 01.20,
							["spellcooldown02.ogg"] = 01.37,
							["spellcooldown03.ogg"] = 01.22,
						},
					},
					["GnomeVocalFemale\\"] = {
						["GnomeFemaleAttackMyTarget01.ogg"] = 01.46,
						["GnomeFemaleAttackMyTarget02.ogg"] = 01.72,
						["GnomeFemaleCharge01.ogg"] = 01.73,
						["GnomeFemaleCharge02.ogg"] = 01.26,
						["GnomeFemaleCheer01.ogg"] = 01.19,
						["GnomeFemaleCheer02.ogg"] = 01.18,
						["GnomeFemaleCongratulations01.ogg"] = 01.06,
						["GnomeFemaleCongratulations02.ogg"] = 00.82,
						["GnomeFemaleCongratulations03.ogg"] = 00.85,
						["GnomeFemaleCongratulations04.ogg"] = 00.61,
						["GnomeFemaleFlee01.ogg"] = 00.69,
						["GnomeFemaleFlee02.ogg"] = 01.06,
						["GnomeFemaleFlee03.ogg"] = 00.89,
						["GnomeFemaleFlirt01.ogg"] = 01.62,
						["GnomeFemaleFlirt02.ogg"] = 08.72,
						["GnomeFemaleFlirt03.ogg"] = 02.83,
						["GnomeFemaleFlirt06.ogg"] = 02.95,
						["GnomeFemaleFlirt07.ogg"] = 13.23,
						["GnomeFemaleFollowMe01.ogg"] = 00.79,
						["GnomeFemaleGoodbye01.ogg"] = 00.47,
						["GnomeFemaleGoodbye02.ogg"] = 00.40,
						["GnomeFemaleGoodbye03.ogg"] = 02.24,
						["GnomeFemaleGoodbye04.ogg"] = 02.56,
						["GnomeFemaleHealMe01.ogg"] = 01.59,
						["GnomeFemaleHealMe02.ogg"] = 01.64,
						["GnomeFemaleHello01.ogg"] = 00.37,
						["GnomeFemaleHello02.ogg"] = 00.66,
						["GnomeFemaleHello03.ogg"] = 00.46,
						["GnomeFemaleHelp01.ogg"] = 01.00,
						["GnomeFemaleHelp02.ogg"] = 01.23,
						["GnomeFemaleHelp03.ogg"] = 00.86,
						["GnomeFemaleIncoming01.ogg"] = 01.40,
						["GnomeFemaleNo01.ogg"] = 00.90,
						["GnomeFemaleNo02.ogg"] = 01.33,
						["GnomeFemaleNo03.ogg"] = 01.08,
						["GnomeFemaleOpenFire01.ogg"] = 00.62,
						["GnomeFemaleOpenFire02.ogg"] = 01.38,
						["GnomeFemaleOutOfMana01.ogg"] = 01.60,
						["GnomeFemaleOutOfMana02.ogg"] = 01.05,
						["GnomeFemalePissed01.ogg"] = 04.81,
						["GnomeFemalePissed02.ogg"] = 03.97,
						["GnomeFemalePissed03.ogg"] = 02.70,
						["GnomeFemalePissed04.ogg"] = 02.75,
						["GnomeFemaleRaspberry01.ogg"] = 00.64,
						["GnomeFemaleThankYou01.ogg"] = 01.02,
						["GnomeFemaleThankYou02.ogg"] = 00.86,
						["GnomeFemaleThankYou03.ogg"] = 01.15,
						["GnomeFemaleWaitHere01.ogg"] = 01.22,
						["GnomeFemaleWaitHere02.ogg"] = 00.98,
						["GnomeFemaleYes01.ogg"] = 00.70,
						["GnomeFemaleYes02.ogg"] = 00.79,
						["GnomeFemaleYes03.ogg"] = 01.12,
						["GnomeFemaleYoureWelcome01.ogg"] = 00.62,
						["GnomeFemaleYoureWelcome02.ogg"] = 01.32,
						["GnomeFemaleYoureWelcome03.ogg"] = 00.61,
						["VO_PCGnomeFemaleRoar01.ogg"] = 01.54,
					},
					["GnomeVocalMale\\"] = {
						["GnomeMaleAttackMyTarget01.ogg"] = 01.48,
						["GnomeMaleAttackMyTarget02.ogg"] = 01.49,
						["GnomeMaleCharge01.ogg"] = 00.64,
						["GnomeMaleCharge02.ogg"] = 00.53,
						["GnomeMaleCharge03.ogg"] = 01.96,
						["GnomeMaleCheer01.ogg"] = 01.01,
						["GnomeMaleCheer02.ogg"] = 00.96,
						["GnomeMaleCongratulations01.ogg"] = 01.54,
						["GnomeMaleCongratulations02.ogg"] = 00.58,
						["GnomeMaleCongratulations03.ogg"] = 01.02,
						["GnomeMaleFlee01.ogg"] = 00.64,
						["GnomeMaleFlee02.ogg"] = 00.96,
						["GnomeMaleFlee03.ogg"] = 01.25,
						["GnomeMaleFlirt01.ogg"] = 03.53,
						["GnomeMaleFlirt02.ogg"] = 04.86,
						["GnomeMaleFlirt03.ogg"] = 03.24,
						["GnomeMaleFlirt04.ogg"] = 02.38,
						["GnomeMaleFollowMe01.ogg"] = 00.95,
						["GnomeMaleFollowMe02.ogg"] = 01.25,
						["GnomeMaleGoodbye01.ogg"] = 00.63,
						["GnomeMaleGoodbye02.ogg"] = 00.55,
						["GnomeMaleGoodbye03.ogg"] = 00.88,
						["GnomeMaleGoodbye04.ogg"] = 00.89,
						["GnomeMaleHealMe01.ogg"] = 01.24,
						["GnomeMaleHealMe02.ogg"] = 01.58,
						["GnomeMaleHello01.ogg"] = 00.62,
						["GnomeMaleHello02.ogg"] = 00.73,
						["GnomeMaleHello03.ogg"] = 01.14,
						["GnomeMaleHello04.ogg"] = 00.66,
						["GnomeMaleHelp01.ogg"] = 01.49,
						["GnomeMaleHelp02.ogg"] = 00.92,
						["GnomeMaleIncoming01.ogg"] = 01.21,
						["GnomeMaleNo01.ogg"] = 00.47,
						["GnomeMaleNo02.ogg"] = 00.60,
						["GnomeMaleNo03.ogg"] = 00.89,
						["GnomeMaleOpenFire01.ogg"] = 01.42,
						["GnomeMaleOpenFire02.ogg"] = 00.74,
						["GnomeMaleOutOfMana01.ogg"] = 01.32,
						["GnomeMaleOutOfMana02.ogg"] = 01.31,
						["GnomeMalePissed01.ogg"] = 04.43,
						["GnomeMalePissed02.ogg"] = 05.42,
						["GnomeMalePissed03.ogg"] = 05.00,
						["GnomeMalePissed04.ogg"] = 08.86,
						["GnomeMalePissed05.ogg"] = 10.29,
						["GnomeMalePissed06.ogg"] = 03.12,
						["GnomeMaleRaspberry01.ogg"] = 00.94,
						["GnomeMaleThankYou01.ogg"] = 00.44,
						["GnomeMaleThankYou02.ogg"] = 00.96,
						["GnomeMaleThankYou03.ogg"] = 02.31,
						["GnomeMaleWaitHere01.ogg"] = 01.16,
						["GnomeMaleWaitHere02.ogg"] = 01.11,
						["GnomeMaleYes01.ogg"] = 00.54,
						["GnomeMaleYes02.ogg"] = 00.72,
						["GnomeMaleYes03.ogg"] = 00.82,
						["GnomeMaleYoureWelcome01.ogg"] = 00.92,
						["GnomeMaleYoureWelcome02.ogg"] = 00.88,
						["GnomeMaleYoureWelcome03.ogg"] = 00.86,
						["VO_PCGnomeMaleRoar01.ogg"] = 01.94,
					},
					["GnomeFemaleChicken01.ogg"] = 01.80,
					["GnomeFemaleChooChoo01.ogg"] = 03.62,
					["GnomeFemaleCry01.ogg"] = 02.25,
					["GnomeFemaleKiss01.ogg"] = 01.62,
					["GnomeFemaleLaugh01.ogg"] = 03.62,
					["GnomeFemaleSigh01.ogg"] = 01.34,
					["GnomeFemaleYawn01.ogg"] = 03.51,
					["GnomeMaleChicken01.ogg"] = 03.46,
					["GnomeMaleChooChoo01.ogg"] = 07.09,
					["GnomeMaleCry01.ogg"] = 07.75,
					["GnomeMaleKiss01.ogg"] = 00.79,
					["GnomeMaleLaugh01.ogg"] = 03.30,
					["GnomeMaleSigh01.ogg"] = 01.04,
					["GnomeMaleYawn01.ogg"] = 06.55,
				},
				["Human\\"] = {
					["Female\\"] = {
						["HumanFemaleChicken01.ogg"] = 02.34,
						["HumanFemaleChooChoo01.ogg"] = 04.59,
						["HumanFemaleCry01.ogg"] = 03.48,
						["HumanFemaleKiss01.ogg"] = 01.59,
						["HumanFemaleLaugh01.ogg"] = 03.06,
						["HumanFemaleSigh01.ogg"] = 01.16,
						["HumanFemaleYawn01.ogg"] = 03.69,
						["mHumanFemaleAttackVoxA.ogg"] = 00.44,
						["mHumanFemaleAttackVoxB.ogg"] = 00.37,
						["mHumanFemaleAttackVoxC.ogg"] = 00.79,
						["mHumanFemaleAttackVoxD.ogg"] = 00.33,
						["mHumanFemaleAttackVoxE.ogg"] = 00.60,
						["mHumanFemaleDeathVoxA.ogg"] = 01.05,
						["mHumanFemaleWoundCriticalVoxA.ogg"] = 00.94,
						["mHumanFemaleWoundVoxA.ogg"] = 00.40,
						["mHumanFemaleWoundVoxB.ogg"] = 00.64,
						["mHumanFemaleWoundVoxC.ogg"] = 01.49,
					},
					["FemaleErrorMessages\\HumanFemale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 01.89,
								["skillnotfound03.ogg"] = 01.64,
								["skillnotfound04.ogg"] = 01.17,
							},
							["abilitycooldown01.ogg"] = 01.78,
							["abilitycooldown02.ogg"] = 01.31,
							["abilitycooldown03.ogg"] = 00.95,
							["alreadyingroup02.ogg"] = 01.42,
							["ammoonly02.ogg"] = 01.36,
							["bagfull01.ogg"] = 01.28,
							["cantcreatehere03.ogg"] = 01.27,
							["cantdropsoulbounditem01.ogg"] = 01.03,
							["cantdropsoulbounditem03.ogg"] = 01.05,
							["cantequipever01.ogg"] = 01.68,
							["cantequiplevel01.ogg"] = 01.99,
							["cantequiplevel02.ogg"] = 01.33,
							["cantequipskill03.ogg"] = 02.73,
							["cantlearnspell01.ogg"] = 01.62,
							["cantloot01.ogg"] = 01.17,
							["canttradesoulbounditem01.ogg"] = 01.23,
							["cantuseitem01.ogg"] = 01.34,
							["chestinuse02.ogg"] = 01.45,
							["genericnotarget01.ogg"] = 01.01,
							["genericnotarget02.ogg"] = 01.77,
							["genericnotarget04.ogg"] = 01.15,
							["guildpermissions01.ogg"] = 01.15,
							["guildpermissions04.ogg"] = 01.72,
							["invalidattacktarget01.ogg"] = 01.42,
							["invalidattacktarget02.ogg"] = 01.05,
							["inventoryfull01.ogg"] = 01.38,
							["inventoryfull02.ogg"] = 01.65,
							["itemcooldown02.ogg"] = 01.66,
							["itemcooldown04.ogg"] = 00.97,
							["itemcooldown06.ogg"] = 01.56,
							["itemlocked01.ogg"] = 00.77,
							["itemmaxcount01.ogg"] = 02.11,
							["lootdidntkill01.ogg"] = 01.17,
							["lootdidntkill06.ogg"] = 01.16,
							["loottoofar02.ogg"] = 01.18,
							["loottoofar03.ogg"] = 01.01,
							["loottoofar04.ogg"] = 01.46,
							["mustequipitem02.ogg"] = 01.73,
							["mustequipitem03.ogg"] = 01.29,
							["noammo05.ogg"] = 00.96,
							["noenergy01.ogg"] = 01.29,
							["noenergy02.ogg"] = 01.50,
							["nomana01.ogg"] = 01.03,
							["nomana02.ogg"] = 01.19,
							["nomana03.ogg"] = 01.29,
							["norage01.ogg"] = 01.13,
							["norage05.ogg"] = 01.23,
							["notabag01.ogg"] = 01.04,
							["notenoughmoney01.ogg"] = 01.28,
							["notenoughmoney02.ogg"] = 01.32,
							["notenoughmoney03.ogg"] = 01.29,
							["notequippable01.ogg"] = 01.36,
							["outofrange02.ogg"] = 01.23,
							["outofrange04.ogg"] = 01.02,
							["outofrange05.ogg"] = 01.18,
							["partyfull03.ogg"] = 00.60,
							["potioncooldown01.ogg"] = 01.66,
							["proficiencyneeded01.ogg"] = 01.48,
							["spellcooldown01.ogg"] = 01.42,
							["spellcooldown02.ogg"] = 01.37,
							["spellcooldown03.ogg"] = 01.61,
						},
					},
					["HumanVocalFemale\\"] = {
						["HumanFemaleAttackMyTarget01.ogg"] = 01.02,
						["HumanFemaleAttackMyTarget02.ogg"] = 01.09,
						["HumanFemaleCharge01.ogg"] = 00.59,
						["HumanFemaleCharge02.ogg"] = 00.63,
						["HumanFemaleCheer01.ogg"] = 00.66,
						["HumanFemaleCheer02.ogg"] = 00.97,
						["HumanFemaleCongratulations01.ogg"] = 01.16,
						["HumanFemaleCongratulations02.ogg"] = 00.63,
						["HumanFemaleCongratulations03.ogg"] = 01.20,
						["HumanFemaleFlee01.ogg"] = 00.55,
						["HumanFemaleFlee02.ogg"] = 00.57,
						["HumanFemaleFlirt01.ogg"] = 02.91,
						["HumanFemaleFlirt02.ogg"] = 05.47,
						["HumanFemaleFlirt03.ogg"] = 01.15,
						["HumanFemaleFollowMe01.ogg"] = 00.61,
						["HumanFemaleFollowMe02.ogg"] = 00.89,
						["HumanFemaleGoodbye01.ogg"] = 00.62,
						["HumanFemaleGoodbye02.ogg"] = 01.01,
						["HumanFemaleGoodbye03.ogg"] = 00.83,
						["HumanFemaleHealMe01.ogg"] = 01.18,
						["HumanFemaleHealMe02.ogg"] = 00.71,
						["HumanFemaleHello01.ogg"] = 00.47,
						["HumanFemaleHello02.ogg"] = 00.43,
						["HumanFemaleHello03.ogg"] = 00.62,
						["HumanFemaleHelp01.ogg"] = 01.08,
						["HumanFemaleHelp02.ogg"] = 00.79,
						["HumanFemaleIncoming01.ogg"] = 00.88,
						["HumanFemaleIncoming02.ogg"] = 00.76,
						["HumanFemaleNo01.ogg"] = 00.50,
						["HumanFemaleNo02.ogg"] = 00.73,
						["HumanFemaleNo03.ogg"] = 00.97,
						["HumanFemaleOpenFire01.ogg"] = 00.59,
						["HumanFemaleOpenFire02.ogg"] = 00.51,
						["HumanFemaleOutOfMana01.ogg"] = 01.20,
						["HumanFemaleOutOfMana02.ogg"] = 01.48,
						["HumanFemalePissed01.ogg"] = 04.10,
						["HumanFemalePissed02.ogg"] = 06.13,
						["HumanFemalePissed03.ogg"] = 03.93,
						["HumanFemalePissed04.ogg"] = 01.38,
						["HumanFemalePissed05.ogg"] = 01.60,
						["HumanFemalePissed07.ogg"] = 03.88,
						["HumanFemalePissed08.ogg"] = 02.58,
						["HumanFemalePissed09.ogg"] = 03.82,
						["HumanFemaleRaspberry01.ogg"] = 00.68,
						["HumanFemaleThankYou01.ogg"] = 00.55,
						["HumanFemaleThankYou02.ogg"] = 00.82,
						["HumanFemaleThankYou03.ogg"] = 01.08,
						["HumanFemaleWaitHere01.ogg"] = 00.70,
						["HumanFemaleWaitHere02.ogg"] = 00.70,
						["HumanFemaleWaitHere03.ogg"] = 00.66,
						["HumanFemaleYes01.ogg"] = 00.49,
						["HumanFemaleYes02.ogg"] = 00.49,
						["HumanFemaleYes03.ogg"] = 00.57,
						["HumanFemaleYoureWelcome01.ogg"] = 00.76,
						["HumanFemaleYoureWelcome02.ogg"] = 00.70,
						["HumanFemaleYoureWelcome03.ogg"] = 00.70,
						["VO_PCHumanFemaleRoar01.ogg"] = 01.81,
					},
					["HumanVocalMale\\"] = {
						["HumanMaleAttackMyTarget01.ogg"] = 01.20,
						["HumanMaleAttackMyTarget02.ogg"] = 01.19,
						["HumanMaleCharge01.ogg"] = 00.97,
						["HumanMaleCharge02.ogg"] = 00.86,
						["HumanMaleCheer01.ogg"] = 01.27,
						["HumanMaleCheer02.ogg"] = 01.16,
						["HumanMaleCongratulations01.ogg"] = 01.34,
						["HumanMaleCongratulations02.ogg"] = 00.82,
						["HumanMaleCongratulations03.ogg"] = 00.74,
						["HumanMaleFlee01.ogg"] = 00.63,
						["HumanMaleFlee02.ogg"] = 00.70,
						["HumanMaleFlirt01.ogg"] = 01.01,
						["HumanMaleFlirt02.ogg"] = 03.94,
						["HumanMaleFlirt03.ogg"] = 01.05,
						["HumanMaleFlirt04.ogg"] = 01.08,
						["HumanMaleFlirt05.ogg"] = 04.33,
						["HumanMaleFlirt06.ogg"] = 03.77,
						["HumanMaleFollowMe01.ogg"] = 00.82,
						["HumanMaleFollowMe02.ogg"] = 01.07,
						["HumanMaleGoodbye01.ogg"] = 00.71,
						["HumanMaleGoodbye02.ogg"] = 01.14,
						["HumanMaleGoodbye03.ogg"] = 00.98,
						["HumanMaleHealMe01.ogg"] = 00.98,
						["HumanMaleHealMe02.ogg"] = 00.76,
						["HumanMaleHello01.ogg"] = 00.44,
						["HumanMaleHello02.ogg"] = 01.02,
						["HumanMaleHello03.ogg"] = 00.66,
						["HumanMaleHello04.ogg"] = 00.71,
						["HumanMaleHelp01.ogg"] = 01.47,
						["HumanMaleHelp02.ogg"] = 00.64,
						["HumanMaleIncoming01.ogg"] = 01.18,
						["HumanMaleIncoming02.ogg"] = 01.33,
						["HumanMaleNo01.ogg"] = 00.41,
						["HumanMaleNo02.ogg"] = 00.51,
						["HumanMaleNo03.ogg"] = 01.22,
						["HumanMaleNo04.ogg"] = 00.64,
						["HumanMaleOpenFire01.ogg"] = 01.37,
						["HumanMaleOpenFire02.ogg"] = 01.00,
						["HumanMaleOutOfMana01.ogg"] = 01.06,
						["HumanMaleOutOfMana02.ogg"] = 01.61,
						["HumanMalePissed01.ogg"] = 02.57,
						["HumanMalePissed02.ogg"] = 10.48,
						["HumanMalePissed03.ogg"] = 06.42,
						["HumanMalePissed04.ogg"] = 05.05,
						["HumanMalePissed05.ogg"] = 07.49,
						["HumanMalePissed06.ogg"] = 34.58,
						["HumanMaleRaspberry01.ogg"] = 01.25,
						["HumanMaleThankYou01.ogg"] = 00.59,
						["HumanMaleThankYou02.ogg"] = 01.04,
						["HumanMaleThankYou03.ogg"] = 00.97,
						["HumanMaleWaitHere01.ogg"] = 00.91,
						["HumanMaleWaitHere02.ogg"] = 01.01,
						["HumanMaleWaitHere03.ogg"] = 00.74,
						["HumanMaleYes01.ogg"] = 00.52,
						["HumanMaleYes02.ogg"] = 01.00,
						["HumanMaleYes03.ogg"] = 00.48,
						["HumanMaleYoureWelcome01.ogg"] = 01.48,
						["HumanMaleYoureWelcome02.ogg"] = 01.83,
						["HumanMaleYoureWelcome03.ogg"] = 01.18,
						["VO_PCHumanMaleRoar01.ogg"] = 02.33,
					},
					["Male\\"] = {
						["HumanMaleAggroA.ogg"] = 00.71,
						["HumanMaleAttackA.ogg"] = 00.79,
						["HumanMaleAttackB.ogg"] = 00.67,
						["HumanMaleAttackC.ogg"] = 00.94,
						["HumanMaleAttackD.ogg"] = 00.58,
						["HumanMaleChicken01.ogg"] = 04.34,
						["HumanMaleChooChoo01.ogg"] = 04.28,
						["HumanMaleCry01.ogg"] = 06.66,
						["HumanMaleDeathA.ogg"] = 02.05,
						["HumanMaleKiss01.ogg"] = 00.87,
						["HumanMaleLaugh01.ogg"] = 02.23,
						["HumanMalePreAggroA.ogg"] = 00.30,
						["HumanMaleSigh01.ogg"] = 01.44,
						["HumanMaleWoundA.ogg"] = 00.36,
						["HumanMaleWoundB.ogg"] = 00.32,
						["HumanMaleWoundC.ogg"] = 00.46,
						["HumanMaleWoundCritA.ogg"] = 00.80,
						["HumanMaleWoundCritB.ogg"] = 00.66,
						["HumanMaleWoundD.ogg"] = 00.49,
						["HumanMaleYawn01.ogg"] = 03.65,
					},
					["MaleErrorMessages\\HumanMale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 01.88,
								["skillnotfound03.ogg"] = 01.52,
								["skillnotfound04.ogg"] = 01.66,
							},
							["abilitycooldown01.ogg"] = 02.04,
							["abilitycooldown02.ogg"] = 01.34,
							["abilitycooldown03.ogg"] = 01.07,
							["alreadyingroup02.ogg"] = 01.77,
							["ammoonly02.ogg"] = 01.33,
							["bagfull01.ogg"] = 01.29,
							["cantcreatehere03.ogg"] = 01.34,
							["cantdropsoulbounditem01.ogg"] = 01.35,
							["cantdropsoulbounditem03.ogg"] = 01.27,
							["cantequipever01.ogg"] = 02.01,
							["cantequiplevel01.ogg"] = 02.73,
							["cantequiplevel02.ogg"] = 01.33,
							["cantequipskill03.ogg"] = 02.99,
							["cantlearnspell01.ogg"] = 01.41,
							["cantloot01.ogg"] = 01.31,
							["canttradesoulbounditem01.ogg"] = 01.04,
							["cantuseitem01.ogg"] = 01.12,
							["chestinuse02.ogg"] = 01.51,
							["genericnotarget01.ogg"] = 01.15,
							["genericnotarget02.ogg"] = 01.94,
							["genericnotarget04.ogg"] = 00.85,
							["guildpermissions01.ogg"] = 01.08,
							["guildpermissions04.ogg"] = 01.50,
							["invalidattacktarget01.ogg"] = 01.62,
							["invalidattacktarget02.ogg"] = 01.41,
							["inventoryfull01.ogg"] = 01.24,
							["inventoryfull02.ogg"] = 01.42,
							["itemcooldown02.ogg"] = 01.62,
							["itemcooldown04.ogg"] = 01.03,
							["itemcooldown06.ogg"] = 01.40,
							["itemlocked01.ogg"] = 00.83,
							["itemmaxcount01.ogg"] = 01.87,
							["lootdidntkill01.ogg"] = 01.07,
							["lootdidntkill06.ogg"] = 01.24,
							["loottoofar02.ogg"] = 01.19,
							["loottoofar03.ogg"] = 01.03,
							["loottoofar04.ogg"] = 01.30,
							["mustequipitem02.ogg"] = 01.96,
							["mustequipitem03.ogg"] = 01.18,
							["noammo05.ogg"] = 00.92,
							["noenergy01.ogg"] = 01.33,
							["noenergy02.ogg"] = 01.51,
							["nomana01.ogg"] = 01.05,
							["nomana02.ogg"] = 01.15,
							["nomana03.ogg"] = 01.31,
							["norage01.ogg"] = 01.23,
							["norage05.ogg"] = 01.66,
							["notabag01.ogg"] = 01.17,
							["notenoughmoney01.ogg"] = 00.98,
							["notenoughmoney02.ogg"] = 01.07,
							["notenoughmoney03.ogg"] = 01.12,
							["notequippable01.ogg"] = 00.97,
							["outofrange02.ogg"] = 01.20,
							["outofrange04.ogg"] = 01.29,
							["outofrange05.ogg"] = 01.20,
							["partyfull03.ogg"] = 01.66,
							["potioncooldown01.ogg"] = 01.85,
							["proficiencyneeded01.ogg"] = 01.29,
							["spellcooldown01.ogg"] = 02.01,
							["spellcooldown02.ogg"] = 01.48,
							["spellcooldown03.ogg"] = 01.33,
						},
					},
					["MaleNPC\\"] = {
						["HumanMalePirate\\"] = {
							["HumanMalePirateAggroA.ogg"] = 01.83,
							["HumanMalePirateAttackA.ogg"] = 00.55,
							["HumanMalePirateAttackB.ogg"] = 00.35,
							["HumanMalePirateAttackC.ogg"] = 00.35,
							["HumanMalePirateDeathA.ogg"] = 01.78,
							["HumanMalePiratePreAggro.ogg"] = 00.33,
							["HumanMalePirateWoundA.ogg"] = 00.48,
							["HumanMalePirateWoundB.ogg"] = 00.33,
							["HumanMalePirateWoundC.ogg"] = 00.78,
							["HumanMalePirateWoundCrit.ogg"] = 01.06,
						},
						["HumanMalePirateHeavy\\"] = {
							["HumanMalePirateHeavyAggro.ogg"] = 00.94,
							["HumanMalePirateHeavyAttackA.ogg"] = 00.62,
							["HumanMalePirateHeavyAttackB.ogg"] = 00.81,
							["HumanMalePirateHeavyAttackC.ogg"] = 00.36,
							["HumanMalePirateHeavyDeath.ogg"] = 01.73,
							["HumanMalePirateHeavyPreAggro.ogg"] = 00.72,
							["HumanMalePirateHeavyWoundA.ogg"] = 00.46,
							["HumanMalePirateHeavyWoundB.ogg"] = 00.42,
							["HumanMalePirateHeavyWoundC.ogg"] = 00.41,
							["HumanMalePirateHeavyWoundCRit.ogg"] = 01.05,
						},
						["HumanPesantMale\\"] = {
							["HumanPesantMaleAggro.ogg"] = 00.47,
							["HumanPesantMaleAttackA.ogg"] = 00.56,
							["HumanPesantMaleAttackB.ogg"] = 00.91,
							["HumanPesantMaleAttackC.ogg"] = 00.50,
							["HumanPesantMaleDeathA.ogg"] = 01.44,
							["HumanPesantMalePreAggro.ogg"] = 00.55,
							["HumanPesantMaleWoundA.ogg"] = 00.81,
							["HumanPesantMaleWoundB.ogg"] = 00.56,
							["HumanPesantMaleWoundC.ogg"] = 00.61,
							["HumanPesantMaleWoundCrit.ogg"] = 00.81,
						},
						["HumanWarrior1\\"] = {
							["HumanWarrior1Aggro.ogg"] = 00.78,
							["HumanWarrior1AttackA.ogg"] = 00.56,
							["HumanWarrior1AttackB.ogg"] = 00.73,
							["HumanWarrior1AttackC.ogg"] = 00.52,
							["HumanWarrior1DeathA.ogg"] = 03.02,
							["HumanWarrior1PreAggro.ogg"] = 00.33,
							["HumanWarrior1WoundA.ogg"] = 00.45,
							["HumanWarrior1WoundB.ogg"] = 00.50,
							["HumanWarrior1WoundC.ogg"] = 00.51,
							["HumanWarrior1WoundCrit.ogg"] = 00.77,
						},
						["HumanWarrior2\\"] = {
							["HumanMaleWarrior2Aggro.ogg"] = 00.49,
							["HumanMaleWarrior2AttackA.ogg"] = 00.57,
							["HumanMaleWarrior2AttackB.ogg"] = 00.52,
							["HumanMaleWarrior2AttackC.ogg"] = 00.61,
							["HumanMaleWarrior2Death.ogg"] = 02.80,
							["HumanMaleWarrior2PreAggro.ogg"] = 00.37,
							["HumanMaleWarrior2WoundA.ogg"] = 00.40,
							["HumanMaleWarrior2WoundB.ogg"] = 00.52,
							["HumanMaleWarrior2WoundC.ogg"] = 00.34,
							["HumanMaleWarrior2WoundCrit.ogg"] = 01.11,
						},
						["HumanWarrior3\\"] = {
							["HumanMaleNPC3AttackA.ogg"] = 00.53,
							["HumanMaleNPC3AttackB.ogg"] = 00.60,
							["HumanMaleNPC3AttadkC.ogg"] = 00.51,
							["HumanMaleNPC3Death.ogg"] = 02.51,
							["HumanMaleNPC3WoundA.ogg"] = 00.80,
							["HumanMaleNPC3WoundB.ogg"] = 00.73,
							["HumanMaleNPC3WoundC.ogg"] = 00.35,
							["HumanMaleNPC3WoundCrit.ogg"] = 01.13,
						},
					},
					["HumanMale_CustomSpell04_"] = {
						["Knocking01.ogg"] = 01.87,
						["Knocking02.ogg"] = 01.87,
						["Knocking03.ogg"] = 01.87,
					},
				},
				["NightElf\\"] = {
					["NightElfFemale\\"] = {
						["NightElfFemaleAttackA.ogg"] = 00.67,
						["NightElfFemaleAttackB.ogg"] = 00.59,
						["NightElfFemaleAttackC.ogg"] = 00.42,
						["NightElfFemaleAttackD.ogg"] = 00.39,
						["NightElfFemaleChicken01.ogg"] = 02.63,
						["NightElfFemaleChooChoo01.ogg"] = 03.88,
						["NightElfFemaleCry01.ogg"] = 07.74,
						["NightElfFemaleDeath.ogg"] = 01.05,
						["NightElfFemaleKiss01.ogg"] = 01.33,
						["NightElfFemaleLaugh01.ogg"] = 03.42,
						["NightElfFemaleSigh01.ogg"] = 01.48,
						["NightElfFemaleWoundA.ogg"] = 00.31,
						["NightElfFemaleWoundB.ogg"] = 00.38,
						["NightElfFemaleWoundC.ogg"] = 00.31,
						["NightElfFemaleWoundCrit.ogg"] = 00.60,
						["NightElfFemaleYawn01.ogg"] = 02.32,
					},
					["NightElfFemaleErrorMessages\\NightElfFemale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.15,
								["skillnotfound03.ogg"] = 01.49,
								["skillnotfound04.ogg"] = 01.69,
							},
							["abilitycooldown01.ogg"] = 01.85,
							["abilitycooldown02.ogg"] = 01.37,
							["abilitycooldown03.ogg"] = 01.05,
							["alreadyingroup02.ogg"] = 01.70,
							["ammoonly02.ogg"] = 01.42,
							["bagfull01.ogg"] = 01.16,
							["cantcreatehere03.ogg"] = 01.45,
							["cantdropsoulbounditem01.ogg"] = 01.08,
							["cantdropsoulbounditem03.ogg"] = 01.53,
							["cantequipever01.ogg"] = 01.81,
							["cantequiplevel01.ogg"] = 02.32,
							["cantequiplevel02.ogg"] = 01.58,
							["cantequipskill03.ogg"] = 02.57,
							["cantlearnspell01.ogg"] = 01.66,
							["cantloot01.ogg"] = 01.07,
							["canttradesoulbounditem01.ogg"] = 01.18,
							["cantuseitem01.ogg"] = 01.18,
							["chestinuse02.ogg"] = 01.69,
							["genericnotarget01.ogg"] = 01.27,
							["genericnotarget02.ogg"] = 02.03,
							["genericnotarget04.ogg"] = 01.00,
							["guildpermissions01.ogg"] = 01.02,
							["guildpermissions04.ogg"] = 01.53,
							["invalidattacktarget01.ogg"] = 01.64,
							["invalidattacktarget02.ogg"] = 01.42,
							["inventoryfull01.ogg"] = 01.33,
							["inventoryfull02.ogg"] = 01.54,
							["itemcooldown02.ogg"] = 01.82,
							["itemcooldown04.ogg"] = 01.15,
							["itemcooldown06.ogg"] = 01.34,
							["itemlocked01.ogg"] = 00.94,
							["itemmaxcount01.ogg"] = 01.77,
							["lootdidntkill01.ogg"] = 01.07,
							["lootdidntkill06.ogg"] = 01.47,
							["loottoofar02.ogg"] = 01.24,
							["loottoofar03.ogg"] = 00.99,
							["loottoofar04.ogg"] = 01.31,
							["mustequipitem02.ogg"] = 01.90,
							["mustequipitem03.ogg"] = 01.43,
							["noammo05.ogg"] = 01.44,
							["noenergy01.ogg"] = 01.39,
							["noenergy02.ogg"] = 01.95,
							["nomana01.ogg"] = 01.17,
							["nomana02.ogg"] = 01.17,
							["nomana03.ogg"] = 01.26,
							["norage01.ogg"] = 01.41,
							["norage05.ogg"] = 01.57,
							["notabag01.ogg"] = 01.12,
							["notenoughmoney01.ogg"] = 01.45,
							["notenoughmoney02.ogg"] = 01.38,
							["notenoughmoney03.ogg"] = 01.32,
							["notequippable01.ogg"] = 01.15,
							["outofrange02.ogg"] = 01.47,
							["outofrange04.ogg"] = 01.08,
							["outofrange05.ogg"] = 01.16,
							["partyfull03.ogg"] = 01.72,
							["potioncooldown01.ogg"] = 01.81,
							["proficiencyneeded01.ogg"] = 01.31,
							["spellcooldown01.ogg"] = 01.78,
							["spellcooldown02.ogg"] = 01.43,
							["spellcooldown03.ogg"] = 01.40,
						},
					},
					["NightElfMale\\"] = {
						["NightElfMaleAttackA.ogg"] = 00.54,
						["NightElfMaleAttackB.ogg"] = 00.28,
						["NightElfMaleAttackC.ogg"] = 00.63,
						["NightElfMaleChicken01.ogg"] = 03.09,
						["NightElfMaleChooChoo01.ogg"] = 05.05,
						["NightElfMaleCry01.ogg"] = 03.54,
						["NightElfMaleDeathA.ogg"] = 01.09,
						["NightElfMaleKiss01.ogg"] = 00.92,
						["NightElfMaleLaugh01.ogg"] = 03.58,
						["NightElfMaleSigh01.ogg"] = 01.85,
						["NightElfMaleWoundA.ogg"] = 00.49,
						["NightElfMaleWoundB.ogg"] = 00.39,
						["NightElfMaleWoundC.ogg"] = 00.53,
						["NightElfMaleWoundCrit.ogg"] = 00.64,
						["NightElfMaleYawn01.ogg"] = 05.20,
					},
					["NightElfMaleErrorMessages\\NightElfMale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 01.73,
								["skillnotfound03.ogg"] = 01.41,
								["skillnotfound04.ogg"] = 01.50,
							},
							["abilitycooldown01.ogg"] = 01.56,
							["abilitycooldown02.ogg"] = 01.19,
							["abilitycooldown03.ogg"] = 00.94,
							["alreadyingroup02.ogg"] = 01.36,
							["ammoonly02.ogg"] = 01.17,
							["bagfull01.ogg"] = 01.12,
							["cantcreatehere03.ogg"] = 01.32,
							["cantdropsoulbounditem01.ogg"] = 01.12,
							["cantdropsoulbounditem03.ogg"] = 01.04,
							["cantequipever01.ogg"] = 01.76,
							["cantequiplevel01.ogg"] = 02.09,
							["cantequiplevel02.ogg"] = 01.25,
							["cantequipskill03.ogg"] = 02.62,
							["cantlearnspell01.ogg"] = 01.46,
							["cantloot01.ogg"] = 00.95,
							["canttradesoulbounditem01.ogg"] = 01.07,
							["cantuseitem01.ogg"] = 01.08,
							["chestinuse02.ogg"] = 01.70,
							["genericnotarget01.ogg"] = 01.02,
							["genericnotarget02.ogg"] = 01.71,
							["genericnotarget04.ogg"] = 00.98,
							["guildpermissions01.ogg"] = 00.90,
							["guildpermissions04.ogg"] = 01.49,
							["invalidattacktarget01.ogg"] = 01.48,
							["invalidattacktarget02.ogg"] = 01.14,
							["inventoryfull01.ogg"] = 01.16,
							["inventoryfull02.ogg"] = 01.48,
							["itemcooldown02.ogg"] = 01.59,
							["itemcooldown04.ogg"] = 01.05,
							["itemcooldown06.ogg"] = 01.11,
							["itemlocked01.ogg"] = 00.82,
							["itemmaxcount01.ogg"] = 01.71,
							["lootdidntkill01.ogg"] = 01.04,
							["lootdidntkill06.ogg"] = 01.38,
							["loottoofar02.ogg"] = 01.20,
							["loottoofar03.ogg"] = 00.89,
							["loottoofar04.ogg"] = 01.06,
							["mustequipitem02.ogg"] = 01.72,
							["mustequipitem03.ogg"] = 01.18,
							["noammo05.ogg"] = 00.91,
							["noenergy01.ogg"] = 01.06,
							["noenergy02.ogg"] = 01.30,
							["nomana01.ogg"] = 01.00,
							["nomana02.ogg"] = 01.05,
							["nomana03.ogg"] = 01.32,
							["norage01.ogg"] = 01.09,
							["norage05.ogg"] = 01.11,
							["notabag01.ogg"] = 00.94,
							["notenoughmoney01.ogg"] = 00.98,
							["notenoughmoney02.ogg"] = 01.24,
							["notenoughmoney03.ogg"] = 01.03,
							["notequippable01.ogg"] = 01.30,
							["outofrange02.ogg"] = 01.11,
							["outofrange04.ogg"] = 01.08,
							["outofrange05.ogg"] = 01.11,
							["partyfull03.ogg"] = 01.46,
							["potioncooldown01.ogg"] = 01.54,
							["proficiencyneeded01.ogg"] = 01.26,
							["spellcooldown01.ogg"] = 01.60,
							["spellcooldown02.ogg"] = 01.45,
							["spellcooldown03.ogg"] = 01.32,
						},
					},
					["NightElfVocalFemale\\"] = {
						["NightElfFemaleAttackMyTarget01.ogg"] = 01.56,
						["NightElfFemaleAttackMyTarget02.ogg"] = 00.82,
						["NightElfFemaleAttackMyTarget03.ogg"] = 01.44,
						["NightElfFemaleCharge01.ogg"] = 01.15,
						["NightElfFemaleCharge02.ogg"] = 01.47,
						["NightElfFemaleCharge03.ogg"] = 01.39,
						["NightElfFemaleCheer01.ogg"] = 01.68,
						["NightElfFemaleCheer02.ogg"] = 02.15,
						["NightElfFemaleCongratulations01.ogg"] = 01.55,
						["NightElfFemaleCongratulations02.ogg"] = 01.37,
						["NightElfFemaleCongratulations03.ogg"] = 01.11,
						["NightElfFemaleFlee01.ogg"] = 00.65,
						["NightElfFemaleFlee02.ogg"] = 01.85,
						["NightElfFemaleFlirt01.ogg"] = 03.75,
						["NightElfFemaleFlirt02.ogg"] = 02.45,
						["NightElfFemaleFlirt03.ogg"] = 03.45,
						["NightElfFemaleFlirt04.ogg"] = 03.68,
						["NightElfFemaleFollowMe01.ogg"] = 01.02,
						["NightElfFemaleFollowMe02.ogg"] = 00.91,
						["NightElfFemaleGoodbye01.ogg"] = 00.67,
						["NightElfFemaleGoodbye02.ogg"] = 01.26,
						["NightElfFemaleGoodbye03.ogg"] = 01.16,
						["NightElfFemaleHealMe01.ogg"] = 01.03,
						["NightElfFemaleHealMe02.ogg"] = 01.36,
						["NightElfFemaleHello01.ogg"] = 00.76,
						["NightElfFemaleHello02.ogg"] = 00.85,
						["NightElfFemaleHello03.ogg"] = 00.79,
						["NightElfFemaleHello04.ogg"] = 00.45,
						["NightElfFemaleHelp01.ogg"] = 00.81,
						["NightElfFemaleHelp02.ogg"] = 01.05,
						["NightElfFemaleIncoming01.ogg"] = 00.67,
						["NightElfFemaleIncoming02.ogg"] = 00.93,
						["NightElfFemaleNo01.ogg"] = 00.77,
						["NightElfFemaleNo02.ogg"] = 01.15,
						["NightElfFemaleNo03.ogg"] = 01.97,
						["NightElfFemaleOpenFire01.ogg"] = 00.95,
						["NightElfFemaleOpenFire02.ogg"] = 00.79,
						["NightElfFemaleOutOfMana01.ogg"] = 01.58,
						["NightElfFemaleOutOfMana02.ogg"] = 01.82,
						["NightElfFemalePissed01.ogg"] = 03.84,
						["NightElfFemalePissed02.ogg"] = 02.43,
						["NightElfFemalePissed03.ogg"] = 04.32,
						["NightElfFemalePissed04.ogg"] = 05.43,
						["NightElfFemalePissed05.ogg"] = 04.91,
						["NightElfFemaleRaspberry01.ogg"] = 01.20,
						["NightElfFemaleThankYou01.ogg"] = 00.61,
						["NightElfFemaleThankYou02.ogg"] = 01.40,
						["NightElfFemaleThankYou03.ogg"] = 01.17,
						["NightElfFemaleWaitHere01.ogg"] = 01.19,
						["NightElfFemaleWaitHere02.ogg"] = 00.76,
						["NightElfFemaleYes01.ogg"] = 00.59,
						["NightElfFemaleYes02.ogg"] = 00.85,
						["NightElfFemaleYes03.ogg"] = 00.91,
						["NightElfFemaleYoureWelcome01.ogg"] = 01.29,
						["NightElfFemaleYoureWelcome02.ogg"] = 01.07,
						["NightElfFemaleYoureWelcome03.ogg"] = 01.56,
						["VO_PCNightElfFemaleRoar01.ogg"] = 01.93,
					},
					["NightElfVocalMale\\"] = {
						["NightElfMaleAttackMyTarget01.ogg"] = 01.59,
						["NightElfMaleAttackMyTarget02.ogg"] = 01.59,
						["NightElfMaleCharge01.ogg"] = 01.30,
						["NightElfMaleCharge02.ogg"] = 00.72,
						["NightElfMaleCheer01.ogg"] = 01.33,
						["NightElfMaleCheer02.ogg"] = 01.79,
						["NightElfMaleCongratulations01.ogg"] = 02.11,
						["NightElfMaleCongratulations02.ogg"] = 01.41,
						["NightElfMaleCongratulations03.ogg"] = 01.38,
						["NightElfMaleFlee01.ogg"] = 01.12,
						["NightElfMaleFlee02.ogg"] = 00.78,
						["NightElfMaleFlirt01.ogg"] = 02.42,
						["NightElfMaleFlirt02.ogg"] = 02.62,
						["NightElfMaleFlirt03.ogg"] = 03.37,
						["NightElfMaleFlirt04.ogg"] = 02.18,
						["NightElfMaleFlirt05.ogg"] = 02.56,
						["NightElfMaleFollowMe01.ogg"] = 01.00,
						["NightElfMaleFollowMe02.ogg"] = 00.64,
						["NightElfMaleGoodbye01.ogg"] = 00.81,
						["NightElfMaleGoodbye02.ogg"] = 00.70,
						["NightElfMaleGoodbye03.ogg"] = 01.20,
						["NightElfMaleHealMe01.ogg"] = 01.01,
						["NightElfMaleHealMe02.ogg"] = 01.34,
						["NightElfMaleHello01.ogg"] = 00.95,
						["NightElfMaleHello02.ogg"] = 00.76,
						["NightElfMaleHello03.ogg"] = 00.76,
						["NightElfMaleHelp01.ogg"] = 00.61,
						["NightElfMaleHelp02.ogg"] = 00.86,
						["NightElfMaleHelp03.ogg"] = 00.73,
						["NightElfMaleIncoming01.ogg"] = 00.78,
						["NightElfMaleIncoming02.ogg"] = 00.63,
						["NightElfMaleNo01.ogg"] = 00.75,
						["NightElfMaleNo02.ogg"] = 01.39,
						["NightElfMaleNo03.ogg"] = 01.29,
						["NightElfMaleOpenFire01.ogg"] = 01.07,
						["NightElfMaleOpenFire02.ogg"] = 00.49,
						["NightElfMaleOutOfMana01.ogg"] = 01.27,
						["NightElfMaleOutOfMana02.ogg"] = 01.66,
						["NightElfMalePissed01.ogg"] = 02.85,
						["NightElfMalePissed02.ogg"] = 03.76,
						["NightElfMalePissed04.ogg"] = 04.00,
						["NightElfMalePissed05.ogg"] = 04.83,
						["NightElfMalePissed06.ogg"] = 05.37,
						["NightElfMalePissed07.ogg"] = 01.78,
						["NightElfMalePissed08.ogg"] = 01.47,
						["NightElfMalePissed09.ogg"] = 03.42,
						["NightElfMaleRaspberry01.ogg"] = 01.42,
						["NightElfMaleThankYou01.ogg"] = 00.90,
						["NightElfMaleThankYou02.ogg"] = 00.97,
						["NightElfMaleThankYou03.ogg"] = 01.43,
						["NightElfMaleWaitHere01.ogg"] = 01.02,
						["NightElfMaleWaitHere02.ogg"] = 00.94,
						["NightElfMaleYes01.ogg"] = 00.76,
						["NightElfMaleYes02.ogg"] = 01.03,
						["NightElfMaleYes03.ogg"] = 00.91,
						["NightElfMaleYoureWelcome01.ogg"] = 00.77,
						["NightElfMaleYoureWelcome02.ogg"] = 00.92,
						["NightElfMaleYoureWelcome03.ogg"] = 01.65,
						["VO_PCNightElfMaleRoar01.ogg"] = 03.61,
					},
				},
				["Orc\\"] = {
					["Female\\"] = {
						["mOrcFemaleAttackCriticalVoxA.ogg"] = 01.09,
						["mOrcFemaleAttackVoxA.ogg"] = 00.97,
						["mOrcFemaleAttackVoxB.ogg"] = 00.85,
						["mOrcFemaleAttackVoxC.ogg"] = 00.91,
						["mOrcFemaleDeathVoxA.ogg"] = 02.09,
						["mOrcFemaleStandVoxA.ogg"] = 01.68,
						["mOrcFemaleStandVoxB.ogg"] = 01.29,
						["mOrcFemaleStandVoxC.ogg"] = 01.68,
						["mOrcFemaleStunVoxA.ogg"] = 02.71,
						["mOrcFemaleStunVoxB.ogg"] = 04.22,
						["mOrcFemaleStunVoxC.ogg"] = 03.54,
						["mOrcFemaleWoundCriticalVoxA.ogg"] = 01.43,
						["mOrcFemaleWoundVoxA.ogg"] = 01.15,
						["mOrcFemaleWoundVoxB.ogg"] = 01.05,
						["mOrcFemaleWoundVoxC.ogg"] = 00.87,
						["OrcFemaleChicken01.ogg"] = 02.48,
						["OrcFemaleChooChoo01.ogg"] = 05.24,
						["OrcFemaleCry01.ogg"] = 04.85,
						["OrcFemaleKiss01.ogg"] = 02.76,
						["OrcFemaleLaugh01.ogg"] = 03.42,
						["OrcFemaleSigh01.ogg"] = 02.31,
						["OrcFemaleYawn01.ogg"] = 03.14,
					},
					["OrcFemaleErrorMessages\\OrcFemale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.05,
								["skillnotfound03.ogg"] = 01.43,
								["skillnotfound04.ogg"] = 01.71,
							},
							["abilitycooldown01.ogg"] = 01.94,
							["abilitycooldown02.ogg"] = 01.39,
							["abilitycooldown03.ogg"] = 01.02,
							["alreadyingroup02.ogg"] = 01.65,
							["ammoonly02.ogg"] = 01.22,
							["bagfull01.ogg"] = 01.18,
							["cantcreatehere03.ogg"] = 01.17,
							["cantdropsoulbounditem01.ogg"] = 01.16,
							["cantdropsoulbounditem03.ogg"] = 01.37,
							["cantequipever01.ogg"] = 01.62,
							["cantequiplevel01.ogg"] = 02.09,
							["cantequiplevel02.ogg"] = 01.35,
							["cantequipskill03.ogg"] = 02.62,
							["cantlearnspell01.ogg"] = 01.62,
							["cantloot01.ogg"] = 01.18,
							["canttradesoulbounditem01.ogg"] = 01.62,
							["cantuseitem01.ogg"] = 01.14,
							["chestinuse02.ogg"] = 01.54,
							["genericnotarget01.ogg"] = 01.37,
							["genericnotarget02.ogg"] = 01.93,
							["genericnotarget04.ogg"] = 01.29,
							["guildpermissions01.ogg"] = 00.96,
							["guildpermissions04.ogg"] = 01.75,
							["invalidattacktarget01.ogg"] = 01.67,
							["invalidattacktarget02.ogg"] = 01.17,
							["inventoryfull01.ogg"] = 01.46,
							["inventoryfull02.ogg"] = 01.66,
							["itemcooldown02.ogg"] = 01.67,
							["itemcooldown04.ogg"] = 01.36,
							["itemcooldown06.ogg"] = 01.28,
							["itemlocked01.ogg"] = 00.80,
							["itemmaxcount01.ogg"] = 02.06,
							["lootdidntkill01.ogg"] = 01.18,
							["lootdidntkill06.ogg"] = 01.21,
							["loottoofar02.ogg"] = 01.54,
							["loottoofar03.ogg"] = 01.00,
							["loottoofar04.ogg"] = 01.31,
							["mustequipitem02.ogg"] = 01.74,
							["mustequipitem03.ogg"] = 01.42,
							["noammo05.ogg"] = 01.04,
							["noenergy01.ogg"] = 01.45,
							["noenergy02.ogg"] = 01.82,
							["nomana01.ogg"] = 01.13,
							["nomana02.ogg"] = 01.21,
							["nomana03.ogg"] = 01.22,
							["norage01.ogg"] = 01.40,
							["norage05.ogg"] = 01.74,
							["notabag01.ogg"] = 01.20,
							["notenoughmoney01.ogg"] = 01.19,
							["notenoughmoney02.ogg"] = 01.30,
							["notenoughmoney03.ogg"] = 01.17,
							["notequippable01.ogg"] = 01.20,
							["outofrange02.ogg"] = 01.49,
							["outofrange04.ogg"] = 01.09,
							["outofrange05.ogg"] = 01.22,
							["partyfull03.ogg"] = 01.86,
							["potioncooldown01.ogg"] = 01.70,
							["proficiencyneeded01.ogg"] = 01.32,
							["spellcooldown01.ogg"] = 01.75,
							["spellcooldown02.ogg"] = 01.59,
							["spellcooldown03.ogg"] = 01.71,
						},
					},
					["OrcMale\\"] = {
						["OrcMaleAttackA.ogg"] = 00.47,
						["OrcMaleAttackB.ogg"] = 00.66,
						["OrcMaleAttackC.ogg"] = 00.44,
						["OrcMaleAttackD.ogg"] = 00.61,
						["OrcMaleChicken01.ogg"] = 02.95,
						["OrcMaleChooChoo01.ogg"] = 04.66,
						["OrcMaleCry01.ogg"] = 04.84,
						["OrcMaleDeath.ogg"] = 03.66,
						["OrcMaleKiss01.ogg"] = 01.12,
						["OrcMaleLaugh01.ogg"] = 02.09,
						["OrcMaleSigh01.ogg"] = 01.60,
						["OrcMaleWoundA.ogg"] = 00.46,
						["OrcMaleWoundB.ogg"] = 00.57,
						["OrcMaleWoundC.ogg"] = 00.66,
						["OrcMaleWoundCrit.ogg"] = 01.16,
						["OrcMaleYawn01.ogg"] = 03.02,
					},
					["OrcMaleErrorMessages\\OrcMale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 01.75,
								["skillnotfound03.ogg"] = 01.70,
								["skillnotfound04.ogg"] = 01.77,
							},
							["abilitycooldown01.ogg"] = 01.85,
							["abilitycooldown02.ogg"] = 01.44,
							["abilitycooldown03.ogg"] = 01.02,
							["alreadyingroup02.ogg"] = 01.44,
							["ammoonly02.ogg"] = 01.47,
							["bagfull01.ogg"] = 01.39,
							["cantcreatehere03.ogg"] = 01.40,
							["cantdropsoulbounditem01.ogg"] = 01.37,
							["cantdropsoulbounditem03.ogg"] = 01.23,
							["cantequipever01.ogg"] = 02.06,
							["cantequiplevel01.ogg"] = 02.06,
							["cantequiplevel02.ogg"] = 01.49,
							["cantequipskill03.ogg"] = 02.64,
							["cantlearnspell01.ogg"] = 01.68,
							["cantloot01.ogg"] = 01.04,
							["canttradesoulbounditem01.ogg"] = 01.24,
							["cantuseitem01.ogg"] = 00.99,
							["chestinuse02.ogg"] = 01.55,
							["genericnotarget01.ogg"] = 01.08,
							["genericnotarget02.ogg"] = 01.71,
							["genericnotarget04.ogg"] = 01.13,
							["guildpermissions01.ogg"] = 01.10,
							["guildpermissions04.ogg"] = 01.42,
							["invalidattacktarget01.ogg"] = 01.38,
							["invalidattacktarget02.ogg"] = 01.16,
							["inventoryfull01.ogg"] = 01.53,
							["inventoryfull02.ogg"] = 01.43,
							["itemcooldown02.ogg"] = 01.62,
							["itemcooldown04.ogg"] = 01.08,
							["itemcooldown06.ogg"] = 01.37,
							["itemlocked01.ogg"] = 00.87,
							["itemmaxcount01.ogg"] = 01.62,
							["lootdidntkill01.ogg"] = 01.04,
							["lootdidntkill06.ogg"] = 01.16,
							["loottoofar02.ogg"] = 01.22,
							["loottoofar03.ogg"] = 01.13,
							["loottoofar04.ogg"] = 01.13,
							["mustequipitem02.ogg"] = 01.92,
							["mustequipitem03.ogg"] = 01.20,
							["noammo05.ogg"] = 01.00,
							["noenergy01.ogg"] = 01.40,
							["noenergy02.ogg"] = 01.40,
							["nomana01.ogg"] = 01.47,
							["nomana02.ogg"] = 01.63,
							["nomana03.ogg"] = 01.66,
							["norage01.ogg"] = 01.36,
							["norage05.ogg"] = 01.39,
							["notabag01.ogg"] = 01.22,
							["notenoughmoney01.ogg"] = 01.29,
							["notenoughmoney02.ogg"] = 01.22,
							["notenoughmoney03.ogg"] = 01.28,
							["notequippable01.ogg"] = 01.41,
							["outofrange02.ogg"] = 01.36,
							["outofrange04.ogg"] = 01.08,
							["outofrange05.ogg"] = 01.44,
							["partyfull03.ogg"] = 01.82,
							["potioncooldown01.ogg"] = 01.74,
							["proficiencyneeded01.ogg"] = 01.28,
							["spellcooldown01.ogg"] = 01.59,
							["spellcooldown02.ogg"] = 01.67,
							["spellcooldown03.ogg"] = 01.49,
						},
					},
					["OrcMaleNPC\\ORcMaleNpc1\\"] = {
						["OrcWarriorMale1AggroA.ogg"] = 00.38,
						["OrcWarriorMale1AttackA.ogg"] = 00.53,
						["OrcWarriorMale1AttackB.ogg"] = 00.37,
						["OrcWarriorMale1AttackC.ogg"] = 00.39,
						["OrcWarriorMale1Death.ogg"] = 02.39,
						["OrcWarriorMale1PreAggroA.ogg"] = 00.32,
						["OrcWarriorMale1WoundA.ogg"] = 00.25,
						["OrcWarriorMale1WoundB.ogg"] = 00.38,
						["OrcWarriorMale1WoundC.ogg"] = 00.29,
						["OrcWarriorMale1WoundCrit.ogg"] = 00.63,
					},
					["OrcVocalFemale\\"] = {
						["OrcFemaleAttackMyTarget01.ogg"] = 01.27,
						["OrcFemaleAttackMyTarget02.ogg"] = 01.63,
						["OrcFemaleAttackMyTarget03.ogg"] = 01.25,
						["OrcFemaleCharge01.ogg"] = 00.68,
						["OrcFemaleCharge02.ogg"] = 01.30,
						["OrcFemaleCharge03.ogg"] = 01.78,
						["OrcFemaleCheer01.ogg"] = 00.93,
						["OrcFemaleCheer02.ogg"] = 01.59,
						["OrcFemaleCongratulations01.ogg"] = 01.28,
						["OrcFemaleCongratulations02.ogg"] = 00.82,
						["OrcFemaleCongratulations03.ogg"] = 01.28,
						["OrcFemaleFlee01.ogg"] = 00.75,
						["OrcFemaleFlee02.ogg"] = 00.66,
						["OrcFemaleFlirt01.ogg"] = 01.76,
						["OrcFemaleFlirt02.ogg"] = 02.16,
						["OrcFemaleFlirt04.ogg"] = 04.14,
						["OrcFemaleFlirt05.ogg"] = 01.28,
						["OrcFemaleFlirt06.ogg"] = 01.78,
						["OrcFemaleFlirt07.ogg"] = 02.20,
						["OrcFemaleFollowMe01.ogg"] = 01.01,
						["OrcFemaleFollowMe02.ogg"] = 00.40,
						["OrcFemaleGoodbye01.ogg"] = 00.90,
						["OrcFemaleGoodbye02.ogg"] = 01.97,
						["OrcFemaleGoodbye03.ogg"] = 00.89,
						["OrcFemaleHealMe01.ogg"] = 00.83,
						["OrcFemaleHealMe02.ogg"] = 01.11,
						["OrcFemaleHello01.ogg"] = 00.78,
						["OrcFemaleHello02.ogg"] = 00.50,
						["OrcFemaleHello03.ogg"] = 00.92,
						["OrcFemaleHelp01.ogg"] = 01.01,
						["OrcFemaleHelp02.ogg"] = 00.83,
						["OrcFemaleIncoming01.ogg"] = 00.89,
						["OrcFemaleIncoming02.ogg"] = 00.83,
						["OrcFemaleNo01.ogg"] = 00.43,
						["OrcFemaleNo02.ogg"] = 01.14,
						["OrcFemaleNo03.ogg"] = 00.54,
						["OrcFemaleOpenFire01.ogg"] = 01.21,
						["OrcFemaleOpenFire02.ogg"] = 00.87,
						["OrcFemaleOpenFire03.ogg"] = 00.92,
						["OrcFemaleOutOfMana01.ogg"] = 01.10,
						["OrcFemaleOutOfMana02.ogg"] = 01.37,
						["OrcFemalePissed01.ogg"] = 02.46,
						["OrcFemalePissed02.ogg"] = 05.63,
						["OrcFemalePissed03.ogg"] = 04.15,
						["OrcFemalePissed04.ogg"] = 01.74,
						["OrcFemalePissed05.ogg"] = 02.07,
						["OrcFemalePissed06.ogg"] = 05.40,
						["OrcFemaleRaspberry01.ogg"] = 01.15,
						["OrcFemaleThankYou01.ogg"] = 01.23,
						["OrcFemaleThankYou02.ogg"] = 00.74,
						["OrcFemaleThankYou03.ogg"] = 00.61,
						["OrcFemaleWaitHere01.ogg"] = 00.53,
						["OrcFemaleWaitHere02.ogg"] = 00.87,
						["OrcFemaleYes01.ogg"] = 00.49,
						["OrcFemaleYes02.ogg"] = 00.60,
						["OrcFemaleYes03.ogg"] = 00.49,
						["OrcFemaleYes04.ogg"] = 00.46,
						["OrcFemaleYoureWelcome01.ogg"] = 00.76,
						["OrcFemaleYoureWelcome02.ogg"] = 01.24,
						["OrcFemaleYoureWelcome03.ogg"] = 00.84,
						["VO_PCOrcFemaleRoar01.ogg"] = 02.43,
					},
					["OrcVocalMale\\"] = {
						["OrcMaleAttackMyTarget01.ogg"] = 01.17,
						["OrcMaleAttackMyTarget02.ogg"] = 01.12,
						["OrcMaleAttackMyTarget03.ogg"] = 01.50,
						["OrcMaleCharge01.ogg"] = 01.21,
						["OrcMaleCharge02.ogg"] = 01.42,
						["OrcMaleCharge03.ogg"] = 01.34,
						["OrcMaleCheer01.ogg"] = 01.43,
						["OrcMaleCheer02.ogg"] = 01.69,
						["OrcMaleCongratulations01.ogg"] = 01.19,
						["OrcMaleCongratulations02.ogg"] = 01.00,
						["OrcMaleCongratulations03.ogg"] = 01.06,
						["OrcMaleFlee01.ogg"] = 00.92,
						["OrcMaleFlee02.ogg"] = 00.50,
						["OrcMaleFlirt01.ogg"] = 04.09,
						["OrcMaleFlirt02.ogg"] = 04.48,
						["OrcMaleFlirt03.ogg"] = 15.87,
						["OrcMaleFlirt04.ogg"] = 02.76,
						["OrcMaleFlirt05.ogg"] = 05.39,
						["OrcMaleFlirt06.ogg"] = 02.40,
						["OrcMaleFollowMe01.ogg"] = 00.73,
						["OrcMaleFollowMe02.ogg"] = 00.49,
						["OrcMaleGoodbye01.ogg"] = 01.80,
						["OrcMaleGoodbye02.ogg"] = 00.82,
						["OrcMaleGoodbye03.ogg"] = 01.48,
						["OrcMaleHealMe01.ogg"] = 00.75,
						["OrcMaleHealMe02.ogg"] = 01.14,
						["OrcMaleHello01.ogg"] = 00.80,
						["OrcMaleHello02.ogg"] = 00.49,
						["OrcMaleHello03.ogg"] = 00.59,
						["OrcMaleHelp01.ogg"] = 00.89,
						["OrcMaleHelp02.ogg"] = 00.70,
						["OrcMaleIncoming01.ogg"] = 00.46,
						["OrcMaleIncoming02.ogg"] = 00.67,
						["OrcMaleIncoming03.ogg"] = 00.81,
						["OrcMaleNo01.ogg"] = 00.65,
						["OrcMaleNo02.ogg"] = 01.06,
						["OrcMaleNo03.ogg"] = 00.37,
						["OrcMaleOpenFire01.ogg"] = 00.64,
						["OrcMaleOpenFire02.ogg"] = 00.91,
						["OrcMaleOutOfMana01.ogg"] = 00.87,
						["OrcMaleOutOfMana02.ogg"] = 01.34,
						["OrcMalePissed01.ogg"] = 05.12,
						["OrcMalePissed02.ogg"] = 01.76,
						["OrcMalePissed03.ogg"] = 03.86,
						["OrcMalePissed04.ogg"] = 05.01,
						["OrcMalePissed05.ogg"] = 01.14,
						["OrcMalePissed06.ogg"] = 03.73,
						["OrcMaleRaspberry01.ogg"] = 00.79,
						["OrcMaleThankYou01.ogg"] = 01.67,
						["OrcMaleThankYou02.ogg"] = 01.13,
						["OrcMaleThankYou03.ogg"] = 00.56,
						["OrcMaleWaitHere01.ogg"] = 01.41,
						["OrcMaleWaitHere02.ogg"] = 01.05,
						["OrcMaleYes01.ogg"] = 00.58,
						["OrcMaleYes02.ogg"] = 00.53,
						["OrcMaleYes03.ogg"] = 00.23,
						["OrcMaleYes04.ogg"] = 00.47,
						["OrcMaleYoureWelcome01.ogg"] = 01.35,
						["OrcMaleYoureWelcome02.ogg"] = 01.33,
						["OrcMaleYoureWelcome03.ogg"] = 00.73,
						["VO_PCOrcMaleRoar01.ogg"] = 01.75,
					},
				},
				["PCGilneanFemale\\VO_"] = {
					["PCGilneanFemale_"] = {
						["Applaud01.ogg"] = 01.39,
						["AttackTarget01.ogg"] = 01.92,
						["AttackTarget02.ogg"] = 01.82,
						["AttackTarget03.ogg"] = 01.51,
						["Charge01.ogg"] = 02.65,
						["Charge02.ogg"] = 01.57,
						["Charge03.ogg"] = 02.19,
						["Charge04.ogg"] = 01.60,
						["Charge05.ogg"] = 01.54,
						["Cheer01.ogg"] = 01.25,
						["Cheer02.ogg"] = 00.93,
						["Chicken01.ogg"] = 02.40,
						["Congratulations01.ogg"] = 01.18,
						["Congratulations02.ogg"] = 01.48,
						["Congratulations03.ogg"] = 01.80,
						["Cry01.ogg"] = 03.11,
						["Cry02.ogg"] = 06.28,
						["Cry03.ogg"] = 03.01,
						["Err2hEquipped01.ogg"] = 02.45,
						["Err2hSkillNotFound01.ogg"] = 01.42,
						["Err2hSkillNotFound02.ogg"] = 01.61,
						["ErrAbilityCooldown01.ogg"] = 01.67,
						["ErrAbilityCooldown02.ogg"] = 01.40,
						["ErrAbilityCooldown03.ogg"] = 01.04,
						["ErrAlreadyInGroup01.ogg"] = 01.31,
						["ErrAmmoOnly01.ogg"] = 01.37,
						["ErrBagFull01.ogg"] = 01.14,
						["ErrCantCreateHere01.ogg"] = 01.35,
						["ErrCantDropSoulBoundItem01.ogg"] = 01.13,
						["ErrCantDropSoulBoundItem02.ogg"] = 01.60,
						["ErrCantEquipEver01.ogg"] = 01.81,
						["ErrCantEquipLevel01.ogg"] = 02.11,
						["ErrCantEquipLevel02.ogg"] = 01.34,
						["ErrCantEquipSkill01.ogg"] = 02.57,
						["ErrCantLearnSpell01.ogg"] = 01.61,
						["ErrCantTradeSoulBoundItem01.ogg"] = 01.37,
						["ErrCantUseItem01.ogg"] = 01.21,
						["ErrChestInUse01.ogg"] = 01.65,
						["ErrGenericNoTarget01.ogg"] = 01.34,
						["ErrGenericNoTarget02.ogg"] = 01.77,
						["ErrGenericNoTarget03.ogg"] = 01.16,
						["ErrGuildPermissions01.ogg"] = 01.24,
						["ErrGuildPermissions02.ogg"] = 01.47,
						["ErrInvalidAttackTarget01.ogg"] = 01.55,
						["ErrInvalidAttackTarget02.ogg"] = 01.31,
						["ErrInventoryFull01.ogg"] = 01.37,
						["ErrInventoryFull02.ogg"] = 01.43,
						["ErrItemCooldown01.ogg"] = 01.51,
						["ErrItemCooldown02.ogg"] = 01.14,
						["ErrItemCooldown03.ogg"] = 01.29,
						["ErrItemLocked01.ogg"] = 00.77,
						["ErrItemMaxCount01.ogg"] = 01.88,
						["ErrLootDidntKill01.ogg"] = 01.18,
						["ErrLootDidntKill02.ogg"] = 01.29,
						["ErrLootTooFar01.ogg"] = 01.20,
						["ErrLootTooFar02.ogg"] = 00.99,
						["ErrLootTooFar03.ogg"] = 01.15,
						["ErrMustEquipItem01.ogg"] = 01.86,
						["ErrMustEquipItem02.ogg"] = 01.18,
						["ErrNoAmmo01.ogg"] = 01.08,
						["ErrNoEnergy01.ogg"] = 01.11,
						["ErrNoEnergy02.ogg"] = 01.39,
						["ErrNoMana01.ogg"] = 01.13,
						["ErrNoMana02.ogg"] = 01.08,
						["ErrNoMana03.ogg"] = 01.12,
						["ErrNoRage01.ogg"] = 01.24,
						["ErrNoRage02.ogg"] = 01.31,
						["ErrNotABag01.ogg"] = 01.15,
						["ErrNotEnoughMoney01.ogg"] = 01.31,
						["ErrNotEnoughMoney02.ogg"] = 01.29,
						["ErrNotEnoughMoney03.ogg"] = 01.36,
						["ErrNotEquippable01.ogg"] = 01.26,
						["ErrOutOfRange01.ogg"] = 01.30,
						["ErrOutOfRange02.ogg"] = 01.24,
						["ErrOutOfRange03.ogg"] = 01.36,
						["ErrPartyFull01.ogg"] = 01.58,
						["ErrPotionCooldown01.ogg"] = 01.50,
						["ErrSpellCooldown01.ogg"] = 01.49,
						["ErrSpellCooldown02.ogg"] = 01.51,
						["ErrSpellCooldown03.ogg"] = 01.48,
						["Flee01.ogg"] = 03.65,
						["Flee02.ogg"] = 02.89,
						["Flee03.ogg"] = 00.90,
						["Flirt01.ogg"] = 04.64,
						["Flirt02.ogg"] = 03.63,
						["Flirt03.ogg"] = 04.15,
						["Flirt04.ogg"] = 04.15,
						["Flirt05.ogg"] = 04.04,
						["Flirt06.ogg"] = 02.85,
						["Flirt07.ogg"] = 02.89,
						["Flirt08.ogg"] = 04.22,
						["Flirt09.ogg"] = 02.00,
						["Flirt10.ogg"] = 03.14,
						["FollowMe01.ogg"] = 00.65,
						["FollowMe02.ogg"] = 00.75,
						["FollowMe03.ogg"] = 00.70,
						["Goodbye01.ogg"] = 00.63,
						["Goodbye02.ogg"] = 02.09,
						["Goodbye03.ogg"] = 02.52,
						["Goodbye04.ogg"] = 01.92,
						["HealMe01.ogg"] = 00.69,
						["HealMe02.ogg"] = 01.30,
						["Hello01.ogg"] = 01.61,
						["Hello02.ogg"] = 00.82,
						["Hello03.ogg"] = 01.84,
						["Hello04.ogg"] = 01.83,
						["Help01.ogg"] = 01.23,
						["Help02.ogg"] = 00.53,
						["IncomingDanger01.ogg"] = 01.19,
						["Kiss01.ogg"] = 00.91,
						["Kiss02.ogg"] = 00.84,
						["Kiss03.ogg"] = 00.82,
						["Laugh01.ogg"] = 01.41,
						["Laugh02.ogg"] = 01.38,
						["Laugh03.ogg"] = 01.45,
						["No01.ogg"] = 00.70,
						["No02.ogg"] = 00.67,
						["No03.ogg"] = 00.46,
						["Nod01.ogg"] = 00.67,
						["OpenFire01.ogg"] = 00.59,
						["OpenFire02.ogg"] = 01.25,
						["OutofMana01.ogg"] = 01.24,
						["OutofMana02.ogg"] = 01.43,
						["Rasberry01.ogg"] = 02.37,
						["Roar01.ogg"] = 02.04,
						["Sigh01.OGG"] = 01.12,
						["Silly01.ogg"] = 04.12,
						["Silly02.ogg"] = 05.11,
						["Silly03.ogg"] = 04.24,
						["Silly04.ogg"] = 01.87,
						["Silly05.ogg"] = 03.11,
						["Silly06.ogg"] = 09.16,
						["Silly07.ogg"] = 17.28,
						["Silly08.ogg"] = 04.66,
						["Silly09.ogg"] = 02.57,
						["ThankYou01.ogg"] = 00.85,
						["ThankYou02.ogg"] = 01.25,
						["ThankYou03.ogg"] = 00.66,
						["Train01.ogg"] = 02.37,
						["WaitHere01.ogg"] = 01.29,
						["WaitHere02.ogg"] = 00.79,
						["Yes01.ogg"] = 01.07,
						["Yes02.ogg"] = 00.96,
						["Yes03.ogg"] = 01.01,
						["YoureWelcome01.ogg"] = 00.87,
						["YoureWelcome02.ogg"] = 00.97,
						["YoureWelcome03.ogg"] = 02.17,
					},
				},
				["PCGilneanMale\\VO_"] = {
					["PCGilneanMale_"] = {
						["AttackTarget01.ogg"] = 02.63,
						["AttackTarget02.ogg"] = 01.87,
						["AttackTarget03.ogg"] = 01.35,
						["Charge01.ogg"] = 03.05,
						["Charge02.ogg"] = 01.37,
						["Charge03.ogg"] = 02.42,
						["Charge04.ogg"] = 01.66,
						["Charge05.ogg"] = 01.55,
						["Cheer01.ogg"] = 00.88,
						["Cheer02.ogg"] = 00.82,
						["Cheer03.ogg"] = 01.25,
						["Cheer04.ogg"] = 00.86,
						["Chicken01.ogg"] = 02.79,
						["Congratulations01.ogg"] = 01.15,
						["Congratulations02.ogg"] = 01.25,
						["Congratulations03.ogg"] = 01.86,
						["Cry01.ogg"] = 03.20,
						["Err2hEquipped01.ogg"] = 01.59,
						["Err2hSkillNotFound01.ogg"] = 01.15,
						["Err2hSkillNotFound02.ogg"] = 01.42,
						["ErrAbilityCooldown01.ogg"] = 01.60,
						["ErrAbilityCooldown02.ogg"] = 01.08,
						["ErrAbilityCooldown03.ogg"] = 00.84,
						["ErrAlreadyInGroup01.ogg"] = 01.37,
						["ErrAmmoOnly01.ogg"] = 01.22,
						["ErrBagFull01.ogg"] = 01.16,
						["ErrCantCreateHere01.ogg"] = 01.11,
						["ErrCantDropSoulBoundItem01.ogg"] = 01.16,
						["ErrCantDropSoulBoundItem02.ogg"] = 01.21,
						["ErrCantEquipEver01.ogg"] = 01.83,
						["ErrCantEquipLevel01.ogg"] = 01.75,
						["ErrCantEquipLevel02.ogg"] = 01.13,
						["ErrCantEquipSkill01.ogg"] = 02.28,
						["ErrCantLearnSpell01.ogg"] = 01.32,
						["ErrCantTradeSoulBoundItem01.ogg"] = 01.03,
						["ErrCantUseItem01.ogg"] = 00.98,
						["ErrChestInUse01.ogg"] = 01.41,
						["ErrGenericNoTarget01.ogg"] = 01.04,
						["ErrGenericNoTarget02.ogg"] = 01.63,
						["ErrGenericNoTarget03.ogg"] = 00.94,
						["ErrGuildPermissions01.ogg"] = 00.83,
						["ErrGuildPermissions02.ogg"] = 01.38,
						["ErrInvalidAttackTarget01.ogg"] = 01.47,
						["ErrInvalidAttackTarget02.ogg"] = 01.11,
						["ErrInventoryFull01.ogg"] = 01.39,
						["ErrInventoryFull02.ogg"] = 01.52,
						["ErrItemCooldown01.ogg"] = 01.38,
						["ErrItemCooldown02.ogg"] = 01.05,
						["ErrItemCooldown03.ogg"] = 01.12,
						["ErrItemLocked01.ogg"] = 00.64,
						["ErrItemMaxCount01.ogg"] = 01.49,
						["ErrLootDidntKill01.ogg"] = 01.05,
						["ErrLootDidntKill02.ogg"] = 01.02,
						["ErrLootTooFar01.ogg"] = 01.18,
						["ErrLootTooFar02.ogg"] = 01.08,
						["ErrLootTooFar03.ogg"] = 01.04,
						["ErrMustEquipItem01.ogg"] = 01.83,
						["ErrMustEquipItem02.ogg"] = 01.36,
						["ErrNoAmmo01.ogg"] = 01.08,
						["ErrNoEnergy01.ogg"] = 01.03,
						["ErrNoEnergy02.ogg"] = 01.31,
						["ErrNoMana01.ogg"] = 00.87,
						["ErrNoMana02.ogg"] = 01.09,
						["ErrNoMana03.ogg"] = 01.04,
						["ErrNoRage01.ogg"] = 01.12,
						["ErrNoRage02.ogg"] = 01.18,
						["ErrNotABag01.ogg"] = 01.03,
						["ErrNotEnoughMoney01.ogg"] = 01.38,
						["ErrNotEnoughMoney02.ogg"] = 01.08,
						["ErrNotEnoughMoney03.ogg"] = 01.33,
						["ErrNotEquippable01.ogg"] = 01.02,
						["ErrOutOfRange01.ogg"] = 01.28,
						["ErrOutOfRange02.ogg"] = 01.09,
						["ErrOutOfRange03.ogg"] = 01.13,
						["ErrPartyFull01.ogg"] = 01.40,
						["ErrPotionCooldown01.ogg"] = 01.45,
						["ErrSpellCooldown01.ogg"] = 01.58,
						["ErrSpellCooldown02.ogg"] = 01.24,
						["ErrSpellCooldown03.ogg"] = 01.40,
						["Flee01.ogg"] = 03.13,
						["Flee02.ogg"] = 04.22,
						["Flee03.ogg"] = 00.77,
						["Flirt01.ogg"] = 02.00,
						["Flirt02.ogg"] = 03.78,
						["Flirt03.ogg"] = 03.70,
						["Flirt04.ogg"] = 04.71,
						["Flirt05.ogg"] = 02.59,
						["Flirt06.ogg"] = 03.20,
						["Flirt07.ogg"] = 03.53,
						["Flirt08.ogg"] = 04.26,
						["Flirt09.ogg"] = 03.88,
						["Flirt10.ogg"] = 02.58,
						["Follow01.ogg"] = 00.79,
						["Follow02.ogg"] = 00.79,
						["Follow03.ogg"] = 00.71,
						["Goodbye01.ogg"] = 00.81,
						["Goodbye02.ogg"] = 02.06,
						["Goodbye03.ogg"] = 02.30,
						["Goodbye04.ogg"] = 01.76,
						["HealMe01.ogg"] = 00.57,
						["HealMe02.ogg"] = 01.12,
						["Hello01.ogg"] = 01.85,
						["Hello02.ogg"] = 00.92,
						["Hello03.ogg"] = 01.74,
						["Hello04.ogg"] = 01.79,
						["Help01.ogg"] = 01.15,
						["Help02.ogg"] = 00.50,
						["IncomingDanger01.ogg"] = 01.23,
						["Kiss01.ogg"] = 00.89,
						["Laugh01.ogg"] = 03.66,
						["No01.ogg"] = 00.58,
						["No02.ogg"] = 00.69,
						["No03.ogg"] = 00.60,
						["Nod01.ogg"] = 00.51,
						["Nod02.ogg"] = 01.13,
						["Nod03.ogg"] = 00.65,
						["OpenFire01.ogg"] = 00.74,
						["OpenFire02.ogg"] = 01.59,
						["OutofMana01.ogg"] = 01.07,
						["OutofMana02.ogg"] = 01.64,
						["Rasberry01.ogg"] = 00.75,
						["Rasberry02.ogg"] = 00.75,
						["Roar01.ogg"] = 01.74,
						["Silly01.ogg"] = 06.87,
						["Silly02.ogg"] = 09.76,
						["Silly03.ogg"] = 04.82,
						["Silly04.ogg"] = 04.63,
						["Silly05.ogg"] = 02.76,
						["Silly06.ogg"] = 04.02,
						["Silly07.ogg"] = 02.08,
						["Silly08.ogg"] = 01.73,
						["Silly09.ogg"] = 02.20,
						["Silly10.ogg"] = 01.59,
						["ThankYou01.ogg"] = 00.84,
						["ThankYou02.ogg"] = 01.46,
						["ThankYou03.ogg"] = 00.71,
						["Train01.ogg"] = 02.95,
						["WaitHere01.ogg"] = 01.16,
						["WaitHere02.ogg"] = 00.99,
						["Yes01.ogg"] = 00.98,
						["Yes02.ogg"] = 01.15,
						["Yes03.ogg"] = 00.89,
						["YoureWelcome01.ogg"] = 00.87,
						["YoureWelcome02.ogg"] = 00.73,
						["YoureWelcome03.ogg"] = 02.09,
					},
				},
				["PCGoblinFemale\\VO_"] = {
					["PCGoblinFemale_"] = {
						["AttackMyTarget01.ogg"] = 02.58,
						["AttackMyTarget02.ogg"] = 01.04,
						["AttackMyTarget03.ogg"] = 00.59,
						["Charge01.ogg"] = 01.15,
						["Charge02.ogg"] = 00.69,
						["Charge03.ogg"] = 03.27,
						["Charge04.ogg"] = 02.33,
						["Charge05.ogg"] = 02.44,
						["Cheer01.ogg"] = 00.88,
						["Cheer02.ogg"] = 01.95,
						["Chicken01.ogg"] = 03.26,
						["Congratulations01.ogg"] = 01.13,
						["Congratulations02.ogg"] = 01.04,
						["Congratulations03.ogg"] = 01.95,
						["Cry01.ogg"] = 02.98,
						["Cry02.ogg"] = 03.02,
						["Err2hEquipped01.ogg"] = 01.60,
						["Err2hSkillNotFound01.ogg"] = 01.32,
						["Err2hSkillNotFound02.ogg"] = 01.42,
						["ErrAbilityCooldown01.ogg"] = 01.45,
						["ErrAbilityCooldown02.ogg"] = 01.23,
						["ErrAbilityCooldown03.ogg"] = 00.87,
						["ErrAlreadyInGroup01.ogg"] = 01.24,
						["ErrAmmoOnly01.ogg"] = 01.16,
						["ErrBagFull01.ogg"] = 01.03,
						["ErrCantCreateHere01.ogg"] = 01.22,
						["ErrCantDropSoulBoundItem01.ogg"] = 01.17,
						["ErrCantDropSoulBoundItem02.ogg"] = 01.04,
						["ErrCantEquipEver01.ogg"] = 02.06,
						["ErrCantEquipLevel01.ogg"] = 01.79,
						["ErrCantEquipLevel02.ogg"] = 01.32,
						["ErrCantEquipSkill01.ogg"] = 02.38,
						["ErrCantLearnSpell01.ogg"] = 01.56,
						["ErrCantTradeSoulBoundItem01.ogg"] = 01.06,
						["ErrCantUseItem01.ogg"] = 01.30,
						["ErrChestInUse01.ogg"] = 01.60,
						["ErrGenericNoTarget01.ogg"] = 01.15,
						["ErrGenericNoTarget02.ogg"] = 01.77,
						["ErrGenericNoTarget03.ogg"] = 01.02,
						["ErrGuildPermissions01.ogg"] = 01.02,
						["ErrGuildPermissions02.ogg"] = 01.61,
						["ErrInvalidAttackTarget01.ogg"] = 01.71,
						["ErrInvalidAttackTarget02.ogg"] = 01.20,
						["ErrInventoryFull01.ogg"] = 01.38,
						["ErrInventoryFull02.ogg"] = 01.48,
						["ErrItemCooldown01.ogg"] = 01.43,
						["ErrItemCooldown02.ogg"] = 01.10,
						["ErrItemCooldown03.ogg"] = 01.30,
						["ErrItemLocked01.ogg"] = 01.15,
						["ErrItemMaxCount01.ogg"] = 02.26,
						["ErrLootDidntKill01.ogg"] = 01.20,
						["ErrLootDidntKill02.ogg"] = 01.37,
						["ErrLootTooFar01.ogg"] = 01.24,
						["ErrLootTooFar02.ogg"] = 00.84,
						["ErrLootTooFar03.ogg"] = 01.11,
						["ErrMustEquipItem01.ogg"] = 01.83,
						["ErrMustEquipItem02.ogg"] = 01.15,
						["ErrNoAmmo01.ogg"] = 00.90,
						["ErrNoEnergy01.ogg"] = 01.03,
						["ErrNoEnergy02.ogg"] = 01.17,
						["ErrNoMana01.ogg"] = 01.09,
						["ErrNoMana02.ogg"] = 00.94,
						["ErrNoMana03.ogg"] = 01.41,
						["ErrNoRage01.ogg"] = 01.31,
						["ErrNoRage02.ogg"] = 01.19,
						["ErrNotABag01.ogg"] = 01.11,
						["ErrNotEnoughMoney01.ogg"] = 01.13,
						["ErrNotEnoughMoney02.ogg"] = 01.26,
						["ErrNotEnoughMoney03.ogg"] = 01.36,
						["ErrNotEquippable01.ogg"] = 01.19,
						["ErrOutOfRange01.ogg"] = 01.30,
						["ErrOutOfRange02.ogg"] = 01.11,
						["ErrOutOfRange03.ogg"] = 01.15,
						["ErrPartyFull01.ogg"] = 01.74,
						["ErrPotionCooldown01.ogg"] = 01.56,
						["ErrSpellCooldown01.ogg"] = 01.43,
						["ErrSpellCooldown02.ogg"] = 01.39,
						["ErrSpellCooldown03.ogg"] = 01.14,
						["Flee01.ogg"] = 02.58,
						["Flee02.ogg"] = 02.97,
						["Flee03.ogg"] = 00.97,
						["Flirt01.ogg"] = 04.34,
						["Flirt02.ogg"] = 02.55,
						["Flirt03.ogg"] = 04.43,
						["Flirt04.ogg"] = 04.73,
						["Flirt05.ogg"] = 02.60,
						["Flirt06.ogg"] = 02.37,
						["Flirt07.ogg"] = 02.65,
						["Flirt08.ogg"] = 02.89,
						["Flirt09.ogg"] = 03.66,
						["Flirt10.ogg"] = 05.94,
						["Followme01.ogg"] = 00.53,
						["Followme02.ogg"] = 01.06,
						["Followme03.ogg"] = 01.15,
						["Goodbye01.ogg"] = 00.53,
						["Goodbye02.ogg"] = 00.44,
						["Goodbye03.ogg"] = 02.52,
						["Goodbye04.ogg"] = 02.65,
						["HealMe01.ogg"] = 01.13,
						["HealMe02.ogg"] = 00.76,
						["Hello01.ogg"] = 01.26,
						["Hello02.ogg"] = 01.04,
						["Hello03.ogg"] = 00.67,
						["Hello04.ogg"] = 00.94,
						["Help01.ogg"] = 02.71,
						["Help02.ogg"] = 01.75,
						["IncomingDanger01.ogg"] = 01.19,
						["Kiss01.ogg"] = 01.10,
						["Laugh01.ogg"] = 02.10,
						["No01.ogg"] = 01.16,
						["No02.ogg"] = 01.26,
						["No03.ogg"] = 01.23,
						["Nod01.ogg"] = 00.43,
						["Nod02.ogg"] = 00.71,
						["Nod03.ogg"] = 00.41,
						["OpenFire01.ogg"] = 00.68,
						["OpenFire02.ogg"] = 01.89,
						["OutofMana01.ogg"] = 02.00,
						["OutofMana02.ogg"] = 01.30,
						["Raspberry01.ogg"] = 01.74,
						["Roar01.ogg"] = 01.68,
						["Silly01.ogg"] = 03.40,
						["Silly02.ogg"] = 11.44,
						["Silly03.ogg"] = 04.23,
						["Silly04.ogg"] = 09.69,
						["Silly05.ogg"] = 07.49,
						["Silly06.ogg"] = 07.83,
						["Silly07.ogg"] = 02.51,
						["Silly08.ogg"] = 02.61,
						["Silly09.ogg"] = 02.88,
						["Silly10.ogg"] = 01.69,
						["ThankYou01.ogg"] = 00.75,
						["ThankYou02.ogg"] = 01.81,
						["ThankYou03.ogg"] = 00.95,
						["Train01.ogg"] = 02.81,
						["WaitHere01.ogg"] = 00.97,
						["WaitHere02.ogg"] = 01.29,
						["Yes01.ogg"] = 00.62,
						["Yes02.ogg"] = 00.91,
						["Yes03.ogg"] = 03.75,
						["YoureWelcome01.ogg"] = 01.53,
						["YoureWelcome02.ogg"] = 00.73,
						["YoureWelcome03.ogg"] = 00.66,
					},
				},
				["PCGoblinMale\\VO_"] = {
					["PCGoblinMale_"] = {
						["AttackMyTarget01.ogg"] = 02.71,
						["AttackMyTarget02.ogg"] = 01.71,
						["AttackMyTarget03.ogg"] = 00.93,
						["Beg01.ogg"] = 01.79,
						["Beg02.ogg"] = 01.18,
						["Beg03.ogg"] = 01.53,
						["Beg04.ogg"] = 00.99,
						["Beg05.ogg"] = 01.00,
						["Charge01.ogg"] = 01.44,
						["Charge02.ogg"] = 00.76,
						["Charge03.ogg"] = 02.54,
						["Charge04.ogg"] = 02.20,
						["Charge05.ogg"] = 03.67,
						["Cheer01.ogg"] = 01.15,
						["Cheer02.ogg"] = 01.27,
						["Chicken01.ogg"] = 03.11,
						["Congratulations01.ogg"] = 00.76,
						["Congratulations02.ogg"] = 00.80,
						["Congratulations03.ogg"] = 02.50,
						["Cry01.ogg"] = 03.08,
						["Cry02.ogg"] = 02.37,
						["Cry03.ogg"] = 02.37,
						["Err2hEquipped01.ogg"] = 01.77,
						["Err2hSkillNotFound01.ogg"] = 01.22,
						["Err2hSkillNotFound02.ogg"] = 01.48,
						["ErrAbilityCooldown01.ogg"] = 01.72,
						["ErrAbilityCooldown02.ogg"] = 01.53,
						["ErrAbilityCooldown03.ogg"] = 00.98,
						["ErrAlreadyInGroup01.ogg"] = 01.39,
						["ErrAmmoOnly01.ogg"] = 01.42,
						["ErrBagFull01.ogg"] = 01.10,
						["ErrCantCreateHere01.ogg"] = 01.20,
						["ErrCantDropSoulBoundItem01.ogg"] = 00.95,
						["ErrCantDropSoulBoundItem02.ogg"] = 01.39,
						["ErrCantEquipEver01.ogg"] = 01.88,
						["ErrCantEquipLevel01.ogg"] = 01.87,
						["ErrCantEquipLevel02.ogg"] = 01.21,
						["ErrCantEquipSkill01.ogg"] = 02.44,
						["ErrCantLearnSpell01.ogg"] = 01.40,
						["ErrCantTradeSoulBoundItem01.ogg"] = 01.21,
						["ErrCantUseItem01.ogg"] = 01.52,
						["ErrChestInUse01.ogg"] = 01.73,
						["ErrGenericNoTarget01.ogg"] = 01.23,
						["ErrGenericNoTarget02.ogg"] = 02.13,
						["ErrGenericNoTarget03.ogg"] = 00.94,
						["ErrGuildPermissions01.ogg"] = 01.03,
						["ErrGuildPermissions02.ogg"] = 01.76,
						["ErrInvalidAttackTarget01.ogg"] = 01.67,
						["ErrInvalidAttackTarget02.ogg"] = 01.35,
						["ErrInventoryFull01.ogg"] = 01.51,
						["ErrInventoryFull02.ogg"] = 01.40,
						["ErrItemCooldown01.ogg"] = 01.56,
						["ErrItemCooldown02.ogg"] = 01.26,
						["ErrItemCooldown03.ogg"] = 01.26,
						["ErrItemLocked01.ogg"] = 00.76,
						["ErrItemMaxCount01.ogg"] = 02.02,
						["ErrLootDidntKill01.ogg"] = 01.17,
						["ErrLootDidntKill02.ogg"] = 01.27,
						["ErrLootTooFar01.ogg"] = 01.35,
						["ErrLootTooFar02.ogg"] = 01.05,
						["ErrLootTooFar03.ogg"] = 00.89,
						["ErrMustEquipItem01.ogg"] = 01.44,
						["ErrMustEquipItem02.ogg"] = 00.94,
						["ErrNoAmmo01.ogg"] = 00.85,
						["ErrNoEnergy01.ogg"] = 00.90,
						["ErrNoEnergy02.ogg"] = 01.30,
						["ErrNoMana01.ogg"] = 00.97,
						["ErrNoMana02.ogg"] = 00.96,
						["ErrNoMana03.ogg"] = 01.63,
						["ErrNoRage01.ogg"] = 01.25,
						["ErrNoRage02.ogg"] = 01.40,
						["ErrNotABag01.ogg"] = 01.27,
						["ErrNotEnoughMoney01.ogg"] = 01.45,
						["ErrNotEnoughMoney02.ogg"] = 01.15,
						["ErrNotEnoughMoney03.ogg"] = 01.48,
						["ErrNotEquippable01.ogg"] = 01.39,
						["ErrOutOfRange01.ogg"] = 01.49,
						["ErrOutOfRange02.ogg"] = 01.17,
						["ErrOutOfRange03.ogg"] = 01.26,
						["ErrPartyFull01.ogg"] = 02.24,
						["ErrPotionCooldown01.ogg"] = 01.58,
						["ErrSpellCooldown01.ogg"] = 01.74,
						["ErrSpellCooldown02.ogg"] = 02.01,
						["ErrSpellCooldown03.ogg"] = 01.43,
						["Flee01.ogg"] = 02.26,
						["Flee02.ogg"] = 02.12,
						["Flee03.ogg"] = 01.26,
						["Flirt01.ogg"] = 02.71,
						["Flirt02.ogg"] = 03.74,
						["Flirt03.ogg"] = 02.85,
						["Flirt04.ogg"] = 06.80,
						["Flirt05.ogg"] = 05.88,
						["Flirt06.ogg"] = 05.93,
						["Flirt07.ogg"] = 01.90,
						["Flirt08.ogg"] = 02.94,
						["Flirt09.ogg"] = 03.01,
						["Flirt10.ogg"] = 00.90,
						["Follow01.ogg"] = 00.70,
						["Follow02.ogg"] = 00.54,
						["Follow03.ogg"] = 01.62,
						["Goodbye01.ogg"] = 00.65,
						["Goodbye02.ogg"] = 00.48,
						["Goodbye03.ogg"] = 03.14,
						["Goodbye04.ogg"] = 02.11,
						["HealMe01.ogg"] = 01.29,
						["HealMe02.ogg"] = 00.61,
						["Hello01.ogg"] = 01.53,
						["Hello02.ogg"] = 01.14,
						["Hello03.ogg"] = 00.68,
						["Hello04.ogg"] = 01.00,
						["Help01.ogg"] = 02.87,
						["Help02.ogg"] = 01.47,
						["IncomingDanger01.ogg"] = 01.07,
						["Kiss01.ogg"] = 01.49,
						["Laugh01.OGG"] = 01.25,
						["Laugh02.OGG"] = 00.95,
						["Laugh03.OGG"] = 01.41,
						["Laugh04.OGG"] = 01.25,
						["No01.ogg"] = 01.16,
						["No02.ogg"] = 01.49,
						["No03.ogg"] = 01.10,
						["Nod01.ogg"] = 00.45,
						["Nod02.ogg"] = 00.61,
						["Nod03.ogg"] = 00.50,
						["OpenFire01.ogg"] = 00.74,
						["OpenFire02.ogg"] = 01.90,
						["OutofMana01.ogg"] = 02.32,
						["OutofMana02.ogg"] = 01.09,
						["Raspberry01.ogg"] = 01.38,
						["Roar01.ogg"] = 01.71,
						["Roar02.ogg"] = 01.45,
						["Roar03.ogg"] = 01.71,
						["Silly01.ogg"] = 02.73,
						["Silly02.ogg"] = 05.38,
						["Silly03.ogg"] = 05.36,
						["Silly04.ogg"] = 06.19,
						["Silly05.ogg"] = 02.91,
						["Silly06.ogg"] = 03.26,
						["Silly07.ogg"] = 02.42,
						["Silly08.ogg"] = 02.45,
						["Silly09.ogg"] = 02.11,
						["Silly10.ogg"] = 08.43,
						["ThankYou01.ogg"] = 00.67,
						["ThankYou02.ogg"] = 01.71,
						["ThankYou03.ogg"] = 01.03,
						["Train01.ogg"] = 02.53,
						["WaitHere01.ogg"] = 00.86,
						["WaitHere02.ogg"] = 02.01,
						["Yes01.ogg"] = 00.38,
						["Yes02.ogg"] = 01.03,
						["Yes03.ogg"] = 02.63,
						["YourWelcome01.ogg"] = 01.45,
						["YourWelcome02.ogg"] = 00.97,
						["YourWelcome03.ogg"] = 00.60,
					},
				},
				["PCPandarenFemale\\VO_"] = {
					["PCPandarenFemale_"] = {
						["Attack01.OGG"] = 00.52,
						["Attack02.OGG"] = 00.61,
						["Attack03.OGG"] = 00.54,
						["Attack04.OGG"] = 00.72,
						["Attack05.OGG"] = 00.72,
						["Attack06.OGG"] = 00.70,
						["Attack07.OGG"] = 00.71,
						["Attack08.OGG"] = 00.54,
						["Attack09.OGG"] = 00.72,
						["Attack10.OGG"] = 00.73,
						["AttackCrit01.OGG"] = 01.23,
						["AttackCrit02.OGG"] = 01.14,
						["AttackCrit03.OGG"] = 01.14,
						["AttackCrit04.OGG"] = 01.15,
						["AttackCrit05.OGG"] = 01.21,
						["AttackCrit06.OGG"] = 01.79,
						["AttackCrit07.OGG"] = 01.24,
						["AttackMyTarget01.OGG"] = 00.97,
						["AttackMyTarget02.OGG"] = 00.71,
						["AttackMyTarget03.OGG"] = 01.07,
						["BattleRoar01.OGG"] = 01.49,
						["BattleRoar02.OGG"] = 01.66,
						["BattleRoar03.OGG"] = 01.69,
						["BattleRoar04.OGG"] = 01.60,
						["BattleRoar05.OGG"] = 01.89,
						["Beg01.OGG"] = 01.94,
						["Beg02.OGG"] = 01.96,
						["Beg03.OGG"] = 06.19,
						["Beg04.OGG"] = 04.68,
						["Beg05.OGG"] = 03.02,
						["Charge01.OGG"] = 02.01,
						["Charge02.OGG"] = 01.86,
						["Charge03.OGG"] = 01.44,
						["Charge04.OGG"] = 02.61,
						["Charge05.OGG"] = 00.93,
						["Cheer01.OGG"] = 01.14,
						["Cheer02.OGG"] = 01.31,
						["Chicken01.OGG"] = 01.15,
						["Chicken02.OGG"] = 01.22,
						["Congratulations01.OGG"] = 00.97,
						["Congratulations02.OGG"] = 01.11,
						["Congratulations03.OGG"] = 01.89,
						["Cry01.OGG"] = 01.97,
						["Cry02.OGG"] = 01.97,
						["Cry03.OGG"] = 01.84,
						["Death01.OGG"] = 02.75,
						["Death02.OGG"] = 03.00,
						["Death03.OGG"] = 02.71,
						["Death04.OGG"] = 02.64,
						["Death05.OGG"] = 02.74,
						["Death06.OGG"] = 02.42,
						["Death07.OGG"] = 02.54,
						["Drink01.OGG"] = 02.39,
						["Drink02.OGG"] = 02.37,
						["Eat01.OGG"] = 02.27,
						["Eat02.OGG"] = 02.52,
						["Err2hEquipped01.OGG"] = 01.86,
						["Err2hSkillNotFound01.OGG"] = 01.66,
						["Err2hSkillNotFound02.OGG"] = 01.82,
						["ErrAbilityCooldown01.OGG"] = 01.68,
						["ErrAbilityCooldown02.OGG"] = 01.27,
						["ErrAbilityCooldown03.OGG"] = 00.91,
						["ErrAlreadyInGroup01.OGG"] = 01.56,
						["ErrAmmoOnly01.OGG"] = 01.50,
						["ErrBagFull01.OGG"] = 01.33,
						["ErrCantCreateHere01.OGG"] = 01.52,
						["ErrCantDropSoulBoundItem01.OGG"] = 01.43,
						["ErrCantDropSoulBoundItem02.OGG"] = 01.28,
						["ErrCantEquipEver01.OGG"] = 02.12,
						["ErrCantEquipLevel01.OGG"] = 02.28,
						["ErrCantEquipLevel02.OGG"] = 01.46,
						["ErrCantEquipSkill01.OGG"] = 02.89,
						["ErrCantLearnSpell01.OGG"] = 01.72,
						["ErrCantTradeSoulBoundItem01.OGG"] = 01.54,
						["ErrCantUseItem01.OGG"] = 01.40,
						["ErrChestInUse01.OGG"] = 02.01,
						["ErrGenericNoTarget01.OGG"] = 01.60,
						["ErrGenericNoTarget02.OGG"] = 02.16,
						["ErrGenericNoTarget03.OGG"] = 01.33,
						["ErrGuildPermissions01.OGG"] = 01.39,
						["ErrGuildPermissions02.OGG"] = 02.02,
						["ErrInvalidAttackTarget01.OGG"] = 02.11,
						["ErrInvalidAttackTarget02.OGG"] = 01.46,
						["ErrInventoryFull01.OGG"] = 01.50,
						["ErrInventoryFull02.OGG"] = 01.63,
						["ErrItemCooldown01.OGG"] = 01.78,
						["ErrItemCooldown02.OGG"] = 01.21,
						["ErrItemCooldown03.OGG"] = 01.46,
						["ErrItemLocked01.OGG"] = 00.90,
						["ErrItemMaxCount01.OGG"] = 02.13,
						["ErrLootDidntKill01.OGG"] = 01.27,
						["ErrLootDidntKill02.OGG"] = 01.57,
						["ErrLootTooFar01.OGG"] = 01.23,
						["ErrLootTooFar02.OGG"] = 00.94,
						["ErrLootTooFar03.OGG"] = 01.31,
						["ErrMustEquipItem01.OGG"] = 01.98,
						["ErrMustEquipItem02.OGG"] = 01.45,
						["ErrNoAmmo01.OGG"] = 01.32,
						["ErrNoEnergy01.OGG"] = 01.40,
						["ErrNoEnergy02.OGG"] = 01.70,
						["ErrNoMana01.OGG"] = 01.31,
						["ErrNoMana02.OGG"] = 01.18,
						["ErrNoMana03.OGG"] = 01.50,
						["ErrNoRage01.OGG"] = 01.25,
						["ErrNoRage02.OGG"] = 01.21,
						["ErrNotABag01.OGG"] = 01.17,
						["ErrNotEnoughMoney01.OGG"] = 01.72,
						["ErrNotEnoughMoney02.OGG"] = 01.47,
						["ErrNotEnoughMoney03.OGG"] = 01.45,
						["ErrNotEquippable01.OGG"] = 01.38,
						["ErrOutOfRange01.OGG"] = 01.42,
						["ErrOutOfRange02.OGG"] = 01.37,
						["ErrOutOfRange03.OGG"] = 01.35,
						["ErrPartyFull01.OGG"] = 02.13,
						["ErrPotionCooldown01.OGG"] = 01.88,
						["ErrSpellCooldown01.OGG"] = 01.94,
						["ErrSpellCooldown02.OGG"] = 01.66,
						["ErrSpellCooldown03.OGG"] = 01.51,
						["Flee01.OGG"] = 00.90,
						["Flee02.OGG"] = 01.10,
						["Flee03.OGG"] = 02.25,
						["Flee04.OGG"] = 00.84,
						["Flirt01.OGG"] = 14.85,
						["Flirt02.OGG"] = 11.77,
						["Flirt03.OGG"] = 04.04,
						["Flirt04.OGG"] = 05.28,
						["Flirt05.OGG"] = 07.61,
						["Flirt06.OGG"] = 06.60,
						["Flirt07.OGG"] = 02.30,
						["Flirt08.OGG"] = 03.30,
						["Flirt09.OGG"] = 05.20,
						["FollowMe01.OGG"] = 00.80,
						["FollowMe02.OGG"] = 01.19,
						["FollowMe03.OGG"] = 01.49,
						["Goodbye01.OGG"] = 00.63,
						["Goodbye02.OGG"] = 01.96,
						["Goodbye03.OGG"] = 01.85,
						["Goodbye04.OGG"] = 01.36,
						["HealMe01.OGG"] = 00.81,
						["HealMe02.OGG"] = 01.06,
						["Hello01.OGG"] = 00.74,
						["Hello02.OGG"] = 00.70,
						["Hello03.OGG"] = 01.16,
						["Hello04.OGG"] = 01.14,
						["Help01.OGG"] = 01.31,
						["Help02.OGG"] = 01.62,
						["IncomingDanger01.OGG"] = 01.15,
						["Kiss01.OGG"] = 00.78,
						["Kiss02.OGG"] = 01.26,
						["Kiss03.OGG"] = 00.66,
						["Laugh01.OGG"] = 02.40,
						["Laugh02.OGG"] = 02.68,
						["Laugh05.OGG"] = 01.93,
						["No01.OGG"] = 00.91,
						["No02.OGG"] = 00.42,
						["No03.OGG"] = 01.14,
						["Nod01.OGG"] = 00.55,
						["Nod02.OGG"] = 00.65,
						["Nod03.OGG"] = 00.80,
						["OpenFire01.OGG"] = 01.05,
						["OpenFire02.OGG"] = 01.38,
						["OutofMana01.OGG"] = 01.30,
						["OutofMana02.OGG"] = 01.26,
						["Raspberry01.OGG"] = 01.22,
						["Sigh01.OGG"] = 01.35,
						["Silly01.OGG"] = 07.77,
						["Silly02.OGG"] = 05.30,
						["Silly03.OGG"] = 02.95,
						["Silly04.OGG"] = 03.06,
						["Silly05.OGG"] = 09.13,
						["Silly06.OGG"] = 06.97,
						["Silly07.OGG"] = 07.45,
						["Silly08.OGG"] = 11.32,
						["Silly09.OGG"] = 10.64,
						["ThankYou01.OGG"] = 02.28,
						["ThankYou02.OGG"] = 00.75,
						["ThankYou03.OGG"] = 02.14,
						["Train01.OGG"] = 04.68,
						["WaitHere01.OGG"] = 01.30,
						["WaitHere02.OGG"] = 01.16,
						["Wound01.OGG"] = 00.56,
						["Wound02.OGG"] = 00.44,
						["Wound03.OGG"] = 00.39,
						["Wound04.OGG"] = 00.52,
						["Wound05.OGG"] = 00.44,
						["Wound06.OGG"] = 00.39,
						["Wound07.OGG"] = 00.52,
						["Wound08.OGG"] = 00.35,
						["Wound09.OGG"] = 00.61,
						["Wound10.OGG"] = 00.48,
						["WoundCrit01.OGG"] = 01.12,
						["WoundCrit02.OGG"] = 01.16,
						["WoundCrit03.OGG"] = 01.06,
						["WoundCrit04.OGG"] = 01.06,
						["WoundCrit05.OGG"] = 01.32,
						["WoundCrit06.OGG"] = 00.90,
						["WoundCrit07.OGG"] = 00.93,
						["Yawn01.OGG"] = 01.97,
						["Yawn06.OGG"] = 01.47,
						["Yes01.OGG"] = 00.66,
						["Yes02.OGG"] = 00.76,
						["Yes03.OGG"] = 01.35,
						["YoureWelcome01.OGG"] = 01.74,
						["YoureWelcome02.OGG"] = 01.87,
						["YoureWelcome03.OGG"] = 03.96,
					},
				},
				["PCPandarenMale\\VO_"] = {
					["PCPandarenMale_"] = {
						["Attack01.OGG"] = 00.83,
						["Attack02.OGG"] = 00.90,
						["Attack03.OGG"] = 00.79,
						["Attack04.OGG"] = 00.91,
						["Attack05.OGG"] = 00.73,
						["Attack06.OGG"] = 00.65,
						["Attack07.OGG"] = 00.72,
						["Attack08.OGG"] = 00.58,
						["Attack09.OGG"] = 00.45,
						["Attack10.OGG"] = 00.73,
						["AttackCritical01.OGG"] = 01.50,
						["AttackCritical02.OGG"] = 00.75,
						["AttackCritical03.OGG"] = 01.43,
						["AttackCritical04.OGG"] = 01.02,
						["AttackCritical05.OGG"] = 00.83,
						["AttackCritical06.OGG"] = 01.45,
						["AttackCritical07.OGG"] = 01.37,
						["AttackCritical08.OGG"] = 01.49,
						["AttackCritical09.OGG"] = 00.77,
						["AttackMyTarget01.OGG"] = 01.20,
						["AttackMyTarget02.OGG"] = 00.98,
						["AttackMyTarget03.OGG"] = 01.16,
						["Beg01.OGG"] = 06.14,
						["Beg02.OGG"] = 06.24,
						["Beg03.OGG"] = 03.94,
						["Beg04.OGG"] = 02.43,
						["Beg05.OGG"] = 03.90,
						["Charge01.OGG"] = 00.70,
						["Charge02.OGG"] = 01.73,
						["Charge03.OGG"] = 02.82,
						["Charge04.OGG"] = 01.79,
						["Charge05.OGG"] = 01.87,
						["Cheer01.OGG"] = 02.04,
						["Cheer02.OGG"] = 01.97,
						["Chicken01.OGG"] = 01.54,
						["Chicken02.OGG"] = 01.61,
						["Chicken03.OGG"] = 01.52,
						["Congratulations01.OGG"] = 00.87,
						["Congratulations02.OGG"] = 00.93,
						["Congratulations03.OGG"] = 01.64,
						["Cry01.OGG"] = 05.07,
						["Cry02.OGG"] = 05.54,
						["Cry03.OGG"] = 06.80,
						["Death01.OGG"] = 02.19,
						["Death02.OGG"] = 02.42,
						["Death03.OGG"] = 01.86,
						["Death04.OGG"] = 02.36,
						["Death05.OGG"] = 02.25,
						["Death06.OGG"] = 02.40,
						["Death07.OGG"] = 02.54,
						["Death08.OGG"] = 02.50,
						["Death09.OGG"] = 02.39,
						["Death10.OGG"] = 02.72,
						["Drink01.OGG"] = 03.31,
						["Drink02.OGG"] = 04.02,
						["Eat01.OGG"] = 02.99,
						["Eat02.OGG"] = 03.24,
						["Err2hEquipped01.OGG"] = 01.63,
						["Err2hSkillNotFound01.OGG"] = 01.41,
						["Err2hSkillNotFound02.OGG"] = 01.85,
						["ErrAbilityCooldown01.OGG"] = 01.74,
						["ErrAbilityCooldown02.OGG"] = 01.31,
						["ErrAbilityCooldown03.OGG"] = 01.02,
						["ErrAlreadyInGroup01.OGG"] = 01.51,
						["ErrAmmoOnly01.OGG"] = 01.36,
						["ErrBagFull01.OGG"] = 00.95,
						["ErrCantCreateHere01.OGG"] = 01.19,
						["ErrCantDropSoulBoundItem01.OGG"] = 01.21,
						["ErrCantDropSoulBoundItem02.OGG"] = 01.23,
						["ErrCantEquipEver01.OGG"] = 02.04,
						["ErrCantEquipLevel01.OGG"] = 02.19,
						["ErrCantEquipLevel02.OGG"] = 01.35,
						["ErrCantEquipSkill01.OGG"] = 02.46,
						["ErrCantLearnSpell01.OGG"] = 01.51,
						["ErrCantTradeSoulBoundItem01.OGG"] = 01.21,
						["ErrCantUseItem01.OGG"] = 01.17,
						["ErrChestInUse01.OGG"] = 01.80,
						["ErrGenericNoTarget01.OGG"] = 01.40,
						["ErrGenericNoTarget02.OGG"] = 01.85,
						["ErrGenericNoTarget03.OGG"] = 00.95,
						["ErrGuildPermissions01.OGG"] = 01.07,
						["ErrGuildPermissions02.OGG"] = 01.60,
						["ErrInvalidAttackTarget01.OGG"] = 01.56,
						["ErrInvalidAttackTarget02.OGG"] = 01.21,
						["ErrInventoryFull01.OGG"] = 01.29,
						["ErrInventoryFull02.OGG"] = 01.47,
						["ErrItemCooldown01.OGG"] = 01.60,
						["ErrItemCooldown02.OGG"] = 01.19,
						["ErrItemCooldown03.OGG"] = 01.24,
						["ErrItemLocked01.OGG"] = 00.64,
						["ErrItemMaxCount01.OGG"] = 01.76,
						["ErrLootDidntKill01.OGG"] = 01.10,
						["ErrLootDidntKill02.OGG"] = 01.41,
						["ErrLootTooFar01.OGG"] = 01.35,
						["ErrLootTooFar02.OGG"] = 01.13,
						["ErrLootTooFar03.OGG"] = 01.43,
						["ErrMustEquipItem01.OGG"] = 02.14,
						["ErrMustEquipItem02.OGG"] = 01.17,
						["ErrNoAmmo01.OGG"] = 01.07,
						["ErrNoEnergy01.OGG"] = 01.21,
						["ErrNoEnergy02.OGG"] = 01.49,
						["ErrNoMana01.OGG"] = 01.01,
						["ErrNoMana02.OGG"] = 01.12,
						["ErrNoMana03.OGG"] = 01.11,
						["ErrNoRage01.OGG"] = 01.11,
						["ErrNoRage02.OGG"] = 01.07,
						["ErrNotABag01.OGG"] = 01.15,
						["ErrNotABag02.OGG"] = 17.95,
						["ErrNotEnoughMoney01.OGG"] = 01.52,
						["ErrNotEnoughMoney02.OGG"] = 01.45,
						["ErrNotEnoughMoney03.OGG"] = 01.26,
						["ErrNotEquippable01.OGG"] = 01.32,
						["ErrOutOfRange01.OGG"] = 01.22,
						["ErrOutOfRange02.OGG"] = 01.16,
						["ErrOutOfRange03.OGG"] = 01.23,
						["ErrPartyFull01.OGG"] = 02.06,
						["ErrPotionCooldown01.OGG"] = 01.70,
						["ErrSpellCooldown01.OGG"] = 01.50,
						["ErrSpellCooldown02.OGG"] = 01.45,
						["ErrSpellCooldown03.OGG"] = 01.39,
						["Flee01.OGG"] = 01.38,
						["Flee02.OGG"] = 02.20,
						["Flee03.OGG"] = 02.53,
						["Flirt01.OGG"] = 01.85,
						["Flirt02.OGG"] = 09.71,
						["Flirt03.OGG"] = 04.15,
						["Flirt04.OGG"] = 04.85,
						["Flirt05.OGG"] = 07.64,
						["Flirt06.OGG"] = 04.31,
						["Flirt07.OGG"] = 03.15,
						["Flirt08.OGG"] = 07.06,
						["FollowMe01.OGG"] = 01.72,
						["FollowMe02.OGG"] = 01.39,
						["FollowMe03.OGG"] = 01.51,
						["Goodbye01.OGG"] = 00.97,
						["Goodbye02.OGG"] = 01.88,
						["Goodbye03.OGG"] = 02.00,
						["Goodbye04.OGG"] = 02.22,
						["HealMe01.OGG"] = 01.09,
						["HealMe02.OGG"] = 00.98,
						["Hello01.OGG"] = 01.16,
						["Hello02.OGG"] = 00.78,
						["Hello03.OGG"] = 00.73,
						["Hello04.OGG"] = 01.25,
						["Hello05.OGG"] = 00.78,
						["Help01.OGG"] = 01.29,
						["Help02.OGG"] = 01.77,
						["IncomingDanger01.OGG"] = 03.25,
						["Kiss02.OGG"] = 02.12,
						["Kiss03.OGG"] = 01.64,
						["Kiss06.OGG"] = 01.70,
						["Laugh01.OGG"] = 03.47,
						["Laugh02.OGG"] = 02.74,
						["Laugh03.OGG"] = 02.74,
						["No01.OGG"] = 02.20,
						["No02.OGG"] = 01.66,
						["No03.OGG"] = 00.33,
						["No04.OGG"] = 03.77,
						["Nod01.OGG"] = 00.44,
						["Nod02.OGG"] = 00.70,
						["OpenFire01.OGG"] = 01.34,
						["OpenFire02.OGG"] = 01.71,
						["OutofMana01.OGG"] = 01.14,
						["OutofMana02.OGG"] = 01.98,
						["Raspberry01.OGG"] = 01.60,
						["Roar01.OGG"] = 02.53,
						["Roar02.OGG"] = 02.49,
						["Roar03.OGG"] = 02.59,
						["Roar04.OGG"] = 02.41,
						["Roar05.OGG"] = 02.40,
						["Sigh01.OGG"] = 01.47,
						["Sigh02.OGG"] = 01.62,
						["Sigh03.OGG"] = 01.79,
						["Silly01.OGG"] = 06.51,
						["Silly02.OGG"] = 06.93,
						["Silly03.OGG"] = 07.29,
						["Silly04.OGG"] = 03.58,
						["Silly05.OGG"] = 11.56,
						["Silly06.OGG"] = 07.45,
						["Silly07.OGG"] = 10.58,
						["Silly08.OGG"] = 08.42,
						["Silly09.OGG"] = 05.57,
						["Silly10.OGG"] = 15.14,
						["ThankYou01.OGG"] = 01.48,
						["ThankYou02.OGG"] = 00.55,
						["ThankYou03.OGG"] = 02.31,
						["Train01.OGG"] = 06.38,
						["Train02.OGG"] = 05.84,
						["WaitHere01.OGG"] = 01.53,
						["WaitHere02.OGG"] = 02.08,
						["Wound01.OGG"] = 00.60,
						["Wound02.OGG"] = 00.67,
						["Wound03.OGG"] = 00.68,
						["Wound04.OGG"] = 00.63,
						["Wound05.OGG"] = 00.89,
						["Wound06.OGG"] = 00.55,
						["Wound07.OGG"] = 00.53,
						["Wound08.OGG"] = 00.66,
						["Wound09.OGG"] = 00.48,
						["Wound10.OGG"] = 00.60,
						["WoundCritical01.OGG"] = 00.48,
						["WoundCritical02.OGG"] = 00.81,
						["WoundCritical03.OGG"] = 00.67,
						["WoundCritical04.OGG"] = 00.65,
						["WoundCritical05.OGG"] = 00.81,
						["WoundCritical06.OGG"] = 00.48,
						["WoundCritical07.OGG"] = 00.78,
						["WoundCritical08.OGG"] = 00.57,
						["WoundCritical09.OGG"] = 00.57,
						["WoundCritical10.OGG"] = 00.57,
						["Yawn01.OGG"] = 03.10,
						["Yawn02.OGG"] = 02.23,
						["Yes01.OGG"] = 00.91,
						["Yes02.OGG"] = 00.60,
						["Yes03.OGG"] = 01.97,
						["YoureWelcome01.OGG"] = 01.46,
						["YoureWelcome02.OGG"] = 01.63,
						["YoureWelcome03.OGG"] = 05.27,
					},
				},
				["PCWorgenFemale\\VO_"] = {
					["PCWorgenFemale_"] = {
						["AttackMyTarget01.ogg"] = 02.19,
						["AttackMyTarget02.ogg"] = 02.19,
						["AttackMyTarget03.ogg"] = 01.40,
						["Charge01.ogg"] = 01.69,
						["Charge02.ogg"] = 02.04,
						["Charge03.ogg"] = 01.60,
						["Charge04.ogg"] = 01.76,
						["Cheer01.ogg"] = 00.86,
						["Cheer02.ogg"] = 01.32,
						["Cheer03.ogg"] = 01.02,
						["Chicken01.ogg"] = 03.60,
						["Congratulations01.ogg"] = 01.68,
						["Congratulations02.ogg"] = 01.88,
						["Congratulations03.ogg"] = 02.43,
						["Cry01.ogg"] = 03.38,
						["Err2hEquipped01.ogg"] = 02.13,
						["Err2hSkillNotFound01.ogg"] = 02.09,
						["Err2hSkillNotFound02.ogg"] = 02.14,
						["ErrAbilityCooldown01.ogg"] = 02.03,
						["ErrAbilityCooldown02.ogg"] = 01.58,
						["ErrAbilityCooldown03.ogg"] = 01.40,
						["ErrAlreadyInGroup01.ogg"] = 01.62,
						["ErrAmmoOnly01.ogg"] = 01.58,
						["ErrBagFull01.ogg"] = 01.43,
						["ErrCantCreateHere01.ogg"] = 01.64,
						["ErrCantDropSoulBoundItem01.ogg"] = 01.59,
						["ErrCantDropSoulBoundItem02.ogg"] = 01.46,
						["ErrCantEquipEver01.ogg"] = 02.26,
						["ErrCantEquipLevel01.ogg"] = 02.72,
						["ErrCantEquipLevel02.ogg"] = 01.77,
						["ErrCantEquipSkill01.ogg"] = 03.01,
						["ErrCantLearnSpell01.ogg"] = 01.89,
						["ErrCantTradeSoulBoundItem01.ogg"] = 01.75,
						["ErrCantUseItem01.ogg"] = 01.55,
						["ErrChestInUse01.ogg"] = 02.11,
						["ErrGenericNoTarget01.ogg"] = 01.58,
						["ErrGenericNoTarget02.ogg"] = 02.22,
						["ErrGenericNoTarget03.ogg"] = 01.28,
						["ErrGuildPermissions01.ogg"] = 01.40,
						["ErrInvalidAttackTarget01.ogg"] = 02.02,
						["ErrInvalidAttackTarget02.ogg"] = 01.66,
						["ErrInventoryFull01.ogg"] = 01.57,
						["ErrInventoryFull02.ogg"] = 01.66,
						["ErrItemCooldown01.ogg"] = 02.31,
						["ErrItemCooldown02.ogg"] = 01.66,
						["ErrItemCooldown03.ogg"] = 01.61,
						["ErrItemLocked01.ogg"] = 00.96,
						["ErrItemMaxCount01.ogg"] = 02.08,
						["ErrLootDidntKill01.ogg"] = 01.44,
						["ErrLootDidntKill02.ogg"] = 01.66,
						["ErrLootTooFar01.ogg"] = 01.57,
						["ErrLootTooFar02.ogg"] = 01.23,
						["ErrLootTooFar03.ogg"] = 01.53,
						["ErrMustEquipItem01.ogg"] = 02.44,
						["ErrMustEquipItem02.ogg"] = 01.71,
						["ErrNoAmmo01.ogg"] = 01.52,
						["ErrNoEnergy01.ogg"] = 01.54,
						["ErrNoEnergy02.ogg"] = 01.94,
						["ErrNoMana01.ogg"] = 01.64,
						["ErrNoMana02.ogg"] = 01.57,
						["ErrNoMana03.ogg"] = 01.68,
						["ErrNoRage01.ogg"] = 01.66,
						["ErrNoRage02.ogg"] = 01.61,
						["ErrNotABag01.ogg"] = 01.46,
						["ErrNotEnoughMoney01.ogg"] = 01.75,
						["ErrNotEnoughMoney02.ogg"] = 01.58,
						["ErrNotEnoughMoney03.ogg"] = 01.73,
						["ErrNotEquippable01.ogg"] = 01.51,
						["ErrOutOfRange01.ogg"] = 01.73,
						["ErrOutOfRange02.ogg"] = 01.45,
						["ErrOutOfRange03.ogg"] = 01.58,
						["ErrPartyFull01.ogg"] = 01.74,
						["ErrPotionCooldown01.ogg"] = 01.87,
						["ErrSpellCooldown01.ogg"] = 01.89,
						["ErrSpellCooldown02.ogg"] = 01.82,
						["ErrSpellCooldown03.ogg"] = 01.92,
						["Flee01.ogg"] = 04.50,
						["Flee02.ogg"] = 04.07,
						["Flee03.ogg"] = 01.42,
						["Flirt01.ogg"] = 04.44,
						["Flirt02.ogg"] = 03.51,
						["Flirt03.ogg"] = 04.89,
						["Flirt04.ogg"] = 04.91,
						["Flirt05.ogg"] = 04.78,
						["Flirt06.ogg"] = 02.85,
						["Flirt07.ogg"] = 03.24,
						["Flirt08.ogg"] = 03.97,
						["Flirt09.ogg"] = 03.47,
						["FollowMe01.ogg"] = 01.24,
						["FollowMe02.ogg"] = 01.56,
						["FollowMe03.ogg"] = 01.19,
						["Goodbye01.ogg"] = 00.98,
						["Goodbye02.ogg"] = 02.53,
						["Goodbye03.ogg"] = 02.72,
						["Goodbye04.ogg"] = 02.13,
						["HealMe01.ogg"] = 01.04,
						["HealMe02.ogg"] = 01.90,
						["Hello01.ogg"] = 02.29,
						["Hello02.ogg"] = 01.20,
						["Hello03.ogg"] = 02.22,
						["Hello04.ogg"] = 02.39,
						["Help01.ogg"] = 01.67,
						["Help02.ogg"] = 00.90,
						["IncomingDanger01.ogg"] = 01.74,
						["Kiss01.ogg"] = 00.61,
						["Laugh01.ogg"] = 05.96,
						["No01.ogg"] = 00.60,
						["No02.ogg"] = 00.87,
						["No03.ogg"] = 00.60,
						["Nod01.ogg"] = 00.54,
						["Nod02.ogg"] = 00.42,
						["OpenFire01.ogg"] = 00.77,
						["OpenFire02.ogg"] = 01.71,
						["OutofMana01.ogg"] = 01.66,
						["OutofMana02.ogg"] = 02.17,
						["Raspberry01.OGG"] = 02.75,
						["Sigh01.OGG"] = 02.66,
						["Silly01.ogg"] = 04.14,
						["Silly02.ogg"] = 05.44,
						["Silly03.ogg"] = 05.01,
						["Silly04.ogg"] = 02.31,
						["Silly05.ogg"] = 03.97,
						["Silly06.ogg"] = 11.46,
						["Silly07.ogg"] = 17.64,
						["Silly08.ogg"] = 06.63,
						["Silly09.ogg"] = 03.11,
						["Silly10.ogg"] = 05.35,
						["ThankYou01.ogg"] = 01.18,
						["ThankYou02.ogg"] = 01.75,
						["ThankYou03.ogg"] = 00.82,
						["Train01.ogg"] = 02.31,
						["WaitHere01.ogg"] = 01.57,
						["WaitHere02.ogg"] = 01.14,
						["Yes01.ogg"] = 01.23,
						["Yes02.ogg"] = 01.10,
						["Yes03.ogg"] = 01.34,
						["YourWelcome01.ogg"] = 01.31,
						["YourWelcome02.ogg"] = 01.31,
						["YourWelcome03.ogg"] = 02.66,
					},
				},
				["PCWorgenMale\\VO_"] = {
					["PCWorgenMale_"] = {
						["AttackMyTarget01.ogg"] = 02.66,
						["AttackMyTarget02.ogg"] = 01.90,
						["AttackMyTarget03.ogg"] = 01.35,
						["Charge01.ogg"] = 04.52,
						["Charge02.ogg"] = 01.62,
						["Charge03.ogg"] = 03.01,
						["Charge04.ogg"] = 02.50,
						["Charge05.ogg"] = 02.81,
						["Cheer01.ogg"] = 01.77,
						["Cheer02.ogg"] = 02.13,
						["Chicken01.ogg"] = 02.51,
						["Congratulations01.ogg"] = 01.83,
						["Congratulations02.ogg"] = 01.86,
						["Congratulations03.ogg"] = 02.45,
						["Cry01.ogg"] = 02.59,
						["Err2hEquipped01.ogg"] = 02.40,
						["Err2hSkillNotFound01.ogg"] = 01.82,
						["Err2hSkillNotFound02.ogg"] = 01.82,
						["ErrAbilityCooldown01.ogg"] = 02.19,
						["ErrAbilityCooldown02.ogg"] = 01.56,
						["ErrAbilityCooldown03.ogg"] = 01.49,
						["ErrAlreadyInGroup01.ogg"] = 01.62,
						["ErrAmmoOnly01.ogg"] = 01.51,
						["ErrBagFull01.ogg"] = 01.34,
						["ErrCantCreateHere01.ogg"] = 01.57,
						["ErrCantDropSoulBoundItem01.ogg"] = 01.57,
						["ErrCantDropSoulBoundItem02.ogg"] = 01.54,
						["ErrCantEquipEver01.ogg"] = 01.94,
						["ErrCantEquipLevel01.ogg"] = 02.27,
						["ErrCantEquipLevel02.ogg"] = 01.72,
						["ErrCantEquipSkill01.ogg"] = 02.92,
						["ErrCantLearnSpell01.ogg"] = 01.87,
						["ErrCantTradeSoulBoundItem01.ogg"] = 01.32,
						["ErrCantUseItem01.ogg"] = 01.29,
						["ErrChestInUse01.ogg"] = 01.87,
						["ErrGenericNoTarget01.ogg"] = 01.47,
						["ErrGenericNoTarget02.ogg"] = 02.36,
						["ErrGenericNoTarget03.ogg"] = 01.16,
						["ErrGuildPermissions01.ogg"] = 01.21,
						["ErrGuildPermissions02.ogg"] = 02.40,
						["ErrInvalidAttackTarget01.ogg"] = 02.09,
						["ErrInvalidAttackTarget02.ogg"] = 01.42,
						["ErrInventoryFull01.ogg"] = 01.66,
						["ErrInventoryFull02.ogg"] = 01.86,
						["ErrItemCooldown01.ogg"] = 01.78,
						["ErrItemCooldown02.ogg"] = 01.49,
						["ErrItemCooldown03.ogg"] = 01.98,
						["ErrItemLocked01.ogg"] = 00.94,
						["ErrItemMaxCount01.ogg"] = 02.28,
						["ErrLootDidntKill01.ogg"] = 01.48,
						["ErrLootDidntKill02.ogg"] = 01.57,
						["ErrLootTooFar01.ogg"] = 01.96,
						["ErrLootTooFar02.ogg"] = 01.36,
						["ErrLootTooFar03.ogg"] = 01.49,
						["ErrMustEquipItem01.ogg"] = 02.29,
						["ErrMustEquipItem02.ogg"] = 01.48,
						["ErrNoAmmo01.ogg"] = 01.25,
						["ErrNoEnergy01.ogg"] = 01.51,
						["ErrNoEnergy02.ogg"] = 02.02,
						["ErrNoMana01.ogg"] = 01.28,
						["ErrNoMana02.ogg"] = 01.79,
						["ErrNoMana03.ogg"] = 01.56,
						["ErrNoRage01.ogg"] = 01.77,
						["ErrNoRage02.ogg"] = 01.83,
						["ErrNotABag01.ogg"] = 01.44,
						["ErrNotEnoughMoney02.ogg"] = 01.36,
						["ErrNotEnoughMoney03.ogg"] = 01.81,
						["ErrNotEquippable01.ogg"] = 01.49,
						["ErrOutOfRange01.ogg"] = 01.77,
						["ErrOutOfRange02.ogg"] = 01.55,
						["ErrOutOfRange03.ogg"] = 01.73,
						["ErrPartyFull01.ogg"] = 02.14,
						["ErrPotionCooldown01.ogg"] = 02.12,
						["ErrSpellCooldown01.ogg"] = 02.38,
						["ErrSpellCooldown02.ogg"] = 01.99,
						["ErrSpellCooldown03.ogg"] = 01.84,
						["Flee01.ogg"] = 04.05,
						["Flee02.ogg"] = 04.08,
						["Flee03.ogg"] = 01.17,
						["Flirt01.ogg"] = 03.94,
						["Flirt02.ogg"] = 05.31,
						["Flirt03.ogg"] = 04.52,
						["Flirt04.ogg"] = 05.92,
						["Flirt05.ogg"] = 02.73,
						["Flirt06.ogg"] = 06.30,
						["Flirt07.ogg"] = 05.58,
						["Flirt08.ogg"] = 05.79,
						["Flirt09.ogg"] = 05.02,
						["Flirt10.ogg"] = 03.71,
						["FollowMe01.ogg"] = 01.12,
						["FollowMe02.ogg"] = 01.01,
						["FollowMe03.ogg"] = 00.89,
						["Goodbye01.ogg"] = 00.77,
						["Goodbye02.ogg"] = 02.27,
						["Goodbye03.ogg"] = 02.42,
						["Goodbye04.ogg"] = 02.13,
						["HealMe01.ogg"] = 00.86,
						["HealMe02.ogg"] = 01.52,
						["Hello01.ogg"] = 01.88,
						["Hello02.ogg"] = 01.16,
						["Hello03.ogg"] = 02.28,
						["Hello04.ogg"] = 02.34,
						["Help01.ogg"] = 01.47,
						["Help02.ogg"] = 00.72,
						["Howl01.ogg"] = 05.94,
						["Howl02.ogg"] = 07.10,
						["Howl03.ogg"] = 08.61,
						["IncomingDanger01.ogg"] = 01.79,
						["Kiss01.ogg"] = 00.71,
						["Laugh01.ogg"] = 03.97,
						["No01.ogg"] = 00.73,
						["No02.ogg"] = 01.00,
						["No03.ogg"] = 00.89,
						["Nod01.ogg"] = 00.66,
						["Nod02.ogg"] = 01.26,
						["Nod03.ogg"] = 00.93,
						["OpenFire01.ogg"] = 00.81,
						["OpenFire02.ogg"] = 01.87,
						["OutofMana01.ogg"] = 01.41,
						["OutofMana02.ogg"] = 01.98,
						["Raspberry01.ogg"] = 00.88,
						["Roar01.ogg"] = 02.16,
						["Silly01.ogg"] = 11.17,
						["Silly02.ogg"] = 10.03,
						["Silly03.ogg"] = 04.70,
						["Silly04.ogg"] = 07.67,
						["Silly05.ogg"] = 04.28,
						["Silly06.ogg"] = 03.80,
						["Silly07.ogg"] = 03.52,
						["Silly08.ogg"] = 02.62,
						["Silly09.ogg"] = 02.64,
						["Silly10.ogg"] = 02.72,
						["ThankYou01.ogg"] = 01.18,
						["ThankYou02.ogg"] = 01.95,
						["ThankYou03.ogg"] = 01.23,
						["Train01.ogg"] = 02.56,
						["WaitHere01.ogg"] = 01.67,
						["WaitHere02.ogg"] = 01.03,
						["Yes01.ogg"] = 01.67,
						["Yes02.ogg"] = 01.03,
						["Yes03.ogg"] = 01.38,
						["YoureWelcome01.ogg"] = 02.73,
						["YoureWelcome02.ogg"] = 01.26,
						["YoureWelcome03.ogg"] = 02.68,
					},
				},
				["PlayerExertions\\"] = {
					["DwarfFemaleFinal\\"] = {
						["VO_PCDwarfFemaleMain_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.62,
								["02.OGG"] = 00.64,
								["03.OGG"] = 00.33,
								["04.OGG"] = 00.49,
								["05.OGG"] = 00.47,
								["06.OGG"] = 00.42,
							},
							["Death_"] = {
								["01.OGG"] = 03.12,
								["02.OGG"] = 01.48,
								["03.OGG"] = 01.15,
								["04.OGG"] = 02.05,
								["05.OGG"] = 02.47,
								["06.OGG"] = 02.24,
								["07.OGG"] = 02.48,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.91,
								["02.OGG"] = 01.30,
								["03.OGG"] = 01.11,
								["04.OGG"] = 01.01,
							},
							["Wound_"] = {
								["01.OGG"] = 00.38,
								["02.OGG"] = 00.38,
								["03.OGG"] = 00.42,
								["04.OGG"] = 00.33,
								["05.OGG"] = 00.39,
								["06.OGG"] = 00.39,
							},
						},
						["DwarfFemaleMainAttackA.ogg"] = 00.33,
						["DwarfFemaleMainAttackB.ogg"] = 00.56,
						["DwarfFemaleMainAttackC.ogg"] = 00.36,
						["DwarfFemaleMainAttackD.ogg"] = 00.40,
						["DwarfFemaleMainDeathA.ogg"] = 01.36,
						["DwarfFemaleMainJump.ogg"] = 00.19,
						["DwarfFemaleMainLand.ogg"] = 00.40,
						["DwarfFemaleMainWoundA.ogg"] = 00.32,
						["DwarfFemaleMainWoundB.ogg"] = 00.27,
						["DwarfFemaleMainWoundC.ogg"] = 00.27,
						["DwarfFemaleMainWoundCritA.ogg"] = 00.40,
						["DwarfFemaleMainWoundCritB.ogg"] = 00.62,
						["DwarfFemaleMainWoundD.ogg"] = 00.34,
					},
					["DwarfMaleFinal\\"] = {
						["VO_PCDwarfMaleMain_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.88,
								["02.OGG"] = 00.47,
								["03.OGG"] = 00.49,
								["04.OGG"] = 00.81,
								["05.OGG"] = 00.73,
								["06.OGG"] = 00.90,
							},
							["Death_"] = {
								["01.OGG"] = 02.31,
								["02.OGG"] = 01.21,
								["03.OGG"] = 02.12,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.46,
								["02.OGG"] = 00.81,
								["03.OGG"] = 00.69,
								["04.OGG"] = 00.60,
							},
							["Wound_"] = {
								["01.OGG"] = 00.36,
								["02.OGG"] = 00.43,
								["03.OGG"] = 00.37,
								["04.OGG"] = 00.48,
								["05.OGG"] = 00.51,
								["06.OGG"] = 00.52,
							},
						},
						["DwarfMaleMainAttackA.ogg"] = 00.42,
						["DwarfMaleMainAttackB.ogg"] = 00.50,
						["DwarfMaleMainAttackC.ogg"] = 00.45,
						["DwarfMaleMainAttackD.ogg"] = 00.81,
						["DwarfMaleMainDeathA.ogg"] = 02.33,
						["DwarfMaleMainDeathB.ogg"] = 02.49,
						["DwarfMaleMainJump.ogg"] = 00.47,
						["DwarfMaleMainLand.ogg"] = 00.23,
						["DwarfMaleMainWoundA.ogg"] = 00.35,
						["DwarfMaleMainWoundB.ogg"] = 00.49,
						["DwarfMaleMainWoundC.ogg"] = 00.45,
						["DwarfMaleMainWoundCritA.ogg"] = 00.63,
						["DwarfMaleMainWoundCritB.ogg"] = 00.68,
						["DwarfMaleMainWoundD.ogg"] = 00.47,
					},
					["GnomeFemaleFinal\\"] = {
						["VO_PCGnomeFemaleMain_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.42,
								["02.OGG"] = 00.40,
								["03.OGG"] = 00.48,
								["04.OGG"] = 00.87,
								["05.OGG"] = 00.51,
								["06.OGG"] = 00.51,
							},
							["Death_"] = {
								["01.OGG"] = 01.65,
								["02.OGG"] = 02.61,
								["03.OGG"] = 02.18,
								["04.OGG"] = 02.63,
							},
							["Wound_"] = {
								["01.OGG"] = 00.43,
								["02.OGG"] = 00.45,
								["03.OGG"] = 00.50,
								["04.OGG"] = 00.37,
								["05.OGG"] = 00.36,
								["06.OGG"] = 00.55,
								["07.OGG"] = 00.36,
							},
							["WoundCrit_01.OGG"] = 01.27,
						},
						["GnomeFemaleMainAttackA.ogg"] = 00.36,
						["GnomeFemaleMainAttackB.ogg"] = 00.24,
						["GnomeFemaleMainAttackC.ogg"] = 00.21,
						["GnomeFemaleMainAttackD.ogg"] = 00.34,
						["GnomeFemaleMainDeathA.ogg"] = 01.62,
						["GnomeFemaleMainJump.ogg"] = 00.26,
						["GnomeFemaleMainLand.ogg"] = 00.27,
						["GnomeFemaleMainWoundA.ogg"] = 00.24,
						["GnomeFemaleMainWoundB.ogg"] = 00.37,
						["GnomeFemaleMainWoundC.ogg"] = 00.19,
						["GnomeFemaleMainWoundCritA.ogg"] = 00.48,
						["GnomeFemaleMainWoundCritB.ogg"] = 00.74,
					},
					["GnomeMaleFinal\\"] = {
						["VO_PCGnomeMaleMain_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.31,
								["02.OGG"] = 00.39,
								["03.OGG"] = 00.46,
								["04.OGG"] = 00.27,
								["05.OGG"] = 00.26,
								["06.OGG"] = 00.40,
							},
							["Death_"] = {
								["01.OGG"] = 01.05,
								["02.OGG"] = 00.66,
								["03.OGG"] = 01.45,
								["04.OGG"] = 01.34,
								["05.OGG"] = 01.68,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.87,
								["02.OGG"] = 00.60,
								["03.OGG"] = 00.72,
								["04.OGG"] = 00.55,
								["05.OGG"] = 00.61,
							},
							["Wound_"] = {
								["01.OGG"] = 00.51,
								["02.OGG"] = 00.47,
								["03.OGG"] = 00.40,
								["04.OGG"] = 00.25,
								["05.OGG"] = 00.70,
								["06.OGG"] = 00.44,
							},
						},
						["GnomeMaleMainAttackA.ogg"] = 00.21,
						["GnomeMaleMainAttackB.ogg"] = 00.27,
						["GnomeMaleMainAttackC.ogg"] = 00.34,
						["GnomeMaleMainAttackD.ogg"] = 00.64,
						["GnomeMaleMainDeathA.ogg"] = 00.92,
						["GnomeMaleMainJump.ogg"] = 00.35,
						["GnomeMaleMainLand.ogg"] = 00.27,
						["GnomeMaleMainWoundA.ogg"] = 00.35,
						["GnomeMaleMainWoundB.ogg"] = 00.27,
						["GnomeMaleMainWoundC.ogg"] = 00.63,
						["GnomeMaleMainWoundCrit.ogg"] = 00.80,
						["GnomeMaleMainWoundD.ogg"] = 00.40,
					},
					["HumanFemaleFinal\\"] = {
						["VO_PCHumanFemaleMain_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.83,
								["02.OGG"] = 00.90,
								["03.OGG"] = 00.61,
								["04.OGG"] = 00.56,
								["05.OGG"] = 00.60,
								["07.OGG"] = 00.89,
							},
							["Death_"] = {
								["01.OGG"] = 01.76,
								["02.OGG"] = 01.58,
								["03.OGG"] = 01.95,
								["04.OGG"] = 01.65,
								["05.OGG"] = 02.04,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.27,
								["02.OGG"] = 01.17,
								["03.OGG"] = 00.71,
							},
							["Wound_"] = {
								["01.OGG"] = 00.45,
								["02.OGG"] = 00.92,
								["03.OGG"] = 00.63,
								["04.OGG"] = 00.65,
								["05.OGG"] = 00.52,
							},
						},
						["HumanFeamleMainAttackA.ogg"] = 00.47,
						["HumanFeamleMainAttackB.ogg"] = 00.73,
						["HumanFeamleMainAttackC.ogg"] = 00.46,
						["HumanFeamleMainAttackD.ogg"] = 00.76,
						["HumanFeamleMainDeathA.ogg"] = 01.94,
						["HumanFeamleMainJump.ogg"] = 00.35,
						["HumanFeamleMainLand.ogg"] = 00.33,
						["HumanFeamleMainWoundA.ogg"] = 00.31,
						["HumanFeamleMainWoundB.ogg"] = 00.33,
						["HumanFeamleMainWoundC.ogg"] = 00.28,
						["HumanFeamleMainWoundCritA.ogg"] = 00.74,
						["HumanFeamleMainWoundD.ogg"] = 00.37,
					},
					["HUMANMALEFINAL\\"] = {
						["HumanMaleMain_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.37,
								["02.OGG"] = 00.36,
								["03.OGG"] = 00.48,
								["04.OGG"] = 00.32,
								["05.OGG"] = 00.55,
								["06.OGG"] = 00.30,
								["07.OGG"] = 00.27,
							},
							["Death_"] = {
								["1.OGG"] = 02.96,
								["2.OGG"] = 02.54,
								["3.OGG"] = 03.43,
								["4.OGG"] = 03.32,
								["6.OGG"] = 03.05,
							},
							["WoundCrit_"] = {
								["1.OGG"] = 00.54,
								["2.OGG"] = 00.48,
								["3.OGG"] = 00.50,
								["4.OGG"] = 00.47,
								["6.OGG"] = 00.36,
								["7.OGG"] = 00.46,
							},
							["Wound_"] = {
								["01.OGG"] = 00.28,
								["02.OGG"] = 00.45,
								["03.OGG"] = 00.46,
								["04.OGG"] = 00.45,
								["05.OGG"] = 00.42,
								["06.OGG"] = 00.59,
								["07.OGG"] = 00.43,
							},
						},
						["HumanMaleMainAttackA.ogg"] = 00.54,
						["HumanMaleMainAttackB.ogg"] = 00.40,
						["HumanMaleMainAttackC.ogg"] = 00.28,
						["HumanMaleMainDeathA.ogg"] = 02.90,
						["HumanMaleMainJump.ogg"] = 00.27,
						["HumanMaleMainLand.ogg"] = 00.28,
						["HumanMaleMainWoundA.ogg"] = 00.46,
						["HumanMaleMainWoundB.ogg"] = 00.45,
						["HumanMaleMainWoundC.ogg"] = 00.48,
						["HumanMaleMainWoundCritA.ogg"] = 00.62,
						["HumanMaleMainWoundCritB.ogg"] = 01.03,
					},
					["NightElfFemaleFinal\\"] = {
						["VO_PCNightElfFemale_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.21,
								["02.OGG"] = 00.30,
								["03.OGG"] = 00.25,
								["04.OGG"] = 00.39,
								["05.OGG"] = 00.29,
								["06.OGG"] = 00.47,
							},
							["Death_"] = {
								["01.OGG"] = 01.65,
								["02.OGG"] = 01.85,
								["03.OGG"] = 01.80,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.87,
								["02.OGG"] = 00.85,
								["03.OGG"] = 00.81,
								["04.OGG"] = 00.93,
								["05.OGG"] = 00.84,
							},
							["Wound_"] = {
								["01.OGG"] = 00.33,
								["02.OGG"] = 00.59,
								["03.OGG"] = 00.57,
								["04.OGG"] = 00.58,
								["05.OGG"] = 00.71,
							},
						},
						["NightElfFemaleMainAttackA.ogg"] = 00.44,
						["NightElfFemaleMainAttackB.ogg"] = 00.28,
						["NightElfFemaleMainAttackC.ogg"] = 00.41,
						["NightElfFemaleMainAttackD.ogg"] = 00.48,
						["NightElfFemaleMainDeath.ogg"] = 00.61,
						["NightElfFemaleMainJump.ogg"] = 00.26,
						["NightElfFemaleMainLand.ogg"] = 00.39,
						["NightElfFemaleMainWoundA.ogg"] = 00.53,
						["NightElfFemaleMainWoundB.ogg"] = 00.37,
						["NightElfFemaleMainWoundC.ogg"] = 00.44,
						["NightElfFemaleMainWoundCritA.ogg"] = 00.70,
						["NightElfFemaleMainWoundD.ogg"] = 00.67,
					},
					["NightElfMaleFinal\\"] = {
						["VO_PCNightElfMale_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.47,
								["02.OGG"] = 00.47,
								["03.OGG"] = 00.23,
								["04.OGG"] = 00.39,
								["05.OGG"] = 00.40,
								["06.OGG"] = 00.45,
							},
							["Death_"] = {
								["01.OGG"] = 01.62,
								["02.OGG"] = 01.76,
								["03.OGG"] = 01.93,
								["04.OGG"] = 01.85,
								["05.OGG"] = 01.61,
								["06.OGG"] = 01.56,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.06,
								["02.OGG"] = 00.84,
								["03.OGG"] = 00.89,
								["04.OGG"] = 00.70,
								["05.OGG"] = 01.21,
							},
							["Wound_"] = {
								["01.OGG"] = 00.30,
								["02.OGG"] = 00.22,
								["03.OGG"] = 00.55,
								["04.OGG"] = 00.44,
								["05.OGG"] = 00.54,
								["06.OGG"] = 00.23,
							},
						},
						["NightElfMaleMainAttackA.ogg"] = 00.46,
						["NightElfMaleMainAttackB.ogg"] = 00.32,
						["NightElfMaleMainAttackC.ogg"] = 00.47,
						["NightElfMaleMainAttackD.ogg"] = 00.29,
						["NightElfMaleMainDeath.ogg"] = 02.72,
						["NightElfMaleMainJump.ogg"] = 00.32,
						["NightElfMaleMainLand.ogg"] = 00.26,
						["NightElfMaleMainWoundA.ogg"] = 00.21,
						["NightElfMaleMainWoundB.ogg"] = 00.37,
						["NightElfMaleMainWoundC.ogg"] = 00.29,
						["NightElfMaleMainWoundCritA.ogg"] = 00.81,
						["NightElfMaleMainWoundCritB.ogg"] = 00.65,
						["NightElfMaleMainWoundD.ogg"] = 00.28,
					},
					["OrcFemaleFinal\\"] = {
						["VO_PCOrcFemale_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.48,
								["02.OGG"] = 00.49,
								["03.OGG"] = 00.64,
								["04.OGG"] = 00.56,
								["05.OGG"] = 00.81,
							},
							["Death_"] = {
								["01.OGG"] = 03.42,
								["02.OGG"] = 02.57,
								["03.OGG"] = 01.49,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.86,
								["02.OGG"] = 00.72,
								["03.OGG"] = 00.55,
								["04.OGG"] = 00.83,
							},
							["Wound_"] = {
								["01.OGG"] = 00.36,
								["02.OGG"] = 00.44,
								["03.OGG"] = 00.44,
							},
						},
						["OrcFemaleMainAttackA.ogg"] = 00.41,
						["OrcFemaleMainAttackB.ogg"] = 00.51,
						["OrcFemaleMainAttackC.ogg"] = 00.42,
						["OrcFemaleMainAttackD.ogg"] = 00.42,
						["OrcFemaleMainDeathA.ogg"] = 02.56,
						["OrcFemaleMainJump.ogg"] = 00.36,
						["OrcFemaleMainLand.ogg"] = 00.53,
						["OrcFemaleMainWoundA.ogg"] = 00.27,
						["OrcFemaleMainWoundB.ogg"] = 00.28,
						["OrcFemaleMainWoundC.ogg"] = 00.38,
						["OrcFemaleMainWoundCritA.ogg"] = 00.64,
						["OrcFemaleMainWoundCritB.ogg"] = 00.55,
						["OrcFemaleMainWoundD.ogg"] = 00.31,
					},
					["OrcMale\\"] = {
						["VO_PCOrcMale_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.56,
								["02.OGG"] = 00.64,
								["03.OGG"] = 00.72,
								["04.OGG"] = 00.62,
								["05.OGG"] = 00.56,
								["06.OGG"] = 00.95,
							},
							["Death_"] = {
								["01.OGG"] = 03.30,
								["02.OGG"] = 03.02,
								["03.OGG"] = 02.42,
								["04.OGG"] = 02.27,
								["05.OGG"] = 02.83,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.13,
								["02.OGG"] = 00.95,
								["03.OGG"] = 00.80,
								["04.OGG"] = 00.96,
							},
							["Wound_"] = {
								["01.OGG"] = 00.50,
								["02.OGG"] = 00.57,
								["03.OGG"] = 00.46,
								["04.OGG"] = 00.63,
								["05.OGG"] = 00.61,
								["06.OGG"] = 00.60,
							},
						},
						["OrcMaleMainAttackA.ogg"] = 00.45,
						["OrcMaleMainAttackB.ogg"] = 00.52,
						["OrcMaleMainAttackC.ogg"] = 00.43,
						["OrcMaleMainDeathA.ogg"] = 02.90,
						["OrcMaleMainJump.ogg"] = 00.28,
						["OrcMaleMainLand.ogg"] = 00.40,
						["OrcMaleMainWoundA.ogg"] = 00.39,
						["OrcMaleMainWoundB.ogg"] = 00.52,
						["OrcMaleMainWoundC.ogg"] = 00.40,
						["OrcMaleMainWoundCrit.ogg"] = 00.84,
						["OrcMaleMainWoundD.ogg"] = 00.46,
					},
					["TaurenFemaleFinal\\"] = {
						["VO_PCTaurenFemale_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.69,
								["02.OGG"] = 00.52,
								["03.OGG"] = 00.53,
								["04.OGG"] = 00.76,
								["05.OGG"] = 00.74,
								["06.OGG"] = 00.73,
							},
							["Death_"] = {
								["01.OGG"] = 01.76,
								["02.OGG"] = 01.85,
								["03.OGG"] = 01.49,
								["04.OGG"] = 01.71,
								["05.OGG"] = 01.81,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.63,
								["02.OGG"] = 00.56,
								["03.OGG"] = 00.69,
								["04.OGG"] = 00.92,
								["05.OGG"] = 01.31,
								["06.OGG"] = 00.83,
							},
							["Wound_"] = {
								["01.OGG"] = 00.39,
								["02.OGG"] = 00.41,
								["03.OGG"] = 00.64,
								["04.OGG"] = 00.37,
								["05.OGG"] = 00.59,
							},
						},
						["TaurenFemaleFinalAttackA.ogg"] = 00.28,
						["TaurenFemaleFinalAttackB.ogg"] = 00.67,
						["TaurenFemaleFinalAttackC.ogg"] = 00.32,
						["TaurenFemaleFinalAttackD.ogg"] = 00.74,
						["TaurenFemaleFinalDeathA.ogg"] = 01.76,
						["TaurenFemaleFinalJump.ogg"] = 00.21,
						["TaurenFemaleFinalLand.ogg"] = 00.72,
						["TaurenFemaleFinalWoundA.ogg"] = 00.32,
						["TaurenFemaleFinalWoundB.ogg"] = 00.31,
						["TaurenFemaleFinalWoundC.ogg"] = 00.26,
						["TaurenFemaleFinalWoundCritA.ogg"] = 00.82,
					},
					["TaurenMaleFinal\\"] = {
						["VO_PCTaurenMale_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.71,
								["02.OGG"] = 01.09,
								["03.OGG"] = 00.62,
								["04.OGG"] = 01.65,
								["05.OGG"] = 00.95,
								["06.OGG"] = 00.59,
							},
							["Death_"] = {
								["01.OGG"] = 03.63,
								["02.OGG"] = 03.41,
								["03.OGG"] = 03.79,
								["04.OGG"] = 03.58,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.91,
								["02.OGG"] = 01.02,
								["03.OGG"] = 01.19,
								["04.OGG"] = 00.94,
								["05.OGG"] = 00.71,
								["06.OGG"] = 00.57,
								["07.OGG"] = 01.02,
							},
							["Wound_"] = {
								["01.OGG"] = 00.92,
								["02.OGG"] = 00.33,
								["03.OGG"] = 00.37,
								["04.OGG"] = 00.66,
								["05.OGG"] = 00.75,
								["06.OGG"] = 00.66,
							},
						},
						["TaurenMaleMainAttackA.ogg"] = 00.71,
						["TaurenMaleMainAttackB.ogg"] = 00.68,
						["TaurenMaleMainAttackC.ogg"] = 00.90,
						["TaurenMaleMainAttackD.ogg"] = 00.63,
						["TaurenMaleMainDeathA.ogg"] = 03.63,
						["TaurenMaleMainJump.ogg"] = 00.27,
						["TaurenMaleMainLand.ogg"] = 00.62,
						["TaurenMaleMainWoundA.ogg"] = 00.34,
						["TaurenMaleMainWoundB.ogg"] = 00.66,
						["TaurenMaleMainWoundC.ogg"] = 00.52,
						["TaurenMaleMainWoundCritA.ogg"] = 00.91,
						["TaurenMaleMainWoundD.ogg"] = 00.71,
					},
					["TrollFemaleFinal\\"] = {
						["VO_PCTrollFemaleMain_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.90,
								["02.OGG"] = 00.85,
								["03.OGG"] = 00.58,
								["04.OGG"] = 00.55,
								["05.OGG"] = 00.77,
							},
							["Death_"] = {
								["01.OGG"] = 01.82,
								["02.OGG"] = 02.45,
								["03.OGG"] = 02.68,
								["04.OGG"] = 01.50,
								["05.OGG"] = 01.51,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.36,
								["02.OGG"] = 01.05,
								["03.OGG"] = 01.36,
								["04.OGG"] = 01.06,
								["05.OGG"] = 00.46,
								["06.OGG"] = 00.61,
							},
							["Wound_"] = {
								["01.OGG"] = 00.37,
								["02.OGG"] = 00.46,
								["03.OGG"] = 00.93,
								["04.OGG"] = 00.88,
								["05.OGG"] = 00.40,
								["06.OGG"] = 00.67,
							},
						},
						["TrollFemalMainAttackA.ogg"] = 00.55,
						["TrollFemalMainAttackB.ogg"] = 00.59,
						["TrollFemalMainAttackC.ogg"] = 00.74,
						["TrollFemalMainAttackD.ogg"] = 00.90,
						["TrollFemalMainDeath.ogg"] = 02.94,
						["TrollFemalMainJump.ogg"] = 00.38,
						["TrollFemalMainLand.ogg"] = 00.24,
						["TrollFemalMainWoundA.ogg"] = 00.39,
						["TrollFemalMainWoundB.ogg"] = 00.51,
						["TrollFemalMainWoundC.ogg"] = 00.78,
						["TrollFemalMainWoundCrit.ogg"] = 00.93,
					},
					["TrollMaleFinal\\"] = {
						["VO_PCTrollMaleMain_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.69,
								["02.OGG"] = 00.63,
								["03.OGG"] = 00.78,
								["04.OGG"] = 00.36,
								["05.OGG"] = 00.48,
							},
							["Death_"] = {
								["01.OGG"] = 02.99,
								["02.OGG"] = 02.92,
								["03.OGG"] = 02.38,
								["04.OGG"] = 02.67,
								["05.OGG"] = 03.04,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.44,
								["02.OGG"] = 00.83,
								["03.OGG"] = 00.81,
							},
							["Wound_"] = {
								["01.OGG"] = 00.79,
								["02.OGG"] = 01.13,
								["03.OGG"] = 00.77,
								["04.OGG"] = 01.08,
							},
						},
						["TrollMaleMainAttackA.ogg"] = 00.84,
						["TrollMaleMainAttackB.ogg"] = 00.91,
						["TrollMaleMainAttackC.ogg"] = 00.38,
						["TrollMaleMainAttackD.ogg"] = 00.36,
						["TrollMaleMainDeath.ogg"] = 03.53,
						["TrollMaleMainJump.ogg"] = 00.22,
						["TrollMaleMainLand.ogg"] = 00.80,
						["TrollMaleMainWoundA.ogg"] = 00.75,
						["TrollMaleMainWoundB.ogg"] = 00.66,
						["TrollMaleMainWoundC.ogg"] = 00.82,
						["TrollMaleMainWoundCritA.ogg"] = 01.25,
						["TrollMaleMainWoundCritB.ogg"] = 00.73,
						["TrollMaleMainWoundD.ogg"] = 01.07,
					},
					["UndeadFemaleFinal\\"] = {
						["VO_PCUndeadFemale_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.64,
								["02.OGG"] = 00.63,
								["03.OGG"] = 00.80,
								["04.OGG"] = 00.45,
								["05.OGG"] = 00.47,
								["06.OGG"] = 00.59,
							},
							["Death_"] = {
								["01.OGG"] = 02.13,
								["02.OGG"] = 02.30,
								["03.OGG"] = 02.18,
								["04.OGG"] = 02.06,
								["05.OGG"] = 02.00,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.60,
								["02.OGG"] = 00.51,
								["03.OGG"] = 00.85,
								["04.OGG"] = 00.81,
							},
							["Wound_"] = {
								["01.OGG"] = 00.45,
								["02.OGG"] = 00.29,
								["03.OGG"] = 00.36,
								["04.OGG"] = 00.35,
								["05.OGG"] = 00.54,
								["06.OGG"] = 00.28,
								["07.OGG"] = 00.51,
							},
						},
						["UndeadFemaleFinalAttackA.ogg"] = 00.70,
						["UndeadFemaleFinalAttackB.ogg"] = 00.83,
						["UndeadFemaleFinalAttackC.ogg"] = 00.72,
						["UndeadFemaleFinalAttackD.ogg"] = 00.40,
						["UndeadFemaleFinalDeath.ogg"] = 02.55,
						["UndeadFemaleFinalJump.ogg"] = 00.36,
						["UndeadFemaleFinalLand.ogg"] = 00.69,
						["UndeadFemaleFinalWound.ogg"] = 00.30,
						["UndeadFemaleFinalWoundB.ogg"] = 00.33,
						["UndeadFemaleFinalWoundC.ogg"] = 00.27,
						["UndeadFemaleFinalWoundCriatA.ogg"] = 00.53,
					},
					["UndeadMaleFinal\\"] = {
						["VO_PCUndeadMale_"] = {
							["Attack_"] = {
								["01.OGG"] = 00.68,
								["02.OGG"] = 00.47,
								["03.OGG"] = 01.14,
								["04.OGG"] = 01.19,
							},
							["Death_"] = {
								["01.OGG"] = 01.69,
								["02.OGG"] = 01.63,
								["03.OGG"] = 01.55,
								["04.OGG"] = 01.83,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.15,
								["02.OGG"] = 01.08,
								["03.OGG"] = 01.07,
								["04.OGG"] = 00.97,
							},
							["Wound_"] = {
								["01.OGG"] = 00.89,
								["02.OGG"] = 00.90,
								["03.OGG"] = 00.86,
								["04.OGG"] = 00.89,
								["05.OGG"] = 01.57,
								["06.OGG"] = 00.67,
							},
						},
						["UndeadMaleMainAttackA.ogg"] = 01.29,
						["UndeadMaleMainAttackB.ogg"] = 00.99,
						["UndeadMaleMainAttackC.ogg"] = 01.30,
						["UndeadMaleMainAttackD.ogg"] = 01.63,
						["UndeadMaleMainDeath.ogg"] = 01.82,
						["UndeadMaleMainJump.ogg"] = 00.21,
						["UndeadMaleMainLand.ogg"] = 00.55,
						["UndeadMaleMainWoundA.ogg"] = 00.84,
						["UndeadMaleMainWoundB.ogg"] = 00.86,
						["UndeadMaleMainWoundC.ogg"] = 00.76,
						["UndeadMaleMainWoundCritA.ogg"] = 01.21,
						["UndeadMaleMainWoundD.ogg"] = 01.01,
					},
				},
				["PlayerRoars\\"] = {
					["CharacterRoarsDwarfFemale.ogg"] = 05.00,
					["CharacterRoarsDwarfMale.ogg"] = 04.57,
					["CharacterRoarsGnomeFemale.ogg"] = 02.97,
					["CharacterRoarsGnomeMale.ogg"] = 04.26,
					["CharacterRoarsHumanFemale.ogg"] = 04.57,
					["CharacterRoarsHumanMale.ogg"] = 04.73,
					["CharacterRoarsNightElfFemale.ogg"] = 02.77,
					["CharacterRoarsNightElfMale.ogg"] = 01.95,
					["CharacterRoarsOrcFemale.ogg"] = 02.07,
					["CharacterRoarsOrcMale.ogg"] = 04.37,
					["CharacterRoarsTaurenFemale.ogg"] = 01.74,
					["CharacterRoarsTaurenMale.ogg"] = 01.54,
					["CharacterRoarsTrollFemale.ogg"] = 01.21,
					["CharacterRoarsTrollMale.ogg"] = 01.91,
					["CharacterRoarsUndeadFemale.ogg"] = 01.66,
					["CharacterRoarsUndeadMale.ogg"] = 03.98,
				},
				["Scourge\\"] = {
					["ScourgeFemale\\"] = {
						["UndeadFemaleAttackA.ogg"] = 00.59,
						["UndeadFemaleAttackB.ogg"] = 00.80,
						["UndeadFemaleAttackC.ogg"] = 00.80,
						["UndeadFemaleChicken01.ogg"] = 04.71,
						["UndeadFemaleChooChoo01.ogg"] = 04.62,
						["UndeadFemaleCry01.ogg"] = 07.32,
						["UndeadFemaleDeathA.ogg"] = 02.64,
						["UndeadFemaleKiss01.ogg"] = 02.31,
						["UndeadFemaleLaugh01.ogg"] = 04.18,
						["UndeadFemaleSigh01.ogg"] = 03.07,
						["UndeadFemaleWoundA.ogg"] = 00.54,
						["UndeadFemaleWoundB.ogg"] = 00.65,
						["UndeadFemaleWoundC.ogg"] = 00.39,
						["UndeadFemaleWoundCrit.ogg"] = 00.94,
						["UndeadFemaleYawn01.ogg"] = 04.52,
					},
					["ScourgeFemaleErrorMessages\\UndeadFemale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.99,
								["skillnotfound03.ogg"] = 02.21,
								["skillnotfound04.ogg"] = 02.10,
							},
							["abilitycooldown01.ogg"] = 02.27,
							["abilitycooldown02.ogg"] = 01.96,
							["abilitycooldown03.ogg"] = 01.45,
							["alreadyingroup02.ogg"] = 02.35,
							["ammoonly02.ogg"] = 01.65,
							["bagfull01.ogg"] = 01.86,
							["cantcreatehere03.ogg"] = 01.73,
							["cantdropsoulbounditem01.ogg"] = 01.42,
							["cantdropsoulbounditem03.ogg"] = 01.53,
							["cantequipever01.ogg"] = 02.65,
							["cantequiplevel01.ogg"] = 03.06,
							["cantequiplevel02.ogg"] = 01.76,
							["cantequipskill03.ogg"] = 03.18,
							["cantlearnspell01.ogg"] = 01.64,
							["cantloot01.ogg"] = 01.35,
							["canttradesoulbounditem01.ogg"] = 01.67,
							["cantuseitem01.ogg"] = 01.49,
							["chestinuse02.ogg"] = 02.53,
							["genericnotarget01.ogg"] = 02.31,
							["genericnotarget02.ogg"] = 02.92,
							["genericnotarget04.ogg"] = 01.49,
							["guildpermissions01.ogg"] = 01.12,
							["guildpermissions04.ogg"] = 02.46,
							["invalidattacktarget01.ogg"] = 02.09,
							["invalidattacktarget02.ogg"] = 01.45,
							["inventoryfull01.ogg"] = 02.25,
							["inventoryfull02.ogg"] = 02.05,
							["itemcooldown02.ogg"] = 02.49,
							["itemcooldown04.ogg"] = 01.99,
							["itemcooldown06.ogg"] = 01.79,
							["itemlocked01.ogg"] = 00.89,
							["itemmaxcount01.ogg"] = 02.10,
							["lootdidntkill01.ogg"] = 01.35,
							["lootdidntkill06.ogg"] = 02.33,
							["loottoofar02.ogg"] = 01.73,
							["loottoofar03.ogg"] = 01.51,
							["loottoofar04.ogg"] = 01.43,
							["mustequipitem02.ogg"] = 02.61,
							["mustequipitem03.ogg"] = 01.52,
							["noammo05.ogg"] = 01.16,
							["noenergy01.ogg"] = 01.75,
							["noenergy02.ogg"] = 02.16,
							["nomana01.ogg"] = 01.54,
							["nomana02.ogg"] = 01.54,
							["nomana03.ogg"] = 01.57,
							["norage01.ogg"] = 01.67,
							["norage05.ogg"] = 02.22,
							["notabag01.ogg"] = 01.51,
							["notenoughmoney01.ogg"] = 01.60,
							["notenoughmoney02.ogg"] = 01.71,
							["notenoughmoney03.ogg"] = 01.82,
							["notequippable01.ogg"] = 01.40,
							["outofrange02.ogg"] = 01.75,
							["outofrange04.ogg"] = 01.44,
							["outofrange05.ogg"] = 02.17,
							["partyfull03.ogg"] = 01.81,
							["potioncooldown01.ogg"] = 01.74,
							["proficiencyneeded01.ogg"] = 01.51,
							["spellcooldown01.ogg"] = 02.21,
							["spellcooldown02.ogg"] = 02.07,
							["spellcooldown03.ogg"] = 01.79,
						},
					},
					["ScourgeMale\\"] = {
						["ScourgeMaleAttackA.ogg"] = 00.90,
						["ScourgeMaleAttackB.ogg"] = 00.62,
						["ScourgeMaleAttackC.ogg"] = 00.76,
						["ScourgeMaleAttackD.ogg"] = 00.80,
						["ScourgeMaleDeathA.ogg"] = 02.31,
						["ScourgeMaleDeathB.ogg"] = 02.77,
						["ScourgeMaleWoundA.ogg"] = 01.40,
						["ScourgeMaleWoundB.ogg"] = 00.92,
						["ScourgeMaleWoundC.ogg"] = 00.93,
						["ScourgeMaleWoundCrit.ogg"] = 01.55,
						["UndeadMaleChicken01.ogg"] = 05.11,
						["UndeadMaleChooChoo01.ogg"] = 03.69,
						["UndeadMaleCry01.ogg"] = 06.50,
						["UndeadMaleKiss01.ogg"] = 00.97,
						["UndeadMaleLaugh01.ogg"] = 02.60,
						["UndeadMaleSigh01.ogg"] = 02.31,
						["UndeadMaleYawn01.ogg"] = 05.21,
					},
					["ScourgeMaleErrorMessages\\UndeadMale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.60,
								["skillnotfound03.ogg"] = 02.09,
								["skillnotfound04.ogg"] = 02.71,
							},
							["abilitycooldown01.ogg"] = 02.97,
							["abilitycooldown02.ogg"] = 02.31,
							["abilitycooldown03.ogg"] = 01.98,
							["alreadyingroup02.ogg"] = 02.36,
							["ammoonly02.ogg"] = 02.11,
							["bagfull01.ogg"] = 02.54,
							["cantcreatehere03.ogg"] = 02.40,
							["cantdropsoulbounditem01.ogg"] = 01.84,
							["cantdropsoulbounditem03.ogg"] = 02.20,
							["cantequipever01.ogg"] = 02.33,
							["cantequiplevel01.ogg"] = 03.04,
							["cantequiplevel02.ogg"] = 01.99,
							["cantequipskill03.ogg"] = 03.67,
							["cantlearnspell01.ogg"] = 02.13,
							["cantloot01.ogg"] = 01.97,
							["canttradesoulbounditem01.ogg"] = 01.93,
							["cantuseitem01.ogg"] = 02.64,
							["chestinuse02.ogg"] = 02.35,
							["genericnotarget01.ogg"] = 01.62,
							["genericnotarget02.ogg"] = 02.31,
							["genericnotarget04.ogg"] = 01.69,
							["guildpermissions01.ogg"] = 02.20,
							["guildpermissions04.ogg"] = 03.38,
							["invalidattacktarget01.ogg"] = 01.98,
							["invalidattacktarget02.ogg"] = 02.28,
							["inventoryfull01.ogg"] = 02.64,
							["inventoryfull02.ogg"] = 02.03,
							["itemcooldown02.ogg"] = 02.23,
							["itemcooldown04.ogg"] = 01.84,
							["itemcooldown06.ogg"] = 02.05,
							["itemlocked01.ogg"] = 01.29,
							["itemmaxcount01.ogg"] = 02.76,
							["lootdidntkill01.ogg"] = 01.98,
							["lootdidntkill06.ogg"] = 02.11,
							["loottoofar02.ogg"] = 01.74,
							["loottoofar03.ogg"] = 01.56,
							["loottoofar04.ogg"] = 02.14,
							["mustequipitem02.ogg"] = 02.69,
							["mustequipitem03.ogg"] = 02.61,
							["noammo05.ogg"] = 01.56,
							["noenergy01.ogg"] = 02.76,
							["noenergy02.ogg"] = 03.23,
							["nomana01.ogg"] = 02.24,
							["nomana02.ogg"] = 03.06,
							["nomana03.ogg"] = 02.52,
							["norage01.ogg"] = 02.01,
							["norage05.ogg"] = 02.14,
							["notabag01.ogg"] = 01.94,
							["notenoughmoney01.ogg"] = 01.89,
							["notenoughmoney02.ogg"] = 01.78,
							["notenoughmoney03.ogg"] = 01.69,
							["notequippable01.ogg"] = 02.20,
							["outofrange02.ogg"] = 01.57,
							["outofrange04.ogg"] = 01.89,
							["outofrange05.ogg"] = 01.73,
							["partyfull03.ogg"] = 02.18,
							["potioncooldown01.ogg"] = 02.20,
							["proficiencyneeded01.ogg"] = 01.97,
							["spellcooldown01.ogg"] = 02.55,
							["spellcooldown02.ogg"] = 02.47,
							["spellcooldown03.ogg"] = 02.32,
						},
					},
					["ScourgeVocalFemale\\"] = {
						["UndeadFemaleAttackMyTarget01.ogg"] = 02.11,
						["UndeadFemaleAttackMyTarget02.ogg"] = 01.48,
						["UndeadFemaleCharge01.ogg"] = 02.31,
						["UndeadFemaleCharge02.ogg"] = 01.92,
						["UndeadFemaleCheer01.ogg"] = 02.96,
						["UndeadFemaleCheer02.ogg"] = 01.58,
						["UndeadFemaleCongratulations01.ogg"] = 01.92,
						["UndeadFemaleCongratulations02.ogg"] = 02.46,
						["UndeadFemaleCongratulations03.ogg"] = 02.74,
						["UndeadFemaleCongratulations04.ogg"] = 02.63,
						["UndeadFemaleFlee01.ogg"] = 01.38,
						["UndeadFemaleFlee02.ogg"] = 01.86,
						["UndeadFemaleFlirt01.ogg"] = 01.88,
						["UndeadFemaleFlirt02.ogg"] = 04.78,
						["UndeadFemaleFlirt03.ogg"] = 08.09,
						["UndeadFemaleFlirt04.ogg"] = 05.06,
						["UndeadFemaleFlirt05.ogg"] = 06.30,
						["UndeadFemaleFlirt06.ogg"] = 03.99,
						["UndeadFemaleFollowMe01.ogg"] = 01.12,
						["UndeadFemaleFollowMe02.ogg"] = 00.86,
						["UndeadFemaleGoodbye01.ogg"] = 01.29,
						["UndeadFemaleGoodbye02.ogg"] = 01.63,
						["UndeadFemaleGoodbye03.ogg"] = 01.33,
						["UndeadFemaleHealMe01.ogg"] = 01.22,
						["UndeadFemaleHealMe02.ogg"] = 01.70,
						["UndeadFemaleHello01.ogg"] = 01.15,
						["UndeadFemaleHello02.ogg"] = 01.24,
						["UndeadFemaleHello03.ogg"] = 01.19,
						["UndeadFemaleHelp01.ogg"] = 01.44,
						["UndeadFemaleHelp02.ogg"] = 01.36,
						["UndeadFemaleIncoming01.ogg"] = 01.01,
						["UndeadFemaleIncoming02.ogg"] = 01.27,
						["UndeadFemaleNo01.ogg"] = 01.17,
						["UndeadFemaleNo02.ogg"] = 01.71,
						["UndeadFemaleNo03.ogg"] = 01.55,
						["UndeadFemaleOpenFire01.ogg"] = 01.43,
						["UndeadFemaleOpenFire02.ogg"] = 01.59,
						["UndeadFemaleOutOfMana01.ogg"] = 01.71,
						["UndeadFemaleOutOfMana02.ogg"] = 02.04,
						["UndeadFemalePissed01.ogg"] = 04.50,
						["UndeadFemalePissed02.ogg"] = 04.81,
						["UndeadFemalePissed03.ogg"] = 02.69,
						["UndeadFemalePissed04.ogg"] = 01.73,
						["UndeadFemalePissed05.ogg"] = 10.61,
						["UndeadFemalePissed06.ogg"] = 04.50,
						["UndeadFemalePissed07.ogg"] = 02.49,
						["UndeadFemalePissed08.ogg"] = 04.78,
						["UndeadFemaleRaspberry01.ogg"] = 01.54,
						["UndeadFemaleThankYou01.ogg"] = 01.29,
						["UndeadFemaleThankYou02.ogg"] = 01.41,
						["UndeadFemaleThankYou03.ogg"] = 01.45,
						["UndeadFemaleWaitHere01.ogg"] = 01.50,
						["UndeadFemaleWaitHere02.ogg"] = 01.29,
						["UndeadFemaleYes01.ogg"] = 01.23,
						["UndeadFemaleYes02.ogg"] = 01.24,
						["UndeadFemaleYes03.ogg"] = 01.82,
						["UndeadFemaleYoureWelcome01.ogg"] = 01.65,
						["UndeadFemaleYoureWelcome02.ogg"] = 00.53,
						["UndeadFemaleYoureWelcome03.ogg"] = 02.16,
						["VO_PCUndeadFemaleRoar01.ogg"] = 02.18,
					},
					["ScourgeVocalMale\\"] = {
						["UndeadMaleAttackMyTarget01.ogg"] = 01.67,
						["UndeadMaleAttackMyTarget02.ogg"] = 01.45,
						["UndeadMaleCharge01.ogg"] = 02.30,
						["UndeadMaleCharge02.ogg"] = 02.51,
						["UndeadMaleCheer01.ogg"] = 02.07,
						["UndeadMaleCheer02.ogg"] = 01.47,
						["UndeadMaleCongratulations01.ogg"] = 02.29,
						["UndeadMaleCongratulations02.ogg"] = 01.60,
						["UndeadMaleCongratulations03.ogg"] = 01.52,
						["UndeadMaleFlee01.ogg"] = 01.77,
						["UndeadMaleFlee02.ogg"] = 01.67,
						["UndeadMaleFlirt01.ogg"] = 04.47,
						["UndeadMaleFlirt02.ogg"] = 05.27,
						["UndeadMaleFlirt03.ogg"] = 03.88,
						["UndeadMaleFlirt04.ogg"] = 03.55,
						["UndeadMaleFlirt05.ogg"] = 05.48,
						["UndeadMaleFlirt06.ogg"] = 03.91,
						["UndeadMaleFollowMe01.ogg"] = 01.22,
						["UndeadMaleFollowMe02.ogg"] = 02.35,
						["UndeadMaleGoodbye01.ogg"] = 01.72,
						["UndeadMaleGoodbye02.ogg"] = 02.34,
						["UndeadMaleGoodbye03.ogg"] = 02.14,
						["UndeadMaleHealMe01.ogg"] = 01.74,
						["UndeadMaleHealMe02.ogg"] = 01.34,
						["UndeadMaleHello01.ogg"] = 01.43,
						["UndeadMaleHello02.ogg"] = 01.82,
						["UndeadMaleHello03.ogg"] = 01.82,
						["UndeadMaleHelp01.ogg"] = 01.79,
						["UndeadMaleHelp02.ogg"] = 01.29,
						["UndeadMaleIncoming01.ogg"] = 01.24,
						["UndeadMaleIncoming02.ogg"] = 01.19,
						["UndeadMaleNo01.ogg"] = 01.52,
						["UndeadMaleNo02.ogg"] = 01.99,
						["UndeadMaleNo03.ogg"] = 02.18,
						["UndeadMaleOpenFire01.ogg"] = 01.62,
						["UndeadMaleOpenFire02.ogg"] = 02.21,
						["UndeadMaleOutOfMana01.ogg"] = 02.56,
						["UndeadMaleOutOfMana02.ogg"] = 02.41,
						["UndeadMalePissed01.ogg"] = 03.80,
						["UndeadMalePissed02.ogg"] = 03.30,
						["UndeadMalePissed03.ogg"] = 05.90,
						["UndeadMalePissed04.ogg"] = 12.85,
						["UndeadMalePissed05.ogg"] = 08.29,
						["UndeadMaleRaspberry01.ogg"] = 01.18,
						["UndeadMaleThankYou01.ogg"] = 02.24,
						["UndeadMaleThankYou02.ogg"] = 01.88,
						["UndeadMaleThankYou03.ogg"] = 01.88,
						["UndeadMaleWaitHere01.ogg"] = 01.04,
						["UndeadMaleWaitHere02.ogg"] = 01.83,
						["UndeadMaleYes01.ogg"] = 01.43,
						["UndeadMaleYes02.ogg"] = 01.61,
						["UndeadMaleYes03.ogg"] = 02.16,
						["UndeadMaleYoureWelcome01.ogg"] = 01.84,
						["UndeadMaleYoureWelcome02.ogg"] = 00.93,
						["VO_PCUndeadMaleRoar01.ogg"] = 02.26,
					},
					["UndeadNPC\\UndeadMaleNpc1\\"] = {
						["UndeadMaleNpc1\\"] = {
							["UndeadMaleNpc1AggroA.ogg"] = 00.62,
							["UndeadMaleNpc1AttackA.ogg"] = 00.32,
							["UndeadMaleNpc1AttackB.ogg"] = 00.52,
							["UndeadMaleNpc1AttackC.ogg"] = 00.64,
							["UndeadMaleNpc1DeathA.ogg"] = 01.58,
							["UndeadMaleNpc1PreAggro.ogg"] = 00.46,
							["UndeadMaleNpc1WoundA.ogg"] = 00.49,
							["UndeadMaleNpc1WoundB.ogg"] = 00.51,
							["UndeadMaleNpc1WoundC.ogg"] = 00.35,
							["UndeadMaleNpc1WoundCrit.ogg"] = 00.77,
						},
					},
				},
				["Tauren\\"] = {
					["Female\\"] = {
						["mTaurenFemaleAttackCriticalVoxA.ogg"] = 01.28,
						["mTaurenFemaleAttackVoxA.ogg"] = 00.81,
						["mTaurenFemaleAttackVoxB.ogg"] = 00.83,
						["mTaurenFemaleAttackVoxC.ogg"] = 00.84,
						["mTaurenFemaleDeathVoxA.ogg"] = 02.16,
						["mTaurenFemaleStandVoxA.ogg"] = 02.22,
						["mTaurenFemaleStandVoxB.ogg"] = 02.25,
						["mTaurenFemaleStandVoxC.ogg"] = 02.28,
						["mTaurenFemaleStunVoxA.ogg"] = 01.91,
						["mTaurenFemaleStunVoxB.ogg"] = 01.60,
						["mTaurenFemaleStunVoxC.ogg"] = 01.80,
						["mTaurenFemaleWoundCriticalVoxA.ogg"] = 00.54,
						["mTaurenFemaleWoundVoxA.ogg"] = 00.93,
						["mTaurenFemaleWoundVoxB.ogg"] = 00.40,
						["mTaurenFemaleWoundVoxC.ogg"] = 00.48,
						["TaurenFemaleChicken01.ogg"] = 04.02,
						["TaurenFemaleChooChoo01.ogg"] = 06.02,
						["TaurenFemaleCry01.ogg"] = 07.84,
						["TaurenFemaleKiss01.ogg"] = 01.38,
						["TaurenFemaleLaugh01.ogg"] = 02.98,
						["TaurenFemaleMoo01.ogg"] = 01.57,
						["TaurenFemaleSigh01.ogg"] = 01.27,
						["TaurenFemaleYawn01.ogg"] = 02.44,
					},
					["TaurenFemaleErrorMessages\\TaurenFemale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 01.77,
								["skillnotfound03.ogg"] = 01.30,
								["skillnotfound04.ogg"] = 01.52,
							},
							["abilitycooldown01.ogg"] = 01.41,
							["abilitycooldown02.ogg"] = 01.14,
							["abilitycooldown03.ogg"] = 00.98,
							["alreadyingroup02.ogg"] = 01.46,
							["ammoonly02.ogg"] = 01.25,
							["bagfull01.ogg"] = 01.01,
							["cantcreatehere03.ogg"] = 01.22,
							["cantdropsoulbounditem01.ogg"] = 01.12,
							["cantdropsoulbounditem03.ogg"] = 01.56,
							["cantequipever01.ogg"] = 01.97,
							["cantequiplevel01.ogg"] = 02.17,
							["cantequiplevel02.ogg"] = 01.38,
							["cantequipskill03.ogg"] = 02.81,
							["cantlearnspell01.ogg"] = 01.71,
							["cantloot01.ogg"] = 01.12,
							["canttradesoulbounditem01.ogg"] = 01.33,
							["cantuseitem01.ogg"] = 01.13,
							["chestinuse02.ogg"] = 01.50,
							["genericnotarget01.ogg"] = 01.20,
							["genericnotarget02.ogg"] = 01.88,
							["genericnotarget04.ogg"] = 01.19,
							["guildpermissions01.ogg"] = 00.97,
							["guildpermissions04.ogg"] = 01.47,
							["invalidattacktarget01.ogg"] = 01.54,
							["invalidattacktarget02.ogg"] = 01.20,
							["inventoryfull01.ogg"] = 01.29,
							["inventoryfull02.ogg"] = 01.54,
							["itemcooldown02.ogg"] = 01.63,
							["itemcooldown04.ogg"] = 01.12,
							["itemcooldown06.ogg"] = 01.34,
							["itemlocked01.ogg"] = 00.72,
							["itemmaxcount01.ogg"] = 01.82,
							["lootdidntkill01.ogg"] = 01.08,
							["lootdidntkill06.ogg"] = 01.39,
							["loottoofar02.ogg"] = 01.29,
							["loottoofar03.ogg"] = 01.09,
							["loottoofar04.ogg"] = 01.26,
							["mustequipitem02.ogg"] = 01.98,
							["mustequipitem03.ogg"] = 01.22,
							["noammo05.ogg"] = 00.86,
							["noenergy01.ogg"] = 01.18,
							["noenergy02.ogg"] = 01.59,
							["nomana01.ogg"] = 01.09,
							["nomana02.ogg"] = 01.37,
							["nomana03.ogg"] = 01.23,
							["norage01.ogg"] = 01.16,
							["norage05.ogg"] = 01.37,
							["notabag01.ogg"] = 01.09,
							["notenoughmoney01.ogg"] = 01.34,
							["notenoughmoney02.ogg"] = 01.29,
							["notenoughmoney03.ogg"] = 01.48,
							["notequippable01.ogg"] = 01.24,
							["outofrange02.ogg"] = 01.42,
							["outofrange04.ogg"] = 01.00,
							["outofrange05.ogg"] = 01.37,
							["partyfull03.ogg"] = 01.90,
							["potioncooldown01.ogg"] = 01.57,
							["proficiencyneeded01.ogg"] = 01.43,
							["spellcooldown01.ogg"] = 01.63,
							["spellcooldown02.ogg"] = 01.54,
							["spellcooldown03.ogg"] = 01.42,
						},
					},
					["TaurenMale\\"] = {
						["TaurenMaleAttackA.ogg"] = 00.56,
						["TaurenMaleAttackB.ogg"] = 00.77,
						["TaurenMaleAttackC.ogg"] = 00.74,
						["TaurenMaleAttackD.ogg"] = 00.73,
						["TaurenMaleChicken01.ogg"] = 03.56,
						["TaurenMaleChooChoo01.ogg"] = 06.72,
						["TaurenMaleCry01.ogg"] = 02.04,
						["TaurenMaleDeathA.ogg"] = 03.03,
						["TaurenMaleKiss01.ogg"] = 01.19,
						["TaurenMaleLaugh01.ogg"] = 03.14,
						["TaurenMaleMoo01.ogg"] = 01.85,
						["TaurenMaleSigh01.ogg"] = 00.91,
						["TaurenMaleWoundA.ogg"] = 00.46,
						["TaurenMaleWoundB.ogg"] = 00.69,
						["TaurenMaleWoundC.ogg"] = 00.67,
						["TaurenMaleWoundCrit.ogg"] = 01.07,
						["TaurenMaleYawn01.ogg"] = 06.27,
					},
					["TaurenMaleErrorMessages\\TaurenMale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.21,
								["skillnotfound03.ogg"] = 01.77,
								["skillnotfound04.ogg"] = 01.84,
							},
							["abilitycooldown01.ogg"] = 02.04,
							["abilitycooldown02.ogg"] = 01.97,
							["abilitycooldown03.ogg"] = 01.29,
							["alreadyingroup02.ogg"] = 01.75,
							["ammoonly02.ogg"] = 01.60,
							["bagfull01.ogg"] = 01.62,
							["cantcreatehere03.ogg"] = 01.57,
							["cantdropsoulbounditem01.ogg"] = 01.30,
							["cantdropsoulbounditem03.ogg"] = 01.66,
							["cantequipever01.ogg"] = 02.16,
							["cantequiplevel01.ogg"] = 02.46,
							["cantequiplevel02.ogg"] = 01.54,
							["cantequipskill03.ogg"] = 03.26,
							["cantlearnspell01.ogg"] = 02.14,
							["cantloot01.ogg"] = 01.41,
							["canttradesoulbounditem01.ogg"] = 01.48,
							["cantuseitem01.ogg"] = 01.38,
							["chestinuse02.ogg"] = 01.91,
							["genericnotarget01.ogg"] = 01.49,
							["genericnotarget02.ogg"] = 02.41,
							["genericnotarget04.ogg"] = 01.54,
							["guildpermissions01.ogg"] = 01.14,
							["guildpermissions04.ogg"] = 01.69,
							["invalidattacktarget01.ogg"] = 01.76,
							["invalidattacktarget02.ogg"] = 01.48,
							["inventoryfull01.ogg"] = 01.81,
							["inventoryfull02.ogg"] = 01.94,
							["itemcooldown02.ogg"] = 01.97,
							["itemcooldown04.ogg"] = 01.22,
							["itemcooldown06.ogg"] = 01.51,
							["itemlocked01.ogg"] = 00.90,
							["itemmaxcount01.ogg"] = 02.35,
							["lootdidntkill01.ogg"] = 01.26,
							["lootdidntkill06.ogg"] = 01.51,
							["loottoofar02.ogg"] = 01.35,
							["loottoofar03.ogg"] = 01.32,
							["loottoofar04.ogg"] = 01.24,
							["mustequipitem02.ogg"] = 02.01,
							["mustequipitem03.ogg"] = 01.31,
							["noammo05.ogg"] = 01.10,
							["noenergy01.ogg"] = 01.59,
							["noenergy02.ogg"] = 01.88,
							["nomana01.ogg"] = 01.42,
							["nomana02.ogg"] = 01.51,
							["nomana03.ogg"] = 01.47,
							["norage01.ogg"] = 01.36,
							["norage05.ogg"] = 01.72,
							["notabag01.ogg"] = 01.35,
							["notenoughmoney01.ogg"] = 01.42,
							["notenoughmoney02.ogg"] = 01.53,
							["notenoughmoney03.ogg"] = 01.49,
							["notequippable01.ogg"] = 01.48,
							["outofrange02.ogg"] = 01.51,
							["outofrange04.ogg"] = 01.24,
							["outofrange05.ogg"] = 01.46,
							["partyfull03.ogg"] = 01.94,
							["potioncooldown01.ogg"] = 01.94,
							["proficiencyneeded01.ogg"] = 01.53,
							["spellcooldown01.ogg"] = 01.89,
							["spellcooldown02.ogg"] = 01.64,
							["spellcooldown03.ogg"] = 01.69,
						},
					},
					["TaurenVocalFemale\\"] = {
						["TaurenFemaleAttackMyTarget01.ogg"] = 01.18,
						["TaurenFemaleAttackMyTarget02.ogg"] = 01.01,
						["TaurenFemaleCharge01.ogg"] = 01.20,
						["TaurenFemaleCharge02.ogg"] = 00.72,
						["TaurenFemaleCheer01.ogg"] = 01.47,
						["TaurenFemaleCheer02.ogg"] = 01.52,
						["TaurenFemaleCongratulations01.ogg"] = 01.00,
						["TaurenFemaleCongratulations02.ogg"] = 00.78,
						["TaurenFemaleCongratulations03.ogg"] = 01.65,
						["TaurenFemaleFlee01.ogg"] = 00.69,
						["TaurenFemaleFlee02.ogg"] = 00.90,
						["TaurenFemaleFlirt01.ogg"] = 02.35,
						["TaurenFemaleFlirt02.ogg"] = 03.56,
						["TaurenFemaleFlirt03.ogg"] = 06.46,
						["TaurenFemaleFlirt05.ogg"] = 01.31,
						["TaurenFemaleFlirt06.ogg"] = 01.96,
						["TaurenFemaleFollowMe01.ogg"] = 00.89,
						["TaurenFemaleFollowMe02.ogg"] = 00.93,
						["TaurenFemaleGoodbye01.ogg"] = 00.78,
						["TaurenFemaleGoodbye02.ogg"] = 00.56,
						["TaurenFemaleGoodbye03.ogg"] = 01.82,
						["TaurenFemaleHealMe01.ogg"] = 00.62,
						["TaurenFemaleHealMe02.ogg"] = 01.05,
						["TaurenFemaleHello01.ogg"] = 00.43,
						["TaurenFemaleHello02.ogg"] = 00.45,
						["TaurenFemaleHello03.ogg"] = 00.70,
						["TaurenFemaleHelp01.ogg"] = 00.53,
						["TaurenFemaleHelp02.ogg"] = 00.38,
						["TaurenFemaleIncoming01.ogg"] = 01.04,
						["TaurenFemaleIncoming02.ogg"] = 00.81,
						["TaurenFemaleIncoming03.ogg"] = 00.59,
						["TaurenFemaleNo01.ogg"] = 00.32,
						["TaurenFemaleNo02.ogg"] = 01.22,
						["TaurenFemaleNo03.ogg"] = 01.29,
						["TaurenFemaleOpenFire01.ogg"] = 01.04,
						["TaurenFemaleOpenFire02.ogg"] = 01.07,
						["TaurenFemaleOutOfMana01.ogg"] = 01.56,
						["TaurenFemaleOutOfMana02.ogg"] = 01.00,
						["TaurenFemalePissed01.ogg"] = 03.45,
						["TaurenFemalePissed02.ogg"] = 02.64,
						["TaurenFemalePissed03.ogg"] = 01.82,
						["TaurenFemalePissed04.ogg"] = 04.50,
						["TaurenFemaleRaspberry01.ogg"] = 01.10,
						["TaurenFemaleThankYou01.ogg"] = 00.53,
						["TaurenFemaleThankYou02.ogg"] = 01.10,
						["TaurenFemaleThankYou03.ogg"] = 01.29,
						["TaurenFemaleWaitHere01.ogg"] = 01.03,
						["TaurenFemaleWaitHere02.ogg"] = 00.74,
						["TaurenFemaleYes01.ogg"] = 00.47,
						["TaurenFemaleYes02.ogg"] = 00.71,
						["TaurenFemaleYes03.ogg"] = 00.92,
						["TaurenFemaleYoureWelcome01.ogg"] = 00.86,
						["TaurenFemaleYoureWelcome02.ogg"] = 01.29,
						["TaurenFemaleYoureWelcome03.ogg"] = 00.92,
						["VO_PCTaurenFemaleRoar01.ogg"] = 02.06,
					},
					["TaurenVocalMale\\"] = {
						["TaurenMaleAttackMyTarget01.ogg"] = 01.33,
						["TaurenMaleAttackMyTarget02.ogg"] = 01.17,
						["TaurenMaleCharge01.ogg"] = 01.52,
						["TaurenMaleCharge02.ogg"] = 01.58,
						["TaurenMaleCharge03.ogg"] = 01.26,
						["TaurenMaleCheer01.ogg"] = 01.72,
						["TaurenMaleCheer02.ogg"] = 02.19,
						["TaurenMaleCongratulations01.ogg"] = 00.91,
						["TaurenMaleCongratulations02.ogg"] = 01.34,
						["TaurenMaleCongratulations03.ogg"] = 02.07,
						["TaurenMaleFlee01.ogg"] = 00.88,
						["TaurenMaleFlee02.ogg"] = 01.13,
						["TaurenMaleFlirt01.ogg"] = 02.23,
						["TaurenMaleFlirt02.ogg"] = 01.74,
						["TaurenMaleFlirt03.ogg"] = 02.48,
						["TaurenMaleFlirt04.ogg"] = 01.57,
						["TaurenMaleFlirt05.ogg"] = 04.10,
						["TaurenMaleFlirt06.ogg"] = 02.87,
						["TaurenMaleFollowMe01.ogg"] = 00.81,
						["TaurenMaleFollowMe02.ogg"] = 01.42,
						["TaurenMaleGoodbye01.ogg"] = 01.05,
						["TaurenMaleGoodbye02.ogg"] = 01.94,
						["TaurenMaleGoodbye03.ogg"] = 01.98,
						["TaurenMaleHealMe01.ogg"] = 00.76,
						["TaurenMaleHealMe02.ogg"] = 01.12,
						["TaurenMaleHello01.ogg"] = 00.49,
						["TaurenMaleHello02.ogg"] = 00.55,
						["TaurenMaleHello03.ogg"] = 01.02,
						["TaurenMaleHelp01.ogg"] = 00.99,
						["TaurenMaleHelp02.ogg"] = 00.45,
						["TaurenMaleHelp03.ogg"] = 00.94,
						["TaurenMaleIncoming01.ogg"] = 01.34,
						["TaurenMaleIncoming02.ogg"] = 01.12,
						["TaurenMaleNo01.ogg"] = 00.54,
						["TaurenMaleNo02.ogg"] = 01.33,
						["TaurenMaleNo03.ogg"] = 00.91,
						["TaurenMaleOpenFire01.ogg"] = 01.78,
						["TaurenMaleOpenFire02.ogg"] = 01.32,
						["TaurenMaleOutOfMana01.ogg"] = 01.59,
						["TaurenMaleOutOfMana02.ogg"] = 01.49,
						["TaurenMalePissed01.ogg"] = 02.70,
						["TaurenMalePissed02.ogg"] = 01.18,
						["TaurenMalePissed03.ogg"] = 03.58,
						["TaurenMalePissed04.ogg"] = 18.32,
						["TaurenMalePissed05.ogg"] = 02.15,
						["TaurenMaleRaspberry01.ogg"] = 01.42,
						["TaurenMaleThankYou01.ogg"] = 01.02,
						["TaurenMaleThankYou02.ogg"] = 01.43,
						["TaurenMaleThankYou03.ogg"] = 01.03,
						["TaurenMaleThankYou04.ogg"] = 03.13,
						["TaurenMaleWaitHere01.ogg"] = 01.21,
						["TaurenMaleWaitHere02.ogg"] = 01.17,
						["TaurenMaleWaitHere03.ogg"] = 01.20,
						["TaurenMaleYes01.ogg"] = 00.60,
						["TaurenMaleYes02.ogg"] = 01.16,
						["TaurenMaleYes03.ogg"] = 01.31,
						["TaurenMaleYoureWelcome01.ogg"] = 00.85,
						["TaurenMaleYoureWelcome02.ogg"] = 01.48,
						["TaurenMaleYoureWelcome03.ogg"] = 01.78,
						["VO_PCTaurenMaleRoar01.ogg"] = 03.21,
					},
				},
				["Troll\\"] = {
					["TrollFemaleErrorMessages\\TrollFemale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.17,
								["skillnotfound03.ogg"] = 02.09,
								["skillnotfound04.ogg"] = 02.37,
							},
							["abilitycooldown01.ogg"] = 01.98,
							["abilitycooldown02.ogg"] = 01.31,
							["abilitycooldown03.ogg"] = 01.47,
							["alreadyingroup02.ogg"] = 02.11,
							["ammoonly02.ogg"] = 01.40,
							["bagfull01.ogg"] = 01.21,
							["cantcreatehere03.ogg"] = 01.31,
							["cantdropsoulbounditem01.ogg"] = 01.11,
							["cantdropsoulbounditem03.ogg"] = 01.55,
							["cantequipever01.ogg"] = 02.25,
							["cantequiplevel01.ogg"] = 02.95,
							["cantequiplevel02.ogg"] = 02.22,
							["cantequipskill03.ogg"] = 03.25,
							["cantlearnspell01.ogg"] = 01.83,
							["cantloot01.ogg"] = 01.20,
							["canttradesoulbounditem01.ogg"] = 01.58,
							["cantuseitem01.ogg"] = 01.36,
							["chestinuse02.ogg"] = 01.74,
							["genericnotarget01.ogg"] = 01.80,
							["genericnotarget02.ogg"] = 02.12,
							["genericnotarget04.ogg"] = 01.55,
							["guildpermissions01.ogg"] = 01.05,
							["guildpermissions04.ogg"] = 01.98,
							["invalidattacktarget01.ogg"] = 02.02,
							["invalidattacktarget02.ogg"] = 01.49,
							["inventoryfull01.ogg"] = 01.65,
							["inventoryfull02.ogg"] = 01.87,
							["itemcooldown02.ogg"] = 01.78,
							["itemcooldown04.ogg"] = 01.41,
							["itemcooldown06.ogg"] = 01.92,
							["itemlocked01.ogg"] = 00.82,
							["itemmaxcount01.ogg"] = 02.23,
							["lootdidntkill01.ogg"] = 01.20,
							["lootdidntkill06.ogg"] = 01.54,
							["loottoofar02.ogg"] = 01.65,
							["loottoofar03.ogg"] = 01.90,
							["loottoofar04.ogg"] = 01.75,
							["mustequipitem02.ogg"] = 02.32,
							["mustequipitem03.ogg"] = 01.69,
							["noammo05.ogg"] = 01.54,
							["noenergy01.ogg"] = 01.43,
							["noenergy02.ogg"] = 02.51,
							["nomana01.ogg"] = 01.59,
							["nomana02.ogg"] = 01.80,
							["nomana03.ogg"] = 01.40,
							["norage01.ogg"] = 02.30,
							["norage05.ogg"] = 02.08,
							["notabag01.ogg"] = 01.72,
							["notenoughmoney01.ogg"] = 01.67,
							["notenoughmoney02.ogg"] = 01.59,
							["notenoughmoney03.ogg"] = 01.99,
							["notequippable01.ogg"] = 01.58,
							["outofrange02.ogg"] = 01.79,
							["outofrange04.ogg"] = 01.94,
							["outofrange05.ogg"] = 01.63,
							["partyfull03.ogg"] = 02.19,
							["potioncooldown01.ogg"] = 02.02,
							["proficiencyneeded01.ogg"] = 01.63,
							["spellcooldown01.ogg"] = 01.88,
							["spellcooldown02.ogg"] = 01.65,
							["spellcooldown03.ogg"] = 02.28,
						},
					},
					["TrollMaleErrorMessages\\TrollMale_"] = {
						["err_"] = {
							["2h_"] = {
								["equipped04.ogg"] = 02.19,
								["skillnotfound03.ogg"] = 01.59,
								["skillnotfound04.ogg"] = 01.99,
							},
							["abilitycooldown01.ogg"] = 02.02,
							["abilitycooldown02.ogg"] = 01.84,
							["abilitycooldown03.ogg"] = 01.38,
							["alreadyingroup02.ogg"] = 02.11,
							["ammoonly02.ogg"] = 01.46,
							["bagfull01.ogg"] = 01.51,
							["cantcreatehere03.ogg"] = 01.45,
							["cantdropsoulbounditem01.ogg"] = 01.63,
							["cantdropsoulbounditem03.ogg"] = 01.28,
							["cantequipever01.ogg"] = 02.05,
							["cantequiplevel01.ogg"] = 02.46,
							["cantequiplevel02.ogg"] = 01.47,
							["cantequipskill03.ogg"] = 03.02,
							["cantlearnspell01.ogg"] = 02.08,
							["cantloot01.ogg"] = 01.45,
							["canttradesoulbounditem01.ogg"] = 01.66,
							["cantuseitem01.ogg"] = 01.30,
							["chestinuse02.ogg"] = 01.69,
							["genericnotarget01.ogg"] = 01.68,
							["genericnotarget02.ogg"] = 02.08,
							["genericnotarget04.ogg"] = 01.29,
							["guildpermissions01.ogg"] = 01.35,
							["guildpermissions04.ogg"] = 02.13,
							["invalidattacktarget01.ogg"] = 02.02,
							["invalidattacktarget02.ogg"] = 01.37,
							["inventoryfull01.ogg"] = 01.88,
							["inventoryfull02.ogg"] = 01.83,
							["itemcooldown02.ogg"] = 02.01,
							["itemcooldown04.ogg"] = 01.65,
							["itemcooldown06.ogg"] = 01.60,
							["itemlocked01.ogg"] = 00.93,
							["itemmaxcount01.ogg"] = 02.32,
							["lootdidntkill01.ogg"] = 01.32,
							["lootdidntkill06.ogg"] = 01.66,
							["loottoofar02.ogg"] = 01.57,
							["loottoofar03.ogg"] = 01.60,
							["loottoofar04.ogg"] = 01.34,
							["mustequipitem02.ogg"] = 02.36,
							["mustequipitem03.ogg"] = 01.71,
							["noammo05.ogg"] = 01.54,
							["noenergy01.ogg"] = 01.36,
							["noenergy02.ogg"] = 01.92,
							["nomana01.ogg"] = 01.30,
							["nomana02.ogg"] = 01.42,
							["nomana03.ogg"] = 01.61,
							["norage01.ogg"] = 01.52,
							["norage05.ogg"] = 01.32,
							["notabag01.ogg"] = 01.34,
							["notenoughmoney01.ogg"] = 02.08,
							["notenoughmoney02.ogg"] = 01.57,
							["notenoughmoney03.ogg"] = 01.67,
							["notequippable01.ogg"] = 01.71,
							["outofrange02.ogg"] = 01.47,
							["outofrange04.ogg"] = 01.60,
							["outofrange05.ogg"] = 01.68,
							["partyfull03.ogg"] = 00.72,
							["potioncooldown01.ogg"] = 02.34,
							["proficiencyneeded01.ogg"] = 01.95,
							["spellcooldown01.ogg"] = 02.26,
							["spellcooldown02.ogg"] = 01.85,
							["spellcooldown03.ogg"] = 01.67,
						},
					},
					["TrollVocalFemale\\"] = {
						["TrollFemaleAttackMyTarget01.ogg"] = 01.20,
						["TrollFemaleAttackMyTarget02.ogg"] = 01.41,
						["TrollFemaleCharge01.ogg"] = 01.98,
						["TrollFemaleCharge02.ogg"] = 02.35,
						["TrollFemaleCheer01.ogg"] = 00.80,
						["TrollFemaleCheer02.ogg"] = 01.49,
						["TrollFemaleCongratulations01.ogg"] = 00.70,
						["TrollFemaleCongratulations02.ogg"] = 01.13,
						["TrollFemaleCongratulations03.ogg"] = 01.33,
						["TrollFemaleFlee01.ogg"] = 01.29,
						["TrollFemaleFlee02.ogg"] = 00.86,
						["TrollFemaleFlirt01.ogg"] = 03.18,
						["TrollFemaleFlirt02.ogg"] = 09.02,
						["TrollFemaleFlirt03.ogg"] = 02.13,
						["TrollFemaleFlirt04.ogg"] = 02.44,
						["TrollFemaleFlirt05.ogg"] = 03.43,
						["TrollFemaleFollowMe01.ogg"] = 01.27,
						["TrollFemaleFollowMe02.ogg"] = 00.93,
						["TrollFemaleGoodbye01.ogg"] = 01.24,
						["TrollFemaleGoodbye02.ogg"] = 01.24,
						["TrollFemaleGoodbye03.ogg"] = 01.23,
						["TrollFemaleHealMe01.ogg"] = 01.71,
						["TrollFemaleHealMe02.ogg"] = 00.81,
						["TrollFemaleHealMe03.ogg"] = 00.81,
						["TrollFemaleHello01.ogg"] = 01.04,
						["TrollFemaleHello02.ogg"] = 00.95,
						["TrollFemaleHello03.ogg"] = 01.17,
						["TrollFemaleHelp01.ogg"] = 00.76,
						["TrollFemaleHelp02.ogg"] = 00.84,
						["TrollFemaleIncoming01.ogg"] = 01.20,
						["TrollFemaleIncoming02.ogg"] = 01.32,
						["TrollFemaleNo01.ogg"] = 01.05,
						["TrollFemaleNo02.ogg"] = 01.01,
						["TrollFemaleNo03.ogg"] = 01.42,
						["TrollFemaleOpenFire01.ogg"] = 01.06,
						["TrollFemaleOpenFire02.ogg"] = 01.08,
						["TrollFemaleOutOfMana01.ogg"] = 01.44,
						["TrollFemaleOutOfMana02.ogg"] = 01.54,
						["TrollFemalePissed01.ogg"] = 04.64,
						["TrollFemalePissed02.ogg"] = 05.10,
						["TrollFemalePissed03.ogg"] = 03.67,
						["TrollFemalePissed04.ogg"] = 05.37,
						["TrollFemalePissed05.ogg"] = 03.92,
						["TrollFemaleRaspberry01.ogg"] = 01.02,
						["TrollFemaleThankYou01.ogg"] = 00.72,
						["TrollFemaleThankYou02.ogg"] = 00.88,
						["TrollFemaleThankYou03.ogg"] = 01.04,
						["TrollFemaleWaitHere01.ogg"] = 00.94,
						["TrollFemaleWaitHere02.ogg"] = 00.86,
						["TrollFemaleWaitHere03.ogg"] = 01.32,
						["TrollFemaleYes01.ogg"] = 01.43,
						["TrollFemaleYes02.ogg"] = 00.58,
						["TrollFemaleYes03.ogg"] = 00.73,
						["TrollFemaleYoureWelcome01.ogg"] = 01.11,
						["TrollFemaleYoureWelcome02.ogg"] = 01.30,
						["TrollFemaleYoureWelcome03.ogg"] = 01.47,
						["VO_PCTrollFemaleRoar01.ogg"] = 02.53,
					},
					["TrollVocalMale\\"] = {
						["TrollMaleAttackMyTarget01.ogg"] = 01.48,
						["TrollMaleAttackMyTarget02.ogg"] = 00.87,
						["TrollMaleCharge01.ogg"] = 01.30,
						["TrollMaleCharge02.ogg"] = 01.46,
						["TrollMaleCheer01.ogg"] = 01.19,
						["TrollMaleCheer02.ogg"] = 01.09,
						["TrollMaleCheer03.ogg"] = 01.18,
						["TrollMaleCongratulations01.ogg"] = 01.05,
						["TrollMaleCongratulations02.ogg"] = 01.07,
						["TrollMaleCongratulations03.ogg"] = 03.15,
						["TrollMaleFlee01.ogg"] = 00.57,
						["TrollMaleFlee02.ogg"] = 01.03,
						["TrollMaleFlirt01.ogg"] = 02.12,
						["TrollMaleFlirt02.ogg"] = 06.23,
						["TrollMaleFlirt03.ogg"] = 02.97,
						["TrollMaleFlirt04.ogg"] = 03.73,
						["TrollMaleFollowMe01.ogg"] = 00.77,
						["TrollMaleFollowMe02.ogg"] = 01.15,
						["TrollMaleGoodbye01.ogg"] = 00.92,
						["TrollMaleGoodbye02.ogg"] = 01.19,
						["TrollMaleGoodbye03.ogg"] = 01.33,
						["TrollMaleHealMe01.ogg"] = 00.68,
						["TrollMaleHealMe02.ogg"] = 00.67,
						["TrollMaleHealMe03.ogg"] = 01.61,
						["TrollMaleHello01.ogg"] = 00.74,
						["TrollMaleHello02.ogg"] = 00.86,
						["TrollMaleHello03.ogg"] = 01.11,
						["TrollMaleHelp01.ogg"] = 00.94,
						["TrollMaleHelp02.ogg"] = 00.99,
						["TrollMaleIncoming01.ogg"] = 01.23,
						["TrollMaleIncoming02.ogg"] = 01.39,
						["TrollMaleNo01.ogg"] = 00.53,
						["TrollMaleNo02.ogg"] = 00.83,
						["TrollMaleNo03.ogg"] = 01.01,
						["TrollMaleNo04.ogg"] = 00.81,
						["TrollMaleOpenFire01.ogg"] = 00.98,
						["TrollMaleOpenFire02.ogg"] = 01.14,
						["TrollMaleOutOfMana01.ogg"] = 01.66,
						["TrollMaleOutOfMana02.ogg"] = 01.67,
						["TrollMalePissed01.ogg"] = 02.03,
						["TrollMalePissed02.ogg"] = 03.66,
						["TrollMalePissed03.ogg"] = 03.44,
						["TrollMalePissed04.ogg"] = 01.65,
						["TrollMalePissed05.ogg"] = 01.65,
						["TrollMalePissed06.ogg"] = 05.95,
						["TrollMaleRaspberry01.ogg"] = 00.94,
						["TrollMaleThankYou01.ogg"] = 00.58,
						["TrollMaleThankYou02.ogg"] = 01.34,
						["TrollMaleThankYou03.ogg"] = 00.94,
						["TrollMaleWaitHere01.ogg"] = 01.19,
						["TrollMaleWaitHere02.ogg"] = 01.15,
						["TrollMaleWaitHere03.ogg"] = 01.70,
						["TrollMaleYes01.ogg"] = 01.33,
						["TrollMaleYes02.ogg"] = 00.94,
						["TrollMaleYes03.ogg"] = 00.96,
						["TrollMaleYes04.ogg"] = 00.85,
						["TrollMaleYoureWelcome01.ogg"] = 01.19,
						["TrollMaleYoureWelcome02.ogg"] = 01.17,
						["TrollMaleYoureWelcome03.ogg"] = 03.10,
						["VO_PCTrollMaleRoar01.ogg"] = 02.55,
					},
					["TrollFemaleChicken01.ogg"] = 04.29,
					["TrollFemaleChooChoo01.ogg"] = 06.56,
					["TrollFemaleCry01.ogg"] = 08.14,
					["TrollFemaleKiss01.ogg"] = 01.30,
					["TrollFemaleLaugh01.ogg"] = 03.28,
					["TrollFemaleSigh01.ogg"] = 00.93,
					["TrollFemaleYawn01.ogg"] = 02.54,
					["TrollMaleChicken01.ogg"] = 03.75,
					["TrollMaleChooChoo01.ogg"] = 06.00,
					["TrollMaleCry01.ogg"] = 06.62,
					["TrollMaleKiss01.ogg"] = 01.25,
					["TrollMaleLaugh01.ogg"] = 03.11,
					["TrollMaleSigh01.ogg"] = 00.87,
					["TrollMaleYawn01.ogg"] = 03.39,
				},
				["VryKulMale\\"] = {
					["VrykulMaleAggro.ogg"] = 01.32,
					["VrykulMaleAttackA.ogg"] = 00.68,
					["VrykulMaleAttackB.ogg"] = 00.75,
					["VrykulMaleAttackC.ogg"] = 00.80,
					["VrykulMaleAttackD.ogg"] = 00.98,
					["VrykulMaleAttackE.ogg"] = 00.96,
					["VrykulMaleAttackF.ogg"] = 00.70,
					["VrykulMaleDeath.ogg"] = 02.18,
					["VrykulMalePreAggro.ogg"] = 01.31,
					["VrykulMaleWoundA.ogg"] = 00.73,
					["VrykulMaleWoundB.ogg"] = 00.77,
					["VrykulMaleWoundC.ogg"] = 00.93,
					["VrykulMaleWoundCrit.ogg"] = 01.72,
					["VrykulMaleWoundD.ogg"] = 00.83,
					["VrykulMaleWoundE.ogg"] = 00.97,
				},
				["DrowningLoop.ogg"] = 04.95,
				["EmoteBoredWhistle01.ogg"] = 06.33,
				["EmoteBoredWhistle02.ogg"] = 03.74,
				["EmoteBoredWhistle03.ogg"] = 02.92,
				["EmoteBoredWhistle04.ogg"] = 04.47,
				["EmoteBoredWhistle05.ogg"] = 01.92,
				["EmoteBoredWhistle06.ogg"] = 04.89,
				["EmoteCatCallWhistle01.ogg"] = 01.28,
				["EmoteCatCallWhistle02.ogg"] = 01.06,
				["EmoteCatCallWhistle03.ogg"] = 01.35,
				["EmoteCatCallWhistle04.ogg"] = 00.87,
				["EmoteCatCallWhistle05.ogg"] = 00.89,
				["EmoteClap1.ogg"] = 00.13,
				["EmoteClap2.ogg"] = 00.11,
				["EmoteClap3.ogg"] = 00.12,
				["EmoteClap4.ogg"] = 00.09,
				["EmoteClap5.ogg"] = 00.09,
				["EmoteClap6.ogg"] = 00.10,
				["EmoteClap7.ogg"] = 00.13,
				["GoblinFemale\\GoblinFemale_Doppler_01.ogg"] = 02.67,
			},
			["CINEMATICVOICES\\"] = {
				["BloodElfNarration.mp3"] = 69.80,
				["DeathKnightNarration.mp3"] = 51.44,
				["DraeneiNarration.mp3"] = 59.22,
				["DwarfNarration.mp3"] = 65.16,
				["GnomeNarration.mp3"] = 52.66,
				["GoblinNarration.mp3"] = 59.87,
				["HumanNarration.mp3"] = 50.52,
				["MaelstromNarration.mp3"] = 36.26,
				["NightElfNarration.mp3"] = 45.56,
				["OrcNarration.mp3"] = 60.13,
				["PANDARENNARRATION.mp3"] = 47.21,
				["TaurenNarration.mp3"] = 74.48,
				["TrollNarration.mp3"] = 46.34,
				["UndeadNarration.mp3"] = 80.48,
				["WorgenNarration.mp3"] = 75.52,
			},
			["creature\\"] = {
				["Abedneum\\HS_"] = {
					["Abedneum_"] = {
						["Activation.ogg"] = 07.83,
						["EventEnd01.ogg"] = 13.85,
						["EventEnd02.ogg"] = 08.03,
						["EventStart.ogg"] = 11.29,
						["Slay01.ogg"] = 02.10,
						["Speech01.ogg"] = 07.48,
						["Speech02.ogg"] = 10.76,
						["Speech03.ogg"] = 21.78,
						["Speech04.ogg"] = 04.02,
					},
				},
				["Abomination\\"] = {
					["VO_QE_"] = {
						["GIL_Abomination_"] = {
							["Event01.ogg"] = 03.94,
							["Event02.ogg"] = 02.89,
							["Event03.ogg"] = 02.91,
							["Event04.ogg"] = 04.66,
							["Event05.ogg"] = 02.83,
							["Event06.ogg"] = 04.32,
						},
					},
					["AbominationPissed2.ogg"] = 01.87,
					["AbominationPissed5.ogg"] = 01.73,
					["AbominationReady1.ogg"] = 02.23,
					["AbominationWhat1.ogg"] = 02.08,
					["AbominationWhat2.ogg"] = 00.93,
					["AbominationWhat4.ogg"] = 00.92,
					["AbominationYes1.ogg"] = 01.52,
					["AbominationYes2.ogg"] = 00.95,
					["AbominationYes4.ogg"] = 01.02,
					["AbominationYes5.ogg"] = 01.17,
					["AbominationYesAttack2.ogg"] = 01.19,
				},
				["Aborius\\VO_"] = {
					["60_NGD_"] = {
						["THRONE_ABORIUS_"] = {
							["01.ogg"] = 12.31,
							["02.ogg"] = 07.67,
						},
					},
				},
				["Adarra\\VO_"] = {
					["QE_VJ_"] = {
						["Adarra_"] = {
							["AllianceShip01.ogg"] = 02.55,
							["AllianceShip02.ogg"] = 05.21,
						},
					},
				},
				["Aeonis\\CAV_"] = {
					["Aeonis_"] = {
						["Aggro01.ogg"] = 09.00,
						["Banish01.ogg"] = 09.55,
						["Death01.ogg"] = 12.61,
						["Enter01.ogg"] = 23.73,
						["Slay01.ogg"] = 09.00,
						["Slay02.ogg"] = 08.00,
					},
				},
				["Aessina\\VO_"] = {
					["QE_HJ_"] = {
						["Aessina_"] = {
							["HYEvent01.ogg"] = 05.93,
							["HYEvent02.ogg"] = 08.04,
							["HYEvent03.ogg"] = 09.57,
							["HYEvent04.ogg"] = 06.41,
							["HYEvent05.ogg"] = 10.78,
							["HYEvent06.ogg"] = 09.03,
							["HYEvent07.ogg"] = 04.11,
						},
					},
				},
				["Aethas\\VO_"] = {
					["5.1_"] = {
						["HPROG_Aethas_"] = {
							["DalAfter_"] = {
								["01.OGG"] = 06.80,
								["02.OGG"] = 07.78,
								["03.OGG"] = 01.38,
								["04.OGG"] = 03.88,
							},
						},
						["PROG_Aethas_"] = {
							["Purge_"] = {
								["01.OGG"] = 03.47,
								["02.OGG"] = 02.92,
							},
						},
					},
					["52_Aethas_Horde_Exalted_01.OGG"] = 01.38,
				},
				["Aggra\\VO_"] = {
					["60_NGD_"] = {
						["WARSONG_"] = {
							["HORDE_AGGRA_"] = {
								["01.ogg"] = 02.04,
								["02.ogg"] = 04.21,
								["03.ogg"] = 01.71,
								["04.ogg"] = 04.79,
								["05.ogg"] = 01.64,
								["06.ogg"] = 01.65,
								["07.ogg"] = 01.12,
							},
							["ALLY_AGGRA_01.ogg"] = 01.20,
						},
						["QUEST_AGGRA_01.ogg"] = 06.05,
					},
					["QE_DH_"] = {
						["Aggra_"] = {
							["Farewell_"] = {
								["01.ogg"] = 00.98,
								["02.ogg"] = 01.74,
							},
							["Greeting_"] = {
								["01.ogg"] = 00.93,
								["02.ogg"] = 00.58,
							},
							["Intro_"] = {
								["01.ogg"] = 05.15,
								["02.ogg"] = 08.42,
								["03.ogg"] = 03.66,
								["04.ogg"] = 01.88,
								["05.ogg"] = 01.64,
								["06.ogg"] = 05.25,
								["07.ogg"] = 11.94,
								["08.ogg"] = 13.89,
								["09.ogg"] = 08.03,
								["10.ogg"] = 07.82,
								["11.ogg"] = 01.70,
							},
						},
					},
					["QUEST_42_"] = {
						["AGGRA_"] = {
							["AIR_"] = {
								["01.ogg"] = 07.91,
								["02.ogg"] = 05.19,
								["03.ogg"] = 03.35,
								["04.ogg"] = 06.60,
								["05.ogg"] = 00.84,
								["06.ogg"] = 14.24,
								["07.ogg"] = 18.26,
								["08.ogg"] = 09.40,
							},
							["EARTH_"] = {
								["01.ogg"] = 01.86,
								["02.ogg"] = 02.55,
								["03.ogg"] = 18.88,
								["04.ogg"] = 09.20,
								["05.ogg"] = 11.72,
								["06.ogg"] = 04.11,
								["07.ogg"] = 06.57,
								["08.ogg"] = 06.63,
								["09.ogg"] = 03.75,
								["10.ogg"] = 01.43,
								["11.ogg"] = 05.97,
								["12.ogg"] = 03.20,
								["13.ogg"] = 10.91,
								["14.ogg"] = 10.89,
								["15.ogg"] = 06.85,
							},
							["FINALE_"] = {
								["01.ogg"] = 03.69,
								["02.ogg"] = 16.30,
							},
							["FIRE_"] = {
								["01.ogg"] = 07.90,
								["02.ogg"] = 03.65,
								["03.ogg"] = 12.34,
								["04.ogg"] = 03.02,
								["05.ogg"] = 06.87,
								["06.ogg"] = 00.55,
								["07.ogg"] = 01.17,
								["08.ogg"] = 00.63,
								["09.ogg"] = 04.72,
								["10.ogg"] = 09.86,
								["11.ogg"] = 02.98,
								["12.ogg"] = 02.09,
								["13.ogg"] = 01.91,
								["14.ogg"] = 10.70,
								["15.ogg"] = 03.40,
								["16.ogg"] = 01.93,
								["17.ogg"] = 08.98,
							},
							["INTRO_"] = {
								["01.ogg"] = 08.95,
								["02.ogg"] = 01.33,
								["03.ogg"] = 01.44,
								["04.ogg"] = 01.30,
								["05.ogg"] = 17.56,
								["06.ogg"] = 06.91,
							},
							["WATER_"] = {
								["01.ogg"] = 04.39,
								["02.ogg"] = 08.62,
								["03.ogg"] = 03.65,
								["04.ogg"] = 13.39,
								["05.ogg"] = 06.68,
								["06.ogg"] = 19.60,
								["07.ogg"] = 09.61,
								["08.ogg"] = 13.23,
								["09.ogg"] = 17.75,
								["10.ogg"] = 07.18,
								["11.ogg"] = 08.66,
								["12.ogg"] = 02.34,
								["13.ogg"] = 15.62,
								["14.ogg"] = 04.68,
								["15.ogg"] = 00.78,
								["16.ogg"] = 10.29,
							},
						},
					},
				},
				["Aggron1\\VO_"] = {
					["60_"] = {
						["AGGRON1_"] = {
							["AttackCrit_"] = {
								["1.OGG"] = 02.10,
								["2.OGG"] = 02.44,
								["3.OGG"] = 01.76,
								["4.OGG"] = 02.34,
								["5.OGG"] = 02.34,
							},
							["Attack_"] = {
								["1.OGG"] = 01.25,
								["10.OGG"] = 01.36,
								["2.OGG"] = 01.45,
								["3.OGG"] = 01.32,
								["4.OGG"] = 01.22,
								["5.OGG"] = 01.08,
								["6.OGG"] = 01.13,
								["7.OGG"] = 01.18,
								["8.OGG"] = 01.38,
								["9.OGG"] = 01.18,
							},
							["WoundCrit_"] = {
								["1.OGG"] = 02.10,
								["2.OGG"] = 02.63,
								["3.OGG"] = 01.76,
								["4.OGG"] = 02.65,
								["5.OGG"] = 02.00,
							},
							["Wound_"] = {
								["1.OGG"] = 01.22,
								["10.OGG"] = 01.40,
								["2.OGG"] = 01.31,
								["3.OGG"] = 01.00,
								["4.OGG"] = 01.50,
								["5.OGG"] = 01.56,
								["6.OGG"] = 01.35,
								["7.OGG"] = 01.08,
								["8.OGG"] = 01.05,
								["9.OGG"] = 01.07,
							},
						},
						["HIGHMAUL_AGGRON_"] = {
							["1_"] = {
								["KILL_"] = {
									["1.OGG"] = 02.81,
									["2.OGG"] = 02.10,
									["3.OGG"] = 03.01,
								},
								["SPELL_"] = {
									["1.OGG"] = 01.78,
									["2.OGG"] = 01.89,
									["3.OGG"] = 02.24,
									["4.OGG"] = 02.68,
								},
								["BERSERK.OGG"] = 03.14,
								["DEATH.OGG"] = 03.85,
								["RESET2.OGG"] = 04.35,
								["AGGRO_1.OGG"] = 02.20,
								["EVENT_1.OGG"] = 03.02,
								["INTRO_1.OGG"] = 01.84,
							},
						},
					},
				},
				["Aggron2\\VO_"] = {
					["60_"] = {
						["AGGRON2_"] = {
							["AttackCrit_"] = {
								["1.OGG"] = 03.64,
								["2.OGG"] = 02.89,
								["3.OGG"] = 02.33,
								["4.OGG"] = 01.84,
								["5.OGG"] = 02.81,
							},
							["Attack_"] = {
								["1.OGG"] = 01.54,
								["10.OGG"] = 01.18,
								["2.OGG"] = 01.44,
								["3.OGG"] = 01.15,
								["4.OGG"] = 01.40,
								["5.OGG"] = 01.22,
								["6.OGG"] = 01.41,
								["7.OGG"] = 01.40,
								["8.OGG"] = 01.30,
								["9.OGG"] = 01.23,
							},
							["WoundCrit_"] = {
								["1.OGG"] = 02.73,
								["2.OGG"] = 01.48,
								["3.OGG"] = 01.61,
								["4.OGG"] = 01.50,
								["5.OGG"] = 01.74,
							},
							["Wound_"] = {
								["1.OGG"] = 00.87,
								["2.OGG"] = 01.18,
								["3.OGG"] = 01.43,
								["4.OGG"] = 00.94,
								["5.OGG"] = 01.52,
								["6.OGG"] = 01.16,
								["7.OGG"] = 01.34,
								["8.OGG"] = 00.95,
								["9.OGG"] = 01.18,
							},
						},
						["HIGHMAUL_AGGRON_"] = {
							["2_"] = {
								["KILL_"] = {
									["1.OGG"] = 02.44,
									["2.OGG"] = 02.88,
									["3.OGG"] = 02.74,
								},
								["SPELL_"] = {
									["1.OGG"] = 02.07,
									["2.OGG"] = 01.63,
									["3.OGG"] = 02.10,
									["4.OGG"] = 01.44,
								},
								["DEATH.OGG"] = 04.78,
								["AGGRO_1.OGG"] = 02.22,
								["EVENT_1.OGG"] = 03.98,
								["INTRO_1.OGG"] = 04.84,
							},
						},
					},
				},
				["Aggthok\\VO_"] = {
					["60_"] = {
						["AGGTHOK_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 02.58,
								["02.ogg"] = 01.12,
								["03.ogg"] = 01.28,
								["04.ogg"] = 01.69,
								["05.ogg"] = 01.23,
							},
							["Attack_"] = {
								["01.ogg"] = 00.98,
								["02.ogg"] = 00.95,
								["03.ogg"] = 00.82,
								["04.ogg"] = 01.02,
								["05.ogg"] = 00.88,
								["06.ogg"] = 00.89,
								["07.ogg"] = 00.82,
								["08.ogg"] = 00.87,
								["09.ogg"] = 00.73,
							},
							["Death_"] = {
								["01.ogg"] = 03.13,
								["02.ogg"] = 02.70,
								["03.ogg"] = 02.36,
								["04.ogg"] = 01.49,
								["05.ogg"] = 03.11,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.69,
								["02.ogg"] = 02.05,
								["03.ogg"] = 01.84,
								["04.ogg"] = 02.39,
								["05.ogg"] = 01.24,
							},
							["Wound_"] = {
								["01.ogg"] = 00.83,
								["010.ogg"] = 00.92,
								["02.ogg"] = 00.96,
								["03.ogg"] = 00.75,
								["04.ogg"] = 00.89,
								["05.ogg"] = 00.94,
								["06.ogg"] = 00.75,
								["07.ogg"] = 00.78,
								["08.ogg"] = 00.76,
								["09.ogg"] = 00.67,
							},
						},
						["TLD_"] = {
							["RUINS_AGGTHOK_"] = {
								["01.ogg"] = 04.10,
								["02.ogg"] = 10.48,
								["03.ogg"] = 09.23,
							},
							["XANDROS_AGGTHOK_"] = {
								["01.ogg"] = 06.14,
								["02.ogg"] = 03.79,
							},
						},
					},
				},
				["AhabWheathoof\\WISH_"] = {
					["AhabWheatHoofDog1.ogg"] = 02.03,
					["AhabWheatHoofDog2.ogg"] = 02.96,
					["AhabWheatHoofDog3.ogg"] = 03.54,
					["AhabWheatHoofFarewell1.ogg"] = 02.24,
					["AhabWheatHoofFarewell2.ogg"] = 01.72,
					["AhabWheatHoofFarewell3.ogg"] = 03.94,
					["AhabWheatHoofGreeting1.ogg"] = 01.88,
					["AhabWheatHoofPissed1.ogg"] = 02.80,
					["AhabWheatHoofPissed2.ogg"] = 02.34,
				},
				["Ahriok\\VO_"] = {
					["60_"] = {
						["AHRIOK_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.06,
								["02.ogg"] = 01.65,
								["03.ogg"] = 01.21,
								["04.ogg"] = 01.56,
								["05.ogg"] = 01.16,
							},
							["Attack_"] = {
								["01.ogg"] = 00.39,
								["010.ogg"] = 00.38,
								["02.ogg"] = 00.32,
								["03.ogg"] = 00.35,
								["04.ogg"] = 00.38,
								["05.ogg"] = 00.50,
								["06.ogg"] = 00.45,
								["07.ogg"] = 00.44,
								["08.ogg"] = 00.30,
								["09.ogg"] = 00.51,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.18,
								["02.ogg"] = 01.53,
								["03.ogg"] = 01.13,
								["04.ogg"] = 01.01,
								["05.ogg"] = 01.08,
							},
							["Wound_"] = {
								["01.ogg"] = 00.53,
								["010.ogg"] = 00.84,
								["02.ogg"] = 00.43,
								["03.ogg"] = 00.42,
								["04.ogg"] = 00.74,
								["05.ogg"] = 00.51,
								["06.ogg"] = 00.72,
								["07.ogg"] = 00.44,
								["08.ogg"] = 00.46,
								["09.ogg"] = 00.54,
							},
						},
						["ID_AHRIOK_"] = {
							["DEATH.ogg"] = 05.12,
							["INTRO.ogg"] = 04.14,
							["SPELL01.ogg"] = 05.51,
							["SPELL02.ogg"] = 07.20,
							["SPELL03.ogg"] = 03.49,
						},
					},
				},
				["AirSpirit\\MON_"] = {
					["AirSpirit_"] = {
						["Attack01.OGG"] = 02.11,
						["Attack02.OGG"] = 02.19,
						["Attack03.OGG"] = 02.69,
						["Attack04.OGG"] = 02.59,
						["Attack05.OGG"] = 02.39,
						["Attack06.OGG"] = 02.38,
						["Attack07.OGG"] = 02.21,
						["Attack08.OGG"] = 02.26,
						["Attack09.OGG"] = 02.49,
						["Attack10.OGG"] = 02.39,
						["AttackCrit01.OGG"] = 01.85,
						["AttackCrit02.OGG"] = 02.28,
						["AttackCrit03.OGG"] = 02.36,
						["AttackCrit04.OGG"] = 02.62,
						["AttackCrit05.OGG"] = 02.56,
						["BattleRoar01.OGG"] = 02.77,
						["Death01.OGG"] = 05.79,
						["Death02.OGG"] = 05.44,
						["Death03.OGG"] = 05.44,
						["Death04.OGG"] = 05.45,
						["Death05.OGG"] = 05.33,
						["Wound01.OGG"] = 01.92,
						["Wound02.OGG"] = 02.01,
						["Wound03.OGG"] = 02.09,
						["Wound04.OGG"] = 01.71,
						["Wound05.OGG"] = 01.62,
						["Wound06.OGG"] = 02.14,
						["Wound07.OGG"] = 02.44,
						["Wound08.OGG"] = 01.89,
						["Wound09.OGG"] = 01.77,
						["Wound10.OGG"] = 02.33,
						["WoundCrit01.OGG"] = 02.38,
						["WoundCrit02.OGG"] = 02.36,
						["WoundCrit03.OGG"] = 02.49,
						["WoundCrit04.OGG"] = 02.29,
						["WoundCrit05.OGG"] = 02.53,
					},
				},
				["Akaani\\VO_"] = {
					["60_"] = {
						["AKAANI_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.43,
								["02.ogg"] = 01.28,
								["03.ogg"] = 00.75,
								["04.ogg"] = 00.80,
								["05.ogg"] = 01.66,
							},
							["Attack_"] = {
								["01.ogg"] = 00.39,
								["010.ogg"] = 00.38,
								["02.ogg"] = 00.43,
								["03.ogg"] = 00.38,
								["04.ogg"] = 00.33,
								["05.ogg"] = 00.34,
								["06.ogg"] = 00.45,
								["07.ogg"] = 00.37,
								["08.ogg"] = 00.33,
								["09.ogg"] = 00.29,
							},
							["Death_"] = {
								["01.ogg"] = 02.56,
								["02.ogg"] = 02.06,
								["03.ogg"] = 02.06,
								["04.ogg"] = 01.87,
								["05.ogg"] = 01.94,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 00.82,
								["02.ogg"] = 00.94,
								["03.ogg"] = 01.11,
								["04.ogg"] = 00.70,
								["05.ogg"] = 00.90,
							},
							["Wound_"] = {
								["01.ogg"] = 00.40,
								["010.ogg"] = 00.40,
								["02.ogg"] = 00.71,
								["03.ogg"] = 00.40,
								["04.ogg"] = 00.39,
								["05.ogg"] = 00.43,
								["06.ogg"] = 00.47,
								["07.ogg"] = 00.51,
								["08.ogg"] = 00.62,
								["09.ogg"] = 00.54,
							},
						},
						["GLADIATOR_AKAANI_"] = {
							["EXIT_"] = {
								["FAIL.ogg"] = 02.36,
								["HIGH.ogg"] = 01.84,
								["MID.ogg"] = 01.26,
							},
							["ONKILL_"] = {
								["01.ogg"] = 03.25,
								["02.ogg"] = 01.35,
							},
							["ENTRANCE_01.ogg"] = 02.08,
						},
					},
				},
				["Akama\\"] = {
					["BLCKTMPLE_Akama_"] = {
						["01.ogg"] = 05.29,
						["02.ogg"] = 04.65,
						["03.ogg"] = 04.32,
						["AkamaDies01.ogg"] = 08.67,
						["Attack01.ogg"] = 00.63,
						["Attack02.ogg"] = 00.68,
						["Attack03.ogg"] = 00.27,
						["Attack04.ogg"] = 00.28,
						["Defend01.ogg"] = 06.01,
						["FightBgn01.ogg"] = 09.90,
						["FinalWin01.ogg"] = 05.89,
						["Freed01.ogg"] = 03.90,
						["Incmng01.ogg"] = 02.40,
						["Incmng02.ogg"] = 02.17,
						["LowHlth01.ogg"] = 02.80,
						["LowHlth02.ogg"] = 03.10,
						["PreFight01.ogg"] = 05.22,
						["Slay01.ogg"] = 02.51,
						["Slay02.ogg"] = 02.18,
						["Warn01.ogg"] = 05.10,
						["Wound01.ogg"] = 00.60,
						["Wound02.ogg"] = 00.50,
						["Wound03.ogg"] = 00.49,
						["WoundCrit01.ogg"] = 00.65,
						["WoundCrit02.ogg"] = 00.66,
						["WoundCrit03.ogg"] = 00.64,
					},
					["BTPRLUDE_"] = {
						["Akama01.ogg"] = 04.47,
						["Akama02.ogg"] = 06.48,
						["Akama03.ogg"] = 05.76,
						["Akama04.ogg"] = 07.99,
						["Akama05.ogg"] = 06.11,
						["Akama06.ogg"] = 07.39,
						["Akama07.ogg"] = 16.84,
						["Akama08.ogg"] = 01.77,
					},
					["VO_60_"] = {
						["Akama_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 00.99,
								["02.ogg"] = 01.63,
								["03.ogg"] = 02.01,
								["04.ogg"] = 01.57,
								["05.ogg"] = 01.73,
							},
							["Attack_"] = {
								["01.ogg"] = 00.51,
								["010.ogg"] = 00.58,
								["02.ogg"] = 00.49,
								["03.ogg"] = 00.72,
								["04.ogg"] = 00.74,
								["05.ogg"] = 00.50,
								["06.ogg"] = 00.51,
								["07.ogg"] = 00.77,
								["08.ogg"] = 00.66,
								["09.ogg"] = 00.56,
							},
							["CROWNING_"] = {
								["01.ogg"] = 03.64,
								["02.ogg"] = 07.39,
								["03.ogg"] = 06.43,
								["04.ogg"] = 03.86,
								["05.ogg"] = 07.20,
								["06.ogg"] = 04.46,
								["07.ogg"] = 07.91,
								["08.ogg"] = 02.40,
								["09.ogg"] = 02.28,
							},
							["Death_"] = {
								["01.ogg"] = 02.09,
								["02.ogg"] = 01.94,
								["03.ogg"] = 02.33,
								["04.ogg"] = 02.78,
								["05.ogg"] = 03.49,
							},
							["FAREWELL_"] = {
								["01.ogg"] = 01.49,
								["02.ogg"] = 01.25,
								["03.ogg"] = 01.74,
							},
							["GREETING_"] = {
								["01.ogg"] = 01.90,
								["02.ogg"] = 02.27,
								["03.ogg"] = 01.62,
							},
							["TRIAL_"] = {
								["01.ogg"] = 06.75,
								["02.ogg"] = 03.01,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 00.78,
								["02.ogg"] = 01.09,
								["03.ogg"] = 00.86,
								["04.ogg"] = 00.64,
								["05.ogg"] = 01.00,
							},
							["Wound_"] = {
								["01.ogg"] = 00.40,
								["010.ogg"] = 00.65,
								["02.ogg"] = 00.41,
								["03.ogg"] = 00.36,
								["04.ogg"] = 00.41,
								["05.ogg"] = 00.39,
								["06.ogg"] = 00.65,
								["07.ogg"] = 00.58,
								["08.ogg"] = 00.37,
								["09.ogg"] = 00.36,
							},
							["BECOME_01.ogg"] = 04.54,
							["PISSED_01.ogg"] = 01.85,
						},
						["SMV_"] = {
							["BELLIES_AKAMA_"] = {
								["01.ogg"] = 03.85,
								["02.ogg"] = 05.51,
								["03.ogg"] = 03.75,
								["04.ogg"] = 06.17,
								["05.ogg"] = 02.25,
								["06.ogg"] = 00.97,
								["07.ogg"] = 03.69,
							},
							["EXARCH_AKAMA_"] = {
								["01.ogg"] = 03.29,
								["02.ogg"] = 03.76,
								["03.ogg"] = 03.82,
							},
							["KARABOR_AKAMA_"] = {
								["01.ogg"] = 04.01,
								["02.ogg"] = 02.86,
							},
							["MURDER_AKAMA_"] = {
								["01.ogg"] = 03.03,
								["02.ogg"] = 02.84,
							},
						},
					},
				},
				["Akilzon\\"] = {
					["AkilzonAggro.ogg"] = 03.58,
					["AkilzonBerserk.ogg"] = 02.78,
					["AkilzonDeath.ogg"] = 03.70,
					["AkilzonEagleSnare.ogg"] = 02.19,
					["AkilzonEvent01.ogg"] = 07.27,
					["AkilzonEvent02.ogg"] = 05.66,
					["AkilzonSlay01.ogg"] = 01.30,
					["AkilzonSlay02.ogg"] = 01.26,
					["AkilzonSummonEagle.ogg"] = 02.23,
				},
				["AKOLIK\\VO_"] = {
					["54_OR_"] = {
						["THOK_AKOLIK_"] = {
							["01.OGG"] = 05.74,
							["02.OGG"] = 05.46,
							["03.OGG"] = 05.80,
							["04.OGG"] = 04.47,
							["05.OGG"] = 05.74,
						},
					},
				},
				["Alchukla\\VO_"] = {
					["52_Alchukla_"] = {
						["Alliance_Blast_"] = {
							["01.OGG"] = 03.14,
							["02.OGG"] = 05.28,
							["03.OGG"] = 02.63,
							["04.OGG"] = 02.82,
							["05.OGG"] = 05.05,
							["06.OGG"] = 03.40,
							["07.OGG"] = 01.51,
							["08.OGG"] = 05.02,
							["09.OGG"] = 05.11,
							["10.OGG"] = 05.02,
							["11.OGG"] = 06.85,
							["12.OGG"] = 06.43,
							["13.OGG"] = 04.64,
						},
					},
				},
				["AlexandrosMograine\\"] = {
					["IC_Alexandros_"] = {
						["Comp301.ogg"] = 03.83,
						["Comp302.ogg"] = 06.25,
						["Comp303.ogg"] = 06.10,
						["Comp304.ogg"] = 09.53,
						["Comp305.ogg"] = 06.27,
						["Comp306.ogg"] = 07.89,
						["Comp307.ogg"] = 08.83,
					},
					["PE_AlexandrosMograine_"] = {
						["DeathKnightEvent01.ogg"] = 04.70,
						["DeathKnightEvent02.ogg"] = 06.17,
						["DeathKnightEvent03.ogg"] = 13.83,
						["DeathKnightEvent04.ogg"] = 26.89,
						["DeathKnightEvent05.ogg"] = 03.25,
					},
				},
				["Alexstrasza\\VO_"] = {
					["Alexstrasza_"] = {
						["Greeting01.OGG"] = 01.21,
						["Greeting02.OGG"] = 03.68,
						["Greeting03.OGG"] = 02.45,
						["Greeting04.OGG"] = 04.88,
						["Greeting05.OGG"] = 04.51,
					},
					["DS_"] = {
						["ALEXSTRASZA_"] = {
							["DWBATTLE_"] = {
								["01.OGG"] = 10.58,
								["02.OGG"] = 04.99,
								["03.OGG"] = 01.93,
								["04.OGG"] = 10.90,
							},
							["DWVICTORY_"] = {
								["01.OGG"] = 06.75,
								["02.OGG"] = 07.99,
							},
							["PREHAGARA_01.OGG"] = 02.26,
						},
						["ALEXSTRAZA_"] = {
							["IRIS_01.OGG"] = 08.78,
							["PREULTRAXION_02.OGG"] = 05.28,
							["ULTRAXIONVICTORY_01.OGG"] = 08.67,
							["ULTRAXION_01.OGG"] = 05.68,
						},
					},
					["QE_TH_"] = {
						["Alexstrasza_"] = {
							["Attack01.ogg"] = 00.56,
							["Attack02.ogg"] = 00.73,
							["Attack03.ogg"] = 00.61,
							["Attack04.ogg"] = 00.91,
							["Attack05.ogg"] = 01.25,
							["Attack06.ogg"] = 01.15,
							["Attack07.ogg"] = 01.29,
							["Attack08.ogg"] = 00.86,
							["Attack09.ogg"] = 01.09,
							["Attack10.ogg"] = 01.75,
							["AttackCritical01.ogg"] = 01.05,
							["AttackCritical02.ogg"] = 01.28,
							["AttackCritical03.ogg"] = 01.20,
							["AttackCritical04.ogg"] = 00.70,
							["AttackCritical05.ogg"] = 01.19,
							["AttackCritical06.ogg"] = 01.09,
							["Death01.ogg"] = 01.86,
							["Death02.ogg"] = 02.24,
							["Death03.ogg"] = 02.20,
							["Event01.ogg"] = 08.13,
							["Event02.ogg"] = 09.14,
							["Event03.ogg"] = 06.64,
							["Event04.ogg"] = 07.03,
							["Event05.ogg"] = 08.84,
							["Event06.ogg"] = 03.78,
							["Event07.ogg"] = 18.44,
							["Event08.ogg"] = 01.46,
							["Event09.ogg"] = 02.54,
							["Event10.ogg"] = 01.63,
							["Wound01.ogg"] = 00.54,
							["Wound02.ogg"] = 00.57,
							["Wound03.ogg"] = 00.61,
							["Wound04.ogg"] = 00.59,
							["Wound05.ogg"] = 00.44,
							["Wound06.ogg"] = 00.70,
							["Wound07.ogg"] = 00.64,
							["Wound08.ogg"] = 00.67,
							["WoundCritical01.ogg"] = 00.85,
							["WoundCritical02.ogg"] = 00.68,
							["WoundCritical03.ogg"] = 00.75,
							["WoundCritical04.ogg"] = 00.74,
							["WoundCritical05.ogg"] = 00.88,
							["WoundCritical06.ogg"] = 00.77,
						},
					},
					["WOE_ALEXSTRASZA_"] = {
						["EVENT_"] = {
							["01.OGG"] = 07.18,
							["02.OGG"] = 07.30,
							["03.OGG"] = 02.82,
						},
					},
				},
				["Alexstraza\\EE_"] = {
					["Alexstrasza_"] = {
						["EndSpeech01.ogg"] = 04.63,
						["EndSpeech02.ogg"] = 02.53,
						["EndSpeech03.ogg"] = 23.37,
						["EndSpeech04.ogg"] = 18.06,
						["HelpSpeech01.ogg"] = 15.97,
						["HelpSpeech01_02.ogg"] = 06.08,
					},
				},
				["AlgalonTheObserver\\UR_"] = {
					["Algalon_"] = {
						["Adds01.ogg"] = 04.45,
						["Adds02.ogg"] = 10.84,
						["Aggro01.ogg"] = 13.77,
						["Attack01.ogg"] = 02.43,
						["Attack02.ogg"] = 02.43,
						["Attack03.ogg"] = 02.66,
						["Attack04.ogg"] = 02.50,
						["Attack05.ogg"] = 02.73,
						["Attack06.ogg"] = 02.97,
						["Berserk02.ogg"] = 13.80,
						["Berzerk01.ogg"] = 05.30,
						["BHole01.ogg"] = 03.40,
						["Death01.ogg"] = 39.10,
						["Death02.ogg"] = 16.85,
						["Death03.ogg"] = 10.09,
						["Slay01.ogg"] = 04.06,
						["Slay02.ogg"] = 03.77,
						["Space01.ogg"] = 11.69,
						["Special01.ogg"] = 04.72,
						["Special02.ogg"] = 05.23,
						["Summon01.ogg"] = 07.98,
						["Summon02.ogg"] = 06.10,
						["Summon03.ogg"] = 11.00,
						["Timer01.ogg"] = 12.15,
						["Timer02.ogg"] = 09.50,
						["Timer03.ogg"] = 08.22,
						["Wound01.ogg"] = 02.32,
						["Wound02.ogg"] = 02.51,
						["Wound03.ogg"] = 02.24,
						["Wound04.ogg"] = 02.36,
						["Wound05.ogg"] = 02.62,
						["Wound06.ogg"] = 02.81,
						["Wound07.ogg"] = 02.70,
						["Wound08.ogg"] = 02.71,
						["WoundCrit01.ogg"] = 02.65,
						["WoundCrit02.ogg"] = 02.80,
						["WoundCrit03.ogg"] = 02.75,
						["WoundCrit04.ogg"] = 02.51,
						["WoundCrit05.ogg"] = 02.61,
						["WoundCrit06.ogg"] = 02.79,
					},
				},
				["ALIZABAL\\VO_"] = {
					["ALIZABAL_"] = {
						["Attack01.OGG"] = 01.17,
						["Attack02.OGG"] = 01.44,
						["Attack03.OGG"] = 01.30,
						["Attack04.OGG"] = 01.54,
						["Attack05.OGG"] = 01.38,
						["Attack06.OGG"] = 01.39,
						["Attack07.OGG"] = 01.73,
						["Attack08.OGG"] = 01.84,
						["Attack09.OGG"] = 01.99,
						["Attack10.OGG"] = 01.64,
						["AttackCrit01.OGG"] = 02.61,
						["AttackCrit02.OGG"] = 02.52,
						["AttackCrit03.OGG"] = 02.01,
						["AttackCrit04.OGG"] = 02.35,
						["AttackCrit05.OGG"] = 02.23,
						["Wound01.OGG"] = 01.00,
						["Wound02.OGG"] = 01.31,
						["Wound03.OGG"] = 01.25,
						["Wound04.OGG"] = 01.34,
						["Wound05.OGG"] = 01.28,
						["Wound06.OGG"] = 01.24,
						["Wound07.OGG"] = 01.67,
						["Wound08.OGG"] = 01.66,
						["Wound09.OGG"] = 01.58,
						["Wound10.OGG"] = 01.40,
						["WoundCrit01.OGG"] = 02.43,
						["WoundCrit02.OGG"] = 01.77,
						["WoundCrit03.OGG"] = 02.05,
						["WoundCrit04.OGG"] = 01.75,
						["WoundCrit05.OGG"] = 01.83,
					},
					["BH_ALIZABAL_"] = {
						["SLAY_"] = {
							["01.OGG"] = 02.67,
							["02.OGG"] = 03.62,
							["03.OGG"] = 02.65,
							["04.OGG"] = 02.70,
						},
						["SPELL_"] = {
							["01.OGG"] = 02.93,
							["02.OGG"] = 02.94,
							["03.OGG"] = 02.95,
							["04.OGG"] = 03.28,
							["05.OGG"] = 03.92,
							["06.OGG"] = 03.40,
							["07.OGG"] = 03.02,
						},
						["AGGRO_01.OGG"] = 03.06,
						["DEATH_01.OGG"] = 04.69,
						["INTRO_01.OGG"] = 11.75,
						["RESET_01.OGG"] = 03.96,
					},
				},
				["AlkizonExertions\\"] = {
					["AkilzonAttackA.ogg"] = 00.88,
					["AlkilzonAttackB.ogg"] = 00.98,
					["AlkilzonAttackC.ogg"] = 01.16,
					["AlkilzonAttackD.ogg"] = 00.64,
					["AlkilzonAttackE.ogg"] = 00.95,
					["AlkilzonAttackF.ogg"] = 00.54,
					["AlkilzonAttackG.ogg"] = 00.54,
					["AlkilzonAttackH.ogg"] = 00.55,
					["AlkilzonWoundA.ogg"] = 00.61,
					["AlkilzonWoundB.ogg"] = 01.13,
					["AlkilzonWoundC.ogg"] = 00.77,
					["AlkilzonWoundCrit.ogg"] = 00.79,
					["AlkilzonWoundD.ogg"] = 00.98,
					["AlkilzonWoundE.ogg"] = 00.55,
					["AlkilzonWoundF.ogg"] = 00.51,
				},
				["AllianceCommander\\VO_"] = {
					["60_SD_"] = {
						["ALLIANCECOMMANDER_"] = {
							["DEATH_"] = {
								["ALLIANCE.ogg"] = 04.90,
								["HORDE.ogg"] = 04.61,
							},
							["AGGRO.ogg"] = 01.27,
							["EVENT01.ogg"] = 00.77,
							["EVENT02.ogg"] = 02.33,
							["EVENT03.ogg"] = 01.74,
							["EVENT04.ogg"] = 01.89,
							["EVENT05.ogg"] = 01.15,
							["EVENT06.ogg"] = 02.53,
							["EVENT07.ogg"] = 02.33,
							["INTRO.ogg"] = 03.78,
						},
					},
				},
				["AllianceWorker\\VO_"] = {
					["60_GAR_"] = {
						["ALLIANCE_WORKER_"] = {
							["01.ogg"] = 01.33,
							["02.ogg"] = 01.81,
							["03.ogg"] = 01.56,
							["04.ogg"] = 00.53,
							["05.ogg"] = 01.34,
							["06.ogg"] = 01.79,
							["07.ogg"] = 01.87,
							["08.ogg"] = 03.37,
							["09.ogg"] = 01.35,
							["10.ogg"] = 01.98,
						},
					},
				},
				["ALYSRAZOR\\VO_"] = {
					["FL_ALYSRAZOR_"] = {
						["KILL_"] = {
							["01.ogg"] = 03.12,
							["02.ogg"] = 04.61,
						},
						["LAUGH_"] = {
							["01.ogg"] = 04.11,
							["02.ogg"] = 05.14,
						},
						["SPIRAL_"] = {
							["01.ogg"] = 05.36,
							["02.ogg"] = 05.34,
						},
						["TRANSITION_"] = {
							["01.ogg"] = 04.83,
							["02.ogg"] = 06.04,
						},
						["AGGRO.ogg"] = 07.19,
						["ATTACK01.ogg"] = 02.29,
						["ATTACK02.ogg"] = 01.76,
						["ATTACK03.ogg"] = 01.98,
						["ATTACK04.ogg"] = 01.93,
						["ATTACK05.ogg"] = 02.16,
						["ATTACK06.ogg"] = 01.97,
						["ATTACK07.ogg"] = 02.03,
						["ATTACK08.ogg"] = 02.01,
						["ATTACK09.ogg"] = 02.09,
						["ATTACK10.ogg"] = 02.05,
						["ATTACKCRIT01.ogg"] = 01.93,
						["ATTACKCRIT02.ogg"] = 02.85,
						["ATTACKCRIT03.ogg"] = 02.97,
						["ATTACKCRIT04.ogg"] = 02.37,
						["ATTACKCRIT05.ogg"] = 02.96,
						["DEATH.ogg"] = 08.67,
						["SPELLCAST01.ogg"] = 02.11,
						["SPELLCAST02.ogg"] = 02.72,
						["SPELLCAST03.ogg"] = 01.97,
						["SPELLCAST04.ogg"] = 02.60,
						["WOUND01.ogg"] = 02.05,
						["WOUND02.ogg"] = 02.20,
						["WOUND03.ogg"] = 02.25,
						["WOUND04.ogg"] = 02.54,
						["WOUND05.ogg"] = 01.77,
						["WOUND06.ogg"] = 01.69,
						["WOUND07.ogg"] = 01.71,
						["WOUND08.ogg"] = 01.52,
						["WOUND09.ogg"] = 01.88,
						["WOUND10.ogg"] = 01.90,
						["WOUNDCRIT01.ogg"] = 02.33,
						["WOUNDCRIT02.ogg"] = 02.76,
						["WOUNDCRIT03.ogg"] = 02.80,
						["WOUNDCRIT04.ogg"] = 02.66,
						["WOUNDCRIT05.ogg"] = 02.64,
					},
					["QUEST_42_ALYSRAZOR.ogg"] = 13.48,
				},
				["AmbassadorHellmaw\\Auch_"] = {
					["Helmaw_"] = {
						["Aggro01.ogg"] = 04.15,
						["Aggro02.ogg"] = 02.51,
						["Aggro03.ogg"] = 04.23,
						["Death01.ogg"] = 05.91,
						["Help01.ogg"] = 03.38,
						["Slay01.ogg"] = 07.98,
						["Slay02.ogg"] = 04.19,
					},
					["Hellmaw_Intro01.ogg"] = 10.32,
				},
				["AmberKearnen\\VO_"] = {
					["Alliance_Flight_"] = {
						["Amber_"] = {
							["01.OGG"] = 03.01,
							["02.OGG"] = 03.15,
							["03.OGG"] = 00.62,
							["04.OGG"] = 02.30,
							["05.OGG"] = 01.99,
							["06.OGG"] = 03.69,
							["07.OGG"] = 02.67,
						},
					},
					["AMBER_"] = {
						["GREETING_"] = {
							["01.OGG"] = 00.60,
							["02.OGG"] = 01.51,
							["03.OGG"] = 00.99,
							["04.OGG"] = 00.90,
							["05.OGG"] = 01.17,
						},
						["SPY_QUEST_"] = {
							["A_"] = {
								["01.OGG"] = 02.57,
								["02.OGG"] = 04.78,
								["03.OGG"] = 04.28,
							},
							["B_"] = {
								["01.OGG"] = 00.82,
								["02.OGG"] = 02.42,
								["03.OGG"] = 05.87,
							},
							["C_"] = {
								["01.OGG"] = 03.28,
								["02.OGG"] = 03.90,
								["03.OGG"] = 03.56,
								["04.OGG"] = 08.50,
							},
							["D_"] = {
								["01.OGG"] = 03.68,
								["02.OGG"] = 03.84,
								["03.OGG"] = 01.61,
								["04.OGG"] = 02.64,
								["05.OGG"] = 04.51,
								["06.OGG"] = 03.07,
								["07.OGG"] = 06.51,
								["08.OGG"] = 05.41,
							},
						},
					},
					["Jade_Forest_"] = {
						["Anduin_Decision_"] = {
							["Amber_"] = {
								["01.OGG"] = 02.01,
								["02.OGG"] = 03.62,
								["03.OGG"] = 02.80,
							},
						},
					},
				},
				["AmberScorpion\\MON_"] = {
					["AmberScorpion_"] = {
						["Aggro_"] = {
							["01.OGG"] = 01.52,
							["02.OGG"] = 01.70,
							["03.OGG"] = 01.83,
							["04.OGG"] = 01.37,
							["05.OGG"] = 02.08,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.97,
							["02.OGG"] = 01.35,
							["03.OGG"] = 01.42,
							["04.OGG"] = 01.38,
							["05.OGG"] = 01.55,
						},
						["Attacks_"] = {
							["01.OGG"] = 01.27,
							["02.OGG"] = 01.44,
							["03.OGG"] = 01.25,
							["04.OGG"] = 01.99,
							["05.OGG"] = 01.48,
							["06.OGG"] = 01.58,
							["07.OGG"] = 01.39,
							["08.OGG"] = 01.58,
							["09.OGG"] = 01.57,
							["10.OGG"] = 01.49,
						},
						["Death_"] = {
							["01.OGG"] = 03.88,
							["02.OGG"] = 03.99,
							["03.OGG"] = 03.06,
							["04.OGG"] = 03.02,
							["05.OGG"] = 03.87,
							["06.OGG"] = 03.23,
							["07.OGG"] = 03.60,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.86,
							["02.OGG"] = 02.13,
							["03.OGG"] = 01.74,
						},
						["Walk_"] = {
							["01.OGG"] = 02.83,
							["010.OGG"] = 01.20,
							["02.OGG"] = 02.26,
							["03.OGG"] = 01.63,
							["04.OGG"] = 01.73,
							["05.OGG"] = 02.09,
							["06.OGG"] = 02.67,
							["07.OGG"] = 01.39,
							["08.OGG"] = 01.75,
							["09.OGG"] = 01.35,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.32,
							["02.OGG"] = 01.49,
							["03.OGG"] = 01.71,
							["04.OGG"] = 01.71,
							["05.OGG"] = 01.37,
						},
						["Wound_"] = {
							["01.OGG"] = 01.41,
							["02.OGG"] = 01.74,
							["03.OGG"] = 01.85,
							["04.OGG"] = 01.51,
							["05.OGG"] = 01.41,
							["06.OGG"] = 01.53,
							["07.OGG"] = 02.25,
							["08.OGG"] = 01.84,
							["09.OGG"] = 01.53,
							["10.OGG"] = 01.44,
						},
						["MountSpecial1.OGG"] = 03.22,
						["MountSpecial2.OGG"] = 03.28,
						["MountSpecial3.OGG"] = 02.50,
					},
				},
				["AmbershaperUnsok\\VO_"] = {
					["DW_UNSOK_"] = {
						["01.OGG"] = 06.67,
						["02.OGG"] = 04.09,
						["03.OGG"] = 07.91,
						["04.OGG"] = 03.05,
						["05.OGG"] = 04.63,
					},
					["MP_UNSOK_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 01.58,
							["02.OGG"] = 01.80,
							["03.OGG"] = 01.51,
							["04.OGG"] = 01.74,
							["05.OGG"] = 01.69,
						},
						["ATTACK_"] = {
							["01.OGG"] = 01.06,
							["02.OGG"] = 01.10,
							["03.OGG"] = 00.91,
							["04.OGG"] = 01.40,
							["05.OGG"] = 01.11,
							["06.OGG"] = 01.12,
							["07.OGG"] = 01.42,
							["08.OGG"] = 01.11,
							["09.OGG"] = 01.12,
							["10.OGG"] = 00.73,
						},
						["EVENT_"] = {
							["PHASE2_01.OGG"] = 09.28,
							["PHASE3_01.OGG"] = 06.11,
						},
						["SLAY_"] = {
							["01.OGG"] = 01.72,
							["02.OGG"] = 01.83,
						},
						["SPELL_"] = {
							["01.OGG"] = 03.62,
							["02.OGG"] = 01.95,
							["03.OGG"] = 05.92,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 00.81,
							["02.OGG"] = 01.01,
							["03.OGG"] = 01.02,
							["04.OGG"] = 01.06,
							["05.OGG"] = 01.32,
						},
						["WOUND_"] = {
							["01.OGG"] = 01.02,
							["02.OGG"] = 01.08,
							["03.OGG"] = 01.03,
							["04.OGG"] = 01.10,
							["05.OGG"] = 01.02,
							["06.OGG"] = 00.76,
							["07.OGG"] = 00.91,
							["08.OGG"] = 00.97,
							["09.OGG"] = 00.95,
							["10.OGG"] = 00.60,
						},
						["AGRO_01.OGG"] = 08.80,
						["DEATH_01.OGG"] = 03.78,
						["INTRO_01.OGG"] = 09.54,
					},
				},
				["AmbMonstrosity\\VO_"] = {
					["MP_MONSTROSITY_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 02.25,
							["02.OGG"] = 03.08,
							["03.OGG"] = 02.33,
							["04.OGG"] = 02.46,
							["05.OGG"] = 03.61,
						},
						["Attack_"] = {
							["01.OGG"] = 01.40,
							["02.OGG"] = 01.55,
							["03.OGG"] = 01.29,
							["04.OGG"] = 01.42,
							["05.OGG"] = 01.50,
							["06.OGG"] = 01.42,
							["07.OGG"] = 01.52,
							["08.OGG"] = 01.63,
							["09.OGG"] = 01.47,
						},
						["SPELL_"] = {
							["01.OGG"] = 06.77,
							["02.OGG"] = 03.33,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 04.77,
							["02.OGG"] = 04.54,
							["03.OGG"] = 04.37,
							["04.OGG"] = 04.18,
							["05.OGG"] = 02.67,
						},
						["Wound_"] = {
							["01.OGG"] = 01.43,
							["02.OGG"] = 01.75,
							["03.OGG"] = 02.35,
							["04.OGG"] = 01.87,
							["05.OGG"] = 02.02,
							["06.OGG"] = 02.09,
							["07.OGG"] = 01.78,
							["08.OGG"] = 01.83,
							["09.OGG"] = 02.92,
						},
						["AGGRO_01.OGG"] = 04.44,
						["DEATH_01.OGG"] = 08.26,
						["SLAY_01.OGG"] = 06.76,
					},
				},
				["AmmenValeLashling\\PET_"] = {
					["AmmenValeLashling_"] = {
						["Clickable01.ogg"] = 00.90,
						["Clickable02.ogg"] = 00.90,
						["Clickable03.ogg"] = 00.94,
						["Clickable04.ogg"] = 01.78,
						["Clickable05.ogg"] = 01.70,
						["Clickable06.ogg"] = 01.54,
						["Clickable07.ogg"] = 02.48,
						["Clickable08.ogg"] = 02.18,
						["Clickable09.ogg"] = 01.28,
						["Clickable10.ogg"] = 01.71,
					},
				},
				["Ammunae\\VO_"] = {
					["HO_Ammunae_"] = {
						["Attack01.ogg"] = 01.10,
						["Attack02.ogg"] = 01.36,
						["Attack03.ogg"] = 01.33,
						["Attack04.ogg"] = 01.44,
						["Attack05.ogg"] = 01.14,
						["Attack06.ogg"] = 01.26,
						["Attack07.ogg"] = 01.70,
						["Attack08.ogg"] = 01.74,
						["Attack09.ogg"] = 02.37,
						["AttackCrit01.ogg"] = 01.92,
						["AttackCrit02.ogg"] = 01.86,
						["AttackCrit03.ogg"] = 01.90,
						["Death01.ogg"] = 03.44,
						["Engage01.ogg"] = 05.46,
						["Event01.ogg"] = 03.56,
						["Slay01.ogg"] = 01.89,
						["Slay02.ogg"] = 02.38,
						["Wound01.ogg"] = 01.02,
						["Wound02.ogg"] = 01.05,
						["Wound03.ogg"] = 01.55,
						["Wound04.ogg"] = 01.41,
						["Wound05.ogg"] = 01.53,
						["Wound06.ogg"] = 01.53,
						["Wound07.ogg"] = 01.75,
						["Wound08.ogg"] = 01.33,
						["Wound09.ogg"] = 01.32,
						["WoundCrit01.ogg"] = 01.84,
						["WoundCrit02.ogg"] = 02.00,
						["WoundCrit03.ogg"] = 00.92,
						["WoundCrit04.ogg"] = 01.81,
						["WoundCrit05.ogg"] = 01.36,
					},
				},
				["AmnennarTheColdbringer\\"] = {
					["AmnennarTheColdbringerAggro01.ogg"] = 03.55,
					["AmnennarTheColdbringerHealth01.ogg"] = 03.59,
					["AmnennarTheColdbringerSlay01.ogg"] = 02.11,
					["AmnennarTheColdbringerSummon01.ogg"] = 02.72,
					["AmnennarTheColdbringerSummon02.ogg"] = 04.09,
				},
				["ANACHRONOS\\VO_"] = {
					["QUEST_42_"] = {
						["ANACHRONOS_VISION_"] = {
							["01.ogg"] = 02.01,
							["02.ogg"] = 04.53,
							["03.ogg"] = 07.83,
							["04.ogg"] = 05.77,
							["05.ogg"] = 07.15,
							["06.ogg"] = 03.60,
							["07.ogg"] = 02.36,
							["08.ogg"] = 05.73,
							["09.ogg"] = 04.87,
							["10.ogg"] = 04.43,
							["11.ogg"] = 02.40,
						},
					},
				},
				["AncientofArcane\\AncientofArcane_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.57,
						["02.ogg"] = 01.29,
						["03.ogg"] = 02.39,
						["04.ogg"] = 02.57,
						["05.ogg"] = 01.76,
						["06.ogg"] = 01.96,
						["07.ogg"] = 01.76,
						["08.ogg"] = 02.36,
						["09.ogg"] = 02.20,
						["10.ogg"] = 02.17,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 01.99,
						["02.ogg"] = 01.92,
						["03.ogg"] = 02.00,
						["04.ogg"] = 01.58,
						["05.ogg"] = 01.67,
						["06.ogg"] = 02.20,
						["07.ogg"] = 01.97,
						["08.ogg"] = 02.07,
						["09.ogg"] = 02.31,
						["10.ogg"] = 01.94,
					},
					["Attack_"] = {
						["01.ogg"] = 01.47,
						["02.ogg"] = 01.43,
						["03.ogg"] = 01.47,
						["04.ogg"] = 01.48,
						["05.ogg"] = 02.02,
						["06.ogg"] = 01.47,
						["07.ogg"] = 01.51,
						["08.ogg"] = 01.47,
						["09.ogg"] = 01.57,
						["10.ogg"] = 01.43,
					},
					["Death_"] = {
						["01.ogg"] = 07.31,
						["02.ogg"] = 07.31,
						["03.ogg"] = 07.31,
						["04.ogg"] = 07.31,
						["05.ogg"] = 07.31,
						["06.ogg"] = 07.31,
						["07.ogg"] = 06.87,
						["08.ogg"] = 06.45,
						["09.ogg"] = 07.31,
						["10.ogg"] = 07.31,
					},
					["PreAggro_"] = {
						["01.ogg"] = 02.69,
						["02.ogg"] = 02.29,
						["03.ogg"] = 01.99,
						["04.ogg"] = 01.82,
						["05.ogg"] = 02.08,
						["06.ogg"] = 01.86,
						["07.ogg"] = 02.20,
						["08.ogg"] = 02.10,
						["09.ogg"] = 02.03,
						["10.ogg"] = 01.92,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 02.55,
						["02.ogg"] = 02.72,
						["03.ogg"] = 02.59,
						["04.ogg"] = 02.44,
						["05.ogg"] = 02.78,
						["06.ogg"] = 02.69,
						["07.ogg"] = 02.14,
						["08.ogg"] = 02.17,
						["09.ogg"] = 02.14,
						["10.ogg"] = 02.30,
					},
					["Wound_"] = {
						["01.ogg"] = 01.59,
						["02.ogg"] = 01.54,
						["03.ogg"] = 01.40,
						["04.ogg"] = 01.67,
						["05.ogg"] = 01.30,
						["06.ogg"] = 01.08,
						["07.ogg"] = 01.47,
						["08.ogg"] = 01.11,
						["09.ogg"] = 01.21,
						["10.ogg"] = 01.62,
					},
				},
				["AncientProtector\\"] = {
					["mAncientAttack1.ogg"] = 02.21,
					["mAncientAttack2.ogg"] = 02.02,
					["mAncientAttack3.ogg"] = 02.01,
					["mAncientDeath1.ogg"] = 08.06,
					["mAncientStandFidget1.ogg"] = 09.29,
					["mAncientStandFidget2.ogg"] = 09.17,
					["mAncientStandFidget3.ogg"] = 09.60,
					["mAncientStep1.ogg"] = 00.98,
					["mAncientStep2.ogg"] = 01.09,
					["mAncientStep3.ogg"] = 01.48,
					["mAncientStep4.ogg"] = 01.24,
					["mAncientStep5.ogg"] = 01.39,
					["mAncientStep6.ogg"] = 01.51,
					["mAncientWound1.ogg"] = 02.04,
					["mAncientWound2.ogg"] = 01.93,
					["mAncientWound3.ogg"] = 02.44,
					["mAncientWoundCritical1.ogg"] = 02.70,
				},
				["AncientTreeOfWar\\"] = {
					["AncientTreeofWarAggro.ogg"] = 03.25,
					["AncientTreeofWarAttackA.ogg"] = 03.25,
					["AncientTreeofWarAttackB.ogg"] = 02.97,
					["AncientTreeofWarAttackC.ogg"] = 02.83,
					["AncientTreeofWarAttackD.ogg"] = 02.61,
					["AncientTreeofWarDeath.ogg"] = 06.87,
					["AncientTreeofWarPreAggro.ogg"] = 02.46,
					["AncientTreeofWarWoundA.ogg"] = 02.46,
					["AncientTreeofWarWoundB.ogg"] = 03.25,
					["AncientTreeofWarWoundC.ogg"] = 02.97,
					["AncientTreeofWarWoundCrit.ogg"] = 02.61,
					["AncientTreeofWarWoundD.ogg"] = 02.83,
				},
				["Anduin\\VO_"] = {
					["SW_Anduin_"] = {
						["Greeting01.ogg"] = 01.38,
						["Greeting02.ogg"] = 02.53,
						["Greeting03.ogg"] = 02.43,
						["GreetingB01.ogg"] = 01.42,
						["GreetingB02.ogg"] = 02.47,
						["GreetingB03.ogg"] = 01.15,
						["GreetingB04.ogg"] = 02.42,
					},
				},
				["AnduinWrynn\\VO_"] = {
					["5.1_"] = {
						["AFINAL_Anduin_"] = {
							["Finale_"] = {
								["01.OGG"] = 02.06,
								["02.OGG"] = 11.51,
								["04.OGG"] = 13.26,
								["04a.OGG"] = 06.45,
								["04b.OGG"] = 02.91,
							},
						},
						["HFINAL_Anduin_"] = {
							["Finale1_"] = {
								["01.OGG"] = 03.50,
								["02.OGG"] = 03.19,
							},
						},
						["PROG_Anduin_"] = {
							["Convo_"] = {
								["01.OGG"] = 03.38,
								["02.OGG"] = 00.79,
								["03.OGG"] = 02.47,
							},
							["Reunion_"] = {
								["01.OGG"] = 00.72,
								["02.OGG"] = 00.75,
								["03.OGG"] = 06.45,
								["04.OGG"] = 03.75,
								["05.OGG"] = 00.84,
								["06.OGG"] = 06.30,
								["07.OGG"] = 00.95,
								["08.OGG"] = 02.46,
							},
							["DalAfter_01.OGG"] = 02.74,
						},
					},
					["52_Anduin_"] = {
						["Legendary_"] = {
							["Forge_Intro_"] = {
								["01.OGG"] = 03.07,
								["02.OGG"] = 03.47,
								["03.OGG"] = 10.37,
								["04.OGG"] = 09.14,
							},
							["Heart_"] = {
								["01.OGG"] = 02.84,
								["02.OGG"] = 03.31,
								["03.OGG"] = 01.71,
								["04.OGG"] = 03.23,
							},
							["Intro_"] = {
								["01.OGG"] = 04.42,
								["02.OGG"] = 07.71,
								["03.OGG"] = 05.98,
								["04.OGG"] = 03.21,
								["05.OGG"] = 01.57,
							},
							["Spear_"] = {
								["01.OGG"] = 01.72,
								["02.OGG"] = 01.26,
								["03.OGG"] = 01.93,
								["04.OGG"] = 04.12,
							},
							["Flavor_01.OGG"] = 04.05,
						},
					},
					["54_"] = {
						["Kun_Lai_"] = {
							["Anduin_REDUX_"] = {
								["01.OGG"] = 02.15,
								["02.OGG"] = 04.76,
							},
						},
						["TI_ANDUIN_"] = {
							["INTRO_"] = {
								["1.OGG"] = 01.65,
								["2.OGG"] = 03.40,
								["3.OGG"] = 01.62,
								["4.OGG"] = 01.23,
								["5.OGG"] = 00.60,
							},
						},
						["ANDUIN_LEGENDARY_CELE_01.OGG"] = 02.29,
					},
					["ANDUIN_"] = {
						["CAVE_"] = {
							["01.OGG"] = 04.21,
							["02.OGG"] = 01.43,
							["03.OGG"] = 01.87,
							["04.OGG"] = 07.13,
						},
						["CLEANSE_"] = {
							["01.OGG"] = 01.08,
							["02.OGG"] = 01.46,
							["03.OGG"] = 01.52,
							["04.OGG"] = 01.63,
						},
						["SPY_QUEST_"] = {
							["B_"] = {
								["01.OGG"] = 02.73,
								["02.OGG"] = 00.85,
							},
							["D_01.OGG"] = 00.38,
						},
					},
					["Jade_Forest_"] = {
						["Anduin_"] = {
							["Decision_Anduin_"] = {
								["01.OGG"] = 02.70,
								["02.OGG"] = 05.64,
								["03.OGG"] = 04.87,
								["04.OGG"] = 01.33,
							},
							["Escape_01.OGG"] = 07.29,
						},
						["Dream_Brew_"] = {
							["Nightmare_"] = {
								["Anduin_"] = {
									["02.OGG"] = 04.57,
									["03.OGG"] = 04.05,
								},
								["Garrosh_02.OGG"] = 06.08,
							},
						},
					},
					["Krasarang_"] = {
						["Crane_Temple_"] = {
							["Anduin_"] = {
								["01.OGG"] = 00.90,
								["02.OGG"] = 02.18,
								["03.OGG"] = 01.61,
								["04.OGG"] = 02.04,
								["05.OGG"] = 03.08,
								["06.OGG"] = 00.80,
							},
						},
						["Redwing_Refuge_"] = {
							["Event_Anduin_"] = {
								["01.OGG"] = 00.72,
								["02.OGG"] = 03.37,
								["03.OGG"] = 07.07,
							},
						},
					},
					["Kun_Lai_"] = {
						["Anduin_Temple_"] = {
							["Event_"] = {
								["01.OGG"] = 03.23,
								["02.OGG"] = 03.28,
								["03.OGG"] = 09.15,
								["04.OGG"] = 12.27,
								["05.OGG"] = 02.64,
								["06.OGG"] = 03.30,
								["07.OGG"] = 04.47,
								["08.OGG"] = 06.59,
								["09.OGG"] = 07.60,
							},
						},
					},
					["Pandaria_Anduin_"] = {
						["Farewell_"] = {
							["01.OGG"] = 00.94,
							["02.OGG"] = 00.70,
							["03.OGG"] = 01.15,
							["04.OGG"] = 01.01,
						},
						["Greeting_"] = {
							["01.OGG"] = 01.51,
							["02.OGG"] = 02.10,
							["03.OGG"] = 02.23,
							["04.OGG"] = 01.90,
							["05.OGG"] = 01.29,
						},
						["Horde_Greeting_"] = {
							["01.OGG"] = 02.00,
							["02.OGG"] = 02.55,
							["03.OGG"] = 02.43,
						},
						["Pissed_"] = {
							["01.OGG"] = 02.11,
							["02.OGG"] = 01.13,
						},
					},
				},
				["Anetheron\\CAV_"] = {
					["Anath_"] = {
						["Attack01.ogg"] = 00.85,
						["Attack02.ogg"] = 00.81,
						["Attack03.ogg"] = 00.68,
						["Attack04.ogg"] = 00.69,
						["Attack05.ogg"] = 00.76,
						["CarionSwrm01.ogg"] = 03.54,
						["CarionSwrm02.ogg"] = 02.20,
						["Death01.ogg"] = 04.38,
						["Enter01.ogg"] = 07.21,
						["Infernal01.ogg"] = 03.18,
						["Infernal02.ogg"] = 03.85,
						["Slay01.ogg"] = 02.46,
						["Slay02.ogg"] = 02.19,
						["Slay03.ogg"] = 03.83,
						["Sleep01.ogg"] = 01.91,
						["Sleep02.ogg"] = 01.78,
						["Wound01.ogg"] = 00.60,
						["Wound02.ogg"] = 00.83,
						["Wound03.ogg"] = 00.80,
						["Wound04.ogg"] = 00.71,
						["WoundCrit01.ogg"] = 00.95,
						["WoundCrit02.ogg"] = 00.60,
						["WoundCrit03.ogg"] = 01.01,
					},
				},
				["Anhuur\\VO_"] = {
					["HO_Anhuur_"] = {
						["Attack01.ogg"] = 00.72,
						["Attack02.ogg"] = 00.72,
						["Attack03.ogg"] = 00.69,
						["Attack04.ogg"] = 00.69,
						["Attack05.ogg"] = 00.79,
						["Attack06.ogg"] = 00.88,
						["Attack07.ogg"] = 00.97,
						["Attack08.ogg"] = 00.75,
						["Attack09.ogg"] = 00.89,
						["Attack10.ogg"] = 01.01,
						["AttackCrit01.ogg"] = 01.46,
						["AttackCrit02.ogg"] = 01.61,
						["AttackCrit03.ogg"] = 01.64,
						["AttackCrit04.ogg"] = 02.00,
						["Death01.ogg"] = 03.04,
						["Engage01.ogg"] = 05.38,
						["Event01.ogg"] = 05.01,
						["Slay01.ogg"] = 02.60,
						["Slay02.ogg"] = 03.72,
						["Wound01.ogg"] = 00.63,
						["Wound02.ogg"] = 00.62,
						["Wound03.ogg"] = 00.44,
						["Wound04.ogg"] = 00.79,
						["Wound05.ogg"] = 00.73,
						["Wound06.ogg"] = 00.93,
						["Wound07.ogg"] = 00.75,
						["Wound08.ogg"] = 00.89,
						["Wound09.ogg"] = 01.06,
						["WoundCrit01.ogg"] = 01.71,
						["WoundCrit02.ogg"] = 01.38,
						["WoundCrit03.ogg"] = 02.18,
						["WoundCrit04.ogg"] = 02.20,
						["WoundCrit05.ogg"] = 01.49,
					},
				},
				["Anomalus\\"] = {
					["TN_Anom_"] = {
						["Attack01.ogg"] = 02.04,
						["Attack02.ogg"] = 01.75,
						["Attack03.ogg"] = 01.48,
						["Attack04.ogg"] = 01.69,
						["Attack05.ogg"] = 01.45,
						["Attack06.ogg"] = 01.89,
						["Attack07.ogg"] = 01.32,
						["Attack08.ogg"] = 01.51,
						["Wound01.ogg"] = 01.13,
						["Wound02.ogg"] = 00.94,
						["Wound03.ogg"] = 01.07,
						["Wound04.ogg"] = 00.88,
						["Wound05.ogg"] = 00.85,
						["WoundCrit01.ogg"] = 00.97,
						["WoundCrit02.ogg"] = 00.90,
						["WoundCrit03.ogg"] = 00.90,
						["WoundCrit04.ogg"] = 01.10,
						["WoundCrit05.ogg"] = 01.16,
						["WoundCrit06.ogg"] = 01.00,
					},
					["AnomalusAggro.ogg"] = 05.12,
					["AnomalusDeath.ogg"] = 03.38,
					["AnomalusKill.ogg"] = 06.99,
					["AnomalusRift.ogg"] = 05.47,
					["AnomalusShield.ogg"] = 04.76,
				},
				["Anraphet\\VO_"] = {
					["HO_Anraphet_"] = {
						["Attack01.ogg"] = 01.34,
						["Attack02.ogg"] = 01.47,
						["Attack03.ogg"] = 01.81,
						["Attack04.ogg"] = 01.85,
						["Attack05.ogg"] = 01.62,
						["Attack06.ogg"] = 01.83,
						["Attack07.ogg"] = 01.90,
						["Attack08.ogg"] = 01.92,
						["Attack09.ogg"] = 02.01,
						["AttackCritical01.ogg"] = 01.98,
						["AttackCritical02.ogg"] = 01.97,
						["AttackCritical03.ogg"] = 02.09,
						["AttackCritical04.ogg"] = 01.97,
						["AttackCritical05.ogg"] = 02.00,
						["Death01.ogg"] = 03.21,
						["Engage01.ogg"] = 04.34,
						["Intro01.ogg"] = 21.95,
						["Slay01.ogg"] = 02.29,
						["Slay02.ogg"] = 02.50,
						["Special01.ogg"] = 05.38,
						["Special02.ogg"] = 06.76,
						["Wound01.ogg"] = 01.45,
						["Wound02.ogg"] = 01.78,
						["Wound03.ogg"] = 01.53,
						["Wound04.ogg"] = 01.61,
						["Wound05.ogg"] = 01.74,
						["Wound06.ogg"] = 01.56,
						["Wound07.ogg"] = 01.83,
						["Wound08.ogg"] = 01.90,
						["WoundCritical01.ogg"] = 01.70,
						["WoundCritical02.ogg"] = 01.85,
						["WoundCritical03.ogg"] = 01.84,
					},
				},
				["AnuBarak\\"] = {
					["AN_Anub_"] = {
						["Attack01.ogg"] = 00.76,
						["Attack02.ogg"] = 00.94,
						["Attack03.ogg"] = 01.01,
						["Attack04.ogg"] = 00.98,
						["Attack05.ogg"] = 01.34,
						["Attack06.ogg"] = 01.42,
						["Roar01.ogg"] = 03.55,
						["Wound01.ogg"] = 00.70,
						["Wound02.ogg"] = 00.45,
						["Wound03.ogg"] = 00.80,
						["Wound04.ogg"] = 00.65,
						["Wound05.ogg"] = 00.68,
						["WoundCrit01.ogg"] = 00.86,
						["WoundCrit02.ogg"] = 01.19,
						["WoundCrit03.ogg"] = 01.32,
						["WoundCrit04.ogg"] = 00.94,
						["WoundCrit05.ogg"] = 01.29,
						["WoundCrit06.ogg"] = 00.98,
					},
					["CR_Anubarak_"] = {
						["30Percent01.ogg"] = 02.64,
						["Aggro01.ogg"] = 03.99,
						["AttackHeavy01.ogg"] = 00.95,
						["AttackHeavy02.ogg"] = 01.73,
						["AttackHeavy03.ogg"] = 01.57,
						["AttackLight01.ogg"] = 00.69,
						["AttackLight02.ogg"] = 00.69,
						["AttackLight03.ogg"] = 00.96,
						["AttackMedium01.ogg"] = 01.24,
						["AttackMedium02.ogg"] = 00.65,
						["AttackMedium03.ogg"] = 01.00,
						["Beserk01.ogg"] = 03.58,
						["Beserk02.ogg"] = 03.34,
						["Beserk03.ogg"] = 03.49,
						["Death01.ogg"] = 04.11,
						["Intro01.ogg"] = 07.73,
						["Slay01.ogg"] = 02.76,
						["Slay02.ogg"] = 03.87,
						["Submerge01.ogg"] = 06.70,
						["WoundCritical01.ogg"] = 01.41,
						["WoundCritical02.ogg"] = 01.21,
						["WoundCritical03.ogg"] = 01.73,
						["WoundHeavy01.ogg"] = 00.98,
						["WoundHeavy02.ogg"] = 01.04,
						["WoundHeavy03.ogg"] = 00.95,
						["WoundLight01.ogg"] = 00.65,
						["WoundLight02.ogg"] = 00.69,
						["WoundLight03.ogg"] = 00.65,
						["WoundMedium01.ogg"] = 00.86,
						["WoundMedium02.ogg"] = 00.83,
						["WoundMedium03.ogg"] = 00.94,
					},
					["ANUBARAKAGGRO.ogg"] = 02.74,
					["ANUBARAKDEATH.ogg"] = 07.75,
					["ANUBARAKINTRO.ogg"] = 17.99,
					["ANUBARAKKILL01.ogg"] = 04.14,
					["ANUBARAKKILL02.ogg"] = 02.24,
					["ANUBARAKKILL03.ogg"] = 04.15,
					["ANUBARAKLOCUST01.ogg"] = 03.85,
					["ANUBARAKLOCUST02.ogg"] = 04.47,
					["ANUBARAKLOCUST03.ogg"] = 02.46,
					["ANUBARAKSUBMERGE01.ogg"] = 03.20,
					["ANUBARAKSUBMERGE02.ogg"] = 05.69,
				},
				["AnubarCrusher\\"] = {
					["AN_Crusher_"] = {
						["Attack01.ogg"] = 00.48,
						["Attack02.ogg"] = 00.75,
						["Attack03.ogg"] = 00.57,
						["Attack04.ogg"] = 00.73,
						["Attack05.ogg"] = 00.73,
						["Attack06.ogg"] = 00.75,
						["Wound01.ogg"] = 00.52,
						["Wound02.ogg"] = 00.47,
						["Wound03.ogg"] = 00.51,
						["Wound04.ogg"] = 00.79,
						["WoundCrit01.ogg"] = 00.92,
						["WoundCrit02.ogg"] = 00.81,
						["WoundCrit03.ogg"] = 01.28,
					},
					["CrusherAggro.ogg"] = 05.38,
					["CrusherAttack.ogg"] = 05.65,
				},
				["Anubrekhan\\ANU_"] = {
					["NAXX_"] = {
						["AGGRO01.ogg"] = 02.25,
						["AGGRO02.ogg"] = 02.73,
						["AGGRO03.ogg"] = 04.20,
						["GREET.ogg"] = 05.61,
						["SLAY.ogg"] = 04.75,
						["TAUNT01.ogg"] = 12.52,
						["TAUNT02.ogg"] = 10.40,
						["TAUNT03.ogg"] = 09.57,
						["TAUNT04.ogg"] = 11.46,
					},
				},
				["Anusibath\\"] = {
					["AnusibathAggro.ogg"] = 02.32,
					["AnusibathAttackA.ogg"] = 01.86,
					["AnusibathAttackB.ogg"] = 01.40,
					["AnusibathAttackC.ogg"] = 01.95,
					["AnusibathDeath.ogg"] = 04.04,
					["AnusibathPreAggro.ogg"] = 02.67,
					["AnusibathWoundA.ogg"] = 01.60,
					["AnusibathWoundB.ogg"] = 01.48,
					["AnusibathWoundC.ogg"] = 01.72,
					["AnusibathWoundCrit.ogg"] = 01.72,
				},
				["Anveena\\"] = {
					["ANVEENAAWAKE01.ogg"] = 02.33,
					["ANVEENASACRIFICE.ogg"] = 05.00,
					["ANVEENAZOMBIE01.ogg"] = 02.55,
					["ANVEENAZOMBIE02.ogg"] = 04.32,
				},
				["Arakkoa\\"] = {
					["ArakkoaAttackA.ogg"] = 00.89,
					["ArakkoaAttackB.ogg"] = 00.94,
					["ArakkoaAttackC.ogg"] = 00.92,
					["ArakkoaAttackD.ogg"] = 00.74,
					["ArakkoaAttackE.ogg"] = 00.99,
					["ArakkoaDeath.ogg"] = 01.34,
					["ArakkoaPreAggro.ogg"] = 00.61,
					["ArakkoaWoundA.ogg"] = 00.84,
					["ArakkoaWoundB.ogg"] = 00.89,
					["ArakkoaWoundC.ogg"] = 00.83,
					["ArakkoaWoundCrit.ogg"] = 01.27,
					["ArakkoaWoundD.ogg"] = 00.81,
				},
				["Aranas\\VO_"] = {
					["QE_Aranas_"] = {
						["Event01.ogg"] = 09.87,
						["Greeting01.ogg"] = 00.99,
						["Greeting02.ogg"] = 02.59,
						["Rescue01.ogg"] = 01.19,
						["Rescue02.ogg"] = 03.10,
					},
				},
				["ArcaneGolem\\"] = {
					["ArcaneGolemAggro.ogg"] = 02.77,
					["ArcaneGolemAttackA.ogg"] = 02.81,
					["ArcaneGolemAttackB.ogg"] = 03.06,
					["ArcaneGolemAttackC.ogg"] = 02.63,
					["ArcaneGolemAttackD.ogg"] = 03.05,
					["ArcaneGolemDeath.ogg"] = 03.84,
					["ArcaneGolemLoop.ogg"] = 04.00,
					["ArcaneGolemPreAggro.ogg"] = 02.49,
					["ArcaneGolemWoundA.ogg"] = 02.88,
					["ArcaneGolemWoundB.ogg"] = 03.09,
					["ArcaneGolemWoundC.ogg"] = 03.09,
					["ArcaneGolemWoundCrit.ogg"] = 02.91,
				},
				["ArcaneGolemBroken\\"] = {
					["ArcaneGolemSmall_"] = {
						["Aggro.ogg"] = 02.48,
						["Attack01.ogg"] = 02.35,
						["Attack02.ogg"] = 02.34,
						["Attack03.ogg"] = 01.98,
						["Attack04.ogg"] = 02.75,
						["Death.ogg"] = 03.19,
						["PreAggro.ogg"] = 01.82,
						["Wound01.ogg"] = 01.81,
						["Wound02.ogg"] = 02.94,
						["Wound03.ogg"] = 02.65,
						["WoundCrit.ogg"] = 02.46,
					},
					["ArcaneGolemBrokenLoop.ogg"] = 04.00,
				},
				["ArcaneTitan\\"] = {
					["ArcaneTitan_"] = {
						["Aggro_"] = {
							["01.ogg"] = 01.97,
							["02.ogg"] = 03.18,
							["03.ogg"] = 02.71,
							["04.ogg"] = 02.40,
							["05.ogg"] = 01.93,
							["06.ogg"] = 02.06,
							["07.ogg"] = 02.39,
							["08.ogg"] = 02.25,
							["09.ogg"] = 01.57,
							["10.ogg"] = 01.79,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 01.74,
							["02.ogg"] = 01.69,
							["03.ogg"] = 02.31,
							["04.ogg"] = 01.74,
							["05.ogg"] = 01.90,
						},
						["Attack_"] = {
							["01.ogg"] = 01.67,
							["02.ogg"] = 01.42,
							["03.ogg"] = 01.34,
							["04.ogg"] = 01.20,
							["05.ogg"] = 01.61,
							["06.ogg"] = 02.21,
							["07.ogg"] = 01.17,
							["08.ogg"] = 01.09,
							["09.ogg"] = 01.47,
							["10.ogg"] = 01.47,
						},
						["Death_"] = {
							["01.ogg"] = 03.28,
							["02.ogg"] = 03.16,
							["03.ogg"] = 02.72,
							["04.ogg"] = 03.36,
							["05.ogg"] = 02.52,
							["06.ogg"] = 02.87,
							["07.ogg"] = 02.70,
							["08.ogg"] = 03.19,
							["09.ogg"] = 03.39,
							["10.ogg"] = 03.06,
						},
						["PreAggro_"] = {
							["01.ogg"] = 01.35,
							["02.ogg"] = 01.45,
							["03.ogg"] = 00.96,
							["04.ogg"] = 01.04,
							["05.ogg"] = 00.87,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.71,
							["02.ogg"] = 02.05,
							["03.ogg"] = 01.71,
							["04.ogg"] = 01.91,
							["05.ogg"] = 01.35,
						},
						["Wound_"] = {
							["01.ogg"] = 00.97,
							["02.ogg"] = 01.00,
							["03.ogg"] = 01.12,
							["04.ogg"] = 01.15,
							["05.ogg"] = 00.97,
							["06.ogg"] = 00.98,
							["07.ogg"] = 00.93,
							["08.ogg"] = 01.15,
							["09.ogg"] = 01.02,
							["10.ogg"] = 01.09,
						},
					},
					["ArcaneTitanAttackA.ogg"] = 02.20,
					["ArcaneTitanAttackB.ogg"] = 02.13,
					["ArcaneTitanAttackC.ogg"] = 02.20,
					["ArcaneTitanAttackD.ogg"] = 02.07,
					["ArcaneTitanAttackE.ogg"] = 02.20,
					["ArcaneTitanDeath.ogg"] = 05.00,
					["ArcaneTitanWoundA.ogg"] = 01.47,
					["ArcaneTitanWoundB.ogg"] = 01.27,
					["ArcaneTitanWoundC.ogg"] = 01.73,
					["ArcaneTitanWoundCrit.ogg"] = 02.87,
					["ArcaneTitanWoundD.ogg"] = 01.27,
				},
				["ArcanistDoan\\"] = {
					["ArcanistDoanAggro01.ogg"] = 02.80,
					["ArcanistDoanSpecialAE01.ogg"] = 02.05,
				},
				["Archaedas\\"] = {
					["ArchaedasAggroYell01.ogg"] = 07.83,
					["ArchaedasSlay01.ogg"] = 02.65,
					["ArchaedasSummon01.ogg"] = 04.46,
					["ArchaedasSummon02.ogg"] = 05.16,
				},
				["ArchbishopBenedictus\\"] = {
					["ArchbishopBenedictusAggro01.ogg"] = 03.16,
					["ArchbishopBenedictusGreeting01.ogg"] = 03.43,
					["ArchbishopBenedictusGreeting02.ogg"] = 02.44,
					["ArchbishopBenedictusGreeting03.ogg"] = 01.21,
					["ArchbishopBenedictusGreeting04.ogg"] = 01.52,
				},
				["Archer\\"] = {
					["ArcherReady1.ogg"] = 01.16,
					["ArcherWhat1.ogg"] = 00.95,
					["ArcherYes1.ogg"] = 01.10,
					["ArcherYes3.ogg"] = 00.87,
					["ArcherYes4.ogg"] = 01.06,
					["ArcherYesAttack1.ogg"] = 01.01,
					["ArcherYesAttack2.ogg"] = 00.73,
					["ArcherYesAttack3.ogg"] = 01.66,
					["ArcherYesAttack4.ogg"] = 01.06,
				},
				["Archimonde\\CAV_"] = {
					["Arch_"] = {
						["Aggro01.ogg"] = 04.81,
						["Attack01.ogg"] = 01.84,
						["Attack02.ogg"] = 01.83,
						["Attack03.ogg"] = 02.58,
						["Attack04.ogg"] = 02.73,
						["Burn01.ogg"] = 04.20,
						["Burn02.ogg"] = 03.26,
						["Charm01.ogg"] = 03.68,
						["Charm02.ogg"] = 03.85,
						["Death01.ogg"] = 07.70,
						["Intro01.ogg"] = 14.94,
						["Knockup01.ogg"] = 02.02,
						["Knockup02.ogg"] = 03.19,
						["PlyrLose01.ogg"] = 12.02,
						["Slay01.ogg"] = 04.81,
						["Slay02.ogg"] = 03.68,
						["Slay03.ogg"] = 03.40,
						["Wound01.ogg"] = 01.85,
						["Wound02.ogg"] = 01.96,
						["Wound03.ogg"] = 01.90,
						["WoundCrit01.ogg"] = 02.66,
						["WoundCrit02.ogg"] = 02.30,
						["WoundCrit03.ogg"] = 02.00,
					},
				},
				["ARCHIVUMSYSTEM\\UR_"] = {
					["Archivum_"] = {
						["FreyaAnalysis01.ogg"] = 02.97,
						["FreyaAnalysis02.ogg"] = 03.86,
						["FreyaAnalysis03.ogg"] = 07.33,
						["FreyaAnalysis04.ogg"] = 05.41,
						["FreyaAnalysis05.ogg"] = 05.21,
						["FreyaAnalysis06.ogg"] = 08.90,
						["FreyaAnalysis07.ogg"] = 13.06,
						["HodirAnalysis01.ogg"] = 03.36,
						["HodirAnalysis02.ogg"] = 04.43,
						["HodirAnalysis03.ogg"] = 08.07,
						["HodirAnalysis04.ogg"] = 06.32,
						["HodirAnalysis05.ogg"] = 04.11,
						["MimironAnalysis01.ogg"] = 03.19,
						["MimironAnalysis02.ogg"] = 07.60,
						["MimironAnalysis03.ogg"] = 06.46,
						["MimironAnalysis04.ogg"] = 06.72,
						["MimironSD00.ogg"] = 03.98,
						["MimironSD01.ogg"] = 03.38,
						["MimironSD02.ogg"] = 03.52,
						["MimironSD03.ogg"] = 03.26,
						["MimironSD04.ogg"] = 03.28,
						["MimironSD05.ogg"] = 03.41,
						["MimironSD06.ogg"] = 03.33,
						["MimironSD07.ogg"] = 03.45,
						["MimironSD08.ogg"] = 03.17,
						["MimironSD09.ogg"] = 03.43,
						["MimironSD10.ogg"] = 03.43,
						["MimironSDEnd01.ogg"] = 05.97,
						["MimironSDStart01.ogg"] = 02.47,
						["Planetarium01.ogg"] = 06.24,
						["Planetarium02.ogg"] = 14.70,
						["Planetarium03.ogg"] = 02.69,
						["Planetarium04.ogg"] = 06.58,
						["Planetarium05.ogg"] = 05.94,
						["Planetarium06.ogg"] = 09.76,
						["System01.ogg"] = 03.27,
						["System02.ogg"] = 04.94,
						["System03.ogg"] = 07.82,
						["System04.ogg"] = 06.04,
						["System05.ogg"] = 23.64,
						["System06.ogg"] = 13.40,
						["System07.ogg"] = 07.41,
						["System08.ogg"] = 09.56,
						["System09.ogg"] = 02.70,
						["System10.ogg"] = 01.69,
						["ThorimAnalysis01.ogg"] = 03.27,
						["ThorimAnalysis02.ogg"] = 06.23,
						["ThorimAnalysis03.ogg"] = 05.70,
						["ThorimAnalysis04.ogg"] = 15.91,
						["ValanyrAnalysis01.ogg"] = 02.27,
						["ValanyrAnalysis02.ogg"] = 04.00,
						["ValanyrAnalysis03.ogg"] = 10.66,
						["ValanyrAnalysis04.ogg"] = 08.01,
						["ValanyrAnalysis05.ogg"] = 09.63,
						["ValanyrAnalysis06.ogg"] = 14.13,
					},
				},
				["ArchmageSol\\VO_"] = {
					["60_"] = {
						["ArchmageSol_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.72,
								["02.ogg"] = 00.86,
								["03.ogg"] = 02.08,
								["04.ogg"] = 01.63,
								["05.ogg"] = 01.26,
							},
							["Attack_"] = {
								["01.ogg"] = 00.28,
								["02.ogg"] = 00.33,
								["03.ogg"] = 00.30,
								["04.ogg"] = 00.40,
								["05.ogg"] = 00.40,
								["06.ogg"] = 00.43,
								["07.ogg"] = 00.36,
								["08.ogg"] = 00.36,
								["09.ogg"] = 00.47,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.55,
								["02.ogg"] = 01.00,
								["03.ogg"] = 01.03,
								["04.ogg"] = 01.65,
								["05.ogg"] = 01.42,
								["06.ogg"] = 01.44,
							},
							["Wound_"] = {
								["01.ogg"] = 00.31,
								["010.ogg"] = 00.54,
								["02.ogg"] = 00.36,
								["03.ogg"] = 00.29,
								["04.ogg"] = 00.40,
								["05.ogg"] = 00.26,
								["06.ogg"] = 00.34,
								["07.ogg"] = 00.32,
								["08.ogg"] = 00.33,
								["09.ogg"] = 00.52,
							},
						},
						["SD_KIRINTORMAGE_"] = {
							["AGGRO.ogg"] = 03.40,
							["DEATH.ogg"] = 05.25,
							["INTRO.ogg"] = 04.94,
							["KILL01.ogg"] = 02.23,
							["KILL02.ogg"] = 02.26,
							["SPELL01.ogg"] = 04.19,
							["SPELL02.ogg"] = 02.36,
							["SPELL03.ogg"] = 02.38,
						},
					},
				},
				["ARCURION\\VO_"] = {
					["ARCURION_"] = {
						["Attack01.OGG"] = 02.73,
						["Attack02.OGG"] = 02.45,
						["Attack03.OGG"] = 02.59,
						["Attack04.OGG"] = 02.11,
						["Attack05.OGG"] = 02.94,
						["Attack06.OGG"] = 02.20,
						["Attack07.OGG"] = 02.37,
						["Attack08.OGG"] = 02.71,
						["AttackCrit01.OGG"] = 03.12,
						["AttackCrit02.OGG"] = 02.85,
						["AttackCrit03.OGG"] = 02.65,
						["AttackCrit04.OGG"] = 02.78,
						["AttackCrit05.OGG"] = 02.60,
						["Wound01.OGG"] = 02.36,
						["Wound02.OGG"] = 02.43,
						["Wound03.OGG"] = 02.04,
						["Wound04.OGG"] = 02.31,
						["Wound05.OGG"] = 02.45,
						["Wound06.OGG"] = 01.87,
						["Wound07.OGG"] = 01.97,
						["Wound08.OGG"] = 01.94,
						["WoundCrit01.OGG"] = 03.27,
						["WoundCrit02.OGG"] = 02.53,
						["WoundCrit03.OGG"] = 02.53,
						["WoundCrit04.OGG"] = 02.98,
						["WoundCrit05.OGG"] = 02.63,
					},
					["HOT_ARCURION_"] = {
						["EVENT_"] = {
							["01.OGG"] = 21.76,
							["02.OGG"] = 12.11,
							["03.OGG"] = 09.21,
							["04.OGG"] = 23.20,
						},
						["INTRO_"] = {
							["01.OGG"] = 13.96,
							["02.OGG"] = 14.41,
						},
						["SLAY_"] = {
							["01.OGG"] = 07.09,
							["02.OGG"] = 08.93,
							["03.OGG"] = 10.68,
						},
						["SPELL_"] = {
							["01.OGG"] = 06.16,
							["02.OGG"] = 07.92,
							["03.OGG"] = 09.56,
							["04.OGG"] = 05.53,
						},
						["AGGRO_01.OGG"] = 13.82,
						["DEATH_01.OGG"] = 10.34,
					},
				},
				["ArgentGruntling\\PET_"] = {
					["ArgentGruntling_Clickable_"] = {
						["01.ogg"] = 01.14,
						["02.ogg"] = 00.88,
						["03.ogg"] = 00.85,
						["04.ogg"] = 01.06,
						["05.ogg"] = 01.59,
						["06.ogg"] = 00.81,
						["07.ogg"] = 01.32,
						["08.ogg"] = 01.17,
						["09.ogg"] = 00.89,
						["10.ogg"] = 01.60,
					},
				},
				["ArgentSquire\\PET_"] = {
					["ArgentSquire_"] = {
						["Clickable01.ogg"] = 02.27,
						["Clickable02.ogg"] = 01.54,
						["Clickable03.ogg"] = 02.45,
						["Clickable04.ogg"] = 02.09,
						["Clickable05.ogg"] = 02.13,
						["Clickable06.ogg"] = 02.01,
						["Clickable07.ogg"] = 03.05,
						["Clickable08.ogg"] = 03.59,
						["Clickable09.ogg"] = 01.79,
						["Clickable10.ogg"] = 02.18,
					},
				},
				["Ariok\\VO_"] = {
					["60_"] = {
						["ARIOK_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.15,
								["02.ogg"] = 01.03,
								["03.ogg"] = 01.05,
								["04.ogg"] = 00.98,
								["05.ogg"] = 01.01,
							},
							["Attack_"] = {
								["01.ogg"] = 00.38,
								["010.ogg"] = 00.49,
								["02.ogg"] = 00.38,
								["03.ogg"] = 00.34,
								["04.ogg"] = 00.45,
								["05.ogg"] = 00.58,
								["06.ogg"] = 00.57,
								["07.ogg"] = 00.46,
								["08.ogg"] = 00.48,
								["09.ogg"] = 00.45,
							},
							["Death_"] = {
								["01.ogg"] = 03.42,
								["02.ogg"] = 03.90,
								["03.ogg"] = 04.49,
								["04.ogg"] = 02.78,
								["05.ogg"] = 01.16,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 00.86,
								["02.ogg"] = 00.84,
								["03.ogg"] = 01.07,
								["04.ogg"] = 01.53,
								["05.ogg"] = 01.16,
							},
							["Wound_"] = {
								["01.ogg"] = 00.29,
								["010.ogg"] = 00.33,
								["02.ogg"] = 00.43,
								["03.ogg"] = 00.33,
								["04.ogg"] = 00.26,
								["05.ogg"] = 00.34,
								["06.ogg"] = 00.33,
								["07.ogg"] = 00.51,
								["08.ogg"] = 00.50,
								["09.ogg"] = 00.38,
							},
						},
						["TAN_ARIOK_"] = {
							["ALTAR_"] = {
								["01.ogg"] = 04.41,
								["02.ogg"] = 06.89,
								["03.ogg"] = 05.07,
								["04.ogg"] = 03.80,
								["05.ogg"] = 05.69,
								["06.ogg"] = 03.48,
								["07.ogg"] = 06.73,
								["08.ogg"] = 00.64,
							},
							["HOLLOW_"] = {
								["01.ogg"] = 04.06,
								["02.ogg"] = 03.36,
								["03.ogg"] = 03.46,
								["04.ogg"] = 11.59,
							},
						},
					},
				},
				["Arion\\VO_"] = {
					["BT_Arion_"] = {
						["Attack01.ogg"] = 01.10,
						["Attack02.ogg"] = 01.10,
						["Attack03.ogg"] = 00.93,
						["Attack04.ogg"] = 01.09,
						["Attack05.ogg"] = 01.14,
						["Attack06.ogg"] = 00.92,
						["Attack07.ogg"] = 00.89,
						["Attack08.ogg"] = 01.14,
						["Attack09.ogg"] = 00.92,
						["Attack10.ogg"] = 00.88,
						["AttackCrit01.ogg"] = 01.22,
						["AttackCrit02.ogg"] = 01.96,
						["AttackCrit03.ogg"] = 01.57,
						["AttackCrit04.ogg"] = 01.73,
						["AttackCrit05.ogg"] = 01.55,
						["Event01.ogg"] = 04.29,
						["Event02.ogg"] = 03.50,
						["Event03.ogg"] = 05.42,
						["Event04.ogg"] = 03.87,
						["Event05.ogg"] = 06.94,
						["Wound01.ogg"] = 00.94,
						["Wound02.ogg"] = 01.01,
						["Wound03.ogg"] = 00.87,
						["Wound04.ogg"] = 00.87,
						["Wound05.ogg"] = 00.87,
						["Wound06.ogg"] = 00.94,
						["Wound07.ogg"] = 01.00,
						["Wound08.ogg"] = 00.86,
						["Wound09.ogg"] = 00.98,
						["Wound10.ogg"] = 01.02,
						["WoundCrit01.ogg"] = 01.17,
						["WoundCrit02.ogg"] = 00.93,
						["WoundCrit03.ogg"] = 01.29,
						["WoundCrit04.ogg"] = 01.23,
						["WoundCrit05.ogg"] = 01.22,
						["WoundCrit06.ogg"] = 01.24,
						["WoundCrit07.ogg"] = 01.30,
						["WoundCrit08.ogg"] = 01.30,
					},
				},
				["Arkeddon\\VO_"] = {
					["60_"] = {
						["ARKEDDON_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 02.14,
								["02.ogg"] = 01.06,
								["03.ogg"] = 02.74,
								["04.ogg"] = 01.84,
								["05.ogg"] = 02.88,
							},
							["Attack_"] = {
								["01.ogg"] = 00.89,
								["010.ogg"] = 00.81,
								["02.ogg"] = 00.45,
								["03.ogg"] = 00.34,
								["04.ogg"] = 00.70,
								["05.ogg"] = 00.82,
								["06.ogg"] = 00.55,
								["07.ogg"] = 00.55,
								["08.ogg"] = 00.64,
								["09.ogg"] = 01.08,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 02.09,
								["02.ogg"] = 01.35,
								["03.ogg"] = 01.25,
								["04.ogg"] = 01.35,
								["05.ogg"] = 01.67,
							},
							["Wound_"] = {
								["01.ogg"] = 00.65,
								["010.ogg"] = 01.07,
								["02.ogg"] = 00.82,
								["03.ogg"] = 00.78,
								["04.ogg"] = 00.73,
								["05.ogg"] = 00.78,
								["06.ogg"] = 00.75,
								["07.ogg"] = 00.55,
								["08.ogg"] = 00.61,
								["09.ogg"] = 00.82,
							},
						},
						["SMV_OVERLOOK_"] = {
							["ARKEDDON_"] = {
								["01.ogg"] = 03.40,
								["02.ogg"] = 06.45,
								["03.ogg"] = 04.61,
								["04.ogg"] = 05.74,
							},
						},
					},
				},
				["ARMADILLO\\Mon_"] = {
					["Armadillo_"] = {
						["Aggro01.OGG"] = 01.19,
						["Aggro02.OGG"] = 01.01,
						["Aggro03.OGG"] = 01.18,
						["Aggro04.OGG"] = 01.02,
						["Aggro05.OGG"] = 00.71,
						["Attack01.OGG"] = 01.19,
						["Attack02.OGG"] = 00.90,
						["Attack03.OGG"] = 00.87,
						["Attack04.OGG"] = 00.65,
						["Attack05.OGG"] = 00.54,
						["Attack06.OGG"] = 00.83,
						["Attack07.OGG"] = 00.65,
						["Attack08.OGG"] = 01.08,
						["Attack09.OGG"] = 00.72,
						["Attack10.OGG"] = 00.55,
						["AttackCrit01.OGG"] = 00.70,
						["AttackCrit02.OGG"] = 01.01,
						["AttackCrit03.OGG"] = 00.60,
						["AttackCrit04.OGG"] = 01.17,
						["AttackCrit05.OGG"] = 01.02,
						["Death01.OGG"] = 01.19,
						["Death02.OGG"] = 00.86,
						["Death03.OGG"] = 01.12,
						["Death04.OGG"] = 00.96,
						["Death05.OGG"] = 00.93,
						["PreAggro01.OGG"] = 00.44,
						["PreAggro02.OGG"] = 00.41,
						["PreAggro03.OGG"] = 00.35,
						["PreAggro04.OGG"] = 00.45,
						["PreAggro05.OGG"] = 00.51,
						["Wound01.OGG"] = 00.70,
						["Wound02.OGG"] = 00.64,
						["Wound03.OGG"] = 00.72,
						["Wound04.OGG"] = 00.73,
						["Wound05.OGG"] = 00.76,
						["Wound06.OGG"] = 00.84,
						["Wound07.OGG"] = 00.72,
						["Wound08.OGG"] = 00.85,
						["Wound09.OGG"] = 00.83,
						["Wound10.OGG"] = 00.77,
						["WoundCrit01.OGG"] = 00.94,
						["WoundCrit02.OGG"] = 00.82,
						["WoundCrit03.OGG"] = 00.97,
						["WoundCrit04.OGG"] = 00.71,
						["WoundCrit05.OGG"] = 00.81,
					},
				},
				["ArmsmasterHarlan\\VO_"] = {
					["SH_ARMSMASTER_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.00,
							["02.OGG"] = 00.79,
							["03.OGG"] = 00.56,
							["04.OGG"] = 00.97,
							["05.OGG"] = 01.01,
						},
						["Attack_"] = {
							["01.OGG"] = 00.30,
							["02.OGG"] = 00.29,
							["03.OGG"] = 00.34,
							["04.OGG"] = 00.27,
							["05.OGG"] = 00.27,
							["06.OGG"] = 00.35,
							["07.OGG"] = 00.32,
							["08.OGG"] = 00.31,
						},
						["SLAY_"] = {
							["01.OGG"] = 01.19,
							["02.OGG"] = 02.40,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.53,
							["02.OGG"] = 01.39,
							["03.OGG"] = 01.24,
							["04.OGG"] = 00.86,
							["05.OGG"] = 00.90,
						},
						["Wound_"] = {
							["01.OGG"] = 00.30,
							["02.OGG"] = 00.28,
							["03.OGG"] = 00.26,
							["04.OGG"] = 00.24,
							["05.OGG"] = 00.28,
							["06.OGG"] = 00.30,
							["07.OGG"] = 00.36,
							["08.OGG"] = 00.36,
							["09.OGG"] = 00.30,
						},
						["AGGRO_01.OGG"] = 01.83,
						["DEATH_01.OGG"] = 04.38,
						["INTRO_01.OGG"] = 03.86,
					},
				},
				["Arnath\\IC_"] = {
					["Arnath_"] = {
						["Attack01.ogg"] = 01.15,
						["Attack02.ogg"] = 01.15,
						["Attack03.ogg"] = 01.10,
						["Attack04.ogg"] = 01.31,
						["Attack05.ogg"] = 01.21,
						["Attack06.ogg"] = 01.48,
						["Attack07.ogg"] = 00.71,
						["Attack08.ogg"] = 00.72,
						["Attack09.ogg"] = 00.95,
						["Attack10.ogg"] = 01.21,
						["Event01.ogg"] = 04.78,
						["Event02.ogg"] = 05.19,
						["Event03.ogg"] = 04.30,
						["Event04.ogg"] = 02.76,
						["Event05.ogg"] = 06.04,
						["Survived01.ogg"] = 05.12,
						["Wound01.ogg"] = 00.63,
						["Wound02.ogg"] = 00.46,
						["Wound03.ogg"] = 00.91,
						["Wound04.ogg"] = 00.87,
						["Wound05.ogg"] = 01.04,
						["Wound06.ogg"] = 00.75,
						["WoundCrit01.ogg"] = 01.20,
						["WoundCrit02.ogg"] = 01.47,
						["WoundCrit03.ogg"] = 01.00,
						["WoundCrit04.ogg"] = 01.15,
						["WoundCrit05.ogg"] = 01.06,
						["WoundCrit06.ogg"] = 00.94,
					},
				},
				["Arnokk\\VO_"] = {
					["60_"] = {
						["ARNOKK_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.51,
								["02.ogg"] = 01.89,
								["03.ogg"] = 01.54,
								["04.ogg"] = 02.08,
								["05.ogg"] = 02.40,
							},
							["Attack_"] = {
								["01.ogg"] = 00.72,
								["010.ogg"] = 00.66,
								["02.ogg"] = 00.49,
								["03.ogg"] = 00.47,
								["04.ogg"] = 00.63,
								["05.ogg"] = 00.68,
								["06.ogg"] = 00.61,
								["07.ogg"] = 00.66,
								["08.ogg"] = 00.72,
								["09.ogg"] = 00.46,
							},
							["Death_"] = {
								["01.ogg"] = 03.15,
								["02.ogg"] = 03.93,
								["03.ogg"] = 02.20,
								["04.ogg"] = 01.89,
								["05.ogg"] = 01.88,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.36,
								["02.ogg"] = 01.56,
								["03.ogg"] = 01.57,
								["04.ogg"] = 01.65,
								["05.ogg"] = 01.28,
							},
							["Wound_"] = {
								["01.ogg"] = 00.60,
								["010.ogg"] = 00.95,
								["02.ogg"] = 00.75,
								["03.ogg"] = 00.82,
								["04.ogg"] = 00.92,
								["05.ogg"] = 00.50,
								["06.ogg"] = 00.44,
								["07.ogg"] = 00.83,
								["08.ogg"] = 00.75,
								["09.ogg"] = 00.60,
							},
						},
						["SMV_KARABOR_"] = {
							["ARNOKK_"] = {
								["01.ogg"] = 03.03,
								["02.ogg"] = 02.91,
								["03.ogg"] = 08.98,
							},
						},
					},
				},
				["Aronus\\VO_"] = {
					["QE_HJ_"] = {
						["Aronus_"] = {
							["Attack01.ogg"] = 00.77,
							["Attack02.ogg"] = 00.44,
							["Attack03.ogg"] = 00.42,
							["Attack04.ogg"] = 00.85,
							["Attack05.ogg"] = 00.79,
							["Attack06.ogg"] = 00.50,
							["Attack07.ogg"] = 00.73,
							["Attack08.ogg"] = 00.75,
							["Attack09.ogg"] = 00.57,
							["Attack10.ogg"] = 00.54,
							["AttackCritical01.ogg"] = 00.67,
							["AttackCritical02.ogg"] = 00.99,
							["AttackCritical03.ogg"] = 01.13,
							["AttackCritical04.ogg"] = 00.62,
							["AttackCritical05.ogg"] = 01.22,
							["Desperiona01.ogg"] = 06.36,
							["Desperiona02.ogg"] = 03.29,
							["Intro01.ogg"] = 03.91,
							["Intro02.ogg"] = 05.00,
							["Intro03.ogg"] = 04.46,
							["Intro04.ogg"] = 05.71,
							["Wound01.ogg"] = 00.29,
							["Wound02.ogg"] = 00.47,
							["Wound03.ogg"] = 00.57,
							["Wound04.ogg"] = 00.45,
							["Wound05.ogg"] = 00.44,
							["Wound06.ogg"] = 00.55,
							["Wound07.ogg"] = 00.26,
							["Wound08.ogg"] = 00.45,
							["WoundCritical01.ogg"] = 00.77,
							["WoundCritical02.ogg"] = 01.15,
							["WoundCritical03.ogg"] = 00.89,
							["WoundCritical04.ogg"] = 01.07,
							["WoundCritical05.ogg"] = 01.17,
						},
					},
				},
				["Arthas\\"] = {
					["CS_Arthas_"] = {
						["Phase_"] = {
							["5_"] = {
								["01.ogg"] = 02.11,
								["02.ogg"] = 03.03,
								["03.ogg"] = 01.50,
								["04.ogg"] = 04.72,
								["05.ogg"] = 03.00,
								["06.ogg"] = 00.95,
								["07.ogg"] = 02.99,
								["08.ogg"] = 02.38,
								["09.ogg"] = 01.38,
								["10.ogg"] = 01.70,
								["11.ogg"] = 03.65,
								["12.ogg"] = 05.25,
								["13.ogg"] = 01.87,
								["14.ogg"] = 02.46,
							},
							["6_"] = {
								["01.ogg"] = 05.53,
								["02.ogg"] = 03.81,
								["03.ogg"] = 03.98,
								["04.ogg"] = 10.50,
								["05.ogg"] = 01.87,
							},
							["7_"] = {
								["01.ogg"] = 05.61,
								["02.ogg"] = 05.16,
								["03.ogg"] = 11.02,
							},
						},
						["20Health.ogg"] = 02.72,
						["50Health.ogg"] = 03.73,
						["ArthasSlays01.ogg"] = 02.00,
						["ArthasSlays02.ogg"] = 01.86,
						["ArthasSlays03.ogg"] = 01.96,
						["Attack01.ogg"] = 00.60,
						["Attack02.ogg"] = 00.64,
						["Attack03.ogg"] = 00.51,
						["Cinematic01.ogg"] = 01.75,
						["Cinematic02.ogg"] = 05.05,
						["Cinematic03.ogg"] = 09.95,
						["Cinematic04.ogg"] = 02.35,
						["Cinematic05.ogg"] = 04.44,
						["Cinematic06.ogg"] = 03.65,
						["Cinematic07.ogg"] = 10.94,
						["Cinematic08.ogg"] = 08.65,
						["Cinematic09.ogg"] = 00.57,
						["Cinematic10.ogg"] = 09.85,
						["Death.ogg"] = 14.79,
						["EnterCity01.ogg"] = 11.73,
						["EnterCity02.ogg"] = 02.25,
						["EnterCity03.ogg"] = 01.78,
						["EnterCity04.ogg"] = 06.28,
						["EnterCity05.ogg"] = 12.50,
						["Greeting01.ogg"] = 02.58,
						["Greeting02.ogg"] = 01.86,
						["Greeting03.ogg"] = 01.63,
						["Greeting04.ogg"] = 02.45,
						["Greeting05.ogg"] = 03.47,
						["Irritated01.ogg"] = 01.60,
						["Irritated02.ogg"] = 01.74,
						["Irritated03.ogg"] = 01.72,
						["Irritated04.ogg"] = 01.96,
						["Irritated05.ogg"] = 02.66,
						["StartingPhase5.ogg"] = 04.74,
						["Wound01.ogg"] = 00.77,
						["Wound02.ogg"] = 00.45,
						["Wound03.ogg"] = 00.62,
						["Wound04.ogg"] = 00.56,
						["WoundCrit01.ogg"] = 01.09,
						["WoundCrit02.ogg"] = 00.70,
						["WoundCrit03.ogg"] = 00.81,
					},
					["DB_Arthas_"] = {
						["ScriptEvent01.ogg"] = 02.87,
						["ScriptEvent02.ogg"] = 10.33,
						["ScriptEvent03.ogg"] = 04.86,
						["ScriptEvent04.ogg"] = 04.89,
						["ScriptEvent05.ogg"] = 05.20,
						["ScriptEvent06.ogg"] = 03.32,
						["ScriptEvent07.ogg"] = 06.20,
						["ScriptEvent08.ogg"] = 10.10,
					},
				},
				["ArthasPrisoner\\UR_"] = {
					["ArthasPrisoner_"] = {
						["YSVisThree01.ogg"] = 05.46,
						["YSVisThree02.ogg"] = 05.93,
					},
				},
				["Arugal\\"] = {
					["ArugalAggro01.ogg"] = 02.16,
					["ArugalCharm01.ogg"] = 01.55,
					["ArugalSlay01.ogg"] = 01.37,
					["ArugalTeaser01.ogg"] = 03.65,
				},
				["ARYGOS\\VO_"] = {
					["QUEST_42_"] = {
						["ARYGOS_"] = {
							["ECLIPSE_"] = {
								["01.ogg"] = 04.48,
								["02.ogg"] = 03.94,
								["03.ogg"] = 04.33,
								["04.ogg"] = 03.76,
								["05.ogg"] = 02.78,
								["06.ogg"] = 06.32,
								["07.ogg"] = 07.52,
								["08.ogg"] = 03.22,
								["09.ogg"] = 08.01,
								["10.ogg"] = 15.60,
								["11.ogg"] = 03.97,
							},
							["EYE_"] = {
								["01.ogg"] = 06.66,
								["02.ogg"] = 05.40,
							},
						},
					},
				},
				["Ashbringer\\ASH_"] = {
					["SPEAK_"] = {
						["01.ogg"] = 10.50,
						["02.ogg"] = 10.92,
						["03.ogg"] = 13.96,
						["04.ogg"] = 13.07,
						["05.ogg"] = 11.84,
						["06.ogg"] = 13.12,
						["07.ogg"] = 15.00,
						["08.ogg"] = 14.74,
						["09.ogg"] = 16.58,
						["10.ogg"] = 20.71,
						["11.ogg"] = 21.08,
						["12.ogg"] = 08.31,
					},
				},
				["AsimAlAkir\\"] = {
					["VO_VP_"] = {
						["AsimAlAkir_"] = {
							["Attack01.ogg"] = 01.40,
							["Attack02.ogg"] = 01.36,
							["Attack03.ogg"] = 01.49,
							["Attack04.ogg"] = 01.63,
							["Attack05.ogg"] = 01.65,
							["Attack06.ogg"] = 01.64,
							["Attack07.ogg"] = 01.60,
							["Attack08.ogg"] = 01.89,
							["Attack09.ogg"] = 01.68,
							["Attack10.ogg"] = 01.64,
							["AttackCritical01.ogg"] = 01.85,
							["AttackCritical02.ogg"] = 01.99,
							["AttackCritical03.ogg"] = 02.31,
							["AttackCritical04.ogg"] = 02.03,
							["AttackCritical05.ogg"] = 01.98,
							["Event01.ogg"] = 09.12,
							["Event02.ogg"] = 03.97,
							["Event03.ogg"] = 05.58,
							["Event04.ogg"] = 04.11,
							["Wound01.ogg"] = 01.51,
							["Wound02.ogg"] = 01.51,
							["Wound03.ogg"] = 01.33,
							["Wound04.ogg"] = 01.81,
							["Wound05.ogg"] = 01.45,
							["Wound06.ogg"] = 01.72,
							["Wound07.ogg"] = 01.51,
							["Wound08.ogg"] = 01.69,
							["Wound09.ogg"] = 01.86,
							["Wound10.ogg"] = 01.67,
							["WoundCritical01.ogg"] = 02.19,
							["WoundCritical02.ogg"] = 02.11,
							["WoundCritical03.ogg"] = 01.63,
							["WoundCritical04.ogg"] = 02.28,
						},
					},
					["MON_Asim_CreatureLoop.ogg"] = 14.42,
				},
				["ASIRA\\VO_"] = {
					["ASIRA_"] = {
						["Attack01.OGG"] = 00.48,
						["Attack02.OGG"] = 00.44,
						["Attack03.OGG"] = 00.48,
						["Attack04.OGG"] = 00.58,
						["Attack05.OGG"] = 00.44,
						["Attack06.OGG"] = 00.62,
						["Attack07.OGG"] = 00.58,
						["Attack08.OGG"] = 00.59,
						["Attack09.OGG"] = 00.50,
						["Attack10.OGG"] = 00.72,
						["AttackCrit01.OGG"] = 01.14,
						["AttackCrit02.OGG"] = 01.10,
						["AttackCrit03.OGG"] = 01.36,
						["AttackCrit04.OGG"] = 01.37,
						["AttackCrit05.OGG"] = 01.55,
						["Wound01.OGG"] = 00.38,
						["Wound02.OGG"] = 00.45,
						["Wound03.OGG"] = 00.55,
						["Wound04.OGG"] = 00.61,
						["Wound05.OGG"] = 00.68,
						["Wound06.OGG"] = 00.66,
						["Wound07.OGG"] = 00.61,
						["Wound08.OGG"] = 00.55,
						["Wound09.OGG"] = 00.56,
						["Wound10.OGG"] = 00.54,
						["WoundCrit01.OGG"] = 00.81,
						["WoundCrit02.OGG"] = 00.82,
						["WoundCrit03.OGG"] = 00.81,
						["WoundCrit04.OGG"] = 00.90,
						["WoundCrit05.OGG"] = 01.06,
					},
					["HOT_ASIRA_"] = {
						["EVENT_"] = {
							["01.OGG"] = 03.95,
							["02.OGG"] = 10.72,
							["03.OGG"] = 04.76,
						},
						["SLAY_"] = {
							["01.OGG"] = 01.97,
							["02.OGG"] = 02.98,
							["03.OGG"] = 03.12,
							["04.OGG"] = 01.54,
						},
						["SPELL_"] = {
							["01.OGG"] = 01.22,
							["02.OGG"] = 01.63,
							["03.OGG"] = 01.61,
						},
						["AGGRO_01.OGG"] = 02.51,
						["DEATH_01.OGG"] = 04.89,
					},
				},
				["AssassinKi\\VO_"] = {
					["54_"] = {
						["KI_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 00.81,
								["02.OGG"] = 01.15,
								["03.OGG"] = 01.02,
								["04.OGG"] = 01.67,
								["05.OGG"] = 01.55,
							},
							["Attack_"] = {
								["01.OGG"] = 00.33,
								["010.OGG"] = 00.47,
								["02.OGG"] = 00.34,
								["03.OGG"] = 00.26,
								["04.OGG"] = 00.53,
								["05.OGG"] = 00.69,
								["06.OGG"] = 00.45,
								["07.OGG"] = 00.32,
								["08.OGG"] = 00.39,
								["09.OGG"] = 00.45,
							},
							["Death_"] = {
								["01.OGG"] = 02.13,
								["02.OGG"] = 02.00,
								["03.OGG"] = 02.22,
								["04.OGG"] = 02.47,
								["05.OGG"] = 02.51,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.89,
								["02.OGG"] = 01.17,
								["03.OGG"] = 00.86,
								["04.OGG"] = 00.79,
								["05.OGG"] = 01.09,
							},
							["Wound_"] = {
								["01.OGG"] = 00.41,
								["02.OGG"] = 00.34,
								["03.OGG"] = 00.44,
								["04.OGG"] = 00.42,
								["05.OGG"] = 00.35,
								["06.OGG"] = 00.37,
								["07.OGG"] = 00.40,
								["08.OGG"] = 00.25,
							},
						},
						["PG_KI_"] = {
							["COMBAT-AGGRO-KI_01.OGG"] = 01.90,
							["COMBAT-AQUABOMB_02.OGG"] = 03.26,
							["COMBAT-FIRE-SOOLI_01.OGG"] = 01.67,
							["GREETING-KI_01.OGG"] = 04.01,
							["INTRO-BASIC_01.OGG"] = 08.12,
							["INTRO-FIRE_01.OGG"] = 05.40,
							["TRIAL-FAILURE-KI_01.OGG"] = 02.44,
							["TRIAL-FAILURE-PLAYER_01.OGG"] = 03.20,
							["TRIAL-START-GOLD_01.OGG"] = 09.72,
						},
					},
				},
				["AssaultCommander\\VO_"] = {
					["60_"] = {
						["COMMANDER_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.96,
								["02.ogg"] = 01.25,
								["03.ogg"] = 00.65,
								["04.ogg"] = 00.96,
								["05.ogg"] = 01.30,
							},
							["Attack_"] = {
								["01.ogg"] = 00.33,
								["010.ogg"] = 00.39,
								["02.ogg"] = 00.73,
								["03.ogg"] = 00.34,
								["04.ogg"] = 00.28,
								["05.ogg"] = 00.35,
								["06.ogg"] = 00.49,
								["07.ogg"] = 00.46,
								["08.ogg"] = 00.40,
								["09.ogg"] = 00.59,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.38,
								["02.ogg"] = 01.82,
								["03.ogg"] = 01.88,
								["04.ogg"] = 00.93,
								["05.ogg"] = 00.80,
							},
							["Wound_"] = {
								["01.ogg"] = 01.13,
								["010.ogg"] = 00.42,
								["02.ogg"] = 00.67,
								["03.ogg"] = 00.63,
								["04.ogg"] = 00.88,
								["05.ogg"] = 00.29,
								["06.ogg"] = 00.47,
								["07.ogg"] = 00.39,
								["08.ogg"] = 00.65,
								["09.ogg"] = 00.26,
							},
						},
						["TRAIN_ASSAULT_"] = {
							["COMMANDER_"] = {
								["EVENT_"] = {
									["1.ogg"] = 01.94,
									["2.ogg"] = 01.50,
									["3.ogg"] = 02.37,
									["4.ogg"] = 02.94,
									["5.ogg"] = 04.29,
								},
								["INTRO_"] = {
									["1.ogg"] = 02.94,
									["2.ogg"] = 03.38,
									["3.ogg"] = 02.50,
									["4.ogg"] = 04.55,
								},
								["KILL_"] = {
									["1.ogg"] = 03.99,
									["2.ogg"] = 01.87,
								},
								["DEATH.ogg"] = 05.30,
								["RESET1.ogg"] = 02.57,
								["AGGRO_1.ogg"] = 02.21,
							},
						},
					},
				},
				["Atalalarion\\"] = {
					["AtalalarionAggro01.ogg"] = 02.60,
					["AtalalarionSpawnYell01.ogg"] = 04.07,
				},
				["Atramedes\\VO_"] = {
					["BD_Atramedes_"] = {
						["Attack01.ogg"] = 01.95,
						["Attack02.ogg"] = 02.21,
						["Attack03.ogg"] = 02.02,
						["Attack04.ogg"] = 01.95,
						["Attack05.ogg"] = 02.20,
						["Attack06.ogg"] = 02.20,
						["Attack07.ogg"] = 01.85,
						["Attack08.ogg"] = 01.83,
						["AttackCritical01.ogg"] = 02.73,
						["AttackCritical02.ogg"] = 02.48,
						["AttackCritical03.ogg"] = 02.33,
						["AttackCritical04.ogg"] = 02.98,
						["AttackCritical05.ogg"] = 02.20,
						["Event01.ogg"] = 10.21,
						["Event02.ogg"] = 07.37,
						["Event03.ogg"] = 03.61,
						["Event04.ogg"] = 06.05,
						["Event05.ogg"] = 02.51,
						["Event06.ogg"] = 05.44,
						["Event07.ogg"] = 06.05,
						["Event08.ogg"] = 15.30,
						["Event09.ogg"] = 02.97,
						["Wound01.ogg"] = 01.54,
						["Wound02.ogg"] = 01.77,
						["Wound03.ogg"] = 01.78,
						["Wound04.ogg"] = 01.62,
						["Wound05.ogg"] = 01.77,
						["Wound06.ogg"] = 01.57,
						["Wound07.ogg"] = 01.62,
						["Wound08.ogg"] = 01.52,
						["WoundCritical01.ogg"] = 04.11,
						["WoundCritical02.ogg"] = 02.46,
						["WoundCritical03.ogg"] = 02.09,
						["WoundCritical04.ogg"] = 01.82,
						["WoundCritical05.ogg"] = 01.99,
					},
				},
				["AttumenTheHuntsman\\"] = {
					["AttumenAttack01.ogg"] = 01.52,
					["AttumenAttack02.ogg"] = 01.40,
					["AttumenAttack03.ogg"] = 01.50,
					["AttumenAttack04.ogg"] = 01.40,
					["AttumenDies01.ogg"] = 07.01,
					["AttumenDisarmed01.ogg"] = 04.51,
					["AttumenEnters01.ogg"] = 03.00,
					["AttumenEnters02.ogg"] = 03.64,
					["AttumenEnters03.ogg"] = 05.51,
					["AttumenMounts01.ogg"] = 04.03,
					["AttumenSlay01.ogg"] = 02.49,
					["AttumenSlay02.ogg"] = 03.02,
					["AttumenTaunt01.ogg"] = 03.15,
					["AttumenTaunt02.ogg"] = 05.65,
					["AttumenWound01.ogg"] = 01.40,
					["AttumenWound02.ogg"] = 01.31,
					["AttumenWound03.ogg"] = 01.32,
					["AttumenWoundCrit01.ogg"] = 01.51,
					["AttumenWoundCrit02.ogg"] = 01.45,
					["AttumenWoundCrit03.ogg"] = 01.84,
					["MidnightSlay01.ogg"] = 02.65,
				},
				["AuchindounProtector\\VO_"] = {
					["60_AUCH_"] = {
						["PROTECTOR_"] = {
							["AGGRO.ogg"] = 03.35,
							["DEATH.ogg"] = 05.78,
							["INTRO.ogg"] = 05.59,
							["KILL.ogg"] = 03.46,
							["SPELL1.ogg"] = 04.23,
							["SPELL2.ogg"] = 03.88,
						},
					},
				},
				["AuchWarden\\VO_"] = {
					["60_AUCH_"] = {
						["WARDEN_"] = {
							["DEATH.ogg"] = 04.85,
							["EVENT1.ogg"] = 02.59,
							["EVENT2.ogg"] = 02.47,
							["EVENT3.ogg"] = 03.29,
							["EVENT4.ogg"] = 02.46,
							["EVENT5.ogg"] = 06.28,
						},
					},
				},
				["AuntieStormstout\\VO_"] = {
					["SB_AUNTIE_"] = {
						["EVENT_"] = {
							["01.OGG"] = 05.94,
							["02.OGG"] = 05.23,
							["03.OGG"] = 03.44,
							["04.OGG"] = 04.08,
							["05.OGG"] = 10.49,
							["06.OGG"] = 01.90,
						},
					},
				},
				["Auriaya\\UR_"] = {
					["Auriaya_"] = {
						["Aggro01.ogg"] = 04.31,
						["Attack01.ogg"] = 00.92,
						["Attack02.ogg"] = 00.88,
						["Attack03.ogg"] = 00.94,
						["Attack04.ogg"] = 00.86,
						["Attack05.ogg"] = 00.78,
						["Berserk01.ogg"] = 02.17,
						["Death01.ogg"] = 04.51,
						["Slay01.ogg"] = 03.03,
						["Slay02.ogg"] = 02.07,
						["Wound01.ogg"] = 00.42,
						["Wound02.ogg"] = 00.93,
						["Wound03.ogg"] = 00.81,
						["Wound04.ogg"] = 01.57,
						["Wound05.ogg"] = 00.91,
					},
				},
				["Avartu\\VO_"] = {
					["5.1_"] = {
						["Dungeon_Avartu_"] = {
							["MoguCrypt_"] = {
								["01.OGG"] = 03.20,
								["02.OGG"] = 04.21,
								["03.OGG"] = 03.82,
								["04.OGG"] = 06.03,
								["05.OGG"] = 03.52,
								["06.OGG"] = 05.37,
								["07.OGG"] = 10.43,
								["08.OGG"] = 05.94,
								["09.OGG"] = 07.26,
								["10.OGG"] = 09.67,
								["11.OGG"] = 08.97,
							},
						},
						["PROG_Avartu_"] = {
							["Vision_"] = {
								["01.OGG"] = 12.33,
								["02.OGG"] = 06.06,
								["03.OGG"] = 07.30,
							},
						},
					},
				},
				["AvatarOfHakar\\"] = {
					["AvatarOfHakarAggro.ogg"] = 02.72,
					["AvatarOfHakarAttackA.ogg"] = 00.87,
					["AvatarOfHakarAttackB.ogg"] = 00.81,
					["AvatarOfHakarAttackC.ogg"] = 00.88,
					["AvatarOfHakarAttackD.ogg"] = 01.66,
					["AvatarOfHakarDeath.ogg"] = 02.91,
					["AvatarOfHakarWoundA.ogg"] = 01.06,
					["AvatarOfHakarWoundB.ogg"] = 01.07,
					["AvatarOfHakarWoundC.ogg"] = 01.42,
					["AvatarOfHakarWoundCritA.ogg"] = 01.17,
				},
				["AvatarOfHakkar\\"] = {
					["AvatarOfHakkarAggro01.ogg"] = 02.51,
					["AvatarOfHakkarBrazier01.ogg"] = 03.00,
					["AvatarOfHakkarBrazier02.ogg"] = 02.49,
					["AvatarOfHakkarBrazier03.ogg"] = 02.31,
					["AvatarOfHakkarBrazier04.ogg"] = 02.27,
				},
				["Aviana\\VO_"] = {
					["QE_HJ_"] = {
						["Aviana_"] = {
							["Attack01.ogg"] = 01.22,
							["Attack02.ogg"] = 01.45,
							["Attack03.ogg"] = 00.74,
							["Attack04.ogg"] = 01.20,
							["Attack05.ogg"] = 01.12,
							["Attack06.ogg"] = 01.11,
							["Attack07.ogg"] = 01.03,
							["Attack08.ogg"] = 01.29,
							["Attack09.ogg"] = 01.17,
							["Attack10.ogg"] = 01.26,
							["AttackCritical01.ogg"] = 01.26,
							["AttackCritical02.ogg"] = 01.34,
							["AttackCritical03.ogg"] = 01.48,
							["AttackCritical04.ogg"] = 01.36,
							["AttackCritical05.ogg"] = 00.93,
							["AttackCritical06.ogg"] = 01.28,
							["Death01.ogg"] = 01.83,
							["Death02.ogg"] = 01.54,
							["Death03.ogg"] = 01.40,
							["Death04.ogg"] = 01.28,
							["Death05.ogg"] = 01.64,
							["Death06.ogg"] = 02.12,
							["Death07.ogg"] = 02.19,
							["Desperiona01.ogg"] = 06.62,
							["Desperiona02.ogg"] = 04.46,
							["HYEvent01.ogg"] = 03.93,
							["HYEvent02.ogg"] = 04.56,
							["HYEvent03.ogg"] = 05.32,
							["HYEvent04.ogg"] = 02.49,
							["HYEvent05.ogg"] = 08.47,
							["HYEvent06.ogg"] = 08.48,
							["Whispers01.ogg"] = 06.16,
							["Whispers02.ogg"] = 02.06,
							["Wound01.ogg"] = 00.66,
							["Wound02.ogg"] = 00.99,
							["Wound03.ogg"] = 00.77,
							["Wound04.ogg"] = 01.05,
							["Wound05.ogg"] = 00.90,
							["Wound06.ogg"] = 01.04,
							["Wound07.ogg"] = 00.85,
							["Wound08.ogg"] = 00.88,
							["Wound09.ogg"] = 01.36,
							["Wound10.ogg"] = 01.24,
							["WoundCritical01.ogg"] = 00.90,
							["WoundCritical02.ogg"] = 00.73,
							["WoundCritical03.ogg"] = 00.98,
							["WoundCritical04.ogg"] = 01.09,
							["WoundCritical05.ogg"] = 00.90,
						},
					},
				},
				["AysaCloudsong\\VO_"] = {
					["54_OR_"] = {
						["AYSA_EVENT_"] = {
							["1.OGG"] = 02.89,
							["2.OGG"] = 03.26,
							["3.OGG"] = 04.22,
							["4.OGG"] = 04.61,
							["5.OGG"] = 02.97,
							["6.OGG"] = 11.07,
							["7.OGG"] = 01.76,
						},
					},
					["AysaCloudsong_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.67,
							["02.OGG"] = 00.60,
							["03.OGG"] = 01.32,
							["04.OGG"] = 00.94,
							["05.OGG"] = 01.28,
							["06.OGG"] = 01.65,
						},
						["Attack_"] = {
							["01.OGG"] = 00.26,
							["02.OGG"] = 00.30,
							["03.OGG"] = 00.34,
							["04.OGG"] = 00.28,
							["05.OGG"] = 00.24,
							["06.OGG"] = 00.36,
							["07.OGG"] = 00.31,
							["08.OGG"] = 00.31,
							["09.OGG"] = 00.33,
							["10.OGG"] = 00.32,
						},
						["Death_"] = {
							["01.OGG"] = 01.74,
							["02.OGG"] = 03.20,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.91,
							["02.OGG"] = 00.85,
							["03.OGG"] = 00.87,
							["04.OGG"] = 00.92,
							["05.OGG"] = 01.03,
						},
						["Wound_"] = {
							["01.OGG"] = 00.35,
							["02.OGG"] = 00.40,
							["03.OGG"] = 00.44,
							["04.OGG"] = 00.46,
							["05.OGG"] = 00.84,
							["06.OGG"] = 00.33,
							["07.OGG"] = 00.37,
							["08.OGG"] = 00.54,
							["09.OGG"] = 00.68,
							["10.OGG"] = 00.50,
						},
					},
					["SZS_Aysa_"] = {
						["Cloudsinger_"] = {
							["Dragon_Fight_"] = {
								["01.OGG"] = 01.24,
								["02.OGG"] = 04.83,
								["03.OGG"] = 02.37,
								["04.OGG"] = 01.09,
								["05.OGG"] = 03.63,
								["06.OGG"] = 02.23,
								["07.OGG"] = 04.11,
							},
							["Ship_Fight_"] = {
								["01.OGG"] = 03.73,
								["02.OGG"] = 04.14,
								["03.OGG"] = 03.97,
								["05.OGG"] = 02.18,
								["06.OGG"] = 04.15,
							},
						},
						["Stormwind_"] = {
							["01.OGG"] = 05.59,
							["02.OGG"] = 01.55,
							["03.OGG"] = 00.75,
							["04.OGG"] = 02.36,
							["05.OGG"] = 03.27,
						},
						["Water_Spirit_"] = {
							["Completion_"] = {
								["01.OGG"] = 03.01,
								["02.OGG"] = 02.44,
							},
						},
					},
					["WI_Aysa_"] = {
						["_"] = {
							["Cave_"] = {
								["Of_Scrolls_"] = {
									["01.OGG"] = 04.89,
									["02.OGG"] = 06.50,
								},
								["Intro_01.OGG"] = 02.24,
							},
							["Chamber_Of_"] = {
								["Winds_"] = {
									["01.OGG"] = 00.53,
									["02.OGG"] = 05.32,
									["03.OGG"] = 03.61,
									["04.OGG"] = 03.57,
								},
							},
							["Greeting_"] = {
								["01.OGG"] = 01.24,
								["02.OGG"] = 01.01,
								["03.OGG"] = 02.55,
								["04.OGG"] = 03.06,
								["05.OGG"] = 03.73,
							},
							["Gun_Ship_"] = {
								["Prelude_"] = {
									["01.OGG"] = 04.92,
									["02.OGG"] = 03.66,
									["03.OGG"] = 03.58,
									["04.OGG"] = 02.27,
									["05.OGG"] = 09.97,
								},
							},
							["Healing_Event_"] = {
								["01.OGG"] = 02.77,
								["02.OGG"] = 05.23,
							},
							["Pei_Wu_"] = {
								["Gate_"] = {
									["01.OGG"] = 01.33,
									["02.OGG"] = 01.45,
								},
							},
							["Pissed_"] = {
								["01.OGG"] = 00.82,
								["02.OGG"] = 02.80,
							},
							["Stromwind_"] = {
								["01.OGG"] = 07.04,
								["02.OGG"] = 05.72,
								["03.OGG"] = 05.37,
							},
							["Turtle_Balloon_"] = {
								["Event_"] = {
									["01.OGG"] = 01.93,
									["02.OGG"] = 00.71,
									["03.OGG"] = 02.63,
									["04.OGG"] = 04.80,
									["05.OGG"] = 03.49,
									["06.OGG"] = 02.34,
									["07.OGG"] = 06.71,
									["08.OGG"] = 03.64,
									["09.OGG"] = 06.54,
									["10.OGG"] = 04.45,
									["11.OGG"] = 01.80,
									["12.OGG"] = 06.79,
									["13.OGG"] = 06.08,
									["14.OGG"] = 03.64,
								},
							},
							["Boss_Kill_01.OGG"] = 03.67,
							["Dock_Approach_01.OGG"] = 08.18,
							["Final_Turn_In_01.OGG"] = 04.62,
							["Fire_Temple_Turn_In_01.OGG"] = 01.16,
							["Hermit_Hut_Intro_01.OGG"] = 07.82,
							["Mandori_Gate_01.OGG"] = 01.49,
						},
					},
				},
				["Azgalor\\CAV_"] = {
					["Azga_"] = {
						["Attack01.ogg"] = 01.60,
						["Attack02.ogg"] = 01.66,
						["Attack03.ogg"] = 01.07,
						["Attack04.ogg"] = 01.11,
						["Attack05.ogg"] = 01.67,
						["Attack06.ogg"] = 01.86,
						["Death01.ogg"] = 08.42,
						["Doom01.ogg"] = 03.65,
						["Doom02.ogg"] = 03.85,
						["Enter01.ogg"] = 14.29,
						["Slay01.ogg"] = 02.30,
						["Slay02.ogg"] = 03.37,
						["Slay03.ogg"] = 02.38,
						["Wound01.ogg"] = 00.75,
						["Wound02.ogg"] = 00.89,
						["Wound03.ogg"] = 01.02,
						["WoundCrit01.ogg"] = 01.07,
						["WoundCrit02.ogg"] = 01.06,
						["WoundCrit03.ogg"] = 01.22,
					},
				},
				["Azil\\VO_"] = {
					["QE_Azil_"] = {
						["Attack01.ogg"] = 00.74,
						["Attack02.ogg"] = 00.51,
						["Attack03.ogg"] = 00.63,
						["Attack04.ogg"] = 00.73,
						["Attack05.ogg"] = 00.63,
						["Attack06.ogg"] = 00.66,
						["Attack07.ogg"] = 00.42,
						["Attack08.ogg"] = 00.50,
						["Attack09.ogg"] = 00.68,
						["Attack10.ogg"] = 01.15,
						["AttackCritical01.ogg"] = 00.67,
						["AttackCritical02.ogg"] = 01.40,
						["AttackCritical03.ogg"] = 00.75,
						["AttackCritical04.ogg"] = 00.91,
						["AttackCritical05.ogg"] = 00.72,
						["Event01.ogg"] = 08.44,
						["Event02.ogg"] = 04.44,
						["Event03.ogg"] = 04.99,
						["Event04.ogg"] = 04.18,
						["Wound01.ogg"] = 00.34,
						["Wound02.ogg"] = 00.41,
						["Wound03.ogg"] = 00.35,
						["Wound04.ogg"] = 00.45,
						["Wound05.ogg"] = 00.49,
						["Wound06.ogg"] = 00.49,
						["Wound07.ogg"] = 00.46,
						["Wound08.ogg"] = 00.63,
						["Wound09.ogg"] = 00.62,
						["Wound10.ogg"] = 00.53,
						["WoundCritical01.ogg"] = 00.94,
						["WoundCritical02.ogg"] = 00.74,
						["WoundCritical03.ogg"] = 00.79,
						["WoundCritical04.ogg"] = 00.79,
						["WoundCritical05.ogg"] = 00.81,
					},
					["SC_Azil_"] = {
						["Aggro01.ogg"] = 04.36,
						["Aggro02.ogg"] = 03.06,
						["Death.ogg"] = 10.05,
						["Event01.ogg"] = 14.51,
						["Spell01.ogg"] = 08.91,
					},
				},
				["Azjentus\\VO_"] = {
					["QE_VJ_"] = {
						["Azjentus_"] = {
							["Attack01.ogg"] = 00.80,
							["Attack02.ogg"] = 00.64,
							["Attack03.ogg"] = 00.87,
							["Attack04.ogg"] = 00.55,
							["Attack05.ogg"] = 00.71,
							["Attack06.ogg"] = 00.79,
							["Attack07.ogg"] = 00.80,
							["Attack08.ogg"] = 01.26,
							["Attack09.ogg"] = 01.17,
							["Attack10.ogg"] = 01.15,
							["AttackCritical01.ogg"] = 00.93,
							["AttackCritical02.ogg"] = 01.31,
							["AttackCritical03.ogg"] = 00.87,
							["AttackCritical04.ogg"] = 01.03,
							["AttackCritical05.ogg"] = 01.13,
							["Bridge01.ogg"] = 07.26,
							["Bridge02.ogg"] = 03.04,
							["Bridge03.ogg"] = 04.09,
							["Bridge04.ogg"] = 02.92,
							["Bridge05.ogg"] = 05.16,
							["Death01.ogg"] = 01.34,
							["Death02.ogg"] = 01.68,
							["Death03.ogg"] = 02.32,
							["Vision01.ogg"] = 08.98,
							["Vision02.ogg"] = 02.43,
							["Wound01.ogg"] = 00.49,
							["Wound02.ogg"] = 00.42,
							["Wound03.ogg"] = 00.69,
							["Wound04.ogg"] = 00.62,
							["Wound05.ogg"] = 00.69,
							["Wound06.ogg"] = 00.62,
							["Wound07.ogg"] = 00.91,
							["Wound08.ogg"] = 00.74,
							["Wound09.ogg"] = 00.70,
							["WoundCritical01.ogg"] = 00.96,
							["WoundCritical02.ogg"] = 01.03,
							["WoundCritical03.ogg"] = 01.01,
							["WoundCritical04.ogg"] = 01.16,
							["WoundCritical05.ogg"] = 00.77,
						},
					},
				},
				["AZSHARA\\VO_"] = {
					["AZSHARA_"] = {
						["Attack01.OGG"] = 00.24,
						["Attack02.OGG"] = 00.29,
						["Attack03.OGG"] = 00.34,
						["Attack04.OGG"] = 00.34,
						["Attack05.OGG"] = 00.24,
						["Attack06.OGG"] = 00.49,
						["Attack07.OGG"] = 00.47,
						["Attack08.OGG"] = 00.44,
						["Attack09.OGG"] = 00.53,
						["Attack10.OGG"] = 00.54,
						["AttackCrit01.OGG"] = 01.07,
						["AttackCrit02.OGG"] = 01.91,
						["AttackCrit03.OGG"] = 00.83,
						["AttackCrit04.OGG"] = 01.37,
						["AttackCrit05.OGG"] = 01.01,
						["Wound01.OGG"] = 00.35,
						["Wound02.OGG"] = 00.38,
						["Wound03.OGG"] = 00.43,
						["Wound04.OGG"] = 00.28,
						["Wound05.OGG"] = 00.28,
						["Wound06.OGG"] = 00.40,
						["Wound07.OGG"] = 00.46,
						["Wound08.OGG"] = 00.62,
						["Wound09.OGG"] = 00.46,
						["Wound10.OGG"] = 00.55,
						["WoundCrit01.OGG"] = 00.74,
						["WoundCrit02.OGG"] = 00.86,
						["WoundCrit03.OGG"] = 01.06,
						["WoundCrit04.OGG"] = 00.85,
						["WoundCrit05.OGG"] = 00.87,
					},
					["WOE_AZSHARA_"] = {
						["EVENT_"] = {
							["01.OGG"] = 05.42,
							["02.OGG"] = 04.32,
							["03.OGG"] = 04.29,
							["04.OGG"] = 07.78,
							["05.OGG"] = 02.25,
							["06.OGG"] = 05.73,
						},
						["SLAY_"] = {
							["01.OGG"] = 02.69,
							["02.OGG"] = 02.96,
							["03.OGG"] = 02.93,
						},
						["SPELL_"] = {
							["01.OGG"] = 02.80,
							["02.OGG"] = 04.72,
							["03.OGG"] = 03.97,
							["04.OGG"] = 06.99,
							["05.OGG"] = 06.70,
							["06.OGG"] = 06.24,
						},
						["AGGRO_01.OGG"] = 09.02,
						["RESET_01.OGG"] = 05.92,
					},
				},
				["Azuka\\VO_"] = {
					["60_"] = {
						["AZUKA_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.87,
								["02.ogg"] = 01.91,
								["03.ogg"] = 01.10,
								["04.ogg"] = 01.15,
								["05.ogg"] = 01.00,
							},
							["Attack_"] = {
								["01.ogg"] = 00.76,
								["010.ogg"] = 00.52,
								["02.ogg"] = 00.71,
								["03.ogg"] = 00.98,
								["04.ogg"] = 00.68,
								["05.ogg"] = 00.48,
								["06.ogg"] = 00.48,
								["07.ogg"] = 00.62,
								["08.ogg"] = 00.62,
								["09.ogg"] = 00.51,
							},
							["Death_"] = {
								["01.ogg"] = 01.95,
								["02.ogg"] = 02.98,
								["03.ogg"] = 02.54,
								["04.ogg"] = 03.03,
								["05.ogg"] = 02.06,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.32,
								["02.ogg"] = 01.63,
								["03.ogg"] = 01.92,
								["04.ogg"] = 01.89,
								["05.ogg"] = 01.78,
							},
							["Wound_"] = {
								["01.ogg"] = 00.47,
								["010.ogg"] = 00.93,
								["02.ogg"] = 00.84,
								["03.ogg"] = 00.80,
								["04.ogg"] = 00.67,
								["05.ogg"] = 00.67,
								["06.ogg"] = 00.55,
								["07.ogg"] = 00.97,
								["08.ogg"] = 00.59,
								["09.ogg"] = 00.62,
							},
						},
						["BOSS_AZUKA_"] = {
							["01.ogg"] = 02.62,
							["02.ogg"] = 02.66,
							["03.ogg"] = 03.80,
							["04.ogg"] = 05.36,
							["05.ogg"] = 03.68,
							["06.ogg"] = 02.85,
							["07.ogg"] = 03.89,
						},
						["GAR_ATTACK_"] = {
							["01.ogg"] = 09.99,
							["02.ogg"] = 00.59,
							["03.ogg"] = 00.37,
						},
						["TAN_FINALE_"] = {
							["AZUKA_"] = {
								["02.ogg"] = 04.35,
								["03.ogg"] = 10.46,
								["04.ogg"] = 08.05,
								["05.ogg"] = 06.65,
								["06.ogg"] = 03.98,
								["07.ogg"] = 14.67,
							},
						},
						["WARLORDS_AZUKA_"] = {
							["01.ogg"] = 06.99,
							["02.ogg"] = 03.91,
							["03.ogg"] = 06.29,
							["04.ogg"] = 08.05,
							["05.ogg"] = 08.82,
						},
					},
				},
				["Azzakel\\VO_"] = {
					["60_"] = {
						["AUCH_AZZAKEL_"] = {
							["KILL_"] = {
								["01.ogg"] = 05.10,
								["02.ogg"] = 04.61,
							},
							["SPELL_"] = {
								["01.ogg"] = 03.52,
								["02.ogg"] = 04.84,
								["03.ogg"] = 03.82,
							},
							["AGGRO.ogg"] = 07.68,
							["DEATH.ogg"] = 04.11,
							["INTRO.ogg"] = 05.85,
						},
						["Azzakel_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.78,
								["02.ogg"] = 02.48,
								["03.ogg"] = 03.85,
								["04.ogg"] = 02.46,
								["05.ogg"] = 02.96,
							},
							["Attack_"] = {
								["01.ogg"] = 01.01,
								["010.ogg"] = 01.03,
								["02.ogg"] = 01.02,
								["03.ogg"] = 01.14,
								["04.ogg"] = 01.04,
								["05.ogg"] = 00.97,
								["06.ogg"] = 00.87,
								["07.ogg"] = 00.84,
								["08.ogg"] = 01.04,
								["09.ogg"] = 00.97,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.94,
								["02.ogg"] = 02.58,
								["03.ogg"] = 02.25,
								["04.ogg"] = 01.28,
								["05.ogg"] = 01.69,
							},
							["Wound_"] = {
								["01.ogg"] = 00.88,
								["010.ogg"] = 00.91,
								["02.ogg"] = 01.53,
								["03.ogg"] = 00.95,
								["04.ogg"] = 00.86,
								["05.ogg"] = 00.98,
								["06.ogg"] = 00.88,
								["07.ogg"] = 00.85,
								["08.ogg"] = 00.87,
								["09.ogg"] = 01.14,
							},
						},
					},
				},
				["BabyCrocodile\\"] = {
					["BabyCrocodileClick1.ogg"] = 01.04,
					["BabyCrocodileClick2.ogg"] = 01.19,
					["BabyCrocodileClick3.ogg"] = 01.48,
					["BabyCrocodileClick4.ogg"] = 01.41,
					["BabyCrocodileClick5.ogg"] = 01.14,
				},
				["BabyLich\\"] = {
					["GhostlySkullPetClickable1.ogg"] = 03.50,
					["GhostlySkullPetClickable2.ogg"] = 04.01,
					["GhostlySkullPetClickable3.ogg"] = 03.39,
					["GhostlySkullPetClickable4.ogg"] = 03.25,
					["GhostlySkullPetLaugh.ogg"] = 07.95,
					["GhostlySkullPetStandVariation1.ogg"] = 04.20,
				},
				["BabyMoonkin\\PET_"] = {
					["BabyMoonkin_"] = {
						["Clickable01.ogg"] = 01.88,
						["Clickable02.ogg"] = 01.27,
						["Clickable03.ogg"] = 01.22,
						["Clickable04.ogg"] = 01.92,
						["Clickable05.ogg"] = 00.93,
						["Clickable06.ogg"] = 01.00,
						["Clickable07.ogg"] = 01.26,
						["Clickable08.ogg"] = 01.70,
						["Flap01.ogg"] = 00.16,
						["Flap02.ogg"] = 00.17,
						["Flap03.ogg"] = 00.15,
						["Flap04.ogg"] = 00.14,
						["Flap05.ogg"] = 00.15,
						["Flap06.ogg"] = 00.15,
						["Flap07.ogg"] = 00.16,
						["Flap08.ogg"] = 00.15,
						["Flap09.ogg"] = 00.15,
						["Flap10.ogg"] = 00.13,
					},
				},
				["BABYMURLOC\\"] = {
					["BabyMurloc_"] = {
						["Attack_"] = {
							["01.OGG"] = 01.51,
							["02.OGG"] = 01.12,
							["03.OGG"] = 01.13,
							["04.OGG"] = 01.10,
							["05.OGG"] = 01.20,
							["06.OGG"] = 01.10,
						},
						["Clickable_"] = {
							["04.OGG"] = 01.13,
							["05.OGG"] = 01.33,
							["06.OGG"] = 02.27,
							["07.OGG"] = 01.68,
							["08.OGG"] = 01.71,
							["09.OGG"] = 01.78,
							["10.OGG"] = 01.20,
						},
						["Death_"] = {
							["01.OGG"] = 04.57,
							["02.OGG"] = 03.82,
							["03.OGG"] = 04.09,
						},
						["Wound_"] = {
							["01.OGG"] = 01.17,
							["02.OGG"] = 00.87,
							["03.OGG"] = 00.67,
							["04.OGG"] = 00.77,
							["05.OGG"] = 00.90,
						},
					},
					["BabyMurlocA.ogg"] = 02.27,
					["BabyMurlocB.ogg"] = 01.95,
					["BabyMurlocC.ogg"] = 01.15,
					["BabyMurlocDance.ogg"] = 11.23,
					["BabyMurlocDance_02.OGG"] = 10.78,
				},
				["BabyTriceratops\\Mon_"] = {
					["Triceratops_"] = {
						["Clickable01.OGG"] = 02.35,
						["Clickable02.OGG"] = 02.45,
						["Clickable03.OGG"] = 01.82,
						["Clickable04.OGG"] = 02.28,
						["Clickable05.OGG"] = 01.91,
						["Clickable06.OGG"] = 01.98,
						["Clickable07.OGG"] = 01.90,
						["Clickable08.OGG"] = 02.42,
						["Clickable09.OGG"] = 02.50,
						["Clickable10.OGG"] = 01.79,
						["Custom01.OGG"] = 06.43,
						["Death01.OGG"] = 07.50,
						["Death02.OGG"] = 08.93,
						["Death03.OGG"] = 08.17,
						["Wound01.OGG"] = 02.04,
						["Wound02.OGG"] = 01.84,
						["Wound03.OGG"] = 02.33,
					},
				},
				["Baine\\VO_"] = {
					["Baine_"] = {
						["Aggro01.ogg"] = 04.83,
						["Aggro02.ogg"] = 03.26,
						["Attack01.ogg"] = 00.68,
						["Attack02.ogg"] = 00.79,
						["Attack03.ogg"] = 00.49,
						["Attack04.ogg"] = 00.48,
						["Attack05.ogg"] = 00.59,
						["Attack06.ogg"] = 00.63,
						["Attack07.ogg"] = 00.80,
						["Attack08.ogg"] = 00.46,
						["Attack09.ogg"] = 00.51,
						["Attack10.ogg"] = 00.42,
						["AttackCritical01.ogg"] = 01.20,
						["AttackCritical02.ogg"] = 01.06,
						["AttackCritical03.ogg"] = 01.13,
						["AttackCritical04.ogg"] = 01.19,
						["AttackCritical05.ogg"] = 01.62,
						["Death01.ogg"] = 02.55,
						["Death02.ogg"] = 02.23,
						["Death03.ogg"] = 03.30,
						["Event01.ogg"] = 01.28,
						["Event02.ogg"] = 09.66,
						["Event03.ogg"] = 05.50,
						["Event04.ogg"] = 06.43,
						["Event05.ogg"] = 01.78,
						["Event06.ogg"] = 01.42,
						["Greeting01.ogg"] = 06.29,
						["Greeting02.ogg"] = 05.32,
						["Greeting03.ogg"] = 02.80,
						["Greeting04.ogg"] = 06.99,
						["Kill01.ogg"] = 01.30,
						["Kill02.ogg"] = 01.51,
						["Spawn01.ogg"] = 02.81,
						["Wound01.ogg"] = 00.42,
						["Wound02.ogg"] = 00.48,
						["Wound03.ogg"] = 00.53,
						["Wound04.ogg"] = 00.44,
						["Wound05.ogg"] = 00.36,
						["Wound06.ogg"] = 00.44,
						["Wound07.ogg"] = 00.67,
						["Wound08.ogg"] = 00.45,
						["Wound09.ogg"] = 00.56,
						["WoundCritical01.ogg"] = 01.35,
						["WoundCritical02.ogg"] = 01.28,
						["WoundCritical03.ogg"] = 00.74,
						["WoundCritical04.ogg"] = 01.16,
						["WoundCritical05.ogg"] = 01.19,
					},
					["ET_ECHOOFBAINE_"] = {
						["SLAY_"] = {
							["01.OGG"] = 02.35,
							["02.OGG"] = 01.91,
							["03.OGG"] = 02.57,
						},
						["SPELL_"] = {
							["01.OGG"] = 02.19,
							["02.OGG"] = 02.77,
						},
						["AGGRO_01.OGG"] = 07.39,
						["DEATH_01.OGG"] = 10.95,
						["INTRO_01.OGG"] = 05.51,
					},
				},
				["BaineBloodhoof\\VO_"] = {
					["53_Baine_"] = {
						["Razor_Finale_"] = {
							["01.OGG"] = 08.00,
							["02.OGG"] = 05.61,
							["03.OGG"] = 07.93,
							["04.OGG"] = 08.65,
							["05.OGG"] = 07.66,
							["06.OGG"] = 07.05,
						},
					},
					["54_OR_"] = {
						["BAINE_"] = {
							["EVENT_"] = {
								["01.OGG"] = 03.29,
								["02.OGG"] = 06.56,
								["03.OGG"] = 02.44,
								["04.OGG"] = 01.35,
								["05.OGG"] = 02.57,
								["06.OGG"] = 02.79,
							},
							["INTRO_"] = {
								["1.OGG"] = 02.19,
								["2.OGG"] = 05.07,
								["3.OGG"] = 02.69,
							},
						},
					},
				},
				["BALEROC\\VO_"] = {
					["FL_BALEROC_"] = {
						["EVENT_"] = {
							["01.ogg"] = 07.54,
							["02.ogg"] = 07.14,
							["03.ogg"] = 06.73,
						},
						["KILL_"] = {
							["01.ogg"] = 04.39,
							["02.ogg"] = 03.57,
							["03.ogg"] = 05.72,
							["04.ogg"] = 04.58,
							["05.ogg"] = 04.90,
						},
						["LAUGH_"] = {
							["01.ogg"] = 06.19,
							["02.ogg"] = 05.93,
						},
						["AGGRO.ogg"] = 06.55,
						["ATTACK01.ogg"] = 01.91,
						["ATTACK02.ogg"] = 02.27,
						["ATTACK03.ogg"] = 02.22,
						["ATTACK04.ogg"] = 01.90,
						["ATTACK05.ogg"] = 01.85,
						["ATTACK06.ogg"] = 01.74,
						["ATTACK07.ogg"] = 01.80,
						["ATTACK08.ogg"] = 02.33,
						["ATTACK09.ogg"] = 02.60,
						["ATTACKCRIT01.ogg"] = 03.26,
						["ATTACKCRIT02.ogg"] = 03.11,
						["ATTACKCRIT03.ogg"] = 02.76,
						["ATTACKCRIT04.ogg"] = 03.12,
						["ATTACKCRIT05.ogg"] = 03.44,
						["DEATH.ogg"] = 07.96,
						["SPELLCAST01.ogg"] = 01.65,
						["SPELLCAST02.ogg"] = 01.99,
						["SPELLCAST03.ogg"] = 01.49,
						["SPELLCAST04.ogg"] = 02.14,
						["WOUND01.ogg"] = 01.62,
						["WOUND02.ogg"] = 01.55,
						["WOUND03.ogg"] = 01.77,
						["WOUND04.ogg"] = 01.74,
						["WOUND05.ogg"] = 01.52,
						["WOUND06.ogg"] = 01.67,
						["WOUND07.ogg"] = 01.32,
						["WOUND08.ogg"] = 01.20,
						["WOUND09.ogg"] = 01.40,
						["WOUND10.ogg"] = 01.44,
						["WOUNDCRIT01.ogg"] = 02.32,
						["WOUNDCRIT02.ogg"] = 01.75,
						["WOUNDCRIT03.ogg"] = 03.06,
						["WOUNDCRIT04.ogg"] = 02.27,
						["WOUNDCRIT05.ogg"] = 02.23,
					},
					["QUEST_42_"] = {
						["BALEROC_TAUNT_"] = {
							["01.ogg"] = 05.75,
							["02.ogg"] = 05.64,
							["03.ogg"] = 05.60,
							["04.ogg"] = 05.80,
						},
					},
				},
				["baltharus\\RS_"] = {
					["Baltharus_"] = {
						["Aggro01.ogg"] = 05.28,
						["Attack01.ogg"] = 02.41,
						["Attack02.ogg"] = 01.53,
						["Attack03.ogg"] = 01.08,
						["Attack04.ogg"] = 01.09,
						["Attack05.ogg"] = 01.60,
						["Attack06.ogg"] = 01.02,
						["Attack07.ogg"] = 01.06,
						["Death01.ogg"] = 04.07,
						["Slay01.ogg"] = 04.47,
						["Slay02.ogg"] = 03.25,
						["Special01.ogg"] = 03.34,
						["Wound01.ogg"] = 01.22,
						["Wound02.ogg"] = 00.87,
						["Wound03.ogg"] = 00.85,
						["Wound04.ogg"] = 00.80,
						["Wound05.ogg"] = 01.09,
						["Yell01.ogg"] = 07.88,
					},
				},
				["BanBearheart\\VO_"] = {
					["BanBearheart_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.08,
							["02.OGG"] = 01.06,
							["03.OGG"] = 01.57,
							["04.OGG"] = 01.41,
							["05.OGG"] = 01.11,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.63,
							["02.OGG"] = 00.55,
							["03.OGG"] = 00.63,
							["04.OGG"] = 00.67,
							["05.OGG"] = 00.63,
							["06.OGG"] = 00.73,
							["07.OGG"] = 00.67,
							["08.OGG"] = 00.68,
							["09.OGG"] = 00.87,
						},
						["Death_"] = {
							["01.OGG"] = 02.90,
							["02.OGG"] = 02.01,
							["03.OGG"] = 01.64,
							["04.OGG"] = 03.32,
							["05.OGG"] = 02.28,
							["06.OGG"] = 02.17,
							["07.OGG"] = 02.26,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.75,
							["02.OGG"] = 01.07,
							["03.OGG"] = 01.85,
							["04.OGG"] = 02.13,
							["05.OGG"] = 02.47,
						},
						["Wound_"] = {
							["01.OGG"] = 00.58,
							["02.OGG"] = 00.86,
							["03.OGG"] = 00.67,
							["04.OGG"] = 00.65,
							["05.OGG"] = 00.69,
							["06.OGG"] = 00.52,
							["07.OGG"] = 00.59,
							["08.OGG"] = 00.99,
						},
					},
					["Ban_"] = {
						["Farewell_"] = {
							["01.OGG"] = 00.73,
							["02.OGG"] = 00.67,
						},
						["Greeting_"] = {
							["01.OGG"] = 00.62,
							["02.OGG"] = 01.44,
							["03.OGG"] = 01.46,
							["04.OGG"] = 01.15,
							["05.OGG"] = 01.61,
						},
						["Pissed_"] = {
							["01.OGG"] = 00.67,
							["02.OGG"] = 01.59,
							["03.OGG"] = 01.79,
							["04.OGG"] = 02.40,
							["05.OGG"] = 03.67,
							["06.OGG"] = 02.41,
							["07.OGG"] = 02.20,
						},
						["ShadoPan_Finale_"] = {
							["01.OGG"] = 01.77,
							["02.OGG"] = 03.60,
							["03.OGG"] = 02.17,
							["04.OGG"] = 02.06,
							["05.OGG"] = 01.24,
							["06.OGG"] = 00.87,
							["07.OGG"] = 03.86,
							["08.OGG"] = 06.54,
							["09.OGG"] = 03.65,
							["10.OGG"] = 03.14,
							["11.OGG"] = 01.35,
							["12.OGG"] = 00.87,
							["13.OGG"] = 02.74,
						},
					},
					["Caravan_Ban_"] = {
						["01.OGG"] = 04.38,
						["02.OGG"] = 02.09,
						["03.OGG"] = 03.30,
						["04.OGG"] = 02.18,
						["05.OGG"] = 01.44,
						["06.OGG"] = 03.06,
						["07.OGG"] = 02.24,
						["08.OGG"] = 04.94,
					},
					["Event1_Ban_"] = {
						["01.OGG"] = 04.35,
						["02.OGG"] = 06.43,
						["03.OGG"] = 05.56,
					},
					["Event3_Ban_"] = {
						["01.OGG"] = 05.19,
						["02.OGG"] = 08.03,
						["03.OGG"] = 05.53,
						["04.OGG"] = 03.03,
					},
					["Kun_Lai_"] = {
						["Ban_"] = {
							["Balloon_Ride_"] = {
								["01.OGG"] = 02.41,
								["02.OGG"] = 02.04,
								["03.OGG"] = 04.32,
								["04.OGG"] = 08.17,
								["05.OGG"] = 06.47,
								["06.OGG"] = 07.66,
								["07.OGG"] = 07.79,
								["08.OGG"] = 07.96,
								["09.OGG"] = 08.06,
								["10.OGG"] = 09.70,
								["11.OGG"] = 08.01,
								["12.OGG"] = 02.82,
							},
							["Gates_"] = {
								["Event_"] = {
									["01.OGG"] = 04.00,
									["02.OGG"] = 03.81,
									["03.OGG"] = 08.86,
								},
								["Quest_01.OGG"] = 07.18,
							},
						},
					},
				},
				["BanelingPet\\PET_"] = {
					["Baneling_"] = {
						["Attack_"] = {
							["01.OGG"] = 01.73,
							["02.OGG"] = 01.97,
							["03.OGG"] = 01.11,
						},
						["Clickable_"] = {
							["01.OGG"] = 01.99,
							["02.OGG"] = 01.79,
							["03.OGG"] = 02.28,
							["04.OGG"] = 01.46,
							["05.OGG"] = 01.45,
							["06.OGG"] = 01.68,
							["07.OGG"] = 01.56,
						},
						["Death_"] = {
							["01.OGG"] = 01.99,
							["02.OGG"] = 01.94,
							["03.OGG"] = 02.00,
							["04.OGG"] = 02.11,
							["05.OGG"] = 02.12,
						},
						["Explosion_"] = {
							["01.OGG"] = 03.27,
							["02.OGG"] = 03.16,
							["03.OGG"] = 03.01,
						},
						["Movement_"] = {
							["01.OGG"] = 04.00,
							["02.OGG"] = 04.00,
							["03.OGG"] = 04.00,
						},
						["Wound_"] = {
							["01.OGG"] = 01.28,
							["02.OGG"] = 01.42,
							["03.OGG"] = 01.28,
						},
					},
				},
				["Banshee\\"] = {
					["BansheeAggroA.ogg"] = 02.27,
					["BansheeAttackA.ogg"] = 02.80,
					["BansheeAttackB.ogg"] = 03.00,
					["BansheeAttackC.ogg"] = 02.57,
					["BansheeDeathA.ogg"] = 05.00,
					["BansheePreAggroA.ogg"] = 01.87,
					["BansheeWoundA.ogg"] = 02.00,
					["BansheeWoundB.ogg"] = 02.24,
					["BansheeWoundC.ogg"] = 02.50,
					["BansheeWoundCrit.ogg"] = 02.80,
				},
				["Barim\\VO_"] = {
					["TV_Barim_"] = {
						["Attack01.ogg"] = 00.64,
						["Attack02.ogg"] = 01.14,
						["Attack03.ogg"] = 00.50,
						["Attack04.ogg"] = 00.72,
						["Attack05.ogg"] = 00.50,
						["Attack06.ogg"] = 00.86,
						["Attack07.ogg"] = 00.78,
						["Attack08.ogg"] = 00.78,
						["Attack09.ogg"] = 00.78,
						["Attack10.ogg"] = 00.99,
						["AttackCritical01.ogg"] = 00.74,
						["AttackCritical02.ogg"] = 01.42,
						["AttackCritical03.ogg"] = 00.58,
						["AttackCritical04.ogg"] = 01.75,
						["AttackCritical05.ogg"] = 00.62,
						["Death01.ogg"] = 02.57,
						["Death02.ogg"] = 02.70,
						["Death03.ogg"] = 01.29,
						["Death04.ogg"] = 03.24,
						["Death05.ogg"] = 03.60,
						["DeathLine01.ogg"] = 04.90,
						["Engage01.ogg"] = 04.71,
						["Event01.ogg"] = 02.06,
						["Event02.ogg"] = 03.33,
						["Kill01.ogg"] = 02.46,
						["Wound01.ogg"] = 00.35,
						["Wound02.ogg"] = 00.39,
						["Wound03.ogg"] = 00.33,
						["Wound04.ogg"] = 00.28,
						["Wound05.ogg"] = 00.34,
						["Wound06.ogg"] = 00.56,
						["Wound07.ogg"] = 00.39,
						["Wound08.ogg"] = 00.46,
						["Wound09.ogg"] = 00.69,
						["Wound10.ogg"] = 00.70,
						["WoundCritical01.ogg"] = 01.14,
						["WoundCritical02.ogg"] = 01.03,
						["WoundCritical03.ogg"] = 00.81,
						["WoundCritical04.ogg"] = 01.12,
						["WoundCritical05.ogg"] = 01.04,
						["WoundCritical06.ogg"] = 00.76,
					},
				},
				["BarnesTheStageManager\\"] = {
					["AudienceReaction01.ogg"] = 02.41,
					["AudienceReaction02.ogg"] = 01.62,
					["AudienceReaction03.ogg"] = 02.76,
					["BarnesAudienceApplause.ogg"] = 10.42,
					["HoodAmbience.ogg"] = 43.00,
					["HoodAmbienceLonger.ogg"] = 47.99,
					["HoodAnnounce01.ogg"] = 06.68,
					["HoodAnnounce02.ogg"] = 10.27,
					["HoodAnnounce03.ogg"] = 14.07,
					["HoodAnnounce04.ogg"] = 13.95,
					["OzAmbience.ogg"] = 33.98,
					["OzAmbienceLonger.ogg"] = 50.32,
					["OzAnnounce01.ogg"] = 06.52,
					["OzAnnounce02.ogg"] = 18.03,
					["OzAnnounce03.ogg"] = 09.38,
					["OzAnnounce04.ogg"] = 13.04,
					["RajAmbience.ogg"] = 24.00,
					["RajAmbienceLonger.ogg"] = 43.00,
					["RajAnnounce01.ogg"] = 05.90,
					["RajAnnounce02.ogg"] = 07.42,
					["RajAnnounce03.ogg"] = 14.07,
					["RajAnnounce04.ogg"] = 13.57,
				},
				["BaronRevilgaz\\"] = {
					["BaronRevilgazAggro01.ogg"] = 03.01,
					["BaronRevilgazAggro02.ogg"] = 02.18,
					["BaronRevilgazGreeting01.ogg"] = 05.06,
					["BaronRevilgazGreeting02.ogg"] = 02.11,
					["BaronRevilgazGreeting03.ogg"] = 01.46,
					["BaronRevilgazGreeting04.ogg"] = 02.17,
				},
				["BaronRivendare\\"] = {
					["NX_Rive_"] = {
						["Attack01.ogg"] = 01.03,
						["Attack02.ogg"] = 00.67,
						["Attack03.ogg"] = 00.91,
						["Attack04.ogg"] = 00.78,
						["Attack05.ogg"] = 01.22,
						["Attack06.ogg"] = 01.03,
						["Attack07.ogg"] = 00.82,
						["Attack08.ogg"] = 01.13,
						["Wound01.ogg"] = 00.68,
						["Wound02.ogg"] = 00.50,
						["Wound03.ogg"] = 00.79,
						["Wound04.ogg"] = 00.57,
						["Wound05.ogg"] = 00.95,
						["Wound06.ogg"] = 00.81,
						["WoundCrit01.ogg"] = 01.01,
						["WoundCrit02.ogg"] = 01.19,
						["WoundCrit03.ogg"] = 01.30,
						["WoundCrit04.ogg"] = 01.22,
						["WoundCrit05.ogg"] = 01.42,
					},
					["RIVENDAREAGGRO01.ogg"] = 01.46,
					["RIVENDAREAGGRO02.ogg"] = 01.56,
					["RIVENDAREAGGRO03.ogg"] = 01.03,
					["RIVENDAREDEATH.ogg"] = 03.86,
					["RIVENDARESLAY01.ogg"] = 02.68,
					["RIVENDARESLAY02.ogg"] = 02.28,
					["RIVENDARESPECIAL.ogg"] = 02.44,
					["RIVENDARETAUNT01.ogg"] = 05.59,
					["RIVENDARETAUNT02.ogg"] = 08.22,
					["RIVENDARETAUNT03.ogg"] = 05.06,
				},
				["Baros\\VO_"] = {
					["60_"] = {
						["SMV_"] = {
							["BAROS_"] = {
								["FAREWELL_"] = {
									["01.ogg"] = 00.58,
									["02.ogg"] = 01.05,
									["03.ogg"] = 01.51,
									["04.ogg"] = 01.05,
									["05.ogg"] = 01.44,
								},
								["GREETING_"] = {
									["01.ogg"] = 00.91,
									["02.ogg"] = 00.90,
									["03.ogg"] = 00.78,
									["04.ogg"] = 01.62,
									["05.ogg"] = 01.56,
								},
								["PISSED_01.ogg"] = 10.73,
							},
							["GARR_"] = {
								["BARR_BAROS_"] = {
									["01.ogg"] = 02.17,
									["02.ogg"] = 06.61,
								},
								["LUMBER_BAROS_"] = {
									["01.ogg"] = 03.31,
									["02.ogg"] = 02.93,
								},
								["RAVEN_BAROS_"] = {
									["01.ogg"] = 05.32,
									["02.ogg"] = 06.32,
								},
								["SHIP_BAROS_"] = {
									["01.ogg"] = 04.97,
									["02.ogg"] = 09.51,
								},
								["WORK_BAROS_"] = {
									["01.ogg"] = 05.68,
									["02.ogg"] = 06.71,
								},
								["START_BAROS_01.ogg"] = 05.05,
							},
						},
						["TLD_BAROS_"] = {
							["GARRISON_"] = {
								["01.ogg"] = 06.19,
								["02.ogg"] = 05.60,
								["03.ogg"] = 03.90,
							},
						},
					},
				},
				["Basilisk\\"] = {
					["mBasiliskAggroA.ogg"] = 03.00,
					["mBasiliskAttackA.ogg"] = 01.42,
					["mBasiliskAttackB.ogg"] = 01.13,
					["mBasiliskAttackC.ogg"] = 01.50,
					["mBasiliskDeath1A.ogg"] = 02.06,
					["mBasiliskDeath2A.ogg"] = 03.47,
					["mBasiliskSpellCastA.ogg"] = 02.10,
					["mBasiliskSpellCastB.ogg"] = 01.76,
					["mBasiliskStand2A.ogg"] = 01.61,
					["mBasiliskStand3A.ogg"] = 01.95,
					["mBasiliskWoundA.ogg"] = 01.19,
					["mBasiliskWoundB.ogg"] = 01.02,
					["mBasiliskWoundC.ogg"] = 01.00,
					["mBasiliskWoundCriticalA.ogg"] = 01.24,
				},
				["Bathiel\\VO_"] = {
					["60_"] = {
						["BATHIEL_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 02.39,
								["02.ogg"] = 01.75,
								["03.ogg"] = 01.07,
								["04.ogg"] = 01.45,
								["05.ogg"] = 00.92,
							},
							["Attack_"] = {
								["01.ogg"] = 00.76,
								["010.ogg"] = 00.75,
								["02.ogg"] = 00.84,
								["03.ogg"] = 01.50,
								["04.ogg"] = 00.74,
								["05.ogg"] = 00.77,
								["06.ogg"] = 00.80,
								["07.ogg"] = 00.89,
								["08.ogg"] = 00.80,
								["09.ogg"] = 00.75,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.80,
								["02.ogg"] = 02.08,
								["03.ogg"] = 01.61,
								["04.ogg"] = 01.56,
								["05.ogg"] = 02.04,
							},
							["Wound_"] = {
								["01.ogg"] = 00.91,
								["010.ogg"] = 00.95,
								["02.ogg"] = 00.92,
								["03.ogg"] = 01.17,
								["04.ogg"] = 00.80,
								["05.ogg"] = 00.87,
								["06.ogg"] = 00.78,
								["07.ogg"] = 00.99,
								["08.ogg"] = 00.88,
								["09.ogg"] = 01.22,
							},
						},
						["BFD_BATHIEL_"] = {
							["INTRO_"] = {
								["01.ogg"] = 08.12,
								["02.ogg"] = 07.68,
							},
							["AGGRO.ogg"] = 07.87,
							["DEATH.ogg"] = 08.18,
						},
					},
				},
				["Battlesaur\\MON_"] = {
					["Battlesaur_"] = {
						["Aggro_"] = {
							["01.OGG"] = 02.64,
							["02.OGG"] = 02.64,
							["03.OGG"] = 02.77,
							["04.OGG"] = 02.72,
							["05.OGG"] = 03.28,
							["06.OGG"] = 02.23,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 02.29,
							["02.OGG"] = 02.26,
							["03.OGG"] = 02.31,
							["04.OGG"] = 02.11,
							["05.OGG"] = 02.27,
							["06.OGG"] = 02.22,
						},
						["Attack_"] = {
							["01.OGG"] = 01.72,
							["02.OGG"] = 01.77,
							["03.OGG"] = 01.94,
							["04.OGG"] = 01.64,
							["05.OGG"] = 02.02,
							["06.OGG"] = 01.86,
							["07.OGG"] = 02.32,
							["08.OGG"] = 01.78,
							["09.OGG"] = 02.00,
							["10.OGG"] = 01.85,
						},
						["BattleRoar_"] = {
							["01.OGG"] = 04.17,
							["02.OGG"] = 04.04,
							["03.OGG"] = 04.08,
							["04.OGG"] = 04.17,
							["05.OGG"] = 04.42,
							["06.OGG"] = 04.42,
							["07.OGG"] = 04.80,
							["08.OGG"] = 04.34,
							["09.OGG"] = 04.54,
							["10.OGG"] = 04.72,
						},
						["Death_"] = {
							["01.OGG"] = 03.56,
							["02.OGG"] = 03.93,
							["03.OGG"] = 03.86,
							["04.OGG"] = 03.95,
							["05.OGG"] = 04.19,
							["06.OGG"] = 03.41,
							["07.OGG"] = 03.91,
						},
						["PiercingRoar_"] = {
							["01.OGG"] = 05.19,
							["02.OGG"] = 05.84,
							["03.OGG"] = 05.93,
						},
						["PreAggro_"] = {
							["01.OGG"] = 03.27,
							["02.OGG"] = 04.08,
							["03.OGG"] = 04.34,
							["04.OGG"] = 03.10,
							["05.OGG"] = 04.69,
							["06.OGG"] = 04.71,
							["07.OGG"] = 03.96,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.72,
							["02.OGG"] = 01.70,
							["03.OGG"] = 01.74,
							["04.OGG"] = 01.57,
							["05.OGG"] = 01.70,
						},
						["Wound_"] = {
							["01.OGG"] = 01.94,
							["02.OGG"] = 01.79,
							["03.OGG"] = 01.85,
							["04.OGG"] = 01.28,
							["05.OGG"] = 01.43,
							["06.OGG"] = 01.70,
							["07.OGG"] = 01.85,
							["08.OGG"] = 01.54,
						},
					},
				},
				["Bear\\"] = {
					["mBearAggroA.ogg"] = 03.17,
					["mBearAttackA.ogg"] = 00.84,
					["mBearAttackB.ogg"] = 00.78,
					["mBearAttackCriticalA.ogg"] = 00.95,
					["mBearAttackD.ogg"] = 01.42,
					["mBearDeathA.ogg"] = 02.65,
					["mBearWoundA.ogg"] = 00.62,
					["mBearWoundB.ogg"] = 00.59,
					["mBearWoundC.ogg"] = 00.60,
					["mBearWoundCriticalA.ogg"] = 01.27,
				},
				["Beatface\\VO_"] = {
					["60_"] = {
						["BEATFACE_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.80,
								["02.ogg"] = 02.05,
								["03.ogg"] = 01.55,
								["04.ogg"] = 01.19,
								["05.ogg"] = 01.49,
							},
							["Attack_"] = {
								["01.ogg"] = 00.75,
								["010.ogg"] = 00.48,
								["02.ogg"] = 00.57,
								["03.ogg"] = 00.83,
								["04.ogg"] = 00.69,
								["05.ogg"] = 00.66,
								["06.ogg"] = 00.57,
								["07.ogg"] = 00.48,
								["08.ogg"] = 01.04,
								["09.ogg"] = 00.68,
							},
							["Death_"] = {
								["01.ogg"] = 03.24,
								["02.ogg"] = 02.42,
								["03.ogg"] = 02.51,
								["04.ogg"] = 03.52,
								["05.ogg"] = 04.28,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.61,
								["02.ogg"] = 01.15,
								["03.ogg"] = 02.88,
								["04.ogg"] = 01.06,
								["05.ogg"] = 01.03,
							},
							["Wound_"] = {
								["01.ogg"] = 00.67,
								["010.ogg"] = 00.74,
								["02.ogg"] = 00.48,
								["03.ogg"] = 00.59,
								["04.ogg"] = 01.13,
								["05.ogg"] = 00.47,
								["06.ogg"] = 00.51,
								["07.ogg"] = 00.52,
								["08.ogg"] = 00.47,
								["09.ogg"] = 00.46,
							},
						},
						["GLADIATOR_BEATFACE_"] = {
							["EXIT_"] = {
								["FAIL.ogg"] = 02.33,
								["HIGH.ogg"] = 02.84,
								["MID.ogg"] = 01.99,
							},
							["ONKILL_"] = {
								["01.ogg"] = 05.71,
								["02.ogg"] = 02.67,
							},
							["ENTRANCE_01.ogg"] = 02.05,
						},
					},
				},
				["BEAVER\\MON_"] = {
					["Beaver_"] = {
						["Aggro_"] = {
							["01.OGG"] = 00.92,
							["02.OGG"] = 00.76,
							["03.OGG"] = 01.07,
							["04.OGG"] = 00.81,
							["05.OGG"] = 01.09,
							["06.OGG"] = 01.03,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.04,
							["02.OGG"] = 00.74,
							["03.OGG"] = 00.79,
							["04.OGG"] = 01.28,
							["05.OGG"] = 00.93,
						},
						["Attack_"] = {
							["01.OGG"] = 01.41,
							["02.OGG"] = 01.00,
							["03.OGG"] = 01.16,
							["04.OGG"] = 01.23,
							["05.OGG"] = 00.66,
							["06.OGG"] = 00.74,
							["07.OGG"] = 00.70,
							["08.OGG"] = 00.97,
							["09.OGG"] = 00.69,
							["10.OGG"] = 01.03,
						},
						["Death_"] = {
							["01.OGG"] = 01.16,
							["02.OGG"] = 01.08,
							["03.OGG"] = 01.19,
							["04.OGG"] = 01.14,
							["05.OGG"] = 01.26,
							["06.OGG"] = 01.24,
							["07.OGG"] = 01.19,
							["08.OGG"] = 01.15,
						},
						["PreAggro_"] = {
							["01.OGG"] = 00.41,
							["02.OGG"] = 00.75,
							["03.OGG"] = 00.81,
							["04.OGG"] = 00.94,
							["05.OGG"] = 00.75,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.92,
							["02.OGG"] = 00.73,
							["03.OGG"] = 00.78,
							["04.OGG"] = 00.78,
							["05.OGG"] = 01.00,
						},
						["Wound_"] = {
							["01.OGG"] = 00.62,
							["02.OGG"] = 00.55,
							["03.OGG"] = 00.73,
							["04.OGG"] = 00.75,
							["05.OGG"] = 00.73,
							["06.OGG"] = 00.72,
							["07.OGG"] = 00.87,
							["08.OGG"] = 00.57,
							["09.OGG"] = 00.67,
							["10.OGG"] = 00.72,
						},
					},
				},
				["BeerSpiritLarge\\MON_"] = {
					["BeerSpirit_Large_"] = {
						["Aggro01.OGG"] = 02.79,
						["Aggro02.OGG"] = 02.44,
						["Aggro03.OGG"] = 02.29,
						["Aggro04.OGG"] = 02.42,
						["Aggro05.OGG"] = 02.79,
						["Attack01.OGG"] = 02.98,
						["Attack02.OGG"] = 03.00,
						["Attack03.OGG"] = 02.20,
						["Attack04.OGG"] = 02.64,
						["Attack05.OGG"] = 03.08,
						["Attack06.OGG"] = 02.82,
						["Attack07.OGG"] = 02.70,
						["Attack08.OGG"] = 02.95,
						["Attack09.OGG"] = 03.14,
						["Attack10.OGG"] = 02.39,
						["AttackCrit01.OGG"] = 02.56,
						["AttackCrit02.OGG"] = 02.60,
						["AttackCrit03.OGG"] = 02.70,
						["AttackCrit04.OGG"] = 02.86,
						["AttackCrit05.OGG"] = 03.73,
						["Death01.OGG"] = 06.59,
						["Death02.OGG"] = 06.18,
						["Death03.OGG"] = 04.82,
						["Death04.OGG"] = 04.83,
						["Death05.OGG"] = 07.28,
						["Wound01.OGG"] = 02.37,
						["Wound02.OGG"] = 02.31,
						["Wound03.OGG"] = 01.55,
						["Wound04.OGG"] = 01.87,
						["Wound05.OGG"] = 02.01,
						["Wound06.OGG"] = 02.17,
						["Wound07.OGG"] = 01.96,
						["Wound08.OGG"] = 01.74,
						["Wound09.OGG"] = 02.36,
						["Wound10.OGG"] = 02.53,
						["WoundCrit01.OGG"] = 02.56,
						["WoundCrit02.OGG"] = 03.76,
						["WoundCrit03.OGG"] = 03.04,
						["WoundCrit04.OGG"] = 02.47,
						["WoundCrit05.OGG"] = 02.93,
					},
				},
				["BeerSpiritMedium\\MON_"] = {
					["BeerSpirit_Medium_"] = {
						["Aggro01.OGG"] = 02.47,
						["Aggro02.OGG"] = 02.33,
						["Aggro03.OGG"] = 02.28,
						["Aggro04.OGG"] = 02.32,
						["Aggro05.OGG"] = 02.49,
						["Attack01.OGG"] = 02.82,
						["Attack02.OGG"] = 02.55,
						["Attack03.OGG"] = 02.04,
						["Attack04.OGG"] = 02.14,
						["Attack05.OGG"] = 03.18,
						["Attack06.OGG"] = 02.74,
						["Attack07.OGG"] = 02.30,
						["Attack08.OGG"] = 02.53,
						["Attack09.OGG"] = 03.08,
						["Attack10.OGG"] = 02.35,
						["AttackCrit01.OGG"] = 02.31,
						["AttackCrit02.OGG"] = 02.42,
						["AttackCrit03.OGG"] = 02.49,
						["AttackCrit04.OGG"] = 02.44,
						["AttackCrit05.OGG"] = 02.97,
						["Death01.OGG"] = 06.05,
						["Death02.OGG"] = 06.19,
						["Death03.OGG"] = 04.48,
						["Death04.OGG"] = 04.73,
						["Death05.OGG"] = 05.93,
						["Wound01.OGG"] = 02.02,
						["Wound02.OGG"] = 01.74,
						["Wound03.OGG"] = 01.47,
						["Wound04.OGG"] = 01.69,
						["Wound05.OGG"] = 01.78,
						["Wound06.OGG"] = 01.94,
						["Wound07.OGG"] = 01.59,
						["Wound08.OGG"] = 01.65,
						["Wound09.OGG"] = 02.09,
						["Wound10.OGG"] = 02.20,
						["WoundCrit01.OGG"] = 02.58,
						["WoundCrit02.OGG"] = 02.95,
						["WoundCrit03.OGG"] = 02.45,
						["WoundCrit04.OGG"] = 02.32,
						["WoundCrit05.OGG"] = 02.65,
					},
				},
				["Beholder\\"] = {
					["BeholderAggro.ogg"] = 02.32,
					["BeholderAttackA.ogg"] = 01.96,
					["BeholderAttackB.ogg"] = 02.11,
					["BeholderAttackC.ogg"] = 02.11,
					["BeholderAttackD.ogg"] = 01.62,
					["BeholderAttackE.ogg"] = 02.28,
					["BeholderDeath.ogg"] = 05.74,
					["BeholderPreAggro.ogg"] = 02.02,
					["BeholderWoundA.ogg"] = 01.27,
					["BeholderWoundB.ogg"] = 01.32,
					["BeholderWoundC.ogg"] = 01.57,
					["BeholderWoundCrit.ogg"] = 02.09,
					["BeholderWoundD.ogg"] = 01.58,
				},
				["Benedictus\\VO_"] = {
					["GB_DT_"] = {
						["Benedictus_"] = {
							["Attack01.ogg"] = 00.57,
							["Attack02.ogg"] = 00.71,
							["Attack03.ogg"] = 00.79,
							["Attack04.ogg"] = 00.72,
							["Attack05.ogg"] = 00.44,
							["Attack06.ogg"] = 00.61,
							["Attack07.ogg"] = 00.70,
							["Attack08.ogg"] = 00.55,
							["Attack09.ogg"] = 00.59,
							["Attack10.ogg"] = 00.69,
							["AttackCritical01.ogg"] = 00.65,
							["AttackCritical02.ogg"] = 00.65,
							["AttackCritical03.ogg"] = 01.04,
							["AttackCritical04.ogg"] = 01.01,
							["AttackCritical05.ogg"] = 00.89,
							["Death01.ogg"] = 01.93,
							["Death02.ogg"] = 01.75,
							["Death03.ogg"] = 02.44,
							["Death04.ogg"] = 01.84,
							["Event01.ogg"] = 03.67,
							["Event02.ogg"] = 08.45,
							["Event03.ogg"] = 08.24,
							["Event04.ogg"] = 09.22,
							["Event05.ogg"] = 08.67,
							["Event06.ogg"] = 02.30,
							["Event06A.ogg"] = 02.72,
							["Event06B.ogg"] = 03.26,
							["Wound01.ogg"] = 00.70,
							["Wound02.ogg"] = 00.95,
							["Wound03.ogg"] = 00.85,
							["Wound04.ogg"] = 00.94,
							["Wound05.ogg"] = 00.84,
							["Wound06.ogg"] = 00.80,
							["Wound07.ogg"] = 00.96,
							["Wound08.ogg"] = 00.71,
							["Wound09.ogg"] = 00.58,
							["Wound10.ogg"] = 00.67,
							["WoundCritical01.ogg"] = 00.97,
							["WoundCritical02.ogg"] = 01.67,
							["WoundCritical03.ogg"] = 01.21,
							["WoundCritical04.ogg"] = 01.12,
							["WoundCritical05.ogg"] = 01.10,
						},
					},
					["HOT_BENEDICTUS_"] = {
						["EVENT_"] = {
							["01.OGG"] = 03.05,
							["02.OGG"] = 05.05,
						},
						["SPELL_"] = {
							["01.OGG"] = 03.28,
							["02.OGG"] = 03.18,
						},
						["DEATH_01.OGG"] = 10.21,
					},
				},
				["Bethtilac\\MON_"] = {
					["FireSpiderBoss_"] = {
						["Aggro_"] = {
							["01.ogg"] = 01.54,
							["02.ogg"] = 01.72,
							["03.ogg"] = 01.98,
						},
						["Attack_"] = {
							["01.ogg"] = 02.05,
							["02.ogg"] = 01.74,
							["03.ogg"] = 02.20,
							["04.ogg"] = 01.97,
							["05.ogg"] = 01.45,
							["06.ogg"] = 01.99,
							["07.ogg"] = 02.04,
							["08.ogg"] = 01.27,
							["09.ogg"] = 01.98,
							["10.ogg"] = 02.06,
						},
						["Death_"] = {
							["01.ogg"] = 04.70,
							["02.ogg"] = 05.21,
							["03.ogg"] = 03.76,
							["04.ogg"] = 04.94,
							["05.ogg"] = 02.81,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.47,
							["02.ogg"] = 01.62,
							["03.ogg"] = 01.67,
							["04.ogg"] = 01.35,
							["05.ogg"] = 01.64,
						},
						["Wound_"] = {
							["01.ogg"] = 01.86,
							["02.ogg"] = 01.59,
							["03.ogg"] = 02.16,
							["04.ogg"] = 01.35,
							["05.ogg"] = 01.59,
							["06.ogg"] = 01.67,
							["07.ogg"] = 01.66,
							["08.ogg"] = 01.73,
							["09.ogg"] = 01.76,
							["10.ogg"] = 01.80,
						},
					},
				},
				["BE_Broom01\\"] = {
					["BE_"] = {
						["Broom01Death.ogg"] = 01.62,
						["Broom01Loop.ogg"] = 04.73,
					},
					["PET_BE_"] = {
						["Broom_"] = {
							["Attack01.OGG"] = 00.98,
							["Attack02.OGG"] = 00.78,
							["Attack03.OGG"] = 00.80,
							["Death01.OGG"] = 01.52,
							["Death02.OGG"] = 01.51,
							["Death03.OGG"] = 01.91,
							["Wound01.OGG"] = 00.50,
							["Wound02.OGG"] = 00.71,
							["Wound03.OGG"] = 00.66,
						},
					},
				},
				["Blackhand\\VO_"] = {
					["60_"] = {
						["BLACKHAND_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.37,
								["02.ogg"] = 01.99,
								["03.ogg"] = 02.67,
								["04.ogg"] = 02.87,
								["05.ogg"] = 02.41,
							},
							["Attack_"] = {
								["01.ogg"] = 00.90,
								["010.ogg"] = 01.03,
								["02.ogg"] = 01.53,
								["03.ogg"] = 00.96,
								["04.ogg"] = 00.71,
								["05.ogg"] = 00.97,
								["06.ogg"] = 01.03,
								["07.ogg"] = 00.91,
								["08.ogg"] = 00.80,
								["09.ogg"] = 00.96,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.76,
								["02.ogg"] = 00.86,
								["03.ogg"] = 01.74,
								["04.ogg"] = 01.67,
								["05.ogg"] = 01.64,
							},
							["Wound_"] = {
								["01.ogg"] = 00.77,
								["02.ogg"] = 00.67,
								["03.ogg"] = 00.77,
								["04.ogg"] = 00.88,
								["05.ogg"] = 00.97,
								["06.ogg"] = 00.77,
								["07.ogg"] = 01.11,
								["08.ogg"] = 01.32,
							},
						},
						["FR_"] = {
							["FINAL_BLACKHAND_"] = {
								["AGGRO.ogg"] = 06.12,
								["BERSERK.ogg"] = 02.86,
								["CEILING01.ogg"] = 04.84,
								["CEILING02.ogg"] = 04.16,
								["CEILING03.ogg"] = 08.05,
								["DEATH.ogg"] = 17.07,
								["FIRE01.ogg"] = 04.22,
								["FIRE02.ogg"] = 03.33,
								["FIRE03.ogg"] = 05.06,
								["FLOORDROP01.ogg"] = 03.49,
								["FLOORDROP02.ogg"] = 03.06,
								["FLOORDROP03.ogg"] = 04.18,
								["GUARDS01.ogg"] = 03.35,
								["GUARDS02.ogg"] = 02.73,
								["GUARDS03.ogg"] = 03.83,
								["INTRO.ogg"] = 12.47,
								["KILL01.ogg"] = 01.09,
								["KILL02.ogg"] = 02.66,
								["KILL03.ogg"] = 02.63,
								["KILL04.ogg"] = 01.78,
								["KILL05.ogg"] = 02.29,
								["PHASE01.ogg"] = 02.81,
								["PHASE02.ogg"] = 04.71,
								["PHASE02b.ogg"] = 04.58,
								["SIEGE01.ogg"] = 02.69,
								["SIEGE02.ogg"] = 04.55,
								["SIEGE03.ogg"] = 04.25,
								["SIEGE04.ogg"] = 03.14,
								["SLAG01.ogg"] = 07.39,
								["SLAG02.ogg"] = 04.85,
								["SLAG03.ogg"] = 05.99,
								["THROWHIT01.ogg"] = 01.76,
								["THROWHIT02.ogg"] = 01.75,
								["THROWHIT03.ogg"] = 02.39,
								["THROWHIT04.ogg"] = 04.22,
								["THROWMISS01.ogg"] = 01.54,
								["THROWMISS02.ogg"] = 02.64,
								["THROWMISS03.ogg"] = 02.36,
								["VEHICLE01.ogg"] = 02.60,
								["VEHICLE02.ogg"] = 03.83,
								["VEHICLE03.ogg"] = 05.26,
								["WING01.ogg"] = 09.86,
								["WING02.ogg"] = 08.30,
								["WING03.ogg"] = 10.44,
							},
							["FURNACE_PA_"] = {
								["EVENT_"] = {
									["3.ogg"] = 06.04,
									["4.ogg"] = 07.65,
									["7.ogg"] = 08.02,
								},
								["INTRO.ogg"] = 04.34,
							},
						},
						["NGD_SURPRISING_"] = {
							["BLACKHAND_"] = {
								["01.ogg"] = 06.15,
								["02.ogg"] = 03.88,
							},
						},
						["SHATTRATH_BLACKHAND_"] = {
							["01.ogg"] = 01.50,
							["02.ogg"] = 07.39,
							["03.ogg"] = 08.67,
						},
						["TAN_BLACKHAND_"] = {
							["01.ogg"] = 04.81,
							["02.ogg"] = 09.73,
							["03.ogg"] = 04.35,
						},
						["SMV_EXCORCISM_SHRAKUN_01.ogg"] = 09.76,
					},
				},
				["BlackheartTheInciter\\Auch_"] = {
					["Blckhrt01_"] = {
						["Aggro01.ogg"] = 02.25,
						["Aggro02.ogg"] = 02.36,
						["Aggro03.ogg"] = 02.99,
						["Death01.ogg"] = 03.88,
						["Help01.ogg"] = 02.74,
						["Intro01.ogg"] = 03.32,
						["Intro02.ogg"] = 04.01,
						["Intro03.ogg"] = 03.36,
						["Slay01.ogg"] = 02.86,
						["Slay02.ogg"] = 02.06,
					},
					["Blckhrt02_"] = {
						["Aggro01.ogg"] = 02.23,
						["Aggro02.ogg"] = 02.44,
						["Aggro03.ogg"] = 02.52,
						["Death01.ogg"] = 04.24,
						["Help01.ogg"] = 02.79,
						["Intro01.ogg"] = 03.28,
						["Intro02.ogg"] = 03.58,
						["Intro03.ogg"] = 02.24,
						["Slay01.ogg"] = 02.59,
						["Slay02.ogg"] = 03.84,
					},
				},
				["Blackhorn\\VO_"] = {
					["QE_HJ_"] = {
						["Blackhorn_"] = {
							["HYEvent01.ogg"] = 05.65,
							["HYEvent02.ogg"] = 07.77,
							["HYEvent03.ogg"] = 04.16,
							["HYEvent04.ogg"] = 07.06,
							["HYEvent05.ogg"] = 03.22,
							["HYEvent06.ogg"] = 07.49,
						},
					},
				},
				["BlackKnight\\AC_"] = {
					["BlackKnight_"] = {
						["Aggro01.ogg"] = 02.95,
						["AttackHeavy01.ogg"] = 00.65,
						["AttackHeavy02.ogg"] = 00.85,
						["AttackHeavy03.ogg"] = 01.04,
						["AttackLight01.ogg"] = 00.47,
						["AttackLight02.ogg"] = 00.63,
						["AttackLight03.ogg"] = 00.55,
						["AttackMedium01.ogg"] = 00.86,
						["AttackMedium02.ogg"] = 00.92,
						["AttackMedium03.ogg"] = 00.70,
						["Death01.ogg"] = 04.65,
						["GhostRes01.ogg"] = 04.72,
						["Intro01.ogg"] = 04.28,
						["Intro02.ogg"] = 07.67,
						["Intro03.ogg"] = 02.46,
						["SkeletonRes01.ogg"] = 03.00,
						["Slay01.ogg"] = 00.94,
						["Slay02.ogg"] = 02.09,
						["WoundCritical01.ogg"] = 00.68,
						["WoundCritical02.ogg"] = 00.68,
						["WoundHeavy01.ogg"] = 00.56,
						["WoundHeavy02.ogg"] = 00.46,
						["WoundHeavy03.ogg"] = 01.07,
						["WoundLight01.ogg"] = 00.48,
						["WoundLight02.ogg"] = 00.43,
						["WoundLight03.ogg"] = 00.67,
						["WoundMedium01.ogg"] = 00.40,
						["WoundMedium02.ogg"] = 00.71,
						["WoundMedium03.ogg"] = 00.67,
					},
				},
				["Blackthorn\\VO_"] = {
					["60_"] = {
						["BLACKTHORN_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 02.03,
								["02.ogg"] = 01.34,
								["03.ogg"] = 01.20,
								["04.ogg"] = 01.96,
								["05.ogg"] = 01.68,
							},
							["Attack_"] = {
								["01.ogg"] = 00.70,
								["010.ogg"] = 00.60,
								["011.ogg"] = 00.67,
								["02.ogg"] = 00.54,
								["03.ogg"] = 00.64,
								["04.ogg"] = 00.45,
								["05.ogg"] = 00.64,
								["06.ogg"] = 00.49,
								["07.ogg"] = 00.57,
								["08.ogg"] = 00.73,
								["09.ogg"] = 00.71,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.82,
								["02.ogg"] = 01.67,
								["03.ogg"] = 02.20,
								["04.ogg"] = 02.07,
								["05.ogg"] = 01.09,
							},
							["Wound_"] = {
								["01.ogg"] = 00.52,
								["010.ogg"] = 00.53,
								["02.ogg"] = 00.56,
								["03.ogg"] = 00.40,
								["04.ogg"] = 00.59,
								["05.ogg"] = 00.63,
								["06.ogg"] = 00.39,
								["07.ogg"] = 00.49,
								["08.ogg"] = 00.43,
								["09.ogg"] = 00.50,
							},
						},
						["RFD_BLACKTHORN_"] = {
							["KILL_"] = {
								["01.ogg"] = 04.34,
								["02.ogg"] = 05.02,
								["03.ogg"] = 03.22,
							},
							["SPELL_"] = {
								["01.ogg"] = 06.33,
								["02.ogg"] = 04.61,
							},
							["AGGRO.ogg"] = 03.55,
							["DEATH.ogg"] = 12.33,
						},
					},
				},
				["BlademasterIshi\\VO_"] = {
					["5.1_HFINAL_"] = {
						["Ishi_Boss_"] = {
							["01.OGG"] = 08.70,
							["02.OGG"] = 09.72,
							["03.OGG"] = 15.36,
							["04.OGG"] = 16.41,
							["05.OGG"] = 16.28,
							["06.OGG"] = 07.58,
						},
					},
					["BlademasterIshi_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.64,
							["02.OGG"] = 01.65,
							["03.OGG"] = 01.51,
							["04.OGG"] = 01.44,
							["05.OGG"] = 01.88,
						},
						["Attack_"] = {
							["01.OGG"] = 00.93,
							["02.OGG"] = 00.92,
							["03.OGG"] = 00.96,
							["04.OGG"] = 00.78,
							["05.OGG"] = 00.95,
							["06.OGG"] = 00.78,
							["07.OGG"] = 01.01,
							["08.OGG"] = 00.91,
							["09.OGG"] = 01.02,
							["10.OGG"] = 01.09,
						},
						["Death_"] = {
							["01.OGG"] = 02.30,
							["02.OGG"] = 02.42,
							["03.OGG"] = 02.39,
							["04.OGG"] = 03.03,
							["05.OGG"] = 02.86,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.12,
							["02.OGG"] = 01.36,
							["03.OGG"] = 01.68,
							["04.OGG"] = 01.18,
							["05.OGG"] = 01.38,
						},
						["Wound_"] = {
							["01.OGG"] = 00.87,
							["02.OGG"] = 00.76,
							["03.OGG"] = 00.74,
							["04.OGG"] = 00.65,
							["05.OGG"] = 00.72,
							["06.OGG"] = 00.87,
							["07.OGG"] = 01.05,
							["08.OGG"] = 00.61,
							["09.OGG"] = 00.72,
							["10.OGG"] = 00.74,
						},
					},
				},
				["BloodElfMale_Guard\\BloodElfMale_"] = {
					["GuardAggro.ogg"] = 00.64,
					["GuardAttackA.ogg"] = 00.60,
					["GuardAttackB.ogg"] = 00.74,
					["GuardAttackC.ogg"] = 00.49,
					["GuardAttackD.ogg"] = 00.54,
					["GuardAttackE.ogg"] = 00.61,
					["GuardDeath.ogg"] = 02.71,
					["GuardPreAggro.ogg"] = 00.65,
					["GuardWoundA.ogg"] = 00.63,
					["GuardWoundB.ogg"] = 00.98,
					["GuardWoundC.ogg"] = 00.70,
					["GuardWoundCrit.ogg"] = 01.37,
					["GuardWoundD.ogg"] = 00.69,
				},
				["BloodGolem\\MON_"] = {
					["BloodGolem_"] = {
						["Aggro_"] = {
							["01.OGG"] = 02.08,
							["02.OGG"] = 02.41,
							["03.OGG"] = 03.25,
							["04.OGG"] = 02.14,
							["05.OGG"] = 02.21,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 02.18,
							["02.OGG"] = 02.21,
							["03.OGG"] = 02.30,
							["04.OGG"] = 02.18,
							["05.OGG"] = 02.11,
						},
						["Attack_"] = {
							["01.OGG"] = 02.01,
							["010.OGG"] = 02.02,
							["02.OGG"] = 02.14,
							["03.OGG"] = 02.03,
							["04.OGG"] = 02.04,
							["05.OGG"] = 02.14,
							["06.OGG"] = 02.04,
							["07.OGG"] = 02.22,
							["08.OGG"] = 01.99,
							["09.OGG"] = 02.03,
						},
						["Clickable_"] = {
							["01.OGG"] = 01.44,
							["02.OGG"] = 01.55,
							["03.OGG"] = 01.92,
							["04.OGG"] = 02.10,
						},
						["Death_"] = {
							["01.OGG"] = 03.25,
							["02.OGG"] = 03.17,
							["03.OGG"] = 03.38,
							["04.OGG"] = 03.10,
							["05.OGG"] = 03.78,
						},
						["Emerge_"] = {
							["01.OGG"] = 02.37,
							["02.OGG"] = 02.41,
							["03.OGG"] = 02.69,
							["04.OGG"] = 02.47,
							["05.OGG"] = 03.03,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.82,
							["02.OGG"] = 02.05,
							["03.OGG"] = 01.67,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.65,
							["02.OGG"] = 01.69,
							["03.OGG"] = 01.94,
							["04.OGG"] = 01.64,
							["05.OGG"] = 01.61,
						},
						["Wound_"] = {
							["01.OGG"] = 01.75,
							["02.OGG"] = 01.73,
							["03.OGG"] = 01.48,
							["04.OGG"] = 01.58,
							["05.OGG"] = 01.62,
							["06.OGG"] = 01.71,
							["07.OGG"] = 01.76,
							["08.OGG"] = 01.78,
							["09.OGG"] = 01.51,
							["10.OGG"] = 01.47,
						},
					},
				},
				["BloodGuard\\HELL_"] = {
					["Bldgrd_"] = {
						["Aim01.ogg"] = 00.63,
						["Fire01.ogg"] = 01.46,
						["Rally01.ogg"] = 04.02,
						["Ready01.ogg"] = 01.43,
					},
				},
				["BloodmageThalnos\\"] = {
					["BloodmageThalnosAggro01.ogg"] = 02.54,
					["BloodmageThalnosHealth01.ogg"] = 03.17,
					["BloodmageThalnosSlay01.ogg"] = 03.23,
				},
				["BloodQueenLanathel\\"] = {
					["FS_Lanathel_"] = {
						["QuelDelar01.ogg"] = 04.81,
						["QuelDelar02.ogg"] = 07.25,
						["QuelDelar03.ogg"] = 05.78,
						["QuelDelar04.ogg"] = 11.19,
						["QuelDelar05.ogg"] = 06.97,
						["QuelDelar06.ogg"] = 05.33,
						["QuelDelar07.ogg"] = 08.57,
						["QuelDelar08.ogg"] = 02.80,
						["QuelDelar09.ogg"] = 01.28,
						["QuelDelar10.ogg"] = 08.76,
					},
					["IC_Lanathel_"] = {
						["Add01.ogg"] = 02.16,
						["Aggro01.ogg"] = 04.62,
						["Attack01.ogg"] = 01.40,
						["Attack02.ogg"] = 01.52,
						["Attack03.ogg"] = 00.94,
						["Attack04.ogg"] = 00.86,
						["Attack05.ogg"] = 00.74,
						["Attack06.ogg"] = 00.87,
						["Attack07.ogg"] = 01.18,
						["Attack08.ogg"] = 00.98,
						["Attack09.ogg"] = 00.85,
						["Attack10.ogg"] = 00.69,
						["Berserk01.ogg"] = 03.14,
						["Bite01.ogg"] = 01.72,
						["Bite02.ogg"] = 01.86,
						["Death01.ogg"] = 06.59,
						["Empower01.ogg"] = 05.08,
						["IntroPrince01.ogg"] = 14.16,
						["Mindcontrol01.ogg"] = 05.37,
						["Reset01.ogg"] = 08.24,
						["Slay01.ogg"] = 02.99,
						["Slay02.ogg"] = 02.04,
						["Special01.ogg"] = 00.87,
						["Special02.ogg"] = 01.91,
						["Special03.ogg"] = 03.16,
						["Wound01.ogg"] = 00.71,
						["Wound02.ogg"] = 00.62,
						["Wound03.ogg"] = 00.38,
						["Wound04.ogg"] = 00.33,
						["Wound05.ogg"] = 01.31,
						["Wound06.ogg"] = 00.92,
						["Wound07.ogg"] = 00.97,
						["WoundCrit01.ogg"] = 01.70,
						["WoundCrit02.ogg"] = 01.36,
						["WoundCrit03.ogg"] = 00.57,
						["WoundCrit04.ogg"] = 00.83,
						["WoundCrit05.ogg"] = 01.07,
					},
				},
				["BlueSentry\\VO_"] = {
					["QUEST_42_"] = {
						["LEGENDARY_BLUE_"] = {
							["SENTRY_"] = {
								["01.ogg"] = 04.60,
								["02.ogg"] = 01.31,
							},
						},
					},
				},
				["Boar\\"] = {
					["mWildBoarAggro1.ogg"] = 02.51,
					["mWildBoarAggro2.ogg"] = 02.04,
					["mWildBoarAggro3.ogg"] = 01.73,
					["mWildBoarAttack1.ogg"] = 01.30,
					["mWildBoarAttack2.ogg"] = 01.13,
					["mWildBoarAttack3.ogg"] = 01.40,
					["mWildBoarDeath1.ogg"] = 01.54,
					["mWildBoarWound1.ogg"] = 01.40,
					["mWildBoarWound2.ogg"] = 01.02,
					["mWildBoarWound3.ogg"] = 01.20,
					["mWildBoarWoundCritical1.ogg"] = 01.43,
				},
				["Boden\\VO_"] = {
					["QE_Boden_"] = {
						["Attack01.ogg"] = 02.30,
						["Attack02.ogg"] = 02.29,
						["Attack03.ogg"] = 02.46,
						["Attack04.ogg"] = 02.58,
						["Attack05.ogg"] = 03.30,
						["Attack06.ogg"] = 02.12,
						["Attack07.ogg"] = 02.17,
						["Attack08.ogg"] = 02.51,
						["Attack09.ogg"] = 02.22,
						["Attack10.ogg"] = 02.73,
						["AttackCritical01.ogg"] = 03.12,
						["AttackCritical02.ogg"] = 03.16,
						["AttackCritical03.ogg"] = 02.91,
						["AttackCritical04.ogg"] = 02.72,
						["Event01.ogg"] = 10.29,
						["Event02.ogg"] = 15.02,
						["Event03.ogg"] = 04.43,
						["Event04.ogg"] = 06.75,
						["Event05.ogg"] = 05.91,
						["Laughs01.ogg"] = 04.35,
						["ThroneDisc01.ogg"] = 13.07,
						["Wound01.ogg"] = 01.76,
						["Wound02.ogg"] = 01.90,
						["Wound03.ogg"] = 02.03,
						["Wound04.ogg"] = 02.02,
						["Wound05.ogg"] = 02.03,
						["Wound06.ogg"] = 01.94,
						["Wound07.ogg"] = 02.06,
						["WoundCritical01.ogg"] = 02.24,
						["WoundCritical02.ogg"] = 02.40,
						["WoundCritical03.ogg"] = 02.41,
						["WoundCritical04.ogg"] = 02.33,
						["WoundCritical05.ogg"] = 02.58,
					},
				},
				["BogBeast\\"] = {
					["mBogBeastAggroA.ogg"] = 02.08,
					["mBogBeastAttack1A.ogg"] = 01.38,
					["mBogBeastAttack1B.ogg"] = 01.23,
					["mBogBeastAttack2A.ogg"] = 01.86,
					["mBogBeastAttack2B.ogg"] = 02.00,
					["mBogBeastDeathA.ogg"] = 04.04,
					["mBogBeastStand2A.ogg"] = 04.88,
					["mBogBeastWoundA.ogg"] = 01.28,
					["mBogBeastWoundB.ogg"] = 01.32,
					["mBogBeastWoundC.ogg"] = 01.29,
					["mBogBeastWoundCriticalA.ogg"] = 01.43,
				},
				["Boldbrew\\VO_"] = {
					["53_Boldbrew_"] = {
						["Scenario_"] = {
							["01.OGG"] = 03.44,
							["02.OGG"] = 03.78,
							["03.OGG"] = 05.58,
							["04.OGG"] = 02.80,
							["05.OGG"] = 12.93,
						},
					},
				},
				["BoldKarasshi\\VO_"] = {
					["Jade_Forest_"] = {
						["Spies_Arrive_"] = {
							["Bold_Karasshi_"] = {
								["01.OGG"] = 07.23,
								["02.OGG"] = 06.50,
								["03.OGG"] = 04.43,
								["04.OGG"] = 06.90,
								["05.OGG"] = 02.69,
								["06.OGG"] = 01.84,
								["07.OGG"] = 08.38,
								["08.OGG"] = 03.11,
								["09.OGG"] = 07.58,
								["10.OGG"] = 08.48,
								["11.OGG"] = 10.60,
								["12.OGG"] = 10.10,
							},
						},
					},
				},
				["Boldrich\\VO_"] = {
					["QE_Boldrich_"] = {
						["Attack01.ogg"] = 00.83,
						["Attack02.ogg"] = 00.87,
						["Attack03.ogg"] = 00.68,
						["Attack04.ogg"] = 00.58,
						["Attack05.ogg"] = 00.69,
						["Attack06.ogg"] = 00.72,
						["Attack07.ogg"] = 00.65,
						["Attack08.ogg"] = 00.67,
						["Attack09.ogg"] = 00.71,
						["Attack10.ogg"] = 00.75,
						["AttackCritical01.ogg"] = 01.22,
						["AttackCritical02.ogg"] = 00.96,
						["AttackCritical03.ogg"] = 01.26,
						["AttackCritical04.ogg"] = 00.88,
						["AttackCritical05.ogg"] = 01.28,
						["Death01.ogg"] = 02.39,
						["Death02.ogg"] = 04.77,
						["Death03.ogg"] = 02.48,
						["Death04.ogg"] = 02.42,
						["Event01.ogg"] = 03.88,
						["Event02.ogg"] = 05.73,
						["Event03.ogg"] = 01.23,
						["Wound01.ogg"] = 00.54,
						["Wound02.ogg"] = 00.62,
						["Wound03.ogg"] = 00.46,
						["Wound04.ogg"] = 00.50,
						["Wound05.ogg"] = 00.53,
						["Wound06.ogg"] = 00.60,
						["Wound07.ogg"] = 00.44,
						["Wound08.ogg"] = 00.73,
						["Wound09.ogg"] = 00.40,
						["Wound10.ogg"] = 00.60,
						["WoundCritical01.ogg"] = 01.29,
						["WoundCritical02.ogg"] = 01.27,
						["WoundCritical03.ogg"] = 01.52,
						["WoundCritical04.ogg"] = 01.57,
						["WoundCritical05.ogg"] = 01.41,
					},
				},
				["boltcog\\OG_"] = {
					["Boltcog_"] = {
						["Attack01.ogg"] = 00.56,
						["Attack02.ogg"] = 00.66,
						["Attack03.ogg"] = 00.71,
						["Attack04.ogg"] = 00.63,
						["Attack05.ogg"] = 00.65,
						["Attack06.ogg"] = 00.45,
						["Attack07.ogg"] = 00.64,
						["Attack08.ogg"] = 00.47,
						["Attack09.ogg"] = 00.59,
						["Attack10.ogg"] = 00.46,
						["Death01.ogg"] = 03.52,
						["Event01.ogg"] = 05.42,
						["Slay01.ogg"] = 00.69,
						["Slay02.ogg"] = 01.23,
						["Wound01.ogg"] = 00.73,
						["Wound02.ogg"] = 00.63,
						["Wound03.ogg"] = 00.68,
						["Wound04.ogg"] = 00.47,
						["Wound05.ogg"] = 00.41,
						["Wound06.ogg"] = 00.43,
						["Wound07.ogg"] = 00.71,
						["Wound08.ogg"] = 00.63,
						["Wound09.ogg"] = 00.60,
						["Wound10.ogg"] = 00.62,
					},
				},
				["BolvarFordragon\\IC_"] = {
					["Bolvar_"] = {
						["Attack01.ogg"] = 02.61,
						["Attack02.ogg"] = 02.64,
						["Attack03.ogg"] = 02.02,
						["Attack04.ogg"] = 02.37,
						["Attack05.ogg"] = 02.00,
						["Attack06.ogg"] = 01.74,
						["Attack07.ogg"] = 01.96,
						["Attack08.ogg"] = 02.27,
						["Attack09.ogg"] = 02.69,
						["Attack10.ogg"] = 02.44,
						["Choking01.ogg"] = 05.93,
						["Death01.ogg"] = 02.62,
						["Death02.ogg"] = 01.78,
						["Death03.ogg"] = 01.90,
						["Death04.ogg"] = 04.65,
						["Death05.ogg"] = 02.69,
						["Death06.ogg"] = 03.24,
						["Death07.ogg"] = 03.30,
						["Death08.ogg"] = 02.74,
						["Intro01.ogg"] = 06.22,
						["Wound01.ogg"] = 02.60,
						["Wound02.ogg"] = 02.58,
						["Wound03.ogg"] = 02.77,
						["Wound04.ogg"] = 03.08,
						["Wound05.ogg"] = 01.60,
						["Wound06.ogg"] = 01.99,
						["Wound07.ogg"] = 02.18,
						["Wound08.ogg"] = 02.22,
						["Wound09.ogg"] = 02.55,
						["WoundCrit01.ogg"] = 03.76,
						["WoundCrit02.ogg"] = 02.63,
					},
				},
				["BonechewerBeastmaster\\HELL_"] = {
					["Beast_"] = {
						["Nokill01.ogg"] = 03.84,
						["Reinf01.ogg"] = 03.77,
					},
				},
				["BoneGolem\\IC_"] = {
					["BoneGolem_"] = {
						["Event01.ogg"] = 04.62,
						["Event02.ogg"] = 03.21,
						["Event03.ogg"] = 03.57,
					},
				},
				["BoneGuardRock\\BoneGuardRock_"] = {
					["Aggro_"] = {
						["01.ogg"] = 02.12,
						["02.ogg"] = 02.14,
						["03.ogg"] = 02.10,
						["04.ogg"] = 02.84,
						["05.ogg"] = 02.58,
						["06.ogg"] = 03.49,
						["07.ogg"] = 02.56,
						["08.ogg"] = 03.84,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 02.13,
						["02.ogg"] = 02.15,
						["03.ogg"] = 02.41,
						["04.ogg"] = 02.16,
						["05.ogg"] = 02.31,
						["06.ogg"] = 02.36,
						["07.ogg"] = 02.24,
						["08.ogg"] = 02.39,
						["09.ogg"] = 02.23,
					},
					["Attack_"] = {
						["01.ogg"] = 01.89,
						["02.ogg"] = 02.28,
						["03.ogg"] = 02.00,
						["04.ogg"] = 01.76,
						["05.ogg"] = 02.01,
						["06.ogg"] = 02.04,
						["07.ogg"] = 02.28,
						["08.ogg"] = 01.75,
						["09.ogg"] = 02.11,
						["10.ogg"] = 02.51,
					},
					["Death_"] = {
						["01.ogg"] = 08.34,
						["02.ogg"] = 08.34,
						["03.ogg"] = 08.34,
						["04.ogg"] = 08.34,
						["05.ogg"] = 08.34,
						["06.ogg"] = 08.34,
						["07.ogg"] = 08.34,
						["08.ogg"] = 08.34,
						["09.ogg"] = 08.34,
						["10.ogg"] = 08.34,
					},
					["PreAggro_"] = {
						["01.ogg"] = 04.75,
						["02.ogg"] = 04.72,
						["03.ogg"] = 05.63,
						["04.ogg"] = 04.91,
						["05.ogg"] = 03.64,
						["06.ogg"] = 03.40,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 02.55,
						["02.ogg"] = 02.50,
						["03.ogg"] = 02.14,
						["04.ogg"] = 02.72,
						["05.ogg"] = 01.98,
						["06.ogg"] = 02.49,
						["07.ogg"] = 02.22,
						["08.ogg"] = 02.52,
						["09.ogg"] = 02.48,
						["10.ogg"] = 01.92,
					},
					["Wound_"] = {
						["01.ogg"] = 01.63,
						["02.ogg"] = 01.58,
						["03.ogg"] = 01.38,
						["04.ogg"] = 01.60,
						["05.ogg"] = 01.57,
						["06.ogg"] = 01.59,
						["07.ogg"] = 01.39,
						["08.ogg"] = 01.44,
						["09.ogg"] = 01.45,
						["10.ogg"] = 01.60,
					},
				},
				["Bonetusk\\VO_"] = {
					["60_"] = {
						["BONETUSK_"] = {
							["AttackCrit_"] = {
								["1.OGG"] = 00.95,
								["2.OGG"] = 00.64,
								["3.OGG"] = 01.31,
								["4.OGG"] = 02.05,
								["5.OGG"] = 01.09,
							},
							["Attack_"] = {
								["1.OGG"] = 00.57,
								["2.OGG"] = 00.64,
								["3.OGG"] = 00.59,
								["4.OGG"] = 02.00,
								["5.OGG"] = 01.15,
								["6.OGG"] = 01.11,
								["7.OGG"] = 00.68,
								["8.OGG"] = 01.29,
							},
							["WoundCrit_"] = {
								["1.OGG"] = 02.15,
								["2.OGG"] = 01.01,
								["3.OGG"] = 01.73,
								["4.OGG"] = 02.30,
								["5.OGG"] = 01.18,
							},
							["Wound_"] = {
								["1.OGG"] = 00.56,
								["2.OGG"] = 01.00,
								["3.OGG"] = 00.49,
								["4.OGG"] = 00.76,
								["5.OGG"] = 00.59,
								["6.OGG"] = 00.76,
							},
						},
						["RFK_Bonetusk_"] = {
							["Aggro.OGG"] = 02.36,
							["Death.OGG"] = 04.57,
							["Event.OGG"] = 02.95,
							["Intro.OGG"] = 06.93,
							["Kill.OGG"] = 02.58,
							["Spell1.OGG"] = 02.02,
							["Spell2.OGG"] = 01.59,
						},
					},
				},
				["BorkaTheBrute\\VO_"] = {
					["60_"] = {
						["BRUTE_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 02.03,
								["02.ogg"] = 01.48,
								["03.ogg"] = 01.71,
								["04.ogg"] = 01.22,
								["05.ogg"] = 00.82,
							},
							["Attack_"] = {
								["01.ogg"] = 00.71,
								["010.ogg"] = 00.52,
								["02.ogg"] = 00.53,
								["03.ogg"] = 00.61,
								["04.ogg"] = 00.64,
								["05.ogg"] = 00.53,
								["06.ogg"] = 00.44,
								["07.ogg"] = 00.42,
								["08.ogg"] = 00.80,
								["09.ogg"] = 00.69,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 02.08,
								["02.ogg"] = 01.70,
								["03.ogg"] = 02.50,
								["04.ogg"] = 01.69,
								["05.ogg"] = 01.23,
							},
							["Wound_"] = {
								["01.ogg"] = 00.63,
								["010.ogg"] = 00.81,
								["02.ogg"] = 00.69,
								["03.ogg"] = 00.59,
								["04.ogg"] = 00.86,
								["05.ogg"] = 00.58,
								["06.ogg"] = 00.76,
								["07.ogg"] = 00.58,
								["08.ogg"] = 00.64,
								["09.ogg"] = 01.12,
							},
						},
						["TRAIN_BRUTE_"] = {
							["INTRO_"] = {
								["01.ogg"] = 01.75,
								["02.ogg"] = 02.66,
							},
							["AGGRO.ogg"] = 01.87,
							["DEATH.ogg"] = 05.92,
							["KILL1.ogg"] = 02.82,
							["KILL2.ogg"] = 03.29,
							["SPELL1.ogg"] = 02.00,
							["SPELL2.ogg"] = 01.99,
							["ENGINEER_DEATH.ogg"] = 03.96,
						},
					},
				},
				["Botani\\MON_"] = {
					["Botani_"] = {
						["Aggro01.ogg"] = 02.31,
						["Aggro02.ogg"] = 01.66,
						["Aggro03.ogg"] = 01.81,
						["Aggro04.ogg"] = 02.35,
						["Aggro05.ogg"] = 01.95,
						["Attack01.ogg"] = 01.50,
						["Attack02.ogg"] = 02.04,
						["Attack03.ogg"] = 02.19,
						["Attack04.ogg"] = 01.63,
						["Attack05.ogg"] = 01.94,
						["Attack06.ogg"] = 02.10,
						["Attack07.ogg"] = 02.44,
						["Attack08.ogg"] = 01.40,
						["Attack09.ogg"] = 01.37,
						["Attack10.ogg"] = 01.47,
						["AttackCrit01.ogg"] = 01.55,
						["AttackCrit02.ogg"] = 02.15,
						["AttackCrit03.ogg"] = 02.35,
						["AttackCrit04.ogg"] = 02.38,
						["AttackCrit05.ogg"] = 01.75,
						["Death01.ogg"] = 02.80,
						["Death02.ogg"] = 02.66,
						["Death03.ogg"] = 02.57,
						["Death04.ogg"] = 02.58,
						["Death05.ogg"] = 03.16,
						["PreAggro01.ogg"] = 01.55,
						["PreAggro02.ogg"] = 01.26,
						["PreAggro03.ogg"] = 01.25,
						["Wound01.ogg"] = 01.49,
						["Wound02.ogg"] = 01.77,
						["Wound03.ogg"] = 02.04,
						["Wound04.ogg"] = 01.40,
						["Wound05.ogg"] = 01.30,
						["Wound06.ogg"] = 01.67,
						["Wound07.ogg"] = 01.43,
						["Wound08.ogg"] = 01.50,
						["Wound09.ogg"] = 01.68,
						["Wound10.ogg"] = 01.54,
						["WoundCrit01.ogg"] = 01.74,
						["WoundCrit02.ogg"] = 01.59,
						["WoundCrit03.ogg"] = 01.98,
						["WoundCrit04.ogg"] = 01.74,
						["WoundCrit05.ogg"] = 01.78,
					},
				},
				["Brandon\\IC_"] = {
					["Captain Brandon_"] = {
						["Attack01.ogg"] = 01.28,
						["Attack02.ogg"] = 01.74,
						["Attack03.ogg"] = 00.79,
						["Attack04.ogg"] = 00.75,
						["Attack05.ogg"] = 00.78,
						["Attack06.ogg"] = 00.55,
						["Attack07.ogg"] = 00.72,
						["Attack08.ogg"] = 00.66,
						["Attack09.ogg"] = 00.29,
						["Attack10.ogg"] = 01.04,
						["Event01.ogg"] = 06.05,
						["Event02.ogg"] = 12.11,
						["Event03.ogg"] = 03.66,
						["Event04.ogg"] = 03.53,
						["Survived01.ogg"] = 05.12,
						["Teleport01.ogg"] = 02.23,
						["Wound01.ogg"] = 00.68,
						["Wound02.ogg"] = 00.44,
						["Wound03.ogg"] = 00.64,
						["Wound04.ogg"] = 00.75,
						["Wound05.ogg"] = 00.46,
						["Wound06.ogg"] = 00.59,
						["Wound07.ogg"] = 00.67,
						["Wound08.ogg"] = 00.83,
						["Wound09.ogg"] = 00.66,
						["Wound10.ogg"] = 01.05,
						["WoundCrit01.ogg"] = 00.85,
						["WoundCrit02.ogg"] = 01.16,
						["WoundCrit03.ogg"] = 00.54,
						["WoundCrit04.ogg"] = 00.88,
						["WoundCrit05.ogg"] = 00.80,
					},
				},
				["Brann\\"] = {
					["HS_Brann_"] = {
						["ArriveTribunal.ogg"] = 11.15,
						["Attack01.ogg"] = 00.58,
						["Attack02.ogg"] = 00.46,
						["Attack03.ogg"] = 01.05,
						["Attack04.ogg"] = 01.01,
						["Attack05.ogg"] = 01.07,
						["Attack06.ogg"] = 00.61,
						["Attack07.ogg"] = 00.63,
						["Attack08.ogg"] = 00.75,
						["Death.ogg"] = 04.10,
						["EarthenSpawns.ogg"] = 05.31,
						["EndSpeech01.ogg"] = 05.20,
						["EndSpeech02.ogg"] = 05.41,
						["EndSpeech03.ogg"] = 09.37,
						["EndSpeech04.ogg"] = 03.91,
						["EndSpeech05.ogg"] = 06.79,
						["EndSpeech06.ogg"] = 03.89,
						["EndSpeech07.ogg"] = 01.19,
						["EndSpeech08.ogg"] = 10.11,
						["EndSpeech09.ogg"] = 04.76,
						["EndSpeech10.ogg"] = 23.29,
						["EndSpeech11.ogg"] = 06.45,
						["EscortStart.ogg"] = 04.11,
						["Farewell01.ogg"] = 00.92,
						["Farewell02.ogg"] = 02.18,
						["Farewell03.ogg"] = 01.47,
						["Farewell04.ogg"] = 01.54,
						["Greeting01.ogg"] = 02.38,
						["Greeting02.ogg"] = 04.22,
						["Greeting03.ogg"] = 03.38,
						["Greeting04.ogg"] = 02.72,
						["IronDwarfSpawns.ogg"] = 07.39,
						["LowHealth.ogg"] = 04.42,
						["OozeSpawns.ogg"] = 05.35,
						["PanelInteraction01.ogg"] = 03.07,
						["PanelInteraction02.ogg"] = 04.77,
						["PanelInteraction03.ogg"] = 04.78,
						["PanelInteraction04.ogg"] = 02.45,
						["PanelInteraction05.ogg"] = 02.04,
						["PanelInteraction06.ogg"] = 03.36,
						["PanelInteraction07.ogg"] = 04.69,
						["PanelInteraction08.ogg"] = 04.87,
						["PanelInteraction09.ogg"] = 05.67,
						["ReactingDeath01.ogg"] = 01.56,
						["ReactingDeath02.ogg"] = 01.84,
						["ReactingDeath03.ogg"] = 01.70,
						["ReactingKill01.ogg"] = 01.77,
						["ReactingKill02.ogg"] = 01.67,
						["ReactingKill03.ogg"] = 03.48,
						["SjonnirVictorySpeech01.ogg"] = 12.01,
						["SjonnirVictorySpeech02.ogg"] = 09.06,
						["TroggSpawns.ogg"] = 05.20,
						["Wound01.ogg"] = 00.42,
						["Wound02.ogg"] = 00.57,
						["Wound03.ogg"] = 00.50,
						["Wound04.ogg"] = 00.79,
						["Wound05.ogg"] = 01.32,
						["WoundCrit01.ogg"] = 01.03,
						["WoundCrit02.ogg"] = 00.76,
						["WoundCrit03.ogg"] = 01.20,
					},
					["UR_Brann_"] = {
						["Algalon01.ogg"] = 02.40,
						["AlgalonSummoned01.ogg"] = 07.04,
						["AlgalonSummoned02.ogg"] = 06.23,
						["Archivum01.ogg"] = 05.63,
						["Archivum02.ogg"] = 06.00,
						["Archivum03.ogg"] = 09.81,
						["Archivum04.ogg"] = 07.15,
						["Archivum05.ogg"] = 11.57,
						["Archivum06.ogg"] = 05.22,
						["Archivum07.ogg"] = 05.25,
						["Archivum08.ogg"] = 08.99,
						["Archivum09.ogg"] = 04.98,
						["Archivum10.ogg"] = 03.81,
						["Dalaran01.ogg"] = 03.02,
						["ICDefeat.ogg"] = 05.24,
						["Planetarium01.ogg"] = 04.55,
						["Planetarium02.ogg"] = 06.34,
						["Planetarium03.ogg"] = 05.07,
						["Planetarium04.ogg"] = 03.63,
						["Planetarium05.ogg"] = 07.52,
						["Radio01.ogg"] = 08.80,
						["Radio02.ogg"] = 05.76,
						["Radio03.ogg"] = 08.11,
						["Radio04.ogg"] = 08.13,
						["Radio05.ogg"] = 09.53,
						["Radio06.ogg"] = 09.17,
						["Radio07.ogg"] = 10.39,
						["Radio08.ogg"] = 07.96,
						["Radio09.ogg"] = 07.36,
						["Radio10.ogg"] = 06.10,
						["Radio11.ogg"] = 03.51,
						["Radio12.ogg"] = 03.18,
						["RadioStart01.ogg"] = 05.53,
					},
					["VO_HO_"] = {
						["Brann_"] = {
							["Event01.ogg"] = 06.20,
							["Event02.ogg"] = 04.74,
							["Event03.ogg"] = 13.11,
							["Event04.ogg"] = 04.70,
							["Event05.ogg"] = 02.84,
							["Event06.ogg"] = 03.26,
							["Event07.ogg"] = 14.50,
							["Event08.ogg"] = 00.98,
							["Event09.ogg"] = 06.13,
							["Event10.ogg"] = 04.30,
							["Event11.ogg"] = 05.98,
							["Final01.ogg"] = 03.86,
							["Final02.ogg"] = 01.85,
							["Final03.ogg"] = 03.66,
							["Final04.ogg"] = 04.22,
							["Final05.ogg"] = 04.01,
							["Final06.ogg"] = 03.11,
							["Final07.ogg"] = 06.06,
							["Final08.ogg"] = 02.26,
							["Final09.ogg"] = 01.83,
							["Final10.ogg"] = 03.66,
							["Final11.ogg"] = 01.62,
							["Final12.ogg"] = 02.45,
							["Final13.ogg"] = 01.10,
							["Final14.ogg"] = 02.65,
							["Vault01.ogg"] = 02.90,
							["Vault02.ogg"] = 03.16,
						},
					},
				},
				["BrannBronzebeard\\HS_"] = {
					["BrannBronzebeard_"] = {
						["ArriveTribunal.ogg"] = 11.52,
						["Attack01.ogg"] = 00.82,
						["Attack02.ogg"] = 00.82,
						["Attack03.ogg"] = 00.89,
						["Attack04.ogg"] = 00.82,
						["Attack05.ogg"] = 01.07,
						["Death.ogg"] = 03.48,
						["EarthenSpawns.ogg"] = 05.49,
						["EndSpeech01.ogg"] = 05.43,
						["EndSpeech02.ogg"] = 04.27,
						["EndSpeech03.ogg"] = 10.50,
						["EndSpeech04.ogg"] = 03.93,
						["EndSpeech05.ogg"] = 06.84,
						["EndSpeech06.ogg"] = 04.38,
						["EndSpeech07.ogg"] = 01.37,
						["EndSpeech08.ogg"] = 09.92,
						["EndSpeech09.ogg"] = 05.49,
						["EndSpeech10.ogg"] = 22.80,
						["EndSpeech11.ogg"] = 07.51,
						["EscortStart.ogg"] = 03.74,
						["Farewell01.ogg"] = 01.58,
						["Farewell02.ogg"] = 01.92,
						["Farewell03.ogg"] = 01.72,
						["Farewell04.ogg"] = 01.93,
						["Greeting01.ogg"] = 03.02,
						["Greeting02.ogg"] = 03.09,
						["Greeting03.ogg"] = 02.61,
						["Greeting04.ogg"] = 02.33,
						["IronDwarfSpawns.ogg"] = 07.84,
						["LowHealth.ogg"] = 04.20,
						["OozeSpawns.ogg"] = 05.44,
						["PanelInteraction01.ogg"] = 04.63,
						["PanelInteraction02.ogg"] = 05.27,
						["PanelInteraction03.ogg"] = 04.64,
						["PanelInteraction04.ogg"] = 03.23,
						["PanelInteraction05.ogg"] = 02.84,
						["PanelInteraction06.ogg"] = 04.48,
						["PanelInteraction07.ogg"] = 05.12,
						["PanelInteraction08.ogg"] = 05.56,
						["PanelInteraction09.ogg"] = 06.47,
						["ReactingDeath01.ogg"] = 02.17,
						["ReactingDeath02.ogg"] = 01.73,
						["ReactingDeath03.ogg"] = 02.10,
						["ReactingKill01.ogg"] = 02.13,
						["ReactingKill02.ogg"] = 01.92,
						["ReactingKill03.ogg"] = 03.90,
						["SjonnirVictorySpeech01.ogg"] = 11.39,
						["SjonnirVictorySpeech02.ogg"] = 09.07,
						["TroggSpawns.ogg"] = 04.68,
						["Wound01.ogg"] = 00.56,
						["Wound02.ogg"] = 00.84,
						["Wound03.ogg"] = 00.64,
						["Wound04.ogg"] = 00.62,
						["WoundCrit01.ogg"] = 01.03,
						["WoundCrit02.ogg"] = 01.16,
						["WoundCrit03.ogg"] = 01.03,
					},
				},
				["BrokenMale\\"] = {
					["BrokenMaleAggro.ogg"] = 00.56,
					["BrokenMaleAttackA.ogg"] = 01.05,
					["BrokenMaleAttackB.ogg"] = 01.14,
					["BrokenMaleAttackC.ogg"] = 00.68,
					["BrokenMaleAttackD.ogg"] = 00.87,
					["BrokenMaleAttackE.ogg"] = 01.00,
					["BrokenMaleDeath.ogg"] = 01.57,
					["BrokenMalePreAggro.ogg"] = 00.51,
					["BrokenMaleWoundA.ogg"] = 00.63,
					["BrokenMaleWoundB.ogg"] = 00.47,
					["BrokenMaleWoundC.ogg"] = 00.86,
					["BrokenMaleWoundCrit.ogg"] = 01.21,
					["BrokenMaleWoundD.ogg"] = 00.99,
				},
				["BrokenNPC1\\"] = {
					["NPCBroken01Farewell01.ogg"] = 00.68,
					["NPCBroken01Farewell02.ogg"] = 00.74,
					["NPCBroken01Farewell03.ogg"] = 01.95,
					["NPCBroken01Farewell05.ogg"] = 00.96,
					["NPCBroken01Farewell06.ogg"] = 02.45,
					["NPCBroken01Farewell07.ogg"] = 00.90,
					["NPCBroken01Farewell08.ogg"] = 00.82,
					["NPCBroken01Greeting01.ogg"] = 00.57,
					["NPCBroken01Greeting02.ogg"] = 01.31,
					["NPCBroken01Greeting03.ogg"] = 01.63,
					["NPCBroken01Greeting04.ogg"] = 03.52,
					["NPCBroken01Greeting06.ogg"] = 02.44,
					["NPCBroken01Greeting07.ogg"] = 02.62,
					["NPCBroken01Greeting08.ogg"] = 03.09,
					["NPCBroken01Greeting09.ogg"] = 01.49,
					["NPCBroken01Pissed01.ogg"] = 01.91,
					["NPCBroken01Pissed02.ogg"] = 01.73,
					["NPCBroken01Pissed03.ogg"] = 00.96,
					["NPCBroken01Pissed04.ogg"] = 01.71,
					["NPCBroken01Pissed08.ogg"] = 01.50,
					["NPCBroken01Pissed09.ogg"] = 01.57,
					["NPCBroken01Vendor01.ogg"] = 01.10,
					["NPCBroken01Vendor02.ogg"] = 01.56,
					["NPCBroken01Vendor03.ogg"] = 01.85,
					["NPCBroken01Vendor04.ogg"] = 01.07,
					["NPCBroken01Vendor05.ogg"] = 01.28,
					["NPCBroken01Vendor06.ogg"] = 01.11,
					["NPCBroken01Vendor07.ogg"] = 01.89,
				},
				["BrokenNPC2\\"] = {
					["NPCBroken02Farewell01.ogg"] = 00.68,
					["NPCBroken02Farewell02.ogg"] = 00.62,
					["NPCBroken02Farewell03.ogg"] = 01.90,
					["NPCBroken02Farewell05.ogg"] = 01.22,
					["NPCBroken02Farewell06.ogg"] = 02.39,
					["NPCBroken02Farewell07.ogg"] = 01.08,
					["NPCBroken02Farewell08.ogg"] = 01.69,
					["NPCBroken02Greeting01.ogg"] = 00.62,
					["NPCBroken02Greeting02.ogg"] = 01.61,
					["NPCBroken02Greeting03.ogg"] = 01.23,
					["NPCBroken02Greeting04.ogg"] = 03.37,
					["NPCBroken02Greeting06.ogg"] = 02.58,
					["NPCBroken02Greeting07.ogg"] = 01.83,
					["NPCBroken02Greeting08.ogg"] = 02.11,
					["NPCBroken02Greeting09.ogg"] = 01.67,
					["NPCBroken02Pissed01.ogg"] = 01.17,
					["NPCBroken02Pissed02.ogg"] = 01.60,
					["NPCBroken02Pissed03.ogg"] = 01.58,
					["NPCBroken02Pissed04.ogg"] = 02.02,
					["NPCBroken02Pissed08.ogg"] = 01.15,
					["NPCBroken02Pissed09.ogg"] = 01.85,
					["NPCBroken02Vendor01.ogg"] = 00.88,
					["NPCBroken02Vendor02.ogg"] = 01.74,
					["NPCBroken02Vendor03.ogg"] = 01.19,
					["NPCBroken02Vendor04.ogg"] = 01.30,
					["NPCBroken02Vendor05.ogg"] = 01.68,
					["NPCBroken02Vendor06.ogg"] = 01.21,
					["NPCBroken02Vendor07.ogg"] = 02.51,
				},
				["Bronjahm\\FS_"] = {
					["Bronjahm_"] = {
						["Aggro01.ogg"] = 03.22,
						["Attack01.ogg"] = 01.60,
						["Attack02.ogg"] = 01.84,
						["Attack03.ogg"] = 02.44,
						["Attack04.ogg"] = 01.60,
						["Attack05.ogg"] = 01.39,
						["Attack06.ogg"] = 00.80,
						["Attack07.ogg"] = 00.73,
						["Attack08.ogg"] = 01.33,
						["Attack09.ogg"] = 01.42,
						["Attack10.ogg"] = 00.72,
						["CorruptSoul01.ogg"] = 03.77,
						["Death01.ogg"] = 02.71,
						["Slay01.ogg"] = 02.61,
						["Slay02.ogg"] = 03.44,
						["Soulstorm01.ogg"] = 03.57,
						["Wound01.ogg"] = 00.83,
						["Wound02.ogg"] = 00.81,
						["Wound03.ogg"] = 00.86,
						["Wound04.ogg"] = 00.67,
						["Wound05.ogg"] = 00.82,
						["Wound06.ogg"] = 01.12,
						["Wound07.ogg"] = 00.91,
						["Wound08.ogg"] = 01.02,
						["WoundCrit01.ogg"] = 01.42,
						["WoundCrit02.ogg"] = 01.04,
						["WoundCrit03.ogg"] = 01.36,
						["WoundCrit04.ogg"] = 01.20,
						["WoundCrit05.ogg"] = 01.10,
						["WoundCrit06.ogg"] = 01.15,
					},
				},
				["BronzeDragon01\\VO_"] = {
					["WOE_BDRAGON01_"] = {
						["EVENT_"] = {
							["01.OGG"] = 00.74,
							["02.OGG"] = 03.93,
						},
					},
				},
				["BronzeDragon02\\VO_"] = {
					["WOE_BDRAGON02_"] = {
						["EVENT_"] = {
							["01.OGG"] = 06.33,
							["02.OGG"] = 00.95,
						},
					},
				},
				["BroodLordLasher\\"] = {
					["BroodlordLasherAggro1.ogg"] = 05.34,
					["BroodlordLasherLeashTriggered.ogg"] = 06.40,
				},
				["BroomStickMount\\"] = {
					["BroomStickMountland.ogg"] = 02.58,
					["BroomStickMountTakeoff.ogg"] = 02.29,
				},
				["BrotherKorloff\\VO_"] = {
					["BrotherKorloff_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.04,
							["02.OGG"] = 01.42,
							["03.OGG"] = 01.39,
							["04.OGG"] = 01.24,
							["05.OGG"] = 00.85,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.40,
							["02.OGG"] = 00.44,
							["03.OGG"] = 00.52,
							["04.OGG"] = 00.65,
							["05.OGG"] = 00.57,
							["06.OGG"] = 00.34,
							["07.OGG"] = 00.33,
							["08.OGG"] = 00.46,
							["09.OGG"] = 00.42,
							["10.OGG"] = 00.47,
						},
						["Death_"] = {
							["01.OGG"] = 02.83,
							["02.OGG"] = 03.17,
							["03.OGG"] = 02.48,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.25,
							["02.OGG"] = 01.07,
							["03.OGG"] = 01.16,
							["04.OGG"] = 01.35,
							["05.OGG"] = 01.14,
						},
						["Wound_"] = {
							["01.OGG"] = 00.51,
							["02.OGG"] = 00.52,
							["03.OGG"] = 00.46,
							["04.OGG"] = 00.51,
							["05.OGG"] = 00.54,
							["06.OGG"] = 00.55,
							["07.OGG"] = 00.40,
							["08.OGG"] = 00.42,
							["09.OGG"] = 00.45,
							["10.OGG"] = 00.38,
						},
					},
					["SM_BROTHER_"] = {
						["SLAY_"] = {
							["01.OGG"] = 03.72,
							["02.OGG"] = 02.84,
						},
						["AGGRO_01.OGG"] = 01.66,
						["DEATH_01.OGG"] = 03.34,
						["RESET_01.OGG"] = 03.66,
					},
				},
				["Brutallus\\"] = {
					["SP_Brut_"] = {
						["Attack01.ogg"] = 01.11,
						["Attack02.ogg"] = 01.11,
						["Attack03.ogg"] = 01.28,
						["Attack04.ogg"] = 01.16,
						["Attack05.ogg"] = 01.99,
						["Wound01.ogg"] = 01.00,
						["Wound02.ogg"] = 00.89,
						["Wound03.ogg"] = 00.93,
						["Wound04.ogg"] = 01.14,
						["WoundCrit01.ogg"] = 01.32,
					},
					["BRUTALLUSBERSERK.ogg"] = 06.12,
					["BRUTALLUSBREAKSICE.ogg"] = 04.57,
					["BRUTALLUSCHARGES.ogg"] = 03.32,
					["BRUTALLUSDEATH.ogg"] = 10.39,
					["BRUTALLUSINTRO.ogg"] = 06.80,
					["BRUTALLUSKILL01.ogg"] = 02.76,
					["BRUTALLUSKILL02.ogg"] = 02.75,
					["BRUTALLUSKILL03.ogg"] = 02.86,
					["BRUTALLUSLOVINGCOMBAT01.ogg"] = 04.00,
					["BRUTALLUSLOVINGCOMBAT02.ogg"] = 05.71,
					["BRUTALLUSLOVINGCOMBAT03.ogg"] = 03.55,
					["BRUTALLUSPLAYERAGGRO.ogg"] = 05.31,
					["BRUTALLUSTAUNTSPLAYERS.ogg"] = 03.76,
					["BRUTALUSKILLSDRAGON.ogg"] = 06.92,
				},
				["Budd\\VO_"] = {
					["QE_VJ_"] = {
						["Budd_"] = {
							["AllianceShip01.ogg"] = 01.26,
							["AllianceShip02.ogg"] = 02.07,
							["AllianceShip03.ogg"] = 04.06,
							["AllianceShip04.ogg"] = 03.72,
							["AllianceShip05.ogg"] = 02.12,
						},
					},
				},
				["BushChicken\\BushChicken_"] = {
					["Aggro_"] = {
						["01.ogg"] = 00.75,
						["02.ogg"] = 01.16,
						["03.ogg"] = 00.97,
						["04.ogg"] = 00.70,
						["05.ogg"] = 00.79,
						["06.ogg"] = 00.73,
						["07.ogg"] = 01.51,
						["08.ogg"] = 00.97,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 00.43,
						["02.ogg"] = 00.56,
						["03.ogg"] = 00.71,
						["04.ogg"] = 00.65,
					},
					["Attack_"] = {
						["01.ogg"] = 00.64,
						["02.ogg"] = 00.43,
						["03.ogg"] = 00.64,
						["04.ogg"] = 00.57,
						["05.ogg"] = 00.79,
						["06.ogg"] = 00.39,
						["07.ogg"] = 00.38,
						["08.ogg"] = 00.35,
						["09.ogg"] = 00.45,
						["10.ogg"] = 00.51,
					},
					["Death_"] = {
						["01.ogg"] = 01.95,
						["02.ogg"] = 00.98,
						["03.ogg"] = 01.53,
						["04.ogg"] = 00.78,
						["05.ogg"] = 01.88,
						["06.ogg"] = 01.96,
						["07.ogg"] = 01.95,
						["08.ogg"] = 01.14,
						["09.ogg"] = 01.10,
						["10.ogg"] = 01.31,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.01,
						["02.ogg"] = 00.46,
						["03.ogg"] = 00.68,
						["04.ogg"] = 00.36,
						["05.ogg"] = 00.47,
						["06.ogg"] = 01.18,
						["07.ogg"] = 00.26,
						["08.ogg"] = 00.83,
						["09.ogg"] = 00.48,
						["10.ogg"] = 00.73,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 00.61,
						["02.ogg"] = 00.81,
						["03.ogg"] = 00.57,
						["04.ogg"] = 00.65,
						["05.ogg"] = 00.70,
					},
					["Wound_"] = {
						["01.ogg"] = 00.47,
						["02.ogg"] = 00.31,
						["03.ogg"] = 00.39,
						["04.ogg"] = 00.45,
						["05.ogg"] = 00.63,
						["06.ogg"] = 00.73,
						["07.ogg"] = 00.36,
						["08.ogg"] = 00.48,
						["09.ogg"] = 00.31,
					},
				},
				["bwonsamdi\\ZF_"] = {
					["Bwonsamdi_"] = {
						["Attack01.ogg"] = 02.37,
						["Attack02.ogg"] = 02.35,
						["Attack03.ogg"] = 02.46,
						["Attack04.ogg"] = 02.77,
						["Attack05.ogg"] = 02.32,
						["Attack06.ogg"] = 02.28,
						["Attack07.ogg"] = 02.67,
						["Attack08.ogg"] = 02.45,
						["Attack09.ogg"] = 02.43,
						["Event01.ogg"] = 08.93,
						["Event02.ogg"] = 15.69,
						["Event03.ogg"] = 23.39,
						["Event04.ogg"] = 03.23,
						["Event05.ogg"] = 10.64,
						["Event06.ogg"] = 07.89,
						["Event07.ogg"] = 09.00,
						["Event08.ogg"] = 09.01,
						["Event09.ogg"] = 20.01,
						["Event10.ogg"] = 06.26,
						["Event11.ogg"] = 04.68,
						["Event12.ogg"] = 14.52,
						["Event13.ogg"] = 15.59,
						["Wound01.ogg"] = 01.79,
						["Wound02.ogg"] = 01.98,
						["Wound03.ogg"] = 01.81,
						["Wound04.ogg"] = 01.96,
						["Wound05.ogg"] = 01.73,
						["Wound06.ogg"] = 01.83,
						["Wound07.ogg"] = 01.69,
					},
				},
				["Caelestrasz\\VO_"] = {
					["BT_Caelestrasz_"] = {
						["Attack01.ogg"] = 00.56,
						["Attack02.ogg"] = 00.57,
						["Attack03.ogg"] = 00.65,
						["Attack04.ogg"] = 00.79,
						["Attack05.ogg"] = 00.45,
						["Attack06.ogg"] = 00.51,
						["Attack07.ogg"] = 00.77,
						["Attack08.ogg"] = 00.89,
						["Attack09.ogg"] = 00.55,
						["Attack10.ogg"] = 00.61,
						["AttackCritical01.ogg"] = 00.95,
						["AttackCritical02.ogg"] = 01.29,
						["AttackCritical03.ogg"] = 01.17,
						["AttackCritical04.ogg"] = 01.02,
						["AttackCritical05.ogg"] = 01.30,
						["Death01.ogg"] = 05.86,
						["Intro01.ogg"] = 04.08,
						["Losing01.ogg"] = 03.16,
						["Phase2.ogg"] = 08.33,
						["Phase3.ogg"] = 16.61,
						["Recharge01.ogg"] = 04.82,
						["Winning01.ogg"] = 04.59,
						["Wound01.ogg"] = 00.53,
						["Wound02.ogg"] = 00.53,
						["Wound03.ogg"] = 00.67,
						["Wound04.ogg"] = 00.67,
						["Wound05.ogg"] = 00.71,
						["Wound06.ogg"] = 00.65,
						["Wound07.ogg"] = 00.53,
						["Wound08.ogg"] = 00.72,
						["Wound09.ogg"] = 00.58,
						["Wound10.ogg"] = 00.84,
						["WoundCritical01.ogg"] = 01.19,
						["WoundCritical02.ogg"] = 00.92,
						["WoundCritical03.ogg"] = 00.80,
						["WoundCritical04.ogg"] = 01.06,
						["WoundCritical05.ogg"] = 01.19,
					},
				},
				["CairneBloodhoof\\"] = {
					["CairneBloodhoofAggro01.ogg"] = 01.50,
					["CairneBloodhoofAggro02.ogg"] = 01.44,
					["CairneBloodhoofGreeting01.ogg"] = 04.06,
					["CairneBloodhoofGreeting02.ogg"] = 04.61,
					["CairneBloodhoofGreeting03.ogg"] = 04.30,
					["CairneBloodhoofGreeting04.ogg"] = 04.73,
				},
				["Caladis\\FS_"] = {
					["Caladis_"] = {
						["QuelDelar01.ogg"] = 03.91,
						["QuelDelar02.ogg"] = 03.39,
					},
				},
				["Calen\\VO_"] = {
					["QE_Calen_"] = {
						["Event01.ogg"] = 01.62,
						["Event02.ogg"] = 01.07,
						["Event03.ogg"] = 03.19,
						["Event04.ogg"] = 01.68,
						["Event05.ogg"] = 04.19,
						["Event06.ogg"] = 02.51,
						["Event07.ogg"] = 07.66,
						["Event08.ogg"] = 04.36,
					},
				},
				["Camel\\Camel_"] = {
					["Aggro_"] = {
						["01.ogg"] = 02.41,
						["02.ogg"] = 02.00,
						["03.ogg"] = 01.58,
						["04.ogg"] = 02.22,
						["05.ogg"] = 01.69,
						["06.ogg"] = 01.72,
						["07.ogg"] = 01.91,
						["08.ogg"] = 01.95,
						["09.ogg"] = 01.62,
						["10.ogg"] = 01.28,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 01.02,
						["02.ogg"] = 01.14,
						["03.ogg"] = 00.92,
						["04.ogg"] = 01.20,
						["05.ogg"] = 00.89,
					},
					["Attack_"] = {
						["01.ogg"] = 00.57,
						["02.ogg"] = 00.57,
						["03.ogg"] = 00.67,
						["04.ogg"] = 00.59,
						["05.ogg"] = 00.50,
						["06.ogg"] = 00.64,
						["07.ogg"] = 00.62,
						["08.ogg"] = 00.51,
						["09.ogg"] = 00.49,
						["10.ogg"] = 00.74,
					},
					["Death_"] = {
						["01.ogg"] = 01.06,
						["02.ogg"] = 01.17,
						["03.ogg"] = 01.32,
						["04.ogg"] = 01.13,
						["05.ogg"] = 01.11,
						["06.ogg"] = 01.29,
						["07.ogg"] = 01.11,
						["08.ogg"] = 01.30,
						["09.ogg"] = 01.31,
						["10.ogg"] = 01.37,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.43,
						["02.ogg"] = 01.64,
						["03.ogg"] = 01.52,
						["04.ogg"] = 01.63,
						["05.ogg"] = 01.69,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 00.60,
						["02.ogg"] = 00.58,
						["03.ogg"] = 00.62,
						["04.ogg"] = 00.67,
						["05.ogg"] = 00.74,
					},
					["Wound_"] = {
						["01.ogg"] = 00.79,
						["02.ogg"] = 00.52,
						["03.ogg"] = 00.59,
						["04.ogg"] = 00.56,
						["05.ogg"] = 00.58,
						["06.ogg"] = 00.55,
						["07.ogg"] = 00.51,
						["08.ogg"] = 00.58,
						["09.ogg"] = 00.60,
						["10.ogg"] = 00.52,
					},
				},
				["Cannon\\"] = {
					["CannonDeath.ogg"] = 02.30,
					["CannonWoundA.ogg"] = 01.18,
					["CannonWoundB.ogg"] = 01.13,
					["CannonWoundC.ogg"] = 01.03,
				},
				["CapDraeneiFem\\VO_"] = {
					["60_DRAENEI_"] = {
						["FEMALE_CAPTURED_"] = {
							["GREETING_"] = {
								["01.ogg"] = 01.96,
								["02.ogg"] = 02.83,
								["03.ogg"] = 01.64,
							},
						},
					},
				},
				["CapDraeneiMale\\VO_"] = {
					["60_DRAENEI_"] = {
						["MALE_CAPTURED_"] = {
							["GREETING_"] = {
								["01.ogg"] = 01.46,
								["02.ogg"] = 01.78,
								["03.ogg"] = 01.08,
							},
						},
					},
				},
				["CapOrcFem\\VO_"] = {
					["60_ORC_"] = {
						["FEMALE_CAPTURED_"] = {
							["GREETING_"] = {
								["01.ogg"] = 01.69,
								["02.ogg"] = 01.08,
								["03.ogg"] = 01.15,
							},
						},
					},
				},
				["CapOrcMale\\VO_"] = {
					["60_ORC_"] = {
						["MALE_CAPTURED_"] = {
							["GREETING_"] = {
								["01.ogg"] = 01.67,
								["02.ogg"] = 02.01,
								["03.ogg"] = 01.06,
							},
						},
					},
				},
				["Captain\\Captain_"] = {
					["W3ChpVIII01.ogg"] = 05.94,
					["W3ChpVIII03.ogg"] = 02.53,
					["W3ChpVIII05.ogg"] = 03.34,
					["W3ChpVIII07.ogg"] = 04.78,
				},
				["CaptainDoren\\VO_"] = {
					["Doren_"] = {
						["Airbase_Boss_"] = {
							["Fight_"] = {
								["01.OGG"] = 02.09,
								["02.OGG"] = 03.46,
								["03.OGG"] = 05.96,
								["04.OGG"] = 05.23,
							},
						},
						["Stronghold_Finale_01.OGG"] = 03.84,
					},
				},
				["CaptainDrok\\VO_"] = {
					["Theramore_Drok_"] = {
						["Speech_"] = {
							["01.OGG"] = 05.18,
							["02.OGG"] = 05.92,
							["03.OGG"] = 08.53,
							["04.OGG"] = 05.94,
							["05.OGG"] = 06.28,
							["06.OGG"] = 06.42,
							["07.OGG"] = 03.76,
							["05_ALT.OGG"] = 07.73,
						},
						["Gossip_01.OGG"] = 10.88,
					},
				},
				["CaptainKoramar\\VO_"] = {
					["60_"] = {
						["ID_KORAMAR_"] = {
							["DEATH.ogg"] = 02.69,
							["DIALOGUE02.ogg"] = 10.51,
							["DIALOGUE04.ogg"] = 18.14,
							["DIALOGUE07.ogg"] = 10.46,
							["DIALOGUE08.ogg"] = 11.32,
							["DIALOGUE10.ogg"] = 05.03,
							["DIALOGUE11.ogg"] = 03.67,
							["DIALOGUE14.ogg"] = 09.10,
							["DIALOGUE19.ogg"] = 15.27,
							["DIALOGUE21.ogg"] = 04.09,
							["DIALOGUE23.ogg"] = 05.56,
							["DIALOGUE25.ogg"] = 01.67,
							["DIALOGUE27.ogg"] = 02.56,
							["DIALOGUE29.ogg"] = 15.52,
							["DIALOGUE31.ogg"] = 05.15,
							["KILL01.ogg"] = 02.06,
							["KILL02.ogg"] = 03.60,
						},
						["KORAMAR_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.39,
								["02.ogg"] = 01.36,
								["03.ogg"] = 01.28,
								["04.ogg"] = 00.90,
								["05.ogg"] = 01.17,
							},
							["Attack_"] = {
								["01.ogg"] = 00.57,
								["010.ogg"] = 00.71,
								["02.ogg"] = 00.42,
								["03.ogg"] = 00.44,
								["04.ogg"] = 00.70,
								["05.ogg"] = 00.35,
								["06.ogg"] = 00.37,
								["07.ogg"] = 00.79,
								["08.ogg"] = 00.46,
								["09.ogg"] = 00.40,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 02.09,
								["02.ogg"] = 00.70,
								["03.ogg"] = 00.77,
								["04.ogg"] = 01.04,
								["05.ogg"] = 00.96,
							},
							["Wound_"] = {
								["01.ogg"] = 00.64,
								["02.ogg"] = 00.61,
								["03.ogg"] = 00.49,
								["04.ogg"] = 00.62,
								["05.ogg"] = 00.54,
								["06.ogg"] = 00.63,
								["07.ogg"] = 00.61,
								["08.ogg"] = 00.56,
							},
						},
					},
				},
				["CaptainScarloc\\CAV_"] = {
					["Scarloc_"] = {
						["Death01.ogg"] = 03.04,
						["Enter01.ogg"] = 09.62,
						["Slay01.ogg"] = 02.19,
						["Slay02.ogg"] = 03.53,
						["Taunt01.ogg"] = 02.71,
						["Taunt02.ogg"] = 05.35,
					},
				},
				["CardinalDeathwhisper\\IC_"] = {
					["Deathwhisper_"] = {
						["Aggro01.ogg"] = 11.10,
						["Attack01.ogg"] = 01.50,
						["Attack02.ogg"] = 00.78,
						["Attack03.ogg"] = 00.67,
						["Attack04.ogg"] = 00.84,
						["Attack05.ogg"] = 01.49,
						["Attack06.ogg"] = 01.35,
						["Attack07.ogg"] = 00.98,
						["Attack08.ogg"] = 01.28,
						["Attack09.ogg"] = 00.99,
						["Attack10.ogg"] = 01.06,
						["Berserk01.ogg"] = 02.56,
						["Death01.ogg"] = 09.26,
						["Event01a.ogg"] = 09.70,
						["Event01b.ogg"] = 07.64,
						["Event01c.ogg"] = 08.22,
						["Event02a.ogg"] = 09.81,
						["Event02b.ogg"] = 17.02,
						["Event03a.ogg"] = 10.51,
						["Event03b.ogg"] = 09.86,
						["P2.ogg"] = 05.37,
						["Slay01.ogg"] = 03.60,
						["Slay02.ogg"] = 04.85,
						["SP01.ogg"] = 07.85,
						["SP02.ogg"] = 04.09,
						["SP03.ogg"] = 05.29,
						["SP04.ogg"] = 05.37,
						["Wound01.ogg"] = 01.17,
						["Wound02.ogg"] = 01.07,
						["Wound03.ogg"] = 00.81,
						["Wound04.ogg"] = 00.65,
						["Wound05.ogg"] = 00.92,
						["Wound06.ogg"] = 00.82,
						["Wound07.ogg"] = 00.92,
						["Wound08.ogg"] = 01.47,
						["Wound09.ogg"] = 01.33,
						["Wound10.ogg"] = 01.08,
						["WoundCrit01.ogg"] = 01.39,
						["WoundCrit02.ogg"] = 01.82,
						["WoundCrit03.ogg"] = 01.24,
						["WoundCrit04.ogg"] = 01.75,
						["WoundCrit05.ogg"] = 01.56,
						["WoundCrit06.ogg"] = 01.13,
						["WoundCrit07.ogg"] = 01.24,
						["WoundCrit08.ogg"] = 00.99,
						["WoundCrit09.ogg"] = 01.15,
						["WoundCrit10.ogg"] = 00.96,
					},
				},
				["Carrion\\"] = {
					["mCarrionAggroA.ogg"] = 01.59,
					["mCarrionAttackA.ogg"] = 01.02,
					["mCarrionAttackB.ogg"] = 01.02,
					["mCarrionAttackC.ogg"] = 01.02,
					["mCarrionAttackD.ogg"] = 01.52,
					["mCarrionDeathA.ogg"] = 02.00,
					["mCarrionWoundA.ogg"] = 00.34,
					["mCarrionWoundB.ogg"] = 01.19,
					["mCarrionWoundC.ogg"] = 00.48,
					["mCarrionWoundCriticalA.ogg"] = 01.53,
				},
				["Cat\\"] = {
					["CatAggro.ogg"] = 01.22,
					["CatDeath.ogg"] = 00.50,
					["CatStepA.ogg"] = 00.70,
					["CatStepB.ogg"] = 00.90,
					["CatStepC.ogg"] = 00.60,
					["Float.ogg"] = 00.41,
				},
				["cataclysmcrocodile\\CataclysmCrocodile_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.43,
						["02.ogg"] = 01.26,
						["03.ogg"] = 01.04,
					},
					["Attacks_"] = {
						["01.ogg"] = 01.60,
						["02.ogg"] = 01.87,
						["03.ogg"] = 01.56,
						["04.ogg"] = 01.07,
						["05.ogg"] = 01.63,
						["06.ogg"] = 01.48,
					},
					["Death_"] = {
						["01.ogg"] = 02.17,
						["02.ogg"] = 02.73,
						["03.ogg"] = 02.65,
						["04.ogg"] = 01.98,
						["05.ogg"] = 01.53,
						["06.ogg"] = 01.82,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.26,
						["02.ogg"] = 01.14,
						["03.ogg"] = 00.92,
					},
					["StandVar1_"] = {
						["01.ogg"] = 01.83,
						["02.ogg"] = 01.79,
						["03.ogg"] = 01.52,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.80,
						["02.ogg"] = 01.66,
						["03.ogg"] = 01.33,
					},
					["Wound_"] = {
						["01.ogg"] = 01.27,
						["02.ogg"] = 01.24,
						["03.ogg"] = 01.39,
						["04.ogg"] = 01.20,
						["05.ogg"] = 01.35,
					},
				},
				["celestialhorse\\"] = {
					["CelestialHorse_MountSpecial_"] = {
						["01.ogg"] = 02.93,
						["02.ogg"] = 02.99,
						["03.ogg"] = 02.99,
					},
					["CelestialWound_"] = {
						["01.ogg"] = 02.13,
						["02.ogg"] = 02.66,
						["03.ogg"] = 02.68,
						["04.ogg"] = 02.60,
					},
				},
				["CELESTIALSERPENT\\MON_"] = {
					["CelestialSerpent_"] = {
						["Aggro_"] = {
							["01.OGG"] = 03.53,
							["02.OGG"] = 03.37,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 03.08,
							["02.OGG"] = 03.81,
						},
						["Attack_"] = {
							["01.OGG"] = 03.40,
							["02.OGG"] = 03.00,
							["03.OGG"] = 03.42,
							["04.OGG"] = 03.43,
							["05.OGG"] = 03.19,
						},
						["Chuff_"] = {
							["01.OGG"] = 02.61,
							["02.OGG"] = 02.97,
							["03.OGG"] = 02.94,
							["04.OGG"] = 02.54,
							["05.OGG"] = 02.68,
							["06.OGG"] = 02.90,
							["07.OGG"] = 02.83,
							["08.OGG"] = 02.50,
							["09.OGG"] = 03.01,
							["10.OGG"] = 02.54,
						},
						["Death_"] = {
							["01.OGG"] = 07.17,
							["02.OGG"] = 06.93,
						},
						["MountSpecial_"] = {
							["01.OGG"] = 05.58,
							["02.OGG"] = 04.51,
							["03.OGG"] = 04.25,
						},
						["Snarl_"] = {
							["01.OGG"] = 03.05,
							["02.OGG"] = 02.97,
							["03.OGG"] = 02.81,
							["04.OGG"] = 03.26,
							["05.OGG"] = 02.75,
						},
						["Stand_"] = {
							["01.OGG"] = 05.79,
							["02.OGG"] = 05.82,
							["03.OGG"] = 05.99,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 03.07,
							["02.OGG"] = 03.13,
						},
						["Wound_"] = {
							["01.OGG"] = 03.48,
							["02.OGG"] = 03.08,
							["03.OGG"] = 02.78,
							["04.OGG"] = 03.17,
							["05.OGG"] = 02.69,
						},
					},
				},
				["CenarionHatchling\\PET_"] = {
					["CenarionHatchling_"] = {
						["Clickable01.ogg"] = 01.06,
						["Clickable02.ogg"] = 00.96,
						["Clickable03.ogg"] = 01.20,
						["Clickable04.ogg"] = 01.33,
						["Clickable05.ogg"] = 01.25,
						["Clickable06.ogg"] = 00.85,
						["Clickable07.ogg"] = 00.60,
						["Clickable08.ogg"] = 00.76,
						["Clickable09.ogg"] = 00.92,
					},
				},
				["Cenarius\\VO_"] = {
					["FL_CENARIUS_"] = {
						["EVENT_"] = {
							["01.ogg"] = 03.92,
							["02.ogg"] = 00.96,
							["03.ogg"] = 09.29,
							["04.ogg"] = 00.87,
						},
					},
					["QE_HJ_"] = {
						["Cenarius_"] = {
							["Attack01.ogg"] = 00.73,
							["Attack02.ogg"] = 00.77,
							["Attack03.ogg"] = 00.85,
							["Attack04.ogg"] = 01.20,
							["Attack05.ogg"] = 01.09,
							["Attack06.ogg"] = 01.11,
							["Attack07.ogg"] = 00.98,
							["Attack08.ogg"] = 00.90,
							["Attack09.ogg"] = 01.10,
							["Attack10.ogg"] = 01.24,
							["AttackCritical01.ogg"] = 01.14,
							["AttackCritical02.ogg"] = 01.54,
							["AttackCritical03.ogg"] = 01.81,
							["AttackCritical04.ogg"] = 02.10,
							["AttackCritical05.ogg"] = 01.02,
							["Death01.ogg"] = 02.68,
							["Death02.ogg"] = 02.87,
							["Death03.ogg"] = 02.87,
							["Death04.ogg"] = 02.96,
							["Greeting01.ogg"] = 02.85,
							["Greeting02.ogg"] = 02.42,
							["Rag01.ogg"] = 07.37,
							["Rag02.ogg"] = 13.74,
							["Rag03.ogg"] = 09.37,
							["Rag04.ogg"] = 05.58,
							["RagEnd01.ogg"] = 07.76,
							["RagEnd02.ogg"] = 08.96,
							["Wound01.ogg"] = 00.68,
							["Wound02.ogg"] = 01.04,
							["Wound03.ogg"] = 00.82,
							["Wound04.ogg"] = 01.43,
							["Wound05.ogg"] = 00.77,
							["Wound06.ogg"] = 00.75,
							["Wound07.ogg"] = 01.18,
							["Wound08.ogg"] = 00.98,
							["Wound09.ogg"] = 00.96,
							["WoundCritical01.ogg"] = 01.59,
							["WoundCritical02.ogg"] = 01.01,
							["WoundCritical03.ogg"] = 01.28,
							["WoundCritical04.ogg"] = 01.27,
							["WoundCritical05.ogg"] = 01.40,
						},
					},
				},
				["Centaur\\"] = {
					["CentaurAggroA.ogg"] = 01.57,
					["CentaurAttackA.ogg"] = 01.85,
					["CentaurAttackB.ogg"] = 01.80,
					["CentaurAttackC.ogg"] = 01.80,
					["CentaurAttackD.ogg"] = 02.02,
					["CentaurDeathA.ogg"] = 02.24,
					["CentaurWoundA.ogg"] = 02.00,
					["CentaurWoundB.ogg"] = 01.73,
					["CentaurWoundC.ogg"] = 01.72,
					["CentaurWoundCrit.ogg"] = 01.75,
				},
				["CentaurFemale\\"] = {
					["CentaurFemaleAggro.ogg"] = 01.12,
					["CentaurFemaleAttackA.ogg"] = 01.27,
					["CentaurFemaleAttackB.ogg"] = 01.23,
					["CentaurFemaleAttackC.ogg"] = 01.13,
					["CentaurFemaleAttackD.ogg"] = 00.50,
					["CentaurFemaleDeath.ogg"] = 02.67,
					["CentaurFemalePreAggro.ogg"] = 00.63,
					["CentaurFemaleWoundA.ogg"] = 01.20,
					["CentaurFemaleWoundB.ogg"] = 01.33,
					["CentaurFemaleWoundC.ogg"] = 00.87,
					["CentaurFemaleWoundCrit.ogg"] = 01.94,
				},
				["ChaotheVoice\\VO_"] = {
					["Shadopan_ArmsWarrior_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.69,
							["02.OGG"] = 01.61,
							["03.OGG"] = 01.56,
							["04.OGG"] = 01.54,
							["05.OGG"] = 01.04,
							["06.OGG"] = 01.76,
						},
						["Attack_"] = {
							["01.OGG"] = 00.52,
							["02.OGG"] = 00.34,
							["03.OGG"] = 00.36,
							["04.OGG"] = 00.29,
							["05.OGG"] = 00.75,
							["06.OGG"] = 00.58,
							["07.OGG"] = 00.46,
							["08.OGG"] = 00.77,
							["09.OGG"] = 00.28,
							["10.OGG"] = 00.34,
						},
						["Challenge_"] = {
							["01.OGG"] = 03.52,
							["02.OGG"] = 02.60,
							["03.OGG"] = 00.84,
							["04.OGG"] = 02.49,
							["05.OGG"] = 01.86,
							["06.OGG"] = 02.03,
							["07.OGG"] = 05.10,
							["08.OGG"] = 03.38,
							["09.OGG"] = 04.48,
						},
						["Death_"] = {
							["01.OGG"] = 02.58,
							["02.OGG"] = 01.81,
							["03.OGG"] = 02.31,
							["04.OGG"] = 02.95,
							["05.OGG"] = 01.56,
							["06.OGG"] = 01.55,
							["07.OGG"] = 02.30,
							["08.OGG"] = 02.47,
						},
						["Farewell_"] = {
							["01.OGG"] = 00.75,
							["02.OGG"] = 00.71,
						},
						["Finale_"] = {
							["01.OGG"] = 01.65,
							["02.OGG"] = 02.40,
							["03.OGG"] = 01.36,
							["04.OGG"] = 01.65,
							["05.OGG"] = 02.08,
							["06.OGG"] = 03.05,
							["07.OGG"] = 03.05,
							["08.OGG"] = 01.44,
						},
						["Generic_"] = {
							["01.OGG"] = 02.07,
							["02.OGG"] = 01.69,
							["03.OGG"] = 01.86,
							["04.OGG"] = 01.50,
							["05.OGG"] = 01.87,
							["06.OGG"] = 01.39,
							["07.OGG"] = 03.17,
							["08.OGG"] = 03.63,
							["09.OGG"] = 02.25,
							["10.OGG"] = 01.96,
							["11.OGG"] = 01.63,
							["12.OGG"] = 01.69,
						},
						["Greeting_"] = {
							["01.OGG"] = 02.16,
							["02.OGG"] = 01.14,
							["03.OGG"] = 01.82,
							["04.OGG"] = 00.72,
							["05.OGG"] = 01.22,
						},
						["Pissed_"] = {
							["01.OGG"] = 03.41,
							["02.OGG"] = 01.90,
							["03.OGG"] = 02.15,
							["04.OGG"] = 09.30,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.92,
							["02.OGG"] = 01.27,
							["03.OGG"] = 00.87,
							["04.OGG"] = 01.17,
							["05.OGG"] = 01.40,
							["06.OGG"] = 00.89,
						},
						["Wound_"] = {
							["01.OGG"] = 00.45,
							["02.OGG"] = 00.43,
							["03.OGG"] = 00.52,
							["04.OGG"] = 00.24,
							["05.OGG"] = 00.43,
							["06.OGG"] = 00.51,
							["07.OGG"] = 00.54,
							["08.OGG"] = 00.58,
							["09.OGG"] = 00.43,
						},
					},
				},
				["Charlga\\VO_"] = {
					["60_"] = {
						["CHARLGA_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.52,
								["02.OGG"] = 02.06,
								["03.OGG"] = 01.09,
								["04.OGG"] = 01.00,
								["05.OGG"] = 01.46,
							},
							["Attack_"] = {
								["01.OGG"] = 00.68,
								["02.OGG"] = 00.58,
								["03.OGG"] = 00.81,
								["04.OGG"] = 00.71,
								["05.OGG"] = 00.77,
								["06.OGG"] = 00.75,
								["07.OGG"] = 00.89,
								["08.OGG"] = 00.96,
								["09.OGG"] = 00.66,
							},
							["WoundCrit_"] = {
								["00.OGG"] = 00.93,
								["01.OGG"] = 01.63,
								["02.OGG"] = 00.54,
								["03.OGG"] = 00.54,
								["04.OGG"] = 00.50,
								["05.OGG"] = 00.99,
							},
							["Wound_"] = {
								["00.OGG"] = 00.54,
								["01.OGG"] = 00.78,
								["02.OGG"] = 00.49,
								["03.OGG"] = 00.87,
								["04.OGG"] = 00.39,
								["05.OGG"] = 00.80,
								["06.OGG"] = 00.72,
								["07.OGG"] = 00.35,
							},
						},
						["RFK_CHARLGA_"] = {
							["AGGRO.OGG"] = 04.94,
							["DEATH.OGG"] = 04.68,
							["INTRO.OGG"] = 05.34,
							["KILL.OGG"] = 03.01,
							["SPELL1.OGG"] = 02.29,
							["SPELL2.OGG"] = 02.48,
							["SPELL3.OGG"] = 03.60,
						},
					},
				},
				["CharlgaRazorflank\\"] = {
					["CharlgaRazorflankAggro01.ogg"] = 04.15,
					["CharlgaRazorflankHealth01.ogg"] = 04.26,
					["CharlgaRazorflankHealth02.ogg"] = 03.37,
					["CharlgaRazorflankHealth03.ogg"] = 02.81,
					["CharlgaRazorflankSlay01.ogg"] = 01.13,
				},
				["ChenStormstout\\VO_"] = {
					["CHENSTORMSTOUT_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 00.87,
							["02.OGG"] = 00.91,
							["03.OGG"] = 01.28,
							["04.OGG"] = 01.18,
							["05.OGG"] = 01.67,
						},
						["ATTACK_"] = {
							["01.OGG"] = 00.38,
							["02.OGG"] = 00.39,
							["03.OGG"] = 00.44,
							["04.OGG"] = 00.52,
							["05.OGG"] = 00.58,
							["06.OGG"] = 00.36,
							["07.OGG"] = 00.43,
							["08.OGG"] = 00.56,
							["09.OGG"] = 00.46,
							["10.OGG"] = 00.51,
						},
						["DEATH_"] = {
							["01.OGG"] = 04.16,
							["02.OGG"] = 04.89,
							["03.OGG"] = 04.32,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 00.70,
							["02.OGG"] = 01.27,
							["03.OGG"] = 00.87,
							["04.OGG"] = 01.20,
							["05.OGG"] = 01.24,
						},
						["WOUND_"] = {
							["01.OGG"] = 00.31,
							["02.OGG"] = 01.28,
							["03.OGG"] = 00.39,
							["04.OGG"] = 00.36,
							["05.OGG"] = 00.48,
							["06.OGG"] = 00.36,
							["07.OGG"] = 01.28,
							["08.OGG"] = 00.47,
							["09.OGG"] = 00.52,
							["10.OGG"] = 00.57,
						},
					},
					["CHEN_"] = {
						["EVENT_"] = {
							["BONKERS_BREWERY_"] = {
								["01.OGG"] = 01.67,
								["02.OGG"] = 02.60,
								["03.OGG"] = 02.17,
								["04.OGG"] = 01.21,
								["05.OGG"] = 01.69,
							},
							["BROKEN_DREAMS_"] = {
								["01.OGG"] = 02.98,
								["02.OGG"] = 04.65,
								["03.OGG"] = 03.24,
								["04.OGG"] = 05.14,
								["05.OGG"] = 03.15,
								["06.OGG"] = 02.90,
								["07.OGG"] = 03.28,
								["08.OGG"] = 07.90,
								["09.OGG"] = 05.38,
								["11.OGG"] = 05.89,
								["12.OGG"] = 05.78,
								["13.OGG"] = 05.14,
								["15.OGG"] = 09.36,
								["16.OGG"] = 02.55,
							},
							["CHENS_RESOLUTION_"] = {
								["01.OGG"] = 05.03,
								["02.OGG"] = 04.77,
								["03.OGG"] = 02.05,
								["04.OGG"] = 05.67,
								["05.OGG"] = 06.58,
								["06.OGG"] = 02.05,
							},
							["CHEN_"] = {
								["AND_LI_"] = {
									["LI_"] = {
										["01.OGG"] = 04.88,
										["02.OGG"] = 03.51,
										["03.OGG"] = 05.64,
										["04.OGG"] = 10.23,
									},
								},
								["INTRO_"] = {
									["01.OGG"] = 09.15,
									["02.OGG"] = 06.71,
									["03A.OGG"] = 01.05,
									["03B.OGG"] = 02.54,
									["04.OGG"] = 01.61,
									["05.OGG"] = 04.35,
									["06.OGG"] = 05.68,
									["07.OGG"] = 10.93,
									["08.OGG"] = 07.85,
									["09.OGG"] = 07.71,
								},
							},
							["CLEANING_HOUSE_"] = {
								["01.OGG"] = 02.47,
								["03.OGG"] = 04.25,
								["04.OGG"] = 03.90,
								["05.OGG"] = 01.00,
								["06.OGG"] = 02.12,
								["07.OGG"] = 05.33,
								["08.OGG"] = 06.15,
							},
							["GREAT_MINDS_"] = {
								["01.OGG"] = 03.75,
								["02.OGG"] = 06.69,
								["03.OGG"] = 03.47,
								["04.OGG"] = 01.76,
								["05.OGG"] = 05.56,
								["06.OGG"] = 01.97,
								["07.OGG"] = 05.02,
								["08.OGG"] = 03.68,
								["09.OGG"] = 05.18,
								["10.OGG"] = 07.24,
							},
							["KNOCKING_ON_"] = {
								["THE_DOOR_"] = {
									["01.OGG"] = 03.34,
									["02.OGG"] = 02.61,
									["03.OGG"] = 01.88,
									["04.OGG"] = 05.96,
									["05.OGG"] = 06.85,
									["06.OGG"] = 02.51,
									["07.OGG"] = 04.18,
									["08.OGG"] = 01.21,
									["09.OGG"] = 03.53,
									["10.OGG"] = 01.36,
									["11.OGG"] = 06.15,
									["12.OGG"] = 05.56,
									["13.OGG"] = 00.95,
									["14.OGG"] = 03.12,
								},
							},
							["LEGACY_"] = {
								["01.OGG"] = 05.53,
								["02.OGG"] = 04.82,
								["03.OGG"] = 05.32,
								["04.OGG"] = 07.97,
								["05.OGG"] = 04.24,
								["06.OGG"] = 03.38,
							},
							["THE_EMPEROR_"] = {
								["01.OGG"] = 03.87,
								["02.OGG"] = 04.04,
								["03.OGG"] = 04.80,
								["04.OGG"] = 06.11,
								["05.OGG"] = 03.76,
							},
							["LI_LIS_DAY_OFF_01.OGG"] = 02.91,
						},
						["STORMSTOUT_"] = {
							["DW_"] = {
								["EVIE_EULOGY_"] = {
									["01.OGG"] = 03.53,
									["02.OGG"] = 02.28,
									["03.OGG"] = 03.83,
									["04.OGG"] = 05.81,
									["05.OGG"] = 03.18,
									["06.OGG"] = 02.30,
								},
								["HAN_EULOGY_"] = {
									["01.OGG"] = 04.04,
									["02.OGG"] = 05.36,
									["03.OGG"] = 03.14,
									["04.OGG"] = 04.71,
								},
								["INTRO_"] = {
									["01.OGG"] = 02.21,
									["02.OGG"] = 01.95,
									["03.OGG"] = 05.04,
									["04.OGG"] = 02.95,
								},
							},
							["Farewell_"] = {
								["01.OGG"] = 01.65,
								["02.OGG"] = 01.78,
								["03.OGG"] = 03.57,
								["04.OGG"] = 01.65,
							},
							["Greeting_"] = {
								["01.OGG"] = 03.36,
								["02.OGG"] = 02.07,
								["03.OGG"] = 01.28,
								["04.OGG"] = 02.26,
								["05.OGG"] = 00.84,
								["06.OGG"] = 00.99,
							},
							["Pissed_"] = {
								["01.OGG"] = 04.66,
								["02.OGG"] = 12.36,
								["03.OGG"] = 11.03,
								["04.OGG"] = 09.85,
								["05.OGG"] = 06.49,
							},
							["VFW_FINALE_"] = {
								["01.OGG"] = 01.26,
								["02.OGG"] = 03.57,
								["03.OGG"] = 14.27,
								["04.OGG"] = 15.51,
							},
						},
					},
					["CHUFA_CHEN_"] = {
						["EVENT_"] = {
							["01.OGG"] = 01.25,
							["02.OGG"] = 00.84,
							["03.OGG"] = 03.56,
							["04.OGG"] = 03.21,
						},
					},
					["DW_CHEN_"] = {
						["STORMSTOUT_MAMA_"] = {
							["FIGHT_"] = {
								["01.OGG"] = 04.63,
								["02.OGG"] = 03.85,
								["03.OGG"] = 04.25,
							},
							["RESOLUTION_"] = {
								["01.OGG"] = 05.80,
								["02.OGG"] = 04.21,
								["04.OGG"] = 02.96,
							},
						},
					},
					["SB_CHEN_"] = {
						["EVENT_"] = {
							["01.OGG"] = 04.12,
							["02.OGG"] = 02.37,
							["03.OGG"] = 04.41,
							["04.OGG"] = 03.96,
							["05.OGG"] = 02.94,
							["06.OGG"] = 05.83,
							["07.OGG"] = 04.51,
							["08.OGG"] = 04.77,
							["09.OGG"] = 02.90,
							["10.OGG"] = 02.53,
							["07_ALT.OGG"] = 05.80,
						},
					},
					["53_Chen_Laugh_01.OGG"] = 00.64,
				},
				["Chicken\\"] = {
					["ChickenDeathA.ogg"] = 00.84,
					["ChickenWoundA.ogg"] = 00.96,
				},
				["ChickenMount\\"] = {
					["ChickenMountSpecialMount.ogg"] = 03.22,
					["ChickenMountWound1.ogg"] = 00.54,
					["ChickenMountWound2.ogg"] = 00.79,
				},
				["ChiefSalyis\\VO_"] = {
					["MP_Salyis_"] = {
						["AGRO_01.OGG"] = 03.91,
						["DEATH_01.OGG"] = 03.40,
						["INTRO_01.OGG"] = 07.34,
						["SLAY_01.OGG"] = 03.28,
						["SPELL_01.OGG"] = 07.59,
					},
				},
				["ChiefUkorzSandscalp\\"] = {
					["ChiefUkorzSandscalpAggro01.ogg"] = 01.71,
					["ChiefUkorzSandscalpHealth01.ogg"] = 02.41,
					["ChiefUkorzSandscalpSlay01.ogg"] = 01.25,
					["ChiefUkorzSandscalpSummon01.ogg"] = 03.22,
				},
				["Chiji\\VO_"] = {
					["5.1_ALP_"] = {
						["RedCrane_"] = {
							["Conclude_"] = {
								["01.OGG"] = 07.42,
								["02.OGG"] = 06.49,
							},
							["Opng_01.OGG"] = 08.48,
						},
					},
					["53_Chiji_"] = {
						["Wrathion_"] = {
							["Advice_"] = {
								["01.OGG"] = 06.02,
								["02.OGG"] = 05.09,
								["03.OGG"] = 03.65,
								["04.OGG"] = 06.14,
								["05.OGG"] = 06.63,
								["06.OGG"] = 06.89,
								["07.OGG"] = 07.13,
							},
							["Challenge_"] = {
								["01.OGG"] = 09.05,
								["02.OGG"] = 06.42,
							},
							["Channel_"] = {
								["01.OGG"] = 07.61,
								["02.OGG"] = 05.62,
							},
							["Meet_"] = {
								["01.OGG"] = 10.69,
								["02.OGG"] = 07.34,
								["03.OGG"] = 04.65,
								["04.OGG"] = 03.10,
								["05.OGG"] = 09.69,
								["06.OGG"] = 06.41,
								["07.OGG"] = 08.90,
								["08.OGG"] = 08.13,
							},
							["Victory_"] = {
								["01.OGG"] = 04.22,
								["02.OGG"] = 09.98,
								["03.OGG"] = 03.94,
								["04.OGG"] = 06.04,
								["05.OGG"] = 11.75,
							},
						},
					},
					["54_"] = {
						["TI_CHIJI_"] = {
							["SPELL_"] = {
								["1.OGG"] = 05.58,
								["2.OGG"] = 04.96,
								["3.OGG"] = 04.04,
							},
							["AGGRO.OGG"] = 03.36,
							["DEATH.OGG"] = 14.49,
							["INTRO.OGG"] = 11.40,
							["KILL.OGG"] = 03.64,
						},
						["RED_CRANE_LEGENDARY_CELE_01.OGG"] = 04.88,
					},
					["Golden_Valley_"] = {
						["Finale_Chiji_"] = {
							["01.OGG"] = 05.20,
							["02.OGG"] = 07.34,
						},
					},
					["Quest_Boss_"] = {
						["Encounter_"] = {
							["01.OGG"] = 06.33,
							["02.OGG"] = 04.20,
							["03.OGG"] = 06.68,
							["04.OGG"] = 06.00,
						},
					},
					["Red_Crane_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 01.59,
							["02.OGG"] = 01.72,
							["03.OGG"] = 01.80,
							["04.OGG"] = 01.73,
							["05.OGG"] = 01.60,
						},
						["ATTACK_"] = {
							["01.OGG"] = 01.07,
							["02.OGG"] = 01.21,
							["03.OGG"] = 01.02,
							["04.OGG"] = 01.10,
							["05.OGG"] = 01.05,
							["06.OGG"] = 01.04,
							["07.OGG"] = 01.09,
							["08.OGG"] = 01.05,
							["09.OGG"] = 01.06,
							["10.OGG"] = 01.01,
						},
						["DEATH_"] = {
							["01.OGG"] = 03.32,
							["02.OGG"] = 02.67,
							["03.OGG"] = 03.03,
							["04.OGG"] = 02.30,
							["05.OGG"] = 02.71,
							["06.OGG"] = 02.15,
							["07.OGG"] = 03.19,
						},
						["Farewell_"] = {
							["01.OGG"] = 02.97,
							["02.OGG"] = 02.15,
							["03.OGG"] = 01.95,
						},
						["Greeting_"] = {
							["01.OGG"] = 02.21,
							["02.OGG"] = 01.56,
							["03.OGG"] = 02.14,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 01.84,
							["02.OGG"] = 01.40,
							["03.OGG"] = 01.83,
							["04.OGG"] = 01.67,
							["05.OGG"] = 02.06,
						},
						["WOUND_"] = {
							["01.OGG"] = 01.32,
							["02.OGG"] = 01.18,
							["03.OGG"] = 01.42,
							["04.OGG"] = 01.14,
							["05.OGG"] = 01.06,
							["06.OGG"] = 01.15,
							["07.OGG"] = 01.19,
							["08.OGG"] = 01.04,
							["09.OGG"] = 01.14,
							["10.OGG"] = 01.17,
						},
					},
					["Kun_Lai_Red_Crane_Gates_Event_01.OGG"] = 03.56,
				},
				["Child1\\VO_"] = {
					["60_SMV_"] = {
						["TOUR_CHILDREN_"] = {
							["01.ogg"] = 02.53,
							["06.ogg"] = 01.98,
						},
					},
				},
				["Child2\\VO_"] = {
					["60_SMV_"] = {
						["TOUR_CHILDREN_"] = {
							["02.ogg"] = 00.89,
							["05.ogg"] = 01.10,
						},
					},
				},
				["Child3\\VO_"] = {
					["60_SMV_"] = {
						["TOUR_CHILDREN_"] = {
							["03.ogg"] = 01.58,
							["04.ogg"] = 01.84,
						},
					},
				},
				["Chimera\\MON_"] = {
					["ChimeraMount_"] = {
						["Chuffs_"] = {
							["01.OGG"] = 02.27,
							["010.OGG"] = 02.01,
							["02.OGG"] = 02.42,
							["03.OGG"] = 02.43,
							["04.OGG"] = 02.42,
							["05.OGG"] = 02.58,
							["06.OGG"] = 02.89,
							["07.OGG"] = 02.76,
							["08.OGG"] = 02.37,
							["09.OGG"] = 02.25,
						},
						["Special_"] = {
							["01.OGG"] = 06.84,
							["02.OGG"] = 06.83,
							["03.OGG"] = 06.06,
							["04.OGG"] = 06.07,
							["05.OGG"] = 06.60,
						},
					},
				},
				["Chimera2\\MON_"] = {
					["Chimera_"] = {
						["Aggro_"] = {
							["01.OGG"] = 02.39,
							["02.OGG"] = 02.10,
							["03.OGG"] = 02.56,
							["04.OGG"] = 02.90,
							["05.OGG"] = 02.26,
						},
						["Attack1_"] = {
							["01.OGG"] = 01.54,
							["02.OGG"] = 01.19,
							["03.OGG"] = 01.40,
							["04.OGG"] = 01.25,
							["05.OGG"] = 01.28,
						},
						["Attack2_"] = {
							["01.OGG"] = 01.69,
							["02.OGG"] = 01.70,
							["03.OGG"] = 01.88,
							["04.OGG"] = 01.58,
							["05.OGG"] = 01.85,
						},
						["Death_"] = {
							["01.OGG"] = 02.13,
							["02.OGG"] = 02.14,
							["03.OGG"] = 02.17,
							["04.OGG"] = 02.48,
							["05.OGG"] = 02.07,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.60,
							["02.OGG"] = 01.36,
							["03.OGG"] = 01.25,
							["04.OGG"] = 01.55,
							["05.OGG"] = 01.48,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.51,
							["02.OGG"] = 01.50,
							["03.OGG"] = 01.57,
							["04.OGG"] = 01.74,
							["05.OGG"] = 01.36,
						},
						["Wound_"] = {
							["01.OGG"] = 01.03,
							["02.OGG"] = 01.24,
							["03.OGG"] = 01.26,
							["04.OGG"] = 01.39,
							["05.OGG"] = 01.62,
							["06.OGG"] = 01.67,
							["07.OGG"] = 01.29,
							["08.OGG"] = 01.26,
							["09.OGG"] = 01.42,
							["10.OGG"] = 01.32,
						},
					},
				},
				["ChineseDragon\\"] = {
					["ChineseDragonAggro.ogg"] = 01.81,
					["ChineseDragonAttack3.ogg"] = 01.06,
					["ChineseDragonAttackA.ogg"] = 00.85,
					["ChineseDragonDeath.ogg"] = 02.37,
					["ChineseDragonPreAggro.ogg"] = 01.51,
					["ChineseDragonPreAttack2.ogg"] = 01.03,
					["ChineseDragonWoundA.ogg"] = 01.30,
					["ChineseDragonWoundB.ogg"] = 01.04,
					["ChineseDragonWoundC.ogg"] = 01.15,
					["ChineseDragonWoundCrit.ogg"] = 01.29,
				},
				["Cho\\VO_"] = {
					["60_"] = {
						["CHO_"] = {
							["AttackCrit_"] = {
								["02.ogg"] = 02.39,
								["03.ogg"] = 01.72,
								["04.ogg"] = 01.59,
								["05.ogg"] = 01.42,
							},
							["Attack_"] = {
								["02.ogg"] = 00.73,
								["03.ogg"] = 00.67,
								["04.ogg"] = 00.62,
								["05.ogg"] = 00.79,
							},
							["WoundCrit_"] = {
								["02.ogg"] = 02.30,
								["03.ogg"] = 01.64,
								["04.ogg"] = 00.90,
								["05.ogg"] = 02.53,
							},
							["Wound_"] = {
								["02.ogg"] = 01.52,
								["03.ogg"] = 00.47,
								["04.ogg"] = 00.49,
								["05.ogg"] = 00.47,
							},
						},
						["HMR_CHO_"] = {
							["KILL3.ogg"] = 02.06,
							["KILL4.ogg"] = 02.60,
						},
					},
				},
				["Chogall\\VO_"] = {
					["60_"] = {
						["FR_CHOGALL_"] = {
							["SLEEPER_"] = {
								["01.ogg"] = 06.02,
								["02.ogg"] = 05.76,
							},
						},
						["HMR_CHOGALL_"] = {
							["AGGRO.ogg"] = 16.58,
							["BERSERK.ogg"] = 07.77,
							["DEATH.ogg"] = 09.89,
							["EVENT1.ogg"] = 09.48,
							["EVENT2.ogg"] = 11.35,
							["INTRO1.ogg"] = 16.07,
							["INTRO2.ogg"] = 09.61,
							["SPELL1.ogg"] = 06.00,
							["SPELL2.ogg"] = 07.18,
							["SPELL3.ogg"] = 04.64,
							["SPELL4.ogg"] = 05.80,
						},
						["NGD_RITUAL_"] = {
							["CHOGALL_"] = {
								["01.ogg"] = 03.58,
								["02.ogg"] = 04.57,
								["03.ogg"] = 04.77,
								["04.ogg"] = 07.88,
							},
						},
						["TAN_CHOGALL_"] = {
							["SHADOW_"] = {
								["01.ogg"] = 08.28,
								["02.ogg"] = 09.56,
							},
						},
						["SMV_GULDAN_SPY_CHOGALL_01.ogg"] = 03.50,
					},
					["BT_Chogall_"] = {
						["Attack01.ogg"] = 00.42,
						["Attack02.ogg"] = 00.89,
						["Attack03.ogg"] = 00.77,
						["Attack04.ogg"] = 01.00,
						["Attack05.ogg"] = 00.89,
						["Attack06.ogg"] = 00.79,
						["Attack07.ogg"] = 00.71,
						["Attack08.ogg"] = 00.75,
						["Attack09.ogg"] = 00.87,
						["Attack10.ogg"] = 00.97,
						["AttackCrit01.ogg"] = 01.20,
						["AttackCrit02.ogg"] = 01.34,
						["AttackCrit03.ogg"] = 01.21,
						["AttackCrit04.ogg"] = 00.97,
						["AttackCrit05.ogg"] = 01.17,
						["BotEvent01.ogg"] = 16.11,
						["BotEvent02.ogg"] = 13.57,
						["BotEvent03.ogg"] = 13.60,
						["BotEvent04.ogg"] = 18.28,
						["BotEvent05.ogg"] = 15.48,
						["BotEvent06.ogg"] = 05.44,
						["BotEvent07.ogg"] = 12.30,
						["BotEvent08.ogg"] = 12.27,
						["BotEvent09.ogg"] = 07.24,
						["BotEvent10.ogg"] = 04.17,
						["BotEvent11.ogg"] = 08.52,
						["BotEvent12.ogg"] = 13.12,
						["BotEvent13.ogg"] = 14.16,
						["BotEvent14.ogg"] = 28.56,
						["BotEvent15.ogg"] = 34.15,
						["BotEvent16.ogg"] = 02.03,
						["BotEvent17.ogg"] = 01.90,
						["BotEvent18.ogg"] = 01.95,
						["BotEvent19.ogg"] = 02.41,
						["BotEvent20.ogg"] = 01.94,
						["BotEvent21.ogg"] = 03.99,
						["BotEvent22.ogg"] = 04.23,
						["BotEvent23.ogg"] = 04.36,
						["BotEvent24.ogg"] = 04.09,
						["BotEvent25.ogg"] = 02.06,
						["BotEvent26.ogg"] = 03.74,
						["BotEvent27.ogg"] = 02.28,
						["BotEvent28.ogg"] = 10.00,
						["BotEvent29.ogg"] = 01.98,
						["BotEvent30.ogg"] = 02.47,
						["BotEvent31.ogg"] = 04.70,
						["BotEvent32.ogg"] = 02.95,
						["BotEvent33.ogg"] = 02.68,
						["BotEvent34.ogg"] = 03.58,
						["BotEvent35.ogg"] = 02.94,
						["BotEvent36.ogg"] = 03.15,
						["BotEvent37.ogg"] = 05.30,
						["BotEvent38.ogg"] = 02.64,
						["BotEvent39.ogg"] = 03.60,
						["BotEvent40.ogg"] = 30.92,
						["BotEvent41.ogg"] = 04.41,
						["BotEvent42.ogg"] = 03.18,
						["BotEvent43.ogg"] = 05.65,
						["BotEvent44.ogg"] = 08.89,
						["BotEvent45.ogg"] = 06.10,
						["BotEvent46.ogg"] = 12.81,
						["BotEvent47.ogg"] = 21.19,
						["BotEvent48.ogg"] = 04.56,
						["Wound01.ogg"] = 00.58,
						["Wound02.ogg"] = 00.82,
						["Wound03.ogg"] = 01.11,
						["Wound04.ogg"] = 00.85,
						["Wound05.ogg"] = 00.85,
						["Wound06.ogg"] = 00.42,
						["Wound07.ogg"] = 00.47,
						["Wound08.ogg"] = 00.51,
						["Wound09.ogg"] = 00.55,
						["Wound10.ogg"] = 00.63,
						["WoundCrit01.ogg"] = 01.96,
						["WoundCrit02.ogg"] = 01.82,
						["WoundCrit03.ogg"] = 00.85,
						["WoundCrit04.ogg"] = 00.80,
						["WoundCrit05.ogg"] = 00.91,
						["WoundCrit06.ogg"] = 00.88,
					},
					["QE_Chogall_"] = {
						["FAggro01.ogg"] = 07.93,
						["FAggro02.ogg"] = 07.82,
						["FAggro03.ogg"] = 05.02,
						["FEnd01.ogg"] = 09.90,
						["FEvent01.ogg"] = 14.95,
						["FEvent02.ogg"] = 14.48,
						["FEvent03.ogg"] = 19.11,
						["FIntro01.ogg"] = 09.06,
						["FIntro02.ogg"] = 15.94,
						["FIntro03.ogg"] = 09.61,
						["TwilEvent01.ogg"] = 05.20,
						["TwilEvent02.ogg"] = 08.13,
						["TwilEvent03.ogg"] = 08.67,
						["TwilEvent04.ogg"] = 15.90,
						["TwilEvent05.ogg"] = 13.71,
						["TwilEvent06.ogg"] = 13.18,
						["TwilEvent07.ogg"] = 09.60,
						["TwilEvent08.ogg"] = 04.34,
						["TwilEvent09.ogg"] = 04.00,
						["TwilEvent10.ogg"] = 16.08,
						["TwilEvent11.ogg"] = 16.01,
						["TwilEvent12.ogg"] = 15.09,
						["TwilEvent13.ogg"] = 06.05,
						["TwilEvent14.ogg"] = 07.81,
						["TwilEvent15.ogg"] = 13.77,
						["TwilEvent16.ogg"] = 10.47,
						["TwilEvent17.ogg"] = 24.25,
					},
				},
				["ChromaticDragon\\MON_"] = {
					["Chromatic_Dragon_"] = {
						["Roar_"] = {
							["01.OGG"] = 03.41,
							["02.OGG"] = 02.75,
							["03.OGG"] = 03.99,
							["04.OGG"] = 03.18,
							["05.OGG"] = 03.12,
						},
						["Wound_"] = {
							["01.OGG"] = 02.92,
							["02.OGG"] = 02.94,
							["03.OGG"] = 02.78,
							["04.OGG"] = 02.50,
							["05.OGG"] = 02.49,
						},
					},
				},
				["Chromie\\VO_"] = {
					["60_"] = {
						["CHROMIE_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.81,
								["02.ogg"] = 00.84,
								["03.ogg"] = 00.91,
								["04.ogg"] = 01.81,
								["05.ogg"] = 01.08,
							},
							["Attack_"] = {
								["01.ogg"] = 00.34,
								["010.ogg"] = 00.38,
								["02.ogg"] = 00.43,
								["03.ogg"] = 00.56,
								["04.ogg"] = 00.35,
								["05.ogg"] = 00.57,
								["06.ogg"] = 00.47,
								["07.ogg"] = 00.79,
								["08.ogg"] = 00.37,
								["09.ogg"] = 00.41,
							},
							["Death_"] = {
								["01.ogg"] = 02.27,
								["02.ogg"] = 02.67,
								["03.ogg"] = 02.54,
								["04.ogg"] = 02.49,
								["05.ogg"] = 02.89,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 02.04,
								["02.ogg"] = 01.79,
								["03.ogg"] = 01.66,
								["04.ogg"] = 01.56,
								["05.ogg"] = 01.26,
							},
							["Wound_"] = {
								["01.ogg"] = 00.32,
								["010.ogg"] = 00.38,
								["02.ogg"] = 00.42,
								["03.ogg"] = 00.35,
								["04.ogg"] = 00.42,
								["05.ogg"] = 00.32,
								["06.ogg"] = 00.28,
								["07.ogg"] = 00.43,
								["08.ogg"] = 00.51,
								["09.ogg"] = 00.69,
							},
						},
						["LQ_CHROMIE_"] = {
							["GREETING_"] = {
								["01.ogg"] = 00.60,
								["02.ogg"] = 00.99,
								["03.ogg"] = 02.41,
							},
							["TARNISHED_"] = {
								["01.ogg"] = 01.16,
								["02.ogg"] = 01.63,
								["03.ogg"] = 02.74,
								["04.ogg"] = 07.44,
								["05.ogg"] = 06.51,
								["06.ogg"] = 05.15,
								["07.ogg"] = 04.20,
								["08.ogg"] = 06.13,
								["09.ogg"] = 03.05,
								["10.ogg"] = 02.26,
								["11.ogg"] = 03.05,
								["12.ogg"] = 02.02,
								["13.ogg"] = 00.89,
								["14.ogg"] = 01.26,
								["15.ogg"] = 03.05,
								["16.ogg"] = 00.75,
								["17.ogg"] = 01.40,
								["18.ogg"] = 02.79,
								["19.ogg"] = 02.42,
							},
						},
					},
				},
				["ChronoLordDeja\\CAV_"] = {
					["Chrono_"] = {
						["Aggro01.ogg"] = 12.93,
						["Banish01.ogg"] = 11.41,
						["Death01.ogg"] = 11.35,
						["Enter01.ogg"] = 17.51,
						["Slay01.ogg"] = 08.58,
						["Slay02.ogg"] = 08.98,
					},
				},
				["ChronoLordEpoch\\CS_"] = {
					["Epoch_"] = {
						["Aggro.ogg"] = 06.03,
						["Attack01.ogg"] = 00.75,
						["Attack02.ogg"] = 00.78,
						["Attack03.ogg"] = 01.05,
						["Attack04.ogg"] = 00.84,
						["Attack05.ogg"] = 01.02,
						["Death.ogg"] = 02.95,
						["IntroSpeech.ogg"] = 15.42,
						["Slay01.ogg"] = 04.72,
						["Slay02.ogg"] = 06.36,
						["Slay03.ogg"] = 06.57,
						["TimeWarp01.ogg"] = 05.20,
						["TimeWarp02.ogg"] = 05.03,
						["TimeWarp03.ogg"] = 04.75,
						["Wound01.ogg"] = 00.77,
						["Wound02.ogg"] = 00.78,
						["Wound03.ogg"] = 00.67,
						["Wound04.ogg"] = 00.69,
						["Wound05.ogg"] = 00.68,
						["WoundCrit01.ogg"] = 00.76,
						["WoundCrit02.ogg"] = 00.80,
						["WoundCrit03.ogg"] = 00.77,
					},
				},
				["CinderKitty\\PET_"] = {
					["CinderKitty_"] = {
						["Attack01.OGG"] = 01.42,
						["Attack02.OGG"] = 01.48,
						["Attack03.OGG"] = 01.87,
						["AttackCrit01.OGG"] = 01.74,
						["AttackCrit02.OGG"] = 02.44,
						["AttackCrit03.OGG"] = 01.92,
						["Clickable01.OGG"] = 02.02,
						["Clickable02.OGG"] = 02.27,
						["Clickable03.OGG"] = 01.88,
						["Clickable04.OGG"] = 01.93,
						["Clickable05.OGG"] = 02.01,
						["Clickable06.OGG"] = 02.19,
						["Clickable07.OGG"] = 02.03,
						["Death01.OGG"] = 02.31,
						["Death02.OGG"] = 02.23,
						["Death03.OGG"] = 02.09,
						["Wound01.OGG"] = 01.13,
						["Wound02.OGG"] = 01.19,
						["Wound03.OGG"] = 01.40,
						["WoundCrit01.OGG"] = 01.80,
						["WoundCrit02.OGG"] = 01.44,
						["WoundCrit03.OGG"] = 01.95,
					},
				},
				["CinderWolf\\MON_"] = {
					["CinderWolf_"] = {
						["Attack01.ogg"] = 02.09,
						["Attack02.ogg"] = 01.59,
						["Attack03.ogg"] = 01.87,
						["Attack04.ogg"] = 01.74,
						["Attack05.ogg"] = 01.90,
						["AttackCrit01.ogg"] = 02.06,
						["AttackCrit02.ogg"] = 01.82,
						["AttackCrit03.ogg"] = 02.10,
						["Death01.ogg"] = 01.94,
						["Death02.ogg"] = 01.98,
						["Death03.ogg"] = 02.00,
						["Wound01.ogg"] = 01.58,
						["Wound02.ogg"] = 01.31,
						["Wound03.ogg"] = 01.46,
						["Wound04.ogg"] = 01.46,
						["Wound05.ogg"] = 01.36,
						["WoundCrit01.ogg"] = 01.55,
						["WoundCrit02.ogg"] = 01.49,
						["WoundCrit03.ogg"] = 01.52,
					},
				},
				["CleverAshyo\\VO_"] = {
					["ASHYO_EVENT_"] = {
						["KUNG_FU_"] = {
							["FINALE_"] = {
								["01.OGG"] = 03.14,
								["02.OGG"] = 01.11,
								["03.OGG"] = 02.70,
								["04.OGG"] = 01.62,
								["05.OGG"] = 01.70,
							},
							["INTRO_"] = {
								["01.OGG"] = 02.41,
								["02.OGG"] = 02.10,
							},
						},
					},
				},
				["Cliffwalker\\VO_"] = {
					["QE_Cliffwalker_"] = {
						["Attack01.ogg"] = 00.54,
						["Attack02.ogg"] = 00.50,
						["Attack03.ogg"] = 00.56,
						["Attack04.ogg"] = 00.37,
						["Attack05.ogg"] = 00.52,
						["Attack06.ogg"] = 00.53,
						["Attack07.ogg"] = 00.72,
						["Attack08.ogg"] = 00.64,
						["Attack09.ogg"] = 00.56,
						["Attack10.ogg"] = 00.76,
						["AttackCritical01.ogg"] = 01.10,
						["AttackCritical02.ogg"] = 01.17,
						["AttackCritical03.ogg"] = 00.82,
						["AttackCritical04.ogg"] = 00.86,
						["AttackCritical05.ogg"] = 01.39,
						["Death01.ogg"] = 01.51,
						["Death02.ogg"] = 02.03,
						["Death03.ogg"] = 01.71,
						["Death04.ogg"] = 01.86,
						["STEvent01.ogg"] = 07.91,
						["STEvent02.ogg"] = 08.77,
						["STEvent03.ogg"] = 02.87,
						["Wound01.ogg"] = 00.42,
						["Wound02.ogg"] = 00.36,
						["Wound03.ogg"] = 00.51,
						["Wound04.ogg"] = 00.42,
						["Wound05.ogg"] = 00.36,
						["Wound06.ogg"] = 00.42,
						["Wound07.ogg"] = 00.33,
						["Wound08.ogg"] = 00.40,
						["Wound09.ogg"] = 00.36,
						["Wound10.ogg"] = 00.41,
						["WoundCritical01.ogg"] = 01.04,
						["WoundCritical02.ogg"] = 00.85,
						["WoundCritical03.ogg"] = 01.01,
						["WoundCritical04.ogg"] = 00.81,
						["WoundCritical05.ogg"] = 01.34,
					},
				},
				["ClockworkGiant\\ClockworkGiant_"] = {
					["AttackUnarmed1_"] = {
						["01.ogg"] = 01.47,
						["02.ogg"] = 01.65,
						["03.ogg"] = 01.82,
					},
					["AttackUnarmed2_"] = {
						["01.ogg"] = 01.47,
						["03.ogg"] = 01.85,
						["2.ogg"] = 01.72,
					},
					["Death.ogg"] = 07.83,
					["MainLoop.ogg"] = 09.80,
					["PoundGround.ogg"] = 03.43,
					["ReadySpellDirectedLoop.ogg"] = 09.76,
					["readySpellOmniLoop.ogg"] = 07.55,
				},
				["ClockworkGiantPet\\"] = {
					["ClockworkGiantPet_"] = {
						["ChannelCastOmni_"] = {
							["01.ogg"] = 00.16,
							["02.ogg"] = 00.18,
							["03.ogg"] = 00.16,
						},
						["Stand_01.ogg"] = 05.09,
					},
					["ClockWorkGianttPet_Clickable_"] = {
						["01.ogg"] = 01.38,
						["02.ogg"] = 01.56,
						["03.ogg"] = 01.66,
						["04.ogg"] = 01.40,
						["05.ogg"] = 01.58,
					},
				},
				["ClockWorkGnome\\"] = {
					["ClockworkGnomeAttackA.ogg"] = 02.18,
					["ClockworkGnomeAttackB.ogg"] = 01.25,
					["ClockworkGnomeAttackC.ogg"] = 01.23,
					["ClockworkGnomeAttackD.ogg"] = 01.38,
					["ClockworkGnomeAttackE.ogg"] = 01.22,
					["ClockworkGnomeAttackF.ogg"] = 01.94,
					["ClockworkGnomeAttackG.ogg"] = 01.62,
					["ClockworkGnomeAttackH.ogg"] = 01.49,
					["ClockworkGnomeAttackI.ogg"] = 01.33,
					["ClockworkGnomeDeath.ogg"] = 01.58,
					["ClockworkGnomeWoundA.ogg"] = 01.11,
					["ClockworkGnomeWoundB.ogg"] = 01.52,
					["ClockworkGnomeWoundC.ogg"] = 01.25,
					["ClockworkGnomeWoundCritA.ogg"] = 01.66,
					["ClockworkGnomeWoundCritB.ogg"] = 01.70,
					["ClockworkGnomeWoundCritC.ogg"] = 01.42,
					["ClockworkGnomeWoundD.ogg"] = 01.34,
					["ClockworkGnomeWoundE.ogg"] = 01.47,
					["ClockworkGnomeWoundF.ogg"] = 01.32,
					["ClockworkGnomeWoundG.ogg"] = 01.25,
					["ClockworkGnomeWoundH.ogg"] = 01.34,
				},
				["ClockworkHorseMount\\mon_"] = {
					["Clockwork_Horse_"] = {
						["Chuff_"] = {
							["01.OGG"] = 00.77,
							["02.OGG"] = 00.71,
							["03.OGG"] = 00.67,
							["04.OGG"] = 00.84,
							["05.OGG"] = 01.02,
							["06.OGG"] = 00.79,
							["07.OGG"] = 00.74,
						},
						["Death_"] = {
							["01.OGG"] = 03.30,
							["02.OGG"] = 03.09,
						},
						["Idle_"] = {
							["01.OGG"] = 01.73,
							["02.OGG"] = 01.83,
							["03.OGG"] = 01.34,
						},
						["MountSpecial_"] = {
							["01.OGG"] = 04.96,
							["02.OGG"] = 05.16,
							["03.OGG"] = 05.56,
						},
						["Summon_"] = {
							["01.OGG"] = 03.94,
							["02.OGG"] = 03.75,
							["03.OGG"] = 03.76,
						},
						["woundcrit_"] = {
							["01.OGG"] = 01.52,
							["02.OGG"] = 01.25,
						},
						["wound_"] = {
							["01.OGG"] = 01.32,
							["02.OGG"] = 01.49,
							["03.OGG"] = 01.34,
						},
						["loop.OGG"] = 08.10,
					},
				},
				["Cockatiel\\PET_"] = {
					["Cockatiel_"] = {
						["Clickable01.ogg"] = 01.38,
						["Clickable02.ogg"] = 00.82,
						["Clickable03.ogg"] = 00.76,
						["Clickable04.ogg"] = 00.61,
						["Clickable05.ogg"] = 00.92,
						["Clickable06.ogg"] = 01.06,
						["Clickable07.ogg"] = 00.86,
						["Clickable08.ogg"] = 01.43,
					},
				},
				["Cocoon\\"] = {
					["CocoonDeath.ogg"] = 01.11,
					["CocoonLoop.ogg"] = 04.49,
				},
				["ColdWraith\\"] = {
					["ColdWraithAttack1.ogg"] = 01.97,
					["ColdWraithAttack10.ogg"] = 01.86,
					["ColdWraithAttack2.ogg"] = 02.09,
					["ColdWraithAttack3.ogg"] = 01.97,
					["ColdWraithAttack4.ogg"] = 01.75,
					["ColdWraithAttack5.ogg"] = 01.72,
					["ColdWraithAttack6.ogg"] = 01.76,
					["ColdWraithAttack7.ogg"] = 01.87,
					["ColdWraithAttack8.ogg"] = 01.73,
					["ColdWraithAttack9.ogg"] = 01.61,
					["ColdWraithDeath.ogg"] = 02.25,
					["ColdWraithWound1.ogg"] = 01.60,
					["ColdWraithWound10.ogg"] = 01.34,
					["ColdWraithWound2.ogg"] = 01.59,
					["ColdWraithWound3.ogg"] = 01.84,
					["ColdWraithWound4.ogg"] = 01.69,
					["ColdWraithWound5.ogg"] = 01.60,
					["ColdWraithWound6.ogg"] = 01.63,
					["ColdWraithWound7.ogg"] = 01.68,
					["ColdWraithWound8.ogg"] = 01.95,
					["ColdWraithWound9.ogg"] = 01.51,
					["ColdWraithWoundCrit1.ogg"] = 02.06,
					["ColdWraithWoundCrit2.ogg"] = 02.03,
					["ColdWraithWoundCrit3.ogg"] = 02.20,
				},
				["CommanderDurand\\VO_"] = {
					["Durand_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.59,
							["02.OGG"] = 00.84,
							["03.OGG"] = 01.19,
							["04.OGG"] = 00.75,
							["05.OGG"] = 01.51,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.35,
							["02.OGG"] = 00.39,
							["03.OGG"] = 00.37,
							["04.OGG"] = 00.32,
							["05.OGG"] = 00.37,
							["06.OGG"] = 00.35,
							["07.OGG"] = 00.36,
							["08.OGG"] = 00.42,
							["09.OGG"] = 00.30,
							["10.OGG"] = 00.48,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.57,
							["02.OGG"] = 02.37,
							["03.OGG"] = 02.50,
							["04.OGG"] = 02.27,
							["05.OGG"] = 00.76,
						},
						["Wound_"] = {
							["01.OGG"] = 00.56,
							["02.OGG"] = 00.66,
							["03.OGG"] = 00.59,
							["04.OGG"] = 00.52,
							["05.OGG"] = 00.57,
							["06.OGG"] = 00.45,
							["07.OGG"] = 00.60,
							["08.OGG"] = 00.74,
							["09.OGG"] = 00.56,
						},
					},
					["SM_DURAND_"] = {
						["SLAY_"] = {
							["01.OGG"] = 02.90,
							["02.OGG"] = 01.97,
						},
						["AGGRO_01.OGG"] = 02.82,
						["DEATH_01.OGG"] = 02.17,
						["INTRO_01.OGG"] = 07.17,
					},
				},
				["CommanderGar\\VO_"] = {
					["60_COM_"] = {
						["GAR_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.56,
								["02.ogg"] = 01.35,
								["03.ogg"] = 02.03,
								["04.ogg"] = 01.32,
								["05.ogg"] = 00.91,
							},
							["Attack_"] = {
								["01.ogg"] = 00.47,
								["010.ogg"] = 00.41,
								["02.ogg"] = 00.59,
								["03.ogg"] = 00.37,
								["04.ogg"] = 00.39,
								["05.ogg"] = 00.47,
								["06.ogg"] = 00.43,
								["07.ogg"] = 00.53,
								["08.ogg"] = 00.46,
								["09.ogg"] = 00.53,
							},
							["Death_"] = {
								["01.ogg"] = 02.32,
								["02.ogg"] = 04.16,
								["03.ogg"] = 04.74,
								["04.ogg"] = 02.37,
								["05.ogg"] = 01.70,
							},
							["EVENT_"] = {
								["01.ogg"] = 08.02,
								["02.ogg"] = 07.11,
								["05.ogg"] = 06.81,
								["06.ogg"] = 03.14,
								["07.ogg"] = 02.99,
								["08.ogg"] = 02.10,
								["09.ogg"] = 01.74,
								["10.ogg"] = 06.27,
								["13.ogg"] = 12.54,
								["16.ogg"] = 09.76,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.14,
								["02.ogg"] = 01.54,
								["03.ogg"] = 00.71,
								["04.ogg"] = 00.63,
								["05.ogg"] = 01.22,
							},
							["Wound_"] = {
								["01.ogg"] = 00.61,
								["010.ogg"] = 00.63,
								["02.ogg"] = 00.52,
								["03.ogg"] = 00.55,
								["04.ogg"] = 00.57,
								["05.ogg"] = 00.56,
								["06.ogg"] = 00.52,
								["07.ogg"] = 00.58,
								["08.ogg"] = 00.71,
								["09.ogg"] = 00.56,
							},
						},
					},
				},
				["CommanderKolurg\\"] = {
					["TN_Kolu_"] = {
						["Attack01.ogg"] = 01.00,
						["Attack02.ogg"] = 00.91,
						["Attack03.ogg"] = 01.16,
						["Attack04.ogg"] = 01.08,
						["Wound01.ogg"] = 00.80,
						["Wound02.ogg"] = 00.72,
						["Wound03.ogg"] = 00.98,
						["Wound04.ogg"] = 01.04,
						["Wound05.ogg"] = 00.51,
						["Wound06.ogg"] = 00.58,
						["WoundCrit01.ogg"] = 02.35,
						["WoundCrit02.ogg"] = 01.04,
						["WoundCrit03.ogg"] = 01.36,
						["WoundCrit04.ogg"] = 00.90,
					},
					["KolurgAggro.ogg"] = 06.19,
					["KolurgDeath.ogg"] = 01.68,
					["KolurgKill.ogg"] = 02.36,
				},
				["CommanderLindon\\VO_"] = {
					["Archer_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.45,
							["02.OGG"] = 01.20,
							["03.OGG"] = 01.06,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.36,
							["02.OGG"] = 00.37,
							["03.OGG"] = 00.37,
							["04.OGG"] = 00.60,
							["05.OGG"] = 00.36,
							["06.OGG"] = 00.42,
							["07.OGG"] = 00.46,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.42,
							["02.OGG"] = 01.10,
							["03.OGG"] = 01.05,
						},
						["Wound_"] = {
							["01.OGG"] = 00.33,
							["02.OGG"] = 00.50,
							["03.OGG"] = 00.48,
							["04.OGG"] = 00.45,
							["05.OGG"] = 00.54,
							["06.OGG"] = 00.39,
							["07.OGG"] = 00.41,
							["08.OGG"] = 00.49,
							["09.OGG"] = 00.36,
						},
					},
					["SH_ARCHER_"] = {
						["SLAY_"] = {
							["01.OGG"] = 02.77,
							["02.OGG"] = 02.86,
						},
						["AGGRO_01.OGG"] = 01.52,
						["DEATH_01.OGG"] = 03.73,
					},
				},
				["CommanderRimok\\VO_"] = {
					["GSS_COMMANDER_"] = {
						["SLAY_"] = {
							["01.OGG"] = 03.05,
							["02.OGG"] = 02.82,
							["03.OGG"] = 02.57,
						},
						["AGGRO_01.OGG"] = 02.82,
						["DEATH_01.OGG"] = 06.17,
						["INTRO_01.OGG"] = 05.02,
					},
				},
				["CommanderSarannis\\TEMPEST_"] = {
					["Saran_"] = {
						["Aggro01.ogg"] = 05.19,
						["Arcane01.ogg"] = 04.33,
						["Arcane02.ogg"] = 03.55,
						["Attack01.ogg"] = 01.93,
						["Attack02.ogg"] = 02.00,
						["Attack03.ogg"] = 02.05,
						["Attack04.ogg"] = 02.14,
						["Attack05.ogg"] = 02.18,
						["Death01.ogg"] = 04.81,
						["Slay01.ogg"] = 03.34,
						["Slay02.ogg"] = 02.75,
						["SummonGrd01.ogg"] = 04.35,
						["Wound01.ogg"] = 02.26,
						["Wound02.ogg"] = 02.41,
						["Wound03.ogg"] = 02.26,
						["Wound04.ogg"] = 01.89,
						["Wound05.ogg"] = 02.21,
						["WoundCrit01.ogg"] = 02.15,
						["WoundCrit02.ogg"] = 02.64,
						["WoundCrit03.ogg"] = 02.47,
						["WoundCrit04.ogg"] = 02.69,
					},
				},
				["CommanderStoutbeard\\"] = {
					["TN_Stou_"] = {
						["Attack01.ogg"] = 00.31,
						["Attack02.ogg"] = 00.36,
						["Attack03.ogg"] = 00.53,
						["Attack04.ogg"] = 00.36,
						["Attack05.ogg"] = 00.38,
						["Attack06.ogg"] = 00.70,
						["Attack07.ogg"] = 00.78,
						["Attack08.ogg"] = 00.60,
						["Wound01.ogg"] = 00.44,
						["Wound02.ogg"] = 00.71,
						["Wound03.ogg"] = 00.58,
						["Wound04.ogg"] = 00.69,
						["Wound05.ogg"] = 00.66,
						["Wound06.ogg"] = 00.54,
						["Wound07.ogg"] = 00.54,
						["Wound08.ogg"] = 00.66,
						["WoundCrit01.ogg"] = 00.82,
						["WoundCrit02.ogg"] = 00.96,
						["WoundCrit03.ogg"] = 00.73,
						["WoundCrit04.ogg"] = 00.98,
					},
					["StoutbeardAggro.ogg"] = 05.00,
					["StoutbeardDeath.ogg"] = 03.74,
					["StoutbeardKill.ogg"] = 01.99,
				},
				["CommanderVojak\\VO_"] = {
					["SNT_VOJAK_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 01.82,
							["02.OGG"] = 01.84,
							["03.OGG"] = 01.24,
							["04.OGG"] = 01.89,
							["05.OGG"] = 01.47,
						},
						["ATTACK_"] = {
							["01.OGG"] = 00.95,
							["02.OGG"] = 01.19,
							["03.OGG"] = 00.68,
							["04.OGG"] = 00.83,
							["05.OGG"] = 00.86,
							["06.OGG"] = 00.83,
							["07.OGG"] = 00.81,
							["08.OGG"] = 00.94,
							["09.OGG"] = 00.87,
							["10.OGG"] = 00.87,
						},
						["GAUNTLET_"] = {
							["00.OGG"] = 07.41,
							["01.OGG"] = 05.31,
							["02.OGG"] = 05.87,
							["03.OGG"] = 05.26,
							["04.OGG"] = 07.20,
						},
						["INTRO_"] = {
							["01.OGG"] = 07.13,
							["02.OGG"] = 06.05,
						},
						["SENDFLYER_"] = {
							["01.OGG"] = 05.06,
							["02.OGG"] = 04.68,
							["03.OGG"] = 05.18,
							["NONE.OGG"] = 05.11,
						},
						["SLAY_"] = {
							["01.OGG"] = 02.46,
							["02.OGG"] = 02.72,
							["03.OGG"] = 04.20,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 01.13,
							["02.OGG"] = 01.19,
							["03.OGG"] = 01.22,
							["04.OGG"] = 00.86,
							["05.OGG"] = 01.03,
						},
						["WOUND_"] = {
							["01.OGG"] = 01.16,
							["02.OGG"] = 01.02,
							["03.OGG"] = 01.01,
							["04.OGG"] = 01.05,
							["05.OGG"] = 00.92,
							["06.OGG"] = 01.06,
							["07.OGG"] = 01.00,
							["08.OGG"] = 01.27,
							["09.OGG"] = 01.03,
							["10.OGG"] = 00.73,
						},
						["DEATH_01.OGG"] = 04.71,
					},
				},
				["computer\\OG_"] = {
					["Computer_"] = {
						["Event01.ogg"] = 11.08,
						["Event02.ogg"] = 08.82,
					},
				},
				["Compy\\MON_"] = {
					["Compy_"] = {
						["Aggro_"] = {
							["01.OGG"] = 01.37,
							["02.OGG"] = 01.27,
							["03.OGG"] = 01.15,
							["04.OGG"] = 01.20,
							["05.OGG"] = 01.07,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.19,
							["02.OGG"] = 01.39,
							["03.OGG"] = 00.90,
							["04.OGG"] = 01.33,
							["05.OGG"] = 00.90,
						},
						["Attack_"] = {
							["01.OGG"] = 00.63,
							["02.OGG"] = 00.80,
							["03.OGG"] = 00.84,
							["04.OGG"] = 00.79,
							["05.OGG"] = 00.54,
							["06.OGG"] = 00.85,
							["07.OGG"] = 00.87,
							["08.OGG"] = 00.81,
							["09.OGG"] = 00.56,
							["10.OGG"] = 00.64,
						},
						["Death_"] = {
							["01.OGG"] = 04.51,
							["02.OGG"] = 04.99,
							["03.OGG"] = 05.15,
							["04.OGG"] = 04.74,
							["05.OGG"] = 04.39,
							["06.OGG"] = 03.81,
							["07.OGG"] = 04.22,
							["08.OGG"] = 04.27,
							["09.OGG"] = 04.22,
							["10.OGG"] = 04.65,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.88,
							["02.OGG"] = 01.74,
							["03.OGG"] = 01.73,
							["04.OGG"] = 01.97,
							["05.OGG"] = 02.21,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.05,
							["02.OGG"] = 01.03,
							["03.OGG"] = 01.23,
							["04.OGG"] = 00.96,
							["05.OGG"] = 01.01,
						},
						["Wound_"] = {
							["01.OGG"] = 00.89,
							["02.OGG"] = 00.70,
							["03.OGG"] = 00.85,
							["04.OGG"] = 00.71,
							["05.OGG"] = 00.54,
							["06.OGG"] = 00.85,
							["07.OGG"] = 00.88,
							["08.OGG"] = 01.06,
							["09.OGG"] = 00.78,
							["10.OGG"] = 00.90,
						},
					},
				},
				["Cookbot\\Mon_"] = {
					["Cookbot_"] = {
						["Attack01.OGG"] = 01.60,
						["Attack02.OGG"] = 01.50,
						["Attack03.OGG"] = 01.51,
						["Attack04.OGG"] = 01.55,
						["Attack05.OGG"] = 01.52,
						["Clickable01.OGG"] = 02.12,
						["Clickable02.OGG"] = 02.92,
						["Clickable03.OGG"] = 02.53,
						["Clickable04.OGG"] = 02.29,
						["Clickable05.OGG"] = 04.82,
						["Clickable06.OGG"] = 03.61,
						["Clickable07.OGG"] = 01.89,
						["Clickable08.OGG"] = 01.91,
						["Clickable09.OGG"] = 03.56,
						["Death01.OGG"] = 01.79,
						["Death02.OGG"] = 01.77,
						["Death03.OGG"] = 01.86,
						["Death04.OGG"] = 01.68,
						["Death05.OGG"] = 01.85,
						["Emerge.OGG"] = 02.98,
						["Stand.OGG"] = 04.45,
						["Stand01.OGG"] = 03.48,
						["Stand02.OGG"] = 02.85,
						["Stand03.OGG"] = 04.92,
						["Submerge.OGG"] = 02.01,
						["Wound01.OGG"] = 01.27,
						["Wound02.OGG"] = 01.08,
						["Wound03.OGG"] = 01.27,
						["Wound04.OGG"] = 01.10,
						["Wound05.OGG"] = 01.70,
					},
				},
				["CordanaFelsong\\VO_"] = {
					["60_"] = {
						["CORDANA_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.38,
								["02.ogg"] = 01.44,
								["03.ogg"] = 01.64,
								["04.ogg"] = 00.78,
								["05.ogg"] = 01.54,
							},
							["Attack_"] = {
								["01.ogg"] = 00.56,
								["010.ogg"] = 00.41,
								["02.ogg"] = 00.45,
								["03.ogg"] = 00.40,
								["04.ogg"] = 00.45,
								["05.ogg"] = 00.58,
								["06.ogg"] = 00.43,
								["07.ogg"] = 00.50,
								["08.ogg"] = 00.51,
								["09.ogg"] = 00.58,
							},
							["Death_"] = {
								["01.ogg"] = 03.12,
								["02.ogg"] = 01.90,
								["03.ogg"] = 02.49,
								["04.ogg"] = 02.26,
								["05.ogg"] = 02.57,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.13,
								["02.ogg"] = 02.02,
								["03.ogg"] = 01.74,
								["04.ogg"] = 02.03,
								["05.ogg"] = 01.53,
							},
							["Wound_"] = {
								["01.ogg"] = 00.36,
								["010.ogg"] = 00.45,
								["02.ogg"] = 00.43,
								["03.ogg"] = 00.43,
								["04.ogg"] = 00.39,
								["05.ogg"] = 00.43,
								["06.ogg"] = 00.45,
								["07.ogg"] = 00.61,
								["08.ogg"] = 00.55,
								["09.ogg"] = 00.38,
							},
						},
						["FR_CORDANA_"] = {
							["PASSAGE_"] = {
								["01.ogg"] = 04.72,
								["02.ogg"] = 04.29,
								["03.ogg"] = 04.26,
								["04.ogg"] = 02.90,
							},
							["COUNCIL_01.ogg"] = 04.21,
							["FLOW_01.ogg"] = 04.35,
							["WORMS_01.ogg"] = 03.28,
						},
						["LQ_CORDANA_"] = {
							["GAME_"] = {
								["01.ogg"] = 02.05,
								["02.ogg"] = 01.14,
								["03.ogg"] = 01.57,
							},
							["INTRO_"] = {
								["01.ogg"] = 01.68,
								["02.ogg"] = 01.38,
							},
							["MIND_"] = {
								["01.ogg"] = 00.78,
								["02.ogg"] = 04.07,
								["03.ogg"] = 02.40,
							},
							["HUNT_01.ogg"] = 03.88,
							["RING_01.ogg"] = 01.27,
							["TARNISHED_01.ogg"] = 03.56,
						},
						["SMV_"] = {
							["CORDANA_"] = {
								["FAREWELL_"] = {
									["01.ogg"] = 01.31,
									["02.ogg"] = 00.93,
									["03.ogg"] = 01.58,
									["04.ogg"] = 01.80,
									["05.ogg"] = 01.98,
								},
								["GREETING_"] = {
									["01.ogg"] = 00.70,
									["02.ogg"] = 00.93,
									["03.ogg"] = 01.06,
									["04.ogg"] = 01.53,
									["05.ogg"] = 01.03,
								},
							},
							["GULDAN_"] = {
								["APPROACH_CORDANA_"] = {
									["01.ogg"] = 02.40,
									["02.ogg"] = 04.48,
									["03.ogg"] = 04.53,
									["04.ogg"] = 02.86,
									["05.ogg"] = 05.44,
									["06.ogg"] = 06.20,
									["07.ogg"] = 05.77,
									["08.ogg"] = 03.81,
								},
								["CAVE_CORDANA_"] = {
									["01.ogg"] = 01.05,
									["02.ogg"] = 00.71,
									["03.ogg"] = 04.00,
									["04.ogg"] = 01.74,
								},
								["HUB_CORDANA_"] = {
									["01.ogg"] = 03.54,
									["02.ogg"] = 03.90,
									["03.ogg"] = 01.92,
								},
								["STAB_CORDANA_"] = {
									["01.ogg"] = 01.92,
									["02.ogg"] = 01.03,
									["04.ogg"] = 03.61,
								},
							},
						},
						["TAN_CORDANA_"] = {
							["DAM_01.ogg"] = 01.41,
							["DPEVENTS_01.ogg"] = 03.03,
						},
						["TLD_ZANGARRA_CORDANA_01.ogg"] = 04.02,
					},
				},
				["CoreHoundMount\\MON_"] = {
					["CoreHoundMount_"] = {
						["Chuff01.ogg"] = 01.98,
						["Chuff02.ogg"] = 02.29,
						["Chuff03.ogg"] = 02.04,
						["Chuff04.ogg"] = 02.08,
						["Chuff05.ogg"] = 01.94,
						["Creatureloop.ogg"] = 03.92,
						["MountSpecial01.ogg"] = 05.08,
						["MountSpecial02.ogg"] = 04.43,
						["MountSpecial03.ogg"] = 04.26,
					},
				},
				["CoreHoundPet\\CoreHoundPup_"] = {
					["Clickable_"] = {
						["01.ogg"] = 01.46,
						["02.ogg"] = 01.47,
						["03.ogg"] = 01.75,
					},
				},
				["Corla\\VO_"] = {
					["BC_Corla_"] = {
						["Attack01.ogg"] = 00.44,
						["Attack02.ogg"] = 00.91,
						["Attack03.ogg"] = 00.69,
						["Attack04.ogg"] = 00.76,
						["Attack05.ogg"] = 00.80,
						["Attack06.ogg"] = 01.13,
						["Attack07.ogg"] = 00.81,
						["Attack08.ogg"] = 01.12,
						["AttackCrit01.ogg"] = 01.27,
						["AttackCrit02.ogg"] = 01.46,
						["AttackCrit03.ogg"] = 01.40,
						["AttackCrit04.ogg"] = 01.86,
						["Event01.ogg"] = 03.90,
						["Event02.ogg"] = 03.38,
						["Event03.ogg"] = 05.84,
						["Event04.ogg"] = 04.76,
						["Wound01.ogg"] = 00.66,
						["Wound02.ogg"] = 00.84,
						["Wound03.ogg"] = 00.89,
						["Wound04.ogg"] = 00.84,
						["Wound05.ogg"] = 00.91,
						["Wound06.ogg"] = 01.14,
						["Wound07.ogg"] = 01.62,
						["Wound08.ogg"] = 00.98,
						["Wound09.ogg"] = 01.60,
						["WoundCrit01.ogg"] = 01.58,
						["WoundCrit02.ogg"] = 01.87,
						["WoundCrit03.ogg"] = 01.44,
						["WoundCrit04.ogg"] = 01.26,
						["WoundCrit05.ogg"] = 01.10,
					},
				},
				["Council\\VO_"] = {
					["BD_Council_"] = {
						["Event01.ogg"] = 05.46,
						["Event02.ogg"] = 04.69,
						["Event03.ogg"] = 02.81,
						["Event04.ogg"] = 02.89,
						["Event05.ogg"] = 02.80,
						["Event06.ogg"] = 03.07,
						["Event07.ogg"] = 03.79,
						["Event08.ogg"] = 04.04,
						["Event09.ogg"] = 03.79,
						["Event10.ogg"] = 04.05,
						["Event11.ogg"] = 06.75,
					},
				},
				["Cow\\"] = {
					["CowDeath.ogg"] = 01.63,
					["CowWound.ogg"] = 00.82,
				},
				["Crab\\"] = {
					["CrabAggro.ogg"] = 00.75,
					["CrabAttackA.ogg"] = 01.07,
					["CrabAttackB.ogg"] = 00.38,
					["CrabAttackC.ogg"] = 00.55,
					["CrabDeathA.ogg"] = 01.28,
					["CrabFootSteps1.ogg"] = 00.09,
					["CrabFootSteps2.ogg"] = 00.19,
					["CrabFootSteps3.ogg"] = 00.31,
					["CrabFootSteps4.ogg"] = 00.12,
					["CrabPreAggro.ogg"] = 01.18,
					["CrabWoundA.ogg"] = 00.34,
					["CrabWoundB.ogg"] = 01.17,
					["CrabWoundC.ogg"] = 01.11,
					["CrabWoundCrit.ogg"] = 01.41,
				},
				["CrackElfMale\\"] = {
					["CrackElfMaleAggro.ogg"] = 01.33,
					["CrackElfMaleAttackA.ogg"] = 01.35,
					["CrackElfMaleAttackB.ogg"] = 01.32,
					["CrackElfMaleAttackC.ogg"] = 01.13,
					["CrackElfMaleAttackD.ogg"] = 01.32,
					["CrackElfMaleAttackE.ogg"] = 01.07,
					["CrackElfMaleDeath.ogg"] = 01.55,
					["CrackElfMalePreAggro.ogg"] = 00.89,
					["CrackElfMaleWoundA.ogg"] = 01.10,
					["CrackElfMaleWoundB.ogg"] = 01.21,
					["CrackElfMaleWoundC.ogg"] = 01.18,
					["CrackElfMaleWoundCrit.ogg"] = 01.66,
					["CrackElfMaleWoundD.ogg"] = 01.25,
				},
				["CRANE\\MON_"] = {
					["Crane_"] = {
						["Aggro_"] = {
							["01.OGG"] = 01.01,
							["02.OGG"] = 01.02,
							["03.OGG"] = 00.87,
							["04.OGG"] = 01.13,
							["05.OGG"] = 01.10,
							["06.OGG"] = 01.01,
							["07.OGG"] = 01.77,
							["08.OGG"] = 01.10,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 00.63,
							["02.OGG"] = 00.62,
							["03.OGG"] = 00.57,
							["04.OGG"] = 00.62,
							["05.OGG"] = 00.83,
						},
						["Attack_"] = {
							["01.OGG"] = 00.70,
							["02.OGG"] = 00.68,
							["03.OGG"] = 00.44,
							["04.OGG"] = 00.54,
							["05.OGG"] = 00.59,
							["06.OGG"] = 00.56,
							["07.OGG"] = 00.64,
							["08.OGG"] = 00.47,
							["09.OGG"] = 00.40,
							["10.OGG"] = 00.42,
						},
						["Death_"] = {
							["01.OGG"] = 03.91,
							["02.OGG"] = 04.01,
							["03.OGG"] = 04.21,
							["04.OGG"] = 03.90,
							["05.OGG"] = 04.01,
						},
						["MountSpecial_"] = {
							["01.OGG"] = 01.79,
							["02.OGG"] = 01.62,
							["03.OGG"] = 01.52,
							["04.OGG"] = 02.55,
							["05.OGG"] = 02.65,
						},
						["PreAggro_"] = {
							["01.OGG"] = 00.71,
							["02.OGG"] = 00.92,
							["03.OGG"] = 01.06,
							["04.OGG"] = 01.01,
							["05.OGG"] = 00.83,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.63,
							["02.OGG"] = 00.66,
							["03.OGG"] = 00.59,
							["04.OGG"] = 00.74,
							["05.OGG"] = 00.95,
						},
						["Wound_"] = {
							["01.OGG"] = 00.58,
							["02.OGG"] = 00.41,
							["03.OGG"] = 00.51,
							["04.OGG"] = 00.58,
							["05.OGG"] = 00.57,
							["06.OGG"] = 00.42,
							["07.OGG"] = 00.40,
							["08.OGG"] = 00.56,
							["09.OGG"] = 00.54,
							["10.OGG"] = 00.55,
						},
					},
				},
				["Crawler\\"] = {
					["CrawlerAggro.ogg"] = 02.74,
					["CrawlerAttackA.ogg"] = 01.53,
					["CrawlerAttackB.ogg"] = 01.60,
					["CrawlerAttackC.ogg"] = 01.93,
					["CrawlerAttackD.ogg"] = 01.97,
					["CrawlerAttackE.ogg"] = 01.80,
					["CrawlerDeath.ogg"] = 02.47,
					["CrawlerWoundA.ogg"] = 01.67,
					["CrawlerWoundB.ogg"] = 01.80,
					["CrawlerWoundC.ogg"] = 01.44,
					["CrawlerWoundCrit.ogg"] = 01.47,
					["CrawlerWoundD.ogg"] = 01.53,
				},
				["CrawlingHandPet\\MON_"] = {
					["CrawlingHandPet_Clickable_"] = {
						["01.ogg"] = 00.78,
						["02.ogg"] = 00.28,
						["03.ogg"] = 00.40,
						["04.ogg"] = 00.45,
						["05.ogg"] = 00.70,
						["06.ogg"] = 00.44,
						["07.ogg"] = 00.45,
						["08.ogg"] = 00.49,
						["09.ogg"] = 00.87,
						["10.ogg"] = 00.72,
					},
				},
				["CreepyCrate\\MON_"] = {
					["CreepyCrate_"] = {
						["Aggro_"] = {
							["01.OGG"] = 01.99,
							["02.OGG"] = 02.06,
							["03.OGG"] = 02.02,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.63,
							["02.OGG"] = 01.87,
						},
						["Attack_"] = {
							["01.OGG"] = 01.95,
							["02.OGG"] = 01.61,
							["03.OGG"] = 01.69,
							["04.OGG"] = 02.04,
							["05.OGG"] = 01.66,
						},
						["Death_"] = {
							["01.OGG"] = 02.32,
							["02.OGG"] = 02.23,
							["03.OGG"] = 01.80,
							["04.OGG"] = 01.68,
							["05.OGG"] = 01.84,
						},
						["PreAggro_"] = {
							["01.OGG"] = 02.42,
							["02.OGG"] = 01.82,
							["03.OGG"] = 01.81,
						},
						["Stand1_"] = {
							["01.OGG"] = 02.71,
							["02.OGG"] = 02.82,
							["03.OGG"] = 02.78,
						},
						["Stand2_"] = {
							["01.OGG"] = 05.20,
							["02.OGG"] = 05.20,
							["03.OGG"] = 05.37,
						},
						["Stand3_"] = {
							["01.OGG"] = 03.95,
							["02.OGG"] = 03.93,
							["03.OGG"] = 04.21,
						},
						["Walk_"] = {
							["01.OGG"] = 02.27,
							["02.OGG"] = 02.22,
							["03.OGG"] = 02.01,
							["04.OGG"] = 01.65,
							["05.OGG"] = 01.69,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.28,
							["02.OGG"] = 01.87,
						},
						["Wound_"] = {
							["01.OGG"] = 01.45,
							["02.OGG"] = 01.63,
							["03.OGG"] = 01.32,
							["04.OGG"] = 01.58,
							["05.OGG"] = 01.43,
						},
					},
				},
				["Crenshaw\\VO_"] = {
					["QE_GIL_"] = {
						["Crenshaw_"] = {
							["Hunt01.ogg"] = 09.79,
							["Hunt02.ogg"] = 01.70,
						},
					},
				},
				["CRICKET\\MON_"] = {
					["Cricket_"] = {
						["Attack01.OGG"] = 01.37,
						["Attack02.OGG"] = 01.20,
						["Attack03.OGG"] = 01.30,
						["Attack04.OGG"] = 01.33,
						["Attack05.OGG"] = 01.29,
						["Attack06.OGG"] = 01.17,
						["Attack07.OGG"] = 01.33,
						["Attack08.OGG"] = 01.28,
						["Attack09.OGG"] = 01.22,
						["Attack10.OGG"] = 01.34,
						["AttackCrit01.OGG"] = 01.83,
						["AttackCrit02.OGG"] = 01.76,
						["AttackCrit03.OGG"] = 01.94,
						["AttackCrit04.OGG"] = 02.01,
						["AttackCrit05.OGG"] = 01.83,
						["Death01.OGG"] = 02.94,
						["Death02.OGG"] = 03.18,
						["Death03.OGG"] = 03.33,
						["Death04.OGG"] = 03.15,
						["Death05.OGG"] = 03.34,
						["Wound01.OGG"] = 01.46,
						["Wound02.OGG"] = 01.53,
						["Wound03.OGG"] = 01.65,
						["Wound04.OGG"] = 01.49,
						["Wound05.OGG"] = 01.36,
						["Wound06.OGG"] = 01.32,
						["Wound07.OGG"] = 01.38,
						["Wound08.OGG"] = 01.65,
						["Wound09.OGG"] = 01.55,
						["Wound10.OGG"] = 01.42,
						["WoundCrit01.OGG"] = 01.48,
						["WoundCrit02.OGG"] = 01.68,
						["WoundCrit03.OGG"] = 01.67,
						["WoundCrit04.OGG"] = 01.78,
						["WoundCrit05.OGG"] = 01.81,
					},
				},
				["CrokScourgebane\\IC_"] = {
					["Crok_"] = {
						["Attack01.ogg"] = 00.60,
						["Attack02.ogg"] = 01.15,
						["Attack03.ogg"] = 00.81,
						["Attack04.ogg"] = 00.89,
						["Attack05.ogg"] = 00.44,
						["Attack06.ogg"] = 00.43,
						["Attack07.ogg"] = 00.34,
						["Attack08.ogg"] = 00.60,
						["Attack09.ogg"] = 01.03,
						["Attack10.ogg"] = 00.67,
						["Event01.ogg"] = 05.77,
						["Event02.ogg"] = 06.46,
						["Event03.ogg"] = 03.01,
						["Event04.ogg"] = 01.16,
						["Event05.ogg"] = 01.56,
						["Event06.ogg"] = 04.10,
						["Event07.ogg"] = 07.67,
						["LowHealth01.ogg"] = 03.29,
						["LowHealthBoss01.ogg"] = 03.23,
						["Trap01.ogg"] = 07.06,
						["Warn01.ogg"] = 08.15,
						["Wipe01.ogg"] = 03.92,
						["Wound01.ogg"] = 00.30,
						["Wound02.ogg"] = 00.34,
						["Wound03.ogg"] = 00.38,
						["Wound04.ogg"] = 00.31,
						["Wound05.ogg"] = 00.48,
						["Wound06.ogg"] = 00.31,
						["Wound07.ogg"] = 00.39,
						["Wound08.ogg"] = 00.42,
						["Wound09.ogg"] = 00.29,
						["WoundCrit01.ogg"] = 00.83,
						["WoundCrit02.ogg"] = 00.47,
						["WoundCrit03.ogg"] = 00.26,
						["WoundCrit04.ogg"] = 00.65,
						["WoundCrit05.ogg"] = 00.50,
						["WoundCrit06.ogg"] = 00.55,
						["WoundCrit07.ogg"] = 00.52,
					},
				},
				["Crone\\"] = {
					["OzCroneAttack01.ogg"] = 01.46,
					["OzCroneAttack02.ogg"] = 01.54,
					["OzCroneAttack03.ogg"] = 01.73,
					["OzCroneDies01.ogg"] = 06.09,
					["OzCroneIntro01.ogg"] = 09.98,
					["OzCroneIntro02.ogg"] = 08.88,
					["OzCroneSlay01.ogg"] = 06.36,
					["OzCroneWound01.ogg"] = 01.28,
					["OzCroneWound02.ogg"] = 01.44,
					["OzCroneWound03.ogg"] = 01.93,
					["OzCroneWoundCrit01.ogg"] = 01.27,
					["OzCroneWoundCrit02.ogg"] = 01.30,
					["OzCroneWoundCrit03.ogg"] = 02.04,
				},
				["Crowley\\VO_"] = {
					["GI_Crowley_"] = {
						["Attack01.ogg"] = 00.56,
						["Attack02.ogg"] = 00.44,
						["Attack03.ogg"] = 00.39,
						["Attack04.ogg"] = 00.55,
						["Attack05.ogg"] = 00.51,
						["Attack06.ogg"] = 00.81,
						["Attack07.ogg"] = 00.55,
						["Attack08.ogg"] = 00.88,
						["AttackCrit01.ogg"] = 02.05,
						["AttackCrit02.ogg"] = 01.25,
						["Battle01.ogg"] = 02.84,
						["Battle02.ogg"] = 04.65,
						["Funeral01.ogg"] = 03.61,
						["Greeting01.ogg"] = 01.36,
						["GreetingWor01.ogg"] = 01.80,
						["Horse01.ogg"] = 03.40,
						["Horse02.ogg"] = 02.66,
						["Horse03.ogg"] = 04.47,
						["HorseStart01.ogg"] = 08.28,
						["Sacrifices01.ogg"] = 07.11,
						["Sacrifices02.ogg"] = 07.23,
						["Sacrifices03.ogg"] = 08.42,
						["Taldoren01.ogg"] = 07.16,
						["Taldoren02.ogg"] = 00.99,
						["Taldoren03.ogg"] = 10.82,
						["Wound01.ogg"] = 00.51,
						["Wound02.ogg"] = 00.46,
						["Wound03.ogg"] = 00.86,
						["Wound04.ogg"] = 01.30,
						["Wound05.ogg"] = 01.16,
						["Wound06.ogg"] = 01.49,
						["Wound07.ogg"] = 01.30,
						["Wound08.ogg"] = 01.39,
						["WoundCrit01.ogg"] = 01.72,
						["WoundCrit02.ogg"] = 01.53,
						["WoundCrit03.ogg"] = 01.70,
					},
				},
				["Crushcog\\VO_"] = {
					["QE_DM_"] = {
						["Crushcog_"] = {
							["Attack01.ogg"] = 00.41,
							["Attack02.ogg"] = 00.36,
							["Attack03.ogg"] = 00.32,
							["Attack04.ogg"] = 00.64,
							["Attack05.ogg"] = 00.49,
							["Attack06.ogg"] = 00.38,
							["Attack07.ogg"] = 00.48,
							["Attack08.ogg"] = 00.27,
							["Attack09.ogg"] = 00.44,
							["Attack10.ogg"] = 00.30,
							["AttackCritical01.ogg"] = 00.88,
							["AttackCritical02.ogg"] = 00.94,
							["AttackCritical03.ogg"] = 00.76,
							["AttackCritical04.ogg"] = 00.88,
							["AttackCritical05.ogg"] = 00.87,
							["Death01.ogg"] = 01.95,
							["Death02.ogg"] = 01.94,
							["Death03.ogg"] = 02.18,
							["Death04.ogg"] = 01.75,
							["Death05.ogg"] = 01.63,
							["DMEvent01.ogg"] = 05.21,
							["DMEvent02.ogg"] = 06.08,
							["DMEvent03.ogg"] = 05.03,
							["Wound01.ogg"] = 00.52,
							["Wound02.ogg"] = 00.53,
							["Wound03.ogg"] = 00.43,
							["Wound04.ogg"] = 00.64,
							["Wound05.ogg"] = 00.62,
							["Wound06.ogg"] = 00.53,
							["Wound07.ogg"] = 00.46,
							["Wound08.ogg"] = 00.42,
							["Wound09.ogg"] = 00.45,
							["WoundCritical01.ogg"] = 01.16,
							["WoundCritical02.ogg"] = 00.83,
							["WoundCritical03.ogg"] = 00.66,
							["WoundCritical04.ogg"] = 00.77,
							["WoundCritical05.ogg"] = 00.70,
						},
					},
				},
				["Crushto\\VO_"] = {
					["60_"] = {
						["6OM_CRUSHTO_"] = {
							["INTRO_"] = {
								["01.OGG"] = 04.93,
								["02.OGG"] = 04.95,
							},
							["SLAY_"] = {
								["01.OGG"] = 03.22,
								["02.OGG"] = 03.79,
								["03.OGG"] = 03.02,
							},
							["SPELL_"] = {
								["01.OGG"] = 01.48,
								["02.OGG"] = 04.65,
								["03.OGG"] = 04.58,
							},
							["AGGRO.OGG"] = 07.58,
							["DEATH.OGG"] = 04.83,
						},
						["CRUSHTO_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.31,
								["02.OGG"] = 01.32,
								["03.OGG"] = 01.05,
								["04.OGG"] = 01.27,
								["05.OGG"] = 01.40,
							},
							["Attack_"] = {
								["01.OGG"] = 00.74,
								["010.OGG"] = 01.15,
								["02.OGG"] = 00.86,
								["03.OGG"] = 00.83,
								["04.OGG"] = 00.95,
								["05.OGG"] = 00.97,
								["06.OGG"] = 00.80,
								["07.OGG"] = 00.71,
								["08.OGG"] = 00.75,
								["09.OGG"] = 00.91,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.22,
								["02.OGG"] = 01.28,
								["03.OGG"] = 01.03,
								["04.OGG"] = 01.54,
								["05.OGG"] = 01.25,
							},
							["Wound_"] = {
								["01.OGG"] = 00.66,
								["010.OGG"] = 00.88,
								["02.OGG"] = 00.73,
								["03.OGG"] = 00.68,
								["04.OGG"] = 00.73,
								["05.OGG"] = 00.61,
								["06.OGG"] = 00.70,
								["07.OGG"] = 00.63,
								["08.OGG"] = 00.67,
								["09.OGG"] = 00.77,
							},
						},
					},
				},
				["CryptFiend\\"] = {
					["CryptFiendAggro.ogg"] = 01.00,
					["CryptFiendAttackA.ogg"] = 01.41,
					["CryptFiendAttackB.ogg"] = 01.33,
					["CryptFiendAttackC.ogg"] = 01.32,
					["CryptFiendDeathA.ogg"] = 03.79,
					["CryptFiendPreAggro.ogg"] = 00.66,
					["CryptFiendWoundA.ogg"] = 01.17,
					["CryptFiendWoundB.ogg"] = 01.50,
					["CryptFiendWoundC.ogg"] = 01.44,
					["CryptFiendWoundCrit.ogg"] = 01.31,
				},
				["CryptLord\\"] = {
					["CryptLordAttackA.ogg"] = 01.15,
					["CryptLordAttackB.ogg"] = 01.82,
					["CryptLordAttackC.ogg"] = 01.28,
					["CryptLordAttackD.ogg"] = 02.05,
					["CryptLordDeath.ogg"] = 04.72,
					["CryptLordWoundA.ogg"] = 01.40,
					["CryptLordWoundB.ogg"] = 01.61,
					["CryptLordWoundC.ogg"] = 01.23,
					["CryptLordWoundCrit.ogg"] = 01.48,
				},
				["CrystalPortal\\"] = {
					["CrystalPortalDeath.ogg"] = 07.37,
					["CrystalPortalLoop.ogg"] = 04.92,
					["CrystalPortalWound.ogg"] = 00.99,
					["CrystalPortalWound2.ogg"] = 02.03,
				},
				["Cthun\\"] = {
					["CthunAttackA.ogg"] = 03.37,
					["CthunAttackB.ogg"] = 03.05,
					["CthunAttackC.ogg"] = 03.09,
					["CthunAttackD.ogg"] = 03.21,
					["CthunDeath.ogg"] = 09.47,
					["CThunDeathIsClose.ogg"] = 04.28,
					["CthunWoundA.ogg"] = 02.87,
					["CthunWoundB.ogg"] = 02.81,
					["CthunWoundC.ogg"] = 02.62,
					["CthunWoundCrit.ogg"] = 03.75,
					["CthunWoundD.ogg"] = 03.10,
					["CThunYouAreAlready.ogg"] = 03.86,
					["CThunYourCourage.ogg"] = 03.20,
					["CThunYourFriends.ogg"] = 03.55,
					["CThunYouWillBetray.ogg"] = 03.12,
					["CThunYouWillDIe.ogg"] = 03.72,
					["YouAreWeak.ogg"] = 02.69,
					["YourHeartWill.ogg"] = 03.60,
				},
				["Curator\\"] = {
					["CuratorAggro01.ogg"] = 03.13,
					["CuratorDies01.ogg"] = 04.42,
					["CuratorModeChange01.ogg"] = 04.58,
					["CuratorRegenMana01.ogg"] = 03.02,
					["CuratorSlay01.ogg"] = 02.48,
					["CuratorSlay02.ogg"] = 02.25,
					["CuratorSpecial01.ogg"] = 03.72,
					["CuratorSpecial02.ogg"] = 03.93,
				},
				["CuriousWolvar\\PET_"] = {
					["CuriousWolvar_Clickable_"] = {
						["01.ogg"] = 01.60,
						["02.ogg"] = 01.81,
						["03.ogg"] = 01.59,
						["04.ogg"] = 01.23,
						["05.ogg"] = 01.75,
						["06.ogg"] = 03.08,
						["07.ogg"] = 02.05,
						["08.ogg"] = 01.79,
						["09.ogg"] = 02.21,
						["10.ogg"] = 02.18,
					},
				},
				["Cyanigosa\\VH_"] = {
					["Cyanigosa_"] = {
						["Aggro.ogg"] = 04.18,
						["Attack01.ogg"] = 00.38,
						["Attack02.ogg"] = 00.52,
						["Attack03.ogg"] = 00.37,
						["Attack04.ogg"] = 00.58,
						["BreathAttack.ogg"] = 02.21,
						["Death01.ogg"] = 04.47,
						["Disruption.ogg"] = 02.28,
						["Slay01.ogg"] = 03.60,
						["Slay02.ogg"] = 02.88,
						["Slay03.ogg"] = 04.34,
						["Spawn.ogg"] = 08.33,
						["SpecialAttack01.ogg"] = 07.15,
						["SpecialAttack02.ogg"] = 04.46,
						["Wound01.ogg"] = 00.31,
						["Wound02.ogg"] = 00.48,
						["Wound03.ogg"] = 00.34,
						["Wound04.ogg"] = 00.54,
						["Wound05.ogg"] = 00.32,
						["Wound06.ogg"] = 00.47,
						["Wound07.ogg"] = 00.49,
						["WoundCrit01.ogg"] = 00.61,
						["WoundCrit02.ogg"] = 00.35,
						["WoundCrit03.ogg"] = 00.71,
						["WoundCrit04.ogg"] = 00.50,
					},
				},
				["CYCLONAS\\VO_"] = {
					["QUEST_42_"] = {
						["CYCLONAS_AIR_"] = {
							["01.ogg"] = 25.31,
							["02.ogg"] = 06.87,
						},
					},
				},
				["DAAKARA\\VO_"] = {
					["ZA2_DAAKARA_"] = {
						["KILL_"] = {
							["01.ogg"] = 03.45,
							["02.ogg"] = 06.61,
							["03.ogg"] = 07.89,
							["04.ogg"] = 03.65,
						},
						["AGGRO.ogg"] = 08.22,
						["ATTACK01.ogg"] = 01.03,
						["ATTACK02.ogg"] = 00.79,
						["ATTACK03.ogg"] = 01.33,
						["ATTACK04.ogg"] = 00.91,
						["ATTACK05.ogg"] = 01.09,
						["ATTACK06.ogg"] = 01.28,
						["ATTACK07.ogg"] = 01.45,
						["ATTACK08.ogg"] = 01.62,
						["ATTACK09.ogg"] = 00.81,
						["ATTACK10.ogg"] = 00.88,
						["ATTACKCRIT01.ogg"] = 02.17,
						["ATTACKCRIT02.ogg"] = 01.68,
						["ATTACKCRIT03.ogg"] = 02.17,
						["ATTACKCRIT04.ogg"] = 02.27,
						["ATTACKCRIT05.ogg"] = 01.58,
						["ATTACKCRIT06.ogg"] = 01.41,
						["ATTACKCRIT07.ogg"] = 02.37,
						["ATTACKCRIT08.ogg"] = 01.44,
						["ATTACKCRIT09.ogg"] = 01.77,
						["ATTACKCRIT10.ogg"] = 02.40,
						["BERSERK.ogg"] = 07.41,
						["DEATH.ogg"] = 07.21,
						["LAUGH01.ogg"] = 03.43,
						["LAUGH02.ogg"] = 03.49,
						["SPELLCAST01.ogg"] = 01.57,
						["SPELLCAST02.ogg"] = 02.35,
						["SPELLCAST03.ogg"] = 01.30,
						["SPELLCAST04.ogg"] = 01.20,
						["WOUND01.ogg"] = 00.89,
						["WOUND02.ogg"] = 00.89,
						["WOUND03.ogg"] = 00.81,
						["WOUND04.ogg"] = 01.19,
						["WOUND05.ogg"] = 01.04,
						["WOUND06.ogg"] = 00.85,
						["WOUND07.ogg"] = 01.01,
						["WOUND08.ogg"] = 01.10,
						["WOUND09.ogg"] = 00.93,
						["WOUND10.ogg"] = 01.34,
						["WOUNDCRIT01.ogg"] = 01.18,
						["WOUNDCRIT02.ogg"] = 01.98,
						["WOUNDCRIT03.ogg"] = 02.61,
						["WOUNDCRIT04.ogg"] = 01.81,
						["WOUNDCRIT05.ogg"] = 01.87,
						["WOUNDCRIT06.ogg"] = 01.51,
						["WOUNDCRIT07.ogg"] = 01.59,
						["BEAR_TRANSFORM.ogg"] = 08.01,
						["DRAGONHAWK_TRANSFORM.ogg"] = 04.93,
						["EAGLE_TRANSFORM.ogg"] = 04.66,
						["FIRE_BREATH.ogg"] = 03.19,
						["LYNX_TRANSFORM.ogg"] = 08.07,
						["ZEALOT_RUSH.ogg"] = 23.94,
					},
				},
				["DaliahTheDoomsayer\\TEMPEST_"] = {
					["Dalliah_"] = {
						["Aggro01.ogg"] = 03.55,
						["Attack01.ogg"] = 01.89,
						["Attack02.ogg"] = 01.89,
						["Attack03.ogg"] = 02.34,
						["Attack04.ogg"] = 02.14,
						["Death01.ogg"] = 04.13,
						["HealLnds01.ogg"] = 03.21,
						["HealLnds02.ogg"] = 04.07,
						["Intro01.ogg"] = 06.24,
						["Slay01.ogg"] = 05.64,
						["Slay02.ogg"] = 03.17,
						["TauntWrath01.ogg"] = 04.37,
						["TauntWrath02.ogg"] = 04.48,
						["TauntWrath03.ogg"] = 04.15,
						["WhrlWnd01.ogg"] = 03.22,
						["WhrlWnd02.ogg"] = 03.26,
						["Wound01.ogg"] = 01.74,
						["Wound02.ogg"] = 01.86,
						["Wound03.ogg"] = 02.06,
						["WoundCrit01.ogg"] = 02.04,
						["WoundCrit02.ogg"] = 02.44,
						["WoundCrit03.ogg"] = 02.29,
						["WrathDies01.ogg"] = 05.34,
					},
				},
				["DalronnTheController\\"] = {
					["UK_Dalr_"] = {
						["Attack01.ogg"] = 00.78,
						["Attack02.ogg"] = 00.50,
						["Attack03.ogg"] = 00.40,
						["Attack04.ogg"] = 00.88,
						["Attack05.ogg"] = 00.98,
						["Attack06.ogg"] = 00.63,
						["Attack07.ogg"] = 00.64,
						["Wound01.ogg"] = 00.58,
						["Wound02.ogg"] = 00.61,
						["Wound03.ogg"] = 00.66,
						["Wound04.ogg"] = 00.64,
						["Wound05.ogg"] = 00.46,
						["Wound06.ogg"] = 00.68,
						["Wound07.ogg"] = 00.61,
						["WoundCrit01.ogg"] = 01.22,
						["WoundCrit02.ogg"] = 00.99,
						["WoundCrit03.ogg"] = 01.29,
						["WoundCrit04.ogg"] = 01.00,
					},
					["DalronKill.ogg"] = 02.92,
					["DalronnAggro.ogg"] = 06.89,
					["DalronnDeath01.ogg"] = 04.46,
					["DalronnDeath02.ogg"] = 04.94,
					["DalronnRaises.ogg"] = 08.10,
				},
				["DameBlaumeux\\BLA_"] = {
					["NAXX_"] = {
						["AGGRO.ogg"] = 01.70,
						["DEATH.ogg"] = 02.15,
						["SLAY.ogg"] = 01.29,
						["SPECIAL.ogg"] = 02.16,
						["TAUNT01.ogg"] = 06.16,
						["TAUNT02.ogg"] = 05.93,
						["TAUNT03.ogg"] = 04.52,
					},
				},
				["DarionMograine\\"] = {
					["IC_Darion_"] = {
						["Comp101.ogg"] = 02.27,
						["Comp102.ogg"] = 08.23,
						["Comp103.ogg"] = 04.20,
						["Comp104.ogg"] = 04.20,
						["Comp201.ogg"] = 01.84,
						["Comp202.ogg"] = 04.10,
						["Comp203.ogg"] = 05.82,
						["Comp204.ogg"] = 01.34,
						["Comp205.ogg"] = 05.33,
						["Comp206.ogg"] = 03.58,
						["Comp301.ogg"] = 01.21,
						["Comp302.ogg"] = 05.38,
						["Comp303.ogg"] = 05.24,
					},
					["PE_DarionMograine_"] = {
						["Attack01.ogg"] = 00.59,
						["Attack02.ogg"] = 00.67,
						["Attack03.ogg"] = 00.78,
						["Attack04.ogg"] = 00.73,
						["Attack05.ogg"] = 00.86,
						["Attack06.ogg"] = 00.94,
						["Attack07.ogg"] = 00.72,
						["Attack08.ogg"] = 01.20,
						["Attack09.ogg"] = 00.93,
						["Farewell01.ogg"] = 02.94,
						["Farewell02.ogg"] = 03.24,
						["Farewell03.ogg"] = 02.14,
						["Farewell04.ogg"] = 02.14,
						["Farewell05.ogg"] = 04.30,
						["FarewellScourge01.ogg"] = 01.62,
						["FarewellScourge02.ogg"] = 01.78,
						["FarewellScourge03.ogg"] = 03.03,
						["FarewellScourge04.ogg"] = 02.37,
						["FarewellScourge05.ogg"] = 03.07,
						["Greeting01.ogg"] = 04.13,
						["Greeting02.ogg"] = 03.45,
						["Greeting03.ogg"] = 02.96,
						["Greeting04.ogg"] = 03.42,
						["Greeting05.ogg"] = 03.57,
						["GreetingScourge01.ogg"] = 02.83,
						["GreetingScourge02.ogg"] = 03.25,
						["GreetingScourge03.ogg"] = 02.86,
						["GreetingScourge04.ogg"] = 02.76,
						["GreetingScourge05.ogg"] = 03.16,
						["Irritated01.ogg"] = 01.13,
						["Irritated02.ogg"] = 02.23,
						["Irritated03.ogg"] = 03.19,
						["Irritated04.ogg"] = 03.90,
						["Irritated05.ogg"] = 01.00,
						["LightsHopeFight01.ogg"] = 02.49,
						["LightsHopeFight02.ogg"] = 01.99,
						["LightsHopeFight03.ogg"] = 02.94,
						["LightsHopeFight04.ogg"] = 01.91,
						["LightsHopeFight05.ogg"] = 02.92,
						["LightsHopeFight06.ogg"] = 02.92,
						["LightsHopeFight07.ogg"] = 02.39,
						["LightsHopeFight08.ogg"] = 01.56,
						["LightsHopeFight09.ogg"] = 04.08,
						["LightsHopeFight10.ogg"] = 02.37,
						["LightsHopeFight11.ogg"] = 04.10,
						["LightsHopeFight12.ogg"] = 04.37,
						["LightsHopeFight13.ogg"] = 02.14,
						["LightsHopeFight14.ogg"] = 03.04,
						["LightsHopeFight15.ogg"] = 02.07,
						["LightsHopeFight16.ogg"] = 02.60,
						["PostFight01.ogg"] = 08.53,
						["PostFight02.ogg"] = 04.45,
						["PostFight03.ogg"] = 00.81,
						["PostFight04.ogg"] = 03.61,
						["PostFight05.ogg"] = 01.76,
						["PostFight06.ogg"] = 03.10,
						["PostFight07.ogg"] = 06.60,
						["PostFight08.ogg"] = 08.97,
						["PostFight09.ogg"] = 08.42,
						["PostFight10.ogg"] = 02.16,
						["PostFight11.ogg"] = 01.24,
						["PostFight12.ogg"] = 11.01,
						["PreFight01.ogg"] = 06.62,
						["PreFight02.ogg"] = 08.89,
						["PreFight03.ogg"] = 08.11,
						["PreFight04.ogg"] = 01.66,
						["PreFight05.ogg"] = 04.31,
						["PreFight06.ogg"] = 11.26,
						["Wound01.ogg"] = 00.53,
						["Wound02.ogg"] = 00.67,
						["Wound03.ogg"] = 00.58,
						["Wound04.ogg"] = 00.83,
						["Wound05.ogg"] = 00.56,
						["Wound06.ogg"] = 00.81,
						["WoundCrit01.ogg"] = 00.80,
						["WoundCrit02.ogg"] = 00.71,
						["WoundCrit03.ogg"] = 00.82,
						["WoundCrit04.ogg"] = 00.85,
						["WoundCrit05.ogg"] = 01.17,
					},
				},
				["DarkAnimus\\MON_"] = {
					["DarkAnimus_"] = {
						["Aggro_"] = {
							["01.OGG"] = 03.92,
							["02.OGG"] = 03.20,
							["03.OGG"] = 03.92,
							["04.OGG"] = 03.38,
							["05.OGG"] = 03.40,
							["06.OGG"] = 02.96,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 02.32,
							["02.OGG"] = 02.33,
							["03.OGG"] = 02.29,
							["04.OGG"] = 02.29,
							["05.OGG"] = 02.30,
							["06.OGG"] = 02.34,
							["07.OGG"] = 02.31,
						},
						["Attack_"] = {
							["01.OGG"] = 01.96,
							["02.OGG"] = 01.98,
							["03.OGG"] = 01.94,
							["04.OGG"] = 02.03,
							["05.OGG"] = 01.96,
							["06.OGG"] = 01.96,
							["07.OGG"] = 01.96,
							["08.OGG"] = 01.96,
							["09.OGG"] = 01.96,
							["10.OGG"] = 01.96,
						},
						["Death_"] = {
							["01.OGG"] = 04.27,
							["02.OGG"] = 03.23,
							["03.OGG"] = 03.53,
							["04.OGG"] = 03.51,
							["05.OGG"] = 03.66,
							["06.OGG"] = 04.05,
							["07.OGG"] = 04.16,
							["08.OGG"] = 04.43,
						},
						["Emerge_"] = {
							["01.OGG"] = 03.17,
							["02.OGG"] = 03.19,
							["03.OGG"] = 03.24,
							["04.OGG"] = 03.28,
							["05.OGG"] = 03.21,
							["06.OGG"] = 02.92,
						},
						["PreAggro_"] = {
							["01.OGG"] = 02.71,
							["02.OGG"] = 02.03,
							["03.OGG"] = 03.25,
							["04.OGG"] = 03.72,
							["05.OGG"] = 02.91,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.94,
							["02.OGG"] = 01.92,
							["03.OGG"] = 01.92,
							["04.OGG"] = 01.93,
							["05.OGG"] = 01.93,
							["06.OGG"] = 01.93,
							["07.OGG"] = 02.21,
							["08.OGG"] = 02.27,
						},
						["Wound_"] = {
							["01.OGG"] = 01.43,
							["02.OGG"] = 01.43,
							["03.OGG"] = 01.43,
							["04.OGG"] = 01.42,
							["05.OGG"] = 01.42,
							["06.OGG"] = 01.42,
							["07.OGG"] = 01.42,
							["08.OGG"] = 01.46,
							["09.OGG"] = 01.43,
							["10.OGG"] = 01.44,
						},
					},
				},
				["DarkHound\\"] = {
					["mDarkHoundAggroA.ogg"] = 02.61,
					["mDarkHoundAttackA.ogg"] = 01.42,
					["mDarkHoundAttackB.ogg"] = 01.08,
					["mDarkHoundAttackC.ogg"] = 01.45,
					["mDarkHoundAttackD.ogg"] = 01.10,
					["mDarkHoundDeathA.ogg"] = 01.96,
					["mDarkHoundSpellCastA.ogg"] = 01.17,
					["mDarkHoundSpellCastB.ogg"] = 00.97,
					["mDarkHoundStandA.ogg"] = 00.53,
					["mDarkHoundWoundA.ogg"] = 00.97,
					["mDarkHoundWoundB.ogg"] = 01.38,
					["mDarkHoundWoundC.ogg"] = 00.93,
					["mDarkHoundWoundCriticalA.ogg"] = 01.37,
				},
				["DarkmasterGandling\\VO_"] = {
					["DarkmasterGandling_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.85,
							["02.OGG"] = 00.76,
							["03.OGG"] = 01.54,
							["04.OGG"] = 00.99,
							["05.OGG"] = 02.16,
						},
						["Attack_"] = {
							["01.OGG"] = 00.30,
							["02.OGG"] = 00.34,
							["03.OGG"] = 00.32,
							["04.OGG"] = 00.36,
							["05.OGG"] = 00.46,
							["06.OGG"] = 00.32,
							["07.OGG"] = 00.37,
							["08.OGG"] = 01.11,
							["09.OGG"] = 00.44,
							["10.OGG"] = 00.79,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.77,
							["02.OGG"] = 00.98,
							["03.OGG"] = 01.12,
							["04.OGG"] = 00.71,
							["05.OGG"] = 01.24,
						},
						["Wound_"] = {
							["01.OGG"] = 01.02,
							["02.OGG"] = 00.47,
							["03.OGG"] = 00.28,
							["04.OGG"] = 00.32,
							["05.OGG"] = 01.67,
							["06.OGG"] = 00.28,
							["07.OGG"] = 00.85,
							["08.OGG"] = 00.52,
							["09.OGG"] = 00.70,
							["10.OGG"] = 00.40,
						},
					},
					["SCHO_GANDLING_"] = {
						["EVENT_"] = {
							["FINALE_"] = {
								["01.OGG"] = 01.58,
								["02.OGG"] = 03.75,
							},
							["01.OGG"] = 07.02,
							["02.OGG"] = 06.30,
							["03.OGG"] = 04.32,
							["04.OGG"] = 06.07,
							["05.OGG"] = 05.43,
							["06.OGG"] = 05.93,
							["07.OGG"] = 03.68,
							["08.OGG"] = 05.96,
							["09.OGG"] = 05.85,
							["10.OGG"] = 03.22,
							["HEALTH50%_01.OGG"] = 04.71,
							["HEALTH75%_01.OGG"] = 06.51,
							["REZ_01.OGG"] = 05.61,
							["SPIRIT1%_01.OGG"] = 05.98,
							["SPIRIT50%_01.OGG"] = 04.54,
						},
						["AGGRO_01.OGG"] = 02.50,
						["DEATH_01.OGG"] = 05.55,
						["INTRO_01.OGG"] = 05.77,
						["SLAY_01.OGG"] = 01.15,
					},
				},
				["DarkmoonEyePet\\Pet_"] = {
					["DarkmoonEye_"] = {
						["Clickble01.OGG"] = 01.33,
						["Clickble02.OGG"] = 00.94,
						["Clickble03.OGG"] = 01.51,
						["Clickble04.OGG"] = 01.43,
						["Clickble05.OGG"] = 01.36,
						["Clickble06.OGG"] = 01.67,
						["Clickble07.OGG"] = 01.43,
						["Clickble08.OGG"] = 01.08,
						["Death01.OGG"] = 01.98,
						["Death02.OGG"] = 02.13,
						["Wound01.OGG"] = 01.16,
						["Wound02.OGG"] = 01.14,
						["Wound03.OGG"] = 01.44,
					},
				},
				["DarkPhoenix\\DarkPhoenix_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.57,
						["02.ogg"] = 01.65,
						["03.ogg"] = 01.78,
						["04.ogg"] = 01.36,
						["05.ogg"] = 01.73,
						["06.ogg"] = 01.56,
						["07.ogg"] = 01.45,
						["08.ogg"] = 01.51,
						["09.ogg"] = 01.57,
						["10.ogg"] = 02.04,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 01.41,
						["02.ogg"] = 01.34,
						["03.ogg"] = 01.17,
						["04.ogg"] = 01.32,
						["05.ogg"] = 01.36,
					},
					["Attack_"] = {
						["01.ogg"] = 01.34,
						["02.ogg"] = 01.31,
						["03.ogg"] = 01.12,
						["04.ogg"] = 01.32,
						["05.ogg"] = 01.52,
						["06.ogg"] = 01.31,
						["07.ogg"] = 01.28,
						["08.ogg"] = 01.44,
						["09.ogg"] = 01.22,
						["10.ogg"] = 01.60,
					},
					["Death_"] = {
						["01.ogg"] = 02.21,
						["02.ogg"] = 02.36,
						["03.ogg"] = 02.13,
						["04.ogg"] = 02.57,
						["05.ogg"] = 02.32,
						["06.ogg"] = 01.88,
						["07.ogg"] = 02.07,
						["08.ogg"] = 02.31,
						["09.ogg"] = 02.36,
						["10.ogg"] = 01.89,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.32,
						["02.ogg"] = 01.31,
						["03.ogg"] = 01.08,
						["04.ogg"] = 01.09,
						["05.ogg"] = 00.94,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 00.93,
						["02.ogg"] = 01.05,
						["03.ogg"] = 01.12,
						["04.ogg"] = 00.98,
						["05.ogg"] = 01.05,
					},
					["Wound_"] = {
						["01.ogg"] = 00.83,
						["02.ogg"] = 00.76,
						["03.ogg"] = 01.05,
						["04.ogg"] = 01.02,
						["05.ogg"] = 00.95,
						["06.ogg"] = 01.06,
						["07.ogg"] = 00.92,
						["08.ogg"] = 01.10,
						["09.ogg"] = 00.96,
						["10.ogg"] = 00.94,
					},
				},
				["DarkShamanFemale\\VO_"] = {
					["54_"] = {
						["OR_DSHAMF_"] = {
							["SPELL_"] = {
								["1.OGG"] = 04.50,
								["2.OGG"] = 05.65,
							},
							["AGGRO.OGG"] = 04.24,
							["DEATH.OGG"] = 05.61,
							["KILL.OGG"] = 05.51,
							["SPELL.OGG"] = 05.93,
							["INTRO_1.OGG"] = 01.59,
						},
						["SHAMANFEMALE_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 00.99,
								["02.OGG"] = 00.59,
								["03.OGG"] = 00.42,
								["04.OGG"] = 00.37,
								["05.OGG"] = 00.38,
							},
							["Attack_"] = {
								["01.OGG"] = 00.48,
								["010.OGG"] = 00.48,
								["02.OGG"] = 00.23,
								["03.OGG"] = 00.41,
								["04.OGG"] = 00.80,
								["05.OGG"] = 00.27,
								["06.OGG"] = 00.58,
								["07.OGG"] = 00.48,
								["08.OGG"] = 00.52,
								["09.OGG"] = 00.43,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.14,
								["02.OGG"] = 01.12,
								["03.OGG"] = 01.00,
								["04.OGG"] = 00.98,
								["05.OGG"] = 01.23,
							},
							["Wound_"] = {
								["01.OGG"] = 00.58,
								["02.OGG"] = 00.44,
								["03.OGG"] = 00.47,
								["04.OGG"] = 00.90,
								["05.OGG"] = 00.53,
								["06.OGG"] = 00.68,
								["07.OGG"] = 00.41,
								["08.OGG"] = 00.62,
							},
						},
					},
				},
				["DarkShamanMale\\VO_"] = {
					["54_"] = {
						["DSHAMM_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.58,
								["02.OGG"] = 02.08,
								["03.OGG"] = 01.21,
								["04.OGG"] = 02.62,
								["05.OGG"] = 01.51,
							},
							["Attack_"] = {
								["01.OGG"] = 00.55,
								["010.OGG"] = 00.70,
								["02.OGG"] = 00.36,
								["03.OGG"] = 00.37,
								["04.OGG"] = 00.39,
								["05.OGG"] = 00.43,
								["06.OGG"] = 00.49,
								["07.OGG"] = 00.31,
								["08.OGG"] = 00.65,
								["09.OGG"] = 00.55,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.22,
								["02.OGG"] = 01.85,
								["03.OGG"] = 01.06,
								["04.OGG"] = 02.29,
								["05.OGG"] = 02.29,
							},
							["Wound_"] = {
								["01.OGG"] = 00.57,
								["02.OGG"] = 00.40,
								["03.OGG"] = 00.56,
								["04.OGG"] = 00.46,
								["05.OGG"] = 00.45,
								["06.OGG"] = 00.56,
								["07.OGG"] = 00.61,
								["08.OGG"] = 00.73,
								["09.OGG"] = 00.67,
							},
						},
						["OR_DSHAMM_"] = {
							["INTRO_"] = {
								["1.OGG"] = 01.74,
								["2.OGG"] = 02.05,
							},
							["SPELL_"] = {
								["1.OGG"] = 04.29,
								["2.OGG"] = 04.68,
							},
							["AGGRO.OGG"] = 03.83,
							["DEATH.OGG"] = 07.26,
							["KILL.OGG"] = 03.62,
							["SPELL.OGG"] = 05.19,
						},
					},
				},
				["DarkweaverSyth\\Auch_"] = {
					["Syth_"] = {
						["Aggro01.ogg"] = 05.68,
						["Aggro02.ogg"] = 05.26,
						["Aggro03.ogg"] = 06.52,
						["Death01.ogg"] = 09.14,
						["Slay01.ogg"] = 05.94,
						["Slay02.ogg"] = 03.81,
						["Summon01.ogg"] = 06.70,
					},
				},
				["Darmac\\VO_"] = {
					["60_"] = {
						["BFR_BREAKER_"] = {
							["DARMAC_"] = {
								["EVENT_"] = {
									["01.OGG"] = 03.03,
									["02.OGG"] = 02.11,
									["03.OGG"] = 01.36,
									["04.OGG"] = 04.93,
									["05.OGG"] = 04.33,
									["06.OGG"] = 06.16,
									["07.OGG"] = 07.26,
									["08.OGG"] = 09.84,
								},
								["SLAY_"] = {
									["01.OGG"] = 01.40,
									["02.OGG"] = 02.76,
									["03.OGG"] = 00.94,
								},
								["SPELL_"] = {
									["01.OGG"] = 02.16,
									["02.OGG"] = 02.39,
									["03.OGG"] = 02.59,
								},
								["AGGRO.OGG"] = 04.89,
								["DEATH.OGG"] = 05.12,
							},
						},
						["BREAKERDARMAC_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 02.45,
								["02.OGG"] = 01.76,
								["03.OGG"] = 01.24,
								["04.OGG"] = 00.79,
								["05.OGG"] = 01.35,
							},
							["Attack_"] = {
								["01.OGG"] = 00.58,
								["02.OGG"] = 00.56,
								["03.OGG"] = 00.66,
								["04.OGG"] = 00.56,
								["05.OGG"] = 00.44,
								["06.OGG"] = 00.45,
								["07.OGG"] = 00.63,
								["08.OGG"] = 00.68,
								["09.OGG"] = 01.44,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 02.14,
								["02.OGG"] = 00.95,
								["03.OGG"] = 01.14,
								["04.OGG"] = 01.56,
								["05.OGG"] = 00.93,
							},
							["Wound_"] = {
								["01.OGG"] = 00.42,
								["010.OGG"] = 00.93,
								["02.OGG"] = 00.70,
								["03.OGG"] = 00.68,
								["04.OGG"] = 00.61,
								["05.OGG"] = 00.79,
								["06.OGG"] = 00.56,
								["07.OGG"] = 00.41,
								["08.OGG"] = 00.54,
								["09.OGG"] = 00.62,
							},
						},
					},
				},
				["DeathbringerSaurfang\\IC_"] = {
					["Dsaurfang_"] = {
						["Aggro01.ogg"] = 03.23,
						["Attack01.ogg"] = 01.67,
						["Attack02.ogg"] = 02.66,
						["Attack03.ogg"] = 01.29,
						["Attack04.ogg"] = 01.49,
						["Attack05.ogg"] = 00.66,
						["Attack06.ogg"] = 01.02,
						["Attack07.ogg"] = 01.10,
						["Attack08.ogg"] = 00.91,
						["Attack09.ogg"] = 01.45,
						["Attack10.ogg"] = 01.38,
						["Berserk01.ogg"] = 03.19,
						["Blood01.ogg"] = 03.38,
						["Death01.ogg"] = 04.08,
						["IntroAll01.ogg"] = 17.54,
						["IntroAll02.ogg"] = 09.76,
						["IntroAll03.ogg"] = 04.26,
						["IntroHor01.ogg"] = 13.75,
						["IntroHor02.ogg"] = 09.46,
						["IntroHor03.ogg"] = 08.87,
						["Slay01.ogg"] = 01.59,
						["Slay02.ogg"] = 03.01,
						["Summon01.ogg"] = 02.34,
						["Wound01.ogg"] = 00.86,
						["Wound02.ogg"] = 00.97,
						["Wound03.ogg"] = 01.08,
						["Wound04.ogg"] = 00.97,
						["Wound05.ogg"] = 00.80,
						["Wound06.ogg"] = 00.99,
						["Wound07.ogg"] = 01.02,
						["Wound08.ogg"] = 00.90,
						["Wound09.ogg"] = 01.89,
						["WoundCrit01.ogg"] = 01.01,
						["WoundCrit02.ogg"] = 01.83,
						["WoundCrit03.ogg"] = 00.83,
						["WoundCrit04.ogg"] = 01.10,
						["WoundCrit05.ogg"] = 00.78,
					},
				},
				["DeathKnight\\"] = {
					["DeathKnightAggro.ogg"] = 02.74,
					["DeathKnightAttackA.ogg"] = 02.11,
					["DeathKnightAttackB.ogg"] = 02.40,
					["DeathKnightAttackC.ogg"] = 02.34,
					["DeathKnightAttackD.ogg"] = 02.20,
					["DeathKnightAttackE.ogg"] = 02.56,
					["DeathKnightDeath.ogg"] = 03.44,
					["DeathKnightPreAggro.ogg"] = 01.96,
					["DeathKnightWoundA.ogg"] = 01.86,
					["DeathKnightWoundB.ogg"] = 02.64,
					["DeathKnightWoundC.ogg"] = 02.29,
					["DeathKnightWoundCrit.ogg"] = 02.80,
					["DeathKnightWoundD.ogg"] = 01.95,
				},
				["DeathKnightMount\\"] = {
					["DeathKnightMountAggro1.ogg"] = 01.41,
					["DeathKnightMountAttack1.ogg"] = 01.41,
					["DeathKnightMountAttack2.ogg"] = 01.72,
					["DeathKnightMountAttack3.ogg"] = 01.60,
					["DeathKnightMountDeath1.ogg"] = 02.79,
					["DeathKnightMountWound1.ogg"] = 01.79,
					["DeathKnightMountWound2.ogg"] = 01.99,
					["DeathKnightMountWound3.ogg"] = 02.18,
					["DeathKnightMountWound4.ogg"] = 01.06,
					["DeathKnightMountWoundCritical1.ogg"] = 02.41,
				},
				["Deathwing\\"] = {
					["DeathwingHuman_"] = {
						["AttackCrit_"] = {
							["01.ogg"] = 00.79,
							["02.ogg"] = 01.07,
							["03.ogg"] = 01.26,
							["04.ogg"] = 00.95,
							["05.ogg"] = 01.14,
						},
						["Attack_"] = {
							["01.ogg"] = 00.65,
							["02.ogg"] = 00.50,
							["03.ogg"] = 00.51,
							["04.ogg"] = 00.77,
							["05.ogg"] = 00.63,
							["06.ogg"] = 00.58,
							["07.ogg"] = 00.44,
							["08.ogg"] = 00.63,
							["09.ogg"] = 00.68,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 00.92,
							["02.ogg"] = 00.95,
							["03.ogg"] = 00.94,
							["04.ogg"] = 01.01,
							["05.ogg"] = 00.75,
						},
						["Wound_"] = {
							["01.ogg"] = 00.39,
							["02.ogg"] = 00.55,
							["03.ogg"] = 00.53,
							["04.ogg"] = 00.56,
							["05.ogg"] = 00.41,
							["06.ogg"] = 00.42,
							["07.ogg"] = 00.61,
							["08.ogg"] = 00.62,
							["09.ogg"] = 00.52,
							["10.ogg"] = 00.59,
						},
					},
					["MON_Deathwing_"] = {
						["Aggro_"] = {
							["01.ogg"] = 04.35,
							["02.ogg"] = 03.75,
							["03.ogg"] = 03.50,
							["04.ogg"] = 03.46,
							["05.ogg"] = 03.44,
							["06.ogg"] = 03.31,
							["07.ogg"] = 03.52,
							["08.ogg"] = 03.93,
							["09.ogg"] = 03.77,
							["10.ogg"] = 04.10,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 04.40,
							["02.ogg"] = 04.21,
							["03.ogg"] = 03.85,
							["04.ogg"] = 03.74,
							["05.ogg"] = 03.01,
						},
						["Attack_"] = {
							["01.ogg"] = 03.74,
							["02.ogg"] = 04.07,
							["03.ogg"] = 03.34,
							["04.ogg"] = 03.20,
							["05.ogg"] = 03.13,
							["06.ogg"] = 03.06,
							["07.ogg"] = 03.58,
							["08.ogg"] = 03.31,
							["09.ogg"] = 03.20,
							["10.ogg"] = 03.60,
						},
						["Death_"] = {
							["01.ogg"] = 05.46,
							["02.ogg"] = 05.33,
							["03.ogg"] = 06.62,
							["04.ogg"] = 04.87,
							["05.ogg"] = 05.31,
							["06.ogg"] = 06.21,
							["07.ogg"] = 05.92,
							["08.ogg"] = 05.01,
							["09.ogg"] = 06.95,
							["10.ogg"] = 06.51,
						},
						["PreAggro_"] = {
							["01.ogg"] = 03.61,
							["02.ogg"] = 04.70,
							["03.ogg"] = 03.71,
							["04.ogg"] = 05.26,
							["05.ogg"] = 03.79,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 03.89,
							["02.ogg"] = 04.32,
							["03.ogg"] = 04.18,
							["04.ogg"] = 04.37,
							["05.ogg"] = 04.61,
						},
						["Wound_"] = {
							["01.ogg"] = 04.09,
							["02.ogg"] = 03.79,
							["03.ogg"] = 03.61,
							["04.ogg"] = 04.11,
							["05.ogg"] = 03.62,
							["06.ogg"] = 04.10,
							["07.ogg"] = 03.67,
							["08.ogg"] = 04.09,
							["09.ogg"] = 03.87,
							["10.ogg"] = 03.46,
						},
					},
					["VO_"] = {
						["53_Deathwing_"] = {
							["Legendary_"] = {
								["01.OGG"] = 04.64,
								["02.OGG"] = 07.26,
								["03.OGG"] = 05.53,
								["04.OGG"] = 04.64,
								["05.OGG"] = 05.91,
							},
						},
						["DS_DEATHWING_"] = {
							["BACKEVENT_"] = {
								["01.OGG"] = 10.01,
								["02.OGG"] = 06.69,
								["03.OGG"] = 07.43,
								["04.OGG"] = 08.91,
							},
							["BACKSLAY_"] = {
								["01.OGG"] = 06.97,
								["02.OGG"] = 06.18,
								["03.OGG"] = 08.39,
								["04.OGG"] = 08.04,
							},
							["MAELSTROMSLAY_"] = {
								["01.OGG"] = 09.56,
								["02.OGG"] = 06.47,
								["03.OGG"] = 06.20,
							},
							["MAELSTROMSPELL_"] = {
								["01.OGG"] = 04.64,
								["02.OGG"] = 05.91,
								["03.OGG"] = 06.08,
								["04.OGG"] = 04.64,
								["05.OGG"] = 05.19,
								["06.OGG"] = 04.54,
							},
							["PREULTRAXION_"] = {
								["01.OGG"] = 08.86,
								["02.OGG"] = 13.95,
								["03.OGG"] = 11.61,
								["04.OGG"] = 11.31,
								["05.OGG"] = 10.82,
							},
							["MAELSTROMAGGRO_01.OGG"] = 09.09,
							["MAELSTROMEVENT_01.OGG"] = 17.92,
						},
						["QE_Deathwing_"] = {
							["Event01.ogg"] = 11.23,
							["Event02.ogg"] = 41.35,
							["Event03.ogg"] = 10.63,
							["Event04.ogg"] = 12.76,
							["Event05.ogg"] = 12.31,
							["Event06.ogg"] = 05.55,
						},
						["QUEST_42_"] = {
							["LEGENDARY_DEATHWING_"] = {
								["01.ogg"] = 07.59,
								["02.ogg"] = 08.64,
								["03.ogg"] = 10.35,
								["04.ogg"] = 09.56,
								["05.ogg"] = 07.92,
							},
						},
					},
				},
				["Deathy\\PET_"] = {
					["Deathy_"] = {
						["Clickable01.ogg"] = 04.93,
						["Clickable02.ogg"] = 04.93,
						["Clickable03.ogg"] = 04.93,
						["Clickable04.ogg"] = 04.93,
						["Clickable05.ogg"] = 05.47,
						["Clickable06.ogg"] = 05.39,
						["StandVar04_01.ogg"] = 03.60,
						["StandVar05_01.ogg"] = 02.73,
						["StandVar06_01.ogg"] = 01.50,
					},
				},
				["Deepholm_Golem\\MON_"] = {
					["Deepholm_Golem_"] = {
						["Aggro_"] = {
							["01.ogg"] = 02.00,
							["02.ogg"] = 02.21,
							["03.ogg"] = 01.37,
							["04.ogg"] = 01.93,
							["05.ogg"] = 02.01,
							["06.ogg"] = 01.70,
							["07.ogg"] = 02.03,
							["08.ogg"] = 01.84,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 01.66,
							["02.ogg"] = 01.58,
							["03.ogg"] = 01.74,
							["04.ogg"] = 01.91,
							["05.ogg"] = 01.72,
						},
						["Attack_"] = {
							["01.ogg"] = 01.84,
							["02.ogg"] = 02.00,
							["03.ogg"] = 01.54,
							["04.ogg"] = 01.83,
							["05.ogg"] = 01.49,
							["06.ogg"] = 01.53,
							["07.ogg"] = 01.58,
							["08.ogg"] = 01.48,
							["09.ogg"] = 01.72,
							["10.ogg"] = 01.68,
						},
						["Death_"] = {
							["01.ogg"] = 06.36,
							["02.ogg"] = 06.17,
							["03.ogg"] = 06.23,
							["04.ogg"] = 05.53,
							["05.ogg"] = 05.93,
							["06.ogg"] = 06.12,
							["07.ogg"] = 06.23,
							["08.ogg"] = 06.33,
							["09.ogg"] = 05.93,
						},
						["PreAggro_"] = {
							["01.ogg"] = 02.83,
							["02.ogg"] = 01.92,
							["03.ogg"] = 02.05,
							["04.ogg"] = 02.80,
							["05.ogg"] = 02.38,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.29,
							["02.ogg"] = 01.65,
							["03.ogg"] = 01.87,
							["04.ogg"] = 01.52,
							["05.ogg"] = 01.70,
						},
						["Wound_"] = {
							["01.ogg"] = 00.97,
							["02.ogg"] = 01.05,
							["03.ogg"] = 01.28,
							["04.ogg"] = 01.22,
							["05.ogg"] = 01.17,
							["06.ogg"] = 01.12,
							["07.ogg"] = 01.11,
							["08.ogg"] = 01.07,
							["09.ogg"] = 01.17,
							["10.ogg"] = 01.14,
						},
					},
				},
				["Deer\\"] = {
					["DeerDeathA.ogg"] = 01.79,
					["DeerWoundA.ogg"] = 00.97,
				},
				["DeloraLionheart\\VO_"] = {
					["WI_Delora_"] = {
						["Greeting_"] = {
							["01.OGG"] = 01.34,
							["02.OGG"] = 01.92,
							["03.OGG"] = 02.00,
						},
						["Pissed_"] = {
							["01.OGG"] = 02.19,
							["02.OGG"] = 01.57,
						},
						["Ship_Battle_"] = {
							["01.OGG"] = 03.01,
							["02.OGG"] = 02.85,
							["03.OGG"] = 03.57,
							["04.OGG"] = 03.64,
						},
						["Aftermath_Argument_01.OGG"] = 03.70,
						["Healing_Event_01.OGG"] = 02.97,
					},
				},
				["DemonFelImp\\VO_"] = {
					["WORLD_DEMON_"] = {
						["FELIMP_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.81,
								["02.OGG"] = 01.93,
								["03.OGG"] = 02.20,
								["04.OGG"] = 02.18,
								["05.OGG"] = 00.71,
							},
							["ATTACK_"] = {
								["Exertions_"] = {
									["01.OGG"] = 00.43,
									["02.OGG"] = 00.57,
									["03.OGG"] = 00.61,
									["04.OGG"] = 00.50,
								},
								["01.OGG"] = 06.06,
								["02.OGG"] = 00.57,
								["03.OGG"] = 00.61,
								["04.OGG"] = 00.43,
								["05.OGG"] = 00.46,
								["06.OGG"] = 00.49,
								["07.OGG"] = 00.55,
							},
							["Death_"] = {
								["01.OGG"] = 01.47,
								["02.OGG"] = 01.52,
								["03.OGG"] = 01.76,
								["04.OGG"] = 01.74,
								["05.OGG"] = 01.69,
							},
							["DISMISS_"] = {
								["01.OGG"] = 03.02,
								["02.OGG"] = 04.42,
								["03.OGG"] = 04.97,
								["04.OGG"] = 02.08,
							},
							["Laugh_"] = {
								["01.OGG"] = 01.71,
								["02.OGG"] = 01.83,
								["03.OGG"] = 02.24,
								["04.OGG"] = 04.09,
								["05.OGG"] = 03.62,
								["06.OGG"] = 03.62,
								["07.OGG"] = 00.85,
							},
							["SPELL_"] = {
								["01.OGG"] = 01.86,
								["02.OGG"] = 01.72,
								["03.OGG"] = 02.88,
								["04.OGG"] = 02.58,
							},
							["SUMMON_"] = {
								["01.OGG"] = 03.48,
								["02.OGG"] = 02.09,
								["03.OGG"] = 05.77,
								["04.OGG"] = 02.71,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.09,
								["02.OGG"] = 01.26,
								["03.OGG"] = 01.15,
								["04.OGG"] = 00.94,
								["05.OGG"] = 01.27,
							},
							["Wound_"] = {
								["01.OGG"] = 00.41,
								["02.OGG"] = 00.43,
								["03.OGG"] = 00.43,
								["04.OGG"] = 00.41,
								["05.OGG"] = 00.46,
								["06.OGG"] = 00.36,
								["07.OGG"] = 00.41,
								["08.OGG"] = 00.45,
								["09.OGG"] = 00.39,
								["10.OGG"] = 00.39,
							},
							["FUNNY_01.OGG"] = 07.55,
						},
					},
				},
				["DemonForm\\"] = {
					["DemonFormAttack1.ogg"] = 01.56,
					["DemonFormAttack2.ogg"] = 01.35,
					["DemonFormAttack3.ogg"] = 01.44,
					["DemonFormAttack4.ogg"] = 01.20,
					["DemonFormAttack5.ogg"] = 01.23,
					["DemonFormAttack6.ogg"] = 01.49,
					["DemonFormAttack7.ogg"] = 01.20,
					["DemonFormAttack8.ogg"] = 01.31,
					["DemonFormAttack9.ogg"] = 01.17,
					["DemonFormDeath.ogg"] = 02.94,
					["DemonFormWound1.ogg"] = 00.89,
					["DemonFormWound10.ogg"] = 01.15,
					["DemonFormWound2.ogg"] = 00.95,
					["DemonFormWound3.ogg"] = 00.96,
					["DemonFormWound4.ogg"] = 01.29,
					["DemonFormWound5.ogg"] = 00.98,
					["DemonFormWound6.ogg"] = 00.93,
					["DemonFormWound7.ogg"] = 01.16,
					["DemonFormWound8.ogg"] = 01.15,
					["DemonFormWound9.ogg"] = 01.06,
					["DemonFormWoundCrit1.ogg"] = 01.34,
					["DemonFormWoundCrit2.ogg"] = 01.61,
				},
				["DemonHunter\\"] = {
					["DemonHunterAggro.ogg"] = 02.91,
					["DemonHunterAttackA.ogg"] = 02.25,
					["DemonHunterAttackB.ogg"] = 01.47,
					["DemonHunterAttackC.ogg"] = 01.63,
					["DemonHunterAttackD.ogg"] = 01.58,
					["DemonHunterAttackE.ogg"] = 01.64,
					["DemonHunterDeath.ogg"] = 03.49,
					["DemonHunterPreAggro.ogg"] = 01.07,
					["DemonHunterWoundA.ogg"] = 01.47,
					["DemonHunterWoundB.ogg"] = 01.39,
					["DemonHunterWoundC.ogg"] = 01.69,
					["DemonHunterWoundCrit.ogg"] = 02.17,
					["DemonHunterWoundD.ogg"] = 01.81,
				},
				["DemonObserver\\VO_"] = {
					["OBSERVER_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 05.19,
							["02.OGG"] = 03.98,
							["03.OGG"] = 03.06,
							["04.OGG"] = 03.45,
						},
						["ATTACK_"] = {
							["01.OGG"] = 03.61,
							["02.OGG"] = 04.81,
							["03.OGG"] = 04.36,
							["04.OGG"] = 04.27,
							["05.OGG"] = 03.39,
							["06.OGG"] = 01.69,
							["07.OGG"] = 02.37,
							["08.OGG"] = 02.28,
							["09.OGG"] = 02.59,
							["10.OGG"] = 03.04,
						},
						["DEATH_"] = {
							["01.OGG"] = 06.47,
							["02.OGG"] = 07.98,
							["03.OGG"] = 03.67,
							["04.OGG"] = 04.97,
							["05.OGG"] = 04.12,
							["06.OGG"] = 05.07,
							["07.OGG"] = 06.02,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 02.69,
							["02.OGG"] = 02.59,
							["03.OGG"] = 02.23,
							["04.OGG"] = 02.48,
							["05.OGG"] = 02.35,
							["06.OGG"] = 01.72,
						},
						["WOUND_"] = {
							["01.OGG"] = 01.56,
							["02.OGG"] = 01.33,
							["03.OGG"] = 01.19,
							["04.OGG"] = 01.23,
							["05.OGG"] = 02.07,
							["06.OGG"] = 01.74,
							["07.OGG"] = 01.84,
							["08.OGG"] = 01.44,
							["09.OGG"] = 01.86,
							["10.OGG"] = 02.46,
						},
					},
					["WORLD_DEMON_"] = {
						["OBSERVER_"] = {
							["ATTACK_"] = {
								["01.OGG"] = 07.27,
								["02.OGG"] = 03.37,
								["03.OGG"] = 06.32,
								["04.OGG"] = 03.98,
							},
							["DISMISS_"] = {
								["01.OGG"] = 04.44,
								["02.OGG"] = 04.44,
							},
							["FUNNY_"] = {
								["01.OGG"] = 06.31,
								["02.OGG"] = 08.62,
							},
							["SPELL_"] = {
								["01.OGG"] = 04.37,
								["02.OGG"] = 08.01,
								["03.OGG"] = 04.34,
								["04.OGG"] = 06.32,
							},
							["SUMMON_"] = {
								["01.OGG"] = 08.08,
								["02.OGG"] = 10.92,
								["03.OGG"] = 07.32,
								["04.OGG"] = 08.23,
							},
						},
					},
				},
				["DemonShivarra\\VO_"] = {
					["WORLD_DEMON_"] = {
						["SHIVARRA_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 05.46,
								["02.OGG"] = 04.44,
								["03.OGG"] = 04.61,
								["04.OGG"] = 02.41,
								["05.OGG"] = 04.09,
								["06.OGG"] = 03.84,
								["07.OGG"] = 03.92,
							},
							["AttackExertion_"] = {
								["01.OGG"] = 01.61,
								["02.OGG"] = 01.58,
							},
							["ATTACK_"] = {
								["01.OGG"] = 01.61,
								["02.OGG"] = 01.58,
								["03.OGG"] = 01.68,
								["04.OGG"] = 01.53,
								["05.OGG"] = 01.52,
								["06.OGG"] = 01.66,
								["07.OGG"] = 01.79,
								["08.OGG"] = 02.92,
								["09.OGG"] = 03.80,
							},
							["Death_"] = {
								["01.OGG"] = 05.06,
								["02.OGG"] = 05.43,
								["03.OGG"] = 07.13,
								["04.OGG"] = 04.67,
								["05.OGG"] = 06.13,
								["06.OGG"] = 05.54,
								["07.OGG"] = 04.48,
								["08.OGG"] = 02.20,
								["09.OGG"] = 02.63,
							},
							["DISMISS_"] = {
								["01.OGG"] = 06.61,
								["02.OGG"] = 03.71,
								["03.OGG"] = 04.78,
								["04.OGG"] = 06.92,
							},
							["SPELL_"] = {
								["01.OGG"] = 04.89,
								["02.OGG"] = 06.11,
								["03.OGG"] = 06.25,
								["04.OGG"] = 06.26,
							},
							["SUMMON_"] = {
								["01.OGG"] = 03.81,
								["02.OGG"] = 07.53,
								["03.OGG"] = 04.14,
								["04.OGG"] = 07.59,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 04.49,
								["02.OGG"] = 02.06,
								["03.OGG"] = 02.66,
								["04.OGG"] = 02.90,
								["05.OGG"] = 03.29,
								["06.OGG"] = 03.84,
								["07.OGG"] = 03.36,
							},
							["Wound_"] = {
								["01.OGG"] = 01.57,
								["02.OGG"] = 02.27,
								["03.OGG"] = 02.05,
								["04.OGG"] = 01.64,
								["05.OGG"] = 02.00,
								["06.OGG"] = 01.65,
								["07.OGG"] = 01.83,
								["08.OGG"] = 02.51,
								["09.OGG"] = 02.50,
							},
							["FUNNY_01.OGG"] = 08.53,
						},
					},
				},
				["DemonVoidwalker\\VO_"] = {
					["DemonVoidwalker_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 03.62,
							["02.OGG"] = 03.39,
							["03.OGG"] = 03.50,
							["04.OGG"] = 03.46,
							["05.OGG"] = 03.67,
							["06.OGG"] = 03.15,
							["07.OGG"] = 03.10,
							["08.OGG"] = 03.33,
						},
						["Attack_"] = {
							["01.OGG"] = 03.16,
							["02.OGG"] = 03.17,
							["03.OGG"] = 03.21,
							["04.OGG"] = 02.83,
							["05.OGG"] = 02.86,
							["06.OGG"] = 02.76,
							["07.OGG"] = 02.57,
							["08.OGG"] = 03.15,
							["09.OGG"] = 02.95,
						},
						["Death_"] = {
							["01.OGG"] = 03.96,
							["02.OGG"] = 04.74,
							["03.OGG"] = 03.60,
							["04.OGG"] = 04.06,
							["05.OGG"] = 04.96,
							["06.OGG"] = 04.24,
							["07.OGG"] = 05.24,
							["08.OGG"] = 04.96,
							["09.OGG"] = 05.79,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 03.61,
							["02.OGG"] = 03.40,
							["03.OGG"] = 03.40,
							["04.OGG"] = 03.31,
							["05.OGG"] = 03.22,
							["06.OGG"] = 03.71,
						},
						["Wound_"] = {
							["01.OGG"] = 03.11,
							["02.OGG"] = 02.61,
							["03.OGG"] = 03.48,
							["04.OGG"] = 02.97,
							["05.OGG"] = 02.88,
							["06.OGG"] = 02.92,
							["07.OGG"] = 03.16,
							["08.OGG"] = 03.25,
							["09.OGG"] = 03.28,
						},
					},
					["WORLD_DEMON_"] = {
						["VOIDLORD_"] = {
							["ATTACK_"] = {
								["01.OGG"] = 06.72,
								["02.OGG"] = 06.56,
								["03.OGG"] = 05.91,
								["04.OGG"] = 07.97,
							},
							["DISMISS_"] = {
								["01.OGG"] = 12.56,
								["02.OGG"] = 12.71,
								["03.OGG"] = 06.34,
								["04.OGG"] = 11.72,
							},
							["ORDER_"] = {
								["01.OGG"] = 07.21,
								["02.OGG"] = 07.25,
								["03.OGG"] = 09.67,
							},
							["SUMMON_"] = {
								["01.OGG"] = 08.30,
								["02.OGG"] = 08.21,
								["03.OGG"] = 07.69,
								["04.OGG"] = 05.14,
							},
							["FUNNY_01.OGG"] = 06.29,
						},
					},
				},
				["DemonWrathguard\\VO_"] = {
					["DEMONWRATHGUARD_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 01.35,
							["02.OGG"] = 01.28,
							["03.OGG"] = 01.21,
							["04.OGG"] = 01.56,
							["05.OGG"] = 01.10,
							["06.OGG"] = 00.92,
							["07.OGG"] = 00.77,
							["08.OGG"] = 00.77,
							["09.OGG"] = 01.10,
							["10.OGG"] = 01.20,
						},
						["ATTACKSPIN_"] = {
							["01.OGG"] = 02.27,
							["02.OGG"] = 02.05,
							["03.OGG"] = 02.05,
						},
						["ATTACK_"] = {
							["01.OGG"] = 00.94,
							["02.OGG"] = 01.27,
							["03.OGG"] = 00.73,
							["04.OGG"] = 01.17,
							["05.OGG"] = 00.82,
							["06.OGG"] = 00.65,
							["07.OGG"] = 01.10,
							["08.OGG"] = 01.17,
							["09.OGG"] = 00.77,
							["10.OGG"] = 01.11,
							["11.OGG"] = 00.87,
						},
						["DEATH_"] = {
							["01.OGG"] = 03.24,
							["02.OGG"] = 03.04,
							["03.OGG"] = 02.93,
							["04.OGG"] = 02.79,
							["05.OGG"] = 03.91,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 01.38,
							["02.OGG"] = 01.26,
							["03.OGG"] = 01.46,
							["04.OGG"] = 01.53,
							["05.OGG"] = 01.12,
							["06.OGG"] = 01.52,
							["07.OGG"] = 01.41,
							["08.OGG"] = 01.43,
							["09.OGG"] = 01.21,
							["10.OGG"] = 01.20,
						},
						["WOUND_"] = {
							["01.OGG"] = 00.67,
							["02.OGG"] = 00.56,
							["03.OGG"] = 00.72,
							["04.OGG"] = 00.70,
							["05.OGG"] = 00.85,
							["06.OGG"] = 00.90,
							["07.OGG"] = 00.79,
							["08.OGG"] = 00.62,
							["09.OGG"] = 00.79,
							["10.OGG"] = 01.11,
						},
					},
					["WORLD_DEMON_"] = {
						["WRATHGUARD_"] = {
							["ATTACK_"] = {
								["01.OGG"] = 02.00,
								["02.OGG"] = 02.56,
								["03.OGG"] = 02.06,
								["04.OGG"] = 01.63,
							},
							["DISMISS_"] = {
								["01.OGG"] = 01.76,
								["02.OGG"] = 01.37,
								["03.OGG"] = 02.74,
								["04.OGG"] = 03.20,
							},
							["ORDER_"] = {
								["01.OGG"] = 02.27,
								["02.OGG"] = 01.09,
								["03.OGG"] = 02.17,
								["04.OGG"] = 01.56,
							},
							["SUMMON_"] = {
								["01.OGG"] = 02.85,
								["02.OGG"] = 02.14,
								["03.OGG"] = 02.35,
								["04.OGG"] = 03.28,
							},
							["FUNNY_01.OGG"] = 09.27,
						},
					},
				},
				["DevourerofSouls\\FS_"] = {
					["DevourerExert_"] = {
						["Attack01.ogg"] = 04.01,
						["Attack02.ogg"] = 03.79,
						["Attack03.ogg"] = 03.42,
						["Attack04.ogg"] = 03.60,
						["Attack05.ogg"] = 03.75,
						["Attack06.ogg"] = 03.41,
						["Attack07.ogg"] = 03.88,
						["Attack08.ogg"] = 03.43,
						["Attack09.ogg"] = 04.05,
					},
					["DevourerFemale01_"] = {
						["Aggro01.ogg"] = 12.38,
						["DarkGlare01.ogg"] = 04.60,
						["Death01.ogg"] = 10.43,
						["Slay01.ogg"] = 05.16,
						["Slay02.ogg"] = 06.22,
						["SoulAttack01.ogg"] = 10.99,
					},
					["DevourerMale01_"] = {
						["Aggro01.ogg"] = 09.04,
						["DarkGlare01.ogg"] = 06.52,
						["Death01.ogg"] = 12.28,
						["Slay01.ogg"] = 04.67,
						["Slay02.ogg"] = 04.62,
						["SoulAttack01.ogg"] = 10.06,
					},
					["DevourerMale02_"] = {
						["Death01.ogg"] = 07.05,
						["Slay01.ogg"] = 02.42,
						["Slay02.ogg"] = 03.31,
						["SoulAttack01.ogg"] = 07.60,
					},
				},
				["DEZCO\\VO_"] = {
					["DEZCO_"] = {
						["Farewell_"] = {
							["01.OGG"] = 02.28,
							["02.OGG"] = 02.52,
							["03.OGG"] = 02.06,
							["04.OGG"] = 02.42,
						},
						["Greeting_"] = {
							["01.OGG"] = 02.72,
							["02.OGG"] = 02.49,
							["03.OGG"] = 01.60,
							["04.OGG"] = 00.82,
						},
						["EVENT_BEER_DELIVERY_FINALE_01.OGG"] = 08.47,
					},
					["Kun_Lai_Dezco_Temple_Event_01.OGG"] = 09.46,
				},
				["DiabloFetish\\PET_"] = {
					["DiabloShamanPet_"] = {
						["Battleroar.OGG"] = 01.96,
						["Clickable01.OGG"] = 00.77,
						["Clickable02.OGG"] = 01.07,
						["Clickable03.OGG"] = 01.26,
						["Clickable04.OGG"] = 01.36,
						["Clickable05.OGG"] = 01.09,
						["Clickable06.OGG"] = 01.09,
						["Clickable07.OGG"] = 01.01,
						["Clickable08.OGG"] = 01.23,
						["Clickable09.OGG"] = 01.47,
						["CustomSpell01.OGG"] = 02.59,
						["Stand1.OGG"] = 01.50,
						["Stand2.OGG"] = 02.15,
					},
				},
				["DiabloFunSized\\"] = {
					["DiabloFunSized1.ogg"] = 00.48,
					["DiabloFunSized2.ogg"] = 00.42,
					["DiabloFunSized3.ogg"] = 00.37,
				},
				["Diamant\\VO_"] = {
					["QE_Diamant_"] = {
						["Event01.ogg"] = 05.57,
						["Event01a.ogg"] = 06.24,
						["Event01b.ogg"] = 04.79,
						["ProvingComp01.ogg"] = 09.92,
						["ProvingComp02.ogg"] = 11.41,
						["ProvingComp03.ogg"] = 13.76,
						["ProvingComp05.ogg"] = 07.00,
						["ProvingComp05a.ogg"] = 06.11,
						["ProvingComp05b.ogg"] = 06.58,
						["ProvingComp06.ogg"] = 14.22,
						["ThroneDisc01.ogg"] = 06.12,
						["ThroneDisc01a.ogg"] = 07.47,
						["ThroneDisc01b.ogg"] = 07.18,
					},
				},
				["DisgustingOozeling\\PET_"] = {
					["DisgustingOozeling_"] = {
						["Clickable01.ogg"] = 01.73,
						["Clickable02.ogg"] = 01.49,
						["Clickable03.ogg"] = 01.66,
						["Clickable04.ogg"] = 01.83,
						["Clickable05.ogg"] = 01.41,
						["Clickable06.ogg"] = 01.63,
						["Clickable07.ogg"] = 02.08,
						["Clickable08.ogg"] = 01.94,
						["Clickable09.ogg"] = 01.88,
						["Clickable10.ogg"] = 02.54,
					},
				},
				["Djinn\\MON_"] = {
					["Djinn_"] = {
						["Aggro_"] = {
							["01.ogg"] = 01.62,
							["02.ogg"] = 01.59,
							["03.ogg"] = 01.38,
							["04.ogg"] = 01.61,
							["05.ogg"] = 01.83,
							["06.ogg"] = 01.48,
							["07.ogg"] = 02.00,
							["08.ogg"] = 01.32,
							["09.ogg"] = 01.68,
							["10.ogg"] = 01.54,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 01.20,
							["02.ogg"] = 00.90,
							["03.ogg"] = 00.89,
							["04.ogg"] = 01.30,
							["05.ogg"] = 00.99,
						},
						["Attack_"] = {
							["01.ogg"] = 01.15,
							["02.ogg"] = 01.85,
							["03.ogg"] = 01.45,
							["04.ogg"] = 01.12,
							["05.ogg"] = 01.36,
							["06.ogg"] = 01.16,
							["07.ogg"] = 01.07,
							["08.ogg"] = 00.96,
							["09.ogg"] = 00.97,
							["10.ogg"] = 00.95,
						},
						["Death_"] = {
							["01.ogg"] = 02.98,
							["02.ogg"] = 04.80,
							["03.ogg"] = 04.38,
							["04.ogg"] = 04.13,
							["05.ogg"] = 04.35,
							["06.ogg"] = 05.15,
							["07.ogg"] = 02.51,
							["08.ogg"] = 03.07,
							["09.ogg"] = 02.82,
							["10.ogg"] = 04.38,
						},
						["PreAggro_"] = {
							["01.ogg"] = 01.21,
							["02.ogg"] = 01.15,
							["03.ogg"] = 01.11,
							["04.ogg"] = 01.23,
							["05.ogg"] = 01.28,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.17,
							["02.ogg"] = 01.20,
							["03.ogg"] = 01.03,
							["04.ogg"] = 01.14,
							["05.ogg"] = 01.28,
						},
						["Wound_"] = {
							["01.ogg"] = 00.79,
							["02.ogg"] = 01.13,
							["03.ogg"] = 00.86,
							["04.ogg"] = 00.87,
							["05.ogg"] = 00.81,
							["06.ogg"] = 00.80,
							["07.ogg"] = 01.16,
							["08.ogg"] = 01.01,
							["09.ogg"] = 01.17,
							["10.ogg"] = 01.02,
						},
					},
				},
				["DogHandler\\VO_"] = {
					["SH_HANDLER_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 00.62,
							["02.OGG"] = 01.54,
							["03.OGG"] = 00.87,
							["04.OGG"] = 01.47,
							["05.OGG"] = 00.74,
						},
						["ATTACK_"] = {
							["01.OGG"] = 00.49,
							["02.OGG"] = 00.71,
							["03.OGG"] = 00.50,
							["04.OGG"] = 00.57,
							["05.OGG"] = 00.41,
							["06.OGG"] = 00.30,
							["07.OGG"] = 00.35,
							["08.OGG"] = 00.79,
						},
						["DEATH_"] = {
							["01.OGG"] = 02.63,
							["02.OGG"] = 02.34,
							["03.OGG"] = 03.07,
							["04.OGG"] = 00.93,
							["05.OGG"] = 00.92,
							["06.OGG"] = 00.98,
							["08.OGG"] = 01.96,
						},
						["EVENT_"] = {
							["01.OGG"] = 03.93,
							["02.OGG"] = 03.76,
							["03.OGG"] = 03.57,
							["04.OGG"] = 04.42,
							["05.OGG"] = 05.02,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 00.63,
							["02.OGG"] = 00.34,
							["03.OGG"] = 01.14,
							["04.OGG"] = 00.52,
							["05.OGG"] = 00.57,
						},
						["WOUND_"] = {
							["01.OGG"] = 00.35,
							["02.OGG"] = 00.28,
							["03.OGG"] = 00.36,
							["04.OGG"] = 00.52,
							["05.OGG"] = 00.64,
							["06.OGG"] = 00.69,
							["07.OGG"] = 00.61,
						},
					},
				},
				["Domina\\VO_"] = {
					["60_BFD_"] = {
						["DOMINA_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 02.26,
								["02.ogg"] = 02.96,
								["03.ogg"] = 02.50,
								["04.ogg"] = 02.05,
								["05.ogg"] = 02.18,
							},
							["Attack_"] = {
								["01.ogg"] = 01.11,
								["010.ogg"] = 01.20,
								["02.ogg"] = 01.06,
								["03.ogg"] = 01.09,
								["04.ogg"] = 01.01,
								["05.ogg"] = 01.03,
								["06.ogg"] = 01.23,
								["07.ogg"] = 01.27,
								["08.ogg"] = 00.84,
								["09.ogg"] = 01.24,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.36,
								["02.ogg"] = 01.37,
								["03.ogg"] = 01.31,
								["04.ogg"] = 01.85,
								["05.ogg"] = 01.73,
							},
							["Wound_"] = {
								["01.ogg"] = 00.95,
								["010.ogg"] = 01.45,
								["02.ogg"] = 01.04,
								["03.ogg"] = 01.52,
								["04.ogg"] = 01.20,
								["05.ogg"] = 01.19,
								["06.ogg"] = 00.99,
								["07.ogg"] = 01.11,
								["08.ogg"] = 01.25,
								["09.ogg"] = 01.22,
							},
							["AGGRO.ogg"] = 05.48,
							["DEATH.ogg"] = 07.51,
							["EVENT.ogg"] = 09.78,
						},
					},
				},
				["DoomGuard\\"] = {
					["DoomGuardAggroA.ogg"] = 00.99,
					["DoomGuardAttackA.ogg"] = 01.00,
					["DoomGuardAttackB.ogg"] = 01.14,
					["DoomGuardAttackC.ogg"] = 01.20,
					["DoomGuardAttackD.ogg"] = 00.88,
					["DoomGuardDeathA.ogg"] = 03.10,
					["DoomGuardWoundA.ogg"] = 01.08,
					["DoomGuardWoundB.ogg"] = 01.37,
					["DoomGuardWoundC.ogg"] = 00.42,
					["DoomGuardWoundCritA.ogg"] = 01.79,
					["DoomGuardWoundD.ogg"] = 00.79,
				},
				["DoomGuardOutland\\"] = {
					["DoomGuardOutlandAgroA.ogg"] = 01.24,
					["DoomGuardOutlandAttack1HA.ogg"] = 01.09,
					["DoomGuardOutlandAttack1HB.ogg"] = 01.01,
					["DoomGuardOutlandAttack2HA.ogg"] = 01.05,
					["DoomGuardOutlandAttack2HB.ogg"] = 00.84,
					["DoomGuardOutlandDeathA.ogg"] = 02.86,
					["DoomGuardOutlandDeathB.ogg"] = 02.81,
					["DoomGuardOutlandPreAgroA.ogg"] = 01.22,
					["DoomGuardOutlandStandA.ogg"] = 02.04,
					["DoomGuardOutlandWoundA.ogg"] = 00.79,
					["DoomGuardOutlandWoundB.ogg"] = 00.75,
					["DoomGuardOutlandWoundC.ogg"] = 00.77,
					["DoomGuardOutlandWoundCritA.ogg"] = 01.48,
					["DoomGuardOutlandWoundD.ogg"] = 00.69,
				},
				["DoomGuardVO\\DOOM_"] = {
					["DISMISS01.ogg"] = 03.28,
					["DISMISS02.ogg"] = 03.56,
					["DISMISS03.ogg"] = 03.51,
					["DISMISS04.ogg"] = 02.24,
					["FUNNY.ogg"] = 06.00,
					["KILL01.ogg"] = 02.07,
					["KILL02.ogg"] = 03.62,
					["KILL03.ogg"] = 02.87,
					["KILL04.ogg"] = 03.56,
					["ORDER01.ogg"] = 03.56,
					["ORDER02.ogg"] = 03.23,
					["ORDER03.ogg"] = 03.70,
					["ORDER04.ogg"] = 02.41,
					["SUMMON01.ogg"] = 02.63,
					["SUMMON02.ogg"] = 02.85,
					["SUMMON03.ogg"] = 02.75,
					["SUMMON04.ogg"] = 03.93,
				},
				["DoomLordKazzak\\GRULLAIR_"] = {
					["Kazzak_"] = {
						["Aggro01.ogg"] = 03.76,
						["Aggro02.ogg"] = 03.41,
						["Attack01.ogg"] = 01.14,
						["Attack02.ogg"] = 01.31,
						["Attack03.ogg"] = 01.23,
						["Death01.ogg"] = 06.30,
						["Intro01.ogg"] = 30.67,
						["Slay01.ogg"] = 02.88,
						["Slay02.ogg"] = 02.46,
						["Slay03.ogg"] = 04.32,
						["Supreme01.ogg"] = 04.55,
						["Supreme02.ogg"] = 05.54,
						["Wound01.ogg"] = 00.60,
						["Wound02.ogg"] = 00.59,
						["Wound03.ogg"] = 00.68,
						["WoundCrit01.ogg"] = 00.86,
						["WoundCrit02.ogg"] = 01.02,
						["WoundCrit03.ogg"] = 00.85,
					},
				},
				["Doomwalker\\GRULLAIR_"] = {
					["Doom_"] = {
						["Aggro01.ogg"] = 04.65,
						["Attack01.ogg"] = 01.15,
						["Attack02.ogg"] = 01.08,
						["Attack03.ogg"] = 01.02,
						["Death01.ogg"] = 05.06,
						["Earth01.ogg"] = 03.12,
						["Earth02.ogg"] = 03.16,
						["Over01.ogg"] = 01.80,
						["Over02.ogg"] = 02.70,
						["Slay01.ogg"] = 02.40,
						["Slay02.ogg"] = 02.21,
						["Slay03.ogg"] = 02.17,
						["Wound01.ogg"] = 00.92,
						["Wound02.ogg"] = 00.95,
						["Wound03.ogg"] = 01.11,
						["Wound04.ogg"] = 01.34,
						["Wound05.ogg"] = 01.44,
						["Wound06.ogg"] = 01.63,
					},
				},
				["Doopy\\MON_"] = {
					["Penguin_Doopy_"] = {
						["Attack_"] = {
							["01.OGG"] = 01.16,
							["02.OGG"] = 01.18,
							["03.OGG"] = 01.29,
							["04.OGG"] = 01.09,
							["05.OGG"] = 01.09,
						},
					},
				},
				["Dorothee\\"] = {
					["OzDorotheeAttack01.ogg"] = 01.07,
					["OzDorotheeAttack02.ogg"] = 01.28,
					["OzDorotheeAttack03.ogg"] = 01.46,
					["OzDorotheeDies01.ogg"] = 04.53,
					["OzDorotheeSummon01.ogg"] = 03.75,
					["OzDorotheeTitoDeath01.ogg"] = 03.20,
					["OzDorotheeWound01.ogg"] = 01.04,
					["OzDorotheeWound02.ogg"] = 01.25,
					["OzDorotheeWound03.ogg"] = 01.22,
					["OzDorotheeWoundCrit01.ogg"] = 01.37,
					["OzDorotheeWoundCrit02.ogg"] = 01.56,
					["OzDorotheeWoundCrit03.ogg"] = 01.54,
					["OzPartyIntro01.ogg"] = 12.55,
				},
				["DraeneiCivFemale\\VO_"] = {
					["60_DRAENEI_"] = {
						["FEMALE_CIV_"] = {
							["FAREWELL_"] = {
								["01.ogg"] = 01.29,
								["02.ogg"] = 02.44,
								["03.ogg"] = 01.53,
								["04.ogg"] = 01.73,
							},
							["GREETING_"] = {
								["01.ogg"] = 01.10,
								["02.ogg"] = 01.30,
								["03.ogg"] = 01.46,
								["04.ogg"] = 01.73,
								["05.ogg"] = 01.19,
							},
						},
					},
				},
				["DraeneiCivMale\\VO_"] = {
					["60_DRAENEI_"] = {
						["MALE_CIV_"] = {
							["FAREWELL_"] = {
								["01.ogg"] = 01.60,
								["02.ogg"] = 01.35,
								["03.ogg"] = 02.14,
								["04.ogg"] = 01.29,
							},
							["GREETING_"] = {
								["01.ogg"] = 01.69,
								["02.ogg"] = 02.24,
								["03.ogg"] = 02.05,
								["04.ogg"] = 03.87,
							},
						},
					},
				},
				["DraeneiFemaleNPC01\\MON_"] = {
					["DraeneiFemale_NPC01_"] = {
						["Aggro_"] = {
							["01.ogg"] = 00.72,
							["02.ogg"] = 01.08,
							["03.ogg"] = 01.21,
							["04.ogg"] = 01.03,
							["05.ogg"] = 01.47,
							["06.ogg"] = 01.26,
							["07.ogg"] = 00.95,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 00.92,
							["02.ogg"] = 01.28,
							["03.ogg"] = 01.24,
							["04.ogg"] = 00.62,
							["05.ogg"] = 00.72,
							["06.ogg"] = 00.93,
						},
						["Attack_"] = {
							["01.ogg"] = 00.58,
							["010.ogg"] = 00.52,
							["011.ogg"] = 00.56,
							["02.ogg"] = 00.56,
							["03.ogg"] = 00.58,
							["04.ogg"] = 00.52,
							["05.ogg"] = 00.55,
							["06.ogg"] = 00.54,
							["07.ogg"] = 00.40,
							["08.ogg"] = 00.70,
							["09.ogg"] = 00.59,
						},
						["Death_"] = {
							["01.ogg"] = 03.50,
							["02.ogg"] = 03.28,
							["03.ogg"] = 02.01,
							["04.ogg"] = 02.02,
							["05.ogg"] = 02.04,
							["06.ogg"] = 02.19,
							["07.ogg"] = 02.03,
						},
						["PreAggro_"] = {
							["01.ogg"] = 00.75,
							["02.ogg"] = 00.77,
							["03.ogg"] = 00.67,
							["04.ogg"] = 00.77,
							["05.ogg"] = 00.64,
							["06.ogg"] = 00.64,
							["07.ogg"] = 00.60,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 00.72,
							["010.ogg"] = 00.95,
							["011.ogg"] = 01.99,
							["012.ogg"] = 01.22,
							["02.ogg"] = 00.58,
							["03.ogg"] = 00.83,
							["04.ogg"] = 00.77,
							["05.ogg"] = 01.12,
							["06.ogg"] = 01.67,
							["07.ogg"] = 00.80,
							["08.ogg"] = 00.79,
							["09.ogg"] = 00.88,
						},
						["Wound_"] = {
							["01.ogg"] = 00.40,
							["010.ogg"] = 00.31,
							["011.ogg"] = 00.39,
							["012.ogg"] = 00.69,
							["013.ogg"] = 00.61,
							["014.ogg"] = 00.61,
							["02.ogg"] = 00.48,
							["03.ogg"] = 00.38,
							["04.ogg"] = 00.49,
							["05.ogg"] = 00.38,
							["06.ogg"] = 00.36,
							["07.ogg"] = 00.53,
							["08.ogg"] = 00.33,
							["09.ogg"] = 00.45,
						},
					},
				},
				["DraeneiMaleCaster\\MON_"] = {
					["DraeneiMale_Caster_"] = {
						["Aggro_"] = {
							["01.ogg"] = 00.52,
							["02.ogg"] = 00.52,
							["03.ogg"] = 00.51,
							["04.ogg"] = 01.42,
							["05.ogg"] = 00.97,
							["06.ogg"] = 00.69,
							["07.ogg"] = 00.93,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 00.99,
							["02.ogg"] = 01.00,
							["03.ogg"] = 01.03,
							["04.ogg"] = 01.30,
							["05.ogg"] = 01.29,
							["06.ogg"] = 01.30,
						},
						["Attack_"] = {
							["01.ogg"] = 00.70,
							["010.ogg"] = 00.43,
							["011.ogg"] = 00.39,
							["012.ogg"] = 00.33,
							["013.ogg"] = 00.31,
							["02.ogg"] = 00.75,
							["03.ogg"] = 00.83,
							["04.ogg"] = 00.68,
							["05.ogg"] = 00.82,
							["06.ogg"] = 00.64,
							["07.ogg"] = 00.40,
							["08.ogg"] = 00.50,
							["09.ogg"] = 00.48,
						},
						["Death_"] = {
							["01.ogg"] = 02.67,
							["02.ogg"] = 01.44,
							["03.ogg"] = 01.82,
							["04.ogg"] = 02.82,
							["05.ogg"] = 02.45,
							["06.ogg"] = 01.93,
							["07.ogg"] = 01.37,
						},
						["PreAggro_"] = {
							["01.ogg"] = 00.40,
							["02.ogg"] = 00.29,
							["03.ogg"] = 00.63,
							["04.ogg"] = 00.35,
							["05.ogg"] = 00.35,
							["06.ogg"] = 00.32,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 00.47,
							["02.ogg"] = 00.58,
							["03.ogg"] = 00.61,
							["04.ogg"] = 00.65,
							["05.ogg"] = 01.17,
							["06.ogg"] = 00.74,
							["07.ogg"] = 00.79,
							["08.ogg"] = 01.35,
						},
						["Wound_"] = {
							["01.ogg"] = 00.33,
							["010.ogg"] = 00.62,
							["011.ogg"] = 00.58,
							["012.ogg"] = 00.50,
							["013.ogg"] = 00.96,
							["02.ogg"] = 00.48,
							["03.ogg"] = 00.39,
							["04.ogg"] = 00.36,
							["05.ogg"] = 00.30,
							["06.ogg"] = 00.39,
							["07.ogg"] = 00.41,
							["08.ogg"] = 00.51,
							["09.ogg"] = 00.60,
						},
					},
				},
				["DraeneiMaleMelee\\MON_"] = {
					["DraeneiMale_Melee_"] = {
						["Aggro_"] = {
							["01.ogg"] = 01.35,
							["02.ogg"] = 00.37,
							["03.ogg"] = 00.56,
							["04.ogg"] = 00.47,
							["05.ogg"] = 00.40,
							["06.ogg"] = 00.43,
							["07.ogg"] = 00.52,
							["08.ogg"] = 00.66,
							["09.ogg"] = 00.52,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 01.00,
							["02.ogg"] = 00.81,
							["03.ogg"] = 01.36,
							["04.ogg"] = 01.19,
							["05.ogg"] = 01.26,
							["06.ogg"] = 01.48,
							["07.ogg"] = 01.73,
							["08.ogg"] = 01.48,
							["09.ogg"] = 01.58,
						},
						["Attack_"] = {
							["01.ogg"] = 00.49,
							["010.ogg"] = 00.86,
							["011.ogg"] = 00.91,
							["012.ogg"] = 00.75,
							["02.ogg"] = 00.83,
							["03.ogg"] = 00.86,
							["04.ogg"] = 00.86,
							["05.ogg"] = 00.78,
							["06.ogg"] = 00.84,
							["07.ogg"] = 00.91,
							["08.ogg"] = 00.90,
							["09.ogg"] = 00.91,
						},
						["Death_"] = {
							["01.ogg"] = 02.20,
							["010.ogg"] = 02.55,
							["011.ogg"] = 02.33,
							["02.ogg"] = 02.25,
							["03.ogg"] = 01.27,
							["04.ogg"] = 02.11,
							["05.ogg"] = 01.35,
							["06.ogg"] = 01.99,
							["07.ogg"] = 02.05,
							["08.ogg"] = 02.32,
							["09.ogg"] = 02.33,
						},
						["PreAggro_"] = {
							["01.ogg"] = 00.35,
							["010.ogg"] = 00.52,
							["011.ogg"] = 00.37,
							["02.ogg"] = 00.34,
							["03.ogg"] = 00.23,
							["04.ogg"] = 00.23,
							["05.ogg"] = 00.41,
							["06.ogg"] = 00.44,
							["07.ogg"] = 00.41,
							["08.ogg"] = 00.68,
							["09.ogg"] = 00.39,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.05,
							["010.ogg"] = 01.37,
							["011.ogg"] = 01.27,
							["012.ogg"] = 01.53,
							["02.ogg"] = 01.24,
							["03.ogg"] = 01.44,
							["04.ogg"] = 01.14,
							["05.ogg"] = 01.18,
							["06.ogg"] = 01.17,
							["07.ogg"] = 00.74,
							["08.ogg"] = 00.89,
							["09.ogg"] = 01.04,
						},
						["Wound_"] = {
							["01.ogg"] = 00.51,
							["010.ogg"] = 00.55,
							["011.ogg"] = 00.61,
							["012.ogg"] = 00.65,
							["013.ogg"] = 00.63,
							["014.ogg"] = 00.63,
							["02.ogg"] = 00.43,
							["03.ogg"] = 01.16,
							["04.ogg"] = 00.42,
							["05.ogg"] = 00.78,
							["06.ogg"] = 00.91,
							["07.ogg"] = 00.63,
							["08.ogg"] = 00.73,
							["09.ogg"] = 00.68,
						},
					},
				},
				["DraeneiWarFemale\\VO_"] = {
					["60_DRAENEI_"] = {
						["FEMALE_WAR_"] = {
							["FAREWELL_"] = {
								["01.ogg"] = 01.22,
								["02.ogg"] = 01.20,
								["03.ogg"] = 02.27,
								["04.ogg"] = 02.46,
							},
							["GREETING_"] = {
								["01.ogg"] = 01.29,
								["02.ogg"] = 00.93,
								["03.ogg"] = 01.04,
								["04.ogg"] = 00.89,
							},
						},
					},
				},
				["DraeneiWarMale\\VO_"] = {
					["60_DRAENEI_"] = {
						["MALE_WAR_"] = {
							["FAREWELL_"] = {
								["01.ogg"] = 01.57,
								["02.ogg"] = 01.81,
								["03.ogg"] = 02.17,
								["04.ogg"] = 01.23,
							},
							["GREETING_"] = {
								["01.ogg"] = 00.79,
								["02.ogg"] = 01.58,
								["03.ogg"] = 01.34,
								["04.ogg"] = 01.22,
							},
						},
					},
				},
				["DraenorClefthoof\\MON_"] = {
					["DraenorCleftHoof_"] = {
						["Aggro_"] = {
							["01.OGG"] = 02.48,
							["02.OGG"] = 02.03,
							["03.OGG"] = 01.79,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.44,
							["02.OGG"] = 01.19,
							["03.OGG"] = 01.18,
						},
						["Attack_"] = {
							["01.OGG"] = 01.54,
							["02.OGG"] = 01.51,
							["03.OGG"] = 01.41,
							["04.OGG"] = 01.61,
							["05.OGG"] = 01.77,
						},
						["Death_"] = {
							["01.OGG"] = 02.68,
							["02.OGG"] = 02.83,
							["03.OGG"] = 02.96,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.13,
							["02.OGG"] = 01.46,
							["03.OGG"] = 01.76,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.14,
							["02.OGG"] = 01.10,
							["03.OGG"] = 01.30,
						},
						["Wound_"] = {
							["01.OGG"] = 01.09,
							["02.OGG"] = 00.89,
							["03.OGG"] = 01.21,
							["04.OGG"] = 01.11,
							["05.OGG"] = 01.12,
						},
					},
				},
				["DraenorConstruct\\MON_"] = {
					["DraenorConstruct_"] = {
						["Aggro01.ogg"] = 01.65,
						["Aggro02.ogg"] = 01.78,
						["Aggro03.ogg"] = 01.98,
						["Aggro04.ogg"] = 01.82,
						["Aggro05.ogg"] = 01.72,
						["Attack01.ogg"] = 01.61,
						["Attack02.ogg"] = 01.68,
						["Attack03.ogg"] = 01.84,
						["Attack04.ogg"] = 01.83,
						["Attack05.ogg"] = 01.86,
						["Attack06.ogg"] = 01.88,
						["Attack07.ogg"] = 01.76,
						["Attack08.ogg"] = 01.76,
						["Attack09.ogg"] = 01.72,
						["Attack10.ogg"] = 01.54,
						["AttackCrit01.ogg"] = 01.89,
						["AttackCrit02.ogg"] = 01.84,
						["AttackCrit03.ogg"] = 01.97,
						["AttackCrit04.ogg"] = 01.77,
						["AttackCrit05.ogg"] = 01.74,
						["Death01.ogg"] = 03.29,
						["Death02.ogg"] = 03.47,
						["Death03.ogg"] = 03.03,
						["Death04.ogg"] = 03.27,
						["Death05.ogg"] = 03.11,
						["Emerge.ogg"] = 04.14,
						["JumpEnd01.ogg"] = 01.95,
						["JumpEnd02.ogg"] = 02.01,
						["JumpEnd03.ogg"] = 01.81,
						["JumpStart01.ogg"] = 01.82,
						["JumpStart02.ogg"] = 01.96,
						["JumpStart03.ogg"] = 02.01,
						["PreAggro01.ogg"] = 01.27,
						["PreAggro02.ogg"] = 01.32,
						["PreAggro03.ogg"] = 01.49,
						["Wound01.ogg"] = 01.76,
						["Wound02.ogg"] = 01.68,
						["Wound03.ogg"] = 01.71,
						["Wound04.ogg"] = 01.70,
						["Wound05.ogg"] = 01.28,
						["Wound06.ogg"] = 01.39,
						["Wound07.ogg"] = 01.79,
						["Wound08.ogg"] = 01.56,
						["Wound09.ogg"] = 01.52,
						["Wound10.ogg"] = 01.81,
						["WoundCrit01.ogg"] = 01.54,
						["WoundCrit02.ogg"] = 01.71,
						["WoundCrit03.ogg"] = 01.69,
						["WoundCrit04.ogg"] = 01.69,
						["WoundCrit05.ogg"] = 02.12,
					},
				},
				["DraenorElekk\\MON_"] = {
					["DraenorElekk_"] = {
						["Aggro_"] = {
							["01.OGG"] = 04.25,
							["02.OGG"] = 03.31,
							["03.OGG"] = 03.62,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.92,
							["02.OGG"] = 01.71,
							["03.OGG"] = 01.95,
						},
						["Attack_"] = {
							["01.OGG"] = 01.98,
							["02.OGG"] = 01.57,
							["03.OGG"] = 01.72,
							["04.OGG"] = 01.72,
							["05.OGG"] = 01.67,
						},
						["Death_"] = {
							["01.OGG"] = 04.57,
							["02.OGG"] = 03.67,
							["03.OGG"] = 03.78,
						},
						["PreAggro_"] = {
							["01.OGG"] = 03.99,
							["02.OGG"] = 03.05,
							["03.OGG"] = 03.86,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.21,
							["02.OGG"] = 01.78,
							["03.OGG"] = 01.72,
						},
						["Wound_"] = {
							["01.OGG"] = 01.21,
							["02.OGG"] = 01.83,
							["03.OGG"] = 01.69,
							["04.OGG"] = 01.93,
							["05.OGG"] = 01.47,
						},
					},
				},
				["DraenorGoatPet\\MON_"] = {
					["DraenorGoat_Pet_"] = {
						["Attack01.ogg"] = 01.47,
						["Attack02.ogg"] = 01.53,
						["Attack03.ogg"] = 01.51,
						["Attack04.ogg"] = 01.33,
						["Attack05.ogg"] = 01.22,
						["Clickables01.ogg"] = 01.51,
						["Clickables02.ogg"] = 01.21,
						["Clickables03.ogg"] = 01.02,
						["Clickables04.ogg"] = 01.05,
						["Clickables05.ogg"] = 01.19,
						["Clickables06.ogg"] = 01.23,
						["Clickables07.ogg"] = 01.41,
						["Clickables08.ogg"] = 01.24,
						["Clickables09.ogg"] = 01.09,
						["Clickables10.ogg"] = 01.33,
						["Death01.ogg"] = 01.83,
						["Death02.ogg"] = 01.85,
						["Death03.ogg"] = 01.52,
						["Death04.ogg"] = 01.48,
						["Death05.ogg"] = 01.77,
						["Wound01.ogg"] = 01.20,
						["Wound02.ogg"] = 01.36,
						["Wound03.ogg"] = 01.22,
						["Wound04.ogg"] = 01.30,
						["Wound05.ogg"] = 01.34,
					},
				},
				["DraenorKaliri\\MON_"] = {
					["Draenor_Kaliri_"] = {
						["Aggro01.ogg"] = 01.88,
						["Aggro02.ogg"] = 00.94,
						["Aggro03.ogg"] = 01.47,
						["Aggro04.ogg"] = 01.31,
						["Aggro05.ogg"] = 01.48,
						["Attack01.ogg"] = 01.21,
						["Attack02.ogg"] = 01.18,
						["Attack03.ogg"] = 01.05,
						["Attack04.ogg"] = 01.41,
						["Attack05.ogg"] = 01.09,
						["Attack06.ogg"] = 01.21,
						["Attack07.ogg"] = 01.04,
						["Attack08.ogg"] = 01.21,
						["Attack09.ogg"] = 01.16,
						["Attack10.ogg"] = 01.08,
						["AttackCrit01.ogg"] = 01.28,
						["AttackCrit02.ogg"] = 01.30,
						["AttackCrit03.ogg"] = 01.52,
						["AttackCrit04.ogg"] = 01.25,
						["AttackCrit05.ogg"] = 02.00,
						["Death01.ogg"] = 03.29,
						["Death02.ogg"] = 03.99,
						["Death03.ogg"] = 04.02,
						["Death04.ogg"] = 03.72,
						["Death05.ogg"] = 03.79,
						["PreAggro01.ogg"] = 01.02,
						["PreAggro02.ogg"] = 00.42,
						["PreAggro03.ogg"] = 01.28,
						["Wound01.ogg"] = 01.29,
						["Wound02.ogg"] = 01.05,
						["Wound03.ogg"] = 01.49,
						["Wound04.ogg"] = 01.31,
						["Wound05.ogg"] = 01.43,
						["Wound06.ogg"] = 01.53,
						["Wound07.ogg"] = 01.44,
						["Wound08.ogg"] = 01.38,
						["Wound09.ogg"] = 01.24,
						["Wound10.ogg"] = 01.18,
						["WoundCrit01.ogg"] = 01.71,
						["WoundCrit02.ogg"] = 01.34,
						["WoundCrit03.ogg"] = 01.80,
						["WoundCrit04.ogg"] = 01.70,
						["WoundCrit05.ogg"] = 01.56,
					},
				},
				["DraenorTalbuk\\MON_"] = {
					["DraenorTalbuk_"] = {
						["Aggro_"] = {
							["01.OGG"] = 02.13,
							["02.OGG"] = 01.75,
							["03.OGG"] = 01.77,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.10,
							["02.OGG"] = 00.94,
							["03.OGG"] = 00.98,
						},
						["Attack_"] = {
							["01.OGG"] = 00.99,
							["02.OGG"] = 01.20,
							["03.OGG"] = 01.08,
							["04.OGG"] = 01.04,
							["05.OGG"] = 00.95,
						},
						["Death_"] = {
							["01.OGG"] = 02.41,
							["02.OGG"] = 02.44,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.87,
							["02.OGG"] = 01.67,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.19,
							["02.OGG"] = 00.91,
							["03.OGG"] = 00.89,
						},
						["Wound_"] = {
							["01.OGG"] = 00.87,
							["02.OGG"] = 00.72,
							["03.OGG"] = 00.88,
							["04.OGG"] = 00.86,
							["05.OGG"] = 00.85,
						},
					},
				},
				["DraenorWolf\\"] = {
					["FX_FW_"] = {
						["WolfHowl_"] = {
							["Dry_"] = {
								["01.OGG"] = 09.25,
								["02.OGG"] = 10.00,
								["03.OGG"] = 10.00,
								["04.OGG"] = 10.00,
								["05.OGG"] = 06.57,
								["06.OGG"] = 06.32,
								["07.OGG"] = 07.43,
							},
							["Wet_"] = {
								["01.OGG"] = 07.96,
								["02.OGG"] = 07.92,
								["03.OGG"] = 07.39,
								["04.OGG"] = 07.19,
								["05.OGG"] = 08.79,
							},
						},
					},
					["Mon_DraenorWolf_"] = {
						["Attack01.OGG"] = 01.49,
						["Attack02.OGG"] = 01.49,
						["Attack03.OGG"] = 01.45,
						["Attack04.OGG"] = 01.45,
						["Attack05.OGG"] = 01.45,
						["Attack06.OGG"] = 01.08,
						["Attack07.OGG"] = 01.45,
						["Attack08.OGG"] = 01.45,
						["Attack09.OGG"] = 01.45,
						["Attack10.OGG"] = 01.45,
						["AttackCrit01.OGG"] = 01.94,
						["AttackCrit02.OGG"] = 01.94,
						["AttackCrit03.OGG"] = 01.94,
						["AttackCrit04.OGG"] = 01.95,
						["CREATURESPECIAL01.OGG"] = 03.10,
						["CREATURESPECIAL02.OGG"] = 02.87,
						["CREATURESPECIAL03.OGG"] = 02.68,
						["Death01.OGG"] = 01.37,
						["Death02.OGG"] = 02.10,
						["Death03.OGG"] = 01.85,
						["Death04.OGG"] = 02.08,
						["Death05.OGG"] = 00.78,
						["PreAggro01.OGG"] = 01.90,
						["PreAggro02.OGG"] = 01.87,
						["PreAggro03.OGG"] = 01.07,
						["PreAggro04.OGG"] = 02.06,
						["PreAggro05.OGG"] = 01.61,
						["Wound01.OGG"] = 01.34,
						["Wound02.OGG"] = 01.61,
						["Wound03.OGG"] = 01.62,
						["Wound04.OGG"] = 00.95,
						["Wound05.OGG"] = 00.74,
						["Wound06.OGG"] = 01.16,
						["Wound07.OGG"] = 01.32,
						["WoundCrit01.OGG"] = 00.74,
						["WoundCrit02.OGG"] = 00.77,
						["WoundCrit03.OGG"] = 00.80,
						["WoundCrit04.OGG"] = 01.02,
					},
				},
				["DraenorWolfPup\\PET_"] = {
					["DraenorWolfPup_"] = {
						["Stand_"] = {
							["Var1.OGG"] = 02.65,
							["Var2.OGG"] = 03.01,
						},
						["Attack01.OGG"] = 01.89,
						["Attack02.OGG"] = 01.89,
						["Attack03.OGG"] = 01.89,
						["AttackCrit01.OGG"] = 01.67,
						["AttackCrit02.OGG"] = 01.67,
						["AttackCrit03.OGG"] = 01.67,
						["Clickable01.OGG"] = 01.20,
						["Clickable02.OGG"] = 01.30,
						["Clickable03.OGG"] = 01.31,
						["Clickable04.OGG"] = 01.17,
						["Clickable05.OGG"] = 00.65,
						["Clickable06.OGG"] = 01.40,
						["Clickable07.OGG"] = 01.77,
						["Clickable08.OGG"] = 01.49,
						["Clickable09.OGG"] = 01.28,
						["Clickable10.OGG"] = 01.61,
						["Death01.OGG"] = 01.49,
						["Death02.OGG"] = 01.49,
						["Death03.OGG"] = 01.49,
						["Special01.OGG"] = 04.00,
						["Special02.OGG"] = 04.00,
						["Special03.OGG"] = 04.00,
						["Wound01.OGG"] = 01.06,
						["Wound02.OGG"] = 01.06,
						["Wound03.OGG"] = 01.06,
						["WoundCrit01.OGG"] = 01.35,
						["WoundCrit02.OGG"] = 01.35,
						["WoundCrit03.OGG"] = 01.35,
					},
				},
				["Dragonfly\\MON_"] = {
					["Dragonfly_"] = {
						["Aggro_"] = {
							["01.ogg"] = 02.22,
							["02.ogg"] = 01.98,
							["03.ogg"] = 01.55,
						},
						["Attack_"] = {
							["01.ogg"] = 01.39,
							["010.ogg"] = 01.41,
							["02.ogg"] = 01.49,
							["03.ogg"] = 01.57,
							["04.ogg"] = 01.44,
							["05.ogg"] = 01.23,
							["06.ogg"] = 01.73,
							["07.ogg"] = 01.38,
							["08.ogg"] = 01.46,
							["09.ogg"] = 01.72,
						},
						["Death_"] = {
							["01.ogg"] = 02.27,
							["02.ogg"] = 02.83,
							["03.ogg"] = 02.46,
							["04.ogg"] = 02.21,
							["05.ogg"] = 02.21,
						},
						["PreAggro_"] = {
							["01.ogg"] = 01.50,
							["02.ogg"] = 01.04,
							["03.ogg"] = 01.27,
						},
						["Stand1_"] = {
							["01.ogg"] = 02.41,
							["02.ogg"] = 02.24,
							["03.ogg"] = 02.14,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.16,
							["02.ogg"] = 01.27,
							["03.ogg"] = 00.96,
							["04.ogg"] = 01.11,
							["05.ogg"] = 01.03,
						},
						["Wound_"] = {
							["01.ogg"] = 01.08,
							["010.ogg"] = 01.00,
							["02.ogg"] = 01.42,
							["03.ogg"] = 01.15,
							["04.ogg"] = 01.28,
							["05.ogg"] = 01.40,
							["06.ogg"] = 01.06,
							["07.ogg"] = 01.35,
							["08.ogg"] = 01.18,
							["09.ogg"] = 00.72,
						},
					},
				},
				["DragonFootSoldier\\"] = {
					["DragonFootSoldierAggro.ogg"] = 01.89,
					["DragonFootSoldierAttackA.ogg"] = 01.35,
					["DragonFootSoldierAttackB.ogg"] = 01.24,
					["DragonFootSoldierAttackC.ogg"] = 01.24,
					["DragonFootSoldierDeath.ogg"] = 02.41,
					["DragonFootSoldierPreAggro.ogg"] = 01.01,
					["DragonFootSoldierWoundA.ogg"] = 01.00,
					["DragonFootSoldierWoundB.ogg"] = 01.05,
					["DragonFootSoldierWoundC.ogg"] = 00.84,
					["DragonFootSoldierWoundCrit.ogg"] = 02.05,
				},
				["DragonHawk\\"] = {
					["DragonHawkAggro.ogg"] = 02.32,
					["DragonHawkAttackA.ogg"] = 01.67,
					["DragonHawkAttackB.ogg"] = 02.26,
					["DragonHawkAttackC.ogg"] = 01.83,
					["DragonHawkAttackD.ogg"] = 01.98,
					["DragonHawkDeath.ogg"] = 01.44,
					["DragonHawkPreAggro.ogg"] = 01.68,
					["DragonHawkWoundA.ogg"] = 01.63,
					["DragonHawkWoundB.ogg"] = 01.20,
					["DragonHawkWoundC.ogg"] = 01.06,
					["DragonHawkWoundCrit.ogg"] = 02.24,
				},
				["DragonKite\\"] = {
					["PET_DragonKite_"] = {
						["Attack01.OGG"] = 02.38,
						["Attack02.OGG"] = 02.22,
						["Attack03.OGG"] = 02.23,
						["Attack04.OGG"] = 02.07,
						["Attack05.OGG"] = 01.91,
						["Clickable01.OGG"] = 00.73,
						["Clickable02.OGG"] = 00.96,
						["Clickable03.OGG"] = 00.85,
						["Clickable04.OGG"] = 00.82,
						["Clickable05.OGG"] = 01.01,
						["Clickable06.OGG"] = 01.07,
						["Death01.OGG"] = 03.41,
						["Death02.OGG"] = 03.86,
						["Death03.OGG"] = 03.79,
						["Death04.OGG"] = 03.57,
						["Wound01.OGG"] = 01.25,
						["Wound02.OGG"] = 01.63,
						["Wound03.OGG"] = 01.49,
						["Wound04.OGG"] = 01.33,
						["Wound05.OGG"] = 01.15,
						["Wound06.OGG"] = 01.36,
					},
					["DragonKite.ogg"] = 20.00,
				},
				["DragonNefarianZombified\\DragonNefarianZombified_"] = {
					["Aggro_"] = {
						["01.ogg"] = 02.18,
						["02.ogg"] = 01.97,
						["03.ogg"] = 02.35,
						["04.ogg"] = 01.71,
						["05.ogg"] = 02.00,
						["06.ogg"] = 02.05,
						["07.ogg"] = 02.38,
						["08.ogg"] = 01.91,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 02.00,
						["02.ogg"] = 02.14,
						["03.ogg"] = 02.29,
						["04.ogg"] = 02.27,
						["05.ogg"] = 02.19,
						["06.ogg"] = 02.44,
						["07.ogg"] = 02.22,
						["08.ogg"] = 02.21,
						["09.ogg"] = 02.06,
						["10.ogg"] = 02.22,
					},
					["Attack_"] = {
						["01.ogg"] = 02.24,
						["02.ogg"] = 02.25,
						["03.ogg"] = 02.00,
						["04.ogg"] = 02.00,
						["05.ogg"] = 02.33,
						["06.ogg"] = 02.26,
						["07.ogg"] = 02.07,
						["08.ogg"] = 02.04,
						["09.ogg"] = 02.03,
						["10.ogg"] = 02.28,
					},
					["Death_"] = {
						["01.ogg"] = 04.51,
						["02.ogg"] = 04.10,
						["03.ogg"] = 04.11,
						["04.ogg"] = 04.20,
						["05.ogg"] = 04.28,
						["06.ogg"] = 03.98,
						["07.ogg"] = 04.15,
						["08.ogg"] = 04.50,
						["09.ogg"] = 04.19,
						["10.ogg"] = 04.50,
					},
					["PreAggro_"] = {
						["01.ogg"] = 03.25,
						["02.ogg"] = 02.73,
						["03.ogg"] = 02.35,
						["04.ogg"] = 02.51,
						["05.ogg"] = 02.01,
						["06.ogg"] = 03.39,
						["07.ogg"] = 04.63,
						["08.ogg"] = 03.85,
						["09.ogg"] = 02.58,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.41,
						["02.ogg"] = 01.36,
						["03.ogg"] = 01.50,
						["04.ogg"] = 01.40,
						["05.ogg"] = 01.39,
						["06.ogg"] = 01.50,
						["07.ogg"] = 01.39,
						["08.ogg"] = 01.47,
						["09.ogg"] = 01.51,
						["10.ogg"] = 01.54,
					},
					["Wound_"] = {
						["01.ogg"] = 01.17,
						["02.ogg"] = 01.35,
						["03.ogg"] = 01.41,
						["04.ogg"] = 01.22,
						["05.ogg"] = 01.37,
						["06.ogg"] = 01.16,
						["07.ogg"] = 01.21,
						["08.ogg"] = 01.15,
						["09.ogg"] = 01.34,
						["10.ogg"] = 01.64,
					},
				},
				["Dragons\\"] = {
					["DragonAggro.ogg"] = 03.04,
					["DragonAttackA.ogg"] = 02.34,
					["DragonAttackB.ogg"] = 02.50,
					["DragonAttackC.ogg"] = 02.30,
					["DragonAttackD.ogg"] = 02.30,
					["DragonDeathA.ogg"] = 06.31,
					["DragonPreAggro.ogg"] = 02.94,
					["DragonWoundA.ogg"] = 01.43,
					["DragonWoundB.ogg"] = 01.03,
					["DragonWoundC.ogg"] = 00.90,
					["DragonWoundCritA.ogg"] = 01.47,
					["DragonWoundCritB.ogg"] = 02.17,
					["DragonWoundD.ogg"] = 01.00,
					["HugeWingFlap1.ogg"] = 01.30,
					["HugeWingFlap2.ogg"] = 01.19,
					["HugeWingFlap3.ogg"] = 01.30,
				},
				["DragonSkywall\\DragonSkywall_"] = {
					["ElectricLoop_"] = {
						["01.ogg"] = 08.01,
						["02.ogg"] = 08.01,
						["03.ogg"] = 08.01,
					},
				},
				["DragonSpawn\\"] = {
					["mDragonSpawnAttack1.ogg"] = 01.74,
					["mDragonSpawnAttack2.ogg"] = 01.96,
					["mDragonSpawnAttack3.ogg"] = 02.02,
					["mDragonSpawnAttackCritical1.ogg"] = 01.91,
					["mDragonSpawnDeath1.ogg"] = 02.60,
					["mDragonSpawnStand1.ogg"] = 02.58,
					["mDragonSpawnStand2.ogg"] = 02.75,
					["mDragonSpawnStand3.ogg"] = 03.74,
					["mDragonSpawnWound1.ogg"] = 01.12,
					["mDragonSpawnWound2.ogg"] = 01.07,
					["mDragonSpawnWound3.ogg"] = 01.27,
					["mDragonSpawnWoundCritical1.ogg"] = 01.28,
				},
				["DragonWhelp\\"] = {
					["mDragonWhelpAggroA.ogg"] = 02.21,
					["mDragonWhelpAggroB.ogg"] = 01.65,
					["mDragonWhelpAttackA.ogg"] = 01.18,
					["mDragonWhelpAttackB.ogg"] = 01.18,
					["mDragonWhelpAttackC.ogg"] = 01.35,
					["mDragonWhelpDeathA.ogg"] = 02.79,
					["mDragonWhelpRunFidgetA.ogg"] = 01.49,
					["mDragonWhelpRunFidgetB.ogg"] = 01.09,
					["mDragonWhelpRunFidgetC.ogg"] = 01.49,
					["mDragonWhelpRunFidgetD.ogg"] = 01.30,
					["mDragonWhelpStandFidgetA.ogg"] = 02.47,
					["mDragonWhelpWalkFidgetA.ogg"] = 02.02,
					["mDragonWhelpWingFlapA.ogg"] = 00.49,
					["mDragonWhelpWingFlapB.ogg"] = 00.49,
					["mDragonWhelpWingFlapC.ogg"] = 00.49,
					["mDragonWhelpWingFlapD.ogg"] = 00.49,
					["mDragonWhelpWingFlapE.ogg"] = 00.49,
					["mDragonWhelpWoundA.ogg"] = 00.92,
					["mDragonWhelpWoundB.ogg"] = 01.00,
					["mDragonWhelpWoundC.ogg"] = 00.71,
					["mDragonWhelpWoundCriticalA.ogg"] = 01.89,
				},
				["Dragon_Medium\\Dragon_"] = {
					["Medium_"] = {
						["Aggro_"] = {
							["01.ogg"] = 01.51,
							["02.ogg"] = 01.70,
							["03.ogg"] = 01.28,
							["04.ogg"] = 01.48,
							["05.ogg"] = 01.50,
							["06.ogg"] = 01.13,
							["07.ogg"] = 01.31,
							["08.ogg"] = 01.36,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 02.04,
							["02.ogg"] = 02.36,
							["03.ogg"] = 02.48,
							["04.ogg"] = 02.56,
							["05.ogg"] = 02.39,
							["06.ogg"] = 02.29,
							["07.ogg"] = 02.42,
							["08.ogg"] = 02.56,
							["09.ogg"] = 02.36,
							["10.ogg"] = 02.00,
						},
						["Attack_"] = {
							["01.ogg"] = 02.04,
							["02.ogg"] = 02.00,
							["03.ogg"] = 02.00,
							["04.ogg"] = 02.10,
							["05.ogg"] = 02.04,
							["06.ogg"] = 02.00,
							["07.ogg"] = 02.00,
							["08.ogg"] = 02.10,
							["09.ogg"] = 02.04,
							["10.ogg"] = 02.00,
						},
						["Death_"] = {
							["01.ogg"] = 04.15,
							["02.ogg"] = 04.16,
							["03.ogg"] = 03.76,
							["04.ogg"] = 04.30,
							["05.ogg"] = 04.11,
							["06.ogg"] = 04.31,
							["07.ogg"] = 04.27,
							["08.ogg"] = 04.44,
							["09.ogg"] = 04.33,
						},
						["PreAggro_"] = {
							["01.ogg"] = 02.39,
							["02.ogg"] = 02.47,
							["03.ogg"] = 03.04,
							["04.ogg"] = 02.68,
							["05.ogg"] = 02.76,
							["06.ogg"] = 02.31,
							["07.ogg"] = 02.58,
							["08.ogg"] = 03.15,
							["09.ogg"] = 02.45,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.31,
							["02.ogg"] = 01.47,
							["03.ogg"] = 01.62,
							["04.ogg"] = 01.34,
							["05.ogg"] = 01.63,
							["06.ogg"] = 01.80,
							["07.ogg"] = 01.56,
							["08.ogg"] = 01.52,
							["09.ogg"] = 01.57,
							["10.ogg"] = 01.60,
						},
						["Wound_"] = {
							["01.ogg"] = 01.14,
							["02.ogg"] = 01.20,
							["03.ogg"] = 01.48,
							["04.ogg"] = 01.54,
							["05.ogg"] = 01.27,
							["06.ogg"] = 01.25,
							["07.ogg"] = 01.32,
							["08.ogg"] = 01.48,
							["09.ogg"] = 01.59,
							["10.ogg"] = 01.30,
						},
					},
				},
				["Dragon_Medium_Rock\\Dragon_"] = {
					["Medium_Rock_"] = {
						["Aggro_"] = {
							["01.ogg"] = 01.44,
							["02.ogg"] = 01.81,
							["03.ogg"] = 01.40,
							["04.ogg"] = 01.66,
							["05.ogg"] = 01.80,
							["06.ogg"] = 01.25,
							["07.ogg"] = 01.31,
							["08.ogg"] = 01.50,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 02.07,
							["02.ogg"] = 02.23,
							["03.ogg"] = 02.16,
							["04.ogg"] = 02.20,
							["05.ogg"] = 02.65,
							["06.ogg"] = 02.27,
							["07.ogg"] = 02.19,
							["08.ogg"] = 01.73,
						},
						["Attack_"] = {
							["01.ogg"] = 01.63,
							["02.ogg"] = 01.62,
							["03.ogg"] = 01.57,
							["04.ogg"] = 01.51,
							["05.ogg"] = 01.46,
							["06.ogg"] = 01.51,
							["07.ogg"] = 01.72,
							["08.ogg"] = 01.99,
							["09.ogg"] = 01.92,
							["10.ogg"] = 01.83,
						},
						["Death_"] = {
							["01.ogg"] = 04.30,
							["02.ogg"] = 04.27,
							["03.ogg"] = 04.00,
							["04.ogg"] = 04.39,
							["05.ogg"] = 04.30,
							["06.ogg"] = 04.85,
							["07.ogg"] = 04.13,
							["08.ogg"] = 04.65,
							["09.ogg"] = 04.51,
						},
						["PreAggro_"] = {
							["01.ogg"] = 02.42,
							["02.ogg"] = 02.54,
							["03.ogg"] = 03.42,
							["04.ogg"] = 02.88,
							["05.ogg"] = 02.86,
							["06.ogg"] = 02.80,
							["07.ogg"] = 02.61,
							["08.ogg"] = 02.75,
							["09.ogg"] = 02.36,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.42,
							["02.ogg"] = 01.50,
							["03.ogg"] = 01.80,
							["04.ogg"] = 01.54,
							["05.ogg"] = 01.87,
							["06.ogg"] = 01.88,
							["07.ogg"] = 01.45,
							["08.ogg"] = 01.45,
							["09.ogg"] = 01.54,
							["10.ogg"] = 01.62,
						},
						["Wound_"] = {
							["01.ogg"] = 01.14,
							["02.ogg"] = 01.20,
							["03.ogg"] = 01.26,
							["04.ogg"] = 01.46,
							["05.ogg"] = 01.27,
							["06.ogg"] = 01.31,
							["07.ogg"] = 01.25,
							["08.ogg"] = 01.62,
							["09.ogg"] = 01.44,
							["10.ogg"] = 01.21,
						},
					},
				},
				["Drahga\\VO_"] = {
					["GB_Drahga_"] = {
						["Attack01.ogg"] = 01.22,
						["Attack02.ogg"] = 01.51,
						["Attack03.ogg"] = 01.18,
						["Attack04.ogg"] = 01.29,
						["Attack05.ogg"] = 00.99,
						["Attack06.ogg"] = 00.94,
						["Attack07.ogg"] = 01.20,
						["Attack08.ogg"] = 01.25,
						["Attack09.ogg"] = 00.99,
						["Attack10.ogg"] = 01.34,
						["AttackCrit01.ogg"] = 01.71,
						["AttackCrit02.ogg"] = 01.44,
						["AttackCrit03.ogg"] = 01.37,
						["AttackCrit04.ogg"] = 01.39,
						["AttackCrit05.ogg"] = 01.27,
						["Death01.ogg"] = 01.78,
						["Death02.ogg"] = 02.08,
						["Death03.ogg"] = 03.03,
						["Death04.ogg"] = 04.32,
						["Death05.ogg"] = 03.22,
						["Event01.ogg"] = 04.43,
						["Event02.ogg"] = 02.33,
						["Event03.ogg"] = 03.78,
						["Event04.ogg"] = 05.31,
						["Event05.ogg"] = 03.52,
						["Event06.ogg"] = 04.50,
						["Event07.ogg"] = 06.03,
						["Wound01.ogg"] = 01.32,
						["Wound02.ogg"] = 01.28,
						["Wound03.ogg"] = 01.27,
						["Wound04.ogg"] = 01.86,
						["Wound05.ogg"] = 02.51,
						["Wound06.ogg"] = 00.98,
						["Wound07.ogg"] = 00.98,
						["Wound08.ogg"] = 01.10,
						["Wound09.ogg"] = 00.93,
						["Wound10.ogg"] = 00.96,
						["WoundCrit01.ogg"] = 01.72,
						["WoundCrit02.ogg"] = 01.67,
						["WoundCrit03.ogg"] = 01.94,
						["WoundCrit04.ogg"] = 02.07,
						["WoundCrit05.ogg"] = 02.09,
						["WoundCrit06.ogg"] = 01.58,
					},
				},
				["Draka\\VO_"] = {
					["60_"] = {
						["DRAKA_"] = {
							["FAREWELL_"] = {
								["01.ogg"] = 02.26,
								["02.ogg"] = 01.94,
								["03.ogg"] = 01.47,
								["04.ogg"] = 01.24,
								["05.ogg"] = 01.40,
							},
							["GREETING_"] = {
								["01.ogg"] = 01.23,
								["02.ogg"] = 01.41,
								["03.ogg"] = 01.27,
								["04.ogg"] = 02.31,
								["05.ogg"] = 02.21,
							},
							["PISSED_"] = {
								["01.ogg"] = 02.23,
								["02.ogg"] = 01.71,
							},
						},
						["FFR_"] = {
							["DUEL_DRAKA_"] = {
								["01.ogg"] = 03.27,
								["02.ogg"] = 00.87,
							},
							["FARSEER_DRAKA_"] = {
								["01.OGG"] = 02.12,
								["02.OGG"] = 05.42,
								["03.OGG"] = 02.67,
								["04.OGG"] = 02.12,
								["05.OGG"] = 07.23,
							},
							["FINALE_"] = {
								["STAGE5_DRAKA_"] = {
									["01.OGG"] = 02.30,
									["02.OGG"] = 01.76,
								},
								["STAGE6_DRAKA_"] = {
									["01.OGG"] = 01.92,
									["02.OGG"] = 01.94,
									["03.OGG"] = 02.52,
									["04.OGG"] = 04.40,
									["05.OGG"] = 03.67,
									["06.OGG"] = 02.89,
								},
								["STAGE8_DRAKA_"] = {
									["01.OGG"] = 03.35,
									["02.OGG"] = 04.15,
									["03.OGG"] = 07.22,
									["04.OGG"] = 02.51,
								},
								["STAGE0_DRAKA_01.OGG"] = 04.45,
								["STAGE3_DRAKA_01.OGG"] = 02.13,
							},
							["FURY_DRAKA_"] = {
								["01.OGG"] = 02.90,
								["02.OGG"] = 03.37,
								["04.OGG"] = 02.55,
							},
							["GROMBOLASH_DRAKA_"] = {
								["01.OGG"] = 06.85,
								["02.OGG"] = 01.90,
							},
							["HORN_DRAKA_"] = {
								["01.OGG"] = 04.35,
								["02.OGG"] = 05.58,
							},
							["WORGOL_DRAKA_"] = {
								["01.OGG"] = 01.58,
								["02.OGG"] = 02.40,
								["03.OGG"] = 02.65,
								["04.OGG"] = 05.08,
								["05.OGG"] = 02.17,
								["06.OGG"] = 02.78,
								["07.OGG"] = 05.61,
								["08.OGG"] = 03.76,
								["09.OGG"] = 04.23,
							},
							["STONE_DRAKA_01.OGG"] = 03.13,
							["THUNDERFALL_DRAKA_01.OGG"] = 01.43,
						},
						["GAR_EVENT_"] = {
							["04.ogg"] = 05.63,
							["12.ogg"] = 05.92,
							["15.ogg"] = 05.82,
							["18.ogg"] = 01.70,
							["20.ogg"] = 11.84,
						},
						["GORGROND_"] = {
							["HORDE_INTRO_"] = {
								["01.ogg"] = 04.53,
								["03.ogg"] = 03.94,
							},
							["IYU_DRAKA_"] = {
								["01.ogg"] = 01.73,
								["02.ogg"] = 01.77,
							},
						},
						["SHATTRATH_DRAKA_"] = {
							["01.ogg"] = 00.97,
							["02.ogg"] = 01.09,
							["03.ogg"] = 01.14,
							["04.ogg"] = 01.73,
							["05.ogg"] = 01.61,
							["06.ogg"] = 00.79,
						},
					},
				},
				["Drake\\"] = {
					["DrakeAggro.ogg"] = 01.25,
					["DrakeAttackA.ogg"] = 01.17,
					["DrakeAttackB.ogg"] = 01.10,
					["DrakeAttackC.ogg"] = 00.91,
					["DrakeDeath.ogg"] = 02.73,
					["DrakePreAggro.ogg"] = 01.22,
					["DrakeWoundA.ogg"] = 00.90,
					["DrakeWoundB.ogg"] = 01.26,
					["DrakeWoundC.ogg"] = 01.12,
					["DrakeWoundCrit.ogg"] = 00.70,
				},
				["Drakeadon\\"] = {
					["DrakeadonAggro.ogg"] = 02.20,
					["DrakeadonAttackA.ogg"] = 01.90,
					["DrakeadonAttackB.ogg"] = 01.08,
					["DrakeadonAttackC.ogg"] = 01.37,
					["DrakeadonAttackD.ogg"] = 01.84,
					["DrakeadonDeath.ogg"] = 05.10,
					["DrakeadonPreAggro.ogg"] = 00.74,
					["DrakeadonWoundA.ogg"] = 01.27,
					["DrakeadonWoundB.ogg"] = 01.80,
					["DrakeadonWoundC.ogg"] = 01.11,
					["DrakeadonWoundCrit.ogg"] = 02.27,
					["DrakeadonWoundD.ogg"] = 01.41,
				},
				["drakemount\\DrakeMount_"] = {
					["MountSpecial_"] = {
						["01.ogg"] = 04.95,
						["02.ogg"] = 04.32,
						["03.ogg"] = 04.71,
					},
				},
				["DrakosTheInterrogator\\"] = {
					["OC_Drak_"] = {
						["Attack01.ogg"] = 00.65,
						["Attack02.ogg"] = 00.49,
						["Attack03.ogg"] = 01.35,
						["Attack04.ogg"] = 00.84,
						["Wound01.ogg"] = 00.54,
						["Wound02.ogg"] = 00.52,
						["Wound03.ogg"] = 00.79,
						["Wound04.ogg"] = 01.41,
						["WoundCrit01.ogg"] = 00.61,
						["WoundCrit02.ogg"] = 00.73,
						["WoundCrit03.ogg"] = 00.56,
					},
					["DRAKOSAGGRO.ogg"] = 06.34,
					["DRAKOSDEATH.ogg"] = 05.63,
					["DRAKOSKILL01.ogg"] = 02.70,
					["DRAKOSKILL02.ogg"] = 02.35,
					["DRAKOSKILL03.ogg"] = 02.84,
					["DRAKOSPULL01.ogg"] = 03.30,
					["DRAKOSPULL02.ogg"] = 02.14,
					["DRAKOSPULL03.ogg"] = 01.66,
					["DRAKOSPULL04.ogg"] = 04.21,
					["DRAKOSSTOMP01.ogg"] = 02.22,
					["DRAKOSSTOMP02.ogg"] = 02.69,
					["DRAKOSSTOMP03.ogg"] = 01.94,
				},
				["Drakuru\\"] = {
					["DT_Drakuru_"] = {
						["DrakTharonEvent01.ogg"] = 04.22,
						["DrakTharonEvent02.ogg"] = 01.09,
						["DrakTharonEvent03.ogg"] = 03.05,
						["DrakTharonEvent04.ogg"] = 04.57,
						["DrakTharonEvent05.ogg"] = 01.66,
						["DrakTharonEvent06.ogg"] = 04.97,
						["DrakTharonEvent07.ogg"] = 04.75,
						["DrakTharonEvent08.ogg"] = 05.71,
						["DrakTharonEvent09.ogg"] = 02.19,
						["DrakTharonEvent10.ogg"] = 04.66,
						["DrakTharonEvent11.ogg"] = 03.13,
						["DrakTharonEvent12.ogg"] = 07.78,
						["DrakTharonEvent13.ogg"] = 06.04,
						["DrakTharonEvent14.ogg"] = 05.76,
					},
					["PE_Drakuru_"] = {
						["Prefight01.ogg"] = 06.15,
						["Prefight02.ogg"] = 06.33,
						["Prefight03.ogg"] = 05.54,
						["RandomYell01.ogg"] = 04.21,
						["RandomYell02.ogg"] = 05.59,
						["RandomYell03.ogg"] = 03.95,
						["RandomYell04.ogg"] = 05.73,
						["RandomYell05.ogg"] = 04.23,
						["RandomYell06.ogg"] = 05.57,
					},
					["ZD_Drakuru_"] = {
						["ZulDrakEvent01.ogg"] = 01.38,
						["ZulDrakEvent02.ogg"] = 03.54,
						["ZulDrakEvent03.ogg"] = 07.10,
					},
				},
				["DreadLord\\"] = {
					["DreadLordAggroA.ogg"] = 00.70,
					["DreadLordAttackA.ogg"] = 00.89,
					["DreadLordAttackB.ogg"] = 01.23,
					["DreadLordAttackC.ogg"] = 00.83,
					["DreadLordAttackD.ogg"] = 00.99,
					["DreadLordDeathA.ogg"] = 04.57,
					["DreadLordSpellCastOmni.ogg"] = 01.11,
					["DreadLordWoundA.ogg"] = 00.62,
					["DreadLordWoundB.ogg"] = 00.63,
					["DreadLordWoundC.ogg"] = 00.75,
					["DreadLordWoundCritA.ogg"] = 00.78,
				},
				["Drekthar\\VO_"] = {
					["60_"] = {
						["DREKTHAR_"] = {
							["AttackCit_"] = {
								["01.ogg"] = 01.64,
								["02.ogg"] = 01.83,
								["03.ogg"] = 01.23,
								["04.ogg"] = 01.24,
								["05.ogg"] = 01.62,
							},
							["Attack_"] = {
								["01.ogg"] = 00.76,
								["010.ogg"] = 00.59,
								["02.ogg"] = 00.56,
								["03.ogg"] = 00.50,
								["04.ogg"] = 00.42,
								["05.ogg"] = 00.43,
								["06.ogg"] = 00.65,
								["07.ogg"] = 00.55,
								["08.ogg"] = 00.59,
								["09.ogg"] = 00.60,
							},
							["Death_"] = {
								["01.ogg"] = 02.71,
								["02.ogg"] = 02.72,
								["03.ogg"] = 02.61,
								["04.ogg"] = 02.52,
								["05.ogg"] = 02.98,
							},
							["FAREWELL_"] = {
								["01.ogg"] = 01.77,
								["02.ogg"] = 01.08,
								["03.ogg"] = 01.96,
								["04.ogg"] = 01.79,
								["05.ogg"] = 01.65,
							},
							["GREETING_"] = {
								["01.ogg"] = 02.32,
								["02.ogg"] = 01.07,
								["03.ogg"] = 02.38,
								["04.ogg"] = 01.16,
								["05.ogg"] = 01.99,
							},
							["PISSED_"] = {
								["01.ogg"] = 03.79,
								["02.ogg"] = 03.72,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 00.73,
								["02.ogg"] = 01.77,
								["03.ogg"] = 01.85,
								["04.ogg"] = 01.49,
								["05.ogg"] = 01.70,
							},
							["Wound_"] = {
								["01.ogg"] = 00.46,
								["010.ogg"] = 00.61,
								["02.ogg"] = 00.46,
								["03.ogg"] = 00.60,
								["04.ogg"] = 00.48,
								["05.ogg"] = 00.40,
								["06.ogg"] = 00.51,
								["07.ogg"] = 00.64,
								["08.ogg"] = 00.44,
								["09.ogg"] = 00.75,
							},
						},
						["FFR_"] = {
							["FARSEER_DREKTHAR_"] = {
								["01.ogg"] = 05.37,
								["02.ogg"] = 07.36,
								["03.ogg"] = 03.00,
								["04.ogg"] = 04.55,
								["05.ogg"] = 04.90,
								["06.ogg"] = 03.52,
								["07.ogg"] = 03.40,
								["08.ogg"] = 06.75,
								["09.ogg"] = 07.82,
								["10.ogg"] = 06.04,
								["11.ogg"] = 05.18,
								["12.ogg"] = 04.20,
							},
							["FINALE_"] = {
								["STAGE0_DREKTHAR_"] = {
									["01.ogg"] = 04.69,
									["02.ogg"] = 01.82,
								},
								["STAGE2_DREKTHAR_"] = {
									["01.ogg"] = 02.42,
									["02.ogg"] = 04.49,
								},
								["STAGE4_DREKTHAR_"] = {
									["01.ogg"] = 01.99,
									["02.ogg"] = 02.32,
								},
								["STAGE7_DREKTHAR_01.ogg"] = 01.67,
							},
							["FLIGHT_DREKTHAR_"] = {
								["01.ogg"] = 03.27,
								["02.ogg"] = 06.31,
								["04.ogg"] = 09.75,
								["05.ogg"] = 05.26,
								["06.ogg"] = 05.40,
								["07.ogg"] = 05.83,
								["08.ogg"] = 03.80,
								["09.ogg"] = 02.12,
							},
							["FURY_DREKTHAR_"] = {
								["02.ogg"] = 02.74,
								["02a.ogg"] = 01.79,
								["02b.ogg"] = 02.49,
								["02c.ogg"] = 02.45,
								["05.ogg"] = 09.58,
								["06.ogg"] = 03.70,
								["07.ogg"] = 11.35,
							},
							["LANDING_DREKTHAR_"] = {
								["01.ogg"] = 01.55,
								["02.ogg"] = 06.53,
								["03.ogg"] = 05.40,
								["07.ogg"] = 05.27,
								["08.ogg"] = 09.60,
							},
							["STONE_DREKTHAR_"] = {
								["01.ogg"] = 06.36,
								["02.ogg"] = 07.67,
								["03.ogg"] = 05.34,
							},
							["VOUCHING_DREKTHAR_"] = {
								["01.ogg"] = 05.25,
								["02.ogg"] = 05.38,
								["03.ogg"] = 07.89,
							},
							["WORGOL_DREKTHAR_"] = {
								["01.ogg"] = 03.84,
								["02.ogg"] = 04.57,
								["03.ogg"] = 03.11,
								["04.ogg"] = 04.06,
								["05.ogg"] = 04.86,
								["06.ogg"] = 05.09,
								["07.ogg"] = 04.31,
								["08.ogg"] = 07.19,
								["09.ogg"] = 08.35,
							},
							["GROMBOLASH_DREKTHAR_02.ogg"] = 06.10,
						},
						["NGD_"] = {
							["THRONE_"] = {
								["DREKTHAR_"] = {
									["01.ogg"] = 07.27,
									["02.ogg"] = 05.75,
								},
								["COMPLETE_DREKTHAR_01.ogg"] = 08.26,
							},
							["ATTUNE_DREKTHAR_01.ogg"] = 05.89,
							["CALLED_DREKTHAR_01.ogg"] = 04.36,
							["UNDERPALE_DREKTHAR_01.ogg"] = 03.86,
						},
						["TAN_DREKTHAR_"] = {
							["PRISONERS_"] = {
								["01.ogg"] = 07.29,
								["02.ogg"] = 06.71,
							},
							["ARENA_01.ogg"] = 01.08,
							["FIRE_01.ogg"] = 03.61,
							["IRON_01.ogg"] = 02.04,
							["RUN_01.ogg"] = 03.65,
						},
					},
				},
				["Druid of the Claw\\"] = {
					["DruidOfTheClawPissed2.ogg"] = 02.13,
					["DruidOfTheClawReady1.ogg"] = 02.48,
					["DruidOfTheClawWhat1.ogg"] = 02.07,
					["DruidOfTheClawWhat2.ogg"] = 01.45,
					["DruidOfTheClawYes1.ogg"] = 02.04,
					["DruidOfTheClawYes4.ogg"] = 00.98,
					["DruidOfTheClawYesAttack2.ogg"] = 01.48,
					["DruidOfTheClawYesAttack3.ogg"] = 02.34,
				},
				["DrunkenPandaren\\VO_"] = {
					["SB_DRUNKS_"] = {
						["LAUGH01.OGG"] = 08.39,
						["LAUGH02.OGG"] = 05.67,
						["LAUGH03.OGG"] = 06.56,
						["LAUGH04.OGG"] = 10.74,
						["LAUGH05.OGG"] = 07.68,
					},
				},
				["DrunkenPandaren1\\VO_"] = {
					["SB_"] = {
						["DRUNK01_"] = {
							["EVENT_"] = {
								["03A.OGG"] = 01.83,
								["03C.OGG"] = 02.76,
								["05A.OGG"] = 04.20,
								["07A.OGG"] = 05.01,
								["09A.OGG"] = 02.83,
								["09C.OGG"] = 02.73,
								["11A.OGG"] = 05.15,
								["13A.OGG"] = 03.02,
								["13C.OGG"] = 03.96,
								["15A.OGG"] = 03.84,
								["17A.OGG"] = 04.56,
								["17C.OGG"] = 03.44,
								["19A.OGG"] = 04.47,
								["19C.OGG"] = 02.79,
								["21A.OGG"] = 04.44,
								["21C.OGG"] = 03.55,
								["25A.OGG"] = 03.92,
								["27A.OGG"] = 05.99,
								["29A.OGG"] = 03.96,
								["29C.OGG"] = 02.08,
							},
							["LAUGH01.OGG"] = 08.05,
							["LAUGH02.OGG"] = 03.68,
							["LAUGH03.OGG"] = 05.07,
							["LAUGH04.OGG"] = 07.93,
						},
						["DRUNKALL_EVENT_02.OGG"] = 26.41,
					},
				},
				["DrunkenPandaren2\\VO_"] = {
					["SB_DRUNK02_"] = {
						["EVENT_"] = {
							["03B.OGG"] = 02.98,
							["05B.OGG"] = 03.09,
							["07B.OGG"] = 05.07,
							["09B.OGG"] = 02.06,
							["11B.OGG"] = 04.46,
							["13B.OGG"] = 01.98,
							["15B.OGG"] = 05.67,
							["17B.OGG"] = 02.04,
							["19B.OGG"] = 01.78,
							["21B.OGG"] = 01.82,
							["25B.OGG"] = 04.66,
							["27B.OGG"] = 04.24,
							["29B.OGG"] = 01.20,
						},
					},
				},
				["DrunkenPandaren3\\VO_"] = {
					["SB_"] = {
						["DRUNK03_"] = {
							["EVENT_"] = {
								["04A.OGG"] = 02.86,
								["04C.OGG"] = 01.64,
								["04E.OGG"] = 02.01,
								["06A.OGG"] = 02.71,
								["08A.OGG"] = 03.38,
								["10A.OGG"] = 02.39,
								["10C.OGG"] = 02.35,
								["12A.OGG"] = 02.05,
								["14A.OGG"] = 05.13,
								["14C.OGG"] = 02.36,
								["16A.OGG"] = 02.19,
								["18A.OGG"] = 04.62,
								["20A.OGG"] = 04.33,
								["20C.OGG"] = 05.86,
								["22A.OGG"] = 03.08,
								["22C.OGG"] = 04.13,
								["26A.OGG"] = 03.83,
								["26C.OGG"] = 02.81,
								["28A.OGG"] = 04.10,
								["28C.OGG"] = 01.27,
								["30A.OGG"] = 02.12,
								["30C.OGG"] = 02.80,
							},
							["LAUGH01.OGG"] = 02.55,
							["LAUGH02.OGG"] = 02.80,
							["LAUGH03.OGG"] = 02.87,
							["LAUGH04.OGG"] = 03.21,
							["LAUGH05.OGG"] = 02.23,
						},
						["DRUNKALL3_EVENT_02.OGG"] = 14.29,
					},
				},
				["DrunkenPandaren4\\VO_"] = {
					["SB_"] = {
						["DRUNK04_"] = {
							["EVENT_"] = {
								["04B.OGG"] = 01.59,
								["04D.OGG"] = 01.40,
								["06B.OGG"] = 03.08,
								["08B.OGG"] = 02.76,
								["10B.OGG"] = 02.10,
								["12B.OGG"] = 03.25,
								["14B.OGG"] = 00.54,
								["16B.OGG"] = 01.69,
								["18B.OGG"] = 04.81,
								["20B.OGG"] = 01.54,
								["22B.OGG"] = 01.73,
								["26B.OGG"] = 01.76,
								["28B.OGG"] = 02.00,
								["30B.OGG"] = 00.66,
							},
							["LAUGH01.OGG"] = 01.36,
							["LAUGH02.OGG"] = 03.11,
							["LAUGH03.OGG"] = 02.27,
							["LAUGH04.OGG"] = 03.75,
							["LAUGH05.OGG"] = 03.42,
							["LAUGH06.OGG"] = 04.49,
							["LAUGH07.OGG"] = 05.97,
						},
						["DRUNKALL4_EVENT_02.OGG"] = 27.16,
					},
				},
				["DrunkenPandaren5\\VO_"] = {
					["SB_DRUNK05_"] = {
						["EVENT_"] = {
							["01A.OGG"] = 07.44,
							["01B.OGG"] = 09.07,
							["23A.OGG"] = 05.29,
							["24A.OGG"] = 05.10,
						},
						["LAUGH01.OGG"] = 02.96,
						["LAUGH02.OGG"] = 05.25,
						["LAUGH03.OGG"] = 04.52,
						["LAUGH04.OGG"] = 10.52,
						["LAUGH05.OGG"] = 05.81,
						["LAUGH06.OGG"] = 06.61,
					},
				},
				["Dryad\\"] = {
					["DryadAggroA.ogg"] = 00.70,
					["DryadAttackA.ogg"] = 00.77,
					["DryadAttackB.ogg"] = 00.78,
					["DryadAttackC.ogg"] = 00.64,
					["DryadDeathA.ogg"] = 01.46,
					["DryadReady1.ogg"] = 02.22,
					["DryadStand2A.ogg"] = 02.60,
					["DryadWhat1.ogg"] = 00.52,
					["DryadWhat2.ogg"] = 00.80,
					["DryadWhat4.ogg"] = 01.33,
					["DryadWoundA.ogg"] = 01.00,
					["DryadWoundB.ogg"] = 00.99,
					["DryadWoundC.ogg"] = 00.78,
					["DryadWoundCrit.ogg"] = 01.09,
				},
				["Durotan\\VO_"] = {
					["60_"] = {
						["DUROTAN_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 02.40,
								["02.ogg"] = 01.35,
								["03.ogg"] = 01.34,
								["04.ogg"] = 01.42,
								["05.ogg"] = 01.02,
							},
							["Attack_"] = {
								["01.ogg"] = 00.85,
								["010.ogg"] = 00.99,
								["02.ogg"] = 00.80,
								["03.ogg"] = 00.64,
								["04.ogg"] = 00.63,
								["05.ogg"] = 00.76,
								["06.ogg"] = 00.84,
								["07.ogg"] = 00.74,
								["08.ogg"] = 01.14,
								["09.ogg"] = 00.94,
							},
							["Death_"] = {
								["01.ogg"] = 03.46,
								["02.ogg"] = 03.19,
								["03.ogg"] = 03.95,
								["04.ogg"] = 02.02,
								["05.ogg"] = 02.02,
							},
							["FAREWELL_"] = {
								["01.ogg"] = 03.50,
								["02.ogg"] = 01.64,
								["03.ogg"] = 01.89,
								["04.ogg"] = 02.78,
								["05.ogg"] = 02.32,
							},
							["GREETING_"] = {
								["01.ogg"] = 03.14,
								["02.ogg"] = 03.79,
								["03.ogg"] = 06.12,
								["04.ogg"] = 02.74,
								["05.ogg"] = 02.80,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.58,
								["02.ogg"] = 01.70,
								["03.ogg"] = 00.97,
								["04.ogg"] = 00.84,
								["05.ogg"] = 01.92,
							},
							["Wound_"] = {
								["01.ogg"] = 00.80,
								["010.ogg"] = 00.58,
								["02.ogg"] = 00.66,
								["03.ogg"] = 00.84,
								["04.ogg"] = 00.76,
								["05.ogg"] = 00.59,
								["06.ogg"] = 00.70,
								["07.ogg"] = 00.58,
								["08.ogg"] = 00.57,
								["09.ogg"] = 00.61,
							},
							["PISSED_01.ogg"] = 03.42,
						},
						["FFR_"] = {
							["BLADESPIRE_DUROTAN_"] = {
								["01.ogg"] = 05.77,
								["02.ogg"] = 03.17,
								["04.ogg"] = 02.38,
								["05.ogg"] = 03.12,
								["06.ogg"] = 03.14,
								["07.ogg"] = 01.91,
								["08.ogg"] = 01.49,
								["09.ogg"] = 06.60,
								["10.ogg"] = 04.95,
								["11.ogg"] = 02.80,
								["12.ogg"] = 05.19,
								["13.ogg"] = 07.98,
								["14.ogg"] = 06.11,
								["15.ogg"] = 05.43,
								["16.ogg"] = 04.25,
							},
							["DUEL_DUROTAN_"] = {
								["ALT_"] = {
									["01.ogg"] = 04.94,
									["02.ogg"] = 10.66,
								},
								["01.ogg"] = 06.96,
								["02.ogg"] = 05.82,
								["03.ogg"] = 07.28,
								["04.ogg"] = 01.91,
								["05.ogg"] = 12.20,
								["06.ogg"] = 14.66,
								["08.ogg"] = 04.90,
								["09.ogg"] = 03.83,
								["10.ogg"] = 07.55,
							},
							["FINALE_"] = {
								["STAGE0_DUROTAN_"] = {
									["01.ogg"] = 08.45,
									["02.ogg"] = 06.24,
									["03.ogg"] = 05.53,
									["04.ogg"] = 02.50,
								},
								["STAGE1_DUROTAN_"] = {
									["01.ogg"] = 05.01,
									["02.ogg"] = 02.90,
								},
								["STAGE4_DUROTAN_"] = {
									["01.ogg"] = 04.81,
									["02.ogg"] = 05.01,
								},
								["STAGE5_DUROTAN_"] = {
									["01.ogg"] = 03.17,
									["02.ogg"] = 04.21,
								},
								["STAGE7_DUROTAN_"] = {
									["01.ogg"] = 04.95,
									["02.ogg"] = 03.57,
									["03.ogg"] = 02.48,
									["04.ogg"] = 04.31,
								},
								["STAGE8_DUROTAN_"] = {
									["01.ogg"] = 01.94,
									["02.ogg"] = 05.73,
								},
								["CINEM_DUROTAN_03.ogg"] = 06.38,
								["STAGE2_DUROTAN_01.ogg"] = 04.90,
								["STAGE3_DUROTAN_01.ogg"] = 03.39,
								["STAGE6_DUROTAN_01.ogg"] = 03.19,
							},
							["GORMAUL_DUROTAN_"] = {
								["01.ogg"] = 03.40,
								["02.ogg"] = 02.75,
								["03.ogg"] = 05.81,
								["04.ogg"] = 05.55,
							},
							["THUNDERFALL_DUROTAN_"] = {
								["01.ogg"] = 01.94,
								["02.ogg"] = 04.62,
								["03.ogg"] = 01.16,
								["05.ogg"] = 02.64,
								["07.ogg"] = 04.40,
								["09.ogg"] = 04.53,
								["10.ogg"] = 01.19,
								["11.ogg"] = 04.43,
								["11b.ogg"] = 05.39,
								["12.ogg"] = 10.68,
								["12b.ogg"] = 05.99,
								["13.ogg"] = 09.31,
								["14.ogg"] = 07.57,
								["16.ogg"] = 09.88,
							},
							["TO_GORMAUL_"] = {
								["DUROTAN_"] = {
									["01.ogg"] = 04.63,
									["02.ogg"] = 03.89,
									["03.ogg"] = 07.60,
									["04.ogg"] = 06.37,
									["05.ogg"] = 03.99,
									["06.ogg"] = 13.86,
								},
							},
							["VOUCHING_DUROTAN_"] = {
								["01.ogg"] = 03.99,
								["02.ogg"] = 03.63,
								["04.ogg"] = 06.28,
								["04a.ogg"] = 02.54,
								["05.ogg"] = 04.33,
								["06.ogg"] = 06.62,
								["07.ogg"] = 09.39,
							},
							["FIND_GANAR_DUROTAN_01.ogg"] = 09.65,
						},
						["GORGROND_"] = {
							["BREAKER_"] = {
								["ACCEPT_HORDE.ogg"] = 06.76,
								["COMPLETE_HORDE.ogg"] = 06.51,
							},
							["HORDE_INTRO_02.ogg"] = 07.94,
							["SKULLS_MEETING_02.ogg"] = 10.66,
						},
						["NGD_"] = {
							["QUEST_DUROTAN_"] = {
								["01.ogg"] = 08.07,
								["02.ogg"] = 02.91,
							},
							["WARSONG_DUROTAN_"] = {
								["01.ogg"] = 02.12,
								["02.ogg"] = 01.24,
								["03.ogg"] = 03.03,
								["04.ogg"] = 03.58,
								["05.ogg"] = 02.14,
								["06.ogg"] = 04.46,
								["07.ogg"] = 04.28,
								["08.ogg"] = 04.06,
								["09.ogg"] = 03.19,
								["10.ogg"] = 01.64,
								["11.ogg"] = 01.51,
							},
							["JUSTICE_DUROTAN_01.ogg"] = 07.50,
						},
						["SHATTRATH_DUROTAN_"] = {
							["01.ogg"] = 01.74,
							["02.ogg"] = 01.93,
							["03.ogg"] = 01.60,
							["04.ogg"] = 01.57,
							["05.ogg"] = 02.71,
							["06.ogg"] = 01.59,
							["07.ogg"] = 00.89,
							["08.ogg"] = 00.88,
							["09.ogg"] = 03.98,
							["10.ogg"] = 03.73,
						},
						["TLD_"] = {
							["BEACH_DUROTAN_"] = {
								["01.ogg"] = 06.51,
								["02.ogg"] = 04.37,
							},
							["ORUNAI_DUROTAN_"] = {
								["01.ogg"] = 06.04,
								["02.ogg"] = 05.20,
								["03.ogg"] = 05.47,
								["04.ogg"] = 04.42,
							},
						},
					},
				},
				["DurotarScorpion\\PET_"] = {
					["DurotarScorpion_"] = {
						["Clickable_"] = {
							["01.ogg"] = 01.69,
							["02.ogg"] = 01.83,
							["03.ogg"] = 01.45,
							["04.ogg"] = 02.10,
							["05.ogg"] = 01.47,
							["06.ogg"] = 02.00,
							["07.ogg"] = 01.65,
							["08.ogg"] = 01.64,
							["09.ogg"] = 01.55,
							["10.ogg"] = 02.39,
						},
						["Clickable01.ogg"] = 02.14,
						["Clickable02.ogg"] = 02.67,
						["Clickable03.ogg"] = 02.68,
						["Clickable04.ogg"] = 03.01,
						["Clickable05.ogg"] = 02.14,
						["Clickable06.ogg"] = 02.24,
						["Clickable07.ogg"] = 01.97,
						["Clickable08.ogg"] = 02.36,
						["Clickable09.ogg"] = 02.30,
						["Clickable10.ogg"] = 03.56,
					},
				},
				["Durumu\\VO_"] = {
					["52_"] = {
						["DURUMU_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 02.75,
								["02.OGG"] = 03.05,
								["03.OGG"] = 03.10,
								["04.OGG"] = 03.46,
								["05.OGG"] = 03.80,
							},
							["Attack_"] = {
								["01.OGG"] = 01.88,
								["010.OGG"] = 01.90,
								["02.OGG"] = 02.16,
								["03.OGG"] = 02.03,
								["04.OGG"] = 02.01,
								["05.OGG"] = 01.43,
								["06.OGG"] = 02.32,
								["07.OGG"] = 02.39,
								["08.OGG"] = 01.99,
								["09.OGG"] = 01.91,
							},
							["Death_"] = {
								["01.OGG"] = 03.93,
								["02.OGG"] = 01.97,
								["03.OGG"] = 01.81,
								["04.OGG"] = 02.37,
								["05.OGG"] = 03.80,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.17,
								["02.OGG"] = 01.27,
								["03.OGG"] = 00.86,
								["04.OGG"] = 00.90,
								["05.OGG"] = 01.03,
							},
							["Wound_"] = {
								["01.OGG"] = 01.50,
								["02.OGG"] = 01.65,
								["03.OGG"] = 01.22,
								["04.OGG"] = 01.12,
								["05.OGG"] = 01.28,
								["06.OGG"] = 01.23,
								["07.OGG"] = 01.21,
								["08.OGG"] = 01.25,
								["09.OGG"] = 01.14,
							},
						},
						["TKR_DURUMU_"] = {
							["AGGRO.OGG"] = 07.70,
							["BERSERK.OGG"] = 11.15,
							["DEATH.OGG"] = 11.82,
							["INTRO.OGG"] = 20.18,
							["KILL01.OGG"] = 06.08,
							["KILL02.OGG"] = 09.18,
							["SPELL01.OGG"] = 05.84,
							["SPELL02.OGG"] = 08.87,
							["SPELL03.OGG"] = 07.97,
							["SPELL04.OGG"] = 06.06,
						},
					},
				},
				["DwarfFemaleGuardNPC\\"] = {
					["DwarfFemaleGuardNPCFarewell01.ogg"] = 01.04,
					["DwarfFemaleGuardNPCFarewell02.ogg"] = 01.19,
					["DwarfFemaleGuardNPCFarewell03.ogg"] = 01.51,
					["DwarfFemaleGuardNPCGreeting01.ogg"] = 00.82,
					["DwarfFemaleGuardNPCGreeting02.ogg"] = 01.10,
					["DwarfFemaleGuardNPCGreeting03.ogg"] = 01.17,
					["DwarfFemaleGuardNPCGreeting04.ogg"] = 00.64,
					["DwarfFemaleGuardNPCGreeting05.ogg"] = 00.80,
					["DwarfFemaleGuardNPCGreeting06.ogg"] = 00.87,
					["DwarfFemaleGuardNPCPissed01.ogg"] = 01.27,
					["DwarfFemaleGuardNPCPissed02.ogg"] = 01.11,
					["DwarfFemaleGuardNPCPissed03.ogg"] = 01.48,
					["DwarfFemaleGuardNPCPissed04.ogg"] = 01.33,
					["DwarfFemaleGuardNPCVendor01.ogg"] = 02.04,
					["DwarfFemaleGuardNPCVendor02.ogg"] = 01.54,
				},
				["DwarfFemaleMaternalNPC\\"] = {
					["DwarfFemaleMaternalNPCFarewell01.ogg"] = 00.70,
					["DwarfFemaleMaternalNPCFarewell02.ogg"] = 00.55,
					["DwarfFemaleMaternalNPCFarewell03.ogg"] = 01.58,
					["DwarfFemaleMaternalNPCFarewell04.ogg"] = 00.82,
					["DwarfFemaleMaternalNPCGreeting01.ogg"] = 00.42,
					["DwarfFemaleMaternalNPCGreeting02.ogg"] = 01.09,
					["DwarfFemaleMaternalNPCGreeting03.ogg"] = 01.02,
					["DwarfFemaleMaternalNPCGreeting04.ogg"] = 00.68,
					["DwarfFemaleMaternalNPCGreeting05.ogg"] = 00.57,
					["DwarfFemaleMaternalNPCPissed01.ogg"] = 00.58,
					["DwarfFemaleMaternalNPCPissed02.ogg"] = 01.10,
					["DwarfFemaleMaternalNPCPissed03.ogg"] = 01.63,
					["DwarfFemaleMaternalNPCPissed04.ogg"] = 01.39,
					["DwarfFemaleMaternalNPCVendor01.ogg"] = 02.12,
					["DwarfFemaleMaternalNPCVendor02.ogg"] = 01.44,
				},
				["DwarfFemaleYoungNPC\\"] = {
					["DwarfFemaleYoungNPCFarewell01.ogg"] = 01.07,
					["DwarfFemaleYoungNPCFarewell02.ogg"] = 00.88,
					["DwarfFemaleYoungNPCFarewell03.ogg"] = 00.85,
					["DwarfFemaleYoungNPCGreeting01.ogg"] = 00.93,
					["DwarfFemaleYoungNPCGreeting02.ogg"] = 01.08,
					["DwarfFemaleYoungNPCGreeting03.ogg"] = 01.08,
					["DwarfFemaleYoungNPCGreeting04.ogg"] = 01.51,
					["DwarfFemaleYoungNPCGreeting05.ogg"] = 00.73,
					["DwarfFemaleYoungNPCGreeting06.ogg"] = 00.56,
					["DwarfFemaleYoungNPCPissed01.ogg"] = 00.68,
					["DwarfFemaleYoungNPCPissed02.ogg"] = 01.40,
					["DwarfFemaleYoungNPCPissed03.ogg"] = 01.37,
					["DwarfFemaleYoungNPCVendor01.ogg"] = 02.18,
					["DwarfFemaleYoungNPCVendor02.ogg"] = 01.59,
				},
				["DwarfMaleGrimNPC\\"] = {
					["DwarfMaleGrimNPCFarewell01.ogg"] = 00.66,
					["DwarfMaleGrimNPCFarewell02.ogg"] = 01.09,
					["DwarfMaleGrimNPCFarewell03.ogg"] = 00.73,
					["DwarfMaleGrimNPCGreeting01.ogg"] = 00.52,
					["DwarfMaleGrimNPCGreeting02.ogg"] = 01.43,
					["DwarfMaleGrimNPCGreeting03.ogg"] = 01.14,
					["DwarfMaleGrimNPCGreeting04.ogg"] = 00.92,
					["DwarfMaleGrimNPCGreeting05.ogg"] = 00.73,
					["DwarfMaleGrimNPCGreeting06.ogg"] = 01.37,
					["DwarfMaleGrimNPCPissed01.ogg"] = 00.57,
					["DwarfMaleGrimNPCPissed02.ogg"] = 01.46,
					["DwarfMaleGrimNPCPissed03.ogg"] = 01.69,
					["DwarfMaleGrimNPCVendor01.ogg"] = 02.18,
					["DwarfMaleGrimNPCVendor02.ogg"] = 01.58,
				},
				["DwarfMaleGuardNPC\\"] = {
					["DwarfMaleGuardNPCFarewell01.ogg"] = 00.58,
					["DwarfMaleGuardNPCFarewell02.ogg"] = 01.10,
					["DwarfMaleGuardNPCFarewell03.ogg"] = 01.55,
					["DwarfMaleGuardNPCFarewell04.ogg"] = 01.06,
					["DwarfMaleGuardNPCGreeting01.ogg"] = 01.47,
					["DwarfMaleGuardNPCGreeting02.ogg"] = 01.27,
					["DwarfMaleGuardNPCGreeting03.ogg"] = 01.34,
					["DwarfMaleGuardNPCGreeting04.ogg"] = 00.47,
					["DwarfMaleGuardNPCGreeting05.ogg"] = 00.67,
					["DwarfMaleGuardNPCGreeting06.ogg"] = 01.07,
					["DwarfMaleGuardNPCPissed01.ogg"] = 01.31,
					["DwarfMaleGuardNPCPissed02.ogg"] = 01.10,
					["DwarfMaleGuardNPCPissed03.ogg"] = 01.28,
					["DwarfMaleGuardNPCVendor01.ogg"] = 02.20,
					["DwarfMaleGuardNPCVendor02.ogg"] = 01.94,
				},
				["DwarfMaleStandardNPC\\"] = {
					["DwarfMaleStandardNPCFarewell01.ogg"] = 01.27,
					["DwarfMaleStandardNPCFarewell02.ogg"] = 01.05,
					["DwarfMaleStandardNPCFarewell03.ogg"] = 01.03,
					["DwarfMaleStandardNPCFarewell04.ogg"] = 00.91,
					["DwarfMaleStandardNPCGreeting01.ogg"] = 00.81,
					["DwarfMaleStandardNPCGreeting02.ogg"] = 01.17,
					["DwarfMaleStandardNPCGreeting03.ogg"] = 01.25,
					["DwarfMaleStandardNPCGreeting04.ogg"] = 01.60,
					["DwarfMaleStandardNPCGreeting05.ogg"] = 01.40,
					["DwarfMaleStandardNPCGreeting06.ogg"] = 00.61,
					["DwarfMaleStandardNPCPissed01.ogg"] = 00.85,
					["DwarfMaleStandardNPCPissed02.ogg"] = 01.09,
					["DwarfMaleStandardNPCPissed03.ogg"] = 01.38,
					["DwarfMaleStandardNPCPissed04.ogg"] = 02.15,
					["DwarfMaleStandardNPCVendor01.ogg"] = 02.56,
					["DwarfMaleStandardNPCVendor02.ogg"] = 01.91,
				},
				["EadricThePure\\AC_"] = {
					["Eadric_"] = {
						["Aggro01.ogg"] = 01.86,
						["AttackHeavy01.ogg"] = 02.02,
						["AttackHeavy02.ogg"] = 02.48,
						["AttackHeavy03.ogg"] = 01.93,
						["AttackHeavy04.ogg"] = 01.67,
						["AttackHeavy05.ogg"] = 01.00,
						["AttackLight01.ogg"] = 00.93,
						["AttackLight02.ogg"] = 01.43,
						["AttackMedium01.ogg"] = 01.34,
						["AttackMedium02.ogg"] = 01.81,
						["Death01.ogg"] = 05.61,
						["Hammer01.ogg"] = 02.22,
						["Intro01.ogg"] = 04.22,
						["Slay01.ogg"] = 03.58,
						["Slay02.ogg"] = 05.17,
						["WoundCritical01.ogg"] = 01.56,
						["WoundCritical02.ogg"] = 02.45,
						["WoundCritical03.ogg"] = 02.08,
						["WoundHeavy01.ogg"] = 00.92,
						["WoundHeavy02.ogg"] = 01.03,
						["WoundHeavy03.ogg"] = 00.95,
						["WoundLight01.ogg"] = 00.33,
						["WoundLight02.ogg"] = 00.30,
						["WoundLight03.ogg"] = 00.66,
						["WoundLight04.ogg"] = 00.21,
						["WoundMedium01.ogg"] = 00.72,
						["WoundMedium02.ogg"] = 00.64,
						["WoundMedium03.ogg"] = 01.50,
						["WoundMedium04.ogg"] = 01.51,
						["WoundMedium05.ogg"] = 00.43,
						["WoundMedium06.ogg"] = 00.59,
					},
				},
				["EarthenFury\\Mon_"] = {
					["EarthenFury_"] = {
						["Aggro_"] = {
							["01.OGG"] = 01.72,
							["02.OGG"] = 01.64,
							["03.OGG"] = 02.30,
							["04.OGG"] = 01.13,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.47,
							["02.OGG"] = 01.26,
							["03.OGG"] = 01.67,
							["04.OGG"] = 01.37,
						},
						["Attack_"] = {
							["01.OGG"] = 01.74,
							["02.OGG"] = 01.66,
							["03.OGG"] = 01.98,
							["04.OGG"] = 01.67,
							["05.OGG"] = 01.37,
							["06.OGG"] = 01.63,
							["07.OGG"] = 01.85,
							["08.OGG"] = 01.77,
						},
						["BattleRoar_"] = {
							["01.OGG"] = 02.52,
							["02.OGG"] = 02.12,
							["03.OGG"] = 01.98,
						},
						["Death_"] = {
							["01.OGG"] = 02.76,
							["02.OGG"] = 02.05,
							["03.OGG"] = 01.23,
							["04.ogg"] = 02.15,
							["05.ogg"] = 01.97,
							["06.ogg"] = 01.75,
							["07.ogg"] = 02.82,
						},
						["Idle_"] = {
							["01.ogg"] = 02.99,
							["02.ogg"] = 01.42,
							["03.ogg"] = 01.10,
							["04.ogg"] = 02.15,
							["05.ogg"] = 01.96,
							["06.ogg"] = 01.15,
							["07.ogg"] = 02.26,
							["08.ogg"] = 01.81,
							["09.ogg"] = 01.71,
							["10.ogg"] = 02.26,
						},
						["Wound_"] = {
							["01.OGG"] = 00.97,
							["02.OGG"] = 01.17,
							["03.OGG"] = 01.07,
							["04.OGG"] = 00.99,
							["05.OGG"] = 00.97,
							["06.OGG"] = 01.15,
							["07.OGG"] = 01.46,
							["08.OGG"] = 01.47,
							["09.OGG"] = 01.13,
						},
					},
					["EarthFury_Tectus_"] = {
						["Death_"] = {
							["01.ogg"] = 05.07,
							["02.ogg"] = 04.96,
							["03.ogg"] = 05.16,
							["04.ogg"] = 04.27,
						},
					},
				},
				["EarthSpirit\\MON_"] = {
					["EarthSpirit_"] = {
						["Attack01.OGG"] = 01.79,
						["Attack02.OGG"] = 01.93,
						["Attack03.OGG"] = 02.05,
						["Attack04.OGG"] = 01.77,
						["Attack05.OGG"] = 02.15,
						["Attack06.OGG"] = 02.26,
						["Attack07.OGG"] = 02.30,
						["Attack08.OGG"] = 02.53,
						["Attack09.OGG"] = 02.11,
						["Attack10.OGG"] = 02.17,
						["AttackCrit01.OGG"] = 01.68,
						["AttackCrit02.OGG"] = 02.45,
						["AttackCrit03.OGG"] = 02.29,
						["AttackCrit04.OGG"] = 01.75,
						["AttackCrit05.OGG"] = 02.39,
						["Battleroar01.OGG"] = 03.09,
						["Death01.OGG"] = 05.34,
						["Death02.OGG"] = 05.51,
						["Death03.OGG"] = 05.59,
						["Death04.OGG"] = 05.19,
						["Death05.OGG"] = 05.68,
						["Wound01.OGG"] = 01.36,
						["Wound02.OGG"] = 01.74,
						["Wound03.OGG"] = 01.47,
						["Wound04.OGG"] = 01.46,
						["Wound05.OGG"] = 01.52,
						["Wound06.OGG"] = 01.69,
						["Wound07.OGG"] = 01.72,
						["Wound08.OGG"] = 01.77,
						["Wound09.OGG"] = 01.76,
						["Wound10.OGG"] = 01.61,
						["WoundCrit01.OGG"] = 02.00,
						["WoundCrit02.OGG"] = 02.14,
						["WoundCrit03.OGG"] = 02.10,
						["WoundCrit04.OGG"] = 01.90,
						["WoundCrit05.OGG"] = 01.79,
					},
				},
				["Ebbert\\VO_"] = {
					["QE_VJ_"] = {
						["Ebbert_"] = {
							["AllianceSub01.ogg"] = 04.93,
							["AllianceSub02.ogg"] = 01.99,
							["AllianceSub03.ogg"] = 03.45,
						},
					},
				},
				["EdwinVanCleef\\"] = {
					["EdwinVanCleefAggro01.ogg"] = 01.78,
					["EdwinVanCleefHealth01.ogg"] = 01.74,
					["EdwinVanCleefHealth02.ogg"] = 02.64,
					["EdwinVanCleefHealth03.ogg"] = 01.84,
					["EdwinVanCleefSlay01.ogg"] = 01.18,
				},
				["ElderAsani\\VO_"] = {
					["ELDERASANI_"] = {
						["ATTACKSCRIT_"] = {
							["01.OGG"] = 00.91,
							["02.OGG"] = 00.89,
							["03.OGG"] = 01.45,
							["04.OGG"] = 01.10,
							["05.OGG"] = 01.37,
						},
						["ATTACK_"] = {
							["01.OGG"] = 00.56,
							["02.OGG"] = 00.36,
							["03.OGG"] = 00.53,
							["04.OGG"] = 00.58,
							["05.OGG"] = 00.56,
							["06.OGG"] = 00.84,
							["07.OGG"] = 00.53,
							["08.OGG"] = 00.69,
							["09.OGG"] = 00.63,
							["10.OGG"] = 00.50,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 01.19,
							["02.OGG"] = 01.31,
							["03.OGG"] = 01.18,
							["04.OGG"] = 01.30,
							["05.OGG"] = 01.00,
						},
						["WOUND_"] = {
							["01.OGG"] = 00.35,
							["02.OGG"] = 00.31,
							["03.OGG"] = 00.62,
							["04.OGG"] = 00.36,
							["05.OGG"] = 00.73,
							["06.OGG"] = 00.42,
							["07.OGG"] = 00.62,
							["08.OGG"] = 00.48,
							["09.OGG"] = 00.78,
							["10.OGG"] = 00.86,
						},
					},
					["TES_ASANI_"] = {
						["EVENT_"] = {
							["01.OGG"] = 02.97,
							["02.OGG"] = 02.77,
							["03.OGG"] = 02.81,
							["03_ALT.OGG"] = 02.85,
						},
						["SLAY_"] = {
							["01.OGG"] = 03.62,
							["02.OGG"] = 02.17,
						},
						["AGGRO_01.OGG"] = 03.97,
						["DEATH_01.OGG"] = 04.78,
					},
				},
				["ElderBrightleaf\\UR_"] = {
					["Brightleaf_"] = {
						["Aggro01.ogg"] = 05.07,
						["Attack01.ogg"] = 00.62,
						["Attack02.ogg"] = 00.45,
						["Attack03.ogg"] = 00.45,
						["Attack04.ogg"] = 00.87,
						["Attack05.ogg"] = 01.48,
						["Death01.ogg"] = 05.42,
						["Slay01.ogg"] = 02.44,
						["Slay02.ogg"] = 04.68,
						["Wound01.ogg"] = 01.31,
						["Wound02.ogg"] = 01.63,
						["Wound03.ogg"] = 02.13,
						["Wound04.ogg"] = 01.32,
						["WoundCrit01.ogg"] = 00.72,
						["WoundCrit02.ogg"] = 01.11,
						["WoundCrit03.ogg"] = 01.44,
						["WoundCrit04.ogg"] = 00.94,
					},
				},
				["ElderIronbranch\\UR_"] = {
					["Ironbranch_"] = {
						["Aggro01.ogg"] = 04.05,
						["Attack01.ogg"] = 00.89,
						["Attack02.ogg"] = 00.91,
						["Attack03.ogg"] = 00.83,
						["Attack04.ogg"] = 01.27,
						["Attack05.ogg"] = 01.07,
						["Attack06.ogg"] = 01.52,
						["Attack07.ogg"] = 00.96,
						["Attack08.ogg"] = 01.29,
						["Attack09.ogg"] = 01.21,
						["Death01.ogg"] = 06.21,
						["Slay01.ogg"] = 04.66,
						["Slay02.ogg"] = 01.86,
						["Wound01.ogg"] = 00.91,
						["Wound02.ogg"] = 01.00,
						["Wound03.ogg"] = 01.10,
						["Wound04.ogg"] = 00.91,
						["Wound05.ogg"] = 01.19,
						["Wound06.ogg"] = 00.97,
						["WoundCrit01.ogg"] = 01.36,
						["WoundCrit02.ogg"] = 01.06,
						["WoundCrit03.ogg"] = 01.35,
						["WoundCrit04.ogg"] = 01.26,
					},
				},
				["ElderLusshan\\VO_"] = {
					["Jade_Forest_"] = {
						["Waterspeaking_Ceremony_"] = {
							["Elder_"] = {
								["01.OGG"] = 04.67,
								["02.OGG"] = 02.92,
								["03.OGG"] = 03.44,
								["04.OGG"] = 03.58,
								["05.OGG"] = 05.74,
								["06.OGG"] = 12.06,
							},
						},
					},
				},
				["ElderNadox\\AK_"] = {
					["Nadox_"] = {
						["Aggro.ogg"] = 03.45,
						["Attack01.ogg"] = 00.77,
						["Attack02.ogg"] = 00.70,
						["Attack03.ogg"] = 01.45,
						["Attack04.ogg"] = 00.71,
						["Attack05.ogg"] = 01.05,
						["Death01.ogg"] = 06.44,
						["Slay01.ogg"] = 02.88,
						["Slay02.ogg"] = 02.12,
						["Slay03.ogg"] = 02.58,
						["SummonEggSac01.ogg"] = 03.22,
						["SummonEggSac02.ogg"] = 04.59,
						["Wound01.ogg"] = 00.48,
						["Wound02.ogg"] = 00.55,
						["Wound03.ogg"] = 00.98,
						["Wound04.ogg"] = 00.79,
						["Wound05.ogg"] = 00.77,
						["WoundCrit01.ogg"] = 01.27,
						["WoundCrit02.ogg"] = 01.30,
						["WoundCrit03.ogg"] = 01.49,
					},
				},
				["ElderRegail\\VO_"] = {
					["ELDERREGAIl_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 00.60,
							["02.OGG"] = 00.81,
							["03.OGG"] = 00.72,
							["04.OGG"] = 00.69,
							["05.OGG"] = 00.96,
						},
						["ATTACK_"] = {
							["01.OGG"] = 00.48,
							["02.OGG"] = 00.58,
							["03.OGG"] = 00.66,
							["04.OGG"] = 00.62,
							["05.OGG"] = 00.59,
							["06.OGG"] = 00.68,
							["07.OGG"] = 00.47,
							["08.OGG"] = 00.60,
							["09.OGG"] = 00.89,
							["10.OGG"] = 00.52,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 00.52,
							["02.OGG"] = 00.62,
							["03.OGG"] = 00.56,
							["04.OGG"] = 00.45,
							["05.OGG"] = 00.45,
						},
						["WOUND_"] = {
							["01.OGG"] = 00.44,
							["02.OGG"] = 00.42,
							["03.OGG"] = 00.48,
							["04.OGG"] = 00.58,
							["05.OGG"] = 00.49,
							["06.OGG"] = 00.46,
							["07.OGG"] = 00.49,
							["08.OGG"] = 00.41,
							["09.OGG"] = 00.35,
							["10.OGG"] = 00.66,
						},
					},
					["TES_REGAIL_"] = {
						["EVENT_"] = {
							["01.OGG"] = 02.54,
							["02.OGG"] = 03.52,
							["03.OGG"] = 02.82,
						},
						["SLAY_"] = {
							["01.OGG"] = 03.56,
							["02.OGG"] = 02.23,
						},
						["AGGRO_01.OGG"] = 02.34,
						["DEATH_01.OGG"] = 05.38,
					},
				},
				["ElderStonebark\\UR_"] = {
					["Stonebark_"] = {
						["Aggro01.ogg"] = 03.54,
						["Attack01.ogg"] = 00.48,
						["Attack02.ogg"] = 00.43,
						["Attack03.ogg"] = 00.51,
						["Attack04.ogg"] = 00.95,
						["Attack05.ogg"] = 01.17,
						["Attack06.ogg"] = 01.45,
						["Attack07.ogg"] = 00.76,
						["Attack08.ogg"] = 00.77,
						["Attack09.ogg"] = 01.16,
						["Death01.ogg"] = 06.90,
						["Slay01.ogg"] = 03.63,
						["Slay02.ogg"] = 01.93,
						["Wound01.ogg"] = 00.53,
						["Wound02.ogg"] = 00.44,
						["Wound03.ogg"] = 00.56,
						["Wound04.ogg"] = 00.64,
						["Wound05.ogg"] = 00.52,
						["Wound06.ogg"] = 00.82,
						["Wound07.ogg"] = 01.05,
					},
				},
				["Elegon\\VO_"] = {
					["ELEGON_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 05.04,
							["02.OGG"] = 03.67,
							["03.OGG"] = 03.94,
							["04.OGG"] = 05.18,
							["05.OGG"] = 02.38,
							["06.OGG"] = 04.70,
						},
						["ATTACK_"] = {
							["01.OGG"] = 01.73,
							["02.OGG"] = 02.12,
							["03.OGG"] = 02.61,
							["04.OGG"] = 01.79,
							["05.OGG"] = 02.72,
							["06.OGG"] = 02.85,
							["07.OGG"] = 02.34,
							["08.OGG"] = 03.60,
							["09.OGG"] = 01.31,
							["10.OGG"] = 02.64,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 02.07,
							["02.OGG"] = 02.46,
							["03.OGG"] = 01.47,
							["04.OGG"] = 03.06,
							["05.OGG"] = 03.65,
							["06.OGG"] = 02.33,
							["07.OGG"] = 02.30,
						},
						["WOUND_"] = {
							["01.OGG"] = 01.34,
							["02.OGG"] = 01.25,
							["03.OGG"] = 01.84,
							["04.OGG"] = 01.54,
							["05.OGG"] = 01.21,
							["06.OGG"] = 01.89,
							["07.OGG"] = 01.45,
							["08.OGG"] = 01.29,
							["09.OGG"] = 01.23,
							["10.OGG"] = 01.30,
							["11.OGG"] = 02.15,
							["12.OGG"] = 01.33,
							["13.OGG"] = 01.63,
							["14.OGG"] = 01.46,
						},
					},
					["MV_ELEGON_"] = {
						["EVENT_PHASE_"] = {
							["A_TO_"] = {
								["B_"] = {
									["01.OGG"] = 03.72,
									["02.OGG"] = 07.05,
								},
							},
							["C_TO_"] = {
								["A_"] = {
									["01.OGG"] = 05.91,
									["02.OGG"] = 04.82,
									["03.OGG"] = 07.47,
								},
							},
							["ENRAGEHARD.OGG"] = 08.40,
							["ENRAGESOFT.OGG"] = 04.92,
							["B_TO_C_01.OGG"] = 09.33,
						},
						["INTRO_"] = {
							["01.OGG"] = 08.79,
							["02.OGG"] = 08.27,
						},
						["SLAY_"] = {
							["01.OGG"] = 03.74,
							["02.OGG"] = 04.29,
							["03.OGG"] = 05.03,
						},
						["AGGRO_01.OGG"] = 08.43,
						["DEATH_01.OGG"] = 14.82,
					},
				},
				["Elekk\\Elekk_"] = {
					["Aggro.ogg"] = 02.79,
					["Attack01.ogg"] = 00.96,
					["Attack02.ogg"] = 01.14,
					["Attack03.ogg"] = 01.04,
					["Attack04.ogg"] = 00.87,
					["Death.ogg"] = 03.15,
					["Wound01.ogg"] = 00.75,
					["Wound02.ogg"] = 00.68,
					["Wound03.ogg"] = 00.70,
					["Wound04.ogg"] = 00.75,
					["Crit_Wound.ogg"] = 01.44,
					["Pre_Aggro.ogg"] = 01.51,
				},
				["ElekkPet\\"] = {
					["ElekkClick1.ogg"] = 00.75,
					["ElekkClick2.ogg"] = 00.75,
					["ElekkClick3.ogg"] = 00.68,
					["ElekkPetRearUp.ogg"] = 00.70,
				},
				["ElekkPlushiePet\\Mon_"] = {
					["Elekk_Plushie_"] = {
						["PET_"] = {
							["Clickable_"] = {
								["01.ogg"] = 00.36,
								["02.ogg"] = 00.22,
								["03.ogg"] = 00.46,
								["04.ogg"] = 00.47,
								["05.ogg"] = 00.26,
								["06.ogg"] = 00.30,
								["07.ogg"] = 00.39,
							},
							["Death_"] = {
								["01.ogg"] = 00.67,
								["02.ogg"] = 00.74,
								["03.ogg"] = 00.54,
								["04.ogg"] = 00.83,
							},
							["Wound_"] = {
								["01.ogg"] = 00.35,
								["02.ogg"] = 00.19,
								["03.ogg"] = 00.48,
								["04.ogg"] = 00.15,
								["05.ogg"] = 00.22,
								["06.ogg"] = 00.34,
								["07.ogg"] = 00.22,
							},
						},
					},
				},
				["ElementalAir\\"] = {
					["AirElementalAggro.ogg"] = 01.90,
					["AirElementalAttackA.ogg"] = 01.74,
					["AirElementalAttackB.ogg"] = 01.77,
					["AirElementalAttackC.ogg"] = 02.24,
					["AirElementalDeath.ogg"] = 02.87,
					["AirElementalLoop.ogg"] = 04.98,
					["AirElementalPreAggro.ogg"] = 02.77,
					["AirElementalWoundA.ogg"] = 01.57,
					["AirElementalWoundB.ogg"] = 01.70,
					["AirElementalWoundC.ogg"] = 02.00,
					["AirElementalWoundCrit.ogg"] = 03.08,
				},
				["ElementalEarth\\"] = {
					["ElementalEarthLoop.ogg"] = 03.91,
					["mElementalEarthAggroA.ogg"] = 02.32,
					["mElementalEarthAttackA.ogg"] = 02.20,
					["mElementalEarthAttackB.ogg"] = 02.16,
					["mElementalEarthAttackC.ogg"] = 02.26,
					["mElementalEarthDeathA.ogg"] = 04.19,
					["mElementalEarthWoundA.ogg"] = 01.33,
					["mElementalEarthWoundB.ogg"] = 01.12,
					["mElementalEarthWoundC.ogg"] = 01.24,
				},
				["ElementalFire\\"] = {
					["FireElementalAggro.ogg"] = 01.91,
					["FireElementalAttackA.ogg"] = 01.82,
					["FireElementalAttackB.ogg"] = 02.08,
					["FireElementalAttackC.ogg"] = 01.87,
					["FireElementalDeathA.ogg"] = 02.43,
					["FireElementalLoop.ogg"] = 03.00,
					["FireElementalPreAggroA.ogg"] = 01.64,
					["FireElementalStandRare.ogg"] = 01.75,
					["FireElementalWoundA.ogg"] = 01.59,
					["FireElementalWoundB.ogg"] = 01.86,
					["FireElementalWoundC.ogg"] = 01.77,
					["FireElementalWoundCrit.ogg"] = 01.64,
				},
				["Elementalist1\\VO_"] = {
					["60_FR_"] = {
						["FURNACE_ELEMENTALIST_"] = {
							["INTRO.ogg"] = 02.01,
							["SPELL.ogg"] = 02.51,
						},
					},
				},
				["Elementalist2\\VO_"] = {
					["60_FR_"] = {
						["FURNACE_PA_"] = {
							["EVENT_"] = {
								["5.ogg"] = 02.89,
								["6.ogg"] = 07.50,
							},
						},
					},
				},
				["Elsia\\VO_"] = {
					["52_Elsia_"] = {
						["AdditionalLine_"] = {
							["01.OGG"] = 01.54,
							["02.OGG"] = 06.40,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.19,
							["02.OGG"] = 00.99,
							["03.OGG"] = 00.61,
							["04.OGG"] = 00.86,
							["05.OGG"] = 00.67,
						},
						["Attack_"] = {
							["01.OGG"] = 00.31,
							["010.OGG"] = 00.26,
							["02.OGG"] = 00.27,
							["03.OGG"] = 00.26,
							["04.OGG"] = 00.35,
							["05.OGG"] = 00.45,
							["06.OGG"] = 00.40,
							["07.OGG"] = 00.56,
							["08.OGG"] = 00.47,
							["09.OGG"] = 00.58,
						},
						["Death_"] = {
							["01.OGG"] = 02.69,
							["02.OGG"] = 03.06,
							["03.OGG"] = 02.50,
							["04.OGG"] = 03.53,
							["05.OGG"] = 02.81,
						},
						["Farewell_"] = {
							["01.OGG"] = 00.99,
							["02.OGG"] = 01.14,
							["03.OGG"] = 01.12,
							["04.OGG"] = 01.41,
						},
						["Greeting_"] = {
							["01.OGG"] = 01.41,
							["02.OGG"] = 01.49,
							["03.OGG"] = 01.92,
							["04.OGG"] = 01.81,
							["05.OGG"] = 02.19,
						},
						["Horde_"] = {
							["Blast_"] = {
								["01.OGG"] = 08.00,
								["02.OGG"] = 06.00,
								["03.OGG"] = 04.50,
								["04.OGG"] = 03.99,
								["05.OGG"] = 01.69,
								["06.OGG"] = 02.64,
								["07.OGG"] = 02.43,
								["08.OGG"] = 02.66,
								["09.OGG"] = 04.14,
								["10.OGG"] = 05.35,
							},
							["Courtyard_"] = {
								["01.OGG"] = 06.36,
								["01a.OGG"] = 01.32,
								["01b.OGG"] = 05.05,
								["02.OGG"] = 02.99,
								["03.OGG"] = 03.39,
								["04.OGG"] = 00.86,
							},
							["Intro_"] = {
								["01.OGG"] = 04.44,
								["02.OGG"] = 08.76,
								["03.OGG"] = 08.39,
								["04.OGG"] = 05.55,
								["05.OGG"] = 03.68,
								["06.OGG"] = 06.72,
								["07.OGG"] = 04.81,
								["08.OGG"] = 05.07,
								["09.OGG"] = 03.67,
							},
							["Landing_"] = {
								["01.OGG"] = 01.13,
								["02.OGG"] = 07.46,
								["03.OGG"] = 08.90,
								["04.OGG"] = 07.69,
								["05.OGG"] = 04.80,
								["06.OGG"] = 04.05,
								["07.OGG"] = 02.05,
								["08.OGG"] = 01.49,
								["09.OGG"] = 07.97,
								["10.OGG"] = 01.67,
								["11.OGG"] = 02.90,
								["12.OGG"] = 03.54,
								["13.OGG"] = 02.50,
								["14.OGG"] = 03.15,
								["15.OGG"] = 04.47,
								["16.OGG"] = 02.74,
								["17.OGG"] = 02.37,
								["18.OGG"] = 02.32,
								["19.OGG"] = 02.83,
								["20.OGG"] = 05.64,
								["21.OGG"] = 02.08,
								["22.OGG"] = 01.66,
								["23.OGG"] = 01.63,
								["24.OGG"] = 01.68,
								["25.OGG"] = 01.06,
							},
							["Mines_"] = {
								["01.OGG"] = 04.08,
								["02.OGG"] = 01.30,
								["03.OGG"] = 04.59,
								["04.OGG"] = 04.29,
								["05.OGG"] = 04.47,
							},
							["Shipyard_"] = {
								["01.OGG"] = 03.68,
								["02.OGG"] = 04.94,
								["03.OGG"] = 05.96,
							},
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.85,
							["02.OGG"] = 01.49,
							["03.OGG"] = 01.04,
							["04.OGG"] = 01.34,
							["05.OGG"] = 02.35,
						},
						["Wound_"] = {
							["01.OGG"] = 00.45,
							["010.OGG"] = 00.34,
							["02.OGG"] = 00.33,
							["03.OGG"] = 00.49,
							["04.OGG"] = 00.35,
							["05.OGG"] = 00.19,
							["06.OGG"] = 00.48,
							["07.OGG"] = 00.25,
							["08.OGG"] = 00.52,
							["09.OGG"] = 00.26,
						},
						["Pissed_01.OGG"] = 01.20,
					},
				},
				["ElwynnLamb\\PET_"] = {
					["ElwynnLamb_"] = {
						["Clickable01.ogg"] = 01.33,
						["Clickable02.ogg"] = 01.32,
						["Clickable03.ogg"] = 01.38,
						["Clickable04.ogg"] = 01.35,
						["Clickable05.ogg"] = 01.21,
						["Clickable06.ogg"] = 01.41,
						["Clickable07.ogg"] = 01.30,
						["Clickable08.ogg"] = 01.25,
					},
				},
				["Emissary\\Emissary_"] = {
					["W3ChpVIII02.ogg"] = 08.24,
					["W3ChpVIII04.ogg"] = 08.66,
				},
				["EnchantedLantern\\PET_"] = {
					["EnchantedLantern_"] = {
						["Click01.ogg"] = 02.74,
						["Click02.ogg"] = 02.63,
						["Click03.ogg"] = 02.49,
						["Click04.ogg"] = 02.92,
						["Click05.ogg"] = 02.92,
						["Click06.ogg"] = 02.88,
						["Click07.ogg"] = 02.90,
						["Click08.ogg"] = 02.72,
						["Click09.ogg"] = 02.65,
					},
				},
				["Ent\\"] = {
					["EntAggroA.ogg"] = 01.65,
					["EntAttackA.ogg"] = 01.27,
					["EntAttackB.ogg"] = 01.67,
					["EntAttackC.ogg"] = 01.54,
					["EntAttackD.ogg"] = 01.30,
					["EntDeathVar1.ogg"] = 01.33,
					["EntDeathVar2.ogg"] = 02.37,
					["EntPreAggroA.ogg"] = 01.03,
					["EntWoundA.ogg"] = 00.94,
					["EntWoundB.ogg"] = 01.71,
					["EntWoundC.ogg"] = 01.77,
					["EntWoundCrit.ogg"] = 01.70,
					["EntWoundD.ogg"] = 01.26,
				},
				["EpochHunter\\CAV_"] = {
					["Epoch_"] = {
						["Aggro01.ogg"] = 09.67,
						["Aggro02.ogg"] = 07.70,
						["Breath01.ogg"] = 06.93,
						["Breath02.ogg"] = 08.03,
						["Death01.ogg"] = 11.97,
						["Enter01.ogg"] = 09.74,
						["Enter02.ogg"] = 14.18,
						["Enter03.ogg"] = 29.10,
						["Slay01.ogg"] = 08.26,
						["Slay02.ogg"] = 12.53,
					},
				},
				["Eredar\\"] = {
					["EredarAggro.ogg"] = 04.35,
					["EredarAttacD.ogg"] = 01.74,
					["EredarAttackA.ogg"] = 01.69,
					["EredarAttackB.ogg"] = 01.76,
					["EredarAttackC.ogg"] = 01.64,
					["EredarAttackE.ogg"] = 01.80,
					["EredarDeath.ogg"] = 04.02,
					["EredarPreAggro.ogg"] = 01.46,
					["EredarWoundA.ogg"] = 01.50,
					["EredarWoundB.ogg"] = 01.16,
					["EredarWoundC.ogg"] = 01.57,
					["EredarWoundCrit.ogg"] = 01.99,
					["EredarWoundD.ogg"] = 01.70,
				},
				["Erekem\\VH_"] = {
					["Erekem_"] = {
						["AddKilled.ogg"] = 07.84,
						["Aggro.ogg"] = 06.44,
						["Attack01.ogg"] = 00.94,
						["Attack02.ogg"] = 00.77,
						["Attack03.ogg"] = 00.77,
						["Attack04.ogg"] = 01.49,
						["Attack05.ogg"] = 01.13,
						["BothAddsDead.ogg"] = 11.96,
						["Death.ogg"] = 04.03,
						["Slay01.ogg"] = 01.16,
						["Slay02.ogg"] = 05.80,
						["Slay03.ogg"] = 05.29,
						["Spawn.ogg"] = 10.45,
						["Wound01.ogg"] = 00.68,
						["Wound02.ogg"] = 00.77,
						["Wound03.ogg"] = 00.81,
						["Wound04.ogg"] = 00.94,
						["Wound05.ogg"] = 00.90,
						["Wound06.ogg"] = 01.07,
						["Wound07.ogg"] = 01.07,
						["WoundCrit01.ogg"] = 01.54,
						["WoundCrit02.ogg"] = 01.96,
					},
				},
				["Ertan\\VO_"] = {
					["VP_Ertan_"] = {
						["Attack01.ogg"] = 00.65,
						["Attack02.ogg"] = 00.68,
						["Attack03.ogg"] = 00.76,
						["Attack04.ogg"] = 00.69,
						["Attack05.ogg"] = 00.77,
						["Attack06.ogg"] = 00.88,
						["Attack07.ogg"] = 00.66,
						["Attack08.ogg"] = 00.71,
						["Attack09.ogg"] = 01.12,
						["Attack10.ogg"] = 00.91,
						["AttackCritical01.ogg"] = 00.86,
						["AttackCritical02.ogg"] = 00.98,
						["AttackCritical03.ogg"] = 01.01,
						["AttackCritical04.ogg"] = 01.18,
						["Event01.ogg"] = 08.67,
						["Event02.ogg"] = 02.65,
						["Event03.ogg"] = 03.03,
						["Event04.ogg"] = 06.73,
						["Wound01.ogg"] = 00.59,
						["Wound02.ogg"] = 00.60,
						["Wound03.ogg"] = 00.70,
						["Wound04.ogg"] = 00.68,
						["Wound05.ogg"] = 00.60,
						["Wound06.ogg"] = 00.65,
						["Wound07.ogg"] = 00.64,
						["Wound08.ogg"] = 00.75,
						["Wound09.ogg"] = 00.69,
						["WoundCritical01.ogg"] = 00.84,
						["WoundCritical02.ogg"] = 00.94,
						["WoundCritical03.ogg"] = 01.25,
						["WoundCritical04.ogg"] = 01.14,
						["WoundCritical05.ogg"] = 01.40,
					},
				},
				["Erudax\\VO_"] = {
					["GB_Erudax_"] = {
						["Attack01.ogg"] = 00.98,
						["Attack02.ogg"] = 00.97,
						["Attack03.ogg"] = 00.89,
						["Attack04.ogg"] = 00.85,
						["Attack05.ogg"] = 00.91,
						["Attack06.ogg"] = 00.96,
						["Attack07.ogg"] = 00.95,
						["Attack08.ogg"] = 00.88,
						["Attack09.ogg"] = 01.08,
						["Attack10.ogg"] = 01.23,
						["AttackCrit01.ogg"] = 01.39,
						["AttackCrit02.ogg"] = 01.63,
						["AttackCrit03.ogg"] = 01.08,
						["AttackCrit04.ogg"] = 01.82,
						["AttackCrit05.ogg"] = 01.32,
						["AttackCrit06.ogg"] = 01.48,
						["AttackCrit07.ogg"] = 01.64,
						["AttackCrit08.ogg"] = 01.78,
						["AttackCrit09.ogg"] = 01.25,
						["Death01.ogg"] = 02.81,
						["Death02.ogg"] = 02.83,
						["Death03.ogg"] = 02.08,
						["Death04.ogg"] = 02.62,
						["Death05.ogg"] = 03.46,
						["Event01.ogg"] = 03.05,
						["Event02.ogg"] = 04.44,
						["Event03.ogg"] = 03.45,
						["Event04.ogg"] = 05.68,
						["Event05.ogg"] = 04.01,
						["Event06.ogg"] = 03.50,
						["Wound01.ogg"] = 01.32,
						["Wound02.ogg"] = 01.06,
						["Wound03.ogg"] = 01.62,
						["Wound04.ogg"] = 01.37,
						["Wound05.ogg"] = 01.17,
						["Wound06.ogg"] = 01.26,
						["Wound07.ogg"] = 01.41,
						["Wound08.ogg"] = 00.83,
						["Wound09.ogg"] = 01.01,
						["Wound10.ogg"] = 01.16,
						["WoundCrit01.ogg"] = 01.02,
						["WoundCrit02.ogg"] = 01.59,
						["WoundCrit03.ogg"] = 01.61,
						["WoundCrit04.ogg"] = 01.59,
						["WoundCrit05.ogg"] = 01.28,
					},
				},
				["Erunak\\VO_"] = {
					["Erunak_"] = {
						["AllSub.ogg"] = 04.92,
						["HordeSub.ogg"] = 04.67,
						["Neptulon01.ogg"] = 02.88,
						["Neptulon02.ogg"] = 02.00,
						["Neptulon03.ogg"] = 00.93,
						["Neptulon04.ogg"] = 03.57,
						["Neptulon05.ogg"] = 03.64,
						["Neptulon06.ogg"] = 03.00,
						["Neptulon07.ogg"] = 02.38,
						["Neptulon08.ogg"] = 03.71,
						["Neptulon09.ogg"] = 02.47,
						["Neptulon10.ogg"] = 01.99,
						["Neptulon11.ogg"] = 04.45,
						["Rescue01.ogg"] = 04.27,
						["Rescue02.ogg"] = 03.97,
						["Rescue03.ogg"] = 03.28,
						["Sub01.ogg"] = 02.29,
						["Sub02.ogg"] = 03.80,
						["Sub03.ogg"] = 02.61,
						["Sub04.ogg"] = 03.58,
						["Sub05.ogg"] = 03.92,
						["Sub06.ogg"] = 01.66,
						["Sub07.ogg"] = 01.69,
					},
					["TT_"] = {
						["Erunak_"] = {
							["Attack01.ogg"] = 00.90,
							["Attack02.ogg"] = 01.52,
							["Attack03.ogg"] = 01.27,
							["Attack04.ogg"] = 00.63,
							["Attack05.ogg"] = 00.66,
							["Attack06.ogg"] = 00.71,
							["Attack07.ogg"] = 00.66,
							["Attack08.ogg"] = 00.67,
							["Attack09.ogg"] = 00.69,
							["AttackCritical01.ogg"] = 01.83,
							["AttackCritical02.ogg"] = 01.00,
							["AttackCritical03.ogg"] = 01.18,
							["AttackCritical04.ogg"] = 01.43,
							["AttackCritical05.ogg"] = 01.20,
							["Death01.ogg"] = 01.73,
							["Death02.ogg"] = 01.54,
							["Death03.ogg"] = 01.51,
							["Death04.ogg"] = 01.36,
							["Death05.ogg"] = 01.72,
							["Wound01.ogg"] = 01.06,
							["Wound02.ogg"] = 01.10,
							["Wound03.ogg"] = 00.93,
							["Wound04.ogg"] = 01.16,
							["Wound05.ogg"] = 01.18,
							["Wound06.ogg"] = 01.04,
							["Wound07.ogg"] = 01.06,
							["Wound08.ogg"] = 00.99,
							["Wound09.ogg"] = 00.80,
							["WoundCritical01.ogg"] = 01.04,
							["WoundCritical02.ogg"] = 01.32,
							["WoundCritical03.ogg"] = 01.15,
							["WoundCritical04.ogg"] = 00.99,
							["WoundCritical05.ogg"] = 01.19,
						},
						["_Erunak_"] = {
							["Freed01.ogg"] = 08.16,
							["PostFight01.ogg"] = 09.30,
						},
					},
				},
				["EssenceOfAnger\\BLCKTMPLE_"] = {
					["EssnceAngr_"] = {
						["Attack01.ogg"] = 01.75,
						["Attack02.ogg"] = 01.61,
						["Attack03.ogg"] = 01.78,
						["Attack04.ogg"] = 01.74,
						["Attack05.ogg"] = 01.54,
						["Freed01.ogg"] = 03.61,
						["Freed02.ogg"] = 03.40,
						["PlyrWin01.ogg"] = 02.80,
						["Recap01.ogg"] = 04.63,
						["Slay01.ogg"] = 05.33,
						["Slay02.ogg"] = 03.54,
						["Special01.ogg"] = 02.54,
						["Wound01.ogg"] = 01.73,
						["Wound02.ogg"] = 01.71,
						["Wound03.ogg"] = 01.85,
						["Wound04.ogg"] = 01.57,
					},
				},
				["EssenceOfDesire\\BLCKTMPLE_"] = {
					["EssnceDesir_"] = {
						["Freed01.ogg"] = 06.65,
						["PlyrWins01.ogg"] = 03.57,
						["Recap01.ogg"] = 03.49,
						["Slay01.ogg"] = 03.53,
						["Slay02.ogg"] = 05.63,
						["Slay03.ogg"] = 04.92,
						["Special01.ogg"] = 04.14,
					},
				},
				["EssenceOfGrief\\BLCKTMPLE_"] = {
					["EssnceGrf_"] = {
						["Aggro02.ogg"] = 04.25,
						["Freed01.ogg"] = 05.56,
						["PlyrWin01.ogg"] = 03.46,
						["Recap01.ogg"] = 03.12,
						["Slay01.ogg"] = 03.57,
						["Slay02.ogg"] = 03.27,
						["Slay03.ogg"] = 04.18,
					},
				},
				["EtherealServiceNPC1\\VO_"] = {
					["ETHEREALNPC1GREETING01.OGG"] = 03.29,
					["ETHEREALNPC1GREETING02.OGG"] = 03.31,
					["ETHEREALNPC1GREETING03.OGG"] = 04.32,
					["ETHEREALNPC1GREETING04.OGG"] = 04.87,
					["ETHEREALNPC1GREETING05.OGG"] = 03.19,
					["ETHEREALNPC1PISSED01.OGG"] = 04.96,
					["ETHEREALNPC1PISSED02.OGG"] = 04.17,
					["ETHEREALNPC1PISSED03.OGG"] = 06.45,
				},
				["EtherealServiceNPC2\\VO_"] = {
					["ETHEREALNPC2GREETING01.OGG"] = 03.60,
					["ETHEREALNPC2GREETING02.OGG"] = 03.80,
					["ETHEREALNPC2GREETING03.OGG"] = 04.48,
					["ETHEREALNPC2GREETING04.OGG"] = 05.16,
					["ETHEREALNPC2GREETING05.OGG"] = 03.81,
					["ETHEREALNPC2PISSED01.OGG"] = 04.94,
					["ETHEREALNPC2PISSED02.OGG"] = 03.91,
					["ETHEREALNPC2PISSED03.OGG"] = 05.35,
				},
				["EtherealServiceNPC3\\VO_"] = {
					["ETHEREALNPC3GREETING01.OGG"] = 03.72,
					["ETHEREALNPC3GREETING02.OGG"] = 03.58,
					["ETHEREALNPC3GREETING03.OGG"] = 05.78,
					["ETHEREALNPC3GREETING04.OGG"] = 05.95,
					["ETHEREALNPC3GREETING05.OGG"] = 04.10,
					["ETHEREALNPC3PISSED01.OGG"] = 05.21,
					["ETHEREALNPC3PISSED02.OGG"] = 04.12,
					["ETHEREALNPC3PISSED03.OGG"] = 08.11,
				},
				["EtherealTrader\\PET_"] = {
					["EtherealTrader_Clickable_"] = {
						["01.ogg"] = 02.66,
						["02.ogg"] = 02.40,
						["03.ogg"] = 01.77,
						["04.ogg"] = 01.92,
						["05.ogg"] = 02.42,
						["06.ogg"] = 02.47,
						["07.ogg"] = 02.35,
						["08.ogg"] = 02.17,
						["09.ogg"] = 02.24,
					},
				},
				["Etherial\\"] = {
					["EthrealAggro.ogg"] = 01.95,
					["EthrealAttackA.ogg"] = 02.32,
					["EthrealAttackB.ogg"] = 02.22,
					["EthrealAttackC.ogg"] = 02.21,
					["EthrealAttackD.ogg"] = 02.46,
					["EthrealDeath.ogg"] = 03.29,
					["EthrealLoop.ogg"] = 04.97,
					["EthrealWoundA.ogg"] = 02.41,
					["EthrealWoundB.ogg"] = 02.17,
					["EthrealWoundC.ogg"] = 02.11,
					["EthrealWoundCrit.ogg"] = 02.85,
				},
				["Ettin\\Ettin_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.29,
						["02.ogg"] = 01.49,
						["03.ogg"] = 01.17,
						["04.ogg"] = 01.32,
						["05.ogg"] = 01.19,
						["06.ogg"] = 01.21,
						["07.ogg"] = 01.62,
						["08.ogg"] = 01.41,
						["09.ogg"] = 01.58,
						["10.ogg"] = 01.70,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 01.01,
						["02.ogg"] = 01.10,
						["03.ogg"] = 00.81,
						["04.ogg"] = 00.76,
						["05.ogg"] = 01.09,
						["06.ogg"] = 00.72,
						["07.ogg"] = 00.75,
						["08.ogg"] = 00.99,
						["09.ogg"] = 00.66,
						["10.ogg"] = 00.83,
					},
					["Attack_"] = {
						["01.ogg"] = 00.88,
						["02.ogg"] = 00.77,
						["03.ogg"] = 00.93,
						["04.ogg"] = 00.72,
						["05.ogg"] = 00.79,
						["06.ogg"] = 00.86,
						["07.ogg"] = 00.86,
						["08.ogg"] = 00.82,
						["09.ogg"] = 00.89,
						["10.ogg"] = 00.83,
					},
					["Death_"] = {
						["01.ogg"] = 02.29,
						["02.ogg"] = 02.41,
						["03.ogg"] = 03.02,
						["04.ogg"] = 02.74,
						["05.ogg"] = 02.82,
						["06.ogg"] = 02.83,
						["07.ogg"] = 04.64,
						["08.ogg"] = 02.12,
						["09.ogg"] = 03.74,
						["10.ogg"] = 02.44,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.16,
						["02.ogg"] = 01.17,
						["03.ogg"] = 01.25,
						["04.ogg"] = 01.26,
						["05.ogg"] = 00.94,
						["06.ogg"] = 01.10,
						["07.ogg"] = 00.82,
						["08.ogg"] = 01.02,
						["09.ogg"] = 01.33,
						["10.ogg"] = 00.98,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.06,
						["02.ogg"] = 00.83,
						["03.ogg"] = 00.80,
						["04.ogg"] = 00.69,
						["05.ogg"] = 00.91,
						["06.ogg"] = 01.00,
						["07.ogg"] = 00.91,
						["08.ogg"] = 01.02,
						["09.ogg"] = 00.89,
						["10.ogg"] = 00.88,
					},
					["Wound_"] = {
						["01.ogg"] = 00.57,
						["02.ogg"] = 00.81,
						["03.ogg"] = 00.81,
						["04.ogg"] = 00.64,
						["05.ogg"] = 00.70,
						["06.ogg"] = 00.73,
						["07.ogg"] = 00.73,
						["08.ogg"] = 00.66,
						["09.ogg"] = 00.81,
						["10.ogg"] = 00.63,
					},
				},
				["ExarchMaladaar\\"] = {
					["Auch_Malad_"] = {
						["Aggro01.ogg"] = 02.01,
						["Aggro02.ogg"] = 02.19,
						["Aggro03.ogg"] = 02.72,
						["Avatar01.ogg"] = 05.85,
						["Death01.ogg"] = 05.61,
						["Intro01.ogg"] = 15.69,
						["Roar01.ogg"] = 02.18,
						["Slay01.ogg"] = 03.81,
						["Slay02.ogg"] = 07.15,
						["SoulCleave01.ogg"] = 03.04,
					},
					["VO_60_"] = {
						["MALADAAR_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.54,
								["02.ogg"] = 00.87,
								["03.ogg"] = 00.84,
								["04.ogg"] = 01.67,
								["05.ogg"] = 00.76,
							},
							["Attack_"] = {
								["01.ogg"] = 00.57,
								["02.ogg"] = 00.54,
								["03.ogg"] = 00.45,
								["04.ogg"] = 00.45,
								["05.ogg"] = 00.57,
								["06.ogg"] = 00.45,
								["07.ogg"] = 00.41,
								["08.ogg"] = 00.47,
								["09.ogg"] = 00.45,
							},
							["CROWNING_"] = {
								["01.ogg"] = 04.75,
								["02.ogg"] = 08.30,
								["03.ogg"] = 08.03,
								["04.ogg"] = 03.47,
								["05.ogg"] = 07.82,
								["06.ogg"] = 09.46,
								["07.ogg"] = 10.18,
								["08.ogg"] = 02.32,
								["09.ogg"] = 02.31,
							},
							["Death_"] = {
								["01.ogg"] = 04.36,
								["02.ogg"] = 03.22,
								["03.ogg"] = 03.25,
								["04.ogg"] = 02.73,
								["05.ogg"] = 02.35,
							},
							["FAREWELL_"] = {
								["01.ogg"] = 02.21,
								["02.ogg"] = 02.11,
								["03.ogg"] = 02.03,
								["04.ogg"] = 01.03,
							},
							["GREETING_"] = {
								["01.ogg"] = 02.33,
								["02.ogg"] = 02.59,
								["03.ogg"] = 03.29,
								["04.ogg"] = 04.01,
							},
							["SPELL_"] = {
								["01.ogg"] = 04.32,
								["02.ogg"] = 03.07,
								["03.ogg"] = 03.57,
							},
							["TRIAL_"] = {
								["01.ogg"] = 03.59,
								["02.ogg"] = 04.20,
								["03.ogg"] = 01.33,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.38,
								["02.ogg"] = 01.01,
								["03.ogg"] = 00.94,
								["04.ogg"] = 01.36,
								["05.ogg"] = 00.90,
							},
							["Wound_"] = {
								["01.ogg"] = 00.31,
								["010.ogg"] = 00.82,
								["02.ogg"] = 00.45,
								["03.ogg"] = 00.50,
								["04.ogg"] = 00.53,
								["05.ogg"] = 00.50,
								["06.ogg"] = 00.63,
								["07.ogg"] = 00.85,
								["08.ogg"] = 00.54,
								["09.ogg"] = 00.58,
							},
							["BECOME_01.ogg"] = 01.93,
						},
						["SMV_"] = {
							["EXCORCISM_MALADAAR_"] = {
								["01.ogg"] = 04.23,
								["02.ogg"] = 11.12,
								["03.ogg"] = 05.54,
								["04.ogg"] = 07.14,
								["05.ogg"] = 04.02,
								["06.ogg"] = 04.74,
								["07.ogg"] = 04.70,
								["08.ogg"] = 02.45,
								["09.ogg"] = 02.18,
								["10.ogg"] = 04.57,
								["11.ogg"] = 03.46,
								["12.ogg"] = 05.99,
							},
							["MURDER_MALADAAR_"] = {
								["01.ogg"] = 02.71,
								["02.ogg"] = 04.25,
								["03.ogg"] = 03.28,
							},
							["XANDROS_MALADAAR_"] = {
								["03.ogg"] = 02.79,
								["04.ogg"] = 05.44,
								["05.ogg"] = 02.59,
							},
						},
						["TAN_MALADAAR_"] = {
							["ARENA_"] = {
								["01-01.ogg"] = 03.63,
								["01.ogg"] = 03.68,
							},
							["FIRE_"] = {
								["01.ogg"] = 03.88,
								["02.ogg"] = 04.68,
							},
							["PRISONERS_"] = {
								["01.ogg"] = 08.08,
								["02.ogg"] = 08.58,
							},
							["CAVE_01.ogg"] = 00.82,
							["RETURN_01.ogg"] = 07.54,
							["RUN_01.ogg"] = 00.98,
						},
						["TLD_"] = {
							["EXARCH_MALADAAR_"] = {
								["01.ogg"] = 06.47,
								["02.ogg"] = 04.87,
								["03.ogg"] = 06.83,
								["04.ogg"] = 04.02,
							},
							["XANDROS_MALADAAR_"] = {
								["01.ogg"] = 04.15,
								["02.ogg"] = 03.18,
							},
							["RET_MALADAAR_01.ogg"] = 06.80,
						},
					},
				},
				["ExecutionerGore\\VO_"] = {
					["60_BFD_"] = {
						["GORE_"] = {
							["EVENT_"] = {
								["01.ogg"] = 06.23,
								["02.ogg"] = 05.63,
								["03.ogg"] = 05.88,
								["04.ogg"] = 08.44,
							},
							["AGGRO.ogg"] = 07.56,
							["DEATH.ogg"] = 10.32,
						},
					},
				},
				["ExecutionerOrcMale\\Auch_"] = {
					["Exec_"] = {
						["Generic01.ogg"] = 01.76,
						["Generic02.ogg"] = 01.61,
						["Generic03.ogg"] = 01.95,
					},
				},
				["Executus\\"] = {
					["ExecutusAggro01.ogg"] = 05.78,
					["ExecutusArrival02.ogg"] = 07.10,
					["ExecutusArrival04.ogg"] = 08.28,
					["ExecutusDefeat01.ogg"] = 32.00,
					["ExecutusSlay01.ogg"] = 02.10,
					["ExecutusSpawn01.ogg"] = 07.29,
					["ExecutusSpecialAttack01.ogg"] = 05.13,
					["ExecutusSummon01.ogg"] = 12.91,
				},
				["FacelessMount\\FacelessMount_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.59,
						["02.ogg"] = 01.43,
						["03.ogg"] = 01.62,
						["04.ogg"] = 01.69,
						["05.ogg"] = 01.72,
						["06.ogg"] = 01.68,
						["07.ogg"] = 02.09,
						["08.ogg"] = 02.07,
						["09.ogg"] = 02.24,
						["10.ogg"] = 01.88,
					},
					["AttackCritical_"] = {
						["01.ogg"] = 01.21,
						["02.ogg"] = 01.86,
						["03.ogg"] = 01.84,
						["04.ogg"] = 01.68,
						["05.ogg"] = 01.31,
					},
					["Attack_"] = {
						["01.ogg"] = 01.20,
						["02.ogg"] = 01.46,
						["03.ogg"] = 01.10,
						["04.ogg"] = 01.45,
						["05.ogg"] = 01.21,
						["06.ogg"] = 01.04,
						["07.ogg"] = 01.21,
						["08.ogg"] = 01.24,
						["09.ogg"] = 01.36,
						["10.ogg"] = 01.30,
					},
					["Death_"] = {
						["01.ogg"] = 02.87,
						["02.ogg"] = 02.69,
						["03.ogg"] = 02.53,
						["04.ogg"] = 02.35,
						["05.ogg"] = 02.24,
						["06.ogg"] = 03.31,
						["07.ogg"] = 02.28,
						["08.ogg"] = 02.50,
						["09.ogg"] = 02.24,
						["10.ogg"] = 02.58,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.88,
						["02.ogg"] = 01.55,
						["03.ogg"] = 02.15,
						["04.ogg"] = 01.46,
						["05.ogg"] = 02.44,
					},
					["WoundCritical_"] = {
						["01.ogg"] = 01.13,
						["02.ogg"] = 00.96,
						["03.ogg"] = 01.47,
						["04.ogg"] = 01.23,
						["05.ogg"] = 01.52,
					},
					["Wound_"] = {
						["01.ogg"] = 01.32,
						["02.ogg"] = 01.15,
						["03.ogg"] = 01.13,
						["04.ogg"] = 01.16,
						["05.ogg"] = 01.34,
						["06.ogg"] = 01.50,
						["07.ogg"] = 00.96,
						["08.ogg"] = 01.19,
						["09.ogg"] = 01.14,
						["10.ogg"] = 00.86,
					},
				},
				["FacelessOne\\FacelessOne_"] = {
					["Aggro.ogg"] = 02.10,
					["Attack1.ogg"] = 02.21,
					["Attack10.ogg"] = 01.50,
					["Attack2.ogg"] = 01.81,
					["Attack3.ogg"] = 01.83,
					["Attack4.ogg"] = 01.58,
					["Attack5.ogg"] = 01.84,
					["Attack6.ogg"] = 01.54,
					["Attack7.ogg"] = 01.85,
					["Attack8.ogg"] = 01.81,
					["Attack9.ogg"] = 01.62,
					["Death.ogg"] = 04.42,
					["PreAggro.ogg"] = 02.83,
					["Wound1.ogg"] = 01.48,
					["Wound10.ogg"] = 01.46,
					["Wound2.ogg"] = 01.74,
					["Wound3.ogg"] = 01.67,
					["Wound4.ogg"] = 01.72,
					["Wound5.ogg"] = 01.45,
					["Wound6.ogg"] = 01.30,
					["Wound7.ogg"] = 01.81,
					["Wound8.ogg"] = 01.20,
					["Wound9.ogg"] = 01.42,
				},
				["FACELESSONEAQUATIC\\FacelessOneAquatic_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.86,
						["02.ogg"] = 01.55,
						["03.ogg"] = 01.52,
						["04.ogg"] = 01.96,
						["05.ogg"] = 02.27,
						["06.ogg"] = 01.76,
						["07.ogg"] = 01.95,
						["08.ogg"] = 02.20,
						["09.ogg"] = 02.02,
						["10.ogg"] = 02.27,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 01.43,
						["02.ogg"] = 01.43,
						["03.ogg"] = 01.43,
						["04.ogg"] = 01.73,
						["05.ogg"] = 01.37,
						["06.ogg"] = 01.49,
						["07.ogg"] = 01.59,
						["08.ogg"] = 01.69,
						["09.ogg"] = 01.43,
						["10.ogg"] = 01.97,
					},
					["Attack_"] = {
						["01.ogg"] = 01.43,
						["02.ogg"] = 01.56,
						["03.ogg"] = 01.43,
						["04.ogg"] = 01.47,
						["05.ogg"] = 01.37,
						["06.ogg"] = 01.43,
						["07.ogg"] = 01.30,
						["08.ogg"] = 01.53,
						["09.ogg"] = 01.58,
						["10.ogg"] = 01.97,
					},
					["Death_"] = {
						["01.ogg"] = 05.12,
						["02.ogg"] = 04.97,
						["03.ogg"] = 04.94,
						["04.ogg"] = 05.17,
						["05.ogg"] = 05.40,
						["06.ogg"] = 04.63,
						["07.ogg"] = 04.51,
						["08.ogg"] = 04.78,
						["09.ogg"] = 04.97,
						["10.ogg"] = 04.13,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.07,
						["02.ogg"] = 01.82,
						["03.ogg"] = 01.54,
						["04.ogg"] = 01.39,
						["05.ogg"] = 01.44,
						["06.ogg"] = 02.16,
						["07.ogg"] = 01.77,
						["08.ogg"] = 01.96,
						["09.ogg"] = 02.72,
						["10.ogg"] = 02.28,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.29,
						["02.ogg"] = 01.52,
						["03.ogg"] = 01.24,
						["04.ogg"] = 01.28,
						["05.ogg"] = 01.40,
						["06.ogg"] = 01.10,
						["07.ogg"] = 01.23,
						["08.ogg"] = 01.10,
						["09.ogg"] = 01.42,
						["10.ogg"] = 01.30,
					},
					["Wound_"] = {
						["01.ogg"] = 00.97,
						["02.ogg"] = 00.97,
						["03.ogg"] = 00.97,
						["04.ogg"] = 01.05,
						["05.ogg"] = 01.18,
						["06.ogg"] = 00.97,
						["07.ogg"] = 00.97,
						["08.ogg"] = 01.21,
						["09.ogg"] = 01.29,
						["10.ogg"] = 00.96,
					},
				},
				["FaerieDragon\\"] = {
					["MON_FaerieDragon_"] = {
						["MountSummon_"] = {
							["01.OGG"] = 03.27,
							["02.OGG"] = 03.41,
							["03.OGG"] = 02.67,
						},
						["Mount_"] = {
							["Aggro_"] = {
								["01.OGG"] = 01.15,
								["02.OGG"] = 01.33,
								["03.OGG"] = 00.95,
								["04.OGG"] = 01.21,
								["05.OGG"] = 00.93,
								["06.OGG"] = 00.72,
								["07.OGG"] = 00.72,
							},
							["Attack_"] = {
								["01.OGG"] = 00.73,
								["02.OGG"] = 01.05,
								["03.OGG"] = 00.68,
								["04.OGG"] = 00.63,
								["05.OGG"] = 00.76,
								["06.OGG"] = 00.73,
								["07.OGG"] = 00.87,
								["08.OGG"] = 00.97,
							},
							["BattleRoar_"] = {
								["01.OGG"] = 05.18,
								["02.OGG"] = 04.74,
								["03.OGG"] = 04.91,
							},
							["Chuff_"] = {
								["01.OGG"] = 00.60,
								["02.OGG"] = 00.59,
								["03.OGG"] = 00.70,
								["04.OGG"] = 00.72,
								["05.OGG"] = 00.64,
								["06.OGG"] = 00.55,
							},
							["Death_"] = {
								["01.OGG"] = 03.66,
								["02.OGG"] = 02.95,
							},
							["Idle_"] = {
								["01.OGG"] = 02.80,
								["02.OGG"] = 02.17,
								["03.OGG"] = 01.16,
								["04.OGG"] = 01.08,
								["05.OGG"] = 00.79,
								["06.OGG"] = 01.16,
								["07.OGG"] = 01.89,
								["08.OGG"] = 00.85,
								["09.OGG"] = 02.46,
								["10.OGG"] = 01.45,
							},
							["MountSpecial_"] = {
								["01.OGG"] = 04.91,
								["02.OGG"] = 04.94,
								["03.OGG"] = 05.21,
								["04.OGG"] = 04.61,
							},
							["PreAggro_"] = {
								["01.OGG"] = 01.32,
								["02.OGG"] = 01.19,
								["03.OGG"] = 01.25,
							},
							["Wound_"] = {
								["01.OGG"] = 00.70,
								["02.OGG"] = 00.97,
								["03.OGG"] = 01.43,
								["04.OGG"] = 00.93,
							},
						},
					},
					["FaerieDragonAggroA.ogg"] = 02.14,
					["FaerieDragonAttackA.ogg"] = 00.49,
					["FaerieDragonAttackB.ogg"] = 00.81,
					["FaerieDragonAttackC.ogg"] = 01.28,
					["FaerieDragonDeathA.ogg"] = 01.28,
					["FaerieDragonPreAggroA.ogg"] = 01.32,
					["FaerieDragonWoundA.ogg"] = 00.67,
					["FaerieDragonWoundB.ogg"] = 00.76,
					["FaerieDragonWoundC.ogg"] = 00.86,
					["FaerieDragonWoundCritA.ogg"] = 01.04,
				},
				["Faerlina\\FAER_"] = {
					["NAXX_"] = {
						["AGGRO01.ogg"] = 02.21,
						["AGGRO02.ogg"] = 02.70,
						["AGGRO03.ogg"] = 02.25,
						["AGGRO04.ogg"] = 02.17,
						["DEATH.ogg"] = 02.86,
						["GREET.ogg"] = 18.34,
						["SLAY01.ogg"] = 01.58,
						["SLAY02.ogg"] = 01.45,
					},
				},
				["FAHRAD\\VO_"] = {
					["QUEST_43_"] = {
						["FAHRAD_"] = {
							["SCENE1_"] = {
								["01.OGG"] = 06.24,
								["02.OGG"] = 02.55,
								["03.OGG"] = 01.04,
								["04.OGG"] = 09.42,
								["05.OGG"] = 07.76,
							},
							["SCENE2_"] = {
								["01.OGG"] = 10.89,
								["02.OGG"] = 09.66,
							},
							["SCENE4_"] = {
								["01.OGG"] = 05.13,
								["02.OGG"] = 04.45,
								["03.OGG"] = 01.74,
								["04.OGG"] = 04.69,
								["05.OGG"] = 09.49,
								["06.OGG"] = 04.41,
								["07.OGG"] = 02.20,
							},
							["COMPLETE1_01.OGG"] = 03.26,
							["COMPLETE2_01.OGG"] = 04.87,
							["COMPLETE3_01.OGG"] = 03.44,
							["COMPLETE4_01.OGG"] = 03.62,
							["SCENE3_01.OGG"] = 05.64,
						},
					},
				},
				["Falric\\HR_"] = {
					["Falric_"] = {
						["Aggro01.ogg"] = 11.35,
						["Attack01.ogg"] = 01.08,
						["Attack02.ogg"] = 01.46,
						["Attack03.ogg"] = 01.17,
						["Attack04.ogg"] = 01.06,
						["Attack05.ogg"] = 00.89,
						["Attack06.ogg"] = 00.61,
						["Attack07.ogg"] = 00.95,
						["Attack08.ogg"] = 01.00,
						["Attack09.ogg"] = 01.06,
						["Attack10.ogg"] = 01.26,
						["Death01.ogg"] = 04.57,
						["Intro01.ogg"] = 04.58,
						["Intro02.ogg"] = 01.36,
						["Slay01.ogg"] = 02.29,
						["Slay02.ogg"] = 03.75,
						["SP01.ogg"] = 03.75,
						["SP02.ogg"] = 04.29,
						["Wound01.ogg"] = 00.67,
						["Wound02.ogg"] = 00.75,
						["Wound03.ogg"] = 00.70,
						["Wound04.ogg"] = 00.89,
						["Wound05.ogg"] = 00.56,
						["Wound06.ogg"] = 00.78,
						["Wound07.ogg"] = 00.91,
						["Wound08.ogg"] = 00.75,
						["Wound09.ogg"] = 01.25,
						["Wound10.ogg"] = 01.33,
						["WoundCrit01.ogg"] = 01.10,
						["WoundCrit02.ogg"] = 02.30,
						["WoundCrit03.ogg"] = 01.12,
						["WoundCrit04.ogg"] = 00.98,
						["WoundCrit05.ogg"] = 01.09,
						["WoundCrit06.ogg"] = 02.77,
						["WoundCrit07.ogg"] = 01.04,
						["WoundCrit08.ogg"] = 00.97,
						["WoundCrit09.ogg"] = 00.68,
						["WoundCrit10.ogg"] = 02.48,
					},
				},
				["FandralCat\\MON_"] = {
					["FandralCat_"] = {
						["Attack01.ogg"] = 02.64,
						["Attack02.ogg"] = 02.69,
						["Attack03.ogg"] = 02.27,
						["Attack04.ogg"] = 02.84,
						["Attack05.ogg"] = 03.05,
						["Attack06.ogg"] = 02.71,
						["Attack07.ogg"] = 02.68,
						["AttackCrit01.ogg"] = 03.36,
						["AttackCrit02.ogg"] = 03.18,
						["AttackCrit03.ogg"] = 02.87,
						["AttackCrit04.ogg"] = 03.28,
						["Death01.ogg"] = 03.15,
						["Death02.ogg"] = 03.17,
						["Death03.ogg"] = 02.99,
						["SpecialAttack01.ogg"] = 02.66,
						["SpecialAttack02.ogg"] = 03.14,
						["Wound01.ogg"] = 02.96,
						["Wound02.ogg"] = 02.97,
						["Wound03.ogg"] = 02.64,
						["Wound04.ogg"] = 02.91,
						["Wound05.ogg"] = 02.60,
						["WoundCrit01.ogg"] = 03.29,
						["WoundCrit02.ogg"] = 03.03,
						["WoundCrit03.ogg"] = 02.91,
						["WoundCrit04.ogg"] = 03.12,
						["WoundCrit05.ogg"] = 03.09,
					},
				},
				["FandralFlameDruid\\VO_"] = {
					["FL_FANDRAL_"] = {
						["ALYSRAZOR_INTRO_"] = {
							["01.ogg"] = 08.53,
							["02.ogg"] = 13.94,
							["03.ogg"] = 09.56,
						},
						["GATE_INTRO_"] = {
							["01.ogg"] = 12.47,
							["02.ogg"] = 06.44,
							["03.ogg"] = 11.94,
						},
						["KILL_"] = {
							["01.ogg"] = 04.71,
							["02.ogg"] = 04.50,
							["03.ogg"] = 05.99,
							["04.ogg"] = 06.39,
							["05.ogg"] = 04.42,
						},
						["AGGRO.ogg"] = 08.01,
						["ATTACK01.ogg"] = 02.48,
						["ATTACK02.ogg"] = 02.61,
						["ATTACK03.ogg"] = 02.69,
						["ATTACK04.ogg"] = 02.73,
						["ATTACK05.ogg"] = 02.87,
						["ATTACK06.ogg"] = 02.00,
						["ATTACK07.ogg"] = 01.93,
						["ATTACK08.ogg"] = 01.89,
						["ATTACK09.ogg"] = 01.91,
						["ATTACK10.ogg"] = 01.91,
						["ATTACKCRIT01.ogg"] = 03.46,
						["ATTACKCRIT02.ogg"] = 03.49,
						["ATTACKCRIT03.ogg"] = 03.32,
						["ATTACKCRIT04.ogg"] = 02.64,
						["ATTACKCRIT05.ogg"] = 04.09,
						["DEATH.ogg"] = 07.23,
						["LAUGH01.ogg"] = 04.86,
						["LAUGH02.ogg"] = 05.71,
						["SPELLCAST01.ogg"] = 02.74,
						["SPELLCAST02.ogg"] = 02.47,
						["SPELLCAST03.ogg"] = 02.86,
						["SPELLCAST04.ogg"] = 03.46,
						["WOUND01.ogg"] = 02.22,
						["WOUND02.ogg"] = 02.16,
						["WOUND03.ogg"] = 01.97,
						["WOUND04.ogg"] = 02.14,
						["WOUND05.ogg"] = 02.19,
						["WOUND06.ogg"] = 02.83,
						["WOUND07.ogg"] = 02.01,
						["WOUND08.ogg"] = 02.38,
						["WOUND09.ogg"] = 02.01,
						["WOUND10.ogg"] = 02.58,
						["WOUNDCRIT01.ogg"] = 03.35,
						["WOUNDCRIT02.ogg"] = 03.01,
						["WOUNDCRIT03.ogg"] = 03.20,
						["WOUNDCRIT04.ogg"] = 03.33,
						["WOUNDCRIT05.ogg"] = 03.56,
						["FIREBIRD_TRANSFORM.ogg"] = 04.83,
						["SCORPION_TRANSFORM.ogg"] = 06.35,
						["TIGER_TRANSFORM.ogg"] = 06.66,
					},
					["QUEST_42_"] = {
						["FANDRAL_"] = {
							["FLASHBACK_"] = {
								["01.ogg"] = 04.97,
								["02.ogg"] = 11.05,
								["03.ogg"] = 03.05,
								["04.ogg"] = 06.59,
								["05.ogg"] = 06.84,
								["06.ogg"] = 09.56,
							},
							["INTRO_"] = {
								["01.ogg"] = 04.71,
								["02.ogg"] = 11.94,
								["03.ogg"] = 12.62,
								["04.ogg"] = 08.66,
								["05.ogg"] = 16.73,
								["06.ogg"] = 15.44,
								["07.ogg"] = 04.61,
								["08.ogg"] = 07.27,
								["09.ogg"] = 08.59,
								["10.ogg"] = 07.53,
							},
							["TAUNT_"] = {
								["01.ogg"] = 05.62,
								["02.ogg"] = 05.56,
								["03.ogg"] = 06.69,
								["04.ogg"] = 04.45,
								["05.ogg"] = 06.75,
								["06.ogg"] = 05.95,
								["07.ogg"] = 06.53,
								["08.ogg"] = 07.05,
							},
						},
					},
				},
				["FandralScorpion\\MON_"] = {
					["FandralScorpion_"] = {
						["Attack01.ogg"] = 01.95,
						["Attack02.ogg"] = 02.13,
						["Attack03.ogg"] = 01.95,
						["Attack04.ogg"] = 02.04,
						["Attack05.ogg"] = 02.10,
						["Attack06.ogg"] = 02.14,
						["Attack07.ogg"] = 01.91,
						["Attack08.ogg"] = 01.98,
						["Attack09.ogg"] = 01.81,
						["Attack10.ogg"] = 02.08,
						["AttackCrit01.ogg"] = 02.19,
						["AttackCrit02.ogg"] = 02.25,
						["AttackCrit03.ogg"] = 02.15,
						["AttackCrit04.ogg"] = 02.54,
						["AttackCrit05.ogg"] = 02.46,
						["Death01.ogg"] = 02.62,
						["Death02.ogg"] = 02.43,
						["Death03.ogg"] = 02.15,
						["Death04.ogg"] = 02.84,
						["Death05.ogg"] = 02.34,
						["Wound01.ogg"] = 01.73,
						["Wound02.ogg"] = 02.10,
						["Wound03.ogg"] = 01.78,
						["Wound04.ogg"] = 01.81,
						["Wound05.ogg"] = 01.87,
						["Wound06.ogg"] = 01.95,
						["Wound07.ogg"] = 01.76,
						["Wound08.ogg"] = 01.81,
						["Wound09.ogg"] = 01.81,
						["Wound10.ogg"] = 02.12,
						["WoundCrit01.ogg"] = 02.30,
						["WoundCrit02.ogg"] = 01.65,
						["WoundCrit03.ogg"] = 02.03,
						["WoundCrit04.ogg"] = 01.93,
						["WoundCrit05.ogg"] = 02.14,
					},
				},
				["FandralStaghelm\\"] = {
					["FandralStaghelmGreeting01.ogg"] = 03.01,
					["FandralStaghelmGreeting02.ogg"] = 02.42,
					["FandralStaghelmGreeting03.ogg"] = 02.14,
				},
				["Fankriss\\"] = {
					["FankrissISenetence.ogg"] = 02.90,
					["FankrissIServeTo.ogg"] = 03.01,
					["FankrissTheLaws.ogg"] = 03.23,
					["FankrissTrespassers.ogg"] = 02.57,
					["FankrissYouWillBe.ogg"] = 03.89,
				},
				["FathomLordKarathress\\COIL_"] = {
					["FathomLrd_"] = {
						["Aggro01.ogg"] = 04.96,
						["Attack01.ogg"] = 02.30,
						["Attack02.ogg"] = 02.41,
						["Attack03.ogg"] = 02.88,
						["Attack04.ogg"] = 02.40,
						["Death01.ogg"] = 05.68,
						["GainAblty01.ogg"] = 06.38,
						["GainAblty02.ogg"] = 04.48,
						["GainAblty03.ogg"] = 04.63,
						["PlyrAttcks01.ogg"] = 06.82,
						["Slay01.ogg"] = 03.68,
						["Slay02.ogg"] = 03.53,
						["Slay03.ogg"] = 03.41,
						["Wound01.ogg"] = 02.38,
						["Wound02.ogg"] = 02.30,
						["Wound03.ogg"] = 02.43,
						["Wound04.ogg"] = 02.53,
						["Wound05.ogg"] = 02.55,
						["WoundCrit01.ogg"] = 02.92,
						["WoundCrit02.ogg"] = 03.23,
						["WoundCrit03.ogg"] = 02.73,
						["WoundCrit04.ogg"] = 02.85,
					},
				},
				["Fawkes\\VO_"] = {
					["QE_TH_"] = {
						["Fawkes_"] = {
							["Event01.ogg"] = 02.49,
							["Event02.ogg"] = 01.09,
							["Event03.ogg"] = 04.49,
							["Event04.ogg"] = 02.31,
							["Event05.ogg"] = 02.87,
							["Event06.ogg"] = 01.60,
							["Event07.ogg"] = 06.23,
							["Event08.ogg"] = 03.03,
							["Event09.ogg"] = 01.64,
							["Event10.ogg"] = 01.87,
							["Event11.ogg"] = 03.35,
							["Event12.ogg"] = 06.97,
							["Event13.ogg"] = 03.38,
						},
					},
				},
				["Fearsen\\VO_"] = {
					["QE_VJ_"] = {
						["Fearsen_"] = {
							["AllianceShip01.ogg"] = 04.95,
							["AllianceShip02.ogg"] = 03.99,
							["AllianceShip03.ogg"] = 02.59,
							["Dock01.ogg"] = 03.67,
							["Dock02.ogg"] = 05.58,
							["Dock03.ogg"] = 06.05,
							["Dock04.ogg"] = 06.93,
						},
					},
				},
				["FeiLitheFirecracker\\VO_"] = {
					["FeiLi_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.49,
							["02.OGG"] = 00.74,
							["03.OGG"] = 00.53,
							["04.OGG"] = 00.69,
							["05.OGG"] = 00.69,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.30,
							["02.OGG"] = 00.35,
							["03.OGG"] = 00.28,
							["04.OGG"] = 00.30,
							["05.OGG"] = 00.32,
							["06.OGG"] = 00.25,
							["07.OGG"] = 00.31,
							["08.OGG"] = 00.22,
							["09.OGG"] = 00.30,
						},
						["Death_"] = {
							["01.OGG"] = 01.69,
							["02.OGG"] = 01.99,
							["03.OGG"] = 02.72,
							["04.OGG"] = 02.29,
							["05.OGG"] = 01.29,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.69,
							["02.OGG"] = 00.91,
							["03.OGG"] = 00.85,
							["04.OGG"] = 00.61,
							["05.OGG"] = 00.99,
						},
						["Wound_"] = {
							["01.OGG"] = 00.46,
							["02.OGG"] = 00.35,
							["03.OGG"] = 00.58,
							["04.OGG"] = 00.66,
							["05.OGG"] = 00.49,
							["06.OGG"] = 00.59,
							["07.OGG"] = 00.67,
							["08.OGG"] = 00.25,
						},
					},
					["Shadopan_FireMage_"] = {
						["Farewell_"] = {
							["01.OGG"] = 01.75,
							["02.OGG"] = 01.19,
						},
						["Finale_"] = {
							["01.OGG"] = 01.87,
							["02.OGG"] = 01.92,
							["03.OGG"] = 02.61,
							["04.OGG"] = 02.31,
							["05.OGG"] = 01.12,
							["06.OGG"] = 01.98,
							["07.OGG"] = 01.70,
							["08.OGG"] = 01.82,
						},
						["Generic_"] = {
							["01.OGG"] = 01.71,
							["02.OGG"] = 01.21,
							["03.OGG"] = 02.77,
							["04.OGG"] = 03.29,
							["05.OGG"] = 02.40,
							["06.OGG"] = 02.51,
							["07.OGG"] = 02.58,
							["08.OGG"] = 01.70,
							["09.OGG"] = 01.96,
							["10.OGG"] = 02.55,
						},
						["Greeting_"] = {
							["01.OGG"] = 01.65,
							["02.OGG"] = 01.06,
							["03.OGG"] = 01.29,
							["04.OGG"] = 01.71,
							["05.OGG"] = 01.78,
						},
						["Pissed_"] = {
							["01.OGG"] = 02.61,
							["02.OGG"] = 02.33,
							["03.OGG"] = 02.91,
							["04.OGG"] = 02.26,
						},
						["Summon_"] = {
							["01.OGG"] = 01.96,
							["02.OGG"] = 03.83,
							["03.OGG"] = 01.89,
						},
					},
				},
				["FelBat\\"] = {
					["MON_FelBat_"] = {
						["Aggro_"] = {
							["01.OGG"] = 01.74,
							["02.OGG"] = 01.60,
							["03.OGG"] = 01.41,
							["04.OGG"] = 01.70,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.14,
							["02.OGG"] = 00.97,
							["03.OGG"] = 01.29,
							["04.OGG"] = 01.29,
						},
						["Attack_"] = {
							["01.OGG"] = 01.14,
							["02.OGG"] = 01.32,
							["03.OGG"] = 01.25,
							["04.OGG"] = 01.37,
							["05.OGG"] = 01.10,
							["06.OGG"] = 01.43,
						},
						["Death_"] = {
							["01.OGG"] = 01.37,
							["02.OGG"] = 01.44,
							["03.OGG"] = 01.77,
							["04.OGG"] = 01.79,
							["05.OGG"] = 01.81,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.60,
							["02.OGG"] = 01.24,
							["03.OGG"] = 01.36,
							["04.OGG"] = 01.19,
							["05.OGG"] = 01.51,
							["06.OGG"] = 01.55,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.92,
							["02.OGG"] = 00.96,
							["03.OGG"] = 01.13,
							["04.OGG"] = 01.14,
						},
						["Wound_"] = {
							["01.OGG"] = 01.04,
							["02.OGG"] = 01.07,
							["03.OGG"] = 01.01,
							["04.OGG"] = 01.06,
							["05.OGG"] = 01.20,
							["06.OGG"] = 01.21,
						},
					},
					["FelBatAggro.ogg"] = 01.02,
					["FelBatAttackA.ogg"] = 00.55,
					["FelBatAttackB.ogg"] = 00.96,
					["FelBatAttackC.ogg"] = 00.68,
					["FelBatDeath.ogg"] = 00.85,
					["FelBatpreAggro.ogg"] = 00.52,
					["FelBatWohndC.ogg"] = 00.68,
					["FelBatWoundA.ogg"] = 00.54,
					["FelBatWoundB.ogg"] = 00.48,
					["FelBatWoundCrit.ogg"] = 00.74,
				},
				["FelBeast\\"] = {
					["FelBeastAggro.ogg"] = 02.49,
					["FelBeastAttackA.ogg"] = 02.97,
					["FelBeastAttackB.ogg"] = 02.32,
					["FelBeastAttackC.ogg"] = 02.55,
					["FelBeastDeath.ogg"] = 02.57,
					["FelBeastPreAggro.ogg"] = 02.32,
					["FelBeastWoundA.ogg"] = 02.54,
					["FelBeastWoundB.ogg"] = 02.32,
					["FelBeastWoundC.ogg"] = 02.12,
					["FelBeastWoundCrit.ogg"] = 02.57,
				},
				["FelBeastBeauty\\FelBeastBeauty_"] = {
					["Aggro01.ogg"] = 02.00,
					["Aggro02.ogg"] = 01.45,
					["Aggro03.ogg"] = 01.29,
					["Aggro04.ogg"] = 01.35,
					["Aggro05.ogg"] = 01.73,
					["Aggro06.ogg"] = 01.60,
					["Aggro07.ogg"] = 01.89,
					["Aggro08.ogg"] = 01.28,
					["Aggro09.ogg"] = 01.07,
					["AggroPre01.ogg"] = 04.42,
					["AggroPre02.ogg"] = 04.33,
					["AggroPre03.ogg"] = 03.58,
					["AggroPre04.ogg"] = 03.40,
					["AggroPre05.ogg"] = 01.31,
					["AggroPre06.ogg"] = 01.51,
					["Attack01.ogg"] = 01.38,
					["Attack02.ogg"] = 01.63,
					["Attack03.ogg"] = 01.50,
					["Attack04.ogg"] = 01.45,
					["Attack05.ogg"] = 01.21,
					["Attack06.ogg"] = 02.06,
					["Attack07.ogg"] = 01.52,
					["Attack08.ogg"] = 01.55,
					["Attack09.ogg"] = 01.71,
					["Attack10.ogg"] = 01.60,
					["AttackCrit01.ogg"] = 01.83,
					["AttackCrit02.ogg"] = 01.54,
					["AttackCrit03.ogg"] = 01.80,
					["AttackCrit04.ogg"] = 01.53,
					["AttackCrit05.ogg"] = 01.26,
					["Death01.ogg"] = 04.24,
					["Death02.ogg"] = 04.41,
					["Death03.ogg"] = 04.76,
					["Death04.ogg"] = 03.93,
					["Death05.ogg"] = 03.99,
					["FireLoop.ogg"] = 06.00,
					["GrowlBark01.ogg"] = 03.31,
					["GrowlBark02.ogg"] = 04.28,
					["GrowlBark03.ogg"] = 03.85,
					["HappyHowl01.ogg"] = 04.53,
					["HappyHowl02.ogg"] = 04.47,
					["HappyHowl03.ogg"] = 04.37,
					["Whimper01.ogg"] = 02.71,
					["Whimper02.ogg"] = 02.59,
					["Whimper03.ogg"] = 02.71,
					["Wound01.ogg"] = 01.03,
					["Wound02.ogg"] = 01.43,
					["Wound03.ogg"] = 01.38,
					["Wound04.ogg"] = 01.27,
					["Wound05.ogg"] = 01.35,
					["Wound06.ogg"] = 01.18,
					["Wound07.ogg"] = 01.38,
					["WoundCrit01.ogg"] = 01.31,
					["WoundCrit02.ogg"] = 01.50,
					["WoundCrit03.ogg"] = 01.61,
					["WoundCrit04.ogg"] = 01.32,
					["WoundCrit05.ogg"] = 01.60,
					["WoundCrit06.ogg"] = 01.68,
					["WoundCrit07.ogg"] = 01.61,
				},
				["Felblaze\\"] = {
					["FELBLAZEBERSERK.ogg"] = 04.57,
					["FELBLAZEBORN.ogg"] = 05.80,
					["FELBLAZEBREATH.ogg"] = 02.54,
					["FELBLAZEDEATH.ogg"] = 04.06,
					["FELBLAZEKILL01.ogg"] = 02.76,
					["FELBLAZEKILL02.ogg"] = 02.61,
					["FELBLAZESPELLS.ogg"] = 03.77,
				},
				["FelBoar\\"] = {
					["FelBoarAggroA.ogg"] = 01.44,
					["FelBoarAttackA.ogg"] = 01.00,
					["FelBoarAttackB.ogg"] = 00.62,
					["FelBoarAttackC.ogg"] = 00.81,
					["FelBoarDeathA.ogg"] = 01.32,
					["FelBoarDeathB.ogg"] = 01.22,
					["FelBoarPreAggroA.ogg"] = 01.30,
					["FelBoarStandA.ogg"] = 01.42,
					["FelBoarWoundA.ogg"] = 00.92,
					["FelBoarWoundB.ogg"] = 00.75,
					["FelBoarWoundC.ogg"] = 00.90,
					["FelBoarWoundCritA.ogg"] = 01.31,
					["FelBoarWoundCritB.ogg"] = 01.19,
					["FelBoarWoundD.ogg"] = 01.10,
				},
				["FelbreakerCaptain\\VO_"] = {
					["60_"] = {
						["FELBREAKERCAPTAIN_"] = {
							["AttackCrit_"] = {
								["0.OGG"] = 02.21,
								["1.OGG"] = 02.64,
								["2.OGG"] = 02.77,
								["3.OGG"] = 01.98,
								["4.OGG"] = 02.02,
							},
							["Attack_"] = {
								["0.OGG"] = 00.99,
								["1.OGG"] = 01.02,
								["2.OGG"] = 01.12,
								["3.OGG"] = 01.57,
								["4.OGG"] = 00.68,
								["5.OGG"] = 00.90,
								["6.OGG"] = 00.97,
							},
							["WoundCrit_"] = {
								["0.OGG"] = 01.72,
								["1.OGG"] = 01.56,
								["2.OGG"] = 01.58,
								["3.OGG"] = 01.51,
								["4.OGG"] = 01.02,
							},
							["Wound_"] = {
								["0.OGG"] = 00.85,
								["1.OGG"] = 00.49,
								["2.OGG"] = 00.65,
								["3.OGG"] = 01.10,
								["4.OGG"] = 00.92,
								["5.OGG"] = 01.19,
								["6.OGG"] = 00.37,
								["7.OGG"] = 00.76,
							},
						},
						["HMR_FELBREAKER_"] = {
							["ADD_"] = {
								["01.OGG"] = 03.38,
								["02.OGG"] = 04.23,
							},
							["SMASH_"] = {
								["01.OGG"] = 02.00,
								["02.OGG"] = 01.63,
								["03.OGG"] = 01.77,
							},
							["SPELL_"] = {
								["01.OGG"] = 04.32,
								["02.OGG"] = 03.66,
							},
							["STOMP_"] = {
								["01.OGG"] = 03.01,
								["02.OGG"] = 06.04,
								["03.OGG"] = 02.77,
								["04.OGG"] = 01.44,
							},
							["AGGRO.OGG"] = 05.01,
							["BERSERK.OGG"] = 03.67,
							["DEATH.OGG"] = 03.58,
							["EVENT1.OGG"] = 03.02,
							["EVENT2.OGG"] = 06.78,
							["EVENT3.OGG"] = 06.11,
							["EVENT4.OGG"] = 03.49,
							["INTRO.OGG"] = 04.33,
							["KILL1.OGG"] = 01.59,
							["KILL2.OGG"] = 01.22,
							["KILL3.OGG"] = 03.57,
						},
					},
				},
				["FelElfCasterFemale\\"] = {
					["FelElfCasterFemaleAttackA.ogg"] = 00.64,
					["FelElfCasterFemaleAttackB.ogg"] = 00.69,
					["FelElfCasterFemaleAttackC.ogg"] = 00.70,
					["FelElfCasterFemaleAttackD.ogg"] = 00.78,
					["FelElfCasterFemaleAttackE.ogg"] = 00.64,
					["FelElfCasterFemaleAttackF.ogg"] = 00.65,
					["FelElfCasterFemaleDeath.ogg"] = 01.93,
					["FelElfCasterFemalePreAggro.ogg"] = 00.84,
					["FelElfCasterFemaleWoundA.ogg"] = 00.78,
					["FelElfCasterFemaleWoundB.ogg"] = 00.63,
					["FelElfCasterFemaleWoundC.ogg"] = 00.66,
					["FelElfCasterFemaleWoundCritA.ogg"] = 00.97,
					["FelElfCasterFemaleWoundCritB.ogg"] = 00.84,
					["FelElfCasterFemaleWoundD.ogg"] = 00.63,
					["FelElfCasterFemaleWoundE.ogg"] = 00.82,
					["FelElfCasterFemaleWoundF.ogg"] = 00.86,
				},
				["FelElfCasterMale\\"] = {
					["FelElfCasterMale_"] = {
						["Aggro01.ogg"] = 01.47,
						["Aggro02.ogg"] = 01.39,
						["Aggro03.ogg"] = 01.38,
						["Aggro04.ogg"] = 01.63,
						["Aggro05.ogg"] = 02.00,
						["Aggro06.ogg"] = 01.81,
						["Aggro07.ogg"] = 02.08,
						["Aggro08.ogg"] = 01.54,
						["Aggro09.ogg"] = 01.87,
						["Aggro10.ogg"] = 01.77,
						["Attack01.ogg"] = 01.00,
						["Attack02.ogg"] = 01.27,
						["Attack03.ogg"] = 01.22,
						["Attack04.ogg"] = 01.14,
						["Attack05.ogg"] = 01.15,
						["Attack06.ogg"] = 01.34,
						["Attack07.ogg"] = 01.20,
						["Attack08.ogg"] = 01.16,
						["Attack09.ogg"] = 01.05,
						["AttackCrit01.ogg"] = 01.66,
						["AttackCrit02.ogg"] = 01.56,
						["AttackCrit03.ogg"] = 01.71,
						["AttackCrit04.ogg"] = 01.56,
						["AttackCrit05.ogg"] = 01.57,
						["Death01.ogg"] = 04.34,
						["Death02.ogg"] = 04.59,
						["Death03.ogg"] = 04.59,
						["Death04.ogg"] = 04.34,
						["Death05.ogg"] = 04.26,
						["Death06.ogg"] = 03.51,
						["PreAggro01.ogg"] = 00.89,
						["PreAggro02.ogg"] = 01.00,
						["PreAggro03.ogg"] = 01.00,
						["PreAggro04.ogg"] = 01.00,
						["PreAggro05.ogg"] = 01.00,
						["Wound01.ogg"] = 01.00,
						["Wound02.ogg"] = 01.00,
						["Wound03.ogg"] = 01.00,
						["Wound04.ogg"] = 01.00,
						["Wound05.ogg"] = 01.00,
						["Wound06.ogg"] = 01.00,
						["Wound07.ogg"] = 01.00,
						["Wound08.ogg"] = 01.00,
						["Wound09.ogg"] = 01.00,
						["Wound10.ogg"] = 01.00,
						["WoundCrit01.ogg"] = 01.68,
						["WoundCrit02.ogg"] = 01.56,
						["WoundCrit03.ogg"] = 01.22,
						["WoundCrit04.ogg"] = 01.44,
						["WoundCrit05.ogg"] = 01.37,
						["WoundCrit06.ogg"] = 01.19,
					},
					["FelElfCasterMaleAggro.ogg"] = 01.41,
					["FelElfCasterMaleAttackA.ogg"] = 01.18,
					["FelElfCasterMaleAttackB.ogg"] = 01.16,
					["FelElfCasterMaleAttackC.ogg"] = 01.09,
					["FelElfCasterMaleAttackD.ogg"] = 01.01,
					["FelElfCasterMaleAttackE.ogg"] = 01.00,
					["FelElfCasterMaleAttackF.ogg"] = 00.80,
					["FelElfCasterMaleAttackG.ogg"] = 01.06,
					["FelElfCasterMaleDeath.ogg"] = 04.05,
					["FelElfCasterMalePreAggro.ogg"] = 01.06,
					["FelElfCasterMaleWoundA.ogg"] = 00.86,
					["FelElfCasterMaleWoundB.ogg"] = 00.82,
					["FelElfCasterMaleWoundC.ogg"] = 00.85,
					["FelElfCasterMaleWoundCritA.ogg"] = 01.18,
					["FelElfCasterMaleWoundCritB.ogg"] = 01.21,
					["FelElfCasterMaleWoundCritI.ogg"] = 01.13,
					["FelElfCasterMaleWoundE.ogg"] = 00.94,
					["FelElfCasterMaleWoundF.ogg"] = 00.95,
					["FelElfCasterMaleWoundG.ogg"] = 00.93,
					["FelElfCasterMaleWoundH.ogg"] = 01.02,
				},
				["FelElfHunterFemale\\"] = {
					["FelElfHunterFemaleAttackA.ogg"] = 00.90,
					["FelElfHunterFemaleAttackB.ogg"] = 00.83,
					["FelElfHunterFemaleAttackC.ogg"] = 00.97,
					["FelElfHunterFemaleAttackD.ogg"] = 00.93,
					["FelElfHunterFemaleAttackE.ogg"] = 01.27,
					["FelElfHunterFemaleAttackF.ogg"] = 01.38,
					["FelElfHunterFemaleDeath.ogg"] = 02.96,
					["FelElfHunterFemalePreAggro.ogg"] = 00.68,
					["FelElfHunterFemaleWoundA.ogg"] = 00.83,
					["FelElfHunterFemaleWoundB.ogg"] = 00.79,
					["FelElfHunterFemaleWoundC.ogg"] = 00.75,
					["FelElfHunterFemaleWoundCrit.ogg"] = 01.05,
					["FelElfHunterFemaleWoundD.ogg"] = 00.70,
					["FelElfHunterFemaleWoundE.ogg"] = 00.93,
					["FelElfHunterFemaleWoundF.ogg"] = 00.97,
					["FelElfHunterFemaleWoundG.ogg"] = 00.71,
					["FelElfHunterFemaleWoundH.ogg"] = 00.62,
					["FelElfHunterFemaleWoundI.ogg"] = 00.84,
				},
				["FelElfWarrirorMale\\"] = {
					["FelElfWarriorMaleAttackA.ogg"] = 00.78,
					["FelElfWarriorMaleAttackB.ogg"] = 00.70,
					["FelElfWarriorMaleAttackC.ogg"] = 00.94,
					["FelElfWarriorMaleAttackD.ogg"] = 00.85,
					["FelElfWarriorMaleAttackE.ogg"] = 00.82,
					["FelElfWarriorMaleAttackF.ogg"] = 00.99,
					["FelElfWarriorMaleAttackG.ogg"] = 01.20,
					["FelElfWarriorMaleDeath.ogg"] = 03.72,
					["FelElfWarriorMalePreAggro.ogg"] = 00.78,
					["FelElfWarriorMaleWoundA.ogg"] = 00.77,
					["FelElfWarriorMaleWoundB.ogg"] = 00.79,
					["FelElfWarriorMaleWoundC.ogg"] = 00.69,
					["FelElfWarriorMaleWoundCritA.ogg"] = 01.01,
					["FelElfWarriorMaleWoundCritB.ogg"] = 00.96,
					["FelElfWarriorMaleWoundCritC.ogg"] = 00.97,
					["FelElfWarriorMaleWoundD.ogg"] = 00.85,
					["FelElfWarriorMaleWoundE.ogg"] = 00.83,
					["FelElfWarriorMaleWoundF.ogg"] = 00.85,
				},
				["FelendrenTheBanished\\A_"] = {
					["FelendrenFeed.ogg"] = 04.03,
					["FelendrenFoolish.ogg"] = 07.35,
					["FelendrenTakeHeart.ogg"] = 05.85,
				},
				["FelGolem\\"] = {
					["FelGolemAggro.ogg"] = 04.70,
					["FelGolemAttackA.ogg"] = 03.38,
					["FelGolemAttackB.ogg"] = 02.49,
					["FelGolemAttackC.ogg"] = 01.99,
					["FelGolemAttackD.ogg"] = 02.86,
					["FelGolemDeath.ogg"] = 04.61,
					["FelGolemWoundA.ogg"] = 02.50,
					["FelGolemWoundB.ogg"] = 02.44,
					["FelGolemWoundC.ogg"] = 02.68,
					["FelGolemWoundCrit.ogg"] = 03.06,
					["FelGolemWoundD.ogg"] = 03.42,
					["FelGolemWoundE.ogg"] = 03.47,
				},
				["FelHound\\"] = {
					["FelHoundAggroA.ogg"] = 01.35,
					["FelHoundAttackA.ogg"] = 00.92,
					["FelHoundAttackB.ogg"] = 00.87,
					["FelHoundAttackC.ogg"] = 00.72,
					["FelHoundDeathA.ogg"] = 01.74,
					["FelHoundPreAggroA.ogg"] = 00.60,
					["FelHoundStandRoar.ogg"] = 01.12,
					["FelHoundWoundA.ogg"] = 00.94,
					["FelHoundWoundB.ogg"] = 00.53,
					["FelHoundWoundC.ogg"] = 00.89,
					["FelHoundWoundCritA.ogg"] = 01.14,
				},
				["FELINEFAMILIAR\\Pet_"] = {
					["FelineFamiliar_"] = {
						["Clickable01.ogg"] = 00.97,
						["Clickable02.ogg"] = 00.90,
						["Clickable03.ogg"] = 00.87,
						["Clickable04.ogg"] = 01.86,
						["Clickable05.ogg"] = 01.84,
						["Clickable06.ogg"] = 00.99,
						["Clickable07.ogg"] = 01.22,
						["Clickable08.ogg"] = 01.72,
						["Clickable09.ogg"] = 01.48,
					},
				},
				["FelOrc\\"] = {
					["FelOrcAggro.ogg"] = 01.80,
					["FelOrcAttackA.ogg"] = 00.70,
					["FelOrcAttackB.ogg"] = 00.68,
					["FelOrcAttackC.ogg"] = 01.10,
					["FelOrcAttackD.ogg"] = 01.29,
					["FelOrcAttackE.ogg"] = 00.92,
					["FelOrcAttackF.ogg"] = 01.25,
					["FelOrcDeathA.ogg"] = 02.41,
					["FelOrcDeathB.ogg"] = 02.39,
					["FelOrcPreAggro.ogg"] = 02.41,
					["FelOrcWoundA.ogg"] = 00.44,
					["FelOrcWoundB.ogg"] = 00.40,
					["FelOrcWoundC.ogg"] = 00.79,
					["FelOrcWoundCritA.ogg"] = 01.07,
					["FelOrcWoundCritB.ogg"] = 01.47,
					["FelOrcWoundCritC.ogg"] = 01.48,
					["FelOrcWoundCritD.ogg"] = 01.41,
					["FelOrcWoundD.ogg"] = 00.51,
					["FelOrcWoundE.ogg"] = 01.01,
					["FelOrcWoundF.ogg"] = 00.55,
				},
				["FelReaver\\"] = {
					["FelReaverAggro.ogg"] = 03.18,
					["FelReaverAttackA.ogg"] = 02.18,
					["FelReaverAttackB.ogg"] = 02.50,
					["FelReaverAttackC.ogg"] = 02.65,
					["FelReaverAttackD.ogg"] = 02.34,
					["FelReaverAttackE.ogg"] = 02.56,
					["FelReaverDeath.ogg"] = 09.72,
					["FelReaverLoop.ogg"] = 04.36,
					["FelReaverPreAggro.ogg"] = 02.21,
					["FelReaverWoundA.ogg"] = 01.38,
					["FelReaverWoundB.ogg"] = 01.64,
					["FelReaverWoundC.ogg"] = 02.46,
					["FelReaverWoundCrit.ogg"] = 02.85,
					["FelReaverWoundD.ogg"] = 01.76,
				},
				["Felsen\\VO_"] = {
					["QE_Felsen_"] = {
						["Event01.ogg"] = 12.58,
						["ThroneDisc01.ogg"] = 17.88,
					},
				},
				["Feludius\\VO_"] = {
					["BT_Feludius_"] = {
						["Attack01.ogg"] = 00.94,
						["Attack02.ogg"] = 01.17,
						["Attack03.ogg"] = 01.16,
						["Attack04.ogg"] = 01.24,
						["Attack05.ogg"] = 01.08,
						["Attack06.ogg"] = 01.03,
						["Attack07.ogg"] = 01.09,
						["Attack08.ogg"] = 01.22,
						["Attack09.ogg"] = 01.08,
						["Attack10.ogg"] = 01.30,
						["AttackCrit01.ogg"] = 01.56,
						["AttackCrit02.ogg"] = 01.80,
						["AttackCrit03.ogg"] = 01.40,
						["AttackCrit04.ogg"] = 01.00,
						["Death01.ogg"] = 02.70,
						["Death02.ogg"] = 02.52,
						["Death03.ogg"] = 03.29,
						["Death04.ogg"] = 02.68,
						["Death05.ogg"] = 02.89,
						["Death06.ogg"] = 02.56,
						["Event01.ogg"] = 04.45,
						["Event02.ogg"] = 01.73,
						["Event03.ogg"] = 04.64,
						["Event04.ogg"] = 04.40,
						["Event05.ogg"] = 06.43,
						["Wound01.ogg"] = 00.96,
						["Wound02.ogg"] = 00.88,
						["Wound03.ogg"] = 01.08,
						["Wound04.ogg"] = 01.21,
						["Wound05.ogg"] = 01.05,
						["Wound06.ogg"] = 00.94,
						["Wound07.ogg"] = 01.05,
						["Wound08.ogg"] = 01.09,
						["Wound09.ogg"] = 01.06,
						["Wound10.ogg"] = 01.23,
						["WoundCrit01.ogg"] = 01.52,
						["WoundCrit02.ogg"] = 02.04,
						["WoundCrit03.ogg"] = 01.40,
						["WoundCrit04.ogg"] = 01.43,
						["WoundCrit05.ogg"] = 01.65,
						["WoundCrit06.ogg"] = 01.24,
						["WoundCrit07.ogg"] = 01.13,
					},
				},
				["FemaleAllianceGuard\\VO_"] = {
					["60_GAR_"] = {
						["ALLIANCE_GUARD_"] = {
							["FEMALE_"] = {
								["01.ogg"] = 00.51,
								["02.ogg"] = 01.11,
								["03.ogg"] = 01.11,
								["04.ogg"] = 00.88,
								["05.ogg"] = 00.81,
								["06.ogg"] = 00.93,
							},
						},
					},
				},
				["FemaleFrostwolfOrc\\VO_"] = {
					["60_FROSTWOLF_"] = {
						["FEMALE_WAR_"] = {
							["FAREWELL_"] = {
								["01.ogg"] = 01.61,
								["02.ogg"] = 01.93,
								["03.ogg"] = 01.44,
							},
							["GREETING_"] = {
								["01.ogg"] = 01.05,
								["02.ogg"] = 02.18,
								["03.ogg"] = 02.19,
							},
						},
					},
				},
				["FemaleFrostwolfOrcCiv\\VO_"] = {
					["60_FROSTWOLF_"] = {
						["FEMALE_CIV_"] = {
							["FAREWELL_"] = {
								["01.ogg"] = 01.34,
								["02.ogg"] = 01.27,
								["03.ogg"] = 01.55,
							},
							["GREETING_"] = {
								["01.ogg"] = 01.43,
								["02.ogg"] = 01.07,
								["03.ogg"] = 01.99,
								["04.ogg"] = 01.44,
							},
						},
					},
				},
				["FemaleHordeGuard\\VO_"] = {
					["60_GAR_"] = {
						["HORDE_GUARD_"] = {
							["FEMALE_"] = {
								["01.ogg"] = 00.87,
								["02.ogg"] = 01.22,
								["03.ogg"] = 01.34,
								["04.ogg"] = 01.01,
								["05.ogg"] = 01.55,
								["06.ogg"] = 01.28,
								["07.ogg"] = 01.82,
							},
						},
					},
				},
				["FemaleTitan\\"] = {
					["FemaleTitanAggro.ogg"] = 01.54,
					["FemaleTitanAttackA.ogg"] = 02.18,
					["FemaleTitanAttackB.ogg"] = 02.14,
					["FemaleTitanAttackC.ogg"] = 01.46,
					["FemaleTitanAttackD.ogg"] = 01.43,
					["FemaleTitanAttackE.ogg"] = 01.53,
					["FemaleTitanDeath.ogg"] = 03.10,
					["FemaleTitanPreAggro.ogg"] = 01.20,
					["FemaleTitanWoundA.ogg"] = 01.03,
					["FemaleTitanWoundB.ogg"] = 01.13,
					["FemaleTitanWoundC.ogg"] = 01.18,
					["FemaleTitanWoundCrit.ogg"] = 01.46,
					["FemaleTitanWoundD.ogg"] = 01.12,
				},
				["FemDraeneiPrisoner\\VO_"] = {
					["60_TANAAN_"] = {
						["HOLLOW_PRISONERS_"] = {
							["03.ogg"] = 02.00,
							["04.ogg"] = 02.16,
							["06.ogg"] = 04.11,
							["07.ogg"] = 02.25,
						},
					},
				},
				["FengTheAccursed\\VO_"] = {
					["Feng_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 02.20,
							["02.OGG"] = 01.57,
							["03.OGG"] = 01.68,
							["04.OGG"] = 01.91,
							["05.OGG"] = 01.51,
						},
						["Attack_"] = {
							["01.OGG"] = 00.85,
							["02.OGG"] = 00.74,
							["03.OGG"] = 00.98,
							["04.OGG"] = 01.11,
							["05.OGG"] = 01.00,
							["06.OGG"] = 00.86,
							["07.OGG"] = 00.77,
							["08.OGG"] = 01.03,
							["09.OGG"] = 00.94,
							["10.OGG"] = 00.80,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.43,
							["02.OGG"] = 01.40,
							["03.OGG"] = 01.70,
							["04.OGG"] = 01.75,
							["05.OGG"] = 01.06,
						},
						["Wound_"] = {
							["01.OGG"] = 00.80,
							["02.OGG"] = 00.98,
							["03.OGG"] = 01.03,
							["04.OGG"] = 01.17,
							["05.OGG"] = 00.91,
							["06.OGG"] = 01.12,
							["07.OGG"] = 01.28,
							["08.OGG"] = 01.20,
							["09.OGG"] = 01.19,
						},
					},
					["MV_FENG_"] = {
						["SLAY_"] = {
							["01.OGG"] = 03.87,
							["02.OGG"] = 03.25,
						},
						["AGGRO_01.OGG"] = 06.65,
						["DEATH_01.OGG"] = 05.82,
						["FIST_01.OGG"] = 05.50,
						["INTRO_01.OGG"] = 03.13,
						["SHIELD_01.OGG"] = 06.34,
						["SPEAR_01.OGG"] = 06.65,
						["STAFF_01.OGG"] = 06.66,
					},
				},
				["Fenris\\VO_"] = {
					["60_FFR_"] = {
						["THUNDERFALL_FENRIS_"] = {
							["01.OGG"] = 09.49,
							["02.OGG"] = 04.40,
							["03.OGG"] = 01.73,
							["04.OGG"] = 03.12,
							["05.OGG"] = 07.87,
							["06.OGG"] = 02.96,
							["07.OGG"] = 05.87,
							["08.OGG"] = 04.42,
							["09.OGG"] = 08.95,
						},
						["WORGOL_FENRIS_"] = {
							["01.OGG"] = 07.53,
							["02.OGG"] = 04.23,
							["03.OGG"] = 02.06,
							["04.OGG"] = 05.11,
							["05.OGG"] = 05.09,
							["06.OGG"] = 04.70,
						},
					},
				},
				["Festergut\\IC_"] = {
					["Festergut_"] = {
						["Aggro01.ogg"] = 01.61,
						["Attack01.ogg"] = 01.86,
						["Attack02.ogg"] = 01.72,
						["Attack03.ogg"] = 01.72,
						["Attack04.ogg"] = 01.37,
						["Attack05.ogg"] = 01.13,
						["Attack06.ogg"] = 01.12,
						["Attack07.ogg"] = 00.92,
						["Attack08.ogg"] = 01.22,
						["Attack09.ogg"] = 01.00,
						["Attack10.ogg"] = 00.86,
						["Beserk01.ogg"] = 03.03,
						["Death01.ogg"] = 04.47,
						["ExpungeBlight01.ogg"] = 05.68,
						["GasSpore01.ogg"] = 01.47,
						["RotfaceDies01.ogg"] = 06.33,
						["Slay01.ogg"] = 03.25,
						["Slay02.ogg"] = 04.51,
						["Wound01.ogg"] = 01.03,
						["Wound02.ogg"] = 01.03,
						["Wound03.ogg"] = 01.11,
						["Wound04.ogg"] = 00.73,
						["Wound05.ogg"] = 00.77,
						["Wound06.ogg"] = 00.83,
						["Wound07.ogg"] = 00.92,
						["Wound08.ogg"] = 01.09,
						["Wound09.ogg"] = 00.86,
						["WoundCrit01.ogg"] = 01.64,
						["WoundCrit02.ogg"] = 02.26,
						["WoundCrit03.ogg"] = 00.93,
						["WoundCrit04.ogg"] = 01.02,
						["WoundCrit05.ogg"] = 02.38,
						["WoundCrit06.ogg"] = 01.07,
						["WoundCrit07.ogg"] = 01.25,
					},
				},
				["Feugen\\FEU_"] = {
					["NAXX_"] = {
						["AGGRO.ogg"] = 02.51,
						["DEATH.ogg"] = 07.58,
						["SLAY.ogg"] = 03.20,
					},
				},
				["Finkle\\VO_"] = {
					["BD_Finkle_"] = {
						["Attack01.ogg"] = 00.49,
						["Attack02.ogg"] = 00.39,
						["Attack03.ogg"] = 00.53,
						["Attack04.ogg"] = 00.48,
						["Attack05.ogg"] = 00.64,
						["Attack06.ogg"] = 00.70,
						["Attack07.ogg"] = 00.50,
						["Attack08.ogg"] = 00.51,
						["AttackCritical01.ogg"] = 01.09,
						["AttackCritical02.ogg"] = 00.95,
						["AttackCritical03.ogg"] = 01.10,
						["AttackCritical04.ogg"] = 01.50,
						["Event01.ogg"] = 03.06,
						["Event02.ogg"] = 02.47,
						["Event03.ogg"] = 01.45,
						["Event04.ogg"] = 01.12,
						["Event05.ogg"] = 03.85,
						["Event06.ogg"] = 07.85,
						["Event07.ogg"] = 04.69,
						["Wound01.ogg"] = 00.56,
						["Wound02.ogg"] = 00.52,
						["Wound03.ogg"] = 00.63,
						["Wound04.ogg"] = 00.59,
						["Wound05.ogg"] = 00.70,
						["Wound06.ogg"] = 00.77,
						["Wound07.ogg"] = 00.71,
						["Wound08.ogg"] = 00.70,
						["WoundCritical01.ogg"] = 01.39,
						["WoundCritical02.ogg"] = 01.17,
						["WoundCritical03.ogg"] = 00.81,
						["WoundCritical04.ogg"] = 01.17,
					},
				},
				["FireElemental\\MON_"] = {
					["FireElementalDraenor_"] = {
						["Aggro_"] = {
							["01.ogg"] = 03.07,
							["02.ogg"] = 03.72,
							["03.ogg"] = 02.93,
							["04.ogg"] = 02.37,
							["05.ogg"] = 02.02,
						},
						["AttackCrit_"] = {
							["010.ogg"] = 02.44,
							["02.ogg"] = 02.32,
							["03.ogg"] = 02.31,
							["04.ogg"] = 02.70,
							["05.ogg"] = 01.85,
							["06.ogg"] = 02.16,
							["07.ogg"] = 02.01,
							["08.ogg"] = 02.39,
							["09.ogg"] = 02.42,
						},
						["Attack_"] = {
							["01.ogg"] = 01.47,
							["010.ogg"] = 02.21,
							["02.ogg"] = 01.44,
							["03.ogg"] = 01.74,
							["04.ogg"] = 01.81,
							["05.ogg"] = 01.68,
							["06.ogg"] = 01.56,
							["07.ogg"] = 01.66,
							["08.ogg"] = 01.74,
							["09.ogg"] = 02.15,
						},
						["BattleRoar_"] = {
							["01.ogg"] = 02.48,
							["02.ogg"] = 02.42,
							["03.ogg"] = 02.39,
							["04.ogg"] = 02.16,
							["05.ogg"] = 02.47,
						},
						["Death_"] = {
							["01.ogg"] = 05.64,
							["02.ogg"] = 05.91,
							["03.ogg"] = 05.50,
							["04.ogg"] = 05.74,
							["05.ogg"] = 05.80,
							["06.ogg"] = 06.17,
						},
						["PreAggro_"] = {
							["01.ogg"] = 01.26,
							["02.ogg"] = 00.85,
							["03.ogg"] = 00.87,
							["04.ogg"] = 01.71,
							["05.ogg"] = 01.99,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.35,
							["02.ogg"] = 01.47,
							["03.ogg"] = 01.66,
							["04.ogg"] = 01.75,
							["05.ogg"] = 01.90,
							["06.ogg"] = 01.85,
							["07.ogg"] = 01.58,
							["08.ogg"] = 01.99,
							["09.ogg"] = 01.87,
						},
						["Wound_"] = {
							["01.ogg"] = 01.08,
							["010.ogg"] = 01.45,
							["02.ogg"] = 00.98,
							["03.ogg"] = 00.94,
							["04.ogg"] = 01.23,
							["05.ogg"] = 01.53,
							["06.ogg"] = 01.54,
							["07.ogg"] = 01.55,
							["08.ogg"] = 01.68,
							["09.ogg"] = 01.74,
						},
					},
				},
				["FireFly\\"] = {
					["PET_Firefly_"] = {
						["Clickable01.ogg"] = 01.69,
						["Clickable02.ogg"] = 01.22,
						["Clickable03.ogg"] = 01.49,
						["Clickable04.ogg"] = 01.23,
						["Clickable05.ogg"] = 01.57,
						["Clickable06.ogg"] = 01.32,
						["Clickable07.ogg"] = 01.42,
						["Clickable08.ogg"] = 02.45,
						["Clickable09.ogg"] = 02.23,
					},
					["FireFlyAggro.ogg"] = 02.45,
					["FireFlyAttackA.ogg"] = 01.06,
					["FireFlyAttackB.ogg"] = 01.13,
					["FireFlyAttackC.ogg"] = 00.92,
					["FireFlyAttackD.ogg"] = 01.21,
					["FireFlyAttackE.ogg"] = 01.36,
					["FireFlyDeath.ogg"] = 01.04,
					["FireFlyPreAggro.ogg"] = 02.67,
					["FireFlyWoundA.ogg"] = 01.43,
					["FireFlyWoundB.ogg"] = 01.32,
					["FireFlyWoundC.ogg"] = 01.11,
					["FireFlyWoundCrit.ogg"] = 01.77,
					["FireFlyWoundD.ogg"] = 01.03,
				},
				["FIREHAWK\\MON_"] = {
					["Firehawk_"] = {
						["Aggro_"] = {
							["01.ogg"] = 02.08,
							["02.ogg"] = 02.25,
							["03.ogg"] = 02.77,
							["04.ogg"] = 01.86,
							["05.ogg"] = 01.91,
							["06.ogg"] = 01.86,
							["07.ogg"] = 02.43,
							["08.ogg"] = 02.00,
							["09.ogg"] = 02.07,
							["10.ogg"] = 02.69,
						},
						["Attack_"] = {
							["01.ogg"] = 02.50,
							["02.ogg"] = 02.43,
							["03.ogg"] = 02.88,
							["04.ogg"] = 02.77,
							["05.ogg"] = 02.69,
							["06.ogg"] = 02.50,
							["07.ogg"] = 02.43,
							["08.ogg"] = 02.12,
							["09.ogg"] = 01.86,
							["10.ogg"] = 02.50,
						},
						["Death_"] = {
							["01.ogg"] = 04.17,
							["02.ogg"] = 04.33,
							["03.ogg"] = 04.43,
							["04.ogg"] = 04.17,
							["05.ogg"] = 04.26,
							["06.ogg"] = 04.03,
							["07.ogg"] = 04.19,
							["08.ogg"] = 04.33,
							["09.ogg"] = 04.17,
							["10.ogg"] = 04.77,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.86,
							["02.ogg"] = 02.00,
							["03.ogg"] = 02.27,
							["04.ogg"] = 02.11,
							["05.ogg"] = 02.18,
						},
						["Wound_"] = {
							["01.ogg"] = 01.86,
							["02.ogg"] = 02.00,
							["03.ogg"] = 02.27,
							["04.ogg"] = 02.11,
							["05.ogg"] = 02.18,
							["06.ogg"] = 01.98,
							["07.ogg"] = 01.73,
							["08.ogg"] = 01.73,
							["09.ogg"] = 01.54,
							["10.ogg"] = 01.46,
						},
					},
				},
				["FireSpiderBossSmall\\MON_"] = {
					["FireSpiderBossSmall_"] = {
						["Aggro_"] = {
							["01.ogg"] = 01.44,
							["02.ogg"] = 01.39,
							["03.ogg"] = 01.43,
							["04.ogg"] = 01.78,
							["05.ogg"] = 01.41,
							["06.ogg"] = 01.37,
							["07.ogg"] = 01.47,
							["08.ogg"] = 01.81,
							["09.ogg"] = 01.41,
							["10.ogg"] = 01.57,
						},
						["Attack_"] = {
							["01.ogg"] = 01.44,
							["02.ogg"] = 01.41,
							["03.ogg"] = 01.38,
							["04.ogg"] = 01.74,
							["05.ogg"] = 01.25,
							["06.ogg"] = 01.60,
							["07.ogg"] = 01.50,
							["08.ogg"] = 01.81,
							["09.ogg"] = 01.41,
							["10.ogg"] = 01.73,
						},
						["Death_"] = {
							["01.ogg"] = 03.40,
							["02.ogg"] = 02.91,
							["03.ogg"] = 02.63,
							["04.ogg"] = 02.76,
							["05.ogg"] = 03.41,
							["06.ogg"] = 03.05,
							["07.ogg"] = 03.84,
							["08.ogg"] = 03.71,
							["09.ogg"] = 03.23,
							["10.ogg"] = 03.25,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.20,
							["02.ogg"] = 01.28,
							["03.ogg"] = 01.18,
							["04.ogg"] = 01.31,
							["05.ogg"] = 01.41,
						},
						["Wound_"] = {
							["01.ogg"] = 01.20,
							["02.ogg"] = 00.95,
							["03.ogg"] = 01.21,
							["04.ogg"] = 01.31,
							["05.ogg"] = 01.41,
							["06.ogg"] = 01.22,
							["07.ogg"] = 01.08,
							["08.ogg"] = 01.69,
							["09.ogg"] = 01.41,
							["10.ogg"] = 01.53,
						},
					},
				},
				["FireSpirit\\MON_"] = {
					["FireSpirit_"] = {
						["Attack01.OGG"] = 01.68,
						["Attack02.OGG"] = 01.70,
						["Attack03.OGG"] = 01.88,
						["Attack04.OGG"] = 02.00,
						["Attack05.OGG"] = 02.29,
						["Attack06.OGG"] = 02.02,
						["Attack07.OGG"] = 02.02,
						["Attack08.OGG"] = 02.42,
						["Attack09.OGG"] = 02.05,
						["Attack10.OGG"] = 02.00,
						["AttackCrit01.OGG"] = 02.22,
						["AttackCrit02.OGG"] = 02.56,
						["AttackCrit03.OGG"] = 02.36,
						["AttackCrit04.OGG"] = 02.61,
						["AttackCrit05.OGG"] = 02.53,
						["BattleRoar01.OGG"] = 02.70,
						["Death01.OGG"] = 05.25,
						["Death02.OGG"] = 05.50,
						["Death03.OGG"] = 05.38,
						["Death04.OGG"] = 05.27,
						["Death05.OGG"] = 05.53,
						["Wound01.OGG"] = 01.31,
						["Wound02.OGG"] = 01.58,
						["Wound03.OGG"] = 01.62,
						["Wound04.OGG"] = 01.51,
						["Wound05.OGG"] = 01.62,
						["Wound06.OGG"] = 01.89,
						["Wound07.OGG"] = 02.03,
						["Wound08.OGG"] = 01.76,
						["Wound09.OGG"] = 01.67,
						["Wound10.OGG"] = 01.79,
						["WoundCrit01.OGG"] = 02.24,
						["WoundCrit02.OGG"] = 02.26,
						["WoundCrit03.OGG"] = 02.15,
						["WoundCrit04.OGG"] = 02.23,
						["WoundCrit05.OGG"] = 01.89,
					},
				},
				["FlamebenderKagraz\\VO_"] = {
					["60_"] = {
						["BFR_KAGRAZ_"] = {
							["CYCLONE_"] = {
								["01.OGG"] = 01.52,
								["02.OGG"] = 02.58,
								["03.OGG"] = 03.84,
								["04.OGG"] = 01.33,
							},
							["SLAY_"] = {
								["01.OGG"] = 02.26,
								["02.OGG"] = 01.47,
							},
							["SPELL_"] = {
								["01.OGG"] = 01.46,
								["02.OGG"] = 03.47,
								["03.OGG"] = 01.85,
							},
							["WOLVES_"] = {
								["01.OGG"] = 01.52,
								["02.OGG"] = 01.94,
								["03.OGG"] = 02.85,
							},
							["AGGRO.OGG"] = 04.22,
							["BERSERK.OGG"] = 05.86,
							["DEATH.OGG"] = 05.54,
							["INTRO.OGG"] = 05.53,
							["RESET.OGG"] = 04.48,
							["AKNOR_DIES.OGG"] = 03.29,
						},
						["KAGRAZ_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 02.46,
								["02.OGG"] = 00.82,
								["03.OGG"] = 01.45,
								["04.OGG"] = 02.63,
								["05.OGG"] = 01.19,
							},
							["Attack_"] = {
								["01.OGG"] = 00.55,
								["010.OGG"] = 00.75,
								["02.OGG"] = 00.54,
								["03.OGG"] = 00.97,
								["04.OGG"] = 00.56,
								["05.OGG"] = 00.43,
								["06.OGG"] = 00.44,
								["07.OGG"] = 01.04,
								["08.OGG"] = 00.73,
								["09.OGG"] = 00.81,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 02.51,
								["02.OGG"] = 01.54,
								["03.OGG"] = 00.91,
								["04.OGG"] = 00.93,
								["05.OGG"] = 01.11,
							},
							["Wound_"] = {
								["01.OGG"] = 00.58,
								["010.OGG"] = 00.75,
								["02.OGG"] = 00.74,
								["03.OGG"] = 00.81,
								["04.OGG"] = 00.81,
								["05.OGG"] = 00.71,
								["06.OGG"] = 00.68,
								["07.OGG"] = 00.48,
								["08.OGG"] = 00.82,
								["09.OGG"] = 00.69,
							},
						},
					},
				},
				["FlameDruidFemale\\VO_"] = {
					["FLAME_DRUID_"] = {
						["FEMALE_"] = {
							["ATTACK01.ogg"] = 01.03,
							["ATTACK02.ogg"] = 01.23,
							["ATTACK03.ogg"] = 01.23,
							["ATTACK04.ogg"] = 01.39,
							["ATTACK05.ogg"] = 01.39,
							["ATTACK06.ogg"] = 01.23,
							["ATTACK07.ogg"] = 01.45,
							["ATTACK08.ogg"] = 01.40,
							["ATTACK09.ogg"] = 01.45,
							["ATTACK10.ogg"] = 01.59,
							["ATTACKCRIT01.ogg"] = 02.18,
							["ATTACKCRIT02.ogg"] = 02.01,
							["ATTACKCRIT03.ogg"] = 01.80,
							["ATTACKCRIT04.ogg"] = 01.65,
							["ATTACKCRIT05.ogg"] = 01.82,
							["DEATH01.ogg"] = 06.87,
							["DEATH02.ogg"] = 03.57,
							["DEATH03.ogg"] = 02.51,
							["DEATH04.ogg"] = 03.26,
							["DEATH05.ogg"] = 04.29,
							["LAUGH01.ogg"] = 02.28,
							["LAUGH02.ogg"] = 04.08,
							["SPELLCAST01.ogg"] = 01.17,
							["SPELLCAST02.ogg"] = 01.52,
							["WOUND01.ogg"] = 01.35,
							["WOUND02.ogg"] = 01.43,
							["WOUND03.ogg"] = 01.44,
							["WOUND04.ogg"] = 01.48,
							["WOUND05.ogg"] = 01.34,
							["WOUND06.ogg"] = 01.26,
							["WOUND07.ogg"] = 01.10,
							["WOUND08.ogg"] = 01.52,
							["WOUND09.ogg"] = 01.09,
							["WOUND10.ogg"] = 01.66,
							["WOUNDCRIT01.ogg"] = 01.97,
							["WOUNDCRIT02.ogg"] = 02.36,
							["WOUNDCRIT03.ogg"] = 01.78,
							["WOUNDCRIT04.ogg"] = 01.88,
							["WOUNDCRIT05.ogg"] = 01.66,
						},
					},
					["FL_FLAME_"] = {
						["DRUID_FEMALE_"] = {
							["ALYSRAZOR_ATTACK_"] = {
								["01.ogg"] = 03.28,
								["02.ogg"] = 02.59,
								["03.ogg"] = 04.01,
								["04.ogg"] = 05.13,
							},
						},
					},
				},
				["FlameDruidMale\\VO_"] = {
					["FLAME_DRUID_"] = {
						["MALE_"] = {
							["ATTACK01.ogg"] = 01.68,
							["ATTACK02.ogg"] = 01.73,
							["ATTACK03.ogg"] = 01.63,
							["ATTACK04.ogg"] = 01.73,
							["ATTACK05.ogg"] = 01.74,
							["ATTACK06.ogg"] = 01.66,
							["ATTACK07.ogg"] = 01.63,
							["ATTACK08.ogg"] = 01.71,
							["ATTACK09.ogg"] = 01.88,
							["ATTACK10.ogg"] = 01.62,
							["ATTACKCRIT01.ogg"] = 02.19,
							["ATTACKCRIT02.ogg"] = 02.16,
							["ATTACKCRIT03.ogg"] = 02.39,
							["ATTACKCRIT04.ogg"] = 02.42,
							["ATTACKCRIT05.ogg"] = 02.26,
							["DEATH01.ogg"] = 03.61,
							["DEATH02.ogg"] = 04.09,
							["DEATH03.ogg"] = 03.11,
							["DEATH04.ogg"] = 02.40,
							["DEATH05.ogg"] = 02.72,
							["LAUGH01.ogg"] = 03.68,
							["LAUGH02.ogg"] = 03.84,
							["SPELLCAST01.ogg"] = 02.38,
							["SPELLCAST02.ogg"] = 02.00,
							["WOUND01.ogg"] = 01.66,
							["WOUND02.ogg"] = 01.70,
							["WOUND03.ogg"] = 01.70,
							["WOUND04.ogg"] = 01.71,
							["WOUND05.ogg"] = 01.68,
							["WOUND06.ogg"] = 01.71,
							["WOUND07.ogg"] = 01.78,
							["WOUND08.ogg"] = 01.84,
							["WOUND09.ogg"] = 01.63,
							["WOUND10.ogg"] = 01.68,
							["WOUNDCRIT01.ogg"] = 02.39,
							["WOUNDCRIT02.ogg"] = 02.64,
							["WOUNDCRIT03.ogg"] = 02.30,
							["WOUNDCRIT04.ogg"] = 02.16,
							["WOUNDCRIT05.ogg"] = 02.43,
						},
					},
					["FL_FLAME_"] = {
						["DRUID_MALE_"] = {
							["ALYSRAZOR_"] = {
								["ATTACK_"] = {
									["01.ogg"] = 05.16,
									["02.ogg"] = 03.52,
									["03.ogg"] = 04.28,
									["04.ogg"] = 04.61,
								},
								["DEATH.ogg"] = 04.33,
								["METEOR_01.ogg"] = 05.05,
							},
						},
					},
				},
				["FlameLeviathan\\UR_"] = {
					["Leviathan_"] = {
						["Aggro01.ogg"] = 09.98,
						["Death01.ogg"] = 09.13,
						["HardmodeOn.ogg"] = 02.29,
						["Overload01.ogg"] = 05.21,
						["Overload02.ogg"] = 06.49,
						["Overload03.ogg"] = 05.35,
						["PlayerRiding.ogg"] = 07.04,
						["Slay01.ogg"] = 08.25,
						["Target01.ogg"] = 05.73,
						["Target02.ogg"] = 03.95,
						["Target03.ogg"] = 06.27,
						["TowerEnergy.ogg"] = 04.04,
						["TowerFire.ogg"] = 04.26,
						["TowerFrost.ogg"] = 04.36,
						["TowerNature.ogg"] = 03.93,
						["TowerNone.ogg"] = 05.71,
					},
				},
				["FlameweaverKoegler\\VO_"] = {
					["SH_SPELLMASTER_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.58,
							["02.OGG"] = 01.23,
							["03.OGG"] = 01.64,
							["04.OGG"] = 01.53,
							["05.OGG"] = 01.92,
						},
						["Attack_"] = {
							["01.OGG"] = 00.74,
							["02.OGG"] = 00.62,
							["03.OGG"] = 00.45,
							["04.OGG"] = 00.50,
							["05.OGG"] = 00.70,
							["06.OGG"] = 00.82,
							["07.OGG"] = 00.67,
							["08.OGG"] = 00.70,
							["09.OGG"] = 00.54,
							["10.OGG"] = 00.45,
						},
						["SLAY_"] = {
							["01.OGG"] = 04.36,
							["02.OGG"] = 03.19,
						},
						["SPELL_"] = {
							["01.OGG"] = 03.18,
							["02.OGG"] = 03.06,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.14,
							["02.OGG"] = 01.93,
							["03.OGG"] = 01.25,
							["04.OGG"] = 01.01,
							["05.OGG"] = 01.48,
						},
						["Wound_"] = {
							["01.OGG"] = 00.69,
							["02.OGG"] = 01.16,
							["03.OGG"] = 00.60,
							["04.OGG"] = 00.63,
							["05.OGG"] = 00.59,
							["06.OGG"] = 00.58,
							["07.OGG"] = 00.67,
							["08.OGG"] = 00.73,
							["09.OGG"] = 00.67,
							["10.OGG"] = 00.54,
						},
						["AGGRO_01.OGG"] = 04.48,
						["DEATH_01.OGG"] = 04.83,
						["INTRO_01.OGG"] = 06.42,
					},
				},
				["flaminghippogryphmount\\Flaming_"] = {
					["Hippogryph_MountSpecial_"] = {
						["01.ogg"] = 01.63,
						["02.ogg"] = 01.82,
						["03.ogg"] = 02.07,
					},
				},
				["FleshBeast\\"] = {
					["FleshBeastAggro.ogg"] = 02.64,
					["FleshBeastAttackA.ogg"] = 01.14,
					["FleshBeastAttackB.ogg"] = 01.40,
					["FleshBeastAttackC.ogg"] = 01.53,
					["FleshBeastAttackD.ogg"] = 01.22,
					["FleshBeastAttackE.ogg"] = 01.28,
					["FleshBeastDeath.ogg"] = 01.21,
					["FleshBeastPreAggro.ogg"] = 01.17,
					["FleshBeastWoundA.ogg"] = 01.25,
					["FleshBeastWoundB.ogg"] = 01.43,
					["FleshBeastWoundC.ogg"] = 01.14,
					["FleshBeastWoundCrit.ogg"] = 01.24,
					["FleshBeastWoundD.ogg"] = 00.96,
				},
				["FleshGiant\\"] = {
					["FleshGiantAttackA.ogg"] = 02.19,
					["FleshGiantAttackB.ogg"] = 01.56,
					["FleshGiantAttackC.ogg"] = 01.92,
					["FleshGiantAttackD.ogg"] = 01.47,
					["FleshGiantDeath.ogg"] = 04.34,
					["FleshGiantLoop.ogg"] = 04.99,
					["FleshGiantWoundA.ogg"] = 02.05,
					["FleshGiantWoundB.ogg"] = 01.58,
					["FleshGiantWoundC.ogg"] = 01.86,
					["FleshGiantWoundCrit.ogg"] = 02.65,
				},
				["FleshGolem\\"] = {
					["FleshGolemAggroA.ogg"] = 01.62,
					["FleshGolemAttackA.ogg"] = 00.66,
					["FleshGolemAttackB.ogg"] = 01.02,
					["FleshGolemAttackC.ogg"] = 00.78,
					["FleshGolemAttackD.ogg"] = 00.87,
					["FleshGolemBelch.ogg"] = 02.25,
					["FleshGolemDeathA.ogg"] = 02.50,
					["FleshGolemLoop.ogg"] = 19.42,
					["FleshGolemPreAggroA.ogg"] = 00.59,
					["FleshGolemWoundA.ogg"] = 00.66,
					["FleshGolemWoundB.ogg"] = 00.74,
					["FleshGolemWoundC.ogg"] = 00.76,
					["FleshGolemWoundCritA.ogg"] = 01.22,
					["FleshGolemWoundD.ogg"] = 00.94,
				},
				["FleshTitan\\"] = {
					["FleshTitanAggro.ogg"] = 02.13,
					["FleshTitanAttackA.ogg"] = 01.58,
					["FleshTitanAttackB.ogg"] = 01.38,
					["FleshTitanAttackC.ogg"] = 02.32,
					["FleshTitanAttackD.ogg"] = 01.80,
					["FleshTitanDeath.ogg"] = 04.48,
					["FleshTitanWoundA.ogg"] = 01.84,
					["FleshTitanWoundB.ogg"] = 01.11,
					["FleshTitanWoundC.ogg"] = 01.21,
					["FleshTitanWoundCrit.ogg"] = 02.69,
				},
				["Flintlocke\\VO_"] = {
					["QE_Flintlocke_"] = {
						["Event01.ogg"] = 03.79,
						["Event02.ogg"] = 08.24,
						["Event03.ogg"] = 00.76,
						["Event04.ogg"] = 04.32,
						["Event05.ogg"] = 03.24,
						["Event06.ogg"] = 10.70,
						["Event07.ogg"] = 03.58,
						["Event08.ogg"] = 04.32,
						["Farewell01.ogg"] = 02.85,
						["Farewell02.ogg"] = 01.31,
						["Farewell03.ogg"] = 02.10,
						["Greeting01.ogg"] = 02.13,
						["Greeting02.ogg"] = 00.90,
						["Greeting03.ogg"] = 02.73,
						["Greeting04.ogg"] = 01.05,
						["Greeting05.ogg"] = 03.35,
						["Pissed01.ogg"] = 01.94,
						["Pissed02.ogg"] = 03.99,
					},
				},
				["flyingcarpetmount\\FlyingCarpetMount_"] = {
					["Flap_"] = {
						["01.ogg"] = 01.51,
						["02.ogg"] = 01.07,
						["03.ogg"] = 02.32,
						["04.ogg"] = 02.05,
						["05.ogg"] = 01.83,
						["06.ogg"] = 01.16,
						["07.ogg"] = 02.51,
						["08.ogg"] = 02.31,
					},
					["Fly_"] = {
						["01.ogg"] = 07.68,
						["02.ogg"] = 07.95,
						["03.ogg"] = 07.73,
						["04.ogg"] = 06.27,
					},
					["Idle_"] = {
						["01.ogg"] = 08.06,
						["02.ogg"] = 07.52,
						["03.ogg"] = 08.60,
						["04.ogg"] = 06.18,
					},
				},
				["FlyingNerubian\\"] = {
					["FlyingNerubianAggro.ogg"] = 01.76,
					["FlyingNerubianAttackA.ogg"] = 01.42,
					["FlyingNerubianAttackB.ogg"] = 01.23,
					["FlyingNerubianAttackC.ogg"] = 01.66,
					["FlyingNerubianAttackD.ogg"] = 01.66,
					["FlyingNerubianAttackE.ogg"] = 01.89,
					["FlyingNerubianDeath.ogg"] = 03.15,
					["FlyingNerubianPReAggro.ogg"] = 02.65,
					["FlyingNerubianWoundA.ogg"] = 01.23,
					["FlyingNerubianWoundB.ogg"] = 01.44,
					["FlyingNerubianWoundC.ogg"] = 01.35,
					["FlyingNerubianWoundCrit.ogg"] = 02.48,
					["FlyingNerubianWoundD.ogg"] = 02.68,
				},
				["FoeReaper\\VO_"] = {
					["DM_FoeReaper_"] = {
						["Aggro01.ogg"] = 04.57,
						["Death01.ogg"] = 07.33,
						["Kill01.ogg"] = 01.79,
						["Spell01.ogg"] = 01.79,
						["Spell02.ogg"] = 03.96,
						["Spell03.ogg"] = 02.36,
						["Spell04.ogg"] = 05.14,
					},
				},
				["FogCreature\\MON_"] = {
					["FOGCREATURE_"] = {
						["AGGRO_"] = {
							["01.OGG"] = 02.86,
							["02.OGG"] = 02.65,
							["03.OGG"] = 03.23,
							["04.OGG"] = 02.88,
							["05.OGG"] = 03.52,
							["06.OGG"] = 03.30,
						},
						["ATTACKCRIT_"] = {
							["01.OGG"] = 03.44,
							["02.OGG"] = 02.90,
							["03.OGG"] = 03.24,
							["04.OGG"] = 02.90,
							["05.OGG"] = 03.14,
						},
						["ATTACK_"] = {
							["01.OGG"] = 02.81,
							["02.OGG"] = 02.47,
							["03.OGG"] = 02.47,
							["04.OGG"] = 02.47,
							["05.OGG"] = 02.47,
							["06.OGG"] = 02.47,
							["07.OGG"] = 02.47,
							["08.OGG"] = 02.47,
							["09.OGG"] = 02.47,
							["10.OGG"] = 02.47,
						},
						["DEATH_"] = {
							["01.OGG"] = 08.91,
							["02.OGG"] = 09.34,
							["03.OGG"] = 09.51,
							["04.OGG"] = 10.44,
							["05.OGG"] = 09.54,
							["06.OGG"] = 10.18,
						},
						["PREAGGRO_"] = {
							["01.OGG"] = 04.78,
							["02.OGG"] = 05.60,
							["03.OGG"] = 04.99,
							["04.OGG"] = 05.01,
							["05.OGG"] = 04.90,
						},
						["ROAR_"] = {
							["01.OGG"] = 05.91,
							["02.OGG"] = 05.77,
							["03.OGG"] = 06.84,
						},
						["STAND_"] = {
							["01.OGG"] = 11.12,
							["02.OGG"] = 11.79,
							["03.OGG"] = 14.51,
							["04.OGG"] = 12.80,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 02.37,
							["02.OGG"] = 02.34,
							["03.OGG"] = 02.34,
							["04.OGG"] = 02.60,
							["05.OGG"] = 02.40,
						},
						["WOUND_"] = {
							["01.OGG"] = 02.49,
							["02.OGG"] = 02.53,
							["03.OGG"] = 02.04,
							["04.OGG"] = 02.07,
							["05.OGG"] = 02.27,
							["06.OGG"] = 02.10,
							["07.OGG"] = 02.24,
							["08.OGG"] = 02.20,
							["09.OGG"] = 02.14,
							["10.OGG"] = 02.17,
						},
						["Creatureloop.OGG"] = 06.55,
					},
				},
				["Footman\\"] = {
					["FootmanYesAttack1.ogg"] = 01.03,
					["FootmanYesAttack2.ogg"] = 01.08,
					["FootmanYesAttack3.ogg"] = 01.15,
				},
				["ForceofNature\\"] = {
					["ForceOfNatureAggro.ogg"] = 02.31,
					["ForceOfNatureAttack.ogg"] = 01.36,
					["ForceOfNatureAttackB.ogg"] = 01.32,
					["ForceOfNatureAttackC.ogg"] = 01.13,
					["ForceOfNatureDeath.ogg"] = 02.19,
					["ForceOfNaturePreAggro.ogg"] = 01.16,
					["ForceOfNatureWoundA.ogg"] = 01.75,
					["ForceOfNatureWoundB.ogg"] = 01.02,
					["ForceOfNatureWoundC.ogg"] = 01.16,
					["ForceOfNatureWoundCrit.ogg"] = 02.35,
				},
				["Foreman\\VO_"] = {
					["60_"] = {
						["FOREMAN_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.76,
								["02.ogg"] = 01.63,
								["03.ogg"] = 01.69,
								["04.ogg"] = 02.27,
								["05.ogg"] = 01.50,
							},
							["Attack_"] = {
								["01.ogg"] = 00.80,
								["010.ogg"] = 00.91,
								["02.ogg"] = 00.80,
								["03.ogg"] = 00.98,
								["04.ogg"] = 00.47,
								["05.ogg"] = 00.57,
								["06.ogg"] = 00.85,
								["07.ogg"] = 00.80,
								["08.ogg"] = 00.55,
								["09.ogg"] = 00.50,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.54,
								["02.ogg"] = 01.33,
								["03.ogg"] = 01.86,
								["04.ogg"] = 01.44,
								["05.ogg"] = 01.74,
							},
							["Wound_"] = {
								["01.ogg"] = 00.56,
								["010.ogg"] = 00.55,
								["02.ogg"] = 00.85,
								["03.ogg"] = 00.53,
								["04.ogg"] = 00.40,
								["05.ogg"] = 00.46,
								["06.ogg"] = 00.61,
								["07.ogg"] = 00.33,
								["08.ogg"] = 00.33,
								["09.ogg"] = 00.30,
							},
						},
						["FR_FURNACE_"] = {
							["FOREMAN_"] = {
								["EVENT_"] = {
									["1.ogg"] = 01.99,
									["2.ogg"] = 03.84,
									["3.ogg"] = 02.11,
									["5.ogg"] = 02.25,
								},
								["KILL_"] = {
									["1.ogg"] = 01.48,
									["2.ogg"] = 01.44,
								},
								["SPELL_"] = {
									["1.ogg"] = 01.48,
									["2.ogg"] = 01.79,
									["3.ogg"] = 01.58,
									["4.ogg"] = 01.54,
								},
								["AGGRO.ogg"] = 03.11,
								["DEATH.ogg"] = 04.15,
								["KILLSALLPLAYERS.ogg"] = 04.71,
							},
						},
					},
				},
				["ForemanMann\\VO_"] = {
					["Jade_Forest_"] = {
						["Fresco_Event_"] = {
							["Mann_"] = {
								["01.OGG"] = 05.86,
								["02.OGG"] = 07.00,
								["03.OGG"] = 05.72,
								["04.OGG"] = 05.84,
								["05.OGG"] = 05.08,
								["06.OGG"] = 06.22,
							},
						},
					},
				},
				["Forest Troll\\"] = {
					["ForestTrollWarcry1.ogg"] = 01.53,
					["ForestTrollYesAttack1.ogg"] = 00.82,
					["ForestTrollYesAttack2.ogg"] = 00.91,
					["ForestTrollYesAttack4.ogg"] = 00.63,
				},
				["ForestTrollMale\\"] = {
					["ForestTrollMaleAggro.ogg"] = 00.91,
					["ForestTrollMaleAttackA.ogg"] = 00.90,
					["ForestTrollMaleAttackB.ogg"] = 00.51,
					["ForestTrollMaleAttackC.ogg"] = 00.79,
					["ForestTrollMaleAttackD.ogg"] = 00.96,
					["ForestTrollMaleAttackE.ogg"] = 00.84,
					["ForestTrollMaleAttackF.ogg"] = 00.81,
					["ForestTrollMaleDeathA.ogg"] = 01.53,
					["ForestTrollMaleDeathB.ogg"] = 01.64,
					["ForestTrollMaleWoundA.ogg"] = 00.27,
					["ForestTrollMaleWoundB.ogg"] = 00.27,
					["ForestTrollMaleWoundC.ogg"] = 00.48,
					["ForestTrollMaleWoundCritA.ogg"] = 01.12,
					["ForestTrollMaleWoundCritB.ogg"] = 01.36,
					["ForestTrollMaleWoundCritC.ogg"] = 00.77,
					["ForestTrollMaleWoundCritD.ogg"] = 01.03,
					["ForestTrollMaleWoundD.ogg"] = 00.44,
					["ForestTrollMaleWoundE.ogg"] = 00.58,
					["ForestTrollMaleWoundF.ogg"] = 00.55,
				},
				["Forgefellow\\VO_"] = {
					["53_Forgefellow_"] = {
						["Scenario_"] = {
							["01.OGG"] = 05.56,
							["02.OGG"] = 18.00,
						},
					},
				},
				["ForgemasterGarfrost\\PS_"] = {
					["Garfrost_"] = {
						["Aggro01.ogg"] = 12.44,
						["Attack01.ogg"] = 01.74,
						["Attack02.ogg"] = 03.21,
						["Attack03.ogg"] = 01.23,
						["Attack04.ogg"] = 00.47,
						["Attack05.ogg"] = 00.57,
						["Attack06.ogg"] = 01.19,
						["Attack07.ogg"] = 00.66,
						["Attack08.ogg"] = 01.05,
						["Attack09.ogg"] = 01.05,
						["Attack10.ogg"] = 01.02,
						["Death01.ogg"] = 10.35,
						["Slay01.ogg"] = 05.92,
						["Slay02.ogg"] = 16.50,
						["SP01.ogg"] = 09.05,
						["SP02.ogg"] = 12.26,
						["Wound01.ogg"] = 00.67,
						["Wound02.ogg"] = 00.72,
						["Wound03.ogg"] = 00.52,
						["Wound04.ogg"] = 00.75,
						["Wound05.ogg"] = 00.64,
						["Wound06.ogg"] = 00.78,
						["Wound07.ogg"] = 00.63,
						["Wound08.ogg"] = 00.83,
						["Wound09.ogg"] = 00.66,
						["Wound10.ogg"] = 01.13,
						["WoundCrit01.ogg"] = 01.05,
						["WoundCrit02.ogg"] = 01.38,
						["WoundCrit03.ogg"] = 01.00,
					},
				},
				["Franzok\\VO_"] = {
					["60_"] = {
						["FRANZOK_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 00.84,
								["02.ogg"] = 00.90,
								["03.ogg"] = 00.86,
								["04.ogg"] = 01.23,
								["05.ogg"] = 01.35,
							},
							["Attack_"] = {
								["01.ogg"] = 00.41,
								["02.ogg"] = 00.57,
								["03.ogg"] = 00.54,
								["04.ogg"] = 00.81,
								["05.ogg"] = 00.74,
								["06.ogg"] = 00.77,
								["07.ogg"] = 00.57,
								["08.ogg"] = 00.42,
								["09.ogg"] = 00.42,
								["10.ogg"] = 00.52,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 00.54,
								["02.ogg"] = 00.93,
								["03.ogg"] = 00.85,
								["04.ogg"] = 00.80,
								["05.ogg"] = 01.04,
							},
							["Wound_"] = {
								["01.ogg"] = 00.64,
								["02.ogg"] = 00.38,
								["03.ogg"] = 00.39,
								["04.ogg"] = 00.58,
								["05.ogg"] = 00.57,
								["06.ogg"] = 00.47,
								["07.ogg"] = 00.61,
								["08.ogg"] = 00.72,
								["09.ogg"] = 00.74,
								["10.ogg"] = 00.68,
							},
						},
						["FR_FRANZOK_"] = {
							["INTRO_"] = {
								["01.ogg"] = 03.27,
								["02.ogg"] = 05.01,
								["03.ogg"] = 04.33,
								["04.ogg"] = 06.52,
							},
							["SPELL_"] = {
								["01.ogg"] = 02.05,
								["02.ogg"] = 03.58,
								["03.ogg"] = 05.78,
								["04.ogg"] = 04.57,
							},
							["AGGRO.ogg"] = 02.89,
							["DEATH.ogg"] = 05.86,
							["KILL.ogg"] = 03.20,
						},
					},
				},
				["Frenzy\\"] = {
					["mFrenzyAggroA.ogg"] = 02.00,
					["mFrenzyAttackA.ogg"] = 01.69,
					["mFrenzyAttackB.ogg"] = 02.36,
					["mFrenzyAttackC.ogg"] = 02.46,
					["mFrenzyDeathA.ogg"] = 03.73,
					["mFrenzyWoundA.ogg"] = 02.42,
					["mFrenzyWoundB.ogg"] = 02.39,
					["mFrenzyWoundC.ogg"] = 02.18,
				},
				["Freya\\UR_"] = {
					["Freya_"] = {
						["Adds01.ogg"] = 03.07,
						["Adds02.ogg"] = 01.90,
						["Adds03.ogg"] = 03.32,
						["Aggro01.ogg"] = 03.25,
						["AggroElder01.ogg"] = 03.75,
						["Attack01.ogg"] = 01.17,
						["Attack02.ogg"] = 00.77,
						["Attack03.ogg"] = 01.05,
						["Attack04.ogg"] = 01.48,
						["Attack05.ogg"] = 00.98,
						["Attack06.ogg"] = 01.96,
						["Berserk01.ogg"] = 04.14,
						["Death01.ogg"] = 10.23,
						["Slay01.ogg"] = 01.21,
						["Slay02.ogg"] = 03.58,
						["Wound01.ogg"] = 00.71,
						["Wound02.ogg"] = 00.59,
						["Wound03.ogg"] = 00.79,
						["Wound04.ogg"] = 01.11,
						["Wound05.ogg"] = 01.04,
						["Wound06.ogg"] = 01.36,
						["Wound07.ogg"] = 01.55,
						["Wound08.ogg"] = 01.32,
						["Wound09.ogg"] = 01.56,
						["YSHelp01.ogg"] = 04.51,
					},
				},
				["Frog\\"] = {
					["Float.ogg"] = 00.41,
					["FrogDeathA.ogg"] = 00.41,
					["FrogFootstep1.ogg"] = 00.23,
					["FrogFootstep2.ogg"] = 00.51,
					["FrogWoundA.ogg"] = 00.41,
				},
				["FrostLord\\"] = {
					["FrostLordAttackA.ogg"] = 02.06,
					["FrostLordAttackB.ogg"] = 02.01,
					["FrostLordAttackC.ogg"] = 02.31,
					["FrostLordAttackD.ogg"] = 02.47,
					["FrostLordAttackE.ogg"] = 02.54,
					["FrostLordAttackF.ogg"] = 02.93,
					["FrostLordAttackG.ogg"] = 03.11,
					["FrostLordBirth.ogg"] = 06.01,
					["FrostLordDeath.ogg"] = 13.46,
					["FrostLordLoop.ogg"] = 23.79,
					["FrostLordSubmerge.ogg"] = 07.38,
					["FrostLordWoundA.ogg"] = 01.77,
					["FrostLordWoundB.ogg"] = 01.38,
					["FrostLordWoundC.ogg"] = 00.97,
					["FrostLordWoundD.ogg"] = 01.60,
					["FrostLordWoundE.ogg"] = 01.64,
					["FrostLordWoundF.ogg"] = 01.55,
					["FrostLordWoundG.ogg"] = 02.04,
					["FrostLordWoundH.ogg"] = 01.78,
				},
				["FrostNymph\\FrostNymph_"] = {
					["Aggro_"] = {
						["01.ogg"] = 00.92,
						["02.ogg"] = 00.83,
					},
					["Attack_"] = {
						["01.ogg"] = 01.00,
						["02.ogg"] = 01.00,
						["03.ogg"] = 01.00,
						["04.ogg"] = 01.00,
						["05.ogg"] = 01.00,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 00.91,
						["02.ogg"] = 00.73,
						["03.ogg"] = 00.73,
					},
					["Wound_"] = {
						["01.ogg"] = 00.63,
						["02.ogg"] = 00.63,
						["03.ogg"] = 00.63,
						["04.ogg"] = 00.63,
						["05.ogg"] = 00.63,
					},
					["Death_01.ogg"] = 01.33,
					["PreAggro_01.ogg"] = 00.46,
				},
				["FrostwornGeneral\\IC_"] = {
					["FrostswornGeneral_"] = {
						["Event01.ogg"] = 06.11,
						["Event02.ogg"] = 04.72,
					},
				},
				["FrostWurmFelFire\\"] = {
					["FrostWurmFelFireAggro.ogg"] = 04.24,
					["FrostWurmFelFireAttackA.ogg"] = 03.73,
					["FrostWurmFelFireAttackB.ogg"] = 03.66,
					["FrostWurmFelFireAttackC.ogg"] = 03.30,
					["FrostWurmFelFireAttackD.ogg"] = 03.66,
					["FrostWurmFelFireDeath.ogg"] = 07.00,
					["FrostWurmFelFireWoundA.ogg"] = 02.54,
					["FrostWurmFelFireWoundB.ogg"] = 02.38,
					["FrostWurmFelFireWoundC.ogg"] = 02.23,
					["FrostWurmFelFireWoundCritA.ogg"] = 02.73,
					["FrostWurmFelFireWoundCritB.ogg"] = 03.08,
					["FrostWurmFelFireWoundD.ogg"] = 02.57,
				},
				["FrostWyrm\\"] = {
					["FrostWyrmAttackA.ogg"] = 04.05,
					["FrostWyrmAttackB.ogg"] = 04.04,
					["FrostWyrmAttackC.ogg"] = 03.68,
					["FrostWyrmAttackD.ogg"] = 02.73,
					["FrostWyrmAttackE.ogg"] = 02.37,
					["FrostWyrmDeath.ogg"] = 04.09,
					["FrostWyrmWoundA.ogg"] = 01.78,
					["FrostWyrmWoundB.ogg"] = 02.26,
					["FrostWyrmWoundC.ogg"] = 02.09,
					["FrostWyrmWoundCrit.ogg"] = 03.59,
					["Naxxramas_Frostwyrm_BirthCustom0.ogg"] = 24.75,
				},
				["FrostWyrmPet\\FrostWyrmPet_"] = {
					["Clickable01.ogg"] = 01.75,
					["Clickable02.ogg"] = 02.30,
					["Clickable03.ogg"] = 01.83,
				},
				["FuelRobot\\FuelRobotClick_"] = {
					["01.ogg"] = 01.51,
					["02.ogg"] = 03.08,
					["03.ogg"] = 01.22,
					["04.ogg"] = 01.60,
					["05.ogg"] = 02.48,
					["06.ogg"] = 02.42,
					["07.ogg"] = 03.52,
				},
				["FungalGiant\\"] = {
					["FungalGiantAggro.ogg"] = 01.63,
					["FungalGiantAttackA.ogg"] = 02.21,
					["FungalGiantAttackB.ogg"] = 02.49,
					["FungalGiantAttackC.ogg"] = 01.92,
					["FungalGiantAttackD.ogg"] = 02.19,
					["FungalGiantAttackE.ogg"] = 01.96,
					["FungalGiantB.ogg"] = 01.90,
					["FungalGiantDeath.ogg"] = 07.58,
					["FungalGiantPreAggro.ogg"] = 01.58,
					["FungalGiantWoundA.ogg"] = 01.49,
					["FungalGiantWoundC.ogg"] = 01.53,
					["FungalGiantWoundCrit.ogg"] = 02.45,
					["FungalGiantWoundD.ogg"] = 01.91,
				},
				["Furbolg\\"] = {
					["mFurbolgAttack1.ogg"] = 01.44,
					["mFurbolgAttack2.ogg"] = 01.18,
					["mFurbolgAttack3.ogg"] = 01.79,
					["mFurbolgAttackCritical1.ogg"] = 01.53,
					["mFurbolgDeath1.ogg"] = 02.65,
					["mFurbolgStand1.ogg"] = 02.89,
					["mFurbolgStand2.ogg"] = 02.82,
					["mFurbolgStand3.ogg"] = 02.14,
					["mFurbolgWound1.ogg"] = 01.33,
					["mFurbolgWound2.ogg"] = 01.48,
					["mFurbolgWound3.ogg"] = 01.52,
					["mFurbolgWoundCritical1.ogg"] = 01.41,
				},
				["Fury\\VO_"] = {
					["60_"] = {
						["FR_FURNACE_"] = {
							["FURY_"] = {
								["KILL_"] = {
									["1.ogg"] = 07.13,
									["2.ogg"] = 05.39,
									["3.ogg"] = 05.91,
								},
								["SPELL_"] = {
									["1.ogg"] = 05.41,
									["2.ogg"] = 06.73,
									["3.ogg"] = 11.15,
									["4.ogg"] = 06.76,
								},
								["AGGRO.ogg"] = 10.30,
								["DEATH.ogg"] = 12.48,
								["KILLSALLPLAYERS.ogg"] = 10.08,
								["EVENT_7.ogg"] = 05.92,
							},
						},
						["FURY_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 03.74,
								["02.ogg"] = 03.74,
								["03.ogg"] = 02.54,
								["04.ogg"] = 03.14,
							},
							["Attack_"] = {
								["01.ogg"] = 01.20,
								["010.ogg"] = 01.91,
								["02.ogg"] = 01.30,
								["03.ogg"] = 01.76,
								["04.ogg"] = 02.12,
								["05.ogg"] = 02.16,
								["06.ogg"] = 01.53,
								["07.ogg"] = 02.36,
								["08.ogg"] = 01.82,
								["09.ogg"] = 01.85,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 02.73,
								["02.ogg"] = 02.18,
								["03.ogg"] = 02.73,
								["04.ogg"] = 02.18,
								["05.ogg"] = 02.32,
							},
							["Wound_"] = {
								["01.ogg"] = 01.59,
								["010.ogg"] = 01.57,
								["02.ogg"] = 01.71,
								["03.ogg"] = 02.02,
								["04.ogg"] = 01.73,
								["05.ogg"] = 01.77,
								["06.ogg"] = 01.99,
								["07.ogg"] = 01.68,
								["08.ogg"] = 01.52,
								["09.ogg"] = 02.25,
							},
						},
					},
				},
				["GalDarah\\GD_"] = {
					["Galdarah_"] = {
						["Aggro.ogg"] = 03.88,
						["Attack01.ogg"] = 01.56,
						["Attack02.ogg"] = 01.21,
						["Attack03.ogg"] = 00.66,
						["Attack04.ogg"] = 01.99,
						["Attack05.ogg"] = 01.36,
						["Attack06.ogg"] = 01.43,
						["Attack07.ogg"] = 01.39,
						["Attack08.ogg"] = 00.64,
						["Attack09.ogg"] = 01.30,
						["Attack10.ogg"] = 02.09,
						["Death.ogg"] = 05.41,
						["Slay01.ogg"] = 02.45,
						["Slay02.ogg"] = 05.94,
						["Slay03.ogg"] = 02.77,
						["SummonRhino01.ogg"] = 04.86,
						["SummonRhino02.ogg"] = 03.31,
						["SummonRhino03.ogg"] = 05.18,
						["Transform01.ogg"] = 05.23,
						["Transform02.ogg"] = 05.88,
						["Wound01.ogg"] = 00.78,
						["Wound02.ogg"] = 01.12,
						["Wound03.ogg"] = 01.36,
						["Wound04.ogg"] = 01.11,
						["Wound05.ogg"] = 01.42,
						["Wound06.ogg"] = 01.31,
						["WoundCrit01.ogg"] = 01.14,
						["WoundCrit02.ogg"] = 01.00,
						["WoundCrit03.ogg"] = 00.86,
					},
				},
				["Gall\\VO_"] = {
					["60_GALL_"] = {
						["AttackCrit_"] = {
							["01.ogg"] = 01.43,
							["02.ogg"] = 01.46,
							["03.ogg"] = 01.23,
							["04.ogg"] = 01.03,
							["05.ogg"] = 00.91,
						},
						["Attack_"] = {
							["01.ogg"] = 00.36,
							["02.ogg"] = 00.65,
							["03.ogg"] = 00.57,
							["04.ogg"] = 00.51,
							["05.ogg"] = 00.36,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 01.39,
							["02.ogg"] = 01.33,
							["03.ogg"] = 01.08,
							["04.ogg"] = 00.99,
							["05.ogg"] = 01.12,
						},
						["Wound_"] = {
							["01.ogg"] = 00.57,
							["02.ogg"] = 00.38,
							["03.ogg"] = 00.38,
							["04.ogg"] = 00.52,
							["05.ogg"] = 00.54,
							["06.ogg"] = 00.61,
						},
					},
				},
				["Gallywix\\VO_"] = {
					["QE_"] = {
						["KE_Gallywix_"] = {
							["KYell01.ogg"] = 03.83,
							["KYell02.ogg"] = 04.39,
							["KYell03.ogg"] = 04.89,
							["KYell04.ogg"] = 05.33,
							["KYell05.ogg"] = 05.52,
							["KYell06.ogg"] = 07.10,
							["KYell07.ogg"] = 02.01,
							["KYell08.ogg"] = 02.64,
							["KYell09.ogg"] = 05.54,
							["KYell10.ogg"] = 08.94,
							["KYell11.ogg"] = 05.98,
							["KYell12.ogg"] = 07.04,
							["KYell13.ogg"] = 08.11,
							["KYell14.ogg"] = 19.46,
						},
						["LI_Gallywix_"] = {
							["Aggro01.ogg"] = 03.24,
							["Aggro02.ogg"] = 03.59,
							["Attack01.ogg"] = 00.68,
							["Attack02.ogg"] = 00.62,
							["Attack03.ogg"] = 00.75,
							["Attack04.ogg"] = 00.81,
							["Attack05.ogg"] = 00.90,
							["Attack06.ogg"] = 00.50,
							["Attack07.ogg"] = 00.61,
							["Attack08.ogg"] = 00.63,
							["Attack09.ogg"] = 00.63,
							["Attack10.ogg"] = 00.63,
							["AttackCrit01.ogg"] = 00.91,
							["AttackCrit02.ogg"] = 01.06,
							["AttackCrit03.ogg"] = 00.96,
							["AttackCrit04.ogg"] = 00.80,
							["AttackCrit05.ogg"] = 00.94,
							["Death01.ogg"] = 02.06,
							["Death02.ogg"] = 02.18,
							["Death03.ogg"] = 01.85,
							["Death04.ogg"] = 03.09,
							["EscapePod01.ogg"] = 05.16,
							["Greeting01.ogg"] = 05.20,
							["Greeting02.ogg"] = 06.62,
							["Greeting03.ogg"] = 03.32,
							["Greeting04.ogg"] = 10.22,
							["Greeting05.ogg"] = 02.22,
							["Kill01.ogg"] = 03.67,
							["Kill02.ogg"] = 01.08,
							["LIEvent01.ogg"] = 09.37,
							["LIEvent02.ogg"] = 04.29,
							["LIEvent03.ogg"] = 05.54,
							["LIEvent04.ogg"] = 04.25,
							["LIEvent05.ogg"] = 03.90,
							["LIEvent06.ogg"] = 05.32,
							["LIEvent07.ogg"] = 04.87,
							["LIEvent08.ogg"] = 03.05,
							["LIEvent09.ogg"] = 04.30,
							["LIEvent10.ogg"] = 05.14,
							["LIEvent11.ogg"] = 04.07,
							["LIEvent12.ogg"] = 03.10,
							["LIEvent13.ogg"] = 02.26,
							["LIEvent14.ogg"] = 03.94,
							["LIEvent15.ogg"] = 08.58,
							["LIEvent16.ogg"] = 02.65,
							["LIEvent17.ogg"] = 07.24,
							["LISummon01.ogg"] = 07.31,
							["LISummon02.ogg"] = 10.05,
							["LISummon03.ogg"] = 06.85,
							["LIYell01.ogg"] = 10.48,
							["LIYell02.ogg"] = 10.05,
							["LIYell03.ogg"] = 13.23,
							["LIYell04.ogg"] = 10.26,
							["LIYell05.ogg"] = 11.07,
							["LIYell06.ogg"] = 14.07,
							["LIYell07.ogg"] = 06.39,
							["LIYell08.ogg"] = 07.13,
							["Wound01.ogg"] = 00.67,
							["Wound02.ogg"] = 00.77,
							["Wound03.ogg"] = 00.74,
							["Wound04.ogg"] = 01.22,
							["Wound05.ogg"] = 00.86,
							["Wound06.ogg"] = 00.80,
							["Wound07.ogg"] = 01.07,
							["Wound08.ogg"] = 00.76,
							["Wound09.ogg"] = 01.00,
							["WoundCrit01.ogg"] = 01.17,
							["WoundCrit02.ogg"] = 01.31,
							["WoundCrit03.ogg"] = 00.73,
							["WoundCrit04.ogg"] = 01.04,
							["WoundCrit05.ogg"] = 01.09,
						},
					},
				},
				["Gamon\\VO_"] = {
					["54_"] = {
						["GAMON_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.39,
								["02.OGG"] = 01.85,
								["03.OGG"] = 02.18,
								["04.OGG"] = 02.05,
								["05.OGG"] = 01.72,
							},
							["Attack_"] = {
								["01.OGG"] = 00.70,
								["010.OGG"] = 00.63,
								["02.OGG"] = 00.80,
								["03.OGG"] = 00.74,
								["04.OGG"] = 00.81,
								["05.OGG"] = 00.76,
								["06.OGG"] = 00.83,
								["07.OGG"] = 00.74,
								["08.OGG"] = 00.56,
								["09.OGG"] = 00.62,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 02.02,
								["02.OGG"] = 02.02,
								["03.OGG"] = 01.75,
								["04.OGG"] = 01.33,
								["05.OGG"] = 01.46,
							},
							["Wound_"] = {
								["01.OGG"] = 00.49,
								["010.OGG"] = 00.76,
								["02.OGG"] = 00.56,
								["03.OGG"] = 00.36,
								["04.OGG"] = 00.49,
								["05.OGG"] = 00.84,
								["06.OGG"] = 00.41,
								["07.OGG"] = 00.65,
								["08.OGG"] = 00.73,
								["09.OGG"] = 00.69,
							},
						},
						["OR_GAMON_"] = {
							["EVENT_"] = {
								["1.OGG"] = 03.25,
								["2.OGG"] = 03.06,
								["3.OGG"] = 04.22,
								["4.OGG"] = 07.17,
								["5.OGG"] = 11.51,
							},
							["INTRO_"] = {
								["1.OGG"] = 04.55,
								["2.OGG"] = 06.96,
								["3.OGG"] = 08.05,
								["4.OGG"] = 03.08,
								["5.OGG"] = 07.66,
								["6.OGG"] = 03.61,
								["7.OGG"] = 04.67,
							},
							["DEATH.OGG"] = 07.59,
							["SPELL.OGG"] = 03.71,
						},
					},
				},
				["Ganar\\VO_"] = {
					["60_"] = {
						["FFR_"] = {
							["BLADESPIRE_GANAR_"] = {
								["01.ogg"] = 03.97,
								["02.ogg"] = 05.67,
								["03.ogg"] = 06.02,
							},
							["DUEL_GANAR_"] = {
								["01.ogg"] = 07.44,
								["02.ogg"] = 11.19,
								["03.ogg"] = 06.83,
								["04.ogg"] = 04.32,
								["05.ogg"] = 01.55,
								["06.ogg"] = 04.39,
							},
							["FINALE_"] = {
								["STAGE0_GANAR_"] = {
									["01.ogg"] = 05.16,
									["02.ogg"] = 08.43,
								},
								["STAGE3_GANAR_"] = {
									["01.ogg"] = 05.14,
									["02.ogg"] = 03.86,
								},
								["STAGE4_GANAR_"] = {
									["01.ogg"] = 03.29,
									["02.ogg"] = 03.29,
									["03.ogg"] = 04.61,
								},
								["STAGE1_GANAR_01.ogg"] = 05.59,
								["STAGE7_GANAR_01.ogg"] = 04.05,
								["STAGE8_GANAR_01.ogg"] = 02.54,
							},
							["LANDING_GANAR_"] = {
								["00.ogg"] = 04.21,
								["01.ogg"] = 08.99,
							},
							["PREWAVE_GANAR_"] = {
								["02.ogg"] = 05.89,
								["03.ogg"] = 07.80,
								["05.ogg"] = 07.81,
								["06.ogg"] = 11.67,
							},
							["THUNDERFALL_GANAR_"] = {
								["01.ogg"] = 06.02,
								["02.ogg"] = 01.26,
								["03.ogg"] = 02.01,
								["04.ogg"] = 06.23,
								["06.ogg"] = 01.62,
								["07.ogg"] = 02.88,
								["11b.ogg"] = 03.41,
								["12b.ogg"] = 02.23,
							},
							["VENGEANCE_GANAR_"] = {
								["01.ogg"] = 05.21,
								["02.ogg"] = 07.77,
								["03.ogg"] = 05.45,
								["04.ogg"] = 07.10,
								["05.ogg"] = 06.38,
								["08.ogg"] = 04.33,
								["10.ogg"] = 03.90,
								["11.ogg"] = 09.11,
								["12.ogg"] = 06.72,
								["13.ogg"] = 10.85,
							},
							["CHARGE_GANAR_01.ogg"] = 02.61,
						},
						["GANAR_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.45,
								["02.ogg"] = 01.15,
								["03.ogg"] = 02.59,
								["04.ogg"] = 02.66,
								["05.ogg"] = 01.44,
							},
							["Attack_"] = {
								["01.ogg"] = 00.60,
								["010.ogg"] = 01.24,
								["02.ogg"] = 00.74,
								["03.ogg"] = 00.56,
								["04.ogg"] = 00.69,
								["05.ogg"] = 00.59,
								["06.ogg"] = 00.59,
								["07.ogg"] = 00.79,
								["08.ogg"] = 00.92,
								["09.ogg"] = 00.77,
							},
							["Death_"] = {
								["01.ogg"] = 02.08,
								["02.ogg"] = 02.74,
								["03.ogg"] = 03.86,
								["04.ogg"] = 04.19,
								["05.ogg"] = 03.77,
							},
							["FAREWELL_"] = {
								["01.ogg"] = 01.29,
								["02.ogg"] = 01.52,
								["03.ogg"] = 01.10,
							},
							["GREETING_"] = {
								["01.ogg"] = 00.72,
								["02.ogg"] = 01.08,
								["03.ogg"] = 00.54,
							},
							["PISSED_"] = {
								["01.ogg"] = 03.09,
								["02.ogg"] = 01.67,
								["03.ogg"] = 03.35,
								["04.ogg"] = 02.16,
								["05.ogg"] = 02.92,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 02.31,
								["02.ogg"] = 02.46,
								["03.ogg"] = 00.91,
								["04.ogg"] = 01.64,
								["05.ogg"] = 01.53,
							},
							["Wound_"] = {
								["01.ogg"] = 00.54,
								["010.ogg"] = 00.89,
								["02.ogg"] = 00.40,
								["03.ogg"] = 00.70,
								["04.ogg"] = 00.70,
								["05.ogg"] = 00.56,
								["06.ogg"] = 00.83,
								["07.ogg"] = 00.73,
								["08.ogg"] = 00.80,
								["09.ogg"] = 00.88,
							},
						},
						["TAN_"] = {
							["FREEING_GANAR_"] = {
								["01.ogg"] = 03.31,
								["02.ogg"] = 07.50,
								["03.ogg"] = 06.41,
							},
							["GANAR_"] = {
								["RUN_"] = {
									["01.ogg"] = 02.47,
									["02.ogg"] = 12.78,
								},
								["SHOVELING_01.ogg"] = 06.92,
							},
						},
					},
				},
				["GaoRan\\VO_"] = {
					["TS_GAO_"] = {
						["RAN_"] = {
							["INTRO_"] = {
								["01.OGG"] = 14.70,
								["02.OGG"] = 11.55,
								["03.OGG"] = 08.27,
								["04.OGG"] = 03.06,
							},
							["DEPARTURE_04.OGG"] = 03.55,
						},
					},
				},
				["Garajal\\VO_"] = {
					["52_TKR_"] = {
						["GARAJAL_EVENT_"] = {
							["01.OGG"] = 02.22,
							["02.OGG"] = 02.76,
							["03.OGG"] = 03.25,
							["04.OGG"] = 03.34,
							["05.OGG"] = 02.05,
							["06.OGG"] = 02.43,
							["07.OGG"] = 04.28,
							["08.OGG"] = 03.54,
							["09.OGG"] = 02.21,
							["10.OGG"] = 10.42,
							["11.OGG"] = 07.18,
							["12.OGG"] = 01.67,
						},
					},
					["MV_TROLL_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.99,
							["02.OGG"] = 01.11,
							["03.OGG"] = 02.00,
							["04.OGG"] = 01.42,
							["05.OGG"] = 01.58,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.55,
							["02.OGG"] = 00.61,
							["03.OGG"] = 00.56,
							["04.OGG"] = 00.33,
							["05.OGG"] = 00.42,
							["06.OGG"] = 00.50,
							["07.OGG"] = 00.25,
							["08.OGG"] = 00.29,
							["09.OGG"] = 00.55,
						},
						["EVENT_"] = {
							["DEATH_"] = {
								["01.OGG"] = 07.02,
								["02.OGG"] = 05.74,
								["03.OGG"] = 05.45,
								["04.OGG"] = 10.11,
							},
							["PACK_"] = {
								["01.OGG"] = 04.79,
								["02.OGG"] = 03.10,
								["03.OGG"] = 03.78,
							},
							["TIME_01.OGG"] = 03.18,
						},
						["SLAY_"] = {
							["01.OGG"] = 03.60,
							["02.OGG"] = 02.86,
							["03.OGG"] = 02.21,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.29,
							["02.OGG"] = 00.79,
							["03.OGG"] = 01.01,
							["04.OGG"] = 01.02,
							["05.OGG"] = 01.30,
						},
						["Wound_"] = {
							["01.OGG"] = 00.51,
							["02.OGG"] = 00.35,
							["03.OGG"] = 00.43,
							["04.OGG"] = 00.39,
							["05.OGG"] = 00.51,
							["06.OGG"] = 00.69,
							["07.OGG"] = 00.44,
							["08.OGG"] = 00.30,
							["09.OGG"] = 00.43,
							["10.OGG"] = 00.37,
						},
						["AGGRO_01.OGG"] = 02.44,
						["Death_01.OGG"] = 05.80,
					},
				},
				["Garan\\VO_"] = {
					["60_"] = {
						["GARAN_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.29,
								["02.OGG"] = 01.81,
								["03.OGG"] = 01.82,
								["04.OGG"] = 01.90,
								["05.OGG"] = 01.95,
							},
							["Attack_"] = {
								["01.OGG"] = 00.47,
								["010.OGG"] = 00.37,
								["02.OGG"] = 00.29,
								["03.OGG"] = 00.58,
								["04.OGG"] = 00.64,
								["05.OGG"] = 00.75,
								["06.OGG"] = 00.47,
								["07.OGG"] = 00.39,
								["08.OGG"] = 00.37,
								["09.OGG"] = 00.40,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.91,
								["02.OGG"] = 01.94,
								["03.OGG"] = 01.95,
								["04.OGG"] = 00.89,
								["05.OGG"] = 01.67,
							},
							["Wound_"] = {
								["01.OGG"] = 00.53,
								["02.OGG"] = 00.74,
								["03.OGG"] = 00.88,
								["04.OGG"] = 00.72,
								["05.OGG"] = 00.48,
								["06.OGG"] = 00.74,
								["07.OGG"] = 00.77,
								["08.OGG"] = 00.64,
								["09.OGG"] = 00.80,
							},
						},
						["IronMaidens_Garan_"] = {
							["01.OGG"] = 06.26,
							["02.OGG"] = 03.84,
							["03.OGG"] = 03.75,
							["04.OGG"] = 03.60,
							["05.OGG"] = 03.38,
							["06.OGG"] = 03.11,
							["07.OGG"] = 02.38,
							["08.OGG"] = 06.92,
							["09.OGG"] = 04.09,
							["10.OGG"] = 01.93,
							["11.OGG"] = 01.77,
							["12.OGG"] = 02.52,
							["13.OGG"] = 04.31,
							["14.OGG"] = 03.52,
							["15.OGG"] = 02.03,
							["16.OGG"] = 01.67,
							["17.OGG"] = 02.32,
							["18.OGG"] = 02.36,
							["19.OGG"] = 02.67,
							["20.OGG"] = 02.88,
						},
					},
				},
				["Gargrak\\VO_"] = {
					["60_"] = {
						["FFR_WORGOL_"] = {
							["GARGRAK_"] = {
								["01.OGG"] = 06.59,
								["02.OGG"] = 00.84,
								["03.OGG"] = 05.68,
								["04.OGG"] = 04.82,
								["05.OGG"] = 06.75,
								["06.OGG"] = 05.79,
								["07.OGG"] = 06.64,
							},
						},
						["GARGRAK_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.70,
								["02.OGG"] = 01.91,
								["03.OGG"] = 01.82,
								["04.OGG"] = 01.99,
								["05.OGG"] = 02.20,
							},
							["Attack_"] = {
								["01.OGG"] = 00.67,
								["02.OGG"] = 00.80,
								["03.OGG"] = 00.77,
								["04.OGG"] = 00.76,
								["05.OGG"] = 00.91,
								["06.OGG"] = 00.85,
								["07.OGG"] = 00.94,
								["08.OGG"] = 00.88,
								["09.OGG"] = 01.12,
								["10.OGG"] = 01.24,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.39,
								["02.OGG"] = 02.26,
								["03.OGG"] = 01.27,
								["04.OGG"] = 01.35,
								["05.OGG"] = 01.80,
							},
							["Wound_"] = {
								["01.OGG"] = 00.96,
								["02.OGG"] = 00.89,
								["03.OGG"] = 01.06,
								["04.OGG"] = 01.30,
								["05.OGG"] = 01.12,
								["06.OGG"] = 00.75,
								["07.OGG"] = 01.99,
								["08.OGG"] = 01.05,
								["09.OGG"] = 01.83,
							},
						},
					},
				},
				["Garona\\"] = {
					["UR_Garona_"] = {
						["YSVisOne01.ogg"] = 02.05,
						["YSVisOne02.ogg"] = 07.46,
						["YSVisOne03.ogg"] = 10.31,
						["YSVisOne04.ogg"] = 03.40,
					},
					["VO_"] = {
						["60_"] = {
							["GARONA_"] = {
								["AttackCrit_"] = {
									["01.ogg"] = 02.11,
									["02.ogg"] = 01.28,
									["03.ogg"] = 01.55,
									["04.ogg"] = 01.56,
									["05.ogg"] = 02.05,
								},
								["Attack_"] = {
									["01.ogg"] = 00.64,
									["010.ogg"] = 00.82,
									["02.ogg"] = 00.73,
									["03.ogg"] = 01.47,
									["04.ogg"] = 00.87,
									["05.ogg"] = 00.79,
									["06.ogg"] = 00.77,
									["07.ogg"] = 00.99,
									["08.ogg"] = 00.47,
									["09.ogg"] = 00.85,
								},
								["Death_"] = {
									["01.ogg"] = 03.31,
									["02.ogg"] = 04.03,
									["03.ogg"] = 03.91,
									["04.ogg"] = 02.78,
									["05.ogg"] = 02.59,
								},
								["WoundCrit_"] = {
									["01.ogg"] = 01.50,
									["02.ogg"] = 02.63,
									["03.ogg"] = 01.38,
									["04.ogg"] = 02.33,
									["05.ogg"] = 01.28,
								},
								["Wound_"] = {
									["01.ogg"] = 00.68,
									["010.ogg"] = 01.32,
									["02.ogg"] = 00.78,
									["03.ogg"] = 00.80,
									["04.ogg"] = 00.49,
									["05.ogg"] = 00.83,
									["06.ogg"] = 00.72,
									["07.ogg"] = 00.76,
									["08.ogg"] = 00.81,
									["09.ogg"] = 00.51,
								},
							},
							["LQ_GARONA_"] = {
								["HUNT_"] = {
									["01.ogg"] = 05.28,
									["02.ogg"] = 06.25,
									["03.ogg"] = 09.71,
									["04.ogg"] = 05.29,
									["05.ogg"] = 03.58,
									["06.ogg"] = 08.19,
									["07.ogg"] = 05.17,
									["08.ogg"] = 03.89,
									["09.ogg"] = 05.83,
									["10.ogg"] = 05.83,
									["11.ogg"] = 02.53,
								},
								["MIND_"] = {
									["01.ogg"] = 03.67,
									["02.ogg"] = 02.28,
									["03.ogg"] = 05.74,
									["04.ogg"] = 05.85,
									["05.ogg"] = 03.90,
								},
								["PRISON_GREETING_"] = {
									["01.ogg"] = 01.43,
									["02.ogg"] = 03.08,
									["03.ogg"] = 01.08,
								},
							},
							["SMV_GULDAN_"] = {
								["STAB_GARONA_"] = {
									["02.ogg"] = 02.03,
									["03.ogg"] = 02.60,
								},
							},
						},
						["QE_TH_"] = {
							["Garona_"] = {
								["Attack01.ogg"] = 00.37,
								["Attack02.ogg"] = 00.30,
								["Attack03.ogg"] = 00.76,
								["Attack04.ogg"] = 00.39,
								["Attack05.ogg"] = 00.28,
								["Attack06.ogg"] = 00.41,
								["Attack07.ogg"] = 00.72,
								["Attack08.ogg"] = 00.38,
								["Attack09.ogg"] = 00.96,
								["Attack10.ogg"] = 00.46,
								["AttackCritical01.ogg"] = 00.73,
								["AttackCritical02.ogg"] = 00.87,
								["AttackCritical03.ogg"] = 01.36,
								["AttackCritical04.ogg"] = 01.27,
								["Event01.ogg"] = 01.04,
								["Event02.ogg"] = 03.00,
								["Event03.ogg"] = 04.23,
								["Event04.ogg"] = 01.37,
								["Event05.ogg"] = 02.55,
								["Event06.ogg"] = 02.29,
								["Greeting01.ogg"] = 02.28,
								["Greeting02.ogg"] = 01.29,
								["Greeting03.ogg"] = 02.09,
								["Greeting04.ogg"] = 02.29,
								["Greeting05.ogg"] = 02.10,
								["Greeting06.ogg"] = 04.50,
								["Greeting07.ogg"] = 03.78,
								["Pissed01.ogg"] = 01.77,
								["Pissed02.ogg"] = 02.94,
								["Pissed03.ogg"] = 03.31,
								["Wound01.ogg"] = 00.36,
								["Wound02.ogg"] = 00.34,
								["Wound03.ogg"] = 00.50,
								["Wound04.ogg"] = 00.51,
								["Wound05.ogg"] = 00.20,
								["Wound06.ogg"] = 00.49,
								["Wound07.ogg"] = 00.45,
								["Wound08.ogg"] = 00.28,
								["Wound09.ogg"] = 00.38,
								["WoundCritical01.ogg"] = 01.29,
								["WoundCritical02.ogg"] = 01.48,
								["WoundCritical03.ogg"] = 01.03,
								["WoundCritical04.ogg"] = 01.22,
								["WoundCritical05.ogg"] = 01.16,
							},
						},
					},
				},
				["GARROSH\\"] = {
					["CR_Garrosh_"] = {
						["AttackHeavy01.ogg"] = 01.36,
						["AttackHeavy02.ogg"] = 00.57,
						["AttackHeavy03.ogg"] = 00.80,
						["AttackLight01.ogg"] = 00.39,
						["AttackLight02.ogg"] = 00.50,
						["AttackLight03.ogg"] = 00.47,
						["AttackMedium01.ogg"] = 01.07,
						["AttackMedium02.ogg"] = 00.73,
						["AttackMedium03.ogg"] = 00.83,
						["BeastHFight01.ogg"] = 06.97,
						["Death02.ogg"] = 01.31,
						["HArrival01.ogg"] = 09.51,
						["HArrival02.ogg"] = 06.24,
						["HArrival03.ogg"] = 02.10,
						["HArrival04.ogg"] = 09.11,
						["HArrival05.ogg"] = 00.66,
						["JaraxxusExit01.ogg"] = 09.16,
						["KillA01.ogg"] = 01.16,
						["KillA02.ogg"] = 01.00,
						["KillA03.ogg"] = 01.42,
						["KillA04.ogg"] = 01.16,
						["PVPAintro01.ogg"] = 14.10,
						["PVPHintro01.ogg"] = 05.76,
						["PVPHWins01.ogg"] = 04.95,
						["TwinsHComplete01.ogg"] = 06.76,
						["WoundCritical01.ogg"] = 00.94,
						["WoundCritical02.ogg"] = 00.68,
						["WoundCritical03.ogg"] = 00.94,
						["WoundHeavy01.ogg"] = 00.63,
						["WoundHeavy02.ogg"] = 00.83,
						["WoundHeavy03.ogg"] = 00.55,
						["WoundLight01.ogg"] = 00.56,
						["WoundLight02.ogg"] = 00.57,
						["WoundLight03.ogg"] = 00.64,
						["WoundMedium01.ogg"] = 00.67,
						["WoundMedium02.ogg"] = 00.76,
						["WoundMedium03.ogg"] = 00.64,
					},
					["VO_"] = {
						["5.1_"] = {
							["AFINAL_Garrosh_"] = {
								["Finale_"] = {
									["01.OGG"] = 08.52,
									["03.OGG"] = 01.96,
									["04.OGG"] = 06.14,
									["05.OGG"] = 10.28,
								},
							},
							["HFINAL_Garrosh_"] = {
								["Boss_"] = {
									["01.OGG"] = 03.63,
									["02.OGG"] = 09.72,
									["03.OGG"] = 07.89,
									["04.OGG"] = 08.21,
									["05.OGG"] = 09.52,
									["06.OGG"] = 03.77,
								},
								["Finale1_"] = {
									["01.OGG"] = 07.30,
									["02.OGG"] = 20.21,
									["03.OGG"] = 11.95,
									["04.OGG"] = 08.60,
									["05.OGG"] = 06.10,
									["06.OGG"] = 08.02,
									["07.OGG"] = 07.66,
									["08.OGG"] = 16.72,
									["09.OGG"] = 03.23,
								},
								["Finale2_"] = {
									["03.OGG"] = 10.74,
									["04.OGG"] = 10.60,
									["05.OGG"] = 03.57,
								},
							},
							["HPROG_Garrosh_"] = {
								["BeachFinal_"] = {
									["01.OGG"] = 04.76,
									["02.OGG"] = 05.80,
									["03.OGG"] = 09.30,
								},
								["BeachVol_"] = {
									["01.OGG"] = 08.91,
									["02.OGG"] = 07.28,
									["03.OGG"] = 10.26,
									["04.OGG"] = 11.76,
									["05.OGG"] = 07.31,
									["06.OGG"] = 21.57,
									["07.OGG"] = 08.86,
								},
								["GrizzleResc_"] = {
									["01.OGG"] = 06.50,
									["02.OGG"] = 05.05,
								},
								["Grotash_"] = {
									["01.OGG"] = 06.12,
									["02.OGG"] = 10.90,
								},
								["Land_"] = {
									["01.OGG"] = 02.97,
									["02.OGG"] = 11.15,
									["03.OGG"] = 07.31,
								},
							},
						},
						["54_OR_"] = {
							["GARROSH_"] = {
								["EVENT_"] = {
									["1.OGG"] = 09.47,
									["10.OGG"] = 04.71,
									["11.OGG"] = 04.78,
									["2.OGG"] = 14.98,
									["3.OGG"] = 02.94,
									["4.OGG"] = 03.76,
									["5.OGG"] = 06.26,
									["6.OGG"] = 03.66,
									["7.OGG"] = 16.85,
									["8.OGG"] = 18.66,
									["9.OGG"] = 10.97,
								},
								["INTRO_"] = {
									["1.OGG"] = 20.18,
									["2.OGG"] = 11.95,
									["3.OGG"] = 16.95,
									["4.OGG"] = 21.22,
									["5.OGG"] = 09.40,
									["6.OGG"] = 08.94,
								},
								["KILL_"] = {
									["1.OGG"] = 01.19,
									["2.OGG"] = 02.12,
									["3.OGG"] = 04.74,
								},
								["SPELL_"] = {
									["1.OGG"] = 04.21,
									["10.OGG"] = 04.32,
									["2.OGG"] = 04.62,
									["3.OGG"] = 05.45,
									["4.OGG"] = 03.09,
									["5.OGG"] = 02.16,
									["6.OGG"] = 02.22,
									["7.OGG"] = 01.83,
									["8.OGG"] = 05.72,
									["9.OGG"] = 04.65,
								},
								["AGGRO.OGG"] = 21.69,
								["DEATH.OGG"] = 10.68,
								["DEATH_2.OGG"] = 15.61,
							},
						},
						["60_NGD_"] = {
							["WARSONG_"] = {
								["ALLY_GARROSH_"] = {
									["01.ogg"] = 02.82,
									["02.ogg"] = 02.83,
									["03.ogg"] = 02.21,
									["04.ogg"] = 04.11,
									["05.ogg"] = 02.23,
									["06.ogg"] = 04.04,
									["07.ogg"] = 04.86,
									["08.ogg"] = 02.36,
									["09.ogg"] = 02.65,
									["10.ogg"] = 04.83,
									["11.ogg"] = 03.88,
									["12.ogg"] = 06.46,
									["13.ogg"] = 08.05,
									["14.ogg"] = 02.89,
								},
								["HORDE_GARROSH_"] = {
									["01.ogg"] = 02.82,
									["02.ogg"] = 02.83,
									["03.ogg"] = 02.20,
									["04.ogg"] = 04.31,
									["06.ogg"] = 04.05,
									["07.ogg"] = 04.86,
									["08.ogg"] = 02.36,
									["09.ogg"] = 04.83,
									["10.ogg"] = 03.89,
									["11.ogg"] = 06.45,
									["12.ogg"] = 08.04,
									["13.ogg"] = 02.89,
									["14.ogg"] = 02.65,
								},
							},
						},
						["GARROSH_"] = {
							["FIGHT_EVENT_"] = {
								["01.OGG"] = 07.95,
								["02.OGG"] = 06.96,
								["03.OGG"] = 05.41,
								["04.OGG"] = 10.02,
								["05.OGG"] = 07.87,
								["06.OGG"] = 04.79,
								["07.OGG"] = 04.69,
							},
							["INTRO_EVENT_"] = {
								["01.OGG"] = 02.97,
								["02.OGG"] = 02.86,
								["03.OGG"] = 02.21,
								["04.OGG"] = 03.06,
							},
							["WALKING_EVENT_"] = {
								["01.OGG"] = 03.92,
								["02.OGG"] = 05.92,
								["03.OGG"] = 06.13,
								["04.OGG"] = 04.04,
								["05.OGG"] = 05.47,
								["06.OGG"] = 02.60,
								["07.OGG"] = 08.05,
								["08.OGG"] = 03.65,
								["09.OGG"] = 01.53,
								["10.OGG"] = 06.37,
								["11.OGG"] = 04.65,
								["12.OGG"] = 03.59,
								["13.OGG"] = 12.54,
								["14.OGG"] = 14.65,
								["15.OGG"] = 02.99,
								["16.OGG"] = 01.10,
								["17.OGG"] = 05.15,
							},
						},
						["QE_"] = {
							["Garrosh_"] = {
								["SPEvent01.ogg"] = 11.05,
								["SPEvent02.ogg"] = 05.73,
								["SPEvent03.ogg"] = 01.85,
								["SPEvent04.ogg"] = 11.36,
								["SPEvent05.ogg"] = 04.77,
								["SPEvent06.ogg"] = 04.96,
								["SPEvent07.ogg"] = 03.02,
								["SPEvent08.ogg"] = 12.92,
								["SPEvent09.ogg"] = 13.32,
							},
							["TI_Garrosh_"] = {
								["Aggro01.ogg"] = 02.80,
								["Aggro02.ogg"] = 02.18,
								["ElEvent01.ogg"] = 11.65,
								["ElEvent02.ogg"] = 09.60,
								["ElEvent03.ogg"] = 15.15,
								["ElEvent04.ogg"] = 03.10,
								["Event01.ogg"] = 07.58,
								["Event02.ogg"] = 07.63,
								["Event03.ogg"] = 17.01,
								["Greeting01.ogg"] = 03.06,
								["Greeting02.ogg"] = 07.28,
								["Greeting03.ogg"] = 03.49,
								["Greeting04.ogg"] = 04.01,
								["STEvent01.ogg"] = 02.87,
								["STEvent02.ogg"] = 01.47,
								["STEvent03.ogg"] = 04.08,
								["STEvent04.ogg"] = 02.48,
								["STEvent05.ogg"] = 03.98,
								["STEvent06.ogg"] = 08.09,
								["STEvent07.ogg"] = 07.75,
								["STEvent08.ogg"] = 08.50,
								["STEvent09.ogg"] = 07.58,
								["STEvent10.ogg"] = 07.48,
								["STEvent11.ogg"] = 05.01,
								["STEvent12.ogg"] = 03.30,
								["STEvent13.ogg"] = 05.39,
								["STEvent14.ogg"] = 03.35,
								["STEvent15.ogg"] = 01.62,
								["STEvent16.ogg"] = 09.56,
								["STEvent17.ogg"] = 06.87,
								["STEvent18.ogg"] = 15.04,
								["STEvent19.ogg"] = 02.67,
								["STEvent20.ogg"] = 08.13,
								["TILEvent01.ogg"] = 03.89,
								["TILEvent02.ogg"] = 47.32,
								["TILEvent03.ogg"] = 10.68,
								["TILEvent04.ogg"] = 04.49,
							},
						},
					},
				},
				["GateWatcherFan\\VO_"] = {
					["GSS_FAN_"] = {
						["EVENT_"] = {
							["01.OGG"] = 03.15,
							["02.OGG"] = 02.76,
							["03.OGG"] = 02.33,
							["04.OGG"] = 01.45,
							["05.OGG"] = 02.72,
							["06.OGG"] = 02.60,
						},
					},
				},
				["GatewatcherGyroKill\\TEMPEST_"] = {
					["Gyro_"] = {
						["Aggro01.ogg"] = 04.87,
						["Attack01.ogg"] = 01.94,
						["Attack02.ogg"] = 02.22,
						["Attack03.ogg"] = 02.07,
						["Death01.ogg"] = 06.32,
						["SawAttck01.ogg"] = 04.27,
						["SawAttck02.ogg"] = 05.24,
						["Slay01.ogg"] = 04.18,
						["Slay02.ogg"] = 04.32,
						["Wound01.ogg"] = 02.02,
						["Wound02.ogg"] = 01.96,
						["Wound03.ogg"] = 02.18,
						["Wound04.ogg"] = 02.19,
					},
				},
				["GatewatcherIronHand\\TEMPEST_"] = {
					["IronHand_"] = {
						["Aggro01.ogg"] = 05.22,
						["Attack01.ogg"] = 02.37,
						["Attack02.ogg"] = 03.03,
						["Attack03.ogg"] = 02.84,
						["Death01.ogg"] = 06.00,
						["Hammer01.ogg"] = 05.15,
						["Hammer02.ogg"] = 04.94,
						["Slay01.ogg"] = 03.44,
						["Slay02.ogg"] = 04.74,
						["Wound01.ogg"] = 02.24,
						["Wound02.ogg"] = 02.14,
						["Wound03.ogg"] = 02.03,
						["Wound04.ogg"] = 02.66,
						["Wound05.ogg"] = 02.65,
					},
				},
				["GathiosTheShatterer\\BLCKTMPLE_"] = {
					["Gathios_"] = {
						["Aggro01.ogg"] = 02.67,
						["Attack01.ogg"] = 00.34,
						["Attack02.ogg"] = 00.29,
						["Attack03.ogg"] = 00.35,
						["Attack04.ogg"] = 00.37,
						["Attack05.ogg"] = 00.28,
						["Attack06.ogg"] = 00.45,
						["Attack07.ogg"] = 00.63,
						["Attack08.ogg"] = 00.59,
						["Attack09.ogg"] = 00.65,
						["Death01.ogg"] = 02.55,
						["Enrage01.ogg"] = 01.95,
						["KilComnt01.ogg"] = 02.00,
						["Slay01.ogg"] = 02.43,
						["Special01.ogg"] = 02.79,
						["Special02.ogg"] = 02.37,
						["Wound01.ogg"] = 00.32,
						["Wound02.ogg"] = 00.41,
						["Wound03.ogg"] = 00.40,
						["Wound04.ogg"] = 00.39,
						["Wound05.ogg"] = 00.37,
						["WoundCrit01.ogg"] = 00.49,
						["WoundCrit02.ogg"] = 00.43,
						["WoundCrit03.ogg"] = 00.56,
						["WoundCrit04.ogg"] = 00.34,
					},
				},
				["Gatrul\\VO_"] = {
					["Gatrul_"] = {
						["Fight_"] = {
							["01.OGG"] = 06.74,
							["02.OGG"] = 04.93,
							["03.OGG"] = 08.98,
							["04.OGG"] = 04.87,
							["05.OGG"] = 06.33,
						},
						["Naval_Finale_01.OGG"] = 05.03,
					},
				},
				["Gazlowe\\"] = {
					["VO_60_"] = {
						["FFR_PLANTFLAG_"] = {
							["GAZLOWE_"] = {
								["01.ogg"] = 02.79,
								["02.ogg"] = 03.57,
								["03.ogg"] = 03.12,
							},
						},
						["GAZLOWE_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.38,
								["02.ogg"] = 01.30,
								["03.ogg"] = 01.47,
								["04.ogg"] = 01.57,
								["05.ogg"] = 01.34,
							},
							["Attack_"] = {
								["01.ogg"] = 00.43,
								["010.ogg"] = 00.51,
								["02.ogg"] = 00.42,
								["03.ogg"] = 00.51,
								["04.ogg"] = 00.34,
								["05.ogg"] = 00.48,
								["06.ogg"] = 00.46,
								["07.ogg"] = 00.33,
								["08.ogg"] = 00.46,
								["09.ogg"] = 00.57,
							},
							["Death_"] = {
								["01.ogg"] = 01.93,
								["02.ogg"] = 01.74,
								["03.ogg"] = 02.13,
								["04.ogg"] = 02.60,
								["05.ogg"] = 01.20,
							},
							["FAREWELL_"] = {
								["01.ogg"] = 00.85,
								["02.ogg"] = 00.87,
								["03.ogg"] = 03.06,
								["04.ogg"] = 01.11,
								["05.ogg"] = 02.79,
							},
							["GREETING_"] = {
								["01.ogg"] = 01.33,
								["02.ogg"] = 00.90,
								["03.ogg"] = 01.51,
								["04.ogg"] = 01.70,
								["05.ogg"] = 01.65,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.30,
								["02.ogg"] = 01.13,
								["03.ogg"] = 01.47,
								["04.ogg"] = 01.36,
								["05.ogg"] = 01.16,
							},
							["Wound_"] = {
								["01.ogg"] = 00.49,
								["010.ogg"] = 00.98,
								["02.ogg"] = 00.53,
								["03.ogg"] = 00.52,
								["04.ogg"] = 00.87,
								["05.ogg"] = 00.50,
								["06.ogg"] = 00.51,
								["07.ogg"] = 00.79,
								["08.ogg"] = 00.57,
								["09.ogg"] = 00.44,
							},
							["PISSED_01.ogg"] = 06.63,
						},
						["OUTPOST_GAZLOWE_"] = {
							["01.ogg"] = 05.05,
							["02.ogg"] = 05.32,
							["03.ogg"] = 03.03,
						},
						["SHATTRATH_GAZLOWE_"] = {
							["01.ogg"] = 01.46,
							["02.ogg"] = 01.47,
						},
					},
					["GazloweAggro01.ogg"] = 01.28,
					["GazloweGreeting01.ogg"] = 02.47,
					["GazloweGreeting02.ogg"] = 02.73,
					["GazloweGreeting03.ogg"] = 01.86,
					["GazloweGreeting04.ogg"] = 01.74,
				},
				["Gearchum\\VO_"] = {
					["QE_TH_"] = {
						["Gearchum_"] = {
							["Event01.ogg"] = 01.11,
							["Event02.ogg"] = 02.06,
							["Event03.ogg"] = 02.37,
							["Event04.ogg"] = 02.21,
							["Event05.ogg"] = 02.25,
							["Event06.ogg"] = 03.49,
							["Event07.ogg"] = 01.99,
							["Event08.ogg"] = 02.10,
						},
					},
				},
				["Geist\\IC_"] = {
					["Geist_"] = {
						["Event01.ogg"] = 05.18,
						["Event02.ogg"] = 03.41,
						["Event03.ogg"] = 02.97,
					},
				},
				["GEKKAN\\VO_"] = {
					["MP_GEKKAN_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.98,
							["02.OGG"] = 00.97,
							["03.OGG"] = 01.80,
							["04.OGG"] = 01.14,
							["05.OGG"] = 01.69,
						},
						["Attack_"] = {
							["01.OGG"] = 00.89,
							["02.OGG"] = 00.97,
							["03.OGG"] = 01.06,
							["04.OGG"] = 01.17,
							["05.OGG"] = 00.92,
							["06.OGG"] = 01.09,
							["07.OGG"] = 00.82,
							["08.OGG"] = 01.22,
							["09.OGG"] = 01.09,
							["10.OGG"] = 01.20,
						},
						["Death_"] = {
							["01.OGG"] = 06.44,
							["02.OGG"] = 02.90,
							["03.OGG"] = 04.51,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 02.35,
							["02.OGG"] = 01.58,
							["03.OGG"] = 01.80,
							["04.OGG"] = 02.98,
							["05.OGG"] = 02.20,
						},
						["Wound_"] = {
							["01.OGG"] = 01.64,
							["02.OGG"] = 00.84,
							["03.OGG"] = 00.90,
							["04.OGG"] = 00.81,
							["05.OGG"] = 00.73,
							["06.OGG"] = 00.54,
							["07.OGG"] = 01.10,
							["08.OGG"] = 01.20,
							["09.OGG"] = 00.65,
							["10.OGG"] = 01.35,
						},
						["AGRO_01.OGG"] = 01.50,
						["INTRO_01.OGG"] = 01.87,
						["SLAY_01.OGG"] = 02.69,
						["SPELL_01.OGG"] = 01.78,
					},
				},
				["GeneralArlos\\PE_"] = {
					["Arlos_"] = {
						["BoreanEvent01.ogg"] = 03.04,
						["BoreanEvent02.ogg"] = 04.70,
					},
				},
				["GeneralBjarngrim\\HL_"] = {
					["Bjarngrim_"] = {
						["Aggro.ogg"] = 04.52,
						["Attack01.ogg"] = 00.79,
						["Attack02.ogg"] = 00.69,
						["Attack03.ogg"] = 00.78,
						["Attack04.ogg"] = 00.56,
						["BattleStance.ogg"] = 03.28,
						["BerserkerStance.ogg"] = 05.50,
						["Death01.ogg"] = 10.39,
						["DefensiveStance.ogg"] = 01.68,
						["Slay01.ogg"] = 02.18,
						["Slay02.ogg"] = 03.65,
						["Slay03.ogg"] = 02.60,
						["Wound01.ogg"] = 00.47,
						["Wound02.ogg"] = 00.65,
						["Wound03.ogg"] = 00.40,
						["Wound04.ogg"] = 00.50,
						["Wound05.ogg"] = 00.37,
						["WoundCrit01.ogg"] = 00.87,
						["WoundCrit02.ogg"] = 00.84,
						["WoundCrit03.ogg"] = 00.95,
					},
				},
				["GeneralPaValak\\VO_"] = {
					["SNT_PAVALAK_"] = {
						["EVENT_"] = {
							["01.OGG"] = 03.39,
							["02.OGG"] = 03.40,
							["03.OGG"] = 03.20,
							["04.OGG"] = 02.47,
							["05.OGG"] = 02.82,
							["06.OGG"] = 03.92,
						},
						["SLAY_"] = {
							["01.OGG"] = 02.08,
							["02.OGG"] = 03.16,
						},
						["AGGRO_01.OGG"] = 05.36,
						["DEATH_01.OGG"] = 04.67,
					},
				},
				["GeneralVezax\\UR_"] = {
					["Vezax_"] = {
						["Aggro01.ogg"] = 06.20,
						["Attack01.ogg"] = 01.22,
						["Attack02.ogg"] = 01.24,
						["Attack03.ogg"] = 01.85,
						["Attack04.ogg"] = 01.82,
						["Attack05.ogg"] = 01.70,
						["Attack06.ogg"] = 01.63,
						["Attack07.ogg"] = 02.04,
						["Attack08.ogg"] = 01.90,
						["Attack09.ogg"] = 01.68,
						["Berserk01.ogg"] = 04.84,
						["Death01.ogg"] = 05.95,
						["HardMode01.ogg"] = 05.24,
						["Kite01.ogg"] = 10.31,
						["Slay01.ogg"] = 07.34,
						["Slay02.ogg"] = 05.99,
						["Wound01.ogg"] = 01.08,
						["Wound02.ogg"] = 00.91,
						["Wound03.ogg"] = 01.54,
						["Wound04.ogg"] = 01.79,
						["Wound05.ogg"] = 01.62,
						["Wound06.ogg"] = 01.73,
						["Wound07.ogg"] = 01.63,
						["Wound08.ogg"] = 01.76,
						["Wound09.ogg"] = 01.44,
						["WoundCrit01.ogg"] = 01.70,
						["WoundCrit02.ogg"] = 01.88,
						["WoundCrit03.ogg"] = 01.97,
						["WoundCrit04.ogg"] = 02.21,
						["WoundCrit05.ogg"] = 02.34,
					},
				},
				["GenericArakkoaOutcast\\VO_"] = {
					["60_"] = {
						["ARAKKOA_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 00.95,
								["02.ogg"] = 00.86,
								["03.ogg"] = 00.74,
								["04.ogg"] = 00.91,
								["05.ogg"] = 00.71,
							},
							["Attack_"] = {
								["01.ogg"] = 00.35,
								["010.ogg"] = 00.31,
								["02.ogg"] = 00.40,
								["03.ogg"] = 00.26,
								["04.ogg"] = 00.35,
								["05.ogg"] = 00.36,
								["06.ogg"] = 00.38,
								["07.ogg"] = 00.30,
								["08.ogg"] = 00.39,
								["09.ogg"] = 00.41,
							},
							["Death_"] = {
								["01.ogg"] = 01.86,
								["02.ogg"] = 01.05,
								["03.ogg"] = 01.75,
								["04.ogg"] = 02.49,
								["05.ogg"] = 00.69,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 00.65,
								["02.ogg"] = 00.71,
								["03.ogg"] = 01.16,
								["04.ogg"] = 01.04,
								["05.ogg"] = 00.89,
							},
							["Wound_"] = {
								["01.ogg"] = 00.34,
								["010.ogg"] = 00.38,
								["02.ogg"] = 00.34,
								["03.ogg"] = 00.22,
								["04.ogg"] = 00.36,
								["05.ogg"] = 00.34,
								["06.ogg"] = 00.44,
								["07.ogg"] = 00.36,
								["08.ogg"] = 00.35,
								["09.ogg"] = 00.31,
							},
						},
						["SPIRES_OUTCAST_"] = {
							["ARAKKOA_"] = {
								["FAREWELL_"] = {
									["01.ogg"] = 02.01,
									["02.ogg"] = 02.42,
									["03.ogg"] = 00.48,
									["04.ogg"] = 02.02,
									["05.ogg"] = 01.76,
								},
								["GREETING_"] = {
									["01.ogg"] = 01.66,
									["02.ogg"] = 04.71,
									["03.ogg"] = 02.33,
									["04.ogg"] = 02.64,
									["05.ogg"] = 02.02,
								},
								["PISSED_"] = {
									["01.ogg"] = 00.93,
									["02.ogg"] = 00.97,
									["03.ogg"] = 04.22,
								},
								["VENDOR_"] = {
									["01.ogg"] = 03.24,
									["02.ogg"] = 03.75,
									["03.ogg"] = 01.26,
								},
							},
						},
					},
				},
				["GenericKlaxxi\\VO_"] = {
					["DW_GENERIC_"] = {
						["KLAXXI_"] = {
							["ATTACKCRIT_"] = {
								["01.OGG"] = 01.46,
								["02.OGG"] = 01.76,
								["03.OGG"] = 01.44,
								["04.OGG"] = 01.71,
								["05.OGG"] = 01.17,
							},
							["ATTACK_"] = {
								["01.OGG"] = 00.92,
								["02.OGG"] = 00.81,
								["03.OGG"] = 00.88,
								["04.OGG"] = 00.48,
								["05.OGG"] = 01.01,
								["06.OGG"] = 00.65,
								["07.OGG"] = 00.77,
								["08.OGG"] = 00.73,
								["09.OGG"] = 00.92,
								["10.OGG"] = 00.67,
							},
							["DEATH_"] = {
								["01.OGG"] = 03.68,
								["02.OGG"] = 03.71,
								["03.OGG"] = 03.38,
								["04.OGG"] = 03.89,
								["05.OGG"] = 03.42,
							},
							["FAREWELL_"] = {
								["01.OGG"] = 01.58,
								["02.OGG"] = 01.80,
								["03.OGG"] = 03.15,
								["04.OGG"] = 01.49,
								["05.OGG"] = 01.27,
							},
							["GREETING_"] = {
								["01.OGG"] = 02.02,
								["02.OGG"] = 01.31,
								["03.OGG"] = 01.14,
								["04.OGG"] = 02.21,
								["05.OGG"] = 00.81,
							},
							["PISSED_"] = {
								["01.OGG"] = 01.87,
								["02.OGG"] = 02.07,
								["03.OGG"] = 02.48,
								["04.OGG"] = 01.98,
								["05.OGG"] = 09.32,
							},
							["VENDOR_"] = {
								["01.OGG"] = 01.92,
								["02.OGG"] = 01.60,
								["03.OGG"] = 01.55,
							},
							["WOUNDCRIT_"] = {
								["01.OGG"] = 01.17,
								["02.OGG"] = 01.10,
								["03.OGG"] = 00.80,
								["04.OGG"] = 01.04,
								["05.OGG"] = 01.22,
							},
							["WOUND_"] = {
								["01.OGG"] = 00.53,
								["02.OGG"] = 00.51,
								["03.OGG"] = 00.81,
								["04.OGG"] = 00.62,
								["05.OGG"] = 01.20,
								["06.OGG"] = 00.61,
								["07.OGG"] = 01.06,
								["08.OGG"] = 00.95,
								["09.OGG"] = 00.62,
								["10.OGG"] = 00.90,
							},
						},
					},
					["MANTID_EVENT_"] = {
						["KUNG_FU_"] = {
							["FINALE_"] = {
								["01.OGG"] = 02.61,
								["02.OGG"] = 02.89,
								["03.OGG"] = 01.96,
								["04.OGG"] = 02.89,
								["05.OGG"] = 04.92,
								["06.OGG"] = 03.14,
							},
						},
					},
				},
				["GenericOrcMaleBurly\\VO_"] = {
					["54_OR_"] = {
						["ORCM6_EVENT_"] = {
							["1.OGG"] = 05.17,
							["2.OGG"] = 04.57,
							["3.OGG"] = 03.44,
						},
					},
				},
				["GenericPandarenFemale\\VO_"] = {
					["GenericPandarenFemale_"] = {
						["Attack01.OGG"] = 00.60,
						["Attack02.OGG"] = 00.58,
						["Attack03.OGG"] = 00.92,
						["Attack04.OGG"] = 00.78,
						["Attack05.OGG"] = 00.71,
						["Attack06.OGG"] = 00.75,
						["Attack07.OGG"] = 00.63,
						["Attack08.OGG"] = 00.49,
						["Attack09.OGG"] = 00.53,
						["Attack10.OGG"] = 00.66,
						["Attack11.OGG"] = 00.72,
						["Attack12.OGG"] = 00.46,
						["Attack13.OGG"] = 00.49,
						["Attack14.OGG"] = 00.67,
						["Attack15.OGG"] = 00.54,
						["Attack16.OGG"] = 00.41,
						["Attack17.OGG"] = 00.43,
						["Attack18.OGG"] = 00.53,
						["Attack19.OGG"] = 00.62,
						["Attack20.OGG"] = 00.64,
						["AttackCrit01.OGG"] = 00.94,
						["AttackCrit02.OGG"] = 01.01,
						["AttackCrit03.OGG"] = 01.17,
						["AttackCrit04.OGG"] = 01.22,
						["AttackCrit05.OGG"] = 00.89,
						["AttackCrit06.OGG"] = 01.06,
						["AttackCrit07.OGG"] = 00.94,
						["AttackCrit08.OGG"] = 00.96,
						["AttackCrit09.OGG"] = 01.16,
						["AttackCrit10.OGG"] = 01.16,
						["BattleRoar01.OGG"] = 01.16,
						["BattleRoar02.OGG"] = 01.12,
						["BattleRoar03.OGG"] = 01.14,
						["BattleRoar04.OGG"] = 01.55,
						["BattleRoar05.OGG"] = 01.30,
						["Death01.OGG"] = 02.23,
						["Death02.OGG"] = 02.31,
						["Death03.OGG"] = 02.19,
						["Death04.OGG"] = 02.19,
						["Death05.OGG"] = 02.25,
						["Death06.OGG"] = 02.35,
						["Death07.OGG"] = 02.26,
						["Death08.OGG"] = 02.54,
						["Death09.OGG"] = 02.48,
						["Death10.OGG"] = 02.14,
						["Wound01.OGG"] = 00.62,
						["Wound02.OGG"] = 00.36,
						["Wound03.OGG"] = 00.39,
						["Wound04.OGG"] = 00.47,
						["Wound05.OGG"] = 00.63,
						["Wound06.OGG"] = 00.45,
						["Wound07.OGG"] = 00.40,
						["Wound08.OGG"] = 00.63,
						["Wound09.OGG"] = 00.66,
						["Wound10.OGG"] = 00.58,
						["Wound11.OGG"] = 00.68,
						["Wound12.OGG"] = 00.40,
						["Wound13.OGG"] = 01.01,
						["Wound14.OGG"] = 00.68,
						["Wound15.OGG"] = 00.54,
						["Wound16.OGG"] = 00.54,
						["Wound17.OGG"] = 00.45,
						["Wound18.OGG"] = 00.33,
						["Wound19.OGG"] = 00.74,
						["Wound20.OGG"] = 00.66,
						["WoundCrit01.OGG"] = 00.80,
						["WoundCrit02.OGG"] = 00.52,
						["WoundCrit03.OGG"] = 00.36,
						["WoundCrit04.OGG"] = 00.86,
						["WoundCrit05.OGG"] = 00.46,
						["WoundCrit06.OGG"] = 00.58,
						["WoundCrit07.OGG"] = 00.50,
						["WoundCrit08.OGG"] = 00.57,
						["WoundCrit09.OGG"] = 00.74,
						["WoundCrit10.OGG"] = 00.49,
					},
				},
				["GenericPandarenMale\\VO_"] = {
					["GenericPandarenMale_"] = {
						["Attack01.OGG"] = 00.60,
						["Attack02.OGG"] = 00.41,
						["Attack03.OGG"] = 00.37,
						["Attack04.OGG"] = 00.40,
						["Attack05.OGG"] = 00.35,
						["Attack06.OGG"] = 00.39,
						["Attack07.OGG"] = 00.52,
						["Attack08.OGG"] = 00.47,
						["Attack09.OGG"] = 00.30,
						["Attack10.OGG"] = 00.43,
						["Attack11.OGG"] = 00.40,
						["Attack12.OGG"] = 00.28,
						["Attack13.OGG"] = 00.39,
						["Attack14.OGG"] = 00.37,
						["Attack15.OGG"] = 00.38,
						["Attack16.OGG"] = 00.52,
						["Attack17.OGG"] = 00.50,
						["Attack18.OGG"] = 00.39,
						["Attack19.OGG"] = 00.49,
						["Attack20.OGG"] = 00.45,
						["AttackCrit01.OGG"] = 00.86,
						["AttackCrit02.OGG"] = 00.89,
						["AttackCrit03.OGG"] = 00.96,
						["AttackCrit04.OGG"] = 00.83,
						["AttackCrit05.OGG"] = 00.99,
						["AttackCrit06.OGG"] = 01.08,
						["AttackCrit07.OGG"] = 01.09,
						["AttackCrit08.OGG"] = 00.94,
						["AttackCrit09.OGG"] = 01.00,
						["AttackCrit10.OGG"] = 01.01,
						["BattleRoar01.OGG"] = 01.57,
						["BattleRoar02.OGG"] = 01.57,
						["BattleRoar03.OGG"] = 02.00,
						["BattleRoar04.OGG"] = 00.72,
						["BattleRoar05.OGG"] = 01.30,
						["BattleRoar06.OGG"] = 01.19,
						["Death01.OGG"] = 01.61,
						["Death02.OGG"] = 01.03,
						["Death03.OGG"] = 01.68,
						["Death04.OGG"] = 01.38,
						["Death05.OGG"] = 01.60,
						["Death06.OGG"] = 01.46,
						["Death07.OGG"] = 01.70,
						["Death08.OGG"] = 01.70,
						["Death09.OGG"] = 01.53,
						["Death10.OGG"] = 01.40,
						["Wound01.OGG"] = 00.47,
						["Wound02.OGG"] = 00.36,
						["Wound03.OGG"] = 00.36,
						["Wound04.OGG"] = 00.32,
						["Wound05.OGG"] = 00.42,
						["Wound06.OGG"] = 00.43,
						["Wound07.OGG"] = 00.51,
						["Wound08.OGG"] = 00.35,
						["Wound09.OGG"] = 00.39,
						["Wound10.OGG"] = 00.43,
						["Wound11.OGG"] = 00.35,
						["Wound12.OGG"] = 00.36,
						["Wound13.OGG"] = 00.43,
						["Wound14.OGG"] = 00.42,
						["Wound15.OGG"] = 00.60,
						["Wound16.OGG"] = 00.52,
						["Wound17.OGG"] = 00.50,
						["Wound18.OGG"] = 00.43,
						["Wound19.OGG"] = 00.45,
						["Wound20.OGG"] = 00.53,
						["WoundCrit01.OGG"] = 00.63,
						["WoundCrit02.OGG"] = 00.47,
						["WoundCrit03.OGG"] = 00.43,
						["WoundCrit04.OGG"] = 00.48,
						["WoundCrit05.OGG"] = 00.52,
						["WoundCrit06.OGG"] = 00.37,
						["WoundCrit07.OGG"] = 00.49,
						["WoundCrit08.OGG"] = 00.43,
						["WoundCrit09.OGG"] = 00.51,
						["WoundCrit10.OGG"] = 00.98,
					},
				},
				["GenericTrollMale\\VO_"] = {
					["54_OR_"] = {
						["TROLLM_"] = {
							["EVENT1.OGG"] = 02.98,
							["EVENT2.OGG"] = 02.55,
						},
					},
				},
				["Genesaur\\MON_"] = {
					["Genesaur_"] = {
						["Aggro01.ogg"] = 03.15,
						["Aggro02.ogg"] = 03.21,
						["Aggro03.ogg"] = 02.53,
						["Aggro04.ogg"] = 03.15,
						["Attack01.ogg"] = 02.33,
						["Attack02.ogg"] = 02.22,
						["Attack03.ogg"] = 02.03,
						["Attack04.ogg"] = 02.32,
						["Attack05.ogg"] = 02.65,
						["Attack06.ogg"] = 02.33,
						["Attack07.ogg"] = 02.62,
						["Attack08.ogg"] = 02.27,
						["Attack09.ogg"] = 02.53,
						["Attack10.ogg"] = 03.06,
						["AttackCrit01.ogg"] = 03.56,
						["AttackCrit02.ogg"] = 03.38,
						["AttackCrit03.ogg"] = 02.87,
						["AttackCrit04.ogg"] = 03.06,
						["AttackCrit05.ogg"] = 02.27,
						["Death01.ogg"] = 03.32,
						["Death02.ogg"] = 03.03,
						["Death03.ogg"] = 03.32,
						["Death04.ogg"] = 04.01,
						["Death05.ogg"] = 03.57,
						["PreAggro01.ogg"] = 03.14,
						["PreAggro02.ogg"] = 02.15,
						["PreAggro03.ogg"] = 03.03,
						["Wound01.ogg"] = 02.07,
						["Wound02.ogg"] = 01.90,
						["Wound03.ogg"] = 01.84,
						["Wound04.ogg"] = 02.58,
						["Wound05.ogg"] = 01.99,
						["Wound06.ogg"] = 01.98,
						["Wound07.ogg"] = 02.51,
						["Wound08.ogg"] = 02.58,
						["Wound09.ogg"] = 02.41,
						["Wound10.ogg"] = 02.06,
						["WoundCrit01.ogg"] = 02.50,
						["WoundCrit02.ogg"] = 02.98,
						["WoundCrit03.ogg"] = 02.78,
						["WoundCrit04.ogg"] = 02.65,
						["WoundCrit05.ogg"] = 03.19,
						["ZoneCalls01.ogg"] = 04.83,
						["ZoneCalls02.ogg"] = 06.18,
						["ZoneCalls03.ogg"] = 05.06,
						["ZoneCalls04.ogg"] = 05.64,
						["ZoneCalls05.ogg"] = 06.36,
					},
				},
				["GenHumFemale\\VO_"] = {
					["54_OR_"] = {
						["HUMANF_"] = {
							["EVENT1.OGG"] = 04.28,
							["EVENT2.OGG"] = 01.52,
							["EVENT3.OGG"] = 02.71,
						},
					},
				},
				["GenHumMale\\VO_"] = {
					["54_OR_"] = {
						["EITRIGG_INTRO_"] = {
							["1.OGG"] = 02.92,
							["2.OGG"] = 10.10,
							["3.OGG"] = 04.35,
							["4.OGG"] = 15.70,
						},
						["HUMANM_"] = {
							["EVENT1.OGG"] = 04.17,
							["EVENT2.OGG"] = 02.13,
						},
					},
				},
				["GenOrcFemale\\VO_"] = {
					["54_OR_"] = {
						["ORCF_EVENT_"] = {
							["1.OGG"] = 02.46,
							["2.OGG"] = 02.02,
							["3.OGG"] = 02.32,
						},
					},
				},
				["GenOrcMale2\\VO_"] = {
					["54_OR_"] = {
						["ORCM2_EVENT_"] = {
							["1.OGG"] = 01.35,
							["2.OGG"] = 01.69,
						},
					},
				},
				["GenOrcMale5\\VO_"] = {
					["54_OR_"] = {
						["ORCM5_EVENT_"] = {
							["1.OGG"] = 04.24,
							["2.OGG"] = 11.23,
							["3.OGG"] = 08.13,
						},
					},
				},
				["Geode\\Geode_"] = {
					["Aggro01.ogg"] = 01.04,
					["Aggro02.ogg"] = 00.98,
					["Aggro03.ogg"] = 00.87,
					["Aggro04.ogg"] = 00.73,
					["Aggro05.ogg"] = 00.92,
					["Aggro06.ogg"] = 01.01,
					["Aggro07.ogg"] = 00.78,
					["Aggro08.ogg"] = 00.81,
					["Aggro09.ogg"] = 00.78,
					["Aggro10.ogg"] = 01.14,
					["Death01.ogg"] = 00.78,
					["Death02.ogg"] = 00.74,
					["Death03.ogg"] = 00.69,
					["Death04.ogg"] = 00.74,
					["Death05.ogg"] = 00.73,
					["Death06.ogg"] = 00.68,
					["Death07.ogg"] = 00.73,
					["Death08.ogg"] = 00.76,
					["Death09.ogg"] = 00.97,
					["Death10.ogg"] = 00.68,
					["PreAggro01.ogg"] = 00.74,
					["PreAggro02.ogg"] = 01.05,
					["PreAggro03.ogg"] = 00.94,
					["PreAggro04.ogg"] = 00.71,
					["Wound01.ogg"] = 00.88,
					["Wound02.ogg"] = 01.00,
					["Wound03.ogg"] = 01.01,
					["Wound04.ogg"] = 00.55,
					["Wound05.ogg"] = 00.70,
					["Wound06.ogg"] = 00.79,
					["Wound07.ogg"] = 00.72,
					["Wound08.ogg"] = 00.48,
					["Wound09.ogg"] = 00.57,
					["Wound10.ogg"] = 00.38,
					["WoundCrit01.ogg"] = 01.00,
					["WoundCrit02.ogg"] = 00.93,
					["WoundCrit03.ogg"] = 00.85,
					["WoundCrit04.ogg"] = 00.61,
					["WoundCrit05.ogg"] = 00.94,
				},
				["Ghost\\"] = {
					["GhostAggroA.ogg"] = 02.41,
					["GhostAttackA.ogg"] = 02.83,
					["GhostAttackB.ogg"] = 02.12,
					["GhostAttackC.ogg"] = 02.31,
					["GhostDeathA.ogg"] = 04.09,
					["GhostPreAggroA.ogg"] = 02.67,
					["GhostWoundA.ogg"] = 02.27,
					["GhostWoundB.ogg"] = 01.53,
					["GhostWoundC.ogg"] = 02.03,
					["GhostWoundCrit.ogg"] = 02.76,
				},
				["GhostlySkullPet\\"] = {
					["GhostlySkullPet1.ogg"] = 03.50,
					["GhostlySkullPet2.ogg"] = 04.01,
					["GhostlySkullPet3.ogg"] = 03.39,
					["GhostlySkullPet4.ogg"] = 03.25,
				},
				["Ghoul\\"] = {
					["mGhoulAggro1.ogg"] = 03.34,
					["mGhoulAggro2.ogg"] = 02.97,
					["mGhoulAggro3.ogg"] = 03.08,
					["mGhoulAttack1.ogg"] = 01.08,
					["mGhoulAttack2.ogg"] = 01.05,
					["mGhoulAttack3.ogg"] = 00.97,
					["mGhoulAttack4.ogg"] = 00.90,
					["mGhoulAttack5.ogg"] = 00.72,
					["mGhoulDeath1.ogg"] = 01.77,
					["mGhoulFidget1a.ogg"] = 04.96,
					["mGhoulFidget1b.ogg"] = 05.12,
					["mGhoulFidget1c.ogg"] = 04.82,
					["mGhoulFidget2a.ogg"] = 05.93,
					["mGhoulFidget2b.ogg"] = 05.94,
					["mGhoulWound1.ogg"] = 01.31,
					["mGhoulWound2.ogg"] = 00.58,
					["mGhoulWound3.ogg"] = 01.03,
					["mGhoulWoundCritical1.ogg"] = 01.03,
				},
				["GiantRemora\\GiantRemora_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.34,
						["02.ogg"] = 01.05,
						["03.ogg"] = 01.07,
						["04.ogg"] = 01.34,
						["05.ogg"] = 01.18,
						["06.ogg"] = 00.74,
						["07.ogg"] = 00.96,
						["08.ogg"] = 01.31,
						["09.ogg"] = 01.11,
						["10.ogg"] = 01.56,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 01.09,
						["02.ogg"] = 01.04,
						["03.ogg"] = 01.03,
						["04.ogg"] = 00.68,
						["05.ogg"] = 00.97,
					},
					["Attack_"] = {
						["01.ogg"] = 00.79,
						["02.ogg"] = 00.67,
						["03.ogg"] = 00.91,
						["04.ogg"] = 00.68,
						["05.ogg"] = 00.57,
						["06.ogg"] = 00.98,
						["07.ogg"] = 00.72,
						["08.ogg"] = 00.69,
						["09.ogg"] = 00.75,
						["10.ogg"] = 00.70,
					},
					["Death_"] = {
						["01.ogg"] = 01.39,
						["02.ogg"] = 01.35,
						["03.ogg"] = 01.36,
						["04.ogg"] = 01.73,
						["05.ogg"] = 01.62,
						["06.ogg"] = 01.76,
						["07.ogg"] = 01.36,
						["08.ogg"] = 01.36,
						["09.ogg"] = 01.52,
						["10.ogg"] = 01.47,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.03,
						["02.ogg"] = 00.84,
						["03.ogg"] = 00.98,
						["04.ogg"] = 01.02,
						["05.ogg"] = 01.08,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 00.56,
						["02.ogg"] = 00.57,
						["03.ogg"] = 00.58,
						["04.ogg"] = 00.54,
						["05.ogg"] = 00.52,
					},
					["Wound_"] = {
						["01.ogg"] = 00.57,
						["02.ogg"] = 00.71,
						["03.ogg"] = 00.67,
						["04.ogg"] = 00.63,
						["05.ogg"] = 00.61,
						["06.ogg"] = 00.60,
						["07.ogg"] = 00.70,
						["08.ogg"] = 00.52,
						["09.ogg"] = 00.49,
						["10.ogg"] = 00.50,
					},
				},
				["GiantSpider\\"] = {
					["GiantSpiderAttackA.ogg"] = 02.41,
					["GiantSpiderAttackB.ogg"] = 01.94,
					["GiantSpiderAttackC.ogg"] = 01.40,
					["GiantSpiderAttackD.ogg"] = 01.59,
					["GiantSpiderWoundA.ogg"] = 01.93,
					["GiantSpiderWoundB.ogg"] = 01.78,
					["GiantSpiderWoundC.ogg"] = 01.56,
					["GiantSpiderWoundCrit.ogg"] = 01.58,
					["GiantSpiderWoundDeath.ogg"] = 02.94,
				},
				["Gilgoblin\\Gilgoblin_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.27,
						["02.ogg"] = 01.47,
						["03.ogg"] = 01.00,
						["04.ogg"] = 01.32,
						["05.ogg"] = 01.37,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 01.41,
						["02.ogg"] = 01.00,
						["03.ogg"] = 00.87,
						["04.ogg"] = 01.24,
						["05.ogg"] = 01.57,
						["06.ogg"] = 01.51,
					},
					["Attack_"] = {
						["01.ogg"] = 01.10,
						["02.ogg"] = 01.10,
						["03.ogg"] = 01.10,
						["04.ogg"] = 01.10,
						["05.ogg"] = 01.10,
						["06.ogg"] = 01.10,
						["07.ogg"] = 01.10,
						["08.ogg"] = 01.10,
						["09.ogg"] = 01.10,
						["10.ogg"] = 01.10,
					},
					["Death_"] = {
						["01.ogg"] = 04.93,
						["02.ogg"] = 04.93,
						["03.ogg"] = 04.93,
						["04.ogg"] = 04.93,
						["05.ogg"] = 04.93,
						["06.ogg"] = 04.93,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.00,
						["02.ogg"] = 00.81,
						["03.ogg"] = 01.00,
						["04.ogg"] = 00.97,
						["05.ogg"] = 00.84,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.00,
						["02.ogg"] = 01.00,
						["03.ogg"] = 01.00,
						["04.ogg"] = 01.00,
						["05.ogg"] = 01.00,
						["06.ogg"] = 01.00,
					},
					["Wound_"] = {
						["01.ogg"] = 00.63,
						["02.ogg"] = 00.63,
						["03.ogg"] = 00.63,
						["04.ogg"] = 00.89,
						["05.ogg"] = 00.63,
						["06.ogg"] = 00.69,
						["07.ogg"] = 00.95,
						["08.ogg"] = 00.68,
						["09.ogg"] = 00.70,
						["10.ogg"] = 00.76,
					},
				},
				["GilneanCivF\\VO_"] = {
					["GilneanCivF_"] = {
						["Farewell01.ogg"] = 01.70,
						["Farewell02.ogg"] = 01.17,
						["Farewell03.ogg"] = 01.84,
						["Farewell04.ogg"] = 01.10,
						["Farewell05.ogg"] = 00.63,
						["Farewell06.ogg"] = 00.86,
						["Farewell07.ogg"] = 02.01,
						["Farewell08.ogg"] = 00.56,
						["Farewell09.ogg"] = 01.98,
						["FarewellAggro01.ogg"] = 01.21,
						["FarewellAggro02.ogg"] = 00.84,
						["FarewellAggro03.ogg"] = 00.81,
						["FarewellAggro04.ogg"] = 00.93,
						["FarewellAggro05.ogg"] = 01.07,
						["Greeting02.ogg"] = 01.15,
						["Greeting03.ogg"] = 01.34,
						["Greeting04.ogg"] = 01.68,
						["Greeting05.ogg"] = 00.92,
						["Greeting06.ogg"] = 02.22,
						["Greeting07.ogg"] = 01.59,
						["GreetingAggro01.ogg"] = 01.26,
						["GreetingAggro02.ogg"] = 00.54,
						["GreetingAggro03.ogg"] = 01.41,
						["GreetingAggro04.ogg"] = 01.09,
						["GreetingAggro05.ogg"] = 01.08,
						["Pissed01.ogg"] = 03.06,
						["Pissed02.ogg"] = 02.25,
						["Pissed03.ogg"] = 02.94,
						["Pissed04.ogg"] = 02.30,
						["Pissed05.ogg"] = 02.47,
						["Pissed06.ogg"] = 01.87,
						["Pissed07.ogg"] = 00.79,
						["Pissed08.ogg"] = 01.48,
						["Pissed09.ogg"] = 01.05,
						["Vendor01.ogg"] = 01.00,
						["Vendor02.ogg"] = 01.86,
						["Vendor03.ogg"] = 01.26,
						["Vendor04.ogg"] = 01.09,
						["Vendor05.ogg"] = 00.97,
						["Vendor06.ogg"] = 01.76,
					},
				},
				["GilneanCivM\\VO_"] = {
					["GilneanCivM_"] = {
						["Farewell01.ogg"] = 01.53,
						["Farewell02.ogg"] = 00.96,
						["Farewell03.ogg"] = 02.03,
						["Farewell04.ogg"] = 01.42,
						["Farewell05.ogg"] = 00.52,
						["Farewell06.ogg"] = 01.10,
						["Farewell07.ogg"] = 02.19,
						["Farewell08.ogg"] = 00.51,
						["Farewell09.ogg"] = 02.01,
						["FarewellAggro01.ogg"] = 01.17,
						["FarewellAggro02.ogg"] = 00.80,
						["FarewellAggro03.ogg"] = 00.69,
						["FarewellAggro04.ogg"] = 00.83,
						["FarewellAggro05.ogg"] = 01.15,
						["Greeting01.ogg"] = 00.27,
						["Greeting02.ogg"] = 00.99,
						["Greeting03.ogg"] = 01.79,
						["Greeting04.ogg"] = 01.41,
						["Greeting05.ogg"] = 00.99,
						["Greeting06.ogg"] = 02.65,
						["Greeting07.ogg"] = 02.01,
						["Greeting08.ogg"] = 02.47,
						["GreetingAggro01.ogg"] = 01.42,
						["GreetingAggro02.ogg"] = 01.28,
						["GreetingAggro03.ogg"] = 00.76,
						["GreetingAggro04.ogg"] = 00.69,
						["GreetingAggro05.ogg"] = 01.11,
						["Pissed01.ogg"] = 01.80,
						["Pissed02.ogg"] = 01.61,
						["Pissed03.ogg"] = 02.39,
						["Pissed04.ogg"] = 02.13,
						["Pissed05.ogg"] = 02.35,
						["Pissed06.ogg"] = 01.66,
						["Pissed07.ogg"] = 00.77,
						["Pissed08.ogg"] = 01.18,
						["Pissed09.ogg"] = 01.28,
						["Vendor01.ogg"] = 01.11,
						["Vendor02.ogg"] = 01.85,
						["Vendor03.ogg"] = 01.44,
						["Vendor04.ogg"] = 01.16,
						["Vendor05.ogg"] = 00.96,
						["Vendor06.ogg"] = 01.76,
					},
				},
				["GilneanFemale\\GilneanFemale_"] = {
					["Attack01.ogg"] = 00.45,
					["Attack02.ogg"] = 00.47,
					["Attack03.ogg"] = 00.41,
					["Attack04.ogg"] = 00.58,
					["Attack05.ogg"] = 00.72,
					["Attack06.ogg"] = 00.44,
					["Attack07.ogg"] = 00.36,
					["Death01.ogg"] = 02.56,
					["Death02.ogg"] = 02.05,
					["Death03.ogg"] = 02.30,
					["Death04.ogg"] = 01.94,
					["Wound01.ogg"] = 00.86,
					["Wound02.ogg"] = 00.87,
					["Wound03.ogg"] = 00.72,
					["Wound04.ogg"] = 00.69,
					["Wound05.ogg"] = 00.77,
					["Wound06.ogg"] = 00.78,
					["Wound07.ogg"] = 00.47,
					["Wound08.ogg"] = 00.52,
					["WoundCrit01.ogg"] = 01.17,
					["WoundCrit02.ogg"] = 01.12,
					["WoundCrit03.ogg"] = 01.02,
					["WoundCrit04.ogg"] = 01.01,
					["WoundCrit05.ogg"] = 01.15,
					["WoundCrit06.ogg"] = 01.23,
					["WoundCrit07.ogg"] = 00.85,
					["WoundCrit08.ogg"] = 01.05,
					["WoundCrit09.ogg"] = 00.77,
				},
				["GilneanGuardF\\VO_"] = {
					["GilneanGuardF_"] = {
						["Farewell01.ogg"] = 02.37,
						["Farewell02.ogg"] = 02.31,
						["Farewell03.ogg"] = 02.14,
						["Farewell04.ogg"] = 00.84,
						["Farewell05.ogg"] = 01.11,
						["Farewell06.ogg"] = 02.21,
						["Farewell07.ogg"] = 03.94,
						["Farewell08.ogg"] = 02.14,
						["Farewell09.ogg"] = 00.80,
						["FarewellAggro01.ogg"] = 01.41,
						["FarewellAggro02.ogg"] = 00.99,
						["FarewellAggro03.ogg"] = 00.91,
						["FarewellAggro04.ogg"] = 01.21,
						["FarewellAggro05.ogg"] = 01.43,
						["Greeting01.ogg"] = 02.12,
						["Greeting02.ogg"] = 01.53,
						["Greeting03.ogg"] = 01.22,
						["Greeting04.ogg"] = 03.58,
						["Greeting05.ogg"] = 02.24,
						["Greeting06.ogg"] = 01.81,
						["Greeting07.ogg"] = 01.51,
						["Greeting08.ogg"] = 02.71,
						["Greeting09.ogg"] = 01.65,
						["Greeting10.ogg"] = 01.74,
						["GreetingAggro01.ogg"] = 02.03,
						["GreetingAggro02.ogg"] = 00.60,
						["GreetingAggro03.ogg"] = 01.22,
						["GreetingAggro04.ogg"] = 01.19,
						["GreetingAggro05.ogg"] = 01.56,
						["Pissed01.ogg"] = 03.20,
						["Pissed02.ogg"] = 02.76,
						["Pissed03.ogg"] = 02.55,
						["Pissed04.ogg"] = 02.40,
						["Pissed05.ogg"] = 01.39,
						["Pissed06.ogg"] = 01.44,
						["Pissed07.ogg"] = 02.82,
						["Vendor01.ogg"] = 01.07,
						["Vendor02.ogg"] = 01.14,
						["Vendor03.ogg"] = 01.38,
						["Vendor04.ogg"] = 01.26,
						["Vendor05.ogg"] = 00.87,
						["Vendor06.ogg"] = 01.93,
					},
				},
				["GilneanGuardM\\VO_"] = {
					["GilneanGuardM_"] = {
						["Farewell01.ogg"] = 02.40,
						["Farewell02.ogg"] = 02.42,
						["Farewell03.ogg"] = 01.79,
						["Farewell04.ogg"] = 00.89,
						["Farewell05.ogg"] = 00.98,
						["Farewell06.ogg"] = 01.71,
						["Farewell07.ogg"] = 03.65,
						["Farewell08.ogg"] = 02.08,
						["Farewell09.ogg"] = 00.67,
						["FarewellAggro01.ogg"] = 01.15,
						["FarewellAggro02.ogg"] = 00.95,
						["FarewellAggro03.ogg"] = 00.72,
						["FarewellAggro04.ogg"] = 01.18,
						["FarewellAggro05.ogg"] = 01.35,
						["Greeting01.ogg"] = 01.71,
						["Greeting02.ogg"] = 01.18,
						["Greeting03.ogg"] = 01.01,
						["Greeting04.ogg"] = 02.93,
						["Greeting05.ogg"] = 01.94,
						["Greeting06.ogg"] = 01.72,
						["Greeting07.ogg"] = 01.16,
						["Greeting08.ogg"] = 01.80,
						["Greeting09.ogg"] = 01.39,
						["Greeting10.ogg"] = 01.50,
						["GreetingAggro01.ogg"] = 01.35,
						["GreetingAggro02.ogg"] = 00.60,
						["GreetingAggro03.ogg"] = 00.98,
						["GreetingAggro04.ogg"] = 00.80,
						["GreetingAggro05.ogg"] = 01.26,
						["Pissed01.ogg"] = 02.84,
						["Pissed02.ogg"] = 02.03,
						["Pissed03.ogg"] = 02.57,
						["Pissed04.ogg"] = 02.06,
						["Pissed05.ogg"] = 00.87,
						["Pissed06.ogg"] = 01.34,
						["Pissed07.ogg"] = 02.57,
						["Pissed08.ogg"] = 02.68,
						["Vendor01.ogg"] = 01.21,
						["Vendor02.ogg"] = 01.85,
						["Vendor03.ogg"] = 01.27,
						["Vendor04.ogg"] = 00.98,
						["Vendor05.ogg"] = 00.95,
						["Vendor06.ogg"] = 01.76,
					},
				},
				["GilneanMale\\GilneanMale_"] = {
					["Attack01.ogg"] = 00.77,
					["Attack02.ogg"] = 00.49,
					["Attack03.ogg"] = 00.64,
					["Attack04.ogg"] = 00.63,
					["Attack05.ogg"] = 00.27,
					["Attack06.ogg"] = 00.27,
					["Attack07.ogg"] = 00.36,
					["Attack08.ogg"] = 00.48,
					["Attack09.ogg"] = 00.44,
					["Attack10.ogg"] = 00.36,
					["AttackCrit01.ogg"] = 00.75,
					["AttackCrit02.ogg"] = 01.02,
					["AttackCrit03.ogg"] = 00.74,
					["AttackCrit04.ogg"] = 00.72,
					["AttackCrit05.ogg"] = 00.76,
					["AttackCrit06.ogg"] = 00.87,
					["AttackCrit07.ogg"] = 00.65,
					["Death01.ogg"] = 01.77,
					["Death02.ogg"] = 01.15,
					["Death03.ogg"] = 00.99,
					["Death04.ogg"] = 01.31,
					["Wound01.ogg"] = 00.80,
					["Wound02.ogg"] = 00.79,
					["Wound03.ogg"] = 01.11,
					["Wound04.ogg"] = 01.03,
					["Wound05.ogg"] = 00.46,
					["Wound06.ogg"] = 01.10,
					["Wound07.ogg"] = 00.74,
					["Wound08.ogg"] = 00.56,
					["Wound09.ogg"] = 00.55,
					["Wound10.ogg"] = 00.47,
					["WoundCrit01.ogg"] = 01.26,
					["WoundCrit02.ogg"] = 00.68,
					["WoundCrit03.ogg"] = 00.83,
					["WoundCrit04.ogg"] = 00.77,
					["WoundCrit05.ogg"] = 01.19,
					["WoundCrit06.ogg"] = 00.75,
					["WoundCrit07.ogg"] = 00.91,
					["WoundCrit08.ogg"] = 00.62,
				},
				["GilneanVenF\\VO_"] = {
					["GilneanVenF_"] = {
						["Farewell01.ogg"] = 00.97,
						["Farewell02.ogg"] = 00.75,
						["Farewell03.ogg"] = 01.00,
						["Farewell04.ogg"] = 01.44,
						["Farewell05.ogg"] = 00.59,
						["Farewell06.ogg"] = 02.41,
						["Farewell07.ogg"] = 02.60,
						["Farewell08.ogg"] = 01.64,
						["Farewell09.ogg"] = 01.33,
						["Farewell10.ogg"] = 01.00,
						["FarewellAggro01.ogg"] = 01.02,
						["FarewellAggro02.ogg"] = 00.79,
						["FarewellAggro03.ogg"] = 00.82,
						["FarewellAggro04.ogg"] = 00.78,
						["FarewellAggro05.ogg"] = 01.05,
						["Greeting01.ogg"] = 01.10,
						["Greeting02.ogg"] = 01.99,
						["Greeting03.ogg"] = 01.60,
						["Greeting04.ogg"] = 01.33,
						["Greeting05.ogg"] = 02.20,
						["Greeting06.ogg"] = 01.70,
						["Greeting07.ogg"] = 01.51,
						["Greeting08.ogg"] = 01.61,
						["Greeting09.ogg"] = 01.63,
						["Greeting10.ogg"] = 01.29,
						["GreetingAggro01.ogg"] = 01.68,
						["GreetingAggro02.ogg"] = 00.60,
						["GreetingAggro03.ogg"] = 01.43,
						["GreetingAggro04.ogg"] = 00.81,
						["GreetingAggro05.ogg"] = 01.54,
						["Pissed01.ogg"] = 01.36,
						["Pissed02.ogg"] = 01.58,
						["Pissed03.ogg"] = 02.08,
						["Pissed04.ogg"] = 02.32,
						["Pissed05.ogg"] = 02.37,
						["Pissed06.ogg"] = 01.49,
						["Pissed07.ogg"] = 00.70,
						["Pissed08.ogg"] = 01.36,
						["Pissed09.ogg"] = 01.05,
						["Pissed10.ogg"] = 02.85,
						["Vendor01.ogg"] = 00.95,
						["Vendor02.ogg"] = 01.29,
						["Vendor03.ogg"] = 01.06,
						["Vendor04.ogg"] = 00.85,
						["Vendor05.ogg"] = 01.72,
					},
				},
				["GilneanVenM\\VO_"] = {
					["GilneanVenM_"] = {
						["Farewell01.ogg"] = 01.11,
						["Farewell02.ogg"] = 00.71,
						["Farewell03.ogg"] = 01.03,
						["Farewell04.ogg"] = 01.96,
						["Farewell05.ogg"] = 00.57,
						["Farewell06.ogg"] = 02.59,
						["Farewell07.ogg"] = 02.66,
						["Farewell08.ogg"] = 01.64,
						["Farewell09.ogg"] = 01.22,
						["Farewell10.ogg"] = 00.82,
						["FarewellAggro01.ogg"] = 01.32,
						["FarewellAggro02.ogg"] = 01.03,
						["FarewellAggro03.ogg"] = 00.89,
						["FarewellAggro04.ogg"] = 01.19,
						["FarewellAggro05.ogg"] = 01.53,
						["Greeting01.ogg"] = 01.33,
						["Greeting02.ogg"] = 01.90,
						["Greeting03.ogg"] = 01.65,
						["Greeting04.ogg"] = 01.25,
						["Greeting05.ogg"] = 02.37,
						["Greeting06.ogg"] = 01.93,
						["Greeting07.ogg"] = 01.77,
						["Greeting08.ogg"] = 02.18,
						["Greeting09.ogg"] = 01.59,
						["Greeting10.ogg"] = 01.29,
						["GreetingAggro01.ogg"] = 01.49,
						["GreetingAggro02.ogg"] = 00.58,
						["GreetingAggro03.ogg"] = 01.30,
						["GreetingAggro04.ogg"] = 00.64,
						["GreetingAggro05.ogg"] = 01.63,
						["Howl01.ogg"] = 02.88,
						["Pissed01.ogg"] = 03.17,
						["Pissed02.ogg"] = 01.62,
						["Pissed03.ogg"] = 02.43,
						["Pissed04.ogg"] = 02.01,
						["Pissed05.ogg"] = 02.76,
						["Pissed06.ogg"] = 01.95,
						["Pissed07.ogg"] = 01.06,
						["Pissed08.ogg"] = 01.08,
						["Pissed09.ogg"] = 01.93,
						["Pissed10.ogg"] = 02.61,
						["Vendor01.ogg"] = 01.18,
						["Vendor02.ogg"] = 01.72,
						["Vendor03.ogg"] = 01.32,
						["Vendor04.ogg"] = 01.28,
						["Vendor05.ogg"] = 00.97,
						["Vendor06.ogg"] = 01.60,
					},
				},
				["GILNEASSTAGECOACH\\GilneasStageCoach_"] = {
					["Drive_FastLP_"] = {
						["01.ogg"] = 03.00,
						["02.ogg"] = 03.00,
						["03.ogg"] = 03.00,
					},
					["IdleOS_"] = {
						["01.ogg"] = 02.00,
						["02.ogg"] = 02.00,
						["03.ogg"] = 02.00,
						["04.ogg"] = 02.00,
						["05.ogg"] = 02.00,
						["06.ogg"] = 02.00,
						["07.ogg"] = 02.00,
						["08.ogg"] = 02.00,
						["09.ogg"] = 02.00,
						["10.ogg"] = 02.00,
					},
					["JinglesOS_"] = {
						["01.ogg"] = 05.00,
						["02.ogg"] = 05.00,
						["03.ogg"] = 05.00,
						["04.ogg"] = 05.00,
					},
					["StartOS_"] = {
						["01.ogg"] = 02.88,
						["02.ogg"] = 02.99,
					},
					["WheelsOS_"] = {
						["01.ogg"] = 03.00,
						["02.ogg"] = 03.00,
						["03.ogg"] = 03.00,
						["04.ogg"] = 03.00,
						["05.ogg"] = 03.00,
					},
				},
				["Giraffe\\"] = {
					["GiraffeAggroA.ogg"] = 01.98,
					["GiraffeAttackA.ogg"] = 00.75,
					["GiraffeAttackB.ogg"] = 01.18,
					["GiraffeAttackC.ogg"] = 00.90,
					["GiraffeDeathA.ogg"] = 00.88,
					["GiraffePreAggroA.ogg"] = 00.67,
					["GiraffeWoundA.ogg"] = 01.50,
					["GiraffeWoundB.ogg"] = 00.59,
					["GiraffeWoundC.ogg"] = 00.96,
					["GiraffeWoundCrit.ogg"] = 01.20,
				},
				["Giselda\\VO_"] = {
					["60_FR_"] = {
						["GISELDA_CAPTURE_"] = {
							["01.ogg"] = 01.76,
							["02.ogg"] = 03.10,
						},
					},
				},
				["Glop\\VO_"] = {
					["QE_Glop_"] = {
						["Attack01.ogg"] = 01.14,
						["Attack02.ogg"] = 01.29,
						["Attack03.ogg"] = 01.26,
						["Attack04.ogg"] = 01.33,
						["Attack05.ogg"] = 01.71,
						["Attack06.ogg"] = 01.01,
						["Attack07.ogg"] = 00.16,
						["Attack08.ogg"] = 01.38,
						["Attack09.ogg"] = 01.29,
						["AttackCritical01.ogg"] = 01.76,
						["AttackCritical02.ogg"] = 01.58,
						["AttackCritical03.ogg"] = 01.48,
						["AttackCritical04.ogg"] = 01.91,
						["AttackCritical05.ogg"] = 01.74,
						["Event01.ogg"] = 06.56,
						["Event02.ogg"] = 08.98,
						["Event03.ogg"] = 09.40,
						["Event04.ogg"] = 05.89,
						["Event05.ogg"] = 09.85,
						["Wound01.ogg"] = 01.50,
						["Wound02.ogg"] = 01.07,
						["Wound03.ogg"] = 01.33,
						["Wound04.ogg"] = 01.15,
						["Wound05.ogg"] = 01.02,
						["Wound06.ogg"] = 01.23,
						["Wound07.ogg"] = 01.52,
						["Wound08.ogg"] = 01.22,
						["Wound09.ogg"] = 01.07,
						["WoundCritical01.ogg"] = 03.40,
						["WoundCritical02.ogg"] = 01.77,
						["WoundCritical03.ogg"] = 01.48,
						["WoundCritical04.ogg"] = 01.72,
						["WoundCritical05.ogg"] = 01.92,
					},
				},
				["Glovall\\VO_"] = {
					["QE_VJ_"] = {
						["Glovall_"] = {
							["Cavern01.ogg"] = 02.77,
							["Cavern02.ogg"] = 02.11,
							["Cavern03.ogg"] = 03.20,
							["Cavern04.ogg"] = 06.84,
						},
					},
				},
				["GlubtokBoth\\VO_"] = {
					["DM_GlubtokBoth_"] = {
						["Attack01.ogg"] = 00.53,
						["Attack02.ogg"] = 00.54,
						["Attack03.ogg"] = 00.68,
						["Attack04.ogg"] = 00.74,
						["Attack05.ogg"] = 00.57,
						["Attack06.ogg"] = 00.66,
						["Attack07.ogg"] = 00.37,
						["Attack08.ogg"] = 00.35,
						["AttackCritical01.ogg"] = 01.01,
						["AttackCritical02.ogg"] = 01.12,
						["AttackCritical03.ogg"] = 01.00,
						["AttackCritical04.ogg"] = 01.50,
						["AttackCritical05.ogg"] = 01.45,
						["Death01.ogg"] = 05.78,
						["Spell03.ogg"] = 04.62,
						["Wound01.ogg"] = 00.51,
						["Wound02.ogg"] = 00.38,
						["Wound03.ogg"] = 00.63,
						["Wound04.ogg"] = 00.48,
						["Wound05.ogg"] = 00.45,
						["Wound06.ogg"] = 00.92,
						["Wound07.ogg"] = 00.60,
						["Wound08.ogg"] = 00.56,
						["WoundCritical01.ogg"] = 01.21,
						["WoundCritical02.ogg"] = 01.39,
						["WoundCritical03.ogg"] = 01.15,
						["WoundCritical04.ogg"] = 01.66,
						["WoundCritical05.ogg"] = 00.59,
					},
				},
				["GlubtokHead1\\VO_"] = {
					["DM_GlubtokHead1_"] = {
						["Aggro01.ogg"] = 04.14,
						["Kill01.ogg"] = 02.09,
						["Spell01.ogg"] = 02.42,
						["Spell02.ogg"] = 01.45,
					},
				},
				["GlubtokHead2\\VO_"] = {
					["DM_GlubtokHead2_"] = {
						["Kill01.ogg"] = 02.01,
						["Spell01.ogg"] = 03.25,
						["Spell02.ogg"] = 01.66,
					},
				},
				["Glutton\\"] = {
					["GluttonAggro01.ogg"] = 03.34,
					["GluttonSlay01.ogg"] = 02.78,
				},
				["Gnoll\\"] = {
					["mGnollAggro1.ogg"] = 01.29,
					["mGnollAggro2.ogg"] = 00.86,
					["mGnollAggro3.ogg"] = 01.99,
					["mGnollAttack1.ogg"] = 00.65,
					["mGnollAttack2.ogg"] = 00.66,
					["mGnollAttack3.ogg"] = 00.78,
					["mGnollAttack4.ogg"] = 00.63,
					["mGnollAttack5.ogg"] = 00.59,
					["mGnollAttack6.ogg"] = 00.45,
					["mGnollAttack7.ogg"] = 00.76,
					["mGnollDeath1.ogg"] = 01.30,
					["mGnollFidget1.ogg"] = 00.90,
					["mGnollFidget2.ogg"] = 00.93,
					["mGnollFidget3.ogg"] = 00.64,
					["mGnollPreAggro1.ogg"] = 00.60,
					["mGnollWound1.ogg"] = 00.67,
					["mGnollWound2.ogg"] = 00.50,
					["mGnollWound3.ogg"] = 00.41,
					["mGnollWound4.ogg"] = 00.50,
					["mGnollWoundCritical1.ogg"] = 01.36,
				},
				["Gnome\\"] = {
					["GnomeAggroA.ogg"] = 00.69,
					["GnomeAttackA.ogg"] = 01.19,
					["GnomeAttackB.ogg"] = 00.60,
					["GnomeAttackC.ogg"] = 00.87,
					["GnomeDeathA.ogg"] = 02.39,
					["GnomeSpellCastOmniA.ogg"] = 01.20,
					["GnomeWoundA.ogg"] = 00.65,
					["GnomeWoundB.ogg"] = 00.68,
					["GnomeWoundC.ogg"] = 00.65,
					["GnomeWoundCritA.ogg"] = 01.19,
				},
				["GnomeCrew01\\VO_"] = {
					["QE_VJ_"] = {
						["GnomeCrew01_"] = {
							["Cavern04.ogg"] = 01.93,
							["Cavern05.ogg"] = 02.93,
							["Cavern06.ogg"] = 04.50,
						},
					},
				},
				["GnomeCrew02\\VO_"] = {
					["QE_VJ_"] = {
						["GnomeCrew02_"] = {
							["AllianceSub01.ogg"] = 02.88,
							["AllianceSub02.ogg"] = 03.91,
							["AllianceSub03.ogg"] = 01.31,
							["AllianceSub04.ogg"] = 01.34,
							["AllianceSub05.ogg"] = 01.94,
							["AllianceSub06.ogg"] = 02.54,
						},
					},
				},
				["GnomeFemaleHappyNPC\\"] = {
					["GnomeFemaleHappyNPCFarewell01.ogg"] = 01.19,
					["GnomeFemaleHappyNPCFarewell02.ogg"] = 01.62,
					["GnomeFemaleHappyNPCFarewell03.ogg"] = 00.90,
					["GnomeFemaleHappyNPCFarewell04.ogg"] = 00.87,
					["GnomeFemaleHappyNPCFarewell05.ogg"] = 00.48,
					["GnomeFemaleHappyNPCGreeting01.ogg"] = 01.57,
					["GnomeFemaleHappyNPCGreeting02.ogg"] = 00.87,
					["GnomeFemaleHappyNPCGreeting03.ogg"] = 00.66,
					["GnomeFemaleHappyNPCGreeting04.ogg"] = 00.75,
					["GnomeFemaleHappyNPCGreeting05.ogg"] = 01.25,
					["GnomeFemaleHappyNPCGreeting06.ogg"] = 03.05,
					["GnomeFemaleHappyNPCPissed01.ogg"] = 01.23,
					["GnomeFemaleHappyNPCPissed02.ogg"] = 02.06,
					["GnomeFemaleHappyNPCPissed03.ogg"] = 01.40,
					["GnomeFemaleHappyNPCPissed04.ogg"] = 01.61,
					["GnomeFemaleHappyNPCPissed05.ogg"] = 00.96,
					["GnomeFemaleHappyNPCVendor01.ogg"] = 01.38,
					["GnomeFemaleHappyNPCVendor02.ogg"] = 01.50,
				},
				["GnomeFemaleNerdyNPC\\"] = {
					["GnomeFemaleNerdyNPCFarewell01.ogg"] = 01.47,
					["GnomeFemaleNerdyNPCFarewell02.ogg"] = 00.83,
					["GnomeFemaleNerdyNPCFarewell03.ogg"] = 00.69,
					["GnomeFemaleNerdyNPCFarewell04.ogg"] = 00.66,
					["GnomeFemaleNerdyNPCFarewell05.ogg"] = 00.78,
					["GnomeFemaleNerdyNPCGreeting01.ogg"] = 00.43,
					["GnomeFemaleNerdyNPCGreeting02.ogg"] = 00.75,
					["GnomeFemaleNerdyNPCGreeting03.ogg"] = 00.74,
					["GnomeFemaleNerdyNPCGreeting04.ogg"] = 01.88,
					["GnomeFemaleNerdyNPCGreeting05.ogg"] = 00.94,
					["GnomeFemaleNerdyNPCPissed01.ogg"] = 00.94,
					["GnomeFemaleNerdyNPCPissed02.ogg"] = 01.42,
					["GnomeFemaleNerdyNPCPissed03.ogg"] = 01.18,
					["GnomeFemaleNerdyNPCPissed04.ogg"] = 00.62,
					["GnomeFemaleNerdyNPCVendor01.ogg"] = 01.33,
					["GnomeFemaleNerdyNPCVendor02.ogg"] = 01.25,
				},
				["GnomeFemaleStandardNPC\\"] = {
					["GnomeFemaleStandardNPCFarewell01.ogg"] = 00.59,
					["GnomeFemaleStandardNPCFarewell02.ogg"] = 00.78,
					["GnomeFemaleStandardNPCFarewell03.ogg"] = 00.63,
					["GnomeFemaleStandardNPCFarewell04.ogg"] = 00.89,
					["GnomeFemaleStandardNPCFarewell05.ogg"] = 01.19,
					["GnomeFemaleStandardNPCGreeting01.ogg"] = 00.92,
					["GnomeFemaleStandardNPCGreeting02.ogg"] = 00.65,
					["GnomeFemaleStandardNPCGreeting03.ogg"] = 00.77,
					["GnomeFemaleStandardNPCGreeting04.ogg"] = 00.32,
					["GnomeFemaleStandardNPCGreeting05.ogg"] = 01.12,
					["GnomeFemaleStandardNPCGreeting06.ogg"] = 00.72,
					["GnomeFemaleStandardNPCPissed01.ogg"] = 00.89,
					["GnomeFemaleStandardNPCPissed02.ogg"] = 01.42,
					["GnomeFemaleStandardNPCPissed03.ogg"] = 01.41,
					["GnomeFemaleStandardNPCPissed04.ogg"] = 00.67,
					["GnomeFemaleStandardNPCVendor01.ogg"] = 01.33,
					["GnomeFemaleStandardNPCVendor02.ogg"] = 01.40,
				},
				["GnomeMale\\VO_"] = {
					["GnomeMale_Scream_"] = {
						["01.ogg"] = 01.66,
						["02.ogg"] = 01.00,
						["03.ogg"] = 01.00,
						["04.ogg"] = 02.09,
						["05.ogg"] = 01.00,
						["06.ogg"] = 02.25,
						["07.ogg"] = 01.18,
						["08.ogg"] = 01.94,
						["09.ogg"] = 01.00,
						["10.ogg"] = 01.36,
					},
				},
				["GnomeMaleStandardNPC\\"] = {
					["GnomeMaleStandardNPCFarewell01.ogg"] = 01.19,
					["GnomeMaleStandardNPCFarewell02.ogg"] = 00.78,
					["GnomeMaleStandardNPCFarewell03.ogg"] = 00.64,
					["GnomeMaleStandardNPCFarewell04.ogg"] = 01.00,
					["GnomeMaleStandardNPCFarewell05.ogg"] = 00.29,
					["GnomeMaleStandardNPCGreeting01.ogg"] = 00.42,
					["GnomeMaleStandardNPCGreeting02.ogg"] = 00.62,
					["GnomeMaleStandardNPCGreeting03.ogg"] = 00.66,
					["GnomeMaleStandardNPCGreeting04.ogg"] = 01.08,
					["GnomeMaleStandardNPCGreeting05.ogg"] = 01.06,
					["GnomeMaleStandardNPCGreeting06.ogg"] = 00.77,
					["GnomeMaleStandardNPCPissed01.ogg"] = 01.24,
					["GnomeMaleStandardNPCPissed02.ogg"] = 01.58,
					["GnomeMaleStandardNPCPissed03.ogg"] = 01.37,
					["GnomeMaleStandardNPCPissed04.ogg"] = 00.83,
					["GnomeMaleStandardNPCVendor01.ogg"] = 01.37,
					["GnomeMaleStandardNPCVendor02.ogg"] = 01.29,
				},
				["GnomeMaleYoungNPC\\"] = {
					["GnomeMaleYoungNPCFarewell01.ogg"] = 00.52,
					["GnomeMaleYoungNPCFarewell02.ogg"] = 00.76,
					["GnomeMaleYoungNPCFarewell03.ogg"] = 00.85,
					["GnomeMaleYoungNPCFarewell04.ogg"] = 00.87,
					["GnomeMaleYoungNPCGreeting01.ogg"] = 00.90,
					["GnomeMaleYoungNPCGreeting02.ogg"] = 00.58,
					["GnomeMaleYoungNPCGreeting03.ogg"] = 00.93,
					["GnomeMaleYoungNPCGreeting04.ogg"] = 00.69,
					["GnomeMaleYoungNPCPissed01.ogg"] = 01.01,
					["GnomeMaleYoungNPCPissed02.ogg"] = 00.81,
					["GnomeMaleYoungNPCPissed03.ogg"] = 01.24,
					["GnomeMaleYoungNPCVendor01.ogg"] = 01.30,
					["GnomeMaleYoungNPCVendor02.ogg"] = 01.26,
				},
				["GnomeMaleZanyNPC\\"] = {
					["GnomeMaleZanyFarewell01.ogg"] = 01.11,
					["GnomeMaleZanyFarewell02.ogg"] = 01.15,
					["GnomeMaleZanyFarewell03.ogg"] = 00.78,
					["GnomeMaleZanyFarewell04.ogg"] = 01.23,
					["GnomeMaleZanyGreetings01.ogg"] = 01.07,
					["GnomeMaleZanyGreetings02.ogg"] = 00.68,
					["GnomeMaleZanyGreetings03.ogg"] = 00.88,
					["GnomeMaleZanyGreetings04.ogg"] = 00.96,
					["GnomeMaleZanyGreetings05.ogg"] = 00.50,
					["GnomeMaleZanyGreetings06.ogg"] = 01.73,
					["GnomeMaleZanyPissed01.ogg"] = 00.89,
					["GnomeMaleZanyPissed02.ogg"] = 01.82,
					["GnomeMaleZanyPissed03.ogg"] = 02.29,
					["GnomeMaleZanyPissed04.ogg"] = 01.06,
					["GnomeMaleZanyVendor01.ogg"] = 01.59,
					["GnomeMaleZanyVendor02.ogg"] = 01.99,
				},
				["GnomePounder\\"] = {
					["GnomePounderAttackA.ogg"] = 02.21,
					["GnomePounderAttackB.ogg"] = 01.70,
					["GnomePounderAttackC.ogg"] = 01.51,
					["GnomePounderAttackD.ogg"] = 01.96,
					["GnomePounderAttackE.ogg"] = 02.47,
					["GnomePounderDeath.ogg"] = 04.80,
					["GnomePounderWoundA.ogg"] = 02.08,
					["GnomePounderWoundB.ogg"] = 00.98,
					["GnomePounderWoundC.ogg"] = 03.67,
					["GnomePounderWoundCrit.ogg"] = 03.06,
					["GnomePounderWoundD.ogg"] = 02.44,
				},
				["GnomeRockCutter\\MON_"] = {
					["GnomeRockCutter_"] = {
						["Stand01.OGG"] = 11.00,
						["Stand02.OGG"] = 10.00,
					},
				},
				["GnomeSpiderTank\\"] = {
					["GnomeSpiderTankAggro.ogg"] = 02.32,
					["GnomeSpiderTankAttackA.ogg"] = 01.86,
					["GnomeSpiderTankAttackB.ogg"] = 01.49,
					["GnomeSpiderTankAttackC.ogg"] = 01.63,
					["GnomeSpiderTankAttackD.ogg"] = 02.00,
					["GnomeSpiderTankDeath.ogg"] = 04.25,
					["GnomeSpiderTankFootstepA.ogg"] = 00.47,
					["GnomeSpiderTankFootstepB.ogg"] = 00.46,
					["GnomeSpiderTankFootstepC.ogg"] = 00.63,
					["GnomeSpiderTankFootstepD.ogg"] = 01.07,
					["GnomeSpiderTankLoop.ogg"] = 04.65,
					["GnomeSpiderTankPreAggro.ogg"] = 02.00,
					["GnomeSpiderTankWoundA.ogg"] = 01.78,
					["GnomeSpiderTankWoundB.ogg"] = 01.73,
					["GnomeSpiderTankWoundC.ogg"] = 01.59,
					["GnomeSpiderTankWoundCrit.ogg"] = 02.64,
					["GnomeSpiderTankWoundD.ogg"] = 00.37,
					["GnomeSpiderTankWoundE.ogg"] = 00.49,
					["GnomeSpiderTankWoundF.ogg"] = 00.37,
				},
				["GnomeSpiderTank02\\"] = {
					["GnomeSpiderTank02Attack_"] = {
						["NoGun1.ogg"] = 01.86,
						["NoGun2.ogg"] = 01.49,
						["NoGun3.ogg"] = 01.63,
						["NoGun4.ogg"] = 01.89,
					},
					["GnomeSpiderTank02Death.ogg"] = 04.25,
					["GnomeSpiderTank02WoundCrit.ogg"] = 02.64,
				},
				["Goblin\\"] = {
					["GoblinAggroA.ogg"] = 01.26,
					["GoblinAttackA.ogg"] = 00.49,
					["GoblinAttackB.ogg"] = 00.46,
					["GoblinAttackC.ogg"] = 00.62,
					["GoblinDeathA.ogg"] = 01.06,
					["GoblinPreAggro.ogg"] = 00.33,
					["GoblinStand3.ogg"] = 01.41,
					["GoblinWoundA.ogg"] = 00.43,
					["GoblinWoundB.ogg"] = 00.50,
					["GoblinWoundC.ogg"] = 00.61,
					["GoblinWoundCrit.ogg"] = 00.95,
				},
				["Goblin01\\VO_"] = {
					["Horde_Zeppelin_"] = {
						["Goblin_"] = {
							["01.OGG"] = 01.63,
							["03.OGG"] = 02.77,
						},
					},
				},
				["GoblinCivF\\VO_"] = {
					["GoblinCivF_"] = {
						["Farewell01.ogg"] = 01.26,
						["Farewell02.ogg"] = 00.82,
						["Farewell03.ogg"] = 01.25,
						["Farewell04.ogg"] = 01.17,
						["Farewell05.ogg"] = 01.24,
						["Farewell06.ogg"] = 01.18,
						["Farewell07.ogg"] = 01.85,
						["Farewell08.ogg"] = 01.17,
						["Farewell09.ogg"] = 00.77,
						["FarewellAggro01.ogg"] = 00.89,
						["FarewellAggro02.ogg"] = 00.99,
						["FarewellAggro03.ogg"] = 00.79,
						["FarewellAggro04.ogg"] = 01.12,
						["Greeting01.ogg"] = 01.30,
						["Greeting02.ogg"] = 01.21,
						["Greeting03.ogg"] = 01.67,
						["Greeting04.ogg"] = 01.04,
						["Greeting05.ogg"] = 00.61,
						["Greeting06.ogg"] = 01.46,
						["Greeting07.ogg"] = 01.75,
						["Greeting08.ogg"] = 01.86,
						["Greeting09.ogg"] = 00.89,
						["GreetingAggro01.ogg"] = 01.33,
						["GreetingAggro02.ogg"] = 00.70,
						["GreetingAggro03.ogg"] = 01.46,
						["GreetingAggro04.ogg"] = 00.97,
						["GreetingAggro05.ogg"] = 01.42,
						["Pissed01.ogg"] = 01.57,
						["Pissed02.ogg"] = 00.74,
						["Pissed03.ogg"] = 01.75,
						["Pissed04.ogg"] = 01.69,
						["Pissed05.ogg"] = 01.18,
						["Pissed06.ogg"] = 01.43,
						["Pissed07.ogg"] = 03.26,
						["Pissed08.ogg"] = 01.96,
						["Pissed09.ogg"] = 01.52,
						["Pissed10.ogg"] = 01.86,
					},
				},
				["GoblinCivM\\VO_"] = {
					["GoblinCivM_"] = {
						["Farewell01.ogg"] = 01.20,
						["Farewell02.ogg"] = 00.74,
						["Farewell03.ogg"] = 01.19,
						["Farewell04.ogg"] = 01.19,
						["Farewell05.ogg"] = 01.20,
						["Farewell06.ogg"] = 01.22,
						["Farewell07.ogg"] = 01.59,
						["Farewell08.ogg"] = 00.83,
						["Farewell09.ogg"] = 01.01,
						["FarewellAggro01.ogg"] = 01.25,
						["FarewellAggro02.ogg"] = 01.13,
						["FarewellAggro03.ogg"] = 00.99,
						["FarewellAggro04.ogg"] = 01.21,
						["FarewellAggro05.ogg"] = 01.43,
						["Greeting01.ogg"] = 01.23,
						["Greeting02.ogg"] = 00.98,
						["Greeting03.ogg"] = 01.27,
						["Greeting04.ogg"] = 00.72,
						["Greeting05.ogg"] = 04.82,
						["Greeting06.ogg"] = 00.44,
						["Greeting07.ogg"] = 01.07,
						["Greeting08.ogg"] = 00.93,
						["Greeting09.ogg"] = 01.49,
						["Greeting10.ogg"] = 00.59,
						["GreetingAggro01.ogg"] = 01.25,
						["GreetingAggro02.ogg"] = 00.78,
						["GreetingAggro03.ogg"] = 01.26,
						["GreetingAggro04.ogg"] = 01.20,
						["GreetingAggro05.ogg"] = 01.20,
						["Pissed01.ogg"] = 01.22,
						["Pissed02.ogg"] = 00.73,
						["Pissed03.ogg"] = 02.06,
						["Pissed04.ogg"] = 02.22,
						["Pissed05.ogg"] = 01.07,
						["Pissed06.ogg"] = 01.17,
						["Pissed07.ogg"] = 03.04,
						["Pissed08.ogg"] = 02.36,
						["Pissed09.ogg"] = 01.28,
						["Pissed10.ogg"] = 01.93,
					},
				},
				["GoblinCrew\\VO_"] = {
					["QE_VJ_"] = {
						["GoblinCrew_"] = {
							["Cavern01.ogg"] = 01.68,
							["Cavern02.ogg"] = 02.84,
							["Cavern03.ogg"] = 04.33,
						},
					},
				},
				["GoblinFemale\\GoblinFemale_"] = {
					["Attack01.ogg"] = 00.42,
					["Attack02.ogg"] = 00.33,
					["Attack03.ogg"] = 00.41,
					["Attack04.ogg"] = 00.38,
					["Attack05.ogg"] = 00.28,
					["Attack06.ogg"] = 00.36,
					["Attack07.ogg"] = 00.43,
					["Attack08.ogg"] = 00.46,
					["Attack09.ogg"] = 00.43,
					["Attack10.ogg"] = 00.37,
					["AttackCrit01.ogg"] = 01.02,
					["AttackCrit02.ogg"] = 00.88,
					["AttackCrit03.ogg"] = 00.94,
					["AttackCrit04.ogg"] = 01.23,
					["AttackCrit05.ogg"] = 00.83,
					["Death01.ogg"] = 00.96,
					["Death02.ogg"] = 01.09,
					["Death03.ogg"] = 02.86,
					["Death04.ogg"] = 01.79,
					["Death05.ogg"] = 02.09,
					["Wound01.ogg"] = 00.57,
					["Wound02.ogg"] = 00.80,
					["Wound03.ogg"] = 00.33,
					["Wound04.ogg"] = 00.33,
					["Wound05.ogg"] = 00.32,
					["Wound06.ogg"] = 00.53,
					["Wound07.ogg"] = 00.48,
					["Wound08.ogg"] = 00.55,
					["WoundCrit01.ogg"] = 01.05,
					["WoundCrit02.ogg"] = 00.66,
					["WoundCrit03.ogg"] = 01.27,
					["WoundCrit04.ogg"] = 00.45,
				},
				["GoblinFemaleZanyNPC\\"] = {
					["GoblinFemaleZanyNPCFarewell01.ogg"] = 01.01,
					["GoblinFemaleZanyNPCFarewell02.ogg"] = 00.68,
					["GoblinFemaleZanyNPCFarewell03.ogg"] = 00.92,
					["GoblinFemaleZanyNPCFarewell04.ogg"] = 00.98,
					["GoblinFemaleZanyNPCFarewell05.ogg"] = 01.59,
					["GoblinFemaleZanyNPCFarewell06.ogg"] = 01.83,
					["GoblinFemaleZanyNPCFarewell07.ogg"] = 00.50,
					["GoblinFemaleZanyNPCFarewell08.ogg"] = 01.24,
					["GoblinFemaleZanyNPCGreeting01.ogg"] = 00.81,
					["GoblinFemaleZanyNPCGreeting02.ogg"] = 01.31,
					["GoblinFemaleZanyNPCGreeting03.ogg"] = 01.21,
					["GoblinFemaleZanyNPCGreeting04.ogg"] = 01.61,
					["GoblinFemaleZanyNPCGreeting05.ogg"] = 01.34,
					["GoblinFemaleZanyNPCGreeting06.ogg"] = 02.44,
					["GoblinFemaleZanyNPCGreeting07.ogg"] = 01.40,
					["GoblinFemaleZanyNPCGreeting08.ogg"] = 01.88,
					["GoblinFemaleZanyNPCGreeting09.ogg"] = 01.97,
					["GoblinFemaleZanyNPCGreeting10.ogg"] = 02.95,
					["GoblinFemaleZanyNPCGreeting11.ogg"] = 00.32,
					["GoblinFemaleZanyNPCGreeting12.ogg"] = 01.96,
					["GoblinFemaleZanyNPCPissed01.ogg"] = 02.04,
					["GoblinFemaleZanyNPCPissed02.ogg"] = 01.99,
					["GoblinFemaleZanyNPCPissed03.ogg"] = 01.88,
					["GoblinFemaleZanyNPCPissed04.ogg"] = 02.02,
					["GoblinFemaleZanyNPCPissed05.ogg"] = 00.59,
					["GoblinFemaleZanyNPCPissed06.ogg"] = 01.66,
					["GoblinFemaleZanyNPCPissed07.ogg"] = 02.87,
					["GoblinFemaleZanyNPCPissed08.ogg"] = 01.91,
					["GoblinFemaleZanyNPCVendor01.ogg"] = 01.20,
					["GoblinFemaleZanyNPCVendor02.ogg"] = 02.26,
				},
				["GoblinGuardF\\VO_"] = {
					["GoblinGuardF_"] = {
						["Farewell01.ogg"] = 00.94,
						["Farewell02.ogg"] = 03.05,
						["Farewell03.ogg"] = 01.30,
						["Farewell04.ogg"] = 01.40,
						["Farewell05.ogg"] = 01.92,
						["Farewell06.ogg"] = 01.02,
						["Farewell07.ogg"] = 02.13,
						["Farewell08.ogg"] = 02.16,
						["Farewell09.ogg"] = 03.40,
						["Farewell10.ogg"] = 02.49,
						["FarewellAggro01.ogg"] = 01.08,
						["FarewellAggro02.ogg"] = 00.83,
						["FarewellAggro03.ogg"] = 00.76,
						["FarewellAggro04.ogg"] = 01.40,
						["Greeting01.ogg"] = 01.49,
						["Greeting02.ogg"] = 00.96,
						["Greeting03.ogg"] = 01.09,
						["Greeting04.ogg"] = 02.50,
						["Greeting05.ogg"] = 02.61,
						["Greeting06.ogg"] = 01.87,
						["Greeting07.ogg"] = 01.15,
						["Greeting08.ogg"] = 01.21,
						["Greeting09.ogg"] = 01.05,
						["Greeting10.ogg"] = 01.26,
						["GreetingAggro01.ogg"] = 01.36,
						["GreetingAggro02.ogg"] = 00.79,
						["GreetingAggro03.ogg"] = 01.45,
						["GreetingAggro04.ogg"] = 01.71,
						["Pissed01.ogg"] = 01.32,
						["Pissed02.ogg"] = 01.73,
						["Pissed03.ogg"] = 01.22,
						["Pissed04.ogg"] = 00.81,
						["Pissed05.ogg"] = 01.49,
						["Pissed06.ogg"] = 01.32,
						["Pissed07.ogg"] = 00.95,
						["Pissed08.ogg"] = 01.04,
						["Pissed09.ogg"] = 01.92,
						["Pissed10.ogg"] = 01.63,
					},
				},
				["GoblinGuardM\\VO_"] = {
					["GoblinGuardM_"] = {
						["Farewell01.ogg"] = 01.19,
						["Farewell02.ogg"] = 02.65,
						["Farewell03.ogg"] = 01.36,
						["Farewell04.ogg"] = 01.21,
						["Farewell05.ogg"] = 01.74,
						["Farewell06.ogg"] = 01.15,
						["Farewell07.ogg"] = 02.44,
						["Farewell08.ogg"] = 02.09,
						["Farewell09.ogg"] = 03.76,
						["Farewell10.ogg"] = 02.36,
						["Greeting01.ogg"] = 01.38,
						["Greeting02.ogg"] = 00.86,
						["Greeting03.ogg"] = 01.34,
						["Greeting04.ogg"] = 02.33,
						["Greeting05.ogg"] = 02.23,
						["Greeting06.ogg"] = 01.85,
						["Greeting07.ogg"] = 01.02,
						["Greeting08.ogg"] = 02.26,
						["Greeting09.ogg"] = 01.25,
						["Greeting10.ogg"] = 01.82,
						["Pissed01.ogg"] = 01.53,
						["Pissed02.ogg"] = 01.97,
						["Pissed03.ogg"] = 01.62,
						["Pissed04.ogg"] = 00.65,
						["Pissed05.ogg"] = 01.78,
						["Pissed06.ogg"] = 01.32,
						["Pissed07.ogg"] = 01.16,
						["Pissed08.ogg"] = 00.97,
						["Pissed09.ogg"] = 03.08,
						["Pissed10.ogg"] = 01.65,
					},
				},
				["GoblinHotAirBalloon\\GoblinHotAirBalloon_"] = {
					["AirBurst_01.ogg"] = 01.56,
					["IDLE_01.ogg"] = 10.00,
				},
				["GoblinHotrod\\Goblinhotrod_"] = {
					["Engine_"] = {
						["Backfire_"] = {
							["01.ogg"] = 00.58,
							["02.ogg"] = 00.47,
						},
						["Idle_LP_"] = {
							["01.ogg"] = 04.00,
							["02.ogg"] = 04.00,
						},
						["Sputters_OS_"] = {
							["01.ogg"] = 01.31,
							["02.ogg"] = 01.33,
							["03.ogg"] = 01.30,
						},
						["StartUp.ogg"] = 02.21,
						["TurnOff.ogg"] = 00.98,
						["Accel_OS_01.ogg"] = 01.00,
						["Drive_LP_01.ogg"] = 07.36,
					},
					["Horn.ogg"] = 01.46,
				},
				["GoblinMale\\GoblinMale_"] = {
					["Attack01.ogg"] = 00.50,
					["Attack02.ogg"] = 00.35,
					["Attack03.ogg"] = 00.44,
					["Attack04.ogg"] = 00.46,
					["Attack05.ogg"] = 00.38,
					["Attack06.ogg"] = 00.38,
					["Attack07.ogg"] = 00.39,
					["Attack08.ogg"] = 00.62,
					["Attack09.ogg"] = 00.39,
					["Attack10.ogg"] = 00.65,
					["AttackCrit01.ogg"] = 00.72,
					["AttackCrit02.ogg"] = 00.75,
					["AttackCrit03.ogg"] = 00.76,
					["AttackCrit04.ogg"] = 00.75,
					["AttackCrit05.ogg"] = 00.65,
					["Death01.ogg"] = 01.85,
					["Death02.ogg"] = 02.32,
					["Death03.ogg"] = 02.37,
					["Death04.ogg"] = 02.75,
					["Death05.ogg"] = 02.07,
					["Death06.ogg"] = 02.70,
					["Wound01.ogg"] = 00.57,
					["Wound02.ogg"] = 00.55,
					["Wound03.ogg"] = 00.62,
					["Wound04.ogg"] = 00.50,
					["Wound05.ogg"] = 00.72,
					["Wound06.ogg"] = 01.01,
					["Wound07.ogg"] = 00.83,
					["Wound08.ogg"] = 00.68,
					["Wound09.ogg"] = 00.51,
					["Wound10.ogg"] = 00.38,
					["WoundCrit01.ogg"] = 00.64,
					["WoundCrit02.ogg"] = 00.62,
					["WoundCrit03.ogg"] = 00.65,
					["WoundCrit04.ogg"] = 00.63,
				},
				["GoblinMaleGruffNPC\\"] = {
					["GoblinMaleGruffNPCFarewell01.ogg"] = 00.83,
					["GoblinMaleGruffNPCFarewell02.ogg"] = 00.90,
					["GoblinMaleGruffNPCFarewell03.ogg"] = 01.66,
					["GoblinMaleGruffNPCFarewell04.ogg"] = 00.54,
					["GoblinMaleGruffNPCGreeting01.ogg"] = 01.60,
					["GoblinMaleGruffNPCGreeting02.ogg"] = 00.42,
					["GoblinMaleGruffNPCGreeting03.ogg"] = 01.73,
					["GoblinMaleGruffNPCGreeting04.ogg"] = 01.57,
					["GoblinMaleGruffNPCGreeting05.ogg"] = 02.06,
					["GoblinMaleGruffNPCGreeting06.ogg"] = 00.36,
					["GoblinMaleGruffNPCPissed01.ogg"] = 01.70,
					["GoblinMaleGruffNPCPissed02.ogg"] = 01.69,
					["GoblinMaleGruffNPCPissed03.ogg"] = 01.43,
					["GoblinMaleGruffNPCPissed04.ogg"] = 01.51,
					["GoblinMaleGruffNPCPissed05.ogg"] = 00.87,
					["GoblinMaleGruffNPCVendor01.ogg"] = 01.40,
					["GoblinMaleGruffNPCVendor02.ogg"] = 01.66,
				},
				["GoblinMaleGuardNPC\\"] = {
					["GoblinMaleGuardNPCFarewell01.ogg"] = 00.72,
					["GoblinMaleGuardNPCFarewell02.ogg"] = 00.75,
					["GoblinMaleGuardNPCFarewell03.ogg"] = 00.66,
					["GoblinMaleGuardNPCFarewell04.ogg"] = 00.92,
					["GoblinMaleGuardNPCFarewell05.ogg"] = 00.59,
					["GoblinMaleGuardNPCGreeting01.ogg"] = 00.49,
					["GoblinMaleGuardNPCGreeting02.ogg"] = 01.50,
					["GoblinMaleGuardNPCGreeting03.ogg"] = 01.30,
					["GoblinMaleGuardNPCGreeting04.ogg"] = 00.92,
					["GoblinMaleGuardNPCGreeting05.ogg"] = 00.46,
					["GoblinMaleGuardNPCPissed01.ogg"] = 01.51,
					["GoblinMaleGuardNPCPissed02.ogg"] = 01.21,
					["GoblinMaleGuardNPCPissed03.ogg"] = 02.17,
					["GoblinMaleGuardNPCPissed04.ogg"] = 00.70,
					["GoblinMaleGuardNPCVendor01.ogg"] = 01.91,
					["GoblinMaleGuardNPCVendor02.ogg"] = 01.68,
				},
				["GoblinMaleZanyNPC\\"] = {
					["GoblinMaleZanyNPCFarewell01.ogg"] = 00.68,
					["GoblinMaleZanyNPCFarewell02.ogg"] = 01.16,
					["GoblinMaleZanyNPCFarewell03.ogg"] = 00.63,
					["GoblinMaleZanyNPCFarewell04.ogg"] = 01.45,
					["GoblinMaleZanyNPCGreeting01.ogg"] = 01.36,
					["GoblinMaleZanyNPCGreeting02.ogg"] = 00.41,
					["GoblinMaleZanyNPCGreeting03.ogg"] = 01.58,
					["GoblinMaleZanyNPCGreeting04.ogg"] = 00.52,
					["GoblinMaleZanyNPCGreeting05.ogg"] = 01.46,
					["GoblinMaleZanyNPCGreeting06.ogg"] = 00.40,
					["GoblinMaleZanyNPCPissed01.ogg"] = 01.31,
					["GoblinMaleZanyNPCPissed02.ogg"] = 01.88,
					["GoblinMaleZanyNPCPissed03.ogg"] = 01.38,
					["GoblinMaleZanyNPCPissed04.ogg"] = 00.67,
					["GoblinMaleZanyNPCVendor01.ogg"] = 01.42,
					["GoblinMaleZanyNPCVendor02.ogg"] = 01.85,
				},
				["GoblinRiverBoat\\GoblinRiverBoat_"] = {
					["Engine_"] = {
						["Accel_01.ogg"] = 01.07,
						["Drive_01.ogg"] = 10.00,
						["Idle_01.ogg"] = 04.25,
					},
					["Water_"] = {
						["Driving_01.ogg"] = 04.52,
						["Lapping_01.ogg"] = 05.00,
					},
				},
				["GoblinShredder\\"] = {
					["Footstep_GoblinShredderMount_"] = {
						["General_"] = {
							["01.OGG"] = 00.43,
							["02.OGG"] = 00.36,
							["03.OGG"] = 00.46,
							["04.OGG"] = 00.47,
							["05.OGG"] = 00.35,
							["06.OGG"] = 00.37,
							["07.OGG"] = 00.36,
							["08.OGG"] = 00.33,
						},
					},
					["MON_GoblinShredder_"] = {
						["Mount_"] = {
							["FlightStart_"] = {
								["01.OGG"] = 04.00,
								["02.OGG"] = 04.95,
								["03.OGG"] = 04.89,
								["04.OGG"] = 04.63,
								["05.OGG"] = 04.95,
							},
							["Gears_"] = {
								["01.OGG"] = 00.98,
								["010.OGG"] = 00.83,
								["02.OGG"] = 01.16,
								["03.OGG"] = 01.07,
								["04.OGG"] = 01.01,
								["05.OGG"] = 00.93,
								["06.OGG"] = 00.69,
								["07.OGG"] = 00.67,
								["08.OGG"] = 00.35,
								["09.OGG"] = 00.73,
							},
							["Land_"] = {
								["01.OGG"] = 01.19,
								["02.OGG"] = 01.53,
								["03.OGG"] = 01.52,
								["04.OGG"] = 01.45,
								["05.OGG"] = 01.12,
							},
							["Special_"] = {
								["01.OGG"] = 06.59,
								["02.OGG"] = 06.82,
								["03.OGG"] = 06.66,
								["04.OGG"] = 06.33,
								["05.OGG"] = 06.50,
							},
							["TakeFlightGearshiftNoBoom_"] = {
								["01.OGG"] = 02.54,
								["02.OGG"] = 02.52,
								["03.OGG"] = 02.01,
								["04.OGG"] = 02.00,
								["05.OGG"] = 03.30,
								["06.OGG"] = 03.17,
							},
							["TakeFlightGearshift_"] = {
								["01.OGG"] = 02.76,
								["02.OGG"] = 03.06,
								["03.OGG"] = 03.11,
								["04.OGG"] = 03.14,
								["05.OGG"] = 03.25,
								["06.OGG"] = 03.14,
							},
							["FlightEnd.OGG"] = 00.89,
							["FlightBackward_LP.OGG"] = 07.18,
							["FlightIdle_LP.OGG"] = 07.18,
							["FlightLeftRight_LP.OGG"] = 06.98,
							["FlightRun_LP.OGG"] = 05.36,
							["IdleStand_LP.OGG"] = 06.27,
							["SwimWaterLayer_LP.OGG"] = 07.18,
							["Swim_LP.OGG"] = 06.07,
						},
					},
					["GoblinShredderAggro.ogg"] = 01.67,
					["GoblinShredderAttackA.ogg"] = 01.62,
					["GoblinShredderAttackB.ogg"] = 01.76,
					["GoblinShredderAttackC.ogg"] = 02.01,
					["GoblinShredderDeathA.ogg"] = 04.53,
					["GoblinShredderLoop.ogg"] = 05.00,
					["GoblinShredderPreAggro.ogg"] = 01.28,
					["GoblinShredderWoundA.ogg"] = 01.57,
					["GoblinShredderWoundB.ogg"] = 01.58,
					["GoblinShredderWoundC.ogg"] = 01.60,
					["GoblinShredderWoundCrit.ogg"] = 01.88,
				},
				["GoblinShredderPet\\PET_"] = {
					["GoblinShredder_"] = {
						["Clickables_"] = {
							["01.ogg"] = 01.59,
							["02.ogg"] = 01.45,
							["03.ogg"] = 01.13,
							["04.ogg"] = 01.11,
							["05.ogg"] = 01.10,
							["06.ogg"] = 00.90,
							["07.ogg"] = 01.16,
							["08.ogg"] = 00.98,
						},
						["Death_"] = {
							["01.ogg"] = 02.31,
							["02.ogg"] = 02.44,
							["03.ogg"] = 02.34,
							["04.ogg"] = 02.38,
							["05.ogg"] = 02.30,
						},
						["Stand1_"] = {
							["01.ogg"] = 03.48,
							["02.ogg"] = 03.33,
							["03.ogg"] = 03.49,
						},
						["Wound_"] = {
							["01.ogg"] = 01.64,
							["02.ogg"] = 01.17,
							["03.ogg"] = 01.95,
							["04.ogg"] = 01.61,
							["05.ogg"] = 01.58,
							["06.ogg"] = 01.51,
							["07.ogg"] = 01.26,
						},
					},
				},
				["GoblinTrike\\VEH_"] = {
					["GoblinTrike_"] = {
						["Turn_"] = {
							["01.ogg"] = 00.98,
							["02.ogg"] = 01.09,
						},
						["Drive_Loop_01.ogg"] = 06.33,
						["Idle_Loop_01.ogg"] = 05.00,
						["Rev_01.ogg"] = 01.31,
						["SingleRev_01.ogg"] = 00.55,
					},
				},
				["GoblinVendorF\\VO_"] = {
					["GoblinVenF_"] = {
						["Farewell01.ogg"] = 02.82,
						["Farewell02.ogg"] = 03.34,
						["Farewell03.ogg"] = 01.58,
						["Farewell04.ogg"] = 02.25,
						["Farewell05.ogg"] = 02.35,
						["Farewell06.ogg"] = 02.55,
						["Farewell07.ogg"] = 02.72,
						["Farewell08.ogg"] = 00.91,
						["Farewell09.ogg"] = 02.54,
						["Farewell10.ogg"] = 01.84,
						["FarewellAggro01.ogg"] = 01.18,
						["FarewellAggro02.ogg"] = 01.17,
						["FarewellAggro03.ogg"] = 00.46,
						["Greeting01.ogg"] = 01.71,
						["Greeting02.ogg"] = 01.67,
						["Greeting03.ogg"] = 02.21,
						["Greeting04.ogg"] = 01.59,
						["Greeting05.ogg"] = 02.27,
						["Greeting06.ogg"] = 01.24,
						["Greeting07.ogg"] = 02.03,
						["Greeting08.ogg"] = 01.96,
						["Greeting09.ogg"] = 02.29,
						["Greeting10.ogg"] = 01.63,
						["GreetingAggro01.ogg"] = 01.70,
						["GreetingAggro02.ogg"] = 00.62,
						["GreetingAggro03.ogg"] = 01.40,
						["GreetingAggro04.ogg"] = 01.01,
						["GreetingAggro05.ogg"] = 01.51,
						["Pissed01.ogg"] = 01.81,
						["Pissed02.ogg"] = 01.52,
						["Pissed03.ogg"] = 02.47,
						["Pissed04.ogg"] = 02.09,
						["Pissed05.ogg"] = 01.54,
						["Pissed06.ogg"] = 01.46,
						["Pissed07.ogg"] = 04.02,
						["Pissed08.ogg"] = 04.22,
						["Pissed09.ogg"] = 01.97,
						["Pissed10.ogg"] = 02.31,
					},
				},
				["GoblinVendorM\\VO_"] = {
					["GoblinVenM_"] = {
						["Farewell01.ogg"] = 02.78,
						["Farewell02.ogg"] = 02.44,
						["Farewell03.ogg"] = 01.45,
						["Farewell04.ogg"] = 02.87,
						["Farewell05.ogg"] = 01.67,
						["Farewell06.ogg"] = 02.03,
						["Farewell07.ogg"] = 02.14,
						["Farewell08.ogg"] = 00.95,
						["Farewell09.ogg"] = 01.76,
						["Farewell10.ogg"] = 01.54,
						["FarewellAggro01.ogg"] = 01.14,
						["FarewellAggro02.ogg"] = 01.05,
						["FarewellAggro03.ogg"] = 01.15,
						["FarewellAggro04.ogg"] = 01.45,
						["Greeting01.ogg"] = 01.26,
						["Greeting02.ogg"] = 01.46,
						["Greeting03.ogg"] = 01.97,
						["Greeting04.ogg"] = 01.43,
						["Greeting05.ogg"] = 02.03,
						["Greeting06.ogg"] = 01.16,
						["Greeting07.ogg"] = 01.90,
						["Greeting08.ogg"] = 01.67,
						["Greeting09.ogg"] = 01.77,
						["Greeting10.ogg"] = 01.37,
						["GreetingAggro01.ogg"] = 01.33,
						["GreetingAggro02.ogg"] = 00.62,
						["GreetingAggro03.ogg"] = 02.14,
						["GreetingAggro04.ogg"] = 01.31,
						["GreetingAggro05.ogg"] = 01.08,
						["Pissed01.ogg"] = 01.76,
						["Pissed02.ogg"] = 01.32,
						["Pissed03.ogg"] = 02.68,
						["Pissed04.ogg"] = 01.96,
						["Pissed05.ogg"] = 01.13,
						["Pissed06.ogg"] = 01.19,
						["Pissed07.ogg"] = 03.66,
						["Pissed08.ogg"] = 02.51,
						["Pissed09.ogg"] = 02.53,
						["Pissed10.ogg"] = 01.59,
					},
				},
				["Goblin_Cannon\\"] = {
					["GoblinCannon_Loop.ogg"] = 20.95,
					["Goblin_CannonDeath.ogg"] = 04.36,
				},
				["Godfrey\\VO_"] = {
					["GI_Godfrey_"] = {
						["Betrayal01.ogg"] = 04.16,
						["Greeting01.ogg"] = 00.84,
						["Greeting02.ogg"] = 00.79,
						["HoldPos01.ogg"] = 02.65,
						["Prison01.ogg"] = 03.35,
						["Rescue01.ogg"] = 02.40,
						["Stocks01.ogg"] = 06.55,
						["Taldoren01.ogg"] = 14.10,
						["Taldoren02.ogg"] = 01.46,
					},
				},
				["Gogduh\\VO_"] = {
					["60_"] = {
						["6OM_FORGEMASTER_"] = {
							["OGRE_"] = {
								["EVENT_"] = {
									["01.OGG"] = 02.40,
									["02.OGG"] = 02.02,
								},
								["SPELL_"] = {
									["01.OGG"] = 02.48,
									["02.OGG"] = 01.60,
									["03.OGG"] = 02.03,
									["04.OGG"] = 01.37,
									["05.OGG"] = 02.75,
									["06.OGG"] = 01.83,
								},
								["AGGRO.OGG"] = 03.01,
								["DEATH.OGG"] = 04.49,
							},
						},
						["FORGEMASTER_OGRE_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 02.48,
								["02.OGG"] = 03.45,
								["03.OGG"] = 03.02,
								["04.OGG"] = 01.29,
								["05.OGG"] = 02.73,
							},
							["Attack_"] = {
								["01.OGG"] = 00.69,
								["010.OGG"] = 01.37,
								["02.OGG"] = 00.71,
								["03.OGG"] = 00.92,
								["04.OGG"] = 01.43,
								["05.OGG"] = 01.09,
								["06.OGG"] = 00.81,
								["07.OGG"] = 01.33,
								["08.OGG"] = 01.30,
								["09.OGG"] = 01.59,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.30,
								["02.OGG"] = 01.62,
								["03.OGG"] = 01.78,
								["04.OGG"] = 01.54,
								["05.OGG"] = 01.77,
							},
							["Wound_"] = {
								["01.OGG"] = 00.59,
								["010.OGG"] = 00.58,
								["02.OGG"] = 00.73,
								["03.OGG"] = 00.53,
								["04.OGG"] = 00.66,
								["05.OGG"] = 00.60,
								["06.OGG"] = 00.75,
								["07.OGG"] = 00.66,
								["08.OGG"] = 01.12,
								["09.OGG"] = 00.57,
							},
						},
					},
				},
				["GOLDFISH\\MON_"] = {
					["Goldfish_"] = {
						["aggro01.OGG"] = 01.87,
						["aggro02.OGG"] = 01.91,
						["aggro03.OGG"] = 01.99,
						["aggro04.OGG"] = 02.34,
						["aggro05.OGG"] = 02.41,
						["attack01.OGG"] = 01.58,
						["attack02.OGG"] = 01.80,
						["attack03.OGG"] = 01.60,
						["attack04.OGG"] = 01.54,
						["attack05.OGG"] = 01.41,
						["attack06.OGG"] = 01.75,
						["attack07.OGG"] = 01.68,
						["attack08.OGG"] = 01.58,
						["attack09.OGG"] = 01.73,
						["attack10.OGG"] = 01.64,
						["attackcrit01.OGG"] = 01.92,
						["attackcrit02.OGG"] = 02.02,
						["attackcrit03.OGG"] = 02.67,
						["attackcrit04.OGG"] = 02.10,
						["attackcrit05.OGG"] = 02.18,
						["Death01.OGG"] = 04.79,
						["Death02.OGG"] = 05.11,
						["Death03.OGG"] = 04.62,
						["Death04.OGG"] = 04.59,
						["Death05.OGG"] = 04.81,
						["Preaggro01.OGG"] = 01.84,
						["Preaggro02.OGG"] = 01.69,
						["Preaggro03.OGG"] = 01.76,
						["Preaggro04.OGG"] = 01.92,
						["Preaggro05.OGG"] = 01.89,
						["Wound01.OGG"] = 01.42,
						["Wound02.OGG"] = 01.71,
						["Wound03.OGG"] = 01.57,
						["Wound04.OGG"] = 01.91,
						["Wound05.OGG"] = 01.93,
						["Wound06.OGG"] = 02.34,
						["Wound07.OGG"] = 01.77,
						["Wound08.OGG"] = 01.67,
						["Wound09.OGG"] = 01.63,
						["Wound10.OGG"] = 02.56,
						["Woundcrit01.OGG"] = 02.22,
						["Woundcrit02.OGG"] = 02.20,
						["Woundcrit03.OGG"] = 02.47,
						["Woundcrit04.OGG"] = 02.56,
						["Woundcrit05.OGG"] = 02.75,
					},
				},
				["Goldrinn\\VO_"] = {
					["QE_HJ_"] = {
						["Goldrinn_"] = {
							["Aid01.ogg"] = 02.35,
							["Aid02.ogg"] = 03.39,
							["Attack01.ogg"] = 00.66,
							["Attack02.ogg"] = 00.63,
							["Attack03.ogg"] = 01.06,
							["Attack04.ogg"] = 00.99,
							["Attack05.ogg"] = 01.26,
							["Attack06.ogg"] = 01.01,
							["Attack07.ogg"] = 00.96,
							["Attack08.ogg"] = 00.99,
							["Attack09.ogg"] = 01.01,
							["Attack10.ogg"] = 00.99,
							["AttackCrit01.ogg"] = 01.47,
							["AttackCrit02.ogg"] = 01.45,
							["Death01.ogg"] = 01.33,
							["Death02.ogg"] = 01.48,
							["Death03.ogg"] = 01.39,
							["Death04.ogg"] = 01.34,
							["Death05.ogg"] = 01.39,
							["HYEvent01.ogg"] = 03.12,
							["HYEvent02.ogg"] = 02.78,
							["HYEvent03.ogg"] = 01.94,
							["HYEvent04.ogg"] = 04.38,
							["HYEvent05.ogg"] = 05.56,
							["HYEvent06.ogg"] = 02.37,
							["Wound01.ogg"] = 01.00,
							["Wound02.ogg"] = 01.10,
							["Wound03.ogg"] = 00.97,
							["Wound04.ogg"] = 01.08,
							["Wound05.ogg"] = 01.14,
							["Wound06.ogg"] = 01.18,
							["Wound07.ogg"] = 01.10,
							["Wound08.ogg"] = 01.10,
							["Wound09.ogg"] = 01.18,
							["Wound10.ogg"] = 01.23,
							["WoundCrit01.ogg"] = 01.19,
							["WoundCrit02.ogg"] = 01.23,
							["WoundCrit03.ogg"] = 01.36,
							["WoundCrit04.ogg"] = 01.57,
							["WoundCrit05.ogg"] = 01.46,
						},
					},
				},
				["GolemIron\\GolemCanonIron_"] = {
					["Attack_"] = {
						["01.ogg"] = 01.50,
						["02.ogg"] = 01.50,
						["03.ogg"] = 01.50,
						["04.ogg"] = 01.70,
						["05.ogg"] = 01.59,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.18,
						["02.ogg"] = 01.48,
						["03.ogg"] = 01.56,
					},
					["Wound_"] = {
						["01.ogg"] = 01.00,
						["02.ogg"] = 01.00,
						["03.ogg"] = 01.00,
						["04.ogg"] = 01.00,
						["05.ogg"] = 01.00,
					},
					["Aggro_01.ogg"] = 03.10,
					["Death_01.ogg"] = 02.56,
				},
				["Golem_Stone\\GolemCannonStone_"] = {
					["Attack_"] = {
						["01.ogg"] = 01.80,
						["02.ogg"] = 01.84,
						["03.ogg"] = 01.67,
						["04.ogg"] = 01.51,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.05,
						["02.ogg"] = 01.42,
						["03.ogg"] = 01.47,
					},
					["Wound_"] = {
						["01.ogg"] = 01.16,
						["02.ogg"] = 01.13,
						["03.ogg"] = 01.45,
						["04.ogg"] = 01.61,
					},
					["Aggro_01.ogg"] = 02.96,
					["Death_01.ogg"] = 02.72,
				},
				["Gorashan\\VO_"] = {
					["60_"] = {
						["GORASHAN_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.90,
								["02.ogg"] = 01.97,
								["03.ogg"] = 02.05,
								["04.ogg"] = 02.24,
								["05.ogg"] = 02.41,
							},
							["Attack_"] = {
								["01.ogg"] = 00.59,
								["010.ogg"] = 00.71,
								["02.ogg"] = 00.74,
								["03.ogg"] = 00.73,
								["04.ogg"] = 00.64,
								["05.ogg"] = 00.64,
								["06.ogg"] = 00.68,
								["07.ogg"] = 00.64,
								["08.ogg"] = 00.67,
								["09.ogg"] = 00.72,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.21,
								["02.ogg"] = 01.76,
								["03.ogg"] = 01.32,
								["04.ogg"] = 01.70,
								["05.ogg"] = 01.72,
							},
							["Wound_"] = {
								["01.ogg"] = 00.58,
								["02.ogg"] = 00.56,
								["03.ogg"] = 00.60,
								["04.ogg"] = 00.84,
								["05.ogg"] = 00.51,
								["06.ogg"] = 00.69,
								["07.ogg"] = 00.79,
								["08.ogg"] = 00.77,
							},
						},
						["UBRS_GORASHAN_"] = {
							["SLAY_"] = {
								["01.ogg"] = 03.50,
								["02.ogg"] = 04.08,
							},
							["SPELL_"] = {
								["01.ogg"] = 05.75,
								["02.ogg"] = 03.95,
								["03.ogg"] = 05.06,
								["04.ogg"] = 03.05,
							},
							["DEATH_01.ogg"] = 05.26,
							["INTRO_01.ogg"] = 03.30,
						},
					},
				},
				["Gordawg\\VO_"] = {
					["60_"] = {
						["Gordawg_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.03,
								["02.ogg"] = 00.68,
								["03.ogg"] = 01.19,
								["04.ogg"] = 01.15,
								["05.ogg"] = 01.33,
							},
							["Attack_"] = {
								["01.ogg"] = 00.63,
								["010.ogg"] = 00.70,
								["02.ogg"] = 00.74,
								["03.ogg"] = 00.92,
								["04.ogg"] = 00.79,
								["05.ogg"] = 00.60,
								["06.ogg"] = 00.84,
								["07.ogg"] = 00.73,
								["08.ogg"] = 00.53,
								["09.ogg"] = 00.73,
							},
							["Death_"] = {
								["01.ogg"] = 04.71,
								["02.ogg"] = 02.24,
								["03.ogg"] = 02.97,
								["04.ogg"] = 03.32,
								["05.ogg"] = 02.75,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.29,
								["02.ogg"] = 01.65,
								["03.ogg"] = 01.71,
								["04.ogg"] = 02.27,
								["05.ogg"] = 01.59,
							},
							["Wound_"] = {
								["01.ogg"] = 00.56,
								["010.ogg"] = 00.55,
								["02.ogg"] = 00.52,
								["03.ogg"] = 00.44,
								["04.ogg"] = 00.44,
								["05.ogg"] = 00.50,
								["06.ogg"] = 00.60,
								["07.ogg"] = 00.45,
								["08.ogg"] = 00.54,
								["09.ogg"] = 00.63,
							},
						},
						["NGD_UNDERPALE_"] = {
							["GORDAWG_"] = {
								["01.ogg"] = 12.49,
								["02.ogg"] = 14.38,
							},
						},
					},
				},
				["GOREN\\MON_"] = {
					["GOREN_"] = {
						["EATING_BITS_"] = {
							["LOOP01.ogg"] = 06.00,
							["LOOP02.ogg"] = 06.00,
							["LOOP03.ogg"] = 06.00,
							["LOOP04.ogg"] = 06.00,
							["LOOP05.ogg"] = 07.00,
							["LOOP06.ogg"] = 07.00,
							["LOOP07.ogg"] = 06.00,
							["LOOP08.ogg"] = 06.00,
							["LOOP09.ogg"] = 06.00,
						},
						["STAND_"] = {
							["01.ogg"] = 03.58,
							["02.ogg"] = 03.22,
							["03.ogg"] = 03.39,
							["04.ogg"] = 03.65,
							["05.ogg"] = 04.29,
						},
						["AGGRO01.ogg"] = 01.35,
						["AGGRO02.ogg"] = 02.15,
						["AGGRO03.ogg"] = 01.48,
						["AGGRO04.ogg"] = 01.23,
						["AGGRO05.ogg"] = 00.89,
						["AGGRO06.ogg"] = 00.94,
						["AGGRO07.ogg"] = 00.91,
						["AGGRO08.ogg"] = 01.12,
						["AGGRO09.ogg"] = 01.96,
						["AGGRO10.ogg"] = 01.43,
						["ATTACK01.ogg"] = 01.24,
						["ATTACK02.ogg"] = 01.26,
						["ATTACK03.ogg"] = 01.15,
						["ATTACK04.ogg"] = 01.12,
						["ATTACK05.ogg"] = 01.11,
						["ATTACK06.ogg"] = 01.56,
						["ATTACK07.ogg"] = 00.92,
						["ATTACK08.ogg"] = 01.18,
						["ATTACK09.ogg"] = 01.03,
						["ATTACK10.ogg"] = 01.22,
						["ATTACKCRIT01.ogg"] = 00.96,
						["ATTACKCRIT02.ogg"] = 01.04,
						["ATTACKCRIT03.ogg"] = 01.05,
						["ATTACKCRIT04.ogg"] = 01.22,
						["ATTACKCRIT05.ogg"] = 01.22,
						["ATTACKCRIT06.ogg"] = 01.03,
						["ATTACKCRIT07.ogg"] = 01.38,
						["ATTACKCRIT08.ogg"] = 01.21,
						["ATTACKCRIT09.ogg"] = 01.14,
						["ATTACKCRIT10.ogg"] = 01.08,
						["DEATH01.ogg"] = 02.95,
						["DEATH02.ogg"] = 02.76,
						["DEATH03.ogg"] = 03.25,
						["DEATH04.ogg"] = 03.46,
						["DEATH05.ogg"] = 02.47,
						["DEATH06.ogg"] = 04.78,
						["DEATH07.ogg"] = 02.86,
						["DEATH08.ogg"] = 03.16,
						["DEATH09.ogg"] = 03.21,
						["DEATH10.ogg"] = 02.82,
						["GIBBERISH01.ogg"] = 01.59,
						["GIBBERISH02.ogg"] = 02.41,
						["GIBBERISH03.ogg"] = 03.29,
						["GIBBERISH04.ogg"] = 01.51,
						["GIBBERISH05.ogg"] = 01.51,
						["GIBBERISH06.ogg"] = 00.84,
						["GIBBERISH07.ogg"] = 02.09,
						["GIBBERISH08.ogg"] = 01.37,
						["GIBBERISH09.ogg"] = 02.37,
						["GIBBERISH10.ogg"] = 02.08,
						["PREAGGRO01.ogg"] = 00.84,
						["PREAGGRO02.ogg"] = 01.01,
						["PREAGGRO03.ogg"] = 01.00,
						["PREAGGRO04.ogg"] = 01.05,
						["PREAGGRO05.ogg"] = 01.26,
						["WOUND01.ogg"] = 00.57,
						["WOUND02.ogg"] = 00.63,
						["WOUND03.ogg"] = 00.72,
						["WOUND04.ogg"] = 00.67,
						["WOUND05.ogg"] = 00.69,
						["WOUND06.ogg"] = 00.57,
						["WOUND07.ogg"] = 00.85,
						["WOUND08.ogg"] = 00.84,
						["WOUND09.ogg"] = 00.75,
						["WOUND10.ogg"] = 00.77,
						["WOUNDCRIT01.ogg"] = 01.11,
						["WOUNDCRIT02.ogg"] = 00.84,
						["WOUNDCRIT03.ogg"] = 00.89,
						["WOUNDCRIT04.ogg"] = 00.65,
						["WOUNDCRIT05.ogg"] = 00.84,
						["WOUNDCRIT06.ogg"] = 00.86,
						["WOUNDCRIT07.ogg"] = 00.88,
						["WOUNDCRIT08.ogg"] = 01.01,
						["WOUNDCRIT09.ogg"] = 01.15,
						["WOUNDCRIT10.ogg"] = 01.22,
					},
				},
				["Gorilla\\"] = {
					["GorillaAggroA.ogg"] = 01.36,
					["GorillaAttackA.ogg"] = 00.42,
					["GorillaAttackB.ogg"] = 00.71,
					["GorillaAttackC.ogg"] = 00.72,
					["GorillaAttackD.ogg"] = 00.78,
					["GorillaDeathA.ogg"] = 04.47,
					["GorillaPreAggroA.ogg"] = 00.33,
					["GorillaStandVar3.ogg"] = 03.68,
					["GorillaWoundA.ogg"] = 00.69,
					["GorillaWoundB.ogg"] = 00.79,
					["GorillaWoundC.ogg"] = 00.55,
					["GorillaWoundCrit.ogg"] = 00.60,
				},
				["Gorrthog\\VO_"] = {
					["60_"] = {
						["FFR_BLADESPIRE_"] = {
							["GORRTHOG_"] = {
								["01.OGG"] = 02.62,
								["02.OGG"] = 06.10,
								["03.OGG"] = 04.11,
								["04.OGG"] = 04.86,
								["05.OGG"] = 04.02,
								["06.OGG"] = 05.68,
								["07.OGG"] = 02.93,
							},
						},
						["GORRTHOG_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.28,
								["02.OGG"] = 01.83,
								["03.OGG"] = 01.98,
								["04.OGG"] = 02.06,
								["05.OGG"] = 02.15,
							},
							["Attack_"] = {
								["01.OGG"] = 00.94,
								["010.OGG"] = 00.83,
								["02.OGG"] = 01.18,
								["03.OGG"] = 01.16,
								["04.OGG"] = 01.13,
								["05.OGG"] = 00.73,
								["06.OGG"] = 00.95,
								["07.OGG"] = 00.85,
								["08.OGG"] = 01.36,
								["09.OGG"] = 01.08,
							},
							["Death_"] = {
								["01.OGG"] = 02.43,
								["02.OGG"] = 03.28,
								["03.OGG"] = 04.08,
								["04.OGG"] = 02.22,
								["05.OGG"] = 02.72,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.82,
								["02.OGG"] = 01.22,
								["03.OGG"] = 01.61,
								["04.OGG"] = 00.75,
								["05.OGG"] = 01.32,
							},
							["Wound_"] = {
								["01.OGG"] = 00.70,
								["02.OGG"] = 00.74,
								["03.OGG"] = 00.43,
								["04.OGG"] = 00.58,
								["05.OGG"] = 00.55,
								["06.OGG"] = 00.67,
								["07.OGG"] = 00.82,
								["08.OGG"] = 01.28,
								["09.OGG"] = 00.53,
							},
						},
					},
				},
				["Gorsik\\VO_"] = {
					["QE_Gorsik_"] = {
						["Attack01.ogg"] = 01.75,
						["Attack02.ogg"] = 01.74,
						["Attack03.ogg"] = 01.55,
						["Attack04.ogg"] = 01.78,
						["Attack05.ogg"] = 01.63,
						["Attack06.ogg"] = 01.71,
						["Attack07.ogg"] = 01.82,
						["Attack08.ogg"] = 01.65,
						["Attack09.ogg"] = 01.70,
						["Attack10.ogg"] = 02.02,
						["AttackCritical01.ogg"] = 01.90,
						["AttackCritical02.ogg"] = 02.22,
						["AttackCritical03.ogg"] = 02.07,
						["AttackCritical04.ogg"] = 02.01,
						["AttackCritical05.ogg"] = 02.01,
						["Event01.ogg"] = 05.38,
						["Event02.ogg"] = 02.62,
						["Event03.ogg"] = 04.34,
						["Event04.ogg"] = 11.72,
						["Event05.ogg"] = 07.99,
						["ThroneDisc01.ogg"] = 11.80,
						["ThroneDisc02.ogg"] = 06.88,
						["Wound01.ogg"] = 01.29,
						["Wound02.ogg"] = 01.28,
						["Wound03.ogg"] = 01.40,
						["Wound04.ogg"] = 01.50,
						["Wound05.ogg"] = 01.39,
						["Wound06.ogg"] = 01.42,
						["Wound07.ogg"] = 01.48,
						["Wound08.ogg"] = 01.39,
						["Wound09.ogg"] = 01.65,
						["Wound10.ogg"] = 01.93,
						["WoundCritical01.ogg"] = 02.48,
						["WoundCritical02.ogg"] = 02.11,
						["WoundCritical03.ogg"] = 02.27,
						["WoundCritical04.ogg"] = 02.10,
						["WoundCritical05.ogg"] = 02.04,
					},
				},
				["GortokPalehoof\\UP_"] = {
					["Gortok_"] = {
						["Aggro.ogg"] = 06.71,
						["Attack01.ogg"] = 01.81,
						["Attack02.ogg"] = 01.64,
						["Attack03.ogg"] = 00.81,
						["Attack04.ogg"] = 01.07,
						["Death.ogg"] = 02.80,
						["Slay01.ogg"] = 05.09,
						["Slay02.ogg"] = 02.37,
						["Wound01.ogg"] = 00.86,
						["Wound02.ogg"] = 00.90,
						["Wound03.ogg"] = 01.13,
						["Wound04.ogg"] = 01.21,
						["WoundCrit01.ogg"] = 01.22,
						["WoundCrit02.ogg"] = 01.56,
						["WoundCrit03.ogg"] = 01.36,
						["WoundCrit04.ogg"] = 01.13,
					},
				},
				["Gothik\\GOT_"] = {
					["NAXX_"] = {
						["DEATH.ogg"] = 07.69,
						["SLAY.ogg"] = 03.02,
						["SPCH.ogg"] = 24.43,
						["TLPRT.ogg"] = 06.87,
					},
				},
				["GrandAdmiralWestwind\\"] = {
					["SO_West_"] = {
						["Attack01.ogg"] = 00.54,
						["Attack02.ogg"] = 00.42,
						["Attack03.ogg"] = 00.28,
						["Attack04.ogg"] = 00.50,
						["Attack05.ogg"] = 00.48,
						["Attack06.ogg"] = 00.87,
						["Attack07.ogg"] = 00.52,
						["Attack08.ogg"] = 00.43,
						["Death01.ogg"] = 01.81,
						["Wound01.ogg"] = 00.55,
						["Wound02.ogg"] = 00.44,
						["Wound03.ogg"] = 00.57,
						["Wound04.ogg"] = 00.80,
						["Wound05.ogg"] = 00.41,
						["WoundCrit01.ogg"] = 00.71,
						["WoundCrit02.ogg"] = 00.57,
						["WoundCrit03.ogg"] = 00.89,
						["WoundCrit04.ogg"] = 00.87,
						["WoundCrit05.ogg"] = 01.03,
						["WoundCrit06.ogg"] = 00.85,
					},
					["WESTWIND50HEALTH.ogg"] = 02.96,
					["WESTWINDABBENDIS01.ogg"] = 02.61,
					["WESTWINDABBENDIS02 .ogg"] = 01.77,
					["WESTWINDABBENDIS03.ogg"] = 04.88,
					["WESTWINDAGGRO.ogg"] = 02.91,
					["WESTWINDSLAY01.ogg"] = 04.27,
					["WESTWINDSLAY02.ogg"] = 01.78,
					["WESTWINDSLAY03.ogg"] = 01.81,
					["WESTWINDSLAY04.ogg"] = 03.18,
					["WESTWINDSPHEREDROP.ogg"] = 09.76,
				},
				["GrandAstromancerCapernian\\TEMPEST_"] = {
					["GrandAstro_"] = {
						["Aggro01.ogg"] = 04.20,
						["Attack01.ogg"] = 01.56,
						["Attack02.ogg"] = 01.75,
						["Attack03.ogg"] = 01.48,
						["Attack04.ogg"] = 01.93,
						["Attack05.ogg"] = 01.86,
						["Attack06.ogg"] = 01.95,
						["Attack07.ogg"] = 01.91,
						["Slay01.ogg"] = 05.04,
						["Wound01.ogg"] = 01.80,
						["Wound02.ogg"] = 01.77,
						["Wound03.ogg"] = 01.54,
						["Wound04.ogg"] = 01.52,
						["Wound05.ogg"] = 01.56,
						["Wound06.ogg"] = 01.82,
						["WoundCrit01.ogg"] = 01.61,
						["WoundCrit02.ogg"] = 01.75,
						["WoundCrit03.ogg"] = 01.99,
						["WoundCrit04.ogg"] = 01.80,
						["WoundCrit05.ogg"] = 01.93,
					},
				},
				["GrandElder\\VO_"] = {
					["Jade_Forest_"] = {
						["Waterspeaking_Ceremony_"] = {
							["Grandelder_"] = {
								["01.OGG"] = 06.15,
								["02.OGG"] = 05.33,
								["03.OGG"] = 08.73,
								["04.OGG"] = 07.89,
							},
						},
					},
				},
				["GrandMagusTelestra\\"] = {
					["TN_Tele_"] = {
						["Attack01.ogg"] = 00.77,
						["Attack02.ogg"] = 00.52,
						["Attack03.ogg"] = 00.78,
						["Attack04.ogg"] = 00.56,
						["Attack05.ogg"] = 00.77,
						["Attack06.ogg"] = 00.79,
						["Wound01.ogg"] = 00.55,
						["Wound02.ogg"] = 00.45,
						["Wound03.ogg"] = 00.46,
						["Wound04.ogg"] = 00.67,
						["Wound05.ogg"] = 00.58,
						["WoundCrit01.ogg"] = 01.08,
						["WoundCrit02.ogg"] = 01.13,
						["WoundCrit03.ogg"] = 00.76,
					},
					["TelestraAggro.ogg"] = 02.71,
					["TelestraDeath.ogg"] = 02.03,
					["TelestraKill.ogg"] = 01.49,
					["TelestraMerge.ogg"] = 02.08,
					["TelestraSplit01.ogg"] = 02.57,
					["TelestraSplit02.ogg"] = 02.78,
				},
				["GrandmasterVorpil\\Auch_"] = {
					["Vorpil_"] = {
						["Aggro01.ogg"] = 02.86,
						["Aggro02.ogg"] = 04.04,
						["Aggro03.ogg"] = 04.21,
						["Death01.ogg"] = 04.92,
						["Help01.ogg"] = 04.40,
						["Intro01.ogg"] = 19.95,
						["Slay01.ogg"] = 03.07,
						["Slay02.ogg"] = 03.46,
					},
				},
				["GrandWarlockAlythess\\"] = {
					["SP_Alyt_"] = {
						["Attack01.ogg"] = 00.53,
						["Attack02.ogg"] = 00.68,
						["Attack03.ogg"] = 00.59,
						["Attack04.ogg"] = 00.59,
						["Wound01.ogg"] = 00.66,
						["Wound02.ogg"] = 00.75,
						["Wound03.ogg"] = 00.49,
						["Wound04.ogg"] = 00.63,
						["WoundCrit01.ogg"] = 00.78,
					},
					["ALLYTHESSCONFLAG.ogg"] = 03.31,
					["ALYTHESSBERSERK.ogg"] = 02.46,
					["ALYTHESSCOMBINE.ogg"] = 02.23,
					["ALYTHESSDEATH.ogg"] = 04.86,
					["ALYTHESSKILL01.ogg"] = 02.68,
					["ALYTHESSKILL02.ogg"] = 02.06,
				},
				["GreaterSlime\\GreaterSlime_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.78,
						["02.ogg"] = 02.31,
						["03.ogg"] = 02.17,
						["04.ogg"] = 01.92,
						["05.ogg"] = 01.53,
						["06.ogg"] = 02.17,
						["07.ogg"] = 01.76,
						["08.ogg"] = 01.82,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 01.07,
						["02.ogg"] = 00.93,
						["03.ogg"] = 01.07,
						["04.ogg"] = 00.97,
						["05.ogg"] = 01.07,
						["06.ogg"] = 01.07,
						["07.ogg"] = 01.07,
						["08.ogg"] = 01.07,
					},
					["Attack_"] = {
						["01.ogg"] = 01.02,
						["02.ogg"] = 01.13,
						["03.ogg"] = 01.13,
						["04.ogg"] = 01.13,
						["05.ogg"] = 01.13,
						["06.ogg"] = 01.13,
						["07.ogg"] = 01.13,
						["08.ogg"] = 01.13,
						["09.ogg"] = 01.13,
					},
					["Death_"] = {
						["01.ogg"] = 06.52,
						["02.ogg"] = 06.36,
						["03.ogg"] = 07.37,
						["04.ogg"] = 07.37,
						["05.ogg"] = 07.37,
						["06.ogg"] = 07.37,
						["07.ogg"] = 07.37,
						["08.ogg"] = 07.37,
						["09.ogg"] = 06.76,
						["10.ogg"] = 06.54,
					},
					["Loop_"] = {
						["01.ogg"] = 08.01,
						["02.ogg"] = 07.90,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.29,
						["02.ogg"] = 01.23,
						["03.ogg"] = 01.04,
						["04.ogg"] = 01.21,
						["05.ogg"] = 01.06,
						["06.ogg"] = 01.05,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.00,
						["02.ogg"] = 01.01,
						["03.ogg"] = 00.97,
						["04.ogg"] = 00.98,
						["05.ogg"] = 00.98,
						["06.ogg"] = 01.03,
						["07.ogg"] = 00.99,
						["08.ogg"] = 01.03,
						["09.ogg"] = 00.93,
						["10.ogg"] = 01.03,
					},
					["Wound_"] = {
						["01.ogg"] = 00.93,
						["02.ogg"] = 00.98,
						["03.ogg"] = 01.03,
						["04.ogg"] = 01.03,
						["05.ogg"] = 00.96,
						["06.ogg"] = 01.03,
						["07.ogg"] = 00.98,
						["08.ogg"] = 01.03,
						["09.ogg"] = 00.99,
						["10.ogg"] = 01.03,
					},
				},
				["Grell\\"] = {
					["GrellAggroA.ogg"] = 01.93,
					["GrellAttackA.ogg"] = 01.59,
					["GrellAttackB.ogg"] = 01.30,
					["GrellAttackC.ogg"] = 00.92,
					["GrellDeathA.ogg"] = 01.75,
					["GrellWoundA.ogg"] = 00.60,
					["GrellWoundB.ogg"] = 01.14,
					["GrellWoundC.ogg"] = 01.19,
					["GrellWoundCrit.ogg"] = 01.08,
				},
				["Grethok\\"] = {
					["GrethokAggro.ogg"] = 06.84,
					["GrethokMindControl.ogg"] = 04.27,
					["GrethokRegainedControl.ogg"] = 05.76,
				},
				["Greymane\\VO_"] = {
					["GENN_GREYMANE_"] = {
						["WICKERMAN_EVENT_"] = {
							["01.ogg"] = 08.17,
							["02.ogg"] = 06.76,
							["03.ogg"] = 06.11,
							["04.ogg"] = 06.44,
							["05.ogg"] = 05.48,
							["06.ogg"] = 08.16,
							["07.ogg"] = 06.76,
							["08.ogg"] = 06.32,
							["09.ogg"] = 06.41,
							["10.ogg"] = 04.97,
							["11.ogg"] = 08.39,
							["12.ogg"] = 01.18,
							["13.ogg"] = 04.95,
						},
					},
					["Greymane_"] = {
						["Aggro01.ogg"] = 02.61,
						["Aggro02.ogg"] = 02.70,
						["Barricade01.ogg"] = 03.31,
						["Barricade02.ogg"] = 01.32,
						["Barricade03.ogg"] = 01.43,
						["Death01.ogg"] = 05.02,
						["Funeral01.ogg"] = 07.73,
						["Funeral02.ogg"] = 07.25,
						["Funeral03.ogg"] = 03.88,
						["Greeting01.ogg"] = 01.43,
						["Greeting01Worgen.ogg"] = 01.43,
						["Greeting02.ogg"] = 02.50,
						["Greeting02Worgen.ogg"] = 02.50,
						["Greeting03.ogg"] = 05.92,
						["Greeting03Worgen.ogg"] = 05.92,
						["Greeting04.ogg"] = 05.38,
						["Greeting04Worgen.ogg"] = 05.38,
						["Greeting05.ogg"] = 01.88,
						["Greeting05Worgen.ogg"] = 01.88,
						["Kill01.ogg"] = 01.96,
						["Kill02.ogg"] = 02.33,
						["Sacrifices01.ogg"] = 07.40,
						["Sacrifices02.ogg"] = 06.13,
						["Stocks01.ogg"] = 08.30,
						["Stocks02.ogg"] = 06.73,
						["Taldoren01.ogg"] = 04.28,
						["Taldoren02.ogg"] = 07.17,
						["War01.ogg"] = 04.04,
						["War02.ogg"] = 02.44,
						["War03.ogg"] = 02.47,
					},
				},
				["GRILEK\\VO_"] = {
					["ZG2_GRILEK_"] = {
						["FIXATE_"] = {
							["01.ogg"] = 03.29,
							["02.ogg"] = 04.60,
						},
						["KILL_"] = {
							["01.ogg"] = 01.54,
							["02.ogg"] = 01.80,
						},
						["ROAR_"] = {
							["01.ogg"] = 03.35,
							["02.ogg"] = 02.71,
						},
						["ROOT_"] = {
							["01.ogg"] = 04.40,
							["02.ogg"] = 05.87,
						},
						["AGGRO.ogg"] = 04.51,
						["ATTACK01.ogg"] = 00.92,
						["ATTACK02.ogg"] = 01.49,
						["ATTACK03.ogg"] = 01.83,
						["ATTACK04.ogg"] = 01.65,
						["ATTACK05.ogg"] = 01.84,
						["ATTACKCRIT01.ogg"] = 03.26,
						["ATTACKCRIT02.ogg"] = 01.91,
						["ATTACKCRIT03.ogg"] = 01.84,
						["ATTACKCRIT04.ogg"] = 02.10,
						["ATTACKCRIT05.ogg"] = 02.41,
						["DEATH.ogg"] = 05.15,
						["WOUND01.ogg"] = 01.61,
						["WOUND02.ogg"] = 01.14,
						["WOUND03.ogg"] = 01.15,
						["WOUND04.ogg"] = 01.51,
						["WOUND05.ogg"] = 01.40,
						["WOUNDCRIT01.ogg"] = 01.61,
						["WOUNDCRIT02.ogg"] = 01.80,
						["WOUNDCRIT03.ogg"] = 02.19,
						["WOUNDCRIT04.ogg"] = 01.40,
						["WOUNDCRIT05.ogg"] = 01.79,
						["LAUGH_01.ogg"] = 03.80,
					},
				},
				["Grimbolt\\VO_"] = {
					["53_Grimbolt_"] = {
						["Scenario_"] = {
							["01.OGG"] = 08.38,
							["02.OGG"] = 11.19,
						},
					},
				},
				["Grimlock\\"] = {
					["GrimlockAggro01.ogg"] = 02.26,
					["GrimlockSlay01.ogg"] = 02.28,
				},
				["GrizzleGearslip\\VO_"] = {
					["5.1_"] = {
						["HPROG_Grizzle_"] = {
							["GrizzleResc_"] = {
								["01.OGG"] = 04.36,
								["02.OGG"] = 08.23,
							},
						},
						["VOL_Grizzle_"] = {
							["Boss1_"] = {
								["01.OGG"] = 03.98,
								["02.OGG"] = 05.35,
								["03.OGG"] = 01.87,
								["04.OGG"] = 01.84,
								["05.OGG"] = 03.22,
								["06.OGG"] = 05.70,
							},
							["Greet_"] = {
								["01.OGG"] = 01.27,
								["02.OGG"] = 01.04,
								["03.OGG"] = 01.58,
							},
							["Open_01.OGG"] = 03.10,
						},
					},
					["53_GEARSLIP_"] = {
						["AttackCrit_"] = {
							["1.OGG"] = 01.38,
							["2.OGG"] = 01.63,
							["3.OGG"] = 01.82,
							["4.OGG"] = 01.26,
							["5.OGG"] = 01.24,
						},
						["Attack_"] = {
							["1.OGG"] = 00.31,
							["2.OGG"] = 00.42,
							["3.OGG"] = 00.55,
							["4.OGG"] = 00.60,
							["5.OGG"] = 00.55,
							["6.OGG"] = 00.37,
							["7.OGG"] = 00.48,
							["8.OGG"] = 00.91,
						},
						["Death_"] = {
							["1.OGG"] = 01.82,
							["2.OGG"] = 01.97,
							["3.OGG"] = 02.14,
							["4.OGG"] = 02.20,
							["5.OGG"] = 01.38,
						},
						["Scenario_"] = {
							["Artifact_"] = {
								["01.OGG"] = 01.28,
								["02.OGG"] = 01.74,
								["03.OGG"] = 02.66,
								["04.OGG"] = 02.49,
							},
							["Finale_"] = {
								["01.OGG"] = 03.65,
								["02.OGG"] = 07.68,
								["03.OGG"] = 05.04,
								["04.OGG"] = 06.14,
								["05.OGG"] = 03.62,
								["06.OGG"] = 07.79,
							},
							["Start_"] = {
								["01.OGG"] = 02.84,
								["02.OGG"] = 07.94,
								["03.OGG"] = 02.69,
							},
						},
						["WoundCrit_"] = {
							["1.OGG"] = 01.49,
							["2.OGG"] = 01.22,
							["3.OGG"] = 01.26,
							["4.OGG"] = 01.59,
							["5.OGG"] = 01.24,
						},
						["Wound_"] = {
							["1.OGG"] = 00.47,
							["2.OGG"] = 00.37,
							["3.OGG"] = 00.44,
							["4.OGG"] = 00.51,
							["5.OGG"] = 00.41,
						},
					},
					["54_OR_"] = {
						["GRIZZLE_INTRO_"] = {
							["1.OGG"] = 04.29,
							["2.OGG"] = 04.49,
							["3.OGG"] = 05.55,
							["4.OGG"] = 06.24,
						},
					},
				},
				["Grokglok\\VO_"] = {
					["60_"] = {
						["Groklok_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.88,
								["02.ogg"] = 02.20,
								["03.ogg"] = 02.23,
								["04.ogg"] = 01.52,
								["05.ogg"] = 01.29,
							},
							["Attack_"] = {
								["01.ogg"] = 00.62,
								["010.ogg"] = 00.57,
								["02.ogg"] = 00.59,
								["03.ogg"] = 00.57,
								["04.ogg"] = 00.67,
								["05.ogg"] = 00.68,
								["06.ogg"] = 00.71,
								["07.ogg"] = 00.50,
								["08.ogg"] = 00.49,
								["09.ogg"] = 00.58,
							},
							["Death_"] = {
								["01.ogg"] = 03.24,
								["02.ogg"] = 02.43,
								["03.ogg"] = 01.58,
								["04.ogg"] = 02.89,
								["05.ogg"] = 02.34,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 02.50,
								["02.ogg"] = 01.98,
								["03.ogg"] = 02.72,
								["04.ogg"] = 01.74,
								["05.ogg"] = 02.03,
							},
							["Wound_"] = {
								["01.ogg"] = 00.61,
								["02.ogg"] = 00.80,
								["03.ogg"] = 00.60,
								["04.ogg"] = 00.57,
								["05.ogg"] = 00.56,
								["06.ogg"] = 00.63,
								["07.ogg"] = 00.81,
								["08.ogg"] = 00.68,
								["09.ogg"] = 00.61,
							},
						},
						["NGD_WARSONG_"] = {
							["ALLY_GROKGLOK_"] = {
								["02.ogg"] = 02.85,
								["03.ogg"] = 01.63,
								["04.ogg"] = 02.24,
								["05.ogg"] = 02.36,
								["06.ogg"] = 03.89,
							},
							["HORDE_GROKGLOK_"] = {
								["01.ogg"] = 02.85,
								["02.ogg"] = 02.25,
								["03.ogg"] = 01.63,
								["04.ogg"] = 02.36,
								["05.ogg"] = 03.88,
							},
						},
					},
				},
				["Grommash\\VO_"] = {
					["60_"] = {
						["LQ_GROMMASH_"] = {
							["RING_"] = {
								["01.ogg"] = 04.53,
								["02.ogg"] = 01.12,
							},
						},
						["SMV_"] = {
							["GROMMAR_GROMMASH_"] = {
								["01.ogg"] = 05.87,
								["02.ogg"] = 08.42,
								["04.ogg"] = 10.30,
							},
							["NERZHULCHOICE_GROM_01.ogg"] = 09.36,
							["OVERLOOK_GROMMASH_01.ogg"] = 07.40,
						},
						["TAN_"] = {
							["FINALE_GROMMASH_"] = {
								["01.ogg"] = 04.92,
								["02.ogg"] = 11.98,
								["03.ogg"] = 10.57,
							},
							["GROMMASH_"] = {
								["RUN_01.ogg"] = 07.71,
								["SHADOW_01.ogg"] = 05.20,
							},
						},
						["WARLORDS_GROMMASH_"] = {
							["01.ogg"] = 02.10,
							["02.ogg"] = 04.42,
							["03.ogg"] = 03.16,
							["04.ogg"] = 09.25,
							["05.ogg"] = 07.95,
							["06.ogg"] = 07.65,
							["07.ogg"] = 05.21,
							["08.ogg"] = 03.64,
						},
						["HMR_GROMMASH_01.ogg"] = 06.15,
					},
				},
				["Grondel\\IC_"] = {
					["Captain Grondel_"] = {
						["Attack01.ogg"] = 01.97,
						["Attack02.ogg"] = 02.36,
						["Attack03.ogg"] = 00.97,
						["Attack04.ogg"] = 00.68,
						["Attack05.ogg"] = 00.79,
						["Attack06.ogg"] = 00.90,
						["Attack07.ogg"] = 00.97,
						["Attack08.ogg"] = 01.29,
						["Attack09.ogg"] = 01.44,
						["Event01.ogg"] = 09.24,
						["Event02.ogg"] = 09.24,
						["Event03.ogg"] = 03.02,
						["Event04.ogg"] = 03.93,
						["Survived01.ogg"] = 05.99,
						["Teleport01.ogg"] = 05.57,
						["Wound01.ogg"] = 00.88,
						["Wound02.ogg"] = 01.02,
						["Wound03.ogg"] = 01.08,
						["Wound04.ogg"] = 00.81,
						["Wound05.ogg"] = 00.92,
						["Wound06.ogg"] = 01.23,
						["Wound07.ogg"] = 00.71,
						["Wound08.ogg"] = 00.72,
						["WoundCrit01.ogg"] = 00.65,
						["WoundCrit02.ogg"] = 00.62,
						["WoundCrit03.ogg"] = 01.11,
					},
				},
				["Gronn\\"] = {
					["MON_GRONN_"] = {
						["AGGRO_"] = {
							["01.OGG"] = 02.42,
							["02.OGG"] = 02.66,
							["03.OGG"] = 02.19,
							["04.OGG"] = 02.35,
							["05.OGG"] = 02.62,
							["06.OGG"] = 02.62,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 02.16,
							["02.OGG"] = 02.35,
							["03.OGG"] = 02.55,
						},
						["ATTACK_"] = {
							["01.OGG"] = 02.44,
							["02.OGG"] = 02.07,
							["03.OGG"] = 01.97,
							["04.OGG"] = 02.10,
							["05.OGG"] = 02.28,
							["06.OGG"] = 02.22,
							["07.OGG"] = 01.78,
							["08.OGG"] = 01.82,
							["09.OGG"] = 02.31,
							["10.OGG"] = 01.71,
						},
						["BATTLEROAR_"] = {
							["01.OGG"] = 02.78,
							["02.OGG"] = 02.62,
							["03.OGG"] = 02.78,
							["04.OGG"] = 02.77,
							["05.OGG"] = 02.73,
							["06.OGG"] = 02.78,
						},
						["Custom04_Attack_"] = {
							["01.ogg"] = 04.05,
							["02.ogg"] = 03.65,
							["03.ogg"] = 04.48,
							["04.ogg"] = 03.84,
							["05.ogg"] = 04.15,
						},
						["DEATH_"] = {
							["01.OGG"] = 02.70,
							["02.OGG"] = 02.70,
							["03.OGG"] = 02.92,
							["04.OGG"] = 03.25,
							["05.OGG"] = 02.89,
							["06.OGG"] = 02.55,
							["07.OGG"] = 02.03,
							["08.OGG"] = 02.41,
							["09.OGG"] = 02.37,
							["10.OGG"] = 03.53,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.99,
							["02.OGG"] = 01.69,
							["03.OGG"] = 01.90,
							["04.OGG"] = 01.94,
						},
						["ROAR_GARRISON_"] = {
							["EXTENDED_"] = {
								["01.ogg"] = 04.68,
								["02.ogg"] = 04.91,
							},
						},
						["Stand_Idle_"] = {
							["01.OGG"] = 02.79,
							["02.OGG"] = 03.08,
							["03.OGG"] = 02.62,
							["04.OGG"] = 02.80,
							["05.OGG"] = 03.20,
							["06.OGG"] = 03.10,
							["07.OGG"] = 02.28,
							["08.OGG"] = 02.67,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.45,
							["02.OGG"] = 01.63,
							["03.OGG"] = 01.67,
							["04.OGG"] = 01.79,
						},
						["WOUND_"] = {
							["01.OGG"] = 01.08,
							["02.OGG"] = 01.07,
							["03.OGG"] = 01.04,
							["04.OGG"] = 01.00,
							["05.OGG"] = 01.31,
							["06.OGG"] = 01.25,
							["07.OGG"] = 01.54,
							["08.OGG"] = 01.43,
							["09.OGG"] = 01.45,
							["10.OGG"] = 01.31,
						},
					},
					["GronnAttackA.ogg"] = 01.93,
					["GronnAttackB.ogg"] = 01.83,
					["GronnAttackC.ogg"] = 02.01,
					["GronnAttackD.ogg"] = 02.27,
					["GronnAttackE.ogg"] = 02.12,
					["GronnDeath.ogg"] = 01.44,
					["GronnWoundA.ogg"] = 01.12,
					["GronnWoundB.ogg"] = 01.20,
					["GronnWoundC.ogg"] = 01.62,
					["GronnWoundCrit.ogg"] = 01.62,
					["GronnWoundD.ogg"] = 00.96,
				},
				["GronnlingPet\\MON_"] = {
					["GRONNLING_PET_"] = {
						["ATTACK_"] = {
							["01.ogg"] = 01.43,
							["02.ogg"] = 01.50,
							["03.ogg"] = 01.41,
							["04.ogg"] = 01.39,
						},
						["CLICKABLE_"] = {
							["01.ogg"] = 01.41,
							["02.ogg"] = 01.32,
							["03.ogg"] = 01.60,
							["04.ogg"] = 01.40,
							["05.ogg"] = 01.63,
							["06.ogg"] = 01.33,
							["07.ogg"] = 01.60,
							["08.ogg"] = 01.74,
							["09.ogg"] = 01.73,
							["10.ogg"] = 01.43,
						},
						["DEATH_"] = {
							["01.ogg"] = 01.89,
							["02.ogg"] = 02.49,
							["03.ogg"] = 02.29,
							["04.ogg"] = 01.73,
							["05.ogg"] = 01.80,
							["06.ogg"] = 01.88,
							["07.ogg"] = 01.63,
						},
						["WOUND_"] = {
							["01.ogg"] = 01.35,
							["02.ogg"] = 01.48,
							["03.ogg"] = 01.63,
							["04.ogg"] = 01.33,
							["05.ogg"] = 01.19,
							["06.ogg"] = 01.79,
							["07.ogg"] = 01.25,
							["08.ogg"] = 01.07,
						},
					},
				},
				["GronnSmall\\MON_"] = {
					["GRONN_Small_"] = {
						["MountSpecial_"] = {
							["01.ogg"] = 04.00,
							["02.ogg"] = 03.82,
							["03.ogg"] = 03.39,
						},
					},
				},
				["Grotan\\VO_"] = {
					["60_FFR_"] = {
						["PREWAVE_GROTAN_"] = {
							["01.OGG"] = 05.54,
							["03.OGG"] = 06.42,
							["04.OGG"] = 04.29,
							["05.OGG"] = 00.73,
						},
					},
				},
				["GroundFlower\\"] = {
					["GroundFlowerDeath.ogg"] = 04.08,
					["GroundFlowerLoop.ogg"] = 10.00,
				},
				["Grouper\\Grouper_"] = {
					["Aggro_"] = {
						["01.ogg"] = 02.99,
						["02.ogg"] = 02.99,
						["03.ogg"] = 03.02,
						["04.ogg"] = 02.95,
						["05.ogg"] = 03.02,
						["06.ogg"] = 03.23,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 03.00,
						["02.ogg"] = 02.64,
						["03.ogg"] = 02.17,
						["04.ogg"] = 02.84,
					},
					["Attack_"] = {
						["01.ogg"] = 01.97,
						["02.ogg"] = 02.16,
						["03.ogg"] = 02.62,
						["04.ogg"] = 02.13,
						["05.ogg"] = 02.22,
						["06.ogg"] = 02.06,
						["07.ogg"] = 02.56,
						["08.ogg"] = 02.64,
						["09.ogg"] = 02.17,
						["10.ogg"] = 02.84,
					},
					["Death_"] = {
						["01.ogg"] = 03.91,
						["02.ogg"] = 04.30,
						["03.ogg"] = 04.87,
						["04.ogg"] = 04.88,
						["05.ogg"] = 04.45,
					},
					["PreAggro_"] = {
						["01.ogg"] = 02.39,
						["02.ogg"] = 02.40,
						["03.ogg"] = 02.43,
						["04.ogg"] = 02.39,
						["05.ogg"] = 02.41,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 02.24,
						["02.ogg"] = 02.19,
						["03.ogg"] = 02.24,
						["04.ogg"] = 02.32,
						["05.ogg"] = 02.82,
						["06.ogg"] = 02.25,
					},
					["Wound_"] = {
						["01.ogg"] = 02.45,
						["02.ogg"] = 02.36,
						["03.ogg"] = 02.82,
						["04.ogg"] = 02.33,
						["05.ogg"] = 02.93,
						["06.ogg"] = 02.89,
						["07.ogg"] = 02.66,
						["08.ogg"] = 02.70,
						["09.ogg"] = 02.82,
						["10.ogg"] = 02.65,
					},
				},
				["Grummle\\MON_"] = {
					["Grummle_"] = {
						["Aggro_"] = {
							["01.OGG"] = 01.53,
							["02.OGG"] = 01.46,
							["03.OGG"] = 01.49,
							["04.OGG"] = 01.10,
							["05.OGG"] = 01.35,
							["06.OGG"] = 01.28,
							["07.OGG"] = 01.02,
							["08.OGG"] = 00.54,
							["09.OGG"] = 00.87,
							["10.OGG"] = 01.30,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 00.71,
							["02.OGG"] = 00.81,
							["03.OGG"] = 00.85,
							["04.OGG"] = 00.75,
							["05.OGG"] = 00.76,
						},
						["Attack_"] = {
							["01.OGG"] = 00.72,
							["02.OGG"] = 00.79,
							["03.OGG"] = 00.93,
							["04.OGG"] = 00.88,
							["05.OGG"] = 00.82,
							["06.OGG"] = 00.72,
							["07.OGG"] = 00.80,
							["08.OGG"] = 00.81,
							["09.OGG"] = 00.76,
							["10.OGG"] = 00.56,
						},
						["Death_"] = {
							["01.OGG"] = 04.01,
							["02.OGG"] = 03.68,
							["03.OGG"] = 03.84,
							["04.OGG"] = 03.95,
							["05.OGG"] = 03.85,
							["06.OGG"] = 05.04,
							["07.OGG"] = 03.82,
							["08.OGG"] = 04.41,
							["09.OGG"] = 04.24,
						},
						["Foley_"] = {
							["Run01.OGG"] = 00.58,
							["Run02.OGG"] = 00.45,
							["Run03.OGG"] = 00.42,
							["Run04.OGG"] = 00.67,
							["Run05.OGG"] = 00.67,
							["Run06.OGG"] = 00.67,
							["Run07.OGG"] = 00.55,
							["Run08.OGG"] = 00.51,
							["Run09.OGG"] = 00.47,
							["Run10.OGG"] = 00.36,
							["Walk01.OGG"] = 00.59,
							["Walk02.OGG"] = 00.71,
							["Walk03.OGG"] = 00.69,
							["Walk04.OGG"] = 00.53,
							["Walk05.OGG"] = 00.80,
							["Walk06.OGG"] = 00.80,
							["Walk07.OGG"] = 00.49,
							["Walk08.OGG"] = 00.75,
							["Walk09.OGG"] = 00.58,
							["Walk10.OGG"] = 00.80,
						},
						["PreAggro_"] = {
							["01.OGG"] = 00.53,
							["02.OGG"] = 00.37,
							["03.OGG"] = 00.51,
							["04.OGG"] = 00.41,
							["05.OGG"] = 00.49,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.88,
							["02.OGG"] = 00.84,
							["03.OGG"] = 00.76,
							["04.OGG"] = 00.90,
							["05.OGG"] = 00.72,
						},
						["Wound_"] = {
							["01.OGG"] = 00.38,
							["02.OGG"] = 00.37,
							["03.OGG"] = 00.48,
							["04.OGG"] = 00.37,
							["05.OGG"] = 00.32,
							["06.OGG"] = 00.32,
							["07.OGG"] = 00.42,
							["08.OGG"] = 00.48,
							["09.OGG"] = 00.38,
							["10.OGG"] = 00.49,
						},
					},
				},
				["GrummleKooky\\VO_"] = {
					["Grummle_Kooky_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.66,
							["02.OGG"] = 01.12,
							["03.OGG"] = 01.16,
							["04.OGG"] = 00.88,
							["05.OGG"] = 01.07,
						},
						["Attack_"] = {
							["01.OGG"] = 00.33,
							["02.OGG"] = 00.37,
							["03.OGG"] = 00.40,
							["04.OGG"] = 00.38,
							["05.OGG"] = 00.35,
							["06.OGG"] = 00.33,
							["07.OGG"] = 00.38,
							["08.OGG"] = 00.44,
							["09.OGG"] = 00.58,
							["10.OGG"] = 00.57,
						},
						["Death_"] = {
							["01.OGG"] = 04.11,
							["02.OGG"] = 04.49,
							["03.OGG"] = 04.00,
							["04.OGG"] = 03.74,
							["05.OGG"] = 04.47,
						},
						["Farewell_"] = {
							["01.OGG"] = 02.43,
							["02.OGG"] = 01.64,
							["03.OGG"] = 02.85,
							["04.OGG"] = 01.06,
						},
						["Greeting_"] = {
							["01.OGG"] = 00.99,
							["02.OGG"] = 01.29,
							["03.OGG"] = 01.93,
							["04.OGG"] = 01.68,
							["05.OGG"] = 02.30,
						},
						["Pissed_"] = {
							["01.OGG"] = 02.58,
							["02.OGG"] = 05.05,
						},
						["Vendor_"] = {
							["01.OGG"] = 02.63,
							["02.OGG"] = 03.89,
							["03.OGG"] = 02.66,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.92,
							["02.OGG"] = 00.61,
							["03.OGG"] = 00.67,
							["04.OGG"] = 00.65,
							["05.OGG"] = 00.74,
						},
						["Wound_"] = {
							["01.OGG"] = 00.45,
							["02.OGG"] = 00.44,
							["03.OGG"] = 00.47,
							["04.OGG"] = 00.51,
							["05.OGG"] = 00.56,
							["06.OGG"] = 00.72,
							["07.OGG"] = 00.53,
							["08.OGG"] = 00.49,
						},
					},
				},
				["GrummleSeedy\\VO_"] = {
					["Grummle_Seedy_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.71,
							["02.OGG"] = 00.65,
							["03.OGG"] = 00.66,
							["04.OGG"] = 00.56,
							["05.OGG"] = 00.69,
						},
						["Attack_"] = {
							["01.OGG"] = 00.30,
							["02.OGG"] = 00.41,
							["03.OGG"] = 00.41,
							["04.OGG"] = 00.31,
							["05.OGG"] = 00.32,
							["06.OGG"] = 00.31,
							["07.OGG"] = 00.56,
							["08.OGG"] = 00.59,
							["09.OGG"] = 00.67,
							["10.OGG"] = 00.37,
						},
						["Death_"] = {
							["01.OGG"] = 04.27,
							["02.OGG"] = 03.81,
							["03.OGG"] = 04.46,
							["04.OGG"] = 04.03,
							["05.OGG"] = 04.05,
						},
						["Farewell_"] = {
							["01.OGG"] = 03.97,
							["02.OGG"] = 05.17,
							["03.OGG"] = 05.48,
							["04.OGG"] = 03.75,
						},
						["Greeting_"] = {
							["01.OGG"] = 04.72,
							["02.OGG"] = 03.20,
							["03.OGG"] = 04.67,
							["04.OGG"] = 03.87,
						},
						["Pissed_"] = {
							["01.OGG"] = 04.52,
							["02.OGG"] = 05.14,
							["03.OGG"] = 06.26,
							["04.OGG"] = 07.76,
							["05.OGG"] = 07.42,
						},
						["Vendor_"] = {
							["01.OGG"] = 05.01,
							["02.OGG"] = 05.43,
							["03.OGG"] = 04.34,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.63,
							["02.OGG"] = 00.47,
							["03.OGG"] = 00.51,
							["04.OGG"] = 00.53,
							["05.OGG"] = 00.50,
						},
						["Wound_"] = {
							["01.OGG"] = 00.33,
							["02.OGG"] = 00.35,
							["03.OGG"] = 00.58,
							["04.OGG"] = 00.37,
							["05.OGG"] = 00.31,
							["06.OGG"] = 00.31,
							["07.OGG"] = 00.23,
							["08.OGG"] = 00.33,
							["09.OGG"] = 00.45,
							["10.OGG"] = 00.51,
						},
					},
				},
				["GrummleStandard\\VO_"] = {
					["Grummle_Standard_"] = {
						["Farewell_"] = {
							["01.OGG"] = 01.98,
							["02.OGG"] = 02.23,
							["03.OGG"] = 02.23,
							["04.OGG"] = 02.49,
						},
						["Greeting_"] = {
							["01.OGG"] = 02.11,
							["02.OGG"] = 01.59,
							["03.OGG"] = 03.54,
							["04.OGG"] = 02.89,
						},
						["Pissed_"] = {
							["01.OGG"] = 04.74,
							["02.OGG"] = 05.65,
							["03.OGG"] = 04.34,
						},
						["Vendor_"] = {
							["01.OGG"] = 03.09,
							["02.OGG"] = 03.17,
							["03.OGG"] = 04.74,
						},
					},
				},
				["Grunt\\"] = {
					["GruntUnitAttack1.ogg"] = 01.48,
					["GruntWarcry1.ogg"] = 01.59,
					["GruntYesAttack1.ogg"] = 01.25,
					["GruntYesAttack2.ogg"] = 00.97,
					["GruntYesAttack3.ogg"] = 01.68,
				},
				["Gruul\\VO_"] = {
					["60_"] = {
						["FR_GRUUL_"] = {
							["AGGRO.ogg"] = 10.84,
							["BERSERK.ogg"] = 04.19,
							["DEATH.ogg"] = 05.32,
							["INTRO.ogg"] = 10.01,
							["KILL01.ogg"] = 03.18,
							["KILL02.ogg"] = 02.40,
							["SPELL01.ogg"] = 07.33,
							["SPELL02.ogg"] = 02.83,
							["SPELL03.ogg"] = 05.39,
							["SPELL04.ogg"] = 03.86,
						},
						["GRUUL_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.09,
								["02.ogg"] = 00.79,
								["03.ogg"] = 01.29,
								["04.ogg"] = 01.24,
								["05.ogg"] = 01.43,
							},
							["Attack_"] = {
								["01.ogg"] = 00.71,
								["010.ogg"] = 00.89,
								["02.ogg"] = 00.80,
								["03.ogg"] = 00.96,
								["04.ogg"] = 00.87,
								["05.ogg"] = 00.70,
								["06.ogg"] = 00.93,
								["07.ogg"] = 00.80,
								["08.ogg"] = 00.63,
								["09.ogg"] = 00.79,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.39,
								["02.ogg"] = 01.77,
								["03.ogg"] = 01.82,
								["04.ogg"] = 02.38,
								["05.ogg"] = 01.71,
							},
							["Wound_"] = {
								["01.ogg"] = 00.65,
								["010.ogg"] = 00.61,
								["02.ogg"] = 00.62,
								["03.ogg"] = 00.52,
								["04.ogg"] = 00.52,
								["05.ogg"] = 00.59,
								["06.ogg"] = 00.69,
								["07.ogg"] = 00.56,
								["08.ogg"] = 00.63,
								["09.ogg"] = 00.73,
							},
						},
					},
				},
				["GruulTheDragonkiller\\GRULLAIR_"] = {
					["Gruul_"] = {
						["Aggro01.ogg"] = 04.75,
						["Attack01.ogg"] = 02.59,
						["Attack02.ogg"] = 02.63,
						["Attack03.ogg"] = 03.34,
						["Attack04.ogg"] = 03.27,
						["Death01.ogg"] = 05.09,
						["Ground01.ogg"] = 03.83,
						["Ground02.ogg"] = 04.47,
						["Petrify01.ogg"] = 03.52,
						["Petrify02.ogg"] = 04.75,
						["Slay01.ogg"] = 03.69,
						["Slay02.ogg"] = 03.09,
						["Slay03.ogg"] = 02.98,
						["Wound01.ogg"] = 02.30,
						["Wound02.ogg"] = 02.10,
						["Wound03.ogg"] = 02.58,
						["Wound04.ogg"] = 02.21,
						["WoundCrit01.ogg"] = 02.75,
						["WoundCrit02.ogg"] = 02.66,
						["WoundCrit03.ogg"] = 02.90,
						["WoundCrit04.ogg"] = 02.94,
						["WoundCrit05.ogg"] = 02.75,
					},
				},
				["Gryphon\\"] = {
					["GryphonAggroA.ogg"] = 01.52,
					["GryphonAttackA.ogg"] = 01.10,
					["GryphonAttackB.ogg"] = 00.81,
					["GryphonAttackC.ogg"] = 00.98,
					["GryphonDeathA.ogg"] = 01.75,
					["GryphonPreAggro.ogg"] = 00.63,
					["GryphonStand2.ogg"] = 01.38,
					["GryphonWoundA.ogg"] = 00.71,
					["GryphonWoundB.ogg"] = 01.22,
					["GryphonWoundC.ogg"] = 01.10,
					["GryphonWoundCritA.ogg"] = 00.88,
				},
				["GryphonPet\\GryphonPetClicable_"] = {
					["01.ogg"] = 00.86,
					["02.ogg"] = 00.76,
					["03.ogg"] = 00.85,
				},
				["Gryphon_Ghost\\Gryphon_"] = {
					["GhostAggro.ogg"] = 01.66,
					["GhostAttackA.ogg"] = 01.78,
					["GhostAttackB.ogg"] = 01.41,
					["GhostAttackC.ogg"] = 01.36,
					["GhostDeath.ogg"] = 02.16,
					["GhostPreAggro.ogg"] = 01.31,
					["GhostStand2.ogg"] = 02.08,
					["GhostWoundA.ogg"] = 01.44,
					["GhostWoundB.ogg"] = 01.41,
					["GhostWoundC.ogg"] = 01.45,
				},
				["Gryphon_Skeletal\\Gryphon_"] = {
					["SkeletalAggro.ogg"] = 01.47,
					["SkeletalAttackA.ogg"] = 00.98,
					["SkeletalAttackB.ogg"] = 01.10,
					["SkeletalAttackC.ogg"] = 00.86,
					["SkeletalDeath.ogg"] = 01.44,
					["SkeletalWoundA.ogg"] = 01.16,
					["SkeletalWoundB.ogg"] = 01.11,
					["SkeletalWoundC.ogg"] = 01.06,
					["SkeletalWoundCrit.ogg"] = 01.25,
				},
				["GSSArcher1\\VO_"] = {
					["GSS_ARCHER1_"] = {
						["EVENT_"] = {
							["01.OGG"] = 04.84,
							["02.OGG"] = 02.74,
							["03.OGG"] = 01.82,
						},
					},
				},
				["GSSArcher2\\VO_"] = {
					["GSS_ARCHER2_"] = {
						["EVENT_"] = {
							["01.OGG"] = 03.96,
							["02.OGG"] = 01.79,
							["03.OGG"] = 04.92,
						},
					},
				},
				["GuardianCub\\PET_"] = {
					["GuardianCub_"] = {
						["Clickable01.ogg"] = 01.81,
						["Clickable02.ogg"] = 01.64,
						["Clickable03.ogg"] = 01.69,
						["Clickable04.ogg"] = 02.06,
						["Clickable05.ogg"] = 01.22,
						["Clickable06.ogg"] = 02.45,
						["Clickable07.ogg"] = 01.29,
						["Clickable08.ogg"] = 01.70,
						["Clickable09.ogg"] = 01.99,
					},
				},
				["GuardianDemon\\VO_"] = {
					["WOE_GuardianDemon_"] = {
						["EVENT_"] = {
							["01.OGG"] = 02.66,
							["02.OGG"] = 02.43,
							["03.OGG"] = 03.73,
							["04.OGG"] = 03.06,
							["05.OGG"] = 03.53,
						},
					},
				},
				["GuCloudstrike\\VO_"] = {
					["GuCloudstrike_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.08,
							["02.OGG"] = 01.05,
							["03.OGG"] = 01.00,
							["04.OGG"] = 00.99,
							["05.OGG"] = 00.98,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.53,
							["02.OGG"] = 00.32,
							["03.OGG"] = 00.56,
							["04.OGG"] = 00.26,
							["05.OGG"] = 00.59,
							["06.OGG"] = 00.61,
							["07.OGG"] = 00.58,
							["08.OGG"] = 00.42,
							["09.OGG"] = 00.43,
							["10.OGG"] = 00.53,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.93,
							["02.OGG"] = 00.70,
							["03.OGG"] = 01.10,
							["04.OGG"] = 00.74,
							["05.OGG"] = 00.70,
						},
						["Wound_"] = {
							["01.OGG"] = 00.53,
							["02.OGG"] = 00.61,
							["03.OGG"] = 00.51,
							["04.OGG"] = 00.52,
							["05.OGG"] = 00.85,
							["06.OGG"] = 00.30,
							["07.OGG"] = 00.28,
							["08.OGG"] = 00.53,
							["09.OGG"] = 00.50,
							["10.OGG"] = 00.36,
						},
					},
					["SPM_GU_"] = {
						["DRAGONINJURED_"] = {
							["01.OGG"] = 02.12,
							["02.OGG"] = 02.93,
						},
						["INTRO_"] = {
							["01.OGG"] = 05.91,
							["02.OGG"] = 05.04,
						},
						["SLAY_"] = {
							["01.OGG"] = 01.13,
							["02.OGG"] = 03.26,
							["03.OGG"] = 03.59,
						},
						["AGGRO_01.OGG"] = 04.16,
						["CALLDRAGON_01.OGG"] = 07.09,
						["DEATH_01.OGG"] = 09.68,
						["RECHARGE_01.OGG"] = 03.34,
					},
				},
				["Gugrokk\\VO_"] = {
					["60_"] = {
						["6OM_GUGROKK_"] = {
							["AGGRO.OGG"] = 05.45,
							["BRIDGE.OGG"] = 05.19,
							["DEATH.OGG"] = 04.43,
							["INTRO.OGG"] = 03.14,
							["KILL01.OGG"] = 01.03,
							["KILL02.OGG"] = 02.08,
							["SPELL01.OGG"] = 01.58,
							["SPELL02.OGG"] = 03.02,
							["SPELL03.OGG"] = 03.15,
							["SPELL04.OGG"] = 04.47,
						},
						["GUGROKK_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 02.32,
								["02.OGG"] = 01.85,
								["03.OGG"] = 02.26,
								["04.OGG"] = 02.78,
								["05.OGG"] = 01.96,
							},
							["Attack_"] = {
								["01.OGG"] = 00.77,
								["010.OGG"] = 01.34,
								["02.OGG"] = 00.82,
								["03.OGG"] = 01.24,
								["04.OGG"] = 01.10,
								["05.OGG"] = 00.49,
								["06.OGG"] = 00.57,
								["07.OGG"] = 00.71,
								["08.OGG"] = 01.52,
								["09.OGG"] = 01.25,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.92,
								["02.OGG"] = 01.71,
								["03.OGG"] = 01.93,
								["04.OGG"] = 01.82,
								["05.OGG"] = 02.10,
							},
							["Wound_"] = {
								["01.OGG"] = 00.58,
								["010.OGG"] = 00.79,
								["02.OGG"] = 00.69,
								["03.OGG"] = 00.86,
								["04.OGG"] = 00.47,
								["05.OGG"] = 00.58,
								["06.OGG"] = 00.80,
								["07.OGG"] = 00.71,
								["08.OGG"] = 00.94,
								["09.OGG"] = 00.65,
							},
						},
					},
				},
				["Guldan\\VO_"] = {
					["60_"] = {
						["FR_GULDAN_"] = {
							["CAPTURE_"] = {
								["01.ogg"] = 05.06,
								["02.ogg"] = 06.05,
								["03.ogg"] = 05.95,
							},
							["REVEALED_"] = {
								["01.ogg"] = 06.16,
								["02.ogg"] = 11.36,
								["03.ogg"] = 03.76,
								["04.ogg"] = 04.33,
								["05.ogg"] = 09.39,
							},
						},
						["GULDAN_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.44,
								["02.ogg"] = 01.61,
								["03.ogg"] = 01.51,
								["04.ogg"] = 01.52,
								["05.ogg"] = 01.16,
							},
							["Attack_"] = {
								["01.ogg"] = 00.81,
								["010.ogg"] = 00.62,
								["02.ogg"] = 00.62,
								["03.ogg"] = 00.54,
								["04.ogg"] = 00.63,
								["05.ogg"] = 00.74,
								["06.ogg"] = 00.47,
								["07.ogg"] = 00.84,
								["08.ogg"] = 00.64,
								["09.ogg"] = 00.49,
							},
							["Death_"] = {
								["01.ogg"] = 03.07,
								["02.ogg"] = 02.34,
								["03.ogg"] = 02.85,
								["04.ogg"] = 03.50,
								["05.ogg"] = 02.50,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.25,
								["02.ogg"] = 01.32,
								["03.ogg"] = 01.20,
								["04.ogg"] = 01.11,
								["05.ogg"] = 01.36,
							},
							["Wound_"] = {
								["01.ogg"] = 00.80,
								["010.ogg"] = 00.62,
								["02.ogg"] = 00.61,
								["03.ogg"] = 00.76,
								["04.ogg"] = 00.65,
								["05.ogg"] = 00.63,
								["06.ogg"] = 00.60,
								["07.ogg"] = 01.09,
								["08.ogg"] = 00.66,
								["09.ogg"] = 00.72,
							},
						},
						["LQ_GULDAN_"] = {
							["GAME_"] = {
								["01.ogg"] = 05.50,
								["02.ogg"] = 07.65,
								["03.ogg"] = 08.37,
								["04.ogg"] = 18.19,
							},
							["RING_"] = {
								["01.ogg"] = 03.63,
								["02.ogg"] = 09.81,
							},
							["SCRYING_01.ogg"] = 04.37,
						},
						["NGD_RITUAL_"] = {
							["GULDAN_"] = {
								["01.ogg"] = 05.77,
								["02.ogg"] = 03.89,
								["03.ogg"] = 06.27,
								["04.ogg"] = 02.83,
							},
						},
						["SMV_GULDAN_"] = {
							["SHADOW_GULDAN_"] = {
								["01.ogg"] = 05.08,
								["02.ogg"] = 03.39,
								["03.ogg"] = 03.90,
								["04.ogg"] = 02.78,
								["05.ogg"] = 07.81,
								["06.ogg"] = 08.26,
							},
							["SPY_GULDAN_"] = {
								["01.ogg"] = 08.61,
								["02.ogg"] = 10.25,
								["03.ogg"] = 06.58,
								["04.ogg"] = 06.49,
								["05.ogg"] = 05.10,
								["06.ogg"] = 08.24,
								["07.ogg"] = 04.07,
								["08.ogg"] = 04.48,
							},
						},
						["TAN_PORTAL_"] = {
							["GULDAN_"] = {
								["01.ogg"] = 05.34,
								["02.ogg"] = 05.14,
								["03.ogg"] = 05.47,
								["04.ogg"] = 04.98,
								["05.ogg"] = 11.19,
								["06.ogg"] = 02.92,
							},
						},
						["TLD_XANDROS_"] = {
							["GULDAN_"] = {
								["01.ogg"] = 04.95,
								["02.ogg"] = 03.37,
								["03.ogg"] = 03.32,
								["04.ogg"] = 11.17,
								["05.ogg"] = 11.55,
							},
						},
					},
				},
				["GurtoggBloodboil\\BLCKTMPLE_"] = {
					["Gurtogg_"] = {
						["Aggro01.ogg"] = 05.06,
						["Death01.ogg"] = 05.61,
						["Enrage01.ogg"] = 05.15,
						["Enrage02.ogg"] = 07.33,
						["Slay01.ogg"] = 03.27,
						["Slay02.ogg"] = 05.76,
						["Special01.ogg"] = 07.14,
						["Special02.ogg"] = 03.30,
					},
				},
				["Gyrocopter\\"] = {
					["GyrocopterStandVar1_"] = {
						["A.ogg"] = 02.69,
						["B.ogg"] = 02.56,
						["Bnew.ogg"] = 04.70,
					},
					["GyrocopterFly.ogg"] = 05.00,
					["GyrocopterFlyIdle.ogg"] = 05.00,
					["GyrocopterFlyUp.ogg"] = 05.00,
					["GyrocopterGearShift1.ogg"] = 01.48,
					["GyrocopterGearShift2.ogg"] = 00.88,
					["GyrocopterGearShift3.ogg"] = 01.00,
					["GyrocopterJumpEnd.ogg"] = 03.04,
					["GyrocopterjumpStart.ogg"] = 02.22,
					["GyrocopterRun.ogg"] = 05.00,
					["GyrocopterShuffleLeftorRight1.ogg"] = 00.97,
					["GyrocopterShuffleLeftorRight2.ogg"] = 01.00,
					["GyrocopterShuffleLeftorRight3.ogg"] = 00.97,
					["GyrocopterStallInAir.ogg"] = 11.90,
					["GyrocopterStallinAirLong.ogg"] = 11.62,
					["GyrocopterStallOnGroundLong.ogg"] = 12.37,
					["GyrocopterStand.ogg"] = 05.00,
					["GyrocopterWalk.ogg"] = 05.00,
				},
				["HAGARA\\VO_"] = {
					["DS_HAGARA_"] = {
						["ADDS_"] = {
							["01.OGG"] = 06.75,
							["02.OGG"] = 05.93,
							["03.OGG"] = 04.10,
							["04.OGG"] = 05.62,
						},
						["CIRCUIT_"] = {
							["01.OGG"] = 01.71,
							["02.OGG"] = 01.89,
							["03.OGG"] = 02.92,
							["04.OGG"] = 02.94,
							["05.OGG"] = 02.72,
							["06.OGG"] = 04.95,
							["07.OGG"] = 02.63,
						},
						["CRYSTALDEAD_"] = {
							["01.OGG"] = 04.66,
							["02.OGG"] = 02.20,
							["03.OGG"] = 01.08,
							["04.OGG"] = 02.12,
							["05.OGG"] = 00.99,
							["06.OGG"] = 01.47,
							["07.OGG"] = 03.81,
						},
						["FROSTRAY_"] = {
							["01.OGG"] = 03.55,
							["02.OGG"] = 03.91,
							["03.OGG"] = 02.56,
						},
						["GLACIER_"] = {
							["01.OGG"] = 02.51,
							["02.OGG"] = 02.50,
						},
						["ICETOMB_"] = {
							["01.OGG"] = 01.53,
							["02.OGG"] = 01.38,
						},
						["LIGHTNING_"] = {
							["01.OGG"] = 02.76,
							["02.OGG"] = 03.76,
						},
						["SLAY_"] = {
							["01.OGG"] = 02.35,
							["02.OGG"] = 00.61,
							["03.OGG"] = 01.40,
							["04.OGG"] = 02.09,
						},
						["Attack01.OGG"] = 00.49,
						["Attack02.OGG"] = 00.59,
						["Attack03.OGG"] = 00.62,
						["Attack04.OGG"] = 00.56,
						["Attack05.OGG"] = 00.62,
						["Attack06.OGG"] = 00.83,
						["Attack07.OGG"] = 00.54,
						["Attack08.OGG"] = 00.73,
						["Attack09.OGG"] = 00.88,
						["Attack10.OGG"] = 00.90,
						["AttackCrit01.OGG"] = 01.10,
						["AttackCrit02.OGG"] = 01.09,
						["AttackCrit03.OGG"] = 00.90,
						["AttackCrit04.OGG"] = 01.39,
						["AttackCrit05.OGG"] = 01.23,
						["Wound01.OGG"] = 00.77,
						["Wound02.OGG"] = 00.84,
						["Wound03.OGG"] = 00.71,
						["Wound04.OGG"] = 00.80,
						["Wound05.OGG"] = 00.65,
						["Wound06.OGG"] = 00.70,
						["Wound07.OGG"] = 00.86,
						["Wound08.OGG"] = 00.43,
						["Wound09.OGG"] = 00.40,
						["Wound10.OGG"] = 00.46,
						["WoundCrit01.OGG"] = 01.12,
						["WoundCrit02.OGG"] = 01.13,
						["WoundCrit03.OGG"] = 01.37,
						["WoundCrit04.OGG"] = 01.15,
						["WoundCrit05.OGG"] = 00.98,
						["AGGRO_01.OGG"] = 04.80,
						["CRYSTALHIT_01.OGG"] = 02.70,
						["DEATH_01.OGG"] = 04.47,
						["INTRO_01.OGG"] = 08.04,
					},
				},
				["Hagrim\\VO_"] = {
					["QE_VJ_"] = {
						["Hagrim_"] = {
							["Bridge01.ogg"] = 03.67,
							["Bridge02.ogg"] = 03.72,
							["Bridge03.ogg"] = 03.41,
							["Bridge04.ogg"] = 05.42,
						},
					},
				},
				["HaiyanTheUnstoppable\\VO_"] = {
					["MP_HAIYAN_"] = {
						["EVENT_"] = {
							["IDLE_"] = {
								["01.OGG"] = 05.85,
								["02.OGG"] = 06.99,
							},
							["MIDBRAWL_"] = {
								["01.OGG"] = 06.23,
								["02.OGG"] = 08.21,
								["03.OGG"] = 06.35,
								["04.OGG"] = 04.84,
							},
							["POSTCOMBAT_"] = {
								["01.OGG"] = 10.93,
								["02.OGG"] = 10.31,
							},
						},
						["AGRO_01.OGG"] = 08.60,
						["DEATH_01.OGG"] = 06.85,
						["SLAY_01.OGG"] = 02.75,
					},
				},
				["Hakkar\\"] = {
					["VO_ZG2_"] = {
						["HAKKAR_"] = {
							["DEFEAT_"] = {
								["01.ogg"] = 08.47,
								["02.ogg"] = 21.15,
							},
							["EVENT_"] = {
								["START.ogg"] = 10.53,
								["BREAK_CHAIN.ogg"] = 05.77,
							},
						},
					},
					["HakkarAttackA.ogg"] = 02.00,
					["HakkarAttackB.ogg"] = 01.89,
					["HakkarAttackC.ogg"] = 01.93,
					["HakkarDeath.ogg"] = 02.25,
					["HakkarWoundA.ogg"] = 01.01,
					["HakkarWoundB.ogg"] = 01.13,
					["HakkarWoundC.ogg"] = 01.06,
					["HakkarWoundCrit.ogg"] = 01.98,
				},
				["Halazzi\\"] = {
					["HalazziAggro.ogg"] = 04.25,
					["HalazziBerserk.ogg"] = 05.31,
					["HalazziCombine.ogg"] = 02.32,
					["HalazziDeath.ogg"] = 03.82,
					["HalazziEvent01.ogg"] = 03.83,
					["HalazziEvent02.ogg"] = 05.47,
					["HalazziMelee01.ogg"] = 02.48,
					["HalazziMelee02.ogg"] = 02.91,
					["HalazziSlay01.ogg"] = 02.32,
					["HalazziSlay02.ogg"] = 01.67,
					["HalazziSplit.ogg"] = 03.39,
					["HalazziTrollAttack01.ogg"] = 00.49,
					["HalazziTrollAttack02.ogg"] = 00.59,
					["HalazziTrollAttack03.ogg"] = 00.68,
					["HalazziTrollAttack04.ogg"] = 00.86,
					["HalazziTrollAttack05.ogg"] = 00.75,
					["HalazziTrollAttack06.ogg"] = 00.83,
					["HalazziTrollAttack07.ogg"] = 01.04,
					["HalazziTrollAttack08.ogg"] = 01.18,
					["HalazziTrollAttack09.ogg"] = 01.35,
					["HalazziTrollAttack10.ogg"] = 01.25,
					["HalazziTrollCrit01.ogg"] = 01.04,
					["HalazziTrollCrit02.ogg"] = 00.96,
					["HalazziTrollCrit03.ogg"] = 01.37,
					["HalazziTrollCrit04.ogg"] = 01.14,
					["HalazziTrollWound01.ogg"] = 00.23,
					["HalazziTrollWound02.ogg"] = 00.36,
					["HalazziTrollWound03.ogg"] = 00.51,
					["HalazziTrollWound04.ogg"] = 00.57,
					["HalazziTrollWound05.ogg"] = 00.48,
					["HalazziTrollWound06.ogg"] = 00.77,
				},
				["HalazziExertions\\"] = {
					["HalazziAttackA.ogg"] = 00.87,
					["HalazziAttackB.ogg"] = 00.65,
					["HalazziAttackC.ogg"] = 00.84,
					["HalazziAttackD.ogg"] = 00.93,
					["HalazziAttackE.ogg"] = 00.83,
					["HalazziAttackF.ogg"] = 00.92,
					["HalazziAttackG.ogg"] = 01.19,
					["HalazziAttackH.ogg"] = 01.24,
					["HalazziAttackI.ogg"] = 01.39,
					["HalazziAttackJ.ogg"] = 01.32,
					["HalazziWoundA.ogg"] = 00.45,
					["HalazziWoundB.ogg"] = 00.54,
					["HalazziWoundC.ogg"] = 00.68,
					["HalazziWoundCritA.ogg"] = 01.16,
					["HalazziWoundCritB.ogg"] = 01.12,
					["HalazziWoundCritC.ogg"] = 01.47,
					["HalazziWoundCritD.ogg"] = 01.15,
					["HalazziWoundD.ogg"] = 00.75,
					["HalazziWoundE.ogg"] = 00.69,
					["HalazziWoundF.ogg"] = 00.83,
				},
				["Halfus\\VO_"] = {
					["BT_Halfus_"] = {
						["Attack01.ogg"] = 00.76,
						["Attack02.ogg"] = 00.81,
						["Attack03.ogg"] = 00.87,
						["Attack04.ogg"] = 00.76,
						["Attack05.ogg"] = 00.93,
						["Attack06.ogg"] = 00.95,
						["Attack07.ogg"] = 00.86,
						["Attack08.ogg"] = 00.79,
						["Attack09.ogg"] = 00.95,
						["Attack10.ogg"] = 00.80,
						["AttackCrit01.ogg"] = 01.33,
						["AttackCrit02.ogg"] = 01.32,
						["AttackCrit03.ogg"] = 01.48,
						["AttackCrit04.ogg"] = 01.33,
						["AttackCrit05.ogg"] = 01.51,
						["AttackCrit06.ogg"] = 01.88,
						["Event01.ogg"] = 05.69,
						["Event02.ogg"] = 03.15,
						["Event03.ogg"] = 04.31,
						["Event04.ogg"] = 02.93,
						["Event05.ogg"] = 02.72,
						["Event06.ogg"] = 04.95,
						["Event07.ogg"] = 02.54,
						["Event08.ogg"] = 03.87,
						["Event09.ogg"] = 04.95,
						["Wound01.ogg"] = 00.71,
						["Wound02.ogg"] = 00.74,
						["Wound03.ogg"] = 00.70,
						["Wound04.ogg"] = 00.78,
						["Wound05.ogg"] = 00.71,
						["Wound06.ogg"] = 00.93,
						["Wound07.ogg"] = 00.75,
						["Wound08.ogg"] = 01.02,
						["Wound09.ogg"] = 00.94,
						["Wound10.ogg"] = 00.93,
						["WoundCrit01.ogg"] = 01.56,
						["WoundCrit02.ogg"] = 01.18,
						["WoundCrit03.ogg"] = 01.74,
						["WoundCrit04.ogg"] = 01.74,
						["WoundCrit05.ogg"] = 01.72,
					},
				},
				["halion\\RS_"] = {
					["Halion_"] = {
						["Aggro01.ogg"] = 08.76,
						["Attack01.ogg"] = 01.25,
						["Attack02.ogg"] = 01.17,
						["Attack03.ogg"] = 01.04,
						["Attack04.ogg"] = 00.96,
						["Attack05.ogg"] = 00.92,
						["Attack06.ogg"] = 00.83,
						["Attack07.ogg"] = 00.99,
						["Attack08.ogg"] = 00.92,
						["Attack09.ogg"] = 00.89,
						["Attack10.ogg"] = 00.91,
						["Beserk01.ogg"] = 02.04,
						["Death01.ogg"] = 14.28,
						["Phase2.ogg"] = 07.95,
						["Phase3.ogg"] = 08.00,
						["Slay01.ogg"] = 03.24,
						["Slay02.ogg"] = 01.32,
						["Spawn01.ogg"] = 07.13,
						["Special01.ogg"] = 02.73,
						["Special02.ogg"] = 02.61,
						["Wound01.ogg"] = 01.04,
						["Wound02.ogg"] = 00.89,
						["Wound03.ogg"] = 00.86,
						["Wound04.ogg"] = 00.85,
						["Wound05.ogg"] = 00.83,
						["Wound06.ogg"] = 01.13,
						["Wound07.ogg"] = 01.06,
						["Wound08.ogg"] = 01.15,
						["Wound09.ogg"] = 01.33,
						["Wound10.ogg"] = 01.18,
						["WoundCrit01.ogg"] = 01.35,
						["WoundCrit02.ogg"] = 01.49,
						["WoundCrit03.ogg"] = 01.81,
						["WoundCrit04.ogg"] = 01.03,
						["WoundCrit05.ogg"] = 01.18,
					},
				},
				["Halukal\\VO_"] = {
					["52_"] = {
						["CAPT_HALUKAL_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 02.28,
								["02.OGG"] = 01.40,
								["03.OGG"] = 01.96,
								["04.OGG"] = 02.27,
								["05.OGG"] = 02.30,
							},
							["Attack_"] = {
								["01.OGG"] = 00.46,
								["010.OGG"] = 00.61,
								["02.OGG"] = 00.59,
								["03.OGG"] = 00.44,
								["04.OGG"] = 01.09,
								["05.OGG"] = 00.32,
								["06.OGG"] = 00.73,
								["07.OGG"] = 00.81,
								["08.OGG"] = 00.95,
								["09.OGG"] = 00.55,
							},
							["Death_"] = {
								["01.OGG"] = 01.57,
								["02.OGG"] = 01.58,
								["03.OGG"] = 03.31,
								["04.OGG"] = 04.04,
								["05.OGG"] = 03.37,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 00.92,
								["02.OGG"] = 01.49,
								["03.OGG"] = 01.29,
								["04.OGG"] = 01.39,
								["05.OGG"] = 01.27,
							},
							["Wound_"] = {
								["01.OGG"] = 00.67,
								["02.OGG"] = 00.61,
								["03.OGG"] = 00.85,
								["04.OGG"] = 00.64,
								["05.OGG"] = 00.39,
								["06.OGG"] = 00.48,
								["07.OGG"] = 00.62,
								["08.OGG"] = 00.70,
								["09.OGG"] = 00.60,
							},
						},
						["Halukal_Alliance_"] = {
							["Blast_"] = {
								["01.OGG"] = 14.97,
								["02.OGG"] = 06.72,
								["03.OGG"] = 07.51,
								["04.OGG"] = 04.24,
								["05.OGG"] = 03.53,
								["06.OGG"] = 03.55,
							},
						},
					},
				},
				["Hamuul\\VO_"] = {
					["QE_HJ_"] = {
						["Hamuul_"] = {
							["Attack01.ogg"] = 00.47,
							["Attack02.ogg"] = 00.58,
							["Attack03.ogg"] = 00.75,
							["Attack04.ogg"] = 01.02,
							["Attack05.ogg"] = 00.73,
							["Attack06.ogg"] = 00.86,
							["Attack07.ogg"] = 00.95,
							["Attack08.ogg"] = 00.67,
							["Attack09.ogg"] = 00.74,
							["Attack10.ogg"] = 00.87,
							["AttackCritical01.ogg"] = 00.95,
							["AttackCritical02.ogg"] = 00.89,
							["AttackCritical03.ogg"] = 00.97,
							["AttackCritical04.ogg"] = 00.92,
							["AttackCritical05.ogg"] = 01.06,
							["AttackCritical06.ogg"] = 00.90,
							["Death01.ogg"] = 02.40,
							["Death02.ogg"] = 01.71,
							["Death03.ogg"] = 02.82,
							["Death04.ogg"] = 03.03,
							["Death05.ogg"] = 02.20,
							["Greeting01.ogg"] = 02.38,
							["Greeting02.ogg"] = 02.71,
							["Greeting03.ogg"] = 04.08,
							["Greeting04.ogg"] = 04.81,
							["Rag01.ogg"] = 04.75,
							["RagEnd01.ogg"] = 15.36,
							["Wound01.ogg"] = 00.61,
							["Wound02.ogg"] = 00.66,
							["Wound03.ogg"] = 00.80,
							["Wound04.ogg"] = 00.80,
							["Wound05.ogg"] = 00.74,
							["Wound06.ogg"] = 00.39,
							["Wound07.ogg"] = 00.87,
							["Wound08.ogg"] = 00.64,
							["Wound09.ogg"] = 00.71,
							["Wound10.ogg"] = 00.48,
							["WoundCritical01.ogg"] = 00.95,
							["WoundCritical02.ogg"] = 01.68,
							["WoundCritical03.ogg"] = 00.65,
							["WoundCritical04.ogg"] = 00.98,
							["WoundCritical05.ogg"] = 01.48,
						},
					},
					["QUEST_42_"] = {
						["HAMUUL_"] = {
							["CONFRONTATION_"] = {
								["01.ogg"] = 04.16,
								["02.ogg"] = 08.89,
								["03.ogg"] = 07.18,
								["04.ogg"] = 02.20,
							},
							["LEYARA_"] = {
								["01.ogg"] = 07.48,
								["02.ogg"] = 07.31,
								["03.ogg"] = 06.35,
								["04.ogg"] = 05.64,
							},
							["PORTAL_"] = {
								["01.ogg"] = 04.39,
								["02.ogg"] = 07.20,
							},
							["SHRINE_"] = {
								["01.ogg"] = 03.62,
								["02.ogg"] = 03.79,
							},
						},
					},
					["FL_HAMUUL_EVENT_01.ogg"] = 11.77,
				},
				["Hansel\\VO_"] = {
					["60_"] = {
						["HANSEL_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.71,
								["02.ogg"] = 01.13,
								["03.ogg"] = 01.75,
								["04.ogg"] = 00.90,
								["05.ogg"] = 00.82,
							},
							["Attack_"] = {
								["01.ogg"] = 00.31,
								["010.ogg"] = 00.60,
								["02.ogg"] = 00.34,
								["03.ogg"] = 00.42,
								["04.ogg"] = 00.23,
								["05.ogg"] = 00.47,
								["06.ogg"] = 00.41,
								["07.ogg"] = 00.41,
								["08.ogg"] = 00.54,
								["09.ogg"] = 00.40,
							},
							["Death_"] = {
								["01.ogg"] = 02.06,
								["02.ogg"] = 01.99,
								["03.ogg"] = 01.61,
								["04.ogg"] = 02.50,
								["05.ogg"] = 01.67,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 00.97,
								["02.ogg"] = 01.20,
								["03.ogg"] = 00.58,
								["04.ogg"] = 01.43,
								["05.ogg"] = 01.46,
							},
							["Wound_"] = {
								["01.ogg"] = 00.39,
								["010.ogg"] = 00.52,
								["02.ogg"] = 00.48,
								["03.ogg"] = 00.55,
								["04.ogg"] = 00.68,
								["05.ogg"] = 00.58,
								["06.ogg"] = 00.87,
								["07.ogg"] = 00.33,
								["08.ogg"] = 00.29,
								["09.ogg"] = 00.92,
							},
						},
						["NGD_"] = {
							["OTHERS_HANSEL_"] = {
								["01.ogg"] = 01.44,
								["02.ogg"] = 02.06,
								["03.ogg"] = 03.96,
								["04.ogg"] = 04.10,
								["05.ogg"] = 02.81,
								["06.ogg"] = 03.28,
								["07.ogg"] = 06.49,
								["08.ogg"] = 05.38,
								["09.ogg"] = 02.12,
								["10.ogg"] = 06.61,
							},
							["QUEST_HANSEL_"] = {
								["01.ogg"] = 07.19,
								["02.ogg"] = 08.68,
							},
						},
						["TANAAN_GUNPOWDER_"] = {
							["PLOT_"] = {
								["01.ogg"] = 01.47,
								["02.ogg"] = 02.45,
								["03.ogg"] = 01.99,
								["04.ogg"] = 03.39,
							},
						},
						["TAN_HANSEL_"] = {
							["IRON_"] = {
								["01.ogg"] = 02.12,
								["02.ogg"] = 04.14,
							},
							["HIJINKS_01.ogg"] = 01.17,
						},
					},
				},
				["Hansgar\\VO_"] = {
					["60_"] = {
						["FR_HANSGAR_"] = {
							["INTRO_"] = {
								["01.ogg"] = 04.63,
								["02.ogg"] = 04.55,
								["03.ogg"] = 06.29,
								["04.ogg"] = 03.93,
							},
							["SPELL_"] = {
								["01.ogg"] = 03.27,
								["02.ogg"] = 04.93,
								["03.ogg"] = 01.44,
								["04.ogg"] = 04.97,
							},
							["AGGRO.ogg"] = 03.13,
							["DEATH.ogg"] = 04.93,
							["KILL.ogg"] = 03.22,
						},
						["HANSGAR_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.69,
								["02.ogg"] = 01.33,
								["03.ogg"] = 02.79,
								["04.ogg"] = 01.44,
								["05.ogg"] = 02.09,
							},
							["Attack_"] = {
								["01.ogg"] = 00.35,
								["02.ogg"] = 00.35,
								["03.ogg"] = 00.38,
								["04.ogg"] = 00.55,
								["05.ogg"] = 00.38,
								["06.ogg"] = 00.78,
								["07.ogg"] = 00.69,
								["08.ogg"] = 00.43,
								["09.ogg"] = 00.63,
								["10.ogg"] = 00.49,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 00.99,
								["02.ogg"] = 00.91,
								["03.ogg"] = 00.88,
								["04.ogg"] = 00.67,
								["05.ogg"] = 01.38,
							},
							["Wound_"] = {
								["01.ogg"] = 00.40,
								["02.ogg"] = 00.39,
								["03.ogg"] = 00.60,
								["04.ogg"] = 00.52,
								["05.ogg"] = 00.67,
								["06.ogg"] = 00.53,
								["07.ogg"] = 00.61,
								["08.ogg"] = 00.62,
								["09.ogg"] = 00.67,
								["10.ogg"] = 00.52,
							},
						},
					},
				},
				["HaoMann\\VO_"] = {
					["Jade_"] = {
						["Forest_Fresco_"] = {
							["Event_Hao_"] = {
								["01.OGG"] = 07.13,
								["02.OGG"] = 08.91,
							},
						},
						["Mines_"] = {
							["Arrival_Event_"] = {
								["Hao_"] = {
									["01.OGG"] = 01.09,
									["02.OGG"] = 02.43,
									["03.OGG"] = 03.31,
									["04.OGG"] = 04.59,
								},
							},
							["Cart_Ride_"] = {
								["Hao_"] = {
									["01.OGG"] = 01.12,
									["02.OGG"] = 02.39,
									["03.OGG"] = 04.16,
									["04.OGG"] = 02.79,
									["05.OGG"] = 05.59,
								},
							},
						},
					},
				},
				["HarbingerSkyriss\\TEMPEST_"] = {
					["Harbinger_"] = {
						["Aggro01.ogg"] = 04.29,
						["Attack01.ogg"] = 00.54,
						["Attack02.ogg"] = 00.59,
						["Attack03.ogg"] = 00.89,
						["Attack04.ogg"] = 00.68,
						["Attack05.ogg"] = 00.75,
						["Attack06.ogg"] = 00.68,
						["Death01.ogg"] = 07.44,
						["Fear01.ogg"] = 02.54,
						["Fear02.ogg"] = 04.31,
						["Freed01.ogg"] = 22.17,
						["Images01.ogg"] = 05.56,
						["MndCntrl01.ogg"] = 03.76,
						["MndCntrl02.ogg"] = 04.94,
						["Slay01.ogg"] = 02.16,
						["Slay02.ogg"] = 04.73,
						["Wound01.ogg"] = 01.16,
						["Wound02.ogg"] = 00.53,
						["Wound03.ogg"] = 01.16,
						["Wound04.ogg"] = 01.24,
						["Wound05.ogg"] = 01.13,
					},
				},
				["Harkoa\\"] = {
					["HarkoaAttack1.ogg"] = 02.85,
					["HarkoaAttack2.ogg"] = 02.92,
					["HarkoaAttack3.ogg"] = 03.17,
					["HarkoaAttack4.ogg"] = 02.93,
					["HarkoaAttack5.ogg"] = 02.92,
					["HarkoaDeath.ogg"] = 03.91,
					["HarkoaWound1.ogg"] = 02.84,
					["HarkoaWound2.ogg"] = 02.73,
					["HarkoaWound3.ogg"] = 02.86,
					["HarkoaWound4.ogg"] = 03.56,
					["HarkoaWound5.ogg"] = 03.01,
				},
				["Harpy\\"] = {
					["mHarpyAggroA.ogg"] = 01.72,
					["mHarpyAttackA.ogg"] = 00.98,
					["mHarpyAttackB.ogg"] = 00.72,
					["mHarpyAttackC.ogg"] = 01.01,
					["mHarpyDeathA.ogg"] = 01.70,
					["mHarpySpellCastA.ogg"] = 01.39,
					["mHarpyWoundA.ogg"] = 01.14,
					["mHarpyWoundB.ogg"] = 00.63,
					["mHarpyWoundC.ogg"] = 00.62,
					["mHarpyWoundCritical.ogg"] = 01.23,
				},
				["Hartley\\VO_"] = {
					["QE_TH_"] = {
						["Hartley_"] = {
							["Event01.ogg"] = 01.63,
							["Event02.ogg"] = 01.30,
							["Event03.ogg"] = 00.89,
							["Event04.ogg"] = 06.77,
							["Event05.ogg"] = 03.04,
							["Event06.ogg"] = 06.10,
							["Event07.ogg"] = 04.41,
							["Event08.ogg"] = 09.32,
							["Event09.ogg"] = 05.24,
							["Event10.ogg"] = 04.13,
							["Event11.ogg"] = 06.43,
							["Event12.ogg"] = 06.97,
							["Event13.ogg"] = 02.10,
							["Event14.ogg"] = 10.28,
							["Event15.ogg"] = 06.01,
							["Event16.ogg"] = 11.09,
						},
					},
				},
				["HarvestGolem\\"] = {
					["HarvestGolemAggroA.ogg"] = 01.58,
					["HarvestGolemAttackA.ogg"] = 01.77,
					["HarvestGolemAttackB.ogg"] = 01.47,
					["HarvestGolemAttackC.ogg"] = 01.67,
					["HarvestGolemDeathA.ogg"] = 06.77,
					["HarvestGolemDeathStage1.ogg"] = 04.41,
					["HarvestGolemDeathStage2.ogg"] = 03.38,
					["HarvestGolemFootstepA.ogg"] = 00.86,
					["HarvestGolemFootstepB.ogg"] = 00.74,
					["HarvestGolemFootstepC.ogg"] = 01.15,
					["HarvestGolemFootstepD.ogg"] = 00.69,
					["HarvestGolemFootstepE.ogg"] = 00.81,
					["HarvestGolemPreAggroA.ogg"] = 01.61,
					["HarvestGolemStandA.ogg"] = 06.23,
					["HarvestGolemWoundA.ogg"] = 01.03,
					["HarvestGolemWoundB.ogg"] = 01.40,
					["HarvestGolemWoundC.ogg"] = 01.34,
					["HarvestGolemWoundCriticalA.ogg"] = 01.14,
				},
				["Hataaru\\VO_"] = {
					["60_"] = {
						["HATAARU_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 01.47,
								["02.ogg"] = 01.61,
								["03.ogg"] = 02.13,
								["04.ogg"] = 01.07,
								["05.ogg"] = 01.58,
							},
							["Attack_"] = {
								["01.ogg"] = 00.31,
								["010.ogg"] = 00.49,
								["02.ogg"] = 00.30,
								["03.ogg"] = 00.33,
								["04.ogg"] = 00.40,
								["05.ogg"] = 00.32,
								["06.ogg"] = 00.38,
								["07.ogg"] = 00.42,
								["08.ogg"] = 00.52,
								["09.ogg"] = 00.43,
							},
							["Death_"] = {
								["01.ogg"] = 02.99,
								["02.ogg"] = 02.44,
								["03.ogg"] = 02.93,
								["04.ogg"] = 02.95,
								["05.ogg"] = 01.19,
							},
							["FAITH_"] = {
								["01.ogg"] = 08.03,
								["02.ogg"] = 05.72,
							},
							["FAREWELL_"] = {
								["01.ogg"] = 02.46,
								["02.ogg"] = 02.15,
							},
							["GREETING_"] = {
								["01.ogg"] = 02.53,
								["02.ogg"] = 01.86,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.18,
								["02.ogg"] = 01.22,
								["03.ogg"] = 01.35,
								["04.ogg"] = 01.34,
								["05.ogg"] = 01.71,
							},
							["Wound_"] = {
								["01.ogg"] = 00.38,
								["010.ogg"] = 00.63,
								["02.ogg"] = 00.44,
								["03.ogg"] = 00.51,
								["04.ogg"] = 00.50,
								["05.ogg"] = 00.50,
								["06.ogg"] = 00.46,
								["07.ogg"] = 00.57,
								["08.ogg"] = 00.39,
								["09.ogg"] = 00.49,
							},
						},
						["SMV_"] = {
							["DEFEN_HAATARU_"] = {
								["01.ogg"] = 03.17,
								["02.ogg"] = 04.11,
								["03.ogg"] = 02.12,
								["04.ogg"] = 03.79,
								["05.ogg"] = 02.64,
								["06.ogg"] = 05.49,
								["07.ogg"] = 02.02,
								["08.ogg"] = 03.62,
							},
							["EXCORCISM_HAATARU_"] = {
								["01.ogg"] = 05.06,
								["02.ogg"] = 05.05,
								["03.ogg"] = 04.17,
							},
							["RAMPARTS_HAATARU_"] = {
								["01.ogg"] = 03.27,
								["02.ogg"] = 08.78,
								["03.ogg"] = 09.04,
								["04.ogg"] = 05.68,
								["05.ogg"] = 04.11,
								["06.ogg"] = 02.08,
							},
							["EXARCH_HATAARU_01.ogg"] = 04.79,
						},
					},
				},
				["Hatock\\VO_"] = {
					["60_"] = {
						["FFR_VENGEANCE_"] = {
							["HATOCK_"] = {
								["01.OGG"] = 07.56,
								["02.OGG"] = 06.74,
								["03.OGG"] = 09.45,
								["04.OGG"] = 03.68,
								["05.OGG"] = 05.00,
								["06.OGG"] = 03.99,
								["07.OGG"] = 03.73,
								["08.OGG"] = 03.88,
								["09.OGG"] = 05.97,
							},
						},
						["HATOCK_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.13,
								["02.OGG"] = 01.61,
								["03.OGG"] = 01.14,
								["04.OGG"] = 01.31,
								["05.OGG"] = 01.38,
							},
							["Attack_"] = {
								["01.OGG"] = 00.53,
								["02.OGG"] = 00.50,
								["03.OGG"] = 00.60,
								["04.OGG"] = 00.92,
								["05.OGG"] = 00.48,
								["06.OGG"] = 00.49,
								["07.OGG"] = 00.66,
								["08.OGG"] = 00.64,
								["09.OGG"] = 00.70,
								["10.OGG"] = 00.49,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.20,
								["02.OGG"] = 01.66,
								["03.OGG"] = 01.57,
								["04.OGG"] = 01.69,
								["05.OGG"] = 01.26,
							},
							["Wound_"] = {
								["01.OGG"] = 00.89,
								["02.OGG"] = 00.91,
								["03.OGG"] = 00.49,
								["04.OGG"] = 00.94,
								["05.OGG"] = 00.71,
								["06.OGG"] = 00.58,
								["07.OGG"] = 00.92,
								["08.OGG"] = 00.60,
								["09.OGG"] = 01.34,
							},
						},
					},
				},
				["HawkmasterNurong\\VO_"] = {
					["HawkmasterNurong_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.15,
							["02.OGG"] = 01.34,
							["03.OGG"] = 01.52,
							["04.OGG"] = 01.50,
							["05.OGG"] = 01.26,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.35,
							["02.OGG"] = 00.27,
							["03.OGG"] = 00.44,
							["04.OGG"] = 00.31,
							["05.OGG"] = 00.25,
							["06.OGG"] = 00.31,
							["07.OGG"] = 00.24,
							["08.OGG"] = 00.32,
							["09.OGG"] = 00.33,
							["10.OGG"] = 00.30,
						},
						["Death_"] = {
							["01.OGG"] = 04.28,
							["02.OGG"] = 04.09,
							["03.OGG"] = 04.41,
							["04.OGG"] = 03.29,
							["05.OGG"] = 03.47,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.60,
							["02.OGG"] = 02.04,
							["03.OGG"] = 01.81,
							["04.OGG"] = 01.98,
							["05.OGG"] = 01.24,
						},
						["Wound_"] = {
							["01.OGG"] = 00.29,
							["02.OGG"] = 00.30,
							["03.OGG"] = 00.69,
							["04.OGG"] = 00.45,
							["05.OGG"] = 00.34,
							["06.OGG"] = 00.40,
							["07.OGG"] = 00.58,
							["08.OGG"] = 00.54,
							["09.OGG"] = 00.33,
							["10.OGG"] = 00.20,
						},
					},
					["Nurong_ShadoPan_"] = {
						["Finale_"] = {
							["01.OGG"] = 02.31,
							["02.OGG"] = 02.36,
							["03.OGG"] = 03.86,
							["04.OGG"] = 01.94,
							["05.OGG"] = 04.16,
							["06.OGG"] = 08.51,
							["07.OGG"] = 04.41,
							["08.OGG"] = 03.88,
							["09.OGG"] = 01.47,
							["10.OGG"] = 01.69,
							["11.OGG"] = 01.74,
						},
					},
					["TS_NURONG_"] = {
						["CHALLENGE_"] = {
							["01.OGG"] = 05.02,
							["02.OGG"] = 01.76,
							["03.OGG"] = 01.51,
							["04.OGG"] = 03.27,
							["05.OGG"] = 02.11,
							["06.OGG"] = 04.07,
							["07.OGG"] = 05.79,
							["08.OGG"] = 06.22,
						},
						["DAILY_GUARDIAN_"] = {
							["CHOICE_"] = {
								["01.OGG"] = 01.50,
								["02.OGG"] = 01.27,
								["03.OGG"] = 01.76,
							},
							["01.OGG"] = 02.01,
							["02.OGG"] = 01.28,
							["03.OGG"] = 01.44,
							["04.OGG"] = 01.46,
							["05.OGG"] = 03.60,
							["06.OGG"] = 03.60,
							["07.OGG"] = 02.56,
							["08.OGG"] = 01.67,
						},
						["FAREWELL_"] = {
							["01.OGG"] = 01.97,
							["02.OGG"] = 01.76,
							["03.OGG"] = 01.30,
							["04.OGG"] = 01.96,
							["05.OGG"] = 01.62,
						},
						["FINALE_"] = {
							["SUBBOSS_"] = {
								["01.OGG"] = 02.94,
								["02.OGG"] = 01.65,
							},
							["BOSS_01.OGG"] = 03.04,
							["START_01.OGG"] = 00.64,
						},
						["GREETING_"] = {
							["01.OGG"] = 01.36,
							["02.OGG"] = 01.03,
							["03.OGG"] = 03.21,
							["04.OGG"] = 01.18,
							["05.OGG"] = 00.94,
						},
						["PISSED_"] = {
							["01.OGG"] = 02.33,
							["02.OGG"] = 03.61,
							["03.OGG"] = 02.92,
							["04.OGG"] = 03.21,
						},
						["SHOOTING_QUEST_"] = {
							["01.OGG"] = 04.16,
							["02.OGG"] = 04.80,
							["03.OGG"] = 02.68,
							["04.OGG"] = 02.95,
						},
						["TANK_BOSS_"] = {
							["01.OGG"] = 03.52,
							["02.OGG"] = 02.81,
							["03.OGG"] = 02.96,
							["04.OGG"] = 04.23,
							["05.OGG"] = 02.86,
							["06.OGG"] = 03.07,
							["07.OGG"] = 02.67,
							["08.OGG"] = 01.46,
							["09.OGG"] = 03.01,
							["10.OGG"] = 05.18,
						},
						["FIRST_APPROACH_01.OGG"] = 02.16,
					},
				},
				["HAYDRIAS\\VO_"] = {
					["QUEST_42_"] = {
						["HAYDRIAS_WATER_"] = {
							["01.ogg"] = 15.67,
							["02.ogg"] = 16.81,
							["03.ogg"] = 15.77,
							["04.ogg"] = 14.24,
							["05.ogg"] = 07.46,
						},
					},
				},
				["HAZZARAH\\VO_"] = {
					["ZG2_HAZZARAH_"] = {
						["DREAMSTATE_"] = {
							["01.ogg"] = 06.07,
							["02.ogg"] = 09.52,
							["03.ogg"] = 06.09,
						},
						["KILL_"] = {
							["01.ogg"] = 06.73,
							["02.ogg"] = 06.28,
						},
						["AGGRO.ogg"] = 07.36,
						["ATTACK01.ogg"] = 01.81,
						["ATTACK02.ogg"] = 02.45,
						["ATTACK03.ogg"] = 02.06,
						["ATTACK04.ogg"] = 01.91,
						["ATTACK05.ogg"] = 02.11,
						["ATTACKCRIT01.ogg"] = 02.20,
						["ATTACKCRIT02.ogg"] = 02.18,
						["ATTACKCRIT03.ogg"] = 02.13,
						["ATTACKCRIT04.ogg"] = 02.02,
						["ATTACKCRIT05.ogg"] = 02.03,
						["DEATH.ogg"] = 07.52,
						["SPELLCAST01.ogg"] = 02.50,
						["SPELLCAST02.ogg"] = 02.07,
						["SPELLCAST03.ogg"] = 02.12,
						["SPELLCAST04.ogg"] = 02.25,
						["WOUND01.ogg"] = 01.77,
						["WOUND02.ogg"] = 01.97,
						["WOUND03.ogg"] = 02.18,
						["WOUND04.ogg"] = 01.94,
						["WOUND05.ogg"] = 01.97,
						["WOUNDCRIT01.ogg"] = 02.14,
						["WOUNDCRIT02.ogg"] = 02.25,
						["WOUNDCRIT03.ogg"] = 02.26,
						["WOUNDCRIT04.ogg"] = 02.43,
						["WOUNDCRIT05.ogg"] = 02.69,
					},
				},
				["HeadlessHorseman\\Horseman_"] = {
					["Attack_"] = {
						["01.ogg"] = 01.00,
						["02.ogg"] = 00.75,
						["03.ogg"] = 00.94,
						["04.ogg"] = 00.99,
						["05.ogg"] = 00.91,
						["06.ogg"] = 00.81,
					},
					["Failing_"] = {
						["01.ogg"] = 10.60,
						["02.ogg"] = 10.41,
					},
					["Laugh_"] = {
						["01.ogg"] = 07.12,
						["02.ogg"] = 03.55,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 00.90,
						["02.ogg"] = 01.32,
						["03.ogg"] = 00.95,
						["04.ogg"] = 01.48,
						["05.ogg"] = 01.51,
						["06.ogg"] = 00.82,
						["07.ogg"] = 00.80,
					},
					["Wound_"] = {
						["01.ogg"] = 00.71,
						["02.ogg"] = 00.43,
						["03.ogg"] = 00.49,
						["04.ogg"] = 00.45,
						["05.ogg"] = 00.50,
						["06.ogg"] = 00.56,
						["07.ogg"] = 00.82,
						["08.ogg"] = 00.62,
					},
					["Aggro_01.ogg"] = 07.98,
					["Beckon_01.ogg"] = 04.82,
					["BodyDefeat_01.ogg"] = 09.64,
					["Bomb_01.ogg"] = 17.45,
					["Conflag_01.ogg"] = 09.32,
					["Death_01.ogg"] = 08.66,
					["Fire_01.ogg"] = 10.06,
					["Out_01.ogg"] = 08.46,
					["Request_01.ogg"] = 05.83,
					["Return_01.ogg"] = 08.28,
					["Slay_01.ogg"] = 08.62,
					["Special_01.ogg"] = 08.47,
				},
				["Hearthsteed\\Mon_"] = {
					["HearthSteed_Mount_"] = {
						["Chuff_"] = {
							["01.OGG"] = 00.66,
							["02.OGG"] = 00.79,
							["03.OGG"] = 00.60,
							["04.OGG"] = 00.80,
							["05.OGG"] = 01.17,
							["06.OGG"] = 00.71,
							["07.OGG"] = 00.64,
							["08.OGG"] = 00.78,
							["09.OGG"] = 00.63,
							["10.OGG"] = 00.63,
						},
						["death_"] = {
							["01.OGG"] = 03.29,
							["02.OGG"] = 02.35,
							["03.OGG"] = 02.42,
						},
						["idle_"] = {
							["01.OGG"] = 01.72,
							["02.OGG"] = 01.99,
							["03.OGG"] = 02.46,
							["04.OGG"] = 01.45,
							["05.OGG"] = 02.16,
							["06.OGG"] = 01.90,
							["07.OGG"] = 01.70,
						},
						["MountSpecial_"] = {
							["01.OGG"] = 03.76,
							["02.OGG"] = 04.09,
							["03.OGG"] = 03.51,
						},
						["Summon_"] = {
							["01.OGG"] = 03.94,
							["02.OGG"] = 03.84,
							["03.OGG"] = 03.76,
						},
						["wound_"] = {
							["01.OGG"] = 01.10,
							["02.OGG"] = 01.49,
							["03.OGG"] = 01.32,
						},
						["Loop.OGG"] = 09.62,
					},
				},
				["HeiFeng\\VO_"] = {
					["HEIFENG_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 02.34,
							["02.OGG"] = 02.36,
							["03.OGG"] = 01.96,
							["04.OGG"] = 02.02,
							["05.OGG"] = 02.42,
						},
						["ATTACK_"] = {
							["01.OGG"] = 01.01,
							["02.OGG"] = 00.95,
							["03.OGG"] = 01.38,
							["04.OGG"] = 01.15,
							["05.OGG"] = 01.12,
							["06.OGG"] = 01.16,
							["07.OGG"] = 01.33,
							["08.OGG"] = 01.29,
							["09.OGG"] = 01.11,
							["10.OGG"] = 01.26,
						},
						["DEATH_"] = {
							["01.OGG"] = 04.87,
							["02.OGG"] = 05.13,
							["03.OGG"] = 03.84,
							["04.OGG"] = 03.61,
							["05.OGG"] = 05.18,
						},
						["LAUGH_"] = {
							["01.OGG"] = 08.51,
							["02.OGG"] = 08.25,
						},
						["WOUNDCRIT_"] = {
							["01.OGG"] = 01.63,
							["02.OGG"] = 01.70,
							["03.OGG"] = 01.55,
							["04.OGG"] = 01.50,
							["05.OGG"] = 01.47,
						},
						["WOUND_"] = {
							["01.OGG"] = 00.81,
							["02.OGG"] = 00.65,
							["03.OGG"] = 00.80,
							["04.OGG"] = 00.72,
							["05.OGG"] = 00.60,
							["06.OGG"] = 00.79,
							["07.OGG"] = 00.70,
							["08.OGG"] = 00.75,
							["09.OGG"] = 00.69,
							["10.OGG"] = 01.30,
						},
					},
					["Shadopan_Finale_"] = {
						["HeiFeng_"] = {
							["01.OGG"] = 05.70,
							["02.OGG"] = 07.17,
							["03.OGG"] = 05.10,
							["04.OGG"] = 06.18,
							["05.OGG"] = 05.08,
							["06.OGG"] = 07.65,
							["07.OGG"] = 04.63,
							["08.OGG"] = 05.48,
							["09.OGG"] = 04.88,
							["10.OGG"] = 06.45,
							["11.OGG"] = 05.71,
							["12.OGG"] = 07.14,
							["13.OGG"] = 03.86,
							["14.OGG"] = 04.72,
							["15.OGG"] = 05.47,
							["16.OGG"] = 04.38,
							["17.OGG"] = 02.40,
							["18.OGG"] = 08.38,
						},
					},
				},
				["Hekima\\VO_"] = {
					["53_HEKIMA_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.66,
							["02.OGG"] = 00.68,
							["03.OGG"] = 00.37,
							["04.OGG"] = 00.53,
							["05.OGG"] = 00.55,
						},
						["Attack_"] = {
							["01.OGG"] = 00.23,
							["02.OGG"] = 00.21,
							["03.OGG"] = 00.39,
							["04.OGG"] = 00.18,
							["05.OGG"] = 00.38,
							["06.OGG"] = 00.25,
							["07.OGG"] = 00.13,
							["08.OGG"] = 00.18,
						},
						["Scenario_"] = {
							["LowHealth_"] = {
								["01.OGG"] = 05.29,
								["02.OGG"] = 06.08,
								["03.OGG"] = 05.49,
							},
							["Death_01.OGG"] = 08.82,
							["Intro_01.OGG"] = 11.50,
							["Slay_01.OGG"] = 02.59,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 02.14,
							["02.OGG"] = 00.80,
							["03.OGG"] = 00.64,
							["04.OGG"] = 00.62,
							["05.OGG"] = 00.70,
						},
						["Wound_"] = {
							["01.OGG"] = 00.57,
							["02.OGG"] = 00.25,
							["03.OGG"] = 00.45,
							["04.OGG"] = 00.49,
							["05.OGG"] = 00.36,
							["06.OGG"] = 00.25,
							["07.OGG"] = 00.30,
						},
					},
				},
				["Helix\\VO_"] = {
					["DM_Helix_"] = {
						["Aggro01.ogg"] = 04.34,
						["Attack01.ogg"] = 00.70,
						["Attack02.ogg"] = 00.60,
						["Attack03.ogg"] = 00.63,
						["Attack04.ogg"] = 00.85,
						["Attack05.ogg"] = 00.61,
						["Attack06.ogg"] = 00.63,
						["Attack07.ogg"] = 00.80,
						["Attack08.ogg"] = 00.54,
						["Attack09.ogg"] = 00.52,
						["Attack10.ogg"] = 00.56,
						["AttackCritical01.ogg"] = 02.27,
						["AttackCritical02.ogg"] = 01.17,
						["AttackCritical03.ogg"] = 01.22,
						["AttackCritical04.ogg"] = 01.62,
						["HelixDies01.ogg"] = 03.04,
						["Kill01.ogg"] = 03.11,
						["OafDies01.ogg"] = 03.65,
						["Spell01.ogg"] = 03.81,
						["Spell02.ogg"] = 02.35,
						["Wound01.ogg"] = 00.46,
						["Wound02.ogg"] = 00.64,
						["Wound03.ogg"] = 00.73,
						["Wound04.ogg"] = 00.72,
						["Wound05.ogg"] = 00.43,
						["Wound06.ogg"] = 00.50,
						["Wound07.ogg"] = 00.37,
						["Wound08.ogg"] = 00.93,
						["Wound09.ogg"] = 00.47,
						["WoundCritical01.ogg"] = 00.83,
						["WoundCritical02.ogg"] = 00.48,
						["WoundCritical03.ogg"] = 00.85,
						["WoundCritical04.ogg"] = 01.69,
					},
				},
				["Hellhound\\MON_"] = {
					["Hellhound_"] = {
						["Aggro.ogg"] = 02.82,
						["Attack.ogg"] = 02.49,
						["Attack02.ogg"] = 02.70,
						["Attack03.ogg"] = 03.14,
						["Attack04.ogg"] = 02.91,
						["Attack05.ogg"] = 02.91,
						["Attack06.ogg"] = 02.78,
						["Attack07.ogg"] = 02.67,
						["Attack08.ogg"] = 02.41,
						["Attack09.ogg"] = 02.71,
						["AttackCrit.ogg"] = 03.15,
						["AttackCrit02.ogg"] = 02.79,
						["AttackCrit03.ogg"] = 03.15,
						["AttackCrit04.ogg"] = 02.78,
						["CreatureLoop.ogg"] = 15.53,
						["Death.ogg"] = 03.23,
						["Death03.ogg"] = 03.16,
						["Death04.ogg"] = 03.42,
						["PreAggro.ogg"] = 02.64,
						["Wound.ogg"] = 02.96,
						["Wound02.ogg"] = 02.50,
						["Wound03.ogg"] = 02.37,
						["Wound04.ogg"] = 02.34,
						["Wound05.ogg"] = 02.63,
						["Wound06.ogg"] = 02.78,
						["Wound07.ogg"] = 03.08,
						["Wound08.ogg"] = 02.82,
						["Wound09.ogg"] = 02.85,
						["WoundCrit.ogg"] = 03.16,
						["WoundCrit02.ogg"] = 03.80,
						["WoundCrit03.ogg"] = 03.00,
						["WoundCrit04.ogg"] = 03.19,
					},
				},
				["HeraldVolazj\\AK_"] = {
					["HeraldVolazj_"] = {
						["Aggro.ogg"] = 02.84,
						["Attack01.ogg"] = 00.56,
						["Attack02.ogg"] = 00.68,
						["Attack03.ogg"] = 00.79,
						["Attack04.ogg"] = 00.64,
						["Attack05.ogg"] = 00.82,
						["Attack06.ogg"] = 00.84,
						["Attack07.ogg"] = 00.69,
						["Attack08.ogg"] = 01.13,
						["Death01.ogg"] = 04.95,
						["Death02.ogg"] = 06.83,
						["PartyPhase01.ogg"] = 04.44,
						["Slay01.ogg"] = 02.25,
						["Slay02.ogg"] = 02.37,
						["Slay03.ogg"] = 03.96,
						["Wound01.ogg"] = 00.37,
						["Wound02.ogg"] = 00.33,
						["Wound03.ogg"] = 00.82,
						["Wound04.ogg"] = 00.57,
						["Wound05.ogg"] = 00.65,
						["Wound06.ogg"] = 00.94,
						["WoundCrit01.ogg"] = 00.96,
						["WoundCrit02.ogg"] = 01.30,
						["WoundCrit03.ogg"] = 01.65,
						["WoundCrit04.ogg"] = 01.01,
						["WoundCrit05.ogg"] = 00.83,
					},
				},
				["Hero Moon Priestess\\"] = {
					["HeroMoonPriestessReady1.ogg"] = 02.11,
					["HeroMoonPriestessWhat2.ogg"] = 00.80,
					["HeroMoonPriestessYes2.ogg"] = 00.64,
					["HeroMoonPriestessYesAttack1.ogg"] = 00.67,
					["HeroMoonPriestessYesAttack2.ogg"] = 01.05,
					["HeroMoonPriestessYesAttack3.ogg"] = 01.78,
				},
				["Hero Mountain King\\"] = {
					["HeroMountainKingYes1.ogg"] = 00.88,
					["HeroMountainKingYesAttack4.ogg"] = 01.22,
				},
				["Herod\\"] = {
					["HerodAggro01.ogg"] = 02.99,
					["HerodEnrage01.ogg"] = 01.97,
					["HerodSlay01.ogg"] = 01.54,
					["HerodWhirlwind01.ogg"] = 01.45,
				},
				["HiddenMaster\\VO_"] = {
					["HIDDEN_MASTER_"] = {
						["EVENT_"] = {
							["A_"] = {
								["01.OGG"] = 07.11,
								["02.OGG"] = 02.89,
								["03.OGG"] = 10.24,
								["04.OGG"] = 02.14,
							},
							["B_"] = {
								["01.OGG"] = 05.25,
								["02.OGG"] = 02.42,
								["03.OGG"] = 02.84,
							},
							["C_"] = {
								["01.OGG"] = 06.07,
								["02.OGG"] = 03.11,
								["03.OGG"] = 06.86,
							},
							["D_"] = {
								["01.OGG"] = 01.65,
								["02.OGG"] = 09.42,
							},
						},
						["FAILURE_"] = {
							["01.OGG"] = 02.59,
							["02.OGG"] = 03.57,
							["03.OGG"] = 01.84,
							["04.OGG"] = 02.36,
							["05.OGG"] = 03.39,
							["06.OGG"] = 01.27,
							["07.OGG"] = 01.79,
							["08.OGG"] = 02.06,
						},
						["GREETING_"] = {
							["01.OGG"] = 00.79,
							["02.OGG"] = 01.06,
							["03.OGG"] = 01.23,
						},
						["SUCCESS_"] = {
							["01.OGG"] = 01.78,
							["02.OGG"] = 01.34,
							["03.OGG"] = 01.32,
							["04.OGG"] = 01.35,
							["05.OGG"] = 02.45,
							["06.OGG"] = 00.97,
						},
					},
				},
				["HideousAmalgamation\\MON_"] = {
					["HideousAmalgamation_"] = {
						["Aggro01.ogg"] = 02.45,
						["Aggro02.ogg"] = 02.75,
						["Attack01.ogg"] = 02.18,
						["Attack02.ogg"] = 02.11,
						["Attack03.ogg"] = 02.30,
						["Attack04.ogg"] = 02.42,
						["Attack05.ogg"] = 02.30,
						["Attack06.ogg"] = 02.05,
						["Attack07.ogg"] = 02.30,
						["AttackCrit01.ogg"] = 02.28,
						["AttackCrit02.ogg"] = 02.30,
						["AttackCrit03.ogg"] = 02.44,
						["Death01.ogg"] = 04.92,
						["Death02.ogg"] = 05.10,
						["Death03.ogg"] = 05.25,
						["PreAggro01.ogg"] = 01.79,
						["Wound01.ogg"] = 02.58,
						["Wound02.ogg"] = 02.18,
						["Wound03.ogg"] = 02.13,
						["Wound04.ogg"] = 02.22,
						["Wound05.ogg"] = 02.40,
						["Wound06.ogg"] = 02.69,
						["Wound07.ogg"] = 02.69,
						["WoundCrit01.ogg"] = 02.41,
						["WoundCrit02.ogg"] = 02.34,
						["WoundCrit03.ogg"] = 02.52,
					},
				},
				["HighArakkoa\\Mon_"] = {
					["WOD_High_"] = {
						["Arakkoa_"] = {
							["Aggro_"] = {
								["01.ogg"] = 01.41,
								["02.ogg"] = 01.42,
								["03.ogg"] = 01.33,
								["04.ogg"] = 01.66,
								["05.ogg"] = 01.66,
							},
							["AttackCrit_"] = {
								["01.ogg"] = 01.28,
								["02.ogg"] = 01.32,
							},
							["BattleRoar_"] = {
								["01.ogg"] = 02.08,
								["02.ogg"] = 02.09,
								["03.ogg"] = 02.01,
								["04.ogg"] = 02.08,
								["05.ogg"] = 02.05,
							},
							["Death_"] = {
								["01.ogg"] = 02.04,
								["02.ogg"] = 01.98,
								["03.ogg"] = 02.82,
								["04.ogg"] = 02.33,
								["05.ogg"] = 02.02,
								["06.ogg"] = 02.17,
								["07.ogg"] = 02.25,
							},
							["preAggro_"] = {
								["01.ogg"] = 01.07,
								["02.ogg"] = 01.35,
								["03.ogg"] = 01.30,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.04,
								["02.ogg"] = 00.86,
								["03.ogg"] = 00.97,
								["04.ogg"] = 01.13,
								["05.ogg"] = 01.25,
							},
							["Wound_"] = {
								["01.ogg"] = 01.34,
								["02.ogg"] = 01.15,
								["03.ogg"] = 00.89,
								["04.ogg"] = 01.07,
								["05.ogg"] = 00.97,
								["06.ogg"] = 00.87,
								["07.ogg"] = 00.85,
								["08.ogg"] = 01.11,
								["09.ogg"] = 00.97,
								["10.ogg"] = 01.15,
							},
							["Attack01.ogg"] = 01.67,
							["Attack02.ogg"] = 01.48,
							["Attack03.ogg"] = 01.73,
							["Attack04.ogg"] = 01.49,
							["Attack05.ogg"] = 01.54,
							["Attack06.ogg"] = 01.25,
							["Attack07.ogg"] = 01.32,
							["Attack08.ogg"] = 01.13,
							["Attack09.ogg"] = 01.01,
							["Attack10.ogg"] = 01.16,
						},
					},
				},
				["HighAstromancerSolarian\\TEMPEST_"] = {
					["HighAstro_"] = {
						["Aggro01.ogg"] = 03.94,
						["Attack01.ogg"] = 01.31,
						["Attack02.ogg"] = 01.34,
						["Attack03.ogg"] = 01.44,
						["Attack04.ogg"] = 01.67,
						["Attack05.ogg"] = 01.74,
						["Attack06.ogg"] = 02.00,
						["Attack07.ogg"] = 01.89,
						["Death01.ogg"] = 04.03,
						["Slay01.ogg"] = 03.52,
						["Slay02.ogg"] = 03.21,
						["Slay03.ogg"] = 02.62,
						["Summon01.ogg"] = 04.08,
						["Summon02.ogg"] = 04.34,
						["Wound01.ogg"] = 00.84,
						["Wound02.ogg"] = 01.20,
						["Wound03.ogg"] = 01.47,
						["Wound04.ogg"] = 01.57,
						["Wound05.ogg"] = 01.61,
						["Wound06.ogg"] = 01.61,
						["WoundCrit01.ogg"] = 01.54,
						["WoundCrit02.ogg"] = 01.69,
						["WoundCrit03.ogg"] = 01.94,
					},
				},
				["HighBontanistFreywinn\\TEMPEST_"] = {
					["Freywinn_"] = {
						["Aggro01.ogg"] = 05.02,
						["Attack01.ogg"] = 02.28,
						["Attack02.ogg"] = 01.98,
						["Attack03.ogg"] = 02.18,
						["Attack04.ogg"] = 01.78,
						["Attack05.ogg"] = 01.73,
						["Attack06.ogg"] = 02.23,
						["Death01.ogg"] = 04.98,
						["Slay01.ogg"] = 04.13,
						["Slay02.ogg"] = 03.31,
						["Tree01.ogg"] = 03.52,
						["Tree02.ogg"] = 04.01,
						["Wound01.ogg"] = 01.57,
						["Wound02.ogg"] = 01.89,
						["Wound03.ogg"] = 01.81,
						["Wound04.ogg"] = 01.72,
						["Wound05.ogg"] = 01.91,
					},
				},
				["HighBorneMage01\\VO_"] = {
					["WOE_HIGHBORNE01_"] = {
						["EVENT_"] = {
							["01.OGG"] = 04.60,
							["02.OGG"] = 04.50,
							["03.OGG"] = 06.01,
						},
						["Attack01.OGG"] = 00.56,
						["Attack02.OGG"] = 00.39,
						["Attack03.OGG"] = 00.48,
						["Attack04.OGG"] = 00.47,
						["Attack05.OGG"] = 00.49,
						["Attack06.OGG"] = 00.59,
						["Attack07.OGG"] = 00.53,
						["Attack08.OGG"] = 00.52,
						["AttackCrit01.OGG"] = 01.68,
						["AttackCrit02.OGG"] = 01.65,
						["AttackCrit03.OGG"] = 01.95,
						["AttackCrit04.OGG"] = 01.65,
						["AttackCrit05.OGG"] = 01.73,
						["Death01.OGG"] = 01.70,
						["Death02.OGG"] = 01.61,
						["Death03.OGG"] = 01.41,
						["Death04.OGG"] = 01.14,
						["Death05.OGG"] = 01.43,
						["Wound01.OGG"] = 00.42,
						["Wound02.OGG"] = 00.50,
						["Wound03.OGG"] = 00.42,
						["Wound04.OGG"] = 00.38,
						["Wound05.OGG"] = 00.46,
						["Wound06.OGG"] = 00.60,
						["Wound07.OGG"] = 00.94,
						["Wound08.OGG"] = 00.64,
						["Wound09.OGG"] = 00.61,
						["Wound10.OGG"] = 00.57,
						["WoundCrit01.OGG"] = 01.42,
						["WoundCrit02.OGG"] = 00.76,
						["WoundCrit03.OGG"] = 01.05,
						["WoundCrit04.OGG"] = 00.86,
						["WoundCrit05.OGG"] = 01.51,
					},
				},
				["HighBorneMage02\\VO_"] = {
					["WOE_HIGHBORNE02_"] = {
						["EVENT_"] = {
							["01.OGG"] = 05.06,
							["02.OGG"] = 03.42,
							["03.OGG"] = 05.49,
						},
						["Attack01.OGG"] = 00.25,
						["Attack02.OGG"] = 00.23,
						["Attack03.OGG"] = 00.32,
						["Attack04.OGG"] = 00.29,
						["Attack05.OGG"] = 00.47,
						["Attack06.OGG"] = 00.44,
						["Attack07.OGG"] = 00.46,
						["Attack08.OGG"] = 00.48,
						["Attack09.OGG"] = 00.51,
						["Attack10.OGG"] = 00.67,
						["AttackCrit01.OGG"] = 01.22,
						["AttackCrit02.OGG"] = 01.61,
						["AttackCrit03.OGG"] = 01.35,
						["AttackCrit04.OGG"] = 01.22,
						["AttackCrit05.OGG"] = 01.28,
						["Death01.OGG"] = 01.40,
						["Death02.OGG"] = 01.72,
						["Death03.OGG"] = 01.80,
						["Death04.OGG"] = 01.78,
						["Death05.OGG"] = 01.73,
						["Wound01.OGG"] = 00.53,
						["Wound02.OGG"] = 00.41,
						["Wound03.OGG"] = 00.42,
						["Wound04.OGG"] = 00.64,
						["Wound05.OGG"] = 00.48,
						["Wound06.OGG"] = 00.49,
						["Wound07.OGG"] = 00.81,
						["Wound08.OGG"] = 01.00,
						["Wound09.OGG"] = 00.60,
						["Wound10.OGG"] = 00.84,
						["WoundCrit01.OGG"] = 01.25,
						["WoundCrit02.OGG"] = 00.88,
						["WoundCrit03.OGG"] = 01.44,
						["WoundCrit04.OGG"] = 01.07,
						["WoundCrit05.OGG"] = 01.22,
					},
				},
				["HighBorneMage03\\VO_"] = {
					["WOE_HIGHBORNE03_"] = {
						["EVENT_"] = {
							["01.OGG"] = 04.00,
							["02.OGG"] = 03.47,
							["03.OGG"] = 04.41,
						},
						["Attack01.OGG"] = 00.33,
						["Attack02.OGG"] = 00.55,
						["Attack03.OGG"] = 00.50,
						["Attack04.OGG"] = 00.70,
						["Attack05.OGG"] = 00.28,
						["Attack06.OGG"] = 00.50,
						["Attack07.OGG"] = 00.80,
						["Attack08.OGG"] = 00.92,
						["Attack09.OGG"] = 01.03,
						["Attack10.OGG"] = 00.78,
						["AttackCrit01.OGG"] = 01.34,
						["AttackCrit02.OGG"] = 01.41,
						["AttackCrit03.OGG"] = 01.85,
						["AttackCrit04.OGG"] = 01.50,
						["AttackCrit05.OGG"] = 01.79,
						["Death01.OGG"] = 01.70,
						["Death02.OGG"] = 02.44,
						["Death03.OGG"] = 01.92,
						["Death04.OGG"] = 01.93,
						["Death05.OGG"] = 01.76,
						["Wound01.OGG"] = 00.35,
						["Wound02.OGG"] = 00.47,
						["Wound03.OGG"] = 00.44,
						["Wound04.OGG"] = 00.40,
						["Wound05.OGG"] = 00.58,
						["Wound06.OGG"] = 00.53,
						["Wound07.OGG"] = 00.59,
						["Wound08.OGG"] = 00.87,
						["Wound09.OGG"] = 00.35,
						["Wound10.OGG"] = 00.34,
						["WoundCrit01.OGG"] = 00.80,
						["WoundCrit02.OGG"] = 00.79,
						["WoundCrit03.OGG"] = 00.98,
						["WoundCrit04.OGG"] = 00.80,
						["WoundCrit05.OGG"] = 00.79,
					},
				},
				["HighGeneralAbbendis\\PE_"] = {
					["Abbendis_"] = {
						["50Health.ogg"] = 04.39,
						["Attack01.ogg"] = 00.73,
						["Attack02.ogg"] = 00.85,
						["Attack03.ogg"] = 01.03,
						["Attack04.ogg"] = 00.97,
						["Wound01.ogg"] = 00.46,
						["Wound02.ogg"] = 00.42,
						["Wound03.ogg"] = 00.54,
						["Wound04.ogg"] = 00.63,
						["Wound05.ogg"] = 00.45,
						["WoundCrit01.ogg"] = 01.20,
						["WoundCrit02.ogg"] = 01.31,
						["WoundCrit03.ogg"] = 01.54,
						["WoundCrit04.ogg"] = 01.37,
						["Yell01.ogg"] = 03.32,
						["Yell02.ogg"] = 03.92,
						["Yell03.ogg"] = 03.84,
						["Yell04.ogg"] = 03.62,
					},
				},
				["HighInquisitorWhitemane\\"] = {
					["HighInquisitorWhitemaneRes01.ogg"] = 01.91,
					["HighInquisitorWhitemaneSlay01.ogg"] = 01.86,
					["HighInquisitorWhitemaneSpawn01.ogg"] = 04.37,
				},
				["HighKingMaulgar\\GRULLAIR_"] = {
					["Maul_"] = {
						["Aggro01.ogg"] = 05.24,
						["Attack01.ogg"] = 01.96,
						["Attack02.ogg"] = 01.93,
						["Attack03.ogg"] = 02.14,
						["Attack04.ogg"] = 02.18,
						["Attack05.ogg"] = 02.37,
						["Death01.ogg"] = 05.10,
						["Enrage01.ogg"] = 05.14,
						["OgrDeth01.ogg"] = 04.27,
						["OgrDeth02.ogg"] = 04.05,
						["OgrDeth03.ogg"] = 03.30,
						["OgrDeth04.ogg"] = 03.42,
						["Slay01.ogg"] = 03.64,
						["Slay02.ogg"] = 03.49,
						["Slay03.ogg"] = 03.38,
						["Wound01.ogg"] = 02.07,
						["Wound02.ogg"] = 01.99,
						["Wound03.ogg"] = 01.97,
						["Wound04.ogg"] = 02.13,
						["WoundCrit01.ogg"] = 01.96,
						["WoundCrit02.ogg"] = 02.11,
						["WoundCrit03.ogg"] = 02.18,
						["WoundCrit04.ogg"] = 02.32,
					},
				},
				["HighlordMograine\\MOG_"] = {
					["NAXX_"] = {
						["AGGRO01.ogg"] = 01.44,
						["AGGRO02.ogg"] = 02.04,
						["AGGRO03.ogg"] = 00.93,
						["DEATH.ogg"] = 12.47,
						["SLAY01.ogg"] = 03.16,
						["SLAY02.ogg"] = 02.35,
						["SPECIAL.ogg"] = 02.72,
						["TAUNT01.ogg"] = 06.42,
						["TAUNT02.ogg"] = 09.18,
						["TAUNT03.ogg"] = 06.48,
					},
				},
				["HighmaulSorcKing\\VO_"] = {
					["60_"] = {
						["HMR_SORCKING_"] = {
							["EVENT_"] = {
								["01.OGG"] = 07.46,
								["02.OGG"] = 08.68,
								["03.OGG"] = 07.19,
								["04.OGG"] = 05.19,
								["05.OGG"] = 05.38,
								["06.OGG"] = 07.99,
								["07.OGG"] = 08.73,
								["08.OGG"] = 02.98,
								["09.OGG"] = 06.41,
								["10.OGG"] = 08.21,
								["11.OGG"] = 06.73,
								["12.ogg"] = 10.60,
								["13.ogg"] = 13.31,
								["14.ogg"] = 01.54,
								["15.ogg"] = 01.40,
								["16.ogg"] = 01.76,
								["17.ogg"] = 05.89,
								["18.ogg"] = 05.71,
								["19.ogg"] = 02.59,
								["20.ogg"] = 03.33,
								["21.ogg"] = 03.58,
								["22.ogg"] = 04.48,
								["23.ogg"] = 02.83,
								["24.ogg"] = 06.12,
								["25.ogg"] = 04.29,
							},
							["AGGRO.OGG"] = 06.51,
							["BERSERK.OGG"] = 02.76,
							["DEATH.OGG"] = 04.48,
							["INTRO.OGG"] = 14.18,
							["KARGATH1.ogg"] = 02.83,
							["KILL1.OGG"] = 02.72,
							["KILL2.OGG"] = 02.41,
							["KILL3.OGG"] = 02.62,
							["SPELL1.OGG"] = 02.44,
							["SPELL2.OGG"] = 02.41,
							["SPELL3.OGG"] = 04.54,
							["SPELL4.OGG"] = 02.98,
							["SPELL5.OGG"] = 01.71,
							["SPELL6.OGG"] = 02.87,
						},
						["SORCKING_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.73,
								["02.OGG"] = 02.00,
								["03.OGG"] = 02.04,
								["04.OGG"] = 01.40,
								["05.OGG"] = 01.18,
							},
							["Attack_"] = {
								["01.OGG"] = 00.59,
								["010.OGG"] = 00.55,
								["02.OGG"] = 00.55,
								["03.OGG"] = 00.52,
								["04.OGG"] = 00.63,
								["05.OGG"] = 00.64,
								["06.OGG"] = 00.66,
								["07.OGG"] = 00.46,
								["08.OGG"] = 00.46,
								["09.OGG"] = 00.56,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 02.30,
								["02.OGG"] = 01.82,
								["03.OGG"] = 02.50,
								["04.OGG"] = 01.60,
								["05.OGG"] = 01.87,
							},
							["Wound_"] = {
								["01.OGG"] = 00.57,
								["02.OGG"] = 00.76,
								["03.OGG"] = 00.57,
								["04.OGG"] = 00.54,
								["05.OGG"] = 00.53,
								["06.OGG"] = 00.60,
								["07.OGG"] = 00.76,
								["08.OGG"] = 00.64,
								["09.OGG"] = 00.57,
							},
						},
					},
				},
				["HighNethermancerZerevor\\BLCKTMPLE_"] = {
					["HiNethZer_"] = {
						["Attack01.ogg"] = 00.62,
						["Attack02.ogg"] = 00.47,
						["Attack03.ogg"] = 00.67,
						["Attack04.ogg"] = 00.76,
						["Attack05.ogg"] = 00.66,
						["Attack06.ogg"] = 00.87,
						["Attack07.ogg"] = 00.76,
						["Death01.ogg"] = 03.14,
						["Enrage01.ogg"] = 02.72,
						["Intro01.ogg"] = 05.81,
						["KillCmnt01.ogg"] = 02.08,
						["Slay01.ogg"] = 02.08,
						["Special01.ogg"] = 02.22,
						["Special02.ogg"] = 02.94,
						["Wound01.ogg"] = 00.29,
						["Wound02.ogg"] = 00.39,
						["Wound03.ogg"] = 00.45,
						["Wound04.ogg"] = 00.51,
						["Wound05.ogg"] = 00.60,
						["Wound06.ogg"] = 00.69,
						["Wound07.ogg"] = 00.73,
						["WoundCrit01.ogg"] = 00.79,
						["WoundCrit02.ogg"] = 01.07,
						["WoundCrit03.ogg"] = 00.93,
					},
				},
				["HighOverlordSaurfang\\"] = {
					["IC_Saurfang_"] = {
						["Attack01.ogg"] = 00.58,
						["Attack02.ogg"] = 00.66,
						["Attack03.ogg"] = 00.85,
						["Attack04.ogg"] = 01.15,
						["Attack05.ogg"] = 00.38,
						["Attack06.ogg"] = 00.51,
						["Attack07.ogg"] = 00.36,
						["Attack08.ogg"] = 00.82,
						["Board01.ogg"] = 05.49,
						["EndAll01.ogg"] = 06.90,
						["EndAll02.ogg"] = 07.29,
						["EndAll03.ogg"] = 04.02,
						["EndHor01.ogg"] = 06.62,
						["EndHor02.ogg"] = 14.16,
						["EndHor03.ogg"] = 13.51,
						["EndHor04.ogg"] = 03.30,
						["EndHor05.ogg"] = 09.40,
						["EndHor06.ogg"] = 07.01,
						["EndHor07.ogg"] = 05.22,
						["EndHor09.ogg"] = 01.93,
						["EndHor10.ogg"] = 05.96,
						["EndHor8.ogg"] = 02.46,
						["Freeze01.ogg"] = 04.42,
						["Intro01.ogg"] = 06.50,
						["Intro02.ogg"] = 09.68,
						["Intro03.ogg"] = 09.60,
						["Intro04.ogg"] = 10.92,
						["Order01.ogg"] = 02.33,
						["Order02.ogg"] = 01.80,
						["Order03.ogg"] = 02.70,
						["Ship01.ogg"] = 09.65,
						["Ship02.ogg"] = 01.61,
						["Ship03.ogg"] = 03.08,
						["Ship04.ogg"] = 03.12,
						["Ship05.ogg"] = 03.08,
						["Ship06.ogg"] = 04.76,
						["Ship07.ogg"] = 06.31,
						["VictoryAll01.ogg"] = 05.78,
						["VictoryHor01.ogg"] = 04.13,
						["Wipe01.ogg"] = 01.67,
						["Wound01.ogg"] = 00.48,
						["Wound02.ogg"] = 00.48,
						["Wound03.ogg"] = 00.61,
						["Wound04.ogg"] = 00.56,
						["Wound05.ogg"] = 00.50,
						["Wound06.ogg"] = 00.55,
						["Wound07.ogg"] = 00.75,
						["Wound08.ogg"] = 00.68,
						["Wound09.ogg"] = 00.78,
						["WoundCrit01.ogg"] = 00.60,
						["WoundCrit02.ogg"] = 00.68,
						["WoundCrit03.ogg"] = 00.65,
						["WoundCrit04.ogg"] = 00.70,
					},
					["VO_54_"] = {
						["OR_SAURFANG_"] = {
							["INTRO_"] = {
								["1.OGG"] = 05.98,
								["2.OGG"] = 07.74,
								["3.OGG"] = 05.36,
								["4.OGG"] = 09.60,
								["5.OGG"] = 13.66,
								["6.OGG"] = 05.66,
								["7.OGG"] = 06.17,
							},
						},
					},
				},
				["HIGHTINKERMEKKATORQUE\\"] = {
					["HighTinkerMekkatorqueAggro01.ogg"] = 02.10,
					["HighTinkerMekkatorqueGreeting01.ogg"] = 02.83,
					["HighTinkerMekkatorqueGreeting02.ogg"] = 03.10,
					["HighTinkerMekkatorqueGreeting03.ogg"] = 02.91,
					["HighTinkerMekkatorqueGreeting04.ogg"] = 01.17,
					["HighTinkerMekkatorqueSlay01.ogg"] = 02.59,
				},
				["HighWarlordNajentus\\BLCKTMPLE_"] = {
					["HighWar_"] = {
						["Aggro01.ogg"] = 05.71,
						["Attack01.ogg"] = 00.59,
						["Attack02.ogg"] = 00.48,
						["Attack03.ogg"] = 00.82,
						["Attack04.ogg"] = 00.50,
						["Death01.ogg"] = 05.60,
						["Enrag01.ogg"] = 04.49,
						["Enrag02.ogg"] = 06.08,
						["Impale01.ogg"] = 03.38,
						["Impale02.ogg"] = 03.45,
						["Slay01.ogg"] = 05.14,
						["Slay02.ogg"] = 04.14,
						["Special01.ogg"] = 04.03,
						["Special02.ogg"] = 04.30,
						["Wound01.ogg"] = 00.33,
						["Wound02.ogg"] = 00.34,
						["Wound03.ogg"] = 00.40,
						["WoundCrit01.ogg"] = 00.35,
						["WoundCrit02.ogg"] = 00.55,
						["WoundCrit03.ogg"] = 00.68,
					},
				},
				["HildaHornswaggle\\VO_"] = {
					["5.1_PROG_"] = {
						["Hilda_"] = {
							["Land_"] = {
								["01.OGG"] = 03.91,
								["02.OGG"] = 05.35,
								["03.OGG"] = 01.07,
							},
							["Reunion_"] = {
								["01.OGG"] = 07.86,
								["02.OGG"] = 02.11,
							},
							["Survey_"] = {
								["01.OGG"] = 01.87,
								["02.OGG"] = 03.82,
								["03.OGG"] = 05.68,
								["04.OGG"] = 09.83,
							},
						},
					},
				},
				["Hippo\\Mon_"] = {
					["WOD_Hippo_"] = {
						["Chuff_"] = {
							["01.OGG"] = 00.73,
							["02.OGG"] = 00.72,
							["03.OGG"] = 00.69,
							["04.OGG"] = 00.55,
							["05.OGG"] = 00.59,
							["06.OGG"] = 00.84,
							["07.OGG"] = 00.52,
						},
						["Aggro01.OGG"] = 01.71,
						["Aggro02.OGG"] = 01.26,
						["Aggro03.OGG"] = 01.30,
						["Aggro04.OGG"] = 02.14,
						["Aggro05.OGG"] = 01.15,
						["Attack01.OGG"] = 01.78,
						["Attack02.OGG"] = 01.96,
						["Attack03.OGG"] = 02.13,
						["Attack04.OGG"] = 02.21,
						["Attack05.OGG"] = 01.96,
						["Attack06.OGG"] = 01.65,
						["CustomSpell01.OGG"] = 08.04,
						["CustomSpell02.OGG"] = 07.76,
						["CustomSpell03.OGG"] = 08.00,
						["Death01.OGG"] = 07.90,
						["Death02.OGG"] = 08.43,
						["Death03.OGG"] = 07.94,
						["Death04.OGG"] = 07.91,
						["Death05.OGG"] = 07.85,
						["PreAggro01.OGG"] = 00.67,
						["PreAggro02.OGG"] = 00.70,
						["PreAggro03.OGG"] = 01.89,
						["PreAggro04.OGG"] = 01.27,
						["PreAggro05.OGG"] = 01.48,
						["Wound01.OGG"] = 01.09,
						["Wound02.OGG"] = 01.12,
						["Wound03.OGG"] = 01.18,
						["Wound04.OGG"] = 01.06,
						["Wound05.OGG"] = 01.17,
						["Wound06.OGG"] = 00.71,
						["Wound07.OGG"] = 00.65,
						["Wound08.OGG"] = 01.04,
					},
				},
				["Hippogryph\\"] = {
					["mHippogryphAggroA.ogg"] = 01.71,
					["mHippogryphAttackA.ogg"] = 01.76,
					["mHippogryphAttackB.ogg"] = 01.83,
					["mHippogryphAttackC.ogg"] = 01.65,
					["mHippogryphAttackD.ogg"] = 01.51,
					["mHippogryphDeathA.ogg"] = 02.30,
					["mHippogryphStand2A.ogg"] = 01.30,
					["mHippogryphWoundA.ogg"] = 00.88,
					["mHippogryphWoundB.ogg"] = 01.01,
					["mHippogryphWoundC.ogg"] = 00.99,
					["mHippogryphWoundCriticalA.ogg"] = 01.23,
				},
				["Hisek\\VO_"] = {
					["54_"] = {
						["HISEK_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.99,
								["02.OGG"] = 01.10,
								["03.OGG"] = 01.45,
								["04.OGG"] = 01.32,
								["05.OGG"] = 01.42,
							},
							["Attack_"] = {
								["01.OGG"] = 00.51,
								["02.OGG"] = 00.72,
								["03.OGG"] = 00.62,
								["04.OGG"] = 00.74,
								["05.OGG"] = 00.70,
								["06.OGG"] = 00.88,
								["07.OGG"] = 00.56,
								["08.OGG"] = 00.57,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 02.16,
								["02.OGG"] = 02.27,
								["03.OGG"] = 02.10,
								["04.OGG"] = 01.83,
								["05.OGG"] = 01.24,
							},
							["Wound_"] = {
								["01.OGG"] = 01.08,
								["02.OGG"] = 00.90,
								["03.OGG"] = 00.63,
								["04.OGG"] = 00.68,
								["05.OGG"] = 00.63,
								["06.OGG"] = 00.53,
								["07.OGG"] = 00.85,
							},
						},
						["OR_HISEK_"] = {
							["SPELL_"] = {
								["1.OGG"] = 04.46,
								["2.OGG"] = 05.75,
							},
							["AGGRO.OGG"] = 03.22,
							["DEATH.OGG"] = 08.18,
							["EVENT.OGG"] = 07.89,
							["INTRO.OGG"] = 05.53,
							["KILL.OGG"] = 03.92,
						},
					},
				},
				["Hobgoblin\\Hobgoblin_"] = {
					["Aggro_"] = {
						["01.ogg"] = 01.02,
						["02.ogg"] = 01.09,
						["03.ogg"] = 01.24,
						["04.ogg"] = 01.21,
						["05.ogg"] = 01.13,
						["06.ogg"] = 01.04,
						["07.ogg"] = 01.25,
						["08.ogg"] = 01.28,
						["09.ogg"] = 01.93,
						["10.ogg"] = 01.73,
					},
					["AttackCrit_"] = {
						["01.ogg"] = 02.00,
						["02.ogg"] = 02.07,
						["03.ogg"] = 01.92,
						["04.ogg"] = 01.88,
						["05.ogg"] = 02.01,
						["06.ogg"] = 02.00,
						["07.ogg"] = 01.94,
					},
					["Attack_"] = {
						["01.ogg"] = 01.49,
						["02.ogg"] = 01.70,
						["03.ogg"] = 01.76,
						["04.ogg"] = 01.59,
						["05.ogg"] = 01.69,
						["06.ogg"] = 01.64,
						["07.ogg"] = 01.82,
						["08.ogg"] = 01.54,
						["09.ogg"] = 01.66,
						["10.ogg"] = 02.00,
					},
					["Death_"] = {
						["01.ogg"] = 03.40,
						["02.ogg"] = 03.83,
						["03.ogg"] = 03.63,
						["04.ogg"] = 03.62,
						["05.ogg"] = 05.05,
					},
					["PreAggro_"] = {
						["01.ogg"] = 01.09,
						["02.ogg"] = 01.29,
						["03.ogg"] = 00.97,
						["04.ogg"] = 03.03,
						["05.ogg"] = 01.08,
						["06.ogg"] = 01.10,
					},
					["WoundCrit_"] = {
						["01.ogg"] = 01.50,
						["02.ogg"] = 01.47,
						["03.ogg"] = 01.49,
						["04.ogg"] = 01.66,
					},
					["Wound_"] = {
						["01.ogg"] = 00.89,
						["02.ogg"] = 01.06,
						["03.ogg"] = 00.90,
						["04.ogg"] = 00.73,
						["05.ogg"] = 00.83,
						["06.ogg"] = 00.85,
						["07.ogg"] = 00.93,
						["08.ogg"] = 01.14,
						["09.ogg"] = 01.29,
					},
				},
				["Hodir\\UR_"] = {
					["Hodir_"] = {
						["Aggro01.ogg"] = 04.53,
						["Attack01.ogg"] = 00.56,
						["Attack02.ogg"] = 00.89,
						["Attack03.ogg"] = 01.02,
						["Attack04.ogg"] = 00.81,
						["Attack05.ogg"] = 00.93,
						["Attack06.ogg"] = 01.21,
						["Attack07.ogg"] = 01.68,
						["Berserk01.ogg"] = 04.38,
						["Death01.ogg"] = 09.12,
						["FlashFreeze01.ogg"] = 03.67,
						["Slay01.ogg"] = 06.08,
						["Slay02.ogg"] = 04.43,
						["Stalactite01.ogg"] = 04.48,
						["Wound01.ogg"] = 00.98,
						["Wound02.ogg"] = 00.81,
						["Wound03.ogg"] = 00.92,
						["Wound04.ogg"] = 00.98,
						["Wound05.ogg"] = 01.02,
						["Wound06.ogg"] = 01.00,
						["Wound07.ogg"] = 01.25,
						["Wound08.ogg"] = 01.16,
						["WoundCrit01.ogg"] = 01.52,
						["WoundCrit02.ogg"] = 01.89,
						["WoundCrit03.ogg"] = 01.70,
						["WoundCrit04.ogg"] = 01.88,
						["YSHelp01.ogg"] = 04.00,
					},
				},
				["HoodWolf\\"] = {
					["HoodWolfAttacks01.ogg"] = 01.20,
					["HoodWolfAttacks02.ogg"] = 01.36,
					["HoodWolfAttacks03.ogg"] = 01.26,
					["HoodWolfAttacks04.ogg"] = 01.14,
					["HoodWolfDies01.ogg"] = 05.74,
					["HoodWolfDies01a.ogg"] = 03.58,
					["HoodWolfEnters01.ogg"] = 06.00,
					["HoodWolfSlay01.ogg"] = 05.53,
					["HoodWolfTransformPlayer01.ogg"] = 05.49,
					["HoodWolfWound01.ogg"] = 01.03,
					["HoodWolfWound02.ogg"] = 01.39,
					["HoodWolfWound03.ogg"] = 01.45,
					["HoodWolfWoundCrit01.ogg"] = 01.65,
					["HoodWolfWoundCrit02.ogg"] = 01.51,
					["HoodWolfWoundCrit03.ogg"] = 01.73,
				},
				["HOPPINGGHOST\\MON_"] = {
					["HoppingGhost_"] = {
						["Aggro_"] = {
							["01.OGG"] = 01.91,
							["02.OGG"] = 01.60,
							["03.OGG"] = 01.52,
							["04.OGG"] = 01.79,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 01.68,
							["02.OGG"] = 01.85,
							["03.OGG"] = 02.06,
							["04.OGG"] = 01.88,
							["05.OGG"] = 01.93,
						},
						["Attack_"] = {
							["01.OGG"] = 01.45,
							["02.OGG"] = 01.65,
							["03.OGG"] = 01.78,
							["04.OGG"] = 01.55,
							["05.OGG"] = 01.63,
							["06.OGG"] = 01.59,
							["07.OGG"] = 01.64,
							["08.OGG"] = 01.68,
							["09.OGG"] = 01.61,
							["10.OGG"] = 01.83,
						},
						["Death_"] = {
							["01.OGG"] = 04.25,
							["02.OGG"] = 04.25,
							["03.OGG"] = 04.35,
							["04.OGG"] = 04.57,
							["05.OGG"] = 03.92,
						},
						["PreAggro_"] = {
							["01.OGG"] = 01.92,
							["02.OGG"] = 02.46,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.88,
							["02.OGG"] = 01.54,
							["03.OGG"] = 02.24,
							["04.OGG"] = 01.96,
							["05.OGG"] = 01.91,
						},
						["Wound_"] = {
							["01.OGG"] = 01.55,
							["02.OGG"] = 01.63,
							["03.OGG"] = 01.56,
							["04.OGG"] = 01.58,
							["05.OGG"] = 01.64,
							["06.OGG"] = 01.59,
							["07.OGG"] = 01.60,
							["08.OGG"] = 01.66,
							["09.OGG"] = 01.69,
						},
					},
					["Hopping_Ghost_Creature_loop.OGG"] = 09.08,
				},
				["HordeCaravan\\HordeCaravan_"] = {
					["Chains_LP_"] = {
						["01.ogg"] = 05.30,
						["02.ogg"] = 05.34,
					},
					["IdleOS_"] = {
						["01.ogg"] = 01.31,
						["02.ogg"] = 02.34,
						["03.ogg"] = 02.10,
						["04.ogg"] = 02.19,
						["05.ogg"] = 03.00,
					},
					["Start_OS_"] = {
						["01.ogg"] = 02.88,
						["02.ogg"] = 02.99,
					},
					["Stone_LP_01.ogg"] = 05.82,
					["Wood_LP_01.ogg"] = 07.02,
				},
				["HordePeon\\VO_"] = {
					["60_"] = {
						["GAR_HORDE_"] = {
							["PEON_"] = {
								["01.ogg"] = 00.91,
								["02.ogg"] = 01.12,
								["03.ogg"] = 01.72,
								["04.ogg"] = 01.16,
							},
						},
						["Peon_"] = {
							["AttackCrit_"] = {
								["01.ogg"] = 02.14,
								["02.ogg"] = 01.91,
								["03.ogg"] = 02.31,
								["04.ogg"] = 02.54,
								["05.ogg"] = 01.21,
							},
							["Attack_"] = {
								["01.ogg"] = 00.49,
								["010.ogg"] = 00.46,
								["02.ogg"] = 00.49,
								["03.ogg"] = 00.43,
								["04.ogg"] = 00.52,
								["05.ogg"] = 00.63,
								["06.ogg"] = 00.40,
								["07.ogg"] = 00.69,
								["08.ogg"] = 00.38,
								["09.ogg"] = 00.39,
							},
							["Death_"] = {
								["01.ogg"] = 02.20,
								["02.ogg"] = 02.55,
								["03.ogg"] = 02.23,
								["04.ogg"] = 01.10,
								["05.ogg"] = 01.35,
							},
							["WoundCrit_"] = {
								["01.ogg"] = 01.30,
								["02.ogg"] = 01.60,
								["03.ogg"] = 01.86,
								["04.ogg"] = 01.99,
								["05.ogg"] = 01.79,
							},
							["Wound_"] = {
								["01.ogg"] = 00.88,
								["02.ogg"] = 00.82,
								["03.ogg"] = 00.91,
								["04.ogg"] = 00.78,
								["05.ogg"] = 01.03,
								["06.ogg"] = 00.94,
								["07.ogg"] = 00.88,
								["08.ogg"] = 01.00,
							},
						},
					},
				},
				["Horisath\\"] = {
					["HorisathAggro.ogg"] = 02.35,
					["HorisathAttack1.ogg"] = 01.58,
					["HorisathAttack2.ogg"] = 01.47,
					["HorisathAttack3.ogg"] = 01.58,
					["HorisathDeath.ogg"] = 03.95,
					["HorisathWound1.ogg"] = 01.53,
					["HorisathWound2.ogg"] = 01.32,
					["HorisathWound3.ogg"] = 01.77,
					["HorisathWoundCrit.ogg"] = 01.73,
				},
				["Horse\\"] = {
					["mFootStepsHorseDirt01.ogg"] = 00.22,
					["mFootStepsHorseDirt02.ogg"] = 00.21,
					["mFootStepsHorseDirt03.ogg"] = 00.23,
					["mFootStepsHorseDirt04.ogg"] = 00.23,
					["mFootStepsHorseDirt05.ogg"] = 00.23,
					["mFootStepsHorseGrass01.ogg"] = 00.31,
					["mFootStepsHorseGrass02.ogg"] = 00.28,
					["mFootStepsHorseGrass03.ogg"] = 00.30,
					["mFootStepsHorseGrass04.ogg"] = 00.28,
					["mFootStepsHorseGrass05.ogg"] = 00.34,
					["mFootstepsHorseSnow01.ogg"] = 00.29,
					["mFootstepsHorseSnow02.ogg"] = 00.27,
					["mFootstepsHorseSnow03.ogg"] = 00.33,
					["mFootstepsHorseSnow04.ogg"] = 00.42,
					["mFootstepsHorseSnow05.ogg"] = 00.39,
					["mFootStepsHorseStone01.ogg"] = 00.15,
					["mFootStepsHorseStone02.ogg"] = 00.28,
					["mFootStepsHorseStone03.ogg"] = 00.19,
					["mFootStepsHorseStone04.ogg"] = 00.27,
					["mFootStepsHorseStone05.ogg"] = 00.15,
					["mFootStepsHorseWood01.ogg"] = 00.19,
					["mFootStepsHorseWood02.ogg"] = 00.30,
					["mFootStepsHorseWood03.ogg"] = 00.23,
					["mFootStepsHorseWood04.ogg"] = 00.19,
					["mFootStepsHorseWood05.ogg"] = 00.28,
					["mHorseAggroA.ogg"] = 01.65,
					["mHorseAttackA.ogg"] = 01.20,
					["mHorseAttackB.ogg"] = 01.33,
					["mHorseAttackC.ogg"] = 01.56,
					["mHorseDeathA.ogg"] = 02.91,
					["mHorseStand3A.ogg"] = 01.25,
					["mHorseWoundA.ogg"] = 01.52,
					["mHorseWoundB.ogg"] = 01.95,
					["mHorseWoundC.ogg"] = 01.33,
					["mHorseWoundCriticalA.ogg"] = 02.32,
				},
				["HorseUndead\\"] = {
					["HorseUndeadAggro.ogg"] = 01.24,
					["HorseUndeadAttackA.ogg"] = 01.54,
					["HorseUndeadAttackB.ogg"] = 01.57,
					["HorseUndeadAttackC.ogg"] = 01.70,
					["HorseUndeadDeath.ogg"] = 02.62,
					["HorseUndeadStand2A.ogg"] = 01.24,
					["HorseUndeadWoundA.ogg"] = 01.79,
					["HorseUndeadWoundB.ogg"] = 01.93,
					["HorseUndeadWoundC.ogg"] = 01.59,
					["HorseUndeadWoundCrit.ogg"] = 02.47,
				},
				["HounmasterBraun\\VO_"] = {
					["HOUNDMASTER_"] = {
						["ATTACKCRIT_"] = {
							["01.OGG"] = 01.00,
							["02.OGG"] = 02.09,
							["03.OGG"] = 01.52,
							["04.OGG"] = 01.35,
							["05.OGG"] = 02.49,
						},
						["attacks_"] = {
							["01.OGG"] = 00.65,
							["02.OGG"] = 01.38,
							["03.OGG"] = 01.13,
							["04.OGG"] = 00.55,
							["05.OGG"] = 00.52,
							["06.OGG"] = 01.25,
							["07.OGG"] = 00.33,
							["08.OGG"] = 00.55,
							["09.OGG"] = 00.59,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 01.37,
							["02.OGG"] = 01.61,
							["03.OGG"] = 01.38,
							["04.OGG"] = 00.75,
							["05.OGG"] = 00.80,
						},
						["WOUND_"] = {
							["01.OGG"] = 00.76,
							["02.OGG"] = 00.56,
							["03.OGG"] = 00.71,
							["04.OGG"] = 00.94,
							["05.OGG"] = 00.90,
							["06.OGG"] = 00.69,
							["07.OGG"] = 00.94,
							["08.OGG"] = 00.53,
							["09.OGG"] = 01.39,
						},
					},
					["SH_HOUNDMASTER_"] = {
						["AGGRO_"] = {
							["01.OGG"] = 01.95,
							["02.OGG"] = 02.41,
						},
						["ATTACK1_"] = {
							["01.OGG"] = 03.16,
							["02.OGG"] = 01.51,
						},
						["ATTACK2_"] = {
							["01.OGG"] = 02.73,
							["02.OGG"] = 02.90,
						},
						["DOGFAIL_"] = {
							["01.OGG"] = 02.88,
							["02.OGG"] = 04.99,
						},
						["END_"] = {
							["01.OGG"] = 06.11,
							["02.OGG"] = 05.39,
						},
						["EVENT_HOUNDDEATH_"] = {
							["01.OGG"] = 01.15,
							["02.OGG"] = 00.84,
							["03.OGG"] = 01.75,
						},
						["INTRO_"] = {
							["01.OGG"] = 02.29,
							["02.OGG"] = 03.22,
						},
						["RESET_01.OGG"] = 02.26,
						["SLAY_01.OGG"] = 01.78,
					},
				},
				["Hozen\\MON_"] = {
					["Hozen_Jungle_"] = {
						["Aggro_"] = {
							["01.OGG"] = 00.62,
							["02.OGG"] = 00.86,
							["03.OGG"] = 00.97,
							["04.OGG"] = 00.73,
							["05.OGG"] = 01.05,
							["06.OGG"] = 00.67,
							["07.OGG"] = 01.15,
							["08.OGG"] = 01.08,
						},
						["AttackCrit_"] = {
							["01.OGG"] = 00.89,
							["02.OGG"] = 00.85,
							["03.OGG"] = 01.01,
							["04.OGG"] = 00.93,
							["05.OGG"] = 00.84,
						},
						["Attack_"] = {
							["01.OGG"] = 00.53,
							["02.OGG"] = 00.40,
							["03.OGG"] = 00.64,
							["04.OGG"] = 00.86,
							["05.OGG"] = 00.94,
							["06.OGG"] = 00.64,
							["07.OGG"] = 00.85,
							["08.OGG"] = 00.97,
							["09.OGG"] = 00.55,
							["10.OGG"] = 00.35,
						},
						["BattleRoar_"] = {
							["01.OGG"] = 01.37,
							["02.OGG"] = 01.42,
							["03.OGG"] = 01.45,
							["04.OGG"] = 01.63,
							["05.OGG"] = 01.52,
							["06.OGG"] = 01.61,
							["07.OGG"] = 01.74,
							["08.OGG"] = 01.23,
							["09.OGG"] = 01.35,
							["10.OGG"] = 01.48,
						},
						["Death_"] = {
							["01.OGG"] = 01.10,
							["02.OGG"] = 01.39,
							["03.OGG"] = 01.60,
							["04.OGG"] = 01.86,
							["05.OGG"] = 01.86,
							["06.OGG"] = 01.54,
							["07.OGG"] = 01.77,
							["08.OGG"] = 01.46,
							["09.OGG"] = 01.46,
							["10.OGG"] = 01.54,
						},
						["PreAggro_"] = {
							["01.OGG"] = 00.78,
							["02.OGG"] = 01.36,
							["03.OGG"] = 01.51,
							["04.OGG"] = 00.87,
							["05.OGG"] = 01.33,
						},
						["Run_"] = {
							["01.OGG"] = 00.63,
							["02.OGG"] = 00.57,
							["03.OGG"] = 00.44,
							["04.OGG"] = 01.26,
							["05.OGG"] = 00.84,
							["06.OGG"] = 00.64,
							["07.OGG"] = 00.99,
							["08.OGG"] = 00.70,
							["09.OGG"] = 00.67,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.89,
							["02.OGG"] = 00.83,
							["03.OGG"] = 01.05,
							["04.OGG"] = 01.41,
							["05.OGG"] = 01.28,
						},
						["Wound_"] = {
							["01.OGG"] = 01.04,
							["02.OGG"] = 00.96,
							["03.OGG"] = 00.99,
							["04.OGG"] = 01.27,
							["05.OGG"] = 00.99,
							["06.OGG"] = 00.82,
							["07.OGG"] = 01.22,
							["08.OGG"] = 01.52,
							["09.OGG"] = 01.19,
							["10.OGG"] = 00.87,
						},
					},
				},
				["HozenCrazy\\VO_"] = {
					["Hozen_Crazy_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 00.95,
							["02.OGG"] = 00.72,
							["03.OGG"] = 01.07,
							["04.OGG"] = 01.02,
							["05.OGG"] = 01.03,
							["06.OGG"] = 00.81,
						},
						["Attack_"] = {
							["01.OGG"] = 00.41,
							["02.OGG"] = 00.58,
							["03.OGG"] = 00.53,
							["04.OGG"] = 00.34,
							["05.OGG"] = 00.60,
							["06.OGG"] = 00.53,
							["07.OGG"] = 00.72,
							["08.OGG"] = 00.40,
							["09.OGG"] = 00.38,
							["10.OGG"] = 00.45,
						},
						["Death_"] = {
							["01.OGG"] = 01.10,
							["02.OGG"] = 01.10,
							["03.OGG"] = 01.35,
							["04.OGG"] = 00.96,
							["05.OGG"] = 01.00,
							["06.OGG"] = 01.35,
							["07.OGG"] = 02.00,
						},
						["Farewell_"] = {
							["01.OGG"] = 00.67,
							["02.OGG"] = 01.85,
							["03.OGG"] = 00.74,
							["04.OGG"] = 00.58,
						},
						["Greeting_"] = {
							["01.OGG"] = 01.16,
							["02.OGG"] = 00.43,
							["03.OGG"] = 00.85,
							["04.OGG"] = 00.78,
						},
						["Pissed_"] = {
							["01.OGG"] = 08.79,
							["02.OGG"] = 02.57,
						},
						["Vendor_"] = {
							["01.OGG"] = 00.99,
							["02.OGG"] = 01.77,
							["03.OGG"] = 02.57,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.83,
							["02.OGG"] = 00.90,
							["03.OGG"] = 00.95,
							["04.OGG"] = 00.80,
							["05.OGG"] = 00.76,
						},
						["Wound_"] = {
							["01.OGG"] = 00.55,
							["02.OGG"] = 00.76,
							["03.OGG"] = 00.74,
							["04.OGG"] = 00.77,
							["05.OGG"] = 00.70,
							["06.OGG"] = 00.76,
						},
					},
				},
				["HozenGruff\\VO_"] = {
					["Hozen_Gruff_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.12,
							["02.OGG"] = 01.46,
							["03.OGG"] = 01.44,
							["04.OGG"] = 01.45,
							["05.OGG"] = 01.21,
							["06.OGG"] = 01.07,
							["07.OGG"] = 01.43,
							["08.OGG"] = 01.26,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.91,
							["02.OGG"] = 00.86,
							["03.OGG"] = 00.51,
							["04.OGG"] = 00.57,
							["05.OGG"] = 00.90,
							["06.OGG"] = 00.79,
							["07.OGG"] = 00.38,
							["08.OGG"] = 00.46,
							["09.OGG"] = 00.45,
							["10.OGG"] = 00.75,
						},
						["Death_"] = {
							["01.OGG"] = 01.63,
							["02.OGG"] = 01.97,
							["03.OGG"] = 02.37,
							["04.OGG"] = 01.25,
							["05.OGG"] = 01.46,
							["06.OGG"] = 01.73,
							["07.OGG"] = 01.65,
							["08.OGG"] = 02.05,
							["09.OGG"] = 01.30,
							["10.OGG"] = 02.09,
						},
						["Farewell_"] = {
							["01.OGG"] = 01.89,
							["02.OGG"] = 00.98,
							["03.OGG"] = 01.99,
							["04.OGG"] = 01.71,
						},
						["Greeting_"] = {
							["01.OGG"] = 00.53,
							["02.OGG"] = 00.67,
							["03.OGG"] = 00.50,
							["04.OGG"] = 00.50,
						},
						["Pissed_"] = {
							["01.OGG"] = 00.79,
							["02.OGG"] = 01.43,
						},
						["Vendor_"] = {
							["01.OGG"] = 02.04,
							["02.OGG"] = 02.05,
							["03.OGG"] = 00.87,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.41,
							["02.OGG"] = 00.56,
							["03.OGG"] = 00.71,
							["04.OGG"] = 00.80,
							["05.OGG"] = 01.01,
							["06.OGG"] = 00.70,
							["07.OGG"] = 00.91,
							["08.OGG"] = 00.72,
							["09.OGG"] = 00.67,
						},
						["Wound_"] = {
							["01.OGG"] = 00.53,
							["02.OGG"] = 00.45,
							["03.OGG"] = 00.61,
							["04.OGG"] = 00.50,
							["05.OGG"] = 00.52,
							["06.OGG"] = 00.55,
							["07.OGG"] = 00.52,
							["08.OGG"] = 00.59,
							["09.OGG"] = 00.61,
							["10.OGG"] = 00.37,
						},
					},
				},
				["HozenStandard\\VO_"] = {
					["Hozen_Standard_"] = {
						["AttackCrit_"] = {
							["01.OGG"] = 01.61,
							["02.OGG"] = 01.23,
							["03.OGG"] = 01.42,
							["04.OGG"] = 01.17,
							["05.OGG"] = 01.24,
							["06.OGG"] = 01.27,
							["07.OGG"] = 01.49,
							["08.OGG"] = 01.55,
							["09.OGG"] = 01.64,
						},
						["Attacks_"] = {
							["01.OGG"] = 00.83,
							["02.OGG"] = 01.31,
							["03.OGG"] = 00.86,
							["04.OGG"] = 01.16,
							["05.OGG"] = 00.63,
							["06.OGG"] = 00.72,
							["07.OGG"] = 00.71,
							["08.OGG"] = 00.71,
							["09.OGG"] = 01.03,
							["10.OGG"] = 00.75,
						},
						["Death_"] = {
							["01.OGG"] = 01.54,
							["02.OGG"] = 02.04,
							["03.OGG"] = 01.47,
							["04.OGG"] = 02.51,
							["05.OGG"] = 01.73,
							["06.OGG"] = 02.66,
							["07.OGG"] = 01.78,
						},
						["Farewell_"] = {
							["01.OGG"] = 02.36,
							["02.OGG"] = 01.57,
							["03.OGG"] = 02.16,
							["04.OGG"] = 03.26,
						},
						["Greeting_"] = {
							["01.OGG"] = 01.81,
							["02.OGG"] = 02.09,
							["03.OGG"] = 01.27,
							["04.OGG"] = 02.21,
						},
						["Pissed_"] = {
							["01.OGG"] = 06.38,
							["02.OGG"] = 10.27,
						},
						["Vendor_"] = {
							["01.OGG"] = 04.09,
							["02.OGG"] = 03.12,
						},
						["WoundCrit_"] = {
							["01.OGG"] = 00.88,
							["02.OGG"] = 01.05,
							["03.OGG"] = 00.90,
							["04.OGG"] = 01.28,
							["05.OGG"] = 00.97,
							["06.OGG"] = 01.06,
							["07.OGG"] = 00.64,
							["08.OGG"] = 00.72,
							["09.OGG"] = 00.81,
						},
						["Wound_"] = {
							["01.OGG"] = 00.68,
							["02.OGG"] = 00.85,
							["03.OGG"] = 00.80,
							["04.OGG"] = 01.09,
							["05.OGG"] = 01.25,
							["06.OGG"] = 00.68,
							["07.OGG"] = 00.71,
							["08.OGG"] = 01.01,
							["09.OGG"] = 00.85,
						},
					},
				},
				["HumanFemaleKid\\"] = {
					["HumanFemaleKidCry1.ogg"] = 01.37,
					["HumanFemaleKidCry2.ogg"] = 01.88,
					["HumanFemaleKidCry3.ogg"] = 01.88,
					["HumanFemaleKidCry4.ogg"] = 02.01,
					["HumanFemaleKidLaugh1.ogg"] = 00.63,
					["HumanFemaleKidLaugh2.ogg"] = 00.66,
					["HumanFemaleKidLaugh3.ogg"] = 00.95,
					["HumanFemaleKidLaugh4.ogg"] = 00.78,
				},
				["HumanFemaleNPC01\\MON_"] = {
					["HumanFemale_NPC01_"] = {
						["Aggro_"] = {
							["01.ogg"] = 00.58,
							["02.ogg"] = 00.73,
							["03.ogg"] = 00.66,
							["04.ogg"] = 00.51,
							["05.ogg"] = 00.87,
							["06.ogg"] = 00.94,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 00.85,
							["02.ogg"] = 01.13,
							["03.ogg"] = 01.09,
							["04.ogg"] = 01.02,
							["05.ogg"] = 01.06,
							["06.ogg"] = 01.20,
							["07.ogg"] = 01.35,
							["08.ogg"] = 00.91,
						},
						["Attack_"] = {
							["01.ogg"] = 00.44,
							["010.ogg"] = 00.68,
							["011.ogg"] = 00.45,
							["02.ogg"] = 00.60,
							["03.ogg"] = 00.52,
							["04.ogg"] = 00.49,
							["05.ogg"] = 00.63,
							["06.ogg"] = 00.68,
							["07.ogg"] = 00.73,
							["08.ogg"] = 00.51,
							["09.ogg"] = 00.73,
						},
						["Death_"] = {
							["01.ogg"] = 01.96,
							["010.ogg"] = 02.03,
							["011.ogg"] = 02.03,
							["02.ogg"] = 02.25,
							["03.ogg"] = 02.11,
							["04.ogg"] = 02.03,
							["05.ogg"] = 02.00,
							["06.ogg"] = 01.95,
							["07.ogg"] = 02.07,
							["08.ogg"] = 02.18,
							["09.ogg"] = 01.93,
						},
						["PreAggro_"] = {
							["01.ogg"] = 00.29,
							["02.ogg"] = 00.33,
							["03.ogg"] = 00.38,
							["04.ogg"] = 00.27,
							["05.ogg"] = 00.43,
							["06.ogg"] = 00.25,
							["07.ogg"] = 00.31,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 00.74,
							["02.ogg"] = 00.61,
							["03.ogg"] = 00.70,
							["04.ogg"] = 00.95,
							["05.ogg"] = 00.91,
							["06.ogg"] = 00.77,
							["07.ogg"] = 00.61,
							["08.ogg"] = 00.77,
						},
						["Wound_"] = {
							["01.ogg"] = 00.34,
							["010.ogg"] = 00.45,
							["011.ogg"] = 00.47,
							["012.ogg"] = 00.45,
							["013.ogg"] = 00.49,
							["014.ogg"] = 00.58,
							["02.ogg"] = 00.43,
							["03.ogg"] = 00.44,
							["04.ogg"] = 00.33,
							["05.ogg"] = 00.37,
							["06.ogg"] = 00.35,
							["07.ogg"] = 00.39,
							["08.ogg"] = 00.42,
							["09.ogg"] = 00.28,
						},
					},
				},
				["HumanFemaleOfficialNPC\\"] = {
					["HumanFemaleOfficialNPCFarewell01.ogg"] = 00.53,
					["HumanFemaleOfficialNPCFarewell02.ogg"] = 01.15,
					["HumanFemaleOfficialNPCFarewell03.ogg"] = 00.60,
					["HumanFemaleOfficialNPCFarewell04.ogg"] = 01.40,
					["HumanFemaleOfficialNPCFarewell05.ogg"] = 01.05,
					["HumanFemaleOfficialNPCGreeting01.ogg"] = 00.81,
					["HumanFemaleOfficialNPCGreeting02.ogg"] = 00.71,
					["HumanFemaleOfficialNPCGreeting03.ogg"] = 00.63,
					["HumanFemaleOfficialNPCGreeting04.ogg"] = 01.10,
					["HumanFemaleOfficialNPCGreeting05.ogg"] = 00.62,
					["HumanFemaleOfficialNPCGreeting06.ogg"] = 01.24,
					["HumanFemaleOfficialNPCPissed01.ogg"] = 00.97,
					["HumanFemaleOfficialNPCPissed02.ogg"] = 01.06,
					["HumanFemaleOfficialNPCPissed03.ogg"] = 01.52,
					["HumanFemaleOfficialNPCVendor01.ogg"] = 01.11,
					["HumanFemaleOfficialNPCVendor02.ogg"] = 01.64,
					["HumanFemaleOfficialNPCVendor03.ogg"] = 00.99,
					["HumanFemaleOfficialNPCVendor04.ogg"] = 01.07,
				},
				["HumanFemaleStandardNPC\\"] = {
					["HumanFemaleStandardNPCFarewell01.ogg"] = 00.81,
					["HumanFemaleStandardNPCFarewell02.ogg"] = 00.96,
					["HumanFemaleStandardNPCFarewell03.ogg"] = 00.87,
					["HumanFemaleStandardNPCFarewell04.ogg"] = 00.82,
					["HumanFemaleStandardNPCGreeting01.ogg"] = 00.57,
					["HumanFemaleStandardNPCGreeting02.ogg"] = 00.82,
					["HumanFemaleStandardNPCGreeting03.ogg"] = 00.60,
					["HumanFemaleStandardNPCGreeting04.ogg"] = 00.95,
					["HumanFemaleStandardNPCGreeting05.ogg"] = 00.64,
					["HumanFemaleStandardNPCPissed01.ogg"] = 00.86,
					["HumanFemaleStandardNPCPissed02.ogg"] = 00.89,
					["HumanFemaleStandardNPCPissed03.ogg"] = 00.84,
					["HumanFemaleStandardNPCVendor01.ogg"] = 02.06,
					["HumanFemaleStandardNPCVendor02.ogg"] = 01.33,
					["HumanFemaleStandardNPCVendor03.ogg"] = 00.98,
					["HumanFemaleStandardNPCVendor04.ogg"] = 01.06,
					["HumanFemaleStandardNPCVendor05.ogg"] = 00.78,
				},
				["HumanFemaleWarriorNPC\\"] = {
					["HumanFemaleWarriorNPCFarewell01.ogg"] = 00.71,
					["HumanFemaleWarriorNPCFarewell02.ogg"] = 00.91,
					["HumanFemaleWarriorNPCFarewell03.ogg"] = 00.64,
					["HumanFemaleWarriorNPCFarewell04.ogg"] = 00.81,
					["HumanFemaleWarriorNPCFarewell05.ogg"] = 00.67,
					["HumanFemaleWarriorNPCGreeting01.ogg"] = 00.49,
					["HumanFemaleWarriorNPCGreeting02.ogg"] = 00.67,
					["HumanFemaleWarriorNPCGreeting03.ogg"] = 00.54,
					["HumanFemaleWarriorNPCGreeting04.ogg"] = 01.07,
					["HumanFemaleWarriorNPCGreeting05.ogg"] = 00.54,
					["HumanFemaleWarriorNPCGreeting06.ogg"] = 00.79,
					["HumanFemaleWarriorNPCPissed01.ogg"] = 01.10,
					["HumanFemaleWarriorNPCPissed02.ogg"] = 00.50,
					["HumanFemaleWarriorNPCPissed03.ogg"] = 00.82,
					["HumanFemaleWarriorNPCPissed04.ogg"] = 01.53,
					["HumanFemaleWarriorNPCVendor01.ogg"] = 01.73,
					["HumanFemaleWarriorNPCVendor02.ogg"] = 01.22,
					["HumanFemaleWarriorNPCVendor03.ogg"] = 01.01,
					["HumanFemaleWarriorNPCVendor04.ogg"] = 01.26,
				},
				["HumanMaleCaster\\MON_"] = {
					["HumanMale_Caster_"] = {
						["Aggro_"] = {
							["01.ogg"] = 00.35,
							["02.ogg"] = 00.47,
							["03.ogg"] = 00.69,
							["04.ogg"] = 00.65,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 01.02,
							["02.ogg"] = 00.92,
							["03.ogg"] = 01.01,
							["04.ogg"] = 01.01,
							["05.ogg"] = 01.03,
						},
						["Attack_"] = {
							["01.ogg"] = 00.41,
							["010.ogg"] = 00.66,
							["011.ogg"] = 00.69,
							["02.ogg"] = 00.97,
							["03.ogg"] = 01.01,
							["04.ogg"] = 00.48,
							["05.ogg"] = 00.47,
							["06.ogg"] = 00.58,
							["07.ogg"] = 00.68,
							["08.ogg"] = 00.83,
							["09.ogg"] = 00.86,
						},
						["Death_"] = {
							["01.ogg"] = 01.73,
							["02.ogg"] = 01.87,
							["03.ogg"] = 01.88,
							["04.ogg"] = 01.87,
							["05.ogg"] = 01.95,
							["06.ogg"] = 01.78,
							["07.ogg"] = 01.85,
						},
						["PreAggro_"] = {
							["01.ogg"] = 00.22,
							["02.ogg"] = 00.14,
							["03.ogg"] = 00.29,
							["04.ogg"] = 00.35,
							["05.ogg"] = 00.37,
							["06.ogg"] = 00.23,
							["07.ogg"] = 00.23,
							["08.ogg"] = 00.23,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 00.73,
							["02.ogg"] = 00.74,
							["03.ogg"] = 00.72,
							["04.ogg"] = 01.07,
							["05.ogg"] = 01.11,
							["06.ogg"] = 00.92,
							["07.ogg"] = 00.84,
							["08.ogg"] = 00.95,
							["09.ogg"] = 00.77,
						},
						["Wound_"] = {
							["01.ogg"] = 00.40,
							["010.ogg"] = 00.33,
							["011.ogg"] = 00.51,
							["012.ogg"] = 00.80,
							["013.ogg"] = 00.65,
							["014.ogg"] = 00.59,
							["015.ogg"] = 00.91,
							["02.ogg"] = 00.33,
							["03.ogg"] = 00.55,
							["04.ogg"] = 00.31,
							["05.ogg"] = 00.38,
							["06.ogg"] = 00.45,
							["07.ogg"] = 00.69,
							["08.ogg"] = 00.42,
							["09.ogg"] = 00.41,
						},
					},
				},
				["HumanMAleKid\\"] = {
					["HumanMaleKidCry1.ogg"] = 01.58,
					["HumanMaleKidCry2.ogg"] = 01.92,
					["HumanMaleKidCry3.ogg"] = 02.73,
					["HumanMaleKidCry4.ogg"] = 02.09,
					["HumanMaleKidCry5.ogg"] = 01.78,
					["HumanMaleKidLaugh1.ogg"] = 01.30,
					["HumanMaleKidLaugh2.ogg"] = 01.24,
					["HumanMaleKidLaugh3.ogg"] = 00.88,
					["HumanMaleKidLaugh4.ogg"] = 00.78,
				},
				["HumanMaleMelee\\MON_"] = {
					["HumanMale_Melee_"] = {
						["Aggro_"] = {
							["01.ogg"] = 00.81,
							["02.ogg"] = 00.85,
							["03.ogg"] = 00.64,
							["04.ogg"] = 00.51,
							["05.ogg"] = 00.68,
							["06.ogg"] = 00.31,
							["07.ogg"] = 00.47,
							["08.ogg"] = 00.62,
						},
						["AttackCrit_"] = {
							["01.ogg"] = 00.83,
							["02.ogg"] = 00.79,
							["03.ogg"] = 00.71,
							["04.ogg"] = 00.95,
							["05.ogg"] = 01.00,
							["06.ogg"] = 00.93,
						},
						["Attack_"] = {
							["01.ogg"] = 00.41,
							["010.ogg"] = 00.30,
							["011.ogg"] = 00.49,
							["012.ogg"] = 00.92,
							["02.ogg"] = 00.39,
							["03.ogg"] = 00.77,
							["04.ogg"] = 00.27,
							["05.ogg"] = 00.39,
							["06.ogg"] = 00.32,
							["07.ogg"] = 00.59,
							["08.ogg"] = 00.60,
							["09.ogg"] = 00.70,
						},
						["Death_"] = {
							["01.ogg"] = 02.02,
							["02.ogg"] = 01.85,
							["03.ogg"] = 01.77,
							["04.ogg"] = 01.80,
							["05.ogg"] = 01.69,
							["06.ogg"] = 01.70,
							["07.ogg"] = 01.98,
							["08.ogg"] = 01.74,
						},
						["PreAggro_"] = {
							["01.ogg"] = 00.22,
							["02.ogg"] = 00.26,
							["03.ogg"] = 00.22,
							["04.ogg"] = 00.25,
							["05.ogg"] = 00.18,
							["06.ogg"] = 00.27,
						},
						["WoundCrit_"] = {
							["01.ogg"] = 00.76,
							["010.ogg"] = 01.15,
							["011.ogg"] = 00.95,
							["012.ogg"] = 01.08,
							["013.ogg"] = 00.83,
							["02.ogg"] = 00.57,
							["03.ogg"] = 00.77,
							["04.ogg"] = 00.79,
							["05.ogg"] = 01.01,
							["06.ogg"] = 00.69,
							["07.ogg"] = 00.94,
							["08.ogg"] = 00.76,
							["09.ogg"] = 00.98,
						},
						["Wound_"] = {
							["01.ogg"] = 00.31,
							["010.ogg"] = 00.60,
							["011.ogg"] = 00.84,
							["012.ogg"] = 00.56,
							["02.ogg"] = 00.43,
							["03.ogg"] = 00.50,
							["04.ogg"] = 00.30,
							["05.ogg"] = 00.44,
							["06.ogg"] = 00.55,
							["07.ogg"] = 00.51,
							["08.ogg"] = 00.51,
							["09.ogg"] = 00.61,
						},
					},
				},
				["HumanMaleOfficialNPC\\"] = {
					["HumanMaleOfficialNPCFarewell01.ogg"] = 00.56,
					["HumanMaleOfficialNPCFarewell02.ogg"] = 00.80,
					["HumanMaleOfficialNPCFarewell03.ogg"] = 01.02,
					["HumanMaleOfficialNPCFarewell04.ogg"] = 00.85,
					["HumanMaleOfficialNPCGreeting01.ogg"] = 00.56,
					["HumanMaleOfficialNPCGreeting02.ogg"] = 00.52,
					["HumanMaleOfficialNPCGreeting03.ogg"] = 00.58,
					["HumanMaleOfficialNPCGreeting04.ogg"] = 00.88,
					["HumanMaleOfficialNPCGreeting05.ogg"] = 00.87,
					["HumanMaleOfficialNPCGreeting06.ogg"] = 00.85,
					["HumanMaleOfficialNPCPissed01.ogg"] = 00.89,
					["HumanMaleOfficialNPCPissed02.ogg"] = 00.71,
					["HumanMaleOfficialNPCPissed03.ogg"] = 00.44,
					["HumanMaleOfficialNPCPissed04.ogg"] = 00.88,
					["HumanMaleOfficialNPCPissed05.ogg"] = 00.64,
					["HumanMaleOfficialNPCPissed06.ogg"] = 01.46,
					["HumanMaleOfficialNPCVendor01.ogg"] = 02.12,
					["HumanMaleOfficialNPCVendor02.ogg"] = 00.80,
					["HumanMaleOfficialNPCVendor03.ogg"] = 01.02,
					["HumanMaleOfficialNPCVendor04.ogg"] = 01.12,
				},
				["HumanMaleStandardNPC\\"] = {
					["HumanMaleStandardNPCFarewell01.ogg"] = 00.71,
					["HumanMaleStandardNPCFarewell02.ogg"] = 00.95,
					["HumanMaleStandardNPCFarewell03.ogg"] = 00.81,
					["HumanMaleStandardNPCFarewell04.ogg"] = 00.90,
					["HumanMaleStandardNPCGreetings01.ogg"] = 00.46,
					["HumanMaleStandardNPCGreetings02.ogg"] = 00.39,
					["HumanMaleStandardNPCGreetings03.ogg"] = 01.14,
					["HumanMaleStandardNPCGreetings04.ogg"] = 01.13,
					["HumanMaleStandardNPCGreetings05.ogg"] = 00.69,
					["HumanMaleStandardNPCGreetings06.ogg"] = 00.89,
					["HumanMaleStandardNPCPissed01.ogg"] = 00.84,
					["HumanMaleStandardNPCPissed02.ogg"] = 00.91,
					["HumanMaleStandardNPCPissed03.ogg"] = 00.58,
					["HumanMaleStandardNPCPissed04.ogg"] = 00.86,
					["HumanMaleStandardNPCVendor01.ogg"] = 02.23,
					["HumanMaleStandardNPCVendor02.ogg"] = 01.38,
				},
				["HumanMaleWarriorNPC\\"] = {
					["HumanMaleWarriorNPCFarewell01.ogg"] = 00.81,
					["HumanMaleWarriorNPCFarewell02.ogg"] = 00.71,
					["HumanMaleWarriorNPCFarewell03.ogg"] = 00.66,
					["HumanMaleWarriorNPCFarewell04.ogg"] = 00.71,
					["HumanMaleWarriorNPCFarewell05.ogg"] = 01.12,
					["HumanMaleWarriorNPCGreeting01.ogg"] = 01.22,
					["HumanMaleWarriorNPCGreeting02.ogg"] = 00.51,
					["HumanMaleWarriorNPCGreeting03.ogg"] = 00.47,
					["HumanMaleWarriorNPCGreeting04.ogg"] = 00.80,
					["HumanMaleWarriorNPCGreeting05.ogg"] = 00.80,
					["HumanMaleWarriorNPCPissed01.ogg"] = 00.73,
					["HumanMaleWarriorNPCPissed02.ogg"] = 00.82,
					["HumanMaleWarriorNPCPissed03.ogg"] = 01.33,
					["HumanMaleWarriorNPCPissed04.ogg"] = 00.85,
					["HumanMaleWarriorNPCPissed05.ogg"] = 00.73,
					["HumanMaleWarriorNPCVendor01.ogg"] = 02.06,
					["HumanMaleWarriorNPCVendor02.ogg"] = 01.59,
					["HumanMaleWarriorNPCVendor03.ogg"] = 01.07,
					["HumanMaleWarriorNPCVendor04.ogg"] = 01.24,
				},
				["HumeSoldier1\\VO_"] = {
					["60_"] = {
						["SPD_HUMAN_"] = {
							["01.ogg"] = 07.61,
							["02.ogg"] = 05.20,
						},
						["TLD_HUM_"] = {
							["SOLDER_"] = {
								["01.ogg"] = 03.03,
								["02.ogg"] = 01.19,
							},
						},
						["NGD_WARSONG_ALLY_GROKGLOK_01.ogg"] = 01.38,
					},
				},
				["Huntress\\"] = {
					["HuntressWarcry1.ogg"] = 01.68,
					["HuntressWhat2.ogg"] = 00.98,
					["HuntressWhat3.ogg"] = 01.24,
					["HuntressYesAttack3.ogg"] = 01.44,
				},
				["Husam\\VO_"] = {
					["TV_Husam_"] = {
						["Attack01.ogg"] = 00.61,
						["Attack02.ogg"] = 00.70,
						["Attack03.ogg"] = 00.64,
						["Attack04.ogg"] = 00.55,
						["Attack05.ogg"] = 00.66,
						["Attack06.ogg"] = 00.56,
						["Attack07.ogg"] = 00.49,
						["Attack08.ogg"] = 00.63,
						["Attack09.ogg"] = 00.73,
						["AttackCritical01.ogg"] = 00.72,
						["AttackCritical02.ogg"] = 00.83,
						["AttackCritical03.ogg"] = 00.70,
						["AttackCritical04.ogg"] = 00.75,
						["AttackCritical05.ogg"] = 00.83,
						["AttackCritical06.ogg"] = 00.70,
						["Death01.ogg"] = 07.60,
						["Engage01.ogg"] = 05.42,
						["Event01.ogg"] = 01.24,
						["Event02.ogg"] = 01.14,
						["Kill02.ogg"] = 01.26,
						["Wound01.ogg"] = 00.87,
						["Wound02.ogg"] = 00.84,
						["Wound03.ogg"] = 00.91,
						["Wound04.ogg"] = 01.04,
						["Wound05.ogg"] = 00.72,
						["Wound06.ogg"] = 00.76,
						["Wound07.ogg"] = 00.73,
						["Wound08.ogg"] = 00.75,
						["Wound09.ogg"] = 00.80,
						["Wound10.ogg"] = 00.85,
						["WoundCritical01.ogg"] = 01.11,
						["WoundCritical02.ogg"] = 01.38,
						["WoundCritical03.ogg"] = 01.46,
						["WoundCritical04.ogg"] = 01.73,
						["WoundCritical05.ogg"] = 01.51,
					},
				},
				["Huseng\\VO_"] = {
					["52_"] = {
						["HUSENG_"] = {
							["AttackCrit_"] = {
								["01.OGG"] = 01.84,
								["02.OGG"] = 00.84,
								["03.OGG"] = 01.83,
								["04.OGG"] = 01.03,
								["05.OGG"] = 00.98,
							},
							["Attack_"] = {
								["01.OGG"] = 00.68,
								["02.OGG"] = 00.65,
								["03.OGG"] = 00.68,
								["04.OGG"] = 00.73,
								["05.OGG"] = 00.87,
								["06.OGG"] = 00.75,
								["07.OGG"] = 00.70,
								["08.OGG"] = 00.68,
								["09.OGG"] = 00.78,
							},
							["Death_"] = {
								["01.OGG"] = 02.49,
								["02.OGG"] = 02.70,
								["03.OGG"] = 02.60,
								["04.OGG"] = 02.68,
								["05.OGG"] = 03.04,
							},
							["WoundCrit_"] = {
								["01.OGG"] = 01.86,
								["02.OGG"] = 01.33,
								["03.OGG"] = 01.64,
								["04.OGG"] = 01.19,
								["05.OGG"] = 01.20,
							},
							["Wound_"] = {
								["01.OGG"] = 00.90,
								["010.OGG"] = 00.90,
								["02.OGG"] = 00.55,
								["03.OGG"] = 00.79,
								["04.OGG"] = 01.02,
								["05.OGG"] = 01.03,
								["06.OGG"] = 00.84,
								["07.OGG"] = 00.77,
								["08.OGG"] = 00.79,
								["09.OGG"] = 00.60,
							},
						},
						["TKR_HUSENG_"] = {
							["SHIPYARD_EVENT_"] = {
								["01.OGG"] = 06.54,
								["02.OGG"] = 03.69,
								["03.OGG"] = 07.89,
								["04.OGG"] = 05.05,
								["05.OGG"] = 08.25,
								["06.OGG"] = 04.18,
								["07.OGG"] = 04.39,
								["08.OGG"] = 02.44,
								["09.OGG"] = 03.12,
								["10.OGG"] = 08.13,
								["11.OGG"] = 05.21,
							},
						},
					},
				},
				["HVanguard01\\VO_"] = {
					["QE_VJ_"] = {
						["HVanguard01_"] = {
							["Dock01.ogg"] = 04.49,
							["Dock02.ogg"] = 05.32,
							["Dock03.ogg"] = 04.81,
							["Dock04.ogg"] = 06.52,
							["Sub01.ogg"] = 00.65,
						},
					},
				},
				["HVanguard02\\VO_"] = {
					["QE_VJ_"] = {
						["HVanguard02_"] = {
							["Dock01.ogg"] = 01.44,
							["Dock02.ogg"] = 04.81,
							["Dock03.ogg"] = 01.56,
							["Dock04.ogg"] = 05.14,
							["Dock05.ogg"] = 04.97,
						},
					},
				},
				["HVanguard03\\VO_"] = {
					["QE_VJ_"] = {
						["HVanguard03_"] = {
							["Dock01.ogg"] = 01.95,
							["Dock02.ogg"] = 04.55,
							["Dock03.ogg"] = 05.33,
							["Dock04.ogg"] = 04.41,
							["Dock05.ogg"] = 04.94,
							["Dock06.ogg"] = 03.45,
							["Dock07.ogg"] = 02.47,
							["Dock08.ogg"] = 06.74,
							["Dock09.ogg"] = 04.88,
						},
					},
				},
				["HVanguard04\\VO_"] = {
					["QE_VJ_"] = {
						["HVanguard04_"] = {
							["Dock01.ogg"] = 03.53,
							["Dock02.ogg"] = 05.33,
							["Dock03.ogg"] = 06.99,
						},
					},
				},
				["HVanguard05\\VO_"] = {
					["QE_VJ_"] = {
						["HVanguard05_"] = {
							["Dock01.ogg"] = 01.49,
							["Dock02.ogg"] = 02.29,
							["Dock03.ogg"] = 04.92,
							["Dock04.ogg"] = 03.37,
							["HordeShip01.ogg"] = 03.12,
							["HordeShip02.ogg"] = 04.38,
						},
					},
				},
				["HyacinthMacaw\\PET_"] = {
					["HyacinthMacaw_"] = {
						["Clickable01.ogg"] = 01.01,
						["Clickable02.ogg"] = 01.12,
						["Clickable03.ogg"] = 00.85,
						["Clickable04.ogg"] = 00.49,
						["Clickable05.ogg"] = 01.66,
						["Clickable06.ogg"] = 01.19,
						["Clickable07.ogg"] = 02.41,
						["Clickable08.ogg"] = 01.66,
					},
				},
				["Hydra\\"] = {
					["mHydraAggroA.ogg"] = 03.87,
					["mHydraAttackA.ogg"] = 02.27,
					["mHydraAttackB.ogg"] = 01.41,
					["mHydraAttackC.ogg"] = 02.19,
					["mHydraDeathA.ogg"] = 02.18,
					["mHydraSpellCast1A.ogg"] = 01.19,
					["mHydraSpellCast1B.ogg"] = 01.36,
					["mHydraSpellCast2A.ogg"] = 01.49,
					["mHydraSpellCast2B.ogg"] = 03.25,
					["mHydraStand2A.ogg"] = 03.23,
					["mHydraWoundA.ogg"] = 01.87,
					["mHydraWoundB.ogg"] = 02.36,
					["mHydraWoundC.ogg"] = 01.75,
					["mHydraWoundCriticalA.ogg"] = 02.00,
				},
				["HydraBoss\\MON_"] = {
					["Hydra_"] = {
						["Attack01.OGG"] = 01.64,
						["Attack02.OGG"] = 01.89,
						["Attack03.OGG"] = 01.56,
						["Attack04.OGG"] = 02.06,
						["Attack05.OGG"] = 01.72,
						["Attack06.OGG"] = 01.97,
						["Attack07.OGG"] = 02.10,
						["Attack08.OGG"] = 01.94,
						["Attack09.OGG"] = 01.98,
						["Attack10.OGG"] = 02.08,
						["AttackCrit01.OGG"] = 01.93,
						["AttackCrit02.OGG"] = 02.30,
						["AttackCrit03.OGG"] = 01.83,
						["AttackCrit04.OGG"] = 02.17,
						["Death01.OGG"] = 05.51,
						["Death02.OGG"] = 04.01,
						["Death03.OGG"] = 04.18,
						["Emerge01.OGG"] = 03.99,
						["Emerge02.OGG"] = 04.53,
						["Emerge03.OGG"] = 04.20,
						["Wound01.OGG"] = 01.98,
						["Wound02.OGG"] = 02.73,
						["Wound03.OGG"] = 02.39,
					},
				},
				["HydromancerThespia\\COIL_"] = {
					["Thesp_"] = {
						["Aggro01.ogg"] = 03.50,
						["Aggro02.ogg"] = 04.14,
						["Aggro03.ogg"] = 03.27,
						["Death01.ogg"] = 07.40,
						["Elmntl01.ogg"] = 03.20,
						["Slay01.ogg"] = 03.13,
						["Slay02.ogg"] = 03.19,
					},
				},
				["HydrossTheUnstable_Clean\\COIL_"] = {
					["HydroClean_"] = {
						["Aggro01.ogg"] = 03.52,
						["Attack01.ogg"] = 01.61,
						["Attack02.ogg"] = 01.73,
						["Attack03.ogg"] = 01.79,
						["Attack04.ogg"] = 01.88,
						["Attack05.ogg"] = 01.75,
						["Attack06.ogg"] = 01.71,
						["Attack07.ogg"] = 01.81,
						["Attack08.ogg"] = 01.74,
						["Death01.ogg"] = 04.38,
						["Slay01.ogg"] = 03.01,
						["Slay02.ogg"] = 02.60,
						["SwtchClean01.ogg"] = 04.58,
						["Wound01.ogg"] = 01.69,
						["Wound02.ogg"] = 01.70,
						["Wound03.ogg"] = 01.77,
						["WoundCrit01.ogg"] = 01.95,
						["WoundCrit02.ogg"] = 02.08,
						["WoundCrit03.ogg"] = 02.30,
					},
				},
				["HydrossTheUnstable_Corrupt\\COIL_"] = {
					["HydroCorr_"] = {
						["Attack01.ogg"] = 02.12,
						["Attack02.ogg"] = 02.54,
						["Attack03.ogg"] = 02.47,
						["Attack04.ogg"] = 02.89,
						["Death01.ogg"] = 06.50,
						["Slay01.ogg"] = 04.36,
						["Slay02.ogg"] = 04.18,
						["SwtchCorrpt01.ogg"] = 05.23,
						["Wound01.ogg"] = 01.77,
						["Wound02.ogg"] = 01.76,
						["Wound03.ogg"] = 01.73,
						["Wound04.ogg"] = 02.11,
						["Wound05.ogg"] = 02.33,
						["WoundCrit01.ogg"] = 02.38,
						["WoundCrit02.ogg"] = 02.64,
						["WoundCrit03.ogg"] = 02.05,
					},
				},
				["Hyena\\"] = {
					["HyenaAggroA.ogg"] = 01.18,
					["HyenaAttackA.ogg"] = 00.62,
					["HyenaAttackB.ogg"] = 00.70,
					["HyenaAttackC.ogg"] = 00.75,
					["HyenaPreAggroA.ogg"] = 00.70,
					["HyenaWoundA.ogg"] = 00.76,
					["HyenaWoundB.ogg"] = 00.60,
					["HyenaWoundC.ogg"] = 00.82,
					["HyenaWoundCrit.ogg"] = 00.75,
				},
				["Ichoron\\VH_"] = {
					["Ichoron_"] = {
						["Aggro.ogg"] = 03.81,
						["Attack01.ogg"] = 01.01,
						["Attack02.ogg"] = 00.67,
						["Attack03.ogg"] = 00.66,
						["Attack04.ogg"] = 01.04,
						["Attack05.ogg"] = 00.92,
						["Attack06.ogg"] = 00.75,
						["Attack07.ogg"] = 01.44,
						["Bubble.ogg"] = 11.44,
						["Death01.ogg"] = 03.75,
						["Enrage.ogg"] = 14.46,
						["Shatter.ogg"] = 03.60,
						["Slay01.ogg"] = 04.78,
						["Slay02.ogg"] = 03.14,
						["Slay03.ogg"] = 03.45,
						["Spawn.ogg"] = 04.20,
						["Wound01.ogg"] = 00.60,
						["Wound02.ogg"] = 00.91,
						["Wound03.ogg"] = 00.84,
						["Wound04.ogg"] = 00.66,
						["Wound05.ogg"] = 01.10,
						["WoundCrit01.ogg"] = 00.71,
						["WoundCrit02.ogg"] = 00.70,
						["WoundCrit03.ogg"] = 00.86,
					},
				},
				["Idrakess\\VO_"] = {
					["QE_VJ_"] = {
						["Idrakess_"] = {
							["Attack01.ogg"] = 00.87,
							["Attack02.ogg"] = 00.87,
							["Attack03.ogg"] = 00.85,
							["Attack04.ogg"] = 01.04,
							["Attack05.ogg"] = 00.96,
							["Attack06.ogg"] = 01.15,
							["Attack07.ogg"] = 01.07,
							["Attack08.ogg"] = 00.81,
							["Attack09.ogg"] = 00.99,
							["AttackCritical01.ogg"] = 01.09,
							["AttackCritical02.ogg"] = 01.04,
							["AttackCritical03.ogg"] = 01.37,
							["AttackCritical04.ogg"] = 01.13,
							["AttackCritical05.ogg"] = 01.18,
							["AttackCritical06.ogg"] = 01.04,
							["Death01.ogg"] = 02.75,
							["Death02.ogg"] = 02.53,
							["Death03.ogg"] = 02.26,
							["Death04.ogg"] = 03.99,
							["Event01.ogg"] = 09.28,
							["Event02.ogg"] = 04.67,
							["Event03.ogg"] = 03.20,
							["Event04.ogg"] = 03.76,
							["Event05.ogg"] = 04.71,
							["Event06.ogg"] = 08.56,
							["Event07.ogg"] = 06.79,
							["Temple01.ogg"] = 03.86,
							["Temple02.ogg"] = 03.65,
							["Temple04.ogg"] = 03.88,
							["Temple05.ogg"] = 04.54,
							["Wound01.ogg"] = 01.10,
							["Wound02.ogg"] = 00.83,
							["Wound03.ogg"] = 00.94,
							["Wound04.ogg"] = 00.96,
							["Wound05.ogg"] = 01.08,
							["Wound06.ogg"] = 01.17,
							["Wound07.ogg"] = 00.76,
							["Wound08.ogg"] = 01.07,
							["Wound09.ogg"] = 00.73,
							["Wound10.ogg"] = 00.82,
							["WoundCritical01.ogg"] = 01.02,
							["WoundCritical02.ogg"] = 01.19,
							["WoundCritical03.ogg"] = 01.49,
							["WoundCritical04.ogg"] = 01.48,
							["WoundCritical05.ogg"] = 01.34,
						},
					},
				},
				["Ignacious\\VO_"] = {
					["BT_Ignacious_"] = {
						["Attack01.ogg"] = 01.53,
						["Attack02.ogg"] = 02.20,
						["Attack03.ogg"] = 01.61,
						["Attack04.ogg"] = 01.86,
						["Attack05.ogg"] = 01.51,
						["Attack06.ogg"] = 01.18,
						["Attack07.ogg"] = 01.14,
						["Attack08.ogg"] = 01.14,
						["Attack09.ogg"] = 01.53,
						["AttackCrit01.ogg"] = 01.73,
						["AttackCrit02.ogg"] = 01.93,
						["AttackCrit03.ogg"] = 01.88,
						["AttackCrit04.ogg"] = 01.91,
						["Death01.ogg"] = 03.44,
						["Death02.ogg"] = 03.67,
						["Death03.ogg"] = 02.70,
						["Event01.ogg"] = 06.80,
						["Event02.ogg"] = 04.50,
						["Event03.ogg"] = 02.98,
						["Event04.ogg"] = 05.08,
						["Event05.ogg"] = 07.37,
						["Wound01.ogg"] = 01.48,
						["Wound02.ogg"] = 00.97,
						["Wound03.ogg"] = 00.69,
						["Wound04.ogg"] = 01.08,
						["Wound05.ogg"] = 01.14,
						["Wound06.ogg"] = 00.69,
						["Wound07.ogg"] = 00.70,
						["Wound08.ogg"] = 01.12,
						["WoundCrit01.ogg"] = 01.40,
						["WoundCrit02.ogg"] = 01.38,
						["WoundCrit03.ogg"] = 01.31,
						["WoundCrit04.ogg"] = 01.45,
						["WoundCrit05.ogg"] = 01.69,
					},
				},
				["IgnisTheFireMaster\\UR_"] = {
					["Ignis_"] = {
						["Aggro01.ogg"] = 07.08,
						["Attack01.ogg"] = 00.62,
						["Attack02.ogg"] = 00.64,
						["Attack03.ogg"] = 00.93,
						["Attack04.ogg"] = 00.88,
						["Attack05.ogg"] = 01.06,
						["Attack06.ogg"] = 01.44,
						["Attack07.ogg"] = 01.18,
						["Attack08.ogg"] = 01.33,
						["Attack09.ogg"] = 02.13,
						["Attack10.ogg"] = 02.27,
						["Berserk01.ogg"] = 03.86,
						["CreateAdds01.ogg"] = 07.33,
						["Death01.ogg"] = 04.21,
						["FireSpec01.ogg"] = 03.13,
						["FireSpec02.ogg"] = 05.69,
						["PourMetal01.ogg"] = 03.61,
						["Slay01.ogg"] = 02.78,
						["Slay02.ogg"] = 03.65,
						["Wound01.ogg"] = 00.74,
						["Wound02.ogg"] = 00.75,
						["Wound03.ogg"] = 00.79,
						["Wound04.ogg"] = 01.05,
						["Wound05.ogg"] = 01.09,
						["Wound06.ogg"] = 01.08,
						["Wound07.ogg"] = 01.78,
						["Wound08.ogg"] = 01.23,
						["Wound09.ogg"] = 01.32,
						["Wound10.ogg"] = 01.02,
						["WoundCrit01.ogg"] = 03.23,
						["WoundCrit02.ogg"] = 02.89,
						["WoundCrit03.ogg"] = 02.87,
					},
				},
				["Illidan\\"] = {
					["BLACK_Illidan_"] = {
						["01.ogg"] = 14.33,
						["02.ogg"] = 08.48,
						["03.ogg"] = 08.73,
						["04.ogg"] = 05.76,
						["05.ogg"] = 04.92,
						["06.ogg"] = 04.84,
						["07.ogg"] = 05.20,
						["08.ogg"] = 07.06,
						["09.ogg"] = 04.52,
						["10.ogg"] = 03.81,
						["11.ogg"] = 06.62,
						["12.ogg"] = 09.54,
						["13.ogg"] = 08.17,
						["14.ogg"] = 08.99,
						["15.ogg"] = 06.87,
						["16.ogg"] = 23.32,
						["17.ogg"] = 06.39,
						["18.ogg"] = 06.06,
						["19.ogg"] = 05.76,
						["Attack01.ogg"] = 00.56,
						["Attack02.ogg"] = 00.66,
						["Attack03.ogg"] = 00.85,
						["Attack04.ogg"] = 00.96,
						["Attack05.ogg"] = 01.10,
						["Attack06.ogg"] = 01.07,
						["Wound01.ogg"] = 00.97,
						["Wound02.ogg"] = 00.88,
						["Wound03.ogg"] = 00.77,
						["WoundCrit01.ogg"] = 01.39,
						["WoundCrit02.ogg"] = 01.35,
					},
					["BTPRLUDE_"] = {
						["Illidan01.ogg"] = 11.55,
						["Illidan02.ogg"] = 19.42,
						["Illidan03.ogg"] = 20.60,
					},
					["VO_"] = {
						["ILLIDAN_"] = {
							["Attack01.OGG"] = 00.28,
							["Attack02.OGG"] = 00.37,
							["Attack03.OGG"] = 00.35,
							["Attack04.OGG"] = 00.33,
							["Attack05.OGG"] = 00.29,
							["Attack06.OGG"] = 00.46,
							["Attack07.OGG"] = 00.37,
							["Attack08.OGG"] = 00.47,
							["Attack09.OGG"] = 00.58,
							["Attack10.OGG"] = 00.63,
							["AttackCrit01.OGG"] = 02.46,
							["AttackCrit02.OGG"] = 02.62,
							["AttackCrit03.OGG"] = 01.49,
							["AttackCrit04.OGG"] = 01.43,
							["AttackCrit05.OGG"] = 01.59,
							["Death01.OGG"] = 03.15,
				