local addonName, L = ...

GlootOptions = {}
GlootOptions.panel = CreateFrame("Frame", L["GrindLootOptions"], UIParent, "InsetFrameTemplate")
GlootOptions.events = {}

GlootOptions.config = CreateFrame("Frame", nil, UIParent)
GlootOptions.config.name = "GrindLoot v" .. DefaultGrindLootOptions["Version"]
GlootOptions.config:SetWidth(420)
GlootOptions.config:SetHeight(400)
GlootOptions.config:SetToplevel(true)
GlootOptions.config:Hide()

OriginalLoot = LootSlot;
function AutoConfirmBoP_LootSlot(slot)
    OriginalLoot(slot)
    ConfirmLootSlot(slot)
end

OriginalOpenBackpack = OpenBackpack
function OpenBackpack(...)
    if next(throwAway) ~= nil then
        GlootOptions.cleanTheBags()
    end

    OriginalOpenBackpack(...)
end

OriginalOpenBag = OpenBag
function OpenBag(bagID, ...)
    if next(throwAway) ~= nil then
        GlootOptions.cleanTheBags()
    end
    OriginalOpenBag(bagID, ...)
end

function GlootOptions.events:LOOT_OPENED(autoLoot)
    if (GrindLootOptions["Enabled"] ~= true) then
        return
    end

    if (autoLoot == 1) then
        return
    end

    if (GetOptOutOfLoot() == 1) then
        return
    end

    LootIt()
end

function GlootCommandHandler(msg)
    if (not msg or msg == "") then msg = "config" end
    local cmd, params = strsplit(" ", msg:lower())
    if (cmd == "config") then
        if (InCombatLockdown()) then
            return
        else
            GlootOptions.cleanTheBags()
            InterfaceOptionsFrame_OpenToCategory(GlootOptions.config.name)
            InterfaceOptionsFrame_OpenToCategory(GlootOptions.config.name)
        end
    end
    if (cmd == "debug") then
        GrindLootDebug = GrindLootDebug == false
        if (GrindLootDebug) then
            GMessage("Debug mode is ON")
        else
            GMessage("Debug mode is OFF")
        end
    end
end

function GlootOptions.cleanTheBags()
    local bagID;
    local slotID;
    local isinbag = {};

    for bagID = 0, 4 do
        local bagCount = GetContainerNumSlots(bagID)
        if bagCount > 0 then
            for slotID = 1, bagCount do
                local bagItemID = GetContainerItemID(bagID, slotID)
                if bagItemID ~= nil then
                    if (throwAway[bagItemID]) then
                        local itemName, itemLink2, itemRarity = GetItemInfo(bagItemID)
                        if (itemRarity < 2) then
                            if (GrindLootDebug) then
                                print("throw away ", itemLink2)
                            end
                            PickupContainerItem(bagID, slotID)
                            DeleteCursorItem()
                        end
                    else
                        isinbag[bagItemID] = true
                    end
                end
            end
        end
    end
    if next(throwAway) ~= nil then
        for k in pairs(throwAway) do
            throwAway[k] = nil
        end
    end

    return isinbag
end

function LootIt()
    local lootSlot;
    local isinbag = GlootOptions.cleanTheBags()

    local cnt = GetNumLootItems()
    local isFishingLoot = IsFishingLoot()

    local prof1, prof2, archaeology, fishing, cooking, firstAid = GetProfessions()
    if (prof1) then
        local _, _, _, _, _, _, skillLineProf1 = GetProfessionInfo(prof1)
    end
    if (prof2) then
        local _, _, _, _, _, _, skillLineProf2 = GetProfessionInfo(prof2)
    end

    for lootSlot = 1, cnt do
        local canloot = false

        local lootType = GetLootSlotType(lootSlot)
        if ((lootType == LOOT_SLOT_MONEY) or (lootType == LOOT_SLOT_CURRENCY)) then --money or other currency item
            canloot = true;
            if (GrindLootDebug) then
                print("currency")
            end
        end

        if ((canloot == false) and (LootSlotHasItem(lootSlot))) then
            local itemID, itemLink2, itemName, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, armorSlot, textureID, vendorPrice, itemCategory, categoryVersion
            local itemID, itemType, itemSubType, itemEquipLoc, iconFileDataID, itemClassID, itemSubClassID
            local itemLink = GetLootSlotLink(lootSlot)

            if (itemLink) then
                itemName, itemLink2, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, armorSlot, textureID, vendorPrice, itemCategory, categoryVersion = GetItemInfo(itemLink)
                itemID, itemType, itemSubType, itemEquipLoc, iconFileDataID, itemClassID, itemSubClassID = GetItemInfoInstant(itemLink)

                if (itemID ~= nil) then
                    itemID = tonumber(itemID)
                else
                    itemID = 0
                end

                local sellToVendorPrice = vendorPrice;
                if sellToVendorPrice == nil then sellToVendorPrice = 0; end
                if GetSellValue then sellToVendorPrice = GetSellValue(itemID) * itemStackCount; end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_QUESTITEM) then
                    canloot = true; --quest item
                    if (GrindLootDebug) then
                        print("quest item")
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_BATTLEPET) then
                    canloot = true; --pet
                    if (GrindLootDebug) then
                        print("pet")
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_GLYPH) then
                    canloot = true; --glyph
                    if (GrindLootDebug) then
                        print("glyph")
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_ITEM_ENHANCEMENT) then
                    canloot = true; --enchanted scroll
                    if (GrindLootDebug) then
                        print("enchanted scroll")
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_KEY) then
                    canloot = true; --it's a key
                    if (GrindLootDebug) then
                        print("key")
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_QUALITY_ARTIFACT) then
                    canloot = true; --artifacts
                    if (GrindLootDebug) then
                        print("artifact")
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_TRADEGOODS) and (GrindLootOptions["GatheringMode"] == true) then
                    canloot = true; --reagent
                    if (GrindLootDebug) then
                        print("reagent and gathering mode")
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_TRADEGOODS) then
                    if (skillLineProf1) and (GLOOT_TRADE_SKILL_LOOT[skillLineProf1]) and (GLOOT_TRADE_SKILL_LOOT[skillLineProf1][itemSubClassID]) then
                        canloot = true; --reagent for a skill we have
                        if (GrindLootDebug) then
                            print("reagent for 1st primatry profession")
                        end
                    end
                    if (skillLineProf2) and (GLOOT_TRADE_SKILL_LOOT[skillLineProf2]) and (GLOOT_TRADE_SKILL_LOOT[skillLineProf2][itemSubClassID]) then
                        canloot = true; --reagent for a skill we have
                        if (GrindLootDebug) then
                            print("reagent for 2nd primatry profession")
                        end
                    end
                    if (cooking) and (GLOOT_TRADE_SKILL_LOOT[GLOOT_COOKING]) and (GLOOT_TRADE_SKILL_LOOT[GLOOT_COOKING][itemSubClassID]) then
                        canloot = true; --reagent for cooking - and we know cooking - we like food
                        if (GrindLootDebug) then
                            print("reagent for cooking")
                        end
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_GEM) then
                    canloot = true; --gem, artifact relic
                    if (GrindLootDebug) then
                        print("gem stuff")
                    end
                end

                if (canloot == false) and ((itemClassID == LE_ITEM_CLASS_MISCELLANEOUS) and (itemSubClassID >= LE_ITEM_QUALITY_EPIC)) then
                    canloot = true; --archeology gorian artifact - other epic_level stuff
                    if (GrindLootDebug) then
                        print("epic junk")
                    end
                end

                if (canloot == false) and (itemClassID == LE_ITEM_CLASS_RECIPE) then
                    canloot = true; --recipe
                    if (GrindLootDebug) then
                        print("recipe")
                    end
                end

                if (canloot == false) then
                    if (GemChip[itemID]) then
                        canloot = true; --gem chip
                        print(GemChip[itemID] .. " " .. L["Gem Chip"] .. " |T" .. textureID .. ":24|t") --special display of color for gem chips
                    end
                end

                if (canloot == false) then
                    local _, _, _, itemRarity = GetLootSlotInfo(lootSlot)
                    if (GrindLootOptions["MinimumRarity"] > 0) and (itemRarity >= GrindLootOptions["MinimumRarity"]) then
                        canloot = true; --rarity based loot
                        if (GrindLootDebug) then
                            print("rarity level")
                        end
                    end

                    if (GrindLootOptions["LootValuable"]) and (GrindLootOptions["MinimumValue"] > 0) and (sellToVendorPrice >= GrindLootOptions["MinimumValue"]) then
                        canloot = true; --vendor value based loot
                        if (GrindLootDebug) then
                            print('valuable')
                            print(itemLink2, ' ', GrindLootOptions["MinimumValue"], '<', sellToVendorPrice)
                        end
                    end
                end

                if (canloot == false) then
                    if (isinbag[itemID]) then
                        canloot = true; --loot if it is already in bags
                        if (GrindLootDebug) then
                            print("have in bag already")
                        end
                    end
                end

                if (canloot == false) then --badly marked quest items
                    local tip = myTooltipFromTemplate or CreateFrame("GAMETOOLTIP", "myTooltipFromTemplate", nil, "GameTooltipTemplate")
                    tip:UnregisterAllEvents()
                    tip:SetOwner(WorldFrame, "ANCHOR_NONE")
                    tip:SetHyperlink(itemLink)
                    local lines = tip:NumLines()
                    for i = 1, lines do
                        local tooltipline = _G["myTooltipFromTemplateTextLeft" .. i]:GetText();
                        if ((tooltipline == L["This Item Begins a Quest"]) or (tooltipline == L["Quest Item"]) or (tooltipline == L["Binds when picked up"])) then
                            canloot = true;
                            if (GrindLootDebug) then
                                print("badly tagged quest item")
                            end
                            break;
                        end
                    end
                end

                if (canloot == false) then
                    if (GrindLootOptions["GatheringModeNoJunk"] == true) then
                        throwAway[itemID] = itemID
                        canloot = true
                        if (GrindLootDebug) then
                            print(itemLink2, " is junk but throw away activated")
                        end
                    end
                    if (canloot == false) and (isFishingLoot) then
                        throwAway[itemID] = itemID
                        canloot = true
                        if (GrindLootDebug) then
                            print("we dont want it but is fishing loot")
                        end
                    end

                    --this is either junk or a missed item that should be auto-looted?
                    --                    print("itemID=", itemID)
                    --                    print("itemClassID=", itemClassID) --
                    --                    print("itemSubClassID=", itemSubClassID)
                    --                    print("ALL=", itemID, itemType, itemSubType, itemEquipLoc, iconFileDataID, itemClassID, itemSubClassID)
                end
            else
                print(L["No link for lootType "], lootType);
            end
        end

        if (canloot == true) then
            LootSlot(lootSlot);
        end
    end

    if (GrindLootOptions["CloseLootWindow"]) then
        CloseLoot()
        if (GrindLootDebug) then
            print("autoclose loot window")
        end
    end
end

function print_r(t)
    local print_r_cache = {}
    local function sub_print_r(t, indent)
        if (print_r_cache[tostring(t)]) then
            print(indent .. "*" .. tostring(t))
        else
            print_r_cache[tostring(t)] = true
            if (type(t) == "table") then
                for pos, val in pairs(t) do
                    if (type(val) == "table") then
                        print(indent .. "[" .. pos .. "] => " .. tostring(t) .. " {")
                        sub_print_r(val, indent .. string.rep(" ", string.len(pos) + 8))
                        print(indent .. string.rep(" ", string.len(pos) + 6) .. "}")
                    elseif (type(val) == "string") then
                        print(indent .. "[" .. pos .. '] => "' .. val .. '"')
                    else
                        print(indent .. "[" .. pos .. "] => " .. tostring(val))
                    end
                end
            else
                print(indent .. tostring(t))
            end
        end
    end

    if (type(t) == "table") then
        print(tostring(t) .. " {")
        sub_print_r(t, "  ")
        print("}")
    else
        sub_print_r(t, "  ")
    end
    print()
end

local function toboolean(value)
    if value and value ~= "0" and value ~= 0 then
        return true
    end
    return false
end

-- ***********************************************************************************************

function GlootOptions.GUIMinimumRarityClick(self, arg1)
    GrindLootOptionsTmp["MinimumRarity"] = arg1;
    GlootOptions.config.GUIMinimumRarity:SetValue(arg1);
    UIDropDownMenu_SetSelectedValue(GlootOptions.config.GUIMinimumRarity, GrindLootOptionsTmp["MinimumRarity"]);
    UIDropDownMenu_SetText(GlootOptions.config.GUIMinimumRarity, RarityNames[GrindLootOptionsTmp["MinimumRarity"]]);
end

function MakeRarityButton(info, MenuValue)
    info.text = RarityNames[MenuValue]
    info.value = MenuValue
    info.arg1 = MenuValue
    info.tooltipTitle = RarityNames[MenuValue]
    if MenuValue == 0 then
        info.tooltipText = info.text
    else
        info.tooltipText = L["Loot only"] .. " " .. info.text .. " " .. L["or better"]
    end
    UIDropDownMenu_AddButton(info);
end

function GUIMinimumRarity_Initialize(self)
    local info = UIDropDownMenu_CreateInfo();
    info.notCheckable = true;
    info.func = GlootOptions.GUIMinimumRarityClick
    MakeRarityButton(info, 0);
    MakeRarityButton(info, 1);
    MakeRarityButton(info, 2);
    MakeRarityButton(info, 3);
    MakeRarityButton(info, 4);
end

function GlootOptions.GUIMinimumRarity_Populate(self)
    self.defaultValue = DefaultGrindLootOptions["MinimumRarity"]
    self.oldValue = GrindLootOptions["MinimumRarity"]
    self.value = self.oldValue or self.defaultValue
    self.tooltip = L["Loot only"] .. " " .. RarityNames[self.value] .. " " .. L["or better"]

    UIDropDownMenu_SetWidth(self, 100);
    UIDropDownMenu_Initialize(self, GUIMinimumRarity_Initialize);
    UIDropDownMenu_SetSelectedValue(self, self.value);
    UIDropDownMenu_SetText(self, RarityNames[self.value])

    self.SetValue = function(self, value)
        self.value = value
        UIDropDownMenu_SetSelectedValue(self, value);
        self.tooltip = L["Loot only"] .. " " .. RarityNames[self.value] .. " " .. L["or better"]
    end;
    self.GetValue = function(self)
        return UIDropDownMenu_GetSelectedValue(self)
    end
    self.RefreshValue = function(self)
        UIDropDownMenu_Initialize(self, GUIMinimumRarity_Initialize);
        UIDropDownMenu_SetSelectedValue(self, self.value);
    end
end

-- ***********************************************************************************************

function GlootOptions.events:ADDON_LOADED(addonName)
    if (addonName == "GrindLoot") then
        GlootOptions.panel:UnregisterEvent("ADDON_LOADED");

        GMessage("v" .. DefaultGrindLootOptions["Version"] .. " " .. L["Loaded"])

        if (GrindLootOptions == nil) then
            GrindLootOptions = {}
            for k, v in pairs(DefaultGrindLootOptions) do GrindLootOptions[k] = v; end
            LootSlot = OriginalLoot;
            return;
        end

        if ((GrindLootOptions["Version"] == nil) or (GrindLootOptions["Version"] < DefaultGrindLootOptions["Version"])) then
            for k, v in pairs(DefaultGrindLootOptions) do GrindLootOptions[k] = v; end
            GMessage(L["Old options detected - they have been set to default values"]);
            LootSlot = OriginalLoot;
        end

        if (GrindLootOptions["AutoConfirm"] == true) then
            LootSlot = AutoConfirmBoP_LootSlot;
        else
            GrindLootOptions["AutoConfirm"] = false
        end

        SLASH_GLOOT1 = "/gloot"
        SLASH_GLOOT2 = "/grindloot"
        SLASH_GLOOT3 = "/gl"
        SlashCmdList["GLOOT"] = function(msg)
            GlootCommandHandler(msg)
        end

        GlootOptions:createGlootOptionsPanel()

        InterfaceOptions_AddCategory(GlootOptions.config)
    end
end

function GlootOptions:populateGlootOptionsPanel(opts)
    self.config.enableCheck:SetChecked(opts["Enabled"])

    GlootOptions.GUIMinimumRarity_Populate(self.config.GUIMinimumRarity)

    self.config.GUIGatherModeCheck:SetChecked(opts["GatheringMode"])
    self.config.GUIGatherModeNoJunkCheck:SetChecked(opts["GatheringModeNoJunk"])

    self.config.GUILootValuableCheck:SetChecked(opts["LootValuable"])
    MoneyInputFrame_SetCopper(self.config.GUILootValuableMinimumValue, opts["MinimumValue"])

    self.config.GUIAutoConfirmCheck:SetChecked(opts["AutoConfirm"])

    self.config.GUICloseLootWindowCheck:SetChecked(opts["CloseLootWindow"])
end

function GlootOptions:createGlootOptionsPanel()
    GlootOptions.config.reset = CreateFrame("Button", nil, GlootOptions.config, "OptionsButtonTemplate")
    GlootOptions.config.reset:SetWidth(160)
    GlootOptions.config.reset:SetPoint("BOTTOMLEFT", GlootOptions.config, "BOTTOMLEFT", 10, 10)
    GlootOptions.config.reset:SetText(L["RESET SETTINGS"])
    GlootOptions.config.reset:SetScript("OnClick", function()
        GlootOptions.config:default()
        GlootOptions.config:refresh()
    end)

    GlootOptions.config.GUIinfoHeader = GlootOptions.config:CreateFontString("infoHeader", "OVERLAY");
    GlootOptions.config.GUIinfoHeader:SetFontObject("OptionsFontLarge");
    GlootOptions.config.GUIinfoHeader:SetText(L["infoHeader"]);
    GlootOptions.config.GUIinfoHeader:SetPoint("TOPLEFT", GlootOptions.config, "TOPLEFT", 25, -20);

    GlootOptions.config.GUIinfoText = GlootOptions.config:CreateFontString("infoText", "OVERLAY");
    GlootOptions.config.GUIinfoText:SetFontObject("OptionsFontHighlightSmall");
    GlootOptions.config.GUIinfoText:SetText(L["infoText"]);
    GlootOptions.config.GUIinfoText:SetPoint("TOPLEFT", GlootOptions.config.GUIinfoHeader, "BOTTOMLEFT", 0, -10);
    GlootOptions.config.GUIinfoText:SetWidth(400);
    GlootOptions.config.GUIinfoText:SetJustifyH("LEFT");

    GlootOptions.config.enableCheck = CreateFrame("CheckButton", "GlootEnableCheck", GlootOptions.config, "GlootInterfaceOptionsCheckButtonTemplate")
    _G["GlootEnableCheckText"]:SetText(L["Enabled"])
    GlootOptions.config.enableCheck:SetPoint("TOPLEFT", GlootOptions.config.GUIinfoText, "BOTTOMLEFT", 0, -10)
    GlootOptions.config.enableCheck.tooltip = L["Enable or disable GrindLoot"];
    function GlootOptions.config.enableCheck.setFunc(state)
        GrindLootOptionsTmp["Enabled"] = toboolean(state)
    end

    GlootOptions.config.GUIMinimumRarityHeader = GlootOptions.config:CreateFontString("RarityHeader", "OVERLAY")
    GlootOptions.config.GUIMinimumRarityHeader:SetFontObject("OptionsFontLarge")
    GlootOptions.config.GUIMinimumRarityHeader:SetText(L["Rarity Looting"])
    GlootOptions.config.GUIMinimumRarityHeader:SetPoint("TOPLEFT", GlootOptions.config.enableCheck, "BOTTOMLEFT", 0, -20)

    GlootOptions.config.GUIMinimumRarity = CreateFrame("Frame", "RarityDropDown", GlootOptions.config, "UIDropDownMenuTemplate")
    GlootOptions.config.GUIMinimumRarity:SetPoint("TOPLEFT", GlootOptions.config.GUIMinimumRarityHeader, "BOTTOMLEFT", -20, -5)
    GlootOptions.config.GUIMinimumRarity.type = CONTROLTYPE_DROPDOWN
    GlootOptions.config.GUIMinimumRarity:RegisterEvent("PLAYER_ENTERING_WORLD")
    BlizzardOptionsPanel_RegisterControl(GlootOptions.config.GUIMinimumRarity, GlootOptions.config)

    GlootOptions.config.GUIMinimumRarity:SetScript("OnEnter", function(self)
        if (not self.isDisabled) then
            GameTooltip:SetOwner(self, "ANCHOR_TOPRIGHT");
            GameTooltip:SetText(self.tooltip, nil, nil, nil, nil, true);
        end
    end)
    GlootOptions.config.GUIMinimumRarity:SetScript("OnLeave", GameTooltip_Hide)

    self.config.GUIGatherModeCheck = CreateFrame("CheckButton", "GlootGatheringModeCheck", self.config, "GlootInterfaceOptionsCheckButtonTemplate")
    _G["GlootGatheringModeCheckText"]:SetText(L["GatheringMode"])
    self.config.GUIGatherModeCheck:SetPoint("TOPLEFT", self.config.GUIMinimumRarity, "BOTTOMLEFT", 20, -20)
    self.config.GUIGatherModeCheck.tooltip = L["Enable or disable Gathering mode"];
    function self.config.GUIGatherModeCheck.setFunc(state)
        GrindLootOptionsTmp["GatheringMode"] = toboolean(state)
    end

    self.config.GUIGatherModeNoJunkCheck = CreateFrame("CheckButton", "GlootGatheringModeNoJunkCheck", self.config, "GlootInterfaceOptionsCheckButtonTemplate")
    _G["GlootGatheringModeNoJunkCheckText"]:SetText(L["GatheringModeNoJunk"])
    self.config.GUIGatherModeNoJunkCheck:SetPoint("TOPLEFT", self.config.GUIGatherModeCheck, "BOTTOMLEFT", 0, -10)
    self.config.GUIGatherModeNoJunkCheck.tooltip = L["Throw away unwanted items auto looted during gathering mode"];
    function self.config.GUIGatherModeNoJunkCheck.setFunc(state)
        GrindLootOptionsTmp["GatheringModeNoJunk"] = toboolean(state)
    end

    self.config.GUILootValuableCheck = CreateFrame("CheckButton", "GlootLootValuableCheck", self.config, "GlootInterfaceOptionsCheckButtonTemplate")
    _G["GlootLootValuableCheckText"]:SetText(L["LootValuable"])
    self.config.GUILootValuableCheck:SetPoint("TOPLEFT", self.config.GUIGatherModeNoJunkCheck, "BOTTOMLEFT", 0, -30)
    self.config.GUILootValuableCheck.tooltip = L["Enable or disable looting valuable trash items"];
    function self.config.GUILootValuableCheck.setFunc(state)
        GrindLootOptionsTmp["LootValuable"] = toboolean(state)
        if (GrindLootOptionsTmp["LootValuable"]) then
            _G["GlootLootValuableMinimumValueGold"]:Enable();
            _G["GlootLootValuableMinimumValueSilver"]:Enable();
            _G["GlootLootValuableMinimumValueCopper"]:Enable();
        else
            _G["GlootLootValuableMinimumValueGold"]:Disable();
            _G["GlootLootValuableMinimumValueSilver"]:Disable();
            _G["GlootLootValuableMinimumValueCopper"]:Disable();
        end
    end

    self.config.GUILootValuableMinimumValue = CreateFrame("Frame", "GlootLootValuableMinimumValue", self.config, "MoneyInputFrameTemplate")
    self.config.GUILootValuableMinimumValue:SetPoint("TOPLEFT", self.config.GUILootValuableCheck, "TOPRIGHT", 0, -30)

    self.config.GUIAutoConfirmCheck = CreateFrame("CheckButton", "GlootAutoConfirmCheck", self.config, "GlootInterfaceOptionsCheckButtonTemplate")
    _G["GlootAutoConfirmCheckText"]:SetText(L["AutoConfirm"])
    self.config.GUIAutoConfirmCheck:SetPoint("TOPLEFT", self.config.GUILootValuableCheck, "BOTTOMLEFT", 0, -50)
    self.config.GUIAutoConfirmCheck.tooltip = L["Automatically confirm BoP items"];
    function self.config.GUIAutoConfirmCheck.setFunc(state)
        GrindLootOptionsTmp["AutoConfirm"] = toboolean(state)
    end

    self.config.GUICloseLootWindowCheck = CreateFrame("CheckButton", "GlootCloseLootWindowCheck", self.config, "GlootInterfaceOptionsCheckButtonTemplate")
    _G["GlootCloseLootWindowCheckText"]:SetText(L["CloseLootWindow"])
    self.config.GUICloseLootWindowCheck:SetPoint("TOPLEFT", self.config.GUIAutoConfirmCheck, "BOTTOMLEFT", 0, -30)
    self.config.GUICloseLootWindowCheck.tooltip = L["Automatically close the loot window after autolooting even if it is not empty"];
    function self.config.GUICloseLootWindowCheck.setFunc(state)
        GrindLootOptionsTmp["CloseLootWindow"] = toboolean(state)
    end
end

GlootOptions.panel:SetScript("OnEvent", function(self, event, ...)
    if (GlootOptions.events[event]) then
        GlootOptions.events[event](self, ...)
    end
end);
for k, v in pairs(GlootOptions.events) do
    GlootOptions.panel:RegisterEvent(k);
end

function GlootOptions.config:refresh(...)
    GrindLootOptionsTmp = {}
    for k, v in pairs(GrindLootOptions) do GrindLootOptionsTmp[k] = v; end
    GlootOptions:populateGlootOptionsPanel(GrindLootOptionsTmp)
end

function GlootOptions.config:default()
    GrindLootOptions = {}
    for k, v in pairs(DefaultGrindLootOptions) do GrindLootOptions[k] = v; end

    GlootOptions:setLootSlot()
end

function GlootOptions.config:cancel(...)
    GrindLootOptionsTmp = {}
end

function GlootOptions.config:okay(...)
    GrindLootOptions = {}
    for k, v in pairs(GrindLootOptionsTmp) do GrindLootOptions[k] = v; end
    GrindLootOptions["MinimumValue"] = MoneyInputFrame_GetCopper(GlootOptions.config.GUILootValuableMinimumValue)

    GlootOptions:setLootSlot()
end

function GlootOptions:setLootSlot()
    if (GrindLootOptions["AutoConfirm"] == true) then
        LootSlot = AutoConfirmBoP_LootSlot;
    else
        if (LootSlot ~= OriginalLoot) then
            LootSlot = OriginalLoot
        end
    end
end