--
--	Grail NPCs
--	Written by scott@mithrandir.com
--
--	Version History
--		Stopped keeping history as it was not maintained.
--
--	Each NPC value is a table that can contain:
--		[1]	code information (see below) like map location
--		[2] optional friendly notes
--		[3] optional faction association
--
--	NPC Codes
--		A:npcId			npcId that is what Blizzard returns for this alias NPC
--		Created			indicates item is created by player
--		D:<npc list>	comma separated list of NPC IDs that drop this item
--		H<holidayCode>	holidayCode is a single character indicating the holiday the NPC is available
--		K:<quest list>	comma separated list of quest IDs for which this is killed
--		Mailbox			indicates item in a mailbox (any map area)
--		Mailbox<mapId>	indicates item in a mailbox in the specified map area
--		N:npcId			npcId whose name is to be used for this NPC
--		Near			indicates the NPC is nearby (any map area)
--		Near<mapId>		indicates the NPC is nearby in the specified map area
--		Preowned		indicates item is already owned
--		Q:<quest list>	comma separated list of quest IDs to which this is associated
--		Self			special NPC indicator for Self (the player)
--		X				indicates NPC is in heroic only
--		Z<mapId>		indicates NPC found in the map area
--		anything else should be the format (without spaces):
--			mapId [mapLevel] : xx.xx , yy.yy > realMapId
--		the "[mapLevel]" is only required for maps with levels, most do not need it
--		the "> realMapId" indicates the coordinates are in a map that contains the realMap...this allows an outer map to show a point for maps that are contained within
--
--	Known issues
--
--
--	Alliance Garrison small plot top step locations:
--		18:	971:46.99,59.27
--		19:	971:50.03,57.75
--		20:	971:51.19,63.58
--	Alliance Garrison medium plot basic entrance locations:
--		22:	971:35.53,49.36
--		25: 971:51.21,47.04
--	Alliance Garrison large plot basic entrance locations:
--		23:	971:45.25,42.49
--		24:	971:40.09,56.58
--
--	Horde Garrison small plot top step locations:
--		18:	976:52.44,37.06
--		19:	976:48.38,33.59
--		20: 976:52.59,40.81
--	Horde Garrison medium plot basic entrance locations:
--		22: 976:51.43,57.39
--		25:	976:57.75,28.14
--	Horde Garrison large plot basic entrance locations:
--		23: 976:58.88,49.06
--		24: 976:60.36,36.51
--
--	Dungeon entrances:
--		Ulduar					495:41.57,17.83
--		Thunder					928:63.73,32.23
--		SM Graveyard 762[1]		20:84.87,30.61
--		SM Cathedral 762[4]		20:85.35,30.62
--		SM Library 762[2]		20:85.29,32.14
--		SM Armory 762[3]		20:85.62,31.59
--		Mechanar				479:70.59,69.73
--		Tempest Keep			479:73.73,63.74
--		Botanica				479:71.72,55.02
--		Arcatraz				479:74.37,57.74
--		Auchanai Crypts			478:34.34,65.61
--		Sethekk Halls			478:44.91,65.61
--		Shadow Labyrinth		478:39.63,73.54
--		Mana Tombs				478:39.63,57.67
--		Blood Furnace			465:46.03,51.79
--		Shattered Halls			465:47.68,51.99
--		Hellfire Ramparts		465:47.63,53.57
--		Black Temple			473:71.05,46.45
--		Grim Batol				700:19.18,54.01
--		Gate of the Setting Sun	811:15.84,74.39
--		Shado-Pan Monastery		809:36.66,47.33
--		Temple of Jade Serpent	806:56.18,57.87
--		Auchindoun				946:46.31,73.93
--		Bloodmaul Slag Mines	941:49.85,24.75
--		Zul Aman				463:82.14,64.35
--
--	UTF-8 file
--
Grail_NPCs_File_Version = 015

if Grail.npcsVersionNumber < Grail_NPCs_File_Version then
Grail.npcsVersionNumber = Grail_NPCs_File_Version

local originalMem = gcinfo()

Grail.npcs = {}

local _, release, _, interface = GetBuildInfo()
release = tonumber(release)
interface = tonumber(interface)

local G = Grail.npcs

if release >= 0 then
G[-541021]={'1021:81.40,44.78 N:0'}
G[-531021]={'1021:58.76,28.30 N:0'}
G[-521021]={'1021:57.80,45.04 N:0'}
G[-511021]={'1021:48.04,16.93 N:0'}
G[-501021]={'1021:43.46,36.78 N:0'}
G[-491021]={'1021:66.34,17.32 N:0'}
G[-481021]={'1021:33.12,33.35 N:0'}
G[-471021]={'1021:53.46,14.86 N:0'}
G[-461021]={'1021:73.02,30.25 N:0'}
G[-451021]={'1021:49.02,55.52 N:0'}
G[-441021]={'1021:31.04,60.45 N:0'}
G[-431021]={'1021:59.24,45.53 N:0'}
G[-421021]={'1021:31.17,61.61 N:0'}
G[-411021]={'1021:55.10,50.56 N:0'}
G[-401021]={'1021:31.10,59.96 N:0'}
G[-391021]={'1021:58.60,28.37 N:0'}
G[-391015]={'1015:61.39,43.12 N:0'}
G[-381021]={'1021:82.09,48.07 N:0'}
G[-381015]={'1015:56.41,66.79 N:0'}
G[-371021]={'1021:41.25,77.84 N:0'}
G[-371015]={'1015:59.18,41.73 N:0'}
G[-361021]={'1021:54.13,65.01 N:0'}
G[-361015]={'1015:44.88,83.47 N:0'}
G[-351021]={'1021:50.96,42.31 N:0'}
G[-351018]={'1018:67.35,38.79 N:0'}
G[-351015]={'1015:32.25,29.67 N:0'}
G[-341021]={'1021:53.81,14.75 N:0'}
G[-341018]={'1018:42.62,51.25 N:0'}
G[-341015]={'1015:57.20,16.72 N:0'}
G[-331021]={'1021:50.78,41.73 N:0'}
G[-331018]={'1018:38.26,61.57 N:0'}
G[-331017]={'1017:66.20,47.78 N:0'}
G[-331015]={'1015:60.61,71.54 N:0'}
G[-321021]={'1021:38.60,46.63 N:0'}
G[-321018]={'1018:57.38,54.53 N:0'}
G[-321017]={'1017:48.45,21.25 N:0'}
G[-321015]={'1015:67.27,26.95 N:0'}
G[-311021]={'1021:47.13,69.85 N:0'}
G[-311018]={'1018:40.67,60.32 N:0'}
G[-311017]={'1017:38.74,54.78 N:0'}
G[-311015]={'1015:46.00,16.07 N:0'}
G[-301021]={'1021:38.27,60.08 N:0'}
G[-301018]={'1018:34.14,60.32 N:0'}
G[-301017]={'1017:55.41,42.60 N:0'}
G[-301015]={'1015:51.14,37.12 N:0'}
G[-291033]={'1033:49.51,72.54 N:0'}
G[-291021]={'1021:53.75,65.76 N:0'}
G[-291018]={'1018:49.49,77.09 N:0'}
G[-291017]={'1017:44.20,67.64 N:0'}
G[-291015]={'1015:54.30,44.40 N:0'}
G[-281033]={'1033:30.32,60.44 N:0'}
G[-281024]={'1024:46.18,27.88 N:0'}
G[-281021]={'1021:47.82,67.33 N:0'}
G[-281018]={'1018:55.57,78.15 N:0'}
G[-281017]={'1017:74.17,88.98 N:0'}
G[-281015]={'1015:65.69,48.40 N:0'}
G[-271033]={'1033:45.91,74.74 N:0'}
G[-271024]={'1024:40.15,62.90 N:0'}
G[-271021]={'1021:49.11,55.55 N:0'}
G[-271018]={'1018:48.92,39.78 N:0'}
G[-271017]={'1017:61.87,90.26 N:0'}
G[-271015]={'1015:64.19,19.32 N:0'}
G[-261033]={'1033:47.36,75.28 N:0'}
G[-261024]={'1024:44.67,9.95 N:0'}
G[-261021]={'1021:66.67,29.60 N:0'}
G[-261018]={'1018:65.79,51.78 N:0'}
G[-261017]={'1017:59.87,42.16 N:0'}
G[-261015]={'1015:56.26,16.53 N:0'}
G[-251033]={'1033:20.46,44.67 N:0'}
G[-251024]={'1024:25.57,42.29 N:0'}
G[-251021]={'1021:79.17,40.87 N:0'}
G[-251018]={'1018:50.23,46.54 N:0'}
G[-251017]={'1017:60.90,68.12 N:0'}
G[-251015]={'1015:48.27,25.15 N:0'}
G[-241033]={'1033:31.22,69.18 N:0'}
G[-241024]={'1024:46.44,60.98 N:0'}
G[-241021]={'1021:51.60,42.16 N:0'}
G[-241018]={'1018:39.98,90.56 N:0'}
G[-241017]={'1017:69.19,45.91 N:0'}
G[-241015]={'1015:56.91,63.49 N:0'}
G[-231170]={'1170:64.54,56.32 N:0'}
G[-231033]={'1033:59.74,60.84 N:0'}
G[-231024]={'1024:43.79,58.09 N:0'}
G[-231021]={'1021:38.56,60.16 N:0'}
G[-231018]={'1018:65.13,59.18 N:0'}
G[-231017]={'1017:55.39,26.06 N:0'}
G[-231015]={'1015:35.36,50.36 N:0'}
G[-221170]={'1170:46.94,66.15 N:0'}
G[-221033]={'1033:27.64,22.70 N:0'}
G[-221024]={'1024:51.06,42.48 N:0'}
G[-221021]={'1021:49.30,67.62 N:0'}
G[-221018]={'1018:25.98,66.45 N:0'}
G[-221017]={'1017:45.20,78.82 N:0'}
G[-221015]={'1015:32.62,54.44 N:0'}
G[-220949]={'949:56.01,6.68 N:0'}
G[-211170]={'1170:32.47,41.01 N:0'}
G[-211033]={'1033:44.93,75.98 N:0'}
G[-211024]={'1024:40.07,13.57 N:0'}
G[-211021]={'1021:45.15,47.95 N:0'}
G[-211018]={'1018:64.72,74.56 N:0'}
G[-211017]={'1017:71.16,47.51 N:0'}
G[-211015]={'1015:58.99,72.96 N:0'}
G[-210949]={'949:59.62,33.29 N:0'}
G[-201170]={'1170:36.70,44.22 N:0'}
G[-201033]={'1033:32.78,79.79 N:0'}
G[-201024]={'1024:28.96,41.60 N:0'}
G[-201021]={'1021:66.90,45.43 N:0'}
G[-201018]={'1018:57.37,80.66 N:0'}
G[-201017]={'1017:75.87,90.12 N:0'}
G[-201015]={'1015:66.04,47.09 N:0'}
G[-200949]={'949:68.63,34.22 N:0'}
G[-191170]={'1170:57.45,30.23 N:0'}
G[-191033]={'1033:45.85,42.58 N:0'}
G[-191024]={'1024:45.78,14.06 N:0'}
G[-191021]={'1021:53.53,74.56 N:0'}
G[-191018]={'1018:51.13,76.22 N:0'}
G[-191017]={'1017:78.04,73.51 N:0'}
G[-191015]={'1015:45.55,32.96 N:0'}
G[-190949]={'949:57.00,35.88 N:0'}
G[-181171]={'1171:77.96,67.41 N:0'}
G[-181170]={'1170:58.69,29.34 N:0'}
G[-181033]={'1033:18.90,23.61 N:0'}
G[-181024]={'1024:36.72,44.31 N:0'}
G[-181021]={'1021:79.02,41.06 N:0'}
G[-181018]={'1018:52.28,6.50 N:0'}
G[-181017]={'1017:79.00,57.81 N:0'}
G[-181015]={'1015:39.73,48.13 N:0'}
G[-180949]={'949:46.38,92.46 N:0'}
G[-171171]={'1171:66.14,52.99 N:0'}
G[-171170]={'1170:62.54,46.11 N:0'}
G[-171033]={'1033:30.07,35.57 N:0'}
G[-171024]={'1024:52.21,79.81 N:0'}
G[-171021]={'1021:45.78,67.64 N:0'}
G[-171018]={'1018:48.17,66.91 N:0'}
G[-171017]={'1017:44.27,48.01 N:0'}
G[-171015]={'1015:37.13,8.68 N:0'}
G[-171014]={'1014[10]:40.19,24.55 N:0'}
G[-170949]={'949:43.10,65.92 N:0'}
G[-170948]={'948:71.80,34.57 N:0'}
G[-161171]={'1171:71.83,68.81 N:0'}
G[-161170]={'1170:52.91,70.00 N:0'}
G[-161033]={'1033:47.46,81.97 N:0'}
G[-161024]={'1024:58.81,69.39 N:0'}
G[-161021]={'1021:45.68,59.13 N:0'}
G[-161018]={'1018:46.36,74.57 N:0'}
G[-161017]={'1017:56.54,30.20 N:0'}
G[-161015]={'1015:63.77,28.50 N:0'}
G[-161014]={'1014[10]:40.23,23.73 N:0'}
G[-160949]={'949:60.88,53.39 N:0'}
G[-160948]={'948:60.45,12.34 N:0'}
G[-151171]={'1171:74.83,62.59 N:0'}
G[-151170]={'1170:27.38,36.25 N:0'}
G[-151033]={'1033:45.82,42.64 N:0'}
G[-151024]={'1024:41.76,72.75 N:0'}
G[-151021]={'1021:38.54,27.03 N:0'}
G[-151018]={'1018:54.96,72.55 N:0'}
G[-151017]={'1017:33.67,50.65 N:0'}
G[-151015]={'1015:47.52,40.56 N:0'}
G[-151014]={'1014[10]:40.22,24.10 N:0'}
G[-150949]={'949:51.36,77.64 N:0'}
G[-150948]={'948:52.98,14.77 N:0'}
G[-150947]={'947:50.41,89.60 N:0'}
G[-150941]={'941:49.15,21.37 N:0'}
G[-141171]={'1171:60.18,22.70 N:0'}
G[-141170]={'1170:55.28,13.84 N:0'}
G[-141033]={'1033:64.22,41.94 N:0'}
G[-141024]={'1024:44.91,66.14 N:0'}
G[-141021]={'1021:68.10,29.14 N:0'}
G[-141018]={'1018:66.77,45.94 1018:54.78,52.78 N:0'}
G[-141017]={'1017:37.07,66.88 N:0'}
G[-141015]={'1015:26.82,49.05 N:0'}
G[-141014]={'1014[10]:40.33,23.94 N:0'}
G[-140949]={'949:49.23,80.94 N:0'}
G[-140948]={'948:39.46,61.66 N:0'}
G[-140947]={'947:63.70,93.94 N:0'}
G[-140941]={'941:42.58,12.62 N:0'}
G[-131171]={'1171:60.68,66.20 N:0'}
G[-131170]={'1170:58.12,29.85 N:0'}
G[-131033]={'1033:23.57,40.19 N:0'}
G[-131024]={'1024:33.59,25.06 N:0'}
G[-131021]={'1021:49.09,55.46 N:0'}
G[-131018]={'1018:39.25,52.58 N:0'}
G[-131017]={'1017:53.39,54.14 N:0'}
G[-131015]={'1015:51.78,44.29 N:0'}
G[-131014]={'1014[10]:40.19,24.71 N:0'}
G[-130950]={'950:55.06,12.38 N:0'}
G[-130949]={'949:44.93,48.23 N:0'}
G[-130948]={'948:75.05,26.11 N:0'}
G[-130947]={'947:42.08,57.34 N:0'}	-- ? 53.12,65.38
G[-130946]={'946:42.79,60.78 N:0'}
G[-130941]={'941:70.11,26.84 N:0'}
G[-130038]={'38:74.10,44.46 N:0','Down in temple'}
G[-121171]={'1171:54.27,25.53 N:0'}
G[-121170]={'1170:40.42,59.65 N:0'}
G[-121135]={'1135:55.01,56.51 N:0'}
G[-121033]={'1033:73.83,52.69 N:0'}
G[-121024]={'1024:41.83,10.54 N:0'}
G[-121021]={'1021:39.05,30.06 N:0'}
G[-121018]={'1018:66.20,44.76 N:0'}
G[-121017]={'1017:37.39,63.52 N:0'}
G[-121015]={'1015:47.67,13.15 N:0'}
G[-121014]={'1014[10]:40.16,25.36 N:0'}
G[-120950]={'950:38.52,39.49 N:0'}
G[-120949]={'949:42.24,63.34 N:0'}
G[-120948]={'948:72.90,32.44 N:0'}
G[-120947]={'947:58.48,32.70 N:0'}
G[-120946]={'946:83.64,30.93 N:0'}
G[-120941]={'941:64.02,16.66 N:0'}
G[-120753]={'753[2]:68.39,64.35 N:0'}
G[-120038]={'38:76.62,41.53 N:0'}
G[-111171]={'1171:57.60,33.83 N:0'}
G[-111170]={'1170:50.03,43.23 N:0'}
G[-111135]={'1135:66.60,64.16 N:0'}
G[-111033]={'1033:34.23,49.44 N:0'}
G[-111024]={'1024:45.37,49.25 N:0'}
G[-111021]={'1021:51.04,54.95 N:0'}
G[-111018]={'1018:59.41,84.12 N:0'}
G[-111017]={'1017:41.51,37.12 N:0'}
G[-111015]={'1015:57.82,43.42 N:0'}
G[-111014]={'1014[10]:40.17,25.20 N:0'}
G[-110971]={'971:33.48,27.74 N:0'}
G[-110950]={'950:39.69,14.87 N:0'}
G[-110949]={'949:52.36,64.17 N:0'}
G[-110948]={'948:70.51,21.94 N:0'}
G[-110947]={'947:58.12,59.79 N:0'}
G[-110946]={'946:73.60,23.92 N:0'}
G[-110941]={'941:66.80,49.53 N:0'}
G[-110857]={'857:45.15,84.88 N:0'}
G[-110753]={'753[2]:66.03,71.46 N:0'}
G[-110038]={'38:77.58,46.02 N:0'}
G[-101171]={'1171:63.08,42.81 N:0'}
G[-101170]={'1170:55.46,63.74 N:0'}
G[-101135]={'1135:55.83,35.54 N:0'}
G[-101033]={'1033:22.79,35.49 N:0'}
G[-101024]={'1024:38.52,39.78 N:0'}
G[-101022]={'1022:65.87,47.27 N:0'}
G[-101021]={'1021:43.70,58.39 N:0'}
G[-101018]={'1018:46.22,67.82 N:0'}
G[-101017]={'1017:42.02,64.49 N:0'}
G[-101015]={'1015:57.99,58.20 N:0'}
G[-101014]={'1014[10]:40.20,24.41 N:0'}
G[-100978]={'978:42.33,81.16 N:0'}
G[-100976]={'976:63.61,45.19 N:0'}
G[-100971]={'971:33.59,30.45 N:0'}
G[-100950]={'950:44.12,74.66 N:0'}
G[-100949]={'949:48.04,55.65 N:0'}
G[-100948]={'948:67.45,21.81 N:0'}
G[-100947]={'947:25.62,32.89 N:0'}
G[-100946]={'946:55.28,23.50 N:0'}
G[-100941]={'941:20.94,57.92 N:0'}
G[-100857]={'857:66.52,29.42 N:0'}
G[-100811]={'811:22.75,27.54 N:0'}
G[-100753]={'753[1]:53.98,21.30 N:0'}
G[-100673]={'673:61.20,44.29 N:0'}
G[-100606]={'606:7.56,34.57 N:0'}
G[-100261]={'261:39.07,46.91 N:0'}
G[-100201]={'201:64.93,16.64 N:0'}
G[-100043]={'43:40.51,53.32 N:0'}
G[-100038]={'38:74.82,49.36 N:0'}
G[-100037]={'37:78.51,35.68 N:0'}
G[-100036]={'36:32.38,39.40 N:0'}
G[-100028]={'28:23.06,35.52 N:0'}
G[-100011]={'11:62.86,61.80 N:0'}
G[0]={'Self'}
G[1]={'1 AdventureGuide'}
G[3]={'807:51.70,48.32'}
G[4]={'893:41.78,71.14 N:100020483'}
G[46]={'30:79.78,55.52'}
G[68]={'301:70.25,83.80'}
G[114]={'39:54,36'}
G[126]={'39:53,11'}
G[171]={'39:53,11'}
G[197]={'864:33.54,52.98'}
G[198]={'864:38.77,43.48 30:49.66,39.40>864','Upstairs'}
G[210]={'34:17.63,28.95'}
G[233]={'39:56.04,31.23'}
G[234]={'39:56.33,47.53'}
G[235]={'39:56.42,30.53'} -- also moves to 39:56.48,30.38
G[240]={'30:42.11,65.93'}
G[241]={'30:42.1,67.2'}
G[244]={'30:34.6,84.4'}
G[246]={'30:34.4,84.3'}
G[247]={'30:43.1,85.8'}
G[248]={'30:34.9,84'}
G[251]={'30:43.1,89.6'}
G[252]={'30:29.9,86'}
G[253]={'30:43.3,65.8'}
G[255]={'30:43.10,85.52'}
G[261]={'30:73.97,72.18'}
G[263]={'34:71.93,46.44'}
G[264]={'34:73.53,46.91'}
G[265]={'34:75.81,45.29'}
G[267]={'34:72.45,46.91'}
G[268]={'34:72.60,47.75'}
G[272]={'34:73.90,43.92'}
G[273]={'34:74.09,44.72'}
G[276]={'34:79.54,47.46'}
G[278]={'30:79.46,68.71'}
G[288]={'34:18.62,58.35'}
G[289]={'34:87.43,35.23'}
G[294]={'30:84.60,69.38'}
G[295]={'30:43.77,65.82'}
G[302]={'34:81.95,59.24'}
G[311]={'34:7.8,34.6'}
G[331]={'301:49.26,87.77','In tower'}
G[332]={'301:81.32,63.51'}
G[342]={'36:22.04,42.70'}
G[344]={'36:28.90,41.12'}
G[352]={'301:70.93,72.48'}
G[375]={'864:39.31,43.77 30:49.81,39.49>864'}
G[376]={'301:49.53,44.60'}
G[379]={'36:15.62,65.33'}
G[382]={'36:31.85,44.90'}
G[384]={'30:84.15,65.49'}
G[392]={'39:30.51,85.61'}
G[415]={'36:29.4,43.4 36:29.4,43.5 36:29.5,43.1 36:29.8,43.6 36:31.1,47.4 36:31.1,47.5'}
G[423]={'36:16.87,57.92'}
G[430]={'36:22,33'}
G[445]={'36:22,33'}
G[446]={'36:22,33'}
G[448]={'30:24.81,95.17'}
G[456]={'39:56.2,7.2'}
G[459]={'864:39.54,55.11 30:49.87,42.65>864'}
G[460]={'27:33.25,38.39>895 895:37.68,37.95'}
G[461]={'301:39.25,84.96','In basement'}
G[464]={'36:15.32,64.59','Top of tower'}
G[466]={'301:69.16,82.73'}
G[469]={'37:47.57,10.26'}
G[513]={'39:40,14'}
G[514]={'30:41.70,65.55'}
G[515]={'39:53,9'}
G[523]={'39:56.6,49.4'}
G[576]={'34:74.20,47.02'}
G[620]={'39:56,31'}
G[658]={'866:65.68,43.56 27:35.56,70.32>866'}
G[661]={'34:75.39,49.01'}
G[663]={'34:75.33,48.01'}
G[715]={'37:44.02,23.29 37:44.18,22.97'} -- 689:35.7,10.7
G[716]={'37:44.24,22.13'}
G[717]={'37:44.50,22.67'}
G[718]={'37:43.72,22.28 37:44.18,22.27'}
G[733]={'37:47.53,10.74'}
G[739]={'37:47.25,11.11'}
G[770]={'37:47.10,10.70'}
G[773]={'37:43.61,23.13'} -- 689:27,77.2
G[786]={'866:42.71,62.24 27:32.06,74.17>866'}
G[793]={'36:32.31,39.43'}
G[821]={'39:56.46,47.57'}
G[823]={'864:35.71,39.76'}
G[837]={'866:60.72,14.68 27:35.6,64.8>866'}
G[878]={'39:56.39,47.35'}
G[888]={'34:45.11,67.02'}
G[895]={'866:63.65,20.09 27:36.1,65.9>866'}
G[900]={'36:28.67,40.95'}
G[911]={'864:40.87,53.80 30:50.24,42.28>864'}
G[912]={'866:61.89,19.01 27:35.8,65.7>866'}
G[914]={'301:79.44,68.89','Upstairs'}
G[915]={'864:41.13,45.29 30:50.31,39.91>864'}
G[916]={'866:59.56,20.41 27:35.5,66>866'}
G[918]={'301:77.51,65.35'}
G[925]={'864:41.55,53.24 30:50.43,42.12>864'}
G[926]={'866:61.91,24.55 27:35.8,66.7>866'}
G[928]={'301:52.85,44.91'}
G[931]={'36:29.42,53.76'}
G[951]={'864:35.48,37.78 30:48.75,37.82>864'} -- 30:48.56,38.03 30:48.46,38.25
G[963]={'30:24.23,74.46'}
G[1068]={'17:17.7,43.8'}
G[1071]={'40:49.80,18.26'}
G[1073]={'35:64.25,26.69'}
G[1089]={'35:23.33,74.94'}
G[1090]={'35:23.30,75.06'}
G[1092]={'35:23.38,75.04'}
G[1104]={'866:61.70,22.07 27:35.80,66.26>866'}
G[1105]={'35:37.24,47.39'}
G[1139]={'35:34.6,43.2 35:34.6,44.6 35:34.7,43.6'}
G[1141]={'301:51.77,93.60'}
G[1142]={'37:46,51'}
G[1144]={'37:46,51'}
G[1153]={'35:37.1,46.3 35:37.2,47.8'}
G[1154]={'35:81.76,61.67'}
G[1156]={'35:81.92,64.61'}
G[1165]={'35:68.01,66.02'}
G[1187]={'35:83.46,65.41'}
G[1217]={'40:10.59,60.59'}
G[1239]={'40:10.95,59.73'}
G[1243]={'27:40.7,65.1 27:47.8,63.4 27:47.8,63.5'}
G[1247]={'27:54.49,50.85'}
G[1252]={'27:53.9,52.1'}
G[1254]={'27:76.32,54.67'}
G[1261]={'27:70.64,48.95'} -- 27:70.67,48.87
G[1265]={'27:70.28,48.16'}
G[1266]={'27:34.6,51.6'}
G[1267]={'27:53.93,50.68'}
G[1269]={'27:53.3,51.9'}
G[1274]={'341:41,54.8'}
G[1293]={'488:85.95,50.86','In mausoleum'}
G[1298]={'301:58.35,69.03'}
G[1317]={'301:52.89,74.44'}
G[1323]={'301:77.18,61.00'}
G[1340]={'35:35.06,46.60'}
G[1343]={'35:25.45,17.95'}
G[1344]={'35:65.33,65.98'}
G[1345]={'35:64.89,66.65'}
G[1354]={'866:43.22,63.12 27:32.16,74.34>866'}
G[1355]={'27:75.6,52.8'}
G[1356]={'341:75.8,11.8'}
G[1365]={'HV 341:30.25,59.43'}
G[1374]={'27:54.2,51.2'}
G[1376]={'27:50.4,49.1 27:57.5,47.4'}
G[1378]={'27:49.4,48.4 27:49.5,48.4 27:53.3,51.9'}
G[1379]={'35:56.3,65.9 35:56.5,65.9 35:58.5,64.5'}
G[1416]={'301:59.72,33.79'}
G[1422]={'37:46.99,10.85'}
G[1427]={'301:62.31,67.94'}
G[1428]={'301:58.10,67.49'}
G[1429]={'301:52.58,83.40'}
G[1431]={'301:60.27,76.75'}
G[1432]={'301:63.77,73.59'}
G[1435]={'301:40.13,85.29'}
G[1449]={'673:54.18,46.44'}
G[1465]={'35:37.19,46.40'}
G[1484]={'40:11.86,57.90'}
G[1493]={'673:35.46,63.66'}
G[1495]={'20:65.49,60.25'}
G[1496]={'20:52.54,54.82'}
G[1499]={'20:61.02,50.56'} -- 20:61.08,50.65 20:60.95,50.46 20:60.91,50.59 20:61.08,50.52 20:60.99,50.47
G[1500]={'20:54.60,29.89'}
G[1515]={'20:60.54,51.86'}
G[1518]={'20:44.62,53.78'}
G[1519]={'20:44.75,53.67'}
G[1521]={'20:65.25,60.42'}
G[1535]={'20:34,48'}
G[1547]={'20:66,56 K:24992'}
G[1548]={'20:56.6,63.8 K:24992'}
G[1561]={'673:41.28,61.15'}
G[1568]={'892:43.42,79.91 20:30.06,71.29>892'}
G[1569]={'892:46.65,58.80 20:30.84,66.20>892'}
G[1570]={'892:55.47,37.75 20:32.97,61.12>892'}
G[1571]={'40:9.4,59.6'}
G[1572]={'35:33.93,50.94'}
G[1573]={'341:55.54,47.76'}
G[1658]={'20:52.6,26.2'}
G[1661]={'892:46.74,58.22 20:30.87,66.05>892'}
G[1682]={'35:35.46,48.53'}
G[1684]={'35:41.52,39.04'}
G[1694]={'27:50.1,49.4 27:57.2,47.7'}
G[1699]={'27:54.73,50.59'}
G[1740]={'892:49.89,56.23 20:31.63,65.57>892'}
G[1745]={'20:60.13,52.39'}
G[1747]={'301:85.71,31.58'}
G[1776]={'38:26.8,33.4 38:26.9,33.7'}
G[1777]={'35:35.43,42.84'}
G[1780]={'21:34.27,16.60'}
G[1854]={'22:52.01,82.88','Circles the statue'}
G[1872]={'27:53.13,49.99'}
G[1931]={'20:44.70,52.62'}
G[1938]={'21:47.07,43.21'}
G[1959]={'341:41.44,52.29'}
G[1960]={'35:14.00,56.49'}
G[1963]={'35:34.83,49.28'}
G[1977]={'27:75.90,54.31'}
G[1992]={'41:42.52,58.18'}
G[2020]={'41:37.05,25.42'}
G[2055]={'382:48.4,69.2'}
G[2057]={'35:56.36,65.98'}
G[2077]={'888:45.94,72.89 41:58.04,38.79>888'}
G[2078]={'41:55.69,52.00'}
G[2079]={'888:45.62,74.55 41:57.96,39.19>888'}
G[2080]={'41:59.93,59.76'}	-- TODO: Determine if the original stuff with him can be given to the second location.  I know "The Shimmering Frond" and "Timberling Sprouts" can go to both.  If the early stuff needs to be done at the original dude, I think it would be best to alias the second one and just make other quests be able to be turned in to either one.
G[2081]={'41:55.66,51.99'}
G[2083]={'41:55.77,50.44'}
G[2104]={'40:10.52,55.71'}
G[2107]={'41:64.58,51.13','Upstairs'}
G[2119]={'892:54.17,56.38 20:32.66,65.61>892'}
G[2122]={'892:53.67,56.54 20:32.54,65.65>892'}
G[2123]={'892:47.74,58.16 20:31.11,66.03>892'}
G[2124]={'892:47.04,58.28 20:30.94,66.07>892'}
G[2126]={'892:46.95,59.38 20:30.91,66.34>892'}
G[2150]={'41:59.52,49.18'}
G[2151]={'41:49.35,44.68'}
G[2211]={'20:60.04,52.87','Upstairs'}
G[2215]={'24:29.23,63.34'}
G[2227]={'382:57.61,93.82'}
G[2229]={'24:57.68,46.90'}
G[2278]={'24:57.27,46.34'}
G[2285]={'301:81.55,34.07'}
G[2299]={'29:72.09,65.69'}
G[2307]={'892:45.93,80.47 20:30.67,71.42>892'}
G[2368]={'24:56.4,84'}
G[2369]={'24:52.4,77'}
G[2370]={'24:58.2,84'}
G[2371]={'24:52.6,75.6'}
G[2372]={'24:56.4,74.2 24:57,74.6 24:57.2,74.3 24:57.4,75.6 24:57.6,74.6 24:57.7,74.4 24:57.9,72.3 24:58.2,73.3 24:58.5,73.1 24:58.7,75 24:58.9,74.4'}
G[2373]={'24:59.6,73.6'}
G[2391]={'24:49.10,66.36'}
G[2397]={'24:57.68,45.24'}
G[2409]={'34:77.49,44.29'}
G[2418]={'24:57.19,45.53'}
G[2419]={'24:57.16,45.53'}
G[2437]={'24:57.00,45.72'}
G[2439]={'301:85.68,31.03'}
G[2460]={'341:26.06,69.82'}
G[2461]={'341:26.01,69.65'}
G[2464]={'37:38.40,50.46'}
G[2465]={'37:38.35,51.07'}
G[2486]={'673:41.81,72.84'}
G[2487]={'673:41.10,73.27'}
G[2488]={'673:40.68,73.82'}
G[2490]={'673:42.58,72.00'}
G[2493]={'673:43.39,71.49'}
G[2495]={'37:43.66,23.46'}
G[2496]={'673:41.18,73.06'} -- 689:27.2,76.9
G[2497]={'37:38.42,48.71'}
G[2500]={'673:40.32,67.79'}
G[2501]={'673:42.07,73.39'}
G[2502]={'673:40.54,67.72'}
G[2519]={'37:63.09,41.51'}
G[2545]={'673:44.45,92.89','Walks a short path here'} -- 673:44.57,93.58 673:44.41,92.65
G[2546]={'673:46.70,95.34','Inside lower ship'}
G[2547]={'673:46.7,95'}
G[2548]={'673:44.43,91.55','Inside lower ship'} -- 673:44.50,91.57 673:44.41,91.45
G[2549]={'673:44.45,91.89'}
G[2592]={'16:30.02,59.70'}
G[2608]={'16:39.98,47.82'}
G[2610]={'16:26,83.9'}
G[2634]={'673:59.46,79.05'}
G[2650]={'26:25,59'}
G[2653]={'26:35,65'}
G[2654]={'26:36,71'}
G[2696]={'16:43.2,92.6'}
G[2700]={'16:40,48.8'}
G[2705]={'24:52.2,58.6'}
G[2707]={'26:35,71'}
G[2712]={'16:54.8,55.3'}
G[2713]={'16:54.89,55.46'}
G[2748]={'692:56.6,53.6'}
G[2766]={'16:25.2,85.5 16:25.4,85.2 16:25.5,85.2'}
G[2768]={'16:27.58,83.01'}
G[2769]={'16:27.72,83.27'}
G[2771]={'16:68.98,34.80'}
G[2774]={'16:27.56,82.91'}
G[2784]={'341:40,55'}
G[2785]={'17:26.21,62.30'}
G[2787]={'16:69.68,36.53'}
G[2789]={'16:40.3,49'}
G[2835]={'16:39.90,47.34'}
G[2858]={'673:40.60,73.42'}
G[2859]={'673:41.67,74.53'}
G[2860]={'17:49.49,36.99'}
G[2916]={'341:77.53,11.81'}
G[2918]={'341:33.10,48.58'}
G[2920]={'17:26.28,62.54'}
G[2941]={'28:37.94,30.86'}
G[2947]={'9:48.79,58.79'}
G[2948]={'9:48.62,59.80'}
G[2976]={'9:53.58,48.27'}
G[2980]={'890:39.45,37.25 9:48.95,78.35>890'}
G[2981]={'890:27.74,28.32 9:45.15,75.46>890'}
G[2984]={'9:32.8,36.1'}
G[2985]={'9:47.50,61.32'}
G[2987]={'9:49.59,17.59'}
G[2988]={'9:57.05,60.43'}
G[2994]={'9:60.79,22.67'}
G[2995]={'362:47.02,49.61'}
G[3007]={'362:41.8,42.8'}
G[3009]={'382:46.61,33.15'}
G[3026]={'362:51.75,53.09'}
G[3028]={'362:56.14,46.37'}
G[3032]={'362:21.96,18.83'}	-- Replaced by 51639?
G[3033]={'362:76.47,27.25'}
G[3034]={'362:77.15,27.04'}
G[3039]={'362:57.29,89.78'}
G[3042]={'362:56.98,89.55'}
G[3045]={'362:24.54,22.56'}
G[3047]={'362:22.74,14.53'}
G[3050]={'362:44.1,44.6'}
G[3052]={'9:49.68,17.23'}
G[3054]={'9:47.88,57.10'}
G[3055]={'9:47.16,56.66'}
G[3056]={'9:44.42,17.19'}
G[3057]={'362:60,51.7'}
G[3059]={'9:45,75.4'}
G[3060]={'9:45.22,75.12'}
G[3061]={'9:45.27,75.30'}
G[3062]={'9:45.1,75.1'}
G[3064]={'9:48.6,59'}
G[3079]={'9:46.06,58.19'}
G[3139]={'4:51.95,43.50'}
G[3140]={'4:55.42,75.10'}
G[3142]={'4:52.24,43.15'}
G[3143]={'889:44.93,66.43 4:44.95,66.42>889'}
G[3144]={'321[1]:49.20,72.26'}
G[3145]={'889:45.82,63.44 4:43.46,67.50>889'}
G[3153]={'889:43.56,71.15 4:42.88,69.47>889'}
G[3154]={'4:42.9,69.3'}
G[3155]={'889:41.53,68.56 4:42.36,68.81>889'}
G[3156]={'889:41.59,65.61 4:41.59,65.61>889'}
G[3157]={'889:41.63,69.32 4:42.39,69.00>889'}
G[3188]={'4:55.95,74.72'}
G[3193]={'4:43.38,30.63'}
G[3208]={'4:56.41,20.04'}
G[3216]={'321[2]:58.22,54.61'}
G[3230]={'465:55,36'}
G[3233]={'9:49.52,17.10'}
G[3278]={'11:28.60,33.69'}
G[3279]={'11:26.38,28.59'}
G[3285]={'11:50.32,25.68'}
G[3287]={'889:34.62,44.21 4:40.60,62.58>889'}
G[3292]={'11:67.69,72.85'}
G[3293]={'4:46.37,22.94'}
G[3309]={'321:49.6,69.4'}
G[3310]={'321[1]:49.64,59.21'}
G[3326]={'321[1]:54.27,34.67'}
G[3332]={'321:66.4,41.7'}
G[3336]={'4:50.85,43.59'}
G[3337]={'11:67.66,39.39'}
G[3338]={'11:49.99,59.84'}
G[3339]={'11:67.72,74.00'}
G[3341]={'607:49.22,82.37'}
G[3344]={'321:39,47.4'}
G[3345]={'321[1]:53.48,49.54'}
G[3347]={'321[1]:55.68,45.76'}
G[3352]={'321[1]:63.88,32.52'}
G[3353]={'321:73.3,45.4'}
G[3355]={'321:76.3,34.6'}
G[3359]={'321[1]:66.47,49.02'}
G[3362]={'321:61.1,35.2 321:61.2,34 321:61.4,35.5 321:61.5,34.3 321:61.5,35.4 321:61.5,35.5 321:69.2,13.2'}
G[3383]={'11:77.29,91.32'}
G[3387]={'607:41.52,47.19'}
G[3389]={'11:37.83,55.27'}
G[3390]={'11:48.59,58.33'}
G[3391]={'11:68.41,69.06'}
G[3399]={'321[1]:32.24,69.65'}
G[3411]={'81:72.05,91.20'}
G[3412]={'321[1]:56.30,56.37'}
G[3418]={'607:41.62,46.51'}
G[3429]={'11:48.70,59.60'}
G[3432]={'11:55.17,41.02'}
G[3433]={'607:41.73,46.64'}
G[3439]={'11:57.54,18.31'}
G[3441]={'362:61.52,80.85'}
G[3442]={'11:62.29,17.48'}
G[3446]={'11:67.86,71.50'}
G[3448]={'11:49.49,58.67'}
G[3449]={'11:30.58,45.93'}
G[3453]={'11:69.59,72.98'}
G[3454]={'607:68.6,44.5'}
G[3464]={'11:66.86,72.79'}
G[3467]={'11:69.91,85.21'}
G[3471]={'11:50.35,25.66'}
G[3489]={'11:50.6,57.8'}
G[3494]={'11:68.39,69.20'}
G[3502]={'11:68.32,71.27'}
G[3514]={'888:47.20,55.95 41:58.35,34.60>888'}
G[3515]={'41:55.82,53.90'}
G[3516]={'381:24.4,48.8 381:24.5,48.8 381:33.8,10 381:34.3,8.2 381:34.4,8.5 381:34.5,8.4 381:34.6,10.6 381:34.8,9 381:35.3,9.6 381:35.5,9.1 381:39.4,10.7'}
G[3517]={'41:43.96,44.17'}
G[3518]={'301:27.7,38 301:43.2,73.6 301:59.9,69.3 301:59.9,70.1 301:60.1,71.3 301:60.2,68 301:60.3,66.8 301:60.3,71.9 301:60.4,72.5 301:60.5,67.6 301:60.5,72.4 301:60.6,67.4 301:60.8,73.1 301:61,73.7 301:61.4,66.4 301:61.4,74.5 301:61.5,74.8 301:61.6,66.5 301:61.8,66.1 301:61.9,73.8 301:62.4,71 301:62.4,71.6 301:62.4,73.3 301:62.6,72.7 301:62.8,65.9 301:62.9,70.3 301:63.3,71.3 301:63.3,72 301:63.5,71.7 301:63.6,66.3 301:63.6,72.5 301:63.7,71.4 301:63.8,66.5 301:64.1,75 301:64.3,70.4 301:64.3,73.7 301:64.4,67.6 301:64.5,66.4 301:64.5,67.4 301:64.5,73.4 301:64.5,74.5 301:64.6,70.2 301:64.7,74.2 301:64.9,68.4 301:65,68.9 301:65,75.5 301:65.2,76.7 301:65.4,70.6 301:65.5,69.4 301:65.5,76.1 301:65.6,74.8 301:66.2,76.8 301:66.4,70.4 301:66.4,71.4 301:66.4,71.9 301:66.5,71.4 301:66.6,71.6 301:67.3,72.5 301:67.6,72.4 301:67.6,72.7'}
G[3519]={'41:39.50,29.86'}
G[3521]={'11:67.81,40.56'}
G[3535]={'41:52,63.8'}
G[3567]={'41:55.55,49.99'}
G[3568]={'41:34.50,27.82'}
G[3593]={'888:49.19,52.44'}
G[3594]={'888:49.21,53.19 41:58.85,33.92>888'}
G[3595]={'888:47.59,59.45 41:58.45,35.47>888'}
G[3596]={'888:49.21,60.54 41:58.85,35.74>888'}
G[3597]={'888:46.60,56.65 41:58.20,34.78>888'}
G[3610]={'41:55.61,51.49'}
G[3615]={'11:48.7,58.7'}
G[3653]={'749[1]:35.82,35.71'}
G[3654]={'749[1]:33.63,14.74'}
G[3674]={'749[1]:61.62,73.41'}
G[3685]={'9:47.5,58.5 9:47.6,58'}
G[3690]={'9:47.6,58'}
G[3691]={'43:36.6,49.6'}
G[3694]={'42:42.51,45.15'}
G[3698]={'43:18,60'}
G[3838]={'41:55.41,88.40'}
G[3841]={'42:51.72,17.65'}
G[3845]={'43:18.3,20.4 43:18.3,20.5'}
G[3846]={'43:18.2,20.6 43:18.3,20.4'}
G[3847]={'43:26.8,36.7'}
G[3848]={'43:85.3,44.4 43:85.3,44.7'}
G[3880]={'43:59,58.8'}
G[3881]={'4:50.74,42.84'}
G[3885]={'43:35.6,71.4 43:35.6,71.5'}
G[3887]={'764[1]:0.00,0.00'}
G[3891]={'43:20.3,38.8'}
G[3894]={'43:37.3,51.8'}
G[3897]={'43:50.9,75.1'}
G[3901]={'43:86.3,44.1 43:86.4,43.1 43:86.7,43 43:87,43.5'}
G[3916]={'43:59.1,59.7'}
G[3920]={'43:78.3,44.9'}
G[3936]={'121:46.03,49.11'}
G[3978]={'362:33.9,47 362:34,46.4 362:34.1,47.6 362:34.6,47.4 362:34.8,48'}
G[3995]={'81:71.12,91.22'}
G[3996]={'43:35.8,49.2'}
G[4046]={'362:70.3,30.8 362:70.7,30.7'}
G[4079]={'43:34.9,49.8'}
G[4087]={'381:56.54,45.99'}
G[4138]={'381:43.5,25.9'}
G[4155]={'381:43.4,51.3 381:43.6,51.2'}
G[4156]={'381:49.10,60.95'}
G[4160]={'381:53.90,38.52'}
G[4202]={'81:63.1,46'}
G[4210]={'381:49.87,36.65'}
G[4214]={'381:40.4,39.2'}
G[4217]={'381:40.5,27.6'}
G[4256]={'341:51.47,26.32'}
G[4265]={'41:56.73,53.51'}
G[4267]={'43:34.41,47.99'}
G[4278]={'764[1]:30.30,69.70'}
G[4311]={'4:46.01,13.79'}
G[4321]={'141:67.48,51.30'}
G[4407]={'81:40.12,31.96'}
G[4421]={'761[1]:22.41,31.65'}
G[4468]={'26:63,76.6'}
G[4486]={'16:13.76,33.91'}
G[4498]={'101:52.2,53.5'}
G[4500]={'141:36.29,31.41'}
G[4501]={'141:37.15,33.08'}
G[4502]={'141:37.36,31.39'}
G[4508]={'761:33,33'}
G[4544]={'121:74.7,43.5 121:75,43 121:76,42.8'}
G[4549]={'382:65.95,49.66'}
G[4551]={'382:63.27,48.58'}
G[4552]={'382:62.17,44.90'}
G[4556]={'382:61.50,41.80'}
G[4563]={'382:86.23,15.97'}
G[4566]={'382:84.97,14.05'}
G[4573]={'382:81.71,31.23'}
G[4584]={'382:84.87,73.54'}
G[4586]={'382:6.3,68.3 382:35,2.2 382:63.9,80.6 382:75,74 382:75.1,172.2 382:75.2,74.5 382:75.4,72.8 382:75.6,74.5 382:75.8,73.4 382:75.8,73.6 382:76.2,72.4 382:78.6,9.2'}
G[4593]={'382:46.90,15.22'}
G[4606]={'382:49.28,17.05'}
G[4611]={'382:47.78,73.37'}
G[4618]={'17:26.19,62.45'}
G[4656]={'101:33.8,53.6'}
G[4663]={'101:55,28.8'}
G[4664]={'101:56,29.6'}
G[4665]={'101:52.6,29.4'}
G[4666]={'101:55.8,28.6'}
G[4667]={'101:55,26.4'}
G[4673]={'101:74.78,13.30'}
G[4730]={'381:42.49,32.60'}
G[4732]={'30:84.32,64.87'}
G[4752]={'321:61.4,34.4 321:61.4,34.7 321:61.4,35.5 321:61.5,34.4 321:61.5,34.5 321:69.4,12.6'}
G[4753]={'381:42.77,32.93'}
G[4772]={'27:71.15,48.41'}
G[4773]={'20:61.88,51.86'}
G[4787]={'688[1]:20.83,75.28'}
G[4791]={'141:35.21,30.66'}
G[4792]={'141:55.44,26.27'}
G[4794]={'141:68.27,48.71'}
G[4854]={'692[1]:22.90,26.22'}
G[4855]={'692[1]:24.13,27.03'}
G[4880]={'141:46.89,17.52'}
G[4921]={'141:66.16,46.07'}
G[4926]={'141:36.42,31.88'}
G[4941]={'141:64.75,50.42'}
G[4943]={'362:54.05,80.72'}
G[4944]={'141:68.21,48.62'}
G[4948]={'141:68.04,48.11'}
G[4949]={'321:32.3,37.8 321:32.5,38.7 321:32.8,37.8'}
G[4968]={'141:66.26,49.05','Top floor of tower'}
G[4983]={'141:40.96,36.71'}
G[5086]={'141:59.67,41.06'}
G[5087]={'141:36.53,30.80'}
G[5089]={'141:36.09,54.31'}
G[5099]={'341:25.71,69.67'}
G[5111]={'341:18.14,51.41'}
G[5115]={'341:71.00,89.69'}
G[5146]={'341:25.93,6.14','Up the ramp'}
G[5147]={'341:23.69,5.05','Up the ramp'}
G[5150]={'341:55.09,58.26','Upstairs'}
G[5159]={'341:60.09,36.44'}
G[5161]={'341:48.11,7.64'}
G[5165]={'341:51.83,14.75'}
G[5173]={'341:50.06,7.42'}
G[5174]={'341:68.46,43.55'}
G[5177]={'341:66.59,55.70'}
G[5296]={'121:53.2,31.8'}
G[5297]={'121:54.6,33.8'}
G[5299]={'121:53.6,32'}
G[5385]={'19:63.19,16.85'}
G[5387]={'341:69.91,18.55'}
G[5390]={'121:75.1,42.8'}
G[5393]={'19:60.10,13.49'}
G[5395]={'101:56.3,59.4 101:56.3,59.5'}
G[5396]={'101:66.67,10.94'}
G[5412]={'101:56.3,59.4 101:56.3,59.5'}
G[5419]={'161:48,41'}
G[5457]={'161:33.6,48'}
G[5494]={'301:55.03,69.69'}
G[5496]={'301:39.66,85.71'}
G[5499]={'301:55.65,86.09'}
G[5504]={'301:64.55,37.58'}
G[5511]={'301:63.65,36.98'}
G[5518]={'301:62.84,31.97'}
G[5519]={'301:63.53,31.08'}
G[5543]={'362:28.03,25.22'}
G[5594]={'161:50.9,27 161:50.9,28'}
G[5636]={'26:9.90,44.23'}
G[5637]={'341:68.40,19.95'}
G[5638]={'101:66.2,9.7'}
G[5639]={'321[1]:46.78,58.89 321[1]:52.25,54.33'}
G[5640]={'321[1]:27.99,61.31'}
G[5641]={'101:52.6,54.3'}
G[5642]={'101:66.44,11.82'}
G[5709]={'687:0.00,0.00'}
G[5752]={'101:66.74,10.87'}
G[5767]={'749[1]:46.61,58.42'}
G[5768]={'749[1]:46.65,59.21'}
G[5769]={'362:30.3,68.5 362:30.7,68.4 362:30.9,68.9 362:30.9,69.5 362:45.7,22.7 362:78.1,29.5 362:78.4,28.4 362:78.4,28.7 362:78.5,28.3 362:78.5,28.7'}
G[5770]={'362:75.3,30.5 362:75.5,30.4 362:75.6,31.1 362:75.7,31.5'}
G[5775]={'749[1]:56.79,47.81'}
G[5860]={'28:23.18,35.31'}
G[5887]={'889:41.72,69.98 4:42.40,69.18>889'}
G[5907]={'11:56.4,40.4 11:56.4,40.6 11:56.8,40.3'}
G[6019]={'101:47.83,61.82'}
G[6030]={'35:23.6,74.4 35:23.6,74.5'}
G[6031]={'341:48.77,42.55'}
G[6034]={'381:60.3,37.1 381:60.5,37'}
G[6073]={'43:82.6,69.6'}
G[6115]={'43:82.6,69.6'}
G[6206]={'691[2]:68.41,62.58'}
G[6212]={'691:41.6,71.6'}
G[6218]={'691[1]:0.00,0.00'}
G[6229]={'691[3]:40.88,87.93'}
G[6234]={'691[4]:28.70,47.59'}
G[6235]={'691[1]:0.00,0.00'}
G[6294]={'341:74.34,9.47'}
G[6329]={'691[1]:0.00,0.00'}
G[6391]={'691[1]:0.00,0.00'}
G[6546]={'141:46.02,57.10'}
G[6566]={'382:77.87,75.96'}
G[6569]={'341:69.22,50.57'}
G[6577]={'35:81.65,64.75'}
G[6606]={'11:56.36,19.72'}
G[6706]={'101:64.66,10.53'}
G[6735]={'381:62.54,32.77'}
G[6736]={'41:55.37,52.23'}
G[6740]={'301:60.42,75.24'}
G[6741]={'382:67.73,37.88'}
G[6746]={'362:45.80,64.65'}
G[6766]={'24:67.2,46.4 24:67.2,46.7 24:69.1,44.2 24:70.5,44.9'}
G[6774]={'864:24.08,73.35 30:45.56,47.75>864'}
G[6780]={'888:54.56,84.72 41:60.17,41.71>888'}
G[6782]={'866:87.50,44.46 27:40.88,70.67>866'}
G[6785]={'20:61.87,51.96'}
G[6826]={'341:36.36,3.63'}
G[6887]={'42:39.1,43.1'}
G[6929]={'321[1]:53.63,78.79'}
G[7010]={'321:55.2,55.8'}
G[7023]={'692[1]:29.07,59.02'}
G[7024]={'39:68.32,70.38'}
G[7079]={'691[1]:0.00,0.00'}
G[7156]={'182:63.2,9'}
G[7157]={'182:62.8,13.6'}
G[7158]={'182:63.8,6.8'}
G[7172]={'692[2]:50.26,34.47'}
G[7206]={'692[1]:43.95,41.09'}
G[7269]={'686:57.2,55.6'}
G[7272]={'686:57.97,25.81'}
G[7286]={'686:44.03,16.40'}
G[7291]={'692[1]:26.53,34.81'}
G[7313]={'41:39.18,29.88 41:39.25,29.73'}
G[7316]={'381:36.08,53.48'}
G[7317]={'41:45.03,53.48',"In Ban'ethil Barrow Den"}
G[7323]={'24:71.41,44.96'}
G[7361]={'691[1]:75.99,66.68'}
G[7363]={'19:48.77,31.75'}
G[7406]={'673:43,72.1'}
G[7407]={'686:58.16,89.10 161:39.22,21.34>686'}
G[7438]={'281:67.8,50.2'}
G[7439]={'281:67.8,50.2'}
G[7440]={'281:24.2,50.4'}
G[7441]={'281:24.4,47.6'}
G[7442]={'281:24.4,47.6'}
G[7453]={'281:64.20,37.28'}
G[7505]={'19:39.2,36.2'}
G[7506]={'19:39.2,36.2'}
G[7623]={'38:49.4,55.4 38:49.4,55.5 38:49.5,55.4 38:49.5,55.5'}
G[7740]={'381:44.9,80.9'}
G[7776]={'121:41.4,15.4 121:41.4,15.5 121:41.6,15.3 121:76.1,43.8'}
G[7783]={'19:62.31,26.08'}
G[7784]={'161:59.79,64.08'}
G[7790]={'321:76.2,37.4 321:76.2,37.5 321:76.6,37.6 321:76.7,37.4'}
G[7795]={'686:31.09,44.20'}
G[7800]={'691[3]:0.00,0.00'}
G[7804]={'161:42.46,24.03'}
G[7806]={'26:49.34,37.67'}
G[7807]={'121:53.35,55.70'}
G[7823]={'161:51.36,29.48'}
G[7824]={'161:52.04,27.61'}
G[7846]={'19:54.7,51.2'}
G[7854]={'121:52.8,47.1'}
G[7875]={'121:74.9,42.6'}
G[7944]={'341:69.53,50.33'}
G[7952]={'4:55.2,75.6'}
G[7953]={'4:55.28,75.49'}
G[7954]={'27:56.27,46.42'}
G[7955]={'27:56.3,46.3'}
G[7995]={'26:59.4,77.8'}
G[7999]={'381:43.01,78.04'}
G[8018]={'26:11.08,46.15'}
G[8115]={'121:74.4,43.4 121:74.4,43.5 121:74.5,43.4'}
G[8126]={'161:52.37,28.31'}
G[8296]={'19:46.7,27.9', 'In cave'}
G[8297]={'19:46.3,39'}
G[8298]={'19:73.6,55.6'}
G[8299]={'19:59.1,35.5'}
G[8300]={'19:49,35.6'}
G[8301]={'19:46.8,13.3'}
G[8302]={'19:52.7,26.9'}
G[8303]={'19:54,37'}
G[8304]={'19:37.1,28.3'}
G[8356]={'362:46.97,58.22'}
G[8359]={'362:45.73,55.86'}
G[8379]={'181:29.3,40.2 181:29.7,40.4 181:29.8,40.5'}
G[8416]={'866:41.67,63.33 27:31.89,74.38>866'}
G[8436]={'28:29.51,26.27'}
G[8516]={'760:52.9,32 760:59.1,31.4 760:59.9,29 760:60,29.6 760:43.3,29.3 760:43.3,29.6 760:43.4,27.5 760:43.7,30.2 760:43.8,26.3 760:43.8,27 760:44.4,25.1 760:44.4,31 760:44.7,24.5 760:45.2,31.5 760:45.3,23.3 760:45.4,23.9 760:45.6,23.1 760:46,32.2 760:46.1,22.4 760:46.1,24.6 760:46.1,32.6 760:46.3,23.6 760:46.6,22.4 760:46.8,32.7 760:46.9,23 760:47.1,23.8 760:50.4,35.6 760:50.5,34.9 760:50.7,34.1 760:50.9,33.3 760:51.1,32 760:51.6,30.8 760:52,30 760:52.3,29.3 760:52.5,29.5 760:52.7,28.7 760:53.3,28.2 760:54.1,28.4 760:55.1,28.8 760:55.5,29.6 760:55.7,29.2 760:56.7,30.3 760:57.1,30.9 760:57.4,31.9 760:58.3,33.3 760:58.4,32.2 760:58.6,33.9 760:59,34.9 760:59.3,35.5 760:59.9,36.3 760:59.9,36.7 760:60.5,37.1 760:61.1,36.2 760:61.1,38.4 760:61.8,37.4 760:62.3,39.3 760:62.4,39.7 760:63,40.2 760:63.5,40.3 760:64.4,41.1 760:64.8,41.2 760:66.2,41.1 760:67.4,41.1 760:67.9,40.7 760:68,32.3 760:68,40.3 760:68.1,34.4 760:68.1,34.6 760:68.4,33.1 760:68.4,35.8 760:68.7,36.1 760:68.7,36.7 760:68.9,32.3 760:68.9,37.7 760:68.9,38.9 760:69,33.1 760:69.1,39.5 760:69.5,31.8 760:69.5,39.7 760:69.8,31.4 760:71,30.6 760:71.3,29.8 760:71.6,30.1 760:72.3,29.1 760:72.8,28.5 760:72.9,28.2 760:73.9,27.6 760:74,23.8 760:74.1,24.7 760:74.1,27.2 760:74.2,25.9 760:74.4,23.3 760:74.5,25.3 760:74.5,26.1 760:74.7,24 760:74.7,26.6 760:74.9,22.7 760:75.1,22 760:75.7,21.5 760:76.3,21.1 760:76.7,20.6 760:77,19.8 760:77.3,19.4 760:77.6,15.6 760:77.7,15.4 760:78,18.5 760:78.1,16.8 760:78.3,18.1 760:78.5,16.7'}
G[8576]={'181:26.82,76.95'}
G[8582]={'11:42.35,15.18'}
G[8586]={'181:42.42,23.59'}
G[8587]={'181:22,51'}
G[8609]={'19:61.25,21.59'}
G[8659]={'321[1]:54.79,45.84','Top of tower'}
G[8670]={'301:60.84,70.78'}
G[8674]={'362:45.11,59.75'}
G[8719]={'301:61.11,70.62'}
G[8890]={'704[1]:46.52,88.19'}
G[8895]={'704[1]:27.27,55.52'}
G[8904]={'704[1]:0.00,0.00'}
G[8960]={'182:38.3,39.1 182:38.4,56.4 182:38.7,46.2 182:39.1,38.3 182:39.3,51.4 182:39.6,39.6 182:39.8,39 182:40.3,34 182:40.9,34.9 182:41.2,34 182:43.9,66.4 182:44.3,66.7 182:44.3,67.8 182:45.3,68 182:45.4,66.2 182:45.4,68.9 182:45.5,66.2 182:45.5,67.6 182:45.5,68.8 182:45.9,66.9 182:46,69.5 182:46.2,17.5 182:49.2,36.8 182:49.5,34.5 182:49.7,34.2 182:50.5,17.2 182:50.9,32.7 615:41.3,34.3'}
G[8962]={'36:28.27,48.87'}
G[8965]={'36:28.35,48.87'}
G[9016]={'704[1]:23.78,54.02'}
G[9029]={'704[1]:50.57,62.81'}
G[9046]={'29[14]:74.00,52.99'}
G[9116]={'182:42.01,71.80'}
G[9117]={'201:54.20,62.50'}
G[9176]={'29:40.2,60.4 29:40.2,60.5 29:43.6,60.1'}
G[9177]={'29:71.86,67.96'}
G[9270]={'201:55.08,62.23'}
G[9271]={'201:55.02,62.23'}
G[9272]={'201:31.87,50.28'}
G[9296]={'864:33.38,54.66'}
G[9298]={'281:25.12,58.49'}
G[9316]={'11:44.37,24.86'}
G[9499]={'704[1]:0.00,0.00'}
G[9502]={'704[1]:0.00,0.00'}
G[9503]={'704[2]:51.10,60.60'}
G[9540]={'19:61.47,18.64'}
G[9550]={'HV 321[1]:51.03,71.01'}
G[9562]={'29:73.46,66.27'}
G[9563]={'29:72,64'}
G[9568]={'721[4]:0.00,0.00'}
G[9616]={'341:75.78,23.27'}
G[9618]={'201:43.45,40.93'}
G[9619]={'201:71.24,76.58'}
G[9623]={'201:63.80,19.74'}
G[9736]={'721[5]:0.00,0.00'}
G[9796]={'889:42.98,62.43 4:42.73,67.24>889'}
G[9997]={'201:55.10,62.67'}
G[9998]={'201:43.44,41.33'}
G[9999]={'201:51.96,49.81'}
G[10076]={'704[1]:0.00,0.00'}
G[10176]={'889:45.20,68.38 4:45.18,68.38>889'}
G[10181]={'382:58.05,91.77'}
G[10184]={'718[1]:68.80,28.23'}
G[10260]={'29:54.57,23.97',[3]='015'}
G[10299]={'721[4]:30.49,39.73 29:24.30,25.66>721'}
G[10302]={'201:55.35,62.49'}
G[10305]={'281:59.31,49.79'}
G[10307]={'281:25.21,58.47'}
G[10387]={'765[1]:73.63,20.34'}
G[10418]={'765:39.15,31.62'}
G[10422]={'765:35.76,34.74'}
G[10424]={'765:38.71,38.78'}
G[10435]={'765[2]:57.03,19.71'}
G[10439]={'765[2]:39.65,22.64'}
G[10445]={'HF 823:55.56,54.99'}
G[10516]={'765:48.89,27.43'}
G[10558]={'765:50.44,29.69'}
G[10578]={'4:55.74,75.36'}
G[10583]={'201:55.98,64.16'}
G[10616]={'30:81.4,66.2'}
G[10618]={'281:46.68,17.72'}
G[10665]={'20:60.13,52.69'}
G[10666]={'20:44.36,53.06'} -- 20:44.37,53.14 20:45.09,53.36 20:44.19,53.93
G[10667]={'23:35.26,68.10'}
G[10738]={'281:36.96,55.59'}
G[10808]={'765:44.03,27.27'}
G[10813]={'765[1]:23.62,78.72'}
G[10822]={'23:67.34,8.92'}
G[10837]={'20:83.26,68.99'}
G[10838]={'22:42.70,84.01'}
G[10839]={'20:83.2,68.6'}
G[10840]={'22:42.97,83.55'}
G[10897]={'241:48.11,67.33'}
G[10916]={'281:29.6,54.8'}
G[10920]={'281:46.85,53.84 182:51.2,80.4'}
G[10921]={'182:50.91,80.14'}
G[10922]={'182:43.97,61.83'}
G[10923]={'182:51.12,80.49'}
G[10926]={'23:32.45,83.65'}
G[10929]={'281:58.01,63.77'}
G[10977]={'201:54.83,63.82'}
G[10997]={'765[1]:4.67,52.41'}
G[11017]={'321[1]:56.8,56.4'}
G[11019]={'182:44.1,61.9'}
G[11031]={'382:76.8,74.6'}
G[11032]={'765[1]:27.35,43.50'}
G[11033]={'23:74.92,53.50'}
G[11034]={'23:75.86,51.97'}
G[11035]={'23:53.22,54.58'}
G[11036]={'23:75.61,52.04'}
G[11053]={'22:43.40,83.74'}
G[11055]={'20:83.4,69.9'}
G[11057]={'20:83.28,69.24'}
G[11063]={'23:35.56,68.88'}
G[11079]={'281:48.67,41.02'}
G[11118]={'281:59.86,51.19'}
G[11138]={'281:60.99,48.61'}
G[11139]={'281:58.84,48.27'}
G[11142]={'765[1]:81.99,28.86'}
G[11191]={'281:59.87,49.19'}
G[11192]={'281:59.81,49.13'}
G[11193]={'281:59.78,49.25'}
G[11219]={'43:27.2,35.6'}
G[11259]={'101:55.4,55.7 101:55.5,55.8'}
G[11317]={'101:22.4,73.1 101:22.5,73'}
G[11378]={'889:46.20,63.26 4:46.20,63.26>889'}
G[11401]={'381:43.40,79.39'}
G[11406]={'341:26.2,8.00'}
G[11438]={'101:62.3,38.9'}
G[11486]={'699[4]:60.54,23.47'}
G[11520]={'680:42.2,58.2'}
G[11554]={'182:51.41,80.44'}
G[11555]={'182:64.41,5.13'}
G[11556]={'281:21.05,46.18'}
G[11557]={'182:64.89,5.25'}
G[11558]={'182:64.58,3.81 182:64.65,5.90 182:64.55,4.80'}
G[11583]={'755:72,79'}
G[11596]={'101:60.86,61.86'}
G[11616]={'22:48.13,32.36'}
G[11624]={'101:25.8,68.2'}
G[11625]={'101:66.51,37.53'}
G[11626]={'101:45.37,75.29'}
G[11697]={'43:82.6,69.6'}
G[11701]={'201:71.4,73.9 201:71.5,74'}
G[11711]={'42:47.70,88.91'}
G[11730]={'261:57.6,79'}
G[11732]={'261:56,80'}
G[11798]={'241:44.29,45.85'}
G[11800]={'241:44.15,45.22'}
G[11801]={'241:51.69,45.09'}
G[11806]={'43:26.68,36.89'}
G[11811]={'161:55.23,60.26'}
G[11814]={'321[1]:32.78,65.16'}
G[11820]={'43:73.77,61.61'}
G[11821]={'81:64.93,82.60'}
G[11832]={'241:36.3,41.9 241:36.5,42.1'}
G[11857]={'607:44.18,33.68'}
G[11858]={'81:72.2,83.9'}
G[11941]={'27:54.6,50.3'}
G[11943]={'4:51.4,41.5 4:51.5,41.5'}
G[12029]={'241:53.33,42.70'}
G[12031]={'101:22.7,72.1'}
G[12032]={'101:22.7,72.5 101:22.8,72.4 611:54.9,16.6'}
G[12042]={'241:52.51,40.55'}
G[12096]={'401:43.12,17.61'}
G[12097]={'401:46.7,84.1'}
G[12201]={'750:27.2,80.6'}
G[12225]={'750[1]:0.00,0.00'}
G[12236]={'750:37.6,70.8'}
G[12238]={'750:25.7,78.4'}
G[12258]={'750:17.6,34.0'}
G[12277]={'101:33.94,53.48'}
G[12340]={'101:23.3,72.8'}
G[12384]={'23:11.34,28.60'}
G[12578]={'182:60.52,25.30'}
G[12596]={'22:42.92,85.06'}
G[12617]={'23:75.85,53.41'}
G[12636]={'23:75.81,53.29'}
G[12676]={'43:73.6,76.6'}
G[12677]={'43:62,49.4'}
G[12678]={'43:41.6,67.4'}
G[12696]={'43:49.75,65.08'}
G[12717]={'43:12.76,34.19'}
G[12719]={'43:12.7,35.3'}
G[12721]={'43:38.88,42.38'}
G[12724]={'43:73.86,62.48'}
G[12736]={'688:48.49,11.75 43:16.52,11.03>688'}
G[12737]={'43:74.19,60.72'}
G[12757]={'43:37.77,43.49'}
G[12759]={'43:48.23,69.75'}
G[12818]={'43:41.49,34.46'}
G[12837]={'43:74.11,60.91'}
G[12858]={'43:68.34,75.30'}
G[12863]={'43:12.46,35.14'}
G[12867]={'43:73.56,60.87'}
G[12876]={'688:42.2,75.6'}
G[12877]={'43:73.04,62.47'}
G[12919]={'141:58.76,60.17'}
G[12920]={'16:68.51,37.82'}
G[12939]={'141:67.76,48.97'}
G[12944]={'704[2]:50.31,58.48'}
G[12997]={'922[1]:52.90,55.35','Deeprun Tram Ironforge side'}
G[13018]={'922[1]:51.75,55.06','Deeprun Tram Stormwind side'}
G[13136]={'261:63.2,45.8'}
G[13158]={'20:87.50,43.29'}
G[13159]={'30:78.8,67.2'}
G[13176]={'401:49.6,82.7'}
G[13179]={'401:49.8,85.6 401:50.4,31 401:50.5,30.9 401:51.3,33'}
G[13180]={'401:49.7,85.7 401:50.2,60.2 401:53.9,27'}
G[13181]={'401:44.3,15.3 401:44.3,15.9 401:45.2,14 401:45.4,14.6 401:45.5,14.4 401:45.5,14.6 401:46.8,16.2 401:47.5,39.6 401:47.7,39 401:49.7,85.5 401:50.3,78.6 401:50.5,80 401:50.6,80.6 401:50.7,81.8'}
G[13236]={'401:50.2,85.1'}
G[13257]={'401:43.4,15.6'}
G[13282]={'750:35.8,10.8'}
G[13283]={'301:79.46,61.26'}
G[13417]={'321[1]:39.55,47.33'}
G[13418]={'HV 321[1]:52.52,77.05'}
G[13429]={'HV 382:68.25,38.87'}
G[13431]={'HV 362:42.45,55.28'}
G[13433]={'HV 341:33.55,67.93'}
G[13434]={'HV 341:33.5,67.6'}
G[13435]={'HV 301:62.81,70.06'}
G[13437]={'401:43.3,18.1 401:48.3,84.3 401:48.4,84.6 401:48.5,84.9 401:49.1,81.5 401:50.6,75.7 401:51.3,61'}
G[13438]={'401:43.1,18.2 401:50.4,65.4 401:50.4,65.5 401:50.5,65.6'}
G[13439]={'401:43.2,18.3 401:44.2,16.1 401:44.8,16.4 401:45.4,16.5 401:45.7,16.5 401:46.8,16.5 401:47.2,16.3 401:47.5,40 401:47.6,39.4 401:47.8,37 401:47.8,38.2 401:48,36.2 401:48,41.3 401:48.3,41.9 401:48.4,16 401:48.6,43.1 401:48.7,35.4 401:48.7,51.3 401:48.7,52 401:48.9,44.3 401:48.9,47.3 401:48.9,47.9 401:48.9,48.6 401:49,16 401:49.1,44.9 401:49.2,46.1 401:49.2,53.4 401:49.4,59.1 401:49.7,16 401:49.7,19.3 401:49.7,19.9 401:49.8,18.1 401:49.8,54.1 401:49.9,57.8 401:50,16.9 401:50.1,57.1 401:50.2,55.3 401:50.2,55.9 401:50.3,21.1 401:50.3,78.9 401:50.3,81.4 401:50.4,60.3 401:50.4,78 401:50.4,80 401:50.4,81.6 401:50.5,81.6 401:50.6,63.4 401:50.6,77.7 401:50.7,22 401:50.7,77.1 401:50.7,81.4 401:50.8,22.6 401:50.8,60.4 401:50.9,60.5 401:51,62.3 401:51.1,23.9 401:51.1,27.4 401:51.1,28 401:51.2,25.1 401:51.2,26.1 401:51.2,28.6 401:51.4,32.8 401:51.6,29.2 401:51.6,32.2 401:51.6,32.9 401:51.8,31 401:51.9,30.4 401:51.9,64.6 401:52.3,66.1'}
G[13442]={'401:43.9,12.7'}
G[13444]={'HV 341:33.15,65.45'}
G[13445]={'HV 321[1]:49.63,78.00'}
G[13596]={'750[1]:0.00,0.00'}
G[13616]={'401:57,82.5'}
G[13617]={'401:42.55,16.82'}
G[13636]={'24:42.34,41.14'}
G[13776]={''}
G[13777]={'24:43.1,43.9'}
G[13797]={'401:45.6,16.6'}
G[13798]={'401:49.3,81.8 401:50.2,80.4 401:50.4,81.3 401:50.7,81.3 401:50.7,81.7'}
G[13816]={'24:45.4,45.3 401:42.6,13.4 401:42.6,13.8'}
G[13817]={'24:58.69,34.24'}
G[13840]={'24:57.79,33.32'}
G[13841]={'24:44.7,46.2'}
G[14266]={'35:61.71,73.04'}
G[14305]={'HC Near'}
G[14322]={'699:62.6,66.2'}
G[14324]={'699[1]:31.81,31.21'}
G[14325]={'699:49.8,78.2'}
G[14326]={'699:69.8,76.6'}
G[14338]={'699:27.8,55.1 699:28.4,55.5 699:28.5,55.4 699:28.5,55.5'}
G[14347]={'261:29.6,10.6'}
G[14358]={'699[2]:48.36,53.75 121:60.32,30.15>699','Upstairs'}
G[14368]={'699:72.4,16.4 699:72.4,16.8 699:72.4,17.5 699:72.5,16.3 699:73,16.6 699:73.1,15.4 699:73.5,15.3 699:73.6,16.6 699:73.7,17.5 699:74.3,16.4 699:74.8,16.7 699:74.9,16.4 699:75,17.5'}
G[14375]={'321:45.2,69.5 321:45.2,72.4 321:45.3,69.2 321:45.3,73.1 321:45.9,73.3 321:46.1,67.8 321:46.1,75.6 321:46.5,76.7 321:46.6,67.4 321:46.7,63.7 321:46.7,67.5 321:46.7,76.1 321:47,64.5 321:47.1,77.9 321:47.4,79 321:47.6,79 321:48.2,66.4 321:48.2,79.8 321:48.3,66.5 321:48.7,71.9 321:48.7,83.5 321:48.8,66.4 321:48.8,79.6 321:49,66.5 321:49,82.6 321:49.1,82.4 321:49.4,81.3 321:49.5,80.2 321:49.5,81.5 321:49.6,66.3 321:49.6,81.1 321:49.9,71.8 321:50,64.1 321:50,70.5 321:50.3,66.7 321:50.6,66.3 321:50.7,80.6 321:50.8,64 321:50.9,66.7 321:51,64.6 321:51.4,67.8 321:51.4,69.9 321:51.4,72.4 321:51.4,79.3 321:51.4,80.2 321:51.5,64.2 321:51.5,66.4 321:51.5,78.9 321:51.5,81.1 321:51.6,67.8 321:51.6,78.2 321:51.6,80.4 321:51.7,81.8 321:51.8,69.4 321:51.8,70 321:51.8,76.9 321:51.9,66.9 321:51.9,71 321:51.9,71.6 321:51.9,72.5 321:51.9,74.6 321:51.9,75.9 321:52,83.1 321:52,83.7 321:52.1,73.9 321:52.2,84.8 321:52.3,85.7 321:52.5,75.7 321:52.5,81.1 321:52.5,81.9 321:52.6,77.6 321:52.7,77 321:53,74.7 321:53.1,74.3 321:53.1,79.5 321:53.6,74 321:53.9,73.1'}
G[14381]={'699:74,13 699:74.3,12.3 699:75.1,12.3'}
G[14382]={'699:78.1,12 699:78.6,11.4 699:79.1,11.5 699:79.4,12.9 699:79.7,13.4 699:79.7,14 699:80,11.3 699:80.1,12.1 699:80.7,12.2 699:81.3,12.5 699:81.4,11.3 699:81.6,12.3 699:81.9,11.4 699:81.9,12.9 699:82.5,12.4 699:82.8,13 699:82.9,11.4'}
G[14383]={'699:83.2,23 699:83.3,24.9 699:83.3,26.2 699:83.4,22.4 699:83.4,23.8 699:83.6,26.5 699:83.8,21.1 699:84,24.2 699:84.2,22.3 699:84.2,25 699:84.3,23 699:84.3,25.5 699:84.5,21.8 699:84.5,23.3 699:84.5,23.9 699:84.5,25.2 699:84.5,26.3'}
G[14387]={'29[16]:54.22,83.34'}
G[14392]={'321:51.2,82.4 321:51.3,83.5 321:51.4,74.5 321:51.4,83.1 321:51.5,83.1 321:51.5,83.5 321:51.7,75.7 321:51.7,76.5 321:51.8,75.3 321:52.4,78.4 321:52.4,82.4 321:52.5,82.6 321:52.6,82.1 321:52.9,78 321:53,77.2 321:53.1,79.1'}
G[14394]={'301:67.17,85.49'}
G[14435]={'261:27,14'}
G[14437]={'29:8.39,35.78'}
G[14444]={'HC Near'}
G[14508]={'673:45.01,25.39','Walks around arena at times'}
G[14624]={'28:38.67,28.68'}
G[14625]={'28:38.11,26.97'}
G[14626]={'28:36.14,28.25 28:37.38,28.93'}
G[14627]={'28:38.46,27.86'}
G[14628]={'28:43.77,28.70'}
G[14634]={'28:37.73,26.58'}
G[14636]={'28:45.86,29.65'}
G[14637]={'121:48.68,44.81'}
G[14720]={'321[1]:48.38,71.27'}
G[14721]={'301:71.45,80.45'}
G[14725]={'381:63.2,22.5 381:63.8,22.7'}
G[14726]={'321:63.4,51.1 321:63.5,51'}
G[14727]={'321:37.3,87.5 321:37.8,87.8 321:38,87.2'}
G[14728]={'362:43.3,42.8 362:43.7,42.5 362:43.9,42.1'}
G[14729]={'382:5.4,58.4 382:44.1,34.9 382:63,71.2 382:70.9,29.6 382:71.4,28.3 382:71.4,28.8 382:71.9,28.9 382:72.1,28.3 382:72.3,29.5 382:72.5,28.4 382:72.5,29.4 382:72.6,29.9'}
G[14731]={'26:78.13,81.39'}
G[14733]={'43:61.9,83.9'}
G[14739]={'26:78.80,78.25'}
G[14740]={'26:80.33,81.53'}
G[14741]={'26:79.16,79.53'}
G[14753]={'43:61.5,83.8'}
G[14754]={'11:40.2,20'}
G[14822]={'HF 823:53.22,75.84'}
G[14828]={'HF 823:47.76,64.79'}
G[14829]={'HF 823:51.10,82.04'}
G[14832]={'HF 823:47.90,67.12'}
G[14833]={'HF 823:55.00,70.78'}
G[14841]={'HF 823:49.24,60.79'}
G[14844]={'HF 823:50.55,69.56'}
G[14845]={'HF 823:52.91,67.93'}
G[14847]={'HF 823:51.89,60.93'}
G[14871]={'HF 823:55.93,70.72'}
G[14875]={'689:14.2,15.5'}
G[14902]={'689:15.3,14.5'}
G[14903]={'689:15.3,16.1'}
G[14904]={'689:15.3,16'}
G[14905]={'689:14.1,13.7'}
G[14910]={'689:15.3,15.4 689:15.3,15.5'}
G[14921]={'689:15.1,16'}
G[14983]={'16:39.95,46.68'}
G[15011]={'HH 27:59.6,34.4'}
G[15012]={'HH 4:46.1,13.7'}
G[15021]={'16:68.4,30.4 16:73.3,29.8'}
G[15042]={'793:62.3,56.5'}
G[15070]={'689:14.5,15.8'}
G[15077]={'HX 673:41.6,73.0'}
G[15078]={'HX 673:41.5,73.0'}
G[15079]={'HX 673:41.4,73.0'}
G[15116]={'HX 321[1]:52.36,77.13'}
G[15119]={'HX 341:28.17,74.93'}
G[15126]={'16:68.4,30.4 16:68.4,30.5 16:68.5,30.4 16:68.5,30.5 16:73.4,29.8'}
G[15127]={'16:40.1,46.6'}
G[15170]={'261:46.42,79.07'}
G[15171]={'261:46.01,79.40'}
G[15174]={'261:55.53,36.77'}
G[15177]={'261:54.40,32.73'}
G[15181]={'261:53.21,32.50'}
G[15182]={'261:54.6,32','Top of tower'}
G[15183]={'261:53.62,35.31'}
G[15189]={'261:55.38,36.26'}
G[15190]={'261:55.30,36.20'}
G[15191]={'261:54.89,36.02'}
G[15192]={'161[18]:41.77,49.88'}	-- should this get a pointer from outside the caverns in Tanaris?
G[15194]={'261:68.65,63.04'}
G[15197]={'HW 382:67.42,13.20'}
G[15270]={'261:53.19,35.20'}
G[15278]={'893:61.03,45.13 462:38.02,21.00>893'}
G[15279]={'893:64.76,46.50 462:39.23,21.46>893'}
G[15280]={'893:65.48,43.74 462:39.4,20.6>893'}
G[15281]={'893:52.88,49.77 462:35.37,22.52>893'}
G[15283]={'893:63.87,46.45 462:38.94,21.45>893'}
G[15284]={'893:65.32,43.20 462:39.4,20.45>893'}
G[15285]={'893:63.84,42.10 462:38.9,20.1>893'}
G[15295]={'893:63.97,42.83 462:38.97,20.26>893'}
G[15296]={'893:61.80,39.36 462:38.27,19.12>893'}
G[15297]={'893:58.47,38.79 462:37.20,19.05>893'}
G[15298]={'893:41.09,70.78 462:31.57,29.48>893','Up on platform'}
G[15301]={'462:40.42,32.21'}
G[15303]={'HF 823:52.50,56.13'}
G[15306]={'261:53.16,35.11'}
G[15309]={'382:67.48,6.62'}
G[15310]={'30:32.04,50.39'}
G[15339]={'717:39.95,75.32'}
G[15340]={'717:30.93,37.96'}
G[15378]={'766:51.6,84.6 261:28.7,89.7>766'}
G[15379]={'766[3]:50.40,84.39'}
G[15380]={'766:50.6,85.6 261:28.7,89.7>766'}
G[15395]={'182:64.01,10.31'}
G[15397]={'462:43.68,71.30'}
G[15398]={'462:34,80'}
G[15399]={'462:60.32,62.77'}
G[15400]={'462:59.52,62.60'}
G[15401]={'462:36.70,57.44'}
G[15402]={'462:54.28,70.97'}
G[15403]={'462:48.16,46.00'}
G[15404]={'462:36.36,66.77'}
G[15405]={'462:44.63,53.14'}
G[15406]={'462:70.45,72.35'}
G[15407]={'462:62.2,79.6'}
G[15409]={'462:35.0,84.6'}
G[15416]={'462:50.33,50.76'}
G[15417]={'462:44.72,69.63'}
G[15418]={'462:47.25,46.30'}
G[15433]={'462:48.15,47.66'}
G[15498]={'772:59.39,14.05'}
G[15499]={'772:59.48,14.05'}
G[15500]={'772:59.53,14.00'}
G[15502]={'766:59.3,68.4'}
G[15503]={'766:59.4,68.5'}
G[15504]={'766:59.2,68.5'}
G[15513]={'893:64.20,42.07 462:39.05,20.01>893'}
G[15549]={'HL 704[1]:50.53,62.95 29:14.58,9.21>704'}
G[15556]={'HL 750[2]:51.46,93.73 101:29.10,62.56>750'}
G[15557]={'HL 29:70.12,45.40'}
G[15558]={'HL 35:33.33,46.55'}
G[15559]={'HL 26:50.00,48.03'}
G[15560]={'HL 721[3]:61.78,40.08 29:24.30,25.66>721'}
G[15561]={'HL 21:44.96,41.15'}
G[15562]={'HL 30:34.56,50.26'}
G[15563]={'HL 19:54.28,49.49'}
G[15564]={'HL 382:66.62,38.20','Upstairs, outside'}
G[15565]={'HL 30:39.79,63.67'}
G[15566]={'HL 23:75.73,54.56'}
G[15567]={'HL 28:21.30,79.10'}
G[15568]={'HL 20:61.86,53.91'}
G[15569]={'HL 27:53.92,49.93'}
G[15570]={'HL 261:30.80,13.32'}
G[15572]={'HL 4:53.22,43.61'}
G[15573]={'HL 161:37.24,79.05'}
G[15574]={'HL 281:59.96,49.94'}
G[15575]={'HL 9:48.50,53.25'}
G[15576]={'HL 673:39.94,72.51','On roof'}
G[15577]={'HL 39:56.63,47.09','Top of tower'}
G[15578]={'HL 686:34.51,39.35 161:39.22,21.34>686'}
G[15579]={'HL 321[1]:52.28,59.95'}
G[15580]={'HL 362:72.96,23.31'}
G[15581]={'HL 121:76.71,37.89'}
G[15582]={'HL 11:68.36,69.96'}
G[15583]={'HL 201:50.37,76.17'}
G[15584]={'HL 61:46.34,51.00'}
G[15585]={'HL 29:52.39,23.94'}
G[15586]={'HL 161:51.40,28.81'}
G[15587]={'HL 121:62.56,31.07'}
G[15588]={'HL 607:41.60,47.44'}
G[15592]={'HL 23:35.58,68.82'}
G[15593]={'HL 687[1]:62.93,34.38 38:69.68,53.45>687'}
G[15594]={'HL 22:69.18,73.44','On ramparts'}
G[15595]={'HL 41:56.85,53.10'}
G[15596]={'HL 37:71.04,34.29'}
G[15597]={'HL 11:48.52,59.26'}
G[15598]={'HL 381:39.22,31.86'}
G[15599]={'HL 261:53.02,35.47'}
G[15600]={'HL 181:64.73,79.35'}
G[15601]={'HL 42:49.53,18.95'}
G[15602]={'HL 22:63.51,36.13','In cave'}
G[15603]={'HL 182:38.36,52.85'}
G[15604]={'HL 61:77.09,75.61'}
G[15605]={'HL 43:35.54,48.92'}
G[15606]={'HL 281:53.22,56.75'}
G[15607]={'HL 765[1]:78.64,22.09 23:27.07,15.77>765'}
G[15608]={''}
G[15651]={'462:33.82,55.58'}
G[15659]={'301:62.39,75.02'}
G[15670]={'462:28.2,60.4'}
G[15693]={'261:33.25,81.23'}
G[15700]={'HQ 321:38,86'}
G[15727]={'766[3]:54.82,59.15'}
G[15732]={'27:60.30,33.84 40:9.17,60.70 161:52.57,28.06 301:67.84,71.45 504[1]:49.33,44.85 673:40.28,67.64'}
G[15864]={'HL 241:53.65,35.26'}
G[15871]={'HL 341:29.22,17.12'}
G[15891]={'HL 321[1]:49.89,81.20 382:66.0,36.8 362:38.38,63.40'}
G[15892]={'HL 341:30.90,61.58'}
G[15895]={'HL 30:34.24,50.56 341:28.83,16.22 381:38.60,30.27 321[1]:52.38,58.49 481:53.2,32.8 362:71.10,28.25 382:65.60,35.99 504[1]:47.63,43.76 471:74.01,57.48 480:73.05,82.56 811:85.30,64.90 811:62.92,19.27'}
G[15920]={'462:29.90,58.52'} -- 462:30.22,58.33 462:29.88,58.48 462:29.85,58.46 462:30.25,58.44
G[15921]={'462:36.35,66.62'}
G[15924]={'462:67.80,56.54'}
G[15939]={'462:43.34,70.82'}
G[15941]={'462:45.19,56.43'}
G[15942]={'462:46.93,71.78'}
G[15945]={'462:44.87,61.04'}
G[15951]={'462:60.32,61.38','Up ramp'}
G[15965]={'462:69.23,52.15'}
G[15968]={'462:36.6,60.6'}
G[15969]={'462:68.71,46.95'}
G[15970]={'462:55.70,54.50'}
G[15989]={'535[3]:0.00,0.00'}
G[15991]={'478:57.7,56'}
G[16112]={'23:75.35,76.18'}
G[16115]={'23:76.70,73.10'}
G[16116]={'23:72.65,74.84'}
G[16128]={'504[1]:30.63,48.59'}
G[16134]={'23:73.78,51.88'}
G[16135]={'23:30.22,56.88'}
G[16144]={'462:38.15,73.55'}
G[16183]={'462:49,89'}
G[16191]={'480:53.93,71.02'}
G[16192]={'462:54.37,50.72'}
G[16196]={'462:49,89'}
G[16197]={'463:46.33,28.37'}
G[16198]={'463:47.66,34.86'}
G[16199]={'463:46.02,31.97'}
G[16200]={'463:46.03,33.57'}
G[16201]={'463:72.30,19.10'}
G[16202]={'463:72.50,32.13'}
G[16203]={'463:71.95,32.64'}
G[16204]={'463:54.86,48.57'}
G[16205]={'463:48.91,31.32'}
G[16210]={'462:44.03,70.76'}
G[16213]={'463:45.48,32.43'}
G[16219]={'463:69.3,15.2'}
G[16220]={'463:72.37,29.64'}
G[16224]={'463:47.25,28.54'}
G[16227]={'11:69.13,70.70'}
G[16231]={'463:44.89,32.52'}
G[16237]={'463:60.29,35.63'}
G[16239]={'463:55.08,48.83'}
G[16240]={'463:54.83,48.35'}
G[16251]={'463:44.74,32.28'}
G[16252]={'463:44.77,32.44'}
G[16253]={'463:48.43,30.93'}
G[16261]={'462:43.69,71.55'}
G[16280]={'462:61.32,54.03'}
G[16289]={'463:44.85,32.81'}
G[16291]={'463:55,48.6'}
G[16293]={'463:31.44,48.32'}
G[16295]={'463:62.90,32.77'}
G[16314]={'463:16.2,57.6'}
G[16339]={'463:79.67,17.68'}
G[16362]={'462:44.2,85.4'}
G[16365]={'23:75.66,52.05'}
G[16388]={'Z799'}
G[16397]={'462:43.57,71.21'}
G[16399]={'673:48.3,63.3'}
G[16416]={'281:58.03,52.21'}
G[16417]={'161:50.4,27.2'}
G[16418]={'11:65.83,71.92'}
G[16462]={'463:72.20,29.77'}
G[16463]={'463:72.32,31.26'}
G[16464]={'463:72.62,31.56'}
G[16475]={'894:61.18,29.49 464:84.3,43>894'}
G[16477]={'894:52.76,35.88 464:80.4,45.8>894'}
G[16480]={'463:46.40,56.43'}
G[16499]={'894:51.55,44.45 464:79.8,49.4>894'}
G[16500]={'894:50.88,42.34 464:79.6,48.8>894'}
G[16501]={'894:51.11,41.13 464:79.7,48.3>894'}
G[16502]={'894:52.12,41.43 464:80,49.5>894'}
G[16503]={'894:50.87,43.85 464:79.6,49.4>894'}
G[16514]={'894:49.87,37.34 464:79.2,46.4>894'}
G[16522]={'894:27.78,80.42 464:69.27,65.77>894'}
G[16535]={'894:50.65,48.75 464:79.4,51.4>894'}
G[16546]={'894:33.90,69.38 464:72,60.8>894'}
G[16551]={'464:48.7,50.3'}
G[16553]={'464:48.4,49.2'}
G[16554]={'464:64.5,54.1'}
G[16574]={'465:54.3,37.9'}
G[16575]={'465:55.1,36.3'}
G[16576]={'465:65.1,44.2'}
G[16577]={'465:55.2,39.1'}
G[16583]={'465:53.2,38.2'}
G[16588]={'465:52.3,36.4'}
G[16601]={'463:57.54,14.94'}
G[16642]={'480:66.73,16.78'}
G[16648]={'480:73.05,45.28'}
G[16653]={'480:59.16,19.70'}
G[16655]={'480:71.2,56.2'}
G[16658]={'480:53.10,26.65'}
G[16661]={'480:71.73,55.75'}
G[16674]={'480:84.71,28.06'}
G[16681]={'480:92.20.37.53'}
G[16684]={'480:79.66,52.14'}
G[16721]={'464:24.45,54.55'}
G[16723]={'471:27.77,60.01'}
G[16749]={'471:47.26,62.31'}
G[16756]={'471:38.9,51.1'}
G[16761]={'471:38.93,84.85'}
G[16768]={'471:57.0,50.6'}
G[16781]={'479:32.26,68.44'}
G[16789]={'465:28.4,60.3 465:28.5,60.2'}
G[16790]={'465:27.7,60.4'}
G[16791]={'465:27,59.6'}
G[16792]={'465:27,59.8'}
G[16793]={'465:26.4,60.4 465:26.5,60.3'}
G[16794]={'465:26.8,59.7'}
G[16796]={'465:23.42,36.55'}
G[16797]={'465:23.35,37.43 465:23.36,39.32 465:23.37,41.20'}
G[16799]={'465:23.1,40.3'}
G[16802]={'480:53.81,20.26'}
G[16808]={'710[1]:67.31,55.47'}
G[16813]={'Z799'}
G[16814]={'Z799'}
G[16815]={'Z799'}
G[16817]={'HM 301:49.53,72.26 341:63.77,25.33 381:62.17,48.67 471:41.6,24.7 481:61.36,31.92'}
G[16818]={'HM 321[1]:47.73,38.20 362:21.61,27.73 382:67.64,8.27 480:69.86,42.96'}
G[16819]={'465:56.64,66.69'}
G[16820]={'465:50.91,60.20'}
G[16822]={'465:54.67,62.36'}
G[16825]={'465:54.29,63.58'}
G[16826]={'465:54.22,63.59'}
G[16827]={'465:50.88,60.35'}
G[16833]={'465:23.14,40.17'}
G[16834]={'465:23.01,40.37'}
G[16837]={'465:52,62.4 465:52,62.5'}
G[16839]={'465:56.69,66.51'}
G[16841]={'19:54.66,50.44'}
G[16845]={'465:32,27.9'}
G[16850]={'465:23.89,72.17'}
G[16851]={'465:23.98,72.34'}
G[16852]={'465:26.90,37.45'}
G[16857]={'465:49.4,65.6'}
G[16858]={'465:61,81.6'}
G[16885]={'465:16.03,52.15'}
G[16888]={'465:15.80,52.17'}
G[16915]={'465:51.36,30.53'}
G[16924]={'462:47.77,46.58'}
G[16991]={'465:15.70,52.08'}
G[16993]={'465:24.6,76.1'}
G[17006]={'465:23.09,40.22'}
G[17015]={'465:26.4,61.8 465:27.1,61.9'}
G[17062]={'465:33.6,43.6'}
G[17071]={'894:50.50,47.87 464:79.4,51>894'}
G[17079]={'261:54.6,62.8'}
G[17080]={'261:39.57,46.97'}
G[17081]={'261:53,34.7'}
G[17082]={'261:54.49,32.94'}
G[17084]={'465:25.85,74.85'}
G[17085]={'465:28.99,81.46'}
G[17089]={'894:50.20,43.14 464:79.28,49.13>894'}
G[17092]={'24:56.74,47.47'}
G[17094]={'37:38.12,50.09'}
G[17095]={'141:35.86,31.74'}
G[17098]={'321:31.8,38.3 321:49.1,71.6 321:49.2,71'}
G[17101]={'464:61.1,54.2'}
G[17106]={'43:35,49.9'}
G[17110]={'464:49.8,51.9'}
G[17114]={'464:49.37,51.08'}
G[17116]={'464:47.2,50.6'}
G[17120]={'471:55.6,82.6'}
G[17122]={'471:47.59,88.32'}
G[17123]={'465:32.1,28.3'}
G[17127]={'38:26.86,33.57'}
G[17192]={'464:33.83,18.41'}
G[17204]={'471:29.38,33.36 471:31.27,27.71'}
G[17214]={'464:48.39,51.77'}
G[17215]={'464:48.39,51.48'}
G[17226]={'465:26.3,63.7 465:26.4,63.1 465:27,62.7 465:27.1,62.1'}
G[17232]={'464:49.39,50.95'}
G[17240]={'464:47,70.1'}
G[17241]={'464:47.1,70.3'}
G[17242]={'464:47.2,70.1'}
G[17246]={'464:46.7,70.5'}
G[17287]={'43:84,62.7'}
G[17291]={'43:86.9,44.8'}
G[17303]={'43:84,62.7'}
G[17304]={'43:90.94,58.14'}
G[17307]={'797[1]:36.71,81.31'}
G[17308]={'797[1]:42.18,70.96'}
G[17310]={'43:83.9,63'}
G[17311]={'13:28.92,32.71 464:16.37,94.03'}
G[17312]={'464:13.62,73.22'}
G[17326]={'476:48.44,94.17'}
G[17355]={'43:73.16,60.11'}
G[17360]={'464:49.44,50.97'}
G[17361]={'464:55.2,41.7'}
G[17362]={'464:64.48,39.78'}
G[17363]={'464:63.1,67.8'}
G[17364]={'464:28.11,62.39'}
G[17377]={'725[1]:58.07,41.68'}
G[17421]={'476:42.1,21.2'}
G[17423]={'476:52.7,53.3'}
G[17424]={'476:54.7,54'}
G[17433]={'476:55.08,58.00'}
G[17434]={'476:53.3,57.7'}
G[17440]={'464:46.6,20.7'}
G[17441]={'464:44.65,23.49'}
G[17442]={'464:44.8,23.8'}
G[17443]={'464:46.9,22.2'}
G[17445]={'464:46.8,21.2'}
G[17468]={'471:32.86,54.48'}
G[17480]={'464:50.02,50.52'}
G[17488]={'464:48.9,51.1'}
G[17493]={'465:55.2,36.1'}
G[17508]={'476:37.4,61.4 476:37.6,61.3'}
G[17514]={'471:46.4,63.1 471:46.6,62.7'}
G[17528]={'476:38.42,82.00'}
G[17538]={'471:57.89,41.42'}
G[17545]={'477:35.4,77.8 477:35.5,77.7'}
G[17554]={'476:57.68,53.88'}
G[17555]={'471:54.48,36.31'}
G[17584]={'471:81.49,51.43','On the surface'}
G[17586]={'476:63.1,87.9'}
G[17587]={'464:37.6,19.7 464:40.0,37.6 464:42.0,57.6 464:40.6,71 464:46.7,31.9 464:54.0,42.6 464:55.8,29.0 464:55.8,48.2 464:57.6,60.8 464:58.6,41.6'}
G[17599]={'476:63.43,88.73'}
G[17600]={'476:61.2,48.4 476:61.2,48.5'}
G[17613]={'32:47,75.4 32:47,75.5'}
G[17614]={'464:24.2,54.3'}
G[17634]={'467:68.66,50.21'}
G[17636]={'479:32.3,63.6'}
G[17637]={'467:34.1,51'}
G[17642]={'476:55.9,56.9'}
G[17649]={'476:63.00,87.55'}
G[17658]={'476:52.69,53.22'}
G[17663]={'476:56.3,56.8'}
G[17674]={'476:73.9,33.4 476:74.3,34 476:74.5,33.6 476:74.6,33.4 476:75.1,34.6'}
G[17676]={'476:53.3,57.1'}
G[17682]={'476:68.26,81.08'}
G[17684]={'476:55.43,55.26'}
G[17686]={'476:24.88,34.36'}
G[17703]={'476:53.3,54.1 476:53.4,54.5 476:53.5,54.5 476:53.6,54.4 476:54.1,61.5 476:54.2,58.2 476:54.3,55.5 476:54.3,58.7 476:54.3,60.4 476:54.3,60.7 476:54.5,56 476:54.5,59.5 476:54.5,60.7 476:54.6,58.3 476:54.7,55.1 476:54.8,56.9 476:55.1,59.1 476:55.4,54.4 476:55.5,54.4 476:55.6,56.6 476:55.8,55.2 476:56,55.8'}
G[17712]={'476:79,22.3 476:79.1,22.7'}
G[17798]={'727[1]:77.76,43.87'}
G[17825]={'476:54.44,54.45'}
G[17831]={'467:23.32,66.21','Sometimes on a quest - will be back'}
G[17834]={'467:78.54,63.15'}
G[17841]={'467:78.40,62.01'}
G[17843]={'476:55.63,55.21'}
G[17844]={'476:55.55,55.43'}
G[17849]={'462:42.03,35.65'}
G[17856]={'467:19.54,50.05'}
G[17858]={'467:79.08,65.27'}
G[17866]={'467:19.65,49.69'}
G[17876]={'N:4949'}
G[17877]={'467:19.80,50.83'}
G[17881]={'733:47.92,68.38'}
G[17882]={'726[1]:26.97,46.22'}
G[17904]={'467:79.11,64.88'}
G[17909]={'467:80.32,64.17'}
G[17923]={'467:19.12,63.48'}	-- 467:19.04,62.36 467:19.00,63.38 467:19.18,64.59 pacing between the points
G[17924]={'467:19.67,52.06'}
G[17925]={'467:19.14,49.38'}
G[17926]={'476:30.3,46'}
G[17927]={'476:30.3,46'}
G[17942]={'728[1]:85.65,67.46'}
G[17956]={'467:80.39,64.16'}
G[17969]={'467:83.37,85.53'}
G[17977]={'729[1]:34.09,41.27'}
G[17982]={'476:30.82,46.66'}
G[17986]={'476:30.76,46.84'}
G[18003]={'467:68.20,49.38'}
G[18004]={'467:68.34,50.08'}
G[18005]={'467:67.81,47.91'}
G[18006]={'467:67.65,47.87'}
G[18007]={'467:68.62,48.73'}
G[18008]={'467:41.95,27.19'}
G[18009]={'467:40.85,28.66'}
G[18010]={'467:41.61,27.29'}
G[18011]={'467:85.2,54.7'}
G[18012]={'467:85,54.1'}
G[18013]={'467:30.7,50.9'}
G[18014]={'467:32.9,48.9'}
G[18015]={'467:31.7,49.3'}
G[18016]={'467:84.4,54.4 467:84.5,54.4'}
G[18017]={'467:32.4,51.9'}
G[18018]={'467:32.2,49.5'}
G[18019]={'467:41.21,28.68'}
G[18020]={'476:51.8,52.1'}
G[18024]={'476:55.5,52.4 476:55.5,52.5'}
G[18035]={'467:80.8,36.3'}
G[18063]={'477:55.4,37.7 477:55.5,37.7'}
G[18066]={'477:54.8,39.4 477:54.8,39.5'}
G[18067]={'477:54.8,39.8'}
G[18068]={'477:54.6,39.9'}
G[18070]={'467:80.37,64.72'}
G[18071]={'477:60.66,22.65'}
G[18072]={'477:60.65,22.10'}
G[18073]={'477:60.80,22.38'}
G[18074]={'477:60.50,22.38'}
G[18090]={'477:55.4,37.4 477:55.4,37.5'}
G[18091]={'467:32,50.4'}
G[18096]={'734:50.44,31.56'}
G[18098]={'475:36.30,67.56'}
G[18099]={'477:61.58,22.03 477:62.14,22.80 477:61.99,24.02 477:61.20,24.91 477:60.57,24.96 477:60.08,24.38 477:59.88,23.31 477:59.58,22.47 477:59.86,21.36 477:60.40,20.87 477:60.92,21.51','Wandering around'}
G[18106]={'477:55.6,37.6'}
G[18124]={'467:81,42'}
G[18141]={'477:56.6,34.3'}
G[18165]={'24:30.9,30.8'}
G[18166]={'481:54.74,44.33'}
G[18180]={'477:71.52,40.81'}
G[18183]={'477:55.48,68.70'}
G[18200]={'477:71.57,40.53'}
G[18209]={'477:33.18,42.31'}
G[18210]={'477:31.4,44.1 477:31.5,44'}
G[18218]={'477:71.38,40.63'}
G[18221]={'38:69.90,36.55'}
G[18222]={'477:54.47,72.08'}
G[18223]={'477:54.61,72.21'}
G[18224]={'477:54.46,72.31'}
G[18229]={'477:32.4,36 477:32.5,36.1'}
G[18233]={'477:55.51,68.78'}
G[18234]={'477:55.3,37.1 477:55.3,37.7 477:55.4,38.6 477:55.5,38.5 477:55.6,37 477:55.7,37.8'}
G[18248]={'475:52,58.2'}
G[18249]={'478:49.7,43.4'}
G[18252]={'478:58.53,53.56'}
G[18253]={'32:47.2,75.1'}
G[18255]={'32:47.30,74.93'}
G[18261]={'477:73.80,62.60'}
G[18262]={'478:19.3,64.1 478:19.8,62.1 478:20,63 478:20,63.5 478:20.5,62.8'}
G[18265]={'477:31.36,57.78'}
G[18266]={'465:56.33,62.85'}
G[18267]={'465:55.9,39.1'}
G[18273]={'478:19.7,60.8 478:77.4,87.8'}
G[18276]={'477:30.78,58.14'}
G[18285]={'467:32.80,59.60'}
G[18294]={'477:71.38,40.57'}
G[18295]={'467:68.55,49.36'}
G[18300]={'477:55.6,37.6'}
G[18301]={'477:55.2,36.1'}
G[18302]={'477:56.4,34.4 477:56.6,34.3 477:57.1,34.8'}
G[18333]={'477:31.77,56.79'}
G[18335]={'477:51.94,34.78'}
G[18340]={'467:70.51,80.31'}
G[18343]={'732[1]:32.61,60.35'}
G[18344]={'732[1]:32.56,52.69'}
G[18353]={'477:55.05,70.54'}
G[18369]={'477:72.56,70.69'}
G[18373]={'722[1]:0.00,0.00'}
G[18383]={'478:48.8,45.6'}
G[18384]={'478:50.1,46.4'}
G[18385]={'478:50.1,44.9'}
G[18386]={'478:48.9,44.7'}
G[18387]={'478:58.29,54.76'}
G[18389]={'478:57.83,54.24'}
G[18390]={'478:57.40,55.43'}
G[18407]={'477:55.8,37.9'}
G[18408]={'477:54.74,70.88'}
G[18414]={'477:32.3,36.2'}
G[18415]={'477:32.3,36.2'}
G[18416]={'477:53.03,7084 477:53.58,70.99 477:53.85,71.35 477:53.57,71.99 477:54.30,72.34 477:54.53,72.66 477:54.54,73.61 477:55.33,73.26 477:55.69,72.65 477:55.36,71.52 477:54.71,70.37 477:54.33,70.35 477:54.12,69.42 477:53.71,68.69 477:53.86,69.97','Wandering the village'}
G[18417]={'477:27.34,43.08'}
G[18424]={'478:44.03,22.44 478:44.75,21.71 478:44.89,21.12 478:43.69,23.07 478:43.29,23.02 478:43.37,22.59 478:43.44,22.39 478:44.40,24.77'}
G[18427]={'476:53.66,56.26'}
G[18445]={'477:29.52,26.01 N:18369'}
G[18446]={'478:44.33,26.31'}
G[18447]={'478:50,45.9'}
G[18459]={'478:57.01,53.49'}
G[18471]={'477:42.8,20.8'}
G[18473]={'723[2]:32.81,32.17'}
G[18481]={'481:53.99,44.73'}
G[18482]={'478:11.8,99.2 478:36.4,30.2 478:36.5,30.3 478:36.6,30.6 478:38,26.4 478:38.1,26.5 478:38.7,26.6 478:39.4,24.1 478:39.4,26.3 478:39.5,26.5 478:39.6,24.1 478:40.3,24.9 478:40.4,25.6 478:40.5,25.6 478:40.7,25.4 478:41.9,26.4 478:42.3,26.5 478:42.5,26.6 478:43.3,26.4 478:43.5,26.3 478:43.6,26.5 478:44.5,26.2 478:44.6,26.5 478:45.5,26.4 478:45.5,26.5 478:46,66.7 478:46.5,26.4 478:47.2,27.1 478:47.4,66.7 478:47.9,27.2 478:47.9,66.8 478:48.4,27.5 478:48.5,27.4 478:48.6,27.7 478:48.7,67 478:49.6,28.2 478:50.4,29.2 478:50.5,29.2 478:50.6,29.5 478:84.4,54.2 478:84.8,55.4 478:86.2,55.9 478:90.2,54.7 478:90.6,54.1 478:92.3,52.7 478:94.6,51.1 478:96.6,54.1 478:97.6,53.3 478:98.2,52.4 481:9,92.8 481:37.3,26.3 481:37.7,24.6 481:37.9,26.3 481:77.4,66.9 481:77.4,67.7 481:77.5,64.4 481:77.5,64.7 481:77.6,62.9 481:78,61.3 481:78.1,61.9 481:78.8,61.5 481:79.1,57.1 481:79.1,61.4 481:79.2,58.5 481:79.8,21.3 481:79.8,21.9 481:80.1,55.4 481:80.4,55.6 481:80.4,57.1 481:80.7,55.2 481:80.7,55.9 481:80.9,54.4 481:81.1,30 481:81.1,30.7 481:81.3,34 481:81.5,33.7 481:81.5,54.5 481:81.6,54.1 481:81.8,34.9 481:81.9,53.3 481:82.2,36.4 481:82.2,40.8 481:82.3,52.2 481:82.6,40.3 481:82.8,41.2 481:82.8,51.9 481:82.8,52.5 481:82.9,41.8 481:83,47.3 481:83,49.1 481:83.1,44.3 481:83.1,44.9 481:83.1,47.8 481:83.1,53.5 481:83.2,49.7 481:83.3,54.5 481:83.5,47.1 481:83.6,40.3 481:83.7,54 481:83.9,53.2 481:84,54.5 481:84.3,55.7 481:84.6,54.5'}
G[18484]={'481:72.23,30.73'}
G[18528]={'473:65.3,44'}
G[18530]={'481:42.6,91.4'}
G[18531]={'481:45.20,81.45'}
G[18537]={'481:30.72,34.60'} -- 479:29.6,14.5 479:30.7,17.4 479:30.7,17.5 481:25,21.5 481:41.6,65.2 481:82.6,49.3
G[18538]={'481:23.97,29.72'}	-- 479:29.5,13.9
G[18565]={'478:69.74,44.23'}
G[18566]={'478:63.38,42.72'}
G[18584]={'481:77.2,34.7'}
G[18594]={'481:54.61,80.71'}
G[18596]={'481:54.98,22.53'}
G[18597]={'481:64.47,15.12'}
G[18653]={'481:63.94,15.55'}
G[18675]={'478:37.06,49.53'}
G[18687]={'477:26.1,60.6'}
G[18704]={'478:58.11,53.42'}
G[18705]={'478:49.3,45.9'}
G[18708]={'724[1]:77.70,38.73'}
G[18712]={'478:48.9,44.7'}
G[18713]={'478:57.51,55.77'}
G[18714]={'478:39,43.8'}
G[18715]={'478:40.46,36.15'}
G[18723]={''}		-- Old Hillsbrad
G[18745]={'478:57.18,55.74'}
G[18760]={'478:73.92,35.19'}
G[18785]={'465:25.19,37.23'}
G[18788]={'467:67.83,51.46'}
G[18789]={'477:54.17,75.06'}
G[18803]={'476:55.16,55.97'}
G[18804]={'476:56.1,54.5 476:56.3,54.3'}
G[18809]={'478:59.45,55.42'}
G[18816]={'477:41.2,44.3'}
G[18817]={'477:41.2,44.3'}
G[18891]={'724[1]:17.18,22.21'}
G[18893]={'481:50.24,45.35'}
G[18927]={'301:61.67,74.19'}
G[18930]={'465:87.4,48.2'}
G[18931]={'465:87.37,52.42'}
G[18937]={'475:37.82,61.40'}
G[18938]={'479:33.75,63.99'}
G[18939]={'473:37.61,55.45'}
G[18940]={'481:64.07,41.13'}
G[18944]={'465:84.7,50.2 465:84.8,50.6 465:86.3,50.6 465:86.4,50.3 465:86.5,50.3 465:86.6,50.6 465:88.3,50.3 465:89.4,50.2'}
G[19020]={'477:55.50,36.01'}
G[19035]={'477:61.70,67.09','Pacing about'}
G[19045]={'481:57.99,15.17'}
G[19133]={'477:55.4,37.4 477:55.4,37.5 477:55.5,37.3'}
G[19137]={'477:55.01,70.39'}
G[19148]={'341:30.80,62.93'}
G[19169]={'480:89.66,49.09'}
G[19171]={'471:51.92,42.65'} -- 13:29.36,28.27 464:21.36,54.25>13
G[19172]={'341:58.14,49.39'}
G[19173]={'381:44.71,52.78'}
G[19175]={'321[1]:51.54,75.05'}
G[19176]={'321[1]:40.32,48.97'}
G[19177]={'321[1]:49.98,61.47'}
G[19178]={'382:63.17,47.40'}
G[19188]={'465:15.2,40.8'}
G[19202]={'481:62.81,35.59'}
G[19217]={'479:31.4,66.2'}
G[19219]={'730[1]:50.34,39.53'}
G[19220]={'730[1]:0.00,0.00'}
G[19227]={'481:65.65,69.29'}
G[19229]={'465:87.34,50.75'}
G[19253]={'465:87.4,49.8'}
G[19254]={'19:54.4,50.4 19:54.4,50.5 19:54.5,50.4 19:54.5,50.7'}
G[19255]={'465:55.9,36.8'}
G[19256]={'465:58,41.3'}
G[19273]={'465:65.9,43.6'}
G[19293]={'465:15.62,52.04'}
G[19294]={'465:15.96,51.57'}
G[19306]={'732[1]:32.52,50.64'}
G[19308]={'465:54.68,62.78'}
G[19309]={'465:61.70,60.90'}
G[19310]={'465:71.34,62.76'}
G[19333]={'473:29.8,31.3'}
G[19344]={'465:49.24,74.83'}
G[19361]={'465:16.27,65.08'}
G[19367]={'465:49.15,74.84'}
G[19370]={'473:36.8,54.8'}
G[19401]={'465:66.1,43.8'}
G[19402]={'467:83.35,37.54'}
G[19409]={'465:71.40,62.48'}
G[19412]={'Z722'}
G[19417]={'478:35.07,66.19'}
G[19428]={'723[1]:0.00,0.00'}
G[19456]={'462:37.59,86.23'}
G[19466]={'479:32.1,64.2'}
G[19467]={'479:30.7,17.5 479:32,64.2'}
G[19468]={'479:32,64.1'}
G[19469]={'479:32,64.1'}
G[19471]={'475:53.1,54.5 475:53.2,54.4'}
G[19475]={'481:61.65,52.16'}
G[19481]={'479:58.3,86.4 479:58.4,86.5'}
G[19488]={'479:57.5,86.3'}
G[19489]={'479:57.5,86.3'}
G[19569]={'479:20.2,55.9 479:21.3,55.7 479:21.8,55.6'}
G[19570]={'479:32.6,64.4'}
G[19578]={'479:31.5,56.6'}
G[19581]={'473:63.33,30.40'}
G[19583]={'479:45.31,34.88'}
G[19589]={'479:32,55.4'}
G[19606]={'478:49.8,45.3'}
G[19617]={'479:32.3,63.9'}
G[19622]={'782[1]:49.82,15.60'}
G[19634]={'479:34.1,68.1'}
G[19644]={'Near'}
G[19645]={'479:32.9,64.7'}
G[19670]={'478:39.42,58.53'}
G[19671]={'Z732'}
G[19674]={'478:39.38,58.47'}
G[19678]={'481:64.71,70.68'}
G[19682]={'465:61.7,81.7'}
G[19683]={'465:61.8,81.5'}
G[19684]={'481:59.67,41.43 481:77.20,43.53 481:60.71,14.64'}
G[19690]={'479:26.9,77'}
G[19697]={'478:35.09,65.09'}
G[19698]={'478:35.1,65.2'}
G[19709]={'479:32.4,66.7'}
G[19715]={'481:49.41,35.21 481:52.44,33.20 481:56.29,33.45 481:59.70,36.21 481:61.64,40.87 481:61.43,48.58 481:58.53,54.45 481:53.52,56.94 481:48.19,53.04','Walks in circle around outside of Terrace of Light'}
G[19720]={'481:43.63,29.77'}
G[19728]={'479:46.6,56.4 479:46.6,56.5'}
G[19736]={'465:61.7,81.7'}
G[19832]={'479:37.3,63.8'}
G[19840]={'479:48.2,86.7'}
G[19844]={'477:51.81,56.85'}
G[19860]={'161:51.63,28.00'}
G[19880]={'479:32.4,64.3 479:32.5,64.2'}
G[19935]={'161:57.5,56.5 161:57.6,55.9 161:57.7,55.2 161:57.9,58.4 161:58.2,54.3 161:58.2,58.7 161:58.6,54.5 161:59,58.9 161:59.1,53.9 161:59.6,54.1 161:59.8,58.2 161:60.2,57.4 161:60.3,54.7 161:60.5,55.1 161:60.5,56.8 161:60.6,55.8'}
G[19936]={'161:57.6,55.8 161:57.6,56.8 161:57.7,57.5 161:57.9,54.8 161:58.3,54.4 161:58.3,58.7 161:58.7,54.5 161:58.8,58.8 161:59.1,54 161:59.5,54.1 161:59.7,58.2 161:60,54.5 161:60,58.8 161:60.2,57.3 161:60.5,55.1 161:60.5,56.8 161:60.6,55.8 161:60.6,58'}
G[19937]={'465:56.9,77.4'}
G[19945]={'475:34.41,77.74'}
G[19990]={'475:42,21'}
G[19995]={'475:43,53'}
G[19998]={'475:40,56'}
G[20066]={'479:46.7,57'}
G[20067]={'479:44,36'}
G[20071]={'479:58.3,31.6 479:58.8,31 479:60,30.9'}
G[20084]={'479:45.8,36'}
G[20092]={'479:58.4,31.4'}
G[20102]={'11:69.03,70.67'}
G[20110]={'479:71.2,35.2'}
G[20112]={'479:34.6,37.9'}
G[20130]={'161:58.06,54.10'}
G[20142]={'161:65.35,49.72'}
G[20154]={'479:70.9,38.8'}
G[20159]={'465:5.1,51.1 465:5.7,51.1 465:6.4,50.4 465:6.5,50.5 465:6.7,50.4 465:8.4,50.1 465:9,50.5 465:9.4,50.4 465:9.6,50.5 465:9.7,50.4 465:10.5,50.3 465:11.4,50.7 465:11.6,50.5 465:12.1,50.1 465:13.2,50.1 465:13.5,50.1 465:14.9,50.1 465:15.5,51.6 465:15.6,50.9 465:16.1,50.1 465:16.5,50.7 465:17.1,50 465:17.8,49.9 465:19.2,49.6 465:19.4,48.9 465:19.5,49.4 465:19.5,49.6 465:20.7,49.2 465:21.6,49.7 465:22,49.2 465:23.2,49.2 465:23.2,49.5 465:23.8,49.5 465:24.2,49.3 465:24.7,49.3 465:24.7,49.5 465:25.3,61.9 465:25.4,60.3 465:25.5,60.7 465:25.6,61.5 465:25.7,59.7 465:26,49.4 465:26,63 465:26.1,49.5 465:26.1,58.3 465:26.3,58.8 465:26.6,58.7 465:26.7,49.4 465:26.9,49.6 465:27.4,58.2 465:27.6,57.9 465:28.1,50.1 465:28.4,57.3 465:28.5,57.5 465:28.9,50.4 465:29,50.7 465:29.1,57 465:30,51.5 465:30.2,51.4 465:30.3,57.1 465:30.7,57.3 465:31.1,52.4 465:31.1,57.5 465:31.3,52.9 465:31.6,53.3 465:31.7,53.6 465:31.8,57.5 465:31.9,57.4 465:32,54.6 465:32.3,56.4 465:32.5,56.3 465:32.5,56.6 465:45.8,52.2 465:46.6,52.1 465:48,52 465:48.8,51.8 465:50.3,55.4 465:50.3,55.9 465:50.5,54.7 465:51.5,54.1 465:51.9,52.8 465:83.3,65.9 465:85.9,64.9 465:86.8,64.9 465:90.2,65.1 465:91.1,65.1 465:91.9,65'}
G[20162]={'479:33.8,64.2'}
G[20201]={'Z733'}
G[20205]={'479:44.8,36.7'}
G[20206]={'465:56.38,62.91'}
G[20232]={'465:79.34,33.86'}
G[20233]={'894:49.72,37.53 464:79.1,46.6>894'}
G[20234]={'465:78.41,34.90'}
G[20235]={'465:78.26,34.45'}
G[20281]={'479:48.1,63.4 479:48.1,63.5 479:48.7,63.5 479:49.4,64.7 479:49.4,65.8 479:49.5,65.8'}
G[20341]={'479:34.6,37.8'}
G[20393]={'479:26.4,42.3 479:26.4,42.5'}
G[20406]={'382:57.98,90.45'}
G[20407]={'301:65.94,31.37'}
G[20415]={'479:58,84.8 479:58.6,84.8 479:59.1,78.9 479:59.1,79.5 479:59.2,80.7 479:59.2,82.4 479:59.2,83 479:59.2,83.8'}
G[20448]={'479:59.4,32.3 479:59.5,32.3'}
G[20449]={'479:59.2,32.4 479:59.3,32.5'}
G[20450]={'479:59.1,32.1 479:59.9,31.9 479:60.1,32.5'}
G[20463]={'479:57.7,85.2'}
G[20464]={'479:57.7,85'}
G[20470]={'479:44.7,34.9'}
G[20471]={'479:44.7,34.9'}
G[20482]={'479:56.8,38.7'}
G[20494]={'473:29.1,29.4 473:29.1,29.5'}
G[20510]={'473:37.6,56'}
G[20515]={'479:65.20,66.81'}
G[20518]={'479:71.2,39'}
G[20551]={'479:59.4,45.1'}
G[20552]={'479:60.9,41.6'}
G[20604]={'471:62.8,66.9 471:63.6,68.1'}
G[20612]={'480:56.6,52.8'}
G[20677]={'465:13.12,61.03'}
G[20678]={'465:15.6,58.7'}
G[20679]={'465:13.01,58.43'}
G[20735]={'504[1]:57.22,66.83'}
G[20763]={'479:57,37.7 479:57.1,35.3 479:57.1,37.1 479:57.2,32.3 479:57.2,35.8 479:57.8,32.1'}
G[20779]={'479:54.8,43.4'}
G[20780]={'479:34.8,38.2'}
G[20793]={'465:68.30,28.54'}
G[20810]={'479:46.4,56.4 479:46.4,56.5 479:46.5,56.4 479:46.5,56.5'}
G[20811]={'479:43.5,35.1'}
G[20871]={'479:42.3,32.6'}
G[20907]={'479:60.1,31.8'}
G[20912]={'731[1]:0.00,0.00'}
G[20913]={'479:44.7,14.5'}
G[20914]={'471:81.4,52.6'}
G[20920]={'479:26.2,41.6'}
G[20921]={'479:46.4,56.1 479:46.5,56.1'}
G[21006]={'478:69.66,44.17 478:69.67,43.95'}
G[21007]={'478:63.29,42.39 478:63.41,42.47 478:63.21,42.30 478:63.33,42.68'}
G[21024]={'473:42.2,45'}
G[21027]={'473:52.1,18.8 473:52.3,19.5 473:52.4,20.5 473:52.5,20.4 473:52.5,20.6 473:53,21.9 473:53.3,24.5 473:53.4,19.4 473:53.4,24.4 473:53.6,19.5 473:53.7,21.9 473:53.8,24.7 473:54.2,18.8 473:54.2,24.2 473:54.3,21.3 473:54.5,21.2 473:54.5,23.8 473:54.9,19.3 473:55,23.4 473:55.3,20 473:55.5,20.2 473:55.7,22.6 473:55.8,20.6 473:55.9,22'}
G[21066]={'475:36.3,67.2'}
G[21088]={'475:76,60.4'}
G[21107]={'475:61.15,70.44'}
G[21110]={'475:60.9,68.2'}
G[21112]={'475:60.7,69'}
G[21117]={'475:52.2,57.6'}
G[21118]={'475:60.1,68.3 475:60.3,69 475:60.5,68.3 475:60.5,69.3'}
G[21133]={'465:70.96,63.37'}
G[21147]={'475:51.9,58.4 475:51.9,58.5'}
G[21151]={'475:37.4,64.7 475:37.5,64.7'}
G[21158]={'475:36.3,66.3 475:36.6,66.5'}
G[21175]={'465:55.1,36'}
G[21183]={'473:53.9,23.4 473:53.9,23.5'}
G[21197]={'475:37.4,65 475:37.5,65'}
G[21209]={'465:51.15,60.22'}
G[21256]={'465:55.1,36.3'}
G[21257]={'465:66.2,42'}
G[21277]={'475:44,51.9'}
G[21279]={'465:61.2,81.7'}
G[21283]={'465:55.2,38.7'}
G[21291]={'473:44.6,23.7'}
G[21292]={'473:29.6,50.4 473:29.6,50.5'}
G[21293]={'473:47.5,57.2'}
G[21300]={'475:68.96,33.00'}
G[21311]={'475:52.8,58.9'}
G[21318]={'473:29.6,50.4 473:29.6,50.5'}
G[21330]={'473:35.8,57.7'}
G[21349]={'475:45,72.3'}
G[21357]={'473:39.5,53.7'}
G[21359]={'473:30.4,32.4 473:30.4,32.5 473:30.5,32.4 473:30.5,32.5'}
G[21400]={'478:57.66,53.31'}
G[21402]={'473:62.5,28.5 473:62.6,28.4'}
G[21411]={'481:63.95,70.03'}
G[21460]={'475:60.3,68.3'}
G[21465]={'478:77.57,38.72'}
G[21469]={'475:37,65.7'}
G[21471]={'473:40.4,41.3 473:40.5,41.3'}
G[21475]={'473:38.6,38.2'}
G[21496]={'475:75.2,62.1'}
G[21499]={'473:24,35'}
G[21657]={'473:57.1,55.5 473:57.3,54.8 473:57.3,56.6 473:57.4,54.3 473:57.5,54.6 473:57.6,57.2 473:58.3,53.8 473:58.4,58.2 473:58.6,53.5 473:58.7,53.4 473:59.2,58.4 473:59.3,58.6 473:59.5,53.4 473:59.6,58.4 473:60,53.9 473:60.2,59 473:60.4,59.5 473:60.5,59.4 473:60.6,54.2 473:61.2,54.8 473:61.2,58 473:61.4,60.1 473:61.6,58.4 473:62,55.3 473:62.2,63.4 473:62.3,60.2 473:62.3,61.5 473:62.4,55.6 473:62.5,55.4 473:62.9,60.4 473:62.9,60.5 473:63,55.7 473:63.7,61 473:63.9,56.1 473:64.4,56.7 473:64.5,56.4 473:64.7,60.8 473:65.1,57.1 473:65.6,60.7 473:65.9,57.4 473:66.1,57.6 473:66.2,60.4 473:66.5,57.7 473:66.5,60.3 473:66.5,60.5 473:67.8,60.4 473:67.9,58.2 473:68,58.5 473:68.3,60.5 473:68.3,83.9 473:68.5,58.4 473:68.8,60.9 473:69.1,83.7 473:69.2,61.7 473:69.2,85.4 473:69.3,58.6 473:69.4,63.2 473:69.4,63.6 473:69.6,63.4 473:69.7,63.8 473:69.7,84.1 473:69.8,58.9 473:70.4,86 473:70.6,59.2 473:70.6,64 473:70.9,59.8 473:71.1,85.8 473:71.2,63.4 473:71.3,60.7 473:71.5,63.5 473:71.6,62.9 473:71.7,60.9 473:71.8,62.4 473:72.1,85.3'}
G[21690]={'475:55.1,72.8'}
G[21691]={'475:60.4,69.1 475:60.5,69'}
G[21700]={'473:58.1,48.3'}
G[21755]={'475:60.3,69'}
G[21769]={'473:28.4,26.5 473:28.5,26.4 473:28.5,26.5'}
G[21770]={'473:30,28.3'}
G[21771]={'473:30.4,30.9 473:30.5,30.9'}
G[21772]={'473:29.9,27.7'}
G[21773]={'473:36.3,56.9'}
G[21774]={'473:36.4,55.7 473:36.4,56.7 473:36.6,55.6 473:36.6,56.5 473:36.8,55.2 473:38.1,54.5 473:61.8,84 473:90.2,83 473:90.3,83.9 473:90.4,82 473:90.7,82.7 473:90.7,84'}
G[21775]={'473:38.3,54'}
G[21777]={'473:36.6,55.2'}
G[21782]={'475:62.2,39.1'}
G[21789]={'473:27.4,21.2 473:27.5,21.2'}
G[21790]={'473:40.8,22.3'}
G[21797]={'473:58.2,70.8'}
G[21810]={'475:59,36'}
G[21822]={'473:61.2,29.2'}
G[21824]={'475:60.4,68.8'}
G[21826]={'473:57.3,49.6'}
G[21860]={'473:61.2,29.2'}
G[21895]={'475:75.8,61.4 475:75.8,61.5'}
G[21896]={'475:75.8,61.4 475:75.8,61.5'}
G[21902]={'478:39.51,54.37'}
G[21937]={'473:36.4,56.9'}
G[21938]={'473:28.5,26.5'}
G[21950]={'475:52.7,59'}
G[21953]={'473:54.7,58.2'}
G[21954]={'473:55.8,58.2'}
G[21955]={'473:56.3,59.5'}
G[21962]={'Z731'}
G[21983]={'475:61.9,39.4 475:61.9,39.5'}
G[21984]={'475:51.8,58.4 475:51.8,58.5'}
G[21998]={'473:21.8,40.9 473:23.1,37.1 473:23.5,34.1 473:23.6,36.9 473:27.2,42.5 473:27.4,21 473:28.4,32.6 473:28.6,32.7 473:28.8,26.9 473:29.4,28.2 473:29.8,28.4 473:30.2,28.6 473:30.3,31 473:30.8,37.9 473:30.9,30.4 473:33,39.2 473:33.9,43 473:35.3,42.5 473:35.6,41.9 473:36,39.1 473:36,68.4 473:36,69.1 473:36.7,69.4 473:37,47.9 473:37.1,37.5 473:37.2,68.3 473:37.4,69.7 473:37.7,21.5 473:37.7,38.2 473:37.7,68.2 473:37.8,38.5 473:38.4,70.2 473:38.7,71.4 473:38.7,71.9 473:39.2,69.6 473:39.3,59 473:39.3,59.9 473:39.5,65.2 473:39.8,70.5 473:40,69.6 473:40.3,69.2 473:40.4,72.2 473:40.7,38.9 473:40.7,68.1 473:40.8,69.3 473:41.1,69.6 473:41.1,71.4 473:41.5,70 473:41.9,45.6 473:42.1,72.8 473:42.2,44 473:42.2,45.1 473:42.2,68.7 473:42.4,70.7 473:42.5,67.4 473:42.5,68.4 473:42.5,72.8 473:42.8,55.6 473:42.8,70.7 473:42.9,69.4 473:43,72.2 473:43.1,51.8 473:43.1,62.6 473:43.4,66.4 473:43.4,69.9 473:43.5,63.3 473:43.5,71.2 473:43.6,73.1 473:44,72.4 473:44.1,40.2 473:44.5,52.9 473:44.6,48.4 473:44.7,44.8 473:45.8,55.5 473:46.6,48.6 473:46.9,57.1 473:47,66.3 473:47.1,63.2 473:47.2,71.6 473:47.4,47.1 473:47.4,65.4 473:47.6,57.2 473:47.7,62.7 473:48.3,57.5 473:48.4,66.5 473:48.9,63.3 473:49.2,58.6 473:49.3,61.2 473:49.3,71.2 473:49.6,59.4 473:49.6,62.4 473:49.6,71.3 473:50.2,64.6 473:50.3,63.5 473:50.4,57.4 473:50.4,57.5 473:50.4,60.8 473:50.4,68.3 473:50.4,69.9 473:50.6,63.2 473:50.8,58.1 473:50.8,58.6 473:50.8,61.3 473:50.8,65.6 473:50.9,59.8 473:50.9,64.4 473:50.9,66.8 473:51,61.6 473:51,64.5 473:51,69 473:51.1,70.6 473:51.2,68.2 473:51.3,57.4 473:51.3,69.6 473:51.5,67.8 473:51.6,57.4 473:51.6,66.3 473:51.8,53.9 473:51.8,63 473:51.8,63.7 473:51.9,61 473:51.9,72.8 473:52,65.2 473:52.1,58.2 473:52.1,60.4 473:52.1,67 473:52.1,70.3 473:52.1,72.4 473:52.2,23 473:52.2,58.9 473:52.3,62.1 473:52.4,68.5 473:52.4,70.9 473:52.5,58.3 473:52.5,72.8 473:52.6,20.8 473:52.6,59.9 473:52.6,63.6 473:52.7,69.6 473:52.8,64.5 473:52.9,57.1 473:52.9,67.4 473:52.9,71.2 473:53,59 473:53,61.2 473:53,68.4 473:53,73.8 473:53.1,68.8 473:53.2,62.6 473:53.2,66 473:53.4,22.6 473:53.4,62 473:53.4,71.6 473:53.5,62.2 473:53.5,67.1 473:53.5,71.6 473:53.6,59.7 473:53.6,64.6 473:53.6,71.4 473:53.7,61.1 473:53.7,67.9 473:53.8,69.9 473:54.1,64.4 473:54.2,63.4 473:54.2,69 473:54.4,66.1 473:54.5,58.7 473:54.5,61.1 473:54.6,59.6 473:54.6,63.2 473:54.6,63.9 473:54.6,64.5 473:54.6,65.5 473:54.8,68.9 473:54.9,38.8 473:55,49.6 473:55,69.5 473:55.3,48.3 473:55.6,59.1 473:55.7,45.2 473:55.7,67.2 473:55.8,36.6 473:56.1,61.4 473:56.9,69.1 473:58.2,70.7 473:58.6,66.4 473:58.8,41.4 473:58.8,58.5 473:59,58.3 473:59,66.7 473:59.6,56.5 473:59.7,43.1 473:59.7,70.2 473:60,42.2 473:61.1,35.2 473:61.1,67.5 473:61.2,40.6 473:61.4,63.9 473:61.7,41 473:62.3,40.3 473:62.3,55.5 473:63.2,30.5 473:63.4,47.9 473:63.4,51.4 473:64,46.5 473:64.3,39.1 473:64.4,88 473:64.7,85.1 473:65,86.1 473:69.4,50.8 473:96.8,90.1'}
G[22004]={'475:75.3,60.9'}
G[22007]={'475:61.9,39.4 475:62,39.5'}
G[22020]={'475:62.7,40.3'}
G[22024]={'473:35.2,39.3 473:35.2,40.2 473:35.2,40.8 473:35.4,37.4 473:35.4,38.3 473:35.4,41.8 473:35.5,41.9'}
G[22042]={'473:38.7,54.2'}
G[22043]={'473:31,29.9'}
G[22053]={'475:61.3,38.4 475:61.3,38.5'}
G[22059]={'473:23.6,36.8 473:34.9,67.6 473:35.6,42.5 473:36,67.9 473:36.3,55.1 473:36.3,69.5 473:36.4,56.7 473:36.6,47.5 473:36.6,56.3 473:36.6,56.5 473:37,54.8 473:37.1,68 473:37.2,66.8 473:37.5,54.9 473:37.6,55.5 473:37.7,38.6 473:37.7,67.1 473:38.1,54.4 473:38.1,67.6 473:38.2,70.2 473:38.4,57.2 473:38.4,68.5 473:38.6,55.3 473:38.7,53.7 473:39.1,45.1 473:39.1,69.1 473:39.3,69.7 473:39.7,50.6 473:40,71.5 473:40.2,71.3 473:40.3,69.3 473:40.6,55.4 473:40.6,71 473:40.7,60.2 473:40.9,21.7 473:41.2,69.2 473:41.3,70.1 473:41.8,69.2 473:42.1,45.2 473:42.1,71.4 473:42.2,72.9 473:42.3,70 473:42.5,62.3 473:42.6,68 473:42.7,72.2 473:42.8,69.3 473:42.8,69.5 473:43,70.6 473:43.2,59.1 473:43.4,54.3 473:43.4,73.2 473:43.5,70.9 473:43.5,71.8 473:43.8,70.3 473:43.9,45.4 473:44,59.2 473:44.1,72.6 473:45.2,62.1 473:45.4,55.8 473:46.7,48.9 473:46.7,54 473:46.9,58.8 473:47.5,53.7 473:49.3,58.1 473:49.3,71.3 473:49.7,68.9 473:50.1,59.8 473:50.2,62 473:50.3,62.6 473:50.4,58.3 473:50.4,64.4 473:50.8,58.8 473:50.8,62.1 473:50.9,57.7 473:50.9,59.9 473:50.9,66.7 473:50.9,69.7 473:51,64.5 473:51.1,62.8 473:51.1,69 473:51.1,70.6 473:51.3,71.5 473:51.4,61.2 473:51.4,64 473:51.4,65.6 473:51.4,68 473:51.5,62 473:51.5,72.8 473:51.8,63.2 473:51.8,66.3 473:52,58.3 473:52,64.4 473:52,65.2 473:52.1,60 473:52.1,66.5 473:52.2,59.1 473:52.2,60.7 473:52.2,68.7 473:52.2,72.4 473:52.3,67.6 473:52.3,69.6 473:52.4,71 473:52.6,69.4 473:52.7,64.1 473:52.7,66 473:52.8,71 473:52.9,63.2 473:52.9,68.4 473:52.9,69.5 473:53,61.2 473:53,65.3 473:53.2,62.2 473:53.2,66.5 473:53.3,59.7 473:53.4,59.2 473:53.4,71.9 473:53.5,59.9 473:53.5,71.5 473:53.6,63.7 473:53.8,61.1 473:53.8,69.9 473:54,67.6 473:54.1,68.7 473:54.2,56.5 473:54.2,62.7 473:54.2,65.3 473:54.2,70.5 473:54.6,49.9 473:54.7,58.8 473:54.7,63.8 473:54.7,68.8 473:55.3,50.7 473:55.5,68.9 473:55.8,59 473:55.8,66.2 473:55.9,56.4 473:56.2,57.1 473:56.4,58.4 473:56.5,57 473:56.8,68.9 473:57.4,66.8 473:57.4,73.9 473:58.3,70.7 473:59,58.7 473:62.5,88.5 473:64.6,62.5 473:67.3,87.3 473:69.8,51.6 473:93,97.3 473:96.9,99'}
G[22103]={'475:53.2,41.1'}
G[22107]={'465:61.2,81.3'}
G[22112]={'473:69.8,61.4'}
G[22113]={'473:59.4,58.7 473:62.5,60.3'}
G[22127]={'475:62.5,38.4'}
G[22133]={'475:62.6,38.3'}
G[22149]={'475:62,38'}
G[22150]={'475:62,38'}
G[22211]={'473:56.3,58.7'}
G[22214]={'473:62.2,29.2'}
G[22215]={'475:36.4,23.4 475:36.5,23.5 475:36.6,23.2 475:37.2,22.2'}
G[22216]={'475:61.68,39.62'}
G[22231]={'465:61.6,81.8'}
G[22272]={'478:37.37,51.28'} -- 478:37.37,50.94 478:37.59,51.41 478:37.16,50.92 478:37.52,51.24 478:37.51,51.54
G[22278]={'478:37.45,50.76'}
G[22292]={'481:52.53,21.00'}
G[22293]={'479:38.1,25.6'}
G[22312]={'475:74.9,60.5'}
G[22364]={'478:31.43,75.65'}
G[22365]={'478:37.73,51.35'}
G[22370]={'478:37.25,50.84 478:37.29,50.99 478:37.71,51.76 478:38.37,51.22 478:38.16,50.50 478:37.83,50.02'}
G[22373]={'481:51.78,20.79'}
G[22377]={'478:30.62,49.07','In Shadow Tomb'}
G[22386]={'475:50,36'}
G[22420]={'478:37.86,51.68'}
G[22421]={'Z728 X'}
G[22423]={'475:1.7,91.6 475:60.8,60 475:61.4,60.5 475:61.7,58.9 475:61.7,60.7 475:62.2,60.4 475:62.3,62.3 475:62.3,65.2 475:62.4,62.5 475:62.5,59.2 475:62.6,64.2 475:62.8,60.4 475:62.8,60.9 475:63,62.1 475:63,63.1 475:63,65 475:63.2,66.5 475:63.4,65.7 475:63.4,67.8 475:63.5,59.3 475:63.5,66 475:63.6,72 475:63.7,62.9 475:63.7,67.6 475:63.9,67.1 475:64,61.9 475:64,65.2 475:64.2,69.8 475:64.3,68.9 475:64.9,67.6 475:64.9,69.3 475:65.1,70.3 475:65.5,70.3'}
G[22424]={'478:53.71,72.38'}
G[22429]={'481:48.6,18.6','Walks in this area'} -- 481:49.61,16.42 481:51.67,15.10 481:52.08,17.73 481:50.13,18.25 481:45.39,22.67 481:46.43,20.02
G[22430]={'465:54.32,63.64','Upstairs'}
G[22433]={'473:65.9,87.1'}
G[22446]={'478:31.01,76.12'}
G[22456]={'478:31.06,76.53'}
G[22458]={'478:30.10,76.14'}
G[22462]={'478:49.71,76.19'}
G[22479]={'479:66.4,67.2'}
G[22481]={'478:30.98,76.18'}
G[22485]={'467:41.28,29.00'}
G[22488]={'475:32.2,91.2'}
G[22489]={'475:53,96.2'}
G[22497]={'481:56.44,49.13'}
G[22818]={'HC Near'}
G[22819]={'481:75.06,47.88'}
G[22820]={'780[1]:48,18.2 467:51.90,33.40>780'}
G[22823]={'467:19.2,51.6'}
G[22836]={'477:31.49,57.61'}
G[22893]={'477:42.8,20.7'}
G[22899]={'479:45.8,36.2'}
G[22914]={'FC Near'}
G[22919]={'475:52.9,15 N:20482'}
G[22931]={'182:51.53,80.87'}
G[22935]={'43:85.09,43.45'}
G[22940]={'481:64.96,68.09'}
G[22941]={'475:55.48,44.86','On tower'}
G[22995]={'475:55.42,45.25'}
G[23010]={'HV 471:55.81,48.84'}
G[23035]={'723[2]:32.55,59.78 N:80648'}
G[23038]={'478:64.09,66.89'}
G[23042]={'478:64.05,66.88'}
G[23048]={'478:64.54,66.69'}
G[23053]={'475:55.3,45.9 475:55.5,45.7 475:55.6,47.9 475:55.9,46.7'}
G[23066]={'478:69.2,78.2'}
G[23120]={'475:27.6,52.8'}
G[23127]={'341:55.3,29.1'}
G[23128]={'321:49.2,71.2'}
G[23139]={'473:66.2,85.7'}
G[23140]={'473:66.1,86.4'}
G[23141]={'473:66,86.4'}
G[23149]={'473:63,87.8 473:65.3,90.2'}
G[23158]={'Z796'}
G[23166]={'473:71.6,87.7'}
G[23233]={'475:28.8,57.4'}
G[23253]={'475:28.9,57.9'}
G[23265]={'477:55.7,37.4'}
G[23267]={'473:74.6,86.6'}
G[23268]={'477:55.40,68.69'}
G[23270]={'481:47.24,26.30'}
G[23271]={'481:35.06,32.36'}
G[23272]={'481:44.8,76.2'}
G[23273]={'481:60.86,63.53'}
G[23280]={'475:52,54.4 475:52,54.5'}
G[23286]={'473:67.8,83.4'}
G[23291]={'473:66.8,86.1'}
G[23300]={'475:28.4,58 475:28.5,58.1'}
G[23306]={'478:64.23,66.97'}
G[23316]={'475:28.4,57.6 475:28.5,57.6'}
G[23324]={'473:74.2,88.6'}
G[23334]={'475:27.4,52.7 475:27.5,52.7'}
G[23335]={'475:28,51.4 475:28,51.5'}
G[23340]={'473:64.6,82.2 473:64.7,83.3 473:64.7,83.9 473:64.7,85.1 473:65.2,85.7'}
G[23342]={'473:63.2,83.5 473:64.7,83.1 473:64.7,84.3 473:64.7,84.9 473:65.2,85.5 473:66.7,87.8 473:67.2,82.4 473:67.2,82.7 473:67.8,83.6 473:68,84.9'}
G[23344]={'473:64.7,85.9 473:64.8,82.9 473:64.9,84.1 473:65.2,85.3 473:66.9,82.8'}
G[23345]={'473:64.7,83.2 473:64.7,83.8 473:64.7,85.7 473:64.8,82 473:65,81.4 473:65.2,85.1 473:65.7,80.9 473:66.7,82.3 473:66.9,82.6 473:67.6,84.2 473:67.9,86 473:68.1,83.3 473:68.3,87.1 473:68.3,87.8 473:68.9,89 473:69.1,83.9 473:69.4,90 473:69.7,81.8 473:69.8,79.8 473:69.8,81 473:70.1,78.9 473:70.4,88.1 473:71.3,79.1 473:71.3,90.8 473:71.7,79.3 473:72.4,80.4 473:72.4,86 473:72.6,81.4 473:72.6,82.2 473:72.7,82.8 473:74.1,83.2 473:75.1,87.6 473:75.2,83.3 473:75.4,88.8 473:75.8,90.4 473:75.9,86.4 473:75.9,86.5 473:76.1,82.8 473:76.1,84.2 473:76.3,82.2 473:76.5,82.1 473:78.5,81.6 N:13437'}
G[23346]={'473:62.2,85.4 473:64.7,82.3 473:64.7,83.2 473:64.7,84.4 473:64.7,85.6 473:65.2,85 473:66.2,88.4 N:13181'}
G[23348]={'473:64.7,83 473:64.7,83.6 473:65.4,85.4 473:65.4,85.5 473:65.5,85.4 473:65.5,85.5'}
G[23376]={'473:63.4,87.5 473:63.8,87.4 473:64.5,86.8 473:64.5,87.5 473:65.4,89.4 473:65.4,89.5 473:65.5,88.3 473:65.5,88.8'}
G[23383]={'478:61,75 478:68.4,73.8 478:75.04,86.27'}
G[23413]={'475:28.28,52.10'}
G[23415]={'478:63.50,65.81'}
G[23427]={'473:66.2,85.7'}
G[23428]={'475:28.1,58.6'}
G[23433]={'481:66.62,16.42'}
G[23434]={'473:56.4,58.6 473:56.5,58.6 473:57.1,58.2'}
G[23449]={'481:64.31,42.33'}
G[23452]={'473:62.39,29.29'}
G[23461]={'481:66.4,18 481:66.4,18.7 481:66.7,18.4 481:66.8,18.6'}
G[23462]={'481:67.92,17.03'}
G[23463]={'481:67.50,18.83'}
G[23464]={'481:68.04,18.12'}
G[23465]={'481:65.89,19.13'}
G[23466]={'481:66.02,17.33'}
G[23473]={'475:27.9,52.2'}
G[23486]={'27:55.13,37.72'}
G[23546]={'491:60.53,61.08 491:60.39,60.99 491:60.56,61.28'}
G[23547]={'491:61.15,62.64 491:60.80,62.52'}
G[23548]={'491:60.17,61.03 491:60.54,61.28'}
G[23558]={'HB 27:53.68,38.55'}
G[23566]={'141:68.36,51.03'}
G[23567]={'141:29.79,47.67 141:29.73,47.62'}
G[23568]={'141:46.62,24.61'}
G[23569]={'141:63.74,17.04'}
G[23570]={'141:41.54,72.98'}
G[23572]={'141:42.33,72.93'}
G[23574]={'781:35.51,24.73'}
G[23579]={'141:41.86,73.99'}
G[23600]={'141:46.14,57.36 141:46.10,57.43'}
G[23601]={'141:46.05,57.24'}
G[23618]={'9:48.35,53.10'}
G[23627]={'HB 27:56.12,38.05'}
G[23628]={'HB 27:56.58,36.91'}
G[23706]={'4:40.73,17.35'}
G[23709]={'27:55.92,37.03'}
G[23710]={'HB 27:56.37,37.84'}
G[23723]={'141:46.66,23.05'}
G[23728]={'491:60.12,62.43'}
G[23729]={'491:58.77,62.76'}
G[23730]={'491:62.3,57.7'}
G[23736]={'491:59.79,63.24'}
G[23749]={'491:28.87,44.24 491:28.81,44.06','Pacing on the second floor of the keep'}
G[23770]={'491:33.97,43.80'}
G[23773]={'491:31.17,40.84'}
G[23778]={'491:78.68,37.13'}
G[23780]={'491:78.60,31.22'}
G[23784]={'491:83.23,43.11'}
G[23797]={'141:53.57,56.91'}
G[23804]={'491:40.29,60.26'}
G[23831]={'491:31.7,42'}
G[23833]={'491:24.24,32.46'}
G[23835]={'141:68.26,51.81','Also circles the fountain'}
G[23843]={'141:55.40,26.36 141:55.58,26.14'}
G[23859]={'491:31.25,43.97'}
G[23870]={'491:36.4,48.4 491:37.4,51.9 491:41.2,49.3'}
G[23872]={'704[2]:47.63,60.09'}
G[23888]={'491:28.94,44.19'}
G[23891]={'491:30.27,28.65'}
G[23892]={'141:72.11,47.05'}
G[23895]={'491:28.97,41.91'}
G[23896]={'141:69.24,51.89'}
G[23904]={'HW Z762'}
G[23905]={'141:69.61,51.77'}
G[23906]={'491:44.47,57.59'}
G[23938]={'491:79.15,31.22'}
G[23948]={'481:75.26,33.43'}
G[23951]={'141:65.08,47.13'}
G[23954]={'523[3]:73.81,36.69'}
G[23961]={'523[1]:68.49,67.11'}
G[23973]={'4:52.5,41.2 462:47.25,46.48'}
G[23975]={'491:59.80,61.48'}
G[23976]={'491:29.11,41.78'}
G[23978]={'491:31.61,41.50'}
G[24018]={'491:38.79,13.07'}
G[24027]={'491:71.12,39.08'}
G[24032]={'491:49.56,11.59'}
G[24037]={'491:84.66,36.45'}
G[24038]={'491:28.86,43.97'}
G[24056]={'491:60.27,18.69'}
G[24060]={'Near491'}
G[24061]={'491:60.06,16.10'}
G[24106]={'491:55.96,55.79'}
G[24108]={'4:41.54,17.63'}
G[24111]={'523[1]:67.60,70.96 491:57.34,46.99>523'} -- 491:59.56,48.87
G[24117]={'491:61.49,22.85'}
G[24122]={'491:59.18,54.57'}
G[24123]={'491:49.31,11.98'}
G[24125]={'491:53,66.1'}
G[24126]={'491:78.54,28.98'}
G[24127]={'491:48.38,11.03'}
G[24129]={'491:48.04,10.74'}
G[24130]={'Near491'}
G[24131]={'491:62.66,16.80'}
G[24135]={'491:48.16,10.67'}
G[24137]={'523:67.7,66.4 523:67.9,66.3 523:67.9,66.5 523:67.9,67.3 523:68.1,68.2 523:68.2,69.6 523:68.3,68.3 523:68.4,68.7 523:68.4,68.9 523:68.4,69.6 523:68.5,67.4 523:68.5,67.7 523:68.5,68.2 523:68.5,68.9 523:68.6,68.8 523:68.6,69.5'}
G[24139]={'491:62.59,16.82'}
G[24145]={'491:56.64,52.38'}
G[24150]={'491:56.90,53.77'}
G[24151]={'491:55.70,57.37'}
G[24152]={'491:26.43,24.50'}
G[24155]={'491:52.01,67.38'}
G[24157]={'491:53.07,66.93'}
G[24176]={'491:60.17,15.62'}
G[24186]={'491:31.16,24.51'}
G[24189]={'491:59.34,55.42'}
G[24191]={'491:59.75,62.43'}
G[24209]={'491:31.28,24.35'}
G[24218]={'491:25.96,24.43'}
G[24227]={'491:30.05,28.64 491:30.13,28.79 491:30.27,28.77'} -- pacing back and forth
G[24234]={'491:48.43,10.44'}
G[24251]={'491:53.58,66.36'}
G[24252]={'491:53.68,65.21'}
G[24256]={'491:48.93,11.98'}
G[24261]={'491:29.68,5.67'}
G[24273]={'491:30.05,28.59'}
G[24282]={'491:61.83,17.19'}
G[24283]={'491:30.77,41.61'}
G[24328]={'491:62.27,17.22'}
G[24359]={'491:26.14,24.58','Circling the fire'}
G[24362]={'491:49.22,12.25'}
G[24369]={'481:75.13,36.68'}
G[24370]={'481:75.49,37.22'}
G[24376]={'491:62.58,16.53'}
G[24390]={'491:48.09,10.48'}
G[24393]={'481:61.75,15.56'}
G[24399]={'491:30.81,28.56'}
G[24458]={'491:65.87,36.78'}
G[24468]={'HB 27:53.54,38.57'}
G[24473]={'491:30.41,26.18'}
G[24494]={'491:30.64,42.78'}
G[24495]={'HB 4:40.32,17.88'}
G[24497]={'HB 4:42.61,17.86'}
G[24498]={'HB 4:40.6,18.2'}
G[24499]={'HB 4:4.19,17.2'}
G[24510]={'HB 4:42.68,17.73'}
G[24519]={'27:53.30,51.47 30:42.62,64.39 464:49.16,51.34'}
G[24525]={'491:35.56,80.62'}
G[24537]={'491:35.60,80.24'}
G[24539]={'491:35.10,80.94'}
G[24541]={'491:36.33,80.48'}
G[24544]={'491:19.78,22.21'}
G[24548]={'491:67.35,60.32'}
G[24634]={'491:64.43,46.95'}
G[24643]={'491:23.08,62.66'}
G[24657]={'HB 4:41.23,18.53'}
G[24702]={'486:77.07,37.82'}
G[24703]={'486:75.90,37.24'}
G[24706]={'486:75.9,37.2'}
G[24709]={'486:75.9,37.3'}
G[24710]={'HB 27:55.13,38.08'}
G[24711]={'HB 4:41.58,18.46'}
G[24717]={'491:74.95,65.41'}
G[24727]={'481:31.33,27.87'}
G[24729]={'301:81.83,28.00'} --301:81.40,27.78 301:81.64,28.23 301:81.99,28.74
G[24730]={'486:75.6,35.8'}
G[24733]={'486:76.8,37.9'}
G[24739]={'43:17.9,49.4 43:17.9,49.5'}
G[24741]={'491:35.34,79.47 491:35.49,79.39','Upstairs'}
G[24750]={'491:75.27,64.97'}
G[24755]={'491:25.02,56.96'}
G[24784]={'491:37.75,79.58'}
G[24795]={'486:45.35,34.50'}
G[24807]={'491:75.05,65.51'}
G[24810]={'491:24.60,58.86'}
G[24811]={'491:78.81,48.87'}
G[24813]={'798[2]:42.61,87.19 N:55007'}
G[24822]={'798:0,0'}
G[24848]={'798:0,0'}
G[24851]={'463:74.76,67.15'}
G[24866]={'477:55.9,73.7'}
G[24881]={'477:52.8,36'}
G[24885]={'478:55.81,53.74'}
G[24886]={'478:49.9,46.7'}
G[24910]={'491:35.9,67.3 491:37.2,74.8 491:37.8,75 491:38,77.1 491:38.3,78.3 491:38.4,69.2 491:38.4,69.8 491:38.5,70.4 491:38.5,78.9 491:38.6,71 491:38.7,79.5 491:38.9,72.1 491:39.7,74.4 491:39.7,74.5 491:40.2,81.1 491:40.8,81.6 491:41.1,76.2 491:42,82.4 491:43.1,77.7'}	-- on a boat that sails around a bunch
G[24932]={'481:49.10,42.50'}
G[24937]={'465:58.17,17.59'}
G[24965]={'499:47.2,30.7'}
G[24967]={'499:47.4,30.6'}
G[24975]={'499:51.4,32.6 499:51.5,32.6'}
G[25032]={'499:47.3,30.7'}
G[25034]={'499:47.3,35.1'}
G[25046]={'499:50.6,40.8'}
G[25057]={'499:47.6,35.2'}
G[25061]={'499:47.6,35.2'}
G[25069]={'499:49.4,40.3 499:49.5,40.4'}
G[25088]={'499:53.8,34.2'}
G[25108]={'499:50.5,39.1'}
G[25112]={'499:48.4,36.7 499:48.4,37.7 499:48.7,36.8 499:48.7,37.5'}
G[25133]={'499:47.5,35.3 499:47.6,35.5'}
G[25140]={'481:62.74,35.97'}
G[25163]={'499:51.2,33.3'}
G[25169]={'499:50.2,28.2'}
G[25197]={'486:43.50,13.96'}
G[25199]={'486:42.84,13.65'}
G[25205]={'486:42.00,12.78'}
G[25206]={'486:43.03,13.81'}
G[25208]={'486:37.75,23.02'}
G[25211]={'486:42.03,13.15'}
G[25233]={'491:32.28,46.79'}
G[25235]={'486:57.32,66.64 486:57.40,66.52 486:57.17,66.24'}
G[25237]={'486:41.35,53.59'}
G[25245]={'486:58.29,68.04'}
G[25247]={'486:41.74,54.72'}
G[25249]={'486:58.41,67.79'}
G[25250]={'486:56.67,72.64'}
G[25251]={'486:58.73,68.35'}
G[25256]={'486:41.37,53.70'}
G[25257]={'488:40.7,18 N:18229'}
G[25262]={'486:45.26,33.36'}
G[25272]={'486:41.22,53.35'}
G[25273]={'486:41.62,53.98 486:43.01,55.64'}	-- different dudes standing about
G[25279]={'486:43.19,54.97'}
G[25280]={'486:42.13,56.17'}
G[25285]={'486:56.60,72.47'}
G[25288]={'486:40.36,51.40','On roof'}
G[25289]={'486:42.34,55.99','On roof'}
G[25291]={'486:44.98,33.39'}
G[25292]={'486:54.30,36.10'}
G[25298]={'486:57.83,69.20'}
G[25299]={'486:57.79,69.19'}
G[25301]={'486:56.71,72.62'}
G[25302]={'486:58.53,68.09'}
G[25307]={'486:57.85,67.59'}
G[25314]={'486:32.94,34.41'}
G[25324]={'HM 43:15.8,21'}
G[25326]={'486:49.61,10.59'}
G[25327]={'486:43.33,55.36'}
G[25328]={'486:40.07,52.06'}
G[25329]={'486:32.25,54.08'}
G[25335]={'486:48.32,19.76'}
G[25336]={'486:48.45,19.74'}
G[25339]={'486:50.28,9.73'}
G[25356]={'486:46.37,37.30'}
G[25374]={'486:49.55,9.98'}
G[25376]={'486:46.57,9.35'}
G[25379]={'486:43.72,54.43'}
G[25380]={'486:52.2,52.8'}
G[25381]={'486:52.06,52.49'}
G[25385]={'486:56.05,55.42'}
G[25394]={'486:43.20,55.05'}
G[25395]={'486:56.68,71.45','In bottom of keep'}
G[25425]={'486:56.2,9.1'}
G[25435]={'486:47.13,75.48'}
G[25437]={'486:38.08,52.49'}
G[25438]={'486:37.92,52.59'}
G[25440]={'486:53.10,52.34','Riding in general area'}
G[25450]={'486:43.61,80.53'}
G[25462]={'502:51.3,35.1'}
G[25475]={'486:32.08,54.25'}
G[25476]={'486:32.34,54.27'}
G[25477]={'486:57.58,18.70 486:58.18,18.34'}
G[25480]={'486:46.34,32.84'}
G[25503]={'486:31.7,54.4'}
G[25504]={'486:31.88,52.32','Upstairs'}
G[25516]={'486:87.6,20.1'}
G[25580]={'478:38.7,12.8'}
G[25589]={'486:54.5,11.6 486:55.5,11.4 486:55.5,12 486:55.5,12.6'}
G[25590]={'486:56.98,18.70'}
G[25602]={'486:77.31,36.88'}
G[25604]={'486:74.67,23.66'}
G[25605]={'486:57.50,69.08'}
G[25607]={'486:37.91,52.33'}
G[25636]={'486:44.10,77.89'}
G[25658]={'486:69.8,12.7'}
G[25697]={'728[1]:18.6,50.6 467:48.94,35.80>728'}
G[25702]={'486:57.5,18.7'}
G[25705]={'486:73.42,18.79'}
G[25714]={'486:69.89,14.74'}
G[25729]={'486:34.59,46.43'}
G[25736]={'486:48.96,10.27'}
G[25737]={'486:58.84,68.72'}
G[25747]={'486:57.44,18.74'}
G[25780]={'486:57.06,20.11'}
G[25785]={'486:46.37,32.40'}
G[25807]={'486:61.67,35.78'}
G[25809]={'486:57.05,44.32'}
G[25810]={'486:57.32,44.08'}
G[25811]={'486:56.80,44.04'}
G[25812]={'486:57.19,44.20 486:57.16,43.59 486:56.90,44.13','The bear that circles'}
G[25816]={'486:56.36,69.58'}
G[25825]={'486:55.00,68.93'}
G[25826]={'486:58.55,67.31'}
G[25838]={'486:57.79,55.10'}
G[25849]={'486:77.49,36.97'}
G[25862]={'486:59.43,30.44'}
G[25883]={'HM 43:86.94,41.86'}
G[25884]={'HM 43:51.35,66.15'}
G[25887]={'HM 16:44.30,46.03'}
G[25888]={'HM 464:44.48,52.50'}
G[25889]={'HM 475:41.57,65.90'}
G[25890]={'HM 19:55.53,14.88'}
G[25891]={'HM 476:55.82,67.88'}
G[25892]={'HM 29:68.34,60.63'}
G[25893]={'HM 42:48.73,22.65'}
G[25894]={'HM 101:66.12,17.10'}
G[25895]={'HM 27:53.80,45.24'}
G[25896]={'HM 34:73.69,54.62'}
G[25897]={'HM 141:61.82,40.46'}
G[25898]={'HM 30:43.47,62.63'}
G[25899]={'HM 121:46.82,43.70'}
G[25900]={'HM 465:62.17,58.29'}
G[25902]={'HM 35:32.55,40.95'}
G[25903]={'HM 477:49.61,69.46'}
G[25904]={'HM 36:24.90,53.39'}
G[25905]={'HM 473:39.63,54.64'}
G[25906]={'HM 41:54.88,52.77'}
G[25907]={'HM 478:54.06,55.52'}
G[25908]={'HM 26:14.34,50.08'}
G[25909]={'HM 22:43.47,82.33'}
G[25910]={'HM 39:44.76,62.06'}
G[25911]={'HM 40:13.46,47.07'}
G[25912]={'HM 467:68.80,51.95'}
G[25913]={'HM 479:31.21,62.66'}
G[25914]={'HM 261:60.30,33.51'}
G[25915]={'HM 673:51.96,67.65'}
G[25916]={'HM 161:52.64,30.26'}
G[25917]={'HM 281:61.24,47.25'}
G[25918]={'HM 479:32.11,68.32'}
G[25919]={'HM 261:50.85,41.31'}
G[25920]={'HM 673:50.40,70.38'}
G[25921]={'HM 161:49.82,27.87'}
G[25922]={'HM 281:58.15,47.51'}
G[25923]={'HM 16:69.36,42.57'}
G[25925]={'HM 17:23.09,37.44'}
G[25926]={'HM 475:49.91,58.66'}
G[25927]={'HM 29:51.11,29.21'}
G[25928]={'HM 101:26.15,76.90'}
G[25929]={'HM 4:52.18,47.32'}
G[25930]={'HM 141:33.43,30.91'}
G[25931]={'HM 462:46.40,50.60'}
G[25932]={'HM 121:72.38,47.79'}
G[25933]={'HM 463:46.90,26.34'}
G[25934]={'HM 465:57.12,42.05'}
G[25935]={'HM 24:54.66,50.09'}
G[25936]={'HM 9:51.82,59.25'}
G[25937]={'HM 477:50.91,34.14'}
G[25938]={'HM 473:33.40,30.54'}
G[25939]={'HM 21:49.63,38.22'}
G[25940]={'HM 81:52.92,62.46'}
G[25941]={'HM 38:76.33,13.77'}
G[25942]={'HM 478:52.01,42.91'}
G[25943]={'HM 11:49.96,54.63'}
G[25944]={'HM 26:76.64,74.96'}
G[25946]={'HM 20:57.22,51.76'}
G[25947]={'HM 467:35.44,51.61'}
G[25962]={'HM 16:44.23,45.20 17:19.46,55.80 19:55.54,15.16 22:43.17,82.55 26:14.04,50.08 27:53.76,45.58 29:68.03,60.12 30:43.69,62.23 34:73.64,53.81 35:32.07,41.51 36:25.14,54.20 37:51.97,63.08 38:69.87,16.25 39:44.65,61.21 40:13.59,46.70 41:54.54,52.68 42:48.65,22.88 43:86.48,41.85 81:49.41,50.97 101:66.35,17.00 121:46.96,43.78 141:61.60,41.04 161:52.45,30.54 201:59.55,63.10 261:59.95,33.59 281:61.14,47.65 464:44.45,51.78 465:62.06,57.92 467:69.04,51.92 473:39.59,54.99 475:41.50,65.30 476:56.16,67.08 477:49.92,69.04 478:54.53,55.38 479:31.53,63.02 486:55.11,19.71 488:75.59,43.38 490:33.93,60.18 491:57.97,16.16 493:47.48,66.36 495:41.62,86.83 496:40.51,61.55 510:78.32,75.46 607:48.42,72.45 673:52.10,67.26 700:47.35,28.53 720:53.75,32.05'}
G[25975]={'HM 301:50.05,72.28 341:65.40,25.04 381:63.18,47.50 471:40.88,25.55'}
G[25978]={'486:41.70,54.59'}
G[25982]={'486:77.25,38.47'}
G[25983]={'486:77.6,37'}
G[25984]={'486:64.03,35.76'}
G[25994]={'HM 4:52.41,47.33 9:51.69,59.54 11:49.86,54.97 16:69.93,42.21 17:23.39,37.28 19:45.69,12.99 20:57.44,51.57 21:49.95,38.18 22:29.45,56.90 24:54.81,49.79 26:76.80,75.33 29:50.61,29.33 37:40.53,51.49 38:76.61,13.34 43:51.68,66.21 81:52.76,62.52 101:26.32,76.64 121:72.21,47.89 141:33.65,30.80 161:49.89,27.73 181:60.72,53.31 201:56.63,66.36 261:51.06,41.09 281:58.20,47.71 462:46.60,50.72 463:46.82,26.67 465:56.92,42.15 467:35.42,51.32 473:33.29,30.25 475:49.55,59.04 477:50.76,33.98 478:52.17,42.77 479:32.53,68.44 486:51.15,11.26 488:38.12,48.32 490:19.47,61.28 491:48.62,12.90 493:47.17,61.26 495:40.37,85.23 496:43.56,71.75 510:79.67,53.45 607:40.75,67.60 673:50.19,70.74 700:52.97,46.10 720:53.23,34.62'}
G[26083]={'486:58.21,62.81'}
G[26084]={'486:58.19,62.99'}
G[26085]={'486:58.28,62.77'}
G[26104]={'486:77,37.6'}
G[26110]={'486:33.49,34.38'}
G[26113]={'321[1]:46.60,37.27 362:20.99,26.46 382:68.88,8.45 480:69.50,42.43'}
G[26117]={'486:33.32,34.53'}
G[26125]={'36:59.02,55.01'}
G[26155]={'486:56.7,69.5'}
G[26156]={'488:12.8,51.6'}
G[26158]={'486:78.3,38'}
G[26169]={'486:63.80,46.13'}
G[26170]={'486:84.80,41.68'}
G[26180]={'488:14.2,49.9'}
G[26181]={'488:13.3,48 488:13.3,49.7 488:13.4,49.1 488:13.6,47.9 488:13.8,49.6 488:13.9,48.5'}
G[26186]={'486:82.17,46.40'}
G[26187]={'486:82,46.4'}
G[26194]={'488:48.00,74.87'}
G[26206]={'Near486'}
G[26212]={'490:59.42,25.99'}
G[26213]={'486:63.95,45.71'}
G[26218]={'486:67.21,54.85'}
G[26221]={'HM 301:49.32,72.27 341:65.09,27.72 381:62.11,49.14 471:43.29,26.22 481:60.67,30.63'} -- This NPC is the same for both factions!!!  So Horde is 526221.
G[26226]={'490:59.80,27.57'}
G[26228]={'488:48.26,74.35'}
G[26245]={'488:47.70,76.63'}
G[26260]={'490:65.77,17.80'}
G[26335]={'490:63.68,23.16'}
G[26344]={'488:36.79,65.05'}
G[26361]={'490:59.76,27.44'}
G[26371]={'490:59.08,26.48 490:59.04,26.42 490:59.12,26.17'}
G[26377]={'490:59.09,26.61'}
G[26379]={'488:36.3,45.6 488:38.1,46.3'}
G[26401]={'HM 16:44.22,45.99 17:18.97,56.33 19:55.55,14.76 22:43.44,82.24 26:15.23,50.17 27:53.80,45.14 29:68.32,60.77 30:43.49,62.51 34:73.77,54.50 35:32.58,41.10 36:25.68,53.37 37:52.12,63.57 38:70.13,15.72 39:44.80,62.18 40:13.50,46.98 41:54.83,52.77 42:48.69,22.69 43:86.89,41.84 81:49.35,51.33 101:66.19,17.10 121:46.78,43.67 141:61.87,40.50 161:52.67,30.22 201:59.77,63.25 261:60.38,33.51 281:61.49,47.51 464:44.41,52.47 465:62.45,58.44 467:68.73,51.94 473:39.64,54.56 475:41.53,65.87 476:55.82,67.75 477:49.57,69.41 478:54.01,55.57 479:31.16,62.64 486:55.14,19.91 488:75.24,43.77 490:33.94,60.52 491:57.84,16.17 493:48.37,65.53 495:41.42,86.74 496:40.37,61.39 510:78.07,74.90 607:48.34,72.29 673:52.03,67.71 700:47.32,28.95 720:53.60,31.92 811:79.67,37.44'} -- the one in zone 26 is behind a tree
G[26415]={'488:36.7,46.6'}
G[26420]={'490:79.76,33.61'}
G[26423]={'490:16.43,47.77'}
G[26424]={'490:16.19,47.61'}
G[26440]={'488:48.1,74.9'}
G[26441]={'488:48,74.8'}
G[26443]={'488:57.91,54.17'}
G[26459]={'488:29.04,55.42'}
G[26471]={'488:38,46.3'}
G[26473]={'488:58.98,17.81'}
G[26484]={'490:69.09,40.10'}
G[26500]={'490:13.24,60.87'}
G[26501]={'488:24.20,60.08'}
G[26504]={'488:37.1,48.6'}
G[26505]={'488:36.1,48.8'}
G[26511]={'488:47.71,80.03'}
G[26514]={'490:67.50,15.28'}
G[26519]={'490:15.7,46.8'}
G[26520]={'HM 4:52.15,47.25 9:51.77,59.21 11:49.96,54.54 16:69.41,42.47 17:23.19,37.42 19:46.30,13.73 20:57.29,51.75 21:49.59,38.31 22:29.23,57.34 24:54.70,50.15 26:76.66,75.06 29:51.21,29.26 37:40.51,50.96 38:76.30,13.59 43:51.35,66.22 81:52.95,62.41 101:26.13,77.01 121:72.41,47.76 141:33.49,30.92 161:49.80,27.93 181:60.80,53.56 201:56.25,66.33 261:50.82,41.41 281:58.16,47.43 462:46.40,50.51 463:46.89,26.48 465:57.16,42.00 467:35.47,51.69 473:33.61,30.72 475:49.92,58.74 477:50.97,34.13 478:51.97,42.96 479:32.16,68.33 486:51.16,11.47 488:38.31,48.45 490:19.26,61.17 491:48.64,13.08 493:47.27,61.66 495:40.27,85.41 496:43.42,71.81 510:80.08,53.21 607:40.85,67.73 673:50.34,70.33 700:52.96,45.93 720:53.10,34.54 811:77.88,34.03'}
G[26527]={'521:86.4,61.6 521:86.5,61.4 521:86.5,61.5 N:10667'}
G[26533]={'521[2]:33.55,45.78'}
G[26543]={'490:17.41,36.36 N:26500'}
G[26560]={'499:48.36,25.08'}
G[26564]={'488:36.6,47.1'}
G[26574]={'488:37.2,45.8'}
G[26581]={'488:35.9,46.9 488:36.1,46 488:36.2,47.6 488:36.5,46.4 488:36.7,47.6 488:37.1,46.5'}
G[26584]={'490:65.2,47.8'}
G[26588]={'490:49.20,34.10'}
G[26593]={'488:35.21,30.04','Inside cave Maw of Neltharion'}
G[26595]={'488:49.14,75.66'}
G[26602]={'486:56.57,20.06'}
G[26604]={'490:16.67,48.29'}
G[26618]={'488:35.8,48.3'}
G[26632]={'534[1]:60.26,13.17'}
G[26647]={'488:54.69,23.88 488:54.50,23.62 488:54.98,23.85'}
G[26649]={'488:37.3,46.8'}
G[26652]={'488:35.8,45.8 488:35.8,46.9 488:36.4,45.3 488:36.5,45.3 488:36.6,45.5'}
G[26653]={'488:26.2,50.7'}
G[26659]={'488:59.40,18.18'}
G[26660]={'488:55.02,23.43'}
G[26661]={'488:54.70,23.26'}
G[26666]={'490:65.1,47.7'}
G[26673]={'488:29.00,55.45'}
G[26701]={'490:45.00,28.36 N:26500'}
G[26723]={'520[1]:36.26,69.04 N:26206'}
G[26733]={'488:22.6,41.7'}
G[26787]={'490:71.74,26.20 N:26500'}
G[26796]={'520[1]:18.94,52.79'}
G[26798]={'520[1]:19.58,53.31'}
G[26814]={'490:69.48,17.50'}
G[26821]={'490:26.41,35.71'}
G[26837]={'488:28.73,57.10'}
G[26851]={'488:60.32,51.54'}
G[26854]={'488:36.5,47.8'}
G[26859]={'488:47.2,33'}
G[26860]={'490:20.7,64.2'}
G[26861]={'524[1]:0.00,0.00'}
G[26868]={'490:22.6,66.1'}
G[26873]={'488:40.26,66.85'}
G[26875]={'490:31.84,60.17'}
G[26876]={'490:59.89,26.68'}
G[26877]={'488:39.52,25.91'}
G[26878]={'488:77.01,49.79'}
G[26879]={'486:58.96,68.29'}
G[26880]={'490:31.31,59.11'}
G[26881]={'488:29.18,55.33'}
G[26883]={'490:77.09,48.65'}
G[26884]={'490:73.76,34.02'}
G[26885]={'490:76.97,48.44'}
G[26886]={'490:73.91,34.13'}
G[26896]={'488:48.46,24.13'}
G[26905]={'491:58.2,62.1'}
G[26914]={'491:58.6,62.8'}
G[26917]={'488:59.84,54.66'}
G[26924]={'490:69.42,19.48'} -- need to have "On the Other Side" buff to see him
G[26932]={'490:55.13,23.38'}
G[26935]={'490:57.52,41.26'}
G[26944]={'490:65,47.8'}
G[26949]={'488:59.52,53.30'}
G[26953]={'491:78.61,29.49'}
G[26964]={'491:79.4,30.7'}
G[26969]={'486:41.6,53.4 486:41.6,53.5'}
G[26972]={'486:41.97,54.11'}
G[26973]={'488:29.18,55.64'}
G[26978]={'488:64.42,26.94 488:64.47,26.34'}
G[26979]={'488:46.7,33.4 488:46.7,33.5'}
G[26983]={'488:60.02,55.20'}
G[26989]={'486:57.92,71.54'}
G[27001]={'486:57.5,72.3'}
G[27028]={'488:76,62'}
G[27037]={'490:22,65.1'}
G[27046]={'486:33.13,34.44'}
G[27060]={'488:28.9,56.1'}
G[27102]={'490:20.9,64.1 490:23.3,64.9'}
G[27120]={'490:26.4,65.7 490:26.5,65.8'}
G[27136]={'488:78.49,48.34 488:78.64,48.09'}
G[27155]={'488:78.64,48.18'}
G[27156]={'488:77.80,50.33'}
G[27157]={'488:89.67,46.37'}
G[27158]={'488:78.91,45.33'}
G[27159]={'488:77.84,50.29'}
G[27172]={'488:77.7,62.7'}
G[27215]={'HB 27:54.67,38.10'}
G[27216]={'HB 4:4.53,17.6'}
G[27221]={'490:65.2,47.4 490:65.2,47.5'}
G[27227]={'490:65.1,47.3'}
G[27243]={'488:76.8,63.2'}
G[27248]={'488:77,62.9'}
G[27255]={'488:64.10,71.99 488:62.98,72.15 488:62.52,73.64 488:62.59,74.92 488:63.63,75.99 488:64.77,72.52 488:65.01,73.52 488:64.92,75.39 488:64.68,76.36'}
G[27262]={'490:22.5,62.9'}
G[27266]={'490:22.2,64.7'}
G[27267]={'488:76,63.2'}
G[27277]={'490:32.10,59.97'}
G[27295]={'490:31.16,59.47'}
G[27314]={'488:79.14,47.17'}
G[27316]={'488:76.75,47.52 488:76.79,47.35'}
G[27317]={'488:77.10,50.11'}
G[27318]={'488:79.07,53.20'}
G[27319]={'488:85.86,51.02'}
G[27320]={'488:76.4,62.6 488:76.5,62.6 488:77.3,62.2 488:77.6,61.9'}
G[27337]={'488:76.8,63.1'}
G[27344]={'491:79.04,29.71'}
G[27347]={'488:87.17,57.48'}
G[27348]={'488:87.24,57.39'}
G[27350]={'488:73.6,73.4 488:73.6,73.5'}
G[27371]={'490:39.54,43.56'}
G[27388]={'490:21,64.1'}
G[27391]={'490:32.42,59.95'}
G[27412]={'488:81.52,42.20'}
G[27416]={'490:39.64,43.37'}
G[27422]={'490:34.4,32.7 490:34.5,32.6'}
G[27423]={'490:34.5,32.6'}
G[27451]={'490:34.4,33 490:34.5,33'}
G[27464]={'490:33.9,32.8'}
G[27468]={'490:39.36,43.87'}
G[27469]={'490:34.77,55.61'}
G[27478]={'HB 341:18.82,53.09'}
G[27483]={'534[1]:65.67,23.77'}
G[27484]={'490:40.48,42.65'}
G[27486]={'490:26.47,35.77'}
G[27489]={'HB 321[1]:50.37,73.50'}
G[27495]={'490:23.02,80.16'}
G[27497]={'490:21.93,29.93'}
G[27499]={'490:26.46,31.76'}
G[27506]={'488:52.21,50.04'}
G[27520]={'490:22.18,81.23'}
G[27532]={'490:10.1,77.2'}
G[27545]={'490:25.61,33.31'}
G[27546]={'490:35.39,66.89'}
G[27562]={'490:22.12,81.25'}
G[27563]={'490:10.1,77.2'}
G[27565]={'490:11.2,76.6'}
G[27575]={'488:59.24,54.32'}
G[27581]={'490:44.04,47.95'}
G[27582]={'490:59.18,26.18'}
G[27602]={'490:21.99,80.73'}
G[27606]={'490:11.3,76.7'}
G[27646]={'490:64.80,43.41'}
G[27658]={'528:48.2,80.7 528:48.4,80.1 528:48.9,80.4 528:49,80.9 528:49.4,79 528:49.4,79.7 528:49.4,80.6 528:49.6,80.7 528:49.8,79 528:49.9,78.4 528:49.9,79.8 528:50,79.2 528:50,80.3 528:50,81.5 528:50.1,80.8 528:50.1,81.8 528:50.5,80 528:50.5,80.6 528:50.6,80.1 528:50.9,79.2 528:51.5,79.2'}
G[27708]={'490:14.8,86.4 490:14.8,86.5'}
G[27719]={'490:22.4,63.9'}
G[27720]={'490:22.3,64.1'}
G[27759]={'490:14.8,86.6 490:14.9,86.4'}
G[27763]={'488:43,50.9'}
G[27765]={'488:60.07,54.20'}
G[27783]={'490:29.91,59.78'}
G[27784]={'488:76.81,47.52 488:76.67,47.37 488:76.80,47.07 488:76.99,47.27 488:76.85,47.33'}
G[27785]={'488:59.61,54.46'}
G[27801]={'493:64.56,48.60'}
G[27803]={'488:60.00,55.08'}
G[27804]={'488:58.1,55.4 488:58.3,55.8 488:58.6,56.3 488:58.7,56.5'}
G[27828]={'488:84.17,54.68'}
G[27844]={'488:64.74,27.93'}
G[27856]={'488:60.00,54.51 N:10667'}
G[27857]={'488:81.17,50.65'}
G[27872]={'488:37.80,23.41'}
G[27915]={'521:47.7,39.3 521:47.7,39.9 521:47.8,39.3 521:47.9,40.5 521:47.7,39.9 N:10667'}
G[27922]={'491:67.45,60.58'}
G[27978]={'526[1]:51.08,12.64'}
G[27986]={'493:27.10,58.65 N:18180'}
G[27987]={'493:39.68,58.65'}
G[27990]={'488:59.79,54.70'}
G[28012]={'Near528'}
G[28016]={'Near534 N:26423'}
G[28027]={'493:54.58,56.36'}
G[28030]={'496:75.37,58.61'}
G[28031]={'493:26.67,59.03'}
G[28032]={'493:27.24,59.89'}
G[28033]={'493:25.36,58.47'}
G[28034]={'496:38,44'}
G[28035]={'496:40,47'}
G[28036]={'496:40,47'}
G[28037]={'493:25.27,58.44'}
G[28039]={'496:40.27,66.62'}
G[28042]={'496:48.77,78.87'}
G[28043]={'496:48.15,63.88'}
G[28044]={'496:58.07,72.43'}
G[28045]={'496:35.62,52.23'}
G[28046]={'493:26.70,59.55'}
G[28056]={'496:40.41,48.20'}
G[28059]={'496:39.41,66.96'}
G[28062]={'496:40.53,65.61'}
G[28070]={'Near526'}
G[28082]={'493:55.00,69.12'}
G[28092]={'201:47.38,9.22'}
G[28095]={'493:50.53,76.60'}
G[28097]={'493:50.54,77.25'}
G[28099]={'496:40.36,48.21'}
G[28106]={'493:23.4,83.3 493:23.5,83.2'}
G[28107]={'493:33.4,74.8 493:33.5,74.8'}
G[28114]={'493:42.15,38.64'}
G[28120]={'Near493'}
G[28122]={'Near493'} -- about 493:74.50,51.16 when quest 12578 concludes
G[28125]={'496:58.68,72.49'}
G[28126]={'161:50.78,27.55'}
G[28138]={'493:55.49,69.68'}
G[28160]={'504[1]:68.58,42.07'}
G[28179]={'492:87.4,75.9 492:87.5,75.8'}
G[28191]={'493:25.58,66.53'}
G[28195]={'486:78.53,51.53'}
G[28196]={'488:48.51,74.39'}
G[28197]={'491:24.66,57.78'}
G[28204]={'496:41.33,65.13'}
G[28205]={'496:35.03,52.11'}
G[28214]={'Near493'}
G[28216]={'Near493'}
G[28217]={'493:55.70,64.98'}
G[28228]={'488:83.98,26.10'}
G[28244]={'496:40.8,66.7 N:3144'}
G[28266]={'493:25.4,58.4 493:25.4,58.5 493:25.5,58.4 493:25.5,58.5'}
G[28283]={'496:58.06,72.04'}
G[28284]={'496:58.25,72.05'}
G[28309]={'496:40.18,68.93'}
G[28314]={'491:71.46,39.21'}
G[28328]={'493:27.07,59.89'}
G[28357]={'502:47.6,28.9 502:47.7,29.5 502:48.2,28.4 502:48.9,27.4 502:48.9,27.5 502:49.5,28.1'}
G[28374]={'493:42.12,28.90'}
G[28375]={'486:37.84,23.19'}
G[28376]={'493:42.34,28.70'}
G[28377]={'502:52.28,33.97'}
G[28382]={'486:67.27,54.85'}
G[28401]={'496:63.71,70.40'}
G[28444]={'502:48.85,29.70'}
G[28464]={'493:65.08,60.31'}
G[28472]={'502:47.48,26.55'}
G[28479]={'496:59.50,58.05'}
G[28480]={'496:59.39,56.42'}
G[28484]={'496:59.16,56.20'}
G[28497]={'493:26.87,58.94'}
G[28503]={'496:27.08,46.15','In Voltarus above Reliquary of Pain'}
G[28510]={'502:50.9,35.5 502:51,35.3 502:51.3,34 502:51.6,34.3 502:51.6,34.8'}
G[28518]={'496:14.06,73.80'}
G[28519]={'496:21,70.2'}
G[28527]={'496:59.98,57.92'}
G[28532]={'496:14.28,74.04'}
G[28561]={'496:53.39,39.01'}
G[28568]={'493:50.48,62.13'}
G[28574]={'493:50.13,61.36'}
G[28589]={'496:19.87,75.45'}
G[28615]={'496:14.01,73.59'}
G[28618]={'496:32.18,74.39'}
G[28621]={'23:51.35,21.31'}
G[28623]={'496:41.55,64.43'}
G[28624]={'496:60.03,56.71'}
G[28647]={'502:52.4,37.8 502:52.6,37.6 502:53.1,36.4 502:53.1,36.9 502:53.5,36.5 502:53.6,36.4'}
G[28653]={'502:51.8,35.6 502:52.3,34.8 502:52.4,34.3 502:52.5,34.5 502:53.1,33.6 502:53.3,33.4'}
G[28658]={'502:54,35'}
G[28667]={'493:72.46,57.52'}
G[28668]={'493:71.97,57.01 N:28216'}
G[28674]={'504[1]:72.19,45.77'}
G[28699]={'504[1]:36.17,33.55'}
G[28701]={'504[1]:40.67,35.34'}
G[28703]={'504[1]:42.64,32.05'}
G[28705]={'504[1]:40.61,64.85'}
G[28706]={'504[1]:36.58,37.28'}
G[28718]={'504[1]:36.4,28.4'}
G[28742]={'504[1]:53.03,64.95'}
G[28746]={'493:49.95,61.53'}
G[28771]={'493:42.07,28.66'}
G[28787]={'493:35.56,47.41'}
G[28907]={'502:53.48,36.56 N:28377'}
G[28910]={'502:54.68,57.44'}
G[28911]={'502:54.2,57.4'}
G[28912]={'502:62.9,68 502:63.2,68.6 N:26581'}
G[28913]={'502:56.2,80.1 N:26170'}
G[28914]={'502:56.2,80'}
G[28919]={'502:55.8,52.3 502:55.9,52.9'}
G[28923]={'525[2]:19.16,58.53'}
G[29006]={'493:53.3,56.6'}
G[29043]={'493:55.71,69.47'}
G[29047]={'502:54.4,34.2 502:54.4,34.5 502:54.5,34.5 502:54.7,33.4 502:54.8,34.1'}
G[29049]={'504[1]:49.02,37.38'}
G[29053]={'502:52.8,81.3 502:52.9,82.5 502:53,81.7'}
G[29077]={'502:65.67,83.79'}
G[29110]={'502:53.57,36.85 N:25462'}
G[29120]={'533[3]:0.00,0.00'}
G[29137]={'496:32.03,74.42'}
G[29142]={'301:61.30,64.67'}
G[29146]={'493:55.53,68.70'}
G[29149]={'493:54.2,53.9'}
G[29155]={'486:41.58,53.60'}
G[29156]={'504[1]:56.30,46.68'}
G[29157]={'493:26.78,60.08'}
G[29158]={'486:58.58,68.30'}
G[29159]={'491:79.44,29.42'}
G[29160]={'490:20.7,64.3'}
G[29161]={'490:32.01,59.79'}
G[29162]={'488:76.8,63.2'}
G[29169]={'496:40.63,66.89'}
G[29173]={'502:34.4,31 502:34.5,31 502:34.6,31.5 502:38.9,38.2 502:39.1,39.1 502:39.5,38 N:28444'}
G[29211]={'496:36.69,72.48'}
G[29306]={'530[1]:46.95,28.90'}
G[29309]={'522[1]:69.39,27.53'}
G[29310]={'522[1]:29.12,50.34'}
G[29343]={'492:42.9,25'}
G[29344]={'492:19.6,48.1'}
G[29375]={'495:70,59'}
G[29380]={'495:25,46'}
G[29396]={'492:19.7,48.3'}
G[29405]={'492:19.7,47.8'}
G[29428]={'495:40.93,85.31'}
G[29430]={'495:41.67,80.01'}
G[29431]={'495:41.02,86.43'}
G[29432]={'495:50.01,81.77'}	-- 495:50.48,81.65
G[29434]={'495:41.51,74.89 495:42.31,73.97 495:43.48,75.24','In cave'}
G[29445]={'495:33.42,57.96'}
G[29455]={'496:17.64,57.54'}
G[29456]={'492:19.9,47.6'}
G[29473]={'495:41.14,86.14'}
G[29480]={'23:83.88,50.43'}
G[29481]={'495:42.81,68.90'}
G[29527]={'504[1]:52.31,55.61','Upstairs in Curiosities & Moore'}
G[29532]={'504[2]:35.46,57.55'}
G[29535]={'504[2]:63.47,11.63'}
G[29560]={'492:9.5,46.4 492:9.5,47.2 N:29344'}
G[29579]={'Near495 N:28070'}
G[29592]={'495:53.14,65.73'}
G[29593]={'495:30.26,74.76'}
G[29611]={'301:85.78,31.73'}
G[29631]={'504[1]:70,39'}
G[29647]={'496:19.73,56.39'}
G[29650]={'495:29.61,74.07'}
G[29651]={'495:37.31,49.66'}
G[29687]={'496:32.15,75.74'}
G[29688]={'496:25.3,63.9'}
G[29689]={'496:25.28,63.96'}
G[29690]={'496:32.18,75.63'}
G[29721]={'495:40.74,84.55'}
G[29727]={'495:29.18,74.90'}
G[29732]={'495:29.83,75.72'}
G[29733]={'496:32.02,75.61'}
G[29743]={'495:29.40,73.77'}
G[29744]={'495:28.83,74.07'}
G[29750]={'495:29.50,74.33'}
G[29751]={'495:25.24,68.47','In back of cave'}
G[29795]={'492:59.9,34.9 492:60,33.6 492:60.1,33.2 492:60.2,36.1 492:60.3,32.4 492:60.4,36.6 492:60.6,31.8 492:60.7,37.2 492:61.2,38.4 492:61.3,31.1 492:61.4,38.8 492:61.6,31 492:61.6,39.3 492:62.1,40.3 492:62.4,30.4 492:62.4,40.9 492:62.5,30.4 492:62.5,30.5 492:62.6,41.4 492:62.7,41.5 492:63.4,43.2 492:63.5,29.5 492:63.5,43.4 492:63.8,44.4 492:64.1,29 492:64.1,45.2 492:64.3,45.7 492:64.5,28.7 492:64.5,46.2 492:64.7,46.8 492:65,28.3 492:65,47.7 492:65.4,48.7 492:65.5,48.9 492:65.6,27.7 492:65.8,49.5 492:66.3,27 492:66.4,50.8 492:66.7,26.6 492:66.7,51.4 492:67.2,52.3 492:67.4,26.3 492:67.4,52.5 492:67.5,52.4 492:67.9,26.3 492:68.1,52.8 492:68.5,26.4 492:68.6,52.8 492:69.2,26.8 492:69.3,52.4 492:69.4,32 492:69.4,32.6 492:69.4,33.8 492:69.5,27.3 492:69.5,31.2 492:69.5,31.7 492:69.5,32.9 492:69.5,34.3 492:69.5,34.7 492:69.5,51.9 492:69.6,27.6 492:69.6,29.4 492:69.6,29.7 492:69.6,36.1 492:69.6,36.7 492:69.7,38.3 492:69.7,38.9 492:69.7,40.1 492:69.7,51.1 492:69.8,41.3 492:69.8,42 492:69.8,42.6 492:69.8,50.1 492:69.9,44.3 492:69.9,45 492:69.9,46 492:69.9,47.2 492:69.9,48.3 492:69.9,48.5 N:26581'}
G[29796]={'495:50.88,65.59'}
G[29799]={'492:56,38.9 492:56.1,39.8 492:56.3,38.3 492:56.3,40.7 492:56.5,41.3 492:56.7,41.9 492:56.9,38 492:57.2,43.1 492:57.4,38.8 492:57.4,43.6 492:57.5,38.4 492:57.5,39.1 492:57.5,44 492:57.6,39.6 492:57.9,44.6 492:58,40.7 492:58.4,41.7 492:58.4,45.5 492:58.5,41.9 492:58.6,45.8 492:58.9,42.9 492:59.4,44.1 492:59.4,47.3 492:59.5,44.3 492:59.8,45 492:59.9,48.4 492:60,45.5 492:60,48.7 492:60.4,46.5 492:60.4,49.6 492:60.5,49.9 492:60.6,47 492:61,51.2 492:61.1,48.1 492:61.2,51.7 492:61.3,48.6 492:61.4,52.5 492:61.5,49.1 492:61.6,53.1 492:61.7,49.7 492:62,54.1 492:62.3,50.9 492:62.4,55.4 492:62.4,55.9 492:62.4,56.5 492:62.5,51.3 492:62.6,51.5 492:62.9,56.5 492:63,52.5 492:63.4,53.9 492:63.4,56.3 492:63.6,54.4 492:63.6,54.5 492:63.8,55.7 N:26170'}
G[29801]={'495:31.42,38.08'}
G[29804]={'492:44.1,24.7 N:29343'}
G[29806]={'495:37.7,46.4 495:37.7,46.5'}
G[29839]={'495:49.75,71.80'}
G[29855]={'495:40.78,51.20'}
G[29885]={'495:44.39,68.93'}
G[29937]={'495:37.29,49.73'}
G[29950]={'495:30.64,36.33'}
G[29951]={'495:44.49,28.18'}
G[29975]={'495:47.47,69.09 N:29481'}
G[29997]={'495:48.33,72.12'}
G[30002]={'492:44.6,20.4 492:44.6,20.5'}
G[30007]={'496:48.4,56.3 496:48.5,56.3 N:18471'}
G[30009]={'496:48.4,56.4 496:48.5,56.4 496:48.5,56.5 N:22893'}
G[30041]={'495:48.44,72.15'}
G[30052]={'495:39.66,59.90','Walking a path'}
G[30056]={'492:41,23.9'}
G[30074]={'492:43.3,25.3'}
G[30082]={'495:38.26,61.70 N:30052'}
G[30099]={'495:75.38,63.56'}
G[30105]={'495:65.42,60.16'}
G[30115]={'504[1]:30.50,48.83'}
G[30116]={'504[1]:31.27,48.11'}
G[30127]={'495:63.21,63.24 N:30099'}
G[30137]={'504[2]:49.10,46.00'} -- wanders around the whole area 504[2]:55.01,52.22 504[2]:48.91,45.47 504[2]:43.15,38.38
G[30152]={'495:31.28,38.17'}
G[30216]={'492:42.9,25.8 492:43.1,25.3 492:43.4,24.4 492:43.5,24.4 492:43.5,24.5'}
G[30218]={'492:43.2,21.1 N:30056'}
G[30223]={'492:87.1,75.9'}
G[30224]={'492:86.1,75.8'}
G[30226]={'492:86.8,76.6'}
G[30227]={'492:87,79'}
G[30232]={'492:32.4,42.9 492:32.5,42.9'}
G[30247]={'495:36.44,49.09'}
G[30252]={'495:64.84,59.07'}
G[30271]={'510:72.17,80.96'}
G[30294]={'495:63.51,59.75'}
G[30295]={'495:56.2,51.4 495:56.2,51.5 N:29445'}
G[30314]={'492:43.75,24.37'}
G[30344]={'492:61.4,47.4'}
G[30345]={'492:61.4,47.4'}
G[30348]={'HL 486:59.09,65.63'}
G[30357]={'HL 490:60.56,27.68'}
G[30358]={'HL 488:29.75,55.91'}
G[30359]={'HL 495:28.89,73.72'}
G[30360]={'HL 486:33.80,34.36'}
G[30362]={'HL 493:49.77,63.62'}
G[30363]={'HL 488:48.77,78.16'}
G[30364]={'HL 486:57.40,43.72'}
G[30365]={'HL 493:63.81,49.02'}
G[30367]={'HL 490:80.52,37.11'}
G[30368]={'HL 501:49.03,13.95'}
G[30369]={'HL 496:58.91,55.97'}
G[30370]={'HL 495:41.15,84.73'}
G[30371]={'HL 486:42.94,49.58'}
G[30372]={'HL 490:64.18,46.98'}
G[30373]={'HL 488:35.10,48.34'}
G[30374]={'HL 495:64.59,51.33'}
G[30375]={'HL 495:31.26,37.62'}
G[30381]={'495:65.67,51.46'}
G[30382]={'495:39.56,56.36 N:28070'}
G[30390]={'495:71.4,48.9 N:29445'}
G[30395]={'495:61.18,39.01','In cave'}
G[30401]={'495:30.2,74.7'}
G[30406]={'492:36.1,33.1'}
G[30433]={'492:87.80,78.07'}
G[30469]={'495:48.52,54.36','In cave'}
G[30472]={'495:36.97,49.51'}
G[30481]={'Near'}
G[30490]={'504[2]:31.29,49.65'}
G[30531]={'HL 523[1]:47.42,69.63 491:57.34,46.99>523'}
G[30533]={'HL 533[1]:21.8,44.0 488:26.01,50.83>533'}
G[30534]={'HL 534[1]:68.85,79.12 496:28.53,86.94>534'}
G[30535]={'HL 526[1]:29.41,62.04 495:39.54,26.92>526'}
G[30536]={'HL 520[1]:55.23,64.73 486:27.50,26.10>520'}
G[30537]={' HL 530[1]:45.67,61.57 496:76.27,21.19>530'}
G[30538]={'HL 524[1]:48.75,22.94 491:57.25,46.59>524'}
G[30548]={'495:44.52,64.55','In back of cave'}
G[30562]={'492:79.8,30.9'}
G[30569]={'496:70.47,23.28'}
G[30596]={'492:83.1,72.9'}
G[30631]={'492:35.4,66.4'}
G[30657]={'492:85.7,76'}
G[30658]={'536[1]:47.63,89.77 504[1]:66.81,68.15>536'}
G[30671]={'496:70.1,22.9'}
G[30676]={'496:70.06,20.93'}
G[30677]={'492:86,75.8 N:28179'}
G[30683]={'492:82.9,72.8 N:30226'}
G[30686]={'492:83,73'}
G[30708]={'492:35.4,66.4 492:35.4,66.5 492:35.5,66.4 492:35.5,66.5'}
G[30709]={'362:29.2,21.8'}
G[30714]={'492:83,73'}
G[30824]={'492:60,33.8 492:60,35.2 492:60.1,33.2 492:60.1,35.6 492:60.4,32.2 492:60.4,36.5 492:60.5,31.9 492:60.9,37.4 492:61,37.7 492:61.1,31.2 492:61.4,38.6 492:61.6,39.2 492:61.7,30.9 492:62,39.9 492:62.3,40.6 492:62.5,30.6 492:62.7,41.3 492:62.8,41.6 492:63.3,29.8 492:63.4,43.1 492:63.5,43.3 492:63.6,29.5 492:63.7,29.4 492:63.9,44.4 492:64.1,44.9 492:64.3,45.5 492:64.6,28.7 492:64.6,46.4 492:64.8,47 492:65,47.6 492:65.3,28.1 492:65.4,48.5 492:65.5,28 492:65.6,48.8 492:66.1,50 492:66.2,27.2 492:66.3,50.5 492:66.5,26.9 492:66.5,50.9 492:66.8,51.6 492:67.4,26.3 492:67.5,52.4 492:67.8,52.7 492:68.2,26.4 492:68.5,26.4 492:69.1,26.8 492:69.2,52.5 492:69.4,31.4 492:69.4,31.6 492:69.4,33.2 492:69.4,33.8 492:69.4,34.6 492:69.4,52 492:69.5,27.4 492:69.5,30.2 492:69.5,30.5 492:69.5,35 492:69.5,35.7 492:69.5,51.9 492:69.6,27.6 492:69.6,37.4 492:69.6,38.3 492:69.6,38.8 492:69.7,28.8 492:69.7,40 492:69.7,41.2 492:69.7,41.8 492:69.7,42.7 492:69.7,50.8 492:69.8,44.3 492:69.8,45 492:69.8,46 492:69.8,47.2 492:69.8,48.2 492:69.8,49.3 492:69.8,49.6'}
G[30825]={'492:60,34.8 492:60.1,34 492:60.2,33.2 492:60.4,32.4 492:60.4,36.4 492:60.4,36.5 492:60.6,32 492:60.6,36.8 492:60.9,37.5 492:61.4,31.2 492:61.4,38.7 492:61.7,39.3 492:61.9,39.7 492:62.1,30.8 492:62.3,40.6 492:62.5,30.5 492:62.5,41 492:62.8,30.2 492:62.8,41.6 492:63.3,42.8 492:63.5,29.6 492:63.5,43.4 492:63.9,29.3 492:63.9,44.3 492:64.2,45.2 492:64.4,45.8 492:64.6,28.7 492:64.6,46.3 492:64.9,28.4 492:64.9,47.2 492:65.1,47.8 492:65.4,48.5 492:65.5,48.7 492:65.6,27.8 492:65.9,49.6 492:66.3,27.1 492:66.4,50.7 492:66.7,51.3 492:66.8,26.7 492:66.9,51.6 492:67.4,26.4 492:67.6,26.4 492:67.7,52.4 492:68.3,26.5 492:68.3,52.6 492:68.6,26.6 492:68.7,52.6 492:69.4,27.6 492:69.4,31.1 492:69.4,32.2 492:69.4,32.8 492:69.4,34.2 492:69.4,34.5 492:69.4,51.9 492:69.5,28.4 492:69.5,29.1 492:69.5,29.9 492:69.5,30.5 492:69.5,34.4 492:69.5,35.2 492:69.5,35.8 492:69.5,36.5 492:69.5,51.5 492:69.6,38 492:69.6,38.6 492:69.6,51.3 492:69.7,40.4 492:69.7,40.6 492:69.7,41.6 492:69.7,42.6 492:69.7,50.3 492:69.8,44.2 492:69.8,45.3 492:69.8,46 492:69.8,47 492:69.8,48.4 492:69.8,49.1 603:42.2,14.3'}
G[30869]={'501:71.98,30.97'}
G[30871]={'524[2]:43.99,18.21 491:57.25,46.59>524'}
G[30944]={'492:54.1,71.1'}
G[30946]={'492:44,24.6'}
G[30997]={'521:31.4,45.3 521:31.4,45.5 521:32.1,44.4 521:32.1,45.1 521:32.2,44.4 521:32.2,44.8 521:32.4,45.5 521:32.4,45.8 521:32.5,44.9 521:32.5,45.7 521:32.6,44.4 521:32.7,45.3 521:32.8,44.3 N:10667'}
G[31036]={'501:49.83,18.08'}
G[31044]={'492:79.8,71.8 N:28179'}
G[31051]={'501:48.46,21.16'}
G[31052]={'501:53.07,20.88'}
G[31053]={'501:22.27,34.39'}
G[31054]={'501:43.72,17.16'}
G[31069]={'492:79.41,72.37 N:30227'}
G[31078]={'492:19.33,47.78'}
G[31081]={'504[1]:67.73,47.17'}
G[31082]={'502:34,30.3 502:34.2,30.5 N:28510'}
G[31084]={'23:83.42,49.44 N:28444'}
G[31085]={'504[1]:69.38,40.69'}
G[31091]={'501:22.2,35 501:22.3,35.5 501:22.5,35 501:49.8,18 501:50,18.5 501:50.5,18'}
G[31101]={'501:21.8,35.5 501:21.9,35.3 501:51.7,21.1'}
G[31102]={'501:22.5,34.6 501:53.3,20.8 501:53.8,21'}
G[31106]={'501:22,34.4 501:22,34.5 501:47.1,21.1'}
G[31107]={'501:22.4,35.4 501:22.4,35.7 501:22.5,35.4 501:22.5,35.7 501:48.6,24.5 501:48.7,24.2'}
G[31108]={'501:47.2,21 501:71.9,31.3 501:72,31.5'}
G[31109]={'501:51.07,24.63'}
G[31134]={'536[1]:45.99,80.44'}
G[31135]={'492:30.8,29.1'}
G[31151]={'501:21.8,34.4 501:21.8,34.5 501:50.2,17.8'}
G[31153]={'501:50.22,17.74'}
G[31154]={'492:31.6,30.9'}
G[31237]={'492:53.8,87'}
G[31240]={'492:79.5,72.7'}
G[31241]={'492:79.4,72.9 492:79.5,72.8'}
G[31259]={'492:0.7,51.4 492:0.9,57.7 492:1.8,52.6 492:4.1,60.6 492:4.3,65 492:4.6,61.8 492:5.3,63.1 492:5.3,66.9 492:5.7,65.8 492:5.9,64 492:41.2,25.1 492:55.1,41 492:55.2,40.3 492:55.3,41.6 492:55.4,37.4 492:55.4,38.3 492:55.4,38.5 492:55.6,40.1 492:55.8,40.8 492:55.9,41.8 492:56,38.4 492:56,38.8 492:56.1,42.9 492:56.2,37.3 492:56.2,43.6 492:56.4,44.7 492:56.5,41 492:56.5,41.6 492:56.8,36.2 492:56.8,37 492:56.9,44.4 492:57,45.7 492:57.1,45 492:57.2,43.1 492:57.4,37.7 492:57.4,39 492:57.4,46.6 492:57.5,38.3 492:57.5,38.7 492:57.5,43.9 492:57.6,36.9 492:57.8,40.1 492:57.8,46.8 492:57.9,45.5 492:58,40.8 492:58.3,41.5 492:58.3,45.3 492:58.4,48.3 492:58.5,38 492:58.5,47.1 492:58.6,42.3 492:58.6,46.2 492:58.7,38.9 492:58.8,47.6 492:58.9,40 492:59,40.5 492:59,42.9 492:59.1,49.7 492:59.3,50.5 492:59.4,44.1 492:59.4,48.8 492:59.5,48.3 492:59.6,41.1 492:59.8,44.6 492:59.8,48.6 492:60,42.2 492:60,42.5 492:60,44.3 492:60,49.8 492:60.1,46 492:60.3,51.4 492:60.3,52.4 492:60.3,53.1 492:60.4,46.5 492:60.4,53.6 492:60.5,43.4 492:60.5,44.6 492:60.5,49.8 492:60.5,50.9 492:60.6,44.4 492:60.6,53.8 492:60.8,46.3 492:61,47.5 492:61.2,52 492:61.2,52.6 492:61.3,47.4 492:61.3,48.8 492:61.3,54.5 492:61.4,56.3 492:61.5,45.7 492:61.6,53.5 492:61.7,53.3 492:61.9,47.3 492:61.9,49.6 492:62,56.6 492:62.1,47.9 492:62.3,50.6 492:62.3,56.1 492:62.4,49 492:62.4,55.2 492:62.4,57.7 492:62.5,48.4 492:62.5,48.8 492:62.5,49.7 492:62.7,51.8 492:63,50.7 492:63,57.9 492:63.3,52.8 492:63.3,56.5 492:63.4,53.9 492:63.4,56.4 492:63.6,50.4 492:63.6,52.5 492:63.6,54.5 492:63.7,51.2 492:63.7,52.1 492:63.7,57.7 492:64,53.7 492:64,56 492:64.4,56.7 492:64.5,53.4 492:64.5,56.9 492:64.7,53.8 492:64.7,55.5 492:65,55.4'}
G[31261]={'492:2.7,49.1 492:2.9,45.2 492:3.6,44.1 492:4.4,53 492:4.6,53.5 492:5.4,42.1 492:6,42.1 492:6,57.1 492:6.1,56 492:7,58.8 492:7.2,40.4 492:7.4,60.2 492:7.6,60.1 492:7.8,39.8 492:7.8,60.6 492:8.6,62.5 492:9.3,39.2 492:9.8,39.3 492:10.2,39.7 492:10.5,50.5 492:10.5,54.7 492:10.7,48.3 492:10.9,60.6 492:42.4,22.1 492:43.2,24.2 492:43.3,24.5 492:44.4,26.9 492:46,24.6 492:59.9,33.9 492:59.9,34.5 492:60.2,36.3 492:60.2,36.9 492:60.3,31.9 492:60.3,32.7 492:60.5,33.2 492:60.5,33.6 492:60.5,35.2 492:60.7,36.1 492:60.9,31.2 492:60.9,32.4 492:60.9,37 492:61.2,39.1 492:61.4,38.1 492:61.4,39.7 492:61.5,37.9 492:61.6,40 492:61.7,31.6 492:62.2,39.3 492:62.2,41.2 492:62.3,30 492:62.4,30.8 492:62.4,41.7 492:62.5,30.2 492:62.5,40.8 492:62.5,41.8 492:62.6,30.9 492:62.7,40.3 492:63,42.7 492:63.1,29.3 492:63.3,43.6 492:63.6,29.5 492:63.6,42.4 492:63.6,43 492:63.6,44.1 492:63.9,45.6 492:64,45.2 492:64.2,29.1 492:64.3,46.5 492:64.4,28.3 492:64.5,45.9 492:64.6,45.3 492:64.6,46.9 492:64.8,28 492:64.8,28.7 492:64.8,47.6 492:65.3,49.2 492:65.4,27.4 492:65.4,49.5 492:65.5,48 492:65.6,28.5 492:65.6,49.5 492:65.9,49.3 492:66,27.6 492:66.3,26.6 492:66.4,51.4 492:66.4,51.5 492:66.5,27.5 492:66.5,49.9 492:66.9,26.4 492:66.9,50.9 492:67.2,26.6 492:67.3,51.9 492:67.3,52.7 492:67.5,52.2 492:68,26.3 492:68.3,27 492:68.3,52.5 492:68.5,27 492:68.6,52.2 492:68.7,26.2 492:68.7,53 492:69,31.7 492:69.1,29.6 492:69.1,32.7 492:69.1,35.4 492:69.2,29 492:69.2,31 492:69.2,34.2 492:69.2,35.7 492:69.2,36.5 492:69.2,51.1 492:69.3,38.2 492:69.3,40.1 492:69.3,41 492:69.3,41.7 492:69.4,28.1 492:69.4,38.9 492:69.4,42.6 492:69.4,44 492:69.4,44.6 492:69.4,46.2 492:69.4,47.3 492:69.4,47.7 492:69.4,49.2 492:69.4,49.6 492:69.5,29.2 492:69.5,35.2 492:69.5,41.7 492:69.5,50.5 492:69.5,51.6 492:69.6,27.2 492:69.6,30.7 492:69.6,35.8 492:69.6,39.7 492:69.7,31.5 492:69.7,33.4 492:69.7,34.2 492:69.7,44.9 492:69.8,28 492:69.8,30.1 492:69.8,37.3 492:69.8,48.7 492:69.9,38 492:70,39 492:70,40.7 492:70,44.3 492:70.1,42.5 492:70.1,49.9 492:70.2,45.8 492:70.2,46.9 492:70.2,47.5'}
G[31273]={'492:66.9,66.4 492:67.1,67.3 492:67.2,67.5 492:67.2,68.8 492:67.3,69.5 492:67.7,68.3 492:67.8,68.6 492:67.9,71.1 492:68.1,67.4 492:68.5,69.7 492:68.7,64.5 492:68.7,69.1 492:68.8,64.3 492:68.9,65.9 492:69,67.2 492:69.3,67.9 492:70,62.3 492:70,62.5 492:70.4,65 492:70.4,67.3 492:70.5,65 492:70.5,67.2 492:70.8,68.3 492:70.8,68.5'}
G[31279]={'492:31.8,64.8 492:31.9,64.2'}
G[31304]={'492:66.1,65.4 492:66.1,65.5 492:66.3,64.1 492:66.4,66.5 492:66.5,66.5 492:66.7,65.7 492:66.8,64 492:67.2,63.3 492:67.3,69.1 492:67.4,67.6 492:67.5,67.7 492:67.7,70.3 492:67.9,64.5 492:68.1,63.4 492:68.1,63.5 492:68.1,67.4 492:68.1,69.4 492:68.4,62.4 492:68.5,62.3 492:68.6,69.1 492:68.7,66.4 492:68.7,66.5 492:68.8,62.7 492:68.8,64.4 492:68.8,64.5 492:69.1,68.3 492:69.2,70.4 492:69.2,70.5 492:69.5,66 492:69.5,67.3 492:69.5,67.5 492:69.8,63.2 492:69.8,64.6 492:70.2,61.9 492:70.4,64.1 492:70.5,65.1 492:70.8,62.9 492:70.9,63.9 492:71.6,61.1 492:71.6,62.7'}
G[31440]={'492:54.9,84.2'}
G[31444]={'492:51.8,86.7'}
G[31557]={'504:65.6,32.2'}
G[31737]={'492:59.9,53.4 492:59.9,53.5 492:60.6,49.8 492:61.6,52.5 492:62.1,51.8 492:62.7,51 492:62.7,51.6'}
G[31776]={'492:57,62.5'}
G[31781]={'492:51.9,57.6'}
G[31808]={'492:62.6,51.3'}
G[31833]={'492:57.4,47.4 492:57.4,47.5 492:57.5,46.7 492:57.6,48.3 492:58.4,46.1 492:59.4,52.6'}
G[31834]={'492:58.3,46'}
G[31868]={'492:68,51.8'}
G[31892]={'492:54.4,59.1 492:54.5,59.5 492:54.6,59.2'}
G[32273]={'521[2]:51.58,41.68'}
G[32301]={'492:2.3,44.9 492:3.9,43.1 492:4.4,52.2 492:4.8,42.8 492:4.8,53.1 492:5.3,42.3 492:5.4,53.9 492:6.1,56.4 492:6.8,58.4 492:6.8,59.1 492:7.8,60.7 492:8.5,61.4 492:8.7,39.6 492:8.8,62.1 492:10.1,62.6 492:10.4,40.3 492:10.6,46.8 492:10.6,51.7 492:10.6,53.5 492:10.7,48.2 492:10.7,53.4 492:11,51.4 492:11,61.2 492:46,26.5 492:59.9,33 492:60.1,33.6 492:60.2,34.7 492:60.3,31.8 492:60.3,36 492:60.4,37 492:60.5,33.7 492:60.5,35.3 492:60.5,35.9 492:60.6,32.1 492:60.6,32.6 492:60.7,37.2 492:61.1,38 492:61.1,39 492:61.2,31.4 492:61.4,39.6 492:61.5,38 492:61.5,38.5 492:61.6,31.1 492:61.9,30.4 492:61.9,31.5 492:62,39.9 492:62,40.8 492:62.4,41.6 492:62.6,30.6 492:62.6,40.4 492:62.6,41.2 492:63,30 492:63.2,42.2 492:63.3,29.3 492:63.3,42.9 492:63.4,44.1 492:63.5,42.3 492:63.5,42.7 492:63.6,43.6 492:64.1,29.7 492:64.2,28.4 492:64.2,45.3 492:64.3,28.9 492:64.4,46.1 492:64.4,46.9 492:64.5,45.1 492:64.5,46 492:64.6,28.7 492:64.8,47.4 492:65.1,28.2 492:65.2,48.2 492:65.3,48.6 492:65.4,27.3 492:65.4,49.5 492:65.5,48.4 492:65.6,27.6 492:65.7,49.1 492:65.8,49.6 492:66.3,27.1 492:66.4,50.6 492:66.6,50.4 492:66.7,51.7 492:66.8,51.4 492:67.2,52.5 492:67.3,26.2 492:67.4,26.5 492:67.5,52.2 492:67.9,26.4 492:68,26.5 492:68.1,52.6 492:68.6,53 492:69,26.4 492:69.2,29.1 492:69.2,35 492:69.2,36.9 492:69.2,52 492:69.3,27.3 492:69.3,30.6 492:69.3,33.3 492:69.3,33.7 492:69.3,35.9 492:69.3,39.2 492:69.4,28.1 492:69.4,30.4 492:69.4,32.1 492:69.4,37.9 492:69.4,39.6 492:69.4,41.2 492:69.4,42.3 492:69.4,42.5 492:69.4,44.6 492:69.4,49.3 492:69.4,49.9 492:69.4,50.5 492:69.5,27 492:69.5,28.7 492:69.5,29.6 492:69.5,30.8 492:69.5,32 492:69.5,33.5 492:69.5,35 492:69.5,36.5 492:69.5,51.7 492:69.6,27.5 492:69.6,33.4 492:69.6,38.3 492:69.6,38.8 492:69.7,35.9 492:69.7,40.1 492:69.7,40.8 492:69.8,41.6 492:69.8,43.8 492:69.8,44.7 492:69.8,46.1 492:69.8,48.6 492:69.8,49.9 492:69.9,47 492:69.9,48.3 492:69.9,51.4 492:70.1,42.9'}
G[32302]={'492:41.3,25.3 492:41.6,25.9 492:55.3,39 492:55.4,38.4 492:55.4,39.8 492:55.5,39.3 492:55.7,40.4 492:55.8,37.5 492:55.8,40.9 492:55.9,41.9 492:56.1,37.3 492:56.4,43.2 492:56.6,43.6 492:56.7,43.4 492:57,36.9 492:57.1,44.8 492:57.5,45.4 492:57.7,37.4 492:57.9,45.8 492:58,38.2 492:58.2,39.1 492:58.2,46.6 492:58.3,39.5 492:58.5,40 492:58.5,47.2 492:58.8,47.8 492:58.9,41.1 492:59.2,41.7 492:59.3,48.8 492:59.4,42.5 492:59.5,42.4 492:59.6,49.2 492:59.8,43.3 492:59.8,43.6 492:60,50 492:60.1,50.9 492:60.3,51.5 492:60.4,44.5 492:60.5,44.9 492:60.5,51.4 492:60.6,52.2 492:60.8,45.5 492:60.9,53.3 492:61.2,54 492:61.4,46.9 492:61.4,54.6 492:61.5,47.2 492:61.5,54.3 492:61.5,54.9 492:61.8,48.4 492:61.8,56.3 492:61.8,56.6 492:62.3,49.5 492:62.4,49.3 492:62.4,57.6 492:62.5,50 492:62.6,57.5 492:63.3,51.3 492:63.4,51.5 492:63.4,57.2 492:63.5,51.7 492:63.7,52.6 492:64.1,53.7 492:64.3,54.5 492:64.4,56.4 492:64.4,56.7 492:64.5,55.1 492:64.5,55.7'}
G[32337]={'504[1]:54.00,32.27'}
G[32404]={'492:64.5,44 N:31237'}
G[32408]={'492:68,51.7 N:31237'}
G[32413]={'504[1]:44.64,63.30'}
G[32423]={'492:71.6,37.6 N:31237'}
G[32430]={'492:54,36.9'}
G[32444]={'492:54,42.9'}
G[32497]={'492:49.2,73.1 N:31237'}
G[32516]={'504[2]:43.16,24.42'}
G[32540]={'495:66.16,61.43'}
G[32548]={'486:29.4,24.8 486:29.5,24.8'}
G[32571]={'495:62.61,60.92'}
G[32594]={'495:67.1,60.9'}
G[32599]={'488:79.3,65.1'}
G[32638]={'1018:68.32,40.58'}
G[32639]={'947:32.39,41.87'}
G[32641]={'24:57.94,72.62'}
G[32642]={'27:53.63,52.54'}
G[32725]={'1014[10]:33.45,47.33'}
G[32798]={'HN 4:51.82,42.07 9:46.93,59.53 20:61.62,53.11 462:47.77,47.13'}
G[32799]={'HN 27:53.99,50.70 30:42.98,65.40 41:55.59,51.36 464:49.07,51.25'}
G[32800]={'492:31.3,62.4 492:31.4,59 492:31.7,57.8 492:31.8,64.8 492:31.9,57.2 492:31.9,64.2 N:31279'}
G[32801]={'HM 486:55.10,19.94'}
G[32802]={'HM 493:48.09,66.36'}
G[32803]={'HM 488:75.29,43.80'}
G[32804]={'HM 491:57.80,16.12'}
G[32805]={'HM 490:33.90,60.45'}
G[32806]={'HM 495:41.44,86.69'}
G[32807]={'HM 510:78.18,74.95'}
G[32808]={'HM 496:40.37,61.30'}
G[32809]={'HM 486:51.13,11.54'}
G[32810]={'HM 493:47.06,61.56'}
G[32811]={'HM 488:38.26,48.47'}
G[32812]={'HM 491:48.61,13.15'}
G[32813]={'HM 490:19.32,61.15'}
G[32814]={'HM 495:40.27,85.35'}
G[32815]={'HM 510:79.97,53.23'}
G[32816]={'HM 496:43.37,71.74'}
G[32836]={'HN 27:54.11,50.82 30:43.04,65.33 41:55.72,51.30 464:49.02,51.19'}
G[32837]={'HN 4:51.90,41.87 9:47.12,59.89 20:61.35,52.98 462:47.65,47.31'}
G[32862]={'42:72.38,18.75'}
G[32863]={'42:58.8,19.4'}
G[32867]={'529[2]:13.21,57.21'}
G[32871]={'529[2]:80.92,45.50'}
G[32912]={'42:50.31,20.33'}
G[32932]={'42:44.6,30.8'}
G[32959]={'42:50.82,17.95'}
G[32960]={'42:50.9,18'}
G[32963]={'42:58.91,19.45'}
G[32964]={'42:64.51,5.47 N:11711'}
G[32965]={'42:58.89,19.41'}
G[32966]={'42:58.88,19.53'}
G[32967]={'42:43.5,80.9'}
G[32968]={'42:43.5,80.9'}
G[32970]={'42:64,5.4'}
G[32971]={'42:50.22,19.78'}
G[32972]={'42:50.93,18.21'}	-- moves about
G[32973]={'42:51.78,18.01'}
G[32977]={'42:51.2,19.6'}
G[32978]={'42:51.2,19.7'} -- 42:56.8,30 removed because it is fleeting
G[32979]={'42:51.00,19.19'}
G[32987]={'42:42.68,45.15'}
G[33022]={'42:58.6,32.6'}
G[33025]={'496:69.99,20.96'}
G[33048]={'42:42.97,39.01'}
G[33055]={'42:63.75,5.98'}
G[33072]={'42:45.4,74.9'}
G[33091]={'42:43.7,53.4 42:43.7,53.5'}
G[33107]={'42:42.6,45.1'}
G[33112]={'42:44.43,56.78'}
G[33117]={'42:40.94,56.48'}
G[33119]={'42:45.4,48.5 42:45.5,48.5'}
G[33126]={'42:42.9,39'}
G[33131]={'42:42.79,40.17'}
G[33132]={'42:42.46,38.56'}
G[33133]={'42:43.68,39.85'}
G[33166]={'42:49.2,57'}
G[33175]={'42:52.4,18'}
G[33176]={'42:69.09,19.24'}
G[33177]={'42:46.8,33.2'}
G[33178]={'42:72.28,19.09'}
G[33182]={'43:29,24.1'}
G[33187]={'43:26.9,22'}
G[33204]={'43:26.8,22'}
G[33222]={'492:76.5,19.2'}
G[33223]={'492:76.6,19.2'}
G[33225]={'492:76.6,19.2'}
G[33231]={'42:42.59,45.29'}
G[33232]={'42:38.6,42.4'}
G[33250]={'42:45.2,75.1'}
G[33253]={'42:44.41,75.47'}
G[33256]={'688[1]:47.95,13.43'}
G[33258]={'688[1]:47.93,13.10'}
G[33260]={'688[1]:48.48,12.05'}
G[33261]={'688[1]:48.48,11.62'}
G[33263]={'11:42.42,15.77'}
G[33276]={'43:26.9,36.7 43:27,36.3'}
G[33280]={'301:53.9,81.4 605:59.7,72.6'}
G[33284]={'11:42.27,15.20'}
G[33294]={'43:64.16,84.50'}
G[33309]={'492:76.6,19.5'}
G[33312]={'492:76.6,19.5'}
G[33315]={'492:76.6,19.4 492:76.6,19.5'}
G[33335]={'492:76.5,19.8'}
G[33361]={'492:76.4,24.5 492:76.5,24.5'}
G[33372]={'492:76,24.4 492:76,24.5'}
G[33373]={'492:76.5,24.2'}
G[33379]={'492:76.4,23.9 492:76.5,23.9'}
G[33403]={'492:76.2,24.6'}
G[33405]={'492:76.4,24.4 492:76.4,24.5 492:76.5,24.5'}
G[33417]={'492:69.4,23 492:69.5,23.1'}
G[33421]={'43:72.93,80.44'}
G[33443]={'43:20.2,38.8'}
G[33445]={'43:26.8,36'}
G[33454]={'43:34.7,48.6'}
G[33532]={'HC Near'}
G[33533]={'HC Near'}
G[33536]={'182:50.3,14.5 182:50.9,14.5 182:51.9,15 182:52.6,14.5 182:53.1,17.4 182:54,16.8 182:54.5,20.6 182:55.2,19 529:53,37.9 529:53,39.1 529:53.1,36 529:53.1,37.3 529:53.2,36 529:53.3,37.2 529:53.3,39 529:53.3,39.6 529:53.3,39.7 529:53.4,38.4 529:53.7,39 529:53.7,39.8 529:53.9,35.9 529:53.9,37.6 529:54.3,35.3 529:54.3,35.4 529:54.3,35.9 529:54.3,36.5 529:54.3,37.7 529:54.4,36.8 529:54.4,38.9 529:54.4,39.5 529:54.5,35.4 529:54.5,38.5 529:54.6,35.5 529:54.6,36.7 529:54.6,37 529:54.6,37.9 529:54.6,38.5 529:54.6,39.5 529:54.7,36 529:54.8,37.9 529:55.5,38 529:55.6,37.4 610:63.9,59.5 640:71.8,47.7 614:52.4,59.4'}
G[33538]={'492:76.4,23.8'}
G[33539]={'492:76.2,24.6'}
G[33540]={'492:76,24.5'}
G[33541]={'492:76.5,24.2'}
G[33542]={'492:76.3,24.3'}
G[33544]={'492:76.4,24.5'}
G[33545]={'492:76,24.4 492:76,24.5'}
G[33547]={'492:76.5,24.3'}
G[33548]={'492:76.4,23.9 492:76.5,23.9'}
G[33549]={'492:76.2,24.6'}
G[33592]={'492:76.3,19.1'}
G[33593]={'492:76.1,19.2'}
G[33625]={'492:76.4,19.4 492:76.4,19.5'}
G[33646]={'492:76.4,19.4 492:76.4,19.5'}
G[33647]={'492:76.4,19.4 492:76.4,19.5 492:76.5,19.5'}
G[33648]={'492:76.5,19.8'}
G[33649]={'492:76.5,19.8'}
G[33652]={'492:76.3,19.1'}
G[33654]={'492:76.4,19.1'}
G[33655]={'492:76.1,19.2'}
G[33656]={'492:76.1,19.1'}
G[33658]={'492:76.3,24.3'}
G[33659]={'492:76.2,24.4'}
G[33726]={'43:73.33,62.19'}
G[33727]={'43:86.4,43.7 43:86.5,43.7'}
G[33759]={'492:69.9,23.4 492:69.9,23.5'}
G[33760]={'43:72.20,57.65','In mine'}
G[33762]={'492:73.8,20'}
G[33763]={'492:69.9,23.4 492:69.9,23.5'}
G[33769]={'492:73.8,19.5'}
G[33770]={'492:73.6,20'}
G[33771]={'492:69.9,23.4'}
G[33777]={'43:75.4,75.8 43:75.6,75.5 43:75.7,75.2'}
G[33817]={'492:69.7,22.8'}
G[33837]={'43:73.61,62.14 N:8582'}
G[33849]={'492:72.59,22.62'}
G[33889]={'43:82.54,53.81'}
G[33956]={'529:14,88.6 529:15.2,89.5 529:15.3,87.3 529:15.3,88.8 529:15.4,88.4 529:15.8,87 529:15.8,88.2 529:15.9,90 529:16.1,88.8 529:16.6,88.1 529:16.6,88.7 529:16.8,89.5'}
G[33957]={'529:14.8,87 529:14.9,87.6 529:15.1,88.7 529:15.5,88.6 529:15.6,87.1 529:15.7,87.6 529:16.1,90.2'}
G[33977]={'43:72.20,57.65 N:33760','In mine'}
G[33981]={'42:57.39,33.85'}
G[34041]={'42:59.1,19.6'}
G[34122]={'43:12.08,33.83'}
G[34195]={'43:94.40,46.82'}
G[34210]={'492:69.5,22.4'}
G[34233]={'43:90.76,58.15'}
G[34239]={'43:36.4,49.8'}
G[34242]={'43:89.6,48.7'}
G[34251]={'43:38,30.1'}
G[34258]={'11:67.44,38.74'}
G[34283]={'43:52.1,56.5'}
G[34284]={'11:66.50,45.55 11:66.49,45.45'}
G[34289]={'43:52.33,56.77'}
G[34290]={'43:52.32,56.51'}
G[34292]={'43:52.09,56.72'}
G[34301]={'42:45.2,74.7'}
G[34303]={'43:11.40,35.36'}
G[34320]={''}
G[34335]={'43:59.1,59.9'}
G[34340]={'42:37.7,82.8'}
G[34341]={'81:74.27,47.72'}
G[34342]={'42:37.7,82.9'}
G[34343]={'42:37.4,82.2 42:37.5,82.3 42:37.7,82.9'}
G[34354]={'43:35.1,71.6'}
G[34358]={'43:59.1,59.9'}
G[34359]={'43:37.99,42.84 43:38.10,43.80 43:39.24,43.58'}
G[34365]={'HC 504[1]:49.36,63.25'}
G[34374]={'43:18.14,20.59'}
G[34377]={'43:62.2,51'}
G[34378]={'43:35.02,72.07'}
G[34395]={'43:37.98,43.86'}
G[34402]={'42:45.3,75.1'}
G[34403]={'42:45.3,75.1'}
G[34404]={'42:45.3,75.1'}
G[34413]={'42:40.61,84.44'}
G[34422]={'42:32.8,84.3 N:33091'}
G[34423]={'42:32.3,85.2'}
G[34435]={'HD 301:47.80,26.69'}
G[34446]={'42:45.7,71.8'}
G[34476]={'HD 382:68.30,15.63'}
G[34477]={'HD 4:47.47,17.63'}
G[34478]={'HD 27:61.66,37.34'}
G[34479]={'HD 381:68.47,39.87'}
G[34480]={'HD 362:57.08,17.37'}
G[34481]={'HD 27:61.63,37.50'}
G[34482]={'HD 4:47.47,17.86'}
G[34483]={'HD 462:47.99,49.47'}
G[34484]={'HD 464:47.61,55.74'}
G[34498]={'42:45.6,71.7'}
G[34510]={'43:38.8,43.3'}
G[34512]={'43:52.09,56.50'}
G[34513]={'11:56.58,40.29'}
G[34518]={'43:60.67,52.68'}
G[34547]={'11:58.01,49.31'}
G[34559]={'43:50.13,67.57'}
G[34560]={'11:53.9,41.5 11:54,41.3'}
G[34569]={'43:49.96,67.24'}
G[34571]={'545:37.41,63.35'}
G[34578]={'11:54.6,41.4 11:54.6,41.5'}
G[34596]={'43:46.16,63.27'}
G[34599]={'43:18,60 N:3698'}
G[34604]={'43:22.3,53.1'}
G[34613]={'11:37.5,45.8'}
G[34626]={'11:60.65,85.37'}
G[34634]={'11:55.11,78.53 11:54.94,78.79'}
G[34638]={'11:55.20,78.40'}
G[34644]={'HY 27:59.81,34.33'}
G[34651]={'11:67.02,74.80'}
G[34653]={'HY 27:52.6,36.4 27:53.4,51.4 27:59.77,34.72 30:34.17,51.08 30:42.25,64.07 41:55.96,51.00 42:50.7,18.8 61:78.31,72.49 381:63.41,47.61 465:55.12,63.40 471:76.17,53.29'}
G[34654]={'HY 4:46.24,14.30 4:52.8,44.1 20:58.7,51.5 24:56.14,47.32 9:46.8,59.1 362:29.93,65.13 382:65.54,8.13 462:46.6,47.3 462:55.5,53.2'}
G[34668]={'605:56.43,76.96'}
G[34673]={'605:60.48,77.57'}
G[34674]={'11:62.6,17'}
G[34675]={'HY 30:34.09,51.54'}
G[34676]={'HY 381:61.48,49.11'}
G[34677]={'HY 382:63.92,11.44'}
G[34678]={'HY 362:30.80,63.69'}
G[34679]={'HY 4:46.59,13.80'}
G[34689]={'605:59.42,73.62'}
G[34692]={'605:57.81,77.14'}
G[34693]={'605:58.88,75.26'} -- 605:59.49,77.73 605:58.30,73.04
G[34695]={'605:59.74,76.02'}
G[34696]={'605:57.90,74.25'}
G[34697]={'605:60.34,77.84'}
G[34698]={'11:62.50,16.76'}
G[34707]={'11:72.60,84.04'}
G[34708]={'HY 27:60.04,34.31'}
G[34710]={'HY 30:33.71,50.63'}
G[34711]={'HY 381:61.89,46.19'}
G[34712]={'HY 382:63.21,8.91'}
G[34713]={'HY 4:46.36,13.86'}
G[34714]={'HY 362:30.4,68.9'}
G[34744]={'HY 30:33.89,50.80'}
G[34749]={'11:77.24,91.39'}
G[34768]={'HY 382:65.26,14.25'}
G[34771]={'492:76.1,24.1'}
G[34828]={'11:62.37,63.90'}
G[34835]={'605:44.3,74.9 605:44.4,75.5 605:44.6,74.4 605:44.7,75.5 605:45.1,74.8'}
G[34841]={'11:38,46.5 11:38.1,46.3'}
G[34850]={'611:59.14,23.91'}
G[34863]={'611:54.63,16.73'}
G[34872]={'605:60.20,74.63'}
G[34874]={'605:58.24,76.53'}
G[34876]={'605:36.4,71.8 605:36.6,71.7 605:36.7,71 605:36.8,70.4'}
G[34877]={'605:35.1,77.7 605:35.4,76.9 605:35.5,78.7 605:35.7,76.4 605:35.7,77.3 605:35.7,77.5 605:36.5,76.6 605:36.6,76.1 605:36.8,75.4'}
G[34878]={'605:41,81.4 605:41,81.5 605:41.7,81.5 605:41.9,80.9 605:42.1,80.4'}
G[34880]={'492:76.3,19.6'}
G[34882]={'492:69.5,23.1'}
G[34884]={'611:55.2,26.5 611:55.4,26.1 611:55.4,27.5 611:55.5,26.7 611:55.5,27.5 611:55.7,29.3 611:55.7,32 611:55.7,38.9 611:55.8,37.7 611:55.9,26.3 611:56,32.8 611:56.1,30.3 611:56.1,30.9 611:56.2,39.5 611:56.3,23.2 611:56.3,37.4 611:56.5,31.7 611:56.5,39.7 611:56.6,30.9 611:56.6,34.1 611:56.6,41.9 611:56.7,35.2 611:56.7,38.6 611:56.8,35.9 611:57,25 611:57.1,25.6 611:57.4,22.3 611:57.4,22.9 611:57.4,23.8 611:57.5,23.9 611:57.5,41.1 611:57.7,30.2 611:57.7,40.4 611:57.8,21.9 611:57.9,23.2 611:58.1,24.5 611:58.1,41.5 611:58.3,31.2 611:58.5,31.4 611:58.6,21.3 611:58.6,42.6 611:58.8,33 611:58.9,24 611:59,30.3 611:59,32.4 611:59,41.7 611:59.2,22 611:59.2,22.7 611:59.5,22.2 611:59.5,29.7 611:59.7,29.3 611:59.8,22.7 611:59.8,26.1 611:59.9,23.5 611:59.9,26.7 611:59.9,30.6 611:59.9,41.3 611:60,28.3 611:60,42.7 611:60.1,36 611:60.1,36.6 611:60.2,24.7 611:60.3,31.7 611:60.3,37.8 611:60.3,42.4 611:60.4,32.9 611:60.4,33.8 611:60.4,34.7 611:60.5,22.3 611:60.5,22.7 611:60.5,33.3 611:60.5,38 611:60.5,41.3 611:60.6,42.5 611:60.7,24.3 611:60.7,25.3 611:60.8,27.2 611:60.8,41.9 611:60.9,28.6 611:60.9,34 611:61,16.8 611:61.1,26.3 611:61.1,35 611:61.1,36.8 611:61.4,28.1 611:61.4,31.1 611:61.4,36.4 611:61.5,22.4 611:61.5,27.4 611:61.5,35.4 611:61.6,17.2 611:61.6,27.6 611:61.6,28.7 611:61.6,31.1 611:61.6,36.2 611:61.6,36.5 611:61.7,25.7 611:61.8,33.7 611:61.8,41.4 611:62.1,32.2 611:62.3,32.5 611:62.4,41.8 611:62.5,32.3 611:62.7,32.7 611:62.9,34 611:63,20.7 611:63,42.1 611:63.3,20.1 611:63.6,33.5 611:63.7,23.4 611:63.7,42.2 611:63.8,16 611:63.8,19.2 611:63.8,44.2 611:64,21.5 611:64,32.3 611:64,44.5 611:64.1,23.9 611:64.1,42.9 611:64.2,33.4 611:64.5,42.5 611:64.6,21.9 611:64.6,41.8 611:64.8,33 611:65,33.5 611:65.3,26.7 611:65.3,37.8 611:65.4,36.9 611:65.6,27.4 611:65.6,41.7 611:65.7,43.7 611:65.8,31.4 611:65.9,28.6 611:66,31.7 611:66.1,29.7 611:66.2,33.1 611:66.2,34.6 611:66.2,38.4 611:66.3,33.8 611:66.5,43.9 611:66.6,34.9 611:66.7,30.2 611:66.7,34.3 611:66.7,36.4 611:67.1,37.3 611:67.2,37.9 611:67.2,38.5 611:67.7,39 611:67.8,37.8 611:68.2,42.1 611:68.3,41 611:68.4,42.7 611:68.5,42 611:68.5,43.3'}
G[34912]={'492:76.2,19.5'}
G[34913]={'611:59.78,22.16 N:34850'}
G[34914]={'492:76.1,24.1'}
G[34936]={'611:59.59,26.79 N:34571'}
G[35053]={'605:56.31,77.10'}
G[35054]={'605:56.31,76.77'}
G[35068]={'321[1]:47.64,71.23'}
G[35077]={'611:55.20,62.89'}
G[35085]={'181:29.12,66.16'}
G[35086]={'181:27.00,77.07'}
G[35087]={'181:29.68,66.88'}
G[35088]={'181:29.72,67.07'}
G[35091]={'181:29.15,66.24'}
G[35094]={'492:69.5,23.1'}
G[35095]={'181:27.01,73.52'}
G[35112]={'611:65.77,77.77'}
G[35115]={'611:65.32,77.65'}
G[35120]={'605:30.11,71.95'}
G[35129]={'181:28.36,75.59'}
G[35136]={'81:70.92,80.57'}
G[35137]={'81:58.80,54.28'}
G[35138]={'81:32.02,61.84'}
G[35142]={'181:70.36,36.25'}
G[35187]={'181:47.23,20.85'}
G[35195]={'181:27,77 N:35086'}
G[35222]={'605:56.71,76.93','Upstairs'}
G[35256]={'HD 504[1]:34.47,38.19'}
G[35260]={'HD 478:39.79,21.80'}
G[35261]={'HD 478:40.17,22.25'}
G[35281]={'381:43.8,78.6'}
G[35286]={'101:54.7,8.8'}
G[35295]={'101:44.6,29.5'}
G[35298]={'101:44.8,29.6'}
G[35369]={'611:56.78,85.49','In basement'}
G[35378]={'611:56.86,81.44'}
G[35384]={'101:76.94,17.99'}
G[35451]={'542[1]:46.04,50.15'}
G[35478]={'101:57.72,49.74'}
G[35481]={'101:36.76,71.68'}
G[35506]={'101:64.8,7.7 101:64.9,7.2 101:65,9.4 101:65.1,10 101:66.3,10.9 101:66.9,10 101:67.4,10.7 101:67.6,10.6 101:68,9.4 101:68,10.3'}
G[35510]={'101:65.1,8.2 101:67,9.7 101:67.6,10.6 101:68.1,10'}
G[35550]={'611:59.37,83.81 N:35112'}
G[35552]={'611:31.13,72.35 N:35077'}
G[35556]={'101:70.65,32.89'}
G[35562]={'101:39.07,26.94'}
G[35566]={'611:48.90,52.76 N:35077'}
G[35591]={'101:51.6,76'}
G[35618]={'611:40.55,39.43'}
G[35632]={'101:53.90,33.27'}
G[35642]={'946:28.37,74.23'}
G[35646]={'811[3]:75.10,43.74'}
G[35648]={'181:47.15,21.06'}
G[35650]={'544:27.87,75.55 N:34668'}
G[35657]={'181:50.68,75.30'}
G[35661]={'101:70.37,32.96'}
G[35754]={'181:47.1,21'}
G[35755]={'181:47.29,21.19'}
G[35756]={'181:47.24,21.27'}
G[35757]={'101:60.9,28.9'}
G[35758]={'544:27.94,74.42 N:34673'}
G[35769]={'544:31.27,79.26 N:34872'}
G[35773]={'101:38.80,26.96'}
G[35786]={'544:27.84,74.29 N:34695'}
G[35817]={'181:52.22,74.24'}
G[35827]={'101:30.94,30.89'}
G[35833]={'181:59.01,71.90'}
G[35837]={'544:31.19,74.12','In cave'}
G[35839]={'611:67.61,64.32'}
G[35840]={'611:70.78,55.08 N:34571'}
G[35867]={'181:55.49,52.13'}
G[35869]={'611:71.40,64.43'}
G[35870]={'611:70.44,65.54'}
G[35871]={'611:71.40,65.73'}
G[35872]={'611:68.03,64.71'}
G[35873]={'611:70.20,65.85'}
G[35874]={'611:71.49,61.20'}
G[35875]={'544:37.62,78.03'}
G[35893]={'544:35.43,75.72'}
G[35902]={'101:29.08,8.08'}
G[35906]={'611:55.72,80.69 N:35115'}
G[35911]={'611:30.37,73.12 N:35112'}
G[35917]={'544:34.61,66.86 N:35893'}
G[36034]={'101:57.46,47.72'}
G[36048]={'101:58.78,46.42'}
G[36052]={'101:58.45,49.85'}
G[36056]={'101:58.29,50.09'}
G[36060]={'101:58.59,48.74'}
G[36077]={'181:50.42,74.29'}
G[36112]={'544:25.28,59.84'}
G[36127]={'544:23.23,67.51'}
G[36132]={'545:37.41,63.24'}
G[36140]={'545:35.94,66.17 N:34850'}
G[36145]={'544:11.77,62.72 N:4949','In ship'}
G[36146]={'181:45.06,75.48'}
G[36161]={'544:12.41,63.14 N:4949'}
G[36163]={'101:71.72,45.57'}
G[36170]={'545:36.51,62.26 N:35115'}
G[36185]={'101:40.50,95.48','Inside cave'}
G[36188]={'544:35.92,66.72 N:4949'}
G[36196]={'750:38.2,58 101[21]:13.02,46.30>750'}
G[36205]={'545:32.77,66.15'}
G[36210]={'181:42.71,25.11'}
G[36290]={'545:28.96,63.92 N:35115'}
G[36291]={'545:28.93,64.02'}
G[36296]={'764[1]:39.31,52.46'}
G[36329]={'101:36.69,71.22'}
G[36332]={'545:36.41,61.25 N:35112'}
G[36334]={'181:55.71,14.76 N:35187'}
G[36335]={'181:32.97,23.55 N:35187'}
G[36336]={'181:62.19,21.07 N:35187'}
G[36337]={'181:31.06,26.77 N:35187'}
G[36361]={'181:55.95,12.15 N:35187'}
G[36372]={'181:25.59,37.96'}
G[36378]={'101:36.39,71.14'}
G[36379]={'181:50.53,74.74'}
G[36398]={'101:72.28,67.35 N:36056'}
G[36410]={'101:54.24,9.28'}
G[36425]={'544:36.02,67.52 N:34668'}
G[36436]={'181:27.92,39.91'}
G[36444]={'101:82.34,80.86 N:36056'}
G[36451]={'545:29.03,65.05 N:34850'}
G[36452]={'545:37.63,65.21 N:34571'}
G[36456]={'545:36.89,84.17'}
G[36457]={'545:37.67,72.76 N:35378'}
G[36458]={'545:32.52,75.49'}
G[36470]={'544:44.54,64.36 N:34872'}
G[36471]={'544:45.36,64.75 N:34872'}
G[36479]={'381:49.8,16.6 381:49.9,15.4 381:49.9,16'}
G[36487]={'101:73.38,73.05 N:36185'}
G[36500]={'181:42.22,76.09'}
G[36502]={'601[1]:44.38,13.63'}
G[36594]={'181:49.56,28.76'}
G[36596]={'181:42.61,23.69'}
G[36600]={'544:24.64,77.94'}
G[36606]={'545:28.13,50.04'}
G[36608]={'544:24.61,77.87'}
G[36616]={'545:42.58,35.96'}
G[36624]={'492:74.2,31.3'}
G[36642]={'492:53.5,90.7 492:74.5,31.1'}
G[36644]={'9:47.66,59.58'}
G[36648]={'362:60.30,51.69'}
G[36658]={'602:45.72,23.49'}
G[36666]={'601[1]:45.37,14.82'}
G[36669]={'504[1]:40.00,58.09'}
G[36670]={'504[1]:70.05,31.44'}
G[36674]={'301:41.59,47.21'}
G[36676]={'181:67.08,20.53'}
G[36689]={'181:71.81,16.70 N:24848'}
G[36694]={'890:30.92,50.58 9:46.19,82.68>890'}
G[36728]={'181:14.34,65.02'}
G[36729]={'181:12.52,67.45 N:34693'}
G[36730]={'181:14.01,64.84'}
G[36743]={'545:26.44,46.91 N:35112','On top of tower'}
G[36744]={'181:29.38,57.61'}
G[36745]={'181:34.31,44.91'}
G[36746]={'181:29.11,57.94'}
G[36749]={'181:29.46,57.68'}
G[36752]={'181:29.52,66.84'}
G[36785]={'181:14.46,75.57 N:35817'}
G[36795]={'181:39.14,51.77'}
G[36799]={'301:27.37,24.15'}
G[36803]={'890:15.62,30.24 9:41.23,76.08>890'}
G[36894]={'181:34.53,44.68'}
G[36895]={'181:34.46,44.74'}
G[36903]={'181:14.47,65.71'}
G[36915]={'610:45.23,23.35'}
G[36918]={'181:10.55,69.85'}
G[36919]={'181:13.86,64.49 N:36596'}
G[36920]={'181:41.50,53.64'}
G[36921]={'181:41.39,53.93'}
G[36954]={'603[1]:76.92,78.98 N:25462'}
G[36955]={'603:37,10.2 603:41.2,13.9 603:10.9,27.2 603:11.1,29.3 603:11.3,28.1 603:11.5,28.2 603:13,24.2 603:13.2,22.8 603:13.3,22.6 603:13.4,22.3 603:13.6,22.2 603:13.6,22.5 603:13.7,22 603:14.4,21.1 603:14.9,20.7 603:15.2,20.4 603:15.5,20.2 603:15.9,19.4 603:16.7,18.6 603:16.7,19.8 603:17.8,19.4 603:18.4,19.6 603:18.5,18.6 603:19,19.9 603:20.2,20.4 603:20.8,20.8 603:22,21.7 603:22.5,22.3 603:23.1,22.8 603:23.6,23.4 603:24.2,23.9 603:24.6,24 603:24.7,24.5 603:25.7,25.1 603:25.7,25.7 603:26.6,26.9 603:27.1,27.5 603:27.4,25.1 603:27.4,25.8 603:27.6,26 603:28,25.4 603:30.8,29 603:32.6,30.5 603:39.5,34.7 603:39.8,33.1 603:40.5,34.3 603:41.1,34.7 603:48.7,42.8 603:49.6,44.2 603:50.7,44.1 603:51,44.7 603:76,77.5 603:76.1,76.3 603:76.2,76.9 603:76.3,77 603:76.6,76.8 603:76.7,77.6 603:77.6,79.5 N:4968'}
G[36956]={'181:58.10,52.31'}
G[36958]={'181:43.76,77.32'}
G[36959]={'181:60.61,50.53'}
G[36990]={'602:40.2,79.8 602:40.3,79.4 602:40.4,78.9 602:40.4,79.8 602:40.9,79.7 602:40.9,80.5 602:41,79.7 602:41.1,78.9 602:41.3,79.1 602:41.5,79.8 602:47.1,41.4 602:47.1,42.6 602:47.2,42.9 602:47.3,42.1 602:47.4,41.9 602:47.5,41.4 602:47.5,41.9 602:47.6,42.7 602:47.7,42 602:47.8,42.7 602:48.5,42.3 602:48.6,42.4 602:48.6,43.1 602:48.8,42.6 602:49.4,43.5 602:49.8,43.5 602:50,43 602:50.4,43.1 602:50.6,42.3 602:50.6,43 602:50.6,43.6 602:50.8,42.4 602:51,42.7 602:51.6,43 602:51.7,42.7 602:52,42.3 602:52.2,41.5 602:52.4,41.2 602:52.5,42.6 602:52.7,41.2 602:52.8,42 602:52.8,42.3 602:53.1,41.3 602:53.7,41.7 602:54.1,39.9 602:54.3,40.8 602:54.3,41.3 602:54.4,41.7 602:54.6,39.9 602:54.7,40.1 602:54.7,40.7 602:54.9,40.6 N:10181'}
G[36993]={'602:40.3,79.8 602:40.4,79.8 602:40.9,79.9 602:40.9,80 602:40.9,80.5 602:40.9,80.7 602:41.1,79.1 602:41.2,79.4 602:41.5,79.7 602:41.5,79.8 602:42,79 602:46.8,42.5 602:47.1,42.5 602:47.2,43.7 602:47.3,41.8 602:47.4,42.4 602:47.6,42.3 602:47.6,42.5 602:47.7,42.6 602:48.1,42.4 602:49,42.6 602:49.4,43 602:50,43.1 602:50,43.5 602:50.1,43 602:50.5,43.1 602:50.6,43.5 602:51.2,43.2 602:51.4,43.6 602:51.8,42.9 602:52,43 602:52.1,42.2 602:52.1,42.3 602:52.5,42.3 602:52.6,42.8 602:52.8,41.2 602:53,42.1 602:53.1,41.1 602:53.6,41.7 602:54.2,41.4 602:54.3,40.2 602:54.4,40.4 602:54.4,41 602:54.6,39.9 602:54.7,41 602:54.8,39.7 602:54.8,40.9 N:4968'}
G[36999]={'181:59.34,50.74'}
G[37009]={'181:60.56,51.01'}
G[37024]={'9:49.37,17.33'}
G[37061]={'181:66.35,20.26'}
G[37064]={'181:66.54,19.60'}
G[37065]={'545:51.81,80.49 N:34850'}
G[37081]={'866:67.14,41.30 27:36.87,70.05>866'}
G[37087]={'866:61.86,22.54 27:35.79,66.02>866'}
G[37102]={'545:59.86,91.71 N:34571'}
G[37106]={'605:48.76,57.65'}
G[37113]={'866:69.84,44.01 27:37.41,70.58>866'}
G[37115]={'866:61.18,13.80 27:35.7,64.6>866'}
G[37120]={'604:42.4,22.6 604:42.4,22.7 604:42.5,22.4 604:42.9,22.8 604:42.9,22.9 N:28444'}
G[37121]={'866:61.27,14.53 27:35.7,64.8>866'}
G[37135]={'607:31.41,13.33'}
G[37136]={'607:37.13,13.90','In tower'}
G[37137]={'607:37.53,17.00'}
G[37138]={'607:39.48,20.34'}
G[37142]={'181:52.98,49.77'}
G[37153]={'607:37.65,16.64'}
G[37154]={'607:39.63,19.89'}
G[37172]={'HA 321:50.79,75.25'}
G[37179]={'605:47.70,57.75'}
G[37195]={'545:68.71,73.25 N:35077'}
G[37221]={'603:39.1,13.9 603:40.3,71 603:41.3,72.2 603:41.4,73.4 603:41.6,72.3 603:42.1,72.9 603:42.2,74.5 603:42.4,73.9 603:43,74.4 603:43.1,75.5 603:43.4,75.4 603:43.6,75.4 603:43.7,75.4 603:44,75.7 603:44,76.6 603:44.8,76.2 603:44.8,76.3 603:45.1,76.8 603:45.2,76.9 603:45.5,77.9 N:4968'}
G[37223]={'603:38.9,70 603:40.4,70.8 603:41.5,73.1 603:41.9,74.2 603:42.1,74.7 603:42.3,74.4 603:42.5,73.3 603:42.5,74.2 603:42.7,74.2 603:42.7,75.1 603:43.1,74.8 603:43.2,75.7 603:43.5,75.3 603:43.7,75.2 603:44.3,76 603:44.3,76.1 603:44.4,76.6 603:44.8,76.4 603:44.9,76.4 603:44.9,76.5 603:45.1,77 603:45.2,77.5 603:45.5,77.2 603:45.6,77.3 603:45.6,77.5 603:45.7,78.1 N:10181'}
G[37515]={'607:44.33,33.29'}
G[37516]={'607:44.50,33.55'}
G[37527]={'499:44.4,45.4 499:44.4,45.5 499:44.5,45.4 499:44.5,45.5'}
G[37554]={'603:41.2,13.9 603:12.3,25 603:12.5,24.3 603:12.9,23.5 603:13.2,22.7 603:13.3,22.4 603:13.3,22.6 603:13.5,21.3 603:13.5,21.9 603:13.6,22 603:13.6,22.5 603:14.3,21.2 603:14.9,20 603:15,20.5 603:15.3,20.4 603:15.8,19.9 603:15.9,19.4 603:16.5,19.6 603:17.1,18.4 603:17.1,18.7 603:17.8,18.9 603:19.2,18.8 603:19.8,19.1 603:20.4,19.5 603:20.5,19.1 603:21,19.6 603:21.4,20.6 603:21.6,20.1 603:22.7,21.8 603:23.1,20.9 603:23.7,21.3 603:23.9,22.8 603:24.4,23.6 603:24.5,22.5 603:26.8,25.1 603:26.8,26.5 603:26.9,26.3 603:39.4,33.9 603:40,33.9 603:40.8,35.2 603:50.4,44.4 603:50.8,43.9 603:65.4,63.3 603:74.1,73.6 603:74.7,74.2 603:75.3,74.8 603:75.9,75.4 603:76.3,76.9 603:76.5,76 603:76.6,76.2 603:76.6,77.2 603:76.7,77.6 603:76.8,77.5 603:76.9,77.2 603:77.3,78.5 603:77.7,77.1 603:77.9,78.9 603:78.3,78.2 N:10181'}
G[37570]={'607:50.41,40.67'}
G[37582]={'601:41.1,9.4 601:41.1,9.7 601:41.2,10.1 601:41.4,8.4 601:41.4,9 601:41.5,8.5 601:41.5,10.2 601:41.6,8.6 601:41.8,9.6 601:44.4,12.2 601:63.9,90.2 601:63.9,90.7 601:64.2,90.4 601:64.3,90.5 602:40.9,80.5 602:41.1,79.6 602:41.2,79.1 602:41.3,79.1 602:41.4,80.2 602:41.5,80.2 602:41.6,80.1 602:43.9,25.8 602:44.1,25.1 602:44.2,23.2 602:44.2,23.8 602:44.2,26 602:44.2,26.7 602:44.3,25.2 602:44.5,23.1 602:44.5,23.7 602:44.5,25.4 602:44.5,25.5 602:44.8,24 602:45.2,19.9 602:45.8,19.6 602:46.4,19.4 602:47,19.1 602:47.4,19.1 602:47.6,18.9 602:48.2,18.4 602:48.3,18.4 602:48.4,18.8 602:48.6,18.4 602:48.6,18.7 602:54,39.5 602:54,40.2 602:54.1,40.5 602:54.6,39.9 602:54.9,39.5 603:29.9,57.2 603:30.1,57.7 603:30.2,57.8 603:30.3,57 603:30.4,58.5 603:30.4,58.7 603:30.7,57.1 603:30.8,57.1 603:30.8,57.9 603:31.2,57.7 603:31.3,58.8 603:33.1,61.9 603:39.5,73.6 603:39.8,74.5 603:40.1,72.5 603:40.2,72.2 603:40.2,73.6 603:40.4,73.2 603:40.5,72.1 603:40.5,72.5 603:40.7,72.8 603:40.8,71.8 603:41.3,74.4 603:41.5,72.7 603:41.7,72.9 603:42.2,73.5 603:42.3,73.8 603:42.4,75.3 603:42.5,73.8 603:42.6,74.2 603:42.7,75.2 603:43.3,75 603:43.4,75.5 603:43.9,75.3 603:44.1,75.7 603:44.3,76.2 603:44.3,76.7 603:44.9,76.3 603:44.9,76.9 603:45.2,77.9 603:45.3,76.8 603:45.5,77.3 603:45.6,77.4 603:46,79.1 603:46,79.3 603:46.6,79.3 603:46.9,79.9'}
G[37591]={'602:47,61.7 602:47.3,61.3 602:47.3,61.9 602:47.4,61.1 602:47.5,61.3 602:47.6,60.8 602:54.2,40.1 602:54.3,40 602:54.4,39.3 602:54.5,40.5 602:54.7,39.7 602:54.9,39.5 602:54.9,40.7 602:55.3,39.2 602:64.9,54.9 602:65,55.5 602:65.3,54.1 602:65.4,54.3 602:65.4,54.9 602:65.4,55.9 602:65.6,55 602:65.7,54.4 602:65.7,55 602:65.9,54.2 602:66,55.7 602:66.1,55.6'}
G[37592]={'602:40.9,80.5 602:41.4,79.4 602:46,63.5 602:46.4,62.7 602:46.9,61.5 602:47.3,61.7 602:47.4,61.1 602:47.4,61.3 602:47.5,60.2 602:47.5,61.1 602:47.8,61.5 602:47.8,61.9 602:48,61.1 602:54.2,40.2 602:54.3,40.1 602:54.4,40.6 602:54.5,40.5 602:54.5,40.6 602:54.7,39.9 602:54.7,40 602:65,54.9 602:65.1,54.4 602:65.1,55 602:65.1,55.5 602:65.2,54.3 602:65.6,55.1 602:65.7,54.1 602:65.8,54.2 602:65.8,55 602:65.9,55.8 602:66.1,55.5'}
G[37596]={'601:63.9,90.3 601:64.1,90.9 601:64.5,90.5 N:10181'}
G[37597]={'601:63.8,90.2 601:63.9,90.1 601:64.1,90.8 601:64.6,90.4 601:64.6,90.5 N:4968'}
G[37602]={'605:59.62,76.48'}
G[37675]={'HA 381:42,52 471:73,56 341:33,66 301:62.41,75.37'}
G[37679]={'607:41.49,46.81'}
G[37717]={'607:41.49,46.59'}
G[37724]={'9:45,75.3'}
G[37737]={'9:45,75.4'}
G[37776]={'504[1]:44.68,71.89 504[1]:46.43,60.97'}
G[37779]={'601:40.8,11.2 601:40.9,10.9 601:41.4,10.1 601:41.4,10.4 601:41.5,10.7 601:41.6,10.2 601:41.8,9.9 601:41.8,10.7 601:44.3,14.5 601:63.8,90.3 601:63.9,90.3 601:64,90.6 601:64.4,90.7 601:64.5,90.4 601:64.7,90.7 602:40.4,79.4 602:40.4,80.3 602:40.9,80.1 602:40.9,80.5 602:41,79.2 602:41,79.3 602:41,80 602:41.5,79.8 602:41.5,80.3 602:43.6,25.4 602:44,26 602:44,26.6 602:44.2,25.8 602:44.3,20.8 602:44.3,23.6 602:44.4,25.4 602:44.5,25.6 602:44.5,26.7 602:44.7,20.4 602:44.8,23.2 602:44.9,20.5 602:45.9,20.1 602:47,19.1 602:47.9,18.9 602:48,19.3 602:48.1,18.4 602:48.3,18.4 602:48.6,18.7 602:53.9,39.7 602:54.7,39.8 602:54.8,39.4 603:29.8,57 603:30.1,57.8 603:30.1,58.6 603:30.3,57.2 603:30.3,58.1 603:30.4,58.6 603:30.5,57.1 603:30.6,57.4 603:30.9,57.8 603:31.3,58.3 603:31.3,58.6 603:31.3,59.1 603:33,60.3 603:33.4,60.9 603:39.5,73.1 603:39.5,73.5 603:39.5,73.6 603:40,72.2 603:40,72.8 603:40.7,71.7 603:40.7,73.5 603:40.8,72.9 603:41,73.6 603:41.2,72.8 603:41.3,72.4 603:41.5,72.4 603:41.5,73.6 603:41.6,73 603:41.8,73.1 603:42.8,74 603:43.2,75.6 603:43.4,74.7 603:43.5,75.4 603:43.5,75.5 603:44.4,76.6 603:44.7,77.2 603:45,77 603:45.1,77.6 603:45.2,78.4 603:45.9,78.3 603:45.9,79 603:46,79.6 603:46.4,79.2 603:47.1,79.5 603:47.2,80 603:47.3,81.6 603:47.7,80.7'}
G[37780]={'504[1]:52.31,22.96 504[1]:53.58,37.05 504[1]:50.14,32.54 504[1]:50.79,18.43'}
G[37783]={'545:70.88,39.83 N:35378'}
G[37803]={'545:70.76,39.94'}
G[37811]={'607:41.64,69.82'}
G[37812]={'607:45.15,85.43'}
G[37815]={'545:60.25,91.85 N:35378'}
G[37822]={'545:63.34,82.91'}
G[37834]={'607:45.09,85.32'}
G[37835]={'607:45.1,85.3'}
G[37837]={'607:41.64,69.81 N:37679'}
G[37847]={'607:44.51,88.09 N:3432'}
G[37873]={'545:69.31,72.97'}
G[37874]={'545:72.72,80.08 N:36132'}
G[37876]={'545:78.28,72.04 N:35112'}
G[37887]={'HA 301:62.52,74.96'}
G[37888]={'23:10.09,65.67'}
G[37908]={'607:42.61,70.22'}
G[37909]={'607:41.10,71.00'}
G[37910]={'607:41.64,69.42'}
G[37915]={'20:83.57,69.95'}
G[37951]={'891:42.82,53.45 4:62.46,84.45>891'}
G[37969]={'891:45.10,85.31 4:63.24,95.34>891'}	-- 891:45.58,85.12 moves about a bit
G[37987]={'891:45.72,85.01 4:45.75,85.01>891'}
G[38005]={'891:56.83,63.69 4:67.24,87.95>891'}
G[38037]={'891:52.55,53.70 4:65.78,84.54>891'}
G[38039]={'HA 381:45.41,57.75 N:37887'}
G[38040]={'HA 471:73.66,57.00 N:37887'}
G[38041]={'HA 341:33.57,65.59 N:37887'}
G[38042]={'HA 321[1]:53.00,76.83 N:37887'}
G[38043]={'HA 480:64.43,66.51 N:37887'}
G[38044]={'HA 362:44.00,52.67 N:37887'}
G[38045]={'HA 382:66.55,38.60 N:37887'}
G[38066]={'HA 301:61.50,75.29'}
G[38113]={'603[1]:36.48,66.89'}
G[38120]={'544:45.34,65.20 N:36379'}
G[38122]={'544:45.25,64.86 N:34673'}
G[38124]={'544:45.27,65.56 N:36077'}
G[38140]={'607:50.74,86.82','Inside fortress dressed as cheese'}
G[38143]={'545:70.66,39.71'}
G[38144]={'545:49.83,56.92 N:36132'}
G[38149]={'545:41.94,37.60 N:35077'}
G[38152]={'607:50.3,87.1 N:38140'}
G[38160]={'601:41.9,12.8 601:42.4,13.8 601:42.7,14.6 601:43.2,13.5 601:43.3,11.9 601:43.3,13.4 601:43.3,14.7 601:43.4,12.4 601:43.4,12.9 601:43.4,13.7 601:43.5,11.8 601:43.6,12.1 601:43.8,13.7 601:43.9,13.2 601:43.9,13.3 601:44,11.3 601:44,15.8 601:44.1,11.1 601:44.1,13.9 601:44.4,14.5 601:44.4,14.8 601:44.5,11.4 601:44.5,11.9 601:44.5,12.9 601:44.6,11.4 601:44.6,14.8 601:44.7,12.4 601:44.7,13.4 601:44.8,14.1 601:44.9,14.6 601:45,15.7 601:45.2,14.1 601:45.4,15.5 601:45.5,12.3 601:45.5,13.6 601:45.5,14.1 601:45.6,13.1 601:45.6,15.2 601:45.7,13 601:45.7,15.1 601:46.1,15.7 601:46.2,15.7 601:48.8,20 601:48.9,19.4 N:4968'}
G[38161]={'601:43.1,13.5 601:43.3,12.4 601:43.4,10 601:43.4,12.3 601:43.4,12.5 601:43.4,12.8 601:43.4,13.6 601:43.4,14.7 601:43.5,13.2 601:43.7,13.4 601:43.7,15.7 601:43.8,11.2 601:43.8,14.2 601:44,15.5 601:44.1,12.1 601:44.1,13.6 601:44.2,11.3 601:44.2,11.9 601:44.2,14.5 601:44.4,14.5 601:44.5,11.4 601:44.5,12.2 601:44.5,12.4 601:44.7,12.5 601:44.8,15.7 601:45,14.7 601:45.1,13 601:45.2,14 601:45.3,14.7 601:45.3,15.5 601:45.4,13.5 601:45.5,12.7 601:45.5,14.9 601:45.5,15.5 601:45.6,14.1 601:45.6,14.4 601:45.7,12.4 601:45.7,13.4 601:45.8,14.9 601:45.9,15.5 601:46.5,15.3 N:10181'}
G[38188]={'602:39.2,15.6 602:39.2,16.5 602:39.3,15.4 602:39.3,15.7 602:39.4,15.4 602:39.4,16.5 602:39.5,15.2 602:39.7,16.2 602:39.7,16.3 602:39.8,15.3 602:40.1,16.8 602:40.1,16.9 602:40.4,17.6 602:40.5,17.3 602:40.5,17.4 602:40.8,17.8 602:41,18.1 602:41.3,18.5 602:41.4,18.7 602:41.6,18.3 602:41.6,18.4 602:41.7,19 602:41.7,19.6 602:41.9,19.3 602:42.3,19.9 602:42.5,19.4 602:42.9,20.3 602:43,19.5 602:43.2,20.9 602:43.4,20.5 602:43.5,20.5 602:43.8,21.2 602:44.2,19.8 602:44.2,21.5 602:44.4,20.3 602:44.8,20.2 602:44.9,21.7 602:45,20.3 602:45.1,20.6 602:45.2,20.7 602:45.2,21.5 602:45.6,20.5 602:45.9,19.4 602:46,19.4 602:46,20.2 602:46.4,20 602:46.6,20.5 602:46.7,20.7 602:47.2,19.4 602:47.2,19.6 602:47.4,19.3 602:47.5,19.5 602:47.8,19.2 602:48.2,18.4 602:48.2,18.9 602:48.4,18.4 602:48.5,19.1 602:48.6,18.9 602:48.7,18.3 N:4968'}
G[38189]={'602:39.1,15.5 602:39.2,15.6 602:39.5,16.4 602:39.7,16.2 602:40.1,16.7 602:40.5,17.3 602:40.5,17.6 602:41.2,18.4 602:41.5,18.6 602:41.9,19.5 602:42,19 602:43.3,20.2 602:43.3,20.3 602:43.4,20.5 602:43.6,19.9 602:43.9,20.1 602:44.1,20.8 602:44.5,20.5 602:45.1,20.2 602:45.1,20.4 602:45.7,19.9 602:45.8,19.8 602:46.9,19.5 602:47.2,19.3 602:47.3,19.4 602:47.3,19.5 602:47.5,19.3 602:47.5,19.5 602:47.5,19.6 602:48.3,18.4 602:48.4,19 602:48.9,18.6 N:10181'}
G[38237]={'201:30.62,51.15'}
G[38242]={'891:50.07,52.74 4:64.94,84.21>891'}
G[38243]={'891:58.06,54.04 4:67.67,84.66>891'}
G[38244]={'891:52.88,49.92 4:65.90,83.25>891'}
G[38245]={'891:58.05,49.25 4:67.66,83.02>891'}
G[38246]={'891:59.69,52.06 4:68.22,83.68>891'}
G[38247]={'891:56.39,50.09 4:67.10,83.31>891'}
G[38255]={'Near201 N:38237'}
G[38263]={'201:76.43,48.34'}
G[38269]={'201:55.72,60.60'}
G[38270]={'201:55.05,60.56'}
G[38274]={'201:71.01,76.60'} -- 201:71.00,76.62 201:70.08,77.47 201:70.47,76.78 201:70.90,75.65
G[38275]={'201:43.2,41.6 201:43.3,41'}
G[38276]={'201:43.2,41.7 201:43.3,41'}
G[38277]={'201:43.2,41.7 201:43.3,41'}
G[38293]={'HA 341:35.35,68.98 381:45.05,56.42 471:76.00,57.74'}
G[38294]={'HK 504[1]:52.42,66.41'}
G[38295]={'HA 480:64.42,70.31 382:64.30,37.55 362:44.22,55.86'}
G[38314]={'607:50.30,40.40'}
G[38316]={'604:39.4,21.6 604:40.1,21.4 604:40.1,21.5'}
G[38323]={'607:49.9,49.6'}
G[38325]={'HA 301:60.61,76.36','In inn, upstairs'}
G[38328]={'HA 321[1]:57.59,60.82'}
G[38343]={'Near201 N:38237'}
G[38378]={'607:29.8,9'}
G[38379]={'607:38.79,11.39'}
G[38380]={'607:35,9.5'}
G[38381]={'544:52.20,73.23'}
G[38383]={'607:39.06,11.44'}
G[38387]={'544:45.17,64.90 N:34668'}
G[38432]={'544:52.20,73.14 N:34874'}
G[38440]={'891:58.95,66.87'}
G[38441]={'544:54.16,17.20'}
G[38442]={'891:58.90,23.09 4:58.91.23.08>891'}
G[38502]={'201:83.50,46.00'}
G[38504]={'201:53.83,62.50'}
G[38517]={'544:53.72,34.93 N:34693'}
G[38534]={'161:51.24,29.96 N:34874'}
G[38535]={'161:51.21,29.92'}
G[38539]={'611:32.38,57.01 N:35112'}
G[38578]={'161:40.25,77.17'}
G[38606]={'604:38.4,20.1 604:38.4,20.7 604:39,20.1 604:39,20.5 604:39,21 604:39.1,20.4 604:39.4,21.5 604:39.7,20.4 604:39.7,20.9 N:4968'}
G[38607]={'604:39,20.7 604:39.3,20.6 604:39.4,20.2 604:39.4,20.3 604:39.4,21.5 604:39.9,20.8'}
G[38608]={'604:39,18.6'}
G[38609]={'604:38.4,20 N:10181'}
G[38611]={'611:38.60,60.22 N:35378'}
G[38619]={'607:69.26,49.09'}
G[38620]={'607:67,46.6'}
G[38621]={'607:64.9,46.1'}
G[38622]={'607:74.00,47.50'}
G[38623]={'607:71,50'}
G[38647]={'544:56.56,71.95'}
G[38703]={'161:71.86,45.42 N:34874'}
G[38704]={'161:72.20,45.22 N:38535'}
G[38706]={'161:55.65,60.86'}
G[38738]={'544:51.79,47.10 N:37106'}
G[38801]={'607:66.97,46.59'}
G[38804]={'607:66.9,46.7'}
G[38849]={'161:44.59,52.66 N:34874'}
G[38871]={'607:56.1,42.7'}
G[38873]={'607:56.2,42.6'}
G[38876]={'607:56.2,42.7'}
G[38878]={'607:61.9,42.1'}
G[38911]={'892:49.20,56.32 20:31.45,65.60>892'}
G[38912]={'607:56.2,42.7'}
G[38917]={'606:48.43,18.97'}
G[38922]={'161:33.27,77.02'}
G[38925]={'20:44.74,53.65'}
G[38927]={'161:42.30,23.84'}
G[38928]={'544:72.86,57.04 N:34668'}
G[38935]={'544:36.79,43.13 N:4949'}
G[38966]={'891:61.55,65.85 4:61.58,65.88>891'}
G[38977]={'20:61.64,34.56'}
G[38978]={'20:61.60,34.39'}
G[38986]={'607:50,49.5'}
G[39003]={'607:49.8,50.4 607:49.8,50.5'}
G[39007]={'891:60.53,62.88 4:68.51,87.67>891'}
G[39034]={'161:51.79,28.06'}
G[39059]={'161:50.02,82.91 N:38535'}
G[39065]={'544:36.27,43.36 N:35875'}
G[39066]={'544:33.79,38.79 N:35893'}
G[39083]={'607:49.1,66.9'}
G[39084]={'607:49.4,67.5 607:49.5,67.5'}
G[39085]={'607:49.2,67.8'}
G[39116]={'382:49.49,29.65'}
G[39118]={'607:43.5,78.3'}
G[39144]={'141:35.49,30.08'}
G[39154]={'607:43.46,78.23'}
G[39155]={'607:47.2,88.5'}
G[39175]={'201:44.11,40.28'}
G[39178]={'161:52.25,28.07'}
G[39188]={'607:49.3,86.7 N:39155'}
G[39199]={'Near544 N:36077'}
G[39206]={'889:42.11,69.51 4:42.51,69.04>889'}
G[39210]={'607:38.93,10.88'}
G[39211]={'607:49.20,67.80'}
G[39212]={'607:66.38,47.13'}
G[39214]={'889:43.39,70.65 4:42.84,69.34>889'}
G[39218]={'607:49.4,86.9'}
G[39220]={'607:49.6,87.1'}
G[39226]={'615:56.02,13.69'}
G[39256]={'81:71.8,45.4 81:71.8,45.6'}
G[39270]={'4:57.91,45.13'}
G[39322]={'607:68.6,49'}
G[39323]={'4:49.59,40.17','On top of tower'}
G[39324]={'4:35.85,41.37'}
G[39325]={'4:40.49,35.36'}
G[39326]={'4:42.70,49.91'}
G[39341]={'544:56.30,27.32'}
G[39376]={'544:51.37,13.12'}
G[39377]={'121:41.4,15.4 121:41.4,15.5'}
G[39379]={'4:45.00,14.78'}
G[39380]={'4:44.90,14.82'}
G[39406]={'606:90.15,56.38'}
G[39407]={'121:81.54,42.44'}
G[39413]={'606:89.58,59.09'}
G[39423]={'4:53.10,43.14'}
G[39427]={'606:35.75,19.67'}
G[39429]={'606:35.69,19.43'}
G[39432]={'606:28.4,30 606:28.5,29.9 606:30.1,31.7'}
G[39433]={'606:30.12,31.29'}
G[39434]={'606:28.17,29.88'}
G[39435]={'606:28.62,30.20 606:28.29,29.98'}
G[39442]={'606:76.94,62.04'}
G[39451]={'606:77.05,62.15'}
G[39509]={'604:40.1,21.4 604:40.1,21.5 604:40.1,21.7 604:40.7,21.1 604:40.7,21.3'}
G[39590]={'4:58.82,23.16'}
G[39604]={'4:56.31,20.27'}
G[39605]={'321[1]:48.11,70.48 N:25237'}
G[39609]={'4:57.65,9.77'}
G[39621]={'606:71.92,58.07'}
G[39622]={''}
G[39627]={'606:32.35,37.16'}
G[39638]={'615:42,68'}
G[39640]={'606:27.25,40.80',"Inside cave Gar'gol's Hovel"}
G[39642]={'606:27.21,35.19'}
G[39643]={'606:27.17,35.22'}
G[39646]={'606:25.80,41.64'}
G[39653]={'121:56.88,54.96'}
G[39656]={'121:51.9,48.1'}
G[39665]={'753[1]:48.01,72.21'}
G[39667]={'610:53.44,43.02'}
G[39679]={'753[1]:0.00,0.00'}
G[39697]={'607:49.22,82.33'}
G[39723]={'121:32.61,45.66'}
G[39725]={'121:77.23,56.48'}
G[39738]={'606:25.83,41.68'}
G[39840]={'121:51.9,46.6'}
G[39847]={'121:74.6,42.9'}
G[39857]={'606:47.73,35.51 N:33091'}
G[39858]={'606:27.11,62.65 N:5769'}
G[39865]={'241:45.47,44.84'}
G[39869]={'606:47.65,35.51'}
G[39875]={'615:49.24,42.57'}
G[39876]={'615:49.42,42.71 615:49.58,42.13'}
G[39877]={'615:55.54,12.53'}
G[39878]={'615:49.13,41.96'}
G[39881]={'615:49.02,57.02 615:49.41,57.46 615:49.45,57.50 615:49.56,57.41 615:49.46,57.59'}
G[39882]={'615:41.29,34.23'}
G[39883]={'610:57.12,28.78 N:39667'}
G[39884]={'610:57.34,28.90'}
G[39887]={'610:44.73,22.58'}
G[39893]={'121:74.6,42.9'}
G[39894]={'121:52.2,48.1'}
G[39895]={'61:11.13,11.22'}
G[39896]={'121:55.6,57'}
G[39908]={'759[1]:56.16,44.02 N:28070'}
G[39918]={'610:49,42'}
G[39925]={'606:64.01,22.65'}
G[39927]={'606:18.98,40.94'}
G[39928]={'606:19.03,37.01'}
G[39930]={'606:19.22,37.89'}
G[39932]={'606:13.65,32.79'}
G[39933]={'606:22.26,44.92'}
G[39946]={'121:86.07,45.28'}
G[39963]={'61:10.55,8.53'}
G[39992]={'121:88.46,44.44'}
G[40027]={'61:75.90,74.61'}
G[40028]={'61:75.93,74.69'}
G[40032]={'121:50.69,17.15'}
G[40035]={'121:51.15,17.84'}
G[40052]={'121:56.96,55.38'}
G[40078]={'121:57.08,53.79'}
G[40082]={'61:90.07,53.01'}
G[40093]={'Near606'}
G[40096]={'606:44.50,18.86'}
G[40105]={'610:46.33,46.92 N:36915'}
G[40109]={'161:40.12,76.97'}
G[40129]={'121:65.88,62.86'}
G[40131]={'121:65.94,62.83'}
G[40132]={'121:57.24,54.98'}
G[40139]={'606:56.76,18.83','In Hyjal Barrow Dens'}
G[40172]={'606:22.21,44.91 N:81280'}
G[40178]={'606:52.13,17.42 N:38917'}
G[40221]={'615:64.07,42.29 N:39877'}
G[40224]={'121:53.2,31.8 N:5296'}
G[40226]={'121:45.34,41.26'}
G[40227]={'615:41.13,34.26'}
G[40276]={'610:52,40'}
G[40278]={'606:64.06,22.49'}
G[40289]={'606:62.05,24.92'}
G[40331]={'606:27.06,63.01'}
G[40341]={'606:24.66,55.68'}
G[40344]={'141:41.87,73.88'}
G[40345]={'141:41.82,73.92'}
G[40358]={'141:42.82,72.43'}
G[40367]={'121:77.31,56.79'}
G[40369]={'121:77.2,56.5'}
G[40398]={'614:72.89,37.35'}	-- this technically could be Near
G[40429]={'609:68.1,55.2 609:68.3,54.3 609:68.3,54.5 609:68.3,55.7 609:68.3,56.2 609:68.4,54.1 609:68.4,54.2 609:68.4,55.1 609:68.4,55.4 609:68.4,55.7 609:68.4,55.8 609:68.4,56.6 609:68.5,56.7 609:68.6,54.1 609:68.6,55.3 609:68.6,56.5 609:68.6,56.7 609:68.7,53.7 609:68.7,57 609:68.8,54.4 609:68.8,55.8 609:68.9,55 609:68.9,55.6 609:69,55.6 609:69.1,54.2 609:69.1,54.9 609:69.1,55.7 609:69.2,55 609:69.3,53.4 609:69.5,54.2 609:69.5,55.1 609:69.6,55 609:69.6,55.7 609:69.6,55.8 609:70,55.3 609:70.2,55.3 609:70.2,55.6 609:70.5,55 609:70.6,54.9 609:70.6,55.2 609:70.6,56.3 609:70.7,54.1 609:70.7,55.1 609:71,55.6 609:71.5,54.9 609:72,55.1 609:72.6,55.1 609:74,54.6 609:74.1,53.4 609:74.2,54'}
G[40475]={'61:76.49,73.63'}
G[40487]={'61:77.19,74.50'}
G[40510]={'615:67.2,49.6'}
G[40552]={'381:36.61,47.85'}
G[40553]={'41:55.47,50.42'}
G[40554]={'61:77.98,73.32'}
G[40556]={'61:78.10,73.70'}
G[40578]={'606:37.22,56.18'}
G[40580]={'161:42.49,24.27'}
G[40589]={'161:52.56,29.05'}
G[40591]={'61:78.07,73.10'}
G[40595]={'61:78.23,73.64'}
G[40619]={'606:95.35,51.32'}
G[40639]={'615:48.99,49.20'}
G[40640]={'615:39.42,58.97'}
G[40641]={'615:48.99,49.12'}
G[40642]={'615:49.16,56.99 N:39887'}
G[40643]={'615:49.18,56.95'}
G[40644]={'615:49.69,57.15'}
G[40645]={'615:56.98,80.55'}
G[40690]={'610:45.02,23.52 N:39887'}
G[40707]={''}
G[40712]={'686:56.75,89.18 161:39.22,21.34>686'}
G[40720]={'606:37.26,56.17'}
G[40726]={'61:78.12,73.09'}
G[40727]={'61:78.26,73.60'}
G[40737]={'610:44.4,24.8 N:39887'}
G[40768]={'61:79.14,71.94'}
G[40772]={'606:72.22,74.69 N:40619'}
G[40773]={'606:71.92,74.09'}
G[40788]={'767[2]:0.00,0.00'}
G[40809]={'9:47.44,58.64'}
G[40816]={'606:72.23,73.94'}
G[40825]={'N:36915'}
G[40827]={'161:40.05,77.54'}
G[40833]={'606:63.25,21.52'}
G[40834]={'606:26.25,41.91'}
G[40837]={'606:26.31,41.95'}
G[40851]={'615:49.52,41.22 N:43287'}
G[40852]={'610:56.12,31.13 N:43287'}
G[40855]={'610:45.2,19.7 K:27729'}
G[40866]={'614:56.90,75.53 N:43287'}
G[40867]={'615:48.55,57.43 N:43287'}
G[40871]={'615:51.41,62.43 N:43287'}
G[40879]={'81:72.5,61.4 81:72.5,61.5'}
G[40881]={'81:70.8,62.9'}
G[40885]={'61:91.63,78.55'}
G[40888]={'61:91.68,79.33'}
G[40894]={'43:35.3,71.2'}
G[40895]={'43:35.4,71.2'}
G[40896]={'81:59.5,56.9'}
G[40897]={'81:59.46,56.97'}
G[40898]={'81:58.97,56.36'}
G[40899]={'81:58.7,56'}
G[40900]={'81:58.7,56'}
G[40901]={'81:73.29,56.61'}
G[40902]={'81:66.23,62.93'}
G[40903]={'81:65.76,63.31'}
G[40905]={'81:72.2,62'}
G[40907]={'81:66.06,64.23'}
G[40908]={'81:58.5,55.3'}
G[40913]={'121:76.97,56.63'}
G[40916]={'615:39.1,78.6 615:39.7,54 615:51.2,63'}
G[40917]={'615:39.1,78.6 615:39.6,54 615:51.2,63'}
G[40918]={'615:39.5,54.7 615:51.7,62.5 615:53.9,67.1'}
G[40919]={'615:29.5,78.9 615:39.1,78.6 615:40.6,75.1 615:51.6,62.7'}
G[40920]={'615:39.6,53.8 615:51.3,62.4 615:51.3,62.5'}
G[40921]={'615:50.3,79'}
G[40926]={'81:74.44,47.66 N:35893'}
G[40950]={'27:53.71,52.19'}
G[40951]={'27:53.70,52.10'}
G[40966]={'121:50.21,16.72'}
G[40973]={'81:72.5,61.4 81:72.5,61.5'}
G[40978]={'615:40.56,75.28'}
G[40983]={'610:57.30,29.29 N:26604'}
G[40987]={'610:54,50'}
G[40997]={'606:43.54,45.88','On top floor'}
G[41003]={'606:44.1,46'}
G[41005]={'606:44.44,46.23'}
G[41006]={'606:42.18,45.46'}
G[41017]={'610:53.8,52.6'}
G[41023]={'81:66.13,63.70'}
G[41049]={'615:36.43,78.68 N:40510'}
G[41050]={'615:38.99,58.60'}
G[41054]={'81:58.8,56'}
G[41058]={'61:91.68,78.81 61:91.67,79.17'} -- first for Alliance, second for Horde
G[41060]={'61:96.83,72.47'}
G[41068]={'606:40.35,44.32'}
G[41071]={'81:66.2,54.6'}
G[41074]={'40:49.89,79.24'}
G[41075]={'40:49.94,79.16'}
G[41086]={'40:57.50,71.76'}
G[41124]={'19:40.4,11.7 19:40.5,11.7'}
G[41125]={'19:42.6,13.9'}
G[41128]={'40:57.84,71.50'}
G[41129]={'40:57.47,71.43'}
G[41133]={'19:59.4,3.2 19:59.5,3.4 19:59.5,3.5'}
G[41134]={'19:53.1,80.3 19:62.2,1.4 19:62.2,1.5'}
G[41140]={'4:53.09,43.58'}
G[41159]={'19:54.3,50 19:54.4,50.5'}
G[41167]={'40:47.58,65.48'}
G[41183]={'610:51.6,52'}
G[41184]={'61:88.57,54.86'}
G[41190]={'61:91.39,57.78'}
G[41204]={'61:91.31,53.84'}
G[41205]={'61:86.75,51.58'}
G[41214]={'161:55.88,60.60'}
G[41215]={'161:33.30,77.35'}
G[41227]={'615:37,83'}
G[41229]={'81:71,79.7'}
G[41233]={'81:48.4,51.8'}
G[41238]={'40:57.46,71.63'}
G[41239]={'477:60.4,24 477:60.5,24 N:4949'}
G[41240]={'81:48.64,51.52'}
G[41248]={'610:46.05,46.85'}
G[41252]={'610:46.62,46.73'}
G[41263]={'477:60.4,23.9 477:60.5,23.8'}
G[41265]={'19:73.18,47.44'}
G[41276]={'81:72.1,76'}
G[41277]={'81:72.1,76'}
G[41278]={'81:70.9,79.7 N:17246'}
G[41282]={'81:72.1,76'}
G[41297]={'40:11.09,57.78'}
G[41298]={'27:62.51,53.70'}
G[41307]={'40:15.23,29.38'}
G[41308]={'606:44.34,47.98'}
G[41321]={'40:56.87,71.11'}
G[41322]={'40:56.32,41.85'}
G[41323]={'40:38.6,39'}
G[41324]={'610:63.98,59.80'}
G[41325]={'40:49.90,18.56'}
G[41332]={'35:81.88,64.08'}
G[41340]={'610:63.98,59.80 N:41324'}
G[41341]={'610:63.86,59.94 N:36915'}
G[41344]={'610:64.21,59.89 N:41252'}
G[41347]={'610:63.89,59.39 N:41248'}
G[41350]={'81:72.7,81.1'}
G[41354]={'19:71.05,60.14'}
G[41363]={'27:56.83,47.10'}
G[41381]={'606:27.40,55.63'}
G[41383]={'121:46.77,45.35'}
G[41392]={'61:46.40,57.89'}
G[41402]={'19:60.63,62.96 19:61.59,63.11 19:62.93,64.23'}
G[41411]={'40:38.93,39.35'}
G[41412]={'40:38.63,39.51'}
G[41413]={'40:38.8,39.7'}
G[41415]={'40:26.93,26.08'}
G[41421]={'61:46.81,55.95'}
G[41426]={'40:13.68,38.18'}
G[41428]={'40:14.40,23.92'}
G[41433]={'40:26.77,26.73'}
G[41434]={'81:53.5,42.5 81:53.6,42.4'}
G[41435]={'40:26.82,25.88'}
G[41441]={'81:48.4,51.9 81:48.5,51.9'}
G[41444]={'61:46.8,56.1'}
G[41446]={'61:46.36,57.79'}
G[41456]={'615:33.11,77.89'}
G[41457]={'615:57.16,85.20'}
G[41476]={'615:46.36,78.58'}
G[41480]={'606:19.54,37.78 N:5769'}
G[41482]={'81:39.97,33.55'}
G[41486]={'81:39.6,30.8'}
G[41487]={'81:33.1,59.6'}
G[41488]={'81:39.6,30.8'}
G[41492]={'606:57.12,55.95'}
G[41497]={'606:56.84,56.02'}
G[41498]={'606:64.27,53.60'}
G[41503]={'40:56.39,40.47'}
G[41504]={'606:41.88,60.79 N:40341'}
G[41507]={'606:42.24,60.57'}
G[41530]={'610:60,80.8 610:60,81.5 610:60.1,80.4 610:60.5,80.9'}
G[41531]={'615:51.63,52.22 N:39875'}
G[41535]={'615:56.93,80.49 N:40639'}
G[41540]={'615:62.67,49.88 N:39887'}
G[41541]={'615:62.71,49.94 N:40643'}
G[41578]={'27:70.41,48.92'}
G[41580]={'121:57.08,53.95'}
G[41598]={'614:42.76,37.95 N:39887'}
G[41600]={'614:42.69,37.91 N:36915'}
G[41612]={'40:56.36,39.83'}
G[41615]={'40:56.42,39.92'}
G[41618]={'610:38.75,31.71 N:36915'}
G[41621]={'4:55.89,12.32'}
G[41636]={'614:42.7,37.8 N:40917'}
G[41638]={'81:32.3,60.5 81:32.4,60 81:32.7,61 81:33.1,59.6'}
G[41639]={'614:42.73,37.92 N:40919'}
G[41640]={'614:52.60,27.82 N:39881'}
G[41652]={'614:31.6,59.2'}
G[41657]={'614:30,59'}
G[41662]={'614:54.44,72.91'}
G[41663]={'614:51.4,61.4 614:51.4,61.5 614:51.5,61.4 614:51.5,61.5'}
G[41664]={'81:33.1,59.6'}
G[41665]={'614:55.61,72.99 N:40645'}
G[41666]={'614:55.50,72.90 N:40639'}
G[41667]={'614:55.46,72.97'}
G[41668]={'614:51.5,60.8 N:40921'}
G[41669]={'614:51.4,60.9 614:51.5,60.9 N:40918'}
G[41670]={'614:51.4,60.9 614:51.5,60.9'}
G[41678]={'43:49.87,65.76'}
G[41711]={'610:39,32 N:40917'}
G[41750]={'610:38.9,31.7 610:39.5,31.3 N:40917'}
G[41769]={'610:39.4,30.7 610:39.5,30.7 610:39.6,30.3 N:40917'}
G[41770]={'615:50.3,79 N:40918'}
G[41786]={'27:82.86,48.40'}
G[41802]={'615:62.60,49.56 615:62.69,50.53 N:39881'}
G[41804]={'27:82.64,48.29'}
G[41810]={'615:60.2,63.6 N:40917'}
G[41811]={'615:60.2,63.7 N:40916'}
G[41813]={'615:60.2,63.6 615:60.3,63.4 615:60.5,63.4 615:60.5,63.5 N:40919'}
G[41853]={'27:78.25,20.51'}
G[41861]={'606:62.14,21.59'}
G[41863]={'610:63.9,59.9'}
G[41885]={'610:63.9,59.8 N:41863'}
G[41908]={'614:42.9,51'}
G[41910]={'614:47.36,49.76'}
G[41925]={'614:46,60'}
G[41926]={'614:46,60'}
G[41937]={'81:62,67.8'}
G[41944]={'16:12.94,36.16'}
G[41949]={'16:13.36,35.95'}
G[41966]={'16:13.35,34.18'}
G[41983]={'16:13.06,69.23'}
G[41990]={'81:67.10,64.55','In cave'}
G[41991]={'81:67.14,64.50','In cave'}
G[41992]={'81:67.17,64.46','In cave'}
G[42023]={'81:71.1,91.2'}
G[42028]={'81:65.86,64.14'}
G[42033]={'81:52.95,39.14'}
G[42039]={'81:45.04,32.76'}
G[42047]={'81:45.02,32.82'}
G[42050]={'81:45.12,32.77'}
G[42074]={'615:46.22,79.56 N:40978'}
G[42076]={'615:29.02,78.51 N:40640'}
G[42077]={'615:33.13,75.87 N:40640'}
G[42088]={'16:12.82,34.08'}
G[42091]={'81:39.69,46.41','Top of tree'}
G[42106]={'81:45.60,34.15 N:41023'}
G[42114]={'614:55,46 K:26124'}
G[42115]={'614:57,74 K:26105'}
G[42129]={'341:39.74,57.25'} -- 341:39.80,57.30
G[42130]={'16:67.72,34.80'}
G[42140]={'40:13.93,34.96'}
G[42160]={'40:49.44,17.21'}
G[42170]={'27:87.68,50.20'}
G[42197]={'614:38.75,44.82'}
G[42224]={'27:38.9,33.4 27:39.2,33.9 27:39.5,34.2 27:39.8,32.1 27:39.9,31.2 27:39.9,33.3 27:40.6,33 27:40.9,31.7 27:41.2,30.6'}
G[42256]={'30:81.85,66.05'}
G[42262]={'19:60.20,13.39'}
G[42264]={'19:60.47,13.82'}
G[42288]={'301:50.56,71.87'}
G[42298]={'19:62.25,26.32'}
G[42299]={'19:55.12,49.58'}
G[42308]={'39:60.05,19.28'}
G[42317]={'895:38.71,32.82 27:33.63,36.45>895'}
G[42323]={'27:33.89,34.78>895 895:39.41,28.39'}
G[42324]={'27:34.28,37.51>895 895:40.68,35.73'}
G[42331]={'27:34.53,35.06>895 895:41.09,29.14'}
G[42333]={'768[1]:54.06,38.61'}
G[42334]={'19:34.68,67.80'}
G[42342]={'39:40.52,47.96'}
G[42344]={'19:49.8,71.5'}
G[42348]={'19:47.2,69.1'}
G[42349]={'19:46.36,87.18'}
G[42352]={'19:43.9,87.8 19:44,87.1 19:44.4,86.1 19:44.9,86.2 19:45.1,86.5 19:45.4,88.1 19:45.8,88.3 19:46,88.5 19:46.1,86.5 19:46.2,85.1 19:46.4,86.2 19:46.5,85.4 19:46.5,85.6 19:47.2,88.2 19:47.2,89 19:47.3,87.2 19:47.5,88.6 19:47.6,88.4'}
G[42353]={'895:48.74,52.88 27:37.43,44.04>895'}
G[42366]={'895:38.03,33.56 27:33.38,36.74>895 N:38535'}
G[42396]={'895:39.50,38.39 27:33.93,38.56>895'}
G[42405]={'39:49.65,19.39'}
G[42406]={'39:49.8,18.8'}
G[42410]={'613:64.5,68.7 N:40917'}
G[42411]={'613:69.61,75.34 N:39887'}
G[42425]={'39:42.10,64.13'}
G[42426]={'39:42,63.4'}
G[42443]={29611,''}
G[42464]={'26:77.30,79.97'}
G[42465]={'640:56.34,12.15 640:56.29,13.31 640:56.13,12.91'}
G[42466]={'640:39.94,19.36'}
G[42467]={'640:56.51,42.65'}
G[42469]={'640:34.18,34.29'}
G[42472]={'640:72.22,53.99'}
G[42489]={'895:38.39,33.49 27:33.51,36.71>895'}
G[42491]={'895:38.21,33.67 27:33.44,36.78>895'}
G[42497]={'39:49.5,19.2'}
G[42498]={'39:49.58,19.60'}
G[42506]={'321[1]:56.53,62.49'}
G[42536]={'26:72,51'}
G[42553]={'895:40.61,28.08 27:34.36,34.66>895'}
G[42555]={'26:73,50'}
G[42558]={'39:49.74,19.50 N:42308'}
G[42573]={'640:49.49,53.35'}
G[42574]={'640:46.53,57.29'}
G[42575]={'39:56.97,47.10'}
G[42600]={3057,''}
G[42609]={'26:73.2,53.6'}
G[42611]={'895:39.23,26.56 27:33.83,34.09>895'}
G[42612]={'26:78.04,78.11'}
G[42613]={'26:78.17,81.31','Upstairs'}
G[42614]={'640:64.13,36.88 N:42466'}
G[42618]={'891:50.03,49.94 4:64.92,83.25>891'}
G[42622]={'26:67.64,66.60'}
G[42624]={'26:67.78,66.29'}
G[42630]={'895:38.20,40.21 27:33.4,39.2>895'}
G[42637]={'321[1]:47.95,71.03 N:25272'}
G[42640]={'181:60.19,50.43'}
G[42641]={'181:60.15,50.39'}
G[42642]={'26:67.81,66.51'}
G[42643]={'181:54.54,51.17'}
G[42651]={'39:42.98,65.01 N:23975'}
G[42672]={'181:26.16,78.84'}
G[42677]={'39:42.4,69.4'}
G[42684]={'640:62.38,47.73 640:62.17,46.64 640:61.87,45.04 640:61.53,44.00 640:62.05,37.59 640:63.95,45.86 640:64.33,49.31 640:65.05,52.76 640:62.46,53.13','Flying around on a gunship'}
G[42708]={'895:37.28,65.21 27:33.09,48.69>895'}
G[42710]={'462:69.21,52.11'}
G[42730]={'640:46.1,45.7'}
G[42731]={'640:46.16,45.74'}
G[42736]={'37:33.72,37.16'}
G[42750]={'39:56.24,47.69 N:234'}
G[42752]={'382:70.4,47 605:69.9,79.7 605:70.4,79.1 615:51.1,63.2 614:42.6,37.7 N:878'}
G[42790]={'37:47.20,10.65'}
G[42811]={'37:63.25,38.77','Upstairs'}
G[42812]={'37:63.46,39.04'}
G[42813]={'37:63.29,39.82'}
G[42814]={'37:63.43,41.07'}
G[42896]={'26:31.82,58.55'}
G[42898]={'26:31.87,58.39'}
G[42899]={'640:56.52,41.05'}
G[42928]={'341:39.21,56.06 N:38607'}
G[42933]={'27:49.91,44.98'}
G[42936]={'381:43.91,76.16'}
G[42968]={'41:55.23,89.19 N:36132'}
G[42975]={'765[1]:73.00,20.60'}
G[42978]={'700:82.50,49.83'}
G[42983]={'30:41.72,64.64'}
G[43000]={'30:81.83,66.55'}
G[43006]={'888:47.38,59.70 41:58.39,35.54>888'}
G[43009]={'480:81.15,37.63'}
G[43010]={'893:64.93,42.38 462:39.3,20.2>893'}
G[43042]={'37:52.64,66.10'}
G[43043]={'673:55.74,41.22 N:52646'}
G[43045]={'37:47.86,11.86 N:52753'}
G[43062]={'321[1]:51.30,55.98'}
G[43063]={'43:49.45,67.09'}
G[43065]={'640:49.62,52.94'}
G[43071]={'640:27.92,68.71'}
G[43072]={'36:77.8,65.8'}
G[43073]={'182:43.58,28.70'}
G[43079]={'182:44.29,61.87'}
G[43082]={'640:60.80,38.99 640:61.33,38.33 640:62.25,38.03 640:64.10,46.81 640:64.64,51.41','In the main cabin on a gunship'}
G[43086]={'38:72.03,12.05'}
G[43087]={'38:70.04,38.56'}
G[43088]={'38:30.78,34.61'}
G[43095]={'673:34.69,29.54 N:34668'}
G[43096]={'673:33.65,29.18'}
G[43097]={'673:35.1,27.6'}
G[43098]={'673:34.6,27.9'}
G[43099]={'673:46.23,28.15'}
G[43107]={'19:47.13,89.35'}
G[43108]={'26:66.3,44.3'}
G[43109]={'26:66.3,44.3'}
G[43116]={'Near640'}
G[43124]={'20:58.84,51.93'}
G[43156]={'26:63.8,60'}
G[43157]={'26:63.9,59.8'}
G[43158]={'640:69.95,60.09'}
G[43160]={'640:28.21,69.62'}
G[43168]={'640:24.52,62.41'}
G[43169]={'640:24.74,62.18'}
G[43184]={'36:26.29,40.12'}
G[43185]={'36:17.94,18.62'}
G[43187]={'700:78.85,51.75'}
G[43190]={'700:73.76,53.86'}
G[43191]={'700:76.53,49.47'}
G[43193]={'700:82.59,49.93 N:42641'}
G[43194]={'36:29.66,44.55'}
G[43200]={'26:30.7,47.1'}
G[43221]={'36:28.66,40.72'} -- 36:28.66,40.74 36:28.89,40.90
G[43239]={'321[1]:65.69,41.08'}
G[43270]={'36:47.52,41.95'}
G[43272]={'36:33.55,11.85'}
G[43274]={'36:25.90,10.49'}
G[43275]={'36:28.31,16.95'}
G[43278]={'864:34.82,54.79 30:48.55,42.57>864'}
G[43287]={'610:42.42,66.13'}
G[43289]={'615:57.11,75.16 N:43287'}
G[43290]={'615:57.05,17.05'}
G[43295]={'613:69.48,75.32'}
G[43298]={'26:34.4,67.9 26:34.5,68.1'}
G[43299]={'26:35.65,68.46'}
G[43300]={'Near36 N:43270'}
G[43302]={'Near36 N:43275'}
G[43303]={'Near36 N:43274'}
G[43305]={'Near36 N:43272'}
G[43319]={'640:24.61,62.18'}
G[43327]={'36:50.60,42.83'}
G[43329]={'36:51.81,40.08'}
G[43344]={'640:34.08,35.23 640:34.56,34.48 640:34.51,33.31'}
G[43371]={'36:52.8,54.6'}
G[43395]={'640:71.79,47.59'}
G[43397]={'640:49.68,52.94'}
G[43438]={'768[1]:62.60,65.06'}
G[43442]={'640:68.47,26.36'}
G[43453]={'34:79.07,44.19 N:35618'}
G[43454]={'673:41.33,61.23'}
G[43455]={'866:61.23,17.47 27:35.7,65.4>866'}
G[43458]={'36:52.55,55.42 N:43184'}
G[43459]={'36:52.43,55.54 N:43270'}
G[43461]={'36:52.41,55.41 N:43274'}
G[43462]={'36:52.54,55.56 N:43275'}
G[43504]={'673:43.84,56.53'}
G[43508]={'36:53.05,67.78'}
G[43546]={'36:70.26,60.14 N:43272'}
G[43549]={'606:71.60,75.35'}
G[43556]={'673:46.65,93.68','Pacing on deck'} -- 673:46.83,94.37 673:46.68,92.97 673:46.67,95.30 673:46.79,94.63
G[43570]={'26:65.77,44.88'}
G[43581]={'700:76.59,49.52 N:43190'}
G[43607]={'36:77.63,65.33 N:43275'}
G[43611]={'36:77.68,65.52 N:43184'}
G[43661]={'673:44.72,92.77'}
G[43690]={'301:61.99,31.21'}
G[43693]={'301:77.43,67.70'}
G[43697]={'34:21,56.6'}
G[43701]={'27:53.81,52.76'}
G[43702]={'27:75.8,54.4'}
G[43727]={'545:41.64,36.51 N:35378'}
G[43730]={'34:18.32,57.66'}
G[43731]={'34:20.02,57.82'}
G[43733]={'36:77.20,65.91 N:43221'}
G[43738]={'34:44.92,67.42'}
G[43769]={'301:70.23,73.36'}
G[43792]={'640:49.74,53.30 N:42465'}
G[43795]={'362:63.2,79.8'}
G[43804]={'640:57.35,12.53 640:59.36,14.24 N:42472'}
G[43805]={'640:56.07,14.38'}
G[43806]={'640:54.6,14.3 640:55.4,13.1 640:55.5,13.1 640:56.5,13.4 640:56.6,14.1 N:42466'}
G[43809]={'640:56.06,13.46 N:42730'}
G[43812]={'36:58.57,55.65 N:43184'}
G[43818]={'640:49.6,53 N:43065'}
G[43835]={'640:49.27,52.80 N:42730'}
G[43837]={'640:49.4,52.8 640:49.8,52.7'}
G[43849]={'673:42,73.6'}
G[43861]={'34:18.35,58.04 N:311'}
G[43870]={'362:75.32,27.66'}
G[43881]={'362:25.24,13.82'}
G[43884]={'37:47.13,10.56'}
G[43885]={'37:47.67,10.35'}
G[43886]={'37:47.98,12.01'}
G[43897]={'640:22.68,52.02'}
G[43898]={'640:22.76,52.10'}
G[43929]={'Near'}
G[43943]={'700:74.79,53.06 N:25237'}
G[43991]={'464:49.71,49.10'}
G[44010]={'640:64.47,82.13 N:42684'}
G[44017]={'37:53.46,66.75'}
G[44018]={'37:53.37,66.30'}
G[44019]={'37:53.21,66.93'}
G[44021]={'37:52.66,66.81'}
G[44024]={'700:73.80,53.93'}
G[44025]={'640:63.32,25.03 N:42465'}
G[44028]={'34:20.32,27.63'}
G[44036]={'462:43.96,69.97'}
G[44042]={'700:74.28,53.29 N:43187'}
G[44043]={'37:53.06,66.20 37:52.81,66.77'}
G[44080]={'640:62.61,26.92'}
G[44082]={'673:55.24,42.49'}
G[44083]={'673:55.41,42.19'}
G[44084]={'673:55.63,42.22'}
G[44098]={'34:18.08,25.32'}
G[44099]={'673:55.30,41.93'}
G[44100]={'673:55.01,42.26','Walks in area'} -- 673:55.04,41.85 673:55.02,42.43 673:54.76,42.40
G[44112]={'673:42.43,73.22'}
G[44143]={'640:27.59,44.84'}
G[44169]={'700:75.30,54.85 N:43190'}
G[44200]={'35:25.40,17.80'}
G[44204]={'640:28.00,68.64'}
G[44216]={'680[1]:70.43,11.40'}
G[44217]={'680[1]:68.62,11.84'}
G[44222]={'640:64.4,82.2 640:64.5,82.2'}
G[44230]={'23:61.64,43.84'}
G[44231]={'23:52.77,53.57'}
G[44232]={'23:34.90,67.89'}
G[44233]={'23:18.46,27.37'}
G[44238]={'301:85.81,25.95 N:26814'}
G[44247]={'301:78.94,71.17'}
G[44293]={'Near301 N:1747'}
G[44303]={'607:66.96,46.59'}
G[44345]={'35:34.80,49.11'}
G[44365]={'21:57.36,10.19 N:10181'}
G[44372]={'640:47,89.4'}
G[44374]={'161:33.21,76.90'}
G[44375]={'688[1]:48.20,13.10 43:16.52,11.03>688'}
G[44387]={'688:31.1,67.5 688:31.2,65.7 688:31.4,66.5 688:31.5,66.4 688:31.5,66.5 688:32.2,67.9 688:32.4,68.5 688:32.5,65.7 688:32.5,67 688:32.5,68.4'}
G[44395]={'301:57.48,24.90 N:35873'}
G[44402]={'761[1]:67.46,82.77'}
G[44407]={'17:64.34,35.04'}
G[44409]={'17:48.99,36.20'}
G[44410]={'17:21.71,57.80'}
G[44415]={'761[1]:19.92,35'}
G[44441]={'22:41.99,14.73 N:28179','Top of keep'}
G[44451]={'22:49,63.7 N:10181'}
G[44452]={'22:47.77,65.19 N:26581'}
G[44453]={'22:41.07,70.45 N:26170'}
G[44454]={'22:49.27,54.91'}
G[44456]={'22:48.87,54.78'}
G[44457]={'22:48.53,54.90'}
G[44458]={'22:50.65,52.57'}
G[44462]={'22:47.31,64.41'}
G[44466]={'22:47.58,65.56'}
G[44467]={'22:41.26,70.07'}
G[44471]={'22:41.01,70.49'}
G[44472]={'22:48.43,31.95'}	-- 22:48.21,31.79 22:48.60,32.11
G[44490]={'614:69.75,34.42 N:39887'}
G[44540]={'614:69.7,34.4 614:69.7,34.5 N:40917'}
G[44556]={'691[1]:63.02,33.41'}
G[44560]={'691[2]:65.19,47.05'}
G[44561]={'691[3]:23.90,39.07'}
G[44563]={'691[4]:34.53,19.82'}
G[44566]={'767[2]:0.00,0.00'}
G[44615]={'21:57.42,10.14'}
G[44618]={'35:78.56,76.25','In cave'}
G[44635]={'35:73.29,35.98'}
G[44637]={'762:38.7,31.1 762:75.8,79.3 762:75.9,80.4 762:76,80.7'}
G[44640]={'21:57.52,10.49'}
G[44660]={'762:65.2,73.7 762:20.1,14.2 762:20.1,14.9 762:20.1,15.5 762:20.4,16.5 762:20.4,17.9 762:20.5,16 762:20.6,15.4 N:44637'}
G[44690]={'762:67,33.3 762:60.6,93.9 N:44637'}
G[44706]={'762:32.7,55.9 762:49.1,86.9 N:44637'}
G[44725]={'321[1]:45.20,53.69'}
G[44726]={'321[1]:44.79,51.56'}
G[44728]={'762:38.7,31.1 762:75.8,78.7 762:75.8,79.9 762:76,80.5'}
G[44735]={'321[1]:45.50,53.77'}
G[44738]={'762:65.2,73.8 N:44728'}
G[44741]={'762[3]:63.38,94.15'}
G[44746]={'762:32.7,54.1 762:47.9,73.5 762:48.9,72 762:48.9,73.2 762:48.9,73.5 762:48.9,74.7 762:48.9,75.6 762:49.5,74.1'}
G[44749]={'301:33.10,39.50'}
G[44778]={'21:56.77,9.19'}
G[44784]={'21:56.27,8.40'}
G[44789]={'21:58.09,8.99'}
G[44799]={'640:47.31,51.40'}
G[44800]={'762:66.8,77.1 762:44.3,64.3 762:44.3,64.9 762:45,66.7 762:45.2,63.7 762:45.2,64.8 762:45.2,66 762:45.5,65.8 762:45.5,67 762:45.6,65.2'}
G[44802]={'640:47.32,51.36'}
G[44804]={'762[3]:66.91,83.75 N:44800'}
G[44805]={'762:32.7,52.8 762:48.3,64.2 762:48.8,64.3 762:48.9,67.5 762:49.1,65.4 762:49.1,66.1 762:49.1,66.7 762:49.5,64.8 762:49.6,64.1 N:44800'}
G[44806]={'301:34.77,38.22'}
G[44807]={'301:52.00,5.81'}
G[44818]={'640:51.28,50.00'}
G[44823]={'640:51.29,50.05'}
G[44833]={'161:30.49,65.51 N:39667'}
G[44837]={'760[1]:24.52,23.72 61:47.56,23.60>760'}
G[44853]={'321:48.4,83.3 321:48.5,83.2'}
G[44859]={'35:82.79,63.45'}
G[44860]={'720:64.38,22.33 N:26814'}
G[44866]={'321[1]:54.03,73.30'}
G[44870]={'35:58.53,29.10'}
G[44871]={'321:53.3,74.3 321:53.3,74.5 321:53.7,74.1 321:54,73.4'}
G[44905]={'22:42.65,14.96 N:44458','Top of keep'}
G[44912]={'21:44.79,20.91'}
G[44916]={'21:44.02,21.36'}
G[44917]={'21:43.99,21.29'}
G[44919]={'321[1]:48.92,59.24'}
G[44927]={'890:30.83,49.46 9:46.15,82.31>890'}
G[44929]={'686:58.27,88.68 161:39.22,21.34>686'}
G[44943]={'673:46.68,95.32'}
G[44945]={'640:55.36,14.16'}
G[44968]={'640:61.38,26.17 N:29428'}
G[44969]={'699[5]:11.13,38.78 121:64.84,30.26>699'}
G[44971]={'699[5]:7.04,36.13 121:64.84,30.26>699'}
G[44973]={'640:59.60,14.04 N:43442'}
G[44978]={'321[1]:34.98,67.83'}
G[44991]={'699[2]:90.65,44.86 121:60.32,30.15>699 N:40052'}
G[44999]={'699[2]:87.41,52.39 121:60.32,30.15>699'}
G[45009]={'341:40,55 N:2784'}
G[45012]={'22:50.49,52.71'}
G[45013]={'22:49.3,53.2'}
G[45040]={'699[1]:71.67,91.95 121:62.49,24.90>699'}
G[45042]={'737:33.36,50.18 N:4949'}
G[45043]={'640:20.71,61.58'}
G[45046]={25237,''}
G[45052]={'699:71.3,91.2 699:71.3,93.2 699:71.4,92.4 699:71.6,92.4 699:71.6,92.5 699:71.9,91.2'}
G[45098]={'22:38.8,55.3'}
G[45107]={'763[1]:46.20,51.84 22:69.06,73.00>763'}
G[45108]={'763[1]:47.32,51.76 22:69.06,73.00>763'}
G[45109]={'763[1]:46.03,58.48 22:69.06,73.00>763'}
G[45110]={'763[1]:47.30,58.41 22:69.06,73.00>763'}
G[45129]={'22:39.4,70.6 22:39.6,70.4 22:39.6,70.5 N:44471'}
G[45137]={'321[1]:35.58,69.11'}
G[45147]={'22:42.37,15.20'}
G[45149]={'22:44.82,12.53'}
G[45155]={'22:57.39,35.63'}
G[45157]={'22:43.21,15.93'}
G[45165]={'22:42.70,84.11'}
G[45167]={'700:79.09,78.29 N:21330'}
G[45168]={'700:77.01,69.86 N:44806'}
G[45169]={'700:76.76,69.83'}
G[45170]={'700:79.29,78.53'}
G[45171]={'700:76.02,79.70'}
G[45172]={'700:67.67,65.96'}
G[45173]={'700:79.43,77.64'}
G[45180]={'720:64.56,28.60 N:26814'}
G[45186]={'720:64.63,28.67'}
G[45195]={'21:45.2,48.3 21:45.2,51.4 21:45.3,49.2 21:45.8,53.6 21:45.9,53.4 21:46.1,51.4 21:46.2,49.4 21:46.2,49.5 21:46.4,51.5 21:46.4,54.6 21:46.7,52 21:46.8,51 21:46.9,52.6 21:47,45.7 21:47,48.5 21:47,49.5 21:47.3,47 21:47.3,48 21:47.4,53.5 21:47.4,55.2 21:47.5,55.4 21:47.5,55.5 21:47.6,50.4 21:47.7,51 21:47.9,51.6 21:47.9,54.3 21:48.4,53.3 21:48.5,50.1 21:48.5,50.5 21:48.8,52.2 21:48.8,53.7 21:49.3,53.2'}
G[45200]={'765[1]:66.25,86.69 23:27.07,15.77>765 N:16115'}
G[45201]={'765[1]:65.25,87.16 23:27.07,15.77>765'}
G[45202]={'720:65,30 K:27187'}
G[45206]={'765[2]:67.92,72.09 23:43.45,19.36>765 N:16112'}
G[45226]={'301:74.54,19.03'}
G[45228]={'21:55.89,46.35'}
G[45244]={'321[1]:50.46,38.36'}
G[45254]={'21:59.27,34.41'}
G[45257]={'19:60.7,28.1'}
G[45258]={'19:60.6,75.4'}
G[45260]={'19:31.4,69.5'}
G[45262]={'19:32.2,44'}
G[45271]={'61:44.63,50.01'}
G[45277]={'61:42.17,48.39'}
G[45278]={'61:42.17,48.39'} -- I cheated and copied from 45277
G[45296]={'720:64.50,28.00 N:26814','Down in Chamber of the Stars'}
G[45301]={'684:56.51,18.13'}	-- 545:51,17
G[45306]={'301:62.99,34.07'}
G[45312]={'684:57.47,18.94 N:44789'}
G[45315]={'684:57.54,18.23'}
G[45320]={'321:45.3,10.6 321:48.4,89.4 321:48.4,89.7 321:48.4,90.5 321:48.5,89.4 321:48.5,89.7'}
G[45323]={'765[1]:66.98,89.33 23:27.07,15.77>765'}
G[45328]={'765[2]:67.62,82.30 23:43.45,19.36>765 N:45323'}
G[45329]={'765[2]:68.04,72.69 23:43.45,19.36>765 N:16115'}
G[45330]={'765[2]:67.11,72.62 23:43.45,19.36>765 N:16116'}
G[45331]={'765[2]:68.64,73.13 23:43.45,19.36>765 N:45201'}
G[45332]={'700:44.04,10.55 N:42730'}
G[45337]={'321[1]:49.18,70.93'}
G[45339]={'321[1]:48.15,72.94'}
G[45340]={'756[1]:44.77,82.41'}
G[45347]={'321[1]:37.92,87.61'}
G[45362]={'700:44.20,18.13 N:42573'}
G[45386]={'700:43.83,11.33 N:42573'}
G[45389]={'684:65.64,34.10'}
G[45391]={'700:44.00,11.24 N:39875'}
G[45400]={'23:8.82,66.59'}
G[45412]={'765[2]:39.13,20.31'}
G[45417]={'23:9.02,66.52'}
G[45428]={'23:4.14,36.02'}
G[45429]={'23:18.37,74.85'}
G[45430]={''}
G[45431]={'23:74.36,53.33 N:45428'}
G[45432]={'700:44.41,11.56 N:42574'}
G[45442]={'61:39.15,25.76'}
G[45451]={'23:35.71,69.31','Tower top, moving around tower'}
G[45460]={'613:64.4,68.7 613:64.5,68.7 N:39875'}
G[45462]={'613:69.8,75.2 N:39877'}
G[45474]={'Near684 N:44789'}
G[45482]={'23:51.63,21.41'}
G[45500]={'23:35.02,68.15'}
G[45518]={'700:29.30,25.99'}
G[45522]={'700:29.85,31.28'}
G[45525]={'21:51.77,66.05 N:10181'}
G[45528]={'700:29.33,25.97'}
G[45530]={'321:32.2,37.8 321:32.7,37.7 321:33.5,37.9 N:25237'}
G[45540]={'321[1]:36.92,87.48'}
G[45562]={'700:29.80,31.42'}
G[45574]={'23:52.77,51.38'}
G[45575]={'23:53.79,53.99','Tower top'}
G[45617]={'21:51.90,65.01 N:10181'}
G[45626]={'21:51.89,64.73'}
G[45631]={'21:51.70,66.55 N:44640'}
G[45658]={'700:45.27,75.36'}
G[45665]={'700:45.32,75.35'}
G[45668]={'700:43.36,57.35 N:21330'}
G[45669]={'700:43.41,57.34'}
G[45675]={'700:36.37,65.96'}
G[45728]={'24:31.4,37.4'}
G[45729]={'23:75.77,52.41 N:45429'}
G[45730]={'23:28.46,25.91 N:45428'}
G[45735]={'23:61.58,43.13'}
G[45736]={'23:61.32,42.86'}
G[45752]={'21:58.06,69.91'}
G[45772]={'720:45.2,37.8'}
G[45786]={'38:73.16,14.90'}
G[45796]={'700:36.37,65.95 N:332'}
G[45799]={'720:45.25,37.96'}
G[45816]={'23:48.00,23.04'}
G[45817]={'704:46.7,65.3 704:46.8,65.9'}
G[45818]={'704:44,77 704:44.3,77.6 704:44.5,76.9 704:44.8,78.2'}
G[45820]={'704:40.3,67.1 704:40.9,66.4 704:40.9,67.4 704:41,67.5 704:41.5,93.2'}
G[45821]={'704:35.9,77.5 704:36,77.4 704:36.2,76.2'}
G[45823]={'704:35.4,77.8 704:35.9,77.6 704:36,77.3 704:36.1,78.7 704:36.5,78.5 704:36.6,77 704:36.6,78.4'}
G[45824]={'704:51.3,52.2 704:51.3,53.2'}
G[45826]={'23:50.00,19.52'}
G[45828]={'23:17.74,27.88'}
G[45831]={'23:27.65,20.85'}
G[45839]={'704:36.3,74.1 704:36.4,75.4 704:36.4,75.5 704:36.5,75.5 704:36.6,74.9'}
G[45840]={'704:58.1,22.4 704:58.1,22.5 704:58.5,23 704:58.6,21.9'}
G[45849]={'704[1]:37.37,80.07 29:14.58,9.21>704'}
G[45850]={'704[1]:35.99,81.00 29:14.58,9.21>704'}
G[45867]={'23:25.39,19.79'}
G[45868]={'23:29.42,19.66'}
G[45874]={'720:63.44,32.49'}
G[45878]={'Z21 N:35115'}
G[45879]={'Z21'}
G[45880]={'Z21'}
G[45888]={'704[2]:46.89,66.13 29:14.58,9.21>704'}
G[45890]={'704[2]:58.07,22.25 29:14.58,9.21>704'}
G[45891]={'704[1]:36.72,74.59 29:14.58,9.21>704 N:9177'}
G[45892]={'704[1]:36.19,77.28 29:14.58,9.21>704'}
G[45894]={'704[1]:40.95,67.21 29:14.58,9.21>704'}
G[45896]={'21:47.4,77.6'}
G[45898]={'704[1]:44.29,77.79 29:14.58,9.21>704'}
G[45899]={'704[2]:50.77,52.68 29:14.58,9.21>704'}
G[45903]={'704[1]:36.06,77.68 29:14.58,9.21>704'}
G[45948]={'38:84.02,40.12'}
G[45966]={'27:25.76,31.95 27[10]:34.07,32.19 N:42396'}
G[45982]={'700:70.24,43.26'}
G[45983]={'700:70.31,43.39'}
G[46003]={'720:40.00,40.55'}
G[46006]={'22:39.44,69.54'}
G[46010]={'38:73.64,9.16'}
G[46011]={'22:50.50,52.23'}
G[46022]={'23:73.81,52.36'}
G[46071]={'38:69.47,54.52 N:27785'}
G[46077]={'687[1]:49.99,17.15 38:69.68,53.45>687 N:27785'}
G[46089]={'700:78.24,62.54'}
G[46090]={'700:78.46,62.60'}
G[46124]={'21:45.32,84.47 N:10181'}
G[46125]={'21:45.34,84.35 N:44640'}
G[46126]={'720:63.6,32.6 K:27627'}
G[46127]={'720:66.6,27.6 K:27627'}
G[46128]={'720:65.6,32.8 K:27627'}
G[46129]={'720:64.2,27.2 K:27627'}
G[46134]={'720:58.88,46.07'}
G[46135]={'720:54.18,41.88','Inside the dam'}
G[46136]={'720:56.62,54.93 720:56.73,53.84 720:56.49,53.26 720:56.28,53.53 720:55.98,53.96'}
G[46138]={'23:77.54,79.35'}
G[46143]={'700:45.92,65.43'}
G[46172]={'38:69.07,76.50'}
G[46174]={'700:45.78,71.73 700:47.88,74.55'}
G[46175]={'700:53.07,74.59 700:52.89,74.56 700:52.97,74.26 700:52.89,74.09 700:52.70,74.06 700:52.86,74.31 700:53.22,74.10'}
G[46176]={'700:46.50,59.44 700:46.57,59.12 700:46.25,58.73 700:45.96,58.65'}
G[46177]={'700:45.91,65.49'}
G[46182]={'38:74.24,12.17'}
G[46233]={'692[1]:63.97,73.01 17:34.28,10.37>692'}
G[46234]={'692[1]:63.75,72.57 17:34.28,10.37>692'}
G[46235]={'692:64.1,72.6 692:64.2,72.4 692:65,72.7'}
G[46236]={'692:64.1,72.6 692:64.2,72.4 692:64.7,72.8 692:64.8,72.4'}
G[46241]={'692:64.2,72.4 692:64.2,72.5 692:64.7,72.6 692:64.8,72.4'}
G[46242]={'700:37.48,88.64 N:42573'}
G[46243]={'700:37.56,88.73 N:42574'}
G[46247]={'692[1]:63.99,72.12 17:34.28,10.37>692'}
G[46254]={'690[1]:19.96,31.57 N:448'}
G[46255]={'27:29.52,37.71 27[10]:66.39,81.63'}
G[46260]={'690[1]:49.79,27.31'}
G[46264]={'690[1]:77.22,44.63'}
G[46274]={'27:27.97,37.79 27[10]:53.08,82.32'}
G[46313]={'700:54.81,44.20'}
G[46318]={'700:55.14,43.56'}
G[46319]={'700:53.84,43.26'}
G[46323]={'700:53.30,42.70 N:45675'}
G[46324]={'700:53.21,42.71'}
G[46338]={'610:55.28,38.92'}
G[46409]={'690[1]:42.36,54.01'}
G[46410]={'690[1]:56.61,53.86'}
G[46413]={'700:27.64,63.86','Bottom of lake'}
G[46417]={'690[1]:50.03,58.27'}
G[46424]={'687:54.3,79.3'}
G[46458]={'610:58.41,48.68 N:46338'}
G[46463]={'610:58.41,48.67 N:46338'}
G[46474]={'610:60.50,69.61'}
G[46475]={'26:32.2,42.6'}
G[46476]={'26:64,59.9'}
G[46496]={'720:58.4,82.9 720:58.5,82.8'}
G[46513]={'Near700 N:42574'}
G[46583]={'700:52.41,70.33 N:46175'}
G[46585]={'700:46.1,65.6 N:46175'}
G[46590]={'720:70.4,59.2'}
G[46591]={'700:49.01,29.77'}
G[46592]={'720:69.4,58.2 720:69.4,58.5 720:69.6,58.4 720:69.6,58.6 720:69.9,59.5'}
G[46603]={'720:60.28,38.28'}
G[46612]={'756[1]:30.26,28.63 N:42308'}
G[46623]={'687:54.5,79.2'}
G[46626]={'700:50.48,70.58 N:46176'}
G[46627]={'700:50.54,70.81 N:46175'}
G[46628]={'700:50.50,70.62 N:46143'}
G[46637]={'321[1]:67.50,38.81'}
G[46638]={'321[1]:67.35,38.73'}
G[46650]={'17:92.64,38.96'}
G[46652]={'17:65.07,38.40'}
G[46653]={'17:64.27,38.13'}
G[46654]={'17:66.39,55.49'}
G[46655]={'17:66.45,55.51'}
G[46656]={'687:54.4,78.9 687:54.5,78.9'}
G[46657]={'545:51,17 N:45301'}
G[46660]={'17:18.4,41.4 17:18.4,41.5 17:18.5,41.4 17:18.5,41.5'}
G[46664]={'17:47.15,56.47 17:46.83,56.29 17:46.61,56.50'}
G[46671]={'700:37.42,93.23'}
G[46676]={'38:68.20,36.17'}
G[46708]={'321:56.4,61.2 321:56.4,61.5 321:56.5,61.2 321:56.9,61.5'}
G[46717]={'700:45.39,87.97'}
G[46750]={'720:77.27,63.26'}
G[46757]={'17:52.2,51.2 N:46236'}
G[46758]={'17:52.2,51.4 17:52.2,51.5 N:46241'}
G[46759]={'17:52.2,51.4 17:52.2,51.5 N:46235'}
G[46760]={'17:49.25,36.92 N:46234'}
G[46768]={'17:50.27,54.31'}
G[46769]={'17:50.25,53.26'}
G[46804]={'700:60.16,58.00'}
G[46805]={'700:57.48,58.14'}
G[46806]={'700:62.60,48.64'}
G[46811]={'700:50.8,60.2'}
G[46812]={'700:50.8,60.2'}
G[46814]={'700:60.42,58.30'}
G[46850]={'700:62.49,48.41 700:62.55,48.28'}
G[46852]={'17:20.58,56.07'}
G[46853]={'17:20.63,56.19'}
G[46854]={'17:20.58,56.30'}
G[46855]={'Near17 N:46852'}
G[46856]={'Near17 N:46853'}
G[46857]={'Near17 N:46854'}
G[46860]={'17:15.3,42.8 17:15.6,42.8'}
G[46861]={'17:6.2,39.3 17:7.5,42.5 17:7.8,35.8 17:7.9,39.5 17:8.3,36.8 17:8.3,38 17:8.4,38.5 17:8.4,40.5 17:8.5,39.3 17:8.7,37.4 17:8.9,43.4 17:9,37.5 17:9.1,43.8 17:9.2,42.4 17:9.3,40.8 17:9.4,35.6 17:9.4,39.9 17:9.5,37.4 17:9.5,40 17:9.5,40.6 17:9.9,37.9 17:9.9,42.2 17:10.1,38.5 17:10.2,36 17:10.5,37.1 17:10.5,38.1 17:10.5,40.7 17:10.6,35.4 17:10.7,40 17:11.2,39.4 17:11.3,41.8 17:11.6,38.3 17:11.6,42.3 17:12.1,38.9 17:12.4,40.1 17:12.5,39.9 17:13.3,36.2 17:82.1,37.4'}
G[46872]={'720:59.58,72.02 N:45799'}
G[46873]={'720:59.70,71.82 N:39667'}
G[46875]={'720:59.66,71.99 N:46338'}
G[46883]={'720:59.57,47.33'}
G[46889]={'756:28.3,25 756:28.4,26.3 756:29.1,27.5 756:29.2,25.3 756:29.2,26.4 756:29.2,26.5 756:29.5,26.4 756:29.5,26.7 756:29.5,27.9 756:29.6,25.2 756:29.9,28.5 756:62.3,39.5 756:62.4,39 756:62.4,40.9 756:62.6,38.4 756:62.7,39.5 756:62.7,40.5 756:62.9,39.3 756:63.5,40.9 756:63.7,39.4 756:63.9,39.9 756:63.9,41.8'}
G[46901]={'HD 4:47.35,18.02'}
G[46902]={'756:28.1,25.5 756:28.3,26.5 756:28.4,25.4 756:29.2,24.2 756:29.2,26.5 756:29.3,24.9 756:29.3,25.5 756:29.5,25.4 756:29.5,26.7 756:29.6,25.5 756:60.3,38.4 756:60.4,38.9 756:60.4,39.6 756:61.1,39.5 756:61.2,38.5 756:61.3,38.4 756:62,38.4 756:62,38.5 756:62.3,39.8 756:62.5,38.4 756:62.6,38.8 756:63.2,39.6'}
G[46906]={'756:27.9,25.2 756:28.2,27.7 756:28.3,25.8 756:28.4,26.5 756:28.5,25.4 756:28.6,26.4 756:28.9,26.8 756:29.1,27.5 756:29.5,25.5 756:29.6,25.3 756:30,27.7 756:30.2,29 756:57.4,39.8 756:58.1,39.3 756:58.1,39.5 756:58.3,38.4 756:58.7,39.2 756:58.7,39.5 756:59.1,38.4 756:59.5,39.2 756:59.6,39.6 N:34693'}
G[46908]={'HD 381:69.91,40.62'}
G[46916]={'17:8,40.8 17:8.1,41.5 17:8.4,40.2 17:8.4,42.5 17:8.8,41.8 17:8.8,42.7 17:9.1,38.3 17:9.1,38.9 17:9.2,44.3 17:9.2,44.5 17:9.3,39.7 17:9.4,36.4 17:9.4,37.4 17:9.4,41.1 17:9.5,36.4 17:9.6,38.2 17:9.6,41.3 17:9.6,41.5 17:9.7,46 17:9.8,46.7 17:10,42.6 17:10.1,34.8 17:10.2,38.7 17:10.2,43.9 17:10.3,39.6 17:10.4,37.3 17:10.7,38.7 17:11,38.2 17:11.1,39.9 17:11.2,41.1 17:11.3,36.9 17:11.4,41.6 17:11.5,40.5 17:11.5,41.6 17:11.6,39.1 17:11.7,36.2 17:11.8,38.4 17:11.8,39.9 17:12.1,36.7 17:12.6,39.3 17:12.7,39.7 17:12.8,36.5 17:12.8,37.5 17:13,36.4'}
G[46917]={'17:13,43.4 17:13,43.5 17:13.1,45.2 17:14.3,46.3 17:14.4,42.7 17:14.6,42.7 17:15.4,46.7 17:15.5,46.7 17:17,48 17:17.2,47.4 17:17.4,45.6 17:17.7,44.6 17:18,45.8 17:19.1,46.7 17:19.3,46 17:20.1,44.8 17:21,44 17:21.3,43.3 17:21.9,43.5 17:22.4,43.1 17:22.5,43.4'}
G[46920]={'720:73.6,72.6'}
G[46930]={'17:20.86,55.72'}
G[46935]={'700:50.74,58.31 N:18471'}
G[46936]={'700:50.7,58.4 700:50.7,58.5 N:22893'}
G[46938]={'17:16.7,48.8'}
G[46964]={'764[1]:0.00,0.00 N:35115'}
G[46972]={'17:20.80,57.35'}
G[46978]={'720:43.98,57.08 N:26814'}
G[46987]={'606:28.28,29.74'}
G[46993]={'720:46.8,58.6'}
G[46998]={'606:27.04,62.64 N:46987'}
G[47002]={'606:43.80,45.95 N:46987'}
G[47005]={'720:54.29,35.27 N:39667'}
G[47006]={'764[1]:62.06,57.24'}
G[47011]={'17:18.8,42.9'}
G[47013]={'17:18.8,42.9'}
G[47014]={'720:80.4,47.8'}
G[47018]={'17:18.8,42.9'}
G[47021]={47011,''}
G[47022]={47013,''}
G[47024]={47018,''}
G[47041]={'38:21.2,51.9'}
G[47118]={'700:43.88,57.27'}
G[47119]={'700:81.66,77.11'}
G[47121]={'700:28.54,24.86'}
G[47147]={'700:60.42,57.65'}
G[47154]={'700:48.54,28.11'}
G[47155]={'700:56.78,15.11'}
G[47158]={'720:36.13,15.77 N:26814'}
G[47159]={'720:24.44,64.08 720:24.46,64.27'}
G[47162]={'756[1]:32.89,59.37'}
G[47195]={'640:30.7,77.8 N:44143'}
G[47202]={'720:41,70 K:27940'}
G[47231]={'764[1]:0.00,0.00'}
G[47233]={'321[1]:44.64,61.60'}
G[47240]={'709:73.39,59.18'}
G[47246]={'321[1]:48.49,62.91'}
G[47250]={'27:27.72,31.93 27[10]:50.97,31.92'}
G[47266]={'28:68.57,53.38'}
G[47267]={'28:68.49,53.28'}
G[47268]={'28:68.74,53.34'}
G[47269]={'28:68.91,53.27'}
G[47280]={'Near28 N:47269'}
G[47281]={'28:54.68,72.22 N:47269'}
G[47293]={'764[1]:64.36,57.87 N:44789'}
G[47317]={'700:61.48,67.42'}
G[47318]={'720:49.67,39.11'}
G[47332]={'Near28 N:47269'}
G[47341]={'182:41.9,72'}
G[47366]={'182:41.89,71.94'}
G[47374]={'Near700'}
G[47383]={'61:69.88,85.17'}
G[47393]={'28:39.42,67.86'}
G[47417]={'700:54.35,43.85 N:43190'}
G[47429]={'28:39.83,67.91 N:47269'}
G[47432]={'24:29.21,64.04'}
G[47440]={'28:38.84,68.92'}
G[47462]={'28:43.06,29.19'}
G[47471]={'61:12.85,33.98'}
G[47492]={'700:27.32,36.79 N:47374'}
G[47493]={'700:29.63,40.98 N:42641'}
G[47551]={'24:33.28,73.63'}
G[47554]={'24:33.29,73.55'}
G[47556]={'182:60.58,9.51'}
G[47571]={'321[1]:49.05,70.56'}
G[47580]={'61:30.47,49.27 N:45442'}
G[47592]={'700:25.99,38.79 N:332'}
G[47603]={'700:21.77,57.09 N:26917'}
G[47605]={'700:22.13,56.55 N:45528'}
G[47611]={'Near700'}
G[47617]={'182:44.1,61.8'}
G[47626]={'756[2]:58.76,39.49'}
G[47670]={'720:24.37,64.55 N:47571'}
G[47671]={'700:36.42,38.12 N:43190'}
G[47681]={'24:36.62,70.20'}
G[47684]={'720:54.91,32.72'}
G[47692]={'182:41.26,49.95'}
G[47696]={'182:41.27,49.90'}
G[47709]={'720:52.9,27.6 720:53,27.2'}
G[47715]={'720:52.98,27.70'}
G[47723]={'700:36.73,37.95'}
G[47739]={'756[2]:60.65,41.24'}
G[47745]={'61:50.14,62.57 N:4046'}
G[47751]={'700:36.39,37.99'}
G[47759]={'24:32.6,78'}
G[47779]={'29:16.99,51.29'}
G[47781]={'24:36.17,61.15'}
G[47789]={'24:38.6,62.6'}
G[47811]={'29:17.27,52.08 N:43184'}
G[47843]={'182:43.45,28.19'}
G[47869]={'24:40.32,59.40'}
G[47875]={'22:44.65,18.47'}
G[47899]={'24:36.34,60.24'}
G[47900]={'24:40.32,59.34'}
G[47902]={'700:59.07,69.80 N:45518'}
G[47904]={'700:59.02,69.81 N:45522'}
G[47905]={'700:44.91,90.90 N:45562','In Obsidian Lair'}
G[47923]={'182:45.6,20.2'}
G[47927]={'28:41.05,68.78'}
G[47931]={'182:61.84,26.77'}
G[47940]={'720:24.40,64.09 N:47159'}
G[47959]={'720:55.02,34.04 N:45799'}
G[47967]={'720:21.85,64.03'}
G[47972]={'720:22.51,63.18 N:47159'}
G[47991]={'700:48.40,14.56 N:42573'}
G[48001]={'29:45.45,46.34'}
G[48010]={'700:49.78,29.17'}
G[48012]={'720:58.97,46.13'}
G[48013]={'700:49.79,29.28'}
G[48014]={'700:49.14,29.31'}
G[48020]={'24:40.30,59.34 N:47900'}
G[48021]={'24:40.26,59.33 N:47869'}
G[48022]={'Near720 N:46883'}
G[48032]={'Near182'} -- initially at 182:48.68,25.16
G[48033]={'29:46.80,44.08'}
G[48034]={'720:63.90,33.85 N:26814'}
G[48039]={'708:51.42,49.62'}
G[48042]={'Near182'}
G[48044]={'Near182'}
G[48046]={'700:62.56,48.59'}
G[48051]={'737:33.38,50.35 N:4949'}
G[48053]={'700:63.15,47.61'}
G[48059]={'700:48.70,16.63 N:42573'}
G[48061]={'708:51.41,49.61'}
G[48062]={'708:51.4,49 708:51.4,49.6 708:51.5,49.1 708:51.5,49.7'}
G[48066]={'708:50.93,49.70'}
G[48069]={'708:50.6,50.5 708:50.9,49.2 708:50.9,49.7'}
G[48070]={'708:51.4,49 708:51.4,49.6 708:51.5,49.1 708:51.5,49.7'}
G[48071]={'708:51.3,49.1 708:51.4,49.6 708:51.5,49.1 708:51.5,49.7'}
G[48074]={'708:51.42,49.61'}
G[48082]={'720:54.64,41.79 N:26814'}
G[48085]={'29:45.32,51.74'}
G[48099]={'29:39.2,55.4 29:39.2,56.1 29:39.2,56.5'}
G[48100]={'29:45.1,52.5 29:45.3,52.4'}
G[48109]={'29:46.39,46.02 N:43184'}
G[48110]={'29:46.32,45.96 N:43221'}
G[48111]={'29:44.41,63.47'}
G[48126]={'182:43.93,28.16'}
G[48127]={'182:56.3,8.2'}
G[48129]={'24:49.15,66.34'}
G[48133]={'29:30.68,33.72'}
G[48162]={'720:23.55,60.25 N:26814'}
G[48173]={'700:49,29.7 N:46591'}
G[48174]={'700:49.1,29.4 N:48014'}
G[48175]={'700:49.7,29.2 N:48010'}
G[48186]={'720:27.03,7.56 N:26814'}
G[48203]={'720:26.62,8.03'}
G[48208]={'61:43.40,43.44'}
G[48218]={'24:49.56,74.38'}
G[48237]={'720:56.92,62.43 N:46883'}
G[48250]={'709:74.77,59.60'}
G[48254]={'709:72.94,60.94'}
G[48255]={'709:73.72,57.59'}
G[48264]={'700:44.08,10.54 N:27804'}
G[48265]={'700:44.08,10.54 N:27803'}
G[48273]={'720:22.29,64.93'}
G[48274]={'720:26.61,8.37'}
G[48275]={'720:56.20,33.60 N:26664'}
G[48292]={'29:82.11,31.52 N:10299'}
G[48306]={'29:73.49,67.19 N:43184'}
G[48307]={'29:73.63,67.16 N:43221'}
G[48312]={'29:69.63,42.90','In cave on top of hill'}
G[48314]={'29:70.17,47.29','In cave'}
G[48316]={'29:66.52,40.53 N:48133','In cave'}
G[48318]={'29:17.78,52.77'}
G[48319]={'24:47.9,71.2 24:48.4,72.3 24:48.4,73 24:48.7,71.3 24:48.7,72.4 24:48.7,72.5'}
G[48321]={'29:46.15,41.80'}
G[48322]={'24:47.9,72.5'}
G[48333]={'182:54.7,18.4'}
G[48339]={'182:43.94,27.86'}
G[48346]={'Near29 N:43184'}
G[48349]={'182:44.00,27.86'}
G[48358]={'709:53.7,80.4 709:53.7,80.5'}
G[48360]={'709:55.2,81.1 709:55.5,80.6'}
G[48361]={'709:55.6,78.4 709:55.7,78.6'}
G[48363]={'709:54.4,79.4 709:54.4,79.6 709:54.5,79.7 709:55,79.2'}
G[48364]={'700:54.39,16.75 N:46804'}
G[48365]={'700:54.76,17.37 700:54.88,17.17 N:21330'}
G[48366]={'700:54.60,17.54'}
G[48367]={'700:54.33,16.75'}
G[48368]={'700:54.3,16.8'}
G[48417]={'756[2]:33.30,48.65'}
G[48419]={'756[1]:59.81,71.78'}
G[48420]={'756[1]:60.32,71.42'}
G[48428]={'720:40,22'}
G[48431]={'720:29.61,21.85 N:48203'}
G[48445]={'756[1]:44.66,82.78'}
G[48459]={'182:43.33,30.43'}
G[48461]={'182:64.09,10.29'}
G[48469]={'182:44.2,28'}
G[48470]={'24:29.30,83.88 N:48218'}
G[48472]={'700:38.12,34.49 N:46591'}
G[48491]={'182:44.34,28.07'}
G[48492]={'182:61.91,26.66'}
G[48493]={'182:56.76,18.50'}
G[48501]={'720:67.34,42.79'}
G[48503]={'24:27.14,88.35 N:48218'}
G[48513]={'321[1]:36.6,87.0'}
G[48522]={'756[2]:60.67,40.49'}
G[48528]={'720:36.15,20.26 N:26814','In the Chamber of the Moon'}
G[48530]={'700:54.74,17.95 N:48013'}
G[48545]={'24:57.08,46.23 N:44640'}
G[48558]={'720:39.00,23.24 N:26814','In the Chamber of the Moon'}
G[48559]={'29:17.4,51.7 29:17.5,51.7'}
G[48564]={'720:52.02,65.46 N:47684'}
G[48565]={'29:54.6,24.4 29:54.7,24.6 N:48559'}
G[48567]={48559,''}
G[48568]={'29:44.6,44.4 29:44.6,44.5 N:3144'}
G[48569]={'29:54.6,24.4 29:54.6,24.5 N:3144'}
G[48621]={'720:42.16,25.92 N:48203'}
G[48658]={'281:50.72,54.87'}
G[48659]={'281:50.80,55.01'}
G[48660]={'281:50.69,55.07'}
G[48698]={'720:41.35,5.56 N:26814'}
G[48704]={'23:73.74,53.06'}
G[48722]={'281:65.32,46.19'}
G[48723]={'281:65.37,46.20'}
G[48731]={''}
G[48732]={''}
G[48733]={39875,''}
G[48734]={42684,''}
G[48736]={'381:48.13,14.47'}
G[48761]={'720:67.23,42.90 N:46883'}
G[48764]={'42:52.4,30.8'}
G[48797]={'673:39.48,69.54','Swims in harbor'}
G[48808]={'673:40.52,68.20'}
G[48965]={'281:59.74,49.66'}
G[48993]={'700:77.63,16.63 N:42640'}
G[49000]={'700:82.12,80.05 N:47374'}
G[49002]={'700:81.84,80.39'}
G[49020]={'700:78.82,76.90 N:44806'}
G[49022]={'700:80.96,79.40'}
G[49035]={'Z24'}
G[49044]={'892:40.51,78.53 20:29.43,70.94>892'}
G[49151]={'720:33.33,19.66 N:26814'}
G[49201]={'24:60.04,63.67'}
G[49203]={'720:32.59,30.66 N:26814'}
G[49204]={'720:32.59,30.89 N:28070'}
G[49240]={'24:61.86,84.22'}
G[49243]={'24:60.08,63.35'}
G[49248]={'720:44.85,67.32 N:28070'}
G[49252]={'700:81.04,79.34 N:44806'}
G[49345]={'720:52.94,65.51 N:46883'}
G[49351]={'720:44.85,67.32 N:28070'}
G[49358]={'700:55.25,17.32 N:21330'}
G[49374]={'700:55.21,17.31 N:48367'}
G[49378]={'700:80.07,74.53 N:47374','Circling in airship'}
G[49379]={'700:80.05,74.50 N:49002','Circling in airship'}
G[49386]={'700:48.61,30.68'}
G[49387]={'700:53.87,42.08'}
G[49396]={'281:55.94,28.13'}
G[49399]={'281:45.61,41.58'}
G[49400]={'281:46.29,42.58'}
G[49402]={'281:48.08,40.61'}
G[49407]={'281:45.78,41.01'}
G[49408]={'720:26.9,7.4 720:26.9,7.5'}
G[49417]={'700:14.87,16.34 N:45518'}
G[49425]={'892:67.01,42.35 20:35.75,62.23>892'}
G[49436]={'281:55.89,28.27'}
G[49439]={'700:77.69,16.65'}
G[49441]={'700:77.67,16.69'}
G[49444]={'606:42.65,28.14'}
G[49476]={'753[1]:33.08,65.99 N:49444'}
G[49479]={'888:42.53,50.49 41:57.20,33.27>888 N:32973'}
G[49480]={'888:38.91,27.69 41:56.07,26.29 N:1992','In cave'}
G[49523]={'720:41.36,5.57'}
G[49537]={'281:55.97,28.24'}
G[49635]={'673:41.49,74.36'}
G[49636]={'673:41.7,74'}
G[49687]={'24:33.6,49.3'}
G[49748]={'381:45.21,49.88'}
G[49810]={'700:14.15,15.47 N:45528'}
G[49856]={'23:76.16,50.95'}
G[49920]={'17:91.2,37.2 17:91.3,37.7 17:91.5,38'}
G[49941]={'759[3]:47.15,44.40 N:28070'}
G[49943]={'769[1]:54.48,15.83 720:76.75,84.45>769'}
G[50038]={'747:31.69,16.14 720:60.52,64.19>747'}
G[50048]={'768:53.61,94.92'}
G[50049]={'301:37.18,56.26','In basement'}
G[50068]={'606:42.66,45.71'}
G[50082]={'606:43.55,45.89 N:40997'}
G[50084]={'606:41.18,42.59'}
G[50140]={'481:58.25,62.16'}
G[50263]={'281:61.87,74.66'}
G[50270]={'767:49.9,89.7 N:39887'}
G[50272]={'767:49.9,89.1 767:49.9,89.7 767:50,90.9 767:50,91.5 N:40917'}
G[50366]={'281:59.68,50.48'}
G[50367]={'181:50.70,73.90'}
G[50371]={'611:57.91,75.55'}
G[50385]={'757[1]:18.80,55.61 700:19.18,54.01>757'}
G[50387]={'757[1]:19.80,52.55 700:19.18,54.01>757 N:45562'}
G[50390]={'757[1]:19.22,55.45 700:19.18,54.01>757 N:45522'}
G[50401]={'720:45.57,57.76'}
G[50480]={'301:63.77,61.53'}
G[50482]={'321:25.1,90.1 321:71.4,36.3 321:71.8,36.7 321:71.9,36.1 321:72.4,35.4 321:72.5,36.2'}
G[50587]={'261:53.28,33.50'}
G[50588]={'261:53.57,33.35'}
G[50601]={'27:62.55,53.80'}
G[50622]={'700:53.96,41.90'}
G[50631]={'27:76.19,53.04'}
G[50690]={'381:37.64,80.43'}
G[51287]={'709:53.8,80.4 709:54.3,80.7 709:54.5,80.2 709:54.5,80.8'}
G[51288]={'709:74.56,60.93'}
G[51574]={'HM 37:52.05,63.55'}
G[51575]={'HM 181:60.79,53.48'}
G[51582]={'HM 37:40.59,50.94'}
G[51585]={'HM 17:19.00,56.18'}
G[51586]={'HM 607:48.33,72.23'}
G[51587]={'HM 607:40.85,67.79'}
G[51588]={'HM 81:49.30,51.33'}
G[51602]={'HM 38:70.25,15.73'}
G[51603]={'HM 19:46.23,13.78'}
G[51604]={'HM 22:29.17,57.35'}
G[51606]={'HM 201:59.86,63.24'}
G[51607]={'HM 201:56.32,66.34'}
G[51639]={'362:21.96,18.83'}
G[51650]={'HM 700:47.26,28.97'}
G[51651]={'HM 700:53.13,46.18'}
G[51652]={'HM 720:53.15,34.53'}
G[51653]={'HM 720:53.59,31.85'}
G[51664]={'182:36.36,58.26'}
G[51665]={'HW 30:32.04,50.51 N:35873'}
G[51677]={'Near281'}
G[51682]={'HM 606:62.82,22.72'}
G[51697]={'HM 615:49.35,42.00'}
G[51698]={'HM 640:49.40,51.32'}
G[51934]={'30:32.35,50.88'}
G[51988]={'301:56.32,53.99'}
G[51989]={'321[1]:57.97,57.61'}
G[52015]={'709:75.00,60.37'}
G[52019]={'769[1]:29.25,38.64'}
G[52053]={'793:31.77,24.11'}
G[52064]={'HW 30:32.09,50.60'}
G[52122]={'795:70.2,40.6'}
G[52135]={'795:47.01,91.38 N:33091'}
G[52192]={'11:44.33,25.10'}
G[52207]={'11:47.53,39.58'}
G[52219]={'606:24.49,60.90'}
G[52234]={'Near37'}
G[52281]={'37:52.88,67.35 37:52.58,66.51 37:53.16,65.87 N:44019'}
G[52292]={'381:43.95,78.87'}
G[52294]={'37:44.13,22.91 N:715'}
G[52309]={'11:41.07,39.21'}
G[52319]={'382:55.29,50.25'}
G[52346]={'37:50.37,21.74'}
G[52371]={'37:76.09,66.65 N:52346','In cave'}
G[52374]={'37:76.09,66.66'}
G[52382]={'321[1]:48.76,70.15'}
G[52408]={'301:49.53,87.50','In tower'}
G[52410]={'37:47.75,12.00 N:469'}
G[52444]={'795:42.52,59.69 N:41006'}
G[52467]={'795:48.54,86.25 N:40331'}
G[52476]={'795:50.94,87.38'}
G[52477]={'795:36.01,59.01 N:40278'}
G[52478]={'795:35.79,59.38 N:39925'}
G[52488]={'795:43.80,88.96'}
G[52489]={'795:50.64,87.26'}
G[52490]={'795:43.04,80.58 N:40997'}
G[52491]={'795:34.50,56.23 N:41003'}
G[52492]={'795:36.29,56.35 N:41005'}
G[52493]={'795:47.55,90.54 N:40139'}
G[52494]={'795:64.88,67.25'}
G[52646]={'673:55.30,41.95'}
G[52651]={'362:36.8,59.6'}
G[52654]={'301:25.93,29.29 N:52234'}
G[52657]={'362:35.6,53.8'}
G[52669]={'606:27.17,62.56 N:39928'}
G[52671]={'606:27.10,62.02 N:39930'}
G[52730]={'793:49.34,39.09'}
G[52753]={'37:47.86,11.86'}
G[52767]={'673:41.03,73.13 N:38966',}
G[52793]={'606:60.31,29.86 N:40289'}
G[52823]={'795:52.99,90.91'}
G[52824]={'795:45.58,85.81'}
G[52835]={'486:34.40,25.20'}
G[52838]={'606:27.08,54.48 N:5769'}
G[52844]={'606:26.80,62.15 N:40139'}
G[52845]={'606:27.36,55.23 N:33091'}
G[52906]={'606:26.00,61.28 N:52488'}
G[52921]={'795:66.09,63.97'}
G[52924]={'781:14.19,52.92 N:38966'} -- at end of dungeon is 781:93.33,53.59
G[52925]={'781:13.76,51.83'}
G[52933]={'781:13.74,54.06'}
G[52937]={'606:27.55,62.43'}
G[52986]={'606:27.53,62.50'}
G[52995]={'606:62.10,23.07'}
G[53009]={'486:46.6,35.6 N:24848'}
G[53023]={'X 793:30.75,47.14 37:72.09,32.91>793'}
G[53024]={'X 793:30.59,47.32 37:72.09,32.91>793'}
G[53043]={'X 793:30.51,50.95 37:72.09,32.91>793'}
G[53056]={'795:57.48,49.46'}
G[53073]={'606:27.49,61.58 606:27.14,61.65 606:26.86,61.77'} -- some days he wanders, others he is just in another place
G[53080]={'795:46.88,89.99 N:41492'}
G[53081]={'321[1]:32.62,68.15 N:52234'}
G[53149]={'486:31,24 N:24848'}
G[53151]={'X 793:30.83,47.28 37:72.09,32.91>793'}
G[53196]={'795:46.76,90.18 N:29428'}
G[53210]={'486:31,24 N:24848'}
G[53214]={'795:46.91,90.00'}
G[53215]={'486:23,30.8 N:24848'}
G[53233]={'795:51.89,30.98 N:39925'}
G[53259]={'795:34.30,56.43'}
G[53304]={'795:36.23,56.58 N:29428'}
G[53310]={'795:50,50'}
G[53349]={'486:23.2,22.8 N:24848'}
G[53352]={'301:26.22,29.27'}
G[53365]={'795:50,86 N:52824'}
G[53371]={'321[1]:50,77'}
G[53385]={'795:47.14,90.42 N:33091'}
G[53422]={'321[1]:48.6,71.8 301:54,56'}
G[53466]={'301:54,56 N:53371'}
G[53519]={'720:34.26,77.56 N:35875'}
G[53524]={'720:47.65,88.91'}
G[53528]={'382:62.66,35.48'}
G[53566]={'808:56.67,18.17'}
G[53567]={'803[1]:60.58,21.42 N:52835'} -- 520:60,21
G[53652]={'614:69.81,34.19 N:35875'}
G[53677]={'614:69.54,34.30'}
G[53738]={'640:56.52,12.50 N:35875'}
G[53763]={'382:68.86,7.86'}
G[53783]={'606:19.59,36.38'}
G[53881]={'795:44.08,86.34'}
G[53882]={'795:44.42,88.81'}
G[53925]={'795:51.45,25.79 N:35875'}
G[53949]={'301:60.06,75.13'}
G[53950]={'301:24.04,44.81'}
G[54004]={'321[1]:48.13,46.86'}
G[54014]={'795:49.60,31.77 N:35875'}
G[54021]={'301:64.17,46.28'}
G[54117]={'301:58.89,52.73'}
G[54118]={'301:65.16,33.46 N:54021'}
G[54135]={'808:38.80,25.49','In cave'}
G[54141]={'321[1]:54.42,77.63'}
G[54142]={'4:57.33,9.01 N:53950'}
G[54146]={'321[1]:58.05,48.42'}
G[54163]={'795:66,65 N:29428'}
G[54168]={'606:60.22,29.83 N:4949'}
G[54233]={'486:46,34.8'}
G[54312]={'606:60.22,30.12 N:35875'}
G[54313]={'606:60.63,31.46 N:4949'}
G[54314]={'606:49.10,19.58 N:38917'}
G[54334]={'HF 301:62.11,32.18 301:62.27,72.97 341:27.52,73.32 381:38.56,49.39 481:52.02,29.14 504[1]:49.90,50.37'} -- another one wanders SW
G[54393]={'606:27.75,63.63'}
G[54432]={'820[1]:81.23,23.95'}
G[54476]={'820[1]:79.59,44.97'}
G[54485]={'HF 823:51.63,77.85'}
G[54548]={'819[1]:48.70,19.73 N:4949'}
G[54567]={'808:55.09,32.54'}
G[54568]={'808:50.23,21.27'}
G[54590]={'819[1]:56.8,27.8'}
G[54601]={'HF 823:53.29,54.37'}
G[54603]={'797[1]:48.45,68.07 465:47.63,53.57>797'}
G[54605]={'HF 823:50.69,65.13'}
G[54606]={'797[1]:48.45,68.07 465:47.63,53.57>797 N:17493'}
G[54608]={'808:57.54,34.69 N:53566'}
G[54609]={'808:50.27,21.48 N:53566'}
G[54614]={'806:46.13,84.57'}
G[54615]={'806:50.41,88.26'}
G[54616]={'806:43.59,90.68'}
G[54617]={'806:45.17,94.98'}
G[54629]={'725[1]:50.94,90.22 465:46.03,51.79>725'}
G[54636]={'725[1]:50.94,90.22 465:46.03,51.79>725'}	-- location is just a guess until horde can verify
G[54667]={'728[1]:18.81,11.18 467:48.94,35.80>728'}
G[54668]={'728[1]:17.86,12.08 467:48.94,35.80>728'}
G[54674]={'726[1]:31.47,65.28 467:54.14,34.39>726'}
G[54675]={'726[1]:30.86,65.22 467:54.14,34.39>726 N:54667'}
G[54678]={'726[1]:29.53,64.43 467:54.14,34.39>726'}
G[54692]={'732[1]:34.41,19.47 478:39.63,57.67>732 N:19670'}
G[54694]={'732[1]:32.73,19.43 54694>732'}
G[54697]={'806:43.49,75.92'}
G[54698]={'722[1]:46.2,23.6 478:34.34,65.61>722'}
G[54725]={'722[1]:44.21,71.01 478:34.34,65.61>722'}
G[54751]={'820[6]:52.12,44.47 N:54476'}
G[54786]={'808:51.41,46.38 N:53566'}
G[54787]={'808:39.40,29.54'}
G[54840]={'723[1]:72.16,35.50 478:44.91,65.61>723'}
G[54847]={'723[1]:47.86,67.01 478:44.91,65.61>723'}
G[54848]={'727[1]:17.88,27.27 467:50.40,33.35>727 N:54667'}
G[54849]={'727[1]:17.48,25.92 467:50.40,33.35>727 N:54678'}
G[54851]={'727[1]:18.83,27.67 467:50.40,33.35>727'}
G[54854]={'806:43.32,76.01'}
G[54870]={'321[1]:48.58,70.56'}
G[54890]={'724[1]:21.28,13.10 478:39.63,73.54>724'}
G[54891]={'724[1]:22.58,12.49 478:39.63,73.54>724'}
G[54913]={'806:45.01,24.96'}
G[54914]={'806:45.21,25.06'}
G[54915]={'806:41.62,23.69'}
G[54917]={'806:41.60,28.33'}
G[54918]={'806:38.94,24.08'}
G[54922]={'806:43.26,24.72'}
G[54926]={'806:43.10,23.60'}
G[54931]={'710[1]:58.61,88.44 465:47.68,51.99>710 N:17493'}
G[54932]={'710[1]:58.8,88.8 465:47.68,51.99>710 N:54636'}
G[54933]={'710[1]:58.61,88.44 465:47.68,51.99>710 N:54603'}
G[54934]={'710[1]:58.62,88.60 465:47.68,51.99>710 N:54629'}
G[54943]={'808:55.09,32.82'}
G[54960]={'806:58.89,81.48'}
G[54961]={'806:53.66,91.41'}
G[54968]={'819[1]:40,52.6'}
G[54969]={'816:87.34,50.04'}
G[54971]={'819[2]:46.79,44.93 N:4949'}
G[54975]={'808:65.59,42.58 N:54567'}
G[54998]={'806:49.65,45.83'}
G[55007]={'798[2]:42.61,87.19'}
G[55009]={'806:41.03,73.97 N:54697'}
G[55020]={'808:70.62,38.72'}
G[55021]={'808:63.44,41.91'}
G[55054]={'4:63.52,0.01 N:54870'}	-- TODO: Attempt to get the real location on Hellscream's Fist which reports as 4:0,0
G[55084]={'806:41.01,74.08'}
G[55094]={'806:38.01,23.79'}
G[55122]={'806:58.07,80.65'}
G[55135]={'806:30.74,10.21 N:54870'}
G[55136]={'710[1]:67.20,51.70 465:47.68,51.99>710 N:17493'}
G[55138]={'710[1]:67.20,51.70 465:47.68,51.99>710 N:54603'}
G[55172]={'806:28.42,24.94 N:54870'}
G[55180]={'806:28.19,24.82'}
G[55196]={'806:54.18,82.41'}
G[55209]={'806:43.21,75.94'}
G[55210]={'HL 720:31.59,62.99'}
G[55211]={'HL 720:65.52,18.68'}
G[55216]={'HL 640:27.71,69.17'}
G[55217]={'HL 640:49.70,54.88'}
G[55218]={'HL 700:51.87,33.07'}
G[55219]={'HL 700:50.91,70.45'}
G[55224]={'HL 606:26.69,62.05'}
G[55227]={'HL 606:62.54,22.82'}
G[55228]={'HL 615:57.25,86.14'}
G[55234]={'806:46.65,46.15'}
G[55274]={'806:38.66,42.25 N:55234'}	-- TODO: Probably should be a Near, but would like specific area if we can put that capability in place
G[55282]={'806:58.86,81.78 N:54616'}
G[55283]={'806:58.93,81.93'}
G[55284]={'806:59.07,81.89'}
G[55333]={'806:58.98,81.83 N:54617'}
G[55382]={'HF 21:75.48,3.27 321[1]:48.22,62.16 362:43.93,52.60 382:62.06,46.93 481:51.80,29.25 480:74.32,81.89 504[1]:50.27,50.40 N:54334'}
G[55403]={'806:31.14,17.53'}
G[55413]={'806:46.56,45.62 N:55234','Running all around town'}
G[55438]={'806:48.67,24.94'}
G[55477]={'808:68.88,64.97 N:54568'}
G[55478]={'808:69.13,66.65 N:55021'}
G[55479]={'808:68.11,66.40'}
G[55497]={'Near806 N:55403'}
G[55521]={'806:31.14,21.58'}
G[55531]={'520[1]:36.06,81.20'}
G[55532]={'816:84.43,56.05'}
G[55535]={'520[1]:35.25,80.93'}
G[55536]={'520[1]:37.30,81.66 N:55535'}
G[55537]={'520[1]:36.14,83.00 N:55535'}
G[55564]={'533[3]:14.92,83.88 488:26.01,50.83>533'}
G[55583]={'808:30.96,36.73 N:54568'}
G[55585]={'808:29.90,39.77 N:55021'}
G[55586]={'808:30.00,60.36 N:53566'}
G[55588]={'808:31.82,39.70'}
G[55592]={'808:24.64,69.79'}
G[55595]={'808:32.94,35.61 N:54567'}
G[55614]={'806:44.25,15.01'}
G[55624]={'816:27.24,64.21 N:54476'}
G[55646]={'806:28.65,47.46 N:55180'}
G[55647]={'806:28.64,47.38'}
G[55648]={'806:28.60,47.43'}
G[55658]={'522[1]:26.62,50.61'}
G[55672]={'808:19.46,51.23 N:53566'}
G[55677]={'534[1]:35.50,83.17 496:28.53,86.94>534 N:26664'}
G[55737]={'530[1]:36.52,35.09 496:81.22,28.88>530 N:30676'}
G[55738]={'530[1]:57.32,34.60 496:76.27,21.19>530 N:30671'}
G[55768]={'806:27.59,32.68 N:54961'}
G[55788]={'806:52.60,38.12'}
G[55789]={'301:78.80,39.99 N:54617'}	-- 301:26.11,20.63 (location prior to new MoP quests)
G[55809]={'806:45.71,43.70'}
G[55828]={'806:28.62,47.48'}
G[55835]={'526[1]:35.75,34.95 495:39.54,26.92>526'}
G[55940]={'808:42.28,86.34 N:55021'}
G[55942]={'808:36.36,72.51 N:54568'}
G[55943]={'808:50.09,76.66'}
G[55944]={'808:42.21,86.53'}
G[55963]={'806:44.25,15.01 N:55614'}
G[56012]={'808:51.31,48.29 N:55588'}
G[56013]={'808:51.44,48.29'}
G[56027]={'525[1]:11.68,53.71 495:45.37,21.39>525'}
G[56062]={'806:46.46,45.81'}
G[56063]={'806:55.31,45.32'}
G[56064]={'806:54.89,45.31'}
G[56065]={'806:54.56,44.41'}	-- 806:54.92,45.12
G[56072]={'524[2]:45.07,18.05 491:57.25,46.59>524'}
G[56110]={'807:84.08,21.03 N:54926'}
G[56111]={'807:19.87,56.92 N:54913'}
G[56112]={'857:60.08,25.00'}
G[56113]={'807:61.14,34.30'}
G[56114]={'857:67.36,32.74 N:56112'}
G[56115]={'857:76.21,7.07'}
G[56133]={'807:85.94,22.11'}
G[56138]={'807:68.88,43.30'}
G[56204]={'807:83.69,21.02'}
G[56205]={'807:75.21,24.05'}
G[56207]={'807:81.45,25.01'}
G[56208]={'807:78.12,32.90'}
G[56222]={'806:58.97,81.70 N:55196'}
G[56287]={'806:53.78,90.63 N:54961'}
G[56312]={'807:78.18,32.81'}
G[56313]={'806:26.27,37.33'}
G[56327]={'806:25.96,38.73'}
G[56329]={'806:33.35,42.21'}
G[56336]={'806:27.99,47.18'}
G[56339]={'806:28.26,47.78 N:54870'}
G[56345]={'806:50.91,27.07 N:54961'}
G[56346]={'806:50.94,27.03'}
G[56347]={'806:45.43,29.14 806[6]:60.88,37.06'}
G[56348]={'806:47.14,46.16'}
G[56351]={'806:25.88,38.00'}
G[56358]={'806:27.03,50.84'}
G[56364]={'806:59.00,81.99 N:81280'}
G[56366]={'806:58.97,81.69 N:55196'}
G[56406]={'806:28.30,47.79 N:55521'}
G[56416]={'808:36.49,84.23 N:54567'}
G[56418]={'808:39.30,86.22 N:54568'}
G[56432]={'806:65.98,79.28'}
G[56433]={'806:65.98,79.38'}
G[56434]={'806:65.91,79.27 N:1747'}
G[56439]={'867[1]:68.33,57.97'}
G[56440]={'807:82.70,21.22'}
G[56465]={'807:82.66,25.55'}
G[56467]={'806:46.30,29.40 N:56347'}
G[56474]={'807:68.71,43.12'}
G[56490]={'Near806 N:54870'}
G[56525]={'806:28.98,49.08 N:55521'}
G[56541]={'877[3]:20.80,22.12 N:63009'}
G[56611]={'807:68.79,43.25 N:56133'}
G[56662]={'808:15.79,49.11 N:54567'}
G[56707]={'806:46.28,45.46'}
G[56708]={'806:52.58,38.11'}
G[56714]={'807:18.29,31.22'}
G[56720]={'807:19.54,56.88'}
G[56737]={'806:57.95,82.51'}
G[56773]={'807:60.60,33.68'}
G[56774]={'806:45.77,44.00'}
G[56782]={'806:58.13,58.66'}
G[56784]={'806:58.03,59.01'}
G[56786]={'806:56.26,60.44'}
G[56787]={'806:57.53,56.01'}
G[56802]={'807:59.82,27.94'}
G[56832]={'807:64.89,26.94'}
G[56833]={'807:65.47,26.06'}
G[56866]={'807:61.14,34.30 N:56113'}
G[56877]={'875[1]:47.32,65.45'}
G[56884]={'877[1]:69.85,45.33 N:60688'}
G[56899]={'29:54.11,23.86'}
G[57108]={'806:28,47 N:54870'}
G[57198]={'807:11.60,49.53'}
G[57209]={'807:52.60,62.96'}
G[57211]={'807:52.73,62.98'}
G[57242]={'806:55.84,57.08'}
G[57250]={'807:68.81,43.50 N:56133'}
G[57298]={'807:52.95,51.59'}
G[57319]={'806:53.89,61.91'}
G[57324]={'806:53.91,61.94'}
G[57385]={'807:38.58,51.72'}
G[57401]={'807:44.16,34.23'}
G[57402]={'807:44.63,34.05'}
G[57405]={'807:62.66,59.74'}
G[57407]={'807:63.62,58.52'}
G[57408]={'807:41.32,38.13','Underground'}
G[57424]={'807:63.55,58.43'}
G[57706]={'807:32.12,68.33 N:56133'}
G[57707]={'807:32.31,68.45 N:56138'}
G[57708]={'807:32.23,68.47 N:56474'}
G[57739]={'808:38.78,86.33 N:54568'}
G[57744]={'857:75.84,7.60'}
G[57864]={'820[1]:79.65,45.14'}
G[57913]={'816:87.33,49.29 N:10667'}
G[57934]={'807:55.88,49.42 N:56133'}
G[58113]={'857:59.88,24.68'}
G[58114]={'857:59.87,24.81'}
G[58149]={'534[1]:37.18,80.52 496:28.53,86.94>534 N:26500'}
G[58160]={'857:68.80,22.24'}
G[58206]={'Near857 N:56112'}
G[58225]={'806:65.35,31.67'}
G[58228]={'806:57.55,45.10'}
G[58278]={'857:29.68,39.05'}
G[58376]={'857:81.29,6.82'}
G[58379]={'857:76.27,7.12 N:56115'}
G[58408]={'811:56.72,43.57'}
G[58413]={'806:57.33,45.34'}
G[58420]={'806:58.61,43.65'}
G[58421]={'807:16.00,82.48 N:18180'}
G[58422]={'807:16.07,82.62 N:715'}
G[58434]={'807:15.90,82.25'}
G[58444]={'806:58.58,43.65 N:58420'}
G[58465]={'811:33.98,38.00'}
G[58467]={'811:56.79,43.26'}
G[58468]={'811:56.74,42.65'}
G[58469]={'811:56.69,43.14 N:59343'}
G[58470]={'811:56.54,43.21 N:59342'}
G[58471]={'811:33.67,38.40'}	-- *** after Golden Lotus revamp we have: [58471]={58471,'811:21.30,71.50'}
G[58503]={'811:33.97,38.13 N:58465'}
G[58504]={'811:34.06,38.13 N:58471'}
G[58506]={'806:58.02,43.71'}
G[58508]={'806:57.48,44.02'}
G[58509]={'806:58.26,45.05'}
G[58510]={'806:58.47,44.70'}
G[58511]={'806:57.29,43.47'}
G[58547]={'857:44.18,42.94'}
G[58562]={'807:52.22,48.67'}
G[58563]={'807:52.23,48.66'}
G[58564]={'806:57.76,45.07'}
G[58567]={'807:52.01,48.34'}
G[58590]={'874[1]:0.00,0.00'}
G[58607]={'857:15.98,39.79 N:58113'}
G[58609]={'857:40.48,34.65 N:1747'}
G[58630]={'857:29.06,51.14'}
G[58632]={'871[1]:0.00,0.00'}
G[58646]={'807:52.74,47.94'}
G[58647]={'807:53.04,51.71'}
G[58704]={'811:18.11,63.56'}
G[58705]={'807:52.76,51.84'}
G[58706]={'807:53.17,51.79'}	-- probably need to make this a SELLS instead of HAS (so we do not try to kill)
G[58707]={'807:53.07,51.86'}
G[58708]={'807:53.12,52.05'}
G[58709]={'807:34.42,46.76'}
G[58710]={'807:53.56,52.57'}
G[58712]={'807:52.98,51.34'}
G[58713]={'807:52.67,51.99'}
G[58714]={'807:52.60,51.63'}
G[58715]={'807:52.58,51.71'}
G[58716]={'807:53.40,51.60'}
G[58717]={'807:53.18,52.24'}
G[58718]={'807:52.89,52.13'}
G[58721]={'807:52.01,48.02 N:58646'}
G[58723]={'807:51.98,48.02 N:58646'}
G[58735]={'857:67.44,32.70'}
G[58736]={'807:60.97,32.85'}
G[58743]={'811:18.48,71.53'}
G[58745]={'857:67.45,32.63'}
G[58761]={'807:45.10,33.78'}
G[58779]={'857:67.63,25.73'}
G[58785]={'Near807 N:56474'}
G[58814]={'Near857 N:56112'}
G[58818]={'811:33.84,70.44'}
G[58819]={'811:35.37,74.06'}
G[58820]={'811:33.77,69.68'}
G[58821]={'857:24.71,34.04 N:58735'}
G[58843]={'807:20.30,58.67'}
G[58911]={'811:35.27,74.86 N:59333'}
G[58919]={'811:21.47,71.59 N:58465'}
G[58920]={'811:21.39,71.45 N:58471'}
G[58945]={'806:27.58,24.25'}
G[58954]={'857:15.70,39.71'}
G[58962]={'811:20.45,73.51 811:20.05,75.63','Moves between spots'}
G[58970]={'857:24.70,33.99 N:58745'}
G[59022]={'806:54.21,82.49 N:55122'}
G[59048]={'857:25.14,33.46'}
G[59049]={'857:67.76,32.49'}
G[59058]={'806:58.76,81.28'}
G[59073]={'809:72.27,91.85'}
G[59074]={'876[4]:46.56,50.07 876[4]:38.82,56.28'}	-- second position is after he moves if you are not quick enough
G[59076]={'809:70.74,90.36'}
G[59077]={'809:71.57,92.83'}
G[59080]={'898[4]:49.46,36.78'}
G[59119]={'807:31,29'}
G[59120]={'807:29.82,28.74'}
G[59121]={'807:30,42'}
G[59123]={'807:29.75,33.97'}
G[59124]={'807:32.72,30.44'}
G[59138]={'857:40.60,33.69 N:58547'}
G[59150]={'871[1]:0.00,0.00'}
G[59173]={'806:46.92,45.99','Pacing back and forth'}
G[59178]={'806:46.63,45.32 N:55788'}
G[59186]={'806:47.05,46.24'}
G[59188]={'857:40.63,33.73 N:1747'}
G[59189]={'857:40.43,34.70 N:1747'}
G[59254]={'806:52.59,38.09 N:55788'}
G[59263]={'809:74.96,88.86'}
G[59272]={'809:74.67,76.92'}
G[59273]={'809:74.78,88.68'}
G[59332]={'811:33.82,38.50 N:58408'}
G[59333]={'811:33.40,38.04'}
G[59334]={'811:33.13,38.98 N:58468'}
G[59335]={'809:69.98,70.54'}
G[59336]={'811:35.29,76.75 N:58819'}
G[59337]={'811:35.12,75.37 N:58468'}
G[59338]={'811:33.87,72.22 N:58467'}
G[59340]={'811:21.48,71.18 N:58408'}
G[59341]={'811:42.23,45.93'}
G[59342]={'811:43.67,46.09'}
G[59343]={'811:42.32,46.00'}
G[59353]={'809:71.76,70.28'}
G[59354]={'809:71.36,69.30'}
G[59371]={'809:64.70,61.75'}
G[59374]={'809[9]:65.93,60.40 N:59354'}
G[59377]={'806:28.2,46.8 N:54961'}
G[59383]={'806:48.32,46.06'}
G[59391]={'806:48.31,61.35'}
G[59402]={'809:65.49,60.82'}
G[59405]={'809:64.24,61.38'}
G[59411]={'806:44.77,67.09 N:54961'}
G[59418]={'806:49.29,61.47 N:54961'}
G[59441]={'809:71.54,93.08 N:55122','Upstairs'}
G[59442]={'809:71.64,93.11 N:54870','Upstairs'}	-- ?? 809:62.98,80.19
G[59448]={'809:62.76,79.83 N:55521'}
G[59449]={'809:62.68,80.67 N:55180'}
G[59450]={'809:54.17,83.27 N:54616'}
G[59451]={'809:53.67,83.27 N:54614'}
G[59452]={'809:51.97,67.25'}
G[59479]={'876[4]:43.23,44.79'}
G[59492]={'806:43.83,12.53 N:55614'}
G[59533]={'807:42.39,50.00'}
G[59550]={'806:58.56,82.30 N:54616'}
G[59569]={'806:38.82,31.22'}
G[59573]={'809:60.24,85.78'}
G[59584]={'857:67.93,45.23'}
G[59585]={'807:55.59,52.07'}
G[59586]={'857:67.56,43.51'}
G[59597]={'809:64.88,60.49'}
G[59608]={'Near857 N:1747'}
G[59620]={'806:58.85,81.12 N:54961'}
G[59636]={'809:60.17,85.91'}
G[59639]={'807:45,28'}
G[59695]={'809:57.71,61.75'}
G[59696]={'809:57.22,61.20'}
G[59701]={'809:58.09,61.46'}
G[59703]={'809:51.66,67.83'}
G[59704]={'876[1]:75.01,36.13 N:56133'}
G[59716]={'809:57.32,60.19'}
G[59719]={'857:40.42,49.24'}
G[59727]={'806:54.57,61.76'}
G[59732]={'806:57.01,44.03'}
G[59733]={'806:55.38,23.73'}
G[59735]={'806:50.82,26.80'}
G[59736]={'806:43.58,24.54'}
G[59755]={'809:42.45,68.91'}
G[59806]={'809:49.09,70.38 N:59452'}
G[59821]={'809:59.63,78.26'}
G[59822]={'876[1]:76.90,35.23'}
G[59855]={'807:17.97,56.44 N:57744'}
G[59856]={'807:17.99,55.89 N:56714'}
G[59894]={'809:52,67.2'}
G[59899]={'806:49.30,61.42 N:56784'}
G[59905]={'811:57.26,42.99'}
G[59906]={'811:74.17,41.82 N:63266'}
G[60021]={'807:18.16,55.82 N:56474'}
G[60042]={'808:50.22,76.63'}
G[60055]={'808:36.31,72.35'}
G[60135]={'857:67.62,42.50'}
G[60136]={'857:67.49,44.59'}
G[60139]={'857:45.99,78.91'}
G[60161]={'809:44.48,89.92'}
G[60173]={'857:51.53,76.85'}
G[60175]={'809:48.14,49.04'}
G[60178]={'809:42.94,88.32'}
G[60182]={'857:51.65,75.29'}
G[60230]={'807:84.50,21.06'}
G[60231]={'807:56.49,50.36'}
G[60232]={'857:76.74,8.38'}
G[60289]={'857:52.43,77.98'}
G[60299]={'857:45.35,84.05'}
G[60358]={'857:42.27,89.84'}
G[60416]={'809:42.81,69.63'}
G[60422]={'857:51.56,77.42'}
G[60436]={'809:63.17,29.38'}
G[60441]={'857:52.47,76.60'}
G[60491]={'Z809'}
G[60503]={'809:42.42,69.65'}
G[60506]={'857:31.34,63.42'}
G[60528]={'857:31.29,63.59'}
G[60529]={'857:31.36,63.62'}
G[60564]={'809:36.47,77.02'}
G[60566]={'301:74.20,91.99 N:54567'}
G[60570]={'4:45.6,12.6 N:54568'}
G[60578]={'867[1]:35.91,44.60 806:56.18,57.87>867'}
G[60585]={'886:80.53,55.99'}
G[60588]={'857:31.31,63.58 N:60506'}
G[60596]={'809:42.36,69.79'}
G[60622]={'810:67.94,67.67'}
G[60673]={'857:68.35,42.09'}
G[60674]={'857:68.34,43.49'}
G[60675]={'857:67.21,41.14'}
G[60677]={'809:40.31,81.53'}
G[60678]={'809:40.27,81.57'}
G[60679]={'809:42.49,69.32'}
G[60684]={'810:67.25,52.22'}
G[60687]={'810:67.20,52.28'}
G[60688]={'810:71.15,56.69'}
G[60694]={'809:60.61,21.35'}
G[60735]={'810:66.98,51.42'}
G[60757]={'809:67.04,33.34 N:60694'}
G[60785]={'809:60.61,21.35 N:60694'}
G[60795]={'809:43.79,51.05 N:54961'}
G[60857]={'810:67.94,67.68 N:60622'}
G[60864]={'810:82.59,73.02'}
G[60871]={'810:71.18,56.74 N:60688'}
G[60903]={'810:82.71,73.16'}
G[60951]={'810:82.69,73.10 N:60903'}
G[60968]={'809:67.23,55.91 809:70.27,51.27 809:71.76,44.90 809:66.41,46.34 809:68.48,44.60'}	-- Xuen exists in more than one place at the same time, though logically, one probably will get the next fight in the round from the nearest one
G[60970]={'806:58.86,81.67 N:55122'}
G[60973]={'809:75.13,87.93'}
G[60981]={'809:68.54,56.42 N:54913'}
G[61016]={'810:61.58,79.35'}
G[61020]={'810:51.67,87.25'}
G[61021]={'810:76.42,82.53'}
G[61026]={'807:36.19,68.29'}
G[61065]={'Near809 N:60973'}
G[61066]={'810:76.42,82.43 N:60688'}
G[61097]={'809:48.11,48.99 N:60175'}
G[61118]={'809:66.30,50.67'}
G[61121]={'811:84.62,62.42'}
G[61161]={'810:39.21,62.01'}
G[61203]={'880:52.38,68.07 N:62321'}
G[61218]={'806:54.02,91.19 N:54961'}
G[61261]={'810:82.68,73.02 N:60687'}
G[61297]={'Near809'}
G[61371]={'809:62.33,29.05 N:54961'}
G[61398]={'885[3]:39.18,75.02'}
G[61454]={'809:29.27,62.26 N:60684'}
G[61467]={'810:79.38,84.45'}
G[61468]={'810:79.46,84.48 N:61021'}
G[61469]={'810:76.93,78.78 N:61021'}
G[61470]={'810:75.86,83.14'}
G[61473]={'809:43.91,89.55'}
G[61474]={'809:72.54,94.17'}
G[61482]={'810:49.14,71.23'}
G[61485]={'887[1]:50.35,44.23'}
G[61495]={'809:63.44,28.73','Upstairs'}
G[61496]={'809:63.36,30.63'}
G[61503]={'809:63.73,30.71'}
G[61504]={'809:57.73,59.70'}
G[61511]={'809:62.43,30.12'}
G[61512]={'809:34.54,59.12'}
G[61528]={'680[1]:33.97,77.51'}
G[61534]={'Near809 N:61503'}
G[61539]={'810:43.86,65.76'}
G[61580]={'810:39.35,62.29'}
G[61581]={'810:39.34,62.21'}
G[61583]={'810:38.80,62.39'}
G[61584]={'810:39.42,61.96'}
G[61585]={'810:39.15,62.07'}
G[61621]={'809:74.67,76.87 N:59272'}
G[61625]={'810:49.20,71.31'}
G[61636]={'899[1]:50.28,82.49'}
G[61693]={'809[9]:64.64,60.92 N:59354'}
G[61716]={'680[1]:67.95,11.30'}
G[61724]={'680[1]:68.14,11.58'}
G[61744]={'809:53.98,84.26'}
G[61759]={'873:56.72,75.74'}
G[61796]={'301:82.60,28.10 N:29611'}
G[61816]={'809:34.96,59.40'}
G[61819]={'809:31.29,61.51 N:60687'}	-- 809:35.12,59.66
G[61820]={'809:29.24,62.30 N:61016'}
G[61822]={'680[1]:68.31,12.80'}
G[61823]={'680[1]:69.36,10.92'}
G[61847]={'809:57.34,61.69 N:54961'}
G[61850]={'809:57.34,61.69 N:54961'}
G[61880]={'810:70.34,86.66'}
G[61881]={'810:70.46,86.37'}
G[61962]={'811:83.27,29.68 N:54961'}
G[61970]={'858:62.05,56.76'}
G[62092]={'321[1]:70.62,31.38 N:25237'}
G[62112]={'811:14.15,76.98'}
G[62124]={'810:67.37,80.68'}
G[62151]={'858:54.88,36.16'}
G[62166]={'858:72.56,28.67'}
G[62180]={'858:54.32,36.08'}
G[62202]={'858:70.19,25.64'}
G[62203]={'858:73.68,27.58'}
G[62205]={'887[2]:0.00,0.00'}
G[62216]={'809:31.34,61.61 N:60684'}
G[62227]={'Near809 N:60687'}
G[62232]={'Near858 N:62180'}
G[62236]={'877[2]:83.48,56.20 809:36.70,47.46>877 N:60687'}
G[62273]={'810:61.64,79.33 N:60688'}
G[62274]={'810:54.02,78.06 N:60688'}
G[62275]={'810:47.48,78.87 N:60688'}
G[62278]={'810:53.93,78.12'}
G[62295]={'Near810'}
G[62304]={'810:49.01,70.45 N:60687'}
G[62321]={'806:47.38,37.01'}
G[62322]={'806:48.16,34.59'}
G[62377]={'807:48.31,33.47'}
G[62378]={'Near810 N:60864'}
G[62379]={'Near810'}
G[62385]={'807:44.25,34.20'}
G[62410]={'810:76.37,82.46 N:60688'}
G[62412]={'810:61.10,83.03 N:60688'}
G[62436]={'810:67.32,80.85 N:61021'}
G[62444]={'810:74.27,84.96 N:61021'}
G[62491]={'882:49.59,60.71 N:65289'}
G[62519]={'858:55.11,34.25'}
G[62538]={'858:54.98,34.05 N:62202'}
G[62540]={'858:43.32,63.50'}
G[62547]={'810:49.14,71.23 N:61482'}
G[62573]={'810:51.27,83.03'}
G[62658]={'807:70.82,24.09'}
G[62666]={'858:51.21,11.40'}
G[62667]={'858:50.73,11.71'}
G[62668]={'858:51.16,11.19'}
G[62730]={'810:61.60,79.29 N:61016'}
G[62736]={'810:61.12,83.07 N:60688'}
G[62754]={'858:52.98,12.38'}
G[62767]={'858:27.4,16.0'}
G[62771]={'858:38.64,17.25'}
G[62772]={'858:38.16,17.34'}
G[62774]={'858:54.94,34.13'}
G[62779]={'858:50.44,12.05 N:56133'}
G[62786]={'810:53.99,86.96 N:61020'}
G[62788]={'810:53.99,86.96 N:61020'}
G[62802]={'810:46.12,82.47 N:61021'}
G[62810]={'810:28.86,22.58'}
G[62859]={'858:51.13,11.12'}
G[62871]={'809:72.67,92.34'}
G[62872]={'857:51.52,77.18'}
G[62898]={'810:54.29,79.05'}
G[62901]={'810:71.08,57.32'}
G[62903]={'810:74.39,81.46'}
G[62909]={'810:50.08,71.98'}
G[62923]={'806:22.87,30.60'}
G[62963]={'858:54.13,20.34 N:56133'}
G[62973]={'858:50.18,10.19 N:56133'}
G[62996]={'903[1]:70.03,46.75'}
G[63009]={'810:49.53,70.51'}
G[63013]={'811[3]:40.28,70.73 811:87.29,69.37'}
G[63014]={'30:40.31,66.01'}
G[63054]={'858:51.16,11.36 N:62666'}
G[63061]={'4:52.71,41.29'}
G[63067]={'9:49.21,56.07'}
G[63070]={'41:55.22,51.34'}
G[63071]={'858:25.70,50.29'}
G[63072]={'858:54.37,35.93'}
G[63073]={'20:60.93,54.32'}
G[63075]={'27:53.83,50.09'}
G[63077]={'464:49.31,52.17'}
G[63080]={'462:47.35,47.35'}
G[63083]={'42:50.12,20.17'}
G[63086]={'321[1]:37.57,79.28'}
G[63145]={'807:51.75,47.77'}
G[63146]={'807:51.88,48.26'}
G[63154]={'807:52.01,48.33'}
G[63156]={'807:51.95,48.32'}
G[63193]={'806:27.56,32.63 N:54961'}
G[63194]={'37:46.01,40.44'}
G[63195]={'Near810 N:61016'}
G[63196]={'Near810'}
G[63197]={'Near810'}
G[63217]={'806:30.85,34.06 N:54961'}
G[63218]={'858:50.19,12.44'}
G[63238]={'895:40.08,35.61'}
G[63258]={'864:41.19,52.13'}
G[63265]={'807:52.00,48.31'}
G[63266]={'811:33.49,40.78'}
G[63272]={'892:53.22,56.84'}
G[63285]={'866:63.21,22.26'}
G[63296]={'889:42.08,68.69 4:42.50,68.85>889'}
G[63307]={'806:28.83,32.62 N:54961'}
G[63310]={'891:52.57,51.85 4:65.79,83.91>891'}
G[63314]={'899[1]:50.00,18.54 N:22893'}
G[63315]={'809:68.69,48.39 N:18471'}
G[63317]={'858:55.65,72.54'}
G[63327]={'890:27.97,28.34'}
G[63328]={'Near858 N:62180'}
G[63331]={'888:48.69,52.46 41:58.72,33.73>888'}
G[63332]={'893:63.42,42.64'}
G[63335]={'894:50.46,48.66 464:79.41,51.61>894'}
G[63349]={'858:54.73,72.16'}
G[63367]={'809:72.65,93.01'}
G[63484]={'873:53.52,65.76'}
G[63497]={'811:14.22,79.28'}
G[63498]={'858:56.10,70.18'}
G[63500]={'858:50.21,12.24'}
G[63501]={'858:55.83,34.87'}
G[63535]={'809:62.36,79.64'}
G[63542]={'809:56.35,84.39'}
G[63577]={'806:46.84,46.16 N:54961'}
G[63596]={'301:69.49,25.16'}
G[63614]={'810:49.01,71.33'}
G[63622]={'Near810'}
G[63623]={'Near810 N:61021'}
G[63624]={'Near810 N:61020'}
G[63626]={'321[1]:52.56,59.27'}
G[63721]={'857:68.43,43.52 N:12919'}
G[63748]={'806:28.18,38.98'}
G[63750]={'809:62.32,29.06 N:54961'}
G[63751]={'809:62.58,79.48'}
G[63754]={'809:53.78,84.11'}
G[63758]={'858:54.26,35.78 N:62540'}
G[63778]={'807:70.01,23.57 807:55.33,50.15 806:45.72,43.81 807:18.55,56.37'}
G[63784]={'809:62.32,29.06 N:54961'}
G[63785]={'858:54.83,36.20'}
G[63809]={'806:30.76,41.09'}
G[63822]={'807:16.19,82.53'}
G[63876]={'858:43.32,63.50 N:62540'}
G[63955]={'Near858'}
G[63983]={'811:83.64,31.09'}
G[63984]={'811:83.41,31.17'}
G[63994]={'811:61.12,20.88'}
G[63996]={'811:62.03,20.62'}
G[64001]={'811:62.68,23.37'}
G[64002]={'811:62.79,20.88'}
G[64007]={'811:63.18,22.31'}
G[64010]={'811:61.25,23.54'}
G[64011]={'811:60.93,23.68'}
G[64013]={'858:43.32,63.50 N:62540'}
G[64028]={'811:86.44,61.56'}
G[64029]={'811:85.22,62.86'}
G[64030]={'811:84.23,61.44'}
G[64031]={'811:84.20,62.53'}
G[64032]={'811:84.63,63.79'}
G[64033]={'811:86.56,60.06'}
G[64036]={'811:87.15,60.81'}
G[64041]={'903[1]:67.19,38.84'}
G[64047]={'903[2]:57.32,77.26'}
G[64076]={'811[3]:30.93,64.01'}
G[64085]={'811:72.4,50.4'}
G[64101]={'811[3]:43.94,46.65'}
G[64144]={'811[3]:36.72,77.67 811:86.90,70.11'}
G[64149]={'811[3]:35.74,67.30'}
G[64231]={'807:53.58,51.23'}
G[64236]={'810:47.48,78.84 N:60688'}
G[64259]={'858:54.90,72.83'}
G[64310]={'806:43.10,68.49'}
G[64314]={'807:53.88,47.41','In small cave'}
G[64315]={'807:55.14,47.38'}
G[64330]={'30:41.66,83.67'}
G[64337]={'Near'}
G[64344]={'858:41.76,72.03 N:62540'}
G[64361]={'876[4]:50.12,48.56 N:56133'}
G[64387]={'877[1]:68.96,43.16 809:36.70,47.46>877 N:63009'}
G[64395]={'807:53.52,51.18'}
G[64399]={'867[1]:35.99,44.12 806:56.18,57.87>867'}
G[64432]={'885[1]:30.28,19.26 811:80.82,32.72>885 N:63266'}
G[64448]={'807:56.02,51.80'}
G[64457]={'807:55.30,50.62'}
G[64464]={'807:52.72,50.42'}
G[64467]={'875[1]:60.91,88.53 811:15.84,74.39>875 N:62112'}
G[64484]={'811:85.88,62.37'}
G[64488]={'811:84.38,61.67'}
G[64490]={'858:41.76,72.03 N:62540'}
G[64508]={'811:85.50,60.20'}
G[64517]={'887[1]:57.90,22.98'}
G[64521]={'809:68.92,46.48'}
G[64531]={'811:62.42,21.55'}
G[64533]={'811:60.53,21.55'}
G[64534]={'811:63.37,20.80'}
G[64540]={'809:68.78,43.13 N:1747'}
G[64542]={'809:68.73,43.02 N:58113'}
G[64559]={'858:44.57,41.40'}
G[64562]={'898[1]:26.83,58.75'}	-- starting skull location
G[64563]={'898[1]:26.89,58.65 N:64562'}	-- starting skull location
G[64566]={'811:62.92,28.19 N:58113'}
G[64572]={'811:86.59,60.00'}
G[64582]={'811:60.82,23.68'}
G[64596]={'806:46.22,84.78 N:66209'}
G[64597]={'807:54.66,47.04'}
G[64599]={'858:55.02,35.55'}
G[64607]={'810:38.07,64.32'}
G[64610]={'811:83.99,58.64 N:58735'}
G[64616]={'873:54.42,72.58'}
G[64672]={'858:56.26,58.22 N:63785'}
G[64691]={'811:82.11,29.59'}
G[64705]={'858:56.24,57.58 N:63785'}
G[64724]={'858:42.15,33.46'}
G[64738]={'871[2]:39.26,13.39 N:64764'}
G[64764]={'871[2]:39.26,13.39'}
G[64815]={'858:54.77,34.07'}
G[64822]={'873:75.30,76.27 N:64616'}
G[64827]={'874[1]:72.70,46.89 N:64764'}
G[64838]={'874[1]:72.70,46.89 N:64764'}
G[64841]={'874[2]:49.03,78.52 N:64842'}
G[64842]={'874[2]:49.03,78.52'}
G[64854]={'874[2]:49.17,24.82 N:64855'}
G[64855]={'874[2]:49.17,24.82'}
G[64901]={'884:43.72,64.86 N:63367'}
G[64922]={'811:83.45,31.05 N:28070'}
G[65189]={'857:31.15,63.16'}
G[65229]={'858:33.41,62.44'}
G[65253]={'858:31.80,88.94 N:63072'}
G[65289]={'857:51.81,76.06'}
G[65327]={'858:72.55,28.57 N:62166'}
G[65341]={'810:48.66,71.06 N:61539'}
G[65354]={'858:66.82,65.33'}
G[65365]={'858:48.11,49.64 N:64815','In Amberglow Hollow underground'}
G[65395]={'858:54.71,34.76'}
G[65502]={'858:66.29,32.01 A:100088715'}
G[65511]={'858:42.53,55.75'}
G[65528]={'807:83.76,20.18'}
G[65558]={'Near808 N:54568'}
G[65648]={'39:60.86,18.51'}
G[65651]={'36:33.29,52.58'}
G[65655]={'34:19.83,43.69'}
G[65656]={'673:51.46,73.39'}
G[65669]={'806:57.52,45.31'}	-- blue
G[65670]={'806:57.52,45.31 N:65669'}	-- green
G[65671]={'806:57.51,45.29 N:65669'}	-- yellow
G[65690]={'810:51.67,87.32 N:61020'}
G[65865]={'862:42.24,62.33'}
G[65908]={'806:46.62,85.16'}
G[65910]={'806:46.25,84.73'}
G[65998]={'806:31.42,21.77'}
G[65999]={'806:31.66,21.91 N:54870'}
G[66023]={'806:46.04,85.14'}
G[66085]={'807:51.99,48.45'}
G[66126]={'4:43.86,28.86'}
G[66129]={'807:52.03,48.41'}
G[66130]={'807:51.75,48.36'}
G[66135]={'11:58.61,53.04'}
G[66136]={'43:20.20,29.55'}
G[66137]={'81:59.66,71.58'}
G[66190]={'806:31.62,11.32 N:54870'}
G[66199]={'806:39.55,90.03'}
G[66209]={'806:46.22,84.69'}
G[66220]={'806:29.18,13.79'}
G[66225]={'806:27.21,15.71'}
G[66247]={'810:74.83,81.36'}
G[66260]={'809:48.59,42.71'}
G[66292]={'806:42.02,92.82'}
G[66296]={'806:46.25,84.81 N:60688'}
G[66352]={'121:59.69,49.75'}
G[66372]={'101:57.11,45.69'}
G[66409]={'810:49.13,71.50'}
G[66412]={'241:46.00,60.39'}
G[66415]={'809:64.31,61.43'}
G[66422]={'607:39.59,79.14'}
G[66442]={'182:40.03,56.58'}
G[66466]={'281:65.69,64.47'}
G[66478]={'26:62.93,54.65'}
G[66512]={'23:67.01,52.37'}
G[66515]={'28:35.42,27.76'}
G[66518]={'38:76.75,41.39'}
G[66520]={'29:25.55,47.62'}
G[66522]={'32:40.18,76.50'}
G[66550]={'465:64.37,49.31'}
G[66551]={'467:17.20,50.52'}
G[66552]={'477:60.99,49.36'}
G[66553]={'481:58.89,70.03'}
G[66557]={'473:30.49,41.82'}
G[66581]={'806:41.46,79.14 N:54617'}
G[66635]={'491:28.59,33.82'}
G[66636]={'510:50.19,59.05'}
G[66638]={'488:59.02,76.99'}
G[66639]={'496:13.18,66.79'}
G[66646]={'806:34.78,10.63 N:54870'}
G[66656]={'806:33.66,10.61 N:54870'}
G[66657]={'806:33.71,10.60 N:60688'}
G[66659]={'806:30.53,7.49'}
G[66660]={'806:30.55,7.14'}
G[66662]={'806:31.99,13.28'}
G[66665]={'806:29.13,13.84 N:60688'}
G[66667]={'806:31.05,11.02 N:55521'}
G[66675]={'492:77.36,19.61'}
G[66730]={'806:47.97,54.12'}
G[66733]={'857:62.19,45.88'}
G[66734]={'807:46.00,43.69'}
G[66738]={'809:35.84,73.69'}
G[66739]={'858:55.10,37.56'}
G[66741]={'811:31.18,74.14'}
G[66769]={'811:33.98,38.00 N:58465'}
G[66815]={'640:49.92,57.05'}
G[66819]={'606:61.37,32.84'}
G[66822]={'700:56.56,56.84'}
G[66824]={'720:56.58,41.91'}
G[66838]={'806:32.06,13.37 N:66853'}
G[66841]={'806:32.04,13.37 N:66853'}
G[66845]={'806:29.13,13.72'}
G[66848]={'806:29.37,13.58 N:66660'}
G[66853]={'806:32.06,13.38'}
G[66875]={'858:55.14,35.38 N:62774'}
G[66918]={'810:36.30,52.26'}
G[66949]={'806:58.93,81.93 N:54617'}
G[66998]={'903[1]:47.50,69.93'}
G[67091]={'858:31.80,88.94 N:63072'}
G[67138]={'858:50.18,10.19 N:56133'}
G[67153]={'806:28.57,22.16 N:55403'}
G[67370]={'823:47.04,62.75'}
G[67386]={'857:16.51,79.14 N:66292','Aboard Skyfire'}
G[67402]={'857:75.86,34.17'}
G[67414]={'914:56.08,75.20 N:38966'}
G[67436]={'857:39.27,61.86'}
G[67438]={'857:13.90,41.20'}
G[67444]={'857:16.72,78.58 N:54614','Aboard Skyfire'}
G[67447]={'857:12.66,62.73 N:3387'}
G[67498]={'857:13.82,41.23 N:67438'}
G[67503]={'857:39.19,61.96 N:67436'}
G[67508]={'857:56.36,42.16'}
G[67533]={'857:20.60,58.04'}
G[67534]={'857:20.48,58.06'}
G[67535]={'857:13.79,55.85'}
G[67536]={'857:26.05,58.07'}
G[67537]={'857:22.56,62.33'}
G[67542]={'857:25.54,60.47'}
G[67553]={'857:25.25,60.42 N:67533'}
G[67554]={'857:22.38,62.27 N:67533'}
G[67555]={'Near857 N:67436'}
G[67556]={'Near857 N:67438'}
G[67557]={'Near857 N:67508'}
G[67558]={'857:84.32,18.86 N:35874'}
G[67562]={'857:13.76,55.79'}
G[67565]={'807:53.37,51.45'}
G[67581]={'809:57.07,79.01 N:16802'}
G[67603]={'809:57.12,78.59 N:67834'}
G[67608]={'857:12.92,56.13 N:55521'}
G[67618]={'857:10.30,55.71 N:55647'}
G[67628]={'857:75.83,34.46 N:55180'}
G[67630]={'857:89.66,32.79 N:54614'}
G[67631]={'857:89.68,33.08'}
G[67660]={'928:28.29,52.42 N:30116'}	-- phase 1 location on ship
G[67662]={'928:33.52,35.15'}	-- phase 2 location at camp.  phase 1 is NPC 567662
G[67663]={'928:32.47,35.24 N:36670'}	-- phase 2 location at camp.  phase 1 is NPC 567663
G[67673]={'928:32.42,35.22 N:34771'}	-- phase 2 location at camp.  phase 1 is NPC 567673
G[67682]={'809:59.83,75.95 N:28070'}
G[67716]={'809:59.81,76.04 N:68275'}
G[67734]={'809:59.97,75.32'}
G[67751]={'857:10.56,53.75'}
G[67767]={'857:10.52,53.48','Circling fire'}
G[67812]={'857:8.74,64.36'}
G[67834]={'811:20.94,15.57'}
G[67840]={'903[2]:32.23,84.67 N:25237'}
G[67844]={'809:55.8,34'}
G[67847]={'857:76.32,34.07 N:47571'}
G[67865]={'857:10.69,53.70 N:63778'}
G[67866]={'809:71.66,93.22 N:56133'}
G[67867]={'857:8.67,64.44 N:25237'}
G[67880]={'857:10.07,53.87'}
G[67881]={'857:89.53,33.54'}
G[67901]={'857:15.69,57.69'}
G[67939]={'857:10.38,53.72 N:54870'}
G[67940]={'857:89.56,32.58 N:55122'}
G[67948]={'811[4]:66.18,33.31 N:1747'}
G[67951]={'809[21]:61.88,25.79 N:67734'}
G[67976]={'857:16.51,79.14 N:7944','Aboard Skyfire'}
G[67983]={'928:38.54,51.12'}
G[67984]={'928:32.70,35.02 N:33538'}	-- phase 1 location
G[67985]={'928:28.21,52.84 N:70358'}	-- phase 1 location on ship
G[67986]={'928:53.94,49.86 N:33542'}	-- Conqueror's Terrace
G[67989]={'928:38.48,51.33 N:68586'}
G[67990]={'928:32.51,35.59 N:16802'}	-- phase 2 location in camp.  phase 1 is NPC 567990
G[67992]={'928:63.24,72.22 N:4968'}	-- Phase 2 location.  Phase 1 is NPC 70370.
G[67993]={'928:34.74,89.19 N:30115'}	-- Phase 1 location.  Phase 2 is NPC 567993.
G[67994]={'928:63.47,73.60'}	-- Phase 2 location.  No Phase 1 location.
G[67995]={'928:34.54,89.46'}	-- Phase 1 location.  Phase 2 is NPC 567995.
G[67996]={'928:63.93,73.99'}	-- Phase 1 location.  Phase 2 is NPC 567996.
G[67997]={'928:64.82,73.17 N:34880'}	-- Phase 1 location.  Phase 2 is NPC 67997.
G[67998]={'928:51.79,47.13'}	-- Beast Pens location
G[67999]={'928:51.85,47.18'}	-- Beast Pens location
G[68000]={'928:63.20,72.29'}
G[68003]={'809:48.80,50.47'}
G[68004]={'809:52.97,46.45 N:1747'}
G[68017]={'811[4]:66.18,33.31 N:1747'}
G[68023]={'809:71.63,93.19 N:38966'}
G[68025]={'889:44.61,66.73 N:4949'}
G[68059]={'889:44.65,66.74 N:4949'}
G[68072]={'Near857 N:25237'}
G[68077]={'41:40,50 N:67834'}
G[68084]={'480:91.2,37.6 N:16802'}
G[68106]={'924[1]:26.80,39.00 N:1747'}
G[68166]={'857:17.33,78.67 N:54616','Aboard Skyfire'}
G[68182]={'857:16.71,78.54','Aboard Skyfire'}
G[68223]={'809:56,32 N:25237'}
G[68226]={'857:88.33,34.69'}
G[68242]={'811[4]:67.47,43.30 N:29611'}
G[68274]={'857:81.49,18.27'}
G[68275]={'857:80.19,16.40'}
G[68287]={'809:60.4,55.2 N:36648'}
G[68311]={'857:85.24,29.13'}
G[68337]={'809:32.6,30.6'}
G[68370]={'809:53.8,49.2 N:16802'}
G[68375]={'809:65.12,60.79'}
G[68392]={'857:85.29,29.12 N:29611'}
G[68399]={'Near857 N:29611'}
G[68417]={'809:59.20,84.26'}
G[68462]={'858:61.17,87.55'}
G[68463]={'810:57.13,42.17'}
G[68464]={'806:28.92,35.99'}
G[68465]={'809:64.94,93.73'}
G[68501]={'809:32.89,26.34 N:68337'}
G[68526]={'922[2]:69.97,47.06'}
G[68531]={'922[2]:23.86,81.90'}
G[68538]={'857:88.89,31.75 N:68003'}
G[68544]={'857:43.45,86.54 N:68003'}
G[68586]={'504[2]:50,48'}
G[68589]={'924[2]:31.50,50.18 N:68586'}
G[68590]={'924[2]:45.24,53.86 N:68586'}
G[68651]={'381:38.92,32.79 N:4968'}
G[68687]={'924[1]:34.27,48.70 N:30115'}
G[68690]={'857:87.91,33.10 N:29611'}
G[68908]={'857:89.80,32.44 N:55283'}
G[68939]={'809:56.38,34.31 N:1747'}
G[68987]={'809:55.96,31.88 N:1747'}
G[69026]={'912:42.03,14.93 N:29611'}
G[69090]={'857:87.72,33.07 N:55122','In the keep'}
G[69227]={'928:46.15,69.11'}
G[69228]={'928:49.77,80.34'}
G[69326]={'928:55.19,30.87'}
G[69359]={'929:41.76,79.30'}
G[69360]={'929:52.01,75.51'}
G[69371]={'928:47.01,66.74'}	-- phase 2 location
G[69389]={'928:38.47,51.17'}
G[69413]={'928:58.67,42.76 N:61021'}
G[69418]={'928:32.63,34.91'} -- phase 1 location
G[69425]={'928:46.73,66.77 N:58113'}	-- phase 2 location
G[69433]={'928:32.78,32.67'}	-- phase 1 location
G[69461]={'928:57.6,33.8'}
G[69522]={'HM 858:56.07,69.59'}
G[69529]={'HM 806:47.18,47.18'}
G[69533]={'HM 857:73.99,9.50'}
G[69535]={'HM 809:71.15,90.86'}
G[69536]={'HM 810:71.52,56.30'}
G[69550]={'HM 807:51.81,51.32'}
G[69551]={'HM 811:77.76,33.99'}
G[69572]={'HM 811:79.67,37.26'}
G[69668]={'928:64.87,72.94'}	-- Phase 1 location.  Phase 2 is NPC 569668.
G[69670]={'928:40.11,59.13'}	-- Phase 2 location.  No phase 1 location? Or is this really phase 1 location?  What differs from NPC 569670 which is at base?
G[69673]={'928:31.46,83.24'}	-- Phase 1 location.  Phase 2 is NPC 569673.
G[69674]={'928:31.67,83.20'}	-- Phase 1 location.  Phase 2 is NPC 569674.
G[69675]={'928:42.32,75.04 N:58735'}	-- Phase 1 location.  Phase 2 is NPC 569675.
G[69677]={'928:63.82,74.03'}	-- Phase 1 location.  Phase 2 is NPC 569677.
G[69678]={'928:64.12,73.91 N:19644'}	-- Phase 1 location.  Phase 2 is NPC 569678.
G[69741]={'928:63.16,73.87 N:4968'}
G[69742]={'928:32.91,32.58 N:16802'}
G[69782]={'873:54.60,71.76 N:64616','Upstairs'}
G[70022]={'929:33.00,53.89','In cave'}
G[70100]={'933:60.26,28.69 N:64616'}
G[70160]={'928:51.42,46.08 N:60688'}
G[70183]={'928:63.25,72.25'}
G[70296]={'301:67.55,18.51'}
G[70297]={'928:63.20,73.90 N:61021'}	-- Alliance version of Taoshi
G[70301]={'321[1]:69.8,40.8'}
G[70316]={'928:51.42,46.18 N:61021'}
G[70320]={'934[1]:35.76,79.84 N:61021'}
G[70358]={'810:50.79,73.38'}
G[70360]={'810:49.93,69.04 N:30115'}
G[70370]={'928:34.60,89.43 N:4968'}	-- Phase 1 position on ship, Phase 2 is NPC 67992
G[70398]={'807:58.92,46.92'}
G[70476]={'873:75.29,76.28 N:64616'}
G[70517]={'928:31.56,83.13 N:20735'}	-- Phase 1 position.  Phase 2 is NPC 570517.
G[70520]={'928:36.72,64.78 N:37527'}	-- phase 2 location	[TODO: Deal with location 928:32.44,35.56 which is at camp when not in the field]
G[70551]={'928:58.78,42.69 N:70358'}
G[70552]={'928:58.70,42.69 N:67998'}
G[70561]={'928:32.45,35.23 N:70567'}
G[70567]={'928:63.24,72.20'}
G[70751]={'925[1]:60.42,77.43'}
G[70752]={'922[2]:52.33,25.38'}	-- 922[2]:54.33,27.92
G[70859]={'941:48.74,65.30 N:4949'}
G[70860]={'941[1]:43.13,41.33'}
G[70902]={'947[15]:60.09,31.98'}
G[70909]={'941:30.90,25.82 N:79917'}
G[70910]={'941:46.40,32.16 N:79917'}
G[70941]={'941[8]:50.60,54.38 N:79917'}
G[70978]={'4:49.69,40.08 N:38966'}
G[70980]={'809:44.97,47.84'}
G[71027]={'4:54.41,9.80 N:55283'}	-- 13:59.53,46.21
G[71143]={'951:33.80,81.59'}
G[71148]={'4:56.39,73.41 N:38966'}
G[71150]={'4:49.75,40.06 N:56133'}
G[71320]={'4:51.79,39.29 N:38243'}
G[71322]={'4:51.79,39.29 N:38243'}	-- this was 71320 until 32810 was turned in
G[71333]={'4:55.03,73.30'}
G[71336]={'811:85.74,59.56'}
G[71352]={'806:58.76,59.20 N:64616'}
G[71424]={'873:73.25,79.63 N:64616'}
G[71426]={'873:75.25,76.32 N:64616'}
G[71483]={'811:62.2,23.8'}
G[71502]={'947:52.03,32.66'}
G[71641]={'947:41.29,55.11'}
G[71823]={'951:44.82,71.98'}
G[71864]={'951:59.06,48.85'}
G[71868]={'951[22]:42.39,70.47'}
G[71869]={'951[22]:62.15,35.29'}
G[71876]={'951[22]:52.87,56.35 N:71869'}
G[71908]={'951:40.39,77.78'}
G[71919]={'951:37.30,78.12'}
G[71939]={'951:21.92,39.75'}
G[71940]={'951:23.09,71.07'}
G[71953]={'951:37.38,55.25'}
G[71955]={'951:34.16,47.49'}
G[71986]={'951:19.13,63.76'}
G[72007]={'951:59.45,40.75'}
G[72045]={'951:26.26,38.58'}
G[72049]={'951:43.57,69.84'}
G[72160]={'38:74.06,44.41'}
G[72193]={'951:33.78,83.32'}
G[72230]={'941:57.14,41.49 N:74651'}
G[72245]={'951:47.36,88.12'}
G[72274]={'941:38.54,52.43'}
G[72297]={'941:68.49,22.45'}
G[72348]={'941:71.71,24.66'}
G[72373]={'941:63.22,60.03'}
G[72413]={'947:77.46,37.61'}
G[72426]={'951:40.93,73.45'}
G[72571]={'950:45.45,35.87'}
G[72623]={'947:29.47,24.55'}
G[72637]={'947:29.26,25.70 N:78430'}
G[72654]={'1024:49.41,39.27'}
G[72695]={'951:34.52,53.84 N:64616'}
G[72723]={'811:83.17,29.65 N:64616'}
G[72751]={'951:49.37,69.41 N:1181758'}
G[72754]={'951:34.57,26.67 N:1181758'}
G[72755]={'951:66.06,23.26'}
G[72761]={'951:43.69,53.29'}
G[72762]={'951:43.05,69.04'}
G[72764]={'951:22.31,67.95'}
G[72765]={'951:23.35,33.03'}
G[72767]={'951:28.39,28.31'}
G[72769]={'951[22]:58.81,27.50'}
G[72771]={'951[22]:67.13,22.78'}
G[72775]={'951:65.82,72.98'}
G[72777]={'951:64.77,70.72'}
G[72805]={'951:65.16,55.89'}
G[72807]={'951:51.04,45.83'}
G[72808]={'951:54.64,44.49'}
G[72814]={'941:31.46,16.25 N:78430'}
G[72822]={'950:49.30,47.99 N:3432'}
G[72836]={'941:31.82,11.83 N:78430'}
G[72837]={'941:31.75,11.77'}
G[72841]={'951:29.74,36.90'}
G[72842]={'Z951'}
G[72843]={'Z951'}
G[72844]={'Z951'}
G[72870]={'951:34.58,53.59'}
G[72874]={'941:31.73,11.88 N:78558'}
G[72875]={'951:52.85,75.52'}
G[72876]={'951:56.33,58.82'}
G[72890]={'941:30.79,41.51'}
G[72892]={'951:54.19,75.65'}
G[72894]={'951:52.05,82.57'}
G[72895]={'951:68.27,35.51'}
G[72897]={'951:33.30,34.38'}
G[72908]={'951:40.44,69.08'}
G[72909]={'951:38.74,70.08'}
G[72939]={'321[1]:38.94,46.84'}
G[72940]={'Near941 N:72274'}
G[72970]={'951:62.67,62.81'}
G[72976]={'941:66.03,49.09'}
G[72997]={'951:39.13,46.77 N:62295'}
G[73018]={'951:41.91,73.55'}
G[73021]={'951:37.05,76.37'}
G[73025]={'951:35.59,77.47'}
G[73082]={'951:34.72,59.68'}
G[73097]={'Near941 N:72373'}
G[73136]={'811:67.43,45.84 N:54961'}
G[73138]={'873:54.74,72.72 N:64616'}
G[73157]={'951[22]:48.85,33.45'}
G[73158]={'951:31.07,52.46'}
G[73160]={'Z951'}
G[73161]={'951:24.25,52.64'}
G[73162]={'951[22]:61.08,49.30'}
G[73163]={'951:42.85,69.42'}
G[73166]={'951:22.36,36.25'}
G[73167]={'951:68.47,58.31'}
G[73169]={'951:52.81,82.47'}
G[73170]={'951:56.65,75.84'}
G[73171]={'951:65.88,42.07'}
G[73172]={'951:43.70,34.93'}
G[73173]={'951:42.54,25.71'}
G[73175]={'951:54.69,53.91'}
G[73277]={'951:68.43,44.81'}
G[73279]={'951:14.52,45.19'}
G[73281]={'951:26.06,22.85'}
G[73282]={'951:65.46,30.18'}
G[73284]={'941:67.13,49.16'}
G[73293]={'951:41.25,47.28'}
G[73303]={'951:42.86,55.20'}
G[73318]={'953[12]:50.08,60.07 N:54961'}
G[73325]={'941:22.82,9.39'}
G[73335]={'953[12]:50,60'}
G[73343]={'951:46.77,46.90'}
G[73348]={'951:23.12,71.65'}
G[73353]={'951:22.01,40.93'}
G[73360]={'941:44.63,43.38'}
G[73373]={'941:21.18,41.61'}
G[73395]={'947:46.38,38.62 N:78994'}
G[73425]={'947:40.60,54.82'}
G[73426]={'1018:49.07,82.34'}
G[73468]={'947:23.08,24.38'}
G[73480]={'941:21.95,14.64 N:77417'}
G[73570]={'951:65.00,50.60'}
G[73626]={'951:34.68,60.32'}
G[73649]={'951:34.69,52.85'}
G[73657]={'951:41.79,63.73'}
G[73666]={'951:35.79,35.39'}
G[73691]={'811:80.65,33.16 N:10667'}
G[73703]={'951:70.53,80.95'}
G[73877]={'947:47.09,14.40','In cave'}
G[73953]={'947:36.39,19.28 N:76748'}
G[73973]={'947:39.81,18.69 N:77270'}
G[74000]={'941:36.00,25.77 N:79917'}
G[74009]={'688[1]:48.47,12.06 43:16.52,11.03>688 N:44375'}
G[74020]={'811[4]:41.15,43.29'}
G[74043]={'947:49.12,38.51 N:17468'}
G[74056]={'823:48.99,88.33'}
G[74121]={'947:42.14,57.36'}
G[74125]={'949:54.23,55.93'}
G[74146]={'947:42.39,18.51'}
G[74148]={'947:41.76,15.04'}
G[74163]={'941:48.62,64.71 N:70860'}
G[74222]={'941:35.92,25.72'}
G[74223]={'941:46.40,32.04'}
G[74224]={'947:41.46,15.80'}
G[74233]={'947:62.46,36.83'}
G[74253]={'941:57.65,41.58 N:74272'}
G[74254]={'941[2]:50.83,70.15'}
G[74272]={'941:16.78,57.83'}
G[74273]={'941[1]:43.55,23.12 N:70860'}
G[74330]={'941:70.06,38.17 N:74272'}
G[74343]={'947:46.63,37.34'}
G[74358]={'941:41.61,52.91'}
G[74367]={'760[1]:24.52,23.72 61:47.56,23.60>760 N:44837'}
G[74408]={'688[1]:48.46,11.73 43:16.52,11.03>688 N:12736'}
G[74409]={'688[2]:87.49,86.16 N:44375'}
G[74434]={'760[1]:44.37,59.74'}
G[74476]={'688[1]:12.15,41.29'}
G[74507]={'941:19.04,58.36'}
G[74547]={'947:47.04,14.35','In cave'}
G[74565]={'688[1]:54.73,59.05'}
G[74593]={'949:46.58,71.48 N:74651'}
G[74594]={'949:37.28,77.01 N:70860'}
G[74606]={'949:41.45,74.10'}
G[74611]={'949:40.49,71.95'}
G[74635]={'941:24.50,28.81'}
G[74651]={'941:20.80,57.93'}
G[74741]={'947:42.86,40.38'}
G[74790]={'964[1]:66.46,20.89'}
G[74808]={'976:50.82,37.58 N:4949'}
G[74877]={'947:34.21,63.25 N:78994'}
G[74888]={'760[1]:36,70 61:47.56,23.60>760 N:44837'}
G[74927]={'964[1]:64.95,24.79'}
G[74977]={'941:64.97,39.49'}
G[75005]={'947:46.04,38.92'}
G[75008]={'949:41.42,66.11'}
G[75028]={'946:49.79,48.65 N:79537'}
G[75043]={'947:49.43,36.83'}
G[75119]={'946:55.67,67.69 N:79537'}
G[75121]={'946:55.50,67.68'}
G[75127]={'949:52.84,59.69 N:78554'}
G[75136]={'949:63.17,52.40 N:78568'}
G[75145]={'947:52.23,46.05 N:78554'}
G[75146]={'949:63.22,52.26 N:79576'}
G[75155]={'688[2]:84.90,86.10'}
G[75176]={'941[1]:43.13,23.26 N:70860'}
G[75177]={'941[1]:34.22,72.94 N:70860'}
G[75186]={'941[2]:70.75,78.58 N:4949'}
G[75188]={'941[3]:66.41,56.49 N:70860'}
G[75191]={'964[1]:45.14,48.03'}
G[75207]={'949:63.27,54.51'}
G[75246]={'946:61.00,72.53 N:75121'}
G[75249]={'946:60.52,72.40 N:78577'}
G[75250]={'946:57.24,77.05 N:79537'}
G[75256]={'946:57.18,76.93 N:78519'}
G[75273]={'946:56.98,82.90'}
G[75283]={'946:76.27,42.72'}
G[75288]={'946:70.50,56.84'}
G[75290]={'946:76.30,42.85'}
G[75311]={'946:77.75,43.97'}
G[75323]={'946:70.53,57.32'}
G[75324]={'946:70.77,56.78'}
G[75389]={'946:42.96,76.23 N:75121'}
G[75392]={'946:42.89,76.08 N:79537'}
G[75469]={'946:82.64,37.78 N:75311'}
G[75483]={'947:65.82,36.32'}
G[75593]={'949:42.66,37.82'}
G[75606]={'688[1]:48.47,12.06 43:16.52,11.03>688 N:33260'}
G[75607]={'688[1]:48.46,11.73 N:33256'}
G[75710]={'949:47.55,94.09 N:14627'}
G[75747]={'946:63.04,23.45'}
G[75752]={'946:61.40,27.94'}
G[75753]={'946:61.32,27.86'}
G[75803]={'946:69.57,20.46 N:78554'}
G[75804]={'946:69.55,20.52 N:78994'}
G[75805]={'946:54.18,36.42 N:78558'}
G[75806]={'946:61.51,10.95 N:70860'}
G[75808]={'946:58.93,20.15 N:74651'}
G[75815]={'946:55.26,18.09'}
G[75819]={'949:42.76,63.01'}
G[75873]={'946:62.06,10.41 N:3391'}
G[75874]={'946:69.38,20.34 N:78568'}
G[75878]={'949:47.71,93.31 N:78994'}
G[75884]={'947:45.70,26.31'}
G[75896]={'946:73.07,38.74'}
G[75913]={'946:76.72,55.24 N:75896'}
G[75924]={'946:58.95,20.72 N:3391'}
G[75941]={'946:55.68,41.16 N:3391'}
G[75942]={'Near946 N:75968'}
G[75958]={'946:58.91,20.20 N:70860'}
G[75959]={'946:55.60,40.95 N:70860'}
G[75968]={'946:61.79,38.88'}
G[76067]={'947:40.60,54.94 N:78994'}
G[76111]={'19:51.79,28.72 N:9540'}
G[76186]={'947:45.79,26.29'}
G[76200]={'947:56.96,57.49'}
G[76204]={'947:53.60,57.28 N:45417'}
G[76240]={'941:19.74,44.76 N:70860'}
G[76266]={'989[2]:53.59,35.76'}
G[76267]={'989[2]:46.50,30.33'}
G[76292]={'989[2]:47.52,37.27'}
G[76407]={'947:0.00,0.00'}
G[76411]={'976:49.71,49.64 N:74272'}	-- garrison level 1 location
G[76447]={'947:45.49,37.72'}
G[76452]={'941:64.74,39.75'}
G[76484]={'941:76.15,55.16 N:70860'}
G[76487]={'941:73.43,58.83 N:72274'}
G[76492]={'941:76.32,54.98'}
G[76508]={'950:40.75,12.96'}
G[76517]={'949:52.40,78.35'}
G[76518]={'969[3]:37.44,36.94'}
G[76534]={'949:53.13,79.74'}
G[76552]={'947:46.36,38.62 N:79795'}
G[76557]={'941:20.94,57.92 N:70860'}
G[76609]={'19:48.73,31.88 N:41124'}
G[76616]={'941:17.67,56.70 N:74272'}
G[76622]={'941:70.07,38.27 N:4949'}
G[76662]={'941:24.14,39.32'}
G[76665]={'946:65.42,50.73'}
G[76668]={'946:68.69,56.80'}
G[76687]={'946:30.91,70.74'}
G[76688]={'949:46.27,69.28 N:74611'}
G[76720]={'941[6]:53.24,56.18 N:4949'}
G[76725]={'941:76.15,55.16 N:74222'}
G[76730]={'941:76.32,54.98'}
G[76746]={'941[1]:42.77,44.74'}
G[76748]={'947:36.39,19.26'}
G[76790]={'946[13]:52.20,38.77'}
G[76804]={'946:50.01,48.61 N:75121'}
G[76826]={'946:36.20,65.05'}
G[76862]={'941:19.23,59.18'}
G[76872]={'976:43.08,57.13'}
G[76889]={'941:19.53,51.01'}
G[76904]={'946:58.84,12.07'}
G[76926]={'946:63.10,26.06'}
G[76941]={'941:21.63,55.08'}
G[76947]={'946:57.68,84.53'}
G[76969]={'946:57.44,85.27'}
G[76987]={'949:39.32,71.99 N:74606'}
G[76998]={'951:25.45,27.15'}
G[77014]={'949:36.85,67.91'}
G[77031]={'946:56.89,25.97'}
G[77051]={'946:44.61,90.76'}
G[77082]={'946:44.84,90.51'}
G[77093]={'949:53.48,70.74'}
G[77106]={'941:84.11,65.10'}
G[77120]={'995[3]:14.23,45.38 N:45658'}
G[77147]={'941:84.11,65.11'}
G[77160]={'941:86.39,48.92 N:14627'}
G[77161]={'971:64.69,67.37 N:78568'}
G[77167]={'Near941 N:78568'}
G[77184]={'962:64.28,47.02 N:78558'}
G[77209]={'971:41.22,49.31 N:79243'}	-- garrison level 1 location
G[77210]={'941:83.21,62.76'}
G[77211]={'947:46.11,25.49'}
G[77217]={'971:64.50,69.86'}
G[77221]={'321[1]:53.84,78.82'}
G[77270]={'947:46.27,15.88'}
G[77282]={'947:46.37,38.69 N:17468'}
G[77312]={'947:52.23,46.04 N:78554'}
G[77354]={'971:46.99,59.27'}	-- plot 18
G[77356]={'971:46.99,59.27'}	-- plot 18
G[77359]={'971:46.99,59.27'}	-- plot 18
G[77363]={'971:46.99,59.27'}	-- plot 18
G[77365]={'971:46.99,59.27'}	-- plot 18
G[77367]={'971:40.09,56.58'}	-- plot 24
G[77372]={'971:46.99,59.27'}	-- plot 18
G[77377]={'971:40.09,56.58'}	-- plot 24
G[77378]={'971:46.99,59.27'}	-- plot 18
G[77382]={'971:46.99,59.27'}
G[77383]={'971:46.99,59.27'}	-- location is top of stairs for plot 18
G[77417]={'947:19.08,28.56'}
G[77426]={'946:49.03,91.66'}
G[77434]={'946:49.23,87.95'}
G[77441]={'946:63.93,85.30'}
G[77528]={'946:35.64,79.86'}
G[77541]={'946:38.03,78.45'}
G[77548]={'946:34.50,71.50'}
G[77580]={'946:45.70,74.45 N:75121'}
G[77581]={'946:45.70,74.05 N:79537'}
G[77582]={'946:31.21,73.60 N:78519'}
G[77614]={'946:46.24,54.92'}
G[77629]={'946:34.01,73.97'}
G[77730]={'971:65.22,41.84'}	-- garrison level 2 location ? 65.07,42.01
G[77733]={'971:54.52,13.92'}	-- garrison level 2 location, though he moves about a bit
G[77734]={'984[1]:48.02,33.15'}
G[77737]={'946:62.15,63.74'}
G[77775]={'971:46.99,59.27'}	-- plot 18
G[77777]={'971:46.99,59.27'}	-- plot 18
G[77778]={'971:46.99,59.27'}	-- plot 18
G[77781]={'971:46.99,59.27'}	-- plot 18
G[77784]={'946:49.19,92.28','Top of lift'}
G[77789]={'Near'}
G[77791]={'971:46.99,59.27'}	-- plot 18
G[77792]={'971:46.99,59.27'}	-- plot 18
G[77799]={'946:43.42,75.96 N:77082'}
G[77831]={'971:46.99,59.27'}	-- plot 18
G[77853]={'946:84.55,31.70 N:19644'}
G[77857]={'948:51.19,50.56'}
G[77869]={'946:50.42,87.50 N:77737'}
G[77902]={'946:47.14,91.62'}
G[77905]={'984[1]:48.18,32.44'}
G[77911]={'941:82.64,69.83 N:77210'}
G[77928]={'941:78.18,55.14 N:3391'}
G[77940]={'941:84.27,52.26'}
G[77944]={'941:86.41,55.97'}
G[77945]={'941:87.43,52.82'}
G[77979]={'941:46.38,15.97'}
G[77980]={'941:47.01,16.88'}
G[77981]={'941:44.73,12.68'}
G[77982]={'947:59.22,82.25 N:21984'}
G[77988]={'941:42.55,14.80'}
G[77995]={'941:47.83,18.94'}
G[77998]={'941:43.62,15.52'}
G[78028]={'946:57.25,76.89 N:77737'}
G[78030]={'949:41.35,91.47'}
G[78056]={'941:48.70,14.70 N:78239'}
G[78082]={'946:50.39,87.32 N:81789'}
G[78083]={'946:50.51,87.55'}
G[78102]={'946:57.54,76.70'}
G[78116]={'39:55.07,49.60'}
G[78151]={'941:57.62,37.23'}
G[78168]={'947:57.98,88.72'}
G[78185]={'941:48.70,14.70 N:78239'}
G[78187]={'949:39.92,37.15 N:41006'}
G[78192]={'976:41.92,45.49 N:41005'}
G[78197]={'949:40.32,40.30'}
G[78207]={'971:46.99,59.27'}	-- location is top of stairs for plot 18
G[78208]={'941:52.63,40.42'}
G[78209]={'941:52.51,40.42'}
G[78210]={'941:86.58,55.85'}
G[78222]={'941[1]:20.12,52.81'}
G[78239]={'941:40.22,21.46'}
G[78251]={'949:54.16,56.07 N:41006'}
G[78257]={'949:52,54'}
G[78258]={'947:58.14,93.89 N:21984'}
G[78269]={'949[20]:0.00,0.00'}
G[78272]={'941:41.79,69.68 N:70860'}
G[78277]={'950:65.57,58.43'}
G[78278]={'950:76.14,53.08'}
G[78319]={'946[13]:49.84,34.19'}
G[78323]={'Near941 N:3391'}
G[78326]={'946:53.39,50.28'}
G[78327]={'946:51.19,51.52'}
G[78390]={'946:49.46,55.01'}
G[78428]={'941:39.43,23.46'}
G[78430]={'970:49.49,14.21'}
G[78457]={'946:56.41,64.73'}
G[78459]={'950:85.42,65.65'}
G[78466]={'976:52.46,53.40 N:3391'}	-- Garrison Level 1 position
G[78470]={'941:39.54,23.59 N:78239'}
G[78482]={'946:56.85,65.75'}
G[78487]={'976:51.28,51.48 N:26859'}	-- Garrison Level 1 position
G[78495]={'976:40.83,51.93 N:81890'}
G[78501]={'946:52.12,47.59'}
G[78513]={'946:51.65,50.51'}
G[78515]={'946:51.64,50.52'}
G[78519]={'946:56.51,67.13'}
G[78520]={'946:55.12,67.41 N:77737'}
G[78534]={'946:49.89,56.16'}
G[78538]={'946:51.62,50.48'}
G[78550]={'947:60.69,96.27'}
G[78553]={'970:50.05,13.34 N:4949'}
G[78554]={'970:71.49,62.70'}
G[78557]={'978:53.68,68.86'}
G[78558]={'970:54.73,48.26'}
G[78559]={'970:60.26,56.34 N:78558'}
G[78560]={'970:71.95,40.46 N:78558'}
G[78561]={'970[1]:81.32,50.20 N:78558'}
G[78562]={'970:49.51,14.41 N:78558'}
G[78563]={'970:44.40,80.68 N:78558'}
G[78564]={'971:37.34,36.88'}	-- TODO: Really these should be done only on the alias one that has them...wonder how to do that properly if it is even possible.
G[78568]={'970:44.07,29.68'}
G[78569]={'970:44.09,29.57 N:14627'}
G[78573]={'970:62.28,52.99'}
G[78577]={'946:55.57,67.01'}
G[78578]={'941:39.55,19.67'}
G[78659]={'941:51.82,16.75'}
G[78746]={'941:51.81,16.75 N:78659'}
G[78758]={'941[9]:73.43,21.18'}
G[78785]={'941:40.55,21.85 N:78659'}
G[78791]={'941:26.16,53.17'}
G[78792]={'941:39.54,23.59 N:78659'}
G[78810]={'941:38.00,14.80 N:78239'}
G[78821]={'941:37.56,14.12 N:78659'}
G[78870]={'941:25.70,51.70 N:78909'}
G[78882]={'947:58.14,93.89 N:21984'}
G[78883]={'970:54.07,48.78'}
G[78907]={'941:25.71,51.68 N:78909'}
G[78909]={'941:25.48,50.65'}
G[78910]={'941:28.54,50.52'}
G[78926]={'994[3]:51.13,45.14'}
G[78937]={'947:67.97,90.11 N:21984'}
G[78985]={'976:47.64,39.33'}
G[78989]={'941:41,52'}
G[78994]={'970:58.82,14.11'}
G[78996]={'970:43.04,26.36 N:74272'}
G[78999]={'947:58.96,84.82'}
G[79002]={'950:75.14,62.51'}
G[79022]={'950:82.49,79.85'}
G[79043]={'947:40.53,54.92 N:17468'}
G[79047]={'941:30.76,41.45 N:72890'}
G[79061]={'947:43.19,61.34'}
G[79070]={'950:81.28,70.34'}
G[79133]={'946:69.88,20.81'}
G[79159]={'946:69.26,19.29'}
G[79176]={'946:71.06,29.74'}
G[79187]={'946:37.25,79.37'}
G[79188]={'950:79.46,50.24'}
G[79201]={'950:71.13,52.35'}
G[79206]={'947:26.97,8.10 N:17468'}
G[79210]={'946:71.89,29.41'}
G[79229]={'941:59.44,31.79'}
G[79231]={'946:70.23,71.28'}
G[79234]={'946:69.53,71.22'}
G[79243]={'947:29.05,16.21'}
G[79252]={'976:49.54,36.31 N:78430'}	-- Garrison level 1 position
G[79263]={'950:86.38,66.20'}
G[79269]={'978:48.80,37.79'}
G[79281]={'950:83.06,67.97'}
G[79282]={'950:78.79,69.23'}
G[79310]={'950:78.58,48.57'}
G[79312]={'950:78.97,58.88'}
G[79315]={'970[1]:51.16,46.72'}
G[79316]={'970[1]:50.87,49.80'}
G[79320]={'949:42.76,63.06'}
G[79322]={'949:42.75,62.98'}
G[79329]={'946:70.14,20.12 N:80630'}
G[79331]={'949:42.70,63.08'}
G[79335]={'946:83.13,31.72'}
G[79337]={'949:42.76,63.01'}
G[79356]={'946:70.89,30.48 N:79210'}
G[79392]={'946:84.97,30.97'}
G[79393]={'946:84.19,30.31'}
G[79402]={'950[11]:42.52,41.39'}
G[79407]={'976:50.93,46.77'}
G[79415]={'941:21.76,56.41 N:70860'}
G[79416]={'949:41.34,72.69'}
G[79432]={'946:75.88,47.61'}
G[79434]={'946:46.32,74.09 N:77737'}
G[79457]={'971:44.09,53.29 N:78554'}	-- garrison level 1 location
G[79470]={'947:28.79,16.23 N:78554'}
G[79482]={'946:43.04,61.83'}
G[79492]={'971:61.38,74.95'}
G[79514]={'946:43.73,59.19'}
G[79519]={'948:43.64,12.93'}
G[79537]={'970:73.24,38.88'}
G[79539]={'948:37.89,18.02'}
G[79540]={'946[14]:37.92,49.47'}
G[79544]={'946:53.81,89.37'}
G[79567]={'947:28.92,16.40 N:78994'}
G[79573]={'946:69.48,21.45'}
G[79576]={'950:63.52,61.89'}
G[79581]={'950:39.55,73.04'}
G[79598]={'948:50.33,36.73'}
G[79604]={'946:71.44,29.61 N:70860'}
G[79608]={'946:69.67,21.08 N:78994'}
G[79609]={'976:51.18,31.72'}
G[79612]={'946:71.83,29.75'}
G[79618]={'946:69.65,21.61'}
G[79627]={'946:71.24,29.94'}
G[79635]={'947:26.94,8.07 N:17468'}
G[79661]={'970[1]:82.84,44.36'}
G[79674]={'950:63.06,61.95 N:78568'}
G[79675]={'970[1]:50.18,48.28 N:75121'}
G[79680]={'946:71.41,29.65'}
G[79681]={'947:62.56,62.57'}
G[79689]={'946:56.02,68.34 N:16554'}
G[79696]={'946:55.38,66.78'}
G[79703]={'946:60.67,55.19'}
G[79722]={'950:65.88,68.63'}
G[79724]={'946:71.22,47.48'}
G[79725]={'950:34.33,76.84'}
G[79740]={'976:53.92,54.98'}	-- Garrison Level 1 position
G[79743]={'950:66.76,68.66'}
G[79744]={'950:67.34,67.54'}
G[79748]={'948:40.08,43.94'}
G[79774]={'976:43.19,47.81 N:88228'}
G[79779]={'947:60.78,68.39'}
G[79795]={'970[1]:45.37,15.81'}
G[79813]={'976:52.44,37.06'}	-- plot 18 location
G[79814]={'976:52.44,37.06'}	-- plot 18 location
G[79815]={'976:60.36,36.51'}	-- plot 24 location
G[79817]={'976:52.44,37.06'}	-- plot 18 location
G[79820]={'976:52.44,37.06'}	-- plot 18 location
G[79821]={'976:52.44,37.06'}	-- plot 18 location
G[79826]={'976:52.44,37.06'}	-- plot 18 location
G[79829]={'976:52.44,37.06'}	-- plot 18 location
G[79830]={'976:52.44,37.06'}	-- plot 18 location
G[79831]={'976:52.44,37.06'}	-- plot 18 location
G[79832]={'976:52.44,37.06'}	-- plot 18 location
G[79833]={'976:52.44,37.06'}	-- plot 18 location
G[79834]={'976:52.44,37.06'}	-- plot 18 location
G[79836]={'976:61.97,35.39'}
G[79853]={'946:62.89,50.44'}
G[79857]={'976:52.44,37.06'}	-- plot 18 location
G[79858]={'976:32.18,41.68'}	-- garrison level 3 location ? 976:31.72,42.13
G[79862]={'976:52.44,37.06'}	-- plot 18 location
G[79863]={'976:52.44,37.06'}	-- plot 18 location
G[79864]={'976:52.44,37.06'}	-- plot 18 location
G[79867]={'976:52.44,37.06'}	-- plot 18 location
G[79870]={'946:64.21,47.80'}
G[79890]={'948:51.62,31.35'}
G[79892]={'976:38.10,72.21'}
G[79893]={'971:54.07,13.68'}
G[79895]={'948:51.03,33.21'}
G[79896]={'941:55.71,75.30'}
G[79897]={'Near950'}
G[79899]={'950:74.87,61.64 N:79897'}
G[79901]={'946:62.87,50.32'}
G[79917]={'970:41.83,41.67'}
G[79921]={'946:71.19,29.44'}
G[79930]={'946:71.41,20.75'}
G[79953]={'971:40.28,53.61'}	-- garrison level 1 location
G[79954]={'950:63.54,61.83 N:14627'}
G[79963]={'946:69.59,21.55'}
G[79966]={'947:39.82,29.40'}
G[79971]={'976:37,70'}
G[79973]={'948:43.75,25.40'}
G[79978]={'946:58.09,53.06'}
G[79979]={'946:57.42,51.12'}
G[80001]={'950:86.38,66.20'}
G[80003]={'950:82.84,45.07 N:4949'}
G[80005]={'993[4]:25.38,47.43'}
G[80028]={'946:61.35,54.40'}
G[80053]={'946:70.51,27.54'}
G[80057]={'950:75.51,65.35'}
G[80073]={'947:59.52,30.37 N:79537'}
G[80075]={'947:61.91,29.68'}	-- ? 56.24,32.61
G[80076]={'947:59.36,26.56'}
G[80078]={'947:56.51,23.59 N:72413'}
G[80079]={'947:56.49,23.53'}
G[80083]={'950:40.44,76.22'}
G[80103]={'946:81.36,27.92'}
G[80108]={'947:56.91,34.64 N:80075'}
G[80122]={'950:43.65,77.81'}
G[80140]={'950:82.93,44.14 N:11378'}
G[80142]={'946:74.98,31.20 N:78558'}
G[80148]={'947:56.93,34.72'}
G[80153]={'948:46.58,46.53 N:75288'}	-- 948:46.51,45.61
G[80155]={'948:36.97,24.49 N:75324'}
G[80157]={'948:36.88,24.57 N:75323'}
G[80159]={'971:36.86,64.77'}	-- garrison level 2 location ? 33.70,51.29
G[80161]={'950:85.42,54.60 N:18261'}
G[80163]={'971:48.96,42.25'}	-- garrison level 1 location ? 43.21,54.12
G[80165]={'947:43.56,77.29 N:79392'}
G[80178]={'948:47.10,31.63'}
G[80184]={'950:79.87,48.85'}
G[80191]={'950:85.62,55.09'}
G[80193]={'946:84.16,30.74 N:79393'}
G[80196]={'947:46.61,37.74'}
G[80205]={'950:85.66,55.26'}
G[80229]={'946:62.12,69.24 N:79210'}
G[80232]={'948:47.99,34.73 N:23066'}
G[80233]={'948:45.43,36.31'}
G[80248]={'947:46.41,25.23'}
G[80260]={'Near946 N:79392'}
G[80265]={'948:51.57,31.07 N:79519'}
G[80297]={'978:48.31,50.36'}
G[80319]={'950[10]:44.86,19.85 N:18261'}
G[80339]={'946:68.77,70.53 N:79210'}
G[80341]={'Near946 N:79210'}
G[80342]={'946:64.52,81.62 N:79210'}
G[80378]={'947:43.69,51.67'}
G[80389]={'Near946 N:79393'}
G[80390]={'946:68.31,70.33 N:79393'}
G[80396]={'946:62.25,68.29 N:79393'}
G[80429]={'950:68.57,64.43 N:79627'}
G[80434]={'950:75.07,22.74'}
G[80451]={'950:68.59,64.46'}
G[80456]={'941:21.04,57.91 N:74272'}
G[80469]={'948:45.40,36.74 N:85320'}
G[80470]={'948:45.40,36.74'}
G[80481]={'948:52.10,49.95'}
G[80508]={'948:44.49,24.01'}
G[80521]={'970:40.07,48.50 N:78568', 'On top of tank'}	-- WoD 40.10,48.42
G[80552]={'946:58.01,29.37'}
G[80553]={'946:71.17,29.88 N:79393'}
G[80568]={'971:47.01,50.94 N:78994'}	-- garrison level 1 location
G[80586]={'950:70.46,9.75','In cave'}
G[80589]={'948:55.77,54.68'}
G[80593]={'950:71.34,17.88'}
G[80595]={'950:72.78,19.71'}
G[80597]={'950:71.66,19.74 N:74272'}
G[80606]={'947:53.38,68.00'}
G[80607]={'946:61.95,69.28 N:79392'}
G[80608]={'946:69.95,69.45 N:79392'}
G[80617]={'Near946 N:79392'}
G[80623]={'946:71.19,29.85 N:79210'}
G[80624]={'950:63.50,61.85 N:79743'}
G[80627]={'946:62.57,67.87 N:80630'}
G[80628]={'946:69.63,69.85 N:80630'}
G[80630]={'946:64.52,81.77'}
G[80632]={'Near946 N:80630'}
G[80635]={'947:55.67,71.98'}
G[80639]={'948:48.98,48.99'}
G[80640]={'948:68.64,41.67'}
G[80643]={'948:66.39,44.64'}
G[80645]={'971:43.17,44.75 N:78430'}	-- garrison level 2 location
G[80648]={'948:46.78,45.96'}
G[80672]={'946:69.74,20.79 N:79392'}
G[80685]={'949:47,65'}
G[80689]={'949:45,64'}
G[80690]={'949:46.62,71.52'}
G[80696]={'949:47,64'}
G[80707]={'947:53.11,65.38'}
G[80714]={'949:58,60'}
G[80725]={'949:41,60'}
G[80727]={'947:53.69,57.28 N:80635'}
G[80740]={'948:54.86,54.23'}
G[80744]={'949:61.73,52.35'}
G[80746]={'948:52.09,49.41'}
G[80747]={'950:37.20,55.65'}
G[80757]={'949:57.20,61.95'}
G[80758]={'948:62.20,42.62'}
G[80761]={'947:53.45,57.31 N:46022'}
G[80762]={'949:59.32,56.36 N:82476'}
G[80782]={'941:54.27,67.46'}
G[80785]={'949:58,63'}
G[80803]={'970:71.92,62.06'}
G[80827]={'947:45.18,38.83'}
G[80833]={'946:70.84,29.62'}
G[80834]={'948:60.48,38.75'}
G[80854]={'946:69.43,21.14'}
G[80856]={'949:46.07,54.75 N:21984'}
G[80859]={'947:52.60,59.70'}
G[80860]={'948:54.85,54.28 N:80481'}
G[80863]={'948:54.83,54.18 N:80746'}
G[80864]={'950:40.43,56.79 N:80434'}
G[80865]={'947:53.66,57.25 N:45429'}
G[80866]={'950:40.40,56.74'}
G[80874]={'949:64.99,48.53 N:78568'}
G[80895]={'947:55.05,68.20 N:16134'}
G[80907]={'947:54.18,70.76'}
G[80921]={'949:64.21,51.94 N:79576'}
G[80922]={'949:64.20,51.77 N:80987'}
G[80964]={'950:55.97,43.17'}
G[80965]={'946:71.33,29.60 N:79393'}
G[80966]={'946:69.60,21.07 N:79392'}
G[80968]={'946:69.78,20.74 N:80630'}
G[80978]={'949:63.99,57.20 N:78994'}
G[80987]={'949:63.14,52.29'}
G[81019]={'950:46.79,57.39'}
G[81038]={'949:42.01,46.83'}
G[81039]={'950:61.98,40.55'}
G[81043]={'949:41.91,46.90'}
G[81054]={'950:52.37,63.51'}
G[81072]={'950:52.10,68.10'}
G[81076]={'949:52.84,59.87'}
G[81086]={'950:55.50,42.09'}
G[81097]={'950:55.44,42.09'}
G[81103]={'971:43.12,44.89 N:352'}
G[81109]={'948:61.47,72.93'}
G[81123]={'950:62.13,40.43'}
G[81126]={'947:45.81,37.33'}
G[81128]={'948:61.45,72.96'}
G[81134]={'950:56.09,43.79'}
G[81140]={'947:61.86,29.14'}
G[81144]={'950:84.06,76.84'}
G[81152]={'947:40.64,54.88'}
G[81153]={'947:40.66,54.87 N:81152'}
G[81166]={'976:45.41,50.63'}
G[81173]={'947:35.38,36.95'}
G[81176]={'947:35.84,36.96'}
G[81185]={'949:54.82,65.29'}
G[81186]={'950:48,48 N:70860'}
G[81189]={'950:82.88,45.07 N:35875'}
G[81193]={'950:49.38,47.84'}
G[81194]={'950:55.49,42.19'}
G[81195]={'950:56.06,43.76'}
G[81202]={'949:43.56,65.01'}
G[81207]={'949:47.20,55.13'}
G[81209]={'941:38.03,47.46'}
G[81210]={'941:37.75,47.48'}
G[81216]={'950:51.82,58.79'}
G[81218]={'949:54.45,66.66 N:80757'}
G[81230]={'950:46.81,57.51'}
G[81240]={'949:43,48'}
G[81241]={'949:58.91,62.52 N:80757'}
G[81280]={'950:63.08,61.94'}
G[81284]={'947:57.48,57.28'}
G[81292]={'947:44.92,38.51'}
G[81308]={'950[12]:46.32,32.68'}
G[81319]={'950:82.86,45.02 N:74651'}
G[81324]={'947:56.72,23.44'}
G[81335]={'950:55.57,55.91 N:74272'}
G[81346]={'971:44.84,53.01'}
G[81347]={'971:43.15,45.74'}
G[81361]={'950:83.79,76.84'}
G[81409]={'950:58.60,59.82'}
G[81412]={'950:66.97,33.75 N:81039'}
G[81415]={'950:66.94,33.79 N:70860'}
G[81443]={'948:58.48,92.20 N:55521'}
G[81492]={'971:38.26,36.73'}	-- garrison level 2 location, using for garrison level 3 location as well which is so close: 971:38.30,37.01
G[81499]={'947:49.80,81.49'}
G[81514]={'948:61.93,42.24'}
G[81518]={'949:45.94,52.69'}
G[81528]={'949:42.50,59.69'}
G[81529]={'949:38.96,51.16'}
G[81530]={'947:50.00,81.22'}
G[81537]={'949:51.71,66.37'}
G[81540]={'949:51.83,41.28'}
G[81541]={'947:49.28,78.12'}
G[81542]={'947:48.89,81.11'}
G[81543]={'947:47.81,80.37'}
G[81548]={'949:46.12,46.69'}
G[81561]={'949:45.42,77.56'}
G[81575]={'949:42.06,79.23'}
G[81588]={'949:46.08,76.85 N:78568'}
G[81589]={'949:46.11,76.65 N:80987'}
G[81590]={'949:46.05,76.67 N:78994'}
G[81600]={'949:42.11,83.44 N:47267'}
G[81601]={'Near949 N:47267'}
G[81617]={'949:49.42,70.93'}
G[81627]={'947:55.96,32.84'}
G[81630]={'949:47,72'}
G[81631]={'949:49.47,70.94'}
G[81634]={'949:49.46,70.94'}
G[81637]={'947:46.57,77.91'}
G[81659]={'949:47.61,72.74'}
G[81674]={'949:45.87,54.97'}
G[81678]={'941[1]:28.28,45.72'}
G[81685]={'949:45.6,58.8'}
G[81688]={'976:62.05,73.88'}
G[81691]={'949[16]:48.77,30.10'}
G[81697]={'947:46.04,80.57'}
G[81718]={'950:51.37,56.11'}
G[81721]={'949:49.50,48.62'}
G[81731]={'949:49.36,49.66'}
G[81738]={'949:51.89,49.93'}
G[81747]={'949:51.03,51.60'}
G[81749]={'949:54.25,52.55'}
G[81751]={'949[17]:50.10,22.41 N:14627'}
G[81761]={'970:62.20,52.93'}
G[81762]={'970:62.27,52.97'}
G[81763]={'970:62.21,52.94'}
G[81765]={'1011:62.10,23.02'}
G[81770]={'948:48.56,44.48 N:79519'}
G[81772]={'949:47.78,93.27 N:80987'}
G[81773]={'948:59.12,79.18 N:81109'}
G[81775]={'949:48.29,47.60'}
G[81784]={'948:59.10,79.22 N:81128'}
G[81789]={'946:55.64,67.77'}
G[81790]={'950:82.58,46.76 N:18261'}
G[81791]={'949:48.13,94.64'}
G[81794]={'950:64.23,59.57 N:81280'}
G[81797]={'950:82.60,46.63 N:18261'}
G[81858]={'947:50.60,82.57'}
G[81870]={'978:45.97,76.23'}
G[81875]={'948:35.49,25.90'}
G[81890]={'948:45.94,46.32'}
G[81891]={'948:45.90,46.36 N:81960'}
G[81902]={'950:89.37,47.38'}
G[81912]={'947:55.99,32.61'}
G[81913]={'948:40.03,44.04 N:81890'}
G[81915]={'948:39.99,60.47 N:81960'}
G[81920]={'948:40.20,43.57'}
G[81929]={'948:39.90,60.87'}
G[81942]={'949:39.84,80.81'}
G[81947]={'976:62.87,34.81'}
G[81948]={'971:40.53,54.00 N:79316'}
G[81949]={'948:39.79,60.68 N:81960'}
G[81953]={'950:51.31,61.59 N:74272'}
G[81955]={'950:79.22,52.65'}
G[81959]={'948:40.27,43.43 N:81890'}
G[81960]={'948:39.13,48.94'}
G[81961]={'948:39.19,48.95 N:81890'}
G[81964]={'948:39.48,61.60 N:81960'}
G[81972]={'948:58.48,92.33 N:81109'}
G[81978]={'948:58.82,92.84 N:81109'}
G[81981]={'976:43.86,83.12'}
G[81987]={'947:55.94,32.90 N:72413'}
G[82029]={'948:38.86,50.05'}
G[82037]={'947:29.01,16.24'}
G[82055]={'948:39.47,52.29'}
G[82070]={'950:71.58,19.72 N:74272'}
G[82078]={'950:82.55,43.97'}
G[82080]={'950:82.60,43.95'}
G[82086]={'949:48.21,71.48'}
G[82092]={'950:63.53,61.42'}
G[82094]={'950:63.48,61.40'}
G[82100]={'948:38.92,48.82'}
G[82101]={'948:38.94,48.86 N:82100'}
G[82104]={'941:59.45,31.80'}
G[82112]={'947:56.93,34.71'}
G[82119]={'950:65.02,58.31'}
G[82123]={'948:32.57,29.05'}	-- ?? 962:41.74,71.49
G[82124]={'948:37.70,51.06','Upstairs in inn'}
G[82126]={'948:37.54,50.76 N:82124','Downstairs in inn'}
G[82138]={'950:71.72,19.65 N:78482'}
G[82179]={'950:55.52,55.92 N:78482'}
G[82181]={'950[12]:46.10,32.79 N:78482'}
G[82194]={'948:37.70,53.81'}
G[82196]={'947:46.07,59.13'}
G[82212]={'948:37.67,53.87'}
G[82214]={'950:71.54,19.76 N:78482'}
G[82222]={'949:52.28,48.97 N:81731'}
G[82225]={'949:52.86,51.73 N:81731'}
G[82227]={'947:58.05,57.64'}
G[82228]={'949:42.06,85.92 N:74606'}
G[82233]={'949:42.05,85.82 N:74651'}
G[82252]={'950:62.14,62.08'}
G[82254]={'949:43.72,84.00'}
G[82256]={'947:49.02,38.62'}
G[82270]={'19:66.59,28.25 N:78554'}
G[82274]={'Near949 N:82254'} -- 949:43.07,83.73
G[82277]={'948:37.75,53.75 N:82194'}
G[82278]={'948:37.69,53.87 N:82212'}
G[82293]={'948:37.60,53.95 N:82212'}
G[82302]={'949:50.33,47.45'}
G[82318]={'947:54,21'}
G[82334]={'949:48.05,94.16 N:82254'}	-- seems Blizzard took this out of a dungeon map 949[17]:50.09,22.35
G[82337]={'949:47.71,93.31 N:74651'}
G[82338]={'949:47.78,93.27 N:74606'}
G[82348]={'947:56.19,32.38 N:78554'}
G[82366]={'947:53.37,67.50'}
G[82375]={'948:36.82,56.94 N:55122'}
G[82402]={'948:36.88,56.67 N:81890'}
G[82403]={'948:36.84,56.78 N:81960'}
G[82437]={'949:59.52,65.93'}
G[82439]={'949:47.64,72.74'}
G[82447]={'19:52.00,28.52'}
G[82466]={'971:47,45'}
G[82468]={'948:61.59,72.85 N:81109'}
G[82476]={'949:58.26,59.90'}
G[82477]={'949:58.97,62.50 N:82476'}
G[82486]={'950:89.00,40.94'}
G[82496]={'947:54,45'}
G[82497]={'947:55,41'}
G[82499]={'949:59.51,57.90'}
G[82509]={'948:47.12,45.85 N:75323'}
G[82537]={'947:56.69,23.01'}
G[82569]={'949:57.05,71.93'}
G[82574]={'949:55.93,71.54 N:85147'}
G[82575]={'949:55.93,71.54 N:85119'}
G[82599]={'950:69.93,52.50'}
G[82610]={'949:46.26,66.70'}
G[82612]={'948:39.55,43.34'}
G[82616]={'941:48.51,24.39'}
G[82621]={'948:50.28,36.70 N:79519'}
G[82622]={'948:41.11,42.89'}
G[82658]={'950:71.11,52.42'}
G[82660]={'978:44.77,74.61'}
G[82664]={'948:39.35,59.82'}
G[82669]={'948:39.24,62.84'}
G[82688]={'950:74,36'}
G[82691]={'948:40.00,43.20'}
G[82709]={'948:39.60,61.20 N:9296'}
G[82713]={'948:56.01,40.85'}
G[82720]={'948:46.54,45.61 N:75288'}
G[82727]={'950:78.29,52.59'}
G[82732]={'949:46.26,69.98'}
G[82746]={'950:67.14,56.04'}
G[82755]={'950:73.52,58.01'}
G[82758]={'950:66.88,51.21'}
G[82759]={'948:56.18,42.54'}
G[82764]={'950:52.48,55.76'}
G[82776]={'971:33.03,35.22'}	-- garrison level 3 location
G[82778]={'950:66.70,56.28'}
G[82786]={'948:60.07,53.55'}
G[82788]={'948:60.20,53.15'}	-- ? 948:60.06,53.63
G[82813]={'948:46.63,46.75'}
G[82816]={'949:44.29,61.65 N:21984'}
G[82826]={'950:76.98,64.34'}
G[82832]={'949:44.29,61.65 N:21984'}
G[82833]={'941:46.41,15.89'}
G[82851]={'19:71.82,47.75 N:4949'}
G[82881]={'947:60.96,24.44'}
G[82893]={'978:43.97,75.34'}
G[82901]={'978:44.79,74.99'}
G[82905]={'949:62.04,53.39'}
G[82909]={'978:43.30,76.66'}
G[82912]={'950:89.56,72.99'}
G[82920]={'946:31.38,27.05'}
G[82922]={'946:37.26,14.67'}
G[82928]={'946:38.18,12.34'}
G[82930]={'946:41.04,42.22'}
G[82942]={'946:33.48,37.91'}
G[82966]={'978:44.76,74.44'}
G[82975]={'950:74.89,11.83'}
G[82988]={'946:37.45,37.39'}
G[82996]={'946:33.54,37.06'}
G[83006]={'971:42.55,52.23'}
G[83008]={'946:47.88,25.17'}
G[83011]={'946:35.05,39.00'}
G[83017]={'946:38.23,12.32'}
G[83051]={'950:49.91,37.09'}
G[83052]={'950:49.90,37.08'}
G[83053]={'950:41.82,36.99'}
G[83054]={'950:41.82,36.99 N:79627'}
G[83058]={'951:25.46,27.21'}
G[83325]={'928:63.24,72.29'}
G[83405]={'949:44.59,61.31'}
G[83409]={'950:40.97,50.04'}
G[83428]={'950:70.40,29.46'}
G[83439]={'976:47.33,37.42'}
G[83448]={'949:50.87,79.91'}
G[83449]={'949:50.45,77.07'}
G[83450]={'949:50.44,76.99'}
G[83455]={'947:51.45,61.61'}
G[83458]={'949:45.6,58.8'}
G[83463]={'948:43.90,48.90'}
G[83482]={'976:47.24,38.11'}	-- garrison level 1 location
G[83489]={'949:45.60,52.82'}
G[83491]={'971:50.05,42.14'}	-- garrison level 1 location
G[83494]={'947:59.08,82.27'}
G[83504]={'976:47.33,37.42'}
G[83509]={'950:93.04,28.47'}
G[83526]={'950:57.87,84.02'}
G[83529]={'948:40.10,43.34 N:44637'}
G[83542]={'950:60.92,47.97'}
G[83549]={'948:39.67,60.85 N:83904'}
G[83569]={'949:46.04,54.75 N:21984'}
G[83570]={'950:36.48,14.52'}
G[83575]={'950:39.69,14.80'}
G[83577]={'950:35.41,19.88'}
G[83603]={'950:80.65,30.48'}
G[83606]={'950:82.85,46.73'}
G[83608]={'948:52.07,23.54 N:44637'}
G[83609]={'948:52.10,23.54 N:83904'}
G[83612]={'987[1]:68.97,41.17'}
G[83616]={'987[1]:68.41,46.78'}
G[83634]={'950:54.81,61.28'}
G[83653]={'948:54.03,23.30'}
G[83680]={'950:61.64,68.89'}
G[83686]={'950:39.63,24.61'}
G[83723]={'950:55.57,55.91 N:74272'}
G[83730]={'950:55.47,55.92 N:78482'}
G[83734]={'950:39.61,24.53 N:83686'}
G[83772]={'948:53.51,27.46 N:44637'}
G[83773]={'948:53.59,27.50 N:83904'}
G[83774]={'949:47.72,52.07'}
G[83820]={'949:44.93,86.88'}
G[83823]={'946:85.18,31.71 N:78558'}
G[83837]={'949:51.07,70.58'}
G[83846]={'1008[2]:50.52,66.32'}
G[83848]={'950:40.08,16.16'}
G[83858]={'971:39.18,42.70'}
G[83869]={'978:45.77,28.80'}
G[83888]={'950:53.70,15.01'}
G[83899]={'948:57.07,34.51 N:44637'}
G[83900]={'948:57.13,34.51 N:83904'}
G[83903]={'948:57.10,34.52 N:44637'}
G[83904]={'948:57.14,34.53'}
G[83929]={'946:84.80,31.52 N:78430'}
G[83940]={'948:58.08,36.31'}
G[83959]={'948:46.51,46.82 N:23066'}
G[83995]={'978:45.27,27.13'}
G[84002]={'947:59.51,94.46'}
G[84095]={'946:49.23,88.01'}
G[84122]={'948:46.65,46.75'}
G[84131]={'949:43.94,48.85 N:21984'}
G[84173]={'978:44.61,73.91'}
G[84176]={'949:38.77,73.61'}
G[84185]={'949:40.95,43.07 N:41006'}
G[84223]={'978:42.81,76.81 N:26814'}
G[84243]={'948:47.18,31.74'}
G[84247]={'941:48.80,67.39'}
G[84248]={'971:51.21,47.04'}	-- plot 25
G[84259]={'948:40.11,43.22'}
G[84261]={'948:39.67,60.87'}
G[84262]={'948:46.50,54.33 N:79519'}
G[84263]={'950:84.06,36.79'}
G[84268]={'971:28.73,35.04 N:79953'}	-- garrison level 3, but her location is 971:28.85,35.39 after the shipyard is upgraded to level 3 because there is a ship table in the garrison from that point on
G[84270]={'971:29.30,34.83 N:79243'}	-- garrison level 3
G[84276]={'948:51.35,50.28 N:79519'}
G[84286]={'971:40.35,61.17'}
G[84291]={'948:39.51,61.68 N:84261'}
G[84292]={'948:40.08,42.72 N:84259'}
G[84334]={'946:46.44,27.74'}
G[84347]={'950:77.05,16.63'}
G[84367]={'946:45.34,31.51'}
G[84372]={'947:26.95,7.27'}
G[84385]={'947:44.23,40.93'}
G[84407]={'950:79.19,52.66'}
G[84435]={'950:45.74,15.05'}
G[84459]={'950:49.42,16.59'}
G[84473]={'978:45.11,28.03'}
G[84492]={'947:44.98,39.18'}
G[84494]={'941:46,48'}
G[84499]={'1008[1]:0.00,0.00'}
G[84506]={'941:60.28,27.20'}
G[84511]={'971:31.43,33.68 N:79953'}
G[84523]={'947:58,26'}
G[84524]={'971:35.53,49.36'}	-- plot 22
G[84550]={'1008[1]:64.79,1.22'}
G[84554]={'1008[1]:65.35,1.64'}
G[84632]={'950:77.43,47.36'}
G[84637]={'950:62.97,36.00 N:18471'}
G[84660]={'978:47.14,26.66'}
G[84684]={'971:29.65,34.24 N:79953'}
G[84689]={'941:20,60'}
G[84702]={'950:77.13,36.87 N:78558'}
G[84706]={'950:88.41,22.48'}
G[84720]={'950:56.90,19.11'}
G[84724]={'947:57.85,21.53'}
G[84726]={'950:86.65,28.32'}
G[84728]={'947:58.31,20.84'}
G[84739]={'941:54.39,51.74 N:84966'}
G[84743]={'949:46.19,55.09 N:81202'}
G[84747]={'941:55.92,48.61'}
G[84748]={'949:43.93,48.82 N:81202'}
G[84764]={'950:56.95,18.46'}
G[84776]={'971:43,54'}
G[84784]={'950:56.77,12.90 N:22893'}
G[84807]={'948:47.28,29.18'}
G[84811]={'949:55.91,71.57'}
G[84825]={'947:60.86,32.64'}
G[84830]={'947:46.96,38.65'}
G[84837]={'978:36.49,37.79'}
G[84857]={'971:46.99,59.27'}	-- plot 18
G[84861]={'950:86.65,28.32'}
G[84866]={'948:43.73,47.07'}
G[84871]={'946:44.34,37.95'}
G[84889]={'947:29.88,18.21 N:84892'}
G[84892]={'950:75.73,66.74'}
G[84908]={'947:51.32,81.09'}
G[84911]={'947:46.03,71.41'}
G[84925]={'947:50.15,72.39'}
G[84928]={'19:48.73,31.78 N:4949'}
G[84929]={'19:51.93,28.65 N:78554'}
G[84945]={'947:48.69,78.86'}
G[84947]={'971:35.53,49.36'}	-- plot 22 location
G[84951]={'948:34.14,58.52'}
G[84963]={'947:35.66,72.26'}
G[84965]={'948:55.13,64.43'}
G[84966]={'947:37.34,72.60'}
G[84967]={'976:57.28,53.86'}	-- Garrison level 1 location
G[84973]={'947:74.90,57.99 N:72413'}
G[84974]={'947:75.13,57.89 N:79537'}
G[84975]={'947:75.19,57.53 N:80079'}
G[85043]={'948:69.88,20.73'}
G[85048]={'976:51.43,57.39'}	-- plot 22 location
G[85062]={'948:62.56,73.88'}
G[85068]={'948:72.94,32.13'}
G[85077]={'949:46.36,69.65 N:85147'}
G[85080]={'948:39.98,60.66 N:55122'}
G[85089]={'949:51.30,47.99 N:81731'}
G[85106]={'941:20.08,56.39'}
G[85119]={'949:53.02,59.81'}
G[85124]={'949:45.08,26.44'}
G[85127]={'949:46.45,30.32'}
G[85130]={'949:60.71,64.78 N:85119'}
G[85146]={'970[1]:81.32,50.20'}
G[85147]={'949:45.68,70.60'}
G[85150]={'947:63.10,94.42'}
G[85190]={'948:68.33,38.93'}
G[85199]={'950:65.81,9.02 949:57.60,43.17'}
G[85206]={'948:44.34,12.04'}
G[85213]={'19:66.94,27.92 N:81492'}
G[85219]={'948:32.49,47.25'}
G[85247]={'19:71.88,48.97 N:26859'}
G[85278]={'949:53.31,59.73 N:82610'}
G[85289]={'976:53.81,42.54'}
G[85299]={'948:70.82,23.11'}
G[85303]={'948:71.12,22.32'}
G[85320]={'948:46.21,45.68'}
G[85344]={'971:58.87,53.45'}
G[85369]={'976:61,53'}
G[85378]={'947:46.17,31.40 N:45109'}	-- ? 947:61.47,63.29
G[85379]={'950:58.96,38.52 N:45110'}	-- ? 947:46.22,31.40
G[85413]={'971:51.21,47.04 N:45109'}	-- entrance to plot 25
G[85414]={'976:57.75,28.14 N:45110'}	-- plot 25 location
G[85418]={'971:28.49,38.64'}
G[85425]={'948:47.13,31.68'}
G[85426]={'949:49.40,49.65 N:85436'}
G[85431]={'949:50.88,51.39 N:85436'}	-- Sparring Arena-based location
G[85432]={'949:51.32,47.96 N:85436'}
G[85434]={'946:75.94,43.92'}
G[85436]={'949:52.87,51.78'}
G[85439]={'941:21,56'}
G[85440]={'941:61,71'}
G[85453]={'948:45.62,29.40'}
G[85514]={'971:42.79,45.41'}
G[85519]={'823:47.27,61.99'}
G[85520]={'948:52.90,54.97'}
G[85524]={'949:44.09,63.26'}
G[85538]={'949:44.91,63.99'}
G[85540]={'949:48.08,52.17'}
G[85545]={'941:51.75,21.44'}
G[85546]={'823:48.38,71.36'}
G[85550]={'948:39.66,60.66'}
G[85562]={'949:49.43,49.59'}
G[85566]={'948:40.03,43.92'}
G[85572]={'946:22.25,74.17'}
G[85598]={'948:44.41,24.04 N:75323'}
G[85601]={'949:46.48,93.57 N:82254'}
G[85694]={'949:53,68'}
G[85695]={'949:53,67'}
G[85708]={'971:53.02,14.88'}
G[85718]={'949:44.52,91.53'}
G[85725]={'949:44.66,90.51'}
G[85749]={'978:44.10,74.17'}
G[85751]={'941:20.70,60.22'}
G[85777]={'971:53.26,69.08 N:77031'}	-- garrison level 2 position
G[85779]={'949:50,75'}
G[85786]={'949:51.28,66.24'}
G[85807]={'949:61.47,57.61'}
G[85839]={'971:42.13,45.27'}
G[85840]={'1011:42.55,36.40'}
G[85849]={'1009:29.65,52.92'}
G[85857]={'971:34.23,32.82'}
G[85882]={'971:62,73'}
G[85889]={'948:61.61,72.80 N:81280'}
G[85892]={'948:50.66,77.19'}
G[85902]={'948:63.05,23.24'}
G[85924]={'949:41,54.6'}
G[85960]={'949:40.14,60.27'}
G[85980]={'949:44.07,48.82'}
G[85984]={'971:53.67,14.60 N:12919'}
G[86024]={'947:50.22,75.86'}
G[86044]={'948:63.21,23.33'}
G[86065]={'1009:31.99,50.00'}
G[86069]={'1009:35.54,75.80'}
G[86084]={'1009:47.98,30.64'}
G[86144]={'948:73.27,42.22'}
G[86155]={'948:74.73,44.25'}
G[86205]={'948:73.79,43.14'}
G[86213]={'947:50.95,79.00'}
G[86260]={'949:57.91,42.70'}
G[86264]={'949:59.47,32.82'}
G[86272]={'925[1]:56.69,76.03'}
G[86312]={'1011:44.16,45.46'}
G[86315]={'1011:45.54,34.61'}
G[86355]={'948:64.29,37.11 N:80648'}
G[86381]={'948:50.95,55.95'}
G[86390]={'1009:51.46,61.59'}
G[86393]={'950[12]:46.11,34.65 N:74272'}
G[86419]={'948:66.50,51.59 N:80758'}
G[86439]={'949:48.4,47.2'}
G[86442]={'946:69.61,20.80'}
G[86475]={'948:64.10,37.01 N:80758'}
G[86499]={'949:45.67,26.72'}
G[86501]={'949:46.36,69.70 N:85147'}
G[86502]={'949:53.02,59.81 N:61020'}
G[86521]={'949:53.29,59.79 N:81280'}
G[86522]={'946:67.54,42.12'}
G[86531]={'946:39.29,38.51'}
G[86536]={'949:50.06,21.66'}
G[86562]={'949:49.58,32.87'}
G[86563]={'1014[10]:72.48,45.66 N:78558'}
G[86566]={'949:48.25,20.87'}
G[86577]={'949:45.95,27.91'}
G[86579]={'949:46.01,31.84'}
G[86589]={'971:46.11,45.81'}
G[86597]={'948:35.79,52.20'}
G[86614]={'976:50.91,50.65'}	-- Garrison Level 1 position
G[86629]={'976:51.43,57.39'}	-- plot 22 location
G[86659]={'950:45.83,36.88'}
G[86677]={'971:52.01,44.82'}
G[86696]={'976:52.44,37.06'}	-- plot 18 location
G[86832]={'321[1]:48.11,70.51 N:38966'}
G[86884]={'4:57.68,9.70'}
G[86927]={'Near N:86084'}
G[86934]={'Near N:79979'}
G[86946]={'948:43.83,24.63 N:23066'}
G[86949]={'946:85.01,31.06'}
G[86959]={'950:45.93,34.87'}
G[86964]={'950:46.69,57.48 N:87561'}
G[86973]={'971:45.25,42.49 N:46804'}	-- plot 23 location
G[86974]={'971:45.25,42.49'}	-- plot 23 location
G[86979]={'976:58.88,49.06 N:27221'}	-- plot 23 location
G[87056]={'976:62.18,35.74'}
G[87110]={'950:56.23,9.81'}
G[87116]={'976:51.70,58.70 N:87121'}
G[87121]={'976:51.43,57.39'}	-- plot 22 location
G[87122]={'941:68.63,64.68'}
G[87123]={'948:46.30,45.31'}
G[87124]={'947:50.03,31.26'}
G[87125]={'946:49.08,80.40'}
G[87206]={'971:35.53,49.36'}	-- plot 22 location
G[87207]={'971:52.13,45.48'}
G[87212]={'971:34.62,49.00 N:87215'}
G[87213]={'971:52.51,45.30'}
G[87215]={'971:34.58,49.18'}
G[87216]={'971:34.64,49.24 N:87215'}
G[87217]={'971:35.53,49.36 N:87215'}	-- plot 22 location
G[87242]={'976:58.88,49.06 N:26584'}	-- plot 23 location
G[87305]={'976:51.43,57.39'}	-- plot 22 location
G[87341]={'946:38.85,49.79'}
G[87344]={'950:42.10,36.92'}
G[87346]={'941:73.53,26.65'}
G[87368]={'1015:52.20,43.44'}
G[87391]={'1009:51.82,61.45'}
G[87393]={'950:50.37,41.28'}
G[87561]={'948:54.20,62.97'}
G[87698]={'947:62.91,33.50'}
G[87706]={'950:50.26,41.12 N:79201'}
G[87764]={'946:69.46,5.81'}
G[87788]={'950:36.93,24.48'}
G[87971]={'941:74.95,30.05'}
G[87991]={'971:35.53,49.36'}	-- plot 22
G[87992]={'971:35.53,49.36 N:46854'}	-- plot 22
G[87994]={'971:35.53,49.36'}	-- plot 22
G[87995]={'971:35.53,49.36 N:2487'}	-- plot 22
G[87996]={'971:35.53,49.36 N:64842'}	-- plot 22
G[87997]={'971:35.53,49.36 N:11036'}	-- plot 22
G[87998]={'971:35.53,49.36 N:58113'}	-- plot 22
G[87999]={'971:35.53,49.36 N:40997'}	-- plot 22
G[88000]={'971:35.53,49.36 N:49444'}	-- plot 22
G[88001]={'971:35.53,49.36 N:38237'}	-- plot 22
G[88002]={'971:35.53,49.36 N:28444'}	-- plot 22
G[88003]={'971:35.53,49.36'}	-- plot 22
G[88004]={'971:35.53,49.36'}	-- plot 22
G[88005]={'971:35.53,49.36 N:54961'}	-- plot 22
G[88006]={'971:35.53,49.36'}	-- plot 22
G[88007]={'971:35.53,49.36'}	-- plot 22
G[88009]={'971:35.53,49.36'}	-- plot 22
G[88013]={'971:35.53,49.36 N:47269'} -- plot 22
G[88017]={'971:35.53,49.36 N:46338'} -- plot 22
G[88022]={'971:35.53,49.36 N:47869'}	-- plot 22
G[88023]={'971:35.53,49.36 N:61021'} -- plot 22
G[88024]={'971:35.53,49.36 N:9177'} -- plot 22
G[88025]={'971:35.53,49.36 N:39930'}	-- plot 22
G[88026]={'971:35.53,49.36 N:43184'}	-- plot 22
G[88027]={'971:35.53,49.36 N:47366'} -- plot 22
G[88078]={'948:51.18,11.68'}
G[88084]={'1015:44.47,39.44'}
G[88086]={'1015:53.68,43.95'}
G[88087]={'1015:53.03,44.04'}
G[88089]={'1015:49.82,38.45'}
G[88099]={'1015:50.18,34.93'}
G[88100]={'1015:52.00,42.09'}
G[88101]={'1015:50.57,44.71'}
G[88112]={'971:47.38,89.11 N:41003'}
G[88115]={'1015:47.00,41.37 N:88867'}
G[88117]={'1015:51.96,44.37'}
G[88145]={'971:46.99,59.27'}	-- plot 18
G[88155]={'1009:52.03,63.54'}
G[88161]={'1011:65.04,59.17'}
G[88173]={'948:39.67,43.06 N:44637'}
G[88179]={'948:40.10,43.36 N:44637'}
G[88187]={'950:35.53,22.13'}
G[88193]={'948:39.42,62.17 N:83609'}
G[88195]={'948:39.73,60.90 N:83904'}
G[88208]={'950:58.15,18.66'}
G[88223]={'971:37.73,35.92 N:78564'}	-- garrison level 2 location ? 37.67,36.23
G[88228]={'976:43.65,47.81'}	-- garrison level 2 location
G[88240]={'950:52.38,19.17'}
G[88276]={'947:43.56,77.29 N:67996'}
G[88279]={'949:58.17,44.27'}
G[88358]={'950:79.68,30.25'}
G[88361]={'950:79.69,30.18'}
G[88392]={'976:52.44,37.06'}	-- plot 18
G[88394]={'949:55.80,43.83'}
G[88412]={'949:44.04,61.55'}
G[88437]={'941:43.47,20.47'}
G[88448]={'978:45.85,28.94 N:47571'}
G[88478]={'950:59.22,16.26'}
G[88487]={'948:54.28,62.96 N:81280'}
G[88494]={'946:37.74,20.62'}
G[88500]={'950:79.46,30.29'}
G[88530]={'949:40.94,43.01 N:41005'}
G[88545]={'971:46.99,59.27'}	-- plot 18
G[88546]={'976:52.44,37.06'}	-- plot 18
G[88570]={'1011:64.02,62.06'}
G[88674]={'948:50.52,32.00'}
G[88782]={'1015:47.71,37.75'}
G[88798]={'1015:47.06,41.48'}
G[88811]={'950:79.78,29.41'}
G[88855]={'1015:62.67,41.24'}
G[88859]={'1015[17]:25.32,37.60'}
G[88863]={'1015:50.34,61.02'}
G[88867]={'1015:51.78,44.29'}
G[88870]={'1015:48.86,42.12'}
G[88873]={'1015:50.01,48.55'}
G[88890]={'1015:54.18,42.01 N:88867'}
G[88892]={'971:61.07,79.30'}
G[88906]={'950:58.51,15.00'}
G[88923]={'1015:47.94,48.66'}
G[88932]={'1015:48.24,49.09'}
G[88946]={'950:60.44,16.25'}
G[88972]={'947:66.43,26.16 N:79537'}
G[89007]={'1015:49.33,50.72'}
G[89009]={'1015:57.86,43.35 N:88867'}
G[89016]={'1015:41.91,41.90'}
G[89023]={'1015:48.38,34.54'}
G[89024]={'1015:63.90,41.56'}
G[89025]={'1015:61.32,38.60'}
G[89048]={'1015:47.97,48.65 N:88923'}
G[89050]={'1015:48.06,49.15'}
G[89051]={'1015:53.45,62.90 N:88873'}
G[89053]={'1015:62.98,57.73'}
G[89056]={'1015:48.11,49.01'}
G[89061]={'948:46.80,9.10'}
G[89063]={'948:59.70,11.42'}
G[89082]={'1015:49.21,46.54'}
G[89090]={'1015:57.81,43.36'}
G[89097]={'1015[18]:42.90,31.58'}
G[89101]={'1015:53.46,63.73'}
G[89158]={'947:59.78,94.47 N:1229314'}
G[89179]={'949:54.24,55.87 N:41005'}
G[89199]={'1015[18]:70.06,47.25'}
G[89257]={'1015:56.40,59.26'}
G[89283]={'1015:64.63,56.62'}
G[89284]={'1015:63.43,56.50'}
G[89287]={'1015:63.92,63.72'}
G[89288]={'1015:60.13,59.34'}
G[89290]={'1015:62.57,59.40'}
G[89326]={'1015:53.28,45.31'}
G[89341]={'1015:47.12,41.42'}
G[89350]={'1015:63.92,63.72'}
G[89362]={'1015:43.53,43.47 N:93011'}
G[89386]={'1015:47.35,45.90'}
G[89393]={'1015:56.94,14.90'}
G[89398]={'1015:43.30,43.16 N:95238'}
G[89400]={'945:16.11,44.37 N:79519'}
G[89640]={'1015:43.67,43.15'}
G[89650]={'1015:47.25,33.94'}
G[89653]={'1015:51.56,32.48'}
G[89660]={'1015[17]:53.40,47.60'}
G[89661]={'1015[17]:28.89,42.42'}
G[89673]={'1015:44.47,44.72'}
G[89675]={'945:50.57,42.79'}
G[89683]={'945:25.72,32.02'}
G[89686]={'945:26.52,30.70'}
G[89699]={'945:20.96,51.84'}
G[89706]={'945:21.98,54.44'}
G[89731]={'1015:40.29,49.49'}
G[89741]={'945:57.05,65.65'}
G[89744]={'945:44.99,72.50'}
G[89746]={'945:57.69,76.02'}
G[89749]={'945:61.12,75.76'}
G[89753]={'976:40.16,56.67 N:25256'}	-- garrison level 3 location  ? 976:39.96,57.53
G[89754]={'945:50.59,44.29'}
G[89759]={'1022:19.66,47.30'}
G[89763]={'971:34.14,32.81 N:38607'}
G[89777]={'945:43.14,35.97'}
G[89793]={'971:34.22,32.75 N:26814'}
G[89794]={'1015:47.97,27.17'}
G[89795]={'1015:47.99,27.13'}
G[89801]={'1015:57.37,14.27'}
G[89802]={'1015:59.03,41.55'}
G[89803]={'1015:58.80,38.68'}
G[89805]={'971:34.18,32.66'}
G[89806]={'976:40.22,56.02 N:16575'}
G[89810]={'945:40.07,35.75'}
G[89816]={'1015:65.48,39.94'}
G[89822]={'945:73.43,71.12 N:74651'}
G[89829]={'1017:31.09,55.98'}
G[89834]={'1015[17]:61.40,69.32'}
G[89846]={'1015:53.45,43.98'}
G[89849]={'1015[17]:52.98,47.82'}
G[89850]={'1015:59.67,55.16'}
G[89857]={'945:39.52,34.23'}
G[89865]={'1015:50.01,35.10'}
G[89884]={'1015:45.43,57.76'}
G[89935]={'945:39.44,38.83'}
G[89936]={'945:41.21,35.40'}
G[89937]={'949:56.14,6.65'}
G[89975]={'1015:47.95,26.99'}
G[89978]={'1015:53.40,16.31'}
G[90005]={'1015:57.83,16.30'}
G[90024]={'945:42.09,37.86'}
G[90057]={'1015:51.03,31.57'}
G[90065]={'1015:46.65,15.78 N:89794'}
G[90066]={'945:51.15,43.08'}
G[90071]={'948:60.43,12.39'}
G[90074]={'945:40.24,35.31'}
G[90107]={'947:56.68,92.27'}
G[90109]={'1015:49.31,59.84'}
G[90122]={'945:37,33'}
G[90134]={'1015:41.72,31.43'}
G[90139]={'1017:63.58,74.54'}
G[90164]={'1015:47.35,53.39'}
G[90167]={'1015:49.67,15.37 N:90423'}
G[90173]={'1015:47.55,51.73'}
G[90176]={'941:70.11,26.86'}
G[90177]={'949:56.74,17.16'}
G[90180]={'949:52.57,9.85 N:80079'}
G[90211]={'945:73.64,43.34'}
G[90217]={'1015:49.52,8.72','In cave'}
G[90230]={'1015:43.24,44.72'}
G[90233]={'946:67.43,6.57 N:78558'}
G[90237]={'946:67.50,6.63 N:45675'}
G[90238]={'945:69.53,54.18'}
G[90241]={'1015:42.77,43.92'}
G[90244]={'1015:59.68,12.01'}
G[90250]={'23[20]:52.24,77.95'}
G[90255]={'1015:41.25,50.51 N:97644'}
G[90262]={'949:57.14,26.75'}
G[90265]={'945:26.01,30.64'}
G[90286]={'945:32.35,72.25'}
G[90309]={'945:58.50,60.35 N:90177'}
G[90312]={'945:21.47,37.88'}
G[90313]={'1015:55.31,27.89'}
G[90317]={'1015:43.17,43.61 N:109196'}
G[90318]={'1015:55.60,14.86'}
G[90369]={'1014[10]:74.94,48.29 N:11034'}	-- 23:74.27,53.25
G[90377]={'1015:57.84,12.29'}
G[90379]={'1015:49.83,15.57'}
G[90380]={'1015:44.98,14.28'}
G[90383]={'1015:53.79,16.82 N:91131'}
G[90389]={'1015:56.66,17.69'}
G[90390]={'1015:57.21,16.37'}
G[90412]={'948:72.82,32.58'}
G[90417]={'1014[10]:28.51,48.32 N:78558'}
G[90418]={'1014[10]:28.45,48.91 N:67996'}
G[90421]={'945:26.39,76.88'}
G[90423]={'1015:49.39,15.53'}
G[90425]={'945:31.77,70.74'}
G[90426]={'945:31.71,67.05'}
G[90429]={'945:31.26,71.97'}
G[90434]={'945:30.74,68.42'}
G[90437]={'945:26.63,75.20'}
G[90438]={'945:26.15,76.28'}
G[90443]={'945:10.73,54.95'}
G[90452]={'945:12.90,56.00'}
G[90463]={'1014[10]:28.63,48.21'}
G[90473]={'823:53.25,87.60'}
G[90474]={'Near1015 N:97644'}
G[90480]={'1015:47.39,9.17'}
G[90481]={'945:61.51,45.84 N:74651'}
G[90482]={'945:16.23,56.89'}
G[90497]={'945:12.76,56.83'}
G[90505]={'1015:67.12,51.63'}
G[90517]={'945:31.67,68.25'}
G[90519]={'945:44.83,37.83'}
G[90526]={'1015:45.78,11.13'}
G[90537]={'1015:45.55,12.67'}
G[90542]={'1015:42.65,8.04'}
G[90543]={'1015:48.90,26.40 N:90916'}
G[90547]={'1015:42.88,8.48'}
G[90553]={'945:9.68,56.22 N:70860'}
G[90584]={'945:44.22,41.54'}
G[90585]={'945:12.82,56.10'}
G[90616]={'1015:56.97,13.94'}
G[90620]={'945:20.83,38.07'}
G[90621]={'1015:35.65,53.37'}
G[90644]={'945:47.28,70.48'}
G[90648]={'1015:44.46,10.69'}
G[90649]={'945:19.34,40.87'}
G[90659]={'1015:38.79,57.59'}
G[90660]={'1015:39.64,47.39'}
G[90661]={'1015:39.64,46.98'}
G[90675]={'971:29.02,40.47'}
G[90703]={'945:25.89,76.11'}
G[90738]={'1015:49.94,26.55 N:89794'}
G[90748]={'1017:35.83,47.95'}
G[90749]={'1017:33.71,51.02 N:66292'}
G[90782]={'945:17.20,42.68'}
G[90783]={'1017:33.76,50.76 N:54614'}
G[90785]={'1017:34.01,50.45'}
G[90803]={'1015:35.39,50.35'}
G[90851]={'945:20.25,51.20'}
G[90866]={'1017:33.60,50.82 N:7944'}
G[90885]={'945:20.50,49.69'}
G[90887]={'945:25.20,46.42'}
G[90888]={'945:25.52,46.07'}
G[90894]={'971:34.21,32.73'}
G[90899]={'1017:32.30,49.65'}
G[90901]={'1015:56.04,29.13'}
G[90903]={'1017:32.26,47.51'}
G[90916]={'1015:48.66,16.54'}
G[90948]={'1017:28.77,55.18'}
G[90963]={'945:58.14,58.68'}
G[90974]={'945:58.43,60.44'}
G[90977]={'945:58.64,60.25'}
G[90985]={'1015:43.85,9.10'}
G[90991]={'945:59.85,47.50'}
G[90993]={'945:59.92,47.49'}
G[91007]={'1065:19.75,57.53'}
G[91009]={'945:57.03,23.23'}
G[91014]={'971:31.29,39.61 N:91017'}
G[91017]={'971:31.17,39.58'}
G[91020]={'971:34.21,32.73'}
G[91024]={'971:34.21,32.73'}
G[91025]={'971:34.21,32.75'}
G[91026]={'976:33.84,42.42 N:91361'}
G[91029]={'976:40.16,56.67'}
G[91030]={'976:40.16,56.67'}
G[91031]={'976:40.16,56.67'}
G[91033]={'976:40.16,56.67'}
G[91034]={'976:40.16,56.67'}
G[91044]={'1018:48.98,89.59'}
G[91045]={'1018[14]:59.86,82.92'}
G[91047]={'945:17.01,52.89'}
G[91048]={'1015:45.47,10.83'}
G[91061]={'1015:40.78,9.32 N:91065'}
G[91065]={'1015:47.44,12.18'}
G[91066]={'1018:48.87,70.20 N:92783'}
G[91072]={'976:40.93,47.75'}
G[91074]={'1015:58.53,54.90'}
G[91093]={'945:41.06,68.68'}
G[91100]={'1015:59.29,46.26'}
G[91109]={'1018:51.93,64.09 N:33091'}
G[91115]={'1015:61.36,62.03'}
G[91121]={'1018:42.19,78.18'}
G[91122]={'1018:46.60,77.27'}
G[91128]={'1015:51.23,32.52'}
G[91130]={'1018:45.69,77.55'}
G[91131]={'1015:48.25,22.76'}
G[91144]={'1031:20.42,61.55'}
G[91150]={'1018:44.12,75.49'}
G[91153]={'1018:47.14,69.95'}
G[91157]={'1015:47.68,28.17'}
G[91158]={'1017:36.82,30.95'}
G[91165]={'Near1015'}
G[91166]={'1015:62.87,51.45 N:91165'}
G[91172]={'1014[10]:70.53,44.06 N:78558'}	-- also at 1014[10]:70.85,43.90 when doing the 39733 quest
G[91184]={'1015:63.33,53.45'}
G[91187]={'1015:32.28,29.83'}
G[91195]={'976:40.48,56.09 N:25256'}
G[91196]={'971:34.23,32.63 N:38607'}
G[91202]={'1017:39.72,67.55'}
G[91204]={'1017:44.16,69.97'}
G[91205]={'1017:45.62,71.57'}
G[91222]={'1017:37.38,63.85'}
G[91223]={'1018:49.66,85.83'}
G[91227]={'945:22.06,50.57'}
G[91240]={'1017:46.26,72.59'}
G[91242]={'949:56.75,17.23'}
G[91243]={'945:13.51,56.85'}
G[91244]={'1017:43.33,75.26'}
G[91249]={'1017:44.80,77.42 N:96465'}
G[91250]={'945:10.06,54.43'}
G[91251]={'945:16.36,58.41'}
G[91288]={'1018:48.42,84.56'}
G[91289]={'1015:52.49,22.92'}
G[91290]={'945:57.43,58.88 N:79519'}
G[91291]={'945:25.78,38.87 N:79519'}
G[91292]={'945:60.46,46.24 N:79519'}
G[91299]={'945:27.06,44.42 N:48559'}
G[91308]={'1015:59.62,17.12'}
G[91313]={'945:31.87,36.99'}
G[91318]={'1018:48.71,88.36'}
G[91324]={'945:33.45,37.31'}
G[91348]={'945:26.75,44.21'}
G[91351]={'945:32.57,37.47 N:48559'}
G[91354]={'1018:53.80,79.79'}
G[91361]={'976:33.40,42.30'}
G[91362]={'976:33.68,42.34 N:91361'}
G[91364]={'976:33.37,42.84 N:91361'}	-- garrison level 3
G[91371]={'1015:45.27,11.99'}
G[91384]={'1022:59.92,40.10'}
G[91387]={'1022:34.32,28.16'}
G[91403]={'1015:61.69,41.10 N:88867'}
G[91404]={'971:34.21,32.74'}	-- garrison level 3
G[91414]={'1017:38.81,20.75'}
G[91417]={'1017:42.64,65.72'}
G[91419]={'1015:56.61,59.60'}
G[91423]={'1017:39.50,65.25'}
G[91431]={'1015[17]:68.83,13.73'}
G[91457]={'1015:56.62,59.56'}
G[91458]={'1017:35.00,36.57'}
G[91459]={'1021:0.00,0.00'}
G[91462]={'1018:54.69,72.85 N:33091'}
G[91470]={'1017:33.35,31.41'}
G[91472]={'1018:54.19,85.81'}
G[91473]={'1017:36.08,27.56'}
G[91474]={'1018:53.84,81.64'}
G[91481]={'1017:42.02,64.49 N:91222'}
G[91486]={'1017:45.19,70.33'}
G[91519]={'1017:43.80,68.21 N:91222'}
G[91527]={'1022:64.49,43.88'}
G[91529]={'1017:41.47,66.74'}
G[91531]={'1022:64.58,43.35'}
G[91553]={'1017:46.24,70.37 N:91222'}
G[91558]={'Near1017 N:91222'}
G[91566]={'1017:44.07,81.44'}
G[91569]={'1017:34.69,26.78'}
G[91571]={'946:44.30,65.39 N:90177'}
G[91573]={'945:32.79,37.48 N:81280'}
G[91575]={'1022:54.65,39.99'}
G[91579]={'1015:43.14,28.16'}
G[91581]={'1017:39.56,19.32'}
G[91589]={'971:33.77,36.37'}
G[91590]={'1017:36.11,27.36'}
G[91593]={'949:51.06,10.95'}
G[91596]={'949:49.69,11.60'}
G[91598]={'1018:46.89,68.78'}
G[91601]={'949:51.16,15.26'}
G[91645]={'1018:49.31,87.78'}
G[91650]={'1018:65.18,67.03 N:100573'}
G[91657]={'1022:21.78,60.76'}
G[91721]={'945:48.09,44.96'}
G[91731]={'1014[10]:47.30,33.45'}
G[91737]={'1017:41.69,81.48'}
G[91750]={'946:44.32,65.33 N:75121'}
G[91751]={'946:44.30,65.39 N:90177'}
G[91756]={'1015:57.22,31.20'}
G[91758]={'1015:49.46,57.75'}
G[91759]={'1017:45.36,80.05'}
G[91760]={'945:46.50,41.93'}
G[91764]={'945:46.99,44.36'}
G[91771]={'1017:37.30,63.72'}
G[91780]={'1017:35.48,18.48'}
G[91795]={'1017:49.61,71.81'}
G[91797]={'1046[1]:0.00,0.00'}
G[91803]={'1017:46.56,83.92'}
G[91818]={'1022:69.70,29.54'}
G[91824]={'1017:32.69,51.72'}
G[91847]={'1018:40.30,59.79'}
G[91860]={'1018:40.26,52.37'}
G[91866]={'23[20]:73.79,19.68'}
G[91871]={'945:52.79,39.99'}
G[91874]={'1017:46.08,77.26'}
G[91892]={'1017:40.67,72.39'}
G[91894]={'1017:41.16,71.90'}
G[91895]={'1017:41.38,71.70'}
G[91913]={'945:73.42,71.12 N:90177'}
G[91923]={'962:69.47,52.98 N:80079'}
G[91935]={'945:9.83,53.59 N:79537'}
G[91948]={'1022:45.69,64.86'}
G[91954]={'811[3]:75.10,43.74'}
G[92002]={'945:57.63,24.37'}
G[92026]={'945:58.64,21.33'}
G[92031]={'945:57.31,26.31'}
G[92034]={'1015:49.36,45.34'}
G[92040]={'1022:85.10,50.23'}
G[92055]={'945:47.37,70.38 N:21183'}
G[92083]={'945:60.12,21.36'}
G[92115]={'161:50.84,29.93'}
G[92117]={'1018:60.05,77.49'}
G[92120]={'945:62.59,31.11 N:21183'}
G[92128]={'1017:44.85,80.21'}
G[92152]={'1017:36.37,51.88'}
G[92180]={'1018:41.61,78.24'}
G[92183]={'1014[10]:44.54,28.71'}
G[92213]={'947:27.60,10.28 N:78558'}
G[92218]={'1017:40.87,80.98'}
G[92219]={'971:32.03,31.94 N:29611'}
G[92223]={'971:34.27,32.82'}
G[92224]={'1017:35.71,54.06'}
G[92264]={'1033:29.91,53.61'}
G[92274]={'945:53.73,21.12'}
G[92317]={'945:32.79,37.47 N:48559'}
G[92321]={'1018:64.07,58.45'}
G[92326]={'1018:65.19,58.24'}
G[92332]={'1018:65.20,59.27'}
G[92335]={'1018:67.27,57.97'}
G[92338]={'945:62.76,27.85 N:21183'}
G[92383]={'1018:65.90,44.00'}
G[92396]={'945:55.29,22.33'}
G[92397]={'945:52.79,19.44'}
G[92398]={'945:51.76,24.25'}
G[92400]={'976:39.13,54.84 N:38966'}	-- garrison level 3
G[92401]={'949:56.74,17.16 N:70860'}
G[92408]={'945:60,21'}
G[92414]={'1017[9]:77.18,48.28 1017:31.18,57.96'}
G[92415]={'1017[9]:26.52,56.42'}
G[92420]={'1018:60.57,61.47 N:40289'}
G[92423]={'1018:38.19,52.77'}
G[92445]={'1015:67.27,26.71'}
G[92447]={'1015:66.94,26.02'}
G[92450]={'1015:65.41,29.11'}
G[92451]={'945:27.52,32.76'}
G[92458]={'1014[10]:41.37,33.09'}
G[92464]={'1014[10]:42.97,33.55'}
G[92465]={'945:49.00,72.58'}
G[92466]={'945:53.80,76.46'}
G[92495]={'945:62.93,72.48'}
G[92508]={'945:63.11,80.66'}
G[92539]={'1017:60.14,50.76 N:96254'}
G[92545]={'945:58.15,58.57'}
G[92546]={'945:31.88,71.33'}
G[92552]={'945:35.56,46.66'}
G[92561]={'1017:44.83,59.35 N:91473'}
G[92566]={'1017:46.55,67.78 N:91473'}
G[92567]={'1017:43.70,67.85 N:91473'}
G[92569]={'1017:45.87,72.69 N:91473'}
G[92573]={'1017:47.01,71.71 N:91473'}
G[92575]={'945:31.37,73.36'}
G[92590]={'1017:41.98,57.72'}
G[92591]={'1017:42.42,58.15'}
G[92596]={'945:49.96,76.82'}
G[92599]={'1017:38.19,42.66'}
G[92600]={'1017:39.00,44.73'}
G[92604]={'1017:44.32,22.76'}
G[92616]={'945:50.42,44.28'}
G[92618]={'1018:38.91,61.45'}
G[92619]={'1018:42.35,59.00'}
G[92620]={'1018:42.47,58.97 N:40619'}
G[92626]={'1017:44.19,22.86'}
G[92636]={'945:38.47,77.69'}
G[92647]={'945:45.89,47.24'}
G[92657]={'945:50.92,74.55'}
G[92680]={'1018:51.44,57.00'}
G[92683]={'1018:42.13,59.03'}
G[92685]={'1017:57.93,45.21'}
G[92688]={'1018:54.79,52.78'}
G[92697]={'1018:51.49,56.85'}
G[92706]={'945:24.02,52.90'}
G[92707]={'1018:39.58,58.98'}
G[92710]={'1018:64.97,61.18 N:40289'}
G[92715]={'945:14.50,62.80'}
G[92718]={'1032[1]:80.10,36.55'}
G[92738]={'1018:38.63,65.67'}
G[92742]={'1018:52.46,63.42 N:40289'}
G[92751]={'1017:60.68,67.76'}
G[92763]={'1017:67.26,39.73'}
G[92764]={'1017:61.85,62.99'}
G[92766]={'945:54.28,80.72'}
G[92776]={'1032[1]:46.70,27.65'}
G[92782]={'1032[1]:70.42,30.74'}
G[92783]={'1018:66.20,44.54'}
G[92788]={'1018:57.55,55.90'}
G[92789]={'1018:57.22,57.52'}
G[92794]={'1018:56.43,53.84'}
G[92802]={'1018:56.13,54.68'}
G[92805]={'945:55.27,74.74'}
G[92817]={'945:54.26,80.83'}
G[92819]={'945:54.40,80.87'}
G[92837]={'1018:64.95,61.15'}
G[92842]={'1018:40.85,53.01 N:40619'}
G[92850]={'1018:40.73,53.01 N:40619'}
G[92873]={'945:10.77,55.11'}
G[92874]={'1018:42.62,78.25'}
G[92909]={'Near1014 N:11034'}
G[92910]={'945:54.89,90.82'}
G[92920]={'1017:66.75,45.46'}
G[92941]={'945:32.65,35.93'}
G[92951]={'1017:47.52,57.77'}
G[92954]={'1018:43.88,50.36'}
G[92956]={'1017:46.86,56.57'}
G[92965]={'1018:43.43,54.03'}
G[92966]={'1018:42.60,52.60'}
G[92977]={'945:12.21,56.94'}
G[92980]={'1032[1]:74.45,35.96 N:93011'}
G[92986]={'1032[1]:74.41,37.18 N:18417'}
G[92987]={'1018[13]:23.18,40.75 N:92718'}
G[92989]={'1018:67.99,35.29'}
G[93001]={'945:16.33,57.18'}
G[93002]={'945:52.35,65.10'}
G[93003]={'945:54.60,57.07'}
G[93011]={'1028:22.08,55.83'}
G[93024]={'945:56.97,35.16'}
G[93027]={'1018[3]:23.18,40.75 N:92718'}
G[93029]={'1018[3]:43.16,82.08'}
G[93030]={'1018:58.87,33.65'}
G[93039]={'945:52.70,42.82'}
G[93057]={'945:16.07,59.23'}
G[93064]={'1018:38.35,63.17'}
G[93066]={'1017:67.85,57.82'}
G[93070]={'1017:68.50,50.93'}
G[93071]={'1017:69.12,42.06'}
G[93076]={'945:36.12,79.14'}
G[93094]={'1017:65.35,43.05'}
G[93095]={'1017:71.22,47.80'}
G[93110]={'1017:49.68,47.20'}
G[93111]={'1018:60.74,32.44'}
G[93112]={'1028:40.05,67.19'}
G[93115]={'1028:40.36,69.90'}
G[93125]={'945:34.56,78.17'}
G[93127]={'1028:60.51,44.76 N:93011'}
G[93149]={'1018:38.87,50.93 N:92718'}
G[93155]={'1018:67.45,39.15'}
G[93157]={'1018:56.96,56.34'}
G[93159]={'1018:55.38,41.83'}
G[93166]={'1017:45.75,49.73'}
G[93188]={'1014[10]:46.20,26.56'}
G[93189]={'1014[10]:46.08,26.67'}
G[93205]={'1018:62.66,47.49'}
G[93231]={'1017:68.50,54.35'}
G[93234]={'1017:71.44,42.51'}
G[93313]={'1018:56.33,65.74'}
G[93318]={'1018:61.07,69.83'}
G[93326]={'1015:43.55,43.42 N:78558'}
G[93329]={'1018:60.43,67.04'}
G[93337]={'1015:45.09,42.90 N:78558'}
G[93354]={'1015:47.95,27.21 N:78558'}
G[93371]={'1017:72.24,50.16'}
G[93377]={'1022:28.99,44.72'}
G[93396]={'945:59.69,45.92'}
G[93399]={'23:74.27,53.16 N:11034'}
G[93401]={'1017:64.94,51.78'}
G[93437]={'1021[2]:51.03,51.33'}
G[93444]={'1018:55.97,83.73'}
G[93446]={'1017:68.16,48.73'}
G[93456]={'1021[2]:55.97,30.75'}
G[93464]={'1018:54.52,72.65'}
G[93489]={'1018:54.49,82.42'}
G[93520]={'1014[10]:38.82,24.75'}
G[93522]={'1014[10]:35.54,29.93'}
G[93523]={'1014[10]:35.29,29.61'}
G[93530]={'1014[10]:38.24,41.81'}
G[93531]={'1014[10]:38.32,40.36'}
G[93538]={'1014[10]:40.95,26.63'}
G[93539]={'1014[10]:38.36,24.55'}
G[93541]={'1014[10]:35.85,28.80'}
G[93550]={'1021[2]:0.00,0.00'}
G[93568]={'1021[1]:0.00,0.00'}
G[93581]={'1018:46.28,84.55'}
G[93584]={'1017:60.59,60.30'}
G[93596]={'945:49.26,40.96'}
G[93600]={'1018:53.75,79.83'}
G[93603]={'1017:55.04,72.56 N:91158'}
G[93622]={'1015:40.61,44.66'}
G[93654]={'1018:60.99,88.37'}
G[93658]={'945:62.66,27.66 N:90177'}
G[93659]={'945:62.90,27.87 N:74272'}
G[93677]={'1018:52.81,87.54'}
G[93679]={'1018:49.24,49.18'}
G[93684]={'1018:52.82,87.46'}
G[93686]={'1018:52.77,87.49'}
G[93691]={'1024:55.09,84.06'}
G[93716]={'1028:62.74,48.37'}
G[93758]={'1018:64.54,85.46'}
G[93759]={'1028:38.79,60.64 N:109196'}
G[93779]={'1017:63.59,61.75'}
G[93787]={'23[20]:53.44,78.63'}
G[93805]={'1024:38.57,69.03'}
G[93812]={'947:28.68,10.85'}
G[93822]={'947:28.20,10.63'}
G[93823]={'1035[1]:58.99,29.86'}
G[93826]={'1080[6]54.95,63.16 1024[6]:54.95,63.22'}
G[93833]={'1024:43.63,59.90 N:95956'}
G[93836]={'1024[8]:59.70,32.62'}
G[93841]={'1024:52.47,44.72 N:95410'}
G[93846]={'1024:53.27,64.04 N:93826'} -- 1024:53.20,70.02 ?
G[93860]={'1017:57.13,73.87'}
G[93890]={'1018:48.40,84.65'}
G[93940]={'1018:42.67,58.08'}
G[94009]={'1018:37.59,59.48'}
G[94046]={'1018:38.72,58.80'}
G[94051]={'1024:49.09,42.36'}
G[94068]={'1024:49.45,39.24'}
G[94085]={'1024:54.14,41.66'}
G[94098]={'1024:56.34,54.86'}
G[94101]={'1024:40.00,52.30'}
G[94117]={'1018:37.05,58.48'}
G[94138]={'1014[4]:42.49,75.94'}
G[94141]={'1014[4]:42.48,74.69'}
G[94147]={'1024:47.65,44.01'}
G[94149]={'1024:44.16,45.37'}
G[94152]={'1024:46.02,47.89'}
G[94153]={'1024:46.09,46.27'}
G[94159]={'1014[4]:41.15,74.32'}
G[94179]={'1018:54.38,73.58'}
G[94196]={'1024:45.37,43.79'}
G[94208]={'1018:45.94,71.92'}
G[94227]={'1017:56.78,66.29 N:10181'}
G[94228]={'1017:62.56,68.07 N:10181'}
G[94261]={'1024[5]:59.31,81.15'}
G[94318]={'1017:71.56,59.82'}
G[94337]={'1017:74.90,61.87'}
G[94338]={'1017:73.28,61.26'}
G[94346]={'1017:59.97,51.36'}
G[94347]={'1017:74.38,59.55'}
G[94366]={'1018:38.92,64.70'}
G[94383]={'1018:36.04,57.59'}
G[94386]={'1024:47.47,47.01'}
G[94409]={'1024:40.04,52.25 N:18180'}
G[94410]={'1028:33.94,70.05 N:95238'}
G[94413]={'1017:62.06,60.44'}
G[94414]={'1018:34.36,58.32'}
G[94429]={'947:29.77,10.65 N:91242'}
G[94434]={'1024:39.93,52.24'}
G[94472]={'945:39.50,28.26'}
G[94485]={'1018:67.00,46.19'}
G[94507]={'1024:53.07,52.21'}
G[94522]={'1024:47.17,47.99'}
G[94561]={'1024:49.03,55.26'}
G[94571]={'1024:44.88,65.71 N:99153'}
G[94589]={'161:41.87,62.89'}
G[94594]={'1018:51.36,51.31'}
G[94624]={'1017:45.20,70.72'}
G[94654]={'1028:39.61,53.04'}
G[94687]={'1024:40.07,63.67'}
G[94688]={'1024:43.09,59.54'}
G[94691]={'1024:43.68,57.72'}
G[94719]={'11:48.85,58.59'}
G[94789]={'941:41.59,72.31'}
G[94801]={'941:40.04,72.22'}
G[94825]={'1017:55.83,70.69'}
G[94856]={'1017:60.53,69.47'}
G[94863]={'1018:69.44,49.38'}
G[94864]={'978:45.97,29.10 N:83837'}
G[94870]={'971:33.11,37.10'}
G[94877]={'1024:56.18,72.45'}
G[94902]={'1054:49.40,55.13 N:93011'}
G[94960]={'1041[2]:48.16,40.02'}
G[94974]={'1018:40.05,43.31'}
G[94977]={'1018:40.73,53.03 N:40619'}
G[94983]={'1024:52.80,42.30'}
G[94984]={'1024:50.14,41.88'}
G[94986]={'1024:49.65,37.67'}
G[95002]={'947:29.82,10.69'}
G[95013]={'1024:38.74,63.41'}
G[95028]={'1018:39.13,51.05 N:108326'}
G[95044]={'945:12.69,55.40'}
G[95053]={'945:23.70,39.81'}
G[95054]={'945:31.91,73.09'}
G[95055]={'1018[14]:61.72,81.23'}
G[95056]={'945:47.20,52.50'}
G[95078]={'1080:14.10,56.06'}
G[95117]={'1018:69.49,49.33'}
G[95118]={'1018:69.54,49.42'}
G[95123]={'1018:65.82,53.37'}
G[95130]={'1024:37.47,64.30'}
G[95137]={'24:57.03,46.46'}
G[95138]={'1018:67.38,53.42'}
G[95152]={'1018:67.46,51.22'}
G[95153]={'1024:45.92,39.27'}
G[95186]={'1024:41.13,61.57'}
G[95191]={'1024:43.70,59.90'}
G[95194]={'1024:52.48,33.29'}
G[95196]={'1024:50.81,35.10'}
G[95202]={'1018:54.29,68.32'}
G[95204]={'1024:47.14,73.38'}
G[95221]={'1018:47.24,58.08'}
G[95226]={'1028:38.27,73.66'}
G[95234]={'321[1]:53.12,57.60'}
G[95235]={'945:21.21,49.56'}
G[95236]={'945:19.00,39.96'}
G[95237]={'1052[1]:57.70,67.42 N:18417'}
G[95238]={'1052[2]:59.38,51.31, 1052[1]:60.20,68.35'}	-- in both places for acceptance of quest 41066, and turnin, but not giving next quest...only downstairs location for that.
G[95240]={'1052[1]:57.69,67.48 N:93011'}
G[95247]={'1018:40.49,44.63'}
G[95256]={'1024:39.42,36.94'}
G[95265]={'1024:53.05,35.70'}
G[95266]={'1024:46.76,37.87'}
G[95270]={'1024:41.63,30.84'}
G[95272]={'1024:45.24,27.43'}
G[95290]={'1024:48.49,27.71'}
G[95310]={'1024:42.35,29.65'}
G[95318]={'1018:61.08,69.33'}
G[95319]={'1018:62.79,70.32'}
G[95329]={'1033:25.15,60.66'}
G[95392]={'1024[31]:40.30,53.18 N:97667'}
G[95395]={'1018:61.05,73.23 N:95396'}
G[95396]={'1018:62.77,71.71'}
G[95399]={'1018:64.37,77.52'}
G[95410]={'1024:52.32,36.43'}
G[95421]={'1024:45.21,32.52 N:97667'}
G[95424]={'945:57.96,59.34'}
G[95430]={'1018:40.05,54.79'}
G[95438]={'1024:40.02,52.36'}
G[95451]={'1027:69.75,79.79'}
G[95599]={'1018:60.97,70.21'}
G[95611]={'1017:60.93,65.32 N:10181'}
G[95617]={'1018:61.66,73.67'}
G[95620]={'1017:67.68,64.35'}
G[95675]={'1041[2]:0.00,0.00'}
G[95676]={'1041[3]:51.99,86.54'}
G[95688]={'1080:45.37,39.21'}
G[95693]={'1024:45.53,48.99'}
G[95726]={'1018:61.88,72.60'}
G[95727]={'1018:63.88,74.87'}
G[95748]={'1017:58.44,25.85'}
G[95753]={'1024[31]:74.57,55.57'}
G[95755]={'1017:55.07,72.64 N:10181'}
G[95799]={'1024[31]:52.38,62.60'}
G[95804]={'1017:62.30,68.09'}
G[95842]={'1041[2]:52.82,66.03'}
G[95852]={'1027:69.01,74.78'}
G[95866]={'1024[20]:60.76,58.14'}
G[95872]={'1024:51.38,31.98'}
G[95881]={'1024[21]:47.46,23.61'}
G[95888]={'1045[3]:50.10,79.48'}
G[95916]={'1024[20]:49.24,43.21'}
G[95921]={'1017:60.59,65.08'}
G[95932]={'1017:71.46,60.58'}
G[95937]={'1024:44.36,67.77'}
G[95951]={'1018:63.90,45.50'}
G[95956]={'1024:41.19,61.49'}
G[96014]={'945:61.66,45.70 N:18013'}
G[96028]={'1046[1]:55.57,54.09'}
G[96038]={'Near1024 N:95956'}
G[96072]={'1024:43.80,75.52'}
G[96083]={'1024:40.25,64.05'}
G[96084]={'1024:40.01,57.96'}
G[96124]={'1024:40.45,62.52'}
G[96129]={'1017:44.47,47.16'}
G[96135]={'1017:47.39,45.66'}
G[96146]={'1024:37.44,43.48'}
G[96147]={'945:57.83,59.79'}
G[96183]={'1014[10]:74.64,44.96'}
G[96215]={'1017:49.54,42.44'}
G[96229]={'1017:42.44,47.87'}
G[96236]={'1017:43.12,41.30'}
G[96254]={'1017:43.17,49.16'}
G[96257]={'1017:46.73,44.44'}
G[96258]={'1017:46.32,44.82 N:96257'}
G[96268]={'1080:0.00,0.00'}
G[96270]={'1024[29]:61.26,72.64'}
G[96277]={'1028:75.25,36.64'}
G[96278]={'1028:72.82,32.79'}
G[96280]={'1028:73.80,31.99'}
G[96286]={'1024[8]Near N:97667'}
G[96304]={'971:41.85,47.73'}
G[96362]={'971:44.29,50.98'}
G[96400]={'1028:44.95,77.83'}
G[96410]={'1024:47.26,33.40'}
G[96420]={'1028:60.58,44.86 N:97297'}
G[96436]={'1028:64.05,52.30 N:109196'}
G[96441]={'1028:64.30,59.17'}
G[96451]={'971:44.01,51.42'}
G[96453]={'Near1024 N:97667'}
G[96465]={'1017:42.79,82.69'}
G[96469]={'1035[1]:58.38,84.60'}
G[96494]={'1028[1]:47.21,19.13'}
G[96513]={'1024:57.62,56.61'}
G[96520]={'1024:38.40,61.24 N:95956'}
G[96527]={'1056:36.17,74.95'}
G[96541]={'1056:34.10,74.37'}
G[96586]={'1035[1]:41.01,37.13'}
G[96590]={'1024:55.83,61.48'}
G[96615]={'1024:48.22,27.13'}
G[96621]={'1024:48.76,27.19'}
G[96644]={'1014[10]:29.10,46.88 N:66292'}
G[96655]={'1028:60.53,44.66 N:95238'}
G[96663]={'301:18.67,51.08 N:48736'}
G[96665]={'1032[1]:49.14,49.44 N:93011'}
G[96666]={'1032[3]:62.27,53.31 N:93011'}
G[96669]={'1032[3]:62.27,53.31 N:18417'}
G[96675]={'1032[2]:41.09,47.17 N:95238'}
G[96682]={'1032[2]:46.94,18.72'}
G[96683]={'4:61.35,8.92'}
G[96686]={'4:61.37,8.87 N:10181'}
G[96691]={'1024:53.72,62.73'}
G[96705]={'971:44.00,51.46'}
G[96735]={'976:47.21,37.75'}
G[96821]={'1014[10]:42.81,80.06'}
G[96853]={'1024:55.33,41.09'}
G[96878]={'1024:53.32,42.12'}
G[96984]={'1024:54.71,44.98'}
G[96986]={'1024:53.46,43.54'}
G[96989]={'1024:54.73,41.00'}
G[96997]={'1032[1]:49.39,33.21'}
G[97012]={'1014[10]:48.73,73.59'}
G[97057]={'1028:80.16,41.69'}
G[97059]={'1028:74.18,57.30'}
G[97064]={'1024[16]:60.89,25.18'}
G[97069]={'1032[1]:71.36,36.36'}
G[97072]={'1021[1]:59.42,60.33'}
G[97074]={'1017:48.02,54.57'}
G[97091]={'1017:50.45,56.09'}
G[97093]={'1024:51.03,25.69'}
G[97094]={'1024[16]:51.92,81.44 1024:41.06,45.52>1024'}	-- outer map I think is 1024:41.06,45.52
G[97102]={'1024:52.33,51.49'}
G[97103]={'1024:39.13,43.18'}
G[97111]={'1021[2]:51.53,52.94'}
G[97130]={'1024:55.28,41.79'}
G[97140]={'1033:37.08,46.22'}	-- moves to 1033:36.51,46.75 after turning in 43318
G[97193]={'Near1024 N:97094'}
G[97203]={'1024:41.96,41.65'}
G[97220]={'1024:48.99,49.93'}
G[97225]={'1032[2]:46.69,43.33'}
G[97228]={'1032[2]:46.81,33.91'}
G[97250]={'1017:36.48,36.61'}
G[97258]={'1017:51.46,56.94'}
G[97261]={'1014[10]:44.46,28.28'}
G[97266]={'1024:53.19,70.28'}
G[97270]={'1017:69.90,45.50 N:93446'}
G[97296]={'301:72.55,47.02 N:78558'}
G[97297]={'1028:69.93,44.23'}
G[97301]={'1024:53.38,64.11 N:97667'}
G[97303]={'1028:69.86,37.91 N:93011'}
G[97305]={'1017:36.78,31.11 N:97074'}
G[97306]={'1017:33.75,45.85'}
G[97319]={'1022:65.56,47.14 N:93234'}
G[97326]={'1024:51.04,48.09'}
G[97333]={'1032[2]:0.00,0.00'}
G[97337]={'1018:68.32,40.52'}
G[97338]={'1018:66.05,37.96'}
G[97344]={'1024:53.37,64.01 N:95956'}
G[97345]={'1024:48.39,40.22'}
G[97361]={'1014[11]:67.28,17.83'}
G[97370]={'1028:68.74,27.59'}
G[97389]={'1035[1]:59.22,13.44'}
G[97407]={'1024:53.16,68.76 N:93841'}
G[97419]={'Near1022 N:93234'}
G[97429]={'1014[10]:39.85,30.46'}
G[97445]={'1022:56.07,65.11'}
G[97449]={'1024:38.11,45.51'}
G[97480]={'1022:46.78,49.01 N:93234'}
G[97504]={'1018:66.85,36.66'}
G[97517]={'1018:60.18,44.28'}
G[97548]={'1018:62.07,37.93'}
G[97553]={'1024:41.28,72.59'}
G[97554]={'1018:62.49,34.86'}
G[97558]={'Near1022 N:93234'}
G[97572]={'1080:32.17,38.21'}
G[97593]={'1024:54.70,40.60'}
G[97630]={'1022:28.54,64.20'}
G[97643]={'1032[2]:41.33,47.36 N:97644'}
G[97644]={'1032[3]:24.44,55.73'}
G[97653]={'1024:53.71,51.28','In cave at bottom of falls'}
G[97661]={'1024:38.90,43.43'}
G[97662]={'1024:40.36,71.69 N:95956'}
G[97666]={'1014[10]:70.51,44.35 N:97553'}
G[97667]={'1024:39.00,37.32'}
G[97671]={'1018:69.48,59.99'}
G[97706]={'1028:73.45,48.92'}
G[97718]={'1014[10]:38.32,40.88'}
G[97729]={'1033:46.04,31.56'}
G[97755]={'1017:42.81,45.00'}
G[97793]={'1024:41.29,58.07'}
G[97808]={'1038:30.26,48.27'}
G[97812]={'1024[16]:51.13,63.51'}
G[97822]={'1017:69.18,65.92'}
G[97843]={'11:67.92,72.26'}
G[97846]={'1024[16]:30.61,62.79 N:97094'}
G[97851]={'1017:68.37,64.98'}
G[97854]={'1080:53.92,45.79'}
G[97858]={'1080:41.57,52.93'}
G[97859]={'1017:68.06,68.94'}
G[97890]={'1017:65.58,58.50'}
G[97891]={'1038:29.45,39.33'}
G[97892]={'1038:27.90,51.76 N:33091'}
G[97895]={'1024:39.18,44.84'}
G[97903]={'1038:31.30,52.50'}
G[97906]={'1017:70.04,63.66'}
G[97919]={'1024:46.50,7.95'}
G[97920]={'1024:46.26,8.02'}
G[97923]={'1077:30.92,54.26 N:101195'}
G[97925]={'1024:32.19,66.86 N:41308'}
G[97933]={'1024:44.16,12.28'}
G[97957]={'1024:57.43,56.33'}
G[97973]={'1017:58.95,42.85'}
G[97974]={'1024:57.59,56.43'}
G[97978]={'1032[3]:62.54,53.52 N:78558'}
G[97979]={'1017:65.91,59.49 N:96465'}
G[97986]={'1017:70.20,69.48 N:96465'}
G[97988]={'1017:70.27,69.26 N:96254'}
G[97999]={'1024:49.04,36.31'}
G[98000]={'1077:52.72,51.06 N:98613'}	-- Druid class hall scouting map
G[98002]={'1077:52.56,51.45 N:40997'}	-- in release 21796 at: 1077:52.62,51.45
G[98003]={'1024:50.21,38.64'}
G[98008]={'Near1048'}
G[98013]={'1077:47.27,7.51 N:38243'}
G[98015]={'1017:54.67,34.96'}
G[98017]={'1080:44.49,45.51'}
G[98018]={'1017:54.02,42.41'}
G[98024]={'1024:50.80,34.57'}
G[98038]={'1024:48.54,41.71'}
G[98067]={'1024:42.73,10.93 N:25197'}
G[98092]={'1014[4]:37.84,45.09'}
G[98093]={'1014[4]:37.41,44.25'}
G[98102]={'1014[4]:40.78,75.40'}
G[98105]={'1017:53.69,70.61'}
G[98109]={'1017:71.18,60.54'}
G[98135]={'1018:54.79,71.70'}
G[98141]={'1018:61.05,69.39'}
G[98156]={'1018:54.40,57.70'}
G[98159]={'1015:46.88,40.80'}
G[98188]={'1017:41.88,33.78'}
G[98194]={'1024:47.06,12.20'}
G[98229]={'1028:28.60,63.06 N:93011'}
G[98232]={'1015:47.70,71.91'}
G[98233]={'1033:35.63,47.52'}
G[98234]={'1018:38.90,54.63'}
G[98241]={'1018:61.78,30.36'}
G[98268]={'1017:61.13,44.41'}
G[98273]={'1024:56.34,54.86'}
G[98283]={'945:83.43,43.58'}
G[98285]={'945:88.36,55.75'}
G[98299]={'1024:36.67,15.88'}
G[98306]={'1033:48.25,40.97'}
G[98311]={'1024:46.64,7.37'}
G[98312]={'1033:34.63,53.41'}
G[98367]={'1017:39.36,42.52'}
G[98371]={'27:73.45,52.19'}
G[98381]={'1015:46.84,40.87'}
G[98408]={'945:40.86,56.37'}
G[98411]={'1017:73.28,47.20'}
G[98412]={'1017:73.18,45.71'}
G[98421]={'1017:72.75,47.05'}
G[98486]={'1028:26.89,63.06'}
G[98498]={'1017:78.89,59.40'}
G[98500]={'1017:79.79,58.75'}
G[98501]={'1017:79.30,58.48'}
G[98502]={'1017:79.32,58.68'}
G[98503]={'1017:78.62,61.19'}
G[98519]={'1014[10]:69.69,46.82'}
G[98548]={'1033:36.60,46.96'}
G[98555]={'1033:35.10,50.79'}
G[98584]={'1018:52.46,63.42 N:40289'}
G[98587]={'1017:78.25,58.64'}
G[98613]={'1052[1]:58.64,54.38'}
G[98632]={'1052[1]:58.01,54.59 N:109295'}
G[98646]={'1052[1]:0.00,0.00'}
G[98648]={'1052[1]:0.00,0.00'}
G[98653]={'1024[5]:81.57,46.46'}
G[98675]={'1015:63.84,30.29'}
G[98685]={'481:54,39'}
G[98690]={'504[1]:50.40,46.16'}
G[98695]={'1068[1]:81.28,61.13 N:98613'}
G[98698]={'1015:36.53,34.09'}
G[98711]={'1028:73.15,33.81 N:97644'}
G[98720]={'1033:30.60,33.36'}
G[98721]={'1017:45.79,25.65'}
G[98757]={'1038:29.95,50.87'}
G[98784]={'1077:59.29,53.19'}
G[98791]={'1015:47.04,45.15'}
G[98794]={'1038:27.96,47.35'}
G[98801]={'1033:30.88,59.14'}
G[98808]={'1024:40.86,52.92'}
G[98825]={'1024[6]:74.74,74.96 N:93805'}
G[98890]={'1024:41.52,31.81'}
G[98931]={'1014[10]:34.71,28.81'}
G[98945]={'1044:48.98,58.42'}
G[98948]={'1080:36.91,78.88'}
G[98955]={'1017:58.66,65.51'}
G[98957]={'1024[29]:60.19,54.07'}
G[98964]={'1015:47.50,44.12'}
G[98969]={'1033:26.57,71.64'}
G[98970]={'1081[4]:0.00,0.00'}
G[98979]={'1033:45.88,39.24'}
G[99035]={'1018:46.95,39.70'}
G[99041]={'1044:52.86,60.19'}
G[99045]={'1028:60.52,44.83 N:97644'}
G[99065]={'1033:45.60,40.81'}
G[99070]={'1033:69.15,55.08'}
G[99075]={'1033:70.60,54.66'}
G[99088]={'1033:36.85,46.52'}
G[99093]={'1033:49.15,43.89'}
G[99153]={'1024[29]:43.21,28.25'}
G[99179]={'1044:52.76,59.64'}
G[99180]={'945:59.74,46.18'}
G[99181]={'1044:51.39,54.26'}
G[99183]={'945:59.87,46.22'}
G[99190]={'1024[29]:49.21,72.35 N:99153'}
G[99192]={'1067:84.26,88.07'}
G[99216]={'1024:54.60,58.95'}
G[99223]={'1017:44.31,26.26'}
G[99247]={'1014[10]:74.95,49.00 N:93011'}
G[99254]={'1014[10]:74.99,49.06 N:18417'}
G[99262]={'1014[10]:74.42,51.28 N:109196'}
G[99267]={'1033:39.60,52.89'}
G[99304]={'1033:76.54,63.45'}
G[99343]={'Near1014 N:97644'}
G[99370]={'181:40.93,58.69'}
G[99379]={'1017:40.59,68.45'}
G[99384]={'1024:39.82,57.44'}
G[99398]={'24:28.74,37.32 N:67996'}
G[99406]={'1024:40.02,63.86'}
G[99415]={'24:28.73,37.19'}
G[99420]={'1015:47.27,26.34'}
G[99452]={'181:39.91,57.66'}
G[99468]={'1024:57.66,56.56'}
G[99481]={'1024:40.84,51.48'}
G[99483]={'1033:47.29,33.49'}
G[99485]={'1033:26.02,85.75'}
G[99491]={'1080:34.00,56.53 N:95956'}
G[99502]={'1033:75.19,62.20'}
G[99514]={'1033:30.87,59.15'}
G[99544]={'1033:69.02,54.13'}
G[99559]={'1033:68.98,54.10'}
G[99575]={'1033:45.07,30.95'}
G[99581]={'1033:32.01,68.57'}
G[99584]={'1033:28.65,85.09'}
G[99588]={'1033:47.39,76.34'}
G[99589]={'1033:51.01,76.74'}
G[99593]={'1033:44.56,22.81'}
G[99610]={'1033:53.38,30.11'}
G[99632]={'1032[1]:78.17,36.38'}
G[99689]={'1015[18]:82.88,85.55'}
G[99749]={'1033:40.77,53.09'}
G[99759]={'1028:74.29,54.49'}
G[99762]={'1033:28.86,85.25'}
G[99764]={'1033:30.07,74.92'}
G[99765]={'1033[23]:61.44,65.05'}
G[99770]={'1033:74.44,56.72'}
G[99784]={'1024:53.62,42.13'}
G[99788]={'1033:43.38,41.72'}
G[99789]={'1033:43.44,31.73'}
G[99791]={'1033:21.34,54.42'}
G[99792]={'1033:22.21,51.58'}
G[99890]={'1033:30.02,69.41'}
G[99893]={'1033:74.93,63.38'}
G[99905]={'1080:42.30,46.93'}
G[99910]={'1018:72.59,51.04'}
G[99929]={'1024:49.10,7.66'}
G[99948]={'1033:70.58,48.81'}
G[100014]={'1033:28.15,38.70'}
G[100019]={'1033:33.13,75.07'}
G[100031]={'23[20]:63.10,37.23'}
G[100047]={'1033[23]:46.30,37.96'}
G[100185]={'1033:34.31,56.15'}
G[100192]={'1033:41.37,60.71'}
G[100237]={'1033:64.47,37.51'}
G[100301]={'1033:37.86,61.65'}
G[100323]={'34:77.42,36.30'}
G[100331]={'1033:37.82,61.57'}
G[100387]={'1018:52.52,64.15 N:33091'}
G[100395]={'301:20.09,34.90 N:48736'}
G[100409]={'1018:38.35,68.23'}
G[100429]={'301:85.89,31.58 N:1747'}
G[100430]={'1024:55.18,44.30'}
G[100433]={'1017:45.98,40.93'}
G[100435]={'1017:42.81,47.09'}
G[100438]={'1044:51.44,48.48'}
G[100441]={'1044:52.94,60.17'}
G[100446]={'1017:45.22,71.21'}
G[100453]={'4:57.17,10.53'}
G[100459]={'1018:56.23,57.34'}
G[100475]={'1044:49.12,58.63'}
G[100477]={'1024:49.38,39.26'}
G[100482]={'1015:47.97,25.90 N:89975'}
G[100495]={'1024:54.42,41.17'}
G[100571]={'720:54.85,32.91'}
G[100573]={'1018:62.33,76.23'}
G[100622]={'1035[1]:43.63,34.63'}
G[100635]={'1035[1]:59.76,13.49'}
G[100675]={'301:85.32,32.28 N:109196'}
G[100729]={'32:52.41,34.42'}
G[100738]={'1017:62.75,68.10'}
G[100775]={'1033:61.88,49.06'}
G[100778]={'1033:60.95,46.49'}
G[100779]={'1033:44.95,23.82'}
G[100786]={'Near1014'}
G[100812]={'32:49.46,74.73'}	-- old was 32:46.91,69.48
G[100823]={'1033:31.04,85.01'}
G[100841]={'1024:38.89,14.14'}
G[100864]={'1033:68.19,58.55'}
G[100866]={'4:45.71,15.88'}
G[100873]={'4:45.82,15.12 N:95238'}
G[100878]={'1033:31.16,84.61'}
G[100888]={'1033:70.95,50.41'}
G[100891]={'1033:71.48,49.75'}
G[100949]={'1033:69.27,68.38'}
G[100973]={'301:85.76,31.77 N:1747'}
G[100982]={'1028:33.93,69.96'}
G[100998]={'1033:80.26,58.98'}
G[100999]={'1033:82.29,62.61'}
G[101004]={'301:40.28,77.72'}
G[101008]={'1081[1]:0.00,0.00'}
G[101035]={'4:45.68,15.93 N:10181'}
G[101046]={'1044:49.20,58.63'}
G[101061]={'Near1014'}	-- before we marked him as moving we had: 1014[10]:57.56,45.72
G[101064]={'241:56.27,31.84 N:101061'}
G[101076]={'1033:26.79,70.80'}
G[101077]={'1024:45.15,55.89'}
G[101080]={'1033:37.89,47.28'}
G[101082]={'1033:37.94,47.37'}
G[101083]={'1033:37.83,47.26'}
G[101097]={'1014[11]:55.77,65.36'}
G[101195]={'1077:44.66,51.97'}	-- in release 21796 he is at 1077:44.66,51.97, does he move?, older was 1077:44.50,51.08
G[101259]={'1077:0.00,0.00'}	-- could not get map to appear near her
G[101282]={'32[27]:68.28,27.10'}	-- old value 32[1]:68.22,27.23
G[101310]={'1014[10]:46.15,21.35 N:42129'}
G[101313]={'1014[10]:46.30,20.57 N:17468'}
G[101314]={'20:78.96,40.98'}
G[101411]={'1046[1]:38.56,28.60'}
G[101441]={'1014[10]:72.80,46.66'}
G[101456]={'1014[11]:57.76,60.14'}
G[101476]={'1065:17.21,59.43'}
G[101499]={'1033:49.68,48.12'}
G[101513]={'1014[4]:41.44,78.07'}
G[101527]={'1014[10]:53.92,40.32'}
G[101532]={'1015:55.91,56.84'}
G[101547]={'32:46.99,75.09 N:78558'}
G[101554]={'1015:63.07,55.75'}
G[101581]={'1033:52.22,29.91'}
G[101644]={'1024:49.26,54.46'}
G[101645]={'1024:50.01,71.59'}
G[101649]={'1024:52.17,79.78'}
G[101651]={'34:48.83,34.22'}
G[101656]={'34:48.90,34.31'}
G[101700]={'1024:31.17,31.69'}
G[101759]={'301:76,17'}
G[101765]={'1033:32.21,12.73'}
G[101766]={'1033:27.83,21.19'}
G[101767]={'1033:33.72,18.08'}
G[101768]={'1033:36.44,22.40'}
G[101783]={'1033:26.81,17.02'}
G[101784]={'1033:27.83,19.11'}
G[101785]={'1024:55.47,77.70'}
G[101793]={'1024:27.54,41.96'}
G[101794]={'1024:31.18,26.48'}
G[101808]={'1024:27.07,44.30'}
G[101821]={'1033:59.71,34.38'}
G[101825]={'1033:52.44,45.10'}
G[101827]={'1024:24.56,42.29'}
G[101832]={'1024:24.55,42.34'}
G[101846]={'1014[10]:40.09,65.97'}
G[101848]={'1033:30.32,47.89'}
G[101868]={'1033:30.87,62.02'}
G[101878]={'1033:29.45,82.96'}
G[101900]={'1033:25.94,59.13'}
G[101927]={'1015:43.55,43.47 N:18417'}
G[101943]={'1015:42.48,46.93'}
G[101957]={'1024:40.89,48.54'}
G[101967]={'1018:38.69,87.35'}
G[101997]={'1024:42.63,48.11'}
G[102018]={'Near1014'}
G[102019]={'1041[3]:0.00,0.00'}
G[102059]={'1015:41.66,73.37'}
G[102064]={'1015:37.33,83.83'}
G[102066]={'1015:40.20,84.26'}
G[102075]={'1015:52.54,81.16'}
G[102120]={'673:40.76,69.12'}
G[102123]={'1024:54.04,77.76'}
G[102142]={'1033:34.46,48.73'}
G[102166]={'1018:39.26,86.65'}
G[102170]={'1017:75.87,90.12'}
G[102193]={'1014[11]:65.95,52.87'}
G[102195]={'1015:65.21,24.91'}
G[102196]={'1015:42.99,62.84'}
G[102197]={'1018:59.83,62.26'}
G[102198]={'1017:78.29,57.24'}
G[102218]={'1024:54.08,80.57'}
G[102232]={'1065:0.00,0.00'}
G[102242]={'1033:30.80,13.02'}
G[102274]={'1024:38.86,68.72'}
G[102297]={'1024:45.80,75.73'}
G[102303]={'1033:48.76,56.74'}
G[102309]={'1033:65.20,51.12'}
G[102333]={'Near1014'}
G[102334]={'1033:72.26,59.08'}
G[102361]={'1024:37.77,43.14'}
G[102365]={'1033:27.09,86.07'}
G[102381]={'Near1033'}
G[102387]={'1066[1]:50.72,48.19'}
G[102390]={'1033:75.95,52.72'}
G[102410]={'1033:70.68,48.78'}
G[102425]={'1033:31.43,23.18'}
G[102426]={'1033:31.51,23.17'}
G[102446]={'1066[1]:50.54,58.90'}
G[102450]={'1033:28.17,82.25'}
G[102468]={'1024:53.25,52.29'}
G[102478]={'1014[10]:60.03,53.44'}
G[102501]={'1024:53.13,54.11'}
G[102516]={'1018:22.47,67.48'}
G[102546]={'Near'}
G[102574]={'1072:43.54,24.65 N:102478'}
G[102578]={'1072:36.64,29.13 N:102478'}
G[102585]={'301:84.39,33.74 N:109196'}
G[102589]={'1040:49.97,53.67'}
G[102594]={'1014[4]:30.47,70.42'}
G[102600]={'1033[36]:39.81,29.61'}
G[102622]={'1018:40.36,86.12'}
G[102625]={'1017:74.15,86.82'}
G[102655]={'1040:49.36,53.43 N:101314'}
G[102666]={'1015:44.21,64.29'}
G[102669]={'1072:42.81,46.61 N:98613'}
G[102700]={'1068[2]:58.86,42.94'}
G[102709]={'1040:49.34,37.71'}
G[102727]={'1024:24.53,42.28'}
G[102728]={'1024:26.42,41.80'}
G[102736]={'1024:26.67,44.23'}
G[102743]={'1024:52.48,52.76'}
G[102744]={'1033:31.40,23.54'}
G[102746]={'1033:50.43,82.34'}
G[102747]={'1033:48.12,75.01'}
G[102748]={'1033:52.23,80.37'}
G[102799]={'1014[10]:73.85,46.04 N:97644'}
G[102820]={'1044:55.24,57.09'}
G[102827]={'1024:43.97,74.14'}
G[102841]={'1033:75.90,72.45'}
G[102843]={'1017:62.16,20.79'}
G[102845]={'1033:70.60,49.17'}
G[102855]={'1044:31.13,40.57'}
G[102864]={'1018:33.51,44.10'}
G[102866]={'1017:62.16,91.69'}
G[102867]={'1018:33.65,42.83'}
G[102868]={'1024:61.34,58.13'}
G[102869]={'1017:60.39,88.36'}
G[102871]={'1024:24.72,57.80'}
G[102872]={'1024:24.57,56.88'}
G[102873]={'1018:33.77,44.47'}
G[102874]={'1024:25.47,57.83'}
G[102875]={'1017:62.48,93.32'}
G[102876]={'1024:61.37,58.12'}
G[102877]={'1017:48.97,23.00'}
G[102878]={'1017:62.41,93.42'}
G[102884]={'1024:43.67,59.53'}
G[102886]={'1024:43.45,74.50'}
G[102887]={'1024:43.47,59.55'}
G[102890]={'1024:43.29,59.25'}
G[102898]={'1033:32.70,67.58'}
G[102902]={'1044:51.11,49.50'}
G[102913]={'1033:83.12,62.65'}
G[102917]={'1024:42.77,57.25'}
G[102938]={'1018:67.45,56.12 N:7999'}
G[102940]={'1072:47.29,53.94'}
G[102969]={'1033:35.55,11.71'}
G[102982]={'1024:44.40,45.79'}
G[102983]={'1024:44.03,48.02'}
G[102988]={'1015:49.66,26.80 N:78558'}
G[102996]={'1017:44.91,71.76'}
G[103022]={'1018:69.54,49.52 N:7999'}
G[103023]={'1072:42.82,46.91'}
G[103025]={'1052[2]:59.72,45.71'}
G[103049]={'1041[1]:0.00,0.00'}
G[103090]={'1024:54.68,75.62'}
G[103092]={'1014[10]:48.48,63.37'}
G[103129]={'1033:30.09,10.40'}
G[103131]={'1033:47.26,56.47'}
G[103155]={'1033:37.02,46.23'}
G[103156]={'1014[10]:65.64,67.29 N:18417'}
G[103174]={'1024:54.18,79.39'}
G[103175]={'1033:41.52,71.23'}
G[103176]={'1015:38.39,47.80'}
G[103177]={'1024:54.11,81.07'}
G[103180]={'1015:37.51,49.20'}
G[103181]={'1033:41.65,71.11'}
G[103183]={'1033:79.64,72.66'}
G[103185]={'1033:79.63,72.78'}
G[103204]={'1033:28.46,82.66'}
G[103208]={'1015:48.07,27.23'}
G[103210]={'1024:60.83,58.65'}
G[103214]={'1033:67.80,70.94'}
G[103223]={'1033:61.28,39.67'}
G[103231]={'1015:37.77,49.81'}
G[103235]={'1024:54.49,81.46'}
G[103245]={'1017:49.03,23.65'}
G[103307]={'1024:25.08,56.21'}
G[103326]={'1033:35.94,21.47'}
G[103363]={'1015:39.00,57.68'}
G[103430]={'1017:61.63,90.39'}
G[103431]={'1017:62.25,93.48'}
G[103437]={'Near1033'}
G[103446]={'1024:27.45,54.95'}
G[103453]={'1017:61.72,90.26'}
G[103457]={'1018:37.45,77.88'}
G[103482]={'1015:47.43,42.57'}
G[103484]={'1017:52.19,52.66'}
G[103485]={'1080:45.89,45.04'}
G[103502]={'1033:77.90,57.13'}
G[103506]={'1014[10]:57.70,45.31'}
G[103527]={'1033:31.35,30.47'}
G[103534]={'1033:77.47,59.84'}
G[103568]={'1033:25.68,30.87'}
G[103569]={'1033:28.30,29.70'}
G[103570]={'1033:25.67,30.92'}
G[103571]={'1033:30.34,30.81'}
G[103575]={'1033:76.73,57.65'}
G[103614]={'895:41.92,31.63'}
G[103616]={'1033:33.34,28.77'}
G[103643]={'1024:33.15,64.63'}
G[103653]={'1024:25.28,56.78'}
G[103656]={'1024:42.07,33.40'}
G[103671]={'1033:35.40,70.64'}
G[103681]={'1024:42.76,33.96'}
G[103712]={'1033:21.34,30.50'}
G[103729]={'1017:62.67,89.95'}
G[103732]={'1052[1]:0.00,0.00'}
G[103734]={'1080:13.66,55.45'}
G[103745]={'1024:61.05,56.36'}
G[103757]={'1017:61.99,93.87'}
G[103761]={'1052[1]:59.30,57.60 N:97644'}
G[103778]={'1077:67.28,75.72 N:37570'}	-- 1077:68.99,75.89
G[103784]={'1015:33.78,11.56'}
G[103785]={'1018:49.35,46.74'}
G[103786]={'1017:52.42,59.02'}
G[103787]={'1033:24.68,49.34'}
G[103797]={'1017:60.47,50.68'}
G[103827]={'1033:87.45,62.17'}
G[103832]={'1077:44.68,50.18'}
G[103837]={'1024:59.13,66.75'}
G[103841]={'1033:16.93,26.81'}
G[103842]={'1015:61.54,41.75'}
G[103844]={'1018:47.65,77.00'}
G[103846]={'1017:55.28,31.09'}
G[103848]={'1033:35.64,38.38'}
G[103850]={'1024:60.01,67.18'}
G[103875]={'241:66.74,60.53 N:33091'}
G[103975]={'1015:40.37,76.79'}
G[104147]={'1033:19.00,24.95'}
G[104161]={'1033:35.78,72.42'}
G[104220]={'1033:21.75,29.43'}
G[104224]={'1033:28.35,34.75'}
G[104226]={'1033:30.03,32.89'}
G[104240]={'1077:52.65,51.16'}
G[104241]={'1077:45.93,51.03 N:33091'}
G[104243]={'1024:51.06,79.34'}
G[104248]={'1024:50.75,79.75'}
G[104258]={'1015:53.15,30.35'}
G[104287]={'11:49.86,60.67'}
G[104289]={'1018:34.01,40.65'}
G[104290]={'1024:61.20,56.98'}
G[104292]={'1017:48.82,20.68'}
G[104294]={'1017:48.79,20.13'}
G[104302]={'1024:52.38,48.08'}
G[104310]={'1024:50.88,50.67'}
G[104311]={'1024:50.93,50.40'}
G[104323]={'1024:48.57,27.41'}
G[104328]={'1024:46.70,28.12'}
G[104343]={'1033[35]:58.08,18.11'}
G[104344]={'1033:38.72,61.96'}
G[104349]={'1077:0.00,0.00'}
G[104369]={'1033:42.39,76.87'}
G[104378]={'1018:53.75,87.28'}
G[104381]={'1014[10]:71.39,50.63'}
G[104385]={'490:50.51,37.61'}
G[104394]={'1033:41.61,59.91'}
G[104404]={'1033:60.45,46.22'}
G[104406]={'1033:74.94,63.39'}
G[104419]={'24:65.18,67.34'}
G[104423]={'24:47.91,55.07'}
G[104425]={'39:51.30,53.51'}
G[104426]={'27:76.46,56.20'}
G[104432]={'27:64.84,56.60'}
G[104445]={'11:49.30,59.13'}
G[104450]={'161:50.88,28.19'}
G[104463]={'161:51.44,29.83'}
G[104475]={'161:51.54,29.49'}
G[104481]={'1024:28.15,52.83'}
G[104484]={'1024:33.85,21.25'}
G[104489]={'39:54.47,43.63'}
G[104513]={'1024:56.76,48.32'}
G[104518]={'1080[6]:67.35,74.07'}
G[104519]={'1033:24.44,54.44'}
G[104521]={'1033:24.44,54.44'}
G[104522]={'1033:23.56,56.91'}
G[104523]={'1018:52.10,39.77'}
G[104524]={'1024:52.63,58.30'}
G[104535]={'490:51.28,36.83 N:101259'}
G[104576]={'1033:77.45,57.19'}
G[104577]={'1077:45.20,51.82'}
G[104582]={'1024:52.77,13.85'}
G[104585]={'1024:51.99,11.80'}
G[104586]={'1033:77.55,59.77'}
G[104597]={'1024:52.49,13.30'}
G[104614]={'1080:57.37,61.27'}
G[104615]={'1080:41.01,69.64'}
G[104618]={'1033:20.65,55.14'}
G[104624]={'1080:48.75,43.98'}
G[104630]={'1033:75.90,52.54'}
G[104640]={'1015:52.19,43.55'}
G[104661]={'1033:22.93,52.70'}
G[104690]={'1024:54.86,82.66'}
G[104692]={'1080:29.87,58.17'}
G[104728]={'1018:66.21,44.78 N:7999'}
G[104744]={'806:45.50,25.12'}
G[104745]={'806:38.34,25.77'}
G[104784]={'806:38.95,24.94'}
G[104799]={'1018:57.82,38.59 N:7999'}
G[104850]={'806:42.06,25.45'}
G[104875]={'27:53.54,51.15'}
G[104885]={'1018:66.93,50.13 N:7999'}
G[104900]={'11:49.68,61.24'}
G[104901]={'11:49.66,59.07'}
G[104921]={'1018:53.71,55.89 N:7999'}
G[104926]={'161:51.51,29.21'}
G[104984]={'1044:51.11,49.50'}
G[105019]={'1044:54.48,57.16'}
G[105046]={'1044:51.85,49.57'}
G[105056]={'1044:51.85,49.57'}
G[105058]={'1044:51.85,49.57'}
G[105071]={'1033:40.11,70.80'}
G[105072]={'1017:67.79,70.45'}
G[105088]={'1017:68.04,70.42'}
G[105104]={'1018:38.90,61.98'}
G[105152]={'1017:68.09,70.39'}
G[105316]={'1028:34.78,70.24'}
G[105342]={'1033:43.37,78.71'}
G[105360]={'1015:35.74,15.32'}
G[105361]={'1015:37.06,19.93'}
G[105362]={'1015:36.54,16.35'}
G[105433]={'1017:61.13,68.18'}
G[105436]={'1017:66.82,41.40'}
G[105443]={'1017:64.28,46.51'}
G[105464]={'1014[11]:67.36,62.69'}
G[105486]={'1033:21.19,44.63'}
G[105502]={'1017:61.63,43.76'}
G[105525]={'1017:60.13,42.54'}
G[105526]={'1017:60.81,42.74'}
G[105532]={'1017:58.41,46.66'}
G[105547]={'1033:23.92,25.69'}
G[105554]={'1033:22.18,33.95'}
G[105613]={'1033[32]:38.38,41.37'}
G[105623]={'1033:21.91,39.46'}
G[105625]={'1033:21.53,42.27'}
G[105632]={'1033[33]:67.02,51.67'}
G[105676]={'1033:23.93,43.74'}
G[105685]={'1033:24.62,43.95'}
G[105686]={'1033:25.09,44.30'}
G[105710]={'1017:61.20,41.76'}
G[105718]={'1017:56.00,41.76'}
G[105728]={'1033:23.30,44.84'}
G[105739]={'1033[33]:35.78,32.35'}
G[105746]={'1017:54.27,44.94'}
G[105748]={'1017:56.18,45.94'}
G[105749]={'1017:56.59,39.29'}
G[105753]={'1033:23.88,44.89'}
G[105756]={'1033:22.06,38.67'}
G[105759]={'1033:50.55,60.25'}
G[105785]={'1033:22.57,49.64'}
G[105793]={'1018:60.04,67.39'}
G[105823]={'1018:73.09,50.67'}
G[105826]={'1018:60.93,66.29'}
G[105838]={'1015:62.46,50.96'}
G[105885]={'1033:20.17,50.08'}
G[105897]={'1018:57.61,69.84'}
G[105899]={'1033:65.87,54.30'}
G[105903]={'1018:57.17,71.26'}
G[105919]={'1015:43.55,24.44'}
G[105932]={'1018:63.96,58.45'}
G[105933]={'1018:67.21,58.21'}
G[105938]={'1015:43.60,24.58'}
G[105948]={'1018:56.76,71.54'}
G[105960]={'1018:49.59,87.80'}
G[105973]={'1018:47.56,88.21'}
G[106009]={'1018:41.44,59.32'}
G[106032]={'1033:51.13,76.24'}
G[106074]={'1024:30.40,27.11'}
G[106077]={'1024:29.45,29.44'}
G[106091]={'1077:48.99,47.23'}
G[106093]={'1077:49.02,46.80'}
G[106095]={'1033:29.69,18.63'}
G[106106]={'1015:54.52,45.82'}
G[106115]={'1024:51.30,66.95'}
G[106119]={'1033:17.76,47.36'}
G[106135]={'1048:43.02,30.33'}
G[106136]={'1048:45.20,32.61'}
G[106182]={'1033:33.71,18.02'}
G[106195]={'1024:52.23,65.90'}
G[106204]={'1048:43.32,30.77'}
G[106250]={'606:60.46,23.62'}
G[106275]={'1033:35.53,18.99'}
G[106286]={'1018:71.24,54.90'}
G[106288]={'1018:69.32,46.67'}
G[106297]={'1015:46.59,14.48'}
G[106299]={'1077:44.47,51.51'}
G[106331]={'1018:69.23,43.71'}
G[106339]={'1033:30.38,74.05'}
G[106340]={'1018:74.99,44.35'}
G[106351]={'1033:33.76,15.09'}
G[106358]={'1018:49.92,77.25'}
G[106369]={'1018:50.33,75.24'}
G[106372]={'1018:50.38,73.19'}
G[106384]={'1018:50.28,73.76'}
G[106419]={'1018:67.16,30.15'}
G[106430]={'161:51.45,30.08'}
G[106442]={'1077:38.48,34.12'}
G[106467]={'1018:68.50,33.82'}
G[106482]={'1094[2]:55.42,48.89'}
G[106522]={'1088[9]:0.00,0.00'}
G[106526]={'1033:35.38,66.80'}
G[106537]={'1015:68.13,28.36'}
G[106558]={'1076[2]:44.92,37.37'}
G[106568]={'1017:36.07,68.31'}
G[106582]={'1015:68.37,26.15'}
G[106583]={'1015:67.29,30.72'}
G[106629]={'1015:38.81,53.26'}
G[106630]={'1015:49.51,21.91'}
G[106638]={'1018:73.62,39.44'}
G[106654]={'1033:49.56,79.58'}
G[106655]={'1014[10]:45.21,29.07'}
G[106665]={'1015:51.54,20.07'}
G[106695]={'1015:64.97,48.94'}
G[106696]={'1033:19.59,22.38'}
G[106764]={'1033:20.02,21.21'}
G[106765]={'1033:16.70,22.84'}
G[106780]={'1046[1]:55.53,54.29'}
G[106788]={'1015:65.97,49.07'}
G[106804]={'1033:18.16,28.03'}
G[106842]={'1018:65.68,45.55'}
G[106879]={'1014[10]:69.69,43.06 N:104381'}
G[106881]={'1015:64.25,56.12'}
G[106883]={'1018:59.85,75.18'}
G[106897]={'1033:61.83,49.10'}
G[106901]={'1018:54.70,73.24'}
G[106902]={'1080:38.08,46.04'}
G[106904]={'1017:60.27,51.38'}
G[106905]={'1086:66.24,66.84'}
G[106914]={'1015:50.41,30.79'}
G[106915]={'1015:50.46,30.73'}
G[106919]={'1033:47.73,72.10'}
G[106920]={'1015:62.68,32.25'}
G[106930]={'1014[10]:28.48,74.54'}
G[106942]={'1044:46.70,46.77'}
G[106951]={'1014[10]:60.33,17.31'}
G[106990]={'1015:65.55,56.77'}
G[107008]={'1015:40.47,40.84'}
G[107023]={'1017:46.62,29.72'}
G[107025]={'1077:48.37,55.61'}
G[107026]={'Near1077'}
G[107075]={'1033:33.70,28.89'}
G[107098]={'1015:49.73,25.48'}
G[107102]={'1015:34.70,43.96'}
G[107103]={'1015:31.99,42.89'}
G[107105]={'1015:33.37,41.36'}
G[107108]={'1015:40.49,44.99'}
G[107113]={'1015:37.21,43.25'}
G[107126]={'1033:36.85,46.55'}	-- he moves to 1033:36.54,46.80 when 43318 turned in
G[107127]={'1015:55.46,46.14'}
G[107132]={'1086:61.47,65.69'}
G[107133]={'1015:28.14,51.78'}
G[107135]={'1015:30.80,45.97'}
G[107136]={'1015:30.77,48.32'}
G[107139]={'1015:46.86,40.95'}
G[107163]={'1086:61.22,65.20'}
G[107201]={'1015:26.32,44.18'}
G[107212]={'1086:42.15,27.98'}
G[107216]={'1015:28.34,45.67'}
G[107225]={'1033:51.18,76.14'}
G[107244]={'1015:63.85,28.94 N:106914'}
G[107245]={'1015:63.88,28.88 N:106915'}
G[107253]={'1033:48.93,73.44'}
G[107258]={'1017:44.26,34.56'}
G[107266]={'1015:27.75,51.07'}
G[107269]={'1015:28.32,52.08'}
G[107302]={'1033:15.87,54.87'}
G[107323]={'1015:33.22,56.28'}
G[107327]={'1015:29.29,53.61'}
G[107328]={'1015:35.12,45.97'}
G[107334]={'1015[17]:30.32,45.31'}
G[107335]={'1015:29.09,52.46'}
G[107362]={'1015:33.03,54.02'}
G[107363]={'1015:32.89,52.79'}
G[107367]={'1015:49.80,38.54'}
G[107368]={'1015:33.03,53.18'}
G[107376]={'1015:46.91,41.43'}
G[107379]={'1015:48.18,73.90'}
G[107392]={'1018:70.40,46.68'}
G[107398]={'1033:17.17,37.89'}
G[107439]={'1015:51.88,33.06'}
G[107440]={'1015:34.55,42.24'}
G[107447]={'1021:0.00,0.00'}
G[107455]={'1017:44.92,38.11'}
G[107460]={'1017:30.27,40.56'}
G[107463]={'1017:58.90,32.09'}
G[107469]={'1017:51.84,29.67'}
G[107487]={'1017:54.65,28.98'}
G[107498]={'1017:54.05,30.20'}
G[107499]={'1017:50.31,34.04'}
G[107545]={'1015:31.48,51.11'}
G[107554]={'4:47.31,17.74'}
G[107567]={'1033:39.25,60.80'}
G[107574]={'301:85.69,31.78'}
G[107588]={'1017:72.32,51.66'}
G[107598]={'1033:47.85,82.97'}
G[107616]={'11:66.84,39.41'}
G[107624]={'1015:34.60,33.79'}
G[107625]={'1015:39.15,34.72'}
G[107628]={'1015:36.85,33.13'}
G[107629]={'1015:36.94,35.04'}
G[107632]={'1033:47.05,61.97'}
G[107657]={'1015:34.93,33.87'}
G[107659]={'34:19.53,57.18'}
G[107660]={'1080:42.95,38.80'}
G[107666]={'1018:65.92,46.16'}
G[107667]={'1017:57.80,21.02'}
G[107674]={'1017:51.31,56.97'}
G[107675]={'1017:51.37,57.25'}
G[107696]={'1015:34.41,33.82'}
G[107712]={'1033:48.31,83.25'}
G[107715]={'1015:34.54,33.90'}
G[107720]={'1033:47.47,71.32'}
G[107723]={'1052[2]:58.41,51.62 N:18417'}
G[107724]={'1052[1]:0.00,0.00'}
G[107753]={'1017:46.99,56.45'}
G[107755]={'1017:51.72,53.40'}
G[107758]={'1017:49.83,57.80'}
G[107763]={'1033:21.11,40.06'}
G[107801]={'1015:59.84,12.03'}
G[107803]={'1017:58.48,51.07'}
G[107805]={'1017:50.77,51.64'}
G[107811]={'1033:19.43,41.83'}
G[107840]={'1017:36.96,31.84 1017:44.86,59.26 1017:37.35,63.77 1017:33.82,45.75 1017:63.46,61.63 1017:51.35,57.27 1017:75.01,55.53 1017:56.51,67.59 1017:54.46,68.77 1017:52.55,64.11'}
G[107846]={'1033:66.70,67.20'}
G[107883]={'1017:53.18,76.34'}
G[107926]={'1017:51.60,74.72'}
G[107934]={'301:37.08,43.09'}
G[107945]={'1015:28.33,52.13'}
G[107959]={'1033[33]:0.00,0.00'}
G[107965]={'1017:42.36,61.18'}
G[107968]={'1014[10]:26.01,52.08 N:20735'}
G[107979]={'30:36.78,52.57'}
G[107995]={'1015:57.56,13.55 N:89794'}
G[107997]={'1033:48.36,83.30'}
G[108009]={'1024[29]:60.19,54.07'}
G[108014]={'1024:47.94,70.80'}
G[108017]={'1024[6]:54.91,77.94'}
G[108029]={'1017:75.18,49.52'}
G[108030]={'1017:72.41,55.73'}
G[108062]={'1017:76.98,52.97'}
G[108063]={'1033:44.21,73.05'}
G[108069]={'1024[29]Near N:99153'}
G[108072]={'1017:74.90,55.57'}
G[108096]={'1033:44.40,66.26'}
G[108101]={'1033[33]:0.00,0.00'}
G[108133]={'1015:58.25,70.05'}
G[108136]={'1015:58.50,78.98'}
G[108137]={'1015:61.16,68.70'}
G[108139]={'1015:60.16,65.14'}
G[108146]={'1015:58.32,71.16'}
G[108153]={'1015:57.69,75.06'}
G[108185]={'1024:49.99,68.33'}
G[108190]={'1033:65.70,62.73'}
G[108239]={'1052[1]:57.95,56.86'}
G[108250]={'1052[1]:57.87,57.14'}
G[108259]={'1018:56.96,80.90'}
G[108283]={'1017:42.59,43.10'}
G[108289]={'1017:43.98,44.92'}
G[108304]={'1018:59.42,84.12'}
G[108305]={'1024:47.47,84.73 N:93826'}
G[108313]={'1017:43.23,40.51'}
G[108314]={'1033:35.14,73.85'}
G[108326]={'1052[1]:56.22,38.86'}
G[108327]={'1018:59.76,81.72'}
G[108328]={'1015:53.39,45.43'}
G[108334]={'1015:55.50,70.25'}
G[108335]={'1015:56.56,64.17'}
G[108338]={'1015:55.47,70.28'}
G[108339]={'1015:55.80,64.43'}
G[108340]={'1015:57.52,63.11'}
G[108343]={'1015:56.54,64.99'}
G[108348]={'1015:56.12,68.37'}
G[108358]={'1018:59.46,82.02'}
G[108389]={'1033:15.22,51.83'}
G[108390]={'1033:15.23,51.76'}
G[108411]={'1033:48.29,83.24'}
G[108434]={'1080[6]:54.83,63.20 N:93826'}
G[108440]={'1015:54.22,71.23'}
G[108446]={'1015:54.73,68.82'}
G[108447]={'1015:56.80,72.02'}
G[108450]={'1015:54.96,72.46'}
G[108451]={'1015:56.80,72.02'}
G[108454]={'1015:53.93,72.15'}
G[108464]={'161:55.32,59.14'}
G[108489]={'1024[29]:40.30,50.57'}
G[108499]={'1024:31.16,47.26'}
G[108504]={'1024:29.78,40.09'}
G[108526]={'1017:41.59,66.56'}
G[108528]={'1033:55.29,39.97'}
G[108529]={'1024:41.18,11.04'}
G[108535]={'1033:13.64,48.45'}
G[108571]={'1052[1]:58.63,57.85 N:18417'}
G[108572]={'1052[1]:58.59,57.85 N:93011'}
G[108576]={'1017:64.96,59.06'}
G[108600]={'1018:59.04,82.44'}
G[108663]={'1017:66.51,63.84'}
G[108675]={'1018:57.82,81.38'}
G[108678]={'1018:55.45,43.38'}
G[108685]={'1017:37.47,64.18'}
G[108721]={'1015:48.47,27.09'}
G[108776]={'22:51.56,79.05 N:11034'}
G[108777]={'22:51.44,79.03 N:1854'}
G[108778]={'22:51.34,79.01 N:78577'}
G[108782]={'1052[1]:57.59,52.31'}
G[108784]={'1052[1]:59.64,49.13'}
G[108790]={'1017:38.46,69.72'}
G[108825]={'1014[10]:0.00,0.00'}
G[108827]={'1017:66.72,51.14'}
G[108829]={'1015:43.24,68.02'}
G[108856]={'1017:68.45,49.87'}
G[108870]={'1033:58.21,53.04'}
G[108871]={'1033:57.82,51.06'}
G[108872]={'1033:54.53,52.24'}
G[108875]={'1033:61.32,56.27'}
G[108876]={'1018:46.22,50.35'}
G[108879]={'1018:24.68,69.58'}
G[108885]={'1017:52.46,23.80'}
G[108887]={'1018:59.33,84.00'}
G[108916]={'301:18.99,26.45'}
G[108927]={'1017:37.25,38.61'}
G[108940]={'1017:70.84,44.35'}
G[108942]={'1033:23.63,48.63'}
G[108961]={'Near1014'}
G[109008]={'1033:22.80,36.18'}
G[109022]={'1033:30.54,40.01'}
G[109023]={'1033:61.04,57.71'}
G[109025]={'1033:62.17,58.93'}
G[109045]={'1018:66.82,75.67'}
G[109053]={'1015:61.43,41.71'}
G[109054]={'1033:26.25,41.19'}
G[109073]={'1018:68.26,71.82'}
G[109110]={'1017:71.97,59.77'}
G[109113]={'1017:30.72,33.86'}
G[109125]={'1018:45.53,83.75'}
G[109154]={'1015:45.74,40.13'}
G[109157]={'1017:55.33,31.09'}
G[109163]={'1022:70.67,19.92'}
G[109174]={'1015:49.8,40'}
G[109180]={'1033:62.87,58.49'}
G[109195]={'1017[1]:58.49,16.01'}
G[109196]={'1014[10]:95.16,64.90'}
G[109199]={'1033:51.08,78.59'}
G[109201]={'1018:47.79,76.91'}
G[109202]={'1033:60.66,56.58'}
G[109212]={'1033:60.59,56.38'}
G[109281]={'1018:43.03,74.78'}
G[109295]={'1014[10]:95.13,65.14'}
G[109318]={'1017:77.89,9.13'}
G[109324]={'1191:36.15,59.78'}
G[109326]={'1015:50.07,21.42'}
G[109331]={'1015:38.31,84.57'}
G[109334]={'1015:51.94,61.79 N:88873'}
G[109349]={'1015:65.62,47.18'}
G[109368]={'1015:47.39,40.02'}
G[109408]={'1033:50.52,77.18'}
G[109409]={'1033:45.77,74.89'}
G[109442]={'1033:50.57,78.25'}
G[109466]={'301:85.79,31.71'}
G[109498]={'1024:51.96,59.90'}
G[109504]={'1015:32.65,48.76'}
G[109521]={'1017:76.81,63.57'}
G[109575]={'1015:58.27,21.38'}
G[109584]={'1015:66.15,39.85'}
G[109594]={'1015:51.07,58.10'}
G[109618]={'27:64.10,54.60'}
G[109620]={'1015:43.16,7.61'}
G[109630]={'1015:29.09,48.95'}
G[109631]={'1018:66.68,77.25'}
G[109633]={'1017:56.60,73.36'}
G[109635]={'1017:57.37,72.43'}
G[109639]={'1017:72.74,62.08'}
G[109640]={'1017:73.98,58.61'}
G[109641]={'1015:56.72,10.95'}
G[109648]={'1018:23.79,70.97'}
G[109653]={'1015:33.65,28.65'}
G[109677]={'1015:58.94,76.61'}
G[109692]={'1018:33.64,61.58'}
G[109702]={'1015:55.77,63.57'}
G[109708]={'1018:67.09,69.55'}
G[109714]={'1018:66.97,69.56'}
G[109734]={'1018:35.00,56.04'}
G[109738]={'1018:56.31,73.86'}
G[109741]={'11:48.57,58.90'}
G[109788]={'1021[2]:0.00,0.00'}
G[109795]={'1017:68.13,48.80'}
G[109803]={'1033:15.23,51.87'}
G[109819]={'1018:66.96,69.91'}
G[109823]={'1044:31.31,40.72'}
G[109826]={'1015:55.60,16.99'}
G[109839]={'1018:32.41,47.89'}
G[109854]={'1014[10]:47.34,40.68'}
G[109867]={'1017:69.03,20.25'}
G[109890]={'1021[2]:40.33,68.57'}
G[109912]={'11:51.33,57.59'}
G[109928]={'1018:60.21,31.77'}
G[109929]={'1018:60.31,33.80'}
G[109943]={'1033:31.13,65.89'}
G[109954]={'1033:42.10,80.20'}
G[109967]={'1017:60.74,24.65'}
G[109990]={'1018:32.40,47.93'}
G[110018]={'1014[10]:50.13,22.63'}
G[110024]={'1033:34.13,60.98'}
G[110034]={'301:84.62,24.88'}
G[110035]={'321[1]:36.38,74.25'}
G[110042]={'1033:60.54,52.00'}
G[110073]={'1015:37.16,17.21'}
G[110253]={'1033:69.87,63.07'}
G[110258]={'1017:78.66,61.21'}
G[110340]={'1033:39.51,34.61'}
G[110342]={'1018:69.51,57.52'}
G[110346]={'1018:59.61,50.58'}
G[110347]={'1015:35.84,18.67'}
G[110361]={'1018:70.33,52.27'}
G[110363]={'1017:58.41,34.23'}
G[110365]={'1033:56.62,60.83'}
G[110371]={'1033:21.32,33.45'}
G[110378]={'1024:58.02,72.29'}
G[110415]={'1033:44.66,74.40'}
G[110418]={'1033:44.59,74.42'}
G[110423]={'1018:64.77,46.27'}
G[110433]={'1052[1]:59.72,44.53'}
G[110435]={'1015:35.97,18.60'}
G[110438]={'1033:36.37,22.18'}
G[110448]={'1015:35.42,13.25'}
G[110468]={'1015:38.41,17.52'}
G[110472]={'1015:35.59,17.44'}
G[110482]={'1052[1]:0.00,0.00'}
G[110496]={'1024:33.28,64.30'}
G[110531]={'1018:56.67,56.34'}
G[110538]={'1033[32]:42.28,14.99'}
G[110562]={'1018:45.59,88.75'}
G[110577]={'1033:24.44,47.51'}
G[110619]={'1015:31.33,50.83'}
G[110642]={'1014[11]:76.10,83.57'}
G[110645]={'1017:46.65,61.51'}
G[110656]={'1033:65.52,59.24'}
G[110667]={'1017:29.37,53.41'}
G[110679]={'1033:57.54,57.58'}
G[110695]={'1091:44.91,9.39 N:17204'}
G[110698]={'1033:48.27,66.85'}
G[110702]={'1033:35.40,41.33'}
G[110703]={'1033:23.14,33.49'}
G[110726]={'1033:62.67,47.38'}
G[110742]={'1091:44.30,8.03'}
G[110768]={'1052[1]:0.00,0.00'}
G[110771]={'1033[1]:55.35,39.35'}
G[110773]={'1015:48.14,25.60'}
G[110791]={'1088[2]:0.00,0.00'}
G[110805]={'1033:30.03,76.85'}
G[110817]={'1044:53.41,57.74'}
G[110824]={'1033:18.61,61.12'}
G[110832]={'1033:27.46,65.57'}
G[110838]={'1015:37.89,15.37'}
G[110870]={'1033:42.40,56.66'}
G[110896]={'1018:56.95,53.27'}
G[110903]={'1024:28.62,55.31'}
G[110904]={'1024:32.39,60.15'}
G[110915]={'1033:38.45,23.20'}
G[110916]={'1024:58.16,18.85'}
G[110944]={'1033:56.82,50.50'}
G[110949]={'1033:38.22,87.08'}
G[110971]={'1015:31.72,47.07'}
G[110975]={'1024:39.81,62.69'}
G[110981]={'1017:54.11,49.23'}
G[110987]={'1033:50.68,56.58'}
G[111002]={'1033:55.83,57.85'}
G[111007]={'1033:49.65,79.06'}
G[111019]={'1033:48.00,52.29'}
G[111062]={'1033:46.98,53.05'}
G[111086]={'1091:44.15,11.30'}
G[111109]={'1014[10]:57.61,45.75'}
G[111162]={'1033:56.12,58.00'}
G[111184]={'1080:45.70,38.88'}
G[111197]={'1033:33.71,52.24'}
G[111206]={'1017:44.40,24.96'}
G[111243]={'1014[10]:57.40,66.94'}
G[111246]={'1014[10]:63.57,54.84'}
G[111252]={'1018:47.50,45.22'}
G[111278]={'1018:46.79,44.72'}
G[111279]={'1018:46.21,41.71'}
G[111280]={'1018:46.94,43.94'}
G[111281]={'1018:47.45,46.58'}
G[111291]={'1017:47.92,62.46'}
G[111318]={'1033:41.60,56.18'}
G[111323]={'1021:49.67,21.03'}
G[111325]={'1017:84.73,13.81'}
G[111327]={'1017:52.09,33.47'}
G[111328]={'1017:89.01,15.31'}
G[111329]={'1033:36.03,34.23'}
G[111338]={'1017:80.86,9.30'}
G[111383]={'1018:33.62,55.42'}
G[111384]={'1018:34.26,55.02'}
G[111397]={'1017:88.90,11.02'}
G[111446]={'1033:49.10,73.29'}
G[111457]={'1015:38.16,85.50'}
G[111459]={'1018:24.41,66.48'}
G[111460]={'1018:21.59,68.46'}
G[111469]={'1015:43.64,82.13'}
G[111473]={'1018:21.87,65.07'}
G[111474]={'1018:22.27,65.31'}
G[111479]={'1015:43.64,82.13'}
G[111484]={'1033:57.03,62.28'}
G[111489]={'1033:54.54,63.12'}
G[111490]={'1033:58.81,64.17'}
G[111530]={'1033:34.82,22.39'}
G[111578]={'1024:41.03,43.41'}
G[111599]={'1033:33.10,18.43'}
G[111609]={'1033:30.97,11.34'}
G[111611]={'1033:32.02,13.61'}
G[111627]={'1015:48.36,73.18'}
G[111637]={'1096:52.76,51.92'}
G[111641]={'1096:40.61,53.08'}
G[111675]={'1033:33.28,49.05'}
G[111736]={'1052[1]:0.00,0.00'}
G[111737]={'1077:33.90,32.57'}
G[111751]={'1015:42.85,79.16'}
G[111752]={'1015:42.27,73.55'}
G[111760]={'1017:55.13,65.87'}
G[111761]={'1017:54.80,66.22'}
G[111763]={'1015:43.13,74.87'}
G[111786]={'1077:43.29,63.23'}
G[111814]={'1017:62.53,68.22'}
G[111826]={'1033:37.81,47.40'}
G[111869]={'1033:64.72,37.84'}
G[111871]={'1033:64.66,37.79'}
G[111900]={'1033:47.86,81.50'}
G[111903]={'1033:47.81,82.87'}
G[111918]={'1033:37.78,47.63'}
G[111930]={'1017:38.73,30.59'}
G[111939]={'1015:43.62,89.80'}
G[111949]={'1033:16.35,25.35'}
G[111952]={'1033:16.34,25.33'}
G[111981]={'1018:59.76,32.92'}
G[112016]={'1033:56.02,64.95'}
G[112021]={'1018:61.02,35.76'}
G[112052]={'1018:63.31,39.52'}
G[112067]={'1033:22.44,15.41'}
G[112130]={'1014[12]:26.76,35.01 N:78558'}
G[112140]={'1033:35.40,28.94'}
G[112146]={'1033:36.52,46.79'}
G[112154]={'1017:38.54,55.16'}
G[112211]={'1017:38.80,55.23'}
G[112217]={'1017:38.64,55.44'}
G[112289]={'1018:54.07,73.48'}
G[112323]={'1077:40.08,24.78'}
G[112334]={'1033:26.18,20.72'}
G[112342]={'1015:52.55,80.47'}
G[112350]={'1015:52.58,80.85'}
G[112370]={'1033:54.36,49.10'}
G[112407]={'1052[1]:59.16,54.30'}
G[112441]={'1014[10]:25.33,45.09'}
G[112444]={'1033:26.21,20.66'}
G[112481]={'1017:64.80,58.79'}
G[112497]={'1033:24.88,34.59'}
G[112512]={'181:25.44,75.88'}
G[112530]={'1033:61.89,60.90'}
G[112531]={'1033:57.83,61.98'}
G[112544]={'1048:31.19,36.61'}
G[112546]={'1048:34.63,62.08'}
G[112548]={'1048:30.76,50.86'}
G[112549]={'1048:40.93,58.96'}
G[112570]={'161:51.89,28.54'}
G[112620]={'1017:38.13,54.96'}
G[112624]={'1017:38.44,55.28'}
G[112653]={'1033:61.30,56.06'}
G[112666]={'Near1014 N:108326'}
G[112696]={'1014[10]:60.92,44.73'}
G[112727]={'1015:69.47,30.41'}
G[112756]={'1033:29.17,89.03'}
G[112757]={'1033:50.13,79.15'}
G[112758]={'1033:57.48,67.15'}
G[112759]={'1033:81.37,62.35'}
G[112796]={'1033:65.51,55.45'}
G[112802]={'1033:13.43,53.49'}
G[112856]={'1018:73.79,54.42'}
G[112861]={'1018:43.07,88.25'}
G[112866]={'1015:56.43,59.35'}
G[112905]={'1033:61.94,44.31'}
G[112910]={'1033:38.70,33.33'}
G[112948]={'1033:46.42,46.53'}
G[112953]={'1052[1]:58.66,43.11'}
G[112967]={'1033[32]:42.28,14.99'}
G[112972]={'1033:64.90,49.73'}
G[113102]={'1033[32]:44.69,26.96'}
G[113125]={'1033:41.25,40.43'}
G[113126]={'1033:35.16,43.22'}
G[113127]={'1033:26.66,68.92'}
G[113137]={'1015:53.24,35.44'}
G[113162]={'1033:17.87,49.09'}
G[113185]={'1033:32.87,47.24'}
G[113190]={'1033:34.42,44.18'}
G[113195]={'1033:26.23,41.18'}
G[113205]={'1033:61.60,51.45'}
G[113284]={'1033:37.87,47.46'}
G[113355]={'1099:43.76,50.34'}
G[113361]={'1099:38.73,53.09'}
G[113417]={'1033:54.61,44.42'}
G[113420]={'1033:54.72,45.83'}
G[113457]={'1033:50.32,79.39'}
G[113515]={'1033:37.39,45.79'}
G[113525]={'1077:52.30,52.79'}
G[113547]={'4:55.65,11.04'}
G[113567]={'1033:35.10,58.89'}
G[113571]={'1033:58.95,38.14'}
G[113572]={'1033:50.03,39.19'}
G[113573]={'1033:45.96,40.47'}
G[113597]={'1033:48.50,63.57'}
G[113618]={'1033:45.42,70.46'}
G[113619]={'1033:44.77,67.20'}
G[113637]={'32[21]:29.78,48.84 N:78558'}
G[113646]={'1018:62.61,34.41'}
G[113655]={'32[21]:30.86,49.03 N:28070'}
G[113679]={'1033:46.29,69.37'}
G[113686]={'Near1077'}
G[113706]={'1033:39.35,60.88'}
G[113738]={'1033:45.64,70.94'}
G[113765]={'1033:44.44,75.78'}
G[113801]={'1015:54.84,52.16'}
G[113813]={'1014[10]:66.30,68.11'}
G[113836]={'32[21]:30.16,51.16 N:67996'}
G[113857]={'1052[1]:58.49,43.97'}
G[113911]={'1017:33.33,31.42'}
G[113986]={'32[21]:50.06,48.39 N:78558'}
G[113987]={'1015:31.28,43.89'}
G[114255]={'1015:37.72,17.11'}
G[114263]={'1114[2]:0.00,0.00'}
G[114282]={'1014[10]:61.36,46.27'}
G[114299]={'1033:33.00,18.57'}
G[114300]={'1033:36.76,19.23'}
G[114303]={'1033:36.54,20.68'}
G[114305]={'1033:31.88,20.27'}
G[114310]={'32:47.01,75.30'}
G[114318]={'1115[3]:0.00,0.00'}
G[114442]={'1018:44.28,52.31'}
G[114468]={'1033:47.46,70.50'}
G[114470]={'1033:50.01,77.05'}
G[114472]={'1033:48.60,77.75'}
G[114474]={'1033:48.10,72.08'}
G[114480]={'1033:50.65,79.90'}
G[114488]={'948:48.01,44.72'}
G[114489]={'946:43.46,71.81'}
G[114490]={'950:80.54,47.70'}
G[114491]={'949:43.92,93.78'}
G[114492]={'1015:48.26,29.68'}
G[114493]={'1018:44.88,57.93'}
G[114494]={'1024:55.52,84.45'}
G[114496]={'1017:32.50,42.16'}
G[114499]={'941:72.59,65.09'}
G[114500]={'947:42.63,35.99'}
G[114518]={'1033:30.47,45.39'}
G[114519]={'1033:23.03,58.35'}
G[114550]={'971:29.23,34.25'}
G[114561]={'382:69.01,43.96'}
G[114562]={'1077:31.22,53.75'}
G[114631]={'32:46.94,75.38'}
G[114676]={'1018:47.21,50.32'}
G[114719]={'1014[10]:42.32,27.03'}
G[114790]={'1115[14]:0.00,0.00'}
G[114793]={'1033:20.94,40.83'}
G[114838]={'1033:41.65,51.50'}
G[114841]={'1033:40.6,53'}
G[114868]={'1033:48.22,83.42'}
G[114876]={'1033:47.61,81.26'}
G[114883]={'1033:40.4,53.2'}
G[114908]={'1033:41.60,51.66'}
G[114909]={'1033:41.66,51.64'}
G[114946]={'1014[10]:73.86,41.70'}
G[114948]={'1033:47.83,82.92'}
G[114956]={'1033:52.08,79.19'}
G[114963]={'1033:41.70,51.55'}
G[115002]={'1033:25.80,88.53'}
G[115008]={'1018:48.36,40.75'}
G[115015]={'1018:56.19,78.34'}
G[115018]={'1033:49.69,85.38'}
G[115021]={'1018:55.25,77.32'}
G[115039]={'1033:52.24,68.72'}
G[115054]={'1021:45.32,65.97'}
G[115056]={'1021:47.64,70.83'}
G[115067]={'1033:24.86,88.69'}
G[115119]={'1018:55.59,79.07'}
G[115132]={'1024:37.99,15.77'}
G[115164]={'32:40.48,76.05'}
G[115216]={'1033:49.41,72.97'}
G[115247]={'1033:43.29,78.76'}
G[115248]={'1033:43.33,78.81'}
G[115249]={'1033:49.39,72.51'}
G[115264]={'1014[10]:44.75,31.93'}
G[115273]={'1033:41.08,69.62'}
G[115286]={'11:63.6,35.8'}
G[115291]={'1017:54.06,45.67'}
G[115338]={'1033:50.81,80.47'}
G[115342]={'1033:39.90,51.39'}
G[115367]={'1033:44.18,60.12'}
G[115371]={'1033:37.07,46.59'}
G[115372]={'1033:36.64,44.98'}
G[115376]={'1033:24.75,88.88'}
G[115389]={'1018:66.88,69.14'}
G[115462]={'1015:51.07,36.68'}
G[115465]={'1014[10]:22.22,39.06'}
G[115466]={'1014[10]:22.48,40.51'}
G[115468]={'1014[10]:23.8,39.4'}
G[115469]={'1033:53.93,39.81'}
G[115497]={'1115[14]:41.68,80.16'}
G[115499]={'1033:39.93,50.95'}
G[115506]={'1033:54.98,72.77'}
G[115517]={'1033:46.45,58.18'}
G[115521]={'1033:40.63,64.49'}
G[115524]={'1033:44.02,59.73'}
G[115529]={'1033:55.61,73.65'}
G[115557]={'1033:52.23,79.05'}
G[115561]={'1033:31.63,53.20'}
G[115562]={'1033:31.99,54.44'}
G[115566]={'1033:31.25,54.52'}
G[115594]={'1033:42.09,60.44'}
G[115601]={'1021:44.32,62.81'}
G[115604]={'1033:48.89,67.10'}
G[115620]={'1021:44.31,62.76'}
G[115648]={'1021:42.27,66.06'}
G[115656]={'1018:40.42,49.27'}
G[115663]={'1017:78.55,77.01'}
G[115664]={'1018:48.13,9.48'}
G[115665]={'1024:33.22,26.02'}
G[115666]={'1015:36.99,6.49'}
G[115667]={'1017:77.92,72.10'}
G[115668]={'1018:49.47,7.74'}
G[115669]={'1024:33.59,25.06'}
G[115671]={'1017:78.16,77.56'}
G[115672]={'1018:47.98,9.32'}
G[115673]={'1024:34.99,21.83'}
G[115674]={'1015:35.49,5.70'}
G[115675]={'1015:38.42,6.03'}
G[115676]={'1018:47.98,9.57'}
G[115677]={'1024:33.05,25.32'}
G[115678]={'1017:78.22,76.29'}
G[115679]={'1024:36.53,20.22'}
G[115680]={'1017:76.75,82.90'}
G[115682]={'1018:52.75,9.61'}
G[115690]={'1033:61.20,48.35'}
G[115691]={'1033:66.68,57.42'}
G[115693]={'1015:59.81,14.05'}
G[115696]={'1033:45.71,70.69'}
G[115697]={'1033:45.98,79.87'}
G[115701]={'1015:59.81,13.99'}
G[115703]={'1033:50.80,77.89'}
G[115710]={'1033:36.62,45.09'}
G[115724]={'1033:65.26,55.28'}
G[115730]={'1115[14]:0.00,0.00'}
G[115736]={'1033:36.50,46.72'}
G[115738]={'1033:65.58,54.63'}
G[115749]={'606:44.32,47.97'}
G[115750]={'241:68.12,55.28'}
G[115755]={'1033:64.83,54.85'}
G[115802]={'606:40.94,42.57'}
G[115806]={'1033:47.87,81.19'}
G[115846]={'1017:73.85,86.38'}
G[115866]={'1021:79.50,42.23'}
G[115874]={'1021:81.47,49.92'}
G[115876]={'1021:81.42,49.91'}
G[115880]={'1033:41.35,18.24'}
G[115891]={'1018:49.62,41.85'}
G[115906]={'1017:38.15,56.71'}
G[115924]={'1033:40.79,52.71'}
G[115969]={'1015:60.00,21.53'}
G[115987]={'1033:28.05,61.95'}
G[116007]={'1033:56.56,45.41'}
G[116010]={'1033:35.82,47.10'}
G[116025]={'1015:62.55,25.45'}
G[116026]={'1015:61.37,22.52'}
G[116038]={'1017:60.02,20.03'}
G[116039]={'1017:61.42,20.31'}
G[116042]={'1033:56.65,43.53'}
G[116050]={'1033:45.58,52.28'}
G[116060]={'1033:55.30,39.95'}
G[116068]={'1033:57.38,49.50'}
G[116084]={'1033:35.78,78.93'}
G[116118]={'1033:42.95,78.81'}
G[116119]={'1033:65.81,54.54'}
G[116121]={'1021:34.31,58.09'}
G[116159]={'1088[8]:0.00,0.00'}
G[116175]={'1014[10]:49.37,39.78'}
G[116180]={'1017:72.95,88.99'}
G[116189]={'1015:25.67,57.76'}
G[116206]={'1033:40.54,64.68'}
G[116218]={'1033:60.56,48.20'}
G[116219]={'1015:37.56,34.92'}
G[116223]={'1033:60.59,48.17'}
G[116225]={'1033:58.57,42.57'}
G[116256]={'1033:39.78,51.28'}
G[116297]={'1015:35.19,33.44'}
G[116302]={'1021:44.74,63.28'}
G[116308]={'Near1014'}
G[116360]={'1033:51.68,63.08'}
G[116362]={'1014[11]:37.86,52.47'}
G[116393]={'1021:59.56,27.26'}
G[116396]={'1014[10]:40.44,24.56'}
G[116424]={'1015:66.70,48.36'}
G[116427]={'1021:54.65,16.25'}
G[116428]={'1015:64.89,48.47'}
G[116433]={'1015:66.57,44.96'}
G[116436]={'1015:67.09,51.43'}
G[116466]={'1021:56.52,13.83'}
G[116469]={'1021:52.80,18.83'}
G[116470]={'1021:56.58,13.81'}
G[116472]={'1021:50.01,16.43'}
G[116479]={'1021:55.85,18.77'}
G[116489]={'1033:83.59,61.64'}
G[116518]={'1021:39.35,42.13'}
G[116521]={'1015:63.07,20.04'}
G[116523]={'1021:37.64,46.52'}
G[116529]={'1033:62.65,52.91'}
G[116554]={'1033:60.57,52.03'}
G[116555]={'1033:60.13,52.06'}
G[116576]={'1021:44.54,63.52'}
G[116580]={'1017:47.50,17.58'}
G[116601]={'1017:73.28,86.82'}
G[116675]={'1033:22.92,27.48'}
G[116714]={'1014[12]:52.73,59.37'}
G[116736]={'1088[7]:0.00,0.00'}
G[116760]={'1114[3]:40.57,26.24'}
G[116868]={'1017:90.03,11.15'}
G[116880]={'1014[10]:52.05,19.58'}
G[116929]={'1044:51.58,48.72'}
G[116951]={'1021:52.74,46.39'}
G[116953]={'1021:61.21,52.87'}
G[116955]={'1015:59.53,36.18'}
G[116961]={'1021:50.82,51.26'}
G[116981]={'1017:79.43,58.43'}
G[117018]={'1017:80.94,61.80'}
G[117035]={'1024:40.73,12.65'}
G[117036]={'1015:42.78,41.38'}
G[117038]={'1017:37.86,42.37'}
G[117039]={'1018:55.73,68.57'}
G[117040]={'1024:55.45,45.86'}
G[117042]={'1014[10]:74.71,45.55'}
G[117049]={'1018:57.45,87.54'}
G[117053]={'1024:51.09,50.11'}
G[117056]={'1015:48.91,44.15'}
G[117060]={'1017:56.48,47.75'}
G[117061]={'1015:43.60,32.73'}
G[117066]={'1024:35.14,70.28'}
G[117068]={'1015:51.97,11.67'}
G[117069]={'1018:47.39,55.39'}
G[117080]={'1017:60.12,28.43'}
G[117086]={'1021:52.33,44.61'}
G[117088]={'1021:49.89,57.39'}
G[117089]={'1021:61.98,38.53'}
G[117091]={'1021:40.63,44.74'}
G[117093]={'1021:58.25,47.50'}
G[117094]={'1021:42.55,42.84'}
G[117095]={'1021:57.48,30.78'}
G[117096]={'1021:56.84,56.35'}
G[117101]={'1021:49.34,56.29'}
G[117103]={'1021:89.65,30.96'}
G[117136]={'1021:49.79,37.14'}
G[117140]={'1021:65.59,31.80'}
G[117141]={'1021:59.56,27.39'}
G[117155]={'1033:31.72,52.92'}
G[117165]={'1021:47.77,55.52'}
G[117168]={'1021:49.26,55.64'}
G[117225]={'1024:35.68,24.04'}
G[117239]={'1021:59.90,29.00'}
G[117249]={'1024:31.37,25.12'}
G[117250]={'1080:27.62,24.31'}
G[117291]={'1021:71.97,40.69'}
G[117292]={'1024:29.13,30.12'}
G[117303]={'1021:58.83,26.50'}
G[117304]={'1021:50.86,55.67'}
G[117305]={'1021:53.61,53.38'}
G[117306]={'1021:50.27,55.64'}
G[117325]={'1021:41.80,16.57'}
G[117334]={'1080:25.56,46.70'}
G[117339]={'1080:29.24,24.67'}
G[117350]={'1021:39.76,35.13'}
G[117351]={'1021:39.85,34.20'}
G[117352]={'1021:37.87,22.34'}
G[117353]={'1024:29.33,28.75'}
G[117354]={'1021:37.71,30.33'}
G[117361]={'1024:31.34,25.13'}
G[117412]={'1033:61.36,43.07'}
G[117413]={'1021:74.25,28.50'}
G[117425]={'1021:38.75,26.10'}
G[117430]={'1021:72.20,39.83'}
G[117432]={'261:33.91,81.82'}
G[117433]={'261:33.94,81.91'}
G[117434]={'261:34.01,80.48'}
G[117435]={'261:34.06,80.43'}
G[117470]={'1021:89.75,33.04'}
G[117486]={'1018:49.43,41.85'}
G[117487]={'1021:88.90,31.83'}
G[117489]={'261:32.57,52.12'}
G[117490]={'261:55.76,72.44'}
G[117491]={'261:46.73,22.32'}
G[117492]={'1021:77.05,28.79'}
G[117504]={'1044:51.57,48.60'}
G[117509]={'1021:37.71,33.26'}
G[117555]={'1021:59.16,45.08'}
G[117567]={'1021:56.89,45.07'}
G[117593]={'1021:78.31,39.97'}
G[117597]={'1021:58.12,47.29'}
G[117611]={'1021:83.95,51.09'}
G[117673]={'1017:63.41,24.87'}
G[117718]={'1021:77.16,39.95'}
G[117719]={'1021:78.10,43.03'}
G[117735]={'1015:56.55,62.46'}
G[117774]={'1015:55.09,67.40'}
G[117780]={'1015:51.39,36.78'}
G[117792]={'1015:60.66,23.75'}
G[117793]={'1021:53.29,50.51'}
G[117871]={'1021:45.69,62.06'}
G[117873]={'1021:44.77,63.18'}
G[117949]={'1021:80.69,46.12'}
G[117950]={'1021:46.41,20.67'}
G[117953]={'1021:77.87,40.59'}
G[117954]={'1021:79.90,43.50'}
G[117955]={'1021:78.47,39.24'}
G[117956]={'1021:78.02,39.43'}
G[117959]={'1017:53.33,86.19'}
G[117962]={'1024:25.60,44.71'}
G[117967]={'1024:55.40,64.88'}
G[117969]={'1017:51.81,33.38'}
G[117970]={'1015:34.29,28.08'}
G[117971]={'1024:35.49,63.47'}
G[117991]={'1018:36.01,53.96'}
G[117993]={'1024:58.21,64.02'}
G[117997]={'1015:55.18,29.73'}
G[118000]={'1015:42.47,11.19'}
G[118006]={'1017:76.13,57.46'}
G[118012]={'1015:62.42,47.23'}
G[118016]={'1018:50.64,73.64'}
G[118017]={'1018:43.64,81.51'}
G[118050]={'1024:34.67,32.18'}
G[118051]={'1024:34.67,32.18'}
G[118057]={'1021:54.48,79.98'}
G[118062]={'1021:58.27,51.86'}
G[118077]={'1018:49.65,77.09'}
G[118105]={'1021:43.82,62.98'}
G[118134]={'1021:57.70,59.46'}
G[118162]={'1021:33.63,33.20'}
G[118177]={'1022:49.72,45.01'}
G[118180]={'1018:0.00,0.00'}
G[118183]={'1018:39.10,51.63'}
G[118184]={'1021:54.59,79.74'}
G[118223]={'1021:56.45,76.47'}
G[118250]={'1018:44.08,50.64'}
G[118255]={'1021:44.12,75.80'}
G[118266]={'1021:41.01,77.50'}
G[118280]={'1017:37.51,38.68'}
G[118281]={'1021:53.85,50.56'}
G[118322]={'1021:42.65,17.28'}
G[118323]={'1021:54.55,45.98'}
G[118336]={'1021:53.78,14.19'}
G[118342]={'1021:67.53,29.23'}
G[118390]={'1021:56.94,56.65'}
G[118410]={'1017:37.45,38.56'}
G[118422]={'1021:64.31,30.55'}
G[118431]={'1077:46.40,48.70'}
G[118440]={'1018:54.97,73.39'}
G[118441]={'1021:48.85,54.84'}
G[118454]={'1021:49.80,43.25'}
G[118455]={'1021:52.69,46.93'}
G[118459]={'1021:49.80,43.25'}
G[118472]={'1021:49.03,39.08'}
G[118499]={'1021:67.11,29.43'}
G[118657]={'1021:52.84,39.90'}
G[118660]={'1021:49.92,43.66'}
G[118676]={'1021:54.97,32.09'}
G[118680]={'1021:77.87,29.67'}
G[118683]={'1021:75.71,21.59'}
G[118752]={'1018:42.24,58.96'}
G[118753]={'1015:63.65,18.32'}
G[118776]={'1021:59.01,29.59'}
G[118778]={'1017:81.68,7.17'}
G[118781]={'1017:71.99,71.84'}
G[118782]={'1015:63.04,19.38'}
G[118783]={'1015:63.99,18.36'}
G[118786]={'1021:34.62,56.20'}
G[118787]={'1021:59.00,29.25'}
G[118788]={'1021:32.64,57.42'}
G[118819]={'1021:61.46,24.67'}
G[118836]={'1015:44.66,48.96'}
G[118840]={'1017:64.03,60.12'}
G[118841]={'1021:44.84,40.61'}
G[118846]={'1021:44.92,41.73'}
G[118851]={'1021:43.18,37.88'}
G[118942]={'1015:55.97,60.82'}
G[118943]={'1021:42.95,16.32'}
G[118947]={'1018:39.10,58.14'}
G[118954]={'1018:39.09,58.07'}
G[118971]={'1021:38.48,59.66'}
G[118975]={'1015:0.00,0.00'}
G[118980]={'1018:38.94,51.30'}
G[118993]={'1021:39.32,79.83'}
G[119002]={'1015:58.39,21.45'}
G[119015]={'1021:42.06,55.02'}
G[119032]={'1017:45.47,18.58'}
G[119053]={'1021:46.01,45.03'}
G[119104]={'1024:30.35,27.19'}
G[119105]={'1024:31.37,28.87'}
G[119139]={'1021:53.99,51.34'}
G[119143]={'1017:32.21,35.24'}
G[119155]={'1017:32.72,34.18'}
G[119173]={'1021:43.43,46.81'}
G[119184]={'1021:49.19,55.39'}
G[119187]={'1021:43.44,56.00'}
G[119191]={'1024:49.33,45.13'}
G[119203]={'1021:77.65,26.05'}
G[119211]={'1024:54.84,55.92'}
G[119305]={'1021:44.57,62.99'}
G[119338]={'301:85.89,31.96'}
G[119340]={'301:86.52,35.90'}
G[119357]={'301:49.74,45.01'}
G[119388]={'1135:56.56,67.57'}
G[119397]={'1135:51.94,52.79'}
G[119489]={'1024:51.52,61.15'}
G[119490]={'1024:50.35,59.58'}
G[119533]={'1135:58.81,75.28'}
G[119535]={'1135:60.91,79.20'}
G[119543]={'1135:60.83,79.40'}
G[119579]={'1024:44.81,54.27'}
G[119597]={'1135:56.30,75.66'}
G[119602]={'1135:55.05,81.73'}
G[119603]={'1021:44.23,53.58'}
G[119605]={'1021:44.42,48.31'}
G[119634]={'1021:68.02,28.41'}
G[119654]={'1024:45.02,9.27'}
G[119664]={'1044:51.35,48.49'}
G[119673]={'1024:45.80,9.14'}
G[119674]={'1021:77.69,39.93'}
G[119676]={'1024:50.14,64.36'}
G[119677]={'1024:43.99,8.74'}
G[119701]={'1024:43.81,11.66'}
G[119718]={'1021:60.38,45.01'}
G[119723]={'1147[1]:0.00,0.00'}
G[119749]={'1170:40.98,68.62'}
G[119765]={'1044:51.52,48.57'}
G[119767]={'1080:62.40,67.09'}
G[119788]={'1021:54.94,32.89'}
G[119869]={'1014[10]:47.99,40.99'}
G[119884]={'1170:39.13,12.66'}
G[119886]={'1021:39.54,71.67'}
G[119905]={'1017:45.68,59.87'}
G[119908]={'1017:45.46,57.89'}
G[119944]={'1024:44.15,57.38'}
G[119982]={'Near606'}
G[120031]={'1021:39.84,43.18'}
G[120032]={'241:68.18,54.78'}
G[120041]={'Near241'}
G[120068]={'1021:28.57,62.77'}
G[120070]={'1021:43.57,58.32'}
G[120071]={'1015:46.75,11.90'}
G[120074]={'1015:44.32,9.27'}
G[120076]={'1021:45.04,52.07'}
G[120084]={'Near1021'}
G[120085]={'1021:63.62,57.27'}
G[120107]={'1015:47.82,9.56'}
G[120112]={'1021:60.10,50.12'}
G[120118]={'1021:70.75,47.60'}
G[120126]={'1021:72.12,41.49'}
G[120136]={'1018:38.05,62.42'}
G[120144]={'1018:40.94,60.58'}
G[120183]={'1021:44.55,63.15'}
G[120200]={'1018:66.42,70.95'}
G[120206]={'1015:63.58,18.46'}
G[120208]={'1021:56.92,56.66'}
G[120215]={'1014[10]:69.38,43.93'}
G[120216]={'1021:71.63,33.28'}
G[120226]={'1021:31.38,60.71'}
G[120268]={'301:86.10,34.31'}
G[120272]={'1021:44.59,63.14'}
G[120281]={'1021:41.62,59.62'}
G[120288]={'1021:60.47,25.02'}
G[120303]={'1018:68.20,32.78'}
G[120304]={'1018:73.61,54.32'}
G[120310]={'1018:43.25,88.60'}
G[120321]={'1018:71.14,36.45'}
G[120372]={'1021:44.56,63.39'}
G[120392]={'1021:68.85,29.73'}
G[120393]={'1135:58.31,75.72'}
G[120395]={'1135:59.87,75.63'}
G[120414]={'1021:42.13,58.85'}
G[120481]={'1021:77.62,26.00'}
G[120529]={'1135:56.65,67.43'}
G[120533]={'1170[3]:46.88,23.20'}
G[120570]={'1021:67.61,48.19'}
G[120601]={'1135:54.63,56.70'}
G[120603]={'1170:53.48,69.53'}
G[120604]={'1170:52.26,69.65'}
G[120631]={'1021:83.20,29.44'}
G[120636]={'1021:47.96,71.59'}
G[120637]={'1135:57.45,56.07'}
G[120664]={'1015:42.81,24.82'}
G[120692]={'1015:49.14,44.02'}
G[120723]={'1135:51.41,56.78'}
G[120725]={'1021:54.86,76.51'}
G[120738]={'1135:51.56,52.81'}
G[120745]={'1021:32.85,57.10'}
G[120749]={'1021:30.85,60.95'}
G[120760]={'1135:59.95,66.37'}
G[120763]={'1135:60.84,47.25'}
G[120800]={'1021:40.08,60.28'}
G[120816]={'1021:39.46,60.96'}
G[120820]={'1021:38.51,59.96'}
G[120837]={'1021:30.85,60.95'}
G[120844]={'1135[1]:42.65,27.23'}
G[120896]={'1021:65.51,32.25'}
G[120898]={'1021:44.39,62.25'}
G[120932]={'1021:54.63,64.74'}
G[120933]={'1021:55.15,67.13'}
G[120934]={'1021:52.72,72.60'}
G[120935]={'1021:82.44,27.56'}
G[120938]={'1021:82.47,28.03'}
G[120945]={'1021:82.89,31.01'}
G[120947]={'1077:29.95,4.24'}
G[120952]={'1021:80.41,28.61'}
G[120953]={'1135:50.41,53.83'}
G[120962]={'1021:83.34,29.25'}
G[120966]={'1021:67.74,43.34'}
G[120977]={'1174[2]:33.78,65.53'}
G[120998]={'1021:39.79,60.61'}
G[121016]={'1021:54.04,79.34'}
G[121029]={'1021:39.54,32.96'}
G[121031]={'1021:66.93,42.18'}
G[121034]={'1021:70.11,47.49'}
G[121035]={'1021:67.16,42.97'}
G[121037]={'1021:77.62,23.76'}
G[121046]={'1021:78.45,39.49'}
G[121058]={'1021:65.98,45.19'}
G[121081]={'1021:43.50,64.08'}
G[121107]={'1021:42.65,17.46'}
G[121124]={'1021:59.95,62.34'}
G[121134]={'1021:78.05,27.42'}
G[121137]={'1021:41.15,64.44'}
G[121151]={'1024:30.04,30.34'}
G[121176]={'1021:53.21,49.91'}
G[121224]={'1021:41.44,59.34'}
G[121226]={'1021:52.62,48.43'}
G[121230]={'1170:52.59,90.77'}
G[121237]={'1021:58.20,26.52'}
G[121251]={'1170:46.11,64.82'}
G[121260]={'1135:40.64,70.06'}
G[121263]={'1135[1]:43.44,23.30'}	-- in Vindicaar over Krokuun
G[121345]={'1135:59.91,69.14'}
G[121517]={'1135:31.47,63.79'}
G[121518]={'1170:43.47,67.71'}
G[121519]={'1135:40.52,63.63'}
G[121520]={'1135:40.64,64.33'}
G[121521]={'1135:39.92,63.12'}
G[121531]={'1135:40.61,63.22'}
G[121546]={'1170:35.78,58.49'}
G[121548]={'1135:41.52,69.58'}
G[121563]={'1170:40.84,57.75'}
G[121578]={'1135:31.82,71.84'}
G[121589]={'1021:44.45,62.22'}
G[121597]={'1170:31.93,37.43'}
G[121670]={'1170:26.09,38.45'}
G[121671]={'1170:24.62,41.30'}
G[121754]={'301:21.37,30.46'}
G[121756]={'1174[1]:20.64,53.26'}
G[122014]={'1170:35.15,36.28'}
G[122065]={'4:58.29,12.15'}
G[122353]={'1170:56.01,63.79'}
G[122378]={'1135[1]:42.09,25.71'}
G[122403]={''}
G[122510]={'1177[1]:59.98,54.50'}
G[122528]={'1177[1]:31.48,30.93'}
G[122551]={'1177[1]:55.44,64.23'}
G[122552]={'1177[1]:54.81,67.68'}
G[122553]={'1177[1]:56.74,65.99'}
G[122621]={'1135:40.37,63.36'}
G[122663]={'1177[1]:59.76,53.57'}
G[122799]={'-1:0.00,0.00'}
G[122800]={'-1:0.00,0.00'}
G[122815]={'1135:68.90,60.92'}
G[122835]={'1135:69.54,56.48'}
G[122838]={'1170:45.75,71.11'}
G[122871]={'1177[2]:0.00,0.00'}
G[122874]={'1177[1]:47.62,48.86'}
G[122875]={'1177[1]:63.92,72.39'}
G[122911]={'1135:38.50,59.61'}
G[122912]={'1135:33.19,75.42'}
G[122924]={'1135:59.83,77.98'}
G[122926]={'1014[10]:26.13,45.02'}
G[122958]={'1171:61.83,36.95'}
G[122974]={'1135:56.40,59.05'}
G[122999]={'1171:55.81,45.84'}
G[123109]={'1135:31.83,71.83'}
G[123110]={'1135:38.23,67.56'}
G[123130]={'1135:69.82,66.27'}
G[123148]={'1135:54.31,75.22'}
G[123149]={'1135:54.23,75.43'}
G[123252]={'481:54.75,38.90'}
G[123395]={'1135[1]:45.39,73.69'}
G[123413]={'1170:59.71,50.50'}
G[123421]={'1135:54.85,81.39'}
G[123422]={'1135:60.28,74.39'}
G[123458]={'1177[1]:63.07,75.57'}
G[123464]={'1135:52.81,30.97'}
G[123467]={'1135:43.67,74.54'}
G[123508]={'1170:65.27,56.84'}
G[123659]={'1135:64.65,25.09'}
G[123667]={'1170:43.37,67.60'}
G[123668]={'1170:62.69,39.28 1135[1]:51.42,74.70 1171[5]:64.09,53.43 1170[3]:50.23,69.50'}	-- in Vindicaar, above Krokuun, Antoran Wastes and Mac'Aree
G[123689]={'1135:54.67,81.26'}
G[123781]={'1177[6]:56.32,68.40'}
G[123790]={'1177[6]:47.31,70.43'}
G[124070]={'1170:59.99,50.50'}
G[124303]={'1135:71.23,33.12'}
G[124312]={'1170[3]:45.88,24.03'}	-- in Vindicaar above Mac'Aree
G[124348]={'1135:56.34,67.46'}
G[124398]={'1170:41.10,71.07'}
G[124430]={'1170:60.56,38.78'}
G[124432]={'1170:56.05,29.93'}
G[124440]={'1170:58.74,37.60'}
G[124444]={'1170:57.70,32.32'}
G[124448]={'1170:54.30,29.48'}
G[124595]={'1135:56.75,67.49'}
G[124670]={'1135:46.75,77.02'}
G[124775]={'1135:44.44,58.64'}
G[124804]={'1135:69.56,56.45'}
G[124906]={'1135:31.68,58.21'}
G[124972]={'1135:60.62,43.99'}
G[124974]={'1135:61.04,47.77'}
G[124975]={'1135:60.69,47.29'}
G[124988]={'1135:55.21,20.93'}
G[125109]={'1135:57.19,33.88'}
G[125110]={'1135:53.00,31.07'}
G[125129]={'1135:59.48,42.52'}
G[125137]={'1193:68.73,57.34'}
G[125246]={'1135:56.90,68.65'}
G[125247]={'1135:56.16,70.14'}
G[125280]={'1195:49.10,45.50'}
G[125314]={'1191:45.20,46.55'}
G[125346]={'1135:56.12,66.76'}
G[125388]={'1135:60.91,19.80'}
G[125443]={'1135:61.56,46.72'}
G[125479]={'1135:70.04,81.23'}
G[125483]={'1193:69.31,42.00'}
G[125497]={'1170:57.67,25.88'}
G[125498]={'1170:60.81,29.59'}
G[125525]={'1170[4]:41.99,68.31'}	-- in Vindicaar above Mac'Aree
G[125527]={'1192:65.39,66.31'}
G[125532]={'1170:49.91,43.28'}
G[125587]={'1190:21.87,52.60'}
G[125634]={'1191:47.20,42.46'}
G[125655]={'1190:17.25,52.19'}
G[125666]={'1194:61.05,40.61'}
G[125757]={'1194:66.64,43.23'}
G[125820]={'1135:42.12,70.27'}
G[125824]={'1135[7]:40.33,42.66 1135:50.36,17.39'}
G[125842]={'1170:59.93,32.35'}
G[125926]={'1170:54.57,30.30'}
G[125967]={'1193:58.00,58.25'}
G[126040]={'1171:65.07,21.28'}
G[126111]={'1171:65.96,51.93'}
G[126115]={'1171:62.99,57.35'}
G[126160]={'1135:64.44,62.61'}
G[126165]={'1171:72.02,67.38'}
G[126167]={'1171:70.70,70.13'}
G[126174]={'1171:52.92,34.97'}
G[126196]={'1171:72.53,67.56'}
G[126197]={'1171:64.52,51.06'}
G[126199]={'1171:52.96,35.84'}
G[126208]={'1171:64.83,50.82'}
G[126231]={'1193:60.86,57.31'}
G[126233]={'1171:75.81,64.64'}
G[126239]={'1135:58.76,78.35'}
G[126254]={'1171:62.08,53.27'}
G[126301]={'301:52.08,13.43'}
G[126307]={'1135[1]:40.18,23.46'}	-- in Vindicaar above Krokuun
G[126319]={'301:52.12,13.69'}
G[126321]={'301:52.23,13.50'}
G[126338]={'1171:61.34,65.14'}
G[126389]={'1170[4]:57.23,68.30 1171[6]:63.05,42.82 1135[2]:59.09,70.86'}	-- in Vindicaar above Mac'Aree, Antoran Wastes and Krokuun
G[126408]={'1135[1]:40.06,19.20'}	-- in Vindicaar above Krokuun
G[126419]={'1135:71.07,32.77'}
G[126457]={'1171:60.77,44.40'}
G[126765]={'1135:33.52,71.48'}
G[126815]={'1170:52.92,66.80'}
G[126852]={'1170:55.55,60.50'}
G[126860]={'1170:37.83,54.66'}
G[126864]={'1170:41.53,11.51'}
G[126865]={'1170:36.66,24.06'}
G[126866]={'1170:63.77,64.37'}
G[126868]={'1170:38.45,64.33'}
G[126869]={'1170:27.14,30.10'}
G[126885]={'1170:35.15,37.44'}
G[126887]={'1170:30.30,40.68'}
G[126889]={'1170:70.30,45.95'}
G[126898]={'1170:43.65,49.56'}
G[126899]={'1170:48.09,40.54'}
G[126900]={'1170:61.33,50.18'}
G[126910]={'1170:56.71,15.07'}
G[126912]={'1170:49.82,9.65'}
G[126942]={'1171:55.78,29.85'}
G[126944]={'1171:56.77,35.34'}
G[126946]={'1171:60.62,48.36'}
G[126950]={'1171[5]:26.92,65.69'}
G[126954]={'1171[5]:33.36,64.80'}
G[126995]={'1170:54.47,10.29'}
G[126996]={'1170:51.96,12.14'}
G[126997]={'1170:55.30,13.00'}
G[126998]={'1170:55.30,13.00'}
G[127033]={'1171:72.39,74.84'}
G[127037]={'1170:43.98,60.91'}
G[127051]={'1171:68.78,26.09'}
G[127057]={'1171[6]:30.31,59.44'}
G[127083]={'1170:46.78,55.51'}
G[127084]={'1171:82.72,65.58'}
G[127096]={'1171:75.84,56.31'}
G[127097]={'1171:57.65,15.61'}
G[127103]={'1171:57.71,15.24'}
G[127114]={'1171:51.11,54.45'}
G[127118]={'1171:50.90,55.50'}
G[127120]={'1171[5]:62.58,63.96 1170[3]:43.36,67.09 1135[1]:43.24,74.41'}	-- in Vindicaar above Antoran Wastes, Mac'Aree and Krokuun
G[127151]={'1170[3]:66.74,58.92'}	-- in Vindicaar above Mac'Aree
G[127162]={'1171:54.24,25.53'}
G[127178]={'1171:72.00,50.35'}
G[127188]={'1171:67.32,39.21'}
G[127189]={'1171:66.89,33.13'}
G[127288]={'1171:63.71,22.96'}
G[127291]={'1171:52.86,28.84'}
G[127300]={'1171:55.80,21.90'}
G[127374]={'1171:61.21,21.22'}
G[127376]={'1171:61.40,20.87'}
G[127476]={'1135[2]:69.61,54.39 1171[6]:55.25,26.52 1170[4]:68.15,57.20'}	-- in Vindicaar above Krokuun, Antoran Wastes and Mac'Aree
G[127581]={'1171:55.02,38.93'}
G[127596]={'1171:64.68,69.28'}
G[127671]={'1171:72.25,67.51'}
G[127722]={'1171:52.58,39.03'}
G[127751]={'1135:62.50,46.98'}
G[127811]={'1171:57.66,15.36'}
G[127942]={'1135:31.16,58.58'}
G[128319]={'1170:35.64,23.77'}
G[128357]={'1170:55.40,65.85'}
G[128359]={'1170:66.31,53.06'}
G[128366]={'1171:52.57,26.57'}
G[128367]={'1171:54.41,27.32'}
G[128370]={'1171:73.60,49.05'}
G[128722]={'1170[3]:53.32,50.02'}	-- in Vindacaar above Mac'Aree
G[128725]={'1170[3]:46.94,23.16'}	-- in Vindicaar above Mac'Aree
G[128735]={'1170[3]:57.14,60.52 1170:52.49,90.87'}	-- in Vindicaar above Mac'Aree
G[128949]={'1188[10]:0.00,0.00'}
G[129674]={'1135[2]:39.58,65.21 1171[6]:56.67,67.14 1170[4]:41.38,58.29'}	-- in Vindicaar above Krokuun, Antoran Wastes and Mac'Aree
G[130030]={'261:69.36,17.62'}
G[130032]={'261:68.96,19.09'}
G[130216]={'261:42.54,44.19'}
G[130549]={'1212[1]:43.88,27.09'}
G[130810]={'1212[1]:47.14,40.02'}
G[130919]={'463:79.70,19.73'}
G[130993]={'1212[1]:49.26,43.75'}
G[131334]={'301:62.50,29.75'}
G[131345]={'1215:28.53,22.27'}
G[131347]={'301:62.48,29.74'}
G[131963]={'261:69.41,17.65'}
G[132192]={'261:69.44,19.25'}
G[132255]={'301:38.97,62.83'}
G[132606]={'261:69.42,19.00'}
G[133362]={'301:53.06,15.28'}
G[151891]={'807:45.11,33.81 N:63054'}
G[500001]={'615:39.12,78.71 A:40643 N:40643'}
G[500002]={'615:39.08,78.53 A:40642 N:39887'}
G[500003]={'615:49.22,57.01 A:39881 N:39881'}
G[500004]={'615:39.23,78.63 A:39881 N:39881'}
G[500005]={'615:29.55,78.93 A:39881 N:39881'}
G[500006]={'HC 341:33.29,48.01 A:14305 N:14305','Down stairs underground'}
G[500007]={'HC 39:57.52,52.55 A:14305 N:14305'}
G[500008]={'HC 301:48.99,89.74 A:14305 N:14305'}
G[500009]={'HC 488:71.68,39.58 A:33532 N:33532'}
G[500010]={'HC 490:50.70,44.45 A:33532 N:33532'}
G[500011]={'HC 488:59.80,54.23 A:33532 N:33532'}
G[500012]={'HC 493:27.09,58.75 A:33532 N:33532'}
G[500013]={'HC 465:88.33,50.39 A:22818 N:22818'}
G[500014]={'HC 161:59.79,57.40 A:22818 N:22818'}
G[500015]={'Near606 A:39627 N:39627'}
G[500016]={'795:51.54,85.50 A:52477 N:40278'}
G[500017]={'795:66.03,66.08 A:52478 N:39925'}
G[500018]={'795:66.23,66.10 A:52477 N:40278'}
G[500019]={'795:41.90,61.48 A:52478 N:39925'}
G[500020]={'22:39.82,69.73 A:45165 N:45165'}
G[500021]={'17:15.96,33.40 A:46654 N:46654'}
G[500022]={'HW 700:78.87,77.79 A:1208129'}
G[500023]={'HW 39:52.91,53.74 A:1190047 N:500022'}
G[500024]={'301:60.08,75.08 A:1209076'}
G[500025]={'321[1]:54.5,77.8 A:1209095'}
G[500026]={'684:79.66,75.66 A:45312 N:44789'}
G[500027]={'764[1]:27.94,60.56 A:47293 N:44789'}
G[500028]={'764[4]:60.32,40.82 A:47293 N:44789'}
G[500029]={'764[6]:58.84,52.46 A:47293 N:44789'}
G[500030]={'81:45.53,33.71 A:42039 N:42039'}
G[500031]={'816:25.98,62.92 A:57864 N:57864'}
G[500032]={'816:71.61,80.63 A:55624'}
G[500033]={'816:87.86,49.89 A:57864 N:57864'}
G[500034]={'544:53.16,36.55 A:38124 N:36077','In mine'}
G[500035]={'544:54.39,16.93 A:38124 N:36077'}
G[500036]={'544:43.63,25.32 A:38387 N:34668'}
G[500037]={'544:43.85,25.30 A:38120 N:36379'}
G[500038]={'HC 488:72.83,36.41 A:33533 N:33533'}
G[500039]={'HC 490:50.57,45.16 A:33533 N:33533'}
G[500040]={'HC 488:59.80,54.22 A:33533 N:33533'}
G[500041]={'HC 201:47.39,9.20 493:40.25,82.73>201 A:33533 N:33533'}
G[500042]={'HC 9:60.75,23.10 A:14444 N:14444'}
G[500043]={'HC 382:58.05,91.77 A:14444 N:14444'}
G[500044]={'23:53.02,53.20 A:45400 N:45400'}
G[500045]={'23:52.92,53.07 A:45417 N:45417'}
G[500046]={'23:61.61,42.60 A:45400 N:45400'}
G[500047]={'23:61.47,42.69 A:45417 N:45417'}
G[500048]={'23:50.59,20.09 A:45400 N:45400'}
G[500049]={'23:50.44,20.15 A:45729 N:45429'}
G[500050]={'23:50.54,20.17 A:45417 N:45417'}
G[500051]={'23:27.61,21.17 A:45729 N:45429'}
G[500052]={'23:73.71,52.09 A:45417 N:45417'}	-- this is the final resting place and I believe exists once 27526 is turned in
G[500053]={'23:73.62,51.87 A:45400 N:45400'} -- see comments for npc 500052
G[500054]={'808:65.98,22.81 A:53566 N:53566'}
G[500055]={'807:68.85,43.40 A:56133 N:56133'}
G[500056]={'807:55.89,49.43 A:56133 N:56133'}
G[500057]={'807:18.09,55.68 A:56474 N:56474'}
G[500058]={'807:52.68,62.82 A:56138 N:56138'}
G[500059]={'807:55.83,49.35 A:56133 N:56133'}
G[500060]={'807:32.25,68.55 A:56133 N:56133'}
G[500062]={'807:32.24,68.29 A:56474 N:56474'}
G[500063]={'807:32.33,68.47 A:56138 N:56138'}
G[500064]={'807:36.03,68.97 A:56133 N:56133'}
G[500065]={'807:35.99,69.09 A:56474 N:56474'}
G[500066]={'807:36.12,69.05 A:56138 N:56138'}
G[500067]={'807:36.00,69.11 A:56133 N:56133'}
G[500068]={'807:75.27,35.50 N:56133'}
G[500069]={'857:60.42,25.57 A:58113 N:58113'}
G[500070]={'857:66.40,32.53 A:56114 N:56112'}
G[500071]={'809:54.17,83.42 A:63542 N:63542'}
G[500072]={'857:24.70,33.99 A:58745 N:58745'}
G[500073]={'809:53.91,83.56 A:59441 N:55122','Wandering around camp'}
G[500074]={'858:50.18,10.19 A:62779 N:56133'}
G[500075]={'858:56.58,75.92 A:63317 N:63317'}
G[500076]={'809:74.93,88.55 A:60973 N:60973'}
G[500077]={'858:44.42,16.80 A:62779 N:56133','Down in Morrowchamber'}
G[500078]={'858:50.29,12.06 A:62667 N:62667'}
G[500079]={'858:50.22,12.10 A:62666 N:62666'}
G[500080]={'809:35.12,59.66 A:61819 N:60687'}
G[500081]={'806:46.47,96.30 A:54617 N:54617'}
G[500082]={'806:46.20,84.81 A:54617 N:54617'}
G[500083]={'806:30.79,52.27 A:56406 N:55521'}
G[500084]={'811:56.45,43.24 A:58468 N:58468'}
G[500085]={'898[3]:48.98,21.22 A:64563 N:64563'}	-- Baron location for turnin
G[500086]={'898[3]:49.08,20.63 A:64562 N:64563'}	-- Spirit location for turnin
G[500087]={'891:58.59,62.04 A:68025 N:4949'}
G[500088]={'HL 381:45.16,52.25 A:15892 N:15892'}
G[500089]={'807:52.92,51.83 A:58646 N:58646'}
G[500090]={'970:48.54,14.18 A:78554 N:78554'}
G[500091]={'301:73.90,55.87 A:18927 N:18927'}
G[500092]={'301:63.75,31.97 A:18927 N:18927'}
G[500093]={'301:49.73,90.01 A:18927 N:18927'}
G[500094]={'504[1]:46.33,72.69 A:18927 N:18927'}
G[500095]={'504[1]:44.16,58.91 A:18927 N:18927'}
G[500096]={'471:60.94,28.57 A:19171 N:19171'}
G[500097]={'471:68.01,61.73 A:19171 N:19171'}
G[500098]={'464:21.36,54.25 A:19171 N:19171'}
G[500099]={'462:54.18,50.76 A:19169 N:19169'}
G[500100]={'480:62.50,73.92 A:19169 N:19169'}
G[500101]={'480:59.09,60.91 A:19169 N:19169'}
G[500102]={'480:78.14,57.64 A:19169 N:19169'}
G[500103]={'504[1]:62.73,30.31 A:19169 N:19169'}
G[500104]={'504[1]:50.89,22.41 A:19169 N:19169'}
G[500105]={'321[1]:32.32,65.85 A:19177 N:19177'}
G[500106]={'11:67.52,74.16 A:20102 N:20102'}
G[500107]={'161:50.89,30.10 A:20102 N:20102'}
G[500108]={'161:51.52,26.68 A:20102 N:20102'}
G[500109]={'161:52.24,28.58 A:20102 N:20102'}
G[500110]={'161:51.95,29.38 A:20102 N:20102'}
G[500111]={'281:58.74,48.38 A:20102 N:20102'}
G[500112]={'281:59.76,49.70 A:20102 N:20102'}
G[500113]={'281:59.89,50.89 A:20102 N:20102'}
G[500114]={'281:61.04,48.87 A:20102 N:20102'}
G[500115]={'479:32.30,64.80 A:20102 N:20102'}
G[500116]={'479:32.90,66.72 A:20102 N:20102'}
G[500117]={'479:33.85,64.11 A:20102 N:20102'}
G[500118]={'481:28.12,47.06 A:20102 N:20102'}
G[500119]={'481:49.17,31.50 A:20102 N:20102'}
G[500120]={'481:53.00,51.12 A:20102 N:20102'}
G[500121]={'481:55.26,80.52 A:20102 N:20102'}
G[500122]={'481:58.02,46.14 A:20102 N:20102'}
G[500123]={'481:54.92,38.48 A:20102 N:20102'}
G[500124]={'481:58.97,58.09 A:20102 N:20102'}
G[500125]={'481:63.60,39.76 A:20102 N:20102'}
G[500126]={'495:40.77,84.50 A:20102 N:20102'}
G[500127]={'504[2]:33.15,52.45 A:20102 N:20102'}
G[500128]={'673:40.56,68.29 A:20102 N:20102'}
G[500129]={'673:40.51,73.08 A:20102 N:20102'}
G[500130]={'673:41.70,74.21 A:20102 N:20102'}
G[500131]={'941:82.83,76.33 A:77210 N:77210'}
G[500132]={'949:45.86,70.30 A:74594 N:70860'}
G[500133]={'949:46.10,70.20 A:74594 N:70860'}
G[500134]={'947:62.58,26.22 A:80073 N:79537'}
G[500135]={'971:44.28,53.92 A:1230865 N:1230865'}	-- garrison level 2 location
G[500136]={'949:53.00,59.78 A:75136 N:78568'}
G[500137]={'949:53.31,59.89 A:75146 N:79576'}
G[500138]={'971:29.26,33.14 A:77209 N:79243'}	-- garrison level 3 location
G[500139]={'971:51.19,63.58 A:77383 N:77383'}	-- location is top of stairs for plot 20
G[500140]={'971:51.19,63.58 A:78207 N:78207'}	-- location is top of stairs for plot 20
G[500141]={'971:51.19,63.58 A:77365 N:77365'}	-- plot 20
G[500142]={'971:51.19,63.58 A:77831 N:77831'}	-- plot 20
G[500143]={'948:51.57,31.36 A:79519 N:79519'}
G[500144]={'948:60.52,39.01 A:80648 N:80648'}
G[500145]={'948:46.50,46.66 A:81770 N:79519'}
G[500146]={'971:28.76,35.02 A:79953 N:79953'}	-- garrison level 3 location
G[500147]={'971:34.11,32.57 A:1234243 N:1234243'}	-- garrison level 3 position
G[500148]={'971:51.19,63.58 A:77372 N:77372'}	-- plot 20
G[500149]={'971:51.19,63.58 A:77777 N:77777'}	-- plot 20
G[500150]={'970[1]:81.54,44.81 A:78553 N:4949'}
G[500151]={'941:57.43,48.31 A:78466 N:3391'}	-- garrison level 1, barracks position
G[500152]={'941:19.74,44.76 A:70860 N:70860'}
G[500153]={'941:55.48,56.63 A:72274 N:72274'}
G[500154]={'941:42.16,55.51 A:78466 N:3391'}	-- garrison level 2 position
G[500155]={'971:51.19,63.58 A:77354 N:77354'}	-- plot 20
G[500156]={'971:51.19,63.58 A:77781 N:77781'}	-- plot 20
G[500157]={'971:51.19,63.58 A:77356 N:77356'}	-- plot 20
G[500158]={'971:51.19,63.58 A:77775 N:77775'}	-- plot 20
G[500159]={'949:46.19,55.09 A:82610 N:82610'}
G[500160]={'947:65.23,26.18 A:73395 N:78994'}
G[500161]={'947:65.33,25.98 A:80078 N:72413'}
G[500162]={'947:65.39,26.17 A:80079 N:80079'}
G[500163]={'947:65.32,26.38 A:80073 N:79537'}
G[500164]={'946:59.97,16.48 A:1225726 N:1225726'}
G[500165]={'946:55.55,40.97 A:75808 N:74651'}
G[500166]={'976:51.43,57.39 A:88013 N:47269'} -- plot 22
G[500167]={'976:58,27 A:88013 N:47269'} -- plot 25
G[500168]={'976:51.43,57.39 A:88017 N:46338'} -- plot 22
G[500169]={'976:58,27 A:88017 N:46338'} -- plot 25
G[500170]={'976:51.43,57.39 A:88022 N:47869'} -- plot 22
G[500171]={'976:58,27 A:88022 N:47869'} -- plot 25
G[500172]={'976:51.43,57.39 A:88023 N:61021'} -- plot 22
G[500173]={'976:58,27 A:88023 N:61021'} -- plot 25
G[500174]={'976:51.43,57.39 A:88024 N:9177'} -- plot 22
G[500175]={'976:58,27 A:88024 N:9177'} -- plot 25
G[500176]={'976:51.43,57.39 A:88027 N:47366'} -- plot 22
G[500177]={'976:58,27 A:88027 N:47366'} -- plot 25
G[500178]={'976:51.43,57.39 A:88025 N:39930'}	-- plot 22
G[500179]={'976:58,27 A:88025 N:39930'}	-- plot 25
G[500180]={'976:51.43,57.39 A:88026 N:43184'}	-- plot 22
G[500181]={'976:58,27 A:88026 N:43184'}	-- plot 25
G[500182]={'976:51.43,57.39 A:87991 N:87991'}	-- plot 22
G[500183]={'976:58,27 A:87991 N:87991'}	-- plot 25
G[500184]={'976:51.43,57.39 A:87992 N:46854'}	-- plot 22
G[500185]={'976:58,27 A:87992 N:46854'}	-- plot 25
G[500186]={'976:51.43,57.39 A:87997 N:11036'}	-- plot 22
G[500187]={'976:58,27 A:87997 N:11036'}	-- plot 25
G[500188]={'976:51.43,57.39 A:87995 N:2487'}	-- plot 22
G[500189]={'976:58,27 A:87995 N:2487'}	-- plot 25
G[500190]={'976:51.43,57.39 A:87996 N:64842'}	-- plot 22
G[500191]={'976:58,27 A:87996 N:64842'}	-- plot 25
G[500192]={'976:51.43,57.39 A:87994 N:87994'}	-- plot 22
G[500193]={'976:58,27 A:87994 N:87994'}	-- plot 25
G[500194]={'976:51.43,57.39 A:87998 N:58113'}	-- plot 22
G[500195]={'976:58,27 A:87998 N:58113'}	-- plot 25
G[500196]={'976:51.43,57.39 A:87999 N:40997'}	-- plot 22
G[500197]={'976:58,27 A:87999 N:40997'}	-- plot 25
G[500198]={'976:51.43,57.39 A:88007 N:88007'}	-- plot 22
G[500199]={'976:58,27 A:88007 N:88007'}	-- plot 25
G[500200]={'976:51.43,57.39 A:88000 N:49444'}	-- plot 22
G[500201]={'976:58,27 A:88000 N:49444'}	-- plot 25
G[500202]={'976:51.43,57.39 A:88001 N:38237'}	-- plot 22
G[500203]={'976:58,27 A:88001 N:38237'}	-- plot 25
G[500204]={'976:51.43,57.39 A:88002 N:28444'}	-- plot 22
G[500205]={'976:58,27 A:88002 N:28444'}	-- plot 25
G[500206]={'976:51.43,57.39 A:88003 N:88003'}	-- plot 22
G[500207]={'976:58,27 A:88003 N:88003'}	-- plot 25
G[500208]={'976:51.43,57.39 A:88004 N:88004'}	-- plot 22
G[500209]={'976:58,27 A:88004 N:88004'}	-- plot 25
G[500210]={'976:51.43,57.39 A:88005 N:54961'}	-- plot 22
G[500211]={'976:58,27 A:88005 N:54961'}	-- plot 25
G[500212]={'976:51.43,57.39 A:88006 N:88006'}	-- plot 22
G[500213]={'976:58,27 A:88006 N:88006'}	-- plot 25
G[500214]={'976:51.43,57.39 A:88009 N:88009'}	-- plot 22
G[500215]={'976:58,27 A:88009 N:88009'}	-- plot 25
G[500216]={'947:27.52,11.26 A:91242 N:91242'}
G[500217]={'971:51.19,63.58 A:84857 N:84857'}	-- plot 20
G[500218]={'971:51.19,63.58 A:77363 N:77363'}	-- plot 20
G[500219]={'971:51.19,63.58 A:77791 N:77791'}	-- plot 20
G[500220]={'971:31.01,31.07 A:81152 N:81152'}	-- garrison level 3 location
G[500221]={'971:51.19,63.58 A:77359 N:77359'}	-- plot 20
G[500222]={'971:51.19,63.58 A:77792 N:77792'}	-- plot 20
G[500223]={'971:51.19,63.58 A:77382 N:77382'}	-- plot 20
G[500224]={'971:51.19,63.58 A:77778 N:77778'}	-- plot 20
G[500225]={'947:75.07,57.89 A:92213 N:78558'}
G[500226]={'764[7]:48.89,82.50 A:47006 N:47006'}
G[500227]={'764[4]:60.41,41.03 A:47006 N:47006'}
G[500228]={'764[6]:58.69,53.52 A:47006 N:47006'}
G[500229]={'941:37.65,50.29 A:78466 N:3391'}	-- garrison level 3 position
G[500230]={'941:41.46,69.89 A:91242 N:91242'}
G[500231]={'976:52.59,40.81 A:79813 N:79813'}	-- plot 20 location
G[500232]={'976:52.59,40.81 A:79814 N:79814'}	-- plot 20 location
G[500233]={'976:52.59,40.81 A:79867 N:79867'}	-- plot 20 location
G[500234]={'976:52.59,40.81 A:79817 N:79817'}	-- plot 20 location
G[500235]={'976:52.59,40.81 A:79821 N:79821'}	-- plot 20 location
G[500236]={'976:52.59,40.81 A:79820 N:79820'}	-- plot 20 location
G[500237]={'976:52.59,40.81 A:79826 N:79826'}	-- plot 20 location
G[500238]={'976:52.59,40.81 A:86696 N:86696'}	-- plot 20 location
G[500239]={'976:52.59,40.81 A:79829 N:79829'}	-- plot 20 location
G[500240]={'976:52.59,40.81 A:79831 N:79831'}	-- plot 20 location
G[500241]={'976:52.59,40.81 A:79832 N:79832'}	-- plot 20 location
G[500242]={'976:52.59,40.81 A:79830 N:79830'}	-- plot 20 location
G[500243]={'976:52.59,40.81 A:79834 N:79834'}	-- plot 20 location
G[500244]={'976:52.59,40.81 A:79833 N:79833'}	-- plot 20 location
G[500245]={'976:52.59,40.81 A:79864 N:79864'}	-- plot 20 location
G[500246]={'976:52.59,40.81 A:79863 N:79863'}	-- plot 20 location
G[500247]={'976:43.92,48.57 A:1234243 N:1234243'}	-- garrison level 3 position
G[500248]={'941:74.02,29.68 A:72230 N:74651'}
G[500249]={'941:73.93,29.61 A:74253 N:74272'}
G[500250]={'976:37.61,50.28 A:78466 N:3391'}	-- garrison level 3 Horde
G[500251]={'976:52.59,40.81 A:79857 N:79857'}	-- plot 20 location
G[500252]={'971:51.19,63.58 A:77378 N:77378'}	-- plot 20
G[500253]={'971:51.19,63.58 A:88545 N:88545'}	-- plot 20
G[500254]={'976:52.59,40.81 A:88546 N:88546'}	-- plot 20
G[500255]={'971:51.19,63.58 A:88145 N:88145'}	-- plot 20
G[500256]={'976:52.59,40.81 A:88392 N:88392'}	-- plot 20
G[500257]={'949:51.85,50.03 A:1234474 N:1234474'}	-- Lumber Mill-based location
G[500258]={'1052[1]:56.20,54.14 N:103025'}
G[500259]={'1015:53.33,45.41 A:108328 N:108328'}
G[500260]={'1054:49.40,54.86 N:18417'}
G[500261]={'1018[14]:62.94,48.95 A:91223 N:91223'}
G[500262]={'1018:63.20,42.22 A:104728 N:7999'}
G[500263]={'1014[11]:68.03,62.99 A:98102 N:98102'}
G[500264]={'1014[10]:49.49,41.19 A:98102 N:98102'}
G[500265]={'1014[11]:67.64,62.13 A:98102 N:98102'}
G[500382]={'36:29.73,44.51 A:382 N:382'}
G[501759]={'321[1]:52,41 A:101759 N:101759'}
G[502079]={'41:58.13,38.94 A:2079 N:2079'}
G[502080]={'41:43.93,44.19 A:2080 N:2080'}	-- TODO: Determine if the original stuff with him can be given to the second location.  I know "The Shimmering Frond" and "Timberling Sprouts" can go to both.  If the early stuff needs to be done at the original dude, I think it would be best to alias the second one and just make other quests be able to be turned in to either one.
G[502081]={'928:53.93,49.77 A:67985 N:70358'}	-- phase 2 location at Beast Pens
G[502487]={'673:41.53,72.93 A:2487 N:2487'}
G[503515]={'41:41.05,45.56 A:3515 N:3515','Wanders a bit around here'}
G[504508]={'761[1]:65.29,81.51 A:4508 N:4508'}
G[509271]={'201:43.9,7.3 A:9271 N:9271'}
G[514305]={'HC 381:43.16,78.05 A:14305 N:14305'}
G[514444]={'HC 181:25.79,50.47 A:14444 N:14444'}
G[514625]={'28:50.01,39.05 A:14625 N:14625'}
G[514626]={'28:42.24,34.51 A:14626 N:14626'}
G[515732]={'20:61.02,59.36 161:52.57,28.06 321[1]:50.20,61.82 462:56.46,51.80 504[1]:49.33,44.85 673:40.28,67.64 A:15732 N:15732'}
G[515892]={'HL 301:61.74,75.71 A:15892 N:15892'}
G[516116]={'23:76.09,75.35 A:16116 N:16116'}
G[518927]={'301:66.95,72.50 A:18927 N:18927'}
G[519169]={'480:90.23,57.58 A:19169 N:19169'}
G[519171]={'471:60.14,48.91 A:19171 N:19171'}
G[519175]={'321[1]:69.87,49.50 A:19175 N:19175'}
G[519176]={'362:40.91,56.15 A:19176 N:19176'}
G[519177]={'321[1]:39.56,78.21 A:19177 N:19177'}
G[519178]={'382:67.69,39.24 A:19178 N:19178'}
G[520102]={'11:68.21,71.38 A:20102 N:20102'}
G[522818]={'HC 478:39.73,64.56 A:22818 N:22818'}
G[526221]={'HM 321[1]:47.24,37.87 362:21.21,24.06 382:66.89,13.51 480:68.68,42.91 481:60.67,30.63 A:26221 N:26221'} -- Horde version since Blizzard really is doing some odd things
G[526935]={'490:64.94,43.42 A:26935 N:26935'}
G[528401]={'496:60.22,57.70 A:28401 N:28401'}
G[528518]={'Near496 A:28518 N:28518'}
G[532959]={'42:50.13,19.46 A:32959 N:32959'}
G[532971]={'42:50.68,19.73 A:32971 N:32971'}
G[532972]={'42:50.80,18.71 A:32972 N:32972'}
G[533178]={'42:72.37,18.81 A:33178 N:33178'}
G[533532]={'HC 488:46.85,59.37 A:33532 N:33532'}
G[533533]={'HC 486:43.75,14.13 A:33533 N:33533'}
G[534668]={'605:59.67,77.05 A:34668 N:34668'}
G[534872]={'605:60.14,74.61 A:34872 N:34872'}
G[534874]={'605:60.00,78.19 A:34874 N:34874'}
G[535120]={'605:29.66,71.91 A:35120 N:35120'}
G[535222]={'605:20.87,13.69 A:35222 N:35222'}
G[535867]={'181:66.55,20.35 A:35867 N:35867'}
G[536163]={'101:73.34,41.64 A:36163 N:36163'}
G[536210]={'181:53.26,49.96 A:36210 N:36210'}
G[536471]={'544:51.85,47.20 A:36471 N:34872'}
G[536749]={'181:60.64,50.59 A:36749 N:36749'}
G[537570]={'607:48.20,38.65 A:37570 N:37570'}
G[537675]={'HA 321[1]:53.03,77.14 480:64.54,67.31 362:43.61,53.00 382:65.89,38.71 A:37675 N:37675'}
G[538120]={'544:68.94,46.45 A:38120 N:36379'}
G[538124]={'544:51.72,47.39 A:38124 N:36077'}
G[538242]={'891:50.72,52.09 A:38242 N:38242'}
G[538243]={'891:57.66,52.64 4:67.53,84.17>891 A:38243 N:38243'}
G[538387]={'544:37.35,41.91 A:38387 N:34668'}
G[538647]={'544:54.00,16.98 A:38647 N:38647'}
G[538738]={'544:54.44,16.92 A:38738 N:37106'}
G[538935]={'544:42.15,17.38 A:38935 N:4949'}
G[539433]={'606:28.22,29.76 A:39433 N:39433'}
G[539627]={'606:29.64,29.27 A:39627 N:39627'}
G[539858]={'606:19.54,37.82 A:39858 N:5769'}
G[539877]={'615:53.28,33.09 A:39877 N:39877'}
G[539881]={'615:40.59,75.04 A:39881 N:39881'}
G[539908]={'759[1]:56.17,3.73 A:39908 N:28070'}
G[540639]={'615:32.91,69.24 A:40639 N:40639'}
G[540642]={'615:33.23,68.35 A:40642 N:39887'}
G[540643]={'615:33.00,67.55 615:33.00,67.70 615:32.99,67.89 A:40643 N:40643'}
G[540645]={'615:56.59,80.25 A:40645 N:40645','At surface'}
G[540772]={'606:72.08,74.02 A:40772 N:40619'}
G[541006]={'606:32.78,70.75 A:41006 N:41006'}
G[541600]={'614:55.71,72.98 A:41600 N:36915'}
G[542039]={'81:45.62,34.23 A:42039 N:42039'}
G[542076]={'615:46.39,79.05 A:42076 N:40640'}
G[542077]={'615:33.13,75.87 A:42077 N:40640'}
G[542466]={'640:33.11,24.11 A:42466 N:42466'}
G[542790]={'37:38.47,48.62 A:42790 N:42790'}
G[543733]={'36:77.20,65.91 A:43733 N:43221'}
G[543885]={'Near37 A:43885 N:43885'}
G[544293]={'301:80.27,62.12 A:44293 N:1747','Up on third floor'}
G[544365]={'21:44.89,41.65 A:44365 N:10181'}
G[544402]={'761[1]:23.40,31.57 A:44402 N:44402'}
G[544415]={'761[1]:23.78,30.70 A:44415 N:44415'}
G[544453]={'22:39.91,69.47 A:44453 N:26170'}
G[544467]={'22:40.03,69.23 A:44467 N:44467'}
G[544640]={'21:44.82,40.92 A:44640 N:44640'}
G[544806]={'301:26.13,47.29 A:44806 N:44806'}
G[544916]={'21:45.81,41.94 A:44916 N:44916'}
G[544917]={'21:45.76,41.91 A:44917 N:44917'}
G[545165]={'22:53.84,64.68 A:45165 N:45165'}
G[545172]={'700:79.22,78.29 A:45172 N:45172'}
G[545200]={'765[1]:21.59,80.75 23:27.07,15.77>765 A:45200 N:16115'}
G[545201]={'765[1]:24.15,76.31 23:27.07,15.77>765 A:45201 N:45201'}	-- this location is valid after 35563 is completed
G[545206]={'765[2]:43.87,14.12 23:43.45,19.36>765 A:45206 N:16112'}
G[545277]={'Near61 A:45277 N:45277'}
G[545278]={'Near61 A:45278 N:45278'}
G[545312]={'684:72.96,30.11 A:45312 N:44789'}
G[545323]={'765[1]:21.66,79.72 23:27.07,15.77>765 A:45323 N:45323'}
G[545328]={'765[2]:49.73,22.34 23:43.45,19.36>765 A:45328 N:45323'}
G[545329]={'765[2]:44.82,20.47 23:43.45,19.36>765 A:45329 N:16115'}
G[545330]={'765[2]:42.45,12.70 23:43.45,19.36>765 A:45330 N:16116'}
G[545331]={'765[2]:49.82,18.49 23:43.45,19.36>765 A:45331 N:45201'}
G[545400]={'23:35.01,69.28 A:45400 N:45400'}	-- the first stop...still only has three original quests
G[545417]={'23:34.85,69.14 A:45417 N:45417'}
G[545429]={'23:35.26,68.86 A:45429 N:45429'}
G[545451]={'23:50.49,20.22 A:45451 N:45451'}
G[545474]={'684:79.66,75.66 A:45474 N:44789'}
G[545574]={'23:60.61,43.33 A:45574 N:45574'}
G[545729]={'23:61.57,43.22 A:45729 N:45429'}
G[545730]={'23:73.75,52.17 A:45730 N:45428'}
G[546409]={'690[1]:22.07,27.20 A:46409 N:46409'}
G[546612]={'756[2]:59.05,36.56 756[2]:60.31,38.84 A:46612 N:42308'}
G[546654]={'17:21.17,57.77 A:46654 N:46654'}
G[546664]={'17:17.98,30.55 A:46664 N:46664'}
G[546804]={'700:60.18,57.83 A:46804 N:46804'}
G[547006]={'764[1]:63.09,71.36 764[1]:59.36,61.16 A:47006 N:47006'}
G[547293]={'764[1]:63.09,71.36 A:47293 N:44789'}
G[547393]={'28:40.81,51.67 A:47393 N:47393'}
G[547429]={'28:38.97,26.02 A:47429 N:47269'}
G[547900]={'24:36.64,61.20 A:47900 N:47900'}
G[548020]={'24:36.56,58.07 A:48020 N:47900'}
G[548021]={'24:38.16,56.41 A:48021 N:47869'}
G[548218]={'24:50.03,74.34 A:48218 N:48218'}
G[548306]={'29:73.49,67.19 A:48306 N:43184'}
G[549020]={'700:78.92,76.65 A:49020 N:44806'}
G[549476]={'753[2]:68.84,55.96 A:49476 N:49444'}
G[549480]={'Near41 A:49480 N:1992','In cave'}
G[552234]={'Near673 A:52234 N:52234'}
G[552477]={'795:41.57,61.32 A:52477 N:40278','In Molten Flow cave'}
G[552478]={'795:51.30,85.81 A:52478 N:39925'}
G[552823]={'795:57.73,49.51 A:52823 N:52823'}
G[552838]={'606:27.11,62.81 A:52838 N:5769'}
G[552845]={'606:27.02,62.69 A:52845 N:33091'}
G[552924]={'781:93.31,53.54 A:52924 N:38966'}
G[552925]={'781:91.77,55.19 A:52925 N:52925'}
G[553073]={'606:27.49,61.58 A:53073 N:53073'}
G[553080]={'795:45.60,86.22 A:53080 N:41492'}
G[553566]={'808:59.68,19.10 A:53566 N:53566'}
G[553738]={'640:64.05,46.09 A:53738 N:35875'}
G[554616]={'806:41.39,79.57 A:54616 N:54616'}
G[554617]={'806:46.47,96.30 A:54617 N:54617'}
G[554786]={'808:51.58,48.33 A:54786 N:53566'}
G[554914]={'806:42.74,23.17 A:54914 N:54914'}
G[554943]={'808:55.10,32.39 A:54943 N:54943'}
G[554960]={'806:58.05,80.56 A:54960 N:54960'}
G[554975]={'808:79.81,39.28 A:54975 N:54567'}
G[555020]={'808:78.48,42.84 A:55020 N:55020'}
G[555521]={'806:28.10,24.70 A:55521 N:55521'}
G[555595]={'808:24.78,69.76 A:55595 N:54567'}
G[555624]={'816:29.34,39.98 A:55624 N:54476'}
G[556111]={'807:18.06,31.01 A:56111 N:54913'}
G[556112]={'857:28.85,50.57 A:56112 N:56112'}
G[556114]={'857:25.19,34.54 A:56114 N:56112'}
G[556133]={'807:68.87,43.14 A:56133 N:56133'}
G[556138]={'807:68.77,43.43 A:56138 N:56138'}
G[556312]={'807:74.41,34.52 A:56312 N:56312'}
G[556339]={'806:28.67,47.54 A:56339 N:54870'}	-- this location is after turn in of 29824
G[556406]={'806:27.23,50.78 A:56406 N:55521'}	-- this move was during 29937
G[556474]={'807:54.27,38.73 A:56474 N:56474'}
G[556720]={'807:17.85,56.25 A:56720 N:56720'}
G[557298]={'807:48.29,33.87 A:57298 N:57298'}	-- at home
G[557402]={'807:52.99,51.74 A:57402 N:57402'}	-- at Halfhill
G[557864]={'820[6]:51.06,43.48 A:57864 N:57864'}
G[558113]={'857:59.88,24.68 A:58113 N:58113'}
G[558114]={'857:28.70,50.88 A:58114 N:58114'}
G[558422]={'807:19.90,75.67 A:58422 N:715'}
G[558465]={'811:56.57,43.60 A:58465 N:58465'}
G[558468]={'811:56.51,43.39 A:58468 N:58468'}
G[558471]={'811:56.51,43.60 A:58471 N:58471'}
G[558607]={'857:28.90,50.86 A:58607 N:58113'}
G[558630]={'857:24.87,34.36 A:58630 N:58630'}
G[558646]={'807:52.25,48.79 A:58646 N:58646'}
G[558647]={'807:31.51,58.07 A:58647 N:58647'}	-- at home
G[558705]={'807:41.72,30.02 A:58705 N:58705'}	-- at home
G[558707]={'807:30.95,53.10 A:58707 N:58707'}	-- at home
G[558708]={'807:29.53,30.60 A:58708 N:58708'}	-- at home
G[558709]={'807:53.07,52.05 A:58709 N:58709'}	-- at Halfhill
G[558745]={'857:15.09,39.43 A:58745 N:58745'}
G[558761]={'807:52.97,51.79 A:58761 N:58761'}	-- Halfhill
G[559441]={'809:53.77,82.68 A:59441 N:55122'}
G[559856]={'807:17.91,55.75 A:59856 N:56714'}
G[559905]={'811:44.77,76.33 A:59905 N:59905'}
G[560622]={'810:76.19,72.91 A:60622 N:60622'}
G[560679]={'809:36.94,76.22 A:60679 N:60679'}
G[560687]={'810:71.02,56.55 A:60687 N:60687'}
G[560795]={'809:43.76,51.11 A:60795 N:54961'}
G[560973]={'809:75.20,88.26 A:60973 N:60973'}
G[561021]={'810:74.23,85.04 A:61021 N:61021'}
G[561161]={'810:35.40,56.65 A:61161 N:61161'}
G[561482]={'810[13]:56.18,20.17 A:61482 N:61482'}
G[561539]={'810:39.45,61.93 A:61539 N:61539'}
G[561819]={'809:35.32,49.56 A:61819 N:60687'}
G[561820]={'809:31.82,60.12 A:61820 N:61016'}
G[561822]={'680[1]:31.67,76.37 A:61822 N:61822'}	-- at end of dungeon
G[561823]={'680[1]:32.07,75.90 A:61823 N:61823'}	-- at end of dungeon
G[562151]={'858:28.65,42.14 A:62151 N:62151'}
G[562180]={'Near858 A:62180'}
G[562274]={'810:54.07,77.87 A:62274 N:60688'}
G[562295]={'Near810 A:62295'}
G[562304]={'810:49.18,71.05 A:62304 N:60687'}
G[562378]={'Near810 A:62378'}
G[562379]={'Near810 A:62379 N:562295'}
G[562666]={'858:38.18,17.18 A:62666 N:62666'}
G[562667]={'858:38.30,17.13 A:62667 N:62667'}
G[562668]={'858:38.20,17.11 A:62668 N:62668'}
G[562774]={'858:55.06,35.47 A:62774 N:62774'}
G[562779]={'858:54.10,20.48 A:62779 N:56133'}
G[563195]={'Near810 A:63195'}
G[563196]={'Near810 A:63196'}
G[563197]={'Near810 A:63197'}
G[563310]={'891:51.95,52.02 A:63310 N:63310'}
G[563317]={'858:54.77,72.11 A:63317 N:63317'}
G[563349]={'858:56.57,75.83 A:63349 N:63349'}	-- only appears here after OCC:31190
G[563367]={'873:51.91,43.74 A:63367 N:63367'}
G[563535]={'809:61.20,82.22 A:63535 N:63535'}
G[563542]={'809:54.70,84.22 A:63542 N:63542'}
G[563622]={'Near810 A:63622'}
G[563623]={'Near810 A:63623'}
G[563624]={'Near810 A:63624'}
G[563751]={'809:63.67,86.65 N:63751'}
G[563754]={'809:61.25,82.29 A:63754 N:63754'}
G[564259]={'858:53.64,76.05 A:64259 N:64259'}
G[564432]={'885[3]:38.68,81.40 811:80.82,32.72>885 A:64432 N:63266'}
G[564467]={'875[1]:52.30,60.57 811:15.84,74.39>875 A:64467 N:62112'}
G[564521]={'809:72.03,94.25 A:64521 N:64521'}	-- Location for quest 31393 when I checked last
G[564562]={'Near898 A:64562 N:64562'}	-- skull location floating through dungeon
G[564563]={'Near898 A:64563 N:64562'}	-- skull location floating through dungeon
G[564738]={'871[1]:31.91,84.42 A:64738 N:64764'}
G[564764]={'871[1]:31.92,84.41 A:64764 N:64764'}
G[565558]={'Near808'}
G[566292]={'806:48.05,88.39 A:66292 N:66292'}
G[567660]={'928:46.86,66.91 A:67660 N:30116'}	-- phase 2 location
G[567662]={'928:28.40,53.36 A:67662 N:67662'}	-- phase 1 location on ship.  phase 2 is NPC 67662
G[567663]={'928:28.60,52.46 A:67663 N:36670'}	-- phase 1 location on ship.  phase 2 is NPC 67663
G[567673]={'928:28.42,52.44 A:67673 N:34771'}	-- phase 1 location on ship.  phase 2 is NPC 67673
G[567734]={'809:32.90,26.27 A:67734 N:67734'}
G[567984]={'928:36.76,64.90 A:67984 N:33538'}	-- phase 2 location	[TODO: Deal with the location 928:32.52,35.68 which is at camp when not in the field]
G[567985]={'928:53.93,49.77 A:67985 N:70358'}	-- phase 2 location at Conqueror's Terrace	; Beast Pens NPC is 502081
G[567986]={'928:47.2,40.6 A:67986 N:33542'}	-- Beast Pens
G[567990]={'928:28.36,52.43 A:67990 N:16802'}	-- phase 1 location on ship.  phase 2 is NPC 67990
G[567992]={'862:19.34,18.86 A:67992 N:4968'}
G[567993]={'928:63.25,72.13 A:67993 N:30115'}	-- Phase 2 location.  Phase 1 is NPC 67993.
G[567995]={'928:62.70,73.56 A:67995 N:67995'}	-- Phase 2 location.  Phase 1 is NPC 67995.
G[567996]={'928:55.74,74.40 N:67996'}	-- Phase 2 location.  Phase 1 is NPC 67996.
G[567997]={'928:40.19,59.56 N:34880'}	-- Phase 2 location.  Phase 1 is NPC 67997.
G[567998]={'928:61.88,51.99 A:67998 N:67998'}	-- Conqueror's Terrace location
G[567999]={'928:61.89,52.09 A:67999 N:67999'}	-- Conqueror's Terrace location
G[568004]={'857:88.98,31.71 A:68004 N:1747'}
G[568025]={'891:38.39,46.47 A:68025 N:4949'}
G[568072]={'Near857 A:68072 N:68072'}
G[568399]={'Near857 A:68399 N:68399'}
G[568651]={'41:39.98,50.48 A:68651 N:4968'}
G[569418]={'928:36.64,64.68 A:69418 N:69418'}	-- phase 2 location [TODO: Deal with the location 928:32.53,35.74 which is the location at camp when not in the field]
G[569433]={'928:46.92,66.90 A:69433 N:69433'}	-- phase 2 location
G[569668]={'928:40.15,59.30 N:69668'}	-- Phase 2 location.  Phase 1 is NPC 69668.
G[569670]={'928:64.83,73.11 N:69670'}	-- Phase 5 location.
G[569673]={'928:42.16,66.45 N:69673'}	-- Phase 2 location.  Phase 1 is NPC 69673.
G[569674]={'928:42.30,66.32 N:69674'}	-- Phase 2 location.  Phase 1 is NPC 69674
G[569675]={'928:55.89,74.41 N:58735'}	-- Phase 2 location.  Phase 1 NPC is 69675.
G[569677]={'928:55.55,74.44 N:69677'}	-- Phase 2 location.  Phase 1 is NPC 69677.
G[569678]={'928:55.61,74.52 N:19644'}	-- Phase 2 location.  Phase 1 is NPC 69678.
G[570297]={'928:32.89,32.68 A:70297 N:61021'}	-- Horde version of Taoshi
G[570517]={'928:42.21,66.33 A:70517 N:20735'}	-- Phase 2 position.  Phase 1 is NPC 70517.
G[570860]={'941:20.75,57.97 A:70860 N:70860'}
G[570941]={'941[8]:49.72,51.91 A:70941 N:79917'}
G[570980]={'809:43.76,51.12 A:70980 N:70980'}
G[571333]={'4:49.80,40.10 A:71333 N:71333'}
G[572230]={'941:57.41,41.47 A:72230 N:74651'}
G[572274]={'941:47.57,45.57 A:72274 N:72274'}
G[573395]={'947:52.23,46.15 A:73395 N:78994'}
G[573480]={'941:19.88,14.62 A:73480 N:77417'}
G[574009]={'688[2]:87.74,86.41 43:16.52,11.03>688 A:74009 N:44375'}
G[574043]={'947:49.30,37.40 A:74043 N:17468'}
G[574163]={'976:50.14,37.92 A:74163 N:70860'}
G[574253]={'941:57.38,41.42 A:74253 N:74272'}
G[574594]={'949:41.49,74.08 A:74594 N:70860'}
G[574606]={'949:46.58,71.53 A:74606 N:74606'}
G[574611]={'949:41.48,74.14 A:74611 N:74611'}
G[574635]={'941:24.44,29.04 A:74635 N:74635'}
G[575136]={'949:53.43,60.33 A:75136 N:78568'}
G[575146]={'949:53.48,60.43 A:75146 N:79576'}
G[575177]={'941[2]:50.40,32.67 A:75177 N:70860'}
G[575256]={'946:60.92,72.45 A:75256 N:78519'}
G[575606]={'688[2]:87.74,86.41 43:16.52,11.03>688 A:75606 N:33260'}
G[575803]={'946:63.04,25.89 A:75803 N:78554'}
G[575804]={'946:63.06,25.83 A:75804 N:78994'}
G[575808]={'946:62.01,10.99 A:75808 N:74651'}
G[575874]={'946:63.08,26.11 A:75874 N:78568'}
G[575884]={'947:45.84,25.58 A:75884 N:75884'}
G[576411]={'941:40.77,67.09 A:76411 N:74272'}
G[577160]={'949:69.63,26.10 A:77160 N:14627'}
G[577161]={'941:88.40,49.48 A:77161 N:78568'}
G[577184]={'947:29.21,25.73 A:77184 N:78558'}
G[577209]={'971:31.68,31.17 A:77209 N:79243'}	-- garrison level 2 location
G[577210]={'941:82.61,69.75 A:77210 N:77210'}
G[577282]={'947:35.72,36.89 A:77282 N:17468'}
G[577354]={'971:50.03,57.75 A:77354 N:77354'}	-- plot 19
G[577356]={'971:50.03,57.75 A:77356 N:77356'}	-- plot 19
G[577359]={'971:50.03,57.75 A:77359 N:77359'}	-- plot 19
G[577363]={'971:50.03,57.75 A:77363 N:77363'}	-- plot 19
G[577365]={'971:50.03,57.75 A:77365 N:77365'}	-- plot 19
G[577367]={'971:45.25,42.49 A:77367 N:77367'}	-- plot 23
G[577372]={'971:50.03,57.75 A:77372 N:77372'}	-- plot 19
G[577377]={'971:45.25,42.49 A:77377 N:77377'}	-- plot 23
G[577378]={'971:50.03,57.75 A:77378 N:77378'}	-- plot 19
G[577382]={'971:50.03,57.75 A:77382 N:77382'}	-- plot 19
G[577383]={'971:50.03,57.75 A:77383 N:77383'}	-- location is top of stairs for plot 19
G[577737]={'946[13]:68.38,19.34 A:77737 N:77737'}
G[577775]={'971:50.03,57.75 A:77775 N:77775'}	-- plot 19
G[577777]={'971:50.03,57.75 A:77777 N:77777'}	-- plot 19
G[577778]={'971:50.03,57.75 A:77778 N:77778'}	-- plot 19
G[577781]={'971:50.03,57.75 A:77781 N:77781'}	-- plot 19
G[577791]={'971:50.03,57.75 A:77791 N:77791'}	-- plot 19
G[577792]={'971:50.03,57.75 A:77792 N:77792'}	-- plot 19
G[577831]={'971:50.03,57.75 A:77831 N:77831'}	-- plot 19
G[577928]={'941:50.04,56.20 A:77928 N:3391'}
G[578028]={'946:60.90,72.54 A:78028 N:77737'}
G[578207]={'971:50.03,57.75 A:78207 N:78207'}	-- location is top of stairs for plot 19
G[578323]={'941:88.40,49.55 A:78323 N:3391'}
G[578466]={'941:48.72,68.93 A:78466 N:3391'}	-- pre-garrison position
G[578487]={'976:45.95,42.71 A:78487 N:26859'}	-- Garrison Level 3 position
G[578553]={'970:71.92,62.06 A:78553 N:4949'}
G[578554]={'970[1]:80.72,45.23 A:78554 N:78554'}
G[578559]={'970:71.54,62.37 A:78559 N:78558'}
G[578560]={'970:73.02,38.09 A:78560 N:78558'}
G[578563]={'970:43.14,28.74 A:78563 N:78558'}
G[578564]={'971:38.47,31.46 A:78564 N:78564'}	-- garrison level 3 location
G[578994]={'970[1]:50.59,48.31 A:78994 N:78994'}
G[578996]={'970:73.18,38.94 A:78996 N:74272'}
G[579043]={'947:35.27,49.14 A:79043 N:17468'}
G[579519]={'948:45.39,18.26 A:79519 N:79519'}
G[579537]={'970[1]:50.25,48.25 A:79537 N:79537'}
G[579573]={'946:71.59,29.90 A:79573 N:79573'}
G[579740]={'976:39.31,55.42 A:79740 N:79740'}	-- Garrison Level 3 position
G[579748]={'948:40.18,60.26 A:79748 N:79748'}
G[579813]={'976:48.38,33.59 A:79813 N:79813'}	-- plot 19 location
G[579814]={'976:48.38,33.59 A:79814 N:79814'}	-- plot 19 location
G[579815]={'976:58.88,49.06 A:79815 N:79815'}	-- plot 23 location
G[579817]={'976:48.38,33.59 A:79817 N:79817'}	-- plot 19 location
G[579820]={'976:48.38,33.59 A:79820 N:79820'}	-- plot 19 location
G[579821]={'976:48.38,33.59 A:79821 N:79821'}	-- plot 19 location
G[579826]={'976:48.38,33.59 A:79826 N:79826'}	-- plot 19 location
G[579829]={'976:48.38,33.59 A:79829 N:79829'}	-- plot 19 location
G[579830]={'976:48.38,33.59 A:79830 N:79830'}	-- plot 19 location
G[579831]={'976:48.38,33.59 A:79831 N:79831'}	-- plot 19 location
G[579832]={'976:48.38,33.59 A:79832 N:79832'}	-- plot 19 location
G[579833]={'976:48.38,33.59 A:79833 N:79833'}	-- plot 19 location
G[579834]={'976:48.38,33.59 A:79834 N:79834'}	-- plot 19 location
G[579857]={'976:48.38,33.59 A:79857 N:79857'}	-- plot 19 location
G[579862]={'976:48.38,33.59 A:79862 N:79862'}	-- plot 19 location
G[579863]={'976:48.38,33.59 A:79863 N:79863'}	-- plot 19 location
G[579864]={'976:48.38,33.59 A:79864 N:79864'}	-- plot 19 location
G[579867]={'976:48.38,33.59 A:79867 N:79867'}	-- plot 19 location
G[579953]={'971:31.17,32.85 A:79953 N:79953'}	-- garrison level 2 location
G[580073]={'947:62.45,26.28 A:80073 N:79537'}
G[580078]={'947:61.92,29.61 A:80078 N:72413'}
G[580079]={'947:62.48,26.22 A:80079 N:80079'}
G[580153]={'948:45.93,45.77 A:80153 N:75288'}
G[580159]={'971:48.96,41.09 A:80159 N:80159'}	-- garrison level 1 location
G[580163]={'971:37.94,63.85 A:80163 N:80163'}	-- garrison level 2 location
G[580193]={'Near946 A:80193 N:79393'}
G[580648]={'948:66.84,51.70 A:80648 N:80648'}
G[580758]={'948:46.72,46.38 A:80758 N:80758'}
G[581152]={'971:46.52,54.30 A:81152 N:81152'}
G[581530]={'947:50.57,82.29 A:81530 N:81530'}
G[581770]={'948:45.87,45.73 A:81770 N:79519'}
G[581790]={'950:64.24,59.55 A:81790 N:18261'}
G[582574]={'949:60.71,64.77 A:82574 N:85147'}
G[582610]={'949:44.90,63.95 A:82610 N:82610'}
G[583606]={'950:63.49,60.70 A:83606 N:83606'}
G[583823]={'946:84.81,31.43 A:83823 N:78558'}
G[583858]={'976:48.19,47.01 A:83858 N:83858'}
G[584248]={'971:35.53,49.36 A:84248 N:84248'}	-- plot 22
G[584524]={'971:51.21,47.04 A:84524 N:84524'}	-- plot 25
G[584702]={'950:92.34,31.43 A:84702 N:78558'}
G[584857]={'971:50.03,57.75 A:84857 N:84857'}	-- plot 19
G[584947]={'971:51.21,47.04 A:84947 N:84947'}	-- plot 25 location
G[585048]={'976:57.75,28.14 A:85048 N:85048'}	-- plot 25 location
G[585413]={'971:35.53,49.36 A:85413 N:45109'}	-- entrance to plot 22
G[585414]={'976:51.43,57.39 A:85414 N:45110'}	-- plot 22 location
G[585431]={'949:52.04,49.49 A:85431 N:85436'}	-- Lumber Mill-based location
G[585777]={'971:53.48,69.35 A:85777 N:77031'}	-- garrison level 1 position
G[585984]={'976:38,72 A:85984 N:12919'}
G[586475]={'948:66.75,51.58 A:86475 N:80758'}
G[586629]={'976:57.75,28.14 A:86629 N:86629'}	-- plot 25 location
G[586696]={'976:48.38,33.59 A:86696 N:86696'}	-- plot 19 location
G[586946]={'Near A:86946 N:23066'}
G[586973]={'971:40.09,56.58 A:86973 N:46804'}	-- plot 24 location
G[586974]={'971:40.09,56.58 A:86974 N:86974'}	-- plot 24 location
G[586979]={'976:60.36,36.51 A:86979 N:27221'}	-- plot 24 location
G[587121]={'976:57.75,28.14 A:87121 N:87121'}	-- plot 25 location
G[587206]={'971:51.21,47.04 A:87206'}	-- plot 25 location
G[587217]={'971:51.21,47.04 A:87217 N:87215'}	-- plot 25 location
G[587242]={'976:60.36,36.51 A:87242 N:26584'}	-- plot 24 location
G[587305]={'976:57.75,28.14 A:87305 N:87305'}	-- plot 25 location
G[587561]={'Near A:87561 N:87561'}
G[587991]={'971:51.21,47.04 A:87991 N:87991'}	-- plot 25
G[587992]={'971:51.21,47.04 A:87992 N:46854'}	-- plot 25
G[587994]={'971:51.21,47.04 A:87994 N:87994'}	-- plot 25
G[587995]={'971:51.21,47.04 A:87995 N:2487'}	-- plot 25
G[587996]={'971:51.21,47.04 A:87996 N:64842'}	-- plot 25
G[587997]={'971:51.21,47.04 A:87997 N:11036'}	-- plot 25
G[587998]={'971:51.21,47.04 A:87998 N:58113'}	-- plot 25
G[587999]={'971:51.21,47.04 A:87999 N:40997'}	-- plot 25
G[588000]={'971:51.21,47.04 A:88000 N:49444'}	-- plot 25
G[588001]={'971:51.21,47.04 A:88001 N:38237'}	-- plot 25
G[588002]={'971:51.21,47.04 A:88002 N:28444'}	-- plot 25
G[588003]={'971:51.21,47.04 A:88003 N:88003'}	-- plot 25
G[588004]={'971:51.21,47.04 A:88004 N:88004'}	-- plot 25
G[588005]={'971:51.21,47.04 A:88005 N:54961'}	-- plot 25
G[588006]={'971:51.21,47.04 A:88006 N:88006'}	-- plot 25
G[588007]={'971:51.21,47.04 A:88007 N:88007'}	-- plot 25
G[588009]={'971:51.21,47.04 A:88009 N:88009'}	-- plot 25
G[588013]={'971:51.21,47.04 A:88013 N:47269'} -- plot 25
G[588017]={'971:51.21,47.04 A:88017 N:46338'} -- plot 25
G[588022]={'971:51.21,47.04 A:88022 N:47869'} -- plot 25
G[588023]={'971:51.21,47.04 A:88023 N:61021'} -- plot 25
G[588024]={'971:51.21,47.04 A:88024 N:9177'} -- plot 25
G[588025]={'971:51.21,47.04 A:88025 N:39930'}	-- plot 25
G[588026]={'971:51.21,47.04 A:88026 N:43184'}	-- plot 25
G[588027]={'971:51.21,47.04 A:88027 N:47366'} -- plot 25
G[588145]={'971:50.03,57.75 A:88145 N:88145'}	-- plot 19
G[588392]={'976:48.38,33.59 A:88392 N:88392'}	-- plot 19
G[588545]={'971:50.03,57.75 A:88545 N:88545'}	-- plot 19
G[588546]={'976:48.38,33.59 A:88546 N:88546'}	-- plot 19
G[588892]={'976:54.66,14.42 A:88892 N:88892'}
G[589023]={'1015:46.96,41.22 A:89023 N:89023'}
G[589793]={'976:40.18,56.62 A:89793 N:26814'}	-- Horde location
G[590238]={'945:62.57,50.89 A:90238 N:90238'}
G[590749]={'1017:33.81,46.03 A:90749 N:66292'}
G[591166]={'1015:61.30,50.79 A:91166 N:91165'}
G[591223]={'1018[14]:62.71,48.73 A:91223 N:91223'}
G[591242]={'949:50.61,16.69 A:91242 N:91242'}
G[591750]={'946[30]:53.57,69.07 A:91750 N:75121'}
G[591751]={'946[30]:56.75,66.65 A:91751 N:90177'}
G[591913]={'947:75.13,57.79 A:91913 N:90177'}
G[591923]={'962:62.45,54.23 A:91923 N:80079'}
G[592213]={'941:40.8,73.2 A:92213 N:78558'}
G[592718]={'1032[1]:49.45,49.82 A:92718 N:92718'}
G[592842]={'1018:43.82,50.29 A:92842 N:40619'}
G[592850]={'1018[3]:43.24,80.95 A:92850 N:40619'}	-- i think outer map location is 1018:40.58,44.28
G[592986]={'1032[1]:48.68,49.31 A:92986 N:18417'}
G[593805]={'1024:38.62,68.42 A:93805 N:93805'}
G[593822]={'947:28.20,11.69 A:93822 N:93822'}
G[594429]={'941:40.71,70.25 A:94429 N:91242'}
G[594789]={'941:42.10,71.04 A:94789 N:94789'}	-- location after accepting 39243
G[594870]={'976:41.46,47.18 A:94870 N:94870'}
G[594902]={'1014[10]:65.64,67.30 A:94902 N:93011'}
G[595237]={'1052[1]:58.58,57.88 A:95237 N:18417'}
G[595240]={'1052[1]:58.62,57.78 A:95240 N:93011'}
G[595424]={'945:60.42,46.73 A:95424 N:95424'}
G[596362]={'976:47.35,38.45 A:96362 N:96362'}
G[596644]={'301:18.92,42.75 A:96644 N:66292'}
G[596665]={'1032[1]:50.80,72.79 A:96665 N:93011'}
G[596683]={'1014[10]:29.12,46.89 A:96683 N:96683'}
G[596686]={'4:61.48,8.77 A:96686 N:10181'}
G[596705]={'976:47.11,37.54 A:96705 N:96705'}
G[597296]={'321[1]:52.53,88.16 A:97296 N:78558'}
G[597553]={'1024[5]:47.35,44.42 A:97553 N:97553'}
G[598102]={'1014[10]:51.70,70.46 A:98102 N:98102'}
G[598632]={'1052[1]:59.93,48.92 A:98632 N:109295'}
G[600000]={'951:36.69,34.07'}
G[600001]={'951:25.48,27.18 N:600000'}
G[600002]={'951:27.35,39.07 N:600000'}
G[600003]={'951:30.60,36.51 N:600000'}
G[600004]={'951:22.39,35.41 N:600000'}
G[600005]={'951:22.15,49.27 N:600000'}
G[600006]={'951:24.80,53.04 N:600000'}
G[600007]={'951:25.68,45.84 N:600000'}
G[600008]={'951:22.26,68.07 N:600000'}
G[600009]={'951:26.85,68.75 N:600000'}
G[600010]={'951:30.99,76.30 N:600000'}
G[600011]={'951:35.34,76.44 N:600000'}
G[600012]={'951:38.74,71.62 N:600000'}
G[600013]={'951:39.81,79.50 N:600000'}
G[600014]={'951:34.84,84.20 N:600000'}
G[600015]={'951:43.560,84.040 N:600000'}
G[600016]={'951:46.99,53.73 N:600000'}
G[600017]={'951:46.70,46.74 N:600000'}
G[600018]={'951:51.16,45.69 N:600000'}
G[600019]={'951:55.55,44.33 N:600000'}
G[600020]={'951:58.02,50.68 N:600000'}
G[600021]={'951:65.61,47.87 N:600000'}
G[600022]={'951:63.80,59.15 N:600000'}
G[600023]={'951:64.90,75.57 N:600000'}
G[600024]={'951:60.16,66.05 N:600000'}
G[600025]={'951:49.72,65.73 N:600000'}
G[600026]={'951:53.10,70.82 N:600000'}
G[600027]={'951:52.66,62.75 N:600000'}
G[600028]={'951:44.13,65.42 N:600000'}
G[600029]={'951:26.02,61.44 N:600000'}
G[600030]={'951:24.63,38.56 N:600000'}
G[600031]={'951:59.93,31.33 N:600000'}
G[600032]={'951:29.77,31.73 N:600000'}
G[600034]={'951:28.16,35.12 N:600000 N:600001'}
G[600035]={'951:26.69,64.98 N:600000 N:600001'}
G[600036]={'951:64.55,70.32 N:600000 N:600001'}
G[600037]={'951:59.25,49.48 N:600000 N:600001'}
G[600038]={'951:69.46,33.09 N:600000 N:600002'}
G[600039]={'951:54.02,78.20 N:600000 N:600002'}
G[600040]={'951:47,26 N:600000'}
G[600041]={'951:61.69,88.53 N:600000'}
G[700000]={'23:74.29,53.24 A:90369'}
G[700001]={'22:51.62,81.85 A:108776'}
G[700002]={'22:52.11,83.19 A:108776'}
G[700003]={'1077:45.65,50.03 A:114562'}
G[700004]={'1015:49.21,16.09 A:90383'}
G[700005]={'1015:49.10,16.69 A:89978'}
G[700006]={'301:60.71,70.69 A:77789'}
G[700007]={'971:32.57,49.68 A:88024'}
G[700008]={'1015:51.49,16.06 A:114562'}
G[700009]={'1014[10]:37.32,43.85 A:77789'}
G[700010]={'1014[10]:71.58,44.60 A:77789'}
G[700011]={'1015:42.17,43.50 A:101943'}
G[700012]={'1077:67.28,75.72 A:103778'}
G[700013]={'301:40.17,77.84 A:114562'}
G[700014]={'1014[10]:57.72,48.55 A:101061'}
G[700015]={'1077:60.20,52.02 A:112953'}
G[700016]={'1017:49.80,32.62 A:107498'}
G[700017]={'1024[8]:41.73,79.78 A:96286'}
G[700018]={'949:57.05,35.83 A:86264'}
G[700019]={'971:28.90,40.02 A:91017'}
G[700020]={'971:36.17,62.62 A:77377'}
G[700021]={'946:69.28,46.46 A:79724'}
G[700022]={'941:37.49,18.28 A:88437'}
G[700023]={'1052[1]:56.47,54.66 A:103025'}
G[700024]={'1014[10]:0.00,0.00 A:112130'}
G[700025]={'710[1]:67.21,53.79 A:16808'}
G[700026]={'1024:43.42,33.55 A:95290'}
G[700027]={'945:25.53,32.42 A:90265'}
G[700028]={'728[1]:83.76,73.35 A:17942'}
G[700029]={'1024:46.73,29.41 A:95290'}
G[700030]={'1024[31]:52.51,61.62 A:95799'}
G[700031]={'949:47.82,74.39 A:81617'}
G[700032]={'811:85.74,63.53 A:77789'}
G[700033]={'1024[31]:65.27,42.79 A:95753'}
G[700034]={'341:70.01,20.61 A:5637'}
G[700035]={'949:42.46,77.72 A:81575'}
G[700036]={'876[1]:76.97,37.18 A:59704'}
G[700037]={'1170:53.48,90.73 A:127151'}
G[700038]={'949:48.06,94.21 A:81751'}
G[700039]={'876[1]:76.97,37.18 A:59822'}
G[700040]={'876[2]:0.00,0.00 A:59479'}
G[700041]={'1024:53.23,64.04 A:93846'}
G[700042]={'1018:38.16,65.26 A:91847'}
G[700043]={'971:38.31,40.28 A:83858'}
G[700044]={'1024:52.28,65.92 A:93846'}
G[700045]={'876[2]:0.00,0.00 A:59074'}
G[700046]={'874[2]:0.00,0.00 A:64827'}
G[700047]={'1024:53.25,64.43 A:97407'}
G[700048]={'874[2]:48.86,76.88 A:64841'}
G[700049]={'161[18]:41.94,49.29 A:15192'}
G[700050]={'876[2]:0.00,0.00 A:64361'}
G[700051]={'871[1]:0.00,0.00 A:64738'}
G[700052]={'898[2]:0.00,0.00 A:59080'}
G[700053]={'733:49.01,72.43 A:15608'}
G[700054]={'877[2]:83.76,54.66 A:62236'}
G[700055]={'765[1]:49.96,21.37 A:10808'}
G[700056]={'301:48.97,87.21 A:77789'}
G[700057]={'877[3]:21.16,24.50 A:56541'}
G[700058]={'1018:44.36,48.34 A:92954'}
G[700059]={'765[1]:29.15,41.43 A:11032'}
G[700060]={'1024:50.89,36.57 A:94068'}
G[700061]={'765[1]:21.18,81.32 A:10813'}
G[700062]={'877[1]:72.39,47.48 A:56884'}
G[700063]={'946:47.81,90.26 A:77426'}
G[700064]={'1018:40.56,44.33 A:92850'}
G[700065]={'38:74.69,49.14 A:46424'}
G[700066]={'38:77.52,46.19 A:46623'}
G[700067]={'877[1]:71.08,48.14 A:64387'}
G[700068]={'1018[13]:43.21,82.18 1018:40.56,44.32 A:93029'}
G[700069]={'887[2]:63.33,79.51 A:64517'}
G[700070]={'887[2]:0.00,0.00 A:64517'}
G[700071]={'971:55.71,72.47 A:85777'}
G[700072]={'1018:39.48,42.12 A:92987'}
G[700073]={'874[2]:0.00,0.00 A:64838'}
G[700074]={'871[1]:0.00,0.00 A:64764'}
G[700075]={'946:82.88,27.60 A:79335'}
G[700076]={'1018:39.46,42.16 A:93027'}
G[700077]={'1018:40.15,42.84 A:95247'}
G[700078]={'1080:44.57,51.04 A:93826'}
G[700079]={'946:61.31,41.10 A:75968'}
G[700080]={'945:49.59,42.39 A:91764'}
G[700081]={'948:41.56,16.52 A:79598'}
G[700082]={'1017:81.50,61.70 A:98498'}
G[700083]={'950:43.55,38.19 A:72571'}
G[700084]={'874[2]:49.01,76.84 A:64842'}
G[700085]={'1017:45.81,68.95 A:91202'}
G[700086]={'38:76.68,41.44 A:46656'}
G[700087]={'687[1]:63.80,86.97 A:5709'}
G[700088]={'692[1]:38.90,8.01 A:1131474'}
G[700089]={'764[1]:67.46,72.17 A:47006'}
G[700090]={'764[2]:0.00,0.00 A:47006'}
G[700091]={'764[4]:57.90,41.66 A:47006'}
G[700092]={'764[4]:0.00,0.00 A:47006'}
G[700093]={'811[3]:0.00,0.00 A:77789'}
G[700094]={'922[1]:0.00,0.00 A:70752'}
G[700095]={'29:18.32,25.11 A:14387'}
G[700096]={'1024:42.64,63.37 A:95013'}
G[700097]={'1024:39.43,64.01 A:96124'}
G[700098]={'1024:42.66,9.89 A:97919'}
G[700099]={'797[1]:35.78,82.66 A:17307'}
G[700100]={'520[1]:18.89,51.44 A:26798'}
G[700101]={'811[3]:35.12,58.13 A:77789'}
G[700102]={'1024:49.57,15.96 A:98067'}
G[700103]={'520[1]:34.70,66.48 A:26723'}
G[700104]={'971:54.30,16.58 A:77733'}
G[700105]={'602:44.37,22.57 A:36658'}
G[700106]={'949:72.33,43.76 A:86260'}
G[700107]={'1080[6]:54.17,64.31 A:93826'}
G[700108]={'526[1]:50.53,16.22 A:27978'}
G[700109]={'1080[6]:73.92,75.66 A:98825'}
G[700110]={'948:31.96,25.54 A:82123'}
G[700111]={'1080:51.31,54.25 A:98825'}
G[700112]={'995[1]:0.00,0.00 A:77120'}
G[700113]={'1022:45.55,62.07 A:97558'}
G[700114]={'1080[6]:56.02,78.42 A:108017'}
G[700115]={'704[2]:0.00,0.00 A:45850'}
G[700116]={'28:32.24,94.87 A:14387'}
G[700117]={'1080:44.32,55.54 A:108017'}
G[700118]={'1033:35.31,47.36 A:98312'}
G[700119]={'721[3]:38.03,50.38 A:10299'}
G[700120]={'721[4]:0.00,0.00 A:10299'}
G[700121]={'1017:74.49,53.88 A:108030'}
G[700122]={'1024:47.37,70.29 A:99153'}
G[700123]={'521[1]:86.49,61.57 A:26527'}
G[700124]={'723[1]:0.00,0.00 A:18473'}
G[700125]={'521[1]:47.74,40.07 A:27915'}
G[700126]={'726[1]:25.99,44.01 A:17882'}
G[700127]={'521[2]:32.14,44.78 A:30997'}
G[700128]={'1017:63.47,64.67 A:1251571'}
G[700129]={'528[1]:49.88,80.30 A:27658'}
G[700130]={'1052[1]:0.00,0.00 A:113686'}
G[700131]={'811[3]:34.74,67.14 A:77789'}
G[700132]={'1024[29]:49.58,55.05 A:108069'}
G[700133]={'1024[29]:43.83,60.83 A:98957'}
G[700134]={'949:45.53,25.41 A:86577'}
G[700135]={'529[1]:0.00,0.00 A:32867'}
G[700136]={'1080:44.32,50.87 A:108434'}
G[700137]={'529[1]:0.00,0.00 A:1194555'}
G[700138]={'529[1]:0.00,0.00 A:33957'}
G[700139]={'1052[1]:57.64,44.53 A:112407'}
G[700140]={'1017:60.78,66.09 A:92764'}
G[700141]={'1052[1]:57.64,44.53 A:113686'}
G[700142]={'1052[2]:0.00,0.00 A:95240'}
G[700143]={'1052[2]:0.00,0.00 A:98613'}
G[700144]={'945:10.69,54.64 A:90482'}
G[700145]={'945:42.91,36.19 A:89936'}
G[700146]={'811[3]:33.04,63.86 A:77789'}
G[700147]={'529[2]:15.48,88.83 A:33957'}
G[700148]={'733:50.44,58.62 A:17881'}
G[700149]={'945:24.34,35.66 A:89686'}
G[700150]={'529[2]:15.59,89.47 A:1194555'}
G[700151]={'536[1]:53.87,63.04 A:31134'}
G[700152]={'1024:50.11,43.13 A:94986'}
G[700153]={'971:52.58,14.89 A:77733'}
G[700154]={'1024:45.70,39.14 A:95410'}
G[700155]={'536[1]:51.08,59.48 A:31134'}
G[700156]={'533[1]:62.45,48.58 A:55564'}
G[700157]={'522[1]:87.09,72.81 A:55658'}
G[700158]={'524[2]:42.65,53.31 A:26861'}
G[700159]={'601[1]:64.19,90.87 A:37597'}
G[700160]={'601[1]:44.02,12.64 A:38160'}
G[700161]={'604[1]:40.14,21.49 A:38316'}
G[700162]={'603[1]:44.95,76.59 A:37221'}
G[700163]={'1080:45.88,54.91 A:96084'}
G[700164]={'603[1]:41.87,62.37 A:38113'}
G[700165]={'603[1]:76.09,76.83 A:36955'}
G[700166]={'1022:60.74,42.60 A:91575'}
G[700167]={'525[1]:0.00,0.00 A:28923'}
G[700168]={'989[1]:0.00,0.00 A:76266'}
G[700169]={'525[1]:0.00,0.00 A:56027'}
G[700170]={'1024:49.22,36.59 A:95410'}
G[700171]={'945:30.36,71.91 A:90286'}
G[700172]={'1080[6]:55.62,62.37 A:108434'}
G[700173]={'950:77.62,60.49 A:79899'}
G[700174]={'1022:59.74,34.96 A:91575'}
G[700175]={'1015:47.95,8.45 A:90985'}
G[700176]={'971:48.87,59.25 A:83858'}
G[700177]={'691[1]:0.00,0.00 A:44560'}
G[700178]={'691[2]:22.26,66.78 A:6235'}
G[700179]={'1022:63.15,35.61 A:91575'}
G[700180]={'691[3]:0.00,0.00 A:44563'}
G[700181]={'686:30.34,39.11 A:7795'}
G[700182]={'1022:68.97,27.23 A:91575'}
G[700183]={'945:33.19,35.80 A:91313'}
G[700184]={'766[1]:0.00,0.00 A:15379'}
G[700185]={'760[1]:28.21,23.56 A:74367'}
G[700186]={'760[1]:37.53,71.33 A:74888'}
G[700187]={'945:37.87,71.99 A:92636'}
G[700188]={'945:28.36,73.86 A:90425'}
G[700189]={'1170:49.37,41.62 A:126899'}
G[700190]={'811[3]:51.84,66.53 A:77789'}
G[700191]={'1022:43.59,65.64 A:91948'}
G[700192]={'945:61.13,36.25 A:90517'}
G[700193]={'1022:44.05,64.88 A:97558'}
G[700194]={'734:28.91,48.14 A:18723'}
G[700195]={'798[1]:13.05,49.85 A:55007'}
G[700196]={'945:44.70,43.08 A:91721'}
G[700197]={'798[2]:60.93,24.28 A:24822'}
G[700198]={'945:43.99,43.75 A:90066'}
G[700199]={'798[2]:94.05,35.48 A:24848'}
G[700200]={'971:37.46,61.49 A:77377'}
G[700201]={'945:50.84,45.93 A:91760'}
G[700202]={'756[1]:36.35,61.09 A:47162'}
G[700203]={'756[2]:60.90,44.38 A:47739'}
G[700204]={'766[2]:59.01,68.38 A:15503'}
G[700205]={'766[1]:0.00,0.00 A:15727'}
G[700206]={'530[1]:52.89,20.39 A:55738'}
G[700207]={'524[1]:0.00,0.00 A:30871'}
G[700208]={'524[1]:0.00,0.00 A:56072'}
G[700209]={'950:50.43,70.58 A:81054'}
G[700210]={'1024:38.99,51.00 A:99481'}
G[700211]={'950:47.32,57.93 A:81216'}
G[700212]={'971:52.00,44.95 A:84524'}
G[700213]={'945:46.34,46.45 A:91721'}
G[700214]={'866:65.58,41.85 A:658'}
G[700215]={'1017:46.61,49.76 A:93166'}
G[700216]={'866:62.54,20.23 A:37087'}
G[700217]={'950:46.46,34.54 A:72571'}
G[700218]={'720:54.89,34.25 A:77789'}
G[700219]={'27:54.07,50.90 A:32639'}
G[700220]={'945:17.42,41.55 A:90312'}
G[700221]={'946[14]:36.61,46.47 A:79540'}
G[700222]={'733:56.58,70.82 A:17881'}
G[700223]={'1054[1]:50.56,70.58 A:94902'}
G[700224]={'949:56.57,45.08 A:88279'}
G[700225]={'760[1]:44.51,59.53 A:74888'}
G[700226]={'761[1]:21.33,33.07 A:4421'}
G[700227]={'1014[10]:95.38,66.46 A:109196'}
G[700228]={'945:48.27,48.48 A:91721'}
G[700229]={'946:68.94,77.54 A:79231'}
G[700230]={'749[1]:60.80,69.52 A:3674'}
G[700231]={'680[1]:33.86,80.73 A:61823'}
G[700232]={'1052[1]:0.00,0.00 A:103025'}
G[700233]={'945:57.60,59.17 A:77789'}
G[700234]={'1052[1]:0.00,0.00 A:95238'}
G[700235]={'945:39.31,38.79 A:89857'}
G[700236]={'699[4]:0.00,0.00 A:14358'}
G[700237]={'699[1]:28.35,55.54 A:14338'}
G[700238]={'1024:39.15,34.55 A:95256'}
G[700239]={'699[1]:49.17,78.19 A:14325'}
G[700240]={'699[1]:69.61,75.75 A:14326'}
G[700241]={'1024:38.47,35.36 A:93836'}
G[700242]={'699[1]:62.19,66.08 A:14322'}
G[700243]={'941[1]:28.74,45.00 A:78222'}
G[700244]={'1041[3]:52.67,83.39 A:95676'}
G[700245]={'1017:36.40,51.81 A:89829'}
G[700246]={'1015:62.78,49.72 A:109349'}
G[700247]={'976:15.87,69.44 A:77789'}
G[700248]={'976:52.99,41.26 A:79862'}
G[700249]={'976:37.72,70.49 A:79892'}
G[700250]={'976:51.68,59.47 A:88026'}
G[700251]={'1015:47.26,37.94 A:88084'}
G[700252]={'1015:60.81,59.57 A:89283'}
G[700253]={'976:51.68,59.47 A:88000'}
G[700254]={'976:18.95,65.69 A:77789'}
G[700255]={'945:14.27,56.82 A:92873'}
G[700256]={'1015:50.20,50.28 A:88873'}
G[700257]={'945:12.75,56.80 A:90482'}
G[700258]={'1011:54.10,33.84 A:81765'}
G[700259]={'1044:52.49,57.84 A:104744'}
G[700260]={'1015:47.85,52.00 A:1239120'}
G[700261]={'1015:50.02,62.48 A:90109'}
G[700262]={'945:54.89,24.03 A:92397'}
G[700263]={'1015[18]:75.38,73.33 A:90109'}
G[700264]={'1015:50.97,56.88 A:90109'}
G[700265]={'1018:56.43,53.84 A:92788'}
G[700266]={'925[1]:59.93,75.67 A:70751'}
G[700267]={'1015:53.20,45.51 A:88086'}
G[700268]={'1015:54.91,43.52 A:107447'}
G[700269]={'949:48.87,32.67 A:85124'}
G[700270]={'1015:53.63,39.83 A:88086'}
G[700271]={'1015:52.95,36.97 A:89849'}
G[700272]={'976:40.01,53.69 A:114562'}
G[700273]={'1015:52.95,36.97 A:89660'}
G[700274]={'1018[14]:60.15,19.13 A:91223'}
G[700275]={'1018:62.74,71.71 A:95599'}
G[700276]={'1015:51.01,36.54 A:89661'}
G[700277]={'1024[29]:49.05,52.49 A:108069'}
G[700278]={'1018:49.87,88.16 A:91223'}
G[700279]={'1015:51.13,36.74 A:107334'}
G[700280]={'1018:63.73,71.79 A:95726'}
G[700281]={'1024:48.01,72.96 A:108069'}
G[700282]={'1018:48.86,81.57 A:91223'}
G[700283]={'1018:42.67,58.05 A:32639'}
G[700284]={'1018:59.21,32.62 A:113646'}
G[700285]={'1018:42.35,53.42 A:92954'}
G[700286]={'1017:33.79,50.81 A:89829'}
G[700287]={'1017[9]:77.20,47.54 A:92414'}
G[700288]={'1017[9]:31.15,67.81 A:92415'}
G[700289]={'1017:28.13,59.24 A:92415'}
G[700290]={'1017:29.29,57.30 A:92415'}
G[700291]={'941:30.07,40.37 A:75186'}
G[700292]={'1024:48.29,72.32 A:108014'}
G[700293]={'941[1]:0.00,0.00 A:75177'}
G[700294]={'941:28.00,35.67 A:75177'}
G[700295]={'945:42.01,38.63 A:89777'}
G[700296]={'941[2]:0.00,0.00 A:70860'}
G[700297]={'945:41.71,38.29 A:89857'}
G[700298]={'1017:49.05,42.66 A:96129'}
G[700299]={'1022:46.38,64.80 A:97558'}
G[700300]={'941:25.37,36.54 A:81678'}
G[700301]={'321[1]:49.95,59.10 A:3216'}
G[700302]={'321[1]:53.01,64.33 A:77789'}
G[700303]={'321[1]:52.05,77.38 A:77789'}
G[700304]={'321[1]:41.43,60.83 A:77789'}
G[700305]={'301:41.27,78.84 A:114550'}
G[700306]={'321[2]:48.28,64.53 A:114561'}
G[700307]={'11:49.96,59.09 A:104900'}
G[700308]={'11:49.44,58.35 A:32641'}
G[700309]={'161:44.81,60.66 A:94589'}
G[700310]={'181:41.92,60.38 A:97843'}
G[700311]={'321[1]:53.17,74.41 A:77789'}
G[700312]={'181:40.57,56.69 A:99370'}
G[700313]={'321[2]:48.28,64.53 A:43929'}
G[700314]={'321[1]:42.93,51.86 A:114561'}
G[700315]={'1014[10]:43.49,55.98 A:77789'}
G[700316]={'1018:73.22,42.63 A:107392'}
G[700317]={'1018:73.83,38.43 A:107392'}
G[700318]={'1014[10]:44.25,37.24 A:77789'}
G[700319]={'1015:64.51,58.59 A:89283'}
G[700320]={'1024:38.91,43.67 A:97846'}
G[700321]={'1024[16]:30.26,67.70 A:97064'}
G[700322]={'1024[16]:48.07,36.16 A:97064'}
G[700323]={'1033:26.37,44.90 A:100014'}
G[700324]={'1015:36.35,51.47 A:103176'}
G[700325]={'1015:43.41,43.36 A:32639'}
G[700326]={'1033:37.67,47.78 A:101848'}
G[700327]={'1014[10]:60.92,44.73 A:77789'}
G[700328]={'1033:21.45,30.62 A:103570'}
G[700329]={'1033:36.08,47.27 A:98555'}
G[700330]={'1033:36.53,46.96 A:102600'}
G[700331]={'161[18]:42.68,39.59 A:19935'}
G[700332]={'1033:30.19,31.05 A:104224'}
G[700333]={'1033:26.18,31.32 A:103569'}
G[700334]={'1033:26.21,31.30 A:103571'}
G[700335]={'811[3]:52.72,57.02 A:77789'}
G[700336]={'733:55.32,73.47 A:17881'}
G[700337]={'1014[10]:56.73,42.51 A:77789'}
G[700338]={'1015:60.41,42.37 A:89024'}
G[700339]={'1015:55.72,44.51 A:88087'}
G[700340]={'1015:55.34,45.99 A:88086'}
G[700341]={'1015[17]:62.17,84.79 A:91459'}
G[700342]={'1015[17]:55.11,51.68 A:89849'}
G[700343]={'1015[17]:26.85,47.28 A:107334'}
G[700344]={'1015[17]:64.51,30.00 A:89660'}
G[700345]={'1015:60.18,40.03 A:89025'}
G[700346]={'1024:35.96,65.75 A:97666'}
G[700347]={'1024:59.02,65.47 A:97666'}
G[700348]={'1033:43.49,41.52 A:99789'}
G[700349]={'1033:38.91,53.81 A:98555'}
G[700350]={'1033:45.29,27.77 A:113573'}
G[700351]={'1018:63.10,67.25 A:95599'}
G[700352]={'1018:63.24,73.95 A:95599'}
G[700353]={'1033:36.32,45.07 A:98548'}
G[700354]={'950:40.00,13.09 A:83848'}
G[700355]={'1033:40.11,31.17 A:112910'}
G[700356]={'1014[10]:42.23,28.38 A:90463'} -- in 7.2 we have 1014[10]:42.68,28.48
G[700357]={'1033[38]:58.70,83.87 A:112067'}
G[700358]={'1014[10]:59.03,43.91 A:77789'}
G[700359]={'1015:49.98,41.40 A:88099'}
G[700360]={'1024:40.48,30.71 A:95310'}
G[700361]={'1033:22.37,41.00 A:105623'}
G[700362]={'1033:36.04,19.67 A:1252260'}
G[700363]={'1033:21.39,42.35 A:107126'}
G[700364]={'1033[35]:42.45,52.07 A:113571'}
G[700365]={'1033:30.07,10.35 A:101766'}
G[700366]={'1024:42.95,56.34 A:94688'}
G[700367]={'1015:46.33,10.49 A:90985'}
G[700368]={'1033:61.38,55.11 A:108870'}
G[700369]={'1033:44.93,73.59 A:108096'}
G[700370]={'1018:46.60,77.03 A:91598'}
G[700371]={'1033[32]:39.30,36.45 A:105756'}
G[700372]={'1018:46.38,84.50 A:91288'}
G[700373]={'1033[33]:45.16,56.85 A:105623'}
G[700374]={'1024:50.24,27.06 A:104328'}
G[700375]={'1033:60.69,56.55 A:108872'}
G[700376]={'1017:46.35,20.51 A:103446'}
G[700377]={'1033:30.54,33.77 A:104224'}
G[700378]={'1099:41.60,50.42 A:113355'}
G[700379]={'1033[32]:42.32,60.85 A:105554'}
G[700380]={'1033[32]:0.00,0.00 A:105756'}
G[700381]={'1017:42.02,63.56 A:91423'}
G[700382]={'1033:19.60,39.79 A:105739'}
G[700383]={'1033:33.21,79.67 A:106339'}
G[700384]={'1024:46.08,46.28 A:94386'}
G[700385]={'945:38.52,39.24 A:89777'}
G[700386]={'945:50.64,42.14 A:89754'}
G[700387]={'1033:80.31,70.48 A:99502'}
G[700388]={'1065:18.57,60.47 A:101476'}
G[700389]={'811[3]:48.57,46.04 A:77789'}
G[700390]={'971:37.29,59.90 A:77377'}
G[700391]={'971:29.06,40.02 A:91014'}
G[700392]={'1014[10]:74.45,48.19 A:77789'}
G[700393]={'1018:59.11,81.32 A:108259'}
G[700394]={'1033:61.28,57.19 A:109180'}
G[700395]={'1018:70.20,57.07 A:92326'}
G[700396]={'1014[10]:47.33,67.00 A:77789'}
G[700397]={'1024:53.40,52.39 A:101644'}
G[700398]={'945:17.45,58.10 A:92873'}
G[700399]={'1018:66.39,50.82 A:95138'}
G[700400]={'1024:24.71,56.37 A:103446'}
G[700401]={'945:41.95,36.86 A:89810'}
G[700402]={'811[3]:48.13,49.62 A:77789'}
G[700403]={'1041[3]:50.57,82.80 A:95676'}
G[700404]={'1017:61.20,93.00 A:103245'}
G[700405]={'945:27.20,30.12 A:89683'}
G[700406]={'1018:62.69,38.67 A:113646'}
G[700407]={'945:55.86,76.95 A:89746'}
G[700408]={'1014[10]:0.00,0.00 A:1246466'}
G[700409]={'1017:67.58,57.19 A:108927'}
G[700410]={'1017:39.11,67.58 A:100446'}
G[700411]={'1033:60.10,54.40 A:108875'}
G[700412]={'1099:40.35,53.01 A:113361'}
G[700413]={'1033[23]:42.38,47.14 A:99765'}
G[700414]={'1033[23]:53.45,76.59 A:99765'}
G[700415]={'1033:33.99,49.21 A:77789'}
G[700416]={'1033:47.88,82.94 A:107632'}
G[700417]={'945:26.96,32.48 A:89686'}
G[700418]={'811[3]:47.04,46.61 A:77789'}
G[700419]={'945:47.34,48.23 A:90066'}
G[700420]={'971:47.18,54.99 A:83858'}
G[700421]={'1018:54.32,81.41 A:91354'}
G[700422]={'946:44.14,43.10 A:84871'}
G[700423]={'1018:63.37,67.09 A:95726'}
G[700424]={'1033:57.18,60.76 A:107253'}
G[700425]={'971:54.45,14.13 A:85708'}
G[700426]={'1033:43.26,62.23 A:107632'}
G[700427]={'1022:45.17,67.91 A:91948'}
G[700428]={'1033:37.65,58.73 A:98555'}
G[700429]={'1024:43.70,29.55 A:95290'}
G[700430]={'1033[33]:40.89,35.06 A:105739'}
G[700431]={'1024:42.92,56.08 A:94691'}
G[700432]={'971:55.42,15.26 A:77733'}
G[700433]={'950:43.35,35.38 A:72571'}
G[700434]={'1017:60.27,54.85 A:107803'}
G[700435]={'1017:63.30,53.11 A:107803'}
G[700436]={'1018:42.47,58.74 A:91847'}
G[700437]={'1024:40.79,34.57 A:95310'}
G[700438]={'1027:70.03,77.21 A:95852'}
G[700439]={'1077:44.52,51.48 A:103778'}
G[700440]={'1018:66.82,75.66 A:109631'}
G[700441]={'1015:61.01,50.58 A:109349'}
G[700442]={'1018[14]:54.96,60.52 A:91645'}
G[700443]={'1018:61.68,73.40 A:95599'}
G[700444]={'1018[14]:60.46,17.54 A:91223'}
G[700445]={'1033:63.14,59.21 A:109180'}
G[700446]={'1017[9]:36.45,57.36 A:90903'}
G[700447]={'1017[9]:69.41,55.60 A:92415'}
G[700448]={'1017[9]:72.78,52.35 A:92415'}
G[700449]={'1024:41.03,45.54 A:97094'}
G[700450]={'1017:50.47,31.55 A:107469'}
G[700451]={'1041[3]:51.11,88.04 A:95676'}
G[700452]={'1024:43.47,10.88 A:97933'}
G[700453]={'1017:53.85,29.89 A:107469'}
G[700454]={'1041[2]:0.00,0.00 A:95676'}
G[700455]={'1017:44.19,29.64 A:99223'}
G[700456]={'1024:51.86,42.38 A:94986'}
G[700457]={'1017:44.60,65.58 A:108526'}
G[700458]={'1015:39.96,48.46 A:103176'}
G[700459]={'1017:81.46,51.45 A:98498'}
G[700460]={'1015:53.43,30.67 A:90313'}
G[700461]={'1077:32.55,53.93 A:101195'}
G[700462]={'1033:31.31,23.47 A:101783'}
G[700463]={'1015:67.73,27.17 A:92450'}
G[700464]={'1033:35.85,55.63 A:98555'}
G[700465]={'1015:48.89,35.19 A:88084'}
G[700466]={'1017:33.15,36.18 A:91458'}
G[700467]={'1024:42.25,27.32 A:95310'}
G[700468]={'1024:40.80,34.47 A:95270'}
G[700469]={'1024[8]:39.71,82.58 A:96286'}
G[700470]={'1024:44.13,32.08 A:95290'}
G[700471]={'1024:49.30,24.18 A:95290'}
G[700472]={'1024:43.96,23.19 A:95392'}
G[700473]={'1024:47.64,32.66 A:96410'}
G[700474]={'1024:44.80,23.84 A:95799'}
G[700475]={'1024[31]:55.96,77.89 A:95753'}
G[700476]={'1017:43.02,44.88 A:96229'}
G[700477]={'1077:52.49,42.51 A:113686'}
G[700478]={'1015:53.08,64.42 A:89051'}
G[700479]={'1033:35.07,51.45 A:111197'}
G[700480]={'1033:81.04,61.12 A:100998'}
G[700481]={'1045[2]:0.00,0.00 A:1258979'}
G[700482]={'1018:56.96,36.97 A:111981'}
G[700483]={'1033[33]:53.70,39.75 A:105756'}
G[700484]={'1018:36.92,58.34 A:102546'}
G[700485]={'1018[13]:31.24,65.73 A:94974'}
G[700486]={'1018[13]:23.91,41.86 A:93027'}
G[700487]={'1015:65.19,56.52 A:89284'}
G[700488]={'1033[33]:0.00,0.00 A:105756'}
G[700489]={'1017:46.56,45.52 A:96129'}
G[700490]={'1017:39.60,65.02 A:100446'}
G[700491]={'1048:43.27,50.21 A:98008'}
G[700492]={'1033:40.35,79.74 A:110949'}
G[700493]={'1017:43.75,68.54 A:91486'}
G[700494]={'1017:43.78,68.21 A:91204'}
G[700495]={'1080:47.44,52.12 A:93826'}
G[700496]={'1017:45.00,69.51 A:100446'}
G[700497]={'1024:37.88,61.92 A:99406'}
G[700498]={'1017:49.12,59.93 A:97091'}
G[700499]={'1018:22.76,67.02 A:111459'}
G[700500]={'1018:66.45,38.60 A:97337'}
G[700501]={'1018:22.10,65.53 A:111460'}
G[700502]={'1048:31.66,54.75 A:98008'}
G[700503]={'1015:60.98,23.08 A:91308'}
G[700504]={'1048:39.74,56.38 A:98008'}
G[700505]={'1014[10]:0.00,0.00 A:1246465'}
G[700506]={'1024:37.34,58.19 A:95916'}
G[700507]={'1033:29.42,53.38 A:98555'}
G[700508]={'928:34.63,89.51 A:67992'}
G[700509]={'1033[32]:27.92,52.46 A:105756'}
G[700510]={'1015:46.06,14.40 A:106297'}
G[700511]={'1033:22.49,37.71 A:113102'}
G[700512]={'1033:27.62,73.50 A:98969'}
G[700513]={'1015:38.83,45.00 A:103176'}
G[700514]={'1033:30.36,39.89 A:113195'}
G[700515]={'1033:52.75,31.40 A:101581'}
G[700516]={'1033:32.02,78.46 A:108314'}
G[700517]={'1048:31.75,61.46 A:98008'}
G[700518]={'1024:37.67,59.53 A:95866'}
G[700519]={'1017:67.75,43.22 A:108927'}
G[700520]={'1024[20]:47.33,54.56 A:95916'}
G[700521]={'1033:51.90,34.91 A:101825'}
G[700522]={'1024[21]:44.46,27.65 A:95881'}
G[700523]={'1024:39.28,70.49 A:102274'}
G[700524]={'1033:31.94,17.45 A:101783'}
G[700525]={'1033:59.75,34.25 A:101825'}
G[700526]={'1048:41.85,47.71 A:98008'}
G[700527]={'1080[6]:55.41,63.33 A:93826'}
G[700528]={'1024:53.03,39.48 A:94983'}
G[700529]={'1018[15]:0.00,0.00 A:91223'}
G[700530]={'1018:52.72,80.03 A:91474'}
G[700531]={'1033:30.62,13.47 A:102242'}
G[700532]={'1033:27.33,86.46 A:101878'}
G[700533]={'1018:62.46,36.62 A:112052'}
G[700534]={'1018:46.47,86.32 A:91288'}
G[700535]={'1048:30.33,39.95 A:98008'}
G[700536]={'1033:15.24,52.35 A:107302'}
G[700537]={'1033:37.84,75.30 A:99584'}
G[700538]={'1017:39.91,31.31 A:111206'}
G[700539]={'1017:60.72,42.43 A:105502'}
G[700540]={'1017:37.08,66.93 A:106568'}
G[700541]={'1017:57.98,63.47 A:94856'}
G[700542]={'1033:34.42,53.56 A:98555'}
G[700543]={'811[3]:47.94,40.40 A:77789'}
G[700544]={'971:47.38,34.90 A:77377'}
G[700545]={'971:31.25,33.33 A:81492'}
G[700546]={'1018:54.03,87.84 A:91354'}
G[700547]={'1024:53.00,35.71 A:95266'}
G[700548]={'1018[14]:61.75,59.91 A:91645'}
G[700549]={'1033:25.67,58.64 A:101878'}
G[700550]={'1024:46.58,31.07 A:96410'}
G[700551]={'1022:43.92,63.73 A:91948'}
G[700552]={'1024:50.12,39.76 A:94983'}
G[700553]={'1024:39.45,14.21 A:108529'}
G[700554]={'1033:30.44,66.08 A:101878'}
G[700555]={'1017:71.23,89.49 A:102170'}
G[700556]={'1080[6]:49.99,45.14 A:108017'}
G[700557]={'1024:56.26,60.04 A:96590'}
G[700558]={'1017:54.21,66.27 A:111291'}
G[700559]={'1024:48.70,82.32 A:98957'}
G[700560]={'1024:51.75,62.83 A:108185'}
G[700561]={'1024[29]:48.11,78.70 A:98957'}
G[700562]={'1080[6]:54.82,64.04 A:108434'}
G[700563]={'1033:56.07,51.90 A:108872'}
G[700564]={'1017:63.55,64.59 A:94856'}
G[700565]={'1033:29.71,88.00 A:101878'}
G[700566]={'1018:52.75,83.05 A:91474'}
G[700567]={'1018:53.74,55.94 A:92697'}
G[700568]={'1033:34.24,73.93 A:103437'}
G[700569]={'1033:17.41,37.95 A:107126'}
G[700570]={'1018:63.70,47.31 A:93205'}
G[700571]={'1033:35.83,70.76 A:103437'}
G[700572]={'1018:62.46,36.94 A:93111'}
G[700573]={'1018:59.84,55.14 A:93157'}
G[700574]={'1077:39.21,32.68 A:106442'}
G[700575]={'1018[13]:43.26,80.92 A:92850'}
G[700576]={'1018:44.24,51.97 A:92965'}
G[700577]={'1021[2]:49.20,51.21 A:93568'}
G[700578]={'691[2]:68.16,62.43 A:6391'}
G[700579]={'691[2]:24.88,67.08 A:6235'}
G[700580]={'1017:41.81,43.05 A:96254'}
G[700581]={'1021[1]:0.00,0.00 A:93437'}
G[700582]={'43:71.25,74.08 A:12676'}
G[700583]={'1021:98.49,57.22 A:77789'}
G[700584]={'605:62.85,77.69 A:34872'}
G[700585]={'544[1]:41.94,24.38 A:35837'}
G[700586]={'756[1]:41.01,60.08 A:47162'}
G[700587]={'1014[10]:38.97,30.11 A:77789'}
G[700588]={'766[2]:59.31,68.05 A:15502'}
G[700589]={'462:34.23,58.55 A:15968'}
G[700590]={'4:40.75,17.64 A:77789'}
G[700591]={'1014[10]:58.23,45.23 A:98519'}
G[700592]={'1028:33.30,70.56 A:93112'}
G[700593]={'1017:44.88,36.99 A:107258'}
G[700594]={'766[1]:0.00,0.00 A:15378'}
G[700595]={'4:40.27,17.09 A:24499'}
G[700596]={'749[1]:16.41,46.45 A:3653'}
G[700597]={'764[1]:28.28,67.59 A:4278'}
G[700598]={'1028:42.19,49.05 A:96400'}
G[700599]={'1028:41.40,40.86 A:93115'}
G[700600]={'680[1]:32.80,78.34 A:61716'}
G[700601]={'1028:56.15,43.43 A:93716'}
G[700602]={'1021[1]:57.70,59.57 A:109788'}
G[700603]={'680[1]:31.92,76.47 A:61724'}
G[700604]={'1028[1]:55.13,58.21 A:96441'}
G[700605]={'688[1]:10.90,37.95 A:74476'}
G[700606]={'1028:78.71,50.47 A:96277'}
G[700607]={'1028:82.05,50.48 A:96277'}
G[700608]={'1028:68.43,52.62 A:99759'}
G[700609]={'1017:45.12,63.86 A:100446'}
G[700610]={'1028:76.25,39.09 A:96277'}
G[700611]={'1032[1]:46.47,33.64 A:92782'}
G[700612]={'1028:68.07,23.79 A:96278'}
G[700613]={'1032[2]:41.59,32.81 A:96682'}
G[700614]={'1032[2]:44.62,55.63 A:92782'}
G[700615]={'1032[1]:66.19,41.22 A:92782'}
G[700616]={'1032[2]:46.83,56.15 A:97225'}
G[700617]={'1032[2]:45.90,49.87 A:92782'}
G[700618]={'1017:32.78,27.89 A:91569'}
G[700619]={'756[1]:28.75,26.22 A:46906'}
G[700620]={'1032[3]:83.70,82.67 A:96666'}
G[700621]={'1017:37.95,21.59 A:91158'}
G[700622]={'756[1]:28.75,26.22 A:46889'}
G[700623]={'1032[3]:85.72,84.04 A:97978'}
G[700624]={'894:51.75,43.35 A:16502'}
G[700625]={'756[1]:29.47,25.42 A:46902'}
G[700626]={'4:58.63,48.28 A:39270'}
G[700627]={'462:33.27,60.71 A:15968'}
G[700628]={'756[1]:38.65,60.91 A:47162'}
G[700629]={'756[2]:58.07,39.65 A:46906'}
G[700630]={'1017:44.09,18.14 A:91158'}
G[700631]={'4:41.52,17.72 A:27216'}
G[700632]={'756[2]:59.19,38.03 A:46902'}
G[700633]={'764[1]:67.63,72.06 A:47293'}
G[700634]={'766[3]:54.24,61.20 A:15727'}
G[700635]={'1028:32.64,69.22 A:93115'}
G[700636]={'756[2]:63.27,39.93 A:46889'}
G[700637]={'1017:44.28,17.68 A:107840'}
G[700638]={'764[2]:29.96,72.03 A:3887'}
G[700639]={'764[4]:59.23,43.52 A:47293'}
G[700640]={'688[1]:48.27,12.13 A:74409'}
G[700641]={'1017:44.31,22.79 A:111206'}
G[700642]={'11:27.63,31.45 A:3278'}
G[700643]={'1017:39.61,32.85 A:111206'}
G[700644]={'871[2]:38.90,15.89 A:64738'}
G[700645]={'874[2]:49.14,70.07 A:64841'}
G[700646]={'691[1]:75.98,62.99 A:7361'}
G[700647]={'691[1]:0.00,0.00 A:1175085'}
G[700648]={'691[2]:63.28,67.61 A:6391'}
G[700649]={'1017:46.52,44.45 A:35642'}
G[700650]={'1017:33.96,54.24 A:90899'}
G[700651]={'1017[9]:26.74,67.18 A:92415'}
G[700652]={'1014[10]:68.29,45.37 A:101527'}
G[700653]={'1041[3]:52.12,81.11 A:95676'}
G[700654]={'1017:45.72,70.81 A:91202'}
G[700655]={'1017:66.70,62.32 A:98955'}
G[700656]={'1017:41.42,66.66 A:91202'}
G[700657]={'1022:62.24,43.39 A:93377'}
G[700658]={'1077:57.38,46.85 A:107026'}
G[700659]={'1022:45.40,62.94 A:91948'}
G[700660]={'1033:26.32,41.30 A:35642'}
G[700661]={'1022:44.58,56.39 A:97558'}
G[700662]={'1017:68.01,47.98 A:108940'}
G[700663]={'1014[10]:40.24,29.08 A:93538'}
G[700664]={'1017:69.08,46.14 A:108940'}
G[700665]={'1048:36.59,60.54 A:98008'}
G[700666]={'1048:41.35,55.69 A:98008'}
G[700667]={'1024[20]:47.99,40.56 A:95916'}
G[700668]={'1024[5]:50.74,38.29 A:98653'}
G[700669]={'1015:54.28,36.64 A:110915 N:110915'}
G[700670]={'1033:38.37,23.87 A:110915 N:110915'}
G[700671]={'1033:28.72,80.23 A:99584'}
G[700672]={'1033:28.26,18.76 A:101783'}
G[700673]={'1033:38.20,90.09 A:103482'}
G[700674]={'1033:28.53,82.69 A:99584'}
G[700675]={'1033[32]:35.68,59.86 A:105554'}
G[700676]={'1018:54.50,71.91 A:112289'}
G[700677]={'1018:44.29,76.31 A:91122'}
G[700678]={'1014[10]:40.36,24.09 A:93538'}
G[700679]={'1096:0.00,0.00 A:99343'}
G[700680]={'1096:0.00,0.00 A:97644'}
G[700681]={'1096:0.00,0.00 A:108069'}
G[700682]={'1096:0.00,0.00 A:96666'}
G[700683]={'1096:0.00,0.00 A:115264'}
G[700684]={'1096:0.00,0.00 A:97978'}
G[700685]={'1024:40.83,32.81 A:95270'}
G[700686]={'1096:0.00,0.00 A:97296'}
G[700687]={'1096:0.00,0.00 A:99247'}
G[700688]={'1096:0.00,0.00 A:96286'}
G[700689]={'1096:0.00,0.00 A:102585'}
G[700690]={'1096:0.00,0.00 A:93826'}
G[700691]={'1096:0.00,0.00 A:100973'}
G[700692]={'1096:0.00,0.00 A:101004'}
G[700693]={'1024[29]:42.09,33.10 A:108014'}
G[700694]={'1096:0.00,0.00 A:96675'}
G[700695]={'1096:0.00,0.00 A:111109'}
G[700696]={'1018:38.88,81.68 A:103482'}
G[700697]={'1096:0.00,0.00 A:96453'}
G[700698]={'1077:60.14,52.10 A:113857'}
G[700699]={'1080:40.69,47.19 A:106902'}
G[700700]={'1024:34.43,23.14 A:115669'}
G[700701]={'1014[10]:57.87,58.63 A:77789'}
G[700702]={'1024:49.98,25.84 A:96410'}
G[700703]={'1024:27.31,44.85 A:101700'}
G[700704]={'1033[33]:57.69,42.31 A:105756'}
G[700705]={'1024:53.19,70.04 A:93846'}
G[700706]={'1015:39.16,38.74 A:103484'}
G[700707]={'1096:0.00,0.00 A:108434'}
G[700708]={'1096:0.00,0.00 A:93846'}
G[700709]={'1024:50.66,42.42 A:94983'}
G[700710]={'1017:72.36,61.03 A:94337'}
G[700711]={'1017:61.23,69.43 A:92764'}
G[700712]={'1077:47.12,50.08 A:77789'}
G[700713]={'1024:46.58,46.12 A:94152'}
G[700714]={'1024:52.02,54.37 A:102468'}
G[700715]={'1077:52.76,51.70 A:77789'}
G[700716]={'1018:68.60,38.22 A:97337'}
G[700717]={'1033[33]:48.90,43.44 A:107126'}
G[700718]={'1014[10]:38.11,32.20 A:77789'}
G[700719]={'1033[33]:49.96,42.65 A:105623'}
G[700720]={'1096:0.00,0.00 A:102600'}
G[700721]={'1033[32]:35.22,54.33 A:108101'}
G[700722]={'1033:36.88,46.61 A:97140'}
G[700723]={'1033:44.90,73.47 A:106032'}
G[700724]={'1033:22.71,36.10 A:35642'}
G[700725]={'1033[33]:34.94,64.62 A:105756'}
G[700726]={'1014[10]:45.51,59.07 A:101527'}
G[700727]={'1033:26.14,31.32 A:103568'}
G[700728]={'1033:28.69,33.03 A:104224'}
G[700729]={'1033:31.02,28.60 A:103527'}
G[700730]={'1033:45.71,35.52 A:98979'}
G[700731]={'1033:44.51,26.23 A:113573'}
G[700732]={'1014[10]:45.21,57.27 A:77789'}
G[700733]={'1024:55.76,56.45 A:97957'}
G[700734]={'1015:35.05,6.68 A:115675'}
G[700735]={'1033[23]:53.60,36.77 A:1252107'}
G[700736]={'1024:55.19,56.07 A:98273'}
G[700737]={'1033:29.40,62.55 A:101868'}
G[700738]={'1033[38]:48.59,48.28 A:1252261'}
G[700739]={'1033:78.57,56.41 A:103575'}
G[700740]={'1033[38]:48.62,49.55 A:112067'}
G[700741]={'1033[38]:48.59,44.85 A:112067'}
G[700742]={'1033:74.49,56.68 A:103575'}
G[700743]={'1033:31.46,23.13 A:101784'}
G[700744]={'1033:29.51,15.24 A:102242'}
G[700745]={'1033:50.57,78.25 A:109409'}
G[700746]={'1033[33]:68.32,51.13 A:105756'}
G[700747]={'1033:24.08,19.13 A:112067'}
G[700748]={'1033:21.15,48.48 A:105486'}
G[700749]={'1033:19.41,41.97 A:105756'}
G[700750]={'1033:31.49,50.05 A:115561'}
G[700751]={'1017:50.13,58.31 A:107755'}
G[700752]={'1017:64.07,51.76 A:93066'}
G[700753]={'1033:60.19,43.69 A:100778'}
G[700754]={'1018:38.24,62.87 A:94046'}
G[700755]={'1018:67.02,44.24 A:94485'}
G[700756]={'1015:52.34,28.62 A:90313'}
G[700757]={'1033[35]:44.42,70.41 A:103482'}
G[700758]={'1033:61.76,44.46 A:100778'}
G[700759]={'1015:34.96,33.80 A:107628'}
G[700760]={'1033:58.14,40.77 A:103482'}
G[700761]={'1014[10]:51.74,38.19 A:77789'}
G[700762]={'1033:30.17,35.49 A:104224'}
G[700763]={'1033:24.30,45.61 A:100014'}
G[700764]={'1033:31.82,46.79 A:110904'}
G[700765]={'1014[10]:53.87,39.67 A:77789'}
G[700766]={'1033:49.11,71.02 A:109409'}
G[700767]={'1033:49.77,36.93 A:110903'}
G[700768]={'1033:59.80,47.63 A:104404'}
G[700769]={'1033:36.06,82.29 A:99762'}
G[700770]={'1041[3]:0.00,0.00 A:1251991'}
G[700771]={'1033:46.65,70.66 A:106032'}
G[700772]={'1033[33]:56.34,58.51 A:105756'}
G[700773]={'1014[12]:49.45,62.52 A:1251992'}
G[700774]={'1033:35.78,78.93 A:99762'}
G[700775]={'1033:25.02,44.10 A:105632'}
G[700776]={'1080:41.26,49.37 A:104615'}
G[700777]={'1018:57.22,57.52 A:92788'}
G[700778]={'1080:42.04,46.28 A:104615'}
G[700779]={'1065:0.00,0.00 A:1250548'}
G[700780]={'1014[12]:40.98,52.30 A:1246463'}
G[700781]={'1017:46.40,56.26 A:97091'}
G[700782]={'1046[1]:0.00,0.00 A:106780'}
G[700783]={'1077:52.42,50.33 A:103832'}
G[700784]={'1033:51.20,83.56 A:109409'}
G[700785]={'1017:57.68,49.85 A:116010'}
G[700786]={'1017:40.61,69.06 A:91423'}
G[700787]={'1015:47.04,53.58 A:116010'}
G[700788]={'1018:52.10,56.68 A:116010'}
G[700789]={'1018:58.00,89.31 A:110904'}
G[700790]={'1033:39.52,51.17 A:101848'}
G[700791]={'1033:51.16,80.09 A:109409'}
G[700792]={'1033[23]:52.14,70.75 A:99762'}
G[700793]={'1018:55.98,57.71 A:110903'}
G[700794]={'1033:34.84,81.26 A:99762'}
G[700795]={'1033:34.66,76.77 A:116084'}
G[700796]={'1033:23.19,44.54 A:105756'}
G[700797]={'1033:22.34,36.90 A:105623'}
G[700798]={'1033:28.58,80.50 A:101878'}
G[700799]={'1033:20.38,44.79 A:105756'}
G[700800]={'1033:36.47,46.61 A:107598'}
G[700801]={'1033:52.10,79.16 A:114948'}
G[700802]={'1033:36.35,45.45 A:111903'}
G[700803]={'1033:27.06,70.17 A:103484'}
G[700804]={'1033:33.34,68.43 A:99762'}
G[700805]={'1033[35]:58.72,17.22 A:103484'}
G[700806]={'1033:52.09,79.19 A:115248'}
G[700807]={'1033:75.89,50.14 A:103787'}
G[700808]={'1033:52.19,80.47 A:114474'}
G[700809]={'1014[10]:41.25,42.96 A:77789'}
G[700810]={'1033[23]:40.48,48.35 A:99762'}
G[700811]={'1033:44.22,53.89 A:116050'}
G[700812]={'1033:47.89,75.73 A:113457'}
G[700813]={'1033:54.89,72.87 A:115039'}
G[700814]={'1033:40.54,53.09 A:114909'}
G[700815]={'1033:40.54,53.09 A:114908'}
G[700816]={'1033:59.11,42.31 A:100778'}
G[700817]={'1033:55.30,44.92 A:112370'}
G[700818]={'1017:67.99,39.99 A:105436'}
G[700819]={'1018:54.98,53.57 A:110903'}
G[700820]={'1033:41.22,21.40 A:115906'}
G[700821]={'1017:43.27,44.03 A:100435'}
G[700822]={'1080:40.45,50.01 A:106902'}
G[700823]={'1017:42.50,48.68 A:100435'}
G[700824]={'1015:36.85,6.70 A:115675'}
G[700825]={'1018:32.22,56.56 A:111383'}
G[700826]={'1024:44.55,8.56 A:97919'}
G[700827]={'1024:55.48,85.67 A:116010'}
G[700828]={'1017:49.81,57.73 A:97091'}
G[700829]={'1024:35.72,22.22 A:115665'}
G[700830]={'1024:35.05,22.01 A:115677'}
G[700831]={'1018:68.03,71.33 A:109045'}
G[700832]={'1033:62.47,55.98 A:109023'}
G[700833]={'1024:23.87,42.65 A:101700'}
G[700834]={'1038:32.45,48.54 A:98757'}
G[700835]={'1080:40.66,53.34 A:106902'}
G[700836]={'1017:71.67,42.51 A:108940'}
G[700837]={'4:58.43,43.54 A:39270'}
G[700838]={'1015:46.16,44.53 A:110903'}
G[700839]={'1024:35.50,36.74 A:115906'}
G[700840]={'1024:43.29,71.33 A:95937'}
G[700841]={'1018:67.46,38.70 A:97338'}
G[700842]={'1033:21.57,42.54 A:105756'}
G[700843]={'1024:30.06,27.67 A:101794'}
G[700844]={'1014[10]:59.02,47.14 A:101527'}
G[700845]={'1033[33]:36.20,32.40 A:114793'}
G[700846]={'1033:48.26,34.46 A:110903'}
G[700847]={'1024:54.92,54.28 A:97957'}
G[700848]={'1018:60.26,35.41 A:113646'}
G[700849]={'1024:44.44,7.99 A:97920'}
G[700850]={'602:0.00,0.00 A:36658'}
G[700851]={'524[2]:0.00,0.00 A:30871'}
G[700852]={'1015:45.55,14.93 A:90379'}
G[700853]={'1015:46.15,17.12 A:106297'}
G[700854]={'1018:67.81,32.70 A:106419'}
G[700855]={'1017:41.99,67.23 A:91204'}
G[700856]={'1018:42.41,58.62 A:101527'}
G[700857]={'1014[10]:45.36,69.95 A:101527'}
G[700858]={'486:34.40,25.20 A:52835'}
G[700859]={'803[1]:0.00,0.00 A:53567'}
G[700860]={'1018:61.74,87.73 A:103484'}
G[700861]={'1015:35.96,8.73 A:115666'}
G[700862]={'1017:48.68,46.02 A:96129'}
G[700863]={'1017:47.61,36.21 A:107258'}
G[700864]={'947:32.43,25.31 A:77789'}
G[700865]={'1018:56.29,53.46 A:92789'}
G[700866]={'1017:50.74,61.43 A:107674'}
G[700867]={'1024:49.73,40.88 A:97999'}
G[700868]={'1024[16]:30.66,64.95 A:97661'}
G[700869]={'1014[4]:0.00,0.00 A:32725'}
G[700870]={'1024[16]:48.12,39.72 A:97103'}
G[700871]={'1024:49.06,13.75 A:98194'}
G[700872]={'1024:46.76,48.32 A:94153'}
G[700873]={'811[3]:57.97,49.91 A:43929'}
G[700874]={'1015:63.12,29.92 A:110904'}
G[700875]={'1080:52.02,49.26 A:104624'}
G[700876]={'1015:66.75,44.88 A:110903'}
G[700877]={'1018:59.04,82.41 A:108675'}
G[700878]={'1080:49.56,61.95 A:104615'}
G[700879]={'1067:0.00,0.00 A:99192'}
G[700880]={'1017:34.13,45.67 A:103786'}
G[700881]={'1050:64.69,49.96 A:103485'}
G[700882]={'1080:64.69,49.96 A:103485'}
G[700883]={'1017:62.25,93.48 A:104289'}
G[700884]={'1017:60.35,51.17 A:101527'}
G[700885]={'1018:42.87,75.60 A:91122'}
G[700886]={'1080:39.49,45.24 A:106902'}
G[700887]={'1024:40.55,65.43 A:94687'}
G[700888]={'1024:37.46,64.30 A:96083'}
G[700889]={'1014[12]:46.28,55.73 A:90417'}
G[700890]={'1077:31.08,4.74 A:106299'}
G[700891]={'Near1018 A:118954'}
G[700892]={'1018:39.03,51.35 A:118954'}
G[700893]={'1018:39.21,61.81 A:118954'}
G[700894]={'465:85.30,50.12 A:116880'}
G[700895]={'1014[10]:57.26,44.06 A:101527'}
G[700896]={'1065:0.00,0.00 A:101476'}
G[700897]={'1094[2]:0.00,0.00 A:106482'}
G[700898]={'1014[10]:58.42,45.26 A:101527'}
G[700899]={'1021:52.16,54.95 A:118390'}
G[700900]={'1014[12]:57.95,72.70 A:116714'}
G[700901]={'1017:45.12,37.00 A:99223'}
G[700902]={'1021:56.46,27.34 A:116175'}
G[700903]={'1021:59.79,27.44 A:116308'}
G[700904]={'1017:77.46,80.20 A:115678'}
G[700905]={'1014[10]:46.92,39.16 A:116175'}
G[700906]={'1021:59.79,27.44 A:116175'}
G[700907]={'1077:45.35,40.53 A:101527'}
G[700908]={'241:69.42,47.99 A:120041'}
G[700909]={'1021:31.39,32.51 A:120084'}
G[700910]={'606:39.86,43.98 A:119982'}
G[700911]={'1018:53.85,83.01 A:91354'}
G[700912]={'1021:54.65,48.27 A:119139'}
G[700913]={'1018:69.35,34.13 A:106419'}
G[700914]={'1048:37.86,37.73 A:101527'}
G[700915]={'1021:74.90,26.12 A:117413'}
G[700916]={'1077:52.59,46.82 A:101527'}
G[700917]={'1021:52.63,47.10 A:117086'}
G[700918]={'1021:52.21,64.85 A:120932'}
G[700919]={'1021:78.64,40.60 A:115866'}
G[700920]={'1021:52.24,69.57 A:120932'}
G[700921]={'1021:42.80,77.69 A:118255'}
G[700922]={'1018:39.47,89.29 A:102166'}
G[700923]={'1018:56.36,44.42 A:93157'}
G[700924]={'1021:43.52,41.39 A:117094'}
G[700925]={'1021:50.24,44.07 A:118657'}
G[700926]={'1021:79.16,37.76 A:117593'}
G[700927]={'1021:52.39,46.57 A:118657'}
G[700928]={'1021:40.75,53.55 A:119015'}
G[700929]={'1021:59.30,27.93 A:118776'}
G[700930]={'1017:72.90,46.94 A:93066'}
G[700931]={'1015:28.63,45.94 A:107135'}
G[700932]={'1017:78.69,61.17 A:98501'}
G[700933]={'1017:78.69,61.17 A:98498'}
G[700934]={'1021:66.93,42.18 A:121034'}
G[700935]={'1018:56.27,78.50 A:115008'}
G[700936]={'922[1]:0.00,0.00 A:68526'}
G[700937]={'1021:41.33,80.89 A:118255'}
G[700938]={'1021:45.04,52.30 A:119886'}
G[700939]={'1021:41.20,16.69 A:121107'}
G[700940]={'1021:65.15,28.69 A:118422'}
G[700941]={'1021:58.82,45.42 A:117093'}
G[700942]={'1015:58.30,43.83 A:91756'}
G[700943]={'1021:48.21,40.96 A:118657'}
G[700944]={'1021:29.22,60.74 A:120745'}
G[700945]={'1021:81.46,48.20 A:115866'}
G[700946]={'1015:55.61,43.29 A:88086'}
G[700947]={'1015:61.51,58.35 A:89053'}
G[700948]={'1077:53.45,49.20 A:101527'}
G[700949]={'1021:58.85,32.54 A:117095'}
G[700950]={'1033:25.64,61.35 A:106339'}
G[700951]={'1021:55.54,27.06 A:117141'}
G[700952]={'1015:56.56,65.74 A:117735'}
G[700953]={'1017:35.79,70.33 A:110904'}
G[700954]={'1024:51.23,49.71 A:104302'}
G[700955]={'1017:29.43,50.03 A:90903'}
G[700956]={'1017:38.02,32.76 A:110903'}
G[700957]={'1017:35.81,70.15 A:110903'}
G[700958]={'1021:48.25,68.97 A:115054'}
G[700959]={'1021:74.90,27.10 A:120945'}
G[700960]={'1033:33.25,76.77 A:108314'}
G[700961]={'1021:57.60,28.02 A:118787'}
G[700962]={'1021:46.22,50.51 A:119173'}
G[700963]={'1021:49.81,78.58 A:118223'}
G[700964]={'1021:59.44,27.13 A:118787'}
G[700965]={'1021:40.97,80.81 A:118993'}
G[700966]={'1021:48.36,70.89 A:115054'}
G[700967]={'1021:68.29,30.50 A:118499'}
G[700968]={'1021:29.40,63.03 A:120745'}
G[700969]={'1021:45.67,38.75 A:118846'}
G[700970]={'1021:30.05,66.25 A:118786'}
G[700971]={'1021:45.67,38.75 A:118851'}
G[700972]={'1077:40.58,26.48 A:111737'}
G[700973]={'1021:42.58,42.46 A:118841'}
G[700974]={'1021:53.70,57.45 A:32639'}
G[700975]={'1021:68.88,28.64 A:118499'}
G[700976]={'1177[2]:0.00,0.00 A:122663'}
G[700977]={'1021:42.94,18.05 A:118943'}
G[700978]={'1021:41.88,34.13 A:111469'}
G[700979]={'1077:54.70,54.96 A:101527'}
G[700980]={'1177[1]:56.50,66.08 A:122663'}
G[700981]={'1021:42.62,66.73 A:115620'}
G[700982]={'1021:31.27,56.35 A:120745'}
G[700983]={'1021:28.14,56.46 A:120745'}
G[700984]={'1021:43.15,79.43 A:118255'}
G[700985]={'1018:43.46,60.53 A:92620'}
G[700986]={'1018:38.15,60.38 A:91847'}
G[700987]={'1015:64.84,27.14 A:32639'}
G[700988]={'1033:33.80,74.31 A:116084'}
G[700989]={'1015:55.48,44.96 A:91459'}
G[700990]={'1033:43.23,29.87 A:110916'}
G[700991]={'1033:33.73,76.10 A:99581'}
G[700992]={'1033:41.17,18.39 A:111826'}
G[700993]={'1033:32.84,66.55 A:106339'}
G[700994]={'1017:48.74,79.00 A:91566'}
G[700995]={'1021:78.62,41.28 A:117955'}
G[700996]={'1017:61.79,90.84 A:103446'}
G[700997]={'1033:43.45,29.43 A:32639'}
G[700998]={'1021:38.81,80.59 A:118255'}
G[700999]={'1021:52.45,42.83 A:116961'}
G[701000]={'1021:82.83,52.61 A:115866'}
G[701001]={'1021:28.89,56.95 A:118786'}
G[701002]={'1021:53.79,67.19 A:120932'}
G[701003]={'1021:51.66,75.26 A:118223'}
G[701004]={'1021:81.17,30.66 A:32639'}
G[701005]={'1015:57.13,73.13 A:115906'}
G[701006]={'1174[1]:35.28,45.84 A:120977'}
G[701007]={'1135:56.75,67.67 A:121345'}
G[701008]={'1135[1]:40.17,23.59 A:120977'}
G[701009]={'1135:37.38,53.55 A:122621'}
G[701010]={'1135[1]:48.86,44.15 A:122378'}
G[701011]={'1171[5]:32.71,55.51 A:121263'}	-- in Vindicaar above Antoran Wastes
G[701012]={'1135:36.33,56.92 A:122621'}
G[701013]={'1135:56.97,65.68 A:124595'}
G[701014]={'1135[2]:0.00,0.00 A:126307'}
G[701015]={'1135[2]:0.00,0.00 A:122378'}
G[701016]={'1170:54.50,77.91 A:120533'}
G[701017]={'1170:63.28,39.73 A:123413'}
G[701018]={'1170:52.87,75.86 A:120533'}
G[701019]={'1170[4]:0.00,0.00 A:120533'}
G[701020]={'1177[1]:47.84,49.31 A:122663'}
G[701021]={'1021:82.88,52.49 A:32639'}
G[701022]={'1024:43.70,75.50 A:96072'}
G[701023]={'1024:26.77,43.68 A:101832'}
G[701024]={'1177[1]:63.92,72.39 A:122663'}
G[701025]={'1015:46.20,51.08 A:110903'}
G[701026]={'1033:50.13,79.70 A:114472'}
G[701027]={'1021:55.55,30.04 A:118776'}
G[701028]={'1018:49.92,7.57 A:115664'}
G[701029]={'1088[1]:0.00,0.00 A:110791'}
G[701030]={'1021:44.40,62.68 A:101527'}
G[701031]={'1171:72.90,50.23 A:126954'}
G[701032]={'1033:28.04,84.94 A:101878'}
G[701033]={'1041[1]:0.00,0.00 A:1251991'}
G[701034]={'1033:27.26,65.73 A:99581'}
G[701035]={'1044:51.75,48.47 A:113686'}
G[701036]={'1024:42.22,27.27 A:32638'}
G[701037]={'1014[10]:68.39,43.04 A:77789'}
G[701038]={'1024:44.81,24.87 A:95753'}
G[701039]={'1044:51.75,48.21 A:113857'}
G[701040]={'1024:45.51,46.19 A:94196'}
G[701041]={'1024:49.17,54.56 A:94507'}
G[701042]={'1065:21.03,58.64 A:91007'}
G[701043]={'1024:53.72,54.24 A:94507'}
G[701044]={'1033:51.93,82.17 A:32639'}
G[701045]={'1017:48.13,57.55 A:97091'}
G[701046]={'1065:19.09,60.06 A:91007'}
G[701047]={'1045[1]:0.00,0.00 A:1258979'}
G[701048]={'1041[1]:0.00,0.00 A:95676'}
G[701049]={'1024:40.51,63.45 A:95013'}
G[701050]={'1018:70.20,57.04 A:32639'}
G[701051]={'1018:62.86,48.53 A:95951'}
G[701052]={'1018:48.66,73.79 A:32639'}
G[701053]={'1018:40.80,58.95 A:94046'}
G[701054]={'1018:43.21,54.89 A:32639'}
G[701055]={'1018:39.93,61.38 A:93064'}
G[701056]={'1018:33.86,58.23 A:32638'}
G[701057]={'1018:38.64,67.20 A:32639'}
G[701058]={'1018:64.73,51.27 A:32639'}
G[701059]={'1033:71.35,57.82 A:99075'}
G[701060]={'1017:60.42,66.81 A:94856'}
G[701061]={'1033:75.70,62.25 A:104576'}
G[701062]={'1017:61.20,62.03 A:94413'}
G[701063]={'1033:31.81,19.52 A:111609'}
G[701064]={'1014[10]:0.00,0.00 A:110642'}
G[701065]={'1015:49.91,35.77 A:88101'}
G[701066]={'1081[1]:0.00,0.00 A:98970'}
G[701067]={'1080:36.62,6.56 A:101077'}
G[701068]={'1033:46.69,76.24 A:106032'}
G[701069]={'1033:17.55,46.52 A:105885'}
G[701070]={'1024:35.29,22.20 A:32638'}
G[701071]={'1033:17.30,54.62 A:32639'}
G[701072]={'1080:53.35,46.51 A:104615'}
G[701073]={'1033:44.47,75.88 A:32638'}
G[701074]={'1174[1]:21.39,55.12 A:121756'}
G[701075]={'1033:23.23,49.16 A:1252263'}
G[701076]={'1135[1]:43.12,27.58 A:121263'}
G[701077]={'1174[2]:34.02,65.72 A:120977'}
G[701078]={'1015:37.45,51.36 A:90661'}
G[701079]={'1033:22.85,48.79 A:114793'}
G[701080]={'1017:57.79,52.33 A:32639'}
G[701081]={'1171[5]:32.30,59.70 A:126950'}	-- in Vindicaar above Antoran Wastes
G[701082]={'1017:78.19,74.81 A:32639'}
G[701083]={'1174[3]:39.25,78.21 A:120977'}
G[701084]={'1024:48.04,29.71 A:96410'}
G[701085]={'1015:26.24,47.12 A:32638'}
G[701086]={'1017:64.29,39.56 A:32638'}
G[701087]={'1024:37.02,39.38 A:96286'}
G[701088]={'1171:75.85,37.60 A:126954'}
G[701089]={'1135:61.81,86.86 A:126307'}
G[701090]={'1015:28.29,48.76 A:107133'}
G[701091]={'1170:51.44,87.09 A:128725'}
G[701092]={'1014[10]:42.64,27.86 A:115264'}
G[701093]={'1170[3]:53.33,49.98 A:120533'}	-- in Vindicaar, turning in quest for returning piece
G[701094]={'1017:74.29,59.51 A:94338'}
G[701095]={'1135:61.87,86.99 A:122378'}
G[701096]={'1170:51.45,86.74 A:126408'}
G[701097]={'1171[5]:33.57,58.25 A:126954'}	-- in Vindicaar about Antoran Wastes
G[701098]={'1135:31.71,57.87 A:1271124'}
G[701099]={'1135[1]:45.58,35.60 A:126307'}
G[701100]={'1135:62.01,87.12 A:121263'}
G[701101]={'1135[1]:39.10,24.87 1135:61.67,86.92 A:124312'}	-- on Vindicaar when it is over Krokuun
G[701102]={'1170:51.83,87.01 A:124312'}
G[701103]={'1033:22.33,30.75 A:113102'}
G[701104]={'1033:36.86,46.52 A:107126'}
G[701105]={'1018:61.67,73.66 A:32638'}
G[701106]={'1017:48.58,22.89 A:102873'}
G[701107]={'1017:38.38,66.51 A:91423'}
G[701108]={'1033:45.36,28.20 A:110903'}
G[701109]={'1015:41.37,58.39 A:90659'}
G[701110]={'1014[10]:48.75,32.94 A:101527'}
G[701111]={'1015:46.82,14.53 A:90380'}
G[701112]={'1018:57.40,88.46 A:98234'}
G[701113]={'1018:36.16,63.60 A:111384'}
G[701114]={'1024:36.19,41.38 A:102361'}
G[701115]={'1024:31.66,38.30 A:108499'}
G[701116]={'1017:60.20,27.13 A:107463'}
G[701117]={'1017:37.99,68.56 A:91423'}
G[701118]={'1024:60.07,57.72 A:102866'}
G[701119]={'1017:66.33,55.12 A:108827'}
G[701120]={'1017:59.74,88.59 A:102871'}
G[701121]={'1017:61.92,93.64 A:104294'}
G[701122]={'1018:40.96,62.34 A:91847'}
G[701123]={'1021:50.53,9.97 A:116469'}
G[701124]={'1033:48.67,77.09 A:109409'}
G[701125]={'1021:0.00,0.00 A:107126'}
G[701126]={'1033:20.80,35.58 A:105756'}
G[701127]={'1018:56.80,82.06 A:110903'}
G[701128]={'1018:55.91,74.65 A:106901'}
G[701129]={'1018:0.00,0.00 A:103643'}
G[701130]={'1018:48.14,47.95 A:114676'}
G[701131]={'1033:17.91,47.02 A:113162'}
G[701132]={'1015:36.76,34.77 A:107715'}
G[701133]={'1024:60.22,57.67 A:102877'}
G[701134]={'1018:70.28,51.77 A:92326'}
G[701135]={'1018:65.53,58.77 A:105932'}
G[701136]={'1018:56.80,62.55 A:110903'}
G[701137]={'1018:57.78,72.04 A:110903'}
G[701138]={'1018:48.91,89.43 A:105960'}
G[701139]={'1147[1]:0.00,0.00 A:77789'}
G[701140]={'1017:60.66,88.93 A:102873'}
G[701141]={'1017:36.73,49.16 A:103643'}
G[701142]={'1017:56.46,38.44 A:105746'}
G[701143]={'1017:69.66,47.71 A:93066'}
G[701144]={'1021:53.84,72.16 A:118184'}
G[701145]={'1024:37.39,15.89 A:108529'}
G[701146]={'1024:36.73,18.66 A:115677'}
G[701147]={'1017:61.80,26.91 A:117080'}
G[701148]={'1044:50.52,57.84 A:119765'}
G[701149]={'1021:48.76,53.45 A:117168'}
G[701150]={'1017:55.38,77.25 A:107883'}
G[701151]={'1018:57.80,56.45 A:110896'}
G[701152]={'1015:38.72,54.35 A:103363'}
G[701153]={'1015:52.74,45.37 A:89846'}
G[701154]={'1015:53.74,38.75 A:89834'}
G[701155]={'1033:20.19,33.34 A:105554'}
G[701156]={'1033:48.65,72.76 A:114472'}
G[701157]={'1024:47.48,45.94 A:94196'}
G[701158]={'1018:33.40,40.85 A:102874'}
G[701159]={'1018:64.64,56.02 A:32641'}
G[701160]={'1080:29.68,40.02 A:104615'}
G[701161]={'1017:43.56,46.49 A:108289'}
G[701162]={'1021:68.50,45.90 A:120896'}
G[701163]={'1021:65.72,46.14 A:121034'}
G[701164]={'1024:51.31,52.54 A:101644'}
G[701165]={'1024:43.95,11.96 A:97919'}
G[701166]={'1018:41.10,90.72 A:115675'}
G[701167]={'1021:37.13,56.21 A:118786'}
G[701168]={'1015:35.94,48.87 A:107328'}
G[701169]={'1015:33.68,45.18 A:107440'}
G[701170]={'1015:39.11,15.70 A:114255'}
G[701171]={'1080:34.83,44.13 A:104615'}
G[701172]={'1024:61.10,56.22 A:102867'}
G[701173]={'1024:60.59,58.14 A:102873'}
G[701174]={'1038:29.77,46.47 A:98757'}
G[701175]={'1044:52.93,60.12 A:105019'}
G[701176]={'1018:43.15,46.04 A:91860'}
G[701177]={'1015:44.79,51.55 A:118836'}
G[701178]={'1033:21.31,21.42 A:32641'}
G[701179]={'1018:68.29,55.54 A:92326'}
G[701180]={'1024:40.78,31.90 A:103656'}
G[701181]={'1024:61.22,56.64 A:104294'}
G[701182]={'1017:43.67,81.65 A:91759'}
G[701183]={'1033:23.23,46.02 A:105676'}
G[701184]={'1021:47.84,17.03 A:118943'}
G[701185]={'1033:20.00,46.44 A:105625'}
G[701186]={'1021:64.46,51.18 A:121031'}
G[701187]={'1021:45.42,40.83 A:118851'}
G[701188]={'1017:62.86,51.42 A:93070'}
G[701189]={'1015:56.08,68.21 A:108338'}
G[701190]={'1024:26.47,53.83 A:102868'}
G[701191]={'1015:57.15,65.32 A:108340'}
G[701192]={'1015:67.25,46.20 A:109349'}
G[701193]={'1018:46.50,74.56 A:91598'}
G[701194]={'1017:68.09,47.20 A:93094'}
G[701195]={'1015:38.39,45.71 A:103231'}
G[701196]={'1018:33.13,40.81 A:102875'}
G[701197]={'1015:35.86,18.63 A:114255'}
G[701198]={'1017:0.00,0.00 A:91575'}
G[701199]={'1024:36.87,17.81 A:115669'}
G[701200]={'1017:51.22,25.50 A:107469'}
G[701201]={'1018:59.46,64.65 A:93318'}
G[701202]={'1018:41.83,75.73 A:102877'}
G[701203]={'1017:40.16,28.07 A:89829'}
G[701204]={'1033:44.16,37.90 A:99789'}
G[701205]={'1018:34.89,64.23 A:111383'}
G[701206]={'1018:41.61,55.40 A:92954'}
G[701207]={'1015:67.09,28.68 A:92450'}
G[701208]={'1017:48.21,17.41 A:119032'}
G[701209]={'1014[10]:51.84,66.21 A:111243'}
G[701210]={'1024:44.15,57.31 A:119944'}
G[701211]={'1033:23.30,57.96 A:104521'}
G[701212]={'1015:42.65,34.91 A:90134'}
G[701213]={'1033:31.29,80.79 A:99581'}
G[701214]={'1033:47.47,71.33 A:111446'}
G[701215]={'1018:40.79,76.83 A:102864'}
G[701216]={'1018:53.61,39.14 A:93159'}
G[701217]={'1033:20.06,43.15 A:105885'}
G[701218]={'1033:48.12,72.69 A:114468'}
G[701219]={'1018:68.61,73.87 A:109045'}
G[701220]={'1018:48.51,40.79 A:93318'}
G[701221]={'1015:32.74,55.00 A:107363'}
G[701222]={'1015:58.75,67.08 A:108146'}
G[701223]={'1015:55.30,30.57 A:90313'}
G[701224]={'1018:64.22,72.48 A:95599'}
G[701225]={'1018:46.50,41.86 A:111280'}
G[701226]={'1015:59.26,72.74 A:108133'}
G[701227]={'1018:65.68,39.69 A:93155'}
G[701228]={'1033:29.01,61.76 A:106339'}
G[701229]={'1015:42.35,87.80 A:111479'}
G[701230]={'1024:28.69,36.33 A:110903'}
G[701231]={'1017:43.75,44.38 A:108283'}
G[701232]={'1015:25.99,44.49 A:107216'}
G[701233]={'1033:31.94,47.44 A:110903'}
G[701234]={'1018:66.94,35.37 A:97338'}
G[701235]={'1017:63.07,27.84 A:117080'}
G[701236]={'1018:32.63,58.16 A:111383'}
G[701237]={'1024:30.21,48.47 A:95937'}
G[701238]={'1033:48.64,79.61 A:32641'}
G[701239]={'1017:54.00,44.72 A:105748'}
G[701240]={'1017:62.21,93.65 A:102877'}
G[701241]={'1015:58.79,38.67 A:89025'}
G[701242]={'1024:41.76,48.70 A:94149'}
G[701243]={'1017:45.89,79.00 A:91244'}
G[701244]={'1017:34.83,71.09 A:106568'}
G[701245]={'1024:0.00,0.00 A:97808'}
G[701246]={'1015:43.92,37.13 A:90134'}
G[701247]={'1017:49.74,56.12 A:107755'}
G[701248]={'1024:60.83,57.47 A:102869'}
G[701249]={'1021:0.00,0.00 A:105362'}
G[701250]={'1017:53.57,46.52 A:105748'}
G[701251]={'1017:64.41,50.18 A:93070'}
G[701252]={'1017:46.79,80.10 A:92128'}
G[701253]={'1018:43.63,91.03 A:115675'}
G[701254]={'1018:33.83,46.67 A:102866'}
G[701255]={'1015:51.38,20.37 A:109326'}
G[701256]={'1033:61.93,45.52 A:104404'}
G[701257]={'1018:58.74,56.58 A:93157'}
G[701258]={'1018:48.21,7.59 A:115682'}
G[701259]={'1033:62.74,59.55 A:109023'}
G[701260]={'1018:37.98,62.22 A:103643'}
G[701261]={'1033:48.71,40.89 A:110903'}
G[701262]={'1033:62.08,53.89 A:116555'}
G[701263]={'1033:17.69,47.21 A:105676'}
G[701264]={'1018:60.16,36.75 A:112052'}
G[701265]={'1033:29.51,34.50 A:110903'}
G[701266]={'1033:31.98,79.33 A:99581'}
G[701267]={'1014[10]:70.43,46.17 A:101527'}
G[701268]={'1017:48.63,20.99 A:102871'}
G[701269]={'1033:43.37,37.57 A:98979'}
G[701270]={'1018:57.61,54.65 A:92789'}
G[701271]={'1018:68.57,52.78 A:92326'}
G[701272]={'1018:62.26,39.03 A:93111'}
G[701273]={'1024:26.08,57.25 A:102869'}
G[701274]={'1024:42.87,49.81 A:101997'}
G[701275]={'1015:44.43,33.95 A:90134'}
G[701276]={'1015:38.28,49.53 A:90661'}
G[701277]={'1017:45.70,56.73 A:119905'}
G[701278]={'1033:29.40,72.84 A:110805'}
G[701279]={'1015:44.29,9.28 A:120107'}
G[701280]={'1018:62.95,60.78 A:92326'}
G[701281]={'1033:28.73,24.67 A:103616'}
G[701282]={'1024:60.97,56.44 A:102876'}
G[701283]={'1024:61.15,56.45 A:103653'}
G[701284]={'1017:42.38,57.52 A:110903'}
G[701285]={'1022:56.40,31.85 A:91384'}
G[701286]={'1024:55.42,58.80 A:96691'}
G[701287]={'1024:29.82,29.85 A:119105'}
G[701288]={'1024:33.08,23.22 A:115677'}
G[701289]={'1015:31.96,49.30 A:107335'}
G[701290]={'1080:34.82,44.12 A:111184'}
G[701291]={'1017:48.65,20.70 A:102867'}
G[701292]={'1017:60.68,25.45 A:107463'}
G[701293]={'1024:30.95,29.88 A:119104'}
G[701294]={'1033:83.17,58.93 A:100999'}
G[701295]={'1017:42.32,69.70 A:91205'}
G[701296]={'1017:67.30,39.89 A:108927'}
G[701297]={'1017:48.45,21.48 A:102875'}
G[701298]={'520[1]:0.00,0.00 A:55535'}
G[701299]={'520[1]:0.00,0.00 A:55537'}
G[701300]={'520[1]:0.00,0.00 A:55536'}
G[701301]={'520[1]:0.00,0.00 A:55531'}
G[701302]={'520[1]:0.00,0.00 A:26723'}
G[701303]={'1021:42.05,28.64 A:117509'}
G[701304]={'1021:57.35,28.18 A:32642'}
G[701305]={'1021:63.65,33.44 A:119634'}
G[701306]={'1021:82.16,30.20 A:118683'}
G[701307]={'1014[10]:51.01,27.97 A:77789'}
G[701308]={'1021:45.02,77.99 A:118266'}
G[701309]={'1015:64.56,31.47 A:92445'}
G[701310]={'1033:18.33,50.18 A:105885'}
G[701311]={'1033:28.61,41.42 A:100014'}
G[701312]={'1018:60.51,43.81 A:32641'}
G[701313]={'1018:33.12,42.54 A:102876'}
G[701314]={'1018:33.60,62.70 A:111383'}
G[701315]={'1015:43.50,31.97 A:98232'}
G[701316]={'1033:21.59,33.85 A:105756'}
G[701317]={'1018:62.76,60.05 A:92837'}
G[701318]={'1017:34.14,46.32 A:90903'}
G[701319]={'1021:44.71,69.71 A:115054'}
G[701320]={'1021:52.52,75.68 A:118057'}
G[701321]={'1017:58.39,47.00 A:105502'}
G[701322]={'1021:81.50,49.70 A:116121'}
G[701323]={'1021:48.08,40.84 A:118455'}
G[701324]={'1021:69.53,47.15 A:121031'}
G[701325]={'1021:59.71,28.89 A:118819'}
G[701326]={'1021:38.57,25.09 A:117354'}
G[701327]={'1018:60.36,47.69 A:92383'}
G[701328]={'1018:44.37,50.09 A:95430'}
G[701329]={'1018:44.24,48.45 A:95430'}
G[701330]={'1017:48.73,24.17 A:102875'}
G[701331]={'1018:26.95,71.16 A:98234'}
G[701332]={'1018:66.58,68.45 A:98234'}
G[701333]={'1018:66.36,72.72 A:109045'}
G[701334]={'1015:27.36,41.94 A:107201'}
G[701335]={'1033:25.22,34.70 A:104224'}
G[701336]={'1017:61.61,92.41 A:102864'}
G[701337]={'1021:49.02,72.95 A:115056'}
G[701338]={'1033:83.84,57.90 A:100998'}
G[701339]={'1022:56.64,39.17 A:91575'}
G[701340]={'1022:56.59,39.23 A:91384'}
G[701341]={'1024:51.63,42.99 A:94984'}
G[701342]={'1024:24.52,56.88 A:102867'}
G[701343]={'1018:56.83,57.07 A:32641'}
G[701344]={'1015:51.06,58.64 A:90109'}
G[701345]={'1015:47.44,53.08 A:32641'}
G[701346]={'1021:49.70,70.34 A:120636'}
G[701347]={'1017:0.00,0.00 A:91384'}
G[701348]={'1017:72.32,53.65 A:108030'}
G[701349]={'1015:36.19,16.31 A:114255'}
G[701350]={'1015:41.88,37.75 A:90134'}
G[701351]={'1033:44.82,42.77 A:99789'}
G[701352]={'1021:0.00,0.00 A:107376'}
G[701353]={'1033:21.53,21.60 A:106764'}
G[701354]={'1021:56.13,64.86 A:98232'}
G[701355]={'1021:0.00,0.00 A:90134'}
G[701356]={'1033:42.36,36.03 A:98979'}
G[701357]={'1015:62.34,24.10 A:116026'}
G[701358]={'1017:67.93,44.29 A:93094'}
G[701359]={'1018:55.26,88.40 A:91474'}
G[701360]={'1033:29.29,79.44 A:102450'}
G[701361]={'1015:68.29,28.96 A:103643'}
G[701362]={'1024:42.53,47.60 A:102982'}
G[701363]={'1033:20.84,31.04 A:116675'}
G[701364]={'1015:64.78,47.13 A:106695'}
G[701365]={'1033:45.52,69.85 A:106654'}
G[701366]={'1021:0.00,0.00 A:105525'}
G[701367]={'1017:60.16,44.19 A:105532'}
G[701368]={'1018:66.33,67.01 A:115008'}
G[701369]={'1024:25.64,41.46 A:102736'}
G[701370]={'1017:35.51,37.12 A:110903'}
G[701371]={'1017:55.41,43.03 A:105748'}
G[701372]={'1018:59.63,58.90 A:92789'}
G[701373]={'1033:28.44,62.14 A:99762'}
G[701374]={'1017:69.96,42.71 A:108940'}
G[701375]={'1018:49.00,38.69 A:115008'}
G[701376]={'1024:43.82,70.33 A:102886'}
G[701377]={'1017:78.61,71.88 A:115678'}
G[701378]={'1017:75.26,61.24 A:103643'}
G[701379]={'1018:59.56,91.72 A:110903'}
G[701380]={'1024:26.57,42.08 A:101700'}
G[701381]={'1015:58.99,64.41 A:108146'}
G[701382]={'1018:65.42,42.44 A:95951'}
G[701383]={'1017:45.87,49.43 A:96129'}
G[701384]={'1014[10]:40.33,50.26 A:77789'}
G[701385]={'1018:39.99,75.25 A:102868'}
G[701386]={'1018:23.90,69.66 A:111460'}
G[701387]={'1017:54.62,39.08 A:105718'}
G[701388]={'1015:38.85,55.70 A:103231'}
G[701389]={'1024:25.84,56.04 A:102877'}
G[701390]={'1024:60.13,57.83 A:102871'}
G[701391]={'1015:39.45,34.63 A:107628'}
G[701392]={'1018:36.48,59.72 A:98234'}
G[701393]={'1018:32.19,43.33 A:102877'}
G[701394]={'1015:47.52,14.72 A:90379'}
G[701395]={'1017:48.88,21.08 A:103653'}
G[701396]={'1033:45.23,67.49 A:111446'}
G[701397]={'1024:51.27,52.60 A:102468'}
G[701398]={'1015:30.61,48.39 A:107135'}
G[701399]={'1017:50.95,60.67 A:107755'}
G[701400]={'1018:53.32,77.05 A:115021'}
G[701401]={'1018:53.14,50.56 A:110903'}
G[701402]={'1015:36.72,35.06 A:107624'}
G[701403]={'1015:57.57,75.11 A:108139'}
G[701404]={'1018:55.09,82.18 A:91472'}
G[701405]={'1015:57.18,45.13 A:91756'}
G[701406]={'1088[3]:0.00,0.00 A:43929'}
G[701407]={'1018:72.57,36.87 A:106331'}
G[701408]={'1015:39.06,54.18 A:90659'}
G[701409]={'1017:32.77,42.37 A:110903'}
G[701410]={'1018:68.03,48.41 A:95951'}
G[701411]={'1018:47.19,55.28 A:100409'}
G[701412]={'1018:40.40,62.06 A:120144'}
G[701413]={'1017:70.67,41.50 A:93071'}
G[701414]={'1033:22.01,29.42 A:116675'}
G[701415]={'1017:80.17,69.67 A:115663'}
G[701416]={'1018:61.65,48.65 A:92383'}
G[701417]={'1017:78.93,75.26 A:115671'}
G[701418]={'1021:0.00,0.00 A:93071'}
G[701419]={'1024:35.48,19.80 A:115677'}
G[701420]={'1017:61.61,90.61 A:103245'}
G[701421]={'1015:50.90,33.36 A:88101'}
G[701422]={'1033:23.20,40.19 A:105625'}
G[701423]={'1015:62.70,54.87 A:109349'}
G[701424]={'1015:68.31,24.53 A:92450'}
G[701425]={'1017:73.40,89.35 A:102170'}
G[701426]={'1024:45.53,71.16 A:108069'}
G[701427]={'1033:31.08,83.20 A:110805'}
G[701428]={'1024:61.06,58.19 A:102867'}
G[701429]={'1015:58.89,66.90 A:108139'}
G[701430]={'1018:66.80,35.65 A:97337'}
G[701431]={'1033:47.18,68.20 A:108096'}
G[701432]={'1018:50.33,72.42 A:106369'}
G[701433]={'1024:25.92,56.29 A:102864'}
G[701434]={'1017:51.64,32.87 A:107469'}
G[701435]={'1017:80.11,61.86 A:98502'}
G[701436]={'1018:38.07,71.48 A:102876'}
G[701437]={'1024:31.89,61.07 A:110496'}
G[701438]={'1021:15.92,31.89 A:120215'}
G[701439]={'1015:35.85,14.23 A:105361'}
G[701440]={'1015:47.47,10.46 A:120107'}
G[701441]={'1018:38.72,83.04 A:102622'}
G[701442]={'1033:29.59,71.49 A:99581'}
G[701443]={'1018:42.56,37.10 A:111281'}
G[701444]={'1033:38.97,66.56 A:116206'}
G[701445]={'1015:59.68,24.60 A:116026'}
G[701446]={'1017:60.52,89.47 A:102875'}
G[701447]={'1018:37.69,77.88 A:102868'}
G[701448]={'1017:61.68,92.05 A:102873'}
G[701449]={'1018:57.82,83.00 A:108327'}
G[701450]={'1033:35.56,38.16 A:112910'}
G[701451]={'1017:76.78,82.98 A:115663'}
G[701452]={'1033:61.96,53.72 A:116554'}
G[701453]={'1033:20.11,24.32 A:106764'}
G[701454]={'1018:58.81,64.91 A:105823'}
G[701455]={'1017:40.75,82.83 A:91759'}
G[701456]={'1021:59.62,26.05 A:118819'}
G[701457]={'1017:40.75,82.83 A:92128'}
G[701458]={'1018:40.66,76.95 A:102875'}
G[701459]={'1018:39.81,75.28 A:102877'}
G[701460]={'1033:31.09,51.18 A:115562'}
G[701461]={'1018:21.80,67.78 A:111474'}
G[701462]={'1021:0.00,0.00 A:97140'}
G[701463]={'1017:0.00,0.00 A:91948'}
G[701464]={'1033:45.27,70.43 A:113619'}
G[701465]={'1018:52.07,9.36 A:115664'}
G[701466]={'1033:29.03,57.63 A:101868'}
G[701467]={'1018:40.82,74.62 A:102871'}
G[701468]={'1033:28.63,60.75 A:101868'}
G[701469]={'1033:17.97,59.66 A:109803'}
G[701470]={'1018:30.06,71.02 A:103643'}
G[701471]={'1015:53.26,44.27 A:107801'}
G[701472]={'1015:57.51,75.16 A:108133'}
G[701473]={'1015:37.72,17.58 A:110838'}
G[701474]={'1024:44.53,49.65 A:102982'}
G[701475]={'1024:44.09,49.80 A:94149'}
G[701476]={'1024:57.82,61.66 A:102871'}
G[701477]={'1024:61.04,56.41 A:102872'}
G[701478]={'1033:18.96,47.94 A:105623'}
G[701479]={'1014[10]:47.78,30.52 A:106655'}
G[701480]={'1015:60.57,26.41 A:116026'}
G[701481]={'1015:48.95,10.22 A:90480'}
G[701482]={'1018:43.28,88.55 A:102166'}
G[701483]={'1018:45.44,38.80 A:111281'}
G[701484]={'1024:32.38,60.20 A:110903'}
G[701485]={'1024:28.11,52.68 A:110903'}
G[701486]={'1017:47.36,22.52 A:102868'}
G[701487]={'1018:45.65,40.27 A:111252'}
G[701488]={'1033:25.74,61.33 A:101900'}
G[701489]={'1017:30.22,52.60 A:90903'}
G[701490]={'1018:46.88,43.61 A:111279'}
G[701491]={'1033:47.03,53.09 A:116050'}
G[701492]={'1033:23.01,41.32 A:105676'}
G[701493]={'1018:60.87,81.27 A:108259'}
G[701494]={'1017:44.86,43.45 A:96236'}
G[701495]={'1017:56.29,44.39 A:105748'}
G[701496]={'1033:57.34,45.49 A:116225'}
G[701497]={'1014[10]:50.27,35.45 A:101527'}
G[701498]={'1033:29.21,66.41 A:101868'}
G[701499]={'1033:24.53,32.33 A:98233'}
G[701500]={'1015:66.61,48.98 A:116428'}
G[701501]={'1015:62.63,23.43 A:116025'}
G[701502]={'1018:61.47,81.09 A:108600'}
G[701503]={'1018:62.55,74.71 A:95726'}
G[701504]={'1033:59.13,49.05 A:116225'}
G[701505]={'1017:61.51,91.41 A:102868'}
G[701506]={'1015:63.83,14.59 A:110824'}
G[701507]={'1024:54.49,41.40 A:107945'}
G[701508]={'1021:53.42,15.06 A:116470'}
G[701509]={'1018:39.02,62.67 A:94009'}
G[701510]={'1033:47.37,67.47 A:105759'}
G[701511]={'1015:62.15,46.39 A:89024'}
G[701512]={'1015:43.31,11.33 A:120074'}
G[701513]={'1021:0.00,0.00 A:92794'}
G[701514]={'1021:40.42,60.57 A:120820'}
G[701515]={'1021:67.54,46.90 A:121034'}
G[701516]={'1021:79.48,42.13 A:117718'}
G[701517]={'1021:55.00,63.44 A:120934'}
G[701518]={'1018:49.30,7.51 A:32641'}
G[701519]={'1017:79.02,74.34 A:115663'}
G[701520]={'1018:46.26,50.21 A:115906'}
G[701521]={'1018:53.48,77.96 A:109819'}
G[701522]={'1018:53.85,77.95 A:115119'}
G[701523]={'1021:67.35,48.18 A:121031'}
G[701524]={'1018:68.75,34.45 A:32641'}
G[701525]={'1018:59.38,67.53 A:105897'}
G[701526]={'1018:57.48,67.98 A:105897'}
G[701527]={'1018:40.07,75.71 A:102873'}
G[701528]={'1018:43.78,53.53 A:91860'}
G[701529]={'1033:22.66,36.08 A:32642'}
G[701530]={'1018:57.27,64.73 A:110903'}
G[701531]={'1018:56.21,85.77 A:110903'}
G[701532]={'1018:57.55,81.16 A:32641'}
G[701533]={'1018:39.44,84.45 A:102622'}
G[701534]={'1018:39.91,75.96 A:102866'}
G[701535]={'1018:38.77,59.74 A:98234'}
G[701536]={'1024:24.30,56.82 A:102875'}
G[701537]={'1024:49.34,28.60 A:96410'}
G[701538]={'1021:53.22,55.52 A:119139'}
G[701539]={'1021:54.37,57.91 A:118390'}
G[701540]={'1021:35.08,34.59 A:118162'}
G[701541]={'1018:44.63,51.54 A:91860'}
G[701542]={'1033:28.70,18.43 A:114305'}
G[701543]={'1015:67.73,50.62 A:106695'}
G[701544]={'1015:56.03,41.53 A:106106'}
G[701545]={'1018:64.18,70.27 A:95726'}
G[701546]={'1014[10]:63.16,56.41 A:111246'}
G[701547]={'1021:53.05,72.31 A:118057'}
G[701548]={'1018:63.77,54.26 A:92321'}
G[701549]={'1015:40.16,79.62 A:111457'}
G[701550]={'1033:47.90,63.07 A:105759'}
G[701551]={'1017:62.30,27.29 A:109967'}
G[701552]={'1021:67.32,43.90 A:120896'}
G[701553]={'1033:28.30,45.19 A:100014'}
G[701554]={'1018:58.00,59.03 A:98234'}
G[701555]={'1021:51.52,71.04 A:120934'}
G[701556]={'1021:51.92,71.55 A:120932'}
G[701557]={'1021:33.35,56.59 A:120226'}
G[701558]={'1018:44.27,76.10 A:91121'}
G[701559]={'1024:36.27,18.67 A:115665'}
G[701560]={'1015:62.56,43.17 A:89024'}
G[701561]={'1080:33.06,57.10 A:104615'}
G[701562]={'1033:64.34,42.96 A:113205'}
G[701563]={'1018:72.96,51.16 A:105826'}
G[701564]={'1080:33.35,57.10 A:111184'}
G[701565]={'1015:56.51,17.89 A:90318'}
G[701566]={'1080:31.96,41.78 A:104615'}
G[701567]={'1021:0.00,0.00 A:90903'}
G[701568]={'1018:75.01,44.24 A:106331'}
G[701569]={'1033:63.63,57.45 A:109023'}
G[701570]={'1024:49.74,44.22 A:94984'}
G[701571]={'1024:33.76,25.01 A:115679'}
G[701572]={'1033:62.81,56.64 A:109180'}
G[701573]={'1033:47.98,65.37 A:108096'}
G[701574]={'1024:37.73,40.77 A:102361'}
G[701575]={'1017:29.30,57.15 A:90903'}
G[701576]={'1017:45.87,38.89 A:107258'}
G[701577]={'1033:65.23,46.50 A:110253'}
G[701578]={'1015:34.47,6.24 A:115666'}
G[701579]={'1017:71.02,52.13 A:93095'}
G[701580]={'1015:50.75,39.49 A:88099'}
G[701581]={'1018:45.12,73.41 A:91122'}
G[701582]={'1033:21.49,39.78 A:107811'}
G[701583]={'1017:43.80,43.45 A:97755'}
G[701584]={'1024:29.24,29.46 A:101794'}
G[701585]={'1033:33.75,51.61 A:115562'}
G[701586]={'1033:62.85,56.60 A:109025'}
G[701587]={'1033:23.05,36.17 A:105676'}
G[701588]={'1033:17.81,48.21 A:105885'}
G[701589]={'1017:29.77,59.71 A:90903'}
G[701590]={'1033:58.57,51.43 A:110944'}
G[701591]={'1018:33.41,51.27 A:98234'}
G[701592]={'1033:44.64,33.15 A:97729'}
G[701593]={'1033:45.40,35.05 A:97729'}
G[701594]={'1015:35.22,10.25 A:115675'}
G[701595]={'1015:57.20,16.23 A:90318'}
G[701596]={'1017:27.26,57.25 A:90903'}
G[701597]={'1033:55.70,47.05 A:112370'}
G[701598]={'1018:32.59,41.19 A:102877'}
G[701599]={'1017:46.97,42.65 A:96129'}
G[701600]={'1033:80.33,70.56 A:103183'}
G[701601]={'1018:40.90,76.14 A:98234'}
G[701602]={'1018:69.53,54.47 A:110342'}
G[701603]={'1015:66.77,48.59 A:106695'}
G[701604]={'1017:46.84,35.63 A:99223'}
G[701605]={'1018:32.58,41.21 A:102867'}
G[701606]={'1024:26.65,55.74 A:102873'}
G[701607]={'1018:62.70,35.30 A:112021'}
G[701608]={'1024:37.97,41.15 A:96146'}
G[701609]={'1033:64.65,36.66 A:110253'}
G[701610]={'1024:58.31,64.83 A:103850'}
G[701611]={'1017:61.72,46.25 A:105502'}
G[701612]={'1041[3]:0.00,0.00 A:95676'}
G[701613]={'1024:33.32,22.99 A:115665'}
G[701614]={'1022:53.92,33.40 A:91948'}
G[701615]={'1017:60.72,29.80 A:107463'}
G[701616]={'1018:33.63,40.18 A:103653'}
G[701617]={'1017:64.87,44.69 A:109795'}
G[701618]={'1024:51.74,39.89 A:94984'}
G[701619]={'1044:52.61,58.84 A:101527'}
G[701620]={'1014[10]:49.08,31.02 A:101527'}
G[701621]={'1033:22.33,39.81 A:105676'}
G[701622]={'1024:52.42,80.25 A:103174'}
G[701623]={'1015:50.67,20.40 A:106630'}
G[701624]={'1024:60.51,59.63 A:102868'}
G[701625]={'1015:53.63,36.34 A:91431'}
G[701626]={'1015:62.66,42.95 A:89802'}
G[701627]={'1017:36.34,67.12 A:91423'}
G[701628]={'1015:48.10,53.15 A:89097'}
G[701629]={'1014[10]:69.82,38.31 A:101846'}
G[701630]={'1015:61.94,42.93 A:89025'}
G[701631]={'1021:0.00,0.00 A:116038'}
G[701632]={'1033:50.71,78.26 A:106032'}
G[701633]={'1017:71.60,87.59 A:102170'}
G[701634]={'1021:0.00,0.00 A:92332'}
G[701635]={'1018:59.44,71.20 A:105897'}
G[701636]={'1033:42.84,25.10 A:110903'}
G[701637]={'1018:48.88,74.12 A:98234'}
G[701638]={'1017:28.64,47.65 A:90903'}
G[701639]={'1018:60.68,70.26 A:95727'}
G[701640]={'1018:59.51,50.86 A:93157'}
G[701641]={'1017:71.21,44.81 A:93071'}
G[701642]={'1015:58.67,59.02 A:89283'}
G[701643]={'1015:63.58,21.59 A:106920'}
G[701644]={'1017:78.98,74.49 A:115678'}
G[701645]={'1033:48.07,71.30 A:114472'}
G[701646]={'1033:21.81,46.80 A:105486'}
G[701647]={'1033:62.55,50.76 A:116529'}
G[701648]={'1017:29.89,54.58 A:90903'}
G[701649]={'1017:47.48,38.01 A:107258'}
G[701650]={'1170:52.49,91.70 A:126389'}
G[701651]={'1170:31.88,37.47 A:121230'}
G[701652]={'1170:51.34,91.46 A:121589'}
G[701653]={'1170[3]:57.19,60.51 A:120533'}	-- in Vindicaar above Mac'Aree
G[701654]={'1170:28.43,47.21 A:121230'}
G[701655]={'1170:62.65,39.43 A:124312'}
G[701656]={'1170:43.42,67.59 A:121230'}
G[701657]={'1170:59.08,20.08 A:120533'}
G[701658]={'1170:52.08,89.74 A:128722'}
G[701659]={'1170:59.14,20.22 A:124312'}
G[701660]={'1170:48.79,19.73 A:120533'}
G[701661]={'1170:35.34,59.55 A:121230'}
G[701662]={'1170:50.14,17.91 A:120533'}
G[701663]={'1077:53.59,49.45 A:98002'}
G[701664]={'1135[1]:49.60,43.63 A:121263'}
G[701665]={'1170[3]:49.71,23.91 A:121263'}	-- in Vindicaar above Mac'Aree
G[701666]={'1170[3]:47.26,19.37 A:126408'}	-- in Vindicaar above Mac'Aree
G[701667]={'1135[1]:44.71,22.30 A:124312'}	-- on Vindicaar (later position) when it is over Krokuun
G[701668]={'1170[3]:50.91,23.27 1170:51.83,87.01 A:124312'}	-- in Vindicaar (later position) above Mac'Aree
G[701669]={'1170[4]:41.99,68.31 A:125525'}
G[701670]={'1135:61.75,86.48 A:126408'}
G[701671]={'1171[5]:56.30,28.48 N:127151'}	-- in Vindicaar above Antoran Wastes
G[701672]={'1135[1]:68.26,56.88 N:127151'}	-- in Vindicaar above Krokuun
G[701673]={'1135[1]:51.70,51.53 A:120533'}	-- in Vindicaar above Krokuun
G[701674]={'1170[3]:45.51,24.58 1135[1]:38.83,25.62 A:121230'}	-- in Vindicaar above Mac'Areee and Krokuun
G[701675]={'1170[3]:58.30,59.77 A:121230'}
G[701676]={'1135:63.26,90.56 A:126389'}
G[701677]={'1135[2]:0.00,0.00 A:121230'}
G[701678]={'1170:44.89,57.37 A:32639'}
G[701679]={'30:45.38,49.00 A:6774'}
G[701680]={'1170:24.20,39.25 A:121670'}
G[701681]={'1170:22.30,40.56 A:121671'}
G[701682]={'1015:49.24,46.35 A:110916'}
G[701683]={'1170:60.62,27.65 A:125926'}
G[701684]={'1024:34.74,72.94 A:117066'}
G[701685]={'1170:56.74,29.73 A:125497'}
G[701686]={'1170:54.89,25.17 A:125842'}
G[701687]={'1135[1]:0.00,0.00 A:121589'}
G[701688]={'1015:41.14,76.53 A:102059'}
G[701689]={'1024:50.20,64.60 A:32639'}
G[701690]={'946:61.80,27.53 A:75874'}
G[701691]={'1018:54.66,9.38 A:115664'}
G[701692]={'1018:53.67,9.17 A:115676'}
G[701693]={'1135[2]:0.00,0.00 A:124312'}
G[701694]={'1171:78.69,38.13 A:127120'}
G[701695]={'1170:60.39,38.88 A:124440'}
G[701696]={'1033:49.28,71.41 A:115216'}
G[701697]={'1135[2]:0.00,0.00 A:126408'}
G[701698]={'1033:49.12,79.58 A:109409'}
G[701699]={'1021:46.56,16.53 A:117325'}
G[701700]={'1170[3]:50.23,69.50 A:123668'}
G[701701]={'1021:29.88,57.94 A:120745'}
G[701702]={'1191:44.63,47.45 A:125587'}
G[701703]={'1171:78.66,36.88 A:77789'}
G[701704]={'1135:62.01,90.86 A:127120'}
G[701705]={'1170:51.27,87.16 A:121230'}
G[701706]={'1015:47.02,40.86 A:101527'}
G[701707]={'1080:30.39,47.84 A:110915'}
G[701708]={'1018:49.62,41.85 A:115008'}
G[701709]={'1171[6]:62.44,60.00 A:101527'}
G[701710]={'1017:56.59,39.71 A:105532'}
G[701711]={'1171[6]:33.54,58.25 A:126954'}
G[701712]={'1193:75.24,51.21 A:125634'}
G[701713]={'1024:43.23,57.31 A:102890'}
G[701714]={'1045[1]:0.00,0.00 A:95888'}
G[701715]={'1190:17.23,57.84 A:125483'}
G[701716]={'1041[2]:0.00,0.00 A:102019'}
G[701717]={'1190:21.27,45.98 A:125314'}
G[701718]={'1170:55.65,58.57 A:126852'}
G[701719]={'1171:75.57,37.70 A:127057'}
G[701720]={'1170:51.22,91.65 A:127151'}
G[701721]={'1170[3]:49.14,68.98 A:123395'}
G[701722]={'1171[6]:62.51,66.17 A:125525'}
G[701723]={'1171[6]:55.53,26.01 A:127476'}
G[701724]={'1171[6]:60.53,57.37 A:101527'}
G[701725]={'1170[3]:0.00,0.00 A:127476'}
G[701726]={'1170:57.70,32.32 A:124430'}
G[701727]={'1170:39.66,68.51 A:124398'}
G[701728]={'1135[1]:43.73,24.86 A:121263'}
G[701729]={'1135[2]:39.63,64.66 A:129674'}
G[701730]={'1170[3]:45.94,25.15 A:124312'}
G[701731]={'1171:75.86,37.35 A:121263'}
G[701732]={'1170:57.53,76.14 A:32642'}
G[701733]={'1147[1]:0.00,0.00 A:124312'}
G[701734]={'1015:47.18,9.62 A:91048'}
G[701735]={'1170[4]:0.00,0.00 A:124312'}
G[701736]={'1177[6]:49.25,71.75 A:123790'}
G[701737]={'1170[4]:0.00,0.00 A:126408'}
G[701738]={'1065:0.00,0.00 A:91007'}
G[701739]={'1171:76.23,56.08 A:127596'}
G[701740]={'1170:52.47,91.36 A:101527'}
G[701741]={'626:0.00,0.00 A:77789'}
G[701742]={'1177[1]:0.00,0.00 A:123781'}
G[701743]={'1170:51.61,91.84 A:123395'}
G[701744]={'1077:54.13,48.47 A:77789'}
G[701745]={'951:47.62,78.46 A:72875'}
G[701746]={'1135:35.08,66.41 A:123109'}
G[701747]={'951:60.78,62.82 A:72970'}
G[701748]={'1170:57.24,37.36 A:124432'}
G[701749]={'1170:61.14,36.41 A:124444'}
G[701750]={'1014[10]:44.75,59.14 A:97012'}
G[701751]={'1170:51.23,91.69 A:125525'}
G[701752]={'1191:46.08,53.12 A:125280'}
G[701753]={'946:43.85,28.64 A:86934'}
G[701754]={'946:34.87,17.52 A:86934'}
G[701755]={'1170:54.53,64.38 A:128357'}
G[701756]={'928:42.30,66.33 A:69674'}
G[701757]={'1170:40.27,66.47 A:124398'}
G[701758]={'1195:54.16,36.44 A:125634'}
G[701759]={'1015:40.24,49.10 A:103180'}
G[701760]={'1015:38.11,58.01 A:90660'}
G[701761]={'1015:66.05,50.70 A:106695'}
G[701762]={'1015:58.23,17.90 A:90005'}
G[701763]={'1014[10]:40.03,32.23 A:101527'}
G[701764]={'1015:54.99,18.83 A:90616'}
G[701765]={'1066[1]:0.00,0.00 A:102446'}
G[701766]={'1021:29.46,63.37 A:118786'}
G[701767]={'1021:40.89,78.63 A:118993'}
G[701768]={'1015:62.75,38.74 A:89024'}
G[701769]={'1170[4]:67.65,56.39 A:127476'}
G[701770]={'1017:49.03,20.82 A:104290'}
G[701771]={'1171:77.95,34.50 A:127476'}
G[701772]={'1171[5]:0.00,0.00 A:127476'}
G[701773]={'1171:72.98,71.07 A:126233'}
G[701774]={'1024:43.21,57.24 A:102884'}
G[701775]={'766[3]:0.00,0.00 A:15727'}
G[701776]={'1195:58.43,41.21 A:125634'}
G[701777]={'1170:53.91,14.76 A:126998'}
G[701778]={'766[3]:0.00,0.00 A:15379'}
G[701779]={'1135:63.64,89.35 A:125525'}
G[701780]={'1170:57.51,17.66 A:126995'}
G[701781]={'1170:58.03,15.04 A:126996'}
G[701782]={'1018:45.52,41.60 A:110916'}
G[701783]={'809:66.89,56.23 A:60968'}
G[701784]={'811[18]:47.11,83.05 A:96541'}
G[701785]={'1014[11]:55.90,65.35 A:101097'}
G[701786]={'1018:41.55,52.64 A:95430'}
G[701787]={'1018:43.05,51.38 A:91860'}
G[701788]={'32:49.46,74.73 A:100812'}
G[701789]={'32[27]:68.28,27.10 A:101282'}
G[701790]={'1050:37.57,31.26 A:101097'}
G[701791]={'1021:81.51,27.70 A:120945'}
G[701792]={'1212[1]:48.43,39.46 A:130549'}
G[701793]={'1170[3]:0.00,0.00 A:121589'}
G[701794]={'1192:60.48,67.98 A:125655'}
G[701795]={'946:68.89,22.53 A:79608'}
G[701796]={'1135:60.81,19.62 A:125129'}
G[701797]={'1171[5]:29.97,59.17 A:127057'}
G[701798]={'1135[7]:37.91,39.50 A:125824'}
G[701799]={'1171:78.09,34.63 A:127151'}
G[1000033]={'39:25.97,16.90'}
G[1000034]={'39:40.63,17.03'}
G[1000035]={'39:25.90,47.75'}
G[1000036]={'39:40.52,47.78'}
G[1000055]={'30:72.65,60.33'}
G[1000056]={'30:79.80,55.50'}
G[1000061]={'34:17.72,29.04'}
G[1000068]={'30:24.55,74.68'}
G[1000256]={'35:37.3,46.5'}
G[1000259]={'40:13.94,34.81'}
G[1000261]={'40:13.52,41.38'}
G[1002059]={'27:87.63,50.14'}
G[1002076]={'37:38.51,48.52'}
G[1002083]={'673:41.26,61.17'}
G[1002688]={'16:29.87,59.77'}
G[1002701]={'16:79.81,31.65','In cave'}
G[1002702]={'16:30.02,59.03'}
G[1002713]={'16:40.2,49'}
G[1002908]={'9:53.52,48.28'}
G[1003972]={'11:68.26,71.25'}
G[1004141]={'11:50.28,25.69'}
G[1006751]={'41:57.64,63.01'}
G[1006752]={'41:37.17,25.33'}
G[1007510]={'41:43.94,44.04 41:43.91,43.99 41:43.95,44.08'}	-- TODO: Determine what the locs are when turned in at original dude.  because turned it at 2nd dude only keeps them there.
G[1007923]={'41:59.84,59.86'}
G[1020985]={'141:55.44,25.92'}
G[1020992]={'141:29.63,48.59'}
G[1021042]={'141:29.84,48.24'}
G[1024776]={'21:44.2,42.6'}
G[1035251]={'101:36.1,30.4 101:36.1,30.5'}
G[1112948]={'40:14.38,24.05'}
G[1131474]={'692[2]:50.01,33.39 17:34.28,10.37>692'}
G[1138492]={'16:57.21,34.55'}
G[1142151]={'40:13.61,38.21'}
G[1142195]={'121:71.7,55.9'}
G[1142487]={'691[2]:68.60,62.21'}
G[1151286]={'181:59.5,31.2'}
G[1152097]={'760:46.1,22.2 760:46.5,22.3 760:46.5,23'}
G[1156561]={'30:24.57,78.22 N:1000068'}
G[1161521]={'201:38.44,66.07'}
G[1161526]={'201:68.54,36.54'}
G[1164869]={'704:54.1,27.2'}
G[1164955]={'201:56.50,12.53'}
G[1164956]={'201:23.57,50.03'}
G[1164957]={'201:77.18,49.99'}
G[1175084]={'691[2]:63.19,67.86 N:1142487'}
G[1175085]={'691[2]:65.73,57.83 N:1142487'}
G[1176091]={'182:59.68,8.12'}
G[1176392]={'22:62.58,58.56'}
G[1177544]={'23:32.22,83.42'}
G[1179485]={'699:26.4,57.3 699:26.4,58.3 699:26.4,58.5 699:26.5,58.5 699:26.6,57.3 699:26.6,58.3'}
G[1179517]={'699[4]:70.69,24.11'}
G[1179551]={'181:79.2,74.8'}
G[1179697]={'673:46.4,26.1'}
G[1179880]={'721:33.3,44.7 721:33.4,44.1 721:33.5,44.9 721:33.7,44.3'}
G[1180025]={'30:84.7,64.4'}
G[1180055]={'749:42.4,51.5 749:43.1,51.9'}
G[1180056]={'9:35.1,61.6 9:35.8,60.9'}
G[1180366]={''}
G[1180448]={'261:55.06,35.99'}
G[1180503]={'261:43.56,42.07'}
G[1180715]={'301:62.40,69.4'}
G[1180743]={'341:33.83,65.70 321[1]:49.29,78.27'}
G[1180746]={'341:33.47,65.58 321[1]:49.15,78.06'}
G[1180747]={'341:33.76,66.33 321[1]:49.55,78.11'}
G[1180748]={'341:33.85,66.64 321[1]:49.17,77.75'}
G[1180793]={'341:33.4,66 321[1]:49.53,77.81'}
G[1180918]={'462:48.17,46.29'}
G[1181011]={'462:69.24,52.10'}
G[1181147]={'463:48.3,31.6 N:1000068'}
G[1181150]={'463:79.63,17.58'}
G[1181153]={'463:72.2,31.2'}
G[1181638]={'465:28,60.3 N:1000068'}
G[1181748]={'464:50.5,11.6'}
G[1181756]={'476:61.2,41.8'}
G[1181758]={'476:61.2,49.4 476:61.2,49.6'}
G[1181889]={'476:55.2,59.1 N:1000068'}
G[1182032]={'476:37.6,61.3'}
G[1182115]={'467:79.08,64.83 N:1000068'}
G[1182165]={'467:32,49.4 467:32,49.5 N:1000068'}
G[1182392]={'477:55.7,37.9'}
G[1182393]={'477:54.68,70.74'}
G[1182549]={'478:67.9,53.4 478:67.9,53.5'}
G[1182587]={'478:57.59,54.70 N:1000068'}
G[1182588]={'478:49.8,45.2 N:1000068'}
G[1182947]={'724[1]:53.31,58.78 478:39.63,73.54>724'}
G[1183284]={'467:41.74,27.27 N:1000068'}
G[1183770]={'479:23.2,68.1'}
G[1183811]={'479:32.1,64.7 N:1000068'}
G[1183877]={''}
G[1184300]={'479:60.3,78'}
G[1184660]={'475:51.9,57.8 N:1000068'}
G[1184825]={'475:34.3,77.3 475:34.4,77.8 475:34.5,77.7 475:35.7,79.1'}
G[1184945]={'473:30.4,30.9 473:30.5,30.8 N:1000068'}
G[1184946]={'473:38.3,54 N:1000068'}
G[1185035]={'475:36.6,67.3 N:1000068'}
G[1185126]={'473:51.4,72.8 473:51.5,72.7'}
G[1185165]={'475:73.3,40.1'}
G[1185166]={'465:61.2,80.6 N:1000068'}
G[1186426]={'141:41.75,73.11 N:1000068'}
G[1186585]={'491:75.93,19.74'}
G[1186887]={'27:53.50,50.45 30:42.39,65.87 4:52.6,42.4 464:48.9,51.0 462:47.6,46.4'} -- for Alliance 20:61,52.7 is not right PS Seemed right this year
G[1187236]={'321[1]:49.39,77.61 341:33.65,65.63'}
G[1187273]={'141:29.70,47.63'}
G[1187559]={'HM 21:49.62,38.60'}
G[1187564]={'HM 39:45.1,62.48'}
G[1187565]={'486:54.63,35.88'}
G[1187851]={'486:57.56,69.13'}
G[1187905]={'486:48.55,59.03'}
G[1187914]={'HM 16:44.58,46.1 N:1187564'}
G[1187916]={'HM 43:86.77,41.51 N:1187564'}
G[1187917]={'HM 464:44.7,52.5 N:1187564'}
G[1187919]={'HM 475:41.8,65.9 N:1187564'}
G[1187920]={'HM 19:55.2,15.3 N:1187564'}
G[1187921]={'HM 476:55.8,68.7 N:1187564'}
G[1187922]={'HM 29:68.5,59.8 N:1187564'}
G[1187923]={'HM 42:48.92,22.58 N:1187564'}
G[1187924]={'HM 101:65.89,16.93 N:1187564'}
G[1187925]={'HM 27:53.8,44.7 N:1187564'}
G[1187926]={'HM 34:73.2,55.1 N:1187564'}
G[1187927]={'HM 141:62.04,40.41 N:1187564'}
G[1187928]={'HM 30:43.22,62.92 N:1187564'}
G[1187929]={'HM 121:46.66,43.72 N:1187564'}
G[1187930]={'HM 465:51.9,58.5 N:1187564'}
G[1187932]={'HM 35:32.32,40.2 N:1187564'}
G[1187933]={'HM 477:49.6,69.9 N:1187564'}
G[1187934]={'HM 36:24.6,54 N:1187564'}
G[1187935]={'HM 473:39.6,54.3 N:1187564'}
G[1187936]={'HM 41:54.7,52.7 N:1187564'}
G[1187937]={'HM 478:54.2,55.4 N:1187564'}
G[1187938]={'HM 26:14.47,49.81 N:1187564'}
G[1187939]={'HM 22:43.6,82.4 N:1187564'}
G[1187940]={'HM 40:13.2,47.4 N:1187564'}
G[1187941]={'HM 467:68.5,52.2 N:1187564'}
G[1187942]={'HM 479:31,62.8 N:1187564'}
G[1187943]={'HM 261:60.4,33.14 N:1187564'}
G[1187944]={'HM 673:51.7,67.2 N:1187564'}
G[1187945]={'HM 161:52.64,30.07 N:1187564'}
G[1187946]={'HM 281:61.38,47.17 N:1187564'}
G[1187947]={'HM 16:69.15,42.83 N:1187559'}
G[1187948]={'HM 43:51.58,66.66 N:1187559'}
G[1187949]={'HM 479:32.29,68.26 N:1187559'}
G[1187950]={'HM 261:50.86,41.80 N:1187559'}
G[1187951]={'HM 673:50.50,70.69 N:1187559'}
G[1187952]={'HM 161:49.81,28.17 N:1187559'}
G[1187953]={'HM 281:58.05,47.24 N:1187559'}
G[1187954]={'HM 17:24.05,37.08 N:1187559'}
G[1187955]={'HM 475:50.01,59.00 N:1187559'}
G[1187956]={'HM 29:51.45,29.11 N:1187559'}
G[1187957]={'HM 101:26.19,77.29 N:1187559'}
G[1187958]={'HM 4:51.98,47.19 N:1187559'}
G[1187959]={'HM 141:33.26,30.71 N:1187559'}
G[1187960]={'HM 462:46.38,50.35 N:1187559'}
G[1187961]={'HM 121:72.45,47.57 N:1187559'}
G[1187962]={'HM 463:47.12,25.97 N:1187559'}
G[1187963]={'HM 465:57.16,41.82 N:1187559'}
G[1187964]={'HM 24:54.56,49.85 N:1187559'}
G[1187965]={'HM 9:51.93,59.46 N:1187559'}
G[1187966]={'HM 477:51.07,34.02 N:1187559'}
G[1187967]={'HM 473:33.49,30.32 N:1187559'}
G[1187968]={'HM 81:52.99,62.27 N:1187559'}
G[1187969]={'HM 38:76.70,14.12 N:1187559'}
G[1187970]={'HM 478:51.94,43.18 N:1187559'}
G[1187971]={'HM 11:49.86,54.39 N:1187559'}
G[1187972]={'HM 26:76.69,74.60 N:1187559'}
G[1187974]={'HM 20:57.04,51.72 N:1187559'}
G[1187975]={'HM 467:35.57,51.75 N:1187559'}
G[1188085]={'486:56.81,55.56'}
G[1188261]={'490:64.29,19.76'}
G[1188364]={'488:47.70,80.01'}
G[1188365]={'490:36.95,32.35'}
G[1188418]={'488:37.6,46.5 488:37.7,46.4 N:1000256'}
G[1188419]={'488:36.64,64.97'}
G[1188649]={'488:77,62.8 N:1000068'}
G[1188667]={'490:31.80,59.55'}
G[1189303]={'HW 30:43.73,65.90 N:500022'}
G[1189311]={'488:78.62,52.29'}
G[1189989]={'HB 27:56.01,37.05'}
G[1189990]={'HB 4:40.67,17.38 N:1189989'}
G[1190020]={'488:77.34,51.43 N:1000256'}
G[1190034]={'HW 41:55.36,52.28 N:500022'}
G[1190035]={'HW 43:37.01,49.26 N:500022'}
G[1190036]={'HW 27:54.49,50.77 N:500022'}
G[1190037]={'HW 464:48.49,49.04 N:500022'}
G[1190038]={'HW 381:62.26,33.16 N:500022'}
G[1190039]={'HW 341:18.32,50.98 N:500022'}
G[1190040]={'HW 301:60.51,75.34 N:500022'}
G[1190041]={'HW 471:59.23,18.50 N:500022'}
G[1190042]={'HW 42:37,44.1 N:500022'}	-- was removed
G[1190043]={'HW 35:35.54,48.50 N:500022'}
G[1190044]={'HW 40:10.81,61.00 N:500022'}
G[1190045]={'HW 476:55.70,59.96 N:500022'}
G[1190046]={'HW 36:26.46,41.51 N:500022'}
G[1190047]={'HW 39:56.81,47.32 N:500022'}
G[1190048]={'HW 34:73.79,44.25 N:500022'}
G[1190050]={'HW 81:40.53,17.69 N:500022'}
G[1190051]={'HW 101:66.33,6.58 N:500022'}
G[1190052]={'HW 141:66.59,45.28 N:500022'}	-- Theramore...now destroyed
G[1190053]={'HW 121:46.33,45.19 N:500022'}
G[1190054]={'HW 26:14.19,44.60 N:500022'}
G[1190055]={'HW 465:54.25,63.70 N:500022'}
G[1190056]={'HW 465:23.42,36.38 N:500022'}
G[1190057]={'HW 467:67.16,48.94 N:500022'}
G[1190058]={'HW 467:41.91,26.17 N:500022'}
G[1190059]={'HW 478:56.59,53.23 N:500022'}
G[1190060]={'HW 477:54.19,75.87 N:500022'}
G[1190061]={'HW 475:35.83,63.73 N:500022'}
G[1190062]={'HW 475:61.05,68.08 N:500022'}
G[1190063]={'HW 473:37.02,58.29 N:500022'}
G[1190064]={'HW 4:51.54,41.59 N:500022'}
G[1190065]={'HW 9:46.79,60.41 N:500022'}
G[1190066]={'HW 20:60.98,51.40 N:500022'}
G[1190067]={'HW 462:48.20,47.87 N:500022'}
G[1190068]={'HW 462:43.70,71.03 N:500022'}
G[1190069]={'HW 321[1]:53.91,78.93 N:500022'}
G[1190070]={'HW 362:45.62,64.85 N:500022'}
G[1190071]={'HW 382:67.74,37.75 N:500022'}
G[1190072]={'HW 480:79.43,57.65 N:500022'}
G[1190073]={'HW 480:67.60,72.92 N:500022'}
G[1190074]={'HW 21:46.45,42.90 N:500022'}
G[1190075]={'HW 463:48.68,31.91 N:500022'}
G[1190076]={'HW 11:49.51,57.91 N:500022'}
G[1190077]={'HW N:500022'}	-- was removed
G[1190078]={'HW 24:57.86,47.27 N:500022'}
G[1190079]={'HW 43:73.96,60.60 N:500022'}
G[1190080]={'HW 81:50.39,63.80 N:500022'}
G[1190081]={'HW 61:46.1,51.4 61:46.1,51.5 N:500022'}	-- was removed
G[1190082]={'HW 16:69.01,33.28 N:500022'}
G[1190083]={'HW 101:24.08,68.29 N:500022'}
G[1190084]={'HW 37:37.37,51.77 N:500022'}
G[1190085]={'HW 141:36.78,32.43 N:500022'}
G[1190086]={'HW 38:46.89,56.90 N:500022'}
G[1190087]={'HW 17:3,46.1 N:500022'}	-- was removed
G[1190088]={'HW 121:74.83,45.14 N:500022'}
G[1190089]={'HW 26:78.19,81.46 N:500022'}
G[1190090]={'HW 465:56.80,37.45 N:500022'}
G[1190091]={'HW 465:26.90,59.47 N:500022'}
G[1190096]={'HW 467:30.63,50.87 N:500022'}
G[1190097]={'HW 478:48.73,45.18 N:500022'}
G[1190098]={'HW 477:56.68,34.49 N:500022'}
G[1190099]={'HW 475:53.43,55.54 N:500022'}
G[1190100]={'HW 475:76.22,60.39 N:500022'}
G[1190101]={'HW 473:30.27,27.70 N:500022'}
G[1190102]={'HW 11:67.34,74.66 N:500022'}
G[1190103]={'HW 673:40.91,73.72 N:500022'}
G[1190104]={'HW 141:41.86,74.09 N:500022'}
G[1190105]={'HW 161:52.56,27.10 N:500022'}
G[1190106]={'HW 281:59.83,51.22 N:500022'}
G[1190107]={'HW 261:55.47,36.79 N:500022'}
G[1190108]={'HW 23:75.57,52.31 N:500022'}
G[1190109]={'HW 467:78.46,62.88 N:500022'}
G[1190110]={'HW 481:28.21,49.07 N:500022'}
G[1190111]={'HW 481:56.31,81.93 N:500022'}
G[1190112]={'HW 475:62.90,38.33 N:500022'}
G[1190113]={'HW 479:32.02,64.44 N:500022'}
G[1190114]={'HW 479:43.32,36.10 N:500022'}
G[1190115]={'HW 473:61.00,28.17 N:500022'}
G[1190116]={'HW 473:56.37,59.82 N:500022'}
G[1190535]={'496:36.71,72.77'}
G[1190602]={'496:59.52,57.20'}
G[1190657]={'496:59.42,44.33'}
G[1190768]={'493:80.41,55.81'}
G[1190777]={'493:72.14,57.53'}
G[1190917]={'502:55.2,46.2'}
G[1190936]={'502:55.8,51.1 502:56.1,52.1'}
G[1191728]={'496:32.27,75.67 N:1000256'}
G[1191760]={'495:37.43,46.84'}
G[1191761]={'495:37.6,46.8'}
G[1191766]={'496:34.94,83.90'}
G[1191878]={'HW 496:59.32,57.20 N:500022'}
G[1191879]={'HW 496:40.86,66.04 N:500022'}
G[1191880]={'HW 490:20.89,64.76 N:500022'}
G[1191881]={'HW 490:65.36,47.00 N:500022'}
G[1191882]={'HW 490:31.94,60.21 N:500022'}
G[1191883]={'HW 490:59.63,26.36 N:500022'}
G[1192018]={'HW 493:26.61,59.20 N:500022'}
G[1192060]={'495:77.15,62.87'}
G[1192071]={'495:63.14,62.3 N:1192060'}
G[1192072]={'495:24.05,61.71'}
G[1192078]={'495:64,64.7 495:64.1,64.4'}
G[1192079]={'495:64.6,61.7 495:65,60.9 495:65.4,60.4'}
G[1192080]={'495:64.2,59.4 495:64.2,59.6 495:64.5,59.4 495:64.5,59.6'}
G[1192524]={'495:67.4,60'}
G[1192833]={'492:79.8,30.9'}
G[1193195]={'492:54,87.3'}
G[1193400]={'492:54.4,86.2'}
G[1194032]={'HM 486:55.21,20.18 N:1187564'}
G[1194033]={'HM 486:51.05,11.80 N:1187559'}
G[1194034]={'HM 493:47.30,61.49 N:1187559'}
G[1194035]={'HM 493:47.9,66.1 N:1187564'}
G[1194036]={'HM 488:75.07,43.83 N:1187564'}
G[1194037]={'HM 488:38.47,48.19 N:1187559'}
G[1194038]={'HM 491:57.7,15.7 N:1187564'}
G[1194039]={'HM 491:48.41,13.34 N:1187559'}
G[1194041]={'HM 490:34.16,60.59 N:1187564'}
G[1194042]={'HM 490:19.13,61.46 N:1187559'}
G[1194043]={'HM 495:40.38,85.59 N:1187559'}
G[1194044]={'HM 495:41.3,87 N:1187564'}
G[1194045]={'HM 510:77.60,75.23 N:1187564'}
G[1194046]={'HM 510:80.34,52.70 N:1187559'}
G[1194048]={'HM 496:43.32,71.35 N:1187559'}
G[1194049]={'HM 496:40.4,61 N:1187564'}
G[1194056]={'HW 491:58.32,62.82 N:500022'}
G[1194057]={'HW 491:30.83,41.43 N:500022'}
G[1194058]={'HW 491:60.48,15.90 N:500022'}
G[1194059]={'HW 486:58.52,67.87 N:500022'}
G[1194060]={'HW 486:57.12,18.82 N:500022'}
G[1194061]={'HW 488:28.95,56.22 N:500022'}
G[1194062]={'HW 488:77.50,51.29 N:500022'}
G[1194063]={'HW 495:28.72,74.28 N:500022'}
G[1194064]={'HW 504[1]:42.35,63.14 N:500022'}
G[1194065]={'HW 491:25.44,59.82 N:500022'}
G[1194066]={'HW 488:60.15,53.45 N:500022'}
G[1194067]={'HW 488:48.11,74.66 N:500022'}
G[1194068]={'HW 486:78.45,49.16 N:500022'}
G[1194069]={'HW 495:41.07,85.85 N:500022'}
G[1194070]={'HW 495:30.92,37.16 N:500022'}
G[1194071]={'HW 504[1]:48.15,41.30 N:500022'}
G[1194072]={'HW 504[2]:38.16,59.63 N:500022'}
G[1194073]={'HW 491:49.44,10.75 N:500022'}
G[1194074]={'HW 491:52.10,66.15 N:500022'}
G[1194075]={'HW 491:79.26,30.62 N:500022'}
G[1194076]={'HW 486:76.66,37.47 N:500022'}
G[1194077]={'HW 486:41.71,54.40 N:500022'}
G[1194078]={'HW 488:37.83,46.47 N:500022'}
G[1194079]={'HW 488:76.82,63.28 N:500022'}
G[1194080]={'HW 495:67.65,50.69 N:500022'}
G[1194081]={'HW 504[1]:66.82,29.61 N:500022'}
G[1194084]={'HW 486:49.74,9.98 N:500022'}
G[1194105]={'42:53.25,19.65'}
G[1194119]={'HW 495:37.09,49.51 N:500022'}
G[1194122]={'42:54.2,29.3'}
G[1194378]={'35:41.37,38.98'}
G[1194387]={'35:36.75,61.14 N:1194378'}
G[1194388]={'35:61.70,73.18 N:1194378'}
G[1194389]={'35:68.11,66.14 N:1194378'}
G[1194390]={'35:73.17,35.89 N:1194378'}
G[1194391]={'35:53.70,38.10 N:1194378'}
G[1194555]={'529:15.6,89.3'}
G[1194714]={'42:57.4,33.8'}
G[1195134]={'43:46.3,61.3'}
G[1195431]={'181:20.26,70.40'}
G[1195433]={'101:69.3,29.2'}
G[1195435]={'181:20.03,69.98'}
G[1195438]={'101:77.00,18.08'}
G[1195445]={'101:74.8,13.3'}
G[1195497]={'101:78.74,23.16'}
G[1195517]={'101:75.88,26.61'}
G[1195600]={'101:69.31,21.19'}
G[1195642]={'181:58.98,71.85'}
G[1195676]={'181:43.81,77.37'}
G[1196393]={'750:38.2,58.1 101[21]:12.57,49.33>750'}
G[1196394]={'545:32.77,66.39'}
G[1196832]={'181:49.52,28.77'}
G[1196833]={'181:53.00,29.06'}
G[1201578]={'181:55.14,51.94'}
G[1201742]={''}
G[1202135]={'201:45.49,7.74'}
G[1202264]={'201:53.1,51.9'}
G[1202335]={'607:67,46.6'}
G[1202407]={'161:41.88,57.52'}
G[1202474]={'720:84.48,43.21 161:37.78,82.38>720'}
G[1202598]={'607:40.4,77.8'}
G[1202613]={'544:51.37,13.08'}
G[1202697]={'606:27.18,35.22'}
G[1202701]={'606:88.26,58.56'}
G[1202706]={'606:28.43,36.38'}
G[1202712]={'606:25.81,41.66',"In cave Gar'gol's Hovel"}
G[1202714]={'615:40.49,75.47'}
G[1202759]={'610:57.86,35.10'}
G[1202859]={'610:46.53,47.38'}
G[1202871]={'610:49.67,40.89'}
G[1202916]={'610:55.11,54.98'}
G[1202975]={'61:79.61,75.08'}
G[1203128]={'610:56.42,30.08'}
G[1203134]={'121:65.91,62.87'}
G[1203140]={'615:40.4,75.4'}
G[1203186]={'81:64.97,49.37'}
G[1203207]={'606:31.28,77.08'}
G[1203301]={'610:60.39,69.83'}
G[1203305]={'615:57.26,89.93'}
G[1203395]={'610:38.9,26.9'}
G[1203733]={'30:74.04,73.32'}
G[1203734]={'30:24.78,95.26'}
G[1203755]={'181:52.31,50.30 N:1201578'}
G[1204050]={'181:53.54,47.37'}
G[1204274]={'640:53.59,73.79'}
G[1204344]={'36:16.24,65.34 36:16.03,64.65 N:1000256'}
G[1204351]={'36:17.87,18.62'}
G[1204406]={'673:62.39,46.79 673:48.51,81.00 673:50.2,75.9 673:54.2,65.4 673:54.2,65.5 673:57,54.4 673:57,54.5'}
G[1204450]={'673:50.24,91.45','Inside lower ship'}
G[1204578]={'673:40.63,73.22'}
G[1204817]={'34:23.45,35.41'}
G[1204824]={'34:20.37,27.46','In catacombs'}
G[1204825]={'34:18.02,25.37','In catacombs'}
G[1204959]={'640:66.45,20.61'}
G[1205134]={'640:63.72,55.40'}
G[1205143]={'21:53.85,12.95'}
G[1205198]={'301:50.19,42.64','In catacombs'}
G[1205207]={'640:67.20,70.18'}
G[1205258]={'22:53.76,80.44','Bottom of crypt'}
G[1205266]={'720:64.85,29.57'}
G[1205332]={'141:37.46,31.52 N:1000068'}
G[1205350]={'21:59.2,34.3'}
G[1205540]={'720:65.17,33.80'}
G[1205874]={'720:39.64,45.42'}
G[1205875]={'23:77.56,79.41'}
G[1206109]={'321[1]:49.66,76.48'}
G[1206111]={'301:62.91,71.54'}
G[1206116]={'321[1]:66.42,49.29 N:1206109'}
G[1206293]={'720:74.14,64.44'}
G[1206294]={'301:62.28,29.93 N:1206111'}
G[1206335]={'17:50.25,54.28'}
G[1206336]={'17:47.97,50.91'}
G[1206374]={'17:50.26,53.27'}
G[1206504]={'17:18.84,30.28','In the cave'}
G[1206569]={'700:57.94,33.50 N:1202697'}
G[1206585]={'182:51.48,83.81'}
G[1206944]={'24:39.72,63.04'}
G[1207104]={'182:60.4,22.3 182:60.5,22.2'}
G[1207125]={'29:73.73,67.33'}
G[1207179]={'281:24.47,47.61'}
G[1207279]={'24:56.54,47.11 24:59.91,63.56 N:1206109'}
G[1207291]={'281:67.06,55.09'}
G[1207303]={'29:17,51.6'}
G[1207304]={'29:72.92,65.14 N:1207303'}
G[1207320]={'341:25.56,69.62 N:1206111'}
G[1207321]={'381:44.93,49.88 N:1206111'}
G[1207322]={'471:55.30,47.33 N:1206111'}
G[1207323]={'362:42.33,57.81 N:1206109'}
G[1207324]={'382:65.93,50.00 N:1206109'}
G[1207325]={'480:62.17,60.44 N:1206109'}
G[1207359]={'606:59.15,83.87'}
G[1207406]={'767[1]:51.11,43.05'}
G[1207407]={'768[1]:60.18,71.32'}
G[1207408]={'769:62.1,31.7 720:76.75,84.45>769'}
G[1207409]={'747:31.57,24.82 720:60.52,64.19>747'}
G[1207410]={'759:48.4,60.8 759:48.6,60.9'}
G[1207411]={'757[1]:26.66,30.02 700:19.18,54.01>757'}
G[1207412]={'753[1]:42.17,69.44'}
G[1207982]={'HM 37:51.7,63.1 N:1187564'}
G[1207983]={'HM 37:40.70,51.80 N:1187559'}
G[1207984]={'HM 17:18.6,55.8 N:1187564'}
G[1207985]={'HM 607:48.27,72.46 N:1187564'}
G[1207986]={'HM 607:40.71,67.35 N:1187559'}
G[1207987]={'HM 201:59.78,62.90 N:1187564'}
G[1207988]={'HM 38:70.1,14.2 N:1187564'}
G[1207989]={'HM 19:46.31,14.13 N:1187559'}
G[1207990]={'HM 22:29.09,56.60 N:1187559'}
G[1207991]={'HM 181:60.45,53.57 N:1187559'}
G[1207992]={'HM 201:56.50,65.85 N:1187559'}
G[1207993]={'HM 81:49.50,51.14 N:1187564'}
G[1208089]={'HM 700:47.15,28.32 N:1187564'}
G[1208090]={'HM 700:53.27,46.37 N:1187559'}
G[1208093]={'HM 720:53,32 N:1187564'}
G[1208094]={'HM 720:52.98,34.58 N:1187559'}
G[1208115]={'HW 42:50.79,18.89 N:500022'}
G[1208116]={'HW 121:51.07,17.82 N:500022'}
G[1208117]={'HW 43:50.25,67.26 N:500022'}
G[1208118]={'HW 43:38.65,42.35 N:500022'}
G[1208119]={'HW 43:12.99,34.10 N:500022'}
G[1208120]={'HW 16:40.07,49.09 N:500022'}
G[1208121]={'HW 17:20.87,56.32 N:500022'}
G[1208122]={'HW 19:60.69,14.08 N:500022'}
G[1208123]={'HW 19:44.35,87.60 N:500022'}
G[1208124]={'HW 35:83.03,63.53 N:500022'}
G[1208125]={'HW 37:53.16,66.98 N:500022'}
G[1208126]={'HW 38:28.93,32.40 N:500022'}
G[1208127]={'HW 26:66.16,44.44 N:500022'}
G[1208128]={'HW 700:60.35,58.25 N:500022'}
G[1208129]={'HW 700:79.48,78.54 N:500022'}
G[1208130]={'HW 700:49.60,30.36 N:500022'}
G[1208131]={'HW 700:43.50,57.27 N:500022'}
G[1208132]={'HW 614:54.68,72.12 N:500022'}
G[1208133]={'HW 615:49.72,57.39 N:500022'}
G[1208134]={'HW 22:43.38,84.36 N:500022'}
G[1208135]={'HW 40:58.21,39.20 N:500022'}
G[1208136]={'HW 40:26.07,25.99 N:500022'}
G[1208137]={'HW 17:65.85,35.65 N:500022'}
G[1208138]={'HW 28:39.48,66.02 N:500022'}
G[1208139]={'HW 38:71.65,14.10 N:500022'}
G[1208140]={'HW 181:57.10,50.17 N:500022'}
G[1208141]={'HW 610:63.49,60.17 N:500022'}
G[1208142]={'HW 615:49.19,41.88 N:500022'}
G[1208143]={'HW 17:18.36,42.73 N:500022'}
G[1208144]={'HW 19:40.47,11.29 N:500022'}
G[1208145]={'HW 24:60.26,63.75 N:500022'}
G[1208146]={'HW 21:44.30,20.29 N:500022'}
G[1208147]={'HW 673:35.04,27.22 N:500022'}
G[1208148]={'HW 26:31.82,57.87 N:500022'}
G[1208149]={'HW 20:83.04,72.08 N:500022'}
G[1208150]={'HW 700:53.40,42.85 N:500022'}
G[1208151]={'HW 700:45.11,76.80 N:500022'}
G[1208152]={'HW 700:75.36,54.92 N:500022'}
G[1208153]={'HW 700:75.41,16.53 N:500022'}
G[1208154]={'HW 615:51.48,62.39 N:500022'}
G[1208155]={'HW 614:51.35,60.56 N:500022'}
G[1208156]={'HW 22:48.28,63.66 N:500022'}
G[1208157]={'HW 101:56.72,50.12 N:500022'}
G[1208158]={'HW 182:44.58,28.99 N:500022'}
G[1208159]={'HW 182:61.86,26.71 N:500022'}
G[1208160]={'HW 121:41.45,15.68 N:500022'}
G[1208161]={'HW 121:51.97,47.63 N:500022'}
G[1208162]={'HW 606:63.05,24.15 N:500022'}
G[1208163]={'HW 606:18.63,37.32 N:500022'}
G[1208164]={'HW 606:42.68,45.71 N:500022'}
G[1208165]={'HW 11:56.21,40.03 N:500022'}
G[1208166]={'HW 11:62.51,16.60 N:500022'}
G[1208167]={'HW 607:39.29,20.10 N:500022'}
G[1208168]={'HW 607:40.71,69.31 N:500022'}
G[1208169]={'HW 607:39.01,10.99 N:500022'}
G[1208170]={'HW 607:65.60,46.54 N:500022'}
G[1208171]={'HW 607:49.05,68.50 N:500022'}
G[1208172]={'HW 81:66.49,64.19 N:500022'}
G[1208173]={'HW 81:71.02,79.08 N:500022'}
G[1208174]={'HW 81:59.05,56.33 N:500022'}
G[1208175]={'HW 81:39.48,32.81 N:500022'}
G[1208176]={'HW 81:31.53,60.66 N:500022'}
G[1208177]={'HW 161:55.70,60.96 N:500022'}
G[1208178]={'HW 720:26.59,7.24 N:500022'}
G[1208179]={'HW 720:54.68,33.01 N:500022'}
G[1208180]={'HW 201:55.27,62.12 N:500022'}
G[1208181]={'HW 640:51.19,49.91 N:500022'}
G[1208183]={'HW 640:47.36,51.71 N:500022'}
G[1208184]={'HM 606:62.78,22.99'}
G[1208187]={'HM 615:49.29,41.91 N:1208184'}
G[1208188]={'HM 640:49.41,51.43 N:1208184'}
G[1208316]={'504[1]:37.55,62.97 N:1206111'}
G[1208317]={'504[1]:59.2,27.4 N:1206109'}
G[1208420]={'673:35.51,63.57'}
G[1208535]={'795:69,42'}
G[1208549]={'781:15.99,55.99'}
G[1208550]={'X 793:31.42,48.17 37:72.09,32.91>793 N:1208549'}
G[1208825]={'381:69.42,39.69'}
G[1209072]={'301:55.40,43.40','In catacombs'}
G[1209076]={'301:65.07,33.52 N:500024'}
G[1209094]={'382:65.8,74.7 N:1209072'}
G[1209095]={'321[1]:54.5,77.8 321[1]:71.6,49.8 N:500025'}
G[1209673]={'808:26.46,33.68'}
G[1209845]={'806:53.71,91.51'}
G[1211316]={'807:19.84,55.93'}
G[1211754]={'809:57.11,47.89'}
G[1212181]={'806:30.89,17.49'}
G[1212389]={'858:53.08,12.36','Down in the Amber Vault'}
G[1213767]={'807[14]:31.36,52.90','In a cave whose entrance is 35,19'}
G[1213770]={'809[8]:41.66,44.11','In back of cave whose entrance is 809:59.20,53.14'}
G[1213771]={'809:72.02,33.98'}
G[1213793]={'809:52.57,51.54'}
G[1214062]={'858:41.88,63.72'}
G[1214205]={'811:83.0,30.4 N:1214218'}
G[1214206]={'811:83.0,30.4 N:1214218'}
G[1214207]={'811:83.0,30.4 N:1214218'}
G[1214208]={'811:83.0,30.4 N:1214218'}
G[1214209]={'811:83.08,30.43 N:1214218'}
G[1214210]={'811:83.5,30.5 N:1214218'}
G[1214211]={'811:83.5,30.5 N:1214218'}
G[1214212]={'811:83.5,30.5 N:1214218'}
G[1214213]={'811:83.5,30.5 N:1214218'}
G[1214214]={'811:83.5,30.5 N:1214218'}
G[1214215]={'811:83.70,30.66 N:1214218'}
G[1214217]={'811:83.5,30.5 N:1214218'}
G[1214218]={'811:83.55,30.59 N:1214218'}
G[1214219]={'811:83.5,30.5 N:1214218'}
G[1214220]={'811:83.5,30.5 N:1214218'}
G[1214221]={'811:83.5,30.5 N:1214218'}
G[1214222]={'811:83.5,30.5 N:1214218'}
G[1214223]={'811:83.5,30.5 N:1214218'}
G[1214224]={'811:83.5,30.5 N:1214218'}
G[1214225]={'811:83.7,30.8 N:1214218'}
G[1214226]={'811:83.7,30.8 N:1214218'}
G[1214438]={'809:64.23,45.11'}
G[1214562]={'858:44.57,41.32'}
G[1214871]={'806:48.57,20.61'}
G[1215705]={'807:52.03,49.06'}
G[1215844]={'806:27.60,24.29'}
G[1215873]={'857:28.25,50.74 N:500022'}
G[1215874]={'HW 806:41.68,23.14 N:500022'}
G[1215875]={'HW 903[2]:58.88,78.25 N:500022'}
G[1215876]={'HW 858:55.21,71.19 N:500022'}
G[1215877]={'HW 858:55.93,32.28 N:500022'}
G[1215879]={'HW 873:55.10,72.24 N:500022'}
G[1215880]={'HW 806:45.77,43.60 N:500022'}
G[1215881]={'HW 806:28.01,47.39 N:500022'}
G[1215884]={'HW 806:48.09,34.62 N:500022'}
G[1215886]={'HW 806:55.71,24.41 N:500022'}
G[1215889]={'HW 806:54.61,63.32 N:500022'}
G[1215891]={'HW 806:59.56,83.24 N:500022'}
G[1215892]={'HW 857:51.40,77.29 N:500022'}
G[1215894]={'HW 857:75.92,6.87 N:500022'}
G[1215895]={'HW 809:57.45,59.95 N:500022'}
G[1215897]={'HW 809:72.73,92.28 N:500022'}
G[1215898]={'HW 809:62.7,80.5 N:500022'}
G[1215899]={'HW 809:64.21,61.27 N:500022'}
G[1215900]={'HW 809:54.07,82.81 N:500022'}
G[1215902]={'HW 810:71.12,57.79 N:500022'}
G[1215903]={'HW 811:35.13,77.78 N:500022'}
G[1215904]={'HW 857:61.02,25.14 N:500022'}
G[1215905]={'HW 807:83.64,20.14 N:500022'}
G[1215906]={'HW 807:19.87,55.79 N:500022'}
G[1215907]={'HW 806:44.80,84.37 N:500022'}
G[1215908]={'HW 806:28.45,13.27 N:500022'}
G[1215914]={'HW 809:62.50,28.90 N:500022'}
G[1215915]={'HW 811[3]:37.86,65.93 N:500022'}
G[1216161]={'857:39.21,61.92 N:1181758'}
G[1216162]={'857:13.87,41.34 N:1181758'}
G[1216163]={'857:56.30,42.05 N:1181758'}
G[1216274]={'857:8.45,63.92'}
G[1216322]={'857:12.73,56.70 N:1203733'}
G[1216609]={'HM 857:85.59,29.16'}
G[1216837]={'873:54.99,72.65'}
G[1217845]={'HM 858:56.06,69.44 N:1217848'}
G[1217846]={'HM 806:47.14,47.09 N:1217848'}
G[1217847]={'HM 857:73.94,9.39 N:1217848'}
G[1217848]={'HM 809:71.09,90.98'}
G[1217849]={'HM 810:71.43,56.33 N:1217848'}
G[1217850]={'HM 807:51.81,51.19 N:1217848'}
G[1217851]={'HM 811:79.92,37.29 N:1187564'}
G[1217852]={'HM 811:77.78,33.66 N:1187559'}
G[1218072]={'928:39.12,56.01 928:40.65,71.43 928:50.18,85.91 928:53.18,81.39 928:52.95,45.10 928:54.27,48.85'}
G[1218077]={'928:34.62,64.83','In cave from beach'}
G[1218750]={'807:52.28,48.69'}
G[1218765]={'807:51.61,48.67'}
G[1218951]={'811:82,31 N:1214218'}
G[1218952]={'811:82.93,31.13 N:1214218'}
G[1218953]={'811:82,31 N:1214218'}
G[1218954]={'811:82,31 N:1214218'}
G[1218955]={'811:82.89,31.41 N:1214218'}
G[1218956]={'811:82,31 N:1214218'}
G[1218957]={'811:82,31 N:1214218'}
G[1218958]={'811:82,31 N:1214218'}
G[1220832]={'951:40.40,92.98'}
G[1220901]={'951:49.71,69.42'}
G[1220902]={'951:53.94,47.21'}
G[1220903]={'951:58.51,60.06'}
G[1220986]={'951:22.69,58.94'}
G[1221036]={'951:70.7,80.9'}
G[1221376]={'951:52.09,46.14'}
G[1221413]={'867[1]:69.09,58.08'}
G[1221617]={'951[22]:62.91,34.88','In cave'}
G[1222684]={'Z951'}
G[1223533]={'947:44.48,63.57'}
G[1224228]={'947:37.18,23.13 N:1002076','In cave'}
G[1224305]={'941:60.28,27.20'}
G[1224306]={'941:58.37,31.09'}
G[1224750]={'947:47.14,46.03'}
G[1224753]={'947:67.04,84.18','In cave'}
G[1224754]={'947:39.19,83.91'}
G[1224755]={'947:37.52,59.24'}
G[1224756]={'947:54.92,45.01'}
G[1224770]={'947:45.82,24.57','In cave'}
G[1224780]={'947:29.99,45.35'}
G[1224781]={'947[15]:56.27,49.19'}
G[1224783]={'947:51.75,35.49'}
G[1224784]={'947:51.14,79.13'}
G[1224785]={'947:20.37,30.64'}
G[1225501]={'947:45.21,60.49 N:1223533'}
G[1225502]={'947:43.75,60.62 N:1223533'}
G[1225503]={'947:44.49,59.14 N:1223533'}
G[1225726]={'946:61.80,27.54'}
G[1225778]={'946:76.27,42.76'}
G[1226702]={'947:45.60,37.80 N:1000068'}	-- this does not exist until the garrison is constructed (or something else)...perhaps they are no longer here
G[1226831]={'947:49.39,37.59','Upstairs'}
G[1226861]={'947:31.26,39.12'}
G[1226862]={'947:34.40,46.17'}
G[1226865]={'947:84.56,44.78'}
G[1226961]={'941[1]:28.87,44.85 N:1203733'}
G[1226987]={'946:30.89,70.82'}
G[1227069]={'946:49.21,88.05'}
G[1227134]={'947:42.10,61.22'}
G[1227504]={'941:84.09,65.14'}
G[1227737]={'946:37.25,79.39'}
G[1227743]={'947:26.53,5.68'}
G[1227793]={'946:36.52,95.98'}
G[1227806]={'941:82.64,69.83'}
G[1227951]={'946:64.91,13.31'}
G[1227953]={'946:65.46,11.37','In cave'}
G[1227954]={'946:52.56,29.54'}
G[1227955]={'946:62.08,32.40'}
G[1227956]={'946:57.37,28.66'}
G[1227996]={'946:66.50,86.94'}
G[1228012]={'946:77.03,49.95'}
G[1228013]={'946:35.40,96.56'}
G[1228014]={'946:75.78,44.72','On platform'}
G[1228015]={'946:64.58,79.20'}
G[1228016]={'946:62.42,47.97'}
G[1228017]={'946:55.25,66.73'}
G[1228018]={'946[14]:28.25,34.96'}
G[1228019]={'946:65.44,88.61'}
G[1228020]={'946:46.95,91.74'}
G[1228021]={'946:38.33,84.51'}
G[1228022]={'946:38.16,12.34'}
G[1228023]={'946:33.29,76.81'}
G[1228024]={'946:81.85,34.94','In mine'}
G[1228025]={'946:75.68,41.40','Under bridge'}
G[1228026]={'946:78.21,14.72'}
G[1228483]={'946:65.96,85.14','Very deep in water'}
G[1229314]={'947:59.79,94.46'}
G[1229330]={'949:39.70,39.90'}
G[1229331]={'946:45.27,37.06'}
G[1229333]={'941:68.00,18.92'}
G[1229344]={'950:46.37,16.04'}
G[1229354]={'946:73.52,51.37','In water'}
G[1230303]={'950:78.97,58.93 N:1203733'}	-- 950:78.63,48.32
G[1230665]={'946:69.77,20.70'}
G[1230741]={'950:63.10,62.02'}
G[1230865]={'971:48.38,40.93'}	-- garrison level 1 location
G[1230882]={'950:71.04,52.31'}
G[1230933]={'947:56.95,34.73'}
G[1230977]={'950:82.94,44.22'}
G[1231100]={'941:54.22,67.52'}
G[1231183]={'948:66.61,51.69'}
G[1231184]={'948:66.80,51.39'}
G[1231901]={'950:81.33,70.35'}
G[1231903]={'949:47.60,72.75'}
G[1231918]={'947:50.00,81.23'}
G[1232024]={'950:51.87,62.10'}
G[1232089]={'948:39.70,60.76'}
G[1232353]={'948:35.49,32.04'}
G[1232397]={'971:42.92,44.59'}
G[1232398]={'971:42.68,44.77 N:1203733'}
G[1232400]={'971:42.67,44.73 N:1232397'}	-- garrison level 2 location
G[1232405]={'947:57.46,57.26 N:1000068'}
G[1232406]={'950:69.93,52.50 N:1233511','Hanging in tree'}
G[1232416]={'976:49.04,41.72 N:1233291'}	-- garrison level 1 location
G[1232489]={'949:47.88,94.25'}	-- it seems Blizzard took this out of a dungeon map 949[17]:44.39,25.67
G[1232492]={'949:47.96,94.35'}
G[1232494]={'947:52.88,24.86','Bottom of water'}
G[1232571]={'950:47.21,74.27','In tree'}
G[1232579]={'947:57.91,45.32 N:80470'}
G[1232582]={'947:37.75,44.27'}
G[1232583]={'947:33.49,39.65'}
G[1232584]={'950:50.12,82.29 N:1232598'}
G[1232586]={'947:36.68,44.46'}
G[1232587]={'947:35.88,40.88'}
G[1232588]={'947:38.49,43.05'}
G[1232589]={'947:34.17,43.48'}
G[1232590]={'950:50.02,66.48'}
G[1232591]={'947:36.79,41.41'}
G[1232592]={'947:55.28,74.87'}
G[1232595]={'950:52.67,80.08 N:1232598'}
G[1232596]={'947:52.82,48.38'}
G[1232598]={'950:77.83,51.94','On top of tower'}
G[1232621]={'947:55.82,20.00','On top of mushroom'}
G[1232624]={'947:58.88,21.93'}
G[1232985]={'950:88.27,42.62 N:1232598'}
G[1233033]={'950:70.59,18.60 N:1232598'}
G[1233034]={'950:64.59,17.62 N:1232598'}
G[1233099]={'948:39.78,42.65 N:1000068'}
G[1233100]={'948:39.46,61.66 N:1000068'}
G[1233101]={'947:37.18,26.02'}
G[1233107]={'1017:67.94,57.76 N:1244694'}
G[1233134]={'950:58.27,52.48','In tree'}
G[1233135]={'950:51.72,60.29'}
G[1233206]={'950:67.65,59.72'}
G[1233229]={'947:60.92,24.43','In cave'}
G[1233241]={'947:48.72,47.53'}
G[1233263]={'950:55.43,55.95 950:51.83,58.74 950:46.76,57.46 950:52.03,68.74'}
G[1233291]={'976:49.05,41.69'}	-- Garrison Level 1 position
G[1233391]={'949:47.72,52.07'}
G[1233505]={'949:45.31,81.94'}	-- arbitrarily mapped ID to location...cannot tell which for sure
G[1233511]={'950:45.62,52.01'}
G[1233520]={'949:45.97,93.57'}
G[1233525]={'949:41.98,81.55'}
G[1233539]={'950:43.22,57.55 N:1233549'}
G[1233549]={'950:48.06,60.12'}
G[1233551]={'950:44.69,67.57 N:1233549'}
G[1233555]={'950:48.58,72.77 N:1233549'}
G[1233557]={'950:55.34,68.27 N:1233549'}
G[1233559]={'949:45.80,89.31'}
G[1233560]={'950:45.85,66.29'}
G[1233561]={'950:58.30,59.32','In tree'}
G[1233611]={'950:67.38,49.08'}
G[1233613]={'950:64.70,65.82'}
G[1233623]={'950:56.57,72.94'}
G[1233641]={'950:64.77,35.72'}
G[1233642]={'950:38.36,49.33'}
G[1233645]={'950:52.41,44.38'}
G[1233649]={'950:75.37,47.10'}
G[1233651]={'950:61.76,57.46','In tree'}
G[1233658]={'950[12]:65.92,57.54 N:1233623'}
G[1233715]={'950:38.35,58.73'}
G[1233768]={'950:57.80,62.04','On rock outcropping'}
G[1233773]={'950:62.54,67.08'}
G[1234147]={'948:36.81,17.14'}
G[1234154]={'948:42.69,18.32'}
G[1234157]={'948:50.50,22.10'}
G[1234159]={'948:50.76,28.75','Under bridge'}
G[1234243]={'971:36.11,34.87'}	-- garrison level 2 position
G[1234432]={'948:58.70,60.24'}
G[1234449]={'948:43.23,27.24','In tree'}
G[1234454]={'948:60.24,53.87 N:1234449','In tree'}
G[1234455]={'948:51.89,48.92 N:1234449','On wall'}
G[1234456]={'948:47.92,30.68'}
G[1234458]={'948:56.23,28.78'}
G[1234461]={'948:54.36,32.54'}
G[1234471]={'948:59.63,81.33'}
G[1234472]={'948:59.16,90.62'}
G[1234473]={'948:55.53,90.84','On high shelf'}
G[1234474]={'949:51.04,51.62'}	-- Sparring Arena-based location
G[1234618]={'948:61.11,55.38'}
G[1234703]={'948:43.90,15.01 N:1234704'}
G[1234704]={'948:43.82,24.63'}
G[1234705]={'948:69.15,43.34 N:1234704'}
G[1234734]={'948:48.97,62.56 N:1234704'}
G[1234735]={'948:55.66,22.09 N:1234704'}
G[1234736]={'948:53.13,84.50 N:1234704'}
G[1234740]={'948:36.29,39.34'}
G[1234744]={'948:53.31,55.52 N:1235073'}
G[1234746]={'948:48.35,52.61 N:1235073'}
G[1234748]={'948:48.35,52.61 N:1235073'}
G[1235073]={'948:51.88,64.65'}
G[1235090]={'948:60.97,63.87 N:1235073'}
G[1235091]={'948:47.77,36.12'}
G[1235095]={'948:52.47,42.80'}
G[1235097]={'948:36.44,57.79'}
G[1235103]={'948:37.15,47.50'}
G[1235104]={'948:34.14,27.52'}
G[1235105]={'948:33.29,27.27 N:1235104'}
G[1235129]={'949:49.47,70.95'}
G[1235135]={'948:56.30,45.30'}
G[1235141]={'948:50.33,25.80'}
G[1235143]={'948:49.21,37.20'}
G[1235168]={'948:46.92,34.04','In tree'}
G[1235172]={'948:42.17,21.69 N:1234147'}
G[1235282]={'948:71.64,48.59'}
G[1235289]={'948:41.86,50.42'}
G[1235299]={'948:68.42,88.98'}
G[1235300]={'948:63.58,67.37'}
G[1235307]={'948:66.47,56.53'}
G[1235310]={'948:60.87,84.60'}
G[1235313]={'948:40.59,54.98'}
G[1235365]={'948:36.19,54.46'}
G[1235860]={'947:66.97,33.48'}
G[1236140]={'949[19]:34.56,66.76'}
G[1236141]={'949:42.36,83.41'}
G[1236165]={'976:50,50 N:1236206'}	-- Arbitrarily set this to Horde
G[1236206]={'971:31.44,31.04'}	-- Arbitrarily set this to Alliance
G[1236483]={'946:28.39,74.19','In cave'}
G[1236610]={'950:35.47,57.25'}
G[1236935]={'946:70.13,7.11'}
G[1237016]={'947:33.27,30.73'}	-- this exists prior to garrison construction
G[1237021]={'947:26.40,32.88'}	-- this exists prior to garrison construction
G[1237022]={'976:48.51,41.44 N:1233291'}
G[1237705]={'950:79.73,30.23'}
G[1237790]={'947:73.76,55.81'}
G[1237821]={'949:40.32,40.30'}
G[1237946]={'950:40.34,68.63','In cave'}
G[1239120]={'1015[18]:43.92,24.68 1015:47.87,52.08'}	-- the second coordinates is if you have not looked at map in cave
G[1239328]={'1015:65.69,56.92'}
G[1239791]={'971:34.32,32.48'}	-- Alliance version	-- TODO: Make Horde version 976:40,56.2
G[1239902]={'945:58.50,60.45'}	-- Arbitrarily set to Alliance
G[1240003]={'945:36.31,43.50'}
G[1240289]={'945:15.93,49.78','In cave'}
G[1240317]={'945:16.09,44.25'}
G[1240519]={'1018:46.45,86.31 N:1244694'}
G[1240543]={'945:17.01,52.93'}
G[1240547]={'945:32.44,37.40'}
G[1240552]={'1015[17]:68.88,13.24'}
G[1240577]={'945:19.30,40.95'}
G[1240580]={'945:28.73,23.34'}
G[1240605]={'1018:64.70,51.25 N:1244694'}
G[1240609]={'1018:43.39,75.90 N:1244694'}
G[1240612]={'1018:48.68,73.79 N:1244694'}
G[1240614]={'1018:39.95,54.61 N:1244694'}
G[1240616]={'281:68.03,73.87'}
G[1240617]={'43:56.39,49.26'}
G[1240619]={'1018:73.80,32.27 N:1244694'}
G[1240625]={'381:43.03,75.74','Upstairs'}
G[1240629]={'1015:53.18,64.44 N:1208420'}
G[1240630]={'1015:49.65,34.48 N:1244694'}
G[1240631]={'1015:40.57,57.67 N:1208420'}
G[1240634]={'1015:57.87,12.26 N:1208420'}
G[1240635]={'1015:58.38,12.28 N:1208420'}
G[1240637]={'1015:42.62,8.08 N:1240639'}
G[1240638]={'1015:55.88,56.85'}
G[1240639]={'1015:58.35,43.79'}
G[1240641]={'1015:49.41,57.98 N:1208420'}
G[1240642]={'1015:56.45,34.81 N:1208420'}
G[1240643]={'1015:49.36,45.37'}
G[1240644]={'1015:53.03,37.27 N:1244694'}
G[1240645]={'1015[18]:69.26,48.27 N:1240639'}
G[1240646]={'1015:44.47,39.48 N:1208420'}
G[1240651]={'1018:67.39,53.41 N:1244694'}
G[1240652]={'1018:44.34,82.57 N:1208420','In cave under inn'}
G[1240653]={'1018:51.50,77.73 N:1244694','Under trees'}
G[1240654]={'1018:63.37,88.41 N:1244694'}
G[1240690]={'1015:57.15,31.06 N:1208420'}
G[1240855]={'945:32.42,70.40'}
G[1241146]={'1017:42.62,65.80 N:1208420'}
G[1241147]={'1017:40.64,68.52 N:1244694'}
G[1241148]={'1017:48.13,74.22 N:1244694'}
G[1241149]={'1017:42.34,61.13 N:1244694'}
G[1241150]={'1017:35.17,68.98 N:1244694'}
G[1241151]={'1017:52.02,80.59 N:1244694'}
G[1241152]={'1017:46.76,80.40 N:1208420'}
G[1241153]={'1017:50.33,40.99 N:1244694'}
G[1241154]={'1017:49.76,78.00 N:1244694'}
G[1241155]={'1017:39.47,65.19 N:1208420'}
G[1241180]={'1017:35.03,36.59 N:1208420'}
G[1241206]={'1017:41.75,46.04 N:1244694'}
G[1241207]={'1017:44.16,69.97 N:1244694'}
G[1241208]={'1017:32.74,27.92 N:1208420'}
G[1241212]={'1017:33.14,36.08 N:1208420'}
G[1241213]={'1017:39.56,19.32 N:1244694'}
G[1241272]={'1022:19.58,46.87 N:1208420'}
G[1241280]={'1017[9]:19.97,41.27 N:1208420'}
G[1241433]={'945:56.97,65.05'}
G[1241434]={'945:54.82,69.31','Up in a tree'}
G[1241449]={'945:61.24,75.88'}
G[1241450]={'945:62.13,70.73'}
G[1241504]={'945:30.38,71.98'}
G[1241518]={'1017:69.15,44.78 N:1244694'}
G[1241521]={'945:40.61,79.80'}
G[1241522]={'945:40.78,75.58'}
G[1241524]={'945:37.05,46.27'}
G[1241533]={'945:41.58,73.28'}
G[1241557]={'1017:31.11,55.98 N:1208420'}
G[1241558]={'1017:35.73,54.10 N:1208420'}
G[1241560]={'945:22.00,47.77'}
G[1241561]={'945:58.5,25.3'}
G[1241562]={'1017:35.92,47.94 N:1244694'}
G[1241563]={'945:62.60,20.53'}
G[1241564]={'1017:46.60,64.96 N:1244694'}
G[1241565]={'945:26.7,44.3'}
G[1241566]={'945:51.73,24.27'}
G[1241599]={'945:64.59,42.11','In tree'}
G[1241600]={'945:49.90,81.24'}
G[1241601]={'945:49.95,79.62'}
G[1241602]={'945:69.75,55.99'}
G[1241605]={'945:47.90,70.40'}
G[1241656]={'945:50.81,64.99'}
G[1241657]={'945:31.41,31.07'}
G[1241664]={'945:25.3,50.2'}
G[1241665]={'1017:48.00,62.37 N:1208420'}
G[1241666]={'945:46.27,72.77'}
G[1241671]={'945:63.40,28.07'}
G[1241673]={'945:26.54,62.96 N:1241565','Up in tower'}
G[1241674]={'945:34.69,34.65','Down in Vault of Eyes'}
G[1241692]={'945:14.96,54.42','In building'}
G[1241699]={'945:17.36,56.92'}
G[1241712]={'945:35.9,78.6'}
G[1241713]={'945:15.99,59.40','In tower'}
G[1241714]={'945:33.90,78.13'}
G[1241715]={'945:35.03,77.33 N:1241714'}
G[1241716]={'945:34.41,78.30 N:1241714'}
G[1241717]={'1017:49.69,47.33'}
G[1241725]={'945:61.50,45.88 N:1239902'}	-- Arbitrarily set to Horde
G[1241742]={'945:46.87,36.65'}
G[1241745]={'945:46.93,44.36'}
G[1241760]={'945:46.85,42.16'}
G[1241764]={'945:73.64,43.24'}
G[1241767]={'1018:69.43,59.94 N:1208420','In cave'}
G[1241772]={'1018:67.20,59.27 N:1208420','In cave'}
G[1241773]={'1018:70.16,57.00 N:1244694'}
G[1241775]={'945:37.73,80.74'}
G[1241835]={'945:49.95,76.77', 'In cave'}
G[1241840]={'1017:69.82,45.72'}
G[1241841]={'945:48.55,75.21'}
G[1241847]={'945:43.1,38.3'}
G[1241848]={'945:42.85,35.38','Top of tower'}
G[1242242]={'1018:56.03,83.76 N:1244694'}
G[1242249]={'945:28.86,34.59','In cave'}
G[1242250]={'1018:54.94,80.56 N:1244694','Under water, in cave'}
G[1242328]={'1018:48.99,86.14 N:1244694'}
G[1242346]={'1018:60.49,82.14 N:1244694'}
G[1242446]={'1018:59.89,72.26 N:1244694'}
G[1242642]={'1018:62.79,70.32 N:1244694'}
G[1242643]={'1018:63.03,76.96 N:1244694'}
G[1242644]={'1018:62.06,67.36 N:1208420','In cave'}
G[1242645]={'1018:56.22,57.30 N:1244694'}
G[1242646]={'1018:68.33,40.61 N:1244694'}
G[1242647]={'1018:65.38,86.26 N:1208420'}
G[1242649]={'945:51.64,32.64'}
G[1242660]={'1018:42.66,58.01 N:1244694'}
G[1242662]={'1018:38.64,67.18 N:1244694'}
G[1242663]={'1018:38.45,65.32 N:1244694'}
G[1242664]={'1018:33.81,58.26 N:1208420'}
G[1242665]={'1018:45.09,61.15 N:1244694'}
G[1242666]={'1018:43.23,54.87 N:1208420'}
G[1242667]={'1018:40.51,44.70 1018[13]:41.99,88.45 N:1244694'}
G[1242668]={'1018[13]:50.85,51.63 1018:40.99,42.69 N:1240639'}
G[1242669]={'1018:61.63,73.69 N:1244694'}
G[1242670]={'1018:61.08,34.21 N:1208420'}
G[1242671]={'1018:61.01,79.18 N:1240639'}
G[1242675]={'1018:54.18,70.59 N:1244694'}
G[1242678]={'1018:54.51,60.48 N:1208420'}
G[1242683]={'1018:63.27,74.01 N:1208420'}
G[1242959]={'1018:66.56,40.91 N:1208420'}
G[1243402]={'1024:39.00,37.32'}
G[1243454]={'1017:57.65,71.88'}
G[1243690]={'945:65.88,85.04'}
G[1243693]={'945:54.94,90.65'}
G[1243700]={'1017:72.40,61.00'}
G[1243773]={'1024:47.64,44.06 N:1208420'}
G[1243798]={'1080[6]:63.49,59.32'}
G[1243836]={'1017:46.73,44.44'}
G[1243912]={'971:43.73,51.59 N:500022'}
G[1244446]={'1024:52.40,51.50'}
G[1244453]={'1017:36.74,31.12'}
G[1244466]={'1028:69.84,37.50'}
G[1244494]={'1024:39.53,57.44 N:1208420'}
G[1244519]={'1024:53.60,51.04 N:1208420'}
G[1244555]={'1014[10]:38.00,29.67'}
G[1244559]={'1022:34.17,27.92'}
G[1244692]={'1028:63.42,54.17 N:1244694'}
G[1244694]={'1028:54.78,59.26'}
G[1244708]={'1017:63.00,48.61'}
G[1244887]={'1017:58.04,47.52 N:1244694'}
G[1244899]={'1017:73.32,41.50 N:1244694'}
G[1244901]={'1017:68.97,41.83 N:1208420'}
G[1244902]={'1017:59.31,58.46 N:1208420'}
G[1244903]={'1017:61.81,62.78 N:1208420'}
G[1244904]={'1017:57.94,63.34 N:1244694'}
G[1244905]={'1017:62.65,73.60 N:1244694','Top of tower'}
G[1244909]={'1017:61.41,44.40 N:1244694'}
G[1244912]={'1017:60.84,42.73 N:1208420'}
G[1244913]={'1017:55.01,47.14 N:1208420'}
G[1244917]={'1017:81.86,67.50 N:1208420'}
G[1244923]={'1032[1]:77.91,35.63'}
G[1244928]={'1017:68.46,29.60 N:1240639'}
G[1245328]={'1033:30.27,39.66'}
G[1245528]={'1024:39.38,62.28 N:1208420'}
G[1245529]={'1080:32.37,41.67 N:1244694'}
G[1245530]={'1024:37.14,57.74 N:1240639'}
G[1245531]={'1024:37.35,33.79 N:1244694'}
G[1245532]={'1024[31]:34.30,80.46 N:1208420'}
G[1245533]={'1024:42.20,27.31 N:1208420'}
G[1245534]={'1024:42.50,35.03 N:1244694'}
G[1245535]={'1024:45.55,34.59 N:1244694'}
G[1245536]={'1024:46.67,28.13 N:1240639'}
G[1245537]={'1024:54.18,41.60 N:1240639'}
G[1245538]={'1024:53.46,43.55 N:1244694'}
G[1245542]={'1024:36.62,62.14 N:1208420'}
G[1245545]={'1080:13.71,55.42 N:1244694'}
G[1245547]={'1024:53.04,52.22 N:1244694','In cave'}
G[1245548]={'1024[16]:60.66,25.11 N:1208420'}
G[1245550]={'1024:50.98,36.46 N:1208420','In cave'}
G[1245553]={'1024:50.98,38.80 N:1208420'}
G[1245579]={'1024:52.03,32.42 N:1208420'}
G[1245580]={'1024:50.81,35.05 N:1244694'}
G[1245581]={'1024:46.81,40.14 N:1244694'}
G[1245601]={'1024[29]:60.52,54.68 N:1244694'}
G[1245602]={'1024:47.03,72.69 N:1208420'}
G[1245603]={'1024:43.75,72.75 N:1244694'}
G[1245688]={'1033:49.10,34.32'}
G[1245793]={'32:52.32,33.80'}
G[1246037]={'1015:55.63,18.55 N:1208420'}
G[1246205]={'1015:66.06,43.44 N:1244694'}
G[1246206]={'1015:58.64,53.38 N:1244694'}
G[1246254]={'1033:52.74,31.31'}
G[1246353]={'1028:82.08,50.44 N:1244694'}
G[1246438]={'161:69.55,68.46'}
G[1246463]={'1014[12]:40.98,52.30'}
G[1246465]={'1014[12]:39.89,58.33'}
G[1246466]={'1014[12]:45.84,65.30 N:1248534'}
G[1246555]={'1032[1]:58.68,34.72 N:1244694'}
G[1246556]={'1032[1]:47.34,54.63 N:1244694'}
G[1246557]={'1032[2]:32.09,48.17 N:1244694'}
G[1246558]={'1032[2]:41.41,32.86 N:1244694'}
G[1246559]={'1032[2]:57.04,40.18 N:1244694'}
G[1246560]={'1032[2]:41.47,63.59 N:1244694'}
G[1246561]={'1032[3]:24.44,9.94 N:1244694'}
G[1246562]={'1032[3]:17.98,81.04 1032[3]:23.23,81.63 N:1244694'}
G[1246713]={'1033:36.10,47.24'}
G[1246884]={'1033:30.82,85.02'}
G[1246885]={'1033:31.19,85.23'}
G[1246944]={'1014[10]:42.78,27.09'}
G[1247694]={'1033:20.92,52.29'}
G[1247704]={'1018:49.39,49.25'}
G[1248534]={'1018:53.47,55.96'}
G[1249997]={'1015:59.88,63.19 N:1244694'}
G[1250080]={'1015:62.38,58.40 N:1244694'}
G[1250081]={'1015:62.99,54.17 N:1244694'}
G[1250083]={'1015:52.01,42.11 N:1244694'}
G[1250084]={'1015:53.62,44.15 N:1244694'}
G[1250085]={'1015:53.49,45.46 N:1244694'}
G[1250087]={'1015[17]:62.02,83.83 N:1244694'}
G[1250088]={'1015[17]:71.71,21.60 N:1244694'}
G[1250090]={'1015:54.41,36.34 N:1244694'}
G[1250091]={'1015:55.37,27.74 N:1244694'}
G[1250092]={'1015:51.53,24.33 N:1208420'}
G[1250097]={'1015:50.20,50.29 N:1244694'}
G[1250098]={'1015[18]:45.36,66.87 1015:48.01,56.24 N:1244694'}	-- second value is outer map version of cave point
G[1250102]={'1015:41.39,30.75 N:1208420'}
G[1250103]={'1015:63.64,39.17 N:1244694'}
G[1250104]={'1015:62.81,44.79 N:1244694'}
G[1250106]={'1015:47.85,7.73 N:1244694'}
G[1250107]={'1015:43.41,22.39 N:1240639'}
G[1250108]={'1015:57.19,25.23 N:1244694'}
G[1250383]={'1033:17.26,37.73'}
G[1250536]={'1017:49.98,32.66'}
G[1250541]={'1024:52.54,66.38 N:1244694'}
G[1250548]={'1065:19.34,56.80'}
G[1250612]={'1017:51.42,57.35'}
G[1250984]={'1017:72.12,54.88 N:1244694'}
G[1250985]={'1017:75.15,49.47 N:1208420'}
G[1250987]={'1017:73.96,52.24 N:1244694'}
G[1250990]={'1017:75.53,50.80'}
G[1251032]={'1033:65.69,62.68'}
G[1251124]={'1024[29]:59.46,41.16'}
G[1251218]={'1017:64.97,59.11'}
G[1251220]={'1017:64.91,58.91'}
G[1251221]={'1017:64.99,58.96'}
G[1251425]={'1018:66.82,75.67'}
G[1251552]={'1015:65.47,29.56 N:1244694'}
G[1251571]={'1017:63.45,64.74'}
G[1251670]={'1014[10]:47.99,41.72 N:500022'}
G[1251671]={'1014[10]:41.48,64.00 N:500022'}
G[1251713]={'1017:65.58,57.38 N:1244694'}
G[1251714]={'1017:6999,67.17 N:1244694'}
G[1251716]={'1017:42.47,34.08 N:1240639','Top of statue'}
G[1251720]={'1017:82.40,54.53 N:1244694'}
G[1251723]={'1017:73.14,45.68 N:1244694'}
G[1251737]={'1017:50.05,18.17 N:1244694'}
G[1251738]={'1017:32.07,47.20 N:1208420'}
G[1251761]={'1017:65.37,43.11 N:1244694'}
G[1251762]={'1017:49.08,59.99 N:1244694'}
G[1251764]={'1017:37.20,38.66 N:1244694'}
G[1251772]={'1017:73.98,58.59 N:1244694'}
G[1251776]={'1017:43.16,40.49 N:1244694'}
G[1251780]={'1017:43.69,80.10 N:1244694'}
G[1251782]={'1017:44.98,38.23 N:1244694'}
G[1251820]={'1017:47.45,34.10 N:1208420'}
G[1251853]={'1017:75.67,60.60 N:1244694'}
G[1251854]={'1017:71.93,44.24 N:1244694'}
G[1251856]={'1017:74.41,41.84 N:1244694'}
G[1251857]={'1017:78.42,71.39 N:1208420'}
G[1251870]={'1017:68.89,26.05'}
G[1251991]={'1041[3]:50.86,88.18'}
G[1251992]={'1014[12]:49.45,62.52'}
G[1252107]={'1033[23]:53.60,36.77 1033:39.32,76.28'}
G[1252258]={'1033:64.66,37.60'}
G[1252259]={'1033:58.89,38.15 N:1252258'}
G[1252260]={'1033[37]:53.75,45.16 N:1252258'}
G[1252261]={'1033[38]:48.59,48.28 1033:22.44,15.41 N:1252258'}
G[1252262]={'1033[33]:66.32,52.44 N:1252258'}
G[1252263]={'1033[33]:58.02,75.20 N:1252258'}
G[1252264]={'1033:27.22,86.45 N:1252258'}
G[1252806]={'1033[23]:54.63,37.94 N:1244694'}
G[1252807]={'1033[32]:38.63,54.11 N:1244694'}
G[1252808]={'1033[33]:48.66,42.63 N:1244694'}
G[1252810]={'1033:23.40,48.78 N:1244694'}
G[1252814]={'1033:30.83,11.03'}
G[1252815]={'1033:43.69,79.25 N:1252814'}
G[1252816]={'1033:43.41,60.55 N:1252814'}
G[1252817]={'1033:42.03,35.25 N:1252814'}
G[1252828]={'1033:48.14,33.99 N:1244694'}
G[1252829]={'1033:52.27,29.90 N:1244694'}
G[1252835]={'1033:76.86,61.50 N:1244694'}
G[1252836]={'1033:81.96,57.46 N:1244694'}
G[1252876]={'1033:55.69,54.80 N:1244694'}
G[1252880]={'1033:61.35,55.49 N:1208420'}
G[1252881]={'1033:57.36,60.54 N:1208420'}
G[1252882]={'1033:57.68,61.97 N:1208420'}
G[1252883]={'1033:54.32,60.32 N:1208420'}
G[1254024]={'1015:34.58,35.56 N:1244694'}
G[1254025]={'1015:68.86,29.74 N:1244694','In cave under water'}
G[1254027]={'1015:53.62,18.13 N:1244694'}
G[1254028]={'1015:26.25,47.15 N:1244694'}
G[1254126]={'1018:73.82,54.37 N:1244694'}
G[1254127]={'1018:62.70,85.26 N:1244694'}
G[1254141]={'1018:63.91,45.57 N:1244694'}
G[1258690]={'1015:54.86,52.14 N:1244694'}
G[1258978]={'32[24]:39.07,73.76'}
G[1258979]={'1045[3]:54.75,35.75'}
G[1259862]={'946:43.53,71.85'}
G[1259863]={'950:80.57,47.66'}
G[1259864]={'949:43.92,93.83'}
G[1259865]={'1015:48.30,29.65'}
G[1259866]={'1018:44.85,57.88'}
G[1259867]={'1024:55.56,84.47'}
G[1259868]={'1017:32.53,42.00'}
G[1259870]={'941:72.71,65.23'}
G[1259871]={'947:42.77,35.81'}
G[1259926]={'1033:30.31,45.27'}
G[1259927]={'1033:22.90,58.38'}
G[1265435]={'1033:36.86,46.45'}
G[1265532]={'1033:51.99,78.75'}
G[1268478]={'1021:53.34,80.45'}
G[1268703]={'1021:41.27,59.38'}
G[1269043]={'1018:51.32,78.46 N:1244694'}
G[1271103]={'1170:46.77,68.99'}
G[1271124]={'1035:31.78,57.73'}
G[1272456]={'1135:62.61,25.82'}
G[1273222]={'1135:68.56,60.51 N:1272456'}
G[1273407]={'1170:63.33,22.53'}
G[1273415]={'1170:53.36,8.47 N:1273407'}
G[1273519]={'1171:68.45,70.81 N:1273523'}
G[1273521]={'1171:51.86,34.10 N:1273523'}
G[1273523]={'1171:59.08,19.42'}	-- this seems old 1171:64.15,23.05
G[1273527]={'1171:65.56,28.28 N:1273523'}
G[1273538]={'1171:62.09,45.83 N:1273523'}
G[1280948]={'261:29.59,69.44'}
G[3234618]={'948:42.42,26.67 N:1234618'}
G[3243912]={'976:47.08,37.93 A:1243912 N:500022'}
G[5102700]={'1068[2]:60.43,34.52 A:102700 N:102700'}
G[5103092]={'1068[1]:81.59,60.22 A:103092 N:103092'}
G[5106558]={'1076[2]:43.65,38.81 A:106558 N:106558'}
G[100001307]={'D:13159 Q:123'}
G[100001357]={'D:515,126,456,171,513 Q:26353'}
G[100003082]={'D:1658 Q:25030'}
G[100004854]={'D:3056 Q:770'}
G[100005179]={'D:3535 Q:927'}
G[100008244]={'D:8301,8299,45258,45262,45257,7846,8298,45260,8302,8303,8297,8300,8304,8296,42334 Q:25772'}
G[100008623]={'D:5457,7269,5419 Q:351'}
G[100008704]={'D:2650,2653,2654,2707,4468,7995,42536,42555,42609 Q:485'}
G[100008705]={'D:39896 Q:25475'}
G[100009326]={'D:6212 Q:2945'}
G[100010593]={'D:8301,8299,45258,45262,45257,7846,8298,45260,8302,8303,8297,8300,8304,8296,42334 Q:25771'}
G[100012842]={'D:10738 Q:28471'}
G[100016303]={'D:12678 Q:23'}
G[100016304]={'D:12677 Q:24'}
G[100016305]={'D:12676 Q:2'}
G[100016408]={'D:12759 Q:1918'}
G[100016782]={'D:12876 Q:6922'}
G[100017203]={'Q:7604'}
G[100018356]={'Z699 Q:7498'}
G[100018357]={'Z699 Q:7499'}
G[100018358]={'Z699 Q:7500'}
G[100018359]={'Z699 Q:7501'}
G[100018360]={'Z699 Q:7502'}
G[100018361]={'Z699 Q:7503'}
G[100018362]={'Z699 Q:7504'}
G[100018363]={'Z699 Q:7505'}
G[100018364]={'Z699 Q:7506'}
G[100018628]={'D:12944 Q:7604'}
G[100018706]={'D:1179697 Q:7810'}
G[100018769]={'Created Q:7649'}
G[100018770]={'Created Q:7650 N:100018769'}
G[100018771]={'Created Q:7651 N:100018769'}
G[100018987]={'D:9046 Q:7761'}
G[100019002]={'D:11583 Q:7783'}
G[100019003]={'D:11583 Q:7781 N:100019002'}
G[100019016]={'D:14347 Q:7785'}	-- TODO: Technically should not be D: since you get it if you have one of two other objects...another thing to think about
G[100019018]={'D:14435 Q:7787'}
G[100019228]={'Created Q:7907'}
G[100019257]={'Created Q:7928'}
G[100019267]={'Created Q:7929'}
G[100019277]={'Created Q:7927'}
G[100019423]={'Created Q:7937'}
G[100019424]={'Created Q:7938'}
G[100019443]={'Created Q:7944'}
G[100019452]={'Created Q:7945'}
G[100019802]={'Preowned Q:8183'}
G[100020461]={'D:11732,11730,13136 Q:8308'}
G[100020483]={'D:15298 Q:8338'}
G[100020644]={'Preowned Q:8446'}
G[100020741]={'D:7156,7157,7158 Q:8470'}
G[100020765]={'D:15968 Q:8482'}
G[100021220]={'D:15339 Q:8791'}
G[100021221]={'D:15727 Q:8801'}
G[100021230]={'Z766 Q:8784'}
G[100021776]={'D:15670 Q:8887'}
G[100022597]={'D:16314 Q:9175'}
G[100022727]={'Preowned Q:9250'}
G[100022733]={'Preowned Q:9251'}
G[100023179]={'321[1]:46.16,37.49 Q:9324'}	-- this is the location of "Flame of Orgrimmar" that you need to click to get the item
G[100023180]={'362:21.45,27.02 Q:9325'}	-- this is the location of "Flame of Thunder Bluff" that you need to click to get the item
G[100023181]={'382:68.25,8.83 Q:9326'}	-- this is the location of "Flame of the Undercity" that you need to click to get the item
G[100023182]={'301:49.79,72.68 Q:9330'}	-- this is the location of "Flame of Stormwind" that you need to click to get the item
G[100023183]={'341:64.47,24.94 Q:9331'}	-- this is the location of "Flame of Ironforge" that you need to click to get the item
G[100023184]={'381:63.99,47.03 Q:9332'}	-- this is the location of "Flame of Darnassus" that you need to click to get the item
G[100023228]={'D:15409 Q:8474'}
G[100023249]={'D:15407 Q:9360'}
G[100023338]={'D:16857 Q:9373'}
G[100023580]={'D:17084 Q:9418'}
G[100023678]={'Z464 Q:9455'}
G[100023759]={'Z464 Q:9514'}
G[100023777]={'D:6073,6115,11697 Q:26443'}
G[100023797]={'D:6073,6115,11697 Q:26447 N:100023777'}
G[100023837]={'Z476 Q:9550'}
G[100023850]={'Z464 Q:9564'}
G[100023870]={'Z476 Q:9576'}
G[100023900]={'D:17528 Q:9594'}
G[100023910]={'Z464 Q:9616'}
G[100024132]={'Mailbox476 Q:9672'}	-- moved from Z464
G[100024330]={'Z467 Q:9731'}
G[100024367]={'Z727 Q:9764'}
G[100024407]={'Z467 Q:9875'}
G[100024414]={'D:16522 Q:9798'}
G[100024483]={'D:18124 Q:9827'}
G[100024484]={'D:18124 Q:9828 N:100024483'}
G[100024504]={'Z477 Q:9861'}
G[100024558]={'Z477 Q:9872'}
G[100024559]={'Z477 Q:9871 N:100024558'}
G[100025459]={'D:18285 Q:9911'}
G[100028552]={'Z465 Q:10229'}
G[100029233]={'Z479 Q:10182'}
G[100029234]={'Z479 Q:10305'}
G[100029235]={'Z479 Q:10306'}
G[100029236]={'Z479 Q:10307'}
G[100029476]={'D:19188 Q:10134'}
G[100029588]={'Z465 Q:10395'}
G[100029590]={'Z465 Q:10393 N:100029588'}
G[100029738]={'D:20779 Q:10413'}
G[100030431]={'D:19995,19998 Q:10524'}
G[100030579]={'D:21499 Q:10623'}
G[100030756]={'D:21499 Q:10621 N:100030579'}
G[100031120]={'D:21810 Q:10719'}
G[100031345]={'Z473 Q:10793'}
G[100031363]={'Z475 Q:10797'}
G[100031384]={'Z475 Q:10810'}
G[100031489]={'D:19990 Q:10825'}
G[100031707]={'Z478 Q:10880'}
G[100031890]={'Created Q:10938'}
G[100031891]={'Created Q:10939'}
G[100031907]={'Created Q:10940'}
G[100031914]={'Created Q:10941'}
G[100032385]={'Z779 Q:11002'}
G[100032386]={'Z779 Q:11003 N:100032385'}
G[100032405]={'Z782 Q:11007'}
G[100032523]={'D:23066 Q:11021'}
G[100032621]={'D:23267 Q:11041'}
G[100032726]={'D:23286,23324 Q:11081'}
G[100033289]={'Z491 Q:11237'}
G[100033314]={'Z491 Q:11249'}
G[100033345]={'Z491 Q:11260 N:100033314'}
G[100033347]={'Z491 Q:11266 N:100033289'}
G[100033961]={'Z491 Q:11395'}
G[100033962]={'Z491 Q:11398 N:100033961'}
G[100034090]={'D:24018 Q:11452'}
G[100034091]={'D:24018 Q:11453 N:100034090'}
G[100034469]={'Z467 Q:11531'}
G[100034777]={'Z486 Q:11632'}
G[100034815]={'Z486 Q:11654'}
G[100034984]={'Z486 Q:11729'}
G[100035568]={'480:69.17,43.42 Q:11935'}	-- this is the location of "Flame of Silvermoon" that you need to click to get the item
G[100035569]={'471:41.12,26.11 Q:11933'}	-- this is the location of "Flame of the Exodar" that you need to click to get the item
G[100035648]={'Z486 Q:11941'}
G[100035723]={'Z728 Q:11972'}
G[100036742]={'Z488 Q:12055'}
G[100036744]={'Z488 Q:12057'}
G[100036746]={'Z488 Q:12059 N:100036742'}
G[100036756]={'Z488 Q:12067'}
G[100036780]={'Z488 Q:12085'}
G[100036855]={'Z488 Q:12146'}
G[100036856]={'Z488 Q:12147 N:100036855'}
G[100036940]={'D:27546 Q:12105'}
G[100036958]={'Z488 Q:12168'}
G[100037163]={'Created Q:12517'}
G[100037164]={'Created Q:12798'}
G[100037432]={'Z488 Q:12271'}
G[100037571]={'Created Q:12278 N:100037736'}
G[100037599]={'Created Q:12306 N:100037736'}
G[100037736]={'Created Q:12420'} -- technically bought for 200 tokens
G[100037737]={'Created Q:12421 N:100037736'} -- technically bought for 200 tokens
G[100037830]={'Z490 Q:12423 N:100036940'}
G[100037833]={'Z488 Q:12419'}
G[100038280]={'Z704 Q:12491'}
G[100038281]={'Z704 Q:12492 N:100038280'}
G[100038321]={'D:28034,28035,28036 Q:12507'}
G[100038567]={'D:4656 Q:14330'}
G[100038660]={'D:28519 Q:12631'}
G[100038673]={'D:28519 Q:12633'}
G[100040666]={'Z492 Q:12839'}
G[100041267]={'Z495 Q:12888'}
G[100041556]={'D:29375 Q:12922'}
G[100042203]={'D:29380 Q:12979'}
G[100042772]={'Z492 Q:13043'}
G[100043039]={'Created Q:12517 N:100037163'}
G[100043242]={'Z492 Q:13136'}
G[100043297]={'Z492 Q:13148'}
G[100043512]={'Z522 Q:13204'}
G[100043876]={'Q13265,13268,13269,13270,13272'}	-- perhaps not related
G[100044148]={'Created Q:12518'}
G[100044158]={'Created Q:13311'}
G[100044259]={'Created Q:13324'}
G[100044276]={'Created Q:13325'}
G[100044294]={'Created Q:13327'}
G[100044326]={'Created Q:13326'}
G[100044569]={'Z535 Q:13372'}
G[100044577]={'Z535 Q:13375'}
G[100044725]={'Z495 Q:13420'}
G[100044927]={'D:33022 Q:13557'}
G[100044979]={'D:32863 Q:13506'}
G[100045040]={'D:32970 Q:13510'}
G[100045506]={'Z529 Q:13604'}
G[100045857]={'Z529 Q:13817 N:100045506'}
G[100045858]={'Created Q:6607,13826'}
G[100046004]={'Z504 Q:13845'}
G[100046052]={'Z529 Q:13631'}
G[100046053]={'A:32871 Q:13819 N:100046052'}
G[100046128]={'Z43 Q:13868'}
G[100046318]={'D:32862 Q:13591'}
G[100046544]={''}
G[100046545]={''}
G[100046856]={'Z605 Q:28607'}
G[100046955]={'Z492 Q:14095'}
G[100047039]={'D:35095 Q:14127'}
G[100048679]={'Z504 Q:14203'}
G[100049010]={'D:4667,4664,4663,4666,4665 Q:14232'}
G[100049200]={'D:35591 Q:14344'}
G[100049203]={'D:4667,4664,4663,4666,4665 Q:14362 N:100049010'}
G[100049220]={'D:35591 Q:14376 N:100049200'}
G[100049643]={'D:10184 Q:24429'}
G[100049644]={'D:10184 Q:24428 N:100049643'}
G[100049667]={'Z504 Q:24431 N:100048679'}
G[100049676]={'Z492 Q:24442'}
G[100049776]={'Z607 Q:24518'}
G[100049932]={'Z607 Q:24606'}
G[100050320]={'D:36296 Q:14483,24745'}
G[100050379]={'Z601 Q:14443'}
G[100050380]={'Z601 Q:24554 N:100050379'}
G[100051315]={'Z604 Q:24914'}
G[100052079]={'D:1535 Q:24979'}
G[100052197]={'Z640 Q:25047'}
G[100052843]={'Q:28799,28803,28804'}
G[100053053]={'D:39918 Q:25377'}
G[100054345]={'D:40276 Q:25467'}
G[100054614]={'D:40510 Q:25442'}
G[100054639]={'D:41183 Q:25503'}
G[100055166]={'D:39896 Q:25451'}
G[100055167]={'D:39896 Q:25454'}
G[100055181]={'D:40905 Q:25647'}
G[100055186]={'D:41017 Q:25419'}
G[100055243]={'D:41167 Q:25736'}
G[100056474]={'D:41937 Q:26016'}
G[100056571]={'D:41925,41926 Q:26019'}
G[100056812]={'D:41925,41926 Q:26090 N:100056571'}
G[100056836]={'Created Q:29396,29397'}
G[100057102]={'D:41652,41657 Q:26144'}
G[100057118]={'D:41652,41657 Q:26149 N:100057102'}
G[100057935]={'D:114 Q:26252'}
G[100058117]={'D:42677 Q:26296'}
G[100058491]={'D:1142,1144 Q:26407'}
G[100058898]={'D:430,445,446 Q:26519'}
G[100059143]={'D:43454 Q:26617'}
G[100060816]={'D:43158 Q:27100'}
G[100060956]={'D:45301,46657 Q:27322'}
G[100061310]={'D:45728 Q:27480 N:45728'}
G[100061378]={'D:45867,45868 Q:27551'}
G[100061505]={'D:45896 Q:27574'}
G[100062021]={'Created Q:27664'}
G[100062044]={'Created Q:27666'}
G[100062045]={'Created Q:27665'}
G[100062046]={'Created Q:27667'}
G[100062056]={'Created Q:27675'}
G[100062138]={'D:40987 Q:27687'}
G[100062281]={'D:39638,41227 Q:27716'}
G[100062282]={'D:39638,41227 Q:27717 N:100062281'}
G[100062483]={'D:46590,46920,47014 Q:27760'}
G[100062768]={'D:46993 Q:27925,28132'}
G[100062933]={'D:14636 28:45,30.8 Q:28058'} -- from Pillaclencher's Ornate Pillow
G[100063090]={'D:47759 Q:28154'}
G[100063127]={'Q:28798'}
G[100063128]={'Q:29261,29262'}
G[100063250]={'D:47789 Q:28196'}
G[100063276]={'Created Q:27686 N:100062056'}
G[100063686]={'D:2368,2369,2370,2371 Q:28356'}
G[100063700]={'D:48428 Q:28376'}
G[100064353]={'D:10916,7438,7439,7440,7441,7442 Q:28462'}
G[100064397]={'Q:28800,28801,28802'}
G[100064450]={'D:48764 Q:28529'}
G[100065894]={'Z708 Q:28777'}
G[100065895]={'Z720 Q:28778'}
G[100065896]={'Z720 Q:28775'}
G[100065897]={'Z720 Q:28776'}
G[100069854]={'Mailbox Q:29298'}
G[100071635]={'Z823'} -- bogus zone just to get it to appear
G[100071636]={'Z823'} -- bogus zone just to get it to appear
G[100071637]={'Z823'} -- bogus zone just to get it to appear
G[100071638]={'Z823'} -- bogus zone just to get it to appear
G[100071715]={'Z823'} -- bogus zone just to get it to appear
G[100071716]={'Z823'} -- bogus zone just to get it to appear
G[100071951]={'Z823'} -- bogus zone just to get it to appear
G[100071952]={'Z823'} -- bogus zone just to get it to appear
G[100071953]={'Z823'} -- bogus zone just to get it to appear
G[100074642]={'Z807 Q:30414'}
G[100074643]={'Z807 Q:30439'}
G[100074644]={'Z807 Q:30390'}
G[100074645]={'Z807 Q:30408'}
G[100074647]={'Z807 Q:30402'}
G[100074649]={'Z807 Q:30396'}
G[100074651]={'Z807 Q:30386'}
G[100074652]={'Z807 Q:30433'}
G[100074654]={'Z807 Q:30421'}
G[100074655]={'Z807 Q:30427'}
G[100077957]={'D:54590,54968 Q:30105'}
G[100078960]={'Z806 Q:30140'}
G[100078961]={'Z806 Q:30141'}
G[100078962]={'Z806 Q:30139'}
G[100079264]={'Z807 Q:30422'}
G[100079265]={'Z807 Q:30425'}
G[100079266]={'Z807 Q:30424'}
G[100079267]={'Z807 Q:30423'}
G[100079268]={'Z807 Q:30389'}
G[100079323]={'Created Q:30452'}
G[100079326]={'Created Q:30451'}
G[100080240]={'Z807 Q:30597'}	-- actually any Pandaria zone
G[100080241]={'D:59335 Q:30582'}
G[100080827]={'D:60299 Q:30675'}
G[100082870]={'D:61970 Q:31023'}
G[100083767]={'D:56833 Q:29758'}
G[100083769]={'Mailbox Q:31055'}
G[100083770]={'Mailbox Q:31093'}
G[100083771]={'Mailbox Q:31094'}
G[100083772]={'Mailbox Q:31095'}
G[100083773]={'Mailbox Q:31097'}
G[100083774]={'Mailbox Q:31096'}
G[100083777]={'Mailbox Q:31100'}
G[100083779]={'Mailbox Q:31102'}
G[100083780]={'Mailbox Q:31103'}
G[100085477]={'Created Q:31794'}
G[100085557]={'Created Q:31795'}
G[100085558]={'Created Q:31796'}
G[100085783]={'D:63809 Q:31261'}
G[100086404]={'D:59639 Q:31312'}
G[100086425]={'Q:31332'}
G[100086433]={'D:59119,59121 Q:31325'}	-- TODO: Make this available from the chief one kills as well
G[100086434]={'D:59119,59121 Q:31326'}
G[100086435]={'D:59123 Q:31328'}
G[100086436]={'D:59123 Q:31329'}
G[100086542]={'Z806 Z807 Z809 Z810 Z811 Z873 Z951 Q:31443'}	-- From Fishing in Jade Forest
G[100086544]={'Z858 Q:31444'}	-- From Fishing in Dread Wastes
G[100086545]={'Z857 Q:31446'}	-- From Fishing in Krasarang Wilds
G[100087871]={'D:65229 Q:31598'}
G[100087878]={'D:64724 Q:31599'}
G[100088715]={'D:65502 Q:31677'}
G[100089155]={'Z806 Q:31784'}
G[100089169]={'Created Q:31786'}
G[100089170]={'Created Q:31787'}
G[100089171]={'Created Q:31788'}
G[100089172]={'Created Q:31789'}
G[100089173]={'Created Q:31790'}
G[100089174]={'Created Q:31791'}
G[100089175]={'Created Q:31792'}
G[100089176]={'Created Q:31793'}
G[100089178]={'Created Q:31797'}
G[100089179]={'Created Q:31798'}
G[100089180]={'Created Q:31799'}
G[100089181]={'Created Q:31800'}
G[100089182]={'Created Q:31801'}
G[100089183]={'Created Q:31802'}
G[100089184]={'Created Q:31803'}
G[100089185]={'Created Q:31804'}
G[100089209]={'Created Q:31805'}
G[100089317]={'D:60491 Q:31809'}
G[100089812]={'D:58706 Q:31936'}	-- TODO: Need to make a "Buy from" instead of kill :-)
G[100089813]={'D:58706 Q:31937'}
G[100089814]={'D:58706 Q:31938'}
G[100091819]={'Q:32161'}
G[100091821]={'Q:32162'}
G[100091822]={'Q:32163'}
G[100091854]={'D:67881 Q:32164 N:100091819'}
G[100091855]={'D:67881 Q:32165 N:100091821'}
G[100091856]={'D:67881 Q:32166 N:100091822'}
G[100092441]={'Created Q:32295'}
G[100094721]={'D:69461 Q:32621'}
G[100094862]={'D:69461 Q:32630'}
G[100095383]={'Created Q:32686'}
G[100095384]={'Created Q:32687'}
G[100095385]={'Created Q:32688'}
G[100095386]={'Created Q:32689'}
G[100095387]={'Created Q:32690'}
G[100095388]={'Created Q:32691'}
G[100095389]={'Created Q:32692'}
G[100095390]={'Created Q:32693'}
G[100097979]={'Q:32838'}
G[100097982]={'Q:32844'}
G[100097985]={'D:43929,77789 Q:32850'}
G[100097986]={'Q:32852'}
G[100097988]={'Q:32856'}
G[100102225]={'D:1222684 Q:32974'}
G[100104257]={'Q:33239'}
G[100104264]={'Q:33234'}
G[100104265]={'Q:33235'}
G[100104266]={'D:72842,72843,72844,73160 Q:33236'}
G[100104267]={'Q:33238'}
G[100109121]={'D:77106 Q:34067'}
G[100109258]={'Q:37669'}
G[100111812]={'Q:37669'}
G[100111813]={'Q:37669'}
G[100111814]={'Q:37669'}
G[100111815]={'Q:37669'}
G[100111816]={'Q:37669'}
G[100111817]={'Q:37669'}
G[100111818]={'Q:37669'}
G[100112378]={'D:80714 Q:35021'}
G[100112566]={'D:74254 Q:35058 N:100113103'}
G[100113080]={'D:80586 Q:33928'}
G[100113103]={'D:75043 Q:35342'}
G[100113107]={'Q:35356'}
G[100113109]={'Q:35377'}
G[100113260]={'D:80714 Q:35642 N:100112378'}
G[100113448]={'D:81528 Q:35811'}
G[100113449]={'D:81528 Q:35812 N:100113448'}
G[100113453]={'D:80785 Q:35813'}
G[100113454]={'D:80785 Q:35814 N:100113453'}
G[100113461]={'D:81537 Q:35820'}
G[100113586]={'D:81775 Q:35944'}
G[100113590]={'D:81775 Q:35948 N:100113586'}
G[100114018]={'D:81240 Q:36075'}
G[100114019]={'D:81240 Q:36076 N:100114018'}
G[100114020]={'D:80685 Q:36078'}
G[100114021]={'D:80685 Q:36080 N:100114020'}
G[100114022]={'D:80689 Q:36081'}
G[100114023]={'D:80689 Q:36083 N:100114022'}
G[100114024]={'D:80696 Q:36084'}
G[100114025]={'D:80696 Q:36086 N:100114024'}
G[100114026]={'D:81617 Q:36090'}
G[100114027]={'D:81617 Q:36091 N:100114026'}
G[100114029]={'D:81630 Q:36092'}
G[100114030]={'D:81630 Q:36094 N:100114029'}
G[100114031]={'D:85779 Q:36096'}
G[100114032]={'D:85779 Q:36097 N:100114031'}
G[100114033]={'D:85695 Q:36098'}
G[100114034]={'D:85695 Q:36101 N:100114033'}
G[100114035]={'D:85694 Q:36103'}
G[100114036]={'D:85694 Q:36104 N:100114035'}
G[100114037]={'D:83458,81685,80725,78257,86439,85924 Q:36105'}
G[100114038]={'D:83458,81685,80725,78257,86439,85924 Q:36106 N:100114037'}
G[100114054]={'Q:36109'}
G[100114146]={'Created Q:36744'}
G[100114877]={'D:75043 Q:36176'}
G[100114965]={'D:74254 Q:36205'}
G[100114972]={'D:75043 Q:36236'}
G[100114973]={'D:74254 Q:36301'}
G[100114984]={'D:75043 Q:36239'}
G[100115008]={'D:74254 Q:36255'}
G[100115278]={'D:75043 Q:36286'}
G[100115281]={'D:75043 Q:36308 N:100115008'}
G[100115287]={'D:74254 Q:36314'}
G[100115343]={'D:75043 Q:36309'}
G[100115467]={'D:85199 Q:36385'}
G[100115507]={'D:75043 Q:36408'}
G[100115593]={'D:74254 Q:36435'}
G[100116120]={'948:37.73,56.32'}
G[100116159]={'D:75207 Q:36502'}
G[100116173]={'D:74254 Q:36505'}
G[100116395]={'Q:37290'}
G[100116438]={'D:74254 Q:36589'}
G[100119208]={'Mail Q:37322'}
G[100119317]={'D:82318 Q:37332'}
G[100122224]={'D:1240616 Q:38089'}
G[100122226]={'D:1240617 Q:38090'}
G[100122239]={'D:1240625 Q:38100'}
G[100122399]={'D:578564,78564 Q:38190'}	-- really sold by...do not kill NPC :-)
G[100122400]={'D:79774 Q:38179 N:100122404'}
G[100122401]={'D:578564,78564 Q:38189'}	-- really sold by...do not kill NPC :-)
G[100122402]={'D:79774 Q:38178 N:100122406'}
G[100122403]={'D:79774 Q:38177 N:100122399'}
G[100122404]={'D:578564,78564 Q:38192'}	-- really sold by...do not kill NPC :-)
G[100122405]={'D:79774 Q:38176 N:100122401'}
G[100122406]={'D:578564,78564 Q:38191'}	-- really sold by...do not kill NPC :-)
G[100122407]={'D:578564,78564 Q:38200'}	-- really sold by...do not kill NPC :-)
G[100122408]={'D:79774 Q:38186 N:100122407'}
G[100122409]={'D:578564,78564 Q:38199'}	-- really sold by...do not kill NPC :-)
G[100122410]={'D:578564,78564 Q:38201 N:100122412'}	-- really sold by...do not kill NPC :-)
G[100122411]={'D:79774 Q:38185 N:100122409'}
G[100122412]={'D:79774 Q:38187'}
G[100122413]={'D:79774 Q:38184 N:100122414'}
G[100122414]={'D:578564,78564 Q:38198'}	-- really sold by...do not kill NPC :-)
G[100122415]={'D:578564,78564 Q:38197'}	-- really sold by...do not kill NPC :-)
G[100122416]={'D:79774 Q:38183 N:100122415'}
G[100122417]={'D:578564,78564 Q:38196'}	-- really sold by...do not kill NPC :-)
G[100122418]={'D:79774 Q:38182 N:100122417'}
G[100122419]={'D:79774 N:100122420'}
G[100122420]={'D:578564,78564'}	-- really sold by...do not kill NPC :-)
G[100122421]={'D:79774 Q:38181 N:100122422'}
G[100122422]={'D:578564,78564 Q:38195'}	-- really sold by...do not kill NPC :-)
G[100122423]={'D:578564,78564 Q:38193'}	-- really sold by...do not kill NPC :-)
G[100122424]={'D:79774 Q:38180 N:100122423'}
G[100122699]={'D:109174 Q:38407'}
G[100123980]={'D:91474 Q:38862'}
G[100124131]={'D:92802 Q:38656'}
G[100126950]={'D:92552 Q:38932'}
G[100127860]={'D:94366 Q:38711'}
G[100127989]={'Q:39278'}
G[100128231]={'D:94472 Q:39355'}
G[100128232]={'D:92408 Q:39356'}
G[100128250]={'D:90974,96014 Q:39358'}	-- really is sold, no need to kill NPC :-)	-- TODO: Set up NPC 96014
G[100128252]={'D:90122 Q:39360'}
G[100128255]={'D:90519 Q:39363'}
G[100128256]={'D:90284 Q:39364'}	-- TODO: Set up NPC 90284
G[100128257]={'D:93076 Q:39365'}
G[100128258]={'D:92647 Q:39366'}
G[100128340]={'D:91318 Q:38146'}
G[100128491]={'D:90974,96014 Q:39359'}	-- really is sold, no need to kill NPC :-)	-- TODO: Set up NPC 96014
G[100128511]={'D:96229 Q:39595'}
G[100129747]={'Q:40168'}	-- TODO: Need to get list of bosses that can drop this
G[100129928]={'Q:40173'}	-- TODO: Need to get list of bosses that can drop this
G[100130921]={'Q:40349'}	-- TODO: This is created from highborne artifacts using archaeology
G[100130923]={'Q:40351'}	-- TODO: This is created from highborne artifacts using archaeology
G[100130925]={'Q:40353'}	-- TODO: This is created from highborne artifacts using archaeology
G[100130926]={'Q:40354'}	-- TODO: This is created from highmountain artifacts using archaeology
G[100130927]={'Q:40355'}	-- TODO: This is created from highmountain artifacts using archaeology
G[100130928]={'Q:40356'}	-- TODO: This is created from highmountain artifacts using archaeology
G[100130929]={'Q:40357'}	-- TODO: This is created from highmountain artifacts using archaeology
G[100130931]={'Q:40359'}	-- TODO: This is created from daemon artifacts using archaeology
G[100130933]={'Q:40361'}	-- TODO: This is created from daemon artifacts using archaeology
G[100130934]={'Q:40362'}	-- TODO: This is created from daemon artifacts using archaeology
G[100133377]={'Q:40786'}	-- TODO: Need to get list of bosses that can drop this
G[100133378]={'Q:40787 N:100133377'}	-- TODO: Need to get list of bosses that can drop this
G[100133675]={'D:101784 Q:41030'}
G[100138441]={'Q:42786'}
G[100138992]={'Q:42978'}
G[100139480]={'Q:43546'}	-- Gotten from Scouting Map follower mission
G[100139481]={'Q:43547'}	-- Gotten from Scouting Map follower mission
G[100140147]={'Q:43882'}	-- Gotten from Scouting Map follower mission
G[100140149]={'Q:43889'}	-- Gotten from Scouting Map follower mission
G[100140163]={'Q:43902'}	-- Gotten from Scouting Map follower mission
G[100140164]={'Q:43903'}	-- Gotten from Scouting Map follower mission
G[100140171]={'Q:43910'}	-- Gotten from Scouting Map follower mission
G[100140173]={'Q:43912'}	-- Gotten from Scouting Map follower mission
G[100140174]={'Q:43913'}	-- Gotten from Scouting Map follower mission
G[100140175]={'Q:43914'}	-- Gotten from Scouting Map follower mission
G[100140177]={'Q:43915'}	-- Gotten from Scouting Map follower mission
G[100140249]={'D:114255 Q:43942'}
G[100140495]={'Q:44057'}	-- Gotten from a Nightfallen emissary reward (after having gotten Revered rep)
G[100140778]={'Q:44176'}	-- looted from Suramar world quest
G[100141186]={'Q:44259'}	-- Gotten from Scouting Map follower mission
G[100141187]={'Q:44260'}	-- Gotten from Scouting Map follower mission
G[100141190]={'Q:44263'}	-- Gotten from Scouting Map follower mission
G[100141191]={'Q:44264'}	-- Gotten from Scouting Map follower mission
G[100141192]={'Q:44265'}	-- Gotten from Scouting Map follower mission
G[100141193]={'D:127476 Q:44266'}	-- Gotten from Scouting Map follower mission
G[100141194]={'D:127476 Q:44267'}	-- Gotten from Scouting Map follower mission
G[100141196]={'D:127476 Q:44269'}	-- Gotten from Scouting Map follower mission
G[100141197]={'D:127476 Q:44270'}	-- Gotten from Scouting Map follower mission
G[100141198]={'D:127476 Q:44271'}	-- Gotten from Scouting Map follower mission
G[100141199]={'D:127476 Q:44272'}	-- Gotten from Scouting Map follower mission
G[100141200]={'D:127476 Q:44273'}	-- Gotten from Scouting Map follower mission
G[100141201]={'D:127476 Q:44274'}	-- Gotten from Scouting Map follower mission
G[100141202]={'D:127476 Q:44275'}	-- Gotten from Scouting Map follower mission
G[100141204]={'D:127476 Q:44277'}	-- Gotten from Scouting Map follower mission
G[100142340]={'D:127476 Q:44917'}	-- Gotten from Scouting Map follower mission
G[100142522]={'D:127476 Q:45111'}	-- Gotten from Scouting Map follower mission
G[100142553]={'D:127476 Q:45162'}	-- Gotten from Scouting Map follower mission
G[100142554]={'D:127476 Q:45163'}	-- Gotten from Scouting Map follower mission
G[100142559]={'D:104415 Q:45159'}
G[100143328]={'D:127476 Q:45172'}	-- Gotten from Scouting Map follower mission
G[100143329]={'D:127476 Q:45173'}	-- Gotten from Scouting Map follower mission
G[100143478]={'D:127476 Q:45179'}	-- Gotten from Scouting Map follower mission
G[100143479]={'D:127476 Q:45180'}	-- Gotten from Scouting Map follower mission
G[100143561]={'D:127476 Q:45304'}	-- Gotten from Scouting Map follower mission
G[100147497]={'D:127476 Q:47714'}	-- Gotten from Scouting Map follower mission
G[100147501]={'D:127476 Q:47718'}	-- Gotten from Scouting Map follower mission
G[100147505]={'D:127476,98000,98613,98695,102669,102589,98093,97389,93787 Q:47122'}	-- Gotten from Scouting Map follower mission -- Need DK, Monk, Shaman, Warlock
G[100147506]={'D:127476 Q:47123'}	-- Gotten from Scouting Map follower mission
G[100147507]={'D:127476 Q:47124'}	-- Gotten from Scouting Map follower mission
G[100147508]={'D:127476 Q:47125'}	-- Gotten from Scouting Map follower mission
G[100147509]={'D:127476 Q:47126'}	-- Gotten from Scouting Map follower mission
G[100151462]={'Q:47793'}	-- gotten from Nightfallen cache (from 10K after exalted reward)
G[100152204]={'D:122403 Q:48230'}
G[100152313]={'D:127476 Q:48288'}	-- Gotten from Scouting Map follower mission
G[100152317]={'D:127476 Q:48292'}	-- Gotten from Scouting Map follower mission
G[100235344]={'Created Q:36770'}
G[200033529]={100046544,''}
G[200033530]={100046545,''}
end

if release >= 19342 then
G[6774]={'864:45.37,49.00'}
end

if release >= 25021 then
G[6774]={'30:45.38,48.99'}
end

if release >= 25678 then
G[122926]={'1014[10]:26.40,44.52'}
end

local N = Grail.npc
for key, value in pairs(Grail.npcs) do
	if value[1] then
		N.locations[key] = {}
		local codeArray = { strsplit(" ", value[1]) }
		local controlCode
		for _, code in pairs(codeArray) do
			controlCode = strsub(code, 1, 1)
			if 'A' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					local alias = tonumber(strsub(code, 3))
					if nil ~= alias then
						N.nameIndex[key] = alias
						N.aliases[alias] = N.aliases[alias] or {}
						tinsert(N.aliases[alias], key)
					else
						print("*** NPC processing of",key,"has improper alias")
					end
				end
			elseif 'C' == controlCode then
				tinsert(N.locations[key], { created = true })
			elseif 'D' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.droppedBy[key] = N.droppedBy[key] or {}
					local npcIds = { strsplit(',', strsub(code, 3)) }
					for _, anNPCId in pairs(npcIds) do
						local npcNumber = tonumber(anNPCId)
						if nil ~= npcNumber then
							tinsert(N.droppedBy[key], npcNumber)
							N.has[npcNumber] = N.has[npcNumber] or {}
							tinsert(N.has[npcNumber], key)
						end
					end
				end
			elseif 'H' == controlCode then
				-- the "has" codes are deprecated as we will populate the data based on "drop" codes instead
				if 2 < strlen(code) then
					local subcode = strsub(code, 2, 2)
					if ':' ~= subcode then
						local holidays = N.holiday[key]
						if nil == holidays then
							holidays = ''
						end
						N.holiday[key] = holidays .. subcode
					end
				end
			elseif 'K' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.kill[key] = N.kill[key] or {}
					local questList = { strsplit(',', strsub(code, 3)) }
					for _, questId in pairs(questList) do
						tinsert(N.kill[key], tonumber(questId))
					end
				end
			elseif 'M' == controlCode then
				local t1 = { mailbox = true }
				if 7 < strlen(code) then
					t1.mapArea = tonumber(strsub(code, 8))
				end
				tinsert(N.locations[key], t1)
			elseif 'N' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					local nameIndexToUse = tonumber(strsub(code, 3))
					N.nameIndex[key] = nameIndexToUse
				else
					local t1 = { near = true }
					if 4 < strlen(code) then
						t1.mapArea = tonumber(strsub(code, 5))
					end
					tinsert(N.locations[key], t1)
				end
			elseif 'P' == controlCode then
				-- we do nothing special for "Preowned" at the moment
			elseif 'Q' == controlCode then
				if 2 < strlen(code) and ':' == strsub(code, 2, 2) then
					N.questAssociations[key] = N.questAssociations[key] or {}
					local questList = { strsplit(',', strsub(code, 3)) }
					for _, questId in pairs(questList) do
						tinsert(N.questAssociations[key], tonumber(questId))
					end
				end
			elseif 'S' == controlCode then
				-- we do nothing special for "Self" at the moment
			elseif 'X' == controlCode then
				N.heroic[key] = true
			elseif 'Z' == controlCode then
				tinsert(N.locations[key], { ["mapArea"]=tonumber(strsub(code, 2)) })
			else	-- a real coordinate
				tinsert(N.locations[key], Grail:_LocationStructure(code))
			end
		end
	end
	if value[2] then N.comment[key] = value[2] end
	if value[3] then N.faction[key] = value[3] end

end
-- TODO: Go through all the Grail.npc.droppedBy values and make sure the locations for the NPCs are added to those keys

Grail.npcs = nil
--	18.84/19.29 idle after a couple minutes at startup without these changes.
--	18.25/18.69	idle after a couple minutes at startup WITH these changes.

Grail.memoryUsage.NPCs = gcinfo() - originalMem

end


