function GoHv5_doDeathKnight_PlayerFrames()

	if GoHv5_DeathKnight_Data.config.Enable_Player_Frames == "NO" then -- BEGIN ENABLED CHECK
	-- IF PLAYER FRAMES OPTION IS DISABLED THEN DO NOTHING.

	else

		local playerClass, EngClass = UnitClass("player");
		GoH_DeathKnight.Class = EngClass;
		GoHv5_DeathKnight_Data.config.LoggedInAsClass = GoH_DeathKnight.Class;

		if (GoH_DeathKnight.Class == "DEATHKNIGHT") then -- BEGIN CLASS CHECK

			if GoHv5_DeathKnight_Data.config.Show_Player_Frames == "YES" then -- BEGIN SETTINGS CHECK
			-- IF PLAYER FRAMES SETTING IS ON...

				if UnitInVehicle("player") then -- BEGIN VEHICLE CHECK

					-- YOU ARE IN A VEHICLE SO WE DO NOTHING
					-- #####################################

				else -- STILL VEHICLE CHECK

					-- YOU ARE NOT IN A VEHICLE SO WE CONTINUE
					-- #######################################

						-- DEATH KNIGHT PLAYER FRAME SETTINGS
						PlayerFrameTexture:ClearAllPoints();
						PlayerFrameTexture:SetPoint("TOPLEFT", "PlayerFrame", 10, 13);
						PlayerFrameTexture:SetTexCoord(0, 1, 0, 1)


						if GetShapeshiftForm() == 1 then
							-- BLOOD PRESENCE
							PlayerFrameTexture:SetTexture("Interface\\AddOns\\GoH_DeathKnight\\PlayerFrames\\Deathknight_Blood.tga");

						elseif GetShapeshiftForm() == 2	then
							-- FROST PRESENCE
							PlayerFrameTexture:SetTexture("Interface\\AddOns\\GoH_DeathKnight\\PlayerFrames\\DeathKnight_Frost.tga");

						elseif GetShapeshiftForm() == 3 then
							-- UNHOLY PRESENCE
							PlayerFrameTexture:SetTexture("Interface\\AddOns\\GoH_DeathKnight\\PlayerFrames\\DeathKnight_Unholy.tga");

						else
							-- DEFAULT/UNKNOWN (Dead/Ghost)
							PlayerFrameTexture:SetTexture("Interface\\AddOns\\GoH_DeathKnight\\PlayerFrames\\DeathKnight_Unknown.tga");

						end

				end -- END VEHICLE CHECK

			else -- STILL SETTINGS CHECK
			-- IF PLAYER FRAMES SETTING IS OFF...

				if UnitInVehicle("player") then -- BEGIN -else- VEHICLE CHECK

					-- YOU ARE IN A VEHICLE SO WE DO NOTHING
					-- #####################################

				else -- STILL -else- VEHICLE CHECK

					-- BLIZZARD PLAYER FRAME SETTINGS
					PlayerFrameTexture:ClearAllPoints();
					PlayerFrameTexture:SetTexCoord(1, 0, 0, 1)
					PlayerFrameTexture:SetPoint("TOPLEFT", "PlayerFrame", 0, 0);
					PlayerFrameTexture:SetTexture("Interface\\TargetingFrame\\UI-TargetingFrame.blp");

				end -- END -else- VEHICLE CHECK

			end -- BEGIN SETTINGS CHECK
		end -- END CLASS CHECK

		if GoHv5_DeathKnight_Data.config.Unit_In_Combat == "NO" then -- BEGIN COMBAT CHECK

			if GoHv5_DeathKnight_Data.config.Player_Frame_In_Raids == "YES" then -- BEGIN RAID OPTION CHECK

				if (UnitInRaid(GoH_DeathKnight.CharName)) then -- BEGIN IN RAID CHECK

					-- HIDE THE PLAYER FRAME
					PlayerFrame:Hide();

				else -- STILL IN RAID CHECK

					-- SHOW THE PLAYER FRAME
					PlayerFrame:Show();

				end -- END IN RAID CHECK

			end -- END RAID OPTION CHECK
		end -- END COMBAT CHECK
	end -- END ENABLED CHECK
end