-- #######################################
-- #######################################
--       GOH DEATH KNIGHT EVENT LOG
-- #######################################
-- #######################################

function GoH_DeathKnight.events.PLAYER_ENTERING_WORLD()
	-- print("Hello World.");
	GoH5_DeathKnight_SavedVariables();
	GoH_Settings_Set_Menu_Button_Images();
	GoH_DeathKnight_Set_Menu_Button_Images();
end

function GoH_DeathKnight.events.COMBAT_LOG_EVENT_UNFILTERED(timestamp, event, hideCaster, sourceGUID, sourceName, sourceFlags, sourceFlags2, destGUID, destName, destFlags, destFlags2, ...)

  -- ###########################################################################################################
  -- SINCE THESE ARE LOCAL, YOU CAN RE-USE THE SAME NAMES IN OTHER GOH CLASS MODS AND DON'T HAVE TO CHANGE THEM.
  -- ###########################################################################################################
  local GoH_spellID, GoH_spellName, GoH_all_spellSchool, GoH_amount, GoH_overkill, GoH_school, GoH_resisted, GoH_blocked, GoH_absorbed, GoH_critical = ...

	-- CHECK THE TIMER
	if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == nil then
		GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "YES";
	end

-- HEALTH HEALME EMOTE
if GoHv5_DeathKnight_Data.config.Use_Health_Warning == "YES" then
	if GoHv5_DeathKnight_Data.config.Use_Health_Warning_Emote == "YES"  then
		if GoHv5_DeathKnight_Data.config.Use_Health_Warning_Emote_Shown == "NO" then
			if ((UnitHealth("player") / UnitHealthMax("player")) <= (GoHv5_DeathKnight_Data.config.Health_Percentage)) then
			   DoEmote("healme");
			   GoHv5_DeathKnight_Data.config.Use_Health_Warning_Emote_Shown = "YES";
			end
		end
		if ((UnitHealth("player") / UnitHealthMax("player")) >= (GoHv5_DeathKnight_Data.config.Health_Percentage+0.05)) then
		   GoHv5_DeathKnight_Data.config.Use_Health_Warning_Emote_Shown = "NO";
		end
	end
end

-- MANA OOM EMOTE
if GoHv5_DeathKnight_Data.config.Use_Mana_Warning == "YES" then
	if GoHv5_DeathKnight_Data.config.Use_Mana_Warning_Emote == "YES"  then
		if GoHv5_DeathKnight_Data.config.Use_Mana_Warning_Emote_Shown == "NO" then
			if ((UnitMana("player") / UnitManaMax("player")) <= (GoHv5_DeathKnight_Data.config.Mana_Percentage)) then
			   DoEmote("oom");
			   GoHv5_DeathKnight_Data.config.Use_Mana_Warning_Emote_Shown = "YES";
			end
		end
		if ((UnitMana("player") / UnitManaMax("player")) >= (GoHv5_DeathKnight_Data.config.Mana_Percentage+0.05)) then
		   GoHv5_DeathKnight_Data.config.Use_Mana_Warning_Emote_Shown = "NO";
		end
	end
end

	-- ################################################################
	-- ################################################################
	-- ################################################################
	-- ################################################################
	-- ################################################################
	-- ################################################################
	-- ################################################################
	-- BEGIN DEATHKNIGHT SPELLS
	-- ################################################################

	if (GoH_DeathKnight.Class == "DEATHKNIGHT") then -- BEGIN CLASS CHECK

		-- DEATH KNIGHT: DEATH GRIP
		if GoHv5_DeathKnight_Data.config.Death_Grip == "YES" then
			if (GoH_spellID == 49576) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				
				
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end	
		end


			-- DEATH KNIGHT: DEATH AND DECAY
		if GoHv5_DeathKnight_Data.config.Death_and_Decay == "YES" then
			if (GoH_spellID == 43265) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Toasty_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				
				if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Toasty_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == "YES" then
				
				-- CALL RANDOM EASTER EGG
					Show_Toasty_Frame();
				end	
			end
		end


			-- DEATH KNIGHT: DEATH COIL
		if GoHv5_DeathKnight_Data.config.Death_Coil == "YES" then
			if (GoH_spellID == 47541) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Death_Coil.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			-- DEATH KNIGHT: EMPOWER RUNE WEAPON
		if GoHv5_DeathKnight_Data.config.Empower_Rune_Weapon == "YES" then
			if (GoH_spellID == 47568) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					-- FORSTMORN HUNGERS
					if (GoH_DeathKnight.Gender == "Female") then
						PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Frostmourn_Hungers_Female.mp3","Master");
					else
						PlaySoundFile("Sound\\Creature\\LichKing\\IC_Lich King_FMAttack01.ogg","Master");
					end

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- DEATH KNIGHT: HUNGERING RUNE WEAPON
		if GoHv5_DeathKnight_Data.config.Empower_Rune_Weapon == "YES" then
			if (GoH_spellID == 207127) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					-- FORSTMORN HUNGERS
					if (GoH_DeathKnight.Gender == "Female") then
						PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Frostmourn_Hungers_Female.mp3","Master");
					else
						PlaySoundFile("Sound\\Creature\\LichKing\\IC_Lich King_FMAttack01.ogg","Master");
					end

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			-- DEATH KNIGHT: ICEBOUND FORTITUDE
		if GoHv5_DeathKnight_Data.config.Icebound_Fortitude == "YES" then
			if (GoH_spellID == 48792) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\IceboundFortitude_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			-- DEATH KNIGHT: ANTI-MAGIC SHELL
		if GoHv5_DeathKnight_Data.config.AntiMagic_Shell == "YES" then
			if (GoH_spellID == 48707) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bubble_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			 -- DEATH KNIGHT: ANTI-MAGIC ZONE
		if GoHv5_DeathKnight_Data.config.AntiMagic_Zone == "YES" then
			if (GoH_spellID == 51052) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Get_Under_Here_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

		-- DEATH KNIGHT: RAISE ALLY
		if GoHv5_DeathKnight_Data.config.Raise_Ally == "YES" then
			if (GoH_spellID == 61999) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\RaiseAlly_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

		-- DEATH KNIGHT: (RAISE ALLY) VOID TOUCH DEBUFF
		if GoHv5_DeathKnight_Data.config.Void_Touch_Debuff == "YES" then
			if (GoH_spellID == 97821) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\RaiseAlly_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			-- DEATH KNIGHT: RAISE DEAD
		if GoHv5_DeathKnight_Data.config.Raise_Dead == "YES" then
			if (GoH_spellName == DeathKnight_Raise_Dead_Name) and (event == "SPELL_SUMMON") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\RaiseDead_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			-- DEATH KNIGHT: ARMY OF THE DEAD
		if GoHv5_DeathKnight_Data.config.Army_of_the_Dead == "YES" then
			if (GoH_spellID == 42650) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Summon();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			-- DEATH KNIGHT: SUMMON GARGOYLE
		if GoHv5_DeathKnight_Data.config.Summon_Gargoyle == "YES" then
			if (GoH_spellID == 49206) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\SummonGargoyle_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			-- DEATH KNIGHT: DARK TRANSFORMATION
		if GoHv5_DeathKnight_Data.config.Dark_Transformation == "YES" then
			if (GoH_spellID == 63560) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Dark_Transformation_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

			-- DEATH KNIGHT: MIND FREEZE
		if GoHv5_DeathKnight_Data.config.Mind_Freeze == "YES" then
			if (GoH_spellID == 47528) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end

			-- DEATH KNIGHT: BLOOD BOIL
		if GoHv5_DeathKnight_Data.config.Blood_Boil == "YES" then
			if (GoH_spellID == 50842) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Toasty_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				
				if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Toasty_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == "YES" then
				
				-- CALL RANDOM EASTER EGG
					Show_Toasty_Frame();
				end	
			end
		end

			 -- DEATH KNIGHT: DARK COMMAND
		if GoHv5_DeathKnight_Data.config.Dark_Command == "YES" then
			if (GoH_spellID == 56222) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
		-- DEATH KNIGHT: MURDEROUS INTENT
		if GoHv5_DeathKnight_Data.config.Dark_Command == "YES" then
			if (GoH_spellID == 207018) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end

		   -- DEATH KNIGHT: CHAINS OF ICE
		if GoHv5_DeathKnight_Data.config.Chains_of_Ice == "YES" then
			if (GoH_spellID == 45524) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

		   -- DEATH KNIGHT: PATH OF FROST
		if GoHv5_DeathKnight_Data.config.Path_of_Frost == "YES" then
			if (GoH_spellID == 3714) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\JesusWalk_1.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- DEATH KNIGHT: HOWLING_BLAST
		if GoHv5_DeathKnight_Data.config.Howling_Blast == "YES" then
			if (GoH_spellID == 49184) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Wind.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

		   -- DEATH KNIGHT: DANCING RUNE WEAPON
		if GoHv5_DeathKnight_Data.config.Dancing_Rune_Weapon == "YES" then
			if (GoH_spellID == 49028) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Lightsaber_Sound.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

		   -- DEATH KNIGHT: REMORSELESS WINTER
		if GoHv5_DeathKnight_Data.config.Remorseless_Winter == "YES" then
			if (GoH_spellID == 196770) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\FreezingFog_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

		   -- DEATH KNIGHT: ASPHYXIATE
		if GoHv5_DeathKnight_Data.config.Asphyxiate == "YES" then
			if (GoH_spellID == 108194) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end

			-- DEATH KNIGHT: GORFIENDS GRASP
		if GoHv5_DeathKnight_Data.config.Gorfiends_Grasp == "YES" then
			if (GoH_spellID == 108199) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
		-- DEATH KNIGHT: CORPSE SHIELD
		if GoHv5_DeathKnight_Data.config.Corpse_Shield == "YES" then
			if (GoH_spellID == 207319) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Death_Pact_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- DEATH KNIGHT: DARK ARBITER
		if GoHv5_DeathKnight_Data.config.Dark_Arbiter == "YES" then
			if (GoH_spellID == 207349) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Sound\\Creature\\LichKing\\IC_Lich King_CallValkyr01.ogg","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

		-- DEATH KNIGHT: DEATH GATE
		if GoHv5_DeathKnight_Data.config.Death_Gate == "YES" then
			if (GoH_spellName == DeathKnight_Death_Gate_Name) and (event == "SPELL_CAST_START") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Stargate.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	end -- END DEATH KNIGHT CLASS CHECK

        -- DEATH KNIGHT: MARROWREND
		if GoHv5_DeathKnight_Data.config.Marrowrend == "YES" then
			if (GoH_spellID == 195182) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\BoneShield_Begins_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

        -- DEATH KNIGHT: DEATH STRIKE
		if GoHv5_DeathKnight_Data.config.Death_Strike == "YES" then
			if (GoH_spellID == 49998) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Finish_It_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Finish_It_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Finish_It_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Finish_It_Image == "YES" then
				
				-- CALL RANDOM EASTER EGG
					Call_RANDOM_Finish_It_Frame();
				end	
			end
		end
		
		-- DEATH KNIGHT: APOCALYPSE
		if GoHv5_DeathKnight_Data.config.Apocalypse == "YES" then
			if (GoH_spellID == 220143) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Sound\\Creature\\LichKing\\IC_Lich King_Special01.ogg","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- DEATH KNIGHT: DEFILE
		if GoHv5_DeathKnight_Data.config.Defile == "YES" then
			if (GoH_spellID == 152280) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Toasty_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
				

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				
				if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Toasty_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == "YES" then
				
				-- CALL RANDOM EASTER EGG
					Show_Toasty_Frame();
				end	
			end
		end
		
		-- DEATH KNIGHT: PILLAR OF FROST
		if GoHv5_DeathKnight_Data.config.Pillar_of_Frost == "YES" then
			if (GoH_spellID == 51271) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Prepare_To_Die_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN Warrior
	-- #######################################################################	

    -- Warrior: Taunt
		if GoHv5_DeathKnight_Data.config.Taunt == "YES" then
			if (GoH_spellID == 355) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
		-- Warrior: OPPRESSOR
		if GoHv5_DeathKnight_Data.config.Taunt == "YES" then
			if (GoH_spellID == 205800) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
	 -- Warrior: AVATAR
		if GoHv5_DeathKnight_Data.config.Avatar == "YES" then
			if (GoH_spellID == 107574) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Dark_Transformation_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- Warrior: CHARGE
		if GoHv5_DeathKnight_Data.config.Charge == "YES" then
			if (GoH_spellID == 100) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\John_Cena.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- Warrior: BLADESTORM
		if GoHv5_DeathKnight_Data.config.Bladestorm == "YES" then
			if (GoH_spellID == 227847) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Lightsaber_Sound.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
		-- Warrior: BLADESTORM
		if GoHv5_DeathKnight_Data.config.Bladestorm == "YES" then
			if (GoH_spellID == 46924) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Lightsaber_Sound.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
		
		
	-- Warrior: PUMMEL 
		if GoHv5_DeathKnight_Data.config.Pummel == "YES" then
			if (GoH_spellID == 6552) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end	

	-- Warrior: INTERCEPT 
		if GoHv5_DeathKnight_Data.config.Intercept == "YES" then
			if (GoH_spellID == 198304) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\John_Cena.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- Warrior: SHOCKWAVE 
		if GoHv5_DeathKnight_Data.config.Shockwave == "YES" then
			if (GoH_spellID == 46968) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\ShockWave.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- Warrior: EXECUTE 
		if GoHv5_DeathKnight_Data.config.Execute == "YES" then
			if (GoH_spellID == 5308) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Finish_It_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Finish_It_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Finish_It_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Finish_It_Image == "YES" then
				
				-- CALL RANDOM EASTER EGG
					Call_RANDOM_Finish_It_Frame();
				end	
			end
		end
				
			
		
	-- Warrior: EXECUTE 
		if GoHv5_DeathKnight_Data.config.Execute == "YES" then
			if (GoH_spellID == 163201) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Finish_It_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					Call_RANDOM_Finish_It_Frame();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- Warrior: DRAGON_ROAR 
		if GoHv5_DeathKnight_Data.config.Dragon_Roar == "YES" then
			if (GoH_spellID == 118000) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- Warrior: REVENGE 
		if GoHv5_DeathKnight_Data.config.Revenge == "YES" then
			if (GoH_spellID == 6572) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\HolyPower_3.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end		

	-- Warrior: THUNDER_CLAP 
		if GoHv5_DeathKnight_Data.config.Thunder_Clap == "YES" then
			if (GoH_spellID == 6343) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Lightning_Storm.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- Warrior: SHIELD WALL 
		if GoHv5_DeathKnight_Data.config.Shield_Wall == "YES" then
			if (GoH_spellID == 871) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bubble_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- Warrior: WHIRLWIND 
		if GoHv5_DeathKnight_Data.config.Whirlwind == "YES" then
			if (GoH_spellID == 190411) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\ShockWave.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- Warrior: COLOSSUS_SMASH 
		if GoHv5_DeathKnight_Data.config.Colossus_Smash == "YES" then
			if (GoH_spellID == 167105) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\HulkSmash.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- Warrior: SHIELD_SLAM 
		if GoHv5_DeathKnight_Data.config.Shield_Slam == "YES" then
			if (GoH_spellID == 23922) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Slam_Sound.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- Warrior: SHIELD_BLOCK 
		if GoHv5_DeathKnight_Data.config.Shield_Block == "YES" then
			if (GoH_spellID == 2565) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Slam_Sound.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- Warrior: COMMANDING_SHOUT 
		if GoHv5_DeathKnight_Data.config.Commanding_Shout == "YES" then
			if (GoH_spellID == 97462) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Calvary_Bugle.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- Warrior: DEMORALIZING_SHOUT 
		if GoHv5_DeathKnight_Data.config.Demoralizing_Shout == "YES" then
			if (GoH_spellID == 1160) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Hulk_Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- Warrior: BERSERKER_RAGE 
		if GoHv5_DeathKnight_Data.config.Berserker_Rage == "YES" then
			if (GoH_spellID == 18499) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Hulk_Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- Warrior: BATTLE_CRY 
		if GoHv5_DeathKnight_Data.config.Battle_Cry == "YES" then
			if (GoH_spellID == 1719) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Calvary_Bugle.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
		-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN PRIEST
	-- #######################################################################
	
	-- PRIEST: MINDBENDER
		if GoHv5_DeathKnight_Data.config.Mindbender == "YES" then
			if (GoH_spellID == 200174) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Slaughter_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	
	-- PRIEST: SHADOWFIEND
		if GoHv5_DeathKnight_Data.config.Shadowfiend == "YES" then
			if (GoH_spellID == 34433) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	
	-- PRIEST: SMITE
		if GoHv5_DeathKnight_Data.config.Smite == "YES" then
			if (GoH_spellID == 585) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\HolyPower_1.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	
	-- PRIEST: DISPERSION
		if GoHv5_DeathKnight_Data.config.Dispersion == "YES" then
			if (GoH_spellID == 47585) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Camouflage.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	
	-- PRIEST: SILENCE
		if GoHv5_DeathKnight_Data.config.Silence == "YES" then
			if (GoH_spellID == 15487) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end
	
	-- PRIEST: LEVITATE
		if GoHv5_DeathKnight_Data.config.Levitate == "YES" then
			if (GoH_spellID == 1706) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\JesusWalk_1.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	
	-- PRIEST: FADE
		if GoHv5_DeathKnight_Data.config.Fade == "YES" then
			if (GoH_spellID == 586) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	
	-- PRIEST: SURRENDER TO MADNESS
		if GoHv5_DeathKnight_Data.config.Surrender_to_Madness == "YES" then
			if (GoH_spellID == 193223) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Madness.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- PRIEST: Leap of Faith
		if GoHv5_DeathKnight_Data.config.Leap_of_Faith == "YES" then
			if (GoH_spellID == 73325) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
		-- PRIEST: PHYCHIC SCREAM
		if GoHv5_DeathKnight_Data.config.phychic_scream == "YES" then
			if (GoH_spellID == 8122) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Get_Out_Of_Here_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
			-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN PALLY
	-- #######################################################################

	
	-- PALLY HAND OF RECKONING
		if GoHv5_DeathKnight_Data.config.Hand_of_Reckoning == "YES" then
			if (GoH_spellID == 62124) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
	-- PALLY HAND OF INQUISITION
		if GoHv5_DeathKnight_Data.config.Hand_of_Reckoning == "YES" then
			if (GoH_spellID == 207028) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end	
		
	-- PALLY AVENGING WRATH
		if GoHv5_DeathKnight_Data.config.Avenging_Wrath == "YES" then
			if (GoH_spellID == 31884) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Avenging_Wrath_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- PALLY REBUKE
		if GoHv5_DeathKnight_Data.config.Rebuke == "YES" then
			if (GoH_spellID == 96231) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end	

	-- PALLY DIVINE SHIELD
		if GoHv5_DeathKnight_Data.config.Divine_Shield == "YES" then
			if (GoH_spellID == 642) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bubble_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- PALLY SHIELD OF VENGEANCE
		if GoHv5_DeathKnight_Data.config.Shield_of_Vengeance == "YES" then
			if (GoH_spellID == 184662) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bubble_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- PALLY HAMMER OF JUSTICE
		if GoHv5_DeathKnight_Data.config.Hammer_of_Justice == "YES" then
			if (GoH_spellID == 853) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Thats_Enough_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- PALLY HAND OF HINDRANCE
		if GoHv5_DeathKnight_Data.config.Hand_of_Hindrance == "YES" then
			if (GoH_spellID == 183218) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- PALLY BLINDING LIGHT
		if GoHv5_DeathKnight_Data.config.Blinding_Light == "YES" then
			if (GoH_spellID == 115750) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\HolyPower_1.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
	-- PALLY: CONSECRATION
		if GoHv5_DeathKnight_Data.config.Consecration == "YES" then
			if (GoH_spellID == 26573) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Toasty_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				
				if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Toasty_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == "YES" then
				
				-- CALL RANDOM EASTER EGG
					Show_Toasty_Frame();
				end	
			end
		end	
		
	-- PALLY: CONSECRATION
		if GoHv5_DeathKnight_Data.config.Consecration == "YES" then
			if (GoH_spellID == 205228) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Toasty_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				
				if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Toasty_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Toasty_Image == "YES" then
				
				-- CALL RANDOM EASTER EGG
					Show_Toasty_Frame();
				end	
			end
		end		

	-- PALLY JUDGMENT
		if GoHv5_DeathKnight_Data.config.Judgment == "YES" then
			if (GoH_spellID == 20271) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\HolyPower_2.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- PALLY CRUSADER STRIKE
		if GoHv5_DeathKnight_Data.config.Crusader_Strike == "YES" then
			if (GoH_spellID == 35395) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\HolyPower_3.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
		
		-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN MONK
	-- #######################################################################
	
	
	-- MONK PARALYSIS
		if GoHv5_DeathKnight_Data.config.Paralysis == "YES" then
			if (GoH_spellID == 115078) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\All_Too_Easy_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	
	-- MONK PROVOKE
		if GoHv5_DeathKnight_Data.config.Provoke == "YES" then
			if (GoH_spellID == 115546) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
	-- MONK ADMONISHMENT
		if GoHv5_DeathKnight_Data.config.Provoke == "YES" then
			if (GoH_spellID == 207025) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end	
		
		
	-- MONK Roll
		if GoHv5_DeathKnight_Data.config.Roll == "YES" then
			if (GoH_spellID == 109132) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Woooaaaoo.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- MONK TIGER PALM
		if GoHv5_DeathKnight_Data.config.Tiger_Palm == "YES" then
			if (GoH_spellID == 100780) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Tiger_Palm.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
	-- MONK FLYING SERPENT KICK
		if GoHv5_DeathKnight_Data.config.Flying_Serpent_Kick == "YES" then
			if (GoH_spellID == 101545) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Cowabunga.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- MONK RISING SUN KICK
		if GoHv5_DeathKnight_Data.config.Rising_Sun_Kick == "YES" then
			if (GoH_spellID == 107428) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Rising_Sun_Kick.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- MONK BLACKOUT KICK
		if GoHv5_DeathKnight_Data.config.Blackout_Kick == "YES" then
			if (GoH_spellID == 100784) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Blackout_kick.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
	-- MONK Fist Of Fury
		if GoHv5_DeathKnight_Data.config.Fists_of_Fury == "YES" then
			if (GoH_spellID == 113656) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Fist_Of_Fury.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- MONK TOUCH OF DEATH
		if GoHv5_DeathKnight_Data.config.Touch_Of_Death == "YES" then
			if (GoH_spellID == 115080) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\KillingBlow_6_GodLike_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- MONK SPEAR HAND STRIKE
		if GoHv5_DeathKnight_Data.config.Spear_Hand_Strike == "YES" then
			if (GoH_spellID == 116705) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end	
		
	-- MONK LEG SWEEP
		if GoHv5_DeathKnight_Data.config.Leg_Sweep == "YES" then
			if (GoH_spellID == 119381) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	
		
		
		-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN DRUID
	-- #######################################################################
	
	-- DRUID GROWL
		if GoHv5_DeathKnight_Data.config.Growl == "YES" then
			if (GoH_spellID == 6795) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
	-- DRUID Alpha_Challenge
		if GoHv5_DeathKnight_Data.config.Growl == "YES" then
			if (GoH_spellID == 207017) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end	
		
	-- DRUID CAT FORM
		if GoHv5_DeathKnight_Data.config.Cat_Form == "YES" then
			if (GoH_spellID == 768) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Max_Speed.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DRUID BEAR FORM
		if GoHv5_DeathKnight_Data.config.Bear_Form == "YES" then
			if (GoH_spellID == 5487) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Max_Strength.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DRUID MOONKIN FORM
		if GoHv5_DeathKnight_Data.config.Moonkin_Form == "YES" then
			if (GoH_spellID == 24858) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Max_Armor.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DRUID MOONKIN FORM
		if GoHv5_DeathKnight_Data.config.Moonkin_Form == "YES" then
			if (GoH_spellID == 197625) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Max_Armor.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DRUID TRAVEL FORM
		if GoHv5_DeathKnight_Data.config.Travel_Form == "YES" then
			if (GoH_spellID == 783) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Max_Speed.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DRUID SKULL BASH
		if GoHv5_DeathKnight_Data.config.Skull_Bash == "YES" then
			if (GoH_spellID == 106839) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end	

	-- DRUID STAMPEDING ROAR
		if GoHv5_DeathKnight_Data.config.Stampeding_Roar == "YES" then
			if (GoH_spellID == 106898) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Hulk_Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DRUID DASH
		if GoHv5_DeathKnight_Data.config.Dash == "YES" then
			if (GoH_spellID == 1850) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Soul_Fire.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
		-- DRUID PROWL
		if GoHv5_DeathKnight_Data.config.Prowl == "YES" then
			if (GoH_spellID == 5215) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
		-- DRUID Moonfire
		if GoHv5_DeathKnight_Data.config.Moonfire == "YES" then
			if (GoH_spellID == 8921) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Repulsor_Blast.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
		-- DRUID STARFALL
		if GoHv5_DeathKnight_Data.config.Starfall == "YES" then
			if (GoH_spellID == 191034) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Lightning_Storm.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
		
		-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN Warlock
	-- #######################################################################
	
	
	-- WARLOCK MORTAL COIL
		if GoHv5_DeathKnight_Data.config.Mortal_Coil == "YES" then
			if (GoH_spellID == 6789) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Get_Out_Of_Here_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK HOWL OF TERROR
		if GoHv5_DeathKnight_Data.config.Howl_of_Terror == "YES" then
			if (GoH_spellID == 5484) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Get_Out_Of_Here_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK UNENDING_BREATH
		if GoHv5_DeathKnight_Data.config.Unending_Breath == "YES" then
			if (GoH_spellID == 5697) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Hand_of_Protection_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK UNENDING_RESOLVE
		if GoHv5_DeathKnight_Data.config.Unending_Resolve == "YES" then
			if (GoH_spellID == 104773) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK SOUL_HARVEST
		if GoHv5_DeathKnight_Data.config.Soul_Harvest == "YES" then
			if (GoH_spellID == 196098) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Prepare_To_Die_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK RAIN_OF_FIRE
		if GoHv5_DeathKnight_Data.config.Rain_Of_Fire == "YES" then
			if (GoH_spellID == 5740) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Lightning_Storm.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK SUMMON_INFERNAL
		if GoHv5_DeathKnight_Data.config.Summon_Infernal == "YES" then
			if (GoH_spellID == 1122) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK SUMMON_DOOMGUARD
		if GoHv5_DeathKnight_Data.config.Summon_Doomguard == "YES" then
			if (GoH_spellID == 18540) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK DARK_PACT
		if GoHv5_DeathKnight_Data.config.Dark_Pact == "YES" then
			if (GoH_spellID == 108416) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Death_Pact_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- WARLOCK BURNING_RUSH
		if GoHv5_DeathKnight_Data.config.Burning_Rush == "YES" then
			if (GoH_spellID == 111400) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Soul_Fire.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN ROGUE
	-- #######################################################################	
		
		-- ROGUE STEALTH
		if GoHv5_DeathKnight_Data.config.Stealth == "YES" then
			if (GoH_spellID == 1784) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- ROGUE VANISH
		if GoHv5_DeathKnight_Data.config.Vanish == "YES" then
			if (GoH_spellID == 1856) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- ROGUE SHADOW_DANCE
		if GoHv5_DeathKnight_Data.config.Shadow_Dance == "YES" then
			if (GoH_spellID == 185212) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\KillingBlow_6_GodLike_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- ROGUE PICK_POCKET
		if GoHv5_DeathKnight_Data.config.Pick_Pocket == "YES" then
			if (GoH_spellID == 921) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\PocketChange_1.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- ROGUE CHEAP_SHOT
		if GoHv5_DeathKnight_Data.config.Cheap_Shot == "YES" then
			if (GoH_spellID == 1833) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- ROGUE BLIND
		if GoHv5_DeathKnight_Data.config.Blind == "YES" then
			if (GoH_spellID == 2094) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Get_Out_Of_Here_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- ROGUE KICK
		if GoHv5_DeathKnight_Data.config.Kick == "YES" then
			if (GoH_spellID == 1766) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end
		
		-- ROGUE SHADOWSTEP
		if GoHv5_DeathKnight_Data.config.Shadowstep == "YES" then
			if (GoH_spellID == 36554) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- ROGUE SPRINT
		if GoHv5_DeathKnight_Data.config.Sprint == "YES" then
			if (GoH_spellID == 2983) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Soul_Fire.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		-- ROGUE EVASION
		if GoHv5_DeathKnight_Data.config.Evasion == "YES" then
			if (GoH_spellID == 5277) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
		
		
		
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN HUNTER
	-- #######################################################################
	
	-- HUNTER A MURDER OF CROWS
		if GoHv5_DeathKnight_Data.config.A_Murder_Of_Crows == "YES" then
			if (GoH_spellID == 131894) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Feast();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- HUNTER BESTIAL_WRATH
		if GoHv5_DeathKnight_Data.config.Bestial_Wrath == "YES" then
			if (GoH_spellID == 19574) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Hulk_Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER SPITTING_COBRA
		if GoHv5_DeathKnight_Data.config.Spitting_Cobra == "YES" then
			if (GoH_spellID == 194407) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Snake.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- HUNTER DIRE_BEAST
		if GoHv5_DeathKnight_Data.config.Dire_Beast == "YES" then
			if (GoH_spellID == 120679) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER COUNTER_SHOT
		if GoHv5_DeathKnight_Data.config.Counter_Shot == "YES" then
			if (GoH_spellID == 147362) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end

	-- HUNTER FEIGN_DEATH
		if GoHv5_DeathKnight_Data.config.Feign_Death == "YES" then
			if (GoH_spellID == 5384) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER KILL_COMMAND
		if GoHv5_DeathKnight_Data.config.Kill_Command == "YES" then
			if (GoH_spellID == 34026) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- HUNTER DISENGAGE
		if GoHv5_DeathKnight_Data.config.Disengage == "YES" then
			if (GoH_spellID == 781) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- HUNTER STAMPEDE
		if GoHv5_DeathKnight_Data.config.Stampede == "YES" then
			if (GoH_spellID == 201430) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Feast();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER DIRE FRENZY
		if GoHv5_DeathKnight_Data.config.Dire_Frenzy == "YES" then
			if (GoH_spellID == 217200) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- HUNTER CAMOUFLAGE
		if GoHv5_DeathKnight_Data.config.Camouflage == "YES" then
			if (GoH_spellID == 199483) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER TRUESHOT
		if GoHv5_DeathKnight_Data.config.Trueshot == "YES" then
			if (GoH_spellID == 193526) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Trueshot.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER SIDEWINDERS
		if GoHv5_DeathKnight_Data.config.Sidewinders == "YES" then
			if (GoH_spellID == 214579) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Snake.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER HARPOON
		if GoHv5_DeathKnight_Data.config.Harpoon == "YES" then
			if (GoH_spellID == 190925) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- HUNTER FLARE
		if GoHv5_DeathKnight_Data.config.Flare == "YES" then
			if (GoH_spellID == 1543) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\I_See_You_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- HUNTER MISDIRECTION
		if GoHv5_DeathKnight_Data.config.Misdirection == "YES" then
			if (GoH_spellID == 34477) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\You_Are_Nothing_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER BURSTING SHOT
		if GoHv5_DeathKnight_Data.config.Bursting_Shot == "YES" then
			if (GoH_spellID == 186387) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bursting_Shot.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER MARKED SHOT
		if GoHv5_DeathKnight_Data.config.Marked_Shot == "YES" then
			if (GoH_spellID == 185901) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Rapid_Fire.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- HUNTER RANGERS NET
		if GoHv5_DeathKnight_Data.config.Rangers_Net == "YES" then
			if (GoH_spellID == 200108) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\All_Too_Easy_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- HUNTER Aspect_of_the_Eagle
		if GoHv5_DeathKnight_Data.config.Aspect_of_the_Eagle == "YES" then
			if (GoH_spellID == 186289) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Hawk.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN DEMON HUNTER
	-- #######################################################################	
    
	
	-- DEMON HUNTER TORMENT
		if GoHv5_DeathKnight_Data.config.Torment == "YES" then
			if (GoH_spellID == 185245) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end
		
	-- DEMON HUNTER TORMENTOR
		if GoHv5_DeathKnight_Data.config.Torment == "YES" then
			if (GoH_spellID == 207029) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_DEATHGRIP_Sound();
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_GoH_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_GoH_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_GoH_Image == "YES" then

			    Show_GoH_Frame();
			    end
			end
		end	
		
	-- DEMON HUNTER SIGIL_OF_FLAME
		if GoHv5_DeathKnight_Data.config.Sigil_Of_Flame == "YES" then
			if (GoH_spellID == 204596) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\I_See_You_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DEMON HUNTER SIGIL_OF_MISERY
		if GoHv5_DeathKnight_Data.config.Sigil_Of_Flame == "YES" then
			if (GoH_spellID == 207684) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\I_See_You_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DEMON HUNTER SIGIL_OF_SCILENCE
		if GoHv5_DeathKnight_Data.config.Sigil_Of_Flame == "YES" then
			if (GoH_spellID == 202137) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\I_See_You_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DEMON HUNTER SIGIL_OF_CHAINS
		if GoHv5_DeathKnight_Data.config.Sigil_Of_Flame == "YES" then
			if (GoH_spellID == 202138) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\I_See_You_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DEMON HUNTER NETHERWALK
		if GoHv5_DeathKnight_Data.config.Netherwalk == "YES" then
			if (GoH_spellID == 196555) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DEMON HUNTER METAMORPHOSIS
		if GoHv5_DeathKnight_Data.config.Metamorphosis == "YES" then
			if (GoH_spellID == 187827) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Dark_Transformation_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DEMON HUNTER METAMORPHOSIS
		if GoHv5_DeathKnight_Data.config.Metamorphosis == "YES" then
			if (GoH_spellID == 191427) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Dark_Transformation_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end		

	-- DEMON HUNTER FELBLADE
		if GoHv5_DeathKnight_Data.config.Felblade == "YES" then
			if (GoH_spellID == 232893) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\John_Cena.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DEMON HUNTER FEL_RUSH
		if GoHv5_DeathKnight_Data.config.Fel_Rush == "YES" then
			if (GoH_spellID == 195072) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\John_Cena.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DEMON HUNTER FEL_ERUPTION
		if GoHv5_DeathKnight_Data.config.Fel_Eruption == "YES" then
			if (GoH_spellID == 211881) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\You_Weak_Pathetic_Fool_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	-- DEMON HUNTER GLIDE
		if GoHv5_DeathKnight_Data.config.Glide == "YES" then
			if (GoH_spellID == 131347) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DEMON HUNTER DARKNESS
		if GoHv5_DeathKnight_Data.config.Darkness == "YES" then
			if (GoH_spellID == 196718) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Camouflage.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DEMON HUNTER SPECTRAL_SIGHT
		if GoHv5_DeathKnight_Data.config.Spectral_Sight == "YES" then
			if (GoH_spellID == 188501) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\I_See_You_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DEMON HUNTER IMMOLATION_AURA
		if GoHv5_DeathKnight_Data.config.Immolation_Aura == "YES" then
			if (GoH_spellID == 178740) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Cower_Before_Me_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- DEMON HUNTER FIERY_BRAND
		if GoHv5_DeathKnight_Data.config.Fiery_Brand == "YES" then
			if (GoH_spellID == 204021) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					-- YOU WILL DIE
				if (GoH_DeathKnight.Gender == "Female") then
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\You_Will_Die_Female.mp3","Master");
				else
	    			PlaySoundFile("Sound\\Creature\\CThun\\CThunYouWillDie.ogg","Master");
				end

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DEMON HUNTER FURY_OF_THE_ILLIDARI
		if GoHv5_DeathKnight_Data.config.Fury_Of_The_Illidari == "YES" then
			if (GoH_spellID == 201467) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					-- YOU ARE NOT PREPARED
					if (GoH_DeathKnight.Gender == "Female") then
						PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\You_Are_Not_Prepared_Female.mp3","Master");
					else
						PlaySoundFile("Sound\\Creature\\Illidan\\BLACK_Illidan_04.ogg","Master");
					end

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- DEMON HUNTER CONSUME_MAGIC
		if GoHv5_DeathKnight_Data.config.Consume_Magic == "YES" then
			if (GoH_spellID == 183752) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end	

	-- DEMON HUNTER SOUL_BARRIER
		if GoHv5_DeathKnight_Data.config.Soul_Barrier == "YES" then
			if (GoH_spellID == 227225) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bubble_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end		

	-- DEMON HUNTER INFERNAL_STRIKE
		if GoHv5_DeathKnight_Data.config.Infernal_Strike == "YES" then
			if (GoH_spellID == 189110) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\John_Cena.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN MAGE 
	-- #######################################################################	

	-- MAGE    TIME_WARP
		if GoHv5_DeathKnight_Data.config.Time_Warp == "YES" then
			if (GoH_spellID == 80353) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Hand_of_Protection_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- MAGE    GREATER_INVISIBILITY
		if GoHv5_DeathKnight_Data.config.Greater_Invisibility == "YES" then
			if (GoH_spellID == 110959) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- MAGE    INVISIBILITY
		if GoHv5_DeathKnight_Data.config.Invisibility == "YES" then
			if (GoH_spellID == 66) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- MAGE    PRISMATIC_BARRIER
		if GoHv5_DeathKnight_Data.config.Prismatic_Barrier == "YES" then
			if (GoH_spellID == 235450) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bubble_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- MAGE    BLAZING_BARRIER
		if GoHv5_DeathKnight_Data.config.Blazing_Barrier == "YES" then
			if (GoH_spellID == 235313) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bubble_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- MAGE    ICE_BARRIER
		if GoHv5_DeathKnight_Data.config.Ice_Barrier == "YES" then
			if (GoH_spellID == 11426) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Bubble_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- MAGE    MIRROR_IMAGE
		if GoHv5_DeathKnight_Data.config.Mirror_Image == "YES" then
			if (GoH_spellID == 55342) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\I_See_You_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- MAGE    ICE_BLOCK
		if GoHv5_DeathKnight_Data.config.Ice_Block == "YES" then
			if (GoH_spellID == 45438) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Thats_Enough_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- MAGE    COUNTERSPELL
		if GoHv5_DeathKnight_Data.config.Counterspell == "YES" then
			if (GoH_spellID == 2139) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end	

	-- MAGE    BLINK
		if GoHv5_DeathKnight_Data.config.Blink == "YES" then
			if (GoH_spellID == 1953) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Soul_Fire.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN SHAMAN 
	-- #######################################################################

	-- SHAMAN    GHOST_WOLF
		if GoHv5_DeathKnight_Data.config.Ghost_Wolf == "YES" then
			if (GoH_spellID == 2645) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Roar.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	
		
	-- SHAMAN    HEROISM
		if GoHv5_DeathKnight_Data.config.Heroism == "YES" then
			if (GoH_spellID == 32182) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Hand_of_Protection_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- SHAMAN    THUNDERSTORM
		if GoHv5_DeathKnight_Data.config.Thunderstorm == "YES" then
			if (GoH_spellID == 51490) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Lightning_Storm.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- SHAMAN    EARTHQUAKE
		if GoHv5_DeathKnight_Data.config.Earthquake == "YES" then
			if (GoH_spellID == 61882) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\KillingBlow_7_HolyShit_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- SHAMAN    WIND_SHEAR
		if GoHv5_DeathKnight_Data.config.Wind_Shear == "YES" then
			if (GoH_spellID == 57994) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Strangulate_" .. GoH_DeathKnight.Gender .. ".mp3","Master");
					
					

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
				if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == nil then
			    GoHv5_DeathKnight_Data.config.Use_Interrupted_Image = "YES";
		        end
		        if GoHv5_DeathKnight_Data.config.Use_Interrupted_Image == "YES" then

			    Show_Interrupted_Frame();
			    end
			end
		end	

	-- SHAMAN    WATER_WALKING
		if GoHv5_DeathKnight_Data.config.Water_Walking == "YES" then
			if (GoH_spellID == 546) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\JesusWalk_1.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- SHAMAN    ASTRAL_SHIFT
		if GoHv5_DeathKnight_Data.config.Astral_Shift == "YES" then
			if (GoH_spellID == 108271) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Camouflage.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- SHAMAN    FERAL_SPIRIT
		if GoHv5_DeathKnight_Data.config.Feral_Spirit == "YES" then
			if (GoH_spellID == 51533) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Feast();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- SHAMAN    SPIRIT_WALK
		if GoHv5_DeathKnight_Data.config.Spirit_Walk == "YES" then
			if (GoH_spellID == 58875) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end	

	-- SHAMAN    FROST_SHOCK
		if GoHv5_DeathKnight_Data.config.Frost_Shock == "YES" then
			if (GoH_spellID == 196840) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\FreezingFog_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end		
		
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- #######################################################################
	-- BEGIN RACIALS
	-- #######################################################################

	   -- HUMAN RACIAL: EVERY MAN FOR HIMSELF
	if GoHv5_DeathKnight_Data.config.Every_Man_For_Himself == "YES" then
		if GoH_DeathKnight.Race == "Human" then
			if (GoH_spellID == 59752) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\You_Are_Nothing_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

		-- NIGHTELF RACIAL: -- SHADOWMELD
	if GoHv5_DeathKnight_Data.config.NightElf_Racial_Shadowmeld == "YES" then
		if GoH_DeathKnight.Race == "NightElf" then
			if (GoH_spellID == 58984) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Cloak();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- WOGEN RACIAL: TWO FORMS
	if GoHv5_DeathKnight_Data.config.Worgen_Two_Forms_Racial == "YES" then
		if GoH_DeathKnight.Race == "Worgen" then
			if (GoH_spellID == 68996) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- GNOME RACIAL: ESCAPE ARTIST
	if GoHv5_DeathKnight_Data.config.Gnome_Escape_Artist_Racial == "YES" then
		if GoH_DeathKnight.Race == "Gnome" then
			if (GoH_spellID == 20589) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- DRAENEI RACIAL: GIFT OF THE NAARU
	if GoHv5_DeathKnight_Data.config.Draenei_Gift_Racial == "YES" then
		if GoH_DeathKnight.Race == "Draenei" then
			if (GoH_spellName == Draenei_Gift_of_the_Naaru_Name) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\HolyPower_1.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- PANDAREN RACIAL: QUAKING PALM
	if GoHv5_DeathKnight_Data.config.Pandaren_Quaking_Palm_Racial == "YES" then
		if GoH_DeathKnight.Race == "Pandaren" then
			if (GoH_spellID == 107079) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Woooaaaoo.mp3","Master");

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- BLOOD ELF RACIAL: ARCANE TORRENT
	if GoHv5_DeathKnight_Data.config.BloodElf_Arcane_Torrent_Racial == "YES" then
		if (GoH_DeathKnight.Race == "BloodElf") or (GoH_DeathKnight.Race == "Blood Elf") then
			if (GoH_spellName == BloodElf_Arcane_Torrent_Name) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- GOBLIN RACIAL: ROCKET JUMP
	if GoHv5_DeathKnight_Data.config.Goblin_Rocket_Jump_Racial == "YES" then
		if GoH_DeathKnight.Race == "Goblin" then
			if (GoH_spellID == 69070) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- ORC RACIAL: BLOOD FURY
	if GoHv5_DeathKnight_Data.config.Orc_Blood_Fury_Racial == "YES" then
		if GoH_DeathKnight.Race == "Orc" then
			if (GoH_spellName == Orc_Blood_Fury_Name) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- TROLL RACIAL: BERSERKING
	if GoHv5_DeathKnight_Data.config.Troll_Berserking_Racial == "YES" then
		if GoH_DeathKnight.Race == "Troll" then
			if (GoH_spellID == 26297) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- UNDEAD RACIAL: WILL OF THE FORSAKEN
	if GoHv5_DeathKnight_Data.config.Undead_Will_of_the_Forsaken_Racial == "YES" then
		if (GoH_DeathKnight.Race == "Undead") or (GoH_DeathKnight.Race == "Forsaken") or (GoH_DeathKnight.Race == "Scourge") then
			if (GoH_spellID == 7744) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DeathKnight.CharName)then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

end



-- #######################################
-- #######################################
-- UNIT SPELLCAST SUCCEEDED
-- #######################################
-- #######################################
function GoH_DeathKnight.events.UNIT_SPELLCAST_SUCCEEDED(caster, GoH_spellName, arg2, arg3, GoH_spellID, arg5, ...)


	   -- DWARF RACIAL: STONEFORM
	if GoHv5_DeathKnight_Data.config.Dwarve_Stoneform_Racial == "YES" then
		if GoH_DeathKnight.Race == "Dwarf" then
			if (GoH_spellName == Dwarve_Stoneform_Name) and (caster == "player")then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end

	   -- TAUREN RACIAL: WAR STOMP
	if GoHv5_DeathKnight_Data.config.Tauren_War_Stomp_Racial == "YES" then
		if GoH_DeathKnight.Race == "Tauren" then
			if (GoH_spellName == Tauren_War_Stomp_Name) and (caster == "player")then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					Play_Random_Laugh();

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end
	end
	


	if (GoH_DeathKnight.Class == "DEATHKNIGHT") then -- BEGIN CLASS CHECK

		-- DEATH KNIGHT: ACHERUS DEATHCHARGER
		if GoHv5_DeathKnight_Data.config.Acherus_Deathcharger == "YES" then
			if (GoH_spellName == DeathKnight_Acherus_Deathcharger_Name) and (caster == "player")then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Summon_Mount_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- DO YOUR EMOTE
					if GoHv5_DeathKnight_Data.config.Acherus_Deathcharger_UseName == "YES" then
						if GoH_DeathKnight.Gender == "Female" then
								SendChatMessage("summons " .. GoHv5_DeathKnight_Data.config.Acherus_Deathcharger_CustomName .. ", her trusty " .. GetSpellLink(DeathKnight_Acherus_Deathcharger_ID) .. ".", "EMOTE");
						else
								SendChatMessage("summons " .. GoHv5_DeathKnight_Data.config.Acherus_Deathcharger_CustomName .. ", his trusty " .. GetSpellLink(DeathKnight_Acherus_Deathcharger_ID) .. ".", "EMOTE");
						end
					end

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end

			end
		end

		-- DEATH KNIGHT: WINGED STEED OF THE EBON BLADE
		if GoHv5_DeathKnight_Data.config.Winged_Steed_of_the_Ebon_Blade == "YES" then
			if (GoH_spellName == DeathKnight_Winged_Steed_Name) and (caster == "player")then

				if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

					-- PLAY YOUR SOUND
					PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Summon_Mount_" .. GoH_DeathKnight.Gender .. ".mp3","Master");

					-- DO YOUR EMOTE
					if GoHv5_DeathKnight_Data.config.Winged_Steed_of_the_Ebon_Blade_UseName == "YES" then
						if GoH_DeathKnight.Gender == "Female" then
								SendChatMessage("summons " .. GoHv5_DeathKnight_Data.config.Winged_Steed_of_the_Ebon_Blade_CustomName .. ", her trusty " .. GetSpellLink(DeathKnight_Winged_Steed_ID) .. ".", "EMOTE");
						else
								SendChatMessage("summons " .. GoHv5_DeathKnight_Data.config.Winged_Steed_of_the_Ebon_Blade_CustomName .. ", his trusty " .. GetSpellLink(DeathKnight_Winged_Steed_ID) .. ".", "EMOTE");
						end
					end

					-- RESET THE TIMER
					GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
					-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

				end
			end
		end

	end -- END DEATH KNIGHT CLASS CHECK
end




-- #######################################
-- #######################################
-- PLAYER ENTER COMBAT SOUNDS
-- #######################################
-- #######################################
function GoH_DeathKnight.events.PLAYER_REGEN_DISABLED()

	if GoHv5_DeathKnight_Data.config.Menu_Fight_Sound == "YES" then

			if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

				-- PLAY YOUR SOUND
				Play_Random_Combat();

				-- RESET THE TIMER
				GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
				-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

			end
	end


end



-- #######################################
-- #######################################
-- PLAYER LEAVE COMBAT SOUNDS
-- #######################################
-- #######################################
function GoH_DeathKnight.events.PLAYER_REGEN_ENABLED()

    if event == "PLAYER_REGEN_ENABLED" and UnitIsDeadOrGhost("player") then return end

	if GoHv5_DeathKnight_Data.config.Fatality_Sound == "YES" then

			if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

				-- PLAY YOUR SOUND
				Play_Random_Finish();

				-- RESET THE TIMER
				GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
				-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

			end
	end


end


function GoH_DeathKnight.events.PLAYER_LOGIN()

            Show_Intro_Frame()

			local playerClass, EngClass = UnitClass("player");
			GoH_DeathKnight.Class = EngClass;
			GoHv5_DeathKnight_Data.config.LoggedInAsClass = GoH_DeathKnight.Class;
			-- print(GoHv5_DeathKnight_Data.config.LoggedInAsClass)

			
			            
			
			             -- GOH SETTING: GENDER BENDER
						if GoHv5_DeathKnight_Data.config.Gender_Bender == nil then
							GoHv5_DeathKnight_Data.config.Gender_Bender = "NO";
						end

						if GoH_DeathKnight.RealGender == nil then
							GoH_DeathKnight.RealGender = genderTable[UnitSex("player")];
						end
						if GoH_DeathKnight.Gender == nil then
							GoH_DeathKnight.Gender = GoH_DeathKnight.RealGender;
						end

			-- GOH SETTING: GENDER BENDER
			if GoHv5_DeathKnight_Data.config.Gender_Bender == "NO" then
				-- REAL GENDER
				GoH_DeathKnight.Gender = GoH_DeathKnight.RealGender;
			else
				-- OPPOSITE TO REAL
				if GoH_DeathKnight.RealGender == "Female" then
					-- Change to Male
					GoH_DeathKnight.Gender = "Male";
				else
					-- Change to Female
					GoH_DeathKnight.Gender = "Female";
				end
			end

			if (GoH_DeathKnight.Class == "DEATHKNIGHT") then
				if GoHv5_DeathKnight_Data.config.Stupid_Login_Sound == "YES"then

					if GoHv5_DeathKnight_Data.config.GoH_Timer_Ready == "YES" then

						-- PLAY YOUR SOUND
						-- REMEMBER WHO OWNS YOUR SOUL DEATHKNIGHT
						if (GoH_DeathKnight.Gender == "Female") then
							PlaySoundFile("Interface\\AddOns\\GoH_DeathKnight\\Sounds\\Remember_Who_Owns_Your_Soul_DeathKnight_Female.mp3","Master");
						else
							PlaySoundFile("Sound\\Creature\\LichKing\\EH_LichKing_Irritated1.ogg","Master");
						end

						-- RESET THE TIMER
						GoHv5_DeathKnight_Data.config.GoH_Timer_Ready = "NO"; GoHv5_DeathKnight_Data.config.GoH_Timer_Time = 0;
						-- print(GoHv5_DeathKnight_Data.config.GoH_Timer_Ready);

					end
				end
			end
end



