-- #######################################
-- #######################################
-- SINCE THIS IS THE DEATH KNIGHT PART OF GOH
-- ALL GoHs CHANGED TO GoH_DeathKnight
-- #######################################
-- #######################################

-- GoH Event Registrations
	GoH_DeathKnight = {}
	GoH_DeathKnight.events = {}

	GoH_DeathKnight.eventFrame = CreateFrame("Frame");
	GoH_DeathKnight.eventFrame:SetScript("OnEvent", function(self, event, ...) GoH_DeathKnight.events[event](...) end);

	-- EVERY EVENT YOU REGISTER MUST HAVE A FUNCTION
	GoH_DeathKnight.eventFrame:RegisterEvent("ADDON_LOADED");
   	GoH_DeathKnight.eventFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
    GoH_DeathKnight.eventFrame:RegisterEvent("PLAYER_REGEN_DISABLED");
   	GoH_DeathKnight.eventFrame:RegisterEvent("PLAYER_REGEN_ENABLED");
    GoH_DeathKnight.eventFrame:RegisterEvent("PLAYER_LOGIN")
    GoH_DeathKnight.eventFrame:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
    GoH_DeathKnight.eventFrame:RegisterEvent("PETITION_SHOW")
    GoH_DeathKnight.eventFrame:RegisterEvent("PARTY_INVITE_REQUEST")
    GoH_DeathKnight.eventFrame:RegisterEvent("ARENA_TEAM_INVITE_REQUEST")
    GoH_DeathKnight.eventFrame:RegisterEvent("DUEL_REQUESTED")
    GoH_DeathKnight.eventFrame:RegisterEvent("AUCTION_HOUSE_SHOW")
    GoH_DeathKnight.eventFrame:RegisterEvent("AUCTION_HOUSE_CLOSED")
    GoH_DeathKnight.eventFrame:RegisterEvent("PLAYER_ENTERING_WORLD")



-- #######################################
-- #######################################
-- INFORMATION GATHERING FOR VARIABLES LATER ON
-- #######################################
-- #######################################
	-- GENDER TABLE
	local genderTable = { "Unknown", "Male", "Female" };
	-- PLAYER CLASS
	local playerClass, EngClass = UnitClass("player");

	-- PLAYER FACTION
	local englishFaction, localizedFaction = UnitFactionGroup("player");

	-- PLAYER RACE
	local GoH_race, GoH_raceEn = UnitRace("player");

	local GoH_NoClassFormsOpen = "NO";


-- #######################################
-- #######################################
-- VARIABLES YOU CAN USE TO CHECK THINGS
-- #######################################
-- #######################################
	-- UNITNAME: CHARACTER / FACTION / CLASS / GENDER / LEVEL
	GoH_DeathKnight.CharName = UnitName("player");				-- (ToonName) Your Toon
	GoH_DeathKnight.Class = EngClass; 							-- (Class) Your Toon
	GoH_DeathKnight.Gender = genderTable[UnitSex("player")];	-- (Gender) Your Toon
	GoH_DeathKnight.Faction = englishFaction;					-- (Faction) Your Toon (Neutral,Horde, Alliance)
	GoH_DeathKnight.CharLevel = UnitLevel("player");			-- (Level) Of Your Toon
	GoH_DeathKnight.NumberRandom = 1;							-- (Random Number Generator)
	GoH_DeathKnight.Race = GoH_raceEn;	                        -- (Race) Of Your Toon
    GoH_DeathKnight.RealGender = genderTable[UnitSex("player")];	-- (Gender) Your Toon
	GoH_DeathKnight.SavedVariablesLoaded = "NO"


-- #######################################
-- #######################################
-- LOAD ADDON FUNCTION
-- #######################################
-- #######################################
function GoH_DeathKnight.events.ADDON_LOADED(addon)

	if addon ~= "GoH_DeathKnight" then
		return;
	end

	GoH_DeathKnight_Form:SetScale(0.9);
	GoH_DeathKnight_Form:SetAlpha(0.85);

	   -- IF NO SAVED VARIABLES, CALL DEFAULT VARIABLES
 	   if (not GoHv5_DeathKnight_Data) then
		-- CALL RESET
		GoH5_DeathKnight_DefaultVariables();
	   end

		-- STUPID ISSUE WITH CLASS NOT BEING LOADED/SAVED IF IN LAGVILLE
		-- THIS IS HERE TO ATTEMPT TO FORCE IT THROUGH.
		local playerClass, EngClass = UnitClass("player");
		GoH_DeathKnight.Class = EngClass;
		GoHv5_DeathKnight_Data.config.LoggedInAsClass = GoH_DeathKnight.Class;
		-- print(GoHv5_DeathKnight_Data.config.LoggedInAsClass)

		GoH_MinimapButton_Reposition();
		GoH_DeathKnight_Set_Menu_Button_Images();
		GoH_DeathKnight_Set_DeathCharger_Button_Images();
		GoH_DeathKnight_Set_Winged_Steed_Button_Images();


    -- Slash Options
    SlashCmdList["GoH_DeathKnight"] = GoH_DeathKnight.Options
        SLASH_GoH_DeathKnight1 = "/GoH_DK"
        SLASH_GoH_DeathKnight2 = "/GOH_deathknight"
        SLASH_GoH_DeathKnight3 = "/dk"
        SLASH_GoH_DeathKnight4 = "/deathknight"
        SLASH_GoH_DeathKnight5 = "/gohdk"
        SLASH_GoH_DeathKnight6 = "/gohdeathknight"
	  SlashCmdList["GoH_DeathKnight"] = GoH_DeathKnight_SlashOpenClose;

	if GoH_DeathKnight.Faction == "Horde" then
		DeathKnight_FactionPicTexture:SetTexture("interface\\AddOns\\GoH\\Images\\GoH_v5_BackGround_Faction_Horde.tga")
	elseif GoH_DeathKnight.Faction == "Alliance" then
		DeathKnight_FactionPicTexture:SetTexture("interface\\AddOns\\GoH\\Images\\GoH_v5_BackGround_Faction_Alliance.tga")
	elseif GoH_DeathKnight.Faction == "Neutral" then
		DeathKnight_FactionPicTexture:SetTexture("interface\\AddOns\\GoH\\Images\\GoH_v5_BackGround_Faction_Neutral.tga")
	end
	if GoH_DeathKnight.Gender == "Female" then
		DeathKnight_Female_Texture:Show();
	else
		DeathKnight_Female_Texture:Hide();
	end

	-- START THE TIMER
	GoHv5_Timer_Frame:Show();

	GoH5_DeathKnight_SavedVariables();

		-- SHOW / HIDE MINIMAP ICON
	    if GoHv5_DeathKnight_Data.config.Show_Minimap_Icon == "YES" then
	    	GoH_MinimapButton:Show();
	    else
	    	GoH_MinimapButton:Hide();
	    end

end

function GoH_DeathKnight_SlashOpenClose()

	if (GoH_DeathKnight_Form:IsVisible()) then

		GoH_DeathKnight_BUTTON_CLOSE_OnClick()

	else
		GoH_NoClassFormsOpen = "NO";
		GoH_CheckClassMenu_Minimap();
		if GoH_NoClassFormsOpen == "YES" then
			GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "YES"
				GoH_DeathKnight_OPEN_MENU();
			GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "NO"
		elseif GoH_NoClassFormsOpen == "NO" then
			GoH_DeathKnight_OPEN_MENU();
		end
	end
end

-- CLOSE BUTTON
function GoH_DeathKnight_BUTTON_CLOSE_OnClick()

	Play_DeathKnight_GUI_Close();
	GoH_DeathKnight_Form:Hide();

end

-- OPEN MENU
function GoH_DeathKnight_OPEN_MENU()

	if (GoH_DeathKnight_Form:IsVisible()) then
		Play_DeathKnight_GUI_Close();
	else
		GoH_NoClassFormsOpen = "NO";
		GoH_CheckClassMenu_Minimap()
		if GoH_NoClassFormsOpen == "YES" then
		else
			Play_DeathKnight_GUI_Open();
			GoH_NoClassFormsOpen = "NO";
		end
	end

	GoH_DeathKnight_Hide_and_Seek();

		-- Get the Version of the DeathKnight's Addon from the TOC file
		-- and display it on the DeathKnight's Menu near the close button.
		GoH_DeathKnight_Addon_Version = GetAddOnMetadata("GoH_DeathKnight", "Version");
		Label_GoHv5_DeathKnight_VERSION:SetText("|cFFFFD000GoH DeathKnight v"..GoH_DeathKnight_Addon_Version.."|r");

end

function GoH_Lose_Focus_of_EditBoxes()

	GoH_Check_Deathcharger_MOUNT_NAME_Text();
	GoH_Check_WingedSteed_MOUNT_NAME_Text();
	GoH_Check_Whisper_Reply_Message_Text();

	GoH5_EditBox_DeathKnight_Winged_Steed_MOUNT_NAME:ClearFocus();
	GoH5_EditBox_DeathKnight_Winged_Steed_MOUNT_NAME:EnableKeyboard(false);
	GoH5_EditBox_DeathKnight_DeathCharger_MOUNT_NAME:ClearFocus();
	GoH5_EditBox_DeathKnight_DeathCharger_MOUNT_NAME:EnableKeyboard(false);
	GoH5_EditBox_Whisper_Reply_Message:ClearFocus();
	GoH5_EditBox_Whisper_Reply_Message:EnableKeyboard(false);
	GoH5_EditBox_Settings_Auction_House_Reply:ClearFocus();
	GoH5_EditBox_Settings_Auction_House_Reply:EnableKeyboard(false);
	GoH5_EditBox_Settings_In_Combat_Reply:ClearFocus();
	GoH5_EditBox_Settings_In_Combat_Reply:EnableKeyboard(false);

end


function GoH_Check_Deathcharger_MOUNT_NAME_Text()
	GoHv5_DeathKnight_Data.config.Acherus_Deathcharger_CustomName = GoH5_EditBox_DeathKnight_DeathCharger_MOUNT_NAME:GetText();
	if GoH5_EditBox_DeathKnight_DeathCharger_MOUNT_NAME:GetText() == "" then
		GoH5_EditBox_DeathKnight_DeathCharger_MOUNT_NAME:SetText("Bam Bam");
		GoHv5_DeathKnight_Data.config.Acherus_Deathcharger_CustomName = GoH5_EditBox_DeathKnight_DeathCharger_MOUNT_NAME:GetText();
	end
end


function GoH_Check_WingedSteed_MOUNT_NAME_Text()
	GoHv5_DeathKnight_Data.config.Winged_Steed_of_the_Ebon_Blade_CustomName = GoH5_EditBox_DeathKnight_Winged_Steed_MOUNT_NAME:GetText();
	if GoH5_EditBox_DeathKnight_Winged_Steed_MOUNT_NAME:GetText() == "" then
		GoH5_EditBox_DeathKnight_Winged_Steed_MOUNT_NAME:SetText("Pebbles");
		GoHv5_DeathKnight_Data.config.Winged_Steed_of_the_Ebon_Blade_CustomName = GoH5_EditBox_DeathKnight_Winged_Steed_MOUNT_NAME:GetText();
	end
end

-- HIDE OTHER MENU FRAMES AND ALIGN THEM TO THE CORRECT USER PLACED LOCATION
function GoH_DeathKnight_Hide_and_Seek()

		-- SHOW / HIDE MINIMAP ICON
		if GoHv5_DeathKnight_Data.config.Show_Minimap_Icon == nil then
			GoHv5_DeathKnight_Data.config.Show_Minimap_Icon = "YES";
		end
	    if GoHv5_DeathKnight_Data.config.Show_Minimap_Icon == "YES" then
	    	GoH_MinimapButton:Show();
	    else
	    	GoH_MinimapButton:Hide();
	    end

	-- GOH DEATHKNIGHT: Page Tab
	if GoHv5_DeathKnight_Data.config.Page_Tab == nil then
		GoHv5_DeathKnight_Data.config.Page_Tab = "ONE";
	end
	if GoHv5_DeathKnight_Data.config.Page_Tab == "TWO" then
		-- PAGE TWO
		GoH_DEATHKNIGHT_PAGE_TAB_TWO_BUTTON_ICON:Disable();
		GoH_DeathKnight_Frame:Hide();

		GoH_DEATHKNIGHT_PAGE_TAB_ONE_BUTTON_ICON:Enable();
		GoH_DeathKnight_Frame_Page2:Show();

	else
		-- PAGE ONE
		GoH_DEATHKNIGHT_PAGE_TAB_ONE_BUTTON_ICON:Disable();
		GoH_DeathKnight_Frame_Page2:Hide();

		GoH_DEATHKNIGHT_PAGE_TAB_TWO_BUTTON_ICON:Enable();
		GoH_DeathKnight_Frame:Show();

	end

	-- TURN OFF AUTO FOCUS ON EDIT BOXES
	GoH5_EditBox_DeathKnight_Winged_Steed_MOUNT_NAME:SetAutoFocus(false);
	GoH5_EditBox_DeathKnight_DeathCharger_MOUNT_NAME:SetAutoFocus(false);

	GoH5_EditBox_DeathKnight_DeathCharger_MOUNT_NAME:SetText(GoHv5_DeathKnight_Data.config.Acherus_Deathcharger_CustomName);
	GoH5_EditBox_DeathKnight_Winged_Steed_MOUNT_NAME:SetText(GoHv5_DeathKnight_Data.config.Winged_Steed_of_the_Ebon_Blade_CustomName);

	GoH5_EditBox_Whisper_Reply_Message:SetAutoFocus(false);
	GoH5_EditBox_Whisper_Reply_Message:SetText(GoHv5_DeathKnight_Data.config.AutoDecline_Whisper_Message);

	GoH5_EditBox_Settings_Auction_House_Reply:SetAutoFocus(false);
	GoH5_EditBox_Settings_Auction_House_Reply:SetText(GoHv5_DeathKnight_Data.config.AutoDND_Auction_House_Whisper_Message);

	GoH5_EditBox_Settings_In_Combat_Reply:SetAutoFocus(false);
	GoH5_EditBox_Settings_In_Combat_Reply:SetText(GoHv5_DeathKnight_Data.config.AutoDND_In_Combat_Whisper_Message);


	GoH_DeathKnight.Class = GoHv5_DeathKnight_Data.config.LoggedInAsClass;

	-- ###########################
	-- Disable Menu Button for Menu you are on
	-- ###########################
	GoHv5_DeathKnight_MenuButtonDeathKnight:Disable();

	-- ###########################
	-- Hide all other addon menus and show the one you want
	-- ###########################


	-- #######################################################
	-- Match all other addon menus to the Settings location
	-- #######################################################

	-- Release all points before re-assigning or we'll get a lua error
	if (GoH_Form:IsVisible()) then
		GoH_Form:ClearAllPoints();
		GoH_Form:Hide();
		GoH_DeathKnight_Form:ClearAllPoints();
		GoH_DeathKnight_Form:SetPoint("TOPLEFT", "GoH_Form");
		GoH_DeathKnight_Form:Show();
	else

		GoH_DeathKnight_Form:Show();
	end

	GoH_Lose_Focus_of_EditBoxes();

end



-- MINIMAP OPEN CLOSE
function GoH_DeathKnight_MINIMAP_TOGGLE()

	GoH_DeathKnight.Class = GoHv5_DeathKnight_Data.config.LoggedInAsClass;

	--LEFT MOUSE BUTTON
	
		if (GoH_Form:IsVisible()) then

			GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "YES"
			GoH_OpenClassMenu_Minimap();
			GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "NO"

		else

			GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "YES"
			GoH_NoClassFormsOpen = "NO";
			GoH_CloseClassMenu_Minimap();
			GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "NO"

			if GoH_NoClassFormsOpen == "NO" then
				GoH_OpenClassMenu_Minimap();
			end

		end

	GoH_Lose_Focus_of_EditBoxes();

end

-- MINIMAP OPEN CLOSE
function GoH_Settings_MINIMAP_TOGGLE()

	GoH_DeathKnight.Class = GoHv5_DeathKnight_Data.config.LoggedInAsClass;

	--RIGHT MOUSE BUTTON
	
		if (GoH_Form:IsVisible()) then

			GoH_NoClassFormsOpen = "NO";
			GoH_CheckClassMenu_Minimap();
			if GoH_NoClassFormsOpen == "YES" then
				GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "YES"
					GoH_BUTTON_CLOSE_OnClick();
				GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "NO"
			elseif GoH_NoClassFormsOpen == "NO" then
				GoH_BUTTON_CLOSE_OnClick();
			end

		else

			GoH_NoClassFormsOpen = "NO";
			GoH_CheckClassMenu_Minimap();
			if GoH_NoClassFormsOpen == "YES" then
				GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "YES"
					GoH_OPEN_MENU();
				GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "NO"
			end

			if GoH_NoClassFormsOpen == "NO" then
				GoH_OPEN_MENU();
			end

		end

	GoH_Lose_Focus_of_EditBoxes();

end

function GoH_CheckClassMenu_Minimap()

	GoH_DeathKnight.Class = GoHv5_DeathKnight_Data.config.LoggedInAsClass;


	GoH_Lose_Focus_of_EditBoxes();

end

function GoH_CloseClassMenu_Minimap()

	GoH_DeathKnight.Class = GoHv5_DeathKnight_Data.config.LoggedInAsClass;


	GoH_Lose_Focus_of_EditBoxes();

end

function GoH_OpenClassMenu_Minimap()

	GoH_DeathKnight.Class = GoHv5_DeathKnight_Data.config.LoggedInAsClass;
    -- print(GoHv5_DeathKnight_Data.config.LoggedInAsClass);

	GoH_Lose_Focus_of_EditBoxes();

end


-- ###################################
-- ###################################
-- CLASS MENU AND SETTINGS BUTTON AREA
-- ###################################
-- ###################################


function GoHv5_DeathKnight_MenuButtonSettings_OnClick()

		GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "YES"
		GoH_OPEN_MENU();
		GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "NO"

end

function GoHv5_DeathKnight_MenuButtonDeathKnight_OnClick()

		GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "YES"
		GoH_DeathKnight_OPEN_MENU();
		GoHv5_DeathKnight_Data.config.GoH_MenuOpenedAlready = "NO"

end


-- #######################################
-- #######################################
-- Call this in a mod's initialization to move the minimap button to its saved position (also used in its movement)
function GoH_MinimapButton_Reposition()
	GoH_MinimapButton:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-(80*cos(GoH_MinimapIcon.GoH_MinimapPos)),(80*sin(GoH_MinimapIcon.GoH_MinimapPos))-52)

end

-- Only while the button is dragged this is called every frame
function GoH_MinimapButton_DraggingFrame_OnUpdate()

	local xpos,ypos = GetCursorPosition()
	local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom()

	xpos = xmin-xpos/UIParent:GetScale()+70 -- get coordinates as differences from the center of the minimap
	ypos = ypos/UIParent:GetScale()-ymin-70

	GoH_MinimapIcon.GoH_MinimapPos = math.deg(math.atan2(ypos,xpos)) -- save the degrees we are relative to the minimap center
	GoH_MinimapButton_Reposition() -- move the button
end

function GoH_MinimapButton_OnEnter(self)
	if (self.dragging) then
		return
	end
	GameTooltip:SetOwner(self or UIParent, "ANCHOR_LEFT")
	GoH_MinimapButton_Details(GameTooltip)
end


function GoH_MinimapButton_Details(tt, ldb)
	tt:SetText("Get Over Here!")

end

