--[[To do:
Add a very minor UI and integrate into the options menu.
Look up better LUA table practices.
Use a compression algorithm to reduce the size of the database.]]
local SearchFrame = CreateFrame("Frame")
local nTopID = 160000 --Update this for new item IDs, http://www.wowhead.com/items?filter=151;2;0#items:0-1-2
local bBuilding = false
local tc = {
	["a335ee"] = "1",
	["0070dd"] = "2",
	["1eff00"] = "3",
	["ffffff"] = "4",
	["9d9d9d"] = "5",
	["ff8000"] = "6",
	["00ccff"] = "7",
	["e6cc80"] = "8"
}
local rtc = {
	["1"] = "a335ee",
	["2"] = "0070dd",
	["3"] = "1eff00",
	["4"] = "ffffff",
	["5"] = "9d9d9d",
	["6"] = "ff8000",
	["7"] = "00ccff",
	["8"] = "e6cc80"
}
local nCurrentID

SLASH_GetLink1 = "/gl"
SLASH_BuildLink1 = "/getlink"
SLASH_TestLink1 = "/gltest"

SlashCmdList["GetLink"] = function(msg)
	GetLink_Command(msg)
end

SlashCmdList["BuildLink"] = function(msg)
	GetLinkBuild_Command(msg)
end

SlashCmdList["TestLink"] = function(msg)
	GLTest(msg)
end

function GLTest(msg)
	GLTable = {}
end
	
function GetLinkBuild_Command(msg)
	if not bBuilding then
		bBuilding = true
		nCurrentID = nTopID
		SearchFrame:SetScript("OnUpdate", GetSearch)
		print("Updating the database.")
	elseif bBuilding then print("Working, " ..  math.floor(100 * (1 - (nCurrentID / nTopID))) .. "% complete.") end
end

--[[Checks the query to make sure it's a decent length to prevent full on spam.
Then it turns it and the results into lower case and generates the saved link if there's
a match.  If there's a - then we need to replace that to %%- to work around the search
filters built into LUA strings.  May need to add other filters in the future.]]

function GetLink_Command(msg)
	if msg:len() > 2 then
		msg = string.lower(msg:gsub("-", "%%-"))
		for idnum in pairs(GLTable) do
			if string.find(GLTable[idnum]:lower(), msg, 2) then
				print("|cff" .. rtc[GLTable[idnum]:sub(1,1)] .. "|Hitem:" .. idnum .. ":::::::::::::::|h[" .. GLTable[idnum]:sub(2) .. "]|h|r")
			end
		end
		print("End of results.")
	else
		print("The query is too short.")
	end
end

--[[Splits the potential item pool into groups of fifty, checks if there's already
an entry in the saved database.  If there isn't an entry it requests the item information.]]

function GetSearch(self, elapsed)
	if bBuilding and nCurrentID > 0 then
		TickStop = nCurrentID - 50
		if TickStop < 0	then TickStop = 0 end
		while nCurrentID > TickStop do
			if not GLTable[nCurrentID] then
				name, link = GetItemInfo(nCurrentID)
				if name then 
					GLTable[nCurrentID] = string.format("%s%s", tc[link:sub(5, 10)], name)
				end
			elseif GLTable[nCurrentID] then
				TickStop = TickStop - 1
			end
			nCurrentID = nCurrentID - 1
		end
	elseif bBuilding then
		bBuilding = false
		SearchFrame:SetScript("OnUpdate", nil)
		print("The database has been updated.  Use /gl [text] to search.")
	end
end

--[[SearchFrame registers this function to activate whenever the addon is loaded
and whenever item data is received.  If there's no database it will create an empty
one.  If the item info is not in the database it will add it.]]

function EventHandler(self, event, arg1)
	if event == "ADDON_LOADED" and arg1 == "GetLink" then
		local nCurrentID = nTopID
		if not GLTable then GLTable = {}
			print("Get Link: Welcome!  To get started, use /getlink to build your database.  Once that's built use /gl [text] to search.")
		elseif GLTable[6948] and GLTable[6948]:find(":::") then
			for idnum in pairs(GLTable) do
				name = GLTable[idnum]:match("%[(.*)%]")
				if name then 
					GLTable[idnum] = string.format("%s%s", tc[GLTable[idnum]:sub(5, 10)], name)
				end
			end
		end
	elseif event == "GET_ITEM_INFO_RECEIVED" then
		if not GLTable[arg1] then
			name, link = GetItemInfo(arg1)
			GLTable[arg1] = string.format("%s%s", tc[link:sub(5, 10)], name)
		end
	end			
end


SearchFrame:RegisterEvent("ADDON_LOADED")
SearchFrame:RegisterEvent("GET_ITEM_INFO_RECEIVED")
SearchFrame:SetScript("OnEvent", EventHandler)
