-- Get localization
local L = LibStub("AceLocale-3.0"):GetLocale("GarrisonJukeBox")

-- table holding music info (name, file, length)
local musictable = {
	-- Classic
	i1wow = {
		{
			name = L["TITLE_MAIN_THEME"],
			files = {
				{"Sound\\Music\\GlueScreenMusic\\wow_main_theme.mp3", 161},
			},
		},
		{
			name = L["TITLE_TIRISFAL"],
			files = {
				{"Sound\\Music\\ZoneMusic\\EvilForest\\DayEvilForest01.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\EvilForest\\DayEvilForest02.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\EvilForest\\DayEvilForest03.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\EvilForest\\NightEvilForest01.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\EvilForest\\NightEvilForest02.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\EvilForest\\NightEvilForest03.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Forest\\DayForest01.mp3", 55},
				{"Sound\\Music\\ZoneMusic\\Forest\\DayForest02.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\Forest\\DayForest03.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\Forest\\NightForest01.mp3", 53},
				{"Sound\\Music\\ZoneMusic\\Forest\\NightForest02.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\Forest\\NightForest03.mp3", 59},
				{"Sound\\Music\\ZoneMusic\\Forest\\NightForest04.mp3", 54},
			},
		},
		{
			name = L["TITLE_MOLTENCORE"],
			files = {
				{"Sound\\Music\\Musical Moments\\battle\\battle01.mp3", 48},
			},
		},
		{
			name = L["TITLE_ASHENVALE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\EnchantedForest\\EnchantedForest01.mp3", 50},
				{"Sound\\Music\\ZoneMusic\\EnchantedForest\\EnchantedForest02.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\EnchantedForest\\EnchantedForest03.mp3", 235},
				{"Sound\\Music\\ZoneMusic\\EnchantedForest\\EnchantedForest04.mp3", 60},
				{"Sound\\Music\\ZoneMusic\\EnchantedForest\\EnchantedForest05.mp3", 70},
			},
		},
		{
			name = L["TITLE_DARNASSUS"],
			files = {
				{"Sound\\Music\\CityMusic\\Darnassus\\Darnassus Intro.mp3", 40},
				{"Sound\\Music\\CityMusic\\Darnassus\\Darnassus Walking 1.mp3", 85},
				{"Sound\\Music\\CityMusic\\Darnassus\\Darnassus Walking 2.mp3", 69},
				{"Sound\\Music\\CityMusic\\Darnassus\\Darnassus Walking 3.mp3", 67},
				{"Sound\\Music\\CityMusic\\Darnassus\\Druid Grove.mp3", 45},
				{"Sound\\Music\\CityMusic\\Darnassus\\Warrior Terrace.mp3", 53},
			},
		},
		{
			name = L["TITLE_GNOMERAGON"],
			files = {
				{"Sound\\Music\\CityMusic\\Gnomeragon\\gnomeragon01-zone.mp3", 64},
				{"Sound\\Music\\CityMusic\\Gnomeragon\\gnomeragon02-zone.mp3", 64},
			},
		},
		{
			name = L["TITLE_IRONFORGE"],
			files = {
				{"Sound\\Music\\CityMusic\\Ironforge\\IronForge Intro.mp3", 86},
				{"Sound\\Music\\CityMusic\\Ironforge\\IronForge Walking 01.mp3", 123},
				{"Sound\\Music\\CityMusic\\Ironforge\\IronForge Walking 02.mp3", 50},
				{"Sound\\Music\\CityMusic\\Ironforge\\Ironforge Walking 03 (Glenn).mp3", 81},
				{"Sound\\Music\\CityMusic\\Ironforge\\Ironforge Walking 04.mp3", 70},
				{"Sound\\Music\\CityMusic\\Ironforge\\tinkertownintro_moment.mp3", 52},
			},
		},
		{
			name = L["TITLE_ORGRIMMAR"],
			files = {
				{"Sound\\Music\\CityMusic\\Orgrimmar\\orgrimmar01-moment.mp3", 69},
				{"Sound\\Music\\CityMusic\\Orgrimmar\\orgrimmar01-zone.mp3", 68},
				{"Sound\\Music\\CityMusic\\Orgrimmar\\orgrimmar02-moment.mp3", 62},
				{"Sound\\Music\\CityMusic\\Orgrimmar\\orgrimmar02-zone.mp3", 62},
				{"Sound\\Music\\CityMusic\\Orgrimmar\\orgrimmar_intro-moment.mp3", 40},
			},
		},
		{
			name = L["TITLE_STORMWIND"],
			files = {
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind01-moment.mp3", 54},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind02-moment.mp3", 35},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind03-moment.mp3", 70},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind04-zone.mp3", 62},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind05-zone.mp3", 61},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind06-zone.mp3", 53},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind07-zone.mp3", 87},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind08-zone.mp3", 77},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind_highSeas-moment.mp3", 133},
				{"Sound\\Music\\CityMusic\\Stormwind\\stormwind_intro-moment.mp3", 66},
			},
		},
		{
			name = L["TITLE_THUNDERBLUFF"],
			files = {
				{"Sound\\Music\\CityMusic\\Thunderbluff\\Thunderbluff Intro.mp3", 46},
				{"Sound\\Music\\CityMusic\\Thunderbluff\\Thunderbluff Walking 01.mp3", 117},
				{"Sound\\Music\\CityMusic\\Thunderbluff\\Thunderbluff Walking 02.mp3", 116},
				{"Sound\\Music\\CityMusic\\Thunderbluff\\Thunderbluff Walking 03.mp3", 121},
			},
		},
		{
			name = L["TITLE_UNDERCITY"],
			files = {
				{"Sound\\Music\\CityMusic\\Undercity\\undercity01-zone.mp3", 67},
				{"Sound\\Music\\CityMusic\\Undercity\\undercity02-zone.mp3", 85},
				{"Sound\\Music\\CityMusic\\Undercity\\undercity03-zone.mp3", 75},
				{"Sound\\Music\\CityMusic\\Undercity\\undercityintro-moment.mp3", 28},
			},
		},
		{
			name = L["TITLE_AHNQIRAJ"],
			files = {
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajInterior1.mp3", 52},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajInterior2.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajInterior3.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajInteriorCenterRoom1.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajInteriorIntroMain.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajKingRoom.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajTriangleRoom1.mp3", 23},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajTriangleRoom2.mp3", 17},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajTriangleRoom3.mp3", 15},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajTriangleRoom4.mp3", 19},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajTriangleRoom5.mp3", 31},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajTriangleRoom6.mp3", 20},
				{"Sound\\Music\\ZoneMusic\\AhnQiraj\\AhnQirajTriangleRoom7.mp3", 17},
			},
		},
		{
			name = L["TITLE_BARRENS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\BarrenDry\\DayBarrenDry01.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\BarrenDry\\DayBarrenDry02.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\BarrenDry\\DayBarrenDry03.mp3", 55},
				{"Sound\\Music\\ZoneMusic\\BarrenDry\\NightBarrenDry01.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\BarrenDry\\NightBarrenDry02.mp3", 41},
				{"Sound\\Music\\ZoneMusic\\BarrenDry\\NightBarrenDry03.mp3", 47},
			},
		},
		{
			name = L["TITLE_FELWOOD"],
			files = {
				{"Sound\\Music\\ZoneMusic\\CursedLand\\CursedLand01.mp3", 54},
				{"Sound\\Music\\ZoneMusic\\CursedLand\\CursedLand02.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\CursedLand\\CursedLand03.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\CursedLand\\CursedLand04.mp3", 79},
				{"Sound\\Music\\ZoneMusic\\CursedLand\\CursedLand05.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\CursedLand\\CursedLand06.mp3", 74},
			},
		},
		{
			name = L["TITLE_TANARIS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Desert\\DayDesert01.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Desert\\DayDesert02.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\Desert\\DayDesert03.mp3", 54},
				{"Sound\\Music\\ZoneMusic\\Desert\\NightDesert01.mp3", 77},
				{"Sound\\Music\\ZoneMusic\\Desert\\NightDesert02.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\Desert\\NightDesert03.mp3", 57},
			},
		},
		{
			name = L["TITLE_STRAGLETHORN"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Jungle\\DayJungle01.mp3", 46},
				{"Sound\\Music\\ZoneMusic\\Jungle\\DayJungle02.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\Jungle\\DayJungle03.mp3", 48},
				{"Sound\\Music\\ZoneMusic\\Jungle\\NightJungle01.mp3", 54},
				{"Sound\\Music\\ZoneMusic\\Jungle\\NightJungle02.mp3", 53},
				{"Sound\\Music\\ZoneMusic\\Jungle\\NightJungle03.mp3", 89},
			},
		},
		{
			name = L["TITLE_WINTERSPRING"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Mountain\\DayMountain01.mp3", 120},
				{"Sound\\Music\\ZoneMusic\\Mountain\\DayMountain02.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Mountain\\DayMountain03.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\Mountain\\NightMountain01.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\Mountain\\NightMountain02.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\Mountain\\NightMountain03.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\Mountain\\NightMountain04.mp3", 64},
			},
		},
		{
			name = L["TITLE_NAXXRAMAS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasAbominationBoss1.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasAbominationBoss2.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasAbominationWing1.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasAbominationWing2.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasAbominationWing3.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasFrostwyrm1.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasFrostwyrm2.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasFrostwyrm3.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasFrostwyrm4.mp3", 60},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasHubBase1.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasHubBase2.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasKelThuzad1.mp3", 95},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasKelThuzad2.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasKelThuzad3.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasPlagueBoss1.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasPlagueWing1.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasPlagueWing2.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasPlagueWing3.mp3", 77},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasSpiderBoss1.mp3", 60},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasSpiderBoss2.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasSpiderWing1.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasSpiderWing2.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasSpiderWing3.mp3", 47},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasWalking1.mp3", 102},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasWalking2.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasWalking3.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasWalking4.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasWalking5.mp3", 100},
				{"Sound\\Music\\ZoneMusic\\Naxxramas\\NaxxramasWalking6.mp3", 99},
			},
		},
		{
			name = L["TITLE_PLAINS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Plains\\DayPlains01.mp3", 53},
				{"Sound\\Music\\ZoneMusic\\Plains\\DayPlains02.mp3", 76},
				{"Sound\\Music\\ZoneMusic\\Plains\\NightPlains01.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\Plains\\NightPlains02.mp3", 68},
			},
		},
		{
			name = L["TITLE_SWAMPOFSORROWS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\SoggyPlace\\soggyplace-zone1.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\SoggyPlace\\soggyplace-zone2.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\SoggyPlace\\soggyplace-zone3.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\SoggyPlace\\soggyplace-zone4.mp3", 89},
				{"Sound\\Music\\ZoneMusic\\SoggyPlace\\soggyplace-zone5.mp3", 70},
			},
		},
		{
			name = L["TITLE_BURNINGSTEPPES"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Volcanic\\DayVolcanic01.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\Volcanic\\DayVolcanic02.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\Volcanic\\NightVolcanic01.mp3", 71},
				{"Sound\\Music\\ZoneMusic\\Volcanic\\NightVolcanic02.mp3", 64},
			},
		},
		{
			name = L["TITLE_ZULAMAN"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_AMB10.mp3", 113},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_AMB11.mp3", 74},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_AMB12.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_AMB13.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_AMB14.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_AMB15.mp3", 113},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_BTL11.mp3", 136},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_BTL12.mp3", 117},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_BTL13.mp3", 40},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_BTL14.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_BTL15.mp3", 79},
				{"Sound\\Music\\ZoneMusic\\Zulaman\\ZA_zulaman_VCT10.mp3", 80},
			},
		},
	},

	-- The Burning Crusade
	i2bc = {
		{
			name = L["TITLE_MAIN_THEME"],
			files = {
				{"Sound\\Music\\GlueScreenMusic\\BC_main_theme.mp3", 226},
			},
		},
		{
			name = L["TITLE_LAMENTOTHIGHBORNE"],
			files = {
				{"Sound\\Music\\GlueScreenMusic\\BCCredits_Lament_of_the_Highborne.mp3", 171},
			},
		},
		{
			name = L["TITLE_AZUREMIST"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_DraeneiWalkUni05.mp3", 191},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_DraeneiWalkUni06.mp3", 110},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_DraeneiWalkUni07r.mp3", 110},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_DraeneiWalkUni08r.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni01.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni02.mp3", 74},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni03.mp3", 150},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni04.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_NagaWalkUni05.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_OwlkinWalkUni01.mp3", 49},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_OwlkinWalkUni02.mp3", 45},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni01.mp3", 206},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni02.mp3", 124},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni02r.mp3", 129},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni03.mp3", 188},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni03r.mp3", 188},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AV_DraeneiWalkUni04.mp3", 158},
			},
		},
		{
			name = L["TITLE_EXODAR"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_ExodarIntro01.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_ExodarWalkUni01.mp3", 109},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_ExodarWalkUni02.mp3", 107},
				{"Sound\\Music\\ZoneMusic\\Azuremyst\\AI_ExodarWalkUni03.mp3", 93},
			},
		},
		{
			name = L["TITLE_BLOODMIST"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_NagaIntro01.mp3", 31},
				{"Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_NagaIntro01r.mp3", 25},
				{"Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni01r.mp3", 126},
				{"Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni02.mp3", 129},
				{"Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni03.mp3", 114},
				{"Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni04.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\Bloodmyst\\BI_SatyrWalkUni05.mp3", 144},
			},
		},
		{
			name = L["TITLE_BLACKTEMPLE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ArrivalWalkHero01.mp3", 164},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ArrivalWalkUni02.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ArrivalWalkUni03.mp3", 74},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ArrivalWalkUni04.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkHero09.mp3", 74},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni01.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni02.mp3", 71},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni03.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni04.mp3", 91},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni05.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni06.mp3", 29},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni07.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni08.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni10.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_IllidariWalkUni11.mp3", 35},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_KaraborWalkUni01.mp3", 106},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_KaraborWalkUni02.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_KaraborWalkUni03.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_KaraborWalkUni04.mp3", 126},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_PreludeEvent01.mp3", 253},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkHero01.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni02.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni03.mp3", 79},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni04.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni05.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni06.mp3", 125},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni07.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_ReliquaryWalkUni08.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkHero01.mp3", 131},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni02.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni03.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni04.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni05.mp3", 56},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni06.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni07.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SanctuaryWalkUni08.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_StormWalkHero02.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_StormWalkUni01.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_StormWalkUni03.mp3", 32},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_StormWalkUni04.mp3", 48},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni01.mp3", 59},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni02.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni03.mp3", 41},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni04.mp3", 114},
				{"Sound\\Music\\ZoneMusic\\BlackTemple\\BT_SummitWalkUni05.mp3", 51},
			},
		},
		{
			name = L["TITLE_BLADESEDGE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_DryForestWalkUni01.mp3", 89},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_DryForestWalkUni02.mp3", 127},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_DryForestWalkUni03.mp3", 131},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni01.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni02.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni03.mp3", 158},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni04.mp3", 110},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_GeneralWalkUni05.mp3", 110},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_OgreWalkUni01.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\BladesEdge\\BL_OgreWalkUni02.mp3", 110},
			},
		},
		{
			name = L["TITLE_CAVERNSOFTIME"],
			files = {
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_BrazensFlightIntroUni.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk1Uni.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk2Uni.mp3", 120},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk3Uni.mp3", 169},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk4Uni.mp3", 130},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk5Uni.mp3", 151},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk6Uni.mp3", 161},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk7Uni.mp3", 178},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk8Uni.mp3", 140},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_CavernsWalk9Uni.mp3", 161},
			},
		},
		{
			name = L["TITLE_ESCDURNHOLDE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeCellarWalk1Uni.mp3", 104},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeCellarWalk2Uni.mp3", 59},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeCellarWalk3Uni.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk1Uni.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk2Uni.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk3Uni.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk4Uni.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk5Uni.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepExtWalk6Uni.mp3", 60},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepIntWalk1Uni.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepIntWalk2Uni.mp3", 123},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_DurnholdeKeepIntWalk3Uni.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_EscapeDurnIntroUni.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HillsbradExtWalk1Uni.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HillsbradExtWalk2Uni.mp3", 56},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_TarrenMillExtWalk1Uni.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_TarrenMillExtWalk2Uni.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_TarrenMillExtWalk3Uni.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_ThrallEscapeIntroUni.mp3", 45},
			},
		},
		{
			name = L["TITLE_HYJAL"],
			files = {
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalk7Uni.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalk8Uni.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalk9Uni.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni01.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni02.mp3", 48},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni03.mp3", 45},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni04.mp3", 85},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni05.mp3", 47},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni06.mp3", 46},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni10.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni11.mp3", 49},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_HyjalExtWalkUni12.mp3", 67},
			},
		},
		{
			name = L["TITLE_BLACKMORASS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassPortalIntro01.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni01.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni02.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni03.mp3", 114},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni04.mp3", 123},
				{"Sound\\Music\\ZoneMusic\\CavernsOfTime\\CT_MorassWalkUni05.mp3", 73},
			},
		},
		{
			name = L["TITLE_EVERSONG"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_BuildingWalkDay01.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_BuildingWalkDay02.mp3", 68},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_BuildingWalkNight01.mp3", 84},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_BuildingWalkNight02.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkDay01.mp3", 48},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkDay02.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkDay03.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkNight01.mp3", 51},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkNight02.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_RuinsWalkNight03.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_ScenicIntroNight01.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_ScortchedWalkDay01.mp3", 116},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_ScortchedWalkDay02.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_ScortchedWalkNight01.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_ScortchedWalkNight02.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonIntro01.mp3", 132},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkDay01.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkDay02.mp3", 79},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkDay03.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkNight01.mp3", 177},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkNight02.mp3", 71},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SilvermoonWalkNight03.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkDay01.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkDay02.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkDay03.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkNight01.mp3", 100},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkNight02.mp3", 100},
				{"Sound\\Music\\ZoneMusic\\Eversong\\ES_SunstriderWalkNight03.mp3", 86},
			},
		},
		{
			name = L["TITLE_GHOSTLANDS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_EversongDarkWalkUni01.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_EversongDarkWalkUni02.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_EversongDarkWalkUni03.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_EversongDarkWalkUni04.mp3", 60},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest1WalkDay01.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest1WalkDay02.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest1WalkNight01.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest2WalkDay01.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest2WalkNight01.mp3", 59},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest2WalkNight02.mp3", 60},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest3WalkDay01.mp3", 154},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest3WalkNight01.mp3", 51},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest3WalkNight02.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_Forest3WalkNight03.mp3", 44},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ScenicWalkUni01.mp3", 89},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ScenicWalkUni02.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ScenicWalkUni03.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ShalandisWalkUni01.mp3", 131},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ShalandisWalkUni02.mp3", 104},
				{"Sound\\Music\\ZoneMusic\\Ghostlands\\GL_ShalandisWalkUni03.mp3", 67},
			},
		},
		{
			name = L["TITLE_HELLFIRE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\BL_HE_OgreWalkUni01.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\BL_HE_OgreWalkUni02.mp3", 110},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_ArmouryIntroUni01.mp3", 14},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_CitadelDemonWalkUni01.mp3", 53},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_CitadelDemonWalkUni02.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_CitadelIntroUni01.mp3", 19},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni01.mp3", 130},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni02.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni03.mp3", 59},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni04.mp3", 96},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_GeneralWalkUni05.mp3", 126},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_PathOfGloryIntroUni01.mp3", 18},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_RampartsWalkUni01.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_RampartsWalkUni02.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_StairsIntroUni01.mp3", 18},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_WistfulIntroUni01.mp3", 25},
				{"Sound\\Music\\ZoneMusic\\HellfirePeninsula\\HE_WistfulIntroUni02.mp3", 17},
			},
		},
		{
			name = L["TITLE_KARAZHAN"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_BackstageWalkUni01.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_BackstageWalkUni02.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerIntroUni01.mp3", 117},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerWalkUni01.mp3", 113},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerWalkUni02.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerWalkUni03.mp3", 124},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_FoyerWalkUni04.mp3", 31},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni01.mp3", 130},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni02.mp3", 123},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni03.mp3", 119},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni04.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni05.mp3", 125},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni06.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_GeneralWalkUni07.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_LibraryWalkUni01.mp3", 128},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_LibraryWalkUni02.mp3", 147},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_LibraryWalkUni03.mp3", 126},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_LibraryWalkUni04.mp3", 124},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_MalchezarWalkUni01.mp3", 124},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_MalchezarWalkUni02.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_MalchezarWalkUni03.mp3", 114},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_OperaHarpsiWalkUni01.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_OperaOrganWalkUni01.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_StableIntroUni01.mp3", 53},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_StableWalkUni01.mp3", 96},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_StableWalkUni02.mp3", 111},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_StableWalkUni03.mp3", 114},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_TowerWalkUni01.mp3", 94},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_TowerWalkUni02.mp3", 115},
				{"Sound\\Music\\ZoneMusic\\Karazhan\\KA_TowerWalkUni03.mp3", 127},
			},
		},
		{
			name = L["TITLE_NAGRAND"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Nagrand\\NA_DiamondIntroUni01.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkDay01.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkDay02.mp3", 100},
				{"Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkDay03.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkNight01.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkNight02.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\Nagrand\\NA_GeneralWalkNight03.mp3", 166},
			},
		},
		{
			name = L["TITLE_NETHERSTORM"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni01.mp3", 150},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni02.mp3", 175},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni03.mp3", 178},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni04.mp3", 181},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni05.mp3", 184},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni06.mp3", 192},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni07.mp3", 193},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni08.mp3", 169},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni09.mp3", 199},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_GeneralWalkUni10.mp3", 223},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_MushroomIntroUni01.mp3", 39},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_MushroomIntroUni02.mp3", 33},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_MushroomIntroUni03.mp3", 37},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_NetherplantIntroUni01.mp3", 44},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_NetherplantIntroUni02.mp3", 51},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_NetherplantIntroUni03.mp3", 47},
				{"Sound\\Music\\ZoneMusic\\Netherstorm\\NS_NetherplantIntroUni04.mp3", 45},
			},
		},
		{
			name = L["TITLE_SUNWELL"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_AssemblyChamberWalkUni01.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_AssemblyChamberWalkUni02.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_FelEnergyWalkUni01.mp3", 126},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleDarkWalkUni01.mp3", 139},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleDarkWalkUni02.mp3", 137},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleDarkWalkUni03.mp3", 126},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleLightWalkUni01.mp3", 115},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleLightWalkUni02.mp3", 119},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleLightWalkUni03.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleMedWalkUni01.mp3", 117},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleMedWalkUni02.mp3", 126},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_IsleMedWalkUni03.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersArrivalWalkUni01.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersAsylumWalkUni01.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersAsylumWalkUni02.mp3", 95},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersAsylumWalkUni03.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni01.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni02.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni03.mp3", 89},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni04.mp3", 91},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_MagistersTerraceWalkUni05.mp3", 123},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellArrivalWalkUni01.mp3", 138},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni01.mp3", 85},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni02.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni03.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni04.mp3", 91},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni05.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_PlateauSunwellWalkUni06.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_QuelDanasWalkUni01.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_QuelDanasWalkUni02.mp3", 84},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_SanctumWalkUni01.mp3", 85},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_ShorelAranWalkUni01.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_SunwellBombingRunUni01.mp3", 259},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_SunwellFlybyUni01.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_TheWellWalkUni01.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_TheWellWalkUni02.mp3", 95},
				{"Sound\\Music\\ZoneMusic\\Sunwell\\SW_TheWellWalkUni03.mp3", 95},
			},
		},
		{
			name = L["TITLE_SHADOWMOON"],
			files = {
				{"Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni01.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni02.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni03.mp3", 106},
				{"Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni04.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni05.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\ShadowmoonValley\\SV_GeneralWalkUni06.mp3", 67},
			},
		},
		{
			name = L["TITLE_TEMPESTKEEP"],
			files = {
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_11.mp3", 46},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_12.mp3", 96},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_13.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_14.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_16.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_17.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_18.mp3", 85},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_19.mp3", 48},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_20.mp3", 47},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_22.mp3", 34},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_AMB_23.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_BTL10.mp3", 59},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_BTL11.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_BTL13.mp3", 36},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_STG14.mp3", 11},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_STG15.mp3", 11},
				{"Sound\\Music\\ZoneMusic\\TempestKeep\\tk_TempestKeep_STG16.mp3", 11},
			},
		},
		{
			name = L["TITLE_ZANGARMASH"],
			files = {
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_CoilfangWalkUni01.mp3", 133},
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_CoilfangWalkUni02.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_CoilfangWalkUni03.mp3", 109},
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni01.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni02.mp3", 120},
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni03.mp3", 59},
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni04.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni05.mp3", 71},
				{"Sound\\Music\\ZoneMusic\\ZangarMarsh\\ZA_GeneralWalkUni06.mp3", 89},
			},
		},
		{
			name = L["TITLE_TEROKKAR"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_AuchindounWalkUni01.mp3", 120},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_AuchindounWalkUni02.mp3", 150},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_AuchindounWalkUni03.mp3", 120},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_BoneWalkUni01.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_BoneWalkUni02.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_BoneWalkUni03.mp3", 56},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_BoneWalkUni04.mp3", 189},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ForestWalkUni01.mp3", 150},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ForestWalkUni02.mp3", 190},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ForestWalkUni03.mp3", 187},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni01.mp3", 137},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni02.mp3", 100},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni03.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni04.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni05.mp3", 117},
				{"Sound\\Music\\ZoneMusic\\Terokkar\\TF_ShattrathWalkUni06.mp3", 137},
			},
		},
	},
	
	-- Wrath of the Lich King
	i3wotlk = {
		{
			name = L["TITLE_MAIN_THEME"],
			files = {
				{"Sound\\Music\\GlueScreenMusic\\WotLK_main_title.mp3", 544},
			},
		},
		{
			name = L["TITLE_STORMPEAKS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkA_Day01.mp3", 86},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkA_Night01.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkADark_Uni01.mp3", 120},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkB_Day02.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkB_Night02.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkB_Uni02.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkC_Day03.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkC_Night03.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkC_Uni03.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkD_Day04.mp3", 55},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkD_Night04.mp3", 52},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkD_Uni04.mp3", 54},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkE_Day05.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkE_Night05.mp3", 74},
				{"Sound\\Music\\ZoneMusic\\StormPeaks\\SP_GeneralWalkE_Uni05.mp3", 83},
			},
		},
		{
			name = L["TITLE_DALARAN"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_GeneralWalkUni01.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_GeneralWalkUni02.mp3", 42},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_GeneralWalkUni03.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_GeneralWalkUni04.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_IntroUni01.mp3", 68},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_SewerWalkUni01.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_SewerWalkUni02.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_SewerWalkUni03.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_SewerWalkUni04.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Dalaran\\DC_SpireWalkUni01.mp3", 91},
			},
		},
		{
			name = L["TITLE_ICECROWNGLACIER"],
			files = {
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralIntro_01.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralIntro_02.mp3", 56},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralIntro_03.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Day01.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Day02.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Day03.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Day04.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night01.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night02.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night03.mp3", 94},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night04.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\IcecrownGlacier\\IC_GeneralWalk_Night05.mp3", 102},
			},
		},
		{
			name = L["TITLE_CRYSTALSONGFOREST"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni01.mp3", 113},
				{"Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni02.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni03.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni04.mp3", 113},
				{"Sound\\Music\\ZoneMusic\\Crystalsong\\CS_CrystalsongWalkUni05.mp3", 107},
			},
		},
		{
			name = L["TITLE_DRAGONBLIGHT"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralIntro_01.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralIntro_02.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralIntro_03.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralIntro_04.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day01.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day02.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day03.mp3", 120},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day04.mp3", 76},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day05.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day06.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day07.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Day08.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night01.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night02.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night03.mp3", 119},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night04.mp3", 76},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night05.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night06.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night07.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_GeneralWalk_Night08.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_Indule_Day01.mp3", 129},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_Indule_Day02.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleDay01.mp3", 129},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleDay02.mp3", 60},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleDay03.mp3", 39},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleNight01.mp3", 132},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleNight02.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\Dragonblight\\DB_Tusk_InduleNight03.mp3", 39},
			},
		},
		{
			name = L["TITLE_HOWLINGFJORD"],
			files = {
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni01.mp3", 30},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni02.mp3", 47},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni03.mp3", 52},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni04.mp3", 26},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni05.mp3", 22},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni06.mp3", 41},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_DistWalkUni07.mp3", 23},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day01.mp3", 110},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day02.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day03.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day04.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day05.mp3", 124},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day06.mp3", 114},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Day07.mp3", 149},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Night01.mp3", 106},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Night02.mp3", 91},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Night03.mp3", 84},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_GeneralWalk_Night04.mp3", 157},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_Tusk_KamaguaDay01.mp3", 95},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_Tusk_KamaguaDay02.mp3", 54},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_Tusk_KamaguaNight01.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\HowlingFjord\\HF_Tusk_KamaguaNight02.mp3", 80},
			},
		},
		{
			name = L["TITLE_SCHOLAZARBASIN"],
			files = {
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_CrystalsWalkUni01.mp3", 130},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_CrystalsWalkUni02.mp3", 143},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_FireWalkUni01.mp3", 107},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_FireWalkUni02.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_FireWalkUni03.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_FireWalkUni04.mp3", 107},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_LifebloodCaveWalkUni01.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_LifebloodCaveWalkUni02.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_LifebloodCaveWalkUni03.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_MakersTerraceWalkUni01.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_MakersTerraceWalkUni02.mp3", 94},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_PathofLifeWardenWalkUni01.mp3", 136},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_PathofLifeWardenWalkUni02.mp3", 161},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay01.mp3", 175},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay02.mp3", 114},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay03.mp3", 105},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay04.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay05.mp3", 123},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkDay06.mp3", 142},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight01.mp3", 115},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight02.mp3", 137},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight03.mp3", 132},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight04.mp3", 91},
				{"Sound\\Music\\ZoneMusic\\SholazarBasin\\SB_SholazarWalkNight05.mp3", 99},
			},
		},
		{
			name = L["TITLE_ESCAPEFROMARTHAS"], -- to be removed when selection will be available
			files = {
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_HallsofChase.mp3", 106},
			},
		},
		{
			name = L["TITLE_LADYORLICH"], -- to be removed when selection will be available
			files = {
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LadyortheLich.mp3", 75},
			},
		},
		{
			name = L["TITLE_CALL_OT_CRUSADE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle01UniWalk.mp3", 145},
				{"Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle02UniWalk.mp3", 185},
				{"Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle03UniWalk.mp3", 162},
				{"Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle04UniWalk.mp3", 160},
				{"Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle05UniWalk.mp3", 193},
				{"Sound\\Music\\ZoneMusic\\ArgentColiseum\\CR_TourneyBattle06UniWalk.mp3", 185},
			},
		},
		{
			name = L["TITLE_ARGENT_TOURNAMENT"],
			files = {
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_HeraldEvent.mp3", 13},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_JoustEvent.mp3", 123},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney01NightWalk.mp3", 156},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney02DayWalk.mp3", 157},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney03NightWalkUniWalk.mp3", 162},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney05NightWalk.mp3", 164},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney06DayWalk.mp3", 144},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney07NightWalk.mp3", 185},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney08NightWalk.mp3", 189},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney09DayWalk.mp3", 151},
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_Tourney10DayWalk.mp3", 151},
			},
		},
		{
			name = L["TITLE_AZJOLNERUB"],
			files = {
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_01.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_02.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_03.mp3", 111},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_04.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_05.mp3", 76},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_06.mp3", 107},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_07.mp3", 107},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralIntro_08.mp3", 104},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_01.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_02.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_03.mp3", 110},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_04.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_05.mp3", 76},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_06.mp3", 104},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_07.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_08.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_09.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_10.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_11.mp3", 111},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_12.mp3", 110},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_13.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_14.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_15.mp3", 76},
				{"Sound\\Music\\ZoneMusic\\AzjolNerub\\AN_GeneralWalk_16.mp3", 77},
			},
		},
		{
			name = L["TITLE_BOREANTUNDRA"],
			files = {
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_ColdarraWalkUni01.mp3", 64},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_ColdarraWalkUni02.mp3", 63},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_ColdarraWalkUni03.mp3", 124},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day01.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day02.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day03.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day04.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day05.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day06.mp3", 115},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day07.mp3", 86},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Day08.mp3", 71},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night01.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night02.mp3", 115},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night03.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night04.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night05.mp3", 77},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night06.mp3", 100},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night07.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeneralWalk_Night08.mp3", 111},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeyserField_General01.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeyserField_General02.mp3", 48},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_GeyserField_General03.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Day01.mp3", 151},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Day02.mp3", 186},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Day03.mp3", 161},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Intro01.mp3", 153},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Intro02.mp3", 177},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Night01.mp3", 159},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Night02.mp3", 79},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Night03.mp3", 76},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Riplash_Night04.mp3", 95},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Tusk_KaskalaDay01.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Tusk_KaskalaDay02.mp3", 79},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Tusk_KaskalaNight01.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\BoreanTundra\\BO_Tusk_KaskalaNight02.mp3", 59},
			},
		},
		{
			name = L["TITLE_EBONHOLD"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni01.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni02.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni03.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni04.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni05.mp3", 117},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni06.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_AssaultUni07.mp3", 96},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_GeneralWalkUni01.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_GeneralWalkUni02.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\Ebon Hold\\EH_GeneralWalkUni03.mp3", 82},
			},
		},
		{
			name = L["TITLE_GRIZZLYHILLS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Day01.mp3", 94},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Day02.mp3", 144},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Day03.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Day04.mp3", 95},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Night01.mp3", 130},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_A_Night02.mp3", 141},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_B_Day01.mp3", 107},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_B_Day02.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_B_Night01.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_GeneralWalk_B_Night02.mp3", 116},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_Intro1Uni01.mp3", 284},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_Intro2Uni01.mp3", 149},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay01.mp3", 141},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay02.mp3", 138},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay03.mp3", 238},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay04.mp3", 111},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay05.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay06.mp3", 155},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay07.mp3", 155},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay08.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkDay09.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight01.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight02.mp3", 111},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight03.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight04.mp3", 155},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight05.mp3", 149},
				{"Sound\\Music\\ZoneMusic\\GrizzlyHills\\GH_WalkNight06.mp3", 133},
			},
		},
		{
			name = L["TITLE_ICC1"],
			files = {
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_BronzeJam.mp3", 116},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_CrimsonHall1.mp3", 121},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_CrimsonHall2.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_CrimsonHall3.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_CrimsonHall4.mp3", 130},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ForgeofSouls1.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ForgeofSouls2.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ForgeofSouls3.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ForgeofSouls4.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Frostmourne1.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Frostmourne2.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Frostmourne3.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Gunships.mp3", 73},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_GunStrings.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_HallsofChase.mp3", 106},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress.mp3", 133},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_HallsofReflection.mp3", 157},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress1.mp3", 153},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress2.mp3", 105},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress3.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_IceFortress4.mp3", 106},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LadyortheLich.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LetHimPass.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer1.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer2.mp3", 40},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer3.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer4.mp3", 102},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer5.mp3", 58},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_LightsHammer6.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls1.mp3", 60},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls2.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls3.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls4.mp3", 129},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_ReflectedHalls5.mp3", 59},
			},
		},
		{
			name = L["TITLE_ICC2"],
			files = {
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_01.mp3", 24},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_02.mp3", 41},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_03.mp3", 20},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_04.mp3", 15},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_05.mp3", 10},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_06.mp3", 20},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_FrozenThrone_07.mp3", 283},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunK_01.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunK_02.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunK_03.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunL_01.mp3", 23},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_RunL_02.mp3", 42},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Sindragosa.mp3", 68},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_SindraStrings.mp3", 66},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_01.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_02.mp3", 16},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_03.mp3", 25},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_04.mp3", 26},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_05.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_StingH_06.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit1.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit2.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit3.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit4.mp3", 103},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_Summit5.mp3", 103},
			},
		},
		{
			name = L["TITLE_ICC3"],
			files = {
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_01.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_02.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_03.mp3", 91},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_04.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_05.mp3", 100},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkA_06.mp3", 52},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkB_01.mp3", 52},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_01.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_02.mp3", 42},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_03.mp3", 42},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_04.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_05.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkD_06.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_01.mp3", 29},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_02.mp3", 29},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_03.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_04.mp3", 29},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkE_05.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_01.mp3", 49},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_02.mp3", 47},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_03.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_04.mp3", 48},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_05.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_06.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_07.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkF_08.mp3", 42},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_01.mp3", 24},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_02.mp3", 24},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_03.mp3", 24},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_04.mp3", 23},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_05.mp3", 25},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkG_06.mp3", 24},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_01.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_02.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_03.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_04.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_05.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkJ_06.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkM_01.mp3", 156},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkZ_01.mp3", 46},
				{"Sound\\Music\\ZoneMusic\\IcecrownRaid\\IR_WalkZ_02.mp3", 46},
			},
		},
		{
			name = L["TITLE_WINTERGRASP"],
			files = {
				{"Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_Contested_01.mp3", 40},
				{"Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_Contested_02.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_Contested_03.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_01.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_02.mp3", 62},
				{"Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_03.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_04.mp3", 43},
				{"Sound\\Music\\ZoneMusic\\LakeWintergrasp\\WG_GeneralWalk_05.mp3", 57},
			},
		},
		{
			name = L["TITLE_NEXUS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni01.mp3", 76},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni02.mp3", 68},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni03.mp3", 102},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni04.mp3", 107},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusActionWalkUni05.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusHailWalkUni01.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusHailWalkUni02.mp3", 65},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusPulseWalkUni01.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusPulseWalkUni02.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusQuietWalkUni01.mp3", 114},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusQuietWalkUni02.mp3", 111},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusQuietWalkUni03.mp3", 56},
				{"Sound\\Music\\ZoneMusic\\Nexus\\NZ_NexusQuietWalkUni04.mp3", 71},
			},
		},
		{
			name = L["TITLE_IRONDWARVES"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkA_Day01.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkA_Night01.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkADark_Uni01.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkB_Day02.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkB_Night02.mp3", 95},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkB_Uni02.mp3", 164},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkC_Day03.mp3", 42},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkC_Night03.mp3", 42},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkC_Uni03.mp3", 42},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkCDark_Uni04.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkD_Day04.mp3", 45},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkD_Night04.mp3", 45},
				{"Sound\\Music\\ZoneMusic\\Northrend\\IronDwarf\\NR_Dwarf_GeneralWalkDDark_Uni05.mp3", 69},
			},
		},
		{
			name = L["TITLE_NR_TRANSPORT"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Northrend\\NorthrendTransport\\NR_NorthrendTransportGeneralDay.mp3", 152},
				{"Sound\\Music\\ZoneMusic\\Northrend\\NorthrendTransport\\NR_NorthrendTransportGeneralNight.mp3", 92},
			},
		},
		{
			name = L["TITLE_NR_ORCS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_General_Intro01.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Day01.mp3", 23},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Day02.mp3", 23},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Day03.mp3", 23},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Day04.mp3", 45},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Night01.mp3", 78},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Night02.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Orc\\NR_Orc_GeneralWalk_Night03.mp3", 79},
			},
		},
		{
			name = L["TITLE_NR_TAUNKA"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkA_Day01.mp3", 138},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkA_Night01.mp3", 141},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkA_Uni01.mp3", 140},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkB_Day02.mp3", 127},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkB_Night02.mp3", 127},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkC_Day03.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkC_Night03.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkD_Day04.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkD_Night04.mp3", 69},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkD_Uni02.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Taunka\\NR_Taunka_GeneralWalkE_Uni03.mp3", 73},
			},
		},
		{
			name = L["TITLE_NR_TROLLS"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Northrend\\Troll\\NR_Troll_General01.mp3", 46},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Troll\\NR_Troll_General02.mp3", 55},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Troll\\NR_Troll_General03.mp3", 38},
				{"Sound\\Music\\ZoneMusic\\Northrend\\Troll\\NR_Troll_General04.mp3", 44},
			},
		},
		{
			name = L["TITLE_ULDUAR1"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningBattleWalk.mp3", 52},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningGeneralWalk01.mp3", 33},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningGeneralWalk02.mp3", 40},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningGeneralWalk03.mp3", 35},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_LightningIntro.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneBattleWalk.mp3", 52},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneGeneralWalk01.mp3", 40},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneGeneralWalk02.mp3", 40},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneGeneralWalk03.mp3", 35},
				{"Sound\\Music\\ZoneMusic\\Ulduar\\UL_StoneIntro.mp3", 85},
			},
		},
		{
			name = L["TITLE_ULDUAR2"],
			files = {
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction01.mp3", 31},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction02.mp3", 137},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction03.mp3", 136},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction04.mp3", 53},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction05.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction06.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction07.mp3", 40},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction08.mp3", 40},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction09.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction10.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction11.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction12.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction13.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction14.mp3", 36},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction15.mp3", 36},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtAction16.mp3", 36},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro01.mp3", 12},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro02.mp3", 14},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro03.mp3", 14},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro04.mp3", 17},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro05.mp3", 13},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro06.mp3", 13},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro07.mp3", 12},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro08.mp3", 26},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtIntro09.mp3", 25},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk01.mp3", 36},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk02.mp3", 33},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk03.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk04.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk05.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk06.mp3", 26},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk07.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk08.mp3", 53},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk09.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk10.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidExt\\UR_UlduarRaidExtWalk11.mp3", 28},
			},
		},
		{
			name = L["TITLE_ULDUAR3"],
			files = {
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonBattle01Walk.mp3", 162},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonBattle02Walk.mp3", 131},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonHeroIntro.mp3", 148},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonPlanetaryHallWalk.mp3", 148},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_AlgalonVoicesWalk.mp3", 148},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_FourSigilsHallWalk.mp3", 123},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_FourSigilsHeroIntro.mp3", 218},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_HallsInstrumentalWalk.mp3", 115},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_HallsofIronHeroEvent.mp3", 196},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_HallsPastWalk.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironBWalk.mp3", 172},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironCWalk.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironDWalk.mp3", 96},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironEWalk.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironFWalk.mp3", 179},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironGhostsWalk.mp3", 179},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_MimironHeroIntro.mp3", 172},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_SigilGhostsWalk.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanGhostsWalk.mp3", 113},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanHallsHeroWalk.mp3", 113},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanMechWalk.mp3", 127},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanOrchestraIntro.mp3", 102},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanSigilsWalk.mp3", 57},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_TitanYoggWalk.mp3", 94},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_UlduarToneWalk.mp3", 106},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_YoggLiteWalk.mp3", 105},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_YoggSaronHeroIntro.mp3", 105},
				{"Sound\\Music\\ZoneMusic\\UlduarRaidInt\\UR_YoggWoodsWalk.mp3", 82},
			},
		},
		{
			name = L["TITLE_UTGARDEKEEP"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni01.mp3", 56},
				{"Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni02.mp3", 52},
				{"Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni03.mp3", 54},
				{"Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni04.mp3", 26},
				{"Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_GeneralWalkUni05.mp3", 30},
				{"Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_QuietWalkUni01.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\Utgarde Keep\\UK_QuietWalkUni02.mp3", 107},
			},
		},
		{
			name = L["TITLE_VIOLETHOLD"],
			files = {
				{"Sound\\Music\\ZoneMusic\\VioletHold\\VH_GeneralWalkUni01.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\VioletHold\\VH_GeneralWalkUni02.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\VioletHold\\VH_GeneralWalkUni03.mp3", 69},
			},
		},
		{
			name = L["TITLE_ZULDRAK"],
			files = {
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_01.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_02.mp3", 98},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_03.mp3", 128},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_04.mp3", 126},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_05.mp3", 129},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralIntro_06.mp3", 125},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Day01.mp3", 89},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Day02.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Day03.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Day04.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Night01.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Night02.mp3", 90},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Night03.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_GeneralWalk_Night04.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_HarKoa_Intro01.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_HarKoa_Intro02.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_MamToth_Intro01.mp3", 30},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_MamToth_Intro02.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_QuetzLun_Intro01.mp3", 32},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_QuetzLun_Intro02.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_Rhunok_Intro01.mp3", 30},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_Rhunok_Intro02.mp3", 27},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_Sseratus_Intro01.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\ZulDrak\\ZD_Sseratus_Intro02.mp3", 27},
			},
		},
		{
			name = L["TITLE_CULLINGSTRAT"],
			files = {
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastAlleyEnd.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastAlleyIntro.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastBattleWalk01.mp3", 94},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastBattleWalk02.mp3", 36},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastBattleWalk03.mp3", 36},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastEndStinger.mp3", 28},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastIndoorsIntro.mp3", 99},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastIntro.mp3", 32},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastMalGanis.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsIntro.mp3", 37},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsWalkANight.mp3", 32},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsWalkAUni.mp3", 32},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsWalkBNight.mp3", 36},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastOutdoorsWalkBUni.mp3", 37},
				{"Sound\\Music\\ZoneMusic\\StratholmePast\\CT_StratholmePastWalkUni.mp3", 102},
			},
		},
	},
	
	-- Cataclysm
	i4cata = {
		{
			name = L["TITLE_MAIN_THEME"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Shattering_UU01.mp3", 725},
			},
		},
		{
			name = L["TITLE_DRUIDS_OT_FLAME"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameA_Hero_UU01.mp3", 91},
				{"Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameA_UU01.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameA_UU02.mp3", 89},
				{"Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameA_UU03.mp3", 44},
				{"Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameB_Hero_UU01.mp3", 88},
				{"Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameB_UU01.mp3", 87},
				{"Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameB_UU02.mp3", 86},
				{"Sound\\Music\\cataclysm\\MUS_42_DruidsoftheFlameB_UU03.mp3", 86},
			},
		},
		{
			name = L["TITLE_ELEMENTALAIR"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_AirA_UU01.mp3", 47},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_AirA_UU02.mp3", 38},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_AirB_UU01.mp3", 44},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_AirB_UU02.mp3", 54},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_AirC_UU01.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_AirD_UU01.mp3", 34},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_AirD_UU02.mp3", 34},
			},
		},
		{
			name = L["TITLE_ELEMENTALEARTH"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_EarthA_UU01.mp3", 58},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_EarthA_UU02.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_EarthA_UU03.mp3", 65},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_EarthA_UU04.mp3", 58},
			},
		},
		{
			name = L["TITLE_ELEMENTALWATER"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterA_UD01.mp3", 67},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterA_UN01.mp3", 67},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterB_UD01.mp3", 34},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterB_UN01.mp3", 34},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterC_UD01.mp3", 63},
				{"Sound\\Music\\cataclysm\\MUS_42_Elemental_WaterC_UN01.mp3", 67},
			},
		},
		{
			name = L["TITLE_ELEMENTALBONDS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_42_ElementalBondsA_UU01.mp3", 54},
				{"Sound\\Music\\cataclysm\\MUS_42_ElementalBondsA_UU02.mp3", 54},
				{"Sound\\Music\\cataclysm\\MUS_42_ElementalBondsA_UU03.mp3", 54},
				{"Sound\\Music\\cataclysm\\MUS_42_ElementalBondsB_UU01.mp3", 29},
				{"Sound\\Music\\cataclysm\\MUS_42_ElementalBondsB_UU02.mp3", 26},
			},
		},
		{
			name = L["TITLE_THRALLAGGRA"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_42_ThrallAggraA_ED01.mp3", 72},
				{"Sound\\Music\\cataclysm\\MUS_42_ThrallAggraA_EN01.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_42_ThrallAggraB_ED01.mp3", 53},
				{"Sound\\Music\\cataclysm\\MUS_42_ThrallAggraB_EN01.mp3", 44},
				{"Sound\\Music\\cataclysm\\MUS_42_ThrallAggraC_EU01.mp3", 57},
				{"Sound\\Music\\cataclysm\\MUS_42_ThrallAggraC_EU02.mp3", 57},
				{"Sound\\Music\\cataclysm\\MUS_43_ThrallEarthWarder_UU01.mp3", 62},
				{"Sound\\Music\\cataclysm\\MUS_43_ThrallEarthWarder_UU02.mp3", 42},
				{"Sound\\Music\\cataclysm\\MUS_43_ThrallEarthWarder_UU03.mp3", 47},
				{"Sound\\Music\\cataclysm\\MUS_43_ThrallEarthWarder_UU04.mp3", 29},
			},
		},
		{
			name = L["TITLE_NIGHTELVES"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_NightElves_GU01.mp3", 160},
				{"Sound\\Music\\cataclysm\\MUS_NightElves_GU02.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_NightElves_GU03.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_NightElves_GU04.mp3", 81},
				{"Sound\\Music\\cataclysm\\MUS_NightElves_GU05.mp3", 81},
				{"Sound\\Music\\cataclysm\\MUS_SirenQuest_EU01.mp3", 42},
			},
		},
		{
			name = L["TITLE_AFTERMATH"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Aftermath_UU01.mp3", 125},
				{"Sound\\Music\\cataclysm\\MUS_Aftermath_UU02.mp3", 125},
				{"Sound\\Music\\cataclysm\\MUS_Aftermath_UU03.mp3", 58},
				{"Sound\\Music\\cataclysm\\MUS_Aftermath_UU04.mp3", 82},
			},
		},
		{
			name = L["TITLE_DRAGONSOUL"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Hero_UU01.mp3", 32},
				{"Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Moment_01.mp3", 31},
				{"Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Moment_02.mp3", 32},
				{"Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Moment_03.mp3", 32},
				{"Sound\\Music\\cataclysm\\MUS_43_DragonSoulA_Moment_04.mp3", 60},
				{"Sound\\Music\\cataclysm\\MUS_43_DragonSoulB_UU01.mp3", 47},
				{"Sound\\Music\\cataclysm\\MUS_43_DragonSoulB_UU02.mp3", 49},
				{"Sound\\Music\\cataclysm\\MUS_43_DragonSoulB_UU03.mp3", 51},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_Hero_UU01.mp3", 189},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_Stinger_01.mp3", 15},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_Stinger_02.mp3", 14},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_Stinger_03.mp3", 5},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_Stinger_04.mp3", 10},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_UU01.mp3", 31},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_UU02.mp3", 18},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_UU03.mp3", 42},
				{"Sound\\Music\\cataclysm\\MUS_43_Gunships_UU04.mp3", 45},
			},
		},
		{
			name = L["TITLE_DEATHWING"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU01.mp3", 35},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU02.mp3", 34},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU03.mp3", 32},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU04.mp3", 59},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU05.mp3", 58},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU06.mp3", 31},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingCorruption_UU07.mp3", 70},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingOutro_UU01.mp3", 58},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingsFall_Hero_UU01.mp3", 147},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingsFall_UU01.mp3", 111},
				{"Sound\\Music\\cataclysm\\MUS_43_DeathwingsFall_UU02.mp3", 104},
			},
		},
		{
			name = L["TITLE_FANGS_OT_FATHER"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherA_Hero_UU01.mp3", 121},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherA_UU01.mp3", 97},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherA_UU02.mp3", 99},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherA_UU03.mp3", 92},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherB_UU01.mp3", 77},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherB_UU02.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherB_UU03.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherC_Hero_UU01.mp3", 151},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherC_UU02.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherC_UU03.mp3", 74},
				{"Sound\\Music\\cataclysm\\MUS_43_FangsOfTheFatherC_UU04.mp3", 63},
			},
		},
		{
			name = L["TITLE_WARSHIPS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_Warships_Hero_01.mp3", 90},
				{"Sound\\Music\\cataclysm\\MUS_43_Warships_UU01.mp3", 66},
				{"Sound\\Music\\cataclysm\\MUS_43_Warships_UU02.mp3", 29},
			},
		},
		{
			name = L["TITLE_NIGHTWALK"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_NightWalk_UU01.mp3", 59},
				{"Sound\\Music\\cataclysm\\MUS_43_NightWalk_UU02.mp3", 60},
				{"Sound\\Music\\cataclysm\\MUS_43_NightWalk_UU03.mp3", 59},
				{"Sound\\Music\\cataclysm\\MUS_43_NightWalk_UU04.mp3", 59},
			},
		},
		{
			name = L["TITLE_TWILIGHTHIGHLANDS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_TwilightsHammer_UU01.mp3", 113},
				{"Sound\\Music\\cataclysm\\MUS_43_TwilightsHammer_UU02.mp3", 55},
				{"Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU01.mp3", 68},
				{"Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU02.mp3", 67},
				{"Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU03.mp3", 67},
				{"Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU04.mp3", 78},
				{"Sound\\Music\\cataclysm\\MUS_TwilightHighlands_GU05.mp3", 67},
				{"Sound\\Music\\cataclysm\\MUS_TwilightsHammer_UU01.mp3", 92},
				{"Sound\\Music\\cataclysm\\MUS_TwilightsHammer_UU02.mp3", 48},
				{"Sound\\Music\\cataclysm\\MUS_TwilightsHammer_UU03.mp3", 48},
				{"Sound\\Music\\cataclysm\\MUS_TwilightVale_GU01.mp3", 110},
				{"Sound\\Music\\cataclysm\\MUS_TwilightVale_GU02.mp3", 81},
				{"Sound\\Music\\cataclysm\\MUS_TwilightVale_GU03.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_TwilightVale_GU04.mp3", 62},
				{"Sound\\Music\\cataclysm\\MUS_TwilightVale_GU05.mp3", 46},
			},
		},
		{
			name = L["TITLE_WELLOFETERNITY"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_Hero_UU01.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU01.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU02.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU03.mp3", 92},
				{"Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU04.mp3", 102},
				{"Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU05.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_43_WellOfEternity_UU06.mp3", 85},
			},
		},
		{
			name = L["TITLE_ZINAZSHARI"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_Hero_UU01.mp3", 177},
				{"Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU01.mp3", 92},
				{"Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU02.mp3", 71},
				{"Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU03.mp3", 51},
				{"Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU04.mp3", 107},
				{"Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU05.mp3", 46},
				{"Sound\\Music\\cataclysm\\MUS_43_ZinAzshari_UU06.mp3", 113},
			},
		},
		{
			name = L["TITLE_RAGE_OT_FIRELANDS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsA_Hero_UU01.mp3", 103},
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsA_UU01.mp3", 91},
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsA_UU02.mp3", 76},
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsA_UU03.mp3", 58},
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsB_Hero_UU01.mp3", 108},
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsB_UU01.mp3", 63},
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsB_UU02.mp3", 53},
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsB_UU03.mp3", 65},
				{"Sound\\Music\\cataclysm\\MUS_42_FirelandsB_UU04.mp3", 52},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_Hero_UU01.mp3", 141},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_Moment_UU01.mp3", 13},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_Moment_UU02.mp3", 15},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_Moment_UU03.mp3", 22},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_Moment_UU04.mp3", 16},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_UU01.mp3", 52},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_UU03.mp3", 35},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_UU04.mp3", 49},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_UU05.mp3", 53},
				{"Sound\\Music\\cataclysm\\MUS_AdventureA_UU06.mp3", 43},
				{"Sound\\Music\\cataclysm\\MUS_Firelands_GU01.mp3", 148},
			},
		},
		{
			name = L["TITLE_GILNEAS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_AllianceHero_UU01.mp3", 195},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UU01.mp3", 79},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UU02.mp3", 71},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UU03.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UU04.mp3", 111},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UU05.mp3", 73},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UU06.mp3", 48},
				{"Sound\\Music\\cataclysm\\MUS_GilneasEvent_E01.mp3", 32},
				{"Sound\\Music\\cataclysm\\MUS_GilneasEvent_E02.mp3", 24},
				{"Sound\\Music\\cataclysm\\MUS_GilneasEvent_E03.mp3", 28},
				{"Sound\\Music\\cataclysm\\MUS_GilneasEvent_E04.mp3", 108},
			},
		},
		{
			name = L["TITLE_BARROWDENS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_BarrowDens_GU01.mp3", 64},
				{"Sound\\Music\\cataclysm\\MUS_BarrowDens_GU02.mp3", 50},
				{"Sound\\Music\\cataclysm\\MUS_BarrowDens_GU03.mp3", 66},
				{"Sound\\Music\\cataclysm\\MUS_BarrowDens_GU04.mp3", 51},
				{"Sound\\Music\\cataclysm\\MUS_BarrowDens_GU05.mp3", 58},
			},
		},
		{
			name = L["TITLE_CHOGALL"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_ChoGall_E01.mp3", 169},
				{"Sound\\Music\\cataclysm\\MUS_ChoGall_E02.mp3", 60},
				{"Sound\\Music\\cataclysm\\MUS_ChoGall_E03.mp3", 29},
				{"Sound\\Music\\cataclysm\\MUS_ChoGall_E04.mp3", 19},
			},
		},
		{
			name = L["TITLE_COLDMOUNTAINS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_ColdMountain_GU01.mp3", 151},
				{"Sound\\Music\\cataclysm\\MUS_ColdMountain_GU02.mp3", 39},
				{"Sound\\Music\\cataclysm\\MUS_ColdMountain_GU03.mp3", 70},
				{"Sound\\Music\\cataclysm\\MUS_ColdMountain_GU04.mp3", 32},
				{"Sound\\Music\\cataclysm\\MUS_ColdMountain_GU05.mp3", 31},
				{"Sound\\Music\\cataclysm\\MUS_ColdMountain_GU06.mp3", 48},
				{"Sound\\Music\\cataclysm\\MUS_ColdMountain_GU07.mp3", 68},
				{"Sound\\Music\\cataclysm\\MUS_ColdMountain_GU08.mp3", 71},
			},
		},
		{
			name = L["TITLE_HYJAL"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_DarkwhisperGorge_GU01.mp3", 119},
				{"Sound\\Music\\cataclysm\\MUS_DarkwhisperGorge_GU02.mp3", 118},
				{"Sound\\Music\\cataclysm\\MUS_Fire_UU01.mp3", 62},
				{"Sound\\Music\\cataclysm\\MUS_Fire_UU02.mp3", 43},
				{"Sound\\Music\\cataclysm\\MUS_GuardiansofHyjal_GU01.mp3", 133},
				{"Sound\\Music\\cataclysm\\MUS_GuardiansofHyjal_GU02.mp3", 137},
				{"Sound\\Music\\cataclysm\\MUS_GuardiansofHyjal_GU03.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_GuardiansofHyjal_GU04.mp3", 143},
				{"Sound\\Music\\cataclysm\\MUS_Hyjal_GU01.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Hyjal_GU02.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Hyjal_GU03.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Hyjal_GU04.mp3", 116},
				{"Sound\\Music\\cataclysm\\MUS_LandWillWeep_UU01.mp3", 53},
				{"Sound\\Music\\cataclysm\\MUS_LandWillWeep_UU02.mp3", 53},
				{"Sound\\Music\\cataclysm\\MUS_Nordrassil_GU01.mp3", 117},
				{"Sound\\Music\\cataclysm\\MUS_Nordrassil_GU02.mp3", 115},
				{"Sound\\Music\\cataclysm\\MUS_Nordrassil_GU03.mp3", 117},
			},
		},
		{
			name = L["TITLE_DEEPHOLM"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Deepholm_GU01.mp3", 123},
				{"Sound\\Music\\cataclysm\\MUS_Deepholm_GU02.mp3", 126},
				{"Sound\\Music\\cataclysm\\MUS_DeepholmEvent_E01.mp3", 114},
				{"Sound\\Music\\cataclysm\\MUS_DeepholmEvent_E02.mp3", 136},
				{"Sound\\Music\\cataclysm\\MUS_Elemental_UU01.mp3", 59},
				{"Sound\\Music\\cataclysm\\MUS_Elemental_UU02.mp3", 40},
				{"Sound\\Music\\cataclysm\\MUS_Elemental_UU03.mp3", 38},
				{"Sound\\Music\\cataclysm\\MUS_Elemental_UU04.mp3", 131},
				{"Sound\\Music\\cataclysm\\MUS_Elemental_UU05.mp3", 72},
				{"Sound\\Music\\cataclysm\\MUS_Elemental_UU06.mp3", 46},
				{"Sound\\Music\\cataclysm\\MUS_Elemental_UU07.mp3", 69},
				{"Sound\\Music\\cataclysm\\MUS_Scarred_UU01.mp3", 78},
				{"Sound\\Music\\cataclysm\\MUS_Scarred_UU02.mp3", 27},
				{"Sound\\Music\\cataclysm\\MUS_Scarred_UU03.mp3", 35},
				{"Sound\\Music\\cataclysm\\MUS_Scarred_UU04.mp3", 51},
			},
		},
		{
			name = L["TITLE_EYE_OT_VORTEX"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_EyeOfTheVortex_GU01.mp3", 97},
				{"Sound\\Music\\cataclysm\\MUS_EyeOfTheVortex_GU02.mp3", 49},
				{"Sound\\Music\\cataclysm\\MUS_EyeOfTheVortex_GU03.mp3", 69},
			},
		},
		{
			name = L["TITLE_GOBLINS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU01.mp3", 24},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU02.mp3", 12},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU03.mp3", 9},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU04.mp3", 14},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU05.mp3", 19},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU06.mp3", 18},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU07.mp3", 10},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU08.mp3", 47},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU09.mp3", 86},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU10.mp3", 47},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU11.mp3", 45},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU12.mp3", 46},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU13.mp3", 47},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU14.mp3", 47},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU15.mp3", 47},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU16.mp3", 87},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU17.mp3", 86},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU18.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU19.mp3", 24},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU20.mp3", 11},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU21.mp3", 11},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU22.mp3", 19},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU23.mp3", 8},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU24.mp3", 14},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU25.mp3", 14},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU26.mp3", 19},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU27.mp3", 19},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU28.mp3", 19},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU29.mp3", 16},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU30.mp3", 18},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU31.mp3", 19},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU32.mp3", 14},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU33.mp3", 15},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU34.mp3", 18},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU35.mp3", 17},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU36.mp3", 16},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU37.mp3", 17},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU38.mp3", 8},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU39.mp3", 8},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU40.mp3", 10},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU41.mp3", 17},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU42.mp3", 18},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU43.mp3", 21},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU44.mp3", 20},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU45.mp3", 16},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU46.mp3", 18},
				{"Sound\\Music\\cataclysm\\MUS_Goblin_UU47.mp3", 51},
				{"Sound\\Music\\cataclysm\\MUS_GoblinHotRodRadioLoop_EU01.mp3", 165},
				{"Sound\\Music\\cataclysm\\MUS_LIRescue_EU01.mp3", 37},
				{"Sound\\Music\\cataclysm\\MUS_LIRescue_EU02.mp3", 11},
				{"Sound\\Music\\cataclysm\\MUS_LIRescue_EU03.mp3", 53},
				{"Sound\\Music\\cataclysm\\MUS_LIRescue_EU04.mp3", 87},
			},
		},
		{
			name = L["TITLE_ULDUM"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_LostCity_GU01.mp3", 133},
				{"Sound\\Music\\cataclysm\\MUS_LostCity_GU02.mp3", 118},
				{"Sound\\Music\\cataclysm\\MUS_LostCity_GU03.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_LostCity_GU04.mp3", 98},
				{"Sound\\Music\\cataclysm\\MUS_LostCity_GU05.mp3", 72},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU01.mp3", 159},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU02.mp3", 207},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU03.mp3", 109},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU04.mp3", 117},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU05.mp3", 140},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU06.mp3", 42},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU07.mp3", 42},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU08.mp3", 42},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU09.mp3", 207},
				{"Sound\\Music\\cataclysm\\MUS_Skywall_GU10.mp3", 109},
				{"Sound\\Music\\cataclysm\\MUS_Treasure_UU01.mp3", 158},
				{"Sound\\Music\\cataclysm\\MUS_Treasure_UU02.mp3", 91},
				{"Sound\\Music\\cataclysm\\MUS_Treasure_UU03.mp3", 63},
				{"Sound\\Music\\cataclysm\\MUS_Treasure_UU04.mp3", 69},
				{"Sound\\Music\\cataclysm\\MUS_Treasure_UU05.mp3", 77},
				{"Sound\\Music\\cataclysm\\MUS_Treasure_UU06.mp3", 70},
				{"Sound\\Music\\cataclysm\\MUS_UldumA_GU01.mp3", 134},
				{"Sound\\Music\\cataclysm\\MUS_UldumA_GU02.mp3", 44},
				{"Sound\\Music\\cataclysm\\MUS_UldumA_GU03.mp3", 94},
				{"Sound\\Music\\cataclysm\\MUS_UldumA_GU04.mp3", 110},
				{"Sound\\Music\\cataclysm\\MUS_UldumA_GU05.mp3", 110},
				{"Sound\\Music\\cataclysm\\MUS_UldumB_GU01.mp3", 126},
				{"Sound\\Music\\cataclysm\\MUS_UldumB_GU02.mp3", 127},
				{"Sound\\Music\\cataclysm\\MUS_UldumB_GU03.mp3", 127},
				{"Sound\\Music\\cataclysm\\MUS_UldumB_GU04.mp3", 56},
				{"Sound\\Music\\cataclysm\\MUS_UldumB_GU05.mp3", 57},
				{"Sound\\Music\\cataclysm\\MUS_UldumB_GU06.mp3", 93},
				{"Sound\\Music\\cataclysm\\MUS_UldumEvent_E01.mp3", 79},
			},
		},
		{
			name = L["TITLE_VASHJIR"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Rift_UU01.mp3", 90},
				{"Sound\\Music\\cataclysm\\MUS_Rift_UU02.mp3", 63},
				{"Sound\\Music\\cataclysm\\MUS_Rift_UU03.mp3", 32},
				{"Sound\\Music\\cataclysm\\MUS_Rift_UU04.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU01.mp3", 98},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU02.mp3", 98},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU03.mp3", 153},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU04.mp3", 48},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU05.mp3", 92},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU06.mp3", 153},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU07.mp3", 91},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU08.mp3", 46},
				{"Sound\\Music\\cataclysm\\MUS_Vashjir_GU09.mp3", 132},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU01.mp3", 87},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU02.mp3", 97},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU03.mp3", 97},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU04.mp3", 97},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU05.mp3", 127},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNaga_GU06.mp3", 113},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU01.mp3", 43},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU02.mp3", 89},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU03.mp3", 96},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU04.mp3", 96},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU05.mp3", 91},
				{"Sound\\Music\\cataclysm\\MUS_VashjirNagaThrone_GU06.mp3", 92},
			},
		},
		{
			name = L["TITLE_SHADOWS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Shadows_UU01.mp3", 90},
				{"Sound\\Music\\cataclysm\\MUS_Shadows_UU02.mp3", 29},
				{"Sound\\Music\\cataclysm\\MUS_Shadows_UU03.mp3", 53},
				{"Sound\\Music\\cataclysm\\MUS_Shadows_UU04.mp3", 70},
				{"Sound\\Music\\cataclysm\\MUS_Shadows_UU05.mp3", 60},
			},
		},
		{
			name = L["TITLE_WORDS_AND_MUSIC"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_WordsAndMusicByEvent_E01.mp3", 52},
			},
		},
	},
	
	-- Cataclysm Revamp (split cata because it has too much music lol)
	i4catarevamp = {
		{
			name = L["TITLE_ZULAMAN"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_altarbloodgod_UU01.mp3", 68},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_altarbloodgod_UU02.mp3", 68},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_altarbloodgod_UU03.mp3", 68},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_bethekk_UU01.mp3", 26},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_bethekk_UU02.mp3", 26},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_cacheofmadness_UU01.mp3", 34},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_cacheofmadness_UU02.mp3", 34},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_devilsterrace_UU01.mp3", 15},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_devilsterrace_UU02.mp3", 15},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_mandokir_UU01.mp3", 100},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_mandokir_UU02.mp3", 100},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_templebethek_UU01.mp3", 60},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_templebethek_UU02.mp3", 60},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_terracedevils_UU01.mp3", 16},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_terracedevils_UU02.mp3", 16},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_thecoil_UU01.mp3", 119},
				{"Sound\\Music\\cataclysm\\MUS_41_ZA_thecoil_UU02.mp3", 119},
			},
		},
		{
			name = L["TITLE_CORRUPTED_DRAGONBLIGHT"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_43_CorruptedDragonblight_UU01.mp3", 122},
				{"Sound\\Music\\cataclysm\\MUS_43_CorruptedDragonblight_UU02.mp3", 122},
				{"Sound\\Music\\cataclysm\\MUS_43_CorruptedDragonblight_UU03.mp3", 84},
			},
		},
		{
			name = L["TITLE_ARATHIHIGHLANDS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsA_GD01.mp3", 67},
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsA_GN01.mp3", 68},
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsA_GN02.mp3", 68},
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsB_GD01.mp3", 69},
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsB_GN01.mp3", 69},
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsB_GN02.mp3", 69},
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsC_GD01.mp3", 90},
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsC_GN01.mp3", 86},
				{"Sound\\Music\\cataclysm\\MUS_ArathiHighlandsC_GN02.mp3", 86},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UD07.mp3", 111},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UN08.mp3", 111},
				{"Sound\\Music\\cataclysm\\MUS_Cataclysm_UN09.mp3", 111},
			},
		},
		{
			name = L["TITLE_AZSHARA"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Azshara_GD01.mp3", 70},
				{"Sound\\Music\\cataclysm\\MUS_Azshara_GN01.mp3", 70},
			},
		},
		{
			name = L["TITLE_BURNINGSTEPPES"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_BurningSteppes_GU01.mp3", 133},
				{"Sound\\Music\\cataclysm\\MUS_BurningSteppes_GU02.mp3", 52},
				{"Sound\\Music\\cataclysm\\MUS_BurningSteppes_GU03.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_BurningSteppes_GU04.mp3", 101},
			},
		},
		{
			name = L["TITLE_FELWOOD"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU01.mp3", 21},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU02.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU03.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU04.mp3", 74},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU05.mp3", 76},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU06.mp3", 79},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU07.mp3", 79},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU08.mp3", 79},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU09.mp3", 43},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU10.mp3", 30},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU11.mp3", 45},
				{"Sound\\Music\\cataclysm\\MUS_Cursed_UU12.mp3", 80},
			},
		},
		{
			name = L["TITLE_DARKIRONFORGE"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_DarkIronforge_GU01.mp3", 154},
				{"Sound\\Music\\cataclysm\\MUS_DarkIronforge_GU02.mp3", 66},
				{"Sound\\Music\\cataclysm\\MUS_DarkIronforge_GU03.mp3", 54},
				{"Sound\\Music\\cataclysm\\MUS_DarkIronforge_GU04.mp3", 102},
				{"Sound\\Music\\cataclysm\\MUS_DarkIronforge_GU05.mp3", 46},
				{"Sound\\Music\\cataclysm\\MUS_DarkIronforge_GU06.mp3", 105},
				{"Sound\\Music\\cataclysm\\MUS_DarkIronforge_GU07.mp3", 94},
			},
		},
		{
			name = L["TITLE_DARNASSUS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Darnassus_GI01.mp3", 48},
				{"Sound\\Music\\cataclysm\\MUS_Darnassus_GI02.mp3", 45},
			},
		},
		{
			name = L["TITLE_DUROTAR"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_DurotarA_GU01.mp3", 124},
				{"Sound\\Music\\cataclysm\\MUS_DurotarA_GU02.mp3", 101},
				{"Sound\\Music\\cataclysm\\MUS_DurotarA_GU03.mp3", 101},
				{"Sound\\Music\\cataclysm\\MUS_DurotarB_GU01.mp3", 72},
				{"Sound\\Music\\cataclysm\\MUS_DurotarB_GU02.mp3", 72},
				{"Sound\\Music\\cataclysm\\MUS_DurotarB_GU03.mp3", 95},
				{"Sound\\Music\\cataclysm\\MUS_DurotarB_GU04.mp3", 95},
				{"Sound\\Music\\cataclysm\\MUS_DurotarC_GU01.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_DurotarC_GU02.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_DurotarC_GU03.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_DurotarC_GU04.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_DurotarD_GU01.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_DurotarD_GU02.mp3", 84},
			},
		},
		{
			name = L["TITLE_FERALAS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Feralas_GU01.mp3", 82},
				{"Sound\\Music\\cataclysm\\MUS_Feralas_GU02.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_Feralas_GU03.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Feralas_GU04.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Feralas_GU05.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_Feralas_GU06.mp3", 82},
				{"Sound\\Music\\cataclysm\\MUS_Feralas_GU07.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Feralas_GU08.mp3", 62},
			},
		},
		{
			name = L["TITLE_GHOST"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Ghosts_UU01.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Ghosts_UU02.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Ghosts_UU03.mp3", 91},
			},
		},
		{
			name = L["TITLE_DUSTWALLOWMARSH"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Grimtotem_UU01.mp3", 79},
				{"Sound\\Music\\cataclysm\\MUS_Grimtotem_UU02.mp3", 79},
				{"Sound\\Music\\cataclysm\\MUS_Grimtotem_UU03.mp3", 79},
				{"Sound\\Music\\cataclysm\\MUS_Grimtotem_UU04.mp3", 70},
			},
		},
		{
			name = L["TITLE_DARKSHORE"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_GroveOfTheAncients_GU01.mp3", 88},
				{"Sound\\Music\\cataclysm\\MUS_GroveOfTheAncients_GU02.mp3", 88},
				{"Sound\\Music\\cataclysm\\MUS_GroveOfTheAncients_GU03.mp3", 62},
				{"Sound\\Music\\cataclysm\\MUS_GroveOfTheAncients_GU04.mp3", 62},
				{"Sound\\Music\\cataclysm\\MUS_RuinsOfAuberdine_GU01.mp3", 100},
				{"Sound\\Music\\cataclysm\\MUS_RuinsOfAuberdine_GU02.mp3", 83},
				{"Sound\\Music\\cataclysm\\MUS_RuinsOfAuberdine_GU03.mp3", 83},
				{"Sound\\Music\\cataclysm\\MUS_RuinsOfAuberdine_GU04.mp3", 77},
				{"Sound\\Music\\cataclysm\\MUS_RuinsOfAuberdine_GU05.mp3", 77},
			},
		},
		{
			name = L["TITLE_UNGORO"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Marsh_UU01.mp3", 110},
				{"Sound\\Music\\cataclysm\\MUS_Marsh_UU02.mp3", 88},
				{"Sound\\Music\\cataclysm\\MUS_Marsh_UU03.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Marsh_UU04.mp3", 68},
				{"Sound\\Music\\cataclysm\\MUS_Marsh_UU05.mp3", 103},
				{"Sound\\Music\\cataclysm\\MUS_Marsh_UU06.mp3", 111},
				{"Sound\\Music\\cataclysm\\MUS_Marsh_UU07.mp3", 110},
				{"Sound\\Music\\cataclysm\\MUS_Marsh_UU08.mp3", 98},
			},
		},
		{
			name = L["TITLE_MOONGLADE"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Moonglade_GU01.mp3", 90},
				{"Sound\\Music\\cataclysm\\MUS_Moonglade_GU02.mp3", 39},
				{"Sound\\Music\\cataclysm\\MUS_Moonglade_GU03.mp3", 32},
				{"Sound\\Music\\cataclysm\\MUS_Moonglade_GU04.mp3", 89},
				{"Sound\\Music\\cataclysm\\MUS_Moonglade_GU05.mp3", 87},
				{"Sound\\Music\\cataclysm\\MUS_Moonglade_GU06.mp3", 73},
				{"Sound\\Music\\cataclysm\\MUS_Moonglade_GU07.mp3", 91},
			},
		},
		{
			name = L["TITLE_PLAINS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Mulgore_GU01.mp3", 94},
				{"Sound\\Music\\cataclysm\\MUS_Mulgore_GU02.mp3", 94},
				{"Sound\\Music\\cataclysm\\MUS_Mulgore_GU03.mp3", 94},
				{"Sound\\Music\\cataclysm\\MUS_MulgorePlains_GU01.mp3", 90},
				{"Sound\\Music\\cataclysm\\MUS_MulgorePlains_GU02.mp3", 73},
				{"Sound\\Music\\cataclysm\\MUS_Tauren_UU01.mp3", 76},
				{"Sound\\Music\\cataclysm\\MUS_Tauren_UU02.mp3", 71},
				{"Sound\\Music\\cataclysm\\MUS_ThunderBluff_GU01.mp3", 93},
				{"Sound\\Music\\cataclysm\\MUS_ThunderBluff_GU02.mp3", 85},
				{"Sound\\Music\\cataclysm\\MUS_ThunderBluff_GU03.mp3", 85},
			},
		},
		{
			name = L["TITLE_ORGRIMMAR"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Orgrimmar_GU01.mp3", 108},
				{"Sound\\Music\\cataclysm\\MUS_OrgrimmarLegacy_GU01.mp3", 91},
				{"Sound\\Music\\cataclysm\\MUS_WarMarch_UU01.mp3", 136},
			},
		},
		{
			name = L["TITLE_TELDRASIL"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Shadowglen_GU01.mp3", 87},
				{"Sound\\Music\\cataclysm\\MUS_Shadowglen_GU02.mp3", 87},
				{"Sound\\Music\\cataclysm\\MUS_Shadowglen_GU03.mp3", 111},
			},
		},
		{
			name = L["TITLE_SILITHUS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Silithus_GU01.mp3", 99},
				{"Sound\\Music\\cataclysm\\MUS_Silithus_GU02.mp3", 62},
				{"Sound\\Music\\cataclysm\\MUS_Silithus_GU03.mp3", 98},
				{"Sound\\Music\\cataclysm\\MUS_Silithus_GU04.mp3", 111},
				{"Sound\\Music\\cataclysm\\MUS_Silithus_GU05.mp3", 98},
				{"Sound\\Music\\cataclysm\\MUS_Silithus_GU06.mp3", 141},
			},
		},
		{
			name = L["TITLE_SBARRENS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_SouthernBarrens_GU01.mp3", 78},
				{"Sound\\Music\\cataclysm\\MUS_SouthernBarrens_GU02.mp3", 55},
				{"Sound\\Music\\cataclysm\\MUS_SouthernBarrens_GU03.mp3", 20},
				{"Sound\\Music\\cataclysm\\MUS_SouthernBarrens_GU04.mp3", 22},
				{"Sound\\Music\\cataclysm\\MUS_SouthernBarrens_GU05.mp3", 36},
				{"Sound\\Music\\cataclysm\\MUS_SouthernBarrens_GU06.mp3", 27},
			},
		},
		{
			name = L["TITLE_STONETALON"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Stonetalon_GU01.mp3", 88},
				{"Sound\\Music\\cataclysm\\MUS_Stonetalon_GU02.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_Stonetalon_GU03.mp3", 80},
				{"Sound\\Music\\cataclysm\\MUS_Stonetalon_GU04.mp3", 80},
			},
		},
		{
			name = L["TITLE_STORMWIND"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Stormwind_GU01.mp3", 73},
				{"Sound\\Music\\cataclysm\\MUS_Stormwind_GU02.mp3", 38},
				{"Sound\\Music\\cataclysm\\MUS_Stormwind_GU03.mp3", 116},
				{"Sound\\Music\\cataclysm\\MUS_Stormwind_GU04.mp3", 66},
			},
		},
		{
			name = L["TITLE_STRAGLETHORN"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Stranglethorn_GU01.mp3", 64},
				{"Sound\\Music\\cataclysm\\MUS_Stranglethorn_GU02.mp3", 90},
				{"Sound\\Music\\cataclysm\\MUS_Stranglethorn_GU03.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Stranglethorn_GU04.mp3", 89},
				{"Sound\\Music\\cataclysm\\MUS_StranglethornVale_GU01.mp3", 78},
				{"Sound\\Music\\cataclysm\\MUS_StranglethornVale_GU02.mp3", 93},
				{"Sound\\Music\\cataclysm\\MUS_StranglethornVale_GU03.mp3", 91},
				{"Sound\\Music\\cataclysm\\MUS_StranglethornVale_GU04.mp3", 102},
			},
		},
		{
			name = L["TITLE_TANARIS"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU01.mp3", 87},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU02.mp3", 87},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU03.mp3", 84},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU04.mp3", 66},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU05.mp3", 82},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU06.mp3", 72},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU07.mp3", 72},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU08.mp3", 61},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU09.mp3", 34},
				{"Sound\\Music\\cataclysm\\MUS_Tanaris_GU10.mp3", 84},
			},
		},
		{
			name = L["TITLE_UNDEAD"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Undead_UU01.mp3", 65},
				{"Sound\\Music\\cataclysm\\MUS_Undead_UU02.mp3", 26},
				{"Sound\\Music\\cataclysm\\MUS_Undead_UU03.mp3", 66},
				{"Sound\\Music\\cataclysm\\MUS_Undead_UU04.mp3", 73},
				{"Sound\\Music\\cataclysm\\MUS_Undead_UU05.mp3", 94},
			},
		},
		{
			name = L["TITLE_WESTFALL"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Westfall_GU01.mp3", 122},
				{"Sound\\Music\\cataclysm\\MUS_Westfall_GU02.mp3", 122},
				{"Sound\\Music\\cataclysm\\MUS_Westfall_GU03.mp3", 122},
				{"Sound\\Music\\cataclysm\\MUS_Westfall_GU04.mp3", 115},
				{"Sound\\Music\\cataclysm\\MUS_Westfall_GU05.mp3", 48},
			},
		},
		{
			name = L["TITLE_WESTPLAGUE"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueA_GD01.mp3", 50},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueA_GN01.mp3", 51},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueA_GN02.mp3", 51},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueB_GD01.mp3", 50},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueB_GN01.mp3", 50},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueB_GN02.mp3", 50},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueB_GN03.mp3", 50},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueC_GD01.mp3", 50},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueC_GN01.mp3", 50},
				{"Sound\\Music\\cataclysm\\MUS_WestPlagueC_GN02.mp3", 50},
			},
		},
		{
			name = L["TITLE_WINTERSPRING"],
			files = {
				{"Sound\\Music\\cataclysm\\MUS_Winterspring_GU01.mp3", 66},
				{"Sound\\Music\\cataclysm\\MUS_Winterspring_GU02.mp3", 66},
				{"Sound\\Music\\cataclysm\\MUS_Winterspring_GU03.mp3", 66},
				{"Sound\\Music\\cataclysm\\MUS_Winterspring_GU04.mp3", 76},
				{"Sound\\Music\\cataclysm\\MUS_Winterspring_GU05.mp3", 107},
			},
		},
	},
	
	-- Mists of Pandaria
	i5mop = {
		{
			name = L["TITLE_MAIN_THEME"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_HeartofPandaria_01.mp3", 480},
			},
		},
		{
			name = L["TITLE_MOGU"],
			files = {
				{"Sound\\Music\\Pandaria\\FlyBy_52_MoguBridge_MX_SFX.mp3", 42},
				{"Sound\\Music\\Pandaria\\FlyBy_52_MoguSecret_MX_SFX.mp3", 27},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_A_Hero_01.mp3", 85},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_A_Hero_02.mp3", 90},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_B_01.mp3", 92},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_B_02.mp3", 34},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_B_03.mp3", 77},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_B_04.mp3", 61},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_B_05.mp3", 80},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_B_06.mp3", 82},
				{"Sound\\Music\\Pandaria\\MUS_50_Mogu_B_Hero_01.mp3", 138},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_01.mp3", 128},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_02.mp3", 61},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_03.mp3", 59},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_04.mp3", 71},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_A_Hero_01.mp3", 133},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_B_01.mp3", 46},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_B_Hero_01.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_B_Stinger_01.mp3", 9},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_01.mp3", 83},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_02.mp3", 78},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_03.mp3", 26},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_04.mp3", 186},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_05.mp3", 155},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_06.mp3", 141},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_Hero_01.mp3", 167},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_Stinger_01.mp3", 13},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_C_Stinger_02.mp3", 14},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_D_01.mp3", 112},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_D_02.mp3", 85},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientMogu_D_Hero_01.mp3", 117},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientPandaria_A_01.mp3", 100},
				{"Sound\\Music\\Pandaria\\MUS_52_AncientPandaria_Hero_01.mp3", 100},
				{"Sound\\Music\\Pandaria\\MUS_52_GodsAndMonster_01.mp3", 159},
			},
		},
		{
			name = L["TITLE_AUGUSTCELESTIALS"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_01.mp3", 61},
				{"Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_02.mp3", 65},
				{"Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_03.mp3", 59},
				{"Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_04.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_05.mp3", 150},
				{"Sound\\Music\\Pandaria\\MUS_50_AugustCelestials_Hero_01.mp3", 130},
				{"Sound\\Music\\Pandaria\\MUS_50_BalloonRide_Hero_01.mp3", 169},
			},
		},
		{
			name = L["TITLE_BAMBOO"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_Bamboo_01.mp3", 46},
				{"Sound\\Music\\Pandaria\\MUS_50_Bamboo_02.mp3", 52},
				{"Sound\\Music\\Pandaria\\MUS_50_Bamboo_03.mp3", 69},
				{"Sound\\Music\\Pandaria\\MUS_50_Bamboo_04.mp3", 98},
				{"Sound\\Music\\Pandaria\\MUS_50_Bamboo_Hero_01.mp3", 88},
				{"Sound\\Music\\Pandaria\\MUS_50_Bamboo_Night_01.mp3", 61},
				{"Sound\\Music\\Pandaria\\MUS_50_Bamboo_Night_Hero_01.mp3", 102},
			},
		},
		{
			name = L["TITLE_BATTLE4PANDARIA"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_BattleforPandaria_Hero_01.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_50_BattleforPandaria_Hero_02.mp3", 61},
			},
		},
		{
			name = L["TITLE_BREWING"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_BottomsUp_01.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_50_BottomsUp_Hero_01.mp3", 88},
				{"Sound\\Music\\Pandaria\\MUS_50_Darkbrew_01.mp3", 88},
				{"Sound\\Music\\Pandaria\\MUS_50_Darkbrew_Hero_01.mp3", 61},
			},
		},
		{
			name = L["TITLE_DREADWASTES"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_DreadWastes_A_Hero_01.mp3", 84},
				{"Sound\\Music\\Pandaria\\MUS_50_DreadWastes_A_Hero_02.mp3", 72},
				{"Sound\\Music\\Pandaria\\MUS_50_Mantid_A_01.mp3", 35},
				{"Sound\\Music\\Pandaria\\MUS_50_Mantid_A_02.mp3", 88},
				{"Sound\\Music\\Pandaria\\MUS_50_Mantid_A_03.mp3", 109},
				{"Sound\\Music\\Pandaria\\MUS_50_Mantid_A_Hero_01.mp3", 95},
			},
		},
		{
			name = L["TITLE_GATE_OT_SETTING_SUN"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_GateoftheSettingSun_B_01.mp3", 97},
				{"Sound\\Music\\Pandaria\\MUS_50_GateoftheSettingSun_B_Hero_01.mp3", 81},
				{"Sound\\Music\\Pandaria\\MUS_50_GateoftheSettingSun_B_Hero_02.mp3", 52},
			},
		},
		{
			name = L["TITLE_HOZEN"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_01.mp3", 57},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_02.mp3", 34},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_03.mp3", 42},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_04.mp3", 50},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_05.mp3", 78},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_06.mp3", 105},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_07.mp3", 32},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_08.mp3", 30},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_09.mp3", 40},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_10.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_11.mp3", 68},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_12.mp3", 55},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_13.mp3", 31},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_A_Hero_01.mp3", 108},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_B_01.mp3", 49},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_B_02.mp3", 49},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_B_03.mp3", 49},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_B_Hero_01.mp3", 49},
				{"Sound\\Music\\Pandaria\\MUS_50_Hozen_Walk_01.mp3", 75},
			},
		},
		{
			name = L["TITLE_RSASARANGWILDS"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_A_Hero_01.mp3", 90},
				{"Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_A_Hero_02.mp3", 75},
				{"Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_B_Hero_01.mp3", 82},
				{"Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_B_Hero_02.mp3", 60},
				{"Sound\\Music\\Pandaria\\MUS_50_KrasarangWilds_B_Hero_03.mp3", 70},
			},
		},
		{
			name = L["TITLE_KUNLAISUMMIT"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_A_Hero_01.mp3", 51},
				{"Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_A_Hero_02.mp3", 64},
				{"Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_A_Hero_03.mp3", 79},
				{"Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_A_Hero_04.mp3", 46},
				{"Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_B_Hero_01.mp3", 158},
				{"Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_C_Hero_01.mp3", 72},
				{"Sound\\Music\\Pandaria\\MUS_50_KunLaiSummit_C_Hero_02.mp3", 77},
			},
		},
		{
			name = L["TITLE_MONKS"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Brewmaster_A_01.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Brewmaster_A_Hero_01.mp3", 79},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_01.mp3", 124},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_02.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_03.mp3", 92},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_Hero_01.mp3", 48},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_Hero_02.mp3", 79},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_Walk_01.mp3", 69},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_A_Walk_02.mp3", 59},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_01.mp3", 89},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_02.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_03.mp3", 66},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_04.mp3", 70},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Mistweaver_B_Hero_01.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_01.mp3", 157},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_02.mp3", 105},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_03.mp3", 68},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Hero_01.mp3", 93},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Hero_02.mp3", 81},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Walk_01.mp3", 108},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Walk_02.mp3", 118},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Walk_03.mp3", 94},
				{"Sound\\Music\\Pandaria\\MUS_50_Monk_Windwalker_A_Walk_04.mp3", 71},
			},
		},
		{
			name = L["TITLE_PANDARIA"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_01.mp3", 38},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_02.mp3", 53},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_03.mp3", 79},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_Choir_01.mp3", 92},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_A_Hero_01.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_B_01.mp3", 55},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_B_Hero_01.mp3", 80},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_B_Hero_02.mp3", 71},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Hero_01.mp3", 43},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Hero_02.mp3", 75},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Hero_03.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Walk_01.mp3", 69},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Walk_02.mp3", 63},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_C_Walk_03.mp3", 110},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_D_01.mp3", 53},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_D_02.mp3", 60},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_D_03.mp3", 43},
				{"Sound\\Music\\Pandaria\\MUS_50_Pandaria_D_Hero_01.mp3", 116},
				{"Sound\\Music\\Pandaria\\MUS_50_PandariaPVP_Hero_01.mp3", 134},
				{"Sound\\Music\\Pandaria\\MUS_50_PandariaPVP_Hero_02.mp3", 66},
			},
		},
		{
			name = L["TITLE_SCARLETMONASTERY"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_ScarletMonastery_A_Hero_01.mp3", 83},
				{"Sound\\Music\\Pandaria\\MUS_50_ScarletMonastery_A_Hero_02.mp3", 54},
				{"Sound\\Music\\Pandaria\\MUS_50_ScarletMonastery_A_Hero_03.mp3", 117},
			},
		},
		{
			name = L["TITLE_SCHOLOMANCE"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_01.mp3", 59},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_02.mp3", 68},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_03.mp3", 61},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_04.mp3", 78},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_05.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_06.mp3", 81},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_07.mp3", 74},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_08.mp3", 78},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_09.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_10.mp3", 84},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_11.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_50_Scholomance_A_12.mp3", 103},
			},
		},
		{
			name = L["TITLE_SERPENTHEART"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Hero_01.mp3", 93},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Hero_02.mp3", 84},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Hero_03.mp3", 93},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Hero_01.mp3", 110},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Hero_02.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Walk_01.mp3", 131},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Walk_02.mp3", 71},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentsHeart_Night_Walk_03.mp3", 102},
			},
		},
		{
			name = L["TITLE_SHA"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_01.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_02.mp3", 66},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Hero_01.mp3", 70},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Heavy_01.mp3", 26},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Heavy_02.mp3", 18},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Heavy_03.mp3", 21},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Lite_01.mp3", 20},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Lite_02.mp3", 18},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Lite_03.mp3", 18},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Lite_04.mp3", 19},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Med_01.mp3", 24},
				{"Sound\\Music\\Pandaria\\MUS_50_Sha_Stinger_Med_02.mp3", 15},
				{"Sound\\Music\\Pandaria\\MUS_50_ShaWalk_Hero_01.mp3", 85},
				{"Sound\\Music\\Pandaria\\MUS_50_ShaWalk_Hero_02.mp3", 57},
				{"Sound\\Music\\Pandaria\\MUS_50_ShaWalk_Hero_03.mp3", 88},
				{"Sound\\Music\\Pandaria\\MUS_50_ShaWalk_Hero_04.mp3", 61},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_01.mp3", 19},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_02.mp3", 20},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_03.mp3", 20},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_04.mp3", 20},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_A_05.mp3", 19},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_01.mp3", 20},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_02.mp3", 20},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_03.mp3", 20},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_04.mp3", 20},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_05.mp3", 19},
				{"Sound\\Music\\Pandaria\\MUS_50_ShoSha_B_06.mp3", 24},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_01.mp3", 53},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_02.mp3", 59},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_03.mp3", 59},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_04.mp3", 59},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaAmbient_Hero.mp3", 114},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaAngry_01.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaAngry_02.mp3", 61},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaAngry_Hero.mp3", 133},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaDescendant_01.mp3", 44},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaDescendant_02.mp3", 49},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaDescendant_03.mp3", 45},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaDescendant_Hero.mp3", 88},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaVocaline_01.mp3", 19},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaVocaline_02.mp3", 60},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaVocaline_03.mp3", 60},
				{"Sound\\Music\\Pandaria\\MUS_54_ShaVocaline_Hero.mp3", 66},
			},
		},
		{
			name = L["TITLE_SHADOPAN"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Hero_01.mp3", 75},
				{"Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Hero_02.mp3", 63},
				{"Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Hero_03.mp3", 172},
				{"Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Walk_01.mp3", 54},
				{"Sound\\Music\\Pandaria\\MUS_50_ShadoPan_A_Walk_02.mp3", 66},
				{"Sound\\Music\\Pandaria\\MUS_50_ShadoPan_B_Hero_01.mp3", 116},
				{"Sound\\Music\\Pandaria\\MUS_50_ShadoPan_B_Hero_02.mp3", 76},
			},
		},
		{
			name = L["TITLE_SHENZINSU"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_01.mp3", 99},
				{"Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_02.mp3", 114},
				{"Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_03.mp3", 114},
				{"Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_Hero_01.mp3", 51},
				{"Sound\\Music\\Pandaria\\MUS_50_ShenZinSu_Hero_02.mp3", 67},
			},
		},
		{
			name = L["TITLE_SIEGENIUZAOTEMPLE"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_SiegeofNiuzaoTemple_Hero_01.mp3", 78},
				{"Sound\\Music\\Pandaria\\MUS_50_SiegeofNiuzaoTemple_Hero_02.mp3", 55},
				{"Sound\\Music\\Pandaria\\MUS_50_SiegeofNiuzaoTemple_Hero_03.mp3", 58},
			},
		},
		{
			name = L["TITLE_SPIRITCAVE"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritCave_01.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritCave_02.mp3", 98},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritCave_03.mp3", 98},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritCave_04.mp3", 70},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritCave_05.mp3", 129},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritCave_06.mp3", 131},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritCave_Hero_01.mp3", 130},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritPath_01.mp3", 74},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritPath_02.mp3", 73},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritPath_03.mp3", 77},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritPath_04.mp3", 51},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritPath_Hero_01.mp3", 72},
				{"Sound\\Music\\Pandaria\\MUS_50_Spirits_A_01.mp3", 52},
				{"Sound\\Music\\Pandaria\\MUS_50_Spirits_A_02.mp3", 72},
				{"Sound\\Music\\Pandaria\\MUS_50_Spirits_A_03.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_50_Spirits_A_04.mp3", 83},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritsB_01.mp3", 74},
				{"Sound\\Music\\Pandaria\\MUS_50_SpiritsB_02.mp3", 73},
			},
		},
		{
			name = L["TITLE_TEMPLE5DAWNS"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_01.mp3", 68},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_02.mp3", 64},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_03.mp3", 70},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_04.mp3", 40},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_05.mp3", 39},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_06.mp3", 48},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_07.mp3", 43},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_08.mp3", 11},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_09.mp3", 93},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_10.mp3", 100},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_11.mp3", 52},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_12.mp3", 19},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheFiveDawns_Hero_01.mp3", 101},
			},
		},
		{
			name = L["TITLE_TEMPLEJADESERPENT"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheJadeSerpent_Hero_01.mp3", 75},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheJadeSerpent_Hero_02.mp3", 88},
				{"Sound\\Music\\Pandaria\\MUS_50_TempleoftheJadeSerpent_Hero_03.mp3", 73},
			},
		},
		{
			name = L["TITLE_SHRINE"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_Toast_A_01.mp3", 54},
				{"Sound\\Music\\Pandaria\\MUS_50_Toast_A_Hero_01.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_50_Toast_B_02.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_50_Toast_B_03.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_50_Toast_B_04.mp3", 88},
				{"Sound\\Music\\Pandaria\\MUS_50_Toast_B_Hero_01.mp3", 91},
			},
		},
		{
			name = L["TITLE_TOWNLONGSTEPPES"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_A_Hero_01.mp3", 95},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_A_Hero_02.mp3", 114},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_B_01.mp3", 97},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_B_02.mp3", 90},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_B_Hero_01.mp3", 105},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Hero_01.mp3", 80},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Hero_02.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Hero_03.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Night_Hero_01.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Night_Hero_02.mp3", 70},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_C_Night_Hero_03.mp3", 70},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_D_01.mp3", 63},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_D_Hero_01.mp3", 42},
				{"Sound\\Music\\Pandaria\\MUS_50_TownlongSteppes_D_Hero_02.mp3", 70},
			},
		},
		{
			name = L["TITLE_GECKO"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_A_01.mp3", 57},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_A_02.mp3", 55},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_A_03.mp3", 38},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_A_04.mp3", 50},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_A_05.mp3", 52},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_A_06.mp3", 85},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_A_Hero_01.mp3", 122},
			},
		},
		{
			name = L["TITLE_FAMILY"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_01.mp3", 110},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_02.mp3", 111},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_03.mp3", 111},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_Hero_01.mp3", 113},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_01.mp3", 69},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_02.mp3", 45},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_03.mp3", 109},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_04.mp3", 122},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_05.mp3", 124},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_B_Night_06.mp3", 117},
			},
		},
		{
			name = L["TITLE_VALEETERNAL"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_C_Hero_01.mp3", 26},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_C_Hero_02.mp3", 29},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_D_Hero_01.mp3", 73},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_D_Hero_02.mp3", 71},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_D_Hero_03.mp3", 52},
				{"Sound\\Music\\Pandaria\\MUS_50_VEB_D_Hero_04.mp3", 50},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_01.mp3", 52},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_02.mp3", 82},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_03.mp3", 53},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_04.mp3", 81},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_05.mp3", 54},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_06.mp3", 81},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_07.mp3", 54},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_08.mp3", 102},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_Hero_01.mp3", 51},
				{"Sound\\Music\\Pandaria\\MUS_50_VFW_A_Hero_02.mp3", 82},
				{"Sound\\Music\\Pandaria\\MUS_50_Windspire_01.mp3", 86},
				{"Sound\\Music\\Pandaria\\MUS_50_Windspire_02.mp3", 117},
				{"Sound\\Music\\Pandaria\\MUS_50_Windspire_03.mp3", 115},
				{"Sound\\Music\\Pandaria\\MUS_50_Windspire_Hero_01.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_54_ValeHealing.mp3", 87},
			},
		},
		{
			name = L["TITLE_ALLIANCE"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_51_AllianceBattleMarch_01.mp3", 119},
				{"Sound\\Music\\Pandaria\\MUS_51_AllianceBattleMarch_02.mp3", 119},
				{"Sound\\Music\\Pandaria\\MUS_51_AllianceBattleMarch_Hero_01.mp3", 119},
				{"Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_01.mp3", 128},
				{"Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_02.mp3", 100},
				{"Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_03.mp3", 66},
				{"Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_04.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_05.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_51_ForTheAlliance_Hero_01.mp3", 128},
				{"Sound\\Music\\Pandaria\\MUS_54_ForThePandarenAlliance_A_01.mp3", 62},
				{"Sound\\Music\\Pandaria\\MUS_54_ForThePandarenAlliance_A_02.mp3", 79},
				{"Sound\\Music\\Pandaria\\MUS_54_ForThePandarenAlliance_B_01.mp3", 61},
				{"Sound\\Music\\Pandaria\\MUS_54_ForThePandarenAlliance_B_02.mp3", 78},
			},
		},
		{
			name = L["TITLE_HORDE"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_A_01.mp3", 163},
				{"Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_A_02.mp3", 166},
				{"Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_A_Hero_01.mp3", 166},
				{"Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_B_01.mp3", 175},
				{"Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_B_02.mp3", 174},
				{"Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_B_Hero_01.mp3", 175},
				{"Sound\\Music\\Pandaria\\MUS_51_GarroshTheme_Big_DivineBellFinale.mp3", 123},
				{"Sound\\Music\\Pandaria\\MUS_54_NoQuarter_01.mp3", 108},
				{"Sound\\Music\\Pandaria\\MUS_54_NoQuarter_02.mp3", 77},
				{"Sound\\Music\\Pandaria\\MUS_54_NoQuarter_03.mp3", 68},
				{"Sound\\Music\\Pandaria\\MUS_54_NoQuarter_04.mp3", 84},
				{"Sound\\Music\\Pandaria\\MUS_54_NoQuarter_Hero.mp3", 108},
				{"Sound\\Music\\Pandaria\\MUS_54_Overlord_01.mp3", 69},
				{"Sound\\Music\\Pandaria\\MUS_54_Overlord_02.mp3", 65},
				{"Sound\\Music\\Pandaria\\MUS_54_Overlord_03.mp3", 27},
				{"Sound\\Music\\Pandaria\\MUS_54_Overlord_Hero.mp3", 69},
			},
		},
		{
			name = L["TITLE_KIRINTOR"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Lyrical_01.mp3", 107},
				{"Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Lyrical_02.mp3", 106},
				{"Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Lyrical_Hero_01.mp3", 107},
				{"Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Military_01.mp3", 102},
				{"Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Military_02.mp3", 103},
				{"Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Military_03.mp3", 41},
				{"Sound\\Music\\Pandaria\\MUS_51_JainaHomeland_Military_Hero_01.mp3", 104},
				{"Sound\\Music\\Pandaria\\MUS_51_Theramores_Fall_Scene_01.mp3", 56}, -- will be doubled for sunreavers
			},
		},
		{
			name = L["TITLE_SUNREAVERS"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_01.mp3", 59},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_02.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_03.mp3", 76},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_04.mp3", 65},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_05.mp3", 23},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_06.mp3", 19},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_07.mp3", 22},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_08.mp3", 23},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_09.mp3", 36},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_10.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_11.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_12.mp3", 57},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_13.mp3", 112},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_14.mp3", 34},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_15.mp3", 12},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_16.mp3", 65},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_17.mp3", 10},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_18.mp3", 9},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_19.mp3", 9},
				{"Sound\\Music\\Pandaria\\MUS_51_Sunreavers_Hero_01.mp3", 130},
				{"Sound\\Music\\Pandaria\\MUS_51_Theramores_Fall_Scene_01.mp3", 56}, -- will be doubled for kirin tor
			},
		},
		{
			name = L["TITLE_ISLEOFTHUNDER"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_01.mp3", 39},
				{"Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_02.mp3", 46},
				{"Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_03.mp3", 49},
				{"Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_04.mp3", 91},
				{"Sound\\Music\\Pandaria\\MUS_52_ItIsDone_A_05.mp3", 53},
				{"Sound\\Music\\Pandaria\\MUS_52_Mysterioso_A_01.mp3", 74},
				{"Sound\\Music\\Pandaria\\MUS_52_Mysterioso_A_02.mp3", 74},
				{"Sound\\Music\\Pandaria\\MUS_52_Mysterioso_Hero_01.mp3", 74},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_01.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_02.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_03.mp3", 66},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_04.mp3", 22},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_05.mp3", 124},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_06.mp3", 60},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_07.mp3", 71},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Hero_01.mp3", 114},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Stinger_01.mp3", 9},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Stinger_02.mp3", 8},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Stinger_03.mp3", 6},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_A_Stinger_04.mp3", 9},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_01.mp3", 66},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_02.mp3", 73},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_03.mp3", 94},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_04.mp3", 106},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_05.mp3", 97},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_B_Hero_01.mp3", 121},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_01.mp3", 95},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_02.mp3", 98},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_03.mp3", 119},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_04.mp3", 48},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_Hero_01.mp3", 121},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_Stinger_01.mp3", 11},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_Stinger_02.mp3", 23},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderIsle_C_Stinger_03.mp3", 9},			},
		},
		{
			name = L["TITLE_THUNDERKING"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_01.mp3", 42},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_02.mp3", 10},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_03.mp3", 56},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Hero_01.mp3", 97},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_01.mp3", 8},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_02.mp3", 13},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_03.mp3", 12},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_04.mp3", 12},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_05.mp3", 14},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_06.mp3", 15},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_A_Stinger_07.mp3", 13},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_B_01.mp3", 44},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_B_Hero_01.mp3", 44},
				{"Sound\\Music\\Pandaria\\MUS_52_ThunderKing_C_Stinger_01.mp3", 3},
				{"Sound\\Music\\Pandaria\\MUS_52_TrovesOfTheThunderKing_01.mp3", 309},
				{"Sound\\Music\\Pandaria\\MUS_53_EmperorRevealed.mp3", 139},
			},
		},
		{
			name = L["TITLE_TROLLS"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_52_TrollBattle_A_01.mp3", 40},
				{"Sound\\Music\\Pandaria\\MUS_52_TrollBattle_A_02.mp3", 84},
				{"Sound\\Music\\Pandaria\\MUS_52_TrollBattle_A_03.mp3", 56},
				{"Sound\\Music\\Pandaria\\MUS_52_TrollBattle_B_01.mp3", 41},
				{"Sound\\Music\\Pandaria\\MUS_52_TrollBattle_B_02.mp3", 80},
				{"Sound\\Music\\Pandaria\\MUS_52_TrollBattle_B_03.mp3", 54},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_A_01.mp3", 72},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_A_02.mp3", 80},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_A_03.mp3", 75},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_B_01.mp3", 72},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_B_02.mp3", 80},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_B_03.mp3", 74},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_C_01.mp3", 64},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_1_C_02.mp3", 79},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_01.mp3", 77},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_02.mp3", 50},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_03.mp3", 38},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_04.mp3", 49},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_A_05.mp3", 64},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_B_01.mp3", 118},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_B_02.mp3", 46},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_B_03.mp3", 64},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_C_01.mp3", 77},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_C_02.mp3", 50},
				{"Sound\\Music\\Pandaria\\MUS_52_Zandalari_2_C_03.mp3", 33},
				{"Sound\\Music\\Pandaria\\MUS_52_ZandalariProphecy_01.mp3", 170},
			},
		},
		{
			name = L["TITLE_WRATHION"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_52_Wrathion_A_02.mp3", 36},
				{"Sound\\Music\\Pandaria\\MUS_52_Wrathion_A_03.mp3", 65},
				{"Sound\\Music\\Pandaria\\MUS_52_Wrathion_A_Hero_01.mp3", 159},
				{"Sound\\Music\\Pandaria\\MUS_52_Wrathion_B_01.mp3", 79},
				{"Sound\\Music\\Pandaria\\MUS_52_Wrathion_B_02.mp3", 39},
				{"Sound\\Music\\Pandaria\\MUS_52_Wrathion_B_03.mp3", 65},
				{"Sound\\Music\\Pandaria\\MUS_53_Wrathion_C_01.mp3", 78},
				{"Sound\\Music\\Pandaria\\MUS_53_Wrathion_C_02.mp3", 45},
			},
		},
		{
			name = L["TITLE_CORRUPTEDVALE"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_01.mp3", 69},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_02.mp3", 38},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_03.mp3", 41},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_04.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Day_Hero.mp3", 107},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_01.mp3", 40},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_02.mp3", 35},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_03.mp3", 35},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_04.mp3", 105},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_05.mp3", 53},
				{"Sound\\Music\\Pandaria\\MUS_54_CorruptedVale_Night_Hero.mp3", 140},
				{"Sound\\Music\\Pandaria\\MUS_54_GoodMourning_Hero.mp3", 84},
			},
		},
		{
			name = L["TITLE_DOOMHAMMER"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_54_Doomhammer_01.mp3", 124},
				{"Sound\\Music\\Pandaria\\MUS_54_Doomhammer_02.mp3", 110},
				{"Sound\\Music\\Pandaria\\MUS_54_Doomhammer_03.mp3", 67},
				{"Sound\\Music\\Pandaria\\MUS_54_Doomhammer_04.mp3", 69},
				{"Sound\\Music\\Pandaria\\MUS_54_Doomhammer_05.mp3", 81},
				{"Sound\\Music\\Pandaria\\MUS_54_Doomhammer_Hero.mp3", 124},
			},
		},
		{
			name = L["TITLE_LEGENDARY"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_01.mp3", 36},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_02.mp3", 50},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_03.mp3", 105},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_04.mp3", 60},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_05.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_06.mp3", 7},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_07.mp3", 34},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_08.mp3", 72},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_09.mp3", 63},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_10.mp3", 23},
				{"Sound\\Music\\Pandaria\\MUS_54_Legendary_Hero.mp3", 107},
			},
		},
		{
			name = L["TITLE_MOKRAH"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_01.mp3", 50},
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_02.mp3", 19},
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_03.mp3", 46},
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_04.mp3", 57},
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_05.mp3", 55},
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_06.mp3", 55},
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_07.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_08.mp3", 79},
				{"Sound\\Music\\Pandaria\\MUS_54_Mok-Rah_Hero.mp3", 122},
			},
		},
		{
			name = L["TITLE_WANDERINGISLE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_Hero_UU01.mp3", 101},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU01.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU02.mp3", 107},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU03.mp3", 68},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU04.mp3", 108},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleA_UU05.mp3", 54},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleB_Hero_UU01.mp3", 135},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleB_UU01.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_Hero_UU01.mp3", 84},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_UU01.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_UU02.mp3", 75},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_UU03.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\WanderingIsle\\MUS_50_WanderingIsleC_UU04.mp3", 82},
			},
		},
		{
			name = L["TITLE_VALLEY4WINDS"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_TheHeartland_Hero_01.mp3", 85},
				{"Sound\\Music\\Pandaria\\MUS_50_TheHeartland_Hero_02.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_50_TheHeartland_Hero_03.mp3", 87},
				{"Sound\\Music\\Pandaria\\MUS_50_TheHeartland_Hero_04.mp3", 147},
				{"Sound\\Music\\Pandaria\\MUS_50_TheRiver_01.mp3", 42},
				{"Sound\\Music\\Pandaria\\MUS_50_TheRiver_02.mp3", 58},
				{"Sound\\Music\\Pandaria\\MUS_50_TheRiver_03.mp3", 51},
				{"Sound\\Music\\Pandaria\\MUS_50_TheRiver_04.mp3", 64},
				{"Sound\\Music\\Pandaria\\MUS_50_TheRiver_05.mp3", 124},
				{"Sound\\Music\\Pandaria\\MUS_50_TheRiver_06.mp3", 129},
				{"Sound\\Music\\Pandaria\\MUS_50_TheRiver_07.mp3", 126},
				{"Sound\\Music\\Pandaria\\MUS_50_TheRiver_Hero_01.mp3", 133},
				{"Sound\\Music\\Pandaria\\MUS_50_WoodofStaves_Hero_01.mp3", 64},
				{"Sound\\Music\\Pandaria\\MUS_50_WoodofStaves_Hero_02.mp3", 76},
				{"Sound\\Music\\Pandaria\\MUS_50_WoodofStaves_Hero_03.mp3", 65},
			},
		},
		{
			name = L["TITLE_SONG_LIULANG"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_01.mp3", 125},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_02.mp3", 166},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_03.mp3", 52},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_04.mp3", 45},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_05.mp3", 82},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_06.mp3", 72},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_07.mp3", 114},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_Inst_Hero_01.mp3", 168},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_VOX_Hero_01.mp3", 170},
				{"Sound\\Music\\Pandaria\\MUS_50_SongofLiulang_VOX_Lite_01.mp3", 234},
			},
		},
		{
			name = L["TITLE_SERPENTRACE"],
			files = {
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentRiders_01.mp3", 152},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentRiders_Hero_01.mp3", 152},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentRiders_SerpentRace.mp3", 238},
				{"Sound\\Music\\Pandaria\\MUS_50_SerpentRiders_Victory_Stinger.mp3", 39},
			},
		},
	},
	
	-- Warlords of Draenor
	i6wod = {
		{
			name = L["TITLE_MAIN_THEME"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_ASiegeofWorlds_MainTitle.mp3", 726},
			},
		},
		{
			name = L["TITLE_A_HEROS_SACRIFICE"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_AHerosSacrifice_v1.mp3", 116},
				{"Sound\\Music\\Draenor\\MUS_60_AHerosSacrifice_v2.mp3", 101},
				{"Sound\\Music\\Draenor\\MUS_60_AHerosSacrifice_v3A.mp3", 55},
				{"Sound\\Music\\Draenor\\MUS_60_AHerosSacrifice_v3B.mp3", 60},
				{"Sound\\Music\\Draenor\\MUS_60_AHerosSacrifice_v4.mp3", 24},
				{"Sound\\Music\\Draenor\\MUS_60_AHerosSacrifice_v5.mp3", 67},
			},
		},
		{
			name = L["TITLE_A_LIGHT_IT_DARKNESS"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_ALightintheDarkness_v1.mp3", 155},
				{"Sound\\Music\\Draenor\\MUS_60_ALightintheDarkness_v2.mp3", 137},
				{"Sound\\Music\\Draenor\\MUS_60_ALightintheDarkness_v3.mp3", 154},
				{"Sound\\Music\\Draenor\\MUS_60_ALightintheDarkness_v3A.mp3", 70},
			},
		},
		{
			name = L["TITLE_SPIRES_OF_ARAK"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Arak2_H.mp3", 157},
				{"Sound\\Music\\Draenor\\MUS_60_NightSpires_v1.mp3", 136},
				{"Sound\\Music\\Draenor\\MUS_60_NightSpires_v2.mp3", 115},
				{"Sound\\Music\\Draenor\\MUS_60_NightSpires_v3.mp3", 135},
				{"Sound\\Music\\Draenor\\MUS_60_NightSpires_v4.mp3", 122},
				{"Sound\\Music\\Draenor\\MUS_60_SpiresofArak_v1.mp3", 159},
				{"Sound\\Music\\Draenor\\MUS_60_SpiresofArak_v2.mp3", 102},
				{"Sound\\Music\\Draenor\\MUS_60_SpiresofArak_v4.mp3", 56},
				{"Sound\\Music\\Draenor\\MUS_60_TraversingtheSpires_A.mp3", 128},
				{"Sound\\Music\\Draenor\\MUS_60_TraversingtheSpires_B.mp3", 123},
				{"Sound\\Music\\Draenor\\MUS_60_TraversingtheSpires_C.mp3", 156},
				{"Sound\\Music\\Draenor\\MUS_60_TraversingtheSpires_H1.mp3", 128},
				{"Sound\\Music\\Draenor\\MUS_60_TraversingtheSpires_H2.mp3", 127},
			},
		},
		{
			name = L["TITLE_DRAENOR_ARMY"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Army_A.mp3", 142},
				{"Sound\\Music\\Draenor\\MUS_60_Army_Stinger1.mp3", 11},
				{"Sound\\Music\\Draenor\\mus_60_Army_Stinger2.mp3", 12},
				{"Sound\\Music\\Draenor\\MUS_60_ArmyLife_H.mp3", 141},
			},
		},
		{
			name = L["TITLE_DRAENOR_BLACKROCK"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_BFreedom_H1.mp3", 68},
				{"Sound\\Music\\Draenor\\MUS_60_BFreedom_H2.mp3", 107},
				{"Sound\\Music\\Draenor\\MUS_60_Blackrock_A.mp3", 84},
				{"Sound\\Music\\Draenor\\MUS_60_Blackrock_B.mp3", 41},
				{"Sound\\Music\\Draenor\\MUS_60_Blackrock_C.mp3", 39},
				{"Sound\\Music\\Draenor\\MUS_60_Blackrock_D.mp3", 8},
				{"Sound\\Music\\Draenor\\MUS_60_Blackrock_E.mp3", 37},
				{"Sound\\Music\\Draenor\\MUS_60_Blackrock_H.mp3", 188},
			},
		},
		{
			name = L["TITLE_CALL_OT_WARRIOR"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_CalloftheWarrior_A.mp3", 150},
				{"Sound\\Music\\Draenor\\MUS_60_CalloftheWarrior_C.mp3", 150},
				{"Sound\\Music\\Draenor\\MUS_60_CalloftheWarrior_H.mp3", 150},
			},
		},
		{
			name = L["TITLE_EAGLEOFDRAENOR"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Eagle_A.mp3", 127},
				{"Sound\\Music\\Draenor\\MUS_60_Eagle_B.mp3", 59},
				{"Sound\\Music\\Draenor\\MUS_60_Eagle_C.mp3", 30},
				{"Sound\\Music\\Draenor\\MUS_60_Eagle_D.mp3", 27},
				{"Sound\\Music\\Draenor\\MUS_60_EagleofDraenor_H.mp3", 126},
			},
		},
		{
			name = L["TITLE_ELUNESSHADOW"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_ElunesShadow_A.mp3", 44},
				{"Sound\\Music\\Draenor\\MUS_60_ElunesShadow_B.mp3", 33},
				{"Sound\\Music\\Draenor\\MUS_60_ElunesShadow_C.mp3", 52},
				{"Sound\\Music\\Draenor\\MUS_60_ElunesShadow_H.mp3", 94},
			},
		},
		{
			name = L["TITLE_ETERNALS"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_EternalNight_H.mp3", 75},
				{"Sound\\Music\\Draenor\\MUS_60_EtherealEmbers_C.mp3", 80},
				{"Sound\\Music\\Draenor\\MUS_60_EtherealEmbers_D.mp3", 79},
				{"Sound\\Music\\Draenor\\MUS_60_EtherealEmbers_E.mp3", 81},
				{"Sound\\Music\\Draenor\\MUS_60_EtherealEmbers_F.mp3", 74},
				{"Sound\\Music\\Draenor\\MUS_60_EtherealEmbers_H.mp3", 80},
				{"Sound\\Music\\Draenor\\MUS_60_EtherealEssence_H1.mp3", 102},
				{"Sound\\Music\\Draenor\\MUS_60_EtherealEssence_H2.mp3", 87},
			},
		},
		{
			name = L["TITLE_FELWASTELAND"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_FelWasteland_A.mp3", 71},
				{"Sound\\Music\\Draenor\\MUS_60_FelWasteland_B.mp3", 90},
				{"Sound\\Music\\Draenor\\MUS_60_FelWasteland_C.mp3", 31},
				{"Sound\\Music\\Draenor\\MUS_60_FelWasteland_H.mp3", 85},
			},
		},
		{
			name = L["TITLE_FORSAKEN"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Forsaken_A.mp3", 82},
				{"Sound\\Music\\Draenor\\MUS_60_Forsaken_H.mp3", 124},
			},
		},
		{
			name = L["TITLE_GARDENSKARABOR"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_GardensOfKarabor_A.mp3", 99},
				{"Sound\\Music\\Draenor\\MUS_60_GardensOfKarabor_B.mp3", 47},
				{"Sound\\Music\\Draenor\\MUS_60_GardensOfKarabor_H.mp3", 126},
				{"Sound\\Music\\Draenor\\MUS_60_KeepersoftheTemple_H.mp3", 190},
			},
		},
		{
			name = L["TITLE_GRINSPIRATION"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Grinspiration_A.mp3", 90},
				{"Sound\\Music\\Draenor\\MUS_60_Grinspiration_B.mp3", 81},
				{"Sound\\Music\\Draenor\\MUS_60_Grinspiration_C.mp3", 124},
				{"Sound\\Music\\Draenor\\MUS_60_Grinspiration_H1.mp3", 101},
				{"Sound\\Music\\Draenor\\MUS_60_Grinspiration_H2.mp3", 84},
			},
		},
		{
			name = L["TITLE_GROMMASH"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_GrommashHellscream_v1.mp3", 165},
				{"Sound\\Music\\Draenor\\MUS_60_GrommashHellscream_v2A.mp3", 48},
				{"Sound\\Music\\Draenor\\MUS_60_GrommashHellscream_v2B.mp3", 55},
				{"Sound\\Music\\Draenor\\MUS_60_GrommashHellscreamv_3.mp3", 73},
				{"Sound\\Music\\Draenor\\MUS_60_HerdingClans_H.mp3", 131},
			},
		},
		{
			name = L["TITLE_IRONDAWN"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_IronDawn_v1.mp3", 151},
				{"Sound\\Music\\Draenor\\MUS_60_IronDawn_v2.mp3", 97},
				{"Sound\\Music\\Draenor\\MUS_60_IronDawn_v3A.mp3", 60},
				{"Sound\\Music\\Draenor\\MUS_60_IronDawn_v3B.mp3", 75},
				{"Sound\\Music\\Draenor\\MUS_60_IronDawn_v4.mp3", 154},
			},
		},
		{
			name = L["TITLE_KHADGAR"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_KhadgarsPlan_v1.mp3", 145},
				{"Sound\\Music\\Draenor\\MUS_60_KhadgarsPlan_v2.mp3", 128},
				{"Sound\\Music\\Draenor\\MUS_60_KhadgarsPlan_v3.mp3", 139},
				{"Sound\\Music\\Draenor\\MUS_60_KhadgarsPlan_v4.mp3", 114},
			},
		},
		{
			name = L["TITLE_LABORIOUSMISERY"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_LaboriousMisery_A.mp3", 68},
				{"Sound\\Music\\Draenor\\MUS_60_LaboriousMisery_H.mp3", 69},
			},
		},
		{
			name = L["TITLE_MAGNIFICENTDESO"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation2_A1.mp3", 83},
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation2_A2.mp3", 97},
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation2_H.mp3", 239},
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation2_H1.mp3", 130},
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation2_H2.mp3", 111},
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation_A.mp3", 236},
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation_B.mp3", 159},
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation_H.mp3", 236},
				{"Sound\\Music\\Draenor\\MUS_60_MagnificentDesolation_Piano_A.mp3", 35},
			},
		},
		{
			name = L["TITLE_MALACH"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Malach_H1.mp3", 127},
				{"Sound\\Music\\Draenor\\MUS_60_Malach_H2.mp3", 139},
				{"Sound\\Music\\Draenor\\MUS_60_Malach_H3.mp3", 46},
				{"Sound\\Music\\Draenor\\MUS_60_Malach_H4.mp3", 66},
			},
		},
		{
			name = L["TITLE_MALEVOLENT"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_MalevolentMystique_A.mp3", 78},
				{"Sound\\Music\\Draenor\\MUS_60_MalevolentMystique_B1.MP3", 78},
				{"Sound\\Music\\Draenor\\MUS_60_MalevolentMystique_B2.mp3", 88},
				{"Sound\\Music\\Draenor\\MUS_60_MalevolentMystique_C.mp3", 90},
				{"Sound\\Music\\Draenor\\MUS_60_MalevolentMystique_H.mp3", 124},
				{"Sound\\Music\\Draenor\\MUS_60_MalevolentPrescience_B.mp3", 66},
				{"Sound\\Music\\Draenor\\MUS_60_MalevolentPrescience_H.mp3", 145},
			},
		},
		{
			name = L["TITLE_MANDOWN"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_A1.mp3", 62},
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_A2.mp3", 60},
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_A3.mp3", 61},
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_B.mp3", 82},
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_C.mp3", 82},
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_D.mp3", 168},
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_E.mp3", 102},
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_F.mp3", 89},
				{"Sound\\Music\\Draenor\\MUS_60_ManDown_H1.mp3", 60},
			},
		},
		{
			name = L["TITLE_MOBILIZE"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Mobilize_A.mp3", 142},
				{"Sound\\Music\\Draenor\\MUS_60_Mobilize_B1.mp3", 115},
				{"Sound\\Music\\Draenor\\MUS_60_Mobilize_B2.mp3", 108},
				{"Sound\\Music\\Draenor\\MUS_60_Mobilize_C1.mp3", 113},
				{"Sound\\Music\\Draenor\\MUS_60_Mobilize_C2.mp3", 123},
				{"Sound\\Music\\Draenor\\MUS_60_Mobilize_D.mp3", 58},
				{"Sound\\Music\\Draenor\\MUS_60_Mobilize_E_Stinger.mp3", 22},
				{"Sound\\Music\\Draenor\\MUS_60_Mobilize_H.mp3", 157},
			},
		},
		{
			name = L["TITLE_MOUNTAINSWOD"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Mountains_Ambient2.mp3", 72},
				{"Sound\\Music\\Draenor\\MUS_60_Mountains_Ambient3.mp3", 81},
				{"Sound\\Music\\Draenor\\MUS_60_Mountains_Stinger1.mp3", 17},
				{"Sound\\Music\\Draenor\\MUS_60_MountainsIntro_A1.mp3", 223},
				{"Sound\\Music\\Draenor\\MUS_60_MountainsIntro_A2.mp3", 107},
				{"Sound\\Music\\Draenor\\MUS_60_MountainsofNagrand_A1.mp3", 70},
				{"Sound\\Music\\Draenor\\MUS_60_MountainsofNagrand_A2.mp3", 123},
				{"Sound\\Music\\Draenor\\MUS_60_MountainsofNagrand_B.mp3", 120},
				{"Sound\\Music\\Draenor\\MUS_60_MountainsofNagrand_H.mp3", 193},
				{"Sound\\Music\\Draenor\\MUS_60_ColdMountain_Duet_H.mp3", 156},
			},
		},
		{
			name = L["TITLE_MYSTIC"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_A1.mp3", 73},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_A2.mp3", 86},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_B1.mp3", 58},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_B2.mp3", 63},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_C.mp3", 68},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_C2.mp3", 87},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_D1.mp3", 65},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_D2.mp3", 83},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_E.mp3", 22},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_F.mp3", 25},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_G.mp3", 15},
				{"Sound\\Music\\Draenor\\MUS_60_Mystic_H.mp3", 134},
			},
		},
		{
			name = L["TITLE_NAGRAND"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Nagrand_v1.mp3", 149},
				{"Sound\\Music\\Draenor\\MUS_60_Nagrand_v2.mp3", 149},
				{"Sound\\Music\\Draenor\\MUS_60_Nagrand_v3A.mp3", 62},
				{"Sound\\Music\\Draenor\\MUS_60_Nagrand_v3B.mp3", 58},
				{"Sound\\Music\\Draenor\\MUS_60_Nagrand_v4.mp3", 87},
				{"Sound\\Music\\Draenor\\MUS_60_Nagrand_v5.mp3", 80},
				{"Sound\\Music\\Draenor\\MUS_60_Nagrand_v6.mp3", 134},
				{"Sound\\Music\\Draenor\\MUS_60_Nagrand_v7.mp3", 89},
			},
		},
		{
			name = L["TITLE_OGREMINES"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_OgreMines_A1.mp3", 130},
				{"Sound\\Music\\Draenor\\MUS_60_OgreMines_A2.mp3", 127},
				{"Sound\\Music\\Draenor\\MUS_60_OgreMines_B.mp3", 133},
				{"Sound\\Music\\Draenor\\MUS_60_OgreMines_H1.mp3", 131},
				{"Sound\\Music\\Draenor\\MUS_60_OgreMines_H2.mp3", 124},
				{"Sound\\Music\\Draenor\\MUS_60_PlightoftheOgres_H1.mp3", 99},
				{"Sound\\Music\\Draenor\\MUS_60_PlightoftheOgres_H2.mp3", 77},
			},
		},
		{
			name = L["TITLE_PATIENCEPOINT"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_PatiencePoint_A1.mp3", 77},
				{"Sound\\Music\\Draenor\\MUS_60_PatiencePoint_A2.mp3", 97},
				{"Sound\\Music\\Draenor\\MUS_60_PatiencePoint_B1.mp3", 77},
				{"Sound\\Music\\Draenor\\MUS_60_PatiencePoint_B2.mp3", 97},
				{"Sound\\Music\\Draenor\\MUS_60_PatiencePoint_H.mp3", 179},
			},
		},
		{
			name = L["TITLE_PROTECTTHETHRONE"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_ProtecttheThrone_H1.mp3", 67},
				{"Sound\\Music\\Draenor\\MUS_60_ProtecttheThrone_H2.mp3", 98},
				{"Sound\\Music\\Draenor\\MUS_60_ProtecttheThrone_H3.mp3", 92},
			},
		},
		{
			name = L["TITLE_QUIETHEART"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_QuietHeart_A.mp3", 224},
				{"Sound\\Music\\Draenor\\MUS_60_QuietHeart_A1.mp3", 109},
				{"Sound\\Music\\Draenor\\MUS_60_QuietHeart_A2.mp3", 116},
				{"Sound\\Music\\Draenor\\MUS_60_QuietHeart_H.mp3", 229},
				{"Sound\\Music\\Draenor\\MUS_60_QuietHeart_H1.mp3", 114},
				{"Sound\\Music\\Draenor\\MUS_60_QuietHeart_H2.mp3", 118},
			},
		},
		{
			name = L["TITLE_SACRIFICE"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Sacrifice_2A.mp3", 89},
				{"Sound\\Music\\Draenor\\MUS_60_Sacrifice_2H.mp3", 88},
				{"Sound\\Music\\Draenor\\MUS_60_Sacrifice_B.mp3", 89},
			},
		},
		{
			name = L["TITLE_SHADOWMOON"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Shadowmoon_v1.mp3", 129},
				{"Sound\\Music\\Draenor\\MUS_60_Shadowmoon_v2.mp3", 127},
				{"Sound\\Music\\Draenor\\MUS_60_Shadowmoon_v3.mp3", 123},
				{"Sound\\Music\\Draenor\\MUS_60_Shadowmoon_v4.mp3", 62},
				{"Sound\\Music\\Draenor\\MUS_60_Shadowmoon_v5.mp3", 95},
				{"Sound\\Music\\Draenor\\MUS_60_ShadowmoonPt1_A.mp3", 110},
				{"Sound\\Music\\Draenor\\MUS_60_ShadowmoonPt1_H.mp3", 138},
				{"Sound\\Music\\Draenor\\MUS_60_ShadowmoonRising_H.mp3", 155},
				{"Sound\\Music\\Draenor\\MUS_60_ShadowmoonSunsetIntro_H.mp3", 70},
				{"Sound\\Music\\Draenor\\MUS_60_ShadowmoonSunsetReprise_H.mp3", 45},
				{"Sound\\Music\\Draenor\\MUS_60_RisetotheDark_H1.mp3", 93},
				{"Sound\\Music\\Draenor\\MUS_60_RisetotheDark_H2.mp3", 124},
				{"Sound\\Music\\Draenor\\MUS_60_Voce_C.mp3", 48},
			},
		},
		{
			name = L["TITLE_SHAKEDOWN"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Shakedown_A.mp3", 103},
				{"Sound\\Music\\Draenor\\MUS_60_Shakedown_B.mp3", 65},
				{"Sound\\Music\\Draenor\\MUS_60_Shakedown_C.mp3", 102},
			},
		},
		{
			name = L["TITLE_SMACKTHEGIANT"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_SmacktheGiant_H1.mp3", 55},
				{"Sound\\Music\\Draenor\\MUS_60_SmacktheGiant_H2.mp3", 53},
				{"Sound\\Music\\Draenor\\MUS_60_SmacktheGiant_H3.mp3", 52},
				{"Sound\\Music\\Draenor\\MUS_60_SmacktheGiant_H4.mp3", 21},
			},
		},
		{
			name = L["TITLE_STORMLORDSMARCH"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_StormlordsontheMarch_H1.mp3", 88},
				{"Sound\\Music\\Draenor\\MUS_60_StormlordsontheMarch_H2.mp3", 46},
				{"Sound\\Music\\Draenor\\MUS_60_StormlordsontheMarch_H3.mp3", 101},
			},
		},
		{
			name = L["TITLE_THECLANSJOIN"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_TheClansJoin_A.mp3", 212},
				{"Sound\\Music\\Draenor\\MUS_60_TheClansJoin_B.mp3", 212},
				{"Sound\\Music\\Draenor\\MUS_60_TheClansJoin_H.mp3", 212},
			},
		},
		{
			name = L["TITLE_TOME"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Tome_A.mp3", 55},
				{"Sound\\Music\\Draenor\\MUS_60_Tome_B.mp3", 55},
				{"Sound\\Music\\Draenor\\MUS_60_Tome_H.mp3", 56},
			},
		},
		{
			name = L["TITLE_TS_HAVE_IT"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_TsHaveIt_A.mp3", 115},
				{"Sound\\Music\\Draenor\\MUS_60_TsHaveIt_B.mp3", 52},
				{"Sound\\Music\\Draenor\\MUS_60_TsHaveIt_H.mp3", 164},
			},
		},
		{
			name = L["TITLE_VILLAGEWOD"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Village_A.mp3", 151},
				{"Sound\\Music\\Draenor\\MUS_60_Village_B.mp3", 91},
				{"Sound\\Music\\Draenor\\MUS_60_Village_C1.mp3", 63},
				{"Sound\\Music\\Draenor\\MUS_60_Village_C2.mp3", 88},
				{"Sound\\Music\\Draenor\\MUS_60_Village_D.mp3", 91},
				{"Sound\\Music\\Draenor\\MUS_60_Village_E.MP3", 9},
				{"Sound\\Music\\Draenor\\MUS_60_Village_F.mp3", 11},
				{"Sound\\Music\\Draenor\\MUS_60_Village_H.mp3", 150},
			},
		},
		{
			name = L["TITLE_VOWSWOD"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Vows_A1.mp3", 55},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_A2.mp3", 49},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_A3.mp3", 101},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_B.mp3", 118},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_C1.mp3", 82},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_C2.mp3", 98},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_C3.mp3", 130},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_D1.mp3", 89},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_D2.mp3", 86},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_H1.mp3", 100},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_H2.mp3", 85},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_H3.mp3", 103},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_H4.mp3", 107},
				{"Sound\\Music\\Draenor\\MUS_60_Vows_H5.mp3", 117},
			},
		},
		{
			name = L["TITLE_WARRIORSJOURNEY"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_A.mp3", 65},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_B1.mp3", 65},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_B2.mp3", 53},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_B3.mp3", 66},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_C.mp3", 17},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_D.mp3", 16},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_E.mp3", 17},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_H1.mp3", 92},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_H2.mp3", 74},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_H3.mp3", 72},
				{"Sound\\Music\\Draenor\\MUS_60_WarriorsJourney_H4.mp3", 79},
			},
		},
		{
			name = L["TITLE_WARSONGWOD"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Warsong_v1.mp3", 153},
				{"Sound\\Music\\Draenor\\MUS_60_Warsong_v2.mp3", 152},
				{"Sound\\Music\\Draenor\\MUS_60_Warsong_v3A.mp3", 84},
				{"Sound\\Music\\Draenor\\MUS_60_Warsong_v3B.mp3", 72},
				{"Sound\\Music\\Draenor\\MUS_60_Warsong_v4.mp3", 156},
			},
		},
		{
			name = L["TITLE_WOLFATTHEGATES"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_WolfattheGates_A.mp3", 162},
				{"Sound\\Music\\Draenor\\MUS_60_WolfattheGates_B.mp3", 162},
				{"Sound\\Music\\Draenor\\MUS_60_WolfattheGates_H.mp3", 162},
			},
		},
		{
			name = L["TITLE_WONDER"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_Wonder_A.mp3", 19},
				{"Sound\\Music\\Draenor\\MUS_60_Wonder_H.mp3", 153},
			},
		},
		{
			name = L["TITLE_WORLDEXPO"],
			files = {
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_A1.mp3", 54},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_A2.mp3", 54},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_A3.mp3", 60},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_B.mp3", 15},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_C.mp3", 22},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_D.mp3", 22},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_E1.mp3", 56},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_E2.mp3", 64},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_F1.mp3", 64},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_F2.mp3", 64},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_F3.mp3", 39},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_G.mp3", 19},
				{"Sound\\Music\\Draenor\\MUS_60_WorldExpo_H.mp3", 169},
			},
		},
	},
	
	-- Warcraft III
	i7events = {
		{
			name = L["TITLE_POWEROTHORDE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\DMF_L70ETC01.mp3", 282},
			},
		},
		{
			name = L["TITLE_FIREFESTIVAL"],
			files = {
				{"Sound\\Music\\WorldEvents\\AllianceFirepole.mp3", 68},
			},
		},
		{
			name = L["TITLE_ARGENTTOURNY"],
			files = {
				{"Sound\\Music\\ZoneMusic\\ArgentTournament\\AT_JoustEvent.mp3", 123},
			},
		},
		{
			name = L["TITLE_TAVERN_ALLIANCE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\TavernAlliance\\TavernAlliance01.mp3", 47},
				{"Sound\\Music\\ZoneMusic\\TavernAlliance\\TavernAlliance02.mp3", 51},
				{"Sound\\Music\\ZoneMusic\\TavernHuman\\RA_HumanTavern1A.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\TavernHuman\\RA_HumanTavern1B.mp3", 79},
				{"Sound\\Music\\ZoneMusic\\TavernHuman\\RA_HumanTavern2A.mp3", 86},
				{"Sound\\Music\\ZoneMusic\\TavernHuman\\RA_HumanTavern2B.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\TavernHuman\\RA_Tavern1_RevisitedA.mp3", 70},
				{"Sound\\Music\\ZoneMusic\\TavernHuman\\RA_Tavern1_RevisitedB.mp3", 72},
				{"Sound\\Music\\ZoneMusic\\TavernDwarf\\RA_DwarfTavern1A.mp3", 79},
				{"Sound\\Music\\ZoneMusic\\TavernDwarf\\RA_DwarfTavern1B.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\TavernDwarf\\RA_DwarfTavern2A.mp3", 86},
				{"Sound\\Music\\ZoneMusic\\TavernDwarf\\RA_DwarfTavern2B.mp3", 92},
				{"Sound\\Music\\ZoneMusic\\TavernDwarf\\RA_DwarfTavern3.mp3", 102},
				{"Sound\\Music\\ZoneMusic\\TavernNightElf\\RA_TempleOfTheMoonA.mp3", 112},
				{"Sound\\Music\\ZoneMusic\\TavernNightElf\\RA_TempleOfTheMoonB.mp3", 119},
			},
		},
		{
			name = L["TITLE_TAVERN_HORDE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\TavernHorde\\TavernHorde01.mp3", 48},
				{"Sound\\Music\\ZoneMusic\\TavernHorde\\TavernHorde02.mp3", 39},
				{"Sound\\Music\\ZoneMusic\\TavernHorde\\TavernHorde03.mp3", 47},
				{"Sound\\Music\\ZoneMusic\\TavernOrc\\RA_OrcRestArea1A.mp3", 100},
				{"Sound\\Music\\ZoneMusic\\TavernOrc\\RA_OrcRestArea1B.mp3", 91},
				{"Sound\\Music\\ZoneMusic\\TavernOrc\\RA_OrcRestArea2A.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\TavernOrc\\RA_OrcRestArea2B.mp3", 86},
				{"Sound\\Music\\ZoneMusic\\TavernOrc\\RA_OrcRestArea3A.mp3", 86},
				{"Sound\\Music\\ZoneMusic\\TavernOrc\\RA_OrcRestArea3B.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\TavernHorde\\undead_dance.mp3", 25},
				{"Sound\\Music\\ZoneMusic\\TavernUndead\\RA_UndeadTavern1A.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\TavernUndead\\RA_UndeadTavern1B.mp3", 87},
				{"Sound\\Music\\ZoneMusic\\TavernUndead\\RA_UndeadTavern2.mp3", 124},
				{"Sound\\Music\\ZoneMusic\\TavernUndead\\RA_UndeadTavern3A.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\TavernUndead\\RA_UndeadTavern3B.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\TavernTauren\\RA_TaurenRestArea1A.mp3", 89},
				{"Sound\\Music\\ZoneMusic\\TavernTauren\\RA_TaurenRestArea1B.mp3", 96},
				{"Sound\\Music\\ZoneMusic\\TavernTauren\\RA_TaurenRestArea2A.mp3", 85},
				{"Sound\\Music\\ZoneMusic\\TavernTauren\\RA_TaurenRestArea2B.mp3", 80},
				{"Sound\\Music\\ZoneMusic\\TavernTauren\\RA_TaurenRestArea3A.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\TavernTauren\\RA_TaurenRestArea3B.mp3", 93},
			},
		},
		{
			name = L["TITLE_TAVERN_PIRATE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\TavernPirate\\RA_PirateTavern1A.mp3", 83},
				{"Sound\\Music\\ZoneMusic\\TavernPirate\\RA_PirateTavern1B.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\TavernPirate\\RA_PirateTavern2A.mp3", 82},
				{"Sound\\Music\\ZoneMusic\\TavernPirate\\RA_PirateTavern2B.mp3", 81},
				{"Sound\\Music\\ZoneMusic\\TavernPirate\\RA_PirateTavern3A.mp3", 88},
				{"Sound\\Music\\ZoneMusic\\TavernPirate\\RA_PirateTavern3B.mp3", 85},
			},
		},
		{
			name = L["TITLE_BREWFEST_ALLIANCE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Brewfest\\BF_Dwarves1.mp3", 94},
				{"Sound\\Music\\ZoneMusic\\Brewfest\\BF_Dwarves2.mp3", 115},
				{"Sound\\Music\\ZoneMusic\\Brewfest\\BF_Dwarves3.mp3", 23},
			},
		},
		{
			name = L["TITLE_BREWFEST_HORDE"],
			files = {
				{"Sound\\Music\\ZoneMusic\\Brewfest\\BF_Goblins1.mp3", 67},
				{"Sound\\Music\\ZoneMusic\\Brewfest\\BF_Goblins2.mp3", 93},
				{"Sound\\Music\\ZoneMusic\\Brewfest\\BF_Goblins3.mp3", 28},
			},
		},
		{
			name = L["TITLE_DARKMOON_FESTIVAL"],
			files = {
				{"Sound\\Music\\WorldEvents\\DarkMoonFaire_1.mp3", 28},
				{"Sound\\Music\\WorldEvents\\DarkMoonFaire_2.mp3", 74},
				{"Sound\\Music\\WorldEvents\\DarkMoonFaire_3.mp3", 58},
				{"Sound\\Music\\WorldEvents\\DarkMoonFaire_4.mp3", 37},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_43_DarkmoonFaireA_Hero_UU01.mp3", 61},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_43_DarkmoonFaireA_UU01.mp3", 59},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_43_DarkmoonFaireB_Hero_UU01.mp3", 71},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_43_DarkmoonFaireB_UU01.mp3", 97},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_43_DarkmoonFaireB_UU02.mp3", 89},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_43_DarkmoonFaireC_UU02.mp3", 172},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_43_DarkmoonFaireD_UU01.mp3", 86},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_43_DarkmoonFaireD_UU02.mp3", 106},
				{"Sound\\Music\\ZoneMusic\\DarkmoonFaire\\MUS_51_DarkmoonFaire_MerryGoRound_01.mp3", 180},
			},
		},
	},
}

local GJB = LibStub("AceAddon-3.0"):GetAddon("GarrisonJukeBox")
if not GJB then return end
GJB:SetMusicTable(musictable)
